/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include "streams.h"
#include "parse.h"
#include "room.h"

// flush room output
bool
RoomStreamSink::stream_end (void) {
	// send output
	if (buffer) {
		if (ignores.empty())
			room.put(buffer, buffer.size());
		else
			room.put(buffer, buffer.size(), &ignores);
		buffer.clear();
	}
	// yes, delete this sink
	return true;
}

StreamParse&
StreamParse::add (StringArg s_name, const Scriptix::Value* s_value)
{
	ParseValue vinfo;
	vinfo.value = s_value;
	vinfo.name = s_name;
	vlist.push_back(vinfo);
	return *this;
}

StreamParse&
StreamParse::add (const Scriptix::Value* s_value)
{
	ParseValue vinfo;
	vinfo.value = s_value;
	vlist.push_back(vinfo);
	return *this;
}
