/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include "ptitle.h"
#include "fileobj.h"
#include "settings.h"

PlayerTitle::PlayerTitle (void) : name(), male_prefix(), female_prefix(), neuter_prefix()
{
}

SPlayerTitleManager::SPlayerTitleManager (void)
{
}

SPlayerTitleManager::~SPlayerTitleManager (void)
{
}

// load player titles
int
SPlayerTitleManager::initialize (void)
{
	Log::Info << "Loading player titles";

	File::Reader reader(settings::get_path ("misc", "data") + "/titles");

	// open failed
	if (!reader.is_open())
		return -1;

	// read title
	File::Node node;
	FO_READ_BEGIN
		FO_OBJECT("title")
			PlayerTitle title;
			title.name = node.get_name();
			// load the title's data
			FO_READ_BEGIN
				FO_ATTR_TYPENAME("male", "prefix")
					title.male_prefix = node.get_data();
				FO_ATTR_TYPENAME("female", "prefix")
					title.female_prefix = node.get_data();
				FO_ATTR_TYPENAME("neuter", "prefix")
					title.neuter_prefix = node.get_data();
			FO_READ_ERROR
				return -1;
			FO_READ_END
			// add title
			titles.push_back(title);
	FO_READ_ERROR
		return -1;
	FO_READ_END

	return 0;
}

// clean up player title list
void
SPlayerTitleManager::shutdown (void)
{
	titles.resize(0);
}

// find the named player title
const PlayerTitle*
SPlayerTitleManager::get_title (StringArg name)
{
	for (TitleList::iterator i = titles.begin(); i != titles.end(); ++i)
		if (i->name == name)
			return &(*i);
	return NULL;
}
