/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include "pdesc.h"
#include "awestr.h"

StringList ColorType::names;

String HairStyleType::names[] = {
	"shaved",
	"long",
	"short",
	"flowing",
	"bun",
	"curled",
	"ponytail",
	"spiked",
};
String HairStyleType::descs[] = {
	"a shaved head",
	"long {.haircolor} hair",
	"short {.haircolor} hair",
	"flowing {.haircolor} hair",
	"{.haircolor} hair put back in a bun",
	"curly {.haircolor} locks",
	"{.haircolor} hair pulled back into a ponytail",
	"spiked {.haircolor} hair",
};

String BodyBuildType::names[] = {
	"lean",
	"slim",
	"broad",
	"stocky",
	"large",
	"hunched",
};

ColorType
ColorType::lookup (StringArg name)
{
	for (uint i = 0; i < names.size(); ++i)
		if (str_eq(name, names[i]))
			return i + 1;
	names.push_back(name);
	names.back().lower();
	return names.size();
}

HairStyleType
HairStyleType::lookup (StringArg name)
{
	for (uint i = 0; i < COUNT; ++i)
		if (str_eq(name, names[i]))
			return i;
	return SHAVED;
}

BodyBuildType
BodyBuildType::lookup (StringArg name)
{
	for (uint i = 0; i < COUNT; ++i)
		if (str_eq(name, names[i]))
			return i;
	return LEAN;
}
