/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include <gc/gc.h>

#include <stdio.h>

#include "error.h"
#include "server.h"
#include "awestr.h"
#include "parse.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int
main (int argc, char **argv)
{
	/* print out information */
	printf ("AweMUD server V%s\nCopyright (C) 2000-2004, AwesomePlay Productions, Inc.\n", VERSION);
	printf ("AweMUD comes with ABSOLUTELY NO WARRANTY; for details see the file COPYING.\n");
	printf ("This is free software, and you are welcome to redistribute it\n"
		"under certain conditions; for details see the file COPYING.\n");

	int success = 1;

	// GC
	GC_INIT();
#if defined(NDEBUG)
	GC_enable_incremental();
#endif

	/* init server */
	if (server.init (argc, argv)) {
		// error code
		return 1;
	}
	success = server.run ();

	return success;
}
