/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <time.h>
#include <errno.h>

#include "log.h"
#include "error.h"
#include "awestr.h"
#include "server.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// hacky error/message/warnign wrappers

namespace Log {
	LogWrapper Error("Error", LOG_ERROR);
	LogWrapper Warning("Warning", LOG_ERROR);
	LogWrapper Info("", 0);

	bool
	LogWrapper::stream_end (void)
	{
		char tbuf[41];
		time_t t;
		time (&t);

		strftime (tbuf, sizeof(tbuf) - 1, "%Y-%m-%d %T", localtime (&t));

		String out = tbuf;
		out += " - ";
		if (pre) {
			out += "** " + pre + ": " + msg + " **\n";
		} else {
			out += msg + "\n";
		}

		server.log_msg (level, out);

		msg.clear();
		return false;
	}
}

LogFile::LogFile (StringArg filename)
{
	assert (!filename.empty());

	if ((f = fopen (filename, "a")) == NULL) {
		Log::Warning << "Unable to open log file " << filename << ": " << strerror(errno);
		f = stdout;
	}
	file = filename;

	print (0, "<--- AweMUD V" VERSION " --->\n");
}

LogFile::LogFile (FILE *nf, StringArg filename)
{
	f = nf;
	file = filename;

	print (0, "<--- AweMUD V" VERSION " --->\n");
}

LogFile::~LogFile (void)
{
	if (f != NULL)
		fclose (f);
}

void
LogFile::print (int type, StringArg text)
{
	if (!text)
		return;

	if (f != NULL) {
		fprintf(f, "%s", text.c_str());
		fflush(f);
	} else {
		printf("%s", text.c_str());
	}
}

void
LogFile::reset (void)
{
	if (f != NULL) {
		fclose (f);
		f = fopen (file, "a+");
		if (f == NULL)
			Log::Warning << "Failed to re-load LogFile " << file << ": " << strerror(errno);
	}
}
