/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include <stdio.h>

#include "gcbase.h"

namespace GCType {
	Collectable::Collectable(void)
	{
		// register us if we're a GC allocated object
		void* base = GC_base((void*)this);
		if (base != NULL)
			GC_register_finalizer_no_order(base, (GC_finalization_proc)GCType::Collectable::cleanup, (void*)((char*)this - (char*)base), NULL, NULL);
	}

	void
	Collectable::cleanup(void* base, void* diff)
	{
		// call finalizer - yay finalizer...
		//printf("FREE: %s  (%p)\n", typeid(*(Collectable*)((char*)base + (ptrdiff_t)diff)).name(), base);
		((Collectable*)((char*)base + (ptrdiff_t)diff))->~Collectable();
	}
}
