/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include <stdlib.h>
#include <stdio.h>

#include <sstream>

#include "action.h"
#include "object.h"
#include "scripts.h"

Action::~Action(void) {}

void
Action::save (File::Writer& writer) const
{
	AttributeHolder::save(writer);

	for (ScriptMap::const_iterator iter = scripts.begin(); iter != scripts.end(); ++iter)
		writer.block("script", iter->first, iter->second.source);
}

int
Action::load (File::Reader& reader)
{
	File::Node node;

	FO_READ_BEGIN
		FO_ATTR_TYPE("script")
			ActionScript ascript;
			if (!node.get_name()) {
				Log::Error << "Action '" << name << "' has script with no name";
				throw File::Error("invalid action");
			}

			ascript.source = node.get_data();
			ascript.func = Scripts.compile(ascript.source, "action,self,user,data", reader.get_filename(), node.get_line());

			// add to list
			scripts[node.get_name()] = ascript;
		// try attributes
		FO_ATTR_TYPE("int")
			int value;
			FO_GET_INT(value);
			set_int(node.get_name(), value);
		FO_ATTR_TYPE("string")
			set_string(node.get_name(), node.get_data());
	FO_READ_ERROR
		return -1;
	FO_READ_END

	return 0;
}

bool
Action::check (Object* self, Entity* user, Scriptix::Value* data)
{
	ScriptMap::iterator i = scripts.find("test");
	if (i != scripts.end()) {
		Scriptix::Value* retval;
		Scripts.run(i->second.func, this, self, user, data, &retval);
		return Scriptix::Value::True(Scripts.get_engine(), retval);
	}
	return true;
}

void
Action::invoke (StringArg name, Object* self, Entity* user, Scriptix::Value* data, Scriptix::Value** retval)
{
	ScriptMap::iterator i = scripts.find(name);
	if (i != scripts.end()) {
		Scripts.run(i->second.func, this, self, user, data, retval);
	}
}
