/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef WEATHER_H
#define WEATHER_H

#include "fileobj.h"
#include "awestr.h"

// a stage of weather, such as 'light rain'
struct WeatherStage {
	String down;
	String up;
	String desc;

	WeatherStage (void) : down(), up(), desc() {}
		
	int load (File::Reader& reader);
	void save (File::Writer& writer) const;
};

// description of a change in the weather, such as 'the rain starts falling more heavily'
struct WeatherChange {
	String pattern;
	String desc;

	WeatherChange (StringArg s_pattern) : pattern(s_pattern), desc() {}
};

// a single pattern, such as 'snow' or 'rain'
struct WeatherPattern {
	String title;
	int chance; /* percent */
	std::vector<WeatherStage> stages;
	std::vector<WeatherChange> changes;

	WeatherPattern (StringArg s_title) : title(s_title),
		chance(0), stages(), changes() {}
		
	int load (File::Reader& reader);
	void save (File::Writer& writer) const;
};

// a single region of the world and its weather patterns
class WeatherRegion {
	protected:
	std::vector<WeatherPattern> patterns;
	uint cur_pattern;
	uint cur_stage;
	uint ticks;

	int get_pattern (StringArg name) const;

	public:
	WeatherRegion (void) : patterns(), cur_pattern(0), cur_stage(0), ticks(0) {}

	int load (File::Reader& reader);
	void save (File::Writer& writer) const;

	int load (void);
	int save (void) const;

	StringArg get_cur (void) const { return patterns[cur_pattern].stages[cur_stage].desc; }

	void update (void);
};

// manage all regions
// FIXME: we should actually *have* multiple regions... ^^;
class SWeatherManager : public IManager
{
	public:
	// initialize the manager
	virtual int initialize (void);

	// close everything down
	virtual void shutdown (void);

	// save the weather region states
	inline int save (void) { return region.save(); }

	// update the manager (once per tick)
	inline void update (void) { region.update(); }

	// get current weather description
	inline StringArg get_current_desc (void) const { return region.get_cur(); }

	private:
	WeatherRegion region;
};
extern SWeatherManager WeatherManager;

#endif
