/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <vector>

#include "awestr.h"

class inifile
{
	struct setting
	{
		String name;
		String value;
	};
	struct section
	{
		String name;
		std::vector<setting> settings;
	};

	public:
	inifile (void) {}
	inifile (StringArg file) { load (file); }

	typedef std::vector<section> slist;
	slist sections;

	int load (StringArg file);

	void set (const char *sect, const char *name, const char *value);
	const char *get (const char *sect, const char *name) const;
};

namespace settings
{
	int init (const char *file);
	void close (void);

	const char *get_str (const char *section, const char *name);
	int get_int (const char *section, const char *name);
	bool get_bool (const char *section, const char *name);
	String get_path (const char *name, const char* def);
}

#endif
