/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef MAP_H
#define MAP_H

#include "object.h"
#include "char.h"
#include "awestr.h"
#include "exit.h"

// Room, the general type
class Room : public Entity
{
	public:
	// nasty public stuff
	EList<Object> objects;
	EList<Character> chars;
	EList<RoomExit> exits;

	Room (void);

	// outdoors
	bool is_outdoors (void) const { return flags.outdoors; }
	void set_outdoors (bool v) { flags.outdoors = v; }

	// safe (no combat/attacks)
	bool is_safe (void) const { return flags.safe; }
	void set_safe (bool v) { flags.safe = v; }

	// no weather notices in room descriptions (but does get global weather changes)
	bool is_noweather (void) const { return flags.noweather; }
	void set_noweather (bool v) { flags.noweather = v; }

	// exits
	RoomExit* get_exit_at (uint);
	RoomExit* get_exit_by_id (exit_id);
	RoomExit* get_exit_by_dir (ExitDir);
	RoomExit* find_exit (const char *, uint c = 1, uint *matches = NULL);
	RoomExit* new_exit (void); //  will pick a unique ID, return exit
	void sort_exits (void); // re-sort exits; FIXME: this is ugly to have to do manually

	// parent
	class Zone* get_zone (void) const { return parent_zone; }

	// identifier
	StringArg get_id (void) const { return id; }
	void set_id (StringArg new_id) { id = new_id; }

	// colour type
	virtual const char* ncolor (void) const { return CTITLE; }

	// desc, short version
	StringArg get_short_desc (void) const { return short_desc; }
	void set_short_desc (StringArg new_short_desc) { short_desc = new_short_desc; }

	// io
	virtual void save (File::Writer& writer) const;
	virtual int load_node(File::Reader& reader, File::Node& node);
	virtual int load_finish (void);

	// update
	void update (void);

	// (de)activate children
	virtual void activate (void);
	virtual void deactivate (void);

	// remove from zone
	virtual void release (void);

	// display
	void show (const class StreamControl& stream, Character* viewer, bool shortd = false);
	void show_exits (const class StreamControl& stream);

	// output
	void put (const char* text, size_t len, GCType::vector<Character*>* ignore = NULL);
	void builder (StringArg text);

	// get entities
	class Character* find_character (const char *name, uint c = 1, uint *matches = NULL);
	Object* find_object (const char *name, uint c = 1, uint *matches = NULL);

	// count tagged entities
	size_t count_tags(StringArg tag) const;

	// add entities
	void add_object (Object* object);
	void add_character (Character* character);

	// coins on the floor
	inline uint get_coins (void) const { return coins; }
	uint take_coins (uint amount);
	uint give_coins (uint amount);

	// handle events - propogate
	virtual int handle_event (Event* event);

	// we are our own room... and darnit, this can't be const!
	virtual inline Room* get_room (void) const { return const_cast<Room*>(this); }

	protected:
	String id;
	String short_desc;
	class Zone* parent_zone;
	uint coins;
	Room* next; //  for list of rooms in world
	struct RoomFlags {
		char outdoors:1, safe:1, noweather:1;
	} flags;

	protected:
	~Room (void);

	SX_TYPEDEF
	E_TYPE(Room)
	
	friend class Zone;
	friend class SZoneManager;
};

#define ROOM(ent) E_CAST(ent,Room)

#endif
