/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef PTITLE_H
#define PTITLE_H

#include "awestr.h"
#include "server.h"

class PlayerTitle
{
	public:
	PlayerTitle (void);

	StringArg get_name (void) const { return name; }

	StringArg get_male_prefix (void) const { return male_prefix; }
	StringArg get_female_prefix (void) const { return female_prefix; }
	StringArg get_neuter_prefix (void) const { return neuter_prefix; }

	private:
	String name;
	String male_prefix;
	String female_prefix;
	String neuter_prefix;

	// to do loading
	friend class SPlayerTitleManager;
};

class SPlayerTitleManager : public IManager
{
	public:
	SPlayerTitleManager (void);
	~SPlayerTitleManager (void);

	// load up titles
	virtual int initialize (void);

	// clean up titles
	virtual void shutdown (void);

	// find a specific title
	const PlayerTitle* get_title (StringArg name);

	private:
	typedef std::vector<PlayerTitle> TitleList;
	TitleList titles;
};

extern SPlayerTitleManager PlayerTitleManager;

#endif
