/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef PARSE_H
#define PARSE_H

#include <vector>

#include "gcbase.h"
#include "scripts.h"
#include "streams.h"

class Character;

struct ParseValue {
	String name;
	const Scriptix::Value* value;
};
typedef GCType::vector<ParseValue> ParseValueList;

namespace parse {
	const StreamControl& text (const StreamControl& stream, const char *format, const ParseValueList&);
	const char *prompt (const char *format, const class Character *ch);
}

// parse info
struct StreamParse {
	StreamParse(StringArg s_text) :
		text(s_text), vlist() {}
	StreamParse(StringArg s_text, const Scriptix::Value* s_value) :
		text(s_text), vlist(1) { vlist[0].value = s_value; }
	StreamParse(StringArg s_text, const Scriptix::Value* s_value1, const Scriptix::Value* s_value2) :
		text(s_text), vlist(2) { vlist[0].value = s_value1; vlist[1].value = s_value2; }
	StreamParse(StringArg s_text, const Scriptix::Value* s_value1, const Scriptix::Value* s_value2, const Scriptix::Value* s_value3) :
		text(s_text), vlist(3) { vlist[0].value = s_value1; vlist[1].value = s_value2; vlist[2].value = s_value3; }
	StreamParse(StringArg s_text, StringArg s_name, const Scriptix::Value* s_value) :
		text(s_text), vlist(1) { vlist[0].name = s_name; vlist[0].value = s_value; }
	StreamParse(StringArg s_text, StringArg s_name1, const Scriptix::Value* s_value1, StringArg s_name2, const Scriptix::Value* s_value2) :
		text(s_text), vlist(2) { vlist[0].name = s_name1; vlist[0].value = s_value1; vlist[1].name = s_name2; vlist[1].value = s_value2; }
	StreamParse(StringArg s_text, StringArg s_name1, const Scriptix::Value* s_value1, StringArg s_name2, const Scriptix::Value* s_value2, StringArg s_name3, const Scriptix::Value* s_value3) :
		text(s_text), vlist(3) { vlist[0].name = s_name1; vlist[0].value = s_value1; vlist[1].name = s_name2; vlist[1].value = s_value2; vlist[2].name = s_name3; vlist[2].value = s_value3; }

	StreamParse& add (StringArg s_name, const Scriptix::Value* s_value);
	StreamParse& add (const Scriptix::Value* s_value);

	friend inline
	const StreamControl&
	operator << (const StreamControl& stream, const StreamParse& sparse)
	{
		return parse::text(stream, sparse.text, sparse.vlist);
	}

	private:
	String text;
	ParseValueList vlist;
};

#endif
