/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef OBJCLASS_H
#define OBJCLASS_H

#include "awestr.h"
#include "gcbase.h"

// Object classes (jewelry, swords, etc.)
class ObjectClass : public GCType::Collectable {
	public:
	inline ObjectClass (StringArg s_name, ObjectClass* s_parent) :
		name(s_name), parent(s_parent) {}

	StringArg get_name (void) const { return name; }
	ObjectClass* get_parent (void) const { return parent; }

	protected:
	String name;
	ObjectClass* parent;
};

class SObjectClassManager : public IManager
{
	public:
	inline SObjectClassManager (void) : classes() {}

	// start the manager
	virtual int initialize (void);

	// finish off the manager
	inline virtual void shutdown (void) { classes.clear(); }

	// get a class
	ObjectClass* lookup (StringArg name);

	protected:
	typedef GCType::map<String, ObjectClass*> ClassMap;
	ClassMap classes;
};
extern SObjectClassManager ObjectClassManager;

#endif
