/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef CLASS_H
#define CLASS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "awestr.h"
#include "rand.h"
#include "scripts.h"
#include "fileobj.h"
#include "char.h"
#include "server.h"

class Class : public Scriptable
{
	public:
	// this is an ugly hack, but it lets us construct the linked
	// list as we need to do
	Class (const std::string& s_name, Class *s_next) : Scriptable(AweMUD_PlayerClassType), name(s_name.c_str()) { next = s_next; }

	StringArg get_name (void) const { return name; }

	int get_pri_exp_type (void) const { return pri_exp_type; }
	int get_sec_exp_type (void) const { return sec_exp_type; }
	int get_diff_mod (void) const { return diff_mod; }
	int get_hp_roll (void) const { return get_random (max_hp - min_hp) + min_hp; }
	int get_combat_mod (void) const { return combat_mod; }
	int get_stat_min (int i) const { if (i >= 0 && i < CharStatID::COUNT) return stats[i] ; else return 0; }

	StringArg get_about (void) const { return about; }

	int load (File::Reader& reader);

	Class *get_next (void) const { return next; }

	// --- Data ---
	protected:
	String name;
	String about;
	int pri_exp_type;
	int sec_exp_type;
	int diff_mod;
	int min_hp, max_hp;
	int combat_mod;

	Class *next;

	int stats[CharStatID::COUNT];
	
	SX_TYPEDEF
};

class SClassManager : public IManager
{
	public:
	inline SClassManager (void) : head(NULL) {}

	int initialize (void);

	void shutdown (void);

	Class* get (StringArg name);

	inline Class* first (void) { return head; }

	private:
	Class *head;
};
extern SClassManager ClassManager;

#endif
