/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef AWE_STRING_H
#define AWE_STRING_H

#include <string.h>
#include <strings.h>
#include <stdarg.h>
#include <string>

#include <vector>

// namespace trick for Scriptix stuff
namespace AweMUD {

	/* hold a C++-style string in a less braind-dead way*/
	class String : public std::string
	{
		public:
		inline String (void) : std::string() {}
		inline String (const String& str) : std::string(str) {}
		inline String (const std::string& str) : std::string(str) {}
		inline String (const char* str) : std::string() { if (str != NULL) std::string::operator=(str); }
		inline String (const std::string& str, size_t len) : std::string(str, len) {}
		inline String (const char* str, size_t len) : std::string() { append(str, len); }
		
		// copy operator
		inline String& operator = (const std::string &str) { std::string::operator=(str); return *this; }
		inline String& operator = (const String &str) { std::string::operator=(str); return *this; }
		inline String& operator = (const char* str) { if (str == NULL) clear(); else std::string::operator=(str); return *this; }

		// test operator
		inline operator bool (void) const { return !empty(); }
		// auto convert to c string
		inline operator const char * (void) const { return c_str(); }

		// use std::string indexers
		inline char& operator[] (int index) { return std::string::operator[](index); }
		inline char operator[] (int index) const { return std::string::operator[](index); }

		// various magic
		long tolong (void) const;
		String& strip (void);
		String& upper (void);
		String& lower (void);

		// for 'iterator' - bleh
		inline const char *get(void) const { return c_str(); }

		// wrappers (argh!)
		inline String& append (const char* str, int len) { if(str != NULL) std::string::append(str, len); return *this; }
	};

	typedef const String& StringArg;

	typedef std::vector<String> StringList;

} // namespace AweMUD
using namespace AweMUD;

#include "types.h"

#define isvowel (ch) ((ch) == 'a' || (ch) == 'e' || (ch) == 'i' || (ch) == 'o' || (ch) == 'u' || (ch) == 'y')

// return suffix of number, like 1=>st, 2=>nd, etc.
const char *get_num_suffix (uint);

// conversion functions
String tostr (long num);
inline long tolong (StringArg str) { return str.tolong(); }

// format check functions
bool str_is_number (StringArg); // is a numeric value
bool str_is_email (StringArg); // checks for semi-valid name@host.domain
bool str_is_true (StringArg); // string is a "true" value

// various funcs
bool str_eq (const char *, const char *, size_t len = 0); // are strings equal, ignoring case - true if equal, len is max length or 0 for full

// match words in a phrase
// string to match is first, string being tested is second
// i.e., phrase_match("bob", str) will see if str is all of or
// part of "bob"
int phrase_match (const char *full, const char *chunk);

// determine a numeric value from input word, i.e. first=>1, second=>2, etc.
uint str_value (StringArg);

// string list building/parsing
StringList& explode(StringList& out, StringArg string, char ch);
String& implode(String& out, const StringList& list, char ch);
String& capwords(String& out, StringArg string);
// and 'easy' versions there-of
inline StringList explode(StringArg string, char ch) { StringList tmp; return explode(tmp, string, ch); }
inline String implode(const StringList& list, char ch) { String tmp; return implode(tmp, list, ch); }
inline String capwords(StringArg string) { String tmp; return capwords(tmp, string); }

// search text lists
int get_index_of (const char** list, StringArg word, int start = -1);

// return true if string is true-value, false otherwise (AVOID USAGE - deprecated)
bool get_true_false (StringArg);

#endif
