/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef AI_H
#define AI_H

#include "awestr.h"
#include "scripts.h"
#include "server.h"

class Event;
class Entity;

class AIState : public GCType::Collectable
{
	public:
	AIState (StringArg s_name) : name (s_name), events(), heartbeat(NULL), round(NULL) {}

	StringArg get_name (void) const { return name; }

	// various actions
	void do_start (Entity* self) const;
	void do_leave (Entity* self) const;
	void do_event (Entity* self, Event* event) const;
	void do_round (Entity* self) const;
	void do_heartbeat (Entity* self) const;

	private:
	String name;
	typedef GCType::map<EventID, Scriptix::Function*> EventList;
	EventList events;
	Scriptix::Function* heartbeat;
	Scriptix::Function* round;
	Scriptix::Function* start;
	Scriptix::Function* leave;

	friend class AI;
};

class AI : public GCType::Collectable
{
	public:
	AI (StringArg s_name);

	int load (File::Reader& reader);

	AIState* get_state (StringArg name)
	{ GCType::map<String, AIState*>::iterator i = states.find(name);
	  if (i != states.end()) return i->second; else return NULL; }

	void do_load (Entity* self) const;

	StringArg get_name (void) const { return name; }

	// data
	protected:
	AI* next;
	String name;
	Scriptix::Function* loadf;
	typedef GCType::map<String, AIState*> StateList;
	StateList states;

	friend class SAIManager;
};

class SAIManager : public IManager
{
	public:
	SAIManager (void) : head(NULL) {}

	virtual int initialize (void);
	virtual void shutdown (void);
	inline virtual void update (void) {}

	void add (AI* ai);
	AI* get (StringArg name);

	private:
	AI* head;
	
};
extern SAIManager AIManager;

#endif
