/*
 *	avarice - The "avarice" program.
 *	Copyright (C) 2003, 2004 James Harris
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License Version 2
 *      as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * This file contains IO Register definitions for use with avr-gdb's 'info
 * io_register' command.
 *
 * $Id: ioreg.cc 307 2012-11-05 16:11:05Z joerg_wunsch $
 */

#include "ioreg.h"

gdb_io_reg_def_type atmega16_io_registers[] =
{
    { "TWBR",    0x20, 0x00 },
    { "TWSR",    0x21, 0x00 },
    { "TWAR",    0x22, 0x00 },
    { "TWDR",    0x23, 0x00 },
    { "ADCL",    0x24, IO_REG_RSE }, // Reading during a conversion corrupts
    { "ADCH",    0x25, IO_REG_RSE }, // ADC result
    { "ADCSRA",  0x26, 0x00 },
    { "ADMUX",   0x27, 0x00 },
    { "ACSR",    0x28, 0x00 },
    { "UBRRL",   0x29, 0x00 },
    { "UCSRB",   0x2A, 0x00 },
    { "UCSRA",   0x2B, 0x00 },
    { "UDR",     0x2C, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "SPCR",    0x2D, 0x00 },
    { "SPSR",    0x2E, 0x00 },
    { "SPDR",    0x2F, 0x00 },
    { "PIND",    0x30, 0x00 },
    { "DDRD",    0x31, 0x00 },
    { "PORTD",   0x32, 0x00 },
    { "PINC",    0x33, 0x00 },
    { "DDRC",    0x34, 0x00 },
    { "PORTC",   0x35, 0x00 },
    { "PINB",    0x36, 0x00 },
    { "DDRB",    0x37, 0x00 },
    { "PORTB",   0x38, 0x00 },
    { "PINA",    0x39, 0x00 },
    { "DDRA",    0x3A, 0x00 },
    { "PORTA",   0x3B, 0x00 },
    { "EECR",    0x3C, 0x00 },
    { "EEDR",    0x3D, 0x00 },
    { "EEARL",   0x3E, 0x00 },
    { "EEARH",   0x3F, 0x00 },
    { "UCSRC -- UBRRH",   0x40, 0x00 },
    { "WDTCR",   0x41, 0x00 },
    { "ASSR",    0x42, 0x00 },
    { "OCR2",    0x43, 0x00 },
    { "TCNT2",   0x44, 0x00 },
    { "TCCR2",   0x45, 0x00 },
    { "ICR1L",   0x46, 0x00 },
    { "ICR1H",   0x47, 0x00 },
    { "OCR1BL",  0x48, 0x00 },
    { "OCR1BH",  0x49, 0x00 },
    { "OCR1AL",  0x4A, 0x00 },
    { "OCR1AH",  0x4B, 0x00 },
    { "TCNT1L",  0x4C, 0x00 },
    { "TCNT1H",  0x4D, 0x00 },
    { "TCCR1B",  0x4E, 0x00 },
    { "TCCR1A",  0x4F, 0x00 },
    { "SFIOR",   0x50, 0x00 },
    { "OCDR -- OSCCAL",    0x51, 0x00 },
    { "TCNT0",   0x52, 0x00 },
    { "TCCR0",   0x53, 0x00 },
    { "MCUCSR",  0x54, 0x00 },
    { "MCUCR",   0x55, 0x00 },
    { "TWCR",    0x56, 0x00 },
    { "SPMCR",   0x57, 0x00 },
    { "TIFR",    0x58, 0x00 },
    { "TIMSK",   0x59, 0x00 },
    { "GIFR",    0x5A, 0x00 },
    { "GICR",    0x5B, 0x00 },
    { "OCR0",    0x5C, 0x00 },
    { "SPL",     0x5D, 0x00 },
    { "SPH",     0x5E, 0x00 },
    { "SREG",    0x5F, 0x00 },
    { 0, 0, 0 }
};

gdb_io_reg_def_type atmega162_io_registers[] =
{
    { "UBRR1L",  0x20, 0x00 },
    { "UCSR1B",  0x21, 0x00 },
    { "UCSR1A",  0x22, 0x00 },
    { "UDR1",    0x23, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "OCDR -- OSCCAL",  0x24, 0x00 },
    { "PINE",    0x25, 0x00 },
    { "DDRE",    0x26, 0x00 },
    { "PORTE",   0x27, 0x00 },
    { "ACSR",    0x28, 0x00 },
    { "UBRR0L",  0x29, 0x00 },
    { "UCSR0B",  0x2A, 0x00 },
    { "UCSR0A",  0x2B, 0x00 },
    { "UDR0",    0x2C, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "SPCR",    0x2D, 0x00 },
    { "SPSR",    0x2E, 0x00 },
    { "SPDR",    0x2F, 0x00 },
    { "PIND",    0x30, 0x00 },
    { "DDRD",    0x31, 0x00 },
    { "PORTD",   0x32, 0x00 },
    { "PINC",    0x33, 0x00 },
    { "DDRC",    0x34, 0x00 },
    { "PORTC",   0x35, 0x00 },
    { "PINB",    0x36, 0x00 },
    { "DDRB",    0x37, 0x00 },
    { "PORTB",   0x38, 0x00 },
    { "PINA",    0x39, 0x00 },
    { "DDRA",    0x3A, 0x00 },
    { "PORTA",   0x3B, 0x00 },
    { "EECR",    0x3C, 0x00 },
    { "EEDR",    0x3D, 0x00 },
    { "EEARL",   0x3E, 0x00 },
    { "EEARH",   0x3F, 0x00 },
    { "UBRR0H -- UCSR0C",  0x40, 0x00 },
    { "WDTCR",   0x41, 0x00 },
    { "OCR2",    0x42, 0x00 },
    { "TCNT2",   0x43, 0x00 },
    { "ICR1L",   0x44, 0x00 },
    { "ICR1H",   0x45, 0x00 },
    { "ASSR",    0x46, 0x00 },
    { "TCCR2",   0x47, 0x00 },
    { "OCR1BL",  0x48, 0x00 },
    { "OCR1BH",  0x49, 0x00 },
    { "OCR1AL",  0x4A, 0x00 },
    { "OCR1AH",  0x4B, 0x00 },
    { "TCNT1L",  0x4C, 0x00 },
    { "TCNT1H",  0x4D, 0x00 },
    { "TCCR1B",  0x4E, 0x00 },
    { "TCCR1A",  0x4F, 0x00 },
    { "SFIOR",   0x50, 0x00 },
    { "OCR0",    0x51, 0x00 },
    { "TCNT0",   0x52, 0x00 },
    { "TCCR0",   0x53, 0x00 },
    { "MCUCSR",  0x54, 0x00 },
    { "MCUCR",   0x55, 0x00 },
    { "EMCUCR",  0x56, 0x00 },
    { "SPMCR",   0x57, 0x00 },
    { "TIFR",    0x58, 0x00 },
    { "TIMSK",   0x59, 0x00 },
    { "GIFR",    0x5A, 0x00 },
    { "GICR",    0x5B, 0x00 },
    { "UCSR1C -- UBRR1H",  0x5C, 0x00 },
    { "SPL",     0x5D, 0x00 },
    { "SPH",     0x5E, 0x00 },
    { "SREG",    0x5F, 0x00 },
    { "CLKPR",   0x61, 0x00 },
    { "PCMSK0",  0x6B, 0x00 },
    { "PCMSK1",  0x6C, 0x00 },
    { "ETIFR",   0x7C, 0x00 },
    { "ETIMSK",  0x7D, 0x00 },
    { "ICR3L",   0x80, 0x00 },
    { "ICR3H",   0x81, 0x00 },
    { "OCR3BL",  0x84, 0x00 },
    { "OCR3BH",  0x85, 0x00 },
    { "OCR3AL",  0x86, 0x00 },
    { "OCR3AH",  0x87, 0x00 },
    { "TCNT3L",  0x88, 0x00 },
    { "TCNT3H",  0x89, 0x00 },
    { "TCCR3B",  0x8A, 0x00 },
    { "TCCR3A",  0x8B, 0x00 },
    { 0, 0, 0 }
};

gdb_io_reg_def_type atmega169_io_registers[] =
{
    { "PINA",    0x20, 0x00 },
    { "DDRA",    0x21, 0x00 },
    { "PORTA",   0x22, 0x00 },
    { "PINB",    0x23, 0x00 },
    { "DDRB",    0x24, 0x00 },
    { "PORTB",   0x25, 0x00 },
    { "PINC",    0x26, 0x00 },
    { "DDRC",    0x27, 0x00 },
    { "PORTC",   0x28, 0x00 },
    { "PIND",    0x29, 0x00 },
    { "DDRD",    0x2A, 0x00 },
    { "PORTD",   0x2B, 0x00 },
    { "PINE",    0x2C, 0x00 },
    { "DDRE",    0x2D, 0x00 },
    { "PORTE",   0x2E, 0x00 },
    { "PINF",    0x2F, 0x00 },
    { "DDRF",    0x30, 0x00 },
    { "PORTF",   0x31, 0x00 },
    { "PING",    0x32, 0x00 },
    { "DDRG",    0x33, 0x00 },
    { "PORTG",   0x34, 0x00 },
    { "TIFR0",   0x35, 0x00 },
    { "TIFR1",   0x36, 0x00 },
    { "TIFR2",   0x37, 0x00 },
    { "EIFR",    0x3C, 0x00 },
    { "EIMSK",   0x3D, 0x00 },
    { "GPIOR0",  0x3E, 0x00 },
    { "EECR",    0x3F, 0x00 },
    { "EEDR",    0x40, 0x00 },
    { "EEARL",   0x41, 0x00 },
    { "EEARH",   0x42, 0x00 },
    { "GTCCR",   0x43, 0x00 },
    { "TCCR0A",  0x44, 0x00 },
    { "TCNT0",   0x46, 0x00 },
    { "OCR0A",   0x47, 0x00 },
    { "GPIOR1",  0x4A, 0x00 },
    { "GPIOR2",  0x4B, 0x00 },
    { "SPCR",    0x4C, 0x00 },
    { "SPSR",    0x4D, 0x00 },
    { "SPDR",    0x4E, 0x00 },
    { "ACSR",    0x50, 0x00 },
    { "OCDR",    0x51, 0x00 },
    { "SMCR",    0x53, 0x00 },
    { "MCUCSR",  0x54, 0x00 },
    { "MCUCR",   0x55, 0x00 },
    { "SPMCSR",  0x57, 0x00 },
    { "SPL",     0x5D, 0x00 },
    { "SPH",     0x5E, 0x00 },
    { "SREG",    0x5F, 0x00 },
    { "WDTCR",   0x60, 0x00 },
    { "CLKPR",   0x61, 0x00 },
    { "OSCCAL",  0x66, 0x00 },
    { "EICRA",   0x69, 0x00 },
    { "PCMSK0",  0x6B, 0x00 },
    { "PCMSK1",  0x6C, 0x00 },
    { "TIMSK0",  0x6E, 0x00 },
    { "TIMSK1",  0x6F, 0x00 },
    { "TIMSK2",  0x70, 0x00 },
    { "ADCL",    0x78, IO_REG_RSE }, // Reading during a conversion corrupts
    { "ADCH",    0x79, IO_REG_RSE }, // ADC result
    { "ADCSRA",  0x7A, 0x00 },
    { "ADCSRB",  0x7B, 0x00 },
    { "ADMUX",   0x7C, 0x00 },
    { "DIDR0",   0x7E, 0x00 },
    { "DIDR1",   0x7F, 0x00 },
    { "TCCR1A",  0x80, 0x00 },
    { "TCCR1B",  0x81, 0x00 },
    { "TCCR1C",  0x82, 0x00 },
    { "TCNT1L",  0x84, 0x00 },
    { "TCNT1H",  0x85, 0x00 },
    { "ICR1L",   0x86, 0x00 },
    { "ICR1H",   0x87, 0x00 },
    { "OCR1AL",  0x88, 0x00 },
    { "OCR1AH",  0x89, 0x00 },
    { "OCR1BL",  0x8A, 0x00 },
    { "OCR1BH",  0x8B, 0x00 },
    { "TCCR2A",  0xB0, 0x00 },
    { "TCNT2",   0xB2, 0x00 },
    { "OCR2A",   0xB3, 0x00 },
    { "ASSR",    0xB6, 0x00 },
    { "USICR",   0xB8, 0x00 },
    { "USISR",   0xB9, 0x00 },
    { "USIDR",   0xBA, 0x00 },
    { "UCSRA",   0xC0, 0x00 },
    { "UCSRB",   0xC1, 0x00 },
    { "UCSRC",   0xC2, 0x00 },
    { "UBRRL",   0xC4, 0x00 },
    { "UBRRH",   0xC5, 0x00 },
    { "UDR",     0xC6, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "LCDCRA",  0xE4, 0x00 },
    { "LCDCRB",  0xE5, 0x00 },
    { "LCDFRR",  0xE6, 0x00 },
    { "LCDCCR",  0xE7, 0x00 },
    { "LCDDR0",  0xEC, 0x00 },
    { "LCDDR1",  0xED, 0x00 },
    { "LCDDR2",  0xEE, 0x00 },
    { "LCDDR3",  0xEF, 0x00 },
    { "LCDDR5",  0xF1, 0x00 },
    { "LCDDR6",  0xF2, 0x00 },
    { "LCDDR7",  0xF3, 0x00 },
    { "LCDDR8",  0xF4, 0x00 },
    { "LCDDR10", 0xF6, 0x00 },
    { "LCDDR11", 0xF7, 0x00 },
    { "LCDDR12", 0xF8, 0x00 },
    { "LCDDR13", 0xF9, 0x00 },
    { "LCDDR15", 0xFB, 0x00 },
    { "LCDDR16", 0xFC, 0x00 },
    { "LCDDR17", 0xFD, 0x00 },
    { "LCDDR18", 0xFE, 0x00 },
    { 0, 0, 0 }
};

gdb_io_reg_def_type atmega32_io_registers[] =
{
    { "TWBR",    0x20, 0x00 },
    { "TWSR",    0x21, 0x00 },
    { "TWAR",    0x22, 0x00 },
    { "TWDR",    0x23, 0x00 },
    { "ADCL",    0x24, IO_REG_RSE }, // Reading during a conversion corrupts
    { "ADCH",    0x25, IO_REG_RSE }, // ADC result
    { "ADCSRA",  0x26, 0x00 },
    { "ADMUX",   0x27, 0x00 },
    { "ACSR",    0x28, 0x00 },
    { "UBRRL",   0x29, 0x00 },
    { "UCSRB",   0x2A, 0x00 },
    { "UCSRA",   0x2B, 0x00 },
    { "UDR",     0x2C, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "SPCR",    0x2D, 0x00 },
    { "SPSR",    0x2E, 0x00 },
    { "SPDR",    0x2F, 0x00 },
    { "PIND",    0x30, 0x00 },
    { "DDRD",    0x31, 0x00 },
    { "PORTD",   0x32, 0x00 },
    { "PINC",    0x33, 0x00 },
    { "DDRC",    0x34, 0x00 },
    { "PORTC",   0x35, 0x00 },
    { "PINB",    0x36, 0x00 },
    { "DDRB",    0x37, 0x00 },
    { "PORTB",   0x38, 0x00 },
    { "PINA",    0x39, 0x00 },
    { "DDRA",    0x3A, 0x00 },
    { "PORTA",   0x3B, 0x00 },
    { "EECR",    0x3C, 0x00 },
    { "EEDR",    0x3D, 0x00 },
    { "EEARL",   0x3E, 0x00 },
    { "EEARH",   0x3F, 0x00 },
    { "UBRR0H -- UCSR0C",  0x40, 0x00 },
    { "WDTCR",   0x41, 0x00 },
    { "ASSR",    0x42, 0x00 },
    { "OCR2",    0x43, 0x00 },
    { "TCNT2",   0x44, 0x00 },
    { "TCCR2",   0x45, 0x00 },
    { "ICR1L",   0x46, 0x00 },
    { "ICR1H",   0x47, 0x00 },
    { "OCR1BL",  0x48, 0x00 },
    { "OCR1BH",  0x49, 0x00 },
    { "OCR1AL",  0x4A, 0x00 },
    { "OCR1AH",  0x4B, 0x00 },
    { "TCNT1L",  0x4C, 0x00 },
    { "TCNT1H",  0x4D, 0x00 },
    { "TCCR1B",  0x4E, 0x00 },
    { "TCCR1A",  0x4F, 0x00 },
    { "SFIOR",   0x50, 0x00 },
    { "OSCCAL",  0x51, 0x00 },
    { "TCNT0",   0x52, 0x00 },
    { "TCCR0",   0x53, 0x00 },
    { "MCUCSR",  0x54, 0x00 },
    { "MCUCR",   0x55, 0x00 },
    { "TWCR",    0x56, 0x00 },
    { "SPMCR",   0x57, 0x00 },
    { "TIFR",    0x58, 0x00 },
    { "TIMSK",   0x59, 0x00 },
    { "GIFR",    0x5A, 0x00 },
    { "GIMSK",   0x5B, 0x00 },
    { "OCR0",    0x5C, 0x00 },
    { "SPL",     0x5D, 0x00 },
    { "SPH",     0x5E, 0x00 },
    { "SREG",    0x5F, 0x00 },
    { 0, 0, 0 }
};

gdb_io_reg_def_type atmega128_io_registers[] =
{
    { "PINF",    0x20, 0x00 },
    { "PINE",    0x21, 0x00 },
    { "DDRE",    0x22, 0x00 },
    { "PORTE",   0x23, 0x00 },
    { "ADCL",    0x24, IO_REG_RSE }, // Reading during a conversion corrupts
    { "ADCH",    0x25, IO_REG_RSE }, // ADC result
    { "ADCSRA",  0x26, 0x00 },
    { "ADMUX",   0x27, 0x00 },
    { "ACSR",    0x28, 0x00 },
    { "UBRR0L",  0x29, 0x00 },
    { "UCSR0B",  0x2A, 0x00 },
    { "UCSR0A",  0x2B, 0x00 },
    { "UDR0",    0x2C, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "SPCR",    0x2D, 0x00 },
    { "SPSR",    0x2E, 0x00 },
    { "SPDR",    0x2F, 0x00 },
    { "PIND",    0x30, 0x00 },
    { "DDRD",    0x31, 0x00 },
    { "PORTD",   0x32, 0x00 },
    { "PINC",    0x33, 0x00 },
    { "DDRC",    0x34, 0x00 },
    { "PORTC",   0x35, 0x00 },
    { "PINB",    0x36, 0x00 },
    { "DDRB",    0x37, 0x00 },
    { "PORTB",   0x38, 0x00 },
    { "PINA",    0x39, 0x00 },
    { "DDRA",    0x3A, 0x00 },
    { "PORTA",   0x3B, 0x00 },
    { "EECR",    0x3C, 0x00 },
    { "EEDR",    0x3D, 0x00 },
    { "EEARL",   0x3E, 0x00 },
    { "EEARH",   0x3F, 0x00 },
    { "SFIOR",   0x40, 0x00 },
    { "WDTCR",   0x41, 0x00 },
    { "OCDR",    0x42, 0x00 },
    { "OCR2",    0x43, 0x00 },
    { "TCNT2",   0x44, 0x00 },
    { "TCCR2",   0x45, 0x00 },
    { "ICR1L",   0x46, 0x00 },
    { "ICR1H",   0x47, 0x00 },
    { "OCR1BL",  0x48, 0x00 },
    { "OCR1BH",  0x49, 0x00 },
    { "OCR1AL",  0x4A, 0x00 },
    { "OCR1AH",  0x4B, 0x00 },
    { "TCNT1L",  0x4C, 0x00 },
    { "TCNT1H",  0x4D, 0x00 },
    { "TCCR1B",  0x4E, 0x00 },
    { "TCCR1A",  0x4F, 0x00 },
    { "ASSR",    0x50, 0x00 },
    { "OCR0",    0x51, 0x00 },
    { "TCNT0",   0x52, 0x00 },
    { "TCCR0",   0x53, 0x00 },
    { "MCUCSR",  0x54, 0x00 },
    { "MCUCR",   0x55, 0x00 },
    { "TIFR",    0x56, 0x00 },
    { "TIMSK",   0x57, 0x00 },
    { "EIFR",    0x58, 0x00 },
    { "EIMSK",   0x59, 0x00 },
    { "EICRB",   0x5A, 0x00 },
    { "RAMPZ",   0x5B, 0x00 },
    { "XDIV",    0x5C, 0x00 },
    { "SPL",     0x5D, 0x00 },
    { "SPH",     0x5E, 0x00 },
    { "SREG",    0x5F, 0x00 },
    { "DDRF",    0x61, 0x00 },
    { "PORTF",   0x62, 0x00 },
    { "PING",    0x63, 0x00 },
    { "DDRG",    0x64, 0x00 },
    { "PORTG",   0x65, 0x00 },
    { "SPMCSR",  0x68, 0x00 },
    { "EICRA",   0x6A, 0x00 },
    { "XMCRB",   0x6C, 0x00 },
    { "XMCRA",   0x6D, 0x00 },
    { "OSCCAL",  0x6F, 0x00 },
    { "TWBR",    0x70, 0x00 },
    { "TWSR",    0x71, 0x00 },
    { "TWAR",    0x72, 0x00 },
    { "TWDR",    0x73, 0x00 },
    { "TWCR",    0x74, 0x00 },
    { "OCR1CL",  0x78, 0x00 },
    { "OCR1CH",  0x79, 0x00 },
    { "TCCR1C",  0x7A, 0x00 },
    { "ETIFR",   0x7C, 0x00 },
    { "ETIMSK",  0x7D, 0x00 },
    { "ICR3L",   0x80, 0x00 },
    { "ICR3H",   0x81, 0x00 },
    { "OCR3CL",  0x82, 0x00 },
    { "OCR3CH",  0x83, 0x00 },
    { "OCR3BL",  0x84, 0x00 },
    { "OCR3BH",  0x85, 0x00 },
    { "OCR3AL",  0x86, 0x00 },
    { "OCR3AH",  0x87, 0x00 },
    { "TCNT3L",  0x88, 0x00 },
    { "TCNT3H",  0x89, 0x00 },
    { "TCCR3B",  0x8A, 0x00 },
    { "TCCR3A",  0x8B, 0x00 },
    { "TCCR3C",  0x8C, 0x00 },
    { "UBRR0H",  0x90, 0x00 },
    { "UCSR0C",  0x95, 0x00 },
    { "UBRR1H",  0x98, 0x00 },
    { "UBRR1L",  0x99, 0x00 },
    { "UCSR1B",  0x9A, 0x00 },
    { "UCSR1A",  0x9B, 0x00 },
    { "UDR1",    0x9C, IO_REG_RSE }, // Reading this clears the UART RXC flag
    { "UCSR1C",  0x9D, 0x00 },
    { 0, 0, 0 }
};

gdb_io_reg_def_type atmega323_io_registers[] =
{
    { "TWBR", 0x20, 0x00 },
    { "TWSR", 0x21, 0x00 },
    { "TWAR", 0x22, 0x00 },
    { "TWDR", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSR", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "UBRR", 0x29, 0x00 },
    { "UCSRB", 0x2a, 0x00 },
    { "UCSRA", 0x2b, 0x00 },
    { "UDR", 0x2c, IO_REG_RSE },
    { "SPCR", 0x2d, 0x00 },
    { "SPSR", 0x2e, 0x00 },
    { "SPDR", 0x2f, 0x00 },
    { "PIND", 0x30, 0x00 },
    { "DDRD", 0x31, 0x00 },
    { "PORTD", 0x32, 0x00 },
    { "PINC", 0x33, 0x00 },
    { "DDRC", 0x34, 0x00 },
    { "PORTC", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "UBRRH", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "ASSR", 0x42, 0x00 },
    { "OCR2", 0x43, 0x00 },
    { "TCNT2", 0x44, 0x00 },
    { "TCCR2", 0x45, 0x00 },
    { "ICR1L", 0x46, 0x00 },
    { "ICR1H", 0x47, 0x00 },
    { "OCR1BL", 0x48, 0x00 },
    { "OCR1BH", 0x49, 0x00 },
    { "OCR1AL", 0x4a, 0x00 },
    { "OCR1AH", 0x4b, 0x00 },
    { "TCNT1L", 0x4c, 0x00 },
    { "TCNT1H", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "SFIOR", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "TWCR", 0x56, 0x00 },
    { "SPMCR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "OCR0", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega64_io_registers[] =
{
    { "PINF", 0x20, 0x00 },
    { "PINE", 0x21, 0x00 },
    { "DDRE", 0x22, 0x00 },
    { "PORTE", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSR -- ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "UBRR0L", 0x29, 0x00 },
    { "UCSR0B", 0x2a, 0x00 },
    { "UCSR0A", 0x2b, 0x00 },
    { "UDR0", 0x2c, IO_REG_RSE },
    { "SPCR", 0x2d, 0x00 },
    { "SPSR", 0x2e, 0x00 },
    { "SPDR", 0x2f, 0x00 },
    { "PIND", 0x30, 0x00 },
    { "DDRD", 0x31, 0x00 },
    { "PORTD", 0x32, 0x00 },
    { "PINC", 0x33, 0x00 },
    { "DDRC", 0x34, 0x00 },
    { "PORTC", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "SFIOR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "OCDR", 0x42, 0x00 },
    { "OCR2", 0x43, 0x00 },
    { "TCNT2", 0x44, 0x00 },
    { "TCCR2", 0x45, 0x00 },
    { "ICR1L", 0x46, 0x00 },
    { "ICR1H", 0x47, 0x00 },
    { "OCR1BL", 0x48, 0x00 },
    { "OCR1BH", 0x49, 0x00 },
    { "OCR1AL", 0x4a, 0x00 },
    { "OCR1AH", 0x4b, 0x00 },
    { "TCNT1L", 0x4c, 0x00 },
    { "TCNT1H", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "ASSR", 0x50, 0x00 },
    { "OCR0", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0", 0x53, 0x00 },
    { "MCUSR -- MCUCSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "TIFR", 0x56, 0x00 },
    { "TIMSK", 0x57, 0x00 },
    { "EIFR", 0x58, 0x00 },
    { "EIMSK", 0x59, 0x00 },
    { "EICRB", 0x5a, 0x00 },
    { "XDIV", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "DDRF", 0x61, 0x00 },
    { "PORTF", 0x62, 0x00 },
    { "PING", 0x63, 0x00 },
    { "DDRG", 0x64, 0x00 },
    { "PORTG", 0x65, 0x00 },
    { "SPMCR -- SPMCSR", 0x68, 0x00 },
    { "EICRA", 0x6a, 0x00 },
    { "XMCRB", 0x6c, 0x00 },
    { "XMCRA", 0x6d, 0x00 },
    { "OSCCAL", 0x6f, 0x00 },
    { "TWBR", 0x70, 0x00 },
    { "TWSR", 0x71, 0x00 },
    { "TWAR", 0x72, 0x00 },
    { "TWDR", 0x73, 0x00 },
    { "TWCR", 0x74, 0x00 },
    { "OCR1CL", 0x78, 0x00 },
    { "OCR1CH", 0x79, 0x00 },
    { "TCCR1C", 0x7a, 0x00 },
    { "ETIFR", 0x7c, 0x00 },
    { "ETIMSK", 0x7d, 0x00 },
    { "ICR3L", 0x80, 0x00 },
    { "ICR3H", 0x81, 0x00 },
    { "OCR3CL", 0x82, 0x00 },
    { "OCR3CH", 0x83, 0x00 },
    { "OCR3BL", 0x84, 0x00 },
    { "OCR3BH", 0x85, 0x00 },
    { "OCR3AL", 0x86, 0x00 },
    { "OCR3AH", 0x87, 0x00 },
    { "TCNT3L", 0x88, 0x00 },
    { "TCNT3H", 0x89, 0x00 },
    { "TCCR3B", 0x8a, 0x00 },
    { "TCCR3A", 0x8b, 0x00 },
    { "TCCR3C", 0x8c, 0x00 },
    { "ADCSRB", 0x8e, 0x00 },
    { "UBRR0H", 0x90, 0x00 },
    { "UCSR0C", 0x95, 0x00 },
    { "UBRR1H", 0x98, 0x00 },
    { "UBRR1L", 0x99, 0x00 },
    { "UCSR1B", 0x9a, 0x00 },
    { "UCSR1A", 0x9b, 0x00 },
    { "UDR1", 0x9c, IO_REG_RSE },
    { "UCSR1C", 0x9d, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90can128_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "CANGCON", 0xd8, 0x00 },
    { "CANGSTA", 0xd9, 0x00 },
    { "CANGIT", 0xda, 0x00 },
    { "CANGIE", 0xdb, 0x00 },
    { "CANEN2", 0xdc, 0x00 },
    { "CANEN1", 0xdd, 0x00 },
    { "CANIE2", 0xde, 0x00 },
    { "CANIE1", 0xdf, 0x00 },
    { "CANSIT2", 0xe0, 0x00 },
    { "CANSIT1", 0xe1, 0x00 },
    { "CANBT1", 0xe2, 0x00 },
    { "CANBT2", 0xe3, 0x00 },
    { "CANBT3", 0xe4, 0x00 },
    { "CANTCON", 0xe5, 0x00 },
    { "CANTIML", 0xe6, 0x00 },
    { "CANTIMH", 0xe7, 0x00 },
    { "CANTTCL", 0xe8, 0x00 },
    { "CANTTCH", 0xe9, 0x00 },
    { "CANTEC", 0xea, 0x00 },
    { "CANREC", 0xeb, 0x00 },
    { "CANHPMOB", 0xec, 0x00 },
    { "CANPAGE", 0xed, 0x00 },
    { "CANSTMOB", 0xee, 0x00 },
    { "CANCDMOB", 0xef, 0x00 },
    { "CANIDT4", 0xf0, 0x00 },
    { "CANIDT3", 0xf1, 0x00 },
    { "CANIDT2", 0xf2, 0x00 },
    { "CANIDT1", 0xf3, 0x00 },
    { "CANIDM4", 0xf4, 0x00 },
    { "CANIDM3", 0xf5, 0x00 },
    { "CANIDM2", 0xf6, 0x00 },
    { "CANIDM1", 0xf7, 0x00 },
    { "CANSTML", 0xf8, 0x00 },
    { "CANSTMH", 0xf9, 0x00 },
    { "CANMSG", 0xfa, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega164p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR -- PRR0", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega324p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR -- PRR0", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega644_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR -- PRR0", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega325_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega3250_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "PINH", 0xd8, 0x00 },
    { "DDRH", 0xd9, 0x00 },
    { "PORTH", 0xda, 0x00 },
    { "PINJ", 0xdb, 0x00 },
    { "DDRJ", 0xdc, 0x00 },
    { "PORTJ", 0xdd, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega645_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega6450_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "PINH", 0xd8, 0x00 },
    { "DDRH", 0xd9, 0x00 },
    { "PORTH", 0xda, 0x00 },
    { "PINJ", 0xdb, 0x00 },
    { "DDRJ", 0xdc, 0x00 },
    { "PORTJ", 0xdd, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega329_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "LCDCRA", 0xe4, 0x00 },
    { "LCDCRB", 0xe5, 0x00 },
    { "LCDFRR", 0xe6, 0x00 },
    { "LCDCCR", 0xe7, 0x00 },
    { "LCDDR00", 0xec, 0x00 },
    { "LCDDR01", 0xed, 0x00 },
    { "LCDDR02", 0xee, 0x00 },
    { "LCDDR03", 0xef, 0x00 },
    { "LCDDR05", 0xf1, 0x00 },
    { "LCDDR06", 0xf2, 0x00 },
    { "LCDDR07", 0xf3, 0x00 },
    { "LCDDR08", 0xf4, 0x00 },
    { "LCDDR10", 0xf6, 0x00 },
    { "LCDDR11", 0xf7, 0x00 },
    { "LCDDR12", 0xf8, 0x00 },
    { "LCDDR13", 0xf9, 0x00 },
    { "LCDDR15", 0xfb, 0x00 },
    { "LCDDR16", 0xfc, 0x00 },
    { "LCDDR17", 0xfd, 0x00 },
    { "LCDDR18", 0xfe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega3290_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "PINH", 0xd8, 0x00 },
    { "DDRH", 0xd9, 0x00 },
    { "PORTH", 0xda, 0x00 },
    { "PINJ", 0xdb, 0x00 },
    { "DDRJ", 0xdc, 0x00 },
    { "PORTJ", 0xdd, 0x00 },
    { "LCDCRA", 0xe4, 0x00 },
    { "LCDCRB", 0xe5, 0x00 },
    { "LCDFRR", 0xe6, 0x00 },
    { "LCDCCR", 0xe7, 0x00 },
    { "LCDDR00", 0xec, 0x00 },
    { "LCDDR01", 0xed, 0x00 },
    { "LCDDR02", 0xee, 0x00 },
    { "LCDDR03", 0xef, 0x00 },
    { "LCDDR04", 0xf0, 0x00 },
    { "LCDDR05", 0xf1, 0x00 },
    { "LCDDR06", 0xf2, 0x00 },
    { "LCDDR07", 0xf3, 0x00 },
    { "LCDDR08", 0xf4, 0x00 },
    { "LCDDR09", 0xf5, 0x00 },
    { "LCDDR10", 0xf6, 0x00 },
    { "LCDDR11", 0xf7, 0x00 },
    { "LCDDR12", 0xf8, 0x00 },
    { "LCDDR13", 0xf9, 0x00 },
    { "LCDDR14", 0xfa, 0x00 },
    { "LCDDR15", 0xfb, 0x00 },
    { "LCDDR16", 0xfc, 0x00 },
    { "LCDDR17", 0xfd, 0x00 },
    { "LCDDR18", 0xfe, 0x00 },
    { "LCDDR19", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega649_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "LCDCRA", 0xe4, 0x00 },
    { "LCDCRB", 0xe5, 0x00 },
    { "LCDFRR", 0xe6, 0x00 },
    { "LCDCCR", 0xe7, 0x00 },
    { "LCDDR00", 0xec, 0x00 },
    { "LCDDR01", 0xed, 0x00 },
    { "LCDDR02", 0xee, 0x00 },
    { "LCDDR03", 0xef, 0x00 },
    { "LCDDR05", 0xf1, 0x00 },
    { "LCDDR06", 0xf2, 0x00 },
    { "LCDDR07", 0xf3, 0x00 },
    { "LCDDR08", 0xf4, 0x00 },
    { "LCDDR10", 0xf6, 0x00 },
    { "LCDDR11", 0xf7, 0x00 },
    { "LCDDR12", 0xf8, 0x00 },
    { "LCDDR13", 0xf9, 0x00 },
    { "LCDDR15", 0xfb, 0x00 },
    { "LCDDR16", 0xfc, 0x00 },
    { "LCDDR17", 0xfd, 0x00 },
    { "LCDDR18", 0xfe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega6490_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "PINH", 0xd8, 0x00 },
    { "DDRH", 0xd9, 0x00 },
    { "PORTH", 0xda, 0x00 },
    { "PINJ", 0xdb, 0x00 },
    { "DDRJ", 0xdc, 0x00 },
    { "PORTJ", 0xdd, 0x00 },
    { "LCDCRA", 0xe4, 0x00 },
    { "LCDCRB", 0xe5, 0x00 },
    { "LCDFRR", 0xe6, 0x00 },
    { "LCDCCR", 0xe7, 0x00 },
    { "LCDDR00", 0xec, 0x00 },
    { "LCDDR01", 0xed, 0x00 },
    { "LCDDR02", 0xee, 0x00 },
    { "LCDDR03", 0xef, 0x00 },
    { "LCDDR04", 0xf0, 0x00 },
    { "LCDDR05", 0xf1, 0x00 },
    { "LCDDR06", 0xf2, 0x00 },
    { "LCDDR07", 0xf3, 0x00 },
    { "LCDDR08", 0xf4, 0x00 },
    { "LCDDR09", 0xf5, 0x00 },
    { "LCDDR10", 0xf6, 0x00 },
    { "LCDDR11", 0xf7, 0x00 },
    { "LCDDR12", 0xf8, 0x00 },
    { "LCDDR13", 0xf9, 0x00 },
    { "LCDDR14", 0xfa, 0x00 },
    { "LCDDR15", 0xfb, 0x00 },
    { "LCDDR16", 0xfc, 0x00 },
    { "LCDDR17", 0xfd, 0x00 },
    { "LCDDR18", 0xfe, 0x00 },
    { "LCDDR19", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega640_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "EIND", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR4A", 0xa0, 0x00 },
    { "TCCR4B", 0xa1, 0x00 },
    { "TCCR4C", 0xa2, 0x00 },
    { "TCNT4L", 0xa4, 0x00 },
    { "TCNT4H", 0xa5, 0x00 },
    { "ICR4L", 0xa6, 0x00 },
    { "ICR4H", 0xa7, 0x00 },
    { "OCR4AL", 0xa8, 0x00 },
    { "OCR4AH", 0xa9, 0x00 },
    { "OCR4BL", 0xaa, 0x00 },
    { "OCR4BH", 0xab, 0x00 },
    { "OCR4CL", 0xac, 0x00 },
    { "OCR4CH", 0xad, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "UCSR2A", 0xd0, 0x00 },
    { "UCSR2B", 0xd1, 0x00 },
    { "UCSR2C", 0xd2, 0x00 },
    { "UBRR2L", 0xd4, 0x00 },
    { "UBRR2H", 0xd5, 0x00 },
    { "UDR2", 0xd6, IO_REG_RSE },
    { "PINH", 0x100, 0x00 },
    { "DDRH", 0x101, 0x00 },
    { "PORTH", 0x102, 0x00 },
    { "PINJ", 0x103, 0x00 },
    { "DDRJ", 0x104, 0x00 },
    { "PORTJ", 0x105, 0x00 },
    { "PINK", 0x106, 0x00 },
    { "DDRK", 0x107, 0x00 },
    { "PORTK", 0x108, 0x00 },
    { "PINL", 0x109, 0x00 },
    { "DDRL", 0x10a, 0x00 },
    { "PORTL", 0x10b, 0x00 },
    { "TCCR5A", 0x120, 0x00 },
    { "TCCR5B", 0x121, 0x00 },
    { "TCCR5C", 0x122, 0x00 },
    { "TCNT5L", 0x124, 0x00 },
    { "TCNT5H", 0x125, 0x00 },
    { "ICR5L", 0x126, 0x00 },
    { "ICR5H", 0x127, 0x00 },
    { "OCR5AL", 0x128, 0x00 },
    { "OCR5AH", 0x129, 0x00 },
    { "OCR5BL", 0x12a, 0x00 },
    { "OCR5BH", 0x12b, 0x00 },
    { "OCR5CL", 0x12c, 0x00 },
    { "OCR5CH", 0x12d, 0x00 },
    { "UCSR3A", 0x130, 0x00 },
    { "UCSR3B", 0x131, 0x00 },
    { "UCSR3C", 0x132, 0x00 },
    { "UBRR3L", 0x134, 0x00 },
    { "UBRR3H", 0x135, 0x00 },
    { "UDR3", 0x136, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega1280_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "EIND", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR4A", 0xa0, 0x00 },
    { "TCCR4B", 0xa1, 0x00 },
    { "TCCR4C", 0xa2, 0x00 },
    { "TCNT4L", 0xa4, 0x00 },
    { "TCNT4H", 0xa5, 0x00 },
    { "ICR4L", 0xa6, 0x00 },
    { "ICR4H", 0xa7, 0x00 },
    { "OCR4AL", 0xa8, 0x00 },
    { "OCR4AH", 0xa9, 0x00 },
    { "OCR4BL", 0xaa, 0x00 },
    { "OCR4BH", 0xab, 0x00 },
    { "OCR4CL", 0xac, 0x00 },
    { "OCR4CH", 0xad, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "UCSR2A", 0xd0, 0x00 },
    { "UCSR2B", 0xd1, 0x00 },
    { "UCSR2C", 0xd2, 0x00 },
    { "UBRR2L", 0xd4, 0x00 },
    { "UBRR2H", 0xd5, 0x00 },
    { "UDR2", 0xd6, IO_REG_RSE },
    { "PINH", 0x100, 0x00 },
    { "DDRH", 0x101, 0x00 },
    { "PORTH", 0x102, 0x00 },
    { "PINJ", 0x103, 0x00 },
    { "DDRJ", 0x104, 0x00 },
    { "PORTJ", 0x105, 0x00 },
    { "PINK", 0x106, 0x00 },
    { "DDRK", 0x107, 0x00 },
    { "PORTK", 0x108, 0x00 },
    { "PINL", 0x109, 0x00 },
    { "DDRL", 0x10a, 0x00 },
    { "PORTL", 0x10b, 0x00 },
    { "TCCR5A", 0x120, 0x00 },
    { "TCCR5B", 0x121, 0x00 },
    { "TCCR5C", 0x122, 0x00 },
    { "TCNT5L", 0x124, 0x00 },
    { "TCNT5H", 0x125, 0x00 },
    { "ICR5L", 0x126, 0x00 },
    { "ICR5H", 0x127, 0x00 },
    { "OCR5AL", 0x128, 0x00 },
    { "OCR5AH", 0x129, 0x00 },
    { "OCR5BL", 0x12a, 0x00 },
    { "OCR5BH", 0x12b, 0x00 },
    { "OCR5CL", 0x12c, 0x00 },
    { "OCR5CH", 0x12d, 0x00 },
    { "UCSR3A", 0x130, 0x00 },
    { "UCSR3B", 0x131, 0x00 },
    { "UCSR3C", 0x132, 0x00 },
    { "UBRR3L", 0x134, 0x00 },
    { "UBRR3H", 0x135, 0x00 },
    { "UDR3", 0x136, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega1281_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "EIND", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR4A", 0xa0, 0x00 },
    { "TCCR4B", 0xa1, 0x00 },
    { "TCCR4C", 0xa2, 0x00 },
    { "TCNT4L", 0xa4, 0x00 },
    { "TCNT4H", 0xa5, 0x00 },
    { "ICR4L", 0xa6, 0x00 },
    { "ICR4H", 0xa7, 0x00 },
    { "OCR4AL", 0xa8, 0x00 },
    { "OCR4AH", 0xa9, 0x00 },
    { "OCR4BL", 0xaa, 0x00 },
    { "OCR4BH", 0xab, 0x00 },
    { "OCR4CL", 0xac, 0x00 },
    { "OCR4CH", 0xad, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "TCCR5A", 0x120, 0x00 },
    { "TCCR5B", 0x121, 0x00 },
    { "TCCR5C", 0x122, 0x00 },
    { "TCNT5L", 0x124, 0x00 },
    { "TCNT5H", 0x125, 0x00 },
    { "ICR5L", 0x126, 0x00 },
    { "ICR5H", 0x127, 0x00 },
    { "OCR5AL", 0x128, 0x00 },
    { "OCR5AH", 0x129, 0x00 },
    { "OCR5BL", 0x12a, 0x00 },
    { "OCR5BH", 0x12b, 0x00 },
    { "OCR5CL", 0x12c, 0x00 },
    { "OCR5CH", 0x12d, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega2560_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "EIND", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR4A", 0xa0, 0x00 },
    { "TCCR4B", 0xa1, 0x00 },
    { "TCCR4C", 0xa2, 0x00 },
    { "TCNT4L", 0xa4, 0x00 },
    { "TCNT4H", 0xa5, 0x00 },
    { "ICR4L", 0xa6, 0x00 },
    { "ICR4H", 0xa7, 0x00 },
    { "OCR4AL", 0xa8, 0x00 },
    { "OCR4AH", 0xa9, 0x00 },
    { "OCR4BL", 0xaa, 0x00 },
    { "OCR4BH", 0xab, 0x00 },
    { "OCR4CL", 0xac, 0x00 },
    { "OCR4CH", 0xad, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "UCSR2A", 0xd0, 0x00 },
    { "UCSR2B", 0xd1, 0x00 },
    { "UCSR2C", 0xd2, 0x00 },
    { "UBRR2L", 0xd4, 0x00 },
    { "UBRR2H", 0xd5, 0x00 },
    { "UDR2", 0xd6, IO_REG_RSE },
    { "PINH", 0x100, 0x00 },
    { "DDRH", 0x101, 0x00 },
    { "PORTH", 0x102, 0x00 },
    { "PINJ", 0x103, 0x00 },
    { "DDRJ", 0x104, 0x00 },
    { "PORTJ", 0x105, 0x00 },
    { "PINK", 0x106, 0x00 },
    { "DDRK", 0x107, 0x00 },
    { "PORTK", 0x108, 0x00 },
    { "PINL", 0x109, 0x00 },
    { "DDRL", 0x10a, 0x00 },
    { "PORTL", 0x10b, 0x00 },
    { "TCCR5A", 0x120, 0x00 },
    { "TCCR5B", 0x121, 0x00 },
    { "TCCR5C", 0x122, 0x00 },
    { "TCNT5L", 0x124, 0x00 },
    { "TCNT5H", 0x125, 0x00 },
    { "ICR5L", 0x126, 0x00 },
    { "ICR5H", 0x127, 0x00 },
    { "OCR5AL", 0x128, 0x00 },
    { "OCR5AH", 0x129, 0x00 },
    { "OCR5BL", 0x12a, 0x00 },
    { "OCR5BH", 0x12b, 0x00 },
    { "OCR5CL", 0x12c, 0x00 },
    { "OCR5CH", 0x12d, 0x00 },
    { "UCSR3A", 0x130, 0x00 },
    { "UCSR3B", 0x131, 0x00 },
    { "UCSR3C", 0x132, 0x00 },
    { "UBRR3L", 0x134, 0x00 },
    { "UBRR3H", 0x135, 0x00 },
    { "UDR3", 0x136, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega2561_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "EIND", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR4A", 0xa0, 0x00 },
    { "TCCR4B", 0xa1, 0x00 },
    { "TCCR4C", 0xa2, 0x00 },
    { "TCNT4L", 0xa4, 0x00 },
    { "TCNT4H", 0xa5, 0x00 },
    { "ICR4L", 0xa6, 0x00 },
    { "ICR4H", 0xa7, 0x00 },
    { "OCR4AL", 0xa8, 0x00 },
    { "OCR4AH", 0xa9, 0x00 },
    { "OCR4BL", 0xaa, 0x00 },
    { "OCR4BH", 0xab, 0x00 },
    { "OCR4CL", 0xac, 0x00 },
    { "OCR4CH", 0xad, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "TCCR5A", 0x120, 0x00 },
    { "TCCR5B", 0x121, 0x00 },
    { "TCCR5C", 0x122, 0x00 },
    { "TCNT5L", 0x124, 0x00 },
    { "TCNT5H", 0x125, 0x00 },
    { "ICR5L", 0x126, 0x00 },
    { "ICR5H", 0x127, 0x00 },
    { "OCR5AL", 0x128, 0x00 },
    { "OCR5AH", 0x129, 0x00 },
    { "OCR5BL", 0x12a, 0x00 },
    { "OCR5BH", 0x12b, 0x00 },
    { "OCR5CL", 0x12c, 0x00 },
    { "OCR5CH", 0x12d, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega48_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega88_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega168_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny13_io_registers[] =
{
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "DIDR0", 0x34, 0x00 },
    { "PCMSK", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEAR -- EEARL", 0x3e, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "GTCCR", 0x48, 0x00 },
    { "OCR0B", 0x49, 0x00 },
    { "DWDR", 0x4e, 0x00 },
    { "TCCR0A", 0x4f, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "OCR0A", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR0", 0x58, 0x00 },
    { "TIMSK0", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL -- SP", 0x5d, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny2313_io_registers[] =
{
    { "DIDR", 0x21, 0x00 },
    { "UBRRH", 0x22, 0x00 },
    { "UCSRC", 0x23, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "UBRRL", 0x29, 0x00 },
    { "UCSRB", 0x2a, 0x00 },
    { "UCSRA", 0x2b, 0x00 },
    { "UDR -- RXB -- TXB", 0x2c, IO_REG_RSE },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "PIND", 0x30, 0x00 },
    { "DDRD", 0x31, 0x00 },
    { "PORTD", 0x32, 0x00 },
    { "GPIOR0", 0x33, 0x00 },
    { "GPIOR1", 0x34, 0x00 },
    { "GPIOR2", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEAR -- EEARL", 0x3e, 0x00 },
    { "PCMSK", 0x40, 0x00 },
    { "WDTCSR", 0x41, 0x00 },
    { "TCCR1C", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "ICR1L", 0x44, 0x00 },
    { "ICR1H", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "OCR1BL", 0x48, 0x00 },
    { "OCR1BH", 0x49, 0x00 },
    { "OCR1L -- OCR1AL", 0x4a, 0x00 },
    { "OCR1H -- OCR1AH", 0x4b, 0x00 },
    { "TCNT1L", 0x4c, 0x00 },
    { "TCNT1H", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "TCCR0A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "OCR0A", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "EIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "OCR0B", 0x5c, 0x00 },
    { "SPL -- SP", 0x5d, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90pwm2_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "GPIOR3", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR", 0x51, 0x00 },
    { "MSMCR", 0x52, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x76, 0x00 },
    { "AMP1CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "PIFR0", 0xa0, 0x00 },
    { "PIM0", 0xa1, 0x00 },
    { "PIFR1", 0xa2, 0x00 },
    { "PIM1", 0xa3, 0x00 },
    { "PIFR2", 0xa4, 0x00 },
    { "PIM2", 0xa5, 0x00 },
    { "DACON", 0xaa, 0x00 },
    { "DACL", 0xab, 0x00 },
    { "DACH", 0xac, 0x00 },
    { "AC0CON", 0xad, 0x00 },
    { "AC1CON", 0xae, 0x00 },
    { "AC2CON", 0xaf, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { "EUCSRA", 0xc8, 0x00 },
    { "EUCSRB", 0xc9, 0x00 },
    { "EUCSRC", 0xca, 0x00 },
    { "MUBRRL", 0xcc, 0x00 },
    { "MUBRRH", 0xcd, 0x00 },
    { "EUDR", 0xce, 0x00 },
    { "PSOC0", 0xd0, 0x00 },
    { "OCR0SAL", 0xd2, 0x00 },
    { "OCR0SAH", 0xd3, 0x00 },
    { "OCR0RAL", 0xd4, 0x00 },
    { "OCR0RAH", 0xd5, 0x00 },
    { "OCR0SBL", 0xd6, 0x00 },
    { "OCR0SBH", 0xd7, 0x00 },
    { "OCR0RBL", 0xd8, 0x00 },
    { "OCR0RBH", 0xd9, 0x00 },
    { "PCNF0", 0xda, 0x00 },
    { "PCTL0", 0xdb, 0x00 },
    { "PFRC0A", 0xdc, 0x00 },
    { "PFRC0B", 0xdd, 0x00 },
    { "PICR0L", 0xde, 0x00 },
    { "PICR0H", 0xdf, 0x00 },
    { "PSOC1", 0xe0, 0x00 },
    { "OCR1SAL", 0xe2, 0x00 },
    { "OCR1SAH", 0xe3, 0x00 },
    { "OCR1RAL", 0xe4, 0x00 },
    { "OCR1RAH", 0xe5, 0x00 },
    { "OCR1SBL", 0xe6, 0x00 },
    { "OCR1SBH", 0xe7, 0x00 },
    { "OCR1RBL", 0xe8, 0x00 },
    { "OCR1RBH", 0xe9, 0x00 },
    { "PCNF1", 0xea, 0x00 },
    { "PCTL1", 0xeb, 0x00 },
    { "PFRC1A", 0xec, 0x00 },
    { "PFRC1B", 0xed, 0x00 },
    { "PICR1L", 0xee, 0x00 },
    { "PICR1H", 0xef, 0x00 },
    { "PSOC2", 0xf0, 0x00 },
    { "POM2", 0xf1, 0x00 },
    { "OCR2SAL", 0xf2, 0x00 },
    { "OCR2SAH", 0xf3, 0x00 },
    { "OCR2RAL", 0xf4, 0x00 },
    { "OCR2RAH", 0xf5, 0x00 },
    { "OCR2SBL", 0xf6, 0x00 },
    { "OCR2SBH", 0xf7, 0x00 },
    { "OCR2RBL", 0xf8, 0x00 },
    { "OCR2RBH", 0xf9, 0x00 },
    { "PCNF2", 0xfa, 0x00 },
    { "PCTL2", 0xfb, 0x00 },
    { "PFRC2A", 0xfc, 0x00 },
    { "PFRC2B", 0xfd, 0x00 },
    { "PICR2L", 0xfe, 0x00 },
    { "PICR2H", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90pwm3_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "GPIOR3", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR", 0x51, 0x00 },
    { "MSMCR", 0x52, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x76, 0x00 },
    { "AMP1CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "PIFR0", 0xa0, 0x00 },
    { "PIM0", 0xa1, 0x00 },
    { "PIFR1", 0xa2, 0x00 },
    { "PIM1", 0xa3, 0x00 },
    { "PIFR2", 0xa4, 0x00 },
    { "PIM2", 0xa5, 0x00 },
    { "DACON", 0xaa, 0x00 },
    { "DACL", 0xab, 0x00 },
    { "DACH", 0xac, 0x00 },
    { "AC0CON", 0xad, 0x00 },
    { "AC1CON", 0xae, 0x00 },
    { "AC2CON", 0xaf, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { "EUCSRA", 0xc8, 0x00 },
    { "EUCSRB", 0xc9, 0x00 },
    { "EUCSRC", 0xca, 0x00 },
    { "MUBRRL", 0xcc, 0x00 },
    { "MUBRRH", 0xcd, 0x00 },
    { "EUDR", 0xce, 0x00 },
    { "PSOC0", 0xd0, 0x00 },
    { "OCR0SAL", 0xd2, 0x00 },
    { "OCR0SAH", 0xd3, 0x00 },
    { "OCR0RAL", 0xd4, 0x00 },
    { "OCR0RAH", 0xd5, 0x00 },
    { "OCR0SBL", 0xd6, 0x00 },
    { "OCR0SBH", 0xd7, 0x00 },
    { "OCR0RBL", 0xd8, 0x00 },
    { "OCR0RBH", 0xd9, 0x00 },
    { "PCNF0", 0xda, 0x00 },
    { "PCTL0", 0xdb, 0x00 },
    { "PFRC0A", 0xdc, 0x00 },
    { "PFRC0B", 0xdd, 0x00 },
    { "PICR0L", 0xde, 0x00 },
    { "PICR0H", 0xdf, 0x00 },
    { "PSOC1", 0xe0, 0x00 },
    { "OCR1SAL", 0xe2, 0x00 },
    { "OCR1SAH", 0xe3, 0x00 },
    { "OCR1RAL", 0xe4, 0x00 },
    { "OCR1RAH", 0xe5, 0x00 },
    { "OCR1SBL", 0xe6, 0x00 },
    { "OCR1SBH", 0xe7, 0x00 },
    { "OCR1RBL", 0xe8, 0x00 },
    { "OCR1RBH", 0xe9, 0x00 },
    { "PCNF1", 0xea, 0x00 },
    { "PCTL1", 0xeb, 0x00 },
    { "PFRC1A", 0xec, 0x00 },
    { "PFRC1B", 0xed, 0x00 },
    { "PICR1L", 0xee, 0x00 },
    { "PICR1H", 0xef, 0x00 },
    { "PSOC2", 0xf0, 0x00 },
    { "POM2", 0xf1, 0x00 },
    { "OCR2SAL", 0xf2, 0x00 },
    { "OCR2SAH", 0xf3, 0x00 },
    { "OCR2RAL", 0xf4, 0x00 },
    { "OCR2RAH", 0xf5, 0x00 },
    { "OCR2SBL", 0xf6, 0x00 },
    { "OCR2SBH", 0xf7, 0x00 },
    { "OCR2RBL", 0xf8, 0x00 },
    { "OCR2RBH", 0xf9, 0x00 },
    { "PCNF2", 0xfa, 0x00 },
    { "PCTL2", 0xfb, 0x00 },
    { "PFRC2A", 0xfc, 0x00 },
    { "PFRC2B", 0xfd, 0x00 },
    { "PICR2L", 0xfe, 0x00 },
    { "PICR2H", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90pwm2b_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "GPIOR3", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x76, 0x00 },
    { "AMP1CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "PIFR0", 0xa0, 0x00 },
    { "PIM0", 0xa1, 0x00 },
    { "PIFR1", 0xa2, 0x00 },
    { "PIM1", 0xa3, 0x00 },
    { "PIFR2", 0xa4, 0x00 },
    { "PIM2", 0xa5, 0x00 },
    { "DACON", 0xaa, 0x00 },
    { "DACL", 0xab, 0x00 },
    { "DACH", 0xac, 0x00 },
    { "AC0CON", 0xad, 0x00 },
    { "AC1CON", 0xae, 0x00 },
    { "AC2CON", 0xaf, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { "EUCSRA", 0xc8, 0x00 },
    { "EUCSRB", 0xc9, 0x00 },
    { "EUCSRC", 0xca, 0x00 },
    { "MUBRRL", 0xcc, 0x00 },
    { "MUBRRH", 0xcd, 0x00 },
    { "EUDR", 0xce, 0x00 },
    { "PSOC0", 0xd0, 0x00 },
    { "OCR0SAL", 0xd2, 0x00 },
    { "OCR0SAH", 0xd3, 0x00 },
    { "OCR0RAL", 0xd4, 0x00 },
    { "OCR0RAH", 0xd5, 0x00 },
    { "OCR0SBL", 0xd6, 0x00 },
    { "OCR0SBH", 0xd7, 0x00 },
    { "OCR0RBL", 0xd8, 0x00 },
    { "OCR0RBH", 0xd9, 0x00 },
    { "PCNF0", 0xda, 0x00 },
    { "PCTL0", 0xdb, 0x00 },
    { "PFRC0A", 0xdc, 0x00 },
    { "PFRC0B", 0xdd, 0x00 },
    { "PICR0L", 0xde, 0x00 },
    { "PICR0H", 0xdf, 0x00 },
    { "PSOC1", 0xe0, 0x00 },
    { "OCR1SAL", 0xe2, 0x00 },
    { "OCR1SAH", 0xe3, 0x00 },
    { "OCR1RAL", 0xe4, 0x00 },
    { "OCR1RAH", 0xe5, 0x00 },
    { "OCR1SBL", 0xe6, 0x00 },
    { "OCR1SBH", 0xe7, 0x00 },
    { "OCR1RBL", 0xe8, 0x00 },
    { "OCR1RBH", 0xe9, 0x00 },
    { "PCNF1", 0xea, 0x00 },
    { "PCTL1", 0xeb, 0x00 },
    { "PFRC1A", 0xec, 0x00 },
    { "PFRC1B", 0xed, 0x00 },
    { "PICR1L", 0xee, 0x00 },
    { "PICR1H", 0xef, 0x00 },
    { "PSOC2", 0xf0, 0x00 },
    { "POM2", 0xf1, 0x00 },
    { "OCR2SAL", 0xf2, 0x00 },
    { "OCR2SAH", 0xf3, 0x00 },
    { "OCR2RAL", 0xf4, 0x00 },
    { "OCR2RAH", 0xf5, 0x00 },
    { "OCR2SBL", 0xf6, 0x00 },
    { "OCR2SBH", 0xf7, 0x00 },
    { "OCR2RBL", 0xf8, 0x00 },
    { "OCR2RBH", 0xf9, 0x00 },
    { "PCNF2", 0xfa, 0x00 },
    { "PCTL2", 0xfb, 0x00 },
    { "PFRC2A", 0xfc, 0x00 },
    { "PFRC2B", 0xfd, 0x00 },
    { "PICR2L", 0xfe, 0x00 },
    { "PICR2H", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90pwm3b_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "GPIOR3", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x76, 0x00 },
    { "AMP1CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "PIFR0", 0xa0, 0x00 },
    { "PIM0", 0xa1, 0x00 },
    { "PIFR1", 0xa2, 0x00 },
    { "PIM1", 0xa3, 0x00 },
    { "PIFR2", 0xa4, 0x00 },
    { "PIM2", 0xa5, 0x00 },
    { "DACON", 0xaa, 0x00 },
    { "DACL", 0xab, 0x00 },
    { "DACH", 0xac, 0x00 },
    { "AC0CON", 0xad, 0x00 },
    { "AC1CON", 0xae, 0x00 },
    { "AC2CON", 0xaf, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { "EUCSRA", 0xc8, 0x00 },
    { "EUCSRB", 0xc9, 0x00 },
    { "EUCSRC", 0xca, 0x00 },
    { "MUBRRL", 0xcc, 0x00 },
    { "MUBRRH", 0xcd, 0x00 },
    { "EUDR", 0xce, 0x00 },
    { "PSOC0", 0xd0, 0x00 },
    { "OCR0SAL", 0xd2, 0x00 },
    { "OCR0SAH", 0xd3, 0x00 },
    { "OCR0RAL", 0xd4, 0x00 },
    { "OCR0RAH", 0xd5, 0x00 },
    { "OCR0SBL", 0xd6, 0x00 },
    { "OCR0SBH", 0xd7, 0x00 },
    { "OCR0RBL", 0xd8, 0x00 },
    { "OCR0RBH", 0xd9, 0x00 },
    { "PCNF0", 0xda, 0x00 },
    { "PCTL0", 0xdb, 0x00 },
    { "PFRC0A", 0xdc, 0x00 },
    { "PFRC0B", 0xdd, 0x00 },
    { "PICR0L", 0xde, 0x00 },
    { "PICR0H", 0xdf, 0x00 },
    { "PSOC1", 0xe0, 0x00 },
    { "OCR1SAL", 0xe2, 0x00 },
    { "OCR1SAH", 0xe3, 0x00 },
    { "OCR1RAL", 0xe4, 0x00 },
    { "OCR1RAH", 0xe5, 0x00 },
    { "OCR1SBL", 0xe6, 0x00 },
    { "OCR1SBH", 0xe7, 0x00 },
    { "OCR1RBL", 0xe8, 0x00 },
    { "OCR1RBH", 0xe9, 0x00 },
    { "PCNF1", 0xea, 0x00 },
    { "PCTL1", 0xeb, 0x00 },
    { "PFRC1A", 0xec, 0x00 },
    { "PFRC1B", 0xed, 0x00 },
    { "PICR1L", 0xee, 0x00 },
    { "PICR1H", 0xef, 0x00 },
    { "PSOC2", 0xf0, 0x00 },
    { "POM2", 0xf1, 0x00 },
    { "OCR2SAL", 0xf2, 0x00 },
    { "OCR2SAH", 0xf3, 0x00 },
    { "OCR2RAL", 0xf4, 0x00 },
    { "OCR2RAH", 0xf5, 0x00 },
    { "OCR2SBL", 0xf6, 0x00 },
    { "OCR2SBH", 0xf7, 0x00 },
    { "OCR2RBL", 0xf8, 0x00 },
    { "OCR2RBH", 0xf9, 0x00 },
    { "PCNF2", 0xfa, 0x00 },
    { "PCTL2", 0xfb, 0x00 },
    { "PFRC2A", 0xfc, 0x00 },
    { "PFRC2B", 0xfd, 0x00 },
    { "PICR2L", 0xfe, 0x00 },
    { "PICR2H", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny24_io_registers[] =
{
    { "PRR", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "TIFR1", 0x2b, 0x00 },
    { "TIMSK1", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "PCMSK0", 0x32, 0x00 },
    { "GPIOR0", 0x33, 0x00 },
    { "GPIOR1", 0x34, 0x00 },
    { "GPIOR2", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "PCMSK1", 0x40, 0x00 },
    { "WDTCSR", 0x41, 0x00 },
    { "TCCR1C", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "ICR1L", 0x44, 0x00 },
    { "ICR1H", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "DWDR", 0x47, 0x00 },
    { "OCR1BL -- OCRB1L", 0x48, 0x00 },
    { "OCR1BH -- OCRB1H", 0x49, 0x00 },
    { "OCR1AL -- OCRA1L", 0x4a, 0x00 },
    { "OCR1AH -- OCRA1H", 0x4b, 0x00 },
    { "TCNT1L", 0x4c, 0x00 },
    { "TCNT1H", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "TCCR0A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "OCR0A", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR0", 0x58, 0x00 },
    { "TIMSK0", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "OCR0B", 0x5c, 0x00 },
    { "SPL -- SP", 0x5d, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny44_io_registers[] =
{
    { "PRR", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "TIFR1", 0x2b, 0x00 },
    { "TIMSK1", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "PCMSK0", 0x32, 0x00 },
    { "GPIOR0", 0x33, 0x00 },
    { "GPIOR1", 0x34, 0x00 },
    { "GPIOR2", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "PCMSK1", 0x40, 0x00 },
    { "WDTCSR", 0x41, 0x00 },
    { "TCCR1C", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "ICR1L", 0x44, 0x00 },
    { "ICR1H", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "DWDR", 0x47, 0x00 },
    { "OCR1BL -- OCRB1L", 0x48, 0x00 },
    { "OCR1BH -- OCRB1H", 0x49, 0x00 },
    { "OCR1AL -- OCRA1L", 0x4a, 0x00 },
    { "OCR1AH -- OCRA1H", 0x4b, 0x00 },
    { "TCNT1L", 0x4c, 0x00 },
    { "TCNT1H", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "TCCR0A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "OCR0A", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR0", 0x58, 0x00 },
    { "TIMSK0", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "OCR0B", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny84_io_registers[] =
{
    { "PRR", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "TIFR1", 0x2b, 0x00 },
    { "TIMSK1", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "PCMSK0", 0x32, 0x00 },
    { "GPIOR0", 0x33, 0x00 },
    { "GPIOR1", 0x34, 0x00 },
    { "GPIOR2", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "PCMSK1", 0x40, 0x00 },
    { "WDTCSR", 0x41, 0x00 },
    { "TCCR1C", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "ICR1L", 0x44, 0x00 },
    { "ICR1H", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "DWDR", 0x47, 0x00 },
    { "OCR1BL -- OCRB1L", 0x48, 0x00 },
    { "OCR1BH -- OCRB1H", 0x49, 0x00 },
    { "OCR1AL -- OCRA1L", 0x4a, 0x00 },
    { "OCR1AH -- OCRA1H", 0x4b, 0x00 },
    { "TCNT1L", 0x4c, 0x00 },
    { "TCNT1H", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "TCCR0A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "OCR0A", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR0", 0x58, 0x00 },
    { "TIMSK0", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "OCR0B", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny25_io_registers[] =
{
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "GPIOR0", 0x31, 0x00 },
    { "GPIOR1", 0x32, 0x00 },
    { "GPIOR2", 0x33, 0x00 },
    { "DIDR0", 0x34, 0x00 },
    { "PCMSK", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "PRR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "DWDR", 0x42, 0x00 },
    { "DTPS1", 0x43, 0x00 },
    { "DT1B", 0x44, 0x00 },
    { "DT1A", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "PLLCSR", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "OCR0A", 0x49, 0x00 },
    { "TCCR0A", 0x4a, 0x00 },
    { "OCR1B", 0x4b, 0x00 },
    { "GTCCR", 0x4c, 0x00 },
    { "OCR1C", 0x4d, 0x00 },
    { "OCR1A", 0x4e, 0x00 },
    { "TCNT1", 0x4f, 0x00 },
    { "TCCR1", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL -- SP", 0x5d, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny45_io_registers[] =
{
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "GPIOR0", 0x31, 0x00 },
    { "GPIOR1", 0x32, 0x00 },
    { "GPIOR2", 0x33, 0x00 },
    { "DIDR0", 0x34, 0x00 },
    { "PCMSK", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "PRR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "DWDR", 0x42, 0x00 },
    { "DTPS1", 0x43, 0x00 },
    { "DT1B", 0x44, 0x00 },
    { "DT1A", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "PLLCSR", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "OCR0A", 0x49, 0x00 },
    { "TCCR0A", 0x4a, 0x00 },
    { "OCR1B", 0x4b, 0x00 },
    { "GTCCR", 0x4c, 0x00 },
    { "OCR1C", 0x4d, 0x00 },
    { "OCR1A", 0x4e, 0x00 },
    { "TCNT1", 0x4f, 0x00 },
    { "TCCR1", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny85_io_registers[] =
{
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "GPIOR0", 0x31, 0x00 },
    { "GPIOR1", 0x32, 0x00 },
    { "GPIOR2", 0x33, 0x00 },
    { "DIDR0", 0x34, 0x00 },
    { "PCMSK", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "PRR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "DWDR", 0x42, 0x00 },
    { "DTPS1", 0x43, 0x00 },
    { "DT1B", 0x44, 0x00 },
    { "DT1A", 0x45, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "PLLCSR", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "OCR0A", 0x49, 0x00 },
    { "TCCR0A", 0x4a, 0x00 },
    { "OCR1B", 0x4b, 0x00 },
    { "GTCCR", 0x4c, 0x00 },
    { "OCR1C", 0x4d, 0x00 },
    { "OCR1A", 0x4e, 0x00 },
    { "TCNT1", 0x4f, 0x00 },
    { "TCCR1", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny261_io_registers[] =
{
    { "TCCR1E", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "DIDR1", 0x22, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSRA", 0x28, 0x00 },
    { "ACSRB", 0x29, 0x00 },
    { "GPIOR0", 0x2a, 0x00 },
    { "GPIOR1", 0x2b, 0x00 },
    { "GPIOR2", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "USIPP", 0x31, 0x00 },
    { "OCR0B", 0x32, 0x00 },
    { "OCR0A", 0x33, 0x00 },
    { "TCNT0H", 0x34, 0x00 },
    { "TCCR0A", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "DWDR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "PCMSK1", 0x42, 0x00 },
    { "PCMSK0", 0x43, 0x00 },
    { "DT1", 0x44, 0x00 },
    { "TC1H", 0x45, 0x00 },
    { "TCCR1D", 0x46, 0x00 },
    { "TCCR1C", 0x47, 0x00 },
    { "CLKPR", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "OCR1D", 0x4a, 0x00 },
    { "OCR1C", 0x4b, 0x00 },
    { "OCR1B", 0x4c, 0x00 },
    { "OCR1A", 0x4d, 0x00 },
    { "TCNT1", 0x4e, 0x00 },
    { "TCCR1B", 0x4f, 0x00 },
    { "TCCR1A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0L", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "PRR", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL -- SP", 0x5d, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny461_io_registers[] =
{
    { "TCCR1E", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "DIDR1", 0x22, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSRA", 0x28, 0x00 },
    { "ACSRB", 0x29, 0x00 },
    { "GPIOR0", 0x2a, 0x00 },
    { "GPIOR1", 0x2b, 0x00 },
    { "GPIOR2", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "USIPP", 0x31, 0x00 },
    { "OCR0B", 0x32, 0x00 },
    { "OCR0A", 0x33, 0x00 },
    { "TCNT0H", 0x34, 0x00 },
    { "TCCR0A", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "DWDR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "PCMSK1", 0x42, 0x00 },
    { "PCMSK0", 0x43, 0x00 },
    { "DT1", 0x44, 0x00 },
    { "TC1H", 0x45, 0x00 },
    { "TCCR1D", 0x46, 0x00 },
    { "TCCR1C", 0x47, 0x00 },
    { "CLKPR", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "OCR1D", 0x4a, 0x00 },
    { "OCR1C", 0x4b, 0x00 },
    { "OCR1B", 0x4c, 0x00 },
    { "OCR1A", 0x4d, 0x00 },
    { "TCNT1", 0x4e, 0x00 },
    { "TCCR1B", 0x4f, 0x00 },
    { "TCCR1A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0L", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "PRR", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny861_io_registers[] =
{
    { "TCCR1E", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "DIDR1", 0x22, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSRA", 0x28, 0x00 },
    { "ACSRB", 0x29, 0x00 },
    { "GPIOR0", 0x2a, 0x00 },
    { "GPIOR1", 0x2b, 0x00 },
    { "GPIOR2", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "USIPP", 0x31, 0x00 },
    { "OCR0B", 0x32, 0x00 },
    { "OCR0A", 0x33, 0x00 },
    { "TCNT0H", 0x34, 0x00 },
    { "TCCR0A", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "EEARH", 0x3f, 0x00 },
    { "DWDR", 0x40, 0x00 },
    { "WDTCR", 0x41, 0x00 },
    { "PCMSK1", 0x42, 0x00 },
    { "PCMSK0", 0x43, 0x00 },
    { "DT1", 0x44, 0x00 },
    { "TC1H", 0x45, 0x00 },
    { "TCCR1D", 0x46, 0x00 },
    { "TCCR1C", 0x47, 0x00 },
    { "CLKPR", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "OCR1D", 0x4a, 0x00 },
    { "OCR1C", 0x4b, 0x00 },
    { "OCR1B", 0x4c, 0x00 },
    { "OCR1A", 0x4d, 0x00 },
    { "TCNT1", 0x4e, 0x00 },
    { "TCCR1B", 0x4f, 0x00 },
    { "TCCR1A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0L", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "PRR", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR", 0x58, 0x00 },
    { "TIMSK", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega32c1_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "DWDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6a, 0x00 },
    { "PCMSK1", 0x6b, 0x00 },
    { "PCMSK2", 0x6c, 0x00 },
    { "PCMSK3", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x75, 0x00 },
    { "AMP1CSR", 0x76, 0x00 },
    { "AMP2CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "DACON", 0x90, 0x00 },
    { "DACL", 0x91, 0x00 },
    { "DACH", 0x92, 0x00 },
    { "AC0CON", 0x94, 0x00 },
    { "AC1CON", 0x95, 0x00 },
    { "AC2CON", 0x96, 0x00 },
    { "AC3CON", 0x97, 0x00 },
    { "LINCR", 0xc8, 0x00 },
    { "LINSIR", 0xc9, 0x00 },
    { "LINENIR", 0xca, 0x00 },
    { "LINERR", 0xcb, 0x00 },
    { "LINBTR", 0xcc, 0x00 },
    { "LINBRRL", 0xcd, 0x00 },
    { "LINBRRH", 0xce, 0x00 },
    { "LINDLR", 0xcf, 0x00 },
    { "LINIDR", 0xd0, 0x00 },
    { "LINSEL", 0xd1, 0x00 },
    { "LINDAT", 0xd2, 0x00 },
    { "CANGCON", 0xd8, 0x00 },
    { "CANGSTA", 0xd9, 0x00 },
    { "CANGIT", 0xda, 0x00 },
    { "CANGIE", 0xdb, 0x00 },
    { "CANEN2", 0xdc, 0x00 },
    { "CANEN1", 0xdd, 0x00 },
    { "CANIE2", 0xde, 0x00 },
    { "CANIE1", 0xdf, 0x00 },
    { "CANSIT2", 0xe0, 0x00 },
    { "CANSIT1", 0xe1, 0x00 },
    { "CANBT1", 0xe2, 0x00 },
    { "CANBT2", 0xe3, 0x00 },
    { "CANBT3", 0xe4, 0x00 },
    { "CANTCON", 0xe5, 0x00 },
    { "CANTIML", 0xe6, 0x00 },
    { "CANTIMH", 0xe7, 0x00 },
    { "CANTTCL", 0xe8, 0x00 },
    { "CANTTCH", 0xe9, 0x00 },
    { "CANTEC", 0xea, 0x00 },
    { "CANREC", 0xeb, 0x00 },
    { "CANHPMOB", 0xec, 0x00 },
    { "CANPAGE", 0xed, 0x00 },
    { "CANSTMOB", 0xee, 0x00 },
    { "CANCDMOB", 0xef, 0x00 },
    { "CANIDT4", 0xf0, 0x00 },
    { "CANIDT3", 0xf1, 0x00 },
    { "CANIDT2", 0xf2, 0x00 },
    { "CANIDT1", 0xf3, 0x00 },
    { "CANIDM4", 0xf4, 0x00 },
    { "CANIDM3", 0xf5, 0x00 },
    { "CANIDM2", 0xf6, 0x00 },
    { "CANIDM1", 0xf7, 0x00 },
    { "CANSTML", 0xf8, 0x00 },
    { "CANSTMH", 0xf9, 0x00 },
    { "CANMSG", 0xfa, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega32m1_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "DWDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6a, 0x00 },
    { "PCMSK1", 0x6b, 0x00 },
    { "PCMSK2", 0x6c, 0x00 },
    { "PCMSK3", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x75, 0x00 },
    { "AMP1CSR", 0x76, 0x00 },
    { "AMP2CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "DACON", 0x90, 0x00 },
    { "DACL", 0x91, 0x00 },
    { "DACH", 0x92, 0x00 },
    { "AC0CON", 0x94, 0x00 },
    { "AC1CON", 0x95, 0x00 },
    { "AC2CON", 0x96, 0x00 },
    { "AC3CON", 0x97, 0x00 },
    { "POCR0SAL", 0xa0, 0x00 },
    { "POCR0SAH", 0xa1, 0x00 },
    { "POCR0RAL", 0xa2, 0x00 },
    { "POCR0RAH", 0xa3, 0x00 },
    { "POCR0SBL", 0xa4, 0x00 },
    { "POCR0SBH", 0xa5, 0x00 },
    { "POCR1SAL", 0xa6, 0x00 },
    { "POCR1SAH", 0xa7, 0x00 },
    { "POCR1RAL", 0xa8, 0x00 },
    { "POCR1RAH", 0xa9, 0x00 },
    { "POCR1SBL", 0xaa, 0x00 },
    { "POCR1SBH", 0xab, 0x00 },
    { "POCR2SAL", 0xac, 0x00 },
    { "POCR2SAH", 0xad, 0x00 },
    { "POCR2RAL", 0xae, 0x00 },
    { "POCR2RAH", 0xaf, 0x00 },
    { "POCR2SBL", 0xb0, 0x00 },
    { "POCR2SBH", 0xb1, 0x00 },
    { "POCRxRBL -- POCR_RBL", 0xb2, 0x00 },
    { "POCRxRBH -- POCR_RBH", 0xb3, 0x00 },
    { "PSYNC", 0xb4, 0x00 },
    { "PCNF", 0xb5, 0x00 },
    { "POC", 0xb6, 0x00 },
    { "PCTL", 0xb7, 0x00 },
    { "PMIC0", 0xb8, 0x00 },
    { "PMIC1", 0xb9, 0x00 },
    { "PMIC2", 0xba, 0x00 },
    { "PIM", 0xbb, 0x00 },
    { "PIFR", 0xbc, 0x00 },
    { "LINCR", 0xc8, 0x00 },
    { "LINSIR", 0xc9, 0x00 },
    { "LINENIR", 0xca, 0x00 },
    { "LINERR", 0xcb, 0x00 },
    { "LINBTR", 0xcc, 0x00 },
    { "LINBRRL", 0xcd, 0x00 },
    { "LINBRRH", 0xce, 0x00 },
    { "LINDLR", 0xcf, 0x00 },
    { "LINIDR", 0xd0, 0x00 },
    { "LINSEL", 0xd1, 0x00 },
    { "LINDAT", 0xd2, 0x00 },
    { "CANGCON", 0xd8, 0x00 },
    { "CANGSTA", 0xd9, 0x00 },
    { "CANGIT", 0xda, 0x00 },
    { "CANGIE", 0xdb, 0x00 },
    { "CANEN2", 0xdc, 0x00 },
    { "CANEN1", 0xdd, 0x00 },
    { "CANIE2", 0xde, 0x00 },
    { "CANIE1", 0xdf, 0x00 },
    { "CANSIT2", 0xe0, 0x00 },
    { "CANSIT1", 0xe1, 0x00 },
    { "CANBT1", 0xe2, 0x00 },
    { "CANBT2", 0xe3, 0x00 },
    { "CANBT3", 0xe4, 0x00 },
    { "CANTCON", 0xe5, 0x00 },
    { "CANTIML", 0xe6, 0x00 },
    { "CANTIMH", 0xe7, 0x00 },
    { "CANTTCL", 0xe8, 0x00 },
    { "CANTTCH", 0xe9, 0x00 },
    { "CANTEC", 0xea, 0x00 },
    { "CANREC", 0xeb, 0x00 },
    { "CANHPMOB", 0xec, 0x00 },
    { "CANPAGE", 0xed, 0x00 },
    { "CANSTMOB", 0xee, 0x00 },
    { "CANCDMOB", 0xef, 0x00 },
    { "CANIDT4", 0xf0, 0x00 },
    { "CANIDT3", 0xf1, 0x00 },
    { "CANIDT2", 0xf2, 0x00 },
    { "CANIDT1", 0xf3, 0x00 },
    { "CANIDM4", 0xf4, 0x00 },
    { "CANIDM3", 0xf5, 0x00 },
    { "CANIDM2", 0xf6, 0x00 },
    { "CANIDM1", 0xf7, 0x00 },
    { "CANSTML", 0xf8, 0x00 },
    { "CANSTMH", 0xf9, 0x00 },
    { "CANMSG", 0xfa, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90can32_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "CANGCON", 0xd8, 0x00 },
    { "CANGSTA", 0xd9, 0x00 },
    { "CANGIT", 0xda, 0x00 },
    { "CANGIE", 0xdb, 0x00 },
    { "CANEN2", 0xdc, 0x00 },
    { "CANEN1", 0xdd, 0x00 },
    { "CANIE2", 0xde, 0x00 },
    { "CANIE1", 0xdf, 0x00 },
    { "CANSIT2", 0xe0, 0x00 },
    { "CANSIT1", 0xe1, 0x00 },
    { "CANBT1", 0xe2, 0x00 },
    { "CANBT2", 0xe3, 0x00 },
    { "CANBT3", 0xe4, 0x00 },
    { "CANTCON", 0xe5, 0x00 },
    { "CANTIML", 0xe6, 0x00 },
    { "CANTIMH", 0xe7, 0x00 },
    { "CANTTCL", 0xe8, 0x00 },
    { "CANTTCH", 0xe9, 0x00 },
    { "CANTEC", 0xea, 0x00 },
    { "CANREC", 0xeb, 0x00 },
    { "CANHPMOB", 0xec, 0x00 },
    { "CANPAGE", 0xed, 0x00 },
    { "CANSTMOB", 0xee, 0x00 },
    { "CANCDMOB", 0xef, 0x00 },
    { "CANIDT4", 0xf0, 0x00 },
    { "CANIDT3", 0xf1, 0x00 },
    { "CANIDT2", 0xf2, 0x00 },
    { "CANIDT1", 0xf3, 0x00 },
    { "CANIDM4", 0xf4, 0x00 },
    { "CANIDM3", 0xf5, 0x00 },
    { "CANIDM2", 0xf6, 0x00 },
    { "CANIDM1", 0xf7, 0x00 },
    { "CANSTML", 0xf8, 0x00 },
    { "CANSTMH", 0xf9, 0x00 },
    { "CANMSG", 0xfa, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90can64_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "CANGCON", 0xd8, 0x00 },
    { "CANGSTA", 0xd9, 0x00 },
    { "CANGIT", 0xda, 0x00 },
    { "CANGIE", 0xdb, 0x00 },
    { "CANEN2", 0xdc, 0x00 },
    { "CANEN1", 0xdd, 0x00 },
    { "CANIE2", 0xde, 0x00 },
    { "CANIE1", 0xdf, 0x00 },
    { "CANSIT2", 0xe0, 0x00 },
    { "CANSIT1", 0xe1, 0x00 },
    { "CANBT1", 0xe2, 0x00 },
    { "CANBT2", 0xe3, 0x00 },
    { "CANBT3", 0xe4, 0x00 },
    { "CANTCON", 0xe5, 0x00 },
    { "CANTIML", 0xe6, 0x00 },
    { "CANTIMH", 0xe7, 0x00 },
    { "CANTTCL", 0xe8, 0x00 },
    { "CANTTCH", 0xe9, 0x00 },
    { "CANTEC", 0xea, 0x00 },
    { "CANREC", 0xeb, 0x00 },
    { "CANHPMOB", 0xec, 0x00 },
    { "CANPAGE", 0xed, 0x00 },
    { "CANSTMOB", 0xee, 0x00 },
    { "CANCDMOB", 0xef, 0x00 },
    { "CANIDT4", 0xf0, 0x00 },
    { "CANIDT3", 0xf1, 0x00 },
    { "CANIDT2", 0xf2, 0x00 },
    { "CANIDT1", 0xf3, 0x00 },
    { "CANIDM4", 0xf4, 0x00 },
    { "CANIDM3", 0xf5, 0x00 },
    { "CANIDM2", 0xf6, 0x00 },
    { "CANIDM1", 0xf7, 0x00 },
    { "CANSTML", 0xf8, 0x00 },
    { "CANSTMH", 0xf9, 0x00 },
    { "CANMSG", 0xfa, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90pwm216_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "GPIOR3", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x76, 0x00 },
    { "AMP1CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "PIFR0", 0xa0, 0x00 },
    { "PIM0", 0xa1, 0x00 },
    { "PIFR1", 0xa2, 0x00 },
    { "PIM1", 0xa3, 0x00 },
    { "PIFR2", 0xa4, 0x00 },
    { "PIM2", 0xa5, 0x00 },
    { "DACON", 0xaa, 0x00 },
    { "DACL", 0xab, 0x00 },
    { "DACH", 0xac, 0x00 },
    { "AC0CON", 0xad, 0x00 },
    { "AC1CON", 0xae, 0x00 },
    { "AC2CON", 0xaf, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { "EUCSRA", 0xc8, 0x00 },
    { "EUCSRB", 0xc9, 0x00 },
    { "EUCSRC", 0xca, 0x00 },
    { "MUBRRL", 0xcc, 0x00 },
    { "MUBRRH", 0xcd, 0x00 },
    { "EUDR", 0xce, 0x00 },
    { "PSOC0", 0xd0, 0x00 },
    { "OCR0SAL", 0xd2, 0x00 },
    { "OCR0SAH", 0xd3, 0x00 },
    { "OCR0RAL", 0xd4, 0x00 },
    { "OCR0RAH", 0xd5, 0x00 },
    { "OCR0SBL", 0xd6, 0x00 },
    { "OCR0SBH", 0xd7, 0x00 },
    { "OCR0RBL", 0xd8, 0x00 },
    { "OCR0RBH", 0xd9, 0x00 },
    { "PCNF0", 0xda, 0x00 },
    { "PCTL0", 0xdb, 0x00 },
    { "PFRC0A", 0xdc, 0x00 },
    { "PFRC0B", 0xdd, 0x00 },
    { "PICR0L", 0xde, 0x00 },
    { "PICR0H", 0xdf, 0x00 },
    { "PSOC1", 0xe0, 0x00 },
    { "OCR1SAL", 0xe2, 0x00 },
    { "OCR1SAH", 0xe3, 0x00 },
    { "OCR1RAL", 0xe4, 0x00 },
    { "OCR1RAH", 0xe5, 0x00 },
    { "OCR1SBL", 0xe6, 0x00 },
    { "OCR1SBH", 0xe7, 0x00 },
    { "OCR1RBL", 0xe8, 0x00 },
    { "OCR1RBH", 0xe9, 0x00 },
    { "PCNF1", 0xea, 0x00 },
    { "PCTL1", 0xeb, 0x00 },
    { "PFRC1A", 0xec, 0x00 },
    { "PFRC1B", 0xed, 0x00 },
    { "PICR1L", 0xee, 0x00 },
    { "PICR1H", 0xef, 0x00 },
    { "PSOC2", 0xf0, 0x00 },
    { "POM2", 0xf1, 0x00 },
    { "OCR2SAL", 0xf2, 0x00 },
    { "OCR2SAH", 0xf3, 0x00 },
    { "OCR2RAL", 0xf4, 0x00 },
    { "OCR2RAH", 0xf5, 0x00 },
    { "OCR2SBL", 0xf6, 0x00 },
    { "OCR2SBH", 0xf7, 0x00 },
    { "OCR2RBL", 0xf8, 0x00 },
    { "OCR2RBH", 0xf9, 0x00 },
    { "PCNF2", 0xfa, 0x00 },
    { "PCTL2", 0xfb, 0x00 },
    { "PFRC2A", 0xfc, 0x00 },
    { "PFRC2B", 0xfd, 0x00 },
    { "PICR2L", 0xfe, 0x00 },
    { "PICR2H", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90pwm316_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "GPIOR1", 0x39, 0x00 },
    { "GPIOR2", 0x3a, 0x00 },
    { "GPIOR3", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMP0CSR", 0x76, 0x00 },
    { "AMP1CSR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "PIFR0", 0xa0, 0x00 },
    { "PIM0", 0xa1, 0x00 },
    { "PIFR1", 0xa2, 0x00 },
    { "PIM1", 0xa3, 0x00 },
    { "PIFR2", 0xa4, 0x00 },
    { "PIM2", 0xa5, 0x00 },
    { "DACON", 0xaa, 0x00 },
    { "DACL", 0xab, 0x00 },
    { "DACH", 0xac, 0x00 },
    { "AC0CON", 0xad, 0x00 },
    { "AC1CON", 0xae, 0x00 },
    { "AC2CON", 0xaf, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { "EUCSRA", 0xc8, 0x00 },
    { "EUCSRB", 0xc9, 0x00 },
    { "EUCSRC", 0xca, 0x00 },
    { "MUBRRL", 0xcc, 0x00 },
    { "MUBRRH", 0xcd, 0x00 },
    { "EUDR", 0xce, 0x00 },
    { "PSOC0", 0xd0, 0x00 },
    { "OCR0SAL", 0xd2, 0x00 },
    { "OCR0SAH", 0xd3, 0x00 },
    { "OCR0RAL", 0xd4, 0x00 },
    { "OCR0RAH", 0xd5, 0x00 },
    { "OCR0SBL", 0xd6, 0x00 },
    { "OCR0SBH", 0xd7, 0x00 },
    { "OCR0RBL", 0xd8, 0x00 },
    { "OCR0RBH", 0xd9, 0x00 },
    { "PCNF0", 0xda, 0x00 },
    { "PCTL0", 0xdb, 0x00 },
    { "PFRC0A", 0xdc, 0x00 },
    { "PFRC0B", 0xdd, 0x00 },
    { "PICR0L", 0xde, 0x00 },
    { "PICR0H", 0xdf, 0x00 },
    { "PSOC1", 0xe0, 0x00 },
    { "OCR1SAL", 0xe2, 0x00 },
    { "OCR1SAH", 0xe3, 0x00 },
    { "OCR1RAL", 0xe4, 0x00 },
    { "OCR1RAH", 0xe5, 0x00 },
    { "OCR1SBL", 0xe6, 0x00 },
    { "OCR1SBH", 0xe7, 0x00 },
    { "OCR1RBL", 0xe8, 0x00 },
    { "OCR1RBH", 0xe9, 0x00 },
    { "PCNF1", 0xea, 0x00 },
    { "PCTL1", 0xeb, 0x00 },
    { "PFRC1A", 0xec, 0x00 },
    { "PFRC1B", 0xed, 0x00 },
    { "PICR1L", 0xee, 0x00 },
    { "PICR1H", 0xef, 0x00 },
    { "PSOC2", 0xf0, 0x00 },
    { "POM2", 0xf1, 0x00 },
    { "OCR2SAL", 0xf2, 0x00 },
    { "OCR2SAH", 0xf3, 0x00 },
    { "OCR2RAL", 0xf4, 0x00 },
    { "OCR2RAH", 0xf5, 0x00 },
    { "OCR2SBL", 0xf6, 0x00 },
    { "OCR2SBH", 0xf7, 0x00 },
    { "OCR2RBL", 0xf8, 0x00 },
    { "OCR2RBH", 0xf9, 0x00 },
    { "PCNF2", 0xfa, 0x00 },
    { "PCTL2", 0xfb, 0x00 },
    { "PFRC2A", 0xfc, 0x00 },
    { "PFRC2B", 0xfd, 0x00 },
    { "PICR2L", 0xfe, 0x00 },
    { "PICR2H", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90usb1287_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "UHCON", 0x9e, 0x00 },
    { "UHINT", 0x9f, 0x00 },
    { "UHIEN", 0xa0, 0x00 },
    { "UHADDR", 0xa1, 0x00 },
    { "UHFNUML", 0xa2, 0x00 },
    { "UHFNUMH", 0xa3, 0x00 },
    { "UHFLEN", 0xa4, 0x00 },
    { "UPINRQX", 0xa5, 0x00 },
    { "UPINTX", 0xa6, 0x00 },
    { "UPNUM", 0xa7, 0x00 },
    { "UPRST", 0xa8, 0x00 },
    { "UPCONX", 0xa9, 0x00 },
    { "UPCFG0X", 0xaa, 0x00 },
    { "UPCFG1X", 0xab, 0x00 },
    { "UPSTAX", 0xac, 0x00 },
    { "UPCFG2X", 0xad, 0x00 },
    { "UPIENX", 0xae, 0x00 },
    { "UPDATX", 0xaf, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "UHWCON", 0xd7, 0x00 },
    { "USBCON", 0xd8, 0x00 },
    { "USBSTA", 0xd9, 0x00 },
    { "USBINT", 0xda, 0x00 },
    { "UDPADDL", 0xdb, 0x00 },
    { "UDPADDH", 0xdc, 0x00 },
    { "OTGCON", 0xdd, 0x00 },
    { "OTGIEN", 0xde, 0x00 },
    { "OTGINT", 0xdf, 0x00 },
    { "UDCON", 0xe0, 0x00 },
    { "UDINT", 0xe1, 0x00 },
    { "UDIEN", 0xe2, 0x00 },
    { "UDADDR", 0xe3, 0x00 },
    { "UDFNUML", 0xe4, 0x00 },
    { "UDFNUMH", 0xe5, 0x00 },
    { "UDMFN", 0xe6, 0x00 },
    { "UDTST", 0xe7, 0x00 },
    { "UEINTX", 0xe8, 0x00 },
    { "UENUM", 0xe9, 0x00 },
    { "UERST", 0xea, 0x00 },
    { "UECONX", 0xeb, 0x00 },
    { "UECFG0X", 0xec, 0x00 },
    { "UECFG1X", 0xed, 0x00 },
    { "UESTA0X", 0xee, 0x00 },
    { "UESTA1X", 0xef, 0x00 },
    { "UEIENX", 0xf0, 0x00 },
    { "UEDATX", 0xf1, 0x00 },
    { "UEBCLX", 0xf2, 0x00 },
    { "UEBCHX", 0xf3, 0x00 },
    { "UEINT", 0xf4, 0x00 },
    { "UPERRX", 0xf5, 0x00 },
    { "UPBCLX", 0xf6, 0x00 },
    { "UPBCHX", 0xf7, 0x00 },
    { "UPINT", 0xf8, 0x00 },
    { "OTGTCON", 0xf9, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90usb162_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "DWDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "WDTCKD", 0x62, 0x00 },
    { "REGCR", 0x63, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UCSR1D", 0xcb, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "CKSEL0", 0xd0, 0x00 },
    { "CKSEL1", 0xd1, 0x00 },
    { "CKSTA", 0xd2, 0x00 },
    { "USBCON", 0xd8, 0x00 },
    { "UDPADDL", 0xdb, 0x00 },
    { "UDPADDH", 0xdc, 0x00 },
    { "UDCON", 0xe0, 0x00 },
    { "UDINT", 0xe1, 0x00 },
    { "UDIEN", 0xe2, 0x00 },
    { "UDADDR", 0xe3, 0x00 },
    { "UDFNUML", 0xe4, 0x00 },
    { "UDFNUMH", 0xe5, 0x00 },
    { "UDMFN", 0xe6, 0x00 },
    { "UEINTX", 0xe8, 0x00 },
    { "UENUM", 0xe9, 0x00 },
    { "UERST", 0xea, 0x00 },
    { "UECONX", 0xeb, 0x00 },
    { "UECFG0X", 0xec, 0x00 },
    { "UECFG1X", 0xed, 0x00 },
    { "UESTA0X", 0xee, 0x00 },
    { "UESTA1X", 0xef, 0x00 },
    { "UEIENX", 0xf0, 0x00 },
    { "UEDATX", 0xf1, 0x00 },
    { "UEBCLX", 0xf2, 0x00 },
    { "UEINT", 0xf4, 0x00 },
    { "PS2CON", 0xfa, 0x00 },
    { "UPOE", 0xfb, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90usb646_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "UHWCON", 0xd7, 0x00 },
    { "USBCON", 0xd8, 0x00 },
    { "USBSTA", 0xd9, 0x00 },
    { "USBINT", 0xda, 0x00 },
    { "UDPADDL", 0xdb, 0x00 },
    { "UDPADDH", 0xdc, 0x00 },
    { "UDCON", 0xe0, 0x00 },
    { "UDINT", 0xe1, 0x00 },
    { "UDIEN", 0xe2, 0x00 },
    { "UDADDR", 0xe3, 0x00 },
    { "UDFNUML", 0xe4, 0x00 },
    { "UDFNUMH", 0xe5, 0x00 },
    { "UDMFN", 0xe6, 0x00 },
    { "UDTST", 0xe7, 0x00 },
    { "UEINTX", 0xe8, 0x00 },
    { "UENUM", 0xe9, 0x00 },
    { "UERST", 0xea, 0x00 },
    { "UECONX", 0xeb, 0x00 },
    { "UECFG0X", 0xec, 0x00 },
    { "UECFG1X", 0xed, 0x00 },
    { "UESTA0X", 0xee, 0x00 },
    { "UESTA1X", 0xef, 0x00 },
    { "UEIENX", 0xf0, 0x00 },
    { "UEDATX", 0xf1, 0x00 },
    { "UEBCLX", 0xf2, 0x00 },
    { "UEBCHX", 0xf3, 0x00 },
    { "UEINT", 0xf4, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type at90usb647_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "XMCRA", 0x74, 0x00 },
    { "XMCRB", 0x75, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "UHCON", 0x9e, 0x00 },
    { "UHINT", 0x9f, 0x00 },
    { "UHIEN", 0xa0, 0x00 },
    { "UHADDR", 0xa1, 0x00 },
    { "UHFNUML", 0xa2, 0x00 },
    { "UHFNUMH", 0xa3, 0x00 },
    { "UHFLEN", 0xa4, 0x00 },
    { "UPINRQX", 0xa5, 0x00 },
    { "UPINTX", 0xa6, 0x00 },
    { "UPNUM", 0xa7, 0x00 },
    { "UPRST", 0xa8, 0x00 },
    { "UPCONX", 0xa9, 0x00 },
    { "UPCFG0X", 0xaa, 0x00 },
    { "UPCFG1X", 0xab, 0x00 },
    { "UPSTAX", 0xac, 0x00 },
    { "UPCFG2X", 0xad, 0x00 },
    { "UPIENX", 0xae, 0x00 },
    { "UPDATX", 0xaf, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "UHWCON", 0xd7, 0x00 },
    { "USBCON", 0xd8, 0x00 },
    { "USBSTA", 0xd9, 0x00 },
    { "USBINT", 0xda, 0x00 },
    { "UDPADDL", 0xdb, 0x00 },
    { "UDPADDH", 0xdc, 0x00 },
    { "OTGCON", 0xdd, 0x00 },
    { "OTGIEN", 0xde, 0x00 },
    { "OTGINT", 0xdf, 0x00 },
    { "UDCON", 0xe0, 0x00 },
    { "UDINT", 0xe1, 0x00 },
    { "UDIEN", 0xe2, 0x00 },
    { "UDADDR", 0xe3, 0x00 },
    { "UDFNUML", 0xe4, 0x00 },
    { "UDFNUMH", 0xe5, 0x00 },
    { "UDMFN", 0xe6, 0x00 },
    { "UDTST", 0xe7, 0x00 },
    { "UEINTX", 0xe8, 0x00 },
    { "UENUM", 0xe9, 0x00 },
    { "UERST", 0xea, 0x00 },
    { "UECONX", 0xeb, 0x00 },
    { "UECFG0X", 0xec, 0x00 },
    { "UECFG1X", 0xed, 0x00 },
    { "UESTA0X", 0xee, 0x00 },
    { "UESTA1X", 0xef, 0x00 },
    { "UEIENX", 0xf0, 0x00 },
    { "UEDATX", 0xf1, 0x00 },
    { "UEBCLX", 0xf2, 0x00 },
    { "UEBCHX", 0xf3, 0x00 },
    { "UEINT", 0xf4, 0x00 },
    { "UPERRX", 0xf5, 0x00 },
    { "UPBCLX", 0xf6, 0x00 },
    { "UPBCHX", 0xf7, 0x00 },
    { "UPINT", 0xf8, 0x00 },
    { "OTGTCON", 0xf9, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega1284p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega165_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSRA", 0xc0, 0x00 },
    { "UCSRB", 0xc1, 0x00 },
    { "UCSRC", 0xc2, 0x00 },
    { "UBRRL", 0xc4, 0x00 },
    { "UBRRH", 0xc5, 0x00 },
    { "UDR", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega165p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega168p_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega16hva_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "OSICSR", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEAR -- EEARL", 0x41, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0L", 0x46, 0x00 },
    { "TCNT0H", 0x47, 0x00 },
    { "OCR0A", 0x48, 0x00 },
    { "OCR0B", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "DWDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "FOSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "VADCL", 0x78, 0x00 },
    { "VADCH", 0x79, 0x00 },
    { "VADCSR", 0x7a, 0x00 },
    { "VADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "OCR1A", 0x88, 0x00 },
    { "OCR1B", 0x89, 0x00 },
    { "ROCR", 0xc8, 0x00 },
    { "BGCCR", 0xd0, 0x00 },
    { "BGCRR", 0xd1, 0x00 },
    { "CADAC0", 0xe0, 0x00 },
    { "CADAC1", 0xe1, 0x00 },
    { "CADAC2", 0xe2, 0x00 },
    { "CADAC3", 0xe3, 0x00 },
    { "CADCSRA", 0xe4, 0x00 },
    { "CADCSRB", 0xe5, 0x00 },
    { "CADRC", 0xe6, 0x00 },
    { "CADICL", 0xe8, 0x00 },
    { "CADICH", 0xe9, 0x00 },
    { "FCSR", 0xf0, 0x00 },
    { "BPIMSK", 0xf2, 0x00 },
    { "BPIFR", 0xf3, 0x00 },
    { "BPSCD", 0xf5, 0x00 },
    { "BPDOCD", 0xf6, 0x00 },
    { "BPCOCD", 0xf7, 0x00 },
    { "BPDHCD", 0xf8, 0x00 },
    { "BPCHCD", 0xf9, 0x00 },
    { "BPSCTR", 0xfa, 0x00 },
    { "BPOCTR", 0xfb, 0x00 },
    { "BPHCTR", 0xfc, 0x00 },
    { "BPCR", 0xfd, 0x00 },
    { "BPPLR", 0xfe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega3250p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "PINH", 0xd8, 0x00 },
    { "DDRH", 0xd9, 0x00 },
    { "PORTH", 0xda, 0x00 },
    { "PINJ", 0xdb, 0x00 },
    { "DDRJ", 0xdc, 0x00 },
    { "PORTJ", 0xdd, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega325p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega328p_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega3290p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "PINH", 0xd8, 0x00 },
    { "DDRH", 0xd9, 0x00 },
    { "PORTH", 0xda, 0x00 },
    { "PINJ", 0xdb, 0x00 },
    { "DDRJ", 0xdc, 0x00 },
    { "PORTJ", 0xdd, 0x00 },
    { "LCDCRA", 0xe4, 0x00 },
    { "LCDCRB", 0xe5, 0x00 },
    { "LCDFRR", 0xe6, 0x00 },
    { "LCDCCR", 0xe7, 0x00 },
    { "LCDDR00", 0xec, 0x00 },
    { "LCDDR01", 0xed, 0x00 },
    { "LCDDR02", 0xee, 0x00 },
    { "LCDDR03", 0xef, 0x00 },
    { "LCDDR04", 0xf0, 0x00 },
    { "LCDDR05", 0xf1, 0x00 },
    { "LCDDR06", 0xf2, 0x00 },
    { "LCDDR07", 0xf3, 0x00 },
    { "LCDDR08", 0xf4, 0x00 },
    { "LCDDR09", 0xf5, 0x00 },
    { "LCDDR10", 0xf6, 0x00 },
    { "LCDDR11", 0xf7, 0x00 },
    { "LCDDR12", 0xf8, 0x00 },
    { "LCDDR13", 0xf9, 0x00 },
    { "LCDDR14", 0xfa, 0x00 },
    { "LCDDR15", 0xfb, 0x00 },
    { "LCDDR16", 0xfc, 0x00 },
    { "LCDDR17", 0xfd, 0x00 },
    { "LCDDR18", 0xfe, 0x00 },
    { "LCDDR19", 0xff, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega329p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "LCDCRA", 0xe4, 0x00 },
    { "LCDCRB", 0xe5, 0x00 },
    { "LCDFRR", 0xe6, 0x00 },
    { "LCDCCR", 0xe7, 0x00 },
    { "LCDDR00", 0xec, 0x00 },
    { "LCDDR01", 0xed, 0x00 },
    { "LCDDR02", 0xee, 0x00 },
    { "LCDDR03", 0xef, 0x00 },
    { "LCDDR05", 0xf1, 0x00 },
    { "LCDDR06", 0xf2, 0x00 },
    { "LCDDR07", 0xf3, 0x00 },
    { "LCDDR08", 0xf4, 0x00 },
    { "LCDDR10", 0xf6, 0x00 },
    { "LCDDR11", 0xf7, 0x00 },
    { "LCDDR12", 0xf8, 0x00 },
    { "LCDDR13", 0xf9, 0x00 },
    { "LCDDR15", 0xfb, 0x00 },
    { "LCDDR16", 0xfc, 0x00 },
    { "LCDDR17", 0xfd, 0x00 },
    { "LCDDR18", 0xfe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega32hvb_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "OSICSR", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0L", 0x46, 0x00 },
    { "TCNT0H", 0x47, 0x00 },
    { "OCR0A", 0x48, 0x00 },
    { "OCR0B", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "DWDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "FOSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "VADCL", 0x78, 0x00 },
    { "VADCH", 0x79, 0x00 },
    { "VADCSR", 0x7a, 0x00 },
    { "VADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "OCR1A", 0x88, 0x00 },
    { "OCR1B", 0x89, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "TWBCSR", 0xbe, 0x00 },
    { "ROCR", 0xc8, 0x00 },
    { "BGCCR", 0xd0, 0x00 },
    { "BGCRR", 0xd1, 0x00 },
    { "BGCSR", 0xd2, 0x00 },
    { "CHGDCSR", 0xd4, 0x00 },
    { "CADAC0", 0xe0, 0x00 },
    { "CADAC1", 0xe1, 0x00 },
    { "CADAC2", 0xe2, 0x00 },
    { "CADAC3", 0xe3, 0x00 },
    { "CADICL", 0xe4, 0x00 },
    { "CADICH", 0xe5, 0x00 },
    { "CADCSRA", 0xe6, 0x00 },
    { "CADCSRB", 0xe7, 0x00 },
    { "CADCSRC", 0xe8, 0x00 },
    { "CADRCC", 0xe9, 0x00 },
    { "CADRDC", 0xea, 0x00 },
    { "FCSR", 0xf0, 0x00 },
    { "CBCR", 0xf1, 0x00 },
    { "BPIMSK", 0xf2, 0x00 },
    { "BPIFR", 0xf3, 0x00 },
    { "BPSCD", 0xf5, 0x00 },
    { "BPDOCD", 0xf6, 0x00 },
    { "BPCOCD", 0xf7, 0x00 },
    { "BPDHCD", 0xf8, 0x00 },
    { "BPCHCD", 0xf9, 0x00 },
    { "BPSCTR", 0xfa, 0x00 },
    { "BPOCTR", 0xfb, 0x00 },
    { "BPHCTR", 0xfc, 0x00 },
    { "BPCR", 0xfd, 0x00 },
    { "BPPLR", 0xfe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega32u4_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "PLLCSR", 0x49, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "PLLFRQ", 0x52, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "EIND", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "RCCTRL", 0x67, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "UHCON", 0x9e, 0x00 },
    { "UHINT", 0x9f, 0x00 },
    { "UHIEN", 0xa0, 0x00 },
    { "UHADDR", 0xa1, 0x00 },
    { "UHFNUML", 0xa2, 0x00 },
    { "UHFNUMH", 0xa3, 0x00 },
    { "UHFLEN", 0xa4, 0x00 },
    { "UPINRQX", 0xa5, 0x00 },
    { "UPINTX", 0xa6, 0x00 },
    { "UPNUM", 0xa7, 0x00 },
    { "UPRST", 0xa8, 0x00 },
    { "UPCONX", 0xa9, 0x00 },
    { "UPCFG0X", 0xaa, 0x00 },
    { "UPCFG1X", 0xab, 0x00 },
    { "UPSTAX", 0xac, 0x00 },
    { "UPCFG2X", 0xad, 0x00 },
    { "UPIENX", 0xae, 0x00 },
    { "UPDATX", 0xaf, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "TCNT4L", 0xbe, 0x00 },
    { "TCNT4H -- TC4H", 0xbf, 0x00 },
    { "TCCR4A", 0xc0, 0x00 },
    { "TCCR4B", 0xc1, 0x00 },
    { "TCCR4C", 0xc2, 0x00 },
    { "TCCR4D", 0xc3, 0x00 },
    { "TCCR4E", 0xc4, 0x00 },
    { "CLKSEL0", 0xc5, 0x00 },
    { "CLKSEL1", 0xc6, 0x00 },
    { "CLKSTA", 0xc7, 0x00 },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "OCR4A", 0xcf, 0x00 },
    { "OCR4B", 0xd0, 0x00 },
    { "OCR4C", 0xd1, 0x00 },
    { "OCR4D", 0xd2, 0x00 },
    { "DT4", 0xd4, 0x00 },
    { "UHWCON", 0xd7, 0x00 },
    { "USBCON", 0xd8, 0x00 },
    { "USBSTA", 0xd9, 0x00 },
    { "USBINT", 0xda, 0x00 },
    { "OTGCON", 0xdd, 0x00 },
    { "OTGIEN", 0xde, 0x00 },
    { "OTGINT", 0xdf, 0x00 },
    { "UDCON", 0xe0, 0x00 },
    { "UDINT", 0xe1, 0x00 },
    { "UDIEN", 0xe2, 0x00 },
    { "UDADDR", 0xe3, 0x00 },
    { "UDFNUML", 0xe4, 0x00 },
    { "UDFNUMH", 0xe5, 0x00 },
    { "UDMFN", 0xe6, 0x00 },
    { "UDTST", 0xe7, 0x00 },
    { "UEINTX", 0xe8, 0x00 },
    { "UENUM", 0xe9, 0x00 },
    { "UERST", 0xea, 0x00 },
    { "UECONX", 0xeb, 0x00 },
    { "UECFG0X", 0xec, 0x00 },
    { "UECFG1X", 0xed, 0x00 },
    { "UESTA0X", 0xee, 0x00 },
    { "UESTA1X", 0xef, 0x00 },
    { "UEIENX", 0xf0, 0x00 },
    { "UEDATX", 0xf1, 0x00 },
    { "UEBCLX", 0xf2, 0x00 },
    { "UEBCHX", 0xf3, 0x00 },
    { "UEINT", 0xf4, 0x00 },
    { "UPERRX", 0xf5, 0x00 },
    { "UPBCLX", 0xf6, 0x00 },
    { "UPBCHX", 0xf7, 0x00 },
    { "UPINT", 0xf8, 0x00 },
    { "OTGTCON", 0xf9, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega406_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "WUTCSR", 0x62, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "FOSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "VADCL", 0x78, 0x00 },
    { "VADCH", 0x79, 0x00 },
    { "VADCSR", 0x7a, 0x00 },
    { "VADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "TWBCSR", 0xbe, 0x00 },
    { "CCSR", 0xc0, 0x00 },
    { "BGCCR", 0xd0, 0x00 },
    { "BGCRR", 0xd1, 0x00 },
    { "CADAC0", 0xe0, 0x00 },
    { "CADAC1", 0xe1, 0x00 },
    { "CADAC2", 0xe2, 0x00 },
    { "CADAC3", 0xe3, 0x00 },
    { "CADCSRA", 0xe4, 0x00 },
    { "CADCSRB", 0xe5, 0x00 },
    { "CADRCC", 0xe6, 0x00 },
    { "CADRDC", 0xe7, 0x00 },
    { "CADICL", 0xe8, 0x00 },
    { "CADICH", 0xe9, 0x00 },
    { "FCSR", 0xf0, 0x00 },
    { "CBCR", 0xf1, 0x00 },
    { "BPIR", 0xf2, 0x00 },
    { "BPDUV", 0xf3, 0x00 },
    { "BPSCD", 0xf4, 0x00 },
    { "BPOCD", 0xf5, 0x00 },
    { "CBPTR", 0xf6, 0x00 },
    { "BPCR", 0xf7, 0x00 },
    { "BPPLR", 0xf8, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega48p_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega644p_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "MONDR -- OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR -- PRR0", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "PCMSK3", 0x73, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega88p_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny167_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PORTCR", 0x32, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x45, 0x00 },
    { "TCCR0B", 0x46, 0x00 },
    { "TCNT0", 0x47, 0x00 },
    { "OCR0A", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "DWDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "CLKCSR", 0x62, 0x00 },
    { "CLKSELR", 0x63, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "AMISCR", 0x77, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCCR1D", 0x83, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1 -- ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "USICR", 0xb8, 0x00 },
    { "USISR", 0xb9, 0x00 },
    { "USIDR", 0xba, 0x00 },
    { "USIBR", 0xbb, 0x00 },
    { "USIPP", 0xbc, 0x00 },
    { "LINCR", 0xc8, 0x00 },
    { "LINSIR", 0xc9, 0x00 },
    { "LINENIR", 0xca, 0x00 },
    { "LINERR", 0xcb, 0x00 },
    { "LINBTR", 0xcc, 0x00 },
    { "LINBRRL", 0xcd, 0x00 },
    { "LINBRRH", 0xce, 0x00 },
    { "LINDLR", 0xcf, 0x00 },
    { "LINIDR", 0xd0, 0x00 },
    { "LINSEL", 0xd1, 0x00 },
    { "LINDAT", 0xd2, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny43u_io_registers[] =
{
    { "PRR", 0x20, 0x00 },
    { "DIDR0", 0x21, 0x00 },
    { "ADCSRB", 0x23, 0x00 },
    { "ADCL", 0x24, IO_REG_RSE },
    { "ADCH", 0x25, IO_REG_RSE },
    { "ADCSRA", 0x26, 0x00 },
    { "ADMUX", 0x27, 0x00 },
    { "ACSR", 0x28, 0x00 },
    { "TIFR1", 0x2b, 0x00 },
    { "TIMSK1", 0x2c, 0x00 },
    { "USICR", 0x2d, 0x00 },
    { "USISR", 0x2e, 0x00 },
    { "USIDR", 0x2f, 0x00 },
    { "USIBR", 0x30, 0x00 },
    { "PCMSK0", 0x32, 0x00 },
    { "GPIOR0", 0x33, 0x00 },
    { "GPIOR1", 0x34, 0x00 },
    { "GPIOR2", 0x35, 0x00 },
    { "PINB", 0x36, 0x00 },
    { "DDRB", 0x37, 0x00 },
    { "PORTB", 0x38, 0x00 },
    { "PINA", 0x39, 0x00 },
    { "DDRA", 0x3a, 0x00 },
    { "PORTA", 0x3b, 0x00 },
    { "EECR", 0x3c, 0x00 },
    { "EEDR", 0x3d, 0x00 },
    { "EEARL", 0x3e, 0x00 },
    { "PCMSK1", 0x40, 0x00 },
    { "WDTCSR", 0x41, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "CLKPR", 0x46, 0x00 },
    { "OCR1B", 0x4b, 0x00 },
    { "OCR1A", 0x4c, 0x00 },
    { "TCNT1", 0x4d, 0x00 },
    { "TCCR1B", 0x4e, 0x00 },
    { "TCCR1A", 0x4f, 0x00 },
    { "TCCR0A", 0x50, 0x00 },
    { "OSCCAL", 0x51, 0x00 },
    { "TCNT0", 0x52, 0x00 },
    { "TCCR0B", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "OCR0A", 0x56, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "TIFR0", 0x58, 0x00 },
    { "TIMSK0", 0x59, 0x00 },
    { "GIFR", 0x5a, 0x00 },
    { "GIMSK", 0x5b, 0x00 },
    { "OCR0B", 0x5c, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny48_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINA", 0x2c, 0x00 },
    { "DDRA", 0x2d, 0x00 },
    { "PORTA", 0x2e, 0x00 },
    { "PORTCR", 0x32, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK3", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "TWIHSR -- TWHSR", 0xbe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type attiny88_io_registers[] =
{
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINA", 0x2c, 0x00 },
    { "DDRA", 0x2d, 0x00 },
    { "PORTA", 0x2e, 0x00 },
    { "PORTCR", 0x32, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR", 0x64, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "PCMSK3", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "ADCL", 0x78, IO_REG_RSE },
    { "ADCH", 0x79, IO_REG_RSE },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "TWHSR", 0xbe, 0x00 },
    { 0, 0, 0 }
};


gdb_io_reg_def_type atmega128rfa1_io_registers[] =
{
    { "PINA", 0x20, 0x00 },
    { "DDRA", 0x21, 0x00 },
    { "PORTA", 0x22, 0x00 },
    { "PINB", 0x23, 0x00 },
    { "DDRB", 0x24, 0x00 },
    { "PORTB", 0x25, 0x00 },
    { "PINC", 0x26, 0x00 },
    { "DDRC", 0x27, 0x00 },
    { "PORTC", 0x28, 0x00 },
    { "PIND", 0x29, 0x00 },
    { "DDRD", 0x2a, 0x00 },
    { "PORTD", 0x2b, 0x00 },
    { "PINE", 0x2c, 0x00 },
    { "DDRE", 0x2d, 0x00 },
    { "PORTE", 0x2e, 0x00 },
    { "PINF", 0x2f, 0x00 },
    { "DDRF", 0x30, 0x00 },
    { "PORTF", 0x31, 0x00 },
    { "PING", 0x32, 0x00 },
    { "DDRG", 0x33, 0x00 },
    { "PORTG", 0x34, 0x00 },
    { "TIFR0", 0x35, 0x00 },
    { "TIFR1", 0x36, 0x00 },
    { "TIFR2", 0x37, 0x00 },
    { "TIFR3", 0x38, 0x00 },
    { "TIFR4", 0x39, 0x00 },
    { "TIFR5", 0x3a, 0x00 },
    { "PCIFR", 0x3b, 0x00 },
    { "EIFR", 0x3c, 0x00 },
    { "EIMSK", 0x3d, 0x00 },
    { "GPIOR0", 0x3e, 0x00 },
    { "EECR", 0x3f, 0x00 },
    { "EEDR", 0x40, 0x00 },
    { "EEARL", 0x41, 0x00 },
    { "EEARH", 0x42, 0x00 },
    { "GTCCR", 0x43, 0x00 },
    { "TCCR0A", 0x44, 0x00 },
    { "TCCR0B", 0x45, 0x00 },
    { "TCNT0", 0x46, 0x00 },
    { "OCR0A", 0x47, 0x00 },
    { "OCR0B", 0x48, 0x00 },
    { "GPIOR1", 0x4a, 0x00 },
    { "GPIOR2", 0x4b, 0x00 },
    { "SPCR", 0x4c, 0x00 },
    { "SPSR", 0x4d, 0x00 },
    { "SPDR", 0x4e, 0x00 },
    { "ACSR", 0x50, 0x00 },
    { "OCDR", 0x51, 0x00 },
    { "SMCR", 0x53, 0x00 },
    { "MCUSR", 0x54, 0x00 },
    { "MCUCR", 0x55, 0x00 },
    { "SPMCSR", 0x57, 0x00 },
    { "RAMPZ", 0x5b, 0x00 },
    { "SPL", 0x5d, 0x00 },
    { "SPH", 0x5e, 0x00 },
    { "SREG", 0x5f, 0x00 },
    { "WDTCSR", 0x60, 0x00 },
    { "CLKPR", 0x61, 0x00 },
    { "PRR2", 0x63, 0x00 },
    { "PRR0", 0x64, 0x00 },
    { "PRR1", 0x65, 0x00 },
    { "OSCCAL", 0x66, 0x00 },
    { "BGCR", 0x67, 0x00 },
    { "PCICR", 0x68, 0x00 },
    { "EICRA", 0x69, 0x00 },
    { "EICRB", 0x6a, 0x00 },
    { "PCMSK0", 0x6b, 0x00 },
    { "PCMSK1", 0x6c, 0x00 },
    { "PCMSK2", 0x6d, 0x00 },
    { "TIMSK0", 0x6e, 0x00 },
    { "TIMSK1", 0x6f, 0x00 },
    { "TIMSK2", 0x70, 0x00 },
    { "TIMSK3", 0x71, 0x00 },
    { "TIMSK4", 0x72, 0x00 },
    { "TIMSK5", 0x73, 0x00 },
    { "NEMCR", 0x75, 0x00 },
    { "ADCSRC", 0x77, 0x00 },
    { "ADCL -- ADCWL", 0x78, 0x00 },
    { "ADCH -- ADCWH", 0x79, 0x00 },
    { "ADCSRA", 0x7a, 0x00 },
    { "ADCSRB", 0x7b, 0x00 },
    { "ADMUX", 0x7c, 0x00 },
    { "DIDR2", 0x7d, 0x00 },
    { "DIDR0", 0x7e, 0x00 },
    { "DIDR1", 0x7f, 0x00 },
    { "TCCR1A", 0x80, 0x00 },
    { "TCCR1B", 0x81, 0x00 },
    { "TCCR1C", 0x82, 0x00 },
    { "TCNT1L", 0x84, 0x00 },
    { "TCNT1H", 0x85, 0x00 },
    { "ICR1L", 0x86, 0x00 },
    { "ICR1H", 0x87, 0x00 },
    { "OCR1AL", 0x88, 0x00 },
    { "OCR1AH", 0x89, 0x00 },
    { "OCR1BL", 0x8a, 0x00 },
    { "OCR1BH", 0x8b, 0x00 },
    { "OCR1CL", 0x8c, 0x00 },
    { "OCR1CH", 0x8d, 0x00 },
    { "TCCR3A", 0x90, 0x00 },
    { "TCCR3B", 0x91, 0x00 },
    { "TCCR3C", 0x92, 0x00 },
    { "TCNT3L", 0x94, 0x00 },
    { "TCNT3H", 0x95, 0x00 },
    { "ICR3L", 0x96, 0x00 },
    { "ICR3H", 0x97, 0x00 },
    { "OCR3AL", 0x98, 0x00 },
    { "OCR3AH", 0x99, 0x00 },
    { "OCR3BL", 0x9a, 0x00 },
    { "OCR3BH", 0x9b, 0x00 },
    { "OCR3CL", 0x9c, 0x00 },
    { "OCR3CH", 0x9d, 0x00 },
    { "TCCR4A", 0xa0, 0x00 },
    { "TCCR4B", 0xa1, 0x00 },
    { "TCCR4C", 0xa2, 0x00 },
    { "TCNT4L", 0xa4, 0x00 },
    { "TCNT4H", 0xa5, 0x00 },
    { "ICR4L", 0xa6, 0x00 },
    { "ICR4H", 0xa7, 0x00 },
    { "OCR4AL", 0xa8, 0x00 },
    { "OCR4AH", 0xa9, 0x00 },
    { "OCR4BL", 0xaa, 0x00 },
    { "OCR4BH", 0xab, 0x00 },
    { "OCR4CL", 0xac, 0x00 },
    { "OCR4CH", 0xad, 0x00 },
    { "TCCR2A", 0xb0, 0x00 },
    { "TCCR2B", 0xb1, 0x00 },
    { "TCNT2", 0xb2, 0x00 },
    { "OCR2A", 0xb3, 0x00 },
    { "OCR2B", 0xb4, 0x00 },
    { "ASSR", 0xb6, 0x00 },
    { "TWBR", 0xb8, 0x00 },
    { "TWSR", 0xb9, 0x00 },
    { "TWAR", 0xba, 0x00 },
    { "TWDR", 0xbb, 0x00 },
    { "TWCR", 0xbc, 0x00 },
    { "TWAMR", 0xbd, 0x00 },
    { "UCSR0A", 0xc0, 0x00 },
    { "UCSR0B", 0xc1, 0x00 },
    { "UCSR0C", 0xc2, 0x00 },
    { "UBRR0L", 0xc4, 0x00 },
    { "UBRR0H", 0xc5, 0x00 },
    { "UDR0", 0xc6, IO_REG_RSE },
    { "UCSR1A", 0xc8, 0x00 },
    { "UCSR1B", 0xc9, 0x00 },
    { "UCSR1C", 0xca, 0x00 },
    { "UBRR1L", 0xcc, 0x00 },
    { "UBRR1H", 0xcd, 0x00 },
    { "UDR1", 0xce, IO_REG_RSE },
    { "SCCR0", 0xdc, 0x00 },
    { "SCCR1", 0xdd, 0x00 },
    { "SCSR", 0xde, 0x00 },
    { "SCIRQM", 0xdf, 0x00 },
    { "SCIRQS", 0xe0, 0x00 },
    { "SCCNTLL", 0xe1, 0x00 },
    { "SCCNTLH", 0xe2, 0x00 },
    { "SCCNTHL", 0xe3, 0x00 },
    { "SCCNTHH", 0xe4, 0x00 },
    { "SCBTSRLL", 0xe5, 0x00 },
    { "SCBTSRLH", 0xe6, 0x00 },
    { "SCBTSRHL", 0xe7, 0x00 },
    { "SCBTSRHH", 0xe8, 0x00 },
    { "SCTSRLL", 0xe9, 0x00 },
    { "SCTSRLH", 0xea, 0x00 },
    { "SCTSRHL", 0xeb, 0x00 },
    { "SCTSRHH", 0xec, 0x00 },
    { "SCOCR3LL", 0xed, 0x00 },
    { "SCOCR3LH", 0xee, 0x00 },
    { "SCOCR3HL", 0xef, 0x00 },
    { "SCOCR3HH", 0xf0, 0x00 },
    { "SCOCR2LL", 0xf1, 0x00 },
    { "SCOCR2LH", 0xf2, 0x00 },
    { "SCOCR2HL", 0xf3, 0x00 },
    { "SCOCR2HH", 0xf4, 0x00 },
    { "SCOCR1LL", 0xf5, 0x00 },
    { "SCOCR1LH", 0xf6, 0x00 },
    { "SCOCR1HL", 0xf7, 0x00 },
    { "SCOCR1HH", 0xf8, 0x00 },
    { "TCCR5A", 0x120, 0x00 },
    { "TCCR5B", 0x121, 0x00 },
    { "TCCR5C", 0x122, 0x00 },
    { "TCNT5L", 0x124, 0x00 },
    { "TCNT5H", 0x125, 0x00 },
    { "ICR5L", 0x126, 0x00 },
    { "ICR5H", 0x127, 0x00 },
    { "OCR5AL", 0x128, 0x00 },
    { "OCR5AH", 0x129, 0x00 },
    { "OCR5BL", 0x12a, 0x00 },
    { "OCR5BH", 0x12b, 0x00 },
    { "OCR5CL", 0x12c, 0x00 },
    { "OCR5CH", 0x12d, 0x00 },
    { "LLCR", 0x12f, 0x00 },
    { "LLDRL", 0x130, 0x00 },
    { "LLDRH", 0x131, 0x00 },
    { "DRTRAM3", 0x132, 0x00 },
    { "DRTRAM2", 0x133, 0x00 },
    { "DRTRAM1", 0x134, 0x00 },
    { "DRTRAM0", 0x135, 0x00 },
    { "DPDS0", 0x136, 0x00 },
    { "DPDS1", 0x137, 0x00 },
    { "TRXPR", 0x139, 0x00 },
    { "AES_CTRL", 0x13c, 0x00 },
    { "AES_STATUS", 0x13d, 0x00 },
    { "AES_STATE", 0x13e, 0x00 },
    { "AES_KEY", 0x13f, 0x00 },
    { "TRX_STATUS", 0x141, 0x00 },
    { "TRX_STATE", 0x142, 0x00 },
    { "TRX_CTRL_0", 0x143, 0x00 },
    { "TRX_CTRL_1", 0x144, 0x00 },
    { "PHY_TX_PWR", 0x145, 0x00 },
    { "PHY_RSSI", 0x146, 0x00 },
    { "PHY_ED_LEVEL", 0x147, 0x00 },
    { "PHY_CC_CCA", 0x148, 0x00 },
    { "CCA_THRES", 0x149, 0x00 },
    { "RX_CTRL", 0x14a, 0x00 },
    { "SFD_VALUE", 0x14b, 0x00 },
    { "TRX_CTRL_2", 0x14c, 0x00 },
    { "ANT_DIV", 0x14d, 0x00 },
    { "IRQ_MASK", 0x14e, 0x00 },
    { "IRQ_STATUS", 0x14f, 0x00 },
    { "VREG_CTRL", 0x150, 0x00 },
    { "BATMON", 0x151, 0x00 },
    { "XOSC_CTRL", 0x152, 0x00 },
    { "RX_SYN", 0x155, 0x00 },
    { "XAH_CTRL_1", 0x157, 0x00 },
    { "FTN_CTRL", 0x158, 0x00 },
    { "PLL_CF", 0x15a, 0x00 },
    { "PLL_DCU", 0x15b, 0x00 },
    { "PART_NUM", 0x15c, 0x00 },
    { "VERSION_NUM", 0x15d, 0x00 },
    { "MAN_ID_0", 0x15e, 0x00 },
    { "MAN_ID_1", 0x15f, 0x00 },
    { "SHORT_ADDR_0", 0x160, 0x00 },
    { "SHORT_ADDR_1", 0x161, 0x00 },
    { "PAN_ID_0", 0x162, 0x00 },
    { "PAN_ID_1", 0x163, 0x00 },
    { "IEEE_ADDR_0", 0x164, 0x00 },
    { "IEEE_ADDR_1", 0x165, 0x00 },
    { "IEEE_ADDR_2", 0x166, 0x00 },
    { "IEEE_ADDR_3", 0x167, 0x00 },
    { "IEEE_ADDR_4", 0x168, 0x00 },
    { "IEEE_ADDR_5", 0x169, 0x00 },
    { "IEEE_ADDR_6", 0x16a, 0x00 },
    { "IEEE_ADDR_7", 0x16b, 0x00 },
    { "XAH_CTRL_0", 0x16c, 0x00 },
    { "CSMA_SEED_0", 0x16d, 0x00 },
    { "CSMA_SEED_1", 0x16e, 0x00 },
    { "CSMA_BE", 0x16f, 0x00 },
    { "TST_CTRL_DIGI", 0x176, 0x00 },
    { "TST_RX_LENGTH", 0x17b, 0x00 },
    { "TRXFBST", 0x180, 0x00 },
    { "TRXFBEND", 0x1ff, 0x00 },
    { 0, 0, 0 }
};

