## Highlights from the past week

- Atom IDE
  - Reviewing and merging PR's, investigating issues and general housekeeping
  - Attempting to modify the language-csharp grammar for use on github.com (oniguruma vs pcre engines)
- GitHub Package
  - Implement actions for most recent commit - undo and amend [atom/github#1364](https://github.com/atom/github/pull/1364)
  - Improved push/pull UX [atom/github#1308](https://github.com/atom/github/pull/1308)
- Teletype
  - Published [Teletype 0.11.0](https://github.com/atom/teletype/releases/tag/v0.11.0) with support for [sharing and joining a portal via URL](https://blog.atom.io/2018/03/29/new-in-teletype-faster-setup-and-improved-multi-file-support.html#joining-a-portal-is-as-easy-as-clicking-a-link)
  - Updated RFC for streamlining collaboration set-up to incorporate feedback, and opened it up for another round of comments ([atom/teletype#344](https://github.com/atom/teletype/pull/344))
- Tree-sitter
  - Started work on fixing an error recovery hang I discovered in Atom last week: https://github.com/tree-sitter/tree-sitter/pull/155.
- Xray
  - [A PR with an initial implementation of a file finder UI](https://github.com/atom/xray/pull/55) is nearly complete.
  - See the [in-depth Xray update for this week](https://github.com/atom/xray/blob/master/docs/updates/2018_04_02.md) for details.
- Reactor Duty
  - `TextEditor.scan` methods with zero-length matches at line endings skip the next line: [#16983](https://github.com/atom/atom/issues/16983), fixed by [atom/superstring#53](https://github.com/atom/superstring/pull/53)
  - Prevent modifications to readonly editors: [#16736](https://github.com/atom/atom/issues/16736), fixed by [#16999](https://github.com/atom/atom/pull/16999) and (thanks @maxbrunsfeld) [#17050](https://github.com/atom/atom/pull/17050)
  - :ship: @t9md's PRs [atom/text-buffer#287](https://github.com/atom/text-buffer/pull/287) and [#16564](https://github.com/atom/atom/pull/16564) to fix [#16176](https://github.com/atom/atom/issues/16176), preserve cursor history on TextEditor cloning.
  - Incorrect buffer positions sent to autocomplete-plus providers: [atom/autocomplete-plus#954](https://github.com/atom/autocomplete-plus/issues/954), fixed by [atom/bracket-matcher#347](https://github.com/atom/bracket-matcher/pull/347)
  - :ship: @Arcanemagus' PR [atom/ci#82](https://github.com/atom/ci/pull/82), upgrade CircleCI templates to 2.0
  - "Cannot read property '0' of null" in `TextEditor.scanInRange` call: [#17023](https://github.com/atom/atom/issues/17023), fixed by [atom/superstring#60](https://github.com/atom/superstring/pull/60)
  - Use Unicode case folding for case-insensitive scans: [atom/superstring#56](https://github.com/atom/superstring/issues/56), fixed by [atom/superstring#56](https://github.com/atom/superstring/pull/61), [atom/superstring#62](https://github.com/atom/superstring/pull/62), [atom/text-buffer#294](https://github.com/atom/text-buffer/pull/294), and [atom/find-and-replace#1009](https://github.com/atom/find-and-replace/pull/1009)
  - Regular expressions containing "\u" throw an error: [atom/superstring#52](https://github.com/atom/superstring/issues/52) and [atom/find-and-replace#999](https://github.com/atom/find-and-replace/issues/999), fixed by [atom/superstring#63](https://github.com/atom/superstring/pull/63)
  - :ship: @hansonw's PR [atom/notifications#187](https://github.com/atom/notifications/pull/187) to fix [atom/notifications#185](https://github.com/atom/notifications/issues/185), sanitize _all_ markdown notification bodies with DOMPurify
  - [atom/notifications#188](https://github.com/atom/notifications/pull/188) and [atom/notifications#189](https://github.com/atom/notifications/pull/189) to chase down some tricky, weird edge cases in using DOMPurify within a v8 snapshot

## Focus for week ahead

- GitHub Package
  - Bring [atom/github#1138](https://github.com/atom/github/pull/1138) "create new pull request" over the finish line
  - Write "vision" documents in atom/github
  - Implement prompt for adding a co-author who is not yet in the commit history for the repository
- Teletype
  - Publish patch release with [potential fix](https://github.com/atom/teletype-client/pull/58) for [atom/teletype#233](https://github.com/atom/teletype/issues/233)
  - Incorporate any new feedback and finalize RFC for streamlining collaboration set-up ([atom/teletype#344](https://github.com/atom/teletype/pull/344))
- Tree-sitter
  - Finish https://github.com/tree-sitter/tree-sitter/pull/155
  - Working on the C# grammar (@damieng)
- Xray
  - Merge the [file finder PR](https://github.com/atom/xray/pull/55).
  - Start on headless shared workspaces.
  - See the [in-depth Xray update for this week](https://github.com/atom/xray/blob/master/docs/updates/2018_04_02.md) for details.
