## Highlights from the past week

- Atom IDE
  - Started conversion of atom-languageclient to TypeScript [atom/atom-languageclient#175](https://github.com/atom/atom-languageclient/pull/175)
- @atom/watcher
    - Report events related to [symlinks](https://github.com/atom/watcher/pull/111) and [test for symlink-related edge cases.](https://github.com/atom/watcher/pull/114)
    - Produce filesystem events with a [consistent parent path](https://github.com/atom/watcher/pull/113) to the one used to create a watcher, even if the watcher was created with a a path containing symlinks.
    - Verified correct behavior with regard to [filesystem case sensitivity.](https://github.com/atom/watcher/pull/116)
    - Corrected buggy [utf8 to utf16 conversion](https://github.com/atom/watcher/pull/115) on Windows.
    - Ran through the MacOS cases in the [testing matrix.](https://github.com/atom/atom/pull/16124)
      - Set up a Samba share on @ungb's testing server to exercise Samba network drives.
    - Published version 1.0.0 on [npm.](https://www.npmjs.com/package/@atom/watcher)
- GitHub Package
    - Introduce a package configuration option to [disable the in-editor merge conflict resolution.](https://github.com/atom/github/pull/1305)
    - Published a new release v0.10.0
    - Investigated and spiked on a fix for amending bug in single-commit repos, which was surfaced by failing cache invalidation tests that were blocking release
      - Deferred fixing underlying bug - [atom/github#1303](https://github.com/atom/github/issues/1303)
      - Fixed failing tests - [atom/github#1302](https://github.com/atom/github/pull/1302)
- Teletype
    - Released [Teletype 0.7.0](https://github.com/atom/teletype/releases/tag/v0.7.0) with improved diagnostics for errors that occur during package initialization ([atom/teletype#266](https://github.com/atom/teletype/issues/266), [atom/teletype#297](https://github.com/atom/teletype/issues/297))
    - Opened [atom/teletype#323](https://github.com/atom/teletype/pull/323), [atom/teletype-client#52](https://github.com/atom/teletype-client/pull/52), and [atom/fuzzy-finder#335](https://github.com/atom/fuzzy-finder/pull/335) to pave the way for guests to use the fuzzy-finder to open any remote editor shared by the host ([atom/teletype#268](https://github.com/atom/teletype/issues/268))

## Focus for week ahead

- Atom IDE
  - Finish conversion of atom-languageclient to TypeScript [atom/atom-languageclient#175](https://github.com/atom/atom-languageclient/pull/175)
  - Contribute TypeScript type definitions for Atom IDE to [DefinitelyTyped](https://github.com/DefinitelyTyped/DefinitelyTyped)
  - Contribute missing TypeScript type defintions for Atom to [DefinitelyTyped](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/atom)
- @atom/watcher
    - Complete [the testing matrix](https://github.com/atom/atom/pull/16124) on Linux and Windows.
    - :shipit: Merge [@atom/watcher support]((https://github.com/atom/atom/pull/16124)) into Atom _(as a non-default `PathWatcher` backend)_. :shipit:
- GitHub Package
    - Quarterly planning. Which might change all of these :wink:
    - Finish tracking down our [freezing CI builds.](https://github.com/atom/github/pull/1289)
    - Resurrect the [gargantuan credential helper and GPG pinentry refactoring PR](https://github.com/atom/github/pull/846) and see how much work is needed to get it over the finish line.
    - Fix issue with diff view popping up unexpectedly - [atom/github#1287](https://github.com/atom/github/issues/1287)
- Teletype
    - Complete initial implementation and merge pull requests ([atom/teletype#323](https://github.com/atom/teletype/pull/323), [atom/teletype-client#52](https://github.com/atom/teletype-client/pull/52), and [atom/fuzzy-finder#335](https://github.com/atom/fuzzy-finder/pull/335)) allowing guests to use the fuzzy-finder to open any remote editor shared by the host ([atom/teletype#268](https://github.com/atom/teletype/issues/268))
    - Use fuzzy-finder support internally in our day-to-day workflows to assess usability
- Tree-sitter
  - Finish and merge [tree-sitter/tree-sitter#128](https://github.com/tree-sitter/tree-sitter/pull/128), which fixes a fundamental performance problem when editing large files.
  - Fix syntax highlighting bugs [#16643](https://github.com/atom/atom/issues/16643) and [#16642](https://github.com/atom/atom/issues/16642).
  - Fix [#16621](https://github.com/atom/atom/issues/16621) - snippets not working when using Tree-sitter.
- Xray
  * @nathansobo (and @as-cii part time) will be focusing the next 12 weeks on a prototype for [a new Electron-based text editor](https://github.com/atom/xray). The goal is to explore the viability of radical performance improvements that could be possible if we make breaking changes to Atom's APIs. At the end of the 12 weeks, we will reassess our plans based on what we have managed to learn and accomplish.
  * Week 1 of 12
    * Clarify and document goals for the next 12 weeks.
    * Ensure that the guide matches our current plans.
    * Refine WebGL based text rendering.
      * Make sure ASCII text renders correctly without being clipped
      * Render text correctly on high DPI displays
      * Use correct API for texture atlas updates
      * Add mouse-wheel scrolling support
      * Non-ASCII rendering, using the HarfBuzz text shaping library to detect combining characters
    * Stretch goal: Switch document encoding to UTF-8 for memory compactness and support multi-byte-aware character indexing.
