## Highlights from the past week

- Atom IDE
  - Converted atom-languageclient to TypeScript
  - ide-typescript updated to use TypeScript 2.7.2
  - Published updates to ide-typescript, ide-json, and ide-csharp to improve language server stability
- @atom/watcher
  - Gracefully handle the situation where a network share with a watch root is disconnected ([#119](https://github.com/atom/watcher/pull/119))
  - Merged into Atom master behind a feature flag ([#16124](https://github.com/atom/atom/pull/16124)) just after the 1.24.0 / 1.25.0-beta0 release
  - Fixed a crash when messages are sent to the worker thread before it's properly initialized ([atom/watcher#121](https://github.com/atom/watcher/pull/121))
- GitHub Package
  - Investigate intermittently freezing tests on Travis in [atom/github#1289](https://github.com/atom/github/pull/1289). Not much luck so far
  - Fixed issue with diff views popping up unexpectedly [atom/github#1311](https://github.com/atom/github/pull/1311). Just waiting on review
- Teletype
  - Fixed an unanticipated bug that would cause non-existent selections to appear in the editor of other participants ([atom/teletype#326](https://github.com/atom/teletype/pull/326)).
  - Published [version 0.8.0](https://github.com/atom/teletype/releases/tag/v0.8.0).
  - Refactored teletype-client and simplified how added/removed editors are broadcasted to participants ([atom/teletype-client#52](https://github.com/atom/teletype-client/pull/52)).
  - Polished the design of fuzzy-finder ([atom/fuzzy-finder#335](https://github.com/atom/fuzzy-finder/pull/335))
  - Pushed [atom/teletype#323](https://github.com/atom/teletype/pull/323) over the finish line.
- Xray
  - We made a slight change of plans and decided to spend more time clarifying the overall vision for the project.
  - We have a [branch](https://github.com/atom/xray/tree/roadmap) with a new README that matches our current thinking, but the Q1 roadmap is still in progress.
  - We did manage to get text rendering with retina displays and non-clipped characters, but there's still work to do. We are also experimenting populating our glyph atlas with up to 4 variants of each glyph at different subpixel positions to more closely match text rendered purely on the CPU.
- Tree-sitter
  - Took some time to fix unrelated regressions from the bug-bash month
    - Fixed a bug where atom --wait did not work correctly on Windows (#16740)
    - Fixed a bug that prevented Atom from reusing an existing window when the same path was opened twice (#16764)
    - Fixed regressions in the behavior of the atom.textEditors.getGrammarOverride and atom.grammars.loadGrammar methods (#16733, #16747)
   - Fixed several syntax highlighting bugs (#16642, #16643)
## Focus for week ahead

- Atom IDE
  - Investigate new Atom IDE UI features for rename operations and workspace symbol search
  - Publish TypeScript definitions for atom-ide/atom-languageclient to DefinitelyTyped 
  - Wire up atom-ide-ui console to LSP server logging
- @atom/watcher
  - Diagnose and correct crashes and lock-ups as people report them
- GitHub Package
  - Establish high-level goals and scope bounds for the GitHub side of the integration
  - Document a protocol for the evolution of major features: ensure they contribute to a cohesive experience with the rest of the package, make sure that @simurai is looped in to the conversation, make sure the community has visibility to our goals
  - Show recent commits in Git panel
- Teletype
  - Merge and use [atom/fuzzy-finder#335](https://github.com/atom/fuzzy-finder/pull/335), [atom/teletype-client#52](https://github.com/atom/teletype-client/pull/52) and [atom/teletype#323](https://github.com/atom/teletype/pull/323).
  - Publish Teletype v0.9.0 containing the new fuzzy-finder support.
- Tree-sitter
  - Fix an issue where snippets are not available when using tree-sitter (#16621)
  - Start work on optimizing editing in the presence of large parse errors (#16590)
  - Start work on allowing parsing to take place on a background thread
- Xray
  - We will continue clarifying the overall vision with a focus on real time collaboration. This may extend beyond the scope of Xray, but is important to get clarity on before comitting to a roadmap.
  - We hope to iron out the remaining issues with subpixel-positioning of glyphs to more faithfully reproduce Chrome's behavior when rendering text via the normal DOM-based code path.
