## Highlights from the past week

- Atom IDE
  - TypeScript conversion fully cleaned up, types ready for definitely typed
  - Started work on AutoComplete rewrites to address poor filtering and over-eager pop-up
  - Review of code actions integration (currently on ide-java)
- @atom/watcher
- GitHub Package
  - Loads of [planning and process](https://github.com/atom/github/blob/master/docs/how-we-work.md)
  - Recent commit history [RFC](https://github.com/atom/github/pull/1318) and [implementation](https://github.com/atom/github/pull/1322)
  - Port another few components from Etch to React in preparation for :point_up:
  - Wrestle with a few [flaky](https://github.com/atom/github/pull/1289) [tests](https://github.com/atom/github/pull/1320) to get our [build](https://github.com/atom/github/pull/1317) under control.
- Teletype
- Tree-sitter
  - Finally wrote some documentation about Tree-sitter and how to develop parsers, now that members of the Atom community are starting to contribute to parsers.
- Xray
  - We finished off some up-front planning around Xray's support for real time collaboration.
  - We're now comfortably scrolling a dev-build of React at 60 frames per second. Frames are rendered in about 1.2ms per frame on our hardware, and rendering is looking identical to Chrome's CPU backend for basic ASCII text, modulo ligatures and kerning. We still have a lot of features to add, but we don't any of them will dramatically impact frame computation time.
- Reactor Duty
  - Discovered root cause of Windows test failures in [atom/tree-view#1203](https://github.com/atom/tree-view/issues/1203), discussed in-progress fix with @50wliu

## Focus for week ahead

- Atom IDE
  - Complete work on AutoComplete improvements
  - Stop cancellations for autocomplete and outline throwing errors in the logs
  - Investigate workspace symbol user interface
- @atom/watcher
  - Diagnose crashes and lockups on Atom launch
- GitHub Package
  - Recent commit implementation: land a [read-only view of the most recent commits](https://github.com/atom/github/pull/1322).
  - Port [CommitViewController and CommitView to React](https://github.com/atom/github/pull/1325).
  - Write up `docs/vision` from meeting notes.
  - Begin on ["remember me"](https://github.com/atom/github/issues/861) for the git credential helper.
- Teletype
- Tree-sitter
  - Optimizing syntax tree updates in the presence of syntax errors. This will improve performance across the board but also make Tree-sitter usable in edge cases where the wrong language is being used to parse a document.
- Xray
  - @as-cii will be focused on more sophisticated text-shaping to extend our support beyond basic ASCII. We're working on a [glyph-renderer](https://github.com/atom/xray/tree/glyph-renderer) module that handles text layout and glyph rasterization. To support a standalone web-based component, we're starting with a WebAssembly module based on HarfBuzz and FreeType, but we can always explore using platform-specific frameworks for the Electron use case.
  - @nathansobo will be focused on implementing selections. We're introducing a new "anchor" abstraction that creates a stable reference to a buffer location, along with methods for converting anchors to offsets or points. Each editor will store selections as a sorted array of anchor ranges. To move a selection, we'll convert its anchors to concrete points, adjust their rows/columns, then convert the points back to anchors. We're curious how long it will take us to do this for thousands of selections. Hopefully it's fast. Then we'll focus on inserting text inside the selections.
- Reactor Duty
  - Investigate dock pane dragging regression [atom/atom#16769](https://github.com/atom/atom/issues/16769)
  - Merge PR [atom/node-keytar#67](https://github.com/atom/node-keytar/pull/67)
