/***** Autogenerated from runtime.in; changes will be overwritten *****/

#line 1 "runtimebase.in"
/*****
 * runtimebase.in
 * Andy Hammerlindl  2009/07/28
 *
 * Common declarations needed for all code-generating .in files.
 *
 *****/


#line 1 "runtime.in"
/*****
 * runtime.in
 * Tom Prince 2005/4/15
 *
 * Generate the runtime functions used by the vm::stack machine.
 *
 *****/

/* Autogenerated routines are specified like this (separated by a formfeed):
   type asyname:cname(cparams)
   {
   C code
   }

*/

// Use Void f() instead of void f() to force an explicit Stack argument.


#line 1 "runtimebase.in"
#include "stack.h"
#include "types.h"
#include "builtin.h"
#include "entry.h"
#include "errormsg.h"
#include "array.h"
#include "triple.h"
#include "callable.h"
#include "opsymbols.h"

using vm::stack;
using vm::error;
using vm::array;
using vm::read;
using vm::callable;
using types::formal;
using types::function;
using camp::triple;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

void unused(void *);

namespace run {
typedef double real;

array *copyArray(array *a);
array *copyArray2(array *a);
array *copyArray3(array *a);

double *copyTripleArray2Components(array *a, size_t &N,
                                   GCPlacement placement=NoGC);
triple *copyTripleArray2C(array *a, size_t &N,
                          GCPlacement placement=NoGC);
}

function *realRealFunction();

#define CURRENTPEN processData().currentpen

#line 52 "runtime.in"
#include <cfloat>
#include <iostream>
#include <fstream>
#include <time.h>
#include <sys/times.h>
#include <locale.h>

#include "angle.h"
#include "pair.h"
#include "triple.h"
#include "transform.h"
#include "path.h"
#include "path3.h"
#include "pen.h"
#include "drawpath.h"
#include "guide.h"
#include "picture.h"
#include "fileio.h"
#include "genv.h"
#include "builtin.h"
#include "texfile.h"
#include "pipestream.h"
#include "parser.h"
#include "stack.h"
#include "util.h"
#include "locate.h"
#include "mathop.h"
#include "callable.h"
#include "stm.h"
#include "lexical.h"
#include "process.h"
#include "arrayop.h"
#include "seconds.h"

#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
  extern "C" {
    void *GC_generate_random_valid_address(void);
    void GC_debug_print_heap_obj_proc(void *);
  }
#endif

using namespace vm;
using namespace camp;
using namespace settings;
using namespace utils;

#undef OUT
#undef IN

namespace run {
using camp::pair;
using vm::array;
using vm::vmFrame;
using vm::stack;
using camp::transform;
using absyntax::runnable;

typedef array boolarray;
typedef array Intarray;
typedef array Intarray2;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array pairarray2;
typedef array triplearray;
typedef array triplearray2;
typedef array patharray;
typedef array patharray2;
typedef array guidearray;
typedef array transformarray;
typedef array penarray;
typedef array penarray2;
typedef array stringarray;
typedef array stringarray2;
}

using vm::array;
using types::function;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

using types::booleanArray;
using types::IntArray;
using types::IntArray2;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::pairArray2;
using types::tripleArray;
using types::tripleArray2;
using types::pathArray;
using types::pathArray2;
using types::guideArray;
using types::transformArray;
using types::penArray;
using types::penArray2;
using types::stringArray;
using types::stringArray2;
using types::formal;

function *realRealFunction()
{
  return new function(primReal(),primReal());
}

function *realTripleFunction()
{
  return new function(primReal(),primTriple());
}

const size_t camp::ColorComponents[]={0,0,1,3,4,0};

namespace vm {
#if COMPACT
const Int DefaultValue=0x7fffffffffffffffLL;
const Int Undefined=0x7ffffffffffffffeLL;

const Int BoolTruthValue=0xABABABABABABABACLL;
const Int BoolFalseValue=0xABABABABABABABABLL;

const item Default=DefaultValue;
#else
const item Default=item(default_t());
#endif
}

namespace run {

stopWatch wallClock;
cpuTimer cpuTime;

const char *arrayempty="cannot take min or max of empty array";
const char *noruntime="no runtime environment for embedded eval";

void writestring(stack *s)
{
  callable *suffix=pop<callable *>(s,NULL);
  string S=pop<string>(s);
  vm::item it=pop(s);
  bool defaultfile=isdefault(it);
  camp::file *f=defaultfile ? &camp::Stdout : vm::get<camp::file*>(it);
  if(!f->isOpen() || !f->enabled()) return;
  if(S != "") f->write(S);
  if(f->text()) {
    if(suffix) {
      s->push(f);
      suffix->call(s);
    } else if(defaultfile) f->writeline();
  }
}

string toplocation()
{
  ostringstream buf;
  position& topPos=processData().topPos;
  buf << topPos.Line() << "." << topPos.Column();
  return buf.str();
}

string emptystring;
pair zero;

}

static string defaulttransparency=string("Compatible");

void unused(void *)
{
}

// Autogenerated routines:



#ifndef NOSYM
#include "runtime.symbols.h"

#endif
namespace run {

// Initializers
#line 229 "runtime.in"
void IntZero(stack *Stack)
{
#line 230 "runtime.in"
  {Stack->push<Int>(0); return;}
}

#line 235 "runtime.in"
void realZero(stack *Stack)
{
#line 236 "runtime.in"
  {Stack->push<real>(0.0); return;}
}

#line 240 "runtime.in"
void boolFalse(stack *Stack)
{
#line 241 "runtime.in"
  {Stack->push<bool>(false); return;}
}

#line 245 "runtime.in"
// bool isnan(real x);
void gen_runtime3(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 246 "runtime.in"
  {Stack->push<bool>(std::isnan(x)); return;}
}

#line 250 "runtime.in"
void pushNullArray(stack *Stack)
{
#line 251 "runtime.in"
  {Stack->push<array*>(0); return;}
}

#line 255 "runtime.in"
void pushNullRecord(stack *Stack)
{
#line 256 "runtime.in"
  {Stack->push<vmFrame*>(0); return;}
}

#line 260 "runtime.in"
void pushNullFunction(stack *Stack)
{
#line 261 "runtime.in"
  {Stack->push(nullfunc::instance()); return;}
}


// Default operations

// Put the default value token on the stack (in place of an argument when
// making a function call).
#line 270 "runtime.in"
void pushDefault(stack *Stack)
{
#line 271 "runtime.in"
  {Stack->push(Default); return;}
}


// Test if the value on the stack is the default value token.
#line 277 "runtime.in"
void isDefault(stack *Stack)
{
  item i=vm::pop(Stack);
#line 278 "runtime.in"
  {Stack->push<bool>(isdefault(i)); return;}
}


// Casts
#line 284 "runtime.in"
void pairToGuide(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 285 "runtime.in"
  {Stack->push<guide*>(new pairguide(z)); return;}
}

#line 290 "runtime.in"
void pathToGuide(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 291 "runtime.in"
  {Stack->push<guide*>(new pathguide(p)); return;}
}

#line 295 "runtime.in"
void guideToPath(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 296 "runtime.in"
  {Stack->push<path>(g->solve()); return;}
}


// Pen operations
#line 302 "runtime.in"
void newPen(stack *Stack)
{
#line 303 "runtime.in"
  {Stack->push<pen>(pen()); return;}
}

#line 308 "runtime.in"
// bool ==(pen a, pen b);
void gen_runtime13(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 309 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 313 "runtime.in"
// bool !=(pen a, pen b);
void gen_runtime14(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 314 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 318 "runtime.in"
// pen +(pen a, pen b);
void gen_runtime15(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 319 "runtime.in"
  {Stack->push<pen>(a+b); return;}
}

#line 323 "runtime.in"
// pen *(real a, pen b);
void gen_runtime16(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  real a=vm::pop<real>(Stack);
#line 324 "runtime.in"
  {Stack->push<pen>(a*b); return;}
}

#line 328 "runtime.in"
// pen *(pen a, real b);
void gen_runtime17(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 329 "runtime.in"
  {Stack->push<pen>(b*a); return;}
}

#line 333 "runtime.in"
// pair max(pen p);
void gen_runtime18(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 334 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 338 "runtime.in"
// pair min(pen p);
void gen_runtime19(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 339 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

// Reset the meaning of pen default attributes.
#line 344 "runtime.in"
// void resetdefaultpen();
void gen_runtime20(stack *)
{
#line 345 "runtime.in"
  processData().defaultpen=camp::pen::initialpen();
}

#line 349 "runtime.in"
// void defaultpen(pen p);
void gen_runtime21(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 350 "runtime.in"
  processData().defaultpen=pen(resolvepen,p);
}

#line 354 "runtime.in"
// pen defaultpen();
void gen_runtime22(stack *Stack)
{
#line 355 "runtime.in"
  {Stack->push<pen>(processData().defaultpen); return;}
}

#line 359 "runtime.in"
// bool invisible(pen p);
void gen_runtime23(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 360 "runtime.in"
  {Stack->push<bool>(p.invisible()); return;}
}

#line 364 "runtime.in"
// pen invisible();
void gen_runtime24(stack *Stack)
{
#line 365 "runtime.in"
  {Stack->push<pen>(pen(invisiblepen)); return;}
}

#line 369 "runtime.in"
// pen gray(pen p);
void gen_runtime25(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 370 "runtime.in"
  p.togrey();
  {Stack->push<pen>(p); return;}
}

#line 375 "runtime.in"
// pen rgb(pen p);
void gen_runtime26(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 376 "runtime.in"
  p.torgb();
  {Stack->push<pen>(p); return;}
}

#line 381 "runtime.in"
// pen cmyk(pen p);
void gen_runtime27(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 382 "runtime.in"
  p.tocmyk();
  {Stack->push<pen>(p); return;}
}

#line 387 "runtime.in"
// pen interp(pen a, pen b, real t);
void gen_runtime28(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 388 "runtime.in"
  {Stack->push<pen>(interpolate(a,b,t)); return;}
}

#line 392 "runtime.in"
// pen rgb(real r, real g, real b);
void gen_runtime29(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real g=vm::pop<real>(Stack);
  real r=vm::pop<real>(Stack);
#line 393 "runtime.in"
  {Stack->push<pen>(pen(r,g,b)); return;}
}

#line 397 "runtime.in"
// pen cmyk(real c, real m, real y, real k);
void gen_runtime30(stack *Stack)
{
  real k=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real m=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
#line 398 "runtime.in"
  {Stack->push<pen>(pen(c,m,y,k)); return;}
}

#line 402 "runtime.in"
// pen gray(real gray);
void gen_runtime31(stack *Stack)
{
  real gray=vm::pop<real>(Stack);
#line 403 "runtime.in"
  {Stack->push<pen>(pen(gray)); return;}
}

#line 407 "runtime.in"
// realarray* colors(pen p);
void gen_runtime32(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 408 "runtime.in"
  size_t n=ColorComponents[p.colorspace()];
  array *a=new array(n);

  switch(n) {
    case 0:
      break;
    case 1:
      (*a)[0]=p.gray();
      break;
    case 3:
      (*a)[0]=p.red();
      (*a)[1]=p.green();
      (*a)[2]=p.blue();
      break;
    case 4:
      (*a)[0]=p.cyan();
      (*a)[1]=p.magenta();
      (*a)[2]=p.yellow();
      (*a)[3]=p.black();
      break;
    default:
      break;
  }
  {Stack->push<realarray*>(a); return;}
}

#line 435 "runtime.in"
// string hex(pen p);
void gen_runtime33(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 436 "runtime.in"
  {Stack->push<string>(p.hex()); return;}
}

#line 440 "runtime.in"
// Int byte(real x);
void gen_runtime34(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 441 "runtime.in"
  {Stack->push<Int>(camp::byte(x)); return;}
}

#line 445 "runtime.in"
// real byteinv(Int x);
void gen_runtime35(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
#line 446 "runtime.in"
  {Stack->push<real>(x >= 0 ? camp::byteinv(x) : 0.0); return;}
}

#line 450 "runtime.in"
// string colorspace(pen p);
void gen_runtime36(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 451 "runtime.in"
  string s=ColorDeviceSuffix[p.colorspace()];
  std::transform(s.begin(),s.end(),s.begin(),tolower);
  {Stack->push<string>(s); return;}
}

#line 457 "runtime.in"
// pen pattern(string *s);
void gen_runtime37(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 458 "runtime.in"
  {Stack->push<pen>(pen(setpattern,*s)); return;}
}

#line 462 "runtime.in"
// string pattern(pen p);
void gen_runtime38(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 463 "runtime.in"
  {Stack->push<string>(p.fillpattern()); return;}
}

#line 467 "runtime.in"
// pen fillrule(Int n);
void gen_runtime39(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 468 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nFill ? (FillRule) n : DEFFILL)); return;}
}

#line 472 "runtime.in"
// Int fillrule(pen p);
void gen_runtime40(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 473 "runtime.in"
  {Stack->push<Int>(p.Fillrule()); return;}
}

#line 477 "runtime.in"
// pen opacity(real opacity=1.0, string blend=defaulttransparency);
void gen_runtime41(stack *Stack)
{
  string blend=vm::pop<string>(Stack,defaulttransparency);
  real opacity=vm::pop<real>(Stack,1.0);
#line 478 "runtime.in"
  for(Int i=0; i < nBlendMode; ++i)
    if(blend == BlendMode[i]) {Stack->push<pen>(pen(Transparency(blend,opacity))); return;}

  ostringstream buf;
  buf << "Unknown blend mode: " << "'" << blend << "'";
  error(buf);
}

#line 487 "runtime.in"
// real opacity(pen p);
void gen_runtime42(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 488 "runtime.in"
  {Stack->push<real>(p.opacity()); return;}
}

#line 492 "runtime.in"
// string blend(pen p);
void gen_runtime43(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 493 "runtime.in"
  {Stack->push<string>(p.blend()); return;}
}

#line 497 "runtime.in"
// pen linetype(realarray *pattern, real offset=0, bool scale=true,             bool adjust=true);
void gen_runtime44(stack *Stack)
{
  bool adjust=vm::pop<bool>(Stack,true);
  bool scale=vm::pop<bool>(Stack,true);
  real offset=vm::pop<real>(Stack,0);
  realarray * pattern=vm::pop<realarray *>(Stack);
#line 499 "runtime.in"
  size_t size=checkArray(pattern);
  array *a=new array(size);
  for(size_t i=0; i < size; ++i)
    (*a)[i]=::max(vm::read<double>(pattern,i),0.0);

  {Stack->push<pen>(pen(LineType(*a,offset,scale,adjust))); return;}
}

#line 508 "runtime.in"
// realarray* linetype(pen p=CURRENTPEN);
void gen_runtime45(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 509 "runtime.in"
  array a=p.linetype()->pattern;
  {Stack->push<realarray*>(copyArray(&a)); return;}
}

#line 514 "runtime.in"
// real offset(pen p);
void gen_runtime46(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 515 "runtime.in"
  {Stack->push<real>(p.linetype()->offset); return;}
}

#line 519 "runtime.in"
// bool scale(pen p);
void gen_runtime47(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 520 "runtime.in"
  {Stack->push<bool>(p.linetype()->scale); return;}
}

#line 524 "runtime.in"
// bool adjust(pen p);
void gen_runtime48(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 525 "runtime.in"
  {Stack->push<bool>(p.linetype()->adjust); return;}
}

#line 529 "runtime.in"
// pen adjust(pen p, real arclength, bool cyclic);
void gen_runtime49(stack *Stack)
{
  bool cyclic=vm::pop<bool>(Stack);
  real arclength=vm::pop<real>(Stack);
  pen p=vm::pop<pen>(Stack);
#line 530 "runtime.in"
  {Stack->push<pen>(adjustdash(p,arclength,cyclic)); return;}
}

#line 534 "runtime.in"
// pen linecap(Int n);
void gen_runtime50(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 535 "runtime.in"
  {Stack->push<pen>(pen(setlinecap,n >= 0 && n < nCap ? n : DEFCAP)); return;}
}

#line 539 "runtime.in"
// Int linecap(pen p=CURRENTPEN);
void gen_runtime51(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 540 "runtime.in"
  {Stack->push<Int>(p.cap()); return;}
}

#line 544 "runtime.in"
// pen linejoin(Int n);
void gen_runtime52(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 545 "runtime.in"
  {Stack->push<pen>(pen(setlinejoin,n >= 0 && n < nJoin ? n : DEFJOIN)); return;}
}

#line 549 "runtime.in"
// Int linejoin(pen p=CURRENTPEN);
void gen_runtime53(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 550 "runtime.in"
  {Stack->push<Int>(p.join()); return;}
}

#line 554 "runtime.in"
// pen miterlimit(real x);
void gen_runtime54(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 555 "runtime.in"
  {Stack->push<pen>(pen(setmiterlimit,x >= 1.0 ? x : DEFJOIN)); return;}
}

#line 559 "runtime.in"
// real miterlimit(pen p=CURRENTPEN);
void gen_runtime55(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 560 "runtime.in"
  {Stack->push<real>(p.miter()); return;}
}

#line 564 "runtime.in"
// pen linewidth(real x);
void gen_runtime56(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 565 "runtime.in"
  {Stack->push<pen>(pen(setlinewidth,x >= 0.0 ? x : DEFWIDTH)); return;}
}

#line 569 "runtime.in"
// real linewidth(pen p=CURRENTPEN);
void gen_runtime57(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 570 "runtime.in"
  {Stack->push<real>(p.width()); return;}
}

#line 574 "runtime.in"
// pen fontcommand(string *s);
void gen_runtime58(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 575 "runtime.in"
  {Stack->push<pen>(pen(setfont,*s)); return;}
}

#line 579 "runtime.in"
// string font(pen p=CURRENTPEN);
void gen_runtime59(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 580 "runtime.in"
  {Stack->push<string>(p.Font()); return;}
}

#line 584 "runtime.in"
// pen fontsize(real size, real lineskip);
void gen_runtime60(stack *Stack)
{
  real lineskip=vm::pop<real>(Stack);
  real size=vm::pop<real>(Stack);
#line 585 "runtime.in"
  {Stack->push<pen>(pen(setfontsize,size > 0.0 ? size : 0.0,
             lineskip > 0.0 ? lineskip : 0.0)); return;}
}

#line 590 "runtime.in"
// real fontsize(pen p=CURRENTPEN);
void gen_runtime61(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 591 "runtime.in"
  {Stack->push<real>(p.size()); return;}
}

#line 595 "runtime.in"
// real lineskip(pen p=CURRENTPEN);
void gen_runtime62(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 596 "runtime.in"
  {Stack->push<real>(p.Lineskip()); return;}
}

#line 600 "runtime.in"
// pen overwrite(Int n);
void gen_runtime63(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 601 "runtime.in"
  {Stack->push<pen>(pen(setoverwrite,n >= 0 && n < nOverwrite ? (overwrite_t) n :
             DEFWRITE)); return;}
}

#line 606 "runtime.in"
// Int overwrite(pen p=CURRENTPEN);
void gen_runtime64(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 607 "runtime.in"
  {Stack->push<Int>(p.Overwrite()); return;}
}

#line 611 "runtime.in"
// pen basealign(Int n);
void gen_runtime65(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 612 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nBaseLine ? (BaseLine) n : DEFBASE)); return;}
}

#line 616 "runtime.in"
// Int basealign(pen p=CURRENTPEN);
void gen_runtime66(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 617 "runtime.in"
  {Stack->push<Int>(p.Baseline()); return;}
}

#line 621 "runtime.in"
// transform transform(pen p);
void gen_runtime67(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 622 "runtime.in"
  {Stack->push<transform>(p.getTransform()); return;}
}

#line 626 "runtime.in"
// path nib(pen p);
void gen_runtime68(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 627 "runtime.in"
  {Stack->push<path>(p.Path()); return;}
}

#line 631 "runtime.in"
// pen makepen(path p);
void gen_runtime69(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 632 "runtime.in"
  {Stack->push<pen>(pen(p)); return;}
}

#line 636 "runtime.in"
// pen colorless(pen p);
void gen_runtime70(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 637 "runtime.in"
  p.colorless();
  {Stack->push<pen>(p); return;}
}

// Interactive mode
#line 643 "runtime.in"
// bool interactive();
void gen_runtime71(stack *Stack)
{
#line 644 "runtime.in"
  {Stack->push<bool>(interact::interactive); return;}
}

#line 649 "runtime.in"
// bool uptodate();
void gen_runtime72(stack *Stack)
{
#line 650 "runtime.in"
  {Stack->push<bool>(interact::uptodate); return;}
}


// System commands
#line 656 "runtime.in"
// Int system(stringarray *s);
void gen_runtime73(stack *Stack)
{
  stringarray * s=vm::pop<stringarray *>(Stack);
#line 657 "runtime.in"
  if(safe) error("system() call disabled; override with option -nosafe");
  size_t size=checkArray(s);
  if(size == 0) {Stack->push<Int>(0); return;}
  mem::vector<string> cmd;
  for(size_t i=0; i < size; ++i)
    cmd.push_back(read<string>(s,i));
  {Stack->push<Int>(System(cmd)); return;}
}

#line 668 "runtime.in"
// bool view();
void gen_runtime74(stack *Stack)
{
#line 669 "runtime.in"
  {Stack->push<bool>(view()); return;}
}

#line 673 "runtime.in"
// string asydir();
void gen_runtime75(stack *Stack)
{
#line 674 "runtime.in"
  {Stack->push<string>(systemDir); return;}
}

#line 678 "runtime.in"
// string locale(string s=emptystring);
void gen_runtime76(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 679 "runtime.in"
  char *L=setlocale(LC_ALL,s.empty() ? NULL : s.c_str());
  {Stack->push<string>(L != NULL ? string(L) : ""); return;}
}

#line 684 "runtime.in"
// void abort(string s=emptystring);
void gen_runtime77(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 685 "runtime.in"
  if(s.empty()) throw handled_error();
  error(s.c_str());
}

#line 690 "runtime.in"
// void exit();
void gen_runtime78(stack *)
{
#line 691 "runtime.in"
  throw quit();
}

#line 695 "runtime.in"
// void assert(bool b, string s=emptystring);
void gen_runtime79(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
  bool b=vm::pop<bool>(Stack);
#line 696 "runtime.in"
  flush(cout);
  if(!b) {
    ostringstream buf;
    buf << "assert FAILED";
    if(s != "") buf << ": " << s;
    error(buf);
  }
}

#line 706 "runtime.in"
// void sleep(Int seconds);
void gen_runtime80(stack *Stack)
{
  Int seconds=vm::pop<Int>(Stack);
#line 707 "runtime.in"
  if(seconds <= 0) return;
  sleep(seconds);
}

#line 712 "runtime.in"
// void usleep(Int microseconds);
void gen_runtime81(stack *Stack)
{
  Int microseconds=vm::pop<Int>(Stack);
#line 713 "runtime.in"
  if(microseconds <= 0) return;
  usleep((unsigned long) microseconds);
}

#line 718 "runtime.in"
// void _eval(string *s, bool embedded, bool interactiveWrite=false);
void gen_runtime82(stack *Stack)
{
  bool interactiveWrite=vm::pop<bool>(Stack,false);
  bool embedded=vm::pop<bool>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 719 "runtime.in"
  if(embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if(e && is)
      runStringEmbedded(*s, *e, *is);
    else
      error(noruntime);
  } else
    runString(*s,interactiveWrite);
}

#line 731 "runtime.in"
// void _eval(runnable *s, bool embedded);
void gen_runtime83(stack *Stack)
{
  bool embedded=vm::pop<bool>(Stack);
  runnable * s=vm::pop<runnable *>(Stack);
#line 732 "runtime.in"
  absyntax::block *ast=new absyntax::block(s->getPos(), false);
  ast->add(s);

  if(embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if(e && is)
      runCodeEmbedded(ast, *e, *is);
    else
      error(noruntime);
  } else
    runCode(ast);
}

#line 747 "runtime.in"
// string xasyKEY();
void gen_runtime84(stack *Stack)
{
#line 748 "runtime.in"
  processDataStruct& P=processData();
  xkey_t& xkey=P.xkey;
  xkey_t::iterator p=xkey.find(P.topPos.LineColumn());
  {Stack->push<string>(p != xkey.end() ? p->second+" 1" : toplocation()+" 0"); return;}
}

#line 754 "runtime.in"
// void xasyKEY(string *s);
void gen_runtime85(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 755 "runtime.in"
  processData().KEY=*s;
}

#line 758 "runtime.in"
// string location();
void gen_runtime86(stack *Stack)
{
#line 759 "runtime.in"
  ostringstream buf;
  buf << getPos();
  {Stack->push<string>(buf.str()); return;}
}

// Wrapper for the stack::load() method.
#line 765 "runtime.in"
void loadModule(stack *Stack)
{
  string * index=vm::pop<string *>(Stack);
#line 766 "runtime.in"
  Stack->load(*index);
}

#line 770 "runtime.in"
// string cd(string s=emptystring);
void gen_runtime88(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 771 "runtime.in"
  if(!globalread()) readDisabled();
  if(!s.empty() && !globalwrite()) {
    string outname=settings::outname();
    string dir=stripFile(outname);
    if(dir.empty()) Setting("outname")=getPath()+dirsep+outname;
  }
  {Stack->push<string>(setPath(s.c_str())); return;}
}

#line 781 "runtime.in"
// void list(string *s, bool imports=false);
void gen_runtime89(stack *Stack)
{
  bool imports=vm::pop<bool>(Stack,false);
  string * s=vm::pop<string *>(Stack);
#line 782 "runtime.in"
  if(*s == "-") return;
  trans::genv ge;
  symbol name=symbol::trans(*s);
  record *r=ge.getModule(name,*s);
  r->e.list(imports ? 0 : r);
}


// Guide operations
#line 792 "runtime.in"
void nullGuide(stack *Stack)
{
#line 793 "runtime.in"
  {Stack->push<guide*>(new pathguide(path())); return;}
}

#line 798 "runtime.in"
void dotsGuide(stack *Stack)
{
  guidearray * a=vm::pop<guidearray *>(Stack);
#line 799 "runtime.in"
  guidevector v;
  size_t size=checkArray(a);
  for (size_t i=0; i < size; ++i)
    v.push_back(a->read<guide*>(i));

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 808 "runtime.in"
void dashesGuide(stack *Stack)
{
  guidearray * a=vm::pop<guidearray *>(Stack);
#line 809 "runtime.in"
  static camp::curlSpec curly;
  static camp::specguide curlout(&curly, camp::OUT);
  static camp::specguide curlin(&curly, camp::IN);

  size_t n=checkArray(a);

  // a--b is equivalent to a{curl 1}..{curl 1}b
  guidevector v;
  if (n > 0)
    v.push_back(a->read<guide*>(0));

  if (n==1) {
    v.push_back(&curlout);
    v.push_back(&curlin);
  }
  else
    for (size_t i=1; i<n; ++i) {
      v.push_back(&curlout);
      v.push_back(&curlin);
      v.push_back(a->read<guide*>(i));
    }

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 835 "runtime.in"
void newCycleToken(stack *Stack)
{
#line 836 "runtime.in"
  {Stack->push<cycleToken>(cycleToken()); return;}
}

#line 840 "runtime.in"
// guide* operator cast(cycleToken tok);
void gen_runtime94(stack *Stack)
{
  cycleToken tok=vm::pop<cycleToken>(Stack);
#line 841 "runtime.in"
// Avoid unused variable warning messages.
  unused(&tok);
  {Stack->push<guide*>(new cycletokguide()); return;}
}

#line 847 "runtime.in"
// guide* operator spec(pair z, Int p);
void gen_runtime95(stack *Stack)
{
  Int p=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 848 "runtime.in"
  camp::side d=(camp::side) p;
  camp::dirSpec *sp=new camp::dirSpec(z);

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 855 "runtime.in"
// curlSpecifier operator curl(real gamma, Int p);
void gen_runtime96(stack *Stack)
{
  Int p=vm::pop<Int>(Stack);
  real gamma=vm::pop<real>(Stack);
#line 856 "runtime.in"
  camp::side s=(camp::side) p;
  {Stack->push<curlSpecifier>(curlSpecifier(gamma,s)); return;}
}

#line 861 "runtime.in"
void curlSpecifierValuePart(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 862 "runtime.in"
  {Stack->push<real>(spec.getValue()); return;}
}

#line 866 "runtime.in"
void curlSpecifierSidePart(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 867 "runtime.in"
  {Stack->push<Int>(spec.getSide()); return;}
}

#line 871 "runtime.in"
// guide* operator cast(curlSpecifier spec);
void gen_runtime99(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 872 "runtime.in"
  {Stack->push<guide*>(new specguide(spec)); return;}
}

#line 876 "runtime.in"
// tensionSpecifier operator tension(real tout, real tin, bool atleast);
void gen_runtime100(stack *Stack)
{
  bool atleast=vm::pop<bool>(Stack);
  real tin=vm::pop<real>(Stack);
  real tout=vm::pop<real>(Stack);
#line 877 "runtime.in"
  {Stack->push<tensionSpecifier>(tensionSpecifier(tout, tin, atleast)); return;}
}

#line 881 "runtime.in"
void tensionSpecifierOutPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 882 "runtime.in"
  {Stack->push<real>(t.getOut()); return;}
}

#line 886 "runtime.in"
void tensionSpecifierInPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 887 "runtime.in"
  {Stack->push<real>(t.getIn()); return;}
}

#line 891 "runtime.in"
void tensionSpecifierAtleastPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 892 "runtime.in"
  {Stack->push<bool>(t.getAtleast()); return;}
}

#line 896 "runtime.in"
// guide* operator cast(tensionSpecifier t);
void gen_runtime104(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 897 "runtime.in"
  {Stack->push<guide*>(new tensionguide(t)); return;}
}

#line 901 "runtime.in"
// guide* operator controls(pair zout, pair zin);
void gen_runtime105(stack *Stack)
{
  pair zin=vm::pop<pair>(Stack);
  pair zout=vm::pop<pair>(Stack);
#line 902 "runtime.in"
  {Stack->push<guide*>(new controlguide(zout, zin)); return;}
}

#line 906 "runtime.in"
// Int size(guide *g);
void gen_runtime106(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 907 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<Int>(f.size()); return;}
}

#line 913 "runtime.in"
// Int length(guide *g);
void gen_runtime107(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 914 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<Int>(g->cyclic() ? f.size() : f.size()-1); return;}
}

#line 920 "runtime.in"
// bool cyclic(guide *g);
void gen_runtime108(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 921 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<bool>(g->cyclic()); return;}
}

#line 927 "runtime.in"
// pair point(guide *g, Int t);
void gen_runtime109(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 928 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<pair>(f.Nodes(adjustedIndex(t,f.size(),g->cyclic())).z); return;}
}

#line 934 "runtime.in"
// pairarray* dirSpecifier(guide *g, Int t);
void gen_runtime110(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 935 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<pairarray*>(new array(0)); return;}
  array *c=new array(2);
  (*c)[0]=f.Nodes(t).out->dir();
  (*c)[1]=f.Nodes(t+1).in->dir();
  {Stack->push<pairarray*>(c); return;}
}

#line 946 "runtime.in"
// pairarray* controlSpecifier(guide *g, Int t);
void gen_runtime111(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 947 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<pairarray*>(new array(0)); return;}
  knot curr=f.Nodes(t);
  knot next=f.Nodes(t+1);
  if(curr.out->controlled()) {
    assert(next.in->controlled());
    array *c=new array(2);
    (*c)[0]=curr.out->control();
    (*c)[1]=next.in->control();
    {Stack->push<pairarray*>(c); return;}
  } else {Stack->push<pairarray*>(new array(0)); return;}
}

#line 963 "runtime.in"
// tensionSpecifier tensionSpecifier(guide *g, Int t);
void gen_runtime112(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 964 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<tensionSpecifier>(tensionSpecifier(1.0,1.0,false)); return;}
  knot curr=f.Nodes(t);
  {Stack->push<tensionSpecifier>(tensionSpecifier(curr.tout.val,f.Nodes(t+1).tin.val,curr.tout.atleast)); return;}
}

#line 973 "runtime.in"
// realarray* curlSpecifier(guide *g, Int t);
void gen_runtime113(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 974 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<realarray*>(new array(0)); return;}
  array *c=new array(2);
  real c0=f.Nodes(t).out->curl();
  real c1=f.Nodes(t+1).in->curl();
  (*c)[0]=c0 >= 0.0 ? c0 : 1.0;
  (*c)[1]=c1 >= 0.0 ? c1 : 1.0;
  {Stack->push<realarray*>(c); return;}
}

#line 987 "runtime.in"
// guide* reverse(guide *g);
void gen_runtime114(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 988 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  if(f.precyclic())
    {Stack->push<guide*>(new pathguide(g->solve().reverse())); return;}

  size_t n=f.size();
  bool cyclic=g->cyclic();
  guidevector v;
  size_t start=cyclic ? n : n-1;
  knot curr=f.Nodes(start);
  knot next=curr;
  for(size_t i=start; i > 0; --i) {
    next=f.Nodes(i-1);
    v.push_back(new pairguide(curr.z));
    if(next.out->controlled()) {
      assert(curr.in->controlled());
      v.push_back(new controlguide(curr.in->control(),next.out->control()));
    } else {
      pair d=curr.in->dir();
      if(d != zero)
        v.push_back(new specguide(new dirSpec(-d),camp::OUT));
      else {
        real C=curr.in->curl();
        if(C >= 0.0)
          v.push_back(new specguide(new curlSpec(C),camp::OUT));
      }
      real tout=curr.tin.val;
      real tin=next.tout.val;
      bool atleast=next.tout.atleast;
      if(tout != 1.0 || tin != 1.0 || next.tout.atleast)
        v.push_back(new tensionguide(tensionSpecifier(tout,tin,atleast)));
      d=next.out->dir();
      if(d != zero)
        v.push_back(new specguide(new dirSpec(-d),camp::IN));
      else {
        real C=next.out->curl();
        if(C >= 0.0)
          v.push_back(new specguide(new curlSpec(C),camp::IN));
      }
    }
    curr=next;
  }
  if(cyclic)
    v.push_back(new cycletokguide());
  else
    v.push_back(new pairguide(next.z));

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1040 "runtime.in"
// realarray* _cputime();
void gen_runtime115(stack *Stack)
{
#line 1041 "runtime.in"
  static const real ticktime=1.0/sysconf(_SC_CLK_TCK);
  struct tms buf;

  ::times(&buf);
  array *t=new array(5);
  (*t)[0]=cpuTime.seconds(); // Includes system time
  (*t)[1]=0.0;
  (*t)[2]=((real) buf.tms_cutime)*ticktime;
  (*t)[3]=((real) buf.tms_cstime)*ticktime;
  (*t)[4]=wallClock.seconds();
  {Stack->push<realarray*>(t); return;}
}


// Transforms
#line 1057 "runtime.in"
// bool ==(transform a, transform b);
void gen_runtime116(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 1058 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1063 "runtime.in"
// bool !=(transform a, transform b);
void gen_runtime117(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 1064 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 1068 "runtime.in"
// transform +(transform a, transform b);
void gen_runtime118(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 1069 "runtime.in"
  {Stack->push<transform>(a+b); return;}
}

#line 1073 "runtime.in"
// transform *(transform a, transform b);
void gen_runtime119(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 1074 "runtime.in"
  {Stack->push<transform>(a*b); return;}
}

#line 1078 "runtime.in"
// pair *(transform t, pair z);
void gen_runtime120(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 1079 "runtime.in"
  {Stack->push<pair>(t*z); return;}
}

#line 1083 "runtime.in"
// path *(transform t, path g);
void gen_runtime121(stack *Stack)
{
  path g=vm::pop<path>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 1084 "runtime.in"
  {Stack->push<path>(transformed(t,g)); return;}
}

#line 1088 "runtime.in"
// pen *(transform t, pen p);
void gen_runtime122(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 1089 "runtime.in"
  {Stack->push<pen>(transformed(t,p)); return;}
}

#line 1093 "runtime.in"
// picture* *(transform t, picture *f);
void gen_runtime123(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 1094 "runtime.in"
  {Stack->push<picture*>(transformed(t,f)); return;}
}

#line 1098 "runtime.in"
// picture* *(realarray2 *t, picture *f);
void gen_runtime124(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
#line 1099 "runtime.in"
  {Stack->push<picture*>(transformed(*t,f)); return;}
}

#line 1103 "runtime.in"
// transform ^(transform t, Int n);
void gen_runtime125(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 1104 "runtime.in"
  transform T;
  if(n < 0) {
    n=-n;
    t=inverse(t);
  }
  for(Int i=0; i < n; i++) T=T*t;
  {Stack->push<transform>(T); return;}
}

#line 1114 "runtime.in"
void transformXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1115 "runtime.in"
  {Stack->push<real>(t.getx()); return;}
}

#line 1119 "runtime.in"
void transformYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1120 "runtime.in"
  {Stack->push<real>(t.gety()); return;}
}

#line 1124 "runtime.in"
void transformXXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1125 "runtime.in"
  {Stack->push<real>(t.getxx()); return;}
}

#line 1129 "runtime.in"
void transformXYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1130 "runtime.in"
  {Stack->push<real>(t.getxy()); return;}
}

#line 1134 "runtime.in"
void transformYXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1135 "runtime.in"
  {Stack->push<real>(t.getyx()); return;}
}

#line 1139 "runtime.in"
void transformYYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1140 "runtime.in"
  {Stack->push<real>(t.getyy()); return;}
}

#line 1144 "runtime.in"
void real6ToTransform(stack *Stack)
{
  real yy=vm::pop<real>(Stack);
  real yx=vm::pop<real>(Stack);
  real xy=vm::pop<real>(Stack);
  real xx=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 1146 "runtime.in"
  {Stack->push<transform>(transform(x,y,xx,xy,yx,yy)); return;}
}

#line 1150 "runtime.in"
// transform shift(transform t);
void gen_runtime133(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1151 "runtime.in"
  {Stack->push<transform>(transform(t.getx(),t.gety(),0,0,0,0)); return;}
}

#line 1155 "runtime.in"
// transform shiftless(transform t);
void gen_runtime134(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1156 "runtime.in"
  {Stack->push<transform>(transform(0,0,t.getxx(),t.getxy(),t.getyx(),t.getyy())); return;}
}

#line 1160 "runtime.in"
// transform identity();
void transformIdentity(stack *Stack)
{
#line 1161 "runtime.in"
  {Stack->push<transform>(identity); return;}
}

#line 1165 "runtime.in"
// transform inverse(transform t);
void gen_runtime136(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1166 "runtime.in"
  {Stack->push<transform>(inverse(t)); return;}
}

#line 1170 "runtime.in"
// transform shift(pair z);
void gen_runtime137(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 1171 "runtime.in"
  {Stack->push<transform>(shift(z)); return;}
}

#line 1175 "runtime.in"
// transform shift(real x, real y);
void gen_runtime138(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 1176 "runtime.in"
  {Stack->push<transform>(shift(pair(x,y))); return;}
}

#line 1180 "runtime.in"
// transform xscale(real x);
void gen_runtime139(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 1181 "runtime.in"
  {Stack->push<transform>(xscale(x)); return;}
}

#line 1185 "runtime.in"
// transform yscale(real y);
void gen_runtime140(stack *Stack)
{
  real y=vm::pop<real>(Stack);
#line 1186 "runtime.in"
  {Stack->push<transform>(yscale(y)); return;}
}

#line 1190 "runtime.in"
// transform scale(real x);
void gen_runtime141(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 1191 "runtime.in"
  {Stack->push<transform>(scale(x)); return;}
}

#line 1195 "runtime.in"
// transform scale(real x, real y);
void gen_runtime142(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 1196 "runtime.in"
  {Stack->push<transform>(scale(x,y)); return;}
}

#line 1200 "runtime.in"
// transform slant(real s);
void gen_runtime143(stack *Stack)
{
  real s=vm::pop<real>(Stack);
#line 1201 "runtime.in"
  {Stack->push<transform>(slant(s)); return;}
}

#line 1205 "runtime.in"
// transform rotate(real angle, pair z=0);
void gen_runtime144(stack *Stack)
{
  pair z=vm::pop<pair>(Stack,0);
  real angle=vm::pop<real>(Stack);
#line 1206 "runtime.in"
  {Stack->push<transform>(rotatearound(z,radians(angle))); return;}
}

#line 1210 "runtime.in"
// transform reflect(pair a, pair b);
void gen_runtime145(stack *Stack)
{
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 1211 "runtime.in"
  {Stack->push<transform>(reflectabout(a,b)); return;}
}

#line 1215 "runtime.in"
// bool isometry(transform t);
void gen_runtime146(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 1216 "runtime.in"
  {Stack->push<bool>(t.isIsometry()); return;}
}

#line 1220 "runtime.in"
// real bezier(real a, real b, real c, real d, real t);
void gen_runtime147(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  real d=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 1221 "runtime.in"
  real onemt=1-t;
  real onemt2=onemt*onemt;
  {Stack->push<real>(onemt2*onemt*a+t*(3.0*(onemt2*b+t*onemt*c)+t*t*d)); return;}
}

} // namespace run

namespace trans {

void gen_runtime_venv(venv &ve)
{
#line 227 "runtime.in"
  REGISTER_BLTIN(run::IntZero,"IntZero");
#line 235 "runtime.in"
  REGISTER_BLTIN(run::realZero,"realZero");
#line 240 "runtime.in"
  REGISTER_BLTIN(run::boolFalse,"boolFalse");
#line 245 "runtime.in"
  addFunc(ve, run::gen_runtime3, primBoolean(), SYM(isnan), formal(primReal(), SYM(x), false, false));
#line 250 "runtime.in"
  REGISTER_BLTIN(run::pushNullArray,"pushNullArray");
#line 255 "runtime.in"
  REGISTER_BLTIN(run::pushNullRecord,"pushNullRecord");
#line 260 "runtime.in"
  REGISTER_BLTIN(run::pushNullFunction,"pushNullFunction");
#line 265 "runtime.in"
  REGISTER_BLTIN(run::pushDefault,"pushDefault");
#line 275 "runtime.in"
  REGISTER_BLTIN(run::isDefault,"isDefault");
#line 282 "runtime.in"
  REGISTER_BLTIN(run::pairToGuide,"pairToGuide");
#line 290 "runtime.in"
  REGISTER_BLTIN(run::pathToGuide,"pathToGuide");
#line 295 "runtime.in"
  REGISTER_BLTIN(run::guideToPath,"guideToPath");
#line 300 "runtime.in"
  REGISTER_BLTIN(run::newPen,"newPen");
#line 308 "runtime.in"
  addFunc(ve, run::gen_runtime13, primBoolean(), SYM_EQ, formal(primPen(), SYM(a), false, false), formal(primPen(), SYM(b), false, false));
#line 313 "runtime.in"
  addFunc(ve, run::gen_runtime14, primBoolean(), SYM_NEQ, formal(primPen(), SYM(a), false, false), formal(primPen(), SYM(b), false, false));
#line 318 "runtime.in"
  addFunc(ve, run::gen_runtime15, primPen(), SYM_PLUS, formal(primPen(), SYM(a), false, false), formal(primPen(), SYM(b), false, false));
#line 323 "runtime.in"
  addFunc(ve, run::gen_runtime16, primPen(), SYM_TIMES, formal(primReal(), SYM(a), false, false), formal(primPen(), SYM(b), false, false));
#line 328 "runtime.in"
  addFunc(ve, run::gen_runtime17, primPen(), SYM_TIMES, formal(primPen(), SYM(a), false, false), formal(primReal(), SYM(b), false, false));
#line 333 "runtime.in"
  addFunc(ve, run::gen_runtime18, primPair(), SYM(max), formal(primPen(), SYM(p), false, false));
#line 338 "runtime.in"
  addFunc(ve, run::gen_runtime19, primPair(), SYM(min), formal(primPen(), SYM(p), false, false));
#line 343 "runtime.in"
  addFunc(ve, run::gen_runtime20, primVoid(), SYM(resetdefaultpen));
#line 349 "runtime.in"
  addFunc(ve, run::gen_runtime21, primVoid(), SYM(defaultpen), formal(primPen(), SYM(p), false, false));
#line 354 "runtime.in"
  addFunc(ve, run::gen_runtime22, primPen(), SYM(defaultpen));
#line 359 "runtime.in"
  addFunc(ve, run::gen_runtime23, primBoolean(), SYM(invisible), formal(primPen(), SYM(p), false, false));
#line 364 "runtime.in"
  addFunc(ve, run::gen_runtime24, primPen(), SYM(invisible));
#line 369 "runtime.in"
  addFunc(ve, run::gen_runtime25, primPen(), SYM(gray), formal(primPen(), SYM(p), false, false));
#line 375 "runtime.in"
  addFunc(ve, run::gen_runtime26, primPen(), SYM(rgb), formal(primPen(), SYM(p), false, false));
#line 381 "runtime.in"
  addFunc(ve, run::gen_runtime27, primPen(), SYM(cmyk), formal(primPen(), SYM(p), false, false));
#line 387 "runtime.in"
  addFunc(ve, run::gen_runtime28, primPen(), SYM(interp), formal(primPen(), SYM(a), false, false), formal(primPen(), SYM(b), false, false), formal(primReal(), SYM(t), false, false));
#line 392 "runtime.in"
  addFunc(ve, run::gen_runtime29, primPen(), SYM(rgb), formal(primReal(), SYM(r), false, false), formal(primReal(), SYM(g), false, false), formal(primReal(), SYM(b), false, false));
#line 397 "runtime.in"
  addFunc(ve, run::gen_runtime30, primPen(), SYM(cmyk), formal(primReal(), SYM(c), false, false), formal(primReal(), SYM(m), false, false), formal(primReal(), SYM(y), false, false), formal(primReal(), SYM(k), false, false));
#line 402 "runtime.in"
  addFunc(ve, run::gen_runtime31, primPen(), SYM(gray), formal(primReal(), SYM(gray), false, false));
#line 407 "runtime.in"
  addFunc(ve, run::gen_runtime32, realArray(), SYM(colors), formal(primPen(), SYM(p), false, false));
#line 435 "runtime.in"
  addFunc(ve, run::gen_runtime33, primString(), SYM(hex), formal(primPen(), SYM(p), false, false));
#line 440 "runtime.in"
  addFunc(ve, run::gen_runtime34, primInt(), SYM(byte), formal(primReal(), SYM(x), false, false));
#line 445 "runtime.in"
  addFunc(ve, run::gen_runtime35, primReal(), SYM(byteinv), formal(primInt(), SYM(x), false, false));
#line 450 "runtime.in"
  addFunc(ve, run::gen_runtime36, primString(), SYM(colorspace), formal(primPen(), SYM(p), false, false));
#line 457 "runtime.in"
  addFunc(ve, run::gen_runtime37, primPen(), SYM(pattern), formal(primString(), SYM(s), false, false));
#line 462 "runtime.in"
  addFunc(ve, run::gen_runtime38, primString(), SYM(pattern), formal(primPen(), SYM(p), false, false));
#line 467 "runtime.in"
  addFunc(ve, run::gen_runtime39, primPen(), SYM(fillrule), formal(primInt(), SYM(n), false, false));
#line 472 "runtime.in"
  addFunc(ve, run::gen_runtime40, primInt(), SYM(fillrule), formal(primPen(), SYM(p), false, false));
#line 477 "runtime.in"
  addFunc(ve, run::gen_runtime41, primPen(), SYM(opacity), formal(primReal(), SYM(opacity), true, false), formal(primString(), SYM(blend), true, false));
#line 487 "runtime.in"
  addFunc(ve, run::gen_runtime42, primReal(), SYM(opacity), formal(primPen(), SYM(p), false, false));
#line 492 "runtime.in"
  addFunc(ve, run::gen_runtime43, primString(), SYM(blend), formal(primPen(), SYM(p), false, false));
#line 497 "runtime.in"
  addFunc(ve, run::gen_runtime44, primPen(), SYM(linetype), formal(realArray(), SYM(pattern), false, false), formal(primReal(), SYM(offset), true, false), formal(primBoolean(), SYM(scale), true, false), formal(primBoolean(), SYM(adjust), true, false));
#line 508 "runtime.in"
  addFunc(ve, run::gen_runtime45, realArray(), SYM(linetype), formal(primPen(), SYM(p), true, false));
#line 514 "runtime.in"
  addFunc(ve, run::gen_runtime46, primReal(), SYM(offset), formal(primPen(), SYM(p), false, false));
#line 519 "runtime.in"
  addFunc(ve, run::gen_runtime47, primBoolean(), SYM(scale), formal(primPen(), SYM(p), false, false));
#line 524 "runtime.in"
  addFunc(ve, run::gen_runtime48, primBoolean(), SYM(adjust), formal(primPen(), SYM(p), false, false));
#line 529 "runtime.in"
  addFunc(ve, run::gen_runtime49, primPen(), SYM(adjust), formal(primPen(), SYM(p), false, false), formal(primReal(), SYM(arclength), false, false), formal(primBoolean(), SYM(cyclic), false, false));
#line 534 "runtime.in"
  addFunc(ve, run::gen_runtime50, primPen(), SYM(linecap), formal(primInt(), SYM(n), false, false));
#line 539 "runtime.in"
  addFunc(ve, run::gen_runtime51, primInt(), SYM(linecap), formal(primPen(), SYM(p), true, false));
#line 544 "runtime.in"
  addFunc(ve, run::gen_runtime52, primPen(), SYM(linejoin), formal(primInt(), SYM(n), false, false));
#line 549 "runtime.in"
  addFunc(ve, run::gen_runtime53, primInt(), SYM(linejoin), formal(primPen(), SYM(p), true, false));
#line 554 "runtime.in"
  addFunc(ve, run::gen_runtime54, primPen(), SYM(miterlimit), formal(primReal(), SYM(x), false, false));
#line 559 "runtime.in"
  addFunc(ve, run::gen_runtime55, primReal(), SYM(miterlimit), formal(primPen(), SYM(p), true, false));
#line 564 "runtime.in"
  addFunc(ve, run::gen_runtime56, primPen(), SYM(linewidth), formal(primReal(), SYM(x), false, false));
#line 569 "runtime.in"
  addFunc(ve, run::gen_runtime57, primReal(), SYM(linewidth), formal(primPen(), SYM(p), true, false));
#line 574 "runtime.in"
  addFunc(ve, run::gen_runtime58, primPen(), SYM(fontcommand), formal(primString(), SYM(s), false, false));
#line 579 "runtime.in"
  addFunc(ve, run::gen_runtime59, primString(), SYM(font), formal(primPen(), SYM(p), true, false));
#line 584 "runtime.in"
  addFunc(ve, run::gen_runtime60, primPen(), SYM(fontsize), formal(primReal(), SYM(size), false, false), formal(primReal(), SYM(lineskip), false, false));
#line 590 "runtime.in"
  addFunc(ve, run::gen_runtime61, primReal(), SYM(fontsize), formal(primPen(), SYM(p), true, false));
#line 595 "runtime.in"
  addFunc(ve, run::gen_runtime62, primReal(), SYM(lineskip), formal(primPen(), SYM(p), true, false));
#line 600 "runtime.in"
  addFunc(ve, run::gen_runtime63, primPen(), SYM(overwrite), formal(primInt(), SYM(n), false, false));
#line 606 "runtime.in"
  addFunc(ve, run::gen_runtime64, primInt(), SYM(overwrite), formal(primPen(), SYM(p), true, false));
#line 611 "runtime.in"
  addFunc(ve, run::gen_runtime65, primPen(), SYM(basealign), formal(primInt(), SYM(n), false, false));
#line 616 "runtime.in"
  addFunc(ve, run::gen_runtime66, primInt(), SYM(basealign), formal(primPen(), SYM(p), true, false));
#line 621 "runtime.in"
  addFunc(ve, run::gen_runtime67, primTransform(), SYM(transform), formal(primPen(), SYM(p), false, false));
#line 626 "runtime.in"
  addFunc(ve, run::gen_runtime68, primPath(), SYM(nib), formal(primPen(), SYM(p), false, false));
#line 631 "runtime.in"
  addFunc(ve, run::gen_runtime69, primPen(), SYM(makepen), formal(primPath(), SYM(p), false, false));
#line 636 "runtime.in"
  addFunc(ve, run::gen_runtime70, primPen(), SYM(colorless), formal(primPen(), SYM(p), false, false));
#line 642 "runtime.in"
  addFunc(ve, run::gen_runtime71, primBoolean(), SYM(interactive));
#line 649 "runtime.in"
  addFunc(ve, run::gen_runtime72, primBoolean(), SYM(uptodate));
#line 654 "runtime.in"
  addFunc(ve, run::gen_runtime73, primInt(), SYM(system), formal(stringArray(), SYM(s), false, false));
#line 668 "runtime.in"
  addFunc(ve, run::gen_runtime74, primBoolean(), SYM(view));
#line 673 "runtime.in"
  addFunc(ve, run::gen_runtime75, primString(), SYM(asydir));
#line 678 "runtime.in"
  addFunc(ve, run::gen_runtime76, primString(), SYM(locale), formal(primString(), SYM(s), true, false));
#line 684 "runtime.in"
  addFunc(ve, run::gen_runtime77, primVoid(), SYM(abort), formal(primString(), SYM(s), true, false));
#line 690 "runtime.in"
  addFunc(ve, run::gen_runtime78, primVoid(), SYM(exit));
#line 695 "runtime.in"
  addFunc(ve, run::gen_runtime79, primVoid(), SYM(assert), formal(primBoolean(), SYM(b), false, false), formal(primString(), SYM(s), true, false));
#line 706 "runtime.in"
  addFunc(ve, run::gen_runtime80, primVoid(), SYM(sleep), formal(primInt(), SYM(seconds), false, false));
#line 712 "runtime.in"
  addFunc(ve, run::gen_runtime81, primVoid(), SYM(usleep), formal(primInt(), SYM(microseconds), false, false));
#line 718 "runtime.in"
  addFunc(ve, run::gen_runtime82, primVoid(), SYM(_eval), formal(primString(), SYM(s), false, false), formal(primBoolean(), SYM(embedded), false, false), formal(primBoolean(), SYM(interactivewrite), true, false));
#line 731 "runtime.in"
  addFunc(ve, run::gen_runtime83, primVoid(), SYM(_eval), formal(primCode(), SYM(s), false, false), formal(primBoolean(), SYM(embedded), false, false));
#line 747 "runtime.in"
  addFunc(ve, run::gen_runtime84, primString(), SYM(xasyKEY));
#line 754 "runtime.in"
  addFunc(ve, run::gen_runtime85, primVoid(), SYM(xasyKEY), formal(primString(), SYM(s), false, false));
#line 758 "runtime.in"
  addFunc(ve, run::gen_runtime86, primString(), SYM(location));
#line 764 "runtime.in"
  REGISTER_BLTIN(run::loadModule,"loadModule");
#line 770 "runtime.in"
  addFunc(ve, run::gen_runtime88, primString(), SYM(cd), formal(primString(), SYM(s), true, false));
#line 781 "runtime.in"
  addFunc(ve, run::gen_runtime89, primVoid(), SYM(list), formal(primString(), SYM(s), false, false), formal(primBoolean(), SYM(imports), true, false));
#line 790 "runtime.in"
  REGISTER_BLTIN(run::nullGuide,"nullGuide");
#line 798 "runtime.in"
  REGISTER_BLTIN(run::dotsGuide,"dotsGuide");
#line 808 "runtime.in"
  REGISTER_BLTIN(run::dashesGuide,"dashesGuide");
#line 835 "runtime.in"
  REGISTER_BLTIN(run::newCycleToken,"newCycleToken");
#line 840 "runtime.in"
  addFunc(ve, run::gen_runtime94, primGuide(), symbol::trans("operator cast"), formal(primCycleToken(), SYM(tok), false, false));
#line 847 "runtime.in"
  addFunc(ve, run::gen_runtime95, primGuide(), symbol::trans("operator spec"), formal(primPair(), SYM(z), false, false), formal(primInt(), SYM(p), false, false));
#line 855 "runtime.in"
  addFunc(ve, run::gen_runtime96, primCurlSpecifier(), SYM_CURL, formal(primReal(), SYM(gamma), false, false), formal(primInt(), SYM(p), false, false));
#line 861 "runtime.in"
  REGISTER_BLTIN(run::curlSpecifierValuePart,"curlSpecifierValuePart");
#line 866 "runtime.in"
  REGISTER_BLTIN(run::curlSpecifierSidePart,"curlSpecifierSidePart");
#line 871 "runtime.in"
  addFunc(ve, run::gen_runtime99, primGuide(), symbol::trans("operator cast"), formal(primCurlSpecifier(), SYM(spec), false, false));
#line 876 "runtime.in"
  addFunc(ve, run::gen_runtime100, primTensionSpecifier(), SYM_TENSION, formal(primReal(), SYM(tout), false, false), formal(primReal(), SYM(tin), false, false), formal(primBoolean(), SYM(atleast), false, false));
#line 881 "runtime.in"
  REGISTER_BLTIN(run::tensionSpecifierOutPart,"tensionSpecifierOutPart");
#line 886 "runtime.in"
  REGISTER_BLTIN(run::tensionSpecifierInPart,"tensionSpecifierInPart");
#line 891 "runtime.in"
  REGISTER_BLTIN(run::tensionSpecifierAtleastPart,"tensionSpecifierAtleastPart");
#line 896 "runtime.in"
  addFunc(ve, run::gen_runtime104, primGuide(), symbol::trans("operator cast"), formal(primTensionSpecifier(), SYM(t), false, false));
#line 901 "runtime.in"
  addFunc(ve, run::gen_runtime105, primGuide(), SYM_CONTROLS, formal(primPair(), SYM(zout), false, false), formal(primPair(), SYM(zin), false, false));
#line 906 "runtime.in"
  addFunc(ve, run::gen_runtime106, primInt(), SYM(size), formal(primGuide(), SYM(g), false, false));
#line 913 "runtime.in"
  addFunc(ve, run::gen_runtime107, primInt(), SYM(length), formal(primGuide(), SYM(g), false, false));
#line 920 "runtime.in"
  addFunc(ve, run::gen_runtime108, primBoolean(), SYM(cyclic), formal(primGuide(), SYM(g), false, false));
#line 927 "runtime.in"
  addFunc(ve, run::gen_runtime109, primPair(), SYM(point), formal(primGuide(), SYM(g), false, false), formal(primInt(), SYM(t), false, false));
#line 934 "runtime.in"
  addFunc(ve, run::gen_runtime110, pairArray(), SYM(dirSpecifier), formal(primGuide(), SYM(g), false, false), formal(primInt(), SYM(t), false, false));
#line 946 "runtime.in"
  addFunc(ve, run::gen_runtime111, pairArray(), SYM(controlSpecifier), formal(primGuide(), SYM(g), false, false), formal(primInt(), SYM(t), false, false));
#line 963 "runtime.in"
  addFunc(ve, run::gen_runtime112, primTensionSpecifier(), SYM(tensionSpecifier), formal(primGuide(), SYM(g), false, false), formal(primInt(), SYM(t), false, false));
#line 973 "runtime.in"
  addFunc(ve, run::gen_runtime113, realArray(), SYM(curlSpecifier), formal(primGuide(), SYM(g), false, false), formal(primInt(), SYM(t), false, false));
#line 987 "runtime.in"
  addFunc(ve, run::gen_runtime114, primGuide(), SYM(reverse), formal(primGuide(), SYM(g), false, false));
#line 1040 "runtime.in"
  addFunc(ve, run::gen_runtime115, realArray(), SYM(_cputime));
#line 1055 "runtime.in"
  addFunc(ve, run::gen_runtime116, primBoolean(), SYM_EQ, formal(primTransform(), SYM(a), false, false), formal(primTransform(), SYM(b), false, false));
#line 1063 "runtime.in"
  addFunc(ve, run::gen_runtime117, primBoolean(), SYM_NEQ, formal(primTransform(), SYM(a), false, false), formal(primTransform(), SYM(b), false, false));
#line 1068 "runtime.in"
  addFunc(ve, run::gen_runtime118, primTransform(), SYM_PLUS, formal(primTransform(), SYM(a), false, false), formal(primTransform(), SYM(b), false, false));
#line 1073 "runtime.in"
  addFunc(ve, run::gen_runtime119, primTransform(), SYM_TIMES, formal(primTransform(), SYM(a), false, false), formal(primTransform(), SYM(b), false, false));
#line 1078 "runtime.in"
  addFunc(ve, run::gen_runtime120, primPair(), SYM_TIMES, formal(primTransform(), SYM(t), false, false), formal(primPair(), SYM(z), false, false));
#line 1083 "runtime.in"
  addFunc(ve, run::gen_runtime121, primPath(), SYM_TIMES, formal(primTransform(), SYM(t), false, false), formal(primPath(), SYM(g), false, false));
#line 1088 "runtime.in"
  addFunc(ve, run::gen_runtime122, primPen(), SYM_TIMES, formal(primTransform(), SYM(t), false, false), formal(primPen(), SYM(p), false, false));
#line 1093 "runtime.in"
  addFunc(ve, run::gen_runtime123, primPicture(), SYM_TIMES, formal(primTransform(), SYM(t), false, false), formal(primPicture(), SYM(f), false, false));
#line 1098 "runtime.in"
  addFunc(ve, run::gen_runtime124, primPicture(), SYM_TIMES, formal(realArray2(), SYM(t), false, false), formal(primPicture(), SYM(f), false, false));
#line 1103 "runtime.in"
  addFunc(ve, run::gen_runtime125, primTransform(), SYM_CARET, formal(primTransform(), SYM(t), false, false), formal(primInt(), SYM(n), false, false));
#line 1114 "runtime.in"
  REGISTER_BLTIN(run::transformXPart,"transformXPart");
#line 1119 "runtime.in"
  REGISTER_BLTIN(run::transformYPart,"transformYPart");
#line 1124 "runtime.in"
  REGISTER_BLTIN(run::transformXXPart,"transformXXPart");
#line 1129 "runtime.in"
  REGISTER_BLTIN(run::transformXYPart,"transformXYPart");
#line 1134 "runtime.in"
  REGISTER_BLTIN(run::transformYXPart,"transformYXPart");
#line 1139 "runtime.in"
  REGISTER_BLTIN(run::transformYYPart,"transformYYPart");
#line 1144 "runtime.in"
  REGISTER_BLTIN(run::real6ToTransform,"real6ToTransform");
#line 1150 "runtime.in"
  addFunc(ve, run::gen_runtime133, primTransform(), SYM(shift), formal(primTransform(), SYM(t), false, false));
#line 1155 "runtime.in"
  addFunc(ve, run::gen_runtime134, primTransform(), SYM(shiftless), formal(primTransform(), SYM(t), false, false));
#line 1160 "runtime.in"
  addFunc(ve, run::transformIdentity, primTransform(), SYM(identity));
#line 1165 "runtime.in"
  addFunc(ve, run::gen_runtime136, primTransform(), SYM(inverse), formal(primTransform(), SYM(t), false, false));
#line 1170 "runtime.in"
  addFunc(ve, run::gen_runtime137, primTransform(), SYM(shift), formal(primPair(), SYM(z), false, false));
#line 1175 "runtime.in"
  addFunc(ve, run::gen_runtime138, primTransform(), SYM(shift), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 1180 "runtime.in"
  addFunc(ve, run::gen_runtime139, primTransform(), SYM(xscale), formal(primReal(), SYM(x), false, false));
#line 1185 "runtime.in"
  addFunc(ve, run::gen_runtime140, primTransform(), SYM(yscale), formal(primReal(), SYM(y), false, false));
#line 1190 "runtime.in"
  addFunc(ve, run::gen_runtime141, primTransform(), SYM(scale), formal(primReal(), SYM(x), false, false));
#line 1195 "runtime.in"
  addFunc(ve, run::gen_runtime142, primTransform(), SYM(scale), formal(primReal(), SYM(x), false, false), formal(primReal(), SYM(y), false, false));
#line 1200 "runtime.in"
  addFunc(ve, run::gen_runtime143, primTransform(), SYM(slant), formal(primReal(), SYM(s), false, false));
#line 1205 "runtime.in"
  addFunc(ve, run::gen_runtime144, primTransform(), SYM(rotate), formal(primReal(), SYM(angle), false, false), formal(primPair(), SYM(z), true, false));
#line 1210 "runtime.in"
  addFunc(ve, run::gen_runtime145, primTransform(), SYM(reflect), formal(primPair(), SYM(a), false, false), formal(primPair(), SYM(b), false, false));
#line 1215 "runtime.in"
  addFunc(ve, run::gen_runtime146, primBoolean(), SYM(isometry), formal(primTransform(), SYM(t), false, false));
#line 1220 "runtime.in"
  addFunc(ve, run::gen_runtime147, primReal(), SYM(bezier), formal(primReal(), SYM(a), false, false), formal(primReal(), SYM(b), false, false), formal(primReal(), SYM(c), false, false), formal(primReal(), SYM(d), false, false), formal(primReal(), SYM(t), false, false));
}

} // namespace trans
