# Motorola 6809
## Section alignment
Sections are not aligned to any particular multiple.

## __DCB, __RS, __DSB

|| 8 bit | 16 bit | 32 bit |
|---|---|---|---|
| Define data | DB | DW | |
| Define space | DS | | |
| Reserve symbol | RB | RW | |

## Directives
The 6809 supports a smaller and faster adressing mode known as "direct addressing". This mode combines the contents of the `DP` register with the 8 bit value from the opcode to form the final 16 bit address.

To use this mode one can either use the `<` operator, for example `LDA <$12`, or the assembler can be informed of the `DP` register contents and automatically decide. This directive should be used right after loading the `DP` register.

```
    ldb      #$15
    tfr      b,dp
    SETDP    $15    ; The assembler now knows about the DP register
    lda      $1512  ; A direct mode addressing mode will be generated since the most significant byte matches the DP register contents
```

`SETDP` can also be used without an argument to reset the assembler's knowledge about the `DP` register contents.


