# 6502 family

## Section alignment
Sections are not aligned to any particular multiple.

## Command line

### -mc\<x> option
Selects CPU variant.

| x | CPU type |
|---|---|
| 0 | 6502 |
| 1 | 65C02 |
| 2 | 65C02S |
| 3 | 65C816 |
| 4 | 4510 |
| 5 | 45GS02 |

### -ms<x> option
This option enables certain synthesized instructions.

| x | Synthesized instructions |
|---|---|
| 0 | Disabled |
| 1 | Enabled |

Synthesized instructions are safe sequences with no unintended side effects. These can be used to improve readabilility of source code.

| Mnemonic | Notes |
|---|---|
| ASL #n | Generates a number of shift instructions |
| LSL #n | Generates a number of shift instructions |
| ROL #n | Generates a number of rotate instructions |
| ROR #n | Generates a number of rotate instructions |


### -mu\<x> option
Some versions of the 6502 series have a number of undocumented instructions. As they are undocumented, no official mnemonics exist. Several sets of mnemonics are in use, however. These can be selected with the ```-mu<x>``` option, where x is 0 (no undocumented opcodes), 1, 2 or 3.

| Set #1 | Set #2 | Set #3 |
|---|---|---|
| AAC | ANC | ANC |
| AAX | SAX | AXS |
| ARR | ARR | ARR |
| ASR | ASR | ALR |
| ATX | LXA | OAL |
| AXA | SHA | AXA |
| AXS | SBX | SAX |
| DCP | DCP | DCM |
| DOP | DOP | SKB |
| ISC | ISB | INS |
| KIL | JAM | HLT |
| LAR | LAE | LAS |
| LAX | LAX | LAX |
| RLA | RLA | RLA |
| RRA | RRA | RRA |
| SLO | SLO | ASO |
| SRE | SRE | LSE |
| SXA | SHX | XAS |
| SYA | SHY | SAY |
| TOP | TOP | SKW |
| XAA | ANE | XAA |
| XAS | SHS | TAS |

## __DCB, __RS, __DSB

|| 8 bit | 16 bit | 32 bit |
|---|---|---|---|
| Define data | DB | DW | DL |
| Define space | DS | | |
| Reserve symbol | RB | RW | RL |

## 65C816 register width
The `BITS` directive is used to control the generation of 8 or 16 bit immediate instructions. `BITS` takes two arguments, the first is the width of the accumulator and the second the width of the X and Y registers. Either argument may be omitted.

```
    BITS 16,8	; Set accumulator width to 16 and index registers to 8
    BITS 8      ; Set accumulator width to 8
    BITS ,16    ; Set index registers width to 16
```

## Immediate and address sizing
The 6502 and 65C816 have several addressing modes that look similar but can generate smaller (or larger) binary representations depending on the range of the operand or the mode of the assembler.

When 16 bit register width is enabled, operations that can take an immediate operand (indicated by `#` before the value) will generate an instruction with a 16 bit value.

In all cases it's possible to extract the high or the low byte of a 16 bit operand with `>` and `<` respectively. `>` effectively shifts the operand right by eight bits. These are not operators, they must come immediatly after the `#` and affect the result of the following expression as a whole. When 65C816S is enabled, a circumflex (`^`) can be used to extract the most significant byte of a 24 bit operand, this is effectively a shift by 16 bits. Note that when the accumulator is in 16 bit mode the `<`, `>` and `^` prefixes will result in two bytes as they are shifts.

Instructions that use absolute addressing modes can also generate different encodings. Many instructions are able to use either a zero page address (one byte) or an absolute address (either two or three bytes). If the assembler is able to, it will select the smallest encoding automatically. This may not be what you want, like immediate operands there are some ways to force a specific encoding. `<` will force zero page addressing in all CPU modes. In 65C816 mode, `|` will force two byte absolute addressing, and `>` will force three byte addressing. The assembler will select three byte addresses when it can detect it is necessary from the context, otherwise it will default to two byte addresses. The `JML` (jump long) and `JSL` (jump to subroutine long) may be used to select three byte addressing as well.

## PEA, PAI and PER (65C816S)
ASMotor uses the WDC convention set forth in the 65C816S datasheet. This is consistent with the nomenclature - these instructions all push an effective address and not the value pointed to by the address. Other assemblers may do it differently.

## Base page pointer
The 4510 and 45GS02 processors have the ability to move the zero page to another segment in memory, hence it is referred to as the "base page" on these CPUs. The `SETBP` directive can be used to indicate to the assembler where the base page is in memory, so it will generate the correct instructions.

```
    SETBP $0500

    lda  #$05
    tab
    lda  $512   ; Opcode $A5 (lda $zp) will be emitted due to SETBP
```

## Symbols
Some symbols that describes the current mode of the assembler are available:

| Symbol | Meaning |
|---|---|
|__816_M|The current width of accumulator/memory as specified by the `BITS` directive, 8 or 16|
|__816_X|The current width of the index registers as specified by the `BITS` directive, 8 or 16|
|__4510_BP|The most recent base page pointer set by SETBP|
