# イントロダクション

`asdf`は、ツールのためのバージョンマネージャです。すべてのツールのバージョンは単一のファイル(`.tool-versions`)内で定義されるため、プロジェクトのGitリポジトリにチェックインして共有することで、チーム全員に同じーバージョンのツールを使ってもらえるようになります。

従来は、複数のCLIのバージョンマネージャを用意する必要があり、それぞれが異なるAPI、構成ファイル、および実装(`$PATH`の操作、Shim、環境変数など)となっていました。`asdf`は、開発ワークフローを簡素化するための単一インターフェースと構成ファイルを提供しており、シンプルなプラグインインターフェースを使って、すべてのツール・ランタイムに拡張することができます。

## どうやって動いているの

シェル上で`asdf`コアがセットアップすると、特定のツールを管理するためのプラグインをインストールすることができるようになります。プラグインによってツールがインストールされると、インストールされる実行ファイルごとに[Shim](<https://en.wikipedia.org/wiki/Shim_(computing)>)が作成されます。これらの実行ファイルを実行しようとすると、代わりにShimが実行され、`.tool-versions`で定義されているバージョンを`asdf`が認識して、当該バージョンが実行されます。

## 関連プロジェクト

### nvm / n / rbenv etc

[nvm](https://github.com/nvm-sh/nvm)、[n](https://github.com/tj/n)、および[rbenv](https://github.com/rbenv/rbenv)のようなツールはすべて、ツールによってインストールされる実行ファイルのShimを作成するシェルスクリプトです。

`asdf`はこれらのツールと非常に似ていて、ツール/ランタイムのバージョン管理という分野では競合しています。`asdf`はプラグインシステムを採用し、他のツールと差別化することで、ツール/ランタイムごとのマネージャ、マネージャごとの異なるコマンド、そしてリポジトリ内の様々な`*-version`ファイルといったものを排除しています。

<!-- ### pyenv

TODO: someone with Python background expand on this

`asdf` has some similarities to `pyenv` but is missing some key features. The `asdf` team is looking at introducing some of these `pyenv` specific features, though no roadmap or timeline is available. -->

### direnv

> シェルに、ディレクトリごとに環境変数をロード/アンロードできる機能を付け加えます。

`asdf`は環境変数を管理することはしませんが、direnvの動作を`asdf`に統合する[`asdf-direnv`](https://github.com/asdf-community/asdf-direnv)プラグインが存在します。

詳しくは[direnvのドキュメント](https://direnv.net/)をご覧ください。

### Homebrew

> macOS(またはLinux)のためのパッケージマネージャー

Homebrewは、パッケージとその上位の依存関係を管理します。`asdf`は上位の依存関係を管理することはしませんし、パッケージマネージャでもありません。それらの管理はユーザが負担することとなりますが、`asdf`はなるべく依存関係のリストを小さく保つように努めています。

詳しくは[Homebrewのドキュメント](https://brew.sh/)をご覧ください。

### NixOS

> Nixは、パッケージ管理とシステム構成に独自のアプローチを取り入れたツールです。

NixOSは、各ツールの依存関係ツリー全体でパッケージのバージョンを正確に管理することで、真に再現可能な環境を構築することを目指しています。`asdf`でそのようなことはできません。NixOSは、独自のプログラミング言語、たくさんのCLIツール、そして60,000を超えるパッケージコレクションによって、それらの機能を支えています。

繰り返しになりますが、`asdf`は上位の依存関係を管理することはしませんし、パッケージマネージャでもありません。

詳しくは[NixOSのドキュメント](https://nixos.org/guides/how-nix-works.html)をご覧ください。

## なぜasdfを使うの?

`asdf`は、プラグインシステムによって**多くの**ツールをサポートしており、シェル構成にたった1行の**シェル**スクリプトを記述するだけで使えるというシンプルさ・親しみやすさによって、チームが**確実に**同じバージョンのツールを使用することを保証できます。

::: tip Note
`asdf`はシステムのパッケージマネージャになることを目指してはいません。あくまで、ツールのバージョンマネージャです。プラグインを作成することで、どのようなツールでも`asdf`で管理できるようになりますが、それがそのツールにとって最善の方法であるとは限りませんのでご注意ください。
:::
