/*
 * Copyright (c) 2002, Stockholms Universitet
 * (Stockholm University, Stockholm Sweden)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the university nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "themis.h"

RCSID("$Id: dir.c,v 1.1.2.2 2002/12/02 03:40:14 lha Exp $");

int
themis_readdir(const char *path, int flags, void *ptr,
	       int (*func)(const char *, const char *, void *))
{
    char *realpath;
    struct dirent *dirent;
    char **files = NULL;
    int ret, i, nfiles = 0;
    DIR *dir;

    if (flags & THEMIS_READDIR_RELATIVE)
	asprintf(&realpath, "%s/%s", fs_root ? fs_root : "", path);
    else
	realpath = (char *)path;

    dir = opendir(realpath);

    if (dir == NULL) {
	warn("can't open dir %s", path); /* XXX */
	if (flags & THEMIS_READDIR_RELATIVE)
	    free(realpath);
	return 0;
    }

    if (flags & THEMIS_READDIR_RELATIVE)
	free(realpath);

    while((dirent = readdir(dir))) {

	if (dirent->d_name[0] == '.' && 
	    (dirent->d_name[1] == '\0' ||
	     (dirent->d_name[1] == '.' && dirent->d_name[2] == '\0')))
	    continue;

	if (flags & THEMIS_READDIR_EXCLUDE)
	    if (exclude_check(dirent->d_name))
		continue;

	nfiles++;
	files = erealloc(files, nfiles * sizeof(*files));

	files[nfiles - 1] = estrdup(dirent->d_name);
    }
    
    closedir(dir);

    ret = 0;

    for (i = 0; i < nfiles; i++ ) {
	ret = (func)(path, files[i], ptr);
	if (ret)
	    break;
    }

    for (i = 0; i < nfiles; i++ )
	free(files[i]);
	
    free(files);

    return ret;
}
