/* A Bison parser, made by GNU Bison 3.7.6.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30706

/* Bison version string.  */
#define YYBISON_VERSION "3.7.6"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         Aqlparse
#define yylex           Aqllex
#define yyerror         Aqlerror
#define yydebug         Aqldebug
#define yynerrs         Aqlnerrs

/* First part of user prologue.  */
#line 9 "Aql/grammar.y"

// we are using alloca here explicitly because we may
// otherwise leak error messages that are generated by Bison.
// Bison reports all its errors via the function `Aqlerror`, which
// will receive the error message as a constant string. So we
// must not free the string inside `Aqlerror`, and we cannot even
// tell if the error message is a dynamically allocated error
// message or a hard-coded error message that resides in some
// static part of the program.
// Even worse, `Aqlerror` does not return control to Bison but throws
// an exception... So the best thing we can do here is to not use
// dynamically memory allocation by Bison, but make it use alloca.
#define YYSTACK_USE_ALLOCA 1

#include "Aql/Aggregator.h"
#include "Aql/AstNode.h"
#include "Aql/Function.h"
#include "Aql/Parser.h"
#include "Aql/Quantifier.h"
#include "Aql/QueryContext.h"
#include "Aql/types.h"
#include "Basics/StringUtils.h"
#include "Basics/tri-strings.h"
#include "Graph/ShortestPathType.h"
#include "Transaction/Context.h"
#include "VocBase/AccessMode.h"


#line 105 "Aql/grammar.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "grammar.hpp"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of query string"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_FOR = 3,                      /* "FOR declaration"  */
  YYSYMBOL_T_LET = 4,                      /* "LET declaration"  */
  YYSYMBOL_T_FILTER = 5,                   /* "FILTER declaration"  */
  YYSYMBOL_T_RETURN = 6,                   /* "RETURN declaration"  */
  YYSYMBOL_T_COLLECT = 7,                  /* "COLLECT declaration"  */
  YYSYMBOL_T_SORT = 8,                     /* "SORT declaration"  */
  YYSYMBOL_T_LIMIT = 9,                    /* "LIMIT declaration"  */
  YYSYMBOL_T_WINDOW = 10,                  /* "WINDOW declaration"  */
  YYSYMBOL_T_ASC = 11,                     /* "ASC keyword"  */
  YYSYMBOL_T_DESC = 12,                    /* "DESC keyword"  */
  YYSYMBOL_T_IN = 13,                      /* "IN keyword"  */
  YYSYMBOL_T_WITH = 14,                    /* "WITH keyword"  */
  YYSYMBOL_T_INTO = 15,                    /* "INTO keyword"  */
  YYSYMBOL_T_AGGREGATE = 16,               /* "AGGREGATE keyword"  */
  YYSYMBOL_T_GRAPH = 17,                   /* "GRAPH keyword"  */
  YYSYMBOL_T_SHORTEST_PATH = 18,           /* "SHORTEST_PATH keyword"  */
  YYSYMBOL_T_K_SHORTEST_PATHS = 19,        /* "K_SHORTEST_PATHS keyword"  */
  YYSYMBOL_T_K_PATHS = 20,                 /* "K_PATHS keyword"  */
  YYSYMBOL_T_DISTINCT = 21,                /* "DISTINCT modifier"  */
  YYSYMBOL_T_REMOVE = 22,                  /* "REMOVE command"  */
  YYSYMBOL_T_INSERT = 23,                  /* "INSERT command"  */
  YYSYMBOL_T_UPDATE = 24,                  /* "UPDATE command"  */
  YYSYMBOL_T_REPLACE = 25,                 /* "REPLACE command"  */
  YYSYMBOL_T_UPSERT = 26,                  /* "UPSERT command"  */
  YYSYMBOL_T_NULL = 27,                    /* "null"  */
  YYSYMBOL_T_TRUE = 28,                    /* "true"  */
  YYSYMBOL_T_FALSE = 29,                   /* "false"  */
  YYSYMBOL_T_STRING = 30,                  /* "identifier"  */
  YYSYMBOL_T_QUOTED_STRING = 31,           /* "quoted string"  */
  YYSYMBOL_T_INTEGER = 32,                 /* "integer number"  */
  YYSYMBOL_T_DOUBLE = 33,                  /* "number"  */
  YYSYMBOL_T_PARAMETER = 34,               /* "bind parameter"  */
  YYSYMBOL_T_DATA_SOURCE_PARAMETER = 35,   /* "bind data source parameter"  */
  YYSYMBOL_T_ASSIGN = 36,                  /* "assignment"  */
  YYSYMBOL_T_NOT = 37,                     /* "not operator"  */
  YYSYMBOL_T_AND = 38,                     /* "and operator"  */
  YYSYMBOL_T_OR = 39,                      /* "or operator"  */
  YYSYMBOL_T_REGEX_MATCH = 40,             /* "~= operator"  */
  YYSYMBOL_T_REGEX_NON_MATCH = 41,         /* "~! operator"  */
  YYSYMBOL_T_EQ = 42,                      /* "== operator"  */
  YYSYMBOL_T_NE = 43,                      /* "!= operator"  */
  YYSYMBOL_T_LT = 44,                      /* "< operator"  */
  YYSYMBOL_T_GT = 45,                      /* "> operator"  */
  YYSYMBOL_T_LE = 46,                      /* "<= operator"  */
  YYSYMBOL_T_GE = 47,                      /* ">= operator"  */
  YYSYMBOL_T_LIKE = 48,                    /* "like operator"  */
  YYSYMBOL_T_PLUS = 49,                    /* "+ operator"  */
  YYSYMBOL_T_MINUS = 50,                   /* "- operator"  */
  YYSYMBOL_T_TIMES = 51,                   /* "* operator"  */
  YYSYMBOL_T_DIV = 52,                     /* "/ operator"  */
  YYSYMBOL_T_MOD = 53,                     /* "% operator"  */
  YYSYMBOL_T_QUESTION = 54,                /* "?"  */
  YYSYMBOL_T_COLON = 55,                   /* ":"  */
  YYSYMBOL_T_SCOPE = 56,                   /* "::"  */
  YYSYMBOL_T_RANGE = 57,                   /* ".."  */
  YYSYMBOL_T_COMMA = 58,                   /* ","  */
  YYSYMBOL_T_OPEN = 59,                    /* "("  */
  YYSYMBOL_T_CLOSE = 60,                   /* ")"  */
  YYSYMBOL_T_OBJECT_OPEN = 61,             /* "{"  */
  YYSYMBOL_T_OBJECT_CLOSE = 62,            /* "}"  */
  YYSYMBOL_T_ARRAY_OPEN = 63,              /* "["  */
  YYSYMBOL_T_ARRAY_CLOSE = 64,             /* "]"  */
  YYSYMBOL_T_OUTBOUND = 65,                /* "outbound modifier"  */
  YYSYMBOL_T_INBOUND = 66,                 /* "inbound modifier"  */
  YYSYMBOL_T_ANY = 67,                     /* "any modifier"  */
  YYSYMBOL_T_ALL = 68,                     /* "all modifier"  */
  YYSYMBOL_T_NONE = 69,                    /* "none modifier"  */
  YYSYMBOL_UMINUS = 70,                    /* UMINUS  */
  YYSYMBOL_UPLUS = 71,                     /* UPLUS  */
  YYSYMBOL_UNEGATION = 72,                 /* UNEGATION  */
  YYSYMBOL_FUNCCALL = 73,                  /* FUNCCALL  */
  YYSYMBOL_REFERENCE = 74,                 /* REFERENCE  */
  YYSYMBOL_INDEXED = 75,                   /* INDEXED  */
  YYSYMBOL_EXPANSION = 76,                 /* EXPANSION  */
  YYSYMBOL_77_ = 77,                       /* '.'  */
  YYSYMBOL_YYACCEPT = 78,                  /* $accept  */
  YYSYMBOL_with_collection = 79,           /* with_collection  */
  YYSYMBOL_with_collection_list = 80,      /* with_collection_list  */
  YYSYMBOL_optional_with = 81,             /* optional_with  */
  YYSYMBOL_82_1 = 82,                      /* $@1  */
  YYSYMBOL_queryStart = 83,                /* queryStart  */
  YYSYMBOL_query = 84,                     /* query  */
  YYSYMBOL_final_statement = 85,           /* final_statement  */
  YYSYMBOL_optional_statement_block_statements = 86, /* optional_statement_block_statements  */
  YYSYMBOL_statement_block_statement = 87, /* statement_block_statement  */
  YYSYMBOL_more_output_variables = 88,     /* more_output_variables  */
  YYSYMBOL_for_output_variables = 89,      /* for_output_variables  */
  YYSYMBOL_prune_and_options = 90,         /* prune_and_options  */
  YYSYMBOL_traversal_graph_info = 91,      /* traversal_graph_info  */
  YYSYMBOL_shortest_path_graph_info = 92,  /* shortest_path_graph_info  */
  YYSYMBOL_k_shortest_paths_graph_info = 93, /* k_shortest_paths_graph_info  */
  YYSYMBOL_k_paths_graph_info = 94,        /* k_paths_graph_info  */
  YYSYMBOL_for_statement = 95,             /* for_statement  */
  YYSYMBOL_96_2 = 96,                      /* $@2  */
  YYSYMBOL_97_3 = 97,                      /* $@3  */
  YYSYMBOL_filter_statement = 98,          /* filter_statement  */
  YYSYMBOL_let_statement = 99,             /* let_statement  */
  YYSYMBOL_let_list = 100,                 /* let_list  */
  YYSYMBOL_let_element = 101,              /* let_element  */
  YYSYMBOL_count_into = 102,               /* count_into  */
  YYSYMBOL_collect_variable_list = 103,    /* collect_variable_list  */
  YYSYMBOL_104_4 = 104,                    /* $@4  */
  YYSYMBOL_collect_statement = 105,        /* collect_statement  */
  YYSYMBOL_collect_list = 106,             /* collect_list  */
  YYSYMBOL_collect_element = 107,          /* collect_element  */
  YYSYMBOL_collect_optional_into = 108,    /* collect_optional_into  */
  YYSYMBOL_variable_list = 109,            /* variable_list  */
  YYSYMBOL_keep = 110,                     /* keep  */
  YYSYMBOL_111_5 = 111,                    /* $@5  */
  YYSYMBOL_aggregate = 112,                /* aggregate  */
  YYSYMBOL_113_6 = 113,                    /* $@6  */
  YYSYMBOL_aggregate_list = 114,           /* aggregate_list  */
  YYSYMBOL_aggregate_element = 115,        /* aggregate_element  */
  YYSYMBOL_aggregate_function_call = 116,  /* aggregate_function_call  */
  YYSYMBOL_117_7 = 117,                    /* $@7  */
  YYSYMBOL_sort_statement = 118,           /* sort_statement  */
  YYSYMBOL_119_8 = 119,                    /* $@8  */
  YYSYMBOL_sort_list = 120,                /* sort_list  */
  YYSYMBOL_sort_element = 121,             /* sort_element  */
  YYSYMBOL_sort_direction = 122,           /* sort_direction  */
  YYSYMBOL_limit_statement = 123,          /* limit_statement  */
  YYSYMBOL_window_statement = 124,         /* window_statement  */
  YYSYMBOL_return_statement = 125,         /* return_statement  */
  YYSYMBOL_in_or_into_collection = 126,    /* in_or_into_collection  */
  YYSYMBOL_remove_statement = 127,         /* remove_statement  */
  YYSYMBOL_insert_statement = 128,         /* insert_statement  */
  YYSYMBOL_update_parameters = 129,        /* update_parameters  */
  YYSYMBOL_update_statement = 130,         /* update_statement  */
  YYSYMBOL_replace_parameters = 131,       /* replace_parameters  */
  YYSYMBOL_replace_statement = 132,        /* replace_statement  */
  YYSYMBOL_update_or_replace = 133,        /* update_or_replace  */
  YYSYMBOL_upsert_statement = 134,         /* upsert_statement  */
  YYSYMBOL_135_9 = 135,                    /* $@9  */
  YYSYMBOL_136_10 = 136,                   /* $@10  */
  YYSYMBOL_quantifier = 137,               /* quantifier  */
  YYSYMBOL_distinct_expression = 138,      /* distinct_expression  */
  YYSYMBOL_139_11 = 139,                   /* $@11  */
  YYSYMBOL_expression = 140,               /* expression  */
  YYSYMBOL_function_name = 141,            /* function_name  */
  YYSYMBOL_function_call = 142,            /* function_call  */
  YYSYMBOL_143_12 = 143,                   /* $@12  */
  YYSYMBOL_144_13 = 144,                   /* $@13  */
  YYSYMBOL_operator_unary = 145,           /* operator_unary  */
  YYSYMBOL_operator_binary = 146,          /* operator_binary  */
  YYSYMBOL_operator_ternary = 147,         /* operator_ternary  */
  YYSYMBOL_optional_function_call_arguments = 148, /* optional_function_call_arguments  */
  YYSYMBOL_expression_or_query = 149,      /* expression_or_query  */
  YYSYMBOL_150_14 = 150,                   /* $@14  */
  YYSYMBOL_function_arguments_list = 151,  /* function_arguments_list  */
  YYSYMBOL_compound_value = 152,           /* compound_value  */
  YYSYMBOL_array = 153,                    /* array  */
  YYSYMBOL_154_15 = 154,                   /* $@15  */
  YYSYMBOL_optional_array_elements = 155,  /* optional_array_elements  */
  YYSYMBOL_array_elements_list = 156,      /* array_elements_list  */
  YYSYMBOL_array_element = 157,            /* array_element  */
  YYSYMBOL_for_options = 158,              /* for_options  */
  YYSYMBOL_options = 159,                  /* options  */
  YYSYMBOL_object = 160,                   /* object  */
  YYSYMBOL_161_16 = 161,                   /* $@16  */
  YYSYMBOL_optional_object_elements = 162, /* optional_object_elements  */
  YYSYMBOL_object_elements_list = 163,     /* object_elements_list  */
  YYSYMBOL_object_element = 164,           /* object_element  */
  YYSYMBOL_array_filter_operator = 165,    /* array_filter_operator  */
  YYSYMBOL_optional_array_filter = 166,    /* optional_array_filter  */
  YYSYMBOL_optional_array_limit = 167,     /* optional_array_limit  */
  YYSYMBOL_optional_array_return = 168,    /* optional_array_return  */
  YYSYMBOL_graph_collection = 169,         /* graph_collection  */
  YYSYMBOL_graph_collection_list = 170,    /* graph_collection_list  */
  YYSYMBOL_graph_subject = 171,            /* graph_subject  */
  YYSYMBOL_172_17 = 172,                   /* $@17  */
  YYSYMBOL_graph_direction = 173,          /* graph_direction  */
  YYSYMBOL_graph_direction_steps = 174,    /* graph_direction_steps  */
  YYSYMBOL_reference = 175,                /* reference  */
  YYSYMBOL_176_18 = 176,                   /* $@18  */
  YYSYMBOL_177_19 = 177,                   /* $@19  */
  YYSYMBOL_simple_value = 178,             /* simple_value  */
  YYSYMBOL_numeric_value = 179,            /* numeric_value  */
  YYSYMBOL_value_literal = 180,            /* value_literal  */
  YYSYMBOL_in_or_into_collection_name = 181, /* in_or_into_collection_name  */
  YYSYMBOL_bind_parameter = 182,           /* bind_parameter  */
  YYSYMBOL_bind_parameter_datasource_expected = 183, /* bind_parameter_datasource_expected  */
  YYSYMBOL_object_element_name = 184,      /* object_element_name  */
  YYSYMBOL_variable_name = 185             /* variable_name  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 48 "Aql/grammar.y"


using namespace arangodb::aql;

#define scanner parser->scanner()

/// @brief forward for lexer function defined in Aql/tokens.ll
int Aqllex(YYSTYPE*, YYLTYPE*, void*);

/// @brief register parse error (this will also abort the currently running query)
void Aqlerror(YYLTYPE* locp,
              arangodb::aql::Parser* parser,
              char const* message) {
  parser->registerParseError(TRI_ERROR_QUERY_PARSE, message, locp->first_line, locp->first_column);
}

namespace {

AstNode* buildShortestPathInfo(Parser* parser,
                               char const* seperator,
                               AstNode* direction,
                               AstNode* startNode,
                               AstNode* endNode,
                               AstNode* graph,
                               AstNode* options,
                               YYLTYPE const& yyloc) {
  if (!TRI_CaseEqualString(seperator, "TO")) {
    parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'TO'", seperator, yyloc.first_line, yyloc.first_column);
  }
  auto infoNode = parser->ast()->createNodeArray();
  infoNode->addMember(direction);
  infoNode->addMember(startNode);
  infoNode->addMember(endNode);
  infoNode->addMember(graph);
  
  auto opts = parser->ast()->createNodeOptions(options);
  TRI_ASSERT(opts != nullptr);
  infoNode->addMember(opts);
  return infoNode;
}

void checkOutVariables(Parser* parser,
                       AstNode const* variableNamesNode,
                       size_t minVariables, size_t maxVariables,
                       char const* errorMessage,
                       YYLTYPE const& yyloc) {
  TRI_ASSERT(variableNamesNode != nullptr);
  TRI_ASSERT(variableNamesNode->type == NODE_TYPE_ARRAY);
  if (variableNamesNode->numMembers() < minVariables ||
      variableNamesNode->numMembers() > maxVariables) {
    parser->registerParseError(TRI_ERROR_QUERY_PARSE, errorMessage, yyloc.first_line, yyloc.first_column);
  }
}

void validateOptions(Parser* parser, AstNode const* node,
                     int line, int column) {
  TRI_ASSERT(node != nullptr);
  if (!node->isObject()) {
    parser->registerParseError(TRI_ERROR_QUERY_PARSE, "'OPTIONS' have to be an object", line, column);
  }
  if (!node->isConstant()) {
    parser->registerParseError(TRI_ERROR_QUERY_COMPILE_TIME_OPTIONS, "'OPTIONS' have to be known at query compile time", line, column);
  }
}

/// @brief check if any of the variables used in the INTO expression were
/// introduced by the COLLECT itself, in which case it would fail
void checkIntoVariables(Parser* parser, AstNode const* expression,
                        int line, int column,
                        VarSet const& variablesIntroduced) {
  if (expression == nullptr) {
    return;
  }

  VarSet varsInAssignment{};
  Ast::getReferencedVariables(expression, varsInAssignment);

  for (auto const& it : varsInAssignment) {
    if (variablesIntroduced.find(it) != variablesIntroduced.end()) {
      std::string msg("use of COLLECT variable '" + it->name + "' inside same COLLECT's INTO expression");
      parser->registerParseError(TRI_ERROR_QUERY_VARIABLE_NAME_UNKNOWN, msg.c_str(), it->name.c_str(), line, column);
      return;
    }
  }
}

/// @brief register variables in the scope
void registerAssignVariables(Parser* parser, arangodb::aql::Scopes* scopes,
                             int line, int column,
                             VarSet& variablesIntroduced,
                             AstNode const* vars) {
  size_t const n = vars->numMembers();

  for (size_t i = 0; i < n; ++i) {
    auto member = vars->getMemberUnchecked(i);

    if (member != nullptr) {
      TRI_ASSERT(member->type == NODE_TYPE_ASSIGN);
      // keep track of the variable for our assignment
      auto v = static_cast<Variable*>(member->getMember(0)->getData());
      scopes->addVariable(v);
      variablesIntroduced.emplace(v);
    }
  }
}

/// @brief validate the aggregate variables expressions
bool validateAggregates(Parser* parser, AstNode const* aggregates,
                        int line, int column) {
  VarSet variablesIntroduced{};
  VarSet varsInAssignment{};
  
  size_t const n = aggregates->numMembers();
  for (size_t i = 0; i < n; ++i) {
    auto member = aggregates->getMemberUnchecked(i);

    if (member != nullptr) {
      TRI_ASSERT(member->type == NODE_TYPE_ASSIGN);
      
      // keep track of the variable for our assignment
      auto v = static_cast<Variable*>(member->getMember(0)->getData());
      variablesIntroduced.emplace(v);

      auto func = member->getMember(1);
      if (func->type != NODE_TYPE_FCALL) {
        // aggregate expression must be a function call
        char const* error = "aggregate expression must be a function call";
        parser->registerParseError(TRI_ERROR_QUERY_INVALID_AGGREGATE_EXPRESSION, error, line, column);
        return false;
      }
      else {
        auto f = static_cast<arangodb::aql::Function*>(func->getData());
        if (!Aggregator::isValid(f->name)) {
          // aggregate expression must be a call to MIN|MAX|LENGTH...
          char const* error = "unknown aggregate function used";
          parser->registerParseError(TRI_ERROR_QUERY_INVALID_AGGREGATE_EXPRESSION, error, line, column);
          return false;
        }
      }
      
      // check if any of the assignment refers to a variable introduced by this very
      // same COLLECT, e.g. COLLECT aggregate x = .., y = x
      varsInAssignment.clear();
      Ast::getReferencedVariables(member->getMember(1), varsInAssignment);
      for (auto const& it : varsInAssignment) {
        if (variablesIntroduced.find(it) != variablesIntroduced.end()) {
          std::string msg("use of COLLECT variable '" + it->name + "' inside same COLLECT");
          parser->registerParseError(TRI_ERROR_QUERY_VARIABLE_NAME_UNKNOWN, msg.c_str(), it->name.c_str(), line, column);
          return false;
        }
      }
    }
  }

  return true;
}


/// @brief validate the WINDOW specification
bool validateWindowSpec(Parser* parser, AstNode const* spec,
                        int line, int column) {
  bool preceding = false;
  bool following = false;
  
  size_t const n = spec->numMembers();
  if (n == 0) {
    parser->registerParseError(TRI_ERROR_QUERY_PARSE, "At least one WINDOW bound must be specified ('preceding'/'following')", line, column);
    return false;
  }
  
  for (size_t i = 0; i < n; ++i) {
    auto member = spec->getMemberUnchecked(i);

    if (member != nullptr) {
      TRI_ASSERT(member->type == NODE_TYPE_OBJECT_ELEMENT);
      bool* attr{};
      auto name = member->getString();
      if (name == "preceding") {
        attr = &preceding;
      } else if (name == "following") {
        attr = &following;
      } else  {
        char const* error = "Invalid WINDOW attribute '%s'; only \"preceding\" and \"following\" are supported";
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, error, name.c_str(), line, column);
        return false;
      }
      
      if (*attr) {
        char const* error = "WINDOW attribute '%s' is specified multiple times";
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, error, name.c_str(), line, column);
        return false;
      }
      
      // mark this attribute as "seen"
      *attr = true;
    }
  }
  return true;
}

/// @brief start a new scope for the collect
bool startCollectScope(arangodb::aql::Scopes* scopes) {
  // check if we are in the main scope
  if (scopes->type() == arangodb::aql::AQL_SCOPE_MAIN ||
      scopes->type() == arangodb::aql::AQL_SCOPE_SUBQUERY) {
    return false;
  }


  // end the active scopes
  scopes->endNested();
  // start a new scope
  scopes->start(arangodb::aql::AQL_SCOPE_COLLECT);
  return true;
}

/// @brief get the INTO variable stored in a node (may not exist)
AstNode const* getIntoVariable(Parser* parser, AstNode const* node) {
  if (node == nullptr) {
    return nullptr;
  }

  if (node->type == NODE_TYPE_VALUE) {
    // node is a string containing the variable name
    return parser->ast()->createNodeVariable(node->getStringValue(), node->getStringLength(), true);
  }

  // node is an array with the variable name as the first member
  TRI_ASSERT(node->type == NODE_TYPE_ARRAY);
  TRI_ASSERT(node->numMembers() == 2);

  auto v = node->getMember(0);
  TRI_ASSERT(v->type == NODE_TYPE_VALUE);
  return parser->ast()->createNodeVariable(v->getStringValue(), v->getStringLength(), true);
}

/// @brief get the INTO variable = expression stored in a node (may not exist)
AstNode const* getIntoExpression(AstNode const* node) {
  if (node == nullptr || node->type == NODE_TYPE_VALUE) {
    return nullptr;
  }

  // node is an array with the expression as the second member
  TRI_ASSERT(node->type == NODE_TYPE_ARRAY);
  TRI_ASSERT(node->numMembers() == 2);

  return node->getMember(1);
}

AstNode* transformOutputVariables(Parser* parser, AstNode const* names) {
  auto wrapperNode = parser->ast()->createNodeArray();
  for (size_t i = 0; i < names->numMembers(); ++i) {
    AstNode* variableNameNode = names->getMemberUnchecked(i);
    TRI_ASSERT(variableNameNode->isStringValue());
    AstNode* variableNode = parser->ast()->createNodeVariable(variableNameNode->getStringValue(), variableNameNode->getStringLength(), true);
    wrapperNode->addMember(variableNode);
  }
  return wrapperNode;
}

} // namespace


#line 588 "Aql/grammar.cpp"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  7
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1678

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  78
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  108
/* YYNRULES -- Number of rules.  */
#define YYNRULES  252
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  424

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   331


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,    77,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   495,   495,   498,   504,   508,   512,   519,   521,   521,
     533,   538,   543,   545,   548,   551,   554,   557,   563,   565,
     570,   572,   574,   576,   578,   580,   582,   584,   586,   588,
     590,   592,   597,   604,   611,   617,   624,   645,   666,   679,
     685,   691,   697,   697,   748,   748,   775,   787,   799,   814,
     822,   827,   829,   834,   841,   851,   851,   862,   872,   885,
     909,   965,   984,  1011,  1013,  1018,  1025,  1028,  1031,  1040,
    1052,  1067,  1067,  1081,  1081,  1091,  1093,  1098,  1105,  1105,
    1116,  1116,  1127,  1130,  1136,  1142,  1145,  1148,  1151,  1157,
    1162,  1169,  1184,  1202,  1210,  1213,  1219,  1229,  1239,  1247,
    1258,  1263,  1271,  1282,  1287,  1290,  1296,  1300,  1296,  1351,
    1354,  1357,  1363,  1363,  1373,  1379,  1382,  1385,  1388,  1391,
    1394,  1400,  1403,  1416,  1416,  1425,  1425,  1435,  1438,  1441,
    1447,  1450,  1453,  1456,  1459,  1462,  1465,  1468,  1471,  1474,
    1477,  1480,  1483,  1486,  1489,  1492,  1499,  1506,  1512,  1518,
    1524,  1531,  1534,  1537,  1540,  1543,  1546,  1549,  1552,  1556,
    1560,  1567,  1570,  1576,  1578,  1583,  1586,  1586,  1602,  1605,
    1611,  1614,  1620,  1620,  1629,  1631,  1633,  1638,  1640,  1645,
    1651,  1654,  1679,  1698,  1701,  1715,  1715,  1724,  1726,  1728,
    1733,  1735,  1740,  1754,  1758,  1767,  1774,  1777,  1783,  1786,
    1792,  1795,  1798,  1804,  1807,  1813,  1816,  1819,  1823,  1829,
    1833,  1840,  1846,  1846,  1855,  1859,  1863,  1872,  1875,  1878,
    1884,  1887,  1893,  1925,  1928,  1931,  1935,  1945,  1945,  1958,
    1973,  1987,  2001,  2001,  2044,  2047,  2053,  2057,  2064,  2067,
    2070,  2073,  2076,  2082,  2086,  2090,  2100,  2107,  2113,  2120,
    2126,  2129,  2134
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of query string\"", "error", "\"invalid token\"",
  "\"FOR declaration\"", "\"LET declaration\"", "\"FILTER declaration\"",
  "\"RETURN declaration\"", "\"COLLECT declaration\"",
  "\"SORT declaration\"", "\"LIMIT declaration\"",
  "\"WINDOW declaration\"", "\"ASC keyword\"", "\"DESC keyword\"",
  "\"IN keyword\"", "\"WITH keyword\"", "\"INTO keyword\"",
  "\"AGGREGATE keyword\"", "\"GRAPH keyword\"",
  "\"SHORTEST_PATH keyword\"", "\"K_SHORTEST_PATHS keyword\"",
  "\"K_PATHS keyword\"", "\"DISTINCT modifier\"", "\"REMOVE command\"",
  "\"INSERT command\"", "\"UPDATE command\"", "\"REPLACE command\"",
  "\"UPSERT command\"", "\"null\"", "\"true\"", "\"false\"",
  "\"identifier\"", "\"quoted string\"", "\"integer number\"",
  "\"number\"", "\"bind parameter\"", "\"bind data source parameter\"",
  "\"assignment\"", "\"not operator\"", "\"and operator\"",
  "\"or operator\"", "\"~= operator\"", "\"~! operator\"",
  "\"== operator\"", "\"!= operator\"", "\"< operator\"", "\"> operator\"",
  "\"<= operator\"", "\">= operator\"", "\"like operator\"",
  "\"+ operator\"", "\"- operator\"", "\"* operator\"", "\"/ operator\"",
  "\"% operator\"", "\"?\"", "\":\"", "\"::\"", "\"..\"", "\",\"", "\"(\"",
  "\")\"", "\"{\"", "\"}\"", "\"[\"", "\"]\"", "\"outbound modifier\"",
  "\"inbound modifier\"", "\"any modifier\"", "\"all modifier\"",
  "\"none modifier\"", "UMINUS", "UPLUS", "UNEGATION", "FUNCCALL",
  "REFERENCE", "INDEXED", "EXPANSION", "'.'", "$accept", "with_collection",
  "with_collection_list", "optional_with", "$@1", "queryStart", "query",
  "final_statement", "optional_statement_block_statements",
  "statement_block_statement", "more_output_variables",
  "for_output_variables", "prune_and_options", "traversal_graph_info",
  "shortest_path_graph_info", "k_shortest_paths_graph_info",
  "k_paths_graph_info", "for_statement", "$@2", "$@3", "filter_statement",
  "let_statement", "let_list", "let_element", "count_into",
  "collect_variable_list", "$@4", "collect_statement", "collect_list",
  "collect_element", "collect_optional_into", "variable_list", "keep",
  "$@5", "aggregate", "$@6", "aggregate_list", "aggregate_element",
  "aggregate_function_call", "$@7", "sort_statement", "$@8", "sort_list",
  "sort_element", "sort_direction", "limit_statement", "window_statement",
  "return_statement", "in_or_into_collection", "remove_statement",
  "insert_statement", "update_parameters", "update_statement",
  "replace_parameters", "replace_statement", "update_or_replace",
  "upsert_statement", "$@9", "$@10", "quantifier", "distinct_expression",
  "$@11", "expression", "function_name", "function_call", "$@12", "$@13",
  "operator_unary", "operator_binary", "operator_ternary",
  "optional_function_call_arguments", "expression_or_query", "$@14",
  "function_arguments_list", "compound_value", "array", "$@15",
  "optional_array_elements", "array_elements_list", "array_element",
  "for_options", "options", "object", "$@16", "optional_object_elements",
  "object_elements_list", "object_element", "array_filter_operator",
  "optional_array_filter", "optional_array_limit", "optional_array_return",
  "graph_collection", "graph_collection_list", "graph_subject", "$@17",
  "graph_direction", "graph_direction_steps", "reference", "$@18", "$@19",
  "simple_value", "numeric_value", "value_literal",
  "in_or_into_collection_name", "bind_parameter",
  "bind_parameter_datasource_expected", "object_element_name",
  "variable_name", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,    46
};
#endif

#define YYPACT_NINF (-352)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-251)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      -1,  -352,  -352,    26,   121,  -352,   393,  -352,  -352,  -352,
    -352,  -352,   108,  -352,    11,    11,  1578,  1389,     7,  -352,
    1578,  1578,  1578,  1578,  1578,  1578,  -352,  -352,  -352,  -352,
    -352,  -352,   165,  -352,  -352,  -352,  -352,  -352,    17,    27,
      39,    63,    64,   121,  -352,  -352,   -29,    29,  -352,     3,
    -352,    33,  -352,  -352,  -352,    22,  -352,  -352,  -352,  -352,
    -352,  1578,    15,  1578,  1578,  1578,  -352,  -352,  1226,    69,
    -352,  -352,  -352,  -352,  -352,  -352,  -352,   -33,  -352,  -352,
    -352,  -352,  -352,  1226,    68,  -352,   104,    11,   120,  1578,
     678,   720,   129,   763,   763,  -352,   503,  -352,   548,  1578,
      11,   104,   110,   120,  -352,    11,  1426,    11,  1578,  -352,
    -352,  -352,  -352,   805,  -352,   102,  1578,  1578,    54,  1578,
    1578,  1578,  1578,  1578,  1578,  1578,  1578,  1578,  1578,  1578,
    1578,  1578,  1578,  1578,  1578,  1467,  1578,   127,   131,   133,
     180,   144,  -352,  1504,   124,  1578,   158,    11,   115,  -352,
     139,  -352,   170,   104,   149,  -352,   416,  1578,   115,  -352,
    1615,    41,   104,   104,  1578,   104,  1578,   104,  1226,   185,
    -352,   115,   104,  -352,   104,  -352,  -352,  -352,  -352,  -352,
    -352,  -352,  -352,   590,   210,  1352,  -352,  1226,  1541,  -352,
     169,   175,  -352,   177,  1578,   171,   176,  -352,   181,  1226,
     174,   187,  -352,  1346,  1578,  1578,  1578,  1578,  1309,  1268,
     290,   290,   290,   290,   191,   191,   191,   191,   290,   143,
     143,  -352,  -352,  -352,  1578,   847,   160,   226,   236,   238,
    1578,  1578,  1578,  1578,  1578,  1578,  1578,  -352,  1541,  -352,
     890,   201,  -352,  -352,  1226,    11,   204,  -352,   227,  -352,
      11,  1578,  -352,  1578,  -352,  -352,  -352,  -352,  -352,  -352,
    1226,   129,   250,    28,   382,  -352,  -352,  -352,  -352,  -352,
    -352,  -352,   763,  -352,   763,  -352,   241,  1578,    11,  -352,
    -352,   235,   140,   237,  -352,  1578,  1578,  1578,   458,  1226,
     206,  -352,  -352,   219,  -352,  1578,   932,  -352,   102,  1578,
    -352,  1578,  1346,   290,   290,   290,  1226,  1578,  1578,  1578,
    1578,  1346,   290,   290,   191,   191,   191,   191,   208,  -352,
    -352,   273,  -352,    11,   251,  -352,  1226,  -352,  -352,   104,
     104,  1578,  1226,   224,  -352,  1578,  -352,  1578,  -352,   974,
    1016,  1058,    25,  -352,   228,  -352,   137,  -352,  -352,  -352,
    1578,  1226,   229,  -352,  1226,  -352,  1226,  1346,  1346,  1346,
    -352,  1578,   278,  -352,  -352,  -352,    90,  -352,  -352,   636,
      11,  1100,  1142,  1578,  1578,  1578,  -352,  -352,  -352,  -352,
    -352,  -352,  -352,  1578,  1226,  1578,   282,  -352,  -352,  -352,
    1578,  -352,   115,  1578,   458,   458,   458,    96,  1226,  1184,
    1578,   225,  1541,   763,  -352,  1226,   104,   104,   104,  -352,
     232,  1578,  1226,  -352,   239,   104,  -352,  -352,  -352,    96,
    1226,  -352,  -352,  -352
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       7,     8,    18,     0,     0,    10,     0,     1,     2,   249,
     248,     4,     9,     3,     0,     0,     0,     0,    55,    80,
       0,     0,     0,     0,     0,     0,   106,    11,    19,    20,
      22,    21,    66,    23,    24,    25,    26,    12,    27,    28,
      29,    30,    31,     0,     6,   252,    34,     0,    32,    50,
      51,     0,   240,   241,   242,   222,   238,   236,   237,   247,
     246,     0,     0,     0,     0,   227,   185,   172,    49,     0,
     225,   115,   116,   117,   223,   170,   171,   119,   239,   118,
     224,   112,    93,   114,     0,    73,   183,     0,    66,     0,
      89,     0,   171,     0,     0,   100,     0,   103,     0,     0,
       0,   183,   183,    66,     5,     0,     0,     0,     0,   129,
     125,   127,   128,     0,    18,   187,   174,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   110,   109,   111,
       0,     0,   123,     0,     0,     0,     0,     0,     0,    57,
      56,    63,     0,   183,    81,    82,    85,     0,     0,    91,
       0,     0,   183,   183,     0,   183,     0,   183,   107,    67,
      58,    71,   183,    61,   183,    33,   217,   218,   219,    44,
      46,    47,    48,    42,   220,     0,    52,    53,   166,   226,
       0,   192,   251,     0,     0,     0,   188,   190,     0,   179,
       0,   175,   177,   143,     0,     0,     0,     0,   131,   130,
     149,   150,   137,   138,   139,   140,   141,   142,   148,   132,
     133,   134,   135,   136,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   122,   166,   196,
       0,   232,   229,   230,   113,     0,    74,    75,     0,   184,
       0,     0,    59,     0,    86,    87,    84,    88,   234,   235,
      90,     0,   222,   238,   246,    94,   243,   244,   245,    95,
      96,    97,     0,    98,     0,   101,     0,     0,     0,    62,
      60,    35,   219,   180,   221,     0,     0,     0,     0,   165,
       0,   168,    18,   164,   228,     0,     0,   186,   189,     0,
     173,   176,   144,   146,   147,   145,   162,     0,     0,     0,
       0,   157,   151,   152,   153,   154,   155,   156,     0,   231,
     197,   198,    54,     0,     0,    64,    65,    83,    92,   183,
     183,     0,    68,    72,    69,     0,    45,     0,    43,     0,
       0,     0,     0,   205,   211,    38,     0,   206,   126,   167,
     166,   194,     0,   191,   193,   178,   161,   159,   158,   160,
     124,     0,   200,    76,   121,    77,     0,    99,   102,     0,
       0,    36,   181,     0,     0,     0,   216,   215,   214,   212,
     207,   208,   169,     0,   199,     0,   203,    78,   104,   105,
       0,    70,     0,     0,     0,     0,     0,     0,   195,   201,
       0,     0,   166,     0,    37,   182,   183,   183,   183,   209,
     213,     0,   204,   233,     0,   183,    39,    40,    41,     0,
     202,    79,   108,   210
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -352,     0,  -352,  -352,  -352,  -352,  -100,  -352,  -352,  -352,
    -352,  -352,  -352,  -352,  -352,  -352,  -352,  -352,  -352,  -352,
    -352,  -352,  -352,   188,   264,  -352,  -352,  -352,  -352,    48,
     -63,  -352,  -352,  -352,   -30,  -352,  -352,   -23,  -352,  -352,
    -352,  -352,  -352,    51,  -352,  -352,  -352,  -352,   -74,  -352,
    -352,  -352,  -352,  -352,  -352,  -352,  -352,  -352,  -352,  -352,
    -352,  -352,   -16,   -19,  -352,  -352,  -352,  -352,  -352,  -352,
    -227,   -49,  -352,  -352,  -352,  -352,  -352,  -352,  -352,     6,
    -352,   -83,   -11,  -352,  -352,  -352,    13,  -352,  -352,  -352,
    -352,  -351,  -352,  -192,  -352,   -90,  -352,  -352,  -352,  -352,
    -352,  -352,   156,   152,  -141,    53,  -352,    52
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    11,    12,     2,     4,     3,     5,    27,     6,    28,
      46,    47,   336,   179,   180,   181,   182,    29,   283,   281,
      30,    31,    49,    50,    86,    32,    87,    33,   150,   151,
     102,   333,   172,   278,    88,   147,   246,   247,   365,   402,
      34,    89,   154,   155,   256,    35,    36,    37,   162,    38,
      39,    95,    40,    97,    41,   390,    42,    99,   276,   140,
      82,   145,   289,    69,    70,   238,   188,    71,    72,    73,
     290,   291,   292,   293,    74,    75,   116,   200,   201,   202,
     338,   149,    76,   115,   195,   196,   197,   241,   362,   386,
     401,   344,   410,   345,   397,   346,   185,    77,   114,   321,
     257,    78,    79,   265,    80,   347,   198,    51
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      68,    83,   103,   243,    90,    91,    93,    94,    96,    98,
      92,   318,    44,     1,   190,   259,   184,   -13,   170,   173,
     163,    84,   165,    85,   167,   153,     7,   -14,  -244,   105,
     143,  -244,  -244,  -244,  -244,  -244,  -244,  -244,  -244,   -15,
     174,    45,   106,   104,   144,   109,   409,   111,   112,   113,
    -244,  -244,  -244,  -244,  -244,   376,   377,    13,  -244,    59,
      60,   107,   159,   -16,   -17,    13,    48,   204,   423,   108,
     252,   266,   267,   156,   110,   -13,   268,   -13,  -121,   270,
     271,  -121,   273,   168,   275,   -14,  -244,   -14,  -244,   279,
     183,   280,   187,   284,   205,   206,    13,   -15,   146,   -15,
     199,   203,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   225,
     226,   -16,   -17,   -16,   -17,   141,   343,   240,   142,   244,
       9,    10,   191,   192,   148,   100,   193,   249,     8,   152,
     171,   260,     9,    10,   203,    85,   141,   261,   272,   387,
     274,     8,   169,  -110,   242,     9,    10,   175,    59,    60,
     249,   176,   177,   178,   227,   194,    43,   380,   228,   288,
     229,    59,    60,   245,   237,   414,    66,   227,   296,    84,
     100,    85,  -110,  -110,  -110,  -110,  -110,  -110,   302,   303,
     304,   305,   349,   230,   132,   133,   134,   250,   329,   248,
     330,   378,   406,   407,   408,   381,   251,   253,   306,   130,
     131,   132,   133,   134,   311,   312,   313,   314,   315,   316,
     317,   277,   231,   232,   233,   234,   235,   236,   285,   294,
    -250,   328,   295,   297,   298,   326,   299,   156,   300,   308,
     130,   131,   132,   133,   134,   301,   367,   368,   136,   309,
    -243,   310,   320,  -243,  -243,  -243,  -243,  -243,  -243,  -243,
    -243,   332,   323,   324,   331,   335,   348,   337,   360,   339,
     340,   341,  -243,  -243,  -243,  -243,  -243,   350,   361,   351,
    -243,   364,   370,   354,   383,   199,   379,   385,   400,   413,
     419,   356,   357,   358,   359,   186,   101,   322,   325,   421,
     363,   382,   152,   117,   327,   366,  -121,   355,  -243,  -121,
    -243,   353,   258,   269,     0,   369,     0,     0,     0,   371,
       0,   372,     0,   416,   417,   418,     0,   118,     0,   415,
     334,     0,   422,     0,   125,   126,   127,   128,     0,   130,
     131,   132,   133,   134,     0,   384,     0,   136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   394,   395,   396,
       0,     0,     0,     0,     0,     0,     0,   398,     0,   399,
       0,     0,     0,     0,   403,   248,     0,   405,     0,     0,
       0,   404,  -245,     0,   412,  -245,  -245,  -245,  -245,  -245,
    -245,  -245,  -245,     0,     0,   420,    14,    15,    16,    17,
      18,    19,    20,    21,  -245,  -245,  -245,  -245,  -245,     0,
       0,     0,  -245,     0,     0,    22,    23,    24,    25,    26,
       0,     0,   391,     0,     0,     0,     0,   254,   255,   117,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -245,     0,  -245,    52,    53,    54,     0,    56,    57,    58,
      59,    60,     0,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   117,     0,   136,     0,   342,     0,     0,     0,     0,
       0,     0,     0,   137,   138,   139,     0,     0,   343,     0,
       0,     0,     9,    10,     0,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,     0,   136,   160,   164,   161,     0,
       0,     0,     0,   176,   177,   282,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,     0,
     136,   160,   166,   161,     0,     0,     0,     0,     0,     0,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   117,     0,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,     0,     0,   136,     0,   117,
       0,     0,     0,     0,     0,   176,   177,   282,   138,   139,
     388,   389,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   117,     0,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   117,   158,   136,   157,     0,     0,     0,
       0,     0,     0,     0,     0,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,     0,   160,   136,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   117,     0,
     136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     117,     0,   136,     0,     0,   189,     0,     0,     0,     0,
       0,     0,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   307,   117,   136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   117,     0,   136,     0,     0,
       0,     0,     0,     0,   319,     0,     0,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   117,     0,   136,
       0,     0,     0,     0,     0,     0,   352,     0,     0,   137,
     138,   139,     0,     0,   373,     0,     0,     0,     0,     0,
       0,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   117,
       0,   136,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   137,   138,   139,     0,     0,   374,     0,     0,     0,
       0,     0,     0,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   117,     0,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   137,   138,   139,     0,     0,   375,     0,
       0,     0,     0,     0,     0,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   117,     0,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,   138,   139,     0,     0,
     392,     0,     0,     0,     0,     0,     0,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   117,     0,   136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   137,   138,   139,
       0,     0,   393,     0,     0,     0,     0,     0,     0,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   117,     0,   136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   117,
       0,   136,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   117,     0,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   118,   119,     0,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   117,     0,     0,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,   118,     0,     0,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,     0,     0,     0,   136,     0,     0,     0,
       0,   286,   287,     0,     0,     0,   137,   138,   139,    52,
      53,    54,    55,    56,    57,    58,    59,    60,     0,    61,
     125,   126,   127,   128,     0,   130,   131,   132,   133,   134,
      62,    63,    64,   136,     0,     0,     0,     0,     0,     0,
      81,    65,     0,    66,     0,    67,    52,    53,    54,    55,
      56,    57,    58,    59,    60,     0,    61,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    62,    63,    64,
       0,     0,     0,     0,     0,     0,     0,     0,    65,     0,
      66,     0,    67,    52,    53,    54,    55,    56,    57,    58,
      59,    60,     0,    61,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    62,    63,    64,     0,     0,     0,
       0,     0,     0,     0,     0,    65,     0,    66,     0,    67,
       0,   176,   177,   178,    52,    53,    54,    55,    56,    57,
      58,    59,    60,     0,    61,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    62,    63,    64,     0,     0,
       0,     0,   224,     0,     0,     0,    65,     0,    66,     0,
      67,    52,    53,    54,    55,    56,    57,    58,    59,    60,
       0,    61,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    62,    63,    64,   239,     0,     0,     0,     0,
       0,     0,     0,    65,     0,    66,     0,    67,    52,    53,
      54,    55,    56,    57,    58,    59,    60,     0,    61,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    62,
      63,    64,     0,     0,     0,     0,     0,     0,     0,     0,
      65,  -163,    66,     0,    67,    52,    53,    54,    55,    56,
      57,    58,    59,    60,     0,    61,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    62,    63,    64,     0,
       0,     0,     0,     0,     0,     0,     0,    65,     0,    66,
       0,    67,    52,    53,    54,   262,   263,    57,    58,    59,
     264,     0,    61,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    62,    63,    64,     0,     0,     0,     0,
       0,     0,     0,     0,    65,     0,    66,     0,    67
};

static const yytype_int16 yycheck[] =
{
      16,    17,    32,   144,    20,    21,    22,    23,    24,    25,
      21,   238,    12,    14,   114,   156,   106,     0,   101,   102,
      94,    14,    96,    16,    98,    88,     0,     0,     0,    58,
      63,     3,     4,     5,     6,     7,     8,     9,    10,     0,
     103,    30,    13,    43,    77,    61,   397,    63,    64,    65,
      22,    23,    24,    25,    26,    30,    31,     4,    30,    34,
      35,    58,    92,     0,     0,    12,    14,    13,   419,    36,
     153,    30,    31,    89,    59,    58,    35,    60,    56,   162,
     163,    59,   165,    99,   167,    58,    58,    60,    60,   172,
     106,   174,   108,   183,    40,    41,    43,    58,    30,    60,
     116,   117,    48,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,    58,    58,    60,    60,    56,    30,   143,    59,   145,
      34,    35,    30,    31,    30,    15,    34,   148,    30,    87,
      30,   157,    34,    35,   160,    16,    56,   158,   164,    59,
     166,    30,   100,    13,    30,    34,    35,   105,    34,    35,
     171,    65,    66,    67,    37,    63,    58,    30,    37,   185,
      37,    34,    35,    15,    30,   402,    61,    37,   194,    14,
      15,    16,    42,    43,    44,    45,    46,    47,   204,   205,
     206,   207,   292,    13,    51,    52,    53,    58,   272,   147,
     274,   342,   394,   395,   396,   346,    36,    58,   224,    49,
      50,    51,    52,    53,   230,   231,   232,   233,   234,   235,
     236,    36,    42,    43,    44,    45,    46,    47,    18,    60,
      55,   261,    55,    62,    58,   251,    55,   253,    64,    13,
      49,    50,    51,    52,    53,    58,   329,   330,    57,    13,
       0,    13,    51,     3,     4,     5,     6,     7,     8,     9,
      10,   277,    58,    36,    23,    30,    60,    30,    60,   285,
     286,   287,    22,    23,    24,    25,    26,    58,     5,   295,
      30,    30,    58,   299,    55,   301,    58,     9,     6,    64,
      58,   307,   308,   309,   310,   107,    32,   245,   250,    60,
     323,   350,   250,    13,   253,   324,    56,   301,    58,    59,
      60,   298,   156,   161,    -1,   331,    -1,    -1,    -1,   335,
      -1,   337,    -1,   406,   407,   408,    -1,    37,    -1,   403,
     278,    -1,   415,    -1,    44,    45,    46,    47,    -1,    49,
      50,    51,    52,    53,    -1,   361,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,   374,   375,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   383,    -1,   385,
      -1,    -1,    -1,    -1,   390,   323,    -1,   393,    -1,    -1,
      -1,   392,     0,    -1,   400,     3,     4,     5,     6,     7,
       8,     9,    10,    -1,    -1,   411,     3,     4,     5,     6,
       7,     8,     9,    10,    22,    23,    24,    25,    26,    -1,
      -1,    -1,    30,    -1,    -1,    22,    23,    24,    25,    26,
      -1,    -1,   370,    -1,    -1,    -1,    -1,    11,    12,    13,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      58,    -1,    60,    27,    28,    29,    -1,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    13,    -1,    57,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    -1,    -1,    57,    13,    14,    15,    -1,
      -1,    -1,    -1,    65,    66,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    -1,    -1,
      57,    13,    14,    15,    -1,    -1,    -1,    -1,    -1,    -1,
      67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    13,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    -1,    -1,    57,    -1,    13,
      -1,    -1,    -1,    -1,    -1,    65,    66,    67,    68,    69,
      24,    25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    13,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    13,    14,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    -1,    13,    57,    15,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    68,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    13,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      13,    -1,    57,    -1,    -1,    60,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    13,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    13,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    -1,    -1,    67,    68,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    13,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    -1,    -1,    67,
      68,    69,    -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    13,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    67,    68,    69,    -1,    -1,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    13,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    13,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    68,    69,    -1,    -1,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    13,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    68,    69,
      -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    13,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    13,
      -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    67,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    13,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    13,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    19,    20,    -1,    -1,    -1,    67,    68,    69,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      44,    45,    46,    47,    -1,    49,    50,    51,    52,    53,
      48,    49,    50,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      21,    59,    -1,    61,    -1,    63,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,
      61,    -1,    63,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    50,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    59,    -1,    61,    -1,    63,
      -1,    65,    66,    67,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,    50,    -1,    -1,
      -1,    -1,    55,    -1,    -1,    -1,    59,    -1,    61,    -1,
      63,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    49,    50,    51,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    59,    -1,    61,    -1,    63,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    60,    61,    -1,    63,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    61,
      -1,    63,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    48,    49,    50,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    59,    -1,    61,    -1,    63
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    14,    81,    83,    82,    84,    86,     0,    30,    34,
      35,    79,    80,   183,     3,     4,     5,     6,     7,     8,
       9,    10,    22,    23,    24,    25,    26,    85,    87,    95,
      98,    99,   103,   105,   118,   123,   124,   125,   127,   128,
     130,   132,   134,    58,    79,    30,    88,    89,   185,   100,
     101,   185,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    37,    48,    49,    50,    59,    61,    63,   140,   141,
     142,   145,   146,   147,   152,   153,   160,   175,   179,   180,
     182,    21,   138,   140,    14,    16,   102,   104,   112,   119,
     140,   140,   160,   140,   140,   129,   140,   131,   140,   135,
      15,   102,   108,   112,    79,    58,    13,    58,    36,   140,
      59,   140,   140,   140,   176,   161,   154,    13,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    57,    67,    68,    69,
     137,    56,    59,    63,    77,   139,    30,   113,    30,   159,
     106,   107,   185,   108,   120,   121,   140,    58,    14,   112,
      13,    15,   126,   126,    14,   126,    14,   126,   140,   185,
     159,    30,   110,   159,   108,   185,    65,    66,    67,    91,
      92,    93,    94,   140,   173,   174,   101,   140,   144,    60,
      84,    30,    31,    34,    63,   162,   163,   164,   184,   140,
     155,   156,   157,   140,    13,    40,    41,    48,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,    55,   140,   140,    37,    37,    37,
      13,    42,    43,    44,    45,    46,    47,    30,   143,    51,
     140,   165,    30,   182,   140,    15,   114,   115,   185,   160,
      58,    36,   159,    58,    11,    12,   122,   178,   180,   182,
     140,   160,    30,    31,    35,   181,    30,    31,    35,   181,
     159,   159,   140,   159,   140,   159,   136,    36,   111,   159,
     159,    97,    67,    96,   173,    18,    19,    20,   140,   140,
     148,   149,   150,   151,    60,    55,   140,    62,    58,    55,
      64,    58,   140,   140,   140,   140,   140,    55,    13,    13,
      13,   140,   140,   140,   140,   140,   140,   140,   148,    64,
      51,   177,   185,    58,    36,   107,   140,   121,   112,   126,
     126,    23,   140,   109,   185,    30,    90,    30,   158,   140,
     140,   140,    17,    30,   169,   171,   173,   183,    60,    84,
      58,   140,    64,   164,   140,   157,   140,   140,   140,   140,
      60,     5,   166,   115,    30,   116,   141,   159,   159,   140,
      58,   140,   140,    30,    30,    30,    30,    31,   182,    58,
      30,   182,   149,    55,   140,     9,   167,    59,    24,    25,
     133,   185,    30,    30,   140,   140,   140,   172,   140,   140,
       6,   168,   117,   140,   160,   140,   171,   171,   171,   169,
     170,    58,   140,    64,   148,   126,   159,   159,   159,    58,
     140,    60,   159,   169
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    78,    79,    79,    80,    80,    80,    81,    82,    81,
      83,    84,    85,    85,    85,    85,    85,    85,    86,    86,
      87,    87,    87,    87,    87,    87,    87,    87,    87,    87,
      87,    87,    88,    88,    89,    90,    90,    90,    91,    92,
      93,    94,    96,    95,    97,    95,    95,    95,    95,    98,
      99,   100,   100,   101,   102,   104,   103,   105,   105,   105,
     105,   105,   105,   106,   106,   107,   108,   108,   108,   109,
     109,   111,   110,   113,   112,   114,   114,   115,   117,   116,
     119,   118,   120,   120,   121,   122,   122,   122,   122,   123,
     123,   124,   124,   125,   126,   126,   127,   128,   129,   129,
     130,   131,   131,   132,   133,   133,   135,   136,   134,   137,
     137,   137,   139,   138,   138,   140,   140,   140,   140,   140,
     140,   141,   141,   143,   142,   144,   142,   145,   145,   145,
     146,   146,   146,   146,   146,   146,   146,   146,   146,   146,
     146,   146,   146,   146,   146,   146,   146,   146,   146,   146,
     146,   146,   146,   146,   146,   146,   146,   146,   146,   146,
     146,   147,   147,   148,   148,   149,   150,   149,   151,   151,
     152,   152,   154,   153,   155,   155,   155,   156,   156,   157,
     158,   158,   158,   159,   159,   161,   160,   162,   162,   162,
     163,   163,   164,   164,   164,   164,   165,   165,   166,   166,
     167,   167,   167,   168,   168,   169,   169,   169,   169,   170,
     170,   171,   172,   171,   171,   171,   171,   173,   173,   173,
     174,   174,   175,   175,   175,   175,   175,   176,   175,   175,
     175,   175,   177,   175,   178,   178,   179,   179,   180,   180,
     180,   180,   180,   181,   181,   181,   182,   182,   183,   183,
     184,   184,   185
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     3,     2,     0,     0,     3,
       2,     2,     1,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     0,     2,     4,     3,     7,
       7,     7,     0,     6,     0,     6,     4,     4,     4,     2,
       2,     1,     3,     3,     4,     0,     3,     3,     3,     4,
       4,     3,     4,     1,     3,     3,     0,     2,     4,     1,
       3,     0,     3,     0,     3,     1,     3,     3,     0,     5,
       0,     3,     1,     3,     2,     0,     1,     1,     1,     2,
       4,     3,     5,     2,     2,     2,     4,     4,     3,     5,
       2,     3,     5,     2,     1,     1,     0,     0,    10,     1,
       1,     1,     0,     3,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     0,     5,     0,     5,     2,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     4,     4,     4,     3,     3,
       3,     4,     4,     4,     4,     4,     4,     4,     5,     5,
       5,     5,     4,     0,     1,     1,     0,     2,     1,     3,
       1,     1,     0,     4,     0,     1,     2,     1,     3,     1,
       0,     2,     4,     0,     2,     0,     4,     0,     1,     2,
       1,     3,     1,     3,     3,     5,     1,     2,     0,     2,
       0,     2,     4,     0,     2,     1,     1,     2,     2,     1,
       3,     1,     0,     4,     2,     2,     2,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     3,     0,     4,     3,
       3,     4,     0,     8,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, parser, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YY_LOCATION_PRINT
#  if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#   define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

#  else
#   define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#  endif
# endif /* !defined YY_LOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, parser); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, arangodb::aql::Parser* parser)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (parser);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, arangodb::aql::Parser* parser)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, parser);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, arangodb::aql::Parser* parser)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), parser);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, parser); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, arangodb::aql::Parser* parser)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (parser);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (arangodb::aql::Parser* parser)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, scanner);
    }

  if (yychar <= T_END)
    {
      yychar = T_END;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* with_collection: "identifier"  */
#line 495 "Aql/grammar.y"
             {
      (yyval.node) = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 2538 "Aql/grammar.cpp"
    break;

  case 3: /* with_collection: bind_parameter_datasource_expected  */
#line 498 "Aql/grammar.y"
                                       {
      (yyval.node) = (yyvsp[0].node);
    }
#line 2546 "Aql/grammar.cpp"
    break;

  case 4: /* with_collection_list: with_collection  */
#line 504 "Aql/grammar.y"
                     {
       auto node = static_cast<AstNode*>(parser->peekStack());
       node->addMember((yyvsp[0].node));
     }
#line 2555 "Aql/grammar.cpp"
    break;

  case 5: /* with_collection_list: with_collection_list "," with_collection  */
#line 508 "Aql/grammar.y"
                                                  {
       auto node = static_cast<AstNode*>(parser->peekStack());
       node->addMember((yyvsp[0].node));
     }
#line 2564 "Aql/grammar.cpp"
    break;

  case 6: /* with_collection_list: with_collection_list with_collection  */
#line 512 "Aql/grammar.y"
                                          {
       auto node = static_cast<AstNode*>(parser->peekStack());
       node->addMember((yyvsp[0].node));
     }
#line 2573 "Aql/grammar.cpp"
    break;

  case 7: /* optional_with: %empty  */
#line 519 "Aql/grammar.y"
                 {
     }
#line 2580 "Aql/grammar.cpp"
    break;

  case 8: /* $@1: %empty  */
#line 521 "Aql/grammar.y"
            {
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
     }
#line 2589 "Aql/grammar.cpp"
    break;

  case 9: /* optional_with: "WITH keyword" $@1 with_collection_list  */
#line 524 "Aql/grammar.y"
                            {
      auto node = static_cast<AstNode*>(parser->popStack());
      auto const& resolver = parser->query().resolver();
      auto withNode = parser->ast()->createNodeWithCollections(node, resolver);
      parser->ast()->addOperation(withNode);
     }
#line 2600 "Aql/grammar.cpp"
    break;

  case 10: /* queryStart: optional_with query  */
#line 533 "Aql/grammar.y"
                        {
    }
#line 2607 "Aql/grammar.cpp"
    break;

  case 11: /* query: optional_statement_block_statements final_statement  */
#line 538 "Aql/grammar.y"
                                                        {
    }
#line 2614 "Aql/grammar.cpp"
    break;

  case 12: /* final_statement: return_statement  */
#line 543 "Aql/grammar.y"
                     {
    }
#line 2621 "Aql/grammar.cpp"
    break;

  case 13: /* final_statement: remove_statement  */
#line 545 "Aql/grammar.y"
                     {
      parser->ast()->scopes()->endNested();
    }
#line 2629 "Aql/grammar.cpp"
    break;

  case 14: /* final_statement: insert_statement  */
#line 548 "Aql/grammar.y"
                     {
      parser->ast()->scopes()->endNested();
    }
#line 2637 "Aql/grammar.cpp"
    break;

  case 15: /* final_statement: update_statement  */
#line 551 "Aql/grammar.y"
                     {
      parser->ast()->scopes()->endNested();
    }
#line 2645 "Aql/grammar.cpp"
    break;

  case 16: /* final_statement: replace_statement  */
#line 554 "Aql/grammar.y"
                      {
      parser->ast()->scopes()->endNested();
    }
#line 2653 "Aql/grammar.cpp"
    break;

  case 17: /* final_statement: upsert_statement  */
#line 557 "Aql/grammar.y"
                     {
      parser->ast()->scopes()->endNested();
    }
#line 2661 "Aql/grammar.cpp"
    break;

  case 18: /* optional_statement_block_statements: %empty  */
#line 563 "Aql/grammar.y"
                {
    }
#line 2668 "Aql/grammar.cpp"
    break;

  case 19: /* optional_statement_block_statements: optional_statement_block_statements statement_block_statement  */
#line 565 "Aql/grammar.y"
                                                                  {
    }
#line 2675 "Aql/grammar.cpp"
    break;

  case 20: /* statement_block_statement: for_statement  */
#line 570 "Aql/grammar.y"
                  {
    }
#line 2682 "Aql/grammar.cpp"
    break;

  case 21: /* statement_block_statement: let_statement  */
#line 572 "Aql/grammar.y"
                  {
    }
#line 2689 "Aql/grammar.cpp"
    break;

  case 22: /* statement_block_statement: filter_statement  */
#line 574 "Aql/grammar.y"
                     {
    }
#line 2696 "Aql/grammar.cpp"
    break;

  case 23: /* statement_block_statement: collect_statement  */
#line 576 "Aql/grammar.y"
                      {
    }
#line 2703 "Aql/grammar.cpp"
    break;

  case 24: /* statement_block_statement: sort_statement  */
#line 578 "Aql/grammar.y"
                   {
    }
#line 2710 "Aql/grammar.cpp"
    break;

  case 25: /* statement_block_statement: limit_statement  */
#line 580 "Aql/grammar.y"
                    {
    }
#line 2717 "Aql/grammar.cpp"
    break;

  case 26: /* statement_block_statement: window_statement  */
#line 582 "Aql/grammar.y"
                     {
    }
#line 2724 "Aql/grammar.cpp"
    break;

  case 27: /* statement_block_statement: remove_statement  */
#line 584 "Aql/grammar.y"
                     {
    }
#line 2731 "Aql/grammar.cpp"
    break;

  case 28: /* statement_block_statement: insert_statement  */
#line 586 "Aql/grammar.y"
                     {
    }
#line 2738 "Aql/grammar.cpp"
    break;

  case 29: /* statement_block_statement: update_statement  */
#line 588 "Aql/grammar.y"
                     {
    }
#line 2745 "Aql/grammar.cpp"
    break;

  case 30: /* statement_block_statement: replace_statement  */
#line 590 "Aql/grammar.y"
                      {
    }
#line 2752 "Aql/grammar.cpp"
    break;

  case 31: /* statement_block_statement: upsert_statement  */
#line 592 "Aql/grammar.y"
                     {
    }
#line 2759 "Aql/grammar.cpp"
    break;

  case 32: /* more_output_variables: variable_name  */
#line 597 "Aql/grammar.y"
                  {
      auto wrapperNode = parser->ast()->createNodeArray();
      parser->pushArray(wrapperNode);
      // This is guaranteed to be called on the first variable
      AstNode* node = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
      parser->pushArrayElement(node);
    }
#line 2771 "Aql/grammar.cpp"
    break;

  case 33: /* more_output_variables: more_output_variables "," variable_name  */
#line 604 "Aql/grammar.y"
                                                  {
      AstNode* node = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
      parser->pushArrayElement(node);
    }
#line 2780 "Aql/grammar.cpp"
    break;

  case 34: /* for_output_variables: more_output_variables  */
#line 611 "Aql/grammar.y"
                          {
      (yyval.node) = parser->popArray();
    }
#line 2788 "Aql/grammar.cpp"
    break;

  case 35: /* prune_and_options: %empty  */
#line 617 "Aql/grammar.y"
                                                   {
      auto node = static_cast<AstNode*>(parser->peekStack());
      // Prune
      node->addMember(parser->ast()->createNodeNop());
      // Options
      node->addMember(parser->ast()->createNodeNop());
    }
#line 2800 "Aql/grammar.cpp"
    break;

  case 36: /* prune_and_options: "identifier" expression  */
#line 624 "Aql/grammar.y"
                          {
      auto node = static_cast<AstNode*>(parser->peekStack());
      if (TRI_CaseEqualString((yyvsp[-1].strval).value, "PRUNE")) {
        /* Only Prune */
        TRI_ASSERT((yyvsp[0].node) != nullptr);
        // Prune
        node->addMember((yyvsp[0].node));
        // Options
        node->addMember(parser->ast()->createNodeNop());
      } else if (TRI_CaseEqualString((yyvsp[-1].strval).value, "OPTIONS")) {
        /* Only Options */
        TRI_ASSERT((yyvsp[0].node) != nullptr);
        ::validateOptions(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column);
        // Prune
        node->addMember(parser->ast()->createNodeNop());
        // Options
        node->addMember((yyvsp[0].node));
      } else {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'PRUNE' or 'OPTIONS'", {(yyvsp[-1].strval).value, (yyvsp[-1].strval).length}, yylloc.first_line, yylloc.first_column);
      }
    }
#line 2826 "Aql/grammar.cpp"
    break;

  case 37: /* prune_and_options: "identifier" expression "identifier" object  */
#line 645 "Aql/grammar.y"
                                          {
      /* prune and options */
      auto node = static_cast<AstNode*>(parser->peekStack());
      if (!TRI_CaseEqualString((yyvsp[-3].strval).value, "PRUNE")) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'PRUNE'", {(yyvsp[-3].strval).value, (yyvsp[-3].strval).length}, yylloc.first_line, yylloc.first_column);
      }
      TRI_ASSERT((yyvsp[-2].node) != nullptr);
      if (!TRI_CaseEqualString((yyvsp[-1].strval).value, "OPTIONS")) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'OPTIONS'", {(yyvsp[-1].strval).value, (yyvsp[-1].strval).length}, yylloc.first_line, yylloc.first_column);
      }
      TRI_ASSERT((yyvsp[0].node) != nullptr);
      ::validateOptions(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column);

      // Prune
      node->addMember((yyvsp[-2].node));
      // Options
      node->addMember((yyvsp[0].node));
    }
#line 2849 "Aql/grammar.cpp"
    break;

  case 38: /* traversal_graph_info: graph_direction_steps expression graph_subject  */
#line 666 "Aql/grammar.y"
                                                   {
      auto infoNode = parser->ast()->createNodeArray();
      // Direction
      infoNode->addMember((yyvsp[-2].node));
      // Source
      infoNode->addMember((yyvsp[-1].node));
      // Graph
      infoNode->addMember((yyvsp[0].node));
      (yyval.node) = infoNode;
    }
#line 2864 "Aql/grammar.cpp"
    break;

  case 39: /* shortest_path_graph_info: graph_direction "SHORTEST_PATH keyword" expression "identifier" expression graph_subject options  */
#line 679 "Aql/grammar.y"
                                                                                         {
      (yyval.node) = ::buildShortestPathInfo(parser, (yyvsp[-3].strval).value, parser->ast()->createNodeDirection((yyvsp[-6].intval), 1), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node), yyloc);
    }
#line 2872 "Aql/grammar.cpp"
    break;

  case 40: /* k_shortest_paths_graph_info: graph_direction_steps "K_SHORTEST_PATHS keyword" expression "identifier" expression graph_subject options  */
#line 685 "Aql/grammar.y"
                                                                                                  {
      (yyval.node) = ::buildShortestPathInfo(parser, (yyvsp[-3].strval).value, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node), yyloc);
    }
#line 2880 "Aql/grammar.cpp"
    break;

  case 41: /* k_paths_graph_info: graph_direction_steps "K_PATHS keyword" expression "identifier" expression graph_subject options  */
#line 691 "Aql/grammar.y"
                                                                                         {
      (yyval.node) = ::buildShortestPathInfo(parser, (yyvsp[-3].strval).value, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node), yyloc);
    }
#line 2888 "Aql/grammar.cpp"
    break;

  case 42: /* $@2: %empty  */
#line 697 "Aql/grammar.y"
                                               {
      AstNode* variablesNode = static_cast<AstNode*>((yyvsp[-2].node));
      ::checkOutVariables(parser, variablesNode, 1, 1, "Collections and Views only have return variable", yyloc);
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_FOR);
      // now create an out variable for the FOR statement
      // this prepares us to handle the optional SEARCH condition, which may
      // or may not refer to the FOR's variable
      AstNode* variableNameNode = variablesNode->getMemberUnchecked(0);
      TRI_ASSERT(variableNameNode->isStringValue());
      AstNode* variableNode = parser->ast()->createNodeVariable(variableNameNode->getStringValue(), variableNameNode->getStringLength(), true);
      parser->pushStack(variableNode);
    }
#line 2905 "Aql/grammar.cpp"
    break;

  case 43: /* for_statement: "FOR declaration" for_output_variables "IN keyword" expression $@2 for_options  */
#line 708 "Aql/grammar.y"
                  {
      // now we can handle the optional SEARCH condition and OPTIONS.
      AstNode* variableNode = static_cast<AstNode*>(parser->popStack());

      Variable* variable = static_cast<Variable*>(variableNode->getData());

      AstNode* node = nullptr;
      AstNode* search = nullptr;
      AstNode* options = nullptr;

      if ((yyvsp[0].node) != nullptr) {
        // we got a SEARCH and/or OPTIONS clause
        TRI_ASSERT((yyvsp[0].node)->type == NODE_TYPE_ARRAY);
        TRI_ASSERT((yyvsp[0].node)->numMembers() == 2);

        search = (yyvsp[0].node)->getMemberUnchecked(0);
        if (search->type == NODE_TYPE_NOP) {
          search = nullptr;
        }
        options = (yyvsp[0].node)->getMemberUnchecked(1);
        if (options->type == NODE_TYPE_NOP) {
          options = nullptr;
        }
      }

      if (search != nullptr) {
        // we got a SEARCH clause. this is always a view.
        node = parser->ast()->createNodeForView(variable, (yyvsp[-2].node), search, options);

        if ((yyvsp[-2].node)->type != NODE_TYPE_PARAMETER_DATASOURCE &&
            (yyvsp[-2].node)->type != NODE_TYPE_VIEW &&
            (yyvsp[-2].node)->type != NODE_TYPE_COLLECTION) {
          parser->registerParseError(TRI_ERROR_QUERY_PARSE, "SEARCH condition used on non-view", yylloc.first_line, yylloc.first_column);
        }
      } else {
        node = parser->ast()->createNodeFor(variable, (yyvsp[-2].node), options);
      }

      parser->ast()->addOperation(node);
    }
#line 2950 "Aql/grammar.cpp"
    break;

  case 44: /* $@3: %empty  */
#line 748 "Aql/grammar.y"
                                                         {
      // Traversal
      auto variableNamesNode = static_cast<AstNode*>((yyvsp[-2].node));
      ::checkOutVariables(parser, variableNamesNode, 1, 3, "Traversals only have one, two or three return variables", yyloc);
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_FOR);
      auto variablesNode = ::transformOutputVariables(parser, variableNamesNode);
      auto graphInfoNode = static_cast<AstNode*>((yyvsp[0].node));
      TRI_ASSERT(graphInfoNode != nullptr);
      TRI_ASSERT(graphInfoNode->type == NODE_TYPE_ARRAY);
      parser->pushStack(variablesNode);
      parser->pushStack(graphInfoNode);
      // This stack push/pop magic is necessary to allow v, e, and p in the prune condition
    }
#line 2968 "Aql/grammar.cpp"
    break;

  case 45: /* for_statement: "FOR declaration" for_output_variables "IN keyword" traversal_graph_info $@3 prune_and_options  */
#line 760 "Aql/grammar.y"
                        {
      auto graphInfoNode = static_cast<AstNode*>(parser->popStack());
      auto variablesNode = static_cast<AstNode*>(parser->popStack());

      auto prune = graphInfoNode->getMember(3);
      if (prune != nullptr) {
        Ast::traverseReadOnly(prune, [&](AstNode const* node) {
          if (node->type == NODE_TYPE_REFERENCE && node->hasFlag(AstNodeFlagType::FLAG_SUBQUERY_REFERENCE)) {
            parser->registerParseError(TRI_ERROR_QUERY_PARSE, "prune condition must not use a subquery", yylloc.first_line, yylloc.first_column);
          }
        });
      }
      auto node = parser->ast()->createNodeTraversal(variablesNode, graphInfoNode);
      parser->ast()->addOperation(node);
    }
#line 2988 "Aql/grammar.cpp"
    break;

  case 46: /* for_statement: "FOR declaration" for_output_variables "IN keyword" shortest_path_graph_info  */
#line 775 "Aql/grammar.y"
                                                             {
      // Shortest Path
      auto variableNamesNode = static_cast<AstNode*>((yyvsp[-2].node));
      ::checkOutVariables(parser, variableNamesNode, 1, 2, "SHORTEST_PATH only has one or two return variables", yyloc);
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_FOR);
      auto variablesNode = ::transformOutputVariables(parser, variableNamesNode);
      auto graphInfoNode = static_cast<AstNode*>((yyvsp[0].node));
      TRI_ASSERT(graphInfoNode != nullptr);
      TRI_ASSERT(graphInfoNode->type == NODE_TYPE_ARRAY);
      auto node = parser->ast()->createNodeShortestPath(variablesNode, graphInfoNode);
      parser->ast()->addOperation(node);
    }
#line 3005 "Aql/grammar.cpp"
    break;

  case 47: /* for_statement: "FOR declaration" for_output_variables "IN keyword" k_shortest_paths_graph_info  */
#line 787 "Aql/grammar.y"
                                                                {
      // K Shortest Paths
      auto variableNamesNode = static_cast<AstNode*>((yyvsp[-2].node));
      ::checkOutVariables(parser, variableNamesNode, 1, 1, "K_SHORTEST_PATHS only has one return variable", yyloc);
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_FOR);
      auto variablesNode = ::transformOutputVariables(parser, variableNamesNode);
      auto graphInfoNode = static_cast<AstNode*>((yyvsp[0].node));
      TRI_ASSERT(graphInfoNode != nullptr);
      TRI_ASSERT(graphInfoNode->type == NODE_TYPE_ARRAY);
      auto node = parser->ast()->createNodeKShortestPaths(arangodb::graph::ShortestPathType::Type::KShortestPaths, variablesNode, graphInfoNode);
      parser->ast()->addOperation(node);
    }
#line 3022 "Aql/grammar.cpp"
    break;

  case 48: /* for_statement: "FOR declaration" for_output_variables "IN keyword" k_paths_graph_info  */
#line 799 "Aql/grammar.y"
                                                       {
      // K Paths
      auto variableNamesNode = static_cast<AstNode*>((yyvsp[-2].node));
      ::checkOutVariables(parser, variableNamesNode, 1, 1, "K_PATHS only has one return variable", yyloc);
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_FOR);
      auto variablesNode = ::transformOutputVariables(parser, variableNamesNode);
      auto graphInfoNode = static_cast<AstNode*>((yyvsp[0].node));
      TRI_ASSERT(graphInfoNode != nullptr);
      TRI_ASSERT(graphInfoNode->type == NODE_TYPE_ARRAY);
      auto node = parser->ast()->createNodeKShortestPaths(arangodb::graph::ShortestPathType::Type::KPaths, variablesNode, graphInfoNode);
      parser->ast()->addOperation(node);
    }
#line 3039 "Aql/grammar.cpp"
    break;

  case 49: /* filter_statement: "FILTER declaration" expression  */
#line 814 "Aql/grammar.y"
                        {
      // operand is a reference. can use it directly
      auto node = parser->ast()->createNodeFilter((yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3049 "Aql/grammar.cpp"
    break;

  case 50: /* let_statement: "LET declaration" let_list  */
#line 822 "Aql/grammar.y"
                   {
    }
#line 3056 "Aql/grammar.cpp"
    break;

  case 51: /* let_list: let_element  */
#line 827 "Aql/grammar.y"
                {
    }
#line 3063 "Aql/grammar.cpp"
    break;

  case 52: /* let_list: let_list "," let_element  */
#line 829 "Aql/grammar.y"
                                 {
    }
#line 3070 "Aql/grammar.cpp"
    break;

  case 53: /* let_element: variable_name "assignment" expression  */
#line 834 "Aql/grammar.y"
                                      {
      auto node = parser->ast()->createNodeLet((yyvsp[-2].strval).value, (yyvsp[-2].strval).length, (yyvsp[0].node), true);
      parser->ast()->addOperation(node);
    }
#line 3079 "Aql/grammar.cpp"
    break;

  case 54: /* count_into: "WITH keyword" "identifier" "INTO keyword" variable_name  */
#line 841 "Aql/grammar.y"
                                         {
      if (!TRI_CaseEqualString((yyvsp[-2].strval).value, "COUNT")) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'COUNT'", {(yyvsp[-2].strval).value, (yyvsp[-2].strval).length}, yylloc.first_line, yylloc.first_column);
      }

      (yyval.strval) = (yyvsp[0].strval);
    }
#line 3091 "Aql/grammar.cpp"
    break;

  case 55: /* $@4: %empty  */
#line 851 "Aql/grammar.y"
              {
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3100 "Aql/grammar.cpp"
    break;

  case 56: /* collect_variable_list: "COLLECT declaration" $@4 collect_list  */
#line 854 "Aql/grammar.y"
                   {
      auto list = static_cast<AstNode*>(parser->popStack());
      TRI_ASSERT(list != nullptr);
      (yyval.node) = list;
    }
#line 3110 "Aql/grammar.cpp"
    break;

  case 57: /* collect_statement: "COLLECT declaration" count_into options  */
#line 862 "Aql/grammar.y"
                                 {
      /* COLLECT WITH COUNT INTO var OPTIONS ... */
      auto scopes = parser->ast()->scopes();

      ::startCollectScope(scopes);

      // in the AST this is transformed to COLLECT AGGREGATE var = COUNT()
      auto node = parser->ast()->createNodeCollectCount(parser->ast()->createNodeArray(), (yyvsp[-1].strval).value, (yyvsp[-1].strval).length, (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3125 "Aql/grammar.cpp"
    break;

  case 58: /* collect_statement: collect_variable_list count_into options  */
#line 872 "Aql/grammar.y"
                                             {
      /* COLLECT var = expr WITH COUNT INTO var OPTIONS ... */
      auto scopes = parser->ast()->scopes();

      if (::startCollectScope(scopes)) {
        VarSet variables{};
        ::registerAssignVariables(parser, scopes, yylloc.first_line, yylloc.first_column, variables, (yyvsp[-2].node));
      }

      // in the AST this is transformed to COLLECT var = expr AGGREGATE var = COUNT()
      auto node = parser->ast()->createNodeCollectCount((yyvsp[-2].node), (yyvsp[-1].strval).value, (yyvsp[-1].strval).length, (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3143 "Aql/grammar.cpp"
    break;

  case 59: /* collect_statement: "COLLECT declaration" aggregate collect_optional_into options  */
#line 885 "Aql/grammar.y"
                                                      {
      /* AGGREGATE var = expr OPTIONS ... */
      VarSet variablesIntroduced{};
      auto scopes = parser->ast()->scopes();

      if (::startCollectScope(scopes)) {
        ::registerAssignVariables(parser, scopes, yylloc.first_line, yylloc.first_column, variablesIntroduced, (yyvsp[-2].node));
      }

      // validate aggregates
      if (!::validateAggregates(parser, (yyvsp[-2].node), yylloc.first_line, yylloc.first_column)) {
        YYABORT;
      }

      if ((yyvsp[-1].node) != nullptr && (yyvsp[-1].node)->type == NODE_TYPE_ARRAY) {
        ::checkIntoVariables(parser, (yyvsp[-1].node)->getMember(1), yylloc.first_line, yylloc.first_column, variablesIntroduced);
      }

      AstNode const* into = ::getIntoVariable(parser, (yyvsp[-1].node));
      AstNode const* intoExpression = ::getIntoExpression((yyvsp[-1].node));

      auto node = parser->ast()->createNodeCollect(parser->ast()->createNodeArray(), (yyvsp[-2].node), into, intoExpression, nullptr, (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3172 "Aql/grammar.cpp"
    break;

  case 60: /* collect_statement: collect_variable_list aggregate collect_optional_into options  */
#line 909 "Aql/grammar.y"
                                                                  {
      /* COLLECT var = expr AGGREGATE var = expr OPTIONS ... */
      VarSet variablesIntroduced{};
      auto scopes = parser->ast()->scopes();

      if (::startCollectScope(scopes)) {
        ::registerAssignVariables(parser, scopes, yylloc.first_line, yylloc.first_column, variablesIntroduced, (yyvsp[-3].node));
        ::registerAssignVariables(parser, scopes, yylloc.first_line, yylloc.first_column, variablesIntroduced, (yyvsp[-2].node));
      }

      if (!::validateAggregates(parser, (yyvsp[-2].node), yylloc.first_line, yylloc.first_column)) {
        YYABORT;
      }

      if ((yyvsp[-1].node) != nullptr && (yyvsp[-1].node)->type == NODE_TYPE_ARRAY) {
        ::checkIntoVariables(parser, (yyvsp[-1].node)->getMember(1), yylloc.first_line, yylloc.first_column, variablesIntroduced);
      }

      // note all group variables
      VarSet groupVars{};
      size_t n = (yyvsp[-3].node)->numMembers();
      for (size_t i = 0; i < n; ++i) {
        auto member = (yyvsp[-3].node)->getMember(i);

        if (member != nullptr) {
          TRI_ASSERT(member->type == NODE_TYPE_ASSIGN);
          groupVars.emplace(static_cast<Variable const*>(member->getMember(0)->getData()));
        }
      }

      // now validate if any aggregate refers to one of the group variables
      n = (yyvsp[-2].node)->numMembers();
      for (size_t i = 0; i < n; ++i) {
        auto member = (yyvsp[-2].node)->getMember(i);

        if (member != nullptr) {
          TRI_ASSERT(member->type == NODE_TYPE_ASSIGN);
          VarSet variablesUsed{};
          Ast::getReferencedVariables(member->getMember(1), variablesUsed);

          for (auto& it : groupVars) {
            if (variablesUsed.find(it) != variablesUsed.end()) {
              parser->registerParseError(TRI_ERROR_QUERY_VARIABLE_NAME_UNKNOWN,
                "use of unknown variable '%s' in AGGREGATE expression", it->name.c_str(), yylloc.first_line, yylloc.first_column);
              break;
            }
          }
        }
      }

      AstNode const* into = ::getIntoVariable(parser, (yyvsp[-1].node));
      AstNode const* intoExpression = ::getIntoExpression((yyvsp[-1].node));

      auto node = parser->ast()->createNodeCollect((yyvsp[-3].node), (yyvsp[-2].node), into, intoExpression, nullptr, (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3233 "Aql/grammar.cpp"
    break;

  case 61: /* collect_statement: collect_variable_list collect_optional_into options  */
#line 965 "Aql/grammar.y"
                                                        {
      /* COLLECT var = expr INTO var OPTIONS ... */
      VarSet variablesIntroduced{};
      auto scopes = parser->ast()->scopes();

      if (::startCollectScope(scopes)) {
        ::registerAssignVariables(parser, scopes, yylloc.first_line, yylloc.first_column, variablesIntroduced, (yyvsp[-2].node));
      }

      if ((yyvsp[-1].node) != nullptr && (yyvsp[-1].node)->type == NODE_TYPE_ARRAY) {
        ::checkIntoVariables(parser, (yyvsp[-1].node)->getMember(1), yylloc.first_line, yylloc.first_column, variablesIntroduced);
      }

      AstNode const* into = ::getIntoVariable(parser, (yyvsp[-1].node));
      AstNode const* intoExpression = ::getIntoExpression((yyvsp[-1].node));

      auto node = parser->ast()->createNodeCollect((yyvsp[-2].node), parser->ast()->createNodeArray(), into, intoExpression, nullptr, (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3257 "Aql/grammar.cpp"
    break;

  case 62: /* collect_statement: collect_variable_list collect_optional_into keep options  */
#line 984 "Aql/grammar.y"
                                                             {
      /* COLLECT var = expr INTO var KEEP ... OPTIONS ... */
      VarSet variablesIntroduced{};
      auto scopes = parser->ast()->scopes();

      if (::startCollectScope(scopes)) {
        ::registerAssignVariables(parser, scopes, yylloc.first_line, yylloc.first_column, variablesIntroduced, (yyvsp[-3].node));
      }

      if ((yyvsp[-2].node) == nullptr &&
          (yyvsp[-1].node) != nullptr) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "use of 'KEEP' without 'INTO'", yylloc.first_line, yylloc.first_column);
      }

      if ((yyvsp[-2].node) != nullptr && (yyvsp[-2].node)->type == NODE_TYPE_ARRAY) {
        ::checkIntoVariables(parser, (yyvsp[-2].node)->getMember(1), yylloc.first_line, yylloc.first_column, variablesIntroduced);
      }

      AstNode const* into = ::getIntoVariable(parser, (yyvsp[-2].node));
      AstNode const* intoExpression = ::getIntoExpression((yyvsp[-2].node));

      auto node = parser->ast()->createNodeCollect((yyvsp[-3].node), parser->ast()->createNodeArray(), into, intoExpression, (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3286 "Aql/grammar.cpp"
    break;

  case 63: /* collect_list: collect_element  */
#line 1011 "Aql/grammar.y"
                    {
    }
#line 3293 "Aql/grammar.cpp"
    break;

  case 64: /* collect_list: collect_list "," collect_element  */
#line 1013 "Aql/grammar.y"
                                         {
    }
#line 3300 "Aql/grammar.cpp"
    break;

  case 65: /* collect_element: variable_name "assignment" expression  */
#line 1018 "Aql/grammar.y"
                                      {
      auto node = parser->ast()->createNodeAssign((yyvsp[-2].strval).value, (yyvsp[-2].strval).length, (yyvsp[0].node));
      parser->pushArrayElement(node);
    }
#line 3309 "Aql/grammar.cpp"
    break;

  case 66: /* collect_optional_into: %empty  */
#line 1025 "Aql/grammar.y"
                {
      (yyval.node) = nullptr;
    }
#line 3317 "Aql/grammar.cpp"
    break;

  case 67: /* collect_optional_into: "INTO keyword" variable_name  */
#line 1028 "Aql/grammar.y"
                         {
      (yyval.node) = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 3325 "Aql/grammar.cpp"
    break;

  case 68: /* collect_optional_into: "INTO keyword" variable_name "assignment" expression  */
#line 1031 "Aql/grammar.y"
                                             {
      auto node = parser->ast()->createNodeArray();
      node->addMember(parser->ast()->createNodeValueString((yyvsp[-2].strval).value, (yyvsp[-2].strval).length));
      node->addMember((yyvsp[0].node));
      (yyval.node) = node;
    }
#line 3336 "Aql/grammar.cpp"
    break;

  case 69: /* variable_list: variable_name  */
#line 1040 "Aql/grammar.y"
                  {
      if (! parser->ast()->scopes()->existsVariable((yyvsp[0].strval).value, (yyvsp[0].strval).length)) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "use of unknown variable '%s' for KEEP", {(yyvsp[0].strval).value, (yyvsp[0].strval).length}, yylloc.first_line, yylloc.first_column);
      }

      auto node = parser->ast()->createNodeReference((yyvsp[0].strval).value, (yyvsp[0].strval).length);
      TRI_ASSERT(node != nullptr);

      // indicate the this node is a reference to the variable name, not the variable value
      node->setFlag(FLAG_KEEP_VARIABLENAME);
      parser->pushArrayElement(node);
    }
#line 3353 "Aql/grammar.cpp"
    break;

  case 70: /* variable_list: variable_list "," variable_name  */
#line 1052 "Aql/grammar.y"
                                        {
      if (! parser->ast()->scopes()->existsVariable((yyvsp[0].strval).value, (yyvsp[0].strval).length)) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "use of unknown variable '%s' for KEEP", {(yyvsp[0].strval).value, (yyvsp[0].strval).length}, yylloc.first_line, yylloc.first_column);
      }

      auto node = parser->ast()->createNodeReference((yyvsp[0].strval).value, (yyvsp[0].strval).length);
      TRI_ASSERT(node != nullptr);

      // indicate the this node is a reference to the variable name, not the variable value
      node->setFlag(FLAG_KEEP_VARIABLENAME);
      parser->pushArrayElement(node);
    }
#line 3370 "Aql/grammar.cpp"
    break;

  case 71: /* $@5: %empty  */
#line 1067 "Aql/grammar.y"
             {
      if (!TRI_CaseEqualString((yyvsp[0].strval).value, "KEEP")) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'KEEP'", {(yyvsp[0].strval).value, (yyvsp[0].strval).length}, yylloc.first_line, yylloc.first_column);
      }

      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3383 "Aql/grammar.cpp"
    break;

  case 72: /* keep: "identifier" $@5 variable_list  */
#line 1074 "Aql/grammar.y"
                    {
      auto list = static_cast<AstNode*>(parser->popStack());
      (yyval.node) = list;
    }
#line 3392 "Aql/grammar.cpp"
    break;

  case 73: /* $@6: %empty  */
#line 1081 "Aql/grammar.y"
                {
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3401 "Aql/grammar.cpp"
    break;

  case 74: /* aggregate: "AGGREGATE keyword" $@6 aggregate_list  */
#line 1084 "Aql/grammar.y"
                     {
      auto list = static_cast<AstNode*>(parser->popStack());
      (yyval.node) = list;
    }
#line 3410 "Aql/grammar.cpp"
    break;

  case 75: /* aggregate_list: aggregate_element  */
#line 1091 "Aql/grammar.y"
                      {
    }
#line 3417 "Aql/grammar.cpp"
    break;

  case 76: /* aggregate_list: aggregate_list "," aggregate_element  */
#line 1093 "Aql/grammar.y"
                                             {
    }
#line 3424 "Aql/grammar.cpp"
    break;

  case 77: /* aggregate_element: variable_name "assignment" aggregate_function_call  */
#line 1098 "Aql/grammar.y"
                                                   {
      auto node = parser->ast()->createNodeAssign((yyvsp[-2].strval).value, (yyvsp[-2].strval).length, (yyvsp[0].node));
      parser->pushArrayElement(node);
    }
#line 3433 "Aql/grammar.cpp"
    break;

  case 78: /* $@7: %empty  */
#line 1105 "Aql/grammar.y"
                         {
      parser->pushStack((yyvsp[-1].strval).value);
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3443 "Aql/grammar.cpp"
    break;

  case 79: /* aggregate_function_call: function_name "(" $@7 optional_function_call_arguments ")"  */
#line 1109 "Aql/grammar.y"
                                                              {
      auto list = static_cast<AstNode const*>(parser->popStack());
      (yyval.node) = parser->ast()->createNodeAggregateFunctionCall(static_cast<char const*>(parser->popStack()), list);
    }
#line 3452 "Aql/grammar.cpp"
    break;

  case 80: /* $@8: %empty  */
#line 1116 "Aql/grammar.y"
           {
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3461 "Aql/grammar.cpp"
    break;

  case 81: /* sort_statement: "SORT declaration" $@8 sort_list  */
#line 1119 "Aql/grammar.y"
                {
      auto list = static_cast<AstNode const*>(parser->popStack());
      auto node = parser->ast()->createNodeSort(list);
      parser->ast()->addOperation(node);
    }
#line 3471 "Aql/grammar.cpp"
    break;

  case 82: /* sort_list: sort_element  */
#line 1127 "Aql/grammar.y"
                 {
      parser->pushArrayElement((yyvsp[0].node));
    }
#line 3479 "Aql/grammar.cpp"
    break;

  case 83: /* sort_list: sort_list "," sort_element  */
#line 1130 "Aql/grammar.y"
                                   {
      parser->pushArrayElement((yyvsp[0].node));
    }
#line 3487 "Aql/grammar.cpp"
    break;

  case 84: /* sort_element: expression sort_direction  */
#line 1136 "Aql/grammar.y"
                              {
      (yyval.node) = parser->ast()->createNodeSortElement((yyvsp[-1].node), (yyvsp[0].node));
    }
#line 3495 "Aql/grammar.cpp"
    break;

  case 85: /* sort_direction: %empty  */
#line 1142 "Aql/grammar.y"
                {
      (yyval.node) = parser->ast()->createNodeValueBool(true);
    }
#line 3503 "Aql/grammar.cpp"
    break;

  case 86: /* sort_direction: "ASC keyword"  */
#line 1145 "Aql/grammar.y"
          {
      (yyval.node) = parser->ast()->createNodeValueBool(true);
    }
#line 3511 "Aql/grammar.cpp"
    break;

  case 87: /* sort_direction: "DESC keyword"  */
#line 1148 "Aql/grammar.y"
           {
      (yyval.node) = parser->ast()->createNodeValueBool(false);
    }
#line 3519 "Aql/grammar.cpp"
    break;

  case 88: /* sort_direction: simple_value  */
#line 1151 "Aql/grammar.y"
                 {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3527 "Aql/grammar.cpp"
    break;

  case 89: /* limit_statement: "LIMIT declaration" expression  */
#line 1157 "Aql/grammar.y"
                       {
      auto offset = parser->ast()->createNodeValueInt(0);
      auto node = parser->ast()->createNodeLimit(offset, (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3537 "Aql/grammar.cpp"
    break;

  case 90: /* limit_statement: "LIMIT declaration" expression "," expression  */
#line 1162 "Aql/grammar.y"
                                          {
      auto node = parser->ast()->createNodeLimit((yyvsp[-2].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3546 "Aql/grammar.cpp"
    break;

  case 91: /* window_statement: "WINDOW declaration" object aggregate  */
#line 1169 "Aql/grammar.y"
                              {
      /* WINDOW {preceding:2, following:2} AGGREGATE x = AVG(x) */
      
      // validate aggregates
      if (!::validateAggregates(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column)) {
        YYABORT;
      }
      
      if (!::validateWindowSpec(parser, (yyvsp[-1].node), yylloc.first_line, yylloc.first_column)) {
        YYABORT;
      }
      
      auto node = parser->ast()->createNodeWindow(/*spec*/(yyvsp[-1].node), /*range*/nullptr, /*aggrs*/(yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3566 "Aql/grammar.cpp"
    break;

  case 92: /* window_statement: "WINDOW declaration" expression "WITH keyword" object aggregate  */
#line 1184 "Aql/grammar.y"
                                                {
    /* WINDOW rangeVar WITH {preceding:"1d", following:"1d"} AGGREGATE x = AVG(x) */
    
    // validate aggregates
    if (!::validateAggregates(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column)) {
      YYABORT;
    }
    
    if (!::validateWindowSpec(parser, (yyvsp[-1].node), yylloc.first_line, yylloc.first_column)) {
      YYABORT;
    }
    
    auto node = parser->ast()->createNodeWindow(/*spec*/(yyvsp[-1].node), /*range*/(yyvsp[-3].node), /*aggrs*/(yyvsp[0].node));
    parser->ast()->addOperation(node);
  }
#line 3586 "Aql/grammar.cpp"
    break;

  case 93: /* return_statement: "RETURN declaration" distinct_expression  */
#line 1202 "Aql/grammar.y"
                                 {
      auto node = parser->ast()->createNodeReturn((yyvsp[0].node));
      parser->ast()->addOperation(node);
      parser->ast()->scopes()->endNested();
    }
#line 3596 "Aql/grammar.cpp"
    break;

  case 94: /* in_or_into_collection: "IN keyword" in_or_into_collection_name  */
#line 1210 "Aql/grammar.y"
                                    {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3604 "Aql/grammar.cpp"
    break;

  case 95: /* in_or_into_collection: "INTO keyword" in_or_into_collection_name  */
#line 1213 "Aql/grammar.y"
                                      {
       (yyval.node) = (yyvsp[0].node);
     }
#line 3612 "Aql/grammar.cpp"
    break;

  case 96: /* remove_statement: "REMOVE command" expression in_or_into_collection options  */
#line 1219 "Aql/grammar.y"
                                                      {
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }
      auto node = parser->ast()->createNodeRemove((yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3624 "Aql/grammar.cpp"
    break;

  case 97: /* insert_statement: "INSERT command" expression in_or_into_collection options  */
#line 1229 "Aql/grammar.y"
                                                      {
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }
      auto node = parser->ast()->createNodeInsert((yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3636 "Aql/grammar.cpp"
    break;

  case 98: /* update_parameters: expression in_or_into_collection options  */
#line 1239 "Aql/grammar.y"
                                             {
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }

      AstNode* node = parser->ast()->createNodeUpdate(nullptr, (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3649 "Aql/grammar.cpp"
    break;

  case 99: /* update_parameters: expression "WITH keyword" expression in_or_into_collection options  */
#line 1247 "Aql/grammar.y"
                                                               {
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }

      AstNode* node = parser->ast()->createNodeUpdate((yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3662 "Aql/grammar.cpp"
    break;

  case 100: /* update_statement: "UPDATE command" update_parameters  */
#line 1258 "Aql/grammar.y"
                               {
    }
#line 3669 "Aql/grammar.cpp"
    break;

  case 101: /* replace_parameters: expression in_or_into_collection options  */
#line 1263 "Aql/grammar.y"
                                             {
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }

      AstNode* node = parser->ast()->createNodeReplace(nullptr, (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3682 "Aql/grammar.cpp"
    break;

  case 102: /* replace_parameters: expression "WITH keyword" expression in_or_into_collection options  */
#line 1271 "Aql/grammar.y"
                                                               {
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }

      AstNode* node = parser->ast()->createNodeReplace((yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3695 "Aql/grammar.cpp"
    break;

  case 103: /* replace_statement: "REPLACE command" replace_parameters  */
#line 1282 "Aql/grammar.y"
                                 {
    }
#line 3702 "Aql/grammar.cpp"
    break;

  case 104: /* update_or_replace: "UPDATE command"  */
#line 1287 "Aql/grammar.y"
             {
      (yyval.intval) = static_cast<int64_t>(NODE_TYPE_UPDATE);
    }
#line 3710 "Aql/grammar.cpp"
    break;

  case 105: /* update_or_replace: "REPLACE command"  */
#line 1290 "Aql/grammar.y"
              {
      (yyval.intval) = static_cast<int64_t>(NODE_TYPE_REPLACE);
    }
#line 3718 "Aql/grammar.cpp"
    break;

  case 106: /* $@9: %empty  */
#line 1296 "Aql/grammar.y"
             {
      // reserve a variable named "$OLD", we might need it in the update expression
      // and in a later return thing
      parser->pushStack(parser->ast()->createNodeVariable(TRI_CHAR_LENGTH_PAIR(Variable::NAME_OLD), true));
    }
#line 3728 "Aql/grammar.cpp"
    break;

  case 107: /* $@10: %empty  */
#line 1300 "Aql/grammar.y"
                 {
      AstNode* variableNode = static_cast<AstNode*>(parser->popStack());

      auto scopes = parser->ast()->scopes();

      scopes->start(arangodb::aql::AQL_SCOPE_SUBQUERY);
      parser->ast()->startSubQuery();

      scopes->start(arangodb::aql::AQL_SCOPE_FOR);
      std::string const variableName = parser->ast()->variables()->nextName();
      auto forNode = parser->ast()->createNodeForUpsert(variableName.c_str(), variableName.size(), parser->ast()->createNodeArray(), false);
      parser->ast()->addOperation(forNode);

      auto filterNode = parser->ast()->createNodeUpsertFilter(parser->ast()->createNodeReference(variableName), (yyvsp[0].node));
      parser->ast()->addOperation(filterNode);

      auto offsetValue = parser->ast()->createNodeValueInt(0);
      auto limitValue = parser->ast()->createNodeValueInt(1);
      auto limitNode = parser->ast()->createNodeLimit(offsetValue, limitValue);
      parser->ast()->addOperation(limitNode);

      auto refNode = parser->ast()->createNodeReference(variableName);
      auto returnNode = parser->ast()->createNodeReturn(refNode);
      parser->ast()->addOperation(returnNode);
      scopes->endNested();

      AstNode* subqueryNode = parser->ast()->endSubQuery();
      scopes->endCurrent();

      std::string const subqueryName = parser->ast()->variables()->nextName();
      auto subQuery = parser->ast()->createNodeLet(subqueryName.c_str(), subqueryName.size(), subqueryNode, false);
      parser->ast()->addOperation(subQuery);

      auto index = parser->ast()->createNodeValueInt(0);
      auto firstDoc = parser->ast()->createNodeLet(variableNode, parser->ast()->createNodeIndexedAccess(parser->ast()->createNodeReference(subqueryName), index));
      parser->ast()->addOperation(firstDoc);

      parser->pushStack(forNode);
    }
#line 3772 "Aql/grammar.cpp"
    break;

  case 108: /* upsert_statement: "UPSERT command" $@9 expression $@10 "INSERT command" expression update_or_replace expression in_or_into_collection options  */
#line 1338 "Aql/grammar.y"
                                                                                     {
      AstNode* forNode = static_cast<AstNode*>(parser->popStack());
      forNode->changeMember(1, (yyvsp[-1].node));
      if (!parser->configureWriteQuery((yyvsp[-1].node), (yyvsp[0].node))) {
        YYABORT;
      }

      auto node = parser->ast()->createNodeUpsert(static_cast<AstNodeType>((yyvsp[-3].intval)), parser->ast()->createNodeReference(TRI_CHAR_LENGTH_PAIR(Variable::NAME_OLD)), (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), (yyvsp[0].node));
      parser->ast()->addOperation(node);
    }
#line 3787 "Aql/grammar.cpp"
    break;

  case 109: /* quantifier: "all modifier"  */
#line 1351 "Aql/grammar.y"
          {
      (yyval.node) = parser->ast()->createNodeQuantifier(Quantifier::ALL);
    }
#line 3795 "Aql/grammar.cpp"
    break;

  case 110: /* quantifier: "any modifier"  */
#line 1354 "Aql/grammar.y"
          {
      (yyval.node) = parser->ast()->createNodeQuantifier(Quantifier::ANY);
    }
#line 3803 "Aql/grammar.cpp"
    break;

  case 111: /* quantifier: "none modifier"  */
#line 1357 "Aql/grammar.y"
           {
      (yyval.node) = parser->ast()->createNodeQuantifier(Quantifier::NONE);
    }
#line 3811 "Aql/grammar.cpp"
    break;

  case 112: /* $@11: %empty  */
#line 1363 "Aql/grammar.y"
               {
      auto const scopeType = parser->ast()->scopes()->type();

      if (scopeType == AQL_SCOPE_MAIN ||
          scopeType == AQL_SCOPE_SUBQUERY) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "cannot use DISTINCT modifier on top-level query element", yylloc.first_line, yylloc.first_column);
      }
    }
#line 3824 "Aql/grammar.cpp"
    break;

  case 113: /* distinct_expression: "DISTINCT modifier" $@11 expression  */
#line 1370 "Aql/grammar.y"
                 {
      (yyval.node) = parser->ast()->createNodeDistinct((yyvsp[0].node));
    }
#line 3832 "Aql/grammar.cpp"
    break;

  case 114: /* distinct_expression: expression  */
#line 1373 "Aql/grammar.y"
               {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3840 "Aql/grammar.cpp"
    break;

  case 115: /* expression: operator_unary  */
#line 1379 "Aql/grammar.y"
                   {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3848 "Aql/grammar.cpp"
    break;

  case 116: /* expression: operator_binary  */
#line 1382 "Aql/grammar.y"
                    {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3856 "Aql/grammar.cpp"
    break;

  case 117: /* expression: operator_ternary  */
#line 1385 "Aql/grammar.y"
                     {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3864 "Aql/grammar.cpp"
    break;

  case 118: /* expression: value_literal  */
#line 1388 "Aql/grammar.y"
                  {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3872 "Aql/grammar.cpp"
    break;

  case 119: /* expression: reference  */
#line 1391 "Aql/grammar.y"
              {
      (yyval.node) = (yyvsp[0].node);
    }
#line 3880 "Aql/grammar.cpp"
    break;

  case 120: /* expression: expression ".." expression  */
#line 1394 "Aql/grammar.y"
                                  {
      (yyval.node) = parser->ast()->createNodeRange((yyvsp[-2].node), (yyvsp[0].node));
    }
#line 3888 "Aql/grammar.cpp"
    break;

  case 121: /* function_name: "identifier"  */
#line 1400 "Aql/grammar.y"
             {
      (yyval.strval) = (yyvsp[0].strval);
    }
#line 3896 "Aql/grammar.cpp"
    break;

  case 122: /* function_name: function_name "::" "identifier"  */
#line 1403 "Aql/grammar.y"
                                   {
      std::string temp((yyvsp[-2].strval).value, (yyvsp[-2].strval).length);
      temp.append("::");
      temp.append((yyvsp[0].strval).value, (yyvsp[0].strval).length);
      auto p = parser->ast()->resources().registerString(temp);
      TRI_ASSERT(p != nullptr);

      (yyval.strval).value = p;
      (yyval.strval).length = temp.size();
    }
#line 3911 "Aql/grammar.cpp"
    break;

  case 123: /* $@12: %empty  */
#line 1416 "Aql/grammar.y"
                         {
      parser->pushStack((yyvsp[-1].strval).value);

      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3922 "Aql/grammar.cpp"
    break;

  case 124: /* function_call: function_name "(" $@12 optional_function_call_arguments ")"  */
#line 1421 "Aql/grammar.y"
                                                              {
      auto list = static_cast<AstNode const*>(parser->popStack());
      (yyval.node) = parser->ast()->createNodeFunctionCall(static_cast<char const*>(parser->popStack()), list, false);
    }
#line 3931 "Aql/grammar.cpp"
    break;

  case 125: /* $@13: %empty  */
#line 1425 "Aql/grammar.y"
                  {
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
    }
#line 3940 "Aql/grammar.cpp"
    break;

  case 126: /* function_call: "like operator" "(" $@13 optional_function_call_arguments ")"  */
#line 1428 "Aql/grammar.y"
                                                              {
      auto list = static_cast<AstNode const*>(parser->popStack());
      (yyval.node) = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("LIKE"), list, false);
    }
#line 3949 "Aql/grammar.cpp"
    break;

  case 127: /* operator_unary: "+ operator" expression  */
#line 1435 "Aql/grammar.y"
                                  {
      (yyval.node) = parser->ast()->optimizeUnaryOperatorArithmetic(parser->ast()->createNodeUnaryOperator(NODE_TYPE_OPERATOR_UNARY_PLUS, (yyvsp[0].node)));
    }
#line 3957 "Aql/grammar.cpp"
    break;

  case 128: /* operator_unary: "- operator" expression  */
#line 1438 "Aql/grammar.y"
                                    {
      (yyval.node) = parser->ast()->optimizeUnaryOperatorArithmetic(parser->ast()->createNodeUnaryOperator(NODE_TYPE_OPERATOR_UNARY_MINUS, (yyvsp[0].node)));
    }
#line 3965 "Aql/grammar.cpp"
    break;

  case 129: /* operator_unary: "not operator" expression  */
#line 1441 "Aql/grammar.y"
                                     {
      (yyval.node) = parser->ast()->createNodeUnaryOperator(NODE_TYPE_OPERATOR_UNARY_NOT, (yyvsp[0].node));
    }
#line 3973 "Aql/grammar.cpp"
    break;

  case 130: /* operator_binary: expression "or operator" expression  */
#line 1447 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_OR, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 3981 "Aql/grammar.cpp"
    break;

  case 131: /* operator_binary: expression "and operator" expression  */
#line 1450 "Aql/grammar.y"
                                {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_AND, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 3989 "Aql/grammar.cpp"
    break;

  case 132: /* operator_binary: expression "+ operator" expression  */
#line 1453 "Aql/grammar.y"
                                 {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_PLUS, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 3997 "Aql/grammar.cpp"
    break;

  case 133: /* operator_binary: expression "- operator" expression  */
#line 1456 "Aql/grammar.y"
                                  {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_MINUS, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4005 "Aql/grammar.cpp"
    break;

  case 134: /* operator_binary: expression "* operator" expression  */
#line 1459 "Aql/grammar.y"
                                  {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_TIMES, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4013 "Aql/grammar.cpp"
    break;

  case 135: /* operator_binary: expression "/ operator" expression  */
#line 1462 "Aql/grammar.y"
                                {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_DIV, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4021 "Aql/grammar.cpp"
    break;

  case 136: /* operator_binary: expression "% operator" expression  */
#line 1465 "Aql/grammar.y"
                                {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_MOD, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4029 "Aql/grammar.cpp"
    break;

  case 137: /* operator_binary: expression "== operator" expression  */
#line 1468 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_EQ, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4037 "Aql/grammar.cpp"
    break;

  case 138: /* operator_binary: expression "!= operator" expression  */
#line 1471 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_NE, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4045 "Aql/grammar.cpp"
    break;

  case 139: /* operator_binary: expression "< operator" expression  */
#line 1474 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_LT, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4053 "Aql/grammar.cpp"
    break;

  case 140: /* operator_binary: expression "> operator" expression  */
#line 1477 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_GT, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4061 "Aql/grammar.cpp"
    break;

  case 141: /* operator_binary: expression "<= operator" expression  */
#line 1480 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_LE, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4069 "Aql/grammar.cpp"
    break;

  case 142: /* operator_binary: expression ">= operator" expression  */
#line 1483 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_GE, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4077 "Aql/grammar.cpp"
    break;

  case 143: /* operator_binary: expression "IN keyword" expression  */
#line 1486 "Aql/grammar.y"
                               {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_IN, (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4085 "Aql/grammar.cpp"
    break;

  case 144: /* operator_binary: expression "not operator" "IN keyword" expression  */
#line 1489 "Aql/grammar.y"
                                     {
      (yyval.node) = parser->ast()->createNodeBinaryOperator(NODE_TYPE_OPERATOR_BINARY_NIN, (yyvsp[-3].node), (yyvsp[0].node));
    }
#line 4093 "Aql/grammar.cpp"
    break;

  case 145: /* operator_binary: expression "not operator" "like operator" expression  */
#line 1492 "Aql/grammar.y"
                                       {
      AstNode* arguments = parser->ast()->createNodeArray(2);
      arguments->addMember((yyvsp[-3].node));
      arguments->addMember((yyvsp[0].node));
      AstNode* expression = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("LIKE"), arguments, false);
      (yyval.node) = parser->ast()->createNodeUnaryOperator(NODE_TYPE_OPERATOR_UNARY_NOT, expression);
    }
#line 4105 "Aql/grammar.cpp"
    break;

  case 146: /* operator_binary: expression "not operator" "~= operator" expression  */
#line 1499 "Aql/grammar.y"
                                              {
      AstNode* arguments = parser->ast()->createNodeArray(2);
      arguments->addMember((yyvsp[-3].node));
      arguments->addMember((yyvsp[0].node));
      AstNode* expression = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("REGEX_TEST"), arguments, false);
      (yyval.node) = parser->ast()->createNodeUnaryOperator(NODE_TYPE_OPERATOR_UNARY_NOT, expression);
    }
#line 4117 "Aql/grammar.cpp"
    break;

  case 147: /* operator_binary: expression "not operator" "~! operator" expression  */
#line 1506 "Aql/grammar.y"
                                                  {
      AstNode* arguments = parser->ast()->createNodeArray(2);
      arguments->addMember((yyvsp[-3].node));
      arguments->addMember((yyvsp[0].node));
      (yyval.node) = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("REGEX_TEST"), arguments, false);
    }
#line 4128 "Aql/grammar.cpp"
    break;

  case 148: /* operator_binary: expression "like operator" expression  */
#line 1512 "Aql/grammar.y"
                                 {
      AstNode* arguments = parser->ast()->createNodeArray(2);
      arguments->addMember((yyvsp[-2].node));
      arguments->addMember((yyvsp[0].node));
      (yyval.node) = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("LIKE"), arguments, false);
    }
#line 4139 "Aql/grammar.cpp"
    break;

  case 149: /* operator_binary: expression "~= operator" expression  */
#line 1518 "Aql/grammar.y"
                                        {
      AstNode* arguments = parser->ast()->createNodeArray(2);
      arguments->addMember((yyvsp[-2].node));
      arguments->addMember((yyvsp[0].node));
      (yyval.node) = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("REGEX_TEST"), arguments, false);
    }
#line 4150 "Aql/grammar.cpp"
    break;

  case 150: /* operator_binary: expression "~! operator" expression  */
#line 1524 "Aql/grammar.y"
                                            {
      AstNode* arguments = parser->ast()->createNodeArray(2);
      arguments->addMember((yyvsp[-2].node));
      arguments->addMember((yyvsp[0].node));
      AstNode* node = parser->ast()->createNodeFunctionCall(TRI_CHAR_LENGTH_PAIR("REGEX_TEST"), arguments, false);
      (yyval.node) = parser->ast()->createNodeUnaryOperator(NODE_TYPE_OPERATOR_UNARY_NOT, node);
    }
#line 4162 "Aql/grammar.cpp"
    break;

  case 151: /* operator_binary: expression quantifier "== operator" expression  */
#line 1531 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_EQ, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4170 "Aql/grammar.cpp"
    break;

  case 152: /* operator_binary: expression quantifier "!= operator" expression  */
#line 1534 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_NE, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4178 "Aql/grammar.cpp"
    break;

  case 153: /* operator_binary: expression quantifier "< operator" expression  */
#line 1537 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_LT, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4186 "Aql/grammar.cpp"
    break;

  case 154: /* operator_binary: expression quantifier "> operator" expression  */
#line 1540 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_GT, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4194 "Aql/grammar.cpp"
    break;

  case 155: /* operator_binary: expression quantifier "<= operator" expression  */
#line 1543 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_LE, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4202 "Aql/grammar.cpp"
    break;

  case 156: /* operator_binary: expression quantifier ">= operator" expression  */
#line 1546 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_GE, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4210 "Aql/grammar.cpp"
    break;

  case 157: /* operator_binary: expression quantifier "IN keyword" expression  */
#line 1549 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_IN, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-2].node));
    }
#line 4218 "Aql/grammar.cpp"
    break;

  case 158: /* operator_binary: expression "all modifier" "not operator" "IN keyword" expression  */
#line 1552 "Aql/grammar.y"
                                           {
      auto quantifier = parser->ast()->createNodeQuantifier(Quantifier::ALL);
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_NIN, (yyvsp[-4].node), (yyvsp[0].node), quantifier);
    }
#line 4227 "Aql/grammar.cpp"
    break;

  case 159: /* operator_binary: expression "any modifier" "not operator" "IN keyword" expression  */
#line 1556 "Aql/grammar.y"
                                           {
      auto quantifier = parser->ast()->createNodeQuantifier(Quantifier::ANY);
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_NIN, (yyvsp[-4].node), (yyvsp[0].node), quantifier);
    }
#line 4236 "Aql/grammar.cpp"
    break;

  case 160: /* operator_binary: expression "none modifier" "not operator" "IN keyword" expression  */
#line 1560 "Aql/grammar.y"
                                            {
      auto quantifier = parser->ast()->createNodeQuantifier(Quantifier::NONE);
      (yyval.node) = parser->ast()->createNodeBinaryArrayOperator(NODE_TYPE_OPERATOR_BINARY_ARRAY_NIN, (yyvsp[-4].node), (yyvsp[0].node), quantifier);
    }
#line 4245 "Aql/grammar.cpp"
    break;

  case 161: /* operator_ternary: expression "?" expression ":" expression  */
#line 1567 "Aql/grammar.y"
                                                        {
      (yyval.node) = parser->ast()->createNodeTernaryOperator((yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4253 "Aql/grammar.cpp"
    break;

  case 162: /* operator_ternary: expression "?" ":" expression  */
#line 1570 "Aql/grammar.y"
                                             {
      (yyval.node) = parser->ast()->createNodeTernaryOperator((yyvsp[-3].node), (yyvsp[0].node));
    }
#line 4261 "Aql/grammar.cpp"
    break;

  case 163: /* optional_function_call_arguments: %empty  */
#line 1576 "Aql/grammar.y"
                {
    }
#line 4268 "Aql/grammar.cpp"
    break;

  case 164: /* optional_function_call_arguments: function_arguments_list  */
#line 1578 "Aql/grammar.y"
                            {
    }
#line 4275 "Aql/grammar.cpp"
    break;

  case 165: /* expression_or_query: expression  */
#line 1583 "Aql/grammar.y"
               {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4283 "Aql/grammar.cpp"
    break;

  case 166: /* $@14: %empty  */
#line 1586 "Aql/grammar.y"
    {
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_SUBQUERY);
      parser->ast()->startSubQuery();
    }
#line 4292 "Aql/grammar.cpp"
    break;

  case 167: /* expression_or_query: $@14 query  */
#line 1589 "Aql/grammar.y"
            {
      AstNode* node = parser->ast()->endSubQuery();
      parser->ast()->scopes()->endCurrent();

      std::string const variableName = parser->ast()->variables()->nextName();
      auto subQuery = parser->ast()->createNodeLet(variableName.c_str(), variableName.size(), node, false);
      parser->ast()->addOperation(subQuery);

      (yyval.node) = parser->ast()->createNodeSubqueryReference(variableName);
    }
#line 4307 "Aql/grammar.cpp"
    break;

  case 168: /* function_arguments_list: expression_or_query  */
#line 1602 "Aql/grammar.y"
                        {
      parser->pushArrayElement((yyvsp[0].node));
    }
#line 4315 "Aql/grammar.cpp"
    break;

  case 169: /* function_arguments_list: function_arguments_list "," expression_or_query  */
#line 1605 "Aql/grammar.y"
                                                        {
      parser->pushArrayElement((yyvsp[0].node));
    }
#line 4323 "Aql/grammar.cpp"
    break;

  case 170: /* compound_value: array  */
#line 1611 "Aql/grammar.y"
          {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4331 "Aql/grammar.cpp"
    break;

  case 171: /* compound_value: object  */
#line 1614 "Aql/grammar.y"
           {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4339 "Aql/grammar.cpp"
    break;

  case 172: /* $@15: %empty  */
#line 1620 "Aql/grammar.y"
                 {
      auto node = parser->ast()->createNodeArray();
      parser->pushArray(node);
    }
#line 4348 "Aql/grammar.cpp"
    break;

  case 173: /* array: "[" $@15 optional_array_elements "]"  */
#line 1623 "Aql/grammar.y"
                                            {
      (yyval.node) = parser->popArray();
    }
#line 4356 "Aql/grammar.cpp"
    break;

  case 174: /* optional_array_elements: %empty  */
#line 1629 "Aql/grammar.y"
                {
    }
#line 4363 "Aql/grammar.cpp"
    break;

  case 175: /* optional_array_elements: array_elements_list  */
#line 1631 "Aql/grammar.y"
                        {
    }
#line 4370 "Aql/grammar.cpp"
    break;

  case 176: /* optional_array_elements: array_elements_list ","  */
#line 1633 "Aql/grammar.y"
                                {
    }
#line 4377 "Aql/grammar.cpp"
    break;

  case 177: /* array_elements_list: array_element  */
#line 1638 "Aql/grammar.y"
                  {
    }
#line 4384 "Aql/grammar.cpp"
    break;

  case 178: /* array_elements_list: array_elements_list "," array_element  */
#line 1640 "Aql/grammar.y"
                                              {
    }
#line 4391 "Aql/grammar.cpp"
    break;

  case 179: /* array_element: expression  */
#line 1645 "Aql/grammar.y"
               {
      parser->pushArrayElement((yyvsp[0].node));
    }
#line 4399 "Aql/grammar.cpp"
    break;

  case 180: /* for_options: %empty  */
#line 1651 "Aql/grammar.y"
                {
      (yyval.node) = nullptr;
    }
#line 4407 "Aql/grammar.cpp"
    break;

  case 181: /* for_options: "identifier" expression  */
#line 1654 "Aql/grammar.y"
                        {
      TRI_ASSERT((yyvsp[0].node) != nullptr);
      // we always return an array with two values: SEARCH and OPTIONS
      // as only one of these values will be set here, the other value is NOP
      auto node = parser->ast()->createNodeArray(2);
      // only one extra qualifier. now we need to check if it is SEARCH or OPTIONS

      if (TRI_CaseEqualString((yyvsp[-1].strval).value, "SEARCH")) {
        // found SEARCH
        node->addMember((yyvsp[0].node));
        node->addMember(parser->ast()->createNodeNop());
      } else {
        // everything else must be OPTIONS
        if (!TRI_CaseEqualString((yyvsp[-1].strval).value, "OPTIONS")) {
          parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'SEARCH' or 'OPTIONS'", {(yyvsp[-1].strval).value, (yyvsp[-1].strval).length}, yylloc.first_line, yylloc.first_column);
        }
      
        ::validateOptions(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column);

        node->addMember(parser->ast()->createNodeNop());
        node->addMember((yyvsp[0].node));
      }

      (yyval.node) = node;
    }
#line 4437 "Aql/grammar.cpp"
    break;

  case 182: /* for_options: "identifier" expression "identifier" expression  */
#line 1679 "Aql/grammar.y"
                                            {
      TRI_ASSERT((yyvsp[-2].node) != nullptr);
      // two extra qualifiers. we expect them in the order: SEARCH, then OPTIONS

      if (!TRI_CaseEqualString((yyvsp[-3].strval).value, "SEARCH") ||
          !TRI_CaseEqualString((yyvsp[-1].strval).value, "OPTIONS")) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'SEARCH' and 'OPTIONS'", {(yyvsp[-3].strval).value, (yyvsp[-3].strval).length}, yylloc.first_line, yylloc.first_column);
      }
      
      ::validateOptions(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column);

      auto node = parser->ast()->createNodeArray(2);
      node->addMember((yyvsp[-2].node));
      node->addMember((yyvsp[0].node));
      (yyval.node) = node;
    }
#line 4458 "Aql/grammar.cpp"
    break;

  case 183: /* options: %empty  */
#line 1698 "Aql/grammar.y"
                {
      (yyval.node) = nullptr;
    }
#line 4466 "Aql/grammar.cpp"
    break;

  case 184: /* options: "identifier" object  */
#line 1701 "Aql/grammar.y"
                    {
      TRI_ASSERT((yyvsp[0].node) != nullptr);

      if (!TRI_CaseEqualString((yyvsp[-1].strval).value, "OPTIONS")) {
        parser->registerParseError(TRI_ERROR_QUERY_PARSE, "unexpected qualifier '%s', expecting 'OPTIONS'", {(yyvsp[-1].strval).value, (yyvsp[-1].strval).length}, yylloc.first_line, yylloc.first_column);
      }
      
      ::validateOptions(parser, (yyvsp[0].node), yylloc.first_line, yylloc.first_column);

      (yyval.node) = (yyvsp[0].node);
    }
#line 4482 "Aql/grammar.cpp"
    break;

  case 185: /* $@16: %empty  */
#line 1715 "Aql/grammar.y"
                  {
      auto node = parser->ast()->createNodeObject();
      parser->pushStack(node);
    }
#line 4491 "Aql/grammar.cpp"
    break;

  case 186: /* object: "{" $@16 optional_object_elements "}"  */
#line 1718 "Aql/grammar.y"
                                              {
      (yyval.node) = static_cast<AstNode*>(parser->popStack());
    }
#line 4499 "Aql/grammar.cpp"
    break;

  case 187: /* optional_object_elements: %empty  */
#line 1724 "Aql/grammar.y"
                {
    }
#line 4506 "Aql/grammar.cpp"
    break;

  case 188: /* optional_object_elements: object_elements_list  */
#line 1726 "Aql/grammar.y"
                         {
    }
#line 4513 "Aql/grammar.cpp"
    break;

  case 189: /* optional_object_elements: object_elements_list ","  */
#line 1728 "Aql/grammar.y"
                                 {
    }
#line 4520 "Aql/grammar.cpp"
    break;

  case 190: /* object_elements_list: object_element  */
#line 1733 "Aql/grammar.y"
                   {
    }
#line 4527 "Aql/grammar.cpp"
    break;

  case 191: /* object_elements_list: object_elements_list "," object_element  */
#line 1735 "Aql/grammar.y"
                                                {
    }
#line 4534 "Aql/grammar.cpp"
    break;

  case 192: /* object_element: "identifier"  */
#line 1740 "Aql/grammar.y"
             {
      // attribute-name-only (comparable to JS enhanced object literals, e.g. { foo, bar })
      auto ast = parser->ast();
      auto variable = ast->scopes()->getVariable((yyvsp[0].strval).value, (yyvsp[0].strval).length, true);

      if (variable == nullptr) {
        // variable does not exist
        parser->registerParseError(TRI_ERROR_QUERY_VARIABLE_NAME_UNKNOWN, "use of unknown variable '%s' in object literal", {(yyvsp[0].strval).value, (yyvsp[0].strval).length}, yylloc.first_line, yylloc.first_column);
      }

      // create a reference to the variable
      auto node = ast->createNodeReference(variable);
      parser->pushObjectElement((yyvsp[0].strval).value, (yyvsp[0].strval).length, node);
    }
#line 4553 "Aql/grammar.cpp"
    break;

  case 193: /* object_element: object_element_name ":" expression  */
#line 1754 "Aql/grammar.y"
                                           {
      // attribute-name : attribute-value
      parser->pushObjectElement((yyvsp[-2].strval).value, (yyvsp[-2].strval).length, (yyvsp[0].node));
    }
#line 4562 "Aql/grammar.cpp"
    break;

  case 194: /* object_element: "bind parameter" ":" expression  */
#line 1758 "Aql/grammar.y"
                                   {
      // bind-parameter : attribute-value
      if ((yyvsp[-2].strval).length < 1 || (yyvsp[-2].strval).value[0] == '@') {
        parser->registerParseError(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE, TRI_errno_string(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE).data(), (yyvsp[-2].strval).value, yylloc.first_line, yylloc.first_column);
      }

      auto param = parser->ast()->createNodeParameter((yyvsp[-2].strval).value, (yyvsp[-2].strval).length);
      parser->pushObjectElement(param, (yyvsp[0].node));
    }
#line 4576 "Aql/grammar.cpp"
    break;

  case 195: /* object_element: "[" expression "]" ":" expression  */
#line 1767 "Aql/grammar.y"
                                                             {
      // [ attribute-name-expression ] : attribute-value
      parser->pushObjectElement((yyvsp[-3].node), (yyvsp[0].node));
    }
#line 4585 "Aql/grammar.cpp"
    break;

  case 196: /* array_filter_operator: "* operator"  */
#line 1774 "Aql/grammar.y"
            {
      (yyval.intval) = 1;
    }
#line 4593 "Aql/grammar.cpp"
    break;

  case 197: /* array_filter_operator: array_filter_operator "* operator"  */
#line 1777 "Aql/grammar.y"
                                  {
      (yyval.intval) = (yyvsp[-1].intval) + 1;
    }
#line 4601 "Aql/grammar.cpp"
    break;

  case 198: /* optional_array_filter: %empty  */
#line 1783 "Aql/grammar.y"
                {
      (yyval.node) = nullptr;
    }
#line 4609 "Aql/grammar.cpp"
    break;

  case 199: /* optional_array_filter: "FILTER declaration" expression  */
#line 1786 "Aql/grammar.y"
                        {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4617 "Aql/grammar.cpp"
    break;

  case 200: /* optional_array_limit: %empty  */
#line 1792 "Aql/grammar.y"
                {
      (yyval.node) = nullptr;
    }
#line 4625 "Aql/grammar.cpp"
    break;

  case 201: /* optional_array_limit: "LIMIT declaration" expression  */
#line 1795 "Aql/grammar.y"
                       {
      (yyval.node) = parser->ast()->createNodeArrayLimit(nullptr, (yyvsp[0].node));
    }
#line 4633 "Aql/grammar.cpp"
    break;

  case 202: /* optional_array_limit: "LIMIT declaration" expression "," expression  */
#line 1798 "Aql/grammar.y"
                                          {
      (yyval.node) = parser->ast()->createNodeArrayLimit((yyvsp[-2].node), (yyvsp[0].node));
    }
#line 4641 "Aql/grammar.cpp"
    break;

  case 203: /* optional_array_return: %empty  */
#line 1804 "Aql/grammar.y"
                {
      (yyval.node) = nullptr;
    }
#line 4649 "Aql/grammar.cpp"
    break;

  case 204: /* optional_array_return: "RETURN declaration" expression  */
#line 1807 "Aql/grammar.y"
                        {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4657 "Aql/grammar.cpp"
    break;

  case 205: /* graph_collection: "identifier"  */
#line 1813 "Aql/grammar.y"
             {
      (yyval.node) = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 4665 "Aql/grammar.cpp"
    break;

  case 206: /* graph_collection: bind_parameter_datasource_expected  */
#line 1816 "Aql/grammar.y"
                                       {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4673 "Aql/grammar.cpp"
    break;

  case 207: /* graph_collection: graph_direction "identifier"  */
#line 1819 "Aql/grammar.y"
                             {
      auto tmp = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
      (yyval.node) = parser->ast()->createNodeCollectionDirection((yyvsp[-1].intval), tmp);
    }
#line 4682 "Aql/grammar.cpp"
    break;

  case 208: /* graph_collection: graph_direction bind_parameter  */
#line 1823 "Aql/grammar.y"
                                   {
      (yyval.node) = parser->ast()->createNodeCollectionDirection((yyvsp[-1].intval), (yyvsp[0].node));
    }
#line 4690 "Aql/grammar.cpp"
    break;

  case 209: /* graph_collection_list: graph_collection  */
#line 1829 "Aql/grammar.y"
                      {
       auto node = static_cast<AstNode*>(parser->peekStack());
       node->addMember((yyvsp[0].node));
     }
#line 4699 "Aql/grammar.cpp"
    break;

  case 210: /* graph_collection_list: graph_collection_list "," graph_collection  */
#line 1833 "Aql/grammar.y"
                                                    {
       auto node = static_cast<AstNode*>(parser->peekStack());
       node->addMember((yyvsp[0].node));
     }
#line 4708 "Aql/grammar.cpp"
    break;

  case 211: /* graph_subject: graph_collection  */
#line 1840 "Aql/grammar.y"
                     {
      auto node = parser->ast()->createNodeArray();
      node->addMember((yyvsp[0].node));
      auto const& resolver = parser->query().resolver();
      (yyval.node) = parser->ast()->createNodeCollectionList(node, resolver);
    }
#line 4719 "Aql/grammar.cpp"
    break;

  case 212: /* $@17: %empty  */
#line 1846 "Aql/grammar.y"
                             {
      auto node = parser->ast()->createNodeArray();
      parser->pushStack(node);
      node->addMember((yyvsp[-1].node));
    }
#line 4729 "Aql/grammar.cpp"
    break;

  case 213: /* graph_subject: graph_collection "," $@17 graph_collection_list  */
#line 1850 "Aql/grammar.y"
                            {
      auto node = static_cast<AstNode*>(parser->popStack());
      auto const& resolver = parser->query().resolver();
      (yyval.node) = parser->ast()->createNodeCollectionList(node, resolver);
    }
#line 4739 "Aql/grammar.cpp"
    break;

  case 214: /* graph_subject: "GRAPH keyword" bind_parameter  */
#line 1855 "Aql/grammar.y"
                           {
      // graph name
      (yyval.node) = (yyvsp[0].node);
    }
#line 4748 "Aql/grammar.cpp"
    break;

  case 215: /* graph_subject: "GRAPH keyword" "quoted string"  */
#line 1859 "Aql/grammar.y"
                            {
      // graph name
      (yyval.node) = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 4757 "Aql/grammar.cpp"
    break;

  case 216: /* graph_subject: "GRAPH keyword" "identifier"  */
#line 1863 "Aql/grammar.y"
                     {
      // graph name
      (yyval.node) = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 4766 "Aql/grammar.cpp"
    break;

  case 217: /* graph_direction: "outbound modifier"  */
#line 1872 "Aql/grammar.y"
               {
      (yyval.intval) = 2;
    }
#line 4774 "Aql/grammar.cpp"
    break;

  case 218: /* graph_direction: "inbound modifier"  */
#line 1875 "Aql/grammar.y"
              {
      (yyval.intval) = 1;
    }
#line 4782 "Aql/grammar.cpp"
    break;

  case 219: /* graph_direction: "any modifier"  */
#line 1878 "Aql/grammar.y"
          {
      (yyval.intval) = 0;
    }
#line 4790 "Aql/grammar.cpp"
    break;

  case 220: /* graph_direction_steps: graph_direction  */
#line 1884 "Aql/grammar.y"
                    {
      (yyval.node) = parser->ast()->createNodeDirection((yyvsp[0].intval), 1);
    }
#line 4798 "Aql/grammar.cpp"
    break;

  case 221: /* graph_direction_steps: expression graph_direction  */
#line 1887 "Aql/grammar.y"
                                                {
      (yyval.node) = parser->ast()->createNodeDirection((yyvsp[0].intval), (yyvsp[-1].node));
    }
#line 4806 "Aql/grammar.cpp"
    break;

  case 222: /* reference: "identifier"  */
#line 1893 "Aql/grammar.y"
             {
      // variable or collection or view
      auto ast = parser->ast();
      AstNode* node = nullptr;

      auto variable = ast->scopes()->getVariable((yyvsp[0].strval).value, (yyvsp[0].strval).length, true);

      if (variable == nullptr) {
        // variable does not exist
        // now try special variables
        if (ast->scopes()->canUseCurrentVariable() && strcmp((yyvsp[0].strval).value, "CURRENT") == 0) {
          variable = ast->scopes()->getCurrentVariable();
        } else if (strcmp((yyvsp[0].strval).value, Variable::NAME_CURRENT) == 0) {
          variable = ast->scopes()->getCurrentVariable();
        }
      }

      if (variable != nullptr) {
        // variable alias exists, now use it
        node = ast->createNodeReference(variable);
      }

      if (node == nullptr) {
        // variable not found. so it must have been a collection or view
        auto const& resolver = parser->query().resolver();
        node = ast->createNodeDataSource(resolver, (yyvsp[0].strval).value, (yyvsp[0].strval).length, arangodb::AccessMode::Type::READ, true, false);
      }

      TRI_ASSERT(node != nullptr);

      (yyval.node) = node;
    }
#line 4843 "Aql/grammar.cpp"
    break;

  case 223: /* reference: compound_value  */
#line 1925 "Aql/grammar.y"
                   {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4851 "Aql/grammar.cpp"
    break;

  case 224: /* reference: bind_parameter  */
#line 1928 "Aql/grammar.y"
                   {
      (yyval.node) = (yyvsp[0].node);
    }
#line 4859 "Aql/grammar.cpp"
    break;

  case 225: /* reference: function_call  */
#line 1931 "Aql/grammar.y"
                  {
      TRI_ASSERT((yyvsp[0].node) != nullptr);
      (yyval.node) = (yyvsp[0].node);
    }
#line 4868 "Aql/grammar.cpp"
    break;

  case 226: /* reference: "(" expression ")"  */
#line 1935 "Aql/grammar.y"
                              {
      if ((yyvsp[-1].node)->type == NODE_TYPE_EXPANSION) {
        // create a dummy passthru node that reduces and evaluates the expansion first
        // and the expansion on top of the stack won't be chained with any other expansions
        (yyval.node) = parser->ast()->createNodePassthru((yyvsp[-1].node));
      }
      else {
        (yyval.node) = (yyvsp[-1].node);
      }
    }
#line 4883 "Aql/grammar.cpp"
    break;

  case 227: /* $@18: %empty  */
#line 1945 "Aql/grammar.y"
           {
      parser->ast()->scopes()->start(arangodb::aql::AQL_SCOPE_SUBQUERY);
      parser->ast()->startSubQuery();
    }
#line 4892 "Aql/grammar.cpp"
    break;

  case 228: /* reference: "(" $@18 query ")"  */
#line 1948 "Aql/grammar.y"
                    {
      AstNode* node = parser->ast()->endSubQuery();
      parser->ast()->scopes()->endCurrent();

      std::string const variableName = parser->ast()->variables()->nextName();
      auto subQuery = parser->ast()->createNodeLet(variableName.c_str(), variableName.size(), node, false);
      parser->ast()->addOperation(subQuery);

      (yyval.node) = parser->ast()->createNodeSubqueryReference(variableName);
    }
#line 4907 "Aql/grammar.cpp"
    break;

  case 229: /* reference: reference '.' "identifier"  */
#line 1958 "Aql/grammar.y"
                                           {
      // named variable access, e.g. variable.reference
      if ((yyvsp[-2].node)->type == NODE_TYPE_EXPANSION) {
        // if left operand is an expansion already...
        // dive into the expansion's right-hand child nodes for further expansion and
        // patch the bottom-most one
        auto current = const_cast<AstNode*>(parser->ast()->findExpansionSubNode((yyvsp[-2].node)));
        TRI_ASSERT(current->type == NODE_TYPE_EXPANSION);
        current->changeMember(1, parser->ast()->createNodeAttributeAccess(current->getMember(1), (yyvsp[0].strval).value, (yyvsp[0].strval).length));
        (yyval.node) = (yyvsp[-2].node);
      }
      else {
        (yyval.node) = parser->ast()->createNodeAttributeAccess((yyvsp[-2].node), (yyvsp[0].strval).value, (yyvsp[0].strval).length);
      }
    }
#line 4927 "Aql/grammar.cpp"
    break;

  case 230: /* reference: reference '.' bind_parameter  */
#line 1973 "Aql/grammar.y"
                                                 {
      // named variable access, e.g. variable.@reference
      if ((yyvsp[-2].node)->type == NODE_TYPE_EXPANSION) {
        // if left operand is an expansion already...
        // patch the existing expansion
        auto current = const_cast<AstNode*>(parser->ast()->findExpansionSubNode((yyvsp[-2].node)));
        TRI_ASSERT(current->type == NODE_TYPE_EXPANSION);
        current->changeMember(1, parser->ast()->createNodeBoundAttributeAccess(current->getMember(1), (yyvsp[0].node)));
        (yyval.node) = (yyvsp[-2].node);
      }
      else {
        (yyval.node) = parser->ast()->createNodeBoundAttributeAccess((yyvsp[-2].node), (yyvsp[0].node));
      }
    }
#line 4946 "Aql/grammar.cpp"
    break;

  case 231: /* reference: reference "[" expression "]"  */
#line 1987 "Aql/grammar.y"
                                                                  {
      // indexed variable access, e.g. variable[index]
      if ((yyvsp[-3].node)->type == NODE_TYPE_EXPANSION) {
        // if left operand is an expansion already...
        // patch the existing expansion
        auto current = const_cast<AstNode*>(parser->ast()->findExpansionSubNode((yyvsp[-3].node)));
        TRI_ASSERT(current->type == NODE_TYPE_EXPANSION);
        current->changeMember(1, parser->ast()->createNodeIndexedAccess(current->getMember(1), (yyvsp[-1].node)));
        (yyval.node) = (yyvsp[-3].node);
      }
      else {
        (yyval.node) = parser->ast()->createNodeIndexedAccess((yyvsp[-3].node), (yyvsp[-1].node));
      }
    }
#line 4965 "Aql/grammar.cpp"
    break;

  case 232: /* $@19: %empty  */
#line 2001 "Aql/grammar.y"
                                                 {
      // variable expansion, e.g. variable[*], with optional FILTER, LIMIT and RETURN clauses
      if ((yyvsp[0].intval) > 1 && (yyvsp[-2].node)->type == NODE_TYPE_EXPANSION) {
        // create a dummy passthru node that reduces and evaluates the expansion first
        // and the expansion on top of the stack won't be chained with any other expansions
        (yyvsp[-2].node) = parser->ast()->createNodePassthru((yyvsp[-2].node));
      }

      // create a temporary iterator variable
      std::string const nextName = parser->ast()->variables()->nextName() + "_";

      if ((yyvsp[-2].node)->type == NODE_TYPE_EXPANSION) {
        auto iterator = parser->ast()->createNodeIterator(nextName.c_str(), nextName.size(), (yyvsp[-2].node)->getMember(1));
        parser->pushStack(iterator);
      }
      else {
        auto iterator = parser->ast()->createNodeIterator(nextName.c_str(), nextName.size(), (yyvsp[-2].node));
        parser->pushStack(iterator);
      }

      auto scopes = parser->ast()->scopes();
      scopes->stackCurrentVariable(scopes->getVariable(nextName));
    }
#line 4993 "Aql/grammar.cpp"
    break;

  case 233: /* reference: reference "[" array_filter_operator $@19 optional_array_filter optional_array_limit optional_array_return "]"  */
#line 2023 "Aql/grammar.y"
                                                                                                     {
      auto scopes = parser->ast()->scopes();
      scopes->unstackCurrentVariable();

      auto iterator = static_cast<AstNode const*>(parser->popStack());
      auto variableNode = iterator->getMember(0);
      TRI_ASSERT(variableNode->type == NODE_TYPE_VARIABLE);
      auto variable = static_cast<Variable const*>(variableNode->getData());

      if ((yyvsp[-7].node)->type == NODE_TYPE_EXPANSION) {
        auto expand = parser->ast()->createNodeExpansion((yyvsp[-5].intval), iterator, parser->ast()->createNodeReference(variable->name), (yyvsp[-3].node), (yyvsp[-2].node), (yyvsp[-1].node));
        (yyvsp[-7].node)->changeMember(1, expand);
        (yyval.node) = (yyvsp[-7].node);
      }
      else {
        (yyval.node) = parser->ast()->createNodeExpansion((yyvsp[-5].intval), iterator, parser->ast()->createNodeReference(variable->name), (yyvsp[-3].node), (yyvsp[-2].node), (yyvsp[-1].node));
      }
    }
#line 5016 "Aql/grammar.cpp"
    break;

  case 234: /* simple_value: value_literal  */
#line 2044 "Aql/grammar.y"
                  {
      (yyval.node) = (yyvsp[0].node);
    }
#line 5024 "Aql/grammar.cpp"
    break;

  case 235: /* simple_value: bind_parameter  */
#line 2047 "Aql/grammar.y"
                   {
      (yyval.node) = (yyvsp[0].node);
    }
#line 5032 "Aql/grammar.cpp"
    break;

  case 236: /* numeric_value: "integer number"  */
#line 2053 "Aql/grammar.y"
              {
      TRI_ASSERT((yyvsp[0].node) != nullptr);
      (yyval.node) = (yyvsp[0].node);
    }
#line 5041 "Aql/grammar.cpp"
    break;

  case 237: /* numeric_value: "number"  */
#line 2057 "Aql/grammar.y"
             {
      TRI_ASSERT((yyvsp[0].node) != nullptr);
      (yyval.node) = (yyvsp[0].node);
    }
#line 5050 "Aql/grammar.cpp"
    break;

  case 238: /* value_literal: "quoted string"  */
#line 2064 "Aql/grammar.y"
                    {
      (yyval.node) = parser->ast()->createNodeValueString((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 5058 "Aql/grammar.cpp"
    break;

  case 239: /* value_literal: numeric_value  */
#line 2067 "Aql/grammar.y"
                  {
      (yyval.node) = (yyvsp[0].node);
    }
#line 5066 "Aql/grammar.cpp"
    break;

  case 240: /* value_literal: "null"  */
#line 2070 "Aql/grammar.y"
           {
      (yyval.node) = parser->ast()->createNodeValueNull();
    }
#line 5074 "Aql/grammar.cpp"
    break;

  case 241: /* value_literal: "true"  */
#line 2073 "Aql/grammar.y"
           {
      (yyval.node) = parser->ast()->createNodeValueBool(true);
    }
#line 5082 "Aql/grammar.cpp"
    break;

  case 242: /* value_literal: "false"  */
#line 2076 "Aql/grammar.y"
            {
      (yyval.node) = parser->ast()->createNodeValueBool(false);
    }
#line 5090 "Aql/grammar.cpp"
    break;

  case 243: /* in_or_into_collection_name: "identifier"  */
#line 2082 "Aql/grammar.y"
             {
      auto const& resolver = parser->query().resolver();
      (yyval.node) = parser->ast()->createNodeCollection(resolver, (yyvsp[0].strval).value, (yyvsp[0].strval).length, arangodb::AccessMode::Type::WRITE);
    }
#line 5099 "Aql/grammar.cpp"
    break;

  case 244: /* in_or_into_collection_name: "quoted string"  */
#line 2086 "Aql/grammar.y"
                    {
      auto const& resolver = parser->query().resolver();
      (yyval.node) = parser->ast()->createNodeCollection(resolver, (yyvsp[0].strval).value, (yyvsp[0].strval).length, arangodb::AccessMode::Type::WRITE);
    }
#line 5108 "Aql/grammar.cpp"
    break;

  case 245: /* in_or_into_collection_name: "bind data source parameter"  */
#line 2090 "Aql/grammar.y"
                            {
      if ((yyvsp[0].strval).length < 2 || (yyvsp[0].strval).value[0] != '@') {
        parser->registerParseError(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE, TRI_errno_string(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE).data(), (yyvsp[0].strval).value, yylloc.first_line, yylloc.first_column);
      }

      (yyval.node) = parser->ast()->createNodeParameterDatasource((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 5120 "Aql/grammar.cpp"
    break;

  case 246: /* bind_parameter: "bind data source parameter"  */
#line 2100 "Aql/grammar.y"
                            {
      if ((yyvsp[0].strval).length < 2 || (yyvsp[0].strval).value[0] != '@') {
        parser->registerParseError(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE, TRI_errno_string(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE).data(), (yyvsp[0].strval).value, yylloc.first_line, yylloc.first_column);
      }

      (yyval.node) = parser->ast()->createNodeParameterDatasource((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 5132 "Aql/grammar.cpp"
    break;

  case 247: /* bind_parameter: "bind parameter"  */
#line 2107 "Aql/grammar.y"
                {
      (yyval.node) = parser->ast()->createNodeParameter((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 5140 "Aql/grammar.cpp"
    break;

  case 248: /* bind_parameter_datasource_expected: "bind data source parameter"  */
#line 2113 "Aql/grammar.y"
                            {
      if ((yyvsp[0].strval).length < 2 || (yyvsp[0].strval).value[0] != '@') {
        parser->registerParseError(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE, TRI_errno_string(TRI_ERROR_QUERY_BIND_PARAMETER_TYPE).data(), (yyvsp[0].strval).value, yylloc.first_line, yylloc.first_column);
      }

      (yyval.node) = parser->ast()->createNodeParameterDatasource((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 5152 "Aql/grammar.cpp"
    break;

  case 249: /* bind_parameter_datasource_expected: "bind parameter"  */
#line 2120 "Aql/grammar.y"
                {
      (yyval.node) = parser->ast()->createNodeParameterDatasource((yyvsp[0].strval).value, (yyvsp[0].strval).length);
    }
#line 5160 "Aql/grammar.cpp"
    break;

  case 250: /* object_element_name: "identifier"  */
#line 2126 "Aql/grammar.y"
             {
      (yyval.strval) = (yyvsp[0].strval);
    }
#line 5168 "Aql/grammar.cpp"
    break;

  case 251: /* object_element_name: "quoted string"  */
#line 2129 "Aql/grammar.y"
                    {
      (yyval.strval) = (yyvsp[0].strval);
    }
#line 5176 "Aql/grammar.cpp"
    break;

  case 252: /* variable_name: "identifier"  */
#line 2134 "Aql/grammar.y"
             {
      (yyval.strval) = (yyvsp[0].strval);
    }
#line 5184 "Aql/grammar.cpp"
    break;


#line 5188 "Aql/grammar.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, parser, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          goto yyexhaustedlab;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= T_END)
        {
          /* Return failure if at end of input.  */
          if (yychar == T_END)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, parser);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, parser);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if 1
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, parser, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;
#endif


/*-------------------------------------------------------.
| yyreturn -- parsing is finished, clean up and return.  |
`-------------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, parser);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, parser);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

