////////////////////////////////////////////////////////////////////////////////
/// DISCLAIMER
///
/// Copyright 2014-2020 ArangoDB GmbH, Cologne, Germany
/// Copyright 2004-2014 triAGENS GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is ArangoDB GmbH, Cologne, Germany
///
/// @author Max Neunhoeffer
/// @author Jan Steemann
////////////////////////////////////////////////////////////////////////////////

#ifndef VELOCYPACK_SLICE_STATIC_DATA_H
#define VELOCYPACK_SLICE_STATIC_DATA_H 1

#include <cstdint>

#include "velocypack/velocypack-common.h"
#include "velocypack/ValueType.h"

namespace arangodb {
namespace velocypack {

struct SliceStaticData {
  using VT = arangodb::velocypack::ValueType;

  static constexpr uint8_t FixedTypeLengths[256] = {
    /* 0x00 */ 1,                    /* 0x01 */ 1,
    /* 0x02 */ 0,                    /* 0x03 */ 0,
    /* 0x04 */ 0,                    /* 0x05 */ 0,
    /* 0x06 */ 0,                    /* 0x07 */ 0,
    /* 0x08 */ 0,                    /* 0x09 */ 0,
    /* 0x0a */ 1,                    /* 0x0b */ 0,
    /* 0x0c */ 0,                    /* 0x0d */ 0,
    /* 0x0e */ 0,                    /* 0x0f */ 0,
    /* 0x10 */ 0,                    /* 0x11 */ 0,
    /* 0x12 */ 0,                    /* 0x13 */ 0,
    /* 0x14 */ 0,                    /* 0x15 */ 0,
    /* 0x16 */ 0,                    /* 0x17 */ 1,
    /* 0x18 */ 1,                    /* 0x19 */ 1,
    /* 0x1a */ 1,                    /* 0x1b */ 1 + sizeof(double),
    /* 0x1c */ 1 + sizeof(int64_t),  /* 0x1d */ 1 + sizeof(char*), 
    /* 0x1e */ 1,                    /* 0x1f */ 1,
    /* 0x20 */ 2,                    /* 0x21 */ 3,
    /* 0x22 */ 4,                    /* 0x23 */ 5,
    /* 0x24 */ 6,                    /* 0x25 */ 7,
    /* 0x26 */ 8,                    /* 0x27 */ 9,
    /* 0x28 */ 2,                    /* 0x29 */ 3,
    /* 0x2a */ 4,                    /* 0x2b */ 5,
    /* 0x2c */ 6,                    /* 0x2d */ 7,
    /* 0x2e */ 8,                    /* 0x2f */ 9,
    /* 0x30 */ 1,                    /* 0x31 */ 1,
    /* 0x32 */ 1,                    /* 0x33 */ 1,
    /* 0x34 */ 1,                    /* 0x35 */ 1,
    /* 0x36 */ 1,                    /* 0x37 */ 1,
    /* 0x38 */ 1,                    /* 0x39 */ 1,
    /* 0x3a */ 1,                    /* 0x3b */ 1,
    /* 0x3c */ 1,                    /* 0x3d */ 1,
    /* 0x3e */ 1,                    /* 0x3f */ 1,
    /* 0x40 */ 1,                    /* 0x41 */ 2,
    /* 0x42 */ 3,                    /* 0x43 */ 4,
    /* 0x44 */ 5,                    /* 0x45 */ 6,
    /* 0x46 */ 7,                    /* 0x47 */ 8,
    /* 0x48 */ 9,                    /* 0x49 */ 10,
    /* 0x4a */ 11,                   /* 0x4b */ 12,
    /* 0x4c */ 13,                   /* 0x4d */ 14,
    /* 0x4e */ 15,                   /* 0x4f */ 16,
    /* 0x50 */ 17,                   /* 0x51 */ 18,
    /* 0x52 */ 19,                   /* 0x53 */ 20,
    /* 0x54 */ 21,                   /* 0x55 */ 22,
    /* 0x56 */ 23,                   /* 0x57 */ 24,
    /* 0x58 */ 25,                   /* 0x59 */ 26,
    /* 0x5a */ 27,                   /* 0x5b */ 28,
    /* 0x5c */ 29,                   /* 0x5d */ 30,
    /* 0x5e */ 31,                   /* 0x5f */ 32,
    /* 0x60 */ 33,                   /* 0x61 */ 34,
    /* 0x62 */ 35,                   /* 0x63 */ 36,
    /* 0x64 */ 37,                   /* 0x65 */ 38,
    /* 0x66 */ 39,                   /* 0x67 */ 40,
    /* 0x68 */ 41,                   /* 0x69 */ 42,
    /* 0x6a */ 43,                   /* 0x6b */ 44,
    /* 0x6c */ 45,                   /* 0x6d */ 46,
    /* 0x6e */ 47,                   /* 0x6f */ 48,
    /* 0x70 */ 49,                   /* 0x71 */ 50,
    /* 0x72 */ 51,                   /* 0x73 */ 52,
    /* 0x74 */ 53,                   /* 0x75 */ 54,
    /* 0x76 */ 55,                   /* 0x77 */ 56,
    /* 0x78 */ 57,                   /* 0x79 */ 58,
    /* 0x7a */ 59,                   /* 0x7b */ 60,
    /* 0x7c */ 61,                   /* 0x7d */ 62,
    /* 0x7e */ 63,                   /* 0x7f */ 64,
    /* 0x80 */ 65,                   /* 0x81 */ 66,
    /* 0x82 */ 67,                   /* 0x83 */ 68,
    /* 0x84 */ 69,                   /* 0x85 */ 70,
    /* 0x86 */ 71,                   /* 0x87 */ 72,
    /* 0x88 */ 73,                   /* 0x89 */ 74,
    /* 0x8a */ 75,                   /* 0x8b */ 76,
    /* 0x8c */ 77,                   /* 0x8d */ 78,
    /* 0x8e */ 79,                   /* 0x8f */ 80,
    /* 0x90 */ 81,                   /* 0x91 */ 82,
    /* 0x92 */ 83,                   /* 0x93 */ 84,
    /* 0x94 */ 85,                   /* 0x95 */ 86,
    /* 0x96 */ 87,                   /* 0x97 */ 88,
    /* 0x98 */ 89,                   /* 0x99 */ 90,
    /* 0x9a */ 91,                   /* 0x9b */ 92,
    /* 0x9c */ 93,                   /* 0x9d */ 94,
    /* 0x9e */ 95,                   /* 0x9f */ 96,
    /* 0xa0 */ 97,                   /* 0xa1 */ 98,
    /* 0xa2 */ 99,                   /* 0xa3 */ 100,
    /* 0xa4 */ 101,                  /* 0xa5 */ 102,
    /* 0xa6 */ 103,                  /* 0xa7 */ 104,
    /* 0xa8 */ 105,                  /* 0xa9 */ 106,
    /* 0xaa */ 107,                  /* 0xab */ 108,
    /* 0xac */ 109,                  /* 0xad */ 110,
    /* 0xae */ 111,                  /* 0xaf */ 112,
    /* 0xb0 */ 113,                  /* 0xb1 */ 114,
    /* 0xb2 */ 115,                  /* 0xb3 */ 116,
    /* 0xb4 */ 117,                  /* 0xb5 */ 118,
    /* 0xb6 */ 119,                  /* 0xb7 */ 120,
    /* 0xb8 */ 121,                  /* 0xb9 */ 122,
    /* 0xba */ 123,                  /* 0xbb */ 124,
    /* 0xbc */ 125,                  /* 0xbd */ 126,
    /* 0xbe */ 127,                  /* 0xbf */ 0,
    /* 0xc0 */ 0,                    /* 0xc1 */ 0,
    /* 0xc2 */ 0,                    /* 0xc3 */ 0,
    /* 0xc4 */ 0,                    /* 0xc5 */ 0,
    /* 0xc6 */ 0,                    /* 0xc7 */ 0,
    /* 0xc8 */ 0,                    /* 0xc9 */ 0,        
    /* 0xca */ 0,                    /* 0xcb */ 0,        
    /* 0xcc */ 0,                    /* 0xcd */ 0,        
    /* 0xce */ 0,                    /* 0xcf */ 0,        
    /* 0xd0 */ 0,                    /* 0xd1 */ 0,        
    /* 0xd2 */ 0,                    /* 0xd3 */ 0,        
    /* 0xd4 */ 0,                    /* 0xd5 */ 0,        
    /* 0xd6 */ 0,                    /* 0xd7 */ 0,        
    /* 0xd8 */ 0,                    /* 0xd9 */ 0,       
    /* 0xda */ 0,                    /* 0xdb */ 0,       
    /* 0xdc */ 0,                    /* 0xdd */ 0,       
    /* 0xde */ 0,                    /* 0xdf */ 0,       
    /* 0xe0 */ 0,                    /* 0xe1 */ 0,       
    /* 0xe2 */ 0,                    /* 0xe3 */ 0,       
    /* 0xe4 */ 0,                    /* 0xe5 */ 0,       
    /* 0xe6 */ 0,                    /* 0xe7 */ 0,       
    /* 0xe8 */ 0,                    /* 0xe9 */ 0,       
    /* 0xea */ 0,                    /* 0xeb */ 0,       
    /* 0xec */ 0,                    /* 0xed */ 0,       
    /* 0xee */ 0,                    /* 0xef */ 0,       
    /* 0xf0 */ 2,                    /* 0xf1 */ 3,
    /* 0xf2 */ 5,                    /* 0xf3 */ 9,
    /* 0xf4 */ 0,                    /* 0xf5 */ 0,
    /* 0xf6 */ 0,                    /* 0xf7 */ 0,
    /* 0xf8 */ 0,                    /* 0xf9 */ 0,
    /* 0xfa */ 0,                    /* 0xfb */ 0,
    /* 0xfc */ 0,                    /* 0xfd */ 0,
    /* 0xfe */ 0,                    /* 0xff */ 0
  };

  static constexpr ValueType TypeMap[256] = {
    /* 0x00 */ VT::None,     /* 0x01 */ VT::Array,
    /* 0x02 */ VT::Array,    /* 0x03 */ VT::Array,
    /* 0x04 */ VT::Array,    /* 0x05 */ VT::Array,
    /* 0x06 */ VT::Array,    /* 0x07 */ VT::Array,
    /* 0x08 */ VT::Array,    /* 0x09 */ VT::Array,
    /* 0x0a */ VT::Object,   /* 0x0b */ VT::Object,
    /* 0x0c */ VT::Object,   /* 0x0d */ VT::Object,
    /* 0x0e */ VT::Object,   /* 0x0f */ VT::Object,
    /* 0x10 */ VT::Object,   /* 0x11 */ VT::Object,
    /* 0x12 */ VT::Object,   /* 0x13 */ VT::Array,
    /* 0x14 */ VT::Object,   /* 0x15 */ VT::None,
    /* 0x16 */ VT::None,     /* 0x17 */ VT::Illegal,
    /* 0x18 */ VT::Null,     /* 0x19 */ VT::Bool,
    /* 0x1a */ VT::Bool,     /* 0x1b */ VT::Double,
    /* 0x1c */ VT::UTCDate,  /* 0x1d */ VT::External,
    /* 0x1e */ VT::MinKey,   /* 0x1f */ VT::MaxKey,
    /* 0x20 */ VT::Int,      /* 0x21 */ VT::Int,
    /* 0x22 */ VT::Int,      /* 0x23 */ VT::Int,
    /* 0x24 */ VT::Int,      /* 0x25 */ VT::Int,
    /* 0x26 */ VT::Int,      /* 0x27 */ VT::Int,
    /* 0x28 */ VT::UInt,     /* 0x29 */ VT::UInt,
    /* 0x2a */ VT::UInt,     /* 0x2b */ VT::UInt,
    /* 0x2c */ VT::UInt,     /* 0x2d */ VT::UInt,
    /* 0x2e */ VT::UInt,     /* 0x2f */ VT::UInt,
    /* 0x30 */ VT::SmallInt, /* 0x31 */ VT::SmallInt,
    /* 0x32 */ VT::SmallInt, /* 0x33 */ VT::SmallInt,
    /* 0x34 */ VT::SmallInt, /* 0x35 */ VT::SmallInt,
    /* 0x36 */ VT::SmallInt, /* 0x37 */ VT::SmallInt,
    /* 0x38 */ VT::SmallInt, /* 0x39 */ VT::SmallInt,
    /* 0x3a */ VT::SmallInt, /* 0x3b */ VT::SmallInt,
    /* 0x3c */ VT::SmallInt, /* 0x3d */ VT::SmallInt,
    /* 0x3e */ VT::SmallInt, /* 0x3f */ VT::SmallInt,
    /* 0x40 */ VT::String,   /* 0x41 */ VT::String,
    /* 0x42 */ VT::String,   /* 0x43 */ VT::String,
    /* 0x44 */ VT::String,   /* 0x45 */ VT::String,
    /* 0x46 */ VT::String,   /* 0x47 */ VT::String,
    /* 0x48 */ VT::String,   /* 0x49 */ VT::String,
    /* 0x4a */ VT::String,   /* 0x4b */ VT::String,
    /* 0x4c */ VT::String,   /* 0x4d */ VT::String,
    /* 0x4e */ VT::String,   /* 0x4f */ VT::String,
    /* 0x50 */ VT::String,   /* 0x51 */ VT::String,
    /* 0x52 */ VT::String,   /* 0x53 */ VT::String,
    /* 0x54 */ VT::String,   /* 0x55 */ VT::String,
    /* 0x56 */ VT::String,   /* 0x57 */ VT::String,
    /* 0x58 */ VT::String,   /* 0x59 */ VT::String,
    /* 0x5a */ VT::String,   /* 0x5b */ VT::String,
    /* 0x5c */ VT::String,   /* 0x5d */ VT::String,
    /* 0x5e */ VT::String,   /* 0x5f */ VT::String,
    /* 0x60 */ VT::String,   /* 0x61 */ VT::String,
    /* 0x62 */ VT::String,   /* 0x63 */ VT::String,
    /* 0x64 */ VT::String,   /* 0x65 */ VT::String,
    /* 0x66 */ VT::String,   /* 0x67 */ VT::String,
    /* 0x68 */ VT::String,   /* 0x69 */ VT::String,
    /* 0x6a */ VT::String,   /* 0x6b */ VT::String,
    /* 0x6c */ VT::String,   /* 0x6d */ VT::String,
    /* 0x6e */ VT::String,   /* 0x6f */ VT::String,
    /* 0x70 */ VT::String,   /* 0x71 */ VT::String,
    /* 0x72 */ VT::String,   /* 0x73 */ VT::String,
    /* 0x74 */ VT::String,   /* 0x75 */ VT::String,
    /* 0x76 */ VT::String,   /* 0x77 */ VT::String,
    /* 0x78 */ VT::String,   /* 0x79 */ VT::String,
    /* 0x7a */ VT::String,   /* 0x7b */ VT::String,
    /* 0x7c */ VT::String,   /* 0x7d */ VT::String,
    /* 0x7e */ VT::String,   /* 0x7f */ VT::String,
    /* 0x80 */ VT::String,   /* 0x81 */ VT::String,
    /* 0x82 */ VT::String,   /* 0x83 */ VT::String,
    /* 0x84 */ VT::String,   /* 0x85 */ VT::String,
    /* 0x86 */ VT::String,   /* 0x87 */ VT::String,
    /* 0x88 */ VT::String,   /* 0x89 */ VT::String,
    /* 0x8a */ VT::String,   /* 0x8b */ VT::String,
    /* 0x8c */ VT::String,   /* 0x8d */ VT::String,
    /* 0x8e */ VT::String,   /* 0x8f */ VT::String,
    /* 0x90 */ VT::String,   /* 0x91 */ VT::String,
    /* 0x92 */ VT::String,   /* 0x93 */ VT::String,
    /* 0x94 */ VT::String,   /* 0x95 */ VT::String,
    /* 0x96 */ VT::String,   /* 0x97 */ VT::String,
    /* 0x98 */ VT::String,   /* 0x99 */ VT::String,
    /* 0x9a */ VT::String,   /* 0x9b */ VT::String,
    /* 0x9c */ VT::String,   /* 0x9d */ VT::String,
    /* 0x9e */ VT::String,   /* 0x9f */ VT::String,
    /* 0xa0 */ VT::String,   /* 0xa1 */ VT::String,
    /* 0xa2 */ VT::String,   /* 0xa3 */ VT::String,
    /* 0xa4 */ VT::String,   /* 0xa5 */ VT::String,
    /* 0xa6 */ VT::String,   /* 0xa7 */ VT::String,
    /* 0xa8 */ VT::String,   /* 0xa9 */ VT::String,
    /* 0xaa */ VT::String,   /* 0xab */ VT::String,
    /* 0xac */ VT::String,   /* 0xad */ VT::String,
    /* 0xae */ VT::String,   /* 0xaf */ VT::String,
    /* 0xb0 */ VT::String,   /* 0xb1 */ VT::String,
    /* 0xb2 */ VT::String,   /* 0xb3 */ VT::String,
    /* 0xb4 */ VT::String,   /* 0xb5 */ VT::String,
    /* 0xb6 */ VT::String,   /* 0xb7 */ VT::String,
    /* 0xb8 */ VT::String,   /* 0xb9 */ VT::String,
    /* 0xba */ VT::String,   /* 0xbb */ VT::String,
    /* 0xbc */ VT::String,   /* 0xbd */ VT::String,
    /* 0xbe */ VT::String,   /* 0xbf */ VT::String,
    /* 0xc0 */ VT::Binary,   /* 0xc1 */ VT::Binary,
    /* 0xc2 */ VT::Binary,   /* 0xc3 */ VT::Binary,
    /* 0xc4 */ VT::Binary,   /* 0xc5 */ VT::Binary,
    /* 0xc6 */ VT::Binary,   /* 0xc7 */ VT::Binary,
    /* 0xc8 */ VT::BCD,      /* 0xc9 */ VT::BCD,
    /* 0xca */ VT::BCD,      /* 0xcb */ VT::BCD,
    /* 0xcc */ VT::BCD,      /* 0xcd */ VT::BCD,
    /* 0xce */ VT::BCD,      /* 0xcf */ VT::BCD,
    /* 0xd0 */ VT::BCD,      /* 0xd1 */ VT::BCD,
    /* 0xd2 */ VT::BCD,      /* 0xd3 */ VT::BCD,
    /* 0xd4 */ VT::BCD,      /* 0xd5 */ VT::BCD,
    /* 0xd6 */ VT::BCD,      /* 0xd7 */ VT::BCD,
    /* 0xd8 */ VT::None,     /* 0xd9 */ VT::None,
    /* 0xda */ VT::None,     /* 0xdb */ VT::None,
    /* 0xdc */ VT::None,     /* 0xdd */ VT::None,
    /* 0xde */ VT::None,     /* 0xdf */ VT::None,
    /* 0xe0 */ VT::None,     /* 0xe1 */ VT::None,
    /* 0xe2 */ VT::None,     /* 0xe3 */ VT::None,
    /* 0xe4 */ VT::None,     /* 0xe5 */ VT::None,
    /* 0xe6 */ VT::None,     /* 0xe7 */ VT::None,
    /* 0xe8 */ VT::None,     /* 0xe9 */ VT::None,
    /* 0xea */ VT::None,     /* 0xeb */ VT::None,
    /* 0xec */ VT::None,     /* 0xed */ VT::None,
    /* 0xee */ VT::Tagged,   /* 0xef */ VT::Tagged,
    /* 0xf0 */ VT::Custom,   /* 0xf1 */ VT::Custom,
    /* 0xf2 */ VT::Custom,   /* 0xf3 */ VT::Custom,
    /* 0xf4 */ VT::Custom,   /* 0xf5 */ VT::Custom,
    /* 0xf6 */ VT::Custom,   /* 0xf7 */ VT::Custom,
    /* 0xf8 */ VT::Custom,   /* 0xf9 */ VT::Custom,
    /* 0xfa */ VT::Custom,   /* 0xfb */ VT::Custom,
    /* 0xfc */ VT::Custom,   /* 0xfd */ VT::Custom,
    /* 0xfe */ VT::Custom,   /* 0xff */ VT::Custom
  };

  static constexpr unsigned int WidthMap[32] = {
    0,  // 0x00, None
    1,  // 0x01, empty array
    1,  // 0x02, array without index table
    2,  // 0x03, array without index table
    4,  // 0x04, array without index table
    8,  // 0x05, array without index table
    1,  // 0x06, array with index table
    2,  // 0x07, array with index table
    4,  // 0x08, array with index table
    8,  // 0x09, array with index table
    1,  // 0x0a, empty object
    1,  // 0x0b, object with sorted index table
    2,  // 0x0c, object with sorted index table
    4,  // 0x0d, object with sorted index table
    8,  // 0x0e, object with sorted index table
    1,  // 0x0f, object with unsorted index table
    2,  // 0x10, object with unsorted index table
    4,  // 0x11, object with unsorted index table
    8,  // 0x12, object with unsorted index table
    0
  };

  static constexpr unsigned int FirstSubMap[32] = {
    0,  // 0x00, None
    1,  // 0x01, empty array
    2,  // 0x02, array without index table
    3,  // 0x03, array without index table
    5,  // 0x04, array without index table
    9,  // 0x05, array without index table
    3,  // 0x06, array with index table
    5,  // 0x07, array with index table
    9,  // 0x08, array with index table
    9,  // 0x09, array with index table
    1,  // 0x0a, empty object
    3,  // 0x0b, object with sorted index table
    5,  // 0x0c, object with sorted index table
    9,  // 0x0d, object with sorted index table
    9,  // 0x0e, object with sorted index table
    3,  // 0x0f, object with unsorted index table
    5,  // 0x10, object with unsorted index table
    9,  // 0x11, object with unsorted index table
    9,  // 0x12, object with unsorted index table,
    0,  // 0x13, compact array, no index table - note: the offset is dynamic!
    0,  // 0x14, compact object, no index table - note: the offset is dynamic!
    0
  };

  static constexpr uint64_t PrecalculatedHashesForDefaultSeed[256] = {
#ifdef VELOCYPACK_XXHASH
    /* 0x00 */ 0xe2b56fa571b3a544,    /* 0x01 */ 0xda3cfd1dc58389d8,
    /* 0x02 */ 0x0000000000000000,    /* 0x03 */ 0x0000000000000000,
    /* 0x04 */ 0x0000000000000000,    /* 0x05 */ 0x0000000000000000,
    /* 0x06 */ 0x0000000000000000,    /* 0x07 */ 0x0000000000000000,
    /* 0x08 */ 0x0000000000000000,    /* 0x09 */ 0x0000000000000000,
    /* 0x0a */ 0xd296bf393ef8d5f5,    /* 0x0b */ 0x0000000000000000,
    /* 0x0c */ 0x0000000000000000,    /* 0x0d */ 0x0000000000000000,
    /* 0x0e */ 0x0000000000000000,    /* 0x0f */ 0x0000000000000000,
    /* 0x10 */ 0x0000000000000000,    /* 0x11 */ 0x0000000000000000,
    /* 0x12 */ 0x0000000000000000,    /* 0x13 */ 0x0000000000000000,
    /* 0x14 */ 0x0000000000000000,    /* 0x15 */ 0x0000000000000000,
    /* 0x16 */ 0x0000000000000000,    /* 0x17 */ 0x24db76da0ebbd8bb,
    /* 0x18 */ 0x1a6a668fb2aa030a,    /* 0x19 */ 0xed545328fb397fed,
    /* 0x1a */ 0xfd783491fceeb46b,    /* 0x1b */ 0x0000000000000000,
    /* 0x1c */ 0x0000000000000000,    /* 0x1d */ 0x0000000000000000,
    /* 0x1e */ 0x505ec293ddfeec5e,    /* 0x1f */ 0x9fab26ba108e2fbf,
    /* 0x20 */ 0x0000000000000000,    /* 0x21 */ 0x0000000000000000,
    /* 0x22 */ 0x0000000000000000,    /* 0x23 */ 0x0000000000000000,
    /* 0x24 */ 0x0000000000000000,    /* 0x25 */ 0x0000000000000000,
    /* 0x26 */ 0x0000000000000000,    /* 0x27 */ 0x0000000000000000,
    /* 0x28 */ 0x0000000000000000,    /* 0x29 */ 0x0000000000000000,
    /* 0x2a */ 0x0000000000000000,    /* 0x2b */ 0x0000000000000000,
    /* 0x2c */ 0x0000000000000000,    /* 0x2d */ 0x0000000000000000,
    /* 0x2e */ 0x0000000000000000,    /* 0x2f */ 0x0000000000000000,
    /* 0x30 */ 0xcdf3868203041650,    /* 0x31 */ 0x7c9133bfa6f828a6,
    /* 0x32 */ 0x62e05b34c4ed7ce4,    /* 0x33 */ 0xb79b6530d263533d,
    /* 0x34 */ 0xf05f611558114f31,    /* 0x35 */ 0xc941f9afc86cdcd5,
    /* 0x36 */ 0x79873ccd694a9f90,    /* 0x37 */ 0xd360268d66bf8c1f,
    /* 0x38 */ 0x19e870f3e36185fe,    /* 0x39 */ 0xd154aeb6ba9114e5,
    /* 0x3a */ 0xa4d6434557b5b885,    /* 0x3b */ 0x91584221ca9eda5b,
    /* 0x3c */ 0xb39b55e7252de481,    /* 0x3d */ 0xe6bf494f0a40618e,
    /* 0x3e */ 0xd2ce603b7dceb6ea,    /* 0x3f */ 0xec71f69fe56368f1,
    /* 0x40 */ 0x142191d3f9a23bce,    /* 0x41 */ 0x0000000000000000,
    /* 0x42 */ 0x0000000000000000,    /* 0x43 */ 0x0000000000000000,
    /* 0x44 */ 0x0000000000000000,    /* 0x45 */ 0x0000000000000000,
    /* 0x46 */ 0x0000000000000000,    /* 0x47 */ 0x0000000000000000,
    /* 0x48 */ 0x0000000000000000,    /* 0x49 */ 0x0000000000000000,
    /* 0x4a */ 0x0000000000000000,    /* 0x4b */ 0x0000000000000000,
    /* 0x4c */ 0x0000000000000000,    /* 0x4d */ 0x0000000000000000,
    /* 0x4e */ 0x0000000000000000,    /* 0x4f */ 0x0000000000000000,
    /* 0x50 */ 0x0000000000000000,    /* 0x51 */ 0x0000000000000000,
    /* 0x52 */ 0x0000000000000000,    /* 0x53 */ 0x0000000000000000,
    /* 0x54 */ 0x0000000000000000,    /* 0x55 */ 0x0000000000000000,
    /* 0x56 */ 0x0000000000000000,    /* 0x57 */ 0x0000000000000000,
    /* 0x58 */ 0x0000000000000000,    /* 0x59 */ 0x0000000000000000,
    /* 0x5a */ 0x0000000000000000,    /* 0x5b */ 0x0000000000000000,
    /* 0x5c */ 0x0000000000000000,    /* 0x5d */ 0x0000000000000000,
    /* 0x5e */ 0x0000000000000000,    /* 0x5f */ 0x0000000000000000,
    /* 0x60 */ 0x0000000000000000,    /* 0x61 */ 0x0000000000000000,
    /* 0x62 */ 0x0000000000000000,    /* 0x63 */ 0x0000000000000000,
    /* 0x64 */ 0x0000000000000000,    /* 0x65 */ 0x0000000000000000,
    /* 0x66 */ 0x0000000000000000,    /* 0x67 */ 0x0000000000000000,
    /* 0x68 */ 0x0000000000000000,    /* 0x69 */ 0x0000000000000000,
    /* 0x6a */ 0x0000000000000000,    /* 0x6b */ 0x0000000000000000,
    /* 0x6c */ 0x0000000000000000,    /* 0x6d */ 0x0000000000000000,
    /* 0x6e */ 0x0000000000000000,    /* 0x6f */ 0x0000000000000000,
    /* 0x70 */ 0x0000000000000000,    /* 0x71 */ 0x0000000000000000,
    /* 0x72 */ 0x0000000000000000,    /* 0x73 */ 0x0000000000000000,
    /* 0x74 */ 0x0000000000000000,    /* 0x75 */ 0x0000000000000000,
    /* 0x76 */ 0x0000000000000000,    /* 0x77 */ 0x0000000000000000,
    /* 0x78 */ 0x0000000000000000,    /* 0x79 */ 0x0000000000000000,
    /* 0x7a */ 0x0000000000000000,    /* 0x7b */ 0x0000000000000000,
    /* 0x7c */ 0x0000000000000000,    /* 0x7d */ 0x0000000000000000,
    /* 0x7e */ 0x0000000000000000,    /* 0x7f */ 0x0000000000000000,
    /* 0x80 */ 0x0000000000000000,    /* 0x81 */ 0x0000000000000000,
    /* 0x82 */ 0x0000000000000000,    /* 0x83 */ 0x0000000000000000,
    /* 0x84 */ 0x0000000000000000,    /* 0x85 */ 0x0000000000000000,
    /* 0x86 */ 0x0000000000000000,    /* 0x87 */ 0x0000000000000000,
    /* 0x88 */ 0x0000000000000000,    /* 0x89 */ 0x0000000000000000,
    /* 0x8a */ 0x0000000000000000,    /* 0x8b */ 0x0000000000000000,
    /* 0x8c */ 0x0000000000000000,    /* 0x8d */ 0x0000000000000000,
    /* 0x8e */ 0x0000000000000000,    /* 0x8f */ 0x0000000000000000,
    /* 0x90 */ 0x0000000000000000,    /* 0x91 */ 0x0000000000000000,
    /* 0x92 */ 0x0000000000000000,    /* 0x93 */ 0x0000000000000000,
    /* 0x94 */ 0x0000000000000000,    /* 0x95 */ 0x0000000000000000,
    /* 0x96 */ 0x0000000000000000,    /* 0x97 */ 0x0000000000000000,
    /* 0x98 */ 0x0000000000000000,    /* 0x99 */ 0x0000000000000000,
    /* 0x9a */ 0x0000000000000000,    /* 0x9b */ 0x0000000000000000,
    /* 0x9c */ 0x0000000000000000,    /* 0x9d */ 0x0000000000000000,
    /* 0x9e */ 0x0000000000000000,    /* 0x9f */ 0x0000000000000000,
    /* 0xa0 */ 0x0000000000000000,    /* 0xa1 */ 0x0000000000000000,
    /* 0xa2 */ 0x0000000000000000,    /* 0xa3 */ 0x0000000000000000,
    /* 0xa4 */ 0x0000000000000000,    /* 0xa5 */ 0x0000000000000000,
    /* 0xa6 */ 0x0000000000000000,    /* 0xa7 */ 0x0000000000000000,
    /* 0xa8 */ 0x0000000000000000,    /* 0xa9 */ 0x0000000000000000,
    /* 0xaa */ 0x0000000000000000,    /* 0xab */ 0x0000000000000000,
    /* 0xac */ 0x0000000000000000,    /* 0xad */ 0x0000000000000000,
    /* 0xae */ 0x0000000000000000,    /* 0xaf */ 0x0000000000000000,
    /* 0xb0 */ 0x0000000000000000,    /* 0xb1 */ 0x0000000000000000,
    /* 0xb2 */ 0x0000000000000000,    /* 0xb3 */ 0x0000000000000000,
    /* 0xb4 */ 0x0000000000000000,    /* 0xb5 */ 0x0000000000000000,
    /* 0xb6 */ 0x0000000000000000,    /* 0xb7 */ 0x0000000000000000,
    /* 0xb8 */ 0x0000000000000000,    /* 0xb9 */ 0x0000000000000000,
    /* 0xba */ 0x0000000000000000,    /* 0xbb */ 0x0000000000000000,
    /* 0xbc */ 0x0000000000000000,    /* 0xbd */ 0x0000000000000000,
    /* 0xbe */ 0x0000000000000000,    /* 0xbf */ 0x0000000000000000,
    /* 0xc0 */ 0x0000000000000000,    /* 0xc1 */ 0x0000000000000000,
    /* 0xc2 */ 0x0000000000000000,    /* 0xc3 */ 0x0000000000000000,
    /* 0xc4 */ 0x0000000000000000,    /* 0xc5 */ 0x0000000000000000,
    /* 0xc6 */ 0x0000000000000000,    /* 0xc7 */ 0x0000000000000000,
    /* 0xc8 */ 0x0000000000000000,    /* 0xc9 */ 0x0000000000000000,
    /* 0xca */ 0x0000000000000000,    /* 0xcb */ 0x0000000000000000,
    /* 0xcc */ 0x0000000000000000,    /* 0xcd */ 0x0000000000000000,
    /* 0xce */ 0x0000000000000000,    /* 0xcf */ 0x0000000000000000,
    /* 0xd0 */ 0x0000000000000000,    /* 0xd1 */ 0x0000000000000000,
    /* 0xd2 */ 0x0000000000000000,    /* 0xd3 */ 0x0000000000000000,
    /* 0xd4 */ 0x0000000000000000,    /* 0xd5 */ 0x0000000000000000,
    /* 0xd6 */ 0x0000000000000000,    /* 0xd7 */ 0x0000000000000000,
    /* 0xd8 */ 0x0000000000000000,    /* 0xd9 */ 0x0000000000000000,
    /* 0xda */ 0x0000000000000000,    /* 0xdb */ 0x0000000000000000,
    /* 0xdc */ 0x0000000000000000,    /* 0xdd */ 0x0000000000000000,
    /* 0xde */ 0x0000000000000000,    /* 0xdf */ 0x0000000000000000,
    /* 0xe0 */ 0x0000000000000000,    /* 0xe1 */ 0x0000000000000000,
    /* 0xe2 */ 0x0000000000000000,    /* 0xe3 */ 0x0000000000000000,
    /* 0xe4 */ 0x0000000000000000,    /* 0xe5 */ 0x0000000000000000,
    /* 0xe6 */ 0x0000000000000000,    /* 0xe7 */ 0x0000000000000000,
    /* 0xe8 */ 0x0000000000000000,    /* 0xe9 */ 0x0000000000000000,
    /* 0xea */ 0x0000000000000000,    /* 0xeb */ 0x0000000000000000,
    /* 0xec */ 0x0000000000000000,    /* 0xed */ 0x0000000000000000,
    /* 0xee */ 0x0000000000000000,    /* 0xef */ 0x0000000000000000,
    /* 0xf0 */ 0x0000000000000000,    /* 0xf1 */ 0x0000000000000000,
    /* 0xf2 */ 0x0000000000000000,    /* 0xf3 */ 0x0000000000000000,
    /* 0xf4 */ 0x0000000000000000,    /* 0xf5 */ 0x0000000000000000,
    /* 0xf6 */ 0x0000000000000000,    /* 0xf7 */ 0x0000000000000000,
    /* 0xf8 */ 0x0000000000000000,    /* 0xf9 */ 0x0000000000000000,
    /* 0xfa */ 0x0000000000000000,    /* 0xfb */ 0x0000000000000000,
    /* 0xfc */ 0x0000000000000000,    /* 0xfd */ 0x0000000000000000,
    /* 0xfe */ 0x0000000000000000,    /* 0xff */ 0x0000000000000000
#endif
#ifdef VELOCYPACK_FASTHASH
    /* 0x00 */ 0xf747d9afd5fc13cd,    /* 0x01 */ 0x9dd59a0795d72dae,    
    /* 0x02 */ 0x0000000000000000,    /* 0x03 */ 0x0000000000000000,    
    /* 0x04 */ 0x0000000000000000,    /* 0x05 */ 0x0000000000000000,    
    /* 0x06 */ 0x0000000000000000,    /* 0x07 */ 0x0000000000000000,    
    /* 0x08 */ 0x0000000000000000,    /* 0x09 */ 0x0000000000000000,    
    /* 0x0a */ 0x651f231e0822a1f2,    /* 0x0b */ 0x0000000000000000,    
    /* 0x0c */ 0x0000000000000000,    /* 0x0d */ 0x0000000000000000,    
    /* 0x0e */ 0x0000000000000000,    /* 0x0f */ 0x0000000000000000,    
    /* 0x10 */ 0x0000000000000000,    /* 0x11 */ 0x0000000000000000,    
    /* 0x12 */ 0x0000000000000000,    /* 0x13 */ 0x0000000000000000,    
    /* 0x14 */ 0x0000000000000000,    /* 0x15 */ 0x0000000000000000,    
    /* 0x16 */ 0x0000000000000000,    /* 0x17 */ 0x423211fec79af09b,    
    /* 0x18 */ 0xd43a065f33b14e52,    /* 0x19 */ 0xf1adc756c139e443,    
    /* 0x1a */ 0x6bf229fb02c686b ,    /* 0x1b */ 0x0000000000000000,    
    /* 0x1c */ 0x0000000000000000,    /* 0x1d */ 0x0000000000000000,    
    /* 0x1e */ 0xc36f498e29ef2aba,    /* 0x1f */ 0x1ad28762083cdc7d,    
    /* 0x20 */ 0x0000000000000000,    /* 0x21 */ 0x0000000000000000,    
    /* 0x22 */ 0x0000000000000000,    /* 0x23 */ 0x0000000000000000,    
    /* 0x24 */ 0x0000000000000000,    /* 0x25 */ 0x0000000000000000,    
    /* 0x26 */ 0x0000000000000000,    /* 0x27 */ 0x0000000000000000,    
    /* 0x28 */ 0x0000000000000000,    /* 0x29 */ 0x0000000000000000,    
    /* 0x2a */ 0x0000000000000000,    /* 0x2b */ 0x0000000000000000,    
    /* 0x2c */ 0x0000000000000000,    /* 0x2d */ 0x0000000000000000,    
    /* 0x2e */ 0x0000000000000000,    /* 0x2f */ 0x0000000000000000,    
    /* 0x30 */ 0xbb1c99a88abf76d2,    /* 0x31 */ 0x8d3e0efdb932c4b8,    
    /* 0x32 */ 0xcd41672e3cd8f76e,    /* 0x33 */ 0x3f831eadbd6628f8,    
    /* 0x34 */ 0x9e4ea5d4abe810ae,    /* 0x35 */ 0x836489847293c2d6,    
    /* 0x36 */ 0x270883ef450bf1c8,    /* 0x37 */ 0x4abf5dea3bb7fb98,    
    /* 0x38 */ 0x5a6892806deadcb2,    /* 0x39 */ 0xdeaa9c7264ffdad0,    
    /* 0x3a */ 0xabd49df61b8b4756,    /* 0x3b */ 0xc068ab004a6dc8de,    
    /* 0x3c */ 0xc2a9f41025e2711b,    /* 0x3d */ 0x47cb9c887443ad40,    
    /* 0x3e */ 0xa57497643e705316,    /* 0x3f */ 0xea4688cdf868a142,    
    /* 0x40 */ 0x49e51044202c2999,    /* 0x41 */ 0x0000000000000000,    
    /* 0x42 */ 0x0000000000000000,    /* 0x43 */ 0x0000000000000000,    
    /* 0x44 */ 0x0000000000000000,    /* 0x45 */ 0x0000000000000000,    
    /* 0x46 */ 0x0000000000000000,    /* 0x47 */ 0x0000000000000000,    
    /* 0x48 */ 0x0000000000000000,    /* 0x49 */ 0x0000000000000000,    
    /* 0x4a */ 0x0000000000000000,    /* 0x4b */ 0x0000000000000000,    
    /* 0x4c */ 0x0000000000000000,    /* 0x4d */ 0x0000000000000000,    
    /* 0x4e */ 0x0000000000000000,    /* 0x4f */ 0x0000000000000000,    
    /* 0x50 */ 0x0000000000000000,    /* 0x51 */ 0x0000000000000000,    
    /* 0x52 */ 0x0000000000000000,    /* 0x53 */ 0x0000000000000000,    
    /* 0x54 */ 0x0000000000000000,    /* 0x55 */ 0x0000000000000000,    
    /* 0x56 */ 0x0000000000000000,    /* 0x57 */ 0x0000000000000000,    
    /* 0x58 */ 0x0000000000000000,    /* 0x59 */ 0x0000000000000000,    
    /* 0x5a */ 0x0000000000000000,    /* 0x5b */ 0x0000000000000000,    
    /* 0x5c */ 0x0000000000000000,    /* 0x5d */ 0x0000000000000000,    
    /* 0x5e */ 0x0000000000000000,    /* 0x5f */ 0x0000000000000000,    
    /* 0x60 */ 0x0000000000000000,    /* 0x61 */ 0x0000000000000000,    
    /* 0x62 */ 0x0000000000000000,    /* 0x63 */ 0x0000000000000000,    
    /* 0x64 */ 0x0000000000000000,    /* 0x65 */ 0x0000000000000000,    
    /* 0x66 */ 0x0000000000000000,    /* 0x67 */ 0x0000000000000000,    
    /* 0x68 */ 0x0000000000000000,    /* 0x69 */ 0x0000000000000000,    
    /* 0x6a */ 0x0000000000000000,    /* 0x6b */ 0x0000000000000000,    
    /* 0x6c */ 0x0000000000000000,    /* 0x6d */ 0x0000000000000000,    
    /* 0x6e */ 0x0000000000000000,    /* 0x6f */ 0x0000000000000000,    
    /* 0x70 */ 0x0000000000000000,    /* 0x71 */ 0x0000000000000000,    
    /* 0x72 */ 0x0000000000000000,    /* 0x73 */ 0x0000000000000000,    
    /* 0x74 */ 0x0000000000000000,    /* 0x75 */ 0x0000000000000000,    
    /* 0x76 */ 0x0000000000000000,    /* 0x77 */ 0x0000000000000000,    
    /* 0x78 */ 0x0000000000000000,    /* 0x79 */ 0x0000000000000000,    
    /* 0x7a */ 0x0000000000000000,    /* 0x7b */ 0x0000000000000000,    
    /* 0x7c */ 0x0000000000000000,    /* 0x7d */ 0x0000000000000000,    
    /* 0x7e */ 0x0000000000000000,    /* 0x7f */ 0x0000000000000000,    
    /* 0x80 */ 0x0000000000000000,    /* 0x81 */ 0x0000000000000000,    
    /* 0x82 */ 0x0000000000000000,    /* 0x83 */ 0x0000000000000000,    
    /* 0x84 */ 0x0000000000000000,    /* 0x85 */ 0x0000000000000000,    
    /* 0x86 */ 0x0000000000000000,    /* 0x87 */ 0x0000000000000000,    
    /* 0x88 */ 0x0000000000000000,    /* 0x89 */ 0x0000000000000000,    
    /* 0x8a */ 0x0000000000000000,    /* 0x8b */ 0x0000000000000000,    
    /* 0x8c */ 0x0000000000000000,    /* 0x8d */ 0x0000000000000000,    
    /* 0x8e */ 0x0000000000000000,    /* 0x8f */ 0x0000000000000000,    
    /* 0x90 */ 0x0000000000000000,    /* 0x91 */ 0x0000000000000000,    
    /* 0x92 */ 0x0000000000000000,    /* 0x93 */ 0x0000000000000000,    
    /* 0x94 */ 0x0000000000000000,    /* 0x95 */ 0x0000000000000000,    
    /* 0x96 */ 0x0000000000000000,    /* 0x97 */ 0x0000000000000000,    
    /* 0x98 */ 0x0000000000000000,    /* 0x99 */ 0x0000000000000000,    
    /* 0x9a */ 0x0000000000000000,    /* 0x9b */ 0x0000000000000000,    
    /* 0x9c */ 0x0000000000000000,    /* 0x9d */ 0x0000000000000000,    
    /* 0x9e */ 0x0000000000000000,    /* 0x9f */ 0x0000000000000000,    
    /* 0xa0 */ 0x0000000000000000,    /* 0xa1 */ 0x0000000000000000,    
    /* 0xa2 */ 0x0000000000000000,    /* 0xa3 */ 0x0000000000000000,    
    /* 0xa4 */ 0x0000000000000000,    /* 0xa5 */ 0x0000000000000000,    
    /* 0xa6 */ 0x0000000000000000,    /* 0xa7 */ 0x0000000000000000,    
    /* 0xa8 */ 0x0000000000000000,    /* 0xa9 */ 0x0000000000000000,    
    /* 0xaa */ 0x0000000000000000,    /* 0xab */ 0x0000000000000000,    
    /* 0xac */ 0x0000000000000000,    /* 0xad */ 0x0000000000000000,    
    /* 0xae */ 0x0000000000000000,    /* 0xaf */ 0x0000000000000000,    
    /* 0xb0 */ 0x0000000000000000,    /* 0xb1 */ 0x0000000000000000,    
    /* 0xb2 */ 0x0000000000000000,    /* 0xb3 */ 0x0000000000000000,    
    /* 0xb4 */ 0x0000000000000000,    /* 0xb5 */ 0x0000000000000000,    
    /* 0xb6 */ 0x0000000000000000,    /* 0xb7 */ 0x0000000000000000,    
    /* 0xb8 */ 0x0000000000000000,    /* 0xb9 */ 0x0000000000000000,    
    /* 0xba */ 0x0000000000000000,    /* 0xbb */ 0x0000000000000000,    
    /* 0xbc */ 0x0000000000000000,    /* 0xbd */ 0x0000000000000000,    
    /* 0xbe */ 0x0000000000000000,    /* 0xbf */ 0x0000000000000000,    
    /* 0xc0 */ 0x0000000000000000,    /* 0xc1 */ 0x0000000000000000,    
    /* 0xc2 */ 0x0000000000000000,    /* 0xc3 */ 0x0000000000000000,    
    /* 0xc4 */ 0x0000000000000000,    /* 0xc5 */ 0x0000000000000000,    
    /* 0xc6 */ 0x0000000000000000,    /* 0xc7 */ 0x0000000000000000,    
    /* 0xc8 */ 0x0000000000000000,    /* 0xc9 */ 0x0000000000000000,    
    /* 0xca */ 0x0000000000000000,    /* 0xcb */ 0x0000000000000000,    
    /* 0xcc */ 0x0000000000000000,    /* 0xcd */ 0x0000000000000000,    
    /* 0xce */ 0x0000000000000000,    /* 0xcf */ 0x0000000000000000,    
    /* 0xd0 */ 0x0000000000000000,    /* 0xd1 */ 0x0000000000000000,    
    /* 0xd2 */ 0x0000000000000000,    /* 0xd3 */ 0x0000000000000000,    
    /* 0xd4 */ 0x0000000000000000,    /* 0xd5 */ 0x0000000000000000,    
    /* 0xd6 */ 0x0000000000000000,    /* 0xd7 */ 0x0000000000000000,    
    /* 0xd8 */ 0x0000000000000000,    /* 0xd9 */ 0x0000000000000000,    
    /* 0xda */ 0x0000000000000000,    /* 0xdb */ 0x0000000000000000,    
    /* 0xdc */ 0x0000000000000000,    /* 0xdd */ 0x0000000000000000,    
    /* 0xde */ 0x0000000000000000,    /* 0xdf */ 0x0000000000000000,    
    /* 0xe0 */ 0x0000000000000000,    /* 0xe1 */ 0x0000000000000000,    
    /* 0xe2 */ 0x0000000000000000,    /* 0xe3 */ 0x0000000000000000,    
    /* 0xe4 */ 0x0000000000000000,    /* 0xe5 */ 0x0000000000000000,    
    /* 0xe6 */ 0x0000000000000000,    /* 0xe7 */ 0x0000000000000000,    
    /* 0xe8 */ 0x0000000000000000,    /* 0xe9 */ 0x0000000000000000,    
    /* 0xea */ 0x0000000000000000,    /* 0xeb */ 0x0000000000000000,    
    /* 0xec */ 0x0000000000000000,    /* 0xed */ 0x0000000000000000,    
    /* 0xee */ 0x0000000000000000,    /* 0xef */ 0x0000000000000000,    
    /* 0xf0 */ 0x0000000000000000,    /* 0xf1 */ 0x0000000000000000,    
    /* 0xf2 */ 0x0000000000000000,    /* 0xf3 */ 0x0000000000000000,    
    /* 0xf4 */ 0x0000000000000000,    /* 0xf5 */ 0x0000000000000000,    
    /* 0xf6 */ 0x0000000000000000,    /* 0xf7 */ 0x0000000000000000,    
    /* 0xf8 */ 0x0000000000000000,    /* 0xf9 */ 0x0000000000000000,    
    /* 0xfa */ 0x0000000000000000,    /* 0xfb */ 0x0000000000000000,    
    /* 0xfc */ 0x0000000000000000,    /* 0xfd */ 0x0000000000000000,    
    /* 0xfe */ 0x0000000000000000,    /* 0xff */ 0x0000000000000000 
#endif
  };
};

}  // namespace arangodb::velocypack
}  // namespace arangodb

#endif
