/*jshint globalstrict:false, strict:false, maxlen: 500 */
/*global assertEqual */

////////////////////////////////////////////////////////////////////////////////
/// @brief tests for query language, range optimizations
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2012 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Jan Steemann
/// @author Copyright 2012, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

var jsunity = require("jsunity");
var helper = require("@arangodb/aql-helper");
var getQueryResults = helper.getQueryResults;

////////////////////////////////////////////////////////////////////////////////
/// @brief test suite
////////////////////////////////////////////////////////////////////////////////

function ahuacatlRangesCombined11TestSuite () {

////////////////////////////////////////////////////////////////////////////////
/// @brief execute a given query and return the results as an array
////////////////////////////////////////////////////////////////////////////////

  function runQuery (query) {
    return getQueryResults("FOR i IN [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ] FILTER " + query + " RETURN i");
  }

  return {

////////////////////////////////////////////////////////////////////////////////
/// @brief set up
////////////////////////////////////////////////////////////////////////////////

    setUp : function () {
    },

////////////////////////////////////////////////////////////////////////////////
/// @brief tear down
////////////////////////////////////////////////////////////////////////////////

    tearDown : function () {
    },

////////////////////////////////////////////////////////////////////////////////
/// @brief test range optimizations
////////////////////////////////////////////////////////////////////////////////

    testRanges : function () {
      var expected = [ 1, 2, 3, 4, 5, 6, 7 ];

      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i == 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i != 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i != 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i > 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i > 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i > 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i >= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 && i <= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 8 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i == 1 || i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i == 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i == 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i == 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i > 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i >= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i >= 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i != 1 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 || i <= 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i != 8 && i <= 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i == 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i == 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i > 1 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i > 8 && i <= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i == 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i > 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i >= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i >= 1 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i >= 8 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i == 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i == 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i == 1) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i != 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 1) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i != 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i > 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i > 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i > 1) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i >= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i >= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i >= 1) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 1) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 && i <= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i < 1 || i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 && i <= 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i < 8 || i <= 1) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i == 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i == 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i == 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i != 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i != 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i != 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i != 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i > 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i > 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i > 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i > 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i >= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i >= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i == 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i == 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i != 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i > 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i > 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i >= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i >= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i < 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i == 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 8 && i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 1 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 1 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 8 && i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 1 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i >= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i < 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 8 && i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 1 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) && (i <= 8 || i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 8 && i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i < 8) || (i <= 1 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i == 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i == 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i != 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i != 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i != 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i != 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i > 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i > 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i > 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i >= 1 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i >= 1 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 || i == 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 && i != 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 || i > 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 && i > 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 && i >= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 || i < 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 && i <= 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i < 8 || i <= 1)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i <= 1 || i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i <= 8 && i != 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 1) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 || i <= 8) && (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 && i <= 8) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 8 && i <= 1) || (i <= 1 || i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i <= 8 && i < 8)"));
      assertEqual(expected, runQuery("(i <= 1 || i <= 1) || (i <= 1 || i < 8)"));
    }
  
  };

}

////////////////////////////////////////////////////////////////////////////////
/// @brief executes the test suite
////////////////////////////////////////////////////////////////////////////////

jsunity.run(ahuacatlRangesCombined11TestSuite);

return jsunity.done();

