////////////////////////////////////////////////////////////////////////////////
/// DISCLAIMER
///
/// Copyright 2014-2021 ArangoDB GmbH, Cologne, Germany
/// Copyright 2004-2014 triAGENS GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is ArangoDB GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
////////////////////////////////////////////////////////////////////////////////

#ifndef ARANGODB_UTILITIES_LINE_EDITOR_H
#define ARANGODB_UTILITIES_LINE_EDITOR_H 1

#include <functional>

#include "Basics/Common.h"
#include "Utilities/ShellBase.h"

namespace arangodb {

////////////////////////////////////////////////////////////////////////////////
/// @brief line editor
////////////////////////////////////////////////////////////////////////////////

class LineEditor {
  LineEditor(LineEditor const&) = delete;
  LineEditor& operator=(LineEditor const&) = delete;

 public:
  //////////////////////////////////////////////////////////////////////////////
  /// @brief number of history entries
  //////////////////////////////////////////////////////////////////////////////

  static int const MAX_HISTORY_ENTRIES = 1000;

 public:
  LineEditor();

  virtual ~LineEditor();

 public:
  //////////////////////////////////////////////////////////////////////////////
  /// @brief whether or not the shell implementation supports colors
  //////////////////////////////////////////////////////////////////////////////

  bool supportsColors() const;

  //////////////////////////////////////////////////////////////////////////////
  /// @brief line editor open
  //////////////////////////////////////////////////////////////////////////////

  bool open(bool autoComplete);

  //////////////////////////////////////////////////////////////////////////////
  /// @brief line editor shutdown
  //////////////////////////////////////////////////////////////////////////////

  bool close();

  //////////////////////////////////////////////////////////////////////////////
  /// @brief line editor prompt
  //////////////////////////////////////////////////////////////////////////////

  std::string prompt(std::string const& prompt, std::string const& begin,
                     ShellBase::EofType&);

  //////////////////////////////////////////////////////////////////////////////
  /// @brief add to history
  //////////////////////////////////////////////////////////////////////////////

  void addHistory(std::string const& line);

  //////////////////////////////////////////////////////////////////////////////
  /// @brief send a signal to the shell implementation
  //////////////////////////////////////////////////////////////////////////////

  void signal();

  //////////////////////////////////////////////////////////////////////////////
  /// @brief register a callback function to be executed on signal receipt
  //////////////////////////////////////////////////////////////////////////////

  void setSignalFunction(std::function<void()> const&);

 protected:
  //////////////////////////////////////////////////////////////////////////////
  /// @brief the shell implementation
  //////////////////////////////////////////////////////////////////////////////

  ShellBase* _shell;

  //////////////////////////////////////////////////////////////////////////////
  /// @brief callback function to be executed on signal receipt
  //////////////////////////////////////////////////////////////////////////////

  std::function<void()> _signalFunc;
};
}  // namespace arangodb

#endif
