#include "unicorn/ucd-tables.hpp"

namespace RS::Unicorn::UnicornDetail {

const std::array<KeyValue<char32_t, uint16_t>, 3566> general_category_array = {{
{0x0,0x4363},
{0x20,0x5a73},
{0x21,0x506f},
{0x24,0x5363},
{0x25,0x506f},
{0x28,0x5073},
{0x29,0x5065},
{0x2a,0x506f},
{0x2b,0x536d},
{0x2c,0x506f},
{0x2d,0x5064},
{0x2e,0x506f},
{0x30,0x4e64},
{0x3a,0x506f},
{0x3c,0x536d},
{0x3f,0x506f},
{0x41,0x4c75},
{0x5b,0x5073},
{0x5c,0x506f},
{0x5d,0x5065},
{0x5e,0x536b},
{0x5f,0x5063},
{0x60,0x536b},
{0x61,0x4c6c},
{0x7b,0x5073},
{0x7c,0x536d},
{0x7d,0x5065},
{0x7e,0x536d},
{0x7f,0x4363},
{0xa0,0x5a73},
{0xa1,0x506f},
{0xa2,0x5363},
{0xa6,0x536f},
{0xa7,0x506f},
{0xa8,0x536b},
{0xa9,0x536f},
{0xaa,0x4c6f},
{0xab,0x5069},
{0xac,0x536d},
{0xad,0x4366},
{0xae,0x536f},
{0xaf,0x536b},
{0xb0,0x536f},
{0xb1,0x536d},
{0xb2,0x4e6f},
{0xb4,0x536b},
{0xb5,0x4c6c},
{0xb6,0x506f},
{0xb8,0x536b},
{0xb9,0x4e6f},
{0xba,0x4c6f},
{0xbb,0x5066},
{0xbc,0x4e6f},
{0xbf,0x506f},
{0xc0,0x4c75},
{0xd7,0x536d},
{0xd8,0x4c75},
{0xdf,0x4c6c},
{0xf7,0x536d},
{0xf8,0x4c6c},
{0x100,0x4c75},
{0x101,0x4c6c},
{0x102,0x4c75},
{0x103,0x4c6c},
{0x104,0x4c75},
{0x105,0x4c6c},
{0x106,0x4c75},
{0x107,0x4c6c},
{0x108,0x4c75},
{0x109,0x4c6c},
{0x10a,0x4c75},
{0x10b,0x4c6c},
{0x10c,0x4c75},
{0x10d,0x4c6c},
{0x10e,0x4c75},
{0x10f,0x4c6c},
{0x110,0x4c75},
{0x111,0x4c6c},
{0x112,0x4c75},
{0x113,0x4c6c},
{0x114,0x4c75},
{0x115,0x4c6c},
{0x116,0x4c75},
{0x117,0x4c6c},
{0x118,0x4c75},
{0x119,0x4c6c},
{0x11a,0x4c75},
{0x11b,0x4c6c},
{0x11c,0x4c75},
{0x11d,0x4c6c},
{0x11e,0x4c75},
{0x11f,0x4c6c},
{0x120,0x4c75},
{0x121,0x4c6c},
{0x122,0x4c75},
{0x123,0x4c6c},
{0x124,0x4c75},
{0x125,0x4c6c},
{0x126,0x4c75},
{0x127,0x4c6c},
{0x128,0x4c75},
{0x129,0x4c6c},
{0x12a,0x4c75},
{0x12b,0x4c6c},
{0x12c,0x4c75},
{0x12d,0x4c6c},
{0x12e,0x4c75},
{0x12f,0x4c6c},
{0x130,0x4c75},
{0x131,0x4c6c},
{0x132,0x4c75},
{0x133,0x4c6c},
{0x134,0x4c75},
{0x135,0x4c6c},
{0x136,0x4c75},
{0x137,0x4c6c},
{0x139,0x4c75},
{0x13a,0x4c6c},
{0x13b,0x4c75},
{0x13c,0x4c6c},
{0x13d,0x4c75},
{0x13e,0x4c6c},
{0x13f,0x4c75},
{0x140,0x4c6c},
{0x141,0x4c75},
{0x142,0x4c6c},
{0x143,0x4c75},
{0x144,0x4c6c},
{0x145,0x4c75},
{0x146,0x4c6c},
{0x147,0x4c75},
{0x148,0x4c6c},
{0x14a,0x4c75},
{0x14b,0x4c6c},
{0x14c,0x4c75},
{0x14d,0x4c6c},
{0x14e,0x4c75},
{0x14f,0x4c6c},
{0x150,0x4c75},
{0x151,0x4c6c},
{0x152,0x4c75},
{0x153,0x4c6c},
{0x154,0x4c75},
{0x155,0x4c6c},
{0x156,0x4c75},
{0x157,0x4c6c},
{0x158,0x4c75},
{0x159,0x4c6c},
{0x15a,0x4c75},
{0x15b,0x4c6c},
{0x15c,0x4c75},
{0x15d,0x4c6c},
{0x15e,0x4c75},
{0x15f,0x4c6c},
{0x160,0x4c75},
{0x161,0x4c6c},
{0x162,0x4c75},
{0x163,0x4c6c},
{0x164,0x4c75},
{0x165,0x4c6c},
{0x166,0x4c75},
{0x167,0x4c6c},
{0x168,0x4c75},
{0x169,0x4c6c},
{0x16a,0x4c75},
{0x16b,0x4c6c},
{0x16c,0x4c75},
{0x16d,0x4c6c},
{0x16e,0x4c75},
{0x16f,0x4c6c},
{0x170,0x4c75},
{0x171,0x4c6c},
{0x172,0x4c75},
{0x173,0x4c6c},
{0x174,0x4c75},
{0x175,0x4c6c},
{0x176,0x4c75},
{0x177,0x4c6c},
{0x178,0x4c75},
{0x17a,0x4c6c},
{0x17b,0x4c75},
{0x17c,0x4c6c},
{0x17d,0x4c75},
{0x17e,0x4c6c},
{0x181,0x4c75},
{0x183,0x4c6c},
{0x184,0x4c75},
{0x185,0x4c6c},
{0x186,0x4c75},
{0x188,0x4c6c},
{0x189,0x4c75},
{0x18c,0x4c6c},
{0x18e,0x4c75},
{0x192,0x4c6c},
{0x193,0x4c75},
{0x195,0x4c6c},
{0x196,0x4c75},
{0x199,0x4c6c},
{0x19c,0x4c75},
{0x19e,0x4c6c},
{0x19f,0x4c75},
{0x1a1,0x4c6c},
{0x1a2,0x4c75},
{0x1a3,0x4c6c},
{0x1a4,0x4c75},
{0x1a5,0x4c6c},
{0x1a6,0x4c75},
{0x1a8,0x4c6c},
{0x1a9,0x4c75},
{0x1aa,0x4c6c},
{0x1ac,0x4c75},
{0x1ad,0x4c6c},
{0x1ae,0x4c75},
{0x1b0,0x4c6c},
{0x1b1,0x4c75},
{0x1b4,0x4c6c},
{0x1b5,0x4c75},
{0x1b6,0x4c6c},
{0x1b7,0x4c75},
{0x1b9,0x4c6c},
{0x1bb,0x4c6f},
{0x1bc,0x4c75},
{0x1bd,0x4c6c},
{0x1c0,0x4c6f},
{0x1c4,0x4c75},
{0x1c5,0x4c74},
{0x1c6,0x4c6c},
{0x1c7,0x4c75},
{0x1c8,0x4c74},
{0x1c9,0x4c6c},
{0x1ca,0x4c75},
{0x1cb,0x4c74},
{0x1cc,0x4c6c},
{0x1cd,0x4c75},
{0x1ce,0x4c6c},
{0x1cf,0x4c75},
{0x1d0,0x4c6c},
{0x1d1,0x4c75},
{0x1d2,0x4c6c},
{0x1d3,0x4c75},
{0x1d4,0x4c6c},
{0x1d5,0x4c75},
{0x1d6,0x4c6c},
{0x1d7,0x4c75},
{0x1d8,0x4c6c},
{0x1d9,0x4c75},
{0x1da,0x4c6c},
{0x1db,0x4c75},
{0x1dc,0x4c6c},
{0x1de,0x4c75},
{0x1df,0x4c6c},
{0x1e0,0x4c75},
{0x1e1,0x4c6c},
{0x1e2,0x4c75},
{0x1e3,0x4c6c},
{0x1e4,0x4c75},
{0x1e5,0x4c6c},
{0x1e6,0x4c75},
{0x1e7,0x4c6c},
{0x1e8,0x4c75},
{0x1e9,0x4c6c},
{0x1ea,0x4c75},
{0x1eb,0x4c6c},
{0x1ec,0x4c75},
{0x1ed,0x4c6c},
{0x1ee,0x4c75},
{0x1ef,0x4c6c},
{0x1f1,0x4c75},
{0x1f2,0x4c74},
{0x1f3,0x4c6c},
{0x1f4,0x4c75},
{0x1f5,0x4c6c},
{0x1f6,0x4c75},
{0x1f9,0x4c6c},
{0x1fa,0x4c75},
{0x1fb,0x4c6c},
{0x1fc,0x4c75},
{0x1fd,0x4c6c},
{0x1fe,0x4c75},
{0x1ff,0x4c6c},
{0x200,0x4c75},
{0x201,0x4c6c},
{0x202,0x4c75},
{0x203,0x4c6c},
{0x204,0x4c75},
{0x205,0x4c6c},
{0x206,0x4c75},
{0x207,0x4c6c},
{0x208,0x4c75},
{0x209,0x4c6c},
{0x20a,0x4c75},
{0x20b,0x4c6c},
{0x20c,0x4c75},
{0x20d,0x4c6c},
{0x20e,0x4c75},
{0x20f,0x4c6c},
{0x210,0x4c75},
{0x211,0x4c6c},
{0x212,0x4c75},
{0x213,0x4c6c},
{0x214,0x4c75},
{0x215,0x4c6c},
{0x216,0x4c75},
{0x217,0x4c6c},
{0x218,0x4c75},
{0x219,0x4c6c},
{0x21a,0x4c75},
{0x21b,0x4c6c},
{0x21c,0x4c75},
{0x21d,0x4c6c},
{0x21e,0x4c75},
{0x21f,0x4c6c},
{0x220,0x4c75},
{0x221,0x4c6c},
{0x222,0x4c75},
{0x223,0x4c6c},
{0x224,0x4c75},
{0x225,0x4c6c},
{0x226,0x4c75},
{0x227,0x4c6c},
{0x228,0x4c75},
{0x229,0x4c6c},
{0x22a,0x4c75},
{0x22b,0x4c6c},
{0x22c,0x4c75},
{0x22d,0x4c6c},
{0x22e,0x4c75},
{0x22f,0x4c6c},
{0x230,0x4c75},
{0x231,0x4c6c},
{0x232,0x4c75},
{0x233,0x4c6c},
{0x23a,0x4c75},
{0x23c,0x4c6c},
{0x23d,0x4c75},
{0x23f,0x4c6c},
{0x241,0x4c75},
{0x242,0x4c6c},
{0x243,0x4c75},
{0x247,0x4c6c},
{0x248,0x4c75},
{0x249,0x4c6c},
{0x24a,0x4c75},
{0x24b,0x4c6c},
{0x24c,0x4c75},
{0x24d,0x4c6c},
{0x24e,0x4c75},
{0x24f,0x4c6c},
{0x294,0x4c6f},
{0x295,0x4c6c},
{0x2b0,0x4c6d},
{0x2c2,0x536b},
{0x2c6,0x4c6d},
{0x2d2,0x536b},
{0x2e0,0x4c6d},
{0x2e5,0x536b},
{0x2ec,0x4c6d},
{0x2ed,0x536b},
{0x2ee,0x4c6d},
{0x2ef,0x536b},
{0x300,0x4d6e},
{0x370,0x4c75},
{0x371,0x4c6c},
{0x372,0x4c75},
{0x373,0x4c6c},
{0x374,0x4c6d},
{0x375,0x536b},
{0x376,0x4c75},
{0x377,0x4c6c},
{0x378,0x436e},
{0x37a,0x4c6d},
{0x37b,0x4c6c},
{0x37e,0x506f},
{0x37f,0x4c75},
{0x380,0x436e},
{0x384,0x536b},
{0x386,0x4c75},
{0x387,0x506f},
{0x388,0x4c75},
{0x38b,0x436e},
{0x38c,0x4c75},
{0x38d,0x436e},
{0x38e,0x4c75},
{0x390,0x4c6c},
{0x391,0x4c75},
{0x3a2,0x436e},
{0x3a3,0x4c75},
{0x3ac,0x4c6c},
{0x3cf,0x4c75},
{0x3d0,0x4c6c},
{0x3d2,0x4c75},
{0x3d5,0x4c6c},
{0x3d8,0x4c75},
{0x3d9,0x4c6c},
{0x3da,0x4c75},
{0x3db,0x4c6c},
{0x3dc,0x4c75},
{0x3dd,0x4c6c},
{0x3de,0x4c75},
{0x3df,0x4c6c},
{0x3e0,0x4c75},
{0x3e1,0x4c6c},
{0x3e2,0x4c75},
{0x3e3,0x4c6c},
{0x3e4,0x4c75},
{0x3e5,0x4c6c},
{0x3e6,0x4c75},
{0x3e7,0x4c6c},
{0x3e8,0x4c75},
{0x3e9,0x4c6c},
{0x3ea,0x4c75},
{0x3eb,0x4c6c},
{0x3ec,0x4c75},
{0x3ed,0x4c6c},
{0x3ee,0x4c75},
{0x3ef,0x4c6c},
{0x3f4,0x4c75},
{0x3f5,0x4c6c},
{0x3f6,0x536d},
{0x3f7,0x4c75},
{0x3f8,0x4c6c},
{0x3f9,0x4c75},
{0x3fb,0x4c6c},
{0x3fd,0x4c75},
{0x430,0x4c6c},
{0x460,0x4c75},
{0x461,0x4c6c},
{0x462,0x4c75},
{0x463,0x4c6c},
{0x464,0x4c75},
{0x465,0x4c6c},
{0x466,0x4c75},
{0x467,0x4c6c},
{0x468,0x4c75},
{0x469,0x4c6c},
{0x46a,0x4c75},
{0x46b,0x4c6c},
{0x46c,0x4c75},
{0x46d,0x4c6c},
{0x46e,0x4c75},
{0x46f,0x4c6c},
{0x470,0x4c75},
{0x471,0x4c6c},
{0x472,0x4c75},
{0x473,0x4c6c},
{0x474,0x4c75},
{0x475,0x4c6c},
{0x476,0x4c75},
{0x477,0x4c6c},
{0x478,0x4c75},
{0x479,0x4c6c},
{0x47a,0x4c75},
{0x47b,0x4c6c},
{0x47c,0x4c75},
{0x47d,0x4c6c},
{0x47e,0x4c75},
{0x47f,0x4c6c},
{0x480,0x4c75},
{0x481,0x4c6c},
{0x482,0x536f},
{0x483,0x4d6e},
{0x488,0x4d65},
{0x48a,0x4c75},
{0x48b,0x4c6c},
{0x48c,0x4c75},
{0x48d,0x4c6c},
{0x48e,0x4c75},
{0x48f,0x4c6c},
{0x490,0x4c75},
{0x491,0x4c6c},
{0x492,0x4c75},
{0x493,0x4c6c},
{0x494,0x4c75},
{0x495,0x4c6c},
{0x496,0x4c75},
{0x497,0x4c6c},
{0x498,0x4c75},
{0x499,0x4c6c},
{0x49a,0x4c75},
{0x49b,0x4c6c},
{0x49c,0x4c75},
{0x49d,0x4c6c},
{0x49e,0x4c75},
{0x49f,0x4c6c},
{0x4a0,0x4c75},
{0x4a1,0x4c6c},
{0x4a2,0x4c75},
{0x4a3,0x4c6c},
{0x4a4,0x4c75},
{0x4a5,0x4c6c},
{0x4a6,0x4c75},
{0x4a7,0x4c6c},
{0x4a8,0x4c75},
{0x4a9,0x4c6c},
{0x4aa,0x4c75},
{0x4ab,0x4c6c},
{0x4ac,0x4c75},
{0x4ad,0x4c6c},
{0x4ae,0x4c75},
{0x4af,0x4c6c},
{0x4b0,0x4c75},
{0x4b1,0x4c6c},
{0x4b2,0x4c75},
{0x4b3,0x4c6c},
{0x4b4,0x4c75},
{0x4b5,0x4c6c},
{0x4b6,0x4c75},
{0x4b7,0x4c6c},
{0x4b8,0x4c75},
{0x4b9,0x4c6c},
{0x4ba,0x4c75},
{0x4bb,0x4c6c},
{0x4bc,0x4c75},
{0x4bd,0x4c6c},
{0x4be,0x4c75},
{0x4bf,0x4c6c},
{0x4c0,0x4c75},
{0x4c2,0x4c6c},
{0x4c3,0x4c75},
{0x4c4,0x4c6c},
{0x4c5,0x4c75},
{0x4c6,0x4c6c},
{0x4c7,0x4c75},
{0x4c8,0x4c6c},
{0x4c9,0x4c75},
{0x4ca,0x4c6c},
{0x4cb,0x4c75},
{0x4cc,0x4c6c},
{0x4cd,0x4c75},
{0x4ce,0x4c6c},
{0x4d0,0x4c75},
{0x4d1,0x4c6c},
{0x4d2,0x4c75},
{0x4d3,0x4c6c},
{0x4d4,0x4c75},
{0x4d5,0x4c6c},
{0x4d6,0x4c75},
{0x4d7,0x4c6c},
{0x4d8,0x4c75},
{0x4d9,0x4c6c},
{0x4da,0x4c75},
{0x4db,0x4c6c},
{0x4dc,0x4c75},
{0x4dd,0x4c6c},
{0x4de,0x4c75},
{0x4df,0x4c6c},
{0x4e0,0x4c75},
{0x4e1,0x4c6c},
{0x4e2,0x4c75},
{0x4e3,0x4c6c},
{0x4e4,0x4c75},
{0x4e5,0x4c6c},
{0x4e6,0x4c75},
{0x4e7,0x4c6c},
{0x4e8,0x4c75},
{0x4e9,0x4c6c},
{0x4ea,0x4c75},
{0x4eb,0x4c6c},
{0x4ec,0x4c75},
{0x4ed,0x4c6c},
{0x4ee,0x4c75},
{0x4ef,0x4c6c},
{0x4f0,0x4c75},
{0x4f1,0x4c6c},
{0x4f2,0x4c75},
{0x4f3,0x4c6c},
{0x4f4,0x4c75},
{0x4f5,0x4c6c},
{0x4f6,0x4c75},
{0x4f7,0x4c6c},
{0x4f8,0x4c75},
{0x4f9,0x4c6c},
{0x4fa,0x4c75},
{0x4fb,0x4c6c},
{0x4fc,0x4c75},
{0x4fd,0x4c6c},
{0x4fe,0x4c75},
{0x4ff,0x4c6c},
{0x500,0x4c75},
{0x501,0x4c6c},
{0x502,0x4c75},
{0x503,0x4c6c},
{0x504,0x4c75},
{0x505,0x4c6c},
{0x506,0x4c75},
{0x507,0x4c6c},
{0x508,0x4c75},
{0x509,0x4c6c},
{0x50a,0x4c75},
{0x50b,0x4c6c},
{0x50c,0x4c75},
{0x50d,0x4c6c},
{0x50e,0x4c75},
{0x50f,0x4c6c},
{0x510,0x4c75},
{0x511,0x4c6c},
{0x512,0x4c75},
{0x513,0x4c6c},
{0x514,0x4c75},
{0x515,0x4c6c},
{0x516,0x4c75},
{0x517,0x4c6c},
{0x518,0x4c75},
{0x519,0x4c6c},
{0x51a,0x4c75},
{0x51b,0x4c6c},
{0x51c,0x4c75},
{0x51d,0x4c6c},
{0x51e,0x4c75},
{0x51f,0x4c6c},
{0x520,0x4c75},
{0x521,0x4c6c},
{0x522,0x4c75},
{0x523,0x4c6c},
{0x524,0x4c75},
{0x525,0x4c6c},
{0x526,0x4c75},
{0x527,0x4c6c},
{0x528,0x4c75},
{0x529,0x4c6c},
{0x52a,0x4c75},
{0x52b,0x4c6c},
{0x52c,0x4c75},
{0x52d,0x4c6c},
{0x52e,0x4c75},
{0x52f,0x4c6c},
{0x530,0x436e},
{0x531,0x4c75},
{0x557,0x436e},
{0x559,0x4c6d},
{0x55a,0x506f},
{0x560,0x436e},
{0x561,0x4c6c},
{0x588,0x436e},
{0x589,0x506f},
{0x58a,0x5064},
{0x58b,0x436e},
{0x58d,0x536f},
{0x58f,0x5363},
{0x590,0x436e},
{0x591,0x4d6e},
{0x5be,0x5064},
{0x5bf,0x4d6e},
{0x5c0,0x506f},
{0x5c1,0x4d6e},
{0x5c3,0x506f},
{0x5c4,0x4d6e},
{0x5c6,0x506f},
{0x5c7,0x4d6e},
{0x5c8,0x436e},
{0x5d0,0x4c6f},
{0x5eb,0x436e},
{0x5f0,0x4c6f},
{0x5f3,0x506f},
{0x5f5,0x436e},
{0x600,0x4366},
{0x606,0x536d},
{0x609,0x506f},
{0x60b,0x5363},
{0x60c,0x506f},
{0x60e,0x536f},
{0x610,0x4d6e},
{0x61b,0x506f},
{0x61c,0x4366},
{0x61d,0x436e},
{0x61e,0x506f},
{0x620,0x4c6f},
{0x640,0x4c6d},
{0x641,0x4c6f},
{0x64b,0x4d6e},
{0x660,0x4e64},
{0x66a,0x506f},
{0x66e,0x4c6f},
{0x670,0x4d6e},
{0x671,0x4c6f},
{0x6d4,0x506f},
{0x6d5,0x4c6f},
{0x6d6,0x4d6e},
{0x6dd,0x4366},
{0x6de,0x536f},
{0x6df,0x4d6e},
{0x6e5,0x4c6d},
{0x6e7,0x4d6e},
{0x6e9,0x536f},
{0x6ea,0x4d6e},
{0x6ee,0x4c6f},
{0x6f0,0x4e64},
{0x6fa,0x4c6f},
{0x6fd,0x536f},
{0x6ff,0x4c6f},
{0x700,0x506f},
{0x70e,0x436e},
{0x70f,0x4366},
{0x710,0x4c6f},
{0x711,0x4d6e},
{0x712,0x4c6f},
{0x730,0x4d6e},
{0x74b,0x436e},
{0x74d,0x4c6f},
{0x7a6,0x4d6e},
{0x7b1,0x4c6f},
{0x7b2,0x436e},
{0x7c0,0x4e64},
{0x7ca,0x4c6f},
{0x7eb,0x4d6e},
{0x7f4,0x4c6d},
{0x7f6,0x536f},
{0x7f7,0x506f},
{0x7fa,0x4c6d},
{0x7fb,0x436e},
{0x800,0x4c6f},
{0x816,0x4d6e},
{0x81a,0x4c6d},
{0x81b,0x4d6e},
{0x824,0x4c6d},
{0x825,0x4d6e},
{0x828,0x4c6d},
{0x829,0x4d6e},
{0x82e,0x436e},
{0x830,0x506f},
{0x83f,0x436e},
{0x840,0x4c6f},
{0x859,0x4d6e},
{0x85c,0x436e},
{0x85e,0x506f},
{0x85f,0x436e},
{0x8a0,0x4c6f},
{0x8b5,0x436e},
{0x8e3,0x4d6e},
{0x903,0x4d63},
{0x904,0x4c6f},
{0x93a,0x4d6e},
{0x93b,0x4d63},
{0x93c,0x4d6e},
{0x93d,0x4c6f},
{0x93e,0x4d63},
{0x941,0x4d6e},
{0x949,0x4d63},
{0x94d,0x4d6e},
{0x94e,0x4d63},
{0x950,0x4c6f},
{0x951,0x4d6e},
{0x958,0x4c6f},
{0x962,0x4d6e},
{0x964,0x506f},
{0x966,0x4e64},
{0x970,0x506f},
{0x971,0x4c6d},
{0x972,0x4c6f},
{0x981,0x4d6e},
{0x982,0x4d63},
{0x984,0x436e},
{0x985,0x4c6f},
{0x98d,0x436e},
{0x98f,0x4c6f},
{0x991,0x436e},
{0x993,0x4c6f},
{0x9a9,0x436e},
{0x9aa,0x4c6f},
{0x9b1,0x436e},
{0x9b2,0x4c6f},
{0x9b3,0x436e},
{0x9b6,0x4c6f},
{0x9ba,0x436e},
{0x9bc,0x4d6e},
{0x9bd,0x4c6f},
{0x9be,0x4d63},
{0x9c1,0x4d6e},
{0x9c5,0x436e},
{0x9c7,0x4d63},
{0x9c9,0x436e},
{0x9cb,0x4d63},
{0x9cd,0x4d6e},
{0x9ce,0x4c6f},
{0x9cf,0x436e},
{0x9d7,0x4d63},
{0x9d8,0x436e},
{0x9dc,0x4c6f},
{0x9de,0x436e},
{0x9df,0x4c6f},
{0x9e2,0x4d6e},
{0x9e4,0x436e},
{0x9e6,0x4e64},
{0x9f0,0x4c6f},
{0x9f2,0x5363},
{0x9f4,0x4e6f},
{0x9fa,0x536f},
{0x9fb,0x5363},
{0x9fc,0x436e},
{0xa01,0x4d6e},
{0xa03,0x4d63},
{0xa04,0x436e},
{0xa05,0x4c6f},
{0xa0b,0x436e},
{0xa0f,0x4c6f},
{0xa11,0x436e},
{0xa13,0x4c6f},
{0xa29,0x436e},
{0xa2a,0x4c6f},
{0xa31,0x436e},
{0xa32,0x4c6f},
{0xa34,0x436e},
{0xa35,0x4c6f},
{0xa37,0x436e},
{0xa38,0x4c6f},
{0xa3a,0x436e},
{0xa3c,0x4d6e},
{0xa3d,0x436e},
{0xa3e,0x4d63},
{0xa41,0x4d6e},
{0xa43,0x436e},
{0xa47,0x4d6e},
{0xa49,0x436e},
{0xa4b,0x4d6e},
{0xa4e,0x436e},
{0xa51,0x4d6e},
{0xa52,0x436e},
{0xa59,0x4c6f},
{0xa5d,0x436e},
{0xa5e,0x4c6f},
{0xa5f,0x436e},
{0xa66,0x4e64},
{0xa70,0x4d6e},
{0xa72,0x4c6f},
{0xa75,0x4d6e},
{0xa76,0x436e},
{0xa81,0x4d6e},
{0xa83,0x4d63},
{0xa84,0x436e},
{0xa85,0x4c6f},
{0xa8e,0x436e},
{0xa8f,0x4c6f},
{0xa92,0x436e},
{0xa93,0x4c6f},
{0xaa9,0x436e},
{0xaaa,0x4c6f},
{0xab1,0x436e},
{0xab2,0x4c6f},
{0xab4,0x436e},
{0xab5,0x4c6f},
{0xaba,0x436e},
{0xabc,0x4d6e},
{0xabd,0x4c6f},
{0xabe,0x4d63},
{0xac1,0x4d6e},
{0xac6,0x436e},
{0xac7,0x4d6e},
{0xac9,0x4d63},
{0xaca,0x436e},
{0xacb,0x4d63},
{0xacd,0x4d6e},
{0xace,0x436e},
{0xad0,0x4c6f},
{0xad1,0x436e},
{0xae0,0x4c6f},
{0xae2,0x4d6e},
{0xae4,0x436e},
{0xae6,0x4e64},
{0xaf0,0x506f},
{0xaf1,0x5363},
{0xaf2,0x436e},
{0xaf9,0x4c6f},
{0xafa,0x436e},
{0xb01,0x4d6e},
{0xb02,0x4d63},
{0xb04,0x436e},
{0xb05,0x4c6f},
{0xb0d,0x436e},
{0xb0f,0x4c6f},
{0xb11,0x436e},
{0xb13,0x4c6f},
{0xb29,0x436e},
{0xb2a,0x4c6f},
{0xb31,0x436e},
{0xb32,0x4c6f},
{0xb34,0x436e},
{0xb35,0x4c6f},
{0xb3a,0x436e},
{0xb3c,0x4d6e},
{0xb3d,0x4c6f},
{0xb3e,0x4d63},
{0xb3f,0x4d6e},
{0xb40,0x4d63},
{0xb41,0x4d6e},
{0xb45,0x436e},
{0xb47,0x4d63},
{0xb49,0x436e},
{0xb4b,0x4d63},
{0xb4d,0x4d6e},
{0xb4e,0x436e},
{0xb56,0x4d6e},
{0xb57,0x4d63},
{0xb58,0x436e},
{0xb5c,0x4c6f},
{0xb5e,0x436e},
{0xb5f,0x4c6f},
{0xb62,0x4d6e},
{0xb64,0x436e},
{0xb66,0x4e64},
{0xb70,0x536f},
{0xb71,0x4c6f},
{0xb72,0x4e6f},
{0xb78,0x436e},
{0xb82,0x4d6e},
{0xb83,0x4c6f},
{0xb84,0x436e},
{0xb85,0x4c6f},
{0xb8b,0x436e},
{0xb8e,0x4c6f},
{0xb91,0x436e},
{0xb92,0x4c6f},
{0xb96,0x436e},
{0xb99,0x4c6f},
{0xb9b,0x436e},
{0xb9c,0x4c6f},
{0xb9d,0x436e},
{0xb9e,0x4c6f},
{0xba0,0x436e},
{0xba3,0x4c6f},
{0xba5,0x436e},
{0xba8,0x4c6f},
{0xbab,0x436e},
{0xbae,0x4c6f},
{0xbba,0x436e},
{0xbbe,0x4d63},
{0xbc0,0x4d6e},
{0xbc1,0x4d63},
{0xbc3,0x436e},
{0xbc6,0x4d63},
{0xbc9,0x436e},
{0xbca,0x4d63},
{0xbcd,0x4d6e},
{0xbce,0x436e},
{0xbd0,0x4c6f},
{0xbd1,0x436e},
{0xbd7,0x4d63},
{0xbd8,0x436e},
{0xbe6,0x4e64},
{0xbf0,0x4e6f},
{0xbf3,0x536f},
{0xbf9,0x5363},
{0xbfa,0x536f},
{0xbfb,0x436e},
{0xc00,0x4d6e},
{0xc01,0x4d63},
{0xc04,0x436e},
{0xc05,0x4c6f},
{0xc0d,0x436e},
{0xc0e,0x4c6f},
{0xc11,0x436e},
{0xc12,0x4c6f},
{0xc29,0x436e},
{0xc2a,0x4c6f},
{0xc3a,0x436e},
{0xc3d,0x4c6f},
{0xc3e,0x4d6e},
{0xc41,0x4d63},
{0xc45,0x436e},
{0xc46,0x4d6e},
{0xc49,0x436e},
{0xc4a,0x4d6e},
{0xc4e,0x436e},
{0xc55,0x4d6e},
{0xc57,0x436e},
{0xc58,0x4c6f},
{0xc5b,0x436e},
{0xc60,0x4c6f},
{0xc62,0x4d6e},
{0xc64,0x436e},
{0xc66,0x4e64},
{0xc70,0x436e},
{0xc78,0x4e6f},
{0xc7f,0x536f},
{0xc80,0x436e},
{0xc81,0x4d6e},
{0xc82,0x4d63},
{0xc84,0x436e},
{0xc85,0x4c6f},
{0xc8d,0x436e},
{0xc8e,0x4c6f},
{0xc91,0x436e},
{0xc92,0x4c6f},
{0xca9,0x436e},
{0xcaa,0x4c6f},
{0xcb4,0x436e},
{0xcb5,0x4c6f},
{0xcba,0x436e},
{0xcbc,0x4d6e},
{0xcbd,0x4c6f},
{0xcbe,0x4d63},
{0xcbf,0x4d6e},
{0xcc0,0x4d63},
{0xcc5,0x436e},
{0xcc6,0x4d6e},
{0xcc7,0x4d63},
{0xcc9,0x436e},
{0xcca,0x4d63},
{0xccc,0x4d6e},
{0xcce,0x436e},
{0xcd5,0x4d63},
{0xcd7,0x436e},
{0xcde,0x4c6f},
{0xcdf,0x436e},
{0xce0,0x4c6f},
{0xce2,0x4d6e},
{0xce4,0x436e},
{0xce6,0x4e64},
{0xcf0,0x436e},
{0xcf1,0x4c6f},
{0xcf3,0x436e},
{0xd01,0x4d6e},
{0xd02,0x4d63},
{0xd04,0x436e},
{0xd05,0x4c6f},
{0xd0d,0x436e},
{0xd0e,0x4c6f},
{0xd11,0x436e},
{0xd12,0x4c6f},
{0xd3b,0x436e},
{0xd3d,0x4c6f},
{0xd3e,0x4d63},
{0xd41,0x4d6e},
{0xd45,0x436e},
{0xd46,0x4d63},
{0xd49,0x436e},
{0xd4a,0x4d63},
{0xd4d,0x4d6e},
{0xd4e,0x4c6f},
{0xd4f,0x436e},
{0xd57,0x4d63},
{0xd58,0x436e},
{0xd5f,0x4c6f},
{0xd62,0x4d6e},
{0xd64,0x436e},
{0xd66,0x4e64},
{0xd70,0x4e6f},
{0xd76,0x436e},
{0xd79,0x536f},
{0xd7a,0x4c6f},
{0xd80,0x436e},
{0xd82,0x4d63},
{0xd84,0x436e},
{0xd85,0x4c6f},
{0xd97,0x436e},
{0xd9a,0x4c6f},
{0xdb2,0x436e},
{0xdb3,0x4c6f},
{0xdbc,0x436e},
{0xdbd,0x4c6f},
{0xdbe,0x436e},
{0xdc0,0x4c6f},
{0xdc7,0x436e},
{0xdca,0x4d6e},
{0xdcb,0x436e},
{0xdcf,0x4d63},
{0xdd2,0x4d6e},
{0xdd5,0x436e},
{0xdd6,0x4d6e},
{0xdd7,0x436e},
{0xdd8,0x4d63},
{0xde0,0x436e},
{0xde6,0x4e64},
{0xdf0,0x436e},
{0xdf2,0x4d63},
{0xdf4,0x506f},
{0xdf5,0x436e},
{0xe01,0x4c6f},
{0xe31,0x4d6e},
{0xe32,0x4c6f},
{0xe34,0x4d6e},
{0xe3b,0x436e},
{0xe3f,0x5363},
{0xe40,0x4c6f},
{0xe46,0x4c6d},
{0xe47,0x4d6e},
{0xe4f,0x506f},
{0xe50,0x4e64},
{0xe5a,0x506f},
{0xe5c,0x436e},
{0xe81,0x4c6f},
{0xe83,0x436e},
{0xe84,0x4c6f},
{0xe85,0x436e},
{0xe87,0x4c6f},
{0xe89,0x436e},
{0xe8a,0x4c6f},
{0xe8b,0x436e},
{0xe8d,0x4c6f},
{0xe8e,0x436e},
{0xe94,0x4c6f},
{0xe98,0x436e},
{0xe99,0x4c6f},
{0xea0,0x436e},
{0xea1,0x4c6f},
{0xea4,0x436e},
{0xea5,0x4c6f},
{0xea6,0x436e},
{0xea7,0x4c6f},
{0xea8,0x436e},
{0xeaa,0x4c6f},
{0xeac,0x436e},
{0xead,0x4c6f},
{0xeb1,0x4d6e},
{0xeb2,0x4c6f},
{0xeb4,0x4d6e},
{0xeba,0x436e},
{0xebb,0x4d6e},
{0xebd,0x4c6f},
{0xebe,0x436e},
{0xec0,0x4c6f},
{0xec5,0x436e},
{0xec6,0x4c6d},
{0xec7,0x436e},
{0xec8,0x4d6e},
{0xece,0x436e},
{0xed0,0x4e64},
{0xeda,0x436e},
{0xedc,0x4c6f},
{0xee0,0x436e},
{0xf00,0x4c6f},
{0xf01,0x536f},
{0xf04,0x506f},
{0xf13,0x536f},
{0xf14,0x506f},
{0xf15,0x536f},
{0xf18,0x4d6e},
{0xf1a,0x536f},
{0xf20,0x4e64},
{0xf2a,0x4e6f},
{0xf34,0x536f},
{0xf35,0x4d6e},
{0xf36,0x536f},
{0xf37,0x4d6e},
{0xf38,0x536f},
{0xf39,0x4d6e},
{0xf3a,0x5073},
{0xf3b,0x5065},
{0xf3c,0x5073},
{0xf3d,0x5065},
{0xf3e,0x4d63},
{0xf40,0x4c6f},
{0xf48,0x436e},
{0xf49,0x4c6f},
{0xf6d,0x436e},
{0xf71,0x4d6e},
{0xf7f,0x4d63},
{0xf80,0x4d6e},
{0xf85,0x506f},
{0xf86,0x4d6e},
{0xf88,0x4c6f},
{0xf8d,0x4d6e},
{0xf98,0x436e},
{0xf99,0x4d6e},
{0xfbd,0x436e},
{0xfbe,0x536f},
{0xfc6,0x4d6e},
{0xfc7,0x536f},
{0xfcd,0x436e},
{0xfce,0x536f},
{0xfd0,0x506f},
{0xfd5,0x536f},
{0xfd9,0x506f},
{0xfdb,0x436e},
{0x1000,0x4c6f},
{0x102b,0x4d63},
{0x102d,0x4d6e},
{0x1031,0x4d63},
{0x1032,0x4d6e},
{0x1038,0x4d63},
{0x1039,0x4d6e},
{0x103b,0x4d63},
{0x103d,0x4d6e},
{0x103f,0x4c6f},
{0x1040,0x4e64},
{0x104a,0x506f},
{0x1050,0x4c6f},
{0x1056,0x4d63},
{0x1058,0x4d6e},
{0x105a,0x4c6f},
{0x105e,0x4d6e},
{0x1061,0x4c6f},
{0x1062,0x4d63},
{0x1065,0x4c6f},
{0x1067,0x4d63},
{0x106e,0x4c6f},
{0x1071,0x4d6e},
{0x1075,0x4c6f},
{0x1082,0x4d6e},
{0x1083,0x4d63},
{0x1085,0x4d6e},
{0x1087,0x4d63},
{0x108d,0x4d6e},
{0x108e,0x4c6f},
{0x108f,0x4d63},
{0x1090,0x4e64},
{0x109a,0x4d63},
{0x109d,0x4d6e},
{0x109e,0x536f},
{0x10a0,0x4c75},
{0x10c6,0x436e},
{0x10c7,0x4c75},
{0x10c8,0x436e},
{0x10cd,0x4c75},
{0x10ce,0x436e},
{0x10d0,0x4c6f},
{0x10fb,0x506f},
{0x10fc,0x4c6d},
{0x10fd,0x4c6f},
{0x1249,0x436e},
{0x124a,0x4c6f},
{0x124e,0x436e},
{0x1250,0x4c6f},
{0x1257,0x436e},
{0x1258,0x4c6f},
{0x1259,0x436e},
{0x125a,0x4c6f},
{0x125e,0x436e},
{0x1260,0x4c6f},
{0x1289,0x436e},
{0x128a,0x4c6f},
{0x128e,0x436e},
{0x1290,0x4c6f},
{0x12b1,0x436e},
{0x12b2,0x4c6f},
{0x12b6,0x436e},
{0x12b8,0x4c6f},
{0x12bf,0x436e},
{0x12c0,0x4c6f},
{0x12c1,0x436e},
{0x12c2,0x4c6f},
{0x12c6,0x436e},
{0x12c8,0x4c6f},
{0x12d7,0x436e},
{0x12d8,0x4c6f},
{0x1311,0x436e},
{0x1312,0x4c6f},
{0x1316,0x436e},
{0x1318,0x4c6f},
{0x135b,0x436e},
{0x135d,0x4d6e},
{0x1360,0x506f},
{0x1369,0x4e6f},
{0x137d,0x436e},
{0x1380,0x4c6f},
{0x1390,0x536f},
{0x139a,0x436e},
{0x13a0,0x4c75},
{0x13f6,0x436e},
{0x13f8,0x4c6c},
{0x13fe,0x436e},
{0x1400,0x5064},
{0x1401,0x4c6f},
{0x166d,0x506f},
{0x166f,0x4c6f},
{0x1680,0x5a73},
{0x1681,0x4c6f},
{0x169b,0x5073},
{0x169c,0x5065},
{0x169d,0x436e},
{0x16a0,0x4c6f},
{0x16eb,0x506f},
{0x16ee,0x4e6c},
{0x16f1,0x4c6f},
{0x16f9,0x436e},
{0x1700,0x4c6f},
{0x170d,0x436e},
{0x170e,0x4c6f},
{0x1712,0x4d6e},
{0x1715,0x436e},
{0x1720,0x4c6f},
{0x1732,0x4d6e},
{0x1735,0x506f},
{0x1737,0x436e},
{0x1740,0x4c6f},
{0x1752,0x4d6e},
{0x1754,0x436e},
{0x1760,0x4c6f},
{0x176d,0x436e},
{0x176e,0x4c6f},
{0x1771,0x436e},
{0x1772,0x4d6e},
{0x1774,0x436e},
{0x1780,0x4c6f},
{0x17b4,0x4d6e},
{0x17b6,0x4d63},
{0x17b7,0x4d6e},
{0x17be,0x4d63},
{0x17c6,0x4d6e},
{0x17c7,0x4d63},
{0x17c9,0x4d6e},
{0x17d4,0x506f},
{0x17d7,0x4c6d},
{0x17d8,0x506f},
{0x17db,0x5363},
{0x17dc,0x4c6f},
{0x17dd,0x4d6e},
{0x17de,0x436e},
{0x17e0,0x4e64},
{0x17ea,0x436e},
{0x17f0,0x4e6f},
{0x17fa,0x436e},
{0x1800,0x506f},
{0x1806,0x5064},
{0x1807,0x506f},
{0x180b,0x4d6e},
{0x180e,0x4366},
{0x180f,0x436e},
{0x1810,0x4e64},
{0x181a,0x436e},
{0x1820,0x4c6f},
{0x1843,0x4c6d},
{0x1844,0x4c6f},
{0x1878,0x436e},
{0x1880,0x4c6f},
{0x18a9,0x4d6e},
{0x18aa,0x4c6f},
{0x18ab,0x436e},
{0x18b0,0x4c6f},
{0x18f6,0x436e},
{0x1900,0x4c6f},
{0x191f,0x436e},
{0x1920,0x4d6e},
{0x1923,0x4d63},
{0x1927,0x4d6e},
{0x1929,0x4d63},
{0x192c,0x436e},
{0x1930,0x4d63},
{0x1932,0x4d6e},
{0x1933,0x4d63},
{0x1939,0x4d6e},
{0x193c,0x436e},
{0x1940,0x536f},
{0x1941,0x436e},
{0x1944,0x506f},
{0x1946,0x4e64},
{0x1950,0x4c6f},
{0x196e,0x436e},
{0x1970,0x4c6f},
{0x1975,0x436e},
{0x1980,0x4c6f},
{0x19ac,0x436e},
{0x19b0,0x4c6f},
{0x19ca,0x436e},
{0x19d0,0x4e64},
{0x19da,0x4e6f},
{0x19db,0x436e},
{0x19de,0x536f},
{0x1a00,0x4c6f},
{0x1a17,0x4d6e},
{0x1a19,0x4d63},
{0x1a1b,0x4d6e},
{0x1a1c,0x436e},
{0x1a1e,0x506f},
{0x1a20,0x4c6f},
{0x1a55,0x4d63},
{0x1a56,0x4d6e},
{0x1a57,0x4d63},
{0x1a58,0x4d6e},
{0x1a5f,0x436e},
{0x1a60,0x4d6e},
{0x1a61,0x4d63},
{0x1a62,0x4d6e},
{0x1a63,0x4d63},
{0x1a65,0x4d6e},
{0x1a6d,0x4d63},
{0x1a73,0x4d6e},
{0x1a7d,0x436e},
{0x1a7f,0x4d6e},
{0x1a80,0x4e64},
{0x1a8a,0x436e},
{0x1a90,0x4e64},
{0x1a9a,0x436e},
{0x1aa0,0x506f},
{0x1aa7,0x4c6d},
{0x1aa8,0x506f},
{0x1aae,0x436e},
{0x1ab0,0x4d6e},
{0x1abe,0x4d65},
{0x1abf,0x436e},
{0x1b00,0x4d6e},
{0x1b04,0x4d63},
{0x1b05,0x4c6f},
{0x1b34,0x4d6e},
{0x1b35,0x4d63},
{0x1b36,0x4d6e},
{0x1b3b,0x4d63},
{0x1b3c,0x4d6e},
{0x1b3d,0x4d63},
{0x1b42,0x4d6e},
{0x1b43,0x4d63},
{0x1b45,0x4c6f},
{0x1b4c,0x436e},
{0x1b50,0x4e64},
{0x1b5a,0x506f},
{0x1b61,0x536f},
{0x1b6b,0x4d6e},
{0x1b74,0x536f},
{0x1b7d,0x436e},
{0x1b80,0x4d6e},
{0x1b82,0x4d63},
{0x1b83,0x4c6f},
{0x1ba1,0x4d63},
{0x1ba2,0x4d6e},
{0x1ba6,0x4d63},
{0x1ba8,0x4d6e},
{0x1baa,0x4d63},
{0x1bab,0x4d6e},
{0x1bae,0x4c6f},
{0x1bb0,0x4e64},
{0x1bba,0x4c6f},
{0x1be6,0x4d6e},
{0x1be7,0x4d63},
{0x1be8,0x4d6e},
{0x1bea,0x4d63},
{0x1bed,0x4d6e},
{0x1bee,0x4d63},
{0x1bef,0x4d6e},
{0x1bf2,0x4d63},
{0x1bf4,0x436e},
{0x1bfc,0x506f},
{0x1c00,0x4c6f},
{0x1c24,0x4d63},
{0x1c2c,0x4d6e},
{0x1c34,0x4d63},
{0x1c36,0x4d6e},
{0x1c38,0x436e},
{0x1c3b,0x506f},
{0x1c40,0x4e64},
{0x1c4a,0x436e},
{0x1c4d,0x4c6f},
{0x1c50,0x4e64},
{0x1c5a,0x4c6f},
{0x1c78,0x4c6d},
{0x1c7e,0x506f},
{0x1c80,0x436e},
{0x1cc0,0x506f},
{0x1cc8,0x436e},
{0x1cd0,0x4d6e},
{0x1cd3,0x506f},
{0x1cd4,0x4d6e},
{0x1ce1,0x4d63},
{0x1ce2,0x4d6e},
{0x1ce9,0x4c6f},
{0x1ced,0x4d6e},
{0x1cee,0x4c6f},
{0x1cf2,0x4d63},
{0x1cf4,0x4d6e},
{0x1cf5,0x4c6f},
{0x1cf7,0x436e},
{0x1cf8,0x4d6e},
{0x1cfa,0x436e},
{0x1d00,0x4c6c},
{0x1d2c,0x4c6d},
{0x1d6b,0x4c6c},
{0x1d78,0x4c6d},
{0x1d79,0x4c6c},
{0x1d9b,0x4c6d},
{0x1dc0,0x4d6e},
{0x1df6,0x436e},
{0x1dfc,0x4d6e},
{0x1e00,0x4c75},
{0x1e01,0x4c6c},
{0x1e02,0x4c75},
{0x1e03,0x4c6c},
{0x1e04,0x4c75},
{0x1e05,0x4c6c},
{0x1e06,0x4c75},
{0x1e07,0x4c6c},
{0x1e08,0x4c75},
{0x1e09,0x4c6c},
{0x1e0a,0x4c75},
{0x1e0b,0x4c6c},
{0x1e0c,0x4c75},
{0x1e0d,0x4c6c},
{0x1e0e,0x4c75},
{0x1e0f,0x4c6c},
{0x1e10,0x4c75},
{0x1e11,0x4c6c},
{0x1e12,0x4c75},
{0x1e13,0x4c6c},
{0x1e14,0x4c75},
{0x1e15,0x4c6c},
{0x1e16,0x4c75},
{0x1e17,0x4c6c},
{0x1e18,0x4c75},
{0x1e19,0x4c6c},
{0x1e1a,0x4c75},
{0x1e1b,0x4c6c},
{0x1e1c,0x4c75},
{0x1e1d,0x4c6c},
{0x1e1e,0x4c75},
{0x1e1f,0x4c6c},
{0x1e20,0x4c75},
{0x1e21,0x4c6c},
{0x1e22,0x4c75},
{0x1e23,0x4c6c},
{0x1e24,0x4c75},
{0x1e25,0x4c6c},
{0x1e26,0x4c75},
{0x1e27,0x4c6c},
{0x1e28,0x4c75},
{0x1e29,0x4c6c},
{0x1e2a,0x4c75},
{0x1e2b,0x4c6c},
{0x1e2c,0x4c75},
{0x1e2d,0x4c6c},
{0x1e2e,0x4c75},
{0x1e2f,0x4c6c},
{0x1e30,0x4c75},
{0x1e31,0x4c6c},
{0x1e32,0x4c75},
{0x1e33,0x4c6c},
{0x1e34,0x4c75},
{0x1e35,0x4c6c},
{0x1e36,0x4c75},
{0x1e37,0x4c6c},
{0x1e38,0x4c75},
{0x1e39,0x4c6c},
{0x1e3a,0x4c75},
{0x1e3b,0x4c6c},
{0x1e3c,0x4c75},
{0x1e3d,0x4c6c},
{0x1e3e,0x4c75},
{0x1e3f,0x4c6c},
{0x1e40,0x4c75},
{0x1e41,0x4c6c},
{0x1e42,0x4c75},
{0x1e43,0x4c6c},
{0x1e44,0x4c75},
{0x1e45,0x4c6c},
{0x1e46,0x4c75},
{0x1e47,0x4c6c},
{0x1e48,0x4c75},
{0x1e49,0x4c6c},
{0x1e4a,0x4c75},
{0x1e4b,0x4c6c},
{0x1e4c,0x4c75},
{0x1e4d,0x4c6c},
{0x1e4e,0x4c75},
{0x1e4f,0x4c6c},
{0x1e50,0x4c75},
{0x1e51,0x4c6c},
{0x1e52,0x4c75},
{0x1e53,0x4c6c},
{0x1e54,0x4c75},
{0x1e55,0x4c6c},
{0x1e56,0x4c75},
{0x1e57,0x4c6c},
{0x1e58,0x4c75},
{0x1e59,0x4c6c},
{0x1e5a,0x4c75},
{0x1e5b,0x4c6c},
{0x1e5c,0x4c75},
{0x1e5d,0x4c6c},
{0x1e5e,0x4c75},
{0x1e5f,0x4c6c},
{0x1e60,0x4c75},
{0x1e61,0x4c6c},
{0x1e62,0x4c75},
{0x1e63,0x4c6c},
{0x1e64,0x4c75},
{0x1e65,0x4c6c},
{0x1e66,0x4c75},
{0x1e67,0x4c6c},
{0x1e68,0x4c75},
{0x1e69,0x4c6c},
{0x1e6a,0x4c75},
{0x1e6b,0x4c6c},
{0x1e6c,0x4c75},
{0x1e6d,0x4c6c},
{0x1e6e,0x4c75},
{0x1e6f,0x4c6c},
{0x1e70,0x4c75},
{0x1e71,0x4c6c},
{0x1e72,0x4c75},
{0x1e73,0x4c6c},
{0x1e74,0x4c75},
{0x1e75,0x4c6c},
{0x1e76,0x4c75},
{0x1e77,0x4c6c},
{0x1e78,0x4c75},
{0x1e79,0x4c6c},
{0x1e7a,0x4c75},
{0x1e7b,0x4c6c},
{0x1e7c,0x4c75},
{0x1e7d,0x4c6c},
{0x1e7e,0x4c75},
{0x1e7f,0x4c6c},
{0x1e80,0x4c75},
{0x1e81,0x4c6c},
{0x1e82,0x4c75},
{0x1e83,0x4c6c},
{0x1e84,0x4c75},
{0x1e85,0x4c6c},
{0x1e86,0x4c75},
{0x1e87,0x4c6c},
{0x1e88,0x4c75},
{0x1e89,0x4c6c},
{0x1e8a,0x4c75},
{0x1e8b,0x4c6c},
{0x1e8c,0x4c75},
{0x1e8d,0x4c6c},
{0x1e8e,0x4c75},
{0x1e8f,0x4c6c},
{0x1e90,0x4c75},
{0x1e91,0x4c6c},
{0x1e92,0x4c75},
{0x1e93,0x4c6c},
{0x1e94,0x4c75},
{0x1e95,0x4c6c},
{0x1e9e,0x4c75},
{0x1e9f,0x4c6c},
{0x1ea0,0x4c75},
{0x1ea1,0x4c6c},
{0x1ea2,0x4c75},
{0x1ea3,0x4c6c},
{0x1ea4,0x4c75},
{0x1ea5,0x4c6c},
{0x1ea6,0x4c75},
{0x1ea7,0x4c6c},
{0x1ea8,0x4c75},
{0x1ea9,0x4c6c},
{0x1eaa,0x4c75},
{0x1eab,0x4c6c},
{0x1eac,0x4c75},
{0x1ead,0x4c6c},
{0x1eae,0x4c75},
{0x1eaf,0x4c6c},
{0x1eb0,0x4c75},
{0x1eb1,0x4c6c},
{0x1eb2,0x4c75},
{0x1eb3,0x4c6c},
{0x1eb4,0x4c75},
{0x1eb5,0x4c6c},
{0x1eb6,0x4c75},
{0x1eb7,0x4c6c},
{0x1eb8,0x4c75},
{0x1eb9,0x4c6c},
{0x1eba,0x4c75},
{0x1ebb,0x4c6c},
{0x1ebc,0x4c75},
{0x1ebd,0x4c6c},
{0x1ebe,0x4c75},
{0x1ebf,0x4c6c},
{0x1ec0,0x4c75},
{0x1ec1,0x4c6c},
{0x1ec2,0x4c75},
{0x1ec3,0x4c6c},
{0x1ec4,0x4c75},
{0x1ec5,0x4c6c},
{0x1ec6,0x4c75},
{0x1ec7,0x4c6c},
{0x1ec8,0x4c75},
{0x1ec9,0x4c6c},
{0x1eca,0x4c75},
{0x1ecb,0x4c6c},
{0x1ecc,0x4c75},
{0x1ecd,0x4c6c},
{0x1ece,0x4c75},
{0x1ecf,0x4c6c},
{0x1ed0,0x4c75},
{0x1ed1,0x4c6c},
{0x1ed2,0x4c75},
{0x1ed3,0x4c6c},
{0x1ed4,0x4c75},
{0x1ed5,0x4c6c},
{0x1ed6,0x4c75},
{0x1ed7,0x4c6c},
{0x1ed8,0x4c75},
{0x1ed9,0x4c6c},
{0x1eda,0x4c75},
{0x1edb,0x4c6c},
{0x1edc,0x4c75},
{0x1edd,0x4c6c},
{0x1ede,0x4c75},
{0x1edf,0x4c6c},
{0x1ee0,0x4c75},
{0x1ee1,0x4c6c},
{0x1ee2,0x4c75},
{0x1ee3,0x4c6c},
{0x1ee4,0x4c75},
{0x1ee5,0x4c6c},
{0x1ee6,0x4c75},
{0x1ee7,0x4c6c},
{0x1ee8,0x4c75},
{0x1ee9,0x4c6c},
{0x1eea,0x4c75},
{0x1eeb,0x4c6c},
{0x1eec,0x4c75},
{0x1eed,0x4c6c},
{0x1eee,0x4c75},
{0x1eef,0x4c6c},
{0x1ef0,0x4c75},
{0x1ef1,0x4c6c},
{0x1ef2,0x4c75},
{0x1ef3,0x4c6c},
{0x1ef4,0x4c75},
{0x1ef5,0x4c6c},
{0x1ef6,0x4c75},
{0x1ef7,0x4c6c},
{0x1ef8,0x4c75},
{0x1ef9,0x4c6c},
{0x1efa,0x4c75},
{0x1efb,0x4c6c},
{0x1efc,0x4c75},
{0x1efd,0x4c6c},
{0x1efe,0x4c75},
{0x1eff,0x4c6c},
{0x1f08,0x4c75},
{0x1f10,0x4c6c},
{0x1f16,0x436e},
{0x1f18,0x4c75},
{0x1f1e,0x436e},
{0x1f20,0x4c6c},
{0x1f28,0x4c75},
{0x1f30,0x4c6c},
{0x1f38,0x4c75},
{0x1f40,0x4c6c},
{0x1f46,0x436e},
{0x1f48,0x4c75},
{0x1f4e,0x436e},
{0x1f50,0x4c6c},
{0x1f58,0x436e},
{0x1f59,0x4c75},
{0x1f5a,0x436e},
{0x1f5b,0x4c75},
{0x1f5c,0x436e},
{0x1f5d,0x4c75},
{0x1f5e,0x436e},
{0x1f5f,0x4c75},
{0x1f60,0x4c6c},
{0x1f68,0x4c75},
{0x1f70,0x4c6c},
{0x1f7e,0x436e},
{0x1f80,0x4c6c},
{0x1f88,0x4c74},
{0x1f90,0x4c6c},
{0x1f98,0x4c74},
{0x1fa0,0x4c6c},
{0x1fa8,0x4c74},
{0x1fb0,0x4c6c},
{0x1fb5,0x436e},
{0x1fb6,0x4c6c},
{0x1fb8,0x4c75},
{0x1fbc,0x4c74},
{0x1fbd,0x536b},
{0x1fbe,0x4c6c},
{0x1fbf,0x536b},
{0x1fc2,0x4c6c},
{0x1fc5,0x436e},
{0x1fc6,0x4c6c},
{0x1fc8,0x4c75},
{0x1fcc,0x4c74},
{0x1fcd,0x536b},
{0x1fd0,0x4c6c},
{0x1fd4,0x436e},
{0x1fd6,0x4c6c},
{0x1fd8,0x4c75},
{0x1fdc,0x436e},
{0x1fdd,0x536b},
{0x1fe0,0x4c6c},
{0x1fe8,0x4c75},
{0x1fed,0x536b},
{0x1ff0,0x436e},
{0x1ff2,0x4c6c},
{0x1ff5,0x436e},
{0x1ff6,0x4c6c},
{0x1ff8,0x4c75},
{0x1ffc,0x4c74},
{0x1ffd,0x536b},
{0x1fff,0x436e},
{0x2000,0x5a73},
{0x200b,0x4366},
{0x2010,0x5064},
{0x2016,0x506f},
{0x2018,0x5069},
{0x2019,0x5066},
{0x201a,0x5073},
{0x201b,0x5069},
{0x201d,0x5066},
{0x201e,0x5073},
{0x201f,0x5069},
{0x2020,0x506f},
{0x2028,0x5a6c},
{0x2029,0x5a70},
{0x202a,0x4366},
{0x202f,0x5a73},
{0x2030,0x506f},
{0x2039,0x5069},
{0x203a,0x5066},
{0x203b,0x506f},
{0x203f,0x5063},
{0x2041,0x506f},
{0x2044,0x536d},
{0x2045,0x5073},
{0x2046,0x5065},
{0x2047,0x506f},
{0x2052,0x536d},
{0x2053,0x506f},
{0x2054,0x5063},
{0x2055,0x506f},
{0x205f,0x5a73},
{0x2060,0x4366},
{0x2065,0x436e},
{0x2066,0x4366},
{0x2070,0x4e6f},
{0x2071,0x4c6d},
{0x2072,0x436e},
{0x2074,0x4e6f},
{0x207a,0x536d},
{0x207d,0x5073},
{0x207e,0x5065},
{0x207f,0x4c6d},
{0x2080,0x4e6f},
{0x208a,0x536d},
{0x208d,0x5073},
{0x208e,0x5065},
{0x208f,0x436e},
{0x2090,0x4c6d},
{0x209d,0x436e},
{0x20a0,0x5363},
{0x20bf,0x436e},
{0x20d0,0x4d6e},
{0x20dd,0x4d65},
{0x20e1,0x4d6e},
{0x20e2,0x4d65},
{0x20e5,0x4d6e},
{0x20f1,0x436e},
{0x2100,0x536f},
{0x2102,0x4c75},
{0x2103,0x536f},
{0x2107,0x4c75},
{0x2108,0x536f},
{0x210a,0x4c6c},
{0x210b,0x4c75},
{0x210e,0x4c6c},
{0x2110,0x4c75},
{0x2113,0x4c6c},
{0x2114,0x536f},
{0x2115,0x4c75},
{0x2116,0x536f},
{0x2118,0x536d},
{0x2119,0x4c75},
{0x211e,0x536f},
{0x2124,0x4c75},
{0x2125,0x536f},
{0x2126,0x4c75},
{0x2127,0x536f},
{0x2128,0x4c75},
{0x2129,0x536f},
{0x212a,0x4c75},
{0x212e,0x536f},
{0x212f,0x4c6c},
{0x2130,0x4c75},
{0x2134,0x4c6c},
{0x2135,0x4c6f},
{0x2139,0x4c6c},
{0x213a,0x536f},
{0x213c,0x4c6c},
{0x213e,0x4c75},
{0x2140,0x536d},
{0x2145,0x4c75},
{0x2146,0x4c6c},
{0x214a,0x536f},
{0x214b,0x536d},
{0x214c,0x536f},
{0x214e,0x4c6c},
{0x214f,0x536f},
{0x2150,0x4e6f},
{0x2160,0x4e6c},
{0x2183,0x4c75},
{0x2184,0x4c6c},
{0x2185,0x4e6c},
{0x2189,0x4e6f},
{0x218a,0x536f},
{0x218c,0x436e},
{0x2190,0x536d},
{0x2195,0x536f},
{0x219a,0x536d},
{0x219c,0x536f},
{0x21a0,0x536d},
{0x21a1,0x536f},
{0x21a3,0x536d},
{0x21a4,0x536f},
{0x21a6,0x536d},
{0x21a7,0x536f},
{0x21ae,0x536d},
{0x21af,0x536f},
{0x21ce,0x536d},
{0x21d0,0x536f},
{0x21d2,0x536d},
{0x21d3,0x536f},
{0x21d4,0x536d},
{0x21d5,0x536f},
{0x21f4,0x536d},
{0x2300,0x536f},
{0x2308,0x5073},
{0x2309,0x5065},
{0x230a,0x5073},
{0x230b,0x5065},
{0x230c,0x536f},
{0x2320,0x536d},
{0x2322,0x536f},
{0x2329,0x5073},
{0x232a,0x5065},
{0x232b,0x536f},
{0x237c,0x536d},
{0x237d,0x536f},
{0x239b,0x536d},
{0x23b4,0x536f},
{0x23dc,0x536d},
{0x23e2,0x536f},
{0x23fb,0x436e},
{0x2400,0x536f},
{0x2427,0x436e},
{0x2440,0x536f},
{0x244b,0x436e},
{0x2460,0x4e6f},
{0x249c,0x536f},
{0x24ea,0x4e6f},
{0x2500,0x536f},
{0x25b7,0x536d},
{0x25b8,0x536f},
{0x25c1,0x536d},
{0x25c2,0x536f},
{0x25f8,0x536d},
{0x2600,0x536f},
{0x266f,0x536d},
{0x2670,0x536f},
{0x2768,0x5073},
{0x2769,0x5065},
{0x276a,0x5073},
{0x276b,0x5065},
{0x276c,0x5073},
{0x276d,0x5065},
{0x276e,0x5073},
{0x276f,0x5065},
{0x2770,0x5073},
{0x2771,0x5065},
{0x2772,0x5073},
{0x2773,0x5065},
{0x2774,0x5073},
{0x2775,0x5065},
{0x2776,0x4e6f},
{0x2794,0x536f},
{0x27c0,0x536d},
{0x27c5,0x5073},
{0x27c6,0x5065},
{0x27c7,0x536d},
{0x27e6,0x5073},
{0x27e7,0x5065},
{0x27e8,0x5073},
{0x27e9,0x5065},
{0x27ea,0x5073},
{0x27eb,0x5065},
{0x27ec,0x5073},
{0x27ed,0x5065},
{0x27ee,0x5073},
{0x27ef,0x5065},
{0x27f0,0x536d},
{0x2800,0x536f},
{0x2900,0x536d},
{0x2983,0x5073},
{0x2984,0x5065},
{0x2985,0x5073},
{0x2986,0x5065},
{0x2987,0x5073},
{0x2988,0x5065},
{0x2989,0x5073},
{0x298a,0x5065},
{0x298b,0x5073},
{0x298c,0x5065},
{0x298d,0x5073},
{0x298e,0x5065},
{0x298f,0x5073},
{0x2990,0x5065},
{0x2991,0x5073},
{0x2992,0x5065},
{0x2993,0x5073},
{0x2994,0x5065},
{0x2995,0x5073},
{0x2996,0x5065},
{0x2997,0x5073},
{0x2998,0x5065},
{0x2999,0x536d},
{0x29d8,0x5073},
{0x29d9,0x5065},
{0x29da,0x5073},
{0x29db,0x5065},
{0x29dc,0x536d},
{0x29fc,0x5073},
{0x29fd,0x5065},
{0x29fe,0x536d},
{0x2b00,0x536f},
{0x2b30,0x536d},
{0x2b45,0x536f},
{0x2b47,0x536d},
{0x2b4d,0x536f},
{0x2b74,0x436e},
{0x2b76,0x536f},
{0x2b96,0x436e},
{0x2b98,0x536f},
{0x2bba,0x436e},
{0x2bbd,0x536f},
{0x2bc9,0x436e},
{0x2bca,0x536f},
{0x2bd2,0x436e},
{0x2bec,0x536f},
{0x2bf0,0x436e},
{0x2c00,0x4c75},
{0x2c2f,0x436e},
{0x2c30,0x4c6c},
{0x2c5f,0x436e},
{0x2c60,0x4c75},
{0x2c61,0x4c6c},
{0x2c62,0x4c75},
{0x2c65,0x4c6c},
{0x2c67,0x4c75},
{0x2c68,0x4c6c},
{0x2c69,0x4c75},
{0x2c6a,0x4c6c},
{0x2c6b,0x4c75},
{0x2c6c,0x4c6c},
{0x2c6d,0x4c75},
{0x2c71,0x4c6c},
{0x2c72,0x4c75},
{0x2c73,0x4c6c},
{0x2c75,0x4c75},
{0x2c76,0x4c6c},
{0x2c7c,0x4c6d},
{0x2c7e,0x4c75},
{0x2c81,0x4c6c},
{0x2c82,0x4c75},
{0x2c83,0x4c6c},
{0x2c84,0x4c75},
{0x2c85,0x4c6c},
{0x2c86,0x4c75},
{0x2c87,0x4c6c},
{0x2c88,0x4c75},
{0x2c89,0x4c6c},
{0x2c8a,0x4c75},
{0x2c8b,0x4c6c},
{0x2c8c,0x4c75},
{0x2c8d,0x4c6c},
{0x2c8e,0x4c75},
{0x2c8f,0x4c6c},
{0x2c90,0x4c75},
{0x2c91,0x4c6c},
{0x2c92,0x4c75},
{0x2c93,0x4c6c},
{0x2c94,0x4c75},
{0x2c95,0x4c6c},
{0x2c96,0x4c75},
{0x2c97,0x4c6c},
{0x2c98,0x4c75},
{0x2c99,0x4c6c},
{0x2c9a,0x4c75},
{0x2c9b,0x4c6c},
{0x2c9c,0x4c75},
{0x2c9d,0x4c6c},
{0x2c9e,0x4c75},
{0x2c9f,0x4c6c},
{0x2ca0,0x4c75},
{0x2ca1,0x4c6c},
{0x2ca2,0x4c75},
{0x2ca3,0x4c6c},
{0x2ca4,0x4c75},
{0x2ca5,0x4c6c},
{0x2ca6,0x4c75},
{0x2ca7,0x4c6c},
{0x2ca8,0x4c75},
{0x2ca9,0x4c6c},
{0x2caa,0x4c75},
{0x2cab,0x4c6c},
{0x2cac,0x4c75},
{0x2cad,0x4c6c},
{0x2cae,0x4c75},
{0x2caf,0x4c6c},
{0x2cb0,0x4c75},
{0x2cb1,0x4c6c},
{0x2cb2,0x4c75},
{0x2cb3,0x4c6c},
{0x2cb4,0x4c75},
{0x2cb5,0x4c6c},
{0x2cb6,0x4c75},
{0x2cb7,0x4c6c},
{0x2cb8,0x4c75},
{0x2cb9,0x4c6c},
{0x2cba,0x4c75},
{0x2cbb,0x4c6c},
{0x2cbc,0x4c75},
{0x2cbd,0x4c6c},
{0x2cbe,0x4c75},
{0x2cbf,0x4c6c},
{0x2cc0,0x4c75},
{0x2cc1,0x4c6c},
{0x2cc2,0x4c75},
{0x2cc3,0x4c6c},
{0x2cc4,0x4c75},
{0x2cc5,0x4c6c},
{0x2cc6,0x4c75},
{0x2cc7,0x4c6c},
{0x2cc8,0x4c75},
{0x2cc9,0x4c6c},
{0x2cca,0x4c75},
{0x2ccb,0x4c6c},
{0x2ccc,0x4c75},
{0x2ccd,0x4c6c},
{0x2cce,0x4c75},
{0x2ccf,0x4c6c},
{0x2cd0,0x4c75},
{0x2cd1,0x4c6c},
{0x2cd2,0x4c75},
{0x2cd3,0x4c6c},
{0x2cd4,0x4c75},
{0x2cd5,0x4c6c},
{0x2cd6,0x4c75},
{0x2cd7,0x4c6c},
{0x2cd8,0x4c75},
{0x2cd9,0x4c6c},
{0x2cda,0x4c75},
{0x2cdb,0x4c6c},
{0x2cdc,0x4c75},
{0x2cdd,0x4c6c},
{0x2cde,0x4c75},
{0x2cdf,0x4c6c},
{0x2ce0,0x4c75},
{0x2ce1,0x4c6c},
{0x2ce2,0x4c75},
{0x2ce3,0x4c6c},
{0x2ce5,0x536f},
{0x2ceb,0x4c75},
{0x2cec,0x4c6c},
{0x2ced,0x4c75},
{0x2cee,0x4c6c},
{0x2cef,0x4d6e},
{0x2cf2,0x4c75},
{0x2cf3,0x4c6c},
{0x2cf4,0x436e},
{0x2cf9,0x506f},
{0x2cfd,0x4e6f},
{0x2cfe,0x506f},
{0x2d00,0x4c6c},
{0x2d26,0x436e},
{0x2d27,0x4c6c},
{0x2d28,0x436e},
{0x2d2d,0x4c6c},
{0x2d2e,0x436e},
{0x2d30,0x4c6f},
{0x2d68,0x436e},
{0x2d6f,0x4c6d},
{0x2d70,0x506f},
{0x2d71,0x436e},
{0x2d7f,0x4d6e},
{0x2d80,0x4c6f},
{0x2d97,0x436e},
{0x2da0,0x4c6f},
{0x2da7,0x436e},
{0x2da8,0x4c6f},
{0x2daf,0x436e},
{0x2db0,0x4c6f},
{0x2db7,0x436e},
{0x2db8,0x4c6f},
{0x2dbf,0x436e},
{0x2dc0,0x4c6f},
{0x2dc7,0x436e},
{0x2dc8,0x4c6f},
{0x2dcf,0x436e},
{0x2dd0,0x4c6f},
{0x2dd7,0x436e},
{0x2dd8,0x4c6f},
{0x2ddf,0x436e},
{0x2de0,0x4d6e},
{0x2e00,0x506f},
{0x2e02,0x5069},
{0x2e03,0x5066},
{0x2e04,0x5069},
{0x2e05,0x5066},
{0x2e06,0x506f},
{0x2e09,0x5069},
{0x2e0a,0x5066},
{0x2e0b,0x506f},
{0x2e0c,0x5069},
{0x2e0d,0x5066},
{0x2e0e,0x506f},
{0x2e17,0x5064},
{0x2e18,0x506f},
{0x2e1a,0x5064},
{0x2e1b,0x506f},
{0x2e1c,0x5069},
{0x2e1d,0x5066},
{0x2e1e,0x506f},
{0x2e20,0x5069},
{0x2e21,0x5066},
{0x2e22,0x5073},
{0x2e23,0x5065},
{0x2e24,0x5073},
{0x2e25,0x5065},
{0x2e26,0x5073},
{0x2e27,0x5065},
{0x2e28,0x5073},
{0x2e29,0x5065},
{0x2e2a,0x506f},
{0x2e2f,0x4c6d},
{0x2e30,0x506f},
{0x2e3a,0x5064},
{0x2e3c,0x506f},
{0x2e40,0x5064},
{0x2e41,0x506f},
{0x2e42,0x5073},
{0x2e43,0x436e},
{0x2e80,0x536f},
{0x2e9a,0x436e},
{0x2e9b,0x536f},
{0x2ef4,0x436e},
{0x2f00,0x536f},
{0x2fd6,0x436e},
{0x2ff0,0x536f},
{0x2ffc,0x436e},
{0x3000,0x5a73},
{0x3001,0x506f},
{0x3004,0x536f},
{0x3005,0x4c6d},
{0x3006,0x4c6f},
{0x3007,0x4e6c},
{0x3008,0x5073},
{0x3009,0x5065},
{0x300a,0x5073},
{0x300b,0x5065},
{0x300c,0x5073},
{0x300d,0x5065},
{0x300e,0x5073},
{0x300f,0x5065},
{0x3010,0x5073},
{0x3011,0x5065},
{0x3012,0x536f},
{0x3014,0x5073},
{0x3015,0x5065},
{0x3016,0x5073},
{0x3017,0x5065},
{0x3018,0x5073},
{0x3019,0x5065},
{0x301a,0x5073},
{0x301b,0x5065},
{0x301c,0x5064},
{0x301d,0x5073},
{0x301e,0x5065},
{0x3020,0x536f},
{0x3021,0x4e6c},
{0x302a,0x4d6e},
{0x302e,0x4d63},
{0x3030,0x5064},
{0x3031,0x4c6d},
{0x3036,0x536f},
{0x3038,0x4e6c},
{0x303b,0x4c6d},
{0x303c,0x4c6f},
{0x303d,0x506f},
{0x303e,0x536f},
{0x3040,0x436e},
{0x3041,0x4c6f},
{0x3097,0x436e},
{0x3099,0x4d6e},
{0x309b,0x536b},
{0x309d,0x4c6d},
{0x309f,0x4c6f},
{0x30a0,0x5064},
{0x30a1,0x4c6f},
{0x30fb,0x506f},
{0x30fc,0x4c6d},
{0x30ff,0x4c6f},
{0x3100,0x436e},
{0x3105,0x4c6f},
{0x312e,0x436e},
{0x3131,0x4c6f},
{0x318f,0x436e},
{0x3190,0x536f},
{0x3192,0x4e6f},
{0x3196,0x536f},
{0x31a0,0x4c6f},
{0x31bb,0x436e},
{0x31c0,0x536f},
{0x31e4,0x436e},
{0x31f0,0x4c6f},
{0x3200,0x536f},
{0x321f,0x436e},
{0x3220,0x4e6f},
{0x322a,0x536f},
{0x3248,0x4e6f},
{0x3250,0x536f},
{0x3251,0x4e6f},
{0x3260,0x536f},
{0x3280,0x4e6f},
{0x328a,0x536f},
{0x32b1,0x4e6f},
{0x32c0,0x536f},
{0x32ff,0x436e},
{0x3300,0x536f},
{0x3400,0x4c6f},
{0x4db6,0x436e},
{0x4dc0,0x536f},
{0x4e00,0x4c6f},
{0x9fd6,0x436e},
{0xa000,0x4c6f},
{0xa015,0x4c6d},
{0xa016,0x4c6f},
{0xa48d,0x436e},
{0xa490,0x536f},
{0xa4c7,0x436e},
{0xa4d0,0x4c6f},
{0xa4f8,0x4c6d},
{0xa4fe,0x506f},
{0xa500,0x4c6f},
{0xa60c,0x4c6d},
{0xa60d,0x506f},
{0xa610,0x4c6f},
{0xa620,0x4e64},
{0xa62a,0x4c6f},
{0xa62c,0x436e},
{0xa640,0x4c75},
{0xa641,0x4c6c},
{0xa642,0x4c75},
{0xa643,0x4c6c},
{0xa644,0x4c75},
{0xa645,0x4c6c},
{0xa646,0x4c75},
{0xa647,0x4c6c},
{0xa648,0x4c75},
{0xa649,0x4c6c},
{0xa64a,0x4c75},
{0xa64b,0x4c6c},
{0xa64c,0x4c75},
{0xa64d,0x4c6c},
{0xa64e,0x4c75},
{0xa64f,0x4c6c},
{0xa650,0x4c75},
{0xa651,0x4c6c},
{0xa652,0x4c75},
{0xa653,0x4c6c},
{0xa654,0x4c75},
{0xa655,0x4c6c},
{0xa656,0x4c75},
{0xa657,0x4c6c},
{0xa658,0x4c75},
{0xa659,0x4c6c},
{0xa65a,0x4c75},
{0xa65b,0x4c6c},
{0xa65c,0x4c75},
{0xa65d,0x4c6c},
{0xa65e,0x4c75},
{0xa65f,0x4c6c},
{0xa660,0x4c75},
{0xa661,0x4c6c},
{0xa662,0x4c75},
{0xa663,0x4c6c},
{0xa664,0x4c75},
{0xa665,0x4c6c},
{0xa666,0x4c75},
{0xa667,0x4c6c},
{0xa668,0x4c75},
{0xa669,0x4c6c},
{0xa66a,0x4c75},
{0xa66b,0x4c6c},
{0xa66c,0x4c75},
{0xa66d,0x4c6c},
{0xa66e,0x4c6f},
{0xa66f,0x4d6e},
{0xa670,0x4d65},
{0xa673,0x506f},
{0xa674,0x4d6e},
{0xa67e,0x506f},
{0xa67f,0x4c6d},
{0xa680,0x4c75},
{0xa681,0x4c6c},
{0xa682,0x4c75},
{0xa683,0x4c6c},
{0xa684,0x4c75},
{0xa685,0x4c6c},
{0xa686,0x4c75},
{0xa687,0x4c6c},
{0xa688,0x4c75},
{0xa689,0x4c6c},
{0xa68a,0x4c75},
{0xa68b,0x4c6c},
{0xa68c,0x4c75},
{0xa68d,0x4c6c},
{0xa68e,0x4c75},
{0xa68f,0x4c6c},
{0xa690,0x4c75},
{0xa691,0x4c6c},
{0xa692,0x4c75},
{0xa693,0x4c6c},
{0xa694,0x4c75},
{0xa695,0x4c6c},
{0xa696,0x4c75},
{0xa697,0x4c6c},
{0xa698,0x4c75},
{0xa699,0x4c6c},
{0xa69a,0x4c75},
{0xa69b,0x4c6c},
{0xa69c,0x4c6d},
{0xa69e,0x4d6e},
{0xa6a0,0x4c6f},
{0xa6e6,0x4e6c},
{0xa6f0,0x4d6e},
{0xa6f2,0x506f},
{0xa6f8,0x436e},
{0xa700,0x536b},
{0xa717,0x4c6d},
{0xa720,0x536b},
{0xa722,0x4c75},
{0xa723,0x4c6c},
{0xa724,0x4c75},
{0xa725,0x4c6c},
{0xa726,0x4c75},
{0xa727,0x4c6c},
{0xa728,0x4c75},
{0xa729,0x4c6c},
{0xa72a,0x4c75},
{0xa72b,0x4c6c},
{0xa72c,0x4c75},
{0xa72d,0x4c6c},
{0xa72e,0x4c75},
{0xa72f,0x4c6c},
{0xa732,0x4c75},
{0xa733,0x4c6c},
{0xa734,0x4c75},
{0xa735,0x4c6c},
{0xa736,0x4c75},
{0xa737,0x4c6c},
{0xa738,0x4c75},
{0xa739,0x4c6c},
{0xa73a,0x4c75},
{0xa73b,0x4c6c},
{0xa73c,0x4c75},
{0xa73d,0x4c6c},
{0xa73e,0x4c75},
{0xa73f,0x4c6c},
{0xa740,0x4c75},
{0xa741,0x4c6c},
{0xa742,0x4c75},
{0xa743,0x4c6c},
{0xa744,0x4c75},
{0xa745,0x4c6c},
{0xa746,0x4c75},
{0xa747,0x4c6c},
{0xa748,0x4c75},
{0xa749,0x4c6c},
{0xa74a,0x4c75},
{0xa74b,0x4c6c},
{0xa74c,0x4c75},
{0xa74d,0x4c6c},
{0xa74e,0x4c75},
{0xa74f,0x4c6c},
{0xa750,0x4c75},
{0xa751,0x4c6c},
{0xa752,0x4c75},
{0xa753,0x4c6c},
{0xa754,0x4c75},
{0xa755,0x4c6c},
{0xa756,0x4c75},
{0xa757,0x4c6c},
{0xa758,0x4c75},
{0xa759,0x4c6c},
{0xa75a,0x4c75},
{0xa75b,0x4c6c},
{0xa75c,0x4c75},
{0xa75d,0x4c6c},
{0xa75e,0x4c75},
{0xa75f,0x4c6c},
{0xa760,0x4c75},
{0xa761,0x4c6c},
{0xa762,0x4c75},
{0xa763,0x4c6c},
{0xa764,0x4c75},
{0xa765,0x4c6c},
{0xa766,0x4c75},
{0xa767,0x4c6c},
{0xa768,0x4c75},
{0xa769,0x4c6c},
{0xa76a,0x4c75},
{0xa76b,0x4c6c},
{0xa76c,0x4c75},
{0xa76d,0x4c6c},
{0xa76e,0x4c75},
{0xa76f,0x4c6c},
{0xa770,0x4c6d},
{0xa771,0x4c6c},
{0xa779,0x4c75},
{0xa77a,0x4c6c},
{0xa77b,0x4c75},
{0xa77c,0x4c6c},
{0xa77d,0x4c75},
{0xa77f,0x4c6c},
{0xa780,0x4c75},
{0xa781,0x4c6c},
{0xa782,0x4c75},
{0xa783,0x4c6c},
{0xa784,0x4c75},
{0xa785,0x4c6c},
{0xa786,0x4c75},
{0xa787,0x4c6c},
{0xa788,0x4c6d},
{0xa789,0x536b},
{0xa78b,0x4c75},
{0xa78c,0x4c6c},
{0xa78d,0x4c75},
{0xa78e,0x4c6c},
{0xa78f,0x4c6f},
{0xa790,0x4c75},
{0xa791,0x4c6c},
{0xa792,0x4c75},
{0xa793,0x4c6c},
{0xa796,0x4c75},
{0xa797,0x4c6c},
{0xa798,0x4c75},
{0xa799,0x4c6c},
{0xa79a,0x4c75},
{0xa79b,0x4c6c},
{0xa79c,0x4c75},
{0xa79d,0x4c6c},
{0xa79e,0x4c75},
{0xa79f,0x4c6c},
{0xa7a0,0x4c75},
{0xa7a1,0x4c6c},
{0xa7a2,0x4c75},
{0xa7a3,0x4c6c},
{0xa7a4,0x4c75},
{0xa7a5,0x4c6c},
{0xa7a6,0x4c75},
{0xa7a7,0x4c6c},
{0xa7a8,0x4c75},
{0xa7a9,0x4c6c},
{0xa7aa,0x4c75},
{0xa7ae,0x436e},
{0xa7b0,0x4c75},
{0xa7b5,0x4c6c},
{0xa7b6,0x4c75},
{0xa7b7,0x4c6c},
{0xa7b8,0x436e},
{0xa7f7,0x4c6f},
{0xa7f8,0x4c6d},
{0xa7fa,0x4c6c},
{0xa7fb,0x4c6f},
{0xa802,0x4d6e},
{0xa803,0x4c6f},
{0xa806,0x4d6e},
{0xa807,0x4c6f},
{0xa80b,0x4d6e},
{0xa80c,0x4c6f},
{0xa823,0x4d63},
{0xa825,0x4d6e},
{0xa827,0x4d63},
{0xa828,0x536f},
{0xa82c,0x436e},
{0xa830,0x4e6f},
{0xa836,0x536f},
{0xa838,0x5363},
{0xa839,0x536f},
{0xa83a,0x436e},
{0xa840,0x4c6f},
{0xa874,0x506f},
{0xa878,0x436e},
{0xa880,0x4d63},
{0xa882,0x4c6f},
{0xa8b4,0x4d63},
{0xa8c4,0x4d6e},
{0xa8c5,0x436e},
{0xa8ce,0x506f},
{0xa8d0,0x4e64},
{0xa8da,0x436e},
{0xa8e0,0x4d6e},
{0xa8f2,0x4c6f},
{0xa8f8,0x506f},
{0xa8fb,0x4c6f},
{0xa8fc,0x506f},
{0xa8fd,0x4c6f},
{0xa8fe,0x436e},
{0xa900,0x4e64},
{0xa90a,0x4c6f},
{0xa926,0x4d6e},
{0xa92e,0x506f},
{0xa930,0x4c6f},
{0xa947,0x4d6e},
{0xa952,0x4d63},
{0xa954,0x436e},
{0xa95f,0x506f},
{0xa960,0x4c6f},
{0xa97d,0x436e},
{0xa980,0x4d6e},
{0xa983,0x4d63},
{0xa984,0x4c6f},
{0xa9b3,0x4d6e},
{0xa9b4,0x4d63},
{0xa9b6,0x4d6e},
{0xa9ba,0x4d63},
{0xa9bc,0x4d6e},
{0xa9bd,0x4d63},
{0xa9c1,0x506f},
{0xa9ce,0x436e},
{0xa9cf,0x4c6d},
{0xa9d0,0x4e64},
{0xa9da,0x436e},
{0xa9de,0x506f},
{0xa9e0,0x4c6f},
{0xa9e5,0x4d6e},
{0xa9e6,0x4c6d},
{0xa9e7,0x4c6f},
{0xa9f0,0x4e64},
{0xa9fa,0x4c6f},
{0xa9ff,0x436e},
{0xaa00,0x4c6f},
{0xaa29,0x4d6e},
{0xaa2f,0x4d63},
{0xaa31,0x4d6e},
{0xaa33,0x4d63},
{0xaa35,0x4d6e},
{0xaa37,0x436e},
{0xaa40,0x4c6f},
{0xaa43,0x4d6e},
{0xaa44,0x4c6f},
{0xaa4c,0x4d6e},
{0xaa4d,0x4d63},
{0xaa4e,0x436e},
{0xaa50,0x4e64},
{0xaa5a,0x436e},
{0xaa5c,0x506f},
{0xaa60,0x4c6f},
{0xaa70,0x4c6d},
{0xaa71,0x4c6f},
{0xaa77,0x536f},
{0xaa7a,0x4c6f},
{0xaa7b,0x4d63},
{0xaa7c,0x4d6e},
{0xaa7d,0x4d63},
{0xaa7e,0x4c6f},
{0xaab0,0x4d6e},
{0xaab1,0x4c6f},
{0xaab2,0x4d6e},
{0xaab5,0x4c6f},
{0xaab7,0x4d6e},
{0xaab9,0x4c6f},
{0xaabe,0x4d6e},
{0xaac0,0x4c6f},
{0xaac1,0x4d6e},
{0xaac2,0x4c6f},
{0xaac3,0x436e},
{0xaadb,0x4c6f},
{0xaadd,0x4c6d},
{0xaade,0x506f},
{0xaae0,0x4c6f},
{0xaaeb,0x4d63},
{0xaaec,0x4d6e},
{0xaaee,0x4d63},
{0xaaf0,0x506f},
{0xaaf2,0x4c6f},
{0xaaf3,0x4c6d},
{0xaaf5,0x4d63},
{0xaaf6,0x4d6e},
{0xaaf7,0x436e},
{0xab01,0x4c6f},
{0xab07,0x436e},
{0xab09,0x4c6f},
{0xab0f,0x436e},
{0xab11,0x4c6f},
{0xab17,0x436e},
{0xab20,0x4c6f},
{0xab27,0x436e},
{0xab28,0x4c6f},
{0xab2f,0x436e},
{0xab30,0x4c6c},
{0xab5b,0x536b},
{0xab5c,0x4c6d},
{0xab60,0x4c6c},
{0xab66,0x436e},
{0xab70,0x4c6c},
{0xabc0,0x4c6f},
{0xabe3,0x4d63},
{0xabe5,0x4d6e},
{0xabe6,0x4d63},
{0xabe8,0x4d6e},
{0xabe9,0x4d63},
{0xabeb,0x506f},
{0xabec,0x4d63},
{0xabed,0x4d6e},
{0xabee,0x436e},
{0xabf0,0x4e64},
{0xabfa,0x436e},
{0xac00,0x4c6f},
{0xd7a4,0x436e},
{0xd7b0,0x4c6f},
{0xd7c7,0x436e},
{0xd7cb,0x4c6f},
{0xd7fc,0x436e},
{0xd800,0x4373},
{0xe000,0x436f},
{0xf900,0x4c6f},
{0xfa6e,0x436e},
{0xfa70,0x4c6f},
{0xfada,0x436e},
{0xfb00,0x4c6c},
{0xfb07,0x436e},
{0xfb13,0x4c6c},
{0xfb18,0x436e},
{0xfb1d,0x4c6f},
{0xfb1e,0x4d6e},
{0xfb1f,0x4c6f},
{0xfb29,0x536d},
{0xfb2a,0x4c6f},
{0xfb37,0x436e},
{0xfb38,0x4c6f},
{0xfb3d,0x436e},
{0xfb3e,0x4c6f},
{0xfb3f,0x436e},
{0xfb40,0x4c6f},
{0xfb42,0x436e},
{0xfb43,0x4c6f},
{0xfb45,0x436e},
{0xfb46,0x4c6f},
{0xfbb2,0x536b},
{0xfbc2,0x436e},
{0xfbd3,0x4c6f},
{0xfd3e,0x5065},
{0xfd3f,0x5073},
{0xfd40,0x436e},
{0xfd50,0x4c6f},
{0xfd90,0x436e},
{0xfd92,0x4c6f},
{0xfdc8,0x436e},
{0xfdf0,0x4c6f},
{0xfdfc,0x5363},
{0xfdfd,0x536f},
{0xfdfe,0x436e},
{0xfe00,0x4d6e},
{0xfe10,0x506f},
{0xfe17,0x5073},
{0xfe18,0x5065},
{0xfe19,0x506f},
{0xfe1a,0x436e},
{0xfe20,0x4d6e},
{0xfe30,0x506f},
{0xfe31,0x5064},
{0xfe33,0x5063},
{0xfe35,0x5073},
{0xfe36,0x5065},
{0xfe37,0x5073},
{0xfe38,0x5065},
{0xfe39,0x5073},
{0xfe3a,0x5065},
{0xfe3b,0x5073},
{0xfe3c,0x5065},
{0xfe3d,0x5073},
{0xfe3e,0x5065},
{0xfe3f,0x5073},
{0xfe40,0x5065},
{0xfe41,0x5073},
{0xfe42,0x5065},
{0xfe43,0x5073},
{0xfe44,0x5065},
{0xfe45,0x506f},
{0xfe47,0x5073},
{0xfe48,0x5065},
{0xfe49,0x506f},
{0xfe4d,0x5063},
{0xfe50,0x506f},
{0xfe53,0x436e},
{0xfe54,0x506f},
{0xfe58,0x5064},
{0xfe59,0x5073},
{0xfe5a,0x5065},
{0xfe5b,0x5073},
{0xfe5c,0x5065},
{0xfe5d,0x5073},
{0xfe5e,0x5065},
{0xfe5f,0x506f},
{0xfe62,0x536d},
{0xfe63,0x5064},
{0xfe64,0x536d},
{0xfe67,0x436e},
{0xfe68,0x506f},
{0xfe69,0x5363},
{0xfe6a,0x506f},
{0xfe6c,0x436e},
{0xfe70,0x4c6f},
{0xfe75,0x436e},
{0xfe76,0x4c6f},
{0xfefd,0x436e},
{0xfeff,0x4366},
{0xff00,0x436e},
{0xff01,0x506f},
{0xff04,0x5363},
{0xff05,0x506f},
{0xff08,0x5073},
{0xff09,0x5065},
{0xff0a,0x506f},
{0xff0b,0x536d},
{0xff0c,0x506f},
{0xff0d,0x5064},
{0xff0e,0x506f},
{0xff10,0x4e64},
{0xff1a,0x506f},
{0xff1c,0x536d},
{0xff1f,0x506f},
{0xff21,0x4c75},
{0xff3b,0x5073},
{0xff3c,0x506f},
{0xff3d,0x5065},
{0xff3e,0x536b},
{0xff3f,0x5063},
{0xff40,0x536b},
{0xff41,0x4c6c},
{0xff5b,0x5073},
{0xff5c,0x536d},
{0xff5d,0x5065},
{0xff5e,0x536d},
{0xff5f,0x5073},
{0xff60,0x5065},
{0xff61,0x506f},
{0xff62,0x5073},
{0xff63,0x5065},
{0xff64,0x506f},
{0xff66,0x4c6f},
{0xff70,0x4c6d},
{0xff71,0x4c6f},
{0xff9e,0x4c6d},
{0xffa0,0x4c6f},
{0xffbf,0x436e},
{0xffc2,0x4c6f},
{0xffc8,0x436e},
{0xffca,0x4c6f},
{0xffd0,0x436e},
{0xffd2,0x4c6f},
{0xffd8,0x436e},
{0xffda,0x4c6f},
{0xffdd,0x436e},
{0xffe0,0x5363},
{0xffe2,0x536d},
{0xffe3,0x536b},
{0xffe4,0x536f},
{0xffe5,0x5363},
{0xffe7,0x436e},
{0xffe8,0x536f},
{0xffe9,0x536d},
{0xffed,0x536f},
{0xffef,0x436e},
{0xfff9,0x4366},
{0xfffc,0x536f},
{0xfffe,0x436e},
{0x10000,0x4c6f},
{0x1000c,0x436e},
{0x1000d,0x4c6f},
{0x10027,0x436e},
{0x10028,0x4c6f},
{0x1003b,0x436e},
{0x1003c,0x4c6f},
{0x1003e,0x436e},
{0x1003f,0x4c6f},
{0x1004e,0x436e},
{0x10050,0x4c6f},
{0x1005e,0x436e},
{0x10080,0x4c6f},
{0x100fb,0x436e},
{0x10100,0x506f},
{0x10103,0x436e},
{0x10107,0x4e6f},
{0x10134,0x436e},
{0x10137,0x536f},
{0x10140,0x4e6c},
{0x10175,0x4e6f},
{0x10179,0x536f},
{0x1018a,0x4e6f},
{0x1018c,0x536f},
{0x1018d,0x436e},
{0x10190,0x536f},
{0x1019c,0x436e},
{0x101a0,0x536f},
{0x101a1,0x436e},
{0x101d0,0x536f},
{0x101fd,0x4d6e},
{0x101fe,0x436e},
{0x10280,0x4c6f},
{0x1029d,0x436e},
{0x102a0,0x4c6f},
{0x102d1,0x436e},
{0x102e0,0x4d6e},
{0x102e1,0x4e6f},
{0x102fc,0x436e},
{0x10300,0x4c6f},
{0x10320,0x4e6f},
{0x10324,0x436e},
{0x10330,0x4c6f},
{0x10341,0x4e6c},
{0x10342,0x4c6f},
{0x1034a,0x4e6c},
{0x1034b,0x436e},
{0x10350,0x4c6f},
{0x10376,0x4d6e},
{0x1037b,0x436e},
{0x10380,0x4c6f},
{0x1039e,0x436e},
{0x1039f,0x506f},
{0x103a0,0x4c6f},
{0x103c4,0x436e},
{0x103c8,0x4c6f},
{0x103d0,0x506f},
{0x103d1,0x4e6c},
{0x103d6,0x436e},
{0x10400,0x4c75},
{0x10428,0x4c6c},
{0x10450,0x4c6f},
{0x1049e,0x436e},
{0x104a0,0x4e64},
{0x104aa,0x436e},
{0x10500,0x4c6f},
{0x10528,0x436e},
{0x10530,0x4c6f},
{0x10564,0x436e},
{0x1056f,0x506f},
{0x10570,0x436e},
{0x10600,0x4c6f},
{0x10737,0x436e},
{0x10740,0x4c6f},
{0x10756,0x436e},
{0x10760,0x4c6f},
{0x10768,0x436e},
{0x10800,0x4c6f},
{0x10806,0x436e},
{0x10808,0x4c6f},
{0x10809,0x436e},
{0x1080a,0x4c6f},
{0x10836,0x436e},
{0x10837,0x4c6f},
{0x10839,0x436e},
{0x1083c,0x4c6f},
{0x1083d,0x436e},
{0x1083f,0x4c6f},
{0x10856,0x436e},
{0x10857,0x506f},
{0x10858,0x4e6f},
{0x10860,0x4c6f},
{0x10877,0x536f},
{0x10879,0x4e6f},
{0x10880,0x4c6f},
{0x1089f,0x436e},
{0x108a7,0x4e6f},
{0x108b0,0x436e},
{0x108e0,0x4c6f},
{0x108f3,0x436e},
{0x108f4,0x4c6f},
{0x108f6,0x436e},
{0x108fb,0x4e6f},
{0x10900,0x4c6f},
{0x10916,0x4e6f},
{0x1091c,0x436e},
{0x1091f,0x506f},
{0x10920,0x4c6f},
{0x1093a,0x436e},
{0x1093f,0x506f},
{0x10940,0x436e},
{0x10980,0x4c6f},
{0x109b8,0x436e},
{0x109bc,0x4e6f},
{0x109be,0x4c6f},
{0x109c0,0x4e6f},
{0x109d0,0x436e},
{0x109d2,0x4e6f},
{0x10a00,0x4c6f},
{0x10a01,0x4d6e},
{0x10a04,0x436e},
{0x10a05,0x4d6e},
{0x10a07,0x436e},
{0x10a0c,0x4d6e},
{0x10a10,0x4c6f},
{0x10a14,0x436e},
{0x10a15,0x4c6f},
{0x10a18,0x436e},
{0x10a19,0x4c6f},
{0x10a34,0x436e},
{0x10a38,0x4d6e},
{0x10a3b,0x436e},
{0x10a3f,0x4d6e},
{0x10a40,0x4e6f},
{0x10a48,0x436e},
{0x10a50,0x506f},
{0x10a59,0x436e},
{0x10a60,0x4c6f},
{0x10a7d,0x4e6f},
{0x10a7f,0x506f},
{0x10a80,0x4c6f},
{0x10a9d,0x4e6f},
{0x10aa0,0x436e},
{0x10ac0,0x4c6f},
{0x10ac8,0x536f},
{0x10ac9,0x4c6f},
{0x10ae5,0x4d6e},
{0x10ae7,0x436e},
{0x10aeb,0x4e6f},
{0x10af0,0x506f},
{0x10af7,0x436e},
{0x10b00,0x4c6f},
{0x10b36,0x436e},
{0x10b39,0x506f},
{0x10b40,0x4c6f},
{0x10b56,0x436e},
{0x10b58,0x4e6f},
{0x10b60,0x4c6f},
{0x10b73,0x436e},
{0x10b78,0x4e6f},
{0x10b80,0x4c6f},
{0x10b92,0x436e},
{0x10b99,0x506f},
{0x10b9d,0x436e},
{0x10ba9,0x4e6f},
{0x10bb0,0x436e},
{0x10c00,0x4c6f},
{0x10c49,0x436e},
{0x10c80,0x4c75},
{0x10cb3,0x436e},
{0x10cc0,0x4c6c},
{0x10cf3,0x436e},
{0x10cfa,0x4e6f},
{0x10d00,0x436e},
{0x10e60,0x4e6f},
{0x10e7f,0x436e},
{0x11000,0x4d63},
{0x11001,0x4d6e},
{0x11002,0x4d63},
{0x11003,0x4c6f},
{0x11038,0x4d6e},
{0x11047,0x506f},
{0x1104e,0x436e},
{0x11052,0x4e6f},
{0x11066,0x4e64},
{0x11070,0x436e},
{0x1107f,0x4d6e},
{0x11082,0x4d63},
{0x11083,0x4c6f},
{0x110b0,0x4d63},
{0x110b3,0x4d6e},
{0x110b7,0x4d63},
{0x110b9,0x4d6e},
{0x110bb,0x506f},
{0x110bd,0x4366},
{0x110be,0x506f},
{0x110c2,0x436e},
{0x110d0,0x4c6f},
{0x110e9,0x436e},
{0x110f0,0x4e64},
{0x110fa,0x436e},
{0x11100,0x4d6e},
{0x11103,0x4c6f},
{0x11127,0x4d6e},
{0x1112c,0x4d63},
{0x1112d,0x4d6e},
{0x11135,0x436e},
{0x11136,0x4e64},
{0x11140,0x506f},
{0x11144,0x436e},
{0x11150,0x4c6f},
{0x11173,0x4d6e},
{0x11174,0x506f},
{0x11176,0x4c6f},
{0x11177,0x436e},
{0x11180,0x4d6e},
{0x11182,0x4d63},
{0x11183,0x4c6f},
{0x111b3,0x4d63},
{0x111b6,0x4d6e},
{0x111bf,0x4d63},
{0x111c1,0x4c6f},
{0x111c5,0x506f},
{0x111ca,0x4d6e},
{0x111cd,0x506f},
{0x111ce,0x436e},
{0x111d0,0x4e64},
{0x111da,0x4c6f},
{0x111db,0x506f},
{0x111dc,0x4c6f},
{0x111dd,0x506f},
{0x111e0,0x436e},
{0x111e1,0x4e6f},
{0x111f5,0x436e},
{0x11200,0x4c6f},
{0x11212,0x436e},
{0x11213,0x4c6f},
{0x1122c,0x4d63},
{0x1122f,0x4d6e},
{0x11232,0x4d63},
{0x11234,0x4d6e},
{0x11235,0x4d63},
{0x11236,0x4d6e},
{0x11238,0x506f},
{0x1123e,0x436e},
{0x11280,0x4c6f},
{0x11287,0x436e},
{0x11288,0x4c6f},
{0x11289,0x436e},
{0x1128a,0x4c6f},
{0x1128e,0x436e},
{0x1128f,0x4c6f},
{0x1129e,0x436e},
{0x1129f,0x4c6f},
{0x112a9,0x506f},
{0x112aa,0x436e},
{0x112b0,0x4c6f},
{0x112df,0x4d6e},
{0x112e0,0x4d63},
{0x112e3,0x4d6e},
{0x112eb,0x436e},
{0x112f0,0x4e64},
{0x112fa,0x436e},
{0x11300,0x4d6e},
{0x11302,0x4d63},
{0x11304,0x436e},
{0x11305,0x4c6f},
{0x1130d,0x436e},
{0x1130f,0x4c6f},
{0x11311,0x436e},
{0x11313,0x4c6f},
{0x11329,0x436e},
{0x1132a,0x4c6f},
{0x11331,0x436e},
{0x11332,0x4c6f},
{0x11334,0x436e},
{0x11335,0x4c6f},
{0x1133a,0x436e},
{0x1133c,0x4d6e},
{0x1133d,0x4c6f},
{0x1133e,0x4d63},
{0x11340,0x4d6e},
{0x11341,0x4d63},
{0x11345,0x436e},
{0x11347,0x4d63},
{0x11349,0x436e},
{0x1134b,0x4d63},
{0x1134e,0x436e},
{0x11350,0x4c6f},
{0x11351,0x436e},
{0x11357,0x4d63},
{0x11358,0x436e},
{0x1135d,0x4c6f},
{0x11362,0x4d63},
{0x11364,0x436e},
{0x11366,0x4d6e},
{0x1136d,0x436e},
{0x11370,0x4d6e},
{0x11375,0x436e},
{0x11480,0x4c6f},
{0x114b0,0x4d63},
{0x114b3,0x4d6e},
{0x114b9,0x4d63},
{0x114ba,0x4d6e},
{0x114bb,0x4d63},
{0x114bf,0x4d6e},
{0x114c1,0x4d63},
{0x114c2,0x4d6e},
{0x114c4,0x4c6f},
{0x114c6,0x506f},
{0x114c7,0x4c6f},
{0x114c8,0x436e},
{0x114d0,0x4e64},
{0x114da,0x436e},
{0x11580,0x4c6f},
{0x115af,0x4d63},
{0x115b2,0x4d6e},
{0x115b6,0x436e},
{0x115b8,0x4d63},
{0x115bc,0x4d6e},
{0x115be,0x4d63},
{0x115bf,0x4d6e},
{0x115c1,0x506f},
{0x115d8,0x4c6f},
{0x115dc,0x4d6e},
{0x115de,0x436e},
{0x11600,0x4c6f},
{0x11630,0x4d63},
{0x11633,0x4d6e},
{0x1163b,0x4d63},
{0x1163d,0x4d6e},
{0x1163e,0x4d63},
{0x1163f,0x4d6e},
{0x11641,0x506f},
{0x11644,0x4c6f},
{0x11645,0x436e},
{0x11650,0x4e64},
{0x1165a,0x436e},
{0x11680,0x4c6f},
{0x116ab,0x4d6e},
{0x116ac,0x4d63},
{0x116ad,0x4d6e},
{0x116ae,0x4d63},
{0x116b0,0x4d6e},
{0x116b6,0x4d63},
{0x116b7,0x4d6e},
{0x116b8,0x436e},
{0x116c0,0x4e64},
{0x116ca,0x436e},
{0x11700,0x4c6f},
{0x1171a,0x436e},
{0x1171d,0x4d6e},
{0x11720,0x4d63},
{0x11722,0x4d6e},
{0x11726,0x4d63},
{0x11727,0x4d6e},
{0x1172c,0x436e},
{0x11730,0x4e64},
{0x1173a,0x4e6f},
{0x1173c,0x506f},
{0x1173f,0x536f},
{0x11740,0x436e},
{0x118a0,0x4c75},
{0x118c0,0x4c6c},
{0x118e0,0x4e64},
{0x118ea,0x4e6f},
{0x118f3,0x436e},
{0x118ff,0x4c6f},
{0x11900,0x436e},
{0x11ac0,0x4c6f},
{0x11af9,0x436e},
{0x12000,0x4c6f},
{0x1239a,0x436e},
{0x12400,0x4e6c},
{0x1246f,0x436e},
{0x12470,0x506f},
{0x12475,0x436e},
{0x12480,0x4c6f},
{0x12544,0x436e},
{0x13000,0x4c6f},
{0x1342f,0x436e},
{0x14400,0x4c6f},
{0x14647,0x436e},
{0x16800,0x4c6f},
{0x16a39,0x436e},
{0x16a40,0x4c6f},
{0x16a5f,0x436e},
{0x16a60,0x4e64},
{0x16a6a,0x436e},
{0x16a6e,0x506f},
{0x16a70,0x436e},
{0x16ad0,0x4c6f},
{0x16aee,0x436e},
{0x16af0,0x4d6e},
{0x16af5,0x506f},
{0x16af6,0x436e},
{0x16b00,0x4c6f},
{0x16b30,0x4d6e},
{0x16b37,0x506f},
{0x16b3c,0x536f},
{0x16b40,0x4c6d},
{0x16b44,0x506f},
{0x16b45,0x536f},
{0x16b46,0x436e},
{0x16b50,0x4e64},
{0x16b5a,0x436e},
{0x16b5b,0x4e6f},
{0x16b62,0x436e},
{0x16b63,0x4c6f},
{0x16b78,0x436e},
{0x16b7d,0x4c6f},
{0x16b90,0x436e},
{0x16f00,0x4c6f},
{0x16f45,0x436e},
{0x16f50,0x4c6f},
{0x16f51,0x4d63},
{0x16f7f,0x436e},
{0x16f8f,0x4d6e},
{0x16f93,0x4c6d},
{0x16fa0,0x436e},
{0x1b000,0x4c6f},
{0x1b002,0x436e},
{0x1bc00,0x4c6f},
{0x1bc6b,0x436e},
{0x1bc70,0x4c6f},
{0x1bc7d,0x436e},
{0x1bc80,0x4c6f},
{0x1bc89,0x436e},
{0x1bc90,0x4c6f},
{0x1bc9a,0x436e},
{0x1bc9c,0x536f},
{0x1bc9d,0x4d6e},
{0x1bc9f,0x506f},
{0x1bca0,0x4366},
{0x1bca4,0x436e},
{0x1d000,0x536f},
{0x1d0f6,0x436e},
{0x1d100,0x536f},
{0x1d127,0x436e},
{0x1d129,0x536f},
{0x1d165,0x4d63},
{0x1d167,0x4d6e},
{0x1d16a,0x536f},
{0x1d16d,0x4d63},
{0x1d173,0x4366},
{0x1d17b,0x4d6e},
{0x1d183,0x536f},
{0x1d185,0x4d6e},
{0x1d18c,0x536f},
{0x1d1aa,0x4d6e},
{0x1d1ae,0x536f},
{0x1d1e9,0x436e},
{0x1d200,0x536f},
{0x1d242,0x4d6e},
{0x1d245,0x536f},
{0x1d246,0x436e},
{0x1d300,0x536f},
{0x1d357,0x436e},
{0x1d360,0x4e6f},
{0x1d372,0x436e},
{0x1d400,0x4c75},
{0x1d41a,0x4c6c},
{0x1d434,0x4c75},
{0x1d44e,0x4c6c},
{0x1d455,0x436e},
{0x1d456,0x4c6c},
{0x1d468,0x4c75},
{0x1d482,0x4c6c},
{0x1d49c,0x4c75},
{0x1d49d,0x436e},
{0x1d49e,0x4c75},
{0x1d4a0,0x436e},
{0x1d4a2,0x4c75},
{0x1d4a3,0x436e},
{0x1d4a5,0x4c75},
{0x1d4a7,0x436e},
{0x1d4a9,0x4c75},
{0x1d4ad,0x436e},
{0x1d4ae,0x4c75},
{0x1d4b6,0x4c6c},
{0x1d4ba,0x436e},
{0x1d4bb,0x4c6c},
{0x1d4bc,0x436e},
{0x1d4bd,0x4c6c},
{0x1d4c4,0x436e},
{0x1d4c5,0x4c6c},
{0x1d4d0,0x4c75},
{0x1d4ea,0x4c6c},
{0x1d504,0x4c75},
{0x1d506,0x436e},
{0x1d507,0x4c75},
{0x1d50b,0x436e},
{0x1d50d,0x4c75},
{0x1d515,0x436e},
{0x1d516,0x4c75},
{0x1d51d,0x436e},
{0x1d51e,0x4c6c},
{0x1d538,0x4c75},
{0x1d53a,0x436e},
{0x1d53b,0x4c75},
{0x1d53f,0x436e},
{0x1d540,0x4c75},
{0x1d545,0x436e},
{0x1d546,0x4c75},
{0x1d547,0x436e},
{0x1d54a,0x4c75},
{0x1d551,0x436e},
{0x1d552,0x4c6c},
{0x1d56c,0x4c75},
{0x1d586,0x4c6c},
{0x1d5a0,0x4c75},
{0x1d5ba,0x4c6c},
{0x1d5d4,0x4c75},
{0x1d5ee,0x4c6c},
{0x1d608,0x4c75},
{0x1d622,0x4c6c},
{0x1d63c,0x4c75},
{0x1d656,0x4c6c},
{0x1d670,0x4c75},
{0x1d68a,0x4c6c},
{0x1d6a6,0x436e},
{0x1d6a8,0x4c75},
{0x1d6c1,0x536d},
{0x1d6c2,0x4c6c},
{0x1d6db,0x536d},
{0x1d6dc,0x4c6c},
{0x1d6e2,0x4c75},
{0x1d6fb,0x536d},
{0x1d6fc,0x4c6c},
{0x1d715,0x536d},
{0x1d716,0x4c6c},
{0x1d71c,0x4c75},
{0x1d735,0x536d},
{0x1d736,0x4c6c},
{0x1d74f,0x536d},
{0x1d750,0x4c6c},
{0x1d756,0x4c75},
{0x1d76f,0x536d},
{0x1d770,0x4c6c},
{0x1d789,0x536d},
{0x1d78a,0x4c6c},
{0x1d790,0x4c75},
{0x1d7a9,0x536d},
{0x1d7aa,0x4c6c},
{0x1d7c3,0x536d},
{0x1d7c4,0x4c6c},
{0x1d7ca,0x4c75},
{0x1d7cb,0x4c6c},
{0x1d7cc,0x436e},
{0x1d7ce,0x4e64},
{0x1d800,0x536f},
{0x1da00,0x4d6e},
{0x1da37,0x536f},
{0x1da3b,0x4d6e},
{0x1da6d,0x536f},
{0x1da75,0x4d6e},
{0x1da76,0x536f},
{0x1da84,0x4d6e},
{0x1da85,0x536f},
{0x1da87,0x506f},
{0x1da8c,0x436e},
{0x1da9b,0x4d6e},
{0x1daa0,0x436e},
{0x1daa1,0x4d6e},
{0x1dab0,0x436e},
{0x1e800,0x4c6f},
{0x1e8c5,0x436e},
{0x1e8c7,0x4e6f},
{0x1e8d0,0x4d6e},
{0x1e8d7,0x436e},
{0x1ee00,0x4c6f},
{0x1ee04,0x436e},
{0x1ee05,0x4c6f},
{0x1ee20,0x436e},
{0x1ee21,0x4c6f},
{0x1ee23,0x436e},
{0x1ee24,0x4c6f},
{0x1ee25,0x436e},
{0x1ee27,0x4c6f},
{0x1ee28,0x436e},
{0x1ee29,0x4c6f},
{0x1ee33,0x436e},
{0x1ee34,0x4c6f},
{0x1ee38,0x436e},
{0x1ee39,0x4c6f},
{0x1ee3a,0x436e},
{0x1ee3b,0x4c6f},
{0x1ee3c,0x436e},
{0x1ee42,0x4c6f},
{0x1ee43,0x436e},
{0x1ee47,0x4c6f},
{0x1ee48,0x436e},
{0x1ee49,0x4c6f},
{0x1ee4a,0x436e},
{0x1ee4b,0x4c6f},
{0x1ee4c,0x436e},
{0x1ee4d,0x4c6f},
{0x1ee50,0x436e},
{0x1ee51,0x4c6f},
{0x1ee53,0x436e},
{0x1ee54,0x4c6f},
{0x1ee55,0x436e},
{0x1ee57,0x4c6f},
{0x1ee58,0x436e},
{0x1ee59,0x4c6f},
{0x1ee5a,0x436e},
{0x1ee5b,0x4c6f},
{0x1ee5c,0x436e},
{0x1ee5d,0x4c6f},
{0x1ee5e,0x436e},
{0x1ee5f,0x4c6f},
{0x1ee60,0x436e},
{0x1ee61,0x4c6f},
{0x1ee63,0x436e},
{0x1ee64,0x4c6f},
{0x1ee65,0x436e},
{0x1ee67,0x4c6f},
{0x1ee6b,0x436e},
{0x1ee6c,0x4c6f},
{0x1ee73,0x436e},
{0x1ee74,0x4c6f},
{0x1ee78,0x436e},
{0x1ee79,0x4c6f},
{0x1ee7d,0x436e},
{0x1ee7e,0x4c6f},
{0x1ee7f,0x436e},
{0x1ee80,0x4c6f},
{0x1ee8a,0x436e},
{0x1ee8b,0x4c6f},
{0x1ee9c,0x436e},
{0x1eea1,0x4c6f},
{0x1eea4,0x436e},
{0x1eea5,0x4c6f},
{0x1eeaa,0x436e},
{0x1eeab,0x4c6f},
{0x1eebc,0x436e},
{0x1eef0,0x536d},
{0x1eef2,0x436e},
{0x1f000,0x536f},
{0x1f02c,0x436e},
{0x1f030,0x536f},
{0x1f094,0x436e},
{0x1f0a0,0x536f},
{0x1f0af,0x436e},
{0x1f0b1,0x536f},
{0x1f0c0,0x436e},
{0x1f0c1,0x536f},
{0x1f0d0,0x436e},
{0x1f0d1,0x536f},
{0x1f0f6,0x436e},
{0x1f100,0x4e6f},
{0x1f10d,0x436e},
{0x1f110,0x536f},
{0x1f12f,0x436e},
{0x1f130,0x536f},
{0x1f16c,0x436e},
{0x1f170,0x536f},
{0x1f19b,0x436e},
{0x1f1e6,0x536f},
{0x1f203,0x436e},
{0x1f210,0x536f},
{0x1f23b,0x436e},
{0x1f240,0x536f},
{0x1f249,0x436e},
{0x1f250,0x536f},
{0x1f252,0x436e},
{0x1f300,0x536f},
{0x1f3fb,0x536b},
{0x1f400,0x536f},
{0x1f57a,0x436e},
{0x1f57b,0x536f},
{0x1f5a4,0x436e},
{0x1f5a5,0x536f},
{0x1f6d1,0x436e},
{0x1f6e0,0x536f},
{0x1f6ed,0x436e},
{0x1f6f0,0x536f},
{0x1f6f4,0x436e},
{0x1f700,0x536f},
{0x1f774,0x436e},
{0x1f780,0x536f},
{0x1f7d5,0x436e},
{0x1f800,0x536f},
{0x1f80c,0x436e},
{0x1f810,0x536f},
{0x1f848,0x436e},
{0x1f850,0x536f},
{0x1f85a,0x436e},
{0x1f860,0x536f},
{0x1f888,0x436e},
{0x1f890,0x536f},
{0x1f8ae,0x436e},
{0x1f910,0x536f},
{0x1f919,0x436e},
{0x1f980,0x536f},
{0x1f985,0x436e},
{0x1f9c0,0x536f},
{0x1f9c1,0x436e},
{0x20000,0x4c6f},
{0x2a6d7,0x436e},
{0x2a700,0x4c6f},
{0x2b735,0x436e},
{0x2b740,0x4c6f},
{0x2b81e,0x436e},
{0x2b820,0x4c6f},
{0x2cea2,0x436e},
{0x2f800,0x4c6f},
{0x2fa1e,0x436e},
{0xe0001,0x4366},
{0xe0002,0x436e},
{0xe0020,0x4366},
{0xe0080,0x436e},
{0xe0100,0x4d6e},
{0xe01f0,0x436e},
{0xf0000,0x436f},
{0xffffe,0x436e},
{0x100000,0x436f},
{0x10fffe,0x436e},
}};

const TableView<char32_t, uint16_t> general_category_table {&general_category_array[0], &general_category_array[0] + general_category_array.size()};

const std::array<KeyValue<char32_t, Joining_Type>, 161> joining_type_array = {{
{0x0,static_cast<Joining_Type>(0)},
{0x600,Joining_Type::Non_Joining},
{0x606,static_cast<Joining_Type>(0)},
{0x608,Joining_Type::Non_Joining},
{0x609,static_cast<Joining_Type>(0)},
{0x60b,Joining_Type::Non_Joining},
{0x60c,static_cast<Joining_Type>(0)},
{0x620,Joining_Type::Dual_Joining},
{0x621,Joining_Type::Non_Joining},
{0x622,Joining_Type::Right_Joining},
{0x626,Joining_Type::Dual_Joining},
{0x627,Joining_Type::Right_Joining},
{0x628,Joining_Type::Dual_Joining},
{0x629,Joining_Type::Right_Joining},
{0x62a,Joining_Type::Dual_Joining},
{0x62f,Joining_Type::Right_Joining},
{0x633,Joining_Type::Dual_Joining},
{0x640,Joining_Type::Join_Causing},
{0x641,Joining_Type::Dual_Joining},
{0x648,Joining_Type::Right_Joining},
{0x649,Joining_Type::Dual_Joining},
{0x64b,static_cast<Joining_Type>(0)},
{0x66e,Joining_Type::Dual_Joining},
{0x670,static_cast<Joining_Type>(0)},
{0x671,Joining_Type::Right_Joining},
{0x674,Joining_Type::Non_Joining},
{0x675,Joining_Type::Right_Joining},
{0x678,Joining_Type::Dual_Joining},
{0x688,Joining_Type::Right_Joining},
{0x69a,Joining_Type::Dual_Joining},
{0x6c0,Joining_Type::Right_Joining},
{0x6c1,Joining_Type::Dual_Joining},
{0x6c3,Joining_Type::Right_Joining},
{0x6cc,Joining_Type::Dual_Joining},
{0x6cd,Joining_Type::Right_Joining},
{0x6ce,Joining_Type::Dual_Joining},
{0x6cf,Joining_Type::Right_Joining},
{0x6d0,Joining_Type::Dual_Joining},
{0x6d2,Joining_Type::Right_Joining},
{0x6d4,static_cast<Joining_Type>(0)},
{0x6d5,Joining_Type::Right_Joining},
{0x6d6,static_cast<Joining_Type>(0)},
{0x6dd,Joining_Type::Non_Joining},
{0x6de,static_cast<Joining_Type>(0)},
{0x6ee,Joining_Type::Right_Joining},
{0x6f0,static_cast<Joining_Type>(0)},
{0x6fa,Joining_Type::Dual_Joining},
{0x6fd,static_cast<Joining_Type>(0)},
{0x6ff,Joining_Type::Dual_Joining},
{0x700,static_cast<Joining_Type>(0)},
{0x710,Joining_Type::Right_Joining},
{0x711,static_cast<Joining_Type>(0)},
{0x712,Joining_Type::Dual_Joining},
{0x715,Joining_Type::Right_Joining},
{0x71a,Joining_Type::Dual_Joining},
{0x71e,Joining_Type::Right_Joining},
{0x71f,Joining_Type::Dual_Joining},
{0x728,Joining_Type::Right_Joining},
{0x729,Joining_Type::Dual_Joining},
{0x72a,Joining_Type::Right_Joining},
{0x72b,Joining_Type::Dual_Joining},
{0x72c,Joining_Type::Right_Joining},
{0x72d,Joining_Type::Dual_Joining},
{0x72f,Joining_Type::Right_Joining},
{0x730,static_cast<Joining_Type>(0)},
{0x74d,Joining_Type::Right_Joining},
{0x74e,Joining_Type::Dual_Joining},
{0x759,Joining_Type::Right_Joining},
{0x75c,Joining_Type::Dual_Joining},
{0x76b,Joining_Type::Right_Joining},
{0x76d,Joining_Type::Dual_Joining},
{0x771,Joining_Type::Right_Joining},
{0x772,Joining_Type::Dual_Joining},
{0x773,Joining_Type::Right_Joining},
{0x775,Joining_Type::Dual_Joining},
{0x778,Joining_Type::Right_Joining},
{0x77a,Joining_Type::Dual_Joining},
{0x780,static_cast<Joining_Type>(0)},
{0x7ca,Joining_Type::Dual_Joining},
{0x7eb,static_cast<Joining_Type>(0)},
{0x7fa,Joining_Type::Join_Causing},
{0x7fb,static_cast<Joining_Type>(0)},
{0x840,Joining_Type::Right_Joining},
{0x841,Joining_Type::Dual_Joining},
{0x846,Joining_Type::Right_Joining},
{0x848,Joining_Type::Dual_Joining},
{0x849,Joining_Type::Right_Joining},
{0x84a,Joining_Type::Dual_Joining},
{0x854,Joining_Type::Right_Joining},
{0x855,Joining_Type::Dual_Joining},
{0x856,Joining_Type::Non_Joining},
{0x859,static_cast<Joining_Type>(0)},
{0x8a0,Joining_Type::Dual_Joining},
{0x8aa,Joining_Type::Right_Joining},
{0x8ad,Joining_Type::Non_Joining},
{0x8ae,Joining_Type::Right_Joining},
{0x8af,Joining_Type::Dual_Joining},
{0x8b1,Joining_Type::Right_Joining},
{0x8b3,Joining_Type::Dual_Joining},
{0x8b5,static_cast<Joining_Type>(0)},
{0x1806,Joining_Type::Non_Joining},
{0x1807,Joining_Type::Dual_Joining},
{0x1808,static_cast<Joining_Type>(0)},
{0x180a,Joining_Type::Join_Causing},
{0x180b,static_cast<Joining_Type>(0)},
{0x180e,Joining_Type::Non_Joining},
{0x180f,static_cast<Joining_Type>(0)},
{0x1820,Joining_Type::Dual_Joining},
{0x1878,static_cast<Joining_Type>(0)},
{0x1880,Joining_Type::Non_Joining},
{0x1887,Joining_Type::Dual_Joining},
{0x18a9,static_cast<Joining_Type>(0)},
{0x18aa,Joining_Type::Dual_Joining},
{0x18ab,static_cast<Joining_Type>(0)},
{0x200c,Joining_Type::Non_Joining},
{0x200d,Joining_Type::Join_Causing},
{0x200e,static_cast<Joining_Type>(0)},
{0x2066,Joining_Type::Non_Joining},
{0x206a,static_cast<Joining_Type>(0)},
{0xa840,Joining_Type::Dual_Joining},
{0xa872,Joining_Type::Left_Joining},
{0xa873,Joining_Type::Non_Joining},
{0xa874,static_cast<Joining_Type>(0)},
{0x10ac0,Joining_Type::Dual_Joining},
{0x10ac5,Joining_Type::Right_Joining},
{0x10ac6,Joining_Type::Non_Joining},
{0x10ac7,Joining_Type::Right_Joining},
{0x10ac8,Joining_Type::Non_Joining},
{0x10ac9,Joining_Type::Right_Joining},
{0x10acb,Joining_Type::Non_Joining},
{0x10acd,Joining_Type::Left_Joining},
{0x10ace,Joining_Type::Right_Joining},
{0x10ad3,Joining_Type::Dual_Joining},
{0x10ad7,Joining_Type::Left_Joining},
{0x10ad8,Joining_Type::Dual_Joining},
{0x10add,Joining_Type::Right_Joining},
{0x10ade,Joining_Type::Dual_Joining},
{0x10ae1,Joining_Type::Right_Joining},
{0x10ae2,Joining_Type::Non_Joining},
{0x10ae4,Joining_Type::Right_Joining},
{0x10ae5,static_cast<Joining_Type>(0)},
{0x10aeb,Joining_Type::Dual_Joining},
{0x10aef,Joining_Type::Right_Joining},
{0x10af0,static_cast<Joining_Type>(0)},
{0x10b80,Joining_Type::Dual_Joining},
{0x10b81,Joining_Type::Right_Joining},
{0x10b82,Joining_Type::Dual_Joining},
{0x10b83,Joining_Type::Right_Joining},
{0x10b86,Joining_Type::Dual_Joining},
{0x10b89,Joining_Type::Right_Joining},
{0x10b8a,Joining_Type::Dual_Joining},
{0x10b8c,Joining_Type::Right_Joining},
{0x10b8d,Joining_Type::Dual_Joining},
{0x10b8e,Joining_Type::Right_Joining},
{0x10b90,Joining_Type::Dual_Joining},
{0x10b91,Joining_Type::Right_Joining},
{0x10b92,static_cast<Joining_Type>(0)},
{0x10ba9,Joining_Type::Right_Joining},
{0x10bad,Joining_Type::Dual_Joining},
{0x10baf,Joining_Type::Non_Joining},
{0x10bb0,static_cast<Joining_Type>(0)},
}};

const TableView<char32_t, Joining_Type> joining_type_table {&joining_type_array[0], &joining_type_array[0] + joining_type_array.size()};

const std::array<KeyValue<char32_t, Joining_Group>, 193> joining_group_array = {{
{0x0,static_cast<Joining_Group>(0)},
{0x620,Joining_Group::Yeh},
{0x621,static_cast<Joining_Group>(0)},
{0x622,Joining_Group::Alef},
{0x624,Joining_Group::Waw},
{0x625,Joining_Group::Alef},
{0x626,Joining_Group::Yeh},
{0x627,Joining_Group::Alef},
{0x628,Joining_Group::Beh},
{0x629,Joining_Group::Teh_Marbuta},
{0x62a,Joining_Group::Beh},
{0x62c,Joining_Group::Hah},
{0x62f,Joining_Group::Dal},
{0x631,Joining_Group::Reh},
{0x633,Joining_Group::Seen},
{0x635,Joining_Group::Sad},
{0x637,Joining_Group::Tah},
{0x639,Joining_Group::Ain},
{0x63b,Joining_Group::Gaf},
{0x63d,Joining_Group::Farsi_Yeh},
{0x640,static_cast<Joining_Group>(0)},
{0x641,Joining_Group::Feh},
{0x642,Joining_Group::Qaf},
{0x643,Joining_Group::Kaf},
{0x644,Joining_Group::Lam},
{0x645,Joining_Group::Meem},
{0x646,Joining_Group::Noon},
{0x647,Joining_Group::Heh},
{0x648,Joining_Group::Waw},
{0x649,Joining_Group::Yeh},
{0x64b,static_cast<Joining_Group>(0)},
{0x66e,Joining_Group::Beh},
{0x66f,Joining_Group::Qaf},
{0x670,static_cast<Joining_Group>(0)},
{0x671,Joining_Group::Alef},
{0x674,static_cast<Joining_Group>(0)},
{0x675,Joining_Group::Alef},
{0x676,Joining_Group::Waw},
{0x678,Joining_Group::Yeh},
{0x679,Joining_Group::Beh},
{0x681,Joining_Group::Hah},
{0x688,Joining_Group::Dal},
{0x691,Joining_Group::Reh},
{0x69a,Joining_Group::Seen},
{0x69d,Joining_Group::Sad},
{0x69f,Joining_Group::Tah},
{0x6a0,Joining_Group::Ain},
{0x6a1,Joining_Group::Feh},
{0x6a7,Joining_Group::Qaf},
{0x6a9,Joining_Group::Gaf},
{0x6aa,Joining_Group::Swash_Kaf},
{0x6ab,Joining_Group::Gaf},
{0x6ac,Joining_Group::Kaf},
{0x6af,Joining_Group::Gaf},
{0x6b5,Joining_Group::Lam},
{0x6b9,Joining_Group::Noon},
{0x6bd,Joining_Group::Nya},
{0x6be,Joining_Group::Knotted_Heh},
{0x6bf,Joining_Group::Hah},
{0x6c0,Joining_Group::Teh_Marbuta},
{0x6c1,Joining_Group::Heh_Goal},
{0x6c3,Joining_Group::Teh_Marbuta_Goal},
{0x6c4,Joining_Group::Waw},
{0x6cc,Joining_Group::Farsi_Yeh},
{0x6cd,Joining_Group::Yeh_With_Tail},
{0x6ce,Joining_Group::Farsi_Yeh},
{0x6cf,Joining_Group::Waw},
{0x6d0,Joining_Group::Yeh},
{0x6d2,Joining_Group::Yeh_Barree},
{0x6d4,static_cast<Joining_Group>(0)},
{0x6d5,Joining_Group::Teh_Marbuta},
{0x6d6,static_cast<Joining_Group>(0)},
{0x6ee,Joining_Group::Dal},
{0x6ef,Joining_Group::Reh},
{0x6f0,static_cast<Joining_Group>(0)},
{0x6fa,Joining_Group::Seen},
{0x6fb,Joining_Group::Sad},
{0x6fc,Joining_Group::Ain},
{0x6fd,static_cast<Joining_Group>(0)},
{0x6ff,Joining_Group::Knotted_Heh},
{0x700,static_cast<Joining_Group>(0)},
{0x710,Joining_Group::Alaph},
{0x711,static_cast<Joining_Group>(0)},
{0x712,Joining_Group::Beth},
{0x713,Joining_Group::Gamal},
{0x715,Joining_Group::Dalath_Rish},
{0x717,Joining_Group::He},
{0x718,Joining_Group::Syriac_Waw},
{0x719,Joining_Group::Zain},
{0x71a,Joining_Group::Heth},
{0x71b,Joining_Group::Teth},
{0x71d,Joining_Group::Yudh},
{0x71e,Joining_Group::Yudh_He},
{0x71f,Joining_Group::Kaph},
{0x720,Joining_Group::Lamadh},
{0x721,Joining_Group::Mim},
{0x722,Joining_Group::Nun},
{0x723,Joining_Group::Semkath},
{0x724,Joining_Group::Final_Semkath},
{0x725,Joining_Group::E},
{0x726,Joining_Group::Pe},
{0x727,Joining_Group::Reversed_Pe},
{0x728,Joining_Group::Sadhe},
{0x729,Joining_Group::Qaph},
{0x72a,Joining_Group::Dalath_Rish},
{0x72b,Joining_Group::Shin},
{0x72c,Joining_Group::Taw},
{0x72d,Joining_Group::Beth},
{0x72e,Joining_Group::Gamal},
{0x72f,Joining_Group::Dalath_Rish},
{0x730,static_cast<Joining_Group>(0)},
{0x74d,Joining_Group::Zhain},
{0x74e,Joining_Group::Khaph},
{0x74f,Joining_Group::Fe},
{0x750,Joining_Group::Beh},
{0x757,Joining_Group::Hah},
{0x759,Joining_Group::Dal},
{0x75b,Joining_Group::Reh},
{0x75c,Joining_Group::Seen},
{0x75d,Joining_Group::Ain},
{0x760,Joining_Group::Feh},
{0x762,Joining_Group::Gaf},
{0x765,Joining_Group::Meem},
{0x767,Joining_Group::Noon},
{0x76a,Joining_Group::Lam},
{0x76b,Joining_Group::Reh},
{0x76d,Joining_Group::Seen},
{0x76e,Joining_Group::Hah},
{0x770,Joining_Group::Seen},
{0x771,Joining_Group::Reh},
{0x772,Joining_Group::Hah},
{0x773,Joining_Group::Alef},
{0x775,Joining_Group::Farsi_Yeh},
{0x777,Joining_Group::Yeh},
{0x778,Joining_Group::Waw},
{0x77a,Joining_Group::Burushaski_Yeh_Barree},
{0x77c,Joining_Group::Hah},
{0x77d,Joining_Group::Seen},
{0x77f,Joining_Group::Kaf},
{0x780,static_cast<Joining_Group>(0)},
{0x8a0,Joining_Group::Beh},
{0x8a2,Joining_Group::Hah},
{0x8a3,Joining_Group::Tah},
{0x8a4,Joining_Group::Feh},
{0x8a5,Joining_Group::Qaf},
{0x8a6,Joining_Group::Lam},
{0x8a7,Joining_Group::Meem},
{0x8a8,Joining_Group::Yeh},
{0x8aa,Joining_Group::Reh},
{0x8ab,Joining_Group::Waw},
{0x8ac,Joining_Group::Rohingya_Yeh},
{0x8ad,static_cast<Joining_Group>(0)},
{0x8ae,Joining_Group::Dal},
{0x8af,Joining_Group::Sad},
{0x8b0,Joining_Group::Gaf},
{0x8b1,Joining_Group::Straight_Waw},
{0x8b2,Joining_Group::Reh},
{0x8b3,Joining_Group::Ain},
{0x8b4,Joining_Group::Kaf},
{0x8b5,static_cast<Joining_Group>(0)},
{0x10ac0,Joining_Group::Manichaean_Aleph},
{0x10ac1,Joining_Group::Manichaean_Beth},
{0x10ac3,Joining_Group::Manichaean_Gimel},
{0x10ac5,Joining_Group::Manichaean_Daleth},
{0x10ac6,static_cast<Joining_Group>(0)},
{0x10ac7,Joining_Group::Manichaean_Waw},
{0x10ac8,static_cast<Joining_Group>(0)},
{0x10ac9,Joining_Group::Manichaean_Zayin},
{0x10acb,static_cast<Joining_Group>(0)},
{0x10acd,Joining_Group::Manichaean_Heth},
{0x10ace,Joining_Group::Manichaean_Teth},
{0x10acf,Joining_Group::Manichaean_Yodh},
{0x10ad0,Joining_Group::Manichaean_Kaph},
{0x10ad3,Joining_Group::Manichaean_Lamedh},
{0x10ad4,Joining_Group::Manichaean_Dhamedh},
{0x10ad5,Joining_Group::Manichaean_Thamedh},
{0x10ad6,Joining_Group::Manichaean_Mem},
{0x10ad7,Joining_Group::Manichaean_Nun},
{0x10ad8,Joining_Group::Manichaean_Samekh},
{0x10ad9,Joining_Group::Manichaean_Ayin},
{0x10adb,Joining_Group::Manichaean_Pe},
{0x10add,Joining_Group::Manichaean_Sadhe},
{0x10ade,Joining_Group::Manichaean_Qoph},
{0x10ae1,Joining_Group::Manichaean_Resh},
{0x10ae2,static_cast<Joining_Group>(0)},
{0x10ae4,Joining_Group::Manichaean_Taw},
{0x10ae5,static_cast<Joining_Group>(0)},
{0x10aeb,Joining_Group::Manichaean_One},
{0x10aec,Joining_Group::Manichaean_Five},
{0x10aed,Joining_Group::Manichaean_Ten},
{0x10aee,Joining_Group::Manichaean_Twenty},
{0x10aef,Joining_Group::Manichaean_Hundred},
{0x10af0,static_cast<Joining_Group>(0)},
}};

const TableView<char32_t, Joining_Group> joining_group_table {&joining_group_array[0], &joining_group_array[0] + joining_group_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 17> default_ignorable_array = {{
{0xad,0xad},
{0x34f,0x34f},
{0x61c,0x61c},
{0x115f,0x1160},
{0x17b4,0x17b5},
{0x180b,0x180e},
{0x200b,0x200f},
{0x202a,0x202e},
{0x2060,0x206f},
{0x3164,0x3164},
{0xfe00,0xfe0f},
{0xfeff,0xfeff},
{0xffa0,0xffa0},
{0xfff0,0xfff8},
{0x1bca0,0x1bca3},
{0x1d173,0x1d17a},
{0xe0000,0xe0fff},
}};

const TableView<char32_t, char32_t> default_ignorable_table {&default_ignorable_array[0], &default_ignorable_array[0] + default_ignorable_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 31> soft_dotted_array = {{
{0x69,0x6a},
{0x12f,0x12f},
{0x249,0x249},
{0x268,0x268},
{0x29d,0x29d},
{0x2b2,0x2b2},
{0x3f3,0x3f3},
{0x456,0x456},
{0x458,0x458},
{0x1d62,0x1d62},
{0x1d96,0x1d96},
{0x1da4,0x1da4},
{0x1da8,0x1da8},
{0x1e2d,0x1e2d},
{0x1ecb,0x1ecb},
{0x2071,0x2071},
{0x2148,0x2149},
{0x2c7c,0x2c7c},
{0x1d422,0x1d423},
{0x1d456,0x1d457},
{0x1d48a,0x1d48b},
{0x1d4be,0x1d4bf},
{0x1d4f2,0x1d4f3},
{0x1d526,0x1d527},
{0x1d55a,0x1d55b},
{0x1d58e,0x1d58f},
{0x1d5c2,0x1d5c3},
{0x1d5f6,0x1d5f7},
{0x1d62a,0x1d62b},
{0x1d65e,0x1d65f},
{0x1d692,0x1d693},
}};

const TableView<char32_t, char32_t> soft_dotted_table {&soft_dotted_array[0], &soft_dotted_array[0] + soft_dotted_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 10> white_space_array = {{
{0x9,0xd},
{0x20,0x20},
{0x85,0x85},
{0xa0,0xa0},
{0x1680,0x1680},
{0x2000,0x200a},
{0x2028,0x2029},
{0x202f,0x202f},
{0x205f,0x205f},
{0x3000,0x3000},
}};

const TableView<char32_t, char32_t> white_space_table {&white_space_array[0], &white_space_array[0] + white_space_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 555> id_start_array = {{
{0x41,0x5a},
{0x61,0x7a},
{0xaa,0xaa},
{0xb5,0xb5},
{0xba,0xba},
{0xc0,0xd6},
{0xd8,0xf6},
{0xf8,0x2c1},
{0x2c6,0x2d1},
{0x2e0,0x2e4},
{0x2ec,0x2ec},
{0x2ee,0x2ee},
{0x370,0x374},
{0x376,0x377},
{0x37a,0x37d},
{0x37f,0x37f},
{0x386,0x386},
{0x388,0x38a},
{0x38c,0x38c},
{0x38e,0x3a1},
{0x3a3,0x3f5},
{0x3f7,0x481},
{0x48a,0x52f},
{0x531,0x556},
{0x559,0x559},
{0x561,0x587},
{0x5d0,0x5ea},
{0x5f0,0x5f2},
{0x620,0x64a},
{0x66e,0x66f},
{0x671,0x6d3},
{0x6d5,0x6d5},
{0x6e5,0x6e6},
{0x6ee,0x6ef},
{0x6fa,0x6fc},
{0x6ff,0x6ff},
{0x710,0x710},
{0x712,0x72f},
{0x74d,0x7a5},
{0x7b1,0x7b1},
{0x7ca,0x7ea},
{0x7f4,0x7f5},
{0x7fa,0x7fa},
{0x800,0x815},
{0x81a,0x81a},
{0x824,0x824},
{0x828,0x828},
{0x840,0x858},
{0x8a0,0x8b4},
{0x904,0x939},
{0x93d,0x93d},
{0x950,0x950},
{0x958,0x961},
{0x971,0x980},
{0x985,0x98c},
{0x98f,0x990},
{0x993,0x9a8},
{0x9aa,0x9b0},
{0x9b2,0x9b2},
{0x9b6,0x9b9},
{0x9bd,0x9bd},
{0x9ce,0x9ce},
{0x9dc,0x9dd},
{0x9df,0x9e1},
{0x9f0,0x9f1},
{0xa05,0xa0a},
{0xa0f,0xa10},
{0xa13,0xa28},
{0xa2a,0xa30},
{0xa32,0xa33},
{0xa35,0xa36},
{0xa38,0xa39},
{0xa59,0xa5c},
{0xa5e,0xa5e},
{0xa72,0xa74},
{0xa85,0xa8d},
{0xa8f,0xa91},
{0xa93,0xaa8},
{0xaaa,0xab0},
{0xab2,0xab3},
{0xab5,0xab9},
{0xabd,0xabd},
{0xad0,0xad0},
{0xae0,0xae1},
{0xaf9,0xaf9},
{0xb05,0xb0c},
{0xb0f,0xb10},
{0xb13,0xb28},
{0xb2a,0xb30},
{0xb32,0xb33},
{0xb35,0xb39},
{0xb3d,0xb3d},
{0xb5c,0xb5d},
{0xb5f,0xb61},
{0xb71,0xb71},
{0xb83,0xb83},
{0xb85,0xb8a},
{0xb8e,0xb90},
{0xb92,0xb95},
{0xb99,0xb9a},
{0xb9c,0xb9c},
{0xb9e,0xb9f},
{0xba3,0xba4},
{0xba8,0xbaa},
{0xbae,0xbb9},
{0xbd0,0xbd0},
{0xc05,0xc0c},
{0xc0e,0xc10},
{0xc12,0xc28},
{0xc2a,0xc39},
{0xc3d,0xc3d},
{0xc58,0xc5a},
{0xc60,0xc61},
{0xc85,0xc8c},
{0xc8e,0xc90},
{0xc92,0xca8},
{0xcaa,0xcb3},
{0xcb5,0xcb9},
{0xcbd,0xcbd},
{0xcde,0xcde},
{0xce0,0xce1},
{0xcf1,0xcf2},
{0xd05,0xd0c},
{0xd0e,0xd10},
{0xd12,0xd3a},
{0xd3d,0xd3d},
{0xd4e,0xd4e},
{0xd5f,0xd61},
{0xd7a,0xd7f},
{0xd85,0xd96},
{0xd9a,0xdb1},
{0xdb3,0xdbb},
{0xdbd,0xdbd},
{0xdc0,0xdc6},
{0xe01,0xe30},
{0xe32,0xe33},
{0xe40,0xe46},
{0xe81,0xe82},
{0xe84,0xe84},
{0xe87,0xe88},
{0xe8a,0xe8a},
{0xe8d,0xe8d},
{0xe94,0xe97},
{0xe99,0xe9f},
{0xea1,0xea3},
{0xea5,0xea5},
{0xea7,0xea7},
{0xeaa,0xeab},
{0xead,0xeb0},
{0xeb2,0xeb3},
{0xebd,0xebd},
{0xec0,0xec4},
{0xec6,0xec6},
{0xedc,0xedf},
{0xf00,0xf00},
{0xf40,0xf47},
{0xf49,0xf6c},
{0xf88,0xf8c},
{0x1000,0x102a},
{0x103f,0x103f},
{0x1050,0x1055},
{0x105a,0x105d},
{0x1061,0x1061},
{0x1065,0x1066},
{0x106e,0x1070},
{0x1075,0x1081},
{0x108e,0x108e},
{0x10a0,0x10c5},
{0x10c7,0x10c7},
{0x10cd,0x10cd},
{0x10d0,0x10fa},
{0x10fc,0x1248},
{0x124a,0x124d},
{0x1250,0x1256},
{0x1258,0x1258},
{0x125a,0x125d},
{0x1260,0x1288},
{0x128a,0x128d},
{0x1290,0x12b0},
{0x12b2,0x12b5},
{0x12b8,0x12be},
{0x12c0,0x12c0},
{0x12c2,0x12c5},
{0x12c8,0x12d6},
{0x12d8,0x1310},
{0x1312,0x1315},
{0x1318,0x135a},
{0x1380,0x138f},
{0x13a0,0x13f5},
{0x13f8,0x13fd},
{0x1401,0x166c},
{0x166f,0x167f},
{0x1681,0x169a},
{0x16a0,0x16ea},
{0x16ee,0x16f8},
{0x1700,0x170c},
{0x170e,0x1711},
{0x1720,0x1731},
{0x1740,0x1751},
{0x1760,0x176c},
{0x176e,0x1770},
{0x1780,0x17b3},
{0x17d7,0x17d7},
{0x17dc,0x17dc},
{0x1820,0x1877},
{0x1880,0x18a8},
{0x18aa,0x18aa},
{0x18b0,0x18f5},
{0x1900,0x191e},
{0x1950,0x196d},
{0x1970,0x1974},
{0x1980,0x19ab},
{0x19b0,0x19c9},
{0x1a00,0x1a16},
{0x1a20,0x1a54},
{0x1aa7,0x1aa7},
{0x1b05,0x1b33},
{0x1b45,0x1b4b},
{0x1b83,0x1ba0},
{0x1bae,0x1baf},
{0x1bba,0x1be5},
{0x1c00,0x1c23},
{0x1c4d,0x1c4f},
{0x1c5a,0x1c7d},
{0x1ce9,0x1cec},
{0x1cee,0x1cf1},
{0x1cf5,0x1cf6},
{0x1d00,0x1dbf},
{0x1e00,0x1f15},
{0x1f18,0x1f1d},
{0x1f20,0x1f45},
{0x1f48,0x1f4d},
{0x1f50,0x1f57},
{0x1f59,0x1f59},
{0x1f5b,0x1f5b},
{0x1f5d,0x1f5d},
{0x1f5f,0x1f7d},
{0x1f80,0x1fb4},
{0x1fb6,0x1fbc},
{0x1fbe,0x1fbe},
{0x1fc2,0x1fc4},
{0x1fc6,0x1fcc},
{0x1fd0,0x1fd3},
{0x1fd6,0x1fdb},
{0x1fe0,0x1fec},
{0x1ff2,0x1ff4},
{0x1ff6,0x1ffc},
{0x2071,0x2071},
{0x207f,0x207f},
{0x2090,0x209c},
{0x2102,0x2102},
{0x2107,0x2107},
{0x210a,0x2113},
{0x2115,0x2115},
{0x2118,0x211d},
{0x2124,0x2124},
{0x2126,0x2126},
{0x2128,0x2128},
{0x212a,0x2139},
{0x213c,0x213f},
{0x2145,0x2149},
{0x214e,0x214e},
{0x2160,0x2188},
{0x2c00,0x2c2e},
{0x2c30,0x2c5e},
{0x2c60,0x2ce4},
{0x2ceb,0x2cee},
{0x2cf2,0x2cf3},
{0x2d00,0x2d25},
{0x2d27,0x2d27},
{0x2d2d,0x2d2d},
{0x2d30,0x2d67},
{0x2d6f,0x2d6f},
{0x2d80,0x2d96},
{0x2da0,0x2da6},
{0x2da8,0x2dae},
{0x2db0,0x2db6},
{0x2db8,0x2dbe},
{0x2dc0,0x2dc6},
{0x2dc8,0x2dce},
{0x2dd0,0x2dd6},
{0x2dd8,0x2dde},
{0x3005,0x3007},
{0x3021,0x3029},
{0x3031,0x3035},
{0x3038,0x303c},
{0x3041,0x3096},
{0x309b,0x309f},
{0x30a1,0x30fa},
{0x30fc,0x30ff},
{0x3105,0x312d},
{0x3131,0x318e},
{0x31a0,0x31ba},
{0x31f0,0x31ff},
{0x3400,0x4db5},
{0x4e00,0x9fd5},
{0xa000,0xa48c},
{0xa4d0,0xa4fd},
{0xa500,0xa60c},
{0xa610,0xa61f},
{0xa62a,0xa62b},
{0xa640,0xa66e},
{0xa67f,0xa69d},
{0xa6a0,0xa6ef},
{0xa717,0xa71f},
{0xa722,0xa788},
{0xa78b,0xa7ad},
{0xa7b0,0xa7b7},
{0xa7f7,0xa801},
{0xa803,0xa805},
{0xa807,0xa80a},
{0xa80c,0xa822},
{0xa840,0xa873},
{0xa882,0xa8b3},
{0xa8f2,0xa8f7},
{0xa8fb,0xa8fb},
{0xa8fd,0xa8fd},
{0xa90a,0xa925},
{0xa930,0xa946},
{0xa960,0xa97c},
{0xa984,0xa9b2},
{0xa9cf,0xa9cf},
{0xa9e0,0xa9e4},
{0xa9e6,0xa9ef},
{0xa9fa,0xa9fe},
{0xaa00,0xaa28},
{0xaa40,0xaa42},
{0xaa44,0xaa4b},
{0xaa60,0xaa76},
{0xaa7a,0xaa7a},
{0xaa7e,0xaaaf},
{0xaab1,0xaab1},
{0xaab5,0xaab6},
{0xaab9,0xaabd},
{0xaac0,0xaac0},
{0xaac2,0xaac2},
{0xaadb,0xaadd},
{0xaae0,0xaaea},
{0xaaf2,0xaaf4},
{0xab01,0xab06},
{0xab09,0xab0e},
{0xab11,0xab16},
{0xab20,0xab26},
{0xab28,0xab2e},
{0xab30,0xab5a},
{0xab5c,0xab65},
{0xab70,0xabe2},
{0xac00,0xd7a3},
{0xd7b0,0xd7c6},
{0xd7cb,0xd7fb},
{0xf900,0xfa6d},
{0xfa70,0xfad9},
{0xfb00,0xfb06},
{0xfb13,0xfb17},
{0xfb1d,0xfb1d},
{0xfb1f,0xfb28},
{0xfb2a,0xfb36},
{0xfb38,0xfb3c},
{0xfb3e,0xfb3e},
{0xfb40,0xfb41},
{0xfb43,0xfb44},
{0xfb46,0xfbb1},
{0xfbd3,0xfd3d},
{0xfd50,0xfd8f},
{0xfd92,0xfdc7},
{0xfdf0,0xfdfb},
{0xfe70,0xfe74},
{0xfe76,0xfefc},
{0xff21,0xff3a},
{0xff41,0xff5a},
{0xff66,0xffbe},
{0xffc2,0xffc7},
{0xffca,0xffcf},
{0xffd2,0xffd7},
{0xffda,0xffdc},
{0x10000,0x1000b},
{0x1000d,0x10026},
{0x10028,0x1003a},
{0x1003c,0x1003d},
{0x1003f,0x1004d},
{0x10050,0x1005d},
{0x10080,0x100fa},
{0x10140,0x10174},
{0x10280,0x1029c},
{0x102a0,0x102d0},
{0x10300,0x1031f},
{0x10330,0x1034a},
{0x10350,0x10375},
{0x10380,0x1039d},
{0x103a0,0x103c3},
{0x103c8,0x103cf},
{0x103d1,0x103d5},
{0x10400,0x1049d},
{0x10500,0x10527},
{0x10530,0x10563},
{0x10600,0x10736},
{0x10740,0x10755},
{0x10760,0x10767},
{0x10800,0x10805},
{0x10808,0x10808},
{0x1080a,0x10835},
{0x10837,0x10838},
{0x1083c,0x1083c},
{0x1083f,0x10855},
{0x10860,0x10876},
{0x10880,0x1089e},
{0x108e0,0x108f2},
{0x108f4,0x108f5},
{0x10900,0x10915},
{0x10920,0x10939},
{0x10980,0x109b7},
{0x109be,0x109bf},
{0x10a00,0x10a00},
{0x10a10,0x10a13},
{0x10a15,0x10a17},
{0x10a19,0x10a33},
{0x10a60,0x10a7c},
{0x10a80,0x10a9c},
{0x10ac0,0x10ac7},
{0x10ac9,0x10ae4},
{0x10b00,0x10b35},
{0x10b40,0x10b55},
{0x10b60,0x10b72},
{0x10b80,0x10b91},
{0x10c00,0x10c48},
{0x10c80,0x10cb2},
{0x10cc0,0x10cf2},
{0x11003,0x11037},
{0x11083,0x110af},
{0x110d0,0x110e8},
{0x11103,0x11126},
{0x11150,0x11172},
{0x11176,0x11176},
{0x11183,0x111b2},
{0x111c1,0x111c4},
{0x111da,0x111da},
{0x111dc,0x111dc},
{0x11200,0x11211},
{0x11213,0x1122b},
{0x11280,0x11286},
{0x11288,0x11288},
{0x1128a,0x1128d},
{0x1128f,0x1129d},
{0x1129f,0x112a8},
{0x112b0,0x112de},
{0x11305,0x1130c},
{0x1130f,0x11310},
{0x11313,0x11328},
{0x1132a,0x11330},
{0x11332,0x11333},
{0x11335,0x11339},
{0x1133d,0x1133d},
{0x11350,0x11350},
{0x1135d,0x11361},
{0x11480,0x114af},
{0x114c4,0x114c5},
{0x114c7,0x114c7},
{0x11580,0x115ae},
{0x115d8,0x115db},
{0x11600,0x1162f},
{0x11644,0x11644},
{0x11680,0x116aa},
{0x11700,0x11719},
{0x118a0,0x118df},
{0x118ff,0x118ff},
{0x11ac0,0x11af8},
{0x12000,0x12399},
{0x12400,0x1246e},
{0x12480,0x12543},
{0x13000,0x1342e},
{0x14400,0x14646},
{0x16800,0x16a38},
{0x16a40,0x16a5e},
{0x16ad0,0x16aed},
{0x16b00,0x16b2f},
{0x16b40,0x16b43},
{0x16b63,0x16b77},
{0x16b7d,0x16b8f},
{0x16f00,0x16f44},
{0x16f50,0x16f50},
{0x16f93,0x16f9f},
{0x1b000,0x1b001},
{0x1bc00,0x1bc6a},
{0x1bc70,0x1bc7c},
{0x1bc80,0x1bc88},
{0x1bc90,0x1bc99},
{0x1d400,0x1d454},
{0x1d456,0x1d49c},
{0x1d49e,0x1d49f},
{0x1d4a2,0x1d4a2},
{0x1d4a5,0x1d4a6},
{0x1d4a9,0x1d4ac},
{0x1d4ae,0x1d4b9},
{0x1d4bb,0x1d4bb},
{0x1d4bd,0x1d4c3},
{0x1d4c5,0x1d505},
{0x1d507,0x1d50a},
{0x1d50d,0x1d514},
{0x1d516,0x1d51c},
{0x1d51e,0x1d539},
{0x1d53b,0x1d53e},
{0x1d540,0x1d544},
{0x1d546,0x1d546},
{0x1d54a,0x1d550},
{0x1d552,0x1d6a5},
{0x1d6a8,0x1d6c0},
{0x1d6c2,0x1d6da},
{0x1d6dc,0x1d6fa},
{0x1d6fc,0x1d714},
{0x1d716,0x1d734},
{0x1d736,0x1d74e},
{0x1d750,0x1d76e},
{0x1d770,0x1d788},
{0x1d78a,0x1d7a8},
{0x1d7aa,0x1d7c2},
{0x1d7c4,0x1d7cb},
{0x1e800,0x1e8c4},
{0x1ee00,0x1ee03},
{0x1ee05,0x1ee1f},
{0x1ee21,0x1ee22},
{0x1ee24,0x1ee24},
{0x1ee27,0x1ee27},
{0x1ee29,0x1ee32},
{0x1ee34,0x1ee37},
{0x1ee39,0x1ee39},
{0x1ee3b,0x1ee3b},
{0x1ee42,0x1ee42},
{0x1ee47,0x1ee47},
{0x1ee49,0x1ee49},
{0x1ee4b,0x1ee4b},
{0x1ee4d,0x1ee4f},
{0x1ee51,0x1ee52},
{0x1ee54,0x1ee54},
{0x1ee57,0x1ee57},
{0x1ee59,0x1ee59},
{0x1ee5b,0x1ee5b},
{0x1ee5d,0x1ee5d},
{0x1ee5f,0x1ee5f},
{0x1ee61,0x1ee62},
{0x1ee64,0x1ee64},
{0x1ee67,0x1ee6a},
{0x1ee6c,0x1ee72},
{0x1ee74,0x1ee77},
{0x1ee79,0x1ee7c},
{0x1ee7e,0x1ee7e},
{0x1ee80,0x1ee89},
{0x1ee8b,0x1ee9b},
{0x1eea1,0x1eea3},
{0x1eea5,0x1eea9},
{0x1eeab,0x1eebb},
{0x20000,0x2a6d6},
{0x2a700,0x2b734},
{0x2b740,0x2b81d},
{0x2b820,0x2cea1},
{0x2f800,0x2fa1d},
}};

const TableView<char32_t, char32_t> id_start_table {&id_start_array[0], &id_start_array[0] + id_start_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 293> id_nonstart_array = {{
{0x30,0x39},
{0x5f,0x5f},
{0xb7,0xb7},
{0x300,0x36f},
{0x387,0x387},
{0x483,0x487},
{0x591,0x5bd},
{0x5bf,0x5bf},
{0x5c1,0x5c2},
{0x5c4,0x5c5},
{0x5c7,0x5c7},
{0x610,0x61a},
{0x64b,0x669},
{0x670,0x670},
{0x6d6,0x6dc},
{0x6df,0x6e4},
{0x6e7,0x6e8},
{0x6ea,0x6ed},
{0x6f0,0x6f9},
{0x711,0x711},
{0x730,0x74a},
{0x7a6,0x7b0},
{0x7c0,0x7c9},
{0x7eb,0x7f3},
{0x816,0x819},
{0x81b,0x823},
{0x825,0x827},
{0x829,0x82d},
{0x859,0x85b},
{0x8e3,0x903},
{0x93a,0x93c},
{0x93e,0x94f},
{0x951,0x957},
{0x962,0x963},
{0x966,0x96f},
{0x981,0x983},
{0x9bc,0x9bc},
{0x9be,0x9c4},
{0x9c7,0x9c8},
{0x9cb,0x9cd},
{0x9d7,0x9d7},
{0x9e2,0x9e3},
{0x9e6,0x9ef},
{0xa01,0xa03},
{0xa3c,0xa3c},
{0xa3e,0xa42},
{0xa47,0xa48},
{0xa4b,0xa4d},
{0xa51,0xa51},
{0xa66,0xa71},
{0xa75,0xa75},
{0xa81,0xa83},
{0xabc,0xabc},
{0xabe,0xac5},
{0xac7,0xac9},
{0xacb,0xacd},
{0xae2,0xae3},
{0xae6,0xaef},
{0xb01,0xb03},
{0xb3c,0xb3c},
{0xb3e,0xb44},
{0xb47,0xb48},
{0xb4b,0xb4d},
{0xb56,0xb57},
{0xb62,0xb63},
{0xb66,0xb6f},
{0xb82,0xb82},
{0xbbe,0xbc2},
{0xbc6,0xbc8},
{0xbca,0xbcd},
{0xbd7,0xbd7},
{0xbe6,0xbef},
{0xc00,0xc03},
{0xc3e,0xc44},
{0xc46,0xc48},
{0xc4a,0xc4d},
{0xc55,0xc56},
{0xc62,0xc63},
{0xc66,0xc6f},
{0xc81,0xc83},
{0xcbc,0xcbc},
{0xcbe,0xcc4},
{0xcc6,0xcc8},
{0xcca,0xccd},
{0xcd5,0xcd6},
{0xce2,0xce3},
{0xce6,0xcef},
{0xd01,0xd03},
{0xd3e,0xd44},
{0xd46,0xd48},
{0xd4a,0xd4d},
{0xd57,0xd57},
{0xd62,0xd63},
{0xd66,0xd6f},
{0xd82,0xd83},
{0xdca,0xdca},
{0xdcf,0xdd4},
{0xdd6,0xdd6},
{0xdd8,0xddf},
{0xde6,0xdef},
{0xdf2,0xdf3},
{0xe31,0xe31},
{0xe34,0xe3a},
{0xe47,0xe4e},
{0xe50,0xe59},
{0xeb1,0xeb1},
{0xeb4,0xeb9},
{0xebb,0xebc},
{0xec8,0xecd},
{0xed0,0xed9},
{0xf18,0xf19},
{0xf20,0xf29},
{0xf35,0xf35},
{0xf37,0xf37},
{0xf39,0xf39},
{0xf3e,0xf3f},
{0xf71,0xf84},
{0xf86,0xf87},
{0xf8d,0xf97},
{0xf99,0xfbc},
{0xfc6,0xfc6},
{0x102b,0x103e},
{0x1040,0x1049},
{0x1056,0x1059},
{0x105e,0x1060},
{0x1062,0x1064},
{0x1067,0x106d},
{0x1071,0x1074},
{0x1082,0x108d},
{0x108f,0x109d},
{0x135d,0x135f},
{0x1369,0x1371},
{0x1712,0x1714},
{0x1732,0x1734},
{0x1752,0x1753},
{0x1772,0x1773},
{0x17b4,0x17d3},
{0x17dd,0x17dd},
{0x17e0,0x17e9},
{0x180b,0x180d},
{0x1810,0x1819},
{0x18a9,0x18a9},
{0x1920,0x192b},
{0x1930,0x193b},
{0x1946,0x194f},
{0x19d0,0x19da},
{0x1a17,0x1a1b},
{0x1a55,0x1a5e},
{0x1a60,0x1a7c},
{0x1a7f,0x1a89},
{0x1a90,0x1a99},
{0x1ab0,0x1abd},
{0x1b00,0x1b04},
{0x1b34,0x1b44},
{0x1b50,0x1b59},
{0x1b6b,0x1b73},
{0x1b80,0x1b82},
{0x1ba1,0x1bad},
{0x1bb0,0x1bb9},
{0x1be6,0x1bf3},
{0x1c24,0x1c37},
{0x1c40,0x1c49},
{0x1c50,0x1c59},
{0x1cd0,0x1cd2},
{0x1cd4,0x1ce8},
{0x1ced,0x1ced},
{0x1cf2,0x1cf4},
{0x1cf8,0x1cf9},
{0x1dc0,0x1df5},
{0x1dfc,0x1dff},
{0x203f,0x2040},
{0x2054,0x2054},
{0x20d0,0x20dc},
{0x20e1,0x20e1},
{0x20e5,0x20f0},
{0x2cef,0x2cf1},
{0x2d7f,0x2d7f},
{0x2de0,0x2dff},
{0x302a,0x302f},
{0x3099,0x309a},
{0xa620,0xa629},
{0xa66f,0xa66f},
{0xa674,0xa67d},
{0xa69e,0xa69f},
{0xa6f0,0xa6f1},
{0xa802,0xa802},
{0xa806,0xa806},
{0xa80b,0xa80b},
{0xa823,0xa827},
{0xa880,0xa881},
{0xa8b4,0xa8c4},
{0xa8d0,0xa8d9},
{0xa8e0,0xa8f1},
{0xa900,0xa909},
{0xa926,0xa92d},
{0xa947,0xa953},
{0xa980,0xa983},
{0xa9b3,0xa9c0},
{0xa9d0,0xa9d9},
{0xa9e5,0xa9e5},
{0xa9f0,0xa9f9},
{0xaa29,0xaa36},
{0xaa43,0xaa43},
{0xaa4c,0xaa4d},
{0xaa50,0xaa59},
{0xaa7b,0xaa7d},
{0xaab0,0xaab0},
{0xaab2,0xaab4},
{0xaab7,0xaab8},
{0xaabe,0xaabf},
{0xaac1,0xaac1},
{0xaaeb,0xaaef},
{0xaaf5,0xaaf6},
{0xabe3,0xabea},
{0xabec,0xabed},
{0xabf0,0xabf9},
{0xfb1e,0xfb1e},
{0xfe00,0xfe0f},
{0xfe20,0xfe2f},
{0xfe33,0xfe34},
{0xfe4d,0xfe4f},
{0xff10,0xff19},
{0xff3f,0xff3f},
{0x101fd,0x101fd},
{0x102e0,0x102e0},
{0x10376,0x1037a},
{0x104a0,0x104a9},
{0x10a01,0x10a03},
{0x10a05,0x10a06},
{0x10a0c,0x10a0f},
{0x10a38,0x10a3a},
{0x10a3f,0x10a3f},
{0x10ae5,0x10ae6},
{0x11000,0x11002},
{0x11038,0x11046},
{0x11066,0x1106f},
{0x1107f,0x11082},
{0x110b0,0x110ba},
{0x110f0,0x110f9},
{0x11100,0x11102},
{0x11127,0x11134},
{0x11136,0x1113f},
{0x11173,0x11173},
{0x11180,0x11182},
{0x111b3,0x111c0},
{0x111ca,0x111cc},
{0x111d0,0x111d9},
{0x1122c,0x11237},
{0x112df,0x112ea},
{0x112f0,0x112f9},
{0x11300,0x11303},
{0x1133c,0x1133c},
{0x1133e,0x11344},
{0x11347,0x11348},
{0x1134b,0x1134d},
{0x11357,0x11357},
{0x11362,0x11363},
{0x11366,0x1136c},
{0x11370,0x11374},
{0x114b0,0x114c3},
{0x114d0,0x114d9},
{0x115af,0x115b5},
{0x115b8,0x115c0},
{0x115dc,0x115dd},
{0x11630,0x11640},
{0x11650,0x11659},
{0x116ab,0x116b7},
{0x116c0,0x116c9},
{0x1171d,0x1172b},
{0x11730,0x11739},
{0x118e0,0x118e9},
{0x16a60,0x16a69},
{0x16af0,0x16af4},
{0x16b30,0x16b36},
{0x16b50,0x16b59},
{0x16f51,0x16f7e},
{0x16f8f,0x16f92},
{0x1bc9d,0x1bc9e},
{0x1d165,0x1d169},
{0x1d16d,0x1d172},
{0x1d17b,0x1d182},
{0x1d185,0x1d18b},
{0x1d1aa,0x1d1ad},
{0x1d242,0x1d244},
{0x1d7ce,0x1d7ff},
{0x1da00,0x1da36},
{0x1da3b,0x1da6c},
{0x1da75,0x1da75},
{0x1da84,0x1da84},
{0x1da9b,0x1da9f},
{0x1daa1,0x1daaf},
{0x1e8d0,0x1e8d6},
{0xe0100,0xe01ef},
}};

const TableView<char32_t, char32_t> id_nonstart_table {&id_nonstart_array[0], &id_nonstart_array[0] + id_nonstart_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 562> xid_start_array = {{
{0x41,0x5a},
{0x61,0x7a},
{0xaa,0xaa},
{0xb5,0xb5},
{0xba,0xba},
{0xc0,0xd6},
{0xd8,0xf6},
{0xf8,0x2c1},
{0x2c6,0x2d1},
{0x2e0,0x2e4},
{0x2ec,0x2ec},
{0x2ee,0x2ee},
{0x370,0x374},
{0x376,0x377},
{0x37b,0x37d},
{0x37f,0x37f},
{0x386,0x386},
{0x388,0x38a},
{0x38c,0x38c},
{0x38e,0x3a1},
{0x3a3,0x3f5},
{0x3f7,0x481},
{0x48a,0x52f},
{0x531,0x556},
{0x559,0x559},
{0x561,0x587},
{0x5d0,0x5ea},
{0x5f0,0x5f2},
{0x620,0x64a},
{0x66e,0x66f},
{0x671,0x6d3},
{0x6d5,0x6d5},
{0x6e5,0x6e6},
{0x6ee,0x6ef},
{0x6fa,0x6fc},
{0x6ff,0x6ff},
{0x710,0x710},
{0x712,0x72f},
{0x74d,0x7a5},
{0x7b1,0x7b1},
{0x7ca,0x7ea},
{0x7f4,0x7f5},
{0x7fa,0x7fa},
{0x800,0x815},
{0x81a,0x81a},
{0x824,0x824},
{0x828,0x828},
{0x840,0x858},
{0x8a0,0x8b4},
{0x904,0x939},
{0x93d,0x93d},
{0x950,0x950},
{0x958,0x961},
{0x971,0x980},
{0x985,0x98c},
{0x98f,0x990},
{0x993,0x9a8},
{0x9aa,0x9b0},
{0x9b2,0x9b2},
{0x9b6,0x9b9},
{0x9bd,0x9bd},
{0x9ce,0x9ce},
{0x9dc,0x9dd},
{0x9df,0x9e1},
{0x9f0,0x9f1},
{0xa05,0xa0a},
{0xa0f,0xa10},
{0xa13,0xa28},
{0xa2a,0xa30},
{0xa32,0xa33},
{0xa35,0xa36},
{0xa38,0xa39},
{0xa59,0xa5c},
{0xa5e,0xa5e},
{0xa72,0xa74},
{0xa85,0xa8d},
{0xa8f,0xa91},
{0xa93,0xaa8},
{0xaaa,0xab0},
{0xab2,0xab3},
{0xab5,0xab9},
{0xabd,0xabd},
{0xad0,0xad0},
{0xae0,0xae1},
{0xaf9,0xaf9},
{0xb05,0xb0c},
{0xb0f,0xb10},
{0xb13,0xb28},
{0xb2a,0xb30},
{0xb32,0xb33},
{0xb35,0xb39},
{0xb3d,0xb3d},
{0xb5c,0xb5d},
{0xb5f,0xb61},
{0xb71,0xb71},
{0xb83,0xb83},
{0xb85,0xb8a},
{0xb8e,0xb90},
{0xb92,0xb95},
{0xb99,0xb9a},
{0xb9c,0xb9c},
{0xb9e,0xb9f},
{0xba3,0xba4},
{0xba8,0xbaa},
{0xbae,0xbb9},
{0xbd0,0xbd0},
{0xc05,0xc0c},
{0xc0e,0xc10},
{0xc12,0xc28},
{0xc2a,0xc39},
{0xc3d,0xc3d},
{0xc58,0xc5a},
{0xc60,0xc61},
{0xc85,0xc8c},
{0xc8e,0xc90},
{0xc92,0xca8},
{0xcaa,0xcb3},
{0xcb5,0xcb9},
{0xcbd,0xcbd},
{0xcde,0xcde},
{0xce0,0xce1},
{0xcf1,0xcf2},
{0xd05,0xd0c},
{0xd0e,0xd10},
{0xd12,0xd3a},
{0xd3d,0xd3d},
{0xd4e,0xd4e},
{0xd5f,0xd61},
{0xd7a,0xd7f},
{0xd85,0xd96},
{0xd9a,0xdb1},
{0xdb3,0xdbb},
{0xdbd,0xdbd},
{0xdc0,0xdc6},
{0xe01,0xe30},
{0xe32,0xe32},
{0xe40,0xe46},
{0xe81,0xe82},
{0xe84,0xe84},
{0xe87,0xe88},
{0xe8a,0xe8a},
{0xe8d,0xe8d},
{0xe94,0xe97},
{0xe99,0xe9f},
{0xea1,0xea3},
{0xea5,0xea5},
{0xea7,0xea7},
{0xeaa,0xeab},
{0xead,0xeb0},
{0xeb2,0xeb2},
{0xebd,0xebd},
{0xec0,0xec4},
{0xec6,0xec6},
{0xedc,0xedf},
{0xf00,0xf00},
{0xf40,0xf47},
{0xf49,0xf6c},
{0xf88,0xf8c},
{0x1000,0x102a},
{0x103f,0x103f},
{0x1050,0x1055},
{0x105a,0x105d},
{0x1061,0x1061},
{0x1065,0x1066},
{0x106e,0x1070},
{0x1075,0x1081},
{0x108e,0x108e},
{0x10a0,0x10c5},
{0x10c7,0x10c7},
{0x10cd,0x10cd},
{0x10d0,0x10fa},
{0x10fc,0x1248},
{0x124a,0x124d},
{0x1250,0x1256},
{0x1258,0x1258},
{0x125a,0x125d},
{0x1260,0x1288},
{0x128a,0x128d},
{0x1290,0x12b0},
{0x12b2,0x12b5},
{0x12b8,0x12be},
{0x12c0,0x12c0},
{0x12c2,0x12c5},
{0x12c8,0x12d6},
{0x12d8,0x1310},
{0x1312,0x1315},
{0x1318,0x135a},
{0x1380,0x138f},
{0x13a0,0x13f5},
{0x13f8,0x13fd},
{0x1401,0x166c},
{0x166f,0x167f},
{0x1681,0x169a},
{0x16a0,0x16ea},
{0x16ee,0x16f8},
{0x1700,0x170c},
{0x170e,0x1711},
{0x1720,0x1731},
{0x1740,0x1751},
{0x1760,0x176c},
{0x176e,0x1770},
{0x1780,0x17b3},
{0x17d7,0x17d7},
{0x17dc,0x17dc},
{0x1820,0x1877},
{0x1880,0x18a8},
{0x18aa,0x18aa},
{0x18b0,0x18f5},
{0x1900,0x191e},
{0x1950,0x196d},
{0x1970,0x1974},
{0x1980,0x19ab},
{0x19b0,0x19c9},
{0x1a00,0x1a16},
{0x1a20,0x1a54},
{0x1aa7,0x1aa7},
{0x1b05,0x1b33},
{0x1b45,0x1b4b},
{0x1b83,0x1ba0},
{0x1bae,0x1baf},
{0x1bba,0x1be5},
{0x1c00,0x1c23},
{0x1c4d,0x1c4f},
{0x1c5a,0x1c7d},
{0x1ce9,0x1cec},
{0x1cee,0x1cf1},
{0x1cf5,0x1cf6},
{0x1d00,0x1dbf},
{0x1e00,0x1f15},
{0x1f18,0x1f1d},
{0x1f20,0x1f45},
{0x1f48,0x1f4d},
{0x1f50,0x1f57},
{0x1f59,0x1f59},
{0x1f5b,0x1f5b},
{0x1f5d,0x1f5d},
{0x1f5f,0x1f7d},
{0x1f80,0x1fb4},
{0x1fb6,0x1fbc},
{0x1fbe,0x1fbe},
{0x1fc2,0x1fc4},
{0x1fc6,0x1fcc},
{0x1fd0,0x1fd3},
{0x1fd6,0x1fdb},
{0x1fe0,0x1fec},
{0x1ff2,0x1ff4},
{0x1ff6,0x1ffc},
{0x2071,0x2071},
{0x207f,0x207f},
{0x2090,0x209c},
{0x2102,0x2102},
{0x2107,0x2107},
{0x210a,0x2113},
{0x2115,0x2115},
{0x2118,0x211d},
{0x2124,0x2124},
{0x2126,0x2126},
{0x2128,0x2128},
{0x212a,0x2139},
{0x213c,0x213f},
{0x2145,0x2149},
{0x214e,0x214e},
{0x2160,0x2188},
{0x2c00,0x2c2e},
{0x2c30,0x2c5e},
{0x2c60,0x2ce4},
{0x2ceb,0x2cee},
{0x2cf2,0x2cf3},
{0x2d00,0x2d25},
{0x2d27,0x2d27},
{0x2d2d,0x2d2d},
{0x2d30,0x2d67},
{0x2d6f,0x2d6f},
{0x2d80,0x2d96},
{0x2da0,0x2da6},
{0x2da8,0x2dae},
{0x2db0,0x2db6},
{0x2db8,0x2dbe},
{0x2dc0,0x2dc6},
{0x2dc8,0x2dce},
{0x2dd0,0x2dd6},
{0x2dd8,0x2dde},
{0x3005,0x3007},
{0x3021,0x3029},
{0x3031,0x3035},
{0x3038,0x303c},
{0x3041,0x3096},
{0x309d,0x309f},
{0x30a1,0x30fa},
{0x30fc,0x30ff},
{0x3105,0x312d},
{0x3131,0x318e},
{0x31a0,0x31ba},
{0x31f0,0x31ff},
{0x3400,0x4db5},
{0x4e00,0x9fd5},
{0xa000,0xa48c},
{0xa4d0,0xa4fd},
{0xa500,0xa60c},
{0xa610,0xa61f},
{0xa62a,0xa62b},
{0xa640,0xa66e},
{0xa67f,0xa69d},
{0xa6a0,0xa6ef},
{0xa717,0xa71f},
{0xa722,0xa788},
{0xa78b,0xa7ad},
{0xa7b0,0xa7b7},
{0xa7f7,0xa801},
{0xa803,0xa805},
{0xa807,0xa80a},
{0xa80c,0xa822},
{0xa840,0xa873},
{0xa882,0xa8b3},
{0xa8f2,0xa8f7},
{0xa8fb,0xa8fb},
{0xa8fd,0xa8fd},
{0xa90a,0xa925},
{0xa930,0xa946},
{0xa960,0xa97c},
{0xa984,0xa9b2},
{0xa9cf,0xa9cf},
{0xa9e0,0xa9e4},
{0xa9e6,0xa9ef},
{0xa9fa,0xa9fe},
{0xaa00,0xaa28},
{0xaa40,0xaa42},
{0xaa44,0xaa4b},
{0xaa60,0xaa76},
{0xaa7a,0xaa7a},
{0xaa7e,0xaaaf},
{0xaab1,0xaab1},
{0xaab5,0xaab6},
{0xaab9,0xaabd},
{0xaac0,0xaac0},
{0xaac2,0xaac2},
{0xaadb,0xaadd},
{0xaae0,0xaaea},
{0xaaf2,0xaaf4},
{0xab01,0xab06},
{0xab09,0xab0e},
{0xab11,0xab16},
{0xab20,0xab26},
{0xab28,0xab2e},
{0xab30,0xab5a},
{0xab5c,0xab65},
{0xab70,0xabe2},
{0xac00,0xd7a3},
{0xd7b0,0xd7c6},
{0xd7cb,0xd7fb},
{0xf900,0xfa6d},
{0xfa70,0xfad9},
{0xfb00,0xfb06},
{0xfb13,0xfb17},
{0xfb1d,0xfb1d},
{0xfb1f,0xfb28},
{0xfb2a,0xfb36},
{0xfb38,0xfb3c},
{0xfb3e,0xfb3e},
{0xfb40,0xfb41},
{0xfb43,0xfb44},
{0xfb46,0xfbb1},
{0xfbd3,0xfc5d},
{0xfc64,0xfd3d},
{0xfd50,0xfd8f},
{0xfd92,0xfdc7},
{0xfdf0,0xfdf9},
{0xfe71,0xfe71},
{0xfe73,0xfe73},
{0xfe77,0xfe77},
{0xfe79,0xfe79},
{0xfe7b,0xfe7b},
{0xfe7d,0xfe7d},
{0xfe7f,0xfefc},
{0xff21,0xff3a},
{0xff41,0xff5a},
{0xff66,0xff9d},
{0xffa0,0xffbe},
{0xffc2,0xffc7},
{0xffca,0xffcf},
{0xffd2,0xffd7},
{0xffda,0xffdc},
{0x10000,0x1000b},
{0x1000d,0x10026},
{0x10028,0x1003a},
{0x1003c,0x1003d},
{0x1003f,0x1004d},
{0x10050,0x1005d},
{0x10080,0x100fa},
{0x10140,0x10174},
{0x10280,0x1029c},
{0x102a0,0x102d0},
{0x10300,0x1031f},
{0x10330,0x1034a},
{0x10350,0x10375},
{0x10380,0x1039d},
{0x103a0,0x103c3},
{0x103c8,0x103cf},
{0x103d1,0x103d5},
{0x10400,0x1049d},
{0x10500,0x10527},
{0x10530,0x10563},
{0x10600,0x10736},
{0x10740,0x10755},
{0x10760,0x10767},
{0x10800,0x10805},
{0x10808,0x10808},
{0x1080a,0x10835},
{0x10837,0x10838},
{0x1083c,0x1083c},
{0x1083f,0x10855},
{0x10860,0x10876},
{0x10880,0x1089e},
{0x108e0,0x108f2},
{0x108f4,0x108f5},
{0x10900,0x10915},
{0x10920,0x10939},
{0x10980,0x109b7},
{0x109be,0x109bf},
{0x10a00,0x10a00},
{0x10a10,0x10a13},
{0x10a15,0x10a17},
{0x10a19,0x10a33},
{0x10a60,0x10a7c},
{0x10a80,0x10a9c},
{0x10ac0,0x10ac7},
{0x10ac9,0x10ae4},
{0x10b00,0x10b35},
{0x10b40,0x10b55},
{0x10b60,0x10b72},
{0x10b80,0x10b91},
{0x10c00,0x10c48},
{0x10c80,0x10cb2},
{0x10cc0,0x10cf2},
{0x11003,0x11037},
{0x11083,0x110af},
{0x110d0,0x110e8},
{0x11103,0x11126},
{0x11150,0x11172},
{0x11176,0x11176},
{0x11183,0x111b2},
{0x111c1,0x111c4},
{0x111da,0x111da},
{0x111dc,0x111dc},
{0x11200,0x11211},
{0x11213,0x1122b},
{0x11280,0x11286},
{0x11288,0x11288},
{0x1128a,0x1128d},
{0x1128f,0x1129d},
{0x1129f,0x112a8},
{0x112b0,0x112de},
{0x11305,0x1130c},
{0x1130f,0x11310},
{0x11313,0x11328},
{0x1132a,0x11330},
{0x11332,0x11333},
{0x11335,0x11339},
{0x1133d,0x1133d},
{0x11350,0x11350},
{0x1135d,0x11361},
{0x11480,0x114af},
{0x114c4,0x114c5},
{0x114c7,0x114c7},
{0x11580,0x115ae},
{0x115d8,0x115db},
{0x11600,0x1162f},
{0x11644,0x11644},
{0x11680,0x116aa},
{0x11700,0x11719},
{0x118a0,0x118df},
{0x118ff,0x118ff},
{0x11ac0,0x11af8},
{0x12000,0x12399},
{0x12400,0x1246e},
{0x12480,0x12543},
{0x13000,0x1342e},
{0x14400,0x14646},
{0x16800,0x16a38},
{0x16a40,0x16a5e},
{0x16ad0,0x16aed},
{0x16b00,0x16b2f},
{0x16b40,0x16b43},
{0x16b63,0x16b77},
{0x16b7d,0x16b8f},
{0x16f00,0x16f44},
{0x16f50,0x16f50},
{0x16f93,0x16f9f},
{0x1b000,0x1b001},
{0x1bc00,0x1bc6a},
{0x1bc70,0x1bc7c},
{0x1bc80,0x1bc88},
{0x1bc90,0x1bc99},
{0x1d400,0x1d454},
{0x1d456,0x1d49c},
{0x1d49e,0x1d49f},
{0x1d4a2,0x1d4a2},
{0x1d4a5,0x1d4a6},
{0x1d4a9,0x1d4ac},
{0x1d4ae,0x1d4b9},
{0x1d4bb,0x1d4bb},
{0x1d4bd,0x1d4c3},
{0x1d4c5,0x1d505},
{0x1d507,0x1d50a},
{0x1d50d,0x1d514},
{0x1d516,0x1d51c},
{0x1d51e,0x1d539},
{0x1d53b,0x1d53e},
{0x1d540,0x1d544},
{0x1d546,0x1d546},
{0x1d54a,0x1d550},
{0x1d552,0x1d6a5},
{0x1d6a8,0x1d6c0},
{0x1d6c2,0x1d6da},
{0x1d6dc,0x1d6fa},
{0x1d6fc,0x1d714},
{0x1d716,0x1d734},
{0x1d736,0x1d74e},
{0x1d750,0x1d76e},
{0x1d770,0x1d788},
{0x1d78a,0x1d7a8},
{0x1d7aa,0x1d7c2},
{0x1d7c4,0x1d7cb},
{0x1e800,0x1e8c4},
{0x1ee00,0x1ee03},
{0x1ee05,0x1ee1f},
{0x1ee21,0x1ee22},
{0x1ee24,0x1ee24},
{0x1ee27,0x1ee27},
{0x1ee29,0x1ee32},
{0x1ee34,0x1ee37},
{0x1ee39,0x1ee39},
{0x1ee3b,0x1ee3b},
{0x1ee42,0x1ee42},
{0x1ee47,0x1ee47},
{0x1ee49,0x1ee49},
{0x1ee4b,0x1ee4b},
{0x1ee4d,0x1ee4f},
{0x1ee51,0x1ee52},
{0x1ee54,0x1ee54},
{0x1ee57,0x1ee57},
{0x1ee59,0x1ee59},
{0x1ee5b,0x1ee5b},
{0x1ee5d,0x1ee5d},
{0x1ee5f,0x1ee5f},
{0x1ee61,0x1ee62},
{0x1ee64,0x1ee64},
{0x1ee67,0x1ee6a},
{0x1ee6c,0x1ee72},
{0x1ee74,0x1ee77},
{0x1ee79,0x1ee7c},
{0x1ee7e,0x1ee7e},
{0x1ee80,0x1ee89},
{0x1ee8b,0x1ee9b},
{0x1eea1,0x1eea3},
{0x1eea5,0x1eea9},
{0x1eeab,0x1eebb},
{0x20000,0x2a6d6},
{0x2a700,0x2b734},
{0x2b740,0x2b81d},
{0x2b820,0x2cea1},
{0x2f800,0x2fa1d},
}};

const TableView<char32_t, char32_t> xid_start_table {&xid_start_array[0], &xid_start_array[0] + xid_start_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 294> xid_nonstart_array = {{
{0x30,0x39},
{0x5f,0x5f},
{0xb7,0xb7},
{0x300,0x36f},
{0x387,0x387},
{0x483,0x487},
{0x591,0x5bd},
{0x5bf,0x5bf},
{0x5c1,0x5c2},
{0x5c4,0x5c5},
{0x5c7,0x5c7},
{0x610,0x61a},
{0x64b,0x669},
{0x670,0x670},
{0x6d6,0x6dc},
{0x6df,0x6e4},
{0x6e7,0x6e8},
{0x6ea,0x6ed},
{0x6f0,0x6f9},
{0x711,0x711},
{0x730,0x74a},
{0x7a6,0x7b0},
{0x7c0,0x7c9},
{0x7eb,0x7f3},
{0x816,0x819},
{0x81b,0x823},
{0x825,0x827},
{0x829,0x82d},
{0x859,0x85b},
{0x8e3,0x903},
{0x93a,0x93c},
{0x93e,0x94f},
{0x951,0x957},
{0x962,0x963},
{0x966,0x96f},
{0x981,0x983},
{0x9bc,0x9bc},
{0x9be,0x9c4},
{0x9c7,0x9c8},
{0x9cb,0x9cd},
{0x9d7,0x9d7},
{0x9e2,0x9e3},
{0x9e6,0x9ef},
{0xa01,0xa03},
{0xa3c,0xa3c},
{0xa3e,0xa42},
{0xa47,0xa48},
{0xa4b,0xa4d},
{0xa51,0xa51},
{0xa66,0xa71},
{0xa75,0xa75},
{0xa81,0xa83},
{0xabc,0xabc},
{0xabe,0xac5},
{0xac7,0xac9},
{0xacb,0xacd},
{0xae2,0xae3},
{0xae6,0xaef},
{0xb01,0xb03},
{0xb3c,0xb3c},
{0xb3e,0xb44},
{0xb47,0xb48},
{0xb4b,0xb4d},
{0xb56,0xb57},
{0xb62,0xb63},
{0xb66,0xb6f},
{0xb82,0xb82},
{0xbbe,0xbc2},
{0xbc6,0xbc8},
{0xbca,0xbcd},
{0xbd7,0xbd7},
{0xbe6,0xbef},
{0xc00,0xc03},
{0xc3e,0xc44},
{0xc46,0xc48},
{0xc4a,0xc4d},
{0xc55,0xc56},
{0xc62,0xc63},
{0xc66,0xc6f},
{0xc81,0xc83},
{0xcbc,0xcbc},
{0xcbe,0xcc4},
{0xcc6,0xcc8},
{0xcca,0xccd},
{0xcd5,0xcd6},
{0xce2,0xce3},
{0xce6,0xcef},
{0xd01,0xd03},
{0xd3e,0xd44},
{0xd46,0xd48},
{0xd4a,0xd4d},
{0xd57,0xd57},
{0xd62,0xd63},
{0xd66,0xd6f},
{0xd82,0xd83},
{0xdca,0xdca},
{0xdcf,0xdd4},
{0xdd6,0xdd6},
{0xdd8,0xddf},
{0xde6,0xdef},
{0xdf2,0xdf3},
{0xe31,0xe31},
{0xe33,0xe3a},
{0xe47,0xe4e},
{0xe50,0xe59},
{0xeb1,0xeb1},
{0xeb3,0xeb9},
{0xebb,0xebc},
{0xec8,0xecd},
{0xed0,0xed9},
{0xf18,0xf19},
{0xf20,0xf29},
{0xf35,0xf35},
{0xf37,0xf37},
{0xf39,0xf39},
{0xf3e,0xf3f},
{0xf71,0xf84},
{0xf86,0xf87},
{0xf8d,0xf97},
{0xf99,0xfbc},
{0xfc6,0xfc6},
{0x102b,0x103e},
{0x1040,0x1049},
{0x1056,0x1059},
{0x105e,0x1060},
{0x1062,0x1064},
{0x1067,0x106d},
{0x1071,0x1074},
{0x1082,0x108d},
{0x108f,0x109d},
{0x135d,0x135f},
{0x1369,0x1371},
{0x1712,0x1714},
{0x1732,0x1734},
{0x1752,0x1753},
{0x1772,0x1773},
{0x17b4,0x17d3},
{0x17dd,0x17dd},
{0x17e0,0x17e9},
{0x180b,0x180d},
{0x1810,0x1819},
{0x18a9,0x18a9},
{0x1920,0x192b},
{0x1930,0x193b},
{0x1946,0x194f},
{0x19d0,0x19da},
{0x1a17,0x1a1b},
{0x1a55,0x1a5e},
{0x1a60,0x1a7c},
{0x1a7f,0x1a89},
{0x1a90,0x1a99},
{0x1ab0,0x1abd},
{0x1b00,0x1b04},
{0x1b34,0x1b44},
{0x1b50,0x1b59},
{0x1b6b,0x1b73},
{0x1b80,0x1b82},
{0x1ba1,0x1bad},
{0x1bb0,0x1bb9},
{0x1be6,0x1bf3},
{0x1c24,0x1c37},
{0x1c40,0x1c49},
{0x1c50,0x1c59},
{0x1cd0,0x1cd2},
{0x1cd4,0x1ce8},
{0x1ced,0x1ced},
{0x1cf2,0x1cf4},
{0x1cf8,0x1cf9},
{0x1dc0,0x1df5},
{0x1dfc,0x1dff},
{0x203f,0x2040},
{0x2054,0x2054},
{0x20d0,0x20dc},
{0x20e1,0x20e1},
{0x20e5,0x20f0},
{0x2cef,0x2cf1},
{0x2d7f,0x2d7f},
{0x2de0,0x2dff},
{0x302a,0x302f},
{0x3099,0x309a},
{0xa620,0xa629},
{0xa66f,0xa66f},
{0xa674,0xa67d},
{0xa69e,0xa69f},
{0xa6f0,0xa6f1},
{0xa802,0xa802},
{0xa806,0xa806},
{0xa80b,0xa80b},
{0xa823,0xa827},
{0xa880,0xa881},
{0xa8b4,0xa8c4},
{0xa8d0,0xa8d9},
{0xa8e0,0xa8f1},
{0xa900,0xa909},
{0xa926,0xa92d},
{0xa947,0xa953},
{0xa980,0xa983},
{0xa9b3,0xa9c0},
{0xa9d0,0xa9d9},
{0xa9e5,0xa9e5},
{0xa9f0,0xa9f9},
{0xaa29,0xaa36},
{0xaa43,0xaa43},
{0xaa4c,0xaa4d},
{0xaa50,0xaa59},
{0xaa7b,0xaa7d},
{0xaab0,0xaab0},
{0xaab2,0xaab4},
{0xaab7,0xaab8},
{0xaabe,0xaabf},
{0xaac1,0xaac1},
{0xaaeb,0xaaef},
{0xaaf5,0xaaf6},
{0xabe3,0xabea},
{0xabec,0xabed},
{0xabf0,0xabf9},
{0xfb1e,0xfb1e},
{0xfe00,0xfe0f},
{0xfe20,0xfe2f},
{0xfe33,0xfe34},
{0xfe4d,0xfe4f},
{0xff10,0xff19},
{0xff3f,0xff3f},
{0xff9e,0xff9f},
{0x101fd,0x101fd},
{0x102e0,0x102e0},
{0x10376,0x1037a},
{0x104a0,0x104a9},
{0x10a01,0x10a03},
{0x10a05,0x10a06},
{0x10a0c,0x10a0f},
{0x10a38,0x10a3a},
{0x10a3f,0x10a3f},
{0x10ae5,0x10ae6},
{0x11000,0x11002},
{0x11038,0x11046},
{0x11066,0x1106f},
{0x1107f,0x11082},
{0x110b0,0x110ba},
{0x110f0,0x110f9},
{0x11100,0x11102},
{0x11127,0x11134},
{0x11136,0x1113f},
{0x11173,0x11173},
{0x11180,0x11182},
{0x111b3,0x111c0},
{0x111ca,0x111cc},
{0x111d0,0x111d9},
{0x1122c,0x11237},
{0x112df,0x112ea},
{0x112f0,0x112f9},
{0x11300,0x11303},
{0x1133c,0x1133c},
{0x1133e,0x11344},
{0x11347,0x11348},
{0x1134b,0x1134d},
{0x11357,0x11357},
{0x11362,0x11363},
{0x11366,0x1136c},
{0x11370,0x11374},
{0x114b0,0x114c3},
{0x114d0,0x114d9},
{0x115af,0x115b5},
{0x115b8,0x115c0},
{0x115dc,0x115dd},
{0x11630,0x11640},
{0x11650,0x11659},
{0x116ab,0x116b7},
{0x116c0,0x116c9},
{0x1171d,0x1172b},
{0x11730,0x11739},
{0x118e0,0x118e9},
{0x16a60,0x16a69},
{0x16af0,0x16af4},
{0x16b30,0x16b36},
{0x16b50,0x16b59},
{0x16f51,0x16f7e},
{0x16f8f,0x16f92},
{0x1bc9d,0x1bc9e},
{0x1d165,0x1d169},
{0x1d16d,0x1d172},
{0x1d17b,0x1d182},
{0x1d185,0x1d18b},
{0x1d1aa,0x1d1ad},
{0x1d242,0x1d244},
{0x1d7ce,0x1d7ff},
{0x1da00,0x1da36},
{0x1da3b,0x1da6c},
{0x1da75,0x1da75},
{0x1da84,0x1da84},
{0x1da9b,0x1da9f},
{0x1daa1,0x1daaf},
{0x1e8d0,0x1e8d6},
{0xe0100,0xe01ef},
}};

const TableView<char32_t, char32_t> xid_nonstart_table {&xid_nonstart_array[0], &xid_nonstart_array[0] + xid_nonstart_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 28> pattern_syntax_array = {{
{0x21,0x2f},
{0x3a,0x40},
{0x5b,0x5e},
{0x60,0x60},
{0x7b,0x7e},
{0xa1,0xa7},
{0xa9,0xa9},
{0xab,0xac},
{0xae,0xae},
{0xb0,0xb1},
{0xb6,0xb6},
{0xbb,0xbb},
{0xbf,0xbf},
{0xd7,0xd7},
{0xf7,0xf7},
{0x2010,0x2027},
{0x2030,0x203e},
{0x2041,0x2053},
{0x2055,0x205e},
{0x2190,0x245f},
{0x2500,0x2775},
{0x2794,0x2bff},
{0x2e00,0x2e7f},
{0x3001,0x3003},
{0x3008,0x3020},
{0x3030,0x3030},
{0xfd3e,0xfd3f},
{0xfe45,0xfe46},
}};

const TableView<char32_t, char32_t> pattern_syntax_table {&pattern_syntax_array[0], &pattern_syntax_array[0] + pattern_syntax_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 5> pattern_white_space_array = {{
{0x9,0xd},
{0x20,0x20},
{0x85,0x85},
{0x200e,0x200f},
{0x2028,0x2029},
}};

const TableView<char32_t, char32_t> pattern_white_space_table {&pattern_white_space_array[0], &pattern_white_space_array[0] + pattern_white_space_array.size()};

const std::array<KeyValue<char32_t, East_Asian_Width>, 1562> east_asian_width_array = {{
{0x0,East_Asian_Width::N},
{0x20,East_Asian_Width::Na},
{0x7f,East_Asian_Width::N},
{0xa1,East_Asian_Width::A},
{0xa2,East_Asian_Width::Na},
{0xa4,East_Asian_Width::A},
{0xa5,East_Asian_Width::Na},
{0xa7,East_Asian_Width::A},
{0xa9,East_Asian_Width::N},
{0xaa,East_Asian_Width::A},
{0xab,East_Asian_Width::N},
{0xac,East_Asian_Width::Na},
{0xad,East_Asian_Width::A},
{0xaf,East_Asian_Width::Na},
{0xb0,East_Asian_Width::A},
{0xb5,East_Asian_Width::N},
{0xb6,East_Asian_Width::A},
{0xbb,East_Asian_Width::N},
{0xbc,East_Asian_Width::A},
{0xc0,East_Asian_Width::N},
{0xc6,East_Asian_Width::A},
{0xc7,East_Asian_Width::N},
{0xd0,East_Asian_Width::A},
{0xd1,East_Asian_Width::N},
{0xd7,East_Asian_Width::A},
{0xd9,East_Asian_Width::N},
{0xde,East_Asian_Width::A},
{0xe2,East_Asian_Width::N},
{0xe6,East_Asian_Width::A},
{0xe7,East_Asian_Width::N},
{0xe8,East_Asian_Width::A},
{0xeb,East_Asian_Width::N},
{0xec,East_Asian_Width::A},
{0xee,East_Asian_Width::N},
{0xf0,East_Asian_Width::A},
{0xf1,East_Asian_Width::N},
{0xf2,East_Asian_Width::A},
{0xf4,East_Asian_Width::N},
{0xf7,East_Asian_Width::A},
{0xfb,East_Asian_Width::N},
{0xfc,East_Asian_Width::A},
{0xfd,East_Asian_Width::N},
{0xfe,East_Asian_Width::A},
{0xff,East_Asian_Width::N},
{0x101,East_Asian_Width::A},
{0x102,East_Asian_Width::N},
{0x111,East_Asian_Width::A},
{0x112,East_Asian_Width::N},
{0x113,East_Asian_Width::A},
{0x114,East_Asian_Width::N},
{0x11b,East_Asian_Width::A},
{0x11c,East_Asian_Width::N},
{0x126,East_Asian_Width::A},
{0x128,East_Asian_Width::N},
{0x12b,East_Asian_Width::A},
{0x12c,East_Asian_Width::N},
{0x131,East_Asian_Width::A},
{0x134,East_Asian_Width::N},
{0x138,East_Asian_Width::A},
{0x139,East_Asian_Width::N},
{0x13f,East_Asian_Width::A},
{0x143,East_Asian_Width::N},
{0x144,East_Asian_Width::A},
{0x145,East_Asian_Width::N},
{0x148,East_Asian_Width::A},
{0x14c,East_Asian_Width::N},
{0x14d,East_Asian_Width::A},
{0x14e,East_Asian_Width::N},
{0x152,East_Asian_Width::A},
{0x154,East_Asian_Width::N},
{0x166,East_Asian_Width::A},
{0x168,East_Asian_Width::N},
{0x16b,East_Asian_Width::A},
{0x16c,East_Asian_Width::N},
{0x1ce,East_Asian_Width::A},
{0x1cf,East_Asian_Width::N},
{0x1d0,East_Asian_Width::A},
{0x1d1,East_Asian_Width::N},
{0x1d2,East_Asian_Width::A},
{0x1d3,East_Asian_Width::N},
{0x1d4,East_Asian_Width::A},
{0x1d5,East_Asian_Width::N},
{0x1d6,East_Asian_Width::A},
{0x1d7,East_Asian_Width::N},
{0x1d8,East_Asian_Width::A},
{0x1d9,East_Asian_Width::N},
{0x1da,East_Asian_Width::A},
{0x1db,East_Asian_Width::N},
{0x1dc,East_Asian_Width::A},
{0x1dd,East_Asian_Width::N},
{0x251,East_Asian_Width::A},
{0x252,East_Asian_Width::N},
{0x261,East_Asian_Width::A},
{0x262,East_Asian_Width::N},
{0x2c4,East_Asian_Width::A},
{0x2c5,East_Asian_Width::N},
{0x2c7,East_Asian_Width::A},
{0x2c8,East_Asian_Width::N},
{0x2c9,East_Asian_Width::A},
{0x2cc,East_Asian_Width::N},
{0x2cd,East_Asian_Width::A},
{0x2ce,East_Asian_Width::N},
{0x2d0,East_Asian_Width::A},
{0x2d1,East_Asian_Width::N},
{0x2d8,East_Asian_Width::A},
{0x2dc,East_Asian_Width::N},
{0x2dd,East_Asian_Width::A},
{0x2de,East_Asian_Width::N},
{0x2df,East_Asian_Width::A},
{0x2e0,East_Asian_Width::N},
{0x300,East_Asian_Width::A},
{0x370,East_Asian_Width::N},
{0x378,static_cast<East_Asian_Width>(0)},
{0x37a,East_Asian_Width::N},
{0x380,static_cast<East_Asian_Width>(0)},
{0x384,East_Asian_Width::N},
{0x38b,static_cast<East_Asian_Width>(0)},
{0x38c,East_Asian_Width::N},
{0x38d,static_cast<East_Asian_Width>(0)},
{0x38e,East_Asian_Width::N},
{0x391,East_Asian_Width::A},
{0x3a2,static_cast<East_Asian_Width>(0)},
{0x3a3,East_Asian_Width::A},
{0x3aa,East_Asian_Width::N},
{0x3b1,East_Asian_Width::A},
{0x3c2,East_Asian_Width::N},
{0x3c3,East_Asian_Width::A},
{0x3ca,East_Asian_Width::N},
{0x401,East_Asian_Width::A},
{0x402,East_Asian_Width::N},
{0x410,East_Asian_Width::A},
{0x450,East_Asian_Width::N},
{0x451,East_Asian_Width::A},
{0x452,East_Asian_Width::N},
{0x530,static_cast<East_Asian_Width>(0)},
{0x531,East_Asian_Width::N},
{0x557,static_cast<East_Asian_Width>(0)},
{0x559,East_Asian_Width::N},
{0x560,static_cast<East_Asian_Width>(0)},
{0x561,East_Asian_Width::N},
{0x588,static_cast<East_Asian_Width>(0)},
{0x589,East_Asian_Width::N},
{0x58b,static_cast<East_Asian_Width>(0)},
{0x58d,East_Asian_Width::N},
{0x590,static_cast<East_Asian_Width>(0)},
{0x591,East_Asian_Width::N},
{0x5c8,static_cast<East_Asian_Width>(0)},
{0x5d0,East_Asian_Width::N},
{0x5eb,static_cast<East_Asian_Width>(0)},
{0x5f0,East_Asian_Width::N},
{0x5f5,static_cast<East_Asian_Width>(0)},
{0x600,East_Asian_Width::N},
{0x61d,static_cast<East_Asian_Width>(0)},
{0x61e,East_Asian_Width::N},
{0x70e,static_cast<East_Asian_Width>(0)},
{0x70f,East_Asian_Width::N},
{0x74b,static_cast<East_Asian_Width>(0)},
{0x74d,East_Asian_Width::N},
{0x7b2,static_cast<East_Asian_Width>(0)},
{0x7c0,East_Asian_Width::N},
{0x7fb,static_cast<East_Asian_Width>(0)},
{0x800,East_Asian_Width::N},
{0x82e,static_cast<East_Asian_Width>(0)},
{0x830,East_Asian_Width::N},
{0x83f,static_cast<East_Asian_Width>(0)},
{0x840,East_Asian_Width::N},
{0x85c,static_cast<East_Asian_Width>(0)},
{0x85e,East_Asian_Width::N},
{0x85f,static_cast<East_Asian_Width>(0)},
{0x8a0,East_Asian_Width::N},
{0x8b5,static_cast<East_Asian_Width>(0)},
{0x8e3,East_Asian_Width::N},
{0x984,static_cast<East_Asian_Width>(0)},
{0x985,East_Asian_Width::N},
{0x98d,static_cast<East_Asian_Width>(0)},
{0x98f,East_Asian_Width::N},
{0x991,static_cast<East_Asian_Width>(0)},
{0x993,East_Asian_Width::N},
{0x9a9,static_cast<East_Asian_Width>(0)},
{0x9aa,East_Asian_Width::N},
{0x9b1,static_cast<East_Asian_Width>(0)},
{0x9b2,East_Asian_Width::N},
{0x9b3,static_cast<East_Asian_Width>(0)},
{0x9b6,East_Asian_Width::N},
{0x9ba,static_cast<East_Asian_Width>(0)},
{0x9bc,East_Asian_Width::N},
{0x9c5,static_cast<East_Asian_Width>(0)},
{0x9c7,East_Asian_Width::N},
{0x9c9,static_cast<East_Asian_Width>(0)},
{0x9cb,East_Asian_Width::N},
{0x9cf,static_cast<East_Asian_Width>(0)},
{0x9d7,East_Asian_Width::N},
{0x9d8,static_cast<East_Asian_Width>(0)},
{0x9dc,East_Asian_Width::N},
{0x9de,static_cast<East_Asian_Width>(0)},
{0x9df,East_Asian_Width::N},
{0x9e4,static_cast<East_Asian_Width>(0)},
{0x9e6,East_Asian_Width::N},
{0x9fc,static_cast<East_Asian_Width>(0)},
{0xa01,East_Asian_Width::N},
{0xa04,static_cast<East_Asian_Width>(0)},
{0xa05,East_Asian_Width::N},
{0xa0b,static_cast<East_Asian_Width>(0)},
{0xa0f,East_Asian_Width::N},
{0xa11,static_cast<East_Asian_Width>(0)},
{0xa13,East_Asian_Width::N},
{0xa29,static_cast<East_Asian_Width>(0)},
{0xa2a,East_Asian_Width::N},
{0xa31,static_cast<East_Asian_Width>(0)},
{0xa32,East_Asian_Width::N},
{0xa34,static_cast<East_Asian_Width>(0)},
{0xa35,East_Asian_Width::N},
{0xa37,static_cast<East_Asian_Width>(0)},
{0xa38,East_Asian_Width::N},
{0xa3a,static_cast<East_Asian_Width>(0)},
{0xa3c,East_Asian_Width::N},
{0xa3d,static_cast<East_Asian_Width>(0)},
{0xa3e,East_Asian_Width::N},
{0xa43,static_cast<East_Asian_Width>(0)},
{0xa47,East_Asian_Width::N},
{0xa49,static_cast<East_Asian_Width>(0)},
{0xa4b,East_Asian_Width::N},
{0xa4e,static_cast<East_Asian_Width>(0)},
{0xa51,East_Asian_Width::N},
{0xa52,static_cast<East_Asian_Width>(0)},
{0xa59,East_Asian_Width::N},
{0xa5d,static_cast<East_Asian_Width>(0)},
{0xa5e,East_Asian_Width::N},
{0xa5f,static_cast<East_Asian_Width>(0)},
{0xa66,East_Asian_Width::N},
{0xa76,static_cast<East_Asian_Width>(0)},
{0xa81,East_Asian_Width::N},
{0xa84,static_cast<East_Asian_Width>(0)},
{0xa85,East_Asian_Width::N},
{0xa8e,static_cast<East_Asian_Width>(0)},
{0xa8f,East_Asian_Width::N},
{0xa92,static_cast<East_Asian_Width>(0)},
{0xa93,East_Asian_Width::N},
{0xaa9,static_cast<East_Asian_Width>(0)},
{0xaaa,East_Asian_Width::N},
{0xab1,static_cast<East_Asian_Width>(0)},
{0xab2,East_Asian_Width::N},
{0xab4,static_cast<East_Asian_Width>(0)},
{0xab5,East_Asian_Width::N},
{0xaba,static_cast<East_Asian_Width>(0)},
{0xabc,East_Asian_Width::N},
{0xac6,static_cast<East_Asian_Width>(0)},
{0xac7,East_Asian_Width::N},
{0xaca,static_cast<East_Asian_Width>(0)},
{0xacb,East_Asian_Width::N},
{0xace,static_cast<East_Asian_Width>(0)},
{0xad0,East_Asian_Width::N},
{0xad1,static_cast<East_Asian_Width>(0)},
{0xae0,East_Asian_Width::N},
{0xae4,static_cast<East_Asian_Width>(0)},
{0xae6,East_Asian_Width::N},
{0xaf2,static_cast<East_Asian_Width>(0)},
{0xaf9,East_Asian_Width::N},
{0xafa,static_cast<East_Asian_Width>(0)},
{0xb01,East_Asian_Width::N},
{0xb04,static_cast<East_Asian_Width>(0)},
{0xb05,East_Asian_Width::N},
{0xb0d,static_cast<East_Asian_Width>(0)},
{0xb0f,East_Asian_Width::N},
{0xb11,static_cast<East_Asian_Width>(0)},
{0xb13,East_Asian_Width::N},
{0xb29,static_cast<East_Asian_Width>(0)},
{0xb2a,East_Asian_Width::N},
{0xb31,static_cast<East_Asian_Width>(0)},
{0xb32,East_Asian_Width::N},
{0xb34,static_cast<East_Asian_Width>(0)},
{0xb35,East_Asian_Width::N},
{0xb3a,static_cast<East_Asian_Width>(0)},
{0xb3c,East_Asian_Width::N},
{0xb45,static_cast<East_Asian_Width>(0)},
{0xb47,East_Asian_Width::N},
{0xb49,static_cast<East_Asian_Width>(0)},
{0xb4b,East_Asian_Width::N},
{0xb4e,static_cast<East_Asian_Width>(0)},
{0xb56,East_Asian_Width::N},
{0xb58,static_cast<East_Asian_Width>(0)},
{0xb5c,East_Asian_Width::N},
{0xb5e,static_cast<East_Asian_Width>(0)},
{0xb5f,East_Asian_Width::N},
{0xb64,static_cast<East_Asian_Width>(0)},
{0xb66,East_Asian_Width::N},
{0xb78,static_cast<East_Asian_Width>(0)},
{0xb82,East_Asian_Width::N},
{0xb84,static_cast<East_Asian_Width>(0)},
{0xb85,East_Asian_Width::N},
{0xb8b,static_cast<East_Asian_Width>(0)},
{0xb8e,East_Asian_Width::N},
{0xb91,static_cast<East_Asian_Width>(0)},
{0xb92,East_Asian_Width::N},
{0xb96,static_cast<East_Asian_Width>(0)},
{0xb99,East_Asian_Width::N},
{0xb9b,static_cast<East_Asian_Width>(0)},
{0xb9c,East_Asian_Width::N},
{0xb9d,static_cast<East_Asian_Width>(0)},
{0xb9e,East_Asian_Width::N},
{0xba0,static_cast<East_Asian_Width>(0)},
{0xba3,East_Asian_Width::N},
{0xba5,static_cast<East_Asian_Width>(0)},
{0xba8,East_Asian_Width::N},
{0xbab,static_cast<East_Asian_Width>(0)},
{0xbae,East_Asian_Width::N},
{0xbba,static_cast<East_Asian_Width>(0)},
{0xbbe,East_Asian_Width::N},
{0xbc3,static_cast<East_Asian_Width>(0)},
{0xbc6,East_Asian_Width::N},
{0xbc9,static_cast<East_Asian_Width>(0)},
{0xbca,East_Asian_Width::N},
{0xbce,static_cast<East_Asian_Width>(0)},
{0xbd0,East_Asian_Width::N},
{0xbd1,static_cast<East_Asian_Width>(0)},
{0xbd7,East_Asian_Width::N},
{0xbd8,static_cast<East_Asian_Width>(0)},
{0xbe6,East_Asian_Width::N},
{0xbfb,static_cast<East_Asian_Width>(0)},
{0xc00,East_Asian_Width::N},
{0xc04,static_cast<East_Asian_Width>(0)},
{0xc05,East_Asian_Width::N},
{0xc0d,static_cast<East_Asian_Width>(0)},
{0xc0e,East_Asian_Width::N},
{0xc11,static_cast<East_Asian_Width>(0)},
{0xc12,East_Asian_Width::N},
{0xc29,static_cast<East_Asian_Width>(0)},
{0xc2a,East_Asian_Width::N},
{0xc3a,static_cast<East_Asian_Width>(0)},
{0xc3d,East_Asian_Width::N},
{0xc45,static_cast<East_Asian_Width>(0)},
{0xc46,East_Asian_Width::N},
{0xc49,static_cast<East_Asian_Width>(0)},
{0xc4a,East_Asian_Width::N},
{0xc4e,static_cast<East_Asian_Width>(0)},
{0xc55,East_Asian_Width::N},
{0xc57,static_cast<East_Asian_Width>(0)},
{0xc58,East_Asian_Width::N},
{0xc5b,static_cast<East_Asian_Width>(0)},
{0xc60,East_Asian_Width::N},
{0xc64,static_cast<East_Asian_Width>(0)},
{0xc66,East_Asian_Width::N},
{0xc70,static_cast<East_Asian_Width>(0)},
{0xc78,East_Asian_Width::N},
{0xc80,static_cast<East_Asian_Width>(0)},
{0xc81,East_Asian_Width::N},
{0xc84,static_cast<East_Asian_Width>(0)},
{0xc85,East_Asian_Width::N},
{0xc8d,static_cast<East_Asian_Width>(0)},
{0xc8e,East_Asian_Width::N},
{0xc91,static_cast<East_Asian_Width>(0)},
{0xc92,East_Asian_Width::N},
{0xca9,static_cast<East_Asian_Width>(0)},
{0xcaa,East_Asian_Width::N},
{0xcb4,static_cast<East_Asian_Width>(0)},
{0xcb5,East_Asian_Width::N},
{0xcba,static_cast<East_Asian_Width>(0)},
{0xcbc,East_Asian_Width::N},
{0xcc5,static_cast<East_Asian_Width>(0)},
{0xcc6,East_Asian_Width::N},
{0xcc9,static_cast<East_Asian_Width>(0)},
{0xcca,East_Asian_Width::N},
{0xcce,static_cast<East_Asian_Width>(0)},
{0xcd5,East_Asian_Width::N},
{0xcd7,static_cast<East_Asian_Width>(0)},
{0xcde,East_Asian_Width::N},
{0xcdf,static_cast<East_Asian_Width>(0)},
{0xce0,East_Asian_Width::N},
{0xce4,static_cast<East_Asian_Width>(0)},
{0xce6,East_Asian_Width::N},
{0xcf0,static_cast<East_Asian_Width>(0)},
{0xcf1,East_Asian_Width::N},
{0xcf3,static_cast<East_Asian_Width>(0)},
{0xd01,East_Asian_Width::N},
{0xd04,static_cast<East_Asian_Width>(0)},
{0xd05,East_Asian_Width::N},
{0xd0d,static_cast<East_Asian_Width>(0)},
{0xd0e,East_Asian_Width::N},
{0xd11,static_cast<East_Asian_Width>(0)},
{0xd12,East_Asian_Width::N},
{0xd3b,static_cast<East_Asian_Width>(0)},
{0xd3d,East_Asian_Width::N},
{0xd45,static_cast<East_Asian_Width>(0)},
{0xd46,East_Asian_Width::N},
{0xd49,static_cast<East_Asian_Width>(0)},
{0xd4a,East_Asian_Width::N},
{0xd4f,static_cast<East_Asian_Width>(0)},
{0xd57,East_Asian_Width::N},
{0xd58,static_cast<East_Asian_Width>(0)},
{0xd5f,East_Asian_Width::N},
{0xd64,static_cast<East_Asian_Width>(0)},
{0xd66,East_Asian_Width::N},
{0xd76,static_cast<East_Asian_Width>(0)},
{0xd79,East_Asian_Width::N},
{0xd80,static_cast<East_Asian_Width>(0)},
{0xd82,East_Asian_Width::N},
{0xd84,static_cast<East_Asian_Width>(0)},
{0xd85,East_Asian_Width::N},
{0xd97,static_cast<East_Asian_Width>(0)},
{0xd9a,East_Asian_Width::N},
{0xdb2,static_cast<East_Asian_Width>(0)},
{0xdb3,East_Asian_Width::N},
{0xdbc,static_cast<East_Asian_Width>(0)},
{0xdbd,East_Asian_Width::N},
{0xdbe,static_cast<East_Asian_Width>(0)},
{0xdc0,East_Asian_Width::N},
{0xdc7,static_cast<East_Asian_Width>(0)},
{0xdca,East_Asian_Width::N},
{0xdcb,static_cast<East_Asian_Width>(0)},
{0xdcf,East_Asian_Width::N},
{0xdd5,static_cast<East_Asian_Width>(0)},
{0xdd6,East_Asian_Width::N},
{0xdd7,static_cast<East_Asian_Width>(0)},
{0xdd8,East_Asian_Width::N},
{0xde0,static_cast<East_Asian_Width>(0)},
{0xde6,East_Asian_Width::N},
{0xdf0,static_cast<East_Asian_Width>(0)},
{0xdf2,East_Asian_Width::N},
{0xdf5,static_cast<East_Asian_Width>(0)},
{0xe01,East_Asian_Width::N},
{0xe3b,static_cast<East_Asian_Width>(0)},
{0xe3f,East_Asian_Width::N},
{0xe5c,static_cast<East_Asian_Width>(0)},
{0xe81,East_Asian_Width::N},
{0xe83,static_cast<East_Asian_Width>(0)},
{0xe84,East_Asian_Width::N},
{0xe85,static_cast<East_Asian_Width>(0)},
{0xe87,East_Asian_Width::N},
{0xe89,static_cast<East_Asian_Width>(0)},
{0xe8a,East_Asian_Width::N},
{0xe8b,static_cast<East_Asian_Width>(0)},
{0xe8d,East_Asian_Width::N},
{0xe8e,static_cast<East_Asian_Width>(0)},
{0xe94,East_Asian_Width::N},
{0xe98,static_cast<East_Asian_Width>(0)},
{0xe99,East_Asian_Width::N},
{0xea0,static_cast<East_Asian_Width>(0)},
{0xea1,East_Asian_Width::N},
{0xea4,static_cast<East_Asian_Width>(0)},
{0xea5,East_Asian_Width::N},
{0xea6,static_cast<East_Asian_Width>(0)},
{0xea7,East_Asian_Width::N},
{0xea8,static_cast<East_Asian_Width>(0)},
{0xeaa,East_Asian_Width::N},
{0xeac,static_cast<East_Asian_Width>(0)},
{0xead,East_Asian_Width::N},
{0xeba,static_cast<East_Asian_Width>(0)},
{0xebb,East_Asian_Width::N},
{0xebe,static_cast<East_Asian_Width>(0)},
{0xec0,East_Asian_Width::N},
{0xec5,static_cast<East_Asian_Width>(0)},
{0xec6,East_Asian_Width::N},
{0xec7,static_cast<East_Asian_Width>(0)},
{0xec8,East_Asian_Width::N},
{0xece,static_cast<East_Asian_Width>(0)},
{0xed0,East_Asian_Width::N},
{0xeda,static_cast<East_Asian_Width>(0)},
{0xedc,East_Asian_Width::N},
{0xee0,static_cast<East_Asian_Width>(0)},
{0xf00,East_Asian_Width::N},
{0xf48,static_cast<East_Asian_Width>(0)},
{0xf49,East_Asian_Width::N},
{0xf6d,static_cast<East_Asian_Width>(0)},
{0xf71,East_Asian_Width::N},
{0xf98,static_cast<East_Asian_Width>(0)},
{0xf99,East_Asian_Width::N},
{0xfbd,static_cast<East_Asian_Width>(0)},
{0xfbe,East_Asian_Width::N},
{0xfcd,static_cast<East_Asian_Width>(0)},
{0xfce,East_Asian_Width::N},
{0xfdb,static_cast<East_Asian_Width>(0)},
{0x1000,East_Asian_Width::N},
{0x10c6,static_cast<East_Asian_Width>(0)},
{0x10c7,East_Asian_Width::N},
{0x10c8,static_cast<East_Asian_Width>(0)},
{0x10cd,East_Asian_Width::N},
{0x10ce,static_cast<East_Asian_Width>(0)},
{0x10d0,East_Asian_Width::N},
{0x1100,East_Asian_Width::W},
{0x1160,East_Asian_Width::N},
{0x1249,static_cast<East_Asian_Width>(0)},
{0x124a,East_Asian_Width::N},
{0x124e,static_cast<East_Asian_Width>(0)},
{0x1250,East_Asian_Width::N},
{0x1257,static_cast<East_Asian_Width>(0)},
{0x1258,East_Asian_Width::N},
{0x1259,static_cast<East_Asian_Width>(0)},
{0x125a,East_Asian_Width::N},
{0x125e,static_cast<East_Asian_Width>(0)},
{0x1260,East_Asian_Width::N},
{0x1289,static_cast<East_Asian_Width>(0)},
{0x128a,East_Asian_Width::N},
{0x128e,static_cast<East_Asian_Width>(0)},
{0x1290,East_Asian_Width::N},
{0x12b1,static_cast<East_Asian_Width>(0)},
{0x12b2,East_Asian_Width::N},
{0x12b6,static_cast<East_Asian_Width>(0)},
{0x12b8,East_Asian_Width::N},
{0x12bf,static_cast<East_Asian_Width>(0)},
{0x12c0,East_Asian_Width::N},
{0x12c1,static_cast<East_Asian_Width>(0)},
{0x12c2,East_Asian_Width::N},
{0x12c6,static_cast<East_Asian_Width>(0)},
{0x12c8,East_Asian_Width::N},
{0x12d7,static_cast<East_Asian_Width>(0)},
{0x12d8,East_Asian_Width::N},
{0x1311,static_cast<East_Asian_Width>(0)},
{0x1312,East_Asian_Width::N},
{0x1316,static_cast<East_Asian_Width>(0)},
{0x1318,East_Asian_Width::N},
{0x135b,static_cast<East_Asian_Width>(0)},
{0x135d,East_Asian_Width::N},
{0x137d,static_cast<East_Asian_Width>(0)},
{0x1380,East_Asian_Width::N},
{0x139a,static_cast<East_Asian_Width>(0)},
{0x13a0,East_Asian_Width::N},
{0x13f6,static_cast<East_Asian_Width>(0)},
{0x13f8,East_Asian_Width::N},
{0x13fe,static_cast<East_Asian_Width>(0)},
{0x1400,East_Asian_Width::N},
{0x169d,static_cast<East_Asian_Width>(0)},
{0x16a0,East_Asian_Width::N},
{0x16f9,static_cast<East_Asian_Width>(0)},
{0x1700,East_Asian_Width::N},
{0x170d,static_cast<East_Asian_Width>(0)},
{0x170e,East_Asian_Width::N},
{0x1715,static_cast<East_Asian_Width>(0)},
{0x1720,East_Asian_Width::N},
{0x1737,static_cast<East_Asian_Width>(0)},
{0x1740,East_Asian_Width::N},
{0x1754,static_cast<East_Asian_Width>(0)},
{0x1760,East_Asian_Width::N},
{0x176d,static_cast<East_Asian_Width>(0)},
{0x176e,East_Asian_Width::N},
{0x1771,static_cast<East_Asian_Width>(0)},
{0x1772,East_Asian_Width::N},
{0x1774,static_cast<East_Asian_Width>(0)},
{0x1780,East_Asian_Width::N},
{0x17de,static_cast<East_Asian_Width>(0)},
{0x17e0,East_Asian_Width::N},
{0x17ea,static_cast<East_Asian_Width>(0)},
{0x17f0,East_Asian_Width::N},
{0x17fa,static_cast<East_Asian_Width>(0)},
{0x1800,East_Asian_Width::N},
{0x180f,static_cast<East_Asian_Width>(0)},
{0x1810,East_Asian_Width::N},
{0x181a,static_cast<East_Asian_Width>(0)},
{0x1820,East_Asian_Width::N},
{0x1878,static_cast<East_Asian_Width>(0)},
{0x1880,East_Asian_Width::N},
{0x18ab,static_cast<East_Asian_Width>(0)},
{0x18b0,East_Asian_Width::N},
{0x18f6,static_cast<East_Asian_Width>(0)},
{0x1900,East_Asian_Width::N},
{0x191f,static_cast<East_Asian_Width>(0)},
{0x1920,East_Asian_Width::N},
{0x192c,static_cast<East_Asian_Width>(0)},
{0x1930,East_Asian_Width::N},
{0x193c,static_cast<East_Asian_Width>(0)},
{0x1940,East_Asian_Width::N},
{0x1941,static_cast<East_Asian_Width>(0)},
{0x1944,East_Asian_Width::N},
{0x196e,static_cast<East_Asian_Width>(0)},
{0x1970,East_Asian_Width::N},
{0x1975,static_cast<East_Asian_Width>(0)},
{0x1980,East_Asian_Width::N},
{0x19ac,static_cast<East_Asian_Width>(0)},
{0x19b0,East_Asian_Width::N},
{0x19ca,static_cast<East_Asian_Width>(0)},
{0x19d0,East_Asian_Width::N},
{0x19db,static_cast<East_Asian_Width>(0)},
{0x19de,East_Asian_Width::N},
{0x1a1c,static_cast<East_Asian_Width>(0)},
{0x1a1e,East_Asian_Width::N},
{0x1a5f,static_cast<East_Asian_Width>(0)},
{0x1a60,East_Asian_Width::N},
{0x1a7d,static_cast<East_Asian_Width>(0)},
{0x1a7f,East_Asian_Width::N},
{0x1a8a,static_cast<East_Asian_Width>(0)},
{0x1a90,East_Asian_Width::N},
{0x1a9a,static_cast<East_Asian_Width>(0)},
{0x1aa0,East_Asian_Width::N},
{0x1aae,static_cast<East_Asian_Width>(0)},
{0x1ab0,East_Asian_Width::N},
{0x1abf,static_cast<East_Asian_Width>(0)},
{0x1b00,East_Asian_Width::N},
{0x1b4c,static_cast<East_Asian_Width>(0)},
{0x1b50,East_Asian_Width::N},
{0x1b7d,static_cast<East_Asian_Width>(0)},
{0x1b80,East_Asian_Width::N},
{0x1bf4,static_cast<East_Asian_Width>(0)},
{0x1bfc,East_Asian_Width::N},
{0x1c38,static_cast<East_Asian_Width>(0)},
{0x1c3b,East_Asian_Width::N},
{0x1c4a,static_cast<East_Asian_Width>(0)},
{0x1c4d,East_Asian_Width::N},
{0x1c80,static_cast<East_Asian_Width>(0)},
{0x1cc0,East_Asian_Width::N},
{0x1cc8,static_cast<East_Asian_Width>(0)},
{0x1cd0,East_Asian_Width::N},
{0x1cf7,static_cast<East_Asian_Width>(0)},
{0x1cf8,East_Asian_Width::N},
{0x1cfa,static_cast<East_Asian_Width>(0)},
{0x1d00,East_Asian_Width::N},
{0x1df6,static_cast<East_Asian_Width>(0)},
{0x1dfc,East_Asian_Width::N},
{0x1f16,static_cast<East_Asian_Width>(0)},
{0x1f18,East_Asian_Width::N},
{0x1f1e,static_cast<East_Asian_Width>(0)},
{0x1f20,East_Asian_Width::N},
{0x1f46,static_cast<East_Asian_Width>(0)},
{0x1f48,East_Asian_Width::N},
{0x1f4e,static_cast<East_Asian_Width>(0)},
{0x1f50,East_Asian_Width::N},
{0x1f58,static_cast<East_Asian_Width>(0)},
{0x1f59,East_Asian_Width::N},
{0x1f5a,static_cast<East_Asian_Width>(0)},
{0x1f5b,East_Asian_Width::N},
{0x1f5c,static_cast<East_Asian_Width>(0)},
{0x1f5d,East_Asian_Width::N},
{0x1f5e,static_cast<East_Asian_Width>(0)},
{0x1f5f,East_Asian_Width::N},
{0x1f7e,static_cast<East_Asian_Width>(0)},
{0x1f80,East_Asian_Width::N},
{0x1fb5,static_cast<East_Asian_Width>(0)},
{0x1fb6,East_Asian_Width::N},
{0x1fc5,static_cast<East_Asian_Width>(0)},
{0x1fc6,East_Asian_Width::N},
{0x1fd4,static_cast<East_Asian_Width>(0)},
{0x1fd6,East_Asian_Width::N},
{0x1fdc,static_cast<East_Asian_Width>(0)},
{0x1fdd,East_Asian_Width::N},
{0x1ff0,static_cast<East_Asian_Width>(0)},
{0x1ff2,East_Asian_Width::N},
{0x1ff5,static_cast<East_Asian_Width>(0)},
{0x1ff6,East_Asian_Width::N},
{0x1fff,static_cast<East_Asian_Width>(0)},
{0x2000,East_Asian_Width::N},
{0x2010,East_Asian_Width::A},
{0x2011,East_Asian_Width::N},
{0x2013,East_Asian_Width::A},
{0x2017,East_Asian_Width::N},
{0x2018,East_Asian_Width::A},
{0x201a,East_Asian_Width::N},
{0x201c,East_Asian_Width::A},
{0x201e,East_Asian_Width::N},
{0x2020,East_Asian_Width::A},
{0x2023,East_Asian_Width::N},
{0x2024,East_Asian_Width::A},
{0x2028,East_Asian_Width::N},
{0x2030,East_Asian_Width::A},
{0x2031,East_Asian_Width::N},
{0x2032,East_Asian_Width::A},
{0x2034,East_Asian_Width::N},
{0x2035,East_Asian_Width::A},
{0x2036,East_Asian_Width::N},
{0x203b,East_Asian_Width::A},
{0x203c,East_Asian_Width::N},
{0x203e,East_Asian_Width::A},
{0x203f,East_Asian_Width::N},
{0x2065,static_cast<East_Asian_Width>(0)},
{0x2066,East_Asian_Width::N},
{0x2072,static_cast<East_Asian_Width>(0)},
{0x2074,East_Asian_Width::A},
{0x2075,East_Asian_Width::N},
{0x207f,East_Asian_Width::A},
{0x2080,East_Asian_Width::N},
{0x2081,East_Asian_Width::A},
{0x2085,East_Asian_Width::N},
{0x208f,static_cast<East_Asian_Width>(0)},
{0x2090,East_Asian_Width::N},
{0x209d,static_cast<East_Asian_Width>(0)},
{0x20a0,East_Asian_Width::N},
{0x20a9,East_Asian_Width::H},
{0x20aa,East_Asian_Width::N},
{0x20ac,East_Asian_Width::A},
{0x20ad,East_Asian_Width::N},
{0x20bf,static_cast<East_Asian_Width>(0)},
{0x20d0,East_Asian_Width::N},
{0x20f1,static_cast<East_Asian_Width>(0)},
{0x2100,East_Asian_Width::N},
{0x2103,East_Asian_Width::A},
{0x2104,East_Asian_Width::N},
{0x2105,East_Asian_Width::A},
{0x2106,East_Asian_Width::N},
{0x2109,East_Asian_Width::A},
{0x210a,East_Asian_Width::N},
{0x2113,East_Asian_Width::A},
{0x2114,East_Asian_Width::N},
{0x2116,East_Asian_Width::A},
{0x2117,East_Asian_Width::N},
{0x2121,East_Asian_Width::A},
{0x2123,East_Asian_Width::N},
{0x2126,East_Asian_Width::A},
{0x2127,East_Asian_Width::N},
{0x212b,East_Asian_Width::A},
{0x212c,East_Asian_Width::N},
{0x2153,East_Asian_Width::A},
{0x2155,East_Asian_Width::N},
{0x215b,East_Asian_Width::A},
{0x215f,East_Asian_Width::N},
{0x2160,East_Asian_Width::A},
{0x216c,East_Asian_Width::N},
{0x2170,East_Asian_Width::A},
{0x217a,East_Asian_Width::N},
{0x2189,East_Asian_Width::A},
{0x218a,East_Asian_Width::N},
{0x218c,static_cast<East_Asian_Width>(0)},
{0x2190,East_Asian_Width::A},
{0x219a,East_Asian_Width::N},
{0x21b8,East_Asian_Width::A},
{0x21ba,East_Asian_Width::N},
{0x21d2,East_Asian_Width::A},
{0x21d3,East_Asian_Width::N},
{0x21d4,East_Asian_Width::A},
{0x21d5,East_Asian_Width::N},
{0x21e7,East_Asian_Width::A},
{0x21e8,East_Asian_Width::N},
{0x2200,East_Asian_Width::A},
{0x2201,East_Asian_Width::N},
{0x2202,East_Asian_Width::A},
{0x2204,East_Asian_Width::N},
{0x2207,East_Asian_Width::A},
{0x2209,East_Asian_Width::N},
{0x220b,East_Asian_Width::A},
{0x220c,East_Asian_Width::N},
{0x220f,East_Asian_Width::A},
{0x2210,East_Asian_Width::N},
{0x2211,East_Asian_Width::A},
{0x2212,East_Asian_Width::N},
{0x2215,East_Asian_Width::A},
{0x2216,East_Asian_Width::N},
{0x221a,East_Asian_Width::A},
{0x221b,East_Asian_Width::N},
{0x221d,East_Asian_Width::A},
{0x2221,East_Asian_Width::N},
{0x2223,East_Asian_Width::A},
{0x2224,East_Asian_Width::N},
{0x2225,East_Asian_Width::A},
{0x2226,East_Asian_Width::N},
{0x2227,East_Asian_Width::A},
{0x222d,East_Asian_Width::N},
{0x222e,East_Asian_Width::A},
{0x222f,East_Asian_Width::N},
{0x2234,East_Asian_Width::A},
{0x2238,East_Asian_Width::N},
{0x223c,East_Asian_Width::A},
{0x223e,East_Asian_Width::N},
{0x2248,East_Asian_Width::A},
{0x2249,East_Asian_Width::N},
{0x224c,East_Asian_Width::A},
{0x224d,East_Asian_Width::N},
{0x2252,East_Asian_Width::A},
{0x2253,East_Asian_Width::N},
{0x2260,East_Asian_Width::A},
{0x2262,East_Asian_Width::N},
{0x2264,East_Asian_Width::A},
{0x2268,East_Asian_Width::N},
{0x226a,East_Asian_Width::A},
{0x226c,East_Asian_Width::N},
{0x226e,East_Asian_Width::A},
{0x2270,East_Asian_Width::N},
{0x2282,East_Asian_Width::A},
{0x2284,East_Asian_Width::N},
{0x2286,East_Asian_Width::A},
{0x2288,East_Asian_Width::N},
{0x2295,East_Asian_Width::A},
{0x2296,East_Asian_Width::N},
{0x2299,East_Asian_Width::A},
{0x229a,East_Asian_Width::N},
{0x22a5,East_Asian_Width::A},
{0x22a6,East_Asian_Width::N},
{0x22bf,East_Asian_Width::A},
{0x22c0,East_Asian_Width::N},
{0x2312,East_Asian_Width::A},
{0x2313,East_Asian_Width::N},
{0x2329,East_Asian_Width::W},
{0x232b,East_Asian_Width::N},
{0x23fb,static_cast<East_Asian_Width>(0)},
{0x2400,East_Asian_Width::N},
{0x2427,static_cast<East_Asian_Width>(0)},
{0x2440,East_Asian_Width::N},
{0x244b,static_cast<East_Asian_Width>(0)},
{0x2460,East_Asian_Width::A},
{0x24ea,East_Asian_Width::N},
{0x24eb,East_Asian_Width::A},
{0x254c,East_Asian_Width::N},
{0x2550,East_Asian_Width::A},
{0x2574,East_Asian_Width::N},
{0x2580,East_Asian_Width::A},
{0x2590,East_Asian_Width::N},
{0x2592,East_Asian_Width::A},
{0x2596,East_Asian_Width::N},
{0x25a0,East_Asian_Width::A},
{0x25a2,East_Asian_Width::N},
{0x25a3,East_Asian_Width::A},
{0x25aa,East_Asian_Width::N},
{0x25b2,East_Asian_Width::A},
{0x25b4,East_Asian_Width::N},
{0x25b6,East_Asian_Width::A},
{0x25b8,East_Asian_Width::N},
{0x25bc,East_Asian_Width::A},
{0x25be,East_Asian_Width::N},
{0x25c0,East_Asian_Width::A},
{0x25c2,East_Asian_Width::N},
{0x25c6,East_Asian_Width::A},
{0x25c9,East_Asian_Width::N},
{0x25cb,East_Asian_Width::A},
{0x25cc,East_Asian_Width::N},
{0x25ce,East_Asian_Width::A},
{0x25d2,East_Asian_Width::N},
{0x25e2,East_Asian_Width::A},
{0x25e6,East_Asian_Width::N},
{0x25ef,East_Asian_Width::A},
{0x25f0,East_Asian_Width::N},
{0x2605,East_Asian_Width::A},
{0x2607,East_Asian_Width::N},
{0x2609,East_Asian_Width::A},
{0x260a,East_Asian_Width::N},
{0x260e,East_Asian_Width::A},
{0x2610,East_Asian_Width::N},
{0x2614,East_Asian_Width::A},
{0x2616,East_Asian_Width::N},
{0x261c,East_Asian_Width::A},
{0x261d,East_Asian_Width::N},
{0x261e,East_Asian_Width::A},
{0x261f,East_Asian_Width::N},
{0x2640,East_Asian_Width::A},
{0x2641,East_Asian_Width::N},
{0x2642,East_Asian_Width::A},
{0x2643,East_Asian_Width::N},
{0x2660,East_Asian_Width::A},
{0x2662,East_Asian_Width::N},
{0x2663,East_Asian_Width::A},
{0x2666,East_Asian_Width::N},
{0x2667,East_Asian_Width::A},
{0x266b,East_Asian_Width::N},
{0x266c,East_Asian_Width::A},
{0x266e,East_Asian_Width::N},
{0x266f,East_Asian_Width::A},
{0x2670,East_Asian_Width::N},
{0x269e,East_Asian_Width::A},
{0x26a0,East_Asian_Width::N},
{0x26be,East_Asian_Width::A},
{0x26c0,East_Asian_Width::N},
{0x26c4,East_Asian_Width::A},
{0x26ce,East_Asian_Width::N},
{0x26cf,East_Asian_Width::A},
{0x26e2,East_Asian_Width::N},
{0x26e3,East_Asian_Width::A},
{0x26e4,East_Asian_Width::N},
{0x26e8,East_Asian_Width::A},
{0x2700,East_Asian_Width::N},
{0x273d,East_Asian_Width::A},
{0x273e,East_Asian_Width::N},
{0x2757,East_Asian_Width::A},
{0x2758,East_Asian_Width::N},
{0x2776,East_Asian_Width::A},
{0x2780,East_Asian_Width::N},
{0x27e6,East_Asian_Width::Na},
{0x27ee,East_Asian_Width::N},
{0x2985,East_Asian_Width::Na},
{0x2987,East_Asian_Width::N},
{0x2b55,East_Asian_Width::A},
{0x2b5a,East_Asian_Width::N},
{0x2b74,static_cast<East_Asian_Width>(0)},
{0x2b76,East_Asian_Width::N},
{0x2b96,static_cast<East_Asian_Width>(0)},
{0x2b98,East_Asian_Width::N},
{0x2bba,static_cast<East_Asian_Width>(0)},
{0x2bbd,East_Asian_Width::N},
{0x2bc9,static_cast<East_Asian_Width>(0)},
{0x2bca,East_Asian_Width::N},
{0x2bd2,static_cast<East_Asian_Width>(0)},
{0x2bec,East_Asian_Width::N},
{0x2bf0,static_cast<East_Asian_Width>(0)},
{0x2c00,East_Asian_Width::N},
{0x2c2f,static_cast<East_Asian_Width>(0)},
{0x2c30,East_Asian_Width::N},
{0x2c5f,static_cast<East_Asian_Width>(0)},
{0x2c60,East_Asian_Width::N},
{0x2cf4,static_cast<East_Asian_Width>(0)},
{0x2cf9,East_Asian_Width::N},
{0x2d26,static_cast<East_Asian_Width>(0)},
{0x2d27,East_Asian_Width::N},
{0x2d28,static_cast<East_Asian_Width>(0)},
{0x2d2d,East_Asian_Width::N},
{0x2d2e,static_cast<East_Asian_Width>(0)},
{0x2d30,East_Asian_Width::N},
{0x2d68,static_cast<East_Asian_Width>(0)},
{0x2d6f,East_Asian_Width::N},
{0x2d71,static_cast<East_Asian_Width>(0)},
{0x2d7f,East_Asian_Width::N},
{0x2d97,static_cast<East_Asian_Width>(0)},
{0x2da0,East_Asian_Width::N},
{0x2da7,static_cast<East_Asian_Width>(0)},
{0x2da8,East_Asian_Width::N},
{0x2daf,static_cast<East_Asian_Width>(0)},
{0x2db0,East_Asian_Width::N},
{0x2db7,static_cast<East_Asian_Width>(0)},
{0x2db8,East_Asian_Width::N},
{0x2dbf,static_cast<East_Asian_Width>(0)},
{0x2dc0,East_Asian_Width::N},
{0x2dc7,static_cast<East_Asian_Width>(0)},
{0x2dc8,East_Asian_Width::N},
{0x2dcf,static_cast<East_Asian_Width>(0)},
{0x2dd0,East_Asian_Width::N},
{0x2dd7,static_cast<East_Asian_Width>(0)},
{0x2dd8,East_Asian_Width::N},
{0x2ddf,static_cast<East_Asian_Width>(0)},
{0x2de0,East_Asian_Width::N},
{0x2e43,static_cast<East_Asian_Width>(0)},
{0x2e80,East_Asian_Width::W},
{0x2e9a,static_cast<East_Asian_Width>(0)},
{0x2e9b,East_Asian_Width::W},
{0x2ef4,static_cast<East_Asian_Width>(0)},
{0x2f00,East_Asian_Width::W},
{0x2fd6,static_cast<East_Asian_Width>(0)},
{0x2ff0,East_Asian_Width::W},
{0x2ffc,static_cast<East_Asian_Width>(0)},
{0x3000,East_Asian_Width::F},
{0x3001,East_Asian_Width::W},
{0x303f,East_Asian_Width::N},
{0x3040,static_cast<East_Asian_Width>(0)},
{0x3041,East_Asian_Width::W},
{0x3097,static_cast<East_Asian_Width>(0)},
{0x3099,East_Asian_Width::W},
{0x3100,static_cast<East_Asian_Width>(0)},
{0x3105,East_Asian_Width::W},
{0x312e,static_cast<East_Asian_Width>(0)},
{0x3131,East_Asian_Width::W},
{0x318f,static_cast<East_Asian_Width>(0)},
{0x3190,East_Asian_Width::W},
{0x31bb,static_cast<East_Asian_Width>(0)},
{0x31c0,East_Asian_Width::W},
{0x31e4,static_cast<East_Asian_Width>(0)},
{0x31f0,East_Asian_Width::W},
{0x321f,static_cast<East_Asian_Width>(0)},
{0x3220,East_Asian_Width::W},
{0x3248,East_Asian_Width::A},
{0x3250,East_Asian_Width::W},
{0x32ff,static_cast<East_Asian_Width>(0)},
{0x3300,East_Asian_Width::W},
{0x4dc0,East_Asian_Width::N},
{0x4e00,East_Asian_Width::W},
{0xa48d,static_cast<East_Asian_Width>(0)},
{0xa490,East_Asian_Width::W},
{0xa4c7,static_cast<East_Asian_Width>(0)},
{0xa4d0,East_Asian_Width::N},
{0xa62c,static_cast<East_Asian_Width>(0)},
{0xa640,East_Asian_Width::N},
{0xa6f8,static_cast<East_Asian_Width>(0)},
{0xa700,East_Asian_Width::N},
{0xa7ae,static_cast<East_Asian_Width>(0)},
{0xa7b0,East_Asian_Width::N},
{0xa7b8,static_cast<East_Asian_Width>(0)},
{0xa7f7,East_Asian_Width::N},
{0xa82c,static_cast<East_Asian_Width>(0)},
{0xa830,East_Asian_Width::N},
{0xa83a,static_cast<East_Asian_Width>(0)},
{0xa840,East_Asian_Width::N},
{0xa878,static_cast<East_Asian_Width>(0)},
{0xa880,East_Asian_Width::N},
{0xa8c5,static_cast<East_Asian_Width>(0)},
{0xa8ce,East_Asian_Width::N},
{0xa8da,static_cast<East_Asian_Width>(0)},
{0xa8e0,East_Asian_Width::N},
{0xa8fe,static_cast<East_Asian_Width>(0)},
{0xa900,East_Asian_Width::N},
{0xa954,static_cast<East_Asian_Width>(0)},
{0xa95f,East_Asian_Width::N},
{0xa960,East_Asian_Width::W},
{0xa97d,static_cast<East_Asian_Width>(0)},
{0xa980,East_Asian_Width::N},
{0xa9ce,static_cast<East_Asian_Width>(0)},
{0xa9cf,East_Asian_Width::N},
{0xa9da,static_cast<East_Asian_Width>(0)},
{0xa9de,East_Asian_Width::N},
{0xa9ff,static_cast<East_Asian_Width>(0)},
{0xaa00,East_Asian_Width::N},
{0xaa37,static_cast<East_Asian_Width>(0)},
{0xaa40,East_Asian_Width::N},
{0xaa4e,static_cast<East_Asian_Width>(0)},
{0xaa50,East_Asian_Width::N},
{0xaa5a,static_cast<East_Asian_Width>(0)},
{0xaa5c,East_Asian_Width::N},
{0xaac3,static_cast<East_Asian_Width>(0)},
{0xaadb,East_Asian_Width::N},
{0xaaf7,static_cast<East_Asian_Width>(0)},
{0xab01,East_Asian_Width::N},
{0xab07,static_cast<East_Asian_Width>(0)},
{0xab09,East_Asian_Width::N},
{0xab0f,static_cast<East_Asian_Width>(0)},
{0xab11,East_Asian_Width::N},
{0xab17,static_cast<East_Asian_Width>(0)},
{0xab20,East_Asian_Width::N},
{0xab27,static_cast<East_Asian_Width>(0)},
{0xab28,East_Asian_Width::N},
{0xab2f,static_cast<East_Asian_Width>(0)},
{0xab30,East_Asian_Width::N},
{0xab66,static_cast<East_Asian_Width>(0)},
{0xab70,East_Asian_Width::N},
{0xabee,static_cast<East_Asian_Width>(0)},
{0xabf0,East_Asian_Width::N},
{0xabfa,static_cast<East_Asian_Width>(0)},
{0xac00,East_Asian_Width::W},
{0xd7a4,static_cast<East_Asian_Width>(0)},
{0xd7b0,East_Asian_Width::N},
{0xd7c7,static_cast<East_Asian_Width>(0)},
{0xd7cb,East_Asian_Width::N},
{0xd7fc,static_cast<East_Asian_Width>(0)},
{0xd800,East_Asian_Width::N},
{0xe000,East_Asian_Width::A},
{0xf900,East_Asian_Width::W},
{0xfb00,East_Asian_Width::N},
{0xfb07,static_cast<East_Asian_Width>(0)},
{0xfb13,East_Asian_Width::N},
{0xfb18,static_cast<East_Asian_Width>(0)},
{0xfb1d,East_Asian_Width::N},
{0xfb37,static_cast<East_Asian_Width>(0)},
{0xfb38,East_Asian_Width::N},
{0xfb3d,static_cast<East_Asian_Width>(0)},
{0xfb3e,East_Asian_Width::N},
{0xfb3f,static_cast<East_Asian_Width>(0)},
{0xfb40,East_Asian_Width::N},
{0xfb42,static_cast<East_Asian_Width>(0)},
{0xfb43,East_Asian_Width::N},
{0xfb45,static_cast<East_Asian_Width>(0)},
{0xfb46,East_Asian_Width::N},
{0xfbc2,static_cast<East_Asian_Width>(0)},
{0xfbd3,East_Asian_Width::N},
{0xfd40,static_cast<East_Asian_Width>(0)},
{0xfd50,East_Asian_Width::N},
{0xfd90,static_cast<East_Asian_Width>(0)},
{0xfd92,East_Asian_Width::N},
{0xfdc8,static_cast<East_Asian_Width>(0)},
{0xfdf0,East_Asian_Width::N},
{0xfdfe,static_cast<East_Asian_Width>(0)},
{0xfe00,East_Asian_Width::A},
{0xfe10,East_Asian_Width::W},
{0xfe1a,static_cast<East_Asian_Width>(0)},
{0xfe20,East_Asian_Width::N},
{0xfe30,East_Asian_Width::W},
{0xfe53,static_cast<East_Asian_Width>(0)},
{0xfe54,East_Asian_Width::W},
{0xfe67,static_cast<East_Asian_Width>(0)},
{0xfe68,East_Asian_Width::W},
{0xfe6c,static_cast<East_Asian_Width>(0)},
{0xfe70,East_Asian_Width::N},
{0xfe75,static_cast<East_Asian_Width>(0)},
{0xfe76,East_Asian_Width::N},
{0xfefd,static_cast<East_Asian_Width>(0)},
{0xfeff,East_Asian_Width::N},
{0xff00,static_cast<East_Asian_Width>(0)},
{0xff01,East_Asian_Width::F},
{0xff61,East_Asian_Width::H},
{0xffbf,static_cast<East_Asian_Width>(0)},
{0xffc2,East_Asian_Width::H},
{0xffc8,static_cast<East_Asian_Width>(0)},
{0xffca,East_Asian_Width::H},
{0xffd0,static_cast<East_Asian_Width>(0)},
{0xffd2,East_Asian_Width::H},
{0xffd8,static_cast<East_Asian_Width>(0)},
{0xffda,East_Asian_Width::H},
{0xffdd,static_cast<East_Asian_Width>(0)},
{0xffe0,East_Asian_Width::F},
{0xffe7,static_cast<East_Asian_Width>(0)},
{0xffe8,East_Asian_Width::H},
{0xffef,static_cast<East_Asian_Width>(0)},
{0xfff9,East_Asian_Width::N},
{0xfffd,East_Asian_Width::A},
{0xfffe,static_cast<East_Asian_Width>(0)},
{0x10000,East_Asian_Width::N},
{0x1000c,static_cast<East_Asian_Width>(0)},
{0x1000d,East_Asian_Width::N},
{0x10027,static_cast<East_Asian_Width>(0)},
{0x10028,East_Asian_Width::N},
{0x1003b,static_cast<East_Asian_Width>(0)},
{0x1003c,East_Asian_Width::N},
{0x1003e,static_cast<East_Asian_Width>(0)},
{0x1003f,East_Asian_Width::N},
{0x1004e,static_cast<East_Asian_Width>(0)},
{0x10050,East_Asian_Width::N},
{0x1005e,static_cast<East_Asian_Width>(0)},
{0x10080,East_Asian_Width::N},
{0x100fb,static_cast<East_Asian_Width>(0)},
{0x10100,East_Asian_Width::N},
{0x10103,static_cast<East_Asian_Width>(0)},
{0x10107,East_Asian_Width::N},
{0x10134,static_cast<East_Asian_Width>(0)},
{0x10137,East_Asian_Width::N},
{0x1018d,static_cast<East_Asian_Width>(0)},
{0x10190,East_Asian_Width::N},
{0x1019c,static_cast<East_Asian_Width>(0)},
{0x101a0,East_Asian_Width::N},
{0x101a1,static_cast<East_Asian_Width>(0)},
{0x101d0,East_Asian_Width::N},
{0x101fe,static_cast<East_Asian_Width>(0)},
{0x10280,East_Asian_Width::N},
{0x1029d,static_cast<East_Asian_Width>(0)},
{0x102a0,East_Asian_Width::N},
{0x102d1,static_cast<East_Asian_Width>(0)},
{0x102e0,East_Asian_Width::N},
{0x102fc,static_cast<East_Asian_Width>(0)},
{0x10300,East_Asian_Width::N},
{0x10324,static_cast<East_Asian_Width>(0)},
{0x10330,East_Asian_Width::N},
{0x1034b,static_cast<East_Asian_Width>(0)},
{0x10350,East_Asian_Width::N},
{0x1037b,static_cast<East_Asian_Width>(0)},
{0x10380,East_Asian_Width::N},
{0x1039e,static_cast<East_Asian_Width>(0)},
{0x1039f,East_Asian_Width::N},
{0x103c4,static_cast<East_Asian_Width>(0)},
{0x103c8,East_Asian_Width::N},
{0x103d6,static_cast<East_Asian_Width>(0)},
{0x10400,East_Asian_Width::N},
{0x1049e,static_cast<East_Asian_Width>(0)},
{0x104a0,East_Asian_Width::N},
{0x104aa,static_cast<East_Asian_Width>(0)},
{0x10500,East_Asian_Width::N},
{0x10528,static_cast<East_Asian_Width>(0)},
{0x10530,East_Asian_Width::N},
{0x10564,static_cast<East_Asian_Width>(0)},
{0x1056f,East_Asian_Width::N},
{0x10570,static_cast<East_Asian_Width>(0)},
{0x10600,East_Asian_Width::N},
{0x10737,static_cast<East_Asian_Width>(0)},
{0x10740,East_Asian_Width::N},
{0x10756,static_cast<East_Asian_Width>(0)},
{0x10760,East_Asian_Width::N},
{0x10768,static_cast<East_Asian_Width>(0)},
{0x10800,East_Asian_Width::N},
{0x10806,static_cast<East_Asian_Width>(0)},
{0x10808,East_Asian_Width::N},
{0x10809,static_cast<East_Asian_Width>(0)},
{0x1080a,East_Asian_Width::N},
{0x10836,static_cast<East_Asian_Width>(0)},
{0x10837,East_Asian_Width::N},
{0x10839,static_cast<East_Asian_Width>(0)},
{0x1083c,East_Asian_Width::N},
{0x1083d,static_cast<East_Asian_Width>(0)},
{0x1083f,East_Asian_Width::N},
{0x10856,static_cast<East_Asian_Width>(0)},
{0x10857,East_Asian_Width::N},
{0x1089f,static_cast<East_Asian_Width>(0)},
{0x108a7,East_Asian_Width::N},
{0x108b0,static_cast<East_Asian_Width>(0)},
{0x108e0,East_Asian_Width::N},
{0x108f3,static_cast<East_Asian_Width>(0)},
{0x108f4,East_Asian_Width::N},
{0x108f6,static_cast<East_Asian_Width>(0)},
{0x108fb,East_Asian_Width::N},
{0x1091c,static_cast<East_Asian_Width>(0)},
{0x1091f,East_Asian_Width::N},
{0x1093a,static_cast<East_Asian_Width>(0)},
{0x1093f,East_Asian_Width::N},
{0x10940,static_cast<East_Asian_Width>(0)},
{0x10980,East_Asian_Width::N},
{0x109b8,static_cast<East_Asian_Width>(0)},
{0x109bc,East_Asian_Width::N},
{0x109d0,static_cast<East_Asian_Width>(0)},
{0x109d2,East_Asian_Width::N},
{0x10a04,static_cast<East_Asian_Width>(0)},
{0x10a05,East_Asian_Width::N},
{0x10a07,static_cast<East_Asian_Width>(0)},
{0x10a0c,East_Asian_Width::N},
{0x10a14,static_cast<East_Asian_Width>(0)},
{0x10a15,East_Asian_Width::N},
{0x10a18,static_cast<East_Asian_Width>(0)},
{0x10a19,East_Asian_Width::N},
{0x10a34,static_cast<East_Asian_Width>(0)},
{0x10a38,East_Asian_Width::N},
{0x10a3b,static_cast<East_Asian_Width>(0)},
{0x10a3f,East_Asian_Width::N},
{0x10a48,static_cast<East_Asian_Width>(0)},
{0x10a50,East_Asian_Width::N},
{0x10a59,static_cast<East_Asian_Width>(0)},
{0x10a60,East_Asian_Width::N},
{0x10aa0,static_cast<East_Asian_Width>(0)},
{0x10ac0,East_Asian_Width::N},
{0x10ae7,static_cast<East_Asian_Width>(0)},
{0x10aeb,East_Asian_Width::N},
{0x10af7,static_cast<East_Asian_Width>(0)},
{0x10b00,East_Asian_Width::N},
{0x10b36,static_cast<East_Asian_Width>(0)},
{0x10b39,East_Asian_Width::N},
{0x10b56,static_cast<East_Asian_Width>(0)},
{0x10b58,East_Asian_Width::N},
{0x10b73,static_cast<East_Asian_Width>(0)},
{0x10b78,East_Asian_Width::N},
{0x10b92,static_cast<East_Asian_Width>(0)},
{0x10b99,East_Asian_Width::N},
{0x10b9d,static_cast<East_Asian_Width>(0)},
{0x10ba9,East_Asian_Width::N},
{0x10bb0,static_cast<East_Asian_Width>(0)},
{0x10c00,East_Asian_Width::N},
{0x10c49,static_cast<East_Asian_Width>(0)},
{0x10c80,East_Asian_Width::N},
{0x10cb3,static_cast<East_Asian_Width>(0)},
{0x10cc0,East_Asian_Width::N},
{0x10cf3,static_cast<East_Asian_Width>(0)},
{0x10cfa,East_Asian_Width::N},
{0x10d00,static_cast<East_Asian_Width>(0)},
{0x10e60,East_Asian_Width::N},
{0x10e7f,static_cast<East_Asian_Width>(0)},
{0x11000,East_Asian_Width::N},
{0x1104e,static_cast<East_Asian_Width>(0)},
{0x11052,East_Asian_Width::N},
{0x11070,static_cast<East_Asian_Width>(0)},
{0x1107f,East_Asian_Width::N},
{0x110c2,static_cast<East_Asian_Width>(0)},
{0x110d0,East_Asian_Width::N},
{0x110e9,static_cast<East_Asian_Width>(0)},
{0x110f0,East_Asian_Width::N},
{0x110fa,static_cast<East_Asian_Width>(0)},
{0x11100,East_Asian_Width::N},
{0x11135,static_cast<East_Asian_Width>(0)},
{0x11136,East_Asian_Width::N},
{0x11144,static_cast<East_Asian_Width>(0)},
{0x11150,East_Asian_Width::N},
{0x11177,static_cast<East_Asian_Width>(0)},
{0x11180,East_Asian_Width::N},
{0x111ce,static_cast<East_Asian_Width>(0)},
{0x111d0,East_Asian_Width::N},
{0x111e0,static_cast<East_Asian_Width>(0)},
{0x111e1,East_Asian_Width::N},
{0x111f5,static_cast<East_Asian_Width>(0)},
{0x11200,East_Asian_Width::N},
{0x11212,static_cast<East_Asian_Width>(0)},
{0x11213,East_Asian_Width::N},
{0x1123e,static_cast<East_Asian_Width>(0)},
{0x11280,East_Asian_Width::N},
{0x11287,static_cast<East_Asian_Width>(0)},
{0x11288,East_Asian_Width::N},
{0x11289,static_cast<East_Asian_Width>(0)},
{0x1128a,East_Asian_Width::N},
{0x1128e,static_cast<East_Asian_Width>(0)},
{0x1128f,East_Asian_Width::N},
{0x1129e,static_cast<East_Asian_Width>(0)},
{0x1129f,East_Asian_Width::N},
{0x112aa,static_cast<East_Asian_Width>(0)},
{0x112b0,East_Asian_Width::N},
{0x112eb,static_cast<East_Asian_Width>(0)},
{0x112f0,East_Asian_Width::N},
{0x112fa,static_cast<East_Asian_Width>(0)},
{0x11300,East_Asian_Width::N},
{0x11304,static_cast<East_Asian_Width>(0)},
{0x11305,East_Asian_Width::N},
{0x1130d,static_cast<East_Asian_Width>(0)},
{0x1130f,East_Asian_Width::N},
{0x11311,static_cast<East_Asian_Width>(0)},
{0x11313,East_Asian_Width::N},
{0x11329,static_cast<East_Asian_Width>(0)},
{0x1132a,East_Asian_Width::N},
{0x11331,static_cast<East_Asian_Width>(0)},
{0x11332,East_Asian_Width::N},
{0x11334,static_cast<East_Asian_Width>(0)},
{0x11335,East_Asian_Width::N},
{0x1133a,static_cast<East_Asian_Width>(0)},
{0x1133c,East_Asian_Width::N},
{0x11345,static_cast<East_Asian_Width>(0)},
{0x11347,East_Asian_Width::N},
{0x11349,static_cast<East_Asian_Width>(0)},
{0x1134b,East_Asian_Width::N},
{0x1134e,static_cast<East_Asian_Width>(0)},
{0x11350,East_Asian_Width::N},
{0x11351,static_cast<East_Asian_Width>(0)},
{0x11357,East_Asian_Width::N},
{0x11358,static_cast<East_Asian_Width>(0)},
{0x1135d,East_Asian_Width::N},
{0x11364,static_cast<East_Asian_Width>(0)},
{0x11366,East_Asian_Width::N},
{0x1136d,static_cast<East_Asian_Width>(0)},
{0x11370,East_Asian_Width::N},
{0x11375,static_cast<East_Asian_Width>(0)},
{0x11480,East_Asian_Width::N},
{0x114c8,static_cast<East_Asian_Width>(0)},
{0x114d0,East_Asian_Width::N},
{0x114da,static_cast<East_Asian_Width>(0)},
{0x11580,East_Asian_Width::N},
{0x115b6,static_cast<East_Asian_Width>(0)},
{0x115b8,East_Asian_Width::N},
{0x115de,static_cast<East_Asian_Width>(0)},
{0x11600,East_Asian_Width::N},
{0x11645,static_cast<East_Asian_Width>(0)},
{0x11650,East_Asian_Width::N},
{0x1165a,static_cast<East_Asian_Width>(0)},
{0x11680,East_Asian_Width::N},
{0x116b8,static_cast<East_Asian_Width>(0)},
{0x116c0,East_Asian_Width::N},
{0x116ca,static_cast<East_Asian_Width>(0)},
{0x11700,East_Asian_Width::N},
{0x1171a,static_cast<East_Asian_Width>(0)},
{0x1171d,East_Asian_Width::N},
{0x1172c,static_cast<East_Asian_Width>(0)},
{0x11730,East_Asian_Width::N},
{0x11740,static_cast<East_Asian_Width>(0)},
{0x118a0,East_Asian_Width::N},
{0x118f3,static_cast<East_Asian_Width>(0)},
{0x118ff,East_Asian_Width::N},
{0x11900,static_cast<East_Asian_Width>(0)},
{0x11ac0,East_Asian_Width::N},
{0x11af9,static_cast<East_Asian_Width>(0)},
{0x12000,East_Asian_Width::N},
{0x1239a,static_cast<East_Asian_Width>(0)},
{0x12400,East_Asian_Width::N},
{0x1246f,static_cast<East_Asian_Width>(0)},
{0x12470,East_Asian_Width::N},
{0x12475,static_cast<East_Asian_Width>(0)},
{0x12480,East_Asian_Width::N},
{0x12544,static_cast<East_Asian_Width>(0)},
{0x13000,East_Asian_Width::N},
{0x1342f,static_cast<East_Asian_Width>(0)},
{0x14400,East_Asian_Width::N},
{0x14647,static_cast<East_Asian_Width>(0)},
{0x16800,East_Asian_Width::N},
{0x16a39,static_cast<East_Asian_Width>(0)},
{0x16a40,East_Asian_Width::N},
{0x16a5f,static_cast<East_Asian_Width>(0)},
{0x16a60,East_Asian_Width::N},
{0x16a6a,static_cast<East_Asian_Width>(0)},
{0x16a6e,East_Asian_Width::N},
{0x16a70,static_cast<East_Asian_Width>(0)},
{0x16ad0,East_Asian_Width::N},
{0x16aee,static_cast<East_Asian_Width>(0)},
{0x16af0,East_Asian_Width::N},
{0x16af6,static_cast<East_Asian_Width>(0)},
{0x16b00,East_Asian_Width::N},
{0x16b46,static_cast<East_Asian_Width>(0)},
{0x16b50,East_Asian_Width::N},
{0x16b5a,static_cast<East_Asian_Width>(0)},
{0x16b5b,East_Asian_Width::N},
{0x16b62,static_cast<East_Asian_Width>(0)},
{0x16b63,East_Asian_Width::N},
{0x16b78,static_cast<East_Asian_Width>(0)},
{0x16b7d,East_Asian_Width::N},
{0x16b90,static_cast<East_Asian_Width>(0)},
{0x16f00,East_Asian_Width::N},
{0x16f45,static_cast<East_Asian_Width>(0)},
{0x16f50,East_Asian_Width::N},
{0x16f7f,static_cast<East_Asian_Width>(0)},
{0x16f8f,East_Asian_Width::N},
{0x16fa0,static_cast<East_Asian_Width>(0)},
{0x1b000,East_Asian_Width::W},
{0x1b002,static_cast<East_Asian_Width>(0)},
{0x1bc00,East_Asian_Width::N},
{0x1bc6b,static_cast<East_Asian_Width>(0)},
{0x1bc70,East_Asian_Width::N},
{0x1bc7d,static_cast<East_Asian_Width>(0)},
{0x1bc80,East_Asian_Width::N},
{0x1bc89,static_cast<East_Asian_Width>(0)},
{0x1bc90,East_Asian_Width::N},
{0x1bc9a,static_cast<East_Asian_Width>(0)},
{0x1bc9c,East_Asian_Width::N},
{0x1bca4,static_cast<East_Asian_Width>(0)},
{0x1d000,East_Asian_Width::N},
{0x1d0f6,static_cast<East_Asian_Width>(0)},
{0x1d100,East_Asian_Width::N},
{0x1d127,static_cast<East_Asian_Width>(0)},
{0x1d129,East_Asian_Width::N},
{0x1d1e9,static_cast<East_Asian_Width>(0)},
{0x1d200,East_Asian_Width::N},
{0x1d246,static_cast<East_Asian_Width>(0)},
{0x1d300,East_Asian_Width::N},
{0x1d357,static_cast<East_Asian_Width>(0)},
{0x1d360,East_Asian_Width::N},
{0x1d372,static_cast<East_Asian_Width>(0)},
{0x1d400,East_Asian_Width::N},
{0x1d455,static_cast<East_Asian_Width>(0)},
{0x1d456,East_Asian_Width::N},
{0x1d49d,static_cast<East_Asian_Width>(0)},
{0x1d49e,East_Asian_Width::N},
{0x1d4a0,static_cast<East_Asian_Width>(0)},
{0x1d4a2,East_Asian_Width::N},
{0x1d4a3,static_cast<East_Asian_Width>(0)},
{0x1d4a5,East_Asian_Width::N},
{0x1d4a7,static_cast<East_Asian_Width>(0)},
{0x1d4a9,East_Asian_Width::N},
{0x1d4ad,static_cast<East_Asian_Width>(0)},
{0x1d4ae,East_Asian_Width::N},
{0x1d4ba,static_cast<East_Asian_Width>(0)},
{0x1d4bb,East_Asian_Width::N},
{0x1d4bc,static_cast<East_Asian_Width>(0)},
{0x1d4bd,East_Asian_Width::N},
{0x1d4c4,static_cast<East_Asian_Width>(0)},
{0x1d4c5,East_Asian_Width::N},
{0x1d506,static_cast<East_Asian_Width>(0)},
{0x1d507,East_Asian_Width::N},
{0x1d50b,static_cast<East_Asian_Width>(0)},
{0x1d50d,East_Asian_Width::N},
{0x1d515,static_cast<East_Asian_Width>(0)},
{0x1d516,East_Asian_Width::N},
{0x1d51d,static_cast<East_Asian_Width>(0)},
{0x1d51e,East_Asian_Width::N},
{0x1d53a,static_cast<East_Asian_Width>(0)},
{0x1d53b,East_Asian_Width::N},
{0x1d53f,static_cast<East_Asian_Width>(0)},
{0x1d540,East_Asian_Width::N},
{0x1d545,static_cast<East_Asian_Width>(0)},
{0x1d546,East_Asian_Width::N},
{0x1d547,static_cast<East_Asian_Width>(0)},
{0x1d54a,East_Asian_Width::N},
{0x1d551,static_cast<East_Asian_Width>(0)},
{0x1d552,East_Asian_Width::N},
{0x1d6a6,static_cast<East_Asian_Width>(0)},
{0x1d6a8,East_Asian_Width::N},
{0x1d7cc,static_cast<East_Asian_Width>(0)},
{0x1d7ce,East_Asian_Width::N},
{0x1da8c,static_cast<East_Asian_Width>(0)},
{0x1da9b,East_Asian_Width::N},
{0x1daa0,static_cast<East_Asian_Width>(0)},
{0x1daa1,East_Asian_Width::N},
{0x1dab0,static_cast<East_Asian_Width>(0)},
{0x1e800,East_Asian_Width::N},
{0x1e8c5,static_cast<East_Asian_Width>(0)},
{0x1e8c7,East_Asian_Width::N},
{0x1e8d7,static_cast<East_Asian_Width>(0)},
{0x1ee00,East_Asian_Width::N},
{0x1ee04,static_cast<East_Asian_Width>(0)},
{0x1ee05,East_Asian_Width::N},
{0x1ee20,static_cast<East_Asian_Width>(0)},
{0x1ee21,East_Asian_Width::N},
{0x1ee23,static_cast<East_Asian_Width>(0)},
{0x1ee24,East_Asian_Width::N},
{0x1ee25,static_cast<East_Asian_Width>(0)},
{0x1ee27,East_Asian_Width::N},
{0x1ee28,static_cast<East_Asian_Width>(0)},
{0x1ee29,East_Asian_Width::N},
{0x1ee33,static_cast<East_Asian_Width>(0)},
{0x1ee34,East_Asian_Width::N},
{0x1ee38,static_cast<East_Asian_Width>(0)},
{0x1ee39,East_Asian_Width::N},
{0x1ee3a,static_cast<East_Asian_Width>(0)},
{0x1ee3b,East_Asian_Width::N},
{0x1ee3c,static_cast<East_Asian_Width>(0)},
{0x1ee42,East_Asian_Width::N},
{0x1ee43,static_cast<East_Asian_Width>(0)},
{0x1ee47,East_Asian_Width::N},
{0x1ee48,static_cast<East_Asian_Width>(0)},
{0x1ee49,East_Asian_Width::N},
{0x1ee4a,static_cast<East_Asian_Width>(0)},
{0x1ee4b,East_Asian_Width::N},
{0x1ee4c,static_cast<East_Asian_Width>(0)},
{0x1ee4d,East_Asian_Width::N},
{0x1ee50,static_cast<East_Asian_Width>(0)},
{0x1ee51,East_Asian_Width::N},
{0x1ee53,static_cast<East_Asian_Width>(0)},
{0x1ee54,East_Asian_Width::N},
{0x1ee55,static_cast<East_Asian_Width>(0)},
{0x1ee57,East_Asian_Width::N},
{0x1ee58,static_cast<East_Asian_Width>(0)},
{0x1ee59,East_Asian_Width::N},
{0x1ee5a,static_cast<East_Asian_Width>(0)},
{0x1ee5b,East_Asian_Width::N},
{0x1ee5c,static_cast<East_Asian_Width>(0)},
{0x1ee5d,East_Asian_Width::N},
{0x1ee5e,static_cast<East_Asian_Width>(0)},
{0x1ee5f,East_Asian_Width::N},
{0x1ee60,static_cast<East_Asian_Width>(0)},
{0x1ee61,East_Asian_Width::N},
{0x1ee63,static_cast<East_Asian_Width>(0)},
{0x1ee64,East_Asian_Width::N},
{0x1ee65,static_cast<East_Asian_Width>(0)},
{0x1ee67,East_Asian_Width::N},
{0x1ee6b,static_cast<East_Asian_Width>(0)},
{0x1ee6c,East_Asian_Width::N},
{0x1ee73,static_cast<East_Asian_Width>(0)},
{0x1ee74,East_Asian_Width::N},
{0x1ee78,static_cast<East_Asian_Width>(0)},
{0x1ee79,East_Asian_Width::N},
{0x1ee7d,static_cast<East_Asian_Width>(0)},
{0x1ee7e,East_Asian_Width::N},
{0x1ee7f,static_cast<East_Asian_Width>(0)},
{0x1ee80,East_Asian_Width::N},
{0x1ee8a,static_cast<East_Asian_Width>(0)},
{0x1ee8b,East_Asian_Width::N},
{0x1ee9c,static_cast<East_Asian_Width>(0)},
{0x1eea1,East_Asian_Width::N},
{0x1eea4,static_cast<East_Asian_Width>(0)},
{0x1eea5,East_Asian_Width::N},
{0x1eeaa,static_cast<East_Asian_Width>(0)},
{0x1eeab,East_Asian_Width::N},
{0x1eebc,static_cast<East_Asian_Width>(0)},
{0x1eef0,East_Asian_Width::N},
{0x1eef2,static_cast<East_Asian_Width>(0)},
{0x1f000,East_Asian_Width::N},
{0x1f02c,static_cast<East_Asian_Width>(0)},
{0x1f030,East_Asian_Width::N},
{0x1f094,static_cast<East_Asian_Width>(0)},
{0x1f0a0,East_Asian_Width::N},
{0x1f0af,static_cast<East_Asian_Width>(0)},
{0x1f0b1,East_Asian_Width::N},
{0x1f0c0,static_cast<East_Asian_Width>(0)},
{0x1f0c1,East_Asian_Width::N},
{0x1f0d0,static_cast<East_Asian_Width>(0)},
{0x1f0d1,East_Asian_Width::N},
{0x1f0f6,static_cast<East_Asian_Width>(0)},
{0x1f100,East_Asian_Width::A},
{0x1f10b,East_Asian_Width::N},
{0x1f10d,static_cast<East_Asian_Width>(0)},
{0x1f110,East_Asian_Width::A},
{0x1f12e,East_Asian_Width::N},
{0x1f12f,static_cast<East_Asian_Width>(0)},
{0x1f130,East_Asian_Width::A},
{0x1f16a,East_Asian_Width::N},
{0x1f16c,static_cast<East_Asian_Width>(0)},
{0x1f170,East_Asian_Width::A},
{0x1f19b,static_cast<East_Asian_Width>(0)},
{0x1f1e6,East_Asian_Width::N},
{0x1f200,East_Asian_Width::W},
{0x1f203,static_cast<East_Asian_Width>(0)},
{0x1f210,East_Asian_Width::W},
{0x1f23b,static_cast<East_Asian_Width>(0)},
{0x1f240,East_Asian_Width::W},
{0x1f249,static_cast<East_Asian_Width>(0)},
{0x1f250,East_Asian_Width::W},
{0x1f252,static_cast<East_Asian_Width>(0)},
{0x1f300,East_Asian_Width::N},
{0x1f57a,static_cast<East_Asian_Width>(0)},
{0x1f57b,East_Asian_Width::N},
{0x1f5a4,static_cast<East_Asian_Width>(0)},
{0x1f5a5,East_Asian_Width::N},
{0x1f6d1,static_cast<East_Asian_Width>(0)},
{0x1f6e0,East_Asian_Width::N},
{0x1f6ed,static_cast<East_Asian_Width>(0)},
{0x1f6f0,East_Asian_Width::N},
{0x1f6f4,static_cast<East_Asian_Width>(0)},
{0x1f700,East_Asian_Width::N},
{0x1f774,static_cast<East_Asian_Width>(0)},
{0x1f780,East_Asian_Width::N},
{0x1f7d5,static_cast<East_Asian_Width>(0)},
{0x1f800,East_Asian_Width::N},
{0x1f80c,static_cast<East_Asian_Width>(0)},
{0x1f810,East_Asian_Width::N},
{0x1f848,static_cast<East_Asian_Width>(0)},
{0x1f850,East_Asian_Width::N},
{0x1f85a,static_cast<East_Asian_Width>(0)},
{0x1f860,East_Asian_Width::N},
{0x1f888,static_cast<East_Asian_Width>(0)},
{0x1f890,East_Asian_Width::N},
{0x1f8ae,static_cast<East_Asian_Width>(0)},
{0x1f910,East_Asian_Width::N},
{0x1f919,static_cast<East_Asian_Width>(0)},
{0x1f980,East_Asian_Width::N},
{0x1f985,static_cast<East_Asian_Width>(0)},
{0x1f9c0,East_Asian_Width::N},
{0x1f9c1,static_cast<East_Asian_Width>(0)},
{0x20000,East_Asian_Width::W},
{0x2fffe,static_cast<East_Asian_Width>(0)},
{0x30000,East_Asian_Width::W},
{0x3fffe,static_cast<East_Asian_Width>(0)},
{0xe0001,East_Asian_Width::N},
{0xe0002,static_cast<East_Asian_Width>(0)},
{0xe0020,East_Asian_Width::N},
{0xe0080,static_cast<East_Asian_Width>(0)},
{0xe0100,East_Asian_Width::A},
{0xe01f0,static_cast<East_Asian_Width>(0)},
{0xf0000,East_Asian_Width::A},
{0xffffe,static_cast<East_Asian_Width>(0)},
{0x100000,East_Asian_Width::A},
{0x10fffe,static_cast<East_Asian_Width>(0)},
}};

const TableView<char32_t, East_Asian_Width> east_asian_width_table {&east_asian_width_array[0], &east_asian_width_array[0] + east_asian_width_array.size()};

const std::array<KeyValue<char32_t, Hangul_Syllable_Type>, 810> hangul_syllable_type_array = {{
{0x0,static_cast<Hangul_Syllable_Type>(0)},
{0x1100,Hangul_Syllable_Type::L},
{0x1160,Hangul_Syllable_Type::V},
{0x11a8,Hangul_Syllable_Type::T},
{0x1200,static_cast<Hangul_Syllable_Type>(0)},
{0xa960,Hangul_Syllable_Type::L},
{0xa97d,static_cast<Hangul_Syllable_Type>(0)},
{0xac00,Hangul_Syllable_Type::LV},
{0xac01,Hangul_Syllable_Type::LVT},
{0xac1c,Hangul_Syllable_Type::LV},
{0xac1d,Hangul_Syllable_Type::LVT},
{0xac38,Hangul_Syllable_Type::LV},
{0xac39,Hangul_Syllable_Type::LVT},
{0xac54,Hangul_Syllable_Type::LV},
{0xac55,Hangul_Syllable_Type::LVT},
{0xac70,Hangul_Syllable_Type::LV},
{0xac71,Hangul_Syllable_Type::LVT},
{0xac8c,Hangul_Syllable_Type::LV},
{0xac8d,Hangul_Syllable_Type::LVT},
{0xaca8,Hangul_Syllable_Type::LV},
{0xaca9,Hangul_Syllable_Type::LVT},
{0xacc4,Hangul_Syllable_Type::LV},
{0xacc5,Hangul_Syllable_Type::LVT},
{0xace0,Hangul_Syllable_Type::LV},
{0xace1,Hangul_Syllable_Type::LVT},
{0xacfc,Hangul_Syllable_Type::LV},
{0xacfd,Hangul_Syllable_Type::LVT},
{0xad18,Hangul_Syllable_Type::LV},
{0xad19,Hangul_Syllable_Type::LVT},
{0xad34,Hangul_Syllable_Type::LV},
{0xad35,Hangul_Syllable_Type::LVT},
{0xad50,Hangul_Syllable_Type::LV},
{0xad51,Hangul_Syllable_Type::LVT},
{0xad6c,Hangul_Syllable_Type::LV},
{0xad6d,Hangul_Syllable_Type::LVT},
{0xad88,Hangul_Syllable_Type::LV},
{0xad89,Hangul_Syllable_Type::LVT},
{0xada4,Hangul_Syllable_Type::LV},
{0xada5,Hangul_Syllable_Type::LVT},
{0xadc0,Hangul_Syllable_Type::LV},
{0xadc1,Hangul_Syllable_Type::LVT},
{0xaddc,Hangul_Syllable_Type::LV},
{0xaddd,Hangul_Syllable_Type::LVT},
{0xadf8,Hangul_Syllable_Type::LV},
{0xadf9,Hangul_Syllable_Type::LVT},
{0xae14,Hangul_Syllable_Type::LV},
{0xae15,Hangul_Syllable_Type::LVT},
{0xae30,Hangul_Syllable_Type::LV},
{0xae31,Hangul_Syllable_Type::LVT},
{0xae4c,Hangul_Syllable_Type::LV},
{0xae4d,Hangul_Syllable_Type::LVT},
{0xae68,Hangul_Syllable_Type::LV},
{0xae69,Hangul_Syllable_Type::LVT},
{0xae84,Hangul_Syllable_Type::LV},
{0xae85,Hangul_Syllable_Type::LVT},
{0xaea0,Hangul_Syllable_Type::LV},
{0xaea1,Hangul_Syllable_Type::LVT},
{0xaebc,Hangul_Syllable_Type::LV},
{0xaebd,Hangul_Syllable_Type::LVT},
{0xaed8,Hangul_Syllable_Type::LV},
{0xaed9,Hangul_Syllable_Type::LVT},
{0xaef4,Hangul_Syllable_Type::LV},
{0xaef5,Hangul_Syllable_Type::LVT},
{0xaf10,Hangul_Syllable_Type::LV},
{0xaf11,Hangul_Syllable_Type::LVT},
{0xaf2c,Hangul_Syllable_Type::LV},
{0xaf2d,Hangul_Syllable_Type::LVT},
{0xaf48,Hangul_Syllable_Type::LV},
{0xaf49,Hangul_Syllable_Type::LVT},
{0xaf64,Hangul_Syllable_Type::LV},
{0xaf65,Hangul_Syllable_Type::LVT},
{0xaf80,Hangul_Syllable_Type::LV},
{0xaf81,Hangul_Syllable_Type::LVT},
{0xaf9c,Hangul_Syllable_Type::LV},
{0xaf9d,Hangul_Syllable_Type::LVT},
{0xafb8,Hangul_Syllable_Type::LV},
{0xafb9,Hangul_Syllable_Type::LVT},
{0xafd4,Hangul_Syllable_Type::LV},
{0xafd5,Hangul_Syllable_Type::LVT},
{0xaff0,Hangul_Syllable_Type::LV},
{0xaff1,Hangul_Syllable_Type::LVT},
{0xb00c,Hangul_Syllable_Type::LV},
{0xb00d,Hangul_Syllable_Type::LVT},
{0xb028,Hangul_Syllable_Type::LV},
{0xb029,Hangul_Syllable_Type::LVT},
{0xb044,Hangul_Syllable_Type::LV},
{0xb045,Hangul_Syllable_Type::LVT},
{0xb060,Hangul_Syllable_Type::LV},
{0xb061,Hangul_Syllable_Type::LVT},
{0xb07c,Hangul_Syllable_Type::LV},
{0xb07d,Hangul_Syllable_Type::LVT},
{0xb098,Hangul_Syllable_Type::LV},
{0xb099,Hangul_Syllable_Type::LVT},
{0xb0b4,Hangul_Syllable_Type::LV},
{0xb0b5,Hangul_Syllable_Type::LVT},
{0xb0d0,Hangul_Syllable_Type::LV},
{0xb0d1,Hangul_Syllable_Type::LVT},
{0xb0ec,Hangul_Syllable_Type::LV},
{0xb0ed,Hangul_Syllable_Type::LVT},
{0xb108,Hangul_Syllable_Type::LV},
{0xb109,Hangul_Syllable_Type::LVT},
{0xb124,Hangul_Syllable_Type::LV},
{0xb125,Hangul_Syllable_Type::LVT},
{0xb140,Hangul_Syllable_Type::LV},
{0xb141,Hangul_Syllable_Type::LVT},
{0xb15c,Hangul_Syllable_Type::LV},
{0xb15d,Hangul_Syllable_Type::LVT},
{0xb178,Hangul_Syllable_Type::LV},
{0xb179,Hangul_Syllable_Type::LVT},
{0xb194,Hangul_Syllable_Type::LV},
{0xb195,Hangul_Syllable_Type::LVT},
{0xb1b0,Hangul_Syllable_Type::LV},
{0xb1b1,Hangul_Syllable_Type::LVT},
{0xb1cc,Hangul_Syllable_Type::LV},
{0xb1cd,Hangul_Syllable_Type::LVT},
{0xb1e8,Hangul_Syllable_Type::LV},
{0xb1e9,Hangul_Syllable_Type::LVT},
{0xb204,Hangul_Syllable_Type::LV},
{0xb205,Hangul_Syllable_Type::LVT},
{0xb220,Hangul_Syllable_Type::LV},
{0xb221,Hangul_Syllable_Type::LVT},
{0xb23c,Hangul_Syllable_Type::LV},
{0xb23d,Hangul_Syllable_Type::LVT},
{0xb258,Hangul_Syllable_Type::LV},
{0xb259,Hangul_Syllable_Type::LVT},
{0xb274,Hangul_Syllable_Type::LV},
{0xb275,Hangul_Syllable_Type::LVT},
{0xb290,Hangul_Syllable_Type::LV},
{0xb291,Hangul_Syllable_Type::LVT},
{0xb2ac,Hangul_Syllable_Type::LV},
{0xb2ad,Hangul_Syllable_Type::LVT},
{0xb2c8,Hangul_Syllable_Type::LV},
{0xb2c9,Hangul_Syllable_Type::LVT},
{0xb2e4,Hangul_Syllable_Type::LV},
{0xb2e5,Hangul_Syllable_Type::LVT},
{0xb300,Hangul_Syllable_Type::LV},
{0xb301,Hangul_Syllable_Type::LVT},
{0xb31c,Hangul_Syllable_Type::LV},
{0xb31d,Hangul_Syllable_Type::LVT},
{0xb338,Hangul_Syllable_Type::LV},
{0xb339,Hangul_Syllable_Type::LVT},
{0xb354,Hangul_Syllable_Type::LV},
{0xb355,Hangul_Syllable_Type::LVT},
{0xb370,Hangul_Syllable_Type::LV},
{0xb371,Hangul_Syllable_Type::LVT},
{0xb38c,Hangul_Syllable_Type::LV},
{0xb38d,Hangul_Syllable_Type::LVT},
{0xb3a8,Hangul_Syllable_Type::LV},
{0xb3a9,Hangul_Syllable_Type::LVT},
{0xb3c4,Hangul_Syllable_Type::LV},
{0xb3c5,Hangul_Syllable_Type::LVT},
{0xb3e0,Hangul_Syllable_Type::LV},
{0xb3e1,Hangul_Syllable_Type::LVT},
{0xb3fc,Hangul_Syllable_Type::LV},
{0xb3fd,Hangul_Syllable_Type::LVT},
{0xb418,Hangul_Syllable_Type::LV},
{0xb419,Hangul_Syllable_Type::LVT},
{0xb434,Hangul_Syllable_Type::LV},
{0xb435,Hangul_Syllable_Type::LVT},
{0xb450,Hangul_Syllable_Type::LV},
{0xb451,Hangul_Syllable_Type::LVT},
{0xb46c,Hangul_Syllable_Type::LV},
{0xb46d,Hangul_Syllable_Type::LVT},
{0xb488,Hangul_Syllable_Type::LV},
{0xb489,Hangul_Syllable_Type::LVT},
{0xb4a4,Hangul_Syllable_Type::LV},
{0xb4a5,Hangul_Syllable_Type::LVT},
{0xb4c0,Hangul_Syllable_Type::LV},
{0xb4c1,Hangul_Syllable_Type::LVT},
{0xb4dc,Hangul_Syllable_Type::LV},
{0xb4dd,Hangul_Syllable_Type::LVT},
{0xb4f8,Hangul_Syllable_Type::LV},
{0xb4f9,Hangul_Syllable_Type::LVT},
{0xb514,Hangul_Syllable_Type::LV},
{0xb515,Hangul_Syllable_Type::LVT},
{0xb530,Hangul_Syllable_Type::LV},
{0xb531,Hangul_Syllable_Type::LVT},
{0xb54c,Hangul_Syllable_Type::LV},
{0xb54d,Hangul_Syllable_Type::LVT},
{0xb568,Hangul_Syllable_Type::LV},
{0xb569,Hangul_Syllable_Type::LVT},
{0xb584,Hangul_Syllable_Type::LV},
{0xb585,Hangul_Syllable_Type::LVT},
{0xb5a0,Hangul_Syllable_Type::LV},
{0xb5a1,Hangul_Syllable_Type::LVT},
{0xb5bc,Hangul_Syllable_Type::LV},
{0xb5bd,Hangul_Syllable_Type::LVT},
{0xb5d8,Hangul_Syllable_Type::LV},
{0xb5d9,Hangul_Syllable_Type::LVT},
{0xb5f4,Hangul_Syllable_Type::LV},
{0xb5f5,Hangul_Syllable_Type::LVT},
{0xb610,Hangul_Syllable_Type::LV},
{0xb611,Hangul_Syllable_Type::LVT},
{0xb62c,Hangul_Syllable_Type::LV},
{0xb62d,Hangul_Syllable_Type::LVT},
{0xb648,Hangul_Syllable_Type::LV},
{0xb649,Hangul_Syllable_Type::LVT},
{0xb664,Hangul_Syllable_Type::LV},
{0xb665,Hangul_Syllable_Type::LVT},
{0xb680,Hangul_Syllable_Type::LV},
{0xb681,Hangul_Syllable_Type::LVT},
{0xb69c,Hangul_Syllable_Type::LV},
{0xb69d,Hangul_Syllable_Type::LVT},
{0xb6b8,Hangul_Syllable_Type::LV},
{0xb6b9,Hangul_Syllable_Type::LVT},
{0xb6d4,Hangul_Syllable_Type::LV},
{0xb6d5,Hangul_Syllable_Type::LVT},
{0xb6f0,Hangul_Syllable_Type::LV},
{0xb6f1,Hangul_Syllable_Type::LVT},
{0xb70c,Hangul_Syllable_Type::LV},
{0xb70d,Hangul_Syllable_Type::LVT},
{0xb728,Hangul_Syllable_Type::LV},
{0xb729,Hangul_Syllable_Type::LVT},
{0xb744,Hangul_Syllable_Type::LV},
{0xb745,Hangul_Syllable_Type::LVT},
{0xb760,Hangul_Syllable_Type::LV},
{0xb761,Hangul_Syllable_Type::LVT},
{0xb77c,Hangul_Syllable_Type::LV},
{0xb77d,Hangul_Syllable_Type::LVT},
{0xb798,Hangul_Syllable_Type::LV},
{0xb799,Hangul_Syllable_Type::LVT},
{0xb7b4,Hangul_Syllable_Type::LV},
{0xb7b5,Hangul_Syllable_Type::LVT},
{0xb7d0,Hangul_Syllable_Type::LV},
{0xb7d1,Hangul_Syllable_Type::LVT},
{0xb7ec,Hangul_Syllable_Type::LV},
{0xb7ed,Hangul_Syllable_Type::LVT},
{0xb808,Hangul_Syllable_Type::LV},
{0xb809,Hangul_Syllable_Type::LVT},
{0xb824,Hangul_Syllable_Type::LV},
{0xb825,Hangul_Syllable_Type::LVT},
{0xb840,Hangul_Syllable_Type::LV},
{0xb841,Hangul_Syllable_Type::LVT},
{0xb85c,Hangul_Syllable_Type::LV},
{0xb85d,Hangul_Syllable_Type::LVT},
{0xb878,Hangul_Syllable_Type::LV},
{0xb879,Hangul_Syllable_Type::LVT},
{0xb894,Hangul_Syllable_Type::LV},
{0xb895,Hangul_Syllable_Type::LVT},
{0xb8b0,Hangul_Syllable_Type::LV},
{0xb8b1,Hangul_Syllable_Type::LVT},
{0xb8cc,Hangul_Syllable_Type::LV},
{0xb8cd,Hangul_Syllable_Type::LVT},
{0xb8e8,Hangul_Syllable_Type::LV},
{0xb8e9,Hangul_Syllable_Type::LVT},
{0xb904,Hangul_Syllable_Type::LV},
{0xb905,Hangul_Syllable_Type::LVT},
{0xb920,Hangul_Syllable_Type::LV},
{0xb921,Hangul_Syllable_Type::LVT},
{0xb93c,Hangul_Syllable_Type::LV},
{0xb93d,Hangul_Syllable_Type::LVT},
{0xb958,Hangul_Syllable_Type::LV},
{0xb959,Hangul_Syllable_Type::LVT},
{0xb974,Hangul_Syllable_Type::LV},
{0xb975,Hangul_Syllable_Type::LVT},
{0xb990,Hangul_Syllable_Type::LV},
{0xb991,Hangul_Syllable_Type::LVT},
{0xb9ac,Hangul_Syllable_Type::LV},
{0xb9ad,Hangul_Syllable_Type::LVT},
{0xb9c8,Hangul_Syllable_Type::LV},
{0xb9c9,Hangul_Syllable_Type::LVT},
{0xb9e4,Hangul_Syllable_Type::LV},
{0xb9e5,Hangul_Syllable_Type::LVT},
{0xba00,Hangul_Syllable_Type::LV},
{0xba01,Hangul_Syllable_Type::LVT},
{0xba1c,Hangul_Syllable_Type::LV},
{0xba1d,Hangul_Syllable_Type::LVT},
{0xba38,Hangul_Syllable_Type::LV},
{0xba39,Hangul_Syllable_Type::LVT},
{0xba54,Hangul_Syllable_Type::LV},
{0xba55,Hangul_Syllable_Type::LVT},
{0xba70,Hangul_Syllable_Type::LV},
{0xba71,Hangul_Syllable_Type::LVT},
{0xba8c,Hangul_Syllable_Type::LV},
{0xba8d,Hangul_Syllable_Type::LVT},
{0xbaa8,Hangul_Syllable_Type::LV},
{0xbaa9,Hangul_Syllable_Type::LVT},
{0xbac4,Hangul_Syllable_Type::LV},
{0xbac5,Hangul_Syllable_Type::LVT},
{0xbae0,Hangul_Syllable_Type::LV},
{0xbae1,Hangul_Syllable_Type::LVT},
{0xbafc,Hangul_Syllable_Type::LV},
{0xbafd,Hangul_Syllable_Type::LVT},
{0xbb18,Hangul_Syllable_Type::LV},
{0xbb19,Hangul_Syllable_Type::LVT},
{0xbb34,Hangul_Syllable_Type::LV},
{0xbb35,Hangul_Syllable_Type::LVT},
{0xbb50,Hangul_Syllable_Type::LV},
{0xbb51,Hangul_Syllable_Type::LVT},
{0xbb6c,Hangul_Syllable_Type::LV},
{0xbb6d,Hangul_Syllable_Type::LVT},
{0xbb88,Hangul_Syllable_Type::LV},
{0xbb89,Hangul_Syllable_Type::LVT},
{0xbba4,Hangul_Syllable_Type::LV},
{0xbba5,Hangul_Syllable_Type::LVT},
{0xbbc0,Hangul_Syllable_Type::LV},
{0xbbc1,Hangul_Syllable_Type::LVT},
{0xbbdc,Hangul_Syllable_Type::LV},
{0xbbdd,Hangul_Syllable_Type::LVT},
{0xbbf8,Hangul_Syllable_Type::LV},
{0xbbf9,Hangul_Syllable_Type::LVT},
{0xbc14,Hangul_Syllable_Type::LV},
{0xbc15,Hangul_Syllable_Type::LVT},
{0xbc30,Hangul_Syllable_Type::LV},
{0xbc31,Hangul_Syllable_Type::LVT},
{0xbc4c,Hangul_Syllable_Type::LV},
{0xbc4d,Hangul_Syllable_Type::LVT},
{0xbc68,Hangul_Syllable_Type::LV},
{0xbc69,Hangul_Syllable_Type::LVT},
{0xbc84,Hangul_Syllable_Type::LV},
{0xbc85,Hangul_Syllable_Type::LVT},
{0xbca0,Hangul_Syllable_Type::LV},
{0xbca1,Hangul_Syllable_Type::LVT},
{0xbcbc,Hangul_Syllable_Type::LV},
{0xbcbd,Hangul_Syllable_Type::LVT},
{0xbcd8,Hangul_Syllable_Type::LV},
{0xbcd9,Hangul_Syllable_Type::LVT},
{0xbcf4,Hangul_Syllable_Type::LV},
{0xbcf5,Hangul_Syllable_Type::LVT},
{0xbd10,Hangul_Syllable_Type::LV},
{0xbd11,Hangul_Syllable_Type::LVT},
{0xbd2c,Hangul_Syllable_Type::LV},
{0xbd2d,Hangul_Syllable_Type::LVT},
{0xbd48,Hangul_Syllable_Type::LV},
{0xbd49,Hangul_Syllable_Type::LVT},
{0xbd64,Hangul_Syllable_Type::LV},
{0xbd65,Hangul_Syllable_Type::LVT},
{0xbd80,Hangul_Syllable_Type::LV},
{0xbd81,Hangul_Syllable_Type::LVT},
{0xbd9c,Hangul_Syllable_Type::LV},
{0xbd9d,Hangul_Syllable_Type::LVT},
{0xbdb8,Hangul_Syllable_Type::LV},
{0xbdb9,Hangul_Syllable_Type::LVT},
{0xbdd4,Hangul_Syllable_Type::LV},
{0xbdd5,Hangul_Syllable_Type::LVT},
{0xbdf0,Hangul_Syllable_Type::LV},
{0xbdf1,Hangul_Syllable_Type::LVT},
{0xbe0c,Hangul_Syllable_Type::LV},
{0xbe0d,Hangul_Syllable_Type::LVT},
{0xbe28,Hangul_Syllable_Type::LV},
{0xbe29,Hangul_Syllable_Type::LVT},
{0xbe44,Hangul_Syllable_Type::LV},
{0xbe45,Hangul_Syllable_Type::LVT},
{0xbe60,Hangul_Syllable_Type::LV},
{0xbe61,Hangul_Syllable_Type::LVT},
{0xbe7c,Hangul_Syllable_Type::LV},
{0xbe7d,Hangul_Syllable_Type::LVT},
{0xbe98,Hangul_Syllable_Type::LV},
{0xbe99,Hangul_Syllable_Type::LVT},
{0xbeb4,Hangul_Syllable_Type::LV},
{0xbeb5,Hangul_Syllable_Type::LVT},
{0xbed0,Hangul_Syllable_Type::LV},
{0xbed1,Hangul_Syllable_Type::LVT},
{0xbeec,Hangul_Syllable_Type::LV},
{0xbeed,Hangul_Syllable_Type::LVT},
{0xbf08,Hangul_Syllable_Type::LV},
{0xbf09,Hangul_Syllable_Type::LVT},
{0xbf24,Hangul_Syllable_Type::LV},
{0xbf25,Hangul_Syllable_Type::LVT},
{0xbf40,Hangul_Syllable_Type::LV},
{0xbf41,Hangul_Syllable_Type::LVT},
{0xbf5c,Hangul_Syllable_Type::LV},
{0xbf5d,Hangul_Syllable_Type::LVT},
{0xbf78,Hangul_Syllable_Type::LV},
{0xbf79,Hangul_Syllable_Type::LVT},
{0xbf94,Hangul_Syllable_Type::LV},
{0xbf95,Hangul_Syllable_Type::LVT},
{0xbfb0,Hangul_Syllable_Type::LV},
{0xbfb1,Hangul_Syllable_Type::LVT},
{0xbfcc,Hangul_Syllable_Type::LV},
{0xbfcd,Hangul_Syllable_Type::LVT},
{0xbfe8,Hangul_Syllable_Type::LV},
{0xbfe9,Hangul_Syllable_Type::LVT},
{0xc004,Hangul_Syllable_Type::LV},
{0xc005,Hangul_Syllable_Type::LVT},
{0xc020,Hangul_Syllable_Type::LV},
{0xc021,Hangul_Syllable_Type::LVT},
{0xc03c,Hangul_Syllable_Type::LV},
{0xc03d,Hangul_Syllable_Type::LVT},
{0xc058,Hangul_Syllable_Type::LV},
{0xc059,Hangul_Syllable_Type::LVT},
{0xc074,Hangul_Syllable_Type::LV},
{0xc075,Hangul_Syllable_Type::LVT},
{0xc090,Hangul_Syllable_Type::LV},
{0xc091,Hangul_Syllable_Type::LVT},
{0xc0ac,Hangul_Syllable_Type::LV},
{0xc0ad,Hangul_Syllable_Type::LVT},
{0xc0c8,Hangul_Syllable_Type::LV},
{0xc0c9,Hangul_Syllable_Type::LVT},
{0xc0e4,Hangul_Syllable_Type::LV},
{0xc0e5,Hangul_Syllable_Type::LVT},
{0xc100,Hangul_Syllable_Type::LV},
{0xc101,Hangul_Syllable_Type::LVT},
{0xc11c,Hangul_Syllable_Type::LV},
{0xc11d,Hangul_Syllable_Type::LVT},
{0xc138,Hangul_Syllable_Type::LV},
{0xc139,Hangul_Syllable_Type::LVT},
{0xc154,Hangul_Syllable_Type::LV},
{0xc155,Hangul_Syllable_Type::LVT},
{0xc170,Hangul_Syllable_Type::LV},
{0xc171,Hangul_Syllable_Type::LVT},
{0xc18c,Hangul_Syllable_Type::LV},
{0xc18d,Hangul_Syllable_Type::LVT},
{0xc1a8,Hangul_Syllable_Type::LV},
{0xc1a9,Hangul_Syllable_Type::LVT},
{0xc1c4,Hangul_Syllable_Type::LV},
{0xc1c5,Hangul_Syllable_Type::LVT},
{0xc1e0,Hangul_Syllable_Type::LV},
{0xc1e1,Hangul_Syllable_Type::LVT},
{0xc1fc,Hangul_Syllable_Type::LV},
{0xc1fd,Hangul_Syllable_Type::LVT},
{0xc218,Hangul_Syllable_Type::LV},
{0xc219,Hangul_Syllable_Type::LVT},
{0xc234,Hangul_Syllable_Type::LV},
{0xc235,Hangul_Syllable_Type::LVT},
{0xc250,Hangul_Syllable_Type::LV},
{0xc251,Hangul_Syllable_Type::LVT},
{0xc26c,Hangul_Syllable_Type::LV},
{0xc26d,Hangul_Syllable_Type::LVT},
{0xc288,Hangul_Syllable_Type::LV},
{0xc289,Hangul_Syllable_Type::LVT},
{0xc2a4,Hangul_Syllable_Type::LV},
{0xc2a5,Hangul_Syllable_Type::LVT},
{0xc2c0,Hangul_Syllable_Type::LV},
{0xc2c1,Hangul_Syllable_Type::LVT},
{0xc2dc,Hangul_Syllable_Type::LV},
{0xc2dd,Hangul_Syllable_Type::LVT},
{0xc2f8,Hangul_Syllable_Type::LV},
{0xc2f9,Hangul_Syllable_Type::LVT},
{0xc314,Hangul_Syllable_Type::LV},
{0xc315,Hangul_Syllable_Type::LVT},
{0xc330,Hangul_Syllable_Type::LV},
{0xc331,Hangul_Syllable_Type::LVT},
{0xc34c,Hangul_Syllable_Type::LV},
{0xc34d,Hangul_Syllable_Type::LVT},
{0xc368,Hangul_Syllable_Type::LV},
{0xc369,Hangul_Syllable_Type::LVT},
{0xc384,Hangul_Syllable_Type::LV},
{0xc385,Hangul_Syllable_Type::LVT},
{0xc3a0,Hangul_Syllable_Type::LV},
{0xc3a1,Hangul_Syllable_Type::LVT},
{0xc3bc,Hangul_Syllable_Type::LV},
{0xc3bd,Hangul_Syllable_Type::LVT},
{0xc3d8,Hangul_Syllable_Type::LV},
{0xc3d9,Hangul_Syllable_Type::LVT},
{0xc3f4,Hangul_Syllable_Type::LV},
{0xc3f5,Hangul_Syllable_Type::LVT},
{0xc410,Hangul_Syllable_Type::LV},
{0xc411,Hangul_Syllable_Type::LVT},
{0xc42c,Hangul_Syllable_Type::LV},
{0xc42d,Hangul_Syllable_Type::LVT},
{0xc448,Hangul_Syllable_Type::LV},
{0xc449,Hangul_Syllable_Type::LVT},
{0xc464,Hangul_Syllable_Type::LV},
{0xc465,Hangul_Syllable_Type::LVT},
{0xc480,Hangul_Syllable_Type::LV},
{0xc481,Hangul_Syllable_Type::LVT},
{0xc49c,Hangul_Syllable_Type::LV},
{0xc49d,Hangul_Syllable_Type::LVT},
{0xc4b8,Hangul_Syllable_Type::LV},
{0xc4b9,Hangul_Syllable_Type::LVT},
{0xc4d4,Hangul_Syllable_Type::LV},
{0xc4d5,Hangul_Syllable_Type::LVT},
{0xc4f0,Hangul_Syllable_Type::LV},
{0xc4f1,Hangul_Syllable_Type::LVT},
{0xc50c,Hangul_Syllable_Type::LV},
{0xc50d,Hangul_Syllable_Type::LVT},
{0xc528,Hangul_Syllable_Type::LV},
{0xc529,Hangul_Syllable_Type::LVT},
{0xc544,Hangul_Syllable_Type::LV},
{0xc545,Hangul_Syllable_Type::LVT},
{0xc560,Hangul_Syllable_Type::LV},
{0xc561,Hangul_Syllable_Type::LVT},
{0xc57c,Hangul_Syllable_Type::LV},
{0xc57d,Hangul_Syllable_Type::LVT},
{0xc598,Hangul_Syllable_Type::LV},
{0xc599,Hangul_Syllable_Type::LVT},
{0xc5b4,Hangul_Syllable_Type::LV},
{0xc5b5,Hangul_Syllable_Type::LVT},
{0xc5d0,Hangul_Syllable_Type::LV},
{0xc5d1,Hangul_Syllable_Type::LVT},
{0xc5ec,Hangul_Syllable_Type::LV},
{0xc5ed,Hangul_Syllable_Type::LVT},
{0xc608,Hangul_Syllable_Type::LV},
{0xc609,Hangul_Syllable_Type::LVT},
{0xc624,Hangul_Syllable_Type::LV},
{0xc625,Hangul_Syllable_Type::LVT},
{0xc640,Hangul_Syllable_Type::LV},
{0xc641,Hangul_Syllable_Type::LVT},
{0xc65c,Hangul_Syllable_Type::LV},
{0xc65d,Hangul_Syllable_Type::LVT},
{0xc678,Hangul_Syllable_Type::LV},
{0xc679,Hangul_Syllable_Type::LVT},
{0xc694,Hangul_Syllable_Type::LV},
{0xc695,Hangul_Syllable_Type::LVT},
{0xc6b0,Hangul_Syllable_Type::LV},
{0xc6b1,Hangul_Syllable_Type::LVT},
{0xc6cc,Hangul_Syllable_Type::LV},
{0xc6cd,Hangul_Syllable_Type::LVT},
{0xc6e8,Hangul_Syllable_Type::LV},
{0xc6e9,Hangul_Syllable_Type::LVT},
{0xc704,Hangul_Syllable_Type::LV},
{0xc705,Hangul_Syllable_Type::LVT},
{0xc720,Hangul_Syllable_Type::LV},
{0xc721,Hangul_Syllable_Type::LVT},
{0xc73c,Hangul_Syllable_Type::LV},
{0xc73d,Hangul_Syllable_Type::LVT},
{0xc758,Hangul_Syllable_Type::LV},
{0xc759,Hangul_Syllable_Type::LVT},
{0xc774,Hangul_Syllable_Type::LV},
{0xc775,Hangul_Syllable_Type::LVT},
{0xc790,Hangul_Syllable_Type::LV},
{0xc791,Hangul_Syllable_Type::LVT},
{0xc7ac,Hangul_Syllable_Type::LV},
{0xc7ad,Hangul_Syllable_Type::LVT},
{0xc7c8,Hangul_Syllable_Type::LV},
{0xc7c9,Hangul_Syllable_Type::LVT},
{0xc7e4,Hangul_Syllable_Type::LV},
{0xc7e5,Hangul_Syllable_Type::LVT},
{0xc800,Hangul_Syllable_Type::LV},
{0xc801,Hangul_Syllable_Type::LVT},
{0xc81c,Hangul_Syllable_Type::LV},
{0xc81d,Hangul_Syllable_Type::LVT},
{0xc838,Hangul_Syllable_Type::LV},
{0xc839,Hangul_Syllable_Type::LVT},
{0xc854,Hangul_Syllable_Type::LV},
{0xc855,Hangul_Syllable_Type::LVT},
{0xc870,Hangul_Syllable_Type::LV},
{0xc871,Hangul_Syllable_Type::LVT},
{0xc88c,Hangul_Syllable_Type::LV},
{0xc88d,Hangul_Syllable_Type::LVT},
{0xc8a8,Hangul_Syllable_Type::LV},
{0xc8a9,Hangul_Syllable_Type::LVT},
{0xc8c4,Hangul_Syllable_Type::LV},
{0xc8c5,Hangul_Syllable_Type::LVT},
{0xc8e0,Hangul_Syllable_Type::LV},
{0xc8e1,Hangul_Syllable_Type::LVT},
{0xc8fc,Hangul_Syllable_Type::LV},
{0xc8fd,Hangul_Syllable_Type::LVT},
{0xc918,Hangul_Syllable_Type::LV},
{0xc919,Hangul_Syllable_Type::LVT},
{0xc934,Hangul_Syllable_Type::LV},
{0xc935,Hangul_Syllable_Type::LVT},
{0xc950,Hangul_Syllable_Type::LV},
{0xc951,Hangul_Syllable_Type::LVT},
{0xc96c,Hangul_Syllable_Type::LV},
{0xc96d,Hangul_Syllable_Type::LVT},
{0xc988,Hangul_Syllable_Type::LV},
{0xc989,Hangul_Syllable_Type::LVT},
{0xc9a4,Hangul_Syllable_Type::LV},
{0xc9a5,Hangul_Syllable_Type::LVT},
{0xc9c0,Hangul_Syllable_Type::LV},
{0xc9c1,Hangul_Syllable_Type::LVT},
{0xc9dc,Hangul_Syllable_Type::LV},
{0xc9dd,Hangul_Syllable_Type::LVT},
{0xc9f8,Hangul_Syllable_Type::LV},
{0xc9f9,Hangul_Syllable_Type::LVT},
{0xca14,Hangul_Syllable_Type::LV},
{0xca15,Hangul_Syllable_Type::LVT},
{0xca30,Hangul_Syllable_Type::LV},
{0xca31,Hangul_Syllable_Type::LVT},
{0xca4c,Hangul_Syllable_Type::LV},
{0xca4d,Hangul_Syllable_Type::LVT},
{0xca68,Hangul_Syllable_Type::LV},
{0xca69,Hangul_Syllable_Type::LVT},
{0xca84,Hangul_Syllable_Type::LV},
{0xca85,Hangul_Syllable_Type::LVT},
{0xcaa0,Hangul_Syllable_Type::LV},
{0xcaa1,Hangul_Syllable_Type::LVT},
{0xcabc,Hangul_Syllable_Type::LV},
{0xcabd,Hangul_Syllable_Type::LVT},
{0xcad8,Hangul_Syllable_Type::LV},
{0xcad9,Hangul_Syllable_Type::LVT},
{0xcaf4,Hangul_Syllable_Type::LV},
{0xcaf5,Hangul_Syllable_Type::LVT},
{0xcb10,Hangul_Syllable_Type::LV},
{0xcb11,Hangul_Syllable_Type::LVT},
{0xcb2c,Hangul_Syllable_Type::LV},
{0xcb2d,Hangul_Syllable_Type::LVT},
{0xcb48,Hangul_Syllable_Type::LV},
{0xcb49,Hangul_Syllable_Type::LVT},
{0xcb64,Hangul_Syllable_Type::LV},
{0xcb65,Hangul_Syllable_Type::LVT},
{0xcb80,Hangul_Syllable_Type::LV},
{0xcb81,Hangul_Syllable_Type::LVT},
{0xcb9c,Hangul_Syllable_Type::LV},
{0xcb9d,Hangul_Syllable_Type::LVT},
{0xcbb8,Hangul_Syllable_Type::LV},
{0xcbb9,Hangul_Syllable_Type::LVT},
{0xcbd4,Hangul_Syllable_Type::LV},
{0xcbd5,Hangul_Syllable_Type::LVT},
{0xcbf0,Hangul_Syllable_Type::LV},
{0xcbf1,Hangul_Syllable_Type::LVT},
{0xcc0c,Hangul_Syllable_Type::LV},
{0xcc0d,Hangul_Syllable_Type::LVT},
{0xcc28,Hangul_Syllable_Type::LV},
{0xcc29,Hangul_Syllable_Type::LVT},
{0xcc44,Hangul_Syllable_Type::LV},
{0xcc45,Hangul_Syllable_Type::LVT},
{0xcc60,Hangul_Syllable_Type::LV},
{0xcc61,Hangul_Syllable_Type::LVT},
{0xcc7c,Hangul_Syllable_Type::LV},
{0xcc7d,Hangul_Syllable_Type::LVT},
{0xcc98,Hangul_Syllable_Type::LV},
{0xcc99,Hangul_Syllable_Type::LVT},
{0xccb4,Hangul_Syllable_Type::LV},
{0xccb5,Hangul_Syllable_Type::LVT},
{0xccd0,Hangul_Syllable_Type::LV},
{0xccd1,Hangul_Syllable_Type::LVT},
{0xccec,Hangul_Syllable_Type::LV},
{0xcced,Hangul_Syllable_Type::LVT},
{0xcd08,Hangul_Syllable_Type::LV},
{0xcd09,Hangul_Syllable_Type::LVT},
{0xcd24,Hangul_Syllable_Type::LV},
{0xcd25,Hangul_Syllable_Type::LVT},
{0xcd40,Hangul_Syllable_Type::LV},
{0xcd41,Hangul_Syllable_Type::LVT},
{0xcd5c,Hangul_Syllable_Type::LV},
{0xcd5d,Hangul_Syllable_Type::LVT},
{0xcd78,Hangul_Syllable_Type::LV},
{0xcd79,Hangul_Syllable_Type::LVT},
{0xcd94,Hangul_Syllable_Type::LV},
{0xcd95,Hangul_Syllable_Type::LVT},
{0xcdb0,Hangul_Syllable_Type::LV},
{0xcdb1,Hangul_Syllable_Type::LVT},
{0xcdcc,Hangul_Syllable_Type::LV},
{0xcdcd,Hangul_Syllable_Type::LVT},
{0xcde8,Hangul_Syllable_Type::LV},
{0xcde9,Hangul_Syllable_Type::LVT},
{0xce04,Hangul_Syllable_Type::LV},
{0xce05,Hangul_Syllable_Type::LVT},
{0xce20,Hangul_Syllable_Type::LV},
{0xce21,Hangul_Syllable_Type::LVT},
{0xce3c,Hangul_Syllable_Type::LV},
{0xce3d,Hangul_Syllable_Type::LVT},
{0xce58,Hangul_Syllable_Type::LV},
{0xce59,Hangul_Syllable_Type::LVT},
{0xce74,Hangul_Syllable_Type::LV},
{0xce75,Hangul_Syllable_Type::LVT},
{0xce90,Hangul_Syllable_Type::LV},
{0xce91,Hangul_Syllable_Type::LVT},
{0xceac,Hangul_Syllable_Type::LV},
{0xcead,Hangul_Syllable_Type::LVT},
{0xcec8,Hangul_Syllable_Type::LV},
{0xcec9,Hangul_Syllable_Type::LVT},
{0xcee4,Hangul_Syllable_Type::LV},
{0xcee5,Hangul_Syllable_Type::LVT},
{0xcf00,Hangul_Syllable_Type::LV},
{0xcf01,Hangul_Syllable_Type::LVT},
{0xcf1c,Hangul_Syllable_Type::LV},
{0xcf1d,Hangul_Syllable_Type::LVT},
{0xcf38,Hangul_Syllable_Type::LV},
{0xcf39,Hangul_Syllable_Type::LVT},
{0xcf54,Hangul_Syllable_Type::LV},
{0xcf55,Hangul_Syllable_Type::LVT},
{0xcf70,Hangul_Syllable_Type::LV},
{0xcf71,Hangul_Syllable_Type::LVT},
{0xcf8c,Hangul_Syllable_Type::LV},
{0xcf8d,Hangul_Syllable_Type::LVT},
{0xcfa8,Hangul_Syllable_Type::LV},
{0xcfa9,Hangul_Syllable_Type::LVT},
{0xcfc4,Hangul_Syllable_Type::LV},
{0xcfc5,Hangul_Syllable_Type::LVT},
{0xcfe0,Hangul_Syllable_Type::LV},
{0xcfe1,Hangul_Syllable_Type::LVT},
{0xcffc,Hangul_Syllable_Type::LV},
{0xcffd,Hangul_Syllable_Type::LVT},
{0xd018,Hangul_Syllable_Type::LV},
{0xd019,Hangul_Syllable_Type::LVT},
{0xd034,Hangul_Syllable_Type::LV},
{0xd035,Hangul_Syllable_Type::LVT},
{0xd050,Hangul_Syllable_Type::LV},
{0xd051,Hangul_Syllable_Type::LVT},
{0xd06c,Hangul_Syllable_Type::LV},
{0xd06d,Hangul_Syllable_Type::LVT},
{0xd088,Hangul_Syllable_Type::LV},
{0xd089,Hangul_Syllable_Type::LVT},
{0xd0a4,Hangul_Syllable_Type::LV},
{0xd0a5,Hangul_Syllable_Type::LVT},
{0xd0c0,Hangul_Syllable_Type::LV},
{0xd0c1,Hangul_Syllable_Type::LVT},
{0xd0dc,Hangul_Syllable_Type::LV},
{0xd0dd,Hangul_Syllable_Type::LVT},
{0xd0f8,Hangul_Syllable_Type::LV},
{0xd0f9,Hangul_Syllable_Type::LVT},
{0xd114,Hangul_Syllable_Type::LV},
{0xd115,Hangul_Syllable_Type::LVT},
{0xd130,Hangul_Syllable_Type::LV},
{0xd131,Hangul_Syllable_Type::LVT},
{0xd14c,Hangul_Syllable_Type::LV},
{0xd14d,Hangul_Syllable_Type::LVT},
{0xd168,Hangul_Syllable_Type::LV},
{0xd169,Hangul_Syllable_Type::LVT},
{0xd184,Hangul_Syllable_Type::LV},
{0xd185,Hangul_Syllable_Type::LVT},
{0xd1a0,Hangul_Syllable_Type::LV},
{0xd1a1,Hangul_Syllable_Type::LVT},
{0xd1bc,Hangul_Syllable_Type::LV},
{0xd1bd,Hangul_Syllable_Type::LVT},
{0xd1d8,Hangul_Syllable_Type::LV},
{0xd1d9,Hangul_Syllable_Type::LVT},
{0xd1f4,Hangul_Syllable_Type::LV},
{0xd1f5,Hangul_Syllable_Type::LVT},
{0xd210,Hangul_Syllable_Type::LV},
{0xd211,Hangul_Syllable_Type::LVT},
{0xd22c,Hangul_Syllable_Type::LV},
{0xd22d,Hangul_Syllable_Type::LVT},
{0xd248,Hangul_Syllable_Type::LV},
{0xd249,Hangul_Syllable_Type::LVT},
{0xd264,Hangul_Syllable_Type::LV},
{0xd265,Hangul_Syllable_Type::LVT},
{0xd280,Hangul_Syllable_Type::LV},
{0xd281,Hangul_Syllable_Type::LVT},
{0xd29c,Hangul_Syllable_Type::LV},
{0xd29d,Hangul_Syllable_Type::LVT},
{0xd2b8,Hangul_Syllable_Type::LV},
{0xd2b9,Hangul_Syllable_Type::LVT},
{0xd2d4,Hangul_Syllable_Type::LV},
{0xd2d5,Hangul_Syllable_Type::LVT},
{0xd2f0,Hangul_Syllable_Type::LV},
{0xd2f1,Hangul_Syllable_Type::LVT},
{0xd30c,Hangul_Syllable_Type::LV},
{0xd30d,Hangul_Syllable_Type::LVT},
{0xd328,Hangul_Syllable_Type::LV},
{0xd329,Hangul_Syllable_Type::LVT},
{0xd344,Hangul_Syllable_Type::LV},
{0xd345,Hangul_Syllable_Type::LVT},
{0xd360,Hangul_Syllable_Type::LV},
{0xd361,Hangul_Syllable_Type::LVT},
{0xd37c,Hangul_Syllable_Type::LV},
{0xd37d,Hangul_Syllable_Type::LVT},
{0xd398,Hangul_Syllable_Type::LV},
{0xd399,Hangul_Syllable_Type::LVT},
{0xd3b4,Hangul_Syllable_Type::LV},
{0xd3b5,Hangul_Syllable_Type::LVT},
{0xd3d0,Hangul_Syllable_Type::LV},
{0xd3d1,Hangul_Syllable_Type::LVT},
{0xd3ec,Hangul_Syllable_Type::LV},
{0xd3ed,Hangul_Syllable_Type::LVT},
{0xd408,Hangul_Syllable_Type::LV},
{0xd409,Hangul_Syllable_Type::LVT},
{0xd424,Hangul_Syllable_Type::LV},
{0xd425,Hangul_Syllable_Type::LVT},
{0xd440,Hangul_Syllable_Type::LV},
{0xd441,Hangul_Syllable_Type::LVT},
{0xd45c,Hangul_Syllable_Type::LV},
{0xd45d,Hangul_Syllable_Type::LVT},
{0xd478,Hangul_Syllable_Type::LV},
{0xd479,Hangul_Syllable_Type::LVT},
{0xd494,Hangul_Syllable_Type::LV},
{0xd495,Hangul_Syllable_Type::LVT},
{0xd4b0,Hangul_Syllable_Type::LV},
{0xd4b1,Hangul_Syllable_Type::LVT},
{0xd4cc,Hangul_Syllable_Type::LV},
{0xd4cd,Hangul_Syllable_Type::LVT},
{0xd4e8,Hangul_Syllable_Type::LV},
{0xd4e9,Hangul_Syllable_Type::LVT},
{0xd504,Hangul_Syllable_Type::LV},
{0xd505,Hangul_Syllable_Type::LVT},
{0xd520,Hangul_Syllable_Type::LV},
{0xd521,Hangul_Syllable_Type::LVT},
{0xd53c,Hangul_Syllable_Type::LV},
{0xd53d,Hangul_Syllable_Type::LVT},
{0xd558,Hangul_Syllable_Type::LV},
{0xd559,Hangul_Syllable_Type::LVT},
{0xd574,Hangul_Syllable_Type::LV},
{0xd575,Hangul_Syllable_Type::LVT},
{0xd590,Hangul_Syllable_Type::LV},
{0xd591,Hangul_Syllable_Type::LVT},
{0xd5ac,Hangul_Syllable_Type::LV},
{0xd5ad,Hangul_Syllable_Type::LVT},
{0xd5c8,Hangul_Syllable_Type::LV},
{0xd5c9,Hangul_Syllable_Type::LVT},
{0xd5e4,Hangul_Syllable_Type::LV},
{0xd5e5,Hangul_Syllable_Type::LVT},
{0xd600,Hangul_Syllable_Type::LV},
{0xd601,Hangul_Syllable_Type::LVT},
{0xd61c,Hangul_Syllable_Type::LV},
{0xd61d,Hangul_Syllable_Type::LVT},
{0xd638,Hangul_Syllable_Type::LV},
{0xd639,Hangul_Syllable_Type::LVT},
{0xd654,Hangul_Syllable_Type::LV},
{0xd655,Hangul_Syllable_Type::LVT},
{0xd670,Hangul_Syllable_Type::LV},
{0xd671,Hangul_Syllable_Type::LVT},
{0xd68c,Hangul_Syllable_Type::LV},
{0xd68d,Hangul_Syllable_Type::LVT},
{0xd6a8,Hangul_Syllable_Type::LV},
{0xd6a9,Hangul_Syllable_Type::LVT},
{0xd6c4,Hangul_Syllable_Type::LV},
{0xd6c5,Hangul_Syllable_Type::LVT},
{0xd6e0,Hangul_Syllable_Type::LV},
{0xd6e1,Hangul_Syllable_Type::LVT},
{0xd6fc,Hangul_Syllable_Type::LV},
{0xd6fd,Hangul_Syllable_Type::LVT},
{0xd718,Hangul_Syllable_Type::LV},
{0xd719,Hangul_Syllable_Type::LVT},
{0xd734,Hangul_Syllable_Type::LV},
{0xd735,Hangul_Syllable_Type::LVT},
{0xd750,Hangul_Syllable_Type::LV},
{0xd751,Hangul_Syllable_Type::LVT},
{0xd76c,Hangul_Syllable_Type::LV},
{0xd76d,Hangul_Syllable_Type::LVT},
{0xd788,Hangul_Syllable_Type::LV},
{0xd789,Hangul_Syllable_Type::LVT},
{0xd7a4,static_cast<Hangul_Syllable_Type>(0)},
{0xd7b0,Hangul_Syllable_Type::V},
{0xd7c7,static_cast<Hangul_Syllable_Type>(0)},
{0xd7cb,Hangul_Syllable_Type::T},
{0xd7fc,static_cast<Hangul_Syllable_Type>(0)},
}};

const TableView<char32_t, Hangul_Syllable_Type> hangul_syllable_type_table {&hangul_syllable_type_array[0], &hangul_syllable_type_array[0] + hangul_syllable_type_array.size()};

const std::array<KeyValue<char32_t, Indic_Positional_Category>, 664> indic_positional_category_array = {{
{0x0,static_cast<Indic_Positional_Category>(0)},
{0x900,Indic_Positional_Category::Top},
{0x903,Indic_Positional_Category::Right},
{0x904,static_cast<Indic_Positional_Category>(0)},
{0x93a,Indic_Positional_Category::Top},
{0x93b,Indic_Positional_Category::Right},
{0x93c,Indic_Positional_Category::Bottom},
{0x93d,static_cast<Indic_Positional_Category>(0)},
{0x93e,Indic_Positional_Category::Right},
{0x93f,Indic_Positional_Category::Left},
{0x940,Indic_Positional_Category::Right},
{0x941,Indic_Positional_Category::Bottom},
{0x945,Indic_Positional_Category::Top},
{0x949,Indic_Positional_Category::Right},
{0x94d,Indic_Positional_Category::Bottom},
{0x94e,Indic_Positional_Category::Left},
{0x94f,Indic_Positional_Category::Right},
{0x950,static_cast<Indic_Positional_Category>(0)},
{0x951,Indic_Positional_Category::Top},
{0x952,Indic_Positional_Category::Bottom},
{0x953,Indic_Positional_Category::Top},
{0x956,Indic_Positional_Category::Bottom},
{0x958,static_cast<Indic_Positional_Category>(0)},
{0x962,Indic_Positional_Category::Bottom},
{0x964,static_cast<Indic_Positional_Category>(0)},
{0x981,Indic_Positional_Category::Top},
{0x982,Indic_Positional_Category::Right},
{0x984,static_cast<Indic_Positional_Category>(0)},
{0x9bc,Indic_Positional_Category::Bottom},
{0x9bd,static_cast<Indic_Positional_Category>(0)},
{0x9be,Indic_Positional_Category::Right},
{0x9bf,Indic_Positional_Category::Left},
{0x9c0,Indic_Positional_Category::Right},
{0x9c1,Indic_Positional_Category::Bottom},
{0x9c5,static_cast<Indic_Positional_Category>(0)},
{0x9c7,Indic_Positional_Category::Left},
{0x9c9,static_cast<Indic_Positional_Category>(0)},
{0x9cb,Indic_Positional_Category::Left_And_Right},
{0x9cd,Indic_Positional_Category::Bottom},
{0x9ce,static_cast<Indic_Positional_Category>(0)},
{0x9d7,Indic_Positional_Category::Right},
{0x9d8,static_cast<Indic_Positional_Category>(0)},
{0x9e2,Indic_Positional_Category::Bottom},
{0x9e4,static_cast<Indic_Positional_Category>(0)},
{0xa01,Indic_Positional_Category::Top},
{0xa03,Indic_Positional_Category::Right},
{0xa04,static_cast<Indic_Positional_Category>(0)},
{0xa3c,Indic_Positional_Category::Bottom},
{0xa3d,static_cast<Indic_Positional_Category>(0)},
{0xa3e,Indic_Positional_Category::Right},
{0xa3f,Indic_Positional_Category::Left},
{0xa40,Indic_Positional_Category::Right},
{0xa41,Indic_Positional_Category::Bottom},
{0xa43,static_cast<Indic_Positional_Category>(0)},
{0xa47,Indic_Positional_Category::Top},
{0xa49,static_cast<Indic_Positional_Category>(0)},
{0xa4b,Indic_Positional_Category::Top},
{0xa4d,Indic_Positional_Category::Bottom},
{0xa4e,static_cast<Indic_Positional_Category>(0)},
{0xa70,Indic_Positional_Category::Top},
{0xa72,static_cast<Indic_Positional_Category>(0)},
{0xa75,Indic_Positional_Category::Bottom},
{0xa76,static_cast<Indic_Positional_Category>(0)},
{0xa81,Indic_Positional_Category::Top},
{0xa83,Indic_Positional_Category::Right},
{0xa84,static_cast<Indic_Positional_Category>(0)},
{0xabc,Indic_Positional_Category::Bottom},
{0xabd,static_cast<Indic_Positional_Category>(0)},
{0xabe,Indic_Positional_Category::Right},
{0xabf,Indic_Positional_Category::Left},
{0xac0,Indic_Positional_Category::Right},
{0xac1,Indic_Positional_Category::Bottom},
{0xac5,Indic_Positional_Category::Top},
{0xac6,static_cast<Indic_Positional_Category>(0)},
{0xac7,Indic_Positional_Category::Top},
{0xac9,Indic_Positional_Category::Top_And_Right},
{0xaca,static_cast<Indic_Positional_Category>(0)},
{0xacb,Indic_Positional_Category::Right},
{0xacd,Indic_Positional_Category::Bottom},
{0xace,static_cast<Indic_Positional_Category>(0)},
{0xae2,Indic_Positional_Category::Bottom},
{0xae4,static_cast<Indic_Positional_Category>(0)},
{0xb01,Indic_Positional_Category::Top},
{0xb02,Indic_Positional_Category::Right},
{0xb04,static_cast<Indic_Positional_Category>(0)},
{0xb3c,Indic_Positional_Category::Bottom},
{0xb3d,static_cast<Indic_Positional_Category>(0)},
{0xb3e,Indic_Positional_Category::Right},
{0xb3f,Indic_Positional_Category::Top},
{0xb40,Indic_Positional_Category::Right},
{0xb41,Indic_Positional_Category::Bottom},
{0xb45,static_cast<Indic_Positional_Category>(0)},
{0xb47,Indic_Positional_Category::Left},
{0xb48,Indic_Positional_Category::Top_And_Left},
{0xb49,static_cast<Indic_Positional_Category>(0)},
{0xb4b,Indic_Positional_Category::Left_And_Right},
{0xb4c,Indic_Positional_Category::Top_And_Left_And_Right},
{0xb4d,Indic_Positional_Category::Bottom},
{0xb4e,static_cast<Indic_Positional_Category>(0)},
{0xb56,Indic_Positional_Category::Top},
{0xb57,Indic_Positional_Category::Top_And_Right},
{0xb58,static_cast<Indic_Positional_Category>(0)},
{0xb62,Indic_Positional_Category::Bottom},
{0xb64,static_cast<Indic_Positional_Category>(0)},
{0xb82,Indic_Positional_Category::Top},
{0xb83,static_cast<Indic_Positional_Category>(0)},
{0xbbe,Indic_Positional_Category::Right},
{0xbc0,Indic_Positional_Category::Top},
{0xbc1,Indic_Positional_Category::Right},
{0xbc3,static_cast<Indic_Positional_Category>(0)},
{0xbc6,Indic_Positional_Category::Left},
{0xbc9,static_cast<Indic_Positional_Category>(0)},
{0xbca,Indic_Positional_Category::Left_And_Right},
{0xbcd,Indic_Positional_Category::Top},
{0xbce,static_cast<Indic_Positional_Category>(0)},
{0xbd7,Indic_Positional_Category::Right},
{0xbd8,static_cast<Indic_Positional_Category>(0)},
{0xc00,Indic_Positional_Category::Top},
{0xc01,Indic_Positional_Category::Right},
{0xc04,static_cast<Indic_Positional_Category>(0)},
{0xc3e,Indic_Positional_Category::Top},
{0xc41,Indic_Positional_Category::Right},
{0xc45,static_cast<Indic_Positional_Category>(0)},
{0xc46,Indic_Positional_Category::Top},
{0xc48,Indic_Positional_Category::Top_And_Bottom},
{0xc49,static_cast<Indic_Positional_Category>(0)},
{0xc4a,Indic_Positional_Category::Top},
{0xc4e,static_cast<Indic_Positional_Category>(0)},
{0xc55,Indic_Positional_Category::Top},
{0xc56,Indic_Positional_Category::Bottom},
{0xc57,static_cast<Indic_Positional_Category>(0)},
{0xc62,Indic_Positional_Category::Bottom},
{0xc64,static_cast<Indic_Positional_Category>(0)},
{0xc81,Indic_Positional_Category::Top},
{0xc82,Indic_Positional_Category::Right},
{0xc84,static_cast<Indic_Positional_Category>(0)},
{0xcbc,Indic_Positional_Category::Bottom},
{0xcbd,static_cast<Indic_Positional_Category>(0)},
{0xcbe,Indic_Positional_Category::Right},
{0xcbf,Indic_Positional_Category::Top},
{0xcc0,Indic_Positional_Category::Top_And_Right},
{0xcc1,Indic_Positional_Category::Right},
{0xcc5,static_cast<Indic_Positional_Category>(0)},
{0xcc6,Indic_Positional_Category::Top},
{0xcc7,Indic_Positional_Category::Top_And_Right},
{0xcc9,static_cast<Indic_Positional_Category>(0)},
{0xcca,Indic_Positional_Category::Top_And_Right},
{0xccc,Indic_Positional_Category::Top},
{0xcce,static_cast<Indic_Positional_Category>(0)},
{0xcd5,Indic_Positional_Category::Right},
{0xcd7,static_cast<Indic_Positional_Category>(0)},
{0xce2,Indic_Positional_Category::Bottom},
{0xce4,static_cast<Indic_Positional_Category>(0)},
{0xd01,Indic_Positional_Category::Top},
{0xd02,Indic_Positional_Category::Right},
{0xd04,static_cast<Indic_Positional_Category>(0)},
{0xd3e,Indic_Positional_Category::Right},
{0xd43,Indic_Positional_Category::Bottom},
{0xd45,static_cast<Indic_Positional_Category>(0)},
{0xd46,Indic_Positional_Category::Left},
{0xd49,static_cast<Indic_Positional_Category>(0)},
{0xd4a,Indic_Positional_Category::Left_And_Right},
{0xd4d,Indic_Positional_Category::Top},
{0xd4e,static_cast<Indic_Positional_Category>(0)},
{0xd57,Indic_Positional_Category::Right},
{0xd58,static_cast<Indic_Positional_Category>(0)},
{0xd62,Indic_Positional_Category::Bottom},
{0xd64,static_cast<Indic_Positional_Category>(0)},
{0xd82,Indic_Positional_Category::Right},
{0xd84,static_cast<Indic_Positional_Category>(0)},
{0xdca,Indic_Positional_Category::Top},
{0xdcb,static_cast<Indic_Positional_Category>(0)},
{0xdcf,Indic_Positional_Category::Right},
{0xdd2,Indic_Positional_Category::Top},
{0xdd4,Indic_Positional_Category::Bottom},
{0xdd5,static_cast<Indic_Positional_Category>(0)},
{0xdd6,Indic_Positional_Category::Bottom},
{0xdd7,static_cast<Indic_Positional_Category>(0)},
{0xdd8,Indic_Positional_Category::Right},
{0xdd9,Indic_Positional_Category::Left},
{0xdda,Indic_Positional_Category::Top_And_Left},
{0xddb,Indic_Positional_Category::Left},
{0xddc,Indic_Positional_Category::Left_And_Right},
{0xddd,Indic_Positional_Category::Top_And_Left_And_Right},
{0xdde,Indic_Positional_Category::Left_And_Right},
{0xddf,Indic_Positional_Category::Right},
{0xde0,static_cast<Indic_Positional_Category>(0)},
{0xdf2,Indic_Positional_Category::Right},
{0xdf4,static_cast<Indic_Positional_Category>(0)},
{0xe30,Indic_Positional_Category::Right},
{0xe31,Indic_Positional_Category::Top},
{0xe32,Indic_Positional_Category::Right},
{0xe34,Indic_Positional_Category::Top},
{0xe38,Indic_Positional_Category::Bottom},
{0xe3b,static_cast<Indic_Positional_Category>(0)},
{0xe40,Indic_Positional_Category::Visual_Order_Left},
{0xe45,Indic_Positional_Category::Right},
{0xe46,static_cast<Indic_Positional_Category>(0)},
{0xe47,Indic_Positional_Category::Top},
{0xe4f,static_cast<Indic_Positional_Category>(0)},
{0xeb0,Indic_Positional_Category::Right},
{0xeb1,Indic_Positional_Category::Top},
{0xeb2,Indic_Positional_Category::Right},
{0xeb4,Indic_Positional_Category::Top},
{0xeb8,Indic_Positional_Category::Bottom},
{0xeba,static_cast<Indic_Positional_Category>(0)},
{0xebb,Indic_Positional_Category::Top},
{0xebc,Indic_Positional_Category::Bottom},
{0xebd,static_cast<Indic_Positional_Category>(0)},
{0xec0,Indic_Positional_Category::Visual_Order_Left},
{0xec5,static_cast<Indic_Positional_Category>(0)},
{0xec8,Indic_Positional_Category::Top},
{0xece,static_cast<Indic_Positional_Category>(0)},
{0xf18,Indic_Positional_Category::Bottom},
{0xf1a,static_cast<Indic_Positional_Category>(0)},
{0xf35,Indic_Positional_Category::Bottom},
{0xf36,static_cast<Indic_Positional_Category>(0)},
{0xf37,Indic_Positional_Category::Bottom},
{0xf38,static_cast<Indic_Positional_Category>(0)},
{0xf39,Indic_Positional_Category::Top},
{0xf3a,static_cast<Indic_Positional_Category>(0)},
{0xf3e,Indic_Positional_Category::Right},
{0xf3f,Indic_Positional_Category::Left},
{0xf40,static_cast<Indic_Positional_Category>(0)},
{0xf71,Indic_Positional_Category::Bottom},
{0xf72,Indic_Positional_Category::Top},
{0xf73,Indic_Positional_Category::Top_And_Bottom},
{0xf74,Indic_Positional_Category::Bottom},
{0xf76,Indic_Positional_Category::Top_And_Bottom},
{0xf7a,Indic_Positional_Category::Top},
{0xf7f,Indic_Positional_Category::Right},
{0xf80,Indic_Positional_Category::Top},
{0xf81,Indic_Positional_Category::Top_And_Bottom},
{0xf82,Indic_Positional_Category::Top},
{0xf84,Indic_Positional_Category::Bottom},
{0xf85,static_cast<Indic_Positional_Category>(0)},
{0xf86,Indic_Positional_Category::Top},
{0xf88,static_cast<Indic_Positional_Category>(0)},
{0xf8d,Indic_Positional_Category::Bottom},
{0xf98,static_cast<Indic_Positional_Category>(0)},
{0xf99,Indic_Positional_Category::Bottom},
{0xfbd,static_cast<Indic_Positional_Category>(0)},
{0xfc6,Indic_Positional_Category::Bottom},
{0xfc7,static_cast<Indic_Positional_Category>(0)},
{0x102b,Indic_Positional_Category::Right},
{0x102d,Indic_Positional_Category::Top},
{0x102f,Indic_Positional_Category::Bottom},
{0x1031,Indic_Positional_Category::Left},
{0x1032,Indic_Positional_Category::Top},
{0x1037,Indic_Positional_Category::Bottom},
{0x1038,Indic_Positional_Category::Right},
{0x1039,static_cast<Indic_Positional_Category>(0)},
{0x103a,Indic_Positional_Category::Top},
{0x103b,Indic_Positional_Category::Right},
{0x103c,static_cast<Indic_Positional_Category>(0)},
{0x103d,Indic_Positional_Category::Bottom},
{0x103f,static_cast<Indic_Positional_Category>(0)},
{0x1056,Indic_Positional_Category::Right},
{0x1058,Indic_Positional_Category::Bottom},
{0x105a,static_cast<Indic_Positional_Category>(0)},
{0x105e,Indic_Positional_Category::Bottom},
{0x1061,static_cast<Indic_Positional_Category>(0)},
{0x1062,Indic_Positional_Category::Right},
{0x1065,static_cast<Indic_Positional_Category>(0)},
{0x1067,Indic_Positional_Category::Right},
{0x106e,static_cast<Indic_Positional_Category>(0)},
{0x1071,Indic_Positional_Category::Top},
{0x1075,static_cast<Indic_Positional_Category>(0)},
{0x1082,Indic_Positional_Category::Bottom},
{0x1083,Indic_Positional_Category::Right},
{0x1084,Indic_Positional_Category::Left},
{0x1085,Indic_Positional_Category::Top},
{0x1087,Indic_Positional_Category::Right},
{0x108d,Indic_Positional_Category::Bottom},
{0x108e,static_cast<Indic_Positional_Category>(0)},
{0x108f,Indic_Positional_Category::Right},
{0x1090,static_cast<Indic_Positional_Category>(0)},
{0x109a,Indic_Positional_Category::Right},
{0x109d,Indic_Positional_Category::Top},
{0x109e,static_cast<Indic_Positional_Category>(0)},
{0x1712,Indic_Positional_Category::Top},
{0x1713,Indic_Positional_Category::Bottom},
{0x1715,static_cast<Indic_Positional_Category>(0)},
{0x1732,Indic_Positional_Category::Top},
{0x1733,Indic_Positional_Category::Bottom},
{0x1735,static_cast<Indic_Positional_Category>(0)},
{0x1752,Indic_Positional_Category::Top},
{0x1753,Indic_Positional_Category::Bottom},
{0x1754,static_cast<Indic_Positional_Category>(0)},
{0x1772,Indic_Positional_Category::Top},
{0x1773,Indic_Positional_Category::Bottom},
{0x1774,static_cast<Indic_Positional_Category>(0)},
{0x17b6,Indic_Positional_Category::Right},
{0x17b7,Indic_Positional_Category::Top},
{0x17bb,Indic_Positional_Category::Bottom},
{0x17be,Indic_Positional_Category::Top_And_Left},
{0x17bf,Indic_Positional_Category::Top_And_Left_And_Right},
{0x17c0,Indic_Positional_Category::Left_And_Right},
{0x17c1,Indic_Positional_Category::Left},
{0x17c4,Indic_Positional_Category::Left_And_Right},
{0x17c6,Indic_Positional_Category::Top},
{0x17c7,Indic_Positional_Category::Right},
{0x17c9,Indic_Positional_Category::Top},
{0x17d2,static_cast<Indic_Positional_Category>(0)},
{0x17d3,Indic_Positional_Category::Top},
{0x17d4,static_cast<Indic_Positional_Category>(0)},
{0x17dd,Indic_Positional_Category::Top},
{0x17de,static_cast<Indic_Positional_Category>(0)},
{0x1920,Indic_Positional_Category::Top},
{0x1922,Indic_Positional_Category::Bottom},
{0x1923,Indic_Positional_Category::Right},
{0x1925,Indic_Positional_Category::Top_And_Right},
{0x1927,Indic_Positional_Category::Top},
{0x1929,Indic_Positional_Category::Right},
{0x192c,static_cast<Indic_Positional_Category>(0)},
{0x1930,Indic_Positional_Category::Right},
{0x1932,Indic_Positional_Category::Bottom},
{0x1933,Indic_Positional_Category::Right},
{0x1939,Indic_Positional_Category::Bottom},
{0x193a,Indic_Positional_Category::Top},
{0x193b,Indic_Positional_Category::Bottom},
{0x193c,static_cast<Indic_Positional_Category>(0)},
{0x19b0,Indic_Positional_Category::Right},
{0x19b5,Indic_Positional_Category::Visual_Order_Left},
{0x19b8,Indic_Positional_Category::Right},
{0x19ba,Indic_Positional_Category::Visual_Order_Left},
{0x19bb,Indic_Positional_Category::Right},
{0x19c1,static_cast<Indic_Positional_Category>(0)},
{0x19c8,Indic_Positional_Category::Right},
{0x19ca,static_cast<Indic_Positional_Category>(0)},
{0x1a17,Indic_Positional_Category::Top},
{0x1a18,Indic_Positional_Category::Bottom},
{0x1a19,Indic_Positional_Category::Left},
{0x1a1a,Indic_Positional_Category::Right},
{0x1a1b,Indic_Positional_Category::Top},
{0x1a1c,static_cast<Indic_Positional_Category>(0)},
{0x1a55,Indic_Positional_Category::Left},
{0x1a56,Indic_Positional_Category::Bottom},
{0x1a57,Indic_Positional_Category::Right},
{0x1a58,Indic_Positional_Category::Top},
{0x1a5b,Indic_Positional_Category::Bottom},
{0x1a5f,static_cast<Indic_Positional_Category>(0)},
{0x1a61,Indic_Positional_Category::Right},
{0x1a62,Indic_Positional_Category::Top},
{0x1a63,Indic_Positional_Category::Right},
{0x1a65,Indic_Positional_Category::Top},
{0x1a69,Indic_Positional_Category::Bottom},
{0x1a6b,Indic_Positional_Category::Top},
{0x1a6c,Indic_Positional_Category::Bottom},
{0x1a6d,Indic_Positional_Category::Right},
{0x1a6e,Indic_Positional_Category::Left},
{0x1a73,Indic_Positional_Category::Top},
{0x1a7d,static_cast<Indic_Positional_Category>(0)},
{0x1a7f,Indic_Positional_Category::Bottom},
{0x1a80,static_cast<Indic_Positional_Category>(0)},
{0x1b00,Indic_Positional_Category::Top},
{0x1b04,Indic_Positional_Category::Right},
{0x1b05,static_cast<Indic_Positional_Category>(0)},
{0x1b34,Indic_Positional_Category::Top},
{0x1b35,Indic_Positional_Category::Right},
{0x1b36,Indic_Positional_Category::Top},
{0x1b38,Indic_Positional_Category::Bottom},
{0x1b3b,Indic_Positional_Category::Bottom_And_Right},
{0x1b3c,Indic_Positional_Category::Top_And_Bottom},
{0x1b3d,Indic_Positional_Category::Top_And_Bottom_And_Right},
{0x1b3e,Indic_Positional_Category::Left},
{0x1b40,Indic_Positional_Category::Left_And_Right},
{0x1b42,Indic_Positional_Category::Top},
{0x1b43,Indic_Positional_Category::Top_And_Right},
{0x1b44,Indic_Positional_Category::Right},
{0x1b45,static_cast<Indic_Positional_Category>(0)},
{0x1b6b,Indic_Positional_Category::Top},
{0x1b6c,Indic_Positional_Category::Bottom},
{0x1b6d,Indic_Positional_Category::Top},
{0x1b74,static_cast<Indic_Positional_Category>(0)},
{0x1b80,Indic_Positional_Category::Top},
{0x1b82,Indic_Positional_Category::Right},
{0x1b83,static_cast<Indic_Positional_Category>(0)},
{0x1ba1,Indic_Positional_Category::Right},
{0x1ba2,Indic_Positional_Category::Bottom},
{0x1ba4,Indic_Positional_Category::Top},
{0x1ba5,Indic_Positional_Category::Bottom},
{0x1ba6,Indic_Positional_Category::Left},
{0x1ba7,Indic_Positional_Category::Right},
{0x1ba8,Indic_Positional_Category::Top},
{0x1baa,Indic_Positional_Category::Right},
{0x1bab,static_cast<Indic_Positional_Category>(0)},
{0x1bac,Indic_Positional_Category::Bottom},
{0x1bae,static_cast<Indic_Positional_Category>(0)},
{0x1be6,Indic_Positional_Category::Top},
{0x1be7,Indic_Positional_Category::Right},
{0x1be8,Indic_Positional_Category::Top},
{0x1bea,Indic_Positional_Category::Right},
{0x1bed,Indic_Positional_Category::Top},
{0x1bee,Indic_Positional_Category::Right},
{0x1bef,Indic_Positional_Category::Top},
{0x1bf2,Indic_Positional_Category::Right},
{0x1bf4,static_cast<Indic_Positional_Category>(0)},
{0x1c24,Indic_Positional_Category::Right},
{0x1c27,Indic_Positional_Category::Left},
{0x1c29,Indic_Positional_Category::Top_And_Left},
{0x1c2a,Indic_Positional_Category::Right},
{0x1c2c,Indic_Positional_Category::Bottom},
{0x1c2d,Indic_Positional_Category::Top},
{0x1c34,Indic_Positional_Category::Left},
{0x1c36,Indic_Positional_Category::Top},
{0x1c37,Indic_Positional_Category::Bottom},
{0x1c38,static_cast<Indic_Positional_Category>(0)},
{0x1cd0,Indic_Positional_Category::Top},
{0x1cd3,static_cast<Indic_Positional_Category>(0)},
{0x1cd4,Indic_Positional_Category::Overstruck},
{0x1cd5,Indic_Positional_Category::Bottom},
{0x1cda,Indic_Positional_Category::Top},
{0x1cdc,Indic_Positional_Category::Bottom},
{0x1ce0,Indic_Positional_Category::Top},
{0x1ce1,Indic_Positional_Category::Right},
{0x1ce2,Indic_Positional_Category::Overstruck},
{0x1ce9,static_cast<Indic_Positional_Category>(0)},
{0x1ced,Indic_Positional_Category::Bottom},
{0x1cee,static_cast<Indic_Positional_Category>(0)},
{0x1cf4,Indic_Positional_Category::Top},
{0x1cf5,static_cast<Indic_Positional_Category>(0)},
{0xa806,Indic_Positional_Category::Top},
{0xa807,static_cast<Indic_Positional_Category>(0)},
{0xa80b,Indic_Positional_Category::Top},
{0xa80c,static_cast<Indic_Positional_Category>(0)},
{0xa823,Indic_Positional_Category::Right},
{0xa825,Indic_Positional_Category::Bottom},
{0xa826,Indic_Positional_Category::Top},
{0xa827,Indic_Positional_Category::Right},
{0xa828,static_cast<Indic_Positional_Category>(0)},
{0xa880,Indic_Positional_Category::Right},
{0xa882,static_cast<Indic_Positional_Category>(0)},
{0xa8b4,Indic_Positional_Category::Right},
{0xa8c4,Indic_Positional_Category::Bottom},
{0xa8c5,static_cast<Indic_Positional_Category>(0)},
{0xa8e0,Indic_Positional_Category::Top},
{0xa8f2,static_cast<Indic_Positional_Category>(0)},
{0xa92b,Indic_Positional_Category::Bottom},
{0xa92e,static_cast<Indic_Positional_Category>(0)},
{0xa947,Indic_Positional_Category::Bottom},
{0xa94a,Indic_Positional_Category::Top},
{0xa94b,Indic_Positional_Category::Bottom},
{0xa94f,Indic_Positional_Category::Top},
{0xa952,Indic_Positional_Category::Right},
{0xa954,static_cast<Indic_Positional_Category>(0)},
{0xa980,Indic_Positional_Category::Top},
{0xa983,Indic_Positional_Category::Right},
{0xa984,static_cast<Indic_Positional_Category>(0)},
{0xa9b3,Indic_Positional_Category::Top},
{0xa9b4,Indic_Positional_Category::Right},
{0xa9b6,Indic_Positional_Category::Top},
{0xa9b8,Indic_Positional_Category::Bottom},
{0xa9ba,Indic_Positional_Category::Left},
{0xa9bc,Indic_Positional_Category::Top},
{0xa9bd,Indic_Positional_Category::Right},
{0xa9c0,Indic_Positional_Category::Bottom_And_Right},
{0xa9c1,static_cast<Indic_Positional_Category>(0)},
{0xa9e5,Indic_Positional_Category::Top},
{0xa9e6,static_cast<Indic_Positional_Category>(0)},
{0xaa29,Indic_Positional_Category::Top},
{0xaa2d,Indic_Positional_Category::Bottom},
{0xaa2e,Indic_Positional_Category::Top},
{0xaa2f,Indic_Positional_Category::Left},
{0xaa31,Indic_Positional_Category::Top},
{0xaa32,Indic_Positional_Category::Bottom},
{0xaa33,Indic_Positional_Category::Right},
{0xaa34,Indic_Positional_Category::Left},
{0xaa35,Indic_Positional_Category::Bottom},
{0xaa37,static_cast<Indic_Positional_Category>(0)},
{0xaa43,Indic_Positional_Category::Top},
{0xaa44,static_cast<Indic_Positional_Category>(0)},
{0xaa4c,Indic_Positional_Category::Top},
{0xaa4d,Indic_Positional_Category::Right},
{0xaa4e,static_cast<Indic_Positional_Category>(0)},
{0xaa7b,Indic_Positional_Category::Right},
{0xaa7c,Indic_Positional_Category::Top},
{0xaa7d,Indic_Positional_Category::Right},
{0xaa7e,static_cast<Indic_Positional_Category>(0)},
{0xaab0,Indic_Positional_Category::Top},
{0xaab1,Indic_Positional_Category::Right},
{0xaab2,Indic_Positional_Category::Top},
{0xaab4,Indic_Positional_Category::Bottom},
{0xaab5,Indic_Positional_Category::Visual_Order_Left},
{0xaab7,Indic_Positional_Category::Top},
{0xaab9,Indic_Positional_Category::Visual_Order_Left},
{0xaaba,Indic_Positional_Category::Right},
{0xaabb,Indic_Positional_Category::Visual_Order_Left},
{0xaabd,Indic_Positional_Category::Right},
{0xaabe,Indic_Positional_Category::Top},
{0xaac0,static_cast<Indic_Positional_Category>(0)},
{0xaac1,Indic_Positional_Category::Top},
{0xaac2,static_cast<Indic_Positional_Category>(0)},
{0xaaeb,Indic_Positional_Category::Left},
{0xaaec,Indic_Positional_Category::Bottom},
{0xaaed,Indic_Positional_Category::Top},
{0xaaee,Indic_Positional_Category::Left},
{0xaaef,Indic_Positional_Category::Right},
{0xaaf0,static_cast<Indic_Positional_Category>(0)},
{0xaaf5,Indic_Positional_Category::Right},
{0xaaf6,static_cast<Indic_Positional_Category>(0)},
{0xabe3,Indic_Positional_Category::Right},
{0xabe5,Indic_Positional_Category::Top},
{0xabe6,Indic_Positional_Category::Right},
{0xabe8,Indic_Positional_Category::Bottom},
{0xabe9,Indic_Positional_Category::Right},
{0xabeb,static_cast<Indic_Positional_Category>(0)},
{0xabec,Indic_Positional_Category::Right},
{0xabed,Indic_Positional_Category::Bottom},
{0xabee,static_cast<Indic_Positional_Category>(0)},
{0x10a01,Indic_Positional_Category::Overstruck},
{0x10a02,Indic_Positional_Category::Bottom},
{0x10a04,static_cast<Indic_Positional_Category>(0)},
{0x10a05,Indic_Positional_Category::Top},
{0x10a06,Indic_Positional_Category::Overstruck},
{0x10a07,static_cast<Indic_Positional_Category>(0)},
{0x10a0c,Indic_Positional_Category::Bottom},
{0x10a0f,Indic_Positional_Category::Top},
{0x10a10,static_cast<Indic_Positional_Category>(0)},
{0x10a38,Indic_Positional_Category::Top},
{0x10a39,Indic_Positional_Category::Bottom},
{0x10a3b,static_cast<Indic_Positional_Category>(0)},
{0x11000,Indic_Positional_Category::Right},
{0x11001,Indic_Positional_Category::Top},
{0x11002,Indic_Positional_Category::Right},
{0x11003,static_cast<Indic_Positional_Category>(0)},
{0x11038,Indic_Positional_Category::Top},
{0x1103c,Indic_Positional_Category::Bottom},
{0x11042,Indic_Positional_Category::Top},
{0x11047,static_cast<Indic_Positional_Category>(0)},
{0x11080,Indic_Positional_Category::Top},
{0x11082,Indic_Positional_Category::Right},
{0x11083,static_cast<Indic_Positional_Category>(0)},
{0x110b0,Indic_Positional_Category::Right},
{0x110b1,Indic_Positional_Category::Left},
{0x110b2,Indic_Positional_Category::Right},
{0x110b3,Indic_Positional_Category::Bottom},
{0x110b5,Indic_Positional_Category::Top},
{0x110b7,Indic_Positional_Category::Right},
{0x110b9,Indic_Positional_Category::Bottom},
{0x110bb,static_cast<Indic_Positional_Category>(0)},
{0x11100,Indic_Positional_Category::Top},
{0x11103,static_cast<Indic_Positional_Category>(0)},
{0x11127,Indic_Positional_Category::Top},
{0x1112a,Indic_Positional_Category::Bottom},
{0x1112c,Indic_Positional_Category::Left},
{0x1112d,Indic_Positional_Category::Top},
{0x1112e,Indic_Positional_Category::Top_And_Bottom},
{0x11130,Indic_Positional_Category::Top},
{0x11131,Indic_Positional_Category::Bottom},
{0x11133,static_cast<Indic_Positional_Category>(0)},
{0x11134,Indic_Positional_Category::Top},
{0x11135,static_cast<Indic_Positional_Category>(0)},
{0x11173,Indic_Positional_Category::Bottom},
{0x11174,static_cast<Indic_Positional_Category>(0)},
{0x11180,Indic_Positional_Category::Top},
{0x11182,Indic_Positional_Category::Right},
{0x11183,static_cast<Indic_Positional_Category>(0)},
{0x111b3,Indic_Positional_Category::Right},
{0x111b4,Indic_Positional_Category::Left},
{0x111b5,Indic_Positional_Category::Right},
{0x111b6,Indic_Positional_Category::Bottom},
{0x111bc,Indic_Positional_Category::Top},
{0x111bf,Indic_Positional_Category::Top_And_Right},
{0x111c0,Indic_Positional_Category::Right},
{0x111c1,static_cast<Indic_Positional_Category>(0)},
{0x111cb,Indic_Positional_Category::Top},
{0x111cc,Indic_Positional_Category::Bottom},
{0x111cd,static_cast<Indic_Positional_Category>(0)},
{0x1122c,Indic_Positional_Category::Right},
{0x1122f,Indic_Positional_Category::Bottom},
{0x11230,Indic_Positional_Category::Top},
{0x11232,Indic_Positional_Category::Top_And_Right},
{0x11234,Indic_Positional_Category::Top},
{0x11235,Indic_Positional_Category::Right},
{0x11236,Indic_Positional_Category::Top},
{0x11238,static_cast<Indic_Positional_Category>(0)},
{0x112df,Indic_Positional_Category::Top},
{0x112e0,Indic_Positional_Category::Right},
{0x112e1,Indic_Positional_Category::Left},
{0x112e2,Indic_Positional_Category::Right},
{0x112e3,Indic_Positional_Category::Bottom},
{0x112e5,Indic_Positional_Category::Top},
{0x112e9,Indic_Positional_Category::Bottom},
{0x112eb,static_cast<Indic_Positional_Category>(0)},
{0x11301,Indic_Positional_Category::Top},
{0x11302,Indic_Positional_Category::Right},
{0x11304,static_cast<Indic_Positional_Category>(0)},
{0x1133e,Indic_Positional_Category::Right},
{0x11340,Indic_Positional_Category::Top},
{0x11341,Indic_Positional_Category::Right},
{0x11345,static_cast<Indic_Positional_Category>(0)},
{0x11347,Indic_Positional_Category::Left},
{0x11349,static_cast<Indic_Positional_Category>(0)},
{0x1134b,Indic_Positional_Category::Left_And_Right},
{0x1134d,Indic_Positional_Category::Right},
{0x1134e,static_cast<Indic_Positional_Category>(0)},
{0x11357,Indic_Positional_Category::Right},
{0x11358,static_cast<Indic_Positional_Category>(0)},
{0x11362,Indic_Positional_Category::Right},
{0x11364,static_cast<Indic_Positional_Category>(0)},
{0x11366,Indic_Positional_Category::Top},
{0x1136d,static_cast<Indic_Positional_Category>(0)},
{0x11370,Indic_Positional_Category::Top},
{0x11375,static_cast<Indic_Positional_Category>(0)},
{0x114b0,Indic_Positional_Category::Right},
{0x114b1,Indic_Positional_Category::Left},
{0x114b2,Indic_Positional_Category::Right},
{0x114b3,Indic_Positional_Category::Bottom},
{0x114b9,Indic_Positional_Category::Left},
{0x114ba,Indic_Positional_Category::Top},
{0x114bb,Indic_Positional_Category::Top_And_Left},
{0x114bc,Indic_Positional_Category::Left_And_Right},
{0x114bd,Indic_Positional_Category::Right},
{0x114be,Indic_Positional_Category::Left_And_Right},
{0x114bf,Indic_Positional_Category::Top},
{0x114c1,Indic_Positional_Category::Right},
{0x114c2,Indic_Positional_Category::Bottom},
{0x114c4,static_cast<Indic_Positional_Category>(0)},
{0x115af,Indic_Positional_Category::Right},
{0x115b0,Indic_Positional_Category::Left},
{0x115b1,Indic_Positional_Category::Right},
{0x115b2,Indic_Positional_Category::Bottom},
{0x115b6,static_cast<Indic_Positional_Category>(0)},
{0x115b8,Indic_Positional_Category::Left},
{0x115b9,Indic_Positional_Category::Top_And_Left},
{0x115ba,Indic_Positional_Category::Left_And_Right},
{0x115bb,Indic_Positional_Category::Top_And_Left_And_Right},
{0x115bc,Indic_Positional_Category::Top},
{0x115be,Indic_Positional_Category::Right},
{0x115bf,Indic_Positional_Category::Bottom},
{0x115c1,static_cast<Indic_Positional_Category>(0)},
{0x115dc,Indic_Positional_Category::Bottom},
{0x115de,static_cast<Indic_Positional_Category>(0)},
{0x11630,Indic_Positional_Category::Right},
{0x11633,Indic_Positional_Category::Bottom},
{0x11639,Indic_Positional_Category::Top},
{0x1163b,Indic_Positional_Category::Right},
{0x1163d,Indic_Positional_Category::Top},
{0x1163e,Indic_Positional_Category::Right},
{0x1163f,Indic_Positional_Category::Bottom},
{0x11640,Indic_Positional_Category::Top},
{0x11641,static_cast<Indic_Positional_Category>(0)},
{0x116ab,Indic_Positional_Category::Top},
{0x116ac,Indic_Positional_Category::Right},
{0x116ad,Indic_Positional_Category::Top},
{0x116ae,Indic_Positional_Category::Left},
{0x116af,Indic_Positional_Category::Right},
{0x116b0,Indic_Positional_Category::Bottom},
{0x116b2,Indic_Positional_Category::Top},
{0x116b6,Indic_Positional_Category::Right},
{0x116b7,Indic_Positional_Category::Bottom},
{0x116b8,static_cast<Indic_Positional_Category>(0)},
{0x1171d,Indic_Positional_Category::Bottom},
{0x1171e,static_cast<Indic_Positional_Category>(0)},
{0x1171f,Indic_Positional_Category::Top},
{0x11720,Indic_Positional_Category::Right},
{0x11722,Indic_Positional_Category::Top},
{0x11724,Indic_Positional_Category::Bottom},
{0x11726,Indic_Positional_Category::Left},
{0x11727,Indic_Positional_Category::Top},
{0x11728,Indic_Positional_Category::Bottom},
{0x11729,Indic_Positional_Category::Top},
{0x1172c,static_cast<Indic_Positional_Category>(0)},
}};

const TableView<char32_t, Indic_Positional_Category> indic_positional_category_table {&indic_positional_category_array[0], &indic_positional_category_array[0] + indic_positional_category_array.size()};

const std::array<KeyValue<char32_t, Indic_Syllabic_Category>, 889> indic_syllabic_category_array = {{
{0x0,static_cast<Indic_Syllabic_Category>(0)},
{0x2d,Indic_Syllabic_Category::Consonant_Placeholder},
{0x2e,static_cast<Indic_Syllabic_Category>(0)},
{0x30,Indic_Syllabic_Category::Number},
{0x3a,static_cast<Indic_Syllabic_Category>(0)},
{0xa0,Indic_Syllabic_Category::Consonant_Placeholder},
{0xa1,static_cast<Indic_Syllabic_Category>(0)},
{0xb2,Indic_Syllabic_Category::Syllable_Modifier},
{0xb4,static_cast<Indic_Syllabic_Category>(0)},
{0xd7,Indic_Syllabic_Category::Consonant_Placeholder},
{0xd8,static_cast<Indic_Syllabic_Category>(0)},
{0x900,Indic_Syllabic_Category::Bindu},
{0x903,Indic_Syllabic_Category::Visarga},
{0x904,Indic_Syllabic_Category::Vowel_Independent},
{0x915,Indic_Syllabic_Category::Consonant},
{0x93a,Indic_Syllabic_Category::Vowel_Dependent},
{0x93c,Indic_Syllabic_Category::Nukta},
{0x93d,Indic_Syllabic_Category::Avagraha},
{0x93e,Indic_Syllabic_Category::Vowel_Dependent},
{0x94d,Indic_Syllabic_Category::Virama},
{0x94e,Indic_Syllabic_Category::Vowel_Dependent},
{0x950,static_cast<Indic_Syllabic_Category>(0)},
{0x951,Indic_Syllabic_Category::Cantillation_Mark},
{0x953,static_cast<Indic_Syllabic_Category>(0)},
{0x955,Indic_Syllabic_Category::Vowel_Dependent},
{0x958,Indic_Syllabic_Category::Consonant},
{0x960,Indic_Syllabic_Category::Vowel_Independent},
{0x962,Indic_Syllabic_Category::Vowel_Dependent},
{0x964,static_cast<Indic_Syllabic_Category>(0)},
{0x966,Indic_Syllabic_Category::Number},
{0x970,static_cast<Indic_Syllabic_Category>(0)},
{0x972,Indic_Syllabic_Category::Vowel_Independent},
{0x978,Indic_Syllabic_Category::Consonant},
{0x980,static_cast<Indic_Syllabic_Category>(0)},
{0x981,Indic_Syllabic_Category::Bindu},
{0x983,Indic_Syllabic_Category::Visarga},
{0x984,static_cast<Indic_Syllabic_Category>(0)},
{0x985,Indic_Syllabic_Category::Vowel_Independent},
{0x98d,static_cast<Indic_Syllabic_Category>(0)},
{0x98f,Indic_Syllabic_Category::Vowel_Independent},
{0x991,static_cast<Indic_Syllabic_Category>(0)},
{0x993,Indic_Syllabic_Category::Vowel_Independent},
{0x995,Indic_Syllabic_Category::Consonant},
{0x9a9,static_cast<Indic_Syllabic_Category>(0)},
{0x9aa,Indic_Syllabic_Category::Consonant},
{0x9b1,static_cast<Indic_Syllabic_Category>(0)},
{0x9b2,Indic_Syllabic_Category::Consonant},
{0x9b3,static_cast<Indic_Syllabic_Category>(0)},
{0x9b6,Indic_Syllabic_Category::Consonant},
{0x9ba,static_cast<Indic_Syllabic_Category>(0)},
{0x9bc,Indic_Syllabic_Category::Nukta},
{0x9bd,Indic_Syllabic_Category::Avagraha},
{0x9be,Indic_Syllabic_Category::Vowel_Dependent},
{0x9c5,static_cast<Indic_Syllabic_Category>(0)},
{0x9c7,Indic_Syllabic_Category::Vowel_Dependent},
{0x9c9,static_cast<Indic_Syllabic_Category>(0)},
{0x9cb,Indic_Syllabic_Category::Vowel_Dependent},
{0x9cd,Indic_Syllabic_Category::Virama},
{0x9ce,Indic_Syllabic_Category::Consonant_Dead},
{0x9cf,static_cast<Indic_Syllabic_Category>(0)},
{0x9d7,Indic_Syllabic_Category::Vowel_Dependent},
{0x9d8,static_cast<Indic_Syllabic_Category>(0)},
{0x9dc,Indic_Syllabic_Category::Consonant},
{0x9de,static_cast<Indic_Syllabic_Category>(0)},
{0x9df,Indic_Syllabic_Category::Consonant},
{0x9e0,Indic_Syllabic_Category::Vowel_Independent},
{0x9e2,Indic_Syllabic_Category::Vowel_Dependent},
{0x9e4,static_cast<Indic_Syllabic_Category>(0)},
{0x9e6,Indic_Syllabic_Category::Number},
{0x9f0,Indic_Syllabic_Category::Consonant},
{0x9f2,static_cast<Indic_Syllabic_Category>(0)},
{0xa01,Indic_Syllabic_Category::Bindu},
{0xa03,Indic_Syllabic_Category::Visarga},
{0xa04,static_cast<Indic_Syllabic_Category>(0)},
{0xa05,Indic_Syllabic_Category::Vowel_Independent},
{0xa0b,static_cast<Indic_Syllabic_Category>(0)},
{0xa0f,Indic_Syllabic_Category::Vowel_Independent},
{0xa11,static_cast<Indic_Syllabic_Category>(0)},
{0xa13,Indic_Syllabic_Category::Vowel_Independent},
{0xa15,Indic_Syllabic_Category::Consonant},
{0xa29,static_cast<Indic_Syllabic_Category>(0)},
{0xa2a,Indic_Syllabic_Category::Consonant},
{0xa31,static_cast<Indic_Syllabic_Category>(0)},
{0xa32,Indic_Syllabic_Category::Consonant},
{0xa34,static_cast<Indic_Syllabic_Category>(0)},
{0xa35,Indic_Syllabic_Category::Consonant},
{0xa37,static_cast<Indic_Syllabic_Category>(0)},
{0xa38,Indic_Syllabic_Category::Consonant},
{0xa3a,static_cast<Indic_Syllabic_Category>(0)},
{0xa3c,Indic_Syllabic_Category::Nukta},
{0xa3d,static_cast<Indic_Syllabic_Category>(0)},
{0xa3e,Indic_Syllabic_Category::Vowel_Dependent},
{0xa43,static_cast<Indic_Syllabic_Category>(0)},
{0xa47,Indic_Syllabic_Category::Vowel_Dependent},
{0xa49,static_cast<Indic_Syllabic_Category>(0)},
{0xa4b,Indic_Syllabic_Category::Vowel_Dependent},
{0xa4d,Indic_Syllabic_Category::Virama},
{0xa4e,static_cast<Indic_Syllabic_Category>(0)},
{0xa59,Indic_Syllabic_Category::Consonant},
{0xa5d,static_cast<Indic_Syllabic_Category>(0)},
{0xa5e,Indic_Syllabic_Category::Consonant},
{0xa5f,static_cast<Indic_Syllabic_Category>(0)},
{0xa66,Indic_Syllabic_Category::Number},
{0xa70,Indic_Syllabic_Category::Bindu},
{0xa71,Indic_Syllabic_Category::Gemination_Mark},
{0xa72,Indic_Syllabic_Category::Consonant_Placeholder},
{0xa74,static_cast<Indic_Syllabic_Category>(0)},
{0xa75,Indic_Syllabic_Category::Consonant_Medial},
{0xa76,static_cast<Indic_Syllabic_Category>(0)},
{0xa81,Indic_Syllabic_Category::Bindu},
{0xa83,Indic_Syllabic_Category::Visarga},
{0xa84,static_cast<Indic_Syllabic_Category>(0)},
{0xa85,Indic_Syllabic_Category::Vowel_Independent},
{0xa8e,static_cast<Indic_Syllabic_Category>(0)},
{0xa8f,Indic_Syllabic_Category::Vowel_Independent},
{0xa92,static_cast<Indic_Syllabic_Category>(0)},
{0xa93,Indic_Syllabic_Category::Vowel_Independent},
{0xa95,Indic_Syllabic_Category::Consonant},
{0xaa9,static_cast<Indic_Syllabic_Category>(0)},
{0xaaa,Indic_Syllabic_Category::Consonant},
{0xab1,static_cast<Indic_Syllabic_Category>(0)},
{0xab2,Indic_Syllabic_Category::Consonant},
{0xab4,static_cast<Indic_Syllabic_Category>(0)},
{0xab5,Indic_Syllabic_Category::Consonant},
{0xaba,static_cast<Indic_Syllabic_Category>(0)},
{0xabc,Indic_Syllabic_Category::Nukta},
{0xabd,Indic_Syllabic_Category::Avagraha},
{0xabe,Indic_Syllabic_Category::Vowel_Dependent},
{0xac6,static_cast<Indic_Syllabic_Category>(0)},
{0xac7,Indic_Syllabic_Category::Vowel_Dependent},
{0xaca,static_cast<Indic_Syllabic_Category>(0)},
{0xacb,Indic_Syllabic_Category::Vowel_Dependent},
{0xacd,Indic_Syllabic_Category::Virama},
{0xace,static_cast<Indic_Syllabic_Category>(0)},
{0xae0,Indic_Syllabic_Category::Vowel_Independent},
{0xae2,Indic_Syllabic_Category::Vowel_Dependent},
{0xae4,static_cast<Indic_Syllabic_Category>(0)},
{0xae6,Indic_Syllabic_Category::Number},
{0xaf0,static_cast<Indic_Syllabic_Category>(0)},
{0xaf9,Indic_Syllabic_Category::Consonant},
{0xafa,static_cast<Indic_Syllabic_Category>(0)},
{0xb01,Indic_Syllabic_Category::Bindu},
{0xb03,Indic_Syllabic_Category::Visarga},
{0xb04,static_cast<Indic_Syllabic_Category>(0)},
{0xb05,Indic_Syllabic_Category::Vowel_Independent},
{0xb0d,static_cast<Indic_Syllabic_Category>(0)},
{0xb0f,Indic_Syllabic_Category::Vowel_Independent},
{0xb11,static_cast<Indic_Syllabic_Category>(0)},
{0xb13,Indic_Syllabic_Category::Vowel_Independent},
{0xb15,Indic_Syllabic_Category::Consonant},
{0xb29,static_cast<Indic_Syllabic_Category>(0)},
{0xb2a,Indic_Syllabic_Category::Consonant},
{0xb31,static_cast<Indic_Syllabic_Category>(0)},
{0xb32,Indic_Syllabic_Category::Consonant},
{0xb34,static_cast<Indic_Syllabic_Category>(0)},
{0xb35,Indic_Syllabic_Category::Consonant},
{0xb3a,static_cast<Indic_Syllabic_Category>(0)},
{0xb3c,Indic_Syllabic_Category::Nukta},
{0xb3d,Indic_Syllabic_Category::Avagraha},
{0xb3e,Indic_Syllabic_Category::Vowel_Dependent},
{0xb45,static_cast<Indic_Syllabic_Category>(0)},
{0xb47,Indic_Syllabic_Category::Vowel_Dependent},
{0xb49,static_cast<Indic_Syllabic_Category>(0)},
{0xb4b,Indic_Syllabic_Category::Vowel_Dependent},
{0xb4d,Indic_Syllabic_Category::Virama},
{0xb4e,static_cast<Indic_Syllabic_Category>(0)},
{0xb56,Indic_Syllabic_Category::Vowel_Dependent},
{0xb58,static_cast<Indic_Syllabic_Category>(0)},
{0xb5c,Indic_Syllabic_Category::Consonant},
{0xb5e,static_cast<Indic_Syllabic_Category>(0)},
{0xb5f,Indic_Syllabic_Category::Consonant},
{0xb60,Indic_Syllabic_Category::Vowel_Independent},
{0xb62,Indic_Syllabic_Category::Vowel_Dependent},
{0xb64,static_cast<Indic_Syllabic_Category>(0)},
{0xb66,Indic_Syllabic_Category::Number},
{0xb70,static_cast<Indic_Syllabic_Category>(0)},
{0xb71,Indic_Syllabic_Category::Consonant},
{0xb72,static_cast<Indic_Syllabic_Category>(0)},
{0xb82,Indic_Syllabic_Category::Bindu},
{0xb83,Indic_Syllabic_Category::Modifying_Letter},
{0xb84,static_cast<Indic_Syllabic_Category>(0)},
{0xb85,Indic_Syllabic_Category::Vowel_Independent},
{0xb8b,static_cast<Indic_Syllabic_Category>(0)},
{0xb8e,Indic_Syllabic_Category::Vowel_Independent},
{0xb91,static_cast<Indic_Syllabic_Category>(0)},
{0xb92,Indic_Syllabic_Category::Vowel_Independent},
{0xb95,Indic_Syllabic_Category::Consonant},
{0xb96,static_cast<Indic_Syllabic_Category>(0)},
{0xb99,Indic_Syllabic_Category::Consonant},
{0xb9b,static_cast<Indic_Syllabic_Category>(0)},
{0xb9c,Indic_Syllabic_Category::Consonant},
{0xb9d,static_cast<Indic_Syllabic_Category>(0)},
{0xb9e,Indic_Syllabic_Category::Consonant},
{0xba0,static_cast<Indic_Syllabic_Category>(0)},
{0xba3,Indic_Syllabic_Category::Consonant},
{0xba5,static_cast<Indic_Syllabic_Category>(0)},
{0xba8,Indic_Syllabic_Category::Consonant},
{0xbab,static_cast<Indic_Syllabic_Category>(0)},
{0xbae,Indic_Syllabic_Category::Consonant},
{0xbba,static_cast<Indic_Syllabic_Category>(0)},
{0xbbe,Indic_Syllabic_Category::Vowel_Dependent},
{0xbc3,static_cast<Indic_Syllabic_Category>(0)},
{0xbc6,Indic_Syllabic_Category::Vowel_Dependent},
{0xbc9,static_cast<Indic_Syllabic_Category>(0)},
{0xbca,Indic_Syllabic_Category::Vowel_Dependent},
{0xbcd,Indic_Syllabic_Category::Virama},
{0xbce,static_cast<Indic_Syllabic_Category>(0)},
{0xbd7,Indic_Syllabic_Category::Vowel_Dependent},
{0xbd8,static_cast<Indic_Syllabic_Category>(0)},
{0xbe6,Indic_Syllabic_Category::Number},
{0xbf0,static_cast<Indic_Syllabic_Category>(0)},
{0xc00,Indic_Syllabic_Category::Bindu},
{0xc03,Indic_Syllabic_Category::Visarga},
{0xc04,static_cast<Indic_Syllabic_Category>(0)},
{0xc05,Indic_Syllabic_Category::Vowel_Independent},
{0xc0d,static_cast<Indic_Syllabic_Category>(0)},
{0xc0e,Indic_Syllabic_Category::Vowel_Independent},
{0xc11,static_cast<Indic_Syllabic_Category>(0)},
{0xc12,Indic_Syllabic_Category::Vowel_Independent},
{0xc15,Indic_Syllabic_Category::Consonant},
{0xc29,static_cast<Indic_Syllabic_Category>(0)},
{0xc2a,Indic_Syllabic_Category::Consonant},
{0xc3a,static_cast<Indic_Syllabic_Category>(0)},
{0xc3d,Indic_Syllabic_Category::Avagraha},
{0xc3e,Indic_Syllabic_Category::Vowel_Dependent},
{0xc45,static_cast<Indic_Syllabic_Category>(0)},
{0xc46,Indic_Syllabic_Category::Vowel_Dependent},
{0xc49,static_cast<Indic_Syllabic_Category>(0)},
{0xc4a,Indic_Syllabic_Category::Vowel_Dependent},
{0xc4d,Indic_Syllabic_Category::Virama},
{0xc4e,static_cast<Indic_Syllabic_Category>(0)},
{0xc55,Indic_Syllabic_Category::Vowel_Dependent},
{0xc57,static_cast<Indic_Syllabic_Category>(0)},
{0xc58,Indic_Syllabic_Category::Consonant},
{0xc5b,static_cast<Indic_Syllabic_Category>(0)},
{0xc60,Indic_Syllabic_Category::Vowel_Independent},
{0xc62,Indic_Syllabic_Category::Vowel_Dependent},
{0xc64,static_cast<Indic_Syllabic_Category>(0)},
{0xc66,Indic_Syllabic_Category::Number},
{0xc70,static_cast<Indic_Syllabic_Category>(0)},
{0xc81,Indic_Syllabic_Category::Bindu},
{0xc83,Indic_Syllabic_Category::Visarga},
{0xc84,static_cast<Indic_Syllabic_Category>(0)},
{0xc85,Indic_Syllabic_Category::Vowel_Independent},
{0xc8d,static_cast<Indic_Syllabic_Category>(0)},
{0xc8e,Indic_Syllabic_Category::Vowel_Independent},
{0xc91,static_cast<Indic_Syllabic_Category>(0)},
{0xc92,Indic_Syllabic_Category::Vowel_Independent},
{0xc95,Indic_Syllabic_Category::Consonant},
{0xca9,static_cast<Indic_Syllabic_Category>(0)},
{0xcaa,Indic_Syllabic_Category::Consonant},
{0xcb4,static_cast<Indic_Syllabic_Category>(0)},
{0xcb5,Indic_Syllabic_Category::Consonant},
{0xcba,static_cast<Indic_Syllabic_Category>(0)},
{0xcbc,Indic_Syllabic_Category::Nukta},
{0xcbd,Indic_Syllabic_Category::Avagraha},
{0xcbe,Indic_Syllabic_Category::Vowel_Dependent},
{0xcc5,static_cast<Indic_Syllabic_Category>(0)},
{0xcc6,Indic_Syllabic_Category::Vowel_Dependent},
{0xcc9,static_cast<Indic_Syllabic_Category>(0)},
{0xcca,Indic_Syllabic_Category::Vowel_Dependent},
{0xccd,Indic_Syllabic_Category::Virama},
{0xcce,static_cast<Indic_Syllabic_Category>(0)},
{0xcd5,Indic_Syllabic_Category::Vowel_Dependent},
{0xcd7,static_cast<Indic_Syllabic_Category>(0)},
{0xcde,Indic_Syllabic_Category::Consonant},
{0xcdf,static_cast<Indic_Syllabic_Category>(0)},
{0xce0,Indic_Syllabic_Category::Vowel_Independent},
{0xce2,Indic_Syllabic_Category::Vowel_Dependent},
{0xce4,static_cast<Indic_Syllabic_Category>(0)},
{0xce6,Indic_Syllabic_Category::Number},
{0xcf0,static_cast<Indic_Syllabic_Category>(0)},
{0xcf1,Indic_Syllabic_Category::Consonant_With_Stacker},
{0xcf3,static_cast<Indic_Syllabic_Category>(0)},
{0xd01,Indic_Syllabic_Category::Bindu},
{0xd03,Indic_Syllabic_Category::Visarga},
{0xd04,static_cast<Indic_Syllabic_Category>(0)},
{0xd05,Indic_Syllabic_Category::Vowel_Independent},
{0xd0d,static_cast<Indic_Syllabic_Category>(0)},
{0xd0e,Indic_Syllabic_Category::Vowel_Independent},
{0xd11,static_cast<Indic_Syllabic_Category>(0)},
{0xd12,Indic_Syllabic_Category::Vowel_Independent},
{0xd15,Indic_Syllabic_Category::Consonant},
{0xd3b,static_cast<Indic_Syllabic_Category>(0)},
{0xd3d,Indic_Syllabic_Category::Avagraha},
{0xd3e,Indic_Syllabic_Category::Vowel_Dependent},
{0xd45,static_cast<Indic_Syllabic_Category>(0)},
{0xd46,Indic_Syllabic_Category::Vowel_Dependent},
{0xd49,static_cast<Indic_Syllabic_Category>(0)},
{0xd4a,Indic_Syllabic_Category::Vowel_Dependent},
{0xd4d,Indic_Syllabic_Category::Virama},
{0xd4e,Indic_Syllabic_Category::Consonant_Preceding_Repha},
{0xd4f,static_cast<Indic_Syllabic_Category>(0)},
{0xd57,Indic_Syllabic_Category::Vowel_Dependent},
{0xd58,static_cast<Indic_Syllabic_Category>(0)},
{0xd5f,Indic_Syllabic_Category::Vowel_Independent},
{0xd62,Indic_Syllabic_Category::Vowel_Dependent},
{0xd64,static_cast<Indic_Syllabic_Category>(0)},
{0xd66,Indic_Syllabic_Category::Number},
{0xd70,static_cast<Indic_Syllabic_Category>(0)},
{0xd7a,Indic_Syllabic_Category::Consonant_Dead},
{0xd80,static_cast<Indic_Syllabic_Category>(0)},
{0xd82,Indic_Syllabic_Category::Bindu},
{0xd83,Indic_Syllabic_Category::Visarga},
{0xd84,static_cast<Indic_Syllabic_Category>(0)},
{0xd85,Indic_Syllabic_Category::Vowel_Independent},
{0xd97,static_cast<Indic_Syllabic_Category>(0)},
{0xd9a,Indic_Syllabic_Category::Consonant},
{0xdb2,static_cast<Indic_Syllabic_Category>(0)},
{0xdb3,Indic_Syllabic_Category::Consonant},
{0xdbc,static_cast<Indic_Syllabic_Category>(0)},
{0xdbd,Indic_Syllabic_Category::Consonant},
{0xdbe,static_cast<Indic_Syllabic_Category>(0)},
{0xdc0,Indic_Syllabic_Category::Consonant},
{0xdc7,static_cast<Indic_Syllabic_Category>(0)},
{0xdca,Indic_Syllabic_Category::Virama},
{0xdcb,static_cast<Indic_Syllabic_Category>(0)},
{0xdcf,Indic_Syllabic_Category::Vowel_Dependent},
{0xdd5,static_cast<Indic_Syllabic_Category>(0)},
{0xdd6,Indic_Syllabic_Category::Vowel_Dependent},
{0xdd7,static_cast<Indic_Syllabic_Category>(0)},
{0xdd8,Indic_Syllabic_Category::Vowel_Dependent},
{0xde0,static_cast<Indic_Syllabic_Category>(0)},
{0xde6,Indic_Syllabic_Category::Number},
{0xdf0,static_cast<Indic_Syllabic_Category>(0)},
{0xdf2,Indic_Syllabic_Category::Vowel_Dependent},
{0xdf4,static_cast<Indic_Syllabic_Category>(0)},
{0xe01,Indic_Syllabic_Category::Consonant},
{0xe2f,static_cast<Indic_Syllabic_Category>(0)},
{0xe30,Indic_Syllabic_Category::Vowel_Dependent},
{0xe3a,Indic_Syllabic_Category::Pure_Killer},
{0xe3b,static_cast<Indic_Syllabic_Category>(0)},
{0xe40,Indic_Syllabic_Category::Vowel_Dependent},
{0xe46,static_cast<Indic_Syllabic_Category>(0)},
{0xe47,Indic_Syllabic_Category::Vowel_Dependent},
{0xe48,Indic_Syllabic_Category::Tone_Mark},
{0xe4c,Indic_Syllabic_Category::Consonant_Killer},
{0xe4d,Indic_Syllabic_Category::Bindu},
{0xe4e,Indic_Syllabic_Category::Pure_Killer},
{0xe4f,static_cast<Indic_Syllabic_Category>(0)},
{0xe50,Indic_Syllabic_Category::Number},
{0xe5a,static_cast<Indic_Syllabic_Category>(0)},
{0xe81,Indic_Syllabic_Category::Consonant},
{0xe83,static_cast<Indic_Syllabic_Category>(0)},
{0xe84,Indic_Syllabic_Category::Consonant},
{0xe85,static_cast<Indic_Syllabic_Category>(0)},
{0xe87,Indic_Syllabic_Category::Consonant},
{0xe89,static_cast<Indic_Syllabic_Category>(0)},
{0xe8a,Indic_Syllabic_Category::Consonant},
{0xe8b,static_cast<Indic_Syllabic_Category>(0)},
{0xe8d,Indic_Syllabic_Category::Consonant},
{0xe8e,static_cast<Indic_Syllabic_Category>(0)},
{0xe94,Indic_Syllabic_Category::Consonant},
{0xe98,static_cast<Indic_Syllabic_Category>(0)},
{0xe99,Indic_Syllabic_Category::Consonant},
{0xea0,static_cast<Indic_Syllabic_Category>(0)},
{0xea1,Indic_Syllabic_Category::Consonant},
{0xea4,static_cast<Indic_Syllabic_Category>(0)},
{0xea5,Indic_Syllabic_Category::Consonant},
{0xea6,static_cast<Indic_Syllabic_Category>(0)},
{0xea7,Indic_Syllabic_Category::Consonant},
{0xea8,static_cast<Indic_Syllabic_Category>(0)},
{0xeaa,Indic_Syllabic_Category::Consonant},
{0xeac,static_cast<Indic_Syllabic_Category>(0)},
{0xead,Indic_Syllabic_Category::Consonant},
{0xeaf,static_cast<Indic_Syllabic_Category>(0)},
{0xeb0,Indic_Syllabic_Category::Vowel_Dependent},
{0xeba,static_cast<Indic_Syllabic_Category>(0)},
{0xebb,Indic_Syllabic_Category::Vowel_Dependent},
{0xebc,Indic_Syllabic_Category::Consonant_Medial},
{0xebe,static_cast<Indic_Syllabic_Category>(0)},
{0xec0,Indic_Syllabic_Category::Vowel_Dependent},
{0xec5,static_cast<Indic_Syllabic_Category>(0)},
{0xec8,Indic_Syllabic_Category::Tone_Mark},
{0xecc,static_cast<Indic_Syllabic_Category>(0)},
{0xecd,Indic_Syllabic_Category::Bindu},
{0xece,static_cast<Indic_Syllabic_Category>(0)},
{0xed0,Indic_Syllabic_Category::Number},
{0xeda,static_cast<Indic_Syllabic_Category>(0)},
{0xedc,Indic_Syllabic_Category::Consonant},
{0xee0,static_cast<Indic_Syllabic_Category>(0)},
{0xf20,Indic_Syllabic_Category::Number},
{0xf34,static_cast<Indic_Syllabic_Category>(0)},
{0xf35,Indic_Syllabic_Category::Syllable_Modifier},
{0xf36,static_cast<Indic_Syllabic_Category>(0)},
{0xf37,Indic_Syllabic_Category::Syllable_Modifier},
{0xf38,static_cast<Indic_Syllabic_Category>(0)},
{0xf39,Indic_Syllabic_Category::Nukta},
{0xf3a,static_cast<Indic_Syllabic_Category>(0)},
{0xf40,Indic_Syllabic_Category::Consonant},
{0xf48,static_cast<Indic_Syllabic_Category>(0)},
{0xf49,Indic_Syllabic_Category::Consonant},
{0xf6d,static_cast<Indic_Syllabic_Category>(0)},
{0xf71,Indic_Syllabic_Category::Vowel_Dependent},
{0xf7e,Indic_Syllabic_Category::Bindu},
{0xf7f,Indic_Syllabic_Category::Visarga},
{0xf80,Indic_Syllabic_Category::Vowel_Dependent},
{0xf82,Indic_Syllabic_Category::Bindu},
{0xf84,Indic_Syllabic_Category::Pure_Killer},
{0xf85,Indic_Syllabic_Category::Avagraha},
{0xf86,static_cast<Indic_Syllabic_Category>(0)},
{0xf88,Indic_Syllabic_Category::Consonant_Head_Letter},
{0xf8d,Indic_Syllabic_Category::Consonant_Subjoined},
{0xf98,static_cast<Indic_Syllabic_Category>(0)},
{0xf99,Indic_Syllabic_Category::Consonant_Subjoined},
{0xfbd,static_cast<Indic_Syllabic_Category>(0)},
{0xfc6,Indic_Syllabic_Category::Syllable_Modifier},
{0xfc7,static_cast<Indic_Syllabic_Category>(0)},
{0x1000,Indic_Syllabic_Category::Consonant},
{0x1021,Indic_Syllabic_Category::Vowel_Independent},
{0x102b,Indic_Syllabic_Category::Vowel_Dependent},
{0x1036,Indic_Syllabic_Category::Bindu},
{0x1037,Indic_Syllabic_Category::Tone_Mark},
{0x1038,Indic_Syllabic_Category::Visarga},
{0x1039,Indic_Syllabic_Category::Invisible_Stacker},
{0x103a,Indic_Syllabic_Category::Pure_Killer},
{0x103b,Indic_Syllabic_Category::Consonant_Medial},
{0x103f,Indic_Syllabic_Category::Consonant},
{0x1040,Indic_Syllabic_Category::Number},
{0x104a,static_cast<Indic_Syllabic_Category>(0)},
{0x104e,Indic_Syllabic_Category::Consonant_Placeholder},
{0x104f,static_cast<Indic_Syllabic_Category>(0)},
{0x1050,Indic_Syllabic_Category::Consonant},
{0x1052,Indic_Syllabic_Category::Vowel_Independent},
{0x1056,Indic_Syllabic_Category::Vowel_Dependent},
{0x105a,Indic_Syllabic_Category::Consonant},
{0x105e,Indic_Syllabic_Category::Consonant_Medial},
{0x1061,Indic_Syllabic_Category::Consonant},
{0x1062,Indic_Syllabic_Category::Vowel_Dependent},
{0x1063,Indic_Syllabic_Category::Tone_Mark},
{0x1065,Indic_Syllabic_Category::Consonant},
{0x1067,Indic_Syllabic_Category::Vowel_Dependent},
{0x1069,Indic_Syllabic_Category::Tone_Mark},
{0x106e,Indic_Syllabic_Category::Consonant},
{0x1071,Indic_Syllabic_Category::Vowel_Dependent},
{0x1075,Indic_Syllabic_Category::Consonant},
{0x1082,Indic_Syllabic_Category::Consonant_Medial},
{0x1083,Indic_Syllabic_Category::Vowel_Dependent},
{0x1087,Indic_Syllabic_Category::Tone_Mark},
{0x108e,Indic_Syllabic_Category::Consonant},
{0x108f,Indic_Syllabic_Category::Tone_Mark},
{0x1090,Indic_Syllabic_Category::Number},
{0x109a,Indic_Syllabic_Category::Tone_Mark},
{0x109c,Indic_Syllabic_Category::Vowel_Dependent},
{0x109e,static_cast<Indic_Syllabic_Category>(0)},
{0x1700,Indic_Syllabic_Category::Vowel_Independent},
{0x1703,Indic_Syllabic_Category::Consonant},
{0x170d,static_cast<Indic_Syllabic_Category>(0)},
{0x170e,Indic_Syllabic_Category::Consonant},
{0x1712,Indic_Syllabic_Category::Vowel_Dependent},
{0x1714,Indic_Syllabic_Category::Pure_Killer},
{0x1715,static_cast<Indic_Syllabic_Category>(0)},
{0x1720,Indic_Syllabic_Category::Vowel_Independent},
{0x1723,Indic_Syllabic_Category::Consonant},
{0x1732,Indic_Syllabic_Category::Vowel_Dependent},
{0x1734,Indic_Syllabic_Category::Pure_Killer},
{0x1735,static_cast<Indic_Syllabic_Category>(0)},
{0x1740,Indic_Syllabic_Category::Vowel_Independent},
{0x1743,Indic_Syllabic_Category::Consonant},
{0x1752,Indic_Syllabic_Category::Vowel_Dependent},
{0x1754,static_cast<Indic_Syllabic_Category>(0)},
{0x1760,Indic_Syllabic_Category::Vowel_Independent},
{0x1763,Indic_Syllabic_Category::Consonant},
{0x176d,static_cast<Indic_Syllabic_Category>(0)},
{0x176e,Indic_Syllabic_Category::Consonant},
{0x1771,static_cast<Indic_Syllabic_Category>(0)},
{0x1772,Indic_Syllabic_Category::Vowel_Dependent},
{0x1774,static_cast<Indic_Syllabic_Category>(0)},
{0x1780,Indic_Syllabic_Category::Consonant},
{0x17a3,Indic_Syllabic_Category::Vowel_Independent},
{0x17b4,static_cast<Indic_Syllabic_Category>(0)},
{0x17b6,Indic_Syllabic_Category::Vowel_Dependent},
{0x17c6,Indic_Syllabic_Category::Bindu},
{0x17c7,Indic_Syllabic_Category::Visarga},
{0x17c8,Indic_Syllabic_Category::Vowel_Dependent},
{0x17c9,Indic_Syllabic_Category::Register_Shifter},
{0x17cb,Indic_Syllabic_Category::Syllable_Modifier},
{0x17cc,Indic_Syllabic_Category::Consonant_Succeeding_Repha},
{0x17cd,Indic_Syllabic_Category::Consonant_Killer},
{0x17ce,Indic_Syllabic_Category::Syllable_Modifier},
{0x17d1,Indic_Syllabic_Category::Pure_Killer},
{0x17d2,Indic_Syllabic_Category::Invisible_Stacker},
{0x17d3,Indic_Syllabic_Category::Syllable_Modifier},
{0x17d4,static_cast<Indic_Syllabic_Category>(0)},
{0x17dc,Indic_Syllabic_Category::Avagraha},
{0x17dd,static_cast<Indic_Syllabic_Category>(0)},
{0x17e0,Indic_Syllabic_Category::Number},
{0x17ea,static_cast<Indic_Syllabic_Category>(0)},
{0x1900,Indic_Syllabic_Category::Consonant_Placeholder},
{0x1901,Indic_Syllabic_Category::Consonant},
{0x191f,static_cast<Indic_Syllabic_Category>(0)},
{0x1920,Indic_Syllabic_Category::Vowel_Dependent},
{0x1929,Indic_Syllabic_Category::Consonant_Subjoined},
{0x192c,static_cast<Indic_Syllabic_Category>(0)},
{0x1930,Indic_Syllabic_Category::Consonant_Final},
{0x1932,Indic_Syllabic_Category::Bindu},
{0x1933,Indic_Syllabic_Category::Consonant_Final},
{0x193a,Indic_Syllabic_Category::Vowel_Dependent},
{0x193b,Indic_Syllabic_Category::Syllable_Modifier},
{0x193c,static_cast<Indic_Syllabic_Category>(0)},
{0x1946,Indic_Syllabic_Category::Number},
{0x1950,Indic_Syllabic_Category::Consonant},
{0x1963,Indic_Syllabic_Category::Vowel},
{0x196e,static_cast<Indic_Syllabic_Category>(0)},
{0x1970,Indic_Syllabic_Category::Tone_Letter},
{0x1975,static_cast<Indic_Syllabic_Category>(0)},
{0x1980,Indic_Syllabic_Category::Consonant},
{0x19ac,static_cast<Indic_Syllabic_Category>(0)},
{0x19b0,Indic_Syllabic_Category::Vowel_Dependent},
{0x19c1,Indic_Syllabic_Category::Consonant_Final},
{0x19c8,Indic_Syllabic_Category::Tone_Mark},
{0x19ca,static_cast<Indic_Syllabic_Category>(0)},
{0x19d0,Indic_Syllabic_Category::Number},
{0x19da,static_cast<Indic_Syllabic_Category>(0)},
{0x1a00,Indic_Syllabic_Category::Consonant},
{0x1a17,Indic_Syllabic_Category::Vowel_Dependent},
{0x1a1c,static_cast<Indic_Syllabic_Category>(0)},
{0x1a20,Indic_Syllabic_Category::Consonant},
{0x1a4d,Indic_Syllabic_Category::Vowel_Independent},
{0x1a53,Indic_Syllabic_Category::Consonant},
{0x1a55,Indic_Syllabic_Category::Consonant_Medial},
{0x1a57,Indic_Syllabic_Category::Consonant_Final},
{0x1a5f,static_cast<Indic_Syllabic_Category>(0)},
{0x1a60,Indic_Syllabic_Category::Invisible_Stacker},
{0x1a61,Indic_Syllabic_Category::Vowel_Dependent},
{0x1a75,Indic_Syllabic_Category::Tone_Mark},
{0x1a7a,Indic_Syllabic_Category::Syllable_Modifier},
{0x1a7d,static_cast<Indic_Syllabic_Category>(0)},
{0x1a7f,Indic_Syllabic_Category::Syllable_Modifier},
{0x1a80,Indic_Syllabic_Category::Number},
{0x1a8a,static_cast<Indic_Syllabic_Category>(0)},
{0x1a90,Indic_Syllabic_Category::Number},
{0x1a9a,static_cast<Indic_Syllabic_Category>(0)},
{0x1b00,Indic_Syllabic_Category::Bindu},
{0x1b03,Indic_Syllabic_Category::Consonant_Succeeding_Repha},
{0x1b04,Indic_Syllabic_Category::Visarga},
{0x1b05,Indic_Syllabic_Category::Vowel_Independent},
{0x1b13,Indic_Syllabic_Category::Consonant},
{0x1b34,Indic_Syllabic_Category::Nukta},
{0x1b35,Indic_Syllabic_Category::Vowel_Dependent},
{0x1b44,Indic_Syllabic_Category::Virama},
{0x1b45,Indic_Syllabic_Category::Consonant},
{0x1b4c,static_cast<Indic_Syllabic_Category>(0)},
{0x1b50,Indic_Syllabic_Category::Number},
{0x1b5a,static_cast<Indic_Syllabic_Category>(0)},
{0x1b80,Indic_Syllabic_Category::Bindu},
{0x1b81,Indic_Syllabic_Category::Consonant_Succeeding_Repha},
{0x1b82,Indic_Syllabic_Category::Visarga},
{0x1b83,Indic_Syllabic_Category::Vowel_Independent},
{0x1b8a,Indic_Syllabic_Category::Consonant},
{0x1ba1,Indic_Syllabic_Category::Consonant_Subjoined},
{0x1ba4,Indic_Syllabic_Category::Vowel_Dependent},
{0x1baa,Indic_Syllabic_Category::Pure_Killer},
{0x1bab,Indic_Syllabic_Category::Invisible_Stacker},
{0x1bac,Indic_Syllabic_Category::Consonant_Subjoined},
{0x1bae,Indic_Syllabic_Category::Consonant},
{0x1bb0,Indic_Syllabic_Category::Number},
{0x1bba,Indic_Syllabic_Category::Avagraha},
{0x1bbb,Indic_Syllabic_Category::Consonant},
{0x1bbe,Indic_Syllabic_Category::Consonant_Final},
{0x1bc0,Indic_Syllabic_Category::Consonant},
{0x1be4,Indic_Syllabic_Category::Vowel_Independent},
{0x1be6,Indic_Syllabic_Category::Nukta},
{0x1be7,Indic_Syllabic_Category::Vowel_Dependent},
{0x1bf0,Indic_Syllabic_Category::Consonant_Final},
{0x1bf2,Indic_Syllabic_Category::Pure_Killer},
{0x1bf4,static_cast<Indic_Syllabic_Category>(0)},
{0x1c00,Indic_Syllabic_Category::Consonant},
{0x1c24,Indic_Syllabic_Category::Consonant_Subjoined},
{0x1c26,Indic_Syllabic_Category::Vowel_Dependent},
{0x1c2d,Indic_Syllabic_Category::Consonant_Final},
{0x1c34,Indic_Syllabic_Category::Bindu},
{0x1c36,Indic_Syllabic_Category::Syllable_Modifier},
{0x1c37,Indic_Syllabic_Category::Nukta},
{0x1c38,static_cast<Indic_Syllabic_Category>(0)},
{0x1c40,Indic_Syllabic_Category::Number},
{0x1c4a,static_cast<Indic_Syllabic_Category>(0)},
{0x1c4d,Indic_Syllabic_Category::Consonant},
{0x1c50,static_cast<Indic_Syllabic_Category>(0)},
{0x1cd0,Indic_Syllabic_Category::Cantillation_Mark},
{0x1cd3,static_cast<Indic_Syllabic_Category>(0)},
{0x1cd4,Indic_Syllabic_Category::Cantillation_Mark},
{0x1ce2,static_cast<Indic_Syllabic_Category>(0)},
{0x1cf2,Indic_Syllabic_Category::Visarga},
{0x1cf4,Indic_Syllabic_Category::Cantillation_Mark},
{0x1cf5,static_cast<Indic_Syllabic_Category>(0)},
{0x1cf8,Indic_Syllabic_Category::Cantillation_Mark},
{0x1cfa,static_cast<Indic_Syllabic_Category>(0)},
{0x200c,Indic_Syllabic_Category::Non_Joiner},
{0x200d,Indic_Syllabic_Category::Joiner},
{0x200e,static_cast<Indic_Syllabic_Category>(0)},
{0x2010,Indic_Syllabic_Category::Consonant_Placeholder},
{0x2015,static_cast<Indic_Syllabic_Category>(0)},
{0x2074,Indic_Syllabic_Category::Syllable_Modifier},
{0x2075,static_cast<Indic_Syllabic_Category>(0)},
{0x2082,Indic_Syllabic_Category::Syllable_Modifier},
{0x2085,static_cast<Indic_Syllabic_Category>(0)},
{0x25cc,Indic_Syllabic_Category::Consonant_Placeholder},
{0x25cd,static_cast<Indic_Syllabic_Category>(0)},
{0xa800,Indic_Syllabic_Category::Vowel_Independent},
{0xa802,static_cast<Indic_Syllabic_Category>(0)},
{0xa803,Indic_Syllabic_Category::Vowel_Independent},
{0xa806,Indic_Syllabic_Category::Pure_Killer},
{0xa807,Indic_Syllabic_Category::Consonant},
{0xa80b,Indic_Syllabic_Category::Bindu},
{0xa80c,Indic_Syllabic_Category::Consonant},
{0xa823,Indic_Syllabic_Category::Vowel_Dependent},
{0xa828,static_cast<Indic_Syllabic_Category>(0)},
{0xa840,Indic_Syllabic_Category::Consonant},
{0xa85e,Indic_Syllabic_Category::Vowel},
{0xa862,Indic_Syllabic_Category::Consonant},
{0xa866,Indic_Syllabic_Category::Vowel},
{0xa867,Indic_Syllabic_Category::Consonant_Subjoined},
{0xa869,Indic_Syllabic_Category::Consonant},
{0xa871,Indic_Syllabic_Category::Consonant_Subjoined},
{0xa872,Indic_Syllabic_Category::Consonant},
{0xa873,Indic_Syllabic_Category::Bindu},
{0xa874,static_cast<Indic_Syllabic_Category>(0)},
{0xa880,Indic_Syllabic_Category::Bindu},
{0xa881,Indic_Syllabic_Category::Visarga},
{0xa882,Indic_Syllabic_Category::Vowel_Independent},
{0xa892,Indic_Syllabic_Category::Consonant},
{0xa8b4,Indic_Syllabic_Category::Consonant_Final},
{0xa8b5,Indic_Syllabic_Category::Vowel_Dependent},
{0xa8c4,Indic_Syllabic_Category::Virama},
{0xa8c5,static_cast<Indic_Syllabic_Category>(0)},
{0xa8d0,Indic_Syllabic_Category::Number},
{0xa8da,static_cast<Indic_Syllabic_Category>(0)},
{0xa8e0,Indic_Syllabic_Category::Cantillation_Mark},
{0xa8f2,static_cast<Indic_Syllabic_Category>(0)},
{0xa900,Indic_Syllabic_Category::Number},
{0xa90a,Indic_Syllabic_Category::Consonant},
{0xa922,Indic_Syllabic_Category::Vowel},
{0xa92b,Indic_Syllabic_Category::Tone_Mark},
{0xa92e,static_cast<Indic_Syllabic_Category>(0)},
{0xa930,Indic_Syllabic_Category::Consonant},
{0xa947,Indic_Syllabic_Category::Vowel_Dependent},
{0xa94f,Indic_Syllabic_Category::Consonant_Final},
{0xa953,Indic_Syllabic_Category::Pure_Killer},
{0xa954,static_cast<Indic_Syllabic_Category>(0)},
{0xa980,Indic_Syllabic_Category::Bindu},
{0xa982,Indic_Syllabic_Category::Consonant_Succeeding_Repha},
{0xa983,Indic_Syllabic_Category::Visarga},
{0xa984,Indic_Syllabic_Category::Vowel_Independent},
{0xa989,Indic_Syllabic_Category::Consonant},
{0xa98c,Indic_Syllabic_Category::Vowel_Independent},
{0xa98f,Indic_Syllabic_Category::Consonant},
{0xa9b3,Indic_Syllabic_Category::Nukta},
{0xa9b4,Indic_Syllabic_Category::Vowel_Dependent},
{0xa9bd,Indic_Syllabic_Category::Consonant_Subjoined},
{0xa9be,Indic_Syllabic_Category::Consonant_Medial},
{0xa9c0,Indic_Syllabic_Category::Virama},
{0xa9c1,static_cast<Indic_Syllabic_Category>(0)},
{0xa9d0,Indic_Syllabic_Category::Number},
{0xa9da,static_cast<Indic_Syllabic_Category>(0)},
{0xa9e0,Indic_Syllabic_Category::Consonant},
{0xa9e5,Indic_Syllabic_Category::Vowel_Dependent},
{0xa9e6,static_cast<Indic_Syllabic_Category>(0)},
{0xa9e7,Indic_Syllabic_Category::Consonant},
{0xa9f0,Indic_Syllabic_Category::Number},
{0xa9fa,Indic_Syllabic_Category::Consonant},
{0xa9ff,static_cast<Indic_Syllabic_Category>(0)},
{0xaa00,Indic_Syllabic_Category::Vowel_Independent},
{0xaa06,Indic_Syllabic_Category::Consonant},
{0xaa29,Indic_Syllabic_Category::Vowel_Dependent},
{0xaa33,Indic_Syllabic_Category::Consonant_Medial},
{0xaa37,static_cast<Indic_Syllabic_Category>(0)},
{0xaa40,Indic_Syllabic_Category::Consonant_Final},
{0xaa4e,static_cast<Indic_Syllabic_Category>(0)},
{0xaa50,Indic_Syllabic_Category::Number},
{0xaa5a,static_cast<Indic_Syllabic_Category>(0)},
{0xaa60,Indic_Syllabic_Category::Consonant},
{0xaa70,static_cast<Indic_Syllabic_Category>(0)},
{0xaa71,Indic_Syllabic_Category::Consonant},
{0xaa74,static_cast<Indic_Syllabic_Category>(0)},
{0xaa7a,Indic_Syllabic_Category::Consonant},
{0xaa7b,Indic_Syllabic_Category::Tone_Mark},
{0xaa7e,Indic_Syllabic_Category::Consonant},
{0xaab0,Indic_Syllabic_Category::Vowel_Dependent},
{0xaabf,Indic_Syllabic_Category::Tone_Mark},
{0xaac0,Indic_Syllabic_Category::Tone_Letter},
{0xaac1,Indic_Syllabic_Category::Tone_Mark},
{0xaac2,Indic_Syllabic_Category::Tone_Letter},
{0xaac3,static_cast<Indic_Syllabic_Category>(0)},
{0xaae0,Indic_Syllabic_Category::Vowel_Independent},
{0xaae2,Indic_Syllabic_Category::Consonant},
{0xaaeb,Indic_Syllabic_Category::Vowel_Dependent},
{0xaaf0,static_cast<Indic_Syllabic_Category>(0)},
{0xaaf5,Indic_Syllabic_Category::Visarga},
{0xaaf6,Indic_Syllabic_Category::Invisible_Stacker},
{0xaaf7,static_cast<Indic_Syllabic_Category>(0)},
{0xabc0,Indic_Syllabic_Category::Consonant},
{0xabce,Indic_Syllabic_Category::Vowel_Independent},
{0xabd0,Indic_Syllabic_Category::Consonant},
{0xabd1,Indic_Syllabic_Category::Vowel_Independent},
{0xabd2,Indic_Syllabic_Category::Consonant},
{0xabdb,Indic_Syllabic_Category::Consonant_Final},
{0xabe3,Indic_Syllabic_Category::Vowel_Dependent},
{0xabeb,static_cast<Indic_Syllabic_Category>(0)},
{0xabec,Indic_Syllabic_Category::Tone_Mark},
{0xabed,Indic_Syllabic_Category::Pure_Killer},
{0xabee,static_cast<Indic_Syllabic_Category>(0)},
{0xabf0,Indic_Syllabic_Category::Number},
{0xabfa,static_cast<Indic_Syllabic_Category>(0)},
{0x10a00,Indic_Syllabic_Category::Consonant},
{0x10a01,Indic_Syllabic_Category::Vowel_Dependent},
{0x10a04,static_cast<Indic_Syllabic_Category>(0)},
{0x10a05,Indic_Syllabic_Category::Vowel_Dependent},
{0x10a07,static_cast<Indic_Syllabic_Category>(0)},
{0x10a0c,Indic_Syllabic_Category::Vowel_Dependent},
{0x10a0e,Indic_Syllabic_Category::Bindu},
{0x10a0f,Indic_Syllabic_Category::Visarga},
{0x10a10,Indic_Syllabic_Category::Consonant},
{0x10a14,static_cast<Indic_Syllabic_Category>(0)},
{0x10a15,Indic_Syllabic_Category::Consonant},
{0x10a18,static_cast<Indic_Syllabic_Category>(0)},
{0x10a19,Indic_Syllabic_Category::Consonant},
{0x10a34,static_cast<Indic_Syllabic_Category>(0)},
{0x10a38,Indic_Syllabic_Category::Nukta},
{0x10a3b,static_cast<Indic_Syllabic_Category>(0)},
{0x10a3f,Indic_Syllabic_Category::Invisible_Stacker},
{0x10a40,Indic_Syllabic_Category::Number},
{0x10a48,static_cast<Indic_Syllabic_Category>(0)},
{0x11000,Indic_Syllabic_Category::Bindu},
{0x11002,Indic_Syllabic_Category::Visarga},
{0x11003,Indic_Syllabic_Category::Consonant_With_Stacker},
{0x11005,Indic_Syllabic_Category::Vowel_Independent},
{0x11013,Indic_Syllabic_Category::Consonant},
{0x11038,Indic_Syllabic_Category::Vowel_Dependent},
{0x11046,Indic_Syllabic_Category::Virama},
{0x11047,static_cast<Indic_Syllabic_Category>(0)},
{0x11052,Indic_Syllabic_Category::Brahmi_Joining_Number},
{0x11066,Indic_Syllabic_Category::Number},
{0x11070,static_cast<Indic_Syllabic_Category>(0)},
{0x1107f,Indic_Syllabic_Category::Number_Joiner},
{0x11080,Indic_Syllabic_Category::Bindu},
{0x11082,Indic_Syllabic_Category::Visarga},
{0x11083,Indic_Syllabic_Category::Vowel_Independent},
{0x1108d,Indic_Syllabic_Category::Consonant},
{0x110b0,Indic_Syllabic_Category::Vowel_Dependent},
{0x110b9,Indic_Syllabic_Category::Virama},
{0x110ba,Indic_Syllabic_Category::Nukta},
{0x110bb,static_cast<Indic_Syllabic_Category>(0)},
{0x11100,Indic_Syllabic_Category::Bindu},
{0x11102,Indic_Syllabic_Category::Visarga},
{0x11103,Indic_Syllabic_Category::Vowel_Independent},
{0x11107,Indic_Syllabic_Category::Consonant},
{0x11127,Indic_Syllabic_Category::Vowel_Dependent},
{0x11133,Indic_Syllabic_Category::Invisible_Stacker},
{0x11134,Indic_Syllabic_Category::Pure_Killer},
{0x11135,static_cast<Indic_Syllabic_Category>(0)},
{0x11136,Indic_Syllabic_Category::Number},
{0x11140,static_cast<Indic_Syllabic_Category>(0)},
{0x11150,Indic_Syllabic_Category::Vowel},
{0x11155,Indic_Syllabic_Category::Consonant},
{0x11173,Indic_Syllabic_Category::Nukta},
{0x11174,static_cast<Indic_Syllabic_Category>(0)},
{0x11180,Indic_Syllabic_Category::Bindu},
{0x11182,Indic_Syllabic_Category::Visarga},
{0x11183,Indic_Syllabic_Category::Vowel_Independent},
{0x11191,Indic_Syllabic_Category::Consonant},
{0x111b3,Indic_Syllabic_Category::Vowel_Dependent},
{0x111c0,Indic_Syllabic_Category::Virama},
{0x111c1,Indic_Syllabic_Category::Avagraha},
{0x111c2,Indic_Syllabic_Category::Consonant_Prefixed},
{0x111c4,static_cast<Indic_Syllabic_Category>(0)},
{0x111ca,Indic_Syllabic_Category::Nukta},
{0x111cb,Indic_Syllabic_Category::Vowel_Dependent},
{0x111cd,static_cast<Indic_Syllabic_Category>(0)},
{0x111d0,Indic_Syllabic_Category::Number},
{0x111da,static_cast<Indic_Syllabic_Category>(0)},
{0x111e1,Indic_Syllabic_Category::Number},
{0x111f5,static_cast<Indic_Syllabic_Category>(0)},
{0x11200,Indic_Syllabic_Category::Vowel_Independent},
{0x11208,Indic_Syllabic_Category::Consonant},
{0x11212,static_cast<Indic_Syllabic_Category>(0)},
{0x11213,Indic_Syllabic_Category::Consonant},
{0x1122c,Indic_Syllabic_Category::Vowel_Dependent},
{0x11234,Indic_Syllabic_Category::Bindu},
{0x11235,Indic_Syllabic_Category::Virama},
{0x11236,Indic_Syllabic_Category::Nukta},
{0x11237,Indic_Syllabic_Category::Gemination_Mark},
{0x11238,static_cast<Indic_Syllabic_Category>(0)},
{0x11280,Indic_Syllabic_Category::Vowel_Independent},
{0x11284,Indic_Syllabic_Category::Consonant},
{0x11287,static_cast<Indic_Syllabic_Category>(0)},
{0x11288,Indic_Syllabic_Category::Consonant},
{0x11289,static_cast<Indic_Syllabic_Category>(0)},
{0x1128a,Indic_Syllabic_Category::Consonant},
{0x1128e,static_cast<Indic_Syllabic_Category>(0)},
{0x1128f,Indic_Syllabic_Category::Consonant},
{0x1129e,static_cast<Indic_Syllabic_Category>(0)},
{0x1129f,Indic_Syllabic_Category::Consonant},
{0x112a9,static_cast<Indic_Syllabic_Category>(0)},
{0x112b0,Indic_Syllabic_Category::Vowel_Independent},
{0x112ba,Indic_Syllabic_Category::Consonant},
{0x112df,Indic_Syllabic_Category::Bindu},
{0x112e0,Indic_Syllabic_Category::Vowel_Dependent},
{0x112e9,Indic_Syllabic_Category::Nukta},
{0x112ea,Indic_Syllabic_Category::Pure_Killer},
{0x112eb,static_cast<Indic_Syllabic_Category>(0)},
{0x112f0,Indic_Syllabic_Category::Number},
{0x112fa,static_cast<Indic_Syllabic_Category>(0)},
{0x11300,Indic_Syllabic_Category::Bindu},
{0x11303,Indic_Syllabic_Category::Visarga},
{0x11304,static_cast<Indic_Syllabic_Category>(0)},
{0x11305,Indic_Syllabic_Category::Vowel_Independent},
{0x1130d,static_cast<Indic_Syllabic_Category>(0)},
{0x1130f,Indic_Syllabic_Category::Vowel_Independent},
{0x11311,static_cast<Indic_Syllabic_Category>(0)},
{0x11313,Indic_Syllabic_Category::Vowel_Independent},
{0x11315,Indic_Syllabic_Category::Consonant},
{0x11329,static_cast<Indic_Syllabic_Category>(0)},
{0x1132a,Indic_Syllabic_Category::Consonant},
{0x11331,static_cast<Indic_Syllabic_Category>(0)},
{0x11332,Indic_Syllabic_Category::Consonant},
{0x11334,static_cast<Indic_Syllabic_Category>(0)},
{0x11335,Indic_Syllabic_Category::Consonant},
{0x1133a,static_cast<Indic_Syllabic_Category>(0)},
{0x1133c,Indic_Syllabic_Category::Nukta},
{0x1133d,Indic_Syllabic_Category::Avagraha},
{0x1133e,Indic_Syllabic_Category::Vowel_Dependent},
{0x11345,static_cast<Indic_Syllabic_Category>(0)},
{0x11347,Indic_Syllabic_Category::Vowel_Dependent},
{0x11349,static_cast<Indic_Syllabic_Category>(0)},
{0x1134b,Indic_Syllabic_Category::Vowel_Dependent},
{0x1134d,Indic_Syllabic_Category::Virama},
{0x1134e,static_cast<Indic_Syllabic_Category>(0)},
{0x11357,Indic_Syllabic_Category::Vowel_Dependent},
{0x11358,static_cast<Indic_Syllabic_Category>(0)},
{0x11360,Indic_Syllabic_Category::Vowel_Independent},
{0x11362,Indic_Syllabic_Category::Vowel_Dependent},
{0x11364,static_cast<Indic_Syllabic_Category>(0)},
{0x11366,Indic_Syllabic_Category::Cantillation_Mark},
{0x1136d,static_cast<Indic_Syllabic_Category>(0)},
{0x11370,Indic_Syllabic_Category::Cantillation_Mark},
{0x11375,static_cast<Indic_Syllabic_Category>(0)},
{0x11481,Indic_Syllabic_Category::Vowel_Independent},
{0x1148f,Indic_Syllabic_Category::Consonant},
{0x114b0,Indic_Syllabic_Category::Vowel_Dependent},
{0x114bf,Indic_Syllabic_Category::Bindu},
{0x114c1,Indic_Syllabic_Category::Visarga},
{0x114c2,Indic_Syllabic_Category::Virama},
{0x114c3,Indic_Syllabic_Category::Nukta},
{0x114c4,Indic_Syllabic_Category::Avagraha},
{0x114c5,static_cast<Indic_Syllabic_Category>(0)},
{0x114d0,Indic_Syllabic_Category::Number},
{0x114da,static_cast<Indic_Syllabic_Category>(0)},
{0x11580,Indic_Syllabic_Category::Vowel_Independent},
{0x1158e,Indic_Syllabic_Category::Consonant},
{0x115af,Indic_Syllabic_Category::Vowel_Dependent},
{0x115b6,static_cast<Indic_Syllabic_Category>(0)},
{0x115b8,Indic_Syllabic_Category::Vowel_Dependent},
{0x115bc,Indic_Syllabic_Category::Bindu},
{0x115be,Indic_Syllabic_Category::Visarga},
{0x115bf,Indic_Syllabic_Category::Virama},
{0x115c0,Indic_Syllabic_Category::Nukta},
{0x115c1,static_cast<Indic_Syllabic_Category>(0)},
{0x115d8,Indic_Syllabic_Category::Vowel_Independent},
{0x115dc,Indic_Syllabic_Category::Vowel_Dependent},
{0x115de,static_cast<Indic_Syllabic_Category>(0)},
{0x11600,Indic_Syllabic_Category::Vowel_Independent},
{0x1160e,Indic_Syllabic_Category::Consonant},
{0x11630,Indic_Syllabic_Category::Vowel_Dependent},
{0x1163d,Indic_Syllabic_Category::Bindu},
{0x1163e,Indic_Syllabic_Category::Visarga},
{0x1163f,Indic_Syllabic_Category::Virama},
{0x11640,Indic_Syllabic_Category::Vowel_Dependent},
{0x11641,static_cast<Indic_Syllabic_Category>(0)},
{0x11650,Indic_Syllabic_Category::Number},
{0x1165a,static_cast<Indic_Syllabic_Category>(0)},
{0x11680,Indic_Syllabic_Category::Vowel_Independent},
{0x1168a,Indic_Syllabic_Category::Consonant},
{0x116ab,Indic_Syllabic_Category::Bindu},
{0x116ac,Indic_Syllabic_Category::Visarga},
{0x116ad,Indic_Syllabic_Category::Vowel_Dependent},
{0x116b6,Indic_Syllabic_Category::Virama},
{0x116b7,Indic_Syllabic_Category::Nukta},
{0x116b8,static_cast<Indic_Syllabic_Category>(0)},
{0x116c0,Indic_Syllabic_Category::Number},
{0x116ca,static_cast<Indic_Syllabic_Category>(0)},
{0x11700,Indic_Syllabic_Category::Consonant},
{0x1171a,static_cast<Indic_Syllabic_Category>(0)},
{0x1171d,Indic_Syllabic_Category::Consonant_Medial},
{0x11720,Indic_Syllabic_Category::Vowel_Dependent},
{0x1172b,Indic_Syllabic_Category::Pure_Killer},
{0x1172c,static_cast<Indic_Syllabic_Category>(0)},
{0x11730,Indic_Syllabic_Category::Number},
{0x1173c,static_cast<Indic_Syllabic_Category>(0)},
}};

const TableView<char32_t, Indic_Syllabic_Category> indic_syllabic_category_table {&indic_syllabic_category_array[0], &indic_syllabic_category_array[0] + indic_syllabic_category_array.size()};

const std::array<KeyValue<char32_t, Grapheme_Cluster_Break>, 1502> grapheme_cluster_break_array = {{
{0x0,Grapheme_Cluster_Break::Control},
{0xa,Grapheme_Cluster_Break::LF},
{0xb,Grapheme_Cluster_Break::Control},
{0xd,Grapheme_Cluster_Break::CR},
{0xe,Grapheme_Cluster_Break::Control},
{0x20,static_cast<Grapheme_Cluster_Break>(0)},
{0x7f,Grapheme_Cluster_Break::Control},
{0xa0,static_cast<Grapheme_Cluster_Break>(0)},
{0xad,Grapheme_Cluster_Break::Control},
{0xae,static_cast<Grapheme_Cluster_Break>(0)},
{0x300,Grapheme_Cluster_Break::Extend},
{0x370,static_cast<Grapheme_Cluster_Break>(0)},
{0x483,Grapheme_Cluster_Break::Extend},
{0x48a,static_cast<Grapheme_Cluster_Break>(0)},
{0x591,Grapheme_Cluster_Break::Extend},
{0x5be,static_cast<Grapheme_Cluster_Break>(0)},
{0x5bf,Grapheme_Cluster_Break::Extend},
{0x5c0,static_cast<Grapheme_Cluster_Break>(0)},
{0x5c1,Grapheme_Cluster_Break::Extend},
{0x5c3,static_cast<Grapheme_Cluster_Break>(0)},
{0x5c4,Grapheme_Cluster_Break::Extend},
{0x5c6,static_cast<Grapheme_Cluster_Break>(0)},
{0x5c7,Grapheme_Cluster_Break::Extend},
{0x5c8,static_cast<Grapheme_Cluster_Break>(0)},
{0x600,Grapheme_Cluster_Break::Control},
{0x606,static_cast<Grapheme_Cluster_Break>(0)},
{0x610,Grapheme_Cluster_Break::Extend},
{0x61b,static_cast<Grapheme_Cluster_Break>(0)},
{0x61c,Grapheme_Cluster_Break::Control},
{0x61d,static_cast<Grapheme_Cluster_Break>(0)},
{0x64b,Grapheme_Cluster_Break::Extend},
{0x660,static_cast<Grapheme_Cluster_Break>(0)},
{0x670,Grapheme_Cluster_Break::Extend},
{0x671,static_cast<Grapheme_Cluster_Break>(0)},
{0x6d6,Grapheme_Cluster_Break::Extend},
{0x6dd,Grapheme_Cluster_Break::Control},
{0x6de,static_cast<Grapheme_Cluster_Break>(0)},
{0x6df,Grapheme_Cluster_Break::Extend},
{0x6e5,static_cast<Grapheme_Cluster_Break>(0)},
{0x6e7,Grapheme_Cluster_Break::Extend},
{0x6e9,static_cast<Grapheme_Cluster_Break>(0)},
{0x6ea,Grapheme_Cluster_Break::Extend},
{0x6ee,static_cast<Grapheme_Cluster_Break>(0)},
{0x70f,Grapheme_Cluster_Break::Control},
{0x710,static_cast<Grapheme_Cluster_Break>(0)},
{0x711,Grapheme_Cluster_Break::Extend},
{0x712,static_cast<Grapheme_Cluster_Break>(0)},
{0x730,Grapheme_Cluster_Break::Extend},
{0x74b,static_cast<Grapheme_Cluster_Break>(0)},
{0x7a6,Grapheme_Cluster_Break::Extend},
{0x7b1,static_cast<Grapheme_Cluster_Break>(0)},
{0x7eb,Grapheme_Cluster_Break::Extend},
{0x7f4,static_cast<Grapheme_Cluster_Break>(0)},
{0x816,Grapheme_Cluster_Break::Extend},
{0x81a,static_cast<Grapheme_Cluster_Break>(0)},
{0x81b,Grapheme_Cluster_Break::Extend},
{0x824,static_cast<Grapheme_Cluster_Break>(0)},
{0x825,Grapheme_Cluster_Break::Extend},
{0x828,static_cast<Grapheme_Cluster_Break>(0)},
{0x829,Grapheme_Cluster_Break::Extend},
{0x82e,static_cast<Grapheme_Cluster_Break>(0)},
{0x859,Grapheme_Cluster_Break::Extend},
{0x85c,static_cast<Grapheme_Cluster_Break>(0)},
{0x8e3,Grapheme_Cluster_Break::Extend},
{0x903,Grapheme_Cluster_Break::SpacingMark},
{0x904,static_cast<Grapheme_Cluster_Break>(0)},
{0x93a,Grapheme_Cluster_Break::Extend},
{0x93b,Grapheme_Cluster_Break::SpacingMark},
{0x93c,Grapheme_Cluster_Break::Extend},
{0x93d,static_cast<Grapheme_Cluster_Break>(0)},
{0x93e,Grapheme_Cluster_Break::SpacingMark},
{0x941,Grapheme_Cluster_Break::Extend},
{0x949,Grapheme_Cluster_Break::SpacingMark},
{0x94d,Grapheme_Cluster_Break::Extend},
{0x94e,Grapheme_Cluster_Break::SpacingMark},
{0x950,static_cast<Grapheme_Cluster_Break>(0)},
{0x951,Grapheme_Cluster_Break::Extend},
{0x958,static_cast<Grapheme_Cluster_Break>(0)},
{0x962,Grapheme_Cluster_Break::Extend},
{0x964,static_cast<Grapheme_Cluster_Break>(0)},
{0x981,Grapheme_Cluster_Break::Extend},
{0x982,Grapheme_Cluster_Break::SpacingMark},
{0x984,static_cast<Grapheme_Cluster_Break>(0)},
{0x9bc,Grapheme_Cluster_Break::Extend},
{0x9bd,static_cast<Grapheme_Cluster_Break>(0)},
{0x9be,Grapheme_Cluster_Break::Extend},
{0x9bf,Grapheme_Cluster_Break::SpacingMark},
{0x9c1,Grapheme_Cluster_Break::Extend},
{0x9c5,static_cast<Grapheme_Cluster_Break>(0)},
{0x9c7,Grapheme_Cluster_Break::SpacingMark},
{0x9c9,static_cast<Grapheme_Cluster_Break>(0)},
{0x9cb,Grapheme_Cluster_Break::SpacingMark},
{0x9cd,Grapheme_Cluster_Break::Extend},
{0x9ce,static_cast<Grapheme_Cluster_Break>(0)},
{0x9d7,Grapheme_Cluster_Break::Extend},
{0x9d8,static_cast<Grapheme_Cluster_Break>(0)},
{0x9e2,Grapheme_Cluster_Break::Extend},
{0x9e4,static_cast<Grapheme_Cluster_Break>(0)},
{0xa01,Grapheme_Cluster_Break::Extend},
{0xa03,Grapheme_Cluster_Break::SpacingMark},
{0xa04,static_cast<Grapheme_Cluster_Break>(0)},
{0xa3c,Grapheme_Cluster_Break::Extend},
{0xa3d,static_cast<Grapheme_Cluster_Break>(0)},
{0xa3e,Grapheme_Cluster_Break::SpacingMark},
{0xa41,Grapheme_Cluster_Break::Extend},
{0xa43,static_cast<Grapheme_Cluster_Break>(0)},
{0xa47,Grapheme_Cluster_Break::Extend},
{0xa49,static_cast<Grapheme_Cluster_Break>(0)},
{0xa4b,Grapheme_Cluster_Break::Extend},
{0xa4e,static_cast<Grapheme_Cluster_Break>(0)},
{0xa51,Grapheme_Cluster_Break::Extend},
{0xa52,static_cast<Grapheme_Cluster_Break>(0)},
{0xa70,Grapheme_Cluster_Break::Extend},
{0xa72,static_cast<Grapheme_Cluster_Break>(0)},
{0xa75,Grapheme_Cluster_Break::Extend},
{0xa76,static_cast<Grapheme_Cluster_Break>(0)},
{0xa81,Grapheme_Cluster_Break::Extend},
{0xa83,Grapheme_Cluster_Break::SpacingMark},
{0xa84,static_cast<Grapheme_Cluster_Break>(0)},
{0xabc,Grapheme_Cluster_Break::Extend},
{0xabd,static_cast<Grapheme_Cluster_Break>(0)},
{0xabe,Grapheme_Cluster_Break::SpacingMark},
{0xac1,Grapheme_Cluster_Break::Extend},
{0xac6,static_cast<Grapheme_Cluster_Break>(0)},
{0xac7,Grapheme_Cluster_Break::Extend},
{0xac9,Grapheme_Cluster_Break::SpacingMark},
{0xaca,static_cast<Grapheme_Cluster_Break>(0)},
{0xacb,Grapheme_Cluster_Break::SpacingMark},
{0xacd,Grapheme_Cluster_Break::Extend},
{0xace,static_cast<Grapheme_Cluster_Break>(0)},
{0xae2,Grapheme_Cluster_Break::Extend},
{0xae4,static_cast<Grapheme_Cluster_Break>(0)},
{0xb01,Grapheme_Cluster_Break::Extend},
{0xb02,Grapheme_Cluster_Break::SpacingMark},
{0xb04,static_cast<Grapheme_Cluster_Break>(0)},
{0xb3c,Grapheme_Cluster_Break::Extend},
{0xb3d,static_cast<Grapheme_Cluster_Break>(0)},
{0xb3e,Grapheme_Cluster_Break::Extend},
{0xb40,Grapheme_Cluster_Break::SpacingMark},
{0xb41,Grapheme_Cluster_Break::Extend},
{0xb45,static_cast<Grapheme_Cluster_Break>(0)},
{0xb47,Grapheme_Cluster_Break::SpacingMark},
{0xb49,static_cast<Grapheme_Cluster_Break>(0)},
{0xb4b,Grapheme_Cluster_Break::SpacingMark},
{0xb4d,Grapheme_Cluster_Break::Extend},
{0xb4e,static_cast<Grapheme_Cluster_Break>(0)},
{0xb56,Grapheme_Cluster_Break::Extend},
{0xb58,static_cast<Grapheme_Cluster_Break>(0)},
{0xb62,Grapheme_Cluster_Break::Extend},
{0xb64,static_cast<Grapheme_Cluster_Break>(0)},
{0xb82,Grapheme_Cluster_Break::Extend},
{0xb83,static_cast<Grapheme_Cluster_Break>(0)},
{0xbbe,Grapheme_Cluster_Break::Extend},
{0xbbf,Grapheme_Cluster_Break::SpacingMark},
{0xbc0,Grapheme_Cluster_Break::Extend},
{0xbc1,Grapheme_Cluster_Break::SpacingMark},
{0xbc3,static_cast<Grapheme_Cluster_Break>(0)},
{0xbc6,Grapheme_Cluster_Break::SpacingMark},
{0xbc9,static_cast<Grapheme_Cluster_Break>(0)},
{0xbca,Grapheme_Cluster_Break::SpacingMark},
{0xbcd,Grapheme_Cluster_Break::Extend},
{0xbce,static_cast<Grapheme_Cluster_Break>(0)},
{0xbd7,Grapheme_Cluster_Break::Extend},
{0xbd8,static_cast<Grapheme_Cluster_Break>(0)},
{0xc00,Grapheme_Cluster_Break::Extend},
{0xc01,Grapheme_Cluster_Break::SpacingMark},
{0xc04,static_cast<Grapheme_Cluster_Break>(0)},
{0xc3e,Grapheme_Cluster_Break::Extend},
{0xc41,Grapheme_Cluster_Break::SpacingMark},
{0xc45,static_cast<Grapheme_Cluster_Break>(0)},
{0xc46,Grapheme_Cluster_Break::Extend},
{0xc49,static_cast<Grapheme_Cluster_Break>(0)},
{0xc4a,Grapheme_Cluster_Break::Extend},
{0xc4e,static_cast<Grapheme_Cluster_Break>(0)},
{0xc55,Grapheme_Cluster_Break::Extend},
{0xc57,static_cast<Grapheme_Cluster_Break>(0)},
{0xc62,Grapheme_Cluster_Break::Extend},
{0xc64,static_cast<Grapheme_Cluster_Break>(0)},
{0xc81,Grapheme_Cluster_Break::Extend},
{0xc82,Grapheme_Cluster_Break::SpacingMark},
{0xc84,static_cast<Grapheme_Cluster_Break>(0)},
{0xcbc,Grapheme_Cluster_Break::Extend},
{0xcbd,static_cast<Grapheme_Cluster_Break>(0)},
{0xcbe,Grapheme_Cluster_Break::SpacingMark},
{0xcbf,Grapheme_Cluster_Break::Extend},
{0xcc0,Grapheme_Cluster_Break::SpacingMark},
{0xcc2,Grapheme_Cluster_Break::Extend},
{0xcc3,Grapheme_Cluster_Break::SpacingMark},
{0xcc5,static_cast<Grapheme_Cluster_Break>(0)},
{0xcc6,Grapheme_Cluster_Break::Extend},
{0xcc7,Grapheme_Cluster_Break::SpacingMark},
{0xcc9,static_cast<Grapheme_Cluster_Break>(0)},
{0xcca,Grapheme_Cluster_Break::SpacingMark},
{0xccc,Grapheme_Cluster_Break::Extend},
{0xcce,static_cast<Grapheme_Cluster_Break>(0)},
{0xcd5,Grapheme_Cluster_Break::Extend},
{0xcd7,static_cast<Grapheme_Cluster_Break>(0)},
{0xce2,Grapheme_Cluster_Break::Extend},
{0xce4,static_cast<Grapheme_Cluster_Break>(0)},
{0xd01,Grapheme_Cluster_Break::Extend},
{0xd02,Grapheme_Cluster_Break::SpacingMark},
{0xd04,static_cast<Grapheme_Cluster_Break>(0)},
{0xd3e,Grapheme_Cluster_Break::Extend},
{0xd3f,Grapheme_Cluster_Break::SpacingMark},
{0xd41,Grapheme_Cluster_Break::Extend},
{0xd45,static_cast<Grapheme_Cluster_Break>(0)},
{0xd46,Grapheme_Cluster_Break::SpacingMark},
{0xd49,static_cast<Grapheme_Cluster_Break>(0)},
{0xd4a,Grapheme_Cluster_Break::SpacingMark},
{0xd4d,Grapheme_Cluster_Break::Extend},
{0xd4e,static_cast<Grapheme_Cluster_Break>(0)},
{0xd57,Grapheme_Cluster_Break::Extend},
{0xd58,static_cast<Grapheme_Cluster_Break>(0)},
{0xd62,Grapheme_Cluster_Break::Extend},
{0xd64,static_cast<Grapheme_Cluster_Break>(0)},
{0xd82,Grapheme_Cluster_Break::SpacingMark},
{0xd84,static_cast<Grapheme_Cluster_Break>(0)},
{0xdca,Grapheme_Cluster_Break::Extend},
{0xdcb,static_cast<Grapheme_Cluster_Break>(0)},
{0xdcf,Grapheme_Cluster_Break::Extend},
{0xdd0,Grapheme_Cluster_Break::SpacingMark},
{0xdd2,Grapheme_Cluster_Break::Extend},
{0xdd5,static_cast<Grapheme_Cluster_Break>(0)},
{0xdd6,Grapheme_Cluster_Break::Extend},
{0xdd7,static_cast<Grapheme_Cluster_Break>(0)},
{0xdd8,Grapheme_Cluster_Break::SpacingMark},
{0xddf,Grapheme_Cluster_Break::Extend},
{0xde0,static_cast<Grapheme_Cluster_Break>(0)},
{0xdf2,Grapheme_Cluster_Break::SpacingMark},
{0xdf4,static_cast<Grapheme_Cluster_Break>(0)},
{0xe31,Grapheme_Cluster_Break::Extend},
{0xe32,static_cast<Grapheme_Cluster_Break>(0)},
{0xe33,Grapheme_Cluster_Break::SpacingMark},
{0xe34,Grapheme_Cluster_Break::Extend},
{0xe3b,static_cast<Grapheme_Cluster_Break>(0)},
{0xe47,Grapheme_Cluster_Break::Extend},
{0xe4f,static_cast<Grapheme_Cluster_Break>(0)},
{0xeb1,Grapheme_Cluster_Break::Extend},
{0xeb2,static_cast<Grapheme_Cluster_Break>(0)},
{0xeb3,Grapheme_Cluster_Break::SpacingMark},
{0xeb4,Grapheme_Cluster_Break::Extend},
{0xeba,static_cast<Grapheme_Cluster_Break>(0)},
{0xebb,Grapheme_Cluster_Break::Extend},
{0xebd,static_cast<Grapheme_Cluster_Break>(0)},
{0xec8,Grapheme_Cluster_Break::Extend},
{0xece,static_cast<Grapheme_Cluster_Break>(0)},
{0xf18,Grapheme_Cluster_Break::Extend},
{0xf1a,static_cast<Grapheme_Cluster_Break>(0)},
{0xf35,Grapheme_Cluster_Break::Extend},
{0xf36,static_cast<Grapheme_Cluster_Break>(0)},
{0xf37,Grapheme_Cluster_Break::Extend},
{0xf38,static_cast<Grapheme_Cluster_Break>(0)},
{0xf39,Grapheme_Cluster_Break::Extend},
{0xf3a,static_cast<Grapheme_Cluster_Break>(0)},
{0xf3e,Grapheme_Cluster_Break::SpacingMark},
{0xf40,static_cast<Grapheme_Cluster_Break>(0)},
{0xf71,Grapheme_Cluster_Break::Extend},
{0xf7f,Grapheme_Cluster_Break::SpacingMark},
{0xf80,Grapheme_Cluster_Break::Extend},
{0xf85,static_cast<Grapheme_Cluster_Break>(0)},
{0xf86,Grapheme_Cluster_Break::Extend},
{0xf88,static_cast<Grapheme_Cluster_Break>(0)},
{0xf8d,Grapheme_Cluster_Break::Extend},
{0xf98,static_cast<Grapheme_Cluster_Break>(0)},
{0xf99,Grapheme_Cluster_Break::Extend},
{0xfbd,static_cast<Grapheme_Cluster_Break>(0)},
{0xfc6,Grapheme_Cluster_Break::Extend},
{0xfc7,static_cast<Grapheme_Cluster_Break>(0)},
{0x102d,Grapheme_Cluster_Break::Extend},
{0x1031,Grapheme_Cluster_Break::SpacingMark},
{0x1032,Grapheme_Cluster_Break::Extend},
{0x1038,static_cast<Grapheme_Cluster_Break>(0)},
{0x1039,Grapheme_Cluster_Break::Extend},
{0x103b,Grapheme_Cluster_Break::SpacingMark},
{0x103d,Grapheme_Cluster_Break::Extend},
{0x103f,static_cast<Grapheme_Cluster_Break>(0)},
{0x1056,Grapheme_Cluster_Break::SpacingMark},
{0x1058,Grapheme_Cluster_Break::Extend},
{0x105a,static_cast<Grapheme_Cluster_Break>(0)},
{0x105e,Grapheme_Cluster_Break::Extend},
{0x1061,static_cast<Grapheme_Cluster_Break>(0)},
{0x1071,Grapheme_Cluster_Break::Extend},
{0x1075,static_cast<Grapheme_Cluster_Break>(0)},
{0x1082,Grapheme_Cluster_Break::Extend},
{0x1083,static_cast<Grapheme_Cluster_Break>(0)},
{0x1084,Grapheme_Cluster_Break::SpacingMark},
{0x1085,Grapheme_Cluster_Break::Extend},
{0x1087,static_cast<Grapheme_Cluster_Break>(0)},
{0x108d,Grapheme_Cluster_Break::Extend},
{0x108e,static_cast<Grapheme_Cluster_Break>(0)},
{0x109d,Grapheme_Cluster_Break::Extend},
{0x109e,static_cast<Grapheme_Cluster_Break>(0)},
{0x1100,Grapheme_Cluster_Break::L},
{0x1160,Grapheme_Cluster_Break::V},
{0x11a8,Grapheme_Cluster_Break::T},
{0x1200,static_cast<Grapheme_Cluster_Break>(0)},
{0x135d,Grapheme_Cluster_Break::Extend},
{0x1360,static_cast<Grapheme_Cluster_Break>(0)},
{0x1712,Grapheme_Cluster_Break::Extend},
{0x1715,static_cast<Grapheme_Cluster_Break>(0)},
{0x1732,Grapheme_Cluster_Break::Extend},
{0x1735,static_cast<Grapheme_Cluster_Break>(0)},
{0x1752,Grapheme_Cluster_Break::Extend},
{0x1754,static_cast<Grapheme_Cluster_Break>(0)},
{0x1772,Grapheme_Cluster_Break::Extend},
{0x1774,static_cast<Grapheme_Cluster_Break>(0)},
{0x17b4,Grapheme_Cluster_Break::Extend},
{0x17b6,Grapheme_Cluster_Break::SpacingMark},
{0x17b7,Grapheme_Cluster_Break::Extend},
{0x17be,Grapheme_Cluster_Break::SpacingMark},
{0x17c6,Grapheme_Cluster_Break::Extend},
{0x17c7,Grapheme_Cluster_Break::SpacingMark},
{0x17c9,Grapheme_Cluster_Break::Extend},
{0x17d4,static_cast<Grapheme_Cluster_Break>(0)},
{0x17dd,Grapheme_Cluster_Break::Extend},
{0x17de,static_cast<Grapheme_Cluster_Break>(0)},
{0x180b,Grapheme_Cluster_Break::Extend},
{0x180e,Grapheme_Cluster_Break::Control},
{0x180f,static_cast<Grapheme_Cluster_Break>(0)},
{0x18a9,Grapheme_Cluster_Break::Extend},
{0x18aa,static_cast<Grapheme_Cluster_Break>(0)},
{0x1920,Grapheme_Cluster_Break::Extend},
{0x1923,Grapheme_Cluster_Break::SpacingMark},
{0x1927,Grapheme_Cluster_Break::Extend},
{0x1929,Grapheme_Cluster_Break::SpacingMark},
{0x192c,static_cast<Grapheme_Cluster_Break>(0)},
{0x1930,Grapheme_Cluster_Break::SpacingMark},
{0x1932,Grapheme_Cluster_Break::Extend},
{0x1933,Grapheme_Cluster_Break::SpacingMark},
{0x1939,Grapheme_Cluster_Break::Extend},
{0x193c,static_cast<Grapheme_Cluster_Break>(0)},
{0x1a17,Grapheme_Cluster_Break::Extend},
{0x1a19,Grapheme_Cluster_Break::SpacingMark},
{0x1a1b,Grapheme_Cluster_Break::Extend},
{0x1a1c,static_cast<Grapheme_Cluster_Break>(0)},
{0x1a55,Grapheme_Cluster_Break::SpacingMark},
{0x1a56,Grapheme_Cluster_Break::Extend},
{0x1a57,Grapheme_Cluster_Break::SpacingMark},
{0x1a58,Grapheme_Cluster_Break::Extend},
{0x1a5f,static_cast<Grapheme_Cluster_Break>(0)},
{0x1a60,Grapheme_Cluster_Break::Extend},
{0x1a61,static_cast<Grapheme_Cluster_Break>(0)},
{0x1a62,Grapheme_Cluster_Break::Extend},
{0x1a63,static_cast<Grapheme_Cluster_Break>(0)},
{0x1a65,Grapheme_Cluster_Break::Extend},
{0x1a6d,Grapheme_Cluster_Break::SpacingMark},
{0x1a73,Grapheme_Cluster_Break::Extend},
{0x1a7d,static_cast<Grapheme_Cluster_Break>(0)},
{0x1a7f,Grapheme_Cluster_Break::Extend},
{0x1a80,static_cast<Grapheme_Cluster_Break>(0)},
{0x1ab0,Grapheme_Cluster_Break::Extend},
{0x1abf,static_cast<Grapheme_Cluster_Break>(0)},
{0x1b00,Grapheme_Cluster_Break::Extend},
{0x1b04,Grapheme_Cluster_Break::SpacingMark},
{0x1b05,static_cast<Grapheme_Cluster_Break>(0)},
{0x1b34,Grapheme_Cluster_Break::Extend},
{0x1b35,Grapheme_Cluster_Break::SpacingMark},
{0x1b36,Grapheme_Cluster_Break::Extend},
{0x1b3b,Grapheme_Cluster_Break::SpacingMark},
{0x1b3c,Grapheme_Cluster_Break::Extend},
{0x1b3d,Grapheme_Cluster_Break::SpacingMark},
{0x1b42,Grapheme_Cluster_Break::Extend},
{0x1b43,Grapheme_Cluster_Break::SpacingMark},
{0x1b45,static_cast<Grapheme_Cluster_Break>(0)},
{0x1b6b,Grapheme_Cluster_Break::Extend},
{0x1b74,static_cast<Grapheme_Cluster_Break>(0)},
{0x1b80,Grapheme_Cluster_Break::Extend},
{0x1b82,Grapheme_Cluster_Break::SpacingMark},
{0x1b83,static_cast<Grapheme_Cluster_Break>(0)},
{0x1ba1,Grapheme_Cluster_Break::SpacingMark},
{0x1ba2,Grapheme_Cluster_Break::Extend},
{0x1ba6,Grapheme_Cluster_Break::SpacingMark},
{0x1ba8,Grapheme_Cluster_Break::Extend},
{0x1baa,Grapheme_Cluster_Break::SpacingMark},
{0x1bab,Grapheme_Cluster_Break::Extend},
{0x1bae,static_cast<Grapheme_Cluster_Break>(0)},
{0x1be6,Grapheme_Cluster_Break::Extend},
{0x1be7,Grapheme_Cluster_Break::SpacingMark},
{0x1be8,Grapheme_Cluster_Break::Extend},
{0x1bea,Grapheme_Cluster_Break::SpacingMark},
{0x1bed,Grapheme_Cluster_Break::Extend},
{0x1bee,Grapheme_Cluster_Break::SpacingMark},
{0x1bef,Grapheme_Cluster_Break::Extend},
{0x1bf2,Grapheme_Cluster_Break::SpacingMark},
{0x1bf4,static_cast<Grapheme_Cluster_Break>(0)},
{0x1c24,Grapheme_Cluster_Break::SpacingMark},
{0x1c2c,Grapheme_Cluster_Break::Extend},
{0x1c34,Grapheme_Cluster_Break::SpacingMark},
{0x1c36,Grapheme_Cluster_Break::Extend},
{0x1c38,static_cast<Grapheme_Cluster_Break>(0)},
{0x1cd0,Grapheme_Cluster_Break::Extend},
{0x1cd3,static_cast<Grapheme_Cluster_Break>(0)},
{0x1cd4,Grapheme_Cluster_Break::Extend},
{0x1ce1,Grapheme_Cluster_Break::SpacingMark},
{0x1ce2,Grapheme_Cluster_Break::Extend},
{0x1ce9,static_cast<Grapheme_Cluster_Break>(0)},
{0x1ced,Grapheme_Cluster_Break::Extend},
{0x1cee,static_cast<Grapheme_Cluster_Break>(0)},
{0x1cf2,Grapheme_Cluster_Break::SpacingMark},
{0x1cf4,Grapheme_Cluster_Break::Extend},
{0x1cf5,static_cast<Grapheme_Cluster_Break>(0)},
{0x1cf8,Grapheme_Cluster_Break::Extend},
{0x1cfa,static_cast<Grapheme_Cluster_Break>(0)},
{0x1dc0,Grapheme_Cluster_Break::Extend},
{0x1df6,static_cast<Grapheme_Cluster_Break>(0)},
{0x1dfc,Grapheme_Cluster_Break::Extend},
{0x1e00,static_cast<Grapheme_Cluster_Break>(0)},
{0x200b,Grapheme_Cluster_Break::Control},
{0x200c,Grapheme_Cluster_Break::Extend},
{0x200e,Grapheme_Cluster_Break::Control},
{0x2010,static_cast<Grapheme_Cluster_Break>(0)},
{0x2028,Grapheme_Cluster_Break::Control},
{0x202f,static_cast<Grapheme_Cluster_Break>(0)},
{0x2060,Grapheme_Cluster_Break::Control},
{0x2070,static_cast<Grapheme_Cluster_Break>(0)},
{0x20d0,Grapheme_Cluster_Break::Extend},
{0x20f1,static_cast<Grapheme_Cluster_Break>(0)},
{0x2cef,Grapheme_Cluster_Break::Extend},
{0x2cf2,static_cast<Grapheme_Cluster_Break>(0)},
{0x2d7f,Grapheme_Cluster_Break::Extend},
{0x2d80,static_cast<Grapheme_Cluster_Break>(0)},
{0x2de0,Grapheme_Cluster_Break::Extend},
{0x2e00,static_cast<Grapheme_Cluster_Break>(0)},
{0x302a,Grapheme_Cluster_Break::Extend},
{0x3030,static_cast<Grapheme_Cluster_Break>(0)},
{0x3099,Grapheme_Cluster_Break::Extend},
{0x309b,static_cast<Grapheme_Cluster_Break>(0)},
{0xa66f,Grapheme_Cluster_Break::Extend},
{0xa673,static_cast<Grapheme_Cluster_Break>(0)},
{0xa674,Grapheme_Cluster_Break::Extend},
{0xa67e,static_cast<Grapheme_Cluster_Break>(0)},
{0xa69e,Grapheme_Cluster_Break::Extend},
{0xa6a0,static_cast<Grapheme_Cluster_Break>(0)},
{0xa6f0,Grapheme_Cluster_Break::Extend},
{0xa6f2,static_cast<Grapheme_Cluster_Break>(0)},
{0xa802,Grapheme_Cluster_Break::Extend},
{0xa803,static_cast<Grapheme_Cluster_Break>(0)},
{0xa806,Grapheme_Cluster_Break::Extend},
{0xa807,static_cast<Grapheme_Cluster_Break>(0)},
{0xa80b,Grapheme_Cluster_Break::Extend},
{0xa80c,static_cast<Grapheme_Cluster_Break>(0)},
{0xa823,Grapheme_Cluster_Break::SpacingMark},
{0xa825,Grapheme_Cluster_Break::Extend},
{0xa827,Grapheme_Cluster_Break::SpacingMark},
{0xa828,static_cast<Grapheme_Cluster_Break>(0)},
{0xa880,Grapheme_Cluster_Break::SpacingMark},
{0xa882,static_cast<Grapheme_Cluster_Break>(0)},
{0xa8b4,Grapheme_Cluster_Break::SpacingMark},
{0xa8c4,Grapheme_Cluster_Break::Extend},
{0xa8c5,static_cast<Grapheme_Cluster_Break>(0)},
{0xa8e0,Grapheme_Cluster_Break::Extend},
{0xa8f2,static_cast<Grapheme_Cluster_Break>(0)},
{0xa926,Grapheme_Cluster_Break::Extend},
{0xa92e,static_cast<Grapheme_Cluster_Break>(0)},
{0xa947,Grapheme_Cluster_Break::Extend},
{0xa952,Grapheme_Cluster_Break::SpacingMark},
{0xa954,static_cast<Grapheme_Cluster_Break>(0)},
{0xa960,Grapheme_Cluster_Break::L},
{0xa97d,static_cast<Grapheme_Cluster_Break>(0)},
{0xa980,Grapheme_Cluster_Break::Extend},
{0xa983,Grapheme_Cluster_Break::SpacingMark},
{0xa984,static_cast<Grapheme_Cluster_Break>(0)},
{0xa9b3,Grapheme_Cluster_Break::Extend},
{0xa9b4,Grapheme_Cluster_Break::SpacingMark},
{0xa9b6,Grapheme_Cluster_Break::Extend},
{0xa9ba,Grapheme_Cluster_Break::SpacingMark},
{0xa9bc,Grapheme_Cluster_Break::Extend},
{0xa9bd,Grapheme_Cluster_Break::SpacingMark},
{0xa9c1,static_cast<Grapheme_Cluster_Break>(0)},
{0xa9e5,Grapheme_Cluster_Break::Extend},
{0xa9e6,static_cast<Grapheme_Cluster_Break>(0)},
{0xaa29,Grapheme_Cluster_Break::Extend},
{0xaa2f,Grapheme_Cluster_Break::SpacingMark},
{0xaa31,Grapheme_Cluster_Break::Extend},
{0xaa33,Grapheme_Cluster_Break::SpacingMark},
{0xaa35,Grapheme_Cluster_Break::Extend},
{0xaa37,static_cast<Grapheme_Cluster_Break>(0)},
{0xaa43,Grapheme_Cluster_Break::Extend},
{0xaa44,static_cast<Grapheme_Cluster_Break>(0)},
{0xaa4c,Grapheme_Cluster_Break::Extend},
{0xaa4d,Grapheme_Cluster_Break::SpacingMark},
{0xaa4e,static_cast<Grapheme_Cluster_Break>(0)},
{0xaa7c,Grapheme_Cluster_Break::Extend},
{0xaa7d,static_cast<Grapheme_Cluster_Break>(0)},
{0xaab0,Grapheme_Cluster_Break::Extend},
{0xaab1,static_cast<Grapheme_Cluster_Break>(0)},
{0xaab2,Grapheme_Cluster_Break::Extend},
{0xaab5,static_cast<Grapheme_Cluster_Break>(0)},
{0xaab7,Grapheme_Cluster_Break::Extend},
{0xaab9,static_cast<Grapheme_Cluster_Break>(0)},
{0xaabe,Grapheme_Cluster_Break::Extend},
{0xaac0,static_cast<Grapheme_Cluster_Break>(0)},
{0xaac1,Grapheme_Cluster_Break::Extend},
{0xaac2,static_cast<Grapheme_Cluster_Break>(0)},
{0xaaeb,Grapheme_Cluster_Break::SpacingMark},
{0xaaec,Grapheme_Cluster_Break::Extend},
{0xaaee,Grapheme_Cluster_Break::SpacingMark},
{0xaaf0,static_cast<Grapheme_Cluster_Break>(0)},
{0xaaf5,Grapheme_Cluster_Break::SpacingMark},
{0xaaf6,Grapheme_Cluster_Break::Extend},
{0xaaf7,static_cast<Grapheme_Cluster_Break>(0)},
{0xabe3,Grapheme_Cluster_Break::SpacingMark},
{0xabe5,Grapheme_Cluster_Break::Extend},
{0xabe6,Grapheme_Cluster_Break::SpacingMark},
{0xabe8,Grapheme_Cluster_Break::Extend},
{0xabe9,Grapheme_Cluster_Break::SpacingMark},
{0xabeb,static_cast<Grapheme_Cluster_Break>(0)},
{0xabec,Grapheme_Cluster_Break::SpacingMark},
{0xabed,Grapheme_Cluster_Break::Extend},
{0xabee,static_cast<Grapheme_Cluster_Break>(0)},
{0xac00,Grapheme_Cluster_Break::LV},
{0xac01,Grapheme_Cluster_Break::LVT},
{0xac1c,Grapheme_Cluster_Break::LV},
{0xac1d,Grapheme_Cluster_Break::LVT},
{0xac38,Grapheme_Cluster_Break::LV},
{0xac39,Grapheme_Cluster_Break::LVT},
{0xac54,Grapheme_Cluster_Break::LV},
{0xac55,Grapheme_Cluster_Break::LVT},
{0xac70,Grapheme_Cluster_Break::LV},
{0xac71,Grapheme_Cluster_Break::LVT},
{0xac8c,Grapheme_Cluster_Break::LV},
{0xac8d,Grapheme_Cluster_Break::LVT},
{0xaca8,Grapheme_Cluster_Break::LV},
{0xaca9,Grapheme_Cluster_Break::LVT},
{0xacc4,Grapheme_Cluster_Break::LV},
{0xacc5,Grapheme_Cluster_Break::LVT},
{0xace0,Grapheme_Cluster_Break::LV},
{0xace1,Grapheme_Cluster_Break::LVT},
{0xacfc,Grapheme_Cluster_Break::LV},
{0xacfd,Grapheme_Cluster_Break::LVT},
{0xad18,Grapheme_Cluster_Break::LV},
{0xad19,Grapheme_Cluster_Break::LVT},
{0xad34,Grapheme_Cluster_Break::LV},
{0xad35,Grapheme_Cluster_Break::LVT},
{0xad50,Grapheme_Cluster_Break::LV},
{0xad51,Grapheme_Cluster_Break::LVT},
{0xad6c,Grapheme_Cluster_Break::LV},
{0xad6d,Grapheme_Cluster_Break::LVT},
{0xad88,Grapheme_Cluster_Break::LV},
{0xad89,Grapheme_Cluster_Break::LVT},
{0xada4,Grapheme_Cluster_Break::LV},
{0xada5,Grapheme_Cluster_Break::LVT},
{0xadc0,Grapheme_Cluster_Break::LV},
{0xadc1,Grapheme_Cluster_Break::LVT},
{0xaddc,Grapheme_Cluster_Break::LV},
{0xaddd,Grapheme_Cluster_Break::LVT},
{0xadf8,Grapheme_Cluster_Break::LV},
{0xadf9,Grapheme_Cluster_Break::LVT},
{0xae14,Grapheme_Cluster_Break::LV},
{0xae15,Grapheme_Cluster_Break::LVT},
{0xae30,Grapheme_Cluster_Break::LV},
{0xae31,Grapheme_Cluster_Break::LVT},
{0xae4c,Grapheme_Cluster_Break::LV},
{0xae4d,Grapheme_Cluster_Break::LVT},
{0xae68,Grapheme_Cluster_Break::LV},
{0xae69,Grapheme_Cluster_Break::LVT},
{0xae84,Grapheme_Cluster_Break::LV},
{0xae85,Grapheme_Cluster_Break::LVT},
{0xaea0,Grapheme_Cluster_Break::LV},
{0xaea1,Grapheme_Cluster_Break::LVT},
{0xaebc,Grapheme_Cluster_Break::LV},
{0xaebd,Grapheme_Cluster_Break::LVT},
{0xaed8,Grapheme_Cluster_Break::LV},
{0xaed9,Grapheme_Cluster_Break::LVT},
{0xaef4,Grapheme_Cluster_Break::LV},
{0xaef5,Grapheme_Cluster_Break::LVT},
{0xaf10,Grapheme_Cluster_Break::LV},
{0xaf11,Grapheme_Cluster_Break::LVT},
{0xaf2c,Grapheme_Cluster_Break::LV},
{0xaf2d,Grapheme_Cluster_Break::LVT},
{0xaf48,Grapheme_Cluster_Break::LV},
{0xaf49,Grapheme_Cluster_Break::LVT},
{0xaf64,Grapheme_Cluster_Break::LV},
{0xaf65,Grapheme_Cluster_Break::LVT},
{0xaf80,Grapheme_Cluster_Break::LV},
{0xaf81,Grapheme_Cluster_Break::LVT},
{0xaf9c,Grapheme_Cluster_Break::LV},
{0xaf9d,Grapheme_Cluster_Break::LVT},
{0xafb8,Grapheme_Cluster_Break::LV},
{0xafb9,Grapheme_Cluster_Break::LVT},
{0xafd4,Grapheme_Cluster_Break::LV},
{0xafd5,Grapheme_Cluster_Break::LVT},
{0xaff0,Grapheme_Cluster_Break::LV},
{0xaff1,Grapheme_Cluster_Break::LVT},
{0xb00c,Grapheme_Cluster_Break::LV},
{0xb00d,Grapheme_Cluster_Break::LVT},
{0xb028,Grapheme_Cluster_Break::LV},
{0xb029,Grapheme_Cluster_Break::LVT},
{0xb044,Grapheme_Cluster_Break::LV},
{0xb045,Grapheme_Cluster_Break::LVT},
{0xb060,Grapheme_Cluster_Break::LV},
{0xb061,Grapheme_Cluster_Break::LVT},
{0xb07c,Grapheme_Cluster_Break::LV},
{0xb07d,Grapheme_Cluster_Break::LVT},
{0xb098,Grapheme_Cluster_Break::LV},
{0xb099,Grapheme_Cluster_Break::LVT},
{0xb0b4,Grapheme_Cluster_Break::LV},
{0xb0b5,Grapheme_Cluster_Break::LVT},
{0xb0d0,Grapheme_Cluster_Break::LV},
{0xb0d1,Grapheme_Cluster_Break::LVT},
{0xb0ec,Grapheme_Cluster_Break::LV},
{0xb0ed,Grapheme_Cluster_Break::LVT},
{0xb108,Grapheme_Cluster_Break::LV},
{0xb109,Grapheme_Cluster_Break::LVT},
{0xb124,Grapheme_Cluster_Break::LV},
{0xb125,Grapheme_Cluster_Break::LVT},
{0xb140,Grapheme_Cluster_Break::LV},
{0xb141,Grapheme_Cluster_Break::LVT},
{0xb15c,Grapheme_Cluster_Break::LV},
{0xb15d,Grapheme_Cluster_Break::LVT},
{0xb178,Grapheme_Cluster_Break::LV},
{0xb179,Grapheme_Cluster_Break::LVT},
{0xb194,Grapheme_Cluster_Break::LV},
{0xb195,Grapheme_Cluster_Break::LVT},
{0xb1b0,Grapheme_Cluster_Break::LV},
{0xb1b1,Grapheme_Cluster_Break::LVT},
{0xb1cc,Grapheme_Cluster_Break::LV},
{0xb1cd,Grapheme_Cluster_Break::LVT},
{0xb1e8,Grapheme_Cluster_Break::LV},
{0xb1e9,Grapheme_Cluster_Break::LVT},
{0xb204,Grapheme_Cluster_Break::LV},
{0xb205,Grapheme_Cluster_Break::LVT},
{0xb220,Grapheme_Cluster_Break::LV},
{0xb221,Grapheme_Cluster_Break::LVT},
{0xb23c,Grapheme_Cluster_Break::LV},
{0xb23d,Grapheme_Cluster_Break::LVT},
{0xb258,Grapheme_Cluster_Break::LV},
{0xb259,Grapheme_Cluster_Break::LVT},
{0xb274,Grapheme_Cluster_Break::LV},
{0xb275,Grapheme_Cluster_Break::LVT},
{0xb290,Grapheme_Cluster_Break::LV},
{0xb291,Grapheme_Cluster_Break::LVT},
{0xb2ac,Grapheme_Cluster_Break::LV},
{0xb2ad,Grapheme_Cluster_Break::LVT},
{0xb2c8,Grapheme_Cluster_Break::LV},
{0xb2c9,Grapheme_Cluster_Break::LVT},
{0xb2e4,Grapheme_Cluster_Break::LV},
{0xb2e5,Grapheme_Cluster_Break::LVT},
{0xb300,Grapheme_Cluster_Break::LV},
{0xb301,Grapheme_Cluster_Break::LVT},
{0xb31c,Grapheme_Cluster_Break::LV},
{0xb31d,Grapheme_Cluster_Break::LVT},
{0xb338,Grapheme_Cluster_Break::LV},
{0xb339,Grapheme_Cluster_Break::LVT},
{0xb354,Grapheme_Cluster_Break::LV},
{0xb355,Grapheme_Cluster_Break::LVT},
{0xb370,Grapheme_Cluster_Break::LV},
{0xb371,Grapheme_Cluster_Break::LVT},
{0xb38c,Grapheme_Cluster_Break::LV},
{0xb38d,Grapheme_Cluster_Break::LVT},
{0xb3a8,Grapheme_Cluster_Break::LV},
{0xb3a9,Grapheme_Cluster_Break::LVT},
{0xb3c4,Grapheme_Cluster_Break::LV},
{0xb3c5,Grapheme_Cluster_Break::LVT},
{0xb3e0,Grapheme_Cluster_Break::LV},
{0xb3e1,Grapheme_Cluster_Break::LVT},
{0xb3fc,Grapheme_Cluster_Break::LV},
{0xb3fd,Grapheme_Cluster_Break::LVT},
{0xb418,Grapheme_Cluster_Break::LV},
{0xb419,Grapheme_Cluster_Break::LVT},
{0xb434,Grapheme_Cluster_Break::LV},
{0xb435,Grapheme_Cluster_Break::LVT},
{0xb450,Grapheme_Cluster_Break::LV},
{0xb451,Grapheme_Cluster_Break::LVT},
{0xb46c,Grapheme_Cluster_Break::LV},
{0xb46d,Grapheme_Cluster_Break::LVT},
{0xb488,Grapheme_Cluster_Break::LV},
{0xb489,Grapheme_Cluster_Break::LVT},
{0xb4a4,Grapheme_Cluster_Break::LV},
{0xb4a5,Grapheme_Cluster_Break::LVT},
{0xb4c0,Grapheme_Cluster_Break::LV},
{0xb4c1,Grapheme_Cluster_Break::LVT},
{0xb4dc,Grapheme_Cluster_Break::LV},
{0xb4dd,Grapheme_Cluster_Break::LVT},
{0xb4f8,Grapheme_Cluster_Break::LV},
{0xb4f9,Grapheme_Cluster_Break::LVT},
{0xb514,Grapheme_Cluster_Break::LV},
{0xb515,Grapheme_Cluster_Break::LVT},
{0xb530,Grapheme_Cluster_Break::LV},
{0xb531,Grapheme_Cluster_Break::LVT},
{0xb54c,Grapheme_Cluster_Break::LV},
{0xb54d,Grapheme_Cluster_Break::LVT},
{0xb568,Grapheme_Cluster_Break::LV},
{0xb569,Grapheme_Cluster_Break::LVT},
{0xb584,Grapheme_Cluster_Break::LV},
{0xb585,Grapheme_Cluster_Break::LVT},
{0xb5a0,Grapheme_Cluster_Break::LV},
{0xb5a1,Grapheme_Cluster_Break::LVT},
{0xb5bc,Grapheme_Cluster_Break::LV},
{0xb5bd,Grapheme_Cluster_Break::LVT},
{0xb5d8,Grapheme_Cluster_Break::LV},
{0xb5d9,Grapheme_Cluster_Break::LVT},
{0xb5f4,Grapheme_Cluster_Break::LV},
{0xb5f5,Grapheme_Cluster_Break::LVT},
{0xb610,Grapheme_Cluster_Break::LV},
{0xb611,Grapheme_Cluster_Break::LVT},
{0xb62c,Grapheme_Cluster_Break::LV},
{0xb62d,Grapheme_Cluster_Break::LVT},
{0xb648,Grapheme_Cluster_Break::LV},
{0xb649,Grapheme_Cluster_Break::LVT},
{0xb664,Grapheme_Cluster_Break::LV},
{0xb665,Grapheme_Cluster_Break::LVT},
{0xb680,Grapheme_Cluster_Break::LV},
{0xb681,Grapheme_Cluster_Break::LVT},
{0xb69c,Grapheme_Cluster_Break::LV},
{0xb69d,Grapheme_Cluster_Break::LVT},
{0xb6b8,Grapheme_Cluster_Break::LV},
{0xb6b9,Grapheme_Cluster_Break::LVT},
{0xb6d4,Grapheme_Cluster_Break::LV},
{0xb6d5,Grapheme_Cluster_Break::LVT},
{0xb6f0,Grapheme_Cluster_Break::LV},
{0xb6f1,Grapheme_Cluster_Break::LVT},
{0xb70c,Grapheme_Cluster_Break::LV},
{0xb70d,Grapheme_Cluster_Break::LVT},
{0xb728,Grapheme_Cluster_Break::LV},
{0xb729,Grapheme_Cluster_Break::LVT},
{0xb744,Grapheme_Cluster_Break::LV},
{0xb745,Grapheme_Cluster_Break::LVT},
{0xb760,Grapheme_Cluster_Break::LV},
{0xb761,Grapheme_Cluster_Break::LVT},
{0xb77c,Grapheme_Cluster_Break::LV},
{0xb77d,Grapheme_Cluster_Break::LVT},
{0xb798,Grapheme_Cluster_Break::LV},
{0xb799,Grapheme_Cluster_Break::LVT},
{0xb7b4,Grapheme_Cluster_Break::LV},
{0xb7b5,Grapheme_Cluster_Break::LVT},
{0xb7d0,Grapheme_Cluster_Break::LV},
{0xb7d1,Grapheme_Cluster_Break::LVT},
{0xb7ec,Grapheme_Cluster_Break::LV},
{0xb7ed,Grapheme_Cluster_Break::LVT},
{0xb808,Grapheme_Cluster_Break::LV},
{0xb809,Grapheme_Cluster_Break::LVT},
{0xb824,Grapheme_Cluster_Break::LV},
{0xb825,Grapheme_Cluster_Break::LVT},
{0xb840,Grapheme_Cluster_Break::LV},
{0xb841,Grapheme_Cluster_Break::LVT},
{0xb85c,Grapheme_Cluster_Break::LV},
{0xb85d,Grapheme_Cluster_Break::LVT},
{0xb878,Grapheme_Cluster_Break::LV},
{0xb879,Grapheme_Cluster_Break::LVT},
{0xb894,Grapheme_Cluster_Break::LV},
{0xb895,Grapheme_Cluster_Break::LVT},
{0xb8b0,Grapheme_Cluster_Break::LV},
{0xb8b1,Grapheme_Cluster_Break::LVT},
{0xb8cc,Grapheme_Cluster_Break::LV},
{0xb8cd,Grapheme_Cluster_Break::LVT},
{0xb8e8,Grapheme_Cluster_Break::LV},
{0xb8e9,Grapheme_Cluster_Break::LVT},
{0xb904,Grapheme_Cluster_Break::LV},
{0xb905,Grapheme_Cluster_Break::LVT},
{0xb920,Grapheme_Cluster_Break::LV},
{0xb921,Grapheme_Cluster_Break::LVT},
{0xb93c,Grapheme_Cluster_Break::LV},
{0xb93d,Grapheme_Cluster_Break::LVT},
{0xb958,Grapheme_Cluster_Break::LV},
{0xb959,Grapheme_Cluster_Break::LVT},
{0xb974,Grapheme_Cluster_Break::LV},
{0xb975,Grapheme_Cluster_Break::LVT},
{0xb990,Grapheme_Cluster_Break::LV},
{0xb991,Grapheme_Cluster_Break::LVT},
{0xb9ac,Grapheme_Cluster_Break::LV},
{0xb9ad,Grapheme_Cluster_Break::LVT},
{0xb9c8,Grapheme_Cluster_Break::LV},
{0xb9c9,Grapheme_Cluster_Break::LVT},
{0xb9e4,Grapheme_Cluster_Break::LV},
{0xb9e5,Grapheme_Cluster_Break::LVT},
{0xba00,Grapheme_Cluster_Break::LV},
{0xba01,Grapheme_Cluster_Break::LVT},
{0xba1c,Grapheme_Cluster_Break::LV},
{0xba1d,Grapheme_Cluster_Break::LVT},
{0xba38,Grapheme_Cluster_Break::LV},
{0xba39,Grapheme_Cluster_Break::LVT},
{0xba54,Grapheme_Cluster_Break::LV},
{0xba55,Grapheme_Cluster_Break::LVT},
{0xba70,Grapheme_Cluster_Break::LV},
{0xba71,Grapheme_Cluster_Break::LVT},
{0xba8c,Grapheme_Cluster_Break::LV},
{0xba8d,Grapheme_Cluster_Break::LVT},
{0xbaa8,Grapheme_Cluster_Break::LV},
{0xbaa9,Grapheme_Cluster_Break::LVT},
{0xbac4,Grapheme_Cluster_Break::LV},
{0xbac5,Grapheme_Cluster_Break::LVT},
{0xbae0,Grapheme_Cluster_Break::LV},
{0xbae1,Grapheme_Cluster_Break::LVT},
{0xbafc,Grapheme_Cluster_Break::LV},
{0xbafd,Grapheme_Cluster_Break::LVT},
{0xbb18,Grapheme_Cluster_Break::LV},
{0xbb19,Grapheme_Cluster_Break::LVT},
{0xbb34,Grapheme_Cluster_Break::LV},
{0xbb35,Grapheme_Cluster_Break::LVT},
{0xbb50,Grapheme_Cluster_Break::LV},
{0xbb51,Grapheme_Cluster_Break::LVT},
{0xbb6c,Grapheme_Cluster_Break::LV},
{0xbb6d,Grapheme_Cluster_Break::LVT},
{0xbb88,Grapheme_Cluster_Break::LV},
{0xbb89,Grapheme_Cluster_Break::LVT},
{0xbba4,Grapheme_Cluster_Break::LV},
{0xbba5,Grapheme_Cluster_Break::LVT},
{0xbbc0,Grapheme_Cluster_Break::LV},
{0xbbc1,Grapheme_Cluster_Break::LVT},
{0xbbdc,Grapheme_Cluster_Break::LV},
{0xbbdd,Grapheme_Cluster_Break::LVT},
{0xbbf8,Grapheme_Cluster_Break::LV},
{0xbbf9,Grapheme_Cluster_Break::LVT},
{0xbc14,Grapheme_Cluster_Break::LV},
{0xbc15,Grapheme_Cluster_Break::LVT},
{0xbc30,Grapheme_Cluster_Break::LV},
{0xbc31,Grapheme_Cluster_Break::LVT},
{0xbc4c,Grapheme_Cluster_Break::LV},
{0xbc4d,Grapheme_Cluster_Break::LVT},
{0xbc68,Grapheme_Cluster_Break::LV},
{0xbc69,Grapheme_Cluster_Break::LVT},
{0xbc84,Grapheme_Cluster_Break::LV},
{0xbc85,Grapheme_Cluster_Break::LVT},
{0xbca0,Grapheme_Cluster_Break::LV},
{0xbca1,Grapheme_Cluster_Break::LVT},
{0xbcbc,Grapheme_Cluster_Break::LV},
{0xbcbd,Grapheme_Cluster_Break::LVT},
{0xbcd8,Grapheme_Cluster_Break::LV},
{0xbcd9,Grapheme_Cluster_Break::LVT},
{0xbcf4,Grapheme_Cluster_Break::LV},
{0xbcf5,Grapheme_Cluster_Break::LVT},
{0xbd10,Grapheme_Cluster_Break::LV},
{0xbd11,Grapheme_Cluster_Break::LVT},
{0xbd2c,Grapheme_Cluster_Break::LV},
{0xbd2d,Grapheme_Cluster_Break::LVT},
{0xbd48,Grapheme_Cluster_Break::LV},
{0xbd49,Grapheme_Cluster_Break::LVT},
{0xbd64,Grapheme_Cluster_Break::LV},
{0xbd65,Grapheme_Cluster_Break::LVT},
{0xbd80,Grapheme_Cluster_Break::LV},
{0xbd81,Grapheme_Cluster_Break::LVT},
{0xbd9c,Grapheme_Cluster_Break::LV},
{0xbd9d,Grapheme_Cluster_Break::LVT},
{0xbdb8,Grapheme_Cluster_Break::LV},
{0xbdb9,Grapheme_Cluster_Break::LVT},
{0xbdd4,Grapheme_Cluster_Break::LV},
{0xbdd5,Grapheme_Cluster_Break::LVT},
{0xbdf0,Grapheme_Cluster_Break::LV},
{0xbdf1,Grapheme_Cluster_Break::LVT},
{0xbe0c,Grapheme_Cluster_Break::LV},
{0xbe0d,Grapheme_Cluster_Break::LVT},
{0xbe28,Grapheme_Cluster_Break::LV},
{0xbe29,Grapheme_Cluster_Break::LVT},
{0xbe44,Grapheme_Cluster_Break::LV},
{0xbe45,Grapheme_Cluster_Break::LVT},
{0xbe60,Grapheme_Cluster_Break::LV},
{0xbe61,Grapheme_Cluster_Break::LVT},
{0xbe7c,Grapheme_Cluster_Break::LV},
{0xbe7d,Grapheme_Cluster_Break::LVT},
{0xbe98,Grapheme_Cluster_Break::LV},
{0xbe99,Grapheme_Cluster_Break::LVT},
{0xbeb4,Grapheme_Cluster_Break::LV},
{0xbeb5,Grapheme_Cluster_Break::LVT},
{0xbed0,Grapheme_Cluster_Break::LV},
{0xbed1,Grapheme_Cluster_Break::LVT},
{0xbeec,Grapheme_Cluster_Break::LV},
{0xbeed,Grapheme_Cluster_Break::LVT},
{0xbf08,Grapheme_Cluster_Break::LV},
{0xbf09,Grapheme_Cluster_Break::LVT},
{0xbf24,Grapheme_Cluster_Break::LV},
{0xbf25,Grapheme_Cluster_Break::LVT},
{0xbf40,Grapheme_Cluster_Break::LV},
{0xbf41,Grapheme_Cluster_Break::LVT},
{0xbf5c,Grapheme_Cluster_Break::LV},
{0xbf5d,Grapheme_Cluster_Break::LVT},
{0xbf78,Grapheme_Cluster_Break::LV},
{0xbf79,Grapheme_Cluster_Break::LVT},
{0xbf94,Grapheme_Cluster_Break::LV},
{0xbf95,Grapheme_Cluster_Break::LVT},
{0xbfb0,Grapheme_Cluster_Break::LV},
{0xbfb1,Grapheme_Cluster_Break::LVT},
{0xbfcc,Grapheme_Cluster_Break::LV},
{0xbfcd,Grapheme_Cluster_Break::LVT},
{0xbfe8,Grapheme_Cluster_Break::LV},
{0xbfe9,Grapheme_Cluster_Break::LVT},
{0xc004,Grapheme_Cluster_Break::LV},
{0xc005,Grapheme_Cluster_Break::LVT},
{0xc020,Grapheme_Cluster_Break::LV},
{0xc021,Grapheme_Cluster_Break::LVT},
{0xc03c,Grapheme_Cluster_Break::LV},
{0xc03d,Grapheme_Cluster_Break::LVT},
{0xc058,Grapheme_Cluster_Break::LV},
{0xc059,Grapheme_Cluster_Break::LVT},
{0xc074,Grapheme_Cluster_Break::LV},
{0xc075,Grapheme_Cluster_Break::LVT},
{0xc090,Grapheme_Cluster_Break::LV},
{0xc091,Grapheme_Cluster_Break::LVT},
{0xc0ac,Grapheme_Cluster_Break::LV},
{0xc0ad,Grapheme_Cluster_Break::LVT},
{0xc0c8,Grapheme_Cluster_Break::LV},
{0xc0c9,Grapheme_Cluster_Break::LVT},
{0xc0e4,Grapheme_Cluster_Break::LV},
{0xc0e5,Grapheme_Cluster_Break::LVT},
{0xc100,Grapheme_Cluster_Break::LV},
{0xc101,Grapheme_Cluster_Break::LVT},
{0xc11c,Grapheme_Cluster_Break::LV},
{0xc11d,Grapheme_Cluster_Break::LVT},
{0xc138,Grapheme_Cluster_Break::LV},
{0xc139,Grapheme_Cluster_Break::LVT},
{0xc154,Grapheme_Cluster_Break::LV},
{0xc155,Grapheme_Cluster_Break::LVT},
{0xc170,Grapheme_Cluster_Break::LV},
{0xc171,Grapheme_Cluster_Break::LVT},
{0xc18c,Grapheme_Cluster_Break::LV},
{0xc18d,Grapheme_Cluster_Break::LVT},
{0xc1a8,Grapheme_Cluster_Break::LV},
{0xc1a9,Grapheme_Cluster_Break::LVT},
{0xc1c4,Grapheme_Cluster_Break::LV},
{0xc1c5,Grapheme_Cluster_Break::LVT},
{0xc1e0,Grapheme_Cluster_Break::LV},
{0xc1e1,Grapheme_Cluster_Break::LVT},
{0xc1fc,Grapheme_Cluster_Break::LV},
{0xc1fd,Grapheme_Cluster_Break::LVT},
{0xc218,Grapheme_Cluster_Break::LV},
{0xc219,Grapheme_Cluster_Break::LVT},
{0xc234,Grapheme_Cluster_Break::LV},
{0xc235,Grapheme_Cluster_Break::LVT},
{0xc250,Grapheme_Cluster_Break::LV},
{0xc251,Grapheme_Cluster_Break::LVT},
{0xc26c,Grapheme_Cluster_Break::LV},
{0xc26d,Grapheme_Cluster_Break::LVT},
{0xc288,Grapheme_Cluster_Break::LV},
{0xc289,Grapheme_Cluster_Break::LVT},
{0xc2a4,Grapheme_Cluster_Break::LV},
{0xc2a5,Grapheme_Cluster_Break::LVT},
{0xc2c0,Grapheme_Cluster_Break::LV},
{0xc2c1,Grapheme_Cluster_Break::LVT},
{0xc2dc,Grapheme_Cluster_Break::LV},
{0xc2dd,Grapheme_Cluster_Break::LVT},
{0xc2f8,Grapheme_Cluster_Break::LV},
{0xc2f9,Grapheme_Cluster_Break::LVT},
{0xc314,Grapheme_Cluster_Break::LV},
{0xc315,Grapheme_Cluster_Break::LVT},
{0xc330,Grapheme_Cluster_Break::LV},
{0xc331,Grapheme_Cluster_Break::LVT},
{0xc34c,Grapheme_Cluster_Break::LV},
{0xc34d,Grapheme_Cluster_Break::LVT},
{0xc368,Grapheme_Cluster_Break::LV},
{0xc369,Grapheme_Cluster_Break::LVT},
{0xc384,Grapheme_Cluster_Break::LV},
{0xc385,Grapheme_Cluster_Break::LVT},
{0xc3a0,Grapheme_Cluster_Break::LV},
{0xc3a1,Grapheme_Cluster_Break::LVT},
{0xc3bc,Grapheme_Cluster_Break::LV},
{0xc3bd,Grapheme_Cluster_Break::LVT},
{0xc3d8,Grapheme_Cluster_Break::LV},
{0xc3d9,Grapheme_Cluster_Break::LVT},
{0xc3f4,Grapheme_Cluster_Break::LV},
{0xc3f5,Grapheme_Cluster_Break::LVT},
{0xc410,Grapheme_Cluster_Break::LV},
{0xc411,Grapheme_Cluster_Break::LVT},
{0xc42c,Grapheme_Cluster_Break::LV},
{0xc42d,Grapheme_Cluster_Break::LVT},
{0xc448,Grapheme_Cluster_Break::LV},
{0xc449,Grapheme_Cluster_Break::LVT},
{0xc464,Grapheme_Cluster_Break::LV},
{0xc465,Grapheme_Cluster_Break::LVT},
{0xc480,Grapheme_Cluster_Break::LV},
{0xc481,Grapheme_Cluster_Break::LVT},
{0xc49c,Grapheme_Cluster_Break::LV},
{0xc49d,Grapheme_Cluster_Break::LVT},
{0xc4b8,Grapheme_Cluster_Break::LV},
{0xc4b9,Grapheme_Cluster_Break::LVT},
{0xc4d4,Grapheme_Cluster_Break::LV},
{0xc4d5,Grapheme_Cluster_Break::LVT},
{0xc4f0,Grapheme_Cluster_Break::LV},
{0xc4f1,Grapheme_Cluster_Break::LVT},
{0xc50c,Grapheme_Cluster_Break::LV},
{0xc50d,Grapheme_Cluster_Break::LVT},
{0xc528,Grapheme_Cluster_Break::LV},
{0xc529,Grapheme_Cluster_Break::LVT},
{0xc544,Grapheme_Cluster_Break::LV},
{0xc545,Grapheme_Cluster_Break::LVT},
{0xc560,Grapheme_Cluster_Break::LV},
{0xc561,Grapheme_Cluster_Break::LVT},
{0xc57c,Grapheme_Cluster_Break::LV},
{0xc57d,Grapheme_Cluster_Break::LVT},
{0xc598,Grapheme_Cluster_Break::LV},
{0xc599,Grapheme_Cluster_Break::LVT},
{0xc5b4,Grapheme_Cluster_Break::LV},
{0xc5b5,Grapheme_Cluster_Break::LVT},
{0xc5d0,Grapheme_Cluster_Break::LV},
{0xc5d1,Grapheme_Cluster_Break::LVT},
{0xc5ec,Grapheme_Cluster_Break::LV},
{0xc5ed,Grapheme_Cluster_Break::LVT},
{0xc608,Grapheme_Cluster_Break::LV},
{0xc609,Grapheme_Cluster_Break::LVT},
{0xc624,Grapheme_Cluster_Break::LV},
{0xc625,Grapheme_Cluster_Break::LVT},
{0xc640,Grapheme_Cluster_Break::LV},
{0xc641,Grapheme_Cluster_Break::LVT},
{0xc65c,Grapheme_Cluster_Break::LV},
{0xc65d,Grapheme_Cluster_Break::LVT},
{0xc678,Grapheme_Cluster_Break::LV},
{0xc679,Grapheme_Cluster_Break::LVT},
{0xc694,Grapheme_Cluster_Break::LV},
{0xc695,Grapheme_Cluster_Break::LVT},
{0xc6b0,Grapheme_Cluster_Break::LV},
{0xc6b1,Grapheme_Cluster_Break::LVT},
{0xc6cc,Grapheme_Cluster_Break::LV},
{0xc6cd,Grapheme_Cluster_Break::LVT},
{0xc6e8,Grapheme_Cluster_Break::LV},
{0xc6e9,Grapheme_Cluster_Break::LVT},
{0xc704,Grapheme_Cluster_Break::LV},
{0xc705,Grapheme_Cluster_Break::LVT},
{0xc720,Grapheme_Cluster_Break::LV},
{0xc721,Grapheme_Cluster_Break::LVT},
{0xc73c,Grapheme_Cluster_Break::LV},
{0xc73d,Grapheme_Cluster_Break::LVT},
{0xc758,Grapheme_Cluster_Break::LV},
{0xc759,Grapheme_Cluster_Break::LVT},
{0xc774,Grapheme_Cluster_Break::LV},
{0xc775,Grapheme_Cluster_Break::LVT},
{0xc790,Grapheme_Cluster_Break::LV},
{0xc791,Grapheme_Cluster_Break::LVT},
{0xc7ac,Grapheme_Cluster_Break::LV},
{0xc7ad,Grapheme_Cluster_Break::LVT},
{0xc7c8,Grapheme_Cluster_Break::LV},
{0xc7c9,Grapheme_Cluster_Break::LVT},
{0xc7e4,Grapheme_Cluster_Break::LV},
{0xc7e5,Grapheme_Cluster_Break::LVT},
{0xc800,Grapheme_Cluster_Break::LV},
{0xc801,Grapheme_Cluster_Break::LVT},
{0xc81c,Grapheme_Cluster_Break::LV},
{0xc81d,Grapheme_Cluster_Break::LVT},
{0xc838,Grapheme_Cluster_Break::LV},
{0xc839,Grapheme_Cluster_Break::LVT},
{0xc854,Grapheme_Cluster_Break::LV},
{0xc855,Grapheme_Cluster_Break::LVT},
{0xc870,Grapheme_Cluster_Break::LV},
{0xc871,Grapheme_Cluster_Break::LVT},
{0xc88c,Grapheme_Cluster_Break::LV},
{0xc88d,Grapheme_Cluster_Break::LVT},
{0xc8a8,Grapheme_Cluster_Break::LV},
{0xc8a9,Grapheme_Cluster_Break::LVT},
{0xc8c4,Grapheme_Cluster_Break::LV},
{0xc8c5,Grapheme_Cluster_Break::LVT},
{0xc8e0,Grapheme_Cluster_Break::LV},
{0xc8e1,Grapheme_Cluster_Break::LVT},
{0xc8fc,Grapheme_Cluster_Break::LV},
{0xc8fd,Grapheme_Cluster_Break::LVT},
{0xc918,Grapheme_Cluster_Break::LV},
{0xc919,Grapheme_Cluster_Break::LVT},
{0xc934,Grapheme_Cluster_Break::LV},
{0xc935,Grapheme_Cluster_Break::LVT},
{0xc950,Grapheme_Cluster_Break::LV},
{0xc951,Grapheme_Cluster_Break::LVT},
{0xc96c,Grapheme_Cluster_Break::LV},
{0xc96d,Grapheme_Cluster_Break::LVT},
{0xc988,Grapheme_Cluster_Break::LV},
{0xc989,Grapheme_Cluster_Break::LVT},
{0xc9a4,Grapheme_Cluster_Break::LV},
{0xc9a5,Grapheme_Cluster_Break::LVT},
{0xc9c0,Grapheme_Cluster_Break::LV},
{0xc9c1,Grapheme_Cluster_Break::LVT},
{0xc9dc,Grapheme_Cluster_Break::LV},
{0xc9dd,Grapheme_Cluster_Break::LVT},
{0xc9f8,Grapheme_Cluster_Break::LV},
{0xc9f9,Grapheme_Cluster_Break::LVT},
{0xca14,Grapheme_Cluster_Break::LV},
{0xca15,Grapheme_Cluster_Break::LVT},
{0xca30,Grapheme_Cluster_Break::LV},
{0xca31,Grapheme_Cluster_Break::LVT},
{0xca4c,Grapheme_Cluster_Break::LV},
{0xca4d,Grapheme_Cluster_Break::LVT},
{0xca68,Grapheme_Cluster_Break::LV},
{0xca69,Grapheme_Cluster_Break::LVT},
{0xca84,Grapheme_Cluster_Break::LV},
{0xca85,Grapheme_Cluster_Break::LVT},
{0xcaa0,Grapheme_Cluster_Break::LV},
{0xcaa1,Grapheme_Cluster_Break::LVT},
{0xcabc,Grapheme_Cluster_Break::LV},
{0xcabd,Grapheme_Cluster_Break::LVT},
{0xcad8,Grapheme_Cluster_Break::LV},
{0xcad9,Grapheme_Cluster_Break::LVT},
{0xcaf4,Grapheme_Cluster_Break::LV},
{0xcaf5,Grapheme_Cluster_Break::LVT},
{0xcb10,Grapheme_Cluster_Break::LV},
{0xcb11,Grapheme_Cluster_Break::LVT},
{0xcb2c,Grapheme_Cluster_Break::LV},
{0xcb2d,Grapheme_Cluster_Break::LVT},
{0xcb48,Grapheme_Cluster_Break::LV},
{0xcb49,Grapheme_Cluster_Break::LVT},
{0xcb64,Grapheme_Cluster_Break::LV},
{0xcb65,Grapheme_Cluster_Break::LVT},
{0xcb80,Grapheme_Cluster_Break::LV},
{0xcb81,Grapheme_Cluster_Break::LVT},
{0xcb9c,Grapheme_Cluster_Break::LV},
{0xcb9d,Grapheme_Cluster_Break::LVT},
{0xcbb8,Grapheme_Cluster_Break::LV},
{0xcbb9,Grapheme_Cluster_Break::LVT},
{0xcbd4,Grapheme_Cluster_Break::LV},
{0xcbd5,Grapheme_Cluster_Break::LVT},
{0xcbf0,Grapheme_Cluster_Break::LV},
{0xcbf1,Grapheme_Cluster_Break::LVT},
{0xcc0c,Grapheme_Cluster_Break::LV},
{0xcc0d,Grapheme_Cluster_Break::LVT},
{0xcc28,Grapheme_Cluster_Break::LV},
{0xcc29,Grapheme_Cluster_Break::LVT},
{0xcc44,Grapheme_Cluster_Break::LV},
{0xcc45,Grapheme_Cluster_Break::LVT},
{0xcc60,Grapheme_Cluster_Break::LV},
{0xcc61,Grapheme_Cluster_Break::LVT},
{0xcc7c,Grapheme_Cluster_Break::LV},
{0xcc7d,Grapheme_Cluster_Break::LVT},
{0xcc98,Grapheme_Cluster_Break::LV},
{0xcc99,Grapheme_Cluster_Break::LVT},
{0xccb4,Grapheme_Cluster_Break::LV},
{0xccb5,Grapheme_Cluster_Break::LVT},
{0xccd0,Grapheme_Cluster_Break::LV},
{0xccd1,Grapheme_Cluster_Break::LVT},
{0xccec,Grapheme_Cluster_Break::LV},
{0xcced,Grapheme_Cluster_Break::LVT},
{0xcd08,Grapheme_Cluster_Break::LV},
{0xcd09,Grapheme_Cluster_Break::LVT},
{0xcd24,Grapheme_Cluster_Break::LV},
{0xcd25,Grapheme_Cluster_Break::LVT},
{0xcd40,Grapheme_Cluster_Break::LV},
{0xcd41,Grapheme_Cluster_Break::LVT},
{0xcd5c,Grapheme_Cluster_Break::LV},
{0xcd5d,Grapheme_Cluster_Break::LVT},
{0xcd78,Grapheme_Cluster_Break::LV},
{0xcd79,Grapheme_Cluster_Break::LVT},
{0xcd94,Grapheme_Cluster_Break::LV},
{0xcd95,Grapheme_Cluster_Break::LVT},
{0xcdb0,Grapheme_Cluster_Break::LV},
{0xcdb1,Grapheme_Cluster_Break::LVT},
{0xcdcc,Grapheme_Cluster_Break::LV},
{0xcdcd,Grapheme_Cluster_Break::LVT},
{0xcde8,Grapheme_Cluster_Break::LV},
{0xcde9,Grapheme_Cluster_Break::LVT},
{0xce04,Grapheme_Cluster_Break::LV},
{0xce05,Grapheme_Cluster_Break::LVT},
{0xce20,Grapheme_Cluster_Break::LV},
{0xce21,Grapheme_Cluster_Break::LVT},
{0xce3c,Grapheme_Cluster_Break::LV},
{0xce3d,Grapheme_Cluster_Break::LVT},
{0xce58,Grapheme_Cluster_Break::LV},
{0xce59,Grapheme_Cluster_Break::LVT},
{0xce74,Grapheme_Cluster_Break::LV},
{0xce75,Grapheme_Cluster_Break::LVT},
{0xce90,Grapheme_Cluster_Break::LV},
{0xce91,Grapheme_Cluster_Break::LVT},
{0xceac,Grapheme_Cluster_Break::LV},
{0xcead,Grapheme_Cluster_Break::LVT},
{0xcec8,Grapheme_Cluster_Break::LV},
{0xcec9,Grapheme_Cluster_Break::LVT},
{0xcee4,Grapheme_Cluster_Break::LV},
{0xcee5,Grapheme_Cluster_Break::LVT},
{0xcf00,Grapheme_Cluster_Break::LV},
{0xcf01,Grapheme_Cluster_Break::LVT},
{0xcf1c,Grapheme_Cluster_Break::LV},
{0xcf1d,Grapheme_Cluster_Break::LVT},
{0xcf38,Grapheme_Cluster_Break::LV},
{0xcf39,Grapheme_Cluster_Break::LVT},
{0xcf54,Grapheme_Cluster_Break::LV},
{0xcf55,Grapheme_Cluster_Break::LVT},
{0xcf70,Grapheme_Cluster_Break::LV},
{0xcf71,Grapheme_Cluster_Break::LVT},
{0xcf8c,Grapheme_Cluster_Break::LV},
{0xcf8d,Grapheme_Cluster_Break::LVT},
{0xcfa8,Grapheme_Cluster_Break::LV},
{0xcfa9,Grapheme_Cluster_Break::LVT},
{0xcfc4,Grapheme_Cluster_Break::LV},
{0xcfc5,Grapheme_Cluster_Break::LVT},
{0xcfe0,Grapheme_Cluster_Break::LV},
{0xcfe1,Grapheme_Cluster_Break::LVT},
{0xcffc,Grapheme_Cluster_Break::LV},
{0xcffd,Grapheme_Cluster_Break::LVT},
{0xd018,Grapheme_Cluster_Break::LV},
{0xd019,Grapheme_Cluster_Break::LVT},
{0xd034,Grapheme_Cluster_Break::LV},
{0xd035,Grapheme_Cluster_Break::LVT},
{0xd050,Grapheme_Cluster_Break::LV},
{0xd051,Grapheme_Cluster_Break::LVT},
{0xd06c,Grapheme_Cluster_Break::LV},
{0xd06d,Grapheme_Cluster_Break::LVT},
{0xd088,Grapheme_Cluster_Break::LV},
{0xd089,Grapheme_Cluster_Break::LVT},
{0xd0a4,Grapheme_Cluster_Break::LV},
{0xd0a5,Grapheme_Cluster_Break::LVT},
{0xd0c0,Grapheme_Cluster_Break::LV},
{0xd0c1,Grapheme_Cluster_Break::LVT},
{0xd0dc,Grapheme_Cluster_Break::LV},
{0xd0dd,Grapheme_Cluster_Break::LVT},
{0xd0f8,Grapheme_Cluster_Break::LV},
{0xd0f9,Grapheme_Cluster_Break::LVT},
{0xd114,Grapheme_Cluster_Break::LV},
{0xd115,Grapheme_Cluster_Break::LVT},
{0xd130,Grapheme_Cluster_Break::LV},
{0xd131,Grapheme_Cluster_Break::LVT},
{0xd14c,Grapheme_Cluster_Break::LV},
{0xd14d,Grapheme_Cluster_Break::LVT},
{0xd168,Grapheme_Cluster_Break::LV},
{0xd169,Grapheme_Cluster_Break::LVT},
{0xd184,Grapheme_Cluster_Break::LV},
{0xd185,Grapheme_Cluster_Break::LVT},
{0xd1a0,Grapheme_Cluster_Break::LV},
{0xd1a1,Grapheme_Cluster_Break::LVT},
{0xd1bc,Grapheme_Cluster_Break::LV},
{0xd1bd,Grapheme_Cluster_Break::LVT},
{0xd1d8,Grapheme_Cluster_Break::LV},
{0xd1d9,Grapheme_Cluster_Break::LVT},
{0xd1f4,Grapheme_Cluster_Break::LV},
{0xd1f5,Grapheme_Cluster_Break::LVT},
{0xd210,Grapheme_Cluster_Break::LV},
{0xd211,Grapheme_Cluster_Break::LVT},
{0xd22c,Grapheme_Cluster_Break::LV},
{0xd22d,Grapheme_Cluster_Break::LVT},
{0xd248,Grapheme_Cluster_Break::LV},
{0xd249,Grapheme_Cluster_Break::LVT},
{0xd264,Grapheme_Cluster_Break::LV},
{0xd265,Grapheme_Cluster_Break::LVT},
{0xd280,Grapheme_Cluster_Break::LV},
{0xd281,Grapheme_Cluster_Break::LVT},
{0xd29c,Grapheme_Cluster_Break::LV},
{0xd29d,Grapheme_Cluster_Break::LVT},
{0xd2b8,Grapheme_Cluster_Break::LV},
{0xd2b9,Grapheme_Cluster_Break::LVT},
{0xd2d4,Grapheme_Cluster_Break::LV},
{0xd2d5,Grapheme_Cluster_Break::LVT},
{0xd2f0,Grapheme_Cluster_Break::LV},
{0xd2f1,Grapheme_Cluster_Break::LVT},
{0xd30c,Grapheme_Cluster_Break::LV},
{0xd30d,Grapheme_Cluster_Break::LVT},
{0xd328,Grapheme_Cluster_Break::LV},
{0xd329,Grapheme_Cluster_Break::LVT},
{0xd344,Grapheme_Cluster_Break::LV},
{0xd345,Grapheme_Cluster_Break::LVT},
{0xd360,Grapheme_Cluster_Break::LV},
{0xd361,Grapheme_Cluster_Break::LVT},
{0xd37c,Grapheme_Cluster_Break::LV},
{0xd37d,Grapheme_Cluster_Break::LVT},
{0xd398,Grapheme_Cluster_Break::LV},
{0xd399,Grapheme_Cluster_Break::LVT},
{0xd3b4,Grapheme_Cluster_Break::LV},
{0xd3b5,Grapheme_Cluster_Break::LVT},
{0xd3d0,Grapheme_Cluster_Break::LV},
{0xd3d1,Grapheme_Cluster_Break::LVT},
{0xd3ec,Grapheme_Cluster_Break::LV},
{0xd3ed,Grapheme_Cluster_Break::LVT},
{0xd408,Grapheme_Cluster_Break::LV},
{0xd409,Grapheme_Cluster_Break::LVT},
{0xd424,Grapheme_Cluster_Break::LV},
{0xd425,Grapheme_Cluster_Break::LVT},
{0xd440,Grapheme_Cluster_Break::LV},
{0xd441,Grapheme_Cluster_Break::LVT},
{0xd45c,Grapheme_Cluster_Break::LV},
{0xd45d,Grapheme_Cluster_Break::LVT},
{0xd478,Grapheme_Cluster_Break::LV},
{0xd479,Grapheme_Cluster_Break::LVT},
{0xd494,Grapheme_Cluster_Break::LV},
{0xd495,Grapheme_Cluster_Break::LVT},
{0xd4b0,Grapheme_Cluster_Break::LV},
{0xd4b1,Grapheme_Cluster_Break::LVT},
{0xd4cc,Grapheme_Cluster_Break::LV},
{0xd4cd,Grapheme_Cluster_Break::LVT},
{0xd4e8,Grapheme_Cluster_Break::LV},
{0xd4e9,Grapheme_Cluster_Break::LVT},
{0xd504,Grapheme_Cluster_Break::LV},
{0xd505,Grapheme_Cluster_Break::LVT},
{0xd520,Grapheme_Cluster_Break::LV},
{0xd521,Grapheme_Cluster_Break::LVT},
{0xd53c,Grapheme_Cluster_Break::LV},
{0xd53d,Grapheme_Cluster_Break::LVT},
{0xd558,Grapheme_Cluster_Break::LV},
{0xd559,Grapheme_Cluster_Break::LVT},
{0xd574,Grapheme_Cluster_Break::LV},
{0xd575,Grapheme_Cluster_Break::LVT},
{0xd590,Grapheme_Cluster_Break::LV},
{0xd591,Grapheme_Cluster_Break::LVT},
{0xd5ac,Grapheme_Cluster_Break::LV},
{0xd5ad,Grapheme_Cluster_Break::LVT},
{0xd5c8,Grapheme_Cluster_Break::LV},
{0xd5c9,Grapheme_Cluster_Break::LVT},
{0xd5e4,Grapheme_Cluster_Break::LV},
{0xd5e5,Grapheme_Cluster_Break::LVT},
{0xd600,Grapheme_Cluster_Break::LV},
{0xd601,Grapheme_Cluster_Break::LVT},
{0xd61c,Grapheme_Cluster_Break::LV},
{0xd61d,Grapheme_Cluster_Break::LVT},
{0xd638,Grapheme_Cluster_Break::LV},
{0xd639,Grapheme_Cluster_Break::LVT},
{0xd654,Grapheme_Cluster_Break::LV},
{0xd655,Grapheme_Cluster_Break::LVT},
{0xd670,Grapheme_Cluster_Break::LV},
{0xd671,Grapheme_Cluster_Break::LVT},
{0xd68c,Grapheme_Cluster_Break::LV},
{0xd68d,Grapheme_Cluster_Break::LVT},
{0xd6a8,Grapheme_Cluster_Break::LV},
{0xd6a9,Grapheme_Cluster_Break::LVT},
{0xd6c4,Grapheme_Cluster_Break::LV},
{0xd6c5,Grapheme_Cluster_Break::LVT},
{0xd6e0,Grapheme_Cluster_Break::LV},
{0xd6e1,Grapheme_Cluster_Break::LVT},
{0xd6fc,Grapheme_Cluster_Break::LV},
{0xd6fd,Grapheme_Cluster_Break::LVT},
{0xd718,Grapheme_Cluster_Break::LV},
{0xd719,Grapheme_Cluster_Break::LVT},
{0xd734,Grapheme_Cluster_Break::LV},
{0xd735,Grapheme_Cluster_Break::LVT},
{0xd750,Grapheme_Cluster_Break::LV},
{0xd751,Grapheme_Cluster_Break::LVT},
{0xd76c,Grapheme_Cluster_Break::LV},
{0xd76d,Grapheme_Cluster_Break::LVT},
{0xd788,Grapheme_Cluster_Break::LV},
{0xd789,Grapheme_Cluster_Break::LVT},
{0xd7a4,static_cast<Grapheme_Cluster_Break>(0)},
{0xd7b0,Grapheme_Cluster_Break::V},
{0xd7c7,static_cast<Grapheme_Cluster_Break>(0)},
{0xd7cb,Grapheme_Cluster_Break::T},
{0xd7fc,static_cast<Grapheme_Cluster_Break>(0)},
{0xd800,Grapheme_Cluster_Break::Control},
{0xe000,static_cast<Grapheme_Cluster_Break>(0)},
{0xfb1e,Grapheme_Cluster_Break::Extend},
{0xfb1f,static_cast<Grapheme_Cluster_Break>(0)},
{0xfe00,Grapheme_Cluster_Break::Extend},
{0xfe10,static_cast<Grapheme_Cluster_Break>(0)},
{0xfe20,Grapheme_Cluster_Break::Extend},
{0xfe30,static_cast<Grapheme_Cluster_Break>(0)},
{0xfeff,Grapheme_Cluster_Break::Control},
{0xff00,static_cast<Grapheme_Cluster_Break>(0)},
{0xff9e,Grapheme_Cluster_Break::Extend},
{0xffa0,static_cast<Grapheme_Cluster_Break>(0)},
{0xfff0,Grapheme_Cluster_Break::Control},
{0xfffc,static_cast<Grapheme_Cluster_Break>(0)},
{0x101fd,Grapheme_Cluster_Break::Extend},
{0x101fe,static_cast<Grapheme_Cluster_Break>(0)},
{0x102e0,Grapheme_Cluster_Break::Extend},
{0x102e1,static_cast<Grapheme_Cluster_Break>(0)},
{0x10376,Grapheme_Cluster_Break::Extend},
{0x1037b,static_cast<Grapheme_Cluster_Break>(0)},
{0x10a01,Grapheme_Cluster_Break::Extend},
{0x10a04,static_cast<Grapheme_Cluster_Break>(0)},
{0x10a05,Grapheme_Cluster_Break::Extend},
{0x10a07,static_cast<Grapheme_Cluster_Break>(0)},
{0x10a0c,Grapheme_Cluster_Break::Extend},
{0x10a10,static_cast<Grapheme_Cluster_Break>(0)},
{0x10a38,Grapheme_Cluster_Break::Extend},
{0x10a3b,static_cast<Grapheme_Cluster_Break>(0)},
{0x10a3f,Grapheme_Cluster_Break::Extend},
{0x10a40,static_cast<Grapheme_Cluster_Break>(0)},
{0x10ae5,Grapheme_Cluster_Break::Extend},
{0x10ae7,static_cast<Grapheme_Cluster_Break>(0)},
{0x11000,Grapheme_Cluster_Break::SpacingMark},
{0x11001,Grapheme_Cluster_Break::Extend},
{0x11002,Grapheme_Cluster_Break::SpacingMark},
{0x11003,static_cast<Grapheme_Cluster_Break>(0)},
{0x11038,Grapheme_Cluster_Break::Extend},
{0x11047,static_cast<Grapheme_Cluster_Break>(0)},
{0x1107f,Grapheme_Cluster_Break::Extend},
{0x11082,Grapheme_Cluster_Break::SpacingMark},
{0x11083,static_cast<Grapheme_Cluster_Break>(0)},
{0x110b0,Grapheme_Cluster_Break::SpacingMark},
{0x110b3,Grapheme_Cluster_Break::Extend},
{0x110b7,Grapheme_Cluster_Break::SpacingMark},
{0x110b9,Grapheme_Cluster_Break::Extend},
{0x110bb,static_cast<Grapheme_Cluster_Break>(0)},
{0x110bd,Grapheme_Cluster_Break::Control},
{0x110be,static_cast<Grapheme_Cluster_Break>(0)},
{0x11100,Grapheme_Cluster_Break::Extend},
{0x11103,static_cast<Grapheme_Cluster_Break>(0)},
{0x11127,Grapheme_Cluster_Break::Extend},
{0x1112c,Grapheme_Cluster_Break::SpacingMark},
{0x1112d,Grapheme_Cluster_Break::Extend},
{0x11135,static_cast<Grapheme_Cluster_Break>(0)},
{0x11173,Grapheme_Cluster_Break::Extend},
{0x11174,static_cast<Grapheme_Cluster_Break>(0)},
{0x11180,Grapheme_Cluster_Break::Extend},
{0x11182,Grapheme_Cluster_Break::SpacingMark},
{0x11183,static_cast<Grapheme_Cluster_Break>(0)},
{0x111b3,Grapheme_Cluster_Break::SpacingMark},
{0x111b6,Grapheme_Cluster_Break::Extend},
{0x111bf,Grapheme_Cluster_Break::SpacingMark},
{0x111c1,static_cast<Grapheme_Cluster_Break>(0)},
{0x111ca,Grapheme_Cluster_Break::Extend},
{0x111cd,static_cast<Grapheme_Cluster_Break>(0)},
{0x1122c,Grapheme_Cluster_Break::SpacingMark},
{0x1122f,Grapheme_Cluster_Break::Extend},
{0x11232,Grapheme_Cluster_Break::SpacingMark},
{0x11234,Grapheme_Cluster_Break::Extend},
{0x11235,Grapheme_Cluster_Break::SpacingMark},
{0x11236,Grapheme_Cluster_Break::Extend},
{0x11238,static_cast<Grapheme_Cluster_Break>(0)},
{0x112df,Grapheme_Cluster_Break::Extend},
{0x112e0,Grapheme_Cluster_Break::SpacingMark},
{0x112e3,Grapheme_Cluster_Break::Extend},
{0x112eb,static_cast<Grapheme_Cluster_Break>(0)},
{0x11300,Grapheme_Cluster_Break::Extend},
{0x11302,Grapheme_Cluster_Break::SpacingMark},
{0x11304,static_cast<Grapheme_Cluster_Break>(0)},
{0x1133c,Grapheme_Cluster_Break::Extend},
{0x1133d,static_cast<Grapheme_Cluster_Break>(0)},
{0x1133e,Grapheme_Cluster_Break::Extend},
{0x1133f,Grapheme_Cluster_Break::SpacingMark},
{0x11340,Grapheme_Cluster_Break::Extend},
{0x11341,Grapheme_Cluster_Break::SpacingMark},
{0x11345,static_cast<Grapheme_Cluster_Break>(0)},
{0x11347,Grapheme_Cluster_Break::SpacingMark},
{0x11349,static_cast<Grapheme_Cluster_Break>(0)},
{0x1134b,Grapheme_Cluster_Break::SpacingMark},
{0x1134e,static_cast<Grapheme_Cluster_Break>(0)},
{0x11357,Grapheme_Cluster_Break::Extend},
{0x11358,static_cast<Grapheme_Cluster_Break>(0)},
{0x11362,Grapheme_Cluster_Break::SpacingMark},
{0x11364,static_cast<Grapheme_Cluster_Break>(0)},
{0x11366,Grapheme_Cluster_Break::Extend},
{0x1136d,static_cast<Grapheme_Cluster_Break>(0)},
{0x11370,Grapheme_Cluster_Break::Extend},
{0x11375,static_cast<Grapheme_Cluster_Break>(0)},
{0x114b0,Grapheme_Cluster_Break::Extend},
{0x114b1,Grapheme_Cluster_Break::SpacingMark},
{0x114b3,Grapheme_Cluster_Break::Extend},
{0x114b9,Grapheme_Cluster_Break::SpacingMark},
{0x114ba,Grapheme_Cluster_Break::Extend},
{0x114bb,Grapheme_Cluster_Break::SpacingMark},
{0x114bd,Grapheme_Cluster_Break::Extend},
{0x114be,Grapheme_Cluster_Break::SpacingMark},
{0x114bf,Grapheme_Cluster_Break::Extend},
{0x114c1,Grapheme_Cluster_Break::SpacingMark},
{0x114c2,Grapheme_Cluster_Break::Extend},
{0x114c4,static_cast<Grapheme_Cluster_Break>(0)},
{0x115af,Grapheme_Cluster_Break::Extend},
{0x115b0,Grapheme_Cluster_Break::SpacingMark},
{0x115b2,Grapheme_Cluster_Break::Extend},
{0x115b6,static_cast<Grapheme_Cluster_Break>(0)},
{0x115b8,Grapheme_Cluster_Break::SpacingMark},
{0x115bc,Grapheme_Cluster_Break::Extend},
{0x115be,Grapheme_Cluster_Break::SpacingMark},
{0x115bf,Grapheme_Cluster_Break::Extend},
{0x115c1,static_cast<Grapheme_Cluster_Break>(0)},
{0x115dc,Grapheme_Cluster_Break::Extend},
{0x115de,static_cast<Grapheme_Cluster_Break>(0)},
{0x11630,Grapheme_Cluster_Break::SpacingMark},
{0x11633,Grapheme_Cluster_Break::Extend},
{0x1163b,Grapheme_Cluster_Break::SpacingMark},
{0x1163d,Grapheme_Cluster_Break::Extend},
{0x1163e,Grapheme_Cluster_Break::SpacingMark},
{0x1163f,Grapheme_Cluster_Break::Extend},
{0x11641,static_cast<Grapheme_Cluster_Break>(0)},
{0x116ab,Grapheme_Cluster_Break::Extend},
{0x116ac,Grapheme_Cluster_Break::SpacingMark},
{0x116ad,Grapheme_Cluster_Break::Extend},
{0x116ae,Grapheme_Cluster_Break::SpacingMark},
{0x116b0,Grapheme_Cluster_Break::Extend},
{0x116b6,Grapheme_Cluster_Break::SpacingMark},
{0x116b7,Grapheme_Cluster_Break::Extend},
{0x116b8,static_cast<Grapheme_Cluster_Break>(0)},
{0x1171d,Grapheme_Cluster_Break::Extend},
{0x11720,Grapheme_Cluster_Break::SpacingMark},
{0x11722,Grapheme_Cluster_Break::Extend},
{0x11726,Grapheme_Cluster_Break::SpacingMark},
{0x11727,Grapheme_Cluster_Break::Extend},
{0x1172c,static_cast<Grapheme_Cluster_Break>(0)},
{0x16af0,Grapheme_Cluster_Break::Extend},
{0x16af5,static_cast<Grapheme_Cluster_Break>(0)},
{0x16b30,Grapheme_Cluster_Break::Extend},
{0x16b37,static_cast<Grapheme_Cluster_Break>(0)},
{0x16f51,Grapheme_Cluster_Break::SpacingMark},
{0x16f7f,static_cast<Grapheme_Cluster_Break>(0)},
{0x16f8f,Grapheme_Cluster_Break::Extend},
{0x16f93,static_cast<Grapheme_Cluster_Break>(0)},
{0x1bc9d,Grapheme_Cluster_Break::Extend},
{0x1bc9f,static_cast<Grapheme_Cluster_Break>(0)},
{0x1bca0,Grapheme_Cluster_Break::Control},
{0x1bca4,static_cast<Grapheme_Cluster_Break>(0)},
{0x1d165,Grapheme_Cluster_Break::Extend},
{0x1d166,Grapheme_Cluster_Break::SpacingMark},
{0x1d167,Grapheme_Cluster_Break::Extend},
{0x1d16a,static_cast<Grapheme_Cluster_Break>(0)},
{0x1d16d,Grapheme_Cluster_Break::SpacingMark},
{0x1d16e,Grapheme_Cluster_Break::Extend},
{0x1d173,Grapheme_Cluster_Break::Control},
{0x1d17b,Grapheme_Cluster_Break::Extend},
{0x1d183,static_cast<Grapheme_Cluster_Break>(0)},
{0x1d185,Grapheme_Cluster_Break::Extend},
{0x1d18c,static_cast<Grapheme_Cluster_Break>(0)},
{0x1d1aa,Grapheme_Cluster_Break::Extend},
{0x1d1ae,static_cast<Grapheme_Cluster_Break>(0)},
{0x1d242,Grapheme_Cluster_Break::Extend},
{0x1d245,static_cast<Grapheme_Cluster_Break>(0)},
{0x1da00,Grapheme_Cluster_Break::Extend},
{0x1da37,static_cast<Grapheme_Cluster_Break>(0)},
{0x1da3b,Grapheme_Cluster_Break::Extend},
{0x1da6d,static_cast<Grapheme_Cluster_Break>(0)},
{0x1da75,Grapheme_Cluster_Break::Extend},
{0x1da76,static_cast<Grapheme_Cluster_Break>(0)},
{0x1da84,Grapheme_Cluster_Break::Extend},
{0x1da85,static_cast<Grapheme_Cluster_Break>(0)},
{0x1da9b,Grapheme_Cluster_Break::Extend},
{0x1daa0,static_cast<Grapheme_Cluster_Break>(0)},
{0x1daa1,Grapheme_Cluster_Break::Extend},
{0x1dab0,static_cast<Grapheme_Cluster_Break>(0)},
{0x1e8d0,Grapheme_Cluster_Break::Extend},
{0x1e8d7,static_cast<Grapheme_Cluster_Break>(0)},
{0x1f1e6,Grapheme_Cluster_Break::Regional_Indicator},
{0x1f200,static_cast<Grapheme_Cluster_Break>(0)},
{0xe0000,Grapheme_Cluster_Break::Control},
{0xe0100,Grapheme_Cluster_Break::Extend},
{0xe01f0,Grapheme_Cluster_Break::Control},
{0xe1000,static_cast<Grapheme_Cluster_Break>(0)},
}};

const TableView<char32_t, Grapheme_Cluster_Break> grapheme_cluster_break_table {&grapheme_cluster_break_array[0], &grapheme_cluster_break_array[0] + grapheme_cluster_break_array.size()};

const std::array<KeyValue<char32_t, Line_Break>, 3096> line_break_array = {{
{0x0,Line_Break::CM},
{0x9,Line_Break::BA},
{0xa,Line_Break::LF},
{0xb,Line_Break::BK},
{0xd,Line_Break::CR},
{0xe,Line_Break::CM},
{0x20,Line_Break::SP},
{0x21,Line_Break::EX},
{0x22,Line_Break::QU},
{0x23,Line_Break::AL},
{0x24,Line_Break::PR},
{0x25,Line_Break::PO},
{0x26,Line_Break::AL},
{0x27,Line_Break::QU},
{0x28,Line_Break::OP},
{0x29,Line_Break::CP},
{0x2a,Line_Break::AL},
{0x2b,Line_Break::PR},
{0x2c,Line_Break::IS},
{0x2d,Line_Break::HY},
{0x2e,Line_Break::IS},
{0x2f,Line_Break::SY},
{0x30,Line_Break::NU},
{0x3a,Line_Break::IS},
{0x3c,Line_Break::AL},
{0x3f,Line_Break::EX},
{0x40,Line_Break::AL},
{0x5b,Line_Break::OP},
{0x5c,Line_Break::PR},
{0x5d,Line_Break::CP},
{0x5e,Line_Break::AL},
{0x7b,Line_Break::OP},
{0x7c,Line_Break::BA},
{0x7d,Line_Break::CL},
{0x7e,Line_Break::AL},
{0x7f,Line_Break::CM},
{0x85,Line_Break::NL},
{0x86,Line_Break::CM},
{0xa0,Line_Break::GL},
{0xa1,Line_Break::OP},
{0xa2,Line_Break::PO},
{0xa3,Line_Break::PR},
{0xa6,Line_Break::AL},
{0xa7,Line_Break::AI},
{0xa9,Line_Break::AL},
{0xaa,Line_Break::AI},
{0xab,Line_Break::QU},
{0xac,Line_Break::AL},
{0xad,Line_Break::BA},
{0xae,Line_Break::AL},
{0xb0,Line_Break::PO},
{0xb1,Line_Break::PR},
{0xb2,Line_Break::AI},
{0xb4,Line_Break::BB},
{0xb5,Line_Break::AL},
{0xb6,Line_Break::AI},
{0xbb,Line_Break::QU},
{0xbc,Line_Break::AI},
{0xbf,Line_Break::OP},
{0xc0,Line_Break::AL},
{0xd7,Line_Break::AI},
{0xd8,Line_Break::AL},
{0xf7,Line_Break::AI},
{0xf8,Line_Break::AL},
{0x2c7,Line_Break::AI},
{0x2c8,Line_Break::BB},
{0x2c9,Line_Break::AI},
{0x2cc,Line_Break::BB},
{0x2cd,Line_Break::AI},
{0x2ce,Line_Break::AL},
{0x2d0,Line_Break::AI},
{0x2d1,Line_Break::AL},
{0x2d8,Line_Break::AI},
{0x2dc,Line_Break::AL},
{0x2dd,Line_Break::AI},
{0x2de,Line_Break::AL},
{0x2df,Line_Break::BB},
{0x2e0,Line_Break::AL},
{0x300,Line_Break::CM},
{0x34f,Line_Break::GL},
{0x350,Line_Break::CM},
{0x35c,Line_Break::GL},
{0x363,Line_Break::CM},
{0x370,Line_Break::AL},
{0x378,static_cast<Line_Break>(0)},
{0x37a,Line_Break::AL},
{0x37e,Line_Break::IS},
{0x37f,Line_Break::AL},
{0x380,static_cast<Line_Break>(0)},
{0x384,Line_Break::AL},
{0x38b,static_cast<Line_Break>(0)},
{0x38c,Line_Break::AL},
{0x38d,static_cast<Line_Break>(0)},
{0x38e,Line_Break::AL},
{0x3a2,static_cast<Line_Break>(0)},
{0x3a3,Line_Break::AL},
{0x483,Line_Break::CM},
{0x48a,Line_Break::AL},
{0x530,static_cast<Line_Break>(0)},
{0x531,Line_Break::AL},
{0x557,static_cast<Line_Break>(0)},
{0x559,Line_Break::AL},
{0x560,static_cast<Line_Break>(0)},
{0x561,Line_Break::AL},
{0x588,static_cast<Line_Break>(0)},
{0x589,Line_Break::IS},
{0x58a,Line_Break::BA},
{0x58b,static_cast<Line_Break>(0)},
{0x58d,Line_Break::AL},
{0x58f,Line_Break::PR},
{0x590,static_cast<Line_Break>(0)},
{0x591,Line_Break::CM},
{0x5be,Line_Break::BA},
{0x5bf,Line_Break::CM},
{0x5c0,Line_Break::AL},
{0x5c1,Line_Break::CM},
{0x5c3,Line_Break::AL},
{0x5c4,Line_Break::CM},
{0x5c6,Line_Break::EX},
{0x5c7,Line_Break::CM},
{0x5c8,static_cast<Line_Break>(0)},
{0x5d0,Line_Break::HL},
{0x5eb,static_cast<Line_Break>(0)},
{0x5f0,Line_Break::HL},
{0x5f3,Line_Break::AL},
{0x5f5,static_cast<Line_Break>(0)},
{0x600,Line_Break::AL},
{0x609,Line_Break::PO},
{0x60c,Line_Break::IS},
{0x60e,Line_Break::AL},
{0x610,Line_Break::CM},
{0x61b,Line_Break::EX},
{0x61c,Line_Break::CM},
{0x61d,static_cast<Line_Break>(0)},
{0x61e,Line_Break::EX},
{0x620,Line_Break::AL},
{0x64b,Line_Break::CM},
{0x660,Line_Break::NU},
{0x66a,Line_Break::PO},
{0x66b,Line_Break::NU},
{0x66d,Line_Break::AL},
{0x670,Line_Break::CM},
{0x671,Line_Break::AL},
{0x6d4,Line_Break::EX},
{0x6d5,Line_Break::AL},
{0x6d6,Line_Break::CM},
{0x6dd,Line_Break::AL},
{0x6df,Line_Break::CM},
{0x6e5,Line_Break::AL},
{0x6e7,Line_Break::CM},
{0x6e9,Line_Break::AL},
{0x6ea,Line_Break::CM},
{0x6ee,Line_Break::AL},
{0x6f0,Line_Break::NU},
{0x6fa,Line_Break::AL},
{0x70e,static_cast<Line_Break>(0)},
{0x70f,Line_Break::AL},
{0x711,Line_Break::CM},
{0x712,Line_Break::AL},
{0x730,Line_Break::CM},
{0x74b,static_cast<Line_Break>(0)},
{0x74d,Line_Break::AL},
{0x7a6,Line_Break::CM},
{0x7b1,Line_Break::AL},
{0x7b2,static_cast<Line_Break>(0)},
{0x7c0,Line_Break::NU},
{0x7ca,Line_Break::AL},
{0x7eb,Line_Break::CM},
{0x7f4,Line_Break::AL},
{0x7f8,Line_Break::IS},
{0x7f9,Line_Break::EX},
{0x7fa,Line_Break::AL},
{0x7fb,static_cast<Line_Break>(0)},
{0x800,Line_Break::AL},
{0x816,Line_Break::CM},
{0x81a,Line_Break::AL},
{0x81b,Line_Break::CM},
{0x824,Line_Break::AL},
{0x825,Line_Break::CM},
{0x828,Line_Break::AL},
{0x829,Line_Break::CM},
{0x82e,static_cast<Line_Break>(0)},
{0x830,Line_Break::AL},
{0x83f,static_cast<Line_Break>(0)},
{0x840,Line_Break::AL},
{0x859,Line_Break::CM},
{0x85c,static_cast<Line_Break>(0)},
{0x85e,Line_Break::AL},
{0x85f,static_cast<Line_Break>(0)},
{0x8a0,Line_Break::AL},
{0x8b5,static_cast<Line_Break>(0)},
{0x8e3,Line_Break::CM},
{0x904,Line_Break::AL},
{0x93a,Line_Break::CM},
{0x93d,Line_Break::AL},
{0x93e,Line_Break::CM},
{0x950,Line_Break::AL},
{0x951,Line_Break::CM},
{0x958,Line_Break::AL},
{0x962,Line_Break::CM},
{0x964,Line_Break::BA},
{0x966,Line_Break::NU},
{0x970,Line_Break::AL},
{0x981,Line_Break::CM},
{0x984,static_cast<Line_Break>(0)},
{0x985,Line_Break::AL},
{0x98d,static_cast<Line_Break>(0)},
{0x98f,Line_Break::AL},
{0x991,static_cast<Line_Break>(0)},
{0x993,Line_Break::AL},
{0x9a9,static_cast<Line_Break>(0)},
{0x9aa,Line_Break::AL},
{0x9b1,static_cast<Line_Break>(0)},
{0x9b2,Line_Break::AL},
{0x9b3,static_cast<Line_Break>(0)},
{0x9b6,Line_Break::AL},
{0x9ba,static_cast<Line_Break>(0)},
{0x9bc,Line_Break::CM},
{0x9bd,Line_Break::AL},
{0x9be,Line_Break::CM},
{0x9c5,static_cast<Line_Break>(0)},
{0x9c7,Line_Break::CM},
{0x9c9,static_cast<Line_Break>(0)},
{0x9cb,Line_Break::CM},
{0x9ce,Line_Break::AL},
{0x9cf,static_cast<Line_Break>(0)},
{0x9d7,Line_Break::CM},
{0x9d8,static_cast<Line_Break>(0)},
{0x9dc,Line_Break::AL},
{0x9de,static_cast<Line_Break>(0)},
{0x9df,Line_Break::AL},
{0x9e2,Line_Break::CM},
{0x9e4,static_cast<Line_Break>(0)},
{0x9e6,Line_Break::NU},
{0x9f0,Line_Break::AL},
{0x9f2,Line_Break::PO},
{0x9f4,Line_Break::AL},
{0x9f9,Line_Break::PO},
{0x9fa,Line_Break::AL},
{0x9fb,Line_Break::PR},
{0x9fc,static_cast<Line_Break>(0)},
{0xa01,Line_Break::CM},
{0xa04,static_cast<Line_Break>(0)},
{0xa05,Line_Break::AL},
{0xa0b,static_cast<Line_Break>(0)},
{0xa0f,Line_Break::AL},
{0xa11,static_cast<Line_Break>(0)},
{0xa13,Line_Break::AL},
{0xa29,static_cast<Line_Break>(0)},
{0xa2a,Line_Break::AL},
{0xa31,static_cast<Line_Break>(0)},
{0xa32,Line_Break::AL},
{0xa34,static_cast<Line_Break>(0)},
{0xa35,Line_Break::AL},
{0xa37,static_cast<Line_Break>(0)},
{0xa38,Line_Break::AL},
{0xa3a,static_cast<Line_Break>(0)},
{0xa3c,Line_Break::CM},
{0xa3d,static_cast<Line_Break>(0)},
{0xa3e,Line_Break::CM},
{0xa43,static_cast<Line_Break>(0)},
{0xa47,Line_Break::CM},
{0xa49,static_cast<Line_Break>(0)},
{0xa4b,Line_Break::CM},
{0xa4e,static_cast<Line_Break>(0)},
{0xa51,Line_Break::CM},
{0xa52,static_cast<Line_Break>(0)},
{0xa59,Line_Break::AL},
{0xa5d,static_cast<Line_Break>(0)},
{0xa5e,Line_Break::AL},
{0xa5f,static_cast<Line_Break>(0)},
{0xa66,Line_Break::NU},
{0xa70,Line_Break::CM},
{0xa72,Line_Break::AL},
{0xa75,Line_Break::CM},
{0xa76,static_cast<Line_Break>(0)},
{0xa81,Line_Break::CM},
{0xa84,static_cast<Line_Break>(0)},
{0xa85,Line_Break::AL},
{0xa8e,static_cast<Line_Break>(0)},
{0xa8f,Line_Break::AL},
{0xa92,static_cast<Line_Break>(0)},
{0xa93,Line_Break::AL},
{0xaa9,static_cast<Line_Break>(0)},
{0xaaa,Line_Break::AL},
{0xab1,static_cast<Line_Break>(0)},
{0xab2,Line_Break::AL},
{0xab4,static_cast<Line_Break>(0)},
{0xab5,Line_Break::AL},
{0xaba,static_cast<Line_Break>(0)},
{0xabc,Line_Break::CM},
{0xabd,Line_Break::AL},
{0xabe,Line_Break::CM},
{0xac6,static_cast<Line_Break>(0)},
{0xac7,Line_Break::CM},
{0xaca,static_cast<Line_Break>(0)},
{0xacb,Line_Break::CM},
{0xace,static_cast<Line_Break>(0)},
{0xad0,Line_Break::AL},
{0xad1,static_cast<Line_Break>(0)},
{0xae0,Line_Break::AL},
{0xae2,Line_Break::CM},
{0xae4,static_cast<Line_Break>(0)},
{0xae6,Line_Break::NU},
{0xaf0,Line_Break::AL},
{0xaf1,Line_Break::PR},
{0xaf2,static_cast<Line_Break>(0)},
{0xaf9,Line_Break::AL},
{0xafa,static_cast<Line_Break>(0)},
{0xb01,Line_Break::CM},
{0xb04,static_cast<Line_Break>(0)},
{0xb05,Line_Break::AL},
{0xb0d,static_cast<Line_Break>(0)},
{0xb0f,Line_Break::AL},
{0xb11,static_cast<Line_Break>(0)},
{0xb13,Line_Break::AL},
{0xb29,static_cast<Line_Break>(0)},
{0xb2a,Line_Break::AL},
{0xb31,static_cast<Line_Break>(0)},
{0xb32,Line_Break::AL},
{0xb34,static_cast<Line_Break>(0)},
{0xb35,Line_Break::AL},
{0xb3a,static_cast<Line_Break>(0)},
{0xb3c,Line_Break::CM},
{0xb3d,Line_Break::AL},
{0xb3e,Line_Break::CM},
{0xb45,static_cast<Line_Break>(0)},
{0xb47,Line_Break::CM},
{0xb49,static_cast<Line_Break>(0)},
{0xb4b,Line_Break::CM},
{0xb4e,static_cast<Line_Break>(0)},
{0xb56,Line_Break::CM},
{0xb58,static_cast<Line_Break>(0)},
{0xb5c,Line_Break::AL},
{0xb5e,static_cast<Line_Break>(0)},
{0xb5f,Line_Break::AL},
{0xb62,Line_Break::CM},
{0xb64,static_cast<Line_Break>(0)},
{0xb66,Line_Break::NU},
{0xb70,Line_Break::AL},
{0xb78,static_cast<Line_Break>(0)},
{0xb82,Line_Break::CM},
{0xb83,Line_Break::AL},
{0xb84,static_cast<Line_Break>(0)},
{0xb85,Line_Break::AL},
{0xb8b,static_cast<Line_Break>(0)},
{0xb8e,Line_Break::AL},
{0xb91,static_cast<Line_Break>(0)},
{0xb92,Line_Break::AL},
{0xb96,static_cast<Line_Break>(0)},
{0xb99,Line_Break::AL},
{0xb9b,static_cast<Line_Break>(0)},
{0xb9c,Line_Break::AL},
{0xb9d,static_cast<Line_Break>(0)},
{0xb9e,Line_Break::AL},
{0xba0,static_cast<Line_Break>(0)},
{0xba3,Line_Break::AL},
{0xba5,static_cast<Line_Break>(0)},
{0xba8,Line_Break::AL},
{0xbab,static_cast<Line_Break>(0)},
{0xbae,Line_Break::AL},
{0xbba,static_cast<Line_Break>(0)},
{0xbbe,Line_Break::CM},
{0xbc3,static_cast<Line_Break>(0)},
{0xbc6,Line_Break::CM},
{0xbc9,static_cast<Line_Break>(0)},
{0xbca,Line_Break::CM},
{0xbce,static_cast<Line_Break>(0)},
{0xbd0,Line_Break::AL},
{0xbd1,static_cast<Line_Break>(0)},
{0xbd7,Line_Break::CM},
{0xbd8,static_cast<Line_Break>(0)},
{0xbe6,Line_Break::NU},
{0xbf0,Line_Break::AL},
{0xbf9,Line_Break::PR},
{0xbfa,Line_Break::AL},
{0xbfb,static_cast<Line_Break>(0)},
{0xc00,Line_Break::CM},
{0xc04,static_cast<Line_Break>(0)},
{0xc05,Line_Break::AL},
{0xc0d,static_cast<Line_Break>(0)},
{0xc0e,Line_Break::AL},
{0xc11,static_cast<Line_Break>(0)},
{0xc12,Line_Break::AL},
{0xc29,static_cast<Line_Break>(0)},
{0xc2a,Line_Break::AL},
{0xc3a,static_cast<Line_Break>(0)},
{0xc3d,Line_Break::AL},
{0xc3e,Line_Break::CM},
{0xc45,static_cast<Line_Break>(0)},
{0xc46,Line_Break::CM},
{0xc49,static_cast<Line_Break>(0)},
{0xc4a,Line_Break::CM},
{0xc4e,static_cast<Line_Break>(0)},
{0xc55,Line_Break::CM},
{0xc57,static_cast<Line_Break>(0)},
{0xc58,Line_Break::AL},
{0xc5b,static_cast<Line_Break>(0)},
{0xc60,Line_Break::AL},
{0xc62,Line_Break::CM},
{0xc64,static_cast<Line_Break>(0)},
{0xc66,Line_Break::NU},
{0xc70,static_cast<Line_Break>(0)},
{0xc78,Line_Break::AL},
{0xc80,static_cast<Line_Break>(0)},
{0xc81,Line_Break::CM},
{0xc84,static_cast<Line_Break>(0)},
{0xc85,Line_Break::AL},
{0xc8d,static_cast<Line_Break>(0)},
{0xc8e,Line_Break::AL},
{0xc91,static_cast<Line_Break>(0)},
{0xc92,Line_Break::AL},
{0xca9,static_cast<Line_Break>(0)},
{0xcaa,Line_Break::AL},
{0xcb4,static_cast<Line_Break>(0)},
{0xcb5,Line_Break::AL},
{0xcba,static_cast<Line_Break>(0)},
{0xcbc,Line_Break::CM},
{0xcbd,Line_Break::AL},
{0xcbe,Line_Break::CM},
{0xcc5,static_cast<Line_Break>(0)},
{0xcc6,Line_Break::CM},
{0xcc9,static_cast<Line_Break>(0)},
{0xcca,Line_Break::CM},
{0xcce,static_cast<Line_Break>(0)},
{0xcd5,Line_Break::CM},
{0xcd7,static_cast<Line_Break>(0)},
{0xcde,Line_Break::AL},
{0xcdf,static_cast<Line_Break>(0)},
{0xce0,Line_Break::AL},
{0xce2,Line_Break::CM},
{0xce4,static_cast<Line_Break>(0)},
{0xce6,Line_Break::NU},
{0xcf0,static_cast<Line_Break>(0)},
{0xcf1,Line_Break::AL},
{0xcf3,static_cast<Line_Break>(0)},
{0xd01,Line_Break::CM},
{0xd04,static_cast<Line_Break>(0)},
{0xd05,Line_Break::AL},
{0xd0d,static_cast<Line_Break>(0)},
{0xd0e,Line_Break::AL},
{0xd11,static_cast<Line_Break>(0)},
{0xd12,Line_Break::AL},
{0xd3b,static_cast<Line_Break>(0)},
{0xd3d,Line_Break::AL},
{0xd3e,Line_Break::CM},
{0xd45,static_cast<Line_Break>(0)},
{0xd46,Line_Break::CM},
{0xd49,static_cast<Line_Break>(0)},
{0xd4a,Line_Break::CM},
{0xd4e,Line_Break::AL},
{0xd4f,static_cast<Line_Break>(0)},
{0xd57,Line_Break::CM},
{0xd58,static_cast<Line_Break>(0)},
{0xd5f,Line_Break::AL},
{0xd62,Line_Break::CM},
{0xd64,static_cast<Line_Break>(0)},
{0xd66,Line_Break::NU},
{0xd70,Line_Break::AL},
{0xd76,static_cast<Line_Break>(0)},
{0xd79,Line_Break::PO},
{0xd7a,Line_Break::AL},
{0xd80,static_cast<Line_Break>(0)},
{0xd82,Line_Break::CM},
{0xd84,static_cast<Line_Break>(0)},
{0xd85,Line_Break::AL},
{0xd97,static_cast<Line_Break>(0)},
{0xd9a,Line_Break::AL},
{0xdb2,static_cast<Line_Break>(0)},
{0xdb3,Line_Break::AL},
{0xdbc,static_cast<Line_Break>(0)},
{0xdbd,Line_Break::AL},
{0xdbe,static_cast<Line_Break>(0)},
{0xdc0,Line_Break::AL},
{0xdc7,static_cast<Line_Break>(0)},
{0xdca,Line_Break::CM},
{0xdcb,static_cast<Line_Break>(0)},
{0xdcf,Line_Break::CM},
{0xdd5,static_cast<Line_Break>(0)},
{0xdd6,Line_Break::CM},
{0xdd7,static_cast<Line_Break>(0)},
{0xdd8,Line_Break::CM},
{0xde0,static_cast<Line_Break>(0)},
{0xde6,Line_Break::NU},
{0xdf0,static_cast<Line_Break>(0)},
{0xdf2,Line_Break::CM},
{0xdf4,Line_Break::AL},
{0xdf5,static_cast<Line_Break>(0)},
{0xe01,Line_Break::SA},
{0xe3b,static_cast<Line_Break>(0)},
{0xe3f,Line_Break::PR},
{0xe40,Line_Break::SA},
{0xe4f,Line_Break::AL},
{0xe50,Line_Break::NU},
{0xe5a,Line_Break::BA},
{0xe5c,static_cast<Line_Break>(0)},
{0xe81,Line_Break::SA},
{0xe83,static_cast<Line_Break>(0)},
{0xe84,Line_Break::SA},
{0xe85,static_cast<Line_Break>(0)},
{0xe87,Line_Break::SA},
{0xe89,static_cast<Line_Break>(0)},
{0xe8a,Line_Break::SA},
{0xe8b,static_cast<Line_Break>(0)},
{0xe8d,Line_Break::SA},
{0xe8e,static_cast<Line_Break>(0)},
{0xe94,Line_Break::SA},
{0xe98,static_cast<Line_Break>(0)},
{0xe99,Line_Break::SA},
{0xea0,static_cast<Line_Break>(0)},
{0xea1,Line_Break::SA},
{0xea4,static_cast<Line_Break>(0)},
{0xea5,Line_Break::SA},
{0xea6,static_cast<Line_Break>(0)},
{0xea7,Line_Break::SA},
{0xea8,static_cast<Line_Break>(0)},
{0xeaa,Line_Break::SA},
{0xeac,static_cast<Line_Break>(0)},
{0xead,Line_Break::SA},
{0xeba,static_cast<Line_Break>(0)},
{0xebb,Line_Break::SA},
{0xebe,static_cast<Line_Break>(0)},
{0xec0,Line_Break::SA},
{0xec5,static_cast<Line_Break>(0)},
{0xec6,Line_Break::SA},
{0xec7,static_cast<Line_Break>(0)},
{0xec8,Line_Break::SA},
{0xece,static_cast<Line_Break>(0)},
{0xed0,Line_Break::NU},
{0xeda,static_cast<Line_Break>(0)},
{0xedc,Line_Break::SA},
{0xee0,static_cast<Line_Break>(0)},
{0xf00,Line_Break::AL},
{0xf01,Line_Break::BB},
{0xf05,Line_Break::AL},
{0xf06,Line_Break::BB},
{0xf08,Line_Break::GL},
{0xf09,Line_Break::BB},
{0xf0b,Line_Break::BA},
{0xf0c,Line_Break::GL},
{0xf0d,Line_Break::EX},
{0xf12,Line_Break::GL},
{0xf13,Line_Break::AL},
{0xf14,Line_Break::EX},
{0xf15,Line_Break::AL},
{0xf18,Line_Break::CM},
{0xf1a,Line_Break::AL},
{0xf20,Line_Break::NU},
{0xf2a,Line_Break::AL},
{0xf34,Line_Break::BA},
{0xf35,Line_Break::CM},
{0xf36,Line_Break::AL},
{0xf37,Line_Break::CM},
{0xf38,Line_Break::AL},
{0xf39,Line_Break::CM},
{0xf3a,Line_Break::OP},
{0xf3b,Line_Break::CL},
{0xf3c,Line_Break::OP},
{0xf3d,Line_Break::CL},
{0xf3e,Line_Break::CM},
{0xf40,Line_Break::AL},
{0xf48,static_cast<Line_Break>(0)},
{0xf49,Line_Break::AL},
{0xf6d,static_cast<Line_Break>(0)},
{0xf71,Line_Break::CM},
{0xf7f,Line_Break::BA},
{0xf80,Line_Break::CM},
{0xf85,Line_Break::BA},
{0xf86,Line_Break::CM},
{0xf88,Line_Break::AL},
{0xf8d,Line_Break::CM},
{0xf98,static_cast<Line_Break>(0)},
{0xf99,Line_Break::CM},
{0xfbd,static_cast<Line_Break>(0)},
{0xfbe,Line_Break::BA},
{0xfc0,Line_Break::AL},
{0xfc6,Line_Break::CM},
{0xfc7,Line_Break::AL},
{0xfcd,static_cast<Line_Break>(0)},
{0xfce,Line_Break::AL},
{0xfd0,Line_Break::BB},
{0xfd2,Line_Break::BA},
{0xfd3,Line_Break::BB},
{0xfd4,Line_Break::AL},
{0xfd9,Line_Break::GL},
{0xfdb,static_cast<Line_Break>(0)},
{0x1000,Line_Break::SA},
{0x1040,Line_Break::NU},
{0x104a,Line_Break::BA},
{0x104c,Line_Break::AL},
{0x1050,Line_Break::SA},
{0x1090,Line_Break::NU},
{0x109a,Line_Break::SA},
{0x10a0,Line_Break::AL},
{0x10c6,static_cast<Line_Break>(0)},
{0x10c7,Line_Break::AL},
{0x10c8,static_cast<Line_Break>(0)},
{0x10cd,Line_Break::AL},
{0x10ce,static_cast<Line_Break>(0)},
{0x10d0,Line_Break::AL},
{0x1100,Line_Break::JL},
{0x1160,Line_Break::JV},
{0x11a8,Line_Break::JT},
{0x1200,Line_Break::AL},
{0x1249,static_cast<Line_Break>(0)},
{0x124a,Line_Break::AL},
{0x124e,static_cast<Line_Break>(0)},
{0x1250,Line_Break::AL},
{0x1257,static_cast<Line_Break>(0)},
{0x1258,Line_Break::AL},
{0x1259,static_cast<Line_Break>(0)},
{0x125a,Line_Break::AL},
{0x125e,static_cast<Line_Break>(0)},
{0x1260,Line_Break::AL},
{0x1289,static_cast<Line_Break>(0)},
{0x128a,Line_Break::AL},
{0x128e,static_cast<Line_Break>(0)},
{0x1290,Line_Break::AL},
{0x12b1,static_cast<Line_Break>(0)},
{0x12b2,Line_Break::AL},
{0x12b6,static_cast<Line_Break>(0)},
{0x12b8,Line_Break::AL},
{0x12bf,static_cast<Line_Break>(0)},
{0x12c0,Line_Break::AL},
{0x12c1,static_cast<Line_Break>(0)},
{0x12c2,Line_Break::AL},
{0x12c6,static_cast<Line_Break>(0)},
{0x12c8,Line_Break::AL},
{0x12d7,static_cast<Line_Break>(0)},
{0x12d8,Line_Break::AL},
{0x1311,static_cast<Line_Break>(0)},
{0x1312,Line_Break::AL},
{0x1316,static_cast<Line_Break>(0)},
{0x1318,Line_Break::AL},
{0x135b,static_cast<Line_Break>(0)},
{0x135d,Line_Break::CM},
{0x1360,Line_Break::AL},
{0x1361,Line_Break::BA},
{0x1362,Line_Break::AL},
{0x137d,static_cast<Line_Break>(0)},
{0x1380,Line_Break::AL},
{0x139a,static_cast<Line_Break>(0)},
{0x13a0,Line_Break::AL},
{0x13f6,static_cast<Line_Break>(0)},
{0x13f8,Line_Break::AL},
{0x13fe,static_cast<Line_Break>(0)},
{0x1400,Line_Break::BA},
{0x1401,Line_Break::AL},
{0x1680,Line_Break::BA},
{0x1681,Line_Break::AL},
{0x169b,Line_Break::OP},
{0x169c,Line_Break::CL},
{0x169d,static_cast<Line_Break>(0)},
{0x16a0,Line_Break::AL},
{0x16eb,Line_Break::BA},
{0x16ee,Line_Break::AL},
{0x16f9,static_cast<Line_Break>(0)},
{0x1700,Line_Break::AL},
{0x170d,static_cast<Line_Break>(0)},
{0x170e,Line_Break::AL},
{0x1712,Line_Break::CM},
{0x1715,static_cast<Line_Break>(0)},
{0x1720,Line_Break::AL},
{0x1732,Line_Break::CM},
{0x1735,Line_Break::BA},
{0x1737,static_cast<Line_Break>(0)},
{0x1740,Line_Break::AL},
{0x1752,Line_Break::CM},
{0x1754,static_cast<Line_Break>(0)},
{0x1760,Line_Break::AL},
{0x176d,static_cast<Line_Break>(0)},
{0x176e,Line_Break::AL},
{0x1771,static_cast<Line_Break>(0)},
{0x1772,Line_Break::CM},
{0x1774,static_cast<Line_Break>(0)},
{0x1780,Line_Break::SA},
{0x17d4,Line_Break::BA},
{0x17d6,Line_Break::NS},
{0x17d7,Line_Break::SA},
{0x17d8,Line_Break::BA},
{0x17d9,Line_Break::AL},
{0x17da,Line_Break::BA},
{0x17db,Line_Break::PR},
{0x17dc,Line_Break::SA},
{0x17de,static_cast<Line_Break>(0)},
{0x17e0,Line_Break::NU},
{0x17ea,static_cast<Line_Break>(0)},
{0x17f0,Line_Break::AL},
{0x17fa,static_cast<Line_Break>(0)},
{0x1800,Line_Break::AL},
{0x1802,Line_Break::EX},
{0x1804,Line_Break::BA},
{0x1806,Line_Break::BB},
{0x1807,Line_Break::AL},
{0x1808,Line_Break::EX},
{0x180a,Line_Break::AL},
{0x180b,Line_Break::CM},
{0x180e,Line_Break::GL},
{0x180f,static_cast<Line_Break>(0)},
{0x1810,Line_Break::NU},
{0x181a,static_cast<Line_Break>(0)},
{0x1820,Line_Break::AL},
{0x1878,static_cast<Line_Break>(0)},
{0x1880,Line_Break::AL},
{0x18a9,Line_Break::CM},
{0x18aa,Line_Break::AL},
{0x18ab,static_cast<Line_Break>(0)},
{0x18b0,Line_Break::AL},
{0x18f6,static_cast<Line_Break>(0)},
{0x1900,Line_Break::AL},
{0x191f,static_cast<Line_Break>(0)},
{0x1920,Line_Break::CM},
{0x192c,static_cast<Line_Break>(0)},
{0x1930,Line_Break::CM},
{0x193c,static_cast<Line_Break>(0)},
{0x1940,Line_Break::AL},
{0x1941,static_cast<Line_Break>(0)},
{0x1944,Line_Break::EX},
{0x1946,Line_Break::NU},
{0x1950,Line_Break::SA},
{0x196e,static_cast<Line_Break>(0)},
{0x1970,Line_Break::SA},
{0x1975,static_cast<Line_Break>(0)},
{0x1980,Line_Break::SA},
{0x19ac,static_cast<Line_Break>(0)},
{0x19b0,Line_Break::SA},
{0x19ca,static_cast<Line_Break>(0)},
{0x19d0,Line_Break::NU},
{0x19da,Line_Break::SA},
{0x19db,static_cast<Line_Break>(0)},
{0x19de,Line_Break::SA},
{0x19e0,Line_Break::AL},
{0x1a17,Line_Break::CM},
{0x1a1c,static_cast<Line_Break>(0)},
{0x1a1e,Line_Break::AL},
{0x1a20,Line_Break::SA},
{0x1a5f,static_cast<Line_Break>(0)},
{0x1a60,Line_Break::SA},
{0x1a7d,static_cast<Line_Break>(0)},
{0x1a7f,Line_Break::CM},
{0x1a80,Line_Break::NU},
{0x1a8a,static_cast<Line_Break>(0)},
{0x1a90,Line_Break::NU},
{0x1a9a,static_cast<Line_Break>(0)},
{0x1aa0,Line_Break::SA},
{0x1aae,static_cast<Line_Break>(0)},
{0x1ab0,Line_Break::CM},
{0x1abf,static_cast<Line_Break>(0)},
{0x1b00,Line_Break::CM},
{0x1b05,Line_Break::AL},
{0x1b34,Line_Break::CM},
{0x1b45,Line_Break::AL},
{0x1b4c,static_cast<Line_Break>(0)},
{0x1b50,Line_Break::NU},
{0x1b5a,Line_Break::BA},
{0x1b5c,Line_Break::AL},
{0x1b5d,Line_Break::BA},
{0x1b61,Line_Break::AL},
{0x1b6b,Line_Break::CM},
{0x1b74,Line_Break::AL},
{0x1b7d,static_cast<Line_Break>(0)},
{0x1b80,Line_Break::CM},
{0x1b83,Line_Break::AL},
{0x1ba1,Line_Break::CM},
{0x1bae,Line_Break::AL},
{0x1bb0,Line_Break::NU},
{0x1bba,Line_Break::AL},
{0x1be6,Line_Break::CM},
{0x1bf4,static_cast<Line_Break>(0)},
{0x1bfc,Line_Break::AL},
{0x1c24,Line_Break::CM},
{0x1c38,static_cast<Line_Break>(0)},
{0x1c3b,Line_Break::BA},
{0x1c40,Line_Break::NU},
{0x1c4a,static_cast<Line_Break>(0)},
{0x1c4d,Line_Break::AL},
{0x1c50,Line_Break::NU},
{0x1c5a,Line_Break::AL},
{0x1c7e,Line_Break::BA},
{0x1c80,static_cast<Line_Break>(0)},
{0x1cc0,Line_Break::AL},
{0x1cc8,static_cast<Line_Break>(0)},
{0x1cd0,Line_Break::CM},
{0x1cd3,Line_Break::AL},
{0x1cd4,Line_Break::CM},
{0x1ce9,Line_Break::AL},
{0x1ced,Line_Break::CM},
{0x1cee,Line_Break::AL},
{0x1cf2,Line_Break::CM},
{0x1cf5,Line_Break::AL},
{0x1cf7,static_cast<Line_Break>(0)},
{0x1cf8,Line_Break::CM},
{0x1cfa,static_cast<Line_Break>(0)},
{0x1d00,Line_Break::AL},
{0x1dc0,Line_Break::CM},
{0x1df6,static_cast<Line_Break>(0)},
{0x1dfc,Line_Break::CM},
{0x1e00,Line_Break::AL},
{0x1f16,static_cast<Line_Break>(0)},
{0x1f18,Line_Break::AL},
{0x1f1e,static_cast<Line_Break>(0)},
{0x1f20,Line_Break::AL},
{0x1f46,static_cast<Line_Break>(0)},
{0x1f48,Line_Break::AL},
{0x1f4e,static_cast<Line_Break>(0)},
{0x1f50,Line_Break::AL},
{0x1f58,static_cast<Line_Break>(0)},
{0x1f59,Line_Break::AL},
{0x1f5a,static_cast<Line_Break>(0)},
{0x1f5b,Line_Break::AL},
{0x1f5c,static_cast<Line_Break>(0)},
{0x1f5d,Line_Break::AL},
{0x1f5e,static_cast<Line_Break>(0)},
{0x1f5f,Line_Break::AL},
{0x1f7e,static_cast<Line_Break>(0)},
{0x1f80,Line_Break::AL},
{0x1fb5,static_cast<Line_Break>(0)},
{0x1fb6,Line_Break::AL},
{0x1fc5,static_cast<Line_Break>(0)},
{0x1fc6,Line_Break::AL},
{0x1fd4,static_cast<Line_Break>(0)},
{0x1fd6,Line_Break::AL},
{0x1fdc,static_cast<Line_Break>(0)},
{0x1fdd,Line_Break::AL},
{0x1ff0,static_cast<Line_Break>(0)},
{0x1ff2,Line_Break::AL},
{0x1ff5,static_cast<Line_Break>(0)},
{0x1ff6,Line_Break::AL},
{0x1ffd,Line_Break::BB},
{0x1ffe,Line_Break::AL},
{0x1fff,static_cast<Line_Break>(0)},
{0x2000,Line_Break::BA},
{0x2007,Line_Break::GL},
{0x2008,Line_Break::BA},
{0x200b,Line_Break::ZW},
{0x200c,Line_Break::CM},
{0x2010,Line_Break::BA},
{0x2011,Line_Break::GL},
{0x2012,Line_Break::BA},
{0x2014,Line_Break::B2},
{0x2015,Line_Break::AI},
{0x2017,Line_Break::AL},
{0x2018,Line_Break::QU},
{0x201a,Line_Break::OP},
{0x201b,Line_Break::QU},
{0x201e,Line_Break::OP},
{0x201f,Line_Break::QU},
{0x2020,Line_Break::AI},
{0x2022,Line_Break::AL},
{0x2024,Line_Break::IN_},
{0x2027,Line_Break::BA},
{0x2028,Line_Break::BK},
{0x202a,Line_Break::CM},
{0x202f,Line_Break::GL},
{0x2030,Line_Break::PO},
{0x2038,Line_Break::AL},
{0x2039,Line_Break::QU},
{0x203b,Line_Break::AI},
{0x203c,Line_Break::NS},
{0x203e,Line_Break::AL},
{0x2044,Line_Break::IS},
{0x2045,Line_Break::OP},
{0x2046,Line_Break::CL},
{0x2047,Line_Break::NS},
{0x204a,Line_Break::AL},
{0x2056,Line_Break::BA},
{0x2057,Line_Break::AL},
{0x2058,Line_Break::BA},
{0x205c,Line_Break::AL},
{0x205d,Line_Break::BA},
{0x2060,Line_Break::WJ},
{0x2061,Line_Break::AL},
{0x2065,static_cast<Line_Break>(0)},
{0x2066,Line_Break::CM},
{0x2070,Line_Break::AL},
{0x2072,static_cast<Line_Break>(0)},
{0x2074,Line_Break::AI},
{0x2075,Line_Break::AL},
{0x207d,Line_Break::OP},
{0x207e,Line_Break::CL},
{0x207f,Line_Break::AI},
{0x2080,Line_Break::AL},
{0x2081,Line_Break::AI},
{0x2085,Line_Break::AL},
{0x208d,Line_Break::OP},
{0x208e,Line_Break::CL},
{0x208f,static_cast<Line_Break>(0)},
{0x2090,Line_Break::AL},
{0x209d,static_cast<Line_Break>(0)},
{0x20a0,Line_Break::PR},
{0x20a7,Line_Break::PO},
{0x20a8,Line_Break::PR},
{0x20b6,Line_Break::PO},
{0x20b7,Line_Break::PR},
{0x20bb,Line_Break::PO},
{0x20bc,Line_Break::PR},
{0x20be,Line_Break::PO},
{0x20bf,Line_Break::PR},
{0x20d0,Line_Break::CM},
{0x20f1,static_cast<Line_Break>(0)},
{0x2100,Line_Break::AL},
{0x2103,Line_Break::PO},
{0x2104,Line_Break::AL},
{0x2105,Line_Break::AI},
{0x2106,Line_Break::AL},
{0x2109,Line_Break::PO},
{0x210a,Line_Break::AL},
{0x2113,Line_Break::AI},
{0x2114,Line_Break::AL},
{0x2116,Line_Break::PR},
{0x2117,Line_Break::AL},
{0x2121,Line_Break::AI},
{0x2123,Line_Break::AL},
{0x212b,Line_Break::AI},
{0x212c,Line_Break::AL},
{0x2154,Line_Break::AI},
{0x2156,Line_Break::AL},
{0x215b,Line_Break::AI},
{0x215c,Line_Break::AL},
{0x215e,Line_Break::AI},
{0x215f,Line_Break::AL},
{0x2160,Line_Break::AI},
{0x216c,Line_Break::AL},
{0x2170,Line_Break::AI},
{0x217a,Line_Break::AL},
{0x2189,Line_Break::AI},
{0x218a,Line_Break::AL},
{0x218c,static_cast<Line_Break>(0)},
{0x2190,Line_Break::AI},
{0x219a,Line_Break::AL},
{0x21d2,Line_Break::AI},
{0x21d3,Line_Break::AL},
{0x21d4,Line_Break::AI},
{0x21d5,Line_Break::AL},
{0x2200,Line_Break::AI},
{0x2201,Line_Break::AL},
{0x2202,Line_Break::AI},
{0x2204,Line_Break::AL},
{0x2207,Line_Break::AI},
{0x2209,Line_Break::AL},
{0x220b,Line_Break::AI},
{0x220c,Line_Break::AL},
{0x220f,Line_Break::AI},
{0x2210,Line_Break::AL},
{0x2211,Line_Break::AI},
{0x2212,Line_Break::PR},
{0x2214,Line_Break::AL},
{0x2215,Line_Break::AI},
{0x2216,Line_Break::AL},
{0x221a,Line_Break::AI},
{0x221b,Line_Break::AL},
{0x221d,Line_Break::AI},
{0x2221,Line_Break::AL},
{0x2223,Line_Break::AI},
{0x2224,Line_Break::AL},
{0x2225,Line_Break::AI},
{0x2226,Line_Break::AL},
{0x2227,Line_Break::AI},
{0x222d,Line_Break::AL},
{0x222e,Line_Break::AI},
{0x222f,Line_Break::AL},
{0x2234,Line_Break::AI},
{0x2238,Line_Break::AL},
{0x223c,Line_Break::AI},
{0x223e,Line_Break::AL},
{0x2248,Line_Break::AI},
{0x2249,Line_Break::AL},
{0x224c,Line_Break::AI},
{0x224d,Line_Break::AL},
{0x2252,Line_Break::AI},
{0x2253,Line_Break::AL},
{0x2260,Line_Break::AI},
{0x2262,Line_Break::AL},
{0x2264,Line_Break::AI},
{0x2268,Line_Break::AL},
{0x226a,Line_Break::AI},
{0x226c,Line_Break::AL},
{0x226e,Line_Break::AI},
{0x2270,Line_Break::AL},
{0x2282,Line_Break::AI},
{0x2284,Line_Break::AL},
{0x2286,Line_Break::AI},
{0x2288,Line_Break::AL},
{0x2295,Line_Break::AI},
{0x2296,Line_Break::AL},
{0x2299,Line_Break::AI},
{0x229a,Line_Break::AL},
{0x22a5,Line_Break::AI},
{0x22a6,Line_Break::AL},
{0x22bf,Line_Break::AI},
{0x22c0,Line_Break::AL},
{0x22ef,Line_Break::IN_},
{0x22f0,Line_Break::AL},
{0x2308,Line_Break::OP},
{0x2309,Line_Break::CL},
{0x230a,Line_Break::OP},
{0x230b,Line_Break::CL},
{0x230c,Line_Break::AL},
{0x2312,Line_Break::AI},
{0x2313,Line_Break::AL},
{0x231a,Line_Break::ID},
{0x231c,Line_Break::AL},
{0x2329,Line_Break::OP},
{0x232a,Line_Break::CL},
{0x232b,Line_Break::AL},
{0x23f0,Line_Break::ID},
{0x23f4,Line_Break::AL},
{0x23fb,static_cast<Line_Break>(0)},
{0x2400,Line_Break::AL},
{0x2427,static_cast<Line_Break>(0)},
{0x2440,Line_Break::AL},
{0x244b,static_cast<Line_Break>(0)},
{0x2460,Line_Break::AI},
{0x24ff,Line_Break::AL},
{0x2500,Line_Break::AI},
{0x254c,Line_Break::AL},
{0x2550,Line_Break::AI},
{0x2575,Line_Break::AL},
{0x2580,Line_Break::AI},
{0x2590,Line_Break::AL},
{0x2592,Line_Break::AI},
{0x2596,Line_Break::AL},
{0x25a0,Line_Break::AI},
{0x25a2,Line_Break::AL},
{0x25a3,Line_Break::AI},
{0x25aa,Line_Break::AL},
{0x25b2,Line_Break::AI},
{0x25b4,Line_Break::AL},
{0x25b6,Line_Break::AI},
{0x25b8,Line_Break::AL},
{0x25bc,Line_Break::AI},
{0x25be,Line_Break::AL},
{0x25c0,Line_Break::AI},
{0x25c2,Line_Break::AL},
{0x25c6,Line_Break::AI},
{0x25c9,Line_Break::AL},
{0x25cb,Line_Break::AI},
{0x25cc,Line_Break::AL},
{0x25ce,Line_Break::AI},
{0x25d2,Line_Break::AL},
{0x25e2,Line_Break::AI},
{0x25e6,Line_Break::AL},
{0x25ef,Line_Break::AI},
{0x25f0,Line_Break::AL},
{0x2600,Line_Break::ID},
{0x2604,Line_Break::AL},
{0x2605,Line_Break::AI},
{0x2607,Line_Break::AL},
{0x2609,Line_Break::AI},
{0x260a,Line_Break::AL},
{0x260e,Line_Break::AI},
{0x2610,Line_Break::AL},
{0x2614,Line_Break::ID},
{0x2616,Line_Break::AI},
{0x2618,Line_Break::ID},
{0x2619,Line_Break::AL},
{0x261a,Line_Break::ID},
{0x2620,Line_Break::AL},
{0x2639,Line_Break::ID},
{0x263c,Line_Break::AL},
{0x2640,Line_Break::AI},
{0x2641,Line_Break::AL},
{0x2642,Line_Break::AI},
{0x2643,Line_Break::AL},
{0x2660,Line_Break::AI},
{0x2662,Line_Break::AL},
{0x2663,Line_Break::AI},
{0x2666,Line_Break::AL},
{0x2667,Line_Break::AI},
{0x2668,Line_Break::ID},
{0x2669,Line_Break::AI},
{0x266b,Line_Break::AL},
{0x266c,Line_Break::AI},
{0x266e,Line_Break::AL},
{0x266f,Line_Break::AI},
{0x2670,Line_Break::AL},
{0x267f,Line_Break::ID},
{0x2680,Line_Break::AL},
{0x269e,Line_Break::AI},
{0x26a0,Line_Break::AL},
{0x26bd,Line_Break::ID},
{0x26c9,Line_Break::AI},
{0x26cd,Line_Break::ID},
{0x26ce,Line_Break::AL},
{0x26cf,Line_Break::ID},
{0x26d2,Line_Break::AI},
{0x26d3,Line_Break::ID},
{0x26d5,Line_Break::AI},
{0x26d8,Line_Break::ID},
{0x26da,Line_Break::AI},
{0x26dc,Line_Break::ID},
{0x26dd,Line_Break::AI},
{0x26df,Line_Break::ID},
{0x26e2,Line_Break::AL},
{0x26e3,Line_Break::AI},
{0x26e4,Line_Break::AL},
{0x26e8,Line_Break::AI},
{0x26ea,Line_Break::ID},
{0x26eb,Line_Break::AI},
{0x26f1,Line_Break::ID},
{0x26f6,Line_Break::AI},
{0x26f7,Line_Break::ID},
{0x26fb,Line_Break::AI},
{0x26fd,Line_Break::ID},
{0x2705,Line_Break::AL},
{0x2708,Line_Break::ID},
{0x270e,Line_Break::AL},
{0x2757,Line_Break::AI},
{0x2758,Line_Break::AL},
{0x275b,Line_Break::QU},
{0x2761,Line_Break::AL},
{0x2762,Line_Break::EX},
{0x2764,Line_Break::AL},
{0x2768,Line_Break::OP},
{0x2769,Line_Break::CL},
{0x276a,Line_Break::OP},
{0x276b,Line_Break::CL},
{0x276c,Line_Break::OP},
{0x276d,Line_Break::CL},
{0x276e,Line_Break::OP},
{0x276f,Line_Break::CL},
{0x2770,Line_Break::OP},
{0x2771,Line_Break::CL},
{0x2772,Line_Break::OP},
{0x2773,Line_Break::CL},
{0x2774,Line_Break::OP},
{0x2775,Line_Break::CL},
{0x2776,Line_Break::AI},
{0x2794,Line_Break::AL},
{0x27c5,Line_Break::OP},
{0x27c6,Line_Break::CL},
{0x27c7,Line_Break::AL},
{0x27e6,Line_Break::OP},
{0x27e7,Line_Break::CL},
{0x27e8,Line_Break::OP},
{0x27e9,Line_Break::CL},
{0x27ea,Line_Break::OP},
{0x27eb,Line_Break::CL},
{0x27ec,Line_Break::OP},
{0x27ed,Line_Break::CL},
{0x27ee,Line_Break::OP},
{0x27ef,Line_Break::CL},
{0x27f0,Line_Break::AL},
{0x2983,Line_Break::OP},
{0x2984,Line_Break::CL},
{0x2985,Line_Break::OP},
{0x2986,Line_Break::CL},
{0x2987,Line_Break::OP},
{0x2988,Line_Break::CL},
{0x2989,Line_Break::OP},
{0x298a,Line_Break::CL},
{0x298b,Line_Break::OP},
{0x298c,Line_Break::CL},
{0x298d,Line_Break::OP},
{0x298e,Line_Break::CL},
{0x298f,Line_Break::OP},
{0x2990,Line_Break::CL},
{0x2991,Line_Break::OP},
{0x2992,Line_Break::CL},
{0x2993,Line_Break::OP},
{0x2994,Line_Break::CL},
{0x2995,Line_Break::OP},
{0x2996,Line_Break::CL},
{0x2997,Line_Break::OP},
{0x2998,Line_Break::CL},
{0x2999,Line_Break::AL},
{0x29d8,Line_Break::OP},
{0x29d9,Line_Break::CL},
{0x29da,Line_Break::OP},
{0x29db,Line_Break::CL},
{0x29dc,Line_Break::AL},
{0x29fc,Line_Break::OP},
{0x29fd,Line_Break::CL},
{0x29fe,Line_Break::AL},
{0x2b55,Line_Break::AI},
{0x2b5a,Line_Break::AL},
{0x2b74,static_cast<Line_Break>(0)},
{0x2b76,Line_Break::AL},
{0x2b96,static_cast<Line_Break>(0)},
{0x2b98,Line_Break::AL},
{0x2bba,static_cast<Line_Break>(0)},
{0x2bbd,Line_Break::AL},
{0x2bc9,static_cast<Line_Break>(0)},
{0x2bca,Line_Break::AL},
{0x2bd2,static_cast<Line_Break>(0)},
{0x2bec,Line_Break::AL},
{0x2bf0,static_cast<Line_Break>(0)},
{0x2c00,Line_Break::AL},
{0x2c2f,static_cast<Line_Break>(0)},
{0x2c30,Line_Break::AL},
{0x2c5f,static_cast<Line_Break>(0)},
{0x2c60,Line_Break::AL},
{0x2cef,Line_Break::CM},
{0x2cf2,Line_Break::AL},
{0x2cf4,static_cast<Line_Break>(0)},
{0x2cf9,Line_Break::EX},
{0x2cfa,Line_Break::BA},
{0x2cfd,Line_Break::AL},
{0x2cfe,Line_Break::EX},
{0x2cff,Line_Break::BA},
{0x2d00,Line_Break::AL},
{0x2d26,static_cast<Line_Break>(0)},
{0x2d27,Line_Break::AL},
{0x2d28,static_cast<Line_Break>(0)},
{0x2d2d,Line_Break::AL},
{0x2d2e,static_cast<Line_Break>(0)},
{0x2d30,Line_Break::AL},
{0x2d68,static_cast<Line_Break>(0)},
{0x2d6f,Line_Break::AL},
{0x2d70,Line_Break::BA},
{0x2d71,static_cast<Line_Break>(0)},
{0x2d7f,Line_Break::CM},
{0x2d80,Line_Break::AL},
{0x2d97,static_cast<Line_Break>(0)},
{0x2da0,Line_Break::AL},
{0x2da7,static_cast<Line_Break>(0)},
{0x2da8,Line_Break::AL},
{0x2daf,static_cast<Line_Break>(0)},
{0x2db0,Line_Break::AL},
{0x2db7,static_cast<Line_Break>(0)},
{0x2db8,Line_Break::AL},
{0x2dbf,static_cast<Line_Break>(0)},
{0x2dc0,Line_Break::AL},
{0x2dc7,static_cast<Line_Break>(0)},
{0x2dc8,Line_Break::AL},
{0x2dcf,static_cast<Line_Break>(0)},
{0x2dd0,Line_Break::AL},
{0x2dd7,static_cast<Line_Break>(0)},
{0x2dd8,Line_Break::AL},
{0x2ddf,static_cast<Line_Break>(0)},
{0x2de0,Line_Break::CM},
{0x2e00,Line_Break::QU},
{0x2e0e,Line_Break::BA},
{0x2e16,Line_Break::AL},
{0x2e17,Line_Break::BA},
{0x2e18,Line_Break::OP},
{0x2e19,Line_Break::BA},
{0x2e1a,Line_Break::AL},
{0x2e1c,Line_Break::QU},
{0x2e1e,Line_Break::AL},
{0x2e20,Line_Break::QU},
{0x2e22,Line_Break::OP},
{0x2e23,Line_Break::CL},
{0x2e24,Line_Break::OP},
{0x2e25,Line_Break::CL},
{0x2e26,Line_Break::OP},
{0x2e27,Line_Break::CL},
{0x2e28,Line_Break::OP},
{0x2e29,Line_Break::CL},
{0x2e2a,Line_Break::BA},
{0x2e2e,Line_Break::EX},
{0x2e2f,Line_Break::AL},
{0x2e30,Line_Break::BA},
{0x2e32,Line_Break::AL},
{0x2e33,Line_Break::BA},
{0x2e35,Line_Break::AL},
{0x2e3a,Line_Break::B2},
{0x2e3c,Line_Break::BA},
{0x2e3f,Line_Break::AL},
{0x2e40,Line_Break::BA},
{0x2e42,Line_Break::OP},
{0x2e43,static_cast<Line_Break>(0)},
{0x2e80,Line_Break::ID},
{0x2e9a,static_cast<Line_Break>(0)},
{0x2e9b,Line_Break::ID},
{0x2ef4,static_cast<Line_Break>(0)},
{0x2f00,Line_Break::ID},
{0x2fd6,static_cast<Line_Break>(0)},
{0x2ff0,Line_Break::ID},
{0x2ffc,static_cast<Line_Break>(0)},
{0x3000,Line_Break::BA},
{0x3001,Line_Break::CL},
{0x3003,Line_Break::ID},
{0x3005,Line_Break::NS},
{0x3006,Line_Break::ID},
{0x3008,Line_Break::OP},
{0x3009,Line_Break::CL},
{0x300a,Line_Break::OP},
{0x300b,Line_Break::CL},
{0x300c,Line_Break::OP},
{0x300d,Line_Break::CL},
{0x300e,Line_Break::OP},
{0x300f,Line_Break::CL},
{0x3010,Line_Break::OP},
{0x3011,Line_Break::CL},
{0x3012,Line_Break::ID},
{0x3014,Line_Break::OP},
{0x3015,Line_Break::CL},
{0x3016,Line_Break::OP},
{0x3017,Line_Break::CL},
{0x3018,Line_Break::OP},
{0x3019,Line_Break::CL},
{0x301a,Line_Break::OP},
{0x301b,Line_Break::CL},
{0x301c,Line_Break::NS},
{0x301d,Line_Break::OP},
{0x301e,Line_Break::CL},
{0x3020,Line_Break::ID},
{0x302a,Line_Break::CM},
{0x3030,Line_Break::ID},
{0x3035,Line_Break::CM},
{0x3036,Line_Break::ID},
{0x303b,Line_Break::NS},
{0x303d,Line_Break::ID},
{0x3040,static_cast<Line_Break>(0)},
{0x3041,Line_Break::CJ},
{0x3042,Line_Break::ID},
{0x3043,Line_Break::CJ},
{0x3044,Line_Break::ID},
{0x3045,Line_Break::CJ},
{0x3046,Line_Break::ID},
{0x3047,Line_Break::CJ},
{0x3048,Line_Break::ID},
{0x3049,Line_Break::CJ},
{0x304a,Line_Break::ID},
{0x3063,Line_Break::CJ},
{0x3064,Line_Break::ID},
{0x3083,Line_Break::CJ},
{0x3084,Line_Break::ID},
{0x3085,Line_Break::CJ},
{0x3086,Line_Break::ID},
{0x3087,Line_Break::CJ},
{0x3088,Line_Break::ID},
{0x308e,Line_Break::CJ},
{0x308f,Line_Break::ID},
{0x3095,Line_Break::CJ},
{0x3097,static_cast<Line_Break>(0)},
{0x3099,Line_Break::CM},
{0x309b,Line_Break::NS},
{0x309f,Line_Break::ID},
{0x30a0,Line_Break::NS},
{0x30a1,Line_Break::CJ},
{0x30a2,Line_Break::ID},
{0x30a3,Line_Break::CJ},
{0x30a4,Line_Break::ID},
{0x30a5,Line_Break::CJ},
{0x30a6,Line_Break::ID},
{0x30a7,Line_Break::CJ},
{0x30a8,Line_Break::ID},
{0x30a9,Line_Break::CJ},
{0x30aa,Line_Break::ID},
{0x30c3,Line_Break::CJ},
{0x30c4,Line_Break::ID},
{0x30e3,Line_Break::CJ},
{0x30e4,Line_Break::ID},
{0x30e5,Line_Break::CJ},
{0x30e6,Line_Break::ID},
{0x30e7,Line_Break::CJ},
{0x30e8,Line_Break::ID},
{0x30ee,Line_Break::CJ},
{0x30ef,Line_Break::ID},
{0x30f5,Line_Break::CJ},
{0x30f7,Line_Break::ID},
{0x30fb,Line_Break::NS},
{0x30fc,Line_Break::CJ},
{0x30fd,Line_Break::NS},
{0x30ff,Line_Break::ID},
{0x3100,static_cast<Line_Break>(0)},
{0x3105,Line_Break::ID},
{0x312e,static_cast<Line_Break>(0)},
{0x3131,Line_Break::ID},
{0x318f,static_cast<Line_Break>(0)},
{0x3190,Line_Break::ID},
{0x31bb,static_cast<Line_Break>(0)},
{0x31c0,Line_Break::ID},
{0x31e4,static_cast<Line_Break>(0)},
{0x31f0,Line_Break::CJ},
{0x3200,Line_Break::ID},
{0x321f,static_cast<Line_Break>(0)},
{0x3220,Line_Break::ID},
{0x3248,Line_Break::AI},
{0x3250,Line_Break::ID},
{0x32ff,static_cast<Line_Break>(0)},
{0x3300,Line_Break::ID},
{0x4dc0,Line_Break::AL},
{0x4e00,Line_Break::ID},
{0xa015,Line_Break::NS},
{0xa016,Line_Break::ID},
{0xa48d,static_cast<Line_Break>(0)},
{0xa490,Line_Break::ID},
{0xa4c7,static_cast<Line_Break>(0)},
{0xa4d0,Line_Break::AL},
{0xa4fe,Line_Break::BA},
{0xa500,Line_Break::AL},
{0xa60d,Line_Break::BA},
{0xa60e,Line_Break::EX},
{0xa60f,Line_Break::BA},
{0xa610,Line_Break::AL},
{0xa620,Line_Break::NU},
{0xa62a,Line_Break::AL},
{0xa62c,static_cast<Line_Break>(0)},
{0xa640,Line_Break::AL},
{0xa66f,Line_Break::CM},
{0xa673,Line_Break::AL},
{0xa674,Line_Break::CM},
{0xa67e,Line_Break::AL},
{0xa69e,Line_Break::CM},
{0xa6a0,Line_Break::AL},
{0xa6f0,Line_Break::CM},
{0xa6f2,Line_Break::AL},
{0xa6f3,Line_Break::BA},
{0xa6f8,static_cast<Line_Break>(0)},
{0xa700,Line_Break::AL},
{0xa7ae,static_cast<Line_Break>(0)},
{0xa7b0,Line_Break::AL},
{0xa7b8,static_cast<Line_Break>(0)},
{0xa7f7,Line_Break::AL},
{0xa802,Line_Break::CM},
{0xa803,Line_Break::AL},
{0xa806,Line_Break::CM},
{0xa807,Line_Break::AL},
{0xa80b,Line_Break::CM},
{0xa80c,Line_Break::AL},
{0xa823,Line_Break::CM},
{0xa828,Line_Break::AL},
{0xa82c,static_cast<Line_Break>(0)},
{0xa830,Line_Break::AL},
{0xa838,Line_Break::PO},
{0xa839,Line_Break::AL},
{0xa83a,static_cast<Line_Break>(0)},
{0xa840,Line_Break::AL},
{0xa874,Line_Break::BB},
{0xa876,Line_Break::EX},
{0xa878,static_cast<Line_Break>(0)},
{0xa880,Line_Break::CM},
{0xa882,Line_Break::AL},
{0xa8b4,Line_Break::CM},
{0xa8c5,static_cast<Line_Break>(0)},
{0xa8ce,Line_Break::BA},
{0xa8d0,Line_Break::NU},
{0xa8da,static_cast<Line_Break>(0)},
{0xa8e0,Line_Break::CM},
{0xa8f2,Line_Break::AL},
{0xa8fc,Line_Break::BB},
{0xa8fd,Line_Break::AL},
{0xa8fe,static_cast<Line_Break>(0)},
{0xa900,Line_Break::NU},
{0xa90a,Line_Break::AL},
{0xa926,Line_Break::CM},
{0xa92e,Line_Break::BA},
{0xa930,Line_Break::AL},
{0xa947,Line_Break::CM},
{0xa954,static_cast<Line_Break>(0)},
{0xa95f,Line_Break::AL},
{0xa960,Line_Break::JL},
{0xa97d,static_cast<Line_Break>(0)},
{0xa980,Line_Break::CM},
{0xa984,Line_Break::AL},
{0xa9b3,Line_Break::CM},
{0xa9c1,Line_Break::AL},
{0xa9c7,Line_Break::BA},
{0xa9ca,Line_Break::AL},
{0xa9ce,static_cast<Line_Break>(0)},
{0xa9cf,Line_Break::AL},
{0xa9d0,Line_Break::NU},
{0xa9da,static_cast<Line_Break>(0)},
{0xa9de,Line_Break::AL},
{0xa9e0,Line_Break::SA},
{0xa9f0,Line_Break::NU},
{0xa9fa,Line_Break::SA},
{0xa9ff,static_cast<Line_Break>(0)},
{0xaa00,Line_Break::AL},
{0xaa29,Line_Break::CM},
{0xaa37,static_cast<Line_Break>(0)},
{0xaa40,Line_Break::AL},
{0xaa43,Line_Break::CM},
{0xaa44,Line_Break::AL},
{0xaa4c,Line_Break::CM},
{0xaa4e,static_cast<Line_Break>(0)},
{0xaa50,Line_Break::NU},
{0xaa5a,static_cast<Line_Break>(0)},
{0xaa5c,Line_Break::AL},
{0xaa5d,Line_Break::BA},
{0xaa60,Line_Break::SA},
{0xaac3,static_cast<Line_Break>(0)},
{0xaadb,Line_Break::SA},
{0xaae0,Line_Break::AL},
{0xaaeb,Line_Break::CM},
{0xaaf0,Line_Break::BA},
{0xaaf2,Line_Break::AL},
{0xaaf5,Line_Break::CM},
{0xaaf7,static_cast<Line_Break>(0)},
{0xab01,Line_Break::AL},
{0xab07,static_cast<Line_Break>(0)},
{0xab09,Line_Break::AL},
{0xab0f,static_cast<Line_Break>(0)},
{0xab11,Line_Break::AL},
{0xab17,static_cast<Line_Break>(0)},
{0xab20,Line_Break::AL},
{0xab27,static_cast<Line_Break>(0)},
{0xab28,Line_Break::AL},
{0xab2f,static_cast<Line_Break>(0)},
{0xab30,Line_Break::AL},
{0xab66,static_cast<Line_Break>(0)},
{0xab70,Line_Break::AL},
{0xabe3,Line_Break::CM},
{0xabeb,Line_Break::BA},
{0xabec,Line_Break::CM},
{0xabee,static_cast<Line_Break>(0)},
{0xabf0,Line_Break::NU},
{0xabfa,static_cast<Line_Break>(0)},
{0xac00,Line_Break::H2},
{0xac01,Line_Break::H3},
{0xac1c,Line_Break::H2},
{0xac1d,Line_Break::H3},
{0xac38,Line_Break::H2},
{0xac39,Line_Break::H3},
{0xac54,Line_Break::H2},
{0xac55,Line_Break::H3},
{0xac70,Line_Break::H2},
{0xac71,Line_Break::H3},
{0xac8c,Line_Break::H2},
{0xac8d,Line_Break::H3},
{0xaca8,Line_Break::H2},
{0xaca9,Line_Break::H3},
{0xacc4,Line_Break::H2},
{0xacc5,Line_Break::H3},
{0xace0,Line_Break::H2},
{0xace1,Line_Break::H3},
{0xacfc,Line_Break::H2},
{0xacfd,Line_Break::H3},
{0xad18,Line_Break::H2},
{0xad19,Line_Break::H3},
{0xad34,Line_Break::H2},
{0xad35,Line_Break::H3},
{0xad50,Line_Break::H2},
{0xad51,Line_Break::H3},
{0xad6c,Line_Break::H2},
{0xad6d,Line_Break::H3},
{0xad88,Line_Break::H2},
{0xad89,Line_Break::H3},
{0xada4,Line_Break::H2},
{0xada5,Line_Break::H3},
{0xadc0,Line_Break::H2},
{0xadc1,Line_Break::H3},
{0xaddc,Line_Break::H2},
{0xaddd,Line_Break::H3},
{0xadf8,Line_Break::H2},
{0xadf9,Line_Break::H3},
{0xae14,Line_Break::H2},
{0xae15,Line_Break::H3},
{0xae30,Line_Break::H2},
{0xae31,Line_Break::H3},
{0xae4c,Line_Break::H2},
{0xae4d,Line_Break::H3},
{0xae68,Line_Break::H2},
{0xae69,Line_Break::H3},
{0xae84,Line_Break::H2},
{0xae85,Line_Break::H3},
{0xaea0,Line_Break::H2},
{0xaea1,Line_Break::H3},
{0xaebc,Line_Break::H2},
{0xaebd,Line_Break::H3},
{0xaed8,Line_Break::H2},
{0xaed9,Line_Break::H3},
{0xaef4,Line_Break::H2},
{0xaef5,Line_Break::H3},
{0xaf10,Line_Break::H2},
{0xaf11,Line_Break::H3},
{0xaf2c,Line_Break::H2},
{0xaf2d,Line_Break::H3},
{0xaf48,Line_Break::H2},
{0xaf49,Line_Break::H3},
{0xaf64,Line_Break::H2},
{0xaf65,Line_Break::H3},
{0xaf80,Line_Break::H2},
{0xaf81,Line_Break::H3},
{0xaf9c,Line_Break::H2},
{0xaf9d,Line_Break::H3},
{0xafb8,Line_Break::H2},
{0xafb9,Line_Break::H3},
{0xafd4,Line_Break::H2},
{0xafd5,Line_Break::H3},
{0xaff0,Line_Break::H2},
{0xaff1,Line_Break::H3},
{0xb00c,Line_Break::H2},
{0xb00d,Line_Break::H3},
{0xb028,Line_Break::H2},
{0xb029,Line_Break::H3},
{0xb044,Line_Break::H2},
{0xb045,Line_Break::H3},
{0xb060,Line_Break::H2},
{0xb061,Line_Break::H3},
{0xb07c,Line_Break::H2},
{0xb07d,Line_Break::H3},
{0xb098,Line_Break::H2},
{0xb099,Line_Break::H3},
{0xb0b4,Line_Break::H2},
{0xb0b5,Line_Break::H3},
{0xb0d0,Line_Break::H2},
{0xb0d1,Line_Break::H3},
{0xb0ec,Line_Break::H2},
{0xb0ed,Line_Break::H3},
{0xb108,Line_Break::H2},
{0xb109,Line_Break::H3},
{0xb124,Line_Break::H2},
{0xb125,Line_Break::H3},
{0xb140,Line_Break::H2},
{0xb141,Line_Break::H3},
{0xb15c,Line_Break::H2},
{0xb15d,Line_Break::H3},
{0xb178,Line_Break::H2},
{0xb179,Line_Break::H3},
{0xb194,Line_Break::H2},
{0xb195,Line_Break::H3},
{0xb1b0,Line_Break::H2},
{0xb1b1,Line_Break::H3},
{0xb1cc,Line_Break::H2},
{0xb1cd,Line_Break::H3},
{0xb1e8,Line_Break::H2},
{0xb1e9,Line_Break::H3},
{0xb204,Line_Break::H2},
{0xb205,Line_Break::H3},
{0xb220,Line_Break::H2},
{0xb221,Line_Break::H3},
{0xb23c,Line_Break::H2},
{0xb23d,Line_Break::H3},
{0xb258,Line_Break::H2},
{0xb259,Line_Break::H3},
{0xb274,Line_Break::H2},
{0xb275,Line_Break::H3},
{0xb290,Line_Break::H2},
{0xb291,Line_Break::H3},
{0xb2ac,Line_Break::H2},
{0xb2ad,Line_Break::H3},
{0xb2c8,Line_Break::H2},
{0xb2c9,Line_Break::H3},
{0xb2e4,Line_Break::H2},
{0xb2e5,Line_Break::H3},
{0xb300,Line_Break::H2},
{0xb301,Line_Break::H3},
{0xb31c,Line_Break::H2},
{0xb31d,Line_Break::H3},
{0xb338,Line_Break::H2},
{0xb339,Line_Break::H3},
{0xb354,Line_Break::H2},
{0xb355,Line_Break::H3},
{0xb370,Line_Break::H2},
{0xb371,Line_Break::H3},
{0xb38c,Line_Break::H2},
{0xb38d,Line_Break::H3},
{0xb3a8,Line_Break::H2},
{0xb3a9,Line_Break::H3},
{0xb3c4,Line_Break::H2},
{0xb3c5,Line_Break::H3},
{0xb3e0,Line_Break::H2},
{0xb3e1,Line_Break::H3},
{0xb3fc,Line_Break::H2},
{0xb3fd,Line_Break::H3},
{0xb418,Line_Break::H2},
{0xb419,Line_Break::H3},
{0xb434,Line_Break::H2},
{0xb435,Line_Break::H3},
{0xb450,Line_Break::H2},
{0xb451,Line_Break::H3},
{0xb46c,Line_Break::H2},
{0xb46d,Line_Break::H3},
{0xb488,Line_Break::H2},
{0xb489,Line_Break::H3},
{0xb4a4,Line_Break::H2},
{0xb4a5,Line_Break::H3},
{0xb4c0,Line_Break::H2},
{0xb4c1,Line_Break::H3},
{0xb4dc,Line_Break::H2},
{0xb4dd,Line_Break::H3},
{0xb4f8,Line_Break::H2},
{0xb4f9,Line_Break::H3},
{0xb514,Line_Break::H2},
{0xb515,Line_Break::H3},
{0xb530,Line_Break::H2},
{0xb531,Line_Break::H3},
{0xb54c,Line_Break::H2},
{0xb54d,Line_Break::H3},
{0xb568,Line_Break::H2},
{0xb569,Line_Break::H3},
{0xb584,Line_Break::H2},
{0xb585,Line_Break::H3},
{0xb5a0,Line_Break::H2},
{0xb5a1,Line_Break::H3},
{0xb5bc,Line_Break::H2},
{0xb5bd,Line_Break::H3},
{0xb5d8,Line_Break::H2},
{0xb5d9,Line_Break::H3},
{0xb5f4,Line_Break::H2},
{0xb5f5,Line_Break::H3},
{0xb610,Line_Break::H2},
{0xb611,Line_Break::H3},
{0xb62c,Line_Break::H2},
{0xb62d,Line_Break::H3},
{0xb648,Line_Break::H2},
{0xb649,Line_Break::H3},
{0xb664,Line_Break::H2},
{0xb665,Line_Break::H3},
{0xb680,Line_Break::H2},
{0xb681,Line_Break::H3},
{0xb69c,Line_Break::H2},
{0xb69d,Line_Break::H3},
{0xb6b8,Line_Break::H2},
{0xb6b9,Line_Break::H3},
{0xb6d4,Line_Break::H2},
{0xb6d5,Line_Break::H3},
{0xb6f0,Line_Break::H2},
{0xb6f1,Line_Break::H3},
{0xb70c,Line_Break::H2},
{0xb70d,Line_Break::H3},
{0xb728,Line_Break::H2},
{0xb729,Line_Break::H3},
{0xb744,Line_Break::H2},
{0xb745,Line_Break::H3},
{0xb760,Line_Break::H2},
{0xb761,Line_Break::H3},
{0xb77c,Line_Break::H2},
{0xb77d,Line_Break::H3},
{0xb798,Line_Break::H2},
{0xb799,Line_Break::H3},
{0xb7b4,Line_Break::H2},
{0xb7b5,Line_Break::H3},
{0xb7d0,Line_Break::H2},
{0xb7d1,Line_Break::H3},
{0xb7ec,Line_Break::H2},
{0xb7ed,Line_Break::H3},
{0xb808,Line_Break::H2},
{0xb809,Line_Break::H3},
{0xb824,Line_Break::H2},
{0xb825,Line_Break::H3},
{0xb840,Line_Break::H2},
{0xb841,Line_Break::H3},
{0xb85c,Line_Break::H2},
{0xb85d,Line_Break::H3},
{0xb878,Line_Break::H2},
{0xb879,Line_Break::H3},
{0xb894,Line_Break::H2},
{0xb895,Line_Break::H3},
{0xb8b0,Line_Break::H2},
{0xb8b1,Line_Break::H3},
{0xb8cc,Line_Break::H2},
{0xb8cd,Line_Break::H3},
{0xb8e8,Line_Break::H2},
{0xb8e9,Line_Break::H3},
{0xb904,Line_Break::H2},
{0xb905,Line_Break::H3},
{0xb920,Line_Break::H2},
{0xb921,Line_Break::H3},
{0xb93c,Line_Break::H2},
{0xb93d,Line_Break::H3},
{0xb958,Line_Break::H2},
{0xb959,Line_Break::H3},
{0xb974,Line_Break::H2},
{0xb975,Line_Break::H3},
{0xb990,Line_Break::H2},
{0xb991,Line_Break::H3},
{0xb9ac,Line_Break::H2},
{0xb9ad,Line_Break::H3},
{0xb9c8,Line_Break::H2},
{0xb9c9,Line_Break::H3},
{0xb9e4,Line_Break::H2},
{0xb9e5,Line_Break::H3},
{0xba00,Line_Break::H2},
{0xba01,Line_Break::H3},
{0xba1c,Line_Break::H2},
{0xba1d,Line_Break::H3},
{0xba38,Line_Break::H2},
{0xba39,Line_Break::H3},
{0xba54,Line_Break::H2},
{0xba55,Line_Break::H3},
{0xba70,Line_Break::H2},
{0xba71,Line_Break::H3},
{0xba8c,Line_Break::H2},
{0xba8d,Line_Break::H3},
{0xbaa8,Line_Break::H2},
{0xbaa9,Line_Break::H3},
{0xbac4,Line_Break::H2},
{0xbac5,Line_Break::H3},
{0xbae0,Line_Break::H2},
{0xbae1,Line_Break::H3},
{0xbafc,Line_Break::H2},
{0xbafd,Line_Break::H3},
{0xbb18,Line_Break::H2},
{0xbb19,Line_Break::H3},
{0xbb34,Line_Break::H2},
{0xbb35,Line_Break::H3},
{0xbb50,Line_Break::H2},
{0xbb51,Line_Break::H3},
{0xbb6c,Line_Break::H2},
{0xbb6d,Line_Break::H3},
{0xbb88,Line_Break::H2},
{0xbb89,Line_Break::H3},
{0xbba4,Line_Break::H2},
{0xbba5,Line_Break::H3},
{0xbbc0,Line_Break::H2},
{0xbbc1,Line_Break::H3},
{0xbbdc,Line_Break::H2},
{0xbbdd,Line_Break::H3},
{0xbbf8,Line_Break::H2},
{0xbbf9,Line_Break::H3},
{0xbc14,Line_Break::H2},
{0xbc15,Line_Break::H3},
{0xbc30,Line_Break::H2},
{0xbc31,Line_Break::H3},
{0xbc4c,Line_Break::H2},
{0xbc4d,Line_Break::H3},
{0xbc68,Line_Break::H2},
{0xbc69,Line_Break::H3},
{0xbc84,Line_Break::H2},
{0xbc85,Line_Break::H3},
{0xbca0,Line_Break::H2},
{0xbca1,Line_Break::H3},
{0xbcbc,Line_Break::H2},
{0xbcbd,Line_Break::H3},
{0xbcd8,Line_Break::H2},
{0xbcd9,Line_Break::H3},
{0xbcf4,Line_Break::H2},
{0xbcf5,Line_Break::H3},
{0xbd10,Line_Break::H2},
{0xbd11,Line_Break::H3},
{0xbd2c,Line_Break::H2},
{0xbd2d,Line_Break::H3},
{0xbd48,Line_Break::H2},
{0xbd49,Line_Break::H3},
{0xbd64,Line_Break::H2},
{0xbd65,Line_Break::H3},
{0xbd80,Line_Break::H2},
{0xbd81,Line_Break::H3},
{0xbd9c,Line_Break::H2},
{0xbd9d,Line_Break::H3},
{0xbdb8,Line_Break::H2},
{0xbdb9,Line_Break::H3},
{0xbdd4,Line_Break::H2},
{0xbdd5,Line_Break::H3},
{0xbdf0,Line_Break::H2},
{0xbdf1,Line_Break::H3},
{0xbe0c,Line_Break::H2},
{0xbe0d,Line_Break::H3},
{0xbe28,Line_Break::H2},
{0xbe29,Line_Break::H3},
{0xbe44,Line_Break::H2},
{0xbe45,Line_Break::H3},
{0xbe60,Line_Break::H2},
{0xbe61,Line_Break::H3},
{0xbe7c,Line_Break::H2},
{0xbe7d,Line_Break::H3},
{0xbe98,Line_Break::H2},
{0xbe99,Line_Break::H3},
{0xbeb4,Line_Break::H2},
{0xbeb5,Line_Break::H3},
{0xbed0,Line_Break::H2},
{0xbed1,Line_Break::H3},
{0xbeec,Line_Break::H2},
{0xbeed,Line_Break::H3},
{0xbf08,Line_Break::H2},
{0xbf09,Line_Break::H3},
{0xbf24,Line_Break::H2},
{0xbf25,Line_Break::H3},
{0xbf40,Line_Break::H2},
{0xbf41,Line_Break::H3},
{0xbf5c,Line_Break::H2},
{0xbf5d,Line_Break::H3},
{0xbf78,Line_Break::H2},
{0xbf79,Line_Break::H3},
{0xbf94,Line_Break::H2},
{0xbf95,Line_Break::H3},
{0xbfb0,Line_Break::H2},
{0xbfb1,Line_Break::H3},
{0xbfcc,Line_Break::H2},
{0xbfcd,Line_Break::H3},
{0xbfe8,Line_Break::H2},
{0xbfe9,Line_Break::H3},
{0xc004,Line_Break::H2},
{0xc005,Line_Break::H3},
{0xc020,Line_Break::H2},
{0xc021,Line_Break::H3},
{0xc03c,Line_Break::H2},
{0xc03d,Line_Break::H3},
{0xc058,Line_Break::H2},
{0xc059,Line_Break::H3},
{0xc074,Line_Break::H2},
{0xc075,Line_Break::H3},
{0xc090,Line_Break::H2},
{0xc091,Line_Break::H3},
{0xc0ac,Line_Break::H2},
{0xc0ad,Line_Break::H3},
{0xc0c8,Line_Break::H2},
{0xc0c9,Line_Break::H3},
{0xc0e4,Line_Break::H2},
{0xc0e5,Line_Break::H3},
{0xc100,Line_Break::H2},
{0xc101,Line_Break::H3},
{0xc11c,Line_Break::H2},
{0xc11d,Line_Break::H3},
{0xc138,Line_Break::H2},
{0xc139,Line_Break::H3},
{0xc154,Line_Break::H2},
{0xc155,Line_Break::H3},
{0xc170,Line_Break::H2},
{0xc171,Line_Break::H3},
{0xc18c,Line_Break::H2},
{0xc18d,Line_Break::H3},
{0xc1a8,Line_Break::H2},
{0xc1a9,Line_Break::H3},
{0xc1c4,Line_Break::H2},
{0xc1c5,Line_Break::H3},
{0xc1e0,Line_Break::H2},
{0xc1e1,Line_Break::H3},
{0xc1fc,Line_Break::H2},
{0xc1fd,Line_Break::H3},
{0xc218,Line_Break::H2},
{0xc219,Line_Break::H3},
{0xc234,Line_Break::H2},
{0xc235,Line_Break::H3},
{0xc250,Line_Break::H2},
{0xc251,Line_Break::H3},
{0xc26c,Line_Break::H2},
{0xc26d,Line_Break::H3},
{0xc288,Line_Break::H2},
{0xc289,Line_Break::H3},
{0xc2a4,Line_Break::H2},
{0xc2a5,Line_Break::H3},
{0xc2c0,Line_Break::H2},
{0xc2c1,Line_Break::H3},
{0xc2dc,Line_Break::H2},
{0xc2dd,Line_Break::H3},
{0xc2f8,Line_Break::H2},
{0xc2f9,Line_Break::H3},
{0xc314,Line_Break::H2},
{0xc315,Line_Break::H3},
{0xc330,Line_Break::H2},
{0xc331,Line_Break::H3},
{0xc34c,Line_Break::H2},
{0xc34d,Line_Break::H3},
{0xc368,Line_Break::H2},
{0xc369,Line_Break::H3},
{0xc384,Line_Break::H2},
{0xc385,Line_Break::H3},
{0xc3a0,Line_Break::H2},
{0xc3a1,Line_Break::H3},
{0xc3bc,Line_Break::H2},
{0xc3bd,Line_Break::H3},
{0xc3d8,Line_Break::H2},
{0xc3d9,Line_Break::H3},
{0xc3f4,Line_Break::H2},
{0xc3f5,Line_Break::H3},
{0xc410,Line_Break::H2},
{0xc411,Line_Break::H3},
{0xc42c,Line_Break::H2},
{0xc42d,Line_Break::H3},
{0xc448,Line_Break::H2},
{0xc449,Line_Break::H3},
{0xc464,Line_Break::H2},
{0xc465,Line_Break::H3},
{0xc480,Line_Break::H2},
{0xc481,Line_Break::H3},
{0xc49c,Line_Break::H2},
{0xc49d,Line_Break::H3},
{0xc4b8,Line_Break::H2},
{0xc4b9,Line_Break::H3},
{0xc4d4,Line_Break::H2},
{0xc4d5,Line_Break::H3},
{0xc4f0,Line_Break::H2},
{0xc4f1,Line_Break::H3},
{0xc50c,Line_Break::H2},
{0xc50d,Line_Break::H3},
{0xc528,Line_Break::H2},
{0xc529,Line_Break::H3},
{0xc544,Line_Break::H2},
{0xc545,Line_Break::H3},
{0xc560,Line_Break::H2},
{0xc561,Line_Break::H3},
{0xc57c,Line_Break::H2},
{0xc57d,Line_Break::H3},
{0xc598,Line_Break::H2},
{0xc599,Line_Break::H3},
{0xc5b4,Line_Break::H2},
{0xc5b5,Line_Break::H3},
{0xc5d0,Line_Break::H2},
{0xc5d1,Line_Break::H3},
{0xc5ec,Line_Break::H2},
{0xc5ed,Line_Break::H3},
{0xc608,Line_Break::H2},
{0xc609,Line_Break::H3},
{0xc624,Line_Break::H2},
{0xc625,Line_Break::H3},
{0xc640,Line_Break::H2},
{0xc641,Line_Break::H3},
{0xc65c,Line_Break::H2},
{0xc65d,Line_Break::H3},
{0xc678,Line_Break::H2},
{0xc679,Line_Break::H3},
{0xc694,Line_Break::H2},
{0xc695,Line_Break::H3},
{0xc6b0,Line_Break::H2},
{0xc6b1,Line_Break::H3},
{0xc6cc,Line_Break::H2},
{0xc6cd,Line_Break::H3},
{0xc6e8,Line_Break::H2},
{0xc6e9,Line_Break::H3},
{0xc704,Line_Break::H2},
{0xc705,Line_Break::H3},
{0xc720,Line_Break::H2},
{0xc721,Line_Break::H3},
{0xc73c,Line_Break::H2},
{0xc73d,Line_Break::H3},
{0xc758,Line_Break::H2},
{0xc759,Line_Break::H3},
{0xc774,Line_Break::H2},
{0xc775,Line_Break::H3},
{0xc790,Line_Break::H2},
{0xc791,Line_Break::H3},
{0xc7ac,Line_Break::H2},
{0xc7ad,Line_Break::H3},
{0xc7c8,Line_Break::H2},
{0xc7c9,Line_Break::H3},
{0xc7e4,Line_Break::H2},
{0xc7e5,Line_Break::H3},
{0xc800,Line_Break::H2},
{0xc801,Line_Break::H3},
{0xc81c,Line_Break::H2},
{0xc81d,Line_Break::H3},
{0xc838,Line_Break::H2},
{0xc839,Line_Break::H3},
{0xc854,Line_Break::H2},
{0xc855,Line_Break::H3},
{0xc870,Line_Break::H2},
{0xc871,Line_Break::H3},
{0xc88c,Line_Break::H2},
{0xc88d,Line_Break::H3},
{0xc8a8,Line_Break::H2},
{0xc8a9,Line_Break::H3},
{0xc8c4,Line_Break::H2},
{0xc8c5,Line_Break::H3},
{0xc8e0,Line_Break::H2},
{0xc8e1,Line_Break::H3},
{0xc8fc,Line_Break::H2},
{0xc8fd,Line_Break::H3},
{0xc918,Line_Break::H2},
{0xc919,Line_Break::H3},
{0xc934,Line_Break::H2},
{0xc935,Line_Break::H3},
{0xc950,Line_Break::H2},
{0xc951,Line_Break::H3},
{0xc96c,Line_Break::H2},
{0xc96d,Line_Break::H3},
{0xc988,Line_Break::H2},
{0xc989,Line_Break::H3},
{0xc9a4,Line_Break::H2},
{0xc9a5,Line_Break::H3},
{0xc9c0,Line_Break::H2},
{0xc9c1,Line_Break::H3},
{0xc9dc,Line_Break::H2},
{0xc9dd,Line_Break::H3},
{0xc9f8,Line_Break::H2},
{0xc9f9,Line_Break::H3},
{0xca14,Line_Break::H2},
{0xca15,Line_Break::H3},
{0xca30,Line_Break::H2},
{0xca31,Line_Break::H3},
{0xca4c,Line_Break::H2},
{0xca4d,Line_Break::H3},
{0xca68,Line_Break::H2},
{0xca69,Line_Break::H3},
{0xca84,Line_Break::H2},
{0xca85,Line_Break::H3},
{0xcaa0,Line_Break::H2},
{0xcaa1,Line_Break::H3},
{0xcabc,Line_Break::H2},
{0xcabd,Line_Break::H3},
{0xcad8,Line_Break::H2},
{0xcad9,Line_Break::H3},
{0xcaf4,Line_Break::H2},
{0xcaf5,Line_Break::H3},
{0xcb10,Line_Break::H2},
{0xcb11,Line_Break::H3},
{0xcb2c,Line_Break::H2},
{0xcb2d,Line_Break::H3},
{0xcb48,Line_Break::H2},
{0xcb49,Line_Break::H3},
{0xcb64,Line_Break::H2},
{0xcb65,Line_Break::H3},
{0xcb80,Line_Break::H2},
{0xcb81,Line_Break::H3},
{0xcb9c,Line_Break::H2},
{0xcb9d,Line_Break::H3},
{0xcbb8,Line_Break::H2},
{0xcbb9,Line_Break::H3},
{0xcbd4,Line_Break::H2},
{0xcbd5,Line_Break::H3},
{0xcbf0,Line_Break::H2},
{0xcbf1,Line_Break::H3},
{0xcc0c,Line_Break::H2},
{0xcc0d,Line_Break::H3},
{0xcc28,Line_Break::H2},
{0xcc29,Line_Break::H3},
{0xcc44,Line_Break::H2},
{0xcc45,Line_Break::H3},
{0xcc60,Line_Break::H2},
{0xcc61,Line_Break::H3},
{0xcc7c,Line_Break::H2},
{0xcc7d,Line_Break::H3},
{0xcc98,Line_Break::H2},
{0xcc99,Line_Break::H3},
{0xccb4,Line_Break::H2},
{0xccb5,Line_Break::H3},
{0xccd0,Line_Break::H2},
{0xccd1,Line_Break::H3},
{0xccec,Line_Break::H2},
{0xcced,Line_Break::H3},
{0xcd08,Line_Break::H2},
{0xcd09,Line_Break::H3},
{0xcd24,Line_Break::H2},
{0xcd25,Line_Break::H3},
{0xcd40,Line_Break::H2},
{0xcd41,Line_Break::H3},
{0xcd5c,Line_Break::H2},
{0xcd5d,Line_Break::H3},
{0xcd78,Line_Break::H2},
{0xcd79,Line_Break::H3},
{0xcd94,Line_Break::H2},
{0xcd95,Line_Break::H3},
{0xcdb0,Line_Break::H2},
{0xcdb1,Line_Break::H3},
{0xcdcc,Line_Break::H2},
{0xcdcd,Line_Break::H3},
{0xcde8,Line_Break::H2},
{0xcde9,Line_Break::H3},
{0xce04,Line_Break::H2},
{0xce05,Line_Break::H3},
{0xce20,Line_Break::H2},
{0xce21,Line_Break::H3},
{0xce3c,Line_Break::H2},
{0xce3d,Line_Break::H3},
{0xce58,Line_Break::H2},
{0xce59,Line_Break::H3},
{0xce74,Line_Break::H2},
{0xce75,Line_Break::H3},
{0xce90,Line_Break::H2},
{0xce91,Line_Break::H3},
{0xceac,Line_Break::H2},
{0xcead,Line_Break::H3},
{0xcec8,Line_Break::H2},
{0xcec9,Line_Break::H3},
{0xcee4,Line_Break::H2},
{0xcee5,Line_Break::H3},
{0xcf00,Line_Break::H2},
{0xcf01,Line_Break::H3},
{0xcf1c,Line_Break::H2},
{0xcf1d,Line_Break::H3},
{0xcf38,Line_Break::H2},
{0xcf39,Line_Break::H3},
{0xcf54,Line_Break::H2},
{0xcf55,Line_Break::H3},
{0xcf70,Line_Break::H2},
{0xcf71,Line_Break::H3},
{0xcf8c,Line_Break::H2},
{0xcf8d,Line_Break::H3},
{0xcfa8,Line_Break::H2},
{0xcfa9,Line_Break::H3},
{0xcfc4,Line_Break::H2},
{0xcfc5,Line_Break::H3},
{0xcfe0,Line_Break::H2},
{0xcfe1,Line_Break::H3},
{0xcffc,Line_Break::H2},
{0xcffd,Line_Break::H3},
{0xd018,Line_Break::H2},
{0xd019,Line_Break::H3},
{0xd034,Line_Break::H2},
{0xd035,Line_Break::H3},
{0xd050,Line_Break::H2},
{0xd051,Line_Break::H3},
{0xd06c,Line_Break::H2},
{0xd06d,Line_Break::H3},
{0xd088,Line_Break::H2},
{0xd089,Line_Break::H3},
{0xd0a4,Line_Break::H2},
{0xd0a5,Line_Break::H3},
{0xd0c0,Line_Break::H2},
{0xd0c1,Line_Break::H3},
{0xd0dc,Line_Break::H2},
{0xd0dd,Line_Break::H3},
{0xd0f8,Line_Break::H2},
{0xd0f9,Line_Break::H3},
{0xd114,Line_Break::H2},
{0xd115,Line_Break::H3},
{0xd130,Line_Break::H2},
{0xd131,Line_Break::H3},
{0xd14c,Line_Break::H2},
{0xd14d,Line_Break::H3},
{0xd168,Line_Break::H2},
{0xd169,Line_Break::H3},
{0xd184,Line_Break::H2},
{0xd185,Line_Break::H3},
{0xd1a0,Line_Break::H2},
{0xd1a1,Line_Break::H3},
{0xd1bc,Line_Break::H2},
{0xd1bd,Line_Break::H3},
{0xd1d8,Line_Break::H2},
{0xd1d9,Line_Break::H3},
{0xd1f4,Line_Break::H2},
{0xd1f5,Line_Break::H3},
{0xd210,Line_Break::H2},
{0xd211,Line_Break::H3},
{0xd22c,Line_Break::H2},
{0xd22d,Line_Break::H3},
{0xd248,Line_Break::H2},
{0xd249,Line_Break::H3},
{0xd264,Line_Break::H2},
{0xd265,Line_Break::H3},
{0xd280,Line_Break::H2},
{0xd281,Line_Break::H3},
{0xd29c,Line_Break::H2},
{0xd29d,Line_Break::H3},
{0xd2b8,Line_Break::H2},
{0xd2b9,Line_Break::H3},
{0xd2d4,Line_Break::H2},
{0xd2d5,Line_Break::H3},
{0xd2f0,Line_Break::H2},
{0xd2f1,Line_Break::H3},
{0xd30c,Line_Break::H2},
{0xd30d,Line_Break::H3},
{0xd328,Line_Break::H2},
{0xd329,Line_Break::H3},
{0xd344,Line_Break::H2},
{0xd345,Line_Break::H3},
{0xd360,Line_Break::H2},
{0xd361,Line_Break::H3},
{0xd37c,Line_Break::H2},
{0xd37d,Line_Break::H3},
{0xd398,Line_Break::H2},
{0xd399,Line_Break::H3},
{0xd3b4,Line_Break::H2},
{0xd3b5,Line_Break::H3},
{0xd3d0,Line_Break::H2},
{0xd3d1,Line_Break::H3},
{0xd3ec,Line_Break::H2},
{0xd3ed,Line_Break::H3},
{0xd408,Line_Break::H2},
{0xd409,Line_Break::H3},
{0xd424,Line_Break::H2},
{0xd425,Line_Break::H3},
{0xd440,Line_Break::H2},
{0xd441,Line_Break::H3},
{0xd45c,Line_Break::H2},
{0xd45d,Line_Break::H3},
{0xd478,Line_Break::H2},
{0xd479,Line_Break::H3},
{0xd494,Line_Break::H2},
{0xd495,Line_Break::H3},
{0xd4b0,Line_Break::H2},
{0xd4b1,Line_Break::H3},
{0xd4cc,Line_Break::H2},
{0xd4cd,Line_Break::H3},
{0xd4e8,Line_Break::H2},
{0xd4e9,Line_Break::H3},
{0xd504,Line_Break::H2},
{0xd505,Line_Break::H3},
{0xd520,Line_Break::H2},
{0xd521,Line_Break::H3},
{0xd53c,Line_Break::H2},
{0xd53d,Line_Break::H3},
{0xd558,Line_Break::H2},
{0xd559,Line_Break::H3},
{0xd574,Line_Break::H2},
{0xd575,Line_Break::H3},
{0xd590,Line_Break::H2},
{0xd591,Line_Break::H3},
{0xd5ac,Line_Break::H2},
{0xd5ad,Line_Break::H3},
{0xd5c8,Line_Break::H2},
{0xd5c9,Line_Break::H3},
{0xd5e4,Line_Break::H2},
{0xd5e5,Line_Break::H3},
{0xd600,Line_Break::H2},
{0xd601,Line_Break::H3},
{0xd61c,Line_Break::H2},
{0xd61d,Line_Break::H3},
{0xd638,Line_Break::H2},
{0xd639,Line_Break::H3},
{0xd654,Line_Break::H2},
{0xd655,Line_Break::H3},
{0xd670,Line_Break::H2},
{0xd671,Line_Break::H3},
{0xd68c,Line_Break::H2},
{0xd68d,Line_Break::H3},
{0xd6a8,Line_Break::H2},
{0xd6a9,Line_Break::H3},
{0xd6c4,Line_Break::H2},
{0xd6c5,Line_Break::H3},
{0xd6e0,Line_Break::H2},
{0xd6e1,Line_Break::H3},
{0xd6fc,Line_Break::H2},
{0xd6fd,Line_Break::H3},
{0xd718,Line_Break::H2},
{0xd719,Line_Break::H3},
{0xd734,Line_Break::H2},
{0xd735,Line_Break::H3},
{0xd750,Line_Break::H2},
{0xd751,Line_Break::H3},
{0xd76c,Line_Break::H2},
{0xd76d,Line_Break::H3},
{0xd788,Line_Break::H2},
{0xd789,Line_Break::H3},
{0xd7a4,static_cast<Line_Break>(0)},
{0xd7b0,Line_Break::JV},
{0xd7c7,static_cast<Line_Break>(0)},
{0xd7cb,Line_Break::JT},
{0xd7fc,static_cast<Line_Break>(0)},
{0xd800,Line_Break::SG},
{0xe000,Line_Break::XX},
{0xf900,Line_Break::ID},
{0xfb00,Line_Break::AL},
{0xfb07,static_cast<Line_Break>(0)},
{0xfb13,Line_Break::AL},
{0xfb18,static_cast<Line_Break>(0)},
{0xfb1d,Line_Break::HL},
{0xfb1e,Line_Break::CM},
{0xfb1f,Line_Break::HL},
{0xfb29,Line_Break::AL},
{0xfb2a,Line_Break::HL},
{0xfb37,static_cast<Line_Break>(0)},
{0xfb38,Line_Break::HL},
{0xfb3d,static_cast<Line_Break>(0)},
{0xfb3e,Line_Break::HL},
{0xfb3f,static_cast<Line_Break>(0)},
{0xfb40,Line_Break::HL},
{0xfb42,static_cast<Line_Break>(0)},
{0xfb43,Line_Break::HL},
{0xfb45,static_cast<Line_Break>(0)},
{0xfb46,Line_Break::HL},
{0xfb50,Line_Break::AL},
{0xfbc2,static_cast<Line_Break>(0)},
{0xfbd3,Line_Break::AL},
{0xfd3e,Line_Break::CL},
{0xfd3f,Line_Break::OP},
{0xfd40,static_cast<Line_Break>(0)},
{0xfd50,Line_Break::AL},
{0xfd90,static_cast<Line_Break>(0)},
{0xfd92,Line_Break::AL},
{0xfdc8,static_cast<Line_Break>(0)},
{0xfdf0,Line_Break::AL},
{0xfdfc,Line_Break::PO},
{0xfdfd,Line_Break::AL},
{0xfdfe,static_cast<Line_Break>(0)},
{0xfe00,Line_Break::CM},
{0xfe10,Line_Break::IS},
{0xfe11,Line_Break::CL},
{0xfe13,Line_Break::IS},
{0xfe15,Line_Break::EX},
{0xfe17,Line_Break::OP},
{0xfe18,Line_Break::CL},
{0xfe19,Line_Break::IN_},
{0xfe1a,static_cast<Line_Break>(0)},
{0xfe20,Line_Break::CM},
{0xfe30,Line_Break::ID},
{0xfe35,Line_Break::OP},
{0xfe36,Line_Break::CL},
{0xfe37,Line_Break::OP},
{0xfe38,Line_Break::CL},
{0xfe39,Line_Break::OP},
{0xfe3a,Line_Break::CL},
{0xfe3b,Line_Break::OP},
{0xfe3c,Line_Break::CL},
{0xfe3d,Line_Break::OP},
{0xfe3e,Line_Break::CL},
{0xfe3f,Line_Break::OP},
{0xfe40,Line_Break::CL},
{0xfe41,Line_Break::OP},
{0xfe42,Line_Break::CL},
{0xfe43,Line_Break::OP},
{0xfe44,Line_Break::CL},
{0xfe45,Line_Break::ID},
{0xfe47,Line_Break::OP},
{0xfe48,Line_Break::CL},
{0xfe49,Line_Break::ID},
{0xfe50,Line_Break::CL},
{0xfe51,Line_Break::ID},
{0xfe52,Line_Break::CL},
{0xfe53,static_cast<Line_Break>(0)},
{0xfe54,Line_Break::NS},
{0xfe56,Line_Break::EX},
{0xfe58,Line_Break::ID},
{0xfe59,Line_Break::OP},
{0xfe5a,Line_Break::CL},
{0xfe5b,Line_Break::OP},
{0xfe5c,Line_Break::CL},
{0xfe5d,Line_Break::OP},
{0xfe5e,Line_Break::CL},
{0xfe5f,Line_Break::ID},
{0xfe67,static_cast<Line_Break>(0)},
{0xfe68,Line_Break::ID},
{0xfe69,Line_Break::PR},
{0xfe6a,Line_Break::PO},
{0xfe6b,Line_Break::ID},
{0xfe6c,static_cast<Line_Break>(0)},
{0xfe70,Line_Break::AL},
{0xfe75,static_cast<Line_Break>(0)},
{0xfe76,Line_Break::AL},
{0xfefd,static_cast<Line_Break>(0)},
{0xfeff,Line_Break::WJ},
{0xff00,static_cast<Line_Break>(0)},
{0xff01,Line_Break::EX},
{0xff02,Line_Break::ID},
{0xff04,Line_Break::PR},
{0xff05,Line_Break::PO},
{0xff06,Line_Break::ID},
{0xff08,Line_Break::OP},
{0xff09,Line_Break::CL},
{0xff0a,Line_Break::ID},
{0xff0c,Line_Break::CL},
{0xff0d,Line_Break::ID},
{0xff0e,Line_Break::CL},
{0xff0f,Line_Break::ID},
{0xff1a,Line_Break::NS},
{0xff1c,Line_Break::ID},
{0xff1f,Line_Break::EX},
{0xff20,Line_Break::ID},
{0xff3b,Line_Break::OP},
{0xff3c,Line_Break::ID},
{0xff3d,Line_Break::CL},
{0xff3e,Line_Break::ID},
{0xff5b,Line_Break::OP},
{0xff5c,Line_Break::ID},
{0xff5d,Line_Break::CL},
{0xff5e,Line_Break::ID},
{0xff5f,Line_Break::OP},
{0xff60,Line_Break::CL},
{0xff62,Line_Break::OP},
{0xff63,Line_Break::CL},
{0xff65,Line_Break::NS},
{0xff66,Line_Break::AL},
{0xff67,Line_Break::CJ},
{0xff71,Line_Break::AL},
{0xff9e,Line_Break::NS},
{0xffa0,Line_Break::AL},
{0xffbf,static_cast<Line_Break>(0)},
{0xffc2,Line_Break::AL},
{0xffc8,static_cast<Line_Break>(0)},
{0xffca,Line_Break::AL},
{0xffd0,static_cast<Line_Break>(0)},
{0xffd2,Line_Break::AL},
{0xffd8,static_cast<Line_Break>(0)},
{0xffda,Line_Break::AL},
{0xffdd,static_cast<Line_Break>(0)},
{0xffe0,Line_Break::PO},
{0xffe1,Line_Break::PR},
{0xffe2,Line_Break::ID},
{0xffe5,Line_Break::PR},
{0xffe7,static_cast<Line_Break>(0)},
{0xffe8,Line_Break::AL},
{0xffef,static_cast<Line_Break>(0)},
{0xfff9,Line_Break::CM},
{0xfffc,Line_Break::CB},
{0xfffd,Line_Break::AI},
{0xfffe,static_cast<Line_Break>(0)},
{0x10000,Line_Break::AL},
{0x1000c,static_cast<Line_Break>(0)},
{0x1000d,Line_Break::AL},
{0x10027,static_cast<Line_Break>(0)},
{0x10028,Line_Break::AL},
{0x1003b,static_cast<Line_Break>(0)},
{0x1003c,Line_Break::AL},
{0x1003e,static_cast<Line_Break>(0)},
{0x1003f,Line_Break::AL},
{0x1004e,static_cast<Line_Break>(0)},
{0x10050,Line_Break::AL},
{0x1005e,static_cast<Line_Break>(0)},
{0x10080,Line_Break::AL},
{0x100fb,static_cast<Line_Break>(0)},
{0x10100,Line_Break::BA},
{0x10103,static_cast<Line_Break>(0)},
{0x10107,Line_Break::AL},
{0x10134,static_cast<Line_Break>(0)},
{0x10137,Line_Break::AL},
{0x1018d,static_cast<Line_Break>(0)},
{0x10190,Line_Break::AL},
{0x1019c,static_cast<Line_Break>(0)},
{0x101a0,Line_Break::AL},
{0x101a1,static_cast<Line_Break>(0)},
{0x101d0,Line_Break::AL},
{0x101fd,Line_Break::CM},
{0x101fe,static_cast<Line_Break>(0)},
{0x10280,Line_Break::AL},
{0x1029d,static_cast<Line_Break>(0)},
{0x102a0,Line_Break::AL},
{0x102d1,static_cast<Line_Break>(0)},
{0x102e0,Line_Break::CM},
{0x102e1,Line_Break::AL},
{0x102fc,static_cast<Line_Break>(0)},
{0x10300,Line_Break::AL},
{0x10324,static_cast<Line_Break>(0)},
{0x10330,Line_Break::AL},
{0x1034b,static_cast<Line_Break>(0)},
{0x10350,Line_Break::AL},
{0x10376,Line_Break::CM},
{0x1037b,static_cast<Line_Break>(0)},
{0x10380,Line_Break::AL},
{0x1039e,static_cast<Line_Break>(0)},
{0x1039f,Line_Break::BA},
{0x103a0,Line_Break::AL},
{0x103c4,static_cast<Line_Break>(0)},
{0x103c8,Line_Break::AL},
{0x103d0,Line_Break::BA},
{0x103d1,Line_Break::AL},
{0x103d6,static_cast<Line_Break>(0)},
{0x10400,Line_Break::AL},
{0x1049e,static_cast<Line_Break>(0)},
{0x104a0,Line_Break::NU},
{0x104aa,static_cast<Line_Break>(0)},
{0x10500,Line_Break::AL},
{0x10528,static_cast<Line_Break>(0)},
{0x10530,Line_Break::AL},
{0x10564,static_cast<Line_Break>(0)},
{0x1056f,Line_Break::AL},
{0x10570,static_cast<Line_Break>(0)},
{0x10600,Line_Break::AL},
{0x10737,static_cast<Line_Break>(0)},
{0x10740,Line_Break::AL},
{0x10756,static_cast<Line_Break>(0)},
{0x10760,Line_Break::AL},
{0x10768,static_cast<Line_Break>(0)},
{0x10800,Line_Break::AL},
{0x10806,static_cast<Line_Break>(0)},
{0x10808,Line_Break::AL},
{0x10809,static_cast<Line_Break>(0)},
{0x1080a,Line_Break::AL},
{0x10836,static_cast<Line_Break>(0)},
{0x10837,Line_Break::AL},
{0x10839,static_cast<Line_Break>(0)},
{0x1083c,Line_Break::AL},
{0x1083d,static_cast<Line_Break>(0)},
{0x1083f,Line_Break::AL},
{0x10856,static_cast<Line_Break>(0)},
{0x10857,Line_Break::BA},
{0x10858,Line_Break::AL},
{0x1089f,static_cast<Line_Break>(0)},
{0x108a7,Line_Break::AL},
{0x108b0,static_cast<Line_Break>(0)},
{0x108e0,Line_Break::AL},
{0x108f3,static_cast<Line_Break>(0)},
{0x108f4,Line_Break::AL},
{0x108f6,static_cast<Line_Break>(0)},
{0x108fb,Line_Break::AL},
{0x1091c,static_cast<Line_Break>(0)},
{0x1091f,Line_Break::BA},
{0x10920,Line_Break::AL},
{0x1093a,static_cast<Line_Break>(0)},
{0x1093f,Line_Break::AL},
{0x10940,static_cast<Line_Break>(0)},
{0x10980,Line_Break::AL},
{0x109b8,static_cast<Line_Break>(0)},
{0x109bc,Line_Break::AL},
{0x109d0,static_cast<Line_Break>(0)},
{0x109d2,Line_Break::AL},
{0x10a01,Line_Break::CM},
{0x10a04,static_cast<Line_Break>(0)},
{0x10a05,Line_Break::CM},
{0x10a07,static_cast<Line_Break>(0)},
{0x10a0c,Line_Break::CM},
{0x10a10,Line_Break::AL},
{0x10a14,static_cast<Line_Break>(0)},
{0x10a15,Line_Break::AL},
{0x10a18,static_cast<Line_Break>(0)},
{0x10a19,Line_Break::AL},
{0x10a34,static_cast<Line_Break>(0)},
{0x10a38,Line_Break::CM},
{0x10a3b,static_cast<Line_Break>(0)},
{0x10a3f,Line_Break::CM},
{0x10a40,Line_Break::AL},
{0x10a48,static_cast<Line_Break>(0)},
{0x10a50,Line_Break::BA},
{0x10a58,Line_Break::AL},
{0x10a59,static_cast<Line_Break>(0)},
{0x10a60,Line_Break::AL},
{0x10aa0,static_cast<Line_Break>(0)},
{0x10ac0,Line_Break::AL},
{0x10ae5,Line_Break::CM},
{0x10ae7,static_cast<Line_Break>(0)},
{0x10aeb,Line_Break::AL},
{0x10af0,Line_Break::BA},
{0x10af6,Line_Break::IN_},
{0x10af7,static_cast<Line_Break>(0)},
{0x10b00,Line_Break::AL},
{0x10b36,static_cast<Line_Break>(0)},
{0x10b39,Line_Break::BA},
{0x10b40,Line_Break::AL},
{0x10b56,static_cast<Line_Break>(0)},
{0x10b58,Line_Break::AL},
{0x10b73,static_cast<Line_Break>(0)},
{0x10b78,Line_Break::AL},
{0x10b92,static_cast<Line_Break>(0)},
{0x10b99,Line_Break::AL},
{0x10b9d,static_cast<Line_Break>(0)},
{0x10ba9,Line_Break::AL},
{0x10bb0,static_cast<Line_Break>(0)},
{0x10c00,Line_Break::AL},
{0x10c49,static_cast<Line_Break>(0)},
{0x10c80,Line_Break::AL},
{0x10cb3,static_cast<Line_Break>(0)},
{0x10cc0,Line_Break::AL},
{0x10cf3,static_cast<Line_Break>(0)},
{0x10cfa,Line_Break::AL},
{0x10d00,static_cast<Line_Break>(0)},
{0x10e60,Line_Break::AL},
{0x10e7f,static_cast<Line_Break>(0)},
{0x11000,Line_Break::CM},
{0x11003,Line_Break::AL},
{0x11038,Line_Break::CM},
{0x11047,Line_Break::BA},
{0x11049,Line_Break::AL},
{0x1104e,static_cast<Line_Break>(0)},
{0x11052,Line_Break::AL},
{0x11066,Line_Break::NU},
{0x11070,static_cast<Line_Break>(0)},
{0x1107f,Line_Break::CM},
{0x11083,Line_Break::AL},
{0x110b0,Line_Break::CM},
{0x110bb,Line_Break::AL},
{0x110be,Line_Break::BA},
{0x110c2,static_cast<Line_Break>(0)},
{0x110d0,Line_Break::AL},
{0x110e9,static_cast<Line_Break>(0)},
{0x110f0,Line_Break::NU},
{0x110fa,static_cast<Line_Break>(0)},
{0x11100,Line_Break::CM},
{0x11103,Line_Break::AL},
{0x11127,Line_Break::CM},
{0x11135,static_cast<Line_Break>(0)},
{0x11136,Line_Break::NU},
{0x11140,Line_Break::BA},
{0x11144,static_cast<Line_Break>(0)},
{0x11150,Line_Break::AL},
{0x11173,Line_Break::CM},
{0x11174,Line_Break::AL},
{0x11175,Line_Break::BB},
{0x11176,Line_Break::AL},
{0x11177,static_cast<Line_Break>(0)},
{0x11180,Line_Break::CM},
{0x11183,Line_Break::AL},
{0x111b3,Line_Break::CM},
{0x111c1,Line_Break::AL},
{0x111c5,Line_Break::BA},
{0x111c7,Line_Break::AL},
{0x111c8,Line_Break::BA},
{0x111c9,Line_Break::AL},
{0x111ca,Line_Break::CM},
{0x111cd,Line_Break::AL},
{0x111ce,static_cast<Line_Break>(0)},
{0x111d0,Line_Break::NU},
{0x111da,Line_Break::AL},
{0x111db,Line_Break::BB},
{0x111dc,Line_Break::AL},
{0x111dd,Line_Break::BA},
{0x111e0,static_cast<Line_Break>(0)},
{0x111e1,Line_Break::AL},
{0x111f5,static_cast<Line_Break>(0)},
{0x11200,Line_Break::AL},
{0x11212,static_cast<Line_Break>(0)},
{0x11213,Line_Break::AL},
{0x1122c,Line_Break::CM},
{0x11238,Line_Break::BA},
{0x1123a,Line_Break::AL},
{0x1123b,Line_Break::BA},
{0x1123d,Line_Break::AL},
{0x1123e,static_cast<Line_Break>(0)},
{0x11280,Line_Break::AL},
{0x11287,static_cast<Line_Break>(0)},
{0x11288,Line_Break::AL},
{0x11289,static_cast<Line_Break>(0)},
{0x1128a,Line_Break::AL},
{0x1128e,static_cast<Line_Break>(0)},
{0x1128f,Line_Break::AL},
{0x1129e,static_cast<Line_Break>(0)},
{0x1129f,Line_Break::AL},
{0x112a9,Line_Break::BA},
{0x112aa,static_cast<Line_Break>(0)},
{0x112b0,Line_Break::AL},
{0x112df,Line_Break::CM},
{0x112eb,static_cast<Line_Break>(0)},
{0x112f0,Line_Break::NU},
{0x112fa,static_cast<Line_Break>(0)},
{0x11300,Line_Break::CM},
{0x11304,static_cast<Line_Break>(0)},
{0x11305,Line_Break::AL},
{0x1130d,static_cast<Line_Break>(0)},
{0x1130f,Line_Break::AL},
{0x11311,static_cast<Line_Break>(0)},
{0x11313,Line_Break::AL},
{0x11329,static_cast<Line_Break>(0)},
{0x1132a,Line_Break::AL},
{0x11331,static_cast<Line_Break>(0)},
{0x11332,Line_Break::AL},
{0x11334,static_cast<Line_Break>(0)},
{0x11335,Line_Break::AL},
{0x1133a,static_cast<Line_Break>(0)},
{0x1133c,Line_Break::CM},
{0x1133d,Line_Break::AL},
{0x1133e,Line_Break::CM},
{0x11345,static_cast<Line_Break>(0)},
{0x11347,Line_Break::CM},
{0x11349,static_cast<Line_Break>(0)},
{0x1134b,Line_Break::CM},
{0x1134e,static_cast<Line_Break>(0)},
{0x11350,Line_Break::AL},
{0x11351,static_cast<Line_Break>(0)},
{0x11357,Line_Break::CM},
{0x11358,static_cast<Line_Break>(0)},
{0x1135d,Line_Break::AL},
{0x11362,Line_Break::CM},
{0x11364,static_cast<Line_Break>(0)},
{0x11366,Line_Break::CM},
{0x1136d,static_cast<Line_Break>(0)},
{0x11370,Line_Break::CM},
{0x11375,static_cast<Line_Break>(0)},
{0x11480,Line_Break::AL},
{0x114b0,Line_Break::CM},
{0x114c4,Line_Break::AL},
{0x114c8,static_cast<Line_Break>(0)},
{0x114d0,Line_Break::NU},
{0x114da,static_cast<Line_Break>(0)},
{0x11580,Line_Break::AL},
{0x115af,Line_Break::CM},
{0x115b6,static_cast<Line_Break>(0)},
{0x115b8,Line_Break::CM},
{0x115c1,Line_Break::BB},
{0x115c2,Line_Break::BA},
{0x115c4,Line_Break::EX},
{0x115c6,Line_Break::AL},
{0x115c9,Line_Break::BA},
{0x115d8,Line_Break::AL},
{0x115dc,Line_Break::CM},
{0x115de,static_cast<Line_Break>(0)},
{0x11600,Line_Break::AL},
{0x11630,Line_Break::CM},
{0x11641,Line_Break::BA},
{0x11643,Line_Break::AL},
{0x11645,static_cast<Line_Break>(0)},
{0x11650,Line_Break::NU},
{0x1165a,static_cast<Line_Break>(0)},
{0x11680,Line_Break::AL},
{0x116ab,Line_Break::CM},
{0x116b8,static_cast<Line_Break>(0)},
{0x116c0,Line_Break::NU},
{0x116ca,static_cast<Line_Break>(0)},
{0x11700,Line_Break::SA},
{0x1171a,static_cast<Line_Break>(0)},
{0x1171d,Line_Break::SA},
{0x1172c,static_cast<Line_Break>(0)},
{0x11730,Line_Break::NU},
{0x1173a,Line_Break::SA},
{0x1173c,Line_Break::BA},
{0x1173f,Line_Break::SA},
{0x11740,static_cast<Line_Break>(0)},
{0x118a0,Line_Break::AL},
{0x118e0,Line_Break::NU},
{0x118ea,Line_Break::AL},
{0x118f3,static_cast<Line_Break>(0)},
{0x118ff,Line_Break::AL},
{0x11900,static_cast<Line_Break>(0)},
{0x11ac0,Line_Break::AL},
{0x11af9,static_cast<Line_Break>(0)},
{0x12000,Line_Break::AL},
{0x1239a,static_cast<Line_Break>(0)},
{0x12400,Line_Break::AL},
{0x1246f,static_cast<Line_Break>(0)},
{0x12470,Line_Break::BA},
{0x12475,static_cast<Line_Break>(0)},
{0x12480,Line_Break::AL},
{0x12544,static_cast<Line_Break>(0)},
{0x13000,Line_Break::AL},
{0x13258,Line_Break::OP},
{0x1325b,Line_Break::CL},
{0x1325e,Line_Break::AL},
{0x13282,Line_Break::CL},
{0x13283,Line_Break::AL},
{0x13286,Line_Break::OP},
{0x13287,Line_Break::CL},
{0x13288,Line_Break::OP},
{0x13289,Line_Break::CL},
{0x1328a,Line_Break::AL},
{0x13379,Line_Break::OP},
{0x1337a,Line_Break::CL},
{0x1337c,Line_Break::AL},
{0x1342f,static_cast<Line_Break>(0)},
{0x14400,Line_Break::AL},
{0x145ce,Line_Break::OP},
{0x145cf,Line_Break::CL},
{0x145d0,Line_Break::AL},
{0x14647,static_cast<Line_Break>(0)},
{0x16800,Line_Break::AL},
{0x16a39,static_cast<Line_Break>(0)},
{0x16a40,Line_Break::AL},
{0x16a5f,static_cast<Line_Break>(0)},
{0x16a60,Line_Break::NU},
{0x16a6a,static_cast<Line_Break>(0)},
{0x16a6e,Line_Break::BA},
{0x16a70,static_cast<Line_Break>(0)},
{0x16ad0,Line_Break::AL},
{0x16aee,static_cast<Line_Break>(0)},
{0x16af0,Line_Break::CM},
{0x16af5,Line_Break::BA},
{0x16af6,static_cast<Line_Break>(0)},
{0x16b00,Line_Break::AL},
{0x16b30,Line_Break::CM},
{0x16b37,Line_Break::BA},
{0x16b3a,Line_Break::AL},
{0x16b44,Line_Break::BA},
{0x16b45,Line_Break::AL},
{0x16b46,static_cast<Line_Break>(0)},
{0x16b50,Line_Break::NU},
{0x16b5a,static_cast<Line_Break>(0)},
{0x16b5b,Line_Break::AL},
{0x16b62,static_cast<Line_Break>(0)},
{0x16b63,Line_Break::AL},
{0x16b78,static_cast<Line_Break>(0)},
{0x16b7d,Line_Break::AL},
{0x16b90,static_cast<Line_Break>(0)},
{0x16f00,Line_Break::AL},
{0x16f45,static_cast<Line_Break>(0)},
{0x16f50,Line_Break::AL},
{0x16f51,Line_Break::CM},
{0x16f7f,static_cast<Line_Break>(0)},
{0x16f8f,Line_Break::CM},
{0x16f93,Line_Break::AL},
{0x16fa0,static_cast<Line_Break>(0)},
{0x1b000,Line_Break::ID},
{0x1b002,static_cast<Line_Break>(0)},
{0x1bc00,Line_Break::AL},
{0x1bc6b,static_cast<Line_Break>(0)},
{0x1bc70,Line_Break::AL},
{0x1bc7d,static_cast<Line_Break>(0)},
{0x1bc80,Line_Break::AL},
{0x1bc89,static_cast<Line_Break>(0)},
{0x1bc90,Line_Break::AL},
{0x1bc9a,static_cast<Line_Break>(0)},
{0x1bc9c,Line_Break::AL},
{0x1bc9d,Line_Break::CM},
{0x1bc9f,Line_Break::BA},
{0x1bca0,Line_Break::CM},
{0x1bca4,static_cast<Line_Break>(0)},
{0x1d000,Line_Break::AL},
{0x1d0f6,static_cast<Line_Break>(0)},
{0x1d100,Line_Break::AL},
{0x1d127,static_cast<Line_Break>(0)},
{0x1d129,Line_Break::AL},
{0x1d165,Line_Break::CM},
{0x1d16a,Line_Break::AL},
{0x1d16d,Line_Break::CM},
{0x1d183,Line_Break::AL},
{0x1d185,Line_Break::CM},
{0x1d18c,Line_Break::AL},
{0x1d1aa,Line_Break::CM},
{0x1d1ae,Line_Break::AL},
{0x1d1e9,static_cast<Line_Break>(0)},
{0x1d200,Line_Break::AL},
{0x1d242,Line_Break::CM},
{0x1d245,Line_Break::AL},
{0x1d246,static_cast<Line_Break>(0)},
{0x1d300,Line_Break::AL},
{0x1d357,static_cast<Line_Break>(0)},
{0x1d360,Line_Break::AL},
{0x1d372,static_cast<Line_Break>(0)},
{0x1d400,Line_Break::AL},
{0x1d455,static_cast<Line_Break>(0)},
{0x1d456,Line_Break::AL},
{0x1d49d,static_cast<Line_Break>(0)},
{0x1d49e,Line_Break::AL},
{0x1d4a0,static_cast<Line_Break>(0)},
{0x1d4a2,Line_Break::AL},
{0x1d4a3,static_cast<Line_Break>(0)},
{0x1d4a5,Line_Break::AL},
{0x1d4a7,static_cast<Line_Break>(0)},
{0x1d4a9,Line_Break::AL},
{0x1d4ad,static_cast<Line_Break>(0)},
{0x1d4ae,Line_Break::AL},
{0x1d4ba,static_cast<Line_Break>(0)},
{0x1d4bb,Line_Break::AL},
{0x1d4bc,static_cast<Line_Break>(0)},
{0x1d4bd,Line_Break::AL},
{0x1d4c4,static_cast<Line_Break>(0)},
{0x1d4c5,Line_Break::AL},
{0x1d506,static_cast<Line_Break>(0)},
{0x1d507,Line_Break::AL},
{0x1d50b,static_cast<Line_Break>(0)},
{0x1d50d,Line_Break::AL},
{0x1d515,static_cast<Line_Break>(0)},
{0x1d516,Line_Break::AL},
{0x1d51d,static_cast<Line_Break>(0)},
{0x1d51e,Line_Break::AL},
{0x1d53a,static_cast<Line_Break>(0)},
{0x1d53b,Line_Break::AL},
{0x1d53f,static_cast<Line_Break>(0)},
{0x1d540,Line_Break::AL},
{0x1d545,static_cast<Line_Break>(0)},
{0x1d546,Line_Break::AL},
{0x1d547,static_cast<Line_Break>(0)},
{0x1d54a,Line_Break::AL},
{0x1d551,static_cast<Line_Break>(0)},
{0x1d552,Line_Break::AL},
{0x1d6a6,static_cast<Line_Break>(0)},
{0x1d6a8,Line_Break::AL},
{0x1d7cc,static_cast<Line_Break>(0)},
{0x1d7ce,Line_Break::NU},
{0x1d800,Line_Break::AL},
{0x1da00,Line_Break::CM},
{0x1da37,Line_Break::AL},
{0x1da3b,Line_Break::CM},
{0x1da6d,Line_Break::AL},
{0x1da75,Line_Break::CM},
{0x1da76,Line_Break::AL},
{0x1da84,Line_Break::CM},
{0x1da85,Line_Break::AL},
{0x1da87,Line_Break::BA},
{0x1da8b,Line_Break::AL},
{0x1da8c,static_cast<Line_Break>(0)},
{0x1da9b,Line_Break::CM},
{0x1daa0,static_cast<Line_Break>(0)},
{0x1daa1,Line_Break::CM},
{0x1dab0,static_cast<Line_Break>(0)},
{0x1e800,Line_Break::AL},
{0x1e8c5,static_cast<Line_Break>(0)},
{0x1e8c7,Line_Break::AL},
{0x1e8d0,Line_Break::CM},
{0x1e8d7,static_cast<Line_Break>(0)},
{0x1ee00,Line_Break::AL},
{0x1ee04,static_cast<Line_Break>(0)},
{0x1ee05,Line_Break::AL},
{0x1ee20,static_cast<Line_Break>(0)},
{0x1ee21,Line_Break::AL},
{0x1ee23,static_cast<Line_Break>(0)},
{0x1ee24,Line_Break::AL},
{0x1ee25,static_cast<Line_Break>(0)},
{0x1ee27,Line_Break::AL},
{0x1ee28,static_cast<Line_Break>(0)},
{0x1ee29,Line_Break::AL},
{0x1ee33,static_cast<Line_Break>(0)},
{0x1ee34,Line_Break::AL},
{0x1ee38,static_cast<Line_Break>(0)},
{0x1ee39,Line_Break::AL},
{0x1ee3a,static_cast<Line_Break>(0)},
{0x1ee3b,Line_Break::AL},
{0x1ee3c,static_cast<Line_Break>(0)},
{0x1ee42,Line_Break::AL},
{0x1ee43,static_cast<Line_Break>(0)},
{0x1ee47,Line_Break::AL},
{0x1ee48,static_cast<Line_Break>(0)},
{0x1ee49,Line_Break::AL},
{0x1ee4a,static_cast<Line_Break>(0)},
{0x1ee4b,Line_Break::AL},
{0x1ee4c,static_cast<Line_Break>(0)},
{0x1ee4d,Line_Break::AL},
{0x1ee50,static_cast<Line_Break>(0)},
{0x1ee51,Line_Break::AL},
{0x1ee53,static_cast<Line_Break>(0)},
{0x1ee54,Line_Break::AL},
{0x1ee55,static_cast<Line_Break>(0)},
{0x1ee57,Line_Break::AL},
{0x1ee58,static_cast<Line_Break>(0)},
{0x1ee59,Line_Break::AL},
{0x1ee5a,static_cast<Line_Break>(0)},
{0x1ee5b,Line_Break::AL},
{0x1ee5c,static_cast<Line_Break>(0)},
{0x1ee5d,Line_Break::AL},
{0x1ee5e,static_cast<Line_Break>(0)},
{0x1ee5f,Line_Break::AL},
{0x1ee60,static_cast<Line_Break>(0)},
{0x1ee61,Line_Break::AL},
{0x1ee63,static_cast<Line_Break>(0)},
{0x1ee64,Line_Break::AL},
{0x1ee65,static_cast<Line_Break>(0)},
{0x1ee67,Line_Break::AL},
{0x1ee6b,static_cast<Line_Break>(0)},
{0x1ee6c,Line_Break::AL},
{0x1ee73,static_cast<Line_Break>(0)},
{0x1ee74,Line_Break::AL},
{0x1ee78,static_cast<Line_Break>(0)},
{0x1ee79,Line_Break::AL},
{0x1ee7d,static_cast<Line_Break>(0)},
{0x1ee7e,Line_Break::AL},
{0x1ee7f,static_cast<Line_Break>(0)},
{0x1ee80,Line_Break::AL},
{0x1ee8a,static_cast<Line_Break>(0)},
{0x1ee8b,Line_Break::AL},
{0x1ee9c,static_cast<Line_Break>(0)},
{0x1eea1,Line_Break::AL},
{0x1eea4,static_cast<Line_Break>(0)},
{0x1eea5,Line_Break::AL},
{0x1eeaa,static_cast<Line_Break>(0)},
{0x1eeab,Line_Break::AL},
{0x1eebc,static_cast<Line_Break>(0)},
{0x1eef0,Line_Break::AL},
{0x1eef2,static_cast<Line_Break>(0)},
{0x1f000,Line_Break::ID},
{0x1f02c,static_cast<Line_Break>(0)},
{0x1f030,Line_Break::ID},
{0x1f094,static_cast<Line_Break>(0)},
{0x1f0a0,Line_Break::ID},
{0x1f0af,static_cast<Line_Break>(0)},
{0x1f0b1,Line_Break::ID},
{0x1f0c0,static_cast<Line_Break>(0)},
{0x1f0c1,Line_Break::ID},
{0x1f0d0,static_cast<Line_Break>(0)},
{0x1f0d1,Line_Break::ID},
{0x1f0f6,static_cast<Line_Break>(0)},
{0x1f100,Line_Break::AI},
{0x1f10d,static_cast<Line_Break>(0)},
{0x1f110,Line_Break::AI},
{0x1f12e,Line_Break::AL},
{0x1f12f,static_cast<Line_Break>(0)},
{0x1f130,Line_Break::AI},
{0x1f16a,Line_Break::AL},
{0x1f16c,static_cast<Line_Break>(0)},
{0x1f170,Line_Break::AI},
{0x1f19b,static_cast<Line_Break>(0)},
{0x1f1e6,Line_Break::RI},
{0x1f200,Line_Break::ID},
{0x1f203,static_cast<Line_Break>(0)},
{0x1f210,Line_Break::ID},
{0x1f23b,static_cast<Line_Break>(0)},
{0x1f240,Line_Break::ID},
{0x1f249,static_cast<Line_Break>(0)},
{0x1f250,Line_Break::ID},
{0x1f252,static_cast<Line_Break>(0)},
{0x1f300,Line_Break::ID},
{0x1f39c,Line_Break::AL},
{0x1f39e,Line_Break::ID},
{0x1f3b5,Line_Break::AL},
{0x1f3b7,Line_Break::ID},
{0x1f3bc,Line_Break::AL},
{0x1f3bd,Line_Break::ID},
{0x1f3fb,Line_Break::AL},
{0x1f400,Line_Break::ID},
{0x1f4a0,Line_Break::AL},
{0x1f4a1,Line_Break::ID},
{0x1f4a2,Line_Break::AL},
{0x1f4a3,Line_Break::ID},
{0x1f4a4,Line_Break::AL},
{0x1f4a5,Line_Break::ID},
{0x1f4af,Line_Break::AL},
{0x1f4b0,Line_Break::ID},
{0x1f4b1,Line_Break::AL},
{0x1f4b3,Line_Break::ID},
{0x1f500,Line_Break::AL},
{0x1f507,Line_Break::ID},
{0x1f517,Line_Break::AL},
{0x1f525,Line_Break::ID},
{0x1f532,Line_Break::AL},
{0x1f54a,Line_Break::ID},
{0x1f57a,static_cast<Line_Break>(0)},
{0x1f57b,Line_Break::ID},
{0x1f5a4,static_cast<Line_Break>(0)},
{0x1f5a5,Line_Break::ID},
{0x1f5d4,Line_Break::AL},
{0x1f5dc,Line_Break::ID},
{0x1f5f4,Line_Break::AL},
{0x1f5fa,Line_Break::ID},
{0x1f650,Line_Break::AL},
{0x1f676,Line_Break::QU},
{0x1f679,Line_Break::NS},
{0x1f67c,Line_Break::AL},
{0x1f680,Line_Break::ID},
{0x1f6d1,static_cast<Line_Break>(0)},
{0x1f6e0,Line_Break::ID},
{0x1f6ed,static_cast<Line_Break>(0)},
{0x1f6f0,Line_Break::ID},
{0x1f6f4,static_cast<Line_Break>(0)},
{0x1f700,Line_Break::AL},
{0x1f774,static_cast<Line_Break>(0)},
{0x1f780,Line_Break::AL},
{0x1f7d5,static_cast<Line_Break>(0)},
{0x1f800,Line_Break::AL},
{0x1f80c,static_cast<Line_Break>(0)},
{0x1f810,Line_Break::AL},
{0x1f848,static_cast<Line_Break>(0)},
{0x1f850,Line_Break::AL},
{0x1f85a,static_cast<Line_Break>(0)},
{0x1f860,Line_Break::AL},
{0x1f888,static_cast<Line_Break>(0)},
{0x1f890,Line_Break::AL},
{0x1f8ae,static_cast<Line_Break>(0)},
{0x1f910,Line_Break::ID},
{0x1f919,static_cast<Line_Break>(0)},
{0x1f980,Line_Break::ID},
{0x1f985,static_cast<Line_Break>(0)},
{0x1f9c0,Line_Break::ID},
{0x1f9c1,static_cast<Line_Break>(0)},
{0x20000,Line_Break::ID},
{0x2fffe,static_cast<Line_Break>(0)},
{0x30000,Line_Break::ID},
{0x3fffe,static_cast<Line_Break>(0)},
{0xe0001,Line_Break::CM},
{0xe0002,static_cast<Line_Break>(0)},
{0xe0020,Line_Break::CM},
{0xe0080,static_cast<Line_Break>(0)},
{0xe0100,Line_Break::CM},
{0xe01f0,static_cast<Line_Break>(0)},
{0xf0000,Line_Break::XX},
{0xffffe,static_cast<Line_Break>(0)},
{0x100000,Line_Break::XX},
{0x10fffe,static_cast<Line_Break>(0)},
}};

const TableView<char32_t, Line_Break> line_break_table {&line_break_array[0], &line_break_array[0] + line_break_array.size()};

const std::array<KeyValue<char32_t, Sentence_Break>, 2896> sentence_break_array = {{
{0x0,static_cast<Sentence_Break>(0)},
{0x9,Sentence_Break::Sp},
{0xa,Sentence_Break::LF},
{0xb,Sentence_Break::Sp},
{0xd,Sentence_Break::CR},
{0xe,static_cast<Sentence_Break>(0)},
{0x20,Sentence_Break::Sp},
{0x21,Sentence_Break::STerm},
{0x22,Sentence_Break::Close},
{0x23,static_cast<Sentence_Break>(0)},
{0x27,Sentence_Break::Close},
{0x2a,static_cast<Sentence_Break>(0)},
{0x2c,Sentence_Break::SContinue},
{0x2e,Sentence_Break::ATerm},
{0x2f,static_cast<Sentence_Break>(0)},
{0x30,Sentence_Break::Numeric},
{0x3a,Sentence_Break::SContinue},
{0x3b,static_cast<Sentence_Break>(0)},
{0x3f,Sentence_Break::STerm},
{0x40,static_cast<Sentence_Break>(0)},
{0x41,Sentence_Break::Upper},
{0x5b,Sentence_Break::Close},
{0x5c,static_cast<Sentence_Break>(0)},
{0x5d,Sentence_Break::Close},
{0x5e,static_cast<Sentence_Break>(0)},
{0x61,Sentence_Break::Lower},
{0x7b,Sentence_Break::Close},
{0x7c,static_cast<Sentence_Break>(0)},
{0x7d,Sentence_Break::Close},
{0x7e,static_cast<Sentence_Break>(0)},
{0x85,Sentence_Break::Sep},
{0x86,static_cast<Sentence_Break>(0)},
{0xa0,Sentence_Break::Sp},
{0xa1,static_cast<Sentence_Break>(0)},
{0xaa,Sentence_Break::Lower},
{0xab,Sentence_Break::Close},
{0xac,static_cast<Sentence_Break>(0)},
{0xad,Sentence_Break::Format},
{0xae,static_cast<Sentence_Break>(0)},
{0xb5,Sentence_Break::Lower},
{0xb6,static_cast<Sentence_Break>(0)},
{0xba,Sentence_Break::Lower},
{0xbb,Sentence_Break::Close},
{0xbc,static_cast<Sentence_Break>(0)},
{0xc0,Sentence_Break::Upper},
{0xd7,static_cast<Sentence_Break>(0)},
{0xd8,Sentence_Break::Upper},
{0xdf,Sentence_Break::Lower},
{0xf7,static_cast<Sentence_Break>(0)},
{0xf8,Sentence_Break::Lower},
{0x100,Sentence_Break::Upper},
{0x101,Sentence_Break::Lower},
{0x102,Sentence_Break::Upper},
{0x103,Sentence_Break::Lower},
{0x104,Sentence_Break::Upper},
{0x105,Sentence_Break::Lower},
{0x106,Sentence_Break::Upper},
{0x107,Sentence_Break::Lower},
{0x108,Sentence_Break::Upper},
{0x109,Sentence_Break::Lower},
{0x10a,Sentence_Break::Upper},
{0x10b,Sentence_Break::Lower},
{0x10c,Sentence_Break::Upper},
{0x10d,Sentence_Break::Lower},
{0x10e,Sentence_Break::Upper},
{0x10f,Sentence_Break::Lower},
{0x110,Sentence_Break::Upper},
{0x111,Sentence_Break::Lower},
{0x112,Sentence_Break::Upper},
{0x113,Sentence_Break::Lower},
{0x114,Sentence_Break::Upper},
{0x115,Sentence_Break::Lower},
{0x116,Sentence_Break::Upper},
{0x117,Sentence_Break::Lower},
{0x118,Sentence_Break::Upper},
{0x119,Sentence_Break::Lower},
{0x11a,Sentence_Break::Upper},
{0x11b,Sentence_Break::Lower},
{0x11c,Sentence_Break::Upper},
{0x11d,Sentence_Break::Lower},
{0x11e,Sentence_Break::Upper},
{0x11f,Sentence_Break::Lower},
{0x120,Sentence_Break::Upper},
{0x121,Sentence_Break::Lower},
{0x122,Sentence_Break::Upper},
{0x123,Sentence_Break::Lower},
{0x124,Sentence_Break::Upper},
{0x125,Sentence_Break::Lower},
{0x126,Sentence_Break::Upper},
{0x127,Sentence_Break::Lower},
{0x128,Sentence_Break::Upper},
{0x129,Sentence_Break::Lower},
{0x12a,Sentence_Break::Upper},
{0x12b,Sentence_Break::Lower},
{0x12c,Sentence_Break::Upper},
{0x12d,Sentence_Break::Lower},
{0x12e,Sentence_Break::Upper},
{0x12f,Sentence_Break::Lower},
{0x130,Sentence_Break::Upper},
{0x131,Sentence_Break::Lower},
{0x132,Sentence_Break::Upper},
{0x133,Sentence_Break::Lower},
{0x134,Sentence_Break::Upper},
{0x135,Sentence_Break::Lower},
{0x136,Sentence_Break::Upper},
{0x137,Sentence_Break::Lower},
{0x139,Sentence_Break::Upper},
{0x13a,Sentence_Break::Lower},
{0x13b,Sentence_Break::Upper},
{0x13c,Sentence_Break::Lower},
{0x13d,Sentence_Break::Upper},
{0x13e,Sentence_Break::Lower},
{0x13f,Sentence_Break::Upper},
{0x140,Sentence_Break::Lower},
{0x141,Sentence_Break::Upper},
{0x142,Sentence_Break::Lower},
{0x143,Sentence_Break::Upper},
{0x144,Sentence_Break::Lower},
{0x145,Sentence_Break::Upper},
{0x146,Sentence_Break::Lower},
{0x147,Sentence_Break::Upper},
{0x148,Sentence_Break::Lower},
{0x14a,Sentence_Break::Upper},
{0x14b,Sentence_Break::Lower},
{0x14c,Sentence_Break::Upper},
{0x14d,Sentence_Break::Lower},
{0x14e,Sentence_Break::Upper},
{0x14f,Sentence_Break::Lower},
{0x150,Sentence_Break::Upper},
{0x151,Sentence_Break::Lower},
{0x152,Sentence_Break::Upper},
{0x153,Sentence_Break::Lower},
{0x154,Sentence_Break::Upper},
{0x155,Sentence_Break::Lower},
{0x156,Sentence_Break::Upper},
{0x157,Sentence_Break::Lower},
{0x158,Sentence_Break::Upper},
{0x159,Sentence_Break::Lower},
{0x15a,Sentence_Break::Upper},
{0x15b,Sentence_Break::Lower},
{0x15c,Sentence_Break::Upper},
{0x15d,Sentence_Break::Lower},
{0x15e,Sentence_Break::Upper},
{0x15f,Sentence_Break::Lower},
{0x160,Sentence_Break::Upper},
{0x161,Sentence_Break::Lower},
{0x162,Sentence_Break::Upper},
{0x163,Sentence_Break::Lower},
{0x164,Sentence_Break::Upper},
{0x165,Sentence_Break::Lower},
{0x166,Sentence_Break::Upper},
{0x167,Sentence_Break::Lower},
{0x168,Sentence_Break::Upper},
{0x169,Sentence_Break::Lower},
{0x16a,Sentence_Break::Upper},
{0x16b,Sentence_Break::Lower},
{0x16c,Sentence_Break::Upper},
{0x16d,Sentence_Break::Lower},
{0x16e,Sentence_Break::Upper},
{0x16f,Sentence_Break::Lower},
{0x170,Sentence_Break::Upper},
{0x171,Sentence_Break::Lower},
{0x172,Sentence_Break::Upper},
{0x173,Sentence_Break::Lower},
{0x174,Sentence_Break::Upper},
{0x175,Sentence_Break::Lower},
{0x176,Sentence_Break::Upper},
{0x177,Sentence_Break::Lower},
{0x178,Sentence_Break::Upper},
{0x17a,Sentence_Break::Lower},
{0x17b,Sentence_Break::Upper},
{0x17c,Sentence_Break::Lower},
{0x17d,Sentence_Break::Upper},
{0x17e,Sentence_Break::Lower},
{0x181,Sentence_Break::Upper},
{0x183,Sentence_Break::Lower},
{0x184,Sentence_Break::Upper},
{0x185,Sentence_Break::Lower},
{0x186,Sentence_Break::Upper},
{0x188,Sentence_Break::Lower},
{0x189,Sentence_Break::Upper},
{0x18c,Sentence_Break::Lower},
{0x18e,Sentence_Break::Upper},
{0x192,Sentence_Break::Lower},
{0x193,Sentence_Break::Upper},
{0x195,Sentence_Break::Lower},
{0x196,Sentence_Break::Upper},
{0x199,Sentence_Break::Lower},
{0x19c,Sentence_Break::Upper},
{0x19e,Sentence_Break::Lower},
{0x19f,Sentence_Break::Upper},
{0x1a1,Sentence_Break::Lower},
{0x1a2,Sentence_Break::Upper},
{0x1a3,Sentence_Break::Lower},
{0x1a4,Sentence_Break::Upper},
{0x1a5,Sentence_Break::Lower},
{0x1a6,Sentence_Break::Upper},
{0x1a8,Sentence_Break::Lower},
{0x1a9,Sentence_Break::Upper},
{0x1aa,Sentence_Break::Lower},
{0x1ac,Sentence_Break::Upper},
{0x1ad,Sentence_Break::Lower},
{0x1ae,Sentence_Break::Upper},
{0x1b0,Sentence_Break::Lower},
{0x1b1,Sentence_Break::Upper},
{0x1b4,Sentence_Break::Lower},
{0x1b5,Sentence_Break::Upper},
{0x1b6,Sentence_Break::Lower},
{0x1b7,Sentence_Break::Upper},
{0x1b9,Sentence_Break::Lower},
{0x1bb,Sentence_Break::OLetter},
{0x1bc,Sentence_Break::Upper},
{0x1bd,Sentence_Break::Lower},
{0x1c0,Sentence_Break::OLetter},
{0x1c4,Sentence_Break::Upper},
{0x1c6,Sentence_Break::Lower},
{0x1c7,Sentence_Break::Upper},
{0x1c9,Sentence_Break::Lower},
{0x1ca,Sentence_Break::Upper},
{0x1cc,Sentence_Break::Lower},
{0x1cd,Sentence_Break::Upper},
{0x1ce,Sentence_Break::Lower},
{0x1cf,Sentence_Break::Upper},
{0x1d0,Sentence_Break::Lower},
{0x1d1,Sentence_Break::Upper},
{0x1d2,Sentence_Break::Lower},
{0x1d3,Sentence_Break::Upper},
{0x1d4,Sentence_Break::Lower},
{0x1d5,Sentence_Break::Upper},
{0x1d6,Sentence_Break::Lower},
{0x1d7,Sentence_Break::Upper},
{0x1d8,Sentence_Break::Lower},
{0x1d9,Sentence_Break::Upper},
{0x1da,Sentence_Break::Lower},
{0x1db,Sentence_Break::Upper},
{0x1dc,Sentence_Break::Lower},
{0x1de,Sentence_Break::Upper},
{0x1df,Sentence_Break::Lower},
{0x1e0,Sentence_Break::Upper},
{0x1e1,Sentence_Break::Lower},
{0x1e2,Sentence_Break::Upper},
{0x1e3,Sentence_Break::Lower},
{0x1e4,Sentence_Break::Upper},
{0x1e5,Sentence_Break::Lower},
{0x1e6,Sentence_Break::Upper},
{0x1e7,Sentence_Break::Lower},
{0x1e8,Sentence_Break::Upper},
{0x1e9,Sentence_Break::Lower},
{0x1ea,Sentence_Break::Upper},
{0x1eb,Sentence_Break::Lower},
{0x1ec,Sentence_Break::Upper},
{0x1ed,Sentence_Break::Lower},
{0x1ee,Sentence_Break::Upper},
{0x1ef,Sentence_Break::Lower},
{0x1f1,Sentence_Break::Upper},
{0x1f3,Sentence_Break::Lower},
{0x1f4,Sentence_Break::Upper},
{0x1f5,Sentence_Break::Lower},
{0x1f6,Sentence_Break::Upper},
{0x1f9,Sentence_Break::Lower},
{0x1fa,Sentence_Break::Upper},
{0x1fb,Sentence_Break::Lower},
{0x1fc,Sentence_Break::Upper},
{0x1fd,Sentence_Break::Lower},
{0x1fe,Sentence_Break::Upper},
{0x1ff,Sentence_Break::Lower},
{0x200,Sentence_Break::Upper},
{0x201,Sentence_Break::Lower},
{0x202,Sentence_Break::Upper},
{0x203,Sentence_Break::Lower},
{0x204,Sentence_Break::Upper},
{0x205,Sentence_Break::Lower},
{0x206,Sentence_Break::Upper},
{0x207,Sentence_Break::Lower},
{0x208,Sentence_Break::Upper},
{0x209,Sentence_Break::Lower},
{0x20a,Sentence_Break::Upper},
{0x20b,Sentence_Break::Lower},
{0x20c,Sentence_Break::Upper},
{0x20d,Sentence_Break::Lower},
{0x20e,Sentence_Break::Upper},
{0x20f,Sentence_Break::Lower},
{0x210,Sentence_Break::Upper},
{0x211,Sentence_Break::Lower},
{0x212,Sentence_Break::Upper},
{0x213,Sentence_Break::Lower},
{0x214,Sentence_Break::Upper},
{0x215,Sentence_Break::Lower},
{0x216,Sentence_Break::Upper},
{0x217,Sentence_Break::Lower},
{0x218,Sentence_Break::Upper},
{0x219,Sentence_Break::Lower},
{0x21a,Sentence_Break::Upper},
{0x21b,Sentence_Break::Lower},
{0x21c,Sentence_Break::Upper},
{0x21d,Sentence_Break::Lower},
{0x21e,Sentence_Break::Upper},
{0x21f,Sentence_Break::Lower},
{0x220,Sentence_Break::Upper},
{0x221,Sentence_Break::Lower},
{0x222,Sentence_Break::Upper},
{0x223,Sentence_Break::Lower},
{0x224,Sentence_Break::Upper},
{0x225,Sentence_Break::Lower},
{0x226,Sentence_Break::Upper},
{0x227,Sentence_Break::Lower},
{0x228,Sentence_Break::Upper},
{0x229,Sentence_Break::Lower},
{0x22a,Sentence_Break::Upper},
{0x22b,Sentence_Break::Lower},
{0x22c,Sentence_Break::Upper},
{0x22d,Sentence_Break::Lower},
{0x22e,Sentence_Break::Upper},
{0x22f,Sentence_Break::Lower},
{0x230,Sentence_Break::Upper},
{0x231,Sentence_Break::Lower},
{0x232,Sentence_Break::Upper},
{0x233,Sentence_Break::Lower},
{0x23a,Sentence_Break::Upper},
{0x23c,Sentence_Break::Lower},
{0x23d,Sentence_Break::Upper},
{0x23f,Sentence_Break::Lower},
{0x241,Sentence_Break::Upper},
{0x242,Sentence_Break::Lower},
{0x243,Sentence_Break::Upper},
{0x247,Sentence_Break::Lower},
{0x248,Sentence_Break::Upper},
{0x249,Sentence_Break::Lower},
{0x24a,Sentence_Break::Upper},
{0x24b,Sentence_Break::Lower},
{0x24c,Sentence_Break::Upper},
{0x24d,Sentence_Break::Lower},
{0x24e,Sentence_Break::Upper},
{0x24f,Sentence_Break::Lower},
{0x294,Sentence_Break::OLetter},
{0x295,Sentence_Break::Lower},
{0x2b9,Sentence_Break::OLetter},
{0x2c0,Sentence_Break::Lower},
{0x2c2,static_cast<Sentence_Break>(0)},
{0x2c6,Sentence_Break::OLetter},
{0x2d2,static_cast<Sentence_Break>(0)},
{0x2e0,Sentence_Break::Lower},
{0x2e5,static_cast<Sentence_Break>(0)},
{0x2ec,Sentence_Break::OLetter},
{0x2ed,static_cast<Sentence_Break>(0)},
{0x2ee,Sentence_Break::OLetter},
{0x2ef,static_cast<Sentence_Break>(0)},
{0x300,Sentence_Break::Extend},
{0x370,Sentence_Break::Upper},
{0x371,Sentence_Break::Lower},
{0x372,Sentence_Break::Upper},
{0x373,Sentence_Break::Lower},
{0x374,Sentence_Break::OLetter},
{0x375,static_cast<Sentence_Break>(0)},
{0x376,Sentence_Break::Upper},
{0x377,Sentence_Break::Lower},
{0x378,static_cast<Sentence_Break>(0)},
{0x37a,Sentence_Break::Lower},
{0x37e,static_cast<Sentence_Break>(0)},
{0x37f,Sentence_Break::Upper},
{0x380,static_cast<Sentence_Break>(0)},
{0x386,Sentence_Break::Upper},
{0x387,static_cast<Sentence_Break>(0)},
{0x388,Sentence_Break::Upper},
{0x38b,static_cast<Sentence_Break>(0)},
{0x38c,Sentence_Break::Upper},
{0x38d,static_cast<Sentence_Break>(0)},
{0x38e,Sentence_Break::Upper},
{0x390,Sentence_Break::Lower},
{0x391,Sentence_Break::Upper},
{0x3a2,static_cast<Sentence_Break>(0)},
{0x3a3,Sentence_Break::Upper},
{0x3ac,Sentence_Break::Lower},
{0x3cf,Sentence_Break::Upper},
{0x3d0,Sentence_Break::Lower},
{0x3d2,Sentence_Break::Upper},
{0x3d5,Sentence_Break::Lower},
{0x3d8,Sentence_Break::Upper},
{0x3d9,Sentence_Break::Lower},
{0x3da,Sentence_Break::Upper},
{0x3db,Sentence_Break::Lower},
{0x3dc,Sentence_Break::Upper},
{0x3dd,Sentence_Break::Lower},
{0x3de,Sentence_Break::Upper},
{0x3df,Sentence_Break::Lower},
{0x3e0,Sentence_Break::Upper},
{0x3e1,Sentence_Break::Lower},
{0x3e2,Sentence_Break::Upper},
{0x3e3,Sentence_Break::Lower},
{0x3e4,Sentence_Break::Upper},
{0x3e5,Sentence_Break::Lower},
{0x3e6,Sentence_Break::Upper},
{0x3e7,Sentence_Break::Lower},
{0x3e8,Sentence_Break::Upper},
{0x3e9,Sentence_Break::Lower},
{0x3ea,Sentence_Break::Upper},
{0x3eb,Sentence_Break::Lower},
{0x3ec,Sentence_Break::Upper},
{0x3ed,Sentence_Break::Lower},
{0x3ee,Sentence_Break::Upper},
{0x3ef,Sentence_Break::Lower},
{0x3f4,Sentence_Break::Upper},
{0x3f5,Sentence_Break::Lower},
{0x3f6,static_cast<Sentence_Break>(0)},
{0x3f7,Sentence_Break::Upper},
{0x3f8,Sentence_Break::Lower},
{0x3f9,Sentence_Break::Upper},
{0x3fb,Sentence_Break::Lower},
{0x3fd,Sentence_Break::Upper},
{0x430,Sentence_Break::Lower},
{0x460,Sentence_Break::Upper},
{0x461,Sentence_Break::Lower},
{0x462,Sentence_Break::Upper},
{0x463,Sentence_Break::Lower},
{0x464,Sentence_Break::Upper},
{0x465,Sentence_Break::Lower},
{0x466,Sentence_Break::Upper},
{0x467,Sentence_Break::Lower},
{0x468,Sentence_Break::Upper},
{0x469,Sentence_Break::Lower},
{0x46a,Sentence_Break::Upper},
{0x46b,Sentence_Break::Lower},
{0x46c,Sentence_Break::Upper},
{0x46d,Sentence_Break::Lower},
{0x46e,Sentence_Break::Upper},
{0x46f,Sentence_Break::Lower},
{0x470,Sentence_Break::Upper},
{0x471,Sentence_Break::Lower},
{0x472,Sentence_Break::Upper},
{0x473,Sentence_Break::Lower},
{0x474,Sentence_Break::Upper},
{0x475,Sentence_Break::Lower},
{0x476,Sentence_Break::Upper},
{0x477,Sentence_Break::Lower},
{0x478,Sentence_Break::Upper},
{0x479,Sentence_Break::Lower},
{0x47a,Sentence_Break::Upper},
{0x47b,Sentence_Break::Lower},
{0x47c,Sentence_Break::Upper},
{0x47d,Sentence_Break::Lower},
{0x47e,Sentence_Break::Upper},
{0x47f,Sentence_Break::Lower},
{0x480,Sentence_Break::Upper},
{0x481,Sentence_Break::Lower},
{0x482,static_cast<Sentence_Break>(0)},
{0x483,Sentence_Break::Extend},
{0x48a,Sentence_Break::Upper},
{0x48b,Sentence_Break::Lower},
{0x48c,Sentence_Break::Upper},
{0x48d,Sentence_Break::Lower},
{0x48e,Sentence_Break::Upper},
{0x48f,Sentence_Break::Lower},
{0x490,Sentence_Break::Upper},
{0x491,Sentence_Break::Lower},
{0x492,Sentence_Break::Upper},
{0x493,Sentence_Break::Lower},
{0x494,Sentence_Break::Upper},
{0x495,Sentence_Break::Lower},
{0x496,Sentence_Break::Upper},
{0x497,Sentence_Break::Lower},
{0x498,Sentence_Break::Upper},
{0x499,Sentence_Break::Lower},
{0x49a,Sentence_Break::Upper},
{0x49b,Sentence_Break::Lower},
{0x49c,Sentence_Break::Upper},
{0x49d,Sentence_Break::Lower},
{0x49e,Sentence_Break::Upper},
{0x49f,Sentence_Break::Lower},
{0x4a0,Sentence_Break::Upper},
{0x4a1,Sentence_Break::Lower},
{0x4a2,Sentence_Break::Upper},
{0x4a3,Sentence_Break::Lower},
{0x4a4,Sentence_Break::Upper},
{0x4a5,Sentence_Break::Lower},
{0x4a6,Sentence_Break::Upper},
{0x4a7,Sentence_Break::Lower},
{0x4a8,Sentence_Break::Upper},
{0x4a9,Sentence_Break::Lower},
{0x4aa,Sentence_Break::Upper},
{0x4ab,Sentence_Break::Lower},
{0x4ac,Sentence_Break::Upper},
{0x4ad,Sentence_Break::Lower},
{0x4ae,Sentence_Break::Upper},
{0x4af,Sentence_Break::Lower},
{0x4b0,Sentence_Break::Upper},
{0x4b1,Sentence_Break::Lower},
{0x4b2,Sentence_Break::Upper},
{0x4b3,Sentence_Break::Lower},
{0x4b4,Sentence_Break::Upper},
{0x4b5,Sentence_Break::Lower},
{0x4b6,Sentence_Break::Upper},
{0x4b7,Sentence_Break::Lower},
{0x4b8,Sentence_Break::Upper},
{0x4b9,Sentence_Break::Lower},
{0x4ba,Sentence_Break::Upper},
{0x4bb,Sentence_Break::Lower},
{0x4bc,Sentence_Break::Upper},
{0x4bd,Sentence_Break::Lower},
{0x4be,Sentence_Break::Upper},
{0x4bf,Sentence_Break::Lower},
{0x4c0,Sentence_Break::Upper},
{0x4c2,Sentence_Break::Lower},
{0x4c3,Sentence_Break::Upper},
{0x4c4,Sentence_Break::Lower},
{0x4c5,Sentence_Break::Upper},
{0x4c6,Sentence_Break::Lower},
{0x4c7,Sentence_Break::Upper},
{0x4c8,Sentence_Break::Lower},
{0x4c9,Sentence_Break::Upper},
{0x4ca,Sentence_Break::Lower},
{0x4cb,Sentence_Break::Upper},
{0x4cc,Sentence_Break::Lower},
{0x4cd,Sentence_Break::Upper},
{0x4ce,Sentence_Break::Lower},
{0x4d0,Sentence_Break::Upper},
{0x4d1,Sentence_Break::Lower},
{0x4d2,Sentence_Break::Upper},
{0x4d3,Sentence_Break::Lower},
{0x4d4,Sentence_Break::Upper},
{0x4d5,Sentence_Break::Lower},
{0x4d6,Sentence_Break::Upper},
{0x4d7,Sentence_Break::Lower},
{0x4d8,Sentence_Break::Upper},
{0x4d9,Sentence_Break::Lower},
{0x4da,Sentence_Break::Upper},
{0x4db,Sentence_Break::Lower},
{0x4dc,Sentence_Break::Upper},
{0x4dd,Sentence_Break::Lower},
{0x4de,Sentence_Break::Upper},
{0x4df,Sentence_Break::Lower},
{0x4e0,Sentence_Break::Upper},
{0x4e1,Sentence_Break::Lower},
{0x4e2,Sentence_Break::Upper},
{0x4e3,Sentence_Break::Lower},
{0x4e4,Sentence_Break::Upper},
{0x4e5,Sentence_Break::Lower},
{0x4e6,Sentence_Break::Upper},
{0x4e7,Sentence_Break::Lower},
{0x4e8,Sentence_Break::Upper},
{0x4e9,Sentence_Break::Lower},
{0x4ea,Sentence_Break::Upper},
{0x4eb,Sentence_Break::Lower},
{0x4ec,Sentence_Break::Upper},
{0x4ed,Sentence_Break::Lower},
{0x4ee,Sentence_Break::Upper},
{0x4ef,Sentence_Break::Lower},
{0x4f0,Sentence_Break::Upper},
{0x4f1,Sentence_Break::Lower},
{0x4f2,Sentence_Break::Upper},
{0x4f3,Sentence_Break::Lower},
{0x4f4,Sentence_Break::Upper},
{0x4f5,Sentence_Break::Lower},
{0x4f6,Sentence_Break::Upper},
{0x4f7,Sentence_Break::Lower},
{0x4f8,Sentence_Break::Upper},
{0x4f9,Sentence_Break::Lower},
{0x4fa,Sentence_Break::Upper},
{0x4fb,Sentence_Break::Lower},
{0x4fc,Sentence_Break::Upper},
{0x4fd,Sentence_Break::Lower},
{0x4fe,Sentence_Break::Upper},
{0x4ff,Sentence_Break::Lower},
{0x500,Sentence_Break::Upper},
{0x501,Sentence_Break::Lower},
{0x502,Sentence_Break::Upper},
{0x503,Sentence_Break::Lower},
{0x504,Sentence_Break::Upper},
{0x505,Sentence_Break::Lower},
{0x506,Sentence_Break::Upper},
{0x507,Sentence_Break::Lower},
{0x508,Sentence_Break::Upper},
{0x509,Sentence_Break::Lower},
{0x50a,Sentence_Break::Upper},
{0x50b,Sentence_Break::Lower},
{0x50c,Sentence_Break::Upper},
{0x50d,Sentence_Break::Lower},
{0x50e,Sentence_Break::Upper},
{0x50f,Sentence_Break::Lower},
{0x510,Sentence_Break::Upper},
{0x511,Sentence_Break::Lower},
{0x512,Sentence_Break::Upper},
{0x513,Sentence_Break::Lower},
{0x514,Sentence_Break::Upper},
{0x515,Sentence_Break::Lower},
{0x516,Sentence_Break::Upper},
{0x517,Sentence_Break::Lower},
{0x518,Sentence_Break::Upper},
{0x519,Sentence_Break::Lower},
{0x51a,Sentence_Break::Upper},
{0x51b,Sentence_Break::Lower},
{0x51c,Sentence_Break::Upper},
{0x51d,Sentence_Break::Lower},
{0x51e,Sentence_Break::Upper},
{0x51f,Sentence_Break::Lower},
{0x520,Sentence_Break::Upper},
{0x521,Sentence_Break::Lower},
{0x522,Sentence_Break::Upper},
{0x523,Sentence_Break::Lower},
{0x524,Sentence_Break::Upper},
{0x525,Sentence_Break::Lower},
{0x526,Sentence_Break::Upper},
{0x527,Sentence_Break::Lower},
{0x528,Sentence_Break::Upper},
{0x529,Sentence_Break::Lower},
{0x52a,Sentence_Break::Upper},
{0x52b,Sentence_Break::Lower},
{0x52c,Sentence_Break::Upper},
{0x52d,Sentence_Break::Lower},
{0x52e,Sentence_Break::Upper},
{0x52f,Sentence_Break::Lower},
{0x530,static_cast<Sentence_Break>(0)},
{0x531,Sentence_Break::Upper},
{0x557,static_cast<Sentence_Break>(0)},
{0x559,Sentence_Break::OLetter},
{0x55a,static_cast<Sentence_Break>(0)},
{0x55d,Sentence_Break::SContinue},
{0x55e,static_cast<Sentence_Break>(0)},
{0x561,Sentence_Break::Lower},
{0x588,static_cast<Sentence_Break>(0)},
{0x589,Sentence_Break::STerm},
{0x58a,static_cast<Sentence_Break>(0)},
{0x591,Sentence_Break::Extend},
{0x5be,static_cast<Sentence_Break>(0)},
{0x5bf,Sentence_Break::Extend},
{0x5c0,static_cast<Sentence_Break>(0)},
{0x5c1,Sentence_Break::Extend},
{0x5c3,static_cast<Sentence_Break>(0)},
{0x5c4,Sentence_Break::Extend},
{0x5c6,static_cast<Sentence_Break>(0)},
{0x5c7,Sentence_Break::Extend},
{0x5c8,static_cast<Sentence_Break>(0)},
{0x5d0,Sentence_Break::OLetter},
{0x5eb,static_cast<Sentence_Break>(0)},
{0x5f0,Sentence_Break::OLetter},
{0x5f4,static_cast<Sentence_Break>(0)},
{0x600,Sentence_Break::Format},
{0x606,static_cast<Sentence_Break>(0)},
{0x60c,Sentence_Break::SContinue},
{0x60e,static_cast<Sentence_Break>(0)},
{0x610,Sentence_Break::Extend},
{0x61b,static_cast<Sentence_Break>(0)},
{0x61c,Sentence_Break::Format},
{0x61d,static_cast<Sentence_Break>(0)},
{0x61f,Sentence_Break::STerm},
{0x620,Sentence_Break::OLetter},
{0x64b,Sentence_Break::Extend},
{0x660,Sentence_Break::Numeric},
{0x66a,static_cast<Sentence_Break>(0)},
{0x66b,Sentence_Break::Numeric},
{0x66d,static_cast<Sentence_Break>(0)},
{0x66e,Sentence_Break::OLetter},
{0x670,Sentence_Break::Extend},
{0x671,Sentence_Break::OLetter},
{0x6d4,Sentence_Break::STerm},
{0x6d5,Sentence_Break::OLetter},
{0x6d6,Sentence_Break::Extend},
{0x6dd,Sentence_Break::Format},
{0x6de,static_cast<Sentence_Break>(0)},
{0x6df,Sentence_Break::Extend},
{0x6e5,Sentence_Break::OLetter},
{0x6e7,Sentence_Break::Extend},
{0x6e9,static_cast<Sentence_Break>(0)},
{0x6ea,Sentence_Break::Extend},
{0x6ee,Sentence_Break::OLetter},
{0x6f0,Sentence_Break::Numeric},
{0x6fa,Sentence_Break::OLetter},
{0x6fd,static_cast<Sentence_Break>(0)},
{0x6ff,Sentence_Break::OLetter},
{0x700,Sentence_Break::STerm},
{0x703,static_cast<Sentence_Break>(0)},
{0x70f,Sentence_Break::Format},
{0x710,Sentence_Break::OLetter},
{0x711,Sentence_Break::Extend},
{0x712,Sentence_Break::OLetter},
{0x730,Sentence_Break::Extend},
{0x74b,static_cast<Sentence_Break>(0)},
{0x74d,Sentence_Break::OLetter},
{0x7a6,Sentence_Break::Extend},
{0x7b1,Sentence_Break::OLetter},
{0x7b2,static_cast<Sentence_Break>(0)},
{0x7c0,Sentence_Break::Numeric},
{0x7ca,Sentence_Break::OLetter},
{0x7eb,Sentence_Break::Extend},
{0x7f4,Sentence_Break::OLetter},
{0x7f6,static_cast<Sentence_Break>(0)},
{0x7f8,Sentence_Break::SContinue},
{0x7f9,Sentence_Break::STerm},
{0x7fa,Sentence_Break::OLetter},
{0x7fb,static_cast<Sentence_Break>(0)},
{0x800,Sentence_Break::OLetter},
{0x816,Sentence_Break::Extend},
{0x81a,Sentence_Break::OLetter},
{0x81b,Sentence_Break::Extend},
{0x824,Sentence_Break::OLetter},
{0x825,Sentence_Break::Extend},
{0x828,Sentence_Break::OLetter},
{0x829,Sentence_Break::Extend},
{0x82e,static_cast<Sentence_Break>(0)},
{0x840,Sentence_Break::OLetter},
{0x859,Sentence_Break::Extend},
{0x85c,static_cast<Sentence_Break>(0)},
{0x8a0,Sentence_Break::OLetter},
{0x8b5,static_cast<Sentence_Break>(0)},
{0x8e3,Sentence_Break::Extend},
{0x904,Sentence_Break::OLetter},
{0x93a,Sentence_Break::Extend},
{0x93d,Sentence_Break::OLetter},
{0x93e,Sentence_Break::Extend},
{0x950,Sentence_Break::OLetter},
{0x951,Sentence_Break::Extend},
{0x958,Sentence_Break::OLetter},
{0x962,Sentence_Break::Extend},
{0x964,Sentence_Break::STerm},
{0x966,Sentence_Break::Numeric},
{0x970,static_cast<Sentence_Break>(0)},
{0x971,Sentence_Break::OLetter},
{0x981,Sentence_Break::Extend},
{0x984,static_cast<Sentence_Break>(0)},
{0x985,Sentence_Break::OLetter},
{0x98d,static_cast<Sentence_Break>(0)},
{0x98f,Sentence_Break::OLetter},
{0x991,static_cast<Sentence_Break>(0)},
{0x993,Sentence_Break::OLetter},
{0x9a9,static_cast<Sentence_Break>(0)},
{0x9aa,Sentence_Break::OLetter},
{0x9b1,static_cast<Sentence_Break>(0)},
{0x9b2,Sentence_Break::OLetter},
{0x9b3,static_cast<Sentence_Break>(0)},
{0x9b6,Sentence_Break::OLetter},
{0x9ba,static_cast<Sentence_Break>(0)},
{0x9bc,Sentence_Break::Extend},
{0x9bd,Sentence_Break::OLetter},
{0x9be,Sentence_Break::Extend},
{0x9c5,static_cast<Sentence_Break>(0)},
{0x9c7,Sentence_Break::Extend},
{0x9c9,static_cast<Sentence_Break>(0)},
{0x9cb,Sentence_Break::Extend},
{0x9ce,Sentence_Break::OLetter},
{0x9cf,static_cast<Sentence_Break>(0)},
{0x9d7,Sentence_Break::Extend},
{0x9d8,static_cast<Sentence_Break>(0)},
{0x9dc,Sentence_Break::OLetter},
{0x9de,static_cast<Sentence_Break>(0)},
{0x9df,Sentence_Break::OLetter},
{0x9e2,Sentence_Break::Extend},
{0x9e4,static_cast<Sentence_Break>(0)},
{0x9e6,Sentence_Break::Numeric},
{0x9f0,Sentence_Break::OLetter},
{0x9f2,static_cast<Sentence_Break>(0)},
{0xa01,Sentence_Break::Extend},
{0xa04,static_cast<Sentence_Break>(0)},
{0xa05,Sentence_Break::OLetter},
{0xa0b,static_cast<Sentence_Break>(0)},
{0xa0f,Sentence_Break::OLetter},
{0xa11,static_cast<Sentence_Break>(0)},
{0xa13,Sentence_Break::OLetter},
{0xa29,static_cast<Sentence_Break>(0)},
{0xa2a,Sentence_Break::OLetter},
{0xa31,static_cast<Sentence_Break>(0)},
{0xa32,Sentence_Break::OLetter},
{0xa34,static_cast<Sentence_Break>(0)},
{0xa35,Sentence_Break::OLetter},
{0xa37,static_cast<Sentence_Break>(0)},
{0xa38,Sentence_Break::OLetter},
{0xa3a,static_cast<Sentence_Break>(0)},
{0xa3c,Sentence_Break::Extend},
{0xa3d,static_cast<Sentence_Break>(0)},
{0xa3e,Sentence_Break::Extend},
{0xa43,static_cast<Sentence_Break>(0)},
{0xa47,Sentence_Break::Extend},
{0xa49,static_cast<Sentence_Break>(0)},
{0xa4b,Sentence_Break::Extend},
{0xa4e,static_cast<Sentence_Break>(0)},
{0xa51,Sentence_Break::Extend},
{0xa52,static_cast<Sentence_Break>(0)},
{0xa59,Sentence_Break::OLetter},
{0xa5d,static_cast<Sentence_Break>(0)},
{0xa5e,Sentence_Break::OLetter},
{0xa5f,static_cast<Sentence_Break>(0)},
{0xa66,Sentence_Break::Numeric},
{0xa70,Sentence_Break::Extend},
{0xa72,Sentence_Break::OLetter},
{0xa75,Sentence_Break::Extend},
{0xa76,static_cast<Sentence_Break>(0)},
{0xa81,Sentence_Break::Extend},
{0xa84,static_cast<Sentence_Break>(0)},
{0xa85,Sentence_Break::OLetter},
{0xa8e,static_cast<Sentence_Break>(0)},
{0xa8f,Sentence_Break::OLetter},
{0xa92,static_cast<Sentence_Break>(0)},
{0xa93,Sentence_Break::OLetter},
{0xaa9,static_cast<Sentence_Break>(0)},
{0xaaa,Sentence_Break::OLetter},
{0xab1,static_cast<Sentence_Break>(0)},
{0xab2,Sentence_Break::OLetter},
{0xab4,static_cast<Sentence_Break>(0)},
{0xab5,Sentence_Break::OLetter},
{0xaba,static_cast<Sentence_Break>(0)},
{0xabc,Sentence_Break::Extend},
{0xabd,Sentence_Break::OLetter},
{0xabe,Sentence_Break::Extend},
{0xac6,static_cast<Sentence_Break>(0)},
{0xac7,Sentence_Break::Extend},
{0xaca,static_cast<Sentence_Break>(0)},
{0xacb,Sentence_Break::Extend},
{0xace,static_cast<Sentence_Break>(0)},
{0xad0,Sentence_Break::OLetter},
{0xad1,static_cast<Sentence_Break>(0)},
{0xae0,Sentence_Break::OLetter},
{0xae2,Sentence_Break::Extend},
{0xae4,static_cast<Sentence_Break>(0)},
{0xae6,Sentence_Break::Numeric},
{0xaf0,static_cast<Sentence_Break>(0)},
{0xaf9,Sentence_Break::OLetter},
{0xafa,static_cast<Sentence_Break>(0)},
{0xb01,Sentence_Break::Extend},
{0xb04,static_cast<Sentence_Break>(0)},
{0xb05,Sentence_Break::OLetter},
{0xb0d,static_cast<Sentence_Break>(0)},
{0xb0f,Sentence_Break::OLetter},
{0xb11,static_cast<Sentence_Break>(0)},
{0xb13,Sentence_Break::OLetter},
{0xb29,static_cast<Sentence_Break>(0)},
{0xb2a,Sentence_Break::OLetter},
{0xb31,static_cast<Sentence_Break>(0)},
{0xb32,Sentence_Break::OLetter},
{0xb34,static_cast<Sentence_Break>(0)},
{0xb35,Sentence_Break::OLetter},
{0xb3a,static_cast<Sentence_Break>(0)},
{0xb3c,Sentence_Break::Extend},
{0xb3d,Sentence_Break::OLetter},
{0xb3e,Sentence_Break::Extend},
{0xb45,static_cast<Sentence_Break>(0)},
{0xb47,Sentence_Break::Extend},
{0xb49,static_cast<Sentence_Break>(0)},
{0xb4b,Sentence_Break::Extend},
{0xb4e,static_cast<Sentence_Break>(0)},
{0xb56,Sentence_Break::Extend},
{0xb58,static_cast<Sentence_Break>(0)},
{0xb5c,Sentence_Break::OLetter},
{0xb5e,static_cast<Sentence_Break>(0)},
{0xb5f,Sentence_Break::OLetter},
{0xb62,Sentence_Break::Extend},
{0xb64,static_cast<Sentence_Break>(0)},
{0xb66,Sentence_Break::Numeric},
{0xb70,static_cast<Sentence_Break>(0)},
{0xb71,Sentence_Break::OLetter},
{0xb72,static_cast<Sentence_Break>(0)},
{0xb82,Sentence_Break::Extend},
{0xb83,Sentence_Break::OLetter},
{0xb84,static_cast<Sentence_Break>(0)},
{0xb85,Sentence_Break::OLetter},
{0xb8b,static_cast<Sentence_Break>(0)},
{0xb8e,Sentence_Break::OLetter},
{0xb91,static_cast<Sentence_Break>(0)},
{0xb92,Sentence_Break::OLetter},
{0xb96,static_cast<Sentence_Break>(0)},
{0xb99,Sentence_Break::OLetter},
{0xb9b,static_cast<Sentence_Break>(0)},
{0xb9c,Sentence_Break::OLetter},
{0xb9d,static_cast<Sentence_Break>(0)},
{0xb9e,Sentence_Break::OLetter},
{0xba0,static_cast<Sentence_Break>(0)},
{0xba3,Sentence_Break::OLetter},
{0xba5,static_cast<Sentence_Break>(0)},
{0xba8,Sentence_Break::OLetter},
{0xbab,static_cast<Sentence_Break>(0)},
{0xbae,Sentence_Break::OLetter},
{0xbba,static_cast<Sentence_Break>(0)},
{0xbbe,Sentence_Break::Extend},
{0xbc3,static_cast<Sentence_Break>(0)},
{0xbc6,Sentence_Break::Extend},
{0xbc9,static_cast<Sentence_Break>(0)},
{0xbca,Sentence_Break::Extend},
{0xbce,static_cast<Sentence_Break>(0)},
{0xbd0,Sentence_Break::OLetter},
{0xbd1,static_cast<Sentence_Break>(0)},
{0xbd7,Sentence_Break::Extend},
{0xbd8,static_cast<Sentence_Break>(0)},
{0xbe6,Sentence_Break::Numeric},
{0xbf0,static_cast<Sentence_Break>(0)},
{0xc00,Sentence_Break::Extend},
{0xc04,static_cast<Sentence_Break>(0)},
{0xc05,Sentence_Break::OLetter},
{0xc0d,static_cast<Sentence_Break>(0)},
{0xc0e,Sentence_Break::OLetter},
{0xc11,static_cast<Sentence_Break>(0)},
{0xc12,Sentence_Break::OLetter},
{0xc29,static_cast<Sentence_Break>(0)},
{0xc2a,Sentence_Break::OLetter},
{0xc3a,static_cast<Sentence_Break>(0)},
{0xc3d,Sentence_Break::OLetter},
{0xc3e,Sentence_Break::Extend},
{0xc45,static_cast<Sentence_Break>(0)},
{0xc46,Sentence_Break::Extend},
{0xc49,static_cast<Sentence_Break>(0)},
{0xc4a,Sentence_Break::Extend},
{0xc4e,static_cast<Sentence_Break>(0)},
{0xc55,Sentence_Break::Extend},
{0xc57,static_cast<Sentence_Break>(0)},
{0xc58,Sentence_Break::OLetter},
{0xc5b,static_cast<Sentence_Break>(0)},
{0xc60,Sentence_Break::OLetter},
{0xc62,Sentence_Break::Extend},
{0xc64,static_cast<Sentence_Break>(0)},
{0xc66,Sentence_Break::Numeric},
{0xc70,static_cast<Sentence_Break>(0)},
{0xc81,Sentence_Break::Extend},
{0xc84,static_cast<Sentence_Break>(0)},
{0xc85,Sentence_Break::OLetter},
{0xc8d,static_cast<Sentence_Break>(0)},
{0xc8e,Sentence_Break::OLetter},
{0xc91,static_cast<Sentence_Break>(0)},
{0xc92,Sentence_Break::OLetter},
{0xca9,static_cast<Sentence_Break>(0)},
{0xcaa,Sentence_Break::OLetter},
{0xcb4,static_cast<Sentence_Break>(0)},
{0xcb5,Sentence_Break::OLetter},
{0xcba,static_cast<Sentence_Break>(0)},
{0xcbc,Sentence_Break::Extend},
{0xcbd,Sentence_Break::OLetter},
{0xcbe,Sentence_Break::Extend},
{0xcc5,static_cast<Sentence_Break>(0)},
{0xcc6,Sentence_Break::Extend},
{0xcc9,static_cast<Sentence_Break>(0)},
{0xcca,Sentence_Break::Extend},
{0xcce,static_cast<Sentence_Break>(0)},
{0xcd5,Sentence_Break::Extend},
{0xcd7,static_cast<Sentence_Break>(0)},
{0xcde,Sentence_Break::OLetter},
{0xcdf,static_cast<Sentence_Break>(0)},
{0xce0,Sentence_Break::OLetter},
{0xce2,Sentence_Break::Extend},
{0xce4,static_cast<Sentence_Break>(0)},
{0xce6,Sentence_Break::Numeric},
{0xcf0,static_cast<Sentence_Break>(0)},
{0xcf1,Sentence_Break::OLetter},
{0xcf3,static_cast<Sentence_Break>(0)},
{0xd01,Sentence_Break::Extend},
{0xd04,static_cast<Sentence_Break>(0)},
{0xd05,Sentence_Break::OLetter},
{0xd0d,static_cast<Sentence_Break>(0)},
{0xd0e,Sentence_Break::OLetter},
{0xd11,static_cast<Sentence_Break>(0)},
{0xd12,Sentence_Break::OLetter},
{0xd3b,static_cast<Sentence_Break>(0)},
{0xd3d,Sentence_Break::OLetter},
{0xd3e,Sentence_Break::Extend},
{0xd45,static_cast<Sentence_Break>(0)},
{0xd46,Sentence_Break::Extend},
{0xd49,static_cast<Sentence_Break>(0)},
{0xd4a,Sentence_Break::Extend},
{0xd4e,Sentence_Break::OLetter},
{0xd4f,static_cast<Sentence_Break>(0)},
{0xd57,Sentence_Break::Extend},
{0xd58,static_cast<Sentence_Break>(0)},
{0xd5f,Sentence_Break::OLetter},
{0xd62,Sentence_Break::Extend},
{0xd64,static_cast<Sentence_Break>(0)},
{0xd66,Sentence_Break::Numeric},
{0xd70,static_cast<Sentence_Break>(0)},
{0xd7a,Sentence_Break::OLetter},
{0xd80,static_cast<Sentence_Break>(0)},
{0xd82,Sentence_Break::Extend},
{0xd84,static_cast<Sentence_Break>(0)},
{0xd85,Sentence_Break::OLetter},
{0xd97,static_cast<Sentence_Break>(0)},
{0xd9a,Sentence_Break::OLetter},
{0xdb2,static_cast<Sentence_Break>(0)},
{0xdb3,Sentence_Break::OLetter},
{0xdbc,static_cast<Sentence_Break>(0)},
{0xdbd,Sentence_Break::OLetter},
{0xdbe,static_cast<Sentence_Break>(0)},
{0xdc0,Sentence_Break::OLetter},
{0xdc7,static_cast<Sentence_Break>(0)},
{0xdca,Sentence_Break::Extend},
{0xdcb,static_cast<Sentence_Break>(0)},
{0xdcf,Sentence_Break::Extend},
{0xdd5,static_cast<Sentence_Break>(0)},
{0xdd6,Sentence_Break::Extend},
{0xdd7,static_cast<Sentence_Break>(0)},
{0xdd8,Sentence_Break::Extend},
{0xde0,static_cast<Sentence_Break>(0)},
{0xde6,Sentence_Break::Numeric},
{0xdf0,static_cast<Sentence_Break>(0)},
{0xdf2,Sentence_Break::Extend},
{0xdf4,static_cast<Sentence_Break>(0)},
{0xe01,Sentence_Break::OLetter},
{0xe31,Sentence_Break::Extend},
{0xe32,Sentence_Break::OLetter},
{0xe34,Sentence_Break::Extend},
{0xe3b,static_cast<Sentence_Break>(0)},
{0xe40,Sentence_Break::OLetter},
{0xe47,Sentence_Break::Extend},
{0xe4f,static_cast<Sentence_Break>(0)},
{0xe50,Sentence_Break::Numeric},
{0xe5a,static_cast<Sentence_Break>(0)},
{0xe81,Sentence_Break::OLetter},
{0xe83,static_cast<Sentence_Break>(0)},
{0xe84,Sentence_Break::OLetter},
{0xe85,static_cast<Sentence_Break>(0)},
{0xe87,Sentence_Break::OLetter},
{0xe89,static_cast<Sentence_Break>(0)},
{0xe8a,Sentence_Break::OLetter},
{0xe8b,static_cast<Sentence_Break>(0)},
{0xe8d,Sentence_Break::OLetter},
{0xe8e,static_cast<Sentence_Break>(0)},
{0xe94,Sentence_Break::OLetter},
{0xe98,static_cast<Sentence_Break>(0)},
{0xe99,Sentence_Break::OLetter},
{0xea0,static_cast<Sentence_Break>(0)},
{0xea1,Sentence_Break::OLetter},
{0xea4,static_cast<Sentence_Break>(0)},
{0xea5,Sentence_Break::OLetter},
{0xea6,static_cast<Sentence_Break>(0)},
{0xea7,Sentence_Break::OLetter},
{0xea8,static_cast<Sentence_Break>(0)},
{0xeaa,Sentence_Break::OLetter},
{0xeac,static_cast<Sentence_Break>(0)},
{0xead,Sentence_Break::OLetter},
{0xeb1,Sentence_Break::Extend},
{0xeb2,Sentence_Break::OLetter},
{0xeb4,Sentence_Break::Extend},
{0xeba,static_cast<Sentence_Break>(0)},
{0xebb,Sentence_Break::Extend},
{0xebd,Sentence_Break::OLetter},
{0xebe,static_cast<Sentence_Break>(0)},
{0xec0,Sentence_Break::OLetter},
{0xec5,static_cast<Sentence_Break>(0)},
{0xec6,Sentence_Break::OLetter},
{0xec7,static_cast<Sentence_Break>(0)},
{0xec8,Sentence_Break::Extend},
{0xece,static_cast<Sentence_Break>(0)},
{0xed0,Sentence_Break::Numeric},
{0xeda,static_cast<Sentence_Break>(0)},
{0xedc,Sentence_Break::OLetter},
{0xee0,static_cast<Sentence_Break>(0)},
{0xf00,Sentence_Break::OLetter},
{0xf01,static_cast<Sentence_Break>(0)},
{0xf18,Sentence_Break::Extend},
{0xf1a,static_cast<Sentence_Break>(0)},
{0xf20,Sentence_Break::Numeric},
{0xf2a,static_cast<Sentence_Break>(0)},
{0xf35,Sentence_Break::Extend},
{0xf36,static_cast<Sentence_Break>(0)},
{0xf37,Sentence_Break::Extend},
{0xf38,static_cast<Sentence_Break>(0)},
{0xf39,Sentence_Break::Extend},
{0xf3a,Sentence_Break::Close},
{0xf3e,Sentence_Break::Extend},
{0xf40,Sentence_Break::OLetter},
{0xf48,static_cast<Sentence_Break>(0)},
{0xf49,Sentence_Break::OLetter},
{0xf6d,static_cast<Sentence_Break>(0)},
{0xf71,Sentence_Break::Extend},
{0xf85,static_cast<Sentence_Break>(0)},
{0xf86,Sentence_Break::Extend},
{0xf88,Sentence_Break::OLetter},
{0xf8d,Sentence_Break::Extend},
{0xf98,static_cast<Sentence_Break>(0)},
{0xf99,Sentence_Break::Extend},
{0xfbd,static_cast<Sentence_Break>(0)},
{0xfc6,Sentence_Break::Extend},
{0xfc7,static_cast<Sentence_Break>(0)},
{0x1000,Sentence_Break::OLetter},
{0x102b,Sentence_Break::Extend},
{0x103f,Sentence_Break::OLetter},
{0x1040,Sentence_Break::Numeric},
{0x104a,Sentence_Break::STerm},
{0x104c,static_cast<Sentence_Break>(0)},
{0x1050,Sentence_Break::OLetter},
{0x1056,Sentence_Break::Extend},
{0x105a,Sentence_Break::OLetter},
{0x105e,Sentence_Break::Extend},
{0x1061,Sentence_Break::OLetter},
{0x1062,Sentence_Break::Extend},
{0x1065,Sentence_Break::OLetter},
{0x1067,Sentence_Break::Extend},
{0x106e,Sentence_Break::OLetter},
{0x1071,Sentence_Break::Extend},
{0x1075,Sentence_Break::OLetter},
{0x1082,Sentence_Break::Extend},
{0x108e,Sentence_Break::OLetter},
{0x108f,Sentence_Break::Extend},
{0x1090,Sentence_Break::Numeric},
{0x109a,Sentence_Break::Extend},
{0x109e,static_cast<Sentence_Break>(0)},
{0x10a0,Sentence_Break::Upper},
{0x10c6,static_cast<Sentence_Break>(0)},
{0x10c7,Sentence_Break::Upper},
{0x10c8,static_cast<Sentence_Break>(0)},
{0x10cd,Sentence_Break::Upper},
{0x10ce,static_cast<Sentence_Break>(0)},
{0x10d0,Sentence_Break::OLetter},
{0x10fb,static_cast<Sentence_Break>(0)},
{0x10fc,Sentence_Break::OLetter},
{0x1249,static_cast<Sentence_Break>(0)},
{0x124a,Sentence_Break::OLetter},
{0x124e,static_cast<Sentence_Break>(0)},
{0x1250,Sentence_Break::OLetter},
{0x1257,static_cast<Sentence_Break>(0)},
{0x1258,Sentence_Break::OLetter},
{0x1259,static_cast<Sentence_Break>(0)},
{0x125a,Sentence_Break::OLetter},
{0x125e,static_cast<Sentence_Break>(0)},
{0x1260,Sentence_Break::OLetter},
{0x1289,static_cast<Sentence_Break>(0)},
{0x128a,Sentence_Break::OLetter},
{0x128e,static_cast<Sentence_Break>(0)},
{0x1290,Sentence_Break::OLetter},
{0x12b1,static_cast<Sentence_Break>(0)},
{0x12b2,Sentence_Break::OLetter},
{0x12b6,static_cast<Sentence_Break>(0)},
{0x12b8,Sentence_Break::OLetter},
{0x12bf,static_cast<Sentence_Break>(0)},
{0x12c0,Sentence_Break::OLetter},
{0x12c1,static_cast<Sentence_Break>(0)},
{0x12c2,Sentence_Break::OLetter},
{0x12c6,static_cast<Sentence_Break>(0)},
{0x12c8,Sentence_Break::OLetter},
{0x12d7,static_cast<Sentence_Break>(0)},
{0x12d8,Sentence_Break::OLetter},
{0x1311,static_cast<Sentence_Break>(0)},
{0x1312,Sentence_Break::OLetter},
{0x1316,static_cast<Sentence_Break>(0)},
{0x1318,Sentence_Break::OLetter},
{0x135b,static_cast<Sentence_Break>(0)},
{0x135d,Sentence_Break::Extend},
{0x1360,static_cast<Sentence_Break>(0)},
{0x1362,Sentence_Break::STerm},
{0x1363,static_cast<Sentence_Break>(0)},
{0x1367,Sentence_Break::STerm},
{0x1369,static_cast<Sentence_Break>(0)},
{0x1380,Sentence_Break::OLetter},
{0x1390,static_cast<Sentence_Break>(0)},
{0x13a0,Sentence_Break::Upper},
{0x13f6,static_cast<Sentence_Break>(0)},
{0x13f8,Sentence_Break::Lower},
{0x13fe,static_cast<Sentence_Break>(0)},
{0x1401,Sentence_Break::OLetter},
{0x166d,static_cast<Sentence_Break>(0)},
{0x166e,Sentence_Break::STerm},
{0x166f,Sentence_Break::OLetter},
{0x1680,Sentence_Break::Sp},
{0x1681,Sentence_Break::OLetter},
{0x169b,Sentence_Break::Close},
{0x169d,static_cast<Sentence_Break>(0)},
{0x16a0,Sentence_Break::OLetter},
{0x16eb,static_cast<Sentence_Break>(0)},
{0x16ee,Sentence_Break::OLetter},
{0x16f9,static_cast<Sentence_Break>(0)},
{0x1700,Sentence_Break::OLetter},
{0x170d,static_cast<Sentence_Break>(0)},
{0x170e,Sentence_Break::OLetter},
{0x1712,Sentence_Break::Extend},
{0x1715,static_cast<Sentence_Break>(0)},
{0x1720,Sentence_Break::OLetter},
{0x1732,Sentence_Break::Extend},
{0x1735,Sentence_Break::STerm},
{0x1737,static_cast<Sentence_Break>(0)},
{0x1740,Sentence_Break::OLetter},
{0x1752,Sentence_Break::Extend},
{0x1754,static_cast<Sentence_Break>(0)},
{0x1760,Sentence_Break::OLetter},
{0x176d,static_cast<Sentence_Break>(0)},
{0x176e,Sentence_Break::OLetter},
{0x1771,static_cast<Sentence_Break>(0)},
{0x1772,Sentence_Break::Extend},
{0x1774,static_cast<Sentence_Break>(0)},
{0x1780,Sentence_Break::OLetter},
{0x17b4,Sentence_Break::Extend},
{0x17d4,static_cast<Sentence_Break>(0)},
{0x17d7,Sentence_Break::OLetter},
{0x17d8,static_cast<Sentence_Break>(0)},
{0x17dc,Sentence_Break::OLetter},
{0x17dd,Sentence_Break::Extend},
{0x17de,static_cast<Sentence_Break>(0)},
{0x17e0,Sentence_Break::Numeric},
{0x17ea,static_cast<Sentence_Break>(0)},
{0x1802,Sentence_Break::SContinue},
{0x1803,Sentence_Break::STerm},
{0x1804,static_cast<Sentence_Break>(0)},
{0x1808,Sentence_Break::SContinue},
{0x1809,Sentence_Break::STerm},
{0x180a,static_cast<Sentence_Break>(0)},
{0x180b,Sentence_Break::Extend},
{0x180e,Sentence_Break::Format},
{0x180f,static_cast<Sentence_Break>(0)},
{0x1810,Sentence_Break::Numeric},
{0x181a,static_cast<Sentence_Break>(0)},
{0x1820,Sentence_Break::OLetter},
{0x1878,static_cast<Sentence_Break>(0)},
{0x1880,Sentence_Break::OLetter},
{0x18a9,Sentence_Break::Extend},
{0x18aa,Sentence_Break::OLetter},
{0x18ab,static_cast<Sentence_Break>(0)},
{0x18b0,Sentence_Break::OLetter},
{0x18f6,static_cast<Sentence_Break>(0)},
{0x1900,Sentence_Break::OLetter},
{0x191f,static_cast<Sentence_Break>(0)},
{0x1920,Sentence_Break::Extend},
{0x192c,static_cast<Sentence_Break>(0)},
{0x1930,Sentence_Break::Extend},
{0x193c,static_cast<Sentence_Break>(0)},
{0x1944,Sentence_Break::STerm},
{0x1946,Sentence_Break::Numeric},
{0x1950,Sentence_Break::OLetter},
{0x196e,static_cast<Sentence_Break>(0)},
{0x1970,Sentence_Break::OLetter},
{0x1975,static_cast<Sentence_Break>(0)},
{0x1980,Sentence_Break::OLetter},
{0x19ac,static_cast<Sentence_Break>(0)},
{0x19b0,Sentence_Break::OLetter},
{0x19ca,static_cast<Sentence_Break>(0)},
{0x19d0,Sentence_Break::Numeric},
{0x19da,static_cast<Sentence_Break>(0)},
{0x1a00,Sentence_Break::OLetter},
{0x1a17,Sentence_Break::Extend},
{0x1a1c,static_cast<Sentence_Break>(0)},
{0x1a20,Sentence_Break::OLetter},
{0x1a55,Sentence_Break::Extend},
{0x1a5f,static_cast<Sentence_Break>(0)},
{0x1a60,Sentence_Break::Extend},
{0x1a7d,static_cast<Sentence_Break>(0)},
{0x1a7f,Sentence_Break::Extend},
{0x1a80,Sentence_Break::Numeric},
{0x1a8a,static_cast<Sentence_Break>(0)},
{0x1a90,Sentence_Break::Numeric},
{0x1a9a,static_cast<Sentence_Break>(0)},
{0x1aa7,Sentence_Break::OLetter},
{0x1aa8,Sentence_Break::STerm},
{0x1aac,static_cast<Sentence_Break>(0)},
{0x1ab0,Sentence_Break::Extend},
{0x1abf,static_cast<Sentence_Break>(0)},
{0x1b00,Sentence_Break::Extend},
{0x1b05,Sentence_Break::OLetter},
{0x1b34,Sentence_Break::Extend},
{0x1b45,Sentence_Break::OLetter},
{0x1b4c,static_cast<Sentence_Break>(0)},
{0x1b50,Sentence_Break::Numeric},
{0x1b5a,Sentence_Break::STerm},
{0x1b5c,static_cast<Sentence_Break>(0)},
{0x1b5e,Sentence_Break::STerm},
{0x1b60,static_cast<Sentence_Break>(0)},
{0x1b6b,Sentence_Break::Extend},
{0x1b74,static_cast<Sentence_Break>(0)},
{0x1b80,Sentence_Break::Extend},
{0x1b83,Sentence_Break::OLetter},
{0x1ba1,Sentence_Break::Extend},
{0x1bae,Sentence_Break::OLetter},
{0x1bb0,Sentence_Break::Numeric},
{0x1bba,Sentence_Break::OLetter},
{0x1be6,Sentence_Break::Extend},
{0x1bf4,static_cast<Sentence_Break>(0)},
{0x1c00,Sentence_Break::OLetter},
{0x1c24,Sentence_Break::Extend},
{0x1c38,static_cast<Sentence_Break>(0)},
{0x1c3b,Sentence_Break::STerm},
{0x1c3d,static_cast<Sentence_Break>(0)},
{0x1c40,Sentence_Break::Numeric},
{0x1c4a,static_cast<Sentence_Break>(0)},
{0x1c4d,Sentence_Break::OLetter},
{0x1c50,Sentence_Break::Numeric},
{0x1c5a,Sentence_Break::OLetter},
{0x1c7e,Sentence_Break::STerm},
{0x1c80,static_cast<Sentence_Break>(0)},
{0x1cd0,Sentence_Break::Extend},
{0x1cd3,static_cast<Sentence_Break>(0)},
{0x1cd4,Sentence_Break::Extend},
{0x1ce9,Sentence_Break::OLetter},
{0x1ced,Sentence_Break::Extend},
{0x1cee,Sentence_Break::OLetter},
{0x1cf2,Sentence_Break::Extend},
{0x1cf5,Sentence_Break::OLetter},
{0x1cf7,static_cast<Sentence_Break>(0)},
{0x1cf8,Sentence_Break::Extend},
{0x1cfa,static_cast<Sentence_Break>(0)},
{0x1d00,Sentence_Break::Lower},
{0x1dc0,Sentence_Break::Extend},
{0x1df6,static_cast<Sentence_Break>(0)},
{0x1dfc,Sentence_Break::Extend},
{0x1e00,Sentence_Break::Upper},
{0x1e01,Sentence_Break::Lower},
{0x1e02,Sentence_Break::Upper},
{0x1e03,Sentence_Break::Lower},
{0x1e04,Sentence_Break::Upper},
{0x1e05,Sentence_Break::Lower},
{0x1e06,Sentence_Break::Upper},
{0x1e07,Sentence_Break::Lower},
{0x1e08,Sentence_Break::Upper},
{0x1e09,Sentence_Break::Lower},
{0x1e0a,Sentence_Break::Upper},
{0x1e0b,Sentence_Break::Lower},
{0x1e0c,Sentence_Break::Upper},
{0x1e0d,Sentence_Break::Lower},
{0x1e0e,Sentence_Break::Upper},
{0x1e0f,Sentence_Break::Lower},
{0x1e10,Sentence_Break::Upper},
{0x1e11,Sentence_Break::Lower},
{0x1e12,Sentence_Break::Upper},
{0x1e13,Sentence_Break::Lower},
{0x1e14,Sentence_Break::Upper},
{0x1e15,Sentence_Break::Lower},
{0x1e16,Sentence_Break::Upper},
{0x1e17,Sentence_Break::Lower},
{0x1e18,Sentence_Break::Upper},
{0x1e19,Sentence_Break::Lower},
{0x1e1a,Sentence_Break::Upper},
{0x1e1b,Sentence_Break::Lower},
{0x1e1c,Sentence_Break::Upper},
{0x1e1d,Sentence_Break::Lower},
{0x1e1e,Sentence_Break::Upper},
{0x1e1f,Sentence_Break::Lower},
{0x1e20,Sentence_Break::Upper},
{0x1e21,Sentence_Break::Lower},
{0x1e22,Sentence_Break::Upper},
{0x1e23,Sentence_Break::Lower},
{0x1e24,Sentence_Break::Upper},
{0x1e25,Sentence_Break::Lower},
{0x1e26,Sentence_Break::Upper},
{0x1e27,Sentence_Break::Lower},
{0x1e28,Sentence_Break::Upper},
{0x1e29,Sentence_Break::Lower},
{0x1e2a,Sentence_Break::Upper},
{0x1e2b,Sentence_Break::Lower},
{0x1e2c,Sentence_Break::Upper},
{0x1e2d,Sentence_Break::Lower},
{0x1e2e,Sentence_Break::Upper},
{0x1e2f,Sentence_Break::Lower},
{0x1e30,Sentence_Break::Upper},
{0x1e31,Sentence_Break::Lower},
{0x1e32,Sentence_Break::Upper},
{0x1e33,Sentence_Break::Lower},
{0x1e34,Sentence_Break::Upper},
{0x1e35,Sentence_Break::Lower},
{0x1e36,Sentence_Break::Upper},
{0x1e37,Sentence_Break::Lower},
{0x1e38,Sentence_Break::Upper},
{0x1e39,Sentence_Break::Lower},
{0x1e3a,Sentence_Break::Upper},
{0x1e3b,Sentence_Break::Lower},
{0x1e3c,Sentence_Break::Upper},
{0x1e3d,Sentence_Break::Lower},
{0x1e3e,Sentence_Break::Upper},
{0x1e3f,Sentence_Break::Lower},
{0x1e40,Sentence_Break::Upper},
{0x1e41,Sentence_Break::Lower},
{0x1e42,Sentence_Break::Upper},
{0x1e43,Sentence_Break::Lower},
{0x1e44,Sentence_Break::Upper},
{0x1e45,Sentence_Break::Lower},
{0x1e46,Sentence_Break::Upper},
{0x1e47,Sentence_Break::Lower},
{0x1e48,Sentence_Break::Upper},
{0x1e49,Sentence_Break::Lower},
{0x1e4a,Sentence_Break::Upper},
{0x1e4b,Sentence_Break::Lower},
{0x1e4c,Sentence_Break::Upper},
{0x1e4d,Sentence_Break::Lower},
{0x1e4e,Sentence_Break::Upper},
{0x1e4f,Sentence_Break::Lower},
{0x1e50,Sentence_Break::Upper},
{0x1e51,Sentence_Break::Lower},
{0x1e52,Sentence_Break::Upper},
{0x1e53,Sentence_Break::Lower},
{0x1e54,Sentence_Break::Upper},
{0x1e55,Sentence_Break::Lower},
{0x1e56,Sentence_Break::Upper},
{0x1e57,Sentence_Break::Lower},
{0x1e58,Sentence_Break::Upper},
{0x1e59,Sentence_Break::Lower},
{0x1e5a,Sentence_Break::Upper},
{0x1e5b,Sentence_Break::Lower},
{0x1e5c,Sentence_Break::Upper},
{0x1e5d,Sentence_Break::Lower},
{0x1e5e,Sentence_Break::Upper},
{0x1e5f,Sentence_Break::Lower},
{0x1e60,Sentence_Break::Upper},
{0x1e61,Sentence_Break::Lower},
{0x1e62,Sentence_Break::Upper},
{0x1e63,Sentence_Break::Lower},
{0x1e64,Sentence_Break::Upper},
{0x1e65,Sentence_Break::Lower},
{0x1e66,Sentence_Break::Upper},
{0x1e67,Sentence_Break::Lower},
{0x1e68,Sentence_Break::Upper},
{0x1e69,Sentence_Break::Lower},
{0x1e6a,Sentence_Break::Upper},
{0x1e6b,Sentence_Break::Lower},
{0x1e6c,Sentence_Break::Upper},
{0x1e6d,Sentence_Break::Lower},
{0x1e6e,Sentence_Break::Upper},
{0x1e6f,Sentence_Break::Lower},
{0x1e70,Sentence_Break::Upper},
{0x1e71,Sentence_Break::Lower},
{0x1e72,Sentence_Break::Upper},
{0x1e73,Sentence_Break::Lower},
{0x1e74,Sentence_Break::Upper},
{0x1e75,Sentence_Break::Lower},
{0x1e76,Sentence_Break::Upper},
{0x1e77,Sentence_Break::Lower},
{0x1e78,Sentence_Break::Upper},
{0x1e79,Sentence_Break::Lower},
{0x1e7a,Sentence_Break::Upper},
{0x1e7b,Sentence_Break::Lower},
{0x1e7c,Sentence_Break::Upper},
{0x1e7d,Sentence_Break::Lower},
{0x1e7e,Sentence_Break::Upper},
{0x1e7f,Sentence_Break::Lower},
{0x1e80,Sentence_Break::Upper},
{0x1e81,Sentence_Break::Lower},
{0x1e82,Sentence_Break::Upper},
{0x1e83,Sentence_Break::Lower},
{0x1e84,Sentence_Break::Upper},
{0x1e85,Sentence_Break::Lower},
{0x1e86,Sentence_Break::Upper},
{0x1e87,Sentence_Break::Lower},
{0x1e88,Sentence_Break::Upper},
{0x1e89,Sentence_Break::Lower},
{0x1e8a,Sentence_Break::Upper},
{0x1e8b,Sentence_Break::Lower},
{0x1e8c,Sentence_Break::Upper},
{0x1e8d,Sentence_Break::Lower},
{0x1e8e,Sentence_Break::Upper},
{0x1e8f,Sentence_Break::Lower},
{0x1e90,Sentence_Break::Upper},
{0x1e91,Sentence_Break::Lower},
{0x1e92,Sentence_Break::Upper},
{0x1e93,Sentence_Break::Lower},
{0x1e94,Sentence_Break::Upper},
{0x1e95,Sentence_Break::Lower},
{0x1e9e,Sentence_Break::Upper},
{0x1e9f,Sentence_Break::Lower},
{0x1ea0,Sentence_Break::Upper},
{0x1ea1,Sentence_Break::Lower},
{0x1ea2,Sentence_Break::Upper},
{0x1ea3,Sentence_Break::Lower},
{0x1ea4,Sentence_Break::Upper},
{0x1ea5,Sentence_Break::Lower},
{0x1ea6,Sentence_Break::Upper},
{0x1ea7,Sentence_Break::Lower},
{0x1ea8,Sentence_Break::Upper},
{0x1ea9,Sentence_Break::Lower},
{0x1eaa,Sentence_Break::Upper},
{0x1eab,Sentence_Break::Lower},
{0x1eac,Sentence_Break::Upper},
{0x1ead,Sentence_Break::Lower},
{0x1eae,Sentence_Break::Upper},
{0x1eaf,Sentence_Break::Lower},
{0x1eb0,Sentence_Break::Upper},
{0x1eb1,Sentence_Break::Lower},
{0x1eb2,Sentence_Break::Upper},
{0x1eb3,Sentence_Break::Lower},
{0x1eb4,Sentence_Break::Upper},
{0x1eb5,Sentence_Break::Lower},
{0x1eb6,Sentence_Break::Upper},
{0x1eb7,Sentence_Break::Lower},
{0x1eb8,Sentence_Break::Upper},
{0x1eb9,Sentence_Break::Lower},
{0x1eba,Sentence_Break::Upper},
{0x1ebb,Sentence_Break::Lower},
{0x1ebc,Sentence_Break::Upper},
{0x1ebd,Sentence_Break::Lower},
{0x1ebe,Sentence_Break::Upper},
{0x1ebf,Sentence_Break::Lower},
{0x1ec0,Sentence_Break::Upper},
{0x1ec1,Sentence_Break::Lower},
{0x1ec2,Sentence_Break::Upper},
{0x1ec3,Sentence_Break::Lower},
{0x1ec4,Sentence_Break::Upper},
{0x1ec5,Sentence_Break::Lower},
{0x1ec6,Sentence_Break::Upper},
{0x1ec7,Sentence_Break::Lower},
{0x1ec8,Sentence_Break::Upper},
{0x1ec9,Sentence_Break::Lower},
{0x1eca,Sentence_Break::Upper},
{0x1ecb,Sentence_Break::Lower},
{0x1ecc,Sentence_Break::Upper},
{0x1ecd,Sentence_Break::Lower},
{0x1ece,Sentence_Break::Upper},
{0x1ecf,Sentence_Break::Lower},
{0x1ed0,Sentence_Break::Upper},
{0x1ed1,Sentence_Break::Lower},
{0x1ed2,Sentence_Break::Upper},
{0x1ed3,Sentence_Break::Lower},
{0x1ed4,Sentence_Break::Upper},
{0x1ed5,Sentence_Break::Lower},
{0x1ed6,Sentence_Break::Upper},
{0x1ed7,Sentence_Break::Lower},
{0x1ed8,Sentence_Break::Upper},
{0x1ed9,Sentence_Break::Lower},
{0x1eda,Sentence_Break::Upper},
{0x1edb,Sentence_Break::Lower},
{0x1edc,Sentence_Break::Upper},
{0x1edd,Sentence_Break::Lower},
{0x1ede,Sentence_Break::Upper},
{0x1edf,Sentence_Break::Lower},
{0x1ee0,Sentence_Break::Upper},
{0x1ee1,Sentence_Break::Lower},
{0x1ee2,Sentence_Break::Upper},
{0x1ee3,Sentence_Break::Lower},
{0x1ee4,Sentence_Break::Upper},
{0x1ee5,Sentence_Break::Lower},
{0x1ee6,Sentence_Break::Upper},
{0x1ee7,Sentence_Break::Lower},
{0x1ee8,Sentence_Break::Upper},
{0x1ee9,Sentence_Break::Lower},
{0x1eea,Sentence_Break::Upper},
{0x1eeb,Sentence_Break::Lower},
{0x1eec,Sentence_Break::Upper},
{0x1eed,Sentence_Break::Lower},
{0x1eee,Sentence_Break::Upper},
{0x1eef,Sentence_Break::Lower},
{0x1ef0,Sentence_Break::Upper},
{0x1ef1,Sentence_Break::Lower},
{0x1ef2,Sentence_Break::Upper},
{0x1ef3,Sentence_Break::Lower},
{0x1ef4,Sentence_Break::Upper},
{0x1ef5,Sentence_Break::Lower},
{0x1ef6,Sentence_Break::Upper},
{0x1ef7,Sentence_Break::Lower},
{0x1ef8,Sentence_Break::Upper},
{0x1ef9,Sentence_Break::Lower},
{0x1efa,Sentence_Break::Upper},
{0x1efb,Sentence_Break::Lower},
{0x1efc,Sentence_Break::Upper},
{0x1efd,Sentence_Break::Lower},
{0x1efe,Sentence_Break::Upper},
{0x1eff,Sentence_Break::Lower},
{0x1f08,Sentence_Break::Upper},
{0x1f10,Sentence_Break::Lower},
{0x1f16,static_cast<Sentence_Break>(0)},
{0x1f18,Sentence_Break::Upper},
{0x1f1e,static_cast<Sentence_Break>(0)},
{0x1f20,Sentence_Break::Lower},
{0x1f28,Sentence_Break::Upper},
{0x1f30,Sentence_Break::Lower},
{0x1f38,Sentence_Break::Upper},
{0x1f40,Sentence_Break::Lower},
{0x1f46,static_cast<Sentence_Break>(0)},
{0x1f48,Sentence_Break::Upper},
{0x1f4e,static_cast<Sentence_Break>(0)},
{0x1f50,Sentence_Break::Lower},
{0x1f58,static_cast<Sentence_Break>(0)},
{0x1f59,Sentence_Break::Upper},
{0x1f5a,static_cast<Sentence_Break>(0)},
{0x1f5b,Sentence_Break::Upper},
{0x1f5c,static_cast<Sentence_Break>(0)},
{0x1f5d,Sentence_Break::Upper},
{0x1f5e,static_cast<Sentence_Break>(0)},
{0x1f5f,Sentence_Break::Upper},
{0x1f60,Sentence_Break::Lower},
{0x1f68,Sentence_Break::Upper},
{0x1f70,Sentence_Break::Lower},
{0x1f7e,static_cast<Sentence_Break>(0)},
{0x1f80,Sentence_Break::Lower},
{0x1f88,Sentence_Break::Upper},
{0x1f90,Sentence_Break::Lower},
{0x1f98,Sentence_Break::Upper},
{0x1fa0,Sentence_Break::Lower},
{0x1fa8,Sentence_Break::Upper},
{0x1fb0,Sentence_Break::Lower},
{0x1fb5,static_cast<Sentence_Break>(0)},
{0x1fb6,Sentence_Break::Lower},
{0x1fb8,Sentence_Break::Upper},
{0x1fbd,static_cast<Sentence_Break>(0)},
{0x1fbe,Sentence_Break::Lower},
{0x1fbf,static_cast<Sentence_Break>(0)},
{0x1fc2,Sentence_Break::Lower},
{0x1fc5,static_cast<Sentence_Break>(0)},
{0x1fc6,Sentence_Break::Lower},
{0x1fc8,Sentence_Break::Upper},
{0x1fcd,static_cast<Sentence_Break>(0)},
{0x1fd0,Sentence_Break::Lower},
{0x1fd4,static_cast<Sentence_Break>(0)},
{0x1fd6,Sentence_Break::Lower},
{0x1fd8,Sentence_Break::Upper},
{0x1fdc,static_cast<Sentence_Break>(0)},
{0x1fe0,Sentence_Break::Lower},
{0x1fe8,Sentence_Break::Upper},
{0x1fed,static_cast<Sentence_Break>(0)},
{0x1ff2,Sentence_Break::Lower},
{0x1ff5,static_cast<Sentence_Break>(0)},
{0x1ff6,Sentence_Break::Lower},
{0x1ff8,Sentence_Break::Upper},
{0x1ffd,static_cast<Sentence_Break>(0)},
{0x2000,Sentence_Break::Sp},
{0x200b,Sentence_Break::Format},
{0x200c,Sentence_Break::Extend},
{0x200e,Sentence_Break::Format},
{0x2010,static_cast<Sentence_Break>(0)},
{0x2013,Sentence_Break::SContinue},
{0x2015,static_cast<Sentence_Break>(0)},
{0x2018,Sentence_Break::Close},
{0x2020,static_cast<Sentence_Break>(0)},
{0x2024,Sentence_Break::ATerm},
{0x2025,static_cast<Sentence_Break>(0)},
{0x2028,Sentence_Break::Sep},
{0x202a,Sentence_Break::Format},
{0x202f,Sentence_Break::Sp},
{0x2030,static_cast<Sentence_Break>(0)},
{0x2039,Sentence_Break::Close},
{0x203b,static_cast<Sentence_Break>(0)},
{0x203c,Sentence_Break::STerm},
{0x203e,static_cast<Sentence_Break>(0)},
{0x2045,Sentence_Break::Close},
{0x2047,Sentence_Break::STerm},
{0x204a,static_cast<Sentence_Break>(0)},
{0x205f,Sentence_Break::Sp},
{0x2060,Sentence_Break::Format},
{0x2065,static_cast<Sentence_Break>(0)},
{0x2066,Sentence_Break::Format},
{0x2070,static_cast<Sentence_Break>(0)},
{0x2071,Sentence_Break::Lower},
{0x2072,static_cast<Sentence_Break>(0)},
{0x207d,Sentence_Break::Close},
{0x207f,Sentence_Break::Lower},
{0x2080,static_cast<Sentence_Break>(0)},
{0x208d,Sentence_Break::Close},
{0x208f,static_cast<Sentence_Break>(0)},
{0x2090,Sentence_Break::Lower},
{0x209d,static_cast<Sentence_Break>(0)},
{0x20d0,Sentence_Break::Extend},
{0x20f1,static_cast<Sentence_Break>(0)},
{0x2102,Sentence_Break::Upper},
{0x2103,static_cast<Sentence_Break>(0)},
{0x2107,Sentence_Break::Upper},
{0x2108,static_cast<Sentence_Break>(0)},
{0x210a,Sentence_Break::Lower},
{0x210b,Sentence_Break::Upper},
{0x210e,Sentence_Break::Lower},
{0x2110,Sentence_Break::Upper},
{0x2113,Sentence_Break::Lower},
{0x2114,static_cast<Sentence_Break>(0)},
{0x2115,Sentence_Break::Upper},
{0x2116,static_cast<Sentence_Break>(0)},
{0x2119,Sentence_Break::Upper},
{0x211e,static_cast<Sentence_Break>(0)},
{0x2124,Sentence_Break::Upper},
{0x2125,static_cast<Sentence_Break>(0)},
{0x2126,Sentence_Break::Upper},
{0x2127,static_cast<Sentence_Break>(0)},
{0x2128,Sentence_Break::Upper},
{0x2129,static_cast<Sentence_Break>(0)},
{0x212a,Sentence_Break::Upper},
{0x212e,static_cast<Sentence_Break>(0)},
{0x212f,Sentence_Break::Lower},
{0x2130,Sentence_Break::Upper},
{0x2134,Sentence_Break::Lower},
{0x2135,Sentence_Break::OLetter},
{0x2139,Sentence_Break::Lower},
{0x213a,static_cast<Sentence_Break>(0)},
{0x213c,Sentence_Break::Lower},
{0x213e,Sentence_Break::Upper},
{0x2140,static_cast<Sentence_Break>(0)},
{0x2145,Sentence_Break::Upper},
{0x2146,Sentence_Break::Lower},
{0x214a,static_cast<Sentence_Break>(0)},
{0x214e,Sentence_Break::Lower},
{0x214f,static_cast<Sentence_Break>(0)},
{0x2160,Sentence_Break::Upper},
{0x2170,Sentence_Break::Lower},
{0x2180,Sentence_Break::OLetter},
{0x2183,Sentence_Break::Upper},
{0x2184,Sentence_Break::Lower},
{0x2185,Sentence_Break::OLetter},
{0x2189,static_cast<Sentence_Break>(0)},
{0x2308,Sentence_Break::Close},
{0x230c,static_cast<Sentence_Break>(0)},
{0x2329,Sentence_Break::Close},
{0x232b,static_cast<Sentence_Break>(0)},
{0x24b6,Sentence_Break::Upper},
{0x24d0,Sentence_Break::Lower},
{0x24ea,static_cast<Sentence_Break>(0)},
{0x275b,Sentence_Break::Close},
{0x2761,static_cast<Sentence_Break>(0)},
{0x2768,Sentence_Break::Close},
{0x2776,static_cast<Sentence_Break>(0)},
{0x27c5,Sentence_Break::Close},
{0x27c7,static_cast<Sentence_Break>(0)},
{0x27e6,Sentence_Break::Close},
{0x27f0,static_cast<Sentence_Break>(0)},
{0x2983,Sentence_Break::Close},
{0x2999,static_cast<Sentence_Break>(0)},
{0x29d8,Sentence_Break::Close},
{0x29dc,static_cast<Sentence_Break>(0)},
{0x29fc,Sentence_Break::Close},
{0x29fe,static_cast<Sentence_Break>(0)},
{0x2c00,Sentence_Break::Upper},
{0x2c2f,static_cast<Sentence_Break>(0)},
{0x2c30,Sentence_Break::Lower},
{0x2c5f,static_cast<Sentence_Break>(0)},
{0x2c60,Sentence_Break::Upper},
{0x2c61,Sentence_Break::Lower},
{0x2c62,Sentence_Break::Upper},
{0x2c65,Sentence_Break::Lower},
{0x2c67,Sentence_Break::Upper},
{0x2c68,Sentence_Break::Lower},
{0x2c69,Sentence_Break::Upper},
{0x2c6a,Sentence_Break::Lower},
{0x2c6b,Sentence_Break::Upper},
{0x2c6c,Sentence_Break::Lower},
{0x2c6d,Sentence_Break::Upper},
{0x2c71,Sentence_Break::Lower},
{0x2c72,Sentence_Break::Upper},
{0x2c73,Sentence_Break::Lower},
{0x2c75,Sentence_Break::Upper},
{0x2c76,Sentence_Break::Lower},
{0x2c7e,Sentence_Break::Upper},
{0x2c81,Sentence_Break::Lower},
{0x2c82,Sentence_Break::Upper},
{0x2c83,Sentence_Break::Lower},
{0x2c84,Sentence_Break::Upper},
{0x2c85,Sentence_Break::Lower},
{0x2c86,Sentence_Break::Upper},
{0x2c87,Sentence_Break::Lower},
{0x2c88,Sentence_Break::Upper},
{0x2c89,Sentence_Break::Lower},
{0x2c8a,Sentence_Break::Upper},
{0x2c8b,Sentence_Break::Lower},
{0x2c8c,Sentence_Break::Upper},
{0x2c8d,Sentence_Break::Lower},
{0x2c8e,Sentence_Break::Upper},
{0x2c8f,Sentence_Break::Lower},
{0x2c90,Sentence_Break::Upper},
{0x2c91,Sentence_Break::Lower},
{0x2c92,Sentence_Break::Upper},
{0x2c93,Sentence_Break::Lower},
{0x2c94,Sentence_Break::Upper},
{0x2c95,Sentence_Break::Lower},
{0x2c96,Sentence_Break::Upper},
{0x2c97,Sentence_Break::Lower},
{0x2c98,Sentence_Break::Upper},
{0x2c99,Sentence_Break::Lower},
{0x2c9a,Sentence_Break::Upper},
{0x2c9b,Sentence_Break::Lower},
{0x2c9c,Sentence_Break::Upper},
{0x2c9d,Sentence_Break::Lower},
{0x2c9e,Sentence_Break::Upper},
{0x2c9f,Sentence_Break::Lower},
{0x2ca0,Sentence_Break::Upper},
{0x2ca1,Sentence_Break::Lower},
{0x2ca2,Sentence_Break::Upper},
{0x2ca3,Sentence_Break::Lower},
{0x2ca4,Sentence_Break::Upper},
{0x2ca5,Sentence_Break::Lower},
{0x2ca6,Sentence_Break::Upper},
{0x2ca7,Sentence_Break::Lower},
{0x2ca8,Sentence_Break::Upper},
{0x2ca9,Sentence_Break::Lower},
{0x2caa,Sentence_Break::Upper},
{0x2cab,Sentence_Break::Lower},
{0x2cac,Sentence_Break::Upper},
{0x2cad,Sentence_Break::Lower},
{0x2cae,Sentence_Break::Upper},
{0x2caf,Sentence_Break::Lower},
{0x2cb0,Sentence_Break::Upper},
{0x2cb1,Sentence_Break::Lower},
{0x2cb2,Sentence_Break::Upper},
{0x2cb3,Sentence_Break::Lower},
{0x2cb4,Sentence_Break::Upper},
{0x2cb5,Sentence_Break::Lower},
{0x2cb6,Sentence_Break::Upper},
{0x2cb7,Sentence_Break::Lower},
{0x2cb8,Sentence_Break::Upper},
{0x2cb9,Sentence_Break::Lower},
{0x2cba,Sentence_Break::Upper},
{0x2cbb,Sentence_Break::Lower},
{0x2cbc,Sentence_Break::Upper},
{0x2cbd,Sentence_Break::Lower},
{0x2cbe,Sentence_Break::Upper},
{0x2cbf,Sentence_Break::Lower},
{0x2cc0,Sentence_Break::Upper},
{0x2cc1,Sentence_Break::Lower},
{0x2cc2,Sentence_Break::Upper},
{0x2cc3,Sentence_Break::Lower},
{0x2cc4,Sentence_Break::Upper},
{0x2cc5,Sentence_Break::Lower},
{0x2cc6,Sentence_Break::Upper},
{0x2cc7,Sentence_Break::Lower},
{0x2cc8,Sentence_Break::Upper},
{0x2cc9,Sentence_Break::Lower},
{0x2cca,Sentence_Break::Upper},
{0x2ccb,Sentence_Break::Lower},
{0x2ccc,Sentence_Break::Upper},
{0x2ccd,Sentence_Break::Lower},
{0x2cce,Sentence_Break::Upper},
{0x2ccf,Sentence_Break::Lower},
{0x2cd0,Sentence_Break::Upper},
{0x2cd1,Sentence_Break::Lower},
{0x2cd2,Sentence_Break::Upper},
{0x2cd3,Sentence_Break::Lower},
{0x2cd4,Sentence_Break::Upper},
{0x2cd5,Sentence_Break::Lower},
{0x2cd6,Sentence_Break::Upper},
{0x2cd7,Sentence_Break::Lower},
{0x2cd8,Sentence_Break::Upper},
{0x2cd9,Sentence_Break::Lower},
{0x2cda,Sentence_Break::Upper},
{0x2cdb,Sentence_Break::Lower},
{0x2cdc,Sentence_Break::Upper},
{0x2cdd,Sentence_Break::Lower},
{0x2cde,Sentence_Break::Upper},
{0x2cdf,Sentence_Break::Lower},
{0x2ce0,Sentence_Break::Upper},
{0x2ce1,Sentence_Break::Lower},
{0x2ce2,Sentence_Break::Upper},
{0x2ce3,Sentence_Break::Lower},
{0x2ce5,static_cast<Sentence_Break>(0)},
{0x2ceb,Sentence_Break::Upper},
{0x2cec,Sentence_Break::Lower},
{0x2ced,Sentence_Break::Upper},
{0x2cee,Sentence_Break::Lower},
{0x2cef,Sentence_Break::Extend},
{0x2cf2,Sentence_Break::Upper},
{0x2cf3,Sentence_Break::Lower},
{0x2cf4,static_cast<Sentence_Break>(0)},
{0x2d00,Sentence_Break::Lower},
{0x2d26,static_cast<Sentence_Break>(0)},
{0x2d27,Sentence_Break::Lower},
{0x2d28,static_cast<Sentence_Break>(0)},
{0x2d2d,Sentence_Break::Lower},
{0x2d2e,static_cast<Sentence_Break>(0)},
{0x2d30,Sentence_Break::OLetter},
{0x2d68,static_cast<Sentence_Break>(0)},
{0x2d6f,Sentence_Break::OLetter},
{0x2d70,static_cast<Sentence_Break>(0)},
{0x2d7f,Sentence_Break::Extend},
{0x2d80,Sentence_Break::OLetter},
{0x2d97,static_cast<Sentence_Break>(0)},
{0x2da0,Sentence_Break::OLetter},
{0x2da7,static_cast<Sentence_Break>(0)},
{0x2da8,Sentence_Break::OLetter},
{0x2daf,static_cast<Sentence_Break>(0)},
{0x2db0,Sentence_Break::OLetter},
{0x2db7,static_cast<Sentence_Break>(0)},
{0x2db8,Sentence_Break::OLetter},
{0x2dbf,static_cast<Sentence_Break>(0)},
{0x2dc0,Sentence_Break::OLetter},
{0x2dc7,static_cast<Sentence_Break>(0)},
{0x2dc8,Sentence_Break::OLetter},
{0x2dcf,static_cast<Sentence_Break>(0)},
{0x2dd0,Sentence_Break::OLetter},
{0x2dd7,static_cast<Sentence_Break>(0)},
{0x2dd8,Sentence_Break::OLetter},
{0x2ddf,static_cast<Sentence_Break>(0)},
{0x2de0,Sentence_Break::Extend},
{0x2e00,Sentence_Break::Close},
{0x2e0e,static_cast<Sentence_Break>(0)},
{0x2e1c,Sentence_Break::Close},
{0x2e1e,static_cast<Sentence_Break>(0)},
{0x2e20,Sentence_Break::Close},
{0x2e2a,static_cast<Sentence_Break>(0)},
{0x2e2e,Sentence_Break::STerm},
{0x2e2f,Sentence_Break::OLetter},
{0x2e30,static_cast<Sentence_Break>(0)},
{0x2e3c,Sentence_Break::STerm},
{0x2e3d,static_cast<Sentence_Break>(0)},
{0x2e42,Sentence_Break::Close},
{0x2e43,static_cast<Sentence_Break>(0)},
{0x3000,Sentence_Break::Sp},
{0x3001,Sentence_Break::SContinue},
{0x3002,Sentence_Break::STerm},
{0x3003,static_cast<Sentence_Break>(0)},
{0x3005,Sentence_Break::OLetter},
{0x3008,Sentence_Break::Close},
{0x3012,static_cast<Sentence_Break>(0)},
{0x3014,Sentence_Break::Close},
{0x301c,static_cast<Sentence_Break>(0)},
{0x301d,Sentence_Break::Close},
{0x3020,static_cast<Sentence_Break>(0)},
{0x3021,Sentence_Break::OLetter},
{0x302a,Sentence_Break::Extend},
{0x3030,static_cast<Sentence_Break>(0)},
{0x3031,Sentence_Break::OLetter},
{0x3036,static_cast<Sentence_Break>(0)},
{0x3038,Sentence_Break::OLetter},
{0x303d,static_cast<Sentence_Break>(0)},
{0x3041,Sentence_Break::OLetter},
{0x3097,static_cast<Sentence_Break>(0)},
{0x3099,Sentence_Break::Extend},
{0x309b,static_cast<Sentence_Break>(0)},
{0x309d,Sentence_Break::OLetter},
{0x30a0,static_cast<Sentence_Break>(0)},
{0x30a1,Sentence_Break::OLetter},
{0x30fb,static_cast<Sentence_Break>(0)},
{0x30fc,Sentence_Break::OLetter},
{0x3100,static_cast<Sentence_Break>(0)},
{0x3105,Sentence_Break::OLetter},
{0x312e,static_cast<Sentence_Break>(0)},
{0x3131,Sentence_Break::OLetter},
{0x318f,static_cast<Sentence_Break>(0)},
{0x31a0,Sentence_Break::OLetter},
{0x31bb,static_cast<Sentence_Break>(0)},
{0x31f0,Sentence_Break::OLetter},
{0x3200,static_cast<Sentence_Break>(0)},
{0x3400,Sentence_Break::OLetter},
{0x4db6,static_cast<Sentence_Break>(0)},
{0x4e00,Sentence_Break::OLetter},
{0x9fd6,static_cast<Sentence_Break>(0)},
{0xa000,Sentence_Break::OLetter},
{0xa48d,static_cast<Sentence_Break>(0)},
{0xa4d0,Sentence_Break::OLetter},
{0xa4fe,static_cast<Sentence_Break>(0)},
{0xa4ff,Sentence_Break::STerm},
{0xa500,Sentence_Break::OLetter},
{0xa60d,static_cast<Sentence_Break>(0)},
{0xa60e,Sentence_Break::STerm},
{0xa610,Sentence_Break::OLetter},
{0xa620,Sentence_Break::Numeric},
{0xa62a,Sentence_Break::OLetter},
{0xa62c,static_cast<Sentence_Break>(0)},
{0xa640,Sentence_Break::Upper},
{0xa641,Sentence_Break::Lower},
{0xa642,Sentence_Break::Upper},
{0xa643,Sentence_Break::Lower},
{0xa644,Sentence_Break::Upper},
{0xa645,Sentence_Break::Lower},
{0xa646,Sentence_Break::Upper},
{0xa647,Sentence_Break::Lower},
{0xa648,Sentence_Break::Upper},
{0xa649,Sentence_Break::Lower},
{0xa64a,Sentence_Break::Upper},
{0xa64b,Sentence_Break::Lower},
{0xa64c,Sentence_Break::Upper},
{0xa64d,Sentence_Break::Lower},
{0xa64e,Sentence_Break::Upper},
{0xa64f,Sentence_Break::Lower},
{0xa650,Sentence_Break::Upper},
{0xa651,Sentence_Break::Lower},
{0xa652,Sentence_Break::Upper},
{0xa653,Sentence_Break::Lower},
{0xa654,Sentence_Break::Upper},
{0xa655,Sentence_Break::Lower},
{0xa656,Sentence_Break::Upper},
{0xa657,Sentence_Break::Lower},
{0xa658,Sentence_Break::Upper},
{0xa659,Sentence_Break::Lower},
{0xa65a,Sentence_Break::Upper},
{0xa65b,Sentence_Break::Lower},
{0xa65c,Sentence_Break::Upper},
{0xa65d,Sentence_Break::Lower},
{0xa65e,Sentence_Break::Upper},
{0xa65f,Sentence_Break::Lower},
{0xa660,Sentence_Break::Upper},
{0xa661,Sentence_Break::Lower},
{0xa662,Sentence_Break::Upper},
{0xa663,Sentence_Break::Lower},
{0xa664,Sentence_Break::Upper},
{0xa665,Sentence_Break::Lower},
{0xa666,Sentence_Break::Upper},
{0xa667,Sentence_Break::Lower},
{0xa668,Sentence_Break::Upper},
{0xa669,Sentence_Break::Lower},
{0xa66a,Sentence_Break::Upper},
{0xa66b,Sentence_Break::Lower},
{0xa66c,Sentence_Break::Upper},
{0xa66d,Sentence_Break::Lower},
{0xa66e,Sentence_Break::OLetter},
{0xa66f,Sentence_Break::Extend},
{0xa673,static_cast<Sentence_Break>(0)},
{0xa674,Sentence_Break::Extend},
{0xa67e,static_cast<Sentence_Break>(0)},
{0xa67f,Sentence_Break::OLetter},
{0xa680,Sentence_Break::Upper},
{0xa681,Sentence_Break::Lower},
{0xa682,Sentence_Break::Upper},
{0xa683,Sentence_Break::Lower},
{0xa684,Sentence_Break::Upper},
{0xa685,Sentence_Break::Lower},
{0xa686,Sentence_Break::Upper},
{0xa687,Sentence_Break::Lower},
{0xa688,Sentence_Break::Upper},
{0xa689,Sentence_Break::Lower},
{0xa68a,Sentence_Break::Upper},
{0xa68b,Sentence_Break::Lower},
{0xa68c,Sentence_Break::Upper},
{0xa68d,Sentence_Break::Lower},
{0xa68e,Sentence_Break::Upper},
{0xa68f,Sentence_Break::Lower},
{0xa690,Sentence_Break::Upper},
{0xa691,Sentence_Break::Lower},
{0xa692,Sentence_Break::Upper},
{0xa693,Sentence_Break::Lower},
{0xa694,Sentence_Break::Upper},
{0xa695,Sentence_Break::Lower},
{0xa696,Sentence_Break::Upper},
{0xa697,Sentence_Break::Lower},
{0xa698,Sentence_Break::Upper},
{0xa699,Sentence_Break::Lower},
{0xa69a,Sentence_Break::Upper},
{0xa69b,Sentence_Break::Lower},
{0xa69e,Sentence_Break::Extend},
{0xa6a0,Sentence_Break::OLetter},
{0xa6f0,Sentence_Break::Extend},
{0xa6f2,static_cast<Sentence_Break>(0)},
{0xa6f3,Sentence_Break::STerm},
{0xa6f4,static_cast<Sentence_Break>(0)},
{0xa6f7,Sentence_Break::STerm},
{0xa6f8,static_cast<Sentence_Break>(0)},
{0xa717,Sentence_Break::OLetter},
{0xa720,static_cast<Sentence_Break>(0)},
{0xa722,Sentence_Break::Upper},
{0xa723,Sentence_Break::Lower},
{0xa724,Sentence_Break::Upper},
{0xa725,Sentence_Break::Lower},
{0xa726,Sentence_Break::Upper},
{0xa727,Sentence_Break::Lower},
{0xa728,Sentence_Break::Upper},
{0xa729,Sentence_Break::Lower},
{0xa72a,Sentence_Break::Upper},
{0xa72b,Sentence_Break::Lower},
{0xa72c,Sentence_Break::Upper},
{0xa72d,Sentence_Break::Lower},
{0xa72e,Sentence_Break::Upper},
{0xa72f,Sentence_Break::Lower},
{0xa732,Sentence_Break::Upper},
{0xa733,Sentence_Break::Lower},
{0xa734,Sentence_Break::Upper},
{0xa735,Sentence_Break::Lower},
{0xa736,Sentence_Break::Upper},
{0xa737,Sentence_Break::Lower},
{0xa738,Sentence_Break::Upper},
{0xa739,Sentence_Break::Lower},
{0xa73a,Sentence_Break::Upper},
{0xa73b,Sentence_Break::Lower},
{0xa73c,Sentence_Break::Upper},
{0xa73d,Sentence_Break::Lower},
{0xa73e,Sentence_Break::Upper},
{0xa73f,Sentence_Break::Lower},
{0xa740,Sentence_Break::Upper},
{0xa741,Sentence_Break::Lower},
{0xa742,Sentence_Break::Upper},
{0xa743,Sentence_Break::Lower},
{0xa744,Sentence_Break::Upper},
{0xa745,Sentence_Break::Lower},
{0xa746,Sentence_Break::Upper},
{0xa747,Sentence_Break::Lower},
{0xa748,Sentence_Break::Upper},
{0xa749,Sentence_Break::Lower},
{0xa74a,Sentence_Break::Upper},
{0xa74b,Sentence_Break::Lower},
{0xa74c,Sentence_Break::Upper},
{0xa74d,Sentence_Break::Lower},
{0xa74e,Sentence_Break::Upper},
{0xa74f,Sentence_Break::Lower},
{0xa750,Sentence_Break::Upper},
{0xa751,Sentence_Break::Lower},
{0xa752,Sentence_Break::Upper},
{0xa753,Sentence_Break::Lower},
{0xa754,Sentence_Break::Upper},
{0xa755,Sentence_Break::Lower},
{0xa756,Sentence_Break::Upper},
{0xa757,Sentence_Break::Lower},
{0xa758,Sentence_Break::Upper},
{0xa759,Sentence_Break::Lower},
{0xa75a,Sentence_Break::Upper},
{0xa75b,Sentence_Break::Lower},
{0xa75c,Sentence_Break::Upper},
{0xa75d,Sentence_Break::Lower},
{0xa75e,Sentence_Break::Upper},
{0xa75f,Sentence_Break::Lower},
{0xa760,Sentence_Break::Upper},
{0xa761,Sentence_Break::Lower},
{0xa762,Sentence_Break::Upper},
{0xa763,Sentence_Break::Lower},
{0xa764,Sentence_Break::Upper},
{0xa765,Sentence_Break::Lower},
{0xa766,Sentence_Break::Upper},
{0xa767,Sentence_Break::Lower},
{0xa768,Sentence_Break::Upper},
{0xa769,Sentence_Break::Lower},
{0xa76a,Sentence_Break::Upper},
{0xa76b,Sentence_Break::Lower},
{0xa76c,Sentence_Break::Upper},
{0xa76d,Sentence_Break::Lower},
{0xa76e,Sentence_Break::Upper},
{0xa76f,Sentence_Break::Lower},
{0xa779,Sentence_Break::Upper},
{0xa77a,Sentence_Break::Lower},
{0xa77b,Sentence_Break::Upper},
{0xa77c,Sentence_Break::Lower},
{0xa77d,Sentence_Break::Upper},
{0xa77f,Sentence_Break::Lower},
{0xa780,Sentence_Break::Upper},
{0xa781,Sentence_Break::Lower},
{0xa782,Sentence_Break::Upper},
{0xa783,Sentence_Break::Lower},
{0xa784,Sentence_Break::Upper},
{0xa785,Sentence_Break::Lower},
{0xa786,Sentence_Break::Upper},
{0xa787,Sentence_Break::Lower},
{0xa788,Sentence_Break::OLetter},
{0xa789,static_cast<Sentence_Break>(0)},
{0xa78b,Sentence_Break::Upper},
{0xa78c,Sentence_Break::Lower},
{0xa78d,Sentence_Break::Upper},
{0xa78e,Sentence_Break::Lower},
{0xa78f,Sentence_Break::OLetter},
{0xa790,Sentence_Break::Upper},
{0xa791,Sentence_Break::Lower},
{0xa792,Sentence_Break::Upper},
{0xa793,Sentence_Break::Lower},
{0xa796,Sentence_Break::Upper},
{0xa797,Sentence_Break::Lower},
{0xa798,Sentence_Break::Upper},
{0xa799,Sentence_Break::Lower},
{0xa79a,Sentence_Break::Upper},
{0xa79b,Sentence_Break::Lower},
{0xa79c,Sentence_Break::Upper},
{0xa79d,Sentence_Break::Lower},
{0xa79e,Sentence_Break::Upper},
{0xa79f,Sentence_Break::Lower},
{0xa7a0,Sentence_Break::Upper},
{0xa7a1,Sentence_Break::Lower},
{0xa7a2,Sentence_Break::Upper},
{0xa7a3,Sentence_Break::Lower},
{0xa7a4,Sentence_Break::Upper},
{0xa7a5,Sentence_Break::Lower},
{0xa7a6,Sentence_Break::Upper},
{0xa7a7,Sentence_Break::Lower},
{0xa7a8,Sentence_Break::Upper},
{0xa7a9,Sentence_Break::Lower},
{0xa7aa,Sentence_Break::Upper},
{0xa7ae,static_cast<Sentence_Break>(0)},
{0xa7b0,Sentence_Break::Upper},
{0xa7b5,Sentence_Break::Lower},
{0xa7b6,Sentence_Break::Upper},
{0xa7b7,Sentence_Break::Lower},
{0xa7b8,static_cast<Sentence_Break>(0)},
{0xa7f7,Sentence_Break::OLetter},
{0xa7f8,Sentence_Break::Lower},
{0xa7fb,Sentence_Break::OLetter},
{0xa802,Sentence_Break::Extend},
{0xa803,Sentence_Break::OLetter},
{0xa806,Sentence_Break::Extend},
{0xa807,Sentence_Break::OLetter},
{0xa80b,Sentence_Break::Extend},
{0xa80c,Sentence_Break::OLetter},
{0xa823,Sentence_Break::Extend},
{0xa828,static_cast<Sentence_Break>(0)},
{0xa840,Sentence_Break::OLetter},
{0xa874,static_cast<Sentence_Break>(0)},
{0xa876,Sentence_Break::STerm},
{0xa878,static_cast<Sentence_Break>(0)},
{0xa880,Sentence_Break::Extend},
{0xa882,Sentence_Break::OLetter},
{0xa8b4,Sentence_Break::Extend},
{0xa8c5,static_cast<Sentence_Break>(0)},
{0xa8ce,Sentence_Break::STerm},
{0xa8d0,Sentence_Break::Numeric},
{0xa8da,static_cast<Sentence_Break>(0)},
{0xa8e0,Sentence_Break::Extend},
{0xa8f2,Sentence_Break::OLetter},
{0xa8f8,static_cast<Sentence_Break>(0)},
{0xa8fb,Sentence_Break::OLetter},
{0xa8fc,static_cast<Sentence_Break>(0)},
{0xa8fd,Sentence_Break::OLetter},
{0xa8fe,static_cast<Sentence_Break>(0)},
{0xa900,Sentence_Break::Numeric},
{0xa90a,Sentence_Break::OLetter},
{0xa926,Sentence_Break::Extend},
{0xa92e,static_cast<Sentence_Break>(0)},
{0xa92f,Sentence_Break::STerm},
{0xa930,Sentence_Break::OLetter},
{0xa947,Sentence_Break::Extend},
{0xa954,static_cast<Sentence_Break>(0)},
{0xa960,Sentence_Break::OLetter},
{0xa97d,static_cast<Sentence_Break>(0)},
{0xa980,Sentence_Break::Extend},
{0xa984,Sentence_Break::OLetter},
{0xa9b3,Sentence_Break::Extend},
{0xa9c1,static_cast<Sentence_Break>(0)},
{0xa9c8,Sentence_Break::STerm},
{0xa9ca,static_cast<Sentence_Break>(0)},
{0xa9cf,Sentence_Break::OLetter},
{0xa9d0,Sentence_Break::Numeric},
{0xa9da,static_cast<Sentence_Break>(0)},
{0xa9e0,Sentence_Break::OLetter},
{0xa9e5,Sentence_Break::Extend},
{0xa9e6,Sentence_Break::OLetter},
{0xa9f0,Sentence_Break::Numeric},
{0xa9fa,Sentence_Break::OLetter},
{0xa9ff,static_cast<Sentence_Break>(0)},
{0xaa00,Sentence_Break::OLetter},
{0xaa29,Sentence_Break::Extend},
{0xaa37,static_cast<Sentence_Break>(0)},
{0xaa40,Sentence_Break::OLetter},
{0xaa43,Sentence_Break::Extend},
{0xaa44,Sentence_Break::OLetter},
{0xaa4c,Sentence_Break::Extend},
{0xaa4e,static_cast<Sentence_Break>(0)},
{0xaa50,Sentence_Break::Numeric},
{0xaa5a,static_cast<Sentence_Break>(0)},
{0xaa5d,Sentence_Break::STerm},
{0xaa60,Sentence_Break::OLetter},
{0xaa77,static_cast<Sentence_Break>(0)},
{0xaa7a,Sentence_Break::OLetter},
{0xaa7b,Sentence_Break::Extend},
{0xaa7e,Sentence_Break::OLetter},
{0xaab0,Sentence_Break::Extend},
{0xaab1,Sentence_Break::OLetter},
{0xaab2,Sentence_Break::Extend},
{0xaab5,Sentence_Break::OLetter},
{0xaab7,Sentence_Break::Extend},
{0xaab9,Sentence_Break::OLetter},
{0xaabe,Sentence_Break::Extend},
{0xaac0,Sentence_Break::OLetter},
{0xaac1,Sentence_Break::Extend},
{0xaac2,Sentence_Break::OLetter},
{0xaac3,static_cast<Sentence_Break>(0)},
{0xaadb,Sentence_Break::OLetter},
{0xaade,static_cast<Sentence_Break>(0)},
{0xaae0,Sentence_Break::OLetter},
{0xaaeb,Sentence_Break::Extend},
{0xaaf0,Sentence_Break::STerm},
{0xaaf2,Sentence_Break::OLetter},
{0xaaf5,Sentence_Break::Extend},
{0xaaf7,static_cast<Sentence_Break>(0)},
{0xab01,Sentence_Break::OLetter},
{0xab07,static_cast<Sentence_Break>(0)},
{0xab09,Sentence_Break::OLetter},
{0xab0f,static_cast<Sentence_Break>(0)},
{0xab11,Sentence_Break::OLetter},
{0xab17,static_cast<Sentence_Break>(0)},
{0xab20,Sentence_Break::OLetter},
{0xab27,static_cast<Sentence_Break>(0)},
{0xab28,Sentence_Break::OLetter},
{0xab2f,static_cast<Sentence_Break>(0)},
{0xab30,Sentence_Break::Lower},
{0xab5b,static_cast<Sentence_Break>(0)},
{0xab5c,Sentence_Break::Lower},
{0xab66,static_cast<Sentence_Break>(0)},
{0xab70,Sentence_Break::Lower},
{0xabc0,Sentence_Break::OLetter},
{0xabe3,Sentence_Break::Extend},
{0xabeb,Sentence_Break::STerm},
{0xabec,Sentence_Break::Extend},
{0xabee,static_cast<Sentence_Break>(0)},
{0xabf0,Sentence_Break::Numeric},
{0xabfa,static_cast<Sentence_Break>(0)},
{0xac00,Sentence_Break::OLetter},
{0xd7a4,static_cast<Sentence_Break>(0)},
{0xd7b0,Sentence_Break::OLetter},
{0xd7c7,static_cast<Sentence_Break>(0)},
{0xd7cb,Sentence_Break::OLetter},
{0xd7fc,static_cast<Sentence_Break>(0)},
{0xf900,Sentence_Break::OLetter},
{0xfa6e,static_cast<Sentence_Break>(0)},
{0xfa70,Sentence_Break::OLetter},
{0xfada,static_cast<Sentence_Break>(0)},
{0xfb00,Sentence_Break::Lower},
{0xfb07,static_cast<Sentence_Break>(0)},
{0xfb13,Sentence_Break::Lower},
{0xfb18,static_cast<Sentence_Break>(0)},
{0xfb1d,Sentence_Break::OLetter},
{0xfb1e,Sentence_Break::Extend},
{0xfb1f,Sentence_Break::OLetter},
{0xfb29,static_cast<Sentence_Break>(0)},
{0xfb2a,Sentence_Break::OLetter},
{0xfb37,static_cast<Sentence_Break>(0)},
{0xfb38,Sentence_Break::OLetter},
{0xfb3d,static_cast<Sentence_Break>(0)},
{0xfb3e,Sentence_Break::OLetter},
{0xfb3f,static_cast<Sentence_Break>(0)},
{0xfb40,Sentence_Break::OLetter},
{0xfb42,static_cast<Sentence_Break>(0)},
{0xfb43,Sentence_Break::OLetter},
{0xfb45,static_cast<Sentence_Break>(0)},
{0xfb46,Sentence_Break::OLetter},
{0xfbb2,static_cast<Sentence_Break>(0)},
{0xfbd3,Sentence_Break::OLetter},
{0xfd3e,Sentence_Break::Close},
{0xfd40,static_cast<Sentence_Break>(0)},
{0xfd50,Sentence_Break::OLetter},
{0xfd90,static_cast<Sentence_Break>(0)},
{0xfd92,Sentence_Break::OLetter},
{0xfdc8,static_cast<Sentence_Break>(0)},
{0xfdf0,Sentence_Break::OLetter},
{0xfdfc,static_cast<Sentence_Break>(0)},
{0xfe00,Sentence_Break::Extend},
{0xfe10,Sentence_Break::SContinue},
{0xfe12,static_cast<Sentence_Break>(0)},
{0xfe13,Sentence_Break::SContinue},
{0xfe14,static_cast<Sentence_Break>(0)},
{0xfe17,Sentence_Break::Close},
{0xfe19,static_cast<Sentence_Break>(0)},
{0xfe20,Sentence_Break::Extend},
{0xfe30,static_cast<Sentence_Break>(0)},
{0xfe31,Sentence_Break::SContinue},
{0xfe33,static_cast<Sentence_Break>(0)},
{0xfe35,Sentence_Break::Close},
{0xfe45,static_cast<Sentence_Break>(0)},
{0xfe47,Sentence_Break::Close},
{0xfe49,static_cast<Sentence_Break>(0)},
{0xfe50,Sentence_Break::SContinue},
{0xfe52,Sentence_Break::ATerm},
{0xfe53,static_cast<Sentence_Break>(0)},
{0xfe55,Sentence_Break::SContinue},
{0xfe56,Sentence_Break::STerm},
{0xfe58,Sentence_Break::SContinue},
{0xfe59,Sentence_Break::Close},
{0xfe5f,static_cast<Sentence_Break>(0)},
{0xfe63,Sentence_Break::SContinue},
{0xfe64,static_cast<Sentence_Break>(0)},
{0xfe70,Sentence_Break::OLetter},
{0xfe75,static_cast<Sentence_Break>(0)},
{0xfe76,Sentence_Break::OLetter},
{0xfefd,static_cast<Sentence_Break>(0)},
{0xfeff,Sentence_Break::Format},
{0xff00,static_cast<Sentence_Break>(0)},
{0xff01,Sentence_Break::STerm},
{0xff02,static_cast<Sentence_Break>(0)},
{0xff08,Sentence_Break::Close},
{0xff0a,static_cast<Sentence_Break>(0)},
{0xff0c,Sentence_Break::SContinue},
{0xff0e,Sentence_Break::ATerm},
{0xff0f,static_cast<Sentence_Break>(0)},
{0xff1a,Sentence_Break::SContinue},
{0xff1b,static_cast<Sentence_Break>(0)},
{0xff1f,Sentence_Break::STerm},
{0xff20,static_cast<Sentence_Break>(0)},
{0xff21,Sentence_Break::Upper},
{0xff3b,Sentence_Break::Close},
{0xff3c,static_cast<Sentence_Break>(0)},
{0xff3d,Sentence_Break::Close},
{0xff3e,static_cast<Sentence_Break>(0)},
{0xff41,Sentence_Break::Lower},
{0xff5b,Sentence_Break::Close},
{0xff5c,static_cast<Sentence_Break>(0)},
{0xff5d,Sentence_Break::Close},
{0xff5e,static_cast<Sentence_Break>(0)},
{0xff5f,Sentence_Break::Close},
{0xff61,Sentence_Break::STerm},
{0xff62,Sentence_Break::Close},
{0xff64,Sentence_Break::SContinue},
{0xff65,static_cast<Sentence_Break>(0)},
{0xff66,Sentence_Break::OLetter},
{0xff9e,Sentence_Break::Extend},
{0xffa0,Sentence_Break::OLetter},
{0xffbf,static_cast<Sentence_Break>(0)},
{0xffc2,Sentence_Break::OLetter},
{0xffc8,static_cast<Sentence_Break>(0)},
{0xffca,Sentence_Break::OLetter},
{0xffd0,static_cast<Sentence_Break>(0)},
{0xffd2,Sentence_Break::OLetter},
{0xffd8,static_cast<Sentence_Break>(0)},
{0xffda,Sentence_Break::OLetter},
{0xffdd,static_cast<Sentence_Break>(0)},
{0xfff9,Sentence_Break::Format},
{0xfffc,static_cast<Sentence_Break>(0)},
{0x10000,Sentence_Break::OLetter},
{0x1000c,static_cast<Sentence_Break>(0)},
{0x1000d,Sentence_Break::OLetter},
{0x10027,static_cast<Sentence_Break>(0)},
{0x10028,Sentence_Break::OLetter},
{0x1003b,static_cast<Sentence_Break>(0)},
{0x1003c,Sentence_Break::OLetter},
{0x1003e,static_cast<Sentence_Break>(0)},
{0x1003f,Sentence_Break::OLetter},
{0x1004e,static_cast<Sentence_Break>(0)},
{0x10050,Sentence_Break::OLetter},
{0x1005e,static_cast<Sentence_Break>(0)},
{0x10080,Sentence_Break::OLetter},
{0x100fb,static_cast<Sentence_Break>(0)},
{0x10140,Sentence_Break::OLetter},
{0x10175,static_cast<Sentence_Break>(0)},
{0x101fd,Sentence_Break::Extend},
{0x101fe,static_cast<Sentence_Break>(0)},
{0x10280,Sentence_Break::OLetter},
{0x1029d,static_cast<Sentence_Break>(0)},
{0x102a0,Sentence_Break::OLetter},
{0x102d1,static_cast<Sentence_Break>(0)},
{0x102e0,Sentence_Break::Extend},
{0x102e1,static_cast<Sentence_Break>(0)},
{0x10300,Sentence_Break::OLetter},
{0x10320,static_cast<Sentence_Break>(0)},
{0x10330,Sentence_Break::OLetter},
{0x1034b,static_cast<Sentence_Break>(0)},
{0x10350,Sentence_Break::OLetter},
{0x10376,Sentence_Break::Extend},
{0x1037b,static_cast<Sentence_Break>(0)},
{0x10380,Sentence_Break::OLetter},
{0x1039e,static_cast<Sentence_Break>(0)},
{0x103a0,Sentence_Break::OLetter},
{0x103c4,static_cast<Sentence_Break>(0)},
{0x103c8,Sentence_Break::OLetter},
{0x103d0,static_cast<Sentence_Break>(0)},
{0x103d1,Sentence_Break::OLetter},
{0x103d6,static_cast<Sentence_Break>(0)},
{0x10400,Sentence_Break::Upper},
{0x10428,Sentence_Break::Lower},
{0x10450,Sentence_Break::OLetter},
{0x1049e,static_cast<Sentence_Break>(0)},
{0x104a0,Sentence_Break::Numeric},
{0x104aa,static_cast<Sentence_Break>(0)},
{0x10500,Sentence_Break::OLetter},
{0x10528,static_cast<Sentence_Break>(0)},
{0x10530,Sentence_Break::OLetter},
{0x10564,static_cast<Sentence_Break>(0)},
{0x10600,Sentence_Break::OLetter},
{0x10737,static_cast<Sentence_Break>(0)},
{0x10740,Sentence_Break::OLetter},
{0x10756,static_cast<Sentence_Break>(0)},
{0x10760,Sentence_Break::OLetter},
{0x10768,static_cast<Sentence_Break>(0)},
{0x10800,Sentence_Break::OLetter},
{0x10806,static_cast<Sentence_Break>(0)},
{0x10808,Sentence_Break::OLetter},
{0x10809,static_cast<Sentence_Break>(0)},
{0x1080a,Sentence_Break::OLetter},
{0x10836,static_cast<Sentence_Break>(0)},
{0x10837,Sentence_Break::OLetter},
{0x10839,static_cast<Sentence_Break>(0)},
{0x1083c,Sentence_Break::OLetter},
{0x1083d,static_cast<Sentence_Break>(0)},
{0x1083f,Sentence_Break::OLetter},
{0x10856,static_cast<Sentence_Break>(0)},
{0x10860,Sentence_Break::OLetter},
{0x10877,static_cast<Sentence_Break>(0)},
{0x10880,Sentence_Break::OLetter},
{0x1089f,static_cast<Sentence_Break>(0)},
{0x108e0,Sentence_Break::OLetter},
{0x108f3,static_cast<Sentence_Break>(0)},
{0x108f4,Sentence_Break::OLetter},
{0x108f6,static_cast<Sentence_Break>(0)},
{0x10900,Sentence_Break::OLetter},
{0x10916,static_cast<Sentence_Break>(0)},
{0x10920,Sentence_Break::OLetter},
{0x1093a,static_cast<Sentence_Break>(0)},
{0x10980,Sentence_Break::OLetter},
{0x109b8,static_cast<Sentence_Break>(0)},
{0x109be,Sentence_Break::OLetter},
{0x109c0,static_cast<Sentence_Break>(0)},
{0x10a00,Sentence_Break::OLetter},
{0x10a01,Sentence_Break::Extend},
{0x10a04,static_cast<Sentence_Break>(0)},
{0x10a05,Sentence_Break::Extend},
{0x10a07,static_cast<Sentence_Break>(0)},
{0x10a0c,Sentence_Break::Extend},
{0x10a10,Sentence_Break::OLetter},
{0x10a14,static_cast<Sentence_Break>(0)},
{0x10a15,Sentence_Break::OLetter},
{0x10a18,static_cast<Sentence_Break>(0)},
{0x10a19,Sentence_Break::OLetter},
{0x10a34,static_cast<Sentence_Break>(0)},
{0x10a38,Sentence_Break::Extend},
{0x10a3b,static_cast<Sentence_Break>(0)},
{0x10a3f,Sentence_Break::Extend},
{0x10a40,static_cast<Sentence_Break>(0)},
{0x10a56,Sentence_Break::STerm},
{0x10a58,static_cast<Sentence_Break>(0)},
{0x10a60,Sentence_Break::OLetter},
{0x10a7d,static_cast<Sentence_Break>(0)},
{0x10a80,Sentence_Break::OLetter},
{0x10a9d,static_cast<Sentence_Break>(0)},
{0x10ac0,Sentence_Break::OLetter},
{0x10ac8,static_cast<Sentence_Break>(0)},
{0x10ac9,Sentence_Break::OLetter},
{0x10ae5,Sentence_Break::Extend},
{0x10ae7,static_cast<Sentence_Break>(0)},
{0x10b00,Sentence_Break::OLetter},
{0x10b36,static_cast<Sentence_Break>(0)},
{0x10b40,Sentence_Break::OLetter},
{0x10b56,static_cast<Sentence_Break>(0)},
{0x10b60,Sentence_Break::OLetter},
{0x10b73,static_cast<Sentence_Break>(0)},
{0x10b80,Sentence_Break::OLetter},
{0x10b92,static_cast<Sentence_Break>(0)},
{0x10c00,Sentence_Break::OLetter},
{0x10c49,static_cast<Sentence_Break>(0)},
{0x10c80,Sentence_Break::Upper},
{0x10cb3,static_cast<Sentence_Break>(0)},
{0x10cc0,Sentence_Break::Lower},
{0x10cf3,static_cast<Sentence_Break>(0)},
{0x11000,Sentence_Break::Extend},
{0x11003,Sentence_Break::OLetter},
{0x11038,Sentence_Break::Extend},
{0x11047,Sentence_Break::STerm},
{0x11049,static_cast<Sentence_Break>(0)},
{0x11066,Sentence_Break::Numeric},
{0x11070,static_cast<Sentence_Break>(0)},
{0x1107f,Sentence_Break::Extend},
{0x11083,Sentence_Break::OLetter},
{0x110b0,Sentence_Break::Extend},
{0x110bb,static_cast<Sentence_Break>(0)},
{0x110bd,Sentence_Break::Format},
{0x110be,Sentence_Break::STerm},
{0x110c2,static_cast<Sentence_Break>(0)},
{0x110d0,Sentence_Break::OLetter},
{0x110e9,static_cast<Sentence_Break>(0)},
{0x110f0,Sentence_Break::Numeric},
{0x110fa,static_cast<Sentence_Break>(0)},
{0x11100,Sentence_Break::Extend},
{0x11103,Sentence_Break::OLetter},
{0x11127,Sentence_Break::Extend},
{0x11135,static_cast<Sentence_Break>(0)},
{0x11136,Sentence_Break::Numeric},
{0x11140,static_cast<Sentence_Break>(0)},
{0x11141,Sentence_Break::STerm},
{0x11144,static_cast<Sentence_Break>(0)},
{0x11150,Sentence_Break::OLetter},
{0x11173,Sentence_Break::Extend},
{0x11174,static_cast<Sentence_Break>(0)},
{0x11176,Sentence_Break::OLetter},
{0x11177,static_cast<Sentence_Break>(0)},
{0x11180,Sentence_Break::Extend},
{0x11183,Sentence_Break::OLetter},
{0x111b3,Sentence_Break::Extend},
{0x111c1,Sentence_Break::OLetter},
{0x111c5,Sentence_Break::STerm},
{0x111c7,static_cast<Sentence_Break>(0)},
{0x111ca,Sentence_Break::Extend},
{0x111cd,Sentence_Break::STerm},
{0x111ce,static_cast<Sentence_Break>(0)},
{0x111d0,Sentence_Break::Numeric},
{0x111da,Sentence_Break::OLetter},
{0x111db,static_cast<Sentence_Break>(0)},
{0x111dc,Sentence_Break::OLetter},
{0x111dd,static_cast<Sentence_Break>(0)},
{0x111de,Sentence_Break::STerm},
{0x111e0,static_cast<Sentence_Break>(0)},
{0x11200,Sentence_Break::OLetter},
{0x11212,static_cast<Sentence_Break>(0)},
{0x11213,Sentence_Break::OLetter},
{0x1122c,Sentence_Break::Extend},
{0x11238,Sentence_Break::STerm},
{0x1123a,static_cast<Sentence_Break>(0)},
{0x1123b,Sentence_Break::STerm},
{0x1123d,static_cast<Sentence_Break>(0)},
{0x11280,Sentence_Break::OLetter},
{0x11287,static_cast<Sentence_Break>(0)},
{0x11288,Sentence_Break::OLetter},
{0x11289,static_cast<Sentence_Break>(0)},
{0x1128a,Sentence_Break::OLetter},
{0x1128e,static_cast<Sentence_Break>(0)},
{0x1128f,Sentence_Break::OLetter},
{0x1129e,static_cast<Sentence_Break>(0)},
{0x1129f,Sentence_Break::OLetter},
{0x112a9,Sentence_Break::STerm},
{0x112aa,static_cast<Sentence_Break>(0)},
{0x112b0,Sentence_Break::OLetter},
{0x112df,Sentence_Break::Extend},
{0x112eb,static_cast<Sentence_Break>(0)},
{0x112f0,Sentence_Break::Numeric},
{0x112fa,static_cast<Sentence_Break>(0)},
{0x11300,Sentence_Break::Extend},
{0x11304,static_cast<Sentence_Break>(0)},
{0x11305,Sentence_Break::OLetter},
{0x1130d,static_cast<Sentence_Break>(0)},
{0x1130f,Sentence_Break::OLetter},
{0x11311,static_cast<Sentence_Break>(0)},
{0x11313,Sentence_Break::OLetter},
{0x11329,static_cast<Sentence_Break>(0)},
{0x1132a,Sentence_Break::OLetter},
{0x11331,static_cast<Sentence_Break>(0)},
{0x11332,Sentence_Break::OLetter},
{0x11334,static_cast<Sentence_Break>(0)},
{0x11335,Sentence_Break::OLetter},
{0x1133a,static_cast<Sentence_Break>(0)},
{0x1133c,Sentence_Break::Extend},
{0x1133d,Sentence_Break::OLetter},
{0x1133e,Sentence_Break::Extend},
{0x11345,static_cast<Sentence_Break>(0)},
{0x11347,Sentence_Break::Extend},
{0x11349,static_cast<Sentence_Break>(0)},
{0x1134b,Sentence_Break::Extend},
{0x1134e,static_cast<Sentence_Break>(0)},
{0x11350,Sentence_Break::OLetter},
{0x11351,static_cast<Sentence_Break>(0)},
{0x11357,Sentence_Break::Extend},
{0x11358,static_cast<Sentence_Break>(0)},
{0x1135d,Sentence_Break::OLetter},
{0x11362,Sentence_Break::Extend},
{0x11364,static_cast<Sentence_Break>(0)},
{0x11366,Sentence_Break::Extend},
{0x1136d,static_cast<Sentence_Break>(0)},
{0x11370,Sentence_Break::Extend},
{0x11375,static_cast<Sentence_Break>(0)},
{0x11480,Sentence_Break::OLetter},
{0x114b0,Sentence_Break::Extend},
{0x114c4,Sentence_Break::OLetter},
{0x114c6,static_cast<Sentence_Break>(0)},
{0x114c7,Sentence_Break::OLetter},
{0x114c8,static_cast<Sentence_Break>(0)},
{0x114d0,Sentence_Break::Numeric},
{0x114da,static_cast<Sentence_Break>(0)},
{0x11580,Sentence_Break::OLetter},
{0x115af,Sentence_Break::Extend},
{0x115b6,static_cast<Sentence_Break>(0)},
{0x115b8,Sentence_Break::Extend},
{0x115c1,static_cast<Sentence_Break>(0)},
{0x115c2,Sentence_Break::STerm},
{0x115c4,static_cast<Sentence_Break>(0)},
{0x115c9,Sentence_Break::STerm},
{0x115d8,Sentence_Break::OLetter},
{0x115dc,Sentence_Break::Extend},
{0x115de,static_cast<Sentence_Break>(0)},
{0x11600,Sentence_Break::OLetter},
{0x11630,Sentence_Break::Extend},
{0x11641,Sentence_Break::STerm},
{0x11643,static_cast<Sentence_Break>(0)},
{0x11644,Sentence_Break::OLetter},
{0x11645,static_cast<Sentence_Break>(0)},
{0x11650,Sentence_Break::Numeric},
{0x1165a,static_cast<Sentence_Break>(0)},
{0x11680,Sentence_Break::OLetter},
{0x116ab,Sentence_Break::Extend},
{0x116b8,static_cast<Sentence_Break>(0)},
{0x116c0,Sentence_Break::Numeric},
{0x116ca,static_cast<Sentence_Break>(0)},
{0x11700,Sentence_Break::OLetter},
{0x1171a,static_cast<Sentence_Break>(0)},
{0x1171d,Sentence_Break::Extend},
{0x1172c,static_cast<Sentence_Break>(0)},
{0x11730,Sentence_Break::Numeric},
{0x1173a,static_cast<Sentence_Break>(0)},
{0x1173c,Sentence_Break::STerm},
{0x1173f,static_cast<Sentence_Break>(0)},
{0x118a0,Sentence_Break::Upper},
{0x118c0,Sentence_Break::Lower},
{0x118e0,Sentence_Break::Numeric},
{0x118ea,static_cast<Sentence_Break>(0)},
{0x118ff,Sentence_Break::OLetter},
{0x11900,static_cast<Sentence_Break>(0)},
{0x11ac0,Sentence_Break::OLetter},
{0x11af9,static_cast<Sentence_Break>(0)},
{0x12000,Sentence_Break::OLetter},
{0x1239a,static_cast<Sentence_Break>(0)},
{0x12400,Sentence_Break::OLetter},
{0x1246f,static_cast<Sentence_Break>(0)},
{0x12480,Sentence_Break::OLetter},
{0x12544,static_cast<Sentence_Break>(0)},
{0x13000,Sentence_Break::OLetter},
{0x1342f,static_cast<Sentence_Break>(0)},
{0x14400,Sentence_Break::OLetter},
{0x14647,static_cast<Sentence_Break>(0)},
{0x16800,Sentence_Break::OLetter},
{0x16a39,static_cast<Sentence_Break>(0)},
{0x16a40,Sentence_Break::OLetter},
{0x16a5f,static_cast<Sentence_Break>(0)},
{0x16a60,Sentence_Break::Numeric},
{0x16a6a,static_cast<Sentence_Break>(0)},
{0x16a6e,Sentence_Break::STerm},
{0x16a70,static_cast<Sentence_Break>(0)},
{0x16ad0,Sentence_Break::OLetter},
{0x16aee,static_cast<Sentence_Break>(0)},
{0x16af0,Sentence_Break::Extend},
{0x16af5,Sentence_Break::STerm},
{0x16af6,static_cast<Sentence_Break>(0)},
{0x16b00,Sentence_Break::OLetter},
{0x16b30,Sentence_Break::Extend},
{0x16b37,Sentence_Break::STerm},
{0x16b39,static_cast<Sentence_Break>(0)},
{0x16b40,Sentence_Break::OLetter},
{0x16b44,Sentence_Break::STerm},
{0x16b45,static_cast<Sentence_Break>(0)},
{0x16b50,Sentence_Break::Numeric},
{0x16b5a,static_cast<Sentence_Break>(0)},
{0x16b63,Sentence_Break::OLetter},
{0x16b78,static_cast<Sentence_Break>(0)},
{0x16b7d,Sentence_Break::OLetter},
{0x16b90,static_cast<Sentence_Break>(0)},
{0x16f00,Sentence_Break::OLetter},
{0x16f45,static_cast<Sentence_Break>(0)},
{0x16f50,Sentence_Break::OLetter},
{0x16f51,Sentence_Break::Extend},
{0x16f7f,static_cast<Sentence_Break>(0)},
{0x16f8f,Sentence_Break::Extend},
{0x16f93,Sentence_Break::OLetter},
{0x16fa0,static_cast<Sentence_Break>(0)},
{0x1b000,Sentence_Break::OLetter},
{0x1b002,static_cast<Sentence_Break>(0)},
{0x1bc00,Sentence_Break::OLetter},
{0x1bc6b,static_cast<Sentence_Break>(0)},
{0x1bc70,Sentence_Break::OLetter},
{0x1bc7d,static_cast<Sentence_Break>(0)},
{0x1bc80,Sentence_Break::OLetter},
{0x1bc89,static_cast<Sentence_Break>(0)},
{0x1bc90,Sentence_Break::OLetter},
{0x1bc9a,static_cast<Sentence_Break>(0)},
{0x1bc9d,Sentence_Break::Extend},
{0x1bc9f,Sentence_Break::STerm},
{0x1bca0,Sentence_Break::Format},
{0x1bca4,static_cast<Sentence_Break>(0)},
{0x1d165,Sentence_Break::Extend},
{0x1d16a,static_cast<Sentence_Break>(0)},
{0x1d16d,Sentence_Break::Extend},
{0x1d173,Sentence_Break::Format},
{0x1d17b,Sentence_Break::Extend},
{0x1d183,static_cast<Sentence_Break>(0)},
{0x1d185,Sentence_Break::Extend},
{0x1d18c,static_cast<Sentence_Break>(0)},
{0x1d1aa,Sentence_Break::Extend},
{0x1d1ae,static_cast<Sentence_Break>(0)},
{0x1d242,Sentence_Break::Extend},
{0x1d245,static_cast<Sentence_Break>(0)},
{0x1d400,Sentence_Break::Upper},
{0x1d41a,Sentence_Break::Lower},
{0x1d434,Sentence_Break::Upper},
{0x1d44e,Sentence_Break::Lower},
{0x1d455,static_cast<Sentence_Break>(0)},
{0x1d456,Sentence_Break::Lower},
{0x1d468,Sentence_Break::Upper},
{0x1d482,Sentence_Break::Lower},
{0x1d49c,Sentence_Break::Upper},
{0x1d49d,static_cast<Sentence_Break>(0)},
{0x1d49e,Sentence_Break::Upper},
{0x1d4a0,static_cast<Sentence_Break>(0)},
{0x1d4a2,Sentence_Break::Upper},
{0x1d4a3,static_cast<Sentence_Break>(0)},
{0x1d4a5,Sentence_Break::Upper},
{0x1d4a7,static_cast<Sentence_Break>(0)},
{0x1d4a9,Sentence_Break::Upper},
{0x1d4ad,static_cast<Sentence_Break>(0)},
{0x1d4ae,Sentence_Break::Upper},
{0x1d4b6,Sentence_Break::Lower},
{0x1d4ba,static_cast<Sentence_Break>(0)},
{0x1d4bb,Sentence_Break::Lower},
{0x1d4bc,static_cast<Sentence_Break>(0)},
{0x1d4bd,Sentence_Break::Lower},
{0x1d4c4,static_cast<Sentence_Break>(0)},
{0x1d4c5,Sentence_Break::Lower},
{0x1d4d0,Sentence_Break::Upper},
{0x1d4ea,Sentence_Break::Lower},
{0x1d504,Sentence_Break::Upper},
{0x1d506,static_cast<Sentence_Break>(0)},
{0x1d507,Sentence_Break::Upper},
{0x1d50b,static_cast<Sentence_Break>(0)},
{0x1d50d,Sentence_Break::Upper},
{0x1d515,static_cast<Sentence_Break>(0)},
{0x1d516,Sentence_Break::Upper},
{0x1d51d,static_cast<Sentence_Break>(0)},
{0x1d51e,Sentence_Break::Lower},
{0x1d538,Sentence_Break::Upper},
{0x1d53a,static_cast<Sentence_Break>(0)},
{0x1d53b,Sentence_Break::Upper},
{0x1d53f,static_cast<Sentence_Break>(0)},
{0x1d540,Sentence_Break::Upper},
{0x1d545,static_cast<Sentence_Break>(0)},
{0x1d546,Sentence_Break::Upper},
{0x1d547,static_cast<Sentence_Break>(0)},
{0x1d54a,Sentence_Break::Upper},
{0x1d551,static_cast<Sentence_Break>(0)},
{0x1d552,Sentence_Break::Lower},
{0x1d56c,Sentence_Break::Upper},
{0x1d586,Sentence_Break::Lower},
{0x1d5a0,Sentence_Break::Upper},
{0x1d5ba,Sentence_Break::Lower},
{0x1d5d4,Sentence_Break::Upper},
{0x1d5ee,Sentence_Break::Lower},
{0x1d608,Sentence_Break::Upper},
{0x1d622,Sentence_Break::Lower},
{0x1d63c,Sentence_Break::Upper},
{0x1d656,Sentence_Break::Lower},
{0x1d670,Sentence_Break::Upper},
{0x1d68a,Sentence_Break::Lower},
{0x1d6a6,static_cast<Sentence_Break>(0)},
{0x1d6a8,Sentence_Break::Upper},
{0x1d6c1,static_cast<Sentence_Break>(0)},
{0x1d6c2,Sentence_Break::Lower},
{0x1d6db,static_cast<Sentence_Break>(0)},
{0x1d6dc,Sentence_Break::Lower},
{0x1d6e2,Sentence_Break::Upper},
{0x1d6fb,static_cast<Sentence_Break>(0)},
{0x1d6fc,Sentence_Break::Lower},
{0x1d715,static_cast<Sentence_Break>(0)},
{0x1d716,Sentence_Break::Lower},
{0x1d71c,Sentence_Break::Upper},
{0x1d735,static_cast<Sentence_Break>(0)},
{0x1d736,Sentence_Break::Lower},
{0x1d74f,static_cast<Sentence_Break>(0)},
{0x1d750,Sentence_Break::Lower},
{0x1d756,Sentence_Break::Upper},
{0x1d76f,static_cast<Sentence_Break>(0)},
{0x1d770,Sentence_Break::Lower},
{0x1d789,static_cast<Sentence_Break>(0)},
{0x1d78a,Sentence_Break::Lower},
{0x1d790,Sentence_Break::Upper},
{0x1d7a9,static_cast<Sentence_Break>(0)},
{0x1d7aa,Sentence_Break::Lower},
{0x1d7c3,static_cast<Sentence_Break>(0)},
{0x1d7c4,Sentence_Break::Lower},
{0x1d7ca,Sentence_Break::Upper},
{0x1d7cb,Sentence_Break::Lower},
{0x1d7cc,static_cast<Sentence_Break>(0)},
{0x1d7ce,Sentence_Break::Numeric},
{0x1d800,static_cast<Sentence_Break>(0)},
{0x1da00,Sentence_Break::Extend},
{0x1da37,static_cast<Sentence_Break>(0)},
{0x1da3b,Sentence_Break::Extend},
{0x1da6d,static_cast<Sentence_Break>(0)},
{0x1da75,Sentence_Break::Extend},
{0x1da76,static_cast<Sentence_Break>(0)},
{0x1da84,Sentence_Break::Extend},
{0x1da85,static_cast<Sentence_Break>(0)},
{0x1da88,Sentence_Break::STerm},
{0x1da89,static_cast<Sentence_Break>(0)},
{0x1da9b,Sentence_Break::Extend},
{0x1daa0,static_cast<Sentence_Break>(0)},
{0x1daa1,Sentence_Break::Extend},
{0x1dab0,static_cast<Sentence_Break>(0)},
{0x1e800,Sentence_Break::OLetter},
{0x1e8c5,static_cast<Sentence_Break>(0)},
{0x1e8d0,Sentence_Break::Extend},
{0x1e8d7,static_cast<Sentence_Break>(0)},
{0x1ee00,Sentence_Break::OLetter},
{0x1ee04,static_cast<Sentence_Break>(0)},
{0x1ee05,Sentence_Break::OLetter},
{0x1ee20,static_cast<Sentence_Break>(0)},
{0x1ee21,Sentence_Break::OLetter},
{0x1ee23,static_cast<Sentence_Break>(0)},
{0x1ee24,Sentence_Break::OLetter},
{0x1ee25,static_cast<Sentence_Break>(0)},
{0x1ee27,Sentence_Break::OLetter},
{0x1ee28,static_cast<Sentence_Break>(0)},
{0x1ee29,Sentence_Break::OLetter},
{0x1ee33,static_cast<Sentence_Break>(0)},
{0x1ee34,Sentence_Break::OLetter},
{0x1ee38,static_cast<Sentence_Break>(0)},
{0x1ee39,Sentence_Break::OLetter},
{0x1ee3a,static_cast<Sentence_Break>(0)},
{0x1ee3b,Sentence_Break::OLetter},
{0x1ee3c,static_cast<Sentence_Break>(0)},
{0x1ee42,Sentence_Break::OLetter},
{0x1ee43,static_cast<Sentence_Break>(0)},
{0x1ee47,Sentence_Break::OLetter},
{0x1ee48,static_cast<Sentence_Break>(0)},
{0x1ee49,Sentence_Break::OLetter},
{0x1ee4a,static_cast<Sentence_Break>(0)},
{0x1ee4b,Sentence_Break::OLetter},
{0x1ee4c,static_cast<Sentence_Break>(0)},
{0x1ee4d,Sentence_Break::OLetter},
{0x1ee50,static_cast<Sentence_Break>(0)},
{0x1ee51,Sentence_Break::OLetter},
{0x1ee53,static_cast<Sentence_Break>(0)},
{0x1ee54,Sentence_Break::OLetter},
{0x1ee55,static_cast<Sentence_Break>(0)},
{0x1ee57,Sentence_Break::OLetter},
{0x1ee58,static_cast<Sentence_Break>(0)},
{0x1ee59,Sentence_Break::OLetter},
{0x1ee5a,static_cast<Sentence_Break>(0)},
{0x1ee5b,Sentence_Break::OLetter},
{0x1ee5c,static_cast<Sentence_Break>(0)},
{0x1ee5d,Sentence_Break::OLetter},
{0x1ee5e,static_cast<Sentence_Break>(0)},
{0x1ee5f,Sentence_Break::OLetter},
{0x1ee60,static_cast<Sentence_Break>(0)},
{0x1ee61,Sentence_Break::OLetter},
{0x1ee63,static_cast<Sentence_Break>(0)},
{0x1ee64,Sentence_Break::OLetter},
{0x1ee65,static_cast<Sentence_Break>(0)},
{0x1ee67,Sentence_Break::OLetter},
{0x1ee6b,static_cast<Sentence_Break>(0)},
{0x1ee6c,Sentence_Break::OLetter},
{0x1ee73,static_cast<Sentence_Break>(0)},
{0x1ee74,Sentence_Break::OLetter},
{0x1ee78,static_cast<Sentence_Break>(0)},
{0x1ee79,Sentence_Break::OLetter},
{0x1ee7d,static_cast<Sentence_Break>(0)},
{0x1ee7e,Sentence_Break::OLetter},
{0x1ee7f,static_cast<Sentence_Break>(0)},
{0x1ee80,Sentence_Break::OLetter},
{0x1ee8a,static_cast<Sentence_Break>(0)},
{0x1ee8b,Sentence_Break::OLetter},
{0x1ee9c,static_cast<Sentence_Break>(0)},
{0x1eea1,Sentence_Break::OLetter},
{0x1eea4,static_cast<Sentence_Break>(0)},
{0x1eea5,Sentence_Break::OLetter},
{0x1eeaa,static_cast<Sentence_Break>(0)},
{0x1eeab,Sentence_Break::OLetter},
{0x1eebc,static_cast<Sentence_Break>(0)},
{0x1f130,Sentence_Break::Upper},
{0x1f14a,static_cast<Sentence_Break>(0)},
{0x1f150,Sentence_Break::Upper},
{0x1f16a,static_cast<Sentence_Break>(0)},
{0x1f170,Sentence_Break::Upper},
{0x1f18a,static_cast<Sentence_Break>(0)},
{0x1f676,Sentence_Break::Close},
{0x1f679,static_cast<Sentence_Break>(0)},
{0x20000,Sentence_Break::OLetter},
{0x2a6d7,static_cast<Sentence_Break>(0)},
{0x2a700,Sentence_Break::OLetter},
{0x2b735,static_cast<Sentence_Break>(0)},
{0x2b740,Sentence_Break::OLetter},
{0x2b81e,static_cast<Sentence_Break>(0)},
{0x2b820,Sentence_Break::OLetter},
{0x2cea2,static_cast<Sentence_Break>(0)},
{0x2f800,Sentence_Break::OLetter},
{0x2fa1e,static_cast<Sentence_Break>(0)},
{0xe0001,Sentence_Break::Format},
{0xe0002,static_cast<Sentence_Break>(0)},
{0xe0020,Sentence_Break::Format},
{0xe0080,static_cast<Sentence_Break>(0)},
{0xe0100,Sentence_Break::Extend},
{0xe01f0,static_cast<Sentence_Break>(0)},
}};

const TableView<char32_t, Sentence_Break> sentence_break_table {&sentence_break_array[0], &sentence_break_array[0] + sentence_break_array.size()};

const std::array<KeyValue<char32_t, Word_Break>, 1524> word_break_array = {{
{0x0,static_cast<Word_Break>(0)},
{0xa,Word_Break::LF},
{0xb,Word_Break::Newline},
{0xd,Word_Break::CR},
{0xe,static_cast<Word_Break>(0)},
{0x22,Word_Break::Double_Quote},
{0x23,static_cast<Word_Break>(0)},
{0x27,Word_Break::Single_Quote},
{0x28,static_cast<Word_Break>(0)},
{0x2c,Word_Break::MidNum},
{0x2d,static_cast<Word_Break>(0)},
{0x2e,Word_Break::MidNumLet},
{0x2f,static_cast<Word_Break>(0)},
{0x30,Word_Break::Numeric},
{0x3a,Word_Break::MidLetter},
{0x3b,Word_Break::MidNum},
{0x3c,static_cast<Word_Break>(0)},
{0x41,Word_Break::ALetter},
{0x5b,static_cast<Word_Break>(0)},
{0x5f,Word_Break::ExtendNumLet},
{0x60,static_cast<Word_Break>(0)},
{0x61,Word_Break::ALetter},
{0x7b,static_cast<Word_Break>(0)},
{0x85,Word_Break::Newline},
{0x86,static_cast<Word_Break>(0)},
{0xaa,Word_Break::ALetter},
{0xab,static_cast<Word_Break>(0)},
{0xad,Word_Break::Format},
{0xae,static_cast<Word_Break>(0)},
{0xb5,Word_Break::ALetter},
{0xb6,static_cast<Word_Break>(0)},
{0xb7,Word_Break::MidLetter},
{0xb8,static_cast<Word_Break>(0)},
{0xba,Word_Break::ALetter},
{0xbb,static_cast<Word_Break>(0)},
{0xc0,Word_Break::ALetter},
{0xd7,static_cast<Word_Break>(0)},
{0xd8,Word_Break::ALetter},
{0xf7,static_cast<Word_Break>(0)},
{0xf8,Word_Break::ALetter},
{0x2c2,static_cast<Word_Break>(0)},
{0x2c6,Word_Break::ALetter},
{0x2d2,static_cast<Word_Break>(0)},
{0x2d7,Word_Break::MidLetter},
{0x2d8,static_cast<Word_Break>(0)},
{0x2e0,Word_Break::ALetter},
{0x2e5,static_cast<Word_Break>(0)},
{0x2ec,Word_Break::ALetter},
{0x2ed,static_cast<Word_Break>(0)},
{0x2ee,Word_Break::ALetter},
{0x2ef,static_cast<Word_Break>(0)},
{0x300,Word_Break::Extend},
{0x370,Word_Break::ALetter},
{0x375,static_cast<Word_Break>(0)},
{0x376,Word_Break::ALetter},
{0x378,static_cast<Word_Break>(0)},
{0x37a,Word_Break::ALetter},
{0x37e,Word_Break::MidNum},
{0x37f,Word_Break::ALetter},
{0x380,static_cast<Word_Break>(0)},
{0x386,Word_Break::ALetter},
{0x387,Word_Break::MidLetter},
{0x388,Word_Break::ALetter},
{0x38b,static_cast<Word_Break>(0)},
{0x38c,Word_Break::ALetter},
{0x38d,static_cast<Word_Break>(0)},
{0x38e,Word_Break::ALetter},
{0x3a2,static_cast<Word_Break>(0)},
{0x3a3,Word_Break::ALetter},
{0x3f6,static_cast<Word_Break>(0)},
{0x3f7,Word_Break::ALetter},
{0x482,static_cast<Word_Break>(0)},
{0x483,Word_Break::Extend},
{0x48a,Word_Break::ALetter},
{0x530,static_cast<Word_Break>(0)},
{0x531,Word_Break::ALetter},
{0x557,static_cast<Word_Break>(0)},
{0x559,Word_Break::ALetter},
{0x55a,static_cast<Word_Break>(0)},
{0x561,Word_Break::ALetter},
{0x588,static_cast<Word_Break>(0)},
{0x589,Word_Break::MidNum},
{0x58a,static_cast<Word_Break>(0)},
{0x591,Word_Break::Extend},
{0x5be,static_cast<Word_Break>(0)},
{0x5bf,Word_Break::Extend},
{0x5c0,static_cast<Word_Break>(0)},
{0x5c1,Word_Break::Extend},
{0x5c3,static_cast<Word_Break>(0)},
{0x5c4,Word_Break::Extend},
{0x5c6,static_cast<Word_Break>(0)},
{0x5c7,Word_Break::Extend},
{0x5c8,static_cast<Word_Break>(0)},
{0x5d0,Word_Break::Hebrew_Letter},
{0x5eb,static_cast<Word_Break>(0)},
{0x5f0,Word_Break::Hebrew_Letter},
{0x5f3,Word_Break::ALetter},
{0x5f4,Word_Break::MidLetter},
{0x5f5,static_cast<Word_Break>(0)},
{0x600,Word_Break::Format},
{0x606,static_cast<Word_Break>(0)},
{0x60c,Word_Break::MidNum},
{0x60e,static_cast<Word_Break>(0)},
{0x610,Word_Break::Extend},
{0x61b,static_cast<Word_Break>(0)},
{0x61c,Word_Break::Format},
{0x61d,static_cast<Word_Break>(0)},
{0x620,Word_Break::ALetter},
{0x64b,Word_Break::Extend},
{0x660,Word_Break::Numeric},
{0x66a,static_cast<Word_Break>(0)},
{0x66b,Word_Break::Numeric},
{0x66c,Word_Break::MidNum},
{0x66d,static_cast<Word_Break>(0)},
{0x66e,Word_Break::ALetter},
{0x670,Word_Break::Extend},
{0x671,Word_Break::ALetter},
{0x6d4,static_cast<Word_Break>(0)},
{0x6d5,Word_Break::ALetter},
{0x6d6,Word_Break::Extend},
{0x6dd,Word_Break::Format},
{0x6de,static_cast<Word_Break>(0)},
{0x6df,Word_Break::Extend},
{0x6e5,Word_Break::ALetter},
{0x6e7,Word_Break::Extend},
{0x6e9,static_cast<Word_Break>(0)},
{0x6ea,Word_Break::Extend},
{0x6ee,Word_Break::ALetter},
{0x6f0,Word_Break::Numeric},
{0x6fa,Word_Break::ALetter},
{0x6fd,static_cast<Word_Break>(0)},
{0x6ff,Word_Break::ALetter},
{0x700,static_cast<Word_Break>(0)},
{0x70f,Word_Break::Format},
{0x710,Word_Break::ALetter},
{0x711,Word_Break::Extend},
{0x712,Word_Break::ALetter},
{0x730,Word_Break::Extend},
{0x74b,static_cast<Word_Break>(0)},
{0x74d,Word_Break::ALetter},
{0x7a6,Word_Break::Extend},
{0x7b1,Word_Break::ALetter},
{0x7b2,static_cast<Word_Break>(0)},
{0x7c0,Word_Break::Numeric},
{0x7ca,Word_Break::ALetter},
{0x7eb,Word_Break::Extend},
{0x7f4,Word_Break::ALetter},
{0x7f6,static_cast<Word_Break>(0)},
{0x7f8,Word_Break::MidNum},
{0x7f9,static_cast<Word_Break>(0)},
{0x7fa,Word_Break::ALetter},
{0x7fb,static_cast<Word_Break>(0)},
{0x800,Word_Break::ALetter},
{0x816,Word_Break::Extend},
{0x81a,Word_Break::ALetter},
{0x81b,Word_Break::Extend},
{0x824,Word_Break::ALetter},
{0x825,Word_Break::Extend},
{0x828,Word_Break::ALetter},
{0x829,Word_Break::Extend},
{0x82e,static_cast<Word_Break>(0)},
{0x840,Word_Break::ALetter},
{0x859,Word_Break::Extend},
{0x85c,static_cast<Word_Break>(0)},
{0x8a0,Word_Break::ALetter},
{0x8b5,static_cast<Word_Break>(0)},
{0x8e3,Word_Break::Extend},
{0x904,Word_Break::ALetter},
{0x93a,Word_Break::Extend},
{0x93d,Word_Break::ALetter},
{0x93e,Word_Break::Extend},
{0x950,Word_Break::ALetter},
{0x951,Word_Break::Extend},
{0x958,Word_Break::ALetter},
{0x962,Word_Break::Extend},
{0x964,static_cast<Word_Break>(0)},
{0x966,Word_Break::Numeric},
{0x970,static_cast<Word_Break>(0)},
{0x971,Word_Break::ALetter},
{0x981,Word_Break::Extend},
{0x984,static_cast<Word_Break>(0)},
{0x985,Word_Break::ALetter},
{0x98d,static_cast<Word_Break>(0)},
{0x98f,Word_Break::ALetter},
{0x991,static_cast<Word_Break>(0)},
{0x993,Word_Break::ALetter},
{0x9a9,static_cast<Word_Break>(0)},
{0x9aa,Word_Break::ALetter},
{0x9b1,static_cast<Word_Break>(0)},
{0x9b2,Word_Break::ALetter},
{0x9b3,static_cast<Word_Break>(0)},
{0x9b6,Word_Break::ALetter},
{0x9ba,static_cast<Word_Break>(0)},
{0x9bc,Word_Break::Extend},
{0x9bd,Word_Break::ALetter},
{0x9be,Word_Break::Extend},
{0x9c5,static_cast<Word_Break>(0)},
{0x9c7,Word_Break::Extend},
{0x9c9,static_cast<Word_Break>(0)},
{0x9cb,Word_Break::Extend},
{0x9ce,Word_Break::ALetter},
{0x9cf,static_cast<Word_Break>(0)},
{0x9d7,Word_Break::Extend},
{0x9d8,static_cast<Word_Break>(0)},
{0x9dc,Word_Break::ALetter},
{0x9de,static_cast<Word_Break>(0)},
{0x9df,Word_Break::ALetter},
{0x9e2,Word_Break::Extend},
{0x9e4,static_cast<Word_Break>(0)},
{0x9e6,Word_Break::Numeric},
{0x9f0,Word_Break::ALetter},
{0x9f2,static_cast<Word_Break>(0)},
{0xa01,Word_Break::Extend},
{0xa04,static_cast<Word_Break>(0)},
{0xa05,Word_Break::ALetter},
{0xa0b,static_cast<Word_Break>(0)},
{0xa0f,Word_Break::ALetter},
{0xa11,static_cast<Word_Break>(0)},
{0xa13,Word_Break::ALetter},
{0xa29,static_cast<Word_Break>(0)},
{0xa2a,Word_Break::ALetter},
{0xa31,static_cast<Word_Break>(0)},
{0xa32,Word_Break::ALetter},
{0xa34,static_cast<Word_Break>(0)},
{0xa35,Word_Break::ALetter},
{0xa37,static_cast<Word_Break>(0)},
{0xa38,Word_Break::ALetter},
{0xa3a,static_cast<Word_Break>(0)},
{0xa3c,Word_Break::Extend},
{0xa3d,static_cast<Word_Break>(0)},
{0xa3e,Word_Break::Extend},
{0xa43,static_cast<Word_Break>(0)},
{0xa47,Word_Break::Extend},
{0xa49,static_cast<Word_Break>(0)},
{0xa4b,Word_Break::Extend},
{0xa4e,static_cast<Word_Break>(0)},
{0xa51,Word_Break::Extend},
{0xa52,static_cast<Word_Break>(0)},
{0xa59,Word_Break::ALetter},
{0xa5d,static_cast<Word_Break>(0)},
{0xa5e,Word_Break::ALetter},
{0xa5f,static_cast<Word_Break>(0)},
{0xa66,Word_Break::Numeric},
{0xa70,Word_Break::Extend},
{0xa72,Word_Break::ALetter},
{0xa75,Word_Break::Extend},
{0xa76,static_cast<Word_Break>(0)},
{0xa81,Word_Break::Extend},
{0xa84,static_cast<Word_Break>(0)},
{0xa85,Word_Break::ALetter},
{0xa8e,static_cast<Word_Break>(0)},
{0xa8f,Word_Break::ALetter},
{0xa92,static_cast<Word_Break>(0)},
{0xa93,Word_Break::ALetter},
{0xaa9,static_cast<Word_Break>(0)},
{0xaaa,Word_Break::ALetter},
{0xab1,static_cast<Word_Break>(0)},
{0xab2,Word_Break::ALetter},
{0xab4,static_cast<Word_Break>(0)},
{0xab5,Word_Break::ALetter},
{0xaba,static_cast<Word_Break>(0)},
{0xabc,Word_Break::Extend},
{0xabd,Word_Break::ALetter},
{0xabe,Word_Break::Extend},
{0xac6,static_cast<Word_Break>(0)},
{0xac7,Word_Break::Extend},
{0xaca,static_cast<Word_Break>(0)},
{0xacb,Word_Break::Extend},
{0xace,static_cast<Word_Break>(0)},
{0xad0,Word_Break::ALetter},
{0xad1,static_cast<Word_Break>(0)},
{0xae0,Word_Break::ALetter},
{0xae2,Word_Break::Extend},
{0xae4,static_cast<Word_Break>(0)},
{0xae6,Word_Break::Numeric},
{0xaf0,static_cast<Word_Break>(0)},
{0xaf9,Word_Break::ALetter},
{0xafa,static_cast<Word_Break>(0)},
{0xb01,Word_Break::Extend},
{0xb04,static_cast<Word_Break>(0)},
{0xb05,Word_Break::ALetter},
{0xb0d,static_cast<Word_Break>(0)},
{0xb0f,Word_Break::ALetter},
{0xb11,static_cast<Word_Break>(0)},
{0xb13,Word_Break::ALetter},
{0xb29,static_cast<Word_Break>(0)},
{0xb2a,Word_Break::ALetter},
{0xb31,static_cast<Word_Break>(0)},
{0xb32,Word_Break::ALetter},
{0xb34,static_cast<Word_Break>(0)},
{0xb35,Word_Break::ALetter},
{0xb3a,static_cast<Word_Break>(0)},
{0xb3c,Word_Break::Extend},
{0xb3d,Word_Break::ALetter},
{0xb3e,Word_Break::Extend},
{0xb45,static_cast<Word_Break>(0)},
{0xb47,Word_Break::Extend},
{0xb49,static_cast<Word_Break>(0)},
{0xb4b,Word_Break::Extend},
{0xb4e,static_cast<Word_Break>(0)},
{0xb56,Word_Break::Extend},
{0xb58,static_cast<Word_Break>(0)},
{0xb5c,Word_Break::ALetter},
{0xb5e,static_cast<Word_Break>(0)},
{0xb5f,Word_Break::ALetter},
{0xb62,Word_Break::Extend},
{0xb64,static_cast<Word_Break>(0)},
{0xb66,Word_Break::Numeric},
{0xb70,static_cast<Word_Break>(0)},
{0xb71,Word_Break::ALetter},
{0xb72,static_cast<Word_Break>(0)},
{0xb82,Word_Break::Extend},
{0xb83,Word_Break::ALetter},
{0xb84,static_cast<Word_Break>(0)},
{0xb85,Word_Break::ALetter},
{0xb8b,static_cast<Word_Break>(0)},
{0xb8e,Word_Break::ALetter},
{0xb91,static_cast<Word_Break>(0)},
{0xb92,Word_Break::ALetter},
{0xb96,static_cast<Word_Break>(0)},
{0xb99,Word_Break::ALetter},
{0xb9b,static_cast<Word_Break>(0)},
{0xb9c,Word_Break::ALetter},
{0xb9d,static_cast<Word_Break>(0)},
{0xb9e,Word_Break::ALetter},
{0xba0,static_cast<Word_Break>(0)},
{0xba3,Word_Break::ALetter},
{0xba5,static_cast<Word_Break>(0)},
{0xba8,Word_Break::ALetter},
{0xbab,static_cast<Word_Break>(0)},
{0xbae,Word_Break::ALetter},
{0xbba,static_cast<Word_Break>(0)},
{0xbbe,Word_Break::Extend},
{0xbc3,static_cast<Word_Break>(0)},
{0xbc6,Word_Break::Extend},
{0xbc9,static_cast<Word_Break>(0)},
{0xbca,Word_Break::Extend},
{0xbce,static_cast<Word_Break>(0)},
{0xbd0,Word_Break::ALetter},
{0xbd1,static_cast<Word_Break>(0)},
{0xbd7,Word_Break::Extend},
{0xbd8,static_cast<Word_Break>(0)},
{0xbe6,Word_Break::Numeric},
{0xbf0,static_cast<Word_Break>(0)},
{0xc00,Word_Break::Extend},
{0xc04,static_cast<Word_Break>(0)},
{0xc05,Word_Break::ALetter},
{0xc0d,static_cast<Word_Break>(0)},
{0xc0e,Word_Break::ALetter},
{0xc11,static_cast<Word_Break>(0)},
{0xc12,Word_Break::ALetter},
{0xc29,static_cast<Word_Break>(0)},
{0xc2a,Word_Break::ALetter},
{0xc3a,static_cast<Word_Break>(0)},
{0xc3d,Word_Break::ALetter},
{0xc3e,Word_Break::Extend},
{0xc45,static_cast<Word_Break>(0)},
{0xc46,Word_Break::Extend},
{0xc49,static_cast<Word_Break>(0)},
{0xc4a,Word_Break::Extend},
{0xc4e,static_cast<Word_Break>(0)},
{0xc55,Word_Break::Extend},
{0xc57,static_cast<Word_Break>(0)},
{0xc58,Word_Break::ALetter},
{0xc5b,static_cast<Word_Break>(0)},
{0xc60,Word_Break::ALetter},
{0xc62,Word_Break::Extend},
{0xc64,static_cast<Word_Break>(0)},
{0xc66,Word_Break::Numeric},
{0xc70,static_cast<Word_Break>(0)},
{0xc81,Word_Break::Extend},
{0xc84,static_cast<Word_Break>(0)},
{0xc85,Word_Break::ALetter},
{0xc8d,static_cast<Word_Break>(0)},
{0xc8e,Word_Break::ALetter},
{0xc91,static_cast<Word_Break>(0)},
{0xc92,Word_Break::ALetter},
{0xca9,static_cast<Word_Break>(0)},
{0xcaa,Word_Break::ALetter},
{0xcb4,static_cast<Word_Break>(0)},
{0xcb5,Word_Break::ALetter},
{0xcba,static_cast<Word_Break>(0)},
{0xcbc,Word_Break::Extend},
{0xcbd,Word_Break::ALetter},
{0xcbe,Word_Break::Extend},
{0xcc5,static_cast<Word_Break>(0)},
{0xcc6,Word_Break::Extend},
{0xcc9,static_cast<Word_Break>(0)},
{0xcca,Word_Break::Extend},
{0xcce,static_cast<Word_Break>(0)},
{0xcd5,Word_Break::Extend},
{0xcd7,static_cast<Word_Break>(0)},
{0xcde,Word_Break::ALetter},
{0xcdf,static_cast<Word_Break>(0)},
{0xce0,Word_Break::ALetter},
{0xce2,Word_Break::Extend},
{0xce4,static_cast<Word_Break>(0)},
{0xce6,Word_Break::Numeric},
{0xcf0,static_cast<Word_Break>(0)},
{0xcf1,Word_Break::ALetter},
{0xcf3,static_cast<Word_Break>(0)},
{0xd01,Word_Break::Extend},
{0xd04,static_cast<Word_Break>(0)},
{0xd05,Word_Break::ALetter},
{0xd0d,static_cast<Word_Break>(0)},
{0xd0e,Word_Break::ALetter},
{0xd11,static_cast<Word_Break>(0)},
{0xd12,Word_Break::ALetter},
{0xd3b,static_cast<Word_Break>(0)},
{0xd3d,Word_Break::ALetter},
{0xd3e,Word_Break::Extend},
{0xd45,static_cast<Word_Break>(0)},
{0xd46,Word_Break::Extend},
{0xd49,static_cast<Word_Break>(0)},
{0xd4a,Word_Break::Extend},
{0xd4e,Word_Break::ALetter},
{0xd4f,static_cast<Word_Break>(0)},
{0xd57,Word_Break::Extend},
{0xd58,static_cast<Word_Break>(0)},
{0xd5f,Word_Break::ALetter},
{0xd62,Word_Break::Extend},
{0xd64,static_cast<Word_Break>(0)},
{0xd66,Word_Break::Numeric},
{0xd70,static_cast<Word_Break>(0)},
{0xd7a,Word_Break::ALetter},
{0xd80,static_cast<Word_Break>(0)},
{0xd82,Word_Break::Extend},
{0xd84,static_cast<Word_Break>(0)},
{0xd85,Word_Break::ALetter},
{0xd97,static_cast<Word_Break>(0)},
{0xd9a,Word_Break::ALetter},
{0xdb2,static_cast<Word_Break>(0)},
{0xdb3,Word_Break::ALetter},
{0xdbc,static_cast<Word_Break>(0)},
{0xdbd,Word_Break::ALetter},
{0xdbe,static_cast<Word_Break>(0)},
{0xdc0,Word_Break::ALetter},
{0xdc7,static_cast<Word_Break>(0)},
{0xdca,Word_Break::Extend},
{0xdcb,static_cast<Word_Break>(0)},
{0xdcf,Word_Break::Extend},
{0xdd5,static_cast<Word_Break>(0)},
{0xdd6,Word_Break::Extend},
{0xdd7,static_cast<Word_Break>(0)},
{0xdd8,Word_Break::Extend},
{0xde0,static_cast<Word_Break>(0)},
{0xde6,Word_Break::Numeric},
{0xdf0,static_cast<Word_Break>(0)},
{0xdf2,Word_Break::Extend},
{0xdf4,static_cast<Word_Break>(0)},
{0xe31,Word_Break::Extend},
{0xe32,static_cast<Word_Break>(0)},
{0xe34,Word_Break::Extend},
{0xe3b,static_cast<Word_Break>(0)},
{0xe47,Word_Break::Extend},
{0xe4f,static_cast<Word_Break>(0)},
{0xe50,Word_Break::Numeric},
{0xe5a,static_cast<Word_Break>(0)},
{0xeb1,Word_Break::Extend},
{0xeb2,static_cast<Word_Break>(0)},
{0xeb4,Word_Break::Extend},
{0xeba,static_cast<Word_Break>(0)},
{0xebb,Word_Break::Extend},
{0xebd,static_cast<Word_Break>(0)},
{0xec8,Word_Break::Extend},
{0xece,static_cast<Word_Break>(0)},
{0xed0,Word_Break::Numeric},
{0xeda,static_cast<Word_Break>(0)},
{0xf00,Word_Break::ALetter},
{0xf01,static_cast<Word_Break>(0)},
{0xf18,Word_Break::Extend},
{0xf1a,static_cast<Word_Break>(0)},
{0xf20,Word_Break::Numeric},
{0xf2a,static_cast<Word_Break>(0)},
{0xf35,Word_Break::Extend},
{0xf36,static_cast<Word_Break>(0)},
{0xf37,Word_Break::Extend},
{0xf38,static_cast<Word_Break>(0)},
{0xf39,Word_Break::Extend},
{0xf3a,static_cast<Word_Break>(0)},
{0xf3e,Word_Break::Extend},
{0xf40,Word_Break::ALetter},
{0xf48,static_cast<Word_Break>(0)},
{0xf49,Word_Break::ALetter},
{0xf6d,static_cast<Word_Break>(0)},
{0xf71,Word_Break::Extend},
{0xf85,static_cast<Word_Break>(0)},
{0xf86,Word_Break::Extend},
{0xf88,Word_Break::ALetter},
{0xf8d,Word_Break::Extend},
{0xf98,static_cast<Word_Break>(0)},
{0xf99,Word_Break::Extend},
{0xfbd,static_cast<Word_Break>(0)},
{0xfc6,Word_Break::Extend},
{0xfc7,static_cast<Word_Break>(0)},
{0x102b,Word_Break::Extend},
{0x103f,static_cast<Word_Break>(0)},
{0x1040,Word_Break::Numeric},
{0x104a,static_cast<Word_Break>(0)},
{0x1056,Word_Break::Extend},
{0x105a,static_cast<Word_Break>(0)},
{0x105e,Word_Break::Extend},
{0x1061,static_cast<Word_Break>(0)},
{0x1062,Word_Break::Extend},
{0x1065,static_cast<Word_Break>(0)},
{0x1067,Word_Break::Extend},
{0x106e,static_cast<Word_Break>(0)},
{0x1071,Word_Break::Extend},
{0x1075,static_cast<Word_Break>(0)},
{0x1082,Word_Break::Extend},
{0x108e,static_cast<Word_Break>(0)},
{0x108f,Word_Break::Extend},
{0x1090,Word_Break::Numeric},
{0x109a,Word_Break::Extend},
{0x109e,static_cast<Word_Break>(0)},
{0x10a0,Word_Break::ALetter},
{0x10c6,static_cast<Word_Break>(0)},
{0x10c7,Word_Break::ALetter},
{0x10c8,static_cast<Word_Break>(0)},
{0x10cd,Word_Break::ALetter},
{0x10ce,static_cast<Word_Break>(0)},
{0x10d0,Word_Break::ALetter},
{0x10fb,static_cast<Word_Break>(0)},
{0x10fc,Word_Break::ALetter},
{0x1249,static_cast<Word_Break>(0)},
{0x124a,Word_Break::ALetter},
{0x124e,static_cast<Word_Break>(0)},
{0x1250,Word_Break::ALetter},
{0x1257,static_cast<Word_Break>(0)},
{0x1258,Word_Break::ALetter},
{0x1259,static_cast<Word_Break>(0)},
{0x125a,Word_Break::ALetter},
{0x125e,static_cast<Word_Break>(0)},
{0x1260,Word_Break::ALetter},
{0x1289,static_cast<Word_Break>(0)},
{0x128a,Word_Break::ALetter},
{0x128e,static_cast<Word_Break>(0)},
{0x1290,Word_Break::ALetter},
{0x12b1,static_cast<Word_Break>(0)},
{0x12b2,Word_Break::ALetter},
{0x12b6,static_cast<Word_Break>(0)},
{0x12b8,Word_Break::ALetter},
{0x12bf,static_cast<Word_Break>(0)},
{0x12c0,Word_Break::ALetter},
{0x12c1,static_cast<Word_Break>(0)},
{0x12c2,Word_Break::ALetter},
{0x12c6,static_cast<Word_Break>(0)},
{0x12c8,Word_Break::ALetter},
{0x12d7,static_cast<Word_Break>(0)},
{0x12d8,Word_Break::ALetter},
{0x1311,static_cast<Word_Break>(0)},
{0x1312,Word_Break::ALetter},
{0x1316,static_cast<Word_Break>(0)},
{0x1318,Word_Break::ALetter},
{0x135b,static_cast<Word_Break>(0)},
{0x135d,Word_Break::Extend},
{0x1360,static_cast<Word_Break>(0)},
{0x1380,Word_Break::ALetter},
{0x1390,static_cast<Word_Break>(0)},
{0x13a0,Word_Break::ALetter},
{0x13f6,static_cast<Word_Break>(0)},
{0x13f8,Word_Break::ALetter},
{0x13fe,static_cast<Word_Break>(0)},
{0x1401,Word_Break::ALetter},
{0x166d,static_cast<Word_Break>(0)},
{0x166f,Word_Break::ALetter},
{0x1680,static_cast<Word_Break>(0)},
{0x1681,Word_Break::ALetter},
{0x169b,static_cast<Word_Break>(0)},
{0x16a0,Word_Break::ALetter},
{0x16eb,static_cast<Word_Break>(0)},
{0x16ee,Word_Break::ALetter},
{0x16f9,static_cast<Word_Break>(0)},
{0x1700,Word_Break::ALetter},
{0x170d,static_cast<Word_Break>(0)},
{0x170e,Word_Break::ALetter},
{0x1712,Word_Break::Extend},
{0x1715,static_cast<Word_Break>(0)},
{0x1720,Word_Break::ALetter},
{0x1732,Word_Break::Extend},
{0x1735,static_cast<Word_Break>(0)},
{0x1740,Word_Break::ALetter},
{0x1752,Word_Break::Extend},
{0x1754,static_cast<Word_Break>(0)},
{0x1760,Word_Break::ALetter},
{0x176d,static_cast<Word_Break>(0)},
{0x176e,Word_Break::ALetter},
{0x1771,static_cast<Word_Break>(0)},
{0x1772,Word_Break::Extend},
{0x1774,static_cast<Word_Break>(0)},
{0x17b4,Word_Break::Extend},
{0x17d4,static_cast<Word_Break>(0)},
{0x17dd,Word_Break::Extend},
{0x17de,static_cast<Word_Break>(0)},
{0x17e0,Word_Break::Numeric},
{0x17ea,static_cast<Word_Break>(0)},
{0x180b,Word_Break::Extend},
{0x180e,Word_Break::Format},
{0x180f,static_cast<Word_Break>(0)},
{0x1810,Word_Break::Numeric},
{0x181a,static_cast<Word_Break>(0)},
{0x1820,Word_Break::ALetter},
{0x1878,static_cast<Word_Break>(0)},
{0x1880,Word_Break::ALetter},
{0x18a9,Word_Break::Extend},
{0x18aa,Word_Break::ALetter},
{0x18ab,static_cast<Word_Break>(0)},
{0x18b0,Word_Break::ALetter},
{0x18f6,static_cast<Word_Break>(0)},
{0x1900,Word_Break::ALetter},
{0x191f,static_cast<Word_Break>(0)},
{0x1920,Word_Break::Extend},
{0x192c,static_cast<Word_Break>(0)},
{0x1930,Word_Break::Extend},
{0x193c,static_cast<Word_Break>(0)},
{0x1946,Word_Break::Numeric},
{0x1950,static_cast<Word_Break>(0)},
{0x19d0,Word_Break::Numeric},
{0x19da,static_cast<Word_Break>(0)},
{0x1a00,Word_Break::ALetter},
{0x1a17,Word_Break::Extend},
{0x1a1c,static_cast<Word_Break>(0)},
{0x1a55,Word_Break::Extend},
{0x1a5f,static_cast<Word_Break>(0)},
{0x1a60,Word_Break::Extend},
{0x1a7d,static_cast<Word_Break>(0)},
{0x1a7f,Word_Break::Extend},
{0x1a80,Word_Break::Numeric},
{0x1a8a,static_cast<Word_Break>(0)},
{0x1a90,Word_Break::Numeric},
{0x1a9a,static_cast<Word_Break>(0)},
{0x1ab0,Word_Break::Extend},
{0x1abf,static_cast<Word_Break>(0)},
{0x1b00,Word_Break::Extend},
{0x1b05,Word_Break::ALetter},
{0x1b34,Word_Break::Extend},
{0x1b45,Word_Break::ALetter},
{0x1b4c,static_cast<Word_Break>(0)},
{0x1b50,Word_Break::Numeric},
{0x1b5a,static_cast<Word_Break>(0)},
{0x1b6b,Word_Break::Extend},
{0x1b74,static_cast<Word_Break>(0)},
{0x1b80,Word_Break::Extend},
{0x1b83,Word_Break::ALetter},
{0x1ba1,Word_Break::Extend},
{0x1bae,Word_Break::ALetter},
{0x1bb0,Word_Break::Numeric},
{0x1bba,Word_Break::ALetter},
{0x1be6,Word_Break::Extend},
{0x1bf4,static_cast<Word_Break>(0)},
{0x1c00,Word_Break::ALetter},
{0x1c24,Word_Break::Extend},
{0x1c38,static_cast<Word_Break>(0)},
{0x1c40,Word_Break::Numeric},
{0x1c4a,static_cast<Word_Break>(0)},
{0x1c4d,Word_Break::ALetter},
{0x1c50,Word_Break::Numeric},
{0x1c5a,Word_Break::ALetter},
{0x1c7e,static_cast<Word_Break>(0)},
{0x1cd0,Word_Break::Extend},
{0x1cd3,static_cast<Word_Break>(0)},
{0x1cd4,Word_Break::Extend},
{0x1ce9,Word_Break::ALetter},
{0x1ced,Word_Break::Extend},
{0x1cee,Word_Break::ALetter},
{0x1cf2,Word_Break::Extend},
{0x1cf5,Word_Break::ALetter},
{0x1cf7,static_cast<Word_Break>(0)},
{0x1cf8,Word_Break::Extend},
{0x1cfa,static_cast<Word_Break>(0)},
{0x1d00,Word_Break::ALetter},
{0x1dc0,Word_Break::Extend},
{0x1df6,static_cast<Word_Break>(0)},
{0x1dfc,Word_Break::Extend},
{0x1e00,Word_Break::ALetter},
{0x1f16,static_cast<Word_Break>(0)},
{0x1f18,Word_Break::ALetter},
{0x1f1e,static_cast<Word_Break>(0)},
{0x1f20,Word_Break::ALetter},
{0x1f46,static_cast<Word_Break>(0)},
{0x1f48,Word_Break::ALetter},
{0x1f4e,static_cast<Word_Break>(0)},
{0x1f50,Word_Break::ALetter},
{0x1f58,static_cast<Word_Break>(0)},
{0x1f59,Word_Break::ALetter},
{0x1f5a,static_cast<Word_Break>(0)},
{0x1f5b,Word_Break::ALetter},
{0x1f5c,static_cast<Word_Break>(0)},
{0x1f5d,Word_Break::ALetter},
{0x1f5e,static_cast<Word_Break>(0)},
{0x1f5f,Word_Break::ALetter},
{0x1f7e,static_cast<Word_Break>(0)},
{0x1f80,Word_Break::ALetter},
{0x1fb5,static_cast<Word_Break>(0)},
{0x1fb6,Word_Break::ALetter},
{0x1fbd,static_cast<Word_Break>(0)},
{0x1fbe,Word_Break::ALetter},
{0x1fbf,static_cast<Word_Break>(0)},
{0x1fc2,Word_Break::ALetter},
{0x1fc5,static_cast<Word_Break>(0)},
{0x1fc6,Word_Break::ALetter},
{0x1fcd,static_cast<Word_Break>(0)},
{0x1fd0,Word_Break::ALetter},
{0x1fd4,static_cast<Word_Break>(0)},
{0x1fd6,Word_Break::ALetter},
{0x1fdc,static_cast<Word_Break>(0)},
{0x1fe0,Word_Break::ALetter},
{0x1fed,static_cast<Word_Break>(0)},
{0x1ff2,Word_Break::ALetter},
{0x1ff5,static_cast<Word_Break>(0)},
{0x1ff6,Word_Break::ALetter},
{0x1ffd,static_cast<Word_Break>(0)},
{0x200c,Word_Break::Extend},
{0x200e,Word_Break::Format},
{0x2010,static_cast<Word_Break>(0)},
{0x2018,Word_Break::MidNumLet},
{0x201a,static_cast<Word_Break>(0)},
{0x2024,Word_Break::MidNumLet},
{0x2025,static_cast<Word_Break>(0)},
{0x2027,Word_Break::MidLetter},
{0x2028,Word_Break::Newline},
{0x202a,Word_Break::Format},
{0x202f,static_cast<Word_Break>(0)},
{0x203f,Word_Break::ExtendNumLet},
{0x2041,static_cast<Word_Break>(0)},
{0x2044,Word_Break::MidNum},
{0x2045,static_cast<Word_Break>(0)},
{0x2054,Word_Break::ExtendNumLet},
{0x2055,static_cast<Word_Break>(0)},
{0x2060,Word_Break::Format},
{0x2065,static_cast<Word_Break>(0)},
{0x2066,Word_Break::Format},
{0x2070,static_cast<Word_Break>(0)},
{0x2071,Word_Break::ALetter},
{0x2072,static_cast<Word_Break>(0)},
{0x207f,Word_Break::ALetter},
{0x2080,static_cast<Word_Break>(0)},
{0x2090,Word_Break::ALetter},
{0x209d,static_cast<Word_Break>(0)},
{0x20d0,Word_Break::Extend},
{0x20f1,static_cast<Word_Break>(0)},
{0x2102,Word_Break::ALetter},
{0x2103,static_cast<Word_Break>(0)},
{0x2107,Word_Break::ALetter},
{0x2108,static_cast<Word_Break>(0)},
{0x210a,Word_Break::ALetter},
{0x2114,static_cast<Word_Break>(0)},
{0x2115,Word_Break::ALetter},
{0x2116,static_cast<Word_Break>(0)},
{0x2119,Word_Break::ALetter},
{0x211e,static_cast<Word_Break>(0)},
{0x2124,Word_Break::ALetter},
{0x2125,static_cast<Word_Break>(0)},
{0x2126,Word_Break::ALetter},
{0x2127,static_cast<Word_Break>(0)},
{0x2128,Word_Break::ALetter},
{0x2129,static_cast<Word_Break>(0)},
{0x212a,Word_Break::ALetter},
{0x212e,static_cast<Word_Break>(0)},
{0x212f,Word_Break::ALetter},
{0x213a,static_cast<Word_Break>(0)},
{0x213c,Word_Break::ALetter},
{0x2140,static_cast<Word_Break>(0)},
{0x2145,Word_Break::ALetter},
{0x214a,static_cast<Word_Break>(0)},
{0x214e,Word_Break::ALetter},
{0x214f,static_cast<Word_Break>(0)},
{0x2160,Word_Break::ALetter},
{0x2189,static_cast<Word_Break>(0)},
{0x24b6,Word_Break::ALetter},
{0x24ea,static_cast<Word_Break>(0)},
{0x2c00,Word_Break::ALetter},
{0x2c2f,static_cast<Word_Break>(0)},
{0x2c30,Word_Break::ALetter},
{0x2c5f,static_cast<Word_Break>(0)},
{0x2c60,Word_Break::ALetter},
{0x2ce5,static_cast<Word_Break>(0)},
{0x2ceb,Word_Break::ALetter},
{0x2cef,Word_Break::Extend},
{0x2cf2,Word_Break::ALetter},
{0x2cf4,static_cast<Word_Break>(0)},
{0x2d00,Word_Break::ALetter},
{0x2d26,static_cast<Word_Break>(0)},
{0x2d27,Word_Break::ALetter},
{0x2d28,static_cast<Word_Break>(0)},
{0x2d2d,Word_Break::ALetter},
{0x2d2e,static_cast<Word_Break>(0)},
{0x2d30,Word_Break::ALetter},
{0x2d68,static_cast<Word_Break>(0)},
{0x2d6f,Word_Break::ALetter},
{0x2d70,static_cast<Word_Break>(0)},
{0x2d7f,Word_Break::Extend},
{0x2d80,Word_Break::ALetter},
{0x2d97,static_cast<Word_Break>(0)},
{0x2da0,Word_Break::ALetter},
{0x2da7,static_cast<Word_Break>(0)},
{0x2da8,Word_Break::ALetter},
{0x2daf,static_cast<Word_Break>(0)},
{0x2db0,Word_Break::ALetter},
{0x2db7,static_cast<Word_Break>(0)},
{0x2db8,Word_Break::ALetter},
{0x2dbf,static_cast<Word_Break>(0)},
{0x2dc0,Word_Break::ALetter},
{0x2dc7,static_cast<Word_Break>(0)},
{0x2dc8,Word_Break::ALetter},
{0x2dcf,static_cast<Word_Break>(0)},
{0x2dd0,Word_Break::ALetter},
{0x2dd7,static_cast<Word_Break>(0)},
{0x2dd8,Word_Break::ALetter},
{0x2ddf,static_cast<Word_Break>(0)},
{0x2de0,Word_Break::Extend},
{0x2e00,static_cast<Word_Break>(0)},
{0x2e2f,Word_Break::ALetter},
{0x2e30,static_cast<Word_Break>(0)},
{0x3005,Word_Break::ALetter},
{0x3006,static_cast<Word_Break>(0)},
{0x302a,Word_Break::Extend},
{0x3030,static_cast<Word_Break>(0)},
{0x3031,Word_Break::Katakana},
{0x3036,static_cast<Word_Break>(0)},
{0x303b,Word_Break::ALetter},
{0x303d,static_cast<Word_Break>(0)},
{0x3099,Word_Break::Extend},
{0x309b,Word_Break::Katakana},
{0x309d,static_cast<Word_Break>(0)},
{0x30a0,Word_Break::Katakana},
{0x30fb,static_cast<Word_Break>(0)},
{0x30fc,Word_Break::Katakana},
{0x3100,static_cast<Word_Break>(0)},
{0x3105,Word_Break::ALetter},
{0x312e,static_cast<Word_Break>(0)},
{0x3131,Word_Break::ALetter},
{0x318f,static_cast<Word_Break>(0)},
{0x31a0,Word_Break::ALetter},
{0x31bb,static_cast<Word_Break>(0)},
{0x31f0,Word_Break::Katakana},
{0x3200,static_cast<Word_Break>(0)},
{0x32d0,Word_Break::Katakana},
{0x32ff,static_cast<Word_Break>(0)},
{0x3300,Word_Break::Katakana},
{0x3358,static_cast<Word_Break>(0)},
{0xa000,Word_Break::ALetter},
{0xa48d,static_cast<Word_Break>(0)},
{0xa4d0,Word_Break::ALetter},
{0xa4fe,static_cast<Word_Break>(0)},
{0xa500,Word_Break::ALetter},
{0xa60d,static_cast<Word_Break>(0)},
{0xa610,Word_Break::ALetter},
{0xa620,Word_Break::Numeric},
{0xa62a,Word_Break::ALetter},
{0xa62c,static_cast<Word_Break>(0)},
{0xa640,Word_Break::ALetter},
{0xa66f,Word_Break::Extend},
{0xa673,static_cast<Word_Break>(0)},
{0xa674,Word_Break::Extend},
{0xa67e,static_cast<Word_Break>(0)},
{0xa67f,Word_Break::ALetter},
{0xa69e,Word_Break::Extend},
{0xa6a0,Word_Break::ALetter},
{0xa6f0,Word_Break::Extend},
{0xa6f2,static_cast<Word_Break>(0)},
{0xa717,Word_Break::ALetter},
{0xa720,static_cast<Word_Break>(0)},
{0xa722,Word_Break::ALetter},
{0xa789,static_cast<Word_Break>(0)},
{0xa78b,Word_Break::ALetter},
{0xa7ae,static_cast<Word_Break>(0)},
{0xa7b0,Word_Break::ALetter},
{0xa7b8,static_cast<Word_Break>(0)},
{0xa7f7,Word_Break::ALetter},
{0xa802,Word_Break::Extend},
{0xa803,Word_Break::ALetter},
{0xa806,Word_Break::Extend},
{0xa807,Word_Break::ALetter},
{0xa80b,Word_Break::Extend},
{0xa80c,Word_Break::ALetter},
{0xa823,Word_Break::Extend},
{0xa828,static_cast<Word_Break>(0)},
{0xa840,Word_Break::ALetter},
{0xa874,static_cast<Word_Break>(0)},
{0xa880,Word_Break::Extend},
{0xa882,Word_Break::ALetter},
{0xa8b4,Word_Break::Extend},
{0xa8c5,static_cast<Word_Break>(0)},
{0xa8d0,Word_Break::Numeric},
{0xa8da,static_cast<Word_Break>(0)},
{0xa8e0,Word_Break::Extend},
{0xa8f2,Word_Break::ALetter},
{0xa8f8,static_cast<Word_Break>(0)},
{0xa8fb,Word_Break::ALetter},
{0xa8fc,static_cast<Word_Break>(0)},
{0xa8fd,Word_Break::ALetter},
{0xa8fe,static_cast<Word_Break>(0)},
{0xa900,Word_Break::Numeric},
{0xa90a,Word_Break::ALetter},
{0xa926,Word_Break::Extend},
{0xa92e,static_cast<Word_Break>(0)},
{0xa930,Word_Break::ALetter},
{0xa947,Word_Break::Extend},
{0xa954,static_cast<Word_Break>(0)},
{0xa960,Word_Break::ALetter},
{0xa97d,static_cast<Word_Break>(0)},
{0xa980,Word_Break::Extend},
{0xa984,Word_Break::ALetter},
{0xa9b3,Word_Break::Extend},
{0xa9c1,static_cast<Word_Break>(0)},
{0xa9cf,Word_Break::ALetter},
{0xa9d0,Word_Break::Numeric},
{0xa9da,static_cast<Word_Break>(0)},
{0xa9e5,Word_Break::Extend},
{0xa9e6,static_cast<Word_Break>(0)},
{0xa9f0,Word_Break::Numeric},
{0xa9fa,static_cast<Word_Break>(0)},
{0xaa00,Word_Break::ALetter},
{0xaa29,Word_Break::Extend},
{0xaa37,static_cast<Word_Break>(0)},
{0xaa40,Word_Break::ALetter},
{0xaa43,Word_Break::Extend},
{0xaa44,Word_Break::ALetter},
{0xaa4c,Word_Break::Extend},
{0xaa4e,static_cast<Word_Break>(0)},
{0xaa50,Word_Break::Numeric},
{0xaa5a,static_cast<Word_Break>(0)},
{0xaa7b,Word_Break::Extend},
{0xaa7e,static_cast<Word_Break>(0)},
{0xaab0,Word_Break::Extend},
{0xaab1,static_cast<Word_Break>(0)},
{0xaab2,Word_Break::Extend},
{0xaab5,static_cast<Word_Break>(0)},
{0xaab7,Word_Break::Extend},
{0xaab9,static_cast<Word_Break>(0)},
{0xaabe,Word_Break::Extend},
{0xaac0,static_cast<Word_Break>(0)},
{0xaac1,Word_Break::Extend},
{0xaac2,static_cast<Word_Break>(0)},
{0xaae0,Word_Break::ALetter},
{0xaaeb,Word_Break::Extend},
{0xaaf0,static_cast<Word_Break>(0)},
{0xaaf2,Word_Break::ALetter},
{0xaaf5,Word_Break::Extend},
{0xaaf7,static_cast<Word_Break>(0)},
{0xab01,Word_Break::ALetter},
{0xab07,static_cast<Word_Break>(0)},
{0xab09,Word_Break::ALetter},
{0xab0f,static_cast<Word_Break>(0)},
{0xab11,Word_Break::ALetter},
{0xab17,static_cast<Word_Break>(0)},
{0xab20,Word_Break::ALetter},
{0xab27,static_cast<Word_Break>(0)},
{0xab28,Word_Break::ALetter},
{0xab2f,static_cast<Word_Break>(0)},
{0xab30,Word_Break::ALetter},
{0xab5b,static_cast<Word_Break>(0)},
{0xab5c,Word_Break::ALetter},
{0xab66,static_cast<Word_Break>(0)},
{0xab70,Word_Break::ALetter},
{0xabe3,Word_Break::Extend},
{0xabeb,static_cast<Word_Break>(0)},
{0xabec,Word_Break::Extend},
{0xabee,static_cast<Word_Break>(0)},
{0xabf0,Word_Break::Numeric},
{0xabfa,static_cast<Word_Break>(0)},
{0xac00,Word_Break::ALetter},
{0xd7a4,static_cast<Word_Break>(0)},
{0xd7b0,Word_Break::ALetter},
{0xd7c7,static_cast<Word_Break>(0)},
{0xd7cb,Word_Break::ALetter},
{0xd7fc,static_cast<Word_Break>(0)},
{0xfb00,Word_Break::ALetter},
{0xfb07,static_cast<Word_Break>(0)},
{0xfb13,Word_Break::ALetter},
{0xfb18,static_cast<Word_Break>(0)},
{0xfb1d,Word_Break::Hebrew_Letter},
{0xfb1e,Word_Break::Extend},
{0xfb1f,Word_Break::Hebrew_Letter},
{0xfb29,static_cast<Word_Break>(0)},
{0xfb2a,Word_Break::Hebrew_Letter},
{0xfb37,static_cast<Word_Break>(0)},
{0xfb38,Word_Break::Hebrew_Letter},
{0xfb3d,static_cast<Word_Break>(0)},
{0xfb3e,Word_Break::Hebrew_Letter},
{0xfb3f,static_cast<Word_Break>(0)},
{0xfb40,Word_Break::Hebrew_Letter},
{0xfb42,static_cast<Word_Break>(0)},
{0xfb43,Word_Break::Hebrew_Letter},
{0xfb45,static_cast<Word_Break>(0)},
{0xfb46,Word_Break::Hebrew_Letter},
{0xfb50,Word_Break::ALetter},
{0xfbb2,static_cast<Word_Break>(0)},
{0xfbd3,Word_Break::ALetter},
{0xfd3e,static_cast<Word_Break>(0)},
{0xfd50,Word_Break::ALetter},
{0xfd90,static_cast<Word_Break>(0)},
{0xfd92,Word_Break::ALetter},
{0xfdc8,static_cast<Word_Break>(0)},
{0xfdf0,Word_Break::ALetter},
{0xfdfc,static_cast<Word_Break>(0)},
{0xfe00,Word_Break::Extend},
{0xfe10,Word_Break::MidNum},
{0xfe11,static_cast<Word_Break>(0)},
{0xfe13,Word_Break::MidLetter},
{0xfe14,Word_Break::MidNum},
{0xfe15,static_cast<Word_Break>(0)},
{0xfe20,Word_Break::Extend},
{0xfe30,static_cast<Word_Break>(0)},
{0xfe33,Word_Break::ExtendNumLet},
{0xfe35,static_cast<Word_Break>(0)},
{0xfe4d,Word_Break::ExtendNumLet},
{0xfe50,Word_Break::MidNum},
{0xfe51,static_cast<Word_Break>(0)},
{0xfe52,Word_Break::MidNumLet},
{0xfe53,static_cast<Word_Break>(0)},
{0xfe54,Word_Break::MidNum},
{0xfe55,Word_Break::MidLetter},
{0xfe56,static_cast<Word_Break>(0)},
{0xfe70,Word_Break::ALetter},
{0xfe75,static_cast<Word_Break>(0)},
{0xfe76,Word_Break::ALetter},
{0xfefd,static_cast<Word_Break>(0)},
{0xfeff,Word_Break::Format},
{0xff00,static_cast<Word_Break>(0)},
{0xff07,Word_Break::MidNumLet},
{0xff08,static_cast<Word_Break>(0)},
{0xff0c,Word_Break::MidNum},
{0xff0d,static_cast<Word_Break>(0)},
{0xff0e,Word_Break::MidNumLet},
{0xff0f,static_cast<Word_Break>(0)},
{0xff1a,Word_Break::MidLetter},
{0xff1b,Word_Break::MidNum},
{0xff1c,static_cast<Word_Break>(0)},
{0xff21,Word_Break::ALetter},
{0xff3b,static_cast<Word_Break>(0)},
{0xff3f,Word_Break::ExtendNumLet},
{0xff40,static_cast<Word_Break>(0)},
{0xff41,Word_Break::ALetter},
{0xff5b,static_cast<Word_Break>(0)},
{0xff66,Word_Break::Katakana},
{0xff9e,Word_Break::Extend},
{0xffa0,Word_Break::ALetter},
{0xffbf,static_cast<Word_Break>(0)},
{0xffc2,Word_Break::ALetter},
{0xffc8,static_cast<Word_Break>(0)},
{0xffca,Word_Break::ALetter},
{0xffd0,static_cast<Word_Break>(0)},
{0xffd2,Word_Break::ALetter},
{0xffd8,static_cast<Word_Break>(0)},
{0xffda,Word_Break::ALetter},
{0xffdd,static_cast<Word_Break>(0)},
{0xfff9,Word_Break::Format},
{0xfffc,static_cast<Word_Break>(0)},
{0x10000,Word_Break::ALetter},
{0x1000c,static_cast<Word_Break>(0)},
{0x1000d,Word_Break::ALetter},
{0x10027,static_cast<Word_Break>(0)},
{0x10028,Word_Break::ALetter},
{0x1003b,static_cast<Word_Break>(0)},
{0x1003c,Word_Break::ALetter},
{0x1003e,static_cast<Word_Break>(0)},
{0x1003f,Word_Break::ALetter},
{0x1004e,static_cast<Word_Break>(0)},
{0x10050,Word_Break::ALetter},
{0x1005e,static_cast<Word_Break>(0)},
{0x10080,Word_Break::ALetter},
{0x100fb,static_cast<Word_Break>(0)},
{0x10140,Word_Break::ALetter},
{0x10175,static_cast<Word_Break>(0)},
{0x101fd,Word_Break::Extend},
{0x101fe,static_cast<Word_Break>(0)},
{0x10280,Word_Break::ALetter},
{0x1029d,static_cast<Word_Break>(0)},
{0x102a0,Word_Break::ALetter},
{0x102d1,static_cast<Word_Break>(0)},
{0x102e0,Word_Break::Extend},
{0x102e1,static_cast<Word_Break>(0)},
{0x10300,Word_Break::ALetter},
{0x10320,static_cast<Word_Break>(0)},
{0x10330,Word_Break::ALetter},
{0x1034b,static_cast<Word_Break>(0)},
{0x10350,Word_Break::ALetter},
{0x10376,Word_Break::Extend},
{0x1037b,static_cast<Word_Break>(0)},
{0x10380,Word_Break::ALetter},
{0x1039e,static_cast<Word_Break>(0)},
{0x103a0,Word_Break::ALetter},
{0x103c4,static_cast<Word_Break>(0)},
{0x103c8,Word_Break::ALetter},
{0x103d0,static_cast<Word_Break>(0)},
{0x103d1,Word_Break::ALetter},
{0x103d6,static_cast<Word_Break>(0)},
{0x10400,Word_Break::ALetter},
{0x1049e,static_cast<Word_Break>(0)},
{0x104a0,Word_Break::Numeric},
{0x104aa,static_cast<Word_Break>(0)},
{0x10500,Word_Break::ALetter},
{0x10528,static_cast<Word_Break>(0)},
{0x10530,Word_Break::ALetter},
{0x10564,static_cast<Word_Break>(0)},
{0x10600,Word_Break::ALetter},
{0x10737,static_cast<Word_Break>(0)},
{0x10740,Word_Break::ALetter},
{0x10756,static_cast<Word_Break>(0)},
{0x10760,Word_Break::ALetter},
{0x10768,static_cast<Word_Break>(0)},
{0x10800,Word_Break::ALetter},
{0x10806,static_cast<Word_Break>(0)},
{0x10808,Word_Break::ALetter},
{0x10809,static_cast<Word_Break>(0)},
{0x1080a,Word_Break::ALetter},
{0x10836,static_cast<Word_Break>(0)},
{0x10837,Word_Break::ALetter},
{0x10839,static_cast<Word_Break>(0)},
{0x1083c,Word_Break::ALetter},
{0x1083d,static_cast<Word_Break>(0)},
{0x1083f,Word_Break::ALetter},
{0x10856,static_cast<Word_Break>(0)},
{0x10860,Word_Break::ALetter},
{0x10877,static_cast<Word_Break>(0)},
{0x10880,Word_Break::ALetter},
{0x1089f,static_cast<Word_Break>(0)},
{0x108e0,Word_Break::ALetter},
{0x108f3,static_cast<Word_Break>(0)},
{0x108f4,Word_Break::ALetter},
{0x108f6,static_cast<Word_Break>(0)},
{0x10900,Word_Break::ALetter},
{0x10916,static_cast<Word_Break>(0)},
{0x10920,Word_Break::ALetter},
{0x1093a,static_cast<Word_Break>(0)},
{0x10980,Word_Break::ALetter},
{0x109b8,static_cast<Word_Break>(0)},
{0x109be,Word_Break::ALetter},
{0x109c0,static_cast<Word_Break>(0)},
{0x10a00,Word_Break::ALetter},
{0x10a01,Word_Break::Extend},
{0x10a04,static_cast<Word_Break>(0)},
{0x10a05,Word_Break::Extend},
{0x10a07,static_cast<Word_Break>(0)},
{0x10a0c,Word_Break::Extend},
{0x10a10,Word_Break::ALetter},
{0x10a14,static_cast<Word_Break>(0)},
{0x10a15,Word_Break::ALetter},
{0x10a18,static_cast<Word_Break>(0)},
{0x10a19,Word_Break::ALetter},
{0x10a34,static_cast<Word_Break>(0)},
{0x10a38,Word_Break::Extend},
{0x10a3b,static_cast<Word_Break>(0)},
{0x10a3f,Word_Break::Extend},
{0x10a40,static_cast<Word_Break>(0)},
{0x10a60,Word_Break::ALetter},
{0x10a7d,static_cast<Word_Break>(0)},
{0x10a80,Word_Break::ALetter},
{0x10a9d,static_cast<Word_Break>(0)},
{0x10ac0,Word_Break::ALetter},
{0x10ac8,static_cast<Word_Break>(0)},
{0x10ac9,Word_Break::ALetter},
{0x10ae5,Word_Break::Extend},
{0x10ae7,static_cast<Word_Break>(0)},
{0x10b00,Word_Break::ALetter},
{0x10b36,static_cast<Word_Break>(0)},
{0x10b40,Word_Break::ALetter},
{0x10b56,static_cast<Word_Break>(0)},
{0x10b60,Word_Break::ALetter},
{0x10b73,static_cast<Word_Break>(0)},
{0x10b80,Word_Break::ALetter},
{0x10b92,static_cast<Word_Break>(0)},
{0x10c00,Word_Break::ALetter},
{0x10c49,static_cast<Word_Break>(0)},
{0x10c80,Word_Break::ALetter},
{0x10cb3,static_cast<Word_Break>(0)},
{0x10cc0,Word_Break::ALetter},
{0x10cf3,static_cast<Word_Break>(0)},
{0x11000,Word_Break::Extend},
{0x11003,Word_Break::ALetter},
{0x11038,Word_Break::Extend},
{0x11047,static_cast<Word_Break>(0)},
{0x11066,Word_Break::Numeric},
{0x11070,static_cast<Word_Break>(0)},
{0x1107f,Word_Break::Extend},
{0x11083,Word_Break::ALetter},
{0x110b0,Word_Break::Extend},
{0x110bb,static_cast<Word_Break>(0)},
{0x110bd,Word_Break::Format},
{0x110be,static_cast<Word_Break>(0)},
{0x110d0,Word_Break::ALetter},
{0x110e9,static_cast<Word_Break>(0)},
{0x110f0,Word_Break::Numeric},
{0x110fa,static_cast<Word_Break>(0)},
{0x11100,Word_Break::Extend},
{0x11103,Word_Break::ALetter},
{0x11127,Word_Break::Extend},
{0x11135,static_cast<Word_Break>(0)},
{0x11136,Word_Break::Numeric},
{0x11140,static_cast<Word_Break>(0)},
{0x11150,Word_Break::ALetter},
{0x11173,Word_Break::Extend},
{0x11174,static_cast<Word_Break>(0)},
{0x11176,Word_Break::ALetter},
{0x11177,static_cast<Word_Break>(0)},
{0x11180,Word_Break::Extend},
{0x11183,Word_Break::ALetter},
{0x111b3,Word_Break::Extend},
{0x111c1,Word_Break::ALetter},
{0x111c5,static_cast<Word_Break>(0)},
{0x111ca,Word_Break::Extend},
{0x111cd,static_cast<Word_Break>(0)},
{0x111d0,Word_Break::Numeric},
{0x111da,Word_Break::ALetter},
{0x111db,static_cast<Word_Break>(0)},
{0x111dc,Word_Break::ALetter},
{0x111dd,static_cast<Word_Break>(0)},
{0x11200,Word_Break::ALetter},
{0x11212,static_cast<Word_Break>(0)},
{0x11213,Word_Break::ALetter},
{0x1122c,Word_Break::Extend},
{0x11238,static_cast<Word_Break>(0)},
{0x11280,Word_Break::ALetter},
{0x11287,static_cast<Word_Break>(0)},
{0x11288,Word_Break::ALetter},
{0x11289,static_cast<Word_Break>(0)},
{0x1128a,Word_Break::ALetter},
{0x1128e,static_cast<Word_Break>(0)},
{0x1128f,Word_Break::ALetter},
{0x1129e,static_cast<Word_Break>(0)},
{0x1129f,Word_Break::ALetter},
{0x112a9,static_cast<Word_Break>(0)},
{0x112b0,Word_Break::ALetter},
{0x112df,Word_Break::Extend},
{0x112eb,static_cast<Word_Break>(0)},
{0x112f0,Word_Break::Numeric},
{0x112fa,static_cast<Word_Break>(0)},
{0x11300,Word_Break::Extend},
{0x11304,static_cast<Word_Break>(0)},
{0x11305,Word_Break::ALetter},
{0x1130d,static_cast<Word_Break>(0)},
{0x1130f,Word_Break::ALetter},
{0x11311,static_cast<Word_Break>(0)},
{0x11313,Word_Break::ALetter},
{0x11329,static_cast<Word_Break>(0)},
{0x1132a,Word_Break::ALetter},
{0x11331,static_cast<Word_Break>(0)},
{0x11332,Word_Break::ALetter},
{0x11334,static_cast<Word_Break>(0)},
{0x11335,Word_Break::ALetter},
{0x1133a,static_cast<Word_Break>(0)},
{0x1133c,Word_Break::Extend},
{0x1133d,Word_Break::ALetter},
{0x1133e,Word_Break::Extend},
{0x11345,static_cast<Word_Break>(0)},
{0x11347,Word_Break::Extend},
{0x11349,static_cast<Word_Break>(0)},
{0x1134b,Word_Break::Extend},
{0x1134e,static_cast<Word_Break>(0)},
{0x11350,Word_Break::ALetter},
{0x11351,static_cast<Word_Break>(0)},
{0x11357,Word_Break::Extend},
{0x11358,static_cast<Word_Break>(0)},
{0x1135d,Word_Break::ALetter},
{0x11362,Word_Break::Extend},
{0x11364,static_cast<Word_Break>(0)},
{0x11366,Word_Break::Extend},
{0x1136d,static_cast<Word_Break>(0)},
{0x11370,Word_Break::Extend},
{0x11375,static_cast<Word_Break>(0)},
{0x11480,Word_Break::ALetter},
{0x114b0,Word_Break::Extend},
{0x114c4,Word_Break::ALetter},
{0x114c6,static_cast<Word_Break>(0)},
{0x114c7,Word_Break::ALetter},
{0x114c8,static_cast<Word_Break>(0)},
{0x114d0,Word_Break::Numeric},
{0x114da,static_cast<Word_Break>(0)},
{0x11580,Word_Break::ALetter},
{0x115af,Word_Break::Extend},
{0x115b6,static_cast<Word_Break>(0)},
{0x115b8,Word_Break::Extend},
{0x115c1,static_cast<Word_Break>(0)},
{0x115d8,Word_Break::ALetter},
{0x115dc,Word_Break::Extend},
{0x115de,static_cast<Word_Break>(0)},
{0x11600,Word_Break::ALetter},
{0x11630,Word_Break::Extend},
{0x11641,static_cast<Word_Break>(0)},
{0x11644,Word_Break::ALetter},
{0x11645,static_cast<Word_Break>(0)},
{0x11650,Word_Break::Numeric},
{0x1165a,static_cast<Word_Break>(0)},
{0x11680,Word_Break::ALetter},
{0x116ab,Word_Break::Extend},
{0x116b8,static_cast<Word_Break>(0)},
{0x116c0,Word_Break::Numeric},
{0x116ca,static_cast<Word_Break>(0)},
{0x1171d,Word_Break::Extend},
{0x1172c,static_cast<Word_Break>(0)},
{0x11730,Word_Break::Numeric},
{0x1173a,static_cast<Word_Break>(0)},
{0x118a0,Word_Break::ALetter},
{0x118e0,Word_Break::Numeric},
{0x118ea,static_cast<Word_Break>(0)},
{0x118ff,Word_Break::ALetter},
{0x11900,static_cast<Word_Break>(0)},
{0x11ac0,Word_Break::ALetter},
{0x11af9,static_cast<Word_Break>(0)},
{0x12000,Word_Break::ALetter},
{0x1239a,static_cast<Word_Break>(0)},
{0x12400,Word_Break::ALetter},
{0x1246f,static_cast<Word_Break>(0)},
{0x12480,Word_Break::ALetter},
{0x12544,static_cast<Word_Break>(0)},
{0x13000,Word_Break::ALetter},
{0x1342f,static_cast<Word_Break>(0)},
{0x14400,Word_Break::ALetter},
{0x14647,static_cast<Word_Break>(0)},
{0x16800,Word_Break::ALetter},
{0x16a39,static_cast<Word_Break>(0)},
{0x16a40,Word_Break::ALetter},
{0x16a5f,static_cast<Word_Break>(0)},
{0x16a60,Word_Break::Numeric},
{0x16a6a,static_cast<Word_Break>(0)},
{0x16ad0,Word_Break::ALetter},
{0x16aee,static_cast<Word_Break>(0)},
{0x16af0,Word_Break::Extend},
{0x16af5,static_cast<Word_Break>(0)},
{0x16b00,Word_Break::ALetter},
{0x16b30,Word_Break::Extend},
{0x16b37,static_cast<Word_Break>(0)},
{0x16b40,Word_Break::ALetter},
{0x16b44,static_cast<Word_Break>(0)},
{0x16b50,Word_Break::Numeric},
{0x16b5a,static_cast<Word_Break>(0)},
{0x16b63,Word_Break::ALetter},
{0x16b78,static_cast<Word_Break>(0)},
{0x16b7d,Word_Break::ALetter},
{0x16b90,static_cast<Word_Break>(0)},
{0x16f00,Word_Break::ALetter},
{0x16f45,static_cast<Word_Break>(0)},
{0x16f50,Word_Break::ALetter},
{0x16f51,Word_Break::Extend},
{0x16f7f,static_cast<Word_Break>(0)},
{0x16f8f,Word_Break::Extend},
{0x16f93,Word_Break::ALetter},
{0x16fa0,static_cast<Word_Break>(0)},
{0x1b000,Word_Break::Katakana},
{0x1b001,static_cast<Word_Break>(0)},
{0x1bc00,Word_Break::ALetter},
{0x1bc6b,static_cast<Word_Break>(0)},
{0x1bc70,Word_Break::ALetter},
{0x1bc7d,static_cast<Word_Break>(0)},
{0x1bc80,Word_Break::ALetter},
{0x1bc89,static_cast<Word_Break>(0)},
{0x1bc90,Word_Break::ALetter},
{0x1bc9a,static_cast<Word_Break>(0)},
{0x1bc9d,Word_Break::Extend},
{0x1bc9f,static_cast<Word_Break>(0)},
{0x1bca0,Word_Break::Format},
{0x1bca4,static_cast<Word_Break>(0)},
{0x1d165,Word_Break::Extend},
{0x1d16a,static_cast<Word_Break>(0)},
{0x1d16d,Word_Break::Extend},
{0x1d173,Word_Break::Format},
{0x1d17b,Word_Break::Extend},
{0x1d183,static_cast<Word_Break>(0)},
{0x1d185,Word_Break::Extend},
{0x1d18c,static_cast<Word_Break>(0)},
{0x1d1aa,Word_Break::Extend},
{0x1d1ae,static_cast<Word_Break>(0)},
{0x1d242,Word_Break::Extend},
{0x1d245,static_cast<Word_Break>(0)},
{0x1d400,Word_Break::ALetter},
{0x1d455,static_cast<Word_Break>(0)},
{0x1d456,Word_Break::ALetter},
{0x1d49d,static_cast<Word_Break>(0)},
{0x1d49e,Word_Break::ALetter},
{0x1d4a0,static_cast<Word_Break>(0)},
{0x1d4a2,Word_Break::ALetter},
{0x1d4a3,static_cast<Word_Break>(0)},
{0x1d4a5,Word_Break::ALetter},
{0x1d4a7,static_cast<Word_Break>(0)},
{0x1d4a9,Word_Break::ALetter},
{0x1d4ad,static_cast<Word_Break>(0)},
{0x1d4ae,Word_Break::ALetter},
{0x1d4ba,static_cast<Word_Break>(0)},
{0x1d4bb,Word_Break::ALetter},
{0x1d4bc,static_cast<Word_Break>(0)},
{0x1d4bd,Word_Break::ALetter},
{0x1d4c4,static_cast<Word_Break>(0)},
{0x1d4c5,Word_Break::ALetter},
{0x1d506,static_cast<Word_Break>(0)},
{0x1d507,Word_Break::ALetter},
{0x1d50b,static_cast<Word_Break>(0)},
{0x1d50d,Word_Break::ALetter},
{0x1d515,static_cast<Word_Break>(0)},
{0x1d516,Word_Break::ALetter},
{0x1d51d,static_cast<Word_Break>(0)},
{0x1d51e,Word_Break::ALetter},
{0x1d53a,static_cast<Word_Break>(0)},
{0x1d53b,Word_Break::ALetter},
{0x1d53f,static_cast<Word_Break>(0)},
{0x1d540,Word_Break::ALetter},
{0x1d545,static_cast<Word_Break>(0)},
{0x1d546,Word_Break::ALetter},
{0x1d547,static_cast<Word_Break>(0)},
{0x1d54a,Word_Break::ALetter},
{0x1d551,static_cast<Word_Break>(0)},
{0x1d552,Word_Break::ALetter},
{0x1d6a6,static_cast<Word_Break>(0)},
{0x1d6a8,Word_Break::ALetter},
{0x1d6c1,static_cast<Word_Break>(0)},
{0x1d6c2,Word_Break::ALetter},
{0x1d6db,static_cast<Word_Break>(0)},
{0x1d6dc,Word_Break::ALetter},
{0x1d6fb,static_cast<Word_Break>(0)},
{0x1d6fc,Word_Break::ALetter},
{0x1d715,static_cast<Word_Break>(0)},
{0x1d716,Word_Break::ALetter},
{0x1d735,static_cast<Word_Break>(0)},
{0x1d736,Word_Break::ALetter},
{0x1d74f,static_cast<Word_Break>(0)},
{0x1d750,Word_Break::ALetter},
{0x1d76f,static_cast<Word_Break>(0)},
{0x1d770,Word_Break::ALetter},
{0x1d789,static_cast<Word_Break>(0)},
{0x1d78a,Word_Break::ALetter},
{0x1d7a9,static_cast<Word_Break>(0)},
{0x1d7aa,Word_Break::ALetter},
{0x1d7c3,static_cast<Word_Break>(0)},
{0x1d7c4,Word_Break::ALetter},
{0x1d7cc,static_cast<Word_Break>(0)},
{0x1d7ce,Word_Break::Numeric},
{0x1d800,static_cast<Word_Break>(0)},
{0x1da00,Word_Break::Extend},
{0x1da37,static_cast<Word_Break>(0)},
{0x1da3b,Word_Break::Extend},
{0x1da6d,static_cast<Word_Break>(0)},
{0x1da75,Word_Break::Extend},
{0x1da76,static_cast<Word_Break>(0)},
{0x1da84,Word_Break::Extend},
{0x1da85,static_cast<Word_Break>(0)},
{0x1da9b,Word_Break::Extend},
{0x1daa0,static_cast<Word_Break>(0)},
{0x1daa1,Word_Break::Extend},
{0x1dab0,static_cast<Word_Break>(0)},
{0x1e800,Word_Break::ALetter},
{0x1e8c5,static_cast<Word_Break>(0)},
{0x1e8d0,Word_Break::Extend},
{0x1e8d7,static_cast<Word_Break>(0)},
{0x1ee00,Word_Break::ALetter},
{0x1ee04,static_cast<Word_Break>(0)},
{0x1ee05,Word_Break::ALetter},
{0x1ee20,static_cast<Word_Break>(0)},
{0x1ee21,Word_Break::ALetter},
{0x1ee23,static_cast<Word_Break>(0)},
{0x1ee24,Word_Break::ALetter},
{0x1ee25,static_cast<Word_Break>(0)},
{0x1ee27,Word_Break::ALetter},
{0x1ee28,static_cast<Word_Break>(0)},
{0x1ee29,Word_Break::ALetter},
{0x1ee33,static_cast<Word_Break>(0)},
{0x1ee34,Word_Break::ALetter},
{0x1ee38,static_cast<Word_Break>(0)},
{0x1ee39,Word_Break::ALetter},
{0x1ee3a,static_cast<Word_Break>(0)},
{0x1ee3b,Word_Break::ALetter},
{0x1ee3c,static_cast<Word_Break>(0)},
{0x1ee42,Word_Break::ALetter},
{0x1ee43,static_cast<Word_Break>(0)},
{0x1ee47,Word_Break::ALetter},
{0x1ee48,static_cast<Word_Break>(0)},
{0x1ee49,Word_Break::ALetter},
{0x1ee4a,static_cast<Word_Break>(0)},
{0x1ee4b,Word_Break::ALetter},
{0x1ee4c,static_cast<Word_Break>(0)},
{0x1ee4d,Word_Break::ALetter},
{0x1ee50,static_cast<Word_Break>(0)},
{0x1ee51,Word_Break::ALetter},
{0x1ee53,static_cast<Word_Break>(0)},
{0x1ee54,Word_Break::ALetter},
{0x1ee55,static_cast<Word_Break>(0)},
{0x1ee57,Word_Break::ALetter},
{0x1ee58,static_cast<Word_Break>(0)},
{0x1ee59,Word_Break::ALetter},
{0x1ee5a,static_cast<Word_Break>(0)},
{0x1ee5b,Word_Break::ALetter},
{0x1ee5c,static_cast<Word_Break>(0)},
{0x1ee5d,Word_Break::ALetter},
{0x1ee5e,static_cast<Word_Break>(0)},
{0x1ee5f,Word_Break::ALetter},
{0x1ee60,static_cast<Word_Break>(0)},
{0x1ee61,Word_Break::ALetter},
{0x1ee63,static_cast<Word_Break>(0)},
{0x1ee64,Word_Break::ALetter},
{0x1ee65,static_cast<Word_Break>(0)},
{0x1ee67,Word_Break::ALetter},
{0x1ee6b,static_cast<Word_Break>(0)},
{0x1ee6c,Word_Break::ALetter},
{0x1ee73,static_cast<Word_Break>(0)},
{0x1ee74,Word_Break::ALetter},
{0x1ee78,static_cast<Word_Break>(0)},
{0x1ee79,Word_Break::ALetter},
{0x1ee7d,static_cast<Word_Break>(0)},
{0x1ee7e,Word_Break::ALetter},
{0x1ee7f,static_cast<Word_Break>(0)},
{0x1ee80,Word_Break::ALetter},
{0x1ee8a,static_cast<Word_Break>(0)},
{0x1ee8b,Word_Break::ALetter},
{0x1ee9c,static_cast<Word_Break>(0)},
{0x1eea1,Word_Break::ALetter},
{0x1eea4,static_cast<Word_Break>(0)},
{0x1eea5,Word_Break::ALetter},
{0x1eeaa,static_cast<Word_Break>(0)},
{0x1eeab,Word_Break::ALetter},
{0x1eebc,static_cast<Word_Break>(0)},
{0x1f130,Word_Break::ALetter},
{0x1f14a,static_cast<Word_Break>(0)},
{0x1f150,Word_Break::ALetter},
{0x1f16a,static_cast<Word_Break>(0)},
{0x1f170,Word_Break::ALetter},
{0x1f18a,static_cast<Word_Break>(0)},
{0x1f1e6,Word_Break::Regional_Indicator},
{0x1f200,static_cast<Word_Break>(0)},
{0xe0001,Word_Break::Format},
{0xe0002,static_cast<Word_Break>(0)},
{0xe0020,Word_Break::Format},
{0xe0080,static_cast<Word_Break>(0)},
{0xe0100,Word_Break::Extend},
{0xe01f0,static_cast<Word_Break>(0)},
}};

const TableView<char32_t, Word_Break> word_break_table {&word_break_array[0], &word_break_array[0] + word_break_array.size()};

const std::array<KeyValue<char32_t, Numeric_Type>, 393> numeric_type_array = {{
{0x0,static_cast<Numeric_Type>(0)},
{0x30,Numeric_Type::Decimal},
{0x3a,static_cast<Numeric_Type>(0)},
{0xb2,Numeric_Type::Digit},
{0xb4,static_cast<Numeric_Type>(0)},
{0xb9,Numeric_Type::Digit},
{0xba,static_cast<Numeric_Type>(0)},
{0xbc,Numeric_Type::Numeric},
{0xbf,static_cast<Numeric_Type>(0)},
{0x660,Numeric_Type::Decimal},
{0x66a,static_cast<Numeric_Type>(0)},
{0x6f0,Numeric_Type::Decimal},
{0x6fa,static_cast<Numeric_Type>(0)},
{0x7c0,Numeric_Type::Decimal},
{0x7ca,static_cast<Numeric_Type>(0)},
{0x966,Numeric_Type::Decimal},
{0x970,static_cast<Numeric_Type>(0)},
{0x9e6,Numeric_Type::Decimal},
{0x9f0,static_cast<Numeric_Type>(0)},
{0x9f4,Numeric_Type::Numeric},
{0x9fa,static_cast<Numeric_Type>(0)},
{0xa66,Numeric_Type::Decimal},
{0xa70,static_cast<Numeric_Type>(0)},
{0xae6,Numeric_Type::Decimal},
{0xaf0,static_cast<Numeric_Type>(0)},
{0xb66,Numeric_Type::Decimal},
{0xb70,static_cast<Numeric_Type>(0)},
{0xb72,Numeric_Type::Numeric},
{0xb78,static_cast<Numeric_Type>(0)},
{0xbe6,Numeric_Type::Decimal},
{0xbf0,Numeric_Type::Numeric},
{0xbf3,static_cast<Numeric_Type>(0)},
{0xc66,Numeric_Type::Decimal},
{0xc70,static_cast<Numeric_Type>(0)},
{0xc78,Numeric_Type::Numeric},
{0xc7f,static_cast<Numeric_Type>(0)},
{0xce6,Numeric_Type::Decimal},
{0xcf0,static_cast<Numeric_Type>(0)},
{0xd66,Numeric_Type::Decimal},
{0xd70,Numeric_Type::Numeric},
{0xd76,static_cast<Numeric_Type>(0)},
{0xde6,Numeric_Type::Decimal},
{0xdf0,static_cast<Numeric_Type>(0)},
{0xe50,Numeric_Type::Decimal},
{0xe5a,static_cast<Numeric_Type>(0)},
{0xed0,Numeric_Type::Decimal},
{0xeda,static_cast<Numeric_Type>(0)},
{0xf20,Numeric_Type::Decimal},
{0xf2a,Numeric_Type::Numeric},
{0xf34,static_cast<Numeric_Type>(0)},
{0x1040,Numeric_Type::Decimal},
{0x104a,static_cast<Numeric_Type>(0)},
{0x1090,Numeric_Type::Decimal},
{0x109a,static_cast<Numeric_Type>(0)},
{0x1369,Numeric_Type::Digit},
{0x1372,Numeric_Type::Numeric},
{0x137d,static_cast<Numeric_Type>(0)},
{0x16ee,Numeric_Type::Numeric},
{0x16f1,static_cast<Numeric_Type>(0)},
{0x17e0,Numeric_Type::Decimal},
{0x17ea,static_cast<Numeric_Type>(0)},
{0x17f0,Numeric_Type::Numeric},
{0x17fa,static_cast<Numeric_Type>(0)},
{0x1810,Numeric_Type::Decimal},
{0x181a,static_cast<Numeric_Type>(0)},
{0x1946,Numeric_Type::Decimal},
{0x1950,static_cast<Numeric_Type>(0)},
{0x19d0,Numeric_Type::Decimal},
{0x19da,Numeric_Type::Digit},
{0x19db,static_cast<Numeric_Type>(0)},
{0x1a80,Numeric_Type::Decimal},
{0x1a8a,static_cast<Numeric_Type>(0)},
{0x1a90,Numeric_Type::Decimal},
{0x1a9a,static_cast<Numeric_Type>(0)},
{0x1b50,Numeric_Type::Decimal},
{0x1b5a,static_cast<Numeric_Type>(0)},
{0x1bb0,Numeric_Type::Decimal},
{0x1bba,static_cast<Numeric_Type>(0)},
{0x1c40,Numeric_Type::Decimal},
{0x1c4a,static_cast<Numeric_Type>(0)},
{0x1c50,Numeric_Type::Decimal},
{0x1c5a,static_cast<Numeric_Type>(0)},
{0x2070,Numeric_Type::Digit},
{0x2071,static_cast<Numeric_Type>(0)},
{0x2074,Numeric_Type::Digit},
{0x207a,static_cast<Numeric_Type>(0)},
{0x2080,Numeric_Type::Digit},
{0x208a,static_cast<Numeric_Type>(0)},
{0x2150,Numeric_Type::Numeric},
{0x2183,static_cast<Numeric_Type>(0)},
{0x2185,Numeric_Type::Numeric},
{0x218a,static_cast<Numeric_Type>(0)},
{0x2460,Numeric_Type::Digit},
{0x2469,Numeric_Type::Numeric},
{0x2474,Numeric_Type::Digit},
{0x247d,Numeric_Type::Numeric},
{0x2488,Numeric_Type::Digit},
{0x2491,Numeric_Type::Numeric},
{0x249c,static_cast<Numeric_Type>(0)},
{0x24ea,Numeric_Type::Digit},
{0x24eb,Numeric_Type::Numeric},
{0x24f5,Numeric_Type::Digit},
{0x24fe,Numeric_Type::Numeric},
{0x24ff,Numeric_Type::Digit},
{0x2500,static_cast<Numeric_Type>(0)},
{0x2776,Numeric_Type::Digit},
{0x277f,Numeric_Type::Numeric},
{0x2780,Numeric_Type::Digit},
{0x2789,Numeric_Type::Numeric},
{0x278a,Numeric_Type::Digit},
{0x2793,Numeric_Type::Numeric},
{0x2794,static_cast<Numeric_Type>(0)},
{0x2cfd,Numeric_Type::Numeric},
{0x2cfe,static_cast<Numeric_Type>(0)},
{0x3007,Numeric_Type::Numeric},
{0x3008,static_cast<Numeric_Type>(0)},
{0x3021,Numeric_Type::Numeric},
{0x302a,static_cast<Numeric_Type>(0)},
{0x3038,Numeric_Type::Numeric},
{0x303b,static_cast<Numeric_Type>(0)},
{0x3192,Numeric_Type::Numeric},
{0x3196,static_cast<Numeric_Type>(0)},
{0x3220,Numeric_Type::Numeric},
{0x322a,static_cast<Numeric_Type>(0)},
{0x3248,Numeric_Type::Numeric},
{0x3250,static_cast<Numeric_Type>(0)},
{0x3251,Numeric_Type::Numeric},
{0x3260,static_cast<Numeric_Type>(0)},
{0x3280,Numeric_Type::Numeric},
{0x328a,static_cast<Numeric_Type>(0)},
{0x32b1,Numeric_Type::Numeric},
{0x32c0,static_cast<Numeric_Type>(0)},
{0x3405,Numeric_Type::Numeric},
{0x3406,static_cast<Numeric_Type>(0)},
{0x3483,Numeric_Type::Numeric},
{0x3484,static_cast<Numeric_Type>(0)},
{0x382a,Numeric_Type::Numeric},
{0x382b,static_cast<Numeric_Type>(0)},
{0x3b4d,Numeric_Type::Numeric},
{0x3b4e,static_cast<Numeric_Type>(0)},
{0x4e00,Numeric_Type::Numeric},
{0x4e01,static_cast<Numeric_Type>(0)},
{0x4e03,Numeric_Type::Numeric},
{0x4e04,static_cast<Numeric_Type>(0)},
{0x4e07,Numeric_Type::Numeric},
{0x4e08,static_cast<Numeric_Type>(0)},
{0x4e09,Numeric_Type::Numeric},
{0x4e0a,static_cast<Numeric_Type>(0)},
{0x4e5d,Numeric_Type::Numeric},
{0x4e5e,static_cast<Numeric_Type>(0)},
{0x4e8c,Numeric_Type::Numeric},
{0x4e8d,static_cast<Numeric_Type>(0)},
{0x4e94,Numeric_Type::Numeric},
{0x4e95,static_cast<Numeric_Type>(0)},
{0x4e96,Numeric_Type::Numeric},
{0x4e97,static_cast<Numeric_Type>(0)},
{0x4ebf,Numeric_Type::Numeric},
{0x4ec1,static_cast<Numeric_Type>(0)},
{0x4edf,Numeric_Type::Numeric},
{0x4ee0,static_cast<Numeric_Type>(0)},
{0x4ee8,Numeric_Type::Numeric},
{0x4ee9,static_cast<Numeric_Type>(0)},
{0x4f0d,Numeric_Type::Numeric},
{0x4f0e,static_cast<Numeric_Type>(0)},
{0x4f70,Numeric_Type::Numeric},
{0x4f71,static_cast<Numeric_Type>(0)},
{0x5104,Numeric_Type::Numeric},
{0x5105,static_cast<Numeric_Type>(0)},
{0x5146,Numeric_Type::Numeric},
{0x5147,static_cast<Numeric_Type>(0)},
{0x5169,Numeric_Type::Numeric},
{0x516a,static_cast<Numeric_Type>(0)},
{0x516b,Numeric_Type::Numeric},
{0x516c,static_cast<Numeric_Type>(0)},
{0x516d,Numeric_Type::Numeric},
{0x516e,static_cast<Numeric_Type>(0)},
{0x5341,Numeric_Type::Numeric},
{0x5342,static_cast<Numeric_Type>(0)},
{0x5343,Numeric_Type::Numeric},
{0x5346,static_cast<Numeric_Type>(0)},
{0x534c,Numeric_Type::Numeric},
{0x534d,static_cast<Numeric_Type>(0)},
{0x53c1,Numeric_Type::Numeric},
{0x53c5,static_cast<Numeric_Type>(0)},
{0x56db,Numeric_Type::Numeric},
{0x56dc,static_cast<Numeric_Type>(0)},
{0x58f1,Numeric_Type::Numeric},
{0x58f2,static_cast<Numeric_Type>(0)},
{0x58f9,Numeric_Type::Numeric},
{0x58fa,static_cast<Numeric_Type>(0)},
{0x5e7a,Numeric_Type::Numeric},
{0x5e7b,static_cast<Numeric_Type>(0)},
{0x5efe,Numeric_Type::Numeric},
{0x5f00,static_cast<Numeric_Type>(0)},
{0x5f0c,Numeric_Type::Numeric},
{0x5f0f,static_cast<Numeric_Type>(0)},
{0x5f10,Numeric_Type::Numeric},
{0x5f11,static_cast<Numeric_Type>(0)},
{0x62fe,Numeric_Type::Numeric},
{0x62ff,static_cast<Numeric_Type>(0)},
{0x634c,Numeric_Type::Numeric},
{0x634d,static_cast<Numeric_Type>(0)},
{0x67d2,Numeric_Type::Numeric},
{0x67d3,static_cast<Numeric_Type>(0)},
{0x6f06,Numeric_Type::Numeric},
{0x6f07,static_cast<Numeric_Type>(0)},
{0x7396,Numeric_Type::Numeric},
{0x7397,static_cast<Numeric_Type>(0)},
{0x767e,Numeric_Type::Numeric},
{0x767f,static_cast<Numeric_Type>(0)},
{0x8086,Numeric_Type::Numeric},
{0x8087,static_cast<Numeric_Type>(0)},
{0x842c,Numeric_Type::Numeric},
{0x842d,static_cast<Numeric_Type>(0)},
{0x8cae,Numeric_Type::Numeric},
{0x8caf,static_cast<Numeric_Type>(0)},
{0x8cb3,Numeric_Type::Numeric},
{0x8cb4,static_cast<Numeric_Type>(0)},
{0x8d30,Numeric_Type::Numeric},
{0x8d31,static_cast<Numeric_Type>(0)},
{0x9621,Numeric_Type::Numeric},
{0x9622,static_cast<Numeric_Type>(0)},
{0x9646,Numeric_Type::Numeric},
{0x9647,static_cast<Numeric_Type>(0)},
{0x964c,Numeric_Type::Numeric},
{0x964d,static_cast<Numeric_Type>(0)},
{0x9678,Numeric_Type::Numeric},
{0x9679,static_cast<Numeric_Type>(0)},
{0x96f6,Numeric_Type::Numeric},
{0x96f7,static_cast<Numeric_Type>(0)},
{0xa620,Numeric_Type::Decimal},
{0xa62a,static_cast<Numeric_Type>(0)},
{0xa6e6,Numeric_Type::Numeric},
{0xa6f0,static_cast<Numeric_Type>(0)},
{0xa830,Numeric_Type::Numeric},
{0xa836,static_cast<Numeric_Type>(0)},
{0xa8d0,Numeric_Type::Decimal},
{0xa8da,static_cast<Numeric_Type>(0)},
{0xa900,Numeric_Type::Decimal},
{0xa90a,static_cast<Numeric_Type>(0)},
{0xa9d0,Numeric_Type::Decimal},
{0xa9da,static_cast<Numeric_Type>(0)},
{0xa9f0,Numeric_Type::Decimal},
{0xa9fa,static_cast<Numeric_Type>(0)},
{0xaa50,Numeric_Type::Decimal},
{0xaa5a,static_cast<Numeric_Type>(0)},
{0xabf0,Numeric_Type::Decimal},
{0xabfa,static_cast<Numeric_Type>(0)},
{0xf96b,Numeric_Type::Numeric},
{0xf96c,static_cast<Numeric_Type>(0)},
{0xf973,Numeric_Type::Numeric},
{0xf974,static_cast<Numeric_Type>(0)},
{0xf978,Numeric_Type::Numeric},
{0xf979,static_cast<Numeric_Type>(0)},
{0xf9b2,Numeric_Type::Numeric},
{0xf9b3,static_cast<Numeric_Type>(0)},
{0xf9d1,Numeric_Type::Numeric},
{0xf9d2,static_cast<Numeric_Type>(0)},
{0xf9d3,Numeric_Type::Numeric},
{0xf9d4,static_cast<Numeric_Type>(0)},
{0xf9fd,Numeric_Type::Numeric},
{0xf9fe,static_cast<Numeric_Type>(0)},
{0xff10,Numeric_Type::Decimal},
{0xff1a,static_cast<Numeric_Type>(0)},
{0x10107,Numeric_Type::Numeric},
{0x10134,static_cast<Numeric_Type>(0)},
{0x10140,Numeric_Type::Numeric},
{0x10179,static_cast<Numeric_Type>(0)},
{0x1018a,Numeric_Type::Numeric},
{0x1018c,static_cast<Numeric_Type>(0)},
{0x102e1,Numeric_Type::Numeric},
{0x102fc,static_cast<Numeric_Type>(0)},
{0x10320,Numeric_Type::Numeric},
{0x10324,static_cast<Numeric_Type>(0)},
{0x10341,Numeric_Type::Numeric},
{0x10342,static_cast<Numeric_Type>(0)},
{0x1034a,Numeric_Type::Numeric},
{0x1034b,static_cast<Numeric_Type>(0)},
{0x103d1,Numeric_Type::Numeric},
{0x103d6,static_cast<Numeric_Type>(0)},
{0x104a0,Numeric_Type::Decimal},
{0x104aa,static_cast<Numeric_Type>(0)},
{0x10858,Numeric_Type::Numeric},
{0x10860,static_cast<Numeric_Type>(0)},
{0x10879,Numeric_Type::Numeric},
{0x10880,static_cast<Numeric_Type>(0)},
{0x108a7,Numeric_Type::Numeric},
{0x108b0,static_cast<Numeric_Type>(0)},
{0x108fb,Numeric_Type::Numeric},
{0x10900,static_cast<Numeric_Type>(0)},
{0x10916,Numeric_Type::Numeric},
{0x1091c,static_cast<Numeric_Type>(0)},
{0x109bc,Numeric_Type::Numeric},
{0x109be,static_cast<Numeric_Type>(0)},
{0x109c0,Numeric_Type::Numeric},
{0x109d0,static_cast<Numeric_Type>(0)},
{0x109d2,Numeric_Type::Numeric},
{0x10a00,static_cast<Numeric_Type>(0)},
{0x10a40,Numeric_Type::Digit},
{0x10a44,Numeric_Type::Numeric},
{0x10a48,static_cast<Numeric_Type>(0)},
{0x10a7d,Numeric_Type::Numeric},
{0x10a7f,static_cast<Numeric_Type>(0)},
{0x10a9d,Numeric_Type::Numeric},
{0x10aa0,static_cast<Numeric_Type>(0)},
{0x10aeb,Numeric_Type::Numeric},
{0x10af0,static_cast<Numeric_Type>(0)},
{0x10b58,Numeric_Type::Numeric},
{0x10b60,static_cast<Numeric_Type>(0)},
{0x10b78,Numeric_Type::Numeric},
{0x10b80,static_cast<Numeric_Type>(0)},
{0x10ba9,Numeric_Type::Numeric},
{0x10bb0,static_cast<Numeric_Type>(0)},
{0x10cfa,Numeric_Type::Numeric},
{0x10d00,static_cast<Numeric_Type>(0)},
{0x10e60,Numeric_Type::Digit},
{0x10e69,Numeric_Type::Numeric},
{0x10e7f,static_cast<Numeric_Type>(0)},
{0x11052,Numeric_Type::Digit},
{0x1105b,Numeric_Type::Numeric},
{0x11066,Numeric_Type::Decimal},
{0x11070,static_cast<Numeric_Type>(0)},
{0x110f0,Numeric_Type::Decimal},
{0x110fa,static_cast<Numeric_Type>(0)},
{0x11136,Numeric_Type::Decimal},
{0x11140,static_cast<Numeric_Type>(0)},
{0x111d0,Numeric_Type::Decimal},
{0x111da,static_cast<Numeric_Type>(0)},
{0x111e1,Numeric_Type::Numeric},
{0x111f5,static_cast<Numeric_Type>(0)},
{0x112f0,Numeric_Type::Decimal},
{0x112fa,static_cast<Numeric_Type>(0)},
{0x114d0,Numeric_Type::Decimal},
{0x114da,static_cast<Numeric_Type>(0)},
{0x11650,Numeric_Type::Decimal},
{0x1165a,static_cast<Numeric_Type>(0)},
{0x116c0,Numeric_Type::Decimal},
{0x116ca,static_cast<Numeric_Type>(0)},
{0x11730,Numeric_Type::Decimal},
{0x1173a,Numeric_Type::Numeric},
{0x1173c,static_cast<Numeric_Type>(0)},
{0x118e0,Numeric_Type::Decimal},
{0x118ea,Numeric_Type::Numeric},
{0x118f3,static_cast<Numeric_Type>(0)},
{0x12400,Numeric_Type::Numeric},
{0x1246f,static_cast<Numeric_Type>(0)},
{0x16a60,Numeric_Type::Decimal},
{0x16a6a,static_cast<Numeric_Type>(0)},
{0x16b50,Numeric_Type::Decimal},
{0x16b5a,static_cast<Numeric_Type>(0)},
{0x16b5b,Numeric_Type::Numeric},
{0x16b62,static_cast<Numeric_Type>(0)},
{0x1d360,Numeric_Type::Numeric},
{0x1d372,static_cast<Numeric_Type>(0)},
{0x1d7ce,Numeric_Type::Decimal},
{0x1d800,static_cast<Numeric_Type>(0)},
{0x1e8c7,Numeric_Type::Numeric},
{0x1e8d0,static_cast<Numeric_Type>(0)},
{0x1f100,Numeric_Type::Digit},
{0x1f10b,Numeric_Type::Numeric},
{0x1f10d,static_cast<Numeric_Type>(0)},
{0x20001,Numeric_Type::Numeric},
{0x20002,static_cast<Numeric_Type>(0)},
{0x20064,Numeric_Type::Numeric},
{0x20065,static_cast<Numeric_Type>(0)},
{0x200e2,Numeric_Type::Numeric},
{0x200e3,static_cast<Numeric_Type>(0)},
{0x20121,Numeric_Type::Numeric},
{0x20122,static_cast<Numeric_Type>(0)},
{0x2092a,Numeric_Type::Numeric},
{0x2092b,static_cast<Numeric_Type>(0)},
{0x20983,Numeric_Type::Numeric},
{0x20984,static_cast<Numeric_Type>(0)},
{0x2098c,Numeric_Type::Numeric},
{0x2098d,static_cast<Numeric_Type>(0)},
{0x2099c,Numeric_Type::Numeric},
{0x2099d,static_cast<Numeric_Type>(0)},
{0x20aea,Numeric_Type::Numeric},
{0x20aeb,static_cast<Numeric_Type>(0)},
{0x20afd,Numeric_Type::Numeric},
{0x20afe,static_cast<Numeric_Type>(0)},
{0x20b19,Numeric_Type::Numeric},
{0x20b1a,static_cast<Numeric_Type>(0)},
{0x22390,Numeric_Type::Numeric},
{0x22391,static_cast<Numeric_Type>(0)},
{0x22998,Numeric_Type::Numeric},
{0x22999,static_cast<Numeric_Type>(0)},
{0x23b1b,Numeric_Type::Numeric},
{0x23b1c,static_cast<Numeric_Type>(0)},
{0x2626d,Numeric_Type::Numeric},
{0x2626e,static_cast<Numeric_Type>(0)},
{0x2f890,Numeric_Type::Numeric},
{0x2f891,static_cast<Numeric_Type>(0)},
}};

const TableView<char32_t, Numeric_Type> numeric_type_table {&numeric_type_array[0], &numeric_type_array[0] + numeric_type_array.size()};

}
