#include "unicorn/ucd-tables.hpp"

namespace RS::Unicorn::UnicornDetail {

const std::array<KeyValue<char32_t, int>, 474> combining_class_array = {{
{0x0,0},
{0x300,230},
{0x315,232},
{0x316,220},
{0x31a,232},
{0x31b,216},
{0x31c,220},
{0x321,202},
{0x323,220},
{0x327,202},
{0x329,220},
{0x334,1},
{0x339,220},
{0x33d,230},
{0x345,240},
{0x346,230},
{0x347,220},
{0x34a,230},
{0x34d,220},
{0x34f,0},
{0x350,230},
{0x353,220},
{0x357,230},
{0x358,232},
{0x359,220},
{0x35b,230},
{0x35c,233},
{0x35d,234},
{0x35f,233},
{0x360,234},
{0x362,233},
{0x363,230},
{0x370,0},
{0x483,230},
{0x488,0},
{0x591,220},
{0x592,230},
{0x596,220},
{0x597,230},
{0x59a,222},
{0x59b,220},
{0x59c,230},
{0x5a2,220},
{0x5a8,230},
{0x5aa,220},
{0x5ab,230},
{0x5ad,222},
{0x5ae,228},
{0x5af,230},
{0x5b0,10},
{0x5b1,11},
{0x5b2,12},
{0x5b3,13},
{0x5b4,14},
{0x5b5,15},
{0x5b6,16},
{0x5b7,17},
{0x5b8,18},
{0x5b9,19},
{0x5bb,20},
{0x5bc,21},
{0x5bd,22},
{0x5be,0},
{0x5bf,23},
{0x5c0,0},
{0x5c1,24},
{0x5c2,25},
{0x5c3,0},
{0x5c4,230},
{0x5c5,220},
{0x5c6,0},
{0x5c7,18},
{0x5c8,0},
{0x610,230},
{0x618,30},
{0x619,31},
{0x61a,32},
{0x61b,0},
{0x64b,27},
{0x64c,28},
{0x64d,29},
{0x64e,30},
{0x64f,31},
{0x650,32},
{0x651,33},
{0x652,34},
{0x653,230},
{0x655,220},
{0x657,230},
{0x65c,220},
{0x65d,230},
{0x65f,220},
{0x660,0},
{0x670,35},
{0x671,0},
{0x6d6,230},
{0x6dd,0},
{0x6df,230},
{0x6e3,220},
{0x6e4,230},
{0x6e5,0},
{0x6e7,230},
{0x6e9,0},
{0x6ea,220},
{0x6eb,230},
{0x6ed,220},
{0x6ee,0},
{0x711,36},
{0x712,0},
{0x730,230},
{0x731,220},
{0x732,230},
{0x734,220},
{0x735,230},
{0x737,220},
{0x73a,230},
{0x73b,220},
{0x73d,230},
{0x73e,220},
{0x73f,230},
{0x742,220},
{0x743,230},
{0x744,220},
{0x745,230},
{0x746,220},
{0x747,230},
{0x748,220},
{0x749,230},
{0x74b,0},
{0x7eb,230},
{0x7f2,220},
{0x7f3,230},
{0x7f4,0},
{0x816,230},
{0x81a,0},
{0x81b,230},
{0x824,0},
{0x825,230},
{0x828,0},
{0x829,230},
{0x82e,0},
{0x859,220},
{0x85c,0},
{0x8e3,220},
{0x8e4,230},
{0x8e6,220},
{0x8e7,230},
{0x8e9,220},
{0x8ea,230},
{0x8ed,220},
{0x8f0,27},
{0x8f1,28},
{0x8f2,29},
{0x8f3,230},
{0x8f6,220},
{0x8f7,230},
{0x8f9,220},
{0x8fb,230},
{0x900,0},
{0x93c,7},
{0x93d,0},
{0x94d,9},
{0x94e,0},
{0x951,230},
{0x952,220},
{0x953,230},
{0x955,0},
{0x9bc,7},
{0x9bd,0},
{0x9cd,9},
{0x9ce,0},
{0xa3c,7},
{0xa3d,0},
{0xa4d,9},
{0xa4e,0},
{0xabc,7},
{0xabd,0},
{0xacd,9},
{0xace,0},
{0xb3c,7},
{0xb3d,0},
{0xb4d,9},
{0xb4e,0},
{0xbcd,9},
{0xbce,0},
{0xc4d,9},
{0xc4e,0},
{0xc55,84},
{0xc56,91},
{0xc57,0},
{0xcbc,7},
{0xcbd,0},
{0xccd,9},
{0xcce,0},
{0xd4d,9},
{0xd4e,0},
{0xdca,9},
{0xdcb,0},
{0xe38,103},
{0xe3a,9},
{0xe3b,0},
{0xe48,107},
{0xe4c,0},
{0xeb8,118},
{0xeba,0},
{0xec8,122},
{0xecc,0},
{0xf18,220},
{0xf1a,0},
{0xf35,220},
{0xf36,0},
{0xf37,220},
{0xf38,0},
{0xf39,216},
{0xf3a,0},
{0xf71,129},
{0xf72,130},
{0xf73,0},
{0xf74,132},
{0xf75,0},
{0xf7a,130},
{0xf7e,0},
{0xf80,130},
{0xf81,0},
{0xf82,230},
{0xf84,9},
{0xf85,0},
{0xf86,230},
{0xf88,0},
{0xfc6,220},
{0xfc7,0},
{0x1037,7},
{0x1038,0},
{0x1039,9},
{0x103b,0},
{0x108d,220},
{0x108e,0},
{0x135d,230},
{0x1360,0},
{0x1714,9},
{0x1715,0},
{0x1734,9},
{0x1735,0},
{0x17d2,9},
{0x17d3,0},
{0x17dd,230},
{0x17de,0},
{0x18a9,228},
{0x18aa,0},
{0x1939,222},
{0x193a,230},
{0x193b,220},
{0x193c,0},
{0x1a17,230},
{0x1a18,220},
{0x1a19,0},
{0x1a60,9},
{0x1a61,0},
{0x1a75,230},
{0x1a7d,0},
{0x1a7f,220},
{0x1a80,0},
{0x1ab0,230},
{0x1ab5,220},
{0x1abb,230},
{0x1abd,220},
{0x1abe,0},
{0x1b34,7},
{0x1b35,0},
{0x1b44,9},
{0x1b45,0},
{0x1b6b,230},
{0x1b6c,220},
{0x1b6d,230},
{0x1b74,0},
{0x1baa,9},
{0x1bac,0},
{0x1be6,7},
{0x1be7,0},
{0x1bf2,9},
{0x1bf4,0},
{0x1c37,7},
{0x1c38,0},
{0x1cd0,230},
{0x1cd3,0},
{0x1cd4,1},
{0x1cd5,220},
{0x1cda,230},
{0x1cdc,220},
{0x1ce0,230},
{0x1ce1,0},
{0x1ce2,1},
{0x1ce9,0},
{0x1ced,220},
{0x1cee,0},
{0x1cf4,230},
{0x1cf5,0},
{0x1cf8,230},
{0x1cfa,0},
{0x1dc0,230},
{0x1dc2,220},
{0x1dc3,230},
{0x1dca,220},
{0x1dcb,230},
{0x1dcd,234},
{0x1dce,214},
{0x1dcf,220},
{0x1dd0,202},
{0x1dd1,230},
{0x1df6,0},
{0x1dfc,233},
{0x1dfd,220},
{0x1dfe,230},
{0x1dff,220},
{0x1e00,0},
{0x20d0,230},
{0x20d2,1},
{0x20d4,230},
{0x20d8,1},
{0x20db,230},
{0x20dd,0},
{0x20e1,230},
{0x20e2,0},
{0x20e5,1},
{0x20e7,230},
{0x20e8,220},
{0x20e9,230},
{0x20ea,1},
{0x20ec,220},
{0x20f0,230},
{0x20f1,0},
{0x2cef,230},
{0x2cf2,0},
{0x2d7f,9},
{0x2d80,0},
{0x2de0,230},
{0x2e00,0},
{0x302a,218},
{0x302b,228},
{0x302c,232},
{0x302d,222},
{0x302e,224},
{0x3030,0},
{0x3099,8},
{0x309b,0},
{0xa66f,230},
{0xa670,0},
{0xa674,230},
{0xa67e,0},
{0xa69e,230},
{0xa6a0,0},
{0xa6f0,230},
{0xa6f2,0},
{0xa806,9},
{0xa807,0},
{0xa8c4,9},
{0xa8c5,0},
{0xa8e0,230},
{0xa8f2,0},
{0xa92b,220},
{0xa92e,0},
{0xa953,9},
{0xa954,0},
{0xa9b3,7},
{0xa9b4,0},
{0xa9c0,9},
{0xa9c1,0},
{0xaab0,230},
{0xaab1,0},
{0xaab2,230},
{0xaab4,220},
{0xaab5,0},
{0xaab7,230},
{0xaab9,0},
{0xaabe,230},
{0xaac0,0},
{0xaac1,230},
{0xaac2,0},
{0xaaf6,9},
{0xaaf7,0},
{0xabed,9},
{0xabee,0},
{0xfb1e,26},
{0xfb1f,0},
{0xfe20,230},
{0xfe27,220},
{0xfe2e,230},
{0xfe30,0},
{0x101fd,220},
{0x101fe,0},
{0x102e0,220},
{0x102e1,0},
{0x10376,230},
{0x1037b,0},
{0x10a0d,220},
{0x10a0e,0},
{0x10a0f,230},
{0x10a10,0},
{0x10a38,230},
{0x10a39,1},
{0x10a3a,220},
{0x10a3b,0},
{0x10a3f,9},
{0x10a40,0},
{0x10ae5,230},
{0x10ae6,220},
{0x10ae7,0},
{0x11046,9},
{0x11047,0},
{0x1107f,9},
{0x11080,0},
{0x110b9,9},
{0x110ba,7},
{0x110bb,0},
{0x11100,230},
{0x11103,0},
{0x11133,9},
{0x11135,0},
{0x11173,7},
{0x11174,0},
{0x111c0,9},
{0x111c1,0},
{0x111ca,7},
{0x111cb,0},
{0x11235,9},
{0x11236,7},
{0x11237,0},
{0x112e9,7},
{0x112ea,9},
{0x112eb,0},
{0x1133c,7},
{0x1133d,0},
{0x1134d,9},
{0x1134e,0},
{0x11366,230},
{0x1136d,0},
{0x11370,230},
{0x11375,0},
{0x114c2,9},
{0x114c3,7},
{0x114c4,0},
{0x115bf,9},
{0x115c0,7},
{0x115c1,0},
{0x1163f,9},
{0x11640,0},
{0x116b6,9},
{0x116b7,7},
{0x116b8,0},
{0x1172b,9},
{0x1172c,0},
{0x16af0,1},
{0x16af5,0},
{0x16b30,230},
{0x16b37,0},
{0x1bc9e,1},
{0x1bc9f,0},
{0x1d165,216},
{0x1d167,1},
{0x1d16a,0},
{0x1d16d,226},
{0x1d16e,216},
{0x1d173,0},
{0x1d17b,220},
{0x1d183,0},
{0x1d185,230},
{0x1d18a,220},
{0x1d18c,0},
{0x1d1aa,230},
{0x1d1ae,0},
{0x1d242,230},
{0x1d245,0},
{0x1e8d0,220},
{0x1e8d7,0},
}};

const TableView<char32_t, int> combining_class_table {&combining_class_array[0], &combining_class_array[0] + combining_class_array.size()};

const std::array<KeyValue<char32_t, std::array<char32_t, 2>>, 2060> canonical_array = {{
{0xc0,{{0x41,0x300}}},
{0xc1,{{0x41,0x301}}},
{0xc2,{{0x41,0x302}}},
{0xc3,{{0x41,0x303}}},
{0xc4,{{0x41,0x308}}},
{0xc5,{{0x41,0x30a}}},
{0xc7,{{0x43,0x327}}},
{0xc8,{{0x45,0x300}}},
{0xc9,{{0x45,0x301}}},
{0xca,{{0x45,0x302}}},
{0xcb,{{0x45,0x308}}},
{0xcc,{{0x49,0x300}}},
{0xcd,{{0x49,0x301}}},
{0xce,{{0x49,0x302}}},
{0xcf,{{0x49,0x308}}},
{0xd1,{{0x4e,0x303}}},
{0xd2,{{0x4f,0x300}}},
{0xd3,{{0x4f,0x301}}},
{0xd4,{{0x4f,0x302}}},
{0xd5,{{0x4f,0x303}}},
{0xd6,{{0x4f,0x308}}},
{0xd9,{{0x55,0x300}}},
{0xda,{{0x55,0x301}}},
{0xdb,{{0x55,0x302}}},
{0xdc,{{0x55,0x308}}},
{0xdd,{{0x59,0x301}}},
{0xe0,{{0x61,0x300}}},
{0xe1,{{0x61,0x301}}},
{0xe2,{{0x61,0x302}}},
{0xe3,{{0x61,0x303}}},
{0xe4,{{0x61,0x308}}},
{0xe5,{{0x61,0x30a}}},
{0xe7,{{0x63,0x327}}},
{0xe8,{{0x65,0x300}}},
{0xe9,{{0x65,0x301}}},
{0xea,{{0x65,0x302}}},
{0xeb,{{0x65,0x308}}},
{0xec,{{0x69,0x300}}},
{0xed,{{0x69,0x301}}},
{0xee,{{0x69,0x302}}},
{0xef,{{0x69,0x308}}},
{0xf1,{{0x6e,0x303}}},
{0xf2,{{0x6f,0x300}}},
{0xf3,{{0x6f,0x301}}},
{0xf4,{{0x6f,0x302}}},
{0xf5,{{0x6f,0x303}}},
{0xf6,{{0x6f,0x308}}},
{0xf9,{{0x75,0x300}}},
{0xfa,{{0x75,0x301}}},
{0xfb,{{0x75,0x302}}},
{0xfc,{{0x75,0x308}}},
{0xfd,{{0x79,0x301}}},
{0xff,{{0x79,0x308}}},
{0x100,{{0x41,0x304}}},
{0x101,{{0x61,0x304}}},
{0x102,{{0x41,0x306}}},
{0x103,{{0x61,0x306}}},
{0x104,{{0x41,0x328}}},
{0x105,{{0x61,0x328}}},
{0x106,{{0x43,0x301}}},
{0x107,{{0x63,0x301}}},
{0x108,{{0x43,0x302}}},
{0x109,{{0x63,0x302}}},
{0x10a,{{0x43,0x307}}},
{0x10b,{{0x63,0x307}}},
{0x10c,{{0x43,0x30c}}},
{0x10d,{{0x63,0x30c}}},
{0x10e,{{0x44,0x30c}}},
{0x10f,{{0x64,0x30c}}},
{0x112,{{0x45,0x304}}},
{0x113,{{0x65,0x304}}},
{0x114,{{0x45,0x306}}},
{0x115,{{0x65,0x306}}},
{0x116,{{0x45,0x307}}},
{0x117,{{0x65,0x307}}},
{0x118,{{0x45,0x328}}},
{0x119,{{0x65,0x328}}},
{0x11a,{{0x45,0x30c}}},
{0x11b,{{0x65,0x30c}}},
{0x11c,{{0x47,0x302}}},
{0x11d,{{0x67,0x302}}},
{0x11e,{{0x47,0x306}}},
{0x11f,{{0x67,0x306}}},
{0x120,{{0x47,0x307}}},
{0x121,{{0x67,0x307}}},
{0x122,{{0x47,0x327}}},
{0x123,{{0x67,0x327}}},
{0x124,{{0x48,0x302}}},
{0x125,{{0x68,0x302}}},
{0x128,{{0x49,0x303}}},
{0x129,{{0x69,0x303}}},
{0x12a,{{0x49,0x304}}},
{0x12b,{{0x69,0x304}}},
{0x12c,{{0x49,0x306}}},
{0x12d,{{0x69,0x306}}},
{0x12e,{{0x49,0x328}}},
{0x12f,{{0x69,0x328}}},
{0x130,{{0x49,0x307}}},
{0x134,{{0x4a,0x302}}},
{0x135,{{0x6a,0x302}}},
{0x136,{{0x4b,0x327}}},
{0x137,{{0x6b,0x327}}},
{0x139,{{0x4c,0x301}}},
{0x13a,{{0x6c,0x301}}},
{0x13b,{{0x4c,0x327}}},
{0x13c,{{0x6c,0x327}}},
{0x13d,{{0x4c,0x30c}}},
{0x13e,{{0x6c,0x30c}}},
{0x143,{{0x4e,0x301}}},
{0x144,{{0x6e,0x301}}},
{0x145,{{0x4e,0x327}}},
{0x146,{{0x6e,0x327}}},
{0x147,{{0x4e,0x30c}}},
{0x148,{{0x6e,0x30c}}},
{0x14c,{{0x4f,0x304}}},
{0x14d,{{0x6f,0x304}}},
{0x14e,{{0x4f,0x306}}},
{0x14f,{{0x6f,0x306}}},
{0x150,{{0x4f,0x30b}}},
{0x151,{{0x6f,0x30b}}},
{0x154,{{0x52,0x301}}},
{0x155,{{0x72,0x301}}},
{0x156,{{0x52,0x327}}},
{0x157,{{0x72,0x327}}},
{0x158,{{0x52,0x30c}}},
{0x159,{{0x72,0x30c}}},
{0x15a,{{0x53,0x301}}},
{0x15b,{{0x73,0x301}}},
{0x15c,{{0x53,0x302}}},
{0x15d,{{0x73,0x302}}},
{0x15e,{{0x53,0x327}}},
{0x15f,{{0x73,0x327}}},
{0x160,{{0x53,0x30c}}},
{0x161,{{0x73,0x30c}}},
{0x162,{{0x54,0x327}}},
{0x163,{{0x74,0x327}}},
{0x164,{{0x54,0x30c}}},
{0x165,{{0x74,0x30c}}},
{0x168,{{0x55,0x303}}},
{0x169,{{0x75,0x303}}},
{0x16a,{{0x55,0x304}}},
{0x16b,{{0x75,0x304}}},
{0x16c,{{0x55,0x306}}},
{0x16d,{{0x75,0x306}}},
{0x16e,{{0x55,0x30a}}},
{0x16f,{{0x75,0x30a}}},
{0x170,{{0x55,0x30b}}},
{0x171,{{0x75,0x30b}}},
{0x172,{{0x55,0x328}}},
{0x173,{{0x75,0x328}}},
{0x174,{{0x57,0x302}}},
{0x175,{{0x77,0x302}}},
{0x176,{{0x59,0x302}}},
{0x177,{{0x79,0x302}}},
{0x178,{{0x59,0x308}}},
{0x179,{{0x5a,0x301}}},
{0x17a,{{0x7a,0x301}}},
{0x17b,{{0x5a,0x307}}},
{0x17c,{{0x7a,0x307}}},
{0x17d,{{0x5a,0x30c}}},
{0x17e,{{0x7a,0x30c}}},
{0x1a0,{{0x4f,0x31b}}},
{0x1a1,{{0x6f,0x31b}}},
{0x1af,{{0x55,0x31b}}},
{0x1b0,{{0x75,0x31b}}},
{0x1cd,{{0x41,0x30c}}},
{0x1ce,{{0x61,0x30c}}},
{0x1cf,{{0x49,0x30c}}},
{0x1d0,{{0x69,0x30c}}},
{0x1d1,{{0x4f,0x30c}}},
{0x1d2,{{0x6f,0x30c}}},
{0x1d3,{{0x55,0x30c}}},
{0x1d4,{{0x75,0x30c}}},
{0x1d5,{{0xdc,0x304}}},
{0x1d6,{{0xfc,0x304}}},
{0x1d7,{{0xdc,0x301}}},
{0x1d8,{{0xfc,0x301}}},
{0x1d9,{{0xdc,0x30c}}},
{0x1da,{{0xfc,0x30c}}},
{0x1db,{{0xdc,0x300}}},
{0x1dc,{{0xfc,0x300}}},
{0x1de,{{0xc4,0x304}}},
{0x1df,{{0xe4,0x304}}},
{0x1e0,{{0x226,0x304}}},
{0x1e1,{{0x227,0x304}}},
{0x1e2,{{0xc6,0x304}}},
{0x1e3,{{0xe6,0x304}}},
{0x1e6,{{0x47,0x30c}}},
{0x1e7,{{0x67,0x30c}}},
{0x1e8,{{0x4b,0x30c}}},
{0x1e9,{{0x6b,0x30c}}},
{0x1ea,{{0x4f,0x328}}},
{0x1eb,{{0x6f,0x328}}},
{0x1ec,{{0x1ea,0x304}}},
{0x1ed,{{0x1eb,0x304}}},
{0x1ee,{{0x1b7,0x30c}}},
{0x1ef,{{0x292,0x30c}}},
{0x1f0,{{0x6a,0x30c}}},
{0x1f4,{{0x47,0x301}}},
{0x1f5,{{0x67,0x301}}},
{0x1f8,{{0x4e,0x300}}},
{0x1f9,{{0x6e,0x300}}},
{0x1fa,{{0xc5,0x301}}},
{0x1fb,{{0xe5,0x301}}},
{0x1fc,{{0xc6,0x301}}},
{0x1fd,{{0xe6,0x301}}},
{0x1fe,{{0xd8,0x301}}},
{0x1ff,{{0xf8,0x301}}},
{0x200,{{0x41,0x30f}}},
{0x201,{{0x61,0x30f}}},
{0x202,{{0x41,0x311}}},
{0x203,{{0x61,0x311}}},
{0x204,{{0x45,0x30f}}},
{0x205,{{0x65,0x30f}}},
{0x206,{{0x45,0x311}}},
{0x207,{{0x65,0x311}}},
{0x208,{{0x49,0x30f}}},
{0x209,{{0x69,0x30f}}},
{0x20a,{{0x49,0x311}}},
{0x20b,{{0x69,0x311}}},
{0x20c,{{0x4f,0x30f}}},
{0x20d,{{0x6f,0x30f}}},
{0x20e,{{0x4f,0x311}}},
{0x20f,{{0x6f,0x311}}},
{0x210,{{0x52,0x30f}}},
{0x211,{{0x72,0x30f}}},
{0x212,{{0x52,0x311}}},
{0x213,{{0x72,0x311}}},
{0x214,{{0x55,0x30f}}},
{0x215,{{0x75,0x30f}}},
{0x216,{{0x55,0x311}}},
{0x217,{{0x75,0x311}}},
{0x218,{{0x53,0x326}}},
{0x219,{{0x73,0x326}}},
{0x21a,{{0x54,0x326}}},
{0x21b,{{0x74,0x326}}},
{0x21e,{{0x48,0x30c}}},
{0x21f,{{0x68,0x30c}}},
{0x226,{{0x41,0x307}}},
{0x227,{{0x61,0x307}}},
{0x228,{{0x45,0x327}}},
{0x229,{{0x65,0x327}}},
{0x22a,{{0xd6,0x304}}},
{0x22b,{{0xf6,0x304}}},
{0x22c,{{0xd5,0x304}}},
{0x22d,{{0xf5,0x304}}},
{0x22e,{{0x4f,0x307}}},
{0x22f,{{0x6f,0x307}}},
{0x230,{{0x22e,0x304}}},
{0x231,{{0x22f,0x304}}},
{0x232,{{0x59,0x304}}},
{0x233,{{0x79,0x304}}},
{0x340,{{0x300,0x0}}},
{0x341,{{0x301,0x0}}},
{0x343,{{0x313,0x0}}},
{0x344,{{0x308,0x301}}},
{0x374,{{0x2b9,0x0}}},
{0x37e,{{0x3b,0x0}}},
{0x385,{{0xa8,0x301}}},
{0x386,{{0x391,0x301}}},
{0x387,{{0xb7,0x0}}},
{0x388,{{0x395,0x301}}},
{0x389,{{0x397,0x301}}},
{0x38a,{{0x399,0x301}}},
{0x38c,{{0x39f,0x301}}},
{0x38e,{{0x3a5,0x301}}},
{0x38f,{{0x3a9,0x301}}},
{0x390,{{0x3ca,0x301}}},
{0x3aa,{{0x399,0x308}}},
{0x3ab,{{0x3a5,0x308}}},
{0x3ac,{{0x3b1,0x301}}},
{0x3ad,{{0x3b5,0x301}}},
{0x3ae,{{0x3b7,0x301}}},
{0x3af,{{0x3b9,0x301}}},
{0x3b0,{{0x3cb,0x301}}},
{0x3ca,{{0x3b9,0x308}}},
{0x3cb,{{0x3c5,0x308}}},
{0x3cc,{{0x3bf,0x301}}},
{0x3cd,{{0x3c5,0x301}}},
{0x3ce,{{0x3c9,0x301}}},
{0x3d3,{{0x3d2,0x301}}},
{0x3d4,{{0x3d2,0x308}}},
{0x400,{{0x415,0x300}}},
{0x401,{{0x415,0x308}}},
{0x403,{{0x413,0x301}}},
{0x407,{{0x406,0x308}}},
{0x40c,{{0x41a,0x301}}},
{0x40d,{{0x418,0x300}}},
{0x40e,{{0x423,0x306}}},
{0x419,{{0x418,0x306}}},
{0x439,{{0x438,0x306}}},
{0x450,{{0x435,0x300}}},
{0x451,{{0x435,0x308}}},
{0x453,{{0x433,0x301}}},
{0x457,{{0x456,0x308}}},
{0x45c,{{0x43a,0x301}}},
{0x45d,{{0x438,0x300}}},
{0x45e,{{0x443,0x306}}},
{0x476,{{0x474,0x30f}}},
{0x477,{{0x475,0x30f}}},
{0x4c1,{{0x416,0x306}}},
{0x4c2,{{0x436,0x306}}},
{0x4d0,{{0x410,0x306}}},
{0x4d1,{{0x430,0x306}}},
{0x4d2,{{0x410,0x308}}},
{0x4d3,{{0x430,0x308}}},
{0x4d6,{{0x415,0x306}}},
{0x4d7,{{0x435,0x306}}},
{0x4da,{{0x4d8,0x308}}},
{0x4db,{{0x4d9,0x308}}},
{0x4dc,{{0x416,0x308}}},
{0x4dd,{{0x436,0x308}}},
{0x4de,{{0x417,0x308}}},
{0x4df,{{0x437,0x308}}},
{0x4e2,{{0x418,0x304}}},
{0x4e3,{{0x438,0x304}}},
{0x4e4,{{0x418,0x308}}},
{0x4e5,{{0x438,0x308}}},
{0x4e6,{{0x41e,0x308}}},
{0x4e7,{{0x43e,0x308}}},
{0x4ea,{{0x4e8,0x308}}},
{0x4eb,{{0x4e9,0x308}}},
{0x4ec,{{0x42d,0x308}}},
{0x4ed,{{0x44d,0x308}}},
{0x4ee,{{0x423,0x304}}},
{0x4ef,{{0x443,0x304}}},
{0x4f0,{{0x423,0x308}}},
{0x4f1,{{0x443,0x308}}},
{0x4f2,{{0x423,0x30b}}},
{0x4f3,{{0x443,0x30b}}},
{0x4f4,{{0x427,0x308}}},
{0x4f5,{{0x447,0x308}}},
{0x4f8,{{0x42b,0x308}}},
{0x4f9,{{0x44b,0x308}}},
{0x622,{{0x627,0x653}}},
{0x623,{{0x627,0x654}}},
{0x624,{{0x648,0x654}}},
{0x625,{{0x627,0x655}}},
{0x626,{{0x64a,0x654}}},
{0x6c0,{{0x6d5,0x654}}},
{0x6c2,{{0x6c1,0x654}}},
{0x6d3,{{0x6d2,0x654}}},
{0x929,{{0x928,0x93c}}},
{0x931,{{0x930,0x93c}}},
{0x934,{{0x933,0x93c}}},
{0x958,{{0x915,0x93c}}},
{0x959,{{0x916,0x93c}}},
{0x95a,{{0x917,0x93c}}},
{0x95b,{{0x91c,0x93c}}},
{0x95c,{{0x921,0x93c}}},
{0x95d,{{0x922,0x93c}}},
{0x95e,{{0x92b,0x93c}}},
{0x95f,{{0x92f,0x93c}}},
{0x9cb,{{0x9c7,0x9be}}},
{0x9cc,{{0x9c7,0x9d7}}},
{0x9dc,{{0x9a1,0x9bc}}},
{0x9dd,{{0x9a2,0x9bc}}},
{0x9df,{{0x9af,0x9bc}}},
{0xa33,{{0xa32,0xa3c}}},
{0xa36,{{0xa38,0xa3c}}},
{0xa59,{{0xa16,0xa3c}}},
{0xa5a,{{0xa17,0xa3c}}},
{0xa5b,{{0xa1c,0xa3c}}},
{0xa5e,{{0xa2b,0xa3c}}},
{0xb48,{{0xb47,0xb56}}},
{0xb4b,{{0xb47,0xb3e}}},
{0xb4c,{{0xb47,0xb57}}},
{0xb5c,{{0xb21,0xb3c}}},
{0xb5d,{{0xb22,0xb3c}}},
{0xb94,{{0xb92,0xbd7}}},
{0xbca,{{0xbc6,0xbbe}}},
{0xbcb,{{0xbc7,0xbbe}}},
{0xbcc,{{0xbc6,0xbd7}}},
{0xc48,{{0xc46,0xc56}}},
{0xcc0,{{0xcbf,0xcd5}}},
{0xcc7,{{0xcc6,0xcd5}}},
{0xcc8,{{0xcc6,0xcd6}}},
{0xcca,{{0xcc6,0xcc2}}},
{0xccb,{{0xcca,0xcd5}}},
{0xd4a,{{0xd46,0xd3e}}},
{0xd4b,{{0xd47,0xd3e}}},
{0xd4c,{{0xd46,0xd57}}},
{0xdda,{{0xdd9,0xdca}}},
{0xddc,{{0xdd9,0xdcf}}},
{0xddd,{{0xddc,0xdca}}},
{0xdde,{{0xdd9,0xddf}}},
{0xf43,{{0xf42,0xfb7}}},
{0xf4d,{{0xf4c,0xfb7}}},
{0xf52,{{0xf51,0xfb7}}},
{0xf57,{{0xf56,0xfb7}}},
{0xf5c,{{0xf5b,0xfb7}}},
{0xf69,{{0xf40,0xfb5}}},
{0xf73,{{0xf71,0xf72}}},
{0xf75,{{0xf71,0xf74}}},
{0xf76,{{0xfb2,0xf80}}},
{0xf78,{{0xfb3,0xf80}}},
{0xf81,{{0xf71,0xf80}}},
{0xf93,{{0xf92,0xfb7}}},
{0xf9d,{{0xf9c,0xfb7}}},
{0xfa2,{{0xfa1,0xfb7}}},
{0xfa7,{{0xfa6,0xfb7}}},
{0xfac,{{0xfab,0xfb7}}},
{0xfb9,{{0xf90,0xfb5}}},
{0x1026,{{0x1025,0x102e}}},
{0x1b06,{{0x1b05,0x1b35}}},
{0x1b08,{{0x1b07,0x1b35}}},
{0x1b0a,{{0x1b09,0x1b35}}},
{0x1b0c,{{0x1b0b,0x1b35}}},
{0x1b0e,{{0x1b0d,0x1b35}}},
{0x1b12,{{0x1b11,0x1b35}}},
{0x1b3b,{{0x1b3a,0x1b35}}},
{0x1b3d,{{0x1b3c,0x1b35}}},
{0x1b40,{{0x1b3e,0x1b35}}},
{0x1b41,{{0x1b3f,0x1b35}}},
{0x1b43,{{0x1b42,0x1b35}}},
{0x1e00,{{0x41,0x325}}},
{0x1e01,{{0x61,0x325}}},
{0x1e02,{{0x42,0x307}}},
{0x1e03,{{0x62,0x307}}},
{0x1e04,{{0x42,0x323}}},
{0x1e05,{{0x62,0x323}}},
{0x1e06,{{0x42,0x331}}},
{0x1e07,{{0x62,0x331}}},
{0x1e08,{{0xc7,0x301}}},
{0x1e09,{{0xe7,0x301}}},
{0x1e0a,{{0x44,0x307}}},
{0x1e0b,{{0x64,0x307}}},
{0x1e0c,{{0x44,0x323}}},
{0x1e0d,{{0x64,0x323}}},
{0x1e0e,{{0x44,0x331}}},
{0x1e0f,{{0x64,0x331}}},
{0x1e10,{{0x44,0x327}}},
{0x1e11,{{0x64,0x327}}},
{0x1e12,{{0x44,0x32d}}},
{0x1e13,{{0x64,0x32d}}},
{0x1e14,{{0x112,0x300}}},
{0x1e15,{{0x113,0x300}}},
{0x1e16,{{0x112,0x301}}},
{0x1e17,{{0x113,0x301}}},
{0x1e18,{{0x45,0x32d}}},
{0x1e19,{{0x65,0x32d}}},
{0x1e1a,{{0x45,0x330}}},
{0x1e1b,{{0x65,0x330}}},
{0x1e1c,{{0x228,0x306}}},
{0x1e1d,{{0x229,0x306}}},
{0x1e1e,{{0x46,0x307}}},
{0x1e1f,{{0x66,0x307}}},
{0x1e20,{{0x47,0x304}}},
{0x1e21,{{0x67,0x304}}},
{0x1e22,{{0x48,0x307}}},
{0x1e23,{{0x68,0x307}}},
{0x1e24,{{0x48,0x323}}},
{0x1e25,{{0x68,0x323}}},
{0x1e26,{{0x48,0x308}}},
{0x1e27,{{0x68,0x308}}},
{0x1e28,{{0x48,0x327}}},
{0x1e29,{{0x68,0x327}}},
{0x1e2a,{{0x48,0x32e}}},
{0x1e2b,{{0x68,0x32e}}},
{0x1e2c,{{0x49,0x330}}},
{0x1e2d,{{0x69,0x330}}},
{0x1e2e,{{0xcf,0x301}}},
{0x1e2f,{{0xef,0x301}}},
{0x1e30,{{0x4b,0x301}}},
{0x1e31,{{0x6b,0x301}}},
{0x1e32,{{0x4b,0x323}}},
{0x1e33,{{0x6b,0x323}}},
{0x1e34,{{0x4b,0x331}}},
{0x1e35,{{0x6b,0x331}}},
{0x1e36,{{0x4c,0x323}}},
{0x1e37,{{0x6c,0x323}}},
{0x1e38,{{0x1e36,0x304}}},
{0x1e39,{{0x1e37,0x304}}},
{0x1e3a,{{0x4c,0x331}}},
{0x1e3b,{{0x6c,0x331}}},
{0x1e3c,{{0x4c,0x32d}}},
{0x1e3d,{{0x6c,0x32d}}},
{0x1e3e,{{0x4d,0x301}}},
{0x1e3f,{{0x6d,0x301}}},
{0x1e40,{{0x4d,0x307}}},
{0x1e41,{{0x6d,0x307}}},
{0x1e42,{{0x4d,0x323}}},
{0x1e43,{{0x6d,0x323}}},
{0x1e44,{{0x4e,0x307}}},
{0x1e45,{{0x6e,0x307}}},
{0x1e46,{{0x4e,0x323}}},
{0x1e47,{{0x6e,0x323}}},
{0x1e48,{{0x4e,0x331}}},
{0x1e49,{{0x6e,0x331}}},
{0x1e4a,{{0x4e,0x32d}}},
{0x1e4b,{{0x6e,0x32d}}},
{0x1e4c,{{0xd5,0x301}}},
{0x1e4d,{{0xf5,0x301}}},
{0x1e4e,{{0xd5,0x308}}},
{0x1e4f,{{0xf5,0x308}}},
{0x1e50,{{0x14c,0x300}}},
{0x1e51,{{0x14d,0x300}}},
{0x1e52,{{0x14c,0x301}}},
{0x1e53,{{0x14d,0x301}}},
{0x1e54,{{0x50,0x301}}},
{0x1e55,{{0x70,0x301}}},
{0x1e56,{{0x50,0x307}}},
{0x1e57,{{0x70,0x307}}},
{0x1e58,{{0x52,0x307}}},
{0x1e59,{{0x72,0x307}}},
{0x1e5a,{{0x52,0x323}}},
{0x1e5b,{{0x72,0x323}}},
{0x1e5c,{{0x1e5a,0x304}}},
{0x1e5d,{{0x1e5b,0x304}}},
{0x1e5e,{{0x52,0x331}}},
{0x1e5f,{{0x72,0x331}}},
{0x1e60,{{0x53,0x307}}},
{0x1e61,{{0x73,0x307}}},
{0x1e62,{{0x53,0x323}}},
{0x1e63,{{0x73,0x323}}},
{0x1e64,{{0x15a,0x307}}},
{0x1e65,{{0x15b,0x307}}},
{0x1e66,{{0x160,0x307}}},
{0x1e67,{{0x161,0x307}}},
{0x1e68,{{0x1e62,0x307}}},
{0x1e69,{{0x1e63,0x307}}},
{0x1e6a,{{0x54,0x307}}},
{0x1e6b,{{0x74,0x307}}},
{0x1e6c,{{0x54,0x323}}},
{0x1e6d,{{0x74,0x323}}},
{0x1e6e,{{0x54,0x331}}},
{0x1e6f,{{0x74,0x331}}},
{0x1e70,{{0x54,0x32d}}},
{0x1e71,{{0x74,0x32d}}},
{0x1e72,{{0x55,0x324}}},
{0x1e73,{{0x75,0x324}}},
{0x1e74,{{0x55,0x330}}},
{0x1e75,{{0x75,0x330}}},
{0x1e76,{{0x55,0x32d}}},
{0x1e77,{{0x75,0x32d}}},
{0x1e78,{{0x168,0x301}}},
{0x1e79,{{0x169,0x301}}},
{0x1e7a,{{0x16a,0x308}}},
{0x1e7b,{{0x16b,0x308}}},
{0x1e7c,{{0x56,0x303}}},
{0x1e7d,{{0x76,0x303}}},
{0x1e7e,{{0x56,0x323}}},
{0x1e7f,{{0x76,0x323}}},
{0x1e80,{{0x57,0x300}}},
{0x1e81,{{0x77,0x300}}},
{0x1e82,{{0x57,0x301}}},
{0x1e83,{{0x77,0x301}}},
{0x1e84,{{0x57,0x308}}},
{0x1e85,{{0x77,0x308}}},
{0x1e86,{{0x57,0x307}}},
{0x1e87,{{0x77,0x307}}},
{0x1e88,{{0x57,0x323}}},
{0x1e89,{{0x77,0x323}}},
{0x1e8a,{{0x58,0x307}}},
{0x1e8b,{{0x78,0x307}}},
{0x1e8c,{{0x58,0x308}}},
{0x1e8d,{{0x78,0x308}}},
{0x1e8e,{{0x59,0x307}}},
{0x1e8f,{{0x79,0x307}}},
{0x1e90,{{0x5a,0x302}}},
{0x1e91,{{0x7a,0x302}}},
{0x1e92,{{0x5a,0x323}}},
{0x1e93,{{0x7a,0x323}}},
{0x1e94,{{0x5a,0x331}}},
{0x1e95,{{0x7a,0x331}}},
{0x1e96,{{0x68,0x331}}},
{0x1e97,{{0x74,0x308}}},
{0x1e98,{{0x77,0x30a}}},
{0x1e99,{{0x79,0x30a}}},
{0x1e9b,{{0x17f,0x307}}},
{0x1ea0,{{0x41,0x323}}},
{0x1ea1,{{0x61,0x323}}},
{0x1ea2,{{0x41,0x309}}},
{0x1ea3,{{0x61,0x309}}},
{0x1ea4,{{0xc2,0x301}}},
{0x1ea5,{{0xe2,0x301}}},
{0x1ea6,{{0xc2,0x300}}},
{0x1ea7,{{0xe2,0x300}}},
{0x1ea8,{{0xc2,0x309}}},
{0x1ea9,{{0xe2,0x309}}},
{0x1eaa,{{0xc2,0x303}}},
{0x1eab,{{0xe2,0x303}}},
{0x1eac,{{0x1ea0,0x302}}},
{0x1ead,{{0x1ea1,0x302}}},
{0x1eae,{{0x102,0x301}}},
{0x1eaf,{{0x103,0x301}}},
{0x1eb0,{{0x102,0x300}}},
{0x1eb1,{{0x103,0x300}}},
{0x1eb2,{{0x102,0x309}}},
{0x1eb3,{{0x103,0x309}}},
{0x1eb4,{{0x102,0x303}}},
{0x1eb5,{{0x103,0x303}}},
{0x1eb6,{{0x1ea0,0x306}}},
{0x1eb7,{{0x1ea1,0x306}}},
{0x1eb8,{{0x45,0x323}}},
{0x1eb9,{{0x65,0x323}}},
{0x1eba,{{0x45,0x309}}},
{0x1ebb,{{0x65,0x309}}},
{0x1ebc,{{0x45,0x303}}},
{0x1ebd,{{0x65,0x303}}},
{0x1ebe,{{0xca,0x301}}},
{0x1ebf,{{0xea,0x301}}},
{0x1ec0,{{0xca,0x300}}},
{0x1ec1,{{0xea,0x300}}},
{0x1ec2,{{0xca,0x309}}},
{0x1ec3,{{0xea,0x309}}},
{0x1ec4,{{0xca,0x303}}},
{0x1ec5,{{0xea,0x303}}},
{0x1ec6,{{0x1eb8,0x302}}},
{0x1ec7,{{0x1eb9,0x302}}},
{0x1ec8,{{0x49,0x309}}},
{0x1ec9,{{0x69,0x309}}},
{0x1eca,{{0x49,0x323}}},
{0x1ecb,{{0x69,0x323}}},
{0x1ecc,{{0x4f,0x323}}},
{0x1ecd,{{0x6f,0x323}}},
{0x1ece,{{0x4f,0x309}}},
{0x1ecf,{{0x6f,0x309}}},
{0x1ed0,{{0xd4,0x301}}},
{0x1ed1,{{0xf4,0x301}}},
{0x1ed2,{{0xd4,0x300}}},
{0x1ed3,{{0xf4,0x300}}},
{0x1ed4,{{0xd4,0x309}}},
{0x1ed5,{{0xf4,0x309}}},
{0x1ed6,{{0xd4,0x303}}},
{0x1ed7,{{0xf4,0x303}}},
{0x1ed8,{{0x1ecc,0x302}}},
{0x1ed9,{{0x1ecd,0x302}}},
{0x1eda,{{0x1a0,0x301}}},
{0x1edb,{{0x1a1,0x301}}},
{0x1edc,{{0x1a0,0x300}}},
{0x1edd,{{0x1a1,0x300}}},
{0x1ede,{{0x1a0,0x309}}},
{0x1edf,{{0x1a1,0x309}}},
{0x1ee0,{{0x1a0,0x303}}},
{0x1ee1,{{0x1a1,0x303}}},
{0x1ee2,{{0x1a0,0x323}}},
{0x1ee3,{{0x1a1,0x323}}},
{0x1ee4,{{0x55,0x323}}},
{0x1ee5,{{0x75,0x323}}},
{0x1ee6,{{0x55,0x309}}},
{0x1ee7,{{0x75,0x309}}},
{0x1ee8,{{0x1af,0x301}}},
{0x1ee9,{{0x1b0,0x301}}},
{0x1eea,{{0x1af,0x300}}},
{0x1eeb,{{0x1b0,0x300}}},
{0x1eec,{{0x1af,0x309}}},
{0x1eed,{{0x1b0,0x309}}},
{0x1eee,{{0x1af,0x303}}},
{0x1eef,{{0x1b0,0x303}}},
{0x1ef0,{{0x1af,0x323}}},
{0x1ef1,{{0x1b0,0x323}}},
{0x1ef2,{{0x59,0x300}}},
{0x1ef3,{{0x79,0x300}}},
{0x1ef4,{{0x59,0x323}}},
{0x1ef5,{{0x79,0x323}}},
{0x1ef6,{{0x59,0x309}}},
{0x1ef7,{{0x79,0x309}}},
{0x1ef8,{{0x59,0x303}}},
{0x1ef9,{{0x79,0x303}}},
{0x1f00,{{0x3b1,0x313}}},
{0x1f01,{{0x3b1,0x314}}},
{0x1f02,{{0x1f00,0x300}}},
{0x1f03,{{0x1f01,0x300}}},
{0x1f04,{{0x1f00,0x301}}},
{0x1f05,{{0x1f01,0x301}}},
{0x1f06,{{0x1f00,0x342}}},
{0x1f07,{{0x1f01,0x342}}},
{0x1f08,{{0x391,0x313}}},
{0x1f09,{{0x391,0x314}}},
{0x1f0a,{{0x1f08,0x300}}},
{0x1f0b,{{0x1f09,0x300}}},
{0x1f0c,{{0x1f08,0x301}}},
{0x1f0d,{{0x1f09,0x301}}},
{0x1f0e,{{0x1f08,0x342}}},
{0x1f0f,{{0x1f09,0x342}}},
{0x1f10,{{0x3b5,0x313}}},
{0x1f11,{{0x3b5,0x314}}},
{0x1f12,{{0x1f10,0x300}}},
{0x1f13,{{0x1f11,0x300}}},
{0x1f14,{{0x1f10,0x301}}},
{0x1f15,{{0x1f11,0x301}}},
{0x1f18,{{0x395,0x313}}},
{0x1f19,{{0x395,0x314}}},
{0x1f1a,{{0x1f18,0x300}}},
{0x1f1b,{{0x1f19,0x300}}},
{0x1f1c,{{0x1f18,0x301}}},
{0x1f1d,{{0x1f19,0x301}}},
{0x1f20,{{0x3b7,0x313}}},
{0x1f21,{{0x3b7,0x314}}},
{0x1f22,{{0x1f20,0x300}}},
{0x1f23,{{0x1f21,0x300}}},
{0x1f24,{{0x1f20,0x301}}},
{0x1f25,{{0x1f21,0x301}}},
{0x1f26,{{0x1f20,0x342}}},
{0x1f27,{{0x1f21,0x342}}},
{0x1f28,{{0x397,0x313}}},
{0x1f29,{{0x397,0x314}}},
{0x1f2a,{{0x1f28,0x300}}},
{0x1f2b,{{0x1f29,0x300}}},
{0x1f2c,{{0x1f28,0x301}}},
{0x1f2d,{{0x1f29,0x301}}},
{0x1f2e,{{0x1f28,0x342}}},
{0x1f2f,{{0x1f29,0x342}}},
{0x1f30,{{0x3b9,0x313}}},
{0x1f31,{{0x3b9,0x314}}},
{0x1f32,{{0x1f30,0x300}}},
{0x1f33,{{0x1f31,0x300}}},
{0x1f34,{{0x1f30,0x301}}},
{0x1f35,{{0x1f31,0x301}}},
{0x1f36,{{0x1f30,0x342}}},
{0x1f37,{{0x1f31,0x342}}},
{0x1f38,{{0x399,0x313}}},
{0x1f39,{{0x399,0x314}}},
{0x1f3a,{{0x1f38,0x300}}},
{0x1f3b,{{0x1f39,0x300}}},
{0x1f3c,{{0x1f38,0x301}}},
{0x1f3d,{{0x1f39,0x301}}},
{0x1f3e,{{0x1f38,0x342}}},
{0x1f3f,{{0x1f39,0x342}}},
{0x1f40,{{0x3bf,0x313}}},
{0x1f41,{{0x3bf,0x314}}},
{0x1f42,{{0x1f40,0x300}}},
{0x1f43,{{0x1f41,0x300}}},
{0x1f44,{{0x1f40,0x301}}},
{0x1f45,{{0x1f41,0x301}}},
{0x1f48,{{0x39f,0x313}}},
{0x1f49,{{0x39f,0x314}}},
{0x1f4a,{{0x1f48,0x300}}},
{0x1f4b,{{0x1f49,0x300}}},
{0x1f4c,{{0x1f48,0x301}}},
{0x1f4d,{{0x1f49,0x301}}},
{0x1f50,{{0x3c5,0x313}}},
{0x1f51,{{0x3c5,0x314}}},
{0x1f52,{{0x1f50,0x300}}},
{0x1f53,{{0x1f51,0x300}}},
{0x1f54,{{0x1f50,0x301}}},
{0x1f55,{{0x1f51,0x301}}},
{0x1f56,{{0x1f50,0x342}}},
{0x1f57,{{0x1f51,0x342}}},
{0x1f59,{{0x3a5,0x314}}},
{0x1f5b,{{0x1f59,0x300}}},
{0x1f5d,{{0x1f59,0x301}}},
{0x1f5f,{{0x1f59,0x342}}},
{0x1f60,{{0x3c9,0x313}}},
{0x1f61,{{0x3c9,0x314}}},
{0x1f62,{{0x1f60,0x300}}},
{0x1f63,{{0x1f61,0x300}}},
{0x1f64,{{0x1f60,0x301}}},
{0x1f65,{{0x1f61,0x301}}},
{0x1f66,{{0x1f60,0x342}}},
{0x1f67,{{0x1f61,0x342}}},
{0x1f68,{{0x3a9,0x313}}},
{0x1f69,{{0x3a9,0x314}}},
{0x1f6a,{{0x1f68,0x300}}},
{0x1f6b,{{0x1f69,0x300}}},
{0x1f6c,{{0x1f68,0x301}}},
{0x1f6d,{{0x1f69,0x301}}},
{0x1f6e,{{0x1f68,0x342}}},
{0x1f6f,{{0x1f69,0x342}}},
{0x1f70,{{0x3b1,0x300}}},
{0x1f71,{{0x3ac,0x0}}},
{0x1f72,{{0x3b5,0x300}}},
{0x1f73,{{0x3ad,0x0}}},
{0x1f74,{{0x3b7,0x300}}},
{0x1f75,{{0x3ae,0x0}}},
{0x1f76,{{0x3b9,0x300}}},
{0x1f77,{{0x3af,0x0}}},
{0x1f78,{{0x3bf,0x300}}},
{0x1f79,{{0x3cc,0x0}}},
{0x1f7a,{{0x3c5,0x300}}},
{0x1f7b,{{0x3cd,0x0}}},
{0x1f7c,{{0x3c9,0x300}}},
{0x1f7d,{{0x3ce,0x0}}},
{0x1f80,{{0x1f00,0x345}}},
{0x1f81,{{0x1f01,0x345}}},
{0x1f82,{{0x1f02,0x345}}},
{0x1f83,{{0x1f03,0x345}}},
{0x1f84,{{0x1f04,0x345}}},
{0x1f85,{{0x1f05,0x345}}},
{0x1f86,{{0x1f06,0x345}}},
{0x1f87,{{0x1f07,0x345}}},
{0x1f88,{{0x1f08,0x345}}},
{0x1f89,{{0x1f09,0x345}}},
{0x1f8a,{{0x1f0a,0x345}}},
{0x1f8b,{{0x1f0b,0x345}}},
{0x1f8c,{{0x1f0c,0x345}}},
{0x1f8d,{{0x1f0d,0x345}}},
{0x1f8e,{{0x1f0e,0x345}}},
{0x1f8f,{{0x1f0f,0x345}}},
{0x1f90,{{0x1f20,0x345}}},
{0x1f91,{{0x1f21,0x345}}},
{0x1f92,{{0x1f22,0x345}}},
{0x1f93,{{0x1f23,0x345}}},
{0x1f94,{{0x1f24,0x345}}},
{0x1f95,{{0x1f25,0x345}}},
{0x1f96,{{0x1f26,0x345}}},
{0x1f97,{{0x1f27,0x345}}},
{0x1f98,{{0x1f28,0x345}}},
{0x1f99,{{0x1f29,0x345}}},
{0x1f9a,{{0x1f2a,0x345}}},
{0x1f9b,{{0x1f2b,0x345}}},
{0x1f9c,{{0x1f2c,0x345}}},
{0x1f9d,{{0x1f2d,0x345}}},
{0x1f9e,{{0x1f2e,0x345}}},
{0x1f9f,{{0x1f2f,0x345}}},
{0x1fa0,{{0x1f60,0x345}}},
{0x1fa1,{{0x1f61,0x345}}},
{0x1fa2,{{0x1f62,0x345}}},
{0x1fa3,{{0x1f63,0x345}}},
{0x1fa4,{{0x1f64,0x345}}},
{0x1fa5,{{0x1f65,0x345}}},
{0x1fa6,{{0x1f66,0x345}}},
{0x1fa7,{{0x1f67,0x345}}},
{0x1fa8,{{0x1f68,0x345}}},
{0x1fa9,{{0x1f69,0x345}}},
{0x1faa,{{0x1f6a,0x345}}},
{0x1fab,{{0x1f6b,0x345}}},
{0x1fac,{{0x1f6c,0x345}}},
{0x1fad,{{0x1f6d,0x345}}},
{0x1fae,{{0x1f6e,0x345}}},
{0x1faf,{{0x1f6f,0x345}}},
{0x1fb0,{{0x3b1,0x306}}},
{0x1fb1,{{0x3b1,0x304}}},
{0x1fb2,{{0x1f70,0x345}}},
{0x1fb3,{{0x3b1,0x345}}},
{0x1fb4,{{0x3ac,0x345}}},
{0x1fb6,{{0x3b1,0x342}}},
{0x1fb7,{{0x1fb6,0x345}}},
{0x1fb8,{{0x391,0x306}}},
{0x1fb9,{{0x391,0x304}}},
{0x1fba,{{0x391,0x300}}},
{0x1fbb,{{0x386,0x0}}},
{0x1fbc,{{0x391,0x345}}},
{0x1fbe,{{0x3b9,0x0}}},
{0x1fc1,{{0xa8,0x342}}},
{0x1fc2,{{0x1f74,0x345}}},
{0x1fc3,{{0x3b7,0x345}}},
{0x1fc4,{{0x3ae,0x345}}},
{0x1fc6,{{0x3b7,0x342}}},
{0x1fc7,{{0x1fc6,0x345}}},
{0x1fc8,{{0x395,0x300}}},
{0x1fc9,{{0x388,0x0}}},
{0x1fca,{{0x397,0x300}}},
{0x1fcb,{{0x389,0x0}}},
{0x1fcc,{{0x397,0x345}}},
{0x1fcd,{{0x1fbf,0x300}}},
{0x1fce,{{0x1fbf,0x301}}},
{0x1fcf,{{0x1fbf,0x342}}},
{0x1fd0,{{0x3b9,0x306}}},
{0x1fd1,{{0x3b9,0x304}}},
{0x1fd2,{{0x3ca,0x300}}},
{0x1fd3,{{0x390,0x0}}},
{0x1fd6,{{0x3b9,0x342}}},
{0x1fd7,{{0x3ca,0x342}}},
{0x1fd8,{{0x399,0x306}}},
{0x1fd9,{{0x399,0x304}}},
{0x1fda,{{0x399,0x300}}},
{0x1fdb,{{0x38a,0x0}}},
{0x1fdd,{{0x1ffe,0x300}}},
{0x1fde,{{0x1ffe,0x301}}},
{0x1fdf,{{0x1ffe,0x342}}},
{0x1fe0,{{0x3c5,0x306}}},
{0x1fe1,{{0x3c5,0x304}}},
{0x1fe2,{{0x3cb,0x300}}},
{0x1fe3,{{0x3b0,0x0}}},
{0x1fe4,{{0x3c1,0x313}}},
{0x1fe5,{{0x3c1,0x314}}},
{0x1fe6,{{0x3c5,0x342}}},
{0x1fe7,{{0x3cb,0x342}}},
{0x1fe8,{{0x3a5,0x306}}},
{0x1fe9,{{0x3a5,0x304}}},
{0x1fea,{{0x3a5,0x300}}},
{0x1feb,{{0x38e,0x0}}},
{0x1fec,{{0x3a1,0x314}}},
{0x1fed,{{0xa8,0x300}}},
{0x1fee,{{0x385,0x0}}},
{0x1fef,{{0x60,0x0}}},
{0x1ff2,{{0x1f7c,0x345}}},
{0x1ff3,{{0x3c9,0x345}}},
{0x1ff4,{{0x3ce,0x345}}},
{0x1ff6,{{0x3c9,0x342}}},
{0x1ff7,{{0x1ff6,0x345}}},
{0x1ff8,{{0x39f,0x300}}},
{0x1ff9,{{0x38c,0x0}}},
{0x1ffa,{{0x3a9,0x300}}},
{0x1ffb,{{0x38f,0x0}}},
{0x1ffc,{{0x3a9,0x345}}},
{0x1ffd,{{0xb4,0x0}}},
{0x2000,{{0x2002,0x0}}},
{0x2001,{{0x2003,0x0}}},
{0x2126,{{0x3a9,0x0}}},
{0x212a,{{0x4b,0x0}}},
{0x212b,{{0xc5,0x0}}},
{0x219a,{{0x2190,0x338}}},
{0x219b,{{0x2192,0x338}}},
{0x21ae,{{0x2194,0x338}}},
{0x21cd,{{0x21d0,0x338}}},
{0x21ce,{{0x21d4,0x338}}},
{0x21cf,{{0x21d2,0x338}}},
{0x2204,{{0x2203,0x338}}},
{0x2209,{{0x2208,0x338}}},
{0x220c,{{0x220b,0x338}}},
{0x2224,{{0x2223,0x338}}},
{0x2226,{{0x2225,0x338}}},
{0x2241,{{0x223c,0x338}}},
{0x2244,{{0x2243,0x338}}},
{0x2247,{{0x2245,0x338}}},
{0x2249,{{0x2248,0x338}}},
{0x2260,{{0x3d,0x338}}},
{0x2262,{{0x2261,0x338}}},
{0x226d,{{0x224d,0x338}}},
{0x226e,{{0x3c,0x338}}},
{0x226f,{{0x3e,0x338}}},
{0x2270,{{0x2264,0x338}}},
{0x2271,{{0x2265,0x338}}},
{0x2274,{{0x2272,0x338}}},
{0x2275,{{0x2273,0x338}}},
{0x2278,{{0x2276,0x338}}},
{0x2279,{{0x2277,0x338}}},
{0x2280,{{0x227a,0x338}}},
{0x2281,{{0x227b,0x338}}},
{0x2284,{{0x2282,0x338}}},
{0x2285,{{0x2283,0x338}}},
{0x2288,{{0x2286,0x338}}},
{0x2289,{{0x2287,0x338}}},
{0x22ac,{{0x22a2,0x338}}},
{0x22ad,{{0x22a8,0x338}}},
{0x22ae,{{0x22a9,0x338}}},
{0x22af,{{0x22ab,0x338}}},
{0x22e0,{{0x227c,0x338}}},
{0x22e1,{{0x227d,0x338}}},
{0x22e2,{{0x2291,0x338}}},
{0x22e3,{{0x2292,0x338}}},
{0x22ea,{{0x22b2,0x338}}},
{0x22eb,{{0x22b3,0x338}}},
{0x22ec,{{0x22b4,0x338}}},
{0x22ed,{{0x22b5,0x338}}},
{0x2329,{{0x3008,0x0}}},
{0x232a,{{0x3009,0x0}}},
{0x2adc,{{0x2add,0x338}}},
{0x304c,{{0x304b,0x3099}}},
{0x304e,{{0x304d,0x3099}}},
{0x3050,{{0x304f,0x3099}}},
{0x3052,{{0x3051,0x3099}}},
{0x3054,{{0x3053,0x3099}}},
{0x3056,{{0x3055,0x3099}}},
{0x3058,{{0x3057,0x3099}}},
{0x305a,{{0x3059,0x3099}}},
{0x305c,{{0x305b,0x3099}}},
{0x305e,{{0x305d,0x3099}}},
{0x3060,{{0x305f,0x3099}}},
{0x3062,{{0x3061,0x3099}}},
{0x3065,{{0x3064,0x3099}}},
{0x3067,{{0x3066,0x3099}}},
{0x3069,{{0x3068,0x3099}}},
{0x3070,{{0x306f,0x3099}}},
{0x3071,{{0x306f,0x309a}}},
{0x3073,{{0x3072,0x3099}}},
{0x3074,{{0x3072,0x309a}}},
{0x3076,{{0x3075,0x3099}}},
{0x3077,{{0x3075,0x309a}}},
{0x3079,{{0x3078,0x3099}}},
{0x307a,{{0x3078,0x309a}}},
{0x307c,{{0x307b,0x3099}}},
{0x307d,{{0x307b,0x309a}}},
{0x3094,{{0x3046,0x3099}}},
{0x309e,{{0x309d,0x3099}}},
{0x30ac,{{0x30ab,0x3099}}},
{0x30ae,{{0x30ad,0x3099}}},
{0x30b0,{{0x30af,0x3099}}},
{0x30b2,{{0x30b1,0x3099}}},
{0x30b4,{{0x30b3,0x3099}}},
{0x30b6,{{0x30b5,0x3099}}},
{0x30b8,{{0x30b7,0x3099}}},
{0x30ba,{{0x30b9,0x3099}}},
{0x30bc,{{0x30bb,0x3099}}},
{0x30be,{{0x30bd,0x3099}}},
{0x30c0,{{0x30bf,0x3099}}},
{0x30c2,{{0x30c1,0x3099}}},
{0x30c5,{{0x30c4,0x3099}}},
{0x30c7,{{0x30c6,0x3099}}},
{0x30c9,{{0x30c8,0x3099}}},
{0x30d0,{{0x30cf,0x3099}}},
{0x30d1,{{0x30cf,0x309a}}},
{0x30d3,{{0x30d2,0x3099}}},
{0x30d4,{{0x30d2,0x309a}}},
{0x30d6,{{0x30d5,0x3099}}},
{0x30d7,{{0x30d5,0x309a}}},
{0x30d9,{{0x30d8,0x3099}}},
{0x30da,{{0x30d8,0x309a}}},
{0x30dc,{{0x30db,0x3099}}},
{0x30dd,{{0x30db,0x309a}}},
{0x30f4,{{0x30a6,0x3099}}},
{0x30f7,{{0x30ef,0x3099}}},
{0x30f8,{{0x30f0,0x3099}}},
{0x30f9,{{0x30f1,0x3099}}},
{0x30fa,{{0x30f2,0x3099}}},
{0x30fe,{{0x30fd,0x3099}}},
{0xf900,{{0x8c48,0x0}}},
{0xf901,{{0x66f4,0x0}}},
{0xf902,{{0x8eca,0x0}}},
{0xf903,{{0x8cc8,0x0}}},
{0xf904,{{0x6ed1,0x0}}},
{0xf905,{{0x4e32,0x0}}},
{0xf906,{{0x53e5,0x0}}},
{0xf907,{{0x9f9c,0x0}}},
{0xf908,{{0x9f9c,0x0}}},
{0xf909,{{0x5951,0x0}}},
{0xf90a,{{0x91d1,0x0}}},
{0xf90b,{{0x5587,0x0}}},
{0xf90c,{{0x5948,0x0}}},
{0xf90d,{{0x61f6,0x0}}},
{0xf90e,{{0x7669,0x0}}},
{0xf90f,{{0x7f85,0x0}}},
{0xf910,{{0x863f,0x0}}},
{0xf911,{{0x87ba,0x0}}},
{0xf912,{{0x88f8,0x0}}},
{0xf913,{{0x908f,0x0}}},
{0xf914,{{0x6a02,0x0}}},
{0xf915,{{0x6d1b,0x0}}},
{0xf916,{{0x70d9,0x0}}},
{0xf917,{{0x73de,0x0}}},
{0xf918,{{0x843d,0x0}}},
{0xf919,{{0x916a,0x0}}},
{0xf91a,{{0x99f1,0x0}}},
{0xf91b,{{0x4e82,0x0}}},
{0xf91c,{{0x5375,0x0}}},
{0xf91d,{{0x6b04,0x0}}},
{0xf91e,{{0x721b,0x0}}},
{0xf91f,{{0x862d,0x0}}},
{0xf920,{{0x9e1e,0x0}}},
{0xf921,{{0x5d50,0x0}}},
{0xf922,{{0x6feb,0x0}}},
{0xf923,{{0x85cd,0x0}}},
{0xf924,{{0x8964,0x0}}},
{0xf925,{{0x62c9,0x0}}},
{0xf926,{{0x81d8,0x0}}},
{0xf927,{{0x881f,0x0}}},
{0xf928,{{0x5eca,0x0}}},
{0xf929,{{0x6717,0x0}}},
{0xf92a,{{0x6d6a,0x0}}},
{0xf92b,{{0x72fc,0x0}}},
{0xf92c,{{0x90ce,0x0}}},
{0xf92d,{{0x4f86,0x0}}},
{0xf92e,{{0x51b7,0x0}}},
{0xf92f,{{0x52de,0x0}}},
{0xf930,{{0x64c4,0x0}}},
{0xf931,{{0x6ad3,0x0}}},
{0xf932,{{0x7210,0x0}}},
{0xf933,{{0x76e7,0x0}}},
{0xf934,{{0x8001,0x0}}},
{0xf935,{{0x8606,0x0}}},
{0xf936,{{0x865c,0x0}}},
{0xf937,{{0x8def,0x0}}},
{0xf938,{{0x9732,0x0}}},
{0xf939,{{0x9b6f,0x0}}},
{0xf93a,{{0x9dfa,0x0}}},
{0xf93b,{{0x788c,0x0}}},
{0xf93c,{{0x797f,0x0}}},
{0xf93d,{{0x7da0,0x0}}},
{0xf93e,{{0x83c9,0x0}}},
{0xf93f,{{0x9304,0x0}}},
{0xf940,{{0x9e7f,0x0}}},
{0xf941,{{0x8ad6,0x0}}},
{0xf942,{{0x58df,0x0}}},
{0xf943,{{0x5f04,0x0}}},
{0xf944,{{0x7c60,0x0}}},
{0xf945,{{0x807e,0x0}}},
{0xf946,{{0x7262,0x0}}},
{0xf947,{{0x78ca,0x0}}},
{0xf948,{{0x8cc2,0x0}}},
{0xf949,{{0x96f7,0x0}}},
{0xf94a,{{0x58d8,0x0}}},
{0xf94b,{{0x5c62,0x0}}},
{0xf94c,{{0x6a13,0x0}}},
{0xf94d,{{0x6dda,0x0}}},
{0xf94e,{{0x6f0f,0x0}}},
{0xf94f,{{0x7d2f,0x0}}},
{0xf950,{{0x7e37,0x0}}},
{0xf951,{{0x964b,0x0}}},
{0xf952,{{0x52d2,0x0}}},
{0xf953,{{0x808b,0x0}}},
{0xf954,{{0x51dc,0x0}}},
{0xf955,{{0x51cc,0x0}}},
{0xf956,{{0x7a1c,0x0}}},
{0xf957,{{0x7dbe,0x0}}},
{0xf958,{{0x83f1,0x0}}},
{0xf959,{{0x9675,0x0}}},
{0xf95a,{{0x8b80,0x0}}},
{0xf95b,{{0x62cf,0x0}}},
{0xf95c,{{0x6a02,0x0}}},
{0xf95d,{{0x8afe,0x0}}},
{0xf95e,{{0x4e39,0x0}}},
{0xf95f,{{0x5be7,0x0}}},
{0xf960,{{0x6012,0x0}}},
{0xf961,{{0x7387,0x0}}},
{0xf962,{{0x7570,0x0}}},
{0xf963,{{0x5317,0x0}}},
{0xf964,{{0x78fb,0x0}}},
{0xf965,{{0x4fbf,0x0}}},
{0xf966,{{0x5fa9,0x0}}},
{0xf967,{{0x4e0d,0x0}}},
{0xf968,{{0x6ccc,0x0}}},
{0xf969,{{0x6578,0x0}}},
{0xf96a,{{0x7d22,0x0}}},
{0xf96b,{{0x53c3,0x0}}},
{0xf96c,{{0x585e,0x0}}},
{0xf96d,{{0x7701,0x0}}},
{0xf96e,{{0x8449,0x0}}},
{0xf96f,{{0x8aaa,0x0}}},
{0xf970,{{0x6bba,0x0}}},
{0xf971,{{0x8fb0,0x0}}},
{0xf972,{{0x6c88,0x0}}},
{0xf973,{{0x62fe,0x0}}},
{0xf974,{{0x82e5,0x0}}},
{0xf975,{{0x63a0,0x0}}},
{0xf976,{{0x7565,0x0}}},
{0xf977,{{0x4eae,0x0}}},
{0xf978,{{0x5169,0x0}}},
{0xf979,{{0x51c9,0x0}}},
{0xf97a,{{0x6881,0x0}}},
{0xf97b,{{0x7ce7,0x0}}},
{0xf97c,{{0x826f,0x0}}},
{0xf97d,{{0x8ad2,0x0}}},
{0xf97e,{{0x91cf,0x0}}},
{0xf97f,{{0x52f5,0x0}}},
{0xf980,{{0x5442,0x0}}},
{0xf981,{{0x5973,0x0}}},
{0xf982,{{0x5eec,0x0}}},
{0xf983,{{0x65c5,0x0}}},
{0xf984,{{0x6ffe,0x0}}},
{0xf985,{{0x792a,0x0}}},
{0xf986,{{0x95ad,0x0}}},
{0xf987,{{0x9a6a,0x0}}},
{0xf988,{{0x9e97,0x0}}},
{0xf989,{{0x9ece,0x0}}},
{0xf98a,{{0x529b,0x0}}},
{0xf98b,{{0x66c6,0x0}}},
{0xf98c,{{0x6b77,0x0}}},
{0xf98d,{{0x8f62,0x0}}},
{0xf98e,{{0x5e74,0x0}}},
{0xf98f,{{0x6190,0x0}}},
{0xf990,{{0x6200,0x0}}},
{0xf991,{{0x649a,0x0}}},
{0xf992,{{0x6f23,0x0}}},
{0xf993,{{0x7149,0x0}}},
{0xf994,{{0x7489,0x0}}},
{0xf995,{{0x79ca,0x0}}},
{0xf996,{{0x7df4,0x0}}},
{0xf997,{{0x806f,0x0}}},
{0xf998,{{0x8f26,0x0}}},
{0xf999,{{0x84ee,0x0}}},
{0xf99a,{{0x9023,0x0}}},
{0xf99b,{{0x934a,0x0}}},
{0xf99c,{{0x5217,0x0}}},
{0xf99d,{{0x52a3,0x0}}},
{0xf99e,{{0x54bd,0x0}}},
{0xf99f,{{0x70c8,0x0}}},
{0xf9a0,{{0x88c2,0x0}}},
{0xf9a1,{{0x8aaa,0x0}}},
{0xf9a2,{{0x5ec9,0x0}}},
{0xf9a3,{{0x5ff5,0x0}}},
{0xf9a4,{{0x637b,0x0}}},
{0xf9a5,{{0x6bae,0x0}}},
{0xf9a6,{{0x7c3e,0x0}}},
{0xf9a7,{{0x7375,0x0}}},
{0xf9a8,{{0x4ee4,0x0}}},
{0xf9a9,{{0x56f9,0x0}}},
{0xf9aa,{{0x5be7,0x0}}},
{0xf9ab,{{0x5dba,0x0}}},
{0xf9ac,{{0x601c,0x0}}},
{0xf9ad,{{0x73b2,0x0}}},
{0xf9ae,{{0x7469,0x0}}},
{0xf9af,{{0x7f9a,0x0}}},
{0xf9b0,{{0x8046,0x0}}},
{0xf9b1,{{0x9234,0x0}}},
{0xf9b2,{{0x96f6,0x0}}},
{0xf9b3,{{0x9748,0x0}}},
{0xf9b4,{{0x9818,0x0}}},
{0xf9b5,{{0x4f8b,0x0}}},
{0xf9b6,{{0x79ae,0x0}}},
{0xf9b7,{{0x91b4,0x0}}},
{0xf9b8,{{0x96b8,0x0}}},
{0xf9b9,{{0x60e1,0x0}}},
{0xf9ba,{{0x4e86,0x0}}},
{0xf9bb,{{0x50da,0x0}}},
{0xf9bc,{{0x5bee,0x0}}},
{0xf9bd,{{0x5c3f,0x0}}},
{0xf9be,{{0x6599,0x0}}},
{0xf9bf,{{0x6a02,0x0}}},
{0xf9c0,{{0x71ce,0x0}}},
{0xf9c1,{{0x7642,0x0}}},
{0xf9c2,{{0x84fc,0x0}}},
{0xf9c3,{{0x907c,0x0}}},
{0xf9c4,{{0x9f8d,0x0}}},
{0xf9c5,{{0x6688,0x0}}},
{0xf9c6,{{0x962e,0x0}}},
{0xf9c7,{{0x5289,0x0}}},
{0xf9c8,{{0x677b,0x0}}},
{0xf9c9,{{0x67f3,0x0}}},
{0xf9ca,{{0x6d41,0x0}}},
{0xf9cb,{{0x6e9c,0x0}}},
{0xf9cc,{{0x7409,0x0}}},
{0xf9cd,{{0x7559,0x0}}},
{0xf9ce,{{0x786b,0x0}}},
{0xf9cf,{{0x7d10,0x0}}},
{0xf9d0,{{0x985e,0x0}}},
{0xf9d1,{{0x516d,0x0}}},
{0xf9d2,{{0x622e,0x0}}},
{0xf9d3,{{0x9678,0x0}}},
{0xf9d4,{{0x502b,0x0}}},
{0xf9d5,{{0x5d19,0x0}}},
{0xf9d6,{{0x6dea,0x0}}},
{0xf9d7,{{0x8f2a,0x0}}},
{0xf9d8,{{0x5f8b,0x0}}},
{0xf9d9,{{0x6144,0x0}}},
{0xf9da,{{0x6817,0x0}}},
{0xf9db,{{0x7387,0x0}}},
{0xf9dc,{{0x9686,0x0}}},
{0xf9dd,{{0x5229,0x0}}},
{0xf9de,{{0x540f,0x0}}},
{0xf9df,{{0x5c65,0x0}}},
{0xf9e0,{{0x6613,0x0}}},
{0xf9e1,{{0x674e,0x0}}},
{0xf9e2,{{0x68a8,0x0}}},
{0xf9e3,{{0x6ce5,0x0}}},
{0xf9e4,{{0x7406,0x0}}},
{0xf9e5,{{0x75e2,0x0}}},
{0xf9e6,{{0x7f79,0x0}}},
{0xf9e7,{{0x88cf,0x0}}},
{0xf9e8,{{0x88e1,0x0}}},
{0xf9e9,{{0x91cc,0x0}}},
{0xf9ea,{{0x96e2,0x0}}},
{0xf9eb,{{0x533f,0x0}}},
{0xf9ec,{{0x6eba,0x0}}},
{0xf9ed,{{0x541d,0x0}}},
{0xf9ee,{{0x71d0,0x0}}},
{0xf9ef,{{0x7498,0x0}}},
{0xf9f0,{{0x85fa,0x0}}},
{0xf9f1,{{0x96a3,0x0}}},
{0xf9f2,{{0x9c57,0x0}}},
{0xf9f3,{{0x9e9f,0x0}}},
{0xf9f4,{{0x6797,0x0}}},
{0xf9f5,{{0x6dcb,0x0}}},
{0xf9f6,{{0x81e8,0x0}}},
{0xf9f7,{{0x7acb,0x0}}},
{0xf9f8,{{0x7b20,0x0}}},
{0xf9f9,{{0x7c92,0x0}}},
{0xf9fa,{{0x72c0,0x0}}},
{0xf9fb,{{0x7099,0x0}}},
{0xf9fc,{{0x8b58,0x0}}},
{0xf9fd,{{0x4ec0,0x0}}},
{0xf9fe,{{0x8336,0x0}}},
{0xf9ff,{{0x523a,0x0}}},
{0xfa00,{{0x5207,0x0}}},
{0xfa01,{{0x5ea6,0x0}}},
{0xfa02,{{0x62d3,0x0}}},
{0xfa03,{{0x7cd6,0x0}}},
{0xfa04,{{0x5b85,0x0}}},
{0xfa05,{{0x6d1e,0x0}}},
{0xfa06,{{0x66b4,0x0}}},
{0xfa07,{{0x8f3b,0x0}}},
{0xfa08,{{0x884c,0x0}}},
{0xfa09,{{0x964d,0x0}}},
{0xfa0a,{{0x898b,0x0}}},
{0xfa0b,{{0x5ed3,0x0}}},
{0xfa0c,{{0x5140,0x0}}},
{0xfa0d,{{0x55c0,0x0}}},
{0xfa10,{{0x585a,0x0}}},
{0xfa12,{{0x6674,0x0}}},
{0xfa15,{{0x51de,0x0}}},
{0xfa16,{{0x732a,0x0}}},
{0xfa17,{{0x76ca,0x0}}},
{0xfa18,{{0x793c,0x0}}},
{0xfa19,{{0x795e,0x0}}},
{0xfa1a,{{0x7965,0x0}}},
{0xfa1b,{{0x798f,0x0}}},
{0xfa1c,{{0x9756,0x0}}},
{0xfa1d,{{0x7cbe,0x0}}},
{0xfa1e,{{0x7fbd,0x0}}},
{0xfa20,{{0x8612,0x0}}},
{0xfa22,{{0x8af8,0x0}}},
{0xfa25,{{0x9038,0x0}}},
{0xfa26,{{0x90fd,0x0}}},
{0xfa2a,{{0x98ef,0x0}}},
{0xfa2b,{{0x98fc,0x0}}},
{0xfa2c,{{0x9928,0x0}}},
{0xfa2d,{{0x9db4,0x0}}},
{0xfa2e,{{0x90de,0x0}}},
{0xfa2f,{{0x96b7,0x0}}},
{0xfa30,{{0x4fae,0x0}}},
{0xfa31,{{0x50e7,0x0}}},
{0xfa32,{{0x514d,0x0}}},
{0xfa33,{{0x52c9,0x0}}},
{0xfa34,{{0x52e4,0x0}}},
{0xfa35,{{0x5351,0x0}}},
{0xfa36,{{0x559d,0x0}}},
{0xfa37,{{0x5606,0x0}}},
{0xfa38,{{0x5668,0x0}}},
{0xfa39,{{0x5840,0x0}}},
{0xfa3a,{{0x58a8,0x0}}},
{0xfa3b,{{0x5c64,0x0}}},
{0xfa3c,{{0x5c6e,0x0}}},
{0xfa3d,{{0x6094,0x0}}},
{0xfa3e,{{0x6168,0x0}}},
{0xfa3f,{{0x618e,0x0}}},
{0xfa40,{{0x61f2,0x0}}},
{0xfa41,{{0x654f,0x0}}},
{0xfa42,{{0x65e2,0x0}}},
{0xfa43,{{0x6691,0x0}}},
{0xfa44,{{0x6885,0x0}}},
{0xfa45,{{0x6d77,0x0}}},
{0xfa46,{{0x6e1a,0x0}}},
{0xfa47,{{0x6f22,0x0}}},
{0xfa48,{{0x716e,0x0}}},
{0xfa49,{{0x722b,0x0}}},
{0xfa4a,{{0x7422,0x0}}},
{0xfa4b,{{0x7891,0x0}}},
{0xfa4c,{{0x793e,0x0}}},
{0xfa4d,{{0x7949,0x0}}},
{0xfa4e,{{0x7948,0x0}}},
{0xfa4f,{{0x7950,0x0}}},
{0xfa50,{{0x7956,0x0}}},
{0xfa51,{{0x795d,0x0}}},
{0xfa52,{{0x798d,0x0}}},
{0xfa53,{{0x798e,0x0}}},
{0xfa54,{{0x7a40,0x0}}},
{0xfa55,{{0x7a81,0x0}}},
{0xfa56,{{0x7bc0,0x0}}},
{0xfa57,{{0x7df4,0x0}}},
{0xfa58,{{0x7e09,0x0}}},
{0xfa59,{{0x7e41,0x0}}},
{0xfa5a,{{0x7f72,0x0}}},
{0xfa5b,{{0x8005,0x0}}},
{0xfa5c,{{0x81ed,0x0}}},
{0xfa5d,{{0x8279,0x0}}},
{0xfa5e,{{0x8279,0x0}}},
{0xfa5f,{{0x8457,0x0}}},
{0xfa60,{{0x8910,0x0}}},
{0xfa61,{{0x8996,0x0}}},
{0xfa62,{{0x8b01,0x0}}},
{0xfa63,{{0x8b39,0x0}}},
{0xfa64,{{0x8cd3,0x0}}},
{0xfa65,{{0x8d08,0x0}}},
{0xfa66,{{0x8fb6,0x0}}},
{0xfa67,{{0x9038,0x0}}},
{0xfa68,{{0x96e3,0x0}}},
{0xfa69,{{0x97ff,0x0}}},
{0xfa6a,{{0x983b,0x0}}},
{0xfa6b,{{0x6075,0x0}}},
{0xfa6c,{{0x242ee,0x0}}},
{0xfa6d,{{0x8218,0x0}}},
{0xfa70,{{0x4e26,0x0}}},
{0xfa71,{{0x51b5,0x0}}},
{0xfa72,{{0x5168,0x0}}},
{0xfa73,{{0x4f80,0x0}}},
{0xfa74,{{0x5145,0x0}}},
{0xfa75,{{0x5180,0x0}}},
{0xfa76,{{0x52c7,0x0}}},
{0xfa77,{{0x52fa,0x0}}},
{0xfa78,{{0x559d,0x0}}},
{0xfa79,{{0x5555,0x0}}},
{0xfa7a,{{0x5599,0x0}}},
{0xfa7b,{{0x55e2,0x0}}},
{0xfa7c,{{0x585a,0x0}}},
{0xfa7d,{{0x58b3,0x0}}},
{0xfa7e,{{0x5944,0x0}}},
{0xfa7f,{{0x5954,0x0}}},
{0xfa80,{{0x5a62,0x0}}},
{0xfa81,{{0x5b28,0x0}}},
{0xfa82,{{0x5ed2,0x0}}},
{0xfa83,{{0x5ed9,0x0}}},
{0xfa84,{{0x5f69,0x0}}},
{0xfa85,{{0x5fad,0x0}}},
{0xfa86,{{0x60d8,0x0}}},
{0xfa87,{{0x614e,0x0}}},
{0xfa88,{{0x6108,0x0}}},
{0xfa89,{{0x618e,0x0}}},
{0xfa8a,{{0x6160,0x0}}},
{0xfa8b,{{0x61f2,0x0}}},
{0xfa8c,{{0x6234,0x0}}},
{0xfa8d,{{0x63c4,0x0}}},
{0xfa8e,{{0x641c,0x0}}},
{0xfa8f,{{0x6452,0x0}}},
{0xfa90,{{0x6556,0x0}}},
{0xfa91,{{0x6674,0x0}}},
{0xfa92,{{0x6717,0x0}}},
{0xfa93,{{0x671b,0x0}}},
{0xfa94,{{0x6756,0x0}}},
{0xfa95,{{0x6b79,0x0}}},
{0xfa96,{{0x6bba,0x0}}},
{0xfa97,{{0x6d41,0x0}}},
{0xfa98,{{0x6edb,0x0}}},
{0xfa99,{{0x6ecb,0x0}}},
{0xfa9a,{{0x6f22,0x0}}},
{0xfa9b,{{0x701e,0x0}}},
{0xfa9c,{{0x716e,0x0}}},
{0xfa9d,{{0x77a7,0x0}}},
{0xfa9e,{{0x7235,0x0}}},
{0xfa9f,{{0x72af,0x0}}},
{0xfaa0,{{0x732a,0x0}}},
{0xfaa1,{{0x7471,0x0}}},
{0xfaa2,{{0x7506,0x0}}},
{0xfaa3,{{0x753b,0x0}}},
{0xfaa4,{{0x761d,0x0}}},
{0xfaa5,{{0x761f,0x0}}},
{0xfaa6,{{0x76ca,0x0}}},
{0xfaa7,{{0x76db,0x0}}},
{0xfaa8,{{0x76f4,0x0}}},
{0xfaa9,{{0x774a,0x0}}},
{0xfaaa,{{0x7740,0x0}}},
{0xfaab,{{0x78cc,0x0}}},
{0xfaac,{{0x7ab1,0x0}}},
{0xfaad,{{0x7bc0,0x0}}},
{0xfaae,{{0x7c7b,0x0}}},
{0xfaaf,{{0x7d5b,0x0}}},
{0xfab0,{{0x7df4,0x0}}},
{0xfab1,{{0x7f3e,0x0}}},
{0xfab2,{{0x8005,0x0}}},
{0xfab3,{{0x8352,0x0}}},
{0xfab4,{{0x83ef,0x0}}},
{0xfab5,{{0x8779,0x0}}},
{0xfab6,{{0x8941,0x0}}},
{0xfab7,{{0x8986,0x0}}},
{0xfab8,{{0x8996,0x0}}},
{0xfab9,{{0x8abf,0x0}}},
{0xfaba,{{0x8af8,0x0}}},
{0xfabb,{{0x8acb,0x0}}},
{0xfabc,{{0x8b01,0x0}}},
{0xfabd,{{0x8afe,0x0}}},
{0xfabe,{{0x8aed,0x0}}},
{0xfabf,{{0x8b39,0x0}}},
{0xfac0,{{0x8b8a,0x0}}},
{0xfac1,{{0x8d08,0x0}}},
{0xfac2,{{0x8f38,0x0}}},
{0xfac3,{{0x9072,0x0}}},
{0xfac4,{{0x9199,0x0}}},
{0xfac5,{{0x9276,0x0}}},
{0xfac6,{{0x967c,0x0}}},
{0xfac7,{{0x96e3,0x0}}},
{0xfac8,{{0x9756,0x0}}},
{0xfac9,{{0x97db,0x0}}},
{0xfaca,{{0x97ff,0x0}}},
{0xfacb,{{0x980b,0x0}}},
{0xfacc,{{0x983b,0x0}}},
{0xfacd,{{0x9b12,0x0}}},
{0xface,{{0x9f9c,0x0}}},
{0xfacf,{{0x2284a,0x0}}},
{0xfad0,{{0x22844,0x0}}},
{0xfad1,{{0x233d5,0x0}}},
{0xfad2,{{0x3b9d,0x0}}},
{0xfad3,{{0x4018,0x0}}},
{0xfad4,{{0x4039,0x0}}},
{0xfad5,{{0x25249,0x0}}},
{0xfad6,{{0x25cd0,0x0}}},
{0xfad7,{{0x27ed3,0x0}}},
{0xfad8,{{0x9f43,0x0}}},
{0xfad9,{{0x9f8e,0x0}}},
{0xfb1d,{{0x5d9,0x5b4}}},
{0xfb1f,{{0x5f2,0x5b7}}},
{0xfb2a,{{0x5e9,0x5c1}}},
{0xfb2b,{{0x5e9,0x5c2}}},
{0xfb2c,{{0xfb49,0x5c1}}},
{0xfb2d,{{0xfb49,0x5c2}}},
{0xfb2e,{{0x5d0,0x5b7}}},
{0xfb2f,{{0x5d0,0x5b8}}},
{0xfb30,{{0x5d0,0x5bc}}},
{0xfb31,{{0x5d1,0x5bc}}},
{0xfb32,{{0x5d2,0x5bc}}},
{0xfb33,{{0x5d3,0x5bc}}},
{0xfb34,{{0x5d4,0x5bc}}},
{0xfb35,{{0x5d5,0x5bc}}},
{0xfb36,{{0x5d6,0x5bc}}},
{0xfb38,{{0x5d8,0x5bc}}},
{0xfb39,{{0x5d9,0x5bc}}},
{0xfb3a,{{0x5da,0x5bc}}},
{0xfb3b,{{0x5db,0x5bc}}},
{0xfb3c,{{0x5dc,0x5bc}}},
{0xfb3e,{{0x5de,0x5bc}}},
{0xfb40,{{0x5e0,0x5bc}}},
{0xfb41,{{0x5e1,0x5bc}}},
{0xfb43,{{0x5e3,0x5bc}}},
{0xfb44,{{0x5e4,0x5bc}}},
{0xfb46,{{0x5e6,0x5bc}}},
{0xfb47,{{0x5e7,0x5bc}}},
{0xfb48,{{0x5e8,0x5bc}}},
{0xfb49,{{0x5e9,0x5bc}}},
{0xfb4a,{{0x5ea,0x5bc}}},
{0xfb4b,{{0x5d5,0x5b9}}},
{0xfb4c,{{0x5d1,0x5bf}}},
{0xfb4d,{{0x5db,0x5bf}}},
{0xfb4e,{{0x5e4,0x5bf}}},
{0x1109a,{{0x11099,0x110ba}}},
{0x1109c,{{0x1109b,0x110ba}}},
{0x110ab,{{0x110a5,0x110ba}}},
{0x1112e,{{0x11131,0x11127}}},
{0x1112f,{{0x11132,0x11127}}},
{0x1134b,{{0x11347,0x1133e}}},
{0x1134c,{{0x11347,0x11357}}},
{0x114bb,{{0x114b9,0x114ba}}},
{0x114bc,{{0x114b9,0x114b0}}},
{0x114be,{{0x114b9,0x114bd}}},
{0x115ba,{{0x115b8,0x115af}}},
{0x115bb,{{0x115b9,0x115af}}},
{0x1d15e,{{0x1d157,0x1d165}}},
{0x1d15f,{{0x1d158,0x1d165}}},
{0x1d160,{{0x1d15f,0x1d16e}}},
{0x1d161,{{0x1d15f,0x1d16f}}},
{0x1d162,{{0x1d15f,0x1d170}}},
{0x1d163,{{0x1d15f,0x1d171}}},
{0x1d164,{{0x1d15f,0x1d172}}},
{0x1d1bb,{{0x1d1b9,0x1d165}}},
{0x1d1bc,{{0x1d1ba,0x1d165}}},
{0x1d1bd,{{0x1d1bb,0x1d16e}}},
{0x1d1be,{{0x1d1bc,0x1d16e}}},
{0x1d1bf,{{0x1d1bb,0x1d16f}}},
{0x1d1c0,{{0x1d1bc,0x1d16f}}},
{0x2f800,{{0x4e3d,0x0}}},
{0x2f801,{{0x4e38,0x0}}},
{0x2f802,{{0x4e41,0x0}}},
{0x2f803,{{0x20122,0x0}}},
{0x2f804,{{0x4f60,0x0}}},
{0x2f805,{{0x4fae,0x0}}},
{0x2f806,{{0x4fbb,0x0}}},
{0x2f807,{{0x5002,0x0}}},
{0x2f808,{{0x507a,0x0}}},
{0x2f809,{{0x5099,0x0}}},
{0x2f80a,{{0x50e7,0x0}}},
{0x2f80b,{{0x50cf,0x0}}},
{0x2f80c,{{0x349e,0x0}}},
{0x2f80d,{{0x2063a,0x0}}},
{0x2f80e,{{0x514d,0x0}}},
{0x2f80f,{{0x5154,0x0}}},
{0x2f810,{{0x5164,0x0}}},
{0x2f811,{{0x5177,0x0}}},
{0x2f812,{{0x2051c,0x0}}},
{0x2f813,{{0x34b9,0x0}}},
{0x2f814,{{0x5167,0x0}}},
{0x2f815,{{0x518d,0x0}}},
{0x2f816,{{0x2054b,0x0}}},
{0x2f817,{{0x5197,0x0}}},
{0x2f818,{{0x51a4,0x0}}},
{0x2f819,{{0x4ecc,0x0}}},
{0x2f81a,{{0x51ac,0x0}}},
{0x2f81b,{{0x51b5,0x0}}},
{0x2f81c,{{0x291df,0x0}}},
{0x2f81d,{{0x51f5,0x0}}},
{0x2f81e,{{0x5203,0x0}}},
{0x2f81f,{{0x34df,0x0}}},
{0x2f820,{{0x523b,0x0}}},
{0x2f821,{{0x5246,0x0}}},
{0x2f822,{{0x5272,0x0}}},
{0x2f823,{{0x5277,0x0}}},
{0x2f824,{{0x3515,0x0}}},
{0x2f825,{{0x52c7,0x0}}},
{0x2f826,{{0x52c9,0x0}}},
{0x2f827,{{0x52e4,0x0}}},
{0x2f828,{{0x52fa,0x0}}},
{0x2f829,{{0x5305,0x0}}},
{0x2f82a,{{0x5306,0x0}}},
{0x2f82b,{{0x5317,0x0}}},
{0x2f82c,{{0x5349,0x0}}},
{0x2f82d,{{0x5351,0x0}}},
{0x2f82e,{{0x535a,0x0}}},
{0x2f82f,{{0x5373,0x0}}},
{0x2f830,{{0x537d,0x0}}},
{0x2f831,{{0x537f,0x0}}},
{0x2f832,{{0x537f,0x0}}},
{0x2f833,{{0x537f,0x0}}},
{0x2f834,{{0x20a2c,0x0}}},
{0x2f835,{{0x7070,0x0}}},
{0x2f836,{{0x53ca,0x0}}},
{0x2f837,{{0x53df,0x0}}},
{0x2f838,{{0x20b63,0x0}}},
{0x2f839,{{0x53eb,0x0}}},
{0x2f83a,{{0x53f1,0x0}}},
{0x2f83b,{{0x5406,0x0}}},
{0x2f83c,{{0x549e,0x0}}},
{0x2f83d,{{0x5438,0x0}}},
{0x2f83e,{{0x5448,0x0}}},
{0x2f83f,{{0x5468,0x0}}},
{0x2f840,{{0x54a2,0x0}}},
{0x2f841,{{0x54f6,0x0}}},
{0x2f842,{{0x5510,0x0}}},
{0x2f843,{{0x5553,0x0}}},
{0x2f844,{{0x5563,0x0}}},
{0x2f845,{{0x5584,0x0}}},
{0x2f846,{{0x5584,0x0}}},
{0x2f847,{{0x5599,0x0}}},
{0x2f848,{{0x55ab,0x0}}},
{0x2f849,{{0x55b3,0x0}}},
{0x2f84a,{{0x55c2,0x0}}},
{0x2f84b,{{0x5716,0x0}}},
{0x2f84c,{{0x5606,0x0}}},
{0x2f84d,{{0x5717,0x0}}},
{0x2f84e,{{0x5651,0x0}}},
{0x2f84f,{{0x5674,0x0}}},
{0x2f850,{{0x5207,0x0}}},
{0x2f851,{{0x58ee,0x0}}},
{0x2f852,{{0x57ce,0x0}}},
{0x2f853,{{0x57f4,0x0}}},
{0x2f854,{{0x580d,0x0}}},
{0x2f855,{{0x578b,0x0}}},
{0x2f856,{{0x5832,0x0}}},
{0x2f857,{{0x5831,0x0}}},
{0x2f858,{{0x58ac,0x0}}},
{0x2f859,{{0x214e4,0x0}}},
{0x2f85a,{{0x58f2,0x0}}},
{0x2f85b,{{0x58f7,0x0}}},
{0x2f85c,{{0x5906,0x0}}},
{0x2f85d,{{0x591a,0x0}}},
{0x2f85e,{{0x5922,0x0}}},
{0x2f85f,{{0x5962,0x0}}},
{0x2f860,{{0x216a8,0x0}}},
{0x2f861,{{0x216ea,0x0}}},
{0x2f862,{{0x59ec,0x0}}},
{0x2f863,{{0x5a1b,0x0}}},
{0x2f864,{{0x5a27,0x0}}},
{0x2f865,{{0x59d8,0x0}}},
{0x2f866,{{0x5a66,0x0}}},
{0x2f867,{{0x36ee,0x0}}},
{0x2f868,{{0x36fc,0x0}}},
{0x2f869,{{0x5b08,0x0}}},
{0x2f86a,{{0x5b3e,0x0}}},
{0x2f86b,{{0x5b3e,0x0}}},
{0x2f86c,{{0x219c8,0x0}}},
{0x2f86d,{{0x5bc3,0x0}}},
{0x2f86e,{{0x5bd8,0x0}}},
{0x2f86f,{{0x5be7,0x0}}},
{0x2f870,{{0x5bf3,0x0}}},
{0x2f871,{{0x21b18,0x0}}},
{0x2f872,{{0x5bff,0x0}}},
{0x2f873,{{0x5c06,0x0}}},
{0x2f874,{{0x5f53,0x0}}},
{0x2f875,{{0x5c22,0x0}}},
{0x2f876,{{0x3781,0x0}}},
{0x2f877,{{0x5c60,0x0}}},
{0x2f878,{{0x5c6e,0x0}}},
{0x2f879,{{0x5cc0,0x0}}},
{0x2f87a,{{0x5c8d,0x0}}},
{0x2f87b,{{0x21de4,0x0}}},
{0x2f87c,{{0x5d43,0x0}}},
{0x2f87d,{{0x21de6,0x0}}},
{0x2f87e,{{0x5d6e,0x0}}},
{0x2f87f,{{0x5d6b,0x0}}},
{0x2f880,{{0x5d7c,0x0}}},
{0x2f881,{{0x5de1,0x0}}},
{0x2f882,{{0x5de2,0x0}}},
{0x2f883,{{0x382f,0x0}}},
{0x2f884,{{0x5dfd,0x0}}},
{0x2f885,{{0x5e28,0x0}}},
{0x2f886,{{0x5e3d,0x0}}},
{0x2f887,{{0x5e69,0x0}}},
{0x2f888,{{0x3862,0x0}}},
{0x2f889,{{0x22183,0x0}}},
{0x2f88a,{{0x387c,0x0}}},
{0x2f88b,{{0x5eb0,0x0}}},
{0x2f88c,{{0x5eb3,0x0}}},
{0x2f88d,{{0x5eb6,0x0}}},
{0x2f88e,{{0x5eca,0x0}}},
{0x2f88f,{{0x2a392,0x0}}},
{0x2f890,{{0x5efe,0x0}}},
{0x2f891,{{0x22331,0x0}}},
{0x2f892,{{0x22331,0x0}}},
{0x2f893,{{0x8201,0x0}}},
{0x2f894,{{0x5f22,0x0}}},
{0x2f895,{{0x5f22,0x0}}},
{0x2f896,{{0x38c7,0x0}}},
{0x2f897,{{0x232b8,0x0}}},
{0x2f898,{{0x261da,0x0}}},
{0x2f899,{{0x5f62,0x0}}},
{0x2f89a,{{0x5f6b,0x0}}},
{0x2f89b,{{0x38e3,0x0}}},
{0x2f89c,{{0x5f9a,0x0}}},
{0x2f89d,{{0x5fcd,0x0}}},
{0x2f89e,{{0x5fd7,0x0}}},
{0x2f89f,{{0x5ff9,0x0}}},
{0x2f8a0,{{0x6081,0x0}}},
{0x2f8a1,{{0x393a,0x0}}},
{0x2f8a2,{{0x391c,0x0}}},
{0x2f8a3,{{0x6094,0x0}}},
{0x2f8a4,{{0x226d4,0x0}}},
{0x2f8a5,{{0x60c7,0x0}}},
{0x2f8a6,{{0x6148,0x0}}},
{0x2f8a7,{{0x614c,0x0}}},
{0x2f8a8,{{0x614e,0x0}}},
{0x2f8a9,{{0x614c,0x0}}},
{0x2f8aa,{{0x617a,0x0}}},
{0x2f8ab,{{0x618e,0x0}}},
{0x2f8ac,{{0x61b2,0x0}}},
{0x2f8ad,{{0x61a4,0x0}}},
{0x2f8ae,{{0x61af,0x0}}},
{0x2f8af,{{0x61de,0x0}}},
{0x2f8b0,{{0x61f2,0x0}}},
{0x2f8b1,{{0x61f6,0x0}}},
{0x2f8b2,{{0x6210,0x0}}},
{0x2f8b3,{{0x621b,0x0}}},
{0x2f8b4,{{0x625d,0x0}}},
{0x2f8b5,{{0x62b1,0x0}}},
{0x2f8b6,{{0x62d4,0x0}}},
{0x2f8b7,{{0x6350,0x0}}},
{0x2f8b8,{{0x22b0c,0x0}}},
{0x2f8b9,{{0x633d,0x0}}},
{0x2f8ba,{{0x62fc,0x0}}},
{0x2f8bb,{{0x6368,0x0}}},
{0x2f8bc,{{0x6383,0x0}}},
{0x2f8bd,{{0x63e4,0x0}}},
{0x2f8be,{{0x22bf1,0x0}}},
{0x2f8bf,{{0x6422,0x0}}},
{0x2f8c0,{{0x63c5,0x0}}},
{0x2f8c1,{{0x63a9,0x0}}},
{0x2f8c2,{{0x3a2e,0x0}}},
{0x2f8c3,{{0x6469,0x0}}},
{0x2f8c4,{{0x647e,0x0}}},
{0x2f8c5,{{0x649d,0x0}}},
{0x2f8c6,{{0x6477,0x0}}},
{0x2f8c7,{{0x3a6c,0x0}}},
{0x2f8c8,{{0x654f,0x0}}},
{0x2f8c9,{{0x656c,0x0}}},
{0x2f8ca,{{0x2300a,0x0}}},
{0x2f8cb,{{0x65e3,0x0}}},
{0x2f8cc,{{0x66f8,0x0}}},
{0x2f8cd,{{0x6649,0x0}}},
{0x2f8ce,{{0x3b19,0x0}}},
{0x2f8cf,{{0x6691,0x0}}},
{0x2f8d0,{{0x3b08,0x0}}},
{0x2f8d1,{{0x3ae4,0x0}}},
{0x2f8d2,{{0x5192,0x0}}},
{0x2f8d3,{{0x5195,0x0}}},
{0x2f8d4,{{0x6700,0x0}}},
{0x2f8d5,{{0x669c,0x0}}},
{0x2f8d6,{{0x80ad,0x0}}},
{0x2f8d7,{{0x43d9,0x0}}},
{0x2f8d8,{{0x6717,0x0}}},
{0x2f8d9,{{0x671b,0x0}}},
{0x2f8da,{{0x6721,0x0}}},
{0x2f8db,{{0x675e,0x0}}},
{0x2f8dc,{{0x6753,0x0}}},
{0x2f8dd,{{0x233c3,0x0}}},
{0x2f8de,{{0x3b49,0x0}}},
{0x2f8df,{{0x67fa,0x0}}},
{0x2f8e0,{{0x6785,0x0}}},
{0x2f8e1,{{0x6852,0x0}}},
{0x2f8e2,{{0x6885,0x0}}},
{0x2f8e3,{{0x2346d,0x0}}},
{0x2f8e4,{{0x688e,0x0}}},
{0x2f8e5,{{0x681f,0x0}}},
{0x2f8e6,{{0x6914,0x0}}},
{0x2f8e7,{{0x3b9d,0x0}}},
{0x2f8e8,{{0x6942,0x0}}},
{0x2f8e9,{{0x69a3,0x0}}},
{0x2f8ea,{{0x69ea,0x0}}},
{0x2f8eb,{{0x6aa8,0x0}}},
{0x2f8ec,{{0x236a3,0x0}}},
{0x2f8ed,{{0x6adb,0x0}}},
{0x2f8ee,{{0x3c18,0x0}}},
{0x2f8ef,{{0x6b21,0x0}}},
{0x2f8f0,{{0x238a7,0x0}}},
{0x2f8f1,{{0x6b54,0x0}}},
{0x2f8f2,{{0x3c4e,0x0}}},
{0x2f8f3,{{0x6b72,0x0}}},
{0x2f8f4,{{0x6b9f,0x0}}},
{0x2f8f5,{{0x6bba,0x0}}},
{0x2f8f6,{{0x6bbb,0x0}}},
{0x2f8f7,{{0x23a8d,0x0}}},
{0x2f8f8,{{0x21d0b,0x0}}},
{0x2f8f9,{{0x23afa,0x0}}},
{0x2f8fa,{{0x6c4e,0x0}}},
{0x2f8fb,{{0x23cbc,0x0}}},
{0x2f8fc,{{0x6cbf,0x0}}},
{0x2f8fd,{{0x6ccd,0x0}}},
{0x2f8fe,{{0x6c67,0x0}}},
{0x2f8ff,{{0x6d16,0x0}}},
{0x2f900,{{0x6d3e,0x0}}},
{0x2f901,{{0x6d77,0x0}}},
{0x2f902,{{0x6d41,0x0}}},
{0x2f903,{{0x6d69,0x0}}},
{0x2f904,{{0x6d78,0x0}}},
{0x2f905,{{0x6d85,0x0}}},
{0x2f906,{{0x23d1e,0x0}}},
{0x2f907,{{0x6d34,0x0}}},
{0x2f908,{{0x6e2f,0x0}}},
{0x2f909,{{0x6e6e,0x0}}},
{0x2f90a,{{0x3d33,0x0}}},
{0x2f90b,{{0x6ecb,0x0}}},
{0x2f90c,{{0x6ec7,0x0}}},
{0x2f90d,{{0x23ed1,0x0}}},
{0x2f90e,{{0x6df9,0x0}}},
{0x2f90f,{{0x6f6e,0x0}}},
{0x2f910,{{0x23f5e,0x0}}},
{0x2f911,{{0x23f8e,0x0}}},
{0x2f912,{{0x6fc6,0x0}}},
{0x2f913,{{0x7039,0x0}}},
{0x2f914,{{0x701e,0x0}}},
{0x2f915,{{0x701b,0x0}}},
{0x2f916,{{0x3d96,0x0}}},
{0x2f917,{{0x704a,0x0}}},
{0x2f918,{{0x707d,0x0}}},
{0x2f919,{{0x7077,0x0}}},
{0x2f91a,{{0x70ad,0x0}}},
{0x2f91b,{{0x20525,0x0}}},
{0x2f91c,{{0x7145,0x0}}},
{0x2f91d,{{0x24263,0x0}}},
{0x2f91e,{{0x719c,0x0}}},
{0x2f91f,{{0x243ab,0x0}}},
{0x2f920,{{0x7228,0x0}}},
{0x2f921,{{0x7235,0x0}}},
{0x2f922,{{0x7250,0x0}}},
{0x2f923,{{0x24608,0x0}}},
{0x2f924,{{0x7280,0x0}}},
{0x2f925,{{0x7295,0x0}}},
{0x2f926,{{0x24735,0x0}}},
{0x2f927,{{0x24814,0x0}}},
{0x2f928,{{0x737a,0x0}}},
{0x2f929,{{0x738b,0x0}}},
{0x2f92a,{{0x3eac,0x0}}},
{0x2f92b,{{0x73a5,0x0}}},
{0x2f92c,{{0x3eb8,0x0}}},
{0x2f92d,{{0x3eb8,0x0}}},
{0x2f92e,{{0x7447,0x0}}},
{0x2f92f,{{0x745c,0x0}}},
{0x2f930,{{0x7471,0x0}}},
{0x2f931,{{0x7485,0x0}}},
{0x2f932,{{0x74ca,0x0}}},
{0x2f933,{{0x3f1b,0x0}}},
{0x2f934,{{0x7524,0x0}}},
{0x2f935,{{0x24c36,0x0}}},
{0x2f936,{{0x753e,0x0}}},
{0x2f937,{{0x24c92,0x0}}},
{0x2f938,{{0x7570,0x0}}},
{0x2f939,{{0x2219f,0x0}}},
{0x2f93a,{{0x7610,0x0}}},
{0x2f93b,{{0x24fa1,0x0}}},
{0x2f93c,{{0x24fb8,0x0}}},
{0x2f93d,{{0x25044,0x0}}},
{0x2f93e,{{0x3ffc,0x0}}},
{0x2f93f,{{0x4008,0x0}}},
{0x2f940,{{0x76f4,0x0}}},
{0x2f941,{{0x250f3,0x0}}},
{0x2f942,{{0x250f2,0x0}}},
{0x2f943,{{0x25119,0x0}}},
{0x2f944,{{0x25133,0x0}}},
{0x2f945,{{0x771e,0x0}}},
{0x2f946,{{0x771f,0x0}}},
{0x2f947,{{0x771f,0x0}}},
{0x2f948,{{0x774a,0x0}}},
{0x2f949,{{0x4039,0x0}}},
{0x2f94a,{{0x778b,0x0}}},
{0x2f94b,{{0x4046,0x0}}},
{0x2f94c,{{0x4096,0x0}}},
{0x2f94d,{{0x2541d,0x0}}},
{0x2f94e,{{0x784e,0x0}}},
{0x2f94f,{{0x788c,0x0}}},
{0x2f950,{{0x78cc,0x0}}},
{0x2f951,{{0x40e3,0x0}}},
{0x2f952,{{0x25626,0x0}}},
{0x2f953,{{0x7956,0x0}}},
{0x2f954,{{0x2569a,0x0}}},
{0x2f955,{{0x256c5,0x0}}},
{0x2f956,{{0x798f,0x0}}},
{0x2f957,{{0x79eb,0x0}}},
{0x2f958,{{0x412f,0x0}}},
{0x2f959,{{0x7a40,0x0}}},
{0x2f95a,{{0x7a4a,0x0}}},
{0x2f95b,{{0x7a4f,0x0}}},
{0x2f95c,{{0x2597c,0x0}}},
{0x2f95d,{{0x25aa7,0x0}}},
{0x2f95e,{{0x25aa7,0x0}}},
{0x2f95f,{{0x7aee,0x0}}},
{0x2f960,{{0x4202,0x0}}},
{0x2f961,{{0x25bab,0x0}}},
{0x2f962,{{0x7bc6,0x0}}},
{0x2f963,{{0x7bc9,0x0}}},
{0x2f964,{{0x4227,0x0}}},
{0x2f965,{{0x25c80,0x0}}},
{0x2f966,{{0x7cd2,0x0}}},
{0x2f967,{{0x42a0,0x0}}},
{0x2f968,{{0x7ce8,0x0}}},
{0x2f969,{{0x7ce3,0x0}}},
{0x2f96a,{{0x7d00,0x0}}},
{0x2f96b,{{0x25f86,0x0}}},
{0x2f96c,{{0x7d63,0x0}}},
{0x2f96d,{{0x4301,0x0}}},
{0x2f96e,{{0x7dc7,0x0}}},
{0x2f96f,{{0x7e02,0x0}}},
{0x2f970,{{0x7e45,0x0}}},
{0x2f971,{{0x4334,0x0}}},
{0x2f972,{{0x26228,0x0}}},
{0x2f973,{{0x26247,0x0}}},
{0x2f974,{{0x4359,0x0}}},
{0x2f975,{{0x262d9,0x0}}},
{0x2f976,{{0x7f7a,0x0}}},
{0x2f977,{{0x2633e,0x0}}},
{0x2f978,{{0x7f95,0x0}}},
{0x2f979,{{0x7ffa,0x0}}},
{0x2f97a,{{0x8005,0x0}}},
{0x2f97b,{{0x264da,0x0}}},
{0x2f97c,{{0x26523,0x0}}},
{0x2f97d,{{0x8060,0x0}}},
{0x2f97e,{{0x265a8,0x0}}},
{0x2f97f,{{0x8070,0x0}}},
{0x2f980,{{0x2335f,0x0}}},
{0x2f981,{{0x43d5,0x0}}},
{0x2f982,{{0x80b2,0x0}}},
{0x2f983,{{0x8103,0x0}}},
{0x2f984,{{0x440b,0x0}}},
{0x2f985,{{0x813e,0x0}}},
{0x2f986,{{0x5ab5,0x0}}},
{0x2f987,{{0x267a7,0x0}}},
{0x2f988,{{0x267b5,0x0}}},
{0x2f989,{{0x23393,0x0}}},
{0x2f98a,{{0x2339c,0x0}}},
{0x2f98b,{{0x8201,0x0}}},
{0x2f98c,{{0x8204,0x0}}},
{0x2f98d,{{0x8f9e,0x0}}},
{0x2f98e,{{0x446b,0x0}}},
{0x2f98f,{{0x8291,0x0}}},
{0x2f990,{{0x828b,0x0}}},
{0x2f991,{{0x829d,0x0}}},
{0x2f992,{{0x52b3,0x0}}},
{0x2f993,{{0x82b1,0x0}}},
{0x2f994,{{0x82b3,0x0}}},
{0x2f995,{{0x82bd,0x0}}},
{0x2f996,{{0x82e6,0x0}}},
{0x2f997,{{0x26b3c,0x0}}},
{0x2f998,{{0x82e5,0x0}}},
{0x2f999,{{0x831d,0x0}}},
{0x2f99a,{{0x8363,0x0}}},
{0x2f99b,{{0x83ad,0x0}}},
{0x2f99c,{{0x8323,0x0}}},
{0x2f99d,{{0x83bd,0x0}}},
{0x2f99e,{{0x83e7,0x0}}},
{0x2f99f,{{0x8457,0x0}}},
{0x2f9a0,{{0x8353,0x0}}},
{0x2f9a1,{{0x83ca,0x0}}},
{0x2f9a2,{{0x83cc,0x0}}},
{0x2f9a3,{{0x83dc,0x0}}},
{0x2f9a4,{{0x26c36,0x0}}},
{0x2f9a5,{{0x26d6b,0x0}}},
{0x2f9a6,{{0x26cd5,0x0}}},
{0x2f9a7,{{0x452b,0x0}}},
{0x2f9a8,{{0x84f1,0x0}}},
{0x2f9a9,{{0x84f3,0x0}}},
{0x2f9aa,{{0x8516,0x0}}},
{0x2f9ab,{{0x273ca,0x0}}},
{0x2f9ac,{{0x8564,0x0}}},
{0x2f9ad,{{0x26f2c,0x0}}},
{0x2f9ae,{{0x455d,0x0}}},
{0x2f9af,{{0x4561,0x0}}},
{0x2f9b0,{{0x26fb1,0x0}}},
{0x2f9b1,{{0x270d2,0x0}}},
{0x2f9b2,{{0x456b,0x0}}},
{0x2f9b3,{{0x8650,0x0}}},
{0x2f9b4,{{0x865c,0x0}}},
{0x2f9b5,{{0x8667,0x0}}},
{0x2f9b6,{{0x8669,0x0}}},
{0x2f9b7,{{0x86a9,0x0}}},
{0x2f9b8,{{0x8688,0x0}}},
{0x2f9b9,{{0x870e,0x0}}},
{0x2f9ba,{{0x86e2,0x0}}},
{0x2f9bb,{{0x8779,0x0}}},
{0x2f9bc,{{0x8728,0x0}}},
{0x2f9bd,{{0x876b,0x0}}},
{0x2f9be,{{0x8786,0x0}}},
{0x2f9bf,{{0x45d7,0x0}}},
{0x2f9c0,{{0x87e1,0x0}}},
{0x2f9c1,{{0x8801,0x0}}},
{0x2f9c2,{{0x45f9,0x0}}},
{0x2f9c3,{{0x8860,0x0}}},
{0x2f9c4,{{0x8863,0x0}}},
{0x2f9c5,{{0x27667,0x0}}},
{0x2f9c6,{{0x88d7,0x0}}},
{0x2f9c7,{{0x88de,0x0}}},
{0x2f9c8,{{0x4635,0x0}}},
{0x2f9c9,{{0x88fa,0x0}}},
{0x2f9ca,{{0x34bb,0x0}}},
{0x2f9cb,{{0x278ae,0x0}}},
{0x2f9cc,{{0x27966,0x0}}},
{0x2f9cd,{{0x46be,0x0}}},
{0x2f9ce,{{0x46c7,0x0}}},
{0x2f9cf,{{0x8aa0,0x0}}},
{0x2f9d0,{{0x8aed,0x0}}},
{0x2f9d1,{{0x8b8a,0x0}}},
{0x2f9d2,{{0x8c55,0x0}}},
{0x2f9d3,{{0x27ca8,0x0}}},
{0x2f9d4,{{0x8cab,0x0}}},
{0x2f9d5,{{0x8cc1,0x0}}},
{0x2f9d6,{{0x8d1b,0x0}}},
{0x2f9d7,{{0x8d77,0x0}}},
{0x2f9d8,{{0x27f2f,0x0}}},
{0x2f9d9,{{0x20804,0x0}}},
{0x2f9da,{{0x8dcb,0x0}}},
{0x2f9db,{{0x8dbc,0x0}}},
{0x2f9dc,{{0x8df0,0x0}}},
{0x2f9dd,{{0x208de,0x0}}},
{0x2f9de,{{0x8ed4,0x0}}},
{0x2f9df,{{0x8f38,0x0}}},
{0x2f9e0,{{0x285d2,0x0}}},
{0x2f9e1,{{0x285ed,0x0}}},
{0x2f9e2,{{0x9094,0x0}}},
{0x2f9e3,{{0x90f1,0x0}}},
{0x2f9e4,{{0x9111,0x0}}},
{0x2f9e5,{{0x2872e,0x0}}},
{0x2f9e6,{{0x911b,0x0}}},
{0x2f9e7,{{0x9238,0x0}}},
{0x2f9e8,{{0x92d7,0x0}}},
{0x2f9e9,{{0x92d8,0x0}}},
{0x2f9ea,{{0x927c,0x0}}},
{0x2f9eb,{{0x93f9,0x0}}},
{0x2f9ec,{{0x9415,0x0}}},
{0x2f9ed,{{0x28bfa,0x0}}},
{0x2f9ee,{{0x958b,0x0}}},
{0x2f9ef,{{0x4995,0x0}}},
{0x2f9f0,{{0x95b7,0x0}}},
{0x2f9f1,{{0x28d77,0x0}}},
{0x2f9f2,{{0x49e6,0x0}}},
{0x2f9f3,{{0x96c3,0x0}}},
{0x2f9f4,{{0x5db2,0x0}}},
{0x2f9f5,{{0x9723,0x0}}},
{0x2f9f6,{{0x29145,0x0}}},
{0x2f9f7,{{0x2921a,0x0}}},
{0x2f9f8,{{0x4a6e,0x0}}},
{0x2f9f9,{{0x4a76,0x0}}},
{0x2f9fa,{{0x97e0,0x0}}},
{0x2f9fb,{{0x2940a,0x0}}},
{0x2f9fc,{{0x4ab2,0x0}}},
{0x2f9fd,{{0x29496,0x0}}},
{0x2f9fe,{{0x980b,0x0}}},
{0x2f9ff,{{0x980b,0x0}}},
{0x2fa00,{{0x9829,0x0}}},
{0x2fa01,{{0x295b6,0x0}}},
{0x2fa02,{{0x98e2,0x0}}},
{0x2fa03,{{0x4b33,0x0}}},
{0x2fa04,{{0x9929,0x0}}},
{0x2fa05,{{0x99a7,0x0}}},
{0x2fa06,{{0x99c2,0x0}}},
{0x2fa07,{{0x99fe,0x0}}},
{0x2fa08,{{0x4bce,0x0}}},
{0x2fa09,{{0x29b30,0x0}}},
{0x2fa0a,{{0x9b12,0x0}}},
{0x2fa0b,{{0x9c40,0x0}}},
{0x2fa0c,{{0x9cfd,0x0}}},
{0x2fa0d,{{0x4cce,0x0}}},
{0x2fa0e,{{0x4ced,0x0}}},
{0x2fa0f,{{0x9d67,0x0}}},
{0x2fa10,{{0x2a0ce,0x0}}},
{0x2fa11,{{0x4cf8,0x0}}},
{0x2fa12,{{0x2a105,0x0}}},
{0x2fa13,{{0x2a20e,0x0}}},
{0x2fa14,{{0x2a291,0x0}}},
{0x2fa15,{{0x9ebb,0x0}}},
{0x2fa16,{{0x4d56,0x0}}},
{0x2fa17,{{0x9ef9,0x0}}},
{0x2fa18,{{0x9efe,0x0}}},
{0x2fa19,{{0x9f05,0x0}}},
{0x2fa1a,{{0x9f0f,0x0}}},
{0x2fa1b,{{0x9f16,0x0}}},
{0x2fa1c,{{0x9f3b,0x0}}},
{0x2fa1d,{{0x2a600,0x0}}},
}};

const TableView<char32_t, std::array<char32_t, 2>> canonical_table {&canonical_array[0], &canonical_array[0] + canonical_array.size()};

const std::array<KeyValue<char32_t, std::array<char32_t, 3>>, 3572> short_compatibility_array = {{
{0xa0,{{0x20,0x0,0x0}}},
{0xa8,{{0x20,0x308,0x0}}},
{0xaa,{{0x61,0x0,0x0}}},
{0xaf,{{0x20,0x304,0x0}}},
{0xb2,{{0x32,0x0,0x0}}},
{0xb3,{{0x33,0x0,0x0}}},
{0xb4,{{0x20,0x301,0x0}}},
{0xb5,{{0x3bc,0x0,0x0}}},
{0xb8,{{0x20,0x327,0x0}}},
{0xb9,{{0x31,0x0,0x0}}},
{0xba,{{0x6f,0x0,0x0}}},
{0xbc,{{0x31,0x2044,0x34}}},
{0xbd,{{0x31,0x2044,0x32}}},
{0xbe,{{0x33,0x2044,0x34}}},
{0x132,{{0x49,0x4a,0x0}}},
{0x133,{{0x69,0x6a,0x0}}},
{0x13f,{{0x4c,0xb7,0x0}}},
{0x140,{{0x6c,0xb7,0x0}}},
{0x149,{{0x2bc,0x6e,0x0}}},
{0x17f,{{0x73,0x0,0x0}}},
{0x1c4,{{0x44,0x17d,0x0}}},
{0x1c5,{{0x44,0x17e,0x0}}},
{0x1c6,{{0x64,0x17e,0x0}}},
{0x1c7,{{0x4c,0x4a,0x0}}},
{0x1c8,{{0x4c,0x6a,0x0}}},
{0x1c9,{{0x6c,0x6a,0x0}}},
{0x1ca,{{0x4e,0x4a,0x0}}},
{0x1cb,{{0x4e,0x6a,0x0}}},
{0x1cc,{{0x6e,0x6a,0x0}}},
{0x1f1,{{0x44,0x5a,0x0}}},
{0x1f2,{{0x44,0x7a,0x0}}},
{0x1f3,{{0x64,0x7a,0x0}}},
{0x2b0,{{0x68,0x0,0x0}}},
{0x2b1,{{0x266,0x0,0x0}}},
{0x2b2,{{0x6a,0x0,0x0}}},
{0x2b3,{{0x72,0x0,0x0}}},
{0x2b4,{{0x279,0x0,0x0}}},
{0x2b5,{{0x27b,0x0,0x0}}},
{0x2b6,{{0x281,0x0,0x0}}},
{0x2b7,{{0x77,0x0,0x0}}},
{0x2b8,{{0x79,0x0,0x0}}},
{0x2d8,{{0x20,0x306,0x0}}},
{0x2d9,{{0x20,0x307,0x0}}},
{0x2da,{{0x20,0x30a,0x0}}},
{0x2db,{{0x20,0x328,0x0}}},
{0x2dc,{{0x20,0x303,0x0}}},
{0x2dd,{{0x20,0x30b,0x0}}},
{0x2e0,{{0x263,0x0,0x0}}},
{0x2e1,{{0x6c,0x0,0x0}}},
{0x2e2,{{0x73,0x0,0x0}}},
{0x2e3,{{0x78,0x0,0x0}}},
{0x2e4,{{0x295,0x0,0x0}}},
{0x37a,{{0x20,0x345,0x0}}},
{0x384,{{0x20,0x301,0x0}}},
{0x3d0,{{0x3b2,0x0,0x0}}},
{0x3d1,{{0x3b8,0x0,0x0}}},
{0x3d2,{{0x3a5,0x0,0x0}}},
{0x3d5,{{0x3c6,0x0,0x0}}},
{0x3d6,{{0x3c0,0x0,0x0}}},
{0x3f0,{{0x3ba,0x0,0x0}}},
{0x3f1,{{0x3c1,0x0,0x0}}},
{0x3f2,{{0x3c2,0x0,0x0}}},
{0x3f4,{{0x398,0x0,0x0}}},
{0x3f5,{{0x3b5,0x0,0x0}}},
{0x3f9,{{0x3a3,0x0,0x0}}},
{0x587,{{0x565,0x582,0x0}}},
{0x675,{{0x627,0x674,0x0}}},
{0x676,{{0x648,0x674,0x0}}},
{0x677,{{0x6c7,0x674,0x0}}},
{0x678,{{0x64a,0x674,0x0}}},
{0xe33,{{0xe4d,0xe32,0x0}}},
{0xeb3,{{0xecd,0xeb2,0x0}}},
{0xedc,{{0xeab,0xe99,0x0}}},
{0xedd,{{0xeab,0xea1,0x0}}},
{0xf0c,{{0xf0b,0x0,0x0}}},
{0xf77,{{0xfb2,0xf81,0x0}}},
{0xf79,{{0xfb3,0xf81,0x0}}},
{0x10fc,{{0x10dc,0x0,0x0}}},
{0x1d2c,{{0x41,0x0,0x0}}},
{0x1d2d,{{0xc6,0x0,0x0}}},
{0x1d2e,{{0x42,0x0,0x0}}},
{0x1d30,{{0x44,0x0,0x0}}},
{0x1d31,{{0x45,0x0,0x0}}},
{0x1d32,{{0x18e,0x0,0x0}}},
{0x1d33,{{0x47,0x0,0x0}}},
{0x1d34,{{0x48,0x0,0x0}}},
{0x1d35,{{0x49,0x0,0x0}}},
{0x1d36,{{0x4a,0x0,0x0}}},
{0x1d37,{{0x4b,0x0,0x0}}},
{0x1d38,{{0x4c,0x0,0x0}}},
{0x1d39,{{0x4d,0x0,0x0}}},
{0x1d3a,{{0x4e,0x0,0x0}}},
{0x1d3c,{{0x4f,0x0,0x0}}},
{0x1d3d,{{0x222,0x0,0x0}}},
{0x1d3e,{{0x50,0x0,0x0}}},
{0x1d3f,{{0x52,0x0,0x0}}},
{0x1d40,{{0x54,0x0,0x0}}},
{0x1d41,{{0x55,0x0,0x0}}},
{0x1d42,{{0x57,0x0,0x0}}},
{0x1d43,{{0x61,0x0,0x0}}},
{0x1d44,{{0x250,0x0,0x0}}},
{0x1d45,{{0x251,0x0,0x0}}},
{0x1d46,{{0x1d02,0x0,0x0}}},
{0x1d47,{{0x62,0x0,0x0}}},
{0x1d48,{{0x64,0x0,0x0}}},
{0x1d49,{{0x65,0x0,0x0}}},
{0x1d4a,{{0x259,0x0,0x0}}},
{0x1d4b,{{0x25b,0x0,0x0}}},
{0x1d4c,{{0x25c,0x0,0x0}}},
{0x1d4d,{{0x67,0x0,0x0}}},
{0x1d4f,{{0x6b,0x0,0x0}}},
{0x1d50,{{0x6d,0x0,0x0}}},
{0x1d51,{{0x14b,0x0,0x0}}},
{0x1d52,{{0x6f,0x0,0x0}}},
{0x1d53,{{0x254,0x0,0x0}}},
{0x1d54,{{0x1d16,0x0,0x0}}},
{0x1d55,{{0x1d17,0x0,0x0}}},
{0x1d56,{{0x70,0x0,0x0}}},
{0x1d57,{{0x74,0x0,0x0}}},
{0x1d58,{{0x75,0x0,0x0}}},
{0x1d59,{{0x1d1d,0x0,0x0}}},
{0x1d5a,{{0x26f,0x0,0x0}}},
{0x1d5b,{{0x76,0x0,0x0}}},
{0x1d5c,{{0x1d25,0x0,0x0}}},
{0x1d5d,{{0x3b2,0x0,0x0}}},
{0x1d5e,{{0x3b3,0x0,0x0}}},
{0x1d5f,{{0x3b4,0x0,0x0}}},
{0x1d60,{{0x3c6,0x0,0x0}}},
{0x1d61,{{0x3c7,0x0,0x0}}},
{0x1d62,{{0x69,0x0,0x0}}},
{0x1d63,{{0x72,0x0,0x0}}},
{0x1d64,{{0x75,0x0,0x0}}},
{0x1d65,{{0x76,0x0,0x0}}},
{0x1d66,{{0x3b2,0x0,0x0}}},
{0x1d67,{{0x3b3,0x0,0x0}}},
{0x1d68,{{0x3c1,0x0,0x0}}},
{0x1d69,{{0x3c6,0x0,0x0}}},
{0x1d6a,{{0x3c7,0x0,0x0}}},
{0x1d78,{{0x43d,0x0,0x0}}},
{0x1d9b,{{0x252,0x0,0x0}}},
{0x1d9c,{{0x63,0x0,0x0}}},
{0x1d9d,{{0x255,0x0,0x0}}},
{0x1d9e,{{0xf0,0x0,0x0}}},
{0x1d9f,{{0x25c,0x0,0x0}}},
{0x1da0,{{0x66,0x0,0x0}}},
{0x1da1,{{0x25f,0x0,0x0}}},
{0x1da2,{{0x261,0x0,0x0}}},
{0x1da3,{{0x265,0x0,0x0}}},
{0x1da4,{{0x268,0x0,0x0}}},
{0x1da5,{{0x269,0x0,0x0}}},
{0x1da6,{{0x26a,0x0,0x0}}},
{0x1da7,{{0x1d7b,0x0,0x0}}},
{0x1da8,{{0x29d,0x0,0x0}}},
{0x1da9,{{0x26d,0x0,0x0}}},
{0x1daa,{{0x1d85,0x0,0x0}}},
{0x1dab,{{0x29f,0x0,0x0}}},
{0x1dac,{{0x271,0x0,0x0}}},
{0x1dad,{{0x270,0x0,0x0}}},
{0x1dae,{{0x272,0x0,0x0}}},
{0x1daf,{{0x273,0x0,0x0}}},
{0x1db0,{{0x274,0x0,0x0}}},
{0x1db1,{{0x275,0x0,0x0}}},
{0x1db2,{{0x278,0x0,0x0}}},
{0x1db3,{{0x282,0x0,0x0}}},
{0x1db4,{{0x283,0x0,0x0}}},
{0x1db5,{{0x1ab,0x0,0x0}}},
{0x1db6,{{0x289,0x0,0x0}}},
{0x1db7,{{0x28a,0x0,0x0}}},
{0x1db8,{{0x1d1c,0x0,0x0}}},
{0x1db9,{{0x28b,0x0,0x0}}},
{0x1dba,{{0x28c,0x0,0x0}}},
{0x1dbb,{{0x7a,0x0,0x0}}},
{0x1dbc,{{0x290,0x0,0x0}}},
{0x1dbd,{{0x291,0x0,0x0}}},
{0x1dbe,{{0x292,0x0,0x0}}},
{0x1dbf,{{0x3b8,0x0,0x0}}},
{0x1e9a,{{0x61,0x2be,0x0}}},
{0x1fbd,{{0x20,0x313,0x0}}},
{0x1fbf,{{0x20,0x313,0x0}}},
{0x1fc0,{{0x20,0x342,0x0}}},
{0x1ffe,{{0x20,0x314,0x0}}},
{0x2002,{{0x20,0x0,0x0}}},
{0x2003,{{0x20,0x0,0x0}}},
{0x2004,{{0x20,0x0,0x0}}},
{0x2005,{{0x20,0x0,0x0}}},
{0x2006,{{0x20,0x0,0x0}}},
{0x2007,{{0x20,0x0,0x0}}},
{0x2008,{{0x20,0x0,0x0}}},
{0x2009,{{0x20,0x0,0x0}}},
{0x200a,{{0x20,0x0,0x0}}},
{0x2011,{{0x2010,0x0,0x0}}},
{0x2017,{{0x20,0x333,0x0}}},
{0x2024,{{0x2e,0x0,0x0}}},
{0x2025,{{0x2e,0x2e,0x0}}},
{0x2026,{{0x2e,0x2e,0x2e}}},
{0x202f,{{0x20,0x0,0x0}}},
{0x2033,{{0x2032,0x2032,0x0}}},
{0x2034,{{0x2032,0x2032,0x2032}}},
{0x2036,{{0x2035,0x2035,0x0}}},
{0x2037,{{0x2035,0x2035,0x2035}}},
{0x203c,{{0x21,0x21,0x0}}},
{0x203e,{{0x20,0x305,0x0}}},
{0x2047,{{0x3f,0x3f,0x0}}},
{0x2048,{{0x3f,0x21,0x0}}},
{0x2049,{{0x21,0x3f,0x0}}},
{0x205f,{{0x20,0x0,0x0}}},
{0x2070,{{0x30,0x0,0x0}}},
{0x2071,{{0x69,0x0,0x0}}},
{0x2074,{{0x34,0x0,0x0}}},
{0x2075,{{0x35,0x0,0x0}}},
{0x2076,{{0x36,0x0,0x0}}},
{0x2077,{{0x37,0x0,0x0}}},
{0x2078,{{0x38,0x0,0x0}}},
{0x2079,{{0x39,0x0,0x0}}},
{0x207a,{{0x2b,0x0,0x0}}},
{0x207b,{{0x2212,0x0,0x0}}},
{0x207c,{{0x3d,0x0,0x0}}},
{0x207d,{{0x28,0x0,0x0}}},
{0x207e,{{0x29,0x0,0x0}}},
{0x207f,{{0x6e,0x0,0x0}}},
{0x2080,{{0x30,0x0,0x0}}},
{0x2081,{{0x31,0x0,0x0}}},
{0x2082,{{0x32,0x0,0x0}}},
{0x2083,{{0x33,0x0,0x0}}},
{0x2084,{{0x34,0x0,0x0}}},
{0x2085,{{0x35,0x0,0x0}}},
{0x2086,{{0x36,0x0,0x0}}},
{0x2087,{{0x37,0x0,0x0}}},
{0x2088,{{0x38,0x0,0x0}}},
{0x2089,{{0x39,0x0,0x0}}},
{0x208a,{{0x2b,0x0,0x0}}},
{0x208b,{{0x2212,0x0,0x0}}},
{0x208c,{{0x3d,0x0,0x0}}},
{0x208d,{{0x28,0x0,0x0}}},
{0x208e,{{0x29,0x0,0x0}}},
{0x2090,{{0x61,0x0,0x0}}},
{0x2091,{{0x65,0x0,0x0}}},
{0x2092,{{0x6f,0x0,0x0}}},
{0x2093,{{0x78,0x0,0x0}}},
{0x2094,{{0x259,0x0,0x0}}},
{0x2095,{{0x68,0x0,0x0}}},
{0x2096,{{0x6b,0x0,0x0}}},
{0x2097,{{0x6c,0x0,0x0}}},
{0x2098,{{0x6d,0x0,0x0}}},
{0x2099,{{0x6e,0x0,0x0}}},
{0x209a,{{0x70,0x0,0x0}}},
{0x209b,{{0x73,0x0,0x0}}},
{0x209c,{{0x74,0x0,0x0}}},
{0x20a8,{{0x52,0x73,0x0}}},
{0x2100,{{0x61,0x2f,0x63}}},
{0x2101,{{0x61,0x2f,0x73}}},
{0x2102,{{0x43,0x0,0x0}}},
{0x2103,{{0xb0,0x43,0x0}}},
{0x2105,{{0x63,0x2f,0x6f}}},
{0x2106,{{0x63,0x2f,0x75}}},
{0x2107,{{0x190,0x0,0x0}}},
{0x2109,{{0xb0,0x46,0x0}}},
{0x210a,{{0x67,0x0,0x0}}},
{0x210b,{{0x48,0x0,0x0}}},
{0x210c,{{0x48,0x0,0x0}}},
{0x210d,{{0x48,0x0,0x0}}},
{0x210e,{{0x68,0x0,0x0}}},
{0x210f,{{0x127,0x0,0x0}}},
{0x2110,{{0x49,0x0,0x0}}},
{0x2111,{{0x49,0x0,0x0}}},
{0x2112,{{0x4c,0x0,0x0}}},
{0x2113,{{0x6c,0x0,0x0}}},
{0x2115,{{0x4e,0x0,0x0}}},
{0x2116,{{0x4e,0x6f,0x0}}},
{0x2119,{{0x50,0x0,0x0}}},
{0x211a,{{0x51,0x0,0x0}}},
{0x211b,{{0x52,0x0,0x0}}},
{0x211c,{{0x52,0x0,0x0}}},
{0x211d,{{0x52,0x0,0x0}}},
{0x2120,{{0x53,0x4d,0x0}}},
{0x2121,{{0x54,0x45,0x4c}}},
{0x2122,{{0x54,0x4d,0x0}}},
{0x2124,{{0x5a,0x0,0x0}}},
{0x2128,{{0x5a,0x0,0x0}}},
{0x212c,{{0x42,0x0,0x0}}},
{0x212d,{{0x43,0x0,0x0}}},
{0x212f,{{0x65,0x0,0x0}}},
{0x2130,{{0x45,0x0,0x0}}},
{0x2131,{{0x46,0x0,0x0}}},
{0x2133,{{0x4d,0x0,0x0}}},
{0x2134,{{0x6f,0x0,0x0}}},
{0x2135,{{0x5d0,0x0,0x0}}},
{0x2136,{{0x5d1,0x0,0x0}}},
{0x2137,{{0x5d2,0x0,0x0}}},
{0x2138,{{0x5d3,0x0,0x0}}},
{0x2139,{{0x69,0x0,0x0}}},
{0x213b,{{0x46,0x41,0x58}}},
{0x213c,{{0x3c0,0x0,0x0}}},
{0x213d,{{0x3b3,0x0,0x0}}},
{0x213e,{{0x393,0x0,0x0}}},
{0x213f,{{0x3a0,0x0,0x0}}},
{0x2140,{{0x2211,0x0,0x0}}},
{0x2145,{{0x44,0x0,0x0}}},
{0x2146,{{0x64,0x0,0x0}}},
{0x2147,{{0x65,0x0,0x0}}},
{0x2148,{{0x69,0x0,0x0}}},
{0x2149,{{0x6a,0x0,0x0}}},
{0x2150,{{0x31,0x2044,0x37}}},
{0x2151,{{0x31,0x2044,0x39}}},
{0x2153,{{0x31,0x2044,0x33}}},
{0x2154,{{0x32,0x2044,0x33}}},
{0x2155,{{0x31,0x2044,0x35}}},
{0x2156,{{0x32,0x2044,0x35}}},
{0x2157,{{0x33,0x2044,0x35}}},
{0x2158,{{0x34,0x2044,0x35}}},
{0x2159,{{0x31,0x2044,0x36}}},
{0x215a,{{0x35,0x2044,0x36}}},
{0x215b,{{0x31,0x2044,0x38}}},
{0x215c,{{0x33,0x2044,0x38}}},
{0x215d,{{0x35,0x2044,0x38}}},
{0x215e,{{0x37,0x2044,0x38}}},
{0x215f,{{0x31,0x2044,0x0}}},
{0x2160,{{0x49,0x0,0x0}}},
{0x2161,{{0x49,0x49,0x0}}},
{0x2162,{{0x49,0x49,0x49}}},
{0x2163,{{0x49,0x56,0x0}}},
{0x2164,{{0x56,0x0,0x0}}},
{0x2165,{{0x56,0x49,0x0}}},
{0x2166,{{0x56,0x49,0x49}}},
{0x2168,{{0x49,0x58,0x0}}},
{0x2169,{{0x58,0x0,0x0}}},
{0x216a,{{0x58,0x49,0x0}}},
{0x216b,{{0x58,0x49,0x49}}},
{0x216c,{{0x4c,0x0,0x0}}},
{0x216d,{{0x43,0x0,0x0}}},
{0x216e,{{0x44,0x0,0x0}}},
{0x216f,{{0x4d,0x0,0x0}}},
{0x2170,{{0x69,0x0,0x0}}},
{0x2171,{{0x69,0x69,0x0}}},
{0x2172,{{0x69,0x69,0x69}}},
{0x2173,{{0x69,0x76,0x0}}},
{0x2174,{{0x76,0x0,0x0}}},
{0x2175,{{0x76,0x69,0x0}}},
{0x2176,{{0x76,0x69,0x69}}},
{0x2178,{{0x69,0x78,0x0}}},
{0x2179,{{0x78,0x0,0x0}}},
{0x217a,{{0x78,0x69,0x0}}},
{0x217b,{{0x78,0x69,0x69}}},
{0x217c,{{0x6c,0x0,0x0}}},
{0x217d,{{0x63,0x0,0x0}}},
{0x217e,{{0x64,0x0,0x0}}},
{0x217f,{{0x6d,0x0,0x0}}},
{0x2189,{{0x30,0x2044,0x33}}},
{0x222c,{{0x222b,0x222b,0x0}}},
{0x222d,{{0x222b,0x222b,0x222b}}},
{0x222f,{{0x222e,0x222e,0x0}}},
{0x2230,{{0x222e,0x222e,0x222e}}},
{0x2460,{{0x31,0x0,0x0}}},
{0x2461,{{0x32,0x0,0x0}}},
{0x2462,{{0x33,0x0,0x0}}},
{0x2463,{{0x34,0x0,0x0}}},
{0x2464,{{0x35,0x0,0x0}}},
{0x2465,{{0x36,0x0,0x0}}},
{0x2466,{{0x37,0x0,0x0}}},
{0x2467,{{0x38,0x0,0x0}}},
{0x2468,{{0x39,0x0,0x0}}},
{0x2469,{{0x31,0x30,0x0}}},
{0x246a,{{0x31,0x31,0x0}}},
{0x246b,{{0x31,0x32,0x0}}},
{0x246c,{{0x31,0x33,0x0}}},
{0x246d,{{0x31,0x34,0x0}}},
{0x246e,{{0x31,0x35,0x0}}},
{0x246f,{{0x31,0x36,0x0}}},
{0x2470,{{0x31,0x37,0x0}}},
{0x2471,{{0x31,0x38,0x0}}},
{0x2472,{{0x31,0x39,0x0}}},
{0x2473,{{0x32,0x30,0x0}}},
{0x2474,{{0x28,0x31,0x29}}},
{0x2475,{{0x28,0x32,0x29}}},
{0x2476,{{0x28,0x33,0x29}}},
{0x2477,{{0x28,0x34,0x29}}},
{0x2478,{{0x28,0x35,0x29}}},
{0x2479,{{0x28,0x36,0x29}}},
{0x247a,{{0x28,0x37,0x29}}},
{0x247b,{{0x28,0x38,0x29}}},
{0x247c,{{0x28,0x39,0x29}}},
{0x2488,{{0x31,0x2e,0x0}}},
{0x2489,{{0x32,0x2e,0x0}}},
{0x248a,{{0x33,0x2e,0x0}}},
{0x248b,{{0x34,0x2e,0x0}}},
{0x248c,{{0x35,0x2e,0x0}}},
{0x248d,{{0x36,0x2e,0x0}}},
{0x248e,{{0x37,0x2e,0x0}}},
{0x248f,{{0x38,0x2e,0x0}}},
{0x2490,{{0x39,0x2e,0x0}}},
{0x2491,{{0x31,0x30,0x2e}}},
{0x2492,{{0x31,0x31,0x2e}}},
{0x2493,{{0x31,0x32,0x2e}}},
{0x2494,{{0x31,0x33,0x2e}}},
{0x2495,{{0x31,0x34,0x2e}}},
{0x2496,{{0x31,0x35,0x2e}}},
{0x2497,{{0x31,0x36,0x2e}}},
{0x2498,{{0x31,0x37,0x2e}}},
{0x2499,{{0x31,0x38,0x2e}}},
{0x249a,{{0x31,0x39,0x2e}}},
{0x249b,{{0x32,0x30,0x2e}}},
{0x249c,{{0x28,0x61,0x29}}},
{0x249d,{{0x28,0x62,0x29}}},
{0x249e,{{0x28,0x63,0x29}}},
{0x249f,{{0x28,0x64,0x29}}},
{0x24a0,{{0x28,0x65,0x29}}},
{0x24a1,{{0x28,0x66,0x29}}},
{0x24a2,{{0x28,0x67,0x29}}},
{0x24a3,{{0x28,0x68,0x29}}},
{0x24a4,{{0x28,0x69,0x29}}},
{0x24a5,{{0x28,0x6a,0x29}}},
{0x24a6,{{0x28,0x6b,0x29}}},
{0x24a7,{{0x28,0x6c,0x29}}},
{0x24a8,{{0x28,0x6d,0x29}}},
{0x24a9,{{0x28,0x6e,0x29}}},
{0x24aa,{{0x28,0x6f,0x29}}},
{0x24ab,{{0x28,0x70,0x29}}},
{0x24ac,{{0x28,0x71,0x29}}},
{0x24ad,{{0x28,0x72,0x29}}},
{0x24ae,{{0x28,0x73,0x29}}},
{0x24af,{{0x28,0x74,0x29}}},
{0x24b0,{{0x28,0x75,0x29}}},
{0x24b1,{{0x28,0x76,0x29}}},
{0x24b2,{{0x28,0x77,0x29}}},
{0x24b3,{{0x28,0x78,0x29}}},
{0x24b4,{{0x28,0x79,0x29}}},
{0x24b5,{{0x28,0x7a,0x29}}},
{0x24b6,{{0x41,0x0,0x0}}},
{0x24b7,{{0x42,0x0,0x0}}},
{0x24b8,{{0x43,0x0,0x0}}},
{0x24b9,{{0x44,0x0,0x0}}},
{0x24ba,{{0x45,0x0,0x0}}},
{0x24bb,{{0x46,0x0,0x0}}},
{0x24bc,{{0x47,0x0,0x0}}},
{0x24bd,{{0x48,0x0,0x0}}},
{0x24be,{{0x49,0x0,0x0}}},
{0x24bf,{{0x4a,0x0,0x0}}},
{0x24c0,{{0x4b,0x0,0x0}}},
{0x24c1,{{0x4c,0x0,0x0}}},
{0x24c2,{{0x4d,0x0,0x0}}},
{0x24c3,{{0x4e,0x0,0x0}}},
{0x24c4,{{0x4f,0x0,0x0}}},
{0x24c5,{{0x50,0x0,0x0}}},
{0x24c6,{{0x51,0x0,0x0}}},
{0x24c7,{{0x52,0x0,0x0}}},
{0x24c8,{{0x53,0x0,0x0}}},
{0x24c9,{{0x54,0x0,0x0}}},
{0x24ca,{{0x55,0x0,0x0}}},
{0x24cb,{{0x56,0x0,0x0}}},
{0x24cc,{{0x57,0x0,0x0}}},
{0x24cd,{{0x58,0x0,0x0}}},
{0x24ce,{{0x59,0x0,0x0}}},
{0x24cf,{{0x5a,0x0,0x0}}},
{0x24d0,{{0x61,0x0,0x0}}},
{0x24d1,{{0x62,0x0,0x0}}},
{0x24d2,{{0x63,0x0,0x0}}},
{0x24d3,{{0x64,0x0,0x0}}},
{0x24d4,{{0x65,0x0,0x0}}},
{0x24d5,{{0x66,0x0,0x0}}},
{0x24d6,{{0x67,0x0,0x0}}},
{0x24d7,{{0x68,0x0,0x0}}},
{0x24d8,{{0x69,0x0,0x0}}},
{0x24d9,{{0x6a,0x0,0x0}}},
{0x24da,{{0x6b,0x0,0x0}}},
{0x24db,{{0x6c,0x0,0x0}}},
{0x24dc,{{0x6d,0x0,0x0}}},
{0x24dd,{{0x6e,0x0,0x0}}},
{0x24de,{{0x6f,0x0,0x0}}},
{0x24df,{{0x70,0x0,0x0}}},
{0x24e0,{{0x71,0x0,0x0}}},
{0x24e1,{{0x72,0x0,0x0}}},
{0x24e2,{{0x73,0x0,0x0}}},
{0x24e3,{{0x74,0x0,0x0}}},
{0x24e4,{{0x75,0x0,0x0}}},
{0x24e5,{{0x76,0x0,0x0}}},
{0x24e6,{{0x77,0x0,0x0}}},
{0x24e7,{{0x78,0x0,0x0}}},
{0x24e8,{{0x79,0x0,0x0}}},
{0x24e9,{{0x7a,0x0,0x0}}},
{0x24ea,{{0x30,0x0,0x0}}},
{0x2a74,{{0x3a,0x3a,0x3d}}},
{0x2a75,{{0x3d,0x3d,0x0}}},
{0x2a76,{{0x3d,0x3d,0x3d}}},
{0x2c7c,{{0x6a,0x0,0x0}}},
{0x2c7d,{{0x56,0x0,0x0}}},
{0x2d6f,{{0x2d61,0x0,0x0}}},
{0x2e9f,{{0x6bcd,0x0,0x0}}},
{0x2ef3,{{0x9f9f,0x0,0x0}}},
{0x2f00,{{0x4e00,0x0,0x0}}},
{0x2f01,{{0x4e28,0x0,0x0}}},
{0x2f02,{{0x4e36,0x0,0x0}}},
{0x2f03,{{0x4e3f,0x0,0x0}}},
{0x2f04,{{0x4e59,0x0,0x0}}},
{0x2f05,{{0x4e85,0x0,0x0}}},
{0x2f06,{{0x4e8c,0x0,0x0}}},
{0x2f07,{{0x4ea0,0x0,0x0}}},
{0x2f08,{{0x4eba,0x0,0x0}}},
{0x2f09,{{0x513f,0x0,0x0}}},
{0x2f0a,{{0x5165,0x0,0x0}}},
{0x2f0b,{{0x516b,0x0,0x0}}},
{0x2f0c,{{0x5182,0x0,0x0}}},
{0x2f0d,{{0x5196,0x0,0x0}}},
{0x2f0e,{{0x51ab,0x0,0x0}}},
{0x2f0f,{{0x51e0,0x0,0x0}}},
{0x2f10,{{0x51f5,0x0,0x0}}},
{0x2f11,{{0x5200,0x0,0x0}}},
{0x2f12,{{0x529b,0x0,0x0}}},
{0x2f13,{{0x52f9,0x0,0x0}}},
{0x2f14,{{0x5315,0x0,0x0}}},
{0x2f15,{{0x531a,0x0,0x0}}},
{0x2f16,{{0x5338,0x0,0x0}}},
{0x2f17,{{0x5341,0x0,0x0}}},
{0x2f18,{{0x535c,0x0,0x0}}},
{0x2f19,{{0x5369,0x0,0x0}}},
{0x2f1a,{{0x5382,0x0,0x0}}},
{0x2f1b,{{0x53b6,0x0,0x0}}},
{0x2f1c,{{0x53c8,0x0,0x0}}},
{0x2f1d,{{0x53e3,0x0,0x0}}},
{0x2f1e,{{0x56d7,0x0,0x0}}},
{0x2f1f,{{0x571f,0x0,0x0}}},
{0x2f20,{{0x58eb,0x0,0x0}}},
{0x2f21,{{0x5902,0x0,0x0}}},
{0x2f22,{{0x590a,0x0,0x0}}},
{0x2f23,{{0x5915,0x0,0x0}}},
{0x2f24,{{0x5927,0x0,0x0}}},
{0x2f25,{{0x5973,0x0,0x0}}},
{0x2f26,{{0x5b50,0x0,0x0}}},
{0x2f27,{{0x5b80,0x0,0x0}}},
{0x2f28,{{0x5bf8,0x0,0x0}}},
{0x2f29,{{0x5c0f,0x0,0x0}}},
{0x2f2a,{{0x5c22,0x0,0x0}}},
{0x2f2b,{{0x5c38,0x0,0x0}}},
{0x2f2c,{{0x5c6e,0x0,0x0}}},
{0x2f2d,{{0x5c71,0x0,0x0}}},
{0x2f2e,{{0x5ddb,0x0,0x0}}},
{0x2f2f,{{0x5de5,0x0,0x0}}},
{0x2f30,{{0x5df1,0x0,0x0}}},
{0x2f31,{{0x5dfe,0x0,0x0}}},
{0x2f32,{{0x5e72,0x0,0x0}}},
{0x2f33,{{0x5e7a,0x0,0x0}}},
{0x2f34,{{0x5e7f,0x0,0x0}}},
{0x2f35,{{0x5ef4,0x0,0x0}}},
{0x2f36,{{0x5efe,0x0,0x0}}},
{0x2f37,{{0x5f0b,0x0,0x0}}},
{0x2f38,{{0x5f13,0x0,0x0}}},
{0x2f39,{{0x5f50,0x0,0x0}}},
{0x2f3a,{{0x5f61,0x0,0x0}}},
{0x2f3b,{{0x5f73,0x0,0x0}}},
{0x2f3c,{{0x5fc3,0x0,0x0}}},
{0x2f3d,{{0x6208,0x0,0x0}}},
{0x2f3e,{{0x6236,0x0,0x0}}},
{0x2f3f,{{0x624b,0x0,0x0}}},
{0x2f40,{{0x652f,0x0,0x0}}},
{0x2f41,{{0x6534,0x0,0x0}}},
{0x2f42,{{0x6587,0x0,0x0}}},
{0x2f43,{{0x6597,0x0,0x0}}},
{0x2f44,{{0x65a4,0x0,0x0}}},
{0x2f45,{{0x65b9,0x0,0x0}}},
{0x2f46,{{0x65e0,0x0,0x0}}},
{0x2f47,{{0x65e5,0x0,0x0}}},
{0x2f48,{{0x66f0,0x0,0x0}}},
{0x2f49,{{0x6708,0x0,0x0}}},
{0x2f4a,{{0x6728,0x0,0x0}}},
{0x2f4b,{{0x6b20,0x0,0x0}}},
{0x2f4c,{{0x6b62,0x0,0x0}}},
{0x2f4d,{{0x6b79,0x0,0x0}}},
{0x2f4e,{{0x6bb3,0x0,0x0}}},
{0x2f4f,{{0x6bcb,0x0,0x0}}},
{0x2f50,{{0x6bd4,0x0,0x0}}},
{0x2f51,{{0x6bdb,0x0,0x0}}},
{0x2f52,{{0x6c0f,0x0,0x0}}},
{0x2f53,{{0x6c14,0x0,0x0}}},
{0x2f54,{{0x6c34,0x0,0x0}}},
{0x2f55,{{0x706b,0x0,0x0}}},
{0x2f56,{{0x722a,0x0,0x0}}},
{0x2f57,{{0x7236,0x0,0x0}}},
{0x2f58,{{0x723b,0x0,0x0}}},
{0x2f59,{{0x723f,0x0,0x0}}},
{0x2f5a,{{0x7247,0x0,0x0}}},
{0x2f5b,{{0x7259,0x0,0x0}}},
{0x2f5c,{{0x725b,0x0,0x0}}},
{0x2f5d,{{0x72ac,0x0,0x0}}},
{0x2f5e,{{0x7384,0x0,0x0}}},
{0x2f5f,{{0x7389,0x0,0x0}}},
{0x2f60,{{0x74dc,0x0,0x0}}},
{0x2f61,{{0x74e6,0x0,0x0}}},
{0x2f62,{{0x7518,0x0,0x0}}},
{0x2f63,{{0x751f,0x0,0x0}}},
{0x2f64,{{0x7528,0x0,0x0}}},
{0x2f65,{{0x7530,0x0,0x0}}},
{0x2f66,{{0x758b,0x0,0x0}}},
{0x2f67,{{0x7592,0x0,0x0}}},
{0x2f68,{{0x7676,0x0,0x0}}},
{0x2f69,{{0x767d,0x0,0x0}}},
{0x2f6a,{{0x76ae,0x0,0x0}}},
{0x2f6b,{{0x76bf,0x0,0x0}}},
{0x2f6c,{{0x76ee,0x0,0x0}}},
{0x2f6d,{{0x77db,0x0,0x0}}},
{0x2f6e,{{0x77e2,0x0,0x0}}},
{0x2f6f,{{0x77f3,0x0,0x0}}},
{0x2f70,{{0x793a,0x0,0x0}}},
{0x2f71,{{0x79b8,0x0,0x0}}},
{0x2f72,{{0x79be,0x0,0x0}}},
{0x2f73,{{0x7a74,0x0,0x0}}},
{0x2f74,{{0x7acb,0x0,0x0}}},
{0x2f75,{{0x7af9,0x0,0x0}}},
{0x2f76,{{0x7c73,0x0,0x0}}},
{0x2f77,{{0x7cf8,0x0,0x0}}},
{0x2f78,{{0x7f36,0x0,0x0}}},
{0x2f79,{{0x7f51,0x0,0x0}}},
{0x2f7a,{{0x7f8a,0x0,0x0}}},
{0x2f7b,{{0x7fbd,0x0,0x0}}},
{0x2f7c,{{0x8001,0x0,0x0}}},
{0x2f7d,{{0x800c,0x0,0x0}}},
{0x2f7e,{{0x8012,0x0,0x0}}},
{0x2f7f,{{0x8033,0x0,0x0}}},
{0x2f80,{{0x807f,0x0,0x0}}},
{0x2f81,{{0x8089,0x0,0x0}}},
{0x2f82,{{0x81e3,0x0,0x0}}},
{0x2f83,{{0x81ea,0x0,0x0}}},
{0x2f84,{{0x81f3,0x0,0x0}}},
{0x2f85,{{0x81fc,0x0,0x0}}},
{0x2f86,{{0x820c,0x0,0x0}}},
{0x2f87,{{0x821b,0x0,0x0}}},
{0x2f88,{{0x821f,0x0,0x0}}},
{0x2f89,{{0x826e,0x0,0x0}}},
{0x2f8a,{{0x8272,0x0,0x0}}},
{0x2f8b,{{0x8278,0x0,0x0}}},
{0x2f8c,{{0x864d,0x0,0x0}}},
{0x2f8d,{{0x866b,0x0,0x0}}},
{0x2f8e,{{0x8840,0x0,0x0}}},
{0x2f8f,{{0x884c,0x0,0x0}}},
{0x2f90,{{0x8863,0x0,0x0}}},
{0x2f91,{{0x897e,0x0,0x0}}},
{0x2f92,{{0x898b,0x0,0x0}}},
{0x2f93,{{0x89d2,0x0,0x0}}},
{0x2f94,{{0x8a00,0x0,0x0}}},
{0x2f95,{{0x8c37,0x0,0x0}}},
{0x2f96,{{0x8c46,0x0,0x0}}},
{0x2f97,{{0x8c55,0x0,0x0}}},
{0x2f98,{{0x8c78,0x0,0x0}}},
{0x2f99,{{0x8c9d,0x0,0x0}}},
{0x2f9a,{{0x8d64,0x0,0x0}}},
{0x2f9b,{{0x8d70,0x0,0x0}}},
{0x2f9c,{{0x8db3,0x0,0x0}}},
{0x2f9d,{{0x8eab,0x0,0x0}}},
{0x2f9e,{{0x8eca,0x0,0x0}}},
{0x2f9f,{{0x8f9b,0x0,0x0}}},
{0x2fa0,{{0x8fb0,0x0,0x0}}},
{0x2fa1,{{0x8fb5,0x0,0x0}}},
{0x2fa2,{{0x9091,0x0,0x0}}},
{0x2fa3,{{0x9149,0x0,0x0}}},
{0x2fa4,{{0x91c6,0x0,0x0}}},
{0x2fa5,{{0x91cc,0x0,0x0}}},
{0x2fa6,{{0x91d1,0x0,0x0}}},
{0x2fa7,{{0x9577,0x0,0x0}}},
{0x2fa8,{{0x9580,0x0,0x0}}},
{0x2fa9,{{0x961c,0x0,0x0}}},
{0x2faa,{{0x96b6,0x0,0x0}}},
{0x2fab,{{0x96b9,0x0,0x0}}},
{0x2fac,{{0x96e8,0x0,0x0}}},
{0x2fad,{{0x9751,0x0,0x0}}},
{0x2fae,{{0x975e,0x0,0x0}}},
{0x2faf,{{0x9762,0x0,0x0}}},
{0x2fb0,{{0x9769,0x0,0x0}}},
{0x2fb1,{{0x97cb,0x0,0x0}}},
{0x2fb2,{{0x97ed,0x0,0x0}}},
{0x2fb3,{{0x97f3,0x0,0x0}}},
{0x2fb4,{{0x9801,0x0,0x0}}},
{0x2fb5,{{0x98a8,0x0,0x0}}},
{0x2fb6,{{0x98db,0x0,0x0}}},
{0x2fb7,{{0x98df,0x0,0x0}}},
{0x2fb8,{{0x9996,0x0,0x0}}},
{0x2fb9,{{0x9999,0x0,0x0}}},
{0x2fba,{{0x99ac,0x0,0x0}}},
{0x2fbb,{{0x9aa8,0x0,0x0}}},
{0x2fbc,{{0x9ad8,0x0,0x0}}},
{0x2fbd,{{0x9adf,0x0,0x0}}},
{0x2fbe,{{0x9b25,0x0,0x0}}},
{0x2fbf,{{0x9b2f,0x0,0x0}}},
{0x2fc0,{{0x9b32,0x0,0x0}}},
{0x2fc1,{{0x9b3c,0x0,0x0}}},
{0x2fc2,{{0x9b5a,0x0,0x0}}},
{0x2fc3,{{0x9ce5,0x0,0x0}}},
{0x2fc4,{{0x9e75,0x0,0x0}}},
{0x2fc5,{{0x9e7f,0x0,0x0}}},
{0x2fc6,{{0x9ea5,0x0,0x0}}},
{0x2fc7,{{0x9ebb,0x0,0x0}}},
{0x2fc8,{{0x9ec3,0x0,0x0}}},
{0x2fc9,{{0x9ecd,0x0,0x0}}},
{0x2fca,{{0x9ed1,0x0,0x0}}},
{0x2fcb,{{0x9ef9,0x0,0x0}}},
{0x2fcc,{{0x9efd,0x0,0x0}}},
{0x2fcd,{{0x9f0e,0x0,0x0}}},
{0x2fce,{{0x9f13,0x0,0x0}}},
{0x2fcf,{{0x9f20,0x0,0x0}}},
{0x2fd0,{{0x9f3b,0x0,0x0}}},
{0x2fd1,{{0x9f4a,0x0,0x0}}},
{0x2fd2,{{0x9f52,0x0,0x0}}},
{0x2fd3,{{0x9f8d,0x0,0x0}}},
{0x2fd4,{{0x9f9c,0x0,0x0}}},
{0x2fd5,{{0x9fa0,0x0,0x0}}},
{0x3000,{{0x20,0x0,0x0}}},
{0x3036,{{0x3012,0x0,0x0}}},
{0x3038,{{0x5341,0x0,0x0}}},
{0x3039,{{0x5344,0x0,0x0}}},
{0x303a,{{0x5345,0x0,0x0}}},
{0x309b,{{0x20,0x3099,0x0}}},
{0x309c,{{0x20,0x309a,0x0}}},
{0x309f,{{0x3088,0x308a,0x0}}},
{0x30ff,{{0x30b3,0x30c8,0x0}}},
{0x3131,{{0x1100,0x0,0x0}}},
{0x3132,{{0x1101,0x0,0x0}}},
{0x3133,{{0x11aa,0x0,0x0}}},
{0x3134,{{0x1102,0x0,0x0}}},
{0x3135,{{0x11ac,0x0,0x0}}},
{0x3136,{{0x11ad,0x0,0x0}}},
{0x3137,{{0x1103,0x0,0x0}}},
{0x3138,{{0x1104,0x0,0x0}}},
{0x3139,{{0x1105,0x0,0x0}}},
{0x313a,{{0x11b0,0x0,0x0}}},
{0x313b,{{0x11b1,0x0,0x0}}},
{0x313c,{{0x11b2,0x0,0x0}}},
{0x313d,{{0x11b3,0x0,0x0}}},
{0x313e,{{0x11b4,0x0,0x0}}},
{0x313f,{{0x11b5,0x0,0x0}}},
{0x3140,{{0x111a,0x0,0x0}}},
{0x3141,{{0x1106,0x0,0x0}}},
{0x3142,{{0x1107,0x0,0x0}}},
{0x3143,{{0x1108,0x0,0x0}}},
{0x3144,{{0x1121,0x0,0x0}}},
{0x3145,{{0x1109,0x0,0x0}}},
{0x3146,{{0x110a,0x0,0x0}}},
{0x3147,{{0x110b,0x0,0x0}}},
{0x3148,{{0x110c,0x0,0x0}}},
{0x3149,{{0x110d,0x0,0x0}}},
{0x314a,{{0x110e,0x0,0x0}}},
{0x314b,{{0x110f,0x0,0x0}}},
{0x314c,{{0x1110,0x0,0x0}}},
{0x314d,{{0x1111,0x0,0x0}}},
{0x314e,{{0x1112,0x0,0x0}}},
{0x314f,{{0x1161,0x0,0x0}}},
{0x3150,{{0x1162,0x0,0x0}}},
{0x3151,{{0x1163,0x0,0x0}}},
{0x3152,{{0x1164,0x0,0x0}}},
{0x3153,{{0x1165,0x0,0x0}}},
{0x3154,{{0x1166,0x0,0x0}}},
{0x3155,{{0x1167,0x0,0x0}}},
{0x3156,{{0x1168,0x0,0x0}}},
{0x3157,{{0x1169,0x0,0x0}}},
{0x3158,{{0x116a,0x0,0x0}}},
{0x3159,{{0x116b,0x0,0x0}}},
{0x315a,{{0x116c,0x0,0x0}}},
{0x315b,{{0x116d,0x0,0x0}}},
{0x315c,{{0x116e,0x0,0x0}}},
{0x315d,{{0x116f,0x0,0x0}}},
{0x315e,{{0x1170,0x0,0x0}}},
{0x315f,{{0x1171,0x0,0x0}}},
{0x3160,{{0x1172,0x0,0x0}}},
{0x3161,{{0x1173,0x0,0x0}}},
{0x3162,{{0x1174,0x0,0x0}}},
{0x3163,{{0x1175,0x0,0x0}}},
{0x3164,{{0x1160,0x0,0x0}}},
{0x3165,{{0x1114,0x0,0x0}}},
{0x3166,{{0x1115,0x0,0x0}}},
{0x3167,{{0x11c7,0x0,0x0}}},
{0x3168,{{0x11c8,0x0,0x0}}},
{0x3169,{{0x11cc,0x0,0x0}}},
{0x316a,{{0x11ce,0x0,0x0}}},
{0x316b,{{0x11d3,0x0,0x0}}},
{0x316c,{{0x11d7,0x0,0x0}}},
{0x316d,{{0x11d9,0x0,0x0}}},
{0x316e,{{0x111c,0x0,0x0}}},
{0x316f,{{0x11dd,0x0,0x0}}},
{0x3170,{{0x11df,0x0,0x0}}},
{0x3171,{{0x111d,0x0,0x0}}},
{0x3172,{{0x111e,0x0,0x0}}},
{0x3173,{{0x1120,0x0,0x0}}},
{0x3174,{{0x1122,0x0,0x0}}},
{0x3175,{{0x1123,0x0,0x0}}},
{0x3176,{{0x1127,0x0,0x0}}},
{0x3177,{{0x1129,0x0,0x0}}},
{0x3178,{{0x112b,0x0,0x0}}},
{0x3179,{{0x112c,0x0,0x0}}},
{0x317a,{{0x112d,0x0,0x0}}},
{0x317b,{{0x112e,0x0,0x0}}},
{0x317c,{{0x112f,0x0,0x0}}},
{0x317d,{{0x1132,0x0,0x0}}},
{0x317e,{{0x1136,0x0,0x0}}},
{0x317f,{{0x1140,0x0,0x0}}},
{0x3180,{{0x1147,0x0,0x0}}},
{0x3181,{{0x114c,0x0,0x0}}},
{0x3182,{{0x11f1,0x0,0x0}}},
{0x3183,{{0x11f2,0x0,0x0}}},
{0x3184,{{0x1157,0x0,0x0}}},
{0x3185,{{0x1158,0x0,0x0}}},
{0x3186,{{0x1159,0x0,0x0}}},
{0x3187,{{0x1184,0x0,0x0}}},
{0x3188,{{0x1185,0x0,0x0}}},
{0x3189,{{0x1188,0x0,0x0}}},
{0x318a,{{0x1191,0x0,0x0}}},
{0x318b,{{0x1192,0x0,0x0}}},
{0x318c,{{0x1194,0x0,0x0}}},
{0x318d,{{0x119e,0x0,0x0}}},
{0x318e,{{0x11a1,0x0,0x0}}},
{0x3192,{{0x4e00,0x0,0x0}}},
{0x3193,{{0x4e8c,0x0,0x0}}},
{0x3194,{{0x4e09,0x0,0x0}}},
{0x3195,{{0x56db,0x0,0x0}}},
{0x3196,{{0x4e0a,0x0,0x0}}},
{0x3197,{{0x4e2d,0x0,0x0}}},
{0x3198,{{0x4e0b,0x0,0x0}}},
{0x3199,{{0x7532,0x0,0x0}}},
{0x319a,{{0x4e59,0x0,0x0}}},
{0x319b,{{0x4e19,0x0,0x0}}},
{0x319c,{{0x4e01,0x0,0x0}}},
{0x319d,{{0x5929,0x0,0x0}}},
{0x319e,{{0x5730,0x0,0x0}}},
{0x319f,{{0x4eba,0x0,0x0}}},
{0x3200,{{0x28,0x1100,0x29}}},
{0x3201,{{0x28,0x1102,0x29}}},
{0x3202,{{0x28,0x1103,0x29}}},
{0x3203,{{0x28,0x1105,0x29}}},
{0x3204,{{0x28,0x1106,0x29}}},
{0x3205,{{0x28,0x1107,0x29}}},
{0x3206,{{0x28,0x1109,0x29}}},
{0x3207,{{0x28,0x110b,0x29}}},
{0x3208,{{0x28,0x110c,0x29}}},
{0x3209,{{0x28,0x110e,0x29}}},
{0x320a,{{0x28,0x110f,0x29}}},
{0x320b,{{0x28,0x1110,0x29}}},
{0x320c,{{0x28,0x1111,0x29}}},
{0x320d,{{0x28,0x1112,0x29}}},
{0x3220,{{0x28,0x4e00,0x29}}},
{0x3221,{{0x28,0x4e8c,0x29}}},
{0x3222,{{0x28,0x4e09,0x29}}},
{0x3223,{{0x28,0x56db,0x29}}},
{0x3224,{{0x28,0x4e94,0x29}}},
{0x3225,{{0x28,0x516d,0x29}}},
{0x3226,{{0x28,0x4e03,0x29}}},
{0x3227,{{0x28,0x516b,0x29}}},
{0x3228,{{0x28,0x4e5d,0x29}}},
{0x3229,{{0x28,0x5341,0x29}}},
{0x322a,{{0x28,0x6708,0x29}}},
{0x322b,{{0x28,0x706b,0x29}}},
{0x322c,{{0x28,0x6c34,0x29}}},
{0x322d,{{0x28,0x6728,0x29}}},
{0x322e,{{0x28,0x91d1,0x29}}},
{0x322f,{{0x28,0x571f,0x29}}},
{0x3230,{{0x28,0x65e5,0x29}}},
{0x3231,{{0x28,0x682a,0x29}}},
{0x3232,{{0x28,0x6709,0x29}}},
{0x3233,{{0x28,0x793e,0x29}}},
{0x3234,{{0x28,0x540d,0x29}}},
{0x3235,{{0x28,0x7279,0x29}}},
{0x3236,{{0x28,0x8ca1,0x29}}},
{0x3237,{{0x28,0x795d,0x29}}},
{0x3238,{{0x28,0x52b4,0x29}}},
{0x3239,{{0x28,0x4ee3,0x29}}},
{0x323a,{{0x28,0x547c,0x29}}},
{0x323b,{{0x28,0x5b66,0x29}}},
{0x323c,{{0x28,0x76e3,0x29}}},
{0x323d,{{0x28,0x4f01,0x29}}},
{0x323e,{{0x28,0x8cc7,0x29}}},
{0x323f,{{0x28,0x5354,0x29}}},
{0x3240,{{0x28,0x796d,0x29}}},
{0x3241,{{0x28,0x4f11,0x29}}},
{0x3242,{{0x28,0x81ea,0x29}}},
{0x3243,{{0x28,0x81f3,0x29}}},
{0x3244,{{0x554f,0x0,0x0}}},
{0x3245,{{0x5e7c,0x0,0x0}}},
{0x3246,{{0x6587,0x0,0x0}}},
{0x3247,{{0x7b8f,0x0,0x0}}},
{0x3250,{{0x50,0x54,0x45}}},
{0x3251,{{0x32,0x31,0x0}}},
{0x3252,{{0x32,0x32,0x0}}},
{0x3253,{{0x32,0x33,0x0}}},
{0x3254,{{0x32,0x34,0x0}}},
{0x3255,{{0x32,0x35,0x0}}},
{0x3256,{{0x32,0x36,0x0}}},
{0x3257,{{0x32,0x37,0x0}}},
{0x3258,{{0x32,0x38,0x0}}},
{0x3259,{{0x32,0x39,0x0}}},
{0x325a,{{0x33,0x30,0x0}}},
{0x325b,{{0x33,0x31,0x0}}},
{0x325c,{{0x33,0x32,0x0}}},
{0x325d,{{0x33,0x33,0x0}}},
{0x325e,{{0x33,0x34,0x0}}},
{0x325f,{{0x33,0x35,0x0}}},
{0x3260,{{0x1100,0x0,0x0}}},
{0x3261,{{0x1102,0x0,0x0}}},
{0x3262,{{0x1103,0x0,0x0}}},
{0x3263,{{0x1105,0x0,0x0}}},
{0x3264,{{0x1106,0x0,0x0}}},
{0x3265,{{0x1107,0x0,0x0}}},
{0x3266,{{0x1109,0x0,0x0}}},
{0x3267,{{0x110b,0x0,0x0}}},
{0x3268,{{0x110c,0x0,0x0}}},
{0x3269,{{0x110e,0x0,0x0}}},
{0x326a,{{0x110f,0x0,0x0}}},
{0x326b,{{0x1110,0x0,0x0}}},
{0x326c,{{0x1111,0x0,0x0}}},
{0x326d,{{0x1112,0x0,0x0}}},
{0x326e,{{0x1100,0x1161,0x0}}},
{0x326f,{{0x1102,0x1161,0x0}}},
{0x3270,{{0x1103,0x1161,0x0}}},
{0x3271,{{0x1105,0x1161,0x0}}},
{0x3272,{{0x1106,0x1161,0x0}}},
{0x3273,{{0x1107,0x1161,0x0}}},
{0x3274,{{0x1109,0x1161,0x0}}},
{0x3275,{{0x110b,0x1161,0x0}}},
{0x3276,{{0x110c,0x1161,0x0}}},
{0x3277,{{0x110e,0x1161,0x0}}},
{0x3278,{{0x110f,0x1161,0x0}}},
{0x3279,{{0x1110,0x1161,0x0}}},
{0x327a,{{0x1111,0x1161,0x0}}},
{0x327b,{{0x1112,0x1161,0x0}}},
{0x327e,{{0x110b,0x116e,0x0}}},
{0x3280,{{0x4e00,0x0,0x0}}},
{0x3281,{{0x4e8c,0x0,0x0}}},
{0x3282,{{0x4e09,0x0,0x0}}},
{0x3283,{{0x56db,0x0,0x0}}},
{0x3284,{{0x4e94,0x0,0x0}}},
{0x3285,{{0x516d,0x0,0x0}}},
{0x3286,{{0x4e03,0x0,0x0}}},
{0x3287,{{0x516b,0x0,0x0}}},
{0x3288,{{0x4e5d,0x0,0x0}}},
{0x3289,{{0x5341,0x0,0x0}}},
{0x328a,{{0x6708,0x0,0x0}}},
{0x328b,{{0x706b,0x0,0x0}}},
{0x328c,{{0x6c34,0x0,0x0}}},
{0x328d,{{0x6728,0x0,0x0}}},
{0x328e,{{0x91d1,0x0,0x0}}},
{0x328f,{{0x571f,0x0,0x0}}},
{0x3290,{{0x65e5,0x0,0x0}}},
{0x3291,{{0x682a,0x0,0x0}}},
{0x3292,{{0x6709,0x0,0x0}}},
{0x3293,{{0x793e,0x0,0x0}}},
{0x3294,{{0x540d,0x0,0x0}}},
{0x3295,{{0x7279,0x0,0x0}}},
{0x3296,{{0x8ca1,0x0,0x0}}},
{0x3297,{{0x795d,0x0,0x0}}},
{0x3298,{{0x52b4,0x0,0x0}}},
{0x3299,{{0x79d8,0x0,0x0}}},
{0x329a,{{0x7537,0x0,0x0}}},
{0x329b,{{0x5973,0x0,0x0}}},
{0x329c,{{0x9069,0x0,0x0}}},
{0x329d,{{0x512a,0x0,0x0}}},
{0x329e,{{0x5370,0x0,0x0}}},
{0x329f,{{0x6ce8,0x0,0x0}}},
{0x32a0,{{0x9805,0x0,0x0}}},
{0x32a1,{{0x4f11,0x0,0x0}}},
{0x32a2,{{0x5199,0x0,0x0}}},
{0x32a3,{{0x6b63,0x0,0x0}}},
{0x32a4,{{0x4e0a,0x0,0x0}}},
{0x32a5,{{0x4e2d,0x0,0x0}}},
{0x32a6,{{0x4e0b,0x0,0x0}}},
{0x32a7,{{0x5de6,0x0,0x0}}},
{0x32a8,{{0x53f3,0x0,0x0}}},
{0x32a9,{{0x533b,0x0,0x0}}},
{0x32aa,{{0x5b97,0x0,0x0}}},
{0x32ab,{{0x5b66,0x0,0x0}}},
{0x32ac,{{0x76e3,0x0,0x0}}},
{0x32ad,{{0x4f01,0x0,0x0}}},
{0x32ae,{{0x8cc7,0x0,0x0}}},
{0x32af,{{0x5354,0x0,0x0}}},
{0x32b0,{{0x591c,0x0,0x0}}},
{0x32b1,{{0x33,0x36,0x0}}},
{0x32b2,{{0x33,0x37,0x0}}},
{0x32b3,{{0x33,0x38,0x0}}},
{0x32b4,{{0x33,0x39,0x0}}},
{0x32b5,{{0x34,0x30,0x0}}},
{0x32b6,{{0x34,0x31,0x0}}},
{0x32b7,{{0x34,0x32,0x0}}},
{0x32b8,{{0x34,0x33,0x0}}},
{0x32b9,{{0x34,0x34,0x0}}},
{0x32ba,{{0x34,0x35,0x0}}},
{0x32bb,{{0x34,0x36,0x0}}},
{0x32bc,{{0x34,0x37,0x0}}},
{0x32bd,{{0x34,0x38,0x0}}},
{0x32be,{{0x34,0x39,0x0}}},
{0x32bf,{{0x35,0x30,0x0}}},
{0x32c0,{{0x31,0x6708,0x0}}},
{0x32c1,{{0x32,0x6708,0x0}}},
{0x32c2,{{0x33,0x6708,0x0}}},
{0x32c3,{{0x34,0x6708,0x0}}},
{0x32c4,{{0x35,0x6708,0x0}}},
{0x32c5,{{0x36,0x6708,0x0}}},
{0x32c6,{{0x37,0x6708,0x0}}},
{0x32c7,{{0x38,0x6708,0x0}}},
{0x32c8,{{0x39,0x6708,0x0}}},
{0x32c9,{{0x31,0x30,0x6708}}},
{0x32ca,{{0x31,0x31,0x6708}}},
{0x32cb,{{0x31,0x32,0x6708}}},
{0x32cc,{{0x48,0x67,0x0}}},
{0x32cd,{{0x65,0x72,0x67}}},
{0x32ce,{{0x65,0x56,0x0}}},
{0x32cf,{{0x4c,0x54,0x44}}},
{0x32d0,{{0x30a2,0x0,0x0}}},
{0x32d1,{{0x30a4,0x0,0x0}}},
{0x32d2,{{0x30a6,0x0,0x0}}},
{0x32d3,{{0x30a8,0x0,0x0}}},
{0x32d4,{{0x30aa,0x0,0x0}}},
{0x32d5,{{0x30ab,0x0,0x0}}},
{0x32d6,{{0x30ad,0x0,0x0}}},
{0x32d7,{{0x30af,0x0,0x0}}},
{0x32d8,{{0x30b1,0x0,0x0}}},
{0x32d9,{{0x30b3,0x0,0x0}}},
{0x32da,{{0x30b5,0x0,0x0}}},
{0x32db,{{0x30b7,0x0,0x0}}},
{0x32dc,{{0x30b9,0x0,0x0}}},
{0x32dd,{{0x30bb,0x0,0x0}}},
{0x32de,{{0x30bd,0x0,0x0}}},
{0x32df,{{0x30bf,0x0,0x0}}},
{0x32e0,{{0x30c1,0x0,0x0}}},
{0x32e1,{{0x30c4,0x0,0x0}}},
{0x32e2,{{0x30c6,0x0,0x0}}},
{0x32e3,{{0x30c8,0x0,0x0}}},
{0x32e4,{{0x30ca,0x0,0x0}}},
{0x32e5,{{0x30cb,0x0,0x0}}},
{0x32e6,{{0x30cc,0x0,0x0}}},
{0x32e7,{{0x30cd,0x0,0x0}}},
{0x32e8,{{0x30ce,0x0,0x0}}},
{0x32e9,{{0x30cf,0x0,0x0}}},
{0x32ea,{{0x30d2,0x0,0x0}}},
{0x32eb,{{0x30d5,0x0,0x0}}},
{0x32ec,{{0x30d8,0x0,0x0}}},
{0x32ed,{{0x30db,0x0,0x0}}},
{0x32ee,{{0x30de,0x0,0x0}}},
{0x32ef,{{0x30df,0x0,0x0}}},
{0x32f0,{{0x30e0,0x0,0x0}}},
{0x32f1,{{0x30e1,0x0,0x0}}},
{0x32f2,{{0x30e2,0x0,0x0}}},
{0x32f3,{{0x30e4,0x0,0x0}}},
{0x32f4,{{0x30e6,0x0,0x0}}},
{0x32f5,{{0x30e8,0x0,0x0}}},
{0x32f6,{{0x30e9,0x0,0x0}}},
{0x32f7,{{0x30ea,0x0,0x0}}},
{0x32f8,{{0x30eb,0x0,0x0}}},
{0x32f9,{{0x30ec,0x0,0x0}}},
{0x32fa,{{0x30ed,0x0,0x0}}},
{0x32fb,{{0x30ef,0x0,0x0}}},
{0x32fc,{{0x30f0,0x0,0x0}}},
{0x32fd,{{0x30f1,0x0,0x0}}},
{0x32fe,{{0x30f2,0x0,0x0}}},
{0x3303,{{0x30a2,0x30fc,0x30eb}}},
{0x3305,{{0x30a4,0x30f3,0x30c1}}},
{0x3306,{{0x30a6,0x30a9,0x30f3}}},
{0x3309,{{0x30aa,0x30f3,0x30b9}}},
{0x330a,{{0x30aa,0x30fc,0x30e0}}},
{0x330b,{{0x30ab,0x30a4,0x30ea}}},
{0x330e,{{0x30ac,0x30ed,0x30f3}}},
{0x330f,{{0x30ac,0x30f3,0x30de}}},
{0x3310,{{0x30ae,0x30ac,0x0}}},
{0x3311,{{0x30ae,0x30cb,0x30fc}}},
{0x3314,{{0x30ad,0x30ed,0x0}}},
{0x3318,{{0x30b0,0x30e9,0x30e0}}},
{0x331c,{{0x30b1,0x30fc,0x30b9}}},
{0x331d,{{0x30b3,0x30eb,0x30ca}}},
{0x331e,{{0x30b3,0x30fc,0x30dd}}},
{0x3322,{{0x30bb,0x30f3,0x30c1}}},
{0x3323,{{0x30bb,0x30f3,0x30c8}}},
{0x3324,{{0x30c0,0x30fc,0x30b9}}},
{0x3325,{{0x30c7,0x30b7,0x0}}},
{0x3326,{{0x30c9,0x30eb,0x0}}},
{0x3327,{{0x30c8,0x30f3,0x0}}},
{0x3328,{{0x30ca,0x30ce,0x0}}},
{0x3329,{{0x30ce,0x30c3,0x30c8}}},
{0x332a,{{0x30cf,0x30a4,0x30c4}}},
{0x332c,{{0x30d1,0x30fc,0x30c4}}},
{0x332f,{{0x30d4,0x30af,0x30eb}}},
{0x3330,{{0x30d4,0x30b3,0x0}}},
{0x3331,{{0x30d3,0x30eb,0x0}}},
{0x3335,{{0x30d5,0x30e9,0x30f3}}},
{0x3337,{{0x30da,0x30bd,0x0}}},
{0x3338,{{0x30da,0x30cb,0x30d2}}},
{0x3339,{{0x30d8,0x30eb,0x30c4}}},
{0x333a,{{0x30da,0x30f3,0x30b9}}},
{0x333b,{{0x30da,0x30fc,0x30b8}}},
{0x333c,{{0x30d9,0x30fc,0x30bf}}},
{0x333e,{{0x30dc,0x30eb,0x30c8}}},
{0x333f,{{0x30db,0x30f3,0x0}}},
{0x3340,{{0x30dd,0x30f3,0x30c9}}},
{0x3341,{{0x30db,0x30fc,0x30eb}}},
{0x3342,{{0x30db,0x30fc,0x30f3}}},
{0x3344,{{0x30de,0x30a4,0x30eb}}},
{0x3345,{{0x30de,0x30c3,0x30cf}}},
{0x3346,{{0x30de,0x30eb,0x30af}}},
{0x3349,{{0x30df,0x30ea,0x0}}},
{0x334b,{{0x30e1,0x30ac,0x0}}},
{0x334e,{{0x30e4,0x30fc,0x30c9}}},
{0x334f,{{0x30e4,0x30fc,0x30eb}}},
{0x3350,{{0x30e6,0x30a2,0x30f3}}},
{0x3352,{{0x30ea,0x30e9,0x0}}},
{0x3353,{{0x30eb,0x30d4,0x30fc}}},
{0x3355,{{0x30ec,0x30e0,0x0}}},
{0x3357,{{0x30ef,0x30c3,0x30c8}}},
{0x3358,{{0x30,0x70b9,0x0}}},
{0x3359,{{0x31,0x70b9,0x0}}},
{0x335a,{{0x32,0x70b9,0x0}}},
{0x335b,{{0x33,0x70b9,0x0}}},
{0x335c,{{0x34,0x70b9,0x0}}},
{0x335d,{{0x35,0x70b9,0x0}}},
{0x335e,{{0x36,0x70b9,0x0}}},
{0x335f,{{0x37,0x70b9,0x0}}},
{0x3360,{{0x38,0x70b9,0x0}}},
{0x3361,{{0x39,0x70b9,0x0}}},
{0x3362,{{0x31,0x30,0x70b9}}},
{0x3363,{{0x31,0x31,0x70b9}}},
{0x3364,{{0x31,0x32,0x70b9}}},
{0x3365,{{0x31,0x33,0x70b9}}},
{0x3366,{{0x31,0x34,0x70b9}}},
{0x3367,{{0x31,0x35,0x70b9}}},
{0x3368,{{0x31,0x36,0x70b9}}},
{0x3369,{{0x31,0x37,0x70b9}}},
{0x336a,{{0x31,0x38,0x70b9}}},
{0x336b,{{0x31,0x39,0x70b9}}},
{0x336c,{{0x32,0x30,0x70b9}}},
{0x336d,{{0x32,0x31,0x70b9}}},
{0x336e,{{0x32,0x32,0x70b9}}},
{0x336f,{{0x32,0x33,0x70b9}}},
{0x3370,{{0x32,0x34,0x70b9}}},
{0x3371,{{0x68,0x50,0x61}}},
{0x3372,{{0x64,0x61,0x0}}},
{0x3373,{{0x41,0x55,0x0}}},
{0x3374,{{0x62,0x61,0x72}}},
{0x3375,{{0x6f,0x56,0x0}}},
{0x3376,{{0x70,0x63,0x0}}},
{0x3377,{{0x64,0x6d,0x0}}},
{0x3378,{{0x64,0x6d,0xb2}}},
{0x3379,{{0x64,0x6d,0xb3}}},
{0x337a,{{0x49,0x55,0x0}}},
{0x337b,{{0x5e73,0x6210,0x0}}},
{0x337c,{{0x662d,0x548c,0x0}}},
{0x337d,{{0x5927,0x6b63,0x0}}},
{0x337e,{{0x660e,0x6cbb,0x0}}},
{0x3380,{{0x70,0x41,0x0}}},
{0x3381,{{0x6e,0x41,0x0}}},
{0x3382,{{0x3bc,0x41,0x0}}},
{0x3383,{{0x6d,0x41,0x0}}},
{0x3384,{{0x6b,0x41,0x0}}},
{0x3385,{{0x4b,0x42,0x0}}},
{0x3386,{{0x4d,0x42,0x0}}},
{0x3387,{{0x47,0x42,0x0}}},
{0x3388,{{0x63,0x61,0x6c}}},
{0x338a,{{0x70,0x46,0x0}}},
{0x338b,{{0x6e,0x46,0x0}}},
{0x338c,{{0x3bc,0x46,0x0}}},
{0x338d,{{0x3bc,0x67,0x0}}},
{0x338e,{{0x6d,0x67,0x0}}},
{0x338f,{{0x6b,0x67,0x0}}},
{0x3390,{{0x48,0x7a,0x0}}},
{0x3391,{{0x6b,0x48,0x7a}}},
{0x3392,{{0x4d,0x48,0x7a}}},
{0x3393,{{0x47,0x48,0x7a}}},
{0x3394,{{0x54,0x48,0x7a}}},
{0x3395,{{0x3bc,0x2113,0x0}}},
{0x3396,{{0x6d,0x2113,0x0}}},
{0x3397,{{0x64,0x2113,0x0}}},
{0x3398,{{0x6b,0x2113,0x0}}},
{0x3399,{{0x66,0x6d,0x0}}},
{0x339a,{{0x6e,0x6d,0x0}}},
{0x339b,{{0x3bc,0x6d,0x0}}},
{0x339c,{{0x6d,0x6d,0x0}}},
{0x339d,{{0x63,0x6d,0x0}}},
{0x339e,{{0x6b,0x6d,0x0}}},
{0x339f,{{0x6d,0x6d,0xb2}}},
{0x33a0,{{0x63,0x6d,0xb2}}},
{0x33a1,{{0x6d,0xb2,0x0}}},
{0x33a2,{{0x6b,0x6d,0xb2}}},
{0x33a3,{{0x6d,0x6d,0xb3}}},
{0x33a4,{{0x63,0x6d,0xb3}}},
{0x33a5,{{0x6d,0xb3,0x0}}},
{0x33a6,{{0x6b,0x6d,0xb3}}},
{0x33a7,{{0x6d,0x2215,0x73}}},
{0x33a9,{{0x50,0x61,0x0}}},
{0x33aa,{{0x6b,0x50,0x61}}},
{0x33ab,{{0x4d,0x50,0x61}}},
{0x33ac,{{0x47,0x50,0x61}}},
{0x33ad,{{0x72,0x61,0x64}}},
{0x33b0,{{0x70,0x73,0x0}}},
{0x33b1,{{0x6e,0x73,0x0}}},
{0x33b2,{{0x3bc,0x73,0x0}}},
{0x33b3,{{0x6d,0x73,0x0}}},
{0x33b4,{{0x70,0x56,0x0}}},
{0x33b5,{{0x6e,0x56,0x0}}},
{0x33b6,{{0x3bc,0x56,0x0}}},
{0x33b7,{{0x6d,0x56,0x0}}},
{0x33b8,{{0x6b,0x56,0x0}}},
{0x33b9,{{0x4d,0x56,0x0}}},
{0x33ba,{{0x70,0x57,0x0}}},
{0x33bb,{{0x6e,0x57,0x0}}},
{0x33bc,{{0x3bc,0x57,0x0}}},
{0x33bd,{{0x6d,0x57,0x0}}},
{0x33be,{{0x6b,0x57,0x0}}},
{0x33bf,{{0x4d,0x57,0x0}}},
{0x33c0,{{0x6b,0x3a9,0x0}}},
{0x33c1,{{0x4d,0x3a9,0x0}}},
{0x33c3,{{0x42,0x71,0x0}}},
{0x33c4,{{0x63,0x63,0x0}}},
{0x33c5,{{0x63,0x64,0x0}}},
{0x33c7,{{0x43,0x6f,0x2e}}},
{0x33c8,{{0x64,0x42,0x0}}},
{0x33c9,{{0x47,0x79,0x0}}},
{0x33ca,{{0x68,0x61,0x0}}},
{0x33cb,{{0x48,0x50,0x0}}},
{0x33cc,{{0x69,0x6e,0x0}}},
{0x33cd,{{0x4b,0x4b,0x0}}},
{0x33ce,{{0x4b,0x4d,0x0}}},
{0x33cf,{{0x6b,0x74,0x0}}},
{0x33d0,{{0x6c,0x6d,0x0}}},
{0x33d1,{{0x6c,0x6e,0x0}}},
{0x33d2,{{0x6c,0x6f,0x67}}},
{0x33d3,{{0x6c,0x78,0x0}}},
{0x33d4,{{0x6d,0x62,0x0}}},
{0x33d5,{{0x6d,0x69,0x6c}}},
{0x33d6,{{0x6d,0x6f,0x6c}}},
{0x33d7,{{0x50,0x48,0x0}}},
{0x33d9,{{0x50,0x50,0x4d}}},
{0x33da,{{0x50,0x52,0x0}}},
{0x33db,{{0x73,0x72,0x0}}},
{0x33dc,{{0x53,0x76,0x0}}},
{0x33dd,{{0x57,0x62,0x0}}},
{0x33de,{{0x56,0x2215,0x6d}}},
{0x33df,{{0x41,0x2215,0x6d}}},
{0x33e0,{{0x31,0x65e5,0x0}}},
{0x33e1,{{0x32,0x65e5,0x0}}},
{0x33e2,{{0x33,0x65e5,0x0}}},
{0x33e3,{{0x34,0x65e5,0x0}}},
{0x33e4,{{0x35,0x65e5,0x0}}},
{0x33e5,{{0x36,0x65e5,0x0}}},
{0x33e6,{{0x37,0x65e5,0x0}}},
{0x33e7,{{0x38,0x65e5,0x0}}},
{0x33e8,{{0x39,0x65e5,0x0}}},
{0x33e9,{{0x31,0x30,0x65e5}}},
{0x33ea,{{0x31,0x31,0x65e5}}},
{0x33eb,{{0x31,0x32,0x65e5}}},
{0x33ec,{{0x31,0x33,0x65e5}}},
{0x33ed,{{0x31,0x34,0x65e5}}},
{0x33ee,{{0x31,0x35,0x65e5}}},
{0x33ef,{{0x31,0x36,0x65e5}}},
{0x33f0,{{0x31,0x37,0x65e5}}},
{0x33f1,{{0x31,0x38,0x65e5}}},
{0x33f2,{{0x31,0x39,0x65e5}}},
{0x33f3,{{0x32,0x30,0x65e5}}},
{0x33f4,{{0x32,0x31,0x65e5}}},
{0x33f5,{{0x32,0x32,0x65e5}}},
{0x33f6,{{0x32,0x33,0x65e5}}},
{0x33f7,{{0x32,0x34,0x65e5}}},
{0x33f8,{{0x32,0x35,0x65e5}}},
{0x33f9,{{0x32,0x36,0x65e5}}},
{0x33fa,{{0x32,0x37,0x65e5}}},
{0x33fb,{{0x32,0x38,0x65e5}}},
{0x33fc,{{0x32,0x39,0x65e5}}},
{0x33fd,{{0x33,0x30,0x65e5}}},
{0x33fe,{{0x33,0x31,0x65e5}}},
{0x33ff,{{0x67,0x61,0x6c}}},
{0xa69c,{{0x44a,0x0,0x0}}},
{0xa69d,{{0x44c,0x0,0x0}}},
{0xa770,{{0xa76f,0x0,0x0}}},
{0xa7f8,{{0x126,0x0,0x0}}},
{0xa7f9,{{0x153,0x0,0x0}}},
{0xab5c,{{0xa727,0x0,0x0}}},
{0xab5d,{{0xab37,0x0,0x0}}},
{0xab5e,{{0x26b,0x0,0x0}}},
{0xab5f,{{0xab52,0x0,0x0}}},
{0xfb00,{{0x66,0x66,0x0}}},
{0xfb01,{{0x66,0x69,0x0}}},
{0xfb02,{{0x66,0x6c,0x0}}},
{0xfb03,{{0x66,0x66,0x69}}},
{0xfb04,{{0x66,0x66,0x6c}}},
{0xfb05,{{0x17f,0x74,0x0}}},
{0xfb06,{{0x73,0x74,0x0}}},
{0xfb13,{{0x574,0x576,0x0}}},
{0xfb14,{{0x574,0x565,0x0}}},
{0xfb15,{{0x574,0x56b,0x0}}},
{0xfb16,{{0x57e,0x576,0x0}}},
{0xfb17,{{0x574,0x56d,0x0}}},
{0xfb20,{{0x5e2,0x0,0x0}}},
{0xfb21,{{0x5d0,0x0,0x0}}},
{0xfb22,{{0x5d3,0x0,0x0}}},
{0xfb23,{{0x5d4,0x0,0x0}}},
{0xfb24,{{0x5db,0x0,0x0}}},
{0xfb25,{{0x5dc,0x0,0x0}}},
{0xfb26,{{0x5dd,0x0,0x0}}},
{0xfb27,{{0x5e8,0x0,0x0}}},
{0xfb28,{{0x5ea,0x0,0x0}}},
{0xfb29,{{0x2b,0x0,0x0}}},
{0xfb4f,{{0x5d0,0x5dc,0x0}}},
{0xfb50,{{0x671,0x0,0x0}}},
{0xfb51,{{0x671,0x0,0x0}}},
{0xfb52,{{0x67b,0x0,0x0}}},
{0xfb53,{{0x67b,0x0,0x0}}},
{0xfb54,{{0x67b,0x0,0x0}}},
{0xfb55,{{0x67b,0x0,0x0}}},
{0xfb56,{{0x67e,0x0,0x0}}},
{0xfb57,{{0x67e,0x0,0x0}}},
{0xfb58,{{0x67e,0x0,0x0}}},
{0xfb59,{{0x67e,0x0,0x0}}},
{0xfb5a,{{0x680,0x0,0x0}}},
{0xfb5b,{{0x680,0x0,0x0}}},
{0xfb5c,{{0x680,0x0,0x0}}},
{0xfb5d,{{0x680,0x0,0x0}}},
{0xfb5e,{{0x67a,0x0,0x0}}},
{0xfb5f,{{0x67a,0x0,0x0}}},
{0xfb60,{{0x67a,0x0,0x0}}},
{0xfb61,{{0x67a,0x0,0x0}}},
{0xfb62,{{0x67f,0x0,0x0}}},
{0xfb63,{{0x67f,0x0,0x0}}},
{0xfb64,{{0x67f,0x0,0x0}}},
{0xfb65,{{0x67f,0x0,0x0}}},
{0xfb66,{{0x679,0x0,0x0}}},
{0xfb67,{{0x679,0x0,0x0}}},
{0xfb68,{{0x679,0x0,0x0}}},
{0xfb69,{{0x679,0x0,0x0}}},
{0xfb6a,{{0x6a4,0x0,0x0}}},
{0xfb6b,{{0x6a4,0x0,0x0}}},
{0xfb6c,{{0x6a4,0x0,0x0}}},
{0xfb6d,{{0x6a4,0x0,0x0}}},
{0xfb6e,{{0x6a6,0x0,0x0}}},
{0xfb6f,{{0x6a6,0x0,0x0}}},
{0xfb70,{{0x6a6,0x0,0x0}}},
{0xfb71,{{0x6a6,0x0,0x0}}},
{0xfb72,{{0x684,0x0,0x0}}},
{0xfb73,{{0x684,0x0,0x0}}},
{0xfb74,{{0x684,0x0,0x0}}},
{0xfb75,{{0x684,0x0,0x0}}},
{0xfb76,{{0x683,0x0,0x0}}},
{0xfb77,{{0x683,0x0,0x0}}},
{0xfb78,{{0x683,0x0,0x0}}},
{0xfb79,{{0x683,0x0,0x0}}},
{0xfb7a,{{0x686,0x0,0x0}}},
{0xfb7b,{{0x686,0x0,0x0}}},
{0xfb7c,{{0x686,0x0,0x0}}},
{0xfb7d,{{0x686,0x0,0x0}}},
{0xfb7e,{{0x687,0x0,0x0}}},
{0xfb7f,{{0x687,0x0,0x0}}},
{0xfb80,{{0x687,0x0,0x0}}},
{0xfb81,{{0x687,0x0,0x0}}},
{0xfb82,{{0x68d,0x0,0x0}}},
{0xfb83,{{0x68d,0x0,0x0}}},
{0xfb84,{{0x68c,0x0,0x0}}},
{0xfb85,{{0x68c,0x0,0x0}}},
{0xfb86,{{0x68e,0x0,0x0}}},
{0xfb87,{{0x68e,0x0,0x0}}},
{0xfb88,{{0x688,0x0,0x0}}},
{0xfb89,{{0x688,0x0,0x0}}},
{0xfb8a,{{0x698,0x0,0x0}}},
{0xfb8b,{{0x698,0x0,0x0}}},
{0xfb8c,{{0x691,0x0,0x0}}},
{0xfb8d,{{0x691,0x0,0x0}}},
{0xfb8e,{{0x6a9,0x0,0x0}}},
{0xfb8f,{{0x6a9,0x0,0x0}}},
{0xfb90,{{0x6a9,0x0,0x0}}},
{0xfb91,{{0x6a9,0x0,0x0}}},
{0xfb92,{{0x6af,0x0,0x0}}},
{0xfb93,{{0x6af,0x0,0x0}}},
{0xfb94,{{0x6af,0x0,0x0}}},
{0xfb95,{{0x6af,0x0,0x0}}},
{0xfb96,{{0x6b3,0x0,0x0}}},
{0xfb97,{{0x6b3,0x0,0x0}}},
{0xfb98,{{0x6b3,0x0,0x0}}},
{0xfb99,{{0x6b3,0x0,0x0}}},
{0xfb9a,{{0x6b1,0x0,0x0}}},
{0xfb9b,{{0x6b1,0x0,0x0}}},
{0xfb9c,{{0x6b1,0x0,0x0}}},
{0xfb9d,{{0x6b1,0x0,0x0}}},
{0xfb9e,{{0x6ba,0x0,0x0}}},
{0xfb9f,{{0x6ba,0x0,0x0}}},
{0xfba0,{{0x6bb,0x0,0x0}}},
{0xfba1,{{0x6bb,0x0,0x0}}},
{0xfba2,{{0x6bb,0x0,0x0}}},
{0xfba3,{{0x6bb,0x0,0x0}}},
{0xfba4,{{0x6c0,0x0,0x0}}},
{0xfba5,{{0x6c0,0x0,0x0}}},
{0xfba6,{{0x6c1,0x0,0x0}}},
{0xfba7,{{0x6c1,0x0,0x0}}},
{0xfba8,{{0x6c1,0x0,0x0}}},
{0xfba9,{{0x6c1,0x0,0x0}}},
{0xfbaa,{{0x6be,0x0,0x0}}},
{0xfbab,{{0x6be,0x0,0x0}}},
{0xfbac,{{0x6be,0x0,0x0}}},
{0xfbad,{{0x6be,0x0,0x0}}},
{0xfbae,{{0x6d2,0x0,0x0}}},
{0xfbaf,{{0x6d2,0x0,0x0}}},
{0xfbb0,{{0x6d3,0x0,0x0}}},
{0xfbb1,{{0x6d3,0x0,0x0}}},
{0xfbd3,{{0x6ad,0x0,0x0}}},
{0xfbd4,{{0x6ad,0x0,0x0}}},
{0xfbd5,{{0x6ad,0x0,0x0}}},
{0xfbd6,{{0x6ad,0x0,0x0}}},
{0xfbd7,{{0x6c7,0x0,0x0}}},
{0xfbd8,{{0x6c7,0x0,0x0}}},
{0xfbd9,{{0x6c6,0x0,0x0}}},
{0xfbda,{{0x6c6,0x0,0x0}}},
{0xfbdb,{{0x6c8,0x0,0x0}}},
{0xfbdc,{{0x6c8,0x0,0x0}}},
{0xfbdd,{{0x677,0x0,0x0}}},
{0xfbde,{{0x6cb,0x0,0x0}}},
{0xfbdf,{{0x6cb,0x0,0x0}}},
{0xfbe0,{{0x6c5,0x0,0x0}}},
{0xfbe1,{{0x6c5,0x0,0x0}}},
{0xfbe2,{{0x6c9,0x0,0x0}}},
{0xfbe3,{{0x6c9,0x0,0x0}}},
{0xfbe4,{{0x6d0,0x0,0x0}}},
{0xfbe5,{{0x6d0,0x0,0x0}}},
{0xfbe6,{{0x6d0,0x0,0x0}}},
{0xfbe7,{{0x6d0,0x0,0x0}}},
{0xfbe8,{{0x649,0x0,0x0}}},
{0xfbe9,{{0x649,0x0,0x0}}},
{0xfbea,{{0x626,0x627,0x0}}},
{0xfbeb,{{0x626,0x627,0x0}}},
{0xfbec,{{0x626,0x6d5,0x0}}},
{0xfbed,{{0x626,0x6d5,0x0}}},
{0xfbee,{{0x626,0x648,0x0}}},
{0xfbef,{{0x626,0x648,0x0}}},
{0xfbf0,{{0x626,0x6c7,0x0}}},
{0xfbf1,{{0x626,0x6c7,0x0}}},
{0xfbf2,{{0x626,0x6c6,0x0}}},
{0xfbf3,{{0x626,0x6c6,0x0}}},
{0xfbf4,{{0x626,0x6c8,0x0}}},
{0xfbf5,{{0x626,0x6c8,0x0}}},
{0xfbf6,{{0x626,0x6d0,0x0}}},
{0xfbf7,{{0x626,0x6d0,0x0}}},
{0xfbf8,{{0x626,0x6d0,0x0}}},
{0xfbf9,{{0x626,0x649,0x0}}},
{0xfbfa,{{0x626,0x649,0x0}}},
{0xfbfb,{{0x626,0x649,0x0}}},
{0xfbfc,{{0x6cc,0x0,0x0}}},
{0xfbfd,{{0x6cc,0x0,0x0}}},
{0xfbfe,{{0x6cc,0x0,0x0}}},
{0xfbff,{{0x6cc,0x0,0x0}}},
{0xfc00,{{0x626,0x62c,0x0}}},
{0xfc01,{{0x626,0x62d,0x0}}},
{0xfc02,{{0x626,0x645,0x0}}},
{0xfc03,{{0x626,0x649,0x0}}},
{0xfc04,{{0x626,0x64a,0x0}}},
{0xfc05,{{0x628,0x62c,0x0}}},
{0xfc06,{{0x628,0x62d,0x0}}},
{0xfc07,{{0x628,0x62e,0x0}}},
{0xfc08,{{0x628,0x645,0x0}}},
{0xfc09,{{0x628,0x649,0x0}}},
{0xfc0a,{{0x628,0x64a,0x0}}},
{0xfc0b,{{0x62a,0x62c,0x0}}},
{0xfc0c,{{0x62a,0x62d,0x0}}},
{0xfc0d,{{0x62a,0x62e,0x0}}},
{0xfc0e,{{0x62a,0x645,0x0}}},
{0xfc0f,{{0x62a,0x649,0x0}}},
{0xfc10,{{0x62a,0x64a,0x0}}},
{0xfc11,{{0x62b,0x62c,0x0}}},
{0xfc12,{{0x62b,0x645,0x0}}},
{0xfc13,{{0x62b,0x649,0x0}}},
{0xfc14,{{0x62b,0x64a,0x0}}},
{0xfc15,{{0x62c,0x62d,0x0}}},
{0xfc16,{{0x62c,0x645,0x0}}},
{0xfc17,{{0x62d,0x62c,0x0}}},
{0xfc18,{{0x62d,0x645,0x0}}},
{0xfc19,{{0x62e,0x62c,0x0}}},
{0xfc1a,{{0x62e,0x62d,0x0}}},
{0xfc1b,{{0x62e,0x645,0x0}}},
{0xfc1c,{{0x633,0x62c,0x0}}},
{0xfc1d,{{0x633,0x62d,0x0}}},
{0xfc1e,{{0x633,0x62e,0x0}}},
{0xfc1f,{{0x633,0x645,0x0}}},
{0xfc20,{{0x635,0x62d,0x0}}},
{0xfc21,{{0x635,0x645,0x0}}},
{0xfc22,{{0x636,0x62c,0x0}}},
{0xfc23,{{0x636,0x62d,0x0}}},
{0xfc24,{{0x636,0x62e,0x0}}},
{0xfc25,{{0x636,0x645,0x0}}},
{0xfc26,{{0x637,0x62d,0x0}}},
{0xfc27,{{0x637,0x645,0x0}}},
{0xfc28,{{0x638,0x645,0x0}}},
{0xfc29,{{0x639,0x62c,0x0}}},
{0xfc2a,{{0x639,0x645,0x0}}},
{0xfc2b,{{0x63a,0x62c,0x0}}},
{0xfc2c,{{0x63a,0x645,0x0}}},
{0xfc2d,{{0x641,0x62c,0x0}}},
{0xfc2e,{{0x641,0x62d,0x0}}},
{0xfc2f,{{0x641,0x62e,0x0}}},
{0xfc30,{{0x641,0x645,0x0}}},
{0xfc31,{{0x641,0x649,0x0}}},
{0xfc32,{{0x641,0x64a,0x0}}},
{0xfc33,{{0x642,0x62d,0x0}}},
{0xfc34,{{0x642,0x645,0x0}}},
{0xfc35,{{0x642,0x649,0x0}}},
{0xfc36,{{0x642,0x64a,0x0}}},
{0xfc37,{{0x643,0x627,0x0}}},
{0xfc38,{{0x643,0x62c,0x0}}},
{0xfc39,{{0x643,0x62d,0x0}}},
{0xfc3a,{{0x643,0x62e,0x0}}},
{0xfc3b,{{0x643,0x644,0x0}}},
{0xfc3c,{{0x643,0x645,0x0}}},
{0xfc3d,{{0x643,0x649,0x0}}},
{0xfc3e,{{0x643,0x64a,0x0}}},
{0xfc3f,{{0x644,0x62c,0x0}}},
{0xfc40,{{0x644,0x62d,0x0}}},
{0xfc41,{{0x644,0x62e,0x0}}},
{0xfc42,{{0x644,0x645,0x0}}},
{0xfc43,{{0x644,0x649,0x0}}},
{0xfc44,{{0x644,0x64a,0x0}}},
{0xfc45,{{0x645,0x62c,0x0}}},
{0xfc46,{{0x645,0x62d,0x0}}},
{0xfc47,{{0x645,0x62e,0x0}}},
{0xfc48,{{0x645,0x645,0x0}}},
{0xfc49,{{0x645,0x649,0x0}}},
{0xfc4a,{{0x645,0x64a,0x0}}},
{0xfc4b,{{0x646,0x62c,0x0}}},
{0xfc4c,{{0x646,0x62d,0x0}}},
{0xfc4d,{{0x646,0x62e,0x0}}},
{0xfc4e,{{0x646,0x645,0x0}}},
{0xfc4f,{{0x646,0x649,0x0}}},
{0xfc50,{{0x646,0x64a,0x0}}},
{0xfc51,{{0x647,0x62c,0x0}}},
{0xfc52,{{0x647,0x645,0x0}}},
{0xfc53,{{0x647,0x649,0x0}}},
{0xfc54,{{0x647,0x64a,0x0}}},
{0xfc55,{{0x64a,0x62c,0x0}}},
{0xfc56,{{0x64a,0x62d,0x0}}},
{0xfc57,{{0x64a,0x62e,0x0}}},
{0xfc58,{{0x64a,0x645,0x0}}},
{0xfc59,{{0x64a,0x649,0x0}}},
{0xfc5a,{{0x64a,0x64a,0x0}}},
{0xfc5b,{{0x630,0x670,0x0}}},
{0xfc5c,{{0x631,0x670,0x0}}},
{0xfc5d,{{0x649,0x670,0x0}}},
{0xfc5e,{{0x20,0x64c,0x651}}},
{0xfc5f,{{0x20,0x64d,0x651}}},
{0xfc60,{{0x20,0x64e,0x651}}},
{0xfc61,{{0x20,0x64f,0x651}}},
{0xfc62,{{0x20,0x650,0x651}}},
{0xfc63,{{0x20,0x651,0x670}}},
{0xfc64,{{0x626,0x631,0x0}}},
{0xfc65,{{0x626,0x632,0x0}}},
{0xfc66,{{0x626,0x645,0x0}}},
{0xfc67,{{0x626,0x646,0x0}}},
{0xfc68,{{0x626,0x649,0x0}}},
{0xfc69,{{0x626,0x64a,0x0}}},
{0xfc6a,{{0x628,0x631,0x0}}},
{0xfc6b,{{0x628,0x632,0x0}}},
{0xfc6c,{{0x628,0x645,0x0}}},
{0xfc6d,{{0x628,0x646,0x0}}},
{0xfc6e,{{0x628,0x649,0x0}}},
{0xfc6f,{{0x628,0x64a,0x0}}},
{0xfc70,{{0x62a,0x631,0x0}}},
{0xfc71,{{0x62a,0x632,0x0}}},
{0xfc72,{{0x62a,0x645,0x0}}},
{0xfc73,{{0x62a,0x646,0x0}}},
{0xfc74,{{0x62a,0x649,0x0}}},
{0xfc75,{{0x62a,0x64a,0x0}}},
{0xfc76,{{0x62b,0x631,0x0}}},
{0xfc77,{{0x62b,0x632,0x0}}},
{0xfc78,{{0x62b,0x645,0x0}}},
{0xfc79,{{0x62b,0x646,0x0}}},
{0xfc7a,{{0x62b,0x649,0x0}}},
{0xfc7b,{{0x62b,0x64a,0x0}}},
{0xfc7c,{{0x641,0x649,0x0}}},
{0xfc7d,{{0x641,0x64a,0x0}}},
{0xfc7e,{{0x642,0x649,0x0}}},
{0xfc7f,{{0x642,0x64a,0x0}}},
{0xfc80,{{0x643,0x627,0x0}}},
{0xfc81,{{0x643,0x644,0x0}}},
{0xfc82,{{0x643,0x645,0x0}}},
{0xfc83,{{0x643,0x649,0x0}}},
{0xfc84,{{0x643,0x64a,0x0}}},
{0xfc85,{{0x644,0x645,0x0}}},
{0xfc86,{{0x644,0x649,0x0}}},
{0xfc87,{{0x644,0x64a,0x0}}},
{0xfc88,{{0x645,0x627,0x0}}},
{0xfc89,{{0x645,0x645,0x0}}},
{0xfc8a,{{0x646,0x631,0x0}}},
{0xfc8b,{{0x646,0x632,0x0}}},
{0xfc8c,{{0x646,0x645,0x0}}},
{0xfc8d,{{0x646,0x646,0x0}}},
{0xfc8e,{{0x646,0x649,0x0}}},
{0xfc8f,{{0x646,0x64a,0x0}}},
{0xfc90,{{0x649,0x670,0x0}}},
{0xfc91,{{0x64a,0x631,0x0}}},
{0xfc92,{{0x64a,0x632,0x0}}},
{0xfc93,{{0x64a,0x645,0x0}}},
{0xfc94,{{0x64a,0x646,0x0}}},
{0xfc95,{{0x64a,0x649,0x0}}},
{0xfc96,{{0x64a,0x64a,0x0}}},
{0xfc97,{{0x626,0x62c,0x0}}},
{0xfc98,{{0x626,0x62d,0x0}}},
{0xfc99,{{0x626,0x62e,0x0}}},
{0xfc9a,{{0x626,0x645,0x0}}},
{0xfc9b,{{0x626,0x647,0x0}}},
{0xfc9c,{{0x628,0x62c,0x0}}},
{0xfc9d,{{0x628,0x62d,0x0}}},
{0xfc9e,{{0x628,0x62e,0x0}}},
{0xfc9f,{{0x628,0x645,0x0}}},
{0xfca0,{{0x628,0x647,0x0}}},
{0xfca1,{{0x62a,0x62c,0x0}}},
{0xfca2,{{0x62a,0x62d,0x0}}},
{0xfca3,{{0x62a,0x62e,0x0}}},
{0xfca4,{{0x62a,0x645,0x0}}},
{0xfca5,{{0x62a,0x647,0x0}}},
{0xfca6,{{0x62b,0x645,0x0}}},
{0xfca7,{{0x62c,0x62d,0x0}}},
{0xfca8,{{0x62c,0x645,0x0}}},
{0xfca9,{{0x62d,0x62c,0x0}}},
{0xfcaa,{{0x62d,0x645,0x0}}},
{0xfcab,{{0x62e,0x62c,0x0}}},
{0xfcac,{{0x62e,0x645,0x0}}},
{0xfcad,{{0x633,0x62c,0x0}}},
{0xfcae,{{0x633,0x62d,0x0}}},
{0xfcaf,{{0x633,0x62e,0x0}}},
{0xfcb0,{{0x633,0x645,0x0}}},
{0xfcb1,{{0x635,0x62d,0x0}}},
{0xfcb2,{{0x635,0x62e,0x0}}},
{0xfcb3,{{0x635,0x645,0x0}}},
{0xfcb4,{{0x636,0x62c,0x0}}},
{0xfcb5,{{0x636,0x62d,0x0}}},
{0xfcb6,{{0x636,0x62e,0x0}}},
{0xfcb7,{{0x636,0x645,0x0}}},
{0xfcb8,{{0x637,0x62d,0x0}}},
{0xfcb9,{{0x638,0x645,0x0}}},
{0xfcba,{{0x639,0x62c,0x0}}},
{0xfcbb,{{0x639,0x645,0x0}}},
{0xfcbc,{{0x63a,0x62c,0x0}}},
{0xfcbd,{{0x63a,0x645,0x0}}},
{0xfcbe,{{0x641,0x62c,0x0}}},
{0xfcbf,{{0x641,0x62d,0x0}}},
{0xfcc0,{{0x641,0x62e,0x0}}},
{0xfcc1,{{0x641,0x645,0x0}}},
{0xfcc2,{{0x642,0x62d,0x0}}},
{0xfcc3,{{0x642,0x645,0x0}}},
{0xfcc4,{{0x643,0x62c,0x0}}},
{0xfcc5,{{0x643,0x62d,0x0}}},
{0xfcc6,{{0x643,0x62e,0x0}}},
{0xfcc7,{{0x643,0x644,0x0}}},
{0xfcc8,{{0x643,0x645,0x0}}},
{0xfcc9,{{0x644,0x62c,0x0}}},
{0xfcca,{{0x644,0x62d,0x0}}},
{0xfccb,{{0x644,0x62e,0x0}}},
{0xfccc,{{0x644,0x645,0x0}}},
{0xfccd,{{0x644,0x647,0x0}}},
{0xfcce,{{0x645,0x62c,0x0}}},
{0xfccf,{{0x645,0x62d,0x0}}},
{0xfcd0,{{0x645,0x62e,0x0}}},
{0xfcd1,{{0x645,0x645,0x0}}},
{0xfcd2,{{0x646,0x62c,0x0}}},
{0xfcd3,{{0x646,0x62d,0x0}}},
{0xfcd4,{{0x646,0x62e,0x0}}},
{0xfcd5,{{0x646,0x645,0x0}}},
{0xfcd6,{{0x646,0x647,0x0}}},
{0xfcd7,{{0x647,0x62c,0x0}}},
{0xfcd8,{{0x647,0x645,0x0}}},
{0xfcd9,{{0x647,0x670,0x0}}},
{0xfcda,{{0x64a,0x62c,0x0}}},
{0xfcdb,{{0x64a,0x62d,0x0}}},
{0xfcdc,{{0x64a,0x62e,0x0}}},
{0xfcdd,{{0x64a,0x645,0x0}}},
{0xfcde,{{0x64a,0x647,0x0}}},
{0xfcdf,{{0x626,0x645,0x0}}},
{0xfce0,{{0x626,0x647,0x0}}},
{0xfce1,{{0x628,0x645,0x0}}},
{0xfce2,{{0x628,0x647,0x0}}},
{0xfce3,{{0x62a,0x645,0x0}}},
{0xfce4,{{0x62a,0x647,0x0}}},
{0xfce5,{{0x62b,0x645,0x0}}},
{0xfce6,{{0x62b,0x647,0x0}}},
{0xfce7,{{0x633,0x645,0x0}}},
{0xfce8,{{0x633,0x647,0x0}}},
{0xfce9,{{0x634,0x645,0x0}}},
{0xfcea,{{0x634,0x647,0x0}}},
{0xfceb,{{0x643,0x644,0x0}}},
{0xfcec,{{0x643,0x645,0x0}}},
{0xfced,{{0x644,0x645,0x0}}},
{0xfcee,{{0x646,0x645,0x0}}},
{0xfcef,{{0x646,0x647,0x0}}},
{0xfcf0,{{0x64a,0x645,0x0}}},
{0xfcf1,{{0x64a,0x647,0x0}}},
{0xfcf2,{{0x640,0x64e,0x651}}},
{0xfcf3,{{0x640,0x64f,0x651}}},
{0xfcf4,{{0x640,0x650,0x651}}},
{0xfcf5,{{0x637,0x649,0x0}}},
{0xfcf6,{{0x637,0x64a,0x0}}},
{0xfcf7,{{0x639,0x649,0x0}}},
{0xfcf8,{{0x639,0x64a,0x0}}},
{0xfcf9,{{0x63a,0x649,0x0}}},
{0xfcfa,{{0x63a,0x64a,0x0}}},
{0xfcfb,{{0x633,0x649,0x0}}},
{0xfcfc,{{0x633,0x64a,0x0}}},
{0xfcfd,{{0x634,0x649,0x0}}},
{0xfcfe,{{0x634,0x64a,0x0}}},
{0xfcff,{{0x62d,0x649,0x0}}},
{0xfd00,{{0x62d,0x64a,0x0}}},
{0xfd01,{{0x62c,0x649,0x0}}},
{0xfd02,{{0x62c,0x64a,0x0}}},
{0xfd03,{{0x62e,0x649,0x0}}},
{0xfd04,{{0x62e,0x64a,0x0}}},
{0xfd05,{{0x635,0x649,0x0}}},
{0xfd06,{{0x635,0x64a,0x0}}},
{0xfd07,{{0x636,0x649,0x0}}},
{0xfd08,{{0x636,0x64a,0x0}}},
{0xfd09,{{0x634,0x62c,0x0}}},
{0xfd0a,{{0x634,0x62d,0x0}}},
{0xfd0b,{{0x634,0x62e,0x0}}},
{0xfd0c,{{0x634,0x645,0x0}}},
{0xfd0d,{{0x634,0x631,0x0}}},
{0xfd0e,{{0x633,0x631,0x0}}},
{0xfd0f,{{0x635,0x631,0x0}}},
{0xfd10,{{0x636,0x631,0x0}}},
{0xfd11,{{0x637,0x649,0x0}}},
{0xfd12,{{0x637,0x64a,0x0}}},
{0xfd13,{{0x639,0x649,0x0}}},
{0xfd14,{{0x639,0x64a,0x0}}},
{0xfd15,{{0x63a,0x649,0x0}}},
{0xfd16,{{0x63a,0x64a,0x0}}},
{0xfd17,{{0x633,0x649,0x0}}},
{0xfd18,{{0x633,0x64a,0x0}}},
{0xfd19,{{0x634,0x649,0x0}}},
{0xfd1a,{{0x634,0x64a,0x0}}},
{0xfd1b,{{0x62d,0x649,0x0}}},
{0xfd1c,{{0x62d,0x64a,0x0}}},
{0xfd1d,{{0x62c,0x649,0x0}}},
{0xfd1e,{{0x62c,0x64a,0x0}}},
{0xfd1f,{{0x62e,0x649,0x0}}},
{0xfd20,{{0x62e,0x64a,0x0}}},
{0xfd21,{{0x635,0x649,0x0}}},
{0xfd22,{{0x635,0x64a,0x0}}},
{0xfd23,{{0x636,0x649,0x0}}},
{0xfd24,{{0x636,0x64a,0x0}}},
{0xfd25,{{0x634,0x62c,0x0}}},
{0xfd26,{{0x634,0x62d,0x0}}},
{0xfd27,{{0x634,0x62e,0x0}}},
{0xfd28,{{0x634,0x645,0x0}}},
{0xfd29,{{0x634,0x631,0x0}}},
{0xfd2a,{{0x633,0x631,0x0}}},
{0xfd2b,{{0x635,0x631,0x0}}},
{0xfd2c,{{0x636,0x631,0x0}}},
{0xfd2d,{{0x634,0x62c,0x0}}},
{0xfd2e,{{0x634,0x62d,0x0}}},
{0xfd2f,{{0x634,0x62e,0x0}}},
{0xfd30,{{0x634,0x645,0x0}}},
{0xfd31,{{0x633,0x647,0x0}}},
{0xfd32,{{0x634,0x647,0x0}}},
{0xfd33,{{0x637,0x645,0x0}}},
{0xfd34,{{0x633,0x62c,0x0}}},
{0xfd35,{{0x633,0x62d,0x0}}},
{0xfd36,{{0x633,0x62e,0x0}}},
{0xfd37,{{0x634,0x62c,0x0}}},
{0xfd38,{{0x634,0x62d,0x0}}},
{0xfd39,{{0x634,0x62e,0x0}}},
{0xfd3a,{{0x637,0x645,0x0}}},
{0xfd3b,{{0x638,0x645,0x0}}},
{0xfd3c,{{0x627,0x64b,0x0}}},
{0xfd3d,{{0x627,0x64b,0x0}}},
{0xfd50,{{0x62a,0x62c,0x645}}},
{0xfd51,{{0x62a,0x62d,0x62c}}},
{0xfd52,{{0x62a,0x62d,0x62c}}},
{0xfd53,{{0x62a,0x62d,0x645}}},
{0xfd54,{{0x62a,0x62e,0x645}}},
{0xfd55,{{0x62a,0x645,0x62c}}},
{0xfd56,{{0x62a,0x645,0x62d}}},
{0xfd57,{{0x62a,0x645,0x62e}}},
{0xfd58,{{0x62c,0x645,0x62d}}},
{0xfd59,{{0x62c,0x645,0x62d}}},
{0xfd5a,{{0x62d,0x645,0x64a}}},
{0xfd5b,{{0x62d,0x645,0x649}}},
{0xfd5c,{{0x633,0x62d,0x62c}}},
{0xfd5d,{{0x633,0x62c,0x62d}}},
{0xfd5e,{{0x633,0x62c,0x649}}},
{0xfd5f,{{0x633,0x645,0x62d}}},
{0xfd60,{{0x633,0x645,0x62d}}},
{0xfd61,{{0x633,0x645,0x62c}}},
{0xfd62,{{0x633,0x645,0x645}}},
{0xfd63,{{0x633,0x645,0x645}}},
{0xfd64,{{0x635,0x62d,0x62d}}},
{0xfd65,{{0x635,0x62d,0x62d}}},
{0xfd66,{{0x635,0x645,0x645}}},
{0xfd67,{{0x634,0x62d,0x645}}},
{0xfd68,{{0x634,0x62d,0x645}}},
{0xfd69,{{0x634,0x62c,0x64a}}},
{0xfd6a,{{0x634,0x645,0x62e}}},
{0xfd6b,{{0x634,0x645,0x62e}}},
{0xfd6c,{{0x634,0x645,0x645}}},
{0xfd6d,{{0x634,0x645,0x645}}},
{0xfd6e,{{0x636,0x62d,0x649}}},
{0xfd6f,{{0x636,0x62e,0x645}}},
{0xfd70,{{0x636,0x62e,0x645}}},
{0xfd71,{{0x637,0x645,0x62d}}},
{0xfd72,{{0x637,0x645,0x62d}}},
{0xfd73,{{0x637,0x645,0x645}}},
{0xfd74,{{0x637,0x645,0x64a}}},
{0xfd75,{{0x639,0x62c,0x645}}},
{0xfd76,{{0x639,0x645,0x645}}},
{0xfd77,{{0x639,0x645,0x645}}},
{0xfd78,{{0x639,0x645,0x649}}},
{0xfd79,{{0x63a,0x645,0x645}}},
{0xfd7a,{{0x63a,0x645,0x64a}}},
{0xfd7b,{{0x63a,0x645,0x649}}},
{0xfd7c,{{0x641,0x62e,0x645}}},
{0xfd7d,{{0x641,0x62e,0x645}}},
{0xfd7e,{{0x642,0x645,0x62d}}},
{0xfd7f,{{0x642,0x645,0x645}}},
{0xfd80,{{0x644,0x62d,0x645}}},
{0xfd81,{{0x644,0x62d,0x64a}}},
{0xfd82,{{0x644,0x62d,0x649}}},
{0xfd83,{{0x644,0x62c,0x62c}}},
{0xfd84,{{0x644,0x62c,0x62c}}},
{0xfd85,{{0x644,0x62e,0x645}}},
{0xfd86,{{0x644,0x62e,0x645}}},
{0xfd87,{{0x644,0x645,0x62d}}},
{0xfd88,{{0x644,0x645,0x62d}}},
{0xfd89,{{0x645,0x62d,0x62c}}},
{0xfd8a,{{0x645,0x62d,0x645}}},
{0xfd8b,{{0x645,0x62d,0x64a}}},
{0xfd8c,{{0x645,0x62c,0x62d}}},
{0xfd8d,{{0x645,0x62c,0x645}}},
{0xfd8e,{{0x645,0x62e,0x62c}}},
{0xfd8f,{{0x645,0x62e,0x645}}},
{0xfd92,{{0x645,0x62c,0x62e}}},
{0xfd93,{{0x647,0x645,0x62c}}},
{0xfd94,{{0x647,0x645,0x645}}},
{0xfd95,{{0x646,0x62d,0x645}}},
{0xfd96,{{0x646,0x62d,0x649}}},
{0xfd97,{{0x646,0x62c,0x645}}},
{0xfd98,{{0x646,0x62c,0x645}}},
{0xfd99,{{0x646,0x62c,0x649}}},
{0xfd9a,{{0x646,0x645,0x64a}}},
{0xfd9b,{{0x646,0x645,0x649}}},
{0xfd9c,{{0x64a,0x645,0x645}}},
{0xfd9d,{{0x64a,0x645,0x645}}},
{0xfd9e,{{0x628,0x62e,0x64a}}},
{0xfd9f,{{0x62a,0x62c,0x64a}}},
{0xfda0,{{0x62a,0x62c,0x649}}},
{0xfda1,{{0x62a,0x62e,0x64a}}},
{0xfda2,{{0x62a,0x62e,0x649}}},
{0xfda3,{{0x62a,0x645,0x64a}}},
{0xfda4,{{0x62a,0x645,0x649}}},
{0xfda5,{{0x62c,0x645,0x64a}}},
{0xfda6,{{0x62c,0x62d,0x649}}},
{0xfda7,{{0x62c,0x645,0x649}}},
{0xfda8,{{0x633,0x62e,0x649}}},
{0xfda9,{{0x635,0x62d,0x64a}}},
{0xfdaa,{{0x634,0x62d,0x64a}}},
{0xfdab,{{0x636,0x62d,0x64a}}},
{0xfdac,{{0x644,0x62c,0x64a}}},
{0xfdad,{{0x644,0x645,0x64a}}},
{0xfdae,{{0x64a,0x62d,0x64a}}},
{0xfdaf,{{0x64a,0x62c,0x64a}}},
{0xfdb0,{{0x64a,0x645,0x64a}}},
{0xfdb1,{{0x645,0x645,0x64a}}},
{0xfdb2,{{0x642,0x645,0x64a}}},
{0xfdb3,{{0x646,0x62d,0x64a}}},
{0xfdb4,{{0x642,0x645,0x62d}}},
{0xfdb5,{{0x644,0x62d,0x645}}},
{0xfdb6,{{0x639,0x645,0x64a}}},
{0xfdb7,{{0x643,0x645,0x64a}}},
{0xfdb8,{{0x646,0x62c,0x62d}}},
{0xfdb9,{{0x645,0x62e,0x64a}}},
{0xfdba,{{0x644,0x62c,0x645}}},
{0xfdbb,{{0x643,0x645,0x645}}},
{0xfdbc,{{0x644,0x62c,0x645}}},
{0xfdbd,{{0x646,0x62c,0x62d}}},
{0xfdbe,{{0x62c,0x62d,0x64a}}},
{0xfdbf,{{0x62d,0x62c,0x64a}}},
{0xfdc0,{{0x645,0x62c,0x64a}}},
{0xfdc1,{{0x641,0x645,0x64a}}},
{0xfdc2,{{0x628,0x62d,0x64a}}},
{0xfdc3,{{0x643,0x645,0x645}}},
{0xfdc4,{{0x639,0x62c,0x645}}},
{0xfdc5,{{0x635,0x645,0x645}}},
{0xfdc6,{{0x633,0x62e,0x64a}}},
{0xfdc7,{{0x646,0x62c,0x64a}}},
{0xfdf0,{{0x635,0x644,0x6d2}}},
{0xfdf1,{{0x642,0x644,0x6d2}}},
{0xfdf9,{{0x635,0x644,0x649}}},
{0xfe10,{{0x2c,0x0,0x0}}},
{0xfe11,{{0x3001,0x0,0x0}}},
{0xfe12,{{0x3002,0x0,0x0}}},
{0xfe13,{{0x3a,0x0,0x0}}},
{0xfe14,{{0x3b,0x0,0x0}}},
{0xfe15,{{0x21,0x0,0x0}}},
{0xfe16,{{0x3f,0x0,0x0}}},
{0xfe17,{{0x3016,0x0,0x0}}},
{0xfe18,{{0x3017,0x0,0x0}}},
{0xfe19,{{0x2026,0x0,0x0}}},
{0xfe30,{{0x2025,0x0,0x0}}},
{0xfe31,{{0x2014,0x0,0x0}}},
{0xfe32,{{0x2013,0x0,0x0}}},
{0xfe33,{{0x5f,0x0,0x0}}},
{0xfe34,{{0x5f,0x0,0x0}}},
{0xfe35,{{0x28,0x0,0x0}}},
{0xfe36,{{0x29,0x0,0x0}}},
{0xfe37,{{0x7b,0x0,0x0}}},
{0xfe38,{{0x7d,0x0,0x0}}},
{0xfe39,{{0x3014,0x0,0x0}}},
{0xfe3a,{{0x3015,0x0,0x0}}},
{0xfe3b,{{0x3010,0x0,0x0}}},
{0xfe3c,{{0x3011,0x0,0x0}}},
{0xfe3d,{{0x300a,0x0,0x0}}},
{0xfe3e,{{0x300b,0x0,0x0}}},
{0xfe3f,{{0x3008,0x0,0x0}}},
{0xfe40,{{0x3009,0x0,0x0}}},
{0xfe41,{{0x300c,0x0,0x0}}},
{0xfe42,{{0x300d,0x0,0x0}}},
{0xfe43,{{0x300e,0x0,0x0}}},
{0xfe44,{{0x300f,0x0,0x0}}},
{0xfe47,{{0x5b,0x0,0x0}}},
{0xfe48,{{0x5d,0x0,0x0}}},
{0xfe49,{{0x203e,0x0,0x0}}},
{0xfe4a,{{0x203e,0x0,0x0}}},
{0xfe4b,{{0x203e,0x0,0x0}}},
{0xfe4c,{{0x203e,0x0,0x0}}},
{0xfe4d,{{0x5f,0x0,0x0}}},
{0xfe4e,{{0x5f,0x0,0x0}}},
{0xfe4f,{{0x5f,0x0,0x0}}},
{0xfe50,{{0x2c,0x0,0x0}}},
{0xfe51,{{0x3001,0x0,0x0}}},
{0xfe52,{{0x2e,0x0,0x0}}},
{0xfe54,{{0x3b,0x0,0x0}}},
{0xfe55,{{0x3a,0x0,0x0}}},
{0xfe56,{{0x3f,0x0,0x0}}},
{0xfe57,{{0x21,0x0,0x0}}},
{0xfe58,{{0x2014,0x0,0x0}}},
{0xfe59,{{0x28,0x0,0x0}}},
{0xfe5a,{{0x29,0x0,0x0}}},
{0xfe5b,{{0x7b,0x0,0x0}}},
{0xfe5c,{{0x7d,0x0,0x0}}},
{0xfe5d,{{0x3014,0x0,0x0}}},
{0xfe5e,{{0x3015,0x0,0x0}}},
{0xfe5f,{{0x23,0x0,0x0}}},
{0xfe60,{{0x26,0x0,0x0}}},
{0xfe61,{{0x2a,0x0,0x0}}},
{0xfe62,{{0x2b,0x0,0x0}}},
{0xfe63,{{0x2d,0x0,0x0}}},
{0xfe64,{{0x3c,0x0,0x0}}},
{0xfe65,{{0x3e,0x0,0x0}}},
{0xfe66,{{0x3d,0x0,0x0}}},
{0xfe68,{{0x5c,0x0,0x0}}},
{0xfe69,{{0x24,0x0,0x0}}},
{0xfe6a,{{0x25,0x0,0x0}}},
{0xfe6b,{{0x40,0x0,0x0}}},
{0xfe70,{{0x20,0x64b,0x0}}},
{0xfe71,{{0x640,0x64b,0x0}}},
{0xfe72,{{0x20,0x64c,0x0}}},
{0xfe74,{{0x20,0x64d,0x0}}},
{0xfe76,{{0x20,0x64e,0x0}}},
{0xfe77,{{0x640,0x64e,0x0}}},
{0xfe78,{{0x20,0x64f,0x0}}},
{0xfe79,{{0x640,0x64f,0x0}}},
{0xfe7a,{{0x20,0x650,0x0}}},
{0xfe7b,{{0x640,0x650,0x0}}},
{0xfe7c,{{0x20,0x651,0x0}}},
{0xfe7d,{{0x640,0x651,0x0}}},
{0xfe7e,{{0x20,0x652,0x0}}},
{0xfe7f,{{0x640,0x652,0x0}}},
{0xfe80,{{0x621,0x0,0x0}}},
{0xfe81,{{0x622,0x0,0x0}}},
{0xfe82,{{0x622,0x0,0x0}}},
{0xfe83,{{0x623,0x0,0x0}}},
{0xfe84,{{0x623,0x0,0x0}}},
{0xfe85,{{0x624,0x0,0x0}}},
{0xfe86,{{0x624,0x0,0x0}}},
{0xfe87,{{0x625,0x0,0x0}}},
{0xfe88,{{0x625,0x0,0x0}}},
{0xfe89,{{0x626,0x0,0x0}}},
{0xfe8a,{{0x626,0x0,0x0}}},
{0xfe8b,{{0x626,0x0,0x0}}},
{0xfe8c,{{0x626,0x0,0x0}}},
{0xfe8d,{{0x627,0x0,0x0}}},
{0xfe8e,{{0x627,0x0,0x0}}},
{0xfe8f,{{0x628,0x0,0x0}}},
{0xfe90,{{0x628,0x0,0x0}}},
{0xfe91,{{0x628,0x0,0x0}}},
{0xfe92,{{0x628,0x0,0x0}}},
{0xfe93,{{0x629,0x0,0x0}}},
{0xfe94,{{0x629,0x0,0x0}}},
{0xfe95,{{0x62a,0x0,0x0}}},
{0xfe96,{{0x62a,0x0,0x0}}},
{0xfe97,{{0x62a,0x0,0x0}}},
{0xfe98,{{0x62a,0x0,0x0}}},
{0xfe99,{{0x62b,0x0,0x0}}},
{0xfe9a,{{0x62b,0x0,0x0}}},
{0xfe9b,{{0x62b,0x0,0x0}}},
{0xfe9c,{{0x62b,0x0,0x0}}},
{0xfe9d,{{0x62c,0x0,0x0}}},
{0xfe9e,{{0x62c,0x0,0x0}}},
{0xfe9f,{{0x62c,0x0,0x0}}},
{0xfea0,{{0x62c,0x0,0x0}}},
{0xfea1,{{0x62d,0x0,0x0}}},
{0xfea2,{{0x62d,0x0,0x0}}},
{0xfea3,{{0x62d,0x0,0x0}}},
{0xfea4,{{0x62d,0x0,0x0}}},
{0xfea5,{{0x62e,0x0,0x0}}},
{0xfea6,{{0x62e,0x0,0x0}}},
{0xfea7,{{0x62e,0x0,0x0}}},
{0xfea8,{{0x62e,0x0,0x0}}},
{0xfea9,{{0x62f,0x0,0x0}}},
{0xfeaa,{{0x62f,0x0,0x0}}},
{0xfeab,{{0x630,0x0,0x0}}},
{0xfeac,{{0x630,0x0,0x0}}},
{0xfead,{{0x631,0x0,0x0}}},
{0xfeae,{{0x631,0x0,0x0}}},
{0xfeaf,{{0x632,0x0,0x0}}},
{0xfeb0,{{0x632,0x0,0x0}}},
{0xfeb1,{{0x633,0x0,0x0}}},
{0xfeb2,{{0x633,0x0,0x0}}},
{0xfeb3,{{0x633,0x0,0x0}}},
{0xfeb4,{{0x633,0x0,0x0}}},
{0xfeb5,{{0x634,0x0,0x0}}},
{0xfeb6,{{0x634,0x0,0x0}}},
{0xfeb7,{{0x634,0x0,0x0}}},
{0xfeb8,{{0x634,0x0,0x0}}},
{0xfeb9,{{0x635,0x0,0x0}}},
{0xfeba,{{0x635,0x0,0x0}}},
{0xfebb,{{0x635,0x0,0x0}}},
{0xfebc,{{0x635,0x0,0x0}}},
{0xfebd,{{0x636,0x0,0x0}}},
{0xfebe,{{0x636,0x0,0x0}}},
{0xfebf,{{0x636,0x0,0x0}}},
{0xfec0,{{0x636,0x0,0x0}}},
{0xfec1,{{0x637,0x0,0x0}}},
{0xfec2,{{0x637,0x0,0x0}}},
{0xfec3,{{0x637,0x0,0x0}}},
{0xfec4,{{0x637,0x0,0x0}}},
{0xfec5,{{0x638,0x0,0x0}}},
{0xfec6,{{0x638,0x0,0x0}}},
{0xfec7,{{0x638,0x0,0x0}}},
{0xfec8,{{0x638,0x0,0x0}}},
{0xfec9,{{0x639,0x0,0x0}}},
{0xfeca,{{0x639,0x0,0x0}}},
{0xfecb,{{0x639,0x0,0x0}}},
{0xfecc,{{0x639,0x0,0x0}}},
{0xfecd,{{0x63a,0x0,0x0}}},
{0xfece,{{0x63a,0x0,0x0}}},
{0xfecf,{{0x63a,0x0,0x0}}},
{0xfed0,{{0x63a,0x0,0x0}}},
{0xfed1,{{0x641,0x0,0x0}}},
{0xfed2,{{0x641,0x0,0x0}}},
{0xfed3,{{0x641,0x0,0x0}}},
{0xfed4,{{0x641,0x0,0x0}}},
{0xfed5,{{0x642,0x0,0x0}}},
{0xfed6,{{0x642,0x0,0x0}}},
{0xfed7,{{0x642,0x0,0x0}}},
{0xfed8,{{0x642,0x0,0x0}}},
{0xfed9,{{0x643,0x0,0x0}}},
{0xfeda,{{0x643,0x0,0x0}}},
{0xfedb,{{0x643,0x0,0x0}}},
{0xfedc,{{0x643,0x0,0x0}}},
{0xfedd,{{0x644,0x0,0x0}}},
{0xfede,{{0x644,0x0,0x0}}},
{0xfedf,{{0x644,0x0,0x0}}},
{0xfee0,{{0x644,0x0,0x0}}},
{0xfee1,{{0x645,0x0,0x0}}},
{0xfee2,{{0x645,0x0,0x0}}},
{0xfee3,{{0x645,0x0,0x0}}},
{0xfee4,{{0x645,0x0,0x0}}},
{0xfee5,{{0x646,0x0,0x0}}},
{0xfee6,{{0x646,0x0,0x0}}},
{0xfee7,{{0x646,0x0,0x0}}},
{0xfee8,{{0x646,0x0,0x0}}},
{0xfee9,{{0x647,0x0,0x0}}},
{0xfeea,{{0x647,0x0,0x0}}},
{0xfeeb,{{0x647,0x0,0x0}}},
{0xfeec,{{0x647,0x0,0x0}}},
{0xfeed,{{0x648,0x0,0x0}}},
{0xfeee,{{0x648,0x0,0x0}}},
{0xfeef,{{0x649,0x0,0x0}}},
{0xfef0,{{0x649,0x0,0x0}}},
{0xfef1,{{0x64a,0x0,0x0}}},
{0xfef2,{{0x64a,0x0,0x0}}},
{0xfef3,{{0x64a,0x0,0x0}}},
{0xfef4,{{0x64a,0x0,0x0}}},
{0xfef5,{{0x644,0x622,0x0}}},
{0xfef6,{{0x644,0x622,0x0}}},
{0xfef7,{{0x644,0x623,0x0}}},
{0xfef8,{{0x644,0x623,0x0}}},
{0xfef9,{{0x644,0x625,0x0}}},
{0xfefa,{{0x644,0x625,0x0}}},
{0xfefb,{{0x644,0x627,0x0}}},
{0xfefc,{{0x644,0x627,0x0}}},
{0xff01,{{0x21,0x0,0x0}}},
{0xff02,{{0x22,0x0,0x0}}},
{0xff03,{{0x23,0x0,0x0}}},
{0xff04,{{0x24,0x0,0x0}}},
{0xff05,{{0x25,0x0,0x0}}},
{0xff06,{{0x26,0x0,0x0}}},
{0xff07,{{0x27,0x0,0x0}}},
{0xff08,{{0x28,0x0,0x0}}},
{0xff09,{{0x29,0x0,0x0}}},
{0xff0a,{{0x2a,0x0,0x0}}},
{0xff0b,{{0x2b,0x0,0x0}}},
{0xff0c,{{0x2c,0x0,0x0}}},
{0xff0d,{{0x2d,0x0,0x0}}},
{0xff0e,{{0x2e,0x0,0x0}}},
{0xff0f,{{0x2f,0x0,0x0}}},
{0xff10,{{0x30,0x0,0x0}}},
{0xff11,{{0x31,0x0,0x0}}},
{0xff12,{{0x32,0x0,0x0}}},
{0xff13,{{0x33,0x0,0x0}}},
{0xff14,{{0x34,0x0,0x0}}},
{0xff15,{{0x35,0x0,0x0}}},
{0xff16,{{0x36,0x0,0x0}}},
{0xff17,{{0x37,0x0,0x0}}},
{0xff18,{{0x38,0x0,0x0}}},
{0xff19,{{0x39,0x0,0x0}}},
{0xff1a,{{0x3a,0x0,0x0}}},
{0xff1b,{{0x3b,0x0,0x0}}},
{0xff1c,{{0x3c,0x0,0x0}}},
{0xff1d,{{0x3d,0x0,0x0}}},
{0xff1e,{{0x3e,0x0,0x0}}},
{0xff1f,{{0x3f,0x0,0x0}}},
{0xff20,{{0x40,0x0,0x0}}},
{0xff21,{{0x41,0x0,0x0}}},
{0xff22,{{0x42,0x0,0x0}}},
{0xff23,{{0x43,0x0,0x0}}},
{0xff24,{{0x44,0x0,0x0}}},
{0xff25,{{0x45,0x0,0x0}}},
{0xff26,{{0x46,0x0,0x0}}},
{0xff27,{{0x47,0x0,0x0}}},
{0xff28,{{0x48,0x0,0x0}}},
{0xff29,{{0x49,0x0,0x0}}},
{0xff2a,{{0x4a,0x0,0x0}}},
{0xff2b,{{0x4b,0x0,0x0}}},
{0xff2c,{{0x4c,0x0,0x0}}},
{0xff2d,{{0x4d,0x0,0x0}}},
{0xff2e,{{0x4e,0x0,0x0}}},
{0xff2f,{{0x4f,0x0,0x0}}},
{0xff30,{{0x50,0x0,0x0}}},
{0xff31,{{0x51,0x0,0x0}}},
{0xff32,{{0x52,0x0,0x0}}},
{0xff33,{{0x53,0x0,0x0}}},
{0xff34,{{0x54,0x0,0x0}}},
{0xff35,{{0x55,0x0,0x0}}},
{0xff36,{{0x56,0x0,0x0}}},
{0xff37,{{0x57,0x0,0x0}}},
{0xff38,{{0x58,0x0,0x0}}},
{0xff39,{{0x59,0x0,0x0}}},
{0xff3a,{{0x5a,0x0,0x0}}},
{0xff3b,{{0x5b,0x0,0x0}}},
{0xff3c,{{0x5c,0x0,0x0}}},
{0xff3d,{{0x5d,0x0,0x0}}},
{0xff3e,{{0x5e,0x0,0x0}}},
{0xff3f,{{0x5f,0x0,0x0}}},
{0xff40,{{0x60,0x0,0x0}}},
{0xff41,{{0x61,0x0,0x0}}},
{0xff42,{{0x62,0x0,0x0}}},
{0xff43,{{0x63,0x0,0x0}}},
{0xff44,{{0x64,0x0,0x0}}},
{0xff45,{{0x65,0x0,0x0}}},
{0xff46,{{0x66,0x0,0x0}}},
{0xff47,{{0x67,0x0,0x0}}},
{0xff48,{{0x68,0x0,0x0}}},
{0xff49,{{0x69,0x0,0x0}}},
{0xff4a,{{0x6a,0x0,0x0}}},
{0xff4b,{{0x6b,0x0,0x0}}},
{0xff4c,{{0x6c,0x0,0x0}}},
{0xff4d,{{0x6d,0x0,0x0}}},
{0xff4e,{{0x6e,0x0,0x0}}},
{0xff4f,{{0x6f,0x0,0x0}}},
{0xff50,{{0x70,0x0,0x0}}},
{0xff51,{{0x71,0x0,0x0}}},
{0xff52,{{0x72,0x0,0x0}}},
{0xff53,{{0x73,0x0,0x0}}},
{0xff54,{{0x74,0x0,0x0}}},
{0xff55,{{0x75,0x0,0x0}}},
{0xff56,{{0x76,0x0,0x0}}},
{0xff57,{{0x77,0x0,0x0}}},
{0xff58,{{0x78,0x0,0x0}}},
{0xff59,{{0x79,0x0,0x0}}},
{0xff5a,{{0x7a,0x0,0x0}}},
{0xff5b,{{0x7b,0x0,0x0}}},
{0xff5c,{{0x7c,0x0,0x0}}},
{0xff5d,{{0x7d,0x0,0x0}}},
{0xff5e,{{0x7e,0x0,0x0}}},
{0xff5f,{{0x2985,0x0,0x0}}},
{0xff60,{{0x2986,0x0,0x0}}},
{0xff61,{{0x3002,0x0,0x0}}},
{0xff62,{{0x300c,0x0,0x0}}},
{0xff63,{{0x300d,0x0,0x0}}},
{0xff64,{{0x3001,0x0,0x0}}},
{0xff65,{{0x30fb,0x0,0x0}}},
{0xff66,{{0x30f2,0x0,0x0}}},
{0xff67,{{0x30a1,0x0,0x0}}},
{0xff68,{{0x30a3,0x0,0x0}}},
{0xff69,{{0x30a5,0x0,0x0}}},
{0xff6a,{{0x30a7,0x0,0x0}}},
{0xff6b,{{0x30a9,0x0,0x0}}},
{0xff6c,{{0x30e3,0x0,0x0}}},
{0xff6d,{{0x30e5,0x0,0x0}}},
{0xff6e,{{0x30e7,0x0,0x0}}},
{0xff6f,{{0x30c3,0x0,0x0}}},
{0xff70,{{0x30fc,0x0,0x0}}},
{0xff71,{{0x30a2,0x0,0x0}}},
{0xff72,{{0x30a4,0x0,0x0}}},
{0xff73,{{0x30a6,0x0,0x0}}},
{0xff74,{{0x30a8,0x0,0x0}}},
{0xff75,{{0x30aa,0x0,0x0}}},
{0xff76,{{0x30ab,0x0,0x0}}},
{0xff77,{{0x30ad,0x0,0x0}}},
{0xff78,{{0x30af,0x0,0x0}}},
{0xff79,{{0x30b1,0x0,0x0}}},
{0xff7a,{{0x30b3,0x0,0x0}}},
{0xff7b,{{0x30b5,0x0,0x0}}},
{0xff7c,{{0x30b7,0x0,0x0}}},
{0xff7d,{{0x30b9,0x0,0x0}}},
{0xff7e,{{0x30bb,0x0,0x0}}},
{0xff7f,{{0x30bd,0x0,0x0}}},
{0xff80,{{0x30bf,0x0,0x0}}},
{0xff81,{{0x30c1,0x0,0x0}}},
{0xff82,{{0x30c4,0x0,0x0}}},
{0xff83,{{0x30c6,0x0,0x0}}},
{0xff84,{{0x30c8,0x0,0x0}}},
{0xff85,{{0x30ca,0x0,0x0}}},
{0xff86,{{0x30cb,0x0,0x0}}},
{0xff87,{{0x30cc,0x0,0x0}}},
{0xff88,{{0x30cd,0x0,0x0}}},
{0xff89,{{0x30ce,0x0,0x0}}},
{0xff8a,{{0x30cf,0x0,0x0}}},
{0xff8b,{{0x30d2,0x0,0x0}}},
{0xff8c,{{0x30d5,0x0,0x0}}},
{0xff8d,{{0x30d8,0x0,0x0}}},
{0xff8e,{{0x30db,0x0,0x0}}},
{0xff8f,{{0x30de,0x0,0x0}}},
{0xff90,{{0x30df,0x0,0x0}}},
{0xff91,{{0x30e0,0x0,0x0}}},
{0xff92,{{0x30e1,0x0,0x0}}},
{0xff93,{{0x30e2,0x0,0x0}}},
{0xff94,{{0x30e4,0x0,0x0}}},
{0xff95,{{0x30e6,0x0,0x0}}},
{0xff96,{{0x30e8,0x0,0x0}}},
{0xff97,{{0x30e9,0x0,0x0}}},
{0xff98,{{0x30ea,0x0,0x0}}},
{0xff99,{{0x30eb,0x0,0x0}}},
{0xff9a,{{0x30ec,0x0,0x0}}},
{0xff9b,{{0x30ed,0x0,0x0}}},
{0xff9c,{{0x30ef,0x0,0x0}}},
{0xff9d,{{0x30f3,0x0,0x0}}},
{0xff9e,{{0x3099,0x0,0x0}}},
{0xff9f,{{0x309a,0x0,0x0}}},
{0xffa0,{{0x3164,0x0,0x0}}},
{0xffa1,{{0x3131,0x0,0x0}}},
{0xffa2,{{0x3132,0x0,0x0}}},
{0xffa3,{{0x3133,0x0,0x0}}},
{0xffa4,{{0x3134,0x0,0x0}}},
{0xffa5,{{0x3135,0x0,0x0}}},
{0xffa6,{{0x3136,0x0,0x0}}},
{0xffa7,{{0x3137,0x0,0x0}}},
{0xffa8,{{0x3138,0x0,0x0}}},
{0xffa9,{{0x3139,0x0,0x0}}},
{0xffaa,{{0x313a,0x0,0x0}}},
{0xffab,{{0x313b,0x0,0x0}}},
{0xffac,{{0x313c,0x0,0x0}}},
{0xffad,{{0x313d,0x0,0x0}}},
{0xffae,{{0x313e,0x0,0x0}}},
{0xffaf,{{0x313f,0x0,0x0}}},
{0xffb0,{{0x3140,0x0,0x0}}},
{0xffb1,{{0x3141,0x0,0x0}}},
{0xffb2,{{0x3142,0x0,0x0}}},
{0xffb3,{{0x3143,0x0,0x0}}},
{0xffb4,{{0x3144,0x0,0x0}}},
{0xffb5,{{0x3145,0x0,0x0}}},
{0xffb6,{{0x3146,0x0,0x0}}},
{0xffb7,{{0x3147,0x0,0x0}}},
{0xffb8,{{0x3148,0x0,0x0}}},
{0xffb9,{{0x3149,0x0,0x0}}},
{0xffba,{{0x314a,0x0,0x0}}},
{0xffbb,{{0x314b,0x0,0x0}}},
{0xffbc,{{0x314c,0x0,0x0}}},
{0xffbd,{{0x314d,0x0,0x0}}},
{0xffbe,{{0x314e,0x0,0x0}}},
{0xffc2,{{0x314f,0x0,0x0}}},
{0xffc3,{{0x3150,0x0,0x0}}},
{0xffc4,{{0x3151,0x0,0x0}}},
{0xffc5,{{0x3152,0x0,0x0}}},
{0xffc6,{{0x3153,0x0,0x0}}},
{0xffc7,{{0x3154,0x0,0x0}}},
{0xffca,{{0x3155,0x0,0x0}}},
{0xffcb,{{0x3156,0x0,0x0}}},
{0xffcc,{{0x3157,0x0,0x0}}},
{0xffcd,{{0x3158,0x0,0x0}}},
{0xffce,{{0x3159,0x0,0x0}}},
{0xffcf,{{0x315a,0x0,0x0}}},
{0xffd2,{{0x315b,0x0,0x0}}},
{0xffd3,{{0x315c,0x0,0x0}}},
{0xffd4,{{0x315d,0x0,0x0}}},
{0xffd5,{{0x315e,0x0,0x0}}},
{0xffd6,{{0x315f,0x0,0x0}}},
{0xffd7,{{0x3160,0x0,0x0}}},
{0xffda,{{0x3161,0x0,0x0}}},
{0xffdb,{{0x3162,0x0,0x0}}},
{0xffdc,{{0x3163,0x0,0x0}}},
{0xffe0,{{0xa2,0x0,0x0}}},
{0xffe1,{{0xa3,0x0,0x0}}},
{0xffe2,{{0xac,0x0,0x0}}},
{0xffe3,{{0xaf,0x0,0x0}}},
{0xffe4,{{0xa6,0x0,0x0}}},
{0xffe5,{{0xa5,0x0,0x0}}},
{0xffe6,{{0x20a9,0x0,0x0}}},
{0xffe8,{{0x2502,0x0,0x0}}},
{0xffe9,{{0x2190,0x0,0x0}}},
{0xffea,{{0x2191,0x0,0x0}}},
{0xffeb,{{0x2192,0x0,0x0}}},
{0xffec,{{0x2193,0x0,0x0}}},
{0xffed,{{0x25a0,0x0,0x0}}},
{0xffee,{{0x25cb,0x0,0x0}}},
{0x1d400,{{0x41,0x0,0x0}}},
{0x1d401,{{0x42,0x0,0x0}}},
{0x1d402,{{0x43,0x0,0x0}}},
{0x1d403,{{0x44,0x0,0x0}}},
{0x1d404,{{0x45,0x0,0x0}}},
{0x1d405,{{0x46,0x0,0x0}}},
{0x1d406,{{0x47,0x0,0x0}}},
{0x1d407,{{0x48,0x0,0x0}}},
{0x1d408,{{0x49,0x0,0x0}}},
{0x1d409,{{0x4a,0x0,0x0}}},
{0x1d40a,{{0x4b,0x0,0x0}}},
{0x1d40b,{{0x4c,0x0,0x0}}},
{0x1d40c,{{0x4d,0x0,0x0}}},
{0x1d40d,{{0x4e,0x0,0x0}}},
{0x1d40e,{{0x4f,0x0,0x0}}},
{0x1d40f,{{0x50,0x0,0x0}}},
{0x1d410,{{0x51,0x0,0x0}}},
{0x1d411,{{0x52,0x0,0x0}}},
{0x1d412,{{0x53,0x0,0x0}}},
{0x1d413,{{0x54,0x0,0x0}}},
{0x1d414,{{0x55,0x0,0x0}}},
{0x1d415,{{0x56,0x0,0x0}}},
{0x1d416,{{0x57,0x0,0x0}}},
{0x1d417,{{0x58,0x0,0x0}}},
{0x1d418,{{0x59,0x0,0x0}}},
{0x1d419,{{0x5a,0x0,0x0}}},
{0x1d41a,{{0x61,0x0,0x0}}},
{0x1d41b,{{0x62,0x0,0x0}}},
{0x1d41c,{{0x63,0x0,0x0}}},
{0x1d41d,{{0x64,0x0,0x0}}},
{0x1d41e,{{0x65,0x0,0x0}}},
{0x1d41f,{{0x66,0x0,0x0}}},
{0x1d420,{{0x67,0x0,0x0}}},
{0x1d421,{{0x68,0x0,0x0}}},
{0x1d422,{{0x69,0x0,0x0}}},
{0x1d423,{{0x6a,0x0,0x0}}},
{0x1d424,{{0x6b,0x0,0x0}}},
{0x1d425,{{0x6c,0x0,0x0}}},
{0x1d426,{{0x6d,0x0,0x0}}},
{0x1d427,{{0x6e,0x0,0x0}}},
{0x1d428,{{0x6f,0x0,0x0}}},
{0x1d429,{{0x70,0x0,0x0}}},
{0x1d42a,{{0x71,0x0,0x0}}},
{0x1d42b,{{0x72,0x0,0x0}}},
{0x1d42c,{{0x73,0x0,0x0}}},
{0x1d42d,{{0x74,0x0,0x0}}},
{0x1d42e,{{0x75,0x0,0x0}}},
{0x1d42f,{{0x76,0x0,0x0}}},
{0x1d430,{{0x77,0x0,0x0}}},
{0x1d431,{{0x78,0x0,0x0}}},
{0x1d432,{{0x79,0x0,0x0}}},
{0x1d433,{{0x7a,0x0,0x0}}},
{0x1d434,{{0x41,0x0,0x0}}},
{0x1d435,{{0x42,0x0,0x0}}},
{0x1d436,{{0x43,0x0,0x0}}},
{0x1d437,{{0x44,0x0,0x0}}},
{0x1d438,{{0x45,0x0,0x0}}},
{0x1d439,{{0x46,0x0,0x0}}},
{0x1d43a,{{0x47,0x0,0x0}}},
{0x1d43b,{{0x48,0x0,0x0}}},
{0x1d43c,{{0x49,0x0,0x0}}},
{0x1d43d,{{0x4a,0x0,0x0}}},
{0x1d43e,{{0x4b,0x0,0x0}}},
{0x1d43f,{{0x4c,0x0,0x0}}},
{0x1d440,{{0x4d,0x0,0x0}}},
{0x1d441,{{0x4e,0x0,0x0}}},
{0x1d442,{{0x4f,0x0,0x0}}},
{0x1d443,{{0x50,0x0,0x0}}},
{0x1d444,{{0x51,0x0,0x0}}},
{0x1d445,{{0x52,0x0,0x0}}},
{0x1d446,{{0x53,0x0,0x0}}},
{0x1d447,{{0x54,0x0,0x0}}},
{0x1d448,{{0x55,0x0,0x0}}},
{0x1d449,{{0x56,0x0,0x0}}},
{0x1d44a,{{0x57,0x0,0x0}}},
{0x1d44b,{{0x58,0x0,0x0}}},
{0x1d44c,{{0x59,0x0,0x0}}},
{0x1d44d,{{0x5a,0x0,0x0}}},
{0x1d44e,{{0x61,0x0,0x0}}},
{0x1d44f,{{0x62,0x0,0x0}}},
{0x1d450,{{0x63,0x0,0x0}}},
{0x1d451,{{0x64,0x0,0x0}}},
{0x1d452,{{0x65,0x0,0x0}}},
{0x1d453,{{0x66,0x0,0x0}}},
{0x1d454,{{0x67,0x0,0x0}}},
{0x1d456,{{0x69,0x0,0x0}}},
{0x1d457,{{0x6a,0x0,0x0}}},
{0x1d458,{{0x6b,0x0,0x0}}},
{0x1d459,{{0x6c,0x0,0x0}}},
{0x1d45a,{{0x6d,0x0,0x0}}},
{0x1d45b,{{0x6e,0x0,0x0}}},
{0x1d45c,{{0x6f,0x0,0x0}}},
{0x1d45d,{{0x70,0x0,0x0}}},
{0x1d45e,{{0x71,0x0,0x0}}},
{0x1d45f,{{0x72,0x0,0x0}}},
{0x1d460,{{0x73,0x0,0x0}}},
{0x1d461,{{0x74,0x0,0x0}}},
{0x1d462,{{0x75,0x0,0x0}}},
{0x1d463,{{0x76,0x0,0x0}}},
{0x1d464,{{0x77,0x0,0x0}}},
{0x1d465,{{0x78,0x0,0x0}}},
{0x1d466,{{0x79,0x0,0x0}}},
{0x1d467,{{0x7a,0x0,0x0}}},
{0x1d468,{{0x41,0x0,0x0}}},
{0x1d469,{{0x42,0x0,0x0}}},
{0x1d46a,{{0x43,0x0,0x0}}},
{0x1d46b,{{0x44,0x0,0x0}}},
{0x1d46c,{{0x45,0x0,0x0}}},
{0x1d46d,{{0x46,0x0,0x0}}},
{0x1d46e,{{0x47,0x0,0x0}}},
{0x1d46f,{{0x48,0x0,0x0}}},
{0x1d470,{{0x49,0x0,0x0}}},
{0x1d471,{{0x4a,0x0,0x0}}},
{0x1d472,{{0x4b,0x0,0x0}}},
{0x1d473,{{0x4c,0x0,0x0}}},
{0x1d474,{{0x4d,0x0,0x0}}},
{0x1d475,{{0x4e,0x0,0x0}}},
{0x1d476,{{0x4f,0x0,0x0}}},
{0x1d477,{{0x50,0x0,0x0}}},
{0x1d478,{{0x51,0x0,0x0}}},
{0x1d479,{{0x52,0x0,0x0}}},
{0x1d47a,{{0x53,0x0,0x0}}},
{0x1d47b,{{0x54,0x0,0x0}}},
{0x1d47c,{{0x55,0x0,0x0}}},
{0x1d47d,{{0x56,0x0,0x0}}},
{0x1d47e,{{0x57,0x0,0x0}}},
{0x1d47f,{{0x58,0x0,0x0}}},
{0x1d480,{{0x59,0x0,0x0}}},
{0x1d481,{{0x5a,0x0,0x0}}},
{0x1d482,{{0x61,0x0,0x0}}},
{0x1d483,{{0x62,0x0,0x0}}},
{0x1d484,{{0x63,0x0,0x0}}},
{0x1d485,{{0x64,0x0,0x0}}},
{0x1d486,{{0x65,0x0,0x0}}},
{0x1d487,{{0x66,0x0,0x0}}},
{0x1d488,{{0x67,0x0,0x0}}},
{0x1d489,{{0x68,0x0,0x0}}},
{0x1d48a,{{0x69,0x0,0x0}}},
{0x1d48b,{{0x6a,0x0,0x0}}},
{0x1d48c,{{0x6b,0x0,0x0}}},
{0x1d48d,{{0x6c,0x0,0x0}}},
{0x1d48e,{{0x6d,0x0,0x0}}},
{0x1d48f,{{0x6e,0x0,0x0}}},
{0x1d490,{{0x6f,0x0,0x0}}},
{0x1d491,{{0x70,0x0,0x0}}},
{0x1d492,{{0x71,0x0,0x0}}},
{0x1d493,{{0x72,0x0,0x0}}},
{0x1d494,{{0x73,0x0,0x0}}},
{0x1d495,{{0x74,0x0,0x0}}},
{0x1d496,{{0x75,0x0,0x0}}},
{0x1d497,{{0x76,0x0,0x0}}},
{0x1d498,{{0x77,0x0,0x0}}},
{0x1d499,{{0x78,0x0,0x0}}},
{0x1d49a,{{0x79,0x0,0x0}}},
{0x1d49b,{{0x7a,0x0,0x0}}},
{0x1d49c,{{0x41,0x0,0x0}}},
{0x1d49e,{{0x43,0x0,0x0}}},
{0x1d49f,{{0x44,0x0,0x0}}},
{0x1d4a2,{{0x47,0x0,0x0}}},
{0x1d4a5,{{0x4a,0x0,0x0}}},
{0x1d4a6,{{0x4b,0x0,0x0}}},
{0x1d4a9,{{0x4e,0x0,0x0}}},
{0x1d4aa,{{0x4f,0x0,0x0}}},
{0x1d4ab,{{0x50,0x0,0x0}}},
{0x1d4ac,{{0x51,0x0,0x0}}},
{0x1d4ae,{{0x53,0x0,0x0}}},
{0x1d4af,{{0x54,0x0,0x0}}},
{0x1d4b0,{{0x55,0x0,0x0}}},
{0x1d4b1,{{0x56,0x0,0x0}}},
{0x1d4b2,{{0x57,0x0,0x0}}},
{0x1d4b3,{{0x58,0x0,0x0}}},
{0x1d4b4,{{0x59,0x0,0x0}}},
{0x1d4b5,{{0x5a,0x0,0x0}}},
{0x1d4b6,{{0x61,0x0,0x0}}},
{0x1d4b7,{{0x62,0x0,0x0}}},
{0x1d4b8,{{0x63,0x0,0x0}}},
{0x1d4b9,{{0x64,0x0,0x0}}},
{0x1d4bb,{{0x66,0x0,0x0}}},
{0x1d4bd,{{0x68,0x0,0x0}}},
{0x1d4be,{{0x69,0x0,0x0}}},
{0x1d4bf,{{0x6a,0x0,0x0}}},
{0x1d4c0,{{0x6b,0x0,0x0}}},
{0x1d4c1,{{0x6c,0x0,0x0}}},
{0x1d4c2,{{0x6d,0x0,0x0}}},
{0x1d4c3,{{0x6e,0x0,0x0}}},
{0x1d4c5,{{0x70,0x0,0x0}}},
{0x1d4c6,{{0x71,0x0,0x0}}},
{0x1d4c7,{{0x72,0x0,0x0}}},
{0x1d4c8,{{0x73,0x0,0x0}}},
{0x1d4c9,{{0x74,0x0,0x0}}},
{0x1d4ca,{{0x75,0x0,0x0}}},
{0x1d4cb,{{0x76,0x0,0x0}}},
{0x1d4cc,{{0x77,0x0,0x0}}},
{0x1d4cd,{{0x78,0x0,0x0}}},
{0x1d4ce,{{0x79,0x0,0x0}}},
{0x1d4cf,{{0x7a,0x0,0x0}}},
{0x1d4d0,{{0x41,0x0,0x0}}},
{0x1d4d1,{{0x42,0x0,0x0}}},
{0x1d4d2,{{0x43,0x0,0x0}}},
{0x1d4d3,{{0x44,0x0,0x0}}},
{0x1d4d4,{{0x45,0x0,0x0}}},
{0x1d4d5,{{0x46,0x0,0x0}}},
{0x1d4d6,{{0x47,0x0,0x0}}},
{0x1d4d7,{{0x48,0x0,0x0}}},
{0x1d4d8,{{0x49,0x0,0x0}}},
{0x1d4d9,{{0x4a,0x0,0x0}}},
{0x1d4da,{{0x4b,0x0,0x0}}},
{0x1d4db,{{0x4c,0x0,0x0}}},
{0x1d4dc,{{0x4d,0x0,0x0}}},
{0x1d4dd,{{0x4e,0x0,0x0}}},
{0x1d4de,{{0x4f,0x0,0x0}}},
{0x1d4df,{{0x50,0x0,0x0}}},
{0x1d4e0,{{0x51,0x0,0x0}}},
{0x1d4e1,{{0x52,0x0,0x0}}},
{0x1d4e2,{{0x53,0x0,0x0}}},
{0x1d4e3,{{0x54,0x0,0x0}}},
{0x1d4e4,{{0x55,0x0,0x0}}},
{0x1d4e5,{{0x56,0x0,0x0}}},
{0x1d4e6,{{0x57,0x0,0x0}}},
{0x1d4e7,{{0x58,0x0,0x0}}},
{0x1d4e8,{{0x59,0x0,0x0}}},
{0x1d4e9,{{0x5a,0x0,0x0}}},
{0x1d4ea,{{0x61,0x0,0x0}}},
{0x1d4eb,{{0x62,0x0,0x0}}},
{0x1d4ec,{{0x63,0x0,0x0}}},
{0x1d4ed,{{0x64,0x0,0x0}}},
{0x1d4ee,{{0x65,0x0,0x0}}},
{0x1d4ef,{{0x66,0x0,0x0}}},
{0x1d4f0,{{0x67,0x0,0x0}}},
{0x1d4f1,{{0x68,0x0,0x0}}},
{0x1d4f2,{{0x69,0x0,0x0}}},
{0x1d4f3,{{0x6a,0x0,0x0}}},
{0x1d4f4,{{0x6b,0x0,0x0}}},
{0x1d4f5,{{0x6c,0x0,0x0}}},
{0x1d4f6,{{0x6d,0x0,0x0}}},
{0x1d4f7,{{0x6e,0x0,0x0}}},
{0x1d4f8,{{0x6f,0x0,0x0}}},
{0x1d4f9,{{0x70,0x0,0x0}}},
{0x1d4fa,{{0x71,0x0,0x0}}},
{0x1d4fb,{{0x72,0x0,0x0}}},
{0x1d4fc,{{0x73,0x0,0x0}}},
{0x1d4fd,{{0x74,0x0,0x0}}},
{0x1d4fe,{{0x75,0x0,0x0}}},
{0x1d4ff,{{0x76,0x0,0x0}}},
{0x1d500,{{0x77,0x0,0x0}}},
{0x1d501,{{0x78,0x0,0x0}}},
{0x1d502,{{0x79,0x0,0x0}}},
{0x1d503,{{0x7a,0x0,0x0}}},
{0x1d504,{{0x41,0x0,0x0}}},
{0x1d505,{{0x42,0x0,0x0}}},
{0x1d507,{{0x44,0x0,0x0}}},
{0x1d508,{{0x45,0x0,0x0}}},
{0x1d509,{{0x46,0x0,0x0}}},
{0x1d50a,{{0x47,0x0,0x0}}},
{0x1d50d,{{0x4a,0x0,0x0}}},
{0x1d50e,{{0x4b,0x0,0x0}}},
{0x1d50f,{{0x4c,0x0,0x0}}},
{0x1d510,{{0x4d,0x0,0x0}}},
{0x1d511,{{0x4e,0x0,0x0}}},
{0x1d512,{{0x4f,0x0,0x0}}},
{0x1d513,{{0x50,0x0,0x0}}},
{0x1d514,{{0x51,0x0,0x0}}},
{0x1d516,{{0x53,0x0,0x0}}},
{0x1d517,{{0x54,0x0,0x0}}},
{0x1d518,{{0x55,0x0,0x0}}},
{0x1d519,{{0x56,0x0,0x0}}},
{0x1d51a,{{0x57,0x0,0x0}}},
{0x1d51b,{{0x58,0x0,0x0}}},
{0x1d51c,{{0x59,0x0,0x0}}},
{0x1d51e,{{0x61,0x0,0x0}}},
{0x1d51f,{{0x62,0x0,0x0}}},
{0x1d520,{{0x63,0x0,0x0}}},
{0x1d521,{{0x64,0x0,0x0}}},
{0x1d522,{{0x65,0x0,0x0}}},
{0x1d523,{{0x66,0x0,0x0}}},
{0x1d524,{{0x67,0x0,0x0}}},
{0x1d525,{{0x68,0x0,0x0}}},
{0x1d526,{{0x69,0x0,0x0}}},
{0x1d527,{{0x6a,0x0,0x0}}},
{0x1d528,{{0x6b,0x0,0x0}}},
{0x1d529,{{0x6c,0x0,0x0}}},
{0x1d52a,{{0x6d,0x0,0x0}}},
{0x1d52b,{{0x6e,0x0,0x0}}},
{0x1d52c,{{0x6f,0x0,0x0}}},
{0x1d52d,{{0x70,0x0,0x0}}},
{0x1d52e,{{0x71,0x0,0x0}}},
{0x1d52f,{{0x72,0x0,0x0}}},
{0x1d530,{{0x73,0x0,0x0}}},
{0x1d531,{{0x74,0x0,0x0}}},
{0x1d532,{{0x75,0x0,0x0}}},
{0x1d533,{{0x76,0x0,0x0}}},
{0x1d534,{{0x77,0x0,0x0}}},
{0x1d535,{{0x78,0x0,0x0}}},
{0x1d536,{{0x79,0x0,0x0}}},
{0x1d537,{{0x7a,0x0,0x0}}},
{0x1d538,{{0x41,0x0,0x0}}},
{0x1d539,{{0x42,0x0,0x0}}},
{0x1d53b,{{0x44,0x0,0x0}}},
{0x1d53c,{{0x45,0x0,0x0}}},
{0x1d53d,{{0x46,0x0,0x0}}},
{0x1d53e,{{0x47,0x0,0x0}}},
{0x1d540,{{0x49,0x0,0x0}}},
{0x1d541,{{0x4a,0x0,0x0}}},
{0x1d542,{{0x4b,0x0,0x0}}},
{0x1d543,{{0x4c,0x0,0x0}}},
{0x1d544,{{0x4d,0x0,0x0}}},
{0x1d546,{{0x4f,0x0,0x0}}},
{0x1d54a,{{0x53,0x0,0x0}}},
{0x1d54b,{{0x54,0x0,0x0}}},
{0x1d54c,{{0x55,0x0,0x0}}},
{0x1d54d,{{0x56,0x0,0x0}}},
{0x1d54e,{{0x57,0x0,0x0}}},
{0x1d54f,{{0x58,0x0,0x0}}},
{0x1d550,{{0x59,0x0,0x0}}},
{0x1d552,{{0x61,0x0,0x0}}},
{0x1d553,{{0x62,0x0,0x0}}},
{0x1d554,{{0x63,0x0,0x0}}},
{0x1d555,{{0x64,0x0,0x0}}},
{0x1d556,{{0x65,0x0,0x0}}},
{0x1d557,{{0x66,0x0,0x0}}},
{0x1d558,{{0x67,0x0,0x0}}},
{0x1d559,{{0x68,0x0,0x0}}},
{0x1d55a,{{0x69,0x0,0x0}}},
{0x1d55b,{{0x6a,0x0,0x0}}},
{0x1d55c,{{0x6b,0x0,0x0}}},
{0x1d55d,{{0x6c,0x0,0x0}}},
{0x1d55e,{{0x6d,0x0,0x0}}},
{0x1d55f,{{0x6e,0x0,0x0}}},
{0x1d560,{{0x6f,0x0,0x0}}},
{0x1d561,{{0x70,0x0,0x0}}},
{0x1d562,{{0x71,0x0,0x0}}},
{0x1d563,{{0x72,0x0,0x0}}},
{0x1d564,{{0x73,0x0,0x0}}},
{0x1d565,{{0x74,0x0,0x0}}},
{0x1d566,{{0x75,0x0,0x0}}},
{0x1d567,{{0x76,0x0,0x0}}},
{0x1d568,{{0x77,0x0,0x0}}},
{0x1d569,{{0x78,0x0,0x0}}},
{0x1d56a,{{0x79,0x0,0x0}}},
{0x1d56b,{{0x7a,0x0,0x0}}},
{0x1d56c,{{0x41,0x0,0x0}}},
{0x1d56d,{{0x42,0x0,0x0}}},
{0x1d56e,{{0x43,0x0,0x0}}},
{0x1d56f,{{0x44,0x0,0x0}}},
{0x1d570,{{0x45,0x0,0x0}}},
{0x1d571,{{0x46,0x0,0x0}}},
{0x1d572,{{0x47,0x0,0x0}}},
{0x1d573,{{0x48,0x0,0x0}}},
{0x1d574,{{0x49,0x0,0x0}}},
{0x1d575,{{0x4a,0x0,0x0}}},
{0x1d576,{{0x4b,0x0,0x0}}},
{0x1d577,{{0x4c,0x0,0x0}}},
{0x1d578,{{0x4d,0x0,0x0}}},
{0x1d579,{{0x4e,0x0,0x0}}},
{0x1d57a,{{0x4f,0x0,0x0}}},
{0x1d57b,{{0x50,0x0,0x0}}},
{0x1d57c,{{0x51,0x0,0x0}}},
{0x1d57d,{{0x52,0x0,0x0}}},
{0x1d57e,{{0x53,0x0,0x0}}},
{0x1d57f,{{0x54,0x0,0x0}}},
{0x1d580,{{0x55,0x0,0x0}}},
{0x1d581,{{0x56,0x0,0x0}}},
{0x1d582,{{0x57,0x0,0x0}}},
{0x1d583,{{0x58,0x0,0x0}}},
{0x1d584,{{0x59,0x0,0x0}}},
{0x1d585,{{0x5a,0x0,0x0}}},
{0x1d586,{{0x61,0x0,0x0}}},
{0x1d587,{{0x62,0x0,0x0}}},
{0x1d588,{{0x63,0x0,0x0}}},
{0x1d589,{{0x64,0x0,0x0}}},
{0x1d58a,{{0x65,0x0,0x0}}},
{0x1d58b,{{0x66,0x0,0x0}}},
{0x1d58c,{{0x67,0x0,0x0}}},
{0x1d58d,{{0x68,0x0,0x0}}},
{0x1d58e,{{0x69,0x0,0x0}}},
{0x1d58f,{{0x6a,0x0,0x0}}},
{0x1d590,{{0x6b,0x0,0x0}}},
{0x1d591,{{0x6c,0x0,0x0}}},
{0x1d592,{{0x6d,0x0,0x0}}},
{0x1d593,{{0x6e,0x0,0x0}}},
{0x1d594,{{0x6f,0x0,0x0}}},
{0x1d595,{{0x70,0x0,0x0}}},
{0x1d596,{{0x71,0x0,0x0}}},
{0x1d597,{{0x72,0x0,0x0}}},
{0x1d598,{{0x73,0x0,0x0}}},
{0x1d599,{{0x74,0x0,0x0}}},
{0x1d59a,{{0x75,0x0,0x0}}},
{0x1d59b,{{0x76,0x0,0x0}}},
{0x1d59c,{{0x77,0x0,0x0}}},
{0x1d59d,{{0x78,0x0,0x0}}},
{0x1d59e,{{0x79,0x0,0x0}}},
{0x1d59f,{{0x7a,0x0,0x0}}},
{0x1d5a0,{{0x41,0x0,0x0}}},
{0x1d5a1,{{0x42,0x0,0x0}}},
{0x1d5a2,{{0x43,0x0,0x0}}},
{0x1d5a3,{{0x44,0x0,0x0}}},
{0x1d5a4,{{0x45,0x0,0x0}}},
{0x1d5a5,{{0x46,0x0,0x0}}},
{0x1d5a6,{{0x47,0x0,0x0}}},
{0x1d5a7,{{0x48,0x0,0x0}}},
{0x1d5a8,{{0x49,0x0,0x0}}},
{0x1d5a9,{{0x4a,0x0,0x0}}},
{0x1d5aa,{{0x4b,0x0,0x0}}},
{0x1d5ab,{{0x4c,0x0,0x0}}},
{0x1d5ac,{{0x4d,0x0,0x0}}},
{0x1d5ad,{{0x4e,0x0,0x0}}},
{0x1d5ae,{{0x4f,0x0,0x0}}},
{0x1d5af,{{0x50,0x0,0x0}}},
{0x1d5b0,{{0x51,0x0,0x0}}},
{0x1d5b1,{{0x52,0x0,0x0}}},
{0x1d5b2,{{0x53,0x0,0x0}}},
{0x1d5b3,{{0x54,0x0,0x0}}},
{0x1d5b4,{{0x55,0x0,0x0}}},
{0x1d5b5,{{0x56,0x0,0x0}}},
{0x1d5b6,{{0x57,0x0,0x0}}},
{0x1d5b7,{{0x58,0x0,0x0}}},
{0x1d5b8,{{0x59,0x0,0x0}}},
{0x1d5b9,{{0x5a,0x0,0x0}}},
{0x1d5ba,{{0x61,0x0,0x0}}},
{0x1d5bb,{{0x62,0x0,0x0}}},
{0x1d5bc,{{0x63,0x0,0x0}}},
{0x1d5bd,{{0x64,0x0,0x0}}},
{0x1d5be,{{0x65,0x0,0x0}}},
{0x1d5bf,{{0x66,0x0,0x0}}},
{0x1d5c0,{{0x67,0x0,0x0}}},
{0x1d5c1,{{0x68,0x0,0x0}}},
{0x1d5c2,{{0x69,0x0,0x0}}},
{0x1d5c3,{{0x6a,0x0,0x0}}},
{0x1d5c4,{{0x6b,0x0,0x0}}},
{0x1d5c5,{{0x6c,0x0,0x0}}},
{0x1d5c6,{{0x6d,0x0,0x0}}},
{0x1d5c7,{{0x6e,0x0,0x0}}},
{0x1d5c8,{{0x6f,0x0,0x0}}},
{0x1d5c9,{{0x70,0x0,0x0}}},
{0x1d5ca,{{0x71,0x0,0x0}}},
{0x1d5cb,{{0x72,0x0,0x0}}},
{0x1d5cc,{{0x73,0x0,0x0}}},
{0x1d5cd,{{0x74,0x0,0x0}}},
{0x1d5ce,{{0x75,0x0,0x0}}},
{0x1d5cf,{{0x76,0x0,0x0}}},
{0x1d5d0,{{0x77,0x0,0x0}}},
{0x1d5d1,{{0x78,0x0,0x0}}},
{0x1d5d2,{{0x79,0x0,0x0}}},
{0x1d5d3,{{0x7a,0x0,0x0}}},
{0x1d5d4,{{0x41,0x0,0x0}}},
{0x1d5d5,{{0x42,0x0,0x0}}},
{0x1d5d6,{{0x43,0x0,0x0}}},
{0x1d5d7,{{0x44,0x0,0x0}}},
{0x1d5d8,{{0x45,0x0,0x0}}},
{0x1d5d9,{{0x46,0x0,0x0}}},
{0x1d5da,{{0x47,0x0,0x0}}},
{0x1d5db,{{0x48,0x0,0x0}}},
{0x1d5dc,{{0x49,0x0,0x0}}},
{0x1d5dd,{{0x4a,0x0,0x0}}},
{0x1d5de,{{0x4b,0x0,0x0}}},
{0x1d5df,{{0x4c,0x0,0x0}}},
{0x1d5e0,{{0x4d,0x0,0x0}}},
{0x1d5e1,{{0x4e,0x0,0x0}}},
{0x1d5e2,{{0x4f,0x0,0x0}}},
{0x1d5e3,{{0x50,0x0,0x0}}},
{0x1d5e4,{{0x51,0x0,0x0}}},
{0x1d5e5,{{0x52,0x0,0x0}}},
{0x1d5e6,{{0x53,0x0,0x0}}},
{0x1d5e7,{{0x54,0x0,0x0}}},
{0x1d5e8,{{0x55,0x0,0x0}}},
{0x1d5e9,{{0x56,0x0,0x0}}},
{0x1d5ea,{{0x57,0x0,0x0}}},
{0x1d5eb,{{0x58,0x0,0x0}}},
{0x1d5ec,{{0x59,0x0,0x0}}},
{0x1d5ed,{{0x5a,0x0,0x0}}},
{0x1d5ee,{{0x61,0x0,0x0}}},
{0x1d5ef,{{0x62,0x0,0x0}}},
{0x1d5f0,{{0x63,0x0,0x0}}},
{0x1d5f1,{{0x64,0x0,0x0}}},
{0x1d5f2,{{0x65,0x0,0x0}}},
{0x1d5f3,{{0x66,0x0,0x0}}},
{0x1d5f4,{{0x67,0x0,0x0}}},
{0x1d5f5,{{0x68,0x0,0x0}}},
{0x1d5f6,{{0x69,0x0,0x0}}},
{0x1d5f7,{{0x6a,0x0,0x0}}},
{0x1d5f8,{{0x6b,0x0,0x0}}},
{0x1d5f9,{{0x6c,0x0,0x0}}},
{0x1d5fa,{{0x6d,0x0,0x0}}},
{0x1d5fb,{{0x6e,0x0,0x0}}},
{0x1d5fc,{{0x6f,0x0,0x0}}},
{0x1d5fd,{{0x70,0x0,0x0}}},
{0x1d5fe,{{0x71,0x0,0x0}}},
{0x1d5ff,{{0x72,0x0,0x0}}},
{0x1d600,{{0x73,0x0,0x0}}},
{0x1d601,{{0x74,0x0,0x0}}},
{0x1d602,{{0x75,0x0,0x0}}},
{0x1d603,{{0x76,0x0,0x0}}},
{0x1d604,{{0x77,0x0,0x0}}},
{0x1d605,{{0x78,0x0,0x0}}},
{0x1d606,{{0x79,0x0,0x0}}},
{0x1d607,{{0x7a,0x0,0x0}}},
{0x1d608,{{0x41,0x0,0x0}}},
{0x1d609,{{0x42,0x0,0x0}}},
{0x1d60a,{{0x43,0x0,0x0}}},
{0x1d60b,{{0x44,0x0,0x0}}},
{0x1d60c,{{0x45,0x0,0x0}}},
{0x1d60d,{{0x46,0x0,0x0}}},
{0x1d60e,{{0x47,0x0,0x0}}},
{0x1d60f,{{0x48,0x0,0x0}}},
{0x1d610,{{0x49,0x0,0x0}}},
{0x1d611,{{0x4a,0x0,0x0}}},
{0x1d612,{{0x4b,0x0,0x0}}},
{0x1d613,{{0x4c,0x0,0x0}}},
{0x1d614,{{0x4d,0x0,0x0}}},
{0x1d615,{{0x4e,0x0,0x0}}},
{0x1d616,{{0x4f,0x0,0x0}}},
{0x1d617,{{0x50,0x0,0x0}}},
{0x1d618,{{0x51,0x0,0x0}}},
{0x1d619,{{0x52,0x0,0x0}}},
{0x1d61a,{{0x53,0x0,0x0}}},
{0x1d61b,{{0x54,0x0,0x0}}},
{0x1d61c,{{0x55,0x0,0x0}}},
{0x1d61d,{{0x56,0x0,0x0}}},
{0x1d61e,{{0x57,0x0,0x0}}},
{0x1d61f,{{0x58,0x0,0x0}}},
{0x1d620,{{0x59,0x0,0x0}}},
{0x1d621,{{0x5a,0x0,0x0}}},
{0x1d622,{{0x61,0x0,0x0}}},
{0x1d623,{{0x62,0x0,0x0}}},
{0x1d624,{{0x63,0x0,0x0}}},
{0x1d625,{{0x64,0x0,0x0}}},
{0x1d626,{{0x65,0x0,0x0}}},
{0x1d627,{{0x66,0x0,0x0}}},
{0x1d628,{{0x67,0x0,0x0}}},
{0x1d629,{{0x68,0x0,0x0}}},
{0x1d62a,{{0x69,0x0,0x0}}},
{0x1d62b,{{0x6a,0x0,0x0}}},
{0x1d62c,{{0x6b,0x0,0x0}}},
{0x1d62d,{{0x6c,0x0,0x0}}},
{0x1d62e,{{0x6d,0x0,0x0}}},
{0x1d62f,{{0x6e,0x0,0x0}}},
{0x1d630,{{0x6f,0x0,0x0}}},
{0x1d631,{{0x70,0x0,0x0}}},
{0x1d632,{{0x71,0x0,0x0}}},
{0x1d633,{{0x72,0x0,0x0}}},
{0x1d634,{{0x73,0x0,0x0}}},
{0x1d635,{{0x74,0x0,0x0}}},
{0x1d636,{{0x75,0x0,0x0}}},
{0x1d637,{{0x76,0x0,0x0}}},
{0x1d638,{{0x77,0x0,0x0}}},
{0x1d639,{{0x78,0x0,0x0}}},
{0x1d63a,{{0x79,0x0,0x0}}},
{0x1d63b,{{0x7a,0x0,0x0}}},
{0x1d63c,{{0x41,0x0,0x0}}},
{0x1d63d,{{0x42,0x0,0x0}}},
{0x1d63e,{{0x43,0x0,0x0}}},
{0x1d63f,{{0x44,0x0,0x0}}},
{0x1d640,{{0x45,0x0,0x0}}},
{0x1d641,{{0x46,0x0,0x0}}},
{0x1d642,{{0x47,0x0,0x0}}},
{0x1d643,{{0x48,0x0,0x0}}},
{0x1d644,{{0x49,0x0,0x0}}},
{0x1d645,{{0x4a,0x0,0x0}}},
{0x1d646,{{0x4b,0x0,0x0}}},
{0x1d647,{{0x4c,0x0,0x0}}},
{0x1d648,{{0x4d,0x0,0x0}}},
{0x1d649,{{0x4e,0x0,0x0}}},
{0x1d64a,{{0x4f,0x0,0x0}}},
{0x1d64b,{{0x50,0x0,0x0}}},
{0x1d64c,{{0x51,0x0,0x0}}},
{0x1d64d,{{0x52,0x0,0x0}}},
{0x1d64e,{{0x53,0x0,0x0}}},
{0x1d64f,{{0x54,0x0,0x0}}},
{0x1d650,{{0x55,0x0,0x0}}},
{0x1d651,{{0x56,0x0,0x0}}},
{0x1d652,{{0x57,0x0,0x0}}},
{0x1d653,{{0x58,0x0,0x0}}},
{0x1d654,{{0x59,0x0,0x0}}},
{0x1d655,{{0x5a,0x0,0x0}}},
{0x1d656,{{0x61,0x0,0x0}}},
{0x1d657,{{0x62,0x0,0x0}}},
{0x1d658,{{0x63,0x0,0x0}}},
{0x1d659,{{0x64,0x0,0x0}}},
{0x1d65a,{{0x65,0x0,0x0}}},
{0x1d65b,{{0x66,0x0,0x0}}},
{0x1d65c,{{0x67,0x0,0x0}}},
{0x1d65d,{{0x68,0x0,0x0}}},
{0x1d65e,{{0x69,0x0,0x0}}},
{0x1d65f,{{0x6a,0x0,0x0}}},
{0x1d660,{{0x6b,0x0,0x0}}},
{0x1d661,{{0x6c,0x0,0x0}}},
{0x1d662,{{0x6d,0x0,0x0}}},
{0x1d663,{{0x6e,0x0,0x0}}},
{0x1d664,{{0x6f,0x0,0x0}}},
{0x1d665,{{0x70,0x0,0x0}}},
{0x1d666,{{0x71,0x0,0x0}}},
{0x1d667,{{0x72,0x0,0x0}}},
{0x1d668,{{0x73,0x0,0x0}}},
{0x1d669,{{0x74,0x0,0x0}}},
{0x1d66a,{{0x75,0x0,0x0}}},
{0x1d66b,{{0x76,0x0,0x0}}},
{0x1d66c,{{0x77,0x0,0x0}}},
{0x1d66d,{{0x78,0x0,0x0}}},
{0x1d66e,{{0x79,0x0,0x0}}},
{0x1d66f,{{0x7a,0x0,0x0}}},
{0x1d670,{{0x41,0x0,0x0}}},
{0x1d671,{{0x42,0x0,0x0}}},
{0x1d672,{{0x43,0x0,0x0}}},
{0x1d673,{{0x44,0x0,0x0}}},
{0x1d674,{{0x45,0x0,0x0}}},
{0x1d675,{{0x46,0x0,0x0}}},
{0x1d676,{{0x47,0x0,0x0}}},
{0x1d677,{{0x48,0x0,0x0}}},
{0x1d678,{{0x49,0x0,0x0}}},
{0x1d679,{{0x4a,0x0,0x0}}},
{0x1d67a,{{0x4b,0x0,0x0}}},
{0x1d67b,{{0x4c,0x0,0x0}}},
{0x1d67c,{{0x4d,0x0,0x0}}},
{0x1d67d,{{0x4e,0x0,0x0}}},
{0x1d67e,{{0x4f,0x0,0x0}}},
{0x1d67f,{{0x50,0x0,0x0}}},
{0x1d680,{{0x51,0x0,0x0}}},
{0x1d681,{{0x52,0x0,0x0}}},
{0x1d682,{{0x53,0x0,0x0}}},
{0x1d683,{{0x54,0x0,0x0}}},
{0x1d684,{{0x55,0x0,0x0}}},
{0x1d685,{{0x56,0x0,0x0}}},
{0x1d686,{{0x57,0x0,0x0}}},
{0x1d687,{{0x58,0x0,0x0}}},
{0x1d688,{{0x59,0x0,0x0}}},
{0x1d689,{{0x5a,0x0,0x0}}},
{0x1d68a,{{0x61,0x0,0x0}}},
{0x1d68b,{{0x62,0x0,0x0}}},
{0x1d68c,{{0x63,0x0,0x0}}},
{0x1d68d,{{0x64,0x0,0x0}}},
{0x1d68e,{{0x65,0x0,0x0}}},
{0x1d68f,{{0x66,0x0,0x0}}},
{0x1d690,{{0x67,0x0,0x0}}},
{0x1d691,{{0x68,0x0,0x0}}},
{0x1d692,{{0x69,0x0,0x0}}},
{0x1d693,{{0x6a,0x0,0x0}}},
{0x1d694,{{0x6b,0x0,0x0}}},
{0x1d695,{{0x6c,0x0,0x0}}},
{0x1d696,{{0x6d,0x0,0x0}}},
{0x1d697,{{0x6e,0x0,0x0}}},
{0x1d698,{{0x6f,0x0,0x0}}},
{0x1d699,{{0x70,0x0,0x0}}},
{0x1d69a,{{0x71,0x0,0x0}}},
{0x1d69b,{{0x72,0x0,0x0}}},
{0x1d69c,{{0x73,0x0,0x0}}},
{0x1d69d,{{0x74,0x0,0x0}}},
{0x1d69e,{{0x75,0x0,0x0}}},
{0x1d69f,{{0x76,0x0,0x0}}},
{0x1d6a0,{{0x77,0x0,0x0}}},
{0x1d6a1,{{0x78,0x0,0x0}}},
{0x1d6a2,{{0x79,0x0,0x0}}},
{0x1d6a3,{{0x7a,0x0,0x0}}},
{0x1d6a4,{{0x131,0x0,0x0}}},
{0x1d6a5,{{0x237,0x0,0x0}}},
{0x1d6a8,{{0x391,0x0,0x0}}},
{0x1d6a9,{{0x392,0x0,0x0}}},
{0x1d6aa,{{0x393,0x0,0x0}}},
{0x1d6ab,{{0x394,0x0,0x0}}},
{0x1d6ac,{{0x395,0x0,0x0}}},
{0x1d6ad,{{0x396,0x0,0x0}}},
{0x1d6ae,{{0x397,0x0,0x0}}},
{0x1d6af,{{0x398,0x0,0x0}}},
{0x1d6b0,{{0x399,0x0,0x0}}},
{0x1d6b1,{{0x39a,0x0,0x0}}},
{0x1d6b2,{{0x39b,0x0,0x0}}},
{0x1d6b3,{{0x39c,0x0,0x0}}},
{0x1d6b4,{{0x39d,0x0,0x0}}},
{0x1d6b5,{{0x39e,0x0,0x0}}},
{0x1d6b6,{{0x39f,0x0,0x0}}},
{0x1d6b7,{{0x3a0,0x0,0x0}}},
{0x1d6b8,{{0x3a1,0x0,0x0}}},
{0x1d6b9,{{0x3f4,0x0,0x0}}},
{0x1d6ba,{{0x3a3,0x0,0x0}}},
{0x1d6bb,{{0x3a4,0x0,0x0}}},
{0x1d6bc,{{0x3a5,0x0,0x0}}},
{0x1d6bd,{{0x3a6,0x0,0x0}}},
{0x1d6be,{{0x3a7,0x0,0x0}}},
{0x1d6bf,{{0x3a8,0x0,0x0}}},
{0x1d6c0,{{0x3a9,0x0,0x0}}},
{0x1d6c1,{{0x2207,0x0,0x0}}},
{0x1d6c2,{{0x3b1,0x0,0x0}}},
{0x1d6c3,{{0x3b2,0x0,0x0}}},
{0x1d6c4,{{0x3b3,0x0,0x0}}},
{0x1d6c5,{{0x3b4,0x0,0x0}}},
{0x1d6c6,{{0x3b5,0x0,0x0}}},
{0x1d6c7,{{0x3b6,0x0,0x0}}},
{0x1d6c8,{{0x3b7,0x0,0x0}}},
{0x1d6c9,{{0x3b8,0x0,0x0}}},
{0x1d6ca,{{0x3b9,0x0,0x0}}},
{0x1d6cb,{{0x3ba,0x0,0x0}}},
{0x1d6cc,{{0x3bb,0x0,0x0}}},
{0x1d6cd,{{0x3bc,0x0,0x0}}},
{0x1d6ce,{{0x3bd,0x0,0x0}}},
{0x1d6cf,{{0x3be,0x0,0x0}}},
{0x1d6d0,{{0x3bf,0x0,0x0}}},
{0x1d6d1,{{0x3c0,0x0,0x0}}},
{0x1d6d2,{{0x3c1,0x0,0x0}}},
{0x1d6d3,{{0x3c2,0x0,0x0}}},
{0x1d6d4,{{0x3c3,0x0,0x0}}},
{0x1d6d5,{{0x3c4,0x0,0x0}}},
{0x1d6d6,{{0x3c5,0x0,0x0}}},
{0x1d6d7,{{0x3c6,0x0,0x0}}},
{0x1d6d8,{{0x3c7,0x0,0x0}}},
{0x1d6d9,{{0x3c8,0x0,0x0}}},
{0x1d6da,{{0x3c9,0x0,0x0}}},
{0x1d6db,{{0x2202,0x0,0x0}}},
{0x1d6dc,{{0x3f5,0x0,0x0}}},
{0x1d6dd,{{0x3d1,0x0,0x0}}},
{0x1d6de,{{0x3f0,0x0,0x0}}},
{0x1d6df,{{0x3d5,0x0,0x0}}},
{0x1d6e0,{{0x3f1,0x0,0x0}}},
{0x1d6e1,{{0x3d6,0x0,0x0}}},
{0x1d6e2,{{0x391,0x0,0x0}}},
{0x1d6e3,{{0x392,0x0,0x0}}},
{0x1d6e4,{{0x393,0x0,0x0}}},
{0x1d6e5,{{0x394,0x0,0x0}}},
{0x1d6e6,{{0x395,0x0,0x0}}},
{0x1d6e7,{{0x396,0x0,0x0}}},
{0x1d6e8,{{0x397,0x0,0x0}}},
{0x1d6e9,{{0x398,0x0,0x0}}},
{0x1d6ea,{{0x399,0x0,0x0}}},
{0x1d6eb,{{0x39a,0x0,0x0}}},
{0x1d6ec,{{0x39b,0x0,0x0}}},
{0x1d6ed,{{0x39c,0x0,0x0}}},
{0x1d6ee,{{0x39d,0x0,0x0}}},
{0x1d6ef,{{0x39e,0x0,0x0}}},
{0x1d6f0,{{0x39f,0x0,0x0}}},
{0x1d6f1,{{0x3a0,0x0,0x0}}},
{0x1d6f2,{{0x3a1,0x0,0x0}}},
{0x1d6f3,{{0x3f4,0x0,0x0}}},
{0x1d6f4,{{0x3a3,0x0,0x0}}},
{0x1d6f5,{{0x3a4,0x0,0x0}}},
{0x1d6f6,{{0x3a5,0x0,0x0}}},
{0x1d6f7,{{0x3a6,0x0,0x0}}},
{0x1d6f8,{{0x3a7,0x0,0x0}}},
{0x1d6f9,{{0x3a8,0x0,0x0}}},
{0x1d6fa,{{0x3a9,0x0,0x0}}},
{0x1d6fb,{{0x2207,0x0,0x0}}},
{0x1d6fc,{{0x3b1,0x0,0x0}}},
{0x1d6fd,{{0x3b2,0x0,0x0}}},
{0x1d6fe,{{0x3b3,0x0,0x0}}},
{0x1d6ff,{{0x3b4,0x0,0x0}}},
{0x1d700,{{0x3b5,0x0,0x0}}},
{0x1d701,{{0x3b6,0x0,0x0}}},
{0x1d702,{{0x3b7,0x0,0x0}}},
{0x1d703,{{0x3b8,0x0,0x0}}},
{0x1d704,{{0x3b9,0x0,0x0}}},
{0x1d705,{{0x3ba,0x0,0x0}}},
{0x1d706,{{0x3bb,0x0,0x0}}},
{0x1d707,{{0x3bc,0x0,0x0}}},
{0x1d708,{{0x3bd,0x0,0x0}}},
{0x1d709,{{0x3be,0x0,0x0}}},
{0x1d70a,{{0x3bf,0x0,0x0}}},
{0x1d70b,{{0x3c0,0x0,0x0}}},
{0x1d70c,{{0x3c1,0x0,0x0}}},
{0x1d70d,{{0x3c2,0x0,0x0}}},
{0x1d70e,{{0x3c3,0x0,0x0}}},
{0x1d70f,{{0x3c4,0x0,0x0}}},
{0x1d710,{{0x3c5,0x0,0x0}}},
{0x1d711,{{0x3c6,0x0,0x0}}},
{0x1d712,{{0x3c7,0x0,0x0}}},
{0x1d713,{{0x3c8,0x0,0x0}}},
{0x1d714,{{0x3c9,0x0,0x0}}},
{0x1d715,{{0x2202,0x0,0x0}}},
{0x1d716,{{0x3f5,0x0,0x0}}},
{0x1d717,{{0x3d1,0x0,0x0}}},
{0x1d718,{{0x3f0,0x0,0x0}}},
{0x1d719,{{0x3d5,0x0,0x0}}},
{0x1d71a,{{0x3f1,0x0,0x0}}},
{0x1d71b,{{0x3d6,0x0,0x0}}},
{0x1d71c,{{0x391,0x0,0x0}}},
{0x1d71d,{{0x392,0x0,0x0}}},
{0x1d71e,{{0x393,0x0,0x0}}},
{0x1d71f,{{0x394,0x0,0x0}}},
{0x1d720,{{0x395,0x0,0x0}}},
{0x1d721,{{0x396,0x0,0x0}}},
{0x1d722,{{0x397,0x0,0x0}}},
{0x1d723,{{0x398,0x0,0x0}}},
{0x1d724,{{0x399,0x0,0x0}}},
{0x1d725,{{0x39a,0x0,0x0}}},
{0x1d726,{{0x39b,0x0,0x0}}},
{0x1d727,{{0x39c,0x0,0x0}}},
{0x1d728,{{0x39d,0x0,0x0}}},
{0x1d729,{{0x39e,0x0,0x0}}},
{0x1d72a,{{0x39f,0x0,0x0}}},
{0x1d72b,{{0x3a0,0x0,0x0}}},
{0x1d72c,{{0x3a1,0x0,0x0}}},
{0x1d72d,{{0x3f4,0x0,0x0}}},
{0x1d72e,{{0x3a3,0x0,0x0}}},
{0x1d72f,{{0x3a4,0x0,0x0}}},
{0x1d730,{{0x3a5,0x0,0x0}}},
{0x1d731,{{0x3a6,0x0,0x0}}},
{0x1d732,{{0x3a7,0x0,0x0}}},
{0x1d733,{{0x3a8,0x0,0x0}}},
{0x1d734,{{0x3a9,0x0,0x0}}},
{0x1d735,{{0x2207,0x0,0x0}}},
{0x1d736,{{0x3b1,0x0,0x0}}},
{0x1d737,{{0x3b2,0x0,0x0}}},
{0x1d738,{{0x3b3,0x0,0x0}}},
{0x1d739,{{0x3b4,0x0,0x0}}},
{0x1d73a,{{0x3b5,0x0,0x0}}},
{0x1d73b,{{0x3b6,0x0,0x0}}},
{0x1d73c,{{0x3b7,0x0,0x0}}},
{0x1d73d,{{0x3b8,0x0,0x0}}},
{0x1d73e,{{0x3b9,0x0,0x0}}},
{0x1d73f,{{0x3ba,0x0,0x0}}},
{0x1d740,{{0x3bb,0x0,0x0}}},
{0x1d741,{{0x3bc,0x0,0x0}}},
{0x1d742,{{0x3bd,0x0,0x0}}},
{0x1d743,{{0x3be,0x0,0x0}}},
{0x1d744,{{0x3bf,0x0,0x0}}},
{0x1d745,{{0x3c0,0x0,0x0}}},
{0x1d746,{{0x3c1,0x0,0x0}}},
{0x1d747,{{0x3c2,0x0,0x0}}},
{0x1d748,{{0x3c3,0x0,0x0}}},
{0x1d749,{{0x3c4,0x0,0x0}}},
{0x1d74a,{{0x3c5,0x0,0x0}}},
{0x1d74b,{{0x3c6,0x0,0x0}}},
{0x1d74c,{{0x3c7,0x0,0x0}}},
{0x1d74d,{{0x3c8,0x0,0x0}}},
{0x1d74e,{{0x3c9,0x0,0x0}}},
{0x1d74f,{{0x2202,0x0,0x0}}},
{0x1d750,{{0x3f5,0x0,0x0}}},
{0x1d751,{{0x3d1,0x0,0x0}}},
{0x1d752,{{0x3f0,0x0,0x0}}},
{0x1d753,{{0x3d5,0x0,0x0}}},
{0x1d754,{{0x3f1,0x0,0x0}}},
{0x1d755,{{0x3d6,0x0,0x0}}},
{0x1d756,{{0x391,0x0,0x0}}},
{0x1d757,{{0x392,0x0,0x0}}},
{0x1d758,{{0x393,0x0,0x0}}},
{0x1d759,{{0x394,0x0,0x0}}},
{0x1d75a,{{0x395,0x0,0x0}}},
{0x1d75b,{{0x396,0x0,0x0}}},
{0x1d75c,{{0x397,0x0,0x0}}},
{0x1d75d,{{0x398,0x0,0x0}}},
{0x1d75e,{{0x399,0x0,0x0}}},
{0x1d75f,{{0x39a,0x0,0x0}}},
{0x1d760,{{0x39b,0x0,0x0}}},
{0x1d761,{{0x39c,0x0,0x0}}},
{0x1d762,{{0x39d,0x0,0x0}}},
{0x1d763,{{0x39e,0x0,0x0}}},
{0x1d764,{{0x39f,0x0,0x0}}},
{0x1d765,{{0x3a0,0x0,0x0}}},
{0x1d766,{{0x3a1,0x0,0x0}}},
{0x1d767,{{0x3f4,0x0,0x0}}},
{0x1d768,{{0x3a3,0x0,0x0}}},
{0x1d769,{{0x3a4,0x0,0x0}}},
{0x1d76a,{{0x3a5,0x0,0x0}}},
{0x1d76b,{{0x3a6,0x0,0x0}}},
{0x1d76c,{{0x3a7,0x0,0x0}}},
{0x1d76d,{{0x3a8,0x0,0x0}}},
{0x1d76e,{{0x3a9,0x0,0x0}}},
{0x1d76f,{{0x2207,0x0,0x0}}},
{0x1d770,{{0x3b1,0x0,0x0}}},
{0x1d771,{{0x3b2,0x0,0x0}}},
{0x1d772,{{0x3b3,0x0,0x0}}},
{0x1d773,{{0x3b4,0x0,0x0}}},
{0x1d774,{{0x3b5,0x0,0x0}}},
{0x1d775,{{0x3b6,0x0,0x0}}},
{0x1d776,{{0x3b7,0x0,0x0}}},
{0x1d777,{{0x3b8,0x0,0x0}}},
{0x1d778,{{0x3b9,0x0,0x0}}},
{0x1d779,{{0x3ba,0x0,0x0}}},
{0x1d77a,{{0x3bb,0x0,0x0}}},
{0x1d77b,{{0x3bc,0x0,0x0}}},
{0x1d77c,{{0x3bd,0x0,0x0}}},
{0x1d77d,{{0x3be,0x0,0x0}}},
{0x1d77e,{{0x3bf,0x0,0x0}}},
{0x1d77f,{{0x3c0,0x0,0x0}}},
{0x1d780,{{0x3c1,0x0,0x0}}},
{0x1d781,{{0x3c2,0x0,0x0}}},
{0x1d782,{{0x3c3,0x0,0x0}}},
{0x1d783,{{0x3c4,0x0,0x0}}},
{0x1d784,{{0x3c5,0x0,0x0}}},
{0x1d785,{{0x3c6,0x0,0x0}}},
{0x1d786,{{0x3c7,0x0,0x0}}},
{0x1d787,{{0x3c8,0x0,0x0}}},
{0x1d788,{{0x3c9,0x0,0x0}}},
{0x1d789,{{0x2202,0x0,0x0}}},
{0x1d78a,{{0x3f5,0x0,0x0}}},
{0x1d78b,{{0x3d1,0x0,0x0}}},
{0x1d78c,{{0x3f0,0x0,0x0}}},
{0x1d78d,{{0x3d5,0x0,0x0}}},
{0x1d78e,{{0x3f1,0x0,0x0}}},
{0x1d78f,{{0x3d6,0x0,0x0}}},
{0x1d790,{{0x391,0x0,0x0}}},
{0x1d791,{{0x392,0x0,0x0}}},
{0x1d792,{{0x393,0x0,0x0}}},
{0x1d793,{{0x394,0x0,0x0}}},
{0x1d794,{{0x395,0x0,0x0}}},
{0x1d795,{{0x396,0x0,0x0}}},
{0x1d796,{{0x397,0x0,0x0}}},
{0x1d797,{{0x398,0x0,0x0}}},
{0x1d798,{{0x399,0x0,0x0}}},
{0x1d799,{{0x39a,0x0,0x0}}},
{0x1d79a,{{0x39b,0x0,0x0}}},
{0x1d79b,{{0x39c,0x0,0x0}}},
{0x1d79c,{{0x39d,0x0,0x0}}},
{0x1d79d,{{0x39e,0x0,0x0}}},
{0x1d79e,{{0x39f,0x0,0x0}}},
{0x1d79f,{{0x3a0,0x0,0x0}}},
{0x1d7a0,{{0x3a1,0x0,0x0}}},
{0x1d7a1,{{0x3f4,0x0,0x0}}},
{0x1d7a2,{{0x3a3,0x0,0x0}}},
{0x1d7a3,{{0x3a4,0x0,0x0}}},
{0x1d7a4,{{0x3a5,0x0,0x0}}},
{0x1d7a5,{{0x3a6,0x0,0x0}}},
{0x1d7a6,{{0x3a7,0x0,0x0}}},
{0x1d7a7,{{0x3a8,0x0,0x0}}},
{0x1d7a8,{{0x3a9,0x0,0x0}}},
{0x1d7a9,{{0x2207,0x0,0x0}}},
{0x1d7aa,{{0x3b1,0x0,0x0}}},
{0x1d7ab,{{0x3b2,0x0,0x0}}},
{0x1d7ac,{{0x3b3,0x0,0x0}}},
{0x1d7ad,{{0x3b4,0x0,0x0}}},
{0x1d7ae,{{0x3b5,0x0,0x0}}},
{0x1d7af,{{0x3b6,0x0,0x0}}},
{0x1d7b0,{{0x3b7,0x0,0x0}}},
{0x1d7b1,{{0x3b8,0x0,0x0}}},
{0x1d7b2,{{0x3b9,0x0,0x0}}},
{0x1d7b3,{{0x3ba,0x0,0x0}}},
{0x1d7b4,{{0x3bb,0x0,0x0}}},
{0x1d7b5,{{0x3bc,0x0,0x0}}},
{0x1d7b6,{{0x3bd,0x0,0x0}}},
{0x1d7b7,{{0x3be,0x0,0x0}}},
{0x1d7b8,{{0x3bf,0x0,0x0}}},
{0x1d7b9,{{0x3c0,0x0,0x0}}},
{0x1d7ba,{{0x3c1,0x0,0x0}}},
{0x1d7bb,{{0x3c2,0x0,0x0}}},
{0x1d7bc,{{0x3c3,0x0,0x0}}},
{0x1d7bd,{{0x3c4,0x0,0x0}}},
{0x1d7be,{{0x3c5,0x0,0x0}}},
{0x1d7bf,{{0x3c6,0x0,0x0}}},
{0x1d7c0,{{0x3c7,0x0,0x0}}},
{0x1d7c1,{{0x3c8,0x0,0x0}}},
{0x1d7c2,{{0x3c9,0x0,0x0}}},
{0x1d7c3,{{0x2202,0x0,0x0}}},
{0x1d7c4,{{0x3f5,0x0,0x0}}},
{0x1d7c5,{{0x3d1,0x0,0x0}}},
{0x1d7c6,{{0x3f0,0x0,0x0}}},
{0x1d7c7,{{0x3d5,0x0,0x0}}},
{0x1d7c8,{{0x3f1,0x0,0x0}}},
{0x1d7c9,{{0x3d6,0x0,0x0}}},
{0x1d7ca,{{0x3dc,0x0,0x0}}},
{0x1d7cb,{{0x3dd,0x0,0x0}}},
{0x1d7ce,{{0x30,0x0,0x0}}},
{0x1d7cf,{{0x31,0x0,0x0}}},
{0x1d7d0,{{0x32,0x0,0x0}}},
{0x1d7d1,{{0x33,0x0,0x0}}},
{0x1d7d2,{{0x34,0x0,0x0}}},
{0x1d7d3,{{0x35,0x0,0x0}}},
{0x1d7d4,{{0x36,0x0,0x0}}},
{0x1d7d5,{{0x37,0x0,0x0}}},
{0x1d7d6,{{0x38,0x0,0x0}}},
{0x1d7d7,{{0x39,0x0,0x0}}},
{0x1d7d8,{{0x30,0x0,0x0}}},
{0x1d7d9,{{0x31,0x0,0x0}}},
{0x1d7da,{{0x32,0x0,0x0}}},
{0x1d7db,{{0x33,0x0,0x0}}},
{0x1d7dc,{{0x34,0x0,0x0}}},
{0x1d7dd,{{0x35,0x0,0x0}}},
{0x1d7de,{{0x36,0x0,0x0}}},
{0x1d7df,{{0x37,0x0,0x0}}},
{0x1d7e0,{{0x38,0x0,0x0}}},
{0x1d7e1,{{0x39,0x0,0x0}}},
{0x1d7e2,{{0x30,0x0,0x0}}},
{0x1d7e3,{{0x31,0x0,0x0}}},
{0x1d7e4,{{0x32,0x0,0x0}}},
{0x1d7e5,{{0x33,0x0,0x0}}},
{0x1d7e6,{{0x34,0x0,0x0}}},
{0x1d7e7,{{0x35,0x0,0x0}}},
{0x1d7e8,{{0x36,0x0,0x0}}},
{0x1d7e9,{{0x37,0x0,0x0}}},
{0x1d7ea,{{0x38,0x0,0x0}}},
{0x1d7eb,{{0x39,0x0,0x0}}},
{0x1d7ec,{{0x30,0x0,0x0}}},
{0x1d7ed,{{0x31,0x0,0x0}}},
{0x1d7ee,{{0x32,0x0,0x0}}},
{0x1d7ef,{{0x33,0x0,0x0}}},
{0x1d7f0,{{0x34,0x0,0x0}}},
{0x1d7f1,{{0x35,0x0,0x0}}},
{0x1d7f2,{{0x36,0x0,0x0}}},
{0x1d7f3,{{0x37,0x0,0x0}}},
{0x1d7f4,{{0x38,0x0,0x0}}},
{0x1d7f5,{{0x39,0x0,0x0}}},
{0x1d7f6,{{0x30,0x0,0x0}}},
{0x1d7f7,{{0x31,0x0,0x0}}},
{0x1d7f8,{{0x32,0x0,0x0}}},
{0x1d7f9,{{0x33,0x0,0x0}}},
{0x1d7fa,{{0x34,0x0,0x0}}},
{0x1d7fb,{{0x35,0x0,0x0}}},
{0x1d7fc,{{0x36,0x0,0x0}}},
{0x1d7fd,{{0x37,0x0,0x0}}},
{0x1d7fe,{{0x38,0x0,0x0}}},
{0x1d7ff,{{0x39,0x0,0x0}}},
{0x1ee00,{{0x627,0x0,0x0}}},
{0x1ee01,{{0x628,0x0,0x0}}},
{0x1ee02,{{0x62c,0x0,0x0}}},
{0x1ee03,{{0x62f,0x0,0x0}}},
{0x1ee05,{{0x648,0x0,0x0}}},
{0x1ee06,{{0x632,0x0,0x0}}},
{0x1ee07,{{0x62d,0x0,0x0}}},
{0x1ee08,{{0x637,0x0,0x0}}},
{0x1ee09,{{0x64a,0x0,0x0}}},
{0x1ee0a,{{0x643,0x0,0x0}}},
{0x1ee0b,{{0x644,0x0,0x0}}},
{0x1ee0c,{{0x645,0x0,0x0}}},
{0x1ee0d,{{0x646,0x0,0x0}}},
{0x1ee0e,{{0x633,0x0,0x0}}},
{0x1ee0f,{{0x639,0x0,0x0}}},
{0x1ee10,{{0x641,0x0,0x0}}},
{0x1ee11,{{0x635,0x0,0x0}}},
{0x1ee12,{{0x642,0x0,0x0}}},
{0x1ee13,{{0x631,0x0,0x0}}},
{0x1ee14,{{0x634,0x0,0x0}}},
{0x1ee15,{{0x62a,0x0,0x0}}},
{0x1ee16,{{0x62b,0x0,0x0}}},
{0x1ee17,{{0x62e,0x0,0x0}}},
{0x1ee18,{{0x630,0x0,0x0}}},
{0x1ee19,{{0x636,0x0,0x0}}},
{0x1ee1a,{{0x638,0x0,0x0}}},
{0x1ee1b,{{0x63a,0x0,0x0}}},
{0x1ee1c,{{0x66e,0x0,0x0}}},
{0x1ee1d,{{0x6ba,0x0,0x0}}},
{0x1ee1e,{{0x6a1,0x0,0x0}}},
{0x1ee1f,{{0x66f,0x0,0x0}}},
{0x1ee21,{{0x628,0x0,0x0}}},
{0x1ee22,{{0x62c,0x0,0x0}}},
{0x1ee24,{{0x647,0x0,0x0}}},
{0x1ee27,{{0x62d,0x0,0x0}}},
{0x1ee29,{{0x64a,0x0,0x0}}},
{0x1ee2a,{{0x643,0x0,0x0}}},
{0x1ee2b,{{0x644,0x0,0x0}}},
{0x1ee2c,{{0x645,0x0,0x0}}},
{0x1ee2d,{{0x646,0x0,0x0}}},
{0x1ee2e,{{0x633,0x0,0x0}}},
{0x1ee2f,{{0x639,0x0,0x0}}},
{0x1ee30,{{0x641,0x0,0x0}}},
{0x1ee31,{{0x635,0x0,0x0}}},
{0x1ee32,{{0x642,0x0,0x0}}},
{0x1ee34,{{0x634,0x0,0x0}}},
{0x1ee35,{{0x62a,0x0,0x0}}},
{0x1ee36,{{0x62b,0x0,0x0}}},
{0x1ee37,{{0x62e,0x0,0x0}}},
{0x1ee39,{{0x636,0x0,0x0}}},
{0x1ee3b,{{0x63a,0x0,0x0}}},
{0x1ee42,{{0x62c,0x0,0x0}}},
{0x1ee47,{{0x62d,0x0,0x0}}},
{0x1ee49,{{0x64a,0x0,0x0}}},
{0x1ee4b,{{0x644,0x0,0x0}}},
{0x1ee4d,{{0x646,0x0,0x0}}},
{0x1ee4e,{{0x633,0x0,0x0}}},
{0x1ee4f,{{0x639,0x0,0x0}}},
{0x1ee51,{{0x635,0x0,0x0}}},
{0x1ee52,{{0x642,0x0,0x0}}},
{0x1ee54,{{0x634,0x0,0x0}}},
{0x1ee57,{{0x62e,0x0,0x0}}},
{0x1ee59,{{0x636,0x0,0x0}}},
{0x1ee5b,{{0x63a,0x0,0x0}}},
{0x1ee5d,{{0x6ba,0x0,0x0}}},
{0x1ee5f,{{0x66f,0x0,0x0}}},
{0x1ee61,{{0x628,0x0,0x0}}},
{0x1ee62,{{0x62c,0x0,0x0}}},
{0x1ee64,{{0x647,0x0,0x0}}},
{0x1ee67,{{0x62d,0x0,0x0}}},
{0x1ee68,{{0x637,0x0,0x0}}},
{0x1ee69,{{0x64a,0x0,0x0}}},
{0x1ee6a,{{0x643,0x0,0x0}}},
{0x1ee6c,{{0x645,0x0,0x0}}},
{0x1ee6d,{{0x646,0x0,0x0}}},
{0x1ee6e,{{0x633,0x0,0x0}}},
{0x1ee6f,{{0x639,0x0,0x0}}},
{0x1ee70,{{0x641,0x0,0x0}}},
{0x1ee71,{{0x635,0x0,0x0}}},
{0x1ee72,{{0x642,0x0,0x0}}},
{0x1ee74,{{0x634,0x0,0x0}}},
{0x1ee75,{{0x62a,0x0,0x0}}},
{0x1ee76,{{0x62b,0x0,0x0}}},
{0x1ee77,{{0x62e,0x0,0x0}}},
{0x1ee79,{{0x636,0x0,0x0}}},
{0x1ee7a,{{0x638,0x0,0x0}}},
{0x1ee7b,{{0x63a,0x0,0x0}}},
{0x1ee7c,{{0x66e,0x0,0x0}}},
{0x1ee7e,{{0x6a1,0x0,0x0}}},
{0x1ee80,{{0x627,0x0,0x0}}},
{0x1ee81,{{0x628,0x0,0x0}}},
{0x1ee82,{{0x62c,0x0,0x0}}},
{0x1ee83,{{0x62f,0x0,0x0}}},
{0x1ee84,{{0x647,0x0,0x0}}},
{0x1ee85,{{0x648,0x0,0x0}}},
{0x1ee86,{{0x632,0x0,0x0}}},
{0x1ee87,{{0x62d,0x0,0x0}}},
{0x1ee88,{{0x637,0x0,0x0}}},
{0x1ee89,{{0x64a,0x0,0x0}}},
{0x1ee8b,{{0x644,0x0,0x0}}},
{0x1ee8c,{{0x645,0x0,0x0}}},
{0x1ee8d,{{0x646,0x0,0x0}}},
{0x1ee8e,{{0x633,0x0,0x0}}},
{0x1ee8f,{{0x639,0x0,0x0}}},
{0x1ee90,{{0x641,0x0,0x0}}},
{0x1ee91,{{0x635,0x0,0x0}}},
{0x1ee92,{{0x642,0x0,0x0}}},
{0x1ee93,{{0x631,0x0,0x0}}},
{0x1ee94,{{0x634,0x0,0x0}}},
{0x1ee95,{{0x62a,0x0,0x0}}},
{0x1ee96,{{0x62b,0x0,0x0}}},
{0x1ee97,{{0x62e,0x0,0x0}}},
{0x1ee98,{{0x630,0x0,0x0}}},
{0x1ee99,{{0x636,0x0,0x0}}},
{0x1ee9a,{{0x638,0x0,0x0}}},
{0x1ee9b,{{0x63a,0x0,0x0}}},
{0x1eea1,{{0x628,0x0,0x0}}},
{0x1eea2,{{0x62c,0x0,0x0}}},
{0x1eea3,{{0x62f,0x0,0x0}}},
{0x1eea5,{{0x648,0x0,0x0}}},
{0x1eea6,{{0x632,0x0,0x0}}},
{0x1eea7,{{0x62d,0x0,0x0}}},
{0x1eea8,{{0x637,0x0,0x0}}},
{0x1eea9,{{0x64a,0x0,0x0}}},
{0x1eeab,{{0x644,0x0,0x0}}},
{0x1eeac,{{0x645,0x0,0x0}}},
{0x1eead,{{0x646,0x0,0x0}}},
{0x1eeae,{{0x633,0x0,0x0}}},
{0x1eeaf,{{0x639,0x0,0x0}}},
{0x1eeb0,{{0x641,0x0,0x0}}},
{0x1eeb1,{{0x635,0x0,0x0}}},
{0x1eeb2,{{0x642,0x0,0x0}}},
{0x1eeb3,{{0x631,0x0,0x0}}},
{0x1eeb4,{{0x634,0x0,0x0}}},
{0x1eeb5,{{0x62a,0x0,0x0}}},
{0x1eeb6,{{0x62b,0x0,0x0}}},
{0x1eeb7,{{0x62e,0x0,0x0}}},
{0x1eeb8,{{0x630,0x0,0x0}}},
{0x1eeb9,{{0x636,0x0,0x0}}},
{0x1eeba,{{0x638,0x0,0x0}}},
{0x1eebb,{{0x63a,0x0,0x0}}},
{0x1f100,{{0x30,0x2e,0x0}}},
{0x1f101,{{0x30,0x2c,0x0}}},
{0x1f102,{{0x31,0x2c,0x0}}},
{0x1f103,{{0x32,0x2c,0x0}}},
{0x1f104,{{0x33,0x2c,0x0}}},
{0x1f105,{{0x34,0x2c,0x0}}},
{0x1f106,{{0x35,0x2c,0x0}}},
{0x1f107,{{0x36,0x2c,0x0}}},
{0x1f108,{{0x37,0x2c,0x0}}},
{0x1f109,{{0x38,0x2c,0x0}}},
{0x1f10a,{{0x39,0x2c,0x0}}},
{0x1f110,{{0x28,0x41,0x29}}},
{0x1f111,{{0x28,0x42,0x29}}},
{0x1f112,{{0x28,0x43,0x29}}},
{0x1f113,{{0x28,0x44,0x29}}},
{0x1f114,{{0x28,0x45,0x29}}},
{0x1f115,{{0x28,0x46,0x29}}},
{0x1f116,{{0x28,0x47,0x29}}},
{0x1f117,{{0x28,0x48,0x29}}},
{0x1f118,{{0x28,0x49,0x29}}},
{0x1f119,{{0x28,0x4a,0x29}}},
{0x1f11a,{{0x28,0x4b,0x29}}},
{0x1f11b,{{0x28,0x4c,0x29}}},
{0x1f11c,{{0x28,0x4d,0x29}}},
{0x1f11d,{{0x28,0x4e,0x29}}},
{0x1f11e,{{0x28,0x4f,0x29}}},
{0x1f11f,{{0x28,0x50,0x29}}},
{0x1f120,{{0x28,0x51,0x29}}},
{0x1f121,{{0x28,0x52,0x29}}},
{0x1f122,{{0x28,0x53,0x29}}},
{0x1f123,{{0x28,0x54,0x29}}},
{0x1f124,{{0x28,0x55,0x29}}},
{0x1f125,{{0x28,0x56,0x29}}},
{0x1f126,{{0x28,0x57,0x29}}},
{0x1f127,{{0x28,0x58,0x29}}},
{0x1f128,{{0x28,0x59,0x29}}},
{0x1f129,{{0x28,0x5a,0x29}}},
{0x1f12a,{{0x3014,0x53,0x3015}}},
{0x1f12b,{{0x43,0x0,0x0}}},
{0x1f12c,{{0x52,0x0,0x0}}},
{0x1f12d,{{0x43,0x44,0x0}}},
{0x1f12e,{{0x57,0x5a,0x0}}},
{0x1f130,{{0x41,0x0,0x0}}},
{0x1f131,{{0x42,0x0,0x0}}},
{0x1f132,{{0x43,0x0,0x0}}},
{0x1f133,{{0x44,0x0,0x0}}},
{0x1f134,{{0x45,0x0,0x0}}},
{0x1f135,{{0x46,0x0,0x0}}},
{0x1f136,{{0x47,0x0,0x0}}},
{0x1f137,{{0x48,0x0,0x0}}},
{0x1f138,{{0x49,0x0,0x0}}},
{0x1f139,{{0x4a,0x0,0x0}}},
{0x1f13a,{{0x4b,0x0,0x0}}},
{0x1f13b,{{0x4c,0x0,0x0}}},
{0x1f13c,{{0x4d,0x0,0x0}}},
{0x1f13d,{{0x4e,0x0,0x0}}},
{0x1f13e,{{0x4f,0x0,0x0}}},
{0x1f13f,{{0x50,0x0,0x0}}},
{0x1f140,{{0x51,0x0,0x0}}},
{0x1f141,{{0x52,0x0,0x0}}},
{0x1f142,{{0x53,0x0,0x0}}},
{0x1f143,{{0x54,0x0,0x0}}},
{0x1f144,{{0x55,0x0,0x0}}},
{0x1f145,{{0x56,0x0,0x0}}},
{0x1f146,{{0x57,0x0,0x0}}},
{0x1f147,{{0x58,0x0,0x0}}},
{0x1f148,{{0x59,0x0,0x0}}},
{0x1f149,{{0x5a,0x0,0x0}}},
{0x1f14a,{{0x48,0x56,0x0}}},
{0x1f14b,{{0x4d,0x56,0x0}}},
{0x1f14c,{{0x53,0x44,0x0}}},
{0x1f14d,{{0x53,0x53,0x0}}},
{0x1f14e,{{0x50,0x50,0x56}}},
{0x1f14f,{{0x57,0x43,0x0}}},
{0x1f16a,{{0x4d,0x43,0x0}}},
{0x1f16b,{{0x4d,0x44,0x0}}},
{0x1f190,{{0x44,0x4a,0x0}}},
{0x1f200,{{0x307b,0x304b,0x0}}},
{0x1f201,{{0x30b3,0x30b3,0x0}}},
{0x1f202,{{0x30b5,0x0,0x0}}},
{0x1f210,{{0x624b,0x0,0x0}}},
{0x1f211,{{0x5b57,0x0,0x0}}},
{0x1f212,{{0x53cc,0x0,0x0}}},
{0x1f213,{{0x30c7,0x0,0x0}}},
{0x1f214,{{0x4e8c,0x0,0x0}}},
{0x1f215,{{0x591a,0x0,0x0}}},
{0x1f216,{{0x89e3,0x0,0x0}}},
{0x1f217,{{0x5929,0x0,0x0}}},
{0x1f218,{{0x4ea4,0x0,0x0}}},
{0x1f219,{{0x6620,0x0,0x0}}},
{0x1f21a,{{0x7121,0x0,0x0}}},
{0x1f21b,{{0x6599,0x0,0x0}}},
{0x1f21c,{{0x524d,0x0,0x0}}},
{0x1f21d,{{0x5f8c,0x0,0x0}}},
{0x1f21e,{{0x518d,0x0,0x0}}},
{0x1f21f,{{0x65b0,0x0,0x0}}},
{0x1f220,{{0x521d,0x0,0x0}}},
{0x1f221,{{0x7d42,0x0,0x0}}},
{0x1f222,{{0x751f,0x0,0x0}}},
{0x1f223,{{0x8ca9,0x0,0x0}}},
{0x1f224,{{0x58f0,0x0,0x0}}},
{0x1f225,{{0x5439,0x0,0x0}}},
{0x1f226,{{0x6f14,0x0,0x0}}},
{0x1f227,{{0x6295,0x0,0x0}}},
{0x1f228,{{0x6355,0x0,0x0}}},
{0x1f229,{{0x4e00,0x0,0x0}}},
{0x1f22a,{{0x4e09,0x0,0x0}}},
{0x1f22b,{{0x904a,0x0,0x0}}},
{0x1f22c,{{0x5de6,0x0,0x0}}},
{0x1f22d,{{0x4e2d,0x0,0x0}}},
{0x1f22e,{{0x53f3,0x0,0x0}}},
{0x1f22f,{{0x6307,0x0,0x0}}},
{0x1f230,{{0x8d70,0x0,0x0}}},
{0x1f231,{{0x6253,0x0,0x0}}},
{0x1f232,{{0x7981,0x0,0x0}}},
{0x1f233,{{0x7a7a,0x0,0x0}}},
{0x1f234,{{0x5408,0x0,0x0}}},
{0x1f235,{{0x6e80,0x0,0x0}}},
{0x1f236,{{0x6709,0x0,0x0}}},
{0x1f237,{{0x6708,0x0,0x0}}},
{0x1f238,{{0x7533,0x0,0x0}}},
{0x1f239,{{0x5272,0x0,0x0}}},
{0x1f23a,{{0x55b6,0x0,0x0}}},
{0x1f240,{{0x3014,0x672c,0x3015}}},
{0x1f241,{{0x3014,0x4e09,0x3015}}},
{0x1f242,{{0x3014,0x4e8c,0x3015}}},
{0x1f243,{{0x3014,0x5b89,0x3015}}},
{0x1f244,{{0x3014,0x70b9,0x3015}}},
{0x1f245,{{0x3014,0x6253,0x3015}}},
{0x1f246,{{0x3014,0x76d7,0x3015}}},
{0x1f247,{{0x3014,0x52dd,0x3015}}},
{0x1f248,{{0x3014,0x6557,0x3015}}},
{0x1f250,{{0x5f97,0x0,0x0}}},
{0x1f251,{{0x53ef,0x0,0x0}}},
}};

const TableView<char32_t, std::array<char32_t, 3>> short_compatibility_table {&short_compatibility_array[0], &short_compatibility_array[0] + short_compatibility_array.size()};

const std::array<KeyValue<char32_t, std::array<char32_t, 18>>, 89> long_compatibility_array = {{
{0x2057,{{0x2032,0x2032,0x2032,0x2032,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2152,{{0x31,0x2044,0x31,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2167,{{0x56,0x49,0x49,0x49,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2177,{{0x76,0x69,0x69,0x69,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x247d,{{0x28,0x31,0x30,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x247e,{{0x28,0x31,0x31,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x247f,{{0x28,0x31,0x32,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2480,{{0x28,0x31,0x33,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2481,{{0x28,0x31,0x34,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2482,{{0x28,0x31,0x35,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2483,{{0x28,0x31,0x36,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2484,{{0x28,0x31,0x37,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2485,{{0x28,0x31,0x38,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2486,{{0x28,0x31,0x39,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2487,{{0x28,0x32,0x30,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x2a0c,{{0x222b,0x222b,0x222b,0x222b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x320e,{{0x28,0x1100,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x320f,{{0x28,0x1102,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3210,{{0x28,0x1103,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3211,{{0x28,0x1105,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3212,{{0x28,0x1106,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3213,{{0x28,0x1107,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3214,{{0x28,0x1109,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3215,{{0x28,0x110b,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3216,{{0x28,0x110c,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3217,{{0x28,0x110e,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3218,{{0x28,0x110f,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3219,{{0x28,0x1110,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x321a,{{0x28,0x1111,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x321b,{{0x28,0x1112,0x1161,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x321c,{{0x28,0x110c,0x116e,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x321d,{{0x28,0x110b,0x1169,0x110c,0x1165,0x11ab,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x321e,{{0x28,0x110b,0x1169,0x1112,0x116e,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x327c,{{0x110e,0x1161,0x11b7,0x1100,0x1169,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x327d,{{0x110c,0x116e,0x110b,0x1174,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3300,{{0x30a2,0x30d1,0x30fc,0x30c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3301,{{0x30a2,0x30eb,0x30d5,0x30a1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3302,{{0x30a2,0x30f3,0x30da,0x30a2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3304,{{0x30a4,0x30cb,0x30f3,0x30b0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3307,{{0x30a8,0x30b9,0x30af,0x30fc,0x30c9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3308,{{0x30a8,0x30fc,0x30ab,0x30fc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x330c,{{0x30ab,0x30e9,0x30c3,0x30c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x330d,{{0x30ab,0x30ed,0x30ea,0x30fc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3312,{{0x30ad,0x30e5,0x30ea,0x30fc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3313,{{0x30ae,0x30eb,0x30c0,0x30fc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3315,{{0x30ad,0x30ed,0x30b0,0x30e9,0x30e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3316,{{0x30ad,0x30ed,0x30e1,0x30fc,0x30c8,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3317,{{0x30ad,0x30ed,0x30ef,0x30c3,0x30c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3319,{{0x30b0,0x30e9,0x30e0,0x30c8,0x30f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x331a,{{0x30af,0x30eb,0x30bc,0x30a4,0x30ed,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x331b,{{0x30af,0x30ed,0x30fc,0x30cd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x331f,{{0x30b5,0x30a4,0x30af,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3320,{{0x30b5,0x30f3,0x30c1,0x30fc,0x30e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3321,{{0x30b7,0x30ea,0x30f3,0x30b0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x332b,{{0x30d1,0x30fc,0x30bb,0x30f3,0x30c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x332d,{{0x30d0,0x30fc,0x30ec,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x332e,{{0x30d4,0x30a2,0x30b9,0x30c8,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3332,{{0x30d5,0x30a1,0x30e9,0x30c3,0x30c9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3333,{{0x30d5,0x30a3,0x30fc,0x30c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3334,{{0x30d6,0x30c3,0x30b7,0x30a7,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3336,{{0x30d8,0x30af,0x30bf,0x30fc,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x333d,{{0x30dd,0x30a4,0x30f3,0x30c8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3343,{{0x30de,0x30a4,0x30af,0x30ed,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3347,{{0x30de,0x30f3,0x30b7,0x30e7,0x30f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3348,{{0x30df,0x30af,0x30ed,0x30f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x334a,{{0x30df,0x30ea,0x30d0,0x30fc,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x334c,{{0x30e1,0x30ac,0x30c8,0x30f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x334d,{{0x30e1,0x30fc,0x30c8,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3351,{{0x30ea,0x30c3,0x30c8,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3354,{{0x30eb,0x30fc,0x30d6,0x30eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3356,{{0x30ec,0x30f3,0x30c8,0x30b2,0x30f3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x337f,{{0x682a,0x5f0f,0x4f1a,0x793e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x3389,{{0x6b,0x63,0x61,0x6c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x33a8,{{0x6d,0x2215,0x73,0xb2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x33ae,{{0x72,0x61,0x64,0x2215,0x73,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x33af,{{0x72,0x61,0x64,0x2215,0x73,0xb2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x33c2,{{0x61,0x2e,0x6d,0x2e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x33c6,{{0x43,0x2215,0x6b,0x67,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0x33d8,{{0x70,0x2e,0x6d,0x2e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf2,{{0x627,0x644,0x644,0x647,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf3,{{0x627,0x643,0x628,0x631,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf4,{{0x645,0x62d,0x645,0x62f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf5,{{0x635,0x644,0x639,0x645,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf6,{{0x631,0x633,0x648,0x644,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf7,{{0x639,0x644,0x64a,0x647,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdf8,{{0x648,0x633,0x644,0x645,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdfa,{{0x635,0x644,0x649,0x20,0x627,0x644,0x644,0x647,0x20,0x639,0x644,0x64a,0x647,0x20,0x648,0x633,0x644,0x645}}},
{0xfdfb,{{0x62c,0x644,0x20,0x62c,0x644,0x627,0x644,0x647,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
{0xfdfc,{{0x631,0x6cc,0x627,0x644,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}},
}};

const TableView<char32_t, std::array<char32_t, 18>> long_compatibility_table {&long_compatibility_array[0], &long_compatibility_array[0] + long_compatibility_array.size()};

const std::array<KeyValue<std::array<char32_t, 2>, char32_t>, 940> composition_array = {{
{{{0x3c,0x338}},0x226e},
{{{0x3d,0x338}},0x2260},
{{{0x3e,0x338}},0x226f},
{{{0x41,0x300}},0xc0},
{{{0x41,0x301}},0xc1},
{{{0x41,0x302}},0xc2},
{{{0x41,0x303}},0xc3},
{{{0x41,0x304}},0x100},
{{{0x41,0x306}},0x102},
{{{0x41,0x307}},0x226},
{{{0x41,0x308}},0xc4},
{{{0x41,0x309}},0x1ea2},
{{{0x41,0x30a}},0xc5},
{{{0x41,0x30c}},0x1cd},
{{{0x41,0x30f}},0x200},
{{{0x41,0x311}},0x202},
{{{0x41,0x323}},0x1ea0},
{{{0x41,0x325}},0x1e00},
{{{0x41,0x328}},0x104},
{{{0x42,0x307}},0x1e02},
{{{0x42,0x323}},0x1e04},
{{{0x42,0x331}},0x1e06},
{{{0x43,0x301}},0x106},
{{{0x43,0x302}},0x108},
{{{0x43,0x307}},0x10a},
{{{0x43,0x30c}},0x10c},
{{{0x43,0x327}},0xc7},
{{{0x44,0x307}},0x1e0a},
{{{0x44,0x30c}},0x10e},
{{{0x44,0x323}},0x1e0c},
{{{0x44,0x327}},0x1e10},
{{{0x44,0x32d}},0x1e12},
{{{0x44,0x331}},0x1e0e},
{{{0x45,0x300}},0xc8},
{{{0x45,0x301}},0xc9},
{{{0x45,0x302}},0xca},
{{{0x45,0x303}},0x1ebc},
{{{0x45,0x304}},0x112},
{{{0x45,0x306}},0x114},
{{{0x45,0x307}},0x116},
{{{0x45,0x308}},0xcb},
{{{0x45,0x309}},0x1eba},
{{{0x45,0x30c}},0x11a},
{{{0x45,0x30f}},0x204},
{{{0x45,0x311}},0x206},
{{{0x45,0x323}},0x1eb8},
{{{0x45,0x327}},0x228},
{{{0x45,0x328}},0x118},
{{{0x45,0x32d}},0x1e18},
{{{0x45,0x330}},0x1e1a},
{{{0x46,0x307}},0x1e1e},
{{{0x47,0x301}},0x1f4},
{{{0x47,0x302}},0x11c},
{{{0x47,0x304}},0x1e20},
{{{0x47,0x306}},0x11e},
{{{0x47,0x307}},0x120},
{{{0x47,0x30c}},0x1e6},
{{{0x47,0x327}},0x122},
{{{0x48,0x302}},0x124},
{{{0x48,0x307}},0x1e22},
{{{0x48,0x308}},0x1e26},
{{{0x48,0x30c}},0x21e},
{{{0x48,0x323}},0x1e24},
{{{0x48,0x327}},0x1e28},
{{{0x48,0x32e}},0x1e2a},
{{{0x49,0x300}},0xcc},
{{{0x49,0x301}},0xcd},
{{{0x49,0x302}},0xce},
{{{0x49,0x303}},0x128},
{{{0x49,0x304}},0x12a},
{{{0x49,0x306}},0x12c},
{{{0x49,0x307}},0x130},
{{{0x49,0x308}},0xcf},
{{{0x49,0x309}},0x1ec8},
{{{0x49,0x30c}},0x1cf},
{{{0x49,0x30f}},0x208},
{{{0x49,0x311}},0x20a},
{{{0x49,0x323}},0x1eca},
{{{0x49,0x328}},0x12e},
{{{0x49,0x330}},0x1e2c},
{{{0x4a,0x302}},0x134},
{{{0x4b,0x301}},0x1e30},
{{{0x4b,0x30c}},0x1e8},
{{{0x4b,0x323}},0x1e32},
{{{0x4b,0x327}},0x136},
{{{0x4b,0x331}},0x1e34},
{{{0x4c,0x301}},0x139},
{{{0x4c,0x30c}},0x13d},
{{{0x4c,0x323}},0x1e36},
{{{0x4c,0x327}},0x13b},
{{{0x4c,0x32d}},0x1e3c},
{{{0x4c,0x331}},0x1e3a},
{{{0x4d,0x301}},0x1e3e},
{{{0x4d,0x307}},0x1e40},
{{{0x4d,0x323}},0x1e42},
{{{0x4e,0x300}},0x1f8},
{{{0x4e,0x301}},0x143},
{{{0x4e,0x303}},0xd1},
{{{0x4e,0x307}},0x1e44},
{{{0x4e,0x30c}},0x147},
{{{0x4e,0x323}},0x1e46},
{{{0x4e,0x327}},0x145},
{{{0x4e,0x32d}},0x1e4a},
{{{0x4e,0x331}},0x1e48},
{{{0x4f,0x300}},0xd2},
{{{0x4f,0x301}},0xd3},
{{{0x4f,0x302}},0xd4},
{{{0x4f,0x303}},0xd5},
{{{0x4f,0x304}},0x14c},
{{{0x4f,0x306}},0x14e},
{{{0x4f,0x307}},0x22e},
{{{0x4f,0x308}},0xd6},
{{{0x4f,0x309}},0x1ece},
{{{0x4f,0x30b}},0x150},
{{{0x4f,0x30c}},0x1d1},
{{{0x4f,0x30f}},0x20c},
{{{0x4f,0x311}},0x20e},
{{{0x4f,0x31b}},0x1a0},
{{{0x4f,0x323}},0x1ecc},
{{{0x4f,0x328}},0x1ea},
{{{0x50,0x301}},0x1e54},
{{{0x50,0x307}},0x1e56},
{{{0x52,0x301}},0x154},
{{{0x52,0x307}},0x1e58},
{{{0x52,0x30c}},0x158},
{{{0x52,0x30f}},0x210},
{{{0x52,0x311}},0x212},
{{{0x52,0x323}},0x1e5a},
{{{0x52,0x327}},0x156},
{{{0x52,0x331}},0x1e5e},
{{{0x53,0x301}},0x15a},
{{{0x53,0x302}},0x15c},
{{{0x53,0x307}},0x1e60},
{{{0x53,0x30c}},0x160},
{{{0x53,0x323}},0x1e62},
{{{0x53,0x326}},0x218},
{{{0x53,0x327}},0x15e},
{{{0x54,0x307}},0x1e6a},
{{{0x54,0x30c}},0x164},
{{{0x54,0x323}},0x1e6c},
{{{0x54,0x326}},0x21a},
{{{0x54,0x327}},0x162},
{{{0x54,0x32d}},0x1e70},
{{{0x54,0x331}},0x1e6e},
{{{0x55,0x300}},0xd9},
{{{0x55,0x301}},0xda},
{{{0x55,0x302}},0xdb},
{{{0x55,0x303}},0x168},
{{{0x55,0x304}},0x16a},
{{{0x55,0x306}},0x16c},
{{{0x55,0x308}},0xdc},
{{{0x55,0x309}},0x1ee6},
{{{0x55,0x30a}},0x16e},
{{{0x55,0x30b}},0x170},
{{{0x55,0x30c}},0x1d3},
{{{0x55,0x30f}},0x214},
{{{0x55,0x311}},0x216},
{{{0x55,0x31b}},0x1af},
{{{0x55,0x323}},0x1ee4},
{{{0x55,0x324}},0x1e72},
{{{0x55,0x328}},0x172},
{{{0x55,0x32d}},0x1e76},
{{{0x55,0x330}},0x1e74},
{{{0x56,0x303}},0x1e7c},
{{{0x56,0x323}},0x1e7e},
{{{0x57,0x300}},0x1e80},
{{{0x57,0x301}},0x1e82},
{{{0x57,0x302}},0x174},
{{{0x57,0x307}},0x1e86},
{{{0x57,0x308}},0x1e84},
{{{0x57,0x323}},0x1e88},
{{{0x58,0x307}},0x1e8a},
{{{0x58,0x308}},0x1e8c},
{{{0x59,0x300}},0x1ef2},
{{{0x59,0x301}},0xdd},
{{{0x59,0x302}},0x176},
{{{0x59,0x303}},0x1ef8},
{{{0x59,0x304}},0x232},
{{{0x59,0x307}},0x1e8e},
{{{0x59,0x308}},0x178},
{{{0x59,0x309}},0x1ef6},
{{{0x59,0x323}},0x1ef4},
{{{0x5a,0x301}},0x179},
{{{0x5a,0x302}},0x1e90},
{{{0x5a,0x307}},0x17b},
{{{0x5a,0x30c}},0x17d},
{{{0x5a,0x323}},0x1e92},
{{{0x5a,0x331}},0x1e94},
{{{0x61,0x300}},0xe0},
{{{0x61,0x301}},0xe1},
{{{0x61,0x302}},0xe2},
{{{0x61,0x303}},0xe3},
{{{0x61,0x304}},0x101},
{{{0x61,0x306}},0x103},
{{{0x61,0x307}},0x227},
{{{0x61,0x308}},0xe4},
{{{0x61,0x309}},0x1ea3},
{{{0x61,0x30a}},0xe5},
{{{0x61,0x30c}},0x1ce},
{{{0x61,0x30f}},0x201},
{{{0x61,0x311}},0x203},
{{{0x61,0x323}},0x1ea1},
{{{0x61,0x325}},0x1e01},
{{{0x61,0x328}},0x105},
{{{0x62,0x307}},0x1e03},
{{{0x62,0x323}},0x1e05},
{{{0x62,0x331}},0x1e07},
{{{0x63,0x301}},0x107},
{{{0x63,0x302}},0x109},
{{{0x63,0x307}},0x10b},
{{{0x63,0x30c}},0x10d},
{{{0x63,0x327}},0xe7},
{{{0x64,0x307}},0x1e0b},
{{{0x64,0x30c}},0x10f},
{{{0x64,0x323}},0x1e0d},
{{{0x64,0x327}},0x1e11},
{{{0x64,0x32d}},0x1e13},
{{{0x64,0x331}},0x1e0f},
{{{0x65,0x300}},0xe8},
{{{0x65,0x301}},0xe9},
{{{0x65,0x302}},0xea},
{{{0x65,0x303}},0x1ebd},
{{{0x65,0x304}},0x113},
{{{0x65,0x306}},0x115},
{{{0x65,0x307}},0x117},
{{{0x65,0x308}},0xeb},
{{{0x65,0x309}},0x1ebb},
{{{0x65,0x30c}},0x11b},
{{{0x65,0x30f}},0x205},
{{{0x65,0x311}},0x207},
{{{0x65,0x323}},0x1eb9},
{{{0x65,0x327}},0x229},
{{{0x65,0x328}},0x119},
{{{0x65,0x32d}},0x1e19},
{{{0x65,0x330}},0x1e1b},
{{{0x66,0x307}},0x1e1f},
{{{0x67,0x301}},0x1f5},
{{{0x67,0x302}},0x11d},
{{{0x67,0x304}},0x1e21},
{{{0x67,0x306}},0x11f},
{{{0x67,0x307}},0x121},
{{{0x67,0x30c}},0x1e7},
{{{0x67,0x327}},0x123},
{{{0x68,0x302}},0x125},
{{{0x68,0x307}},0x1e23},
{{{0x68,0x308}},0x1e27},
{{{0x68,0x30c}},0x21f},
{{{0x68,0x323}},0x1e25},
{{{0x68,0x327}},0x1e29},
{{{0x68,0x32e}},0x1e2b},
{{{0x68,0x331}},0x1e96},
{{{0x69,0x300}},0xec},
{{{0x69,0x301}},0xed},
{{{0x69,0x302}},0xee},
{{{0x69,0x303}},0x129},
{{{0x69,0x304}},0x12b},
{{{0x69,0x306}},0x12d},
{{{0x69,0x308}},0xef},
{{{0x69,0x309}},0x1ec9},
{{{0x69,0x30c}},0x1d0},
{{{0x69,0x30f}},0x209},
{{{0x69,0x311}},0x20b},
{{{0x69,0x323}},0x1ecb},
{{{0x69,0x328}},0x12f},
{{{0x69,0x330}},0x1e2d},
{{{0x6a,0x302}},0x135},
{{{0x6a,0x30c}},0x1f0},
{{{0x6b,0x301}},0x1e31},
{{{0x6b,0x30c}},0x1e9},
{{{0x6b,0x323}},0x1e33},
{{{0x6b,0x327}},0x137},
{{{0x6b,0x331}},0x1e35},
{{{0x6c,0x301}},0x13a},
{{{0x6c,0x30c}},0x13e},
{{{0x6c,0x323}},0x1e37},
{{{0x6c,0x327}},0x13c},
{{{0x6c,0x32d}},0x1e3d},
{{{0x6c,0x331}},0x1e3b},
{{{0x6d,0x301}},0x1e3f},
{{{0x6d,0x307}},0x1e41},
{{{0x6d,0x323}},0x1e43},
{{{0x6e,0x300}},0x1f9},
{{{0x6e,0x301}},0x144},
{{{0x6e,0x303}},0xf1},
{{{0x6e,0x307}},0x1e45},
{{{0x6e,0x30c}},0x148},
{{{0x6e,0x323}},0x1e47},
{{{0x6e,0x327}},0x146},
{{{0x6e,0x32d}},0x1e4b},
{{{0x6e,0x331}},0x1e49},
{{{0x6f,0x300}},0xf2},
{{{0x6f,0x301}},0xf3},
{{{0x6f,0x302}},0xf4},
{{{0x6f,0x303}},0xf5},
{{{0x6f,0x304}},0x14d},
{{{0x6f,0x306}},0x14f},
{{{0x6f,0x307}},0x22f},
{{{0x6f,0x308}},0xf6},
{{{0x6f,0x309}},0x1ecf},
{{{0x6f,0x30b}},0x151},
{{{0x6f,0x30c}},0x1d2},
{{{0x6f,0x30f}},0x20d},
{{{0x6f,0x311}},0x20f},
{{{0x6f,0x31b}},0x1a1},
{{{0x6f,0x323}},0x1ecd},
{{{0x6f,0x328}},0x1eb},
{{{0x70,0x301}},0x1e55},
{{{0x70,0x307}},0x1e57},
{{{0x72,0x301}},0x155},
{{{0x72,0x307}},0x1e59},
{{{0x72,0x30c}},0x159},
{{{0x72,0x30f}},0x211},
{{{0x72,0x311}},0x213},
{{{0x72,0x323}},0x1e5b},
{{{0x72,0x327}},0x157},
{{{0x72,0x331}},0x1e5f},
{{{0x73,0x301}},0x15b},
{{{0x73,0x302}},0x15d},
{{{0x73,0x307}},0x1e61},
{{{0x73,0x30c}},0x161},
{{{0x73,0x323}},0x1e63},
{{{0x73,0x326}},0x219},
{{{0x73,0x327}},0x15f},
{{{0x74,0x307}},0x1e6b},
{{{0x74,0x308}},0x1e97},
{{{0x74,0x30c}},0x165},
{{{0x74,0x323}},0x1e6d},
{{{0x74,0x326}},0x21b},
{{{0x74,0x327}},0x163},
{{{0x74,0x32d}},0x1e71},
{{{0x74,0x331}},0x1e6f},
{{{0x75,0x300}},0xf9},
{{{0x75,0x301}},0xfa},
{{{0x75,0x302}},0xfb},
{{{0x75,0x303}},0x169},
{{{0x75,0x304}},0x16b},
{{{0x75,0x306}},0x16d},
{{{0x75,0x308}},0xfc},
{{{0x75,0x309}},0x1ee7},
{{{0x75,0x30a}},0x16f},
{{{0x75,0x30b}},0x171},
{{{0x75,0x30c}},0x1d4},
{{{0x75,0x30f}},0x215},
{{{0x75,0x311}},0x217},
{{{0x75,0x31b}},0x1b0},
{{{0x75,0x323}},0x1ee5},
{{{0x75,0x324}},0x1e73},
{{{0x75,0x328}},0x173},
{{{0x75,0x32d}},0x1e77},
{{{0x75,0x330}},0x1e75},
{{{0x76,0x303}},0x1e7d},
{{{0x76,0x323}},0x1e7f},
{{{0x77,0x300}},0x1e81},
{{{0x77,0x301}},0x1e83},
{{{0x77,0x302}},0x175},
{{{0x77,0x307}},0x1e87},
{{{0x77,0x308}},0x1e85},
{{{0x77,0x30a}},0x1e98},
{{{0x77,0x323}},0x1e89},
{{{0x78,0x307}},0x1e8b},
{{{0x78,0x308}},0x1e8d},
{{{0x79,0x300}},0x1ef3},
{{{0x79,0x301}},0xfd},
{{{0x79,0x302}},0x177},
{{{0x79,0x303}},0x1ef9},
{{{0x79,0x304}},0x233},
{{{0x79,0x307}},0x1e8f},
{{{0x79,0x308}},0xff},
{{{0x79,0x309}},0x1ef7},
{{{0x79,0x30a}},0x1e99},
{{{0x79,0x323}},0x1ef5},
{{{0x7a,0x301}},0x17a},
{{{0x7a,0x302}},0x1e91},
{{{0x7a,0x307}},0x17c},
{{{0x7a,0x30c}},0x17e},
{{{0x7a,0x323}},0x1e93},
{{{0x7a,0x331}},0x1e95},
{{{0xa8,0x300}},0x1fed},
{{{0xa8,0x301}},0x385},
{{{0xa8,0x342}},0x1fc1},
{{{0xc2,0x300}},0x1ea6},
{{{0xc2,0x301}},0x1ea4},
{{{0xc2,0x303}},0x1eaa},
{{{0xc2,0x309}},0x1ea8},
{{{0xc4,0x304}},0x1de},
{{{0xc5,0x301}},0x1fa},
{{{0xc6,0x301}},0x1fc},
{{{0xc6,0x304}},0x1e2},
{{{0xc7,0x301}},0x1e08},
{{{0xca,0x300}},0x1ec0},
{{{0xca,0x301}},0x1ebe},
{{{0xca,0x303}},0x1ec4},
{{{0xca,0x309}},0x1ec2},
{{{0xcf,0x301}},0x1e2e},
{{{0xd4,0x300}},0x1ed2},
{{{0xd4,0x301}},0x1ed0},
{{{0xd4,0x303}},0x1ed6},
{{{0xd4,0x309}},0x1ed4},
{{{0xd5,0x301}},0x1e4c},
{{{0xd5,0x304}},0x22c},
{{{0xd5,0x308}},0x1e4e},
{{{0xd6,0x304}},0x22a},
{{{0xd8,0x301}},0x1fe},
{{{0xdc,0x300}},0x1db},
{{{0xdc,0x301}},0x1d7},
{{{0xdc,0x304}},0x1d5},
{{{0xdc,0x30c}},0x1d9},
{{{0xe2,0x300}},0x1ea7},
{{{0xe2,0x301}},0x1ea5},
{{{0xe2,0x303}},0x1eab},
{{{0xe2,0x309}},0x1ea9},
{{{0xe4,0x304}},0x1df},
{{{0xe5,0x301}},0x1fb},
{{{0xe6,0x301}},0x1fd},
{{{0xe6,0x304}},0x1e3},
{{{0xe7,0x301}},0x1e09},
{{{0xea,0x300}},0x1ec1},
{{{0xea,0x301}},0x1ebf},
{{{0xea,0x303}},0x1ec5},
{{{0xea,0x309}},0x1ec3},
{{{0xef,0x301}},0x1e2f},
{{{0xf4,0x300}},0x1ed3},
{{{0xf4,0x301}},0x1ed1},
{{{0xf4,0x303}},0x1ed7},
{{{0xf4,0x309}},0x1ed5},
{{{0xf5,0x301}},0x1e4d},
{{{0xf5,0x304}},0x22d},
{{{0xf5,0x308}},0x1e4f},
{{{0xf6,0x304}},0x22b},
{{{0xf8,0x301}},0x1ff},
{{{0xfc,0x300}},0x1dc},
{{{0xfc,0x301}},0x1d8},
{{{0xfc,0x304}},0x1d6},
{{{0xfc,0x30c}},0x1da},
{{{0x102,0x300}},0x1eb0},
{{{0x102,0x301}},0x1eae},
{{{0x102,0x303}},0x1eb4},
{{{0x102,0x309}},0x1eb2},
{{{0x103,0x300}},0x1eb1},
{{{0x103,0x301}},0x1eaf},
{{{0x103,0x303}},0x1eb5},
{{{0x103,0x309}},0x1eb3},
{{{0x112,0x300}},0x1e14},
{{{0x112,0x301}},0x1e16},
{{{0x113,0x300}},0x1e15},
{{{0x113,0x301}},0x1e17},
{{{0x14c,0x300}},0x1e50},
{{{0x14c,0x301}},0x1e52},
{{{0x14d,0x300}},0x1e51},
{{{0x14d,0x301}},0x1e53},
{{{0x15a,0x307}},0x1e64},
{{{0x15b,0x307}},0x1e65},
{{{0x160,0x307}},0x1e66},
{{{0x161,0x307}},0x1e67},
{{{0x168,0x301}},0x1e78},
{{{0x169,0x301}},0x1e79},
{{{0x16a,0x308}},0x1e7a},
{{{0x16b,0x308}},0x1e7b},
{{{0x17f,0x307}},0x1e9b},
{{{0x1a0,0x300}},0x1edc},
{{{0x1a0,0x301}},0x1eda},
{{{0x1a0,0x303}},0x1ee0},
{{{0x1a0,0x309}},0x1ede},
{{{0x1a0,0x323}},0x1ee2},
{{{0x1a1,0x300}},0x1edd},
{{{0x1a1,0x301}},0x1edb},
{{{0x1a1,0x303}},0x1ee1},
{{{0x1a1,0x309}},0x1edf},
{{{0x1a1,0x323}},0x1ee3},
{{{0x1af,0x300}},0x1eea},
{{{0x1af,0x301}},0x1ee8},
{{{0x1af,0x303}},0x1eee},
{{{0x1af,0x309}},0x1eec},
{{{0x1af,0x323}},0x1ef0},
{{{0x1b0,0x300}},0x1eeb},
{{{0x1b0,0x301}},0x1ee9},
{{{0x1b0,0x303}},0x1eef},
{{{0x1b0,0x309}},0x1eed},
{{{0x1b0,0x323}},0x1ef1},
{{{0x1b7,0x30c}},0x1ee},
{{{0x1ea,0x304}},0x1ec},
{{{0x1eb,0x304}},0x1ed},
{{{0x226,0x304}},0x1e0},
{{{0x227,0x304}},0x1e1},
{{{0x228,0x306}},0x1e1c},
{{{0x229,0x306}},0x1e1d},
{{{0x22e,0x304}},0x230},
{{{0x22f,0x304}},0x231},
{{{0x292,0x30c}},0x1ef},
{{{0x391,0x300}},0x1fba},
{{{0x391,0x301}},0x386},
{{{0x391,0x304}},0x1fb9},
{{{0x391,0x306}},0x1fb8},
{{{0x391,0x313}},0x1f08},
{{{0x391,0x314}},0x1f09},
{{{0x391,0x345}},0x1fbc},
{{{0x395,0x300}},0x1fc8},
{{{0x395,0x301}},0x388},
{{{0x395,0x313}},0x1f18},
{{{0x395,0x314}},0x1f19},
{{{0x397,0x300}},0x1fca},
{{{0x397,0x301}},0x389},
{{{0x397,0x313}},0x1f28},
{{{0x397,0x314}},0x1f29},
{{{0x397,0x345}},0x1fcc},
{{{0x399,0x300}},0x1fda},
{{{0x399,0x301}},0x38a},
{{{0x399,0x304}},0x1fd9},
{{{0x399,0x306}},0x1fd8},
{{{0x399,0x308}},0x3aa},
{{{0x399,0x313}},0x1f38},
{{{0x399,0x314}},0x1f39},
{{{0x39f,0x300}},0x1ff8},
{{{0x39f,0x301}},0x38c},
{{{0x39f,0x313}},0x1f48},
{{{0x39f,0x314}},0x1f49},
{{{0x3a1,0x314}},0x1fec},
{{{0x3a5,0x300}},0x1fea},
{{{0x3a5,0x301}},0x38e},
{{{0x3a5,0x304}},0x1fe9},
{{{0x3a5,0x306}},0x1fe8},
{{{0x3a5,0x308}},0x3ab},
{{{0x3a5,0x314}},0x1f59},
{{{0x3a9,0x300}},0x1ffa},
{{{0x3a9,0x301}},0x38f},
{{{0x3a9,0x313}},0x1f68},
{{{0x3a9,0x314}},0x1f69},
{{{0x3a9,0x345}},0x1ffc},
{{{0x3ac,0x345}},0x1fb4},
{{{0x3ae,0x345}},0x1fc4},
{{{0x3b1,0x300}},0x1f70},
{{{0x3b1,0x301}},0x3ac},
{{{0x3b1,0x304}},0x1fb1},
{{{0x3b1,0x306}},0x1fb0},
{{{0x3b1,0x313}},0x1f00},
{{{0x3b1,0x314}},0x1f01},
{{{0x3b1,0x342}},0x1fb6},
{{{0x3b1,0x345}},0x1fb3},
{{{0x3b5,0x300}},0x1f72},
{{{0x3b5,0x301}},0x3ad},
{{{0x3b5,0x313}},0x1f10},
{{{0x3b5,0x314}},0x1f11},
{{{0x3b7,0x300}},0x1f74},
{{{0x3b7,0x301}},0x3ae},
{{{0x3b7,0x313}},0x1f20},
{{{0x3b7,0x314}},0x1f21},
{{{0x3b7,0x342}},0x1fc6},
{{{0x3b7,0x345}},0x1fc3},
{{{0x3b9,0x300}},0x1f76},
{{{0x3b9,0x301}},0x3af},
{{{0x3b9,0x304}},0x1fd1},
{{{0x3b9,0x306}},0x1fd0},
{{{0x3b9,0x308}},0x3ca},
{{{0x3b9,0x313}},0x1f30},
{{{0x3b9,0x314}},0x1f31},
{{{0x3b9,0x342}},0x1fd6},
{{{0x3bf,0x300}},0x1f78},
{{{0x3bf,0x301}},0x3cc},
{{{0x3bf,0x313}},0x1f40},
{{{0x3bf,0x314}},0x1f41},
{{{0x3c1,0x313}},0x1fe4},
{{{0x3c1,0x314}},0x1fe5},
{{{0x3c5,0x300}},0x1f7a},
{{{0x3c5,0x301}},0x3cd},
{{{0x3c5,0x304}},0x1fe1},
{{{0x3c5,0x306}},0x1fe0},
{{{0x3c5,0x308}},0x3cb},
{{{0x3c5,0x313}},0x1f50},
{{{0x3c5,0x314}},0x1f51},
{{{0x3c5,0x342}},0x1fe6},
{{{0x3c9,0x300}},0x1f7c},
{{{0x3c9,0x301}},0x3ce},
{{{0x3c9,0x313}},0x1f60},
{{{0x3c9,0x314}},0x1f61},
{{{0x3c9,0x342}},0x1ff6},
{{{0x3c9,0x345}},0x1ff3},
{{{0x3ca,0x300}},0x1fd2},
{{{0x3ca,0x301}},0x390},
{{{0x3ca,0x342}},0x1fd7},
{{{0x3cb,0x300}},0x1fe2},
{{{0x3cb,0x301}},0x3b0},
{{{0x3cb,0x342}},0x1fe7},
{{{0x3ce,0x345}},0x1ff4},
{{{0x3d2,0x301}},0x3d3},
{{{0x3d2,0x308}},0x3d4},
{{{0x406,0x308}},0x407},
{{{0x410,0x306}},0x4d0},
{{{0x410,0x308}},0x4d2},
{{{0x413,0x301}},0x403},
{{{0x415,0x300}},0x400},
{{{0x415,0x306}},0x4d6},
{{{0x415,0x308}},0x401},
{{{0x416,0x306}},0x4c1},
{{{0x416,0x308}},0x4dc},
{{{0x417,0x308}},0x4de},
{{{0x418,0x300}},0x40d},
{{{0x418,0x304}},0x4e2},
{{{0x418,0x306}},0x419},
{{{0x418,0x308}},0x4e4},
{{{0x41a,0x301}},0x40c},
{{{0x41e,0x308}},0x4e6},
{{{0x423,0x304}},0x4ee},
{{{0x423,0x306}},0x40e},
{{{0x423,0x308}},0x4f0},
{{{0x423,0x30b}},0x4f2},
{{{0x427,0x308}},0x4f4},
{{{0x42b,0x308}},0x4f8},
{{{0x42d,0x308}},0x4ec},
{{{0x430,0x306}},0x4d1},
{{{0x430,0x308}},0x4d3},
{{{0x433,0x301}},0x453},
{{{0x435,0x300}},0x450},
{{{0x435,0x306}},0x4d7},
{{{0x435,0x308}},0x451},
{{{0x436,0x306}},0x4c2},
{{{0x436,0x308}},0x4dd},
{{{0x437,0x308}},0x4df},
{{{0x438,0x300}},0x45d},
{{{0x438,0x304}},0x4e3},
{{{0x438,0x306}},0x439},
{{{0x438,0x308}},0x4e5},
{{{0x43a,0x301}},0x45c},
{{{0x43e,0x308}},0x4e7},
{{{0x443,0x304}},0x4ef},
{{{0x443,0x306}},0x45e},
{{{0x443,0x308}},0x4f1},
{{{0x443,0x30b}},0x4f3},
{{{0x447,0x308}},0x4f5},
{{{0x44b,0x308}},0x4f9},
{{{0x44d,0x308}},0x4ed},
{{{0x456,0x308}},0x457},
{{{0x474,0x30f}},0x476},
{{{0x475,0x30f}},0x477},
{{{0x4d8,0x308}},0x4da},
{{{0x4d9,0x308}},0x4db},
{{{0x4e8,0x308}},0x4ea},
{{{0x4e9,0x308}},0x4eb},
{{{0x627,0x653}},0x622},
{{{0x627,0x654}},0x623},
{{{0x627,0x655}},0x625},
{{{0x648,0x654}},0x624},
{{{0x64a,0x654}},0x626},
{{{0x6c1,0x654}},0x6c2},
{{{0x6d2,0x654}},0x6d3},
{{{0x6d5,0x654}},0x6c0},
{{{0x928,0x93c}},0x929},
{{{0x930,0x93c}},0x931},
{{{0x933,0x93c}},0x934},
{{{0x9c7,0x9be}},0x9cb},
{{{0x9c7,0x9d7}},0x9cc},
{{{0xb47,0xb3e}},0xb4b},
{{{0xb47,0xb56}},0xb48},
{{{0xb47,0xb57}},0xb4c},
{{{0xb92,0xbd7}},0xb94},
{{{0xbc6,0xbbe}},0xbca},
{{{0xbc6,0xbd7}},0xbcc},
{{{0xbc7,0xbbe}},0xbcb},
{{{0xc46,0xc56}},0xc48},
{{{0xcbf,0xcd5}},0xcc0},
{{{0xcc6,0xcc2}},0xcca},
{{{0xcc6,0xcd5}},0xcc7},
{{{0xcc6,0xcd6}},0xcc8},
{{{0xcca,0xcd5}},0xccb},
{{{0xd46,0xd3e}},0xd4a},
{{{0xd46,0xd57}},0xd4c},
{{{0xd47,0xd3e}},0xd4b},
{{{0xdd9,0xdca}},0xdda},
{{{0xdd9,0xdcf}},0xddc},
{{{0xdd9,0xddf}},0xdde},
{{{0xddc,0xdca}},0xddd},
{{{0x1025,0x102e}},0x1026},
{{{0x1b05,0x1b35}},0x1b06},
{{{0x1b07,0x1b35}},0x1b08},
{{{0x1b09,0x1b35}},0x1b0a},
{{{0x1b0b,0x1b35}},0x1b0c},
{{{0x1b0d,0x1b35}},0x1b0e},
{{{0x1b11,0x1b35}},0x1b12},
{{{0x1b3a,0x1b35}},0x1b3b},
{{{0x1b3c,0x1b35}},0x1b3d},
{{{0x1b3e,0x1b35}},0x1b40},
{{{0x1b3f,0x1b35}},0x1b41},
{{{0x1b42,0x1b35}},0x1b43},
{{{0x1e36,0x304}},0x1e38},
{{{0x1e37,0x304}},0x1e39},
{{{0x1e5a,0x304}},0x1e5c},
{{{0x1e5b,0x304}},0x1e5d},
{{{0x1e62,0x307}},0x1e68},
{{{0x1e63,0x307}},0x1e69},
{{{0x1ea0,0x302}},0x1eac},
{{{0x1ea0,0x306}},0x1eb6},
{{{0x1ea1,0x302}},0x1ead},
{{{0x1ea1,0x306}},0x1eb7},
{{{0x1eb8,0x302}},0x1ec6},
{{{0x1eb9,0x302}},0x1ec7},
{{{0x1ecc,0x302}},0x1ed8},
{{{0x1ecd,0x302}},0x1ed9},
{{{0x1f00,0x300}},0x1f02},
{{{0x1f00,0x301}},0x1f04},
{{{0x1f00,0x342}},0x1f06},
{{{0x1f00,0x345}},0x1f80},
{{{0x1f01,0x300}},0x1f03},
{{{0x1f01,0x301}},0x1f05},
{{{0x1f01,0x342}},0x1f07},
{{{0x1f01,0x345}},0x1f81},
{{{0x1f02,0x345}},0x1f82},
{{{0x1f03,0x345}},0x1f83},
{{{0x1f04,0x345}},0x1f84},
{{{0x1f05,0x345}},0x1f85},
{{{0x1f06,0x345}},0x1f86},
{{{0x1f07,0x345}},0x1f87},
{{{0x1f08,0x300}},0x1f0a},
{{{0x1f08,0x301}},0x1f0c},
{{{0x1f08,0x342}},0x1f0e},
{{{0x1f08,0x345}},0x1f88},
{{{0x1f09,0x300}},0x1f0b},
{{{0x1f09,0x301}},0x1f0d},
{{{0x1f09,0x342}},0x1f0f},
{{{0x1f09,0x345}},0x1f89},
{{{0x1f0a,0x345}},0x1f8a},
{{{0x1f0b,0x345}},0x1f8b},
{{{0x1f0c,0x345}},0x1f8c},
{{{0x1f0d,0x345}},0x1f8d},
{{{0x1f0e,0x345}},0x1f8e},
{{{0x1f0f,0x345}},0x1f8f},
{{{0x1f10,0x300}},0x1f12},
{{{0x1f10,0x301}},0x1f14},
{{{0x1f11,0x300}},0x1f13},
{{{0x1f11,0x301}},0x1f15},
{{{0x1f18,0x300}},0x1f1a},
{{{0x1f18,0x301}},0x1f1c},
{{{0x1f19,0x300}},0x1f1b},
{{{0x1f19,0x301}},0x1f1d},
{{{0x1f20,0x300}},0x1f22},
{{{0x1f20,0x301}},0x1f24},
{{{0x1f20,0x342}},0x1f26},
{{{0x1f20,0x345}},0x1f90},
{{{0x1f21,0x300}},0x1f23},
{{{0x1f21,0x301}},0x1f25},
{{{0x1f21,0x342}},0x1f27},
{{{0x1f21,0x345}},0x1f91},
{{{0x1f22,0x345}},0x1f92},
{{{0x1f23,0x345}},0x1f93},
{{{0x1f24,0x345}},0x1f94},
{{{0x1f25,0x345}},0x1f95},
{{{0x1f26,0x345}},0x1f96},
{{{0x1f27,0x345}},0x1f97},
{{{0x1f28,0x300}},0x1f2a},
{{{0x1f28,0x301}},0x1f2c},
{{{0x1f28,0x342}},0x1f2e},
{{{0x1f28,0x345}},0x1f98},
{{{0x1f29,0x300}},0x1f2b},
{{{0x1f29,0x301}},0x1f2d},
{{{0x1f29,0x342}},0x1f2f},
{{{0x1f29,0x345}},0x1f99},
{{{0x1f2a,0x345}},0x1f9a},
{{{0x1f2b,0x345}},0x1f9b},
{{{0x1f2c,0x345}},0x1f9c},
{{{0x1f2d,0x345}},0x1f9d},
{{{0x1f2e,0x345}},0x1f9e},
{{{0x1f2f,0x345}},0x1f9f},
{{{0x1f30,0x300}},0x1f32},
{{{0x1f30,0x301}},0x1f34},
{{{0x1f30,0x342}},0x1f36},
{{{0x1f31,0x300}},0x1f33},
{{{0x1f31,0x301}},0x1f35},
{{{0x1f31,0x342}},0x1f37},
{{{0x1f38,0x300}},0x1f3a},
{{{0x1f38,0x301}},0x1f3c},
{{{0x1f38,0x342}},0x1f3e},
{{{0x1f39,0x300}},0x1f3b},
{{{0x1f39,0x301}},0x1f3d},
{{{0x1f39,0x342}},0x1f3f},
{{{0x1f40,0x300}},0x1f42},
{{{0x1f40,0x301}},0x1f44},
{{{0x1f41,0x300}},0x1f43},
{{{0x1f41,0x301}},0x1f45},
{{{0x1f48,0x300}},0x1f4a},
{{{0x1f48,0x301}},0x1f4c},
{{{0x1f49,0x300}},0x1f4b},
{{{0x1f49,0x301}},0x1f4d},
{{{0x1f50,0x300}},0x1f52},
{{{0x1f50,0x301}},0x1f54},
{{{0x1f50,0x342}},0x1f56},
{{{0x1f51,0x300}},0x1f53},
{{{0x1f51,0x301}},0x1f55},
{{{0x1f51,0x342}},0x1f57},
{{{0x1f59,0x300}},0x1f5b},
{{{0x1f59,0x301}},0x1f5d},
{{{0x1f59,0x342}},0x1f5f},
{{{0x1f60,0x300}},0x1f62},
{{{0x1f60,0x301}},0x1f64},
{{{0x1f60,0x342}},0x1f66},
{{{0x1f60,0x345}},0x1fa0},
{{{0x1f61,0x300}},0x1f63},
{{{0x1f61,0x301}},0x1f65},
{{{0x1f61,0x342}},0x1f67},
{{{0x1f61,0x345}},0x1fa1},
{{{0x1f62,0x345}},0x1fa2},
{{{0x1f63,0x345}},0x1fa3},
{{{0x1f64,0x345}},0x1fa4},
{{{0x1f65,0x345}},0x1fa5},
{{{0x1f66,0x345}},0x1fa6},
{{{0x1f67,0x345}},0x1fa7},
{{{0x1f68,0x300}},0x1f6a},
{{{0x1f68,0x301}},0x1f6c},
{{{0x1f68,0x342}},0x1f6e},
{{{0x1f68,0x345}},0x1fa8},
{{{0x1f69,0x300}},0x1f6b},
{{{0x1f69,0x301}},0x1f6d},
{{{0x1f69,0x342}},0x1f6f},
{{{0x1f69,0x345}},0x1fa9},
{{{0x1f6a,0x345}},0x1faa},
{{{0x1f6b,0x345}},0x1fab},
{{{0x1f6c,0x345}},0x1fac},
{{{0x1f6d,0x345}},0x1fad},
{{{0x1f6e,0x345}},0x1fae},
{{{0x1f6f,0x345}},0x1faf},
{{{0x1f70,0x345}},0x1fb2},
{{{0x1f74,0x345}},0x1fc2},
{{{0x1f7c,0x345}},0x1ff2},
{{{0x1fb6,0x345}},0x1fb7},
{{{0x1fbf,0x300}},0x1fcd},
{{{0x1fbf,0x301}},0x1fce},
{{{0x1fbf,0x342}},0x1fcf},
{{{0x1fc6,0x345}},0x1fc7},
{{{0x1ff6,0x345}},0x1ff7},
{{{0x1ffe,0x300}},0x1fdd},
{{{0x1ffe,0x301}},0x1fde},
{{{0x1ffe,0x342}},0x1fdf},
{{{0x2190,0x338}},0x219a},
{{{0x2192,0x338}},0x219b},
{{{0x2194,0x338}},0x21ae},
{{{0x21d0,0x338}},0x21cd},
{{{0x21d2,0x338}},0x21cf},
{{{0x21d4,0x338}},0x21ce},
{{{0x2203,0x338}},0x2204},
{{{0x2208,0x338}},0x2209},
{{{0x220b,0x338}},0x220c},
{{{0x2223,0x338}},0x2224},
{{{0x2225,0x338}},0x2226},
{{{0x223c,0x338}},0x2241},
{{{0x2243,0x338}},0x2244},
{{{0x2245,0x338}},0x2247},
{{{0x2248,0x338}},0x2249},
{{{0x224d,0x338}},0x226d},
{{{0x2261,0x338}},0x2262},
{{{0x2264,0x338}},0x2270},
{{{0x2265,0x338}},0x2271},
{{{0x2272,0x338}},0x2274},
{{{0x2273,0x338}},0x2275},
{{{0x2276,0x338}},0x2278},
{{{0x2277,0x338}},0x2279},
{{{0x227a,0x338}},0x2280},
{{{0x227b,0x338}},0x2281},
{{{0x227c,0x338}},0x22e0},
{{{0x227d,0x338}},0x22e1},
{{{0x2282,0x338}},0x2284},
{{{0x2283,0x338}},0x2285},
{{{0x2286,0x338}},0x2288},
{{{0x2287,0x338}},0x2289},
{{{0x2291,0x338}},0x22e2},
{{{0x2292,0x338}},0x22e3},
{{{0x22a2,0x338}},0x22ac},
{{{0x22a8,0x338}},0x22ad},
{{{0x22a9,0x338}},0x22ae},
{{{0x22ab,0x338}},0x22af},
{{{0x22b2,0x338}},0x22ea},
{{{0x22b3,0x338}},0x22eb},
{{{0x22b4,0x338}},0x22ec},
{{{0x22b5,0x338}},0x22ed},
{{{0x3046,0x3099}},0x3094},
{{{0x304b,0x3099}},0x304c},
{{{0x304d,0x3099}},0x304e},
{{{0x304f,0x3099}},0x3050},
{{{0x3051,0x3099}},0x3052},
{{{0x3053,0x3099}},0x3054},
{{{0x3055,0x3099}},0x3056},
{{{0x3057,0x3099}},0x3058},
{{{0x3059,0x3099}},0x305a},
{{{0x305b,0x3099}},0x305c},
{{{0x305d,0x3099}},0x305e},
{{{0x305f,0x3099}},0x3060},
{{{0x3061,0x3099}},0x3062},
{{{0x3064,0x3099}},0x3065},
{{{0x3066,0x3099}},0x3067},
{{{0x3068,0x3099}},0x3069},
{{{0x306f,0x3099}},0x3070},
{{{0x306f,0x309a}},0x3071},
{{{0x3072,0x3099}},0x3073},
{{{0x3072,0x309a}},0x3074},
{{{0x3075,0x3099}},0x3076},
{{{0x3075,0x309a}},0x3077},
{{{0x3078,0x3099}},0x3079},
{{{0x3078,0x309a}},0x307a},
{{{0x307b,0x3099}},0x307c},
{{{0x307b,0x309a}},0x307d},
{{{0x309d,0x3099}},0x309e},
{{{0x30a6,0x3099}},0x30f4},
{{{0x30ab,0x3099}},0x30ac},
{{{0x30ad,0x3099}},0x30ae},
{{{0x30af,0x3099}},0x30b0},
{{{0x30b1,0x3099}},0x30b2},
{{{0x30b3,0x3099}},0x30b4},
{{{0x30b5,0x3099}},0x30b6},
{{{0x30b7,0x3099}},0x30b8},
{{{0x30b9,0x3099}},0x30ba},
{{{0x30bb,0x3099}},0x30bc},
{{{0x30bd,0x3099}},0x30be},
{{{0x30bf,0x3099}},0x30c0},
{{{0x30c1,0x3099}},0x30c2},
{{{0x30c4,0x3099}},0x30c5},
{{{0x30c6,0x3099}},0x30c7},
{{{0x30c8,0x3099}},0x30c9},
{{{0x30cf,0x3099}},0x30d0},
{{{0x30cf,0x309a}},0x30d1},
{{{0x30d2,0x3099}},0x30d3},
{{{0x30d2,0x309a}},0x30d4},
{{{0x30d5,0x3099}},0x30d6},
{{{0x30d5,0x309a}},0x30d7},
{{{0x30d8,0x3099}},0x30d9},
{{{0x30d8,0x309a}},0x30da},
{{{0x30db,0x3099}},0x30dc},
{{{0x30db,0x309a}},0x30dd},
{{{0x30ef,0x3099}},0x30f7},
{{{0x30f0,0x3099}},0x30f8},
{{{0x30f1,0x3099}},0x30f9},
{{{0x30f2,0x3099}},0x30fa},
{{{0x30fd,0x3099}},0x30fe},
{{{0x11099,0x110ba}},0x1109a},
{{{0x1109b,0x110ba}},0x1109c},
{{{0x110a5,0x110ba}},0x110ab},
{{{0x11131,0x11127}},0x1112e},
{{{0x11132,0x11127}},0x1112f},
{{{0x11347,0x1133e}},0x1134b},
{{{0x11347,0x11357}},0x1134c},
{{{0x114b9,0x114b0}},0x114bc},
{{{0x114b9,0x114ba}},0x114bb},
{{{0x114b9,0x114bd}},0x114be},
{{{0x115b8,0x115af}},0x115ba},
{{{0x115b9,0x115af}},0x115bb},
}};

const TableView<std::array<char32_t, 2>, char32_t> composition_table {&composition_array[0], &composition_array[0] + composition_array.size()};

}
