#include "unicorn/ucd-tables.hpp"

namespace RS::Unicorn::UnicornDetail {

const std::array<KeyValue<char32_t, char const*>, 305> blocks_array = {{
{0x0,"Basic Latin"},
{0x80,"Latin-1 Supplement"},
{0x100,"Latin Extended-A"},
{0x180,"Latin Extended-B"},
{0x250,"IPA Extensions"},
{0x2b0,"Spacing Modifier Letters"},
{0x300,"Combining Diacritical Marks"},
{0x370,"Greek and Coptic"},
{0x400,"Cyrillic"},
{0x500,"Cyrillic Supplement"},
{0x530,"Armenian"},
{0x590,"Hebrew"},
{0x600,"Arabic"},
{0x700,"Syriac"},
{0x750,"Arabic Supplement"},
{0x780,"Thaana"},
{0x7c0,"NKo"},
{0x800,"Samaritan"},
{0x840,"Mandaic"},
{0x860,static_cast<char const*>(0)},
{0x8a0,"Arabic Extended-A"},
{0x900,"Devanagari"},
{0x980,"Bengali"},
{0xa00,"Gurmukhi"},
{0xa80,"Gujarati"},
{0xb00,"Oriya"},
{0xb80,"Tamil"},
{0xc00,"Telugu"},
{0xc80,"Kannada"},
{0xd00,"Malayalam"},
{0xd80,"Sinhala"},
{0xe00,"Thai"},
{0xe80,"Lao"},
{0xf00,"Tibetan"},
{0x1000,"Myanmar"},
{0x10a0,"Georgian"},
{0x1100,"Hangul Jamo"},
{0x1200,"Ethiopic"},
{0x1380,"Ethiopic Supplement"},
{0x13a0,"Cherokee"},
{0x1400,"Unified Canadian Aboriginal Syllabics"},
{0x1680,"Ogham"},
{0x16a0,"Runic"},
{0x1700,"Tagalog"},
{0x1720,"Hanunoo"},
{0x1740,"Buhid"},
{0x1760,"Tagbanwa"},
{0x1780,"Khmer"},
{0x1800,"Mongolian"},
{0x18b0,"Unified Canadian Aboriginal Syllabics Extended"},
{0x1900,"Limbu"},
{0x1950,"Tai Le"},
{0x1980,"New Tai Lue"},
{0x19e0,"Khmer Symbols"},
{0x1a00,"Buginese"},
{0x1a20,"Tai Tham"},
{0x1ab0,"Combining Diacritical Marks Extended"},
{0x1b00,"Balinese"},
{0x1b80,"Sundanese"},
{0x1bc0,"Batak"},
{0x1c00,"Lepcha"},
{0x1c50,"Ol Chiki"},
{0x1c80,static_cast<char const*>(0)},
{0x1cc0,"Sundanese Supplement"},
{0x1cd0,"Vedic Extensions"},
{0x1d00,"Phonetic Extensions"},
{0x1d80,"Phonetic Extensions Supplement"},
{0x1dc0,"Combining Diacritical Marks Supplement"},
{0x1e00,"Latin Extended Additional"},
{0x1f00,"Greek Extended"},
{0x2000,"General Punctuation"},
{0x2070,"Superscripts and Subscripts"},
{0x20a0,"Currency Symbols"},
{0x20d0,"Combining Diacritical Marks for Symbols"},
{0x2100,"Letterlike Symbols"},
{0x2150,"Number Forms"},
{0x2190,"Arrows"},
{0x2200,"Mathematical Operators"},
{0x2300,"Miscellaneous Technical"},
{0x2400,"Control Pictures"},
{0x2440,"Optical Character Recognition"},
{0x2460,"Enclosed Alphanumerics"},
{0x2500,"Box Drawing"},
{0x2580,"Block Elements"},
{0x25a0,"Geometric Shapes"},
{0x2600,"Miscellaneous Symbols"},
{0x2700,"Dingbats"},
{0x27c0,"Miscellaneous Mathematical Symbols-A"},
{0x27f0,"Supplemental Arrows-A"},
{0x2800,"Braille Patterns"},
{0x2900,"Supplemental Arrows-B"},
{0x2980,"Miscellaneous Mathematical Symbols-B"},
{0x2a00,"Supplemental Mathematical Operators"},
{0x2b00,"Miscellaneous Symbols and Arrows"},
{0x2c00,"Glagolitic"},
{0x2c60,"Latin Extended-C"},
{0x2c80,"Coptic"},
{0x2d00,"Georgian Supplement"},
{0x2d30,"Tifinagh"},
{0x2d80,"Ethiopic Extended"},
{0x2de0,"Cyrillic Extended-A"},
{0x2e00,"Supplemental Punctuation"},
{0x2e80,"CJK Radicals Supplement"},
{0x2f00,"Kangxi Radicals"},
{0x2fe0,static_cast<char const*>(0)},
{0x2ff0,"Ideographic Description Characters"},
{0x3000,"CJK Symbols and Punctuation"},
{0x3040,"Hiragana"},
{0x30a0,"Katakana"},
{0x3100,"Bopomofo"},
{0x3130,"Hangul Compatibility Jamo"},
{0x3190,"Kanbun"},
{0x31a0,"Bopomofo Extended"},
{0x31c0,"CJK Strokes"},
{0x31f0,"Katakana Phonetic Extensions"},
{0x3200,"Enclosed CJK Letters and Months"},
{0x3300,"CJK Compatibility"},
{0x3400,"CJK Unified Ideographs Extension A"},
{0x4dc0,"Yijing Hexagram Symbols"},
{0x4e00,"CJK Unified Ideographs"},
{0xa000,"Yi Syllables"},
{0xa490,"Yi Radicals"},
{0xa4d0,"Lisu"},
{0xa500,"Vai"},
{0xa640,"Cyrillic Extended-B"},
{0xa6a0,"Bamum"},
{0xa700,"Modifier Tone Letters"},
{0xa720,"Latin Extended-D"},
{0xa800,"Syloti Nagri"},
{0xa830,"Common Indic Number Forms"},
{0xa840,"Phags-pa"},
{0xa880,"Saurashtra"},
{0xa8e0,"Devanagari Extended"},
{0xa900,"Kayah Li"},
{0xa930,"Rejang"},
{0xa960,"Hangul Jamo Extended-A"},
{0xa980,"Javanese"},
{0xa9e0,"Myanmar Extended-B"},
{0xaa00,"Cham"},
{0xaa60,"Myanmar Extended-A"},
{0xaa80,"Tai Viet"},
{0xaae0,"Meetei Mayek Extensions"},
{0xab00,"Ethiopic Extended-A"},
{0xab30,"Latin Extended-E"},
{0xab70,"Cherokee Supplement"},
{0xabc0,"Meetei Mayek"},
{0xac00,"Hangul Syllables"},
{0xd7b0,"Hangul Jamo Extended-B"},
{0xd800,"High Surrogates"},
{0xdb80,"High Private Use Surrogates"},
{0xdc00,"Low Surrogates"},
{0xe000,"Private Use Area"},
{0xf900,"CJK Compatibility Ideographs"},
{0xfb00,"Alphabetic Presentation Forms"},
{0xfb50,"Arabic Presentation Forms-A"},
{0xfe00,"Variation Selectors"},
{0xfe10,"Vertical Forms"},
{0xfe20,"Combining Half Marks"},
{0xfe30,"CJK Compatibility Forms"},
{0xfe50,"Small Form Variants"},
{0xfe70,"Arabic Presentation Forms-B"},
{0xff00,"Halfwidth and Fullwidth Forms"},
{0xfff0,"Specials"},
{0x10000,"Linear B Syllabary"},
{0x10080,"Linear B Ideograms"},
{0x10100,"Aegean Numbers"},
{0x10140,"Ancient Greek Numbers"},
{0x10190,"Ancient Symbols"},
{0x101d0,"Phaistos Disc"},
{0x10200,static_cast<char const*>(0)},
{0x10280,"Lycian"},
{0x102a0,"Carian"},
{0x102e0,"Coptic Epact Numbers"},
{0x10300,"Old Italic"},
{0x10330,"Gothic"},
{0x10350,"Old Permic"},
{0x10380,"Ugaritic"},
{0x103a0,"Old Persian"},
{0x103e0,static_cast<char const*>(0)},
{0x10400,"Deseret"},
{0x10450,"Shavian"},
{0x10480,"Osmanya"},
{0x104b0,static_cast<char const*>(0)},
{0x10500,"Elbasan"},
{0x10530,"Caucasian Albanian"},
{0x10570,static_cast<char const*>(0)},
{0x10600,"Linear A"},
{0x10780,static_cast<char const*>(0)},
{0x10800,"Cypriot Syllabary"},
{0x10840,"Imperial Aramaic"},
{0x10860,"Palmyrene"},
{0x10880,"Nabataean"},
{0x108b0,static_cast<char const*>(0)},
{0x108e0,"Hatran"},
{0x10900,"Phoenician"},
{0x10920,"Lydian"},
{0x10940,static_cast<char const*>(0)},
{0x10980,"Meroitic Hieroglyphs"},
{0x109a0,"Meroitic Cursive"},
{0x10a00,"Kharoshthi"},
{0x10a60,"Old South Arabian"},
{0x10a80,"Old North Arabian"},
{0x10aa0,static_cast<char const*>(0)},
{0x10ac0,"Manichaean"},
{0x10b00,"Avestan"},
{0x10b40,"Inscriptional Parthian"},
{0x10b60,"Inscriptional Pahlavi"},
{0x10b80,"Psalter Pahlavi"},
{0x10bb0,static_cast<char const*>(0)},
{0x10c00,"Old Turkic"},
{0x10c50,static_cast<char const*>(0)},
{0x10c80,"Old Hungarian"},
{0x10d00,static_cast<char const*>(0)},
{0x10e60,"Rumi Numeral Symbols"},
{0x10e80,static_cast<char const*>(0)},
{0x11000,"Brahmi"},
{0x11080,"Kaithi"},
{0x110d0,"Sora Sompeng"},
{0x11100,"Chakma"},
{0x11150,"Mahajani"},
{0x11180,"Sharada"},
{0x111e0,"Sinhala Archaic Numbers"},
{0x11200,"Khojki"},
{0x11250,static_cast<char const*>(0)},
{0x11280,"Multani"},
{0x112b0,"Khudawadi"},
{0x11300,"Grantha"},
{0x11380,static_cast<char const*>(0)},
{0x11480,"Tirhuta"},
{0x114e0,static_cast<char const*>(0)},
{0x11580,"Siddham"},
{0x11600,"Modi"},
{0x11660,static_cast<char const*>(0)},
{0x11680,"Takri"},
{0x116d0,static_cast<char const*>(0)},
{0x11700,"Ahom"},
{0x11740,static_cast<char const*>(0)},
{0x118a0,"Warang Citi"},
{0x11900,static_cast<char const*>(0)},
{0x11ac0,"Pau Cin Hau"},
{0x11b00,static_cast<char const*>(0)},
{0x12000,"Cuneiform"},
{0x12400,"Cuneiform Numbers and Punctuation"},
{0x12480,"Early Dynastic Cuneiform"},
{0x12550,static_cast<char const*>(0)},
{0x13000,"Egyptian Hieroglyphs"},
{0x13430,static_cast<char const*>(0)},
{0x14400,"Anatolian Hieroglyphs"},
{0x14680,static_cast<char const*>(0)},
{0x16800,"Bamum Supplement"},
{0x16a40,"Mro"},
{0x16a70,static_cast<char const*>(0)},
{0x16ad0,"Bassa Vah"},
{0x16b00,"Pahawh Hmong"},
{0x16b90,static_cast<char const*>(0)},
{0x16f00,"Miao"},
{0x16fa0,static_cast<char const*>(0)},
{0x1b000,"Kana Supplement"},
{0x1b100,static_cast<char const*>(0)},
{0x1bc00,"Duployan"},
{0x1bca0,"Shorthand Format Controls"},
{0x1bcb0,static_cast<char const*>(0)},
{0x1d000,"Byzantine Musical Symbols"},
{0x1d100,"Musical Symbols"},
{0x1d200,"Ancient Greek Musical Notation"},
{0x1d250,static_cast<char const*>(0)},
{0x1d300,"Tai Xuan Jing Symbols"},
{0x1d360,"Counting Rod Numerals"},
{0x1d380,static_cast<char const*>(0)},
{0x1d400,"Mathematical Alphanumeric Symbols"},
{0x1d800,"Sutton SignWriting"},
{0x1dab0,static_cast<char const*>(0)},
{0x1e800,"Mende Kikakui"},
{0x1e8e0,static_cast<char const*>(0)},
{0x1ee00,"Arabic Mathematical Alphabetic Symbols"},
{0x1ef00,static_cast<char const*>(0)},
{0x1f000,"Mahjong Tiles"},
{0x1f030,"Domino Tiles"},
{0x1f0a0,"Playing Cards"},
{0x1f100,"Enclosed Alphanumeric Supplement"},
{0x1f200,"Enclosed Ideographic Supplement"},
{0x1f300,"Miscellaneous Symbols and Pictographs"},
{0x1f600,"Emoticons"},
{0x1f650,"Ornamental Dingbats"},
{0x1f680,"Transport and Map Symbols"},
{0x1f700,"Alchemical Symbols"},
{0x1f780,"Geometric Shapes Extended"},
{0x1f800,"Supplemental Arrows-C"},
{0x1f900,"Supplemental Symbols and Pictographs"},
{0x1fa00,static_cast<char const*>(0)},
{0x20000,"CJK Unified Ideographs Extension B"},
{0x2a6e0,static_cast<char const*>(0)},
{0x2a700,"CJK Unified Ideographs Extension C"},
{0x2b740,"CJK Unified Ideographs Extension D"},
{0x2b820,"CJK Unified Ideographs Extension E"},
{0x2ceb0,static_cast<char const*>(0)},
{0x2f800,"CJK Compatibility Ideographs Supplement"},
{0x2fa20,static_cast<char const*>(0)},
{0xe0000,"Tags"},
{0xe0080,static_cast<char const*>(0)},
{0xe0100,"Variation Selectors Supplement"},
{0xe01f0,static_cast<char const*>(0)},
{0xf0000,"Supplementary Private Use Area-A"},
{0x100000,"Supplementary Private Use Area-B"},
{0x110000,static_cast<char const*>(0)},
}};

const TableView<char32_t, char const*> blocks_table {&blocks_array[0], &blocks_array[0] + blocks_array.size()};

}
