#include "unicorn/ucd-tables.hpp"

namespace RS::Unicorn::UnicornDetail {

const std::array<KeyValue<char32_t, Bidi_Class>, 1892> bidi_class_array = {{
{0x0,Bidi_Class::BN},
{0x9,Bidi_Class::S},
{0xa,Bidi_Class::B},
{0xb,Bidi_Class::S},
{0xc,Bidi_Class::WS},
{0xd,Bidi_Class::B},
{0xe,Bidi_Class::BN},
{0x1c,Bidi_Class::B},
{0x1f,Bidi_Class::S},
{0x20,Bidi_Class::WS},
{0x21,Bidi_Class::ON},
{0x23,Bidi_Class::ET},
{0x26,Bidi_Class::ON},
{0x2b,Bidi_Class::ES},
{0x2c,Bidi_Class::CS},
{0x2d,Bidi_Class::ES},
{0x2e,Bidi_Class::CS},
{0x30,Bidi_Class::EN},
{0x3a,Bidi_Class::CS},
{0x3b,Bidi_Class::ON},
{0x41,Bidi_Class::L},
{0x5b,Bidi_Class::ON},
{0x61,Bidi_Class::L},
{0x7b,Bidi_Class::ON},
{0x7f,Bidi_Class::BN},
{0x85,Bidi_Class::B},
{0x86,Bidi_Class::BN},
{0xa0,Bidi_Class::CS},
{0xa1,Bidi_Class::ON},
{0xa2,Bidi_Class::ET},
{0xa6,Bidi_Class::ON},
{0xaa,Bidi_Class::L},
{0xab,Bidi_Class::ON},
{0xad,Bidi_Class::BN},
{0xae,Bidi_Class::ON},
{0xb0,Bidi_Class::ET},
{0xb2,Bidi_Class::EN},
{0xb4,Bidi_Class::ON},
{0xb5,Bidi_Class::L},
{0xb6,Bidi_Class::ON},
{0xb9,Bidi_Class::EN},
{0xba,Bidi_Class::L},
{0xbb,Bidi_Class::ON},
{0xc0,Bidi_Class::L},
{0xd7,Bidi_Class::ON},
{0xd8,Bidi_Class::L},
{0xf7,Bidi_Class::ON},
{0xf8,Bidi_Class::L},
{0x2b9,Bidi_Class::ON},
{0x2bb,Bidi_Class::L},
{0x2c2,Bidi_Class::ON},
{0x2d0,Bidi_Class::L},
{0x2d2,Bidi_Class::ON},
{0x2e0,Bidi_Class::L},
{0x2e5,Bidi_Class::ON},
{0x2ee,Bidi_Class::L},
{0x2ef,Bidi_Class::ON},
{0x300,Bidi_Class::NSM},
{0x370,Bidi_Class::L},
{0x374,Bidi_Class::ON},
{0x376,Bidi_Class::L},
{0x378,static_cast<Bidi_Class>(0)},
{0x37a,Bidi_Class::L},
{0x37e,Bidi_Class::ON},
{0x37f,Bidi_Class::L},
{0x380,static_cast<Bidi_Class>(0)},
{0x384,Bidi_Class::ON},
{0x386,Bidi_Class::L},
{0x387,Bidi_Class::ON},
{0x388,Bidi_Class::L},
{0x38b,static_cast<Bidi_Class>(0)},
{0x38c,Bidi_Class::L},
{0x38d,static_cast<Bidi_Class>(0)},
{0x38e,Bidi_Class::L},
{0x3a2,static_cast<Bidi_Class>(0)},
{0x3a3,Bidi_Class::L},
{0x3f6,Bidi_Class::ON},
{0x3f7,Bidi_Class::L},
{0x483,Bidi_Class::NSM},
{0x48a,Bidi_Class::L},
{0x530,static_cast<Bidi_Class>(0)},
{0x531,Bidi_Class::L},
{0x557,static_cast<Bidi_Class>(0)},
{0x559,Bidi_Class::L},
{0x560,static_cast<Bidi_Class>(0)},
{0x561,Bidi_Class::L},
{0x588,static_cast<Bidi_Class>(0)},
{0x589,Bidi_Class::L},
{0x58a,Bidi_Class::ON},
{0x58b,static_cast<Bidi_Class>(0)},
{0x58d,Bidi_Class::ON},
{0x58f,Bidi_Class::ET},
{0x590,static_cast<Bidi_Class>(0)},
{0x591,Bidi_Class::NSM},
{0x5be,Bidi_Class::R},
{0x5bf,Bidi_Class::NSM},
{0x5c0,Bidi_Class::R},
{0x5c1,Bidi_Class::NSM},
{0x5c3,Bidi_Class::R},
{0x5c4,Bidi_Class::NSM},
{0x5c6,Bidi_Class::R},
{0x5c7,Bidi_Class::NSM},
{0x5c8,static_cast<Bidi_Class>(0)},
{0x5d0,Bidi_Class::R},
{0x5eb,static_cast<Bidi_Class>(0)},
{0x5f0,Bidi_Class::R},
{0x5f5,static_cast<Bidi_Class>(0)},
{0x600,Bidi_Class::AN},
{0x606,Bidi_Class::ON},
{0x608,Bidi_Class::AL},
{0x609,Bidi_Class::ET},
{0x60b,Bidi_Class::AL},
{0x60c,Bidi_Class::CS},
{0x60d,Bidi_Class::AL},
{0x60e,Bidi_Class::ON},
{0x610,Bidi_Class::NSM},
{0x61b,Bidi_Class::AL},
{0x61d,static_cast<Bidi_Class>(0)},
{0x61e,Bidi_Class::AL},
{0x64b,Bidi_Class::NSM},
{0x660,Bidi_Class::AN},
{0x66a,Bidi_Class::ET},
{0x66b,Bidi_Class::AN},
{0x66d,Bidi_Class::AL},
{0x670,Bidi_Class::NSM},
{0x671,Bidi_Class::AL},
{0x6d6,Bidi_Class::NSM},
{0x6dd,Bidi_Class::AN},
{0x6de,Bidi_Class::ON},
{0x6df,Bidi_Class::NSM},
{0x6e5,Bidi_Class::AL},
{0x6e7,Bidi_Class::NSM},
{0x6e9,Bidi_Class::ON},
{0x6ea,Bidi_Class::NSM},
{0x6ee,Bidi_Class::AL},
{0x6f0,Bidi_Class::EN},
{0x6fa,Bidi_Class::AL},
{0x70e,static_cast<Bidi_Class>(0)},
{0x70f,Bidi_Class::AL},
{0x711,Bidi_Class::NSM},
{0x712,Bidi_Class::AL},
{0x730,Bidi_Class::NSM},
{0x74b,static_cast<Bidi_Class>(0)},
{0x74d,Bidi_Class::AL},
{0x7a6,Bidi_Class::NSM},
{0x7b1,Bidi_Class::AL},
{0x7b2,static_cast<Bidi_Class>(0)},
{0x7c0,Bidi_Class::R},
{0x7eb,Bidi_Class::NSM},
{0x7f4,Bidi_Class::R},
{0x7f6,Bidi_Class::ON},
{0x7fa,Bidi_Class::R},
{0x7fb,static_cast<Bidi_Class>(0)},
{0x800,Bidi_Class::R},
{0x816,Bidi_Class::NSM},
{0x81a,Bidi_Class::R},
{0x81b,Bidi_Class::NSM},
{0x824,Bidi_Class::R},
{0x825,Bidi_Class::NSM},
{0x828,Bidi_Class::R},
{0x829,Bidi_Class::NSM},
{0x82e,static_cast<Bidi_Class>(0)},
{0x830,Bidi_Class::R},
{0x83f,static_cast<Bidi_Class>(0)},
{0x840,Bidi_Class::R},
{0x859,Bidi_Class::NSM},
{0x85c,static_cast<Bidi_Class>(0)},
{0x85e,Bidi_Class::R},
{0x85f,static_cast<Bidi_Class>(0)},
{0x8a0,Bidi_Class::AL},
{0x8b5,static_cast<Bidi_Class>(0)},
{0x8e3,Bidi_Class::NSM},
{0x903,Bidi_Class::L},
{0x93a,Bidi_Class::NSM},
{0x93b,Bidi_Class::L},
{0x93c,Bidi_Class::NSM},
{0x93d,Bidi_Class::L},
{0x941,Bidi_Class::NSM},
{0x949,Bidi_Class::L},
{0x94d,Bidi_Class::NSM},
{0x94e,Bidi_Class::L},
{0x951,Bidi_Class::NSM},
{0x958,Bidi_Class::L},
{0x962,Bidi_Class::NSM},
{0x964,Bidi_Class::L},
{0x981,Bidi_Class::NSM},
{0x982,Bidi_Class::L},
{0x984,static_cast<Bidi_Class>(0)},
{0x985,Bidi_Class::L},
{0x98d,static_cast<Bidi_Class>(0)},
{0x98f,Bidi_Class::L},
{0x991,static_cast<Bidi_Class>(0)},
{0x993,Bidi_Class::L},
{0x9a9,static_cast<Bidi_Class>(0)},
{0x9aa,Bidi_Class::L},
{0x9b1,static_cast<Bidi_Class>(0)},
{0x9b2,Bidi_Class::L},
{0x9b3,static_cast<Bidi_Class>(0)},
{0x9b6,Bidi_Class::L},
{0x9ba,static_cast<Bidi_Class>(0)},
{0x9bc,Bidi_Class::NSM},
{0x9bd,Bidi_Class::L},
{0x9c1,Bidi_Class::NSM},
{0x9c5,static_cast<Bidi_Class>(0)},
{0x9c7,Bidi_Class::L},
{0x9c9,static_cast<Bidi_Class>(0)},
{0x9cb,Bidi_Class::L},
{0x9cd,Bidi_Class::NSM},
{0x9ce,Bidi_Class::L},
{0x9cf,static_cast<Bidi_Class>(0)},
{0x9d7,Bidi_Class::L},
{0x9d8,static_cast<Bidi_Class>(0)},
{0x9dc,Bidi_Class::L},
{0x9de,static_cast<Bidi_Class>(0)},
{0x9df,Bidi_Class::L},
{0x9e2,Bidi_Class::NSM},
{0x9e4,static_cast<Bidi_Class>(0)},
{0x9e6,Bidi_Class::L},
{0x9f2,Bidi_Class::ET},
{0x9f4,Bidi_Class::L},
{0x9fb,Bidi_Class::ET},
{0x9fc,static_cast<Bidi_Class>(0)},
{0xa01,Bidi_Class::NSM},
{0xa03,Bidi_Class::L},
{0xa04,static_cast<Bidi_Class>(0)},
{0xa05,Bidi_Class::L},
{0xa0b,static_cast<Bidi_Class>(0)},
{0xa0f,Bidi_Class::L},
{0xa11,static_cast<Bidi_Class>(0)},
{0xa13,Bidi_Class::L},
{0xa29,static_cast<Bidi_Class>(0)},
{0xa2a,Bidi_Class::L},
{0xa31,static_cast<Bidi_Class>(0)},
{0xa32,Bidi_Class::L},
{0xa34,static_cast<Bidi_Class>(0)},
{0xa35,Bidi_Class::L},
{0xa37,static_cast<Bidi_Class>(0)},
{0xa38,Bidi_Class::L},
{0xa3a,static_cast<Bidi_Class>(0)},
{0xa3c,Bidi_Class::NSM},
{0xa3d,static_cast<Bidi_Class>(0)},
{0xa3e,Bidi_Class::L},
{0xa41,Bidi_Class::NSM},
{0xa43,static_cast<Bidi_Class>(0)},
{0xa47,Bidi_Class::NSM},
{0xa49,static_cast<Bidi_Class>(0)},
{0xa4b,Bidi_Class::NSM},
{0xa4e,static_cast<Bidi_Class>(0)},
{0xa51,Bidi_Class::NSM},
{0xa52,static_cast<Bidi_Class>(0)},
{0xa59,Bidi_Class::L},
{0xa5d,static_cast<Bidi_Class>(0)},
{0xa5e,Bidi_Class::L},
{0xa5f,static_cast<Bidi_Class>(0)},
{0xa66,Bidi_Class::L},
{0xa70,Bidi_Class::NSM},
{0xa72,Bidi_Class::L},
{0xa75,Bidi_Class::NSM},
{0xa76,static_cast<Bidi_Class>(0)},
{0xa81,Bidi_Class::NSM},
{0xa83,Bidi_Class::L},
{0xa84,static_cast<Bidi_Class>(0)},
{0xa85,Bidi_Class::L},
{0xa8e,static_cast<Bidi_Class>(0)},
{0xa8f,Bidi_Class::L},
{0xa92,static_cast<Bidi_Class>(0)},
{0xa93,Bidi_Class::L},
{0xaa9,static_cast<Bidi_Class>(0)},
{0xaaa,Bidi_Class::L},
{0xab1,static_cast<Bidi_Class>(0)},
{0xab2,Bidi_Class::L},
{0xab4,static_cast<Bidi_Class>(0)},
{0xab5,Bidi_Class::L},
{0xaba,static_cast<Bidi_Class>(0)},
{0xabc,Bidi_Class::NSM},
{0xabd,Bidi_Class::L},
{0xac1,Bidi_Class::NSM},
{0xac6,static_cast<Bidi_Class>(0)},
{0xac7,Bidi_Class::NSM},
{0xac9,Bidi_Class::L},
{0xaca,static_cast<Bidi_Class>(0)},
{0xacb,Bidi_Class::L},
{0xacd,Bidi_Class::NSM},
{0xace,static_cast<Bidi_Class>(0)},
{0xad0,Bidi_Class::L},
{0xad1,static_cast<Bidi_Class>(0)},
{0xae0,Bidi_Class::L},
{0xae2,Bidi_Class::NSM},
{0xae4,static_cast<Bidi_Class>(0)},
{0xae6,Bidi_Class::L},
{0xaf1,Bidi_Class::ET},
{0xaf2,static_cast<Bidi_Class>(0)},
{0xaf9,Bidi_Class::L},
{0xafa,static_cast<Bidi_Class>(0)},
{0xb01,Bidi_Class::NSM},
{0xb02,Bidi_Class::L},
{0xb04,static_cast<Bidi_Class>(0)},
{0xb05,Bidi_Class::L},
{0xb0d,static_cast<Bidi_Class>(0)},
{0xb0f,Bidi_Class::L},
{0xb11,static_cast<Bidi_Class>(0)},
{0xb13,Bidi_Class::L},
{0xb29,static_cast<Bidi_Class>(0)},
{0xb2a,Bidi_Class::L},
{0xb31,static_cast<Bidi_Class>(0)},
{0xb32,Bidi_Class::L},
{0xb34,static_cast<Bidi_Class>(0)},
{0xb35,Bidi_Class::L},
{0xb3a,static_cast<Bidi_Class>(0)},
{0xb3c,Bidi_Class::NSM},
{0xb3d,Bidi_Class::L},
{0xb3f,Bidi_Class::NSM},
{0xb40,Bidi_Class::L},
{0xb41,Bidi_Class::NSM},
{0xb45,static_cast<Bidi_Class>(0)},
{0xb47,Bidi_Class::L},
{0xb49,static_cast<Bidi_Class>(0)},
{0xb4b,Bidi_Class::L},
{0xb4d,Bidi_Class::NSM},
{0xb4e,static_cast<Bidi_Class>(0)},
{0xb56,Bidi_Class::NSM},
{0xb57,Bidi_Class::L},
{0xb58,static_cast<Bidi_Class>(0)},
{0xb5c,Bidi_Class::L},
{0xb5e,static_cast<Bidi_Class>(0)},
{0xb5f,Bidi_Class::L},
{0xb62,Bidi_Class::NSM},
{0xb64,static_cast<Bidi_Class>(0)},
{0xb66,Bidi_Class::L},
{0xb78,static_cast<Bidi_Class>(0)},
{0xb82,Bidi_Class::NSM},
{0xb83,Bidi_Class::L},
{0xb84,static_cast<Bidi_Class>(0)},
{0xb85,Bidi_Class::L},
{0xb8b,static_cast<Bidi_Class>(0)},
{0xb8e,Bidi_Class::L},
{0xb91,static_cast<Bidi_Class>(0)},
{0xb92,Bidi_Class::L},
{0xb96,static_cast<Bidi_Class>(0)},
{0xb99,Bidi_Class::L},
{0xb9b,static_cast<Bidi_Class>(0)},
{0xb9c,Bidi_Class::L},
{0xb9d,static_cast<Bidi_Class>(0)},
{0xb9e,Bidi_Class::L},
{0xba0,static_cast<Bidi_Class>(0)},
{0xba3,Bidi_Class::L},
{0xba5,static_cast<Bidi_Class>(0)},
{0xba8,Bidi_Class::L},
{0xbab,static_cast<Bidi_Class>(0)},
{0xbae,Bidi_Class::L},
{0xbba,static_cast<Bidi_Class>(0)},
{0xbbe,Bidi_Class::L},
{0xbc0,Bidi_Class::NSM},
{0xbc1,Bidi_Class::L},
{0xbc3,static_cast<Bidi_Class>(0)},
{0xbc6,Bidi_Class::L},
{0xbc9,static_cast<Bidi_Class>(0)},
{0xbca,Bidi_Class::L},
{0xbcd,Bidi_Class::NSM},
{0xbce,static_cast<Bidi_Class>(0)},
{0xbd0,Bidi_Class::L},
{0xbd1,static_cast<Bidi_Class>(0)},
{0xbd7,Bidi_Class::L},
{0xbd8,static_cast<Bidi_Class>(0)},
{0xbe6,Bidi_Class::L},
{0xbf3,Bidi_Class::ON},
{0xbf9,Bidi_Class::ET},
{0xbfa,Bidi_Class::ON},
{0xbfb,static_cast<Bidi_Class>(0)},
{0xc00,Bidi_Class::NSM},
{0xc01,Bidi_Class::L},
{0xc04,static_cast<Bidi_Class>(0)},
{0xc05,Bidi_Class::L},
{0xc0d,static_cast<Bidi_Class>(0)},
{0xc0e,Bidi_Class::L},
{0xc11,static_cast<Bidi_Class>(0)},
{0xc12,Bidi_Class::L},
{0xc29,static_cast<Bidi_Class>(0)},
{0xc2a,Bidi_Class::L},
{0xc3a,static_cast<Bidi_Class>(0)},
{0xc3d,Bidi_Class::L},
{0xc3e,Bidi_Class::NSM},
{0xc41,Bidi_Class::L},
{0xc45,static_cast<Bidi_Class>(0)},
{0xc46,Bidi_Class::NSM},
{0xc49,static_cast<Bidi_Class>(0)},
{0xc4a,Bidi_Class::NSM},
{0xc4e,static_cast<Bidi_Class>(0)},
{0xc55,Bidi_Class::NSM},
{0xc57,static_cast<Bidi_Class>(0)},
{0xc58,Bidi_Class::L},
{0xc5b,static_cast<Bidi_Class>(0)},
{0xc60,Bidi_Class::L},
{0xc62,Bidi_Class::NSM},
{0xc64,static_cast<Bidi_Class>(0)},
{0xc66,Bidi_Class::L},
{0xc70,static_cast<Bidi_Class>(0)},
{0xc78,Bidi_Class::ON},
{0xc7f,Bidi_Class::L},
{0xc80,static_cast<Bidi_Class>(0)},
{0xc81,Bidi_Class::NSM},
{0xc82,Bidi_Class::L},
{0xc84,static_cast<Bidi_Class>(0)},
{0xc85,Bidi_Class::L},
{0xc8d,static_cast<Bidi_Class>(0)},
{0xc8e,Bidi_Class::L},
{0xc91,static_cast<Bidi_Class>(0)},
{0xc92,Bidi_Class::L},
{0xca9,static_cast<Bidi_Class>(0)},
{0xcaa,Bidi_Class::L},
{0xcb4,static_cast<Bidi_Class>(0)},
{0xcb5,Bidi_Class::L},
{0xcba,static_cast<Bidi_Class>(0)},
{0xcbc,Bidi_Class::NSM},
{0xcbd,Bidi_Class::L},
{0xcc5,static_cast<Bidi_Class>(0)},
{0xcc6,Bidi_Class::L},
{0xcc9,static_cast<Bidi_Class>(0)},
{0xcca,Bidi_Class::L},
{0xccc,Bidi_Class::NSM},
{0xcce,static_cast<Bidi_Class>(0)},
{0xcd5,Bidi_Class::L},
{0xcd7,static_cast<Bidi_Class>(0)},
{0xcde,Bidi_Class::L},
{0xcdf,static_cast<Bidi_Class>(0)},
{0xce0,Bidi_Class::L},
{0xce2,Bidi_Class::NSM},
{0xce4,static_cast<Bidi_Class>(0)},
{0xce6,Bidi_Class::L},
{0xcf0,static_cast<Bidi_Class>(0)},
{0xcf1,Bidi_Class::L},
{0xcf3,static_cast<Bidi_Class>(0)},
{0xd01,Bidi_Class::NSM},
{0xd02,Bidi_Class::L},
{0xd04,static_cast<Bidi_Class>(0)},
{0xd05,Bidi_Class::L},
{0xd0d,static_cast<Bidi_Class>(0)},
{0xd0e,Bidi_Class::L},
{0xd11,static_cast<Bidi_Class>(0)},
{0xd12,Bidi_Class::L},
{0xd3b,static_cast<Bidi_Class>(0)},
{0xd3d,Bidi_Class::L},
{0xd41,Bidi_Class::NSM},
{0xd45,static_cast<Bidi_Class>(0)},
{0xd46,Bidi_Class::L},
{0xd49,static_cast<Bidi_Class>(0)},
{0xd4a,Bidi_Class::L},
{0xd4d,Bidi_Class::NSM},
{0xd4e,Bidi_Class::L},
{0xd4f,static_cast<Bidi_Class>(0)},
{0xd57,Bidi_Class::L},
{0xd58,static_cast<Bidi_Class>(0)},
{0xd5f,Bidi_Class::L},
{0xd62,Bidi_Class::NSM},
{0xd64,static_cast<Bidi_Class>(0)},
{0xd66,Bidi_Class::L},
{0xd76,static_cast<Bidi_Class>(0)},
{0xd79,Bidi_Class::L},
{0xd80,static_cast<Bidi_Class>(0)},
{0xd82,Bidi_Class::L},
{0xd84,static_cast<Bidi_Class>(0)},
{0xd85,Bidi_Class::L},
{0xd97,static_cast<Bidi_Class>(0)},
{0xd9a,Bidi_Class::L},
{0xdb2,static_cast<Bidi_Class>(0)},
{0xdb3,Bidi_Class::L},
{0xdbc,static_cast<Bidi_Class>(0)},
{0xdbd,Bidi_Class::L},
{0xdbe,static_cast<Bidi_Class>(0)},
{0xdc0,Bidi_Class::L},
{0xdc7,static_cast<Bidi_Class>(0)},
{0xdca,Bidi_Class::NSM},
{0xdcb,static_cast<Bidi_Class>(0)},
{0xdcf,Bidi_Class::L},
{0xdd2,Bidi_Class::NSM},
{0xdd5,static_cast<Bidi_Class>(0)},
{0xdd6,Bidi_Class::NSM},
{0xdd7,static_cast<Bidi_Class>(0)},
{0xdd8,Bidi_Class::L},
{0xde0,static_cast<Bidi_Class>(0)},
{0xde6,Bidi_Class::L},
{0xdf0,static_cast<Bidi_Class>(0)},
{0xdf2,Bidi_Class::L},
{0xdf5,static_cast<Bidi_Class>(0)},
{0xe01,Bidi_Class::L},
{0xe31,Bidi_Class::NSM},
{0xe32,Bidi_Class::L},
{0xe34,Bidi_Class::NSM},
{0xe3b,static_cast<Bidi_Class>(0)},
{0xe3f,Bidi_Class::ET},
{0xe40,Bidi_Class::L},
{0xe47,Bidi_Class::NSM},
{0xe4f,Bidi_Class::L},
{0xe5c,static_cast<Bidi_Class>(0)},
{0xe81,Bidi_Class::L},
{0xe83,static_cast<Bidi_Class>(0)},
{0xe84,Bidi_Class::L},
{0xe85,static_cast<Bidi_Class>(0)},
{0xe87,Bidi_Class::L},
{0xe89,static_cast<Bidi_Class>(0)},
{0xe8a,Bidi_Class::L},
{0xe8b,static_cast<Bidi_Class>(0)},
{0xe8d,Bidi_Class::L},
{0xe8e,static_cast<Bidi_Class>(0)},
{0xe94,Bidi_Class::L},
{0xe98,static_cast<Bidi_Class>(0)},
{0xe99,Bidi_Class::L},
{0xea0,static_cast<Bidi_Class>(0)},
{0xea1,Bidi_Class::L},
{0xea4,static_cast<Bidi_Class>(0)},
{0xea5,Bidi_Class::L},
{0xea6,static_cast<Bidi_Class>(0)},
{0xea7,Bidi_Class::L},
{0xea8,static_cast<Bidi_Class>(0)},
{0xeaa,Bidi_Class::L},
{0xeac,static_cast<Bidi_Class>(0)},
{0xead,Bidi_Class::L},
{0xeb1,Bidi_Class::NSM},
{0xeb2,Bidi_Class::L},
{0xeb4,Bidi_Class::NSM},
{0xeba,static_cast<Bidi_Class>(0)},
{0xebb,Bidi_Class::NSM},
{0xebd,Bidi_Class::L},
{0xebe,static_cast<Bidi_Class>(0)},
{0xec0,Bidi_Class::L},
{0xec5,static_cast<Bidi_Class>(0)},
{0xec6,Bidi_Class::L},
{0xec7,static_cast<Bidi_Class>(0)},
{0xec8,Bidi_Class::NSM},
{0xece,static_cast<Bidi_Class>(0)},
{0xed0,Bidi_Class::L},
{0xeda,static_cast<Bidi_Class>(0)},
{0xedc,Bidi_Class::L},
{0xee0,static_cast<Bidi_Class>(0)},
{0xf00,Bidi_Class::L},
{0xf18,Bidi_Class::NSM},
{0xf1a,Bidi_Class::L},
{0xf35,Bidi_Class::NSM},
{0xf36,Bidi_Class::L},
{0xf37,Bidi_Class::NSM},
{0xf38,Bidi_Class::L},
{0xf39,Bidi_Class::NSM},
{0xf3a,Bidi_Class::ON},
{0xf3e,Bidi_Class::L},
{0xf48,static_cast<Bidi_Class>(0)},
{0xf49,Bidi_Class::L},
{0xf6d,static_cast<Bidi_Class>(0)},
{0xf71,Bidi_Class::NSM},
{0xf7f,Bidi_Class::L},
{0xf80,Bidi_Class::NSM},
{0xf85,Bidi_Class::L},
{0xf86,Bidi_Class::NSM},
{0xf88,Bidi_Class::L},
{0xf8d,Bidi_Class::NSM},
{0xf98,static_cast<Bidi_Class>(0)},
{0xf99,Bidi_Class::NSM},
{0xfbd,static_cast<Bidi_Class>(0)},
{0xfbe,Bidi_Class::L},
{0xfc6,Bidi_Class::NSM},
{0xfc7,Bidi_Class::L},
{0xfcd,static_cast<Bidi_Class>(0)},
{0xfce,Bidi_Class::L},
{0xfdb,static_cast<Bidi_Class>(0)},
{0x1000,Bidi_Class::L},
{0x102d,Bidi_Class::NSM},
{0x1031,Bidi_Class::L},
{0x1032,Bidi_Class::NSM},
{0x1038,Bidi_Class::L},
{0x1039,Bidi_Class::NSM},
{0x103b,Bidi_Class::L},
{0x103d,Bidi_Class::NSM},
{0x103f,Bidi_Class::L},
{0x1058,Bidi_Class::NSM},
{0x105a,Bidi_Class::L},
{0x105e,Bidi_Class::NSM},
{0x1061,Bidi_Class::L},
{0x1071,Bidi_Class::NSM},
{0x1075,Bidi_Class::L},
{0x1082,Bidi_Class::NSM},
{0x1083,Bidi_Class::L},
{0x1085,Bidi_Class::NSM},
{0x1087,Bidi_Class::L},
{0x108d,Bidi_Class::NSM},
{0x108e,Bidi_Class::L},
{0x109d,Bidi_Class::NSM},
{0x109e,Bidi_Class::L},
{0x10c6,static_cast<Bidi_Class>(0)},
{0x10c7,Bidi_Class::L},
{0x10c8,static_cast<Bidi_Class>(0)},
{0x10cd,Bidi_Class::L},
{0x10ce,static_cast<Bidi_Class>(0)},
{0x10d0,Bidi_Class::L},
{0x1249,static_cast<Bidi_Class>(0)},
{0x124a,Bidi_Class::L},
{0x124e,static_cast<Bidi_Class>(0)},
{0x1250,Bidi_Class::L},
{0x1257,static_cast<Bidi_Class>(0)},
{0x1258,Bidi_Class::L},
{0x1259,static_cast<Bidi_Class>(0)},
{0x125a,Bidi_Class::L},
{0x125e,static_cast<Bidi_Class>(0)},
{0x1260,Bidi_Class::L},
{0x1289,static_cast<Bidi_Class>(0)},
{0x128a,Bidi_Class::L},
{0x128e,static_cast<Bidi_Class>(0)},
{0x1290,Bidi_Class::L},
{0x12b1,static_cast<Bidi_Class>(0)},
{0x12b2,Bidi_Class::L},
{0x12b6,static_cast<Bidi_Class>(0)},
{0x12b8,Bidi_Class::L},
{0x12bf,static_cast<Bidi_Class>(0)},
{0x12c0,Bidi_Class::L},
{0x12c1,static_cast<Bidi_Class>(0)},
{0x12c2,Bidi_Class::L},
{0x12c6,static_cast<Bidi_Class>(0)},
{0x12c8,Bidi_Class::L},
{0x12d7,static_cast<Bidi_Class>(0)},
{0x12d8,Bidi_Class::L},
{0x1311,static_cast<Bidi_Class>(0)},
{0x1312,Bidi_Class::L},
{0x1316,static_cast<Bidi_Class>(0)},
{0x1318,Bidi_Class::L},
{0x135b,static_cast<Bidi_Class>(0)},
{0x135d,Bidi_Class::NSM},
{0x1360,Bidi_Class::L},
{0x137d,static_cast<Bidi_Class>(0)},
{0x1380,Bidi_Class::L},
{0x1390,Bidi_Class::ON},
{0x139a,static_cast<Bidi_Class>(0)},
{0x13a0,Bidi_Class::L},
{0x13f6,static_cast<Bidi_Class>(0)},
{0x13f8,Bidi_Class::L},
{0x13fe,static_cast<Bidi_Class>(0)},
{0x1400,Bidi_Class::ON},
{0x1401,Bidi_Class::L},
{0x1680,Bidi_Class::WS},
{0x1681,Bidi_Class::L},
{0x169b,Bidi_Class::ON},
{0x169d,static_cast<Bidi_Class>(0)},
{0x16a0,Bidi_Class::L},
{0x16f9,static_cast<Bidi_Class>(0)},
{0x1700,Bidi_Class::L},
{0x170d,static_cast<Bidi_Class>(0)},
{0x170e,Bidi_Class::L},
{0x1712,Bidi_Class::NSM},
{0x1715,static_cast<Bidi_Class>(0)},
{0x1720,Bidi_Class::L},
{0x1732,Bidi_Class::NSM},
{0x1735,Bidi_Class::L},
{0x1737,static_cast<Bidi_Class>(0)},
{0x1740,Bidi_Class::L},
{0x1752,Bidi_Class::NSM},
{0x1754,static_cast<Bidi_Class>(0)},
{0x1760,Bidi_Class::L},
{0x176d,static_cast<Bidi_Class>(0)},
{0x176e,Bidi_Class::L},
{0x1771,static_cast<Bidi_Class>(0)},
{0x1772,Bidi_Class::NSM},
{0x1774,static_cast<Bidi_Class>(0)},
{0x1780,Bidi_Class::L},
{0x17b4,Bidi_Class::NSM},
{0x17b6,Bidi_Class::L},
{0x17b7,Bidi_Class::NSM},
{0x17be,Bidi_Class::L},
{0x17c6,Bidi_Class::NSM},
{0x17c7,Bidi_Class::L},
{0x17c9,Bidi_Class::NSM},
{0x17d4,Bidi_Class::L},
{0x17db,Bidi_Class::ET},
{0x17dc,Bidi_Class::L},
{0x17dd,Bidi_Class::NSM},
{0x17de,static_cast<Bidi_Class>(0)},
{0x17e0,Bidi_Class::L},
{0x17ea,static_cast<Bidi_Class>(0)},
{0x17f0,Bidi_Class::ON},
{0x17fa,static_cast<Bidi_Class>(0)},
{0x1800,Bidi_Class::ON},
{0x180b,Bidi_Class::NSM},
{0x180e,Bidi_Class::BN},
{0x180f,static_cast<Bidi_Class>(0)},
{0x1810,Bidi_Class::L},
{0x181a,static_cast<Bidi_Class>(0)},
{0x1820,Bidi_Class::L},
{0x1878,static_cast<Bidi_Class>(0)},
{0x1880,Bidi_Class::L},
{0x18a9,Bidi_Class::NSM},
{0x18aa,Bidi_Class::L},
{0x18ab,static_cast<Bidi_Class>(0)},
{0x18b0,Bidi_Class::L},
{0x18f6,static_cast<Bidi_Class>(0)},
{0x1900,Bidi_Class::L},
{0x191f,static_cast<Bidi_Class>(0)},
{0x1920,Bidi_Class::NSM},
{0x1923,Bidi_Class::L},
{0x1927,Bidi_Class::NSM},
{0x1929,Bidi_Class::L},
{0x192c,static_cast<Bidi_Class>(0)},
{0x1930,Bidi_Class::L},
{0x1932,Bidi_Class::NSM},
{0x1933,Bidi_Class::L},
{0x1939,Bidi_Class::NSM},
{0x193c,static_cast<Bidi_Class>(0)},
{0x1940,Bidi_Class::ON},
{0x1941,static_cast<Bidi_Class>(0)},
{0x1944,Bidi_Class::ON},
{0x1946,Bidi_Class::L},
{0x196e,static_cast<Bidi_Class>(0)},
{0x1970,Bidi_Class::L},
{0x1975,static_cast<Bidi_Class>(0)},
{0x1980,Bidi_Class::L},
{0x19ac,static_cast<Bidi_Class>(0)},
{0x19b0,Bidi_Class::L},
{0x19ca,static_cast<Bidi_Class>(0)},
{0x19d0,Bidi_Class::L},
{0x19db,static_cast<Bidi_Class>(0)},
{0x19de,Bidi_Class::ON},
{0x1a00,Bidi_Class::L},
{0x1a17,Bidi_Class::NSM},
{0x1a19,Bidi_Class::L},
{0x1a1b,Bidi_Class::NSM},
{0x1a1c,static_cast<Bidi_Class>(0)},
{0x1a1e,Bidi_Class::L},
{0x1a56,Bidi_Class::NSM},
{0x1a57,Bidi_Class::L},
{0x1a58,Bidi_Class::NSM},
{0x1a5f,static_cast<Bidi_Class>(0)},
{0x1a60,Bidi_Class::NSM},
{0x1a61,Bidi_Class::L},
{0x1a62,Bidi_Class::NSM},
{0x1a63,Bidi_Class::L},
{0x1a65,Bidi_Class::NSM},
{0x1a6d,Bidi_Class::L},
{0x1a73,Bidi_Class::NSM},
{0x1a7d,static_cast<Bidi_Class>(0)},
{0x1a7f,Bidi_Class::NSM},
{0x1a80,Bidi_Class::L},
{0x1a8a,static_cast<Bidi_Class>(0)},
{0x1a90,Bidi_Class::L},
{0x1a9a,static_cast<Bidi_Class>(0)},
{0x1aa0,Bidi_Class::L},
{0x1aae,static_cast<Bidi_Class>(0)},
{0x1ab0,Bidi_Class::NSM},
{0x1abf,static_cast<Bidi_Class>(0)},
{0x1b00,Bidi_Class::NSM},
{0x1b04,Bidi_Class::L},
{0x1b34,Bidi_Class::NSM},
{0x1b35,Bidi_Class::L},
{0x1b36,Bidi_Class::NSM},
{0x1b3b,Bidi_Class::L},
{0x1b3c,Bidi_Class::NSM},
{0x1b3d,Bidi_Class::L},
{0x1b42,Bidi_Class::NSM},
{0x1b43,Bidi_Class::L},
{0x1b4c,static_cast<Bidi_Class>(0)},
{0x1b50,Bidi_Class::L},
{0x1b6b,Bidi_Class::NSM},
{0x1b74,Bidi_Class::L},
{0x1b7d,static_cast<Bidi_Class>(0)},
{0x1b80,Bidi_Class::NSM},
{0x1b82,Bidi_Class::L},
{0x1ba2,Bidi_Class::NSM},
{0x1ba6,Bidi_Class::L},
{0x1ba8,Bidi_Class::NSM},
{0x1baa,Bidi_Class::L},
{0x1bab,Bidi_Class::NSM},
{0x1bae,Bidi_Class::L},
{0x1be6,Bidi_Class::NSM},
{0x1be7,Bidi_Class::L},
{0x1be8,Bidi_Class::NSM},
{0x1bea,Bidi_Class::L},
{0x1bed,Bidi_Class::NSM},
{0x1bee,Bidi_Class::L},
{0x1bef,Bidi_Class::NSM},
{0x1bf2,Bidi_Class::L},
{0x1bf4,static_cast<Bidi_Class>(0)},
{0x1bfc,Bidi_Class::L},
{0x1c2c,Bidi_Class::NSM},
{0x1c34,Bidi_Class::L},
{0x1c36,Bidi_Class::NSM},
{0x1c38,static_cast<Bidi_Class>(0)},
{0x1c3b,Bidi_Class::L},
{0x1c4a,static_cast<Bidi_Class>(0)},
{0x1c4d,Bidi_Class::L},
{0x1c80,static_cast<Bidi_Class>(0)},
{0x1cc0,Bidi_Class::L},
{0x1cc8,static_cast<Bidi_Class>(0)},
{0x1cd0,Bidi_Class::NSM},
{0x1cd3,Bidi_Class::L},
{0x1cd4,Bidi_Class::NSM},
{0x1ce1,Bidi_Class::L},
{0x1ce2,Bidi_Class::NSM},
{0x1ce9,Bidi_Class::L},
{0x1ced,Bidi_Class::NSM},
{0x1cee,Bidi_Class::L},
{0x1cf4,Bidi_Class::NSM},
{0x1cf5,Bidi_Class::L},
{0x1cf7,static_cast<Bidi_Class>(0)},
{0x1cf8,Bidi_Class::NSM},
{0x1cfa,static_cast<Bidi_Class>(0)},
{0x1d00,Bidi_Class::L},
{0x1dc0,Bidi_Class::NSM},
{0x1df6,static_cast<Bidi_Class>(0)},
{0x1dfc,Bidi_Class::NSM},
{0x1e00,Bidi_Class::L},
{0x1f16,static_cast<Bidi_Class>(0)},
{0x1f18,Bidi_Class::L},
{0x1f1e,static_cast<Bidi_Class>(0)},
{0x1f20,Bidi_Class::L},
{0x1f46,static_cast<Bidi_Class>(0)},
{0x1f48,Bidi_Class::L},
{0x1f4e,static_cast<Bidi_Class>(0)},
{0x1f50,Bidi_Class::L},
{0x1f58,static_cast<Bidi_Class>(0)},
{0x1f59,Bidi_Class::L},
{0x1f5a,static_cast<Bidi_Class>(0)},
{0x1f5b,Bidi_Class::L},
{0x1f5c,static_cast<Bidi_Class>(0)},
{0x1f5d,Bidi_Class::L},
{0x1f5e,static_cast<Bidi_Class>(0)},
{0x1f5f,Bidi_Class::L},
{0x1f7e,static_cast<Bidi_Class>(0)},
{0x1f80,Bidi_Class::L},
{0x1fb5,static_cast<Bidi_Class>(0)},
{0x1fb6,Bidi_Class::L},
{0x1fbd,Bidi_Class::ON},
{0x1fbe,Bidi_Class::L},
{0x1fbf,Bidi_Class::ON},
{0x1fc2,Bidi_Class::L},
{0x1fc5,static_cast<Bidi_Class>(0)},
{0x1fc6,Bidi_Class::L},
{0x1fcd,Bidi_Class::ON},
{0x1fd0,Bidi_Class::L},
{0x1fd4,static_cast<Bidi_Class>(0)},
{0x1fd6,Bidi_Class::L},
{0x1fdc,static_cast<Bidi_Class>(0)},
{0x1fdd,Bidi_Class::ON},
{0x1fe0,Bidi_Class::L},
{0x1fed,Bidi_Class::ON},
{0x1ff0,static_cast<Bidi_Class>(0)},
{0x1ff2,Bidi_Class::L},
{0x1ff5,static_cast<Bidi_Class>(0)},
{0x1ff6,Bidi_Class::L},
{0x1ffd,Bidi_Class::ON},
{0x1fff,static_cast<Bidi_Class>(0)},
{0x2000,Bidi_Class::WS},
{0x200b,Bidi_Class::BN},
{0x200e,Bidi_Class::L},
{0x200f,Bidi_Class::R},
{0x2010,Bidi_Class::ON},
{0x2028,Bidi_Class::WS},
{0x2029,Bidi_Class::B},
{0x202a,Bidi_Class::LRE},
{0x202b,Bidi_Class::RLE},
{0x202c,Bidi_Class::PDF},
{0x202d,Bidi_Class::LRO},
{0x202e,Bidi_Class::RLO},
{0x202f,Bidi_Class::CS},
{0x2030,Bidi_Class::ET},
{0x2035,Bidi_Class::ON},
{0x2044,Bidi_Class::CS},
{0x2045,Bidi_Class::ON},
{0x205f,Bidi_Class::WS},
{0x2060,Bidi_Class::BN},
{0x2065,static_cast<Bidi_Class>(0)},
{0x2066,Bidi_Class::LRI},
{0x2067,Bidi_Class::RLI},
{0x2068,Bidi_Class::FSI},
{0x2069,Bidi_Class::PDI},
{0x206a,Bidi_Class::BN},
{0x2070,Bidi_Class::EN},
{0x2071,Bidi_Class::L},
{0x2072,static_cast<Bidi_Class>(0)},
{0x2074,Bidi_Class::EN},
{0x207a,Bidi_Class::ES},
{0x207c,Bidi_Class::ON},
{0x207f,Bidi_Class::L},
{0x2080,Bidi_Class::EN},
{0x208a,Bidi_Class::ES},
{0x208c,Bidi_Class::ON},
{0x208f,static_cast<Bidi_Class>(0)},
{0x2090,Bidi_Class::L},
{0x209d,static_cast<Bidi_Class>(0)},
{0x20a0,Bidi_Class::ET},
{0x20bf,static_cast<Bidi_Class>(0)},
{0x20d0,Bidi_Class::NSM},
{0x20f1,static_cast<Bidi_Class>(0)},
{0x2100,Bidi_Class::ON},
{0x2102,Bidi_Class::L},
{0x2103,Bidi_Class::ON},
{0x2107,Bidi_Class::L},
{0x2108,Bidi_Class::ON},
{0x210a,Bidi_Class::L},
{0x2114,Bidi_Class::ON},
{0x2115,Bidi_Class::L},
{0x2116,Bidi_Class::ON},
{0x2119,Bidi_Class::L},
{0x211e,Bidi_Class::ON},
{0x2124,Bidi_Class::L},
{0x2125,Bidi_Class::ON},
{0x2126,Bidi_Class::L},
{0x2127,Bidi_Class::ON},
{0x2128,Bidi_Class::L},
{0x2129,Bidi_Class::ON},
{0x212a,Bidi_Class::L},
{0x212e,Bidi_Class::ET},
{0x212f,Bidi_Class::L},
{0x213a,Bidi_Class::ON},
{0x213c,Bidi_Class::L},
{0x2140,Bidi_Class::ON},
{0x2145,Bidi_Class::L},
{0x214a,Bidi_Class::ON},
{0x214e,Bidi_Class::L},
{0x2150,Bidi_Class::ON},
{0x2160,Bidi_Class::L},
{0x2189,Bidi_Class::ON},
{0x218c,static_cast<Bidi_Class>(0)},
{0x2190,Bidi_Class::ON},
{0x2212,Bidi_Class::ES},
{0x2213,Bidi_Class::ET},
{0x2214,Bidi_Class::ON},
{0x2336,Bidi_Class::L},
{0x237b,Bidi_Class::ON},
{0x2395,Bidi_Class::L},
{0x2396,Bidi_Class::ON},
{0x23fb,static_cast<Bidi_Class>(0)},
{0x2400,Bidi_Class::ON},
{0x2427,static_cast<Bidi_Class>(0)},
{0x2440,Bidi_Class::ON},
{0x244b,static_cast<Bidi_Class>(0)},
{0x2460,Bidi_Class::ON},
{0x2488,Bidi_Class::EN},
{0x249c,Bidi_Class::L},
{0x24ea,Bidi_Class::ON},
{0x26ac,Bidi_Class::L},
{0x26ad,Bidi_Class::ON},
{0x2800,Bidi_Class::L},
{0x2900,Bidi_Class::ON},
{0x2b74,static_cast<Bidi_Class>(0)},
{0x2b76,Bidi_Class::ON},
{0x2b96,static_cast<Bidi_Class>(0)},
{0x2b98,Bidi_Class::ON},
{0x2bba,static_cast<Bidi_Class>(0)},
{0x2bbd,Bidi_Class::ON},
{0x2bc9,static_cast<Bidi_Class>(0)},
{0x2bca,Bidi_Class::ON},
{0x2bd2,static_cast<Bidi_Class>(0)},
{0x2bec,Bidi_Class::ON},
{0x2bf0,static_cast<Bidi_Class>(0)},
{0x2c00,Bidi_Class::L},
{0x2c2f,static_cast<Bidi_Class>(0)},
{0x2c30,Bidi_Class::L},
{0x2c5f,static_cast<Bidi_Class>(0)},
{0x2c60,Bidi_Class::L},
{0x2ce5,Bidi_Class::ON},
{0x2ceb,Bidi_Class::L},
{0x2cef,Bidi_Class::NSM},
{0x2cf2,Bidi_Class::L},
{0x2cf4,static_cast<Bidi_Class>(0)},
{0x2cf9,Bidi_Class::ON},
{0x2d00,Bidi_Class::L},
{0x2d26,static_cast<Bidi_Class>(0)},
{0x2d27,Bidi_Class::L},
{0x2d28,static_cast<Bidi_Class>(0)},
{0x2d2d,Bidi_Class::L},
{0x2d2e,static_cast<Bidi_Class>(0)},
{0x2d30,Bidi_Class::L},
{0x2d68,static_cast<Bidi_Class>(0)},
{0x2d6f,Bidi_Class::L},
{0x2d71,static_cast<Bidi_Class>(0)},
{0x2d7f,Bidi_Class::NSM},
{0x2d80,Bidi_Class::L},
{0x2d97,static_cast<Bidi_Class>(0)},
{0x2da0,Bidi_Class::L},
{0x2da7,static_cast<Bidi_Class>(0)},
{0x2da8,Bidi_Class::L},
{0x2daf,static_cast<Bidi_Class>(0)},
{0x2db0,Bidi_Class::L},
{0x2db7,static_cast<Bidi_Class>(0)},
{0x2db8,Bidi_Class::L},
{0x2dbf,static_cast<Bidi_Class>(0)},
{0x2dc0,Bidi_Class::L},
{0x2dc7,static_cast<Bidi_Class>(0)},
{0x2dc8,Bidi_Class::L},
{0x2dcf,static_cast<Bidi_Class>(0)},
{0x2dd0,Bidi_Class::L},
{0x2dd7,static_cast<Bidi_Class>(0)},
{0x2dd8,Bidi_Class::L},
{0x2ddf,static_cast<Bidi_Class>(0)},
{0x2de0,Bidi_Class::NSM},
{0x2e00,Bidi_Class::ON},
{0x2e43,static_cast<Bidi_Class>(0)},
{0x2e80,Bidi_Class::ON},
{0x2e9a,static_cast<Bidi_Class>(0)},
{0x2e9b,Bidi_Class::ON},
{0x2ef4,static_cast<Bidi_Class>(0)},
{0x2f00,Bidi_Class::ON},
{0x2fd6,static_cast<Bidi_Class>(0)},
{0x2ff0,Bidi_Class::ON},
{0x2ffc,static_cast<Bidi_Class>(0)},
{0x3000,Bidi_Class::WS},
{0x3001,Bidi_Class::ON},
{0x3005,Bidi_Class::L},
{0x3008,Bidi_Class::ON},
{0x3021,Bidi_Class::L},
{0x302a,Bidi_Class::NSM},
{0x302e,Bidi_Class::L},
{0x3030,Bidi_Class::ON},
{0x3031,Bidi_Class::L},
{0x3036,Bidi_Class::ON},
{0x3038,Bidi_Class::L},
{0x303d,Bidi_Class::ON},
{0x3040,static_cast<Bidi_Class>(0)},
{0x3041,Bidi_Class::L},
{0x3097,static_cast<Bidi_Class>(0)},
{0x3099,Bidi_Class::NSM},
{0x309b,Bidi_Class::ON},
{0x309d,Bidi_Class::L},
{0x30a0,Bidi_Class::ON},
{0x30a1,Bidi_Class::L},
{0x30fb,Bidi_Class::ON},
{0x30fc,Bidi_Class::L},
{0x3100,static_cast<Bidi_Class>(0)},
{0x3105,Bidi_Class::L},
{0x312e,static_cast<Bidi_Class>(0)},
{0x3131,Bidi_Class::L},
{0x318f,static_cast<Bidi_Class>(0)},
{0x3190,Bidi_Class::L},
{0x31bb,static_cast<Bidi_Class>(0)},
{0x31c0,Bidi_Class::ON},
{0x31e4,static_cast<Bidi_Class>(0)},
{0x31f0,Bidi_Class::L},
{0x321d,Bidi_Class::ON},
{0x321f,static_cast<Bidi_Class>(0)},
{0x3220,Bidi_Class::L},
{0x3250,Bidi_Class::ON},
{0x3260,Bidi_Class::L},
{0x327c,Bidi_Class::ON},
{0x327f,Bidi_Class::L},
{0x32b1,Bidi_Class::ON},
{0x32c0,Bidi_Class::L},
{0x32cc,Bidi_Class::ON},
{0x32d0,Bidi_Class::L},
{0x32ff,static_cast<Bidi_Class>(0)},
{0x3300,Bidi_Class::L},
{0x3377,Bidi_Class::ON},
{0x337b,Bidi_Class::L},
{0x33de,Bidi_Class::ON},
{0x33e0,Bidi_Class::L},
{0x33ff,Bidi_Class::ON},
{0x3400,Bidi_Class::L},
{0x4db6,static_cast<Bidi_Class>(0)},
{0x4dc0,Bidi_Class::ON},
{0x4e00,Bidi_Class::L},
{0x9fd6,static_cast<Bidi_Class>(0)},
{0xa000,Bidi_Class::L},
{0xa48d,static_cast<Bidi_Class>(0)},
{0xa490,Bidi_Class::ON},
{0xa4c7,static_cast<Bidi_Class>(0)},
{0xa4d0,Bidi_Class::L},
{0xa60d,Bidi_Class::ON},
{0xa610,Bidi_Class::L},
{0xa62c,static_cast<Bidi_Class>(0)},
{0xa640,Bidi_Class::L},
{0xa66f,Bidi_Class::NSM},
{0xa673,Bidi_Class::ON},
{0xa674,Bidi_Class::NSM},
{0xa67e,Bidi_Class::ON},
{0xa680,Bidi_Class::L},
{0xa69e,Bidi_Class::NSM},
{0xa6a0,Bidi_Class::L},
{0xa6f0,Bidi_Class::NSM},
{0xa6f2,Bidi_Class::L},
{0xa6f8,static_cast<Bidi_Class>(0)},
{0xa700,Bidi_Class::ON},
{0xa722,Bidi_Class::L},
{0xa788,Bidi_Class::ON},
{0xa789,Bidi_Class::L},
{0xa7ae,static_cast<Bidi_Class>(0)},
{0xa7b0,Bidi_Class::L},
{0xa7b8,static_cast<Bidi_Class>(0)},
{0xa7f7,Bidi_Class::L},
{0xa802,Bidi_Class::NSM},
{0xa803,Bidi_Class::L},
{0xa806,Bidi_Class::NSM},
{0xa807,Bidi_Class::L},
{0xa80b,Bidi_Class::NSM},
{0xa80c,Bidi_Class::L},
{0xa825,Bidi_Class::NSM},
{0xa827,Bidi_Class::L},
{0xa828,Bidi_Class::ON},
{0xa82c,static_cast<Bidi_Class>(0)},
{0xa830,Bidi_Class::L},
{0xa838,Bidi_Class::ET},
{0xa83a,static_cast<Bidi_Class>(0)},
{0xa840,Bidi_Class::L},
{0xa874,Bidi_Class::ON},
{0xa878,static_cast<Bidi_Class>(0)},
{0xa880,Bidi_Class::L},
{0xa8c4,Bidi_Class::NSM},
{0xa8c5,static_cast<Bidi_Class>(0)},
{0xa8ce,Bidi_Class::L},
{0xa8da,static_cast<Bidi_Class>(0)},
{0xa8e0,Bidi_Class::NSM},
{0xa8f2,Bidi_Class::L},
{0xa8fe,static_cast<Bidi_Class>(0)},
{0xa900,Bidi_Class::L},
{0xa926,Bidi_Class::NSM},
{0xa92e,Bidi_Class::L},
{0xa947,Bidi_Class::NSM},
{0xa952,Bidi_Class::L},
{0xa954,static_cast<Bidi_Class>(0)},
{0xa95f,Bidi_Class::L},
{0xa97d,static_cast<Bidi_Class>(0)},
{0xa980,Bidi_Class::NSM},
{0xa983,Bidi_Class::L},
{0xa9b3,Bidi_Class::NSM},
{0xa9b4,Bidi_Class::L},
{0xa9b6,Bidi_Class::NSM},
{0xa9ba,Bidi_Class::L},
{0xa9bc,Bidi_Class::NSM},
{0xa9bd,Bidi_Class::L},
{0xa9ce,static_cast<Bidi_Class>(0)},
{0xa9cf,Bidi_Class::L},
{0xa9da,static_cast<Bidi_Class>(0)},
{0xa9de,Bidi_Class::L},
{0xa9e5,Bidi_Class::NSM},
{0xa9e6,Bidi_Class::L},
{0xa9ff,static_cast<Bidi_Class>(0)},
{0xaa00,Bidi_Class::L},
{0xaa29,Bidi_Class::NSM},
{0xaa2f,Bidi_Class::L},
{0xaa31,Bidi_Class::NSM},
{0xaa33,Bidi_Class::L},
{0xaa35,Bidi_Class::NSM},
{0xaa37,static_cast<Bidi_Class>(0)},
{0xaa40,Bidi_Class::L},
{0xaa43,Bidi_Class::NSM},
{0xaa44,Bidi_Class::L},
{0xaa4c,Bidi_Class::NSM},
{0xaa4d,Bidi_Class::L},
{0xaa4e,static_cast<Bidi_Class>(0)},
{0xaa50,Bidi_Class::L},
{0xaa5a,static_cast<Bidi_Class>(0)},
{0xaa5c,Bidi_Class::L},
{0xaa7c,Bidi_Class::NSM},
{0xaa7d,Bidi_Class::L},
{0xaab0,Bidi_Class::NSM},
{0xaab1,Bidi_Class::L},
{0xaab2,Bidi_Class::NSM},
{0xaab5,Bidi_Class::L},
{0xaab7,Bidi_Class::NSM},
{0xaab9,Bidi_Class::L},
{0xaabe,Bidi_Class::NSM},
{0xaac0,Bidi_Class::L},
{0xaac1,Bidi_Class::NSM},
{0xaac2,Bidi_Class::L},
{0xaac3,static_cast<Bidi_Class>(0)},
{0xaadb,Bidi_Class::L},
{0xaaec,Bidi_Class::NSM},
{0xaaee,Bidi_Class::L},
{0xaaf6,Bidi_Class::NSM},
{0xaaf7,static_cast<Bidi_Class>(0)},
{0xab01,Bidi_Class::L},
{0xab07,static_cast<Bidi_Class>(0)},
{0xab09,Bidi_Class::L},
{0xab0f,static_cast<Bidi_Class>(0)},
{0xab11,Bidi_Class::L},
{0xab17,static_cast<Bidi_Class>(0)},
{0xab20,Bidi_Class::L},
{0xab27,static_cast<Bidi_Class>(0)},
{0xab28,Bidi_Class::L},
{0xab2f,static_cast<Bidi_Class>(0)},
{0xab30,Bidi_Class::L},
{0xab66,static_cast<Bidi_Class>(0)},
{0xab70,Bidi_Class::L},
{0xabe5,Bidi_Class::NSM},
{0xabe6,Bidi_Class::L},
{0xabe8,Bidi_Class::NSM},
{0xabe9,Bidi_Class::L},
{0xabed,Bidi_Class::NSM},
{0xabee,static_cast<Bidi_Class>(0)},
{0xabf0,Bidi_Class::L},
{0xabfa,static_cast<Bidi_Class>(0)},
{0xac00,Bidi_Class::L},
{0xd7a4,static_cast<Bidi_Class>(0)},
{0xd7b0,Bidi_Class::L},
{0xd7c7,static_cast<Bidi_Class>(0)},
{0xd7cb,Bidi_Class::L},
{0xd7fc,static_cast<Bidi_Class>(0)},
{0xd800,Bidi_Class::L},
{0xfa6e,static_cast<Bidi_Class>(0)},
{0xfa70,Bidi_Class::L},
{0xfada,static_cast<Bidi_Class>(0)},
{0xfb00,Bidi_Class::L},
{0xfb07,static_cast<Bidi_Class>(0)},
{0xfb13,Bidi_Class::L},
{0xfb18,static_cast<Bidi_Class>(0)},
{0xfb1d,Bidi_Class::R},
{0xfb1e,Bidi_Class::NSM},
{0xfb1f,Bidi_Class::R},
{0xfb29,Bidi_Class::ES},
{0xfb2a,Bidi_Class::R},
{0xfb37,static_cast<Bidi_Class>(0)},
{0xfb38,Bidi_Class::R},
{0xfb3d,static_cast<Bidi_Class>(0)},
{0xfb3e,Bidi_Class::R},
{0xfb3f,static_cast<Bidi_Class>(0)},
{0xfb40,Bidi_Class::R},
{0xfb42,static_cast<Bidi_Class>(0)},
{0xfb43,Bidi_Class::R},
{0xfb45,static_cast<Bidi_Class>(0)},
{0xfb46,Bidi_Class::R},
{0xfb50,Bidi_Class::AL},
{0xfbc2,static_cast<Bidi_Class>(0)},
{0xfbd3,Bidi_Class::AL},
{0xfd3e,Bidi_Class::ON},
{0xfd40,static_cast<Bidi_Class>(0)},
{0xfd50,Bidi_Class::AL},
{0xfd90,static_cast<Bidi_Class>(0)},
{0xfd92,Bidi_Class::AL},
{0xfdc8,static_cast<Bidi_Class>(0)},
{0xfdf0,Bidi_Class::AL},
{0xfdfd,Bidi_Class::ON},
{0xfdfe,static_cast<Bidi_Class>(0)},
{0xfe00,Bidi_Class::NSM},
{0xfe10,Bidi_Class::ON},
{0xfe1a,static_cast<Bidi_Class>(0)},
{0xfe20,Bidi_Class::NSM},
{0xfe30,Bidi_Class::ON},
{0xfe50,Bidi_Class::CS},
{0xfe51,Bidi_Class::ON},
{0xfe52,Bidi_Class::CS},
{0xfe53,static_cast<Bidi_Class>(0)},
{0xfe54,Bidi_Class::ON},
{0xfe55,Bidi_Class::CS},
{0xfe56,Bidi_Class::ON},
{0xfe5f,Bidi_Class::ET},
{0xfe60,Bidi_Class::ON},
{0xfe62,Bidi_Class::ES},
{0xfe64,Bidi_Class::ON},
{0xfe67,static_cast<Bidi_Class>(0)},
{0xfe68,Bidi_Class::ON},
{0xfe69,Bidi_Class::ET},
{0xfe6b,Bidi_Class::ON},
{0xfe6c,static_cast<Bidi_Class>(0)},
{0xfe70,Bidi_Class::AL},
{0xfe75,static_cast<Bidi_Class>(0)},
{0xfe76,Bidi_Class::AL},
{0xfefd,static_cast<Bidi_Class>(0)},
{0xfeff,Bidi_Class::BN},
{0xff00,static_cast<Bidi_Class>(0)},
{0xff01,Bidi_Class::ON},
{0xff03,Bidi_Class::ET},
{0xff06,Bidi_Class::ON},
{0xff0b,Bidi_Class::ES},
{0xff0c,Bidi_Class::CS},
{0xff0d,Bidi_Class::ES},
{0xff0e,Bidi_Class::CS},
{0xff10,Bidi_Class::EN},
{0xff1a,Bidi_Class::CS},
{0xff1b,Bidi_Class::ON},
{0xff21,Bidi_Class::L},
{0xff3b,Bidi_Class::ON},
{0xff41,Bidi_Class::L},
{0xff5b,Bidi_Class::ON},
{0xff66,Bidi_Class::L},
{0xffbf,static_cast<Bidi_Class>(0)},
{0xffc2,Bidi_Class::L},
{0xffc8,static_cast<Bidi_Class>(0)},
{0xffca,Bidi_Class::L},
{0xffd0,static_cast<Bidi_Class>(0)},
{0xffd2,Bidi_Class::L},
{0xffd8,static_cast<Bidi_Class>(0)},
{0xffda,Bidi_Class::L},
{0xffdd,static_cast<Bidi_Class>(0)},
{0xffe0,Bidi_Class::ET},
{0xffe2,Bidi_Class::ON},
{0xffe5,Bidi_Class::ET},
{0xffe7,static_cast<Bidi_Class>(0)},
{0xffe8,Bidi_Class::ON},
{0xffef,static_cast<Bidi_Class>(0)},
{0xfff9,Bidi_Class::ON},
{0xfffe,static_cast<Bidi_Class>(0)},
{0x10000,Bidi_Class::L},
{0x1000c,static_cast<Bidi_Class>(0)},
{0x1000d,Bidi_Class::L},
{0x10027,static_cast<Bidi_Class>(0)},
{0x10028,Bidi_Class::L},
{0x1003b,static_cast<Bidi_Class>(0)},
{0x1003c,Bidi_Class::L},
{0x1003e,static_cast<Bidi_Class>(0)},
{0x1003f,Bidi_Class::L},
{0x1004e,static_cast<Bidi_Class>(0)},
{0x10050,Bidi_Class::L},
{0x1005e,static_cast<Bidi_Class>(0)},
{0x10080,Bidi_Class::L},
{0x100fb,static_cast<Bidi_Class>(0)},
{0x10100,Bidi_Class::L},
{0x10101,Bidi_Class::ON},
{0x10102,Bidi_Class::L},
{0x10103,static_cast<Bidi_Class>(0)},
{0x10107,Bidi_Class::L},
{0x10134,static_cast<Bidi_Class>(0)},
{0x10137,Bidi_Class::L},
{0x10140,Bidi_Class::ON},
{0x1018d,static_cast<Bidi_Class>(0)},
{0x10190,Bidi_Class::ON},
{0x1019c,static_cast<Bidi_Class>(0)},
{0x101a0,Bidi_Class::ON},
{0x101a1,static_cast<Bidi_Class>(0)},
{0x101d0,Bidi_Class::L},
{0x101fd,Bidi_Class::NSM},
{0x101fe,static_cast<Bidi_Class>(0)},
{0x10280,Bidi_Class::L},
{0x1029d,static_cast<Bidi_Class>(0)},
{0x102a0,Bidi_Class::L},
{0x102d1,static_cast<Bidi_Class>(0)},
{0x102e0,Bidi_Class::NSM},
{0x102e1,Bidi_Class::EN},
{0x102fc,static_cast<Bidi_Class>(0)},
{0x10300,Bidi_Class::L},
{0x10324,static_cast<Bidi_Class>(0)},
{0x10330,Bidi_Class::L},
{0x1034b,static_cast<Bidi_Class>(0)},
{0x10350,Bidi_Class::L},
{0x10376,Bidi_Class::NSM},
{0x1037b,static_cast<Bidi_Class>(0)},
{0x10380,Bidi_Class::L},
{0x1039e,static_cast<Bidi_Class>(0)},
{0x1039f,Bidi_Class::L},
{0x103c4,static_cast<Bidi_Class>(0)},
{0x103c8,Bidi_Class::L},
{0x103d6,static_cast<Bidi_Class>(0)},
{0x10400,Bidi_Class::L},
{0x1049e,static_cast<Bidi_Class>(0)},
{0x104a0,Bidi_Class::L},
{0x104aa,static_cast<Bidi_Class>(0)},
{0x10500,Bidi_Class::L},
{0x10528,static_cast<Bidi_Class>(0)},
{0x10530,Bidi_Class::L},
{0x10564,static_cast<Bidi_Class>(0)},
{0x1056f,Bidi_Class::L},
{0x10570,static_cast<Bidi_Class>(0)},
{0x10600,Bidi_Class::L},
{0x10737,static_cast<Bidi_Class>(0)},
{0x10740,Bidi_Class::L},
{0x10756,static_cast<Bidi_Class>(0)},
{0x10760,Bidi_Class::L},
{0x10768,static_cast<Bidi_Class>(0)},
{0x10800,Bidi_Class::R},
{0x10806,static_cast<Bidi_Class>(0)},
{0x10808,Bidi_Class::R},
{0x10809,static_cast<Bidi_Class>(0)},
{0x1080a,Bidi_Class::R},
{0x10836,static_cast<Bidi_Class>(0)},
{0x10837,Bidi_Class::R},
{0x10839,static_cast<Bidi_Class>(0)},
{0x1083c,Bidi_Class::R},
{0x1083d,static_cast<Bidi_Class>(0)},
{0x1083f,Bidi_Class::R},
{0x10856,static_cast<Bidi_Class>(0)},
{0x10857,Bidi_Class::R},
{0x1089f,static_cast<Bidi_Class>(0)},
{0x108a7,Bidi_Class::R},
{0x108b0,static_cast<Bidi_Class>(0)},
{0x108e0,Bidi_Class::R},
{0x108f3,static_cast<Bidi_Class>(0)},
{0x108f4,Bidi_Class::R},
{0x108f6,static_cast<Bidi_Class>(0)},
{0x108fb,Bidi_Class::R},
{0x1091c,static_cast<Bidi_Class>(0)},
{0x1091f,Bidi_Class::ON},
{0x10920,Bidi_Class::R},
{0x1093a,static_cast<Bidi_Class>(0)},
{0x1093f,Bidi_Class::R},
{0x10940,static_cast<Bidi_Class>(0)},
{0x10980,Bidi_Class::R},
{0x109b8,static_cast<Bidi_Class>(0)},
{0x109bc,Bidi_Class::R},
{0x109d0,static_cast<Bidi_Class>(0)},
{0x109d2,Bidi_Class::R},
{0x10a01,Bidi_Class::NSM},
{0x10a04,static_cast<Bidi_Class>(0)},
{0x10a05,Bidi_Class::NSM},
{0x10a07,static_cast<Bidi_Class>(0)},
{0x10a0c,Bidi_Class::NSM},
{0x10a10,Bidi_Class::R},
{0x10a14,static_cast<Bidi_Class>(0)},
{0x10a15,Bidi_Class::R},
{0x10a18,static_cast<Bidi_Class>(0)},
{0x10a19,Bidi_Class::R},
{0x10a34,static_cast<Bidi_Class>(0)},
{0x10a38,Bidi_Class::NSM},
{0x10a3b,static_cast<Bidi_Class>(0)},
{0x10a3f,Bidi_Class::NSM},
{0x10a40,Bidi_Class::R},
{0x10a48,static_cast<Bidi_Class>(0)},
{0x10a50,Bidi_Class::R},
{0x10a59,static_cast<Bidi_Class>(0)},
{0x10a60,Bidi_Class::R},
{0x10aa0,static_cast<Bidi_Class>(0)},
{0x10ac0,Bidi_Class::R},
{0x10ae5,Bidi_Class::NSM},
{0x10ae7,static_cast<Bidi_Class>(0)},
{0x10aeb,Bidi_Class::R},
{0x10af7,static_cast<Bidi_Class>(0)},
{0x10b00,Bidi_Class::R},
{0x10b36,static_cast<Bidi_Class>(0)},
{0x10b39,Bidi_Class::ON},
{0x10b40,Bidi_Class::R},
{0x10b56,static_cast<Bidi_Class>(0)},
{0x10b58,Bidi_Class::R},
{0x10b73,static_cast<Bidi_Class>(0)},
{0x10b78,Bidi_Class::R},
{0x10b92,static_cast<Bidi_Class>(0)},
{0x10b99,Bidi_Class::R},
{0x10b9d,static_cast<Bidi_Class>(0)},
{0x10ba9,Bidi_Class::R},
{0x10bb0,static_cast<Bidi_Class>(0)},
{0x10c00,Bidi_Class::R},
{0x10c49,static_cast<Bidi_Class>(0)},
{0x10c80,Bidi_Class::R},
{0x10cb3,static_cast<Bidi_Class>(0)},
{0x10cc0,Bidi_Class::R},
{0x10cf3,static_cast<Bidi_Class>(0)},
{0x10cfa,Bidi_Class::R},
{0x10d00,static_cast<Bidi_Class>(0)},
{0x10e60,Bidi_Class::AN},
{0x10e7f,static_cast<Bidi_Class>(0)},
{0x11000,Bidi_Class::L},
{0x11001,Bidi_Class::NSM},
{0x11002,Bidi_Class::L},
{0x11038,Bidi_Class::NSM},
{0x11047,Bidi_Class::L},
{0x1104e,static_cast<Bidi_Class>(0)},
{0x11052,Bidi_Class::ON},
{0x11066,Bidi_Class::L},
{0x11070,static_cast<Bidi_Class>(0)},
{0x1107f,Bidi_Class::NSM},
{0x11082,Bidi_Class::L},
{0x110b3,Bidi_Class::NSM},
{0x110b7,Bidi_Class::L},
{0x110b9,Bidi_Class::NSM},
{0x110bb,Bidi_Class::L},
{0x110c2,static_cast<Bidi_Class>(0)},
{0x110d0,Bidi_Class::L},
{0x110e9,static_cast<Bidi_Class>(0)},
{0x110f0,Bidi_Class::L},
{0x110fa,static_cast<Bidi_Class>(0)},
{0x11100,Bidi_Class::NSM},
{0x11103,Bidi_Class::L},
{0x11127,Bidi_Class::NSM},
{0x1112c,Bidi_Class::L},
{0x1112d,Bidi_Class::NSM},
{0x11135,static_cast<Bidi_Class>(0)},
{0x11136,Bidi_Class::L},
{0x11144,static_cast<Bidi_Class>(0)},
{0x11150,Bidi_Class::L},
{0x11173,Bidi_Class::NSM},
{0x11174,Bidi_Class::L},
{0x11177,static_cast<Bidi_Class>(0)},
{0x11180,Bidi_Class::NSM},
{0x11182,Bidi_Class::L},
{0x111b6,Bidi_Class::NSM},
{0x111bf,Bidi_Class::L},
{0x111ca,Bidi_Class::NSM},
{0x111cd,Bidi_Class::L},
{0x111ce,static_cast<Bidi_Class>(0)},
{0x111d0,Bidi_Class::L},
{0x111e0,static_cast<Bidi_Class>(0)},
{0x111e1,Bidi_Class::L},
{0x111f5,static_cast<Bidi_Class>(0)},
{0x11200,Bidi_Class::L},
{0x11212,static_cast<Bidi_Class>(0)},
{0x11213,Bidi_Class::L},
{0x1122f,Bidi_Class::NSM},
{0x11232,Bidi_Class::L},
{0x11234,Bidi_Class::NSM},
{0x11235,Bidi_Class::L},
{0x11236,Bidi_Class::NSM},
{0x11238,Bidi_Class::L},
{0x1123e,static_cast<Bidi_Class>(0)},
{0x11280,Bidi_Class::L},
{0x11287,static_cast<Bidi_Class>(0)},
{0x11288,Bidi_Class::L},
{0x11289,static_cast<Bidi_Class>(0)},
{0x1128a,Bidi_Class::L},
{0x1128e,static_cast<Bidi_Class>(0)},
{0x1128f,Bidi_Class::L},
{0x1129e,static_cast<Bidi_Class>(0)},
{0x1129f,Bidi_Class::L},
{0x112aa,static_cast<Bidi_Class>(0)},
{0x112b0,Bidi_Class::L},
{0x112df,Bidi_Class::NSM},
{0x112e0,Bidi_Class::L},
{0x112e3,Bidi_Class::NSM},
{0x112eb,static_cast<Bidi_Class>(0)},
{0x112f0,Bidi_Class::L},
{0x112fa,static_cast<Bidi_Class>(0)},
{0x11300,Bidi_Class::NSM},
{0x11302,Bidi_Class::L},
{0x11304,static_cast<Bidi_Class>(0)},
{0x11305,Bidi_Class::L},
{0x1130d,static_cast<Bidi_Class>(0)},
{0x1130f,Bidi_Class::L},
{0x11311,static_cast<Bidi_Class>(0)},
{0x11313,Bidi_Class::L},
{0x11329,static_cast<Bidi_Class>(0)},
{0x1132a,Bidi_Class::L},
{0x11331,static_cast<Bidi_Class>(0)},
{0x11332,Bidi_Class::L},
{0x11334,static_cast<Bidi_Class>(0)},
{0x11335,Bidi_Class::L},
{0x1133a,static_cast<Bidi_Class>(0)},
{0x1133c,Bidi_Class::NSM},
{0x1133d,Bidi_Class::L},
{0x11340,Bidi_Class::NSM},
{0x11341,Bidi_Class::L},
{0x11345,static_cast<Bidi_Class>(0)},
{0x11347,Bidi_Class::L},
{0x11349,static_cast<Bidi_Class>(0)},
{0x1134b,Bidi_Class::L},
{0x1134e,static_cast<Bidi_Class>(0)},
{0x11350,Bidi_Class::L},
{0x11351,static_cast<Bidi_Class>(0)},
{0x11357,Bidi_Class::L},
{0x11358,static_cast<Bidi_Class>(0)},
{0x1135d,Bidi_Class::L},
{0x11364,static_cast<Bidi_Class>(0)},
{0x11366,Bidi_Class::NSM},
{0x1136d,static_cast<Bidi_Class>(0)},
{0x11370,Bidi_Class::NSM},
{0x11375,static_cast<Bidi_Class>(0)},
{0x11480,Bidi_Class::L},
{0x114b3,Bidi_Class::NSM},
{0x114b9,Bidi_Class::L},
{0x114ba,Bidi_Class::NSM},
{0x114bb,Bidi_Class::L},
{0x114bf,Bidi_Class::NSM},
{0x114c1,Bidi_Class::L},
{0x114c2,Bidi_Class::NSM},
{0x114c4,Bidi_Class::L},
{0x114c8,static_cast<Bidi_Class>(0)},
{0x114d0,Bidi_Class::L},
{0x114da,static_cast<Bidi_Class>(0)},
{0x11580,Bidi_Class::L},
{0x115b2,Bidi_Class::NSM},
{0x115b6,static_cast<Bidi_Class>(0)},
{0x115b8,Bidi_Class::L},
{0x115bc,Bidi_Class::NSM},
{0x115be,Bidi_Class::L},
{0x115bf,Bidi_Class::NSM},
{0x115c1,Bidi_Class::L},
{0x115dc,Bidi_Class::NSM},
{0x115de,static_cast<Bidi_Class>(0)},
{0x11600,Bidi_Class::L},
{0x11633,Bidi_Class::NSM},
{0x1163b,Bidi_Class::L},
{0x1163d,Bidi_Class::NSM},
{0x1163e,Bidi_Class::L},
{0x1163f,Bidi_Class::NSM},
{0x11641,Bidi_Class::L},
{0x11645,static_cast<Bidi_Class>(0)},
{0x11650,Bidi_Class::L},
{0x1165a,static_cast<Bidi_Class>(0)},
{0x11680,Bidi_Class::L},
{0x116ab,Bidi_Class::NSM},
{0x116ac,Bidi_Class::L},
{0x116ad,Bidi_Class::NSM},
{0x116ae,Bidi_Class::L},
{0x116b0,Bidi_Class::NSM},
{0x116b6,Bidi_Class::L},
{0x116b7,Bidi_Class::NSM},
{0x116b8,static_cast<Bidi_Class>(0)},
{0x116c0,Bidi_Class::L},
{0x116ca,static_cast<Bidi_Class>(0)},
{0x11700,Bidi_Class::L},
{0x1171a,static_cast<Bidi_Class>(0)},
{0x1171d,Bidi_Class::NSM},
{0x11720,Bidi_Class::L},
{0x11722,Bidi_Class::NSM},
{0x11726,Bidi_Class::L},
{0x11727,Bidi_Class::NSM},
{0x1172c,static_cast<Bidi_Class>(0)},
{0x11730,Bidi_Class::L},
{0x11740,static_cast<Bidi_Class>(0)},
{0x118a0,Bidi_Class::L},
{0x118f3,static_cast<Bidi_Class>(0)},
{0x118ff,Bidi_Class::L},
{0x11900,static_cast<Bidi_Class>(0)},
{0x11ac0,Bidi_Class::L},
{0x11af9,static_cast<Bidi_Class>(0)},
{0x12000,Bidi_Class::L},
{0x1239a,static_cast<Bidi_Class>(0)},
{0x12400,Bidi_Class::L},
{0x1246f,static_cast<Bidi_Class>(0)},
{0x12470,Bidi_Class::L},
{0x12475,static_cast<Bidi_Class>(0)},
{0x12480,Bidi_Class::L},
{0x12544,static_cast<Bidi_Class>(0)},
{0x13000,Bidi_Class::L},
{0x1342f,static_cast<Bidi_Class>(0)},
{0x14400,Bidi_Class::L},
{0x14647,static_cast<Bidi_Class>(0)},
{0x16800,Bidi_Class::L},
{0x16a39,static_cast<Bidi_Class>(0)},
{0x16a40,Bidi_Class::L},
{0x16a5f,static_cast<Bidi_Class>(0)},
{0x16a60,Bidi_Class::L},
{0x16a6a,static_cast<Bidi_Class>(0)},
{0x16a6e,Bidi_Class::L},
{0x16a70,static_cast<Bidi_Class>(0)},
{0x16ad0,Bidi_Class::L},
{0x16aee,static_cast<Bidi_Class>(0)},
{0x16af0,Bidi_Class::NSM},
{0x16af5,Bidi_Class::L},
{0x16af6,static_cast<Bidi_Class>(0)},
{0x16b00,Bidi_Class::L},
{0x16b30,Bidi_Class::NSM},
{0x16b37,Bidi_Class::L},
{0x16b46,static_cast<Bidi_Class>(0)},
{0x16b50,Bidi_Class::L},
{0x16b5a,static_cast<Bidi_Class>(0)},
{0x16b5b,Bidi_Class::L},
{0x16b62,static_cast<Bidi_Class>(0)},
{0x16b63,Bidi_Class::L},
{0x16b78,static_cast<Bidi_Class>(0)},
{0x16b7d,Bidi_Class::L},
{0x16b90,static_cast<Bidi_Class>(0)},
{0x16f00,Bidi_Class::L},
{0x16f45,static_cast<Bidi_Class>(0)},
{0x16f50,Bidi_Class::L},
{0x16f7f,static_cast<Bidi_Class>(0)},
{0x16f8f,Bidi_Class::NSM},
{0x16f93,Bidi_Class::L},
{0x16fa0,static_cast<Bidi_Class>(0)},
{0x1b000,Bidi_Class::L},
{0x1b002,static_cast<Bidi_Class>(0)},
{0x1bc00,Bidi_Class::L},
{0x1bc6b,static_cast<Bidi_Class>(0)},
{0x1bc70,Bidi_Class::L},
{0x1bc7d,static_cast<Bidi_Class>(0)},
{0x1bc80,Bidi_Class::L},
{0x1bc89,static_cast<Bidi_Class>(0)},
{0x1bc90,Bidi_Class::L},
{0x1bc9a,static_cast<Bidi_Class>(0)},
{0x1bc9c,Bidi_Class::L},
{0x1bc9d,Bidi_Class::NSM},
{0x1bc9f,Bidi_Class::L},
{0x1bca0,Bidi_Class::BN},
{0x1bca4,static_cast<Bidi_Class>(0)},
{0x1d000,Bidi_Class::L},
{0x1d0f6,static_cast<Bidi_Class>(0)},
{0x1d100,Bidi_Class::L},
{0x1d127,static_cast<Bidi_Class>(0)},
{0x1d129,Bidi_Class::L},
{0x1d167,Bidi_Class::NSM},
{0x1d16a,Bidi_Class::L},
{0x1d173,Bidi_Class::BN},
{0x1d17b,Bidi_Class::NSM},
{0x1d183,Bidi_Class::L},
{0x1d185,Bidi_Class::NSM},
{0x1d18c,Bidi_Class::L},
{0x1d1aa,Bidi_Class::NSM},
{0x1d1ae,Bidi_Class::L},
{0x1d1e9,static_cast<Bidi_Class>(0)},
{0x1d200,Bidi_Class::ON},
{0x1d242,Bidi_Class::NSM},
{0x1d245,Bidi_Class::ON},
{0x1d246,static_cast<Bidi_Class>(0)},
{0x1d300,Bidi_Class::ON},
{0x1d357,static_cast<Bidi_Class>(0)},
{0x1d360,Bidi_Class::L},
{0x1d372,static_cast<Bidi_Class>(0)},
{0x1d400,Bidi_Class::L},
{0x1d455,static_cast<Bidi_Class>(0)},
{0x1d456,Bidi_Class::L},
{0x1d49d,static_cast<Bidi_Class>(0)},
{0x1d49e,Bidi_Class::L},
{0x1d4a0,static_cast<Bidi_Class>(0)},
{0x1d4a2,Bidi_Class::L},
{0x1d4a3,static_cast<Bidi_Class>(0)},
{0x1d4a5,Bidi_Class::L},
{0x1d4a7,static_cast<Bidi_Class>(0)},
{0x1d4a9,Bidi_Class::L},
{0x1d4ad,static_cast<Bidi_Class>(0)},
{0x1d4ae,Bidi_Class::L},
{0x1d4ba,static_cast<Bidi_Class>(0)},
{0x1d4bb,Bidi_Class::L},
{0x1d4bc,static_cast<Bidi_Class>(0)},
{0x1d4bd,Bidi_Class::L},
{0x1d4c4,static_cast<Bidi_Class>(0)},
{0x1d4c5,Bidi_Class::L},
{0x1d506,static_cast<Bidi_Class>(0)},
{0x1d507,Bidi_Class::L},
{0x1d50b,static_cast<Bidi_Class>(0)},
{0x1d50d,Bidi_Class::L},
{0x1d515,static_cast<Bidi_Class>(0)},
{0x1d516,Bidi_Class::L},
{0x1d51d,static_cast<Bidi_Class>(0)},
{0x1d51e,Bidi_Class::L},
{0x1d53a,static_cast<Bidi_Class>(0)},
{0x1d53b,Bidi_Class::L},
{0x1d53f,static_cast<Bidi_Class>(0)},
{0x1d540,Bidi_Class::L},
{0x1d545,static_cast<Bidi_Class>(0)},
{0x1d546,Bidi_Class::L},
{0x1d547,static_cast<Bidi_Class>(0)},
{0x1d54a,Bidi_Class::L},
{0x1d551,static_cast<Bidi_Class>(0)},
{0x1d552,Bidi_Class::L},
{0x1d6a6,static_cast<Bidi_Class>(0)},
{0x1d6a8,Bidi_Class::L},
{0x1d6db,Bidi_Class::ON},
{0x1d6dc,Bidi_Class::L},
{0x1d715,Bidi_Class::ON},
{0x1d716,Bidi_Class::L},
{0x1d74f,Bidi_Class::ON},
{0x1d750,Bidi_Class::L},
{0x1d789,Bidi_Class::ON},
{0x1d78a,Bidi_Class::L},
{0x1d7c3,Bidi_Class::ON},
{0x1d7c4,Bidi_Class::L},
{0x1d7cc,static_cast<Bidi_Class>(0)},
{0x1d7ce,Bidi_Class::EN},
{0x1d800,Bidi_Class::L},
{0x1da00,Bidi_Class::NSM},
{0x1da37,Bidi_Class::L},
{0x1da3b,Bidi_Class::NSM},
{0x1da6d,Bidi_Class::L},
{0x1da75,Bidi_Class::NSM},
{0x1da76,Bidi_Class::L},
{0x1da84,Bidi_Class::NSM},
{0x1da85,Bidi_Class::L},
{0x1da8c,static_cast<Bidi_Class>(0)},
{0x1da9b,Bidi_Class::NSM},
{0x1daa0,static_cast<Bidi_Class>(0)},
{0x1daa1,Bidi_Class::NSM},
{0x1dab0,static_cast<Bidi_Class>(0)},
{0x1e800,Bidi_Class::R},
{0x1e8c5,static_cast<Bidi_Class>(0)},
{0x1e8c7,Bidi_Class::R},
{0x1e8d0,Bidi_Class::NSM},
{0x1e8d7,static_cast<Bidi_Class>(0)},
{0x1ee00,Bidi_Class::AL},
{0x1ee04,static_cast<Bidi_Class>(0)},
{0x1ee05,Bidi_Class::AL},
{0x1ee20,static_cast<Bidi_Class>(0)},
{0x1ee21,Bidi_Class::AL},
{0x1ee23,static_cast<Bidi_Class>(0)},
{0x1ee24,Bidi_Class::AL},
{0x1ee25,static_cast<Bidi_Class>(0)},
{0x1ee27,Bidi_Class::AL},
{0x1ee28,static_cast<Bidi_Class>(0)},
{0x1ee29,Bidi_Class::AL},
{0x1ee33,static_cast<Bidi_Class>(0)},
{0x1ee34,Bidi_Class::AL},
{0x1ee38,static_cast<Bidi_Class>(0)},
{0x1ee39,Bidi_Class::AL},
{0x1ee3a,static_cast<Bidi_Class>(0)},
{0x1ee3b,Bidi_Class::AL},
{0x1ee3c,static_cast<Bidi_Class>(0)},
{0x1ee42,Bidi_Class::AL},
{0x1ee43,static_cast<Bidi_Class>(0)},
{0x1ee47,Bidi_Class::AL},
{0x1ee48,static_cast<Bidi_Class>(0)},
{0x1ee49,Bidi_Class::AL},
{0x1ee4a,static_cast<Bidi_Class>(0)},
{0x1ee4b,Bidi_Class::AL},
{0x1ee4c,static_cast<Bidi_Class>(0)},
{0x1ee4d,Bidi_Class::AL},
{0x1ee50,static_cast<Bidi_Class>(0)},
{0x1ee51,Bidi_Class::AL},
{0x1ee53,static_cast<Bidi_Class>(0)},
{0x1ee54,Bidi_Class::AL},
{0x1ee55,static_cast<Bidi_Class>(0)},
{0x1ee57,Bidi_Class::AL},
{0x1ee58,static_cast<Bidi_Class>(0)},
{0x1ee59,Bidi_Class::AL},
{0x1ee5a,static_cast<Bidi_Class>(0)},
{0x1ee5b,Bidi_Class::AL},
{0x1ee5c,static_cast<Bidi_Class>(0)},
{0x1ee5d,Bidi_Class::AL},
{0x1ee5e,static_cast<Bidi_Class>(0)},
{0x1ee5f,Bidi_Class::AL},
{0x1ee60,static_cast<Bidi_Class>(0)},
{0x1ee61,Bidi_Class::AL},
{0x1ee63,static_cast<Bidi_Class>(0)},
{0x1ee64,Bidi_Class::AL},
{0x1ee65,static_cast<Bidi_Class>(0)},
{0x1ee67,Bidi_Class::AL},
{0x1ee6b,static_cast<Bidi_Class>(0)},
{0x1ee6c,Bidi_Class::AL},
{0x1ee73,static_cast<Bidi_Class>(0)},
{0x1ee74,Bidi_Class::AL},
{0x1ee78,static_cast<Bidi_Class>(0)},
{0x1ee79,Bidi_Class::AL},
{0x1ee7d,static_cast<Bidi_Class>(0)},
{0x1ee7e,Bidi_Class::AL},
{0x1ee7f,static_cast<Bidi_Class>(0)},
{0x1ee80,Bidi_Class::AL},
{0x1ee8a,static_cast<Bidi_Class>(0)},
{0x1ee8b,Bidi_Class::AL},
{0x1ee9c,static_cast<Bidi_Class>(0)},
{0x1eea1,Bidi_Class::AL},
{0x1eea4,static_cast<Bidi_Class>(0)},
{0x1eea5,Bidi_Class::AL},
{0x1eeaa,static_cast<Bidi_Class>(0)},
{0x1eeab,Bidi_Class::AL},
{0x1eebc,static_cast<Bidi_Class>(0)},
{0x1eef0,Bidi_Class::ON},
{0x1eef2,static_cast<Bidi_Class>(0)},
{0x1f000,Bidi_Class::ON},
{0x1f02c,static_cast<Bidi_Class>(0)},
{0x1f030,Bidi_Class::ON},
{0x1f094,static_cast<Bidi_Class>(0)},
{0x1f0a0,Bidi_Class::ON},
{0x1f0af,static_cast<Bidi_Class>(0)},
{0x1f0b1,Bidi_Class::ON},
{0x1f0c0,static_cast<Bidi_Class>(0)},
{0x1f0c1,Bidi_Class::ON},
{0x1f0d0,static_cast<Bidi_Class>(0)},
{0x1f0d1,Bidi_Class::ON},
{0x1f0f6,static_cast<Bidi_Class>(0)},
{0x1f100,Bidi_Class::EN},
{0x1f10b,Bidi_Class::ON},
{0x1f10d,static_cast<Bidi_Class>(0)},
{0x1f110,Bidi_Class::L},
{0x1f12f,static_cast<Bidi_Class>(0)},
{0x1f130,Bidi_Class::L},
{0x1f16a,Bidi_Class::ON},
{0x1f16c,static_cast<Bidi_Class>(0)},
{0x1f170,Bidi_Class::L},
{0x1f19b,static_cast<Bidi_Class>(0)},
{0x1f1e6,Bidi_Class::L},
{0x1f203,static_cast<Bidi_Class>(0)},
{0x1f210,Bidi_Class::L},
{0x1f23b,static_cast<Bidi_Class>(0)},
{0x1f240,Bidi_Class::L},
{0x1f249,static_cast<Bidi_Class>(0)},
{0x1f250,Bidi_Class::L},
{0x1f252,static_cast<Bidi_Class>(0)},
{0x1f300,Bidi_Class::ON},
{0x1f57a,static_cast<Bidi_Class>(0)},
{0x1f57b,Bidi_Class::ON},
{0x1f5a4,static_cast<Bidi_Class>(0)},
{0x1f5a5,Bidi_Class::ON},
{0x1f6d1,static_cast<Bidi_Class>(0)},
{0x1f6e0,Bidi_Class::ON},
{0x1f6ed,static_cast<Bidi_Class>(0)},
{0x1f6f0,Bidi_Class::ON},
{0x1f6f4,static_cast<Bidi_Class>(0)},
{0x1f700,Bidi_Class::ON},
{0x1f774,static_cast<Bidi_Class>(0)},
{0x1f780,Bidi_Class::ON},
{0x1f7d5,static_cast<Bidi_Class>(0)},
{0x1f800,Bidi_Class::ON},
{0x1f80c,static_cast<Bidi_Class>(0)},
{0x1f810,Bidi_Class::ON},
{0x1f848,static_cast<Bidi_Class>(0)},
{0x1f850,Bidi_Class::ON},
{0x1f85a,static_cast<Bidi_Class>(0)},
{0x1f860,Bidi_Class::ON},
{0x1f888,static_cast<Bidi_Class>(0)},
{0x1f890,Bidi_Class::ON},
{0x1f8ae,static_cast<Bidi_Class>(0)},
{0x1f910,Bidi_Class::ON},
{0x1f919,static_cast<Bidi_Class>(0)},
{0x1f980,Bidi_Class::ON},
{0x1f985,static_cast<Bidi_Class>(0)},
{0x1f9c0,Bidi_Class::ON},
{0x1f9c1,static_cast<Bidi_Class>(0)},
{0x20000,Bidi_Class::L},
{0x2a6d7,static_cast<Bidi_Class>(0)},
{0x2a700,Bidi_Class::L},
{0x2b735,static_cast<Bidi_Class>(0)},
{0x2b740,Bidi_Class::L},
{0x2b81e,static_cast<Bidi_Class>(0)},
{0x2b820,Bidi_Class::L},
{0x2cea2,static_cast<Bidi_Class>(0)},
{0x2f800,Bidi_Class::L},
{0x2fa1e,static_cast<Bidi_Class>(0)},
{0xe0001,Bidi_Class::BN},
{0xe0002,static_cast<Bidi_Class>(0)},
{0xe0020,Bidi_Class::BN},
{0xe0080,static_cast<Bidi_Class>(0)},
{0xe0100,Bidi_Class::NSM},
{0xe01f0,static_cast<Bidi_Class>(0)},
{0xf0000,Bidi_Class::L},
{0xffffe,static_cast<Bidi_Class>(0)},
{0x100000,Bidi_Class::L},
{0x10fffe,static_cast<Bidi_Class>(0)},
}};

const TableView<char32_t, Bidi_Class> bidi_class_table {&bidi_class_array[0], &bidi_class_array[0] + bidi_class_array.size()};

const std::array<char32_t, 545> bidi_mirrored_array = {{
0x28,
0x29,
0x3c,
0x3e,
0x5b,
0x5d,
0x7b,
0x7d,
0xab,
0xbb,
0xf3a,
0xf3b,
0xf3c,
0xf3d,
0x169b,
0x169c,
0x2039,
0x203a,
0x2045,
0x2046,
0x207d,
0x207e,
0x208d,
0x208e,
0x2140,
0x2201,
0x2202,
0x2203,
0x2204,
0x2208,
0x2209,
0x220a,
0x220b,
0x220c,
0x220d,
0x2211,
0x2215,
0x2216,
0x221a,
0x221b,
0x221c,
0x221d,
0x221f,
0x2220,
0x2221,
0x2222,
0x2224,
0x2226,
0x222b,
0x222c,
0x222d,
0x222e,
0x222f,
0x2230,
0x2231,
0x2232,
0x2233,
0x2239,
0x223b,
0x223c,
0x223d,
0x223e,
0x223f,
0x2240,
0x2241,
0x2242,
0x2243,
0x2244,
0x2245,
0x2246,
0x2247,
0x2248,
0x2249,
0x224a,
0x224b,
0x224c,
0x2252,
0x2253,
0x2254,
0x2255,
0x225f,
0x2260,
0x2262,
0x2264,
0x2265,
0x2266,
0x2267,
0x2268,
0x2269,
0x226a,
0x226b,
0x226e,
0x226f,
0x2270,
0x2271,
0x2272,
0x2273,
0x2274,
0x2275,
0x2276,
0x2277,
0x2278,
0x2279,
0x227a,
0x227b,
0x227c,
0x227d,
0x227e,
0x227f,
0x2280,
0x2281,
0x2282,
0x2283,
0x2284,
0x2285,
0x2286,
0x2287,
0x2288,
0x2289,
0x228a,
0x228b,
0x228c,
0x228f,
0x2290,
0x2291,
0x2292,
0x2298,
0x22a2,
0x22a3,
0x22a6,
0x22a7,
0x22a8,
0x22a9,
0x22aa,
0x22ab,
0x22ac,
0x22ad,
0x22ae,
0x22af,
0x22b0,
0x22b1,
0x22b2,
0x22b3,
0x22b4,
0x22b5,
0x22b6,
0x22b7,
0x22b8,
0x22be,
0x22bf,
0x22c9,
0x22ca,
0x22cb,
0x22cc,
0x22cd,
0x22d0,
0x22d1,
0x22d6,
0x22d7,
0x22d8,
0x22d9,
0x22da,
0x22db,
0x22dc,
0x22dd,
0x22de,
0x22df,
0x22e0,
0x22e1,
0x22e2,
0x22e3,
0x22e4,
0x22e5,
0x22e6,
0x22e7,
0x22e8,
0x22e9,
0x22ea,
0x22eb,
0x22ec,
0x22ed,
0x22f0,
0x22f1,
0x22f2,
0x22f3,
0x22f4,
0x22f5,
0x22f6,
0x22f7,
0x22f8,
0x22f9,
0x22fa,
0x22fb,
0x22fc,
0x22fd,
0x22fe,
0x22ff,
0x2308,
0x2309,
0x230a,
0x230b,
0x2320,
0x2321,
0x2329,
0x232a,
0x2768,
0x2769,
0x276a,
0x276b,
0x276c,
0x276d,
0x276e,
0x276f,
0x2770,
0x2771,
0x2772,
0x2773,
0x2774,
0x2775,
0x27c0,
0x27c3,
0x27c4,
0x27c5,
0x27c6,
0x27c8,
0x27c9,
0x27cb,
0x27cc,
0x27cd,
0x27d3,
0x27d4,
0x27d5,
0x27d6,
0x27dc,
0x27dd,
0x27de,
0x27e2,
0x27e3,
0x27e4,
0x27e5,
0x27e6,
0x27e7,
0x27e8,
0x27e9,
0x27ea,
0x27eb,
0x27ec,
0x27ed,
0x27ee,
0x27ef,
0x2983,
0x2984,
0x2985,
0x2986,
0x2987,
0x2988,
0x2989,
0x298a,
0x298b,
0x298c,
0x298d,
0x298e,
0x298f,
0x2990,
0x2991,
0x2992,
0x2993,
0x2994,
0x2995,
0x2996,
0x2997,
0x2998,
0x299b,
0x299c,
0x299d,
0x299e,
0x299f,
0x29a0,
0x29a1,
0x29a2,
0x29a3,
0x29a4,
0x29a5,
0x29a6,
0x29a7,
0x29a8,
0x29a9,
0x29aa,
0x29ab,
0x29ac,
0x29ad,
0x29ae,
0x29af,
0x29b8,
0x29c0,
0x29c1,
0x29c2,
0x29c3,
0x29c4,
0x29c5,
0x29c9,
0x29ce,
0x29cf,
0x29d0,
0x29d1,
0x29d2,
0x29d4,
0x29d5,
0x29d8,
0x29d9,
0x29da,
0x29db,
0x29dc,
0x29e1,
0x29e3,
0x29e4,
0x29e5,
0x29e8,
0x29e9,
0x29f4,
0x29f5,
0x29f6,
0x29f7,
0x29f8,
0x29f9,
0x29fc,
0x29fd,
0x2a0a,
0x2a0b,
0x2a0c,
0x2a0d,
0x2a0e,
0x2a0f,
0x2a10,
0x2a11,
0x2a12,
0x2a13,
0x2a14,
0x2a15,
0x2a16,
0x2a17,
0x2a18,
0x2a19,
0x2a1a,
0x2a1b,
0x2a1c,
0x2a1e,
0x2a1f,
0x2a20,
0x2a21,
0x2a24,
0x2a26,
0x2a29,
0x2a2b,
0x2a2c,
0x2a2d,
0x2a2e,
0x2a34,
0x2a35,
0x2a3c,
0x2a3d,
0x2a3e,
0x2a57,
0x2a58,
0x2a64,
0x2a65,
0x2a6a,
0x2a6b,
0x2a6c,
0x2a6d,
0x2a6f,
0x2a70,
0x2a73,
0x2a74,
0x2a79,
0x2a7a,
0x2a7b,
0x2a7c,
0x2a7d,
0x2a7e,
0x2a7f,
0x2a80,
0x2a81,
0x2a82,
0x2a83,
0x2a84,
0x2a85,
0x2a86,
0x2a87,
0x2a88,
0x2a89,
0x2a8a,
0x2a8b,
0x2a8c,
0x2a8d,
0x2a8e,
0x2a8f,
0x2a90,
0x2a91,
0x2a92,
0x2a93,
0x2a94,
0x2a95,
0x2a96,
0x2a97,
0x2a98,
0x2a99,
0x2a9a,
0x2a9b,
0x2a9c,
0x2a9d,
0x2a9e,
0x2a9f,
0x2aa0,
0x2aa1,
0x2aa2,
0x2aa3,
0x2aa6,
0x2aa7,
0x2aa8,
0x2aa9,
0x2aaa,
0x2aab,
0x2aac,
0x2aad,
0x2aaf,
0x2ab0,
0x2ab1,
0x2ab2,
0x2ab3,
0x2ab4,
0x2ab5,
0x2ab6,
0x2ab7,
0x2ab8,
0x2ab9,
0x2aba,
0x2abb,
0x2abc,
0x2abd,
0x2abe,
0x2abf,
0x2ac0,
0x2ac1,
0x2ac2,
0x2ac3,
0x2ac4,
0x2ac5,
0x2ac6,
0x2ac7,
0x2ac8,
0x2ac9,
0x2aca,
0x2acb,
0x2acc,
0x2acd,
0x2ace,
0x2acf,
0x2ad0,
0x2ad1,
0x2ad2,
0x2ad3,
0x2ad4,
0x2ad5,
0x2ad6,
0x2adc,
0x2ade,
0x2ae2,
0x2ae3,
0x2ae4,
0x2ae5,
0x2ae6,
0x2aec,
0x2aed,
0x2aee,
0x2af3,
0x2af7,
0x2af8,
0x2af9,
0x2afa,
0x2afb,
0x2afd,
0x2e02,
0x2e03,
0x2e04,
0x2e05,
0x2e09,
0x2e0a,
0x2e0c,
0x2e0d,
0x2e1c,
0x2e1d,
0x2e20,
0x2e21,
0x2e22,
0x2e23,
0x2e24,
0x2e25,
0x2e26,
0x2e27,
0x2e28,
0x2e29,
0x3008,
0x3009,
0x300a,
0x300b,
0x300c,
0x300d,
0x300e,
0x300f,
0x3010,
0x3011,
0x3014,
0x3015,
0x3016,
0x3017,
0x3018,
0x3019,
0x301a,
0x301b,
0xfe59,
0xfe5a,
0xfe5b,
0xfe5c,
0xfe5d,
0xfe5e,
0xfe64,
0xfe65,
0xff08,
0xff09,
0xff1c,
0xff1e,
0xff3b,
0xff3d,
0xff5b,
0xff5d,
0xff5f,
0xff60,
0xff62,
0xff63,
0x1d6db,
0x1d715,
0x1d74f,
0x1d789,
0x1d7c3,
}};

const Irange<char32_t const*> bidi_mirrored_table {&bidi_mirrored_array[0], &bidi_mirrored_array[0] + bidi_mirrored_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 364> bidi_mirroring_glyph_array = {{
{0x28,0x29},
{0x29,0x28},
{0x3c,0x3e},
{0x3e,0x3c},
{0x5b,0x5d},
{0x5d,0x5b},
{0x7b,0x7d},
{0x7d,0x7b},
{0xab,0xbb},
{0xbb,0xab},
{0xf3a,0xf3b},
{0xf3b,0xf3a},
{0xf3c,0xf3d},
{0xf3d,0xf3c},
{0x169b,0x169c},
{0x169c,0x169b},
{0x2039,0x203a},
{0x203a,0x2039},
{0x2045,0x2046},
{0x2046,0x2045},
{0x207d,0x207e},
{0x207e,0x207d},
{0x208d,0x208e},
{0x208e,0x208d},
{0x2208,0x220b},
{0x2209,0x220c},
{0x220a,0x220d},
{0x220b,0x2208},
{0x220c,0x2209},
{0x220d,0x220a},
{0x2215,0x29f5},
{0x223c,0x223d},
{0x223d,0x223c},
{0x2243,0x22cd},
{0x2252,0x2253},
{0x2253,0x2252},
{0x2254,0x2255},
{0x2255,0x2254},
{0x2264,0x2265},
{0x2265,0x2264},
{0x2266,0x2267},
{0x2267,0x2266},
{0x2268,0x2269},
{0x2269,0x2268},
{0x226a,0x226b},
{0x226b,0x226a},
{0x226e,0x226f},
{0x226f,0x226e},
{0x2270,0x2271},
{0x2271,0x2270},
{0x2272,0x2273},
{0x2273,0x2272},
{0x2274,0x2275},
{0x2275,0x2274},
{0x2276,0x2277},
{0x2277,0x2276},
{0x2278,0x2279},
{0x2279,0x2278},
{0x227a,0x227b},
{0x227b,0x227a},
{0x227c,0x227d},
{0x227d,0x227c},
{0x227e,0x227f},
{0x227f,0x227e},
{0x2280,0x2281},
{0x2281,0x2280},
{0x2282,0x2283},
{0x2283,0x2282},
{0x2284,0x2285},
{0x2285,0x2284},
{0x2286,0x2287},
{0x2287,0x2286},
{0x2288,0x2289},
{0x2289,0x2288},
{0x228a,0x228b},
{0x228b,0x228a},
{0x228f,0x2290},
{0x2290,0x228f},
{0x2291,0x2292},
{0x2292,0x2291},
{0x2298,0x29b8},
{0x22a2,0x22a3},
{0x22a3,0x22a2},
{0x22a6,0x2ade},
{0x22a8,0x2ae4},
{0x22a9,0x2ae3},
{0x22ab,0x2ae5},
{0x22b0,0x22b1},
{0x22b1,0x22b0},
{0x22b2,0x22b3},
{0x22b3,0x22b2},
{0x22b4,0x22b5},
{0x22b5,0x22b4},
{0x22b6,0x22b7},
{0x22b7,0x22b6},
{0x22c9,0x22ca},
{0x22ca,0x22c9},
{0x22cb,0x22cc},
{0x22cc,0x22cb},
{0x22cd,0x2243},
{0x22d0,0x22d1},
{0x22d1,0x22d0},
{0x22d6,0x22d7},
{0x22d7,0x22d6},
{0x22d8,0x22d9},
{0x22d9,0x22d8},
{0x22da,0x22db},
{0x22db,0x22da},
{0x22dc,0x22dd},
{0x22dd,0x22dc},
{0x22de,0x22df},
{0x22df,0x22de},
{0x22e0,0x22e1},
{0x22e1,0x22e0},
{0x22e2,0x22e3},
{0x22e3,0x22e2},
{0x22e4,0x22e5},
{0x22e5,0x22e4},
{0x22e6,0x22e7},
{0x22e7,0x22e6},
{0x22e8,0x22e9},
{0x22e9,0x22e8},
{0x22ea,0x22eb},
{0x22eb,0x22ea},
{0x22ec,0x22ed},
{0x22ed,0x22ec},
{0x22f0,0x22f1},
{0x22f1,0x22f0},
{0x22f2,0x22fa},
{0x22f3,0x22fb},
{0x22f4,0x22fc},
{0x22f6,0x22fd},
{0x22f7,0x22fe},
{0x22fa,0x22f2},
{0x22fb,0x22f3},
{0x22fc,0x22f4},
{0x22fd,0x22f6},
{0x22fe,0x22f7},
{0x2308,0x2309},
{0x2309,0x2308},
{0x230a,0x230b},
{0x230b,0x230a},
{0x2329,0x232a},
{0x232a,0x2329},
{0x2768,0x2769},
{0x2769,0x2768},
{0x276a,0x276b},
{0x276b,0x276a},
{0x276c,0x276d},
{0x276d,0x276c},
{0x276e,0x276f},
{0x276f,0x276e},
{0x2770,0x2771},
{0x2771,0x2770},
{0x2772,0x2773},
{0x2773,0x2772},
{0x2774,0x2775},
{0x2775,0x2774},
{0x27c3,0x27c4},
{0x27c4,0x27c3},
{0x27c5,0x27c6},
{0x27c6,0x27c5},
{0x27c8,0x27c9},
{0x27c9,0x27c8},
{0x27cb,0x27cd},
{0x27cd,0x27cb},
{0x27d5,0x27d6},
{0x27d6,0x27d5},
{0x27dd,0x27de},
{0x27de,0x27dd},
{0x27e2,0x27e3},
{0x27e3,0x27e2},
{0x27e4,0x27e5},
{0x27e5,0x27e4},
{0x27e6,0x27e7},
{0x27e7,0x27e6},
{0x27e8,0x27e9},
{0x27e9,0x27e8},
{0x27ea,0x27eb},
{0x27eb,0x27ea},
{0x27ec,0x27ed},
{0x27ed,0x27ec},
{0x27ee,0x27ef},
{0x27ef,0x27ee},
{0x2983,0x2984},
{0x2984,0x2983},
{0x2985,0x2986},
{0x2986,0x2985},
{0x2987,0x2988},
{0x2988,0x2987},
{0x2989,0x298a},
{0x298a,0x2989},
{0x298b,0x298c},
{0x298c,0x298b},
{0x298d,0x2990},
{0x298e,0x298f},
{0x298f,0x298e},
{0x2990,0x298d},
{0x2991,0x2992},
{0x2992,0x2991},
{0x2993,0x2994},
{0x2994,0x2993},
{0x2995,0x2996},
{0x2996,0x2995},
{0x2997,0x2998},
{0x2998,0x2997},
{0x29b8,0x2298},
{0x29c0,0x29c1},
{0x29c1,0x29c0},
{0x29c4,0x29c5},
{0x29c5,0x29c4},
{0x29cf,0x29d0},
{0x29d0,0x29cf},
{0x29d1,0x29d2},
{0x29d2,0x29d1},
{0x29d4,0x29d5},
{0x29d5,0x29d4},
{0x29d8,0x29d9},
{0x29d9,0x29d8},
{0x29da,0x29db},
{0x29db,0x29da},
{0x29f5,0x2215},
{0x29f8,0x29f9},
{0x29f9,0x29f8},
{0x29fc,0x29fd},
{0x29fd,0x29fc},
{0x2a2b,0x2a2c},
{0x2a2c,0x2a2b},
{0x2a2d,0x2a2e},
{0x2a2e,0x2a2d},
{0x2a34,0x2a35},
{0x2a35,0x2a34},
{0x2a3c,0x2a3d},
{0x2a3d,0x2a3c},
{0x2a64,0x2a65},
{0x2a65,0x2a64},
{0x2a79,0x2a7a},
{0x2a7a,0x2a79},
{0x2a7d,0x2a7e},
{0x2a7e,0x2a7d},
{0x2a7f,0x2a80},
{0x2a80,0x2a7f},
{0x2a81,0x2a82},
{0x2a82,0x2a81},
{0x2a83,0x2a84},
{0x2a84,0x2a83},
{0x2a8b,0x2a8c},
{0x2a8c,0x2a8b},
{0x2a91,0x2a92},
{0x2a92,0x2a91},
{0x2a93,0x2a94},
{0x2a94,0x2a93},
{0x2a95,0x2a96},
{0x2a96,0x2a95},
{0x2a97,0x2a98},
{0x2a98,0x2a97},
{0x2a99,0x2a9a},
{0x2a9a,0x2a99},
{0x2a9b,0x2a9c},
{0x2a9c,0x2a9b},
{0x2aa1,0x2aa2},
{0x2aa2,0x2aa1},
{0x2aa6,0x2aa7},
{0x2aa7,0x2aa6},
{0x2aa8,0x2aa9},
{0x2aa9,0x2aa8},
{0x2aaa,0x2aab},
{0x2aab,0x2aaa},
{0x2aac,0x2aad},
{0x2aad,0x2aac},
{0x2aaf,0x2ab0},
{0x2ab0,0x2aaf},
{0x2ab3,0x2ab4},
{0x2ab4,0x2ab3},
{0x2abb,0x2abc},
{0x2abc,0x2abb},
{0x2abd,0x2abe},
{0x2abe,0x2abd},
{0x2abf,0x2ac0},
{0x2ac0,0x2abf},
{0x2ac1,0x2ac2},
{0x2ac2,0x2ac1},
{0x2ac3,0x2ac4},
{0x2ac4,0x2ac3},
{0x2ac5,0x2ac6},
{0x2ac6,0x2ac5},
{0x2acd,0x2ace},
{0x2ace,0x2acd},
{0x2acf,0x2ad0},
{0x2ad0,0x2acf},
{0x2ad1,0x2ad2},
{0x2ad2,0x2ad1},
{0x2ad3,0x2ad4},
{0x2ad4,0x2ad3},
{0x2ad5,0x2ad6},
{0x2ad6,0x2ad5},
{0x2ade,0x22a6},
{0x2ae3,0x22a9},
{0x2ae4,0x22a8},
{0x2ae5,0x22ab},
{0x2aec,0x2aed},
{0x2aed,0x2aec},
{0x2af7,0x2af8},
{0x2af8,0x2af7},
{0x2af9,0x2afa},
{0x2afa,0x2af9},
{0x2e02,0x2e03},
{0x2e03,0x2e02},
{0x2e04,0x2e05},
{0x2e05,0x2e04},
{0x2e09,0x2e0a},
{0x2e0a,0x2e09},
{0x2e0c,0x2e0d},
{0x2e0d,0x2e0c},
{0x2e1c,0x2e1d},
{0x2e1d,0x2e1c},
{0x2e20,0x2e21},
{0x2e21,0x2e20},
{0x2e22,0x2e23},
{0x2e23,0x2e22},
{0x2e24,0x2e25},
{0x2e25,0x2e24},
{0x2e26,0x2e27},
{0x2e27,0x2e26},
{0x2e28,0x2e29},
{0x2e29,0x2e28},
{0x3008,0x3009},
{0x3009,0x3008},
{0x300a,0x300b},
{0x300b,0x300a},
{0x300c,0x300d},
{0x300d,0x300c},
{0x300e,0x300f},
{0x300f,0x300e},
{0x3010,0x3011},
{0x3011,0x3010},
{0x3014,0x3015},
{0x3015,0x3014},
{0x3016,0x3017},
{0x3017,0x3016},
{0x3018,0x3019},
{0x3019,0x3018},
{0x301a,0x301b},
{0x301b,0x301a},
{0xfe59,0xfe5a},
{0xfe5a,0xfe59},
{0xfe5b,0xfe5c},
{0xfe5c,0xfe5b},
{0xfe5d,0xfe5e},
{0xfe5e,0xfe5d},
{0xfe64,0xfe65},
{0xfe65,0xfe64},
{0xff08,0xff09},
{0xff09,0xff08},
{0xff1c,0xff1e},
{0xff1e,0xff1c},
{0xff3b,0xff3d},
{0xff3d,0xff3b},
{0xff5b,0xff5d},
{0xff5d,0xff5b},
{0xff5f,0xff60},
{0xff60,0xff5f},
{0xff62,0xff63},
{0xff63,0xff62},
}};

const TableView<char32_t, char32_t> bidi_mirroring_glyph_table {&bidi_mirroring_glyph_array[0], &bidi_mirroring_glyph_array[0] + bidi_mirroring_glyph_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 120> bidi_paired_bracket_array = {{
{0x28,0x29},
{0x29,0x28},
{0x5b,0x5d},
{0x5d,0x5b},
{0x7b,0x7d},
{0x7d,0x7b},
{0xf3a,0xf3b},
{0xf3b,0xf3a},
{0xf3c,0xf3d},
{0xf3d,0xf3c},
{0x169b,0x169c},
{0x169c,0x169b},
{0x2045,0x2046},
{0x2046,0x2045},
{0x207d,0x207e},
{0x207e,0x207d},
{0x208d,0x208e},
{0x208e,0x208d},
{0x2308,0x2309},
{0x2309,0x2308},
{0x230a,0x230b},
{0x230b,0x230a},
{0x2329,0x232a},
{0x232a,0x2329},
{0x2768,0x2769},
{0x2769,0x2768},
{0x276a,0x276b},
{0x276b,0x276a},
{0x276c,0x276d},
{0x276d,0x276c},
{0x276e,0x276f},
{0x276f,0x276e},
{0x2770,0x2771},
{0x2771,0x2770},
{0x2772,0x2773},
{0x2773,0x2772},
{0x2774,0x2775},
{0x2775,0x2774},
{0x27c5,0x27c6},
{0x27c6,0x27c5},
{0x27e6,0x27e7},
{0x27e7,0x27e6},
{0x27e8,0x27e9},
{0x27e9,0x27e8},
{0x27ea,0x27eb},
{0x27eb,0x27ea},
{0x27ec,0x27ed},
{0x27ed,0x27ec},
{0x27ee,0x27ef},
{0x27ef,0x27ee},
{0x2983,0x2984},
{0x2984,0x2983},
{0x2985,0x2986},
{0x2986,0x2985},
{0x2987,0x2988},
{0x2988,0x2987},
{0x2989,0x298a},
{0x298a,0x2989},
{0x298b,0x298c},
{0x298c,0x298b},
{0x298d,0x2990},
{0x298e,0x298f},
{0x298f,0x298e},
{0x2990,0x298d},
{0x2991,0x2992},
{0x2992,0x2991},
{0x2993,0x2994},
{0x2994,0x2993},
{0x2995,0x2996},
{0x2996,0x2995},
{0x2997,0x2998},
{0x2998,0x2997},
{0x29d8,0x29d9},
{0x29d9,0x29d8},
{0x29da,0x29db},
{0x29db,0x29da},
{0x29fc,0x29fd},
{0x29fd,0x29fc},
{0x2e22,0x2e23},
{0x2e23,0x2e22},
{0x2e24,0x2e25},
{0x2e25,0x2e24},
{0x2e26,0x2e27},
{0x2e27,0x2e26},
{0x2e28,0x2e29},
{0x2e29,0x2e28},
{0x3008,0x3009},
{0x3009,0x3008},
{0x300a,0x300b},
{0x300b,0x300a},
{0x300c,0x300d},
{0x300d,0x300c},
{0x300e,0x300f},
{0x300f,0x300e},
{0x3010,0x3011},
{0x3011,0x3010},
{0x3014,0x3015},
{0x3015,0x3014},
{0x3016,0x3017},
{0x3017,0x3016},
{0x3018,0x3019},
{0x3019,0x3018},
{0x301a,0x301b},
{0x301b,0x301a},
{0xfe59,0xfe5a},
{0xfe5a,0xfe59},
{0xfe5b,0xfe5c},
{0xfe5c,0xfe5b},
{0xfe5d,0xfe5e},
{0xfe5e,0xfe5d},
{0xff08,0xff09},
{0xff09,0xff08},
{0xff3b,0xff3d},
{0xff3d,0xff3b},
{0xff5b,0xff5d},
{0xff5d,0xff5b},
{0xff5f,0xff60},
{0xff60,0xff5f},
{0xff62,0xff63},
{0xff63,0xff62},
}};

const TableView<char32_t, char32_t> bidi_paired_bracket_table {&bidi_paired_bracket_array[0], &bidi_paired_bracket_array[0] + bidi_paired_bracket_array.size()};

const std::array<KeyValue<char32_t, char32_t>, 120> bidi_paired_bracket_type_array = {{
{0x28,0x6f},
{0x29,0x63},
{0x5b,0x6f},
{0x5d,0x63},
{0x7b,0x6f},
{0x7d,0x63},
{0xf3a,0x6f},
{0xf3b,0x63},
{0xf3c,0x6f},
{0xf3d,0x63},
{0x169b,0x6f},
{0x169c,0x63},
{0x2045,0x6f},
{0x2046,0x63},
{0x207d,0x6f},
{0x207e,0x63},
{0x208d,0x6f},
{0x208e,0x63},
{0x2308,0x6f},
{0x2309,0x63},
{0x230a,0x6f},
{0x230b,0x63},
{0x2329,0x6f},
{0x232a,0x63},
{0x2768,0x6f},
{0x2769,0x63},
{0x276a,0x6f},
{0x276b,0x63},
{0x276c,0x6f},
{0x276d,0x63},
{0x276e,0x6f},
{0x276f,0x63},
{0x2770,0x6f},
{0x2771,0x63},
{0x2772,0x6f},
{0x2773,0x63},
{0x2774,0x6f},
{0x2775,0x63},
{0x27c5,0x6f},
{0x27c6,0x63},
{0x27e6,0x6f},
{0x27e7,0x63},
{0x27e8,0x6f},
{0x27e9,0x63},
{0x27ea,0x6f},
{0x27eb,0x63},
{0x27ec,0x6f},
{0x27ed,0x63},
{0x27ee,0x6f},
{0x27ef,0x63},
{0x2983,0x6f},
{0x2984,0x63},
{0x2985,0x6f},
{0x2986,0x63},
{0x2987,0x6f},
{0x2988,0x63},
{0x2989,0x6f},
{0x298a,0x63},
{0x298b,0x6f},
{0x298c,0x63},
{0x298d,0x6f},
{0x298e,0x63},
{0x298f,0x6f},
{0x2990,0x63},
{0x2991,0x6f},
{0x2992,0x63},
{0x2993,0x6f},
{0x2994,0x63},
{0x2995,0x6f},
{0x2996,0x63},
{0x2997,0x6f},
{0x2998,0x63},
{0x29d8,0x6f},
{0x29d9,0x63},
{0x29da,0x6f},
{0x29db,0x63},
{0x29fc,0x6f},
{0x29fd,0x63},
{0x2e22,0x6f},
{0x2e23,0x63},
{0x2e24,0x6f},
{0x2e25,0x63},
{0x2e26,0x6f},
{0x2e27,0x63},
{0x2e28,0x6f},
{0x2e29,0x63},
{0x3008,0x6f},
{0x3009,0x63},
{0x300a,0x6f},
{0x300b,0x63},
{0x300c,0x6f},
{0x300d,0x63},
{0x300e,0x6f},
{0x300f,0x63},
{0x3010,0x6f},
{0x3011,0x63},
{0x3014,0x6f},
{0x3015,0x63},
{0x3016,0x6f},
{0x3017,0x63},
{0x3018,0x6f},
{0x3019,0x63},
{0x301a,0x6f},
{0x301b,0x63},
{0xfe59,0x6f},
{0xfe5a,0x63},
{0xfe5b,0x6f},
{0xfe5c,0x63},
{0xfe5d,0x6f},
{0xfe5e,0x63},
{0xff08,0x6f},
{0xff09,0x63},
{0xff3b,0x6f},
{0xff3d,0x63},
{0xff5b,0x6f},
{0xff5d,0x63},
{0xff5f,0x6f},
{0xff60,0x63},
{0xff62,0x6f},
{0xff63,0x63},
}};

const TableView<char32_t, char32_t> bidi_paired_bracket_type_table {&bidi_paired_bracket_type_array[0], &bidi_paired_bracket_type_array[0] + bidi_paired_bracket_type_array.size()};

}
