macro(SET_FIND_LIBRARY_OPTIONS _prefixes _suffixes)
  set(_CMAKE_FIND_LIBRARY_PREFIXES "${CMAKE_FIND_LIBRARY_PREFIXES}")
  set(_CMAKE_FIND_LIBRARY_SUFFIXES "${CMAKE_FIND_LIBRARY_SUFFIXES}")
  
  set(CMAKE_FIND_LIBRARY_PREFIXES "${_prefixes}" CACHE INTERNAL "" FORCE )
  set(CMAKE_FIND_LIBRARY_SUFFIXES "${_suffixes}" CACHE INTERNAL "" FORCE ) 
endmacro()

macro(RESTORE_FIND_LIBRARY_OPTIONS)
  set(CMAKE_FIND_LIBRARY_PREFIXES "${_CMAKE_FIND_LIBRARY_PREFIXES}" CACHE INTERNAL "" FORCE)
  set(CMAKE_FIND_LIBRARY_SUFFIXES "${_CMAKE_FIND_LIBRARY_SUFFIXES}" CACHE INTERNAL "" FORCE)
endmacro()

macro(ADD_OPTION_GPROF DEFAULT)
  if (CMAKE_COMPILER_IS_GNUCXX)
      option(USE_GPROF "Compile using -pg for gprof output" ${DEFAULT})

      if(USE_GPROF)
          message(STATUS "Using gprof output for ${CMAKE_PROJECT_NAME}")
          set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -pg")
          set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -pg")
          set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -pg")
          set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -pg")
      else()
          message(STATUS "NOT using gprof output for ${CMAKE_PROJECT_NAME}")
      endif()
  else()
      message(STATUS "gprof generation NOT AVAILABLE - Not a GNU compiler")
  endif()
endmacro()
