// Copyright 2010 the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// This file contains 100.000 decimal representations of random doubles. They
// have been generated using Gay's dtoa to produce the precision representation:
//         dtoa(v, 2, number_digits, &decimal_point, &sign, nullptr);

#include "src/init/v8.h"

#include "test/cctest/gay-precision.h"

namespace v8 {
namespace internal {

static const PrecomputedPrecision kPrecisionTestNumbers[] = {
  {2.3024669636324308799278094e-83, 2, "23", -82},
  {1.2271034538374108029704385e+193, 17, "12271034538374108", 194},
  {1.9542561068988380481160711e+57, 10, "1954256107", 58},
  {4.0276324163778515192788466e-51, 8, "40276324", -50},
  {1.6914540254705166587262553e+102, 1, "2", 103},
  {7.6532541187326505614920874e+288, 20, "76532541187326505615", 289},
  {1.6567575133729817467289600e+23, 7, "1656758", 24},
  {6.3103204323996751932168403e-133, 14, "63103204323997", -132},
  {1.0472244069221818664582672e+169, 18, "104722440692218187", 170},
  {5.8195110602236590512695494e-298, 5, "58195", -297},
  {2.7233724244078238914410514e-56, 4, "2723", -55},
  {1.1924206821150524667712989e+122, 11, "11924206821", 123},
  {2.2261125060557557215910356e-269, 16, "2226112506055756", -268},
  {6.1889134327848623559372550e+67, 1, "6", 68},
  {1.5892233500643144375443996e-180, 12, "158922335006", -179},
  {3.6875321366835632698755802e+270, 17, "36875321366835633", 271},
  {2.3733845667315735338541208e+126, 9, "237338457", 127},
  {7.2670588501169592001027554e-53, 10, "726705885", -52},
  {4.9170455970883548626879892e-254, 13, "4917045597088", -253},
  {1.7981440481396788747093341e+135, 7, "1798144", 136},
  {4.1430797302555728231073948e-61, 6, "414308", -60},
  {5.3114308918428753258922370e+02, 17, "53114308918428753", 3},
  {7.9500621669844508713374803e+181, 15, "795006216698445", 182},
  {6.7617200906902767279304861e+261, 17, "67617200906902767", 262},
  {2.9307289920694830357794235e-165, 14, "29307289920695", -164},
  {1.7952648452345714728710963e+26, 13, "1795264845235", 27},
  {2.0083953360749408782218564e+130, 7, "2008395", 131},
  {4.2916111728112377929687500e+12, 14, "42916111728112", 13},
  {1.9928689004455980385166824e+254, 18, "199286890044559804", 255},
  {2.1123625338612581706154704e+225, 13, "2112362533861", 226},
  {4.8830731273424825138651316e+295, 3, "488", 296},
  {1.2191652349903613301670223e+266, 14, "12191652349904", 267},
  {3.6999315668495149604649834e-32, 19, "369993156684951496", -31},
  {1.5188088672905016683742083e-61, 21, "151880886729050166837", -60},
  {2.9348630805280859767947277e+00, 13, "2934863080528", 1},
  {7.7314672997715490821828045e+94, 21, "773146729977154908218", 95},
  {5.6083403200029747022331304e-247, 12, "560834032", -246},
  {7.7497965954812522289981797e-140, 9, "77497966", -139},
  {6.6856050260448473731649095e+215, 5, "66856", 216},
  {1.2418328974777711106675400e-71, 7, "1241833", -70},
  {1.3459985356642020430815130e-288, 1, "1", -287},
  {2.1915799176186182137773301e-203, 6, "219158", -202},
  {1.0326939090091490937354526e+93, 13, "1032693909009", 94},
  {1.5138888579768905066814077e-266, 13, "1513888857977", -265},
  {1.9996377568530313639953447e+64, 16, "1999637756853031", 65},
  {3.3062991029887976355874563e-180, 14, "33062991029888", -179},
  {1.2294404635676454931382885e+285, 10, "1229440464", 286},
  {5.2761955287208103465372414e+38, 4, "5276", 39},
  {3.4909843005387576688730017e+248, 15, "349098430053876", 249},
  {1.4600193475332589025877161e-281, 10, "1460019348", -280},
  {3.7238671987944088133934072e+270, 2, "37", 271},
  {2.7040969027475294676277237e+203, 1, "3", 204},
  {3.1238301655143934348145765e+264, 4, "3124", 265},
  {1.4579590332761703549188822e-141, 10, "1457959033", -140},
  {1.3152548731171278448870182e-07, 11, "13152548731", -6},
  {2.3885803367276874575258411e+198, 11, "23885803367", 199},
  {1.5782036194299332851526061e+189, 14, "15782036194299", 190},
  {3.7888196192099388695744884e-177, 8, "37888196", -176},
  {1.6732921916600566490413282e+135, 6, "167329", 136},
  {1.1319344519593492302111433e-245, 8, "11319345", -244},
  {1.4553280169944760665153016e-04, 11, "1455328017", -3},
  {4.6647991356133391154530551e-79, 17, "46647991356133391", -78},
  {2.7962420327426839019520000e+22, 4, "2796", 23},
  {2.0829699571275728970526811e-100, 15, "208296995712757", -99},
  {5.7108256846985638615179879e+268, 17, "57108256846985639", 269},
  {5.9438041766512519747909006e-44, 10, "5943804177", -43},
  {1.6553354253618068784832226e-13, 11, "16553354254", -12},
  {5.0792034330812282552570656e+219, 10, "5079203433", 220},
  {1.2275274992243392111070883e+289, 20, "12275274992243392111", 290},
  {8.1526240526777274628800507e+134, 20, "81526240526777274629", 135},
  {9.7885373748170129233448442e-151, 21, "978853737481701292334", -150},
  {1.5175607786756988810293008e+216, 4, "1518", 217},
  {1.5055659956013152037653756e-165, 17, "15055659956013152", -164},
  {6.5607111654594372584198757e-150, 11, "65607111655", -149},
  {1.7932790684967551874977491e-163, 12, "17932790685", -162},
  {1.9821715596658603095623018e+291, 6, "198217", 292},
  {1.0267594059913173148360320e-258, 6, "102676", -257},
  {2.3836006512497631667201786e-194, 9, "238360065", -193},
  {1.9362899175559093093853623e-79, 5, "19363", -78},
  {7.3625281122989054969937052e-291, 20, "7362528112298905497", -290},
  {2.9067292287821186952143865e+91, 15, "290672922878212", 92},
  {1.4793512167574492000000000e+16, 4, "1479", 17},
  {3.4103862617090174011013742e-136, 19, "3410386261709017401", -135},
  {4.2472726849679426643619274e-136, 18, "424727268496794266", -135},
  {9.0379988070056961683454404e-88, 15, "90379988070057", -87},
  {4.6114795705287448020898609e+227, 18, "46114795705287448", 228},
  {1.8629726428774103110268509e-278, 20, "1862972642877410311", -277},
  {3.1585260821472390924526589e-163, 2, "32", -162},
  {2.3453742411008844416317322e-141, 4, "2345", -140},
  {7.6597504120436647401728194e+200, 14, "76597504120437", 201},
  {8.0369107874406907392638566e-187, 20, "80369107874406907393", -186},
  {2.1631573385361605637398725e+235, 2, "22", 236},
  {1.7528390691506443790990035e-295, 1, "2", -294},
  {5.7630524098098487393989293e+237, 18, "576305240980984874", 238},
  {2.5540667845973345009373734e+36, 2, "26", 37},
  {3.0277467369268860302417182e+290, 5, "30277", 291},
  {1.5938108548705140243150408e-238, 17, "1593810854870514", -237},
  {2.2292455945420836302312301e+254, 4, "2229", 255},
  {1.5282263588616771875000000e+14, 11, "15282263589", 15},
  {5.4311888352508468366139627e-192, 8, "54311888", -191},
  {1.4612834386490569822890658e-240, 13, "1461283438649", -239},
  {3.5853426068817486690533561e-112, 16, "3585342606881749", -111},
  {2.5851668404204492638110794e+282, 7, "2585167", 283},
  {9.7833339930171263698071805e+278, 21, "978333399301712636981", 279},
  {2.5303775894667265360769771e-260, 21, "253037758946672653608", -259},
  {1.3278631312545150166419272e+128, 6, "132786", 129},
  {4.9176303300192645330870331e-287, 2, "49", -286},
  {5.7471660594172751910989609e-130, 5, "57472", -129},
  {2.5655142696562731891564806e-225, 8, "25655143", -224},
  {4.4718288364245362254909723e+206, 8, "44718288", 207},
  {4.2143924491569045358225109e+212, 9, "421439245", 213},
  {4.8214768601502697974086963e-106, 1, "5", -105},
  {2.3166454945162848889974429e-83, 19, "2316645494516284889", -82},
  {6.9818352999773524585281738e-97, 2, "7", -96},
  {1.5322862927763915187918899e-223, 18, "153228629277639152", -222},
  {1.8337256552559268723498319e-277, 1, "2", -276},
  {3.1949757056877905552897080e-286, 15, "319497570568779", -285},
  {5.2334925891806514421145900e-303, 8, "52334926", -302},
  {4.2397933975930834605650472e+241, 16, "4239793397593083", 242},
  {1.0287974590351816410215381e+46, 19, "1028797459035181641", 47},
  {2.4669310347076632472902549e+153, 6, "246693", 154},
  {2.3672887137932878098423359e-123, 5, "23673", -122},
  {1.0964154477099161492558111e-41, 11, "10964154477", -40},
  {1.5295024371357803357715677e-173, 5, "15295", -172},
  {1.2960075883806472670367262e-54, 13, "1296007588381", -53},
  {4.3783415307791511905477761e+106, 4, "4378", 107},
  {2.8397250995092657187812958e-45, 20, "28397250995092657188", -44},
  {3.4926435113382431269026662e-228, 16, "3492643511338243", -227},
  {1.6171030381303118763576321e+211, 2, "16", 212},
  {1.3318815650098664921492777e-63, 9, "133188157", -62},
  {3.8862210186865425299719981e+199, 15, "388622101868654", 200},
  {2.4315570067394405993841563e-41, 16, "2431557006739441", -40},
  {4.0530852201741314929526241e+68, 14, "40530852201741", 69},
  {8.1524942456057922620341187e-285, 2, "82", -284},
  {1.8478461668190198875395301e-18, 7, "1847846", -17},
  {8.5040705397523013194598685e+29, 11, "85040705398", 30},
  {9.1701664733270674617844118e-133, 18, "917016647332706746", -132},
  {7.0341156175263989558404590e+124, 21, "703411561752639895584", 125},
  {2.9579303536672631296003413e-117, 17, "29579303536672631", -116},
  {2.7342559436818562102922254e-25, 3, "273", -24},
  {3.1361469696535758888455815e+131, 10, "313614697", 132},
  {2.5527452729076293644957633e+254, 8, "25527453", 255},
  {9.9820714786650617441276991e-188, 14, "99820714786651", -187},
  {3.6571838526253739508170202e+133, 5, "36572", 134},
  {2.1439991334064125415065562e+263, 20, "21439991334064125415", 264},
  {2.7691891516865265877643639e-22, 18, "276918915168652659", -21},
  {2.1334103372345467838404774e+88, 11, "21334103372", 89},
  {4.0087518843710600846921259e-70, 14, "40087518843711", -69},
  {4.5057191122729767868974023e-305, 4, "4506", -304},
  {1.0473278711848223183025558e+121, 2, "1", 122},
  {1.6047196239146576000000000e+17, 21, "16047196239146576", 18},
  {3.2842790363402219520000000e+19, 16, "3284279036340222", 20},
  {3.3011839082268779726720411e+49, 19, "3301183908226877973", 50},
  {3.5524488971914461146209680e-121, 4, "3552", -120},
  {9.3645453466686285736468607e+219, 18, "936454534666862857", 220},
  {7.0104813432821121242350305e+265, 10, "7010481343", 266},
  {1.0619445753193927361857805e+205, 4, "1062", 206},
  {4.1863602757393668541110751e-111, 7, "418636", -110},
  {1.7315820675696728064000000e+19, 3, "173", 20},
  {6.7536303772024729600000000e+18, 16, "6753630377202473", 19},
  {4.8183795408314211822712804e-34, 16, "4818379540831421", -33},
  {9.9985664236304032551239570e-118, 2, "1", -116},
  {1.4694026914528593216677450e+257, 12, "146940269145", 258},
  {3.5645603483149065799664397e+187, 5, "35646", 188},
  {6.1987463825650669839283147e-276, 3, "62", -275},
  {1.5688509571326879387196221e+29, 18, "156885095713268794", 30},
  {3.6180770538862043395056389e+02, 1, "4", 3},
  {1.4952125037553337540480192e-56, 13, "1495212503755", -55},
  {1.5424978749940269014837876e+140, 8, "15424979", 141},
  {2.1912324444506835428888323e-222, 9, "219123244", -221},
  {2.6861068268688206672668457e+09, 4, "2686", 10},
  {2.2132415098877569881022729e-233, 18, "221324150988775699", -232},
  {1.5461619078362464790621828e-229, 5, "15462", -228},
  {1.7091675770146193651730871e-217, 14, "17091675770146", -216},
  {1.2655481031785394254133935e-174, 9, "12655481", -173},
  {2.2019828136248825133152136e-249, 16, "2201982813624883", -248},
  {2.6641823654765167329198483e+188, 13, "2664182365477", 189},
  {1.8386638959847941731339538e-62, 7, "1838664", -61},
  {9.3789847708144529513706771e-244, 7, "9378985", -243},
  {2.8968742182042179734329121e-58, 3, "29", -57},
  {4.4486429920398419536107678e+72, 9, "444864299", 73},
  {4.7286370052887201932731699e+156, 1, "5", 157},
  {2.1685434632593119362867832e+166, 4, "2169", 167},
  {5.2713817544629900952241304e+224, 8, "52713818", 225},
  {1.0750886811869889033802218e-172, 4, "1075", -171},
  {1.7881521561909617000111696e-128, 1, "2", -127},
  {8.2612365649984376651008774e-09, 15, "826123656499844", -8},
  {3.0659269027962132270204165e+01, 18, "306592690279621323", 2},
  {1.0257004968116448070582152e+203, 10, "1025700497", 204},
  {5.9570673631705455912711106e-272, 5, "59571", -271},
  {2.6365686143089448530216091e-294, 20, "2636568614308944853", -293},
  {1.3531961593964102457858458e+26, 19, "1353196159396410246", 27},
  {9.0079905923664457919849195e-263, 6, "900799", -262},
  {1.4299198189606970252968772e-129, 14, "14299198189607", -128},
  {2.0805418957077831142515569e+93, 14, "20805418957078", 94},
  {5.7466396964952557550465888e+190, 7, "574664", 191},
  {1.0372167315407058213434323e-67, 13, "1037216731541", -66},
  {2.9538391452730367739638067e+48, 17, "29538391452730368", 49},
  {1.9314758517125893245200249e+176, 2, "19", 177},
  {1.9285037841894596891538092e-248, 13, "1928503784189", -247},
  {3.6769745620665332738404270e+109, 20, "36769745620665332738", 110},
  {7.5299611947541506695796786e-28, 19, "752996119475415067", -27},
  {5.6540335834820418842111399e-148, 19, "5654033583482041884", -147},
  {1.4435936796986067287374286e-86, 1, "1", -85},
  {4.9593131840629578125000000e+13, 4, "4959", 14},
  {2.1779132118350692541944486e-200, 4, "2178", -199},
  {3.5974308822994829468019572e-26, 19, "3597430882299482947", -25},
  {2.6350657052632263558538254e+274, 15, "263506570526323", 275},
  {3.1496335914500373633431469e-06, 6, "314963", -5},
  {1.5829662412528247235443144e+299, 3, "158", 300},
  {1.6510322905680954034405342e-206, 1, "2", -205},
  {1.2578274708780377027868662e+178, 6, "125783", 179},
  {1.0944860844656250159998862e+113, 15, "109448608446563", 114},
  {7.3864858716613918657219408e-299, 4, "7386", -298},
  {7.2399349842634245045993245e-240, 5, "72399", -239},
  {3.2557998339989399896099690e+39, 3, "326", 40},
  {9.0636202671739879152112600e+117, 17, "90636202671739879", 118},
  {5.7383098177584941782274446e-166, 12, "573830981776", -165},
  {2.6035318557560247284976854e+203, 14, "2603531855756", 204},
  {3.1701773256352779759829668e+30, 9, "317017733", 31},
  {2.0712254158825995350308271e-23, 20, "2071225415882599535", -22},
  {3.9912456780196638866931025e-03, 10, "3991245678", -2},
  {2.1455418392802322388609769e+184, 10, "2145541839", 185},
  {1.3610104590390237593789248e-281, 15, "136101045903902", -280},
  {2.4092255356620283770867475e-207, 19, "2409225535662028377", -206},
  {5.8672951433643968582629252e+53, 5, "58673", 54},
  {6.8608734134076288969323766e+205, 19, "6860873413407628897", 206},
  {1.3663690821635593182450424e+253, 18, "136636908216355932", 254},
  {2.1841890235713401867124734e-213, 8, "2184189", -212},
  {9.4037268560009376921811427e+85, 10, "9403726856", 86},
  {4.6106495002123060317185621e+95, 5, "46106", 96},
  {5.5252119899677070957686189e+90, 1, "6", 91},
  {4.3255683526337411367929149e-183, 17, "43255683526337411", -182},
  {1.7604959765486607666219872e+59, 10, "1760495977", 60},
  {1.8599843308893806953257554e-170, 10, "1859984331", -169},
  {1.5839589129109327923016621e+284, 9, "158395891", 285},
  {2.0417992144557787655292524e-223, 3, "204", -222},
  {2.5238698705815739727074964e+69, 4, "2524", 70},
  {4.9064955722675923962050411e-187, 5, "49065", -186},
  {3.5300941656158408535976118e+121, 19, "3530094165615840854", 122},
  {7.5453543030983126024445649e+147, 20, "75453543030983126024", 148},
  {2.6134379288854274543639492e-240, 11, "26134379289", -239},
  {6.5539932562927263730221711e+27, 19, "6553993256292726373", 28},
  {1.3631262367554623464401749e-40, 10, "1363126237", -39},
  {1.3891744899431735346349066e+128, 2, "14", 129},
  {2.9116903463547217584217954e-147, 13, "2911690346355", -146},
  {3.9350871877615033315179209e-218, 3, "394", -217},
  {1.9706238831943163107297065e+38, 15, "197062388319432", 39},
  {2.0168736224848082225457208e-182, 8, "20168736", -181},
  {8.6377508564490800759297805e-94, 6, "863775", -93},
  {1.2934345427734508653772800e+23, 13, "1293434542773", 24},
  {1.0269902614576889986929160e+96, 20, "10269902614576889987", 97},
  {9.1608616474856846911361123e+108, 7, "9160862", 109},
  {3.9401268249392208546249426e-308, 9, "394012682", -307},
  {1.0034264973466462736014241e+55, 18, "100342649734664627", 56},
  {1.0149828976701485064964498e-245, 9, "10149829", -244},
  {5.5237722087660123648718047e+177, 6, "552377", 178},
  {1.0131318292024524973865690e+46, 17, "10131318292024525", 47},
  {1.3242693619416466185394983e-170, 5, "13243", -169},
  {3.8377504791031817701660835e-91, 5, "38378", -90},
  {2.0683780395258056849362256e+232, 18, "206837803952580568", 233},
  {6.3894953759518899747219313e+153, 2, "64", 154},
  {2.5516677123933556335391560e-265, 12, "255166771239", -264},
  {6.0735454429934270039046377e+264, 18, "6073545442993427", 265},
  {1.0558716914998955815671097e+206, 12, "10558716915", 207},
  {3.6090831208672276217244839e+290, 8, "36090831", 291},
  {3.1915615467201051042686476e+219, 5, "31916", 220},
  {6.6745813949196983073730292e+288, 8, "66745814", 289},
  {2.9634106138905730335406414e-87, 20, "29634106138905730335", -86},
  {4.4775123576567524275262713e-178, 19, "4477512357656752428", -177},
  {4.9474911838512324026181982e+153, 21, "494749118385123240262", 154},
  {3.2735724205956634207581504e-06, 19, "3273572420595663421", -5},
  {6.7878433334912694918775300e+135, 15, "678784333349127", 136},
  {2.3565363557190159868963685e-234, 13, "2356536355719", -233},
  {1.2434622168902812847727951e-69, 3, "124", -68},
  {1.4571091669779827105208761e+180, 2, "15", 181},
  {2.0819162708713953812925842e-11, 11, "20819162709", -10},
  {1.7872336597668013724209810e+123, 12, "178723365977", 124},
  {2.9918735580552276013106271e-175, 7, "2991874", -174},
  {1.6993333322473085790761967e-155, 7, "1699333", -154},
  {9.4220826891847220711736658e-89, 10, "9422082689", -88},
  {4.6195384056464833261987144e-84, 2, "46", -83},
  {2.3000140803890525738085795e-278, 15, "230001408038905", -277},
  {9.2253601538172670118569904e-262, 21, "922536015381726701186", -261},
  {1.9797021147741060879979916e-86, 12, "197970211477", -85},
  {5.2468397477928567894493631e+300, 11, "52468397478", 301},
  {1.0162695712814010427083696e-50, 21, "101626957128140104271", -49},
  {1.9038878028370981325254491e+178, 1, "2", 179},
  {2.3217483811549038053721014e-174, 6, "232175", -173},
  {4.3602453488855990061578780e-150, 4, "436", -149},
  {1.4353827048634542062899300e+00, 13, "1435382704863", 1},
  {2.5098028160483423893671265e-247, 12, "250980281605", -246},
  {4.6984258388539640732872107e+214, 1, "5", 215},
  {1.0274973118612931651286603e-46, 10, "1027497312", -45},
  {1.5769046036524691460588231e+39, 5, "15769", 40},
  {2.7527781313655267785123473e+140, 3, "275", 141},
  {4.6099215472719019079304927e-286, 16, "4609921547271902", -285},
  {9.9239257813776284966526484e-284, 13, "9923925781378", -283},
  {3.2566318112902602075536403e+203, 19, "3256631811290260208", 204},
  {5.3607923611368304000000000e+16, 18, "53607923611368304", 17},
  {3.8770713300570767814432439e+297, 3, "388", 298},
  {6.4124811358966513596564713e-133, 3, "641", -132},
  {2.2381502934423936487033576e-96, 1, "2", -95},
  {8.1166235508077403551236359e-54, 8, "81166236", -53},
  {8.5002432511711367088884642e-56, 6, "850024", -55},
  {1.5575056832174283623360969e-306, 18, "155750568321742836", -305},
  {6.2409098087540424671947005e-286, 17, "62409098087540425", -285},
  {5.5154420220156951184288882e+218, 12, "551544202202", 219},
  {6.3021050028555912634505317e-199, 11, "63021050029", -198},
  {7.5946128007898228638566947e-36, 5, "75946", -35},
  {7.1095350018484020280793973e-256, 4, "711", -255},
  {5.6642031802955696988236663e-200, 1, "6", -199},
  {6.1453542987293702535839934e+192, 13, "6145354298729", 193},
  {1.1969748875756475936209738e-88, 4, "1197", -87},
  {6.0872632493647162616589426e-261, 21, "608726324936471626166", -260},
  {3.3529376476600145997791434e-12, 14, "335293764766", -11},
  {2.3720663172754777067516202e+170, 3, "237", 171},
  {7.9867934315443277623736206e-117, 4, "7987", -116},
  {7.4094830033244203893813580e+256, 3, "741", 257},
  {6.6300436486341399866058992e-206, 13, "6630043648634", -205},
  {5.7087166122980289870575802e-14, 5, "57087", -13},
  {1.1160195520310365692102680e-13, 7, "111602", -12},
  {2.7933279985861187537632333e+60, 12, "279332799859", 61},
  {7.4712252221172874867582805e+223, 15, "747122522211729", 224},
  {3.1739663622306891855924782e+286, 19, "3173966362230689186", 287},
  {5.2081377404692609360935359e+98, 2, "52", 99},
  {3.1596464770012267332311687e+258, 11, "3159646477", 259},
  {1.9431608870885562209078176e-74, 5, "19432", -73},
  {1.5491889951409416418902231e-113, 4, "1549", -112},
  {3.7160109208062209352911313e-26, 16, "3716010920806221", -25},
  {2.0645835512807359101701980e+27, 18, "206458355128073591", 28},
  {5.1630027286728384509488349e-53, 7, "5163003", -52},
  {3.2104859793161713277241610e+230, 20, "32104859793161713277", 231},
  {6.7107646743857816288305202e+30, 19, "6710764674385781629", 31},
  {9.7659162749949820161829776e+199, 1, "1", 201},
  {3.5966899434257512659590502e+197, 16, "3596689943425751", 198},
  {3.0450946851083747575656559e-146, 4, "3045", -145},
  {1.5191501144100129681974524e+82, 7, "151915", 83},
  {2.6440351948680949755141571e+45, 2, "26", 46},
  {2.6235996981959264561866608e+52, 12, "26235996982", 53},
  {4.1200448254504535826220170e+117, 17, "41200448254504536", 118},
  {2.2627757765878636305774334e-191, 2, "23", -190},
  {4.9844512144685746797487314e+252, 17, "49844512144685747", 253},
  {9.5154481326327377730504163e-55, 20, "95154481326327377731", -54},
  {1.9970895361968177183948440e-25, 8, "19970895", -24},
  {5.3251055436087622466168422e+26, 11, "53251055436", 27},
  {5.9018515597975501965608310e-259, 4, "5902", -258},
  {3.7964641623812784183754820e-224, 12, "379646416238", -223},
  {3.5863697537967170185769707e-221, 14, "35863697537967", -220},
  {3.7253704575105917762761263e+205, 4, "3725", 206},
  {4.8810688652375602593528809e-260, 5, "48811", -259},
  {1.6594570474339338993638635e+279, 2, "17", 280},
  {3.9093411778514540196298563e-162, 8, "39093412", -161},
  {7.2168559113506486794855825e-75, 20, "72168559113506486795", -74},
  {7.9473093684552553032799550e+77, 20, "79473093684552553033", 78},
  {1.2939992157021042632789823e-156, 20, "12939992157021042633", -155},
  {3.8395687835301181242321650e-295, 10, "3839568784", -294},
  {6.4489287166483208059890095e-15, 9, "644892872", -14},
  {8.4601575715944999190766039e+209, 7, "8460158", 210},
  {3.8806152647686587710017764e-58, 10, "3880615265", -57},
  {7.1686559845129837617907711e-256, 2, "72", -255},
  {4.0187130627344573361974756e-13, 12, "401871306273", -12},
  {6.3911642695244233104994101e-46, 4, "6391", -45},
  {1.5059413319521746734706799e+109, 10, "1505941332", 110},
  {3.4716471797330561671092397e-88, 11, "34716471797", -87},
  {3.5495609681721976829468678e-224, 19, "3549560968172197683", -223},
  {5.7735498685340135360521147e+165, 14, "5773549868534", 166},
  {3.0223601812864263164383146e+137, 19, "3022360181286426316", 138},
  {2.5041168350273741302517786e-39, 12, "250411683503", -38},
  {5.3495182756622937180500771e-238, 13, "5349518275662", -237},
  {2.5090486089535811964376121e+144, 15, "250904860895358", 145},
  {1.4296742579252460186021645e+213, 6, "142967", 214},
  {3.2281171174802800763693421e+34, 3, "323", 35},
  {6.1557604081169012571253836e+221, 9, "615576041", 222},
  {5.1265092809241914570524224e-14, 14, "51265092809242", -13},
  {8.7984927881645098650516874e+268, 8, "87984928", 269},
  {2.6677240180899265289306641e+10, 21, "266772401808992652893", 11},
  {4.6461441877145727630704641e+04, 15, "464614418771457", 5},
  {2.5267014437679144431328580e-201, 19, "2526701443767914443", -200},
  {1.6195295923182359105467777e+33, 12, "161952959232", 34},
  {2.8493143822424077989358516e-301, 13, "2849314382242", -300},
  {1.5686135456081225735821351e-36, 12, "156861354561", -35},
  {2.1548022234050276163964786e+248, 21, "21548022234050276164", 249},
  {3.7664902500758127106301338e-259, 15, "376649025007581", -258},
  {5.5073051953868127256468536e+136, 5, "55073", 137},
  {1.9774673589496746463178269e+268, 17, "19774673589496746", 269},
  {1.3399394736762729649412775e-139, 17, "1339939473676273", -138},
  {1.0420640797537323285627306e-32, 4, "1042", -31},
  {2.2554957900586576694198495e-200, 15, "225549579005866", -199},
  {1.3212463878200511518620058e+244, 11, "13212463878", 245},
  {7.6819375184475002663986624e-48, 13, "7681937518448", -47},
  {3.0778581339066406406723340e-28, 7, "3077858", -27},
  {6.2880067457590098754678923e-286, 4, "6288", -285},
  {2.5199742384763087904681838e+161, 20, "25199742384763087905", 162},
  {2.3850006574033587623176053e+40, 1, "2", 41},
  {1.0798699265968548241789850e+236, 6, "107987", 237},
  {5.1230025571934723327370561e-19, 5, "5123", -18},
  {2.6934682029129621508238100e-262, 6, "269347", -261},
  {3.2599898124078175155999721e-09, 15, "325998981240782", -8},
  {3.0694119868217959410444722e+277, 13, "3069411986822", 278},
  {5.8096367945722537696145876e-211, 2, "58", -210},
  {4.3368191205129512120832383e+83, 5, "43368", 84},
  {3.3905623643000412016294418e-214, 3, "339", -213},
  {7.2987058645539189804976938e-296, 2, "73", -295},
  {8.8787317495990787080124165e+160, 19, "8878731749599078708", 161},
  {5.2883627213085489548149261e-85, 3, "529", -84},
  {3.2572876130271994526849994e-274, 6, "325729", -273},
  {9.6262102545178051559116800e-211, 1, "1", -209},
  {2.2281291905300523250939292e+130, 19, "2228129190530052325", 131},
  {4.5588998558426585231435761e+238, 12, "455889985584", 239},
  {1.7628023838050470883522542e+123, 7, "1762802", 124},
  {4.1003724395161169935966364e-121, 18, "410037243951611699", -120},
  {5.6577801440607663859661467e-308, 6, "565778", -307},
  {2.0190930714083442071295738e-78, 7, "2019093", -77},
  {2.9308363520461595679698134e+296, 15, "293083635204616", 297},
  {4.7991882161065503446043975e-17, 21, "47991882161065503446", -16},
  {4.3815847969147206844324919e-284, 15, "438158479691472", -283},
  {1.3218691830275292602034012e-33, 17, "13218691830275293", -32},
  {3.4867568244993849385368464e-223, 13, "3486756824499", -222},
  {5.9333886258418860690964743e+255, 8, "59333886", 256},
  {1.5024849462996962639397540e+30, 18, "150248494629969626", 31},
  {2.9720844385701630041922934e-79, 16, "2972084438570163", -78},
  {1.2991226262852837403260514e-227, 7, "1299123", -226},
  {4.4133039119668524564802703e+260, 21, "441330391196685245648", 261},
  {7.7166540638394122337563721e-100, 9, "771665406", -99},
  {5.5441532585749114669067932e+92, 17, "55441532585749115", 93},
  {6.9223199070375288536180963e-171, 20, "69223199070375288536", -170},
  {3.6980925128715197710969553e-295, 13, "3698092512872", -294},
  {2.0532509847326062522335490e+271, 20, "20532509847326062522", 272},
  {3.9477538697426865222311621e-132, 9, "394775387", -131},
  {7.1701287002742330332870237e+73, 14, "71701287002742", 74},
  {6.7110119542899396037682891e+04, 21, "671101195428993960377", 5},
  {1.0684850698114450678058313e+234, 17, "10684850698114451", 235},
  {1.6291509948013389483094215e+07, 11, "16291509948", 8},
  {4.5785466308983029450442566e-30, 20, "4578546630898302945", -29},
  {1.6801883758542338035994880e+93, 20, "16801883758542338036", 94},
  {5.1380571081533660427103702e-40, 4, "5138", -39},
  {1.5614971276372007501373758e-260, 4, "1561", -259},
  {1.6560780005783320962167967e-288, 12, "165607800058", -287},
  {3.6177804648281290061013170e-120, 6, "361778", -119},
  {1.5459219738418466041250587e+66, 17, "15459219738418466", 67},
  {1.0679537386393355339843254e-107, 16, "1067953738639336", -106},
  {8.8848268067722928384664441e+164, 5, "88848", 165},
  {7.5641909747027547289637735e-90, 1, "8", -89},
  {2.0157389431230346920132503e+155, 21, "201573894312303469201", 156},
  {8.5521486726269479561577212e+53, 9, "855214867", 54},
  {3.1677625730957059979814802e+213, 4, "3168", 214},
  {5.8687179514190130141582197e-219, 15, "586871795141901", -218},
  {1.1921734285279776284463664e-142, 9, "119217343", -141},
  {2.6989602353151684440647629e-230, 14, "26989602353152", -229},
  {1.0079545811443198431062357e-308, 14, "10079545811443", -307},
  {2.4558711211064379008325459e+66, 11, "24558711211", 67},
  {4.5830397551059383247353471e-253, 12, "458303975511", -252},
  {5.4419181033922297400088488e-170, 15, "544191810339223", -169},
  {1.6457070336106948851718921e+163, 15, "164570703361069", 164},
  {5.7127042513134304997387132e+128, 13, "5712704251313", 129},
  {5.0649007571530600710081182e+207, 7, "5064901", 208},
  {1.8257904064239951427756460e+137, 18, "182579040642399514", 138},
  {1.6639193887184801144621540e-216, 14, "16639193887185", -215},
  {5.3557913793244962435673615e-43, 9, "535579138", -42},
  {1.4132746294786512917228212e-157, 14, "14132746294787", -156},
  {1.4322879757512842346812765e+145, 17, "14322879757512842", 146},
  {4.5871523717103219456920785e-208, 8, "45871524", -207},
  {9.7694778032292502061187076e-135, 10, "9769477803", -134},
  {6.9364325092169274807400635e+29, 15, "693643250921693", 30},
  {2.8969388878287640064005480e+189, 4, "2897", 190},
  {1.2682525934383380610745511e-27, 8, "12682526", -26},
  {1.9930344860522043313789030e+282, 18, "199303448605220433", 283},
  {4.2179000916853445345321728e-218, 2, "42", -217},
  {9.8168674620955327510554255e+61, 15, "981686746209553", 62},
  {7.4416157278074979451638637e+226, 20, "74416157278074979452", 227},
  {5.9342628701217088171109159e+209, 17, "59342628701217088", 210},
  {7.2961908470020539293537634e+86, 2, "73", 87},
  {2.1528810674091343349259161e-125, 6, "215288", -124},
  {1.6348999855221982661970255e+112, 7, "16349", 113},
  {2.3024141283491270677124559e+185, 19, "2302414128349127068", 186},
  {2.6143700730628535391401646e-252, 2, "26", -251},
  {1.1634940038301654958625011e-79, 16, "1163494003830165", -78},
  {2.6590511134852027907982119e+02, 15, "26590511134852", 3},
  {1.2360906344567300410077684e-152, 9, "123609063", -151},
  {4.6131734660162538154814692e+95, 14, "46131734660163", 96},
  {6.5214310864662109619260561e+240, 19, "6521431086466210962", 241},
  {1.2326348265974124963379488e-225, 12, "12326348266", -224},
  {1.9369762529148998956580690e+279, 20, "19369762529148998957", 280},
  {4.5258708886429289736447202e-220, 2, "45", -219},
  {2.3632390920943861116417244e-95, 3, "236", -94},
  {6.3064983967623049249577431e-269, 10, "6306498397", -268},
  {1.5100896134638266583332795e+298, 2, "15", 299},
  {6.1790631514550008823344619e+209, 10, "6179063151", 210},
  {6.9529943691121041347390897e-47, 2, "7", -46},
  {1.7980435144746230881188951e+57, 4, "1798", 58},
  {2.9662291360098766151708549e-80, 19, "2966229136009876615", -79},
  {5.7219924674080132574647977e+219, 5, "5722", 220},
  {5.2311175454260219330266025e-70, 1, "5", -69},
  {5.4333171210728295166272823e-214, 17, "54333171210728295", -213},
  {7.2325593902387431495579276e+223, 20, "72325593902387431496", 224},
  {2.7695099325673656525638421e+301, 19, "2769509932567365653", 302},
  {2.4120560052022578770134088e-281, 13, "2412056005202", -280},
  {1.7731969730298572047724422e+42, 1, "2", 43},
  {1.7835900802650638133754937e-261, 16, "1783590080265064", -260},
  {1.6274970486185898514890926e+34, 18, "162749704861858985", 35},
  {6.9988570631018097749685576e-258, 10, "6998857063", -257},
  {3.3360146975175667594967471e-105, 20, "33360146975175667595", -104},
  {1.4941170910316488638052839e+242, 20, "14941170910316488638", 243},
  {8.8603722151936311387896655e-214, 14, "88603722151936", -213},
  {1.3415092574982752449874803e-206, 2, "13", -205},
  {3.5914480642649481137849281e+96, 9, "359144806", 97},
  {6.1340222352354631527903409e+144, 10, "6134022235", 145},
  {9.1109791309187005056665472e-212, 14, "91109791309187", -211},
  {1.6057540562001991014437368e-29, 5, "16058", -28},
  {5.3453944681573530651958173e+292, 1, "5", 293},
  {1.0652000914897530540703426e-99, 15, "106520009148975", -98},
  {4.3074248613431364198955569e-199, 17, "43074248613431364", -198},
  {1.8660344284443924629118854e+305, 3, "187", 306},
  {3.5654660220977058114821814e-174, 11, "35654660221", -173},
  {5.1174941042570371678822578e+300, 6, "511749", 301},
  {3.3505254909843961076601389e+156, 19, "3350525490984396108", 157},
  {1.4011938054587806878571380e+79, 12, "140119380546", 80},
  {9.0131243548674090411542201e+220, 4, "9013", 221},
  {5.6650218079717512262910657e+157, 11, "5665021808", 158},
  {2.7211591911468446600428579e+254, 16, "2721159191146845", 255},
  {1.8169935424449720729705878e-12, 9, "181699354", -11},
  {7.2216258973958658186128892e-56, 19, "7221625897395865819", -55},
  {2.1612446600693736964113335e+161, 6, "216124", 162},
  {4.3556195877352639599905357e-28, 19, "435561958773526396", -27},
  {1.0710140876606004122437777e+142, 9, "107101409", 143},
  {5.1525487695550764034486561e+43, 2, "52", 44},
  {5.1365457878229613953460416e-162, 18, "51365457878229614", -161},
  {8.8315901165986687362414911e-59, 19, "8831590116598668736", -58},
  {3.3469753683270187296645441e-222, 17, "33469753683270187", -221},
  {1.9056148954355797272161491e+201, 12, "190561489544", 202},
  {1.6082575778432351619469616e+224, 2, "16", 225},
  {1.3779639011396719517559846e-226, 12, "137796390114", -225},
  {2.6477655605830199278951394e-209, 14, "2647765560583", -208},
  {6.7484918784972743551001069e-220, 16, "6748491878497274", -219},
  {8.1347968546690425511555872e-208, 14, "8134796854669", -207},
  {7.0627202877843638272838524e-70, 2, "71", -69},
  {4.6205532623310251630991564e-269, 1, "5", -268},
  {5.2234255856714901639029686e+261, 21, "52234255856714901639", 262},
  {2.6522512050059083856813775e-188, 10, "2652251205", -187},
  {1.0594521823990938387720402e-204, 7, "1059452", -203},
  {3.8552110428564752403180387e+294, 19, "385521104285647524", 295},
  {1.3414618152035682440606499e-190, 10, "1341461815", -189},
  {2.4170709854278133766753857e+212, 10, "2417070985", 213},
  {3.1371645759657836338262608e+219, 17, "31371645759657836", 220},
  {1.1998030103041256964206696e+08, 1, "1", 9},
  {3.1849224165810225531458855e+06, 7, "3184922", 7},
  {3.2585884233132819623024857e-208, 20, "32585884233132819623", -207},
  {4.1722882943167094442039960e+177, 1, "4", 178},
  {1.5679312774170047325511723e-242, 4, "1568", -241},
  {4.1367188047471383914274310e+183, 20, "41367188047471383914", 184},
  {2.0192156097039772522811339e+185, 3, "202", 186},
  {2.1404509873787233723795552e-07, 3, "214", -6},
  {2.0180921488397775713751853e+113, 10, "2018092149", 114},
  {3.6116693903137897141277790e+06, 7, "3611669", 7},
  {1.1102534241025882872171310e+157, 18, "111025342410258829", 158},
  {2.7939439779151391848237709e-55, 21, "279394397791513918482", -54},
  {1.4157607775432476597280852e-114, 4, "1416", -113},
  {2.4944176434221716659902067e+115, 20, "2494417643422171666", 116},
  {4.8393029074277562652607684e+178, 20, "48393029074277562653", 179},
  {2.6340667396560383414262491e-82, 13, "2634066739656", -81},
  {6.2151775304685938432347137e+271, 15, "621517753046859", 272},
  {4.9619702075358094109577212e+184, 12, "496197020754", 185},
  {1.4274238324397544971088427e+125, 3, "143", 126},
  {3.5164025287977509813060132e-259, 3, "352", -258},
  {5.3238226373627740714760113e-209, 11, "53238226374", -208},
  {5.3175004825293256401998215e+163, 4, "5318", 164},
  {1.0844020130188885913774605e+274, 6, "10844", 275},
  {2.8617322968364713306572082e-29, 6, "286173", -28},
  {7.4807767137122367413434246e-50, 19, "7480776713712236741", -49},
  {3.9738266704344001059278854e-101, 21, "397382667043440010593", -100},
  {9.8757249906979557324589302e-201, 18, "987572499069795573", -200},
  {4.8062245050599626336866753e-169, 12, "480622450506", -168},
  {2.4966554584866018428778577e+229, 16, "2496655458486602", 230},
  {5.3079855065544283933918310e+256, 21, "530798550655442839339", 257},
  {2.9106869855766020926882227e+54, 21, "291068698557660209269", 55},
  {8.2939325666465993867655620e+129, 17, "82939325666465994", 130},
  {1.2319457203778255345453582e-15, 6, "123195", -14},
  {2.6886582449380013387724046e+76, 8, "26886582", 77},
  {4.7167336819700550622657259e+184, 9, "471673368", 185},
  {7.6153660750746547869810646e+185, 8, "76153661", 186},
  {4.3175168953800457715988159e+08, 7, "4317517", 9},
  {3.8271217794880045919750255e-74, 14, "3827121779488", -73},
  {1.0933102594939983374566314e+82, 2, "11", 83},
  {7.8341756578683792874550250e+184, 3, "783", 185},
  {1.7034368506131375627990003e-49, 3, "17", -48},
  {4.7033021889482123469956916e-21, 2, "47", -20},
  {7.5436099093305219888049002e-220, 3, "754", -219},
  {4.2211394776727935525710012e-304, 19, "4221139477672793553", -303},
  {1.8097118088354062248162782e-163, 8, "18097118", -162},
  {1.0201937104210139359669928e-121, 5, "10202", -120},
  {3.4783267714166063293261132e-185, 16, "3478326771416606", -184},
  {2.7245016987132265285497208e+180, 15, "272450169871323", 181},
  {4.0598251123119479835902928e-158, 12, "405982511231", -157},
  {1.5871255306233429576864995e+139, 12, "158712553062", 140},
  {1.0178231869938851510056484e+39, 11, "1017823187", 40},
  {6.9068734276862472257889717e+251, 17, "69068734276862472", 252},
  {1.3088267551691466628205730e+268, 20, "13088267551691466628", 269},
  {7.8104015639704396421525094e+47, 7, "7810402", 48},
  {3.0876120039068319719743784e-153, 3, "309", -152},
  {3.8412790807641549928213781e+231, 11, "38412790808", 232},
  {5.2807824777996741064825270e+42, 12, "52807824778", 43},
  {1.4294075601482837694412188e-143, 18, "142940756014828377", -142},
  {2.2989091826599450496245336e+55, 11, "22989091827", 56},
  {1.1582002318880319367677904e-11, 4, "1158", -10},
  {9.1367221040065968722031553e-206, 12, "913672210401", -205},
  {1.9497408090139383315888021e+87, 5, "19497", 88},
  {7.0305341520432201665549332e-139, 11, "7030534152", -138},
  {5.5124848918162767516238375e+156, 20, "55124848918162767516", 157},
  {5.7787410841347371286828385e-86, 8, "57787411", -85},
  {5.8614484096453775455591341e+119, 21, "586144840964537754556", 120},
  {2.0702531427393829505496264e-122, 11, "20702531427", -121},
  {2.8047235023390712740365416e+04, 12, "280472350234", 5},
  {4.8137403994564256990583360e+119, 20, "48137403994564256991", 120},
  {3.6724773508547158280330841e+134, 14, "36724773508547", 135},
  {4.1242716187065606810456508e+138, 14, "41242716187066", 139},
  {2.2638102512587797161014460e+28, 12, "226381025126", 29},
  {1.2317043755577052444751423e+271, 12, "123170437556", 272},
  {8.5875410984931922905462763e-209, 15, "858754109849319", -208},
  {1.8802335974859765018587927e-130, 5, "18802", -129},
  {2.8665786000294619018236442e-236, 2, "29", -235},
  {1.5683183006429487276913159e-08, 3, "157", -7},
  {3.4147741994672017346946888e-140, 16, "3414774199467202", -139},
  {2.2349968521379340309648046e-37, 2, "22", -36},
  {1.2521599889115607658530739e+30, 18, "125215998891156077", 31},
  {1.2919115524771869723103842e+68, 3, "129", 69},
  {6.3636830579067895037364092e-280, 7, "6363683", -279},
  {7.1807482222202596041364210e+143, 13, "718074822222", 144},
  {1.7993233262057132784053225e+225, 2, "18", 226},
  {2.4819778003217326778794925e-241, 2, "25", -240},
  {4.1606664489799306587013763e+128, 19, "4160666448979930659", 129},
  {1.7243589072418612415116939e-22, 9, "172435891", -21},
  {1.3000769060512584110256284e+05, 14, "13000769060513", 6},
  {1.4698780426550940599893039e+187, 13, "1469878042655", 188},
  {5.3406723448704811744391918e+04, 17, "53406723448704812", 5},
  {5.4068143310331604288955924e-120, 6, "540681", -119},
  {5.4954728076780157545576216e+141, 21, "549547280767801575456", 142},
  {5.5555834357786861568000000e+19, 14, "55555834357787", 20},
  {3.7550461951542555597192923e-306, 5, "3755", -305},
  {1.4715079149344139642391707e-83, 14, "14715079149344", -82},
  {1.4565711830055474382957295e-155, 8, "14565712", -154},
  {4.5447967246774113821000459e-299, 7, "4544797", -298},
  {6.0828555828834021480217920e-289, 13, "6082855582883", -288},
  {6.8849874905713580585333296e-13, 4, "6885", -12},
  {2.1297670082789601990134420e+279, 19, "2129767008278960199", 280},
  {7.9672183452908481174489076e-88, 2, "8", -87},
  {5.4069183116152356202593601e+259, 10, "5406918312", 260},
  {3.7059164871326728832502868e-22, 11, "37059164871", -21},
  {1.6262025928271740136367427e+130, 20, "16262025928271740136", 131},
  {2.6692676321124222002552278e-87, 3, "267", -86},
  {7.0017731250101102971785223e-231, 14, "70017731250101", -230},
  {4.7433114775648028092289215e-222, 5, "47433", -221},
  {1.0373879136180818484408569e-65, 16, "1037387913618082", -64},
  {3.2982899055702459222477144e-53, 8, "32982899", -52},
  {2.4921442322957782751759719e+151, 18, "249214423229577828", 152},
  {2.1859869855068841632483027e+165, 14, "21859869855069", 166},
  {8.9009518236457391006863685e+105, 14, "89009518236457", 106},
  {9.9115611776252224866284989e+152, 16, "9911561177625222", 153},
  {7.1489497235842354010078180e-236, 7, "714895", -235},
  {1.8960624595624904993285107e-37, 18, "18960624595624905", -36},
  {3.0716361765005012936973209e+177, 6, "307164", 178},
  {2.7806530267148892992440917e+55, 19, "2780653026714889299", 56},
  {1.8757337418007061441176670e+268, 3, "188", 269},
  {4.6162398747301382382313065e+269, 7, "461624", 270},
  {1.5272524970234090888008929e+161, 9, "15272525", 162},
  {1.3081761826663272071882966e+74, 19, "1308176182666327207", 75},
  {2.7947666728568103189943183e-22, 15, "279476667285681", -21},
  {8.0372604391654256579610525e-222, 4, "8037", -221},
  {3.3749250737078897827374053e+146, 21, "337492507370788978274", 147},
  {2.6573053288431120533646427e-58, 20, "26573053288431120534", -57},
  {1.8700801313850039600403674e+120, 5, "18701", 121},
  {6.4164696490806304034528621e-231, 12, "641646964908", -230},
  {7.4720531933171259765625000e+12, 5, "74721", 13},
  {2.2549059680083581676635847e-25, 17, "22549059680083582", -24},
  {2.4982924033562978295316736e-83, 12, "249829240336", -82},
  {2.6693683912185125201249401e+304, 8, "26693684", 305},
  {2.7541966084918804983729670e+45, 11, "27541966085", 46},
  {9.8008733279223902626684352e+254, 4, "9801", 255},
  {2.7615332223092929656688255e+241, 6, "276153", 242},
  {1.3555063331870467147235437e+167, 10, "1355506333", 168},
  {7.7698755122559527412629618e+87, 2, "78", 88},
  {1.8875053163480641972121092e+154, 10, "1887505316", 155},
  {3.0728479778034720453808318e+282, 15, "307284797780347", 283},
  {4.9858683236043904310313026e-42, 1, "5", -41},
  {1.1144151401091318661449808e+235, 8, "11144151", 236},
  {4.8963478332035054673016469e-24, 5, "48963", -23},
  {6.4115434322481601547370254e+106, 14, "64115434322482", 107},
  {7.4687894267981625336932216e+104, 18, "746878942679816253", 105},
  {2.5071734667049687125267655e-304, 17, "25071734667049687", -303},
  {1.4927888223495150190325854e+116, 7, "1492789", 117},
  {5.1613199589531994374436814e+107, 19, "5161319958953199437", 108},
  {5.0558865651822129182861910e-12, 16, "5055886565182213", -11},
  {6.1416595323725686770825581e-277, 8, "61416595", -276},
  {2.3126681082872433232761030e+200, 5, "23127", 201},
  {1.8194490560929730699615112e-162, 9, "181944906", -161},
  {3.8656217746563228778600493e+274, 7, "3865622", 275},
  {1.0267095321303313808404468e+107, 18, "102670953213033138", 108},
  {1.2435093528434508803927471e-60, 2, "12", -59},
  {1.1191084863733200844583076e+27, 11, "11191084864", 28},
  {2.6375481717066639397778251e+254, 15, "263754817170666", 255},
  {1.8929509674570111759824581e-145, 10, "1892950967", -144},
  {2.0688358896345161898115321e-56, 9, "206883589", -55},
  {2.3762970229201922533871827e+194, 6, "23763", 195},
  {5.7767294427308925907185024e+131, 10, "5776729443", 132},
  {1.6645960017006788593154564e+136, 2, "17", 137},
  {6.7119181219930813598760152e+166, 11, "6711918122", 167},
  {2.9260264352084230573888956e-287, 17, "29260264352084231", -286},
  {5.6002313209810336159443250e+160, 6, "560023", 161},
  {1.2707069729022919545457948e-223, 1, "1", -222},
  {1.0371605588944856914308898e-53, 5, "10372", -52},
  {5.9669506283129801095872565e+172, 13, "5966950628313", 173},
  {3.7263326989340773651153058e+134, 8, "37263327", 135},
  {4.2184671360295649403926435e+246, 12, "421846713603", 247},
  {8.3018142166033890024946071e-270, 19, "8301814216603389002", -269},
  {1.5406626596097185889240751e-146, 4, "1541", -145},
  {1.7253585792631116748784917e+242, 6, "172536", 243},
  {3.9439399836523825696544947e-205, 5, "39439", -204},
  {2.0584124626212490653251257e-101, 11, "20584124626", -100},
  {2.7731268637307875091845190e+94, 4, "2773", 95},
  {4.5975020500985942442387165e-119, 19, "4597502050098594244", -118},
  {1.8923728725910436408050837e+164, 14, "1892372872591", 165},
  {4.2347503876669913228126061e+90, 12, "423475038767", 91},
  {4.4236708761812136608907797e+238, 1, "4", 239},
  {5.6493476316883036986692794e+42, 2, "56", 43},
  {1.7745626603070332484316950e-186, 17, "17745626603070332", -185},
  {4.0574871866234298027565400e+158, 17, "40574871866234298", 159},
  {3.3138652965775717273524786e-13, 16, "3313865296577572", -12},
  {2.2703294715050073688605200e-68, 20, "22703294715050073689", -67},
  {8.0028826524353672063796378e-98, 4, "8003", -97},
  {1.6517537231465141165694325e+262, 7, "1651754", 263},
  {3.8726981253322611905226567e-206, 4, "3873", -205},
  {1.4712736667412399286676810e+249, 11, "14712736667", 250},
  {8.2369415013072210200811425e-36, 9, "82369415", -35},
  {3.4641992966683613175961796e-86, 5, "34642", -85},
  {5.3452391137049915282712816e-250, 3, "535", -249},
  {5.3950178765387008163047920e-103, 15, "53950178765387", -102},
  {1.0589066787996437906348654e-249, 16, "1058906678799644", -248},
  {1.4965359802491678780857798e-93, 10, "149653598", -92},
  {2.0165953652390411885778557e-238, 13, "2016595365239", -237},
  {3.0124035713546868549161680e+286, 4, "3012", 287},
  {1.7594125953330849560140633e+193, 11, "17594125953", 194},
  {6.6406274262650975073220668e+87, 13, "6640627426265", 88},
  {1.4794308718222674264983405e+96, 14, "14794308718223", 97},
  {5.7533009088493063173564009e+112, 14, "57533009088493", 113},
  {9.4211862398914020578606949e-82, 9, "942118624", -81},
  {6.2995094571764329107119705e+164, 15, "629950945717643", 165},
  {2.8902513264150313789106727e-122, 12, "289025132642", -121},
  {2.8844471262794276455447086e-207, 11, "28844471263", -206},
  {2.4533642181717204501650687e-129, 8, "24533642", -128},
  {3.6675345606963017676987000e+34, 2, "37", 35},
  {2.2645565436844609070646447e+294, 14, "22645565436845", 295},
  {4.0945266163734285718120935e-230, 8, "40945266", -229},
  {3.4782269822955232145340346e+58, 5, "34782", 59},
  {4.7710516250826600478078120e+88, 15, "477105162508266", 89},
  {7.3935381378147374144139086e-194, 7, "7393538", -193},
  {1.0114934158577827511929784e-257, 12, "101149341586", -256},
  {2.0274422203898928724408977e-162, 9, "202744222", -161},
  {2.8232978325284350172278487e-98, 6, "28233", -97},
  {4.1760705233158554264288497e+89, 13, "4176070523316", 90},
  {2.1736356052479354340573703e-132, 6, "217364", -131},
  {3.2883928488430295652457380e-05, 9, "328839285", -4},
  {8.9632987137941412514066451e-66, 7, "8963299", -65},
  {2.5054462829451815537542445e+135, 6, "250545", 136},
  {2.1426944516158121605768962e+43, 8, "21426945", 44},
  {1.9137687456957998980340466e-95, 2, "19", -94},
  {1.0972575185494356220989363e+74, 7, "1097258", 75},
  {1.0978868166527825950834578e+159, 5, "10979", 160},
  {2.4573602459401298828125000e+12, 14, "24573602459401", 13},
  {9.9246981155305823851400084e-306, 2, "99", -305},
  {1.6120777237213534276812800e+23, 18, "161207772372135343", 24},
  {1.2609254326256567505445727e+255, 9, "126092543", 256},
  {1.9099639008239432456225708e-212, 12, "190996390082", -211},
  {2.5381314759838175791498236e-06, 14, "25381314759838", -5},
  {3.8691787419544143250772090e-84, 10, "3869178742", -83},
  {2.0306929606170625913498961e+217, 18, "203069296061706259", 218},
  {2.0570266077706475476665651e-121, 10, "2057026608", -120},
  {2.6784839165421438769517913e-32, 16, "2678483916542144", -31},
  {4.1851960085436995468001559e+204, 2, "42", 205},
  {3.0912911492130173643900103e+201, 15, "309129114921302", 202},
  {3.2752041395548862472121971e-217, 16, "3275204139554886", -216},
  {2.9427081359144563200000000e+17, 3, "294", 18},
  {1.6081880072674337845636147e+41, 2, "16", 42},
  {5.5274683029870816393922811e+214, 3, "553", 215},
  {6.2100920503831053850952281e+56, 10, "621009205", 57},
  {1.2572324686803614860786580e-39, 15, "125723246868036", -38},
  {2.8832164721668593562424550e-127, 5, "28832", -126},
  {5.4533224198923945227341076e+186, 5, "54533", 187},
  {1.6198311686447714666932495e+109, 17, "16198311686447715", 110},
  {7.3218570622411188442704743e+257, 19, "7321857062241118844", 258},
  {4.9445074071715227734895484e-54, 14, "49445074071715", -53},
  {2.6395485500204479089188108e-155, 13, "263954855002", -154},
  {7.5908121713538275989955352e+204, 6, "759081", 205},
  {8.6556039438851422635499213e+201, 9, "865560394", 202},
  {8.7921357998863328590914964e+128, 6, "879214", 129},
  {1.9573500792649128664367104e+25, 6, "195735", 26},
  {5.3820045995193670175355820e-15, 1, "5", -14},
  {1.3140029214130792306200037e+235, 1, "1", 236},
  {5.2755083539099661823167693e+26, 9, "527550835", 27},
  {4.2180006642854759594061405e+210, 4, "4218", 211},
  {1.6148141543283823226762231e+124, 19, "1614814154328382323", 125},
  {8.2173493335074845909627122e+29, 20, "8217349333507484591", 30},
  {1.4658537070174585126049506e-213, 3, "147", -212},
  {2.0032710854026138265344958e+226, 12, "20032710854", 227},
  {1.0880445956537819095619177e-251, 16, "1088044595653782", -250},
  {3.4693822344281853232736002e+53, 5, "34694", 54},
  {3.6550629956563857421697438e-183, 8, "3655063", -182},
  {1.1572104646243926607746594e-203, 5, "11572", -202},
  {1.5122421193886230109937633e-254, 4, "1512", -253},
  {1.7217477371958223696746520e-16, 11, "17217477372", -15},
  {6.3855854732060240114362547e-105, 10, "6385585473", -104},
  {1.0490540693118869880306836e+43, 14, "10490540693119", 44},
  {1.2665468889345042501526690e-248, 3, "127", -247},
  {1.3265172251666336959063345e+46, 21, "132651722516663369591", 47},
  {1.8647542215513973987117277e-272, 3, "186", -271},
  {8.7657241388449163043087928e+200, 10, "8765724139", 201},
  {7.0835308238096826494164664e+27, 10, "7083530824", 28},
  {2.7552096945091772896400163e+99, 9, "275520969", 100},
  {3.0385383241179269146676763e+80, 20, "30385383241179269147", 81},
  {5.4942440657326039074427236e-264, 10, "5494244066", -263},
  {9.4673012606508900091776506e+172, 11, "94673012607", 173},
  {1.2017472858762175843996321e+39, 8, "12017473", 40},
  {6.2186709823394930134819288e+184, 8, "6218671", 185},
  {9.0601840585153381457672594e-01, 4, "906", 0},
  {4.6122102676761808327557655e-90, 20, "46122102676761808328", -89},
  {1.2988123308692228624571948e-300, 14, "12988123308692", -299},
  {1.5783302019977090560000000e+18, 15, "157833020199771", 19},
  {4.3702000476486411229725288e-79, 2, "44", -78},
  {2.0451908964488670418199485e+93, 8, "20451909", 94},
  {6.9149529642390316618529631e+298, 10, "6914952964", 299},
  {3.9770990603753963463099490e-68, 18, "397709906037539635", -67},
  {1.8399414001606940248681544e-273, 9, "18399414", -272},
  {2.9533371054789563583732595e+195, 19, "2953337105478956358", 196},
  {2.6813927584761802428465098e-196, 5, "26814", -195},
  {8.6735386985210939117436876e-123, 14, "86735386985211", -122},
  {2.5986260749465248896281106e+72, 4, "2599", 73},
  {2.5680090037516434338787487e-49, 2, "26", -48},
  {3.0697818021152168886939604e-75, 3, "307", -74},
  {8.7994435423555055112396224e+279, 15, "879944354235551", 280},
  {2.3992566815155325460617593e+227, 5, "23993", 228},
  {2.4578088857354777647182151e+131, 20, "24578088857354777647", 132},
  {1.4852109677742573369692812e-05, 10, "1485210968", -4},
  {5.7156441036948713847299808e-84, 13, "5715644103695", -83},
  {2.0964111617763768297214787e+181, 9, "209641116", 182},
  {2.7489301082098590689842009e-43, 7, "274893", -42},
  {2.9937812366886470430844438e+61, 20, "29937812366886470431", 62},
  {3.5201584683201293604996404e+220, 1, "4", 221},
  {1.0299937119950666186696253e+01, 2, "1", 2},
  {8.9683630387146112988543575e-254, 21, "896836303871461129885", -253},
  {4.8587896770847729552048044e+87, 8, "48587897", 88},
  {7.9842453945254641898968058e-157, 6, "798425", -156},
  {4.3510870823543134202634681e+139, 2, "44", 140},
  {1.7203412185130130725195226e-87, 2, "17", -86},
  {2.7574711219411693845788669e-195, 15, "275747112194117", -194},
  {1.8250218532107128294781434e+250, 12, "182502185321", 251},
  {4.2626629760415287538840124e-36, 2, "43", -35},
  {8.4932559932298532949883963e+218, 19, "8493255993229853295", 219},
  {4.6079288438659001364346165e-242, 20, "46079288438659001364", -241},
  {1.4001551853455756787827821e+76, 20, "14001551853455756788", 77},
  {8.4660988863607200435122410e+117, 19, "8466098886360720044", 118},
  {2.7042559398767383253919874e-67, 13, "2704255939877", -66},
  {6.7363724426033201372351450e+126, 15, "673637244260332", 127},
  {1.5388982986844961021667849e-111, 18, "15388982986844961", -110},
  {1.0304141152848498226088497e-234, 6, "103041", -233},
  {6.2707996491148994616022414e+221, 13, "6270799649115", 222},
  {5.9468461355606512900044508e-24, 14, "59468461355607", -23},
  {7.1964053198299806843288356e+267, 7, "7196405", 268},
  {1.4872139619478080908185327e+139, 12, "148721396195", 140},
  {4.7306918192960207778904647e-164, 14, "4730691819296", -163},
  {7.4726013130764769753335548e-128, 3, "747", -127},
  {7.4939243185646481099516231e-06, 2, "75", -5},
  {5.7951163237555239596608951e+287, 6, "579512", 288},
  {1.4502955935231141963885669e+289, 10, "1450295594", 290},
  {2.8734328836362582531892452e-305, 2, "29", -304},
  {1.2102639668988206360922965e-19, 7, "1210264", -18},
  {6.3274729649927949485670627e-112, 9, "632747296", -111},
  {9.6145994475137743268587174e-275, 17, "96145994475137743", -274},
  {1.0100684780421881688705791e-180, 2, "1", -179},
  {1.6568633937763732251643019e+47, 19, "1656863393776373225", 48},
  {7.5546632139430654683145583e+45, 7, "7554663", 46},
  {2.3403251101413054052011017e-104, 14, "23403251101413", -103},
  {1.4367567547095207715206927e+273, 7, "1436757", 274},
  {5.0656871653309996969543246e-176, 19, "5065687165330999697", -175},
  {8.9436636993058197952691856e-88, 15, "894366369930582", -87},
  {4.0188959317122169470389960e-103, 12, "401889593171", -102},
  {1.0393007688548729179424287e-187, 12, "103930076885", -186},
  {7.0646298748641557693481445e+09, 21, "706462987486415576935", 10},
  {2.6379383594288145505993260e-49, 13, "2637938359429", -48},
  {8.0841674319723467620953454e+127, 9, "808416743", 128},
  {2.9160619907723420538656445e-134, 4, "2916", -133},
  {3.9590106910063357387036612e+222, 7, "3959011", 223},
  {1.8537205539227508190077191e-121, 18, "185372055392275082", -120},
  {6.1030406885159917787344502e+265, 6, "610304", 266},
  {2.8034828486386255212766909e-299, 20, "28034828486386255213", -298},
  {9.6522405604503361868530669e+285, 7, "9652241", 286},
  {3.7226056934095152709382249e-308, 1, "4", -307},
  {5.4542834929016732398040414e+284, 18, "545428349290167324", 285},
  {1.4639598288302290480345013e-151, 15, "146395982883023", -150},
  {1.8468597214265807198798916e-35, 10, "1846859721", -34},
  {1.2872222387417648048085137e-70, 3, "129", -69},
  {1.1382591777519438181888566e+263, 8, "11382592", 264},
  {2.2944649111657535558909952e+25, 15, "229446491116575", 26},
  {2.8848686078542358304029878e+201, 8, "28848686", 202},
  {1.7843283232493094066961434e-265, 4, "1784", -264},
  {4.2854364497646776552384367e-278, 18, "428543644976467766", -277},
  {5.4768478267567726936137356e+106, 14, "54768478267568", 107},
  {1.8523802020979280900724086e+143, 20, "18523802020979280901", 144},
  {4.0018103700980356264161202e-170, 13, "4001810370098", -169},
  {9.4047363810827334064507889e-111, 16, "9404736381082733", -110},
  {4.1113035072640734805954767e-182, 11, "41113035073", -181},
  {1.2795284878377510969258103e+206, 15, "127952848783775", 207},
  {1.2174179856723587094807588e-68, 4, "1217", -67},
  {2.2590804841316347313946718e+70, 20, "22590804841316347314", 71},
  {9.7483223081446470727862483e+153, 21, "974832230814464707279", 154},
  {1.0084231137939273679911946e+157, 8, "10084231", 158},
  {6.1824712189577534753698398e-276, 15, "618247121895775", -275},
  {7.8542664913757073604029339e-85, 10, "7854266491", -84},
  {6.5408507480686458988688003e-270, 4, "6541", -269},
  {1.6929481112899909672632625e-78, 19, "1692948111289990967", -77},
  {1.2010822434464509121391171e+121, 1, "1", 122},
  {2.8994662022996620952415576e-113, 1, "3", -112},
  {1.4781465672191792767010091e-179, 17, "14781465672191793", -178},
  {1.7808231585836204926686442e+279, 17, "17808231585836205", 280},
  {9.7969834932631663588628643e-145, 15, "979698349326317", -144},
  {1.0997128256127432591895199e+48, 12, "109971282561", 49},
  {4.5847854706942000646622844e-36, 5, "45848", -35},
  {9.0383706546843903940553573e+48, 17, "90383706546843904", 49},
  {2.4972590673399240175511393e-33, 15, "249725906733992", -32},
  {5.4201144101146649509826867e+83, 15, "542011441011466", 84},
  {3.4784448255167416818343306e+128, 12, "347844482552", 129},
  {9.4108585875645169751874659e+184, 16, "9410858587564517", 185},
  {1.7579572700713202461472176e-162, 3, "176", -161},
  {3.2102118222977866351030327e+38, 20, "32102118222977866351", 39},
  {2.3883446911254046072231835e-302, 14, "23883446911254", -301},
  {1.3825808043273530098064118e+103, 3, "138", 104},
  {6.3942564834130984473721028e-281, 20, "63942564834130984474", -280},
  {4.4143107758598333488686595e-74, 3, "441", -73},
  {1.1180160352667703895747404e-293, 5, "1118", -292},
  {1.7629654164569427318294757e-270, 11, "17629654165", -269},
  {6.2775239088463275132818536e+79, 5, "62775", 80},
  {2.0928270018006755300820311e+120, 10, "2092827002", 121},
  {2.0032671857602558990000654e+66, 11, "20032671858", 67},
  {5.7118558037641735529591329e-264, 14, "57118558037642", -263},
  {6.2879696545411645623330305e-33, 16, "6287969654541165", -32},
  {5.3616555253230487085558104e-242, 6, "536166", -241},
  {4.8117014152077373546874366e-300, 16, "4811701415207737", -299},
  {8.0937155846159439205378953e+226, 9, "809371558", 227},
  {6.6010623059548165703961032e-47, 10, "6601062306", -46},
  {2.9729363869216589605869352e+113, 14, "29729363869217", 114},
  {2.3582981528885000743022560e+288, 21, "23582981528885000743", 289},
  {6.3134415389861694371436643e-254, 3, "631", -253},
  {3.5838439381367587864327054e+61, 3, "358", 62},
  {2.1437237692842194245150625e+292, 9, "214372377", 293},
  {4.8967966283639446016967663e+292, 17, "48967966283639446", 293},
  {1.1732236663145240431074533e+139, 11, "11732236663", 140},
  {2.8839364205865009667683763e+88, 2, "29", 89},
  {3.3482410280687923586792504e+54, 9, "334824103", 55},
  {6.5887650316534277114019299e-131, 1, "7", -130},
  {1.3740716577371994134848101e+270, 1, "1", 271},
  {4.6048588032533028625395942e+155, 18, "460485880325330286", 156},
  {1.9222441537621905920000000e+18, 2, "19", 19},
  {5.1403742592891740160000000e+18, 5, "51404", 19},
  {1.2773573708396364357436936e+281, 16, "1277357370839636", 282},
  {6.5571564438611658635674202e+271, 9, "655715644", 272},
  {6.2109700154477564900537262e+182, 5, "6211", 183},
  {8.0695611922511959204297540e+219, 7, "8069561", 220},
  {1.1884234670268597393140037e-101, 12, "118842346703", -100},
  {1.9926068398734837928043232e+185, 15, "199260683987348", 186},
  {5.2580049074754611200000000e+17, 19, "525800490747546112", 18},
  {7.4318818123927123428018222e-196, 17, "74318818123927123", -195},
  {1.9143728191221413409392531e-268, 8, "19143728", -267},
  {5.6336854325030467269996643e+226, 4, "5634", 227},
  {1.7047272253840130838859640e+158, 7, "1704727", 159},
  {3.2035135626132735447119270e-13, 1, "3", -12},
  {1.5962857827562526332189259e+191, 5, "15963", 192},
  {1.7060573818121278031652193e-250, 18, "17060573818121278", -249},
  {5.4274415060234631585459958e+75, 6, "542744", 76},
  {1.6088787778653673402244087e-214, 14, "16088787778654", -213},
  {1.1803080309367254333574088e-249, 6, "118031", -248},
  {8.7213467001948024426312877e-164, 3, "872", -163},
  {2.2954766182733872724334282e-129, 20, "22954766182733872724", -128},
  {2.5776642872264296485508734e+239, 16, "257766428722643", 240},
  {1.5413773722002604510622828e-06, 21, "154137737220026045106", -5},
  {4.1769585033511001253020229e+303, 7, "4176959", 304},
  {6.8271771609414328113777458e-205, 14, "68271771609414", -204},
  {9.4978835852224873646761719e+142, 12, "949788358522", 143},
  {4.5495398898762071582865196e-300, 9, "454953989", -299},
  {1.0319212872560926482479646e+46, 13, "1031921287256", 47},
  {3.7030342666467706016452821e-174, 3, "37", -173},
  {4.2722250480009879288445868e+130, 7, "4272225", 131},
  {5.0704079203996526179844813e+41, 13, "50704079204", 42},
  {9.6380402559009596053483535e-159, 18, "963804025590095961", -158},
  {1.3447245913394553360775031e+63, 17, "13447245913394553", 64},
  {3.0255266940905135606008800e-292, 4, "3026", -291},
  {2.1041550673763083191588593e+234, 21, "210415506737630831916", 235},
  {5.4759926056916708798384632e-214, 11, "54759926057", -213},
  {6.8584860859574273220865363e-203, 10, "6858486086", -202},
  {7.1382476337100556192558865e-10, 17, "71382476337100556", -9},
  {2.0715357643266332667433788e+125, 21, "207153576432663326674", 126},
  {4.1656333092766381106351214e-161, 2, "42", -160},
  {9.4428412334695757176713586e-234, 5, "94428", -233},
  {5.1876202252239975857757158e+44, 20, "51876202252239975858", 45},
  {1.2436274856393842703244307e+207, 15, "124362748563938", 208},
  {2.1557842587024954408635166e-256, 9, "215578426", -255},
  {2.6939497392049193042583857e+42, 5, "26939", 43},
  {1.9844088522238093588929837e+40, 12, "198440885222", 41},
  {6.5590166379407340423194723e-149, 18, "655901663794073404", -148},
  {7.0810244603219350191914199e+82, 11, "70810244603", 83},
  {1.0730143973870203060560135e-138, 11, "10730143974", -137},
  {5.2212771718120934391075319e-195, 16, "5221277171812093", -194},
  {6.5362764037361048161983490e+07, 13, "6536276403736", 8},
  {5.9360356696860614447426895e+204, 11, "59360356697", 205},
  {1.7220274225165762560000000e+19, 8, "17220274", 20},
  {3.9700172611145804438177105e+47, 17, "39700172611145804", 48},
  {6.2203499067380847419436434e-297, 15, "622034990673808", -296},
  {3.6956905058179545121893946e+152, 21, "369569050581795451219", 153},
  {3.8548890938562831919007104e-304, 3, "385", -303},
  {2.8773385640228293503739249e-282, 17, "28773385640228294", -281},
  {9.9232972105547690844428782e+95, 15, "992329721055477", 96},
  {2.6080076495768544600946763e+303, 11, "26080076496", 304},
  {2.4638057951853355620846840e+90, 1, "2", 91},
  {4.8063321997791203228370775e-250, 10, "48063322", -249},
  {1.3343182325454359477329858e-118, 5, "13343", -117},
  {1.9348377153603287862862623e-117, 1, "2", -116},
  {3.7715818741978535321872006e+207, 2, "38", 208},
  {1.5852372217926412343832567e-106, 21, "158523722179264123438", -105},
  {2.6592217561416069905061350e+47, 19, "2659221756141606991", 48},
  {6.7288522768831955418581669e+203, 19, "6728852276883195542", 204},
  {8.8472333438649893893359475e-296, 8, "88472333", -295},
  {1.1775896256767174562517715e-118, 10, "1177589626", -117},
  {3.1210706920645102526177974e-173, 11, "31210706921", -172},
  {1.7379439659731096110219951e+295, 14, "17379439659731", 296},
  {1.8714665766618255362204312e-191, 21, "187146657666182553622", -190},
  {4.2676447203145386673910426e+180, 19, "4267644720314538667", 181},
  {9.7500635013673014035662909e-167, 19, "9750063501367301404", -166},
  {8.2969194171867223259983446e-290, 18, "829691941718672233", -289},
  {3.6881488969417419840508650e+155, 5, "36881", 156},
  {9.8034502847415297103603182e+234, 21, "980345028474152971036", 235},
  {1.0962567334218677968237431e+31, 8, "10962567", 32},
  {4.0450814481238910340782597e+85, 3, "405", 86},
  {8.1872307641137863733156955e+254, 10, "8187230764", 255},
  {1.4348185534663238457395243e-10, 11, "14348185535", -9},
  {2.9847122927983906604260969e+77, 20, "29847122927983906604", 78},
  {1.7114663319833711070389200e+180, 13, "1711466331983", 181},
  {3.4251229352195815767629758e-155, 16, "3425122935219582", -154},
  {3.4086562850989646518500027e+195, 1, "3", 196},
  {5.3034513294675519834533968e+121, 2, "53", 122},
  {8.8591442084643121062560283e+188, 10, "8859144208", 189},
  {2.5905704182578015918855648e-163, 6, "259057", -162},
  {6.6052174019056705889474970e+26, 11, "66052174019", 27},
  {8.4316257545083286348240262e+174, 3, "843", 175},
  {1.3068019516951952035512437e+130, 19, "1306801951695195204", 131},
  {2.6694600991965638877386135e+277, 11, "26694600992", 278},
  {3.2620001491040358494453227e-271, 15, "326200014910404", -270},
  {1.2038270317787603367448492e-126, 21, "120382703177876033674", -125},
  {1.0630752861613998630475615e-291, 4, "1063", -290},
  {2.8087779208321343432025872e+79, 17, "28087779208321343", 80},
  {7.0117890152284303960809009e-146, 8, "7011789", -145},
  {1.4077573616205523090660371e-67, 10, "1407757362", -66},
  {3.2284635558790874481201172e+09, 12, "322846355588", 10},
  {2.8894673241404404327654788e-30, 7, "2889467", -29},
  {9.3241102440824587721498817e+75, 14, "93241102440825", 76},
  {9.6942354621047153347937854e-308, 4, "9694", -307},
  {1.0432506640113630330669685e+202, 17, "1043250664011363", 203},
  {3.9819510059134155744686723e+05, 4, "3982", 6},
  {3.6740181464508388248111423e-206, 14, "36740181464508", -205},
  {1.6336409057779136239515779e-209, 19, "1633640905777913624", -208},
  {1.3044123663775932241239370e-296, 12, "130441236638", -295},
  {3.1417544935124983353839228e-205, 14, "31417544935125", -204},
  {1.0016481454829531110527012e+143, 12, "100164814548", 144},
  {4.8430552146823551146934103e+226, 16, "4843055214682355", 227},
  {4.8812904952782481368303314e-172, 8, "48812905", -171},
  {3.5356886392038368002121297e+154, 17, "35356886392038368", 155},
  {4.6959641223942264512968609e-200, 3, "47", -199},
  {9.9239155798674198264425553e+66, 20, "99239155798674198264", 67},
  {1.4703478676719635200000000e+17, 18, "147034786767196352", 18},
  {2.4042482418571761305488593e+51, 2, "24", 52},
  {4.6455478653859794853509839e-33, 20, "46455478653859794854", -32},
  {1.2781946266146433082793436e+275, 5, "12782", 276},
  {2.9875875574202476467652690e-285, 21, "298758755742024764677", -284},
  {7.5933857070825305894727525e-64, 18, "759338570708253059", -63},
  {1.3844779558842181797815275e-298, 21, "138447795588421817978", -297},
  {2.3630137946497784142318961e+287, 2, "24", 288},
  {1.4562611050431409376249279e+122, 6, "145626", 123},
  {2.8958127682481975296000000e+19, 12, "289581276825", 20},
  {1.6982613948297316527031164e+180, 21, "16982613948297316527", 181},
  {1.5156745966511374042610670e+246, 14, "15156745966511", 247},
  {2.7328710436121959062872032e-309, 4, "2733", -308},
  {9.9007042376655707435582684e+182, 13, "9900704237666", 183},
  {1.4948915579077265443891134e-125, 4, "1495", -124},
  {4.2524056235370505965990845e+114, 1, "4", 115},
  {1.6964578806834630243102782e+41, 15, "169645788068346", 42},
  {2.4361313987513940383682667e-51, 11, "24361313988", -50},
  {7.7875607799690753146556778e-13, 20, "77875607799690753147", -12},
  {8.0981449901125549577683474e-97, 12, "809814499011", -96},
  {3.5636490203934020368754197e+72, 13, "3563649020393", 73},
  {1.0183483140297253319487394e-229, 13, "101834831403", -228},
  {7.4701252416524451644384841e-05, 4, "747", -4},
  {3.9669914749486110392489844e+260, 7, "3966991", 261},
  {1.4938632251682873943949235e-29, 18, "149386322516828739", -28},
  {4.1593390434154815068698784e+76, 7, "4159339", 77},
  {4.8643823155065464542806149e+185, 12, "486438231551", 186},
  {3.7745587182732521101736468e+104, 3, "377", 105},
  {4.1547417165777207530864633e-184, 21, "415474171657772075309", -183},
  {1.3510738294902587333574208e-184, 15, "135107382949026", -183},
  {4.6299004472356973105552704e-85, 14, "46299004472357", -84},
  {5.1588483470211737060546875e+11, 20, "51588483470211737061", 12},
  {2.4149974457179001853782367e-166, 6, "2415", -165},
  {1.9409086586589180878624684e-303, 2, "19", -302},
  {2.9379760887956782922318578e-281, 10, "2937976089", -280},
  {5.3877198365699942683478512e-16, 2, "54", -15},
  {6.6352742265921124873937239e-288, 20, "66352742265921124874", -287},
  {1.3769514482021072675245426e+218, 11, "13769514482", 219},
  {1.2076236412568350048830281e+178, 5, "12076", 179},
  {8.7891482537385516902291040e-108, 14, "87891482537386", -107},
  {2.4233794482459666548436164e-73, 18, "242337944824596665", -72},
  {4.9542250585645801164798158e+87, 17, "49542250585645801", 88},
  {1.4006143735337434964655064e+152, 12, "140061437353", 153},
  {2.8625631373350589977336311e+245, 8, "28625631", 246},
  {7.4865860697780546615831554e+04, 4, "7487", 5},
  {2.8802445597784282480933405e+137, 18, "288024455977842825", 138},
  {6.9928498408580920072585202e+75, 19, "6992849840858092007", 76},
  {6.8921198853788942426792325e+192, 12, "689211988538", 193},
  {3.0226858557373349811123514e-61, 21, "302268585573733498111", -60},
  {1.0250777556567675967414578e-61, 15, "102507775565677", -60},
  {8.8298620140901204186684119e+179, 5, "88299", 180},
  {3.2595260939373867884057972e-217, 3, "326", -216},
  {4.5861735449277370123174948e-187, 8, "45861735", -186},
  {3.0748131593638882015660847e+114, 13, "3074813159364", 115},
  {1.6216411623825837162878876e-97, 12, "162164116238", -96},
  {2.2007318114889610283928938e+303, 17, "2200731811488961", 304},
  {2.0445581081877706892973771e+287, 10, "2044558108", 288},
  {7.2701361658256160054005441e-301, 11, "72701361658", -300},
  {1.9315911300815884141329093e+59, 17, "19315911300815884", 60},
  {2.0207806820036735157070898e-15, 20, "20207806820036735157", -14},
  {5.2636281530570993198694400e+23, 21, "526362815305709931987", 24},
  {4.1273664800398909578197259e-63, 8, "41273665", -62},
  {6.2341997110685677735917089e-245, 12, "623419971107", -244},
  {1.5537935018885892752367428e-28, 19, "1553793501888589275", -27},
  {8.0428350476797043269416204e+46, 12, "804283504768", 47},
  {1.8776866431250759019044578e-138, 10, "1877686643", -137},
  {2.8259526021190571250454391e-125, 10, "2825952602", -124},
  {1.8077735800877966178954475e-19, 4, "1808", -18},
  {8.9610310449965417115178888e+195, 19, "8961031044996541712", 196},
  {2.4361647143690708135007947e+58, 4, "2436", 59},
  {2.3726631423560464572874752e+27, 9, "237266314", 28},
  {3.5143100336919584433001515e-298, 1, "4", -297},
  {1.6172123960442045360319089e+232, 17, "16172123960442045", 233},
  {2.1560737417946549148839299e-278, 1, "2", -277},
  {3.3718543782517562769641582e+85, 19, "3371854378251756277", 86},
  {2.4862541834022132255299125e+69, 16, "2486254183402213", 70},
  {1.0360918753762037002025896e+92, 12, "103609187538", 93},
  {9.6275102708266954294199785e+260, 16, "9627510270826695", 261},
  {2.0428618931030739884345872e+46, 6, "204286", 47},
  {3.8341082979777470544861035e-114, 17, "38341082979777471", -113},
  {1.1419176018635474412960078e+234, 14, "11419176018635", 235},
  {5.2999920386463147666928856e-296, 8, "5299992", -295},
  {1.3310543444799818090468951e+69, 20, "1331054344479981809", 70},
  {5.9296520177124379250832991e+139, 16, "5929652017712438", 140},
  {2.4672982781430059928233650e+222, 11, "24672982781", 223},
  {6.4775918962817955862259280e-84, 3, "648", -83},
  {1.0098009435432530918541259e-101, 1, "1", -100},
  {1.0807493288530598859267447e+58, 3, "108", 59},
  {8.1284487953968840367969754e+246, 16, "8128448795396884", 247},
  {4.4858027463542700719977290e+199, 13, "4485802746354", 200},
  {8.5765366887313447811596001e+278, 21, "857653668873134478116", 279},
  {1.6495301908643955596953328e-145, 6, "164953", -144},
  {1.0301523224738204876800000e+20, 18, "103015232247382049", 21},
  {1.4491248177263938224257365e+254, 9, "144912482", 255},
  {1.1686784833970805596429543e+121, 12, "11686784834", 122},
  {1.4166522780962365093095728e-204, 1, "1", -203},
  {1.0613486772646103858852853e-69, 20, "10613486772646103859", -68},
  {9.7709962347584950128289291e+104, 19, "9770996234758495013", 105},
  {5.7154902708702213865302276e-114, 17, "57154902708702214", -113},
  {2.8018977667215077521015179e+181, 8, "28018978", 182},
  {1.1182549233179195522115005e-60, 11, "11182549233", -59},
  {1.0823256496903471856983819e+280, 11, "10823256497", 281},
  {2.9784120668587389041053757e+229, 14, "29784120668587", 230},
  {5.4311999230280819738685257e-53, 20, "54311999230280819739", -52},
  {2.7949329361143841249096005e-136, 7, "2794933", -135},
  {3.2056181208172143301139189e+43, 5, "32056", 44},
  {1.2193915709041576312596192e-79, 19, "1219391570904157631", -78},
  {3.7020425082969602207470050e+100, 8, "37020425", 101},
  {2.6080878210311931668676780e-287, 8, "26080878", -286},
  {2.8739068933987788352158586e+173, 3, "287", 174},
  {2.9003744326544844260695279e+115, 20, "29003744326544844261", 116},
  {1.8543082290888382885896135e+03, 3, "185", 4},
  {3.4146119553904921199443263e-23, 15, "341461195539049", -22},
  {3.1958244108941865084944665e-198, 9, "319582441", -197},
  {1.0175986741087331271905865e+195, 3, "102", 196},
  {1.0890391195890362789303808e-176, 5, "1089", -175},
  {1.0860915377394138506711883e+248, 14, "10860915377394", 249},
  {2.6002050544603967708093190e-36, 14, "26002050544604", -35},
  {1.3328448568056179951664040e+67, 17, "1332844856805618", 68},
  {3.4783663519148998330914453e+70, 11, "34783663519", 71},
  {4.2805329320358765729939845e+127, 20, "4280532932035876573", 128},
  {2.3841343830623592691188920e+103, 9, "238413438", 104},
  {5.9637885902819069983138434e+00, 21, "596378859028190699831", 1},
  {3.6321892108177511000445415e-106, 9, "363218921", -105},
  {1.7533466405862812442437941e-237, 1, "2", -236},
  {1.8695222954326882181523528e-157, 1, "2", -156},
  {5.1157175531807301974109350e-255, 4, "5116", -254},
  {4.6004308323673125000000000e+14, 11, "46004308324", 15},
  {1.3626245346374867862963165e-223, 16, "1362624534637487", -222},
  {1.1186485753180238493434754e-129, 14, "1118648575318", -128},
  {9.1378894024638684716856996e-165, 14, "91378894024639", -164},
  {1.4889428421534129437855942e+94, 8, "14889428", 95},
  {2.0295986225903194977393794e-84, 7, "2029599", -83},
  {1.0799371906400690485270011e-66, 16, "1079937190640069", -65},
  {5.6552517894442106482371083e-181, 10, "5655251789", -180},
  {1.9144233807599661764638648e-42, 9, "191442338", -41},
  {3.6016707281277068175986766e+246, 7, "3601671", 247},
  {1.9437827417303205585101248e+258, 6, "194378", 259},
  {3.1053954939631076675701783e-173, 8, "31053955", -172},
  {1.0543750333624442397261049e-97, 16, "1054375033362444", -96},
  {1.6225409659976446714027657e+287, 10, "1622540966", 288},
  {3.2173335104135753448683383e+214, 10, "321733351", 215},
  {9.3360556369793144026776678e-115, 6, "933606", -114},
  {5.2635284611679795682394576e+156, 3, "526", 157},
  {1.9834645041623377854767974e+71, 7, "1983465", 72},
  {1.1115177260259390051597723e+293, 10, "1111517726", 294},
  {3.7691928224701776637147179e+197, 13, "376919282247", 198},
  {3.5047165660759344311150037e+292, 10, "3504716566", 293},
  {5.0698650477871652057330776e-229, 4, "507", -228},
  {4.4201929598871190901212313e-118, 20, "44201929598871190901", -117},
  {1.6492223583713549299955902e+213, 8, "16492224", 214},
  {1.2874098901039765651990633e+237, 11, "12874098901", 238},
  {4.3105568925101227322644158e+186, 11, "43105568925", 187},
  {5.5483186751292481405654379e+85, 5, "55483", 86},
  {2.1182817115787703138834521e+64, 4, "2118", 65},
  {9.7334161660288602976558264e-72, 7, "9733416", -71},
  {2.9134035208265588883072923e-290, 5, "29134", -289},
  {7.4927725855509748866564290e-224, 1, "7", -223},
  {6.9569059540440412464084413e-105, 4, "6957", -104},
  {1.8095384017875548162398812e+146, 12, "180953840179", 147},
  {5.3681738486838411496608462e-107, 12, "536817384868", -106},
  {8.3677890171504819865856393e+287, 15, "836778901715048", 288},
  {1.8197129527294873384962726e-04, 16, "1819712952729487", -3},
  {3.9438855083335534822566361e-25, 19, "3943885508333553482", -24},
  {1.6063633517331169758712084e+71, 13, "1606363351733", 72},
  {7.5118637598309396002708116e-176, 4, "7512", -175},
  {6.9769392063643151007765962e+181, 4, "6977", 182},
  {6.2472492970649668841270907e-04, 18, "624724929706496688", -3},
  {3.4740052548010695561324434e+102, 10, "3474005255", 103},
  {1.1072817115831857193077178e+176, 19, "1107281711583185719", 177},
  {2.9566678178341425176282786e-202, 20, "29566678178341425176", -201},
  {2.7738715830480270518072806e+254, 8, "27738716", 255},
  {4.3181894091369648835337746e-246, 18, "431818940913696488", -245},
  {1.8267958882341844420753549e+209, 20, "18267958882341844421", 210},
  {5.2372589795543653005778349e-164, 3, "524", -163},
  {2.1628237663531136728654549e-82, 18, "216282376635311367", -81},
  {2.9296914774037955199166876e-301, 14, "29296914774038", -300},
  {1.6842015948743728696457909e-45, 16, "1684201594874373", -44},
  {5.5096040051893923841595555e+228, 16, "5509604005189392", 229},
  {1.0969611428770203806198131e+215, 16, "109696114287702", 216},
  {1.2863539871335528542447101e-101, 15, "128635398713355", -100},
  {9.6951968936884212227804639e-166, 1, "1", -164},
  {1.0378562049007934241574474e+283, 20, "10378562049007934242", 284},
  {2.9261421023991244133521187e+81, 13, "2926142102399", 82},
  {4.0374843042609343400051447e+214, 12, "403748430426", 215},
  {4.7693307576079771919998399e-37, 8, "47693308", -36},
  {9.4230820278166794073645072e-117, 3, "942", -116},
  {1.6323216479240692208403642e-273, 16, "1632321647924069", -272},
  {1.6974204048386202871043472e-279, 5, "16974", -278},
  {2.9176003506349313516157650e-237, 21, "291760035063493135162", -236},
  {5.1248887111985123807841016e-282, 1, "5", -281},
  {5.3072586953238945799414183e-141, 12, "530725869532", -140},
  {5.7942592446819011134726089e+304, 7, "5794259", 305},
  {3.4827103802492937260722980e+194, 17, "34827103802492937", 195},
  {1.6100641669916241468495154e+91, 15, "161006416699162", 92},
  {7.4663385192417750084493891e-240, 3, "747", -239},
  {1.5676616667172044727459371e-152, 3, "157", -151},
  {5.7599514579407451542386527e-08, 11, "57599514579", -7},
  {7.6723354646081304154071045e+251, 3, "767", 252},
  {8.0842922762442875670648086e-51, 10, "8084292276", -50},
  {6.0422535051864656315734831e+242, 1, "6", 243},
  {2.7480517611601792531516220e-171, 13, "274805176116", -170},
  {7.1578034340071960580456448e+25, 12, "715780343401", 26},
  {5.2570097455990825742231086e+216, 2, "53", 217},
  {7.6877230446241218795772116e-188, 18, "768772304462412188", -187},
  {1.3432719256107071336267675e-126, 6, "134327", -125},
  {1.7413820411667164255397171e-142, 6, "174138", -141},
  {5.4118496435029236124591989e+01, 10, "5411849644", 2},
  {5.8067716979359328784878569e+303, 14, "58067716979359", 304},
  {3.3205178536057582449554201e+171, 3, "332", 172},
  {2.5760396460661987943346228e-65, 19, "2576039646066198794", -64},
  {3.2979109715628553032978801e-70, 7, "3297911", -69},
  {1.7017858599749358571043512e-63, 18, "170178585997493586", -62},
  {4.7260503677884762306836636e+300, 15, "472605036778848", 301},
  {5.7567151108449902237460397e-183, 10, "5756715111", -182},
  {2.9770995581438307968745889e+189, 8, "29770996", 190},
  {4.0821418721902132621533798e-169, 10, "4082141872", -168},
  {7.5995599211589172395133115e-44, 15, "759955992115892", -43},
  {9.7971127972359870259858114e-115, 7, "9797113", -114},
  {2.1998735376728652254777840e+51, 5, "21999", 52},
  {1.2816322713533289357646480e-282, 15, "128163227135333", -281},
  {3.7899060198545907304792904e+195, 13, "3789906019855", 196},
  {4.6343852219672762524555005e+35, 17, "46343852219672763", 36},
  {2.3511793917127080989782549e+89, 8, "23511794", 90},
  {6.1419353223922861123309605e+184, 19, "6141935322392286112", 185},
  {7.8643700763574479505629700e+261, 9, "786437008", 262},
  {5.0148672577360107829529463e-228, 15, "501486725773601", -227},
  {1.7436656096823989282693943e-99, 7, "1743666", -98},
  {2.2822465280274157471071641e-203, 21, "228224652802741574711", -202},
  {9.1847128974655783734136305e+302, 15, "918471289746558", 303},
  {1.0831341745003992290653453e-20, 1, "1", -19},
  {1.4605845666418891362854483e+257, 2, "15", 258},
  {8.9423127807907057328018017e-276, 16, "8942312780790706", -275},
  {1.5947079827648421568896354e-132, 14, "15947079827648", -131},
  {1.3174516185495906754759338e+268, 10, "1317451619", 269},
  {3.5858031742696811972555961e-214, 19, "3585803174269681197", -213},
  {5.4508722230113994345617447e-96, 18, "545087222301139943", -95},
  {7.0001756091536780364672221e-36, 5, "70002", -35},
  {1.7438318743651613556054416e+273, 15, "174383187436516", 274},
  {3.3537132955402210724464735e+149, 13, "335371329554", 150},
  {2.3512482237134017135577108e-240, 17, "23512482237134017", -239},
  {9.6978763999674315814750052e-270, 18, "969787639996743158", -269},
  {5.9551917512824382705752905e+293, 6, "595519", 294},
  {2.5675503463861956365772824e-133, 13, "2567550346386", -132},
  {9.5891198379738513931750552e-97, 10, "9589119838", -96},
  {6.0513799708891205801903406e+199, 4, "6051", 200},
  {4.6475743201511865907621768e+251, 2, "46", 252},
  {1.3285060477633708637262844e-03, 12, "132850604776", -2},
  {2.6986353303411824473768119e-301, 14, "26986353303412", -300},
  {1.1625880071596142020862652e-258, 8, "1162588", -257},
  {3.9795655513235587538621180e+214, 4, "398", 215},
  {5.7965889872173257438601825e-244, 10, "5796588987", -243},
  {8.8956833013204884988748079e-257, 12, "889568330132", -256},
  {2.8898440150451831631953191e+215, 1, "3", 216},
  {1.0457387511939190328121185e+07, 12, "104573875119", 8},
  {2.1994324071801781888634269e+300, 9, "219943241", 301},
  {1.9933910276844445021385870e-16, 5, "19934", -15},
  {3.6780978866224470518305873e+254, 9, "367809789", 255},
  {1.0666118484015531254930527e+99, 10, "1066611848", 100},
  {3.3200657056318029281794974e+270, 21, "332006570563180292818", 271},
  {8.6449829773756739463617329e+244, 5, "8645", 245},
  {2.5789814701538099441971838e+285, 10, "257898147", 286},
  {3.6389077351298046336998056e-190, 12, "363890773513", -189},
  {3.7103315920474650125194868e+144, 7, "3710332", 145},
  {3.3802163186171830741868591e-66, 20, "33802163186171830742", -65},
  {2.7916426443655844842408864e-278, 12, "279164264437", -277},
  {1.2500421487313299115600598e+96, 10, "1250042149", 97},
  {1.8321769501109224949038438e-286, 6, "183218", -285},
  {1.1007145284342092653850144e+79, 18, "110071452843420927", 80},
  {1.2522154144209901048362627e-07, 2, "13", -6},
  {6.8490666298486589346024606e+292, 7, "6849067", 293},
  {1.5229795734944695536133468e-69, 9, "152297957", -68},
  {6.3662066016834386678675413e-204, 21, "636620660168343866787", -203},
  {1.2799964609248871093358907e-234, 10, "1279996461", -233},
  {2.0748138864761067614524184e-292, 5, "20748", -291},
  {8.3304877309871859375000000e+13, 3, "833", 14},
  {1.4382237258031336625389555e+127, 19, "1438223725803133663", 128},
  {1.6686345176616165745048011e+192, 9, "166863452", 193},
  {3.7094369251853219903859421e+234, 8, "37094369", 235},
  {7.0311259117020248141126481e-28, 21, "703112591170202481411", -27},
  {6.0920933177827416138300309e+34, 2, "61", 35},
  {8.8884529124053333227949180e+252, 9, "888845291", 253},
  {2.3648012284894795613258590e+253, 14, "23648012284895", 254},
  {1.7550886421414606306178481e+163, 17, "17550886421414606", 164},
  {2.8892322494888161250381699e-24, 14, "28892322494888", -23},
  {1.3501916045802855898629589e+81, 13, "135019160458", 82},
  {1.2975699426767904743485044e-143, 11, "12975699427", -142},
  {3.8449894981371083557801773e-253, 1, "4", -252},
  {8.9430411118564026302164561e-184, 19, "894304111185640263", -183},
  {2.2650464683987650229957784e+265, 12, "22650464684", 266},
  {4.6626972411653568040828948e+151, 5, "46627", 152},
  {1.5888709676203874030233777e-58, 16, "1588870967620387", -57},
  {1.3720973892992940727116631e+145, 11, "13720973893", 146},
  {2.0797302109272420987408385e+298, 3, "208", 299},
  {1.6459452934538847875382859e+161, 9, "164594529", 162},
  {4.5542105891217552327751889e+200, 15, "455421058912176", 201},
  {5.5819679213447835658927618e-80, 16, "5581967921344784", -79},
  {7.2069331089659364326586347e+263, 6, "720693", 264},
  {1.1677403421286887593378995e+204, 5, "11677", 205},
  {2.8903404446850017622720099e+259, 2, "29", 260},
  {4.5056585191401334720896508e-91, 11, "45056585191", -90},
  {4.4415384471336208402121952e+247, 12, "444153844713", 248},
  {2.1216516418514534575703155e-281, 21, "212165164185145345757", -280},
  {2.5010529257730708949035937e+300, 12, "250105292577", 301},
  {3.6752382350087373763038131e+257, 1, "4", 258},
  {5.2798235942070568597049053e-06, 6, "527982", -5},
  {1.4231803238409833984375000e+13, 20, "14231803238409833984", 14},
  {6.9015927449497913081747859e-152, 10, "6901592745", -151},
  {2.4203585082396985375438962e-163, 17, "24203585082396985", -162},
  {5.9771917392590482503523410e-119, 9, "597719174", -118},
  {3.3617220638531648408888442e-121, 15, "336172206385316", -120},
  {1.9098391322955425563295002e-240, 8, "19098391", -239},
  {7.5502636016339585144393321e+95, 7, "7550264", 96},
  {3.8700009340416825256733242e-135, 1, "4", -134},
  {7.4769902741913774391686565e+133, 9, "747699027", 134},
  {2.1162047097279532741999975e+56, 2, "21", 57},
  {2.7858537361508823922748596e+277, 12, "278585373615", 278},
  {5.2400575192879122387185841e-239, 8, "52400575", -238},
  {2.1461607593341636883002445e+126, 21, "21461607593341636883", 127},
  {8.7561743934163981874908230e+280, 16, "8756174393416398", 281},
  {7.2657261832984196664135299e+156, 9, "726572618", 157},
  {1.1887497131781860727758989e-159, 15, "118874971317819", -158},
  {7.2900292782707458375050419e+90, 8, "72900293", 91},
  {3.2005051820091476162171720e+171, 10, "3200505182", 172},
  {9.1913676106340767618027334e-31, 7, "9191368", -30},
  {1.1743062885006290118471251e-281, 7, "1174306", -280},
  {4.3397411327322403116093910e+155, 10, "4339741133", 156},
  {1.1813489504224708151593714e-287, 4, "1181", -286},
  {3.0123895126450828033464543e+56, 10, "3012389513", 57},
  {1.6227278405180548890525886e-284, 14, "16227278405181", -283},
  {1.1521334540859564199562049e+48, 13, "1152133454086", 49},
  {1.3685188042033840833831384e-71, 16, "1368518804203384", -70},
  {4.0717648033113894017480745e-19, 20, "40717648033113894017", -18},
  {4.4727352193331154386298683e-65, 3, "447", -64},
  {1.1802826968985731079812948e-72, 16, "1180282696898573", -71},
  {1.4186843483859771729023964e+153, 7, "1418684", 154},
  {5.0827430740143275411542205e+286, 18, "508274307401432754", 287},
  {2.0298016108911721194251722e-281, 13, "2029801610891", -280},
  {6.0741775260914706015587752e+32, 17, "60741775260914706", 33},
  {3.4451540787292014895641646e+286, 8, "34451541", 287},
  {1.1988191070456805082658869e-151, 1, "1", -150},
  {4.7919511199406970528192230e-221, 16, "4791951119940697", -220},
  {5.0631103920807435228569193e+269, 12, "506311039208", 270},
  {6.3528181170850074474424646e+293, 6, "635282", 294},
  {6.0519590339632587448858087e+233, 6, "605196", 234},
  {8.5461316240261819782939656e+229, 12, "854613162403", 230},
  {8.6710538331277752104020310e+143, 3, "867", 144},
  {8.8308258621804406693364281e-157, 1, "9", -156},
  {3.7080101384011603349485033e-191, 14, "37080101384012", -190},
  {4.5682819644104760899250767e+215, 8, "4568282", 216},
  {2.0354521204160134132984889e+227, 2, "2", 228},
  {1.0139841217287516778603013e-101, 20, "10139841217287516779", -100},
  {4.4619366891980271018654794e+173, 10, "4461936689", 174},
  {1.3575207745573623701380622e-233, 9, "135752077", -232},
  {7.9596666460745949934932261e+46, 6, "795967", 47},
  {7.5191701260324711917180494e+42, 17, "75191701260324712", 43},
  {1.4619902727778945141006706e-127, 2, "15", -126},
  {2.0164937929055131953944446e-221, 21, "201649379290551319539", -220},
  {4.1812363039276308593750000e+12, 8, "41812363", 13},
  {2.0917075621105419001787749e+68, 21, "209170756211054190018", 69},
  {1.0792417182064969762777280e-265, 9, "107924172", -264},
  {2.7952339642525829112172275e+250, 5, "27952", 251},
  {2.2139079391134447778283275e+51, 6, "221391", 52},
  {4.6469088028380588101897256e+225, 9, "46469088", 226},
  {5.0513503766870129286443449e-285, 7, "505135", -284},
  {2.1153110866480547838482656e+171, 12, "211531108665", 172},
  {9.2463995732380708809231617e+266, 18, "924639957323807088", 267},
  {4.9735391541780645627902846e-118, 1, "5", -117},
  {1.3273025973503756665998008e-91, 3, "133", -90},
  {5.1936626071173942483558146e+270, 14, "51936626071174", 271},
  {3.2425832411141434864787823e-170, 8, "32425832", -169},
  {1.6240236345158190511617652e+223, 19, "1624023634515819051", 224},
  {9.7671227754071455857999776e+147, 11, "97671227754", 148},
  {4.6596012107900761677476079e-122, 6, "46596", -121},
  {1.6859717222233924071227235e-76, 7, "1685972", -75},
  {1.7741904629787687894621328e-82, 2, "18", -81},
  {3.1539577212545261235862695e-80, 2, "32", -79},
  {5.1917751783297554854762217e-35, 21, "519177517832975548548", -34},
  {9.5416166367610400564285669e+290, 13, "9541616636761", 291},
  {1.7356441781851195207198027e+264, 21, "173564417818511952072", 265},
  {2.8554534390103315594151839e+130, 8, "28554534", 131},
  {1.7369086324589183779446310e-221, 17, "17369086324589184", -220},
  {3.2484577074643360503891774e-231, 2, "32", -230},
  {9.7783731523966715771498645e+156, 18, "977837315239667158", 157},
  {1.2596392415463541936462355e+238, 4, "126", 239},
  {9.7163179643346696965884553e+234, 2, "97", 235},
  {1.3602558987987840152503414e-231, 10, "1360255899", -230},
  {5.6899668385365590477417341e-177, 4, "569", -176},
  {7.7962897871441174042357131e-118, 10, "7796289787", -117},
  {3.6164838076019756800000000e+17, 8, "36164838", 18},
  {4.9054614666645437827962627e-121, 14, "49054614666645", -120},
  {4.0113969795803975027777044e+230, 17, "40113969795803975", 231},
  {2.6209302966511974985057566e+219, 10, "2620930297", 220},
  {1.3144368449139498717811954e-256, 6, "131444", -255},
  {1.1167599985213928402019444e+142, 8, "111676", 143},
  {1.3251973279298589222815914e+243, 15, "132519732792986", 244},
  {3.3926090244020571674472082e-139, 21, "339260902440205716745", -138},
  {4.5953668126441408438170836e-104, 21, "459536681264414084382", -103},
  {1.3672875847382937074732608e-75, 15, "136728758473829", -74},
  {7.4036123169155970522612967e+242, 4, "7404", 243},
  {6.9800554190067761169099241e-108, 7, "6980055", -107},
  {1.1590164041511505476818312e-35, 9, "11590164", -34},
  {3.7387615892116621059875047e+119, 12, "373876158921", 120},
  {1.1812743122004886666367850e-200, 7, "1181274", -199},
  {3.6563836043754042136268602e-279, 6, "365638", -278},
  {3.5922788083528869213333157e-13, 8, "35922788", -12},
  {3.4024322170825624857802625e-69, 3, "34", -68},
  {2.0234206027186225342860892e-141, 5, "20234", -140},
  {3.6089823462062669184726038e+272, 20, "36089823462062669185", 273},
  {5.1783977054233877047387514e+218, 10, "5178397705", 219},
  {1.1645420917205795853570555e-240, 19, "1164542091720579585", -239},
  {4.3617379160114034403812207e-289, 1, "4", -288},
  {2.0802820198883431872656433e-48, 12, "208028201989", -47},
  {8.9657793196230901760000000e+20, 10, "896577932", 21},
  {1.5094626405436928436035496e-192, 12, "150946264054", -191},
  {1.3758277293756591503175069e-126, 20, "13758277293756591503", -125},
  {5.8073411731165713043260753e+198, 15, "580734117311657", 199},
  {7.1917560561616997144639196e+96, 8, "71917561", 97},
  {6.3492665123057521701140930e-95, 15, "634926651230575", -94},
  {2.3845104899724181569047009e+261, 16, "2384510489972418", 262},
  {4.4302679100917167687245669e+164, 11, "44302679101", 165},
  {4.4999478893104130989744949e+190, 12, "449994788931", 191},
  {4.7325377816170015490048000e+22, 19, "4732537781617001549", 23},
  {8.4221252530179574958490536e+303, 1, "8", 304},
  {2.8895184703780216551591961e-146, 18, "288951847037802166", -145},
  {1.3097024784643670997922173e+124, 17, "13097024784643671", 125},
  {6.5674441666695837840324962e-25, 11, "65674441667", -24},
  {3.7064007240728349369372907e+95, 17, "37064007240728349", 96},
  {2.1087522802287126341629453e-112, 10, "210875228", -111},
  {1.9578879195832531324722650e-48, 6, "195789", -47},
  {6.2330294580586012790062721e-174, 19, "6233029458058601279", -173},
  {1.3508971354494353876412872e-191, 1, "1", -190},
  {5.7442020945667198171900488e+51, 9, "574420209", 52},
  {9.8172047149171168291897274e+155, 15, "981720471491712", 156},
  {1.4192513212044123989031615e-79, 5, "14193", -78},
  {1.3733115053136773315043739e+196, 13, "1373311505314", 197},
  {1.0702689599523490685331528e-307, 20, "10702689599523490685", -306},
  {1.9563552081782285468978648e-234, 13, "1956355208178", -233},
  {8.0298234176979206825841208e-191, 6, "802982", -190},
  {2.7009634555223369461824727e+196, 1, "3", 197},
  {2.7681184099530543595236519e+60, 15, "276811840995305", 61},
  {8.8923878688463669071612232e-171, 19, "8892387868846366907", -170},
  {1.3681848209075852782717840e-110, 11, "13681848209", -109},
  {1.4772181330451983826739722e-184, 12, "147721813305", -183},
  {1.1168846844930435846012330e-279, 19, "1116884684493043585", -278},
  {2.2322864957635651735629836e+190, 14, "22322864957636", 191},
  {6.6809346613018127331000621e-270, 12, "66809346613", -269},
  {2.2601415640280167145361734e-223, 5, "22601", -222},
  {3.2888015541237429566016264e+123, 6, "32888", 124},
  {1.8778072518515780955924173e-83, 9, "187780725", -82},
  {6.8706396830278664451908705e-156, 11, "6870639683", -155},
  {2.2651496988995655345995948e-263, 9, "22651497", -262},
  {1.9019091589587484392879951e+124, 8, "19019092", 125},
  {8.6774070512547496326037343e+117, 21, "86774070512547496326", 118},
  {3.4052604769582022694980661e-119, 1, "3", -118},
  {8.0548845500501281000874337e+175, 21, "805488455005012810009", 176},
  {2.4158767908088539097670798e-228, 13, "2415876790809", -227},
  {9.4185392252828308607262719e-113, 6, "941854", -112},
  {4.0267927209657239407577824e-246, 18, "402679272096572394", -245},
  {2.6507924850310646397386946e-163, 18, "265079248503106464", -162},
  {7.6555379364950502131315031e-128, 3, "766", -127},
  {6.8671593706787783943293745e-34, 16, "6867159370678778", -33},
  {1.8429685102017499501535172e-90, 2, "18", -89},
  {4.7027277244992444038472866e+91, 10, "4702727724", 92},
  {7.4073188251477689289667667e+40, 3, "741", 41},
  {3.1769650207669112031900392e+116, 20, "31769650207669112032", 117},
  {7.7476461765437514050122415e+274, 7, "7747646", 275},
  {4.7178110338984481515737035e-121, 12, "47178110339", -120},
  {5.2814032120093281094170875e+235, 15, "528140321200933", 236},
  {9.0342980766886507771375963e+116, 20, "90342980766886507771", 117},
  {3.2478581858273687595600240e+263, 4, "3248", 264},
  {4.4457063359470119515788160e+103, 18, "444570633594701195", 104},
  {1.8089424046831994344178338e-26, 18, "180894240468319943", -25},
  {5.1379640798048893668869652e-151, 11, "51379640798", -150},
  {4.5899453064208685189343183e-200, 19, "4589945306420868519", -199},
  {4.3352905977272792966224436e+261, 11, "43352905977", 262},
  {4.8684716950403257865920371e+180, 5, "48685", 181},
  {7.9997502785588063587865535e-138, 9, "799975028", -137},
  {3.3064885179140917952539205e-139, 7, "3306489", -138},
  {2.9286301685866419981213854e+199, 12, "292863016859", 200},
  {8.5388606468092667402767982e+91, 13, "8538860646809", 92},
  {2.8887708013092742594038935e-81, 3, "289", -80},
  {6.9907273106957892120812862e-89, 15, "699072731069579", -88},
  {3.0587987854900601967062998e+103, 12, "305879878549", 104},
  {1.5875184396320915039557922e-38, 17, "15875184396320915", -37},
  {5.0608546442067057185383227e-48, 4, "5061", -47},
  {1.2408926368906036720948714e+191, 14, "12408926368906", 192},
  {4.2255484014568397002039001e+224, 2, "42", 225},
  {2.2225943838634942113823251e+104, 4, "2223", 105},
  {4.2785650262389281757846203e+48, 6, "427857", 49},
  {5.0009281836558217178428495e-112, 7, "5000928", -111},
  {3.2625260624224540435886738e+32, 16, "3262526062422454", 33},
  {6.0170784380367080499714636e-171, 8, "60170784", -170},
  {8.1890407518613044524482560e+25, 15, "81890407518613", 26},
  {9.9238565160320110394343705e+55, 18, "992385651603201104", 56},
  {1.3989425092938931099311045e-111, 19, "139894250929389311", -110},
  {7.4355392610206450378703123e-94, 2, "74", -93},
  {2.4637145893322493592756753e-214, 17, "24637145893322494", -213},
  {2.1250502408445676593294521e-112, 17, "21250502408445677", -111},
  {3.8410311556321515804900544e+286, 19, "384103115563215158", 287},
  {2.8682669319473730287096597e+76, 10, "2868266932", 77},
  {2.3576158640915363493009190e+230, 14, "23576158640915", 231},
  {2.7832655739363271761521107e-75, 20, "27832655739363271762", -74},
  {8.8383171066063983700191654e+139, 15, "88383171066064", 140},
  {7.5848695578627575977412535e+254, 14, "75848695578628", 255},
  {6.4168496006532065034644319e-04, 17, "64168496006532065", -3},
  {3.9853558859160791632775577e-236, 10, "3985355886", -235},
  {8.5045429156322629301200224e+226, 1, "9", 227},
  {1.0768947609665732044207244e+71, 3, "108", 72},
  {8.7156277263862325107232405e+121, 21, "871562772638623251072", 122},
  {1.8076499867975410909350002e-77, 3, "181", -76},
  {6.1710000263982005944632079e+293, 16, "6171000026398201", 294},
  {2.2921142287847116749259172e-282, 1, "2", -281},
  {1.0997643279340085961514025e+27, 19, "1099764327934008596", 28},
  {1.8371179710422450717130210e-109, 16, "1837117971042245", -108},
  {3.9937514128345778335998907e+285, 13, "3993751412835", 286},
  {9.8297454799101582345494152e+144, 2, "98", 145},
  {4.8147460154196174624622104e-206, 6, "481475", -205},
  {1.9595953419768621353623542e-196, 15, "195959534197686", -195},
  {9.1405474059397765701391799e-265, 2, "91", -264},
  {6.4811216626474104299229545e-201, 13, "6481121662647", -200},
  {5.1163250355530176874396808e-03, 15, "511632503555302", -2},
  {1.6767768318446115904520780e-98, 14, "16767768318446", -97},
  {1.8714481461265213568687059e+208, 7, "1871448", 209},
  {2.0864800895574469581343006e-249, 15, "208648008955745", -248},
  {3.2981107866845742029692511e+41, 6, "329811", 42},
  {7.2714692502497012992899916e-176, 7, "7271469", -175},
  {3.6925385756737934825091856e-57, 16, "3692538575673793", -56},
  {4.4428160735024555775934447e+170, 17, "44428160735024556", 171},
  {7.2031554285264438912559337e+265, 8, "72031554", 266},
  {5.9803899180964886999660815e-227, 13, "5980389918096", -226},
  {5.5290997586002446146087912e-220, 15, "552909975860024", -219},
  {1.0751152545665156127502082e-293, 12, "107511525457", -292},
  {7.9421992064282928302792027e-265, 13, "7942199206428", -264},
  {1.4665828795178688921822909e-288, 8, "14665829", -287},
  {7.8790644809980633901964515e+295, 6, "787906", 296},
  {1.5335362720604718367461338e-247, 8, "15335363", -246},
  {3.3010069105747464253201832e-237, 7, "3301007", -236},
  {2.2098248670904115926562453e+138, 13, "220982486709", 139},
  {1.2499380671607326991276902e+227, 12, "124993806716", 228},
  {9.6612044205666857208085314e+139, 5, "96612", 140},
  {5.7838971744619355860929053e+227, 7, "5783897", 228},
  {4.0011665961104470315123492e-45, 4, "4001", -44},
  {1.4846627464216102339424276e-177, 14, "14846627464216", -176},
  {6.8775708144224023977488643e+200, 12, "687757081442", 201},
  {5.3916684852736396838405687e+67, 16, "539166848527364", 68},
  {5.6725982097048613612679160e+32, 18, "567259820970486136", 33},
  {5.3154688709185916565895345e+254, 12, "531546887092", 255},
  {6.7231443753647659560407047e-16, 19, "6723144375364765956", -15},
  {1.3162612352527423072178437e-41, 14, "13162612352527", -40},
  {3.1686545626488544287221167e-27, 3, "317", -26},
  {8.5754634024388505268815380e+156, 7, "8575463", 157},
  {1.8749442511033507412535212e-136, 17, "18749442511033507", -135},
  {2.1079921414047222933616182e+287, 10, "2107992141", 288},
  {5.3448698772392404757252689e+281, 4, "5345", 282},
  {3.6529521802221578801949418e-109, 1, "4", -108},
  {2.6061407439363855541148001e+106, 13, "2606140743936", 107},
  {2.7579902993254980982575495e-86, 18, "27579902993254981", -85},
  {1.2385711225866869353647832e-236, 21, "123857112258668693536", -235},
  {6.5014521429272350636336074e+207, 8, "65014521", 208},
  {1.0598536270239296929039961e-142, 9, "105985363", -141},
  {2.0790711661208353225677639e-251, 20, "20790711661208353226", -250},
  {3.3119138456570996534267208e+245, 16, "33119138456571", 246},
  {1.2575517910290781198408891e-172, 18, "125755179102907812", -171},
  {2.2102494731634260581385030e+199, 9, "221024947", 200},
  {1.1919809905687758658272255e+260, 20, "11919809905687758658", 261},
  {2.4416425423440216211333627e-107, 16, "2441642542344022", -106},
  {7.3240440467973427140542464e-230, 4, "7324", -229},
  {1.1621598780819861462710714e-187, 15, "116215987808199", -186},
  {4.8330719895840238551411292e+108, 7, "4833072", 109},
  {1.2882767687968864192690565e-103, 6, "128828", -102},
  {2.5047132710436182790284322e-144, 11, "2504713271", -143},
  {2.9627736004058729932142446e-260, 17, "2962773600405873", -259},
  {7.2847386489586800000000000e+15, 18, "728473864895868", 16},
  {8.7176395424678015245936865e-26, 19, "8717639542467801525", -25},
  {1.1070962730287367886156676e-308, 15, "110709627302874", -307},
  {1.6778701682461759587851420e+56, 3, "168", 57},
  {2.9225127899755885573384651e+232, 6, "292251", 233},
  {1.5807053335652289076960750e-174, 12, "158070533357", -173},
  {4.5424235266554665923543784e+185, 11, "45424235267", 186},
  {2.2504316328449131151360000e+21, 11, "22504316328", 22},
  {1.1695861672946485056700123e-145, 19, "1169586167294648506", -144},
  {1.9474280346076916923187613e-160, 20, "19474280346076916923", -159},
  {9.1150781230935368810756659e+53, 9, "911507812", 54},
  {5.4379389568526635062046954e-86, 4, "5438", -85},
  {3.6858184165696285651153310e+161, 20, "36858184165696285651", 162},
  {1.8173788291163391470239506e-25, 8, "18173788", -24},
  {2.0150981295521351902113712e+75, 5, "20151", 76},
  {9.5401222285559672737271762e+246, 8, "95401222", 247},
  {2.5818302318379751251631057e+298, 20, "25818302318379751252", 299},
  {8.1845967411933275930573171e-278, 20, "81845967411933275931", -277},
  {2.4127155262824404055011463e-225, 8, "24127155", -224},
  {3.7570310706700434729809788e-159, 18, "375703107067004347", -158},
  {7.7256041810640304550791422e+69, 14, "7725604181064", 70},
  {5.1982753951097192982749375e+222, 18, "51982753951097193", 223},
  {6.3973282620847117222365583e+84, 14, "63973282620847", 85},
  {5.3417025481727594480532751e+180, 13, "5341702548173", 181},
  {1.0678771534336701331969162e-275, 4, "1068", -274},
  {1.2049651990277995030858146e+146, 5, "1205", 147},
  {3.6108619922239369505535128e+199, 14, "36108619922239", 200},
  {2.5076833760392801791848613e+259, 15, "250768337603928", 260},
  {1.6467115457138234105289997e+249, 3, "165", 250},
  {1.3221571861663930035615400e-107, 18, "1322157186166393", -106},
  {5.4333183346260272095110897e+305, 18, "543331833462602721", 306},
  {1.5644231854869529917049813e+219, 12, "156442318549", 220},
  {9.0289257731010708900560241e+27, 9, "902892577", 28},
  {2.4425516071982863558038109e-275, 3, "244", -274},
  {1.5577496597355617360642780e-285, 9, "155774966", -284},
  {9.7489785137255033602989218e-290, 7, "9748979", -289},
  {2.4807658617682632642743950e-244, 3, "248", -243},
  {5.9090906609008310248798832e-123, 3, "591", -122},
  {1.2955134122689323914525243e-38, 21, "129551341226893239145", -37},
  {8.7966724726933107365026620e-07, 12, "879667247269", -6},
  {1.5595051292755374150323924e+193, 11, "15595051293", 194},
  {1.2361335260731541259265628e-138, 18, "123613352607315413", -137},
  {1.3663653521821880928944224e-174, 9, "136636535", -173},
  {8.9769826823613430000000000e+15, 3, "898", 16},
  {2.6329254439845718130688000e+22, 16, "2632925443984572", 23},
  {3.2995675913671041369891914e-74, 5, "32996", -73},
  {5.2010712902214998166055201e-58, 4, "5201", -57},
  {1.6219595446360716398442465e-223, 13, "1621959544636", -222},
  {2.1789768713109735274260783e-186, 7, "2178977", -185},
  {5.2133989111378771066665649e+08, 7, "5213399", 9},
  {3.2206141096316245195125418e+300, 20, "32206141096316245195", 301},
  {2.6964394493301684550529114e-149, 9, "269643945", -148},
  {1.1218523734543077328928965e-231, 10, "1121852373", -230},
  {1.0526547712169113106078461e-87, 3, "105", -86},
  {4.3882082927959012831374211e-08, 21, "438820829279590128314", -7},
  {5.3513355731080061202592134e-167, 9, "535133557", -166},
  {1.5973746607054044477288445e-178, 13, "1597374660705", -177},
  {7.7254957680405878713720132e+301, 14, "77254957680406", 302},
  {1.5785730840182497831636955e-98, 6, "157857", -97},
  {4.3764415111693588398654246e+276, 2, "44", 277},
  {5.7560179806576948520122439e-17, 4, "5756", -16},
  {1.5352399218153208414208000e+22, 5, "15352", 23},
  {2.0223664942385785343262822e+284, 13, "2022366494239", 285},
  {5.7998537139676705717968428e+108, 8, "57998537", 109},
  {2.2704005211615231331500402e+231, 3, "227", 232},
  {4.2760633328568950984712642e-142, 3, "428", -141},
  {8.6159131304641391588517626e+194, 14, "86159131304641", 195},
  {1.6878368036071059169304815e-192, 16, "1687836803607106", -191},
  {4.8760856300133831789355078e+60, 13, "4876085630013", 61},
  {3.4097566431181100378955223e-169, 2, "34", -168},
  {1.4326521828539925958525415e-211, 6, "143265", -210},
  {1.4004210451931685451333712e-286, 19, "1400421045193168545", -285},
  {1.1489040166267743573550303e-134, 18, "114890401662677436", -133},
  {7.0167659211780938062548371e-152, 16, "7016765921178094", -151},
  {2.0883043476515883636509543e-49, 12, "208830434765", -48},
  {4.9922877749291828050824576e-96, 13, "4992287774929", -95},
  {3.5431874932076342262669251e-246, 5, "35432", -245},
  {2.6206466924739349846363091e-275, 17, "2620646692473935", -274},
  {1.1301278538938297197014777e+289, 4, "113", 290},
  {5.5854404569395856015034951e+03, 18, "55854404569395856", 4},
  {3.9582300572851540753263989e-259, 11, "39582300573", -258},
  {2.0570859130317315518582460e+171, 8, "20570859", 172},
  {5.8561631266679368523681381e+102, 16, "5856163126667937", 103},
  {4.4698990479423413302584720e+210, 21, "446989904794234133026", 211},
  {8.6487089930642766188626323e+198, 18, "864870899306427662", 199},
  {7.8032160578675972290128524e+95, 18, "780321605786759723", 96},
  {1.5133563580961878726209964e+256, 12, "15133563581", 257},
  {1.7621244645954457094036092e-301, 4, "1762", -300},
  {5.9406959953124560247694352e-135, 21, "594069599531245602477", -134},
  {1.5205649723833571278793828e-199, 16, "1520564972383357", -198},
  {1.9324138958515489213108546e-94, 3, "193", -93},
  {2.2676988278917428486329185e+101, 13, "2267698827892", 102},
  {1.4295856904428911893324177e+32, 15, "142958569044289", 33},
  {3.1873750768133646271706994e-01, 12, "318737507681", 0},
  {2.5144011741335337906945428e+46, 2, "25", 47},
  {8.0641620559356938735560886e+175, 15, "806416205593569", 176},
  {6.4289514507797961261577782e+70, 18, "642895145077979613", 71},
  {8.8209188123258477388838867e-270, 17, "88209188123258477", -269},
  {2.5531116592025731459886670e-206, 2, "26", -205},
  {2.9427691598345164086783809e-126, 13, "2942769159835", -125},
  {4.8729234790255920954625874e+200, 2, "49", 201},
  {2.6166831486234008857232684e-41, 13, "2616683148623", -40},
  {1.3217269502239020887607592e-238, 16, "1321726950223902", -237},
  {1.5410551418022512034225073e-289, 18, "15410551418022512", -288},
  {1.6407726013061299518190167e+182, 20, "16407726013061299518", 183},
  {2.0130920718826923005578590e-301, 6, "201309", -300},
  {1.5186444760133127094983929e-206, 2, "15", -205},
  {1.3094233326852572533969484e+94, 17, "13094233326852573", 95},
  {1.7608659674894953045738504e-146, 20, "17608659674894953046", -145},
  {9.6690742963415066303199740e-244, 2, "97", -243},
  {3.8118196679345261731108221e-292, 5, "38118", -291},
  {6.9153488461217567918806271e+128, 19, "6915348846121756792", 129},
  {2.5837211125552084010164733e-308, 12, "258372111256", -307},
  {1.0276846562447896130926116e-30, 13, "1027684656245", -29},
  {3.7036904587986133153943540e+159, 3, "37", 160},
  {4.6359406771309339033783910e-92, 11, "46359406771", -91},
  {1.0163815966234346287890778e-215, 9, "10163816", -214},
  {9.2791103663969047332118835e+67, 18, "927911036639690473", 68},
  {1.0520649106249533194023529e-11, 16, "1052064910624953", -10},
  {2.1044946567527222539588360e-290, 19, "2104494656752722254", -289},
  {4.6400947172293973412602586e-142, 9, "464009472", -141},
  {4.0184571927293049167497698e-44, 10, "4018457193", -43},
  {9.8095529948108407712908057e+262, 18, "980955299481084077", 263},
  {1.6346629779504825428982758e+98, 13, "163466297795", 99},
  {1.2706623498288297887800372e-52, 15, "127066234982883", -51},
  {6.2772176353837178843631644e+86, 17, "62772176353837179", 87},
  {4.1357660387001812949409416e-175, 8, "4135766", -174},
  {2.2104776359300870717864779e-265, 6, "221048", -264},
  {4.9010517844138348664273508e+02, 7, "4901052", 3},
  {8.2629683411064155983992344e-190, 1, "8", -189},
  {1.7805974193146211160502609e-237, 5, "17806", -236},
  {1.6797221677337150452895050e-58, 20, "16797221677337150453", -57},
  {2.3429356880421100055658452e+254, 20, "23429356880421100056", 255},
  {2.6288717344095789532766132e-206, 17, "2628871734409579", -205},
  {3.7944988161475828147780644e-90, 16, "3794498816147583", -89},
  {1.7483244137667324329066496e+25, 6, "174832", 26},
  {8.5463046100352276611855228e-268, 9, "854630461", -267},
  {3.9125138489545421426673382e+293, 21, "391251384895454214267", 294},
  {5.2528908668759982593938597e-22, 9, "525289087", -21},
  {2.7840570997172076818127293e+157, 1, "3", 158},
  {1.0521312071035697873152309e-224, 17, "10521312071035698", -223},
  {1.5655766926765082288598950e+206, 17, "15655766926765082", 207},
  {4.5828008341454225143119105e+79, 21, "458280083414542251431", 80},
  {7.9523902697589020350737772e+160, 15, "79523902697589", 161},
  {6.4443082698906380129293949e+116, 15, "644430826989064", 117},
  {1.4125095106975613988776486e+156, 11, "14125095107", 157},
  {3.1818280822459564605216376e+283, 2, "32", 284},
  {4.2147276232510352174021108e-84, 14, "4214727623251", -83},
  {2.0447594842362869430935969e-173, 8, "20447595", -172},
  {6.9606265509749721006526689e+98, 4, "6961", 99},
  {2.1500897729027677717922759e-190, 8, "21500898", -189},
  {1.3815940463679936696820102e-99, 2, "14", -98},
  {6.1275715659291814095442152e-127, 12, "612757156593", -126},
  {9.7785507735238753647301606e+206, 17, "97785507735238754", 207},
  {6.4578237631983083560981226e-88, 12, "64578237632", -87},
  {3.0707682652695258083883446e+127, 18, "307076826526952581", 128},
  {1.0182011245653525902494774e-177, 8, "10182011", -176},
  {2.5151632319263192369194319e+95, 2, "25", 96},
  {1.3259070877435706140483246e+301, 20, "1325907087743570614", 302},
  {2.4913274855811497086543896e-229, 19, "2491327485581149709", -228},
  {2.5838157674068223262317321e+236, 13, "2583815767407", 237},
  {2.2969175210499657853150388e+269, 10, "2296917521", 270},
  {5.9742633829667138658971840e+221, 2, "6", 222},
  {9.9959889639572867025281294e-58, 11, "9995988964", -57},
  {9.2824048773422207839838631e-254, 3, "928", -253},
  {2.1261387429108244486580194e-154, 2, "21", -153},
  {1.3751715227891491760984947e-236, 4, "1375", -235},
  {1.9894833973524528119014576e+04, 15, "198948339735245", 5},
  {3.5257874524335880978903241e-158, 6, "352579", -157},
  {8.7456452935969642804601993e-67, 5, "87456", -66},
  {1.1986712539436702317917106e+183, 5, "11987", 184},
  {1.2368278865412651159817723e-99, 9, "123682789", -98},
  {5.1621354607806954076124743e+113, 13, "5162135460781", 114},
  {2.8685141206928013052696660e+215, 11, "28685141207", 216},
  {1.3641859946695234311469687e-227, 2, "14", -226},
  {2.6511664662507682535650848e+114, 13, "2651166466251", 115},
  {1.2289628394654693369698686e+271, 8, "12289628", 272},
  {3.4256349579385536095291435e+291, 1, "3", 292},
  {3.3837773239430404082448018e-283, 17, "33837773239430404", -282},
  {1.7149714144945001364814991e-175, 18, "171497141449450014", -174},
  {2.6197243027497485039369292e+64, 14, "26197243027497", 65},
  {1.2542406551734323025772659e-231, 3, "125", -230},
  {2.0035339505048781905050766e+142, 2, "2", 143},
  {2.7611090947184291788488629e+176, 17, "27611090947184292", 177},
  {5.3228545458765841131457656e-179, 12, "532285454588", -178},
  {2.8639753863904286655112462e-285, 1, "3", -284},
  {3.9228577041115873305487956e+62, 7, "3922858", 63},
  {9.5154083078403346405701500e-270, 4, "9515", -269},
  {5.9573809722710077647679925e+51, 14, "5957380972271", 52},
  {3.1125836801712534921248805e+186, 13, "3112583680171", 187},
  {2.0266885000830589323956166e+75, 13, "2026688500083", 76},
  {3.0956472715293701249312824e+175, 3, "31", 176},
  {4.8063569459566333390766290e+232, 3, "481", 233},
  {1.6988689824506844461187924e-209, 14, "16988689824507", -208},
  {2.4455844929623277310520740e-130, 12, "244558449296", -129},
  {1.1622674145173406407678303e-197, 20, "11622674145173406408", -196},
  {3.6295148119098269129073247e+99, 19, "3629514811909826913", 100},
  {1.0885771982120701207463885e-144, 16, "108857719821207", -143},
  {4.2021125984319447651687948e+193, 13, "4202112598432", 194},
  {5.4361056962071594175455269e+292, 10, "5436105696", 293},
  {4.5433146424305220196924880e+128, 3, "454", 129},
  {8.2023194259279356867646290e+32, 9, "820231943", 33},
  {2.5450324183125041533112413e+30, 1, "3", 31},
  {1.4901498450215569647219711e+191, 11, "1490149845", 192},
  {3.1058930579420284143484991e+262, 21, "310589305794202841435", 263},
  {1.0978074312784754601845180e-17, 12, "109780743128", -16},
  {1.0836680841215319881993294e-135, 12, "108366808412", -134},
  {3.1787757685301697249936173e-276, 6, "317878", -275},
  {3.2265346706389966668812488e-235, 7, "3226535", -234},
  {3.6349944363367353236070964e+239, 3, "363", 240},
  {1.0562412988155851859363758e+36, 14, "10562412988156", 37},
  {1.0597973017430380711634140e+144, 3, "106", 145},
  {4.4669389131324815547358522e+206, 6, "446694", 207},
  {1.0144305624480013211576557e-113, 3, "101", -112},
  {5.2573572079726414140985823e+159, 8, "52573572", 160},
  {1.7077432864440747096375035e+242, 19, "170774328644407471", 243},
  {3.7256158423201476823429901e-191, 6, "372562", -190},
  {6.6882400530529781892951655e-58, 6, "668824", -57},
  {2.4047346577583253738375599e-33, 9, "240473466", -32},
  {5.8407012567344913987940684e+234, 6, "58407", 235},
  {2.6217091506524989157381204e-145, 19, "2621709150652498916", -144},
  {2.3896264561684040355487416e+27, 17, "2389626456168404", 28},
  {7.0112864183011911173134090e+27, 3, "701", 28},
  {8.5783356599378624891151011e+39, 7, "8578336", 40},
  {5.5134826102918489979227341e-230, 4, "5513", -229},
  {1.7934467028340357848295779e-78, 13, "1793446702834", -77},
  {2.0982750407580053885658926e+73, 9, "209827504", 74},
  {2.8196118251829937225420462e-08, 7, "2819612", -7},
  {1.5271973244788558962909837e+192, 4, "1527", 193},
  {6.2452684559568094172369844e-153, 13, "6245268455957", -152},
  {2.0880978532230524614257802e+49, 18, "208809785322305246", 50},
  {1.4847260225868066271210289e+305, 19, "1484726022586806627", 306},
  {3.3385072581287849657122184e+112, 15, "333850725812878", 113},
  {1.8440818741316297211907013e-143, 18, "184408187413162972", -142},
  {7.2759632632146364302205100e-94, 7, "7275963", -93},
  {8.2314705568586667493854622e-302, 21, "823147055685866674939", -301},
  {1.8015751619228415086977807e+31, 6, "180158", 32},
  {1.0007620923629276799005083e+00, 5, "10008", 1},
  {9.0755861585531148639327577e+280, 16, "9075586158553115", 281},
  {7.8081547140940736006485795e+295, 14, "78081547140941", 296},
  {1.1314003403679924990947924e-224, 6, "11314", -223},
  {1.1934131374406605581762921e-307, 4, "1193", -306},
  {5.5157363278460791700806466e-155, 14, "55157363278461", -154},
  {3.8090378074616356996731841e+133, 15, "380903780746164", 134},
  {1.2597396684109347681050928e+111, 6, "125974", 112},
  {4.7641471465894163349349205e+69, 14, "47641471465894", 70},
  {1.1621199778510667624994354e+295, 3, "116", 296},
  {3.1526529451300701077504000e+22, 21, "315265294513007010775", 23},
  {1.0595124592757643779214036e+254, 7, "1059512", 255},
  {2.1292112902506089311627780e-76, 6, "212921", -75},
  {1.5945737864130884227153756e-145, 2, "16", -144},
  {4.9817100904113666039002536e-148, 16, "4981710090411367", -147},
  {1.5555231636715615444019742e-257, 19, "1555523163671561544", -256},
  {2.1173068674963666918575618e+150, 1, "2", 151},
  {1.8542858182952148905694640e-193, 18, "185428581829521489", -192},
  {3.2383027818146983766877407e-161, 20, "32383027818146983767", -160},
  {2.2877048977999162161722779e+05, 3, "229", 6},
  {7.4596737866012506723166096e+107, 20, "74596737866012506723", 108},
  {2.5951417406527322756538382e-256, 13, "2595141740653", -255},
  {7.7846967001018092992742393e-124, 20, "77846967001018092993", -123},
  {2.2754270349618114281582084e-70, 2, "23", -69},
  {1.0325597713667536864062563e-178, 4, "1033", -177},
  {1.6568430323526465763332257e+131, 7, "1656843", 132},
  {1.5678681376381429009327555e+37, 18, "15678681376381429", 38},
  {1.6405898960868060575591775e+47, 1, "2", 48},
  {1.1567744667171406674212148e-203, 18, "115677446671714067", -202},
  {2.8332084606595596107112108e+131, 9, "283320846", 132},
  {1.3705296385352381552388055e+181, 10, "1370529639", 182},
  {4.0414165724431009053340145e-32, 20, "40414165724431009053", -31},
  {4.9760659507673182548606594e-112, 11, "49760659508", -111},
  {2.5379215143926403414814148e+201, 8, "25379215", 202},
  {2.8204496363633871221258631e-263, 13, "2820449636363", -262},
  {6.4154461772083448777999860e+48, 1, "6", 49},
  {2.9801273171614909517939975e+299, 3, "298", 300},
  {4.4217023259787854021205623e-237, 18, "44217023259787854", -236},
  {5.9498443329691584613438948e-02, 4, "595", -1},
  {1.9691621867761345532534664e-291, 5, "19692", -290},
  {6.5979943816779474890584287e+35, 2, "66", 36},
  {3.3988129701960456723294167e-119, 5, "33988", -118},
  {2.0813194118372351233424627e-302, 16, "2081319411837235", -301},
  {1.7784294253587957727549868e-99, 17, "17784294253587958", -98},
  {6.1206013296527946364041353e+119, 16, "6120601329652795", 120},
  {1.8839940006214396444243237e+231, 7, "1883994", 232},
  {4.3727367381539003639927136e-72, 20, "4372736738153900364", -71},
  {6.1255085754092866138296920e+298, 11, "61255085754", 299},
  {1.3471382767606807246765788e+200, 15, "134713827676068", 201},
  {1.0181754670040921252086839e+51, 21, "101817546700409212521", 52},
  {3.6502728602774457580446284e-243, 2, "37", -242},
  {1.6914974802507308479412309e-06, 16, "1691497480250731", -5},
  {2.2282642337349757617655501e-68, 15, "222826423373498", -67},
  {4.0278746389578688169695126e+203, 17, "40278746389578688", 204},
  {6.4724035876209228090767060e+194, 12, "647240358762", 195},
  {1.3409224892179559185559356e+114, 5, "13409", 115},
  {3.3141157060506136174207627e-202, 10, "3314115706", -201},
  {3.3602650603057258605957031e+10, 9, "336026506", 11},
  {1.0809230055634415101442269e-69, 12, "108092300556", -68},
  {6.6988339025792759576617374e-261, 3, "67", -260},
  {2.4714799093312741733016529e-86, 15, "247147990933127", -85},
  {1.9309027078176749994013697e-204, 10, "1930902708", -203},
  {6.2293077330969223024633744e-71, 19, "6229307733096922302", -70},
  {6.9048421651342105803031091e+93, 15, "690484216513421", 94},
  {1.6965822116083650467451384e-192, 16, "1696582211608365", -191},
  {1.3068476279991087852841027e-73, 9, "130684763", -72},
  {6.7180557142666831607469273e-218, 7, "6718056", -217},
  {4.8787260469347788770458674e-160, 18, "487872604693477888", -159},
  {5.5205693120848537739772733e-27, 1, "6", -26},
  {7.5164668439403953548612220e-155, 13, "751646684394", -154},
  {5.7253959646465312783387853e+26, 9, "572539596", 27},
  {7.2117212639180369602005220e+288, 2, "72", 289},
  {5.6251780984018041307399070e-39, 4, "5625", -38},
  {2.2966564231190732929343903e+232, 13, "2296656423119", 233},
  {2.3557242680372836474829577e-162, 8, "23557243", -161},
  {1.7241622929908098144750374e+143, 13, "1724162292991", 144},
  {8.8392738008754722014951571e+169, 7, "8839274", 170},
  {1.1332740262940317298660444e-152, 6, "113327", -151},
  {1.2376550279434773571488948e-148, 4, "1238", -147},
  {2.9404752331132844086189851e-96, 4, "294", -95},
  {3.5937851821287667382158128e-217, 10, "3593785182", -216},
  {4.3392153021877803217209854e+280, 12, "433921530219", 281},
  {2.9119211942300456391367381e-285, 10, "2911921194", -284},
  {2.8845893822299153641457658e+135, 19, "2884589382229915364", 136},
  {2.0700275648201023768204543e-97, 17, "20700275648201024", -96},
  {1.5349417193468007430921100e-14, 17, "15349417193468007", -13},
  {7.3622595163424660425910851e-68, 4, "7362", -67},
  {1.0525798259260166185077484e+281, 6, "105258", 282},
  {2.5041559676192001672634608e-132, 16, "25041559676192", -131},
  {2.8611815790850056701069346e+180, 12, "286118157909", 181},
  {8.3242379476521527803208958e-146, 18, "832423794765215278", -145},
  {2.3946185538182352122098538e+88, 19, "2394618553818235212", 89},
  {2.8615008547674203871641416e-115, 17, "28615008547674204", -114},
  {1.2199581928010927563251154e+154, 1, "1", 155},
  {2.5036095795434865894501691e+103, 9, "250360958", 104},
  {3.9936311286661534184022159e+241, 8, "39936311", 242},
  {5.2747189274429946959645748e+278, 21, "527471892744299469596", 279},
  {5.9493264192481079980148082e-237, 4, "5949", -236},
  {6.7112267639554752643072000e+22, 17, "67112267639554753", 23},
  {4.8256851920937878416687130e+164, 3, "483", 165},
  {6.1294453780772198423827181e+268, 4, "6129", 269},
  {2.5502381496498263572554872e+102, 14, "25502381496498", 103},
  {4.7014077436343710937500000e+12, 4, "4701", 13},
  {2.9004269149693599347326168e+124, 7, "2900427", 125},
  {1.1153006980878499876820918e+152, 3, "112", 153},
  {6.3928271735456014923610377e+40, 16, "6392827173545601", 41},
  {1.8129233018110062559971190e-159, 10, "1812923302", -158},
  {2.7088479261316108024075674e-228, 2, "27", -227},
  {6.7049383212474720892061409e+70, 18, "670493832124747209", 71},
  {4.5617479555690695139950016e-272, 10, "4561747956", -271},
  {1.0977442610491550435387638e+27, 14, "10977442610492", 28},
  {4.2320347784941003310791964e-163, 19, "4232034778494100331", -162},
  {1.1171431760477929861347759e-137, 10, "1117143176", -136},
  {2.3549809079005166365448141e+258, 4, "2355", 259},
  {4.4612869771380802522212492e+148, 8, "4461287", 149},
  {5.4309027482248862783538380e+147, 12, "543090274822", 148},
  {3.4937385892357105274617375e-127, 8, "34937386", -126},
  {1.1302080857078777501664908e+108, 4, "113", 109},
  {5.4784607343653131409355314e-130, 18, "547846073436531314", -129},
  {1.0548615614801626595369785e-100, 9, "105486156", -99},
  {9.0493685197815086598188166e-306, 5, "90494", -305},
  {2.8963481991252539439900508e-207, 5, "28963", -206},
  {1.9461839163183565703120606e+65, 15, "194618391631836", 66},
  {3.0234877005634345911863174e-57, 3, "302", -56},
  {1.4115953080941640625000000e+14, 18, "141159530809416406", 15},
  {4.0805031114687190819177656e+168, 13, "4080503111469", 169},
  {6.7394116248532113333459990e-303, 2, "67", -302},
  {2.9294711720735535960309394e-145, 7, "2929471", -144},
  {3.2252867898447508735469826e+48, 6, "322529", 49},
  {1.2248427383225433849710270e-92, 14, "12248427383225", -91},
  {2.4749047973736619620036801e+48, 10, "2474904797", 49},
  {1.1260686593206751591489860e-224, 21, "112606865932067515915", -223},
  {9.6111373168808513519611135e+205, 21, "961113731688085135196", 206},
  {2.0327158910742821507517965e-250, 13, "2032715891074", -249},
  {1.5220927534611236131252359e+65, 18, "152209275346112361", 66},
  {1.9632919684588799423679715e+135, 9, "196329197", 136},
  {1.6945727540948809785441258e-195, 21, "169457275409488097854", -194},
  {6.7463150506672213945494382e+303, 7, "6746315", 304},
  {1.3179058619253590160569272e-231, 13, "1317905861925", -230},
  {1.5492940243210275859202048e+26, 9, "154929402", 27},
  {5.7069565083084188764688767e+152, 14, "57069565083084", 153},
  {1.8445181561398673603242535e+82, 11, "18445181561", 83},
  {6.5912731451379924507705255e-01, 4, "6591", 0},
  {6.1068540864354325357305957e-180, 8, "61068541", -179},
  {3.4800919569660098560000000e+18, 4, "348", 19},
  {1.4103846642294953009479680e+24, 16, "1410384664229495", 25},
  {3.0108564558258314526545567e-155, 15, "301085645582583", -154},
  {4.3407068834894196134527690e+159, 3, "434", 160},
  {4.1581968677227930981163320e+77, 2, "42", 78},
  {2.7360396545165404443283921e+29, 11, "27360396545", 30},
  {3.0649499848033117926527738e+181, 7, "306495", 182},
  {3.1223981305304673845609523e+121, 4, "3122", 122},
  {4.0441264851048461179455359e+167, 4, "4044", 168},
  {2.3608519474925507651163951e+122, 4, "2361", 123},
  {9.3043412878577720337074487e+231, 21, "930434128785777203371", 232},
  {6.7687633604633541108112327e+70, 14, "67687633604634", 71},
  {1.0427528297615602070891327e+01, 19, "1042752829761560207", 2},
  {1.6311377844365709318860752e-38, 5, "16311", -37},
  {2.5879959196150152942450614e+36, 10, "258799592", 37},
  {5.7456273972186984077422623e+110, 6, "574563", 111},
  {2.4527362648035947277411395e-25, 7, "2452736", -24},
  {4.1031291508545557730354077e-143, 7, "4103129", -142},
  {4.5121430641128055260082383e+60, 7, "4512143", 61},
  {1.0539391201422199615958764e+191, 7, "1053939", 192},
  {5.9957357121860525768645556e-117, 17, "59957357121860526", -116},
  {2.6461262353106802368164062e+11, 12, "264612623531", 12},
  {2.3437140590713253317317025e+221, 6, "234371", 222},
  {6.8526784254606449271132581e-145, 8, "68526784", -144},
  {4.3118591372447649130687008e-303, 21, "431185913724476491307", -302},
  {8.5361870283266085662930295e+209, 12, "853618702833", 210},
  {2.5846177891115630773079436e-67, 7, "2584618", -66},
  {4.1186970102331555673921418e+160, 2, "41", 161},
  {1.1338732025123509824666759e+119, 3, "113", 120},
  {3.3276499441737651777717619e+118, 6, "332765", 119},
  {5.0853426480064605992604863e-241, 1, "5", -240},
  {2.3530032732924538059891191e-166, 20, "2353003273292453806", -165},
  {9.1686623712913746042673695e-191, 19, "9168662371291374604", -190},
  {1.2712130045910096376350301e+216, 20, "12712130045910096376", 217},
  {2.2750197867615691311594434e-70, 21, "227501978676156913116", -69},
  {4.1184390193950397007633681e-271, 21, "411843901939503970076", -270},
  {1.2869216089022049672403169e+91, 6, "128692", 92},
  {8.6363261869838658759343043e+39, 1, "9", 40},
  {4.5639726252282930871636816e-268, 12, "456397262523", -267},
  {1.6708200346530977500000000e+15, 16, "1670820034653098", 16},
  {1.1169149422737563028931618e+07, 15, "111691494227376", 8},
  {1.0873764771822313129338271e+204, 9, "108737648", 205},
  {8.6137915990569302986816080e+213, 18, "86137915990569303", 214},
  {2.3466362488744812042157890e-211, 6, "234664", -210},
  {2.7572264937611046288479132e+37, 18, "275722649376110463", 38},
  {4.9050383804512175082611455e-133, 13, "4905038380451", -132},
  {2.3233793486702011535412775e-262, 12, "232337934867", -261},
  {1.6460900762412060227704375e-287, 19, "1646090076241206023", -286},
  {1.9344638783966993692782562e-162, 4, "1934", -161},
  {3.5936566661766302127887425e+181, 6, "359366", 182},
  {1.0274087015598136468435036e+136, 19, "1027408701559813647", 137},
  {4.9097270489631889447109296e-207, 5, "49097", -206},
  {6.6252058255778677399025280e-162, 20, "66252058255778677399", -161},
  {5.1885680157583759056538552e-220, 19, "5188568015758375906", -219},
  {1.5176847105288120475139493e-145, 9, "151768471", -144},
  {5.9753255280360217511770315e+03, 10, "5975325528", 4},
  {2.9159114323864326993950559e-124, 21, "29159114323864326994", -123},
  {1.8077844089514237892917456e+123, 1, "2", 124},
  {1.1924094944732911006023434e+175, 7, "1192409", 176},
  {9.5129421005303223868141407e-92, 20, "95129421005303223868", -91},
  {1.2056989585758001428277128e-189, 16, "12056989585758", -188},
  {8.4237193297258402669619870e-243, 19, "8423719329725840267", -242},
  {1.1995321090766366264148707e-89, 10, "1199532109", -88},
  {7.0227676112630225146152697e-39, 8, "70227676", -38},
  {9.2276310735250026036564255e-129, 13, "9227631073525", -128},
  {4.9459585967204398958971357e-181, 2, "49", -180},
  {1.9062300146014901333337649e-216, 11, "19062300146", -215},
  {2.0115255031513081549187863e-110, 5, "20115", -109},
  {1.7823486713874642339673915e+155, 14, "17823486713875", 156},
  {2.2762808617454964764899008e-296, 20, "22762808617454964765", -295},
  {4.0810921980738489817811943e-168, 14, "40810921980738", -167},
  {8.5651796718297517105197132e+298, 8, "85651797", 299},
  {4.3975087983741613146938002e-180, 18, "439750879837416131", -179},
  {4.7074223523692938225880735e-230, 12, "470742235237", -229},
  {7.4585497109904380881116150e-178, 6, "745855", -177},
  {4.7800585342725953276048153e+29, 11, "47800585343", 30},
  {2.5364113263620843814330972e-158, 11, "25364113264", -157},
  {8.6169656297776951686950744e+32, 14, "86169656297777", 33},
  {1.0213220672089248367321042e+217, 6, "102132", 218},
  {9.1626353335378362025581146e+241, 7, "9162635", 242},
  {6.7016716301455836598904719e+152, 6, "670167", 153},
  {4.7979192009190601731192549e-240, 11, "47979192009", -239},
  {6.3477632758006732688895380e+244, 7, "6347763", 245},
  {4.1464440749519490471997907e-263, 11, "4146444075", -262},
  {5.6642528695147196433345953e+264, 3, "566", 265},
  {3.8566615562731732206471284e-88, 1, "4", -87},
  {1.2544800092147258981441520e+36, 21, "125448000921472589814", 37},
  {5.6588755530455849065512960e+24, 19, "5658875553045584907", 25},
  {8.4844930530417982382113380e+276, 2, "85", 277},
  {4.6901722441477933462852288e-29, 21, "469017224414779334629", -28},
  {1.1030154100028785341977542e-193, 13, "1103015410003", -192},
  {2.2023122473004304426208064e+215, 3, "22", 216},
  {1.5622516377920223886896275e-258, 11, "15622516378", -257},
  {1.0243610003075959339688258e-227, 8, "1024361", -226},
  {9.2802598808243554450932605e+268, 11, "92802598808", 269},
  {3.0515366646286029464120989e+300, 16, "3051536664628603", 301},
  {3.3084424951751200376035361e-222, 13, "3308442495175", -221},
  {2.6471031522421891548487790e+272, 4, "2647", 273},
  {5.9824301402118761215387055e-110, 20, "59824301402118761215", -109},
  {4.0616084215880215167999268e+08, 19, "4061608421588021517", 9},
  {1.9766467650508029182831097e-184, 3, "198", -183},
  {4.4153131663337144834005859e+129, 1, "4", 130},
  {6.7888230219537683231884619e+214, 9, "678882302", 215},
  {1.0987718680869130424691889e+253, 14, "10987718680869", 254},
  {3.5749938651794752647144959e+160, 15, "357499386517948", 161},
  {4.6600920803665379315269794e+223, 9, "466009208", 224},
  {1.3745753302713952001507325e-247, 7, "1374575", -246},
  {9.9355911581893242798997510e-298, 7, "9935591", -297},
  {1.7867311802775709610823231e-226, 11, "17867311803", -225},
  {5.6767787985552086532153856e-270, 12, "567677879856", -269},
  {1.6160392754688206573255877e+251, 18, "161603927546882066", 252},
  {2.0172239254441148403921767e-195, 21, "201722392544411484039", -194},
  {2.3623644831723108112272252e-300, 4, "2362", -299},
  {6.7198904377566014996480000e+21, 3, "672", 22},
  {6.1220008630462117885732322e+287, 4, "6122", 288},
  {3.9140496166790109744686528e-28, 2, "39", -27},
  {8.3248493904847363022061747e+57, 21, "832484939048473630221", 58},
  {4.2002029508822730439460335e+103, 14, "42002029508823", 104},
  {9.7284592856854542436646851e+246, 18, "972845928568545424", 247},
  {5.1454283807470308256071661e+137, 9, "514542838", 138},
  {2.3888432424893859540304675e+00, 21, "238884324248938595403", 1},
  {5.4340624821370370948280600e-263, 12, "543406248214", -262},
  {6.1931543051207857225950834e-279, 17, "61931543051207857", -278},
  {3.3389558181244937475441338e+303, 14, "33389558181245", 304},
  {2.3681381294060455934692464e+268, 17, "23681381294060456", 269},
  {2.3776516637602068194210286e+202, 5, "23777", 203},
  {1.5803643882221657945518052e-105, 14, "15803643882222", -104},
  {2.2030748519029969648145044e-227, 2, "22", -226},
  {9.7928545440472940292864551e+36, 1, "1", 38},
  {4.5038928306286547477180216e-140, 15, "450389283062865", -139},
  {4.2237711693743685036372707e-66, 2, "42", -65},
  {1.3530394610643690180447067e+184, 7, "1353039", 185},
  {1.1508601440301058501862454e+90, 3, "115", 91},
  {3.2207962712413131148363603e-47, 14, "32207962712413", -46},
  {8.3753125585957672924270474e-283, 2, "84", -282},
  {2.0359478709355637572108288e+27, 12, "203594787094", 28},
  {3.4520746289968479818135400e-253, 8, "34520746", -252},
  {6.0633368187620451265710791e-24, 9, "606333682", -23},
  {6.4289055666749416065109199e+279, 18, "642890556667494161", 280},
  {5.1051557210295544518851447e+270, 8, "51051557", 271},
  {1.5277356306774619097828829e+269, 14, "15277356306775", 270},
  {1.8733267822150111536487848e+288, 9, "187332678", 289},
  {2.6478660801604701177160548e+154, 12, "264786608016", 155},
  {2.0523942863985988714349516e-26, 6, "205239", -25},
  {5.5128602282020772880421623e+213, 21, "551286022820207728804", 214},
  {7.4695231057288329073809024e+201, 13, "7469523105729", 202},
  {9.2924810649955048138981486e-101, 17, "92924810649955048", -100},
  {9.4617370215283082904274856e-32, 18, "946173702152830829", -31},
  {3.0890017805206842326044165e-256, 6, "3089", -255},
  {1.5086369416123764433668164e-02, 4, "1509", -1},
  {1.4524988363384481741852292e-20, 16, "1452498836338448", -19},
  {2.8689792756782138144461622e-145, 6, "286898", -144},
  {1.7705208453697664389556504e+170, 7, "1770521", 171},
  {1.5164091430803471389978494e+259, 12, "151640914308", 260},
  {1.2431989747263179366551203e-60, 9, "124319897", -59},
  {1.8780040987561483308157040e+258, 10, "1878004099", 259},
  {1.9327313906552162222080000e+21, 18, "193273139065521622", 22},
  {3.4415108090185450079384495e+242, 3, "344", 243},
  {3.5409189925488114204669659e-50, 15, "354091899254881", -49},
  {2.6016935681570335562837435e+138, 6, "260169", 139},
  {6.4007298213136123855377243e-234, 21, "640072982131361238554", -233},
  {1.5262455283936723009041386e-199, 7, "1526246", -198},
  {7.7650626564929535664788475e-221, 1, "8", -220},
  {1.7869920663501730744801228e+126, 18, "178699206635017307", 127},
  {1.8392138228960698688140661e+260, 20, "18392138228960698688", 261},
  {7.2212891828406341717223164e+272, 19, "7221289182840634172", 273},
  {6.4137109035540464802595300e+220, 12, "641371090355", 221},
  {1.5994345898771799258312073e+125, 3, "16", 126},
  {3.2547326027758275533955575e+245, 2, "33", 246},
  {1.4954420329070389777531061e+107, 2, "15", 108},
  {2.1791420733965720515012829e-193, 13, "2179142073397", -192},
  {9.9070814385830829320413500e-176, 13, "9907081438583", -175},
  {6.7504867723550339018812578e-161, 16, "6750486772355034", -160},
  {5.1641132147123883783764225e-223, 6, "516411", -222},
  {1.2177616058517764652952268e+101, 16, "1217761605851776", 102},
  {9.1780212861622732210070461e-253, 19, "9178021286162273221", -252},
  {1.6667121991689465692983801e+120, 1, "2", 121},
  {2.5340008898841201301917373e-13, 7, "2534001", -12},
  {3.3755218874741970204281195e-156, 12, "337552188747", -155},
  {7.4068705595162033076506251e-172, 8, "74068706", -171},
  {6.4411442016496518535270710e+75, 12, "644114420165", 76},
  {2.5635748794969043156952954e-75, 16, "2563574879496904", -74},
  {7.7788460823459558601029427e+205, 19, "777884608234595586", 206},
  {2.2313280146654751417644581e-186, 5, "22313", -185},
  {4.1953610713567664865229153e-146, 11, "41953610714", -145},
  {1.2293633792798563708105806e+104, 21, "122936337927985637081", 105},
  {9.3983989977523007992399715e-113, 10, "9398398998", -112},
  {6.1641134391086701433082401e+86, 10, "6164113439", 87},
  {1.9401618282399547817482064e+52, 2, "19", 53},
  {8.0705917726472819678921602e-147, 18, "807059177264728197", -146},
  {9.2773289007074310191181000e+61, 18, "927732890070743102", 62},
  {4.9476550099763754277161552e-34, 12, "494765500998", -33},
  {1.1291971299640865947492641e-128, 8, "11291971", -127},
  {1.9610880639323034856223393e+123, 13, "1961088063932", 124},
  {1.5832479900413354039704551e+28, 20, "1583247990041335404", 29},
  {5.6332940239409253996732552e-244, 8, "5633294", -243},
  {5.9455416332962994985962865e-34, 13, "5945541633296", -33},
  {3.4884750043711884721274063e-133, 13, "3488475004371", -132},
  {2.4921961472337575375378056e+258, 8, "24921961", 259},
  {4.3423590037302333093248834e+38, 17, "43423590037302333", 39},
  {8.9601524021340001189200913e+111, 12, "896015240213", 112},
  {9.5847539482260911114207552e-232, 17, "95847539482260911", -231},
  {4.9288783510692324775887977e+281, 3, "493", 282},
  {4.2867869327422243766314624e-187, 6, "428679", -186},
  {3.3726105039258635617064911e+277, 3, "337", 278},
  {2.5633037761967303029148234e-164, 9, "256330378", -163},
  {7.8667063143280731871382109e+172, 18, "786670631432807319", 173},
  {4.2803797768829923468828887e-272, 5, "42804", -271},
  {2.2957001253014966212621233e-52, 11, "22957001253", -51},
  {1.6849382846251818875919396e-59, 5, "16849", -58},
  {1.4190720102548379938652491e+175, 16, "1419072010254838", 176},
  {1.6961594415455345335559688e+224, 21, "169615944154553453356", 225},
  {2.5861172900991371548750600e-68, 15, "258611729009914", -67},
  {5.7922951076447234929301627e-218, 3, "579", -217},
  {8.2612551895085552500432495e+156, 12, "826125518951", 157},
  {7.5891004454676904099633545e-208, 1, "8", -207},
  {8.5500113161595957689459312e+47, 7, "8550011", 48},
  {1.8107055369819981749723752e-135, 13, "1810705536982", -134},
  {6.3179762062212608590537514e-53, 15, "631797620622126", -52},
  {6.3943748750117433217559171e+218, 7, "6394375", 219},
  {1.0503066969656857168812959e+164, 14, "10503066969657", 165},
  {4.4400460467476504064048455e+30, 15, "444004604674765", 31},
  {5.9739054683947042840626590e-157, 19, "5973905468394704284", -156},
  {1.0093604034165507741790822e-22, 7, "100936", -21},
  {8.0648530603955633945863865e+142, 14, "80648530603956", 143},
  {1.4482557657385115750767298e+273, 1, "1", 274},
  {1.5430190558278693912704300e+217, 4, "1543", 218},
  {1.1152274683749809729224605e+104, 9, "111522747", 105},
  {1.3664765399822050814772791e-115, 10, "136647654", -114},
  {9.7266274842109283933698732e-08, 21, "972662748421092839337", -7},
  {9.2784954798188581557204480e-46, 21, "927849547981885815572", -45},
  {2.9429883728399410542733267e-177, 15, "294298837283994", -176},
  {2.2938531657588339753486923e-57, 17, "2293853165758834", -56},
  {4.1507025370773750206162482e+185, 10, "4150702537", 186},
  {7.5557233347796777257066846e-68, 15, "755572333477968", -67},
  {1.6355267052390404474573986e-192, 9, "163552671", -191},
  {1.8287822477134240971310717e-124, 15, "182878224771342", -123},
  {1.9991163444047501229761110e+02, 8, "19991163", 3},
  {1.6823126889941398913586095e-262, 9, "168231269", -261},
  {2.5557566838161739906756393e+198, 12, "255575668382", 199},
  {6.9564698633054764902953279e-47, 16, "6956469863305476", -46},
  {6.4335733128648246573646966e+44, 20, "64335733128648246574", 45},
  {6.2008055755382277356973694e+145, 2, "62", 146},
  {3.2608963737203820324712990e+213, 15, "326089637372038", 214},
  {7.9766724260407968998705261e-123, 20, "79766724260407968999", -122},
  {5.0622790447785875083469330e+136, 12, "506227904478", 137},
  {2.7600912924605035012655483e+83, 1, "3", 84},
  {1.6472458957737116741082490e-87, 7, "1647246", -86},
  {1.4717134966447189896456270e+210, 7, "1471713", 211},
  {3.1736284279636643472412488e-264, 13, "3173628427964", -263},
  {1.3364825255431587759805338e+174, 3, "134", 175},
  {1.2849801017298873919631603e+91, 13, "128498010173", 92},
  {1.5005518696272707583141536e-165, 13, "1500551869627", -164},
  {1.3295501678241675945108641e+248, 5, "13296", 249},
  {4.6683000013921761636104383e-168, 14, "46683000013922", -167},
  {8.2491877178015823099891956e-18, 4, "8249", -17},
  {1.3761025496815665791643825e+220, 4, "1376", 221},
  {3.7722317400831631669127033e+210, 4, "3772", 211},
  {1.4333705406517632387189346e+137, 21, "143337054065176323872", 138},
  {1.5667873863632146192051996e+119, 8, "15667874", 120},
  {1.3251557209649583435058594e+11, 20, "13251557209649583435", 12},
  {3.9571216919650829856695514e-148, 6, "395712", -147},
  {1.3792114952763168733368005e+267, 19, "1379211495276316873", 268},
  {4.7288914554650106312559428e+28, 19, "4728891455465010631", 29},
  {4.7000776240625643626267558e+198, 8, "47000776", 199},
  {1.9110685695851437872219114e-231, 7, "1911069", -230},
  {1.1754135626478007437883809e+68, 15, "11754135626478", 69},
  {8.5177430199562798543910386e+220, 18, "851774301995627985", 221},
  {3.3746228643353058915587933e-148, 15, "337462286433531", -147},
  {2.3772794425859566746902632e+243, 14, "2377279442586", 244},
  {1.0260228106211978621757256e-210, 20, "10260228106211978622", -209},
  {1.3921339779331633497880347e-238, 10, "1392133978", -237},
  {1.5783613269988382500000000e+15, 16, "1578361326998838", 16},
  {3.4629740488214011563771320e-84, 20, "34629740488214011564", -83},
  {1.8183009334904841043261061e+125, 5, "18183", 126},
  {4.0927225959373804491525741e+56, 18, "409272259593738045", 57},
  {6.3952923069208324100196588e+95, 4, "6395", 96},
  {6.7822700981752393901653707e-141, 2, "68", -140},
  {7.2500288524014396624827747e-224, 17, "72500288524014397", -223},
  {6.6010364489639649259948287e+266, 3, "66", 267},
  {1.1811089804337054030955439e-55, 5, "11811", -54},
  {8.4766858741400284712432445e+248, 14, "847668587414", 249},
  {1.5260851017413280712418728e+209, 10, "1526085102", 210},
  {3.4490030676380748911232054e-118, 19, "3449003067638074891", -117},
  {4.8302645235100909511843333e-163, 2, "48", -162},
  {4.3683233118564915863339915e-291, 1, "4", -290},
  {2.0572322808752095365496211e-220, 20, "20572322808752095365", -219},
  {2.6387067514544019249158591e+253, 10, "2638706751", 254},
  {4.5129289425719208276221523e-41, 10, "4512928943", -40},
  {1.3985727726154529543133739e+48, 12, "139857277262", 49},
  {1.7000427520168719628433048e-304, 12, "170004275202", -303},
  {1.7172825957120953348563461e-67, 1, "2", -66},
  {3.4735042720284228018120045e+249, 2, "35", 250},
  {2.6397563428521464109748865e-86, 3, "264", -85},
  {9.5789547978684104267243629e+104, 2, "96", 105},
  {2.2084906051678929741963956e+285, 7, "2208491", 286},
  {7.1288051728990552353887156e-109, 17, "71288051728990552", -108},
  {4.9043624304317245200843973e-286, 2, "49", -285},
  {2.7635124234615400594911655e+288, 9, "276351242", 289},
  {3.4756805792974406867302079e-31, 2, "35", -30},
  {6.7494999540965833629367550e+237, 21, "674949995409658336294", 238},
  {7.3998111663157084428069117e-150, 15, "739981116631571", -149},
  {4.7702848691650617263853666e+225, 19, "4770284869165061726", 226},
  {2.0572580688437668072765518e+01, 3, "206", 2},
  {3.8508476492169380828664920e+233, 1, "4", 234},
  {2.7287771029490814131332171e-303, 9, "27287771", -302},
  {2.1523224171045124075755959e-301, 18, "215232241710451241", -300},
  {6.0129622088389750189416734e-157, 5, "6013", -156},
  {1.4013929243847589451503471e+90, 6, "140139", 91},
  {6.3525620335956470966639909e+200, 9, "635256203", 201},
  {4.8665028838411308825016022e+07, 14, "48665028838411", 8},
  {8.1500313124911747565867355e-300, 8, "81500313", -299},
  {3.1979681357622221643998998e-125, 19, "3197968135762222164", -124},
  {1.9295627487683248858728441e-283, 1, "2", -282},
  {4.4503338097618014710678576e+58, 4, "445", 59},
  {1.9595729069753542246400000e+20, 9, "195957291", 21},
  {3.7334794870339859645617403e+89, 17, "3733479487033986", 90},
  {9.3018738783301252462120951e-145, 20, "93018738783301252462", -144},
  {8.7482674305609990957267272e-246, 4, "8748", -245},
  {6.2590090808307708849654019e+273, 12, "625900908083", 274},
  {1.1190740640740501023098266e+235, 3, "112", 236},
  {4.1713590369433444348988307e-69, 2, "42", -68},
  {6.5767440345452007350423907e+266, 15, "65767440345452", 267},
  {5.0452368748489434483496122e+59, 5, "50452", 60},
  {5.5028035109702910634145681e+138, 13, "550280351097", 139},
  {1.7469496095969588303517327e-297, 9, "174694961", -296},
  {8.1213674939585378531603510e-01, 20, "81213674939585378532", 0},
  {8.0299897773343197313800583e+247, 15, "802998977733432", 248},
  {1.6015739160598711164975807e-273, 11, "16015739161", -272},
  {2.2256211757916543250246157e-296, 11, "22256211758", -295},
  {3.2058482905710809987788599e-39, 5, "32058", -38},
  {3.2344968075555137443091939e+278, 14, "32344968075555", 279},
  {5.5932382095606203663962171e+160, 3, "559", 161},
  {2.1132607078075749314892540e+109, 21, "211326070780757493149", 110},
  {7.1039882992637491778371220e+158, 6, "710399", 159},
  {7.9518976118199725224213705e+42, 9, "795189761", 43},
  {6.4459252047455364818975982e+97, 7, "6445925", 98},
  {8.4278662316590965815977234e+229, 17, "84278662316590966", 230},
  {2.0267454434998583984375000e+11, 7, "2026745", 12},
  {7.6696683814677364330442259e-154, 2, "77", -153},
  {8.8004536123080659282140198e-244, 4, "88", -243},
  {9.4904680763904794698898227e-57, 16, "9490468076390479", -56},
  {1.2589400110874492192204360e+88, 13, "1258940011087", 89},
  {1.4071908777743152863897536e+119, 5, "14072", 120},
  {1.3218747192183380275861090e+284, 9, "132187472", 285},
  {2.1944317431902785139490487e-208, 10, "2194431743", -207},
  {6.1091947082084057947411033e+282, 18, "610919470820840579", 283},
  {6.2718807489291442939305698e-92, 15, "627188074892914", -91},
  {3.9079616170408944794339739e-122, 19, "3907961617040894479", -121},
  {4.9081264131054699420928955e+07, 12, "490812641311", 8},
  {2.1432933805469564526812677e-182, 4, "2143", -181},
  {3.0682778600048121630660999e-117, 2, "31", -116},
  {4.7921440104115910340014895e-254, 13, "4792144010412", -253},
  {4.1789194902423514042127332e+52, 16, "4178919490242351", 53},
  {8.5382057081424742847292387e+136, 19, "8538205708142474285", 137},
  {3.0896266417243481488396393e-22, 11, "30896266417", -21},
  {9.2524136288180974222141620e-58, 12, "925241362882", -57},
  {3.1704673127543065480799374e+35, 17, "31704673127543065", 36},
  {2.8566606264659486673858776e+40, 1, "3", 41},
  {1.5784555208238226084860696e+77, 1, "2", 78},
  {1.3114678520916125859172284e+193, 13, "1311467852092", 194},
  {9.7143355502052367914754861e+150, 7, "9714336", 151},
  {7.5191731770760577350120753e-32, 12, "751917317708", -31},
  {6.6182974925257460035985177e+181, 20, "66182974925257460036", 182},
  {1.4089406572968532767753835e+270, 1, "1", 271},
  {1.1574403494054681384994865e+00, 3, "116", 1},
  {3.3483114324724639623441037e-143, 12, "334831143247", -142},
  {1.4149623824151193374488870e+280, 5, "1415", 281},
  {8.7272743300304750954314806e-125, 16, "8727274330030475", -124},
  {1.5897120147421219761377732e+92, 17, "1589712014742122", 93},
  {1.5106862906950529876588824e-270, 21, "151068629069505298766", -269},
  {5.3196864681749788306139008e+111, 6, "531969", 112},
  {2.1177123403752025230566953e-34, 5, "21177", -33},
  {1.8294738293978013432550256e-02, 20, "18294738293978013433", -1},
  {3.3227424527027879110909025e-280, 5, "33227", -279},
  {1.3780717443169501698069425e+42, 15, "137807174431695", 43},
  {1.8690627871837867700212334e+102, 11, "18690627872", 103},
  {2.4332491889536812799088065e-204, 14, "24332491889537", -203},
  {4.2150053930623102404209463e+307, 18, "421500539306231024", 308},
  {1.3048873935843849358739988e-03, 8, "13048874", -2},
  {1.7949316512922823838377198e-220, 9, "179493165", -219},
  {1.1321700315289681155894850e-90, 9, "113217003", -89},
  {2.2304232482368622240541809e+255, 9, "223042325", 256},
  {8.5088706532609185708379920e+284, 3, "851", 285},
  {4.6876870585965597475189536e-263, 13, "4687687058597", -262},
  {1.0254626990832447919940613e+54, 5, "10255", 55},
  {4.3618197727834339024890004e+306, 9, "436181977", 307},
  {1.3507822010685297731992378e-182, 5, "13508", -181},
  {3.3674519221759124798099022e-66, 6, "336745", -65},
  {3.4019273196318739842353410e-186, 10, "340192732", -185},
  {2.1600154455022387397807901e+228, 21, "216001544550223873978", 229},
  {5.5367346280160031001483354e+168, 21, "553673462801600310015", 169},
  {1.4485705411206803639833970e-18, 6, "144857", -17},
  {6.7824341327728771111159405e+286, 2, "68", 287},
  {2.2744178169870705447655383e-281, 2, "23", -280},
  {1.3416346264827010961098144e+285, 3, "134", 286},
  {3.0813485569450987356311430e+52, 9, "308134856", 53},
  {3.3518502744008702449285032e-55, 10, "3351850274", -54},
  {1.4431061466047866054770777e+58, 10, "1443106147", 59},
  {3.2036790601164137284064504e-101, 9, "320367906", -100},
  {4.6629440168343750976014288e+224, 3, "466", 225},
  {2.6524149543138304061297657e+256, 2, "27", 257},
  {4.0779036497791676310723558e-281, 18, "407790364977916763", -280},
  {1.7235522244459356434049011e-166, 17, "17235522244459356", -165},
  {4.8602632291118434237239113e-151, 6, "486026", -150},
  {1.5158460384732907265101409e-208, 12, "151584603847", -207},
  {2.0559734679617294800096569e+34, 7, "2055973", 35},
  {6.3607135929496160257561010e-168, 20, "63607135929496160258", -167},
  {1.7309497189281251492326944e+160, 19, "1730949718928125149", 161},
  {3.0207024455768779914989887e-286, 10, "3020702446", -285},
  {1.8363068801946472975781976e+188, 10, "183630688", 189},
  {5.1242496428238967309116375e+27, 3, "512", 28},
  {4.3404729140265169870014748e+139, 13, "4340472914027", 140},
  {6.3236576402437203364941863e-67, 8, "63236576", -66},
  {6.4206166472580599944921912e+128, 2, "64", 129},
  {8.2597037613242677371897915e+103, 20, "82597037613242677372", 104},
  {4.0840847168085187719507960e+104, 21, "408408471680851877195", 105},
  {5.0460155598338604178591552e-76, 2, "5", -75},
  {4.0148518242653942959120159e+143, 8, "40148518", 144},
  {2.9859466577626457606089788e-217, 15, "298594665776265", -216},
  {8.5746349776143810147345160e-109, 15, "857463497761438", -108},
  {7.0522142297796932586360398e+106, 6, "705221", 107},
  {7.3388709504594596095319510e-179, 18, "733887095045945961", -178},
  {2.9543614306373152645662795e+46, 9, "295436143", 47},
  {3.5668404689245094038161535e-121, 19, "3566840468924509404", -120},
  {3.5921231840190176159272015e+265, 11, "3592123184", 266},
  {6.0747606764057020857244496e-196, 16, "6074760676405702", -195},
  {1.0375266323885662841154356e+80, 20, "10375266323885662841", 81},
  {1.7532639259568422330040320e+26, 11, "1753263926", 27},
  {3.1641407820394786824185466e+255, 21, "316414078203947868242", 256},
  {5.2009643122859889781941934e-12, 15, "520096431228599", -11},
  {6.9648211734325971733328519e-69, 14, "69648211734326", -68},
  {1.3474937574908855073610257e-50, 6, "134749", -49},
  {3.8122472630171423430230890e+208, 20, "3812247263017142343", 209},
  {2.4593999223581052019671040e+24, 19, "2459399922358105202", 25},
  {1.4098376120805222019398834e+109, 1, "1", 110},
  {2.6073861039150108757202234e+197, 3, "261", 198},
  {9.8648147828604976801643020e-219, 20, "98648147828604976802", -218},
  {5.4639842599168120428767478e-216, 11, "54639842599", -215},
  {7.1033582507604416884027694e+45, 19, "7103358250760441688", 46},
  {3.2230632865482665778533470e+254, 10, "3223063287", 255},
  {9.8342282025954648394109960e+48, 9, "98342282", 49},
  {6.6607412845245771836410995e-46, 21, "666074128452457718364", -45},
  {5.6127239231682177004098550e+284, 3, "561", 285},
  {2.1122484650053734850441299e+41, 20, "2112248465005373485", 42},
  {5.3450711422481707754513398e+241, 20, "53450711422481707755", 242},
  {4.1482702427062922923450283e+273, 18, "414827024270629229", 274},
  {3.9128173182313248907504930e+137, 12, "391281731823", 138},
  {6.9557392431298682759685649e-232, 5, "69557", -231},
  {9.8587382541720718027776682e+123, 12, "985873825417", 124},
  {2.0551963999899675516502614e-88, 20, "20551963999899675517", -87},
  {7.8231988033032734707700214e-223, 4, "7823", -222},
  {3.0611031484952442814248961e+163, 16, "3061103148495244", 164},
  {1.2292579636876058278416081e-289, 9, "122925796", -288},
  {3.7296914644512791161943133e-141, 11, "37296914645", -140},
  {4.9499218415403399358314533e-34, 17, "49499218415403399", -33},
  {2.3980547262643934489521250e+125, 11, "23980547263", 126},
  {4.5213618674680870557216177e-16, 13, "4521361867468", -15},
  {1.8895098841050308914057904e-281, 9, "188950988", -280},
  {3.3805440608737006588019009e+268, 15, "33805440608737", 269},
  {3.4813010761526156553681551e+224, 17, "34813010761526157", 225},
  {1.2296923202332236026331898e-260, 3, "123", -259},
  {8.4083313561711119947597613e+139, 8, "84083314", 140},
  {1.6426415479538597367983588e+238, 8, "16426415", 239},
  {2.5426593356191163343865972e-58, 9, "254265934", -57},
  {2.5901875427147983249693415e+293, 14, "25901875427148", 294},
  {4.4373085306597519012621406e+154, 20, "44373085306597519013", 155},
  {4.3581419180659884800000000e+17, 17, "43581419180659885", 18},
  {4.3906441329513739776446104e+105, 4, "4391", 106},
  {3.7468218861048871195335229e-34, 18, "374682188610488712", -33},
  {3.2875739443697626190564201e+249, 15, "328757394436976", 250},
  {8.0380638021049893406849759e+301, 5, "80381", 302},
  {7.9302120859684946035763931e+31, 5, "79302", 32},
  {2.5022054662423662841320038e+07, 4, "2502", 8},
  {7.1367419536043841840742400e+23, 18, "713674195360438418", 24},
  {8.3269858035420172829606474e+213, 5, "8327", 214},
  {5.2782608256674209450158330e-67, 3, "528", -66},
  {3.0746364540586097272974390e+63, 7, "3074636", 64},
  {1.0872042099622658007093402e+70, 19, "1087204209962265801", 71},
  {9.1219801577565827384351761e+57, 3, "912", 58},
  {3.2318162475414177964641582e-04, 1, "3", -3},
  {5.6601957087396540000000000e+15, 10, "5660195709", 16},
  {2.1087082512766626966729608e-95, 17, "21087082512766627", -94},
  {6.4241005779656428627820726e-281, 1, "6", -280},
  {2.1968349813855033580068051e+128, 3, "22", 129},
  {6.7335076600749715449224069e-42, 19, "6733507660074971545", -41},
  {3.0416339535518857274602918e-58, 4, "3042", -57},
  {2.2263018975681220882772486e+149, 18, "222630189756812209", 150},
  {2.2104478409701458194063202e-294, 16, "2210447840970146", -293},
  {4.0661934570853703181412712e+82, 14, "40661934570854", 83},
  {8.6356786687660212046600838e+41, 18, "86356786687660212", 42},
  {1.8319505645008458780828497e+300, 3, "183", 301},
  {2.1881354423810158637411084e+164, 19, "2188135442381015864", 165},
  {1.3862058703314876589448102e+28, 16, "1386205870331488", 29},
  {3.2743507476944919993071734e+68, 20, "32743507476944919993", 69},
  {3.2645070333705468730812006e-191, 7, "3264507", -190},
  {2.9925619072217314755822323e+301, 18, "299256190722173148", 302},
  {1.7902652409235204205913766e-84, 5, "17903", -83},
  {2.6741220927815225376589736e-217, 4, "2674", -216},
  {1.6549517034181629898312271e-64, 1, "2", -63},
  {5.4032620722518073477733091e-65, 2, "54", -64},
  {9.2452395025578774990028301e-109, 6, "924524", -108},
  {1.1504479539614660693217101e+152, 3, "115", 153},
  {6.1072782030965463559127658e-309, 19, "6107278203096546356", -308},
  {1.7406845164626038831262464e+76, 2, "17", 77},
  {2.7993002666169029825024883e-108, 18, "279930026661690298", -107},
  {6.6295012973361366776957327e+176, 1, "7", 177},
  {3.1178681437860936412912094e-44, 2, "31", -43},
  {3.5538536222711717756753117e+243, 21, "355385362227117177568", 244},
  {1.2110246706370283565987260e+144, 5, "1211", 145},
  {5.1880721395794544640000000e+18, 11, "51880721396", 19},
  {9.7778107918854564598759261e-72, 19, "977781079188545646", -71},
  {7.3803280676529608528935788e-256, 16, "7380328067652961", -255},
  {5.1343200981751043682627569e-234, 9, "51343201", -233},
  {2.0588768134491990984499123e-239, 2, "21", -238},
  {3.2176462652164257349395561e-46, 21, "321764626521642573494", -45},
  {1.2673031490546943887534076e+84, 14, "12673031490547", 85},
  {2.2141839517965752746587564e-266, 20, "22141839517965752747", -265},
  {6.3492394180514180216535195e-37, 17, "6349239418051418", -36},
  {1.7411654939473408044223458e+251, 11, "17411654939", 252},
  {7.5401509330465321500437656e+177, 9, "754015093", 178},
  {9.0061764041219574963985505e-179, 21, "90061764041219574964", -178},
  {1.3137243109803577321602125e+188, 2, "13", 189},
  {1.5092974597942920264656480e+239, 8, "15092975", 240},
  {5.1524773452281182644871900e+199, 4, "5152", 200},
  {3.1685299205923770868629800e+206, 19, "3168529920592377087", 207},
  {1.1836122659190944280178425e+67, 20, "1183612265919094428", 68},
  {7.7769423672818377253480743e-33, 21, "777694236728183772535", -32},
  {6.5226500377308175680758453e-53, 2, "65", -52},
  {3.7195716113533345252453132e-249, 20, "37195716113533345252", -248},
  {4.1052053373548157277504908e+129, 4, "4105", 130},
  {3.9324211015743114781205998e+62, 12, "393242110157", 63},
  {1.6544763610103290606663492e-101, 11, "1654476361", -100},
  {1.8102389157589703881881939e+52, 16, "181023891575897", 53},
  {3.6237599290067145331513665e-37, 15, "362375992900671", -36},
  {4.0886111272038357733516381e-162, 8, "40886111", -161},
  {1.3305400292692207202482252e-38, 16, "1330540029269221", -37},
  {3.3728458022262253916988771e+285, 4, "3373", 286},
  {2.5367050804671195105323567e-105, 17, "25367050804671195", -104},
  {2.4766722260120389958488933e+219, 21, "247667222601203899585", 220},
  {4.4716714895944842354009473e+216, 21, "44716714895944842354", 217},
  {2.8740742846348867243984575e-85, 4, "2874", -84},
  {1.8778238793503168738066313e+145, 12, "187782387935", 146},
  {2.9320487726112470007671428e+137, 16, "2932048772611247", 138},
  {1.8519131531598832680687112e+248, 11, "18519131532", 249},
  {1.0474399563567617498297658e+288, 19, "104743995635676175", 289},
  {4.1910869650348574813063514e-299, 20, "41910869650348574813", -298},
  {2.7404851211304777146879448e-200, 19, "2740485121130477715", -199},
  {1.7433865735010057662971434e+250, 13, "1743386573501", 251},
  {5.9145802853869880730748971e+280, 8, "59145803", 281},
  {2.0912346500404171380506153e-46, 12, "209123465004", -45},
  {3.6291256829698680485862508e-69, 19, "3629125682969868049", -68},
  {1.8065497593951179266199518e+55, 15, "180654975939512", 56},
  {6.0460973440787347849551525e-31, 17, "60460973440787348", -30},
  {4.5135171178577191580648502e+103, 14, "45135171178577", 104},
  {1.2913772618701250365995825e+156, 8, "12913773", 157},
  {1.3061639632787002929164524e-229, 11, "13061639633", -228},
  {6.8702485875873557092336213e-186, 5, "68702", -185},
  {1.5486508542879629263939455e-146, 14, "1548650854288", -145},
  {2.1664045965096187047037275e-17, 6, "21664", -16},
  {3.8689978413242258400454595e+249, 17, "38689978413242258", 250},
  {6.1192212177541171818638079e-233, 11, "61192212178", -232},
  {1.2084733866890417338312831e+187, 18, "120847338668904173", 188},
  {3.4828920944626914468038686e-301, 20, "34828920944626914468", -300},
  {1.2379652019559603956538477e-185, 10, "1237965202", -184},
  {1.7823221252894821757441383e-306, 10, "1782322125", -305},
  {2.2121031994884105081338620e+210, 12, "221210319949", 211},
  {9.0282831362950458581018986e-167, 10, "9028283136", -166},
  {8.0124716263965615322879031e-110, 20, "80124716263965615323", -109},
  {6.6692015578835599041654994e+291, 16, "666920155788356", 292},
  {1.7050743724145913376514569e-91, 19, "1705074372414591338", -90},
  {7.3109769214185243374749019e+37, 1, "7", 38},
  {5.6618823436301925218686322e+107, 2, "57", 108},
  {1.9415258700586894389975428e-184, 2, "19", -183},
  {1.4465404005194516886704583e-185, 19, "1446540400519451689", -184},
  {2.8367961849898959807846030e-155, 10, "2836796185", -154},
  {6.4681163803942852332830803e+214, 9, "646811638", 215},
  {2.1178523204158192065872232e-153, 17, "21178523204158192", -152},
  {1.5261256012330633220423975e-243, 14, "15261256012331", -242},
  {3.7798539946474576000000000e+16, 5, "37799", 17},
  {6.7810839715677215002060869e-279, 7, "6781084", -278},
  {1.1353688919010886511147490e-123, 8, "11353689", -122},
  {3.3931736648309938617897200e+276, 14, "3393173664831", 277},
  {1.1860314308747634405120673e+246, 16, "1186031430874763", 247},
  {1.5696683245108891942119216e-96, 1, "2", -95},
  {2.3702410325001367149043558e-222, 1, "2", -221},
  {3.0920288033504803497897565e-167, 17, "30920288033504803", -166},
  {3.3792227271547422749653317e+175, 10, "3379222727", 176},
  {3.6196876571836539256091838e-137, 16, "3619687657183654", -136},
  {7.7181073526104249725681217e+306, 7, "7718107", 307},
  {4.4773801246274343667078656e-29, 17, "44773801246274344", -28},
  {1.8067958269135178969805477e-111, 8, "18067958", -110},
  {4.3083960794995117187500000e+10, 16, "4308396079499512", 11},
  {2.9262278423794260089353372e+106, 16, "2926227842379426", 107},
  {4.8888219937264967244231579e-146, 15, "48888219937265", -145},
  {3.3769819525218348856163695e+71, 14, "33769819525218", 72},
  {2.7130557579126704556222700e-24, 6, "271306", -23},
  {4.7216491612877190919031305e+37, 11, "47216491613", 38},
  {4.2693030601669742082486385e+51, 1, "4", 52},
  {1.3400707604958020037755264e+207, 21, "134007076049580200378", 208},
  {7.1907159627546067869018474e-94, 3, "719", -93},
  {6.1377947482632963778962087e+298, 12, "613779474826", 299},
  {9.6982534125237104353003472e+129, 15, "969825341252371", 130},
  {9.4437010274033854242150211e+230, 1, "9", 231},
  {4.5922877324342273381038533e+61, 5, "45923", 62},
  {7.1163258202210460845237809e-302, 20, "71163258202210460845", -301},
  {4.5746604727034589911670992e+274, 20, "45746604727034589912", 275},
  {1.5017686159903222440443428e-207, 9, "150176862", -206},
  {1.3664852721311552041251531e-163, 7, "1366485", -162},
  {3.8664653429246695211206377e-146, 16, "386646534292467", -145},
  {4.2076532203302557194832664e+254, 15, "420765322033026", 255},
  {5.5485620998371041742794609e+298, 20, "55485620998371041743", 299},
  {1.6268390849557054236132966e-102, 13, "1626839084956", -101},
  {6.5616873481868644496105212e-231, 5, "65617", -230},
  {3.0182180442687749246333503e-65, 10, "3018218044", -64},
  {2.2371049313219486204767745e-38, 3, "224", -37},
  {9.5987793250117958485204088e-45, 18, "959877932501179585", -44},
  {1.6511256255722482811020708e+131, 8, "16511256", 132},
  {2.0670740514226685667688549e-34, 2, "21", -33},
  {1.7813020321115928805382919e+167, 10, "1781302032", 168},
  {1.1752768799405215302085105e-299, 5, "11753", -298},
  {1.8208706870283835402852576e-29, 2, "18", -28},
  {3.7285132405819903422588436e-270, 11, "37285132406", -269},
  {2.7491970831081281791998856e-27, 7, "2749197", -26},
  {3.3878664715996690468146184e-87, 9, "338786647", -86},
  {3.6385094586923145121694638e+72, 3, "364", 73},
  {6.6945350911617169668831342e-78, 16, "6694535091161717", -77},
  {1.0376279746415572943130581e-242, 14, "10376279746416", -241},
  {3.1702745646324904000000000e+16, 21, "31702745646324904", 17},
  {1.6981329338775683334005598e+78, 6, "169813", 79},
  {1.9485523692227332759338466e-72, 21, "194855236922273327593", -71},
  {2.2979590805970846023118776e-13, 12, "22979590806", -12},
  {5.6753772309137551762496905e+249, 16, "5675377230913755", 250},
  {4.5388022135151005248079931e-57, 12, "453880221352", -56},
  {4.3555504163436435802721374e+112, 5, "43556", 113},
  {2.4890871658913111717535792e-135, 16, "2489087165891311", -134},
  {3.2512408688310577270937799e-12, 8, "32512409", -11},
  {2.8833540975141352148827290e-104, 5, "28834", -103},
  {2.9541313785721273993437115e+105, 9, "295413138", 106},
  {5.1088493196564293541896964e-299, 18, "510884931965642935", -298},
  {2.0536403471664999015242950e+29, 15, "20536403471665", 30},
  {3.4764625491912686293757738e+216, 12, "347646254919", 217},
  {1.0554240172942303495923177e-263, 19, "105542401729423035", -262},
  {2.5998416366667517445832400e+92, 17, "25998416366667517", 93},
  {1.1816879255522324829667404e-137, 17, "11816879255522325", -136},
  {2.5023439902590312500000000e+13, 19, "250234399025903125", 14},
  {8.0039157277491231457280000e+21, 7, "8003916", 22},
  {6.3990315075080882604557410e-157, 16, "6399031507508088", -156},
  {3.3423918306805640520910480e+72, 20, "33423918306805640521", 73},
  {4.5929180882626355507303286e+144, 12, "459291808826", 145},
  {9.6312426050835636563924719e-120, 10, "9631242605", -119},
  {4.3121934703694345127208408e+228, 17, "43121934703694345", 229},
  {6.2144720756843056440836517e-80, 2, "62", -79},
  {5.4761660458135452536723501e+272, 13, "5476166045814", 273},
  {1.0190995958256277575480595e-258, 12, "101909959583", -257},
  {1.2079281118725651977702794e-236, 20, "12079281118725651978", -235},
  {3.8895673419811952743096786e+267, 11, "3889567342", 268},
  {4.0199873865891141891479492e+09, 18, "401998738658911419", 10},
  {2.9258777950795089413325246e-196, 5, "29259", -195},
  {1.0675207625546020118942330e+135, 19, "1067520762554602012", 136},
  {4.3245994357024301570478915e-08, 17, "43245994357024302", -7},
  {1.4194101730975915005766743e+258, 12, "14194101731", 259},
  {9.6840837251363682762765046e+42, 21, "968408372513636827628", 43},
  {2.0805988704663648563640914e-26, 9, "208059887", -25},
  {4.2857780729177470365864736e-262, 11, "42857780729", -261},
  {8.5816666599560960681142329e-07, 13, "8581666659956", -6},
  {3.4055141945146579634488372e-133, 4, "3406", -132},
  {9.9143689560917419255224489e-14, 8, "9914369", -13},
  {1.1531671513011824132522240e-230, 8, "11531672", -229},
  {1.9636450347816984246914880e-128, 8, "1963645", -127},
  {1.0237048634988275081902287e+294, 19, "1023704863498827508", 295},
  {1.0502310232169895447245228e+115, 4, "105", 116},
  {1.9765890561353992543261238e-291, 11, "19765890561", -290},
  {1.2244177711556937650397233e+213, 10, "1224417771", 214},
  {2.3667292690892315673828125e+11, 4, "2367", 12},
  {4.5038789992289081532533239e-48, 17, "45038789992289082", -47},
  {1.1469409304123378562498560e+24, 9, "114694093", 25},
  {8.1348242010979083665616349e-138, 10, "8134824201", -137},
  {1.3977918215375909765914699e+109, 15, "139779182153759", 110},
  {1.1046435715419753611675862e+91, 20, "11046435715419753612", 92},
  {1.4044950780502135044862876e+102, 17, "14044950780502135", 103},
  {5.1554784293873869016611167e-02, 5, "51555", -1},
  {7.8342786223953119229481233e-174, 2, "78", -173},
  {4.3261068125939067552863396e+236, 3, "433", 237},
  {6.0864234456383006524833931e-279, 8, "60864234", -278},
  {2.5266230257111903616972713e-94, 11, "25266230257", -93},
  {6.3165160063592532221397863e+60, 2, "63", 61},
  {1.7817731803537595843659948e+161, 4, "1782", 162},
  {1.2314726475075404369405425e-58, 5, "12315", -57},
  {2.6207722338900183592420974e-53, 10, "2620772234", -52},
  {2.0420245751319902825665572e+129, 6, "204202", 130},
  {6.5048132075002583378746205e-148, 13, "65048132075", -147},
  {1.3707618123411097239070812e-270, 14, "13707618123411", -269},
  {4.7046972785748876774724528e-201, 16, "4704697278574888", -200},
  {6.6321865455068650248601600e+24, 7, "6632187", 25},
  {4.9783272554457095576909611e+130, 16, "497832725544571", 131},
  {1.9793872957885025078012704e+108, 13, "1979387295789", 109},
  {5.0283868210114074638802221e-46, 18, "502838682101140746", -45},
  {6.4056353741536931260472371e+261, 11, "64056353742", 262},
  {4.9423274662858747902658947e-105, 7, "4942327", -104},
  {7.1371208633715126922375578e+201, 19, "7137120863371512692", 202},
  {8.8727726843481034628196340e+218, 2, "89", 219},
  {1.4470052116664723274924619e+99, 15, "144700521166647", 100},
  {1.1220002916375184345713796e+36, 17, "11220002916375184", 37},
  {2.8392422897526239435860745e-303, 12, "283924228975", -302},
  {1.9005485452563910508597272e-135, 10, "1900548545", -134},
  {9.6465516196429095836930672e+50, 18, "964655161964290958", 51},
  {2.1507873949952902460037164e-49, 7, "2150787", -48},
  {5.9387734319765086939346316e+68, 9, "593877343", 69},
  {7.1061164914097124297214112e+218, 13, "710611649141", 219},
  {1.4519119518944584158577772e+197, 9, "145191195", 198},
  {2.8441308132538046851911803e-128, 3, "284", -127},
  {3.9825391293511693821501477e+249, 14, "39825391293512", 250},
  {3.4978800696375048463832089e+254, 17, "34978800696375048", 255},
  {8.9853743769060655889527754e+124, 20, "8985374376906065589", 125},
  {1.5737498778486345174016348e-34, 18, "157374987784863452", -33},
  {4.6542500631923703180817091e+257, 5, "46543", 258},
  {9.9156607364184850290514229e+152, 1, "1", 154},
  {3.5371009933015304692637208e-186, 17, "35371009933015305", -185},
  {3.3772969155085807329275707e+103, 10, "3377296916", 104},
  {1.8772098280449528160481451e-73, 16, "1877209828044953", -72},
  {1.2078735100376403785202633e+169, 15, "120787351003764", 170},
  {2.4170040811105560977163956e-73, 20, "24170040811105560977", -72},
  {4.4626699722721884340808550e+296, 14, "44626699722722", 297},
  {1.9262874536239298951550581e-164, 8, "19262875", -163},
  {1.5048419929507001687481255e-43, 20, "15048419929507001687", -42},
  {2.1582585352733429175027694e+298, 18, "215825853527334292", 299},
  {2.2135056272488928917555581e-142, 12, "221350562725", -141},
  {2.2742065700295657512777909e-263, 16, "2274206570029566", -262},
  {4.4375746036896836783471666e-305, 1, "4", -304},
  {4.5623498362954794821709268e+206, 18, "456234983629547948", 207},
  {1.3553013214617201477199907e+35, 15, "135530132146172", 36},
  {4.6554691561987616621327165e-282, 16, "4655469156198762", -281},
  {1.2112888435886456165413487e+192, 10, "1211288844", 193},
  {1.2362257805628942464588040e+61, 21, "123622578056289424646", 62},
  {4.1364542344580871093357435e+46, 7, "4136454", 47},
  {4.3007094826549064789555450e+203, 3, "43", 204},
  {3.6903248176893202156035704e+120, 8, "36903248", 121},
  {7.9016202420037072115171750e+198, 6, "790162", 199},
  {1.2613378158380540000342435e-106, 7, "1261338", -105},
  {5.0956848607958206202557297e+175, 16, "5095684860795821", 176},
  {3.3357895880928286546877232e-30, 21, "333578958809282865469", -29},
  {2.7063660361920016479280350e-219, 17, "27063660361920016", -218},
  {2.8558231771336683223635012e+277, 9, "285582318", 278},
  {1.6142610326879616368640000e+22, 3, "161", 23},
  {1.1945051618889051191538096e+60, 17, "11945051618889051", 61},
  {3.4986989332174446542673200e-246, 21, "349869893321744465427", -245},
  {5.5517495291050419974719615e+172, 12, "555174952911", 173},
  {4.6844084086027965183005207e+103, 7, "4684408", 104},
  {2.9763895173122956919245902e+119, 14, "29763895173123", 120},
  {1.8004482946148459899073455e+149, 12, "180044829461", 150},
  {1.9218854007200623378750575e+69, 18, "192188540072006234", 70},
  {1.0117768271656757682334423e-205, 21, "101177682716567576823", -204},
  {1.4078544813052222467039744e+135, 20, "14078544813052222467", 136},
  {1.4910755897085031220443185e+172, 6, "149108", 173},
  {6.2307485965264885557238449e-301, 2, "62", -300},
  {1.8272356776125971227884293e+07, 1, "2", 8},
  {1.7285069951084521122768947e+212, 9, "1728507", 213},
  {6.2002525707575769313420457e-75, 10, "6200252571", -74},
  {6.1512976654896165184429614e+71, 13, "615129766549", 72},
  {9.0015040903217328069646054e+248, 7, "9001504", 249},
  {3.8080022370417078429870103e+32, 20, "3808002237041707843", 33},
  {9.0231974825535976915100373e+118, 3, "902", 119},
  {2.4285884375387720229108879e-214, 20, "24285884375387720229", -213},
  {1.1545163927243648172640178e+36, 13, "1154516392724", 37},
  {4.5546121860576458821113642e+105, 8, "45546122", 106},
  {3.2985473389516581593746204e+39, 7, "3298547", 40},
  {1.7933258800159923087792472e-195, 14, "1793325880016", -194},
  {1.4651408801853561452554596e+275, 11, "14651408802", 276},
  {5.4176573982494078530755450e-272, 7, "5417657", -271},
  {1.0087516442404687141120620e-26, 21, "100875164424046871411", -25},
  {3.4607571159152699092667771e-124, 19, "3460757115915269909", -123},
  {2.7561096087353302595675991e-11, 5, "27561", -10},
  {2.8571016659982128982252879e-292, 16, "2857101665998213", -291},
  {3.4285144065154920611064218e-160, 10, "3428514407", -159},
  {6.4678357841965611401494837e+305, 12, "64678357842", 306},
  {6.0277492378444677638906410e+262, 17, "60277492378444678", 263},
  {3.9724678993162020547066893e+218, 3, "397", 219},
  {1.9349528242689879268135372e-05, 1, "2", -4},
  {4.3566885243929220525985638e+49, 3, "436", 50},
  {1.4225239406968553278075874e+222, 4, "1423", 223},
  {4.2613065886362150567399906e+207, 7, "4261307", 208},
  {6.9947930412337407280220148e-20, 10, "6994793041", -19},
  {1.0675091729960360315671747e-29, 2, "11", -28},
  {4.7436984570629318748851698e+72, 5, "47437", 73},
  {7.4460354530294840593918676e-202, 10, "7446035453", -201},
  {2.0279913965332878656445204e-217, 14, "20279913965333", -216},
  {1.9267388764819574198667575e+119, 18, "192673887648195742", 120},
  {7.2420223297964575084598899e+241, 1, "7", 242},
  {2.2491443092177043077540278e-229, 14, "22491443092177", -228},
  {3.1003026594143674451345269e-121, 5, "31003", -120},
  {2.7264562825252932729092110e-274, 18, "272645628252529327", -273},
  {1.3074540342736855758053882e-54, 10, "1307454034", -53},
  {3.1145722898011835390802243e-190, 6, "311457", -189},
  {1.6590972774907713134051890e+260, 5, "16591", 261},
  {8.4285902382835398186586140e-71, 14, "84285902382835", -70},
  {4.9424304356331166401512923e+269, 3, "494", 270},
  {1.6484208619677971105504977e+66, 3, "165", 67},
  {4.9030096877725484904666845e+265, 16, "4903009687772548", 266},
  {4.7442222740153111449789978e-21, 21, "474422227401531114498", -20},
  {7.7989090223695004766369894e+148, 9, "779890902", 149},
  {1.7759821506825180578208834e-67, 13, "1775982150683", -66},
  {8.8707941974065888022588617e+306, 21, "887079419740658880226", 307},
  {5.6482553694347700652546000e-267, 17, "56482553694347701", -266},
  {5.4403669841950341303716765e+130, 18, "544036698419503413", 131},
  {2.8801944641898190710807965e+272, 3, "288", 273},
  {4.7380729437503205305830972e-22, 18, "473807294375032053", -21},
  {5.2201297139890565298420303e+121, 14, "52201297139891", 122},
  {1.0562175936536320751392069e+279, 2, "11", 280},
  {9.4303001185793775143153943e+243, 10, "9430300119", 244},
  {1.7595029462346938749547300e+291, 12, "175950294623", 292},
  {9.3303908774440920199169167e-231, 18, "933039087744409202", -230},
  {4.6188781784760912218462737e-48, 14, "46188781784761", -47},
  {4.9519748788175606300215054e-46, 4, "4952", -45},
  {3.5113019944627788599356762e-66, 14, "35113019944628", -65},
  {2.7662486162379107879710206e+108, 2, "28", 109},
  {9.2466989472400918981314323e-192, 11, "92466989472", -191},
  {5.0559386487674407780122769e-146, 20, "5055938648767440778", -145},
  {2.0563132381403745192182033e+183, 9, "205631324", 184},
  {4.3511627928840766707077349e-95, 13, "4351162792884", -94},
  {9.0690094609256159990464144e+173, 17, "9069009460925616", 174},
  {3.7708481351086723327636719e+10, 8, "37708481", 11},
  {4.2661221886907774631637865e-202, 4, "4266", -201},
  {2.3582296250092147609206574e+189, 9, "235822963", 190},
  {2.0430675707109696289782233e+103, 2, "2", 104},
  {3.9743310523278634611479434e-294, 3, "397", -293},
  {2.5349301686170623199305625e-86, 19, "253493016861706232", -85},
  {1.6250762630672959236927074e-182, 10, "1625076263", -181},
  {8.6799011829777390643979992e+177, 2, "87", 178},
  {1.5094918903493007332772533e-270, 14, "15094918903493", -269},
  {3.7333533088957946259317136e+228, 4, "3733", 229},
  {8.3086620714311215484900148e+244, 10, "8308662071", 245},
  {1.1431817360817647176051850e-286, 1, "1", -285},
  {3.8792842833960911439590272e+259, 1, "4", 260},
  {1.5835489923413164353714291e+56, 9, "158354899", 57},
  {2.0069414402066733465600000e+20, 14, "20069414402067", 21},
  {5.3691473402150604657915322e-180, 16, "536914734021506", -179},
  {3.4345656607662839630116925e+30, 17, "3434565660766284", 31},
  {2.6327960571012854644654554e+52, 21, "263279605710128546447", 53},
  {8.7400197328585770007546720e-103, 19, "8740019732858577001", -102},
  {9.9686750014698978988178307e+279, 12, "996867500147", 280},
  {4.2170765456873075454028138e+52, 16, "4217076545687308", 53},
  {2.4186583242893864069943020e+217, 10, "2418658324", 218},
  {5.0659561510211032483245691e-91, 10, "5065956151", -90},
  {3.0058774179080176342565285e+53, 10, "3005877418", 54},
  {6.7304078940965758718496506e+147, 17, "67304078940965759", 148},
  {3.5670552021799013357744010e+36, 15, "35670552021799", 37},
  {4.4215868831004586537636787e-306, 21, "442158688310045865376", -305},
  {7.4112353666705635521073272e+300, 2, "74", 301},
  {2.2391490567718713009399806e+131, 20, "22391490567718713009", 132},
  {5.9619488939122040510545177e-153, 14, "59619488939122", -152},
  {7.7723416665503773009322107e-110, 9, "777234167", -109},
  {3.1357093320704187011718750e+11, 21, "313570933207041870117", 12},
  {2.3052299319127295474860056e+268, 8, "23052299", 269},
  {1.0862356428381102806670150e+140, 3, "109", 141},
  {6.8012258482170587867152102e+108, 21, "680122584821705878672", 109},
  {8.7176161874682017100957112e-212, 3, "872", -211},
  {2.5999182053870781912810074e-278, 18, "259991820538707819", -277},
  {1.5716049883406568768073920e+48, 5, "15716", 49},
  {3.6201441758385968939316648e-23, 6, "362014", -22},
  {4.2000558626050334739415737e-04, 1, "4", -3},
  {2.4365432337430915182504638e-272, 9, "243654323", -271},
  {3.6501656981091448770808032e-132, 5, "36502", -131},
  {3.3687937917168111125865179e-265, 17, "33687937917168111", -264},
  {3.1688827936219683983839685e+259, 9, "316888279", 260},
  {3.0218322896927448715081589e-169, 11, "30218322897", -168},
  {1.7449300780472004470807189e+211, 20, "17449300780472004471", 212},
  {7.5176166599113932582589330e+243, 6, "751762", 244},
  {1.3844597969021400397626100e-102, 9, "13844598", -101},
  {3.2318495858718754881031834e-123, 8, "32318496", -122},
  {1.5068287599338156460155577e-300, 18, "150682875993381565", -299},
  {3.0935984324751768912609096e+144, 5, "30936", 145},
  {6.8979082646661925410751997e-71, 7, "6897908", -70},
  {3.5536575478095142370779573e-297, 10, "3553657548", -296},
  {2.1043856734742511618903504e-216, 16, "2104385673474251", -215},
  {1.5009520261198101950687853e-286, 18, "15009520261198102", -285},
  {1.5234976958038574922684155e+113, 4, "1523", 114},
  {1.0692360180891228276442513e-173, 5, "10692", -172},
  {3.5941227468097971662476507e+168, 16, "3594122746809797", 169},
  {5.7495089959218543810383265e-62, 19, "5749508995921854381", -61},
  {1.5261075576732190180582443e-98, 1, "2", -97},
  {7.1155864635092044692807704e-210, 1, "7", -209},
  {1.9993402687035225823354975e+236, 4, "1999", 237},
  {7.8898829479210631022791580e-298, 5, "78899", -297},
  {1.4046678899531970852497723e+228, 12, "140466788995", 229},
  {7.4529056652835414159829369e-190, 5, "74529", -189},
  {2.1028384992714743586347671e+40, 17, "21028384992714744", 41},
  {7.7897141119468537467456168e-123, 14, "77897141119469", -122},
  {9.7325153990714750406943098e+87, 13, "9732515399071", 88},
  {2.9524927082592474847951194e+299, 10, "2952492708", 300},
  {1.1646698336116952355790363e+60, 14, "11646698336117", 61},
  {3.8450965308777816348772868e+143, 12, "384509653088", 144},
  {1.3431982450340844242559130e+250, 15, "134319824503408", 251},
  {1.8435803331217062800086820e-278, 6, "184358", -277},
  {8.5048445932963938688748048e+100, 11, "85048445933", 101},
  {1.6979472623891320987473132e+162, 2, "17", 163},
  {1.6219164108802235096596029e-239, 4, "1622", -238},
  {1.6601796898035391872519775e+69, 5, "16602", 70},
  {4.6022023597426397401715266e+69, 7, "4602202", 70},
  {1.4267876564392927613542230e+85, 17, "14267876564392928", 86},
  {3.4294584817735118680782828e-211, 10, "3429458482", -210},
  {4.3242248384376905113671112e+206, 21, "432422483843769051137", 207},
  {1.2907770433657661527065371e-130, 2, "13", -129},
  {4.5060325478135969159765589e+30, 1, "5", 31},
  {1.1934919661830342860917433e+198, 11, "11934919662", 199},
  {2.3279518509054256607460396e-65, 19, "2327951850905425661", -64},
  {1.0229043748525610372196410e+108, 20, "10229043748525610372", 109},
  {3.2608970345150186360680976e-141, 10, "3260897035", -140},
  {8.8253314593997265281133143e-248, 3, "883", -247},
  {2.3142535979582451006101227e-137, 5, "23143", -136},
  {6.0692175723377551298308800e-249, 16, "6069217572337755", -248},
  {1.6404662330514676516377601e+208, 5, "16405", 209},
  {3.7479851909396091315655062e+102, 19, "3747985190939609132", 103},
  {2.2099131460155710156384601e-259, 4, "221", -258},
  {1.0100213947528528866925603e+279, 16, "1010021394752853", 280},
  {2.2829414258773157806893961e+155, 6, "228294", 156},
  {3.9885585037634296006026793e-293, 21, "39885585037634296006", -292},
  {3.3742600264452771006912466e-282, 8, "337426", -281},
  {4.4551193418410535999478967e+30, 18, "44551193418410536", 31},
  {3.5739999003866861661988032e+196, 4, "3574", 197},
  {5.6347516321601933671564210e-56, 20, "56347516321601933672", -55},
  {5.2917422613428253491200000e+20, 10, "5291742261", 21},
  {8.4682215718977200836525169e-69, 11, "84682215719", -68},
  {1.8497319222001005003228309e+242, 18, "18497319222001005", 243},
  {7.8362856386488528996793609e-07, 20, "78362856386488528997", -6},
  {7.8738327956871415000720047e+284, 5, "78738", 285},
  {2.9457611068559453991325329e+91, 11, "29457611069", 92},
  {1.9027510916595689093548736e+282, 14, "19027510916596", 283},
  {6.2140841052491982491351360e+289, 12, "621408410525", 290},
  {2.2090132921432642539404029e-84, 21, "220901329214326425394", -83},
  {3.6464263301021956318906914e+244, 4, "3646", 245},
  {3.6755679597648692398627250e-177, 18, "367556795976486924", -176},
  {5.4291138852390488475673511e-299, 15, "542911388523905", -298},
  {5.3893576378867565494915918e-148, 1, "5", -147},
  {7.3237362928459099503347871e+125, 3, "732", 126},
  {2.3109630515749830915801524e-53, 19, "2310963051574983092", -52},
  {1.3229289018383887198074146e-188, 11, "13229289018", -187},
  {6.4728224911527580007791819e-224, 21, "647282249115275800078", -223},
  {2.5601248081524179749672600e+247, 2, "26", 248},
  {3.6566937553718579308789760e+24, 18, "365669375537185793", 25},
  {2.7026915031186274721925110e+280, 9, "27026915", 281},
  {1.9094294566622210540907620e-197, 7, "1909429", -196},
  {5.8769764103671202050736635e+163, 7, "5876976", 164},
  {5.1565129940814334593718882e-294, 9, "515651299", -293},
  {1.3243674904215173213273914e+213, 19, "1324367490421517321", 214},
  {2.8772002595583585389249492e+03, 19, "2877200259558358539", 4},
  {2.3847330411293874626457880e-197, 7, "2384733", -196},
  {1.5686629261225162834722887e+216, 8, "15686629", 217},
  {6.5099008660699117624781691e-101, 10, "6509900866", -100},
  {6.3848638425306651660027715e-116, 17, "63848638425306652", -115},
  {5.8290424313756864756861257e+147, 12, "582904243138", 148},
  {4.0319004256121550414840426e-271, 15, "403190042561216", -270},
  {1.8751279390285869592136958e+36, 2, "19", 37},
  {8.1666288174498931513878248e-250, 17, "81666288174498932", -249},
  {4.3685427265032907385344505e-209, 13, "4368542726503", -208},
  {3.0437667512454902220116960e+283, 15, "304376675124549", 284},
  {5.1984530181728363878038127e+207, 10, "5198453018", 208},
  {6.4203320110014166689930803e-301, 14, "64203320110014", -300},
  {1.2417337995956781457062999e+44, 17, "12417337995956781", 45},
  {1.4442171625854890851562205e-158, 3, "144", -157},
  {6.9550396864023339961218387e-303, 11, "69550396864", -302},
  {2.6553665491237867900731639e-65, 6, "265537", -64},
  {9.2884541550835624939250102e+197, 16, "9288454155083562", 198},
  {3.4485981783324481535882994e+133, 10, "3448598178", 134},
  {1.3873563009198549841259020e-105, 12, "138735630092", -104},
  {3.8317379099111998446585738e+136, 4, "3832", 137},
  {1.1551452748784832635919884e+01, 12, "115514527488", 2},
  {2.4100584993571804680788656e-145, 20, "24100584993571804681", -144},
  {8.6089020264249229431152344e+09, 17, "86089020264249229", 10},
  {2.5365142696027489736260722e+48, 5, "25365", 49},
  {5.2733418342234307835881529e-74, 12, "527334183422", -73},
  {7.0433941024415806425441519e+216, 10, "7043394102", 217},
  {1.0120273342140567395167968e+160, 8, "10120273", 161},
  {1.0004568406522688397362521e-189, 7, "1000457", -188},
  {7.9454306060755005730397606e-137, 17, "79454306060755006", -136},
  {3.0959786260890481009439802e+97, 11, "30959786261", 98},
  {2.7697395017308819894889664e-103, 14, "27697395017309", -102},
  {8.8198647741959009621825995e+53, 3, "882", 54},
  {2.1102467084356426284256356e+32, 7, "2110247", 33},
  {3.8524214865064036658070484e-134, 2, "39", -133},
  {7.2166812742914096746246784e-164, 9, "721668127", -163},
  {1.9396240962556944358118612e-249, 13, "1939624096256", -248},
  {1.4058129887988684326173646e-274, 7, "1405813", -273},
  {1.6668343224463553481240433e-60, 9, "166683432", -59},
  {1.1128040684421338732166525e+249, 1, "1", 250},
  {6.8265546736936050932481699e-97, 5, "68266", -96},
  {1.4957620673372239041698289e-33, 6, "149576", -32},
  {2.0902999213714423126786457e-02, 19, "2090299921371442313", -1},
  {1.9337252650568360064291256e-95, 7, "1933725", -94},
  {3.6735462396249867052879815e-111, 18, "367354623962498671", -110},
  {6.6665230598631435042575083e+225, 19, "6666523059863143504", 226},
  {4.1633529370307523888537396e-185, 3, "416", -184},
  {1.2155521707315590527936697e-190, 17, "12155521707315591", -189},
  {9.7408071087816046716903511e-98, 5, "97408", -97},
  {5.9718835129586598071336542e+175, 3, "597", 176},
  {9.6842949727465018415213545e-223, 20, "96842949727465018415", -222},
  {4.6495355756499321736142522e-217, 15, "464953557564993", -216},
  {3.2198194511762202725242666e-35, 19, "3219819451176220273", -34},
  {2.3261639132931188214570284e+04, 9, "232616391", 5},
  {1.6324657809917689879325039e-43, 15, "163246578099177", -42},
  {2.1052559388694482641678399e-178, 7, "2105256", -177},
  {2.8196429116036562435146942e+144, 7, "2819643", 145},
  {6.6825107249317865020123043e+300, 6, "668251", 301},
  {5.8294558342980941151186938e-14, 12, "58294558343", -13},
  {2.0487730525047447737481675e+219, 14, "20487730525047", 220},
  {3.2030658546930552627101070e+60, 6, "320307", 61},
  {3.1807366388463797101037803e+188, 10, "3180736639", 189},
  {8.0744828608435627265390660e+186, 8, "80744829", 187},
  {1.8447131703624430861931648e+274, 1, "2", 275},
  {1.2317825537802922671344240e+258, 11, "12317825538", 259},
  {2.4496378379416135404133693e-210, 4, "245", -209},
  {3.2808525235487761605316961e-76, 1, "3", -75},
  {2.0154140491132757109374976e+25, 1, "2", 26},
  {1.0766645956640666842892755e+179, 3, "108", 180},
  {5.9179996042796935340352515e-229, 13, "591799960428", -228},
  {5.9267856227606988980141842e-178, 1, "6", -177},
  {1.1538879625629301280652432e-291, 17, "11538879625629301", -290},
  {1.7740219350026959462442275e-107, 15, "17740219350027", -106},
  {2.8858951723214141633816361e-148, 10, "2885895172", -147},
  {2.3945088092615561183120166e+233, 17, "23945088092615561", 234},
  {6.8460255606805736165826345e-132, 12, "684602556068", -131},
  {9.7857739493110256841318095e-114, 12, "978577394931", -113},
  {6.7923183542581991666757886e+245, 5, "67923", 246},
  {1.6218689655732717821016748e-193, 2, "16", -192},
  {1.3774610442264618797826100e+252, 10, "1377461044", 253},
  {4.5290108091650637355307914e+291, 9, "452901081", 292},
  {3.5080488454161209648611546e+208, 5, "3508", 209},
  {2.1293125702103597840107273e-145, 4, "2129", -144},
  {8.2975725766985447270971444e+223, 1, "8", 224},
  {1.8677310699083175171977225e-174, 21, "18677310699083175172", -173},
  {3.5117545021149996126192414e-214, 3, "351", -213},
  {8.4936477177378894451891551e-104, 1, "8", -103},
  {7.4422856210820714686758358e-277, 13, "7442285621082", -276},
  {8.8649999283129551247402312e-306, 12, "886499992831", -305},
  {1.7046505813194481645185493e-257, 17, "17046505813194482", -256},
  {3.6281203851106663565996465e-100, 13, "3628120385111", -99},
  {3.2371604592234858323118667e+292, 4, "3237", 293},
  {3.0473436709415564152237775e+227, 18, "304734367094155642", 228},
  {1.1568677302121356170370508e+302, 15, "115686773021214", 303},
  {1.1086775056446742266416550e+07, 19, "1108677505644674227", 8},
  {5.2033118535001731206157286e+254, 1, "5", 255},
  {5.0027712687251836061477661e+07, 3, "5", 8},
  {3.7412548431323816337625606e+145, 8, "37412548", 146},
  {1.7243702010496995177005274e-302, 3, "172", -301},
  {1.0130517171193712149024838e-162, 21, "10130517171193712149", -161},
  {2.1084262543430101046554258e-217, 7, "2108426", -216},
  {5.1769201721115490178575224e-41, 19, "5176920172111549018", -40},
  {4.7418666784333855742467369e-211, 3, "474", -210},
  {6.4450509154938119306976078e-108, 15, "644505091549381", -107},
  {3.9150387313515458971322417e-10, 12, "391503873135", -9},
  {2.8970527059710803441703320e+06, 3, "29", 7},
  {1.1881286734849529354794808e-293, 13, "1188128673485", -292},
  {3.0993762816696141409329867e+80, 18, "309937628166961414", 81},
  {1.9747644870269985025872150e-35, 1, "2", -34},
  {1.2668669018542468446856118e-14, 21, "126686690185424684469", -13},
  {5.8103216715355187088127891e+156, 11, "58103216715", 157},
  {4.7587945514733204574175927e+264, 2, "48", 265},
  {4.1447104674388076956109124e+78, 21, "414471046743880769561", 79},
  {2.2020684855686255984652243e+134, 4, "2202", 135},
  {7.9745965173584091280960966e-196, 11, "79745965174", -195},
  {2.7850051128444455020202702e-52, 13, "2785005112844", -51},
  {4.0911394578299915416548854e-121, 14, "409113945783", -120},
  {8.0312096755773896465794911e+199, 7, "803121", 200},
  {1.7745785702238769678982617e-220, 18, "177457857022387697", -219},
  {4.5700061642315767470166745e+272, 14, "45700061642316", 273},
  {1.7455913725278183015457555e-275, 1, "2", -274},
  {1.6633299768578110710371787e+247, 4, "1663", 248},
  {1.3084318562094394668078046e+129, 12, "130843185621", 130},
  {1.8566160840842598404025335e-104, 4, "1857", -103},
  {3.6439249191696757847970531e-255, 15, "364392491916968", -254},
  {3.5923799387012605822947692e-33, 1, "4", -32},
  {5.8969154311615719020205700e-261, 15, "589691543116157", -260},
  {6.2811669852096550242085112e+244, 10, "6281166985", 245},
  {3.2759670909423237073420022e+183, 4, "3276", 184},
  {6.8298565917302947617705515e+188, 8, "68298566", 189},
  {7.3229966119667035989523112e+93, 1, "7", 94},
  {4.6995276486258772408177720e+00, 12, "469952764863", 1},
  {3.3788789288059797769562677e+117, 6, "337888", 118},
  {4.2334947569299661959718015e+185, 13, "423349475693", 186},
  {2.2588353527207806963032982e+209, 2, "23", 210},
  {1.0598561102325271924562721e-65, 17, "10598561102325272", -64},
  {1.3900943824844422040084908e+60, 15, "139009438248444", 61},
  {8.4938751095542225243063320e+47, 21, "849387510955422252431", 48},
  {1.1723971745832058781815117e-278, 10, "1172397175", -277},
  {1.5235582910250454917872966e-176, 12, "152355829103", -175},
  {1.4012636723874889221816433e+141, 17, "14012636723874889", 142},
  {1.0644078399533075226908082e+188, 18, "106440783995330752", 189},
  {1.2590572315280127488102894e-77, 8, "12590572", -76},
  {1.3729490735650908401009583e-97, 16, "1372949073565091", -96},
  {1.8735625625178785433111173e+291, 14, "18735625625179", 292},
  {1.7082677944666125442395498e-12, 21, "170826779446661254424", -11},
  {2.9869076250440754333114361e+229, 1, "3", 230},
  {1.2286242567559688511182279e-71, 12, "122862425676", -70},
  {3.3113258472126434326171875e+11, 15, "331132584721264", 12},
  {2.2073461293256909161183730e+104, 11, "22073461293", 105},
  {2.2475426925035494128668372e-127, 13, "2247542692504", -126},
  {1.2529746602576011537677349e-85, 9, "125297466", -84},
  {6.1948619311324065856875501e-125, 13, "6194861931132", -124},
  {2.6762416845912009790010438e+236, 19, "2676241684591200979", 237},
  {7.7085508993262475466498940e-241, 14, "77085508993262", -240},
  {1.4511662662296893667104200e-213, 6, "145117", -212},
  {2.4560933414297747576270380e-117, 3, "246", -116},
  {1.9010358951825147974040625e+267, 11, "19010358952", 268},
  {4.0502852609517448822644380e+190, 1, "4", 191},
  {2.3498537056134304314547620e-290, 17, "23498537056134304", -289},
  {1.4736607986794968221888178e+265, 4, "1474", 266},
  {9.6562704203491944842614159e+252, 15, "965627042034919", 253},
  {5.4257304458262607674950006e+160, 10, "5425730446", 161},
  {2.8020300898223801792064700e-256, 3, "28", -255},
  {1.7545043883289646566917525e-122, 17, "17545043883289647", -121},
  {1.4804242197342322701490353e+257, 16, "1480424219734232", 258},
  {4.0312025846039748686274785e-97, 9, "403120258", -96},
  {2.2208562049486352011500140e+244, 11, "22208562049", 245},
  {1.4742049824631873877308896e-219, 18, "147420498246318739", -218},
  {1.7999067346509644672243987e+104, 1, "2", 105},
  {9.4727694049973310288277524e-113, 15, "947276940499733", -112},
  {2.5458090666471436500384329e-165, 12, "254580906665", -164},
  {4.7018331102909426800334656e-281, 12, "470183311029", -280},
  {1.6580443307822122720985345e+65, 15, "165804433078221", 66},
  {7.4056502649086910702869169e-03, 20, "74056502649086910703", -2},
  {2.5688702394648221691895106e+200, 6, "256887", 201},
  {1.5126935305669687619716205e+104, 15, "151269353056697", 105},
  {1.7376036521165323521165653e-279, 16, "1737603652116532", -278},
  {9.8262146283027485282227709e+237, 13, "9826214628303", 238},
  {8.6254358326431597600036207e+54, 14, "86254358326432", 55},
  {3.1479201803098104092087530e-83, 18, "314792018030981041", -82},
  {1.1109256234310877968854154e-06, 5, "11109", -5},
  {2.6761722115359298892177091e-52, 11, "26761722115", -51},
  {3.8680284982664479144680213e-259, 16, "3868028498266448", -258},
  {2.0134809750360447384087925e-73, 2, "2", -72},
  {1.2537582539903803262859583e+05, 6, "125376", 6},
  {6.7016061655732291170012427e-195, 12, "670160616557", -194},
  {2.7123910255498259415082869e-175, 5, "27124", -174},
  {1.2061703386003626292222179e+04, 6, "120617", 5},
  {3.9121779333964107474588744e+51, 12, "39121779334", 52},
  {3.4897916975686421322587951e-258, 5, "34898", -257},
  {5.6726299864885023669856764e+28, 16, "5672629986488502", 29},
  {7.5093917279403422162306059e+269, 2, "75", 270},
  {4.2715008719309382598822426e-107, 5, "42715", -106},
  {1.1113577197177377738282199e-54, 11, "11113577197", -53},
  {7.4270799746914299613304149e-57, 8, "742708", -56},
  {1.3971866411380525130902783e-245, 6, "139719", -244},
  {9.5871457726238713619381144e+73, 3, "959", 74},
  {8.6577297689645652518198095e+130, 20, "86577297689645652518", 131},
  {7.7346678274401975047126693e-13, 20, "77346678274401975047", -12},
  {3.0294672482664764827011163e+257, 3, "303", 258},
  {1.0384491903802622659629989e-181, 7, "1038449", -180},
  {1.3780338840879908894167233e-68, 1, "1", -67},
  {5.7035146503375467451245157e+255, 10, "570351465", 256},
  {1.7963876892646573644884545e-97, 21, "179638768926465736449", -96},
  {2.0925722906335695382424780e+198, 4, "2093", 199},
  {1.9397948425903592105632250e+197, 21, "193979484259035921056", 198},
  {5.8425241745128524505904192e-200, 19, "5842524174512852451", -199},
  {1.7789589688044490239397869e+263, 18, "177895896880444902", 264},
  {3.1768172536408794653574780e+198, 20, "31768172536408794654", 199},
  {2.1257972231417210643012325e+159, 16, "2125797223141721", 160},
  {3.4081148896211238167876718e+39, 10, "340811489", 40},
  {7.0296077277245053337600000e+20, 6, "702961", 21},
  {5.6700946633400579073298391e-118, 21, "567009466334005790733", -117},
  {4.4223222716085787834776331e+198, 11, "44223222716", 199},
  {1.1550227716500945289812469e-48, 13, "115502277165", -47},
  {8.8009400089514611616251055e-222, 17, "88009400089514612", -221},
  {9.7380909020055071180490143e-199, 2, "97", -198},
  {5.9570350306364153530081377e+158, 15, "595703503063642", 159},
  {3.4785827477672631439682024e+283, 5, "34786", 284},
  {1.2861764385917172396006417e+202, 6, "128618", 203},
  {4.4392628968048323885181134e+138, 1, "4", 139},
  {8.5201862135493858364344357e+298, 11, "85201862135", 299},
  {4.2487095222772236133881021e+107, 15, "424870952227722", 108},
  {6.7255640942225554794287189e+99, 21, "672556409422255547943", 100},
  {3.9785458791970949130135125e+303, 8, "39785459", 304},
  {2.0755356726691484444453830e-35, 15, "207553567266915", -34},
  {3.1923746699564580946302502e+176, 12, "319237466996", 177},
  {8.2255728073756454905314060e+120, 1, "8", 121},
  {2.6268124148051014789276831e-106, 11, "26268124148", -105},
  {5.0065247462580443507952732e+61, 6, "500652", 62},
  {6.1778212654642847727877918e+106, 19, "6177821265464284773", 107},
  {5.1258848179320900750882616e-185, 17, "51258848179320901", -184},
  {6.7129726428992614506467540e+53, 13, "6712972642899", 54},
  {3.4581501453521766400000000e+18, 1, "3", 19},
  {3.4750745105827600769208170e+79, 18, "347507451058276008", 80},
  {6.6781004020690652864229962e-206, 7, "66781", -205},
  {1.2136442582822106332631274e-291, 19, "1213644258282210633", -290},
  {2.3458477770896407360437511e-284, 9, "234584778", -283},
  {1.1378924221540962946619402e+02, 16, "1137892422154096", 3},
  {7.9702154597906520272238112e-307, 16, "7970215459790652", -306},
  {1.7436546671271433094524744e-83, 4, "1744", -82},
  {3.3340240587247515035120238e-233, 9, "333402406", -232},
  {1.7337358069419077795001355e-80, 17, "17337358069419078", -79},
  {3.7927324329386085115554866e+231, 18, "379273243293860851", 232},
  {2.4709309323665397774302507e-199, 19, "2470930932366539777", -198},
  {2.5451688984608985394463583e+39, 6, "254517", 40},
  {2.8289024789600679976524348e+139, 14, "28289024789601", 140},
  {2.1536220815302805372040702e+210, 8, "21536221", 211},
  {4.6214959957453060557954522e+284, 3, "462", 285},
  {5.6006316709399149029836292e-73, 2, "56", -72},
  {1.0931788918552451502190997e+164, 17, "10931788918552452", 165},
  {1.3386650181979797774757023e-73, 13, "1338665018198", -72},
  {3.6853883497561157174206769e-91, 14, "36853883497561", -90},
  {3.1463160789477658126805449e-101, 13, "3146316078948", -100},
  {8.2816628956830933127586636e+172, 1, "8", 173},
  {2.0512231597012860334800756e-149, 8, "20512232", -148},
  {3.3514821662819000365373604e-30, 9, "335148217", -29},
  {9.8229651889892383339894664e-66, 7, "9822965", -65},
  {7.8389525385386698876263404e+169, 17, "78389525385386699", 170},
  {2.2903850834317041672360359e-138, 12, "229038508343", -137},
  {2.0527391780612938395639300e+280, 10, "2052739178", 281},
  {4.3594612267031042434509159e+215, 6, "435946", 216},
  {3.1611433172698302479559716e+232, 21, "316114331726983024796", 233},
  {2.1012402361838868454216234e+155, 6, "210124", 156},
  {1.7061182529880283395167028e-235, 21, "170611825298802833952", -234},
  {7.3915504391607329475545388e-205, 1, "7", -204},
  {2.0946342262021075001197789e+223, 19, "20946342262021075", 224},
  {1.4559981439095044564581527e-264, 16, "1455998143909504", -263},
  {7.6263083855524337291717529e+08, 12, "762630838555", 9},
  {5.8329126894314503733948956e+228, 14, "58329126894315", 229},
  {1.4127173219382476169805824e+25, 10, "1412717322", 26},
  {2.1393655099121028637581798e-23, 1, "2", -22},
  {2.3895536178018350724731373e-282, 5, "23896", -281},
  {2.4919115522926722679779762e-127, 1, "2", -126},
  {1.7269580152748719191019424e+51, 4, "1727", 52},
  {2.8706279717513114263940961e-272, 5, "28706", -271},
  {1.4621827775080143486505553e+154, 6, "146218", 155},
  {2.1912108993202173304601321e-47, 11, "21912108993", -46},
  {3.2505444692653594539405725e+55, 7, "3250544", 56},
  {6.0823281028400195515793618e-257, 14, "608232810284", -256},
  {3.3826191632975790636900884e+303, 3, "338", 304},
  {1.1937444460241971943923466e-188, 20, "11937444460241971944", -187},
  {3.1989877268590498549944596e+256, 9, "319898773", 257},
  {2.2142749652457430143143789e-67, 19, "2214274965245743014", -66},
  {1.0519157856953072975965179e-110, 8, "10519158", -109},
  {1.0209776231448441032487742e+96, 14, "10209776231448", 97},
  {2.0074129798703401655654862e-69, 10, "200741298", -68},
  {1.7344586661870908232831901e+53, 1, "2", 54},
  {3.9166847376991182430222668e+46, 7, "3916685", 47},
  {1.5786978025486564915696256e-206, 5, "15787", -205},
  {7.0441593750486099373860720e-167, 3, "704", -166},
  {7.1878708641130612962398736e-253, 9, "718787086", -252},
  {1.3296611428101747277960201e-234, 19, "1329661142810174728", -233},
  {6.6165879016950899837752576e+206, 10, "6616587902", 207},
  {5.6290303625767546325280268e+233, 10, "5629030363", 234},
  {1.7040378599254184506724309e+246, 20, "17040378599254184507", 247},
  {6.9501497778690431627732703e-199, 12, "695014977787", -198},
  {1.0013285791873382823305037e-297, 21, "100132857918733828233", -296},
  {8.7588507244831973674750517e-219, 11, "87588507245", -218},
  {7.7833254400229073948134215e+253, 5, "77833", 254},
  {1.9778222572284345885342589e-234, 13, "1977822257228", -233},
  {2.0410053384907604926129383e+185, 13, "2041005338491", 186},
  {1.0276583434810734167700032e+133, 12, "102765834348", 134},
  {2.1667013832906076834132345e-279, 9, "216670138", -278},
  {8.5856199345218714923025824e+94, 9, "858561993", 95},
  {5.1938597975026010077281793e-126, 13, "5193859797503", -125},
  {9.0952072499305343613097049e+291, 3, "91", 292},
  {1.8061793224272805223503189e-230, 15, "180617932242728", -229},
  {5.4229004041005354094034862e-145, 16, "5422900404100535", -144},
  {1.6549648916000649583751104e+178, 11, "16549648916", 179},
  {5.9670973597522316908861579e+280, 19, "5967097359752231691", 281},
  {1.5140873403729204221549237e-207, 5, "15141", -206},
  {1.8684369437386166498193924e+190, 10, "1868436944", 191},
  {4.7351423833857106301597165e+205, 14, "47351423833857", 206},
  {1.9794184786315392398578164e-44, 9, "197941848", -43},
  {5.9928685153760894214085005e-296, 9, "599286852", -295},
  {6.2235228425695708428701634e-45, 2, "62", -44},
  {1.3412618129614882396075382e+88, 3, "134", 89},
  {9.4099767501629958822736770e-36, 20, "94099767501629958823", -35},
  {2.2139745046203547898623169e-27, 20, "22139745046203547899", -26},
  {2.1290045612459986652462152e-04, 10, "2129004561", -3},
  {1.3550312402370520206899583e-247, 3, "136", -246},
  {7.1362430709797409281803361e+299, 16, "7136243070979741", 300},
  {1.2005859055105373666409397e+67, 9, "120058591", 68},
  {7.1996414166414091280297580e-70, 4, "72", -69},
  {8.0665312968677098180359871e-228, 1, "8", -227},
  {8.9942102303879526381510504e-58, 3, "899", -57},
  {6.3403377797914093646506775e+224, 2, "63", 225},
  {1.2724692677739081943741889e-276, 19, "1272469267773908194", -275},
  {9.8657097166895431097717265e-190, 1, "1", -188},
  {2.9687882551960422215882103e-68, 17, "29687882551960422", -67},
  {3.8767194840443355711556672e-138, 2, "39", -137},
  {2.3411724833178476245475219e-138, 15, "234117248331785", -137},
  {7.4910235946014872325810284e-295, 7, "7491024", -294},
  {9.2688499180092403057850897e+187, 1, "9", 188},
  {5.4328531225601363812289679e-19, 8, "54328531", -18},
  {4.0322459613366247424476751e-143, 1, "4", -142},
  {3.7514628047310781544521063e-02, 3, "375", -1},
  {5.9902511340546985009043633e-150, 7, "5990251", -149},
  {3.8953859976874583536234595e-56, 14, "38953859976875", -55},
  {1.7829506131071532089475472e+144, 19, "1782950613107153209", 145},
  {3.1622993931233562928924176e-127, 8, "31622994", -126},
  {3.0292826207644784000000000e+16, 18, "30292826207644784", 17},
  {9.3687918399302161726816879e+53, 11, "93687918399", 54},
  {1.3092122168110622880964408e+64, 11, "13092122168", 65},
  {4.7296243123368358789180797e+307, 14, "47296243123368", 308},
  {7.6938117739206175130134774e+27, 10, "7693811774", 28},
  {8.7578731372331195482118180e-80, 11, "87578731372", -79},
  {4.4263455829484744390248823e-204, 18, "442634558294847444", -203},
  {3.9368724981885623175527916e+186, 12, "393687249819", 187},
  {5.9672848587126756942943950e-307, 18, "596728485871267569", -306},
  {1.3389940703285749722330106e+43, 13, "1338994070329", 44},
  {6.2085559383496074931136189e+190, 2, "62", 191},
  {4.5884913205079296613053080e-154, 12, "458849132051", -153},
  {3.7526343715725597633842789e+264, 18, "375263437157255976", 265},
  {9.7623922055160211597168995e-02, 3, "976", -1},
  {1.6431955408631879981798883e+51, 15, "164319554086319", 52},
  {3.8134833397413703036154647e+116, 10, "381348334", 117},
  {6.1196611556730929199388203e+84, 12, "611966115567", 85},
  {1.3113604076417980174711818e+296, 7, "131136", 297},
  {1.7639231071506423627076410e-68, 3, "176", -67},
  {3.0180409365816055385902225e-269, 15, "301804093658161", -268},
  {2.6062754257930285820253564e-275, 6, "260628", -274},
  {6.9178609531665827023659897e+276, 3, "692", 277},
  {3.5406699992214302689765832e+199, 5, "35407", 200},
  {1.9765347705080114974890929e+185, 7, "1976535", 186},
  {5.9771821459141793912016662e+32, 15, "597718214591418", 33},
  {1.4508901234736993949002254e-212, 10, "1450890123", -211},
  {5.6952975687989905057811015e-285, 7, "5695298", -284},
  {1.3081984013153565157231567e-05, 16, "1308198401315357", -4},
  {3.8695829705224873930743514e-74, 17, "38695829705224874", -73},
  {1.9132045135205150771976232e-180, 9, "191320451", -179},
  {2.0330566621535969550864530e-301, 9, "203305666", -300},
  {1.0308474674472746724131609e-241, 6, "103085", -240},
  {8.2487862669257536532512107e+175, 20, "82487862669257536533", 176},
  {1.1558287457177415972015580e-142, 2, "12", -141},
  {8.8740426115265558646142551e+191, 5, "8874", 192},
  {4.1029372619382704104158225e-163, 13, "4102937261938", -162},
  {2.4883455338090072584421583e+165, 18, "248834553380900726", 166},
  {2.2470716968890333529439429e-185, 1, "2", -184},
  {4.2586511173416593539581239e-196, 14, "42586511173417", -195},
  {1.9077286607246668915344177e-94, 5, "19077", -93},
  {5.9909099173684979354470147e+288, 19, "5990909917368497935", 289},
  {3.3591861237883463075205641e-86, 7, "3359186", -85},
  {3.8459071845766209949295261e-160, 2, "38", -159},
  {1.5744853110600323830524352e+271, 3, "157", 272},
  {3.6750633723456549279194967e-245, 2, "37", -244},
  {2.1020808314318948461757083e-187, 8, "21020808", -186},
  {2.4841498543543250831110421e+182, 12, "248414985435", 183},
  {3.1262719376789422166674532e+109, 8, "31262719", 110},
  {7.1108001818933334523079580e+84, 19, "7110800181893333452", 85},
  {1.3056469040910958409974251e-45, 17, "13056469040910958", -44},
  {5.0547968366439830727776922e+214, 8, "50547968", 215},
  {1.3913811918975179626983656e-05, 16, "1391381191897518", -4},
  {1.2803682754519620636040374e-112, 19, "1280368275451962064", -111},
  {1.0968759861282586488046236e+111, 1, "1", 112},
  {1.0900921522137638283387252e+213, 12, "109009215221", 214},
  {1.5732335489289065379201722e+282, 11, "15732335489", 283},
  {1.3054244330052960461882144e+163, 20, "13054244330052960462", 164},
  {2.3365502051973392907840919e-191, 21, "233655020519733929078", -190},
  {2.9506269070669347147980344e+152, 2, "3", 153},
  {6.7359664748858391763529270e+286, 15, "673596647488584", 287},
  {2.2938394144325405626378226e+48, 11, "22938394144", 49},
  {3.4422954357922951399579015e-105, 8, "34422954", -104},
  {2.7358389200376432858495461e+256, 21, "273583892003764328585", 257},
  {3.0932465856553431530015498e-175, 21, "3093246585655343153", -174},
  {3.3925068912624311830234662e+224, 1, "3", 225},
  {6.6358244451965841015520437e+197, 10, "6635824445", 198},
  {6.0691934558287716745878969e+229, 21, "606919345582877167459", 230},
  {3.5806747863039193578607139e-207, 14, "35806747863039", -206},
  {8.3324800611449462215351651e-172, 9, "833248006", -171},
  {5.8458446745674721367902887e+297, 21, "584584467456747213679", 298},
  {3.4871537716212980396744185e+68, 18, "348715377162129804", 69},
  {7.1680736177944819926851103e+115, 4, "7168", 116},
  {2.4015754408759502183936709e-270, 20, "24015754408759502184", -269},
  {1.8109607948185894912966911e-127, 20, "18109607948185894913", -126},
  {2.2027482078570076550094239e-37, 1, "2", -36},
  {2.1412256876135842881725161e+43, 5, "21412", 44},
  {7.4662644296948816455544978e+266, 16, "7466264429694882", 267},
  {7.3627990142423726561079656e-149, 20, "73627990142423726561", -148},
  {2.9102034693205535773065586e+170, 1, "3", 171},
  {4.4183794865699120101954609e-161, 16, "4418379486569912", -160},
  {1.3772478651053157746947801e-99, 2, "14", -98},
  {1.9040603552165374064374670e+239, 15, "190406035521654", 240},
  {2.3309174994037102644952723e-257, 7, "2330917", -256},
  {4.7001595488108251558613493e+57, 16, "4700159548810825", 58},
  {5.2141226851832233949643585e+151, 18, "521412268518322339", 152},
  {7.3251306454518289458057332e+138, 15, "732513064545183", 139},
  {2.8540858461763354884459532e+270, 7, "2854086", 271},
  {8.7293596675417021870732975e+228, 6, "872936", 229},
  {1.7315289293735084311618756e-105, 5, "17315", -104},
  {8.8792704325296432294839628e-121, 4, "8879", -120},
  {1.7819928687936472146301973e+167, 19, "1781992868793647215", 168},
  {4.0524637151844808604027251e+258, 21, "40524637151844808604", 259},
  {1.1893411527546664319885345e-184, 3, "119", -183},
  {4.6287623662255156900015395e-58, 19, "462876236622551569", -57},
  {2.7863908086965784873120701e+86, 8, "27863908", 87},
  {3.3761890762053623150587446e-45, 9, "337618908", -44},
  {2.4277808496546348184090395e-118, 15, "242778084965463", -117},
  {8.1833432232728380859929475e+247, 21, "818334322327283808599", 248},
  {1.2312454390916835910393731e+213, 20, "1231245439091683591", 214},
  {1.0091328265086179609262896e-218, 12, "100913282651", -217},
  {1.7696776074848674376489880e-52, 19, "1769677607484867438", -51},
  {1.1909558587642182631527764e+224, 6, "119096", 225},
  {1.4146677835874101995417884e+30, 3, "141", 31},
  {3.7005899039165318568784924e-249, 7, "370059", -248},
  {7.9829795711598751006128288e-208, 15, "798297957115988", -207},
  {4.5230596173266898289055665e-293, 21, "452305961732668982891", -292},
  {2.0258694403215063796433415e-238, 10, "202586944", -237},
  {1.2293385893018079044288226e-199, 16, "1229338589301808", -198},
  {8.4029192508966011042434771e-94, 12, "84029192509", -93},
  {9.3000372141793966407546130e+155, 13, "9300037214179", 156},
  {2.6251718710229967384036125e+49, 5, "26252", 50},
  {1.7764812126982377092461100e+159, 14, "17764812126982", 160},
  {1.1480706813903055969915630e+96, 21, "114807068139030559699", 97},
  {1.3801535634211201442080039e+163, 17, "13801535634211201", 164},
  {1.9429182739586538833498830e+294, 7, "1942918", 295},
  {5.6614329755229244232177734e+09, 12, "566143297552", 10},
  {6.1502637658925939553868937e+165, 1, "6", 166},
  {4.9343608879241624322279032e+89, 6, "493436", 90},
  {9.0044275705200915664984074e-134, 18, "900442757052009157", -133},
  {6.0042358623712897251689530e-53, 21, "600423586237128972517", -52},
  {2.7867031248060757481622126e-134, 20, "27867031248060757482", -133},
  {3.0331241456543283685561151e+35, 9, "303312415", 36},
  {1.0657886565166534590876053e+197, 7, "1065789", 198},
  {2.2734676551283022468812448e+145, 14, "22734676551283", 146},
  {3.3688235910473132366681925e-276, 15, "336882359104731", -275},
  {5.8884551412782959545743378e-165, 1, "6", -164},
  {8.8594176585973256820407400e+215, 16, "8859417658597326", 216},
  {1.0853499623427537633280000e+21, 11, "10853499623", 22},
  {2.3134396745979501127844129e-131, 11, "23134396746", -130},
  {6.3147153013555692181739166e+282, 14, "63147153013556", 283},
  {2.1876391032525059082177089e+52, 17, "21876391032525059", 53},
  {3.6885117802694351972758680e+56, 8, "36885118", 57},
  {3.1739523729958813268906866e-135, 17, "31739523729958813", -134},
  {1.2334318669555472395118086e+172, 17, "12334318669555472", 173},
  {4.0864130440785709239793351e+71, 4, "4086", 72},
  {3.1203665731345143101396687e-116, 7, "3120367", -115},
  {4.9373462094941589519209263e-272, 8, "49373462", -271},
  {8.4050152496422105312707830e-228, 21, "840501524964221053127", -227},
  {7.9651282761407083602752458e+132, 4, "7965", 133},
  {6.1114710973635195046066576e+65, 19, "6111471097363519505", 66},
  {2.6751019581895515972644566e-260, 19, "2675101958189551597", -259},
  {3.3588182106120900207400923e-144, 19, "3358818210612090021", -143},
  {9.2371718982866243283064987e+125, 6, "923717", 126},
  {3.4074247402174666448020359e+142, 9, "340742474", 143},
  {1.4758097053639679443425218e-196, 20, "14758097053639679443", -195},
  {9.7841818983474131673574448e+06, 16, "9784181898347413", 7},
  {2.8649915452097808449665146e-79, 15, "286499154520978", -78},
  {1.3186146201054999225636481e+273, 16, "13186146201055", 274},
  {2.7219156283522347711322399e-18, 3, "272", -17},
  {1.8047298176620656320569980e+124, 21, "180472981766206563206", 125},
  {8.5068742483711370873689391e+275, 15, "850687424837114", 276},
  {1.2128337963574265374939316e+83, 16, "1212833796357427", 84},
  {4.9666909262661833938768063e-198, 19, "4966690926266183394", -197},
  {7.4013994257138996252694876e-269, 12, "740139942571", -268},
  {1.0153962160454950044462841e-27, 2, "1", -26},
  {6.7652145997020487068395274e+162, 11, "67652145997", 163},
  {3.9365785764577550279134362e+208, 7, "3936579", 209},
  {7.2570882114666467235887944e-127, 2, "73", -126},
  {2.6986580337056949067226575e-295, 7, "2698658", -294},
  {4.8123379434255865449028406e+114, 1, "5", 115},
  {3.4917929817173624000000000e+16, 10, "3491792982", 17},
  {6.3769329491719724345044335e-153, 17, "63769329491719724", -152},
  {2.0403538494264807285741951e+192, 9, "204035385", 193},
  {2.0731109103905332160778002e+71, 16, "2073110910390533", 72},
  {3.8432490547365671774527777e+148, 1, "4", 149},
  {4.8145378456078665101359717e-147, 4, "4815", -146},
  {7.1278411959109902736569143e+220, 6, "712784", 221},
  {6.4041451991233779764309845e+196, 6, "640415", 197},
  {4.8761903861817628145217896e+08, 7, "487619", 9},
  {2.7269086779709655389424124e+175, 7, "2726909", 176},
  {8.9149170539389901082118268e+251, 17, "89149170539389901", 252},
  {3.1038798298194964116942627e-232, 10, "310387983", -231},
  {2.6084447110959431595435141e+122, 13, "2608444711096", 123},
  {1.0685318273026229094589185e+106, 3, "107", 107},
  {4.1812120164859976848655372e+85, 18, "418121201648599768", 86},
  {4.1660625942965942010619947e+80, 2, "42", 81},
  {1.0729682834967067096397640e-159, 8, "10729683", -158},
  {2.7693128825915546364731261e-287, 14, "27693128825916", -286},
  {4.6071800589518170888765186e+264, 8, "46071801", 265},
  {1.3171808594636898725931783e-260, 5, "13172", -259},
  {2.9922378545345407010299339e-288, 18, "29922378545345407", -287},
  {5.1775876823284890246959803e+288, 7, "5177588", 289},
  {1.7324261156722143587583415e-222, 13, "1732426115672", -221},
  {1.2918384950081360526756518e+92, 10, "1291838495", 93},
  {1.0454782329714767698391843e-55, 10, "1045478233", -54},
  {9.8690737296911215392022475e+235, 6, "986907", 236},
  {1.2196392865898727632113793e-214, 18, "121963928658987276", -213},
  {1.1191360312754570883972925e+113, 7, "1119136", 114},
  {6.2794211329954100252610198e+239, 17, "627942113299541", 240},
  {6.7164608777608102421475171e-127, 20, "67164608777608102421", -126},
  {2.7499503790168637328425813e-174, 12, "274995037902", -173},
  {2.6602513901473142852925977e+81, 14, "26602513901473", 82},
  {5.1752427620336619029650649e-02, 4, "5175", -1},
  {2.4425294563334145791373203e-297, 17, "24425294563334146", -296},
  {2.0519900784664438275054572e+189, 4, "2052", 190},
  {1.9585491607377590353920000e+21, 19, "1958549160737759035", 22},
  {1.4730769164918829194154437e+81, 1, "1", 82},
  {1.1691027304987849792071246e+152, 8, "11691027", 153},
  {7.0137714861526473116453581e+116, 10, "7013771486", 117},
  {4.3350628366459679286697605e-72, 8, "43350628", -71},
  {2.4980058222253916255795048e+01, 5, "2498", 2},
  {7.7862876284742206305076823e+128, 1, "8", 129},
  {1.4795557466645801023708441e+248, 16, "147955574666458", 249},
  {9.9676411951558044433593750e+11, 9, "99676412", 12},
  {3.0340217177500878901303207e+223, 14, "30340217177501", 224},
  {9.4716265075060489572706092e+269, 10, "9471626508", 270},
  {3.0353787986449037039672547e-270, 8, "30353788", -269},
  {1.5868692234470733072193145e+285, 15, "158686922344707", 286},
  {9.1463451714542161002770022e+258, 1, "9", 259},
  {1.3644317078045845431818952e+294, 20, "13644317078045845432", 295},
  {3.2430415463137298702394985e-277, 21, "324304154631372987024", -276},
  {4.1623842205280247908179114e+70, 15, "416238422052802", 71},
  {1.9892623242924396421261510e-43, 14, "19892623242924", -42},
  {9.8474445513338575842023271e+97, 5, "98474", 98},
  {1.1333809177160034179687500e+11, 3, "113", 12},
  {1.2290072295023919787697485e+214, 15, "122900722950239", 215},
  {9.0800393423197628264452819e+185, 1, "9", 186},
  {5.0700809286841229381523659e+70, 21, "507008092868412293815", 71},
  {3.5773920178602056250000000e+14, 1, "4", 15},
  {7.5394111061344996474815159e+134, 1, "8", 135},
  {2.7763792723662392934720303e+225, 15, "277637927236624", 226},
  {2.6224958700665529636834000e-40, 1, "3", -39},
  {2.6880007944107824244108679e+194, 14, "26880007944108", 195},
  {6.2312091547476859128091532e+254, 15, "623120915474769", 255},
  {6.6772284363203357019350126e-212, 3, "668", -211},
  {1.2821798710686270481611542e-39, 11, "12821798711", -38},
  {9.5462532064676604466602061e-04, 2, "95", -3},
  {7.3336166301977805239054763e-43, 4, "7334", -42},
  {2.0309182349618632938978645e+218, 3, "203", 219},
  {2.0936599151941593819445190e-11, 6, "209366", -10},
  {2.0608304896045659512878855e-293, 12, "20608304896", -292},
  {3.8812160663419805650541416e-90, 15, "388121606634198", -89},
  {6.2445719173453208458145773e-184, 9, "624457192", -183},
  {7.5070970509322786957177588e+282, 9, "750709705", 283},
  {2.5124402717910658433907909e+194, 12, "251244027179", 195},
  {9.8606317702564487617383863e-67, 15, "986063177025645", -66},
  {1.3422511432641297682868536e-33, 17, "13422511432641298", -32},
  {1.6098319892955663664815810e+299, 4, "161", 300},
  {4.8737837578543232901011115e+91, 9, "487378376", 92},
  {3.9794318209734745427453484e-205, 21, "397943182097347454275", -204},
  {3.2811774067781134379790700e-172, 17, "32811774067781134", -171},
  {5.0108314888697756172433774e-125, 5, "50108", -124},
  {1.3229166639789985000000000e+15, 10, "1322916664", 16},
  {2.9650747547303585275803898e-27, 12, "296507475473", -26},
  {7.6750840834278608284679273e+293, 16, "7675084083427861", 294},
  {2.9650536256316498301531234e-97, 14, "29650536256316", -96},
  {3.0583065804139673131082323e+111, 7, "3058307", 112},
  {3.1777828243293592010779105e+206, 3, "318", 207},
  {1.4098694377846144435332504e-292, 3, "141", -291},
  {2.0023217768822735076814271e+211, 6, "200232", 212},
  {4.8278469082402091405545984e-269, 14, "48278469082402", -268},
  {3.8801743833313577025682966e-134, 2, "39", -133},
  {5.6596382970279518236517056e+34, 10, "5659638297", 35},
  {1.3007795667911320255682812e+76, 1, "1", 77},
  {6.7292859990322122126965655e+265, 6, "672929", 266},
  {2.9303397058269387024055277e+77, 18, "29303397058269387", 78},
  {2.2364803624503893750000000e+14, 3, "224", 15},
  {6.7323461373576913047145354e+02, 3, "673", 3},
  {9.1732320850197391432324115e-300, 17, "91732320850197391", -299},
  {1.4483653029878150482992689e+78, 4, "1448", 79},
  {3.3031545316455279936583274e+126, 13, "3303154531646", 127},
  {2.6282640957716965962037578e+286, 1, "3", 287},
  {7.2634590610355956782201412e-210, 9, "726345906", -209},
  {5.6328377838413853044166335e+196, 17, "56328377838413853", 197},
  {1.7334866284177539155508680e-177, 19, "1733486628417753916", -176},
  {5.1962790284346284916148443e-113, 9, "519627903", -112},
  {7.2653042865389842735756044e-166, 5, "72653", -165},
  {2.9912923412894889870464156e-21, 5, "29913", -20},
  {5.0044478008004007581002279e-190, 16, "5004447800800401", -189},
  {6.8046058558916909284361551e+300, 6, "680461", 301},
  {2.4541328089840527658272060e+237, 13, "2454132808984", 238},
  {9.3509316958976065459019126e-287, 10, "9350931696", -286},
  {3.4945105469868473145124700e-291, 8, "34945105", -290},
  {1.1598714875204269068926257e+254, 16, "1159871487520427", 255},
  {2.2856772004715935087829233e+161, 10, "22856772", 162},
  {5.4105654004428835260474211e-269, 15, "541056540044288", -268},
  {1.1218827647293716011884756e-70, 14, "11218827647294", -69},
  {2.3398494100790949889792292e-287, 6, "233985", -286},
  {5.1615483339203278292920717e+157, 18, "516154833392032783", 158},
  {1.5666392103406787693633791e-166, 3, "157", -165},
  {3.2860848010124020096163179e-73, 9, "32860848", -72},
  {1.6201200030251923213929839e-37, 8, "162012", -36},
  {8.4988376393712367903699341e-307, 7, "8498838", -306},
  {2.9422622759500405633051989e+203, 6, "294226", 204},
  {5.6865620636866370473975568e-08, 9, "568656206", -7},
  {3.9883566433430721380983971e+132, 4, "3988", 133},
  {3.6968499322362772246893692e-289, 2, "37", -288},
  {4.9858992071637750244140625e+11, 12, "498589920716", 12},
  {8.7688554277636046617873554e+203, 18, "876885542776360466", 204},
  {3.9527319665158022163246022e-13, 5, "39527", -12},
  {4.6681722930003839135334884e+219, 3, "467", 220},
  {6.3697443804203628625920000e+21, 2, "64", 22},
  {3.4875373748590438700239440e-209, 3, "349", -208},
  {2.0987877195322656025260382e-246, 9, "209878772", -245},
  {4.6142132647093156648943547e-145, 1, "5", -144},
  {2.2828226297421544160577214e+281, 1, "2", 282},
  {1.5215216872796223997686908e-77, 6, "152152", -76},
  {3.0439135278479687401898978e-211, 7, "3043914", -210},
  {3.6489198395651085329442075e+89, 10, "364891984", 90},
  {1.7853395719655365931034338e-121, 17, "17853395719655366", -120},
  {4.7170768937646924979722410e-130, 19, "4717076893764692498", -129},
  {2.2688985836049022488473839e+83, 5, "22689", 84},
  {1.0539573659430141108811599e+114, 8, "10539574", 115},
  {9.8291371868521930887173391e-265, 11, "98291371869", -264},
  {3.9444661754540272713395898e-137, 4, "3944", -136},
  {7.4225299370413165228372806e+265, 10, "7422529937", 266},
  {3.4284723274671211303260346e-260, 16, "3428472327467121", -259},
  {3.0520752504627569518508221e+68, 18, "305207525046275695", 69},
  {5.6234420582232884433441736e-68, 4, "5623", -67},
  {1.5825173033645830438739937e+44, 8, "15825173", 45},
  {5.9820210471002012368311009e+214, 19, "5982021047100201237", 215},
  {1.4602256206319996360998888e-211, 5, "14602", -210},
  {1.1393507409279643692311555e+200, 10, "1139350741", 201},
  {4.9843484955341446360872905e-175, 16, "4984348495534145", -174},
  {1.8920030074960656666916916e-28, 2, "19", -27},
  {7.9694832265606387048435827e-299, 15, "796948322656064", -298},
  {4.7087284612697270831013245e-25, 14, "47087284612697", -24},
  {2.3510630251958364303500802e+236, 4, "2351", 237},
  {3.5148984359015208019754723e+265, 10, "3514898436", 266},
  {1.1255680480983606238713604e+43, 21, "112556804809836062387", 44},
  {2.7863981970390627366030049e+136, 13, "2786398197039", 137},
  {9.2506096188003576676256552e-136, 13, "92506096188", -135},
  {3.9452168221486910906891539e+274, 4, "3945", 275},
  {7.8978813266593510471034544e-211, 12, "789788132666", -210},
  {5.9595114437106827699420242e+229, 6, "595951", 230},
  {4.8594265825806576932195656e+242, 16, "4859426582580658", 243},
  {1.1499569720718708630323794e+247, 1, "1", 248},
  {1.5237654903457413156929546e-105, 4, "1524", -104},
  {4.4277831892125333132384699e+254, 11, "44277831892", 255},
  {4.9896490283587045269086957e+03, 1, "5", 4},
  {3.1169331536263823394958699e-202, 4, "3117", -201},
  {3.6209146791184365436080564e+233, 3, "362", 234},
  {9.2848169863548795625574414e-276, 16, "928481698635488", -275},
  {1.4009947838356498975455034e-259, 17, "14009947838356499", -258},
  {8.3237305698166439205794040e-186, 10, "832373057", -185},
  {5.0486962064190244518745275e+208, 4, "5049", 209},
  {5.9169998132069720465531895e+281, 3, "592", 282},
  {5.9683928136029336521808273e+255, 13, "5968392813603", 256},
  {1.5306536812585911544663976e-75, 8, "15306537", -74},
  {1.8938818641720344781824437e-04, 20, "18938818641720344782", -3},
  {1.7797832920686008672357126e-187, 3, "178", -186},
  {4.6895660201297057792544365e+06, 6, "468957", 7},
  {2.2385716044498255484880089e-32, 1, "2", -31},
  {4.8690965153482206427261697e-294, 16, "4869096515348221", -293},
  {1.0350215674206797137479316e+115, 1, "1", 116},
  {6.1230095152501061354793649e+267, 21, "612300951525010613548", 268},
  {1.4976534557081649098761326e+113, 18, "149765345570816491", 114},
  {1.3637969103948671783083539e-189, 17, "13637969103948672", -188},
  {1.4740942304661503177064656e-84, 13, "1474094230466", -83},
  {2.5520611407918935197359521e-122, 8, "25520611", -121},
  {8.3923451267281636540666066e-98, 4, "8392", -97},
  {2.0722198532419380293481287e+179, 5, "20722", 180},
  {2.7733331917232846462595018e+220, 14, "27733331917233", 221},
  {4.8103723352436966381103115e+44, 21, "481037233524369663811", 45},
  {4.2083061865351656913978251e-137, 17, "42083061865351657", -136},
  {9.7777120003074178181398053e-294, 4, "9778", -293},
  {3.2959831869772623949897780e-226, 6, "329598", -225},
  {1.3545550062474956146092670e+113, 19, "1354555006247495615", 114},
  {1.5167736564041175970226394e+127, 12, "15167736564", 128},
  {3.3820578365255831662950175e+97, 5, "33821", 98},
  {6.3115607538452157909824700e-279, 20, "6311560753845215791", -278},
  {2.1977033439452863472588481e+43, 19, "2197703343945286347", 44},
  {8.3497321727991842455939537e+301, 15, "834973217279918", 302},
  {8.5718619769129425062891076e+271, 5, "85719", 272},
  {1.1694280050544142256096973e+158, 4, "1169", 159},
  {8.9716189223669499078825419e+195, 21, "897161892236694990788", 196},
  {3.8060692527664180338244895e-124, 4, "3806", -123},
  {2.5122428196211735411174062e+295, 10, "251224282", 296},
  {4.5002051764245904201739062e+263, 8, "45002052", 264},
  {8.8586885147581254887173835e+50, 19, "8858688514758125489", 51},
  {6.4333004116926944789408114e-85, 21, "643330041169269447894", -84},
  {7.6920385550909722555175781e-95, 6, "769204", -94},
  {1.2539254466238131072361151e+205, 10, "1253925447", 206},
  {1.7247579153427282071476594e+222, 1, "2", 223},
  {1.9685638932912226013510289e-26, 18, "19685638932912226", -25},
  {5.9302736189127193545118035e+147, 11, "59302736189", 148},
  {4.1099975530082601939983123e-109, 7, "4109998", -108},
  {1.5402108440615434776297463e+240, 6, "154021", 241},
  {9.4521865307267499873866526e-252, 8, "94521865", -251},
  {9.4561715357335413709454407e-268, 11, "94561715357", -267},
  {1.6411257135696165321950538e+161, 7, "1641126", 162},
  {6.7587845766280704944027045e+84, 4, "6759", 85},
  {4.5920170241917176236660650e-301, 5, "4592", -300},
  {1.6154864533756556587908187e+128, 18, "161548645337565566", 129},
  {1.8674507622675785605041640e+131, 2, "19", 132},
  {7.6797403295972162855676919e-288, 1, "8", -287},
  {5.7910574556254838242862723e-39, 9, "579105746", -38},
  {3.9648233311540374323298802e-162, 5, "39648", -161},
  {7.7729421699450726703924498e+205, 20, "77729421699450726704", 206},
  {1.0963111074357789084172705e+150, 9, "109631111", 151},
  {2.3969972573961601236797073e+148, 13, "2396997257396", 149},
  {5.3324569454960190362033831e-118, 14, "5332456945496", -117},
  {2.1221882746492118315380208e-70, 10, "2122188275", -69},
  {1.4946544768676155400130115e-63, 6, "149465", -62},
  {2.2544003363139159927757914e+164, 12, "225440033631", 165},
  {1.5396013206736170714297635e+41, 6, "15396", 42},
  {7.8975552100469640429402650e-151, 1, "8", -150},
  {2.1180325107815227990531731e-275, 13, "2118032510782", -274},
  {2.1377802979881346461295085e-294, 2, "21", -293},
  {1.3794539588770607249878585e+217, 9, "137945396", 218},
  {1.4179557355394508800000000e+18, 2, "14", 19},
  {6.5166783238469437662611593e-207, 9, "651667832", -206},
  {1.7799731146928520498162241e+307, 11, "17799731147", 308},
  {9.0930526122130539689008399e+42, 19, "9093052612213053969", 43},
  {4.9291989025998232483554878e+37, 9, "49291989", 38},
  {6.3274420150984072795738119e-218, 14, "63274420150984", -217},
  {7.0320763854265345687951082e-35, 21, "70320763854265345688", -34},
  {1.6000870706941787508704397e-162, 17, "16000870706941788", -161},
  {6.1057851126149227100278237e+111, 7, "6105785", 112},
  {2.5209627599432578686956352e-267, 7, "2520963", -266},
  {3.6430388045193346331890050e+105, 19, "3643038804519334633", 106},
  {7.0180399567607716998354141e-305, 9, "701803996", -304},
  {1.6395990562090924534517275e-189, 15, "163959905620909", -188},
  {6.1467571333055710604256463e-272, 5, "61468", -271},
  {6.9304875804896867299862193e+278, 7, "6930488", 279},
  {1.6620012466318893873667720e+31, 14, "16620012466319", 32},
  {1.3017631491695682536490465e+53, 2, "13", 54},
  {1.3130232787757630069323058e+294, 17, "1313023278775763", 295},
  {4.4362743377807205186017388e+71, 3, "444", 72},
  {1.5570457717239342123599079e+233, 8, "15570458", 234},
  {6.9221642974558611888042731e+31, 6, "692216", 32},
  {3.3813356331097983384398433e+91, 20, "33813356331097983384", 92},
  {6.1353714013691297288498345e+274, 18, "613537140136912973", 275},
  {8.4091362019689430872212626e-227, 15, "840913620196894", -226},
  {1.9282847497885428022661988e-75, 12, "192828474979", -74},
  {1.4266507280393219127066890e+273, 4, "1427", 274},
  {8.0661557017496016222455582e-277, 17, "80661557017496016", -276},
  {6.7370995950629652817407239e-113, 11, "67370995951", -112},
  {1.1561940042463733815683767e+132, 13, "1156194004246", 133},
  {1.3555779245055880606279399e-151, 13, "1355577924506", -150},
  {1.4889952985988409572353227e+88, 16, "1488995298598841", 89},
  {3.1349553384838479933362011e-200, 8, "31349553", -199},
  {7.3826099495836766436696053e+06, 7, "738261", 7},
  {9.3176875668583283235679691e+290, 21, "931768756685832832357", 291},
  {2.3719331546088870130495179e-83, 20, "2371933154608887013", -82},
  {2.6022621697140277693734067e+103, 2, "26", 104},
  {7.2701091858761616688124520e-144, 16, "7270109185876162", -143},
  {2.8717112636244692516195120e-205, 3, "287", -204},
  {4.6075301628253648113654078e-46, 18, "460753016282536481", -45},
  {7.3910580589484918010800871e+264, 6, "739106", 265},
  {6.3674437025847771677538736e+31, 17, "63674437025847772", 32},
  {1.2145952119946884643756854e+125, 15, "121459521199469", 126},
  {3.5014270085724590561820247e-267, 13, "3501427008572", -266},
  {1.3393325326780489183247375e-263, 7, "1339333", -262},
  {7.9831950913540317637351816e+289, 9, "798319509", 290},
  {1.2179091806831314916271759e-98, 16, "1217909180683131", -97},
  {5.3210709809992312938065062e-04, 20, "53210709809992312938", -3},
  {4.3653706857838473667788064e-116, 1, "4", -115},
  {2.3230144190232383927982596e+269, 12, "232301441902", 270},
  {3.5450456849673861370320083e+02, 20, "3545045684967386137", 3},
  {1.0507113478506833692406852e+58, 9, "105071135", 59},
  {4.0178157637738182347847325e+164, 14, "40178157637738", 165},
  {4.2394555506200288452167930e+180, 20, "42394555506200288452", 181},
  {7.0627971754969759598392562e+126, 7, "7062797", 127},
  {5.5433281719593536931996377e-181, 17, "55433281719593537", -180},
  {8.3688202457294767317348333e-299, 19, "8368820245729476732", -298},
  {1.0442454458953616907419873e+266, 4, "1044", 267},
  {4.9606151894224932437817664e-61, 18, "496061518942249324", -60},
  {1.1117051897487607719433229e-204, 12, "111170518975", -203},
  {5.5117340831498549942868628e-135, 13, "551173408315", -134},
  {6.1319654746544876036596563e+153, 8, "61319655", 154},
  {8.2791975117285943396885227e-146, 16, "8279197511728594", -145},
  {1.1175423288788526050012051e-66, 15, "111754232887885", -65},
  {5.4584469007145823531341317e-54, 8, "54584469", -53},
  {1.7257554666917957830165329e+130, 15, "17257554666918", 131},
  {1.1615552084122877325835316e-48, 18, "116155520841228773", -47},
  {2.5129094532762703785230829e-04, 7, "2512909", -3},
  {8.5438930786084763136436187e+45, 18, "854389307860847631", 46},
  {2.6677853102818147871882633e-246, 4, "2668", -245},
  {3.0830962713308222022026099e-38, 15, "308309627133082", -37},
  {9.9507403342762736992705659e+79, 8, "99507403", 80},
  {7.8321671281233271484375000e+12, 15, "783216712812333", 13},
  {1.3337598002595192224076717e-228, 6, "133376", -227},
  {1.3121783996838329252286638e-280, 13, "1312178399684", -279},
  {5.3733903877858069098039095e-01, 2, "54", 0},
  {2.7592827987710306610602048e+81, 18, "275928279877103066", 82},
  {5.9488977012618129810451611e+188, 8, "59488977", 189},
  {1.3791533530159894531250000e+13, 3, "138", 14},
  {6.2079180690519836959579862e-96, 9, "620791807", -95},
  {6.5658871822410703202260809e+62, 19, "656588718224107032", 63},
  {9.3693502706593647482156328e-260, 1, "9", -259},
  {3.3774175020557047450917075e-128, 6, "337742", -127},
  {4.7968011431671970040798080e-144, 14, "47968011431672", -143},
  {3.4541798058905966120552119e-185, 20, "34541798058905966121", -184},
  {1.9371803057543964312649928e-99, 5, "19372", -98},
  {5.9075527654871287156426408e+29, 14, "59075527654871", 30},
  {4.3879896752019132801414523e-65, 5, "4388", -64},
  {1.6670312790397863954147001e-31, 11, "1667031279", -30},
  {1.9356871529069275227996032e+225, 6, "193569", 226},
  {6.4887515391216934372901222e+77, 18, "648875153912169344", 78},
  {2.4098290847879707065095724e+164, 16, "2409829084787971", 165},
  {3.7429433976152026938701134e-49, 15, "37429433976152", -48},
  {3.3893948705016622478175161e-31, 10, "3389394871", -30},
  {4.4446663586093186324942109e+185, 12, "444466635861", 186},
  {1.0564318138455937236020220e-208, 2, "11", -207},
  {1.0688785119276201132788991e+53, 6, "106888", 54},
  {1.9761983484129569046053521e-238, 7, "1976198", -237},
  {1.1667570670493826808853238e+50, 13, "1166757067049", 51},
  {1.2866712714393816105219165e+186, 13, "1286671271439", 187},
  {7.6645460450225476627070976e+25, 9, "766454605", 26},
  {3.3199628543264333265919224e+69, 17, "33199628543264333", 70},
  {1.2700078843262208447726793e+191, 21, "127000788432622084477", 192},
  {2.2651878650164451279066195e+141, 15, "226518786501645", 142},
  {3.8066692990305618356846200e+156, 6, "380667", 157},
  {1.5078276473506229222061490e-276, 20, "15078276473506229222", -275},
  {3.1046394259201599845955721e-156, 2, "31", -155},
  {4.6150607020588729130064524e+202, 12, "461506070206", 203},
  {1.1441561314492212705081040e-29, 10, "1144156131", -28},
  {3.3031256530171736672920382e-236, 16, "3303125653017174", -235},
  {9.5899335198985240577679456e+67, 14, "95899335198985", 68},
  {1.1385814245345906694695220e-224, 19, "1138581424534590669", -223},
  {2.5424833873464110612480000e+21, 7, "2542483", 22},
  {8.5245407608040941024499255e+214, 14, "85245407608041", 215},
  {5.4894554326601400119034119e+159, 14, "54894554326601", 160},
  {7.7750077706547294694064060e+136, 20, "77750077706547294694", 137},
  {3.4127786130865688927300900e-200, 3, "341", -199},
  {1.3496006168148365676551052e+139, 13, "1349600616815", 140},
  {4.7824692717237372741002233e+226, 19, "4782469271723737274", 227},
  {2.4478341434572034491319074e+165, 15, "24478341434572", 166},
  {3.3712935474106118241388548e+65, 4, "3371", 66},
  {2.5769394359355449780359879e+303, 3, "258", 304},
  {1.4190044069845412741379384e-264, 6, "1419", -263},
  {2.3169028759419819694814438e-90, 2, "23", -89},
  {1.3258745942362030582970505e+217, 20, "13258745942362030583", 218},
  {4.5707856436446185111769660e-85, 12, "457078564364", -84},
  {5.3887720949235630455802708e-152, 8, "53887721", -151},
  {1.6668224003482048954017828e+210, 21, "16668224003482048954", 211},
  {3.0912254840006606795485527e-151, 4, "3091", -150},
  {2.6491465031129812688875544e-140, 18, "264914650311298127", -139},
  {1.5736535290188047642220354e-47, 1, "2", -46},
  {2.2267666323971682503702156e+69, 17, "22267666323971683", 70},
  {1.6032632532417481202023671e+184, 12, "160326325324", 185},
  {5.7450340940488381630419526e+153, 11, "5745034094", 154},
  {1.3126538426102276186249173e+139, 1, "1", 140},
  {2.2592754361205394056767507e+224, 2, "23", 225},
  {6.7256941325181531666973588e+267, 11, "67256941325", 268},
  {1.0353706683383917542124993e-07, 2, "1", -6},
  {8.6699732386172743300543186e-165, 7, "8669973", -164},
  {1.5492970008838825176864030e+40, 14, "15492970008839", 41},
  {3.2137701929716203415869648e+65, 9, "321377019", 66},
  {1.6444067983431265824088715e-58, 6, "164441", -57},
  {1.3385141125440638141913990e+131, 17, "13385141125440638", 132},
  {4.9564064703868956199623063e+58, 16, "4956406470386896", 59},
  {4.8086822229109425483894981e+83, 14, "48086822229109", 84},
  {3.8040027234182467101561532e+247, 10, "3804002723", 248},
  {2.0969929948405667366840293e-63, 21, "209699299484056673668", -62},
  {1.0890680873489631191145748e-247, 10, "1089068087", -246},
  {9.0128511819276917161301854e-05, 21, "901285118192769171613", -4},
  {2.3264269292552020711811382e-176, 13, "2326426929255", -175},
  {4.3109159943768943069430795e+50, 14, "43109159943769", 51},
  {3.4447724844705518429587640e+277, 14, "34447724844706", 278},
  {5.1047337897734736722475440e-08, 18, "510473378977347367", -7},
  {2.5873236622281490572836630e+241, 9, "258732366", 242},
  {2.5066795085877015686670066e-96, 2, "25", -95},
  {1.8684545920885636757536688e-301, 12, "186845459209", -300},
  {3.4709889162404543483786630e-308, 5, "3471", -307},
  {1.6237333892073623670728039e-237, 11, "16237333892", -236},
  {1.9671931452665816911383087e+224, 17, "19671931452665817", 225},
  {8.8270507639271818353149651e-100, 5, "88271", -99},
  {6.2463581532088198800009003e-174, 1, "6", -173},
  {1.6617224913169747076348749e+123, 17, "16617224913169747", 124},
  {2.5257423556793718394520992e-121, 3, "253", -120},
  {1.8039777630003866340718477e+40, 13, "1803977763", 41},
  {7.0297071985283639938682565e-292, 12, "702970719853", -291},
  {3.2983432928441356140741263e-96, 13, "3298343292844", -95},
  {1.6303632535545532092043654e+195, 9, "163036325", 196},
  {7.9258597893036288735566948e+296, 2, "79", 297},
  {1.7243337387028936486710471e-156, 15, "172433373870289", -155},
  {3.1030233795367704818142635e+184, 4, "3103", 185},
  {6.0617459495575150086666804e+299, 11, "60617459496", 300},
  {5.3131974288530722001665393e+27, 12, "531319742885", 28},
  {4.7367346836640153064210727e+225, 15, "473673468366402", 226},
  {6.8296160486258700651978067e+130, 10, "6829616049", 131},
  {2.8430481702225685517812886e+36, 18, "284304817022256855", 37},
  {2.3608566213311057190072790e+103, 18, "236085662133110572", 104},
  {6.0145517319504637583135603e+38, 11, "6014551732", 39},
  {1.4004755874770614004893915e-80, 10, "1400475587", -79},
  {1.7990132100986021304115423e-233, 6, "179901", -232},
  {2.3584618636203103996117671e-153, 5, "23585", -152},
  {2.8261884776759951051660286e+109, 10, "2826188478", 110},
  {3.2731888333070666046092632e+237, 1, "3", 238},
  {2.8888459685843500829407508e+160, 16, "288884596858435", 161},
  {2.4850781967933026998728658e+224, 8, "24850782", 225},
  {3.4263281376565779157616905e+142, 2, "34", 143},
  {1.4511239605912728212805305e-69, 2, "15", -68},
  {1.5410385471706077131010338e+246, 15, "154103854717061", 247},
  {2.0924090981579119283878341e+40, 12, "209240909816", 41},
  {7.0983065360017304650565175e+272, 5, "70983", 273},
  {5.5881613140790625165289209e+76, 13, "5588161314079", 77},
  {5.8873891370025478059798545e+200, 10, "5887389137", 201},
  {3.1093710949831916317272342e-292, 2, "31", -291},
  {2.8709603350504611571805609e+156, 7, "287096", 157},
  {4.7961175232311529947797285e+117, 21, "479611752323115299478", 118},
  {2.0063437593066834907980491e-207, 9, "200634376", -206},
  {5.2734526303773935385083641e-258, 3, "527", -257},
  {9.5630220263276247518964133e-170, 19, "9563022026327624752", -169},
  {6.6677762833309209250542517e-256, 12, "666777628333", -255},
  {2.3086537781367928786632164e-171, 14, "23086537781368", -170},
  {1.3060955622145817606206155e+259, 7, "1306096", 260},
  {1.0988502878957836989505607e+231, 4, "1099", 232},
  {1.5250042733343790126942895e-19, 1, "2", -18},
  {1.2383018530813678214878578e-294, 20, "12383018530813678215", -293},
  {6.8607131106621403563322340e+263, 14, "68607131106621", 264},
  {5.8056849792199516483876452e+214, 1, "6", 215},
  {2.5961928880065997159962125e-211, 2, "26", -210},
  {7.5805040562488293603950631e+276, 10, "7580504056", 277},
  {4.1122411074590047680128538e+93, 8, "41122411", 94},
  {5.0840773422704804741483939e-203, 16, "508407734227048", -202},
  {5.9215201997500068818946769e+195, 10, "59215202", 196},
  {7.9783040684282534731202098e+279, 15, "797830406842825", 280},
  {7.9163137200798548447441010e+54, 7, "7916314", 55},
  {5.0593312669899957662699503e-213, 10, "5059331267", -212},
  {4.9823568000072441718311720e+121, 6, "498236", 122},
  {9.7610036720350815976038536e-241, 2, "98", -240},
  {3.4169798533055756473448246e-164, 9, "341697985", -163},
  {6.9493640872362540987423521e+65, 1, "7", 66},
  {4.8396928235889993282504709e+86, 2, "48", 87},
  {9.9787371086709821011326309e+213, 2, "1", 215},
  {1.3935225078110734326338460e-288, 21, "139352250781107343263", -287},
  {9.3657727352475194303805984e-171, 16, "9365772735247519", -170},
  {2.5098427761173433600000000e+17, 13, "2509842776117", 18},
  {5.1281689784195755235696149e-83, 12, "512816897842", -82},
  {3.6659971924692752733261051e+84, 3, "367", 85},
  {1.4424007859943261426163593e-113, 13, "1442400785994", -112},
  {2.7118095296356700315975680e+25, 14, "27118095296357", 26},
  {9.8961726175660993968398968e+249, 16, "9896172617566099", 250},
  {4.3289450617577664659757545e-295, 3, "433", -294},
  {1.8286909210350277667994613e+119, 14, "1828690921035", 120},
  {5.4708185248526373624606851e+83, 2, "55", 84},
  {2.2247464129562933561979112e-87, 1, "2", -86},
  {9.3881202230049749358333218e+32, 2, "94", 33},
  {4.6455614627536441622864206e-52, 8, "46455615", -51},
  {3.8051226315515221773639261e+87, 15, "380512263155152", 88},
  {1.3426980599921343693076361e-249, 9, "134269806", -248},
  {2.5424135269271658249929861e-286, 14, "25424135269272", -285},
  {1.2521294257488861743137677e-131, 16, "1252129425748886", -130},
  {1.9543738577843738112667234e-152, 5, "19544", -151},
  {1.2853085413111904338867068e+124, 20, "12853085413111904339", 125},
  {1.4558801145203223719934351e+268, 16, "1455880114520322", 269},
  {5.2202403036257629601685666e+136, 14, "52202403036258", 137},
  {1.3088082950242546685386727e-229, 2, "13", -228},
  {3.2177456086688108800000000e+17, 14, "32177456086688", 18},
  {6.2121983737754198340484737e+169, 20, "6212198373775419834", 170},
  {2.6444876271650638208172800e+41, 3, "264", 42},
  {6.2463105593718530909460447e-116, 12, "624631055937", -115},
  {3.5604218641263481205212329e+69, 3, "356", 70},
  {1.6434900390751060000000000e+15, 8, "164349", 16},
  {7.1698838611577621788942578e+260, 17, "71698838611577622", 261},
  {5.0493933716873126553173192e+142, 1, "5", 143},
  {2.7393737151806984616917261e+139, 19, "2739373715180698462", 140},
  {4.4207549303824785580343716e+122, 9, "442075493", 123},
  {3.0484409265178804226715221e+269, 7, "3048441", 270},
  {6.5544882065856317145891188e-229, 16, "6554488206585632", -228},
  {7.9727913448410756349201938e-109, 18, "797279134484107563", -108},
  {3.1092856789610486122108474e+206, 1, "3", 207},
  {1.3335151355727701394083585e-118, 3, "133", -117},
  {2.6058840505498384602306600e-270, 9, "260588405", -269},
  {3.4866423194759486983233396e-101, 9, "348664232", -100},
  {6.6928492086684645157729223e-04, 16, "6692849208668465", -3},
  {3.8474453551174517711345914e+271, 8, "38474454", 272},
  {6.8511629185763019794911844e-299, 7, "6851163", -298},
  {7.5519090285488882363669039e-49, 9, "755190903", -48},
  {3.8692966169631415866255133e-145, 6, "38693", -144},
  {7.3078870818622439680737575e+206, 21, "730788708186224396807", 207},
  {6.3336437773993324847924720e-113, 6, "633364", -112},
  {4.1344813127244939096271992e+04, 1, "4", 5},
  {1.2289103892099795674826501e-215, 8, "12289104", -214},
  {1.2136454255704422615036283e-286, 6, "121365", -285},
  {3.3006292496229442414613695e+155, 16, "3300629249622944", 156},
  {1.0627054772849335586454172e+99, 20, "10627054772849335586", 100},
  {1.0751855131448083297901927e-106, 21, "107518551314480832979", -105},
  {7.7158399741379993241450229e+278, 7, "771584", 279},
  {3.1685786950733181155150478e-227, 20, "31685786950733181155", -226},
  {1.2792749890006879672346907e-183, 19, "1279274989000687967", -182},
  {2.6085529239694849181880179e+228, 7, "2608553", 229},
  {6.3591785458893850565829210e-247, 16, "6359178545889385", -246},
  {2.6595390130222975826900457e-257, 11, "2659539013", -256},
  {7.8361365624283357392067535e-240, 10, "7836136562", -239},
  {2.6194304560542785203582105e-214, 21, "261943045605427852036", -213},
  {5.1666530559216382957444113e-161, 16, "5166653055921638", -160},
  {5.2086369238797546449196037e-168, 12, "520863692388", -167},
  {2.2587175176658811667320877e+126, 1, "2", 127},
  {3.2354846851692488325499064e-148, 3, "324", -147},
  {7.2350258276449218792443086e-253, 6, "723503", -252},
  {2.9170497869004814861045521e+76, 16, "2917049786900481", 77},
  {5.2891296475125658933432286e+248, 16, "5289129647512566", 249},
  {1.1981858025794266476107312e-172, 3, "12", -171},
  {1.3945770527797491710238933e-145, 17, "13945770527797492", -144},
  {1.2386535329940590915456874e-44, 2, "12", -43},
  {2.6015973339648392352793407e+147, 15, "260159733396484", 148},
  {4.0578981966636076649454685e+158, 18, "405789819666360766", 159},
  {9.0404208873197939103983341e+104, 17, "90404208873197939", 105},
  {1.0307563761636506691548549e-186, 2, "1", -185},
  {9.6785850481085093052179379e+148, 4, "9679", 149},
  {1.3179658471567909321797580e+189, 2, "13", 190},
  {1.6246777074626316070556641e+10, 17, "16246777074626316", 11},
  {4.8693176170694506842141238e+290, 10, "4869317617", 291},
  {3.4451499345184008965550740e-272, 20, "34451499345184008966", -271},
  {5.2866680213175414049242562e-02, 18, "52866680213175414", -1},
  {7.5820755792341931296423610e-80, 21, "758207557923419312964", -79},
  {1.0880507011894510733177001e+46, 13, "1088050701189", 47},
  {1.8624531636313815100702423e+129, 11, "18624531636", 130},
  {1.6123066442022027580505076e+195, 19, "1612306644202202758", 196},
  {7.0526148523450554391057626e+214, 18, "705261485234505544", 215},
  {2.5002214725993902465307916e+172, 1, "3", 173},
  {5.3539813880310850847061931e-212, 5, "5354", -211},
  {3.4263891157697689713899339e+117, 1, "3", 118},
  {1.8335714497572552307719553e+43, 4, "1834", 44},
  {1.5589882495196042557681219e-305, 15, "15589882495196", -304},
  {5.4349142817575143751290640e-84, 15, "543491428175751", -83},
  {6.3982196916404496497518602e+108, 3, "64", 109},
  {1.2125013455400514623764306e+37, 3, "121", 38},
  {1.9062973713343744908144117e+00, 14, "19062973713344", 1},
  {2.2566273489523172611370683e+05, 21, "225662734895231726114", 6},
  {5.2738515682542732644707525e+260, 10, "5273851568", 261},
  {5.7902959865013826756661047e-181, 14, "57902959865014", -180},
  {4.0758143549245988353431801e+131, 9, "407581435", 132},
  {9.7884631081236953583472557e-185, 15, "97884631081237", -184},
  {1.5100320326198212206884589e+185, 20, "15100320326198212207", 186},
  {7.8077758149812137578038573e-01, 21, "78077758149812137578", 0},
  {2.6321552975799689355870038e+206, 15, "263215529757997", 207},
  {4.2379664940433981365913066e-287, 13, "4237966494043", -286},
  {2.2147283638786772173766600e-194, 21, "221472836387867721738", -193},
  {1.1768651168599501216664260e+138, 14, "117686511686", 139},
  {4.8283677232460104510243638e+89, 13, "4828367723246", 90},
  {2.2241783635727112759422218e+279, 17, "22241783635727113", 280},
  {3.8617977638893117099645938e+54, 19, "386179776388931171", 55},
  {8.8348854944477954616836461e-29, 17, "88348854944477955", -28},
  {4.3650348136426689243744143e+133, 16, "4365034813642669", 134},
  {5.2985655468742841283304513e+307, 17, "52985655468742841", 308},
  {5.0974820366026707229354548e+277, 2, "51", 278},
  {1.6775903980448178810467663e+51, 9, "16775904", 52},
  {1.2133539159746553257881065e+120, 6, "121335", 121},
  {3.6590477164228837778684541e-250, 21, "365904771642288377787", -249},
  {1.3405895111144416419410309e+215, 20, "13405895111144416419", 216},
  {3.4106565689275245893270756e-299, 21, "341065656892752458933", -298},
  {6.2447221246343517740467926e-16, 15, "624472212463435", -15},
  {1.0067418690814984305603730e+00, 9, "100674187", 1},
  {4.2961770155294021269056224e+256, 2, "43", 257},
  {5.3235050490377755196131621e+177, 20, "53235050490377755196", 178},
  {5.6457250548616216322531114e-181, 13, "5645725054862", -180},
  {5.4260707985757120547040327e-107, 15, "542607079857571", -106},
  {1.0436840783182234273236157e+291, 14, "10436840783182", 292},
  {9.1633881592665431695626334e+241, 8, "91633882", 242},
  {1.2547166399891159273141388e+280, 4, "1255", 281},
  {1.3577623263299191396660201e+232, 10, "1357762326", 233},
  {4.8761570780020111231014499e-179, 3, "488", -178},
  {4.1700561994187492132186890e+08, 20, "41700561994187492132", 9},
  {3.4220427279371330339644230e-178, 18, "342204272793713303", -177},
  {4.9812859959815394878387451e+08, 7, "4981286", 9},
  {2.7716981419860456934696734e-203, 5, "27717", -202},
  {1.3758803762169607063042659e-172, 5, "13759", -171},
  {2.0923569963526612841145281e+66, 15, "209235699635266", 67},
  {3.5899968040537058368878862e-280, 11, "35899968041", -279},
  {2.1686988445351695949473514e+260, 7, "2168699", 261},
  {7.5885261841772072677912946e+153, 6, "758853", 154},
  {7.5968808792088267995742019e+266, 3, "76", 267},
  {4.0741033911138090922025981e+203, 15, "407410339111381", 204},
  {2.9555349522812992947010008e-110, 12, "295553495228", -109},
  {1.6690838071351501844479496e+202, 16, "166908380713515", 203},
  {7.4631244941320844917781815e-45, 8, "74631245", -44},
  {2.0247074628481657662670834e-03, 16, "2024707462848166", -2},
  {3.8039222855620877444376306e-267, 18, "380392228556208774", -266},
  {1.3272181174226849590129031e-41, 11, "13272181174", -40},
  {1.0192224530943212508194932e+286, 13, "1019222453094", 287},
  {1.1543649989782611463835753e-286, 21, "115436499897826114638", -285},
  {9.9464356148485243788907905e-217, 10, "9946435615", -216},
  {4.0134722969995757054302376e-251, 2, "4", -250},
  {6.4788311280059080015002690e-129, 7, "6478831", -128},
  {1.1127184780136295136401961e+277, 16, "111271847801363", 278},
  {3.9506801714858221620372383e-260, 4, "3951", -259},
  {5.1860406041599568027016969e-69, 7, "5186041", -68},
  {2.3832217237092724634950010e+257, 15, "238322172370927", 258},
  {1.0839246331965544028587345e+112, 11, "10839246332", 113},
  {2.9663215745085447591872878e-148, 17, "29663215745085448", -147},
  {3.9535629139038320123181542e-244, 8, "39535629", -243},
  {1.3974778349592730787673359e-257, 17, "13974778349592731", -256},
  {7.9400206709370197127312018e+180, 7, "7940021", 181},
  {2.8051606588299128848430901e-239, 10, "2805160659", -238},
  {7.1361041841696545458762258e-172, 16, "7136104184169655", -171},
  {7.1353566123916987979843841e+103, 16, "7135356612391699", 104},
  {2.6551234260350536756435644e-111, 7, "2655123", -110},
  {5.8141356966624733211949771e-21, 19, "5814135696662473321", -20},
  {6.6029639062441420234207155e-205, 2, "66", -204},
  {2.9112472688530414598870595e+184, 3, "291", 185},
  {4.1672631638799144627030044e+139, 7, "4167263", 140},
  {9.9052913881696654126426719e-225, 2, "99", -224},
  {3.3530876526710144960917290e+131, 5, "33531", 132},
  {7.1223407899218887708417692e-273, 17, "71223407899218888", -272},
  {2.5857698138316613284408863e-112, 12, "258576981383", -111},
  {4.6600735447646865415176532e+207, 11, "46600735448", 208},
  {6.7499033828417062498786116e+131, 15, "674990338284171", 132},
  {6.5610357733521453258092052e+27, 17, "65610357733521453", 28},
  {5.9000071988253405654743179e+164, 19, "5900007198825340565", 165},
  {4.7247719885922627027416463e-284, 21, "472477198859226270274", -283},
  {6.7909953019216261231747222e-26, 13, "6790995301922", -25},
  {4.3034150259317308910407990e-257, 20, "4303415025931730891", -256},
  {4.5123277758453870371403585e+142, 20, "45123277758453870371", 143},
  {1.0633091519524085923163151e+96, 4, "1063", 97},
  {2.7343771784126080567878766e+70, 1, "3", 71},
  {9.0464493038860640820624036e+174, 8, "90464493", 175},
  {2.4035498305701475472167199e-191, 16, "2403549830570148", -190},
  {1.4573680862822413016744863e-56, 7, "1457368", -55},
  {1.7004733383101089810588218e+109, 3, "17", 110},
  {8.2644992840249715773266254e+241, 5, "82645", 242},
  {4.9103394310255790172725368e-238, 8, "49103394", -237},
  {3.5350687607762209275003308e-12, 17, "35350687607762209", -11},
  {2.2321805181060450630842116e+252, 19, "2232180518106045063", 253},
  {3.4586475031588667947002465e-20, 15, "345864750315887", -19},
  {2.9326787716561533517506704e-240, 8, "29326788", -239},
  {5.0882552556783705085477920e+204, 12, "508825525568", 205},
  {7.6122745637302797246798169e-04, 3, "761", -3},
  {1.1325358171162343424287191e-148, 15, "113253581711623", -147},
  {5.8031340686715109989313876e-12, 7, "5803134", -11},
  {1.3242034991261680479730935e-278, 8, "13242035", -277},
  {4.6494596527899796569435508e-156, 6, "464946", -155},
  {9.8308413544486752534137820e+233, 5, "98308", 234},
  {5.0558742441149703200773815e-27, 4, "5056", -26},
  {1.0573727657755920871423750e+249, 3, "106", 250},
  {3.7504443625024318737112151e+102, 6, "375044", 103},
  {1.9334748528113482087067563e+196, 20, "19334748528113482087", 197},
  {1.3833554346752913888407894e-163, 8, "13833554", -162},
  {3.9346332019391131769850989e+159, 3, "393", 160},
  {2.7250201590916476370233094e+162, 15, "272502015909165", 163},
  {7.9561928790522069408720765e-303, 5, "79562", -302},
  {5.9926272521543773334602143e+173, 11, "59926272522", 174},
  {1.3344467202053467326827015e-66, 10, "133444672", -65},
  {3.2218324217853455826551031e-130, 12, "322183242179", -129},
  {1.0582833541264946688897908e+05, 18, "105828335412649467", 6},
  {1.0194996563933061256621212e-180, 5, "10195", -179},
  {4.6231436181158455966012529e-193, 10, "4623143618", -192},
  {1.1963733647479575320056889e-82, 1, "1", -81},
  {1.0585511020930168334660616e+297, 12, "105855110209", 298},
  {5.8386581964362257764987112e+94, 18, "583865819643622578", 95},
  {2.2868592133878181715526069e+209, 7, "2286859", 210},
  {2.1974667668343744209351782e+265, 4, "2197", 266},
  {2.6462384882111479844733448e-56, 6, "264624", -55},
  {7.1233073463434940990846544e+189, 2, "71", 190},
  {3.6949861723931910906561115e+282, 1, "4", 283},
  {1.7196503135303549840742645e-252, 14, "17196503135304", -251},
  {2.8800861597356891396495247e+37, 14, "28800861597357", 38},
  {1.9984358809560857555864238e+190, 21, "199843588095608575559", 191},
  {9.4361170895185971815290430e+153, 17, "94361170895185972", 154},
  {2.3631599800199123483142476e-106, 7, "236316", -105},
  {1.0396846582749255347868507e-103, 20, "10396846582749255348", -102},
  {4.1751144375851310163512487e+218, 1, "4", 219},
  {5.3486260921322161756440912e-24, 21, "534862609213221617564", -23},
  {3.4054339872196500408685262e-97, 14, "34054339872197", -96},
  {1.6658239511064250280857945e+161, 9, "166582395", 162},
  {4.8549941831224111741222412e+57, 1, "5", 58},
  {3.1572851075916446531041704e+53, 8, "31572851", 54},
  {7.4225821165732142863781098e-255, 21, "742258211657321428638", -254},
  {5.1035137282312956483839071e-265, 6, "510351", -264},
  {3.9275559532704939289562789e+117, 5, "39276", 118},
  {7.8161032080613548375735934e-187, 7, "7816103", -186},
  {2.3924542689756235070977438e-228, 18, "239245426897562351", -227},
  {1.1552979805449769271582427e+277, 4, "1155", 278},
  {1.5114010570474199728184255e+121, 12, "151140105705", 122},
  {2.0688720744931492150201100e-193, 19, "2068872074493149215", -192},
  {6.3335501142985679591715736e-175, 1, "6", -174},
  {3.3900531545747434724055443e-202, 3, "339", -201},
  {2.9323335879079544919496678e-269, 11, "29323335879", -268},
  {1.0500348155094040701451780e-109, 9, "105003482", -108},
  {2.9381662473561844895658332e+81, 7, "2938166", 82},
  {2.4785321447269591764633144e+126, 19, "2478532144726959176", 127},
  {9.0530004084934503244387435e-193, 20, "90530004084934503244", -192},
  {8.3311494625755975573526872e+179, 1, "8", 180},
  {3.7256423367836900635910221e-162, 3, "373", -161},
  {3.3398838009019016799385291e-50, 14, "33398838009019", -49},
  {1.1733268579415593556001213e+62, 9, "117332686", 63},
  {1.8374572930598570788837525e+43, 1, "2", 44},
  {3.7959423890949957458481224e-228, 18, "379594238909499575", -227},
  {1.6031620549665126856408891e+74, 13, "1603162054967", 75},
  {1.2854343608740294322251456e+166, 1, "1", 167},
  {3.0424278737618360860898458e-106, 15, "304242787376184", -105},
  {1.4128007048214123585524862e+203, 14, "14128007048214", 204},
  {3.2381369308775682686333769e-261, 10, "3238136931", -260},
  {1.4919058316933023262431019e+285, 6, "149191", 286},
  {9.9063067558048986397276053e-50, 18, "990630675580489864", -49},
  {4.5414303801182861460832857e-82, 10, "454143038", -81},
  {9.8024437314079878738922070e+180, 16, "9802443731407988", 181},
  {2.0349952258920160204423083e-106, 6, "2035", -105},
  {3.5957322385538854111866485e-297, 19, "3595732238553885411", -296},
  {5.5837380225546914657080996e-241, 11, "55837380226", -240},
  {6.6671921008141752771900766e-128, 12, "666719210081", -127},
  {2.7029942784600363843895568e+298, 19, "2702994278460036384", 299},
  {2.2979772349189626685768779e+263, 6, "229798", 264},
  {1.5924790507851756106514988e+289, 11, "15924790508", 290},
  {8.8798386180390488218887023e+269, 3, "888", 270},
  {2.4197190852860669461635450e+281, 11, "24197190853", 282},
  {2.1500916769604217585986178e-275, 6, "215009", -274},
  {8.5509148594606555748896863e-263, 8, "85509149", -262},
  {2.6047195093930545126095975e-216, 8, "26047195", -215},
  {1.1414949183267570295899987e-67, 10, "1141494918", -66},
  {1.7114370565888389939200000e+20, 1, "2", 21},
  {4.6574281340312073673715076e-01, 12, "465742813403", 0},
  {4.3622410156218236489133453e-255, 18, "436224101562182365", -254},
  {5.0605249543718385840804946e-203, 1, "5", -202},
  {1.3721270483679938930652985e-163, 8, "1372127", -162},
  {7.7695134158981172391960850e+267, 5, "77695", 268},
  {5.5007791399401317686054705e+147, 3, "55", 148},
  {1.4375087447590757506443372e+218, 9, "143750874", 219},
  {3.3496154657951682499005297e-253, 9, "334961547", -252},
  {2.3094984134080321068996951e+82, 8, "23094984", 83},
  {1.9102226753028809283784683e+158, 15, "191022267530288", 159},
  {1.2197881880459078923979458e+40, 5, "12198", 41},
  {1.6876225562104035173460300e-85, 13, "168762255621", -84},
  {8.7929538510746569293243827e+40, 17, "87929538510746569", 41},
  {9.6427372998337688602893794e+69, 17, "96427372998337689", 70},
  {6.5264743093469855292240624e-229, 7, "6526474", -228},
  {1.9260014302384363918759700e+270, 6, "1926", 271},
  {1.3637144342020183314125704e+282, 16, "1363714434202018", 283},
  {9.9138707824777311130237956e-183, 18, "991387078247773111", -182},
  {1.6290910437044681505846879e-110, 1, "2", -109},
  {7.8596614700004552741794918e-222, 4, "786", -221},
  {1.0038889031269075080534541e-288, 18, "100388890312690751", -287},
  {3.0255281660444414724473411e-68, 5, "30255", -67},
  {5.1580193369503719655105180e+35, 11, "5158019337", 36},
  {4.2772155599205765864398400e-50, 18, "427721555992057659", -49},
  {3.8413424577740237106430924e-259, 20, "38413424577740237106", -258},
  {1.3951098198902307972774052e+66, 12, "139510981989", 67},
  {1.1545785250975714546604787e+107, 12, "11545785251", 108},
  {1.8609426579187657964627880e+101, 15, "186094265791877", 102},
  {1.2826035269044092640790533e+140, 4, "1283", 141},
  {3.4893753438534952218674419e+79, 5, "34894", 80},
  {1.9747084388375042439116742e-187, 16, "1974708438837504", -186},
  {4.3514105481271381398405310e+284, 4, "4351", 285},
  {5.8933097784998634416234534e-06, 8, "58933098", -5},
  {2.8191101604057278563171986e-34, 12, "281911016041", -33},
  {5.4625089689686898481925667e-279, 19, "5462508968968689848", -278},
  {3.7852177351946103647563930e+68, 10, "3785217735", 69},
  {1.8804690580217604167251052e+229, 12, "188046905802", 230},
  {4.4208622327755891462651551e+163, 14, "44208622327756", 164},
  {5.1852235560220976576576236e-223, 17, "51852235560220977", -222},
  {7.0484841895551192842542674e+40, 9, "704848419", 41},
  {2.6083689498853999577673882e+236, 15, "26083689498854", 237},
  {7.1879069066270034084332495e-236, 11, "71879069066", -235},
  {1.9646794312854896517636525e-220, 20, "19646794312854896518", -219},
  {1.6743552738903001546256254e+268, 9, "167435527", 269},
  {1.1333930972663956400875349e-218, 2, "11", -217},
  {7.2713085936956424855020432e-58, 18, "727130859369564249", -57},
  {4.7990729757420512995713402e-18, 16, "4799072975742051", -17},
  {7.2249357967553005268355942e-41, 1, "7", -40},
  {3.4177575081858576271226797e+278, 6, "341776", 279},
  {1.5965113788481120852852095e-186, 17, "15965113788481121", -185},
  {6.3204391880224584851956623e-117, 15, "632043918802246", -116},
  {1.2320349253615613781293100e-290, 7, "1232035", -289},
  {6.4796782990193992191052530e+02, 7, "6479678", 3},
  {4.8636545609329278038529225e-117, 14, "48636545609329", -116},
  {6.6938459590313725235974349e+231, 2, "67", 232},
  {4.9694501194980154210436475e+82, 12, "49694501195", 83},
  {9.7627473993388393710542280e-147, 15, "976274739933884", -146},
  {6.3375332697201629098843353e-76, 4, "6338", -75},
  {2.9206545831935248395715078e+44, 7, "2920655", 45},
  {8.6683217400445500820599523e+179, 2, "87", 180},
  {7.8662412020328847782805243e+207, 14, "78662412020329", 208},
  {1.4550824115948453561596946e-175, 7, "1455082", -174},
  {1.2626860033444107641619338e-204, 11, "12626860033", -203},
  {8.6744571049758344310465556e+94, 7, "8674457", 95},
  {1.5053804488289928538451098e+44, 7, "150538", 45},
  {9.5729078916107721215071725e+166, 19, "9572907891610772122", 167},
  {1.6325491016106018192739001e+209, 15, "16325491016106", 210},
  {1.8782525226881484826382581e-139, 16, "1878252522688148", -138},
  {1.3363051973901790694902013e+239, 5, "13363", 240},
  {8.2787513824931146044445765e-250, 13, "8278751382493", -249},
  {1.2712337406357410500070356e+79, 2, "13", 80},
  {3.5743287272895372853035127e-84, 12, "357432872729", -83},
  {8.5723158559633693819941431e-275, 6, "857232", -274},
  {8.7672765637321446198321917e-164, 7, "8767277", -163},
  {1.5590970870313635317920014e+209, 7, "1559097", 210},
  {2.0446183676161211561185745e-256, 13, "2044618367616", -255},
  {2.8846598586531672751427670e-235, 2, "29", -234},
  {2.7498416068988836926896839e+181, 12, "27498416069", 182},
  {1.1581555945899657371084973e-04, 21, "115815559458996573711", -3},
  {3.3780115099854331295653111e+181, 15, "337801150998543", 182},
  {2.1790908068367548140411212e+102, 13, "2179090806837", 103},
  {3.2367984301171813201727580e-266, 13, "3236798430117", -265},
  {3.4705111761825648954113404e-279, 19, "3470511176182564895", -278},
  {5.0729116066624900678893399e+197, 19, "5072911606662490068", 198},
  {5.1053355905008012820776211e-113, 13, "5105335590501", -112},
  {1.3511462542146474957477491e+219, 7, "1351146", 220},
  {2.1344442789947352245934483e-282, 17, "21344442789947352", -281},
  {6.1458395439718796415949144e+60, 11, "6145839544", 61},
  {1.7558567913567951467751669e+165, 7, "1755857", 166},
  {9.3140603447640070363660014e-244, 9, "931406034", -243},
  {7.2720839563153784390008848e+273, 9, "727208396", 274},
  {4.9042673424152528505206682e+204, 21, "490426734241525285052", 205},
  {4.6731710138267812823975930e-59, 8, "4673171", -58},
  {6.5594195569156728926273306e+189, 17, "65594195569156729", 190},
  {3.7283061405859509743205993e+270, 20, "37283061405859509743", 271},
  {3.7886311563392715196187430e+229, 14, "37886311563393", 230},
  {6.1566874222292327603484768e-119, 6, "615669", -118},
  {9.5861094692702804893942990e+57, 21, "958610946927028048939", 58},
  {1.7344740108359143596076721e-159, 20, "17344740108359143596", -158},
  {2.9989938945472588997148396e+185, 5, "2999", 186},
  {7.0910742507356551966204258e-102, 1, "7", -101},
  {8.2574223491920544276770614e-107, 14, "82574223491921", -106},
  {4.8561192683190178247927649e-192, 1, "5", -191},
  {6.2030208998451827420104564e-243, 11, "62030208998", -242},
  {3.9004740230218848511865587e+152, 16, "3900474023021885", 153},
  {4.3594901513733475381810252e-308, 17, "43594901513733475", -307},
  {8.4932263606597896829445942e+142, 14, "84932263606598", 143},
  {1.4024517248998565061995492e+119, 4, "1402", 120},
  {1.6973496365553295519882350e-92, 6, "169735", -91},
  {4.0289942154760148247421693e+66, 9, "402899422", 67},
  {7.5744197677803093347374862e+105, 1, "8", 106},
  {4.1285438811823907416481400e+151, 14, "41285438811824", 152},
  {2.2244279568715628588253526e-194, 8, "2224428", -193},
  {5.1242017409775706502835701e+295, 9, "512420174", 296},
  {3.7030285457346468654577464e+172, 11, "37030285457", 173},
  {6.9435606989838022158433806e+127, 4, "6944", 128},
  {3.5262414362265864551294005e-222, 20, "35262414362265864551", -221},
  {9.7455850617273567357434634e+260, 18, "974558506172735674", 261},
  {2.8247861373097044218036600e+230, 5, "28248", 231},
  {7.9042304006846739760329913e-175, 20, "7904230400684673976", -174},
  {1.3643023609926474980473249e-167, 1, "1", -166},
  {1.9656986267291833445285348e-131, 15, "196569862672918", -130},
  {3.6538771877887228751579118e+41, 17, "36538771877887229", 42},
  {1.5773971798843457127625979e-173, 4, "1577", -172},
  {5.8445604139112597206986797e-136, 7, "584456", -135},
  {6.9122529431615137965276053e-192, 13, "6912252943162", -191},
  {6.8469829329044268242249194e-04, 7, "6846983", -3},
  {2.3244343206039033673576278e+155, 10, "2324434321", 156},
  {8.2965578235814419478313031e+56, 17, "82965578235814419", 57},
  {1.4048439389387758836086591e-135, 8, "14048439", -134},
  {5.6428425856512963534538159e+97, 19, "5642842585651296353", 98},
  {5.9801660744211014626351646e-270, 19, "5980166074421101463", -269},
  {5.6316524975999144014594836e+76, 16, "5631652497599914", 77},
  {2.2803582701628692245828740e+254, 17, "22803582701628692", 255},
  {7.1082998864769814614591827e+276, 13, "7108299886477", 277},
  {6.8329472245140805357042233e-52, 13, "6832947224514", -51},
  {8.0020762213553991231686542e+33, 17, "80020762213553991", 34},
  {2.2406756446631150058553424e+254, 20, "22406756446631150059", 255},
  {9.4858115589341600489003969e-04, 9, "948581156", -3},
  {4.9783245609272344307703142e+148, 11, "49783245609", 149},
  {3.2856748753383661686665323e-93, 12, "328567487534", -92},
  {1.0873183626864065010716890e-81, 12, "108731836269", -80},
  {8.4972587547520550041829503e-216, 16, "8497258754752055", -215},
  {3.4571190179059718409268342e+130, 15, "345711901790597", 131},
  {4.4168102716428301967836785e+277, 20, "44168102716428301968", 278},
  {1.4409066257035899081652436e-108, 14, "14409066257036", -107},
  {3.8854177466365033714433211e-92, 5, "38854", -91},
  {6.8872884825452659089936217e-181, 19, "6887288482545265909", -180},
  {1.1709076035386436258841570e+242, 19, "1170907603538643626", 243},
  {7.5316440274378194478399467e+61, 8, "7531644", 62},
  {6.5537537733523989194209842e+129, 4, "6554", 130},
  {8.0329912987372084003508466e-129, 1, "8", -128},
  {2.5217122333540083087757312e-303, 9, "252171223", -302},
  {5.5504313563703901426082708e-252, 15, "555043135637039", -251},
  {1.7921373899105266291733070e-211, 1, "2", -210},
  {6.7465225587933816358565837e-17, 16, "6746522558793382", -16},
  {6.6322557996239075195878451e-97, 21, "663225579962390751959", -96},
  {5.5155921941023928993082499e-143, 16, "5515592194102393", -142},
  {8.5134425735835884515394471e-286, 6, "851344", -285},
  {2.7826812875893930428494456e+71, 15, "278268128758939", 72},
  {9.0979887976922650517072309e+141, 10, "9097988798", 142},
  {2.6111257904884668996888819e-133, 12, "261112579049", -132},
  {4.2040913162382996820370048e-116, 14, "42040913162383", -115},
  {1.0240797026498468649956119e+46, 4, "1024", 47},
  {1.1733086761637618387851673e-242, 14, "11733086761638", -241},
  {6.8930744632423284178092793e+300, 21, "689307446324232841781", 301},
  {3.4558605549387640915329991e-16, 15, "345586055493876", -15},
  {1.0732057969727898207100251e-06, 18, "107320579697278982", -5},
  {2.9038712750772824007147034e+123, 15, "290387127507728", 124},
  {1.7061542141016872631074038e+118, 1, "2", 119},
  {4.8216504756859284580100553e+278, 3, "482", 279},
  {7.6396600071736642632153769e+213, 19, "7639660007173664263", 214},
  {1.4539290432715264966002331e-288, 21, "14539290432715264966", -287},
  {4.6652368255997014502879036e+148, 20, "46652368255997014503", 149},
  {4.9783969845825577067444101e+03, 16, "4978396984582558", 4},
  {3.0158200387744301862214892e+121, 6, "301582", 122},
  {1.6143158550097303588140028e+93, 10, "1614315855", 94},
  {3.6575225934165770131859583e-274, 20, "36575225934165770132", -273},
  {2.3135824166898607392343375e+38, 21, "231358241668986073923", 39},
  {1.2372128408806861866726347e-135, 7, "1237213", -134},
  {4.9140097053306451913929317e-291, 8, "49140097", -290},
  {6.7806403231414646641051157e-62, 7, "678064", -61},
  {4.8022327823635125610647077e-290, 16, "4802232782363513", -289},
  {3.1618164842545700129651598e+210, 17, "316181648425457", 211},
  {1.8342299609525312427844821e+90, 18, "183422996095253124", 91},
  {4.0451855681628895412920688e-201, 17, "40451855681628895", -200},
  {5.9008089890584457151431609e+249, 1, "6", 250},
  {2.8039641393621106321214770e-58, 12, "280396413936", -57},
  {7.3798470472965356353332892e-145, 4, "738", -144},
  {4.6681675979683257887196017e-76, 11, "4668167598", -75},
  {1.3729527367398530244827271e+08, 19, "1372952736739853024", 9},
  {8.2097998864704287945540347e+205, 14, "82097998864704", 206},
  {2.9951099087929035691579867e+77, 17, "29951099087929036", 78},
  {2.8206016465861682984694880e-01, 8, "28206016", 0},
  {3.1307527539266439067227571e+294, 11, "31307527539", 295},
  {2.0736342679733884233637198e+167, 14, "20736342679734", 168},
  {1.0136933094657109460288453e-263, 6, "101369", -262},
  {1.2867535763713104089336697e+306, 11, "12867535764", 307},
  {6.2649081416160723851173296e+188, 6, "626491", 189},
  {5.1106016124033909007863874e+57, 6, "51106", 58},
  {1.7291323403984116881855610e+87, 1, "2", 88},
  {1.2701730776164985275928429e+131, 5, "12702", 132},
  {2.9097259438458168041201868e+196, 12, "290972594385", 197},
  {1.5855744045159512592199921e-307, 1, "2", -306},
  {2.4595691220099041450623503e-216, 2, "25", -215},
  {3.2707761943073411658021408e+48, 2, "33", 49},
  {4.3027670418418274873982078e-219, 18, "430276704184182749", -218},
  {1.3163472130759010871603649e+180, 19, "1316347213075901087", 181},
  {6.8845840296996334431078228e+173, 14, "68845840296996", 174},
  {1.6532476342413292513811029e+02, 15, "165324763424133", 3},
  {1.8329338349558104144509366e-16, 13, "1832933834956", -15},
  {7.2226571316508769514144156e-178, 16, "7222657131650877", -177},
  {1.0116276385914698733984149e-123, 21, "10116276385914698734", -122},
  {2.0224328608247513600000000e+18, 16, "2022432860824751", 19},
  {3.3323869899743608185085785e+38, 4, "3332", 39},
  {2.4285662998117136066821494e+41, 19, "2428566299811713607", 42},
  {7.8302072998475558298103010e-27, 21, "783020729984755582981", -26},
  {8.2726652358531807314973452e+40, 13, "8272665235853", 41},
  {8.1323482747763206514188917e+192, 20, "81323482747763206514", 193},
  {1.1018660324062330428984015e+235, 5, "11019", 236},
  {1.6828809630775602534357513e+41, 15, "168288096307756", 42},
  {1.7818172050842912648189429e-213, 2, "18", -212},
  {2.6597895505466650510571760e+305, 20, "26597895505466650511", 306},
  {1.2581426631880821915621962e-95, 16, "1258142663188082", -94},
  {2.0723666392175560409119307e+227, 5, "20724", 228},
  {1.1222739467360641756071151e+126, 6, "112227", 127},
  {3.1194622096632986185543015e-300, 18, "311946220966329862", -299},
  {1.6354396074402086158283837e-88, 13, "163543960744", -87},
  {9.3338493083794596689476787e-228, 2, "93", -227},
  {9.4730746795702158151333857e+163, 13, "947307467957", 164},
  {9.3148627372093401255959539e-79, 18, "931486273720934013", -78},
  {5.4754551514857581532411792e+190, 5, "54755", 191},
  {7.3961481313056701735239680e+24, 6, "739615", 25},
  {4.0390447179884554412942029e-93, 12, "403904471799", -92},
  {6.2384426974695671678053979e-181, 19, "6238442697469567168", -180},
  {1.5606285575680586477405010e-292, 20, "15606285575680586477", -291},
  {2.3827018685489632833044545e+260, 21, "23827018685489632833", 261},
  {6.1624418440897941701203541e+82, 19, "616244184408979417", 83},
  {2.2129967403878958975838032e+02, 5, "2213", 3},
  {4.2716078673383071540821306e-287, 2, "43", -286},
  {1.3772693892636412837958892e-14, 20, "13772693892636412838", -13},
  {4.8285583967834972759093130e+198, 5, "48286", 199},
  {8.9608616819014575000000000e+14, 13, "8960861681901", 15},
  {4.2630789950131482395739117e+195, 10, "4263078995", 196},
  {1.5994364489793455913778069e-15, 3, "16", -14},
  {8.8215841728370793369157948e+77, 1, "9", 78},
  {9.8243408183958285403140079e-36, 20, "98243408183958285403", -35},
  {8.3869686648125894264728268e-233, 19, "8386968664812589426", -232},
  {2.0223635167385749048745927e-297, 21, "202236351673857490487", -296},
  {1.0092314101780978416972605e+223, 15, "10092314101781", 224},
  {5.3608370539173760669533722e+35, 13, "5360837053917", 36},
  {2.4970386699293015655293040e+222, 17, "24970386699293016", 223},
  {1.3199610245410651999482267e-101, 11, "13199610245", -100},
  {2.2737328749213555559649935e+94, 12, "227373287492", 95},
  {1.2928931388037621761937474e+130, 13, "1292893138804", 131},
  {3.2123434321241949520517169e+296, 5, "32123", 297},
  {5.0219006839867434561265359e+256, 17, "50219006839867435", 257},
  {1.9038315433681422491367636e-126, 16, "1903831543368142", -125},
  {1.6298667023733621084242028e-180, 17, "16298667023733621", -179},
  {5.7288634461302385711185630e+100, 6, "572886", 101},
  {6.2317939556599749036323970e-63, 6, "623179", -62},
  {1.0378957329454717869703763e+259, 7, "1037896", 260},
  {4.6618222033729313311341805e+304, 14, "46618222033729", 305},
  {8.9652411712552541767559907e+89, 20, "89652411712552541768", 90},
  {2.2532273913917425107077246e-135, 15, "225322739139174", -134},
  {9.3862448829256747466016311e+256, 11, "93862448829", 257},
  {3.5772718134474063141711041e-191, 9, "357727181", -190},
  {3.4687308398750479412267062e-189, 3, "347", -188},
  {2.3487006530189160978437796e-244, 6, "23487", -243},
  {8.7753593743758929559324935e+273, 17, "8775359374375893", 274},
  {5.8251908508497589672183674e-200, 1, "6", -199},
  {1.8469769847012055353437041e-59, 7, "1846977", -58},
  {1.5906478534263901278749157e-162, 13, "1590647853426", -161},
  {8.1834753114729337458702408e-87, 9, "818347531", -86},
  {7.2263910443543343261606765e+283, 9, "722639104", 284},
  {4.8811408880706334641618944e+25, 10, "4881140888", 26},
  {4.4858907487126571709806912e-35, 15, "448589074871266", -34},
  {1.7408736210750391816081110e+269, 17, "17408736210750392", 270},
  {5.3817305050611590616803773e+200, 17, "53817305050611591", 201},
  {3.1994195394751124083995819e+07, 5, "31994", 8},
  {1.1801906460540674876803027e+30, 16, "1180190646054067", 31},
  {1.0017039485305986097987087e+124, 5, "10017", 125},
  {7.2894882092763641637380818e+177, 19, "7289488209276364164", 178},
  {1.6488632613619541925034983e+304, 16, "1648863261361954", 305},
  {1.1009864934942476687462829e-50, 12, "110098649349", -49},
  {2.5609511006585763803506262e+141, 14, "25609511006586", 142},
  {9.2025009545790018771591266e-39, 3, "92", -38},
  {7.1163349418834484062654038e+276, 2, "71", 277},
  {1.9903407059606966200120021e+278, 12, "199034070596", 279},
  {5.7688559753588934229547872e+116, 20, "5768855975358893423", 117},
  {1.7942443772782140743195183e+180, 3, "179", 181},
  {8.4755526212313293423246752e+139, 4, "8476", 140},
  {1.5862632585910404398063126e-37, 8, "15862633", -36},
  {8.4565514845608475325185183e-05, 3, "846", -4},
  {3.4953830185877810702970681e+125, 16, "3495383018587781", 126},
  {1.9730307221419534887928131e-44, 14, "1973030722142", -43},
  {2.4743765080447461544800435e-151, 3, "247", -150},
  {2.3476388767685129437831112e+165, 11, "23476388768", 166},
  {6.8506682502640530071465492e+27, 14, "68506682502641", 28},
  {4.1460931389655116439806185e+117, 20, "4146093138965511644", 118},
  {5.2618761234706284880122758e+125, 15, "526187612347063", 126},
  {1.3806942086077667474743876e-164, 15, "138069420860777", -163},
  {1.1758055709910917069401446e+298, 21, "117580557099109170694", 299},
  {5.9148133564008169399956517e+110, 2, "59", 111},
  {2.1246883722206001315335964e-32, 7, "2124688", -31},
  {1.0236351587966577376073746e-198, 4, "1024", -197},
  {2.8638103337308989781610126e+278, 7, "286381", 279},
  {1.2898627585964661165319663e+43, 12, "12898627586", 44},
  {5.6211824743779984977395865e+31, 10, "5621182474", 32},
  {1.3676455395829688747488320e+231, 15, "136764553958297", 232},
  {2.8121121682091097922629773e-10, 14, "28121121682091", -9},
  {4.3993584493024788441283565e+297, 7, "4399358", 298},
  {2.6895139611274791759118795e+296, 13, "2689513961127", 297},
  {9.0588935130662039043826941e+214, 9, "905889351", 215},
  {8.0659403320284998398000882e+279, 21, "80659403320284998398", 280},
  {3.4739521117078898148950045e-143, 11, "34739521117", -142},
  {1.7905851875980785105777336e-21, 3, "179", -20},
  {2.9626694329300740865652480e+254, 2, "3", 255},
  {4.4464968669483649605747668e-240, 1, "4", -239},
  {1.0889998255136820712482200e+210, 18, "108899982551368207", 211},
  {1.4607107051164667805703663e+74, 6, "146071", 75},
  {1.1061795482601411958878825e-252, 10, "1106179548", -251},
  {1.8446156003598940389618738e+295, 15, "184461560035989", 296},
  {6.1296247826344364688774086e+264, 21, "612962478263443646888", 265},
  {8.9099985564980317621543071e-17, 9, "890999856", -16},
  {4.5718107381658230981847426e-186, 2, "46", -185},
  {1.0531568686761218554070867e-16, 11, "10531568687", -15},
  {3.1753294069707206686275201e+207, 20, "31753294069707206686", 208},
  {1.6005586716820519057120820e+122, 12, "160055867168", 123},
  {1.9597441753964772655373340e+126, 13, "1959744175396", 127},
  {1.0518812386736738247999067e-09, 1, "1", -8},
  {2.1460418213066314148183817e+156, 12, "214604182131", 157},
  {7.5256959109671764368912442e+90, 20, "75256959109671764369", 91},
  {8.9926974641813821774442231e-139, 8, "89926975", -138},
  {6.9362094795060144389946996e-115, 8, "69362095", -114},
  {3.6745785388899790020472434e+69, 13, "367457853889", 70},
  {5.3429213474918708124063469e+49, 7, "5342921", 50},
  {5.5644556134518604710643846e+50, 5, "55645", 51},
  {1.3662765597383570697497821e+85, 2, "14", 86},
  {1.0216895120707243925406447e-120, 13, "1021689512071", -119},
  {4.8654486079942674900239418e+279, 20, "486544860799426749", 280},
  {9.2146570802613901145438272e+135, 20, "92146570802613901145", 136},
  {8.2672591398800048961196624e-152, 19, "8267259139880004896", -151},
  {5.9707671984629224097256919e+66, 9, "59707672", 67},
  {2.6673729546510952494954880e+109, 12, "266737295465", 110},
  {1.8926022868480399854509034e+174, 16, "189260228684804", 175},
  {3.6662384994866653175599785e+219, 19, "3666238499486665318", 220},
  {2.1829038222478968410762688e+39, 15, "21829038222479", 40},
  {8.0013113523088551012371662e-273, 21, "800131135230885510124", -272},
  {5.2327947177360715790195942e-103, 9, "523279472", -102},
  {2.3079250946192502695980165e+186, 3, "231", 187},
  {4.8479902926311955726010322e-51, 13, "4847990292631", -50},
  {2.9367445192911602319360000e+21, 21, "293674451929116023194", 22},
  {3.6251737019770140609604083e+262, 21, "362517370197701406096", 263},
  {1.0798228621932750523777902e-190, 1, "1", -189},
  {3.0852359429000114486232756e-207, 16, "3085235942900011", -206},
  {1.1943879929907221604884496e+159, 9, "119438799", 160},
  {7.2285426278666351708641687e-239, 7, "7228543", -238},
  {1.8307727752341656629277655e-220, 19, "1830772775234165663", -219},
  {3.4599283599560819903694702e-130, 12, "345992835996", -129},
  {3.5930728779404584614463518e-41, 19, "3593072877940458461", -40},
  {8.5949077367912808200016685e-307, 4, "8595", -306},
  {2.3588995374503769601337639e+274, 20, "23588995374503769601", 275},
  {6.3752442633586684241890907e+06, 15, "637524426335867", 7},
  {4.9056141414294003701726063e+186, 7, "4905614", 187},
  {4.7164189882613903815977919e+264, 16, "471641898826139", 265},
  {1.6626901278604890142123237e-121, 1, "2", -120},
  {2.3611689449856575502659094e-172, 7, "2361169", -171},
  {1.7416698573321554317524150e-279, 5, "17417", -278},
  {1.4134815962658674834528938e+04, 16, "1413481596265867", 5},
  {2.6067760377913969778004164e-50, 8, "2606776", -49},
  {1.0067878955333814503826880e-70, 12, "100678789553", -69},
  {6.8262843634552673407161445e+180, 18, "682628436345526734", 181},
  {7.9453400888012058042854713e+79, 21, "794534008880120580429", 80},
  {7.0337752477100224424029685e-65, 17, "70337752477100224", -64},
  {1.7219688259761089794392019e-12, 5, "1722", -11},
  {7.4903579357352652379776209e+298, 10, "7490357936", 299},
  {3.2235390634742581418088345e-219, 18, "322353906347425814", -218},
  {5.7802975210670656773385763e-232, 5, "57803", -231},
  {1.0530352675860882244777517e-216, 3, "105", -215},
  {3.7152501207276850871347925e+140, 12, "371525012073", 141},
  {9.2226603498667248000696320e+24, 10, "922266035", 25},
  {9.5784654244232266919862278e+86, 20, "9578465424423226692", 87},
  {7.3034546910216758966813064e+136, 13, "7303454691022", 137},
  {1.2276068300144801948560500e+113, 2, "12", 114},
  {2.1016462410909863107188425e+90, 16, "2101646241090986", 91},
  {3.1989767325209305674905659e-142, 21, "319897673252093056749", -141},
  {1.0539592292973015718026156e+279, 16, "1053959229297302", 280},
  {6.1741059295203414324718383e-227, 17, "61741059295203414", -226},
  {1.3825977973673866564403128e+166, 5, "13826", 167},
  {6.4137799133608697308562860e-37, 5, "64138", -36},
  {4.3029289513223250013849146e+126, 4, "4303", 127},
  {6.0051825959022257960790247e-111, 19, "6005182595902225796", -110},
  {7.6264702748564594545330795e+96, 6, "762647", 97},
  {3.0675886346637167682532379e-22, 16, "3067588634663717", -21},
  {3.1066625828188945392098935e+188, 18, "310666258281889454", 189},
  {6.8506533337436794240163700e+44, 16, "6850653333743679", 45},
  {4.6452951886591171758675622e-39, 18, "464529518865911718", -38},
  {2.5812708582580782389650968e-95, 12, "258127085826", -94},
  {5.1637089663651265733664390e-175, 8, "5163709", -174},
  {2.0230371152316763803983275e+214, 15, "202303711523168", 215},
  {2.2179049995060869021016952e-301, 8, "2217905", -300},
  {1.6245476057185394885627087e+35, 4, "1625", 36},
  {2.0707369003321627067566675e-217, 10, "20707369", -216},
  {1.2621589709462379884005678e+56, 21, "12621589709462379884", 57},
  {2.4294876631608585899857955e+117, 16, "2429487663160859", 118},
  {9.7003037925426836101361030e-96, 8, "97003038", -95},
  {9.0008282931534586105600297e-33, 6, "900083", -32},
  {2.6599767535289536062947328e+27, 10, "2659976754", 28},
  {1.1235389880809920731341176e+265, 17, "11235389880809921", 266},
  {6.0648130278355171998232181e+40, 15, "606481302783552", 41},
  {2.5802694990474863517175998e-138, 3, "258", -137},
  {1.4628364679743990213956148e+121, 9, "146283647", 122},
  {7.2551487015333258382528570e-34, 2, "73", -33},
  {2.1242940991955220466295127e+98, 5, "21243", 99},
  {2.9100010531133159700337950e-253, 13, "2910001053113", -252},
  {3.0534592005069459728853377e-123, 10, "3053459201", -122},
  {2.0393298717808527526676626e-224, 7, "203933", -223},
  {1.2174257351281428882384268e+82, 19, "1217425735128142888", 83},
  {1.0878725732196218182507657e+195, 15, "108787257321962", 196},
  {7.4296008850979875246341978e+250, 19, "7429600885097987525", 251},
  {2.0071928951175861402778686e-39, 12, "200719289512", -38},
  {1.9254875520138474422308379e-216, 11, "1925487552", -215},
  {3.7453224592789621603344419e-44, 21, "374532245927896216033", -43},
  {1.9103211525267247572936055e-07, 17, "19103211525267248", -6},
  {4.6386393485427574776809243e+305, 6, "463864", 306},
  {4.2406230298699568947995431e+02, 8, "4240623", 3},
  {1.9439405687589524679002968e+267, 8, "19439406", 268},
  {1.4405316793529764022883397e+261, 9, "144053168", 262},
  {6.0566778242365504890191953e-147, 9, "605667782", -146},
  {5.0612190024664154647326545e+166, 1, "5", 167},
  {1.6645115110567527645494584e+295, 9, "166451151", 296},
  {8.0526041079424060346189566e-103, 20, "80526041079424060346", -102},
  {3.6483869250234820960125392e-112, 14, "36483869250235", -111},
  {7.4470275794310245709555539e-243, 1, "7", -242},
  {9.3724046953992552117445555e+182, 6, "93724", 183},
  {6.0025647587094384917337163e-254, 20, "60025647587094384917", -253},
  {1.7981382669307318771819115e+298, 15, "179813826693073", 299},
  {2.1055814860715117234653308e-76, 13, "2105581486072", -75},
  {9.2228653704857838176383413e-32, 9, "922286537", -31},
  {2.7685257754134208497437276e-81, 17, "27685257754134208", -80},
  {6.1143254216095516741475506e+283, 5, "61143", 284},
  {2.4590051928397523528418052e+264, 5, "2459", 265},
  {5.7734520761903026580221967e-218, 7, "5773452", -217},
  {8.3878806923940533306449652e+05, 16, "8387880692394053", 6},
  {6.7242324495468751301629439e+154, 6, "672423", 155},
  {2.1029740287351233780615742e-240, 6, "210297", -239},
  {6.6478018540026354000428502e-222, 13, "6647801854003", -221},
  {1.9107853653573978646658049e+191, 10, "1910785365", 192},
  {5.3796644219035734034154696e+106, 18, "53796644219035734", 107},
  {6.2997149232971438746447632e-74, 11, "62997149233", -73},
  {6.1023861796816921516429887e-89, 16, "6102386179681692", -88},
  {2.2890412173060261142983874e-97, 14, "2289041217306", -96},
  {1.7361137531261156775522228e+81, 5, "17361", 82},
  {3.6425703563321816927697162e-78, 3, "364", -77},
  {2.1556091834934415817260742e+09, 18, "215560918349344158", 10},
  {1.6578120932321437749685876e-94, 12, "165781209323", -93},
  {3.7326666141898234232086843e-303, 11, "37326666142", -302},
  {1.8845696928838031568281376e+240, 13, "1884569692884", 241},
  {1.3680293406663387401553481e-210, 8, "13680293", -209},
  {8.6721494407505544371297881e+39, 18, "867214944075055444", 40},
  {1.5487400772253190916309760e-299, 16, "1548740077225319", -298},
  {1.2117610084838189745074784e+198, 16, "1211761008483819", 199},
  {2.3749179735235159456426583e+237, 12, "237491797352", 238},
  {5.8205516148304633824033133e-213, 5, "58206", -212},
  {3.6989422041929142303354305e+109, 11, "36989422042", 110},
  {6.0328580440995565368211828e+03, 10, "6032858044", 4},
  {2.0369844661976249694824219e+10, 2, "2", 11},
  {3.0223723545082861384312567e-128, 19, "3022372354508286138", -127},
  {3.7754056829773281707994692e+38, 18, "377540568297732817", 39},
  {6.0705305364764935608899803e+85, 1, "6", 86},
  {8.9827989488753601949233695e+187, 2, "9", 188},
  {5.7052905693486941918474994e-58, 11, "57052905693", -57},
  {9.8515269097780397443952433e-117, 14, "9851526909778", -116},
  {1.0553469336973667569173509e+115, 17, "10553469336973668", 116},
  {4.1240044884453286593247124e-244, 19, "4124004488445328659", -243},
  {9.0089329584215121825254050e-79, 9, "900893296", -78},
  {1.5654027357974603017789895e+184, 16, "156540273579746", 185},
  {9.6704575766283182666955107e-21, 12, "967045757663", -20},
  {3.3357410306805998573205663e-273, 4, "3336", -272},
  {2.7167285403686465567806567e-90, 20, "27167285403686465568", -89},
  {1.0331235960637479817478689e-128, 6, "103312", -127},
  {7.0125669876142379410996890e-44, 15, "701256698761424", -43},
  {2.6019476298017690358587293e-284, 16, "2601947629801769", -283},
  {1.8280625249496505648872252e+236, 20, "18280625249496505649", 237},
  {1.2698193133143506105138861e+105, 21, "126981931331435061051", 106},
  {9.4787381344155714422951452e+288, 11, "94787381344", 289},
  {4.8549233767132924363833493e-130, 5, "48549", -129},
  {3.2583482000876727426721887e-281, 8, "32583482", -280},
  {1.6533105148906432365479111e-153, 8, "16533105", -152},
  {1.6365149310747680429742904e-159, 1, "2", -158},
  {5.4859732471997827779702479e-197, 9, "548597325", -196},
  {7.8650146448357574148800504e+124, 13, "7865014644836", 125},
  {6.3667521461668007116800000e+20, 14, "63667521461668", 21},
  {5.6723349269334475426964909e+221, 14, "56723349269334", 222},
  {1.3930309959458269610990240e-248, 20, "13930309959458269611", -247},
  {5.7075599556885981477294985e+156, 17, "57075599556885981", 157},
  {1.6903256834971852162449421e-299, 5, "16903", -298},
  {3.6805611956002493615698716e-18, 2, "37", -17},
  {8.5587976603090038384366679e+281, 20, "85587976603090038384", 282},
  {1.6214149863597622961605716e-16, 14, "16214149863598", -15},
  {4.2678753227220104287912958e-44, 15, "426787532272201", -43},
  {5.4425728314174972705100311e+65, 18, "544257283141749727", 66},
  {4.3888888350224444688482343e-74, 11, "4388888835", -73},
  {8.9208386998101514014092422e-174, 21, "892083869981015140141", -173},
  {1.1648422855935968609505822e+212, 11, "11648422856", 213},
  {6.8803628250402081816347728e+139, 20, "68803628250402081816", 140},
  {6.8735809215130851874973620e-68, 16, "6873580921513085", -67},
  {3.7979663935388103329538104e-210, 5, "3798", -209},
  {5.5276746899488690889933791e-72, 12, "552767468995", -71},
  {1.2861151035643999292814463e+181, 19, "1286115103564399929", 182},
  {8.8281460786047420251443677e+243, 10, "8828146079", 244},
  {3.9785345460136684680536913e-15, 2, "4", -14},
  {1.0246279504180068847453292e+271, 4, "1025", 272},
  {1.8462677162891279890191738e-60, 15, "184626771628913", -59},
  {6.0939802817304514487355528e+183, 8, "60939803", 184},
  {5.8590388022558265906977836e+150, 7, "5859039", 151},
  {3.0675429415805435695574488e+01, 12, "306754294158", 2},
  {4.1013342380701164098099376e+254, 1, "4", 255},
  {8.8104332672738146972656250e+11, 8, "88104333", 12},
  {1.3103413524983247756958008e+10, 11, "13103413525", 11},
  {3.6512303405262769802052406e-225, 11, "36512303405", -224},
  {9.7811804436178649088000000e+19, 14, "97811804436179", 20},
  {1.4697536349350455061440357e-108, 9, "146975363", -107},
  {4.7918250494632890238109751e+64, 10, "4791825049", 65},
  {5.8673426016036069253857484e+235, 15, "586734260160361", 236},
  {7.9242616107224587046097824e+166, 1, "8", 167},
  {1.3538368152153675407685416e-252, 19, "1353836815215367541", -251},
  {6.1407507552376595320127710e-254, 12, "614075075524", -253},
  {9.8499924847693091816683917e+36, 15, "984999248476931", 37},
  {9.9447329444187124487157697e-60, 5, "99447", -59},
  {2.2141919176761710058018186e-172, 20, "22141919176761710058", -171},
  {1.3368690685055721875000000e+14, 8, "13368691", 15},
  {3.1616805273316799948371622e+279, 21, "316168052733167999484", 280},
  {6.6299536815437677819077523e-301, 9, "662995368", -300},
  {2.2036942271150733397337537e-101, 7, "2203694", -100},
  {1.1948731542841304133938777e-158, 17, "11948731542841304", -157},
  {1.7032500556312585608461693e+195, 2, "17", 196},
  {2.6396898310398829505581695e-10, 6, "263969", -9},
  {6.2531728242334054480418058e-297, 13, "6253172824233", -296},
  {1.2128976456708091512235110e-110, 6, "12129", -109},
  {3.4120466718254540639161300e-233, 9, "341204667", -232},
  {2.4618550210744956558800869e-269, 11, "24618550211", -268},
  {5.0936490983295098163997119e+118, 11, "50936490983", 119},
  {6.0529434793841606006026268e+05, 13, "6052943479384", 6},
  {1.7984522536268030375177196e-249, 14, "17984522536268", -248},
  {1.7108400385873695900498775e-81, 10, "1710840039", -80},
  {2.0679659698340446391089363e-67, 13, "2067965969834", -66},
  {5.2925731612561545075913669e-132, 3, "529", -131},
  {2.1039550027718000211884222e+131, 7, "2103955", 132},
  {3.7775476633081512039243962e+250, 14, "37775476633082", 251},
  {8.3821365608784341110843638e+270, 15, "838213656087843", 271},
  {5.6500695005202887490730029e+298, 11, "56500695005", 299},
  {2.0406792405311990662615529e-04, 11, "20406792405", -3},
  {1.7306114406603907012537640e-92, 18, "17306114406603907", -91},
  {6.7022681553383557698813260e+118, 1, "7", 119},
  {3.7904147555139776294069605e+158, 17, "37904147555139776", 159},
  {5.8647302418109636107582914e-304, 11, "58647302418", -303},
  {1.7560158726168497082573480e-131, 11, "17560158726", -130},
  {2.3003104517244800089602364e+78, 15, "230031045172448", 79},
  {1.2066132228677234591089485e-253, 6, "120661", -252},
  {1.2098801732839790677492697e+59, 9, "120988017", 60},
  {2.3657497471316564834502922e-25, 9, "236574975", -24},
  {3.7487112353651600379361476e+224, 16, "374871123536516", 225},
  {2.1876979904514541195618368e+107, 7, "2187698", 108},
  {1.6138025475891703614828673e-183, 8, "16138025", -182},
  {1.4165960016812199244763403e-196, 19, "1416596001681219924", -195},
  {3.5403400811060011891132024e-306, 2, "35", -305},
  {1.1904120727113121823577317e+237, 7, "1190412", 238},
  {2.8840110059336510187914142e-303, 19, "2884011005933651019", -302},
  {1.4453287298327915605663564e+64, 12, "144532872983", 65},
  {7.9395254191407107474094337e-132, 19, "7939525419140710747", -131},
  {5.6746711017108645146978568e-269, 13, "5674671101711", -268},
  {7.5835641092505099935981762e-96, 11, "75835641093", -95},
  {5.3351699648417508930291282e+222, 4, "5335", 223},
  {5.8896640857389089622367261e-192, 13, "5889664085739", -191},
  {4.5539923557747987742561158e-161, 7, "4553992", -160},
  {1.5449219846339843258409297e-212, 14, "1544921984634", -211},
  {7.9008548151397307848060592e-272, 14, "79008548151397", -271},
  {1.5082741446587989099349011e+187, 9, "150827414", 188},
  {3.0360046410699469682319483e+202, 7, "3036005", 203},
  {2.3246910815452713724889760e+133, 16, "2324691081545271", 134},
  {7.4727482684016963290020163e-165, 2, "75", -164},
  {2.2017525838630528258894050e-218, 15, "220175258386305", -217},
  {7.1661991550934293773088392e+53, 10, "7166199155", 54},
  {9.0845105260682639382027569e+94, 15, "908451052606826", 95},
  {2.7947512126982685396726785e+262, 11, "27947512127", 263},
  {1.5774818561978138087551666e+122, 20, "15774818561978138088", 123},
  {1.6164629677586946947096207e+216, 5, "16165", 217},
  {1.4580819704757770188417045e-263, 16, "1458081970475777", -262},
  {4.1333087472773608371462451e+271, 10, "4133308747", 272},
  {2.8328517867394453633492429e+284, 12, "283285178674", 285},
  {1.4495970197460957045719040e+24, 21, "144959701974609570457", 25},
  {7.9247928935852585378424631e-168, 14, "79247928935853", -167},
  {5.5096286808259777233677250e+107, 13, "5509628680826", 108},
  {4.8307287134144270232482490e-199, 17, "4830728713414427", -198},
  {4.3135492518454959187951616e+25, 11, "43135492518", 26},
  {5.4882762724851100065856526e+49, 19, "5488276272485110007", 50},
  {1.4882211790091924186185679e+01, 5, "14882", 2},
  {1.2778796389040438519687846e-161, 19, "1277879638904043852", -160},
  {2.6547661605667468522629086e+272, 17, "26547661605667469", 273},
  {5.6078991910976073576441104e-168, 5, "56079", -167},
  {3.9489419203335991119052800e+23, 3, "395", 24},
  {1.4279397456204020642499326e-234, 20, "14279397456204020642", -233},
  {1.8392739306675523519515991e+08, 11, "18392739307", 9},
  {4.7190116945841876323122395e-287, 19, "4719011694584187632", -286},
  {8.4070802837114319396975607e+242, 20, "84070802837114319397", 243},
  {2.0337372016762458297810976e+290, 10, "2033737202", 291},
  {1.8817046512002429022010083e+297, 4, "1882", 298},
  {4.2912162821736381626838337e+189, 20, "42912162821736381627", 190},
  {7.8088914531488423031268823e+121, 15, "780889145314884", 122},
  {1.6266920832514976295815139e+294, 20, "16266920832514976296", 295},
  {7.4809338881348816308789880e+40, 3, "748", 41},
  {2.3803706252701038707380794e-252, 15, "23803706252701", -251},
  {1.4035058941693563217271951e+126, 11, "14035058942", 127},
  {7.8610886587661509159041225e-113, 11, "78610886588", -112},
  {1.4018829289860317311393097e-162, 2, "14", -161},
  {5.2875531614012648127473683e+62, 1, "5", 63},
  {4.8378197105221586889961243e+198, 18, "483781971052215869", 199},
  {4.1569835965534671096583453e+101, 1, "4", 102},
  {2.3934126804199105468944610e+91, 18, "239341268041991055", 92},
  {7.0651495691033201304355084e+292, 9, "706514957", 293},
  {6.5318111698979460786580705e+76, 1, "7", 77},
  {1.3689814292943319325252588e+219, 9, "136898143", 220},
  {1.1130640180328572392142084e+98, 7, "1113064", 99},
  {6.1496954294350591392433088e+202, 8, "61496954", 203},
  {1.3158684091056818299142856e+187, 15, "131586840910568", 188},
  {1.1619867447983355568362881e-207, 15, "116198674479834", -206},
  {3.1059829231963718153676300e-242, 3, "311", -241},
  {1.7613949736215147382517255e-196, 9, "176139497", -195},
  {1.1143820880856891733695533e-154, 16, "1114382088085689", -153},
  {1.3024676646895482501293123e-255, 16, "1302467664689548", -254},
  {6.4008144265750991353023843e-255, 16, "6400814426575099", -254},
  {5.0346125777059409023965738e+166, 7, "5034613", 167},
  {5.8407567869895490117645437e+296, 21, "584075678698954901176", 297},
  {3.2546166229821557201128845e-231, 15, "325461662298216", -230},
  {4.0679222497200714817810793e+259, 10, "406792225", 260},
  {2.2169313262706148166404096e-219, 12, "221693132627", -218},
  {7.8551533729886458846859280e-225, 14, "78551533729886", -224},
  {4.2617847329947527624787116e+61, 13, "4261784732995", 62},
  {5.7087525895205236258237293e+45, 2, "57", 46},
  {1.2368476559347626245720640e+43, 6, "123685", 44},
  {3.6905544301848246887884560e-243, 18, "369055443018482469", -242},
  {1.6048281961166184491543548e+173, 5, "16048", 174},
  {2.0281713312887966003546103e+306, 18, "20281713312887966", 307},
  {5.1198798771551034186692824e+250, 3, "512", 251},
  {7.7578907737485797056491229e-70, 6, "775789", -69},
  {4.7995585872827280000000000e+16, 13, "4799558587283", 17},
  {3.3251493795912794767663550e-235, 13, "3325149379591", -234},
  {3.2891595789317206890841713e+65, 9, "328915958", 66},
  {1.7462285617881671647476435e-156, 11, "17462285618", -155},
  {1.0593087607949469238519669e+07, 20, "10593087607949469239", 8},
  {2.6728388990618739530658163e-36, 16, "2672838899061874", -35},
  {3.1149407398009862900800545e-48, 21, "311494073980098629008", -47},
  {2.0527642671566995430904363e-194, 20, "20527642671566995431", -193},
  {4.4826197871509333630446056e-298, 5, "44826", -297},
  {2.1822512014441985328141573e-247, 9, "21822512", -246},
  {1.7811574446035025762830431e-10, 6, "178116", -9},
  {6.0852549458741594337090944e-25, 15, "608525494587416", -24},
  {3.6732842096009181987907595e-168, 1, "4", -167},
  {1.0321149676075251206631930e-99, 4, "1032", -98},
  {2.4541396890436964298585702e-280, 5, "24541", -279},
  {1.5925268105454071707082564e+260, 7, "1592527", 261},
  {5.5896946177336778513368496e+31, 17, "55896946177336779", 32},
  {3.6281950254740940694703680e-90, 8, "3628195", -89},
  {1.0537370637177943169608478e-85, 5, "10537", -84},
  {3.1475458723303586975892875e+203, 12, "314754587233", 204},
  {7.8505532514497745797211203e+302, 2, "79", 303},
  {1.4381789747515444539302601e-245, 9, "143817897", -244},
  {1.4561733764433580205761243e+256, 15, "145617337644336", 257},
  {1.7199206880752400011477986e+109, 13, "1719920688075", 110},
  {1.6230260552803907736094089e-160, 13, "162302605528", -159},
  {2.2728228381476451858134169e+01, 10, "2272822838", 2},
  {5.2905907310709661961467417e-89, 12, "529059073107", -88},
  {5.7672449874375460976276275e+26, 20, "57672449874375460976", 27},
  {2.0430005325706293170838268e+304, 1, "2", 305},
  {5.4359154385871704228178090e-45, 20, "54359154385871704228", -44},
  {3.5200303836178344589926915e-186, 8, "35200304", -185},
  {1.5667280246065718125108082e-124, 7, "1566728", -123},
  {1.9006372236555032904191042e+95, 4, "1901", 96},
  {4.5589325702244140448693484e-106, 17, "4558932570224414", -105},
  {5.1287267946681516667101719e+291, 13, "5128726794668", 292},
  {1.3117576086444815978212836e+123, 1, "1", 124},
  {2.4842807455716367341080307e-126, 13, "2484280745572", -125},
  {1.9354539987896019101656000e+280, 4, "1935", 281},
  {2.6014331534524423489283719e+253, 9, "260143315", 254},
  {1.6214167468952739017282808e-239, 15, "162141674689527", -238},
  {1.0209826217206166501047114e+89, 17, "10209826217206167", 90},
  {9.9949307667296557419112847e-215, 3, "999", -214},
  {6.2592476036894297187134444e-249, 12, "625924760369", -248},
  {5.2984524720778378808950961e-110, 10, "5298452472", -109},
  {1.3717820957819262143708002e-291, 8, "13717821", -290},
  {1.3678762164095035264751704e+210, 11, "13678762164", 211},
  {8.0685231495246220800000000e+17, 19, "806852314952462208", 18},
  {9.1691620500351717320185592e-123, 19, "9169162050035171732", -122},
  {2.0474057076235103919811154e-240, 19, "2047405707623510392", -239},
  {1.0745000519280658219003790e-218, 20, "10745000519280658219", -217},
  {4.3143997206049833489400510e-172, 9, "431439972", -171},
  {7.1497232717678742747788404e+127, 5, "71497", 128},
  {7.0129316812551736568251913e+216, 13, "7012931681255", 217},
  {1.5040204012043690303892062e-14, 2, "15", -13},
  {1.2406399876933944180991027e+304, 7, "124064", 305},
  {4.8276998951616712783145323e+126, 16, "4827699895161671", 127},
  {1.2524296259426623432452131e+151, 5, "12524", 152},
  {9.8085911762337852497706855e-240, 8, "98085912", -239},
  {8.8019639506462739183099573e-297, 6, "880196", -296},
  {1.8753998377603517231156989e-158, 21, "187539983776035172312", -157},
  {4.0241506961838176498733093e+198, 17, "40241506961838176", 199},
  {6.2185746304091438133473058e-275, 4, "6219", -274},
  {1.4982313156290573470646176e-119, 21, "149823131562905734706", -118},
  {1.9128442526764950339347253e+100, 12, "191284425268", 101},
  {3.1523425307725736896305880e+65, 19, "315234253077257369", 66},
  {1.9039038748289036448113620e+04, 18, "190390387482890364", 5},
  {2.0226445592191516954682819e-144, 18, "20226445592191517", -143},
  {9.6286398891679904999652188e+147, 19, "96286398891679905", 148},
  {1.4917141382564265733587633e-133, 3, "149", -132},
  {9.1366742605771334587865706e-244, 14, "91366742605771", -243},
  {7.8843533959262077729704536e-246, 15, "788435339592621", -245},
  {1.6441217723612309943390549e+233, 17, "1644121772361231", 234},
  {3.7419738605903829356338312e-112, 3, "374", -111},
  {4.1775340992932070701946777e-221, 1, "4", -220},
  {4.0035975130386465991761676e+107, 6, "40036", 108},
  {1.1215544933695727954300232e+80, 8, "11215545", 81},
  {6.2656049491805536407607892e+78, 16, "6265604949180554", 79},
  {9.5799588370012076324454886e-145, 7, "9579959", -144},
  {6.6767984509760935357539881e+47, 20, "66767984509760935358", 48},
  {9.0216275875855133157035692e+45, 14, "90216275875855", 46},
  {1.2367491093745145505823320e+303, 5, "12367", 304},
  {5.5060241419587772141101224e-208, 8, "55060241", -207},
  {2.9000687195597886308357659e-285, 2, "29", -284},
  {2.2170865655906744269624063e+157, 21, "221708656559067442696", 158},
  {8.7929942820150524020694676e-249, 12, "879299428202", -248},
  {3.0016657549466572271479619e+196, 11, "30016657549", 197},
  {1.6151859491389201212152571e-02, 15, "161518594913892", -1},
  {3.1127236479573736154749104e-133, 13, "3112723647957", -132},
  {2.1902728342492307474828215e-69, 17, "21902728342492307", -68},
  {3.8415606325172076248658356e-290, 16, "3841560632517208", -289},
  {1.0491831406579888499724105e+172, 4, "1049", 173},
  {2.3626547587907470542281716e-181, 16, "2362654758790747", -180},
  {9.1561831447206725942050736e-288, 14, "91561831447207", -287},
  {3.7210130903571313130567847e-71, 21, "372101309035713131306", -70},
  {3.2080408185097481545780345e-293, 20, "32080408185097481546", -292},
  {1.0617871648288499558776270e-254, 4, "1062", -253},
  {2.1368709162064911546032599e-144, 15, "213687091620649", -143},
  {2.7937683635700060556029750e+170, 3, "279", 171},
  {3.4276337186450522073199164e-104, 9, "342763372", -103},
  {2.4063305190181163848135330e+191, 5, "24063", 192},
  {6.3393233259970018788794316e-68, 15, "6339323325997", -67},
  {2.5827772625040728243607330e-191, 15, "258277726250407", -190},
  {8.9999594581327733171401084e-165, 16, "8999959458132773", -164},
  {1.3909536517847797427983212e+58, 16, "139095365178478", 59},
  {1.0348125174281016694288616e-48, 10, "1034812517", -47},
  {7.4486361167182150240672917e-220, 1, "7", -219},
  {7.1826944836616319383471394e+81, 10, "7182694484", 82},
  {9.9522331926362664636737161e+69, 20, "99522331926362664637", 70},
  {1.8663700395239099650151995e-137, 2, "19", -136},
  {7.5414298426842188928276300e+05, 3, "754", 6},
  {1.7968993711447133625256222e+84, 17, "17968993711447134", 85},
  {5.6261708344398136531640279e+210, 19, "5626170834439813653", 211},
  {2.0843801401648808667441094e-274, 5, "20844", -273},
  {6.7785328916510336000000000e+17, 18, "67785328916510336", 18},
  {5.0749464194617385180177425e-190, 3, "507", -189},
  {5.7857725622000111050486394e-184, 17, "57857725622000111", -183},
  {8.0784145522524283933307743e+02, 11, "80784145523", 3},
  {3.4999792355300262928268670e+42, 14, "349997923553", 43},
  {4.1904450699018060102343672e-161, 11, "41904450699", -160},
  {2.6088104250305762722475511e-102, 13, "2608810425031", -101},
  {2.5801606325394088217745427e+216, 20, "25801606325394088218", 217},
  {2.9737996021617474585102994e-235, 11, "29737996022", -234},
  {9.3872156210267790525241574e+216, 20, "93872156210267790525", 217},
  {5.4979032372091647400267755e+132, 5, "54979", 133},
  {9.6317696516394615561405867e-56, 4, "9632", -55},
  {1.0331746876986758079556503e+203, 13, "1033174687699", 204},
  {1.7781407471692387942803534e+111, 4, "1778", 112},
  {1.0035081007314925030842273e+94, 6, "100351", 95},
  {1.1168856108253225114249905e+118, 2, "11", 119},
  {1.2544774221105702063305212e-300, 7, "1254477", -299},
  {1.4352545067706002339932856e-260, 21, "143525450677060023399", -259},
  {5.3726063505292895337775049e-177, 5, "53726", -176},
  {3.4130929339575691752273554e+238, 1, "3", 239},
  {3.1143352373589630814535430e-260, 3, "311", -259},
  {3.4375475432241322828669428e+41, 21, "343754754322413228287", 42},
  {7.5767765095003338283434019e-168, 16, "7576776509500334", -167},
  {2.0110879388910292414401517e+46, 9, "201108794", 47},
  {1.5196383692028567841201839e-60, 14, "15196383692029", -59},
  {1.3175807373188342306629329e-174, 8, "13175807", -173},
  {6.2879823653208119021099038e+90, 2, "63", 91},
  {1.4102561612877403918337284e-14, 13, "1410256161288", -13},
  {4.2770867095735120089878871e-60, 19, "4277086709573512009", -59},
  {2.5861478063812984211079915e+203, 20, "25861478063812984211", 204},
  {1.9510559356032891090506423e-155, 20, "19510559356032891091", -154},
  {1.5951221244795260256818549e+283, 6, "159512", 284},
  {1.6311080291648789471230047e+124, 15, "163110802916488", 125},
  {2.9906044681702457774839064e-69, 18, "299060446817024578", -68},
  {6.9304661829873720426275870e+286, 14, "69304661829874", 287},
  {8.5382539545298533410444352e-222, 13, "853825395453", -221},
  {2.8754291201207286902227398e+142, 12, "287542912012", 143},
  {3.7747903194678965856655072e+35, 21, "377479031946789658567", 36},
  {5.1156892995230337558086785e+35, 8, "51156893", 36},
  {3.7212463232481621957285373e-100, 19, "3721246323248162196", -99},
  {3.4504393027746646876698225e-127, 21, "345043930277466468767", -126},
  {4.2667008160464934933285306e+157, 13, "4266700816046", 158},
  {2.4962990936967885952352320e+59, 9, "249629909", 60},
  {2.5107374825580601538087869e+237, 18, "251073748255806015", 238},
  {2.1526710452597332542215188e+80, 8, "2152671", 81},
  {5.1104761274164140522830902e+176, 6, "511048", 177},
  {5.0617287689913020734700857e-226, 15, "50617287689913", -225},
  {9.0314274748583641407832657e+218, 9, "903142747", 219},
  {1.6327548749488019237114045e+295, 10, "1632754875", 296},
  {2.0988353422675494923108783e-89, 10, "2098835342", -88},
  {3.6703808061644062376347986e-65, 14, "36703808061644", -64},
  {2.2455352174212938593081446e+65, 15, "224553521742129", 66},
  {1.9141447792634186772787259e-157, 3, "191", -156},
  {2.9714860333089917045736806e-137, 13, "2971486033309", -136},
  {1.4126616398652327653712690e-302, 3, "141", -301},
  {6.0020946310573159197945962e+141, 7, "6002095", 142},
  {3.2344516320208639304127476e+105, 15, "323445163202086", 106},
  {3.5366535683827807906576268e-03, 12, "353665356838", -2},
  {2.0490818210492477318234986e-113, 10, "2049081821", -112},
  {7.1378191682275019014120804e+228, 6, "713782", 229},
  {1.2069018579769295001008135e-162, 11, "1206901858", -161},
  {1.1594455810680034946180683e-01, 10, "1159445581", 0},
  {3.2725775477131202817264798e+161, 3, "327", 162},
  {1.0320646842721162957789600e+281, 3, "103", 282},
  {1.2027612261436252064273524e+53, 15, "120276122614363", 54},
  {1.8809327797684023758291529e+200, 19, "1880932779768402376", 201},
  {4.1802225369982904365649205e-286, 20, "41802225369982904366", -285},
  {5.3292616324591664372090913e+90, 10, "5329261632", 91},
  {5.0774052514350361156624562e+143, 21, "507740525143503611566", 144},
  {1.5533404767449307925674764e+147, 13, "1553340476745", 148},
  {2.3715671931570912289563139e+76, 6, "237157", 77},
  {5.5555678559079175190576942e-183, 20, "55555678559079175191", -182},
  {2.0246047562418612261118978e+105, 20, "20246047562418612261", 106},
  {2.4610478641941046306984259e+230, 8, "24610479", 231},
  {3.0457032606927739787635926e-214, 15, "304570326069277", -213},
  {8.9077612884104596812546949e-189, 13, "890776128841", -188},
  {7.7819908797419068997301165e-143, 12, "778199087974", -142},
  {6.5104652419137597440000000e+18, 2, "65", 19},
  {2.5835653299832744437420684e-259, 11, "258356533", -258},
  {4.1278674234211994380823499e+93, 10, "4127867423", 94},
  {6.6308484185672945401783500e-147, 21, "663084841856729454018", -146},
  {5.2114929806027771374183968e-169, 9, "521149298", -168},
  {4.4105541784432495526345144e+248, 21, "441055417844324955263", 249},
  {2.1239145729459342959679858e-207, 17, "21239145729459343", -206},
  {2.4706351846564724242330419e+26, 9, "247063518", 27},
  {4.4497758641997566912554045e+189, 1, "4", 190},
  {1.7138217020830557476716074e+198, 11, "17138217021", 199},
  {6.8032811433058798224212676e-244, 11, "68032811433", -243},
  {1.0701602892211362600350899e+167, 15, "107016028922114", 168},
  {1.6024081485643488208378656e+236, 10, "1602408149", 237},
  {8.1185851089948128349312782e-47, 18, "811858510899481283", -46},
  {5.2380079041519454797178595e+154, 6, "523801", 155},
  {2.3967573249894848855044784e+28, 17, "23967573249894849", 29},
  {2.1278865735987750754685917e+127, 7, "2127887", 128},
  {1.9786843862054934565177660e-225, 19, "1978684386205493457", -224},
  {1.4487435785828216392645894e-301, 11, "14487435786", -300},
  {4.7190433385709440879922746e-209, 13, "4719043338571", -208},
  {2.8466126613997027746215149e-266, 4, "2847", -265},
  {2.1908780905546488981112944e-92, 13, "2190878090555", -91},
  {1.9413506223238485221218252e-178, 8, "19413506", -177},
  {1.9928791915287601580406114e+256, 6, "199288", 257},
  {2.1783147568037480706271890e+263, 19, "2178314756803748071", 264},
  {8.0550702536632522126118595e+225, 5, "80551", 226},
  {3.1196954957615015223913049e-289, 20, "31196954957615015224", -288},
  {3.8311174027148218888888957e-81, 2, "38", -80},
  {1.8617531811014091443064741e+92, 10, "1861753181", 93},
  {5.1420808037537408254473831e+116, 13, "5142080803754", 117},
  {1.6274720084139962619582333e-254, 6, "162747", -253},
  {1.2481983957376295262179383e+240, 16, "124819839573763", 241},
  {1.2124708286616300095611747e+236, 7, "1212471", 237},
  {2.9956449667188032182440576e+51, 10, "2995644967", 52},
  {1.1588014993616736661089443e-16, 1, "1", -15},
  {8.7169631333215663082052076e-26, 1, "9", -25},
  {3.3801908245866768181770577e-191, 17, "33801908245866768", -190},
  {1.1033363237721151438969406e+39, 19, "1103336323772115144", 40},
  {3.2132639372653711388475432e-139, 13, "3213263937265", -138},
  {2.9587012301133809832903366e-154, 20, "29587012301133809833", -153},
  {5.3622886519599279038406817e-262, 21, "536228865195992790384", -261},
  {2.7440455298664576469785645e-161, 14, "27440455298665", -160},
  {4.6846556494794956474802709e-55, 5, "46847", -54},
  {1.6337211183925817110960583e-225, 13, "1633721118393", -224},
  {4.1119077817994882446743850e-92, 18, "411190778179948824", -91},
  {2.3407783525239112147119043e+208, 10, "2340778353", 209},
  {6.1311380640343275961342647e-58, 14, "61311380640343", -57},
  {4.1539864057760447995017005e+37, 19, "41539864057760448", 38},
  {2.8617914123853339595703845e+28, 9, "286179141", 29},
  {7.3599637295280888776960581e-130, 5, "736", -129},
  {1.0508892963069606189283979e-142, 12, "105088929631", -141},
  {1.3083779764220138188706513e+235, 17, "13083779764220138", 236},
  {5.4610122921273471843886504e-112, 1, "5", -111},
  {2.1525616164965252388574187e-215, 14, "21525616164965", -214},
  {1.1423251518548815200082739e+100, 1, "1", 101},
  {5.8168119896543767026741989e+03, 7, "5816812", 4},
  {1.1842990519436727874929859e+260, 4, "1184", 261},
  {1.1891133879845904995813199e-11, 14, "11891133879846", -10},
  {6.3371007961266097854960414e-138, 16, "633710079612661", -137},
  {8.9416668658741943692695351e-223, 17, "89416668658741944", -222},
  {3.1852204683521945894973302e-201, 13, "3185220468352", -200},
  {1.3667133662991044921875000e+13, 18, "136671336629910449", 14},
  {9.9656890074123394566018089e-70, 9, "996568901", -69},
  {6.2264201180365303229140102e+234, 11, "6226420118", 235},
  {1.4493833411994604352610188e-135, 18, "144938334119946044", -134},
  {5.3636524171524187151219934e-94, 8, "53636524", -93},
  {4.8177306533859330486436931e-269, 16, "4817730653385933", -268},
  {2.4882450539439616667500226e-135, 18, "248824505394396167", -134},
  {1.9914954870180623391347940e-53, 3, "199", -52},
  {6.3078787639013197602536879e+202, 13, "6307878763901", 203},
  {7.7790259620128582492865858e-91, 9, "777902596", -90},
  {5.6119474892735482172559694e+170, 14, "56119474892735", 171},
  {3.8320115160603003956607411e-229, 14, "38320115160603", -228},
  {3.2212590051014256375709144e-142, 5, "32213", -141},
  {6.2191269178489797410370333e+254, 12, "621912691785", 255},
  {2.2701979416439747271921540e-204, 20, "22701979416439747272", -203},
  {1.1772960500044217405472203e-244, 5, "11773", -243},
  {4.7563772042847385527945779e+83, 15, "475637720428474", 84},
  {3.9838092139055300465599741e-168, 12, "398380921391", -167},
  {1.1672790562444935665141640e+128, 10, "1167279056", 129},
  {1.9217572412311104124435258e-224, 14, "19217572412311", -223},
  {4.2668903555610431340292986e-185, 6, "426689", -184},
  {1.1127634495099094149956293e+37, 14, "11127634495099", 38},
  {3.1782362896584532092119617e-172, 16, "3178236289658453", -171},
  {1.1028523709398064377231947e-188, 11, "11028523709", -187},
  {6.4709649190624399160653939e-46, 7, "6470965", -45},
  {1.8854148633011872493898519e+146, 11, "18854148633", 147},
  {4.8526528291384797024779469e+294, 12, "485265282914", 295},
  {1.4521278286893788478665122e-40, 14, "14521278286894", -39},
  {2.0580628600092136169398772e+228, 10, "205806286", 229},
  {9.5596553620036603809465999e+68, 2, "96", 69},
  {6.1345332798615255911736208e+193, 12, "613453327986", 194},
  {1.0271940928857386507667829e+132, 8, "10271941", 133},
  {5.8648804031733756380409729e+34, 20, "5864880403173375638", 35},
  {1.7780185800605076559321052e+52, 4, "1778", 53},
  {4.7834671223261958958220505e+57, 12, "478346712233", 58},
  {2.7583132789301099542728736e+135, 16, "275831327893011", 136},
  {4.8544304341831925914059120e+291, 14, "48544304341832", 292},
  {2.1136815776162648200988770e+09, 20, "21136815776162648201", 10},
  {9.7507375316478095978515718e-103, 20, "97507375316478095979", -102},
  {2.8510600784023986091216777e-266, 16, "2851060078402399", -265},
  {1.4900990714102483913005462e-259, 20, "14900990714102483913", -258},
  {1.4707637036978456243223008e-253, 21, "147076370369784562432", -252},
  {8.6917720967707439355171560e-57, 8, "86917721", -56},
  {1.9992566484794785150115547e+178, 4, "1999", 179},
  {2.9692842783426051864757261e-165, 13, "2969284278343", -164},
  {2.8039382731244517188656771e-16, 13, "2803938273124", -15},
  {3.8837010705766109530037055e-39, 15, "388370107057661", -38},
  {1.0088488554816265718727664e+02, 15, "100884885548163", 3},
  {1.3455976357240011632294463e+107, 10, "1345597636", 108},
  {9.4775930207174194190963482e+271, 13, "9477593020717", 272},
  {5.0068285297774096527880428e-270, 18, "500682852977740965", -269},
  {7.2871702917813810471432975e+105, 1, "7", 106},
  {1.2148793950227659015916142e-296, 2, "12", -295},
  {1.3327815215661614080000000e+18, 4, "1333", 19},
  {2.9419885980142371684355469e-110, 18, "294198859801423717", -109},
  {6.1666588558425391403075141e-125, 14, "61666588558425", -124},
  {3.1578095819048109169592712e-164, 10, "3157809582", -163},
  {8.1763621278419155533984950e+206, 14, "81763621278419", 207},
  {1.9647404730446450658869786e+295, 5, "19647", 296},
  {5.3541811853036759641011841e-210, 5, "53542", -209},
  {3.0387789296182220384540883e+62, 3, "304", 63},
  {9.1997570460892944335937500e+11, 3, "92", 12},
  {8.8092693279209985877183185e-285, 9, "880926933", -284},
  {4.0858404276639208838953663e+156, 9, "408584043", 157},
  {2.4390519884769293716987605e+242, 10, "2439051988", 243},
  {3.7182832475252347248341926e+96, 7, "3718283", 97},
  {2.7164756214079167557968571e-148, 9, "271647562", -147},
  {1.8664768456023873689413890e-109, 7, "1866477", -108},
  {8.7072262903093590376627397e+212, 9, "870722629", 213},
  {5.7075818127446827002634294e-66, 12, "570758181274", -65},
  {1.2182923884254295616460897e-229, 18, "121829238842542956", -228},
  {6.4714987027854166949669565e+198, 2, "65", 199},
  {2.3098408205221971299246147e-178, 11, "23098408205", -177},
  {2.2268071346540208704588747e-262, 1, "2", -261},
  {1.6650151228165759382844425e+163, 20, "16650151228165759383", 164},
  {1.2488440847195511365490080e-164, 16, "1248844084719551", -163},
  {3.5861204071413324311323231e-112, 10, "3586120407", -111},
  {2.8071367197281723875880014e-287, 16, "2807136719728172", -286},
  {1.3506635551735653166804951e-03, 20, "13506635551735653167", -2},
  {1.6305363753958972372484195e-98, 17, "16305363753958972", -97},
  {2.7226657587168690722901156e+45, 10, "2722665759", 46},
  {3.9626660545644302926151024e-80, 19, "3962666054564430293", -79},
  {1.4481763887909678717624747e-299, 21, "144817638879096787176", -298},
  {5.1994430185429364587370296e+306, 7, "5199443", 307},
  {3.1446120845593892730424531e+235, 16, "3144612084559389", 236},
  {3.0513202818395293691249868e-119, 2, "31", -118},
  {3.3060067491973441205021637e-117, 8, "33060067", -116},
  {9.5811184497181721515017803e-231, 1, "1", -229},
  {1.6910640944842140314940186e+221, 16, "1691064094484214", 222},
  {1.4993001331491954726972706e-157, 13, "1499300133149", -156},
  {8.9871842843662818927577448e-34, 8, "89871843", -33},
  {8.8091743033995227147509612e-21, 6, "880917", -20},
  {3.2659701905613257685262108e-284, 2, "33", -283},
  {1.6338911556674483661397904e+55, 5, "16339", 56},
  {7.4596089957982882758656000e+22, 5, "74596", 23},
  {1.5432435359505983650093409e-77, 6, "154324", -76},
  {1.6119911885654081959592350e-194, 20, "1611991188565408196", -193},
  {1.8686825623249035723852733e-146, 1, "2", -145},
  {1.0608847333176649192978054e-177, 4, "1061", -176},
  {1.4614049374305772024276729e+205, 17, "14614049374305772", 206},
  {9.7165241178834552576456799e+97, 8, "97165241", 98},
  {5.4889709790548495056975301e-194, 10, "5488970979", -193},
  {3.0743769643648653368984660e+235, 7, "3074377", 236},
  {3.0826928875696695259512436e+234, 10, "3082692888", 235},
  {4.2262367393304142336878105e-197, 8, "42262367", -196},
  {2.6568123950341448840802172e-60, 3, "266", -59},
  {4.3537023673033781405118847e-301, 12, "43537023673", -300},
  {8.3525428974081706645843898e+77, 10, "8352542897", 78},
  {7.0237320110656926571807529e+147, 19, "7023732011065692657", 148},
  {4.1931515593849619044017300e+119, 5, "41932", 120},
  {1.4989714727241819512498784e+211, 17, "1498971472724182", 212},
  {2.5371510904231016851708166e-292, 4, "2537", -291},
  {2.0245866726943404742668311e+299, 19, "2024586672694340474", 300},
  {1.1083025002789163599344435e+27, 12, "110830250028", 28},
  {2.6983464694649472657958562e+104, 1, "3", 105},
  {7.9352946443056941468049756e-204, 18, "793529464430569415", -203},
  {3.1755380574534628697702400e+23, 1, "3", 24},
  {8.4531556348778909048692470e-24, 3, "845", -23},
  {9.5879589917135588971596664e+154, 19, "9587958991713558897", 155},
  {3.3360309926316284703221410e-262, 8, "3336031", -261},
  {1.2142037317904450452390332e-181, 7, "1214204", -180},
  {5.3128345623737105482876977e+215, 10, "5312834562", 216},
  {1.7919443450283256393527018e-208, 14, "17919443450283", -207},
  {7.7911569212949891365581688e-275, 13, "7791156921295", -274},
  {3.7943127165482442410192977e+86, 2, "38", 87},
  {4.7546936894483541693724446e+287, 5, "47547", 288},
  {6.9824760216294654471018448e+306, 20, "69824760216294654471", 307},
  {6.2797574645339394144533714e-255, 13, "6279757464534", -254},
  {1.9983468787917342463114953e-112, 15, "199834687879173", -111},
  {1.5480580555637141996595675e-132, 3, "155", -131},
  {1.2057156699134865595859641e-247, 2, "12", -246},
  {1.1577353461608623896458490e-145, 9, "115773535", -144},
  {5.4552941375266132370901009e-175, 21, "545529413752661323709", -174},
  {3.2784956993217582344653693e-242, 12, "327849569932", -241},
  {3.5930555193594183826103247e-260, 4, "3593", -259},
  {1.2349445297659861440665068e-121, 4, "1235", -120},
  {5.2829980811298533312058718e+137, 9, "528299808", 138},
  {2.2325262025417566584038164e+185, 17, "22325262025417567", 186},
  {3.5713486134992689156050048e+252, 18, "357134861349926892", 253},
  {7.3996281636214654477779976e-252, 16, "7399628163621465", -251},
  {7.0199993693913453523355917e+87, 1, "7", 88},
  {5.1053916863494080391240681e+37, 16, "5105391686349408", 38},
  {1.2081563865868344644951248e+292, 15, "120815638658683", 293},
  {7.9738165945403494514927453e-63, 13, "797381659454", -62},
  {4.1805090959434181030858891e+67, 13, "4180509095943", 68},
  {1.1801959902098273987948591e-79, 7, "1180196", -78},
  {2.5918270658843073921417592e+77, 4, "2592", 78},
  {6.8681211880054777292244773e+37, 9, "686812119", 38},
  {2.4310526310168222258664592e-132, 6, "243105", -131},
  {1.5180016623103103363012099e+283, 1, "2", 284},
  {2.0240065148401611186943428e-296, 13, "202400651484", -295},
  {1.2778832858023128274714795e+249, 4, "1278", 250},
  {1.0895125038537134765625000e+13, 18, "108951250385371348", 14},
  {9.5033689608864438207639271e-52, 8, "9503369", -51},
  {5.5221919976612513245654972e+42, 3, "552", 43},
  {6.8080992214251589727386694e+218, 21, "680809922142515897274", 219},
  {6.9790469746514630218410885e-272, 4, "6979", -271},
  {5.6300727222103200099570068e-102, 17, "563007272221032", -101},
  {1.8283578813304200759460009e+93, 7, "1828358", 94},
  {6.5506457478341873814773320e+76, 15, "655064574783419", 77},
  {1.6396463878154573271357944e-299, 1, "2", -298},
  {3.5076114669320516073301676e+76, 5, "35076", 77},
  {9.1560649198509040466669105e-237, 15, "91560649198509", -236},
  {9.9077877410706617860093045e+223, 3, "991", 224},
  {3.1777700319709445040770373e+112, 21, "317777003197094450408", 113},
  {5.1151531641461494072930694e+283, 21, "511515316414614940729", 284},
  {1.0077468117867309146248128e+177, 5, "10077", 178},
  {5.2353685374640317247017641e-130, 20, "52353685374640317247", -129},
  {7.1967492241664140993626820e+200, 14, "71967492241664", 201},
  {8.9825418132749704757248000e+22, 18, "898254181327497048", 23},
  {1.1427628415795010332499867e-254, 12, "114276284158", -253},
  {1.2896172640922010871981740e+300, 16, "1289617264092201", 301},
  {2.9362548448220367117977361e-254, 21, "29362548448220367118", -253},
  {7.5320479790078193059388689e+61, 21, "753204797900781930594", 62},
  {3.6582052812002239182954428e-183, 17, "36582052812002239", -182},
  {2.1497067940378221390444599e+99, 15, "214970679403782", 100},
  {4.0471512472249223667155817e-64, 16, "4047151247224922", -63},
  {2.6096200279238029937053860e-153, 12, "260962002792", -152},
  {9.4156935768374722079419008e-252, 9, "941569358", -251},
  {1.9006703710087830858104700e-29, 12, "190067037101", -28},
  {2.6297753599666854052267327e+220, 6, "262978", 221},
  {1.8557093829588461721243294e+167, 16, "1855709382958846", 168},
  {9.5679235136853167510383188e-226, 16, "9567923513685317", -225},
  {6.3800252661241501354720856e+249, 18, "638002526612415014", 250},
  {1.0356719452130075179250797e+166, 20, "10356719452130075179", 167},
  {1.6114864674863450945439793e+46, 6, "161149", 47},
  {6.5780367278110327636371380e-31, 20, "65780367278110327636", -30},
  {8.1925979809236472439781807e-03, 1, "8", -2},
  {6.5294688969960733050197860e+184, 20, "6529468896996073305", 185},
  {1.1255811076983382677799771e-163, 20, "11255811076983382678", -162},
  {5.9965031935980805595104385e-290, 15, "599650319359808", -289},
  {1.0250246865730431056424332e-88, 12, "102502468657", -87},
  {1.9576188938366023558436631e-151, 4, "1958", -150},
  {3.8248176559933183299536649e+299, 18, "382481765599331833", 300},
  {3.0552104047599350254108984e-179, 7, "305521", -178},
  {1.4016724498940537418931446e-67, 5, "14017", -66},
  {4.0460019386341619786583310e+65, 5, "4046", 66},
  {6.6233205616755783880250186e-113, 2, "66", -112},
  {4.4141050158343068817942738e+297, 4, "4414", 298},
  {1.6229644005486197360196678e-285, 4, "1623", -284},
  {1.4921948155259361267089844e+09, 19, "1492194815525936127", 10},
  {9.3370204683017594738584591e+202, 20, "93370204683017594739", 203},
  {1.0240528447543901906274708e+37, 18, "102405284475439019", 38},
  {2.2057280486576834525704784e+126, 16, "2205728048657683", 127},
  {4.6783729355752989605890886e+259, 8, "46783729", 260},
  {1.2660435897773009409802910e+218, 18, "126604358977730094", 219},
  {3.9140382096296257125033601e-215, 6, "391404", -214},
  {1.4168283062466473381322681e+42, 17, "14168283062466473", 43},
  {1.2965319521946565143230209e+238, 6, "129653", 239},
  {1.5279645476759579168156033e+250, 2, "15", 251},
  {9.7518289427937657722410284e+53, 20, "97518289427937657722", 54},
  {5.4010079113946756445400327e-19, 6, "540101", -18},
  {2.7296533965414361245603930e-268, 13, "2729653396541", -267},
  {1.3713263381024004563289596e-122, 2, "14", -121},
  {4.2133816984016852496935975e+74, 13, "4213381698402", 75},
  {5.8310700293746074599716824e-21, 13, "5831070029375", -20},
  {1.1944584636344030380249023e+10, 9, "119445846", 11},
  {3.9862684445024257640363757e-278, 6, "398627", -277},
  {1.2175985519768504481181624e+280, 11, "1217598552", 281},
  {1.5779269631932573242719913e+265, 19, "1577926963193257324", 266},
  {5.9807008176709278175740932e+123, 7, "5980701", 124},
  {1.3653598642035826108230064e+72, 10, "1365359864", 73},
  {1.0481397443533836389461654e-106, 12, "104813974435", -105},
  {1.6084670209471087353027552e+39, 16, "1608467020947109", 40},
  {5.5940721310177482839091945e+100, 3, "559", 101},
  {7.9489636054435070000665329e+236, 8, "79489636", 237},
  {1.0218944617011106580743810e-169, 15, "102189446170111", -168},
  {4.2358870492598226586435526e-201, 5, "42359", -200},
  {2.9876201056888678641592797e+114, 5, "29876", 115},
  {2.0306375173236457067302409e-137, 10, "2030637517", -136},
  {1.4657468869423990877143209e-133, 9, "146574689", -132},
  {1.5132245566010995423708932e-103, 11, "15132245566", -102},
  {4.3444503287521666361690354e+147, 3, "434", 148},
  {4.4124948144374632593358438e+295, 4, "4412", 296},
  {1.9434424339847533437485605e+45, 4, "1943", 46},
  {3.3952644424201326749751019e+290, 1, "3", 291},
  {6.9565765586631325077748347e-233, 15, "695657655866313", -232},
  {1.3642364451829329497120669e+206, 13, "1364236445183", 207},
  {3.3545779126100722106910595e-147, 5, "33546", -146},
  {5.1727487789319067510345615e+119, 16, "5172748778931907", 120},
  {7.0784987752133609774275636e-84, 16, "7078498775213361", -83},
  {5.6675153851892919783542491e+83, 15, "566751538518929", 84},
  {2.6493981741881172707721632e+302, 6, "26494", 303},
  {9.2599000463420693655893139e+107, 9, "925990005", 108},
  {3.7319048792851892991654566e-109, 16, "3731904879285189", -108},
  {6.3087396002094195618611200e+23, 9, "63087396", 24},
  {1.9608927715002625686628381e-57, 3, "196", -56},
  {3.9501189359963768414304564e-66, 11, "3950118936", -65},
  {1.6786791048495010835921583e-195, 7, "1678679", -194},
  {1.7036441850553340603617086e-270, 17, "17036441850553341", -269},
  {9.7762759821394902426340020e-191, 19, "9776275982139490243", -190},
  {5.2910468080895238784933099e+00, 4, "5291", 1},
  {6.3944814371247575071844737e-132, 19, "6394481437124757507", -131},
  {1.2062644436269041303933026e-287, 6, "120626", -286},
  {1.5696494706880376702961094e-213, 18, "156964947068803767", -212},
  {2.2540230831997481079486956e-128, 14, "22540230831997", -127},
  {9.7412841926368814613301825e+59, 5, "97413", 60},
  {2.5580008047543113281250000e+13, 17, "25580008047543113", 14},
  {9.9768410653244749405250714e-58, 15, "997684106532447", -57},
  {4.5721171222333597545528869e-241, 12, "457211712223", -240},
  {9.0760956369780479060716280e+169, 21, "907609563697804790607", 170},
  {1.2360487852282565868149645e+164, 6, "123605", 165},
  {2.2114961895377145279432686e+220, 21, "221149618953771452794", 221},
  {1.9388132703419116111337370e-132, 15, "193881327034191", -131},
  {4.0062674855636474089928640e-145, 14, "40062674855636", -144},
  {4.4123052806614678882923148e-156, 17, "44123052806614679", -155},
  {9.1394127354093226595744336e+69, 1, "9", 70},
  {7.7306847794726956269589779e-04, 13, "7730684779473", -3},
  {3.2523191105492472201957393e+291, 11, "32523191105", 292},
  {4.6284992485954780110378715e+275, 5, "46285", 276},
  {9.3136106342905172069195536e-126, 5, "93136", -125},
  {6.9572906258010117887722907e-308, 13, "6957290625801", -307},
  {4.1302524536476951478870129e-290, 6, "413025", -289},
  {8.1067248102366414601265814e-201, 12, "810672481024", -200},
  {2.4368940249800902968622855e-192, 2, "24", -191},
  {3.3643872002897688121772049e+302, 21, "336438720028976881218", 303},
  {4.9918671774756879873327869e-35, 2, "5", -34},
  {1.2979355993520572604239981e+55, 8, "12979356", 56},
  {1.2350564725405792435931056e+282, 4, "1235", 283},
  {2.6924490262250992999488832e-90, 2, "27", -89},
  {1.5838880009995081995673340e+73, 15, "158388800099951", 74},
  {6.1941207932444003259083387e+112, 16, "61941207932444", 113},
  {7.1700674168894773900542125e+114, 17, "71700674168894774", 115},
  {1.1057842982047649567121894e-250, 18, "110578429820476496", -249},
  {1.2202863929010425993650658e+219, 5, "12203", 220},
  {1.5426060055380019651666342e-46, 1, "2", -45},
  {3.0151020350716297528779105e+156, 20, "30151020350716297529", 157},
  {2.0217327276200792929534378e+117, 1, "2", 118},
  {4.4035744293592025629136711e+170, 10, "4403574429", 171},
  {9.4712983442516808378379278e+126, 9, "947129834", 127},
  {4.2089637664921710099212585e-284, 13, "4208963766492", -283},
  {3.1484013721514828010947625e-24, 10, "3148401372", -23},
  {1.8295529220477971947329910e+87, 18, "182955292204779719", 88},
  {3.5278956279780607939175919e-224, 20, "35278956279780607939", -223},
  {1.1447569042508649185542229e+64, 21, "114475690425086491855", 65},
  {3.2918650036286913387229408e-182, 16, "3291865003628691", -181},
  {1.2814544701590547194893445e-123, 1, "1", -122},
  {9.9593305833003025417126291e+153, 12, "99593305833", 154},
  {1.0596477575399156568567369e-27, 4, "106", -26},
  {6.9642800499899075891659582e-218, 2, "7", -217},
  {8.9832952785234756469726562e+10, 10, "8983295279", 11},
  {4.0099883909708974614298168e-15, 19, "4009988390970897461", -14},
  {5.9744814081257516788455006e+232, 1, "6", 233},
  {1.3633918720225205560222135e+118, 3, "136", 119},
  {1.3397759685642235576119018e-229, 3, "134", -228},
  {6.4701433213376969935494819e-270, 5, "64701", -269},
  {4.4739954855926216143101200e-89, 2, "45", -88},
  {4.1892833223639253188392499e-46, 16, "4189283322363925", -45},
  {1.5123334964831115357152863e-232, 14, "15123334964831", -231},
  {1.5900479055238187160569516e-143, 2, "16", -142},
  {2.3076436533559292908175374e-197, 16, "2307643653355929", -196},
  {7.5050428576516891928730720e-22, 9, "750504286", -21},
  {1.1742582573615473524793634e-215, 21, "117425825736154735248", -214},
  {9.9605019613681787252853022e+148, 3, "996", 149},
  {8.5340684721742371972500036e+205, 20, "85340684721742371973", 206},
  {3.8162814383789485537282705e-160, 19, "3816281438378948554", -159},
  {1.5159550995096016661318339e+46, 2, "15", 47},
  {8.8528506308067605696411725e-136, 20, "88528506308067605696", -135},
  {2.9979316656868335089503495e+57, 17, "29979316656868335", 58},
  {8.9275959977811525754538015e-54, 19, "8927595997781152575", -53},
  {1.9983259973620039586273598e+40, 14, "1998325997362", 41},
  {5.9596216280810756549764171e-13, 6, "595962", -12},
  {6.1122036054606503791777946e+195, 10, "6112203605", 196},
  {6.3344330899927465988295826e+259, 10, "633443309", 260},
  {2.5856136007458920110760568e+113, 18, "258561360074589201", 114},
  {9.5217308202783330032519602e-60, 20, "95217308202783330033", -59},
  {3.5969292577435426072205712e+69, 9, "359692926", 70},
  {3.0121741689565077153691384e-168, 11, "3012174169", -167},
  {1.8601438719375193608399041e+271, 17, "18601438719375194", 272},
  {6.9152419694566242373808895e-49, 7, "6915242", -48},
  {5.1156135471626922214320341e+192, 19, "5115613547162692221", 193},
  {2.5294657873521810361701728e-226, 4, "2529", -225},
  {1.3077095921200831540897542e+164, 13, "130770959212", 165},
  {4.1869171058949187074357489e+273, 21, "418691710589491870744", 274},
  {3.9725407880644272803136179e+152, 2, "4", 153},
  {8.3109626519116338530373070e-122, 6, "831096", -121},
  {1.0388155428193897370182100e-181, 16, "103881554281939", -180},
  {5.7243249306986045756626667e+74, 18, "572432493069860458", 75},
  {1.3489911183121479812591603e-271, 7, "1348991", -270},
  {3.0074728623343430539420019e+268, 21, "300747286233434305394", 269},
  {8.3687028666026008902268585e-207, 17, "83687028666026009", -206},
  {3.4737525708328169074786057e-95, 21, "347375257083281690748", -94},
  {3.9763490069647065939465861e-302, 2, "4", -301},
  {5.3885532250918316207270212e+138, 12, "538855322509", 139},
  {3.2047743229881303367908993e-151, 19, "3204774322988130337", -150},
  {3.3818433160637394327427125e-77, 7, "3381843", -76},
  {1.7161706949043183379116210e+297, 7, "1716171", 298},
  {2.5092623629949094463518128e+33, 4, "2509", 34},
  {2.5946613263091326101579589e-37, 17, "25946613263091326", -36},
  {5.5530780735676779464744276e-83, 16, "5553078073567678", -82},
  {1.2001277413130328793251428e+194, 18, "120012774131303288", 195},
  {4.8230090730122946213566307e+210, 6, "482301", 211},
  {2.6105953049834583669977904e+214, 20, "2610595304983458367", 215},
  {8.0588055539941831735109832e-51, 7, "8058806", -50},
  {2.6202277619512546419012422e-115, 1, "3", -114},
  {2.2356296218849045788922974e+139, 7, "223563", 140},
  {6.1985826670606042294058946e-15, 6, "619858", -14},
  {1.2274571257346132135221886e-30, 4, "1227", -29},
  {3.7584099445500668803135364e+61, 20, "37584099445500668803", 62},
  {2.2874003026426209244711066e-291, 20, "22874003026426209245", -290},
  {1.7189017584457637640886787e+226, 12, "171890175845", 227},
  {8.0767498357280193654998848e-302, 14, "8076749835728", -301},
  {7.2003037218526733340695500e+03, 16, "7200303721852673", 4},
  {5.1527543983878201693917451e+225, 20, "51527543983878201694", 226},
  {8.1028645724757446593199938e-204, 7, "8102865", -203},
  {4.6181800137765792134694467e-302, 21, "461818001377657921347", -301},
  {5.3320216790688102124022659e+101, 1, "5", 102},
  {7.2228090325204692888403074e+255, 18, "722280903252046929", 256},
  {1.5163865708484621055411273e+179, 3, "152", 180},
  {1.6896175755069637980689093e+218, 10, "1689617576", 219},
  {1.4523320479184780476179196e+78, 12, "145233204792", 79},
  {1.5764302627591297971943528e-127, 10, "1576430263", -126},
  {5.9149297143679345703125000e+11, 3, "591", 12},
  {1.5970758906564486802986819e+48, 11, "15970758907", 49},
  {2.2334247423028192901347096e-86, 11, "22334247423", -85},
  {1.4733547078190544978729555e-29, 19, "1473354707819054498", -28},
  {1.5801077143026371219108356e+288, 14, "15801077143026", 289},
  {1.2017809486378706405969625e-144, 18, "120178094863787064", -143},
  {3.2614100007978314815963790e+214, 20, "32614100007978314816", 215},
  {1.0187777078876556035549461e+275, 15, "101877770788766", 276},
  {9.5276109123128392778055760e+50, 20, "95276109123128392778", 51},
  {5.9843460146755992108622082e+205, 11, "59843460147", 206},
  {2.7029773000432705032380909e+01, 7, "2702977", 2},
  {1.8668886471019983256114952e+268, 4, "1867", 269},
  {6.8313070445737876066949396e-155, 7, "6831307", -154},
  {2.9955927507521447533246500e+271, 17, "29955927507521448", 272},
  {6.6421420794743886184766158e-206, 11, "66421420795", -205},
  {3.1288081743972158324438781e+129, 5, "31288", 130},
  {1.8594364750475574181667534e+168, 19, "1859436475047557418", 169},
  {2.9494662444373353288267353e+122, 11, "29494662444", 123},
  {4.4770303281856745327160493e+206, 11, "44770303282", 207},
  {3.5428860957437899144054623e+102, 8, "35428861", 103},
  {9.2506048075446560171831040e-281, 11, "92506048075", -280},
  {2.5481402648723857875435000e+119, 1, "3", 120},
  {4.7128257530130106544683974e+278, 12, "471282575301", 279},
  {2.0832688184900031503854540e-253, 11, "20832688185", -252},
  {2.8059433225198483925524436e-114, 7, "2805943", -113},
  {6.4048110689858611013225011e-82, 5, "64048", -81},
  {4.4164658012985989779447064e+144, 10, "4416465801", 145},
  {5.8590475889653776752064497e+238, 14, "58590475889654", 239},
  {2.1238877879569592682033704e+75, 21, "21238877879569592682", 76},
  {1.5933919294195530585687095e+276, 11, "15933919294", 277},
  {9.7546494968193117954056421e-224, 11, "97546494968", -223},
  {2.1696733460199536813338993e-297, 5, "21697", -296},
  {4.8029589524069753559692361e-62, 17, "48029589524069754", -61},
  {1.8861322118961154804518310e-200, 5, "18861", -199},
  {8.2011445492602282052192102e-100, 3, "82", -99},
  {9.2614036567570577315772394e+150, 1, "9", 151},
  {4.3782923522972170965903148e-62, 14, "43782923522972", -61},
  {2.3218952360947241429702926e-46, 5, "23219", -45},
  {1.9960114074596407500000000e+15, 14, "19960114074596", 16},
  {7.0296323699809173924663655e+202, 6, "702963", 203},
  {3.0822838565890313876840386e+193, 3, "308", 194},
  {1.0019303516615786259236646e-74, 4, "1002", -73},
  {8.5342522498123269248317909e-153, 5, "85343", -152},
  {1.7121296047203672167870631e+97, 1, "2", 98},
  {4.0361958924142089421994115e-301, 19, "4036195892414208942", -300},
  {4.7178294871718814869407499e+288, 16, "4717829487171881", 289},
  {2.8697112494799099154560313e+268, 14, "28697112494799", 269},
  {9.4961696750569340290038021e-263, 13, "9496169675057", -262},
  {2.7443178731090319279847836e-109, 18, "274431787310903193", -108},
  {1.2241234914655857920058704e-75, 16, "1224123491465586", -74},
  {1.6811861597522822852795532e-245, 10, "168118616", -244},
  {1.3941104636544560038606544e+219, 9, "139411046", 220},
  {3.1601047823542662265012020e+35, 9, "316010478", 36},
  {2.3776077935314518755601106e+144, 19, "2377607793531451876", 145},
  {7.7609676216555779847199732e-249, 1, "8", -248},
  {1.7809506370340978138450574e-208, 14, "17809506370341", -207},
  {2.1313494166748527385798693e-90, 19, "2131349416674852739", -89},
  {8.9607342549165793765938656e-75, 14, "89607342549166", -74},
  {1.0658890521646100033674134e+100, 16, "106588905216461", 101},
  {1.4205711137127605252467270e+304, 16, "1420571113712761", 305},
  {2.1727987380567283456505654e-54, 3, "217", -53},
  {1.9458060849341030728827747e+43, 10, "1945806085", 44},
  {5.6517002549237727078422184e-247, 8, "56517003", -246},
  {4.2903209037960691759048174e-100, 5, "42903", -99},
  {1.8443244433574654405185482e-38, 14, "18443244433575", -37},
  {4.7941516210845398426279107e-220, 1, "5", -219},
  {1.0713425601639498121216000e+22, 15, "107134256016395", 23},
  {3.0625904975995965564453241e-243, 4, "3063", -242},
  {1.0538704817792768631376363e+269, 5, "10539", 270},
  {9.0477126812649790860339629e+141, 15, "904771268126498", 142},
  {2.8309682940999898737022278e-02, 3, "283", -1},
  {1.0608091427985334123029183e-142, 8, "10608091", -141},
  {2.3684595954059543068141305e+294, 21, "236845959540595430681", 295},
  {7.7388897640012134550228141e+136, 20, "7738889764001213455", 137},
  {1.0653832765301470824050932e+118, 1, "1", 119},
  {4.7047211722697377924349784e+169, 20, "47047211722697377924", 170},
  {1.5456631447855872127046451e+268, 8, "15456631", 269},
  {7.6432476623973252090073249e-246, 17, "76432476623973252", -245},
  {1.1908157951931434465736694e-72, 10, "1190815795", -71},
  {3.5269937071276680568783256e+166, 12, "352699370713", 167},
  {7.8521073058988023238882099e-251, 14, "78521073058988", -250},
  {1.2323107520598729099332509e+103, 17, "12323107520598729", 104},
  {6.1826158564423813644420130e+158, 1, "6", 159},
  {9.6230093283268517828110255e+179, 4, "9623", 180},
  {1.4786355429212845010826269e-130, 2, "15", -129},
  {5.1337614445740294743652217e-211, 16, "5133761444574029", -210},
  {3.7449264045073850904525599e-283, 16, "3744926404507385", -282},
  {2.4049406559604177452237450e+185, 21, "240494065596041774522", 186},
  {8.6318904275198028939994513e+258, 6, "863189", 259},
  {2.1097421288571300996933769e-100, 16, "210974212885713", -99},
  {8.0111542039731333812117066e+245, 2, "8", 246},
  {8.6380897841506026059801011e-290, 10, "8638089784", -289},
  {4.3386056873263597049440691e+58, 8, "43386057", 59},
  {2.3802347773962454176603548e-260, 8, "23802348", -259},
  {6.1357824881320295965189654e-137, 12, "613578248813", -136},
  {8.0269612350159682365451259e-288, 17, "80269612350159682", -287},
  {6.7280498226069549607536650e+238, 17, "6728049822606955", 239},
  {2.6616812129526428701069303e+207, 7, "2661681", 208},
  {6.8509975306895791824515314e+62, 7, "6850998", 63},
  {1.3272953901775223375472545e-142, 19, "1327295390177522338", -141},
  {7.9444830035034538347158593e+221, 18, "794448300350345383", 222},
  {1.2053289634351742569850360e+189, 7, "1205329", 190},
  {1.6539767032557299020902423e+197, 1, "2", 198},
  {1.3493682512589054898354070e+74, 5, "13494", 75},
  {1.9722982321820719179743916e+241, 3, "197", 242},
  {6.2962345947508673564042041e+34, 17, "62962345947508674", 35},
  {9.0562481966202854761724570e+240, 15, "905624819662029", 241},
  {1.4844710704006047348789198e-34, 9, "148447107", -33},
  {4.1616217250172346830368042e+07, 5, "41616", 8},
  {2.1986057907790415566839647e+292, 14, "2198605790779", 293},
  {5.2710640353440001424049986e+203, 1, "5", 204},
  {1.1055815817478421540795751e-204, 14, "11055815817478", -203},
  {2.2147877356049476048968503e-237, 18, "22147877356049476", -236},
  {6.0627137782111318870371019e+102, 10, "6062713778", 103},
  {2.1143183159550213925030998e+170, 15, "211431831595502", 171},
  {5.3458853413896866791722710e+217, 16, "5345885341389687", 218},
  {3.2955064917926769385248601e-24, 9, "329550649", -23},
  {3.8142729420821040328521124e+80, 15, "38142729420821", 81},
  {5.2425690020801220089197159e+06, 6, "524257", 7},
  {1.6511829273331333120000000e+19, 7, "1651183", 20},
  {1.0609922268606920037042778e-10, 2, "11", -9},
  {1.4891491723491014750665539e+106, 4, "1489", 107},
  {1.0613463195474673187404603e+152, 13, "1061346319547", 153},
  {4.6188094510927218515170411e-260, 20, "46188094510927218515", -259},
  {4.9772704025415681160539646e-156, 15, "497727040254157", -155},
  {3.9670551288867880960000000e+19, 6, "396706", 20},
  {9.8644302246335787343264515e-107, 2, "99", -106},
  {1.1968382099232135168000000e+19, 11, "11968382099", 20},
  {3.1150648788457271796423844e-99, 9, "311506488", -98},
  {2.6456161850743343836753255e+140, 5, "26456", 141},
  {1.2250744571716435398079374e+108, 13, "1225074457172", 109},
  {1.5985082188078882427988852e+223, 18, "159850821880788824", 224},
  {1.2079711402069010932431858e+210, 15, "12079711402069", 211},
  {2.3002967455122498183851727e+188, 17, "23002967455122498", 189},
  {3.3876737761786802715064838e+41, 15, "338767377617868", 42},
  {4.8199330413219625895700612e-212, 8, "4819933", -211},
  {5.7349081956828793191072691e+54, 16, "5734908195682879", 55},
  {1.5811528120104706350986622e+31, 3, "158", 32},
  {2.9058783369609422734637372e-36, 12, "290587833696", -35},
  {6.7916025930058547424591238e-242, 5, "67916", -241},
  {2.8804714736185963063349087e-115, 11, "28804714736", -114},
  {9.2025446521456624796677648e+269, 2, "92", 270},
  {1.4676299840733952013443152e+87, 5, "14676", 88},
  {2.4659038817764860596993286e-265, 10, "2465903882", -264},
  {2.8715132212884675422363033e+104, 10, "2871513221", 105},
  {4.4747232707958466546879583e+216, 3, "447", 217},
  {4.7809730318852514601058228e-240, 6, "478097", -239},
  {6.5728218147955820625364439e+226, 1, "7", 227},
  {1.0882627479858570807430406e+111, 3, "109", 112},
  {3.9142960895694686464154676e+291, 6, "39143", 292},
  {1.1019655048249370240218723e+71, 4, "1102", 72},
  {9.9674041703803499337083763e+121, 6, "99674", 122},
  {9.0219458988448861152935381e-195, 1, "9", -194},
  {1.0128628948805970659580048e-122, 10, "1012862895", -121},
  {7.6879889271284936118945726e-98, 18, "768798892712849361", -97},
  {9.9468341540921298976164076e-241, 1, "1", -239},
  {5.3002029588294086796500787e+145, 3, "53", 146},
  {3.1503835906404065603603759e-66, 7, "3150384", -65},
  {6.7807544436114062083962910e-204, 17, "67807544436114062", -203},
  {3.5371574813059145501908780e-102, 12, "353715748131", -101},
  {2.4220328557141969255451880e-275, 6, "242203", -274},
  {4.4568590054081626225274560e-09, 17, "44568590054081626", -8},
  {1.7578626986267727026597446e+283, 17, "17578626986267727", 284},
  {6.6275690196859920491174770e+107, 4, "6628", 108},
  {5.8060988356182195263373284e-248, 12, "580609883562", -247},
  {5.1791593798972899165278250e+00, 1, "5", 1},
  {2.4041635592045147245284883e+129, 2, "24", 130},
  {3.1108952984003091200000000e+17, 9, "31108953", 18},
  {5.9956576916165172577332169e-291, 3, "6", -290},
  {2.5544445520673446381796135e-120, 19, "2554444552067344638", -119},
  {5.8222383997337787430872268e+103, 16, "5822238399733779", 104},
  {4.5821585544153322059945387e+151, 2, "46", 152},
  {6.8193768573636908994299423e+289, 3, "682", 290},
  {1.2979725804011439376186371e-185, 2, "13", -184},
  {2.8396131582858236387152480e+263, 8, "28396132", 264},
  {2.3522990279412104035825242e+75, 6, "23523", 76},
  {1.1480800897188283480001123e+299, 15, "114808008971883", 300},
  {6.1870543847171392938489559e+293, 12, "618705438472", 294},
  {2.8788994584799808360477917e+215, 9, "287889946", 216},
  {3.6275891920128058697920593e-283, 7, "3627589", -282},
  {1.1781765356306335680254204e-163, 4, "1178", -162},
  {1.3138143364087688839901764e-166, 11, "13138143364", -165},
  {3.2689171671277903932739734e+40, 20, "32689171671277903933", 41},
  {2.2441846044390313714783207e-175, 5, "22442", -174},
  {1.2916310815329066381658476e+211, 18, "129163108153290664", 212},
  {4.7557764452821542501222941e-284, 10, "4755776445", -283},
  {1.6255785425476020585997840e+273, 17, "16255785425476021", 274},
  {3.3220881297264349175731977e-302, 18, "332208812972643492", -301},
  {3.6896805898672444288443381e+190, 17, "36896805898672444", 191},
  {1.6862003644604359220506625e+151, 10, "1686200364", 152},
  {6.2429031618948147717121233e-165, 3, "624", -164},
  {3.2149186340375717722188198e+249, 4, "3215", 250},
  {2.2100346454957827093930563e-179, 17, "22100346454957827", -178},
  {7.8484379332513922471624339e-268, 9, "784843793", -267},
  {1.3997253606680050689441158e+203, 18, "139972536066800507", 204},
  {1.9971824824147454119472864e+298, 16, "1997182482414745", 299},
  {1.1959422584001095720796052e+231, 2, "12", 232},
  {4.4738038022028412779165062e-106, 16, "4473803802202841", -105},
  {4.3363003008175244450704891e-134, 9, "43363003", -133},
  {8.4605751307514621722494961e+294, 19, "8460575130751462172", 295},
  {1.8731180654887708508561892e+106, 6, "187312", 107},
  {4.0675827999206513932982984e+290, 11, "40675827999", 291},
  {6.0578903167859957872685280e+277, 16, "6057890316785996", 278},
  {9.7449786820873477004970320e-35, 20, "97449786820873477005", -34},
  {2.0286467723890195244691164e+42, 4, "2029", 43},
  {4.0782051067147553991167481e-131, 8, "40782051", -130},
  {6.1163705111872927024210941e+103, 3, "612", 104},
  {1.2827660557602897151919230e+90, 17, "12827660557602897", 91},
  {1.2414078015871802736101418e-281, 2, "12", -280},
  {2.9333326857722523454535673e+282, 18, "293333268577225235", 283},
  {2.8367023684602336182851174e-164, 2, "28", -163},
  {5.0378313687507523005915156e-280, 5, "50378", -279},
  {4.0880891528540163798396844e-143, 12, "408808915285", -142},
  {4.4390051377625045053944116e-244, 3, "444", -243},
  {2.5816084485106153825581318e+126, 21, "258160844851061538256", 127},
  {1.5316258505525898654013872e+06, 4, "1532", 7},
  {9.8250353495912618769727452e+59, 11, "98250353496", 60},
  {3.4544781808474575057294111e-92, 20, "34544781808474575057", -91},
  {9.6578909713756297122485947e-108, 18, "965789097137562971", -107},
  {1.4048210003659043362324426e-76, 5, "14048", -75},
  {1.5873319741619818353477896e+73, 16, "1587331974161982", 74},
  {7.6818776651357382217030613e-303, 20, "76818776651357382217", -302},
  {6.8202912593076490229647491e+276, 14, "68202912593076", 277},
  {4.7204154920831369293385513e-139, 8, "47204155", -138},
  {9.2736735134295861595589588e-171, 12, "927367351343", -170},
  {3.2133573930983962439758486e-96, 18, "321335739309839624", -95},
  {2.1079837613684237602170866e+129, 19, "210798376136842376", 130},
  {2.7016686890384447906399146e+04, 15, "270166868903844", 5},
  {1.7031310197131793207084098e-40, 5, "17031", -39},
  {1.2609824744740039843656779e-268, 16, "1260982474474004", -267},
  {3.8068615144210423871845144e+144, 17, "38068615144210424", 145},
  {1.6399132616823008737064946e+89, 17, "16399132616823009", 90},
  {1.2906785125294834651931526e+210, 14, "12906785125295", 211},
  {5.7939903314511131357478333e+146, 21, "579399033145111313575", 147},
  {7.4064412690718976468902140e-198, 8, "74064413", -197},
  {1.7520606769738511332144048e+72, 10, "1752060677", 73},
  {3.0046831346879099815639384e-219, 7, "3004683", -218},
  {1.5869747006301737058129283e+67, 3, "159", 68},
  {2.4282707739654482151132114e-263, 14, "24282707739654", -262},
  {2.1760492709176344595658692e+183, 14, "21760492709176", 184},
  {2.8680182366042700640430884e-151, 2, "29", -150},
  {5.3030119988365239131128667e+238, 7, "5303012", 239},
  {6.1137327293884208562275673e+279, 20, "61137327293884208562", 280},
  {5.8475192612112582773676400e-215, 21, "584751926121125827737", -214},
  {2.5529142674138548393780503e+214, 15, "255291426741385", 215},
  {8.1974232270928165366586489e+60, 1, "8", 61},
  {6.2953318251795783238130240e+81, 4, "6295", 82},
  {7.9289817408802145980945161e+228, 20, "79289817408802145981", 229},
  {7.3723897637451633107590446e-93, 16, "7372389763745163", -92},
  {1.7461046074603882604996081e+299, 4, "1746", 300},
  {1.0914218559481233883423566e+154, 15, "109142185594812", 155},
  {9.3795252996198807481393811e-28, 14, "93795252996199", -27},
  {2.8415326207392543236033063e-223, 12, "284153262074", -222},
  {3.6682333881938034014780214e-03, 8, "36682334", -2},
  {7.2269181833223878554505752e+171, 8, "72269182", 172},
  {7.6785279323612144538933334e-34, 2, "77", -33},
  {3.5230656449391932199260651e+143, 16, "3523065644939193", 144},
  {9.0480629066013108977957625e-173, 11, "90480629066", -172},
  {4.3172920637936408602488272e-204, 7, "4317292", -203},
  {1.0748402174116499382928981e+107, 9, "107484022", 108},
  {9.8797231757389707224370878e+174, 15, "987972317573897", 175},
  {8.4157540354547066920497778e+159, 19, "8415754035454706692", 160},
  {3.0728246011097722009888121e-194, 5, "30728", -193},
  {4.3098553535865127022125355e-266, 2, "43", -265},
  {8.3320780052519760153662574e+106, 14, "8332078005252", 107},
  {2.2950208864462986549715744e-132, 6, "229502", -131},
  {1.8078793960187596697068938e+289, 12, "180787939602", 290},
  {5.9023302294846051441029321e+100, 2, "59", 101},
  {1.1365927870908534429150406e-98, 16, "1136592787090853", -97},
  {1.2083053493351460298480132e-209, 8, "12083053", -208},
  {5.2693932128808298043598129e-80, 1, "5", -79},
  {3.5068880780912314508139728e-273, 17, "35068880780912315", -272},
  {7.1052781621625559365851475e+286, 19, "7105278162162555937", 287},
  {8.0095987828998370359243348e-91, 14, "80095987828998", -90},
  {3.6602924251818915159191264e+66, 17, "36602924251818915", 67},
  {2.8890598492755377026684962e-140, 15, "288905984927554", -139},
  {7.1096826022577012400858467e-174, 19, "710968260225770124", -173},
  {1.4156566309780012034025276e+03, 9, "141565663", 4},
  {3.0639330802998817823712407e-03, 2, "31", -2},
  {3.5729417199431427205704306e-236, 15, "357294171994314", -235},
  {6.2444098171968071399129544e-143, 6, "624441", -142},
  {3.4202546810538039642733357e+189, 20, "34202546810538039643", 190},
  {2.1962250119043196900554252e-38, 3, "22", -37},
  {1.7874653340458072325158976e+157, 10, "1787465334", 158},
  {9.3305966042961658918527389e+212, 19, "9330596604296165892", 213},
  {1.1351258044483792810209940e+69, 11, "11351258044", 70},
  {1.2055056452356651711279777e-108, 6, "120551", -107},
  {3.8126650516309881584374745e+96, 12, "381266505163", 97},
  {5.2859702664931855140582871e+120, 3, "529", 121},
  {1.0361144430811942443347827e-234, 6, "103611", -233},
  {1.5041501395721537966304594e+38, 10, "150415014", 39},
  {9.2725226428950549698563270e+297, 6, "927252", 298},
  {1.0329148627592792723827160e+31, 7, "1032915", 32},
  {3.3467453155979355447182608e-138, 21, "334674531559793554472", -137},
  {1.9616328040892371556493191e+285, 4, "1962", 286},
  {1.1076589545769104422751293e+157, 10, "1107658955", 158},
  {3.8240365948491153735301776e+279, 5, "3824", 280},
  {7.7223645955792866021695775e+121, 19, "7722364595579286602", 122},
  {1.9036536181633605246391164e+173, 20, "19036536181633605246", 174},
  {1.4954722061747058682249613e-28, 16, "1495472206174706", -27},
  {3.2436643904833146546806499e-95, 8, "32436644", -94},
  {3.0217384779709839629030275e-110, 2, "3", -109},
  {7.1263501029504615512069570e-88, 5, "71264", -87},
  {5.3750634502173239822797063e-281, 2, "54", -280},
  {4.5741226111274243050933649e-74, 9, "457412261", -73},
  {3.6065113417621174358687649e-52, 6, "360651", -51},
  {4.8795939682249966321504008e-203, 14, "4879593968225", -202},
  {2.7481143204713067293142731e+62, 1, "3", 63},
  {1.8039757690258424997491255e-223, 11, "1803975769", -222},
  {7.0150184327035382554582152e+198, 6, "701502", 199},
  {5.0117904978012374905664478e-272, 15, "501179049780124", -271},
  {9.0184688890891274320495141e-05, 19, "9018468889089127432", -4},
  {1.0831735302368703309103451e+99, 11, "10831735302", 100},
  {6.4480865555485556100343746e-226, 15, "644808655554856", -225},
  {2.5049735165889230635541039e-269, 13, "2504973516589", -268},
  {9.9622139723626399484712297e-191, 20, "99622139723626399485", -190},
  {2.4159877016669114314015435e+208, 10, "2415987702", 209},
  {1.0497080771084945436069781e+100, 20, "10497080771084945436", 101},
  {3.8089453337697101379799335e+205, 12, "380894533377", 206},
  {8.8553965821030481123740649e+238, 12, "88553965821", 239},
  {2.2970555815934806590159625e-230, 13, "2297055581593", -229},
  {4.2995899098198218908144190e+88, 13, "429958990982", 89},
  {6.7726347953437193009805945e+93, 13, "6772634795344", 94},
  {1.2897727044354302474844414e-206, 17, "12897727044354302", -205},
  {1.4115304978857165215847508e-195, 10, "1411530498", -194},
  {2.7545302064812059070682869e-61, 8, "27545302", -60},
  {6.7099968874318123322928486e-136, 19, "6709996887431812332", -135},
  {9.1461868559848078872626883e+304, 10, "9146186856", 305},
  {1.3077071040187884723542132e+290, 4, "1308", 291},
  {1.3355145960166419698024908e-293, 14, "13355145960166", -292},
  {1.9150670186047536907329900e-31, 11, "19150670186", -30},
  {5.9379114142968346134025866e-74, 1, "6", -73},
  {9.8432598301584547680804136e-107, 20, "98432598301584547681", -106},
  {8.6284391440953691520281097e-271, 8, "86284391", -270},
  {9.1233255682658928767885255e+62, 1, "9", 63},
  {5.3127555120112340853725331e+119, 16, "5312755512011234", 120},
  {6.0058497178975057467986320e-118, 14, "60058497178975", -117},
  {9.9229029527772338701817405e+115, 5, "99229", 116},
  {1.5951322768344757366493247e+109, 7, "1595132", 110},
  {1.5137856775088652640224594e-179, 5, "15138", -178},
  {1.8366969624084373742966610e-166, 6, "18367", -165},
  {4.3072294420268010552152900e-184, 19, "4307229442026801055", -183},
  {7.4910941344455076789727518e-217, 2, "75", -216},
  {4.3676299030536185149891354e+185, 19, "4367629903053618515", 186},
  {1.6061278182294153557168227e+139, 12, "160612781823", 140},
  {9.0442863872930829842697976e-268, 2, "9", -267},
  {2.4549307826964512674000585e-22, 14, "24549307826965", -21},
  {1.4656782167108707039781867e+234, 19, "1465678216710870704", 235},
  {1.7328537384713390635377414e-258, 12, "173285373847", -257},
  {8.7395180827776936532159080e+275, 20, "87395180827776936532", 276},
  {1.5503307314092502684256765e-141, 17, "15503307314092503", -140},
  {1.0126508552059892240565423e-208, 6, "101265", -207},
  {1.9360647780014306873319463e-166, 10, "1936064778", -165},
  {1.9767094656750218429400986e-16, 17, "19767094656750218", -15},
  {1.7921164624881919851254647e-143, 5, "17921", -142},
  {2.0879832282296468029296831e-52, 1, "2", -51},
  {5.3742783205727068230009921e-173, 14, "53742783205727", -172},
  {3.8335826989184000211607360e+52, 10, "3833582699", 53},
  {6.5557446266916660946970569e+70, 14, "65557446266917", 71},
  {1.1210417051671147635703017e+114, 15, "112104170516711", 115},
  {3.0200408433511973087565691e-63, 21, "302004084335119730876", -62},
  {8.0828390977450413059419542e+40, 16, "8082839097745041", 41},
  {5.4524437130363391113281250e+11, 10, "5452443713", 12},
  {9.9008850483129330028915528e-56, 19, "9900885048312933003", -55},
  {8.7540294002107340811039853e-300, 21, "87540294002107340811", -299},
  {1.7164928322066926030062705e-18, 3, "172", -17},
  {1.0159530747766292565777934e+295, 1, "1", 296},
  {1.3236439894161638141076602e+121, 9, "132364399", 122},
  {1.7993771887214788940250313e+42, 2, "18", 43},
  {3.5740891703958001520151727e-205, 2, "36", -204},
  {3.3147150144956952225108438e+260, 17, "33147150144956952", 261},
  {4.1582684782764063223564240e+114, 14, "41582684782764", 115},
  {3.8153750302416506620695717e+132, 19, "3815375030241650662", 133},
  {6.1124849525443506368357505e+79, 18, "611248495254435064", 80},
  {1.4519764218546365409525760e+24, 4, "1452", 25},
  {1.1341509540022514683683584e-38, 16, "1134150954002251", -37},
  {5.6754606007890281942811184e+135, 10, "5675460601", 136},
  {2.4245629391429770973743739e+109, 7, "2424563", 110},
  {1.0377698531881637017111889e+178, 14, "10377698531882", 179},
  {1.7177210247396006098390527e-239, 14, "17177210247396", -238},
  {1.5745367680917409599731078e+168, 17, "1574536768091741", 169},
  {5.6968439019703986787496626e+88, 17, "56968439019703987", 89},
  {8.2304990509997716604016425e-11, 4, "823", -10},
  {8.0494704132464178890452613e-203, 16, "8049470413246418", -202},
  {2.1374910349023572095071448e+73, 18, "213749103490235721", 74},
  {1.0783646486417387371539136e-34, 21, "107836464864173873715", -33},
  {1.9674815677218553273775336e+256, 21, "196748156772185532738", 257},
  {3.6223714732993265694067738e+291, 11, "36223714733", 292},
  {4.6092120583856648750800125e-294, 19, "4609212058385664875", -293},
  {8.7324190975932198143755725e+296, 3, "873", 297},
  {8.4320026131574575929926117e-253, 14, "84320026131575", -252},
  {2.8642391096546264857562160e+259, 5, "28642", 260},
  {5.1318215904757543706823832e+64, 11, "51318215905", 65},
  {1.9846367677025875944526445e-38, 7, "1984637", -37},
  {1.3294380650518271620498285e+145, 14, "13294380650518", 146},
  {5.5117005106398274340413734e+280, 21, "551170051063982743404", 281},
  {2.1573484365456227885063302e-291, 18, "215734843654562279", -290},
  {3.9990151604205807309786087e+245, 9, "399901516", 246},
  {4.4272839476547283838530235e-300, 3, "443", -299},
  {3.9889117103876370219064781e-171, 20, "39889117103876370219", -170},
  {4.2524757232350581463311444e+61, 9, "425247572", 62},
  {7.7964610337984094728448531e-44, 2, "78", -43},
  {9.4096421030562385273351977e-05, 1, "9", -4},
  {2.1211895531889161018045929e+236, 8, "21211896", 237},
  {1.7462017599341502260175961e-307, 10, "174620176", -306},
  {2.3241561593111897411303735e-191, 2, "23", -190},
  {4.9534533259997555315899429e+100, 12, "4953453326", 101},
  {3.4211740698092113664052085e-65, 11, "34211740698", -64},
  {1.5223095868814636562482182e-254, 19, "1522309586881463656", -253},
  {1.0665915699164905139445889e-282, 20, "10665915699164905139", -281},
  {5.7221766661000180274060074e-166, 16, "5722176666100018", -165},
  {2.6283832459389736868202771e+242, 9, "262838325", 243},
  {4.5033958896988181306191930e+270, 5, "45034", 271},
  {1.7184252912698407688587001e+284, 20, "17184252912698407689", 285},
  {3.4520083333981918506125386e-46, 19, "3452008333398191851", -45},
  {1.3654839495037400292004117e+106, 15, "136548394950374", 107},
  {2.6171041439124222775072017e-194, 1, "3", -193},
  {4.0193713775784614816110786e+127, 17, "40193713775784615", 128},
  {5.9745467446257116726960353e-168, 2, "6", -167},
  {1.9995909851444820127612563e+276, 11, "19995909851", 277},
  {1.7323985229459780227319213e-133, 19, "1732398522945978023", -132},
  {2.7237410222508075429308505e-196, 2, "27", -195},
  {8.1157255705744262706554062e+34, 15, "811572557057443", 35},
  {7.9998979761923419517498643e-35, 16, "7999897976192342", -34},
  {2.9497755866269617996771634e+234, 7, "2949776", 235},
  {7.3507358370668965936375891e+193, 15, "73507358370669", 194},
  {1.2295510641934946730541486e+110, 1, "1", 111},
  {8.5116849592512852668745610e+89, 18, "851168495925128527", 90},
  {1.0248761224427465611785058e-63, 21, "102487612244274656118", -62},
  {3.9104958041967212553628193e-236, 2, "39", -235},
  {1.7379715671344668474566844e-31, 7, "1737972", -30},
  {2.1691436818530850909094291e+111, 6, "216914", 112},
  {1.7813856405081238887388605e-240, 8, "17813856", -239},
  {2.0120426512722589886329999e-128, 13, "2012042651272", -127},
  {7.1331188563856468338845917e+35, 20, "71331188563856468339", 36},
  {2.0600810712213251711318598e-65, 6, "206008", -64},
  {4.0841633446558834033876639e-11, 16, "4084163344655883", -10},
  {1.8209612736226539375539482e+37, 11, "18209612736", 38},
  {1.3856102322486205642291498e+287, 6, "138561", 288},
  {1.7268256524922831086394958e+74, 9, "172682565", 75},
  {8.1509812698014905736353197e+124, 5, "8151", 125},
  {9.2396744190480341578001220e-268, 10, "9239674419", -267},
  {2.8688164683679297334935552e+25, 2, "29", 26},
  {6.9015497493698452941434532e-193, 14, "69015497493698", -192},
  {2.5950606100768269793704794e-253, 5, "25951", -252},
  {2.8973832480741142114906733e-240, 8, "28973832", -239},
  {7.2433479381101362361306453e-105, 11, "72433479381", -104},
  {4.2557320776497888064170743e-221, 14, "42557320776498", -220},
  {4.6945259124602842345015091e-127, 11, "46945259125", -126},
  {6.1011339136744827782872971e+186, 14, "61011339136745", 187},
  {1.5937009931279613050739937e-47, 17, "15937009931279613", -46},
  {6.0210686514709452365496320e+25, 14, "60210686514709", 26},
  {5.0713289609474586210505338e+218, 2, "51", 219},
  {6.3495649178496968920775481e-163, 7, "6349565", -162},
  {3.1452682107026747832574707e-264, 3, "315", -263},
  {5.7800984928521266312849636e-08, 17, "57800984928521266", -7},
  {3.2244052026298654223629905e+56, 19, "3224405202629865422", 57},
  {4.7981921729878118143307431e-125, 17, "47981921729878118", -124},
  {3.9719503850038687368867523e+219, 16, "3971950385003869", 220},
  {2.4402603093267024950563655e+178, 3, "244", 179},
  {2.2182307310831376674457004e+129, 14, "22182307310831", 130},
  {2.6685760579081807583084007e-204, 17, "26685760579081808", -203},
  {2.1590822807975476568812680e+275, 5, "21591", 276},
  {7.6779908725431988916411719e-175, 7, "7677991", -174},
  {5.1249298141687878964929923e+270, 12, "512492981417", 271},
  {2.0409157382647583453725607e+223, 1, "2", 224},
  {1.8453958018205344114519999e+132, 15, "184539580182053", 133},
  {2.3414855021253619131828284e+221, 2, "23", 222},
  {1.3018859054748520469892493e+209, 5, "13019", 210},
  {1.2686466634659852331214992e-148, 13, "1268646663466", -147},
  {2.1838580236053504039326154e+84, 18, "21838580236053504", 85},
  {2.9075272185858590512463055e-151, 19, "2907527218585859051", -150},
  {2.7241714458825828433030260e-58, 20, "27241714458825828433", -57},
  {1.0688374972370430472260269e+204, 12, "106883749724", 205},
  {8.5039354277513529534652554e-160, 15, "850393542775135", -159},
  {3.9166777150164851513838228e-165, 17, "39166777150164852", -164},
  {5.5502718908939943080287007e-132, 11, "55502718909", -131},
  {3.6491667967072510178599815e+46, 6, "364917", 47},
  {3.1494022480908650417587242e+151, 20, "31494022480908650418", 152},
  {2.0727417201171574477818688e+47, 21, "207274172011715744778", 48},
  {1.3165499771615060190131751e-220, 4, "1317", -219},
  {2.9995580091546309902117412e-264, 9, "299955801", -263},
  {3.0178675975907992014165160e+87, 15, "30178675975908", 88},
  {1.0119913599028622923493890e+125, 6, "101199", 126},
  {1.4472836045273834060105126e+270, 9, "14472836", 271},
  {1.0937795386947776089593373e+96, 13, "1093779538695", 97},
  {2.3322489444598402725332694e-72, 21, "233224894445984027253", -71},
  {4.9666082550900874052347133e-105, 16, "4966608255090087", -104},
  {4.9744399337596790406667808e-65, 3, "497", -64},
  {2.1086304607242908544557161e+48, 4, "2109", 49},
  {3.4501337404986477814752886e+301, 10, "345013374", 302},
  {2.2517527940446285339095496e+197, 5, "22518", 198},
  {1.2225070157479672482841696e-239, 6, "122251", -238},
  {1.1103895164385513865029636e+84, 8, "11103895", 85},
  {4.3394711428023041479824176e-100, 7, "4339471", -99},
  {1.5727526192904671738245172e-35, 18, "157275261929046717", -34},
  {6.5368294497850351752671789e-275, 17, "65368294497850352", -274},
  {1.3653987370731731867987616e-121, 11, "13653987371", -120},
  {6.2262482419474249211462783e+91, 16, "6226248241947425", 92},
  {1.6390224159746930191407855e+107, 4, "1639", 108},
  {2.7136046346968357832357414e+34, 13, "2713604634697", 35},
  {1.3515448961072983375484788e-212, 18, "135154489610729834", -211},
  {1.1487311813779028086055308e+292, 12, "114873118138", 293},
  {3.4991598652772234345320612e+04, 20, "34991598652772234345", 5},
  {3.2833963863303937255741275e-188, 20, "32833963863303937256", -187},
  {3.2697177174245206709554156e-10, 20, "3269717717424520671", -9},
  {1.0326845972928228323199066e-92, 1, "1", -91},
  {3.7959636921363198784388316e-08, 8, "37959637", -7},
  {2.1438950864462620146964634e-121, 12, "214389508645", -120},
  {1.9883614031766336305200285e-114, 18, "198836140317663363", -113},
  {3.6369509326687116394232679e-219, 18, "363695093266871164", -218},
  {3.8469329066759242506813757e+211, 16, "3846932906675924", 212},
  {1.0486426853041613995170976e+45, 3, "105", 46},
  {5.6966717859047126459378003e+210, 16, "5696671785904713", 211},
  {7.3894779984118451257865606e+175, 20, "73894779984118451258", 176},
  {6.7275913757332209596271002e-71, 16, "6727591375733221", -70},
  {1.3601520042861969903108877e+39, 21, "136015200428619699031", 40},
  {4.5469726393003195772838127e+117, 12, "45469726393", 118},
  {6.9509762004060074292492808e+41, 19, "6950976200406007429", 42},
  {2.6589215425709115922980735e-252, 16, "2658921542570912", -251},
  {3.6184046178126672921513087e-159, 20, "36184046178126672922", -158},
  {6.5314706437129999608069725e-67, 7, "6531471", -66},
  {2.4985926939284729124000111e-244, 6, "249859", -243},
  {3.6976087440593880007411512e-266, 17, "3697608744059388", -265},
  {4.5985150712039431084828545e+57, 2, "46", 58},
  {7.4915401902121671783017070e-91, 11, "74915401902", -90},
  {2.5236335783204435715161332e-300, 21, "252363357832044357152", -299},
  {3.6159838229861034637022900e-95, 8, "36159838", -94},
  {4.3334540009877340073135891e-08, 13, "4333454000988", -7},
  {7.4457417049580211861060351e-264, 18, "744574170495802119", -263},
  {4.3384641188143612824906211e-172, 3, "434", -171},
  {1.4964275608840625355295618e+240, 3, "15", 241},
  {3.4294976471866627454135735e+304, 18, "342949764718666275", 305},
  {7.1683028592799211787949864e+306, 7, "7168303", 307},
  {6.6428783327231220472063448e+276, 16, "6642878332723122", 277},
  {1.6282975405162587549038348e-192, 16, "1628297540516259", -191},
  {9.6562120871021988911994753e-159, 5, "96562", -158},
  {2.7444364571230219321625449e+226, 12, "274443645712", 227},
  {3.3092086613552769192499066e+287, 9, "330920866", 288},
  {3.9799498632985462532006751e+182, 18, "397994986329854625", 183},
  {2.9154800195256285298122893e-244, 14, "29154800195256", -243},
  {4.1134760745299149770955271e+179, 11, "41134760745", 180},
  {4.6913135991609107483076515e-229, 16, "4691313599160911", -228},
  {9.1362335167319203125000000e+13, 18, "913623351673192031", 14},
  {2.6796666746537651845333571e-153, 10, "2679666675", -152},
  {5.0302425255729816494382768e-37, 17, "50302425255729816", -36},
  {2.2406705332730271438284715e+64, 16, "2240670533273027", 65},
  {2.5757762690237041767131029e+33, 15, "25757762690237", 34},
  {4.7224765089471647406422982e+142, 15, "472247650894716", 143},
  {1.0122354063900430909134488e-224, 9, "101223541", -223},
  {1.0341795708535784374331083e-54, 10, "1034179571", -53},
  {6.6626305503543456828861517e+182, 8, "66626306", 183},
  {1.3793953031147988529582495e+196, 3, "138", 197},
  {6.0564625311994586110691745e+285, 21, "605646253119945861107", 286},
  {9.3420658497876178514060270e+168, 13, "9342065849788", 169},
  {5.4564955515946757656779844e+79, 18, "545649555159467577", 80},
  {1.5527183833951452522786993e+156, 3, "155", 157},
  {3.6778713199411647377842710e-177, 3, "368", -176},
  {6.6816385357611830754854824e-80, 10, "6681638536", -79},
  {3.7406399864791973973013041e-78, 13, "3740639986479", -77},
  {2.1156905171595470683661903e-92, 8, "21156905", -91},
  {1.1091184582965558271811013e+295, 21, "110911845829655582718", 296},
  {2.9600900230857303620686262e-202, 20, "29600900230857303621", -201},
  {2.4327907494445065073537638e+266, 7, "2432791", 267},
  {2.2807742661217027782188212e+84, 15, "22807742661217", 85},
  {5.6319134387267032689349853e-188, 13, "5631913438727", -187},
  {1.4430917571150580818660939e-271, 1, "1", -270},
  {6.3820942750631364108159066e-222, 18, "638209427506313641", -221},
  {1.2035615173960572274613738e+195, 14, "12035615173961", 196},
  {5.5866042020655242003441091e-211, 9, "55866042", -210},
  {2.5446675328234086394878015e-197, 15, "254466753282341", -196},
  {2.0426631695043652198424569e-160, 5, "20427", -159},
  {9.7865902421740311314823645e+279, 16, "9786590242174031", 280},
  {5.1127885124523134021974550e+172, 19, "5112788512452313402", 173},
  {1.6291479210075192641194688e-133, 21, "162914792100751926412", -132},
  {7.4077112242808067032037177e+59, 18, "74077112242808067", 60},
  {2.0508329409927021350953672e-276, 7, "2050833", -275},
  {1.3679970933447544992712053e+169, 12, "136799709334", 170},
  {3.6723866264396879763318327e-152, 12, "367238662644", -151},
  {2.8127299263912739490933745e+00, 12, "281272992639", 1},
  {1.6369970281375792503364949e-165, 1, "2", -164},
  {1.2417701181393046364458386e+87, 17, "12417701181393046", 88},
  {4.4322571994545442329459037e-205, 1, "4", -204},
  {9.0123119492940308480000000e+18, 1, "9", 19},
  {5.5483816434020426482628700e+122, 2, "55", 123},
  {6.3234503415466116877227176e-112, 18, "632345034154661169", -111},
  {6.2285276934685764273434272e-294, 9, "622852769", -293},
  {3.8530250732136412919567135e-147, 21, "385302507321364129196", -146},
  {3.6935391795781084005931536e+254, 9, "369353918", 255},
  {4.9191947545135910872729299e-147, 4, "4919", -146},
  {3.2107413009304897382272178e-19, 11, "32107413009", -18},
  {7.7409128344362585821565074e-181, 5, "77409", -180},
  {4.9411078095362213601203372e-175, 5, "49411", -174},
  {1.7968353690468775709071495e-281, 13, "1796835369047", -280},
  {1.1275761855288734375000000e+14, 12, "112757618553", 15},
  {2.5430511475529788518356310e-263, 11, "25430511476", -262},
  {2.1460255914293982862754384e-185, 4, "2146", -184},
  {2.1948610385818275621803492e+130, 17, "21948610385818276", 131},
  {3.4605771382018539383744825e+121, 18, "346057713820185394", 122},
  {1.8899317516154633551222560e-299, 2, "19", -298},
  {2.9239137602965915093751429e-198, 3, "292", -197},
  {2.3333894353716402415284422e-147, 14, "23333894353716", -146},
  {3.1866117765847122767840533e-164, 20, "31866117765847122768", -163},
  {6.2640994642211652021323862e-230, 16, "6264099464221165", -229},
  {2.3720437936700511791337322e-277, 12, "237204379367", -276},
  {1.6443084520005470822506142e-204, 17, "16443084520005471", -203},
  {1.0103159990759129271772183e+211, 8, "1010316", 212},
  {4.1253583970939826722212906e-03, 17, "41253583970939827", -2},
  {1.9056573728813088514243848e+158, 18, "190565737288130885", 159},
  {1.4436641982966996637446449e-297, 18, "144366419829669966", -296},
  {2.8048054139884729144597460e+67, 19, "2804805413988472914", 68},
  {2.0894277849291276823713807e-183, 8, "20894278", -182},
  {1.8118247983311800577660650e+31, 1, "2", 32},
  {1.2176957336327945494516268e-223, 11, "12176957336", -222},
  {3.8672359642454910291532312e-234, 21, "386723596424549102915", -233},
  {4.5052953585623353397908601e+188, 1, "5", 189},
  {1.5725803596282794895313301e+67, 3, "157", 68},
  {4.5023454208331413648187625e+208, 16, "4502345420833141", 209},
  {8.4037122839868040806400000e+20, 13, "8403712283987", 21},
  {3.4187818981324593844681225e+233, 8, "34187819", 234},
  {1.3095977959554647915365572e-115, 9, "13095978", -114},
  {2.0086131926027521382780152e+242, 17, "20086131926027521", 243},
  {6.9594949399169611016078018e-95, 12, "695949493992", -94},
  {2.9351334214206868537164707e+134, 4, "2935", 135},
  {4.9218447668344583734167941e-01, 8, "49218448", 0},
  {6.8520279761595089051463892e+265, 8, "6852028", 266},
  {1.0077379359558507082089992e-165, 17, "10077379359558507", -164},
  {2.3433539863929346747295780e-185, 17, "23433539863929347", -184},
  {7.9979553537904918193817139e+06, 17, "79979553537904918", 7},
  {2.7800027067297102422819473e+166, 10, "2780002707", 167},
  {5.4196929796607649919300742e+147, 4, "542", 148},
  {1.5250256591015049917563541e+35, 8, "15250257", 36},
  {7.6945227922119600201166194e-174, 3, "769", -173},
  {2.1797797990769270299494331e-213, 1, "2", -212},
  {8.7684003348720581192790944e+74, 14, "87684003348721", 75},
  {1.1972705941234230085854586e+295, 3, "12", 296},
  {3.7742513787061305178322849e+253, 20, "37742513787061305178", 254},
  {1.7395281699872122509458972e-223, 9, "173952817", -222},
  {1.7952560885325572311125104e-139, 15, "179525608853256", -138},
  {2.4079033623362256340907956e+155, 20, "24079033623362256341", 156},
  {1.5293535474673990802353073e+256, 20, "15293535474673990802", 257},
  {7.0006891501013160723035183e-102, 4, "7001", -101},
  {2.4626992178224941947081815e+234, 14, "24626992178225", 235},
  {4.4609810348892313493899778e-265, 12, "446098103489", -264},
  {5.1878884879578361453411552e-306, 14, "51878884879578", -305},
  {1.4388678243824472228267509e+108, 17, "14388678243824472", 109},
  {3.3816043075075293694560769e-49, 21, "338160430750752936946", -48},
  {4.5338982176885703636551221e+299, 15, "453389821768857", 300},
  {4.0889128449967777781205353e+55, 5, "40889", 56},
  {4.3319829896754990598927353e-10, 13, "4331982989675", -9},
  {5.8752647160589367325234154e-48, 4, "5875", -47},
  {1.7496316367134895943001615e+31, 9, "174963164", 32},
  {7.2775871641039254345451070e+246, 3, "728", 247},
  {1.9710075659996013641357422e+09, 6, "197101", 10},
  {7.3006230019425454704341436e+55, 21, "730062300194254547043", 56},
  {3.9793502773351677771695500e+240, 13, "3979350277335", 241},
  {7.2687649682285841909506644e-146, 3, "727", -145},
  {1.1454526313908883866497150e+103, 1, "1", 104},
  {4.4567929266079401371835841e-305, 1, "4", -304},
  {3.2158373788618323149234744e+89, 3, "322", 90},
  {8.3528565617042204891503636e+293, 10, "8352856562", 294},
  {9.2701203670619493753620200e+192, 19, "9270120367061949375", 193},
  {8.2571610627557685917862227e-97, 2, "83", -96},
  {6.3398046951743370318615651e+199, 11, "63398046952", 200},
  {3.6348545813193463332780048e-112, 20, "36348545813193463333", -111},
  {8.6410548258754684164143398e+47, 3, "864", 48},
  {2.5530198845828891028997621e+227, 7, "255302", 228},
  {2.2483555965096489420705052e+31, 3, "225", 32},
  {4.3133122123003452463662270e+269, 13, "43133122123", 270},
  {3.6736669833508104000000000e+16, 14, "36736669833508", 17},
  {3.3527251160763216543055777e+303, 3, "335", 304},
  {5.1987291810003188623966460e-151, 8, "51987292", -150},
  {5.1472993901089877483034532e+303, 18, "514729939010898775", 304},
  {1.3505242517407453902809286e+105, 2, "14", 106},
  {9.4688592250456379247157322e+193, 7, "9468859", 194},
  {4.6878519179949893939363383e+157, 21, "468785191799498939394", 158},
  {1.4021587988811516265107914e-127, 4, "1402", -126},
  {3.9812026750400999772111843e+292, 2, "4", 293},
  {4.3668079174831160004612182e-18, 2, "44", -17},
  {1.1459002747353180497744221e-259, 20, "11459002747353180498", -258},
  {3.8405368567898247292210884e+264, 5, "38405", 265},
  {4.5486520261207384652214067e+70, 5, "45487", 71},
  {1.7107939357080274947636199e-65, 1, "2", -64},
  {6.5572025145706603169558421e-140, 11, "65572025146", -139},
  {2.9641030068836816155342423e-287, 20, "29641030068836816155", -286},
  {9.9506664500960695024873026e+100, 12, "99506664501", 101},
  {3.9805721691890639618294630e-255, 20, "39805721691890639618", -254},
  {4.3294262906509568105016361e-68, 14, "4329426290651", -67},
  {1.3083919053873455794948994e-181, 12, "130839190539", -180},
  {1.2006967244761147957863346e-219, 5, "12007", -218},
  {1.9088798014429537167686346e-153, 5, "19089", -152},
  {1.2543545050718395755844308e+93, 11, "12543545051", 94},
  {1.4213645024992845744439704e+110, 8, "14213645", 111},
  {1.4248474726855687158968116e-217, 9, "142484747", -216},
  {2.8758117006311938672391995e-59, 15, "287581170063119", -58},
  {7.3951346284602193402011985e-230, 9, "739513463", -229},
  {1.6831227991648215657326259e+177, 21, "168312279916482156573", 178},
  {1.3903109583781431364629199e-84, 16, "1390310958378143", -83},
  {7.9434611406362872906033627e+242, 14, "79434611406363", 243},
  {2.3251347669959977441294286e+166, 1, "2", 167},
  {8.3230920653604480192118326e+119, 18, "832309206536044802", 120},
  {3.0752569048737030078637697e+147, 4, "3075", 148},
  {3.6794092666070952451046604e+41, 17, "36794092666070952", 42},
  {2.0209038309451051650232876e+87, 6, "20209", 88},
  {1.2820206370249773874947142e+134, 10, "1282020637", 135},
  {6.0028513680723807170025705e-125, 16, "6002851368072381", -124},
  {1.7968585597943928190428748e+291, 17, "17968585597943928", 292},
  {6.8591927227363969245280165e-234, 2, "69", -233},
  {7.8435469340264978679169589e+142, 19, "7843546934026497868", 143},
  {3.5530327171177540579489992e-60, 6, "355303", -59},
  {8.3014516960363189539693535e-74, 5, "83015", -73},
  {1.2813139770095792503608022e-177, 7, "1281314", -176},
  {7.5361307615149059598556050e+218, 12, "753613076151", 219},
  {2.3419749358687526267949985e+49, 14, "23419749358688", 50},
  {3.5531389715453960203540672e+87, 10, "3553138972", 88},
  {5.1106680166890646515646394e-154, 11, "51106680167", -153},
  {1.4710004059957183405720564e+293, 15, "147100040599572", 294},
  {3.8442802357024269149636070e-273, 16, "3844280235702427", -272},
  {4.7624750742171136954245120e+286, 8, "47624751", 287},
  {6.5257446831776690158412015e-284, 18, "652574468317766902", -283},
  {4.6032945352290247851701152e-260, 6, "460329", -259},
  {1.7117201892617130586745344e+284, 1, "2", 285},
  {3.4596767868631910691692181e-205, 15, "345967678686319", -204},
  {4.5174235669866884974956494e+131, 5, "45174", 132},
  {3.0110954003607984769562838e+104, 17, "30110954003607985", 105},
  {2.1706645319489172795726353e+106, 9, "217066453", 107},
  {3.2625337966371290078837112e+255, 1, "3", 256},
  {5.7044736734935950638552092e+54, 16, "5704473673493595", 55},
  {2.6018029395581199355265171e+203, 4, "2602", 204},
  {8.3266858727594328127858725e+225, 10, "8326685873", 226},
  {2.3267013629655589239815580e-26, 2, "23", -25},
  {8.5109627204016084162600550e+52, 6, "851096", 53},
  {1.6363279275843470026078745e+207, 20, "16363279275843470026", 208},
  {5.0274272979261518963204793e-261, 4, "5027", -260},
  {1.1977519362102773785591125e+08, 18, "119775193621027738", 9},
  {1.6509816359124138065082520e-267, 20, "16509816359124138065", -266},
  {2.4249145919282601158162294e-02, 21, "242491459192826011582", -1},
  {5.5203158189704600307509412e+241, 19, "5520315818970460031", 242},
  {3.2464434310166050096116853e+35, 15, "324644343101661", 36},
  {3.1739401276096717056208045e-229, 21, "317394012760967170562", -228},
  {9.5727563552989682830891748e-63, 13, "9572756355299", -62},
  {3.4859959125338857433007433e+00, 17, "34859959125338857", 1},
  {1.7743979057511170675942211e+170, 10, "1774397906", 171},
  {6.9582344762528071378894913e+115, 20, "69582344762528071379", 116},
  {3.2333156369932906441846745e-307, 14, "32333156369933", -306},
  {1.2270827145763853277133428e-183, 16, "1227082714576385", -182},
  {1.6990149060744646895865252e-123, 20, "16990149060744646896", -122},
  {3.2836553673740720498728411e+260, 4, "3284", 261},
  {1.1248199283480797608364964e+248, 7, "112482", 249},
  {2.3566000045540753440136776e+146, 15, "235660000455408", 147},
  {4.8998354055225434112000000e+19, 12, "489983540552", 20},
  {9.2947577192878888334447708e+219, 9, "929475772", 220},
  {4.3304621058676405143276093e+27, 17, "43304621058676405", 28},
  {4.1452119304790709638866074e+109, 13, "4145211930479", 110},
  {2.7082482022839749679239625e+251, 12, "270824820228", 252},
  {9.4566700407667702017738417e+117, 4, "9457", 118},
  {8.2930568986515831907299419e+242, 8, "82930569", 243},
  {1.7162793713576823494039183e-256, 9, "171627937", -255},
  {3.0578949124402672559557942e-161, 18, "305789491244026726", -160},
  {5.6730278909092324851774856e+138, 17, "56730278909092325", 139},
  {2.2480308215131163225821046e+247, 18, "224803082151311632", 248},
  {2.0044738799378550948270521e-233, 2, "2", -232},
  {2.4872421647165507234021565e+92, 5, "24872", 93},
  {4.5405280844048550853029706e+85, 4, "4541", 86},
  {3.9083296730569666194807501e-103, 10, "3908329673", -102},
  {2.5198670428099935443188760e+101, 12, "251986704281", 102},
  {3.8129816907379506671233643e-252, 7, "3812982", -251},
  {4.7606936131879180459512986e-265, 19, "4760693613187918046", -264},
  {1.4447192898595822274909999e-103, 13, "144471928986", -102},
  {1.8319895427609253888000000e+19, 12, "183198954276", 20},
  {1.6370262487532757027890095e+50, 13, "1637026248753", 51},
  {2.0402938288437466344752752e-58, 8, "20402938", -57},
  {2.0315638332183292905959611e-53, 14, "20315638332183", -52},
  {2.3287080962878681356062669e+306, 15, "232870809628787", 307},
  {5.4254427942405704167586581e-170, 3, "543", -169},
  {1.5597468212652813327364192e+240, 5, "15597", 241},
  {2.0614623401655921791542495e-158, 14, "20614623401656", -157},
  {7.8246124892230576263623801e-199, 19, "7824612489223057626", -198},
  {1.2512696508271112823050292e-11, 6, "125127", -10},
  {3.2499738931221403293506029e+176, 6, "324997", 177},
  {1.9137143158376952284791270e+128, 19, "1913714315837695228", 129},
  {4.4856015905901606340328507e-284, 9, "448560159", -283},
  {2.2491820170818411957427197e-208, 13, "2249182017082", -207},
  {3.2883935498625784723691612e-111, 19, "3288393549862578472", -110},
  {7.6653304642987501356920733e-32, 11, "76653304643", -31},
  {1.7102162621897837760068781e-142, 3, "171", -141},
  {6.7683883557151191711518084e-131, 17, "67683883557151192", -130},
  {3.9207197324463271030464234e-08, 3, "392", -7},
  {2.7619569684302489518016175e+248, 16, "2761956968430249", 249},
  {8.2694318582241337931944191e+261, 3, "827", 262},
  {8.5809641575194782509165174e-42, 5, "8581", -41},
  {3.4273766811959061167266827e-122, 5, "34274", -121},
  {2.7350279541559943849321729e-109, 12, "273502795416", -108},
  {1.0275613316283527471750889e-302, 1, "1", -301},
  {1.9941825400179008932158119e-293, 8, "19941825", -292},
  {1.7199176601009237338252902e+26, 15, "171991766010092", 27},
  {2.7067307622768614219634039e-302, 20, "2706730762276861422", -301},
  {1.2833772277628055101648013e-191, 20, "12833772277628055102", -190},
  {4.4484590266817637168467402e+288, 17, "44484590266817637", 289},
  {2.3780991996320666346637247e+45, 7, "2378099", 46},
  {2.8957124318495353723033949e-110, 2, "29", -109},
  {8.9929497413211738689686164e-160, 10, "8992949741", -159},
  {2.3441476065548554745905264e-102, 1, "2", -101},
  {3.5049811600373272415957521e+230, 15, "350498116003733", 231},
  {6.0279029739611863157484037e+125, 6, "60279", 126},
  {1.8538604877434170865812108e+80, 2, "19", 81},
  {1.1413856614485441027105590e+246, 21, "114138566144854410271", 247},
  {1.8942112744368416375760064e-126, 10, "1894211274", -125},
  {8.3020701742749515821578512e+210, 8, "83020702", 211},
  {2.1553966478678003514012967e-206, 8, "21553966", -205},
  {1.5310100081704211540006882e-140, 4, "1531", -139},
  {6.5265768062839547110619446e+142, 5, "65266", 143},
  {4.2428669738335045002417706e-68, 11, "42428669738", -67},
  {5.8211409325667007031046732e-75, 17, "58211409325667007", -74},
  {2.7596113456156397760061532e+107, 9, "275961135", 108},
  {9.3218618758046079942166413e-39, 15, "932186187580461", -38},
  {8.9746817215455355191450748e-39, 9, "897468172", -38},
  {5.4795392771984090505017612e+268, 18, "547953927719840905", 269},
  {2.7736069825508284196013539e-37, 19, "277360698255082842", -36},
  {1.9342342189961004728537065e-204, 6, "193423", -203},
  {6.9281410862608092137317374e+90, 13, "6928141086261", 91},
  {4.3966516731310978023615470e+30, 6, "439665", 31},
  {4.6898932600861051861199936e+181, 10, "468989326", 182},
  {6.9572261296448455365902529e-193, 20, "69572261296448455366", -192},
  {3.8995485161498180112142330e+172, 18, "389954851614981801", 173},
  {8.2837598156019645315791677e-32, 16, "8283759815601965", -31},
  {6.1834795586112277979692837e-40, 20, "6183479558611227798", -39},
  {1.9915891960451515490150015e+169, 13, "1991589196045", 170},
  {2.9759876829736330581611564e+296, 10, "2975987683", 297},
  {2.3181483271061108571729759e+164, 17, "23181483271061109", 165},
  {1.0992173378705950777919800e-256, 3, "11", -255},
  {2.5021299795998048828708043e+106, 21, "250212997959980488287", 107},
  {7.2889466915158871590727364e+266, 11, "72889466915", 267},
  {9.2722745905890958046354471e+223, 12, "927227459059", 224},
  {3.5790070801280793759997794e-177, 21, "3579007080128079376", -176},
  {1.2256937680411044933272690e-66, 5, "12257", -65},
  {6.2594909168051486204795850e+287, 13, "6259490916805", 288},
  {1.4289446230277443952297505e+36, 1, "1", 37},
  {2.4388623359291510591260365e+65, 15, "243886233592915", 66},
  {1.2172543449005946627582267e-42, 14, "12172543449006", -41},
  {1.0977079202795816313299319e-163, 17, "10977079202795816", -162},
  {1.2104515792283206667205558e-82, 6, "121045", -81},
  {1.6717450468089570765799041e-152, 21, "167174504680895707658", -151},
  {3.2661266461618834982814967e-180, 9, "326612665", -179},
  {2.8664152221914074712286143e-234, 13, "2866415222191", -233},
  {6.4750956787555261995681375e-158, 5, "64751", -157},
  {1.0281872779304936081398784e+298, 8, "10281873", 299},
  {4.4193503487146321920000000e+18, 4, "4419", 19},
  {1.6365476092538119803820992e-34, 16, "1636547609253812", -33},
  {2.8831667268826474858604881e+207, 4, "2883", 208},
  {3.4655030907413110345382858e+284, 18, "346550309074131103", 285},
  {1.5619890762069174538235835e-117, 17, "15619890762069175", -116},
  {6.8523830303292053009561756e-217, 21, "685238303032920530096", -216},
  {7.9457833953946237948611286e-45, 9, "79457834", -44},
  {8.3009269263794198089771680e+282, 13, "8300926926379", 283},
  {7.3647094069995272432402532e-28, 12, "7364709407", -27},
  {7.4564145751816028349129801e-93, 19, "7456414575181602835", -92},
  {1.3516995337333192899438934e+36, 14, "13516995337333", 37},
  {1.0519768195158189264282745e-202, 18, "105197681951581893", -201},
  {2.9479231341884516160095713e-114, 11, "29479231342", -113},
  {7.1906977048106551300840175e+120, 18, "719069770481065513", 121},
  {4.9478122981483229911300479e-54, 4, "4948", -53},
  {1.0167116983739824218750000e+13, 10, "1016711698", 14},
  {3.4295286018474898699988612e+75, 14, "34295286018475", 76},
  {6.4756923268090391958695520e-103, 19, "6475692326809039196", -102},
  {3.4060230994368718705083454e+252, 15, "340602309943687", 253},
  {1.2388251298606752445910206e+140, 10, "123882513", 141},
  {8.8951868399631458769755924e+240, 14, "88951868399631", 241},
  {6.7453708556201562547908541e+149, 2, "67", 150},
  {1.1728315187355386581893572e+299, 18, "117283151873553866", 300},
  {6.1339633132233756995643772e+162, 16, "6133963313223376", 163},
  {1.4781087446788022764211198e-91, 10, "1478108745", -90},
  {8.0548275242697637039983315e+33, 14, "80548275242698", 34},
  {1.1150461219019658950011121e+292, 4, "1115", 293},
  {1.8675912434783629477040831e-08, 14, "18675912434784", -7},
  {8.6226645209522971934316761e-96, 16, "8622664520952297", -95},
  {1.1253776745181886598400005e-129, 15, "112537767451819", -128},
  {3.6005504157654756585560087e+139, 7, "360055", 140},
  {1.3446702143339193530428034e+85, 16, "1344670214333919", 86},
  {6.1416462685166342767029597e-70, 15, "614164626851663", -69},
  {6.5506925077487592412092984e-271, 9, "655069251", -270},
  {3.2569078429629717661520724e-53, 16, "3256907842962972", -52},
  {5.2434556623737183303080567e+60, 7, "5243456", 61},
  {2.0143573817981248234409953e-42, 18, "201435738179812482", -41},
  {1.0241567801156630357766379e-84, 8, "10241568", -83},
  {7.0870959681709584509224046e+189, 9, "708709597", 190},
  {4.6232592170278310154480287e-285, 21, "462325921702783101545", -284},
  {7.3560146196617385695614197e-132, 7, "7356015", -131},
  {2.8236703202327043453384896e+104, 5, "28237", 105},
  {7.7488642162121530097693601e+289, 16, "7748864216212153", 290},
  {2.8944210135973550014460015e+281, 6, "289442", 282},
  {8.6153117120306624895215834e+77, 2, "86", 78},
  {6.5246758635477588755339230e+38, 12, "652467586355", 39},
  {1.6063082349997055148860839e+55, 18, "160630823499970551", 56},
  {1.4626947675865596503412496e-198, 19, "146269476758655965", -197},
  {3.0164267250195878188661757e-46, 17, "30164267250195878", -45},
  {2.2693056654745755530284461e-192, 4, "2269", -191},
  {3.8024504558840339219538739e+89, 16, "3802450455884034", 90},
  {1.8905679518052224000000000e+17, 6, "189057", 18},
  {2.9567129883707059748141723e+198, 12, "295671298837", 199},
  {7.6301388516476775277791122e-09, 19, "7630138851647677528", -8},
  {4.9316077631480262232936963e+134, 13, "4931607763148", 135},
  {8.4767262749103633487222972e-11, 5, "84767", -10},
  {5.1794418816329658257432361e-112, 15, "517944188163297", -111},
  {1.0490294209863042324618746e+72, 17, "10490294209863042", 73},
  {1.0355483092074973591741147e+33, 8, "10355483", 34},
  {2.2415737074810451374671813e+266, 3, "224", 267},
  {5.2949297948044524275701406e+01, 6, "529493", 2},
  {1.0930320288010969839342129e+188, 15, "10930320288011", 189},
  {1.3977946370595358803152903e+123, 18, "139779463705953588", 124},
  {2.4895498896071204467981679e+191, 18, "248954988960712045", 192},
  {5.7332658449275279279452647e+228, 6, "573327", 229},
  {9.5878118725679587162574213e-245, 19, "9587811872567958716", -244},
  {1.5285128643094584784008237e-251, 2, "15", -250},
  {3.9129941645414736961505753e-03, 12, "391299416454", -2},
  {3.3606034581610083983959732e-248, 9, "336060346", -247},
  {3.3124030690783323823276269e+202, 10, "3312403069", 203},
  {3.6442369035295060043370933e-279, 16, "3644236903529506", -278},
  {2.8836554235671834638267337e-165, 19, "2883655423567183464", -164},
  {2.9848245753677506159409777e+88, 9, "298482458", 89},
  {4.6850978137253107930729405e-25, 7, "4685098", -24},
  {1.9941319551415542579199513e+196, 18, "199413195514155426", 197},
  {3.1095908515252847264328412e+85, 12, "310959085153", 86},
  {4.0073929892672568589414146e-19, 10, "4007392989", -18},
  {2.6636532743786705935322006e-151, 18, "266365327437867059", -150},
  {2.5235815000652527194920677e-102, 5, "25236", -101},
  {1.3483237918972625058754292e-134, 12, "13483237919", -133},
  {4.5011205695163774549262401e-75, 3, "45", -74},
  {1.0579906331118897010130274e-254, 15, "105799063311189", -253},
  {4.5671833864591305535767077e+113, 20, "45671833864591305536", 114},
  {2.3280382056161879694892823e+258, 6, "232804", 259},
  {4.3779520164541750659736863e+01, 19, "4377952016454175066", 2},
  {3.3516525936992957967649666e+100, 17, "33516525936992958", 101},
  {2.0547861831253464938128090e+58, 6, "205479", 59},
  {1.7697260824215763982425633e+81, 1, "2", 82},
  {5.9634949894837262485200002e+62, 20, "59634949894837262485", 63},
  {4.5235132307420526769242071e-220, 4, "4524", -219},
  {4.5243406267788348074323914e+145, 14, "45243406267788", 146},
  {1.2901222172092449475572798e+140, 3, "129", 141},
  {3.9265023048318168725989230e+303, 2, "39", 304},
  {1.4745841603624978550690065e-238, 17, "14745841603624979", -237},
  {3.0533112064739280268523881e+70, 5, "30533", 71},
  {1.0374500318373042644391149e+235, 13, "1037450031837", 236},
  {6.9814507416917618476870975e-220, 3, "698", -219},
  {1.7595618065032112083724537e-84, 10, "1759561807", -83},
  {1.2969709527072960496507590e+281, 4, "1297", 282},
  {4.3906406949777215061380894e-90, 3, "439", -89},
  {4.0323319642734455511274442e+201, 20, "40323319642734455511", 202},
  {1.2698688211689560007716187e-73, 6, "126987", -72},
  {4.2855078941576877486598734e+216, 8, "42855079", 217},
  {5.8962523274282531841280542e-108, 11, "58962523274", -107},
  {1.2376358105204915249436543e-73, 3, "124", -72},
  {6.1264803505217477003742233e-113, 4, "6126", -112},
  {2.4086404033395695705221216e-297, 15, "240864040333957", -296},
  {2.7205264033075014965788776e+153, 9, "27205264", 154},
  {7.4594205579001142022652189e-181, 7, "7459421", -180},
  {1.7807799596256332744517409e+50, 20, "17807799596256332745", 51},
  {1.5643174597310346332612915e-41, 10, "156431746", -40},
  {2.7799712782498156393056081e+190, 5, "278", 191},
  {7.6944284096460856593393807e+73, 21, "769442840964608565934", 74},
  {6.7872875791335878530397202e-258, 1, "7", -257},
  {2.7902836767492623766884208e+05, 17, "27902836767492624", 6},
  {2.3251383993439116800000000e+17, 5, "23251", 18},
  {3.8719010020050082046554016e+129, 8, "3871901", 130},
  {2.5138330842194068192194164e-304, 6, "251383", -303},
  {5.5651894843840052295320910e+191, 13, "5565189484384", 192},
  {1.0673270596186837314545228e+148, 17, "10673270596186837", 149},
  {1.2858361125454002416840380e-15, 13, "1285836112545", -14},
  {3.2915486415826753206645958e-226, 5, "32915", -225},
  {2.8835767060299114419518549e-124, 14, "28835767060299", -123},
  {6.2279168299040831848438509e-287, 17, "62279168299040832", -286},
  {1.6164607359991333488965688e-108, 8, "16164607", -107},
  {4.3219024239257239795796263e+304, 16, "4321902423925724", 305},
  {1.7163702469110582754891032e+193, 2, "17", 194},
  {5.2181317490689875200000000e+17, 4, "5218", 18},
  {3.9547211976388581785600000e+20, 6, "395472", 21},
  {9.1518134070411778078567431e-215, 18, "915181340704117781", -214},
  {1.0648187504281978581374313e-39, 3, "106", -38},
  {1.2457589642752679456439489e-244, 15, "124575896427527", -243},
  {9.7790298777943593750000000e+12, 21, "9779029877794359375", 13},
  {1.6837020249483062183925959e+151, 10, "1683702025", 152},
  {1.9808890480017226134103108e-257, 20, "19808890480017226134", -256},
  {3.1248000644218120117187500e+12, 11, "31248000644", 13},
  {1.2146932897421021412309792e+264, 6, "121469", 265},
  {1.2152906622926813308606371e-135, 10, "1215290662", -134},
  {8.2806222385980980486246175e-278, 3, "828", -277},
  {1.0936939007620919662400691e-290, 10, "1093693901", -289},
  {4.2313538416985956780331536e+289, 15, "42313538416986", 290},
  {4.3896444731932138666030291e+77, 10, "4389644473", 78},
  {1.1386665093845833493509859e+184, 11, "11386665094", 185},
  {2.0371086303857131732259147e-274, 3, "204", -273},
  {5.7203817923731506127335825e+152, 6, "572038", 153},
  {1.1338052546590198039633229e-90, 3, "113", -89},
  {3.5632256226137628435192186e-95, 21, "356322562261376284352", -94},
  {8.3089685303376105475376211e-272, 11, "83089685303", -271},
  {2.6787942733055011749267578e+10, 2, "27", 11},
  {9.1651129352099897511537399e+119, 17, "91651129352099898", 120},
  {9.6297426440929101029803241e+61, 5, "96297", 62},
  {2.2508548791171965599871809e-158, 9, "225085488", -157},
  {3.8553925883280783143481318e+127, 13, "3855392588328", 128},
  {3.4764567112311006897986153e+277, 16, "3476456711231101", 278},
  {2.5279692916688472559131328e+233, 6, "252797", 234},
  {8.4921992055244467549816003e-35, 16, "8492199205524447", -34},
  {2.8746084585961805455258028e-114, 5, "28746", -113},
  {5.4688849821312930445488812e-270, 11, "54688849821", -269},
  {6.1998216664042513094021616e+247, 4, "62", 248},
  {3.3068249308932800567292697e+100, 12, "330682493089", 101},
  {4.7358658326550107239390094e+213, 15, "473586583265501", 214},
  {7.9930405165522852249600000e+20, 20, "7993040516552285225", 21},
  {5.1117216996558482309184230e-172, 13, "5111721699656", -171},
  {1.2416299502212392690125853e+05, 12, "124162995022", 6},
  {1.9343673160853454890221828e+281, 7, "1934367", 282},
  {3.7289911496791303250983221e+86, 1, "4", 87},
  {2.1423656453803987888440718e+287, 13, "214236564538", 288},
  {4.7746592830696466702843322e+35, 4, "4775", 36},
  {8.3612610882191823007025064e-161, 5, "83613", -160},
  {1.1125388590951491275408664e+39, 14, "11125388590951", 40},
  {9.7948419401690514586421545e+132, 21, "979484194016905145864", 133},
  {2.6380696534489393176211026e-202, 16, "2638069653448939", -201},
  {3.3165176087799373672663221e-289, 18, "331651760877993737", -288},
  {3.4091285022857572293864824e-147, 5, "34091", -146},
  {2.0520446552052623707021432e-10, 17, "20520446552052624", -9},
  {9.7262967274414574344303611e-264, 21, "972629672744145743443", -263},
  {4.6248147624254067980962953e-92, 21, "46248147624254067981", -91},
  {2.0335467827834388985153970e-38, 18, "20335467827834389", -37},
  {2.2348325288273826970795598e+130, 11, "22348325288", 131},
  {3.0650739768919202664768190e-223, 8, "3065074", -222},
  {7.1617986868353816414164768e+35, 11, "71617986868", 36},
  {2.5697504252600013240032038e-219, 17, "25697504252600013", -218},
  {5.1566559322736668154874513e-14, 19, "5156655932273666815", -13},
  {2.2887461489069783473470276e-27, 3, "229", -26},
  {3.2193396632364169818174560e+02, 12, "321933966324", 3},
  {7.4390041846455009431628740e-304, 14, "74390041846455", -303},
  {3.7467303277543844267985424e+145, 9, "374673033", 146},
  {1.1602518037617608470668529e+00, 1, "1", 1},
  {2.2432370678088879117866957e-91, 20, "22432370678088879118", -90},
  {4.2440423478946468574529738e-206, 2, "42", -205},
  {4.0375141979363031839886220e-20, 17, "40375141979363032", -19},
  {1.4584972685774925484503665e+181, 16, "1458497268577493", 182},
  {9.4491121253052827750409442e+214, 7, "9449112", 215},
  {9.6286847493292671808715062e-228, 1, "1", -226},
  {3.6235445824144163301279531e+273, 21, "362354458241441633013", 274},
  {4.7490361134636248341122371e+61, 6, "474904", 62},
  {3.0167480207009974095858525e-276, 21, "301674802070099740959", -275},
  {1.1164058125483473117848064e+91, 9, "111640581", 92},
  {4.3145585214059703955041976e-59, 2, "43", -58},
  {1.9699100926792134825894248e+231, 3, "197", 232},
  {5.8928195242960461166956629e+280, 15, "589281952429605", 281},
  {4.6172191565422968051906818e-157, 11, "46172191565", -156},
  {6.1233553846954831456363930e+61, 3, "612", 62},
  {1.1211522013041366279770623e+144, 3, "112", 145},
  {7.5341030161633116842538503e+266, 5, "75341", 267},
  {1.3530834304693038926027308e-180, 4, "1353", -179},
  {3.7629079696589998006182739e+249, 12, "376290796966", 250},
  {4.7724549786913968412991306e-145, 15, "47724549786914", -144},
  {1.2860238916521265650335638e-200, 11, "12860238917", -199},
  {4.4626994992095889117651624e+40, 4, "4463", 41},
  {1.8916645368223074975043116e-93, 17, "18916645368223075", -92},
  {7.7039176936499239081876819e-114, 12, "770391769365", -113},
  {1.9201397201344744891849124e+172, 13, "1920139720134", 173},
  {5.2573775979550360937882825e+186, 15, "525737759795504", 187},
  {3.5775384291723132928000000e+19, 12, "357753842917", 20},
  {2.0537575033761071527719473e-177, 2, "21", -176},
  {9.4925607336702534464844540e-103, 18, "949256073367025345", -102},
  {1.6968947987297707446592018e-202, 7, "1696895", -201},
  {6.1850217952745433276228966e+215, 10, "6185021795", 216},
  {1.9789077887510114052279331e+211, 19, "1978907788751011405", 212},
  {9.6218546808297527554521262e+268, 18, "962185468082975276", 269},
  {4.3785564087777658964437122e-04, 1, "4", -3},
  {5.0655668811540344201479554e-120, 19, "506556688115403442", -119},
  {1.2240015196764768979695159e-74, 3, "122", -73},
  {9.9783097162437630947489691e+133, 9, "997830972", 134},
  {9.7050377163897891035543985e-137, 9, "970503772", -136},
  {8.7093904715262721812004009e-261, 5, "87094", -260},
  {1.5724236796762986183108194e-256, 20, "15724236796762986183", -255},
  {2.8855714167628618405980575e-56, 19, "2885571416762861841", -55},
  {1.6079910900946546081111551e+241, 4, "1608", 242},
  {1.7091931934311969092604642e-163, 6, "170919", -162},
  {9.8740012956322992841956373e+218, 15, "98740012956323", 219},
  {8.0388431991213139680977085e-239, 10, "8038843199", -238},
  {1.7662810068440564050270618e+27, 19, "1766281006844056405", 28},
  {2.0010325972408863667631028e+91, 5, "2001", 92},
  {6.5499679362973168517551064e-118, 19, "6549967936297316852", -117},
  {1.6328839159908036650705947e+284, 2, "16", 285},
  {1.6962361583021900552704884e-199, 11, "16962361583", -198},
  {1.5441789883095947149260750e+209, 2, "15", 210},
  {6.3206282535646319435072823e+210, 1, "6", 211},
  {5.8290010503892276961205436e-289, 20, "58290010503892276961", -288},
  {4.3400412504689604212283345e-64, 10, "434004125", -63},
  {4.6336160798711042187881936e-199, 6, "463362", -198},
  {1.2584768468750806514640591e+62, 2, "13", 63},
  {3.1438414482450141170462045e+29, 6, "314384", 30},
  {6.0160346433724216314857419e-46, 6, "601603", -45},
  {6.0841338030027515618920215e-161, 18, "608413380300275156", -160},
  {7.0228643618593910656370448e+279, 8, "70228644", 280},
  {2.0804541363000368283137812e-205, 15, "208045413630004", -204},
  {7.5223180866131208596712714e-305, 2, "75", -304},
  {1.5968445673770223158459119e+284, 14, "1596844567377", 285},
  {2.1674719315707002130012465e-184, 15, "21674719315707", -183},
  {1.9711865723769587047423967e-164, 14, "1971186572377", -163},
  {5.5148481721974017579189832e+282, 6, "551485", 283},
  {4.0121483772716381595920268e+204, 8, "40121484", 205},
  {7.7596491065515564451391594e+84, 7, "7759649", 85},
  {9.7298944236447886839890027e+291, 16, "9729894423644789", 292},
  {2.6771748606125163520000000e+18, 16, "2677174860612516", 19},
  {6.8330621736470855071660503e-181, 19, "6833062173647085507", -180},
  {6.8078272189956775292140236e-21, 2, "68", -20},
  {1.3421562897804439227688397e-164, 21, "134215628978044392277", -163},
  {1.4812198278411667314121528e-154, 3, "148", -153},
  {4.9363274070517827324322036e-259, 21, "493632740705178273243", -258},
  {1.8247373887433065248272981e-104, 1, "2", -103},
  {1.9448433059431710783465544e-235, 10, "1944843306", -234},
  {2.7637811100615897630102493e+54, 7, "2763781", 55},
  {6.5255762665213849593469397e+191, 9, "652557627", 192},
  {5.9749372624047044702391016e+307, 16, "5974937262404704", 308},
  {4.6260814465951331063921545e-231, 6, "462608", -230},
  {2.6444261222346688342524788e+251, 21, "264442612223466883425", 252},
  {3.3173286785827996742700260e-116, 7, "3317329", -115},
  {5.7538282672925764388919772e-192, 9, "575382827", -191},
  {5.2370619152229297745047068e-217, 18, "523706191522292977", -216},
  {1.8278199223930967236632855e-303, 1, "2", -302},
  {1.0587743487017519095636681e+76, 8, "10587743", 77},
  {1.0441529311895221529718329e-227, 16, "1044152931189522", -226},
  {4.8505516716546430252797399e-92, 8, "48505517", -91},
  {7.4952367934102327393349039e-291, 20, "74952367934102327393", -290},
  {3.2081819612766232693060761e-286, 4, "3208", -285},
  {4.2619308869116580542189978e+55, 21, "426193088691165805422", 56},
  {3.1643606855065962478297580e-149, 20, "31643606855065962478", -148},
  {2.4380892959661608778895575e+125, 15, "243808929596616", 126},
  {6.4787379721472289479405803e-22, 14, "64787379721472", -21},
  {3.5236982562464198701264942e+236, 13, "3523698256246", 237},
  {5.8855616486182798320209984e-71, 21, "588556164861827983202", -70},
  {2.4373358499543373684338885e-254, 21, "243733584995433736843", -253},
  {1.0124582413444648061523800e+181, 4, "1012", 182},
  {9.1514405386235072692281216e-298, 7, "9151441", -297},
  {3.0186747764475424682011930e+164, 16, "3018674776447542", 165},
  {5.1524792701540370391548276e-176, 16, "5152479270154037", -175},
  {8.5118184243004398529978612e+212, 16, "851181842430044", 213},
  {2.0201133295224430160586668e+65, 9, "202011333", 66},
  {7.6639819056312791124782230e-54, 11, "76639819056", -53},
  {3.8097416296845775107244415e-110, 21, "380974162968457751072", -109},
  {4.2120480049428007891694831e+241, 6, "421205", 242},
  {4.9108924120823677142621215e+129, 16, "4910892412082368", 130},
  {7.2883836456819113984000000e+19, 13, "7288383645682", 20},
  {9.5702367034294598510542529e-83, 11, "95702367034", -82},
  {1.4353804165382027301949278e+192, 18, "143538041653820273", 193},
  {6.1276724509863378203888133e-161, 10, "6127672451", -160},
  {5.7081313587763395798828006e+54, 8, "57081314", 55},
  {1.0439563084466439622947948e+87, 1, "1", 88},
  {1.4796333163801702257670858e-73, 11, "14796333164", -72},
  {4.6813328660263598592608044e+237, 4, "4681", 238},
  {3.2710012110958103530707537e+47, 15, "327100121109581", 48},
  {3.1734204028436262888135388e+04, 11, "31734204028", 5},
  {9.5654768197677173418611322e-82, 14, "95654768197677", -81},
  {9.0895828622227504941896680e+105, 11, "90895828622", 106},
  {3.1153693072743049920480537e+203, 18, "311536930727430499", 204},
  {2.8863959151161885820329189e+06, 19, "2886395915116188582", 7},
  {1.3176004344800519359850409e+111, 9, "131760043", 112},
  {6.3356130317601911741298363e+227, 9, "633561303", 228},
  {1.3832351114800096320478972e-303, 10, "1383235111", -302},
  {2.5493955151804910261461018e+158, 4, "2549", 159},
  {1.3765381673283055080889399e-227, 16, "1376538167328306", -226},
  {6.7133564315731934914414696e+217, 1, "7", 218},
  {2.7082099056376900097314652e+27, 8, "27082099", 28},
  {3.8238976576116140806595776e+304, 19, "3823897657611614081", 305},
  {2.3282341180677392656339183e+154, 9, "232823412", 155},
  {6.0099612594400058928003732e+112, 4, "601", 113},
  {5.2946367969998388595287231e+146, 12, "5294636797", 147},
  {1.2758717362834534317430616e+239, 15, "127587173628345", 240},
  {1.0871259614215231514965453e-137, 6, "108713", -136},
  {9.4915440726086754230030350e+117, 19, "9491544072608675423", 118},
  {1.2812541748308594644357252e-258, 3, "128", -257},
  {1.9623767389033019561567210e+72, 10, "1962376739", 73},
  {2.1956209404572884827737892e+294, 6, "219562", 295},
  {1.2151051873542026426910923e-02, 3, "122", -1},
  {3.7960045004250298350296437e-157, 15, "379600450042503", -156},
  {3.6272028707443515618082095e+166, 1, "4", 167},
  {1.8058591298242783588174188e+221, 19, "1805859129824278359", 222},
  {1.3604917449083129331813544e+73, 11, "13604917449", 74},
  {1.3058298824007079751578986e-259, 7, "130583", -258},
  {2.7967021587208081306244506e+70, 12, "279670215872", 71},
  {2.9138130638239866002559858e+179, 17, "29138130638239866", 180},
  {5.8189308258012262604753850e-279, 9, "581893083", -278},
  {1.1956563715905169798877049e-100, 20, "11956563715905169799", -99},
  {7.0566590567364052306732706e-264, 18, "705665905673640523", -263},
  {2.9567299228345166134362846e+67, 4, "2957", 68},
  {3.0586595046776090949443628e-149, 15, "305865950467761", -148},
  {3.4672715722227542608327913e+108, 18, "346727157222275426", 109},
  {8.2460549945179397104633339e-49, 16, "824605499451794", -48},
  {3.3092769806417320498541891e-174, 9, "330927698", -173},
  {1.6996670830864651914313728e+26, 7, "1699667", 27},
  {2.3716577408794704624254340e-275, 7, "2371658", -274},
  {1.5878548042055926466614233e-133, 5, "15879", -132},
  {2.7185671349430969381123945e+82, 3, "272", 83},
  {4.9085393483554161840563532e+293, 21, "490853934835541618406", 294},
  {5.0728758525603120582944338e-275, 21, "507287585256031205829", -274},
  {1.8791849269248863617606077e-159, 10, "1879184927", -158},
  {8.8458835150088834056361796e-159, 12, "884588351501", -158},
  {1.4169701260904121077392170e+284, 7, "141697", 285},
  {4.1517551149645045071976905e-100, 9, "415175511", -99},
  {4.1652939715616081045610512e+286, 5, "41653", 287},
  {3.5523751625319487165971226e+139, 8, "35523752", 140},
  {1.4194402283872885760000000e+18, 4, "1419", 19},
  {1.2734854661865753596982355e+265, 10, "1273485466", 266},
  {1.2506823387160303500463708e+215, 12, "125068233872", 216},
  {1.2999704856754556134972092e+75, 20, "12999704856754556135", 76},
  {8.1881954374951660633087158e+07, 15, "818819543749517", 8},
  {1.4797941171685435969247264e-98, 1, "1", -97},
  {9.3430804348920401424653084e+51, 18, "934308043489204014", 52},
  {1.4237125871945888909099687e+286, 18, "142371258719458889", 287},
  {6.3845501279277920716395524e-233, 4, "6385", -232},
  {3.0860314735893990136805536e+272, 17, "3086031473589399", 273},
  {3.6744170270066578737776100e-114, 9, "367441703", -113},
  {2.3316717791478924702331824e+166, 2, "23", 167},
  {5.4346863724760820877884157e+73, 2, "54", 74},
  {2.6170764994015880195915833e-190, 18, "261707649940158802", -189},
  {6.9050221260402477511877844e-140, 8, "69050221", -139},
  {1.8420607146673383419933609e-305, 15, "184206071466734", -304},
  {3.3741510320799950229913880e+238, 5, "33742", 239},
  {1.1147858135240316606503559e-51, 21, "111478581352403166065", -50},
  {1.0339420598439623943003669e-40, 11, "10339420598", -39},
  {1.1215255178782797092271768e-290, 2, "11", -289},
  {1.1370335674251913274266833e+132, 19, "1137033567425191327", 133},
  {2.8419585191254566623182159e+75, 12, "284195851913", 76},
  {2.0034621627606068377995003e-124, 7, "2003462", -123},
  {2.8010385702716489834504452e-62, 8, "28010386", -61},
  {5.1721289547976836649014661e+50, 18, "517212895479768366", 51},
  {9.2458892331672031736987793e-120, 11, "92458892332", -119},
  {3.2133300600232217934139356e-80, 18, "321333006002322179", -79},
  {4.2163435331150487143600062e+282, 5, "42163", 283},
  {2.7928635920596793600000000e+17, 8, "27928636", 18},
  {6.0256226111569828374208463e+61, 2, "6", 62},
  {4.7693360879661543337679664e+65, 17, "47693360879661543", 66},
  {1.5058812381858899560845584e+270, 4, "1506", 271},
  {4.1408311517140450711697975e+261, 16, "4140831151714045", 262},
  {1.6679045975813516067222045e+279, 19, "1667904597581351607", 280},
  {2.3485193237499654221851447e-156, 17, "23485193237499654", -155},
  {4.1074201339707619198284712e+212, 7, "410742", 213},
  {4.6179847506025340868109220e+211, 14, "46179847506025", 212},
  {3.2845244925312983916058778e-224, 9, "328452449", -223},
  {4.0345145532731562434917891e+291, 16, "4034514553273156", 292},
  {4.0397038125564982867989637e-45, 7, "4039704", -44},
  {2.0937894038018962943292273e-255, 6, "209379", -254},
  {2.7720614077757291963656924e+256, 20, "27720614077757291964", 257},
  {8.2600226830413822308341172e+79, 17, "82600226830413822", 80},
  {4.6444386303948343921043016e+64, 16, "4644438630394834", 65},
  {2.0611757542631456904095340e-298, 2, "21", -297},
  {1.0152962493780828848006278e-89, 14, "10152962493781", -88},
  {7.3362317695487006434245633e+158, 21, "733623176954870064342", 159},
  {5.1288518942343410356993560e-278, 5, "51289", -277},
  {1.0589133635523662498979179e-153, 5, "10589", -152},
  {3.4760932134534952179604905e-177, 5, "34761", -176},
  {1.3530081868076345023792703e+113, 15, "135300818680763", 114},
  {6.3731328479660400200621896e-147, 3, "637", -146},
  {1.0978304153584350298907609e-80, 16, "1097830415358435", -79},
  {2.3162328031630682518809718e-230, 2, "23", -229},
  {5.1222459708463360952680327e+307, 6, "512225", 308},
  {1.4528224775448717683570178e+47, 19, "1452822477544871768", 48},
  {1.1822517373010523670883710e-153, 5, "11823", -152},
  {3.3859396892475900892832168e+63, 15, "338593968924759", 64},
  {2.5275327799939121054157949e-64, 1, "3", -63},
  {4.7301839032364056860619970e+227, 20, "47301839032364056861", 228},
  {7.4279442031666939427276389e+70, 15, "742794420316669", 71},
  {9.5629010243751697040165376e-191, 10, "9562901024", -190},
  {1.4360252601742460126402672e+51, 3, "144", 52},
  {3.0646397860998139963021249e-111, 2, "31", -110},
  {2.9346868812935729170149655e-22, 13, "2934686881294", -21},
  {3.8212621164304355085516800e+23, 10, "3821262116", 24},
  {2.0204411817076161222178103e+167, 5, "20204", 168},
  {1.8414348264860536127020902e-29, 1, "2", -28},
  {5.0515005714109285572875063e-157, 5, "50515", -156},
  {2.7634727922308525418818992e+272, 5, "27635", 273},
  {2.3729880176501594964494317e-238, 2, "24", -237},
  {2.0379945707332159083881943e+169, 20, "20379945707332159084", 170},
  {3.8927579108812080965597069e-237, 11, "38927579109", -236},
  {8.7290614544413106813254553e-185, 15, "872906145444131", -184},
  {7.6987593317384779361131991e+130, 8, "76987593", 131},
  {5.6491748346006330869540138e+215, 16, "5649174834600633", 216},
  {7.6771110150487372017346624e+248, 10, "7677111015", 249},
  {1.0721562441146060228347778e+09, 13, "1072156244115", 10},
  {2.3926231139113022379412985e-283, 20, "23926231139113022379", -282},
  {8.7101902616845308626123584e+144, 19, "8710190261684530863", 145},
  {4.0522668967657625706408786e+147, 15, "405226689676576", 148},
  {3.4872387540021455086586402e+74, 18, "348723875400214551", 75},
  {4.2189357705300483055785529e-100, 10, "4218935771", -99},
  {1.0151798659773398931526427e-40, 5, "10152", -39},
  {7.4239350929223698934503784e-34, 14, "74239350929224", -33},
  {4.1797207906979901936060896e-208, 12, "41797207907", -207},
  {1.6926517877928896000000000e+16, 6, "169265", 17},
  {1.2873135084775035254900104e-19, 9, "128731351", -18},
  {6.1487566811268226564986944e+206, 20, "61487566811268226565", 207},
  {8.0353618376356212434143706e-11, 1, "8", -10},
  {6.9241302089002608276162670e-124, 17, "69241302089002608", -123},
  {1.6230590720482541603818774e+174, 16, "1623059072048254", 175},
  {1.5790806920858728501860316e+274, 4, "1579", 275},
  {2.9817028419988189034572306e-275, 18, "29817028419988189", -274},
  {1.3602469544647233539980891e-261, 6, "136025", -260},
  {7.5593134461111260687039028e+223, 13, "7559313446111", 224},
  {1.5597035518703951370567943e-55, 18, "155970355187039514", -54},
  {7.2199864730513970367823794e-21, 12, "721998647305", -20},
  {2.0597481618322446143988163e-134, 10, "2059748162", -133},
  {2.3546808642831262011248669e+88, 13, "2354680864283", 89},
  {7.8595517284510344961887101e-243, 15, "785955172845103", -242},
  {5.2505403538250243946820389e-269, 3, "525", -268},
  {3.5715186812774772720436304e+81, 8, "35715187", 82},
  {3.1020007111286378596709374e+263, 12, "310200071113", 264},
  {7.3797738440974469500982452e-70, 10, "7379773844", -69},
  {2.4075325909851181097052347e-31, 9, "240753259", -30},
  {6.8969192728554834493440000e+22, 19, "6896919272855483449", 23},
  {7.8612407471124915797162096e-39, 2, "79", -38},
  {1.1359222609913788693166169e+256, 19, "1135922260991378869", 257},
  {2.0213845735292062188680330e+149, 19, "2021384573529206219", 150},
  {8.5569354511503325122341094e-291, 16, "8556935451150333", -290},
  {8.7747695325845354137060813e+215, 4, "8775", 216},
  {8.5628247199701607613382500e-301, 11, "856282472", -300},
  {6.3610769577776150280139959e-207, 16, "6361076957777615", -206},
  {1.9466905034784109585268639e-21, 17, "1946690503478411", -20},
  {1.0933637146606537231654720e-138, 1, "1", -137},
  {1.3015050069696500339971506e-249, 3, "13", -248},
  {1.0992417696415109892447201e+194, 18, "109924176964151099", 195},
  {7.6197359841875074173262697e+199, 1, "8", 200},
  {1.2691624407578249346629090e-302, 4, "1269", -301},
  {5.7371151766990332251106446e-209, 10, "5737115177", -208},
  {1.9954515794542674156471030e+59, 13, "1995451579454", 60},
  {5.6527014651039652359255794e-211, 8, "56527015", -210},
  {4.0541911512222913153549045e-194, 5, "40542", -193},
  {1.6563521126327143272974548e-258, 15, "165635211263271", -257},
  {5.1470299104919088930612235e-204, 2, "51", -203},
  {3.2194457307451013050692457e-52, 7, "3219446", -51},
  {2.6294402957034349241396152e-174, 11, "26294402957", -173},
  {7.9895372043290716160000000e+18, 20, "7989537204329071616", 19},
  {6.2341108826364561281428877e-251, 10, "6234110883", -250},
  {1.3773424310347399688750427e+147, 12, "137734243103", 148},
  {5.5033117737142558537999929e+150, 20, "55033117737142558538", 151},
  {3.9335121330920445753589948e+265, 7, "3933512", 266},
  {1.6391504426307360626345429e-208, 15, "163915044263074", -207},
  {4.7658713033224210087936000e+22, 12, "476587130332", 23},
  {3.0677897215979022480970539e+93, 20, "30677897215979022481", 94},
  {1.1138305906937805750609902e-256, 10, "1113830591", -255},
  {9.0663896693824155551093025e-189, 5, "90664", -188},
  {6.9071522930150860578794929e-54, 1, "7", -53},
  {7.8838706326840742553974106e-04, 8, "78838706", -3},
  {5.4948516573698683695624695e+32, 9, "549485166", 33},
  {6.6907754863933754431168190e-286, 5, "66908", -285},
  {1.3782589208108569391372426e-247, 9, "137825892", -246},
  {2.7705750812353133923227335e+92, 19, "2770575081235313392", 93},
  {9.8896382340609887538312891e+173, 19, "9889638234060988754", 174},
  {8.8982047693490929136406305e+151, 10, "8898204769", 152},
  {7.7671888911094176115686106e+207, 8, "77671889", 208},
  {4.1564056987365892879470439e-185, 19, "4156405698736589288", -184},
  {9.8550278155526537612661995e+137, 16, "9855027815552654", 138},
  {1.2838866841808326361457614e-254, 15, "128388668418083", -253},
  {1.2648948811496403375447644e+120, 18, "126489488114964034", 121},
  {1.8220603776452237164741484e+117, 21, "182206037764522371647", 118},
  {1.7608485099650607489791654e+228, 6, "176085", 229},
  {1.2763597052270985459503308e+206, 5, "12764", 207},
  {3.6489439723383454647225574e+153, 14, "36489439723383", 154},
  {5.6671820499395667003584687e-10, 11, "56671820499", -9},
  {1.3093376170313885112184668e+45, 7, "1309338", 46},
  {7.2588060737749256270246501e+289, 10, "7258806074", 290},
  {8.7981087018781526153159653e+158, 8, "87981087", 159},
  {2.3851292956965527524209084e+270, 15, "238512929569655", 271},
  {1.4621823031840193610216258e-225, 2, "15", -224},
  {1.9713188339424198870844765e-158, 5, "19713", -157},
  {1.3654545728999513492917612e+248, 10, "1365454573", 249},
  {1.9457014488735809994069004e+123, 18, "1945701448873581", 124},
  {2.3994611026688489711729281e-90, 10, "2399461103", -89},
  {1.1713317468622390281174683e-90, 9, "117133175", -89},
  {5.2150629775182589148484549e-07, 15, "521506297751826", -6},
  {1.0698892574528390567244746e-247, 20, "10698892574528390567", -246},
  {1.3893676218338880766533223e+168, 1, "1", 169},
  {3.5931605890237630951670418e+83, 19, "3593160589023763095", 84},
  {6.4753758680463662432238108e+62, 9, "647537587", 63},
  {1.0252333706191388348169695e-155, 8, "10252334", -154},
  {1.3175226182663130129131726e-45, 10, "1317522618", -44},
  {4.7976851741708532879478609e-39, 1, "5", -38},
  {2.4568739825574226725377497e-284, 20, "24568739825574226725", -283},
  {2.1083314735310543007147831e-39, 1, "2", -38},
  {8.4861291543665058333461724e-151, 19, "8486129154366505833", -150},
  {2.6166844971902029172078307e-33, 18, "261668449719020292", -32},
  {2.8500189443242090518316572e-245, 16, "2850018944324209", -244},
  {2.3882743119432118890155803e-54, 12, "238827431194", -53},
  {1.6756194120096737012147385e-132, 21, "167561941200967370121", -131},
  {5.7165064943621714184801553e-286, 7, "5716506", -285},
  {7.5963665189102765634563140e-152, 8, "75963665", -151},
  {3.0567356312263428061360769e+156, 4, "3057", 157},
  {2.2363888221489279598347870e-135, 4, "2236", -134},
  {3.8984595704023834974529388e-69, 19, "3898459570402383497", -68},
  {6.6963979340549980162766571e+239, 20, "66963979340549980163", 240},
  {3.7842446300274874216268924e-222, 11, "378424463", -221},
  {1.9847682647486796741817355e-104, 16, "198476826474868", -103},
  {8.9244216610892309745889958e-295, 20, "89244216610892309746", -294},
  {3.2640033815176551326276961e-213, 17, "32640033815176551", -212},
  {7.8349838436456692409283906e-281, 13, "7834983843646", -280},
  {2.3770862978049245416271987e-156, 13, "2377086297805", -155},
  {1.8250431484172216403566274e-102, 4, "1825", -101},
  {2.0536906356967773662342798e+122, 14, "20536906356968", 123},
  {1.7620104503504715225143991e+180, 1, "2", 181},
  {1.6058278845767466422265293e-110, 10, "1605827885", -109},
  {6.1420739159396638008564198e-59, 19, "6142073915939663801", -58},
  {5.0067849548872401248127401e+45, 18, "500678495488724012", 46},
  {2.8130060148178179326403560e+144, 5, "2813", 145},
  {3.3950106369488792646001715e-18, 18, "339501063694887926", -17},
  {3.3764086599840423236382234e+204, 15, "337640865998404", 205},
  {4.9903110029333847710137327e-07, 16, "4990311002933385", -6},
  {3.4173431144566845783588818e+245, 2, "34", 246},
  {2.2335065257879962011773031e-66, 10, "2233506526", -65},
  {8.2534033032728884782194890e-252, 6, "82534", -251},
  {1.1031201280384448257561297e-23, 11, "1103120128", -22},
  {7.7514754104874994286866614e+112, 19, "7751475410487499429", 113},
  {3.3146155969592478412633069e+61, 18, "331461559695924784", 62},
  {1.5779686315604734193014993e-163, 17, "15779686315604734", -162},
  {6.3874438490974826525292153e-06, 8, "63874438", -5},
  {2.0547568087266752398561760e-305, 16, "2054756808726675", -304},
  {4.2228526210736389955996850e-62, 9, "422285262", -61},
  {1.3778887715905091119143301e-65, 12, "137788877159", -64},
  {2.1158329328809477556248810e-177, 14, "21158329328809", -176},
  {8.5997593250224133953452110e+05, 13, "8599759325022", 6},
  {2.9259187642822650911398593e+233, 2, "29", 234},
  {5.3356542121208162367351253e-197, 2, "53", -196},
  {6.1670106567536444391239972e+83, 8, "61670107", 84},
  {7.4517188693693405116330836e+48, 19, "7451718869369340512", 49},
  {2.8239738167848748030987305e-167, 1, "3", -166},
  {1.1071988293465944933070894e+204, 9, "110719883", 205},
  {2.3601674327271888063188694e-149, 12, "236016743273", -148},
  {3.5707475056917089759626053e-99, 15, "357074750569171", -98},
  {1.1065136086910253067625947e-266, 4, "1107", -265},
  {3.9898500917464250587677127e+282, 10, "3989850092", 283},
  {1.4409823537923117270556288e+121, 13, "1440982353792", 122},
  {1.6756741649058482999824424e-190, 9, "167567416", -189},
  {1.4897124617703587686371412e-192, 16, "1489712461770359", -191},
  {3.2467332765260517665708790e+150, 6, "324673", 151},
  {3.1888903001376026124094208e+218, 3, "319", 219},
  {1.1650912103006053229649940e+123, 15, "116509121030061", 124},
  {2.7817323794879701848635722e-247, 5, "27817", -246},
  {8.6465712248707112799942499e-133, 2, "86", -132},
  {2.4652783269589282011435156e-219, 3, "247", -218},
  {1.2226056973726969325623684e-213, 19, "1222605697372696933", -212},
  {1.2853606011093176027354905e+172, 9, "12853606", 173},
  {5.8320842526731294181068236e+63, 16, "5832084252673129", 64},
  {1.5382189251775611640702851e+80, 19, "1538218925177561164", 81},
  {7.9839772623494662720534568e-120, 12, "798397726235", -119},
  {1.2313961121308363787622734e-206, 1, "1", -205},
  {8.9764825484098253507405606e+166, 4, "8976", 167},
  {5.8944376513491502600909445e+198, 17, "58944376513491503", 199},
  {1.5035436505637510852924711e-223, 8, "15035437", -222},
  {4.2861288872149227052068906e-208, 5, "42861", -207},
  {3.9119738112980094130222493e+211, 8, "39119738", 212},
  {9.4512634121175957926230347e-144, 8, "94512634", -143},
  {1.7029991609630303332143559e+283, 11, "1702999161", 284},
  {1.4011498221316946143815071e+60, 10, "1401149822", 61},
  {1.0842053406853960502737485e-180, 20, "10842053406853960503", -179},
  {2.9236807185288291586721120e-213, 21, "292368071852882915867", -212},
  {1.1488661224475505171964424e-287, 21, "11488661224475505172", -286},
  {2.2175824802375569819026576e-129, 9, "221758248", -128},
  {1.5535683098026818386909155e+203, 10, "155356831", 204},
  {5.1714673862781106705057112e-87, 14, "51714673862781", -86},
  {5.1632531808113314768369792e-143, 7, "5163253", -142},
  {6.7354793786071772073792376e-131, 7, "6735479", -130},
  {2.1302264121503666793534846e-11, 14, "21302264121504", -10},
  {1.0608765194771863967873489e-234, 14, "10608765194772", -233},
  {3.8162237359216270482909548e-119, 20, "38162237359216270483", -118},
  {7.0026954930953587951319122e+27, 4, "7003", 28},
  {1.4699660012742828684937319e+126, 1, "1", 127},
  {1.0074538199290488060850801e-81, 19, "1007453819929048806", -80},
  {2.0218270176360881192960000e+21, 16, "2021827017636088", 22},
  {3.9299974102484509328680032e-200, 20, "39299974102484509329", -199},
  {6.1161005991882367109720505e+214, 6, "61161", 215},
  {9.6960918460595444745304890e-145, 4, "9696", -144},
  {1.1762165198437036476146148e-247, 19, "1176216519843703648", -246},
  {2.3769577192080494932729785e+141, 3, "238", 142},
  {1.9139951280814602340123227e+34, 17, "19139951280814602", 35},
  {2.5366705050640138175910172e-98, 19, "2536670505064013818", -97},
  {6.3008938744993748256614563e-263, 17, "63008938744993748", -262},
  {9.1369748280654887496032788e-63, 8, "91369748", -62},
  {2.6171833224457175820297679e+182, 19, "2617183322445717582", 183},
  {2.2483094266530918860443862e+135, 15, "224830942665309", 136},
  {2.5991622422704931235980083e+46, 10, "2599162242", 47},
  {4.6427702541628606618915410e-58, 6, "464277", -57},
  {4.0881136424037034157663584e+05, 9, "408811364", 6},
  {1.3995245027820005408685343e-95, 8, "13995245", -94},
  {5.5351766781365405768156052e+05, 4, "5535", 6},
  {4.3123650868525659320103235e+57, 17, "43123650868525659", 58},
  {7.2671595903247257913285305e+97, 7, "726716", 98},
  {3.8790374873502065419483752e-21, 11, "38790374874", -20},
  {5.6617836118371987102625994e+38, 7, "5661784", 39},
  {1.3835851374242401846438949e-84, 8, "13835851", -83},
  {1.0034814128063894761253150e+270, 21, "100348141280638947613", 271},
  {1.3376756939945601942060811e-303, 17, "13376756939945602", -302},
  {5.2554517220534241738123467e+219, 14, "52554517220534", 220},
  {1.4345410640725647675159083e+131, 8, "14345411", 132},
  {2.7783316780833533352473920e-275, 17, "27783316780833533", -274},
  {8.3063511002845409336714511e+00, 19, "8306351100284540934", 1},
  {7.0402816624658263547268697e+215, 9, "704028166", 216},
  {5.2683119025351222951112960e+53, 20, "52683119025351222951", 54},
  {4.4925579364972283441303090e+306, 6, "449256", 307},
  {1.2098744869829846200655290e+221, 11, "1209874487", 222},
  {1.5266413568574901764464782e-107, 17, "15266413568574902", -106},
  {4.7593504737790482129117334e-36, 2, "48", -35},
  {1.0611182122729130845299057e+181, 4, "1061", 182},
  {1.5397952691340625286102295e+07, 12, "153979526913", 8},
  {1.1791668391365211799989537e+278, 18, "117916683913652118", 279},
  {5.3253324433223770677636565e+75, 9, "532533244", 76},
  {2.6936833538221640008009953e+76, 14, "26936833538222", 77},
  {3.7399969264060617604062824e+118, 19, "373999692640606176", 119},
  {1.6530217430438594694745080e+99, 6, "165302", 100},
  {1.3402202850623735736986832e-05, 1, "1", -4},
  {3.0135058172389371022318298e-30, 8, "30135058", -29},
  {5.7365052399275011597621569e+302, 6, "573651", 303},
  {1.1454833498955847045457797e-29, 1, "1", -28},
  {5.2770332140269221815454741e-150, 18, "527703321402692218", -149},
  {6.8881427529313904640000000e+18, 12, "688814275293", 19},
  {6.8159494384291791974587112e+264, 20, "68159494384291791975", 265},
  {1.4459140870360893961384173e-183, 12, "144591408704", -182},
  {8.0640287836411134236714284e-129, 3, "806", -128},
  {9.7390375728897609925359153e+253, 2, "97", 254},
  {1.2800312243005789664873068e+67, 16, "1280031224300579", 68},
  {2.7430640557533960609180851e-249, 10, "2743064056", -248},
  {2.7197889981786681370368785e+51, 14, "27197889981787", 52},
  {2.5416277569648470600286665e+162, 15, "254162775696485", 163},
  {2.8310632039733496867484064e+02, 14, "28310632039733", 3},
  {5.1096946349357817799871899e+83, 9, "510969463", 84},
  {1.1805897795841554720721238e-44, 9, "118058978", -43},
  {3.7471959207957560731673056e-125, 1, "4", -124},
  {5.8416503900600756680224815e+52, 2, "58", 53},
  {6.6945519764159511631565824e-241, 17, "66945519764159512", -240},
  {2.7426174710571031350976670e+212, 7, "2742617", 213},
  {4.6988500694782503204666418e-253, 19, "469885006947825032", -252},
  {3.0638881500533052211551837e-81, 3, "306", -80},
  {1.4407610577766563544861562e-131, 4, "1441", -130},
  {3.1938425210866710384353286e-18, 17, "3193842521086671", -17},
  {3.5663857021812924804687500e+12, 12, "356638570218", 13},
  {9.9794677247724151997291331e+285, 8, "99794677", 286},
  {8.9515300325067633389408709e-275, 12, "895153003251", -274},
  {3.5803925288617022528312704e-95, 18, "358039252886170225", -94},
  {5.6059984295225707516514126e-161, 14, "56059984295226", -160},
  {1.8276177021966588730526917e+153, 16, "1827617702196659", 154},
  {2.2292505232220626884557420e+297, 17, "22292505232220627", 298},
  {1.5399117459083779304901822e-61, 8, "15399117", -60},
  {3.3572671229245586786098890e+100, 2, "34", 101},
  {8.4139090344827232067603361e-07, 17, "84139090344827232", -6},
  {9.4823884849052419162894732e+130, 3, "948", 131},
  {1.8543152745330921937248075e-259, 14, "18543152745331", -258},
  {2.2022576675810845955828888e-103, 16, "2202257667581085", -102},
  {2.4998915353383107222842089e-262, 13, "2499891535338", -261},
  {8.9277612038047846533532009e+51, 4, "8928", 52},
  {4.2863877667924751756984349e-246, 15, "428638776679248", -245},
  {9.9382620899899847789242758e-125, 19, "9938262089989984779", -124},
  {6.1720694802122151828279389e-119, 13, "6172069480212", -118},
  {8.6298662071403866930797314e-262, 11, "86298662071", -261},
  {2.0420485858922885108955589e-48, 20, "20420485858922885109", -47},
  {8.3166326596864407320653823e+215, 2, "83", 216},
  {4.5308055118081357496876843e+185, 2, "45", 186},
  {2.6115579250116314784892737e-136, 15, "261155792501163", -135},
  {1.1275672923011013665695248e+184, 20, "11275672923011013666", 185},
  {6.0670076623109648878164110e-96, 9, "606700766", -95},
  {1.0014619531566521761822058e-210, 3, "1", -209},
  {3.0376922043355777746366969e+148, 20, "30376922043355777746", 149},
  {7.2016200778440065449176761e-206, 11, "72016200778", -205},
  {4.6125463034128785145270468e+61, 6, "461255", 62},
  {5.9333593190108221821149484e-142, 17, "59333593190108222", -141},
  {5.6155298973009769020112935e-138, 20, "5615529897300976902", -137},
  {3.2364814548063249588012695e+09, 18, "323648145480632496", 10},
  {2.8833969306965164786026900e+114, 7, "2883397", 115},
  {9.3741921662008283116751569e+297, 5, "93742", 298},
  {1.1149935945080330007221076e-155, 8, "11149936", -154},
  {1.3859849154211896554402880e-111, 4, "1386", -110},
  {4.3539536952934017440059007e+175, 14, "43539536952934", 176},
  {5.7551507533295142600825697e+290, 19, "575515075332951426", 291},
  {4.8918995124785439289254196e+45, 1, "5", 46},
  {2.9416153251427942739688138e-234, 18, "294161532514279427", -233},
  {4.0529276360615465704311328e-227, 8, "40529276", -226},
  {4.9073461918332056011148013e-158, 7, "4907346", -157},
  {6.7085859865191314358331668e-81, 11, "67085859865", -80},
  {8.6569004817329612538301582e-206, 9, "865690048", -205},
  {1.8445083178285775557027390e+87, 16, "1844508317828578", 88},
  {5.8199607753383405027455874e+74, 7, "5819961", 75},
  {1.4034144283165731122071195e-34, 12, "140341442832", -33},
  {6.4617889921254059849193986e+283, 11, "64617889921", 284},
  {1.5281745281829689658714466e-25, 8, "15281745", -24},
  {9.1142658717729091790669686e-86, 7, "9114266", -85},
  {2.1841729243172221078884556e+172, 7, "2184173", 173},
  {6.0937117952852982063899713e-118, 17, "60937117952852982", -117},
  {6.5275842284978865515290986e+230, 6, "652758", 231},
  {1.2555283596821458514861195e+184, 4, "1256", 185},
  {1.6468756180979581162446152e-285, 11, "16468756181", -284},
  {4.8537930210844894127420099e-169, 21, "485379302108448941274", -168},
  {1.6182605834442173590006803e-111, 6, "161826", -110},
  {4.5445698885450759199408818e+88, 14, "45445698885451", 89},
  {8.6638659232649883202529282e-127, 9, "866386592", -126},
  {1.7066096824315082634001812e+161, 10, "1706609682", 162},
  {1.3428716896225597958552411e+303, 18, "13428716896225598", 304},
  {1.5949067217794978144963656e+88, 19, "1594906721779497814", 89},
  {5.0653196280772088598474963e+255, 19, "506531962807720886", 256},
  {5.0387941506181821726316243e-144, 20, "50387941506181821726", -143},
  {3.9995432015650295985348694e-91, 11, "39995432016", -90},
  {8.4779890313500664434936172e-289, 7, "8477989", -288},
  {1.8837034121287814348800000e+20, 14, "18837034121288", 21},
  {1.0084952849985830274208250e-166, 11, "1008495285", -165},
  {3.4863707410754683489899577e-272, 16, "3486370741075468", -271},
  {5.8998729852526410635969639e+84, 21, "58998729852526410636", 85},
  {2.8833053148547579811560283e+50, 10, "2883305315", 51},
  {2.3789380853668934493670806e+86, 12, "237893808537", 87},
  {3.3530299175852925231218696e-174, 2, "34", -173},
  {1.0439352438262588254011133e+189, 13, "1043935243826", 190},
  {5.4564228727021981582160916e+187, 6, "545642", 188},
  {2.4226308916283778595459217e+275, 4, "2423", 276},
  {4.7013672735731665811105471e+129, 16, "4701367273573167", 130},
  {9.5673214598572514854439284e-183, 12, "956732145986", -182},
  {1.3147743141702238070930169e-243, 5, "13148", -242},
  {5.3426239883134193764575535e+43, 17, "53426239883134194", 44},
  {2.4911683456624357814126834e+141, 7, "2491168", 142},
  {6.3960603738618288627269496e-63, 1, "6", -62},
  {1.3577122612629767622215838e-80, 16, "1357712261262977", -79},
  {1.7148246280261294521501118e-127, 1, "2", -126},
  {1.6641304651880653510291491e+145, 10, "1664130465", 146},
  {3.1200573882656426213563681e+58, 3, "312", 59},
  {4.4933957216365600582526647e+129, 20, "44933957216365600583", 130},
  {2.1720152787148624912523004e-53, 15, "217201527871486", -52},
  {5.6922833996700597183358330e+30, 4, "5692", 31},
  {1.8457883698161912466752115e+58, 6, "184579", 59},
  {9.3356075747281954054683494e-140, 5, "93356", -139},
  {3.0372125173160589997786137e-278, 2, "3", -277},
  {3.2528107585483000863496195e-261, 21, "325281075854830008635", -260},
  {1.6136727083041149874972541e-22, 10, "1613672708", -21},
  {1.4834364563698367211744808e-101, 19, "1483436456369836721", -100},
  {5.2615769373122054817506130e-188, 7, "5261577", -187},
  {4.5926920341153412179862782e-300, 3, "459", -299},
  {2.1320526907337385719571167e+130, 11, "21320526907", 131},
  {5.7167654442565246204525011e-164, 8, "57167654", -163},
  {3.5798075545349661444178473e-194, 18, "357980755453496614", -193},
  {6.6753108457897637836137574e-303, 12, "667531084579", -302},
  {2.1234532528581566223730854e-208, 8, "21234533", -207},
  {1.3095819641976216391159434e-202, 17, "13095819641976216", -201},
  {4.5776226589544046402216191e-116, 4, "4578", -115},
  {1.5365645574851942423702305e+262, 8, "15365646", 263},
  {1.8035903682783569050489785e+147, 6, "180359", 148},
  {2.7989433449828620030107172e+92, 5, "27989", 93},
  {5.6899116327615954452985188e+54, 9, "568991163", 55},
  {4.8600824938901341231255491e-106, 3, "486", -105},
  {4.4680767580513098883137536e+26, 7, "4468077", 27},
  {3.0470162025517160745630668e+38, 12, "304701620255", 39},
  {2.6026469332958067833495482e-64, 12, "26026469333", -63},
  {4.5944614946384282482499604e+179, 20, "45944614946384282482", 180},
  {8.0161264254928966304564299e-111, 11, "80161264255", -110},
  {4.0193652142711481403490699e+45, 1, "4", 46},
  {1.1863526157365380402340685e+173, 5, "11864", 174},
  {2.0519973078990854013366208e+253, 21, "205199730789908540134", 254},
  {3.5206517721407598233315860e-269, 5, "35207", -268},
  {1.0370044352306973156367939e-17, 11, "10370044352", -16},
  {7.5225444963959554922557949e-286, 13, "7522544496396", -285},
  {3.9292528980505282856634078e+82, 11, "39292528981", 83},
  {1.0828721740204595271172330e-14, 12, "108287217402", -13},
  {5.1946696259845121329535972e-281, 6, "519467", -280},
  {6.9158002193092066480031720e+125, 19, "6915800219309206648", 126},
  {6.6402986994566541485829434e+85, 14, "66402986994567", 86},
  {3.9643841017863339701537070e+159, 11, "39643841018", 160},
  {2.1029175922771438798692619e-256, 13, "2102917592277", -255},
  {2.7575832534954659601793240e+194, 21, "275758325349546596018", 195},
  {8.7666310123984999261426375e-119, 6, "876663", -118},
  {1.2862637457446017544415438e+149, 5, "12863", 150},
  {3.8921708183256388450463432e+301, 8, "38921708", 302},
  {2.4593728887008443373589699e+173, 15, "245937288870084", 174},
  {2.4596595882848790024179827e-276, 8, "24596596", -275},
  {1.3069547651391749393057205e-223, 17, "13069547651391749", -222},
  {9.6970139040878291602402818e-115, 11, "96970139041", -114},
  {7.8562395761591576903826379e-60, 1, "8", -59},
  {5.6845761505182582259963895e-28, 14, "56845761505183", -27},
  {2.4885485763382259503026131e+33, 6, "248855", 34},
  {6.1371034848057581848851054e-166, 11, "61371034848", -165},
  {1.7657916843033744942540789e+239, 19, "1765791684303374494", 240},
  {9.4997184232378745056554299e-108, 7, "9499718", -107},
  {1.8851424235011658107150274e-190, 16, "1885142423501166", -189},
  {6.9438143235377463004604108e-266, 16, "6943814323537746", -265},
  {4.0831536138560027007524006e+278, 10, "4083153614", 279},
  {2.9989746961597813405841457e-72, 4, "2999", -71},
  {5.5028489916632294123441186e+46, 8, "5502849", 47},
  {2.6313698313512237614410984e-235, 14, "26313698313512", -234},
  {3.3510188834995916642258482e-68, 21, "335101888349959166423", -67},
  {3.4420020604570665009549237e+124, 7, "3442002", 125},
  {1.4269338936129463088741173e-95, 9, "142693389", -94},
  {1.6781155579591058695850767e+273, 17, "16781155579591059", 274},
  {2.8256305253669548910114746e+127, 7, "2825631", 128},
  {1.5997477257654892701801137e-24, 13, "1599747725765", -23},
  {2.9697879156905546693678843e+01, 6, "296979", 2},
  {2.9986149259771893139726644e-53, 17, "29986149259771893", -52},
  {1.3289425597888355522362284e-183, 15, "132894255978884", -182},
  {7.2729897129603781713460178e+261, 17, "72729897129603782", 262},
  {4.0011227752501347333364792e+304, 3, "4", 305},
  {3.6571957970889551353607657e-244, 7, "3657196", -243},
  {5.3990144492545324230166852e+94, 5, "5399", 95},
  {6.6537371517277695800268208e+229, 7, "6653737", 230},
  {5.8184175335196566942881005e+84, 21, "581841753351965669429", 85},
  {3.1637738529507677439787318e+72, 20, "3163773852950767744", 73},
  {6.4501231276848311667521145e+303, 6, "645012", 304},
  {5.8070783475426947794516485e+55, 4, "5807", 56},
  {7.8286930697845044342138262e-188, 18, "782869306978450443", -187},
  {1.1759520022412148594639140e+90, 18, "117595200224121486", 91},
  {2.0432550539601918828813862e+176, 19, "2043255053960191883", 177},
  {7.5701004021706617286578067e+206, 19, "7570100402170661729", 207},
  {2.7323508255703688263916125e-241, 17, "27323508255703688", -240},
  {4.6738510371378292922263097e-184, 20, "46738510371378292922", -183},
  {2.8725836964750043378528486e-110, 18, "287258369647500434", -109},
  {2.5495190001649145128020197e-167, 12, "254951900016", -166},
  {6.4923469376577940333441377e+152, 4, "6492", 153},
  {1.5948426319911623310163241e+150, 16, "1594842631991162", 151},
  {3.9788845882662173481954421e+237, 11, "39788845883", 238},
  {6.2174133351304239531786880e-90, 5, "62174", -89},
  {3.2408851019182167538226355e+287, 8, "32408851", 288},
  {2.8849271977260771383136908e+259, 8, "28849272", 260},
  {5.8909880216406092916300215e+168, 5, "5891", 169},
  {3.1407470460562322047443791e+296, 3, "314", 297},
  {4.0594423574823112756763351e+185, 8, "40594424", 186},
  {4.8430563383148008070678201e-148, 13, "4843056338315", -147},
  {4.3505477828021284681561220e-126, 11, "43505477828", -125},
  {2.9646108620135498093282083e+204, 6, "296461", 205},
  {3.8431235051394049148402923e+132, 18, "384312350513940491", 133},
  {9.5463631730437139298240034e+65, 18, "954636317304371393", 66},
  {1.0034139374016787671874164e+66, 17, "10034139374016788", 67},
  {9.0775369803885619025207840e-162, 20, "90775369803885619025", -161},
  {6.7688444825290937411988827e-209, 10, "6768844483", -208},
  {1.5006521427606046557993441e+272, 5, "15007", 273},
  {6.4845898894459932735213753e+172, 17, "64845898894459933", 173},
  {4.9608412605263741467141749e-20, 1, "5", -19},
  {4.7611659797176949203423302e-04, 18, "476116597971769492", -3},
  {9.4182327418813495769792137e-246, 1, "9", -245},
  {4.5936802488292148399659792e-246, 13, "4593680248829", -245},
  {4.0917174053031485861031608e+256, 8, "40917174", 257},
  {2.0165020996393217333298314e+70, 6, "20165", 71},
  {2.5533436972543753870638528e+228, 10, "2553343697", 229},
  {8.0226506235467168751813705e-75, 19, "8022650623546716875", -74},
  {5.7368697329730660802886116e-284, 11, "5736869733", -283},
  {1.0466286110439176890396780e-203, 4, "1047", -202},
  {9.1128239948475285857866900e+137, 8, "9112824", 138},
  {1.3869278591729884955631711e+72, 10, "1386927859", 73},
  {6.8114674881980565375071906e-124, 7, "6811467", -123},
  {9.6885916227073160519332738e-93, 5, "96886", -92},
  {2.7358807337123399327089617e+194, 14, "27358807337123", 195},
  {2.9663415741884152100924488e+215, 5, "29663", 216},
  {7.3852809766093451599151023e-262, 10, "7385280977", -261},
  {1.6007614929023042559744917e+139, 21, "160076149290230425597", 140},
  {3.2360243843536667558345909e+31, 8, "32360244", 32},
  {4.4159640248126189988277979e-268, 17, "4415964024812619", -267},
  {3.5497656737395401474786403e-44, 17, "35497656737395401", -43},
  {1.5532506480335817752636509e+63, 3, "155", 64},
  {1.1445035177353798096438526e+239, 5, "11445", 240},
  {1.7348423481804733481205790e+304, 8, "17348423", 305},
  {3.4939711852528224699199200e+06, 19, "349397118525282247", 7},
  {5.1962009941900724163031908e-253, 18, "519620099419007242", -252},
  {3.0579821778970111333156793e-72, 13, "3057982177897", -71},
  {2.5570408486830875110795061e-104, 16, "2557040848683088", -103},
  {5.6525273832316046601180848e-286, 20, "56525273832316046601", -285},
  {7.6079906905566028991708973e-205, 1, "8", -204},
  {1.4748027423926133345344054e-251, 18, "147480274239261333", -250},
  {4.0289054091537250163008230e-299, 2, "4", -298},
  {9.7653967685771847283083191e+60, 14, "97653967685772", 61},
  {7.3575997917291359640790302e-286, 9, "735759979", -285},
  {1.8395191231617215186639992e-59, 14, "18395191231617", -58},
  {5.8296677612241339698634820e-291, 8, "58296678", -290},
  {1.3454160133111873718563689e-160, 18, "134541601331118737", -159},
  {5.1777111832466702846433031e-192, 3, "518", -191},
  {1.0493033810782400481012537e-204, 1, "1", -203},
  {9.0055991163036752647444642e+167, 7, "9005599", 168},
  {1.1965545488294288859256340e-299, 2, "12", -298},
  {5.7750054344232625000000000e+14, 7, "5775005", 15},
  {1.7955995898028055398252988e-116, 1, "2", -115},
  {6.9140500979592117142214182e-75, 21, "691405009795921171422", -74},
  {1.4085239243754408298799909e-307, 13, "1408523924375", -306},
  {7.4551839922432080003592171e-228, 11, "74551839922", -227},
  {2.1730411880007765331668662e-16, 12, "2173041188", -15},
  {5.3603766961971640791991413e-290, 6, "536038", -289},
  {7.5538903423236488901276147e-277, 19, "755389034232364889", -276},
  {3.7646276970764166514744525e-255, 5, "37646", -254},
  {6.5631290642178004458675349e-306, 17, "65631290642178004", -305},
  {1.1721767499550289930867106e-247, 4, "1172", -246},
  {5.4123939637031380960856258e+63, 10, "5412393964", 64},
  {6.5340959652172115433429284e+299, 2, "65", 300},
  {2.4509187735250200759595005e-240, 14, "2450918773525", -239},
  {5.2263590635688099615128765e+62, 10, "5226359064", 63},
  {1.4608804017478235964042340e-274, 12, "146088040175", -273},
  {5.9280614864877570485777748e+70, 19, "5928061486487757049", 71},
  {9.2292959592778204759366870e-266, 18, "922929595927782048", -265},
  {9.0525788344278339355047591e-253, 14, "90525788344278", -252},
  {2.5638702512603347564565134e+173, 1, "3", 174},
  {2.1692984304848126695005517e-270, 19, "216929843048481267", -269},
  {5.6334296442582584785176189e-69, 11, "56334296443", -68},
  {3.4515139592869245596879068e+154, 19, "345151395928692456", 155},
  {4.9770461460429307547267749e+154, 3, "498", 155},
  {4.6215094949992124854199206e+128, 18, "462150949499921249", 129},
  {2.7983421350466076040705347e+35, 9, "279834214", 36},
  {1.3459004823673771874671385e-217, 10, "1345900482", -216},
  {2.9955891979434143744901023e-74, 6, "299559", -73},
  {3.4239917040884205589822802e-12, 1, "3", -11},
  {1.7226733215123721475320103e-244, 6, "172267", -243},
  {1.1142719526036543803062420e+281, 1, "1", 282},
  {6.0001827526579868935678795e-49, 6, "600018", -48},
  {3.0657101693599299707638855e+86, 3, "307", 87},
  {3.9146803347726595287123745e+219, 3, "391", 220},
  {1.2579315807337874811662512e-68, 10, "1257931581", -67},
  {2.7382791897768547945161194e-182, 5, "27383", -181},
  {9.0191939246733356176813758e+82, 19, "9019193924673335618", 83},
  {3.8900888241536271643693053e+173, 13, "3890088824154", 174},
  {1.3197876340360387580130736e-127, 11, "1319787634", -126},
  {1.6773540780886508078774600e+306, 14, "16773540780887", 307},
  {9.6772882698132819694581846e+286, 20, "96772882698132819695", 287},
  {4.9629937376145629967902006e+244, 2, "5", 245},
  {1.1603853297838037602506692e+262, 16, "1160385329783804", 263},
  {4.1894960318912652567185300e+298, 4, "4189", 299},
  {6.5806324910033206534792057e+282, 2, "66", 283},
  {1.9544394480680899113163004e-87, 14, "19544394480681", -86},
  {4.9448887468526529401511945e-57, 11, "49448887469", -56},
  {1.9362162435984317447221034e-100, 11, "19362162436", -99},
  {1.0048276142235186752421988e-112, 13, "1004827614224", -111},
  {2.9916752687614534270527718e+296, 14, "29916752687615", 297},
  {8.9569673074705826948318132e+57, 10, "8956967307", 58},
  {1.2398308670405296152194181e-243, 7, "1239831", -242},
  {6.1848229166297685006389477e-72, 15, "618482291662977", -71},
  {6.6205137454474370315438136e+03, 12, "662051374545", 4},
  {2.4820172565567958207092145e+183, 8, "24820173", 184},
  {3.6879778034984006709030962e-47, 3, "369", -46},
  {2.8278202422409578856790592e+162, 1, "3", 163},
  {5.6296082300758302011852327e-187, 11, "56296082301", -186},
  {9.5769147361792688753083652e+235, 15, "957691473617927", 236},
  {2.6608500698273652964164239e+110, 2, "27", 111},
  {1.1257355288777615037621057e-212, 6, "112574", -211},
  {7.5636576911451798937739255e-117, 1, "8", -116},
  {8.7637634365542653932945360e+114, 2, "88", 115},
  {4.3666765569334833302725068e-256, 15, "436667655693348", -255},
  {1.0853573564099731572105171e+99, 3, "109", 100},
  {3.8611090133980183315048750e-126, 11, "38611090134", -125},
  {8.3809505346149202702548135e-198, 9, "838095053", -197},
  {9.3358035115799186780547618e-262, 13, "933580351158", -261},
  {1.1575735379176865060016821e-232, 1, "1", -231},
  {3.0278156443244135714069451e-270, 16, "3027815644324414", -269},
  {4.1254109092380688469209685e+164, 20, "41254109092380688469", 165},
  {2.5169931421499781009519102e-155, 8, "25169931", -154},
  {2.0144256936722526542023396e-233, 11, "20144256937", -232},
  {4.3116323979515221170898139e+168, 17, "43116323979515221", 169},
  {5.9991493308333893748646799e-184, 21, "599914933083338937486", -183},
  {1.2369996750999286652835745e-263, 8, "12369997", -262},
  {1.7770077203110480579294116e+103, 15, "177700772031105", 104},
  {8.7190242261912183888427285e-239, 14, "87190242261912", -238},
  {2.0592105033620523843077593e-49, 12, "205921050336", -48},
  {6.3168431686178367261085413e+72, 5, "63168", 73},
  {1.5058866943228092731804712e+231, 12, "150588669432", 232},
  {4.5413729659934279397601662e-94, 4, "4541", -93},
  {6.9742312984477101099119723e-165, 7, "6974231", -164},
  {1.5383354284317435319721156e-58, 8, "15383354", -57},
  {5.3320400886396071548831383e-297, 15, "533204008863961", -296},
  {2.8416829584182278842841622e-167, 6, "284168", -166},
  {1.9912834377618188286339994e-220, 8, "19912834", -219},
  {1.9688041725419987518353787e+226, 19, "1968804172541998752", 227},
  {9.1728975487009661279774275e-181, 9, "917289755", -180},
  {6.0677452798888666120611337e+41, 9, "606774528", 42},
  {1.7087545429825288644515936e-289, 5, "17088", -288},
  {4.7559696545926970755292939e+201, 2, "48", 202},
  {3.4147519710508410934642344e+28, 2, "34", 29},
  {3.7593138281137818662257953e-213, 13, "3759313828114", -212},
  {4.6149544185237761858968700e+272, 4, "4615", 273},
  {2.3445612829190797089020830e-128, 2, "23", -127},
  {1.9254439571439353134131700e-45, 6, "192544", -44},
  {4.0827019767273472931400006e-244, 20, "40827019767273472931", -243},
  {3.1798848642135473192194770e-196, 10, "3179884864", -195},
  {6.6594201908087182079926356e+269, 4, "6659", 270},
  {1.1836900147831000876999491e-286, 9, "118369001", -285},
  {1.0338815207337224511867022e+86, 13, "1033881520734", 87},
  {3.7312651275040004429474742e-184, 12, "37312651275", -183},
  {3.9495272789565202957687599e-305, 9, "394952728", -304},
  {2.4671805261194743110333287e+286, 5, "24672", 287},
  {1.2248332134119045086075617e+100, 18, "122483321341190451", 101},
  {2.9366098185573657826254225e+260, 14, "29366098185574", 261},
  {4.3907989541145728519720956e+294, 21, "439079895411457285197", 295},
  {6.2837624776417671289145135e-74, 5, "62838", -73},
  {6.2916891152106930312770672e-03, 21, "629168911521069303128", -2},
  {1.0386025891628699244243105e-09, 21, "103860258916286992442", -8},
  {9.5999664462569173310792894e-53, 1, "1", -51},
  {1.7594952027314018396657410e+149, 7, "1759495", 150},
  {1.1810345241194620223638658e+137, 15, "118103452411946", 138},
  {1.7813507476621425898475338e+235, 6, "178135", 236},
  {6.3208324464073676475927384e+279, 2, "63", 280},
  {3.9034068019430639364777949e-88, 17, "39034068019430639", -87},
  {3.0069057008867286969230717e+47, 14, "30069057008867", 48},
  {7.2879120977068660673264189e-99, 8, "72879121", -98},
  {2.6161869666058979456262386e-280, 6, "261619", -279},
  {6.9585750920415571065455780e+284, 13, "6958575092042", 285},
  {3.2040739261448573829925594e+61, 3, "32", 62},
  {6.9026201721427532180557529e-103, 6, "690262", -102},
  {1.6076286945792356930214992e-27, 19, "1607628694579235693", -26},
  {5.8304549350631827613403395e+146, 4, "583", 147},
  {1.2561375656760239442062934e-263, 12, "125613756568", -262},
  {1.9796795355058803852878132e+214, 7, "197968", 215},
  {2.4507660739738678055225337e+138, 3, "245", 139},
  {2.5421487614571223635826800e-281, 19, "2542148761457122364", -280},
  {7.4347835221230527050850723e+36, 21, "743478352212305270509", 37},
  {1.9574317068067087878555968e-31, 10, "1957431707", -30},
  {6.8366307666222171170718203e+226, 4, "6837", 227},
  {2.5629594310083257111794650e+54, 12, "256295943101", 55},
  {4.0646760312530197504232401e+137, 17, "40646760312530198", 138},
  {1.8841476048933619807562619e+300, 2, "19", 301},
  {3.2266457428204177214516309e+60, 4, "3227", 61},
  {2.0048970019613425972985273e+164, 6, "20049", 165},
  {1.3656420225466941701597534e+04, 20, "13656420225466941702", 5},
  {1.6207367985024376255687173e-01, 13, "1620736798502", 0},
  {4.3249212968620756465194377e-78, 1, "4", -77},
  {9.1589702522424066871722636e-67, 2, "92", -66},
  {2.8515583231357711354480074e+192, 13, "2851558323136", 193},
  {9.7176763919089508851677962e-247, 16, "9717676391908951", -246},
  {4.0235154234884764681343614e-78, 3, "402", -77},
  {1.4648315572115261072963703e+110, 4, "1465", 111},
  {1.0785349001578586640788382e+162, 7, "1078535", 163},
  {1.4067546655935728912319261e+245, 4, "1407", 246},
  {2.0247686258064387982668928e-166, 12, "202476862581", -165},
  {7.0974804113529167072900658e+154, 2, "71", 155},
  {2.7596389919583024780759272e+58, 3, "276", 59},
  {7.3618821755779691678571792e+242, 6, "736188", 243},
  {1.4637292766835062420905508e-246, 16, "1463729276683506", -245},
  {3.9522323919742041643530903e+152, 14, "39522323919742", 153},
  {3.7368628038011591171993049e-11, 10, "3736862804", -10},
  {2.2129526496479320562246481e+176, 18, "221295264964793206", 177},
  {2.1859741504067338080017059e+179, 12, "218597415041", 180},
  {6.0308323721458746081426687e+106, 21, "603083237214587460814", 107},
  {9.8210124534131997682593199e-245, 5, "9821", -244},
  {3.1027579789758138534860470e-32, 6, "310276", -31},
  {4.8050632098868447515059236e+184, 12, "480506320989", 185},
  {3.4410460578446168000000000e+16, 19, "34410460578446168", 17},
  {6.3193201174319939944441311e+304, 10, "6319320117", 305},
  {1.7257565560242870931002641e-274, 2, "17", -273},
  {2.3185274400358276571710472e-67, 17, "23185274400358277", -66},
  {1.4772066993644306811895329e-116, 1, "1", -115},
  {1.9727971350713298158958629e-170, 21, "19727971350713298159", -169},
  {5.0553409185257519250464338e+183, 20, "5055340918525751925", 184},
  {3.6678647251465830017279646e-237, 20, "36678647251465830017", -236},
  {2.0620524135049091939564191e+69, 15, "206205241350491", 70},
  {4.3906195674293602665633734e+55, 6, "439062", 56},
  {4.6011505508925417707310837e-187, 6, "460115", -186},
  {1.1442449893285871966204514e-04, 18, "11442449893285872", -3},
  {4.6323524154649503078441127e+116, 5, "46324", 117},
  {7.9058184748448498425742984e+30, 17, "79058184748448498", 31},
  {2.1590480063118364715266814e-130, 15, "215904800631184", -129},
  {6.3779331901543820883953888e+75, 12, "637793319015", 76},
  {1.7581847807192020167419645e-212, 6, "175818", -211},
  {5.0827709517759202237686840e-182, 15, "508277095177592", -181},
  {4.4552121748006377622900131e-268, 6, "445521", -267},
  {1.1109452398925781665546276e+31, 9, "111094524", 32},
  {1.9407366699016732000000000e+16, 18, "19407366699016732", 17},
  {1.7704546575312140144418435e-25, 12, "177045465753", -24},
  {2.5308291350210369258308366e-294, 15, "253082913502104", -293},
  {8.9793173249599637469074267e-140, 11, "8979317325", -139},
  {1.4974564913747825794567909e-143, 11, "14974564914", -142},
  {2.4585456741595213932274291e+79, 19, "2458545674159521393", 80},
  {8.4984580261943540235033320e+270, 12, "849845802619", 271},
  {8.5616158942936532071734001e-69, 11, "85616158943", -68},
  {1.1255133239434504183440457e-226, 4, "1126", -225},
  {7.2940287484190807073640839e-167, 15, "729402874841908", -166},
  {7.4334175546550200867534141e-153, 17, "74334175546550201", -152},
  {5.9906434538567770073350168e+286, 11, "59906434539", 287},
  {1.6908155104860327323177994e+160, 9, "169081551", 161},
  {4.6976449356854932683188981e-132, 21, "469764493568549326832", -131},
  {2.6548648389100219386869383e+294, 1, "3", 295},
  {1.9077303531033573515672839e-289, 16, "1907730353103357", -288},
  {2.8320838693210213466322717e+280, 20, "28320838693210213466", 281},
  {2.9808815701613162400841728e+26, 7, "2980882", 27},
  {1.9064194464564608276646275e-239, 13, "1906419446456", -238},
  {1.6806494053535230583414162e+177, 13, "1680649405354", 178},
  {1.8002649575154527780912819e-07, 2, "18", -6},
  {1.5661475305164014989211822e+145, 14, "15661475305164", 146},
  {1.8329564563658834000881945e+117, 15, "183295645636588", 118},
  {9.8070768809261833339099808e-25, 10, "9807076881", -24},
  {3.4156736684280325155247857e+288, 19, "3415673668428032516", 289},
  {7.2910467540239604426930103e-306, 6, "729105", -305},
  {2.4431895540919232246264242e-222, 16, "2443189554091923", -221},
  {5.1103713156647644828208463e-28, 18, "511037131566476448", -27},
  {3.1471142729912924526078825e+271, 10, "3147114273", 272},
  {3.6706999009312849585809262e+126, 21, "367069990093128495858", 127},
  {2.0433853678109270671269318e-06, 20, "20433853678109270671", -5},
  {7.9271704687075807929380426e+257, 7, "792717", 258},
  {5.0050967516113302040324468e+181, 21, "500509675161133020403", 182},
  {3.1419135458868970945659870e+288, 15, "31419135458869", 289},
  {1.3417595635936627480679491e+56, 7, "134176", 57},
  {3.7034048704875619200813758e-254, 8, "37034049", -253},
  {1.8274632409400879682027992e+300, 3, "183", 301},
  {6.3779211905277518002356793e-160, 21, "637792119052775180024", -159},
  {1.5216212409276892447707041e+00, 3, "152", 1},
  {4.9068181491149078057851875e+268, 8, "49068181", 269},
  {5.4759594862707891349129532e+296, 21, "547595948627078913491", 297},
  {5.0882443367295211136524803e-111, 14, "50882443367295", -110},
  {8.8956860172715914282824580e-21, 17, "88956860172715914", -20},
  {2.8416976836286131612962973e+229, 14, "28416976836286", 230},
  {3.5162779978614413386523432e-56, 18, "351627799786144134", -55},
  {2.5372964687899147740463274e+269, 1, "3", 270},
  {3.6897764836617423730775442e-125, 8, "36897765", -124},
  {3.3167952908180362687757178e-177, 20, "33167952908180362688", -176},
  {7.8375394388074710965156555e+07, 8, "78375394", 8},
  {3.7316971704742947072192740e+175, 3, "373", 176},
  {2.5771374172988951347533851e-116, 8, "25771374", -115},
  {1.0165606329361352642806012e+235, 7, "1016561", 236},
  {1.0144902787623537564418803e-238, 7, "101449", -237},
  {1.3350577936971169510555792e-276, 20, "13350577936971169511", -275},
  {3.2520564234179796817836744e+61, 4, "3252", 62},
  {1.9238147278893886580942602e-253, 14, "19238147278894", -252},
  {5.2265143285577529600150264e+172, 1, "5", 173},
  {1.5753021854412126757582445e-50, 6, "15753", -49},
  {2.5652738494906343571586927e-250, 4, "2565", -249},
  {4.5640122435859023448556734e-134, 8, "45640122", -133},
  {6.3344169530157903137126466e+181, 19, "6334416953015790314", 182},
  {5.9557675442847879603505135e+06, 6, "595577", 7},
  {9.6278471903333627282581004e+194, 7, "9627847", 195},
  {6.0645251370794101920534367e-13, 18, "606452513707941019", -12},
  {1.7738969930488336583984421e-199, 18, "177389699304883366", -198},
  {1.7362041871940099732079514e-134, 19, "1736204187194009973", -133},
  {1.5513409077127884066729899e-141, 1, "2", -140},
  {2.3338655057386509724892676e+04, 12, "233386550574", 5},
  {3.5249909481313451188654057e+76, 21, "352499094813134511887", 77},
  {5.5582548096605813768686187e-207, 17, "55582548096605814", -206},
  {1.2539866122135540841603242e-287, 9, "125398661", -286},
  {4.7842482414532441867914901e+135, 9, "478424824", 136},
  {8.6725839145927200089680599e+144, 15, "867258391459272", 145},
  {6.3070852256001211277079580e+159, 6, "630709", 160},
  {7.7193998543989864897594178e+306, 9, "771939985", 307},
  {1.0043079900605884839004016e+58, 10, "100430799", 59},
  {1.3471176651379000197759773e+275, 19, "134711766513790002", 276},
  {2.7192953177856714978692062e+116, 1, "3", 117},
  {4.1980268694054752653575027e-159, 12, "419802686941", -158},
  {2.9248822190372819463919963e+115, 21, "292488221903728194639", 116},
  {1.6422813679252723965222646e+225, 13, "1642281367925", 226},
  {3.0369633918755987951675600e-120, 12, "303696339188", -119},
  {2.5695977502883184980719142e+193, 4, "257", 194},
  {7.2955842569637552810275248e+63, 19, "7295584256963755281", 64},
  {1.1226369240292102298224107e-121, 21, "112263692402921022982", -120},
  {9.9795329560060096597406226e+179, 4, "998", 180},
  {7.4118468001366325957379250e-155, 18, "74118468001366326", -154},
  {3.0211678143017618942746299e-190, 6, "302117", -189},
  {5.5259814779060140736122166e+42, 1, "6", 43},
  {6.4900450600124846317273416e+125, 20, "64900450600124846317", 126},
  {3.0863342265363701387800057e+242, 18, "308633422653637014", 243},
  {6.7558380705330945104135871e+255, 12, "675583807053", 256},
  {1.0835673410846253374188328e-279, 20, "10835673410846253374", -278},
  {6.0033911312218537695296346e-239, 17, "60033911312218538", -238},
  {4.0819003649758916666348221e+29, 13, "4081900364976", 30},
  {1.4522675358601120456659250e-150, 3, "145", -149},
  {1.9762511910386829172174512e+99, 10, "1976251191", 100},
  {1.4651460240294303113046919e-250, 13, "1465146024029", -249},
  {9.5631824986600933450337976e+284, 5, "95632", 285},
  {3.4544569596714654646695898e-300, 17, "34544569596714655", -299},
  {1.0043843974274915770046210e-74, 13, "1004384397427", -73},
  {1.1335047803371706754295712e-141, 8, "11335048", -140},
  {6.6151336426333590282668080e+65, 9, "661513364", 66},
  {6.9912772917293976562500000e+13, 12, "699127729173", 14},
  {4.6662805558838630878194955e+90, 13, "4666280555884", 91},
  {3.3193072863966661891010649e+44, 1, "3", 45},
  {4.3854954125076608000000000e+16, 1, "4", 17},
  {9.7838213716529402529101392e+159, 5, "97838", 160},
  {1.0232107185754667082280289e-82, 13, "1023210718575", -81},
  {1.4403376413421294794903019e+257, 9, "144033764", 258},
  {1.2011232206099782417178815e-80, 10, "1201123221", -79},
  {1.7411990485804122924804688e+11, 18, "174119904858041229", 12},
  {1.7084842077453829138108957e-251, 2, "17", -250},
  {5.2530972490799953736881670e+63, 19, "5253097249079995374", 64},
  {1.9500001810748120005443399e-07, 13, "1950000181075", -6},
  {7.1636870190468514175260200e-186, 6, "716369", -185},
  {2.1210804436095386454680594e+211, 5, "21211", 212},
  {4.6032663529106062490693229e-227, 9, "460326635", -226},
  {4.0510003632279884044173312e+25, 9, "405100036", 26},
  {2.0194543527303401982362032e+145, 10, "2019454353", 146},
  {2.6328356957379068626724018e-114, 11, "26328356957", -113},
  {3.2957515446548693781582140e-32, 1, "3", -31},
  {2.0207454284762312896243586e-293, 17, "20207454284762313", -292},
  {2.8230917645625975338720207e+145, 17, "28230917645625975", 146},
  {3.1843225250078642357098784e+288, 19, "3184322525007864236", 289},
  {8.9374911762153047295354131e-211, 7, "8937491", -210},
  {2.5834763147619177831336811e+52, 11, "25834763148", 53},
  {1.2094964248262173526755008e-12, 11, "12094964248", -11},
  {1.3924883984963794978950562e+72, 10, "1392488398", 73},
  {4.3224558786222218988587947e-239, 11, "43224558786", -238},
  {4.2172655295783653733826719e-40, 7, "4217266", -39},
  {1.3022516367294450737985565e+56, 6, "130225", 57},
  {2.6284413319617899804600893e-47, 15, "262844133196179", -46},
  {2.3077185335852027311295357e+220, 16, "2307718533585203", 221},
  {2.5952504071500307958768697e-135, 6, "259525", -134},
  {3.3200554641810745243351526e+62, 13, "3320055464181", 63},
  {2.4085392900658198071043495e+64, 7, "2408539", 65},
  {2.1250836851539074476106106e-147, 8, "21250837", -146},
  {1.5100339789504606614137044e-93, 7, "1510034", -92},
  {4.9332174273934014391212358e-17, 14, "49332174273934", -16},
  {9.6376112992546997465224832e+161, 3, "964", 162},
  {1.1630281353860851829640558e-198, 20, "1163028135386085183", -197},
  {1.8452636972450944690051353e+118, 16, "1845263697245094", 119},
  {1.2646438759489172298344783e+04, 11, "12646438759", 5},
  {4.3902726068535837687788228e+283, 16, "4390272606853584", 284},
  {2.3281356198668945379477000e+167, 11, "23281356199", 168},
  {4.4584176651776526776976649e+111, 14, "44584176651777", 112},
  {2.5542651234221133728161604e+279, 13, "2554265123422", 280},
  {3.2708389948062891680801375e-214, 12, "327083899481", -213},
  {2.4402160844584440233303735e+283, 20, "24402160844584440233", 284},
  {6.0025565117635421389716439e+160, 6, "600256", 161},
  {6.0761202251158256807015851e+89, 3, "608", 90},
  {2.2838199878055132011095156e-162, 6, "228382", -161},
  {6.0377330712033853265497563e-123, 4, "6038", -122},
  {2.8619409153855691290349444e-15, 1, "3", -14},
  {1.1241540746749754063451556e+275, 12, "112415407467", 276},
  {3.5910672012130704819300286e+73, 5, "35911", 74},
  {5.5934996319063487811650810e+68, 19, "5593499631906348781", 69},
  {1.0310341900000314306377688e+284, 8, "10310342", 285},
  {7.2657159165301796565556719e+70, 11, "72657159165", 71},
  {2.8067480065443412467704500e-38, 20, "28067480065443412468", -37},
  {1.4882711072481072893950764e+255, 3, "149", 256},
  {7.8759804090188964664775995e+01, 6, "787598", 2},
  {9.7383866768336559538196412e+240, 19, "9738386676833655954", 241},
  {2.2912881460814281218118320e+265, 9, "229128815", 266},
  {1.7877603863241055918049201e+127, 7, "178776", 128},
  {3.5804881522116400005585406e-280, 10, "3580488152", -279},
  {5.3961008170363303970013231e-82, 19, "5396100817036330397", -81},
  {2.1033073799549327813155414e-273, 11, "210330738", -272},
  {2.0587257597462541923725731e-44, 4, "2059", -43},
  {2.4185355704752054678559309e-256, 14, "24185355704752", -255},
  {1.3584959078428200795113733e+275, 7, "1358496", 276},
  {2.3929242832733026858432719e-168, 9, "239292428", -167},
  {5.7274968421639622686346819e+250, 8, "57274968", 251},
  {2.5590847687390731121459200e+23, 2, "26", 24},
  {9.7529981698510885747242367e-296, 6, "9753", -295},
  {3.3242911588680161820864307e+155, 11, "33242911589", 156},
  {4.3374184003326929229288078e-256, 14, "43374184003327", -255},
  {1.5376692626997384359852992e-63, 7, "1537669", -62},
  {5.1256462511808029953257165e+126, 9, "512564625", 127},
  {3.1407815936629111264560000e+72, 20, "31407815936629111265", 73},
  {1.1639168416062118124339607e-279, 9, "116391684", -278},
  {6.9952211531121065972869085e+62, 9, "699522115", 63},
  {1.4072307523782325648544108e+68, 12, "140723075238", 69},
  {2.5077834919279537867761117e+37, 16, "2507783491927954", 38},
  {5.1162371659820594830843112e+256, 15, "511623716598206", 257},
  {1.8654089030341161533972188e-268, 11, "1865408903", -267},
  {3.8602794548475185178442289e+118, 14, "38602794548475", 119},
  {1.3265235742060857495698932e+280, 14, "13265235742061", 281},
  {2.7750299982036287228230976e-212, 11, "27750299982", -211},
  {2.0683964887010904865052314e-298, 3, "207", -297},
  {1.0735556085787142329179380e-268, 15, "107355560857871", -267},
  {1.2188375026625665957215075e-230, 18, "12188375026625666", -229},
  {3.3540532524377396280497004e+208, 14, "33540532524377", 209},
  {3.6856704218332637809349744e+41, 14, "36856704218333", 42},
  {2.5586457357532131687171920e+51, 10, "2558645736", 52},
  {5.5759597096906276540310359e-134, 17, "55759597096906277", -133},
  {7.0666120748514272333715097e+287, 15, "706661207485143", 288},
  {1.5952143314870424934039645e+122, 13, "1595214331487", 123},
  {9.1702894748324324672786312e-05, 7, "9170289", -4},
  {1.8556274642599073796425395e+92, 18, "185562746425990738", 93},
  {4.2687837179089449048010311e-08, 21, "42687837179089449048", -7},
  {3.3316249180897800244276833e+124, 1, "3", 125},
  {3.4400850686220408525827392e+132, 7, "3440085", 133},
  {1.5092096161317612294926899e-188, 2, "15", -187},
  {7.1876495479906702067287461e-80, 7, "718765", -79},
  {3.1872101866569898413090705e-304, 14, "3187210186657", -303},
  {4.5737303879203395647792034e+167, 13, "457373038792", 168},
  {6.3775942608776765936736612e+230, 3, "638", 231},
  {2.2709761186764408320000000e+18, 19, "2270976118676440832", 19},
  {5.1518338128836699639429476e-274, 8, "51518338", -273},
  {1.9427571492141207074569810e-35, 11, "19427571492", -34},
  {7.4442723424727910563799915e+245, 10, "7444272342", 246},
  {1.4264376707072998369518166e-248, 19, "1426437670707299837", -247},
  {6.1771646818118861680754527e-80, 13, "6177164681812", -79},
  {3.9063515821055738079061854e-175, 5, "39064", -174},
  {1.5516307032400853786096888e-210, 8, "15516307", -209},
  {2.3506195930951799847650041e-201, 5, "23506", -200},
  {2.4527952371803077138895486e-53, 9, "245279524", -52},
  {1.3293271481884168392896122e+99, 15, "132932714818842", 100},
  {1.4643896681844712794750661e+187, 9, "146438967", 188},
  {1.8352528528056989416510081e-05, 2, "18", -4},
  {2.6679921236282173104303100e+32, 11, "26679921236", 33},
  {2.9033189084721038192792964e-32, 1, "3", -31},
  {1.8211326826681012558983503e-194, 1, "2", -193},
  {4.0868114440717517936718650e+03, 8, "40868114", 4},
  {2.7137208986459887549713699e-01, 16, "2713720898645989", 0},
  {2.1041973785707068818845153e-145, 9, "210419738", -144},
  {3.7671098096860105289958048e-146, 3, "377", -145},
  {6.5461828453437933003755106e-270, 10, "6546182845", -269},
  {1.3456512332895000927379670e+00, 6, "134565", 1},
  {1.1569841170343430072649985e-264, 8, "11569841", -263},
  {1.5610553524969428977455251e-165, 1, "2", -164},
  {7.2917327934054292437627206e-295, 5, "72917", -294},
  {1.8589938001571051343957042e+290, 9, "18589938", 291},
  {2.2503007069280036519470805e+247, 15, "2250300706928", 248},
  {4.0690051225797660854755385e+201, 2, "41", 202},
  {9.3815613446122076971341165e+100, 7, "9381561", 101},
  {1.5274373593454448578769486e+257, 3, "153", 258},
  {9.0000478366533764069065409e-138, 14, "90000478366534", -137},
  {7.5609994441334724428124325e+145, 13, "7560999444133", 146},
  {4.3148340269254277212422766e-287, 20, "43148340269254277212", -286},
  {7.4556215320472624066010736e+161, 2, "75", 162},
  {2.9166400541152622964625564e+55, 17, "29166400541152623", 56},
  {7.3177378285903749084542124e-289, 7, "7317738", -288},
  {5.6773145557878458754440988e+196, 16, "5677314555787846", 197},
  {3.0812615449327676385899561e+59, 16, "3081261544932768", 60},
  {1.4178430446448512369701060e+261, 4, "1418", 262},
  {2.5866082287091137080499197e+48, 3, "259", 49},
  {2.3121551454335959902686033e+142, 21, "231215514543359599027", 143},
  {1.9872012901697870112342970e+208, 14, "19872012901698", 209},
  {6.7421674792911617235258200e+234, 3, "674", 235},
  {5.4315039474964095195536027e-127, 2, "54", -126},
  {1.1502340891829608798895785e+137, 11, "11502340892", 138},
  {3.5935767600119199336398572e-189, 6, "359358", -188},
  {5.7976355732096483727897157e+31, 10, "5797635573", 32},
  {1.9116990869694238322295233e-102, 2, "19", -101},
  {1.9453912899005073746105503e-35, 12, "19453912899", -34},
  {1.9323523956749323896989995e-272, 4, "1932", -271},
  {2.1181939703131089645326226e-125, 7, "2118194", -124},
  {5.6773014690950834636779047e+257, 16, "5677301469095083", 258},
  {1.2110460305201553406612071e+74, 19, "1211046030520155341", 75},
  {1.9606082325491662589724089e-221, 7, "1960608", -220},
  {1.6773395903939971694999956e+123, 7, "167734", 124},
  {9.7950721639184437239480195e-242, 20, "97950721639184437239", -241},
  {4.1618449071235490077444536e+41, 8, "41618449", 42},
  {1.8973904675520659356323078e+273, 15, "189739046755207", 274},
  {1.0864368324619039955057634e-154, 4, "1086", -153},
  {4.1303011394619558315268329e-120, 1, "4", -119},
  {9.2068162342919328695720752e-250, 1, "9", -249},
  {3.1538703758581178074806699e-103, 11, "31538703759", -102},
  {3.4548670309257329915699624e-40, 11, "34548670309", -39},
  {4.5129481328250572504050077e+115, 11, "45129481328", 116},
  {2.9848321534215540785225913e+63, 18, "298483215342155408", 64},
  {2.0108465423460538333113954e-272, 18, "201084654234605383", -271},
  {2.1862113961564967475026849e+247, 2, "22", 248},
  {2.6675882036220605688370588e-307, 16, "2667588203622061", -306},
  {1.9024524871152219352529114e+238, 1, "2", 239},
  {1.8249689407881750607974708e-136, 1, "2", -135},
  {1.0470217241013769885557921e-297, 8, "10470217", -296},
  {9.5448756033505317077434860e-269, 9, "95448756", -268},
  {4.0976862328678417104985632e-93, 16, "4097686232867842", -92},
  {2.2910163233881885975653033e-253, 2, "23", -252},
  {3.3178402292262810457606518e-256, 13, "3317840229226", -255},
  {2.4706968262660602440820409e-132, 17, "24706968262660602", -131},
  {9.5583421532905305843580007e-141, 12, "955834215329", -140},
  {6.3253648627431018472840146e-67, 10, "6325364863", -66},
  {6.1738375005450355404064411e-05, 6, "617384", -4},
  {2.6106866885671020933358502e-228, 19, "2610686688567102093", -227},
  {1.0933605041420774136457386e-274, 19, "1093360504142077414", -273},
  {4.7188017322264604889841594e-155, 21, "471880173222646048898", -154},
  {9.8115248602585128792892972e+255, 6, "981152", 256},
  {1.7715466916569593330963709e-20, 6, "177155", -19},
  {1.2237423652439537595647879e+213, 2, "12", 214},
  {2.0660876747539081451487653e-87, 5, "20661", -86},
  {9.0608652354511169833851274e-65, 16, "9060865235451117", -64},
  {1.8927238006552384140340068e+301, 21, "189272380065523841403", 302},
  {8.3170839722756465177395200e+23, 1, "8", 24},
  {1.7798749082474694637690765e+103, 18, "177987490824746946", 104},
  {1.9635656672869674139802936e+302, 10, "1963565667", 303},
  {3.7655228408393055713158773e+268, 16, "3765522840839306", 269},
  {1.3076236132264757825941545e-105, 6, "130762", -104},
  {7.7554676677797098606310821e-34, 7, "7755468", -33},
  {9.1586771987150833001826059e-129, 4, "9159", -128},
  {7.1394800726456833217525855e+03, 10, "7139480073", 4},
  {5.5225330195118312744821934e+109, 5, "55225", 110},
  {2.4303254189000228435162949e-95, 19, "2430325418900022844", -94},
  {5.9547647126212127130182946e-131, 21, "595476471262121271302", -130},
  {7.0207525233690242902141271e-159, 15, "702075252336902", -158},
  {6.5151987192273664333678783e-17, 12, "651519871923", -16},
  {1.0153683599152547244789240e-154, 20, "10153683599152547245", -153},
  {6.8186168609104127833403679e-18, 14, "68186168609104", -17},
  {1.6139224711967760070744850e-220, 7, "1613922", -219},
  {6.2602717849598853834833569e-09, 6, "626027", -8},
  {8.6501221427630677181260736e-61, 2, "87", -60},
  {2.0976157478105767590696251e-292, 9, "209761575", -291},
  {1.0608505472231653486818973e+169, 1, "1", 170},
  {4.6706603496686248842719521e-176, 8, "46706603", -175},
  {4.5470585563461767598876732e+191, 6, "454706", 192},
  {1.7642764060065051467383676e+50, 2, "18", 51},
  {1.1321736374011086378331015e-217, 19, "1132173637401108638", -216},
  {7.1919142491495356478208545e+201, 16, "7191914249149536", 202},
  {1.4295676676885894241130131e-154, 13, "1429567667689", -153},
  {5.4067060872337813989952131e+108, 20, "5406706087233781399", 109},
  {3.7851227531330338447017414e+60, 20, "37851227531330338447", 61},
  {1.2861362004707252687478099e-10, 1, "1", -9},
  {8.5157910667127199047628427e+166, 18, "85157910667127199", 167},
  {4.1294146975895029741901127e+166, 21, "412941469758950297419", 167},
  {1.6685651226247019523653004e-51, 18, "166856512262470195", -50},
  {8.5627057742505408965996153e+294, 5, "85627", 295},
  {1.6220550598242656895989310e-102, 6, "162206", -101},
  {5.4708905075642033660119605e-78, 8, "54708905", -77},
  {9.7158527975050815119736367e+120, 16, "9715852797505082", 121},
  {4.5064648534322839222636784e+219, 2, "45", 220},
  {9.5251321229731990217707198e+196, 16, "9525132122973199", 197},
  {1.6851207392692842394680121e-07, 20, "16851207392692842395", -6},
  {2.4721294193590638089012692e+169, 12, "247212941936", 170},
  {7.4311131964327948972482692e-224, 20, "74311131964327948972", -223},
  {1.4617877325104089453816414e+07, 6, "146179", 8},
  {1.5392041441488305853465029e+216, 16, "1539204144148831", 217},
  {1.1453710697338959111272454e-211, 21, "114537106973389591113", -210},
  {4.7093839633567869703182969e+131, 19, "470938396335678697", 132},
  {1.2776904530678788838601178e+296, 11, "12776904531", 297},
  {3.8011141676080821990833465e-189, 15, "380111416760808", -188},
  {2.4856723563258125864194881e+02, 7, "2485672", 3},
  {9.9493690369452712293033852e-270, 4, "9949", -269},
  {4.4578558215098217197984543e-92, 10, "4457855822", -91},
  {2.6585453467078868971287411e-53, 15, "265854534670789", -52},
  {9.2698758308849377517973285e+179, 20, "92698758308849377518", 180},
  {5.6776347808109248341094581e-34, 17, "56776347808109248", -33},
  {2.1792953665104405810392089e+70, 16, "2179295366510441", 71},
  {4.6200167353556796936290951e+225, 15, "462001673535568", 226},
  {4.0600574691023019811889122e+61, 14, "40600574691023", 62},
  {1.2526305203088974733337351e-88, 11, "12526305203", -87},
  {4.9305115628405633500844110e+93, 14, "49305115628406", 94},
  {4.6628412066931542564013814e-198, 19, "4662841206693154256", -197},
  {1.3191238526084252862592056e-17, 1, "1", -16},
  {2.9634135507054344219531454e-234, 5, "29634", -233},
  {1.3408678554362914406731576e+106, 21, "134086785543629144067", 107},
  {7.0050956716109029305161688e-267, 2, "7", -266},
  {2.8037523011839725467137379e-283, 3, "28", -282},
  {7.6565726228967012596987656e-79, 15, "76565726228967", -78},
  {4.0447545926273536954713197e+261, 18, "40447545926273537", 262},
  {4.4038395210532918085174006e+85, 16, "4403839521053292", 86},
  {1.5681230847981260666818529e+187, 16, "1568123084798126", 188},
  {8.9540295863126572228442660e+78, 8, "89540296", 79},
  {4.4219387322244651835398873e-201, 12, "442193873222", -200},
  {1.3140418281859323412996884e-43, 10, "1314041828", -42},
  {5.3817713927520241451496965e+125, 4, "5382", 126},
  {4.0566028167103153738562878e+129, 3, "406", 130},
  {4.8013901615781830623745918e+06, 7, "480139", 7},
  {6.5525076107580451203039303e-259, 4, "6553", -258},
  {5.5130883504928623113319816e+276, 16, "5513088350492862", 277},
  {3.0945845192293386352183009e-90, 3, "309", -89},
  {6.5850123747860134547190599e-33, 11, "65850123748", -32},
  {5.5325743049378240342656201e+90, 16, "5532574304937824", 91},
  {2.8938071635717472926049183e-305, 3, "289", -304},
  {1.2271236586719190147057959e+221, 21, "122712365867191901471", 222},
  {1.7399973250818247493615755e-276, 18, "173999732508182475", -275},
  {2.3915538287520009434636716e+275, 2, "24", 276},
  {1.2165335482508880218081287e+95, 5, "12165", 96},
  {9.7664074886777092484607613e+75, 21, "976640748867770924846", 76},
  {5.8638354556478641619972051e-245, 1, "6", -244},
  {1.3675692653852637623846824e+160, 10, "1367569265", 161},
  {3.6636818965942539311209103e-03, 10, "3663681897", -2},
  {6.4268723384765194837876584e-110, 9, "642687234", -109},
  {2.5427878590596286990419527e+47, 21, "254278785905962869904", 48},
  {4.7403557639308884443514903e-246, 19, "4740355763930888444", -245},
  {8.3843545473001316204228556e-78, 1, "8", -77},
  {5.5937539243588194997380219e+301, 5, "55938", 302},
  {3.6355268322261229474708174e+261, 10, "3635526832", 262},
  {8.1473215374608900584831474e-303, 17, "81473215374608901", -302},
  {1.0857833992467311311396076e-125, 19, "1085783399246731131", -124},
  {2.1557164727351342536752217e+95, 5, "21557", 96},
  {4.4875483180793035249128296e-07, 12, "448754831808", -6},
  {4.4887487354565042997618806e-91, 8, "44887487", -90},
  {1.8759297221867516695886649e+223, 6, "187593", 224},
  {5.8256903987075845040081114e-73, 4, "5826", -72},
  {5.5431947597261406691560523e+306, 3, "554", 307},
  {7.4951232077526414046832079e-28, 4, "7495", -27},
  {3.6362113353741081178737099e-214, 9, "363621134", -213},
  {5.3518053690089049742772592e+296, 3, "535", 297},
  {3.2673310739708182452122777e-276, 9, "326733107", -275},
  {1.5127364918269732454400000e+21, 6, "151274", 22},
  {1.5746533940891534651844935e+271, 21, "157465339408915346518", 272},
  {2.6497064923463881123411726e+208, 14, "26497064923464", 209},
  {1.7614029214031548664384440e-09, 1, "2", -8},
  {2.7358592529985183233353841e+132, 13, "2735859252999", 133},
  {4.0329760103079227179159411e+233, 21, "403297601030792271792", 234},
  {1.0176915177355467029613340e+96, 13, "1017691517736", 97},
  {1.1785965958093241758815260e-298, 13, "1178596595809", -297},
  {3.4901382616490983481725113e+206, 2, "35", 207},
  {7.2871362777632774473885279e+173, 10, "7287136278", 174},
  {1.0694345071605393615409455e-106, 9, "106943451", -105},
  {3.0611874685516454815826175e-242, 7, "3061187", -241},
  {3.1525665624903329123200482e+110, 2, "32", 111},
  {6.1390619815173729415075938e-266, 15, "613906198151737", -265},
  {3.3345595332503520877465413e+241, 7, "333456", 242},
  {1.2437908588331441887508752e+211, 21, "124379085883314418875", 212},
  {3.4054618275601265500549853e-57, 2, "34", -56},
  {5.1353627207077909189481885e-129, 9, "513536272", -128},
  {4.2492808747550736246817446e+289, 6, "424928", 290},
  {4.2500331073990110157365091e-87, 2, "43", -86},
  {1.2873486784336140314314018e+138, 15, "128734867843361", 139},
  {5.2263490362968440300522382e-84, 9, "522634904", -83},
  {1.8063293551602970781981608e-301, 3, "181", -300},
  {1.9677872363136754939296193e+82, 5, "19678", 83},
  {1.9475081353191762662491519e+73, 7, "1947508", 74},
  {3.5670032272946513124470372e-58, 21, "356700322729465131245", -57},
  {3.4681066164797542010425462e-306, 20, "3468106616479754201", -305},
  {2.5787338319043752000000000e+16, 16, "2578733831904375", 17},
  {6.2866533511502381945343244e-198, 6, "628665", -197},
  {5.8265131638341439918314867e-52, 3, "583", -51},
  {1.0802197241416126464000000e+19, 9, "108021972", 20},
  {6.9260866032196042681555104e-196, 1, "7", -195},
  {1.0184826019263802317653666e-148, 18, "101848260192638023", -147},
  {7.1234362422273395961447922e-256, 7, "7123436", -255},
  {4.0204731687100738427302015e-191, 16, "4020473168710074", -190},
  {1.0870552149732085079349024e-214, 21, "108705521497320850793", -213},
  {1.3074939293634176414956150e-154, 6, "130749", -153},
  {2.0939994401053436903785136e-49, 6, "2094", -48},
  {4.0123639472434792651511732e+180, 7, "4012364", 181},
  {3.4314019462646915681342229e+198, 17, "34314019462646916", 199},
  {2.4692696781100093927452001e+83, 4, "2469", 84},
  {7.3756615442925479138984431e-166, 11, "73756615443", -165},
  {3.2826289757197042144204843e+290, 2, "33", 291},
  {5.7942856135303222790768049e+268, 19, "5794285613530322279", 269},
  {2.4301846885757076488945279e+54, 10, "2430184689", 55},
  {5.4031603389948617936523508e-15, 17, "54031603389948618", -14},
  {1.0135009887820909852962359e+03, 2, "1", 4},
  {5.1453932279490943809093119e+193, 12, "514539322795", 194},
  {1.8589426964306405413648020e-208, 3, "186", -207},
  {1.4064922376807739335094079e-242, 5, "14065", -241},
  {3.6343454614804647000960065e+159, 17, "36343454614804647", 160},
  {7.9416811757401857919167363e-91, 10, "7941681176", -90},
  {2.5945613458881674616919504e+156, 10, "2594561346", 157},
  {6.3624252226285372380433335e+227, 3, "636", 228},
  {1.0579179032450728125000000e+14, 10, "1057917903", 15},
  {2.9423930145677064846659050e+268, 21, "294239301456770648467", 269},
  {1.0365743750873706459628288e+57, 1, "1", 58},
  {5.8856242244779779781459978e+237, 15, "588562422447798", 238},
  {1.6962931027679971846604141e-112, 8, "16962931", -111},
  {5.0909063026472574909180726e-93, 18, "509090630264725749", -92},
  {3.7244586573030426209455807e-235, 21, "372445865730304262095", -234},
  {1.0750556465692595729325774e-29, 9, "107505565", -28},
  {1.1258089483442813139822923e+186, 2, "11", 187},
  {2.6607994978775637340397313e+284, 7, "2660799", 285},
  {4.9068296442942379339111458e+166, 1, "5", 167},
  {5.1112606718580034240870465e+211, 2, "51", 212},
  {1.7376391721237242811655094e+289, 8, "17376392", 290},
  {3.5645183693376601347555255e+177, 19, "3564518369337660135", 178},
  {3.9913095473939594686887413e-112, 4, "3991", -111},
  {3.9109066866803263554006725e-51, 1, "4", -50},
  {1.2767128206643134711457817e+298, 21, "127671282066431347115", 299},
  {5.7510886565604050767469711e+160, 21, "575108865656040507675", 161},
  {2.0523211569896289048735799e-123, 7, "2052321", -122},
  {3.7092130199159627920746055e+123, 2, "37", 124},
  {4.4097818436624577887584786e-254, 11, "44097818437", -253},
  {2.1343217122692691135432827e-226, 16, "2134321712269269", -225},
  {3.7660631543384876588595593e+114, 4, "3766", 115},
  {2.6613342358060424930432137e-94, 21, "266133423580604249304", -93},
  {3.5278190355082485022065157e+137, 15, "352781903550825", 138},
  {9.5094948204853562537838645e-07, 14, "95094948204854", -6},
  {4.3383136348650897472341973e-167, 11, "43383136349", -166},
  {1.1020897398992703416917149e-192, 6, "110209", -191},
  {1.2206709068421692122463411e-133, 18, "122067090684216921", -132},
  {1.3062306207530973948661298e+76, 15, "13062306207531", 77},
  {9.7266741203657348901647947e+231, 15, "972667412036573", 232},
  {5.1030767998692799932422030e-100, 3, "51", -99},
  {2.0349386604116303425064027e+161, 15, "203493866041163", 162},
  {4.4439769871544263496221121e+215, 7, "4443977", 216},
  {2.6287439999913565871641200e+256, 21, "262874399999135658716", 257},
  {1.2870711546158872268692012e-206, 18, "128707115461588723", -205},
  {4.7438490185628498118601248e+291, 7, "4743849", 292},
  {2.5037492762216333544166596e+154, 4, "2504", 155},
  {2.7819010851867542520045547e-138, 12, "278190108519", -137},
  {5.3362560473809726520384263e+188, 1, "5", 189},
  {2.2836213390566777852355842e-136, 15, "228362133905668", -135},
  {4.2215143279022180972056025e+102, 21, "422151432790221809721", 103},
  {1.8226023124685316334587055e-266, 19, "1822602312468531633", -265},
  {4.5021435378636137763797633e-105, 16, "4502143537863614", -104},
  {1.7041183685547168726850000e-50, 8, "17041184", -49},
  {4.6314616403618127381818965e-215, 4, "4631", -214},
  {5.3005476769648172748419632e+59, 18, "530054767696481727", 60},
  {3.5814763485845420221171345e+179, 16, "3581476348584542", 180},
  {1.6428341511175889984475701e-56, 8, "16428342", -55},
  {1.3649635395470655501670769e+250, 12, "136496353955", 251},
  {5.7451389237408287722952176e+50, 10, "5745138924", 51},
  {5.6583987574391291407832343e+131, 9, "565839876", 132},
  {4.2720922802390721763449419e+277, 4, "4272", 278},
  {5.4967938928768860928071382e+297, 6, "549679", 298},
  {3.2112307055885539925418157e-100, 15, "321123070558855", -99},
  {7.1828714753784738019661170e-18, 4, "7183", -17},
  {3.1260165939110843332472137e+239, 17, "31260165939110843", 240},
  {1.1461240355637448683667604e+120, 21, "114612403556374486837", 121},
  {3.3748236433609042173717969e-35, 6, "337482", -34},
  {5.1867908556662305751240042e-100, 7, "5186791", -99},
  {4.1712828135227586428204458e-207, 10, "4171282814", -206},
  {3.9439063942607743958377902e+252, 12, "394390639426", 253},
  {2.5132463630527079993423045e+299, 6, "251325", 300},
  {3.5183660440222644720532926e-186, 7, "3518366", -185},
  {1.6647731119685426160336896e+25, 7, "1664773", 26},
  {4.3749896921874599533568238e+41, 10, "4374989692", 42},
  {1.0719077005190352516974230e-149, 7, "1071908", -148},
  {5.6955120702893609017532477e-255, 9, "569551207", -254},
  {2.7918867699441403945135795e-148, 4, "2792", -147},
  {3.6043786244109685943014551e+210, 14, "3604378624411", 211},
  {2.2669860097362505355694819e+163, 14, "22669860097363", 164},
  {1.8723965543272172758306466e+64, 8, "18723966", 65},
  {2.5271504220261232180891587e-95, 15, "252715042202612", -94},
  {2.5185856217018543688713691e-05, 10, "2518585622", -4},
  {3.0050900898573011459609863e+72, 5, "30051", 73},
  {1.0819942788483461576623901e+151, 14, "10819942788483", 152},
  {2.4360935122579343523831382e-151, 13, "2436093512258", -150},
  {1.0485642913103613654833714e-64, 13, "104856429131", -63},
  {1.7989556323515537627439442e-256, 1, "2", -255},
  {1.2467845921638106414569897e-177, 11, "12467845922", -176},
  {1.5326258371182903155155224e-232, 12, "153262583712", -231},
  {3.1097432425944963996611060e-227, 14, "31097432425945", -226},
  {1.5710273725252913042192252e+206, 3, "157", 207},
  {1.0622926079694290401033751e+123, 21, "10622926079694290401", 124},
  {2.3086143583290718789131209e-87, 18, "230861435832907188", -86},
  {2.8550293583923994846263050e-51, 14, "28550293583924", -50},
  {6.7170142893850616194460025e-118, 9, "671701429", -117},
  {2.3883811481322775076571845e-21, 15, "238838114813228", -20},
  {2.9119698936947233745229172e+175, 11, "29119698937", 176},
  {2.2221129637418001193922798e-260, 14, "22221129637418", -259},
  {1.2553426996200527578552076e+202, 13, "125534269962", 203},
  {3.4603155537771413903395752e-217, 17, "34603155537771414", -216},
  {1.0992915928303157026872368e+177, 18, "10992915928303157", 178},
  {7.3142572546849412878525890e+261, 3, "731", 262},
  {4.8166453443897507158788645e-259, 18, "481664534438975072", -258},
  {1.8831654199644085133077538e+260, 6, "188317", 261},
  {5.2503945304329146938251358e-92, 3, "525", -91},
  {1.1797835848538655525275377e-201, 1, "1", -200},
  {9.4008884412618251220977422e-223, 11, "94008884413", -222},
  {5.5503720899367373698633777e-10, 2, "56", -9},
  {1.5908373476620947720337561e-39, 14, "15908373476621", -38},
  {7.6531632152233179057595862e-127, 14, "76531632152233", -126},
  {3.5360659778637138092533252e+197, 10, "3536065978", 198},
  {1.0599164080440931865185353e-164, 15, "105991640804409", -163},
  {1.4094792118175400817676634e+272, 3, "141", 273},
  {3.4534619642510318944170211e-04, 12, "345346196425", -3},
  {2.0985660188188265455967819e+61, 2, "21", 62},
  {5.1801334781672174873410019e+136, 6, "518013", 137},
  {1.4945235887235110288145687e+108, 15, "149452358872351", 109},
  {2.8986905612300205986347066e+43, 11, "28986905612", 44},
  {3.5264723539585909991436164e-96, 19, "3526472353958590999", -95},
  {3.8518474155525688036032690e+128, 9, "385184742", 129},
  {4.1032149891379440065808662e-146, 2, "41", -145},
  {2.5342772586119993084434891e-206, 11, "25342772586", -205},
  {1.6089507217692198871402445e+187, 21, "160895072176921988714", 188},
  {3.7030563588401148739934000e-203, 9, "370305636", -202},
  {8.7624177661112575465211694e-138, 7, "8762418", -137},
  {3.7292232213040045006763459e+182, 17, "37292232213040045", 183},
  {6.8291645397691256063258350e-240, 3, "683", -239},
  {1.0300865024882092434997087e+210, 21, "10300865024882092435", 211},
  {9.2928483105221300979455788e+117, 19, "9292848310522130098", 118},
  {2.1955254406811475483512568e+108, 5, "21955", 109},
  {1.2009305312544904112981020e-64, 5, "12009", -63},
  {1.3321356488766966494657171e-296, 13, "1332135648877", -295},
  {3.2495768589030771161517436e+195, 8, "32495769", 196},
  {1.1010364379585608287634409e-223, 7, "1101036", -222},
  {1.0906055541185445868489268e-18, 17, "10906055541185446", -17},
  {1.2444020021606171108771129e-294, 17, "12444020021606171", -293},
  {3.3035146815282517920309320e-168, 17, "33035146815282518", -167},
  {2.8154040707290126420428978e-64, 8, "28154041", -63},
  {1.3279214039876776002872908e-234, 6, "132792", -233},
  {6.4509502345264722240842258e+209, 14, "64509502345265", 210},
  {8.3260320572925050069173375e-10, 20, "83260320572925050069", -9},
  {1.8918146200849527696063381e-118, 8, "18918146", -117},
  {2.4675475663216360470660382e+188, 14, "24675475663216", 189},
  {9.7901710389393188099746920e+266, 21, "979017103893931880997", 267},
  {2.2940475134991640979716331e-72, 20, "2294047513499164098", -71},
  {5.8334624513851577529812808e+243, 6, "583346", 244},
  {2.5332679744969526667616440e+245, 4, "2533", 246},
  {1.2678811514593702060286412e-82, 18, "126788115145937021", -81},
  {2.1746756058210650174727929e-04, 3, "217", -3},
  {1.6538585177142260444778017e-29, 14, "16538585177142", -28},
  {4.5290421391271494939876217e-260, 2, "45", -259},
  {7.1470688333574596450818641e-60, 1, "7", -59},
  {3.7082003029019522845319071e+90, 16, "3708200302901952", 91},
  {4.1316956151231443771449480e-144, 4, "4132", -143},
  {3.9991931330898985818983536e+99, 15, "39991931330899", 100},
  {9.6511558956850937594119830e+42, 4, "9651", 43},
  {4.6872906994318775275587541e+01, 10, "4687290699", 2},
  {7.9527533526952068516227137e+189, 1, "8", 190},
  {8.7094081562414511992272021e-44, 6, "870941", -43},
  {7.7485209531130423822472022e-133, 18, "774852095311304238", -132},
  {1.6414989641899340186112898e-219, 18, "164149896418993402", -218},
  {6.7372690139129895233248972e-187, 4, "6737", -186},
  {4.5062252003788723333310900e-192, 5, "45062", -191},
  {3.5969524316307772737953445e-90, 3, "36", -89},
  {8.2821839991142257198185202e+198, 20, "82821839991142257198", 199},
  {3.7355643530221343313786190e+188, 16, "3735564353022134", 189},
  {1.6440231797489162109375000e+13, 15, "164402317974892", 14},
  {5.2306686002796153531706842e-59, 20, "52306686002796153532", -58},
  {3.0788813359016300625833357e-175, 17, "30788813359016301", -174},
  {3.7125122324240850394818255e-56, 10, "3712512232", -55},
  {2.7808250577976488673666124e+174, 14, "27808250577976", 175},
  {3.4945681005732236051821520e+127, 3, "349", 128},
  {3.4206078970554197051578954e+299, 10, "3420607897", 300},
  {1.8923312124804812343797436e-81, 21, "189233121248048123438", -80},
  {6.6568604654736270139627519e-122, 13, "6656860465474", -121},
  {2.9604681685719022275593021e-270, 12, "296046816857", -269},
  {1.5379275177036251989193261e+03, 3, "154", 4},
  {5.3812498776919574050281841e+62, 16, "5381249877691957", 63},
  {3.1647938184259474214769649e+223, 18, "316479381842594742", 224},
  {1.3233901557134014536598976e-260, 6, "132339", -259},
  {1.8640790785787555213642852e-03, 14, "18640790785788", -2},
  {4.7124987607048695966309832e-127, 7, "4712499", -126},
  {2.9825222669594921760389562e-20, 15, "298252226695949", -19},
  {1.4639740975466497691952750e-12, 1, "1", -11},
  {8.0594552413346345213837631e-72, 1, "8", -71},
  {3.9820740586364231408984819e+251, 21, "39820740586364231409", 252},
  {6.5077833563393503427505493e+07, 1, "7", 8},
  {3.2161418794924662996820691e+251, 7, "3216142", 252},
  {4.1530470418511023992755533e+194, 9, "415304704", 195},
  {1.2209508034651589187139678e-43, 5, "1221", -42},
  {1.6134733647361976111541962e+131, 13, "1613473364736", 132},
  {3.1270429617156061817624438e-96, 8, "3127043", -95},
  {2.5804080561411360220323405e+71, 8, "25804081", 72},
  {1.7063609575877439975738525e+08, 7, "1706361", 9},
  {2.7999558989317817866923550e-14, 5, "28", -13},
  {7.6725916074978938076144956e-199, 10, "7672591607", -198},
  {1.5671169804354772367850438e+102, 16, "1567116980435477", 103},
  {2.9455009098412573502223885e-83, 20, "29455009098412573502", -82},
  {6.6839829309842043760344349e+288, 14, "66839829309842", 289},
  {1.0845355751467538307370694e-185, 18, "108453557514675383", -184},
  {2.6444125212666347115056906e-167, 13, "2644412521267", -166},
  {2.0598436104551646681267117e+290, 14, "20598436104552", 291},
  {5.1008011344050451627874486e-52, 13, "5100801134405", -51},
  {1.3545159745106098180316009e+184, 13, "1354515974511", 185},
  {8.4116170816676003303642489e-07, 14, "84116170816676", -6},
  {3.0461233918821249117136776e-67, 4, "3046", -66},
  {3.2814800090815667499003551e-195, 17, "32814800090815667", -194},
  {3.3049099824425946921110153e+07, 21, "330490998244259469211", 8},
  {2.0570479797026887949908735e+43, 7, "2057048", 44},
  {1.7536882610587699796490395e-277, 13, "1753688261059", -276},
  {1.1562880739108050382534409e-193, 3, "116", -192},
  {1.6933291880030419276845420e+174, 10, "1693329188", 175},
  {2.9319600576342985505388293e+181, 5, "2932", 182},
  {4.0042951614303934272963073e-111, 16, "4004295161430393", -110},
  {7.4631419808592612871724190e+62, 1, "7", 63},
  {5.0625221782688132613948837e-172, 15, "506252217826881", -171},
  {6.1623370451955238618931158e-266, 1, "6", -265},
  {1.3964478940382119162802488e-36, 5, "13964", -35},
  {1.2219850255534320057002693e-137, 11, "12219850256", -136},
  {1.0721095047560285914633188e+147, 5, "10721", 148},
  {6.7132354939627182362164755e-290, 5, "67132", -289},
  {1.8821602491347130887892455e+68, 16, "1882160249134713", 69},
  {3.1703647779473679474096755e-155, 19, "3170364777947367947", -154},
  {1.5538007586719682767695261e-03, 6, "15538", -2},
  {6.2484488132610138068394250e+276, 8, "62484488", 277},
  {8.0537963356691899898560251e-260, 18, "805379633566918999", -259},
  {3.2819856429744453330537617e+246, 15, "328198564297445", 247},
  {3.2900187016509148857238362e+195, 11, "32900187017", 196},
  {7.8173064938711446260087558e-187, 12, "781730649387", -186},
  {1.1857425229102340677878131e-307, 13, "118574252291", -306},
  {3.4203914543916435022111147e+100, 7, "3420391", 101},
  {2.4556553097315645271656920e-248, 10, "245565531", -247},
  {1.2518536223479630656981068e-12, 18, "125185362234796307", -11},
  {4.9894881235934770382518639e-194, 6, "498949", -193},
  {3.8928377386168053123764763e+259, 3, "389", 260},
  {8.3536497935589965505418723e+305, 2, "84", 306},
  {6.8249040160500692174696414e+116, 20, "68249040160500692175", 117},
  {3.7934048797006186179745074e+76, 15, "379340487970062", 77},
  {2.4130020978423567808967058e-295, 5, "2413", -294},
  {6.3099145905846274175028669e+233, 8, "63099146", 234},
  {4.6116501065811991327575651e+110, 13, "4611650106581", 111},
  {6.0319899002538995153657338e+122, 21, "603198990025389951537", 123},
  {2.5161755065246236870321520e+206, 5, "25162", 207},
  {1.6543395386106105036800000e+21, 14, "16543395386106", 22},
  {1.2030064823724129339495204e-227, 6, "120301", -226},
  {2.1990464348503211265976431e+173, 15, "219904643485032", 174},
  {3.1688797429579276136236195e-06, 16, "3168879742957928", -5},
  {2.9570171794500171887866693e+139, 1, "3", 140},
  {7.2482227951553141990493997e+77, 3, "725", 78},
  {5.3637323924376592303838234e-170, 9, "536373239", -169},
  {4.6328282039331290883759373e-209, 5, "46328", -208},
  {3.0172474502325394889553759e-31, 12, "301724745023", -30},
  {8.0886259459282957787758137e-226, 9, "808862595", -225},
  {1.2430983014053637360612611e+287, 2, "12", 288},
  {1.2774041604551550368253964e-239, 14, "12774041604552", -238},
  {5.8063123644954116696107160e+203, 18, "580631236449541167", 204},
  {1.5942919909729853951193187e-200, 7, "1594292", -199},
  {1.2845029744898520067193513e+291, 11, "12845029745", 292},
  {8.9743022669731988734501361e-289, 20, "89743022669731988735", -288},
  {1.8416876714301378889543556e+37, 21, "184168767143013788895", 38},
  {7.9566807330868466403877039e-292, 21, "795668073308684664039", -291},
  {2.2238158284392469462612800e+279, 3, "222", 280},
  {3.4596082707055825501711547e-240, 17, "34596082707055826", -239},
  {8.7394943513537125133396308e+254, 20, "87394943513537125133", 255},
  {1.0153743352528529496892913e+223, 2, "1", 224},
  {2.1489322658106190834800594e+127, 5, "21489", 128},
  {3.8191996561006431583774356e-71, 11, "38191996561", -70},
  {5.7006353046564903194031301e+41, 11, "57006353047", 42},
  {1.3615751853653063287564216e-87, 10, "1361575185", -86},
  {1.8802332031349760557402457e+133, 7, "1880233", 134},
  {1.0704385373181160651963532e+200, 1, "1", 201},
  {2.0780191348896178805929686e-176, 16, "2078019134889618", -175},
  {4.2564513684115994809647621e+239, 11, "42564513684", 240},
  {5.0206331684158985121526761e-58, 6, "502063", -57},
  {4.2000897004079254218443059e-144, 7, "420009", -143},
  {4.2679783103443659926505050e-126, 6, "426798", -125},
  {9.3992031311497620649447597e-154, 21, "939920313114976206494", -153},
  {2.1219377840205719265576079e-01, 5, "21219", 0},
  {2.0513976815401076019260901e-213, 20, "20513976815401076019", -212},
  {2.1100591076567127466416098e+72, 1, "2", 73},
  {2.1508643168754669897211548e-183, 21, "215086431687546698972", -182},
  {8.5483370411092826026466344e+37, 11, "85483370411", 38},
  {7.1793290898504543279910941e+273, 20, "7179329089850454328", 274},
  {1.6027275794269820616084050e-74, 11, "16027275794", -73},
  {1.6245922566652842596917613e-94, 18, "162459225666528426", -93},
  {4.8667201935937676310970874e-183, 8, "48667202", -182},
  {9.0216647497381563212359876e+191, 6, "902166", 192},
  {2.5572568523133098017113655e+274, 9, "255725685", 275},
  {7.4259577711514276973493707e+221, 7, "7425958", 222},
  {2.0099578916470070412991746e+262, 4, "201", 263},
  {1.6050906929400817025452852e+06, 18, "16050906929400817", 7},
  {1.1063646882069393237748417e-169, 20, "11063646882069393238", -168},
  {3.8580680557868390115312258e+164, 5, "38581", 165},
  {4.5034716053680908230358066e-203, 20, "4503471605368090823", -202},
  {5.3481674013378953435525090e-118, 1, "5", -117},
  {5.1333560608444075936660250e-234, 16, "5133356060844408", -233},
  {2.2658812841563469203132851e+143, 5, "22659", 144},
  {9.1357934249301889032479117e-252, 14, "91357934249302", -251},
  {1.0000691687961656552916405e-53, 5, "10001", -52},
  {6.1053979228799966907550841e-111, 14, "610539792288", -110},
  {5.3976509162086878432574871e-18, 2, "54", -17},
  {1.7502108030390174310521679e+298, 12, "175021080304", 299},
  {9.9780022214069065884394089e+75, 4, "9978", 76},
  {2.9770112547007746014903838e+30, 3, "298", 31},
  {5.6263668828359655311727394e-41, 18, "562636688283596553", -40},
  {4.2311520247834068297713945e+114, 21, "423115202478340682977", 115},
  {6.3151276893242052817877103e-65, 15, "631512768932421", -64},
  {7.6051310095179172961546035e-133, 14, "76051310095179", -132},
  {6.9276854232487997391479095e-33, 17, "69276854232487997", -32},
  {2.9858992257834922698560739e+220, 6, "29859", 221},
  {1.2253345652152692851465212e+273, 8, "12253346", 274},
  {2.2316752633031825020924816e+249, 7, "2231675", 250},
  {1.6357687460493654440522102e-222, 21, "163576874604936544405", -221},
  {6.5027293813735786531223130e-37, 2, "65", -36},
  {3.4709207402026624406878807e-201, 8, "34709207", -200},
  {1.4010811316794320855763341e-207, 4, "1401", -206},
  {9.0204194142283013024762287e+213, 14, "90204194142283", 214},
  {1.7579888817350628647997141e+197, 10, "1757988882", 198},
  {2.2032401509855637166799876e-95, 5, "22032", -94},
  {2.8060215994636230618652917e+00, 15, "280602159946362", 1},
  {1.4763079392744530220111503e-19, 10, "1476307939", -18},
  {9.6790495902795710202746199e+30, 2, "97", 31},
  {2.5167883370710707060745690e-39, 21, "251678833707107070607", -38},
  {1.0855366368533035044517228e-277, 20, "10855366368533035045", -276},
  {6.9856210116140461671748759e+123, 16, "6985621011614046", 124},
  {3.6198110102341115397481657e+124, 20, "36198110102341115397", 125},
  {7.2321435882088143747226745e+132, 3, "723", 133},
  {1.5739480008362632232440745e+97, 4, "1574", 98},
  {4.3503003197835472737608555e-63, 11, "43503003198", -62},
  {4.2471620032123247590595432e+213, 6, "424716", 214},
  {2.1600980754949640243448767e-210, 17, "2160098075494964", -209},
  {1.5920305999759648157074701e-130, 18, "159203059997596482", -129},
  {5.3265625776086343882639862e-05, 14, "53265625776086", -4},
  {9.9390488935743445809694138e-106, 2, "99", -105},
  {8.0334492650139414199054195e-293, 8, "80334493", -292},
  {9.9551402556737850810326248e+64, 13, "9955140255674", 65},
  {7.7105789908873485625464185e-293, 9, "771057899", -292},
  {2.9448148734502444052614821e-19, 19, "2944814873450244405", -18},
  {1.6633648984308267626493684e+183, 7, "1663365", 184},
  {1.1699816542423012695312500e+12, 16, "1169981654242301", 13},
  {3.7166134898137428703162913e+180, 2, "37", 181},
  {8.8475411321995060444017053e-186, 12, "88475411322", -185},
  {2.6000507818217409201296523e-226, 17, "26000507818217409", -225},
  {3.6286482886022038348040262e-241, 19, "3628648288602203835", -240},
  {4.7893246380920783802916951e-42, 12, "478932463809", -41},
  {1.2970362825658910236579621e-286, 9, "129703628", -285},
  {9.8043877863223990167212879e-29, 7, "9804388", -28},
  {9.6859896418034315628022297e+187, 7, "968599", 188},
  {1.2376088980141139984130859e+10, 1, "1", 11},
  {1.7855326365698911603242182e+278, 18, "178553263656989116", 279},
  {2.0816774152969411047277841e+93, 19, "2081677415296941105", 94},
  {3.5098810841160709735576934e-72, 18, "350988108411607097", -71},
  {1.8591919093558487503343525e+233, 13, "1859191909356", 234},
  {1.0350730256883777585558739e-155, 3, "104", -154},
  {1.7487535349133821100954161e+183, 20, "17487535349133821101", 184},
  {4.3466415331710102958944147e-175, 10, "4346641533", -174},
  {1.2129790092166470035575936e-225, 13, "1212979009217", -224},
  {3.0263902239953339278441316e+274, 14, "30263902239953", 275},
  {2.5670782167449114087254970e-284, 4, "2567", -283},
  {9.1180809794197427655936169e-46, 8, "9118081", -45},
  {6.4586539542910915245019273e-108, 12, "645865395429", -107},
  {4.4509549678207249613167351e-128, 21, "445095496782072496132", -127},
  {4.7967536351561050149208548e-226, 6, "479675", -225},
  {5.5981050786400437802155520e+168, 6, "559811", 169},
  {1.5537955593708661379362228e+169, 11, "15537955594", 170},
  {8.0111135234987952032059508e-33, 9, "801111352", -32},
  {2.7873285513513215614095829e+97, 3, "279", 98},
  {1.3969108654906943215462636e+212, 16, "1396910865490694", 213},
  {6.7181778376540130290077333e+188, 10, "6718177838", 189},
  {2.6251195511674141525159005e-163, 13, "2625119551167", -162},
  {4.6727023408282146262112038e-194, 11, "46727023408", -193},
  {2.9845431302396936314018705e+263, 19, "2984543130239693631", 264},
  {3.2659040385401557339983473e-125, 8, "3265904", -124},
  {1.4130741630493186259632058e-93, 3, "141", -92},
  {3.3790280767538589119614121e-102, 16, "3379028076753859", -101},
  {4.8977998197998984722727994e+109, 21, "489779981979989847227", 110},
  {1.1103712919294657156573577e-88, 5, "11104", -87},
  {1.4482514080135647262660564e+209, 11, "1448251408", 210},
  {1.4199698859372886600100361e-91, 9, "141996989", -90},
  {6.5602761828485951638860684e+195, 20, "65602761828485951639", 196},
  {1.1847825520748308857253132e-08, 12, "118478255207", -7},
  {4.8231166116791295817162321e-104, 4, "4823", -103},
  {6.7632724925396940680338579e+44, 8, "67632725", 45},
  {8.4294775198348992881725887e+262, 7, "8429478", 263},
  {4.0785812001394772307336442e-76, 5, "40786", -75},
  {1.9219983960872693393884178e+181, 5, "1922", 182},
  {6.1392595288252637184000000e+19, 9, "613925953", 20},
  {1.4564650365547289505385783e-227, 15, "145646503655473", -226},
  {7.3036286484713542518375881e-91, 3, "73", -90},
  {1.5483684995101129650840199e-24, 10, "15483685", -23},
  {3.0084727916546096220853237e+200, 7, "3008473", 201},
  {2.1627694949062482398897955e-04, 9, "216276949", -3},
  {8.1738813835045397786154131e-38, 19, "8173881383504539779", -37},
  {3.2167543488101081007715734e+175, 1, "3", 176},
  {4.9736979645187766360379063e-169, 1, "5", -168},
  {5.4227490010695850520362811e+99, 16, "5422749001069585", 100},
  {4.2252843543578945866885853e-151, 7, "4225284", -150},
  {4.8227277248977050185203552e+06, 3, "482", 7},
  {2.6139730111775500572736731e+222, 4, "2614", 223},
  {3.8184777219725822364995512e+160, 9, "381847772", 161},
  {1.3012575383306993300949512e-255, 8, "13012575", -254},
  {2.9728051943983048413741438e-151, 3, "297", -150},
  {7.5702261317471698122153224e-13, 12, "757022613175", -12},
  {1.4358973648650222949069410e+88, 3, "144", 89},
  {2.9403380119421680000000000e+16, 12, "294033801194", 17},
  {4.9308484651391580353000001e+228, 6, "493085", 229},
  {1.0675738432780134596280472e-112, 9, "106757384", -111},
  {7.7295421914357923671305044e-45, 14, "77295421914358", -44},
  {4.0294209939740484205455380e+42, 18, "402942099397404842", 43},
  {1.3560662152627752964722025e-127, 16, "1356066215262775", -126},
  {3.8155524086442176431027218e+272, 21, "38155524086442176431", 273},
  {3.6362420799018721319147091e+176, 18, "363624207990187213", 177},
  {3.4406112653121796261884016e+242, 10, "3440611265", 243},
  {9.0177358539711900689985569e+89, 17, "90177358539711901", 90},
  {3.5962519083083797302069936e+214, 5, "35963", 215},
  {6.8290922359694288827082513e-282, 17, "68290922359694289", -281},
  {9.0543247873377928720676048e-98, 6, "905432", -97},
  {1.4357450585743985990929439e+307, 5, "14357", 308},
  {6.5036899123920702961955116e-197, 18, "65036899123920703", -196},
  {2.5509956452737523175515260e-306, 15, "255099564527375", -305},
  {2.9785796384376119261797262e-214, 7, "297858", -213},
  {1.9540815246305016354567662e+183, 6, "195408", 184},
  {1.4321913511083603311670214e-138, 1, "1", -137},
  {7.0210623640295591354370117e+09, 8, "70210624", 10},
  {8.7275145137156567741812649e+120, 12, "872751451372", 121},
  {4.3071824067903657610328437e+196, 15, "430718240679037", 197},
  {5.1717108730325572980928191e+129, 6, "517171", 130},
  {7.8478755672874793213694047e+247, 21, "784787556728747932137", 248},
  {9.0297967819700830458428102e+136, 6, "90298", 137},
  {4.5588360287128260454010086e-107, 3, "456", -106},
  {8.9949673248343788702090351e+187, 2, "9", 188},
  {7.8220628791465473136802954e-51, 17, "78220628791465473", -50},
  {2.3973861059929529969952383e-295, 19, "2397386105992952997", -294},
  {5.1949169687501047424614784e-163, 20, "51949169687501047425", -162},
  {3.5310079229127754182843267e-173, 14, "35310079229128", -172},
  {5.9438622195914434148164659e-161, 5, "59439", -160},
  {1.3624933036168466939834433e-22, 15, "136249330361685", -21},
  {9.8804489229655107407136878e-95, 15, "988044892296551", -94},
  {9.2024218983143448957908951e+191, 21, "920242189831434489579", 192},
  {2.1247491236227552404118467e-268, 15, "212474912362276", -267},
  {4.1296598418851585815372589e+148, 6, "412966", 149},
  {3.0298996400177723394871743e-30, 16, "3029899640017772", -29},
  {1.3694864108452969179269707e+140, 15, "13694864108453", 141},
  {7.4375070842513446966832371e-270, 1, "7", -269},
  {5.2420061843354561617463714e-210, 13, "5242006184335", -209},
  {4.2453657218135740715751393e-185, 6, "424537", -184},
  {4.4915100352590481667591871e+164, 9, "449151004", 165},
  {5.8181008695759689074833027e+286, 10, "581810087", 287},
  {7.4311058403974823365658725e-174, 2, "74", -173},
  {3.9048859390029639555203300e+193, 21, "390488593900296395552", 194},
  {1.4849673746005479380963522e-257, 16, "1484967374600548", -256},
  {2.9262613977585023760556917e-164, 10, "2926261398", -163},
  {5.2081183233060328324592388e-41, 21, "520811832330603283246", -40},
  {5.7041770715797812981176079e-124, 1, "6", -123},
  {3.1518893283438836225651001e-189, 17, "31518893283438836", -188},
  {3.1125976439767675145092074e-225, 17, "31125976439767675", -224},
  {2.2214912574568404658873936e-271, 7, "2221491", -270},
  {3.8741523660183138330802339e-70, 8, "38741524", -69},
  {1.9257374099977370897702140e-80, 16, "1925737409997737", -79},
  {8.0976560287773062577497179e+37, 12, "809765602878", 38},
  {2.2285931231949710475127623e-67, 15, "222859312319497", -66},
  {3.8315653914238127164104345e-239, 11, "38315653914", -238},
  {1.5486833137721556844830978e-295, 8, "15486833", -294},
  {2.6854787677956503687545256e+58, 16, "268547876779565", 59},
  {5.7188640469747289195565165e+277, 21, "571886404697472891956", 278},
  {4.5082464133809909457958499e+179, 10, "4508246413", 180},
  {1.0726589281981218156432250e-166, 1, "1", -165},
  {8.6583730407902698551768119e+178, 12, "865837304079", 179},
  {8.1707253357581419087301129e+244, 8, "81707253", 245},
  {3.3692444146679872675804314e-107, 20, "33692444146679872676", -106},
  {1.1361743071893908448227063e+153, 12, "113617430719", 154},
  {6.4637012447627340617675407e+104, 15, "646370124476273", 105},
  {2.4415374223945462803066330e-255, 18, "244153742239454628", -254},
  {4.0701207593459685023475231e+298, 4, "407", 299},
  {1.5070633968632239402924552e+290, 11, "15070633969", 291},
  {1.9544117736279027852541680e-97, 1, "2", -96},
  {4.6102062366507724153988528e-130, 3, "461", -129},
  {4.9237092703090882997005295e-76, 5, "49237", -75},
  {1.6609528488605218509059308e-94, 2, "17", -93},
  {1.2642864181844673312454392e+240, 10, "1264286418", 241},
  {7.5104124196128688901474390e+55, 4, "751", 56},
  {3.0870798938729341490924997e-85, 17, "30870798938729341", -84},
  {1.4004074453493717864991474e-211, 14, "14004074453494", -210},
  {1.6142426595567348698958838e-171, 3, "161", -170},
  {4.0168330193334727254231459e+90, 17, "40168330193334727", 91},
  {7.2694636464365142708844540e-06, 3, "727", -5},
  {1.0402071344205864083779975e+247, 12, "104020713442", 248},
  {1.4760163829187868129478947e-92, 9, "147601638", -91},
  {1.1365167144030207741363381e+136, 5, "11365", 137},
  {9.2126431743793760209473860e+291, 3, "921", 292},
  {1.4273215939702477477206421e+60, 15, "142732159397025", 61},
  {2.7314756428313879003114287e-121, 10, "2731475643", -120},
  {2.0597492312477717361629178e-282, 21, "205974923124777173616", -281},
  {3.2859252069788166253267147e+191, 1, "3", 192},
  {2.7229574291281444116528621e-63, 6, "272296", -62},
  {2.8075184147279204443141514e-308, 2, "28", -307},
  {7.3287623544533976089361397e-283, 6, "732876", -282},
  {9.4537680433074600184773855e-301, 11, "94537680433", -300},
  {1.2977226823929104520773561e-66, 11, "12977226824", -65},
  {3.8362330158732915211744549e-182, 21, "383623301587329152117", -181},
  {1.2881627798617572964837523e+131, 11, "12881627799", 132},
  {1.9199315941882824088082771e+00, 5, "19199", 1},
  {5.7207503550028872862538385e-179, 17, "57207503550028873", -178},
  {2.7857182194415170455443410e+157, 3, "279", 158},
  {2.2876954616670015811252587e+264, 21, "228769546166700158113", 265},
  {1.9356052370062021627328011e+138, 21, "193560523700620216273", 139},
  {5.5000939448623464232573603e-55, 7, "5500094", -54},
  {6.8429265780576731596277537e-251, 21, "684292657805767315963", -250},
  {4.3117013301605002471927104e+190, 19, "4311701330160500247", 191},
  {1.5847017864311698868403875e+47, 17, "15847017864311699", 48},
  {1.2709663964377633800535342e-161, 1, "1", -160},
  {1.6184243193517432934048885e-22, 17, "16184243193517433", -21},
  {2.2659058613393028396913995e+92, 15, "22659058613393", 93},
  {3.4141969667593764370394638e+02, 12, "341419696676", 3},
  {5.8913472319987794199190891e+254, 14, "58913472319988", 255},
  {3.1923048698992895055152469e-49, 5, "31923", -48},
  {3.6198125227060445777323474e+188, 12, "361981252271", 189},
  {4.0861026345047938725525807e-214, 4, "4086", -213},
  {2.3020416077778760572422250e-197, 21, "230204160777787605724", -196},
  {5.1688532920852310765371204e-33, 18, "516885329208523108", -32},
  {1.9924622106061280586324704e-141, 8, "19924622", -140},
  {2.7405679844264632046013155e-292, 5, "27406", -291},
  {1.6042256989686668372111776e+232, 13, "1604225698969", 233},
  {4.0561015048425975064497631e+35, 16, "4056101504842598", 36},
  {1.2182153052749607395922600e-07, 2, "12", -6},
  {7.4309894921654419450590074e-164, 15, "743098949216544", -163},
  {9.5570617908498344453693365e+283, 4, "9557", 284},
  {5.2689910460985826088379862e+31, 16, "5268991046098583", 32},
  {8.5435066822554813545154716e+200, 17, "85435066822554814", 201},
  {2.8042131310955612785874355e-295, 14, "28042131310956", -294},
  {6.1880873574104564913033412e-199, 1, "6", -198},
  {3.2052704322982316999268795e-301, 8, "32052704", -300},
  {2.5403076457222404265266594e-297, 11, "25403076457", -296},
  {3.5390367228716604215710055e-139, 12, "353903672287", -138},
  {6.1570649944068806512964319e-229, 9, "615706499", -228},
  {4.2711210696424849397223856e+158, 4, "4271", 159},
  {1.3567360136213808394466183e+106, 2, "14", 107},
  {4.9835046305447634182823267e+230, 1, "5", 231},
  {9.8083015093901118582448102e+226, 18, "980830150939011186", 227},
  {1.3074003935306802862988091e-222, 14, "13074003935307", -221},
  {2.8589319909552479259673419e+01, 2, "29", 2},
  {1.7439034808279658205462960e-299, 21, "174390348082796582055", -298},
  {4.3631048524750087438104380e-261, 20, "43631048524750087438", -260},
  {1.1306465402101770613370030e+188, 3, "113", 189},
  {3.6596558479942004736000000e+19, 4, "366", 20},
  {4.3420747707043638955767127e+116, 6, "434207", 117},
  {3.7620720914973982569058975e+206, 16, "3762072091497398", 207},
  {1.0259917537279418967739553e+144, 12, "102599175373", 145},
  {8.9170401492029897244139207e-123, 11, "89170401492", -122},
  {5.6287789769256142743409606e-193, 3, "563", -192},
  {3.6813522812917697821568032e+220, 17, "36813522812917698", 221},
  {5.8636105188684054203466385e+230, 3, "586", 231},
  {4.8859544604538950165342915e+30, 7, "4885954", 31},
  {6.5953241983773659775083506e-188, 9, "65953242", -187},
  {1.2294903443034662628343109e-102, 16, "1229490344303466", -101},
  {9.9282609082875579618352204e-185, 16, "9928260908287558", -184},
  {2.8742400750126426135657205e+274, 13, "2874240075013", 275},
  {8.9853156987422231167325167e-49, 13, "8985315698742", -48},
  {1.1819492255332278500477939e+49, 16, "1181949225533228", 50},
  {2.8049651376426536994798509e+251, 18, "28049651376426537", 252},
  {4.4747387294472048201220438e+132, 10, "4474738729", 133},
  {1.5289904222045375283863291e+41, 18, "152899042220453753", 42},
  {2.3232159849407244435673655e+128, 12, "232321598494", 129},
  {1.2292002278436030605090112e+113, 2, "12", 114},
  {8.5138477038380787632230478e-09, 18, "851384770383807876", -8},
  {1.4327391317151812456060606e+93, 14, "14327391317152", 94},
  {3.5823371876325622859257199e+61, 7, "3582337", 62},
  {8.5235661088291328287141476e-203, 9, "852356611", -202},
  {8.2873626003497543623266054e+124, 17, "82873626003497544", 125},
  {1.2076891911057245908544385e+225, 13, "1207689191106", 226},
  {2.3438662673943641605051213e-289, 14, "23438662673944", -288},
  {4.6848591092273158913215990e-80, 8, "46848591", -79},
  {4.5225917321012339469814404e-118, 8, "45225917", -117},
  {1.0460754409214416778244955e+67, 5, "10461", 68},
  {7.5487165042228009036166833e-75, 4, "7549", -74},
  {8.8462950587997130617664328e+269, 19, "8846295058799713062", 270},
  {4.2609666775376841149275312e+202, 9, "426096668", 203},
  {6.7872088247294400089505220e+264, 17, "678720882472944", 265},
  {1.3493722036948142524577800e+285, 15, "134937220369481", 286},
  {5.4781866718980204794696463e-30, 15, "547818667189802", -29},
  {2.9441242587136429538172287e-33, 19, "2944124258713642954", -32},
  {1.2606358949912808227539062e+11, 15, "126063589499128", 12},
  {1.9659224014706394076347351e+08, 11, "19659224015", 9},
  {3.6359657707002448393642236e-210, 1, "4", -209},
  {9.3096207085444276511415875e-21, 2, "93", -20},
  {5.2394015178525014994143781e-125, 7, "5239402", -124},
  {3.2335993849292485596407474e+256, 18, "323359938492924856", 257},
  {5.1140624986833645343615845e+251, 18, "511406249868336453", 252},
  {1.2665669445043568230710478e-176, 14, "12665669445044", -175},
  {3.3266107150310686371237311e-104, 6, "332661", -103},
  {6.9946741765155862955476969e+101, 12, "699467417652", 102},
  {5.4488896394730076250978763e-88, 21, "54488896394730076251", -87},
  {7.0469174399651124858392040e+44, 10, "704691744", 45},
  {7.8130725387989225563246649e+62, 3, "781", 63},
  {2.3533320398704824478345249e-308, 17, "23533320398704824", -307},
  {4.0666876198387532004883313e-65, 3, "407", -64},
  {9.9651268677415164807556505e-117, 16, "9965126867741516", -116},
  {1.1810339246917707881774897e+257, 16, "1181033924691771", 258},
  {2.9504299374332930416992388e-167, 5, "29504", -166},
  {2.8516552427392814914441353e+44, 5, "28517", 45},
  {1.1837258881838281563284231e+101, 8, "11837259", 102},
  {1.4481973556614986240000000e+18, 5, "14482", 19},
  {1.0075446725967542747136000e+22, 19, "1007544672596754275", 23},
  {3.8758282269852575480646784e-272, 11, "3875828227", -271},
  {6.8836159075860204137178556e-261, 3, "688", -260},
  {5.9605457982224600515215360e+24, 7, "5960546", 25},
  {1.9225633035902273382466184e-212, 9, "19225633", -211},
  {5.8305094125034224576735223e+273, 5, "58305", 274},
  {3.0585594946813967589169229e-143, 14, "30585594946814", -142},
  {2.6733057350645561940156957e-64, 16, "2673305735064556", -63},
  {6.8255501695853079614846145e-222, 12, "682555016959", -221},
  {1.2695348052273450494981146e+275, 10, "1269534805", 276},
  {2.0898360429450577773450992e+238, 20, "20898360429450577773", 239},
  {5.6672549853010766084211300e-297, 12, "56672549853", -296},
  {3.6169113927258438487544704e+156, 21, "361691139272584384875", 157},
  {7.1949825676118340877990587e-75, 21, "71949825676118340878", -74},
  {2.3872472748598735540419677e-238, 19, "2387247274859873554", -237},
  {9.8756287970707824326341349e-200, 13, "9875628797071", -199},
  {1.0081494963656531771912359e-307, 12, "100814949637", -306},
  {3.9346700509994174733271864e-217, 1, "4", -216},
  {2.6119084938914055881626825e+59, 1, "3", 60},
  {3.7851474232729151034501571e+304, 14, "37851474232729", 305},
  {1.4411288539219387388044486e+149, 2, "14", 150},
  {9.0817357209512641074989055e+101, 5, "90817", 102},
  {4.9662575914339177911098071e-153, 9, "496625759", -152},
  {2.4600111039224948936334600e+234, 19, "2460011103922494894", 235},
  {2.8046569189722033546786394e-49, 8, "28046569", -48},
  {7.4978766817574774621908039e+285, 21, "749787668175747746219", 286},
  {4.0101953701906717087579275e-296, 20, "40101953701906717088", -295},
  {1.3524129527014726091408464e+204, 20, "13524129527014726091", 205},
  {2.8183108028094892084920201e-173, 18, "281831080280948921", -172},
  {8.8788592893595142514687700e-223, 10, "8878859289", -222},
  {3.8912322374155166296869043e+241, 19, "389123223741551663", 242},
  {7.3723247265374438152162089e-194, 1, "7", -193},
  {1.7867170532711736357706350e+228, 19, "1786717053271173636", 229},
  {1.3619427222718649531024510e-58, 21, "13619427222718649531", -57},
  {3.8464860983705184459802902e+159, 2, "38", 160},
  {3.1665711251945046586175070e-30, 19, "3166571125194504659", -29},
  {1.1631269686557257550917780e+286, 8, "1163127", 287},
  {1.5838706017740505822428496e+73, 16, "1583870601774051", 74},
  {3.4707376782850451906563789e-168, 21, "347073767828504519066", -167},
  {4.7911216183351778975694022e+99, 8, "47911216", 100},
  {8.0299050359271293895673290e-150, 5, "80299", -149},
  {1.1793717535511473533257340e+168, 8, "11793718", 169},
  {1.1821612939046733847263340e-08, 8, "11821613", -7},
  {5.9176732145735482649383512e+153, 12, "591767321457", 154},
  {3.5887152403776589065323998e+235, 1, "4", 236},
  {3.3925328946455405690337160e-270, 4, "3393", -269},
  {8.1258721547937231020768737e+292, 16, "8125872154793723", 293},
  {1.3753948055135627505642821e-193, 3, "138", -192},
  {1.7050151023837349292218482e-214, 18, "170501510238373493", -213},
  {1.3368787238401130339074497e-240, 14, "13368787238401", -239},
  {2.6460024899805155970551314e-226, 13, "2646002489981", -225},
  {3.6597494246812657854674863e-75, 16, "3659749424681266", -74},
  {7.7953256465779591173951855e-205, 7, "7795326", -204},
  {3.0427637733902175296440459e-192, 21, "304276377339021752964", -191},
  {2.0048891621917577933916110e+107, 4, "2005", 108},
  {1.5517539573868864393978747e-111, 7, "1551754", -110},
  {1.1503822234844542783317127e+271, 7, "1150382", 272},
  {7.9770627993674988346656162e-150, 18, "797706279936749883", -149},
  {5.3138805785229832613154556e+142, 19, "5313880578522983261", 143},
  {1.5564675218483925388603733e-291, 17, "15564675218483925", -290},
  {6.0867737112087203125000000e+13, 15, "608677371120872", 14},
  {7.2379710884811238844166968e+135, 14, "72379710884811", 136},
  {5.0892109662390078724900485e+141, 19, "5089210966239007872", 142},
  {2.5752458512979096879868792e-223, 15, "257524585129791", -222},
  {6.6532541799261949445559480e+269, 3, "665", 270},
  {9.4240299725206601175632027e+100, 19, "9424029972520660118", 101},
  {3.3225059525833675917638864e-295, 14, "33225059525834", -294},
  {4.8315873771088015360000000e+18, 4, "4832", 19},
  {1.5588837787002783608070189e-02, 11, "15588837787", -1},
  {1.8646503290643018221894862e+285, 10, "1864650329", 286},
  {6.3659499333777913909765102e+41, 14, "63659499333778", 42},
  {1.7398052035657317062692230e-163, 7, "1739805", -162},
  {4.5464324490010224242380967e+190, 9, "454643245", 191},
  {4.2159991280496970335744219e+234, 4, "4216", 235},
  {6.5242711541071877441025069e+245, 10, "6524271154", 246},
  {2.0509930508287260502799325e+187, 19, "205099305082872605", 188},
  {5.0155831923535295190720149e+131, 10, "5015583192", 132},
  {1.1024537739059061867250183e-138, 7, "1102454", -137},
  {2.5812339346905535888671875e+11, 13, "2581233934691", 12},
  {1.4275218321485676423057288e+185, 3, "143", 186},
  {5.2875199050494879649286501e-137, 18, "528751990504948796", -136},
  {1.6520347101087799411147670e+62, 17, "16520347101087799", 63},
  {1.1221424957667243137760002e-280, 10, "1122142496", -279},
  {4.2226958410019789960398710e+288, 2, "42", 289},
  {1.3329871296688456627350329e+202, 13, "1332987129669", 203},
  {6.3725964980208793638016813e+86, 4, "6373", 87},
  {1.9424751555610360077583522e+301, 1, "2", 302},
  {7.1876570806799280497211321e+299, 17, "7187657080679928", 300},
  {1.9392260501578088386962521e-284, 6, "193923", -283},
  {7.1319264621874636623512291e-238, 16, "7131926462187464", -237},
  {3.6329353481361879006683284e+244, 6, "363294", 245},
  {1.6671440296072014315789057e-254, 9, "166714403", -253},
  {1.3087001379265164207136694e+182, 10, "1308700138", 183},
  {1.0630006344498333604085859e-272, 9, "106300063", -271},
  {3.0357598983603392882113882e+85, 13, "303575989836", 86},
  {2.0736444479239529972877168e-299, 6, "207364", -298},
  {5.3060070986244109911499852e+234, 21, "530600709862441099115", 235},
  {7.1022679729284011196271060e-224, 12, "710226797293", -223},
  {1.7315047321386151185533422e-24, 1, "2", -23},
  {2.0087018368657863448568757e+50, 13, "2008701836866", 51},
  {7.0330986792347477521625104e+279, 4, "7033", 280},
  {7.2112380197296974273630388e+78, 7, "7211238", 79},
  {1.3497759265585975781738213e+216, 1, "1", 217},
  {1.5644643667940704141276247e+217, 9, "156446437", 218},
  {3.0476675897377624077944526e-109, 3, "305", -108},
  {1.3643464707117595200000000e+17, 7, "1364346", 18},
  {6.4833109094038932932896948e+223, 16, "6483310909403893", 224},
  {4.0911394026111944839104757e+130, 15, "409113940261119", 131},
  {3.1027113370157227190029262e+64, 1, "3", 65},
  {4.7088161837197739416108783e+256, 18, "470881618371977394", 257},
  {8.1165791677540061769163013e-274, 12, "811657916775", -273},
  {1.8192161735619833084684759e+180, 15, "181921617356198", 181},
  {2.2138508741036241242960252e-31, 20, "22138508741036241243", -30},
  {1.1541246679743711788533493e-232, 2, "12", -231},
  {2.7186159355442645983310312e-165, 15, "271861593554426", -164},
  {7.2927112288350097112375349e+202, 17, "72927112288350097", 203},
  {9.4642523400512702408360470e-288, 1, "9", -287},
  {1.4131436701020176039088640e+259, 15, "141314367010202", 260},
  {6.9775522980754066848303207e-124, 14, "69775522980754", -123},
  {5.3942335766076551576343259e+79, 12, "539423357661", 80},
  {6.9666204647056392564190753e-231, 7, "696662", -230},
  {2.7193672959376189701620674e+46, 21, "271936729593761897016", 47},
  {3.5211856077044986620659981e-32, 19, "3521185607704498662", -31},
  {7.7583214479565052393103601e-130, 16, "7758321447956505", -129},
  {1.7367064373413084597458670e-301, 4, "1737", -300},
  {3.5607895020372681034135559e-65, 14, "35607895020373", -64},
  {2.6228502724469845208149996e-195, 13, "2622850272447", -194},
  {3.9416456190465407886759207e-307, 16, "3941645619046541", -306},
  {1.4055581054696010066298276e-215, 11, "14055581055", -214},
  {4.1359880221092821630865589e-262, 8, "4135988", -261},
  {3.8078633908726567904251859e+52, 8, "38078634", 53},
  {8.5302546690411301388288741e-275, 6, "853025", -274},
  {1.8425478732958995580006037e+79, 18, "184254787329589956", 80},
  {2.3460397224364168194127787e-129, 12, "234603972244", -128},
  {2.1236936623690016473074566e-176, 7, "2123694", -175},
  {5.3923549980050311279296875e+11, 21, "539235499800503112793", 12},
  {5.2103614679285165189507359e-81, 16, "5210361467928517", -80},
  {1.1704636009844752635746926e+160, 10, "1170463601", 161},
  {5.3858914191318461225031539e-134, 4, "5386", -133},
  {3.8184336191028451793170745e+240, 16, "3818433619102845", 241},
  {6.5167846484053127886650104e+195, 16, "6516784648405313", 196},
  {2.2207984788208910107664985e-110, 17, "2220798478820891", -109},
  {1.5672897747242456054687500e+11, 7, "156729", 12},
  {1.4203087161341520949657316e+64, 6, "142031", 65},
  {3.6555923463061596416329416e-185, 21, "365559234630615964163", -184},
  {2.9885158423034576337679470e-285, 16, "2988515842303458", -284},
  {1.2698841723902436237292927e+153, 11, "12698841724", 154},
  {5.5465713886943024567809046e-85, 1, "6", -84},
  {4.2296485091942353459924214e+221, 8, "42296485", 222},
  {7.4649040727171500874581392e+210, 5, "74649", 211},
  {7.7656691978772129405800919e-215, 9, "77656692", -214},
  {8.9252722742171629755651354e+132, 10, "8925272274", 133},
  {1.2055503781478578227336183e+106, 12, "120555037815", 107},
  {1.9562021665894358563388646e-107, 1, "2", -106},
  {1.3594430014740976862239117e-197, 21, "135944300147409768622", -196},
  {1.0459866707442743376848984e-201, 1, "1", -200},
  {4.3221077460430479088970390e+189, 4, "4322", 190},
  {1.8703374672634063327752556e-135, 6, "187034", -134},
  {1.5079680078767784674647086e+55, 11, "15079680079", 56},
  {1.8590483127128770601473622e-302, 4, "1859", -301},
  {6.7325451195252441965010932e-65, 4, "6733", -64},
  {3.8725937840287840908368960e+214, 12, "387259378403", 215},
  {4.0528345570855455489612322e-37, 5, "40528", -36},
  {1.9784995343541500153364110e+251, 6, "19785", 252},
  {2.2051951110334635258550224e+206, 10, "2205195111", 207},
  {7.7412453117498826857890268e-84, 13, "774124531175", -83},
  {1.1312981532995536349964893e-230, 17, "11312981532995536", -229},
  {1.0410551837391368205877523e-113, 16, "1041055183739137", -112},
  {1.7935651726177952176498887e-194, 11, "17935651726", -193},
  {1.9315745664556816572949711e+136, 15, "193157456645568", 137},
  {2.7451107593538579171098111e+231, 11, "27451107594", 232},
  {6.0307756466501368632090911e+252, 14, "60307756466501", 253},
  {3.9538974200486361271730695e-146, 4, "3954", -145},
  {1.2817675879140529101075821e+304, 12, "128176758791", 305},
  {1.1137423903885462577518117e+265, 9, "111374239", 266},
  {7.9179357362511210833363690e+257, 17, "79179357362511211", 258},
  {3.3197378106543364398553309e+60, 6, "331974", 61},
  {3.3770708479655246709424866e+34, 12, "337707084797", 35},
  {2.2918776786983731836687783e-26, 7, "2291878", -25},
  {3.8873356262052524113946876e-32, 17, "38873356262052524", -31},
  {2.6172596420488372689171508e-235, 1, "3", -234},
  {6.3406326737943744163859382e-117, 18, "634063267379437442", -116},
  {2.2823110512789481917618586e+26, 9, "228231105", 27},
  {1.5666140516094041154379876e-84, 13, "1566614051609", -83},
  {7.1008149837649514648880284e+28, 18, "710081498376495146", 29},
  {2.8506837105779838109689983e-142, 14, "2850683710578", -141},
  {8.9562688865397588182032465e+192, 8, "89562689", 193},
  {1.6277258765449405893210021e-257, 20, "16277258765449405893", -256},
  {8.4685235443875371134225515e+38, 4, "8469", 39},
  {4.6608696790227475406570606e+100, 12, "466086967902", 101},
  {5.5344173266383638853556380e-283, 18, "553441732663836389", -282},
  {6.2900440203342948867556725e-252, 14, "62900440203343", -251},
  {1.0136728848837180458214944e-72, 19, "1013672884883718046", -71},
  {1.9240982897064603174881376e-214, 20, "19240982897064603175", -213},
  {5.6596650955193836919918087e+103, 11, "56596650955", 104},
  {2.9261025222952831425061710e-243, 21, "292610252229528314251", -242},
  {5.3757457302186314578339110e+197, 12, "537574573022", 198},
  {2.7674001435956073376731089e-153, 15, "276740014359561", -152},
  {4.0647017012067018269396712e-34, 20, "40647017012067018269", -33},
  {1.5027357260486640510640526e+35, 7, "1502736", 36},
  {2.9219127853769920670306521e-111, 21, "292191278537699206703", -110},
  {1.9305618343602448940675446e-117, 17, "19305618343602449", -116},
  {5.6886560387338377956150673e-265, 4, "5689", -264},
  {2.0874936947805595340485722e-153, 6, "208749", -152},
  {7.0119369822063576065231306e-212, 21, "701193698220635760652", -211},
  {1.4151518153915555219780018e+282, 19, "1415151815391555522", 283},
  {7.1147595725026450703771528e+209, 5, "71148", 210},
  {3.1481270578404915381374260e-181, 15, "314812705784049", -180},
  {1.1250217105299213072811531e-180, 11, "11250217105", -179},
  {3.7870214115830703413958486e+163, 15, "378702141158307", 164},
  {1.7538556354067614012535149e-132, 1, "2", -131},
  {1.7225592757572345961447441e+273, 9, "172255928", 274},
  {8.9996286871315767173935890e-225, 11, "89996286871", -224},
  {6.0804808235496703146666361e+181, 13, "608048082355", 182},
  {7.0922600883084533906460558e+153, 9, "709226009", 154},
  {2.6490643668169233643590882e+67, 9, "264906437", 68},
  {6.6570196584712516299741707e-190, 20, "665701965847125163", -189},
  {2.7400167637686159406300588e-132, 21, "274001676376861594063", -131},
  {5.2314001331154188157699629e-46, 18, "523140013311541882", -45},
  {1.2569078130116782786995803e+134, 2, "13", 135},
  {4.1962511074772251683321885e-142, 2, "42", -141},
  {7.3152801304665484074213678e+267, 15, "731528013046655", 268},
  {1.9900216289528399490920130e-285, 11, "1990021629", -284},
  {6.2835785666694976000000000e+16, 20, "62835785666694976", 17},
  {1.3578043606790642637325268e-116, 21, "135780436067906426373", -115},
  {3.2886796537519707219184024e+276, 19, "3288679653751970722", 277},
  {3.5741523082377618868637846e+109, 5, "35742", 110},
  {7.5857790958879819222004143e+65, 18, "758577909588798192", 66},
  {3.4525529556585398765455444e+46, 4, "3453", 47},
  {1.4974920200859916338440369e-275, 19, "1497492020085991634", -274},
  {3.1072920180096676296494447e-234, 20, "31072920180096676296", -233},
  {1.7115708153539092857608359e+274, 6, "171157", 275},
  {3.8569571312135259017126450e-30, 13, "3856957131214", -29},
  {4.8272621481736543117072900e+283, 8, "48272621", 284},
  {4.1611553947845572462107866e+87, 5, "41612", 88},
  {1.2229578685074226754071876e+98, 10, "1222957869", 99},
  {1.6271193452209339194365055e-162, 19, "1627119345220933919", -161},
  {2.5935082956183560192000000e+19, 7, "2593508", 20},
  {1.6910207340712245662787397e-215, 7, "1691021", -214},
  {5.2849162177751647595138690e+197, 17, "52849162177751648", 198},
  {4.3091314316352719672601799e+163, 3, "431", 164},
  {1.7455065603723050022579959e-145, 13, "1745506560372", -144},
  {1.0462253090597456483168490e+40, 13, "104622530906", 41},
  {3.3632726830596745429254255e+84, 18, "336327268305967454", 85},
  {6.6886778814842157736624323e-172, 6, "668868", -171},
  {1.8960793942506429314175295e-296, 11, "18960793943", -295},
  {1.3700815961964550561955334e+219, 13, "1370081596196", 220},
  {3.6729564589403633973856587e-228, 11, "36729564589", -227},
  {1.9496269088031485110811560e-227, 1, "2", -226},
  {1.4198465548059663104141368e+205, 8, "14198466", 206},
  {1.2454270887192751670192325e-76, 5, "12454", -75},
  {7.7499311596026224276200316e-282, 4, "775", -281},
  {3.9193710076872287982621705e+135, 16, "3919371007687229", 136},
  {2.6513850845948905116067827e+295, 4, "2651", 296},
  {1.9040064625163829304617580e-39, 13, "1904006462516", -38},
  {9.1497540324800290970319630e+271, 5, "91498", 272},
  {1.3131068482352489261925151e+154, 14, "13131068482352", 155},
  {4.4529039105004084599613476e-179, 10, "4452903911", -178},
  {1.8898270873119216403419923e+69, 6, "188983", 70},
  {1.4101276256531259798488545e-155, 12, "141012762565", -154},
  {4.5011664580066615169086523e+49, 19, "4501166458006661517", 50},
  {4.0736258171695157569451355e+217, 5, "40736", 218},
  {4.6320205042034752566067200e+24, 8, "46320205", 25},
  {3.1454062376305290604745979e+37, 19, "314540623763052906", 38},
  {1.8895475465148605134707000e+105, 13, "1889547546515", 106},
  {3.9461249508071457560445266e-244, 10, "3946124951", -243},
  {4.8697134057676486458415547e+37, 6, "486971", 38},
  {2.0119102112890876889818051e+224, 10, "2011910211", 225},
  {2.7067328370365494335987839e-281, 5, "27067", -280},
  {3.6004382454976781759071579e-206, 20, "36004382454976781759", -205},
  {1.4824326662419845841746793e-29, 5, "14824", -28},
  {9.6658387007896468147774782e+113, 12, "966583870079", 114},
  {2.3228929356249028072740129e-277, 13, "2322892935625", -276},
  {1.8266231223974902092117048e-281, 12, "18266231224", -280},
  {3.7116313162536493879728174e-283, 7, "3711631", -282},
  {2.8934378675637975755310274e-219, 1, "3", -218},
  {4.6809278245699248296628391e+90, 3, "468", 91},
  {1.7158155616526054142772656e-294, 1, "2", -293},
  {2.1964743580823467191116905e+115, 5, "21965", 116},
  {8.3018655535358437475749406e+106, 16, "8301865553535844", 107},
  {1.0806002435899431620118844e-94, 20, "1080600243589943162", -93},
  {1.2263740070841542738591924e+220, 10, "1226374007", 221},
  {3.1956946875956228577939745e-161, 8, "31956947", -160},
  {1.6747844329850825319555033e-239, 21, "167478443298508253196", -238},
  {4.8742297322317377028847662e+109, 6, "487423", 110},
  {5.0752002612212680216535254e-45, 5, "50752", -44},
  {2.8313447676876034565615297e-245, 16, "2831344767687603", -244},
  {1.1916514526679261787079050e-118, 19, "1191651452667926179", -117},
  {1.0841784888765174014393257e-222, 14, "10841784888765", -221},
  {2.1127956547349308157064345e+280, 19, "2112795654734930816", 281},
  {7.0717707495432170460471893e+129, 7, "7071771", 130},
  {1.8547844801107076867272547e-122, 10, "185478448", -121},
  {2.0744203289963027128307836e-178, 2, "21", -177},
  {1.4911070214988204460943849e-90, 3, "149", -89},
  {1.1695531103073982189011997e+221, 11, "11695531103", 222},
  {3.4883949787579255190388690e+255, 21, "348839497875792551904", 256},
  {4.6659271512420752185771731e+90, 2, "47", 91},
  {4.3836675311556235310889838e-274, 2, "44", -273},
  {1.3518048445665360851240259e+105, 15, "135180484456654", 106},
  {5.2935885879429367898060316e+223, 21, "529358858794293678981", 224},
  {3.5102241737794704511802834e-113, 2, "35", -112},
  {3.6252400726452568832148813e+223, 13, "3625240072645", 224},
  {3.8206516948969797451085910e+66, 8, "38206517", 67},
  {6.9381109526328486856643711e-162, 9, "693811095", -161},
  {7.0744598581686698775549330e-281, 6, "707446", -280},
  {6.4796441072353279875683961e+85, 19, "6479644107235327988", 86},
  {2.6317247270929198290711227e-285, 20, "26317247270929198291", -284},
  {4.6577724250195886080000000e+18, 12, "465777242502", 19},
  {3.6485034963092578617552924e+143, 18, "364850349630925786", 144},
  {6.8500281576375163590433650e-249, 2, "69", -248},
  {3.0350061714432220348121707e-20, 1, "3", -19},
  {2.5027114513969011961235265e+253, 21, "250271145139690119612", 254},
  {2.3450844822673713210515878e-99, 4, "2345", -98},
  {8.9382337064488742818384635e+35, 3, "894", 36},
  {4.9519167394592404365539551e+07, 7, "4951917", 8},
  {1.2586683764465967632227152e-91, 11, "12586683764", -90},
  {9.3823844514664309160995184e-39, 9, "938238445", -38},
  {4.8913769776361505478812071e+286, 9, "489137698", 287},
  {4.3281309941991246709248340e+51, 15, "432813099419912", 52},
  {3.5215234505230338113474978e-150, 3, "352", -149},
  {9.6298773756138891794789644e+268, 19, "9629877375613889179", 269},
  {1.6356482968815157266806778e-87, 19, "1635648296881515727", -86},
  {3.1785960208552217962171373e-213, 9, "317859602", -212},
  {3.4395744307679457400944575e-128, 19, "343957443076794574", -127},
  {2.8626828829289861292704884e-89, 2, "29", -88},
  {1.6118113894245038201009530e+168, 10, "1611811389", 169},
  {6.5535955077875440231320803e-251, 16, "6553595507787544", -250},
  {7.7084652983420046344761817e-123, 11, "77084652983", -122},
  {1.5217568299876338243484497e+08, 8, "15217568", 9},
  {3.9919986850675181085893887e-292, 21, "399199868506751810859", -291},
  {1.4691043766245397582273038e-153, 3, "147", -152},
  {2.0272103787497742992682881e+152, 9, "202721038", 153},
  {9.8481773901106474493475789e-96, 7, "9848177", -95},
  {8.3106705033706379054888815e+110, 5, "83107", 111},
  {9.2435172077179248158087422e+84, 2, "92", 85},
  {6.0815075510428738481908371e+205, 9, "608150755", 206},
  {6.4794682700258977900069466e-261, 11, "647946827", -260},
  {3.9226920848314455149667366e+193, 19, "3922692084831445515", 194},
  {1.0395772144975227982507026e-69, 15, "103957721449752", -68},
  {1.9778605281453656967399445e+56, 8, "19778605", 57},
  {7.1980045628787417615422869e+227, 16, "7198004562878742", 228},
  {5.5017326315013780972788059e+254, 20, "55017326315013780973", 255},
  {4.0982223399223328322166277e-15, 12, "409822233992", -14},
  {3.1117216389133617959182456e-192, 7, "3111722", -191},
  {1.5653640382635718323530751e+40, 7, "1565364", 41},
  {2.6122752215696749831807497e+153, 17, "2612275221569675", 154},
  {3.1464150152360890555008641e+60, 1, "3", 61},
  {3.5022619038580850232544045e-223, 3, "35", -222},
  {5.6634317501944532883139590e-93, 13, "5663431750194", -92},
  {1.2860916109446902847854617e+102, 4, "1286", 103},
  {4.6283777798388061463767145e+45, 9, "462837778", 46},
  {1.1292943460767766936096442e-206, 17, "11292943460767767", -205},
  {3.6492914031790448271160529e+112, 14, "3649291403179", 113},
  {8.0236829166352561328798790e-295, 15, "802368291663526", -294},
  {1.9038243298289131649749464e-175, 1, "2", -174},
  {1.1885921923064740252084676e-154, 16, "1188592192306474", -153},
  {9.0719681342919529864790772e+169, 18, "907196813429195299", 170},
  {6.6798398315556574385058972e-301, 20, "66798398315556574385", -300},
  {8.2655593459889217851195433e-83, 15, "826555934598892", -82},
  {2.7061450539759001725316703e-164, 4, "2706", -163},
  {4.4593069483638300190479222e-302, 5, "44593", -301},
  {1.0445235082745897137487298e+304, 10, "1044523508", 305},
  {6.4348805908948392647367060e-136, 3, "643", -135},
  {1.6375647354587576022034906e-204, 15, "163756473545876", -203},
  {1.8412886121664766334638555e-22, 6, "184129", -21},
  {1.3474329069893548022528951e+246, 12, "134743290699", 247},
  {1.3010711679397873664284863e-127, 3, "13", -126},
  {1.5937830599201307163326218e-158, 4, "1594", -157},
  {7.2960124551781640240956838e+306, 16, "7296012455178164", 307},
  {3.1192529938749766472163177e+68, 2, "31", 69},
  {8.6752687619052353359226692e-275, 8, "86752688", -274},
  {1.8387040374052775526400000e+22, 3, "184", 23},
  {1.0560056063199028889374244e-65, 13, "105600560632", -64},
  {1.8501662549762873775008728e-258, 11, "1850166255", -257},
  {1.3293977109777011882729657e-98, 8, "13293977", -97},
  {3.8443309903731322752131435e-37, 12, "384433099037", -36},
  {2.6626844492357077291845533e+123, 10, "2662684449", 124},
  {6.1595568111162179909244144e-287, 13, "6159556811116", -286},
  {6.3225011330562167560822888e+129, 10, "6322501133", 130},
  {1.0844515411409651898420739e-69, 11, "10844515411", -68},
  {3.4761789111248952930649478e+164, 10, "3476178911", 165},
  {6.1031614649802063022085600e-304, 10, "6103161465", -303},
  {7.2890999143552437881972142e-163, 14, "72890999143552", -162},
  {3.5148237810500737587915410e+00, 12, "351482378105", 1},
  {5.6009139487368625481043595e-114, 19, "5600913948736862548", -113},
  {2.4980788737622490135459995e+244, 18, "249807887376224901", 245},
  {4.5562257787245034965566892e+64, 6, "455623", 65},
  {2.2605656566105467676273770e-70, 19, "2260565656610546768", -69},
  {2.8577262455686820729999550e-109, 20, "2857726245568682073", -108},
  {6.9567493992617793887323707e+126, 20, "69567493992617793887", 127},
  {2.5613866538730300167002522e+26, 7, "2561387", 27},
  {3.3488132048112575561243446e+37, 18, "334881320481125756", 38},
  {9.6180998169527205993299373e-50, 19, "9618099816952720599", -49},
  {3.1216547795440405298691718e-164, 9, "312165478", -163},
  {5.6293945554260119216412505e-236, 11, "56293945554", -235},
  {1.6547541923836100675106961e+212, 19, "1654754192383610068", 213},
  {5.8430934781022943867160916e-188, 10, "5843093478", -187},
  {4.6976096748181896145537519e+151, 12, "469760967482", 152},
  {7.4251088578479158040725568e-61, 17, "74251088578479158", -60},
  {9.4750169382960817658783640e+173, 18, "947501693829608177", 174},
  {1.6486114241023132410275367e-13, 19, "1648611424102313241", -12},
  {2.6871389631326354777375242e-20, 21, "268713896313263547774", -19},
  {1.4900620685045168084174844e-236, 3, "149", -235},
  {1.5318767276708152485164369e-55, 11, "15318767277", -54},
  {1.5400330614622667060099628e+212, 17, "15400330614622667", 213},
  {3.8961690201135696698046954e+212, 4, "3896", 213},
  {2.8300793477575427113212476e-270, 15, "283007934775754", -269},
  {3.1776854366108684520587443e+147, 10, "3177685437", 148},
  {6.4135187363255298647603887e+32, 10, "6413518736", 33},
  {7.5262459483938947454299468e+307, 18, "752624594839389475", 308},
  {2.0151017367637426520079301e-10, 6, "20151", -9},
  {9.1325370794344121893567535e-168, 10, "9132537079", -167},
  {8.3943661314489018197916133e+238, 14, "83943661314489", 239},
  {8.1158263358733370518745201e+82, 7, "8115826", 83},
  {1.3209154412427489153254960e-59, 20, "13209154412427489153", -58},
  {4.3100240877756285015297156e-139, 3, "431", -138},
  {8.7430872285677281688897882e-61, 16, "8743087228567728", -60},
  {1.2629194611141832000565893e+200, 9, "126291946", 201},
  {4.2563031824483027031855895e-52, 20, "42563031824483027032", -51},
  {2.5037196197486133564157012e+71, 2, "25", 72},
  {6.8098480570943468158321204e-305, 8, "68098481", -304},
  {3.5914256270738085548851852e-292, 19, "3591425627073808555", -291},
  {1.6096711290200573063611036e+198, 17, "16096711290200573", 199},
  {1.3148250725132410157329804e+160, 9, "131482507", 161},
  {5.6735352881735797039038275e-236, 20, "56735352881735797039", -235},
  {2.8766518573995275327532444e-20, 10, "2876651857", -19},
  {5.2559128855004222648691618e+174, 3, "526", 175},
  {1.4143629164901447298966692e+34, 11, "14143629165", 35},
  {2.6648937146740422185458975e+36, 3, "266", 37},
  {3.8189948480215084028601805e+269, 2, "38", 270},
  {2.3271037489077776524263614e-183, 8, "23271037", -182},
  {1.5595199181814592424369997e+165, 5, "15595", 166},
  {4.0007483832026559623532466e+88, 11, "40007483832", 89},
  {1.6956584653730415641435715e+291, 11, "16956584654", 292},
  {4.7692183776585600136995092e+280, 6, "476922", 281},
  {2.8846495845879236131175623e-297, 15, "288464958458792", -296},
  {1.6784766837296424505289688e+233, 16, "1678476683729642", 234},
  {1.0703853790955843994225916e+00, 12, "10703853791", 1},
  {1.9051454113833292494101539e-235, 21, "190514541138332924941", -234},
  {3.2270815470767015646976730e-287, 10, "3227081547", -286},
  {6.2614223599351912315247972e+29, 5, "62614", 30},
  {1.1062378159105601828713298e-113, 20, "11062378159105601829", -112},
  {8.7799596161359404305683394e-35, 4, "878", -34},
  {3.3008860457653237934011882e+94, 16, "3300886045765324", 95},
  {9.8395542620651455503621242e+107, 6, "983955", 108},
  {1.6057966512156420160680678e+299, 13, "1605796651216", 300},
  {9.2482830462222003050880508e+251, 20, "92482830462222003051", 252},
  {5.2826137276433314927398994e+178, 16, "5282613727643331", 179},
  {2.5721830307667676003520942e-129, 2, "26", -128},
  {6.2334736314278091972400695e-26, 6, "623347", -25},
  {3.2696224088166789332629048e-288, 8, "32696224", -287},
  {4.6803215697984152632317277e-241, 6, "468032", -240},
  {1.7368210276542037918756358e-191, 20, "17368210276542037919", -190},
  {1.5766766303874726096296293e+34, 21, "157667663038747260963", 35},
  {1.1649416405408130294678419e-107, 16, "1164941640540813", -106},
  {5.7385136948632256989932934e-170, 21, "573851369486322569899", -169},
  {3.9599650309510497680629052e+147, 9, "395996503", 148},
  {3.7219046113949242739281822e+137, 13, "3721904611395", 138},
  {5.2401830878093654388605373e+43, 19, "5240183087809365439", 44},
  {7.2268859779837116362818509e-169, 5, "72269", -168},
  {1.8424810320602514543412554e+165, 9, "184248103", 166},
  {5.9729837876223494359772402e-282, 19, "5972983787622349436", -281},
  {1.1406067513757149596944211e+223, 16, "1140606751375715", 224},
  {1.3071441283451894393383830e-151, 9, "130714413", -150},
  {1.1138518602129264814516955e+133, 16, "1113851860212926", 134},
  {2.5948186931760480711149263e-270, 14, "2594818693176", -269},
  {9.7698692652243951755123097e-263, 7, "9769869", -262},
  {4.2006144606146008484914477e-297, 9, "420061446", -296},
  {6.6464050953803151937091076e-246, 5, "66464", -245},
  {4.8425185640380295763452299e+204, 7, "4842519", 205},
  {1.2289090476572278274042600e+38, 17, "12289090476572278", 39},
  {6.7270556477122404455110813e+304, 16, "672705564771224", 305},
  {5.7145737275203905318883096e-259, 4, "5715", -258},
  {1.1359607315214324186030982e+223, 9, "113596073", 224},
  {7.3955529998389395717889723e-150, 2, "74", -149},
  {1.1252362829878620645385901e+260, 5, "11252", 261},
  {3.6287592190443209387562162e-137, 18, "362875921904432094", -136},
  {1.3843661096323791150427836e+66, 3, "138", 67},
  {4.7612212051919821588591187e-248, 14, "4761221205192", -247},
  {2.0891673297197952079987691e-165, 11, "20891673297", -164},
  {4.2790942591019051176379726e-58, 10, "4279094259", -57},
  {2.3408404926660797627884659e-256, 16, "234084049266608", -255},
  {1.0302084318630740166443439e+71, 15, "103020843186307", 72},
  {3.9384910292388854939739475e-50, 12, "393849102924", -49},
  {6.4379254251419079751243557e+46, 5, "64379", 47},
  {6.4296316857889978127052651e-246, 18, "642963168578899781", -245},
  {2.8388659351527462604281027e+03, 19, "283886593515274626", 4},
  {8.8959311243244139025019718e-77, 5, "88959", -76},
  {1.9036115401941127904640576e+265, 7, "1903612", 266},
  {2.0086610457487737585988766e+212, 4, "2009", 213},
  {7.0965313344829451120503282e+181, 19, "7096531334482945112", 182},
  {9.6934724276705061745711652e+288, 8, "96934724", 289},
  {1.5980522592043484048367780e-29, 20, "15980522592043484048", -28},
  {5.5864033971338681470392338e+66, 7, "5586403", 67},
  {3.1809720257224686379603381e-12, 12, "318097202572", -11},
  {5.8030458574694524458911519e-216, 20, "58030458574694524459", -215},
  {2.6214942888975724601008203e+301, 6, "262149", 302},
  {9.3899616872829513549804688e+10, 5, "939", 11},
  {2.2095358155766105922447559e-14, 1, "2", -13},
  {1.1218606575024142844775906e-299, 1, "1", -298},
  {1.1366608084535175702118400e+24, 6, "113666", 25},
  {2.4000737844257545103467995e-203, 3, "24", -202},
  {5.9116802608163129346790760e-286, 15, "591168026081631", -285},
  {1.8752008842508558200117119e-17, 16, "1875200884250856", -16},
  {9.9517630505372994822247665e+299, 1, "1", 301},
  {2.1898945013071452224656502e-276, 17, "21898945013071452", -275},
  {1.7016897420470563200000000e+17, 14, "17016897420471", 18},
  {2.4460660479871263287566012e-113, 21, "244606604798712632876", -112},
  {1.9172248051842531474794029e+68, 6, "191722", 69},
  {1.6011565140364294957232500e-205, 2, "16", -204},
  {8.5256112679143673007820932e-98, 16, "8525611267914367", -97},
  {3.1561729724499467441119878e-58, 7, "3156173", -57},
  {2.7425696251847243557245251e+223, 8, "27425696", 224},
  {2.8357215798414594201793440e-50, 17, "28357215798414594", -49},
  {2.0746857746673156233238408e+108, 21, "207468577466731562332", 109},
  {1.3281189407816981506347656e+11, 19, "1328118940781698151", 12},
  {5.4499800517181500121725085e-251, 13, "5449980051718", -250},
  {7.2928649706324313317636169e+78, 20, "72928649706324313318", 79},
  {2.1094784361389970226064162e+33, 15, "2109478436139", 34},
  {1.5978148830477521080100589e-301, 14, "15978148830478", -300},
  {6.2888702287577577838664550e-08, 9, "628887023", -7},
  {7.3134402263991616623890504e-210, 14, "73134402263992", -209},
  {7.4358095686777388605079955e+141, 10, "7435809569", 142},
  {1.1034205813500859612678737e-259, 14, "11034205813501", -258},
  {3.2156661286714365526406316e-129, 7, "3215666", -128},
  {4.8064157112385883746131668e+65, 18, "480641571123858837", 66},
  {1.5737236768113247369527515e-299, 19, "1573723676811324737", -298},
  {1.0545731982509083172772080e+05, 16, "1054573198250908", 6},
  {4.4015464587793620303273201e+06, 10, "4401546459", 7},
  {1.7572335631991760720063384e+44, 5, "17572", 45},
  {4.3393234977112119824486302e-124, 7, "4339323", -123},
  {4.5580185216493615401078875e-236, 7, "4558019", -235},
  {3.7139963676681256687940398e-249, 3, "371", -248},
  {1.4504494182764014319383347e+26, 18, "145044941827640143", 27},
  {1.5628185238905967657697437e+67, 13, "1562818523891", 68},
  {4.7117526927885942536841285e-111, 13, "4711752692789", -110},
  {2.9494457325109423788597059e+242, 2, "29", 243},
  {1.2438226878860929764040308e-187, 6, "124382", -186},
  {7.1807455969446006916382526e-109, 8, "71807456", -108},
  {1.3915506720253387048680980e+46, 6, "139155", 47},
  {3.7951725804524908107259952e-265, 5, "37952", -264},
  {1.7195259105635412109427379e-252, 21, "171952591056354121094", -251},
  {6.3254386194851390500642985e-91, 6, "632544", -90},
  {2.1039868646597632376016158e-277, 6, "210399", -276},
  {2.2218692257343939016891512e+209, 12, "222186922573", 210},
  {1.5073761478546542316792610e+134, 21, "150737614785465423168", 135},
  {2.2652154940585808209545921e+219, 10, "2265215494", 220},
  {5.8507121266572965759322059e-31, 1, "6", -30},
  {1.4284334829219525436638084e-129, 11, "14284334829", -128},
  {3.9498979046243086845480754e-253, 4, "395", -252},
  {1.2622057023383128554730469e-174, 4, "1262", -173},
  {3.2085551159550916064407273e-132, 17, "32085551159550916", -131},
  {4.0349895941278795394077722e+141, 4, "4035", 142},
  {1.8968004999295395138662752e-168, 9, "18968005", -167},
  {1.8435586987770658527786221e+135, 16, "1843558698777066", 136},
  {1.0707095387690032746060659e-78, 3, "107", -77},
  {6.9315112682558754973684109e-290, 3, "693", -289},
  {6.1782022941919693903390310e+26, 15, "617820229419197", 27},
  {2.4877474774940749398991884e-305, 12, "248774747749", -304},
  {5.0446782243667755345434597e-283, 12, "504467822437", -282},
  {1.3377645146763063590137632e+74, 17, "13377645146763064", 75},
  {1.6933245817106690142116910e-135, 21, "169332458171066901421", -134},
  {2.2840138410704693357466587e+222, 11, "22840138411", 223},
  {6.3739032189780660316911023e-108, 1, "6", -107},
  {1.4989309690321962024411921e-99, 8, "1498931", -98},
  {1.0621617175212898205792308e-279, 20, "10621617175212898206", -278},
  {6.2413436342271510921813457e-115, 9, "624134363", -114},
  {7.4876664264164888799716928e+45, 6, "748767", 46},
  {4.5280667327300056118304762e-257, 17, "45280667327300056", -256},
  {1.7861696481779420152483768e+92, 12, "178616964818", 93},
  {5.6067648533305756778387130e-83, 9, "560676485", -82},
  {5.3158997597012803421495317e+87, 11, "53158997597", 88},
  {3.5573581888935408002110367e+59, 14, "35573581888935", 60},
  {7.7860095024964545620537964e-218, 19, "7786009502496454562", -217},
  {6.0571125876825440722371514e-302, 18, "605711258768254407", -301},
  {3.3178090715419277462077440e+24, 8, "33178091", 25},
  {2.3234119600044762359476437e+112, 8, "2323412", 113},
  {2.8676979057442311517703768e+95, 11, "28676979057", 96},
  {6.1409113876768000156684341e+297, 10, "6140911388", 298},
  {7.8021639517508934069749023e+55, 8, "7802164", 56},
  {1.1985103666916677667639834e-104, 19, "1198510366691667767", -103},
  {6.3899495977692339660840999e-135, 2, "64", -134},
  {2.6578941279437637393867820e-293, 20, "26578941279437637394", -292},
  {1.0403411717751797813364516e+66, 6, "104034", 67},
  {1.0215001215524645080244291e-208, 10, "1021500122", -207},
  {2.0413235779764391008798966e+294, 8, "20413236", 295},
  {8.7086714542880141191601549e+97, 2, "87", 98},
  {4.6351901235539262324892972e-211, 13, "4635190123554", -210},
  {4.0623729538684549376086969e-272, 20, "40623729538684549376", -271},
  {9.2023483748957742260792852e+27, 11, "92023483749", 28},
  {1.4140411033319307281238323e+194, 5, "1414", 195},
  {7.7983850386274192259318186e+295, 20, "77983850386274192259", 296},
  {5.1735907451029290567007599e-160, 17, "51735907451029291", -159},
  {3.3111799908845608722998004e+195, 15, "331117999088456", 196},
  {8.2619739482739845650910610e-30, 18, "826197394827398457", -29},
  {1.6951062992826249519115961e+256, 8, "16951063", 257},
  {1.3982362668336293343602912e-227, 5, "13982", -226},
  {2.7711832674083805781589177e-228, 3, "277", -227},
  {1.0018167963539763940825198e-216, 21, "100181679635397639408", -215},
  {1.0349444780264152680249810e+36, 11, "1034944478", 37},
  {5.0526376649333890611615061e+00, 19, "5052637664933389061", 1},
  {1.5348409151914570374874286e+189, 19, "1534840915191457037", 190},
  {7.6534652591943649646249789e+93, 7, "7653465", 94},
  {2.7111624977589874574844677e+282, 8, "27111625", 283},
  {6.4954417390203786805790547e-220, 10, "6495441739", -219},
  {7.5029608228564733889641851e-237, 18, "750296082285647339", -236},
  {6.9562880174083074583962771e+114, 1, "7", 115},
  {1.8617088818990032333403368e+303, 8, "18617089", 304},
  {1.8747026714523899466758737e+64, 4, "1875", 65},
  {9.4742101962409319665209787e+224, 12, "947421019624", 225},
  {2.5101255276294284057617188e+11, 18, "251012552762942841", 12},
  {2.3539624454484813487166172e-169, 5, "2354", -168},
  {3.0025727013706946315333496e-234, 17, "30025727013706946", -233},
  {3.6383191487660171175255099e-51, 11, "36383191488", -50},
  {2.1547299706808195868782176e-258, 19, "2154729970680819587", -257},
  {1.9429388587795439757854865e+00, 7, "1942939", 1},
  {3.2152765552216541431715099e-176, 21, "321527655522165414317", -175},
  {4.9272276734154738712147309e-83, 20, "49272276734154738712", -82},
  {5.5372767695099596886913455e-176, 8, "55372768", -175},
  {7.5623351432970178858098692e+240, 10, "7562335143", 241},
  {1.0594017685836427422563647e+176, 12, "105940176858", 177},
  {3.5616203434371689928828334e-119, 20, "35616203434371689929", -118},
  {9.7908338501133441011362945e-101, 4, "9791", -100},
  {7.3184398615677181164976231e-236, 3, "732", -235},
  {4.2445630014016846867345674e+63, 6, "424456", 64},
  {2.6404780196156744598413065e+101, 21, "264047801961567445984", 102},
  {9.2267477598405587580137479e+225, 8, "92267478", 226},
  {7.8960192110007590888005185e+156, 11, "7896019211", 157},
  {2.6204531845386847836289994e+180, 10, "2620453185", 181},
  {2.2885320311693430562974799e+113, 10, "2288532031", 114},
  {7.5984839955268300800000000e+18, 12, "759848399553", 19},
  {1.3247555529649785156250000e+12, 18, "132475555296497852", 13},
  {2.6620761267743223829747160e-298, 21, "266207612677432238297", -297},
  {3.7928123733158754067800492e+60, 13, "3792812373316", 61},
  {9.3947252707324859186417594e-228, 19, "9394725270732485919", -227},
  {8.4677064688322397716800579e-73, 17, "84677064688322398", -72},
  {6.0838573671990836787128716e-169, 2, "61", -168},
  {1.8198113280997240375019420e+151, 2, "18", 152},
  {7.9469292229828028939664364e+05, 3, "795", 6},
  {2.3674228589909154052296599e-225, 2, "24", -224},
  {3.9892126877186988629523422e+177, 18, "398921268771869886", 178},
  {4.0484818398591000979607579e+76, 19, "4048481839859100098", 77},
  {2.1314351686042145291431822e+145, 16, "2131435168604215", 146},
  {3.3594787443315286741954189e-119, 18, "335947874433152867", -118},
  {2.2060765289678865637474494e+123, 14, "22060765289679", 124},
  {4.8842585782831659509890071e+305, 16, "4884258578283166", 306},
  {3.4316994733067348409337138e+50, 9, "343169947", 51},
  {4.5062882362021402613451521e+306, 17, "45062882362021403", 307},
  {2.2849373110519486052120237e+195, 21, "228493731105194860521", 196},
  {3.3581827980324701597963180e-130, 1, "3", -129},
  {1.0645654610385286589535804e-52, 9, "106456546", -51},
  {1.1156860389881837697812762e+295, 4, "1116", 296},
  {1.9897448491606039801222767e-246, 14, "19897448491606", -245},
  {1.2341509123477733743846628e-273, 7, "1234151", -272},
  {3.6271471408328335748142039e-49, 1, "4", -48},
  {6.5316992149190306272507400e-204, 15, "653169921491903", -203},
  {2.9409269184686313153287429e-02, 6, "294093", -1},
  {6.4378357025368553187419919e+104, 14, "64378357025369", 105},
  {4.4495631473768289292308744e-197, 13, "4449563147377", -196},
  {2.4579409768607721385092675e-269, 17, "24579409768607721", -268},
  {1.2675985634493706767667582e+189, 11, "12675985634", 190},
  {1.1720010622046534071138479e-224, 16, "1172001062204653", -223},
  {1.3798173412936474582080153e-21, 4, "138", -20},
  {3.7524633200822401686634026e+236, 11, "37524633201", 237},
  {5.3167564440958791608463949e+50, 19, "5316756444095879161", 51},
  {2.7948913250258318614189112e+268, 17, "27948913250258319", 269},
  {1.1484444207175485078631611e-276, 3, "115", -275},
  {8.2111361836735405626343393e+135, 17, "82111361836735406", 136},
  {2.6799515128281201710063909e-294, 15, "267995151282812", -293},
  {2.9480445731182488070033087e+270, 5, "2948", 271},
  {3.3699759792252897657031788e+87, 15, "336997597922529", 88},
  {3.0020382775338147692229828e+39, 13, "3002038277534", 40},
  {5.7676289271599839032531753e+251, 12, "576762892716", 252},
  {6.0844898924998130109085898e-158, 21, "608448989249981301091", -157},
  {4.0167043580263385926288671e-165, 17, "40167043580263386", -164},
  {3.8863586583974906137926637e-34, 15, "388635865839749", -33},
  {1.3272435266870864218400326e-255, 3, "133", -254},
  {3.0286180489030723218519558e+53, 3, "303", 54},
  {1.0800597356759091324887893e-100, 16, "1080059735675909", -99},
  {1.8270874346786873942253194e+279, 10, "1827087435", 280},
  {2.9561749820498197798531832e-144, 2, "3", -143},
  {1.0324520182370484200665406e+124, 20, "10324520182370484201", 125},
  {5.4493777689661842474780179e-304, 16, "5449377768966184", -303},
  {2.3709304497252499943502546e-08, 17, "237093044972525", -7},
  {1.6261679696370016073626941e-182, 2, "16", -181},
  {2.3547369436880451490264214e+187, 12, "235473694369", 188},
  {1.4599469247561198973382900e+265, 12, "145994692476", 266},
  {1.9452296450715994191951366e+53, 1, "2", 54},
  {1.0935928949073389383681268e-251, 8, "10935929", -250},
  {2.2476980145531591472757068e-173, 16, "2247698014553159", -172},
  {3.8483215710762602279722548e+267, 9, "384832157", 268},
  {1.1472645496194726244033013e+254, 3, "115", 255},
  {2.3076938214367720076061843e+128, 2, "23", 129},
  {5.0456728633764416260603136e-287, 7, "5045673", -286},
  {2.8036249777912594168773007e-129, 9, "280362498", -128},
  {1.7077247416600257899950354e-298, 14, "170772474166", -297},
  {7.1624580579461808680173546e-235, 8, "71624581", -234},
  {3.1570968826971573234969606e+246, 8, "31570969", 247},
  {2.2928332559096523819609775e+95, 17, "22928332559096524", 96},
  {9.2397816294417495883101442e-192, 19, "9239781629441749588", -191},
  {1.0847415455110362022773651e+174, 7, "1084742", 175},
  {3.6369619764904772096494536e-188, 12, "363696197649", -187},
  {2.3539691826225066825197812e-303, 18, "235396918262250668", -302},
  {1.0274554072856475804001295e-275, 6, "102746", -274},
  {1.4328791187093040270214411e+259, 21, "143287911870930402702", 260},
  {7.4211817342035914810266839e-173, 10, "7421181734", -172},
  {6.7267170878859666207539200e+23, 4, "6727", 24},
  {1.5240601396639117330558624e+65, 1, "2", 66},
  {9.4123340138964506384359098e+76, 13, "9412334013896", 77},
  {2.7134564493304163123356533e+53, 11, "27134564493", 54},
  {3.4954481632487176487101669e+173, 12, "349544816325", 174},
  {1.7941041654284602580018707e+67, 5, "17941", 68},
  {1.2252154414149740019324142e-02, 19, "1225215441414974002", -1},
  {1.9902214934028189520972584e+135, 15, "199022149340282", 136},
  {1.3065717273601216831925269e+304, 20, "13065717273601216832", 305},
  {4.1802313039453813874694711e-304, 11, "41802313039", -303},
  {8.3337997057041995743904037e+229, 2, "83", 230},
  {3.7425590783473396517149618e-170, 7, "3742559", -169},
  {3.3463848919109108479430870e-12, 11, "33463848919", -11},
  {2.6718199855943425397339864e-173, 10, "2671819986", -172},
  {5.8566705589750564511093974e+70, 5, "58567", 71},
  {3.3358506075951690528067551e+254, 4, "3336", 255},
  {3.7296082378818626382781798e+63, 14, "37296082378819", 64},
  {9.2309047044136885823037351e+201, 11, "92309047044", 202},
  {4.3062128067190646843957392e-09, 20, "43062128067190646844", -8},
  {7.7788413437705210633643885e+31, 21, "777884134377052106336", 32},
  {1.3381757814033719395246666e+287, 19, "133817578140337194", 288},
  {1.1151411420918734175788019e-96, 15, "111514114209187", -95},
  {6.1550888196833635656508197e+245, 1, "6", 246},
  {2.0342348099858895137459970e-38, 8, "20342348", -37},
  {4.0091730683028541907205659e+167, 1, "4", 168},
  {1.1611409681843925989391961e+134, 15, "116114096818439", 135},
  {9.8543263713075286114699556e+172, 2, "99", 173},
  {1.2465396934415104675292969e+11, 5, "12465", 12},
  {1.2914689333562217368906455e+134, 11, "12914689334", 135},
  {1.0774540873283477151901284e-100, 13, "1077454087328", -99},
  {2.7491794207501821230827903e+197, 16, "2749179420750182", 198},
  {4.4681737022145730033031994e+148, 19, "4468173702214573003", 149},
  {2.1979630305114496624476606e+30, 15, "219796303051145", 31},
  {1.4089833912368320713006443e-84, 7, "1408983", -83},
  {6.0582124289561250374125702e+111, 13, "6058212428956", 112},
  {3.9435189710984520694872968e+71, 19, "3943518971098452069", 72},
  {2.4962066997874344629846880e+95, 15, "249620669978743", 96},
  {2.3628836164777029218737925e-256, 17, "23628836164777029", -255},
  {1.9088014193096534935881283e-116, 13, "190880141931", -115},
  {2.9872140550173724404160130e-165, 8, "29872141", -164},
  {2.5613292719333930569099814e-103, 13, "2561329271933", -102},
  {5.6380905133639702860653723e+228, 15, "563809051336397", 229},
  {1.2693505228628828250899092e+196, 5, "12694", 197},
  {2.8033838900012792717835998e-160, 6, "280338", -159},
  {6.1325662215854464496293887e+146, 18, "613256622158544645", 147},
  {2.3338581047627952431567662e-73, 2, "23", -72},
  {1.6048586569717542660746428e+65, 4, "1605", 66},
  {1.1794718089193057196566893e-185, 2, "12", -184},
  {2.0735477352507321861746882e+266, 7, "2073548", 267},
  {1.1618292500090088246908635e+264, 4, "1162", 265},
  {4.2536101255614596155125361e+98, 3, "425", 99},
  {1.5061830048936885917338846e-46, 9, "1506183", -45},
  {4.9923244507819829433139959e+218, 3, "499", 219},
  {3.7072644921834517862636003e-151, 2, "37", -150},
  {2.2845540494674633531380900e+244, 7, "2284554", 245},
  {3.3013676775346982233875619e-261, 3, "33", -260},
  {7.7024683996705949749286674e-62, 4, "7702", -61},
  {2.7699547668045502139817398e+171, 12, "27699547668", 172},
  {6.0522419795995523768473403e-99, 19, "6052241979599552377", -98},
  {8.1109297850892320286463143e-241, 15, "811092978508923", -240},
  {1.2391474262104404624551535e+05, 13, "123914742621", 6},
  {1.2758897162876490357692376e-62, 12, "127588971629", -61},
  {1.2611107522470322722843986e+271, 14, "1261110752247", 272},
  {7.6838822788434816547818128e-211, 11, "76838822788", -210},
  {2.5704208348582471963046900e+134, 10, "2570420835", 135},
  {2.1340495896883682926507281e-150, 19, "2134049589688368293", -149},
  {9.3266667552642492880969014e-241, 17, "93266667552642493", -240},
  {3.5603521214066155664597951e-166, 21, "356035212140661556646", -165},
  {6.1697693596891979819740888e+306, 17, "6169769359689198", 307},
  {2.1265636990186678250028909e-238, 13, "2126563699019", -237},
  {3.7384643256438302065322311e-244, 6, "373846", -243},
  {3.5978808548234137010620465e-145, 9, "359788085", -144},
  {5.6457213890901377259029447e+302, 21, "56457213890901377259", 303},
  {9.3098054660020900274845676e-125, 16, "930980546600209", -124},
  {2.4513050323384808619660488e+293, 2, "25", 294},
  {1.9830075897564558557904852e+294, 20, "19830075897564558558", 295},
  {1.7241269613509518277492620e-158, 2, "17", -157},
  {1.4882576832188246248524290e-181, 15, "148825768321882", -180},
  {2.6336697684218175078141478e-216, 3, "263", -215},
  {2.0841870329597153696185189e+290, 17, "20841870329597154", 291},
  {1.5069678445934448460235504e-18, 10, "1506967845", -17},
  {1.1525639132244547596857515e+101, 17, "11525639132244548", 102},
  {1.7300326346477507071200884e-251, 21, "173003263464775070712", -250},
  {4.0642789144101800755008897e-183, 17, "40642789144101801", -182},
  {4.0830089270719011189658704e+291, 13, "4083008927072", 292},
  {4.5744722945751458726795182e+198, 2, "46", 199},
  {1.0312154277774565000037550e-29, 5, "10312", -28},
  {1.7020586704325489172884902e-08, 6, "170206", -7},
  {3.5706302918997798887453697e+143, 19, "3570630291899779889", 144},
  {1.9356249151959254132937007e-279, 2, "19", -278},
  {3.2909806924563886306068864e-58, 10, "3290980692", -57},
  {6.0017698816427387242811164e+00, 12, "600176988164", 1},
  {8.4772713004241084125873404e-244, 21, "847727130042410841259", -243},
  {2.0312108396431170272769464e+45, 18, "203121083964311703", 46},
  {2.4490197143504473227404860e-112, 13, "244901971435", -111},
  {1.2786615643432368912826048e-229, 11, "12786615643", -228},
  {1.9055070967286967187925466e+106, 8, "19055071", 107},
  {4.1063852594268334256868008e+175, 20, "41063852594268334257", 176},
  {2.1978673072415430198447358e-69, 15, "219786730724154", -68},
  {6.8744679906847328093621052e-76, 4, "6874", -75},
  {1.6156547331095576291586802e-281, 16, "1615654733109558", -280},
  {3.1510191174786385890231090e+32, 21, "315101911747863858902", 33},
  {2.7332008977038361517043060e+151, 8, "27332009", 152},
  {2.0765573194819446749395956e+157, 1, "2", 158},
  {4.5622347444067250570068413e+305, 20, "4562234744406725057", 306},
  {4.0335431070963305121349715e-272, 3, "403", -271},
  {3.2014675682095596943345372e-05, 12, "320146756821", -4},
  {1.0574318169418794332429792e+269, 9, "105743182", 270},
  {1.3798270014393988711195579e-196, 14, "13798270014394", -195},
  {2.6388509472042016478772896e+265, 16, "2638850947204202", 266},
  {2.4309509267040983022123379e+163, 15, "24309509267041", 164},
  {1.0740093733064886976125008e+305, 11, "10740093733", 306},
  {1.5908972602174573915404117e-303, 18, "159089726021745739", -302},
  {1.3271718745794748888272685e-249, 7, "1327172", -248},
  {3.3639333183079432487744547e+231, 17, "33639333183079432", 232},
  {9.2744720093340077847416214e+240, 8, "9274472", 241},
  {2.2960866573884913397253456e-265, 7, "2296087", -264},
  {1.5671379990781554548049873e-90, 14, "15671379990782", -89},
  {2.4725854595363139712565621e+57, 14, "24725854595363", 58},
  {6.7198572098524579576325452e+93, 19, "6719857209852457958", 94},
  {3.3839600947303246317028490e-101, 7, "338396", -100},
  {7.5456890004025369352470528e+25, 11, "75456890004", 26},
  {1.5485955632445633263781134e-68, 21, "154859556324456332638", -67},
  {8.1139867404288180817470441e+135, 12, "811398674043", 136},
  {2.7297281113509886409381775e+107, 7, "2729728", 108},
  {2.3165193822461414762357008e-232, 9, "231651938", -231},
  {9.3837176527162941056303680e+04, 11, "93837176527", 5},
  {4.3469311603733625922316675e-260, 21, "434693116037336259223", -259},
  {3.6964958281448913185535246e-305, 16, "3696495828144891", -304},
  {2.3950463437309616218163094e-237, 10, "2395046344", -236},
  {1.2378225896935577829153583e-226, 17, "12378225896935578", -225},
  {5.5684763095611963948658953e+263, 13, "5568476309561", 264},
  {3.6560183600828376250784345e+130, 5, "3656", 131},
  {3.9990955495190508485655276e-269, 11, "39990955495", -268},
  {1.4770909899659102898864207e-291, 11, "147709099", -290},
  {5.8510398020986245853272615e-226, 9, "58510398", -225},
  {2.7203045602464587661717839e+75, 20, "27203045602464587662", 76},
  {2.5318057672522751246513462e+104, 15, "253180576725228", 105},
  {1.6256131804288591117075374e-54, 16, "1625613180428859", -53},
  {3.1842211985266003646392965e-252, 20, "31842211985266003646", -251},
  {1.0993301615348045590199439e-37, 7, "109933", -36},
  {1.2739049365995685114884872e+95, 7, "1273905", 96},
  {2.3343677656033577407037192e-88, 19, "2334367765603357741", -87},
  {4.8596610777012722808678824e-202, 19, "4859661077701272281", -201},
  {1.5580722979739279889539524e-98, 13, "1558072297974", -97},
  {1.5037467865033250572216994e+237, 6, "150375", 238},
  {5.1729153750134541585650174e-23, 18, "517291537501345416", -22},
  {2.6599217335869294538182272e-251, 17, "26599217335869295", -250},
  {2.5320001511033596631677064e-66, 1, "3", -65},
  {9.4021022624086388097307670e-106, 2, "94", -105},
  {2.9107906956069821746494637e+206, 16, "2910790695606982", 207},
  {5.9922357188067389637308358e-228, 20, "59922357188067389637", -227},
  {2.6210421304041560196102650e+92, 10, "262104213", 93},
  {7.5787251683698877550129370e-22, 12, "757872516837", -21},
  {2.1121170412833542096686753e-158, 1, "2", -157},
  {2.5183534297742189161070416e+33, 20, "25183534297742189161", 34},
  {1.5410507011016335608809052e+81, 18, "154105070110163356", 82},
  {9.6667754473425543693167957e+247, 7, "9666775", 248},
  {1.7663300064518567991354582e-176, 21, "176633000645185679914", -175},
  {3.1547682518106928411129741e-196, 15, "315476825181069", -195},
  {7.7504575851191527038680023e-205, 3, "775", -204},
  {9.0791266809553616696146384e-198, 4, "9079", -197},
  {2.8591925011896230101858634e+132, 10, "2859192501", 133},
  {2.2549975277359853846847816e+27, 2, "23", 28},
  {1.0398451457045551580755482e+39, 21, "103984514570455515808", 40},
  {9.1877434712105121451604180e-42, 2, "92", -41},
  {7.0557121146059765469927453e-121, 15, "705571211460598", -120},
  {2.2088703535460927888274504e-187, 19, "2208870353546092789", -186},
  {2.2904478963391817994302210e-32, 1, "2", -31},
  {1.0811227654734137439668903e+279, 17, "10811227654734137", 280},
  {4.1190207705055042014549149e+263, 15, "41190207705055", 264},
  {6.9689482605416134779241358e+266, 12, "696894826054", 267},
  {2.3222825238034747186155471e-01, 2, "23", 0},
  {1.9934546616462720142967939e-154, 3, "199", -153},
  {1.7083256967099552782279620e+145, 6, "170833", 146},
  {4.9592776805923320353031158e+07, 20, "49592776805923320353", 8},
  {5.2776441273709115693506576e-159, 13, "5277644127371", -158},
  {5.6902593135816821695548368e-118, 11, "56902593136", -117},
  {1.3605068162372184091922181e-217, 6, "136051", -216},
  {7.8864645018484942364383279e+233, 15, "788646450184849", 234},
  {2.6723791054493090063469179e+31, 12, "267237910545", 32},
  {7.8873157739621423376010384e+93, 6, "788732", 94},
  {4.4981737572970544479615660e+271, 2, "45", 272},
  {4.2793009113842671295980258e+128, 14, "42793009113843", 129},
  {7.5865969166526485690713697e-169, 10, "7586596917", -168},
  {8.9630273708720807852209036e-137, 5, "8963", -136},
  {1.3040606687466031751838583e-272, 3, "13", -271},
  {1.2487401957625720900110740e+184, 20, "124874019576257209", 185},
  {9.2919699617721965832363110e+269, 3, "929", 270},
  {4.9664219544602396794766629e+295, 20, "49664219544602396795", 296},
  {2.4981379572486887642271922e+113, 20, "24981379572486887642", 114},
  {6.3229007896213835898740390e-127, 10, "632290079", -126},
  {1.1311300439195631250000000e+14, 9, "113113004", 15},
  {3.2880291429769978954375566e+179, 18, "32880291429769979", 180},
  {6.5346907787723785175003811e+218, 2, "65", 219},
  {1.1324775813159576087962066e+132, 15, "113247758131596", 133},
  {6.5655344346409788574080617e+140, 13, "6565534434641", 141},
  {4.7938131732009190461420068e-11, 2, "48", -10},
  {1.6905228749673028502922901e+217, 8, "16905229", 218},
  {1.1430991437943537005084100e+228, 18, "11430991437943537", 229},
  {3.3917184608578224128000000e+19, 19, "3391718460857822413", 20},
  {4.0658698292082313227123805e-69, 5, "40659", -68},
  {1.4439272042111531922265016e-107, 18, "144392720421115319", -106},
  {9.2082225207640681721180633e-241, 20, "92082225207640681721", -240},
  {1.9355505464478723106235289e-253, 9, "193555055", -252},
  {7.2244722133625347563483336e-156, 11, "72244722134", -155},
  {1.0854485767703840962512728e+45, 20, "10854485767703840963", 46},
  {1.1802138396659714733445580e+32, 11, "11802138397", 33},
  {8.9360373015379418844486160e-65, 11, "89360373015", -64},
  {1.7993369231817652676210890e-128, 5, "17993", -127},
  {1.9653373171160992988799377e-132, 20, "19653373171160992989", -131},
  {3.8609150096455370018987188e+239, 20, "38609150096455370019", 240},
  {4.1558827089017066454932255e-64, 16, "4155882708901707", -63},
  {1.2022466175040198050064260e+46, 9, "120224662", 47},
  {1.3675814794395037649256704e-220, 17, "13675814794395038", -219},
  {7.1256319727844591498183831e-262, 8, "7125632", -261},
  {3.4145952591502609424481602e-07, 19, "3414595259150260942", -6},
  {1.5409945477552840584297119e-299, 14, "15409945477553", -298},
  {1.0138971837317371060269380e+197, 20, "1013897183731737106", 198},
  {1.1743148591542443259010616e+84, 6, "117431", 85},
  {3.1402353199454603663528418e+38, 11, "31402353199", 39},
  {9.7677161826058702622797527e+186, 21, "976771618260587026228", 187},
  {1.6639555270821051162642756e-123, 16, "1663955527082105", -122},
  {3.7450453897261464350861460e-12, 19, "3745045389726146435", -11},
  {5.2465901594924022829714299e+299, 14, "52465901594924", 300},
  {7.1061589620862087727676469e-153, 11, "71061589621", -152},
  {8.4823402704352861670410398e+150, 8, "84823403", 151},
  {5.0926358257524386025633315e+123, 20, "50926358257524386026", 124},
  {8.0542676707301717497729744e-223, 6, "805427", -222},
  {1.4997135362267638183228771e-151, 20, "14997135362267638183", -150},
  {2.6366302381627696932578279e-104, 19, "2636630238162769693", -103},
  {2.8683160584803475514706059e-199, 11, "28683160585", -198},
  {3.1696509066102717374621085e-33, 18, "316965090661027174", -32},
  {8.0665273582342163708706473e+54, 20, "80665273582342163709", 55},
  {8.8098997397388567208361118e-213, 8, "88098997", -212},
  {5.2949450221428422580633600e+23, 20, "52949450221428422581", 24},
  {1.6238281655147576985697785e-275, 14, "16238281655148", -274},
  {2.7900862191276004534334396e-138, 13, "2790086219128", -137},
  {2.8976194216338741861019262e-229, 8, "28976194", -228},
  {4.1155902142563970432660335e-286, 21, "411559021425639704327", -285},
  {6.1046353810974920634422119e+127, 12, "61046353811", 128},
  {8.5534982011058218015234381e+53, 18, "85534982011058218", 54},
  {5.8489603502234576739993374e+167, 11, "58489603502", 168},
  {1.1805656774403684695018755e+303, 13, "118056567744", 304},
  {7.9678116592764509490698196e+123, 3, "797", 124},
  {1.5663929969883763085353856e+208, 13, "1566392996988", 209},
  {2.1216106609752919277052568e+153, 15, "212161066097529", 154},
  {1.7620525459884081188495500e-120, 6, "176205", -119},
  {1.3606498247216897825572765e-177, 12, "136064982472", -176},
  {2.7350129291757291152792931e-200, 12, "273501292918", -199},
  {7.9323182778210267839330836e+171, 2, "79", 172},
  {9.2736596752998687204966400e+23, 2, "93", 24},
  {4.3645468603433579949760134e+120, 5, "43645", 121},
  {1.4826856926148078828257518e+144, 15, "148268569261481", 145},
  {3.0842469298561157139166451e-244, 11, "30842469299", -243},
  {7.8654633333813368147861412e+30, 19, "7865463333381336815", 31},
  {1.8004928116418948769569397e+08, 12, "180049281164", 9},
  {2.6855037112860237923885892e-199, 9, "268550371", -198},
  {6.8073454940393054804599566e+292, 17, "68073454940393055", 293},
  {6.9043203530093048689249940e+141, 3, "69", 142},
  {5.5380176130533208230731517e-278, 9, "553801761", -277},
  {7.3962774362886820763419242e-188, 4, "7396", -187},
  {1.0592352218078899922104712e-205, 8, "10592352", -204},
  {3.1589334319915669024313937e+44, 4, "3159", 45},
  {3.6989303182041810992301856e-193, 9, "369893032", -192},
  {4.8120465859584063667874896e+174, 7, "4812047", 175},
  {3.5622893188776322824801429e-175, 17, "35622893188776323", -174},
  {7.0565600879986854679639301e-116, 11, "7056560088", -115},
  {4.5746263982322766742396852e+181, 17, "45746263982322767", 182},
  {1.4456650101651482541821228e+94, 18, "144566501016514825", 95},
  {8.4843072829662974112450005e-72, 5, "84843", -71},
  {4.5368609497954483123336287e-198, 6, "453686", -197},
  {7.4763605840329619713929174e-83, 17, "7476360584032962", -82},
  {3.6241073869230588063535995e+135, 11, "36241073869", 136},
  {4.2793869659028288583990001e+37, 12, "42793869659", 38},
  {2.2802436155284866457920410e+256, 13, "2280243615528", 257},
  {2.1931724618166857618792466e-135, 16, "2193172461816686", -134},
  {1.3623424991677216887711662e+214, 7, "1362342", 215},
  {1.5818447743131682887609448e-276, 1, "2", -275},
  {8.6462928029317983392843169e+204, 13, "8646292802932", 205},
  {1.8117181520107984738066524e+170, 10, "1811718152", 171},
  {9.6483786916348353109545117e+238, 10, "9648378692", 239},
  {3.3122700115749021084628044e+302, 1, "3", 303},
  {6.6525072397171155182705406e-122, 19, "6652507239717115518", -121},
  {5.6397453142076941501557594e+218, 8, "56397453", 219},
  {1.3954292880480567017842507e+221, 13, "1395429288048", 222},
  {1.0075747378330459328855073e-101, 14, "1007574737833", -100},
  {8.3048612752372879927256502e+229, 3, "83", 230},
  {2.8188974339222830635001043e-199, 14, "28188974339223", -198},
  {1.5631021394568438733151141e+223, 3, "156", 224},
  {1.2414908110445616669711445e+240, 19, "1241490811044561667", 241},
  {1.0998410532491132040774626e-228, 10, "1099841053", -227},
  {2.6749337350904266847859948e-193, 4, "2675", -192},
  {1.5999164967554366431586307e-243, 14, "15999164967554", -242},
  {1.2747669264147737319860334e-213, 4, "1275", -212},
  {2.2518425398971258120964743e-07, 4, "2252", -6},
  {3.2844093478996662536375726e-193, 13, "32844093479", -192},
  {5.6142204463520425360973034e+59, 15, "561422044635204", 60},
  {4.6493427082746410619041800e-97, 19, "4649342708274641062", -96},
  {9.6082940471940601520729400e+92, 8, "9608294", 93},
  {3.4244672919638680389102969e+117, 14, "34244672919639", 118},
  {1.2024438714833908647960925e+02, 6, "120244", 3},
  {7.1540372349677028296355275e+00, 12, "715403723497", 1},
  {1.3554291156699021085134155e-117, 6, "135543", -116},
  {4.6864555334290987128370308e+197, 19, "4686455533429098713", 198},
  {3.1464946213759774849601021e+230, 13, "3146494621376", 231},
  {1.8099371743911528236620250e-224, 5, "18099", -223},
  {4.5150628911401083528418427e+29, 15, "451506289114011", 30},
  {2.6278409629510288983597743e-184, 3, "263", -183},
  {3.0905112625439557875532177e-219, 6, "309051", -218},
  {5.9705061435946303776028249e+91, 8, "59705061", 92},
  {2.3833013790305613170861290e+142, 11, "2383301379", 143},
  {9.2658632644248682728961705e+152, 13, "9265863264425", 153},
  {9.2655649696542420230308352e+241, 21, "926556496965424202303", 242},
  {4.6740725114932953143465192e-37, 4, "4674", -36},
  {1.1979208207930401138326875e+274, 8, "11979208", 275},
  {9.1904660966370941337600000e+20, 5, "91905", 21},
  {3.3844697834017561110873622e-24, 16, "3384469783401756", -23},
  {3.6404266260197616507052262e-271, 18, "364042662601976165", -270},
  {1.5522809964400996091065341e+275, 1, "2", 276},
  {5.0623712813849185353854350e-227, 10, "5062371281", -226},
  {6.3596196207722925919370027e+00, 19, "6359619620772292592", 1},
  {2.0423221007514192146454062e+88, 16, "2042322100751419", 89},
  {1.7572241847184009098783294e-143, 3, "176", -142},
  {5.5069453232178688269828900e-275, 21, "550694532321786882698", -274},
  {3.5095826021217117325734691e-37, 20, "35095826021217117326", -36},
  {4.7297977245773361154307709e+94, 13, "4729797724577", 95},
  {1.2466407097643675270426189e-233, 5, "12466", -232},
  {1.6757038722023379062441870e-28, 4, "1676", -27},
  {6.0576977684140893788942811e+237, 10, "6057697768", 238},
  {7.4161156989026604125730283e+243, 9, "74161157", 244},
  {3.3412656185518587219173109e+187, 10, "3341265619", 188},
  {7.4332491438161336887851967e+218, 8, "74332491", 219},
  {5.6707784364356309441386815e-130, 9, "567077844", -129},
  {1.6872430189235677968019788e-246, 8, "1687243", -245},
  {4.0103667324017221920330420e-64, 4, "401", -63},
  {1.1969166265774419158556495e+258, 19, "1196916626577441916", 259},
  {2.9182980182134822141516081e-164, 10, "2918298018", -163},
  {1.2589706357578290392002850e-277, 13, "1258970635758", -276},
  {4.3398470538819474359363907e-73, 17, "43398470538819474", -72},
  {2.0689046861592237352571734e+248, 13, "2068904686159", 249},
  {5.8265285915675000053116181e-60, 15, "58265285915675", -59},
  {7.8383402611499520000000000e+16, 1, "8", 17},
  {6.8064710828517699431315670e-99, 3, "681", -98},
  {5.3173524866243488094331251e-256, 6, "531735", -255},
  {1.2616146239731728446046429e-274, 21, "12616146239731728446", -273},
  {1.5764719480716826118294648e-255, 16, "1576471948071683", -254},
  {5.9237346772489026188850403e+07, 17, "59237346772489026", 8},
  {4.3339616640887463096589308e-154, 19, "433396166408874631", -153},
  {3.3410943456526007904521412e-21, 3, "334", -20},
  {7.4542202160195210873665016e-114, 7, "745422", -113},
  {3.8220957338116371246948439e+69, 15, "382209573381164", 70},
  {4.5841895936615862004751542e-91, 18, "45841895936615862", -90},
  {1.4428031166819680485593295e+256, 14, "1442803116682", 257},
  {2.6387952804074948250320436e-307, 20, "2638795280407494825", -306},
  {8.3740612218928332184082281e-282, 12, "837406122189", -281},
  {1.7943077115925822549709448e+178, 8, "17943077", 179},
  {8.0875909773222035207958713e-156, 8, "8087591", -155},
  {8.3003365713078069748190780e+93, 14, "83003365713078", 94},
  {2.4943072539754997154899581e-300, 20, "24943072539754997155", -299},
  {2.1963505288007082598385340e-206, 6, "219635", -205},
  {6.6738375858645186033563177e+289, 20, "66738375858645186034", 290},
  {1.1560145072357037911986420e+129, 5, "1156", 130},
  {1.2455318098228613470684160e+193, 15, "124553180982286", 194},
  {3.0339085592134503254979385e-170, 4, "3034", -169},
  {2.7477844611691231428077954e-307, 12, "274778446117", -306},
  {2.2317676950430269143724712e+168, 8, "22317677", 169},
  {5.7548348502948037384158703e+98, 9, "575483485", 99},
  {5.1885636532558476952634885e+291, 2, "52", 292},
  {5.8719870628356453199323072e+244, 11, "58719870628", 245},
  {7.5373165396890301167796708e+261, 8, "75373165", 262},
  {3.2264234295373570103403082e+214, 7, "3226423", 215},
  {3.0372238841727374229617368e+35, 18, "303722388417273742", 36},
  {8.0573049496744828394748198e-165, 10, "805730495", -164},
  {4.1466160852750213715528946e-50, 14, "4146616085275", -49},
  {3.1422693703111732006072998e+08, 21, "314226937031117320061", 9},
  {1.2238697738692711475877118e+274, 9, "122386977", 275},
  {2.9276382444153423242278803e+58, 1, "3", 59},
  {5.7930264711859293317269367e+252, 20, "57930264711859293317", 253},
  {6.8244614409553128578728865e-112, 6, "682446", -111},
  {2.4131033064393117017928491e-247, 17, "24131033064393117", -246},
  {5.8974073319677545078168948e+134, 9, "589740733", 135},
  {1.9384150903753277752042492e-222, 8, "19384151", -221},
  {3.2427296304286238401574994e+159, 11, "32427296304", 160},
  {6.8606724695566403915310634e+298, 17, "68606724695566404", 299},
  {5.0796547512980178963641335e-98, 6, "507965", -97},
  {6.9633996607582558603986136e+183, 21, "69633996607582558604", 184},
  {2.5141593090492580000000000e+16, 14, "25141593090493", 17},
  {1.4464689818329799862875331e+183, 2, "14", 184},
  {3.4119461978250122266902018e+120, 10, "3411946198", 121},
  {1.3029264624675639729008571e-222, 21, "13029264624675639729", -221},
  {4.3462788174350915872924512e-215, 6, "434628", -214},
  {2.0656947350344314247151665e-275, 7, "2065695", -274},
  {3.9381545426360209555598132e-19, 21, "393815454263602095556", -18},
  {4.3129936401968714567016833e-208, 5, "4313", -207},
  {1.8255070444770426385072128e+25, 18, "182550704447704264", 26},
  {2.9790111495883243945478834e-248, 2, "3", -247},
  {3.0465343120682351286032569e-25, 20, "30465343120682351286", -24},
  {1.8778782702991139734614408e-110, 18, "187787827029911397", -109},
  {1.2094203251351907465049874e+236, 15, "120942032513519", 237},
  {2.6392327403834628892214535e-36, 1, "3", -35},
  {1.4953108347872205051645392e-67, 6, "149531", -66},
  {5.0648143532110484376370729e+239, 21, "506481435321104843764", 240},
  {6.6534612921243183372132972e+283, 9, "665346129", 284},
  {1.0062737683746191560191173e+34, 6, "100627", 35},
  {2.3284017054410939196802948e-306, 3, "233", -305},
  {1.0135578739053087422794719e-261, 14, "10135578739053", -260},
  {1.5723441108416700022512037e-10, 7, "1572344", -9},
  {9.7667105811829725860096880e+33, 17, "97667105811829726", 34},
  {2.0438934887300194752816324e-191, 10, "2043893489", -190},
  {1.5052745232535903451057902e+38, 6, "150527", 39},
  {8.2977388261953351403476140e+127, 13, "8297738826195", 128},
  {2.4649122993436285858304222e+87, 9, "24649123", 88},
  {1.3053799840579082294497259e-78, 12, "130537998406", -77},
  {2.2296560809312149428495782e+291, 20, "22296560809312149428", 292},
  {3.2548843537081988458624248e-127, 1, "3", -126},
  {4.5311596645226155868160000e+21, 15, "453115966452262", 22},
  {5.5614089703399710018596485e+141, 4, "5561", 142},
  {2.6962992068576736455922992e+131, 10, "2696299207", 132},
  {2.6151846089024145861716266e-76, 7, "2615185", -75},
  {1.9475809882036163902248788e+77, 20, "19475809882036163902", 78},
  {1.3597465564726517018812958e-155, 19, "1359746556472651702", -154},
  {1.5686219302036119277759629e+64, 11, "15686219302", 65},
  {1.8785998678410550651489591e+31, 13, "1878599867841", 32},
  {1.6335630382442167083128262e+51, 8, "1633563", 52},
  {2.6376824976011220534742311e+77, 21, "263768249760112205347", 78},
  {7.2585888713679976232231613e-178, 13, "7258588871368", -177},
  {1.6826210609541765384811137e-96, 7, "1682621", -95},
  {4.9918333465936180706688241e+96, 6, "499183", 97},
  {1.3925408666986809279003040e+209, 10, "1392540867", 210},
  {1.2431435154844590847065238e+118, 20, "12431435154844590847", 119},
  {5.7636723040002724600144610e-177, 1, "6", -176},
  {9.4710314447700465671191268e-293, 3, "947", -292},
  {4.1562139761101103948957773e+185, 4, "4156", 186},
  {7.7103444444896428427358190e-219, 12, "771034444449", -218},
  {5.5314037346281405540430762e+181, 7, "5531404", 182},
  {8.5075981722475563049706950e+213, 8, "85075982", 214},
  {3.8242801869009893375580990e+116, 1, "4", 117},
  {9.1617614097363720703125000e+11, 17, "91617614097363721", 12},
  {4.2475254383638312219846911e-98, 11, "42475254384", -97},
  {1.4168060216288231023000020e+145, 12, "141680602163", 146},
  {5.9132849208330754473717053e+175, 17, "59132849208330754", 176},
  {9.4960486773269040778262551e-66, 13, "9496048677327", -65},
  {2.1409938233786673649755693e-303, 10, "2140993823", -302},
  {2.9926929704916927878529024e+25, 2, "3", 26},
  {2.7779534484925983506024868e+256, 13, "2777953448493", 257},
  {1.3640101799778127520758895e+46, 14, "13640101799778", 47},
  {4.1994530052893885981091235e-71, 19, "4199453005289388598", -70},
  {1.7497459510902761707977493e-178, 17, "17497459510902762", -177},
  {2.1717657782382947553545062e-156, 5, "21718", -155},
  {7.9595541759113035604568601e-202, 9, "795955418", -201},
  {2.4705596534268620380871632e-229, 6, "247056", -228},
  {8.5830130760245713777859469e+301, 2, "86", 302},
  {1.5877536783497946341371402e+161, 5, "15878", 162},
  {1.1832681255873964940909150e+222, 12, "118326812559", 223},
  {9.9264137744436525247332056e+306, 17, "99264137744436525", 307},
  {3.2165370171467521019157982e-157, 14, "32165370171468", -156},
  {4.0709704928233213974003200e-287, 2, "41", -286},
  {9.9050625677324983376996827e-302, 13, "9905062567732", -301},
  {1.7179156781614682589018718e+185, 9, "171791568", 186},
  {1.8080935776433192798191469e+31, 13, "1808093577643", 32},
  {9.0863911670930609563613384e+252, 4, "9086", 253},
  {1.8743189092956781973870020e-276, 6, "187432", -275},
  {1.1567674146105278283398811e-39, 18, "115676741461052783", -38},
  {3.1051562476442142429274516e-48, 9, "310515625", -47},
  {7.8856946299556388046064471e-57, 7, "7885695", -56},
  {1.4568919197642765936215204e-283, 14, "14568919197643", -282},
  {5.7082188777262591341731330e+124, 9, "570821888", 125},
  {3.4273114831454956006138287e-113, 1, "3", -112},
  {1.7291290182773902355930430e+189, 1, "2", 190},
  {1.4720819729108421916819463e-178, 20, "14720819729108421917", -177},
  {1.6076539548885960337249682e+293, 20, "16076539548885960337", 294},
  {9.9998321756250693917621079e-130, 12, "999983217563", -129},
  {3.7462918386331383677428249e-36, 11, "37462918386", -35},
  {1.7575563643917186267104081e-71, 4, "1758", -70},
  {6.3710089714971811117039433e+258, 6, "637101", 259},
  {1.1848312632797419717646229e-280, 15, "118483126327974", -279},
  {8.4596013129308032473199914e-292, 7, "8459601", -291},
  {2.1865609810744743885952948e-38, 16, "2186560981074474", -37},
  {1.2067055334324610569520887e-16, 20, "1206705533432461057", -15},
  {2.6668874432927010226405705e+233, 9, "266688744", 234},
  {2.2595023612775562044444864e+205, 11, "22595023613", 206},
  {1.0232757118696465687932351e+272, 1, "1", 273},
  {1.7919552039111519341009423e+76, 4, "1792", 77},
  {4.0221563492752374214271684e+305, 4, "4022", 306},
  {2.2622914371419279784876225e+80, 1, "2", 81},
  {2.0042803230578955410550264e-222, 14, "20042803230579", -221},
  {9.1546156016897233624750887e-216, 14, "91546156016897", -215},
  {1.1242157706303839523356228e+208, 9, "112421577", 209},
  {7.0809024918244873063867026e-214, 19, "7080902491824487306", -213},
  {8.5333093744883720521141769e+46, 2, "85", 47},
  {4.0590551612589560038519472e+79, 18, "4059055161258956", 80},
  {1.9048289616554897569027388e+162, 11, "19048289617", 163},
  {3.4718181625156079218019141e-281, 19, "3471818162515607922", -280},
  {3.0866573730523476961439987e-43, 3, "309", -42},
  {6.4924553157055206494995609e-155, 17, "64924553157055206", -154},
  {7.5145016206604421256574551e-121, 16, "7514501620660442", -120},
  {5.4288729149831303094298200e-286, 12, "542887291498", -285},
  {1.9620016710775785069871529e-146, 20, "1962001671077578507", -145},
  {1.7762601413317921338687482e+113, 21, "177626014133179213387", 114},
  {9.4610399424824689583964392e+97, 5, "9461", 98},
  {7.5777504456706131537341547e-299, 19, "7577750445670613154", -298},
  {3.8112239401701021712448708e+101, 1, "4", 102},
  {2.1568344157035110645108608e+113, 1, "2", 114},
  {4.9103925491967078048073470e+82, 15, "491039254919671", 83},
  {1.2750756701411756173797607e-275, 12, "127507567014", -274},
  {1.0691178581142753832356025e+176, 3, "107", 177},
  {5.4315230088792199987596921e+82, 9, "543152301", 83},
  {2.8268134234861566865443833e-176, 16, "2826813423486157", -175},
  {7.7956492092340976795443783e-46, 20, "77956492092340976795", -45},
  {7.4887133411395639184744460e+102, 21, "748871334113956391847", 103},
  {7.6285952465644225299838405e+260, 16, "7628595246564423", 261},
  {5.1421770435100654968422033e+230, 7, "5142177", 231},
  {1.3400478144300323798304210e-42, 4, "134", -41},
  {2.9019895587813899909613505e+221, 14, "29019895587814", 222},
  {1.8453614152542546971737812e+68, 6, "184536", 69},
  {6.7918562639532869488582040e-236, 18, "679185626395328695", -235},
  {3.0283087243740315352770057e+102, 21, "302830872437403153528", 103},
  {5.7351805538156081591242284e-201, 19, "5735180553815608159", -200},
  {1.1804902211780913867758572e-103, 18, "118049022117809139", -102},
  {2.6660349220911079080211445e+241, 17, "26660349220911079", 242},
  {3.0794690571340090424667511e-201, 10, "3079469057", -200},
  {8.8761461550619088988181937e+64, 3, "888", 65},
  {2.5636157333235320302531517e+294, 16, "2563615733323532", 295},
  {1.9586628146544066385946655e-294, 14, "19586628146544", -293},
  {1.0133505518824051623848327e-247, 1, "1", -246},
  {9.4894528376544956699945033e+04, 1, "9", 5},
  {7.9188078237460139163852839e-212, 3, "792", -211},
  {3.0567327977286712347549737e+214, 21, "305673279772867123475", 215},
  {1.5583048583122261298124675e+171, 15, "155830485831223", 172},
  {3.8358562217514257956877672e+241, 6, "383586", 242},
  {3.3414023163357815714765293e+252, 3, "334", 253},
  {6.3185446329547858568073724e-115, 3, "632", -114},
  {1.7585377230916779650170104e-263, 19, "1758537723091677965", -262},
  {1.4342371628906194470138868e+156, 11, "14342371629", 157},
  {2.5297673627814694670096449e+184, 2, "25", 185},
  {4.3635587003084891077936986e+58, 6, "436356", 59},
  {4.5242168411909310575870114e+210, 9, "452421684", 211},
  {1.3414706493892597034573555e+07, 12, "134147064939", 8},
  {2.5606362207630260895441597e-307, 11, "25606362208", -306},
  {2.6423539966342404178039991e-137, 10, "2642353997", -136},
  {3.9585276160733082038511575e-265, 18, "39585276160733082", -264},
  {4.6464617278371547415014882e-179, 3, "465", -178},
  {4.1450869967732858667822655e+202, 6, "414509", 203},
  {1.5962467879601676112124966e-82, 14, "15962467879602", -81},
  {3.8211509781673309878984914e-270, 9, "382115098", -269},
  {9.5068304495341388974338770e+05, 16, "9506830449534139", 6},
  {3.7807789143537045978217988e-149, 7, "3780779", -148},
  {1.6117338151790587314810704e+207, 18, "161173381517905873", 208},
  {3.7745260080529988456946270e+104, 7, "3774526", 105},
  {2.6370581356613871546020825e+95, 16, "2637058135661387", 96},
  {2.1625329171678117209216161e+77, 16, "2162532917167812", 78},
  {3.9784877991583017044809644e+124, 2, "4", 125},
  {6.5682939878058140243991860e+97, 21, "65682939878058140244", 98},
  {1.3926803447207254625974453e+289, 13, "1392680344721", 290},
  {1.1790237045160562804479111e-42, 13, "1179023704516", -41},
  {8.6560097704759363009513788e+140, 3, "866", 141},
  {7.5874026731483361800201237e+04, 18, "758740267314833618", 5},
  {2.4207938511035407027789949e+117, 12, "24207938511", 118},
  {2.2515634823799955723314295e-305, 4, "2252", -304},
  {1.8922299304674250945154418e+93, 10, "189222993", 94},
  {2.6546950404499557126526188e+85, 2, "27", 86},
  {6.6100526163388628609107779e-10, 17, "66100526163388629", -9},
  {2.2693938961064724352501943e-57, 7, "2269394", -56},
  {1.9486595141986894329067920e-245, 11, "19486595142", -244},
  {6.6778430540441618244756476e+213, 10, "6677843054", 214},
  {1.1399271743207119540039665e-83, 2, "11", -82},
  {3.8859186541796051329086034e+195, 6, "388592", 196},
  {2.0168261094374584310966538e+281, 7, "2016826", 282},
  {3.0135571718031740903192794e+169, 8, "30135572", 170},
  {2.6917881744946228263031413e-24, 5, "26918", -23},
  {1.2057419724313366749967822e+188, 15, "120574197243134", 189},
  {2.7576148560700088765782818e+138, 5, "27576", 139},
  {5.1926175733557219699897044e-228, 6, "519262", -227},
  {3.0890633117143934169326398e-21, 8, "30890633", -20},
  {4.5628181200282092930925757e-116, 16, "4562818120028209", -115},
  {7.4778004406383949842717897e+133, 21, "747780044063839498427", 134},
  {3.2729532708008013677218936e+229, 12, "32729532708", 230},
  {5.4637135708083045928269235e-23, 7, "5463714", -22},
  {3.6077510247715014268176627e-253, 6, "360775", -252},
  {1.0090296852457639507094878e+271, 8, "10090297", 272},
  {1.1131720604745534683523828e+167, 15, "111317206047455", 168},
  {4.9855851102099677306869132e-11, 1, "5", -10},
  {2.1601387034353327216031796e-136, 12, "216013870344", -135},
  {1.5044842190116180711643323e-193, 3, "15", -192},
  {8.5253364282136193198373201e+68, 21, "852533642821361931984", 69},
  {1.3849934339083350315470105e-150, 3, "138", -149},
  {7.9355587434582707110027648e+87, 3, "794", 88},
  {7.0902245230967957984688844e+58, 11, "70902245231", 59},
  {1.3898567601749179488010240e+24, 8, "13898568", 25},
  {2.6756387384166078334111077e-248, 17, "26756387384166078", -247},
  {7.8346095761851646075007385e+196, 13, "7834609576185", 197},
  {1.4411943504492536084085378e+213, 20, "14411943504492536084", 214},
  {1.4720362822043954015426082e+138, 20, "14720362822043954015", 139},
  {5.4636309861837795075847018e-174, 20, "54636309861837795076", -173},
  {1.6199654001709027290574167e-70, 21, "161996540017090272906", -69},
  {5.3744748127377760410308838e+08, 13, "5374474812738", 9},
  {2.2900750768549503942746634e-38, 17, "22900750768549504", -37},
  {7.3644284547682228863897605e+67, 2, "74", 68},
  {4.8418324927408863772506141e+91, 11, "48418324927", 92},
  {1.3738232696436550982663927e-288, 6, "137382", -287},
  {3.9064199679287857311014857e-152, 11, "39064199679", -151},
  {8.4551355903279887076556800e+23, 8, "84551356", 24},
  {1.4481419363292075738757497e-53, 18, "144814193632920757", -52},
  {2.2511711213009557626600282e-302, 1, "2", -301},
  {2.8196176113805110013147852e+171, 19, "2819617611380511001", 172},
  {5.5365687333858995114765320e-37, 17, "55365687333858995", -36},
  {8.3071485342741208576349588e+108, 10, "8307148534", 109},
  {1.4492086870482614640723024e+107, 20, "14492086870482614641", 108},
  {1.0068857877297022200529892e-171, 4, "1007", -170},
  {2.8107831919549937340420593e-145, 11, "2810783192", -144},
  {2.6322991026583195161849517e-278, 18, "263229910265831952", -277},
  {1.5048771877562452925132831e+34, 21, "150487718775624529251", 35},
  {1.4022292969199712371526580e+127, 17, "14022292969199712", 128},
  {3.1102937584169136684529341e-58, 3, "311", -57},
  {7.3166280279540158777959937e+56, 2, "73", 57},
  {1.3013433770496429669464005e-43, 7, "1301343", -42},
  {5.6680060697314212216341634e+98, 4, "5668", 99},
  {4.4322503594011515872491300e+302, 17, "44322503594011516", 303},
  {3.8248227031937268863536883e+147, 1, "4", 148},
  {5.3889163176071768378069736e-145, 21, "538891631760717683781", -144},
  {4.3696443110739800567626806e+55, 9, "436964431", 56},
  {6.8075916130873477817041198e+294, 1, "7", 295},
  {3.3042131551609610411918775e-22, 9, "330421316", -21},
  {1.9006335423022364155023769e-241, 17, "19006335423022364", -240},
  {2.0539994983765792711970491e+107, 4, "2054", 108},
  {1.6839691967556122760510626e+172, 13, "1683969196756", 173},
  {1.0567637280296890842872430e+284, 10, "1056763728", 285},
  {6.8216125370072702976000000e+19, 13, "6821612537007", 20},
  {3.8465133429345147139804193e+224, 20, "3846513342934514714", 225},
  {1.7778489112968417196899679e+75, 19, "177784891129684172", 76},
  {6.1913581400767478315344539e-04, 4, "6191", -3},
  {1.2021562938663682914370875e-224, 5, "12022", -223},
  {1.2634849050224790536185292e-302, 18, "126348490502247905", -301},
  {4.7989464915276564206181172e-268, 11, "47989464915", -267},
  {1.8382631128975944608792701e+244, 18, "183826311289759446", 245},
  {7.9280369625903748558204236e+98, 16, "7928036962590375", 99},
  {5.5420431718967968994632499e+134, 20, "55420431718967968995", 135},
  {1.1435473532801763873717038e+226, 12, "114354735328", 227},
  {5.3467619697550748483989599e+233, 7, "5346762", 234},
  {6.7335317424494576222301078e+235, 5, "67335", 236},
  {1.3285093007273002916412389e-72, 14, "13285093007273", -71},
  {9.8777362469646712003741060e-134, 11, "9877736247", -133},
  {5.2607729874769486072004341e+190, 19, "5260772987476948607", 191},
  {2.0715550888126024054829023e-160, 6, "207156", -159},
  {8.6079835987725824521596775e-228, 11, "86079835988", -227},
  {1.5303222114262089482866256e+153, 15, "153032221142621", 154},
  {4.3049332265800192872449377e-82, 2, "43", -81},
  {2.0623317599544600145417059e-247, 13, "2062331759954", -246},
  {1.2818158424519739897252064e+81, 19, "128181584245197399", 82},
  {9.9712972346301884899568875e+254, 12, "997129723463", 255},
  {3.7574293270136483396368598e-52, 21, "375742932701364833964", -51},
  {5.2878257430688897137583988e-275, 13, "5287825743069", -274},
  {8.0751616398970080144846238e+62, 21, "807516163989700801448", 63},
  {2.8963721355011476800971039e+103, 3, "29", 104},
  {1.7786224871629820979583924e-15, 19, "1778622487162982098", -14},
  {5.9410770764070509000648886e-214, 21, "594107707640705090006", -213},
  {8.1285757583872353390867472e+279, 21, "812857575838723533909", 280},
  {4.7773723213303043115037530e+74, 19, "4777372321330304312", 75},
  {1.4641364981100716032000000e+19, 9, "14641365", 20},
  {9.5821265653689392000000000e+16, 19, "95821265653689392", 17},
  {9.2989388741872560890293492e-273, 12, "929893887419", -272},
  {3.1165853799704157751609548e+172, 16, "3116585379970416", 173},
  {2.4833969055635232236153088e-271, 11, "24833969056", -270},
  {2.8300735020454737740599638e-124, 9, "28300735", -123},
  {1.0645624295895672961984571e-264, 12, "106456242959", -263},
  {9.1208380013895031113909005e+238, 19, "9120838001389503111", 239},
  {3.0532004272977346332120171e-287, 18, "305320042729773463", -286},
  {1.3920010493529980583701929e-241, 18, "139200104935299806", -240},
  {3.7288175707332409112317089e+51, 15, "372881757073324", 52},
  {2.9595146200507992575010655e+300, 1, "3", 301},
  {3.8811984403885762371273104e-09, 21, "388119844038857623713", -8},
  {4.0937041277661148535813433e+259, 19, "4093704127766114854", 260},
  {2.0821419880771982972545752e-43, 16, "2082141988077198", -42},
  {2.1903277014375588937319604e-223, 2, "22", -222},
  {1.9442359639959240371954161e-236, 8, "1944236", -235},
  {8.5147963418926309628899842e+127, 16, "8514796341892631", 128},
  {5.8101214732047818444041403e+110, 17, "58101214732047818", 111},
  {2.6960502818760291316858060e+42, 3, "27", 43},
  {3.3408092043708700541072769e-172, 7, "3340809", -171},
  {6.8957024877465721386449090e-80, 16, "6895702487746572", -79},
  {3.3190847993345491808492515e+90, 19, "3319084799334549181", 91},
  {2.8081608335737887276405874e+51, 21, "280816083357378872764", 52},
  {4.9315910284716848481401659e+306, 16, "4931591028471685", 307},
  {2.0950380927878097692585747e-307, 19, "2095038092787809769", -306},
  {5.0832580373501126073968986e-112, 19, "5083258037350112607", -111},
  {8.5515609564149226593274850e-142, 18, "855156095641492266", -141},
  {6.2829147678217166152884018e+121, 15, "628291476782172", 122},
  {3.0859998483218792544382744e-102, 8, "30859998", -101},
  {8.9003040639539991696012783e+279, 5, "89003", 280},
  {5.0742306585166068629711353e-48, 12, "507423065852", -47},
  {2.4843398590382750859487397e+175, 13, "2484339859038", 176},
  {6.4594415248900398044975440e-99, 20, "64594415248900398045", -98},
  {1.1831376198827624807377885e-117, 15, "118313761988276", -116},
  {4.9152603011906804303724923e+128, 19, "491526030119068043", 129},
  {1.0902582437749251718988387e-268, 9, "109025824", -267},
  {2.1351880343296334638057689e-203, 11, "21351880343", -202},
  {3.4871064957129601283050348e+242, 3, "349", 243},
  {3.6336378208074586941058702e-168, 14, "36336378208075", -167},
  {7.1840862461988330429223444e+74, 5, "71841", 75},
  {4.5253385574570075219721813e+176, 6, "452534", 177},
  {1.4128993435008391181478059e-149, 5, "14129", -148},
  {2.8764488841975817808285080e-165, 11, "28764488842", -164},
  {5.1918997045556567153491963e+280, 4, "5192", 281},
  {2.3372218492403202564740139e-50, 6, "233722", -49},
  {2.5504748848472922606120477e-132, 21, "255047488484729226061", -131},
  {2.8531018049473156654315891e-300, 12, "285310180495", -299},
  {5.2118683322657066860033315e-182, 1, "5", -181},
  {2.0133754101051213467134361e-120, 20, "20133754101051213467", -119},
  {1.7088873351790380000405422e-288, 4, "1709", -287},
  {1.1628655293892451784080327e-79, 2, "12", -78},
  {2.6020385472280184745258361e-222, 7, "2602039", -221},
  {2.1526538254589653778699597e+102, 4, "2153", 103},
  {2.3568171623580506760365500e-299, 4, "2357", -298},
  {1.8610627138078199034052483e-229, 3, "186", -228},
  {5.7352440480324205388473210e-53, 9, "573524405", -52},
  {2.0905185341767979241074722e+77, 2, "21", 78},
  {6.9722484799864923662253052e-158, 18, "697224847998649237", -157},
  {1.9163714547582438852400114e+216, 1, "2", 217},
  {3.0743419740311649874102624e-159, 10, "3074341974", -158},
  {1.0335991397780799973494958e-85, 15, "103359913977808", -84},
  {3.3969210134633977746531399e+90, 12, "339692101346", 91},
  {2.4181486373823821625528994e+263, 18, "241814863738238216", 264},
  {5.4016207896046599133079057e+183, 11, "54016207896", 184},
  {4.4319833399874014312453459e-72, 1, "4", -71},
  {5.7743841529199613848426906e+26, 6, "577438", 27},
  {6.9318368539712349188913864e+45, 17, "69318368539712349", 46},
  {5.2210353737874666016639628e+72, 6, "522104", 73},
  {3.8815514549045517928903837e-41, 10, "3881551455", -40},
  {1.5585567265344743025439155e-11, 9, "155855673", -10},
  {8.7010638996789673742456863e+156, 11, "87010638997", 157},
  {4.1319607479213806508357131e-266, 5, "4132", -265},
  {5.5986871310688650330427732e+85, 9, "559868713", 86},
  {2.4520153858146915348820325e-278, 13, "2452015385815", -277},
  {2.9070191560294020534660812e-255, 14, "29070191560294", -254},
  {3.4510953631631924309886017e-02, 5, "34511", -1},
  {3.7950788011051709108479426e-09, 3, "38", -8},
  {4.9607855186448883659542720e+163, 2, "5", 164},
  {9.5612129592254479850955342e-278, 3, "956", -277},
  {2.8704283964990229861215986e+64, 3, "287", 65},
  {4.1410176985759673111138857e-225, 13, "4141017698576", -224},
  {3.0445903266508215129203479e-250, 1, "3", -249},
  {1.5930250305159561438490748e-78, 8, "1593025", -77},
  {2.1839461001814859225477229e+254, 18, "218394610018148592", 255},
  {8.7498666848864078332428288e+26, 15, "874986668488641", 27},
  {6.8344441150330511428338543e+278, 14, "68344441150331", 279},
  {2.5932346030767924185486479e-264, 20, "25932346030767924185", -263},
  {1.3324216454327144315818801e+240, 10, "1332421645", 241},
  {2.4937490914374512774885858e-114, 12, "249374909144", -113},
  {3.9909905701142110451346146e+180, 14, "39909905701142", 181},
  {1.8313510707183686280235992e-208, 4, "1831", -207},
  {7.8461912800183098593242946e-61, 5, "78462", -60},
  {6.9907291366904488011706964e+91, 14, "69907291366904", 92},
  {4.7275995577939773065547602e+288, 1, "5", 289},
  {1.2683421329574492685105836e-168, 11, "1268342133", -167},
  {3.3356398300689572121113476e-07, 18, "333563983006895721", -6},
  {1.8401549984784680054123698e+97, 6, "184015", 98},
  {2.0576954413553098458068211e+48, 18, "205769544135530985", 49},
  {2.3115181417491761343961662e-138, 18, "231151814174917613", -137},
  {2.8689690263949444332177381e-145, 21, "286896902639494443322", -144},
  {6.5368416948106765991186040e-05, 11, "65368416948", -4},
  {1.0688256995473966998689735e+216, 21, "106882569954739669987", 217},
  {1.5121219380327973216819638e+229, 1, "2", 230},
  {1.4797211869398437470952193e+189, 17, "14797211869398437", 190},
  {3.4975288312249723447110965e-272, 15, "349752883122497", -271},
  {3.1291938438963392718541488e-108, 12, "31291938439", -107},
  {7.3245612948043299245556231e-12, 11, "73245612948", -11},
  {5.5940578816062296401624273e+232, 17, "55940578816062296", 233},
  {6.5233044806190295043504547e-15, 5, "65233", -14},
  {7.1255981235439095412465784e-114, 4, "7126", -113},
  {2.3420655297333066180164401e-151, 10, "234206553", -150},
  {4.1386840357130726218715298e-305, 17, "41386840357130726", -304},
  {8.8676044346162192761346664e+243, 21, "886760443461621927613", 244},
  {5.3989756389329200972952143e-57, 6, "539898", -56},
  {3.1659557266251051214590533e-21, 1, "3", -20},
  {1.3484544954887288819923310e+218, 3, "135", 219},
  {1.1821949124612481814693076e-153, 1, "1", -152},
  {1.9897070465445852314905950e-218, 8, "1989707", -217},
  {7.6659585549949653195382342e+70, 13, "7665958554995", 71},
  {4.4718284269527721563210284e+176, 4, "4472", 177},
  {7.8516990565103089871999962e+68, 14, "78516990565103", 69},
  {2.1489003836398866180692763e+307, 9, "214890038", 308},
  {7.5432922199347191332596571e-194, 4, "7543", -193},
  {3.9737387689658256809474384e+155, 17, "39737387689658257", 156},
  {3.9832038392406340319804380e-85, 9, "398320384", -84},
  {3.9189663724159352340818504e+125, 14, "39189663724159", 126},
  {3.9163847891433186691680555e+102, 17, "39163847891433187", 103},
  {4.0233937476447147359239992e-43, 4, "4023", -42},
  {3.9657214872124068134494130e-97, 20, "39657214872124068134", -96},
  {6.1714398857767466721065029e-178, 20, "61714398857767466721", -177},
  {1.7925744751793416446457376e+176, 14, "17925744751793", 177},
  {1.0381702422854430163249703e+245, 11, "10381702423", 246},
  {5.7009933916319750592538767e+216, 2, "57", 217},
  {2.8787887811875962694657791e+156, 9, "287878878", 157},
  {6.0023507610119808840250109e-123, 9, "600235076", -122},
  {3.3335808896344476273030995e+272, 16, "3333580889634448", 273},
  {1.9554121371957517354762437e+42, 3, "196", 43},
  {7.6932712941071210054278905e-137, 15, "769327129410712", -136},
  {1.0613513692507298189338873e-266, 18, "106135136925072982", -265},
  {1.5477021283944699890704719e+233, 7, "1547702", 234},
  {2.5809151111256257258603936e+252, 12, "258091511113", 253},
  {1.2058800590535673168011694e+242, 2, "12", 243},
  {2.0672926462531297740037369e+258, 10, "2067292646", 259},
  {1.5838289248560937969606606e+153, 10, "1583828925", 154},
  {1.6921243177321349713634268e+92, 2, "17", 93},
  {1.6159186378678243405893725e-35, 13, "1615918637868", -34},
  {1.4804104995051689933180024e+242, 14, "14804104995052", 243},
  {6.0975943867023735517114085e+237, 16, "6097594386702374", 238},
  {3.8099784984363945646227858e-32, 15, "380997849843639", -31},
  {7.4384288040092215141745345e+222, 10, "7438428804", 223},
  {1.1692289193551549972961655e-158, 7, "1169229", -157},
  {4.2015655717019494628906250e+11, 1, "4", 12},
  {1.8318382832498053891953945e+286, 21, "18318382832498053892", 287},
  {2.3399791158745002170744667e+243, 1, "2", 244},
  {2.6723266306492000432812209e-48, 8, "26723266", -47},
  {1.5987588922914075141726068e-300, 9, "159875889", -299},
  {3.0490343509765922109275846e+50, 17, "30490343509765922", 51},
  {1.4178034440084954803911503e+246, 14, "14178034440085", 247},
  {7.9476951650953141619054833e+231, 2, "79", 232},
  {9.2082540819822581407831005e-35, 20, "92082540819822581408", -34},
  {5.5153055294078509267676564e-145, 12, "551530552941", -144},
  {7.8074101474902911830198592e-42, 9, "780741015", -41},
  {2.7356950864552499803633647e-62, 16, "273569508645525", -61},
  {2.8731644760019707061746151e-111, 7, "2873164", -110},
  {2.4438753670466394691668292e-113, 17, "24438753670466395", -112},
  {2.2137362028527625119880490e-191, 7, "2213736", -190},
  {1.3076812030040684236684209e+194, 17, "13076812030040684", 195},
  {2.8172510483188233593829081e-70, 5, "28173", -69},
  {2.1138817175368529479883656e+91, 1, "2", 92},
  {3.4550844132584715098432809e+65, 19, "345508441325847151", 66},
  {8.2022780147155549870307051e+163, 10, "8202278015", 164},
  {5.3071347132327742575278276e+203, 19, "5307134713232774258", 204},
  {1.1371634275899463243725641e-45, 16, "1137163427589946", -44},
  {7.3028407812841560436985137e-197, 14, "73028407812842", -196},
  {8.4400877725710386695234959e-256, 20, "84400877725710386695", -255},
  {1.2320873758504443580538945e-263, 10, "1232087376", -262},
  {9.5648954977919678878277321e+262, 10, "9564895498", 263},
  {1.9833610579504207752578815e-256, 14, "19833610579504", -255},
  {1.8324265566043050404379506e+202, 21, "183242655660430504044", 203},
  {2.0876117237325311500524511e+55, 3, "209", 56},
  {2.8386314745692272283833337e+212, 10, "2838631475", 213},
  {1.0348591745590309760763495e-135, 7, "1034859", -134},
  {1.0590523516938206907655062e-290, 11, "10590523517", -289},
  {6.6657148752805587816561721e+125, 15, "666571487528056", 126},
  {2.0778469445076269674909406e-244, 20, "20778469445076269675", -243},
  {2.6355293511716639856431041e+82, 6, "263553", 83},
  {2.8602362957529456634053099e-270, 13, "2860236295753", -269},
  {1.6023132317382250262801334e+69, 15, "160231323173823", 70},
  {8.7609509468926749128259077e-13, 12, "876095094689", -12},
  {1.1444261795382181212262646e+259, 14, "11444261795382", 260},
  {3.6420235651778676959060023e+196, 8, "36420236", 197},
  {4.8191830175078748861635538e+176, 15, "481918301750787", 177},
  {1.4973732578402882880039507e-171, 6, "149737", -170},
  {1.1338773501713699107731144e-139, 15, "113387735017137", -138},
  {3.7169215425258116648561856e+197, 14, "37169215425258", 198},
  {2.0130404326281222866308454e-236, 4, "2013", -235},
  {2.7334366525417363217882576e-70, 18, "273343665254173632", -69},
  {5.9747305610936471964578232e+01, 21, "597473056109364719646", 2},
  {5.3981359465978223911690923e-243, 2, "54", -242},
  {1.1337925465235741554969866e-124, 20, "11337925465235741555", -123},
  {8.2746575901214021534083666e+154, 5, "82747", 155},
  {1.2160243208730717483326289e+104, 19, "1216024320873071748", 105},
  {2.9191516613102450584206760e+129, 21, "291915166131024505842", 130},
  {8.0882580196403818130493164e+09, 13, "808825801964", 10},
  {3.5696928992659023372240836e-17, 19, "3569692899265902337", -16},
  {3.2312129853424803097344204e+136, 13, "3231212985342", 137},
  {4.8688679124122191558376706e-36, 18, "486886791241221916", -35},
  {5.0613780226411156644296726e-291, 16, "5061378022641116", -290},
  {1.1861325725821598557681835e+48, 17, "11861325725821599", 49},
  {5.5362903052671821748895744e+25, 4, "5536", 26},
  {3.6578121498609863609936323e-251, 20, "3657812149860986361", -250},
  {1.0023093822706120458221542e+88, 7, "1002309", 89},
  {4.1481187147461492396444652e-110, 13, "4148118714746", -109},
  {1.3394887950758230525875716e+219, 13, "1339488795076", 220},
  {5.3632372785504832904504184e+254, 14, "53632372785505", 255},
  {3.4678322910935413202438517e+296, 4, "3468", 297},
  {2.0362056849222732986228090e+280, 19, "2036205684922273299", 281},
  {9.9539061283982355464387380e+107, 20, "99539061283982355464", 108},
  {6.6299162567286443622276656e+132, 6, "662992", 133},
  {5.6146563871756907601178808e+289, 8, "56146564", 290},
  {5.6901695764203611458134202e+302, 4, "569", 303},
  {1.0398273083789229567060105e+215, 3, "104", 216},
  {2.3958002138556275168461160e+164, 11, "23958002139", 165},
  {2.1410053310001303220667289e+240, 13, "2141005331", 241},
  {8.4773833324719349964283615e-142, 9, "847738333", -141},
  {4.3335276256953792684387504e+278, 7, "4333528", 279},
  {3.3337529113023737836375234e-115, 3, "333", -114},
  {3.0954220897230680306980547e+113, 4, "3095", 114},
  {3.5349883170104929959002812e-26, 20, "35349883170104929959", -25},
  {1.0352643242089548725233239e+144, 3, "104", 145},
  {1.1541682054872555555312843e+53, 21, "115416820548725555553", 54},
  {3.4943691995356096621287795e-272, 5, "34944", -271},
  {2.2357272501658569734856226e+152, 7, "2235727", 153},
  {2.4995601668949466818804957e+82, 21, "249956016689494668188", 83},
  {1.2700328971097763994004174e+156, 2, "13", 157},
  {2.8404803512669914503097068e-03, 16, "2840480351266991", -2},
  {3.2950197305725192810134404e+192, 3, "33", 193},
  {6.4259184550375175793345008e+253, 12, "642591845504", 254},
  {2.9682375621423681175846640e+284, 13, "2968237562142", 285},
  {1.5076460041363864692879138e-146, 7, "1507646", -145},
  {1.8070598001057972122085816e-113, 14, "18070598001058", -112},
  {3.8690079242432198989126089e-264, 11, "38690079242", -263},
  {5.9234894493342042333533401e-241, 11, "59234894493", -240},
  {1.5967595799220725000000000e+15, 14, "15967595799221", 16},
  {1.5018771670194966864801872e-173, 5, "15019", -172},
  {6.8555419369949847275590573e+154, 8, "68555419", 155},
  {8.6419669625757433503130853e-111, 3, "864", -110},
  {8.0115778055424301445718133e+161, 12, "801157780554", 162},
  {1.6775769283109452724456787e+09, 18, "167757692831094527", 10},
  {2.9455510082458301090672370e+197, 10, "2945551008", 198},
  {1.9834536281792938243597746e+06, 12, "198345362818", 7},
  {5.0352095624618835512647996e+185, 8, "50352096", 186},
  {1.4289639647043940518947677e-180, 3, "143", -179},
  {1.3054210430227089260764524e+241, 9, "130542104", 242},
  {1.3045091042943692611352772e+265, 9, "13045091", 266},
  {1.8528443215571093493971530e-270, 10, "1852844322", -269},
  {8.6860765991727460196305623e-202, 17, "8686076599172746", -201},
  {4.0237783857396173089579956e-38, 10, "4023778386", -37},
  {2.5420893347320038865762331e-79, 1, "3", -78},
  {3.1932390283657728051605579e-254, 21, "319323902836577280516", -253},
  {8.3351483289294068948212642e+295, 10, "8335148329", 296},
  {3.4676551697940490096094116e-307, 18, "346765516979404901", -306},
  {2.8466078912116974090488626e+250, 10, "2846607891", 251},
  {2.5531803616562539963065777e-80, 6, "255318", -79},
  {1.7452976852889788694573089e+28, 17, "17452976852889789", 29},
  {1.2893086802245675029335952e+113, 16, "1289308680224568", 114},
  {7.1295870227459253964847087e-73, 14, "71295870227459", -72},
  {2.1958165875122922262204961e+303, 20, "21958165875122922262", 304},
  {1.0781393595760363562281149e+167, 16, "1078139359576036", 168},
  {3.7417206772380411660067314e+218, 7, "3741721", 219},
  {4.2111351187876430592340298e+135, 12, "421113511879", 136},
  {2.6892037183371565521178703e+121, 16, "2689203718337157", 122},
  {9.1551939328725540814356695e+284, 21, "915519393287255408144", 285},
  {5.8092290269216428515953617e+168, 16, "5809229026921643", 169},
  {4.8831352270068737875448734e-65, 20, "48831352270068737875", -64},
  {1.2977848518112536970749190e-20, 14, "12977848518113", -19},
  {9.0345196150963525705698762e-74, 14, "90345196150964", -73},
  {7.2277792355863816911549840e+275, 16, "7227779235586382", 276},
  {4.2554267245411393228312560e-250, 10, "4255426725", -249},
  {4.4167200586765093415933994e-105, 13, "4416720058677", -104},
  {3.9983364554744665527343750e+11, 13, "3998336455474", 12},
  {1.7752946491505207097208157e+84, 17, "17752946491505207", 85},
  {1.5903734954420439606792570e+01, 15, "159037349544204", 2},
  {1.3253605659174377399242638e-305, 13, "1325360565917", -304},
  {4.2166085477868888626475778e+220, 20, "42166085477868888626", 221},
  {8.5130829178227770994167224e+249, 12, "851308291782", 250},
  {6.7150073204642903979368052e-163, 5, "6715", -162},
  {1.2480203522416693834094152e-34, 18, "124802035224166938", -33},
  {8.0036135126657435813607706e-137, 12, "800361351267", -136},
  {6.7847527829859630010990805e-143, 11, "6784752783", -142},
  {1.1010300884269659350494992e+301, 11, "11010300884", 302},
  {7.6255670249341985039870195e-239, 1, "8", -238},
  {3.1133249038071909692439061e+279, 5, "31133", 280},
  {7.5789310869903896653901971e+143, 10, "7578931087", 144},
  {2.1123065367327623481033078e-153, 1, "2", -152},
  {7.1647530752189824967665476e-298, 10, "7164753075", -297},
  {2.5544153700781801647933124e+207, 17, "25544153700781802", 208},
  {4.4738531427122645790911851e+190, 4, "4474", 191},
  {3.1880242262224205638977035e-34, 21, "31880242262224205639", -33},
  {5.5302039838048438022225216e-166, 4, "553", -165},
  {2.0612418807652983885021298e-165, 18, "206124188076529839", -164},
  {3.5984318146752125585121029e+246, 12, "359843181468", 247},
  {7.7978191936979642351616000e+22, 2, "78", 23},
  {5.1401593752743737274799136e+86, 14, "51401593752744", 87},
  {5.6080236859613368222407065e+32, 6, "560802", 33},
  {4.4822258353983785792504398e-11, 20, "44822258353983785793", -10},
  {2.1970805740788177038984037e+100, 1, "2", 101},
  {3.1760052025819296035517275e+91, 12, "317600520258", 92},
  {1.3408057627287712596170964e-97, 18, "134080576272877126", -96},
  {3.8138752014524855613708496e+09, 5, "38139", 10},
  {2.2474560231608599027244822e-302, 21, "224745602316085990272", -301},
  {8.6451494666302933657851210e-86, 16, "8645149466630293", -85},
  {1.3557570597865547489881444e-40, 9, "135575706", -39},
  {5.6952597068815343193474475e+273, 4, "5695", 274},
  {1.7837966898764458501670098e+85, 1, "2", 86},
  {6.5450353763775103464920286e-185, 4, "6545", -184},
  {2.5065707037330253006180297e-137, 17, "25065707037330253", -136},
  {3.1631416579951481938468869e+117, 19, "3163141657995148194", 118},
  {1.9824096981989705901294326e+107, 6, "198241", 108},
  {1.4271318296789773801658789e-116, 9, "142713183", -115},
  {1.2605379228825834958733118e-200, 21, "126053792288258349587", -199},
  {2.5768251163697460744821670e-237, 2, "26", -236},
  {5.6717996861104007939795098e+285, 11, "56717996861", 286},
  {9.1215285997522824006089603e-05, 2, "91", -4},
  {1.8695444216991665715683291e+228, 4, "187", 229},
  {3.4479965792842945316982116e-250, 13, "3447996579284", -249},
  {9.0364394474468954107488444e+139, 19, "9036439447446895411", 140},
  {9.0741816463898051314726374e-211, 3, "907", -210},
  {5.7940656790525741562589609e+265, 8, "57940657", 266},
  {5.3384689127468866969257567e+199, 4, "5338", 200},
  {9.5846826313921486676614437e-146, 7, "9584683", -145},
  {3.2693058182819560546875000e+12, 15, "326930581828196", 13},
  {3.4475703086859473778462082e-65, 16, "3447570308685947", -64},
  {4.0058206731549660602483125e+108, 6, "400582", 109},
  {2.2183168266278353949229838e-288, 20, "22183168266278353949", -287},
  {5.1647801451744161279689614e+230, 1, "5", 231},
  {3.2092639291536701359089413e+278, 20, "32092639291536701359", 279},
  {3.2765482100854440294541259e-212, 1, "3", -211},
  {6.9072404751062253159845821e+136, 8, "69072405", 137},
  {1.1064883890021031680169948e-138, 4, "1106", -137},
  {1.5540859535975819681396471e-140, 13, "1554085953598", -139},
  {3.5160094090769322690789967e-112, 10, "3516009409", -111},
  {1.1048632397554043204451728e-12, 2, "11", -11},
  {4.1568001541321314526655925e+94, 4, "4157", 95},
  {5.7600329896928943186533764e+228, 12, "576003298969", 229},
  {2.0196328437977991632659756e-127, 5, "20196", -126},
  {2.4905694574209891457137239e+279, 14, "2490569457421", 280},
  {5.0278609895311058938223349e-34, 2, "5", -33},
  {4.1091221256871714107043120e-167, 17, "41091221256871714", -166},
  {2.6572411830302097770464640e+181, 9, "265724118", 182},
  {1.7676196071786678175123642e-152, 21, "176761960717866781751", -151},
  {1.3820455571813743937229989e-98, 1, "1", -97},
  {5.1517504855335189805708153e+270, 20, "51517504855335189806", 271},
  {8.8794872430556944183794891e-273, 10, "8879487243", -272},
  {4.9771174478451095667173099e-167, 3, "498", -166},
  {2.1836075820897548656224048e-250, 4, "2184", -249},
  {1.0370898591827991610897391e+60, 11, "10370898592", 61},
  {3.9754093667856984477124451e+90, 15, "39754093667857", 91},
  {1.0083994943947372177702471e-84, 2, "1", -83},
  {3.5351228293106518985861611e-92, 6, "353512", -91},
  {4.7726610716372627011966639e-167, 18, "47726610716372627", -166},
  {8.0852491732269761356902988e-131, 3, "809", -130},
  {4.6388653343349332687378150e-149, 12, "463886533433", -148},
  {4.1320643580162361630075298e+186, 12, "413206435802", 187},
  {3.2413657479455952364310749e+205, 12, "324136574795", 206},
  {3.7002818940064094428262673e+213, 1, "4", 214},
  {7.8597309459809034399613947e-224, 10, "7859730946", -223},
  {1.9822931479482657977641009e+211, 12, "198229314795", 212},
  {6.7809718770437338678271760e-251, 2, "68", -250},
  {9.3318067156357823533035223e-291, 1, "9", -290},
  {1.1281119745054594399149727e+54, 20, "11281119745054594399", 55},
  {1.8241075535536122043112073e-01, 20, "18241075535536122043", 0},
  {5.2719074565296529510597239e-125, 4, "5272", -124},
  {1.0664877921235028126711246e-228, 12, "106648779212", -227},
  {1.2148840891386274764492983e+170, 8, "12148841", 171},
  {2.4939827177211390072051809e-101, 7, "2493983", -100},
  {1.8895672558644596217817988e+100, 2, "19", 101},
  {5.9002367563804184150003746e-235, 3, "59", -234},
  {5.3718318094907280513385128e-157, 21, "537183180949072805134", -156},
  {4.7423972880627841742462709e+64, 7, "4742397", 65},
  {1.1005387867277151812879781e-111, 13, "1100538786728", -110},
  {7.2094924593099789642204840e-47, 14, "720949245931", -46},
  {2.0236204444938315658230386e-284, 20, "20236204444938315658", -283},
  {1.1337421270832536131366648e-122, 8, "11337421", -121},
  {9.4637957056010900694461074e-65, 7, "9463796", -64},
  {1.8767880618212876053844209e-261, 2, "19", -260},
  {1.3111783619700955509860079e-276, 12, "131117836197", -275},
  {1.6649980489334472965710733e+299, 9, "166499805", 300},
  {2.5000979091079144433290052e-273, 3, "25", -272},
  {1.3798707552717262350744621e+200, 8, "13798708", 201},
  {1.0189605012711184394635570e+216, 4, "1019", 217},
  {1.1808192248290134911369907e+103, 3, "118", 104},
  {1.3017648542520111037326126e-36, 3, "13", -35},
  {3.6935573855712488947886940e+83, 7, "3693557", 84},
  {7.0415737590677231472821603e+265, 16, "7041573759067723", 266},
  {1.5039406216252990054787968e+226, 10, "1503940622", 227},
  {3.8301559820259662862534151e-215, 18, "383015598202596629", -214},
  {4.7305235807904859198111205e-48, 16, "4730523580790486", -47},
  {1.8340401419691956725243885e+147, 13, "1834040141969", 148},
  {1.6689839620144020310798159e-132, 10, "1668983962", -131},
  {1.1686619738639460430327567e+217, 18, "116866197386394604", 218},
  {3.5613237333425432000000000e+16, 4, "3561", 17},
  {2.3122334167385517914345827e-156, 5, "23122", -155},
  {3.7753360222567412303576367e+76, 16, "3775336022256741", 77},
  {8.0485886545146232267116034e+214, 21, "804858865451462322671", 215},
  {2.3905838770507904917248672e+90, 1, "2", 91},
  {1.4052979446996042045902649e+259, 1, "1", 260},
  {1.1441754029774915265560400e-121, 13, "1144175402977", -120},
  {2.0272378619519610413233030e+142, 21, "202723786195196104132", 143},
  {1.8865803983978631660849145e-268, 12, "18865803984", -267},
  {3.6524179831788490167467551e-294, 15, "365241798317885", -293},
  {5.0991873478131552071203059e-51, 10, "5099187348", -50},
  {3.9131994577585247994200073e+158, 12, "391319945776", 159},
  {1.5998334795813611311850536e-231, 4, "16", -230},
  {8.7360860942845782092768036e+195, 4, "8736", 196},
  {9.6146536705933351204624887e-112, 14, "96146536705933", -111},
  {5.3124970822647546429108929e+63, 11, "53124970823", 64},
  {7.4876489433769622912355914e-66, 14, "7487648943377", -65},
  {4.5042996911468139298790378e-231, 9, "450429969", -230},
  {1.3327762803448688652988365e-76, 16, "1332776280344869", -75},
  {1.1942323395641878237816087e-184, 7, "1194232", -183},
  {2.5927895924282050300251677e-261, 18, "259278959242820503", -260},
  {1.1914687865848731943026859e-274, 10, "1191468787", -273},
  {5.9368911372672469766818430e-268, 13, "5936891137267", -267},
  {8.5061462895116784003277665e-108, 4, "8506", -107},
  {2.6564351328720690545250037e-250, 7, "2656435", -249},
  {8.9054616582625356716786671e-293, 16, "8905461658262536", -292},
  {2.7140330518303910455896779e-144, 13, "271403305183", -143},
  {1.9642143004616598701762709e-34, 12, "196421430046", -33},
  {4.1122707156324177305630240e+116, 15, "411227071563242", 117},
  {3.6508195853470615506220829e+205, 18, "365081958534706155", 206},
  {5.9989374908730987350116648e+224, 12, "599893749087", 225},
  {9.1394235528208208470438021e-229, 5, "91394", -228},
  {1.2563633966107277804282765e-79, 12, "125636339661", -78},
  {2.0824753179131802003435834e-274, 12, "208247531791", -273},
  {1.8365446764726647572748763e+130, 6, "183654", 131},
  {1.1056851047518194256311198e-71, 8, "11056851", -70},
  {1.2145186015958549907282268e+132, 16, "1214518601595855", 133},
  {8.0447479486283009417151423e+52, 8, "80447479", 53},
  {1.3007831163075561012232589e-157, 3, "13", -156},
  {8.9077265039371558400000000e+17, 12, "890772650394", 18},
  {4.8301331420353849676757371e-78, 20, "48301331420353849677", -77},
  {3.6750412909602634556418795e+237, 12, "367504129096", 238},
  {1.5269648395735627802881347e-76, 12, "152696483957", -75},
  {9.9270477630615480270883727e-126, 19, "9927047763061548027", -125},
  {4.3815684550886097149165677e+79, 16, "438156845508861", 80},
  {1.6636290112340531588454974e+155, 7, "1663629", 156},
  {1.1390041856918939285861112e+146, 15, "113900418569189", 147},
  {4.7129043805700616332841170e+137, 6, "47129", 138},
  {2.4439717489974098465911877e+126, 12, "2443971749", 127},
  {2.9601197386416246334410565e+262, 12, "296011973864", 263},
  {7.3090097341955549448649538e+171, 3, "731", 172},
  {1.6447721613763351040000000e+18, 7, "1644772", 19},
  {7.3672555240094656020068143e+99, 21, "736725552400946560201", 100},
  {1.3001994179638391417293587e-136, 18, "130019941796383914", -135},
  {7.1171345254102921027634109e+211, 18, "71171345254102921", 212},
  {4.8922475107558025204026022e+117, 18, "489224751075580252", 118},
  {1.7026553767810683767497310e-47, 14, "17026553767811", -46},
  {9.9282079522656400851800441e+177, 16, "992820795226564", 178},
  {1.5024948990398357141168306e-288, 10, "1502494899", -287},
  {7.5736080895604109924039441e-192, 15, "757360808956041", -191},
  {8.3084813179599374275689681e+211, 5, "83085", 212},
  {1.3761726291654324816349231e-01, 2, "14", 0},
  {3.0558625685456057652714819e+154, 3, "306", 155},
  {2.7219947765417048353230791e+305, 20, "27219947765417048353", 306},
  {4.0324693891789642159000623e+205, 19, "4032469389178964216", 206},
  {1.3251716854859227498877048e-173, 15, "132517168548592", -172},
  {1.0535663552495899186038240e-129, 18, "105356635524958992", -128},
  {5.6084677270869736770714965e-126, 15, "560846772708697", -125},
  {5.1902935547147094289450816e-160, 10, "5190293555", -159},
  {4.3327386106663470033085780e-106, 4, "4333", -105},
  {2.3870655453791574509768841e-211, 6, "238707", -210},
  {1.4356811637201641133101868e+221, 9, "143568116", 222},
  {5.7668050567352472380104768e-36, 9, "576680506", -35},
  {7.3685309965537092973393001e-166, 5, "73685", -165},
  {1.1394849502230194653799924e+100, 16, "1139484950223019", 101},
  {4.1111347000257913951772991e+192, 12, "411113470003", 193},
  {8.1282763918479640306555405e-255, 8, "81282764", -254},
  {4.5192746010663081090714470e-165, 3, "452", -164},
  {6.8744434806981532625982979e+204, 20, "68744434806981532626", 205},
  {7.0093433844833944712169216e+124, 2, "7", 125},
  {2.1598295498917045018823029e-07, 21, "215982954989170450188", -6},
  {4.2288004146000081207249667e-141, 4, "4229", -140},
  {1.4147558672610365430556238e+184, 18, "141475586726103654", 185},
  {5.0565475825680106354378069e-197, 1, "5", -196},
  {7.8049664178809730495717294e+143, 4, "7805", 144},
  {1.0938221535933249761680903e+102, 18, "109382215359332498", 103},
  {2.8457869775773128617614083e-237, 17, "28457869775773129", -236},
  {6.4920131998171433195937723e+255, 19, "649201319981714332", 256},
  {2.3001964182890057208819241e-66, 4, "23", -65},
  {8.7466234160257359116386563e+135, 3, "875", 136},
  {3.6405171261552836958708798e-266, 3, "364", -265},
  {1.8494159725581483448721697e+80, 13, "1849415972558", 81},
  {7.4124030137235973775566822e+158, 18, "741240301372359738", 159},
  {1.6771943881892606098313022e+291, 15, "167719438818926", 292},
  {1.4083242183688907537316332e+178, 16, "1408324218368891", 179},
  {1.7628400659262736457318053e+124, 9, "176284007", 125},
  {4.7101452199296797058593555e+191, 5, "47101", 192},
  {4.1193522309883850534789730e-171, 11, "4119352231", -170},
  {1.8332977892082267201607717e+220, 12, "183329778921", 221},
  {1.8567444881775714331661507e+135, 13, "1856744488178", 136},
  {1.1524339216427479549182713e+265, 8, "11524339", 266},
  {5.7870020920278518668217734e+71, 9, "578700209", 72},
  {8.9428642215662341743498011e+253, 10, "8942864222", 254},
  {2.0318818767486791768172964e+127, 1, "2", 128},
  {4.2251756016355118395388405e-272, 12, "422517560164", -271},
  {1.2601534153478684360906807e+301, 10, "1260153415", 302},
  {3.5019255642482965690267822e+223, 2, "35", 224},
  {3.0176508439894326171875000e+12, 7, "3017651", 13},
  {2.5689561555321989047147881e+134, 12, "256895615553", 135},
  {1.2907606080911585326609870e-195, 11, "12907606081", -194},
  {2.6416538778671164585347603e+173, 9, "264165388", 174},
  {3.8157830262879714465358851e+56, 15, "381578302628797", 57},
  {1.0403244595038891584969029e+200, 9, "104032446", 201},
  {4.9979887735402971237420693e+269, 14, "49979887735403", 270},
  {4.0982551274308538353617274e+93, 5, "40983", 94},
  {3.2420866394639139217343691e-223, 4, "3242", -222},
  {3.5664459490067858059406247e+77, 3, "357", 78},
  {3.0255225805269085698580811e+211, 18, "302552258052690857", 212},
  {3.7570159559554216873396384e+172, 2, "38", 173},
  {4.9229744256955638813247776e-300, 4, "4923", -299},
  {1.1896330469840649770363972e-42, 6, "118963", -41},
  {5.2946107998929058456948059e+297, 7, "5294611", 298},
  {3.2675621155597141575016830e-105, 6, "326756", -104},
  {4.6876737504709376510017184e+57, 10, "468767375", 58},
  {1.2213281768182186319390484e-186, 19, "1221328176818218632", -185},
  {3.4176222431229327452947096e+52, 6, "341762", 53},
  {1.5070009399251792519897021e+96, 14, "15070009399252", 97},
  {8.9901538806855318285541906e-41, 7, "8990154", -40},
  {6.7732124397233514634386609e-02, 5, "67732", -1},
  {7.6846325793681986073486175e+65, 1, "8", 66},
  {3.0172351471279183247938278e-93, 4, "3017", -92},
  {2.2543518878139725327491760e+08, 11, "22543518878", 9},
  {4.6930649343629714806760966e-05, 10, "4693064934", -4},
  {1.0821571462957160352459135e-64, 16, "1082157146295716", -63},
  {4.9173298563962606381505306e+239, 10, "4917329856", 240},
  {9.5230696655253641859570581e+174, 1, "1", 176},
  {3.7210098133027148437500000e+12, 20, "37210098133027148438", 13},
  {5.9450954031661073138387616e-30, 17, "59450954031661073", -29},
  {7.6682514049956326902749345e-200, 5, "76683", -199},
  {1.0040822010789752842210343e-219, 6, "100408", -218},
  {1.0014122489118595992207156e+291, 17, "10014122489118596", 292},
  {1.4254658568663130614853388e-285, 4, "1425", -284},
  {2.3835425580763827394321094e-276, 7, "2383543", -275},
  {2.4141319870870193285696772e-76, 10, "2414131987", -75},
  {1.5941872636402583027959099e+190, 3, "159", 191},
  {5.3658823074867702896392277e-164, 9, "536588231", -163},
  {4.2569750236703092585116195e-259, 2, "43", -258},
  {1.8357245529924450229717694e-171, 4, "1836", -170},
  {6.5603835458441652851058042e-282, 11, "65603835458", -281},
  {6.5736034944717580752808463e+269, 6, "65736", 270},
  {5.5053344452180476690432000e+22, 2, "55", 23},
  {4.8913989799051282459154263e-213, 3, "489", -212},
  {5.3570547237131515104342117e+85, 14, "53570547237132", 86},
  {1.9566743650031785230419219e+307, 4, "1957", 308},
  {4.6835121103821703057073876e+39, 6, "468351", 40},
  {7.5107744346032851918394003e-47, 7, "7510774", -46},
  {7.6622083720345114454343372e+177, 3, "766", 178},
  {2.6185766871456822412646620e+53, 6, "261858", 54},
  {4.5075874331487655229965420e+277, 12, "450758743315", 278},
  {2.6539426394151987545918301e+120, 21, "265394263941519875459", 121},
  {1.1039942350500815641323946e+246, 8, "11039942", 247},
  {6.5982283368021880598099120e+115, 15, "659822833680219", 116},
  {4.1282490048932368276546307e-107, 13, "4128249004893", -106},
  {7.6490847090576225458960073e+47, 20, "76490847090576225459", 48},
  {2.4103644613225407657238786e+176, 10, "2410364461", 177},
  {5.8664362728059457716709747e-198, 18, "586643627280594577", -197},
  {3.4890328597572600814332725e-103, 17, "34890328597572601", -102},
  {1.4726975112470086006746637e-79, 19, "1472697511247008601", -78},
  {7.8888369483359206403713809e-135, 9, "788883695", -134},
  {5.3229084418616086720666353e+305, 21, "532290844186160867207", 306},
  {4.9987521213105655507778264e+287, 15, "499875212131057", 288},
  {7.7474059436268683549349727e-93, 14, "77474059436269", -92},
  {4.4116492495827036712278699e+236, 6, "441165", 237},
  {1.8086989175566025232476014e-83, 8, "18086989", -82},
  {2.5890189601716058548869101e-149, 21, "258901896017160585489", -148},
  {9.8211198271725933187333688e+95, 20, "98211198271725933187", 96},
  {3.3388438030345946901618691e+111, 10, "3338843803", 112},
  {1.5291061494466123250060948e+268, 1, "2", 269},
  {3.5743672017646510059191523e-28, 17, "3574367201764651", -27},
  {2.5064054291779240904607014e-186, 7, "2506405", -185},
  {2.3458102873139274281349259e+109, 4, "2346", 110},
  {1.6142861847622428291790078e+185, 5, "16143", 186},
  {5.3817495009320115176492661e+158, 19, "5381749500932011518", 159},
  {6.2721170471813854503229663e-222, 2, "63", -221},
  {4.6162990010322522294983154e+65, 4, "4616", 66},
  {2.4359226059167607970232364e+135, 8, "24359226", 136},
  {1.9386323761664115658846438e-05, 9, "193863238", -4},
  {1.5135407015359256513574761e+171, 16, "1513540701535926", 172},
  {2.5806669933109401540959278e-36, 17, "25806669933109402", -35},
  {4.1522891065145167522132397e+06, 5, "41523", 7},
  {3.8465855209392847733981755e-185, 20, "38465855209392847734", -184},
  {5.8910497480902593958202779e+277, 11, "58910497481", 278},
  {3.3063184428664673365464760e+299, 9, "330631844", 300},
  {1.2754584598566485477778428e-62, 11, "12754584599", -61},
  {2.6652076689319920175518276e-95, 18, "266520766893199202", -94},
  {1.0596409841828000242219686e-234, 1, "1", -233},
  {2.1888388724022329002012769e-184, 3, "219", -183},
  {1.7358518338422530442452901e-98, 17, "1735851833842253", -97},
  {5.7925453042919911777003559e+130, 10, "5792545304", 131},
  {2.9812181986966176214600909e+26, 5, "29812", 27},
  {2.6865644755910566435819781e+92, 12, "268656447559", 93},
  {2.2006712247682418043376955e-169, 11, "22006712248", -168},
  {3.3804668827769341284182879e+61, 14, "33804668827769", 62},
  {6.0245581098044301756404939e+116, 15, "602455810980443", 117},
  {7.2230814824414735251411887e-214, 17, "72230814824414735", -213},
  {4.9832757146251123702331345e-22, 18, "498327571462511237", -21},
  {1.0355632950203911072031361e-265, 15, "103556329502039", -264},
  {1.8093222992143907967591988e+78, 6, "180932", 79},
  {4.9235555800938470846725356e+283, 8, "49235556", 284},
  {4.9766321841114965617147148e-120, 4, "4977", -119},
  {3.7020155015013314487910400e+23, 8, "37020155", 24},
  {2.6128048511764811796530309e+127, 8, "26128049", 128},
  {2.4084743074924539142739077e+271, 7, "2408474", 272},
  {1.3537188064331651381216949e+41, 4, "1354", 42},
  {8.5762210868447998399584863e-264, 12, "857622108684", -263},
  {7.2260373714982627999632392e-299, 12, "72260373715", -298},
  {1.9700299968151323616455948e+256, 5, "197", 257},
  {3.5946452945368955390220807e-107, 17, "35946452945368955", -106},
  {2.0163921499100003369596782e+240, 4, "2016", 241},
  {3.2517994442559480447597630e-130, 16, "3251799444255948", -129},
  {3.0593147435807628802199648e-308, 13, "3059314743581", -307},
  {2.8629019808562840948795638e-29, 19, "2862901980856284095", -28},
  {1.0815594479932519524513481e-240, 12, "108155944799", -239},
  {1.9634086173737536362171236e+45, 11, "19634086174", 46},
  {2.8389952992238624840328790e-273, 10, "2838995299", -272},
  {9.9644327925821467428732364e+108, 16, "9964432792582147", 109},
  {8.6582643024424899318512563e+160, 20, "86582643024424899319", 161},
  {6.8463616509504261373985158e+161, 9, "684636165", 162},
  {9.2527132920631946705744428e+147, 3, "925", 148},
  {8.6386143258491503488371340e+248, 18, "863861432584915035", 249},
  {2.5646349784499097336381062e+176, 2, "26", 177},
  {1.0986350187328193239721941e+00, 21, "109863501873281932397", 1},
  {5.2405994083420254299022678e+159, 13, "5240599408342", 160},
  {2.9129954067034578895267302e+107, 4, "2913", 108},
  {1.4047071891171663746308263e-140, 10, "1404707189", -139},
  {6.1433008631512337011387947e-11, 3, "614", -10},
  {1.5177133688695217593359297e+58, 3, "152", 59},
  {1.2365828375991259425214923e+106, 13, "1236582837599", 107},
  {4.8129143759631882490865515e+125, 5, "48129", 126},
  {7.2048838349624826478189985e+149, 16, "7204883834962483", 150},
  {2.9035080566641856142397607e+80, 14, "29035080566642", 81},
  {2.4283783799484936234868347e-231, 21, "242837837994849362349", -230},
  {1.9637770114031389665357565e+293, 5, "19638", 294},
  {6.0934068907579888752064028e-182, 2, "61", -181},
  {1.4190633835186950398657337e+40, 7, "1419063", 41},
  {3.8725009762526591713280000e+21, 8, "3872501", 22},
  {2.8571974217281799556746878e-166, 18, "285719742172817996", -165},
  {1.7019790943790937220731981e-84, 21, "170197909437909372207", -83},
  {1.5052458993487639448270861e-32, 5, "15052", -31},
  {4.5792954365786164835344504e+109, 12, "457929543658", 110},
  {2.9711811152487800586800405e-167, 13, "2971181115249", -166},
  {5.4453990499805113503185138e-230, 13, "5445399049981", -229},
  {1.8550032335206721296685153e-174, 1, "2", -173},
  {3.6686266384595713000130006e-288, 16, "3668626638459571", -287},
  {1.9880663245653975200129782e+121, 2, "2", 122},
  {2.5351123061004505831697460e+108, 16, "2535112306100451", 109},
  {2.4448079707943324321919391e+72, 11, "24448079708", 73},
  {1.9785587274989079059334726e+53, 6, "197856", 54},
  {1.6483797042063505908226782e+301, 13, "1648379704206", 302},
  {1.1965683023488992549322513e-212, 9, "11965683", -211},
  {2.8411135905775888804394628e+231, 18, "284111359057758888", 232},
  {4.7863670547218485877390373e+138, 18, "478636705472184859", 139},
  {2.2937575535097795993564021e+134, 18, "22937575535097796", 135},
  {1.5029121533648420750228177e-133, 1, "2", -132},
  {5.2328850275640725158154964e+03, 2, "52", 4},
  {3.9192865624008248720739559e+65, 10, "3919286562", 66},
  {8.8752663055958580864330468e-143, 13, "8875266305596", -142},
  {6.4748973618011218825427903e-151, 11, "64748973618", -150},
  {2.2419718955025662384434328e+77, 16, "2241971895502566", 78},
  {1.6863260299559542856164337e-233, 16, "1686326029955954", -232},
  {7.7291829626688083785206610e-241, 13, "7729182962669", -240},
  {3.1017708245798982655903137e-142, 6, "310177", -141},
  {1.2891911915140102634349254e+140, 16, "128919119151401", 141},
  {3.4660963651888563738360753e+142, 1, "3", 143},
  {1.6808406133570871099694789e-79, 12, "168084061336", -78},
  {1.1808667373475126284758446e-229, 10, "1180866737", -228},
  {3.9611376445313658624164348e-286, 9, "396113764", -285},
  {6.7464350026763892704811504e-229, 14, "67464350026764", -228},
  {2.7083107768450700442203797e-303, 3, "271", -302},
  {1.0171930447751109806970436e-50, 1, "1", -49},
  {1.1489277166158504462317185e-227, 7, "1148928", -226},
  {3.6119680961628965880454582e-140, 3, "361", -139},
  {3.4020795741762121771733201e-161, 6, "340208", -160},
  {6.3764513847711157624991092e-220, 21, "63764513847711157625", -219},
  {7.9141829925622779956301923e-133, 13, "7914182992562", -132},
  {2.7075737995422728976844327e-263, 20, "27075737995422728977", -262},
  {5.5591931104768951727648250e-145, 6, "555919", -144},
  {5.5251602857984400527986550e+62, 10, "5525160286", 63},
  {1.0108624724317428422544907e-22, 8, "10108625", -21},
  {1.6885522127646079639539893e+124, 21, "168855221276460796395", 125},
  {2.9337965592841649748603895e-268, 14, "29337965592842", -267},
  {6.4921569728758396354912294e-69, 1, "6", -68},
  {8.5410849917451878048334755e+118, 3, "854", 119},
  {5.1902743942606924823084338e+211, 13, "5190274394261", 212},
  {5.1778724028642712004578097e-59, 7, "5177872", -58},
  {4.3739711463796570378815966e+73, 10, "4373971146", 74},
  {5.4223348830389852968688092e-206, 3, "542", -205},
  {4.4753532343798948757853035e+241, 10, "4475353234", 242},
  {3.1076622186872424934747292e-152, 14, "31076622186872", -151},
  {1.8909835095217948806570828e+119, 21, "189098350952179488066", 120},
  {1.4950580888108497829248458e+201, 21, "149505808881084978292", 202},
  {2.7953327969016119994843590e-128, 19, "2795332796901611999", -127},
  {7.3665238478753507587227415e-127, 20, "73665238478753507587", -126},
  {4.5957565231510167861413607e+45, 10, "4595756523", 46},
  {1.4416264560860350728034973e+07, 3, "144", 8},
  {1.7624682213791781346548552e+211, 6, "176247", 212},
  {1.6267499313514098233063567e-216, 13, "1626749931351", -215},
  {5.9145209104964150770551067e-89, 3, "591", -88},
  {1.6384503847738717834541677e-33, 13, "1638450384774", -32},
  {7.7584005295357547195489820e-176, 14, "77584005295358", -175},
  {1.1016617055660856692030343e-251, 9, "110166171", -250},
  {8.1190213274638338093206042e+149, 13, "8119021327464", 150},
  {8.0480884372552238002564613e+60, 8, "80480884", 61},
  {1.0375159941743618434021695e+261, 14, "10375159941744", 262},
  {6.2158163143301129271905950e-115, 20, "62158163143301129272", -114},
  {3.3975604518750649378273368e+265, 15, "339756045187506", 266},
  {6.5300460366399213744527438e-265, 14, "65300460366399", -264},
  {6.4521175543255089962317581e+137, 18, "6452117554325509", 138},
  {2.1230029319590532365276128e-180, 15, "212300293195905", -179},
  {1.6816249819452272523524416e-34, 3, "168", -33},
  {3.9494615071534421421251822e-203, 15, "394946150715344", -202},
  {8.0370542294886604831196328e-148, 6, "803705", -147},
  {8.0953515705211489982433663e+287, 6, "809535", 288},
  {3.1066101439244243844906952e+280, 14, "31066101439244", 281},
  {7.7050337030670784948112095e-165, 20, "77050337030670784948", -164},
  {4.2946093520598947807001821e+132, 19, "4294609352059894781", 133},
  {2.9094559462232961032883900e-210, 18, "29094559462232961", -209},
  {9.0071755117931685457792953e+174, 18, "900717551179316855", 175},
  {4.6012975624100457453361719e-144, 2, "46", -143},
  {1.6593457407982935543855339e-279, 2, "17", -278},
  {2.9696497402280507551946189e-10, 4, "297", -9},
  {2.0849459969861581966670940e-257, 8, "2084946", -256},
  {2.7237509140810455613579404e-278, 9, "272375091", -277},
  {1.6760603203297986495902841e+102, 15, "16760603203298", 103},
  {5.8280500328051621326193920e+135, 18, "582805003280516213", 136},
  {1.9943837289353783948302176e-132, 14, "19943837289354", -131},
  {3.6135238041094001037807549e-24, 17, "36135238041094001", -23},
  {1.1245507106372612814839114e-99, 8, "11245507", -98},
  {9.1776428120154221529755397e-152, 17, "91776428120154222", -151},
  {2.8041546251747463561408102e-73, 16, "2804154625174746", -72},
  {8.7579869105387186187349121e-214, 2, "88", -213},
  {1.1671407256283190104217484e-213, 13, "1167140725628", -212},
  {4.0344758985125842243103848e-209, 18, "403447589851258422", -208},
  {7.4988228538801495902270005e+297, 21, "749882285388014959023", 298},
  {3.6199535114575305725490918e+49, 5, "362", 50},
  {4.1054956235696301164745378e-113, 14, "41054956235696", -112},
  {4.6479915517492371070284428e-285, 1, "5", -284},
  {2.5745222966006043694284544e-214, 1, "3", -213},
  {2.3256161966993782869156026e+92, 8, "23256162", 93},
  {5.4713676193979827330159024e+156, 20, "5471367619397982733", 157},
  {1.7165251252031732044272548e-82, 8, "17165251", -81},
  {1.0571429223983907600501644e-277, 21, "105714292239839076005", -276},
  {4.7839496524291138351580262e+194, 12, "478394965243", 195},
  {2.0868497005023174692148559e-146, 5, "20868", -145},
  {2.8690671697302517640619430e-68, 19, "2869067169730251764", -67},
  {1.6628430309687450201626940e-217, 2, "17", -216},
  {2.5200284449167809299118941e+88, 15, "252002844491678", 89},
  {6.6318545581305422443650465e+65, 20, "66318545581305422444", 66},
  {1.0728581450970175591401176e+175, 12, "10728581451", 176},
  {9.6406290584092812149247588e+153, 12, "964062905841", 154},
  {1.0163030957928860934823904e-111, 6, "10163", -110},
  {3.9037968871822286660808628e+105, 9, "390379689", 106},
  {4.9255477036308735577210285e-110, 6, "492555", -109},
  {1.8159243867074407453272810e+205, 10, "1815924387", 206},
  {1.0144297436083888549908152e+99, 11, "10144297436", 100},
  {2.4599717272071336764917125e-300, 9, "245997173", -299},
  {1.1570450620764421210745744e+285, 18, "115704506207644212", 286},
  {2.7301602287264184512988960e-273, 15, "273016022872642", -272},
  {1.3810101875876661041375630e+36, 7, "138101", 37},
  {3.9495934293758907370817323e-288, 6, "394959", -287},
  {4.6224165882877700993475750e-291, 5, "46224", -290},
  {2.4515481896717341624852174e-135, 20, "24515481896717341625", -134},
  {7.6388102872043037509241933e-245, 4, "7639", -244},
  {5.8938761899899853500490267e+189, 4, "5894", 190},
  {4.0488071963420439508680704e+25, 16, "4048807196342044", 26},
  {1.3325509503147097217645884e+54, 18, "133255095031470972", 55},
  {2.0729826769759152101783651e+99, 16, "2072982676975915", 100},
  {8.2772491373474376783634925e-301, 13, "8277249137347", -300},
  {4.9526940635979973759093668e+277, 3, "495", 278},
  {3.6588372722261804236600763e+144, 13, "3658837272226", 145},
  {6.6135463355586575842444346e-68, 12, "661354633556", -67},
  {2.6652594844822906367774261e+225, 20, "26652594844822906368", 226},
  {2.9333862927374929254147068e-87, 8, "29333863", -86},
  {6.3788070102198873736903043e+272, 21, "637880701021988737369", 273},
  {1.0517634727842336794803066e+219, 21, "105176347278423367948", 220},
  {1.8995044913201193352223350e-90, 20, "18995044913201193352", -89},
  {4.6472212915293297451779712e-212, 4, "4647", -211},
  {8.7265606669751207161394256e+132, 18, "872656066697512072", 133},
  {1.5695271978668789842073733e-189, 12, "156952719787", -188},
  {1.5757968900016297076650817e-04, 8, "15757969", -3},
  {1.1002722645173416391938045e-128, 15, "110027226451734", -127},
  {1.1940448463030641326164503e+118, 11, "11940448463", 119},
  {9.2477203342426921952022030e+198, 13, "9247720334243", 199},
  {8.5760534247506988858009662e-269, 19, "8576053424750698886", -268},
  {3.9327528584559340283447547e+77, 7, "3932753", 78},
  {8.3163259439370076377462994e+205, 2, "83", 206},
  {1.3902372032508785924379064e+292, 21, "139023720325087859244", 293},
  {9.9609043390441280261790422e+253, 21, "996090433904412802618", 254},
  {3.1258981150729091753932540e+289, 15, "312589811507291", 290},
  {1.3506824226719788041013147e-263, 12, "135068242267", -262},
  {3.4800150773760537277384807e-65, 16, "3480015077376054", -64},
  {1.4358211682931888426157071e-221, 4, "1436", -220},
  {3.5569106140735148353534313e-68, 19, "3556910614073514835", -67},
  {1.7716519355185964079696625e-99, 10, "1771651936", -98},
  {2.1694997199844302380925107e+179, 6, "21695", 180},
  {7.1043971120547933139763177e+203, 18, "710439711205479331", 204},
  {1.2878104377048654933985740e+171, 17, "12878104377048655", 172},
  {8.2188420056025260087887732e+94, 2, "82", 95},
  {3.5635376348018175367181546e-306, 16, "3563537634801818", -305},
  {1.6000610076884343307497258e-188, 9, "160006101", -187},
  {1.2635297206444960276348475e-63, 19, "1263529720644496028", -62},
  {2.8950555345608712662107012e-117, 1, "3", -116},
  {1.5417058278528764347102839e-247, 1, "2", -246},
  {7.9532651595145841322131873e+160, 3, "795", 161},
  {1.9213694427555450385055873e-63, 4, "1921", -62},
  {7.8439457009456685698519609e+207, 3, "784", 208},
  {1.0176514521338605748388782e-291, 4, "1018", -290},
  {7.8499473483657522113281363e-106, 17, "78499473483657522", -105},
  {3.5062647605795818924340817e-58, 3, "351", -57},
  {1.3075514815335041559505779e-268, 21, "130755148153350415595", -267},
  {3.1031035647607110334652702e+183, 2, "31", 184},
  {2.9072027533935816531334515e-170, 7, "2907203", -169},
  {3.1839879908283036739154015e-54, 7, "3183988", -53},
  {2.1614838967046538228511646e-178, 5, "21615", -177},
  {2.8848024260430798903746083e-145, 1, "3", -144},
  {8.2687053649406274225242910e-196, 9, "826870536", -195},
  {1.1038680988842247813749164e+258, 5, "11039", 259},
  {4.0344518702192195066880628e-53, 19, "4034451870219219507", -52},
  {1.9798446575977744812543215e+92, 19, "1979844657597774481", 93},
  {1.4162297529177420480449735e+243, 1, "1", 244},
  {1.6602045429470800519662512e+114, 18, "166020454294708005", 115},
  {1.1044438853579655821610604e+268, 14, "1104443885358", 269},
  {1.8305479252696409461643469e+137, 1, "2", 138},
  {6.2642887656474682127387557e+95, 20, "62642887656474682127", 96},
  {3.2727817229444254787385348e-70, 8, "32727817", -69},
  {1.5071638696758834712358419e+207, 5, "15072", 208},
  {5.3612584113808700854652933e+290, 3, "536", 291},
  {1.4511717310951988137744855e+225, 16, "1451171731095199", 226},
  {9.8612583475057407884081927e+203, 4, "9861", 204},
  {3.4566533415397455059028702e+269, 10, "3456653342", 270},
  {1.1337687665731777476766192e+172, 2, "11", 173},
  {2.0750798069871016067613139e-178, 20, "20750798069871016068", -177},
  {5.1213716499658175452385693e-26, 20, "51213716499658175452", -25},
  {1.9084290188671137624670662e+76, 2, "19", 77},
  {2.1820466728745135181155267e+47, 5, "2182", 48},
  {5.8135161761610825502334984e+204, 9, "581351618", 205},
  {2.2498286407799058513509820e-186, 9, "224982864", -185},
  {2.1193224827104408204702692e+195, 2, "21", 196},
  {4.0030541776818876880685677e-307, 21, "400305417768188768807", -306},
  {1.1674148925223759421552149e+145, 3, "117", 146},
  {1.4264741465703386679532417e-104, 1, "1", -103},
  {1.4330281493182919047759944e+303, 12, "143302814932", 304},
  {1.0284472655176472601449778e-211, 15, "102844726551765", -210},
  {6.8467757000304857354548752e+190, 20, "68467757000304857355", 191},
  {1.5014278516954239004433756e-180, 2, "15", -179},
  {5.3039649501926708622594778e+276, 14, "53039649501927", 277},
  {2.4520875019763021148655698e+201, 6, "245209", 202},
  {4.5670192629272586240000000e+18, 7, "4567019", 19},
  {2.2763581314633486526125792e+140, 2, "23", 141},
  {1.1375368878851614102317367e+262, 14, "11375368878852", 263},
  {4.3908387243133501739900604e+100, 19, "4390838724313350174", 101},
  {2.3314184258685770789860398e-196, 2, "23", -195},
  {8.4821102557411858574204815e-213, 18, "848211025574118586", -212},
  {2.0527603930788390552747081e-268, 20, "20527603930788390553", -267},
  {3.0834864033844627361716099e-291, 7, "3083486", -290},
  {4.4388821396371644804618912e-16, 20, "44388821396371644805", -15},
  {1.5135231512935374466584268e+87, 11, "15135231513", 88},
  {8.4111189744444749763948227e+68, 18, "841111897444447498", 69},
  {8.3170311826773217709639707e-69, 3, "832", -68},
  {7.5641620350201031866730236e+98, 11, "7564162035", 99},
  {2.2624158376087498006240280e-157, 3, "226", -156},
  {1.2930877299685983907924091e-276, 3, "129", -275},
  {1.1526739449709036578986137e-66, 18, "115267394497090366", -65},
  {1.1866459750702525000000000e+15, 19, "11866459750702525", 16},
  {1.9153017346939774276475629e+238, 20, "19153017346939774276", 239},
  {1.0459617153578945123313610e+235, 8, "10459617", 236},
  {3.0678814338118940103242971e+72, 14, "30678814338119", 73},
  {9.1139937532487198710441589e+07, 7, "9113994", 8},
  {3.4383724680105357632158079e+236, 2, "34", 237},
  {6.4144210720038470677859478e+110, 12, "6414421072", 111},
  {2.7509375197662370919184818e-179, 1, "3", -178},
  {2.1238781857227590229364428e+304, 16, "2123878185722759", 305},
  {5.2798923036287214009099688e+119, 18, "52798923036287214", 120},
  {1.5267187655766085817548597e-133, 1, "2", -132},
  {3.0914551392617980922399794e-193, 8, "30914551", -192},
  {4.6576895733685716806251267e-36, 20, "46576895733685716806", -35},
  {1.0025285519201141865387005e-298, 10, "1002528552", -297},
  {1.9841944047429392254253632e-50, 11, "19841944047", -49},
  {1.3254812112374554747593081e-93, 6, "132548", -92},
  {1.4568168573954557703410759e-12, 9, "145681686", -11},
  {8.6572186445220565937564599e+110, 2, "87", 111},
  {7.4112115423876615650273546e+36, 12, "741121154239", 37},
  {3.4561716890340682896159363e-37, 20, "34561716890340682896", -36},
  {5.6843988799141057810501793e-74, 16, "5684398879914106", -73},
  {1.4275738070004596736000000e+20, 4, "1428", 21},
  {7.1005796218394704559053114e+155, 18, "710057962183947046", 156},
  {3.2962460917880308806027622e+269, 10, "3296246092", 270},
  {2.1294728744547906873040711e-42, 1, "2", -41},
  {9.9102953258362540824798254e-229, 12, "991029532584", -228},
  {4.5407901201349054987724041e-81, 2, "45", -80},
  {7.0959597063249418569150571e+36, 10, "7095959706", 37},
  {8.3466796179110411674343531e-148, 2, "83", -147},
  {1.4610617657961988281250000e+13, 7, "1461062", 14},
  {1.1456926230728745322573618e+239, 12, "114569262307", 240},
  {4.7448918461300612903391514e-161, 5, "47449", -160},
  {1.1975221809769765445498722e-204, 21, "119752218097697654455", -203},
  {1.9107054315497534039505076e+182, 15, "191070543154975", 183},
  {4.4499559116062074863065008e-42, 4, "445", -41},
  {9.3031070155885777859204512e+35, 9, "930310702", 36},
  {8.2934832915185626234609176e-63, 8, "82934833", -62},
  {3.8786986739222136142771519e+127, 21, "387869867392221361428", 128},
  {6.9637244432716019599767948e-242, 3, "696", -241},
  {9.5751065715668652234359793e-106, 21, "957510657156686522344", -105},
  {3.0804034198394345000132694e+158, 2, "31", 159},
  {3.6666451611597948532272794e+82, 16, "3666645161159795", 83},
  {1.3826911127949288179083503e-180, 19, "1382691112794928818", -179},
  {5.6942979541148343003931450e+154, 1, "6", 155},
  {1.8951836518877604747140107e-34, 8, "18951837", -33},
  {3.3996940905395789432784343e-17, 11, "33996940905", -16},
  {1.0523479571488009499434454e-192, 3, "105", -191},
  {8.5440990662260115581108076e+80, 11, "85440990662", 81},
  {8.2499104025430115755831668e+157, 15, "824991040254301", 158},
  {1.4066838264693744566008977e+128, 14, "14066838264694", 129},
  {6.0791224936732300800000000e+17, 8, "60791225", 18},
  {1.1294434964270063820896419e-245, 16, "1129443496427006", -244},
  {3.5129998987648991406261578e-127, 9, "35129999", -126},
  {1.0494066572930033722638438e+103, 7, "1049407", 104},
  {1.2076536815713921466904985e+79, 6, "120765", 80},
  {5.2626849844751676968387481e-200, 12, "526268498448", -199},
  {3.0749374211314926323289391e+206, 14, "30749374211315", 207},
  {2.8268728257198504518399014e-151, 7, "2826873", -150},
  {3.0098580988704336389924677e-123, 11, "30098580989", -122},
  {1.1197951801009042739971731e-120, 18, "111979518010090427", -119},
  {5.0515604992780746156563677e-192, 16, "5051560499278075", -191},
  {2.0259572543872327889512669e-42, 4, "2026", -41},
  {1.3149579668452812720948374e+75, 17, "13149579668452813", 76},
  {1.8412421995160935059080057e+288, 19, "1841242199516093506", 289},
  {6.5842312984045104480386433e+102, 18, "658423129840451045", 103},
  {1.0295293102583647154967581e-19, 6, "102953", -18},
  {4.1216320182142780141453987e+237, 7, "4121632", 238},
  {2.1551541147941898657336424e+02, 20, "21551541147941898657", 3},
  {4.7028170990293500277491601e+62, 12, "470281709903", 63},
  {3.4515581446298615292675334e+78, 15, "345155814462986", 79},
  {4.5299716671624670194216145e-62, 7, "4529972", -61},
  {5.3437697650056788705280000e+21, 8, "53437698", 22},
  {4.6664134632261567396917469e-238, 19, "466641346322615674", -237},
  {5.6121979852230953861673883e-282, 14, "56121979852231", -281},
  {1.3998665661012239492569044e-270, 2, "14", -269},
  {1.3067133852206111491269471e+284, 21, "130671338522061114913", 285},
  {4.7624373531330428199961574e-224, 4, "4762", -223},
  {1.3129042290150405589320232e-111, 20, "13129042290150405589", -110},
  {1.1363665999280580259410055e-112, 16, "1136366599928058", -111},
  {1.9164638138085680750775638e+197, 7, "1916464", 198},
  {9.4618625858234783105303983e+236, 17, "94618625858234783", 237},
  {4.8104272436768311394552794e+32, 21, "481042724367683113946", 33},
  {6.1086771207783877058768193e-299, 8, "61086771", -298},
  {1.0157436569819203506754135e+291, 8, "10157437", 292},
  {3.7720198987736273437500000e+13, 19, "3772019898773627344", 14},
  {6.0090564898373072525669213e+97, 11, "60090564898", 98},
  {6.1036143413891217767803521e-58, 20, "61036143413891217768", -57},
  {4.8174067792121353149414062e+09, 10, "4817406779", 10},
  {5.8704472099297863680000000e+18, 16, "5870447209929786", 19},
  {5.2628755107421173086448131e+45, 13, "5262875510742", 46},
  {4.6087435798989272128322293e-298, 2, "46", -297},
  {4.0024206377524455649359520e+253, 14, "40024206377524", 254},
  {3.0035054898749768965440131e-111, 10, "300350549", -110},
  {1.4914997554524522322976139e-228, 1, "1", -227},
  {6.5580586456365280664240925e-79, 9, "655805865", -78},
  {2.8777256301023546137829898e-162, 1, "3", -161},
  {1.6555345678306362144329930e-120, 6, "165553", -119},
  {2.8578263035926829427353793e+290, 21, "285782630359268294274", 291},
  {1.0796663259281133541278572e-72, 8, "10796663", -71},
  {4.9171089666531511014210559e+264, 20, "49171089666531511014", 265},
  {1.6234996136927153356800000e+21, 7, "16235", 22},
  {6.7769525274158706033590581e+304, 2, "68", 305},
  {2.6772160027838281849284774e-170, 5, "26772", -169},
  {2.1434172721699901141472602e-98, 13, "214341727217", -97},
  {2.3912915679610705609011211e-154, 5, "23913", -153},
  {1.9173640295369676076772349e-63, 9, "191736403", -62},
  {6.5058338377938498616694101e-161, 5, "65058", -160},
  {5.4824803049043436148083903e-154, 5, "54825", -153},
  {1.8019707419402691159138663e-07, 10, "1801970742", -6},
  {1.2378177508829233997146175e-33, 17, "12378177508829234", -32},
  {9.8712414797515216782432658e-244, 6, "987124", -243},
  {4.2022437326697796433462474e-21, 15, "420224373266978", -20},
  {1.0024872324133769036967786e+288, 12, "100248723241", 289},
  {2.8706700366713439009315301e-75, 14, "28706700366713", -74},
  {1.7995329169395744973982145e+237, 18, "17995329169395745", 238},
  {2.0823493751625434043252377e+277, 20, "20823493751625434043", 278},
  {3.9073750479239802825243554e+110, 4, "3907", 111},
  {1.8886620973562037474658074e-292, 2, "19", -291},
  {3.0078145888075101674516162e+227, 3, "301", 228},
  {3.4198360540934169170309938e-214, 21, "341983605409341691703", -213},
  {1.5355462930100282771707784e-194, 13, "153554629301", -193},
  {3.2853835446377658407303871e+116, 21, "328538354463776584073", 117},
  {9.2923692726324782781113149e+189, 12, "929236927263", 190},
  {7.2148586686348637723315106e-153, 5, "72149", -152},
  {1.2482494190735741786503768e+69, 6, "124825", 70},
  {1.8290487054218037611909687e+230, 8, "18290487", 231},
  {4.5728511078893997649052943e+174, 5, "45729", 175},
  {3.7046236273400447528275574e-61, 4, "3705", -60},
  {3.4553538876323365137064648e-57, 19, "3455353887632336514", -56},
  {1.4577707436105092607271826e-16, 7, "1457771", -15},
  {8.2550877772504092824673481e-251, 6, "825509", -250},
  {4.7945501232559954816694942e-73, 21, "479455012325599548167", -72},
  {5.0696305986938781738281250e+11, 17, "50696305986938782", 12},
  {1.7849387914374457942501527e-243, 18, "178493879143744579", -242},
  {1.3154347601802603233745200e+52, 3, "132", 53},
  {1.2588302043428851110983072e-58, 17, "12588302043428851", -57},
  {7.9128604023558222928943392e+83, 17, "79128604023558223", 84},
  {1.1675051915397887178525639e+29, 21, "116750519153978871785", 30},
  {9.4934134708720241849296608e+235, 11, "94934134709", 236},
  {1.3021705413797208572779835e+301, 14, "13021705413797", 302},
  {1.5576376652591565832210981e+196, 14, "15576376652592", 197},
  {1.8798975578359496663084243e+295, 19, "1879897557835949666", 296},
  {8.0265237925186682956302429e+166, 14, "80265237925187", 167},
  {3.1240560277484562537470793e-238, 21, "312405602774845625375", -237},
  {7.8072699728513129057204002e-228, 9, "780726997", -227},
  {4.9016734900514366149902344e+10, 10, "490167349", 11},
  {4.9656016887675109319388866e+05, 6, "49656", 6},
  {3.0331778940383006754997384e+264, 17, "30331778940383007", 265},
  {1.3583139861662476454641703e+211, 21, "135831398616624764546", 212},
  {1.4526872602466391927794804e-08, 15, "145268726024664", -7},
  {4.8408575352925803046424589e+271, 12, "484085753529", 272},
  {5.7713930975964672761698826e+152, 3, "577", 153},
  {9.6521190949489610890953090e+259, 19, "9652119094948961089", 260},
  {2.7141667088497868469667118e+79, 17, "27141667088497868", 80},
  {3.0325817211342252598344745e+264, 7, "3032582", 265},
  {3.6990956609396783249622805e+264, 2, "37", 265},
  {3.9561502179540878918824974e+87, 1, "4", 88},
  {1.4286638695679939281837856e-17, 21, "142866386956799392818", -16},
  {1.2792738108123958971067473e+266, 18, "12792738108123959", 267},
  {6.8364562761583380833213377e+189, 20, "68364562761583380833", 190},
  {7.0250354786291139097123903e+178, 15, "702503547862911", 179},
  {1.1538198689778095120387054e+88, 15, "115381986897781", 89},
  {4.0306301122432355126955561e-65, 8, "40306301", -64},
  {5.0363043336914468934626884e+115, 16, "5036304333691447", 116},
  {2.6142674124636114651123135e-239, 1, "3", -238},
  {2.4893681523683948963317848e+85, 15, "248936815236839", 86},
  {6.4880563982395448439915628e-125, 1, "6", -124},
  {2.0379020369841469916432552e-182, 7, "2037902", -181},
  {1.0699473441027106666319292e-41, 9, "106994734", -40},
  {2.7385170659501166210047198e-39, 19, "2738517065950116621", -38},
  {5.1624465942369575234205745e-11, 8, "51624466", -10},
  {4.1755985629647872293061758e-82, 9, "417559856", -81},
  {9.5406069539959018584340811e+05, 8, "9540607", 6},
  {5.2355540156330498896383527e+159, 8, "5235554", 160},
  {1.6035078921780657522933224e+65, 20, "16035078921780657523", 66},
  {6.2922471937201694589280955e+35, 7, "6292247", 36},
  {2.7380784851298947001217934e+251, 10, "2738078485", 252},
  {8.5172156648662915989279985e-258, 15, "851721566486629", -257},
  {1.6127967322778864670248070e+99, 20, "1612796732277886467", 100},
  {8.3528762563957844939502788e-15, 5, "83529", -14},
  {1.1651284293262287963123199e+236, 13, "1165128429326", 237},
  {1.6880540699174914713773210e-77, 9, "168805407", -76},
  {6.3179489440203979857063899e-17, 8, "63179489", -16},
  {7.4812561786625199685406708e-207, 9, "748125618", -206},
  {3.0482157256651320457458496e+09, 1, "3", 10},
  {4.0565318964475292683392995e-200, 12, "405653189645", -199},
  {1.1175958178686408469729139e-160, 6, "11176", -159},
  {2.1136188011368430316620857e-88, 19, "2113618801136843032", -87},
  {1.0316003070886576495786303e-08, 20, "10316003070886576496", -7},
  {1.5542118267966817611707409e-265, 8, "15542118", -264},
  {6.5265926212583395644695161e-95, 8, "65265926", -94},
  {1.2457626593219782356399168e-05, 18, "124576265932197824", -4},
  {2.3693738671000975731839909e+282, 14, "23693738671001", 283},
  {1.2661193897156372556445092e-01, 7, "1266119", 0},
  {4.2470113605069404988215579e+187, 18, "42470113605069405", 188},
  {2.4993495108662805480646347e-231, 21, "249934951086628054806", -230},
  {5.5752233516102174992780124e+192, 1, "6", 193},
  {4.1014974251686835077869469e-276, 9, "410149743", -275},
  {8.4916988825476886139774862e-153, 14, "84916988825477", -152},
  {7.4414317907745987669399790e+141, 12, "744143179077", 142},
  {1.1809052605154173393796481e+200, 20, "11809052605154173394", 201},
  {1.3569263627465713134322011e+156, 3, "136", 157},
  {3.0524110819984827679675067e-246, 8, "30524111", -245},
  {5.0586808437051120400560189e-169, 15, "505868084370511", -168},
  {3.1295070975945389982087934e+199, 9, "31295071", 200},
  {7.4773596928484034782772506e+290, 2, "75", 291},
  {1.0263784860629476548620901e-134, 15, "102637848606295", -133},
  {6.9443297301376936780876908e-44, 18, "694432973013769368", -43},
  {3.9971034201157435695735022e+179, 4, "3997", 180},
  {2.7621870233979333853700852e-57, 4, "2762", -56},
  {5.9760195591340137166091042e+104, 6, "597602", 105},
  {4.8026290044694675123942139e+279, 21, "480262900446946751239", 280},
  {5.6088348399432017519530394e+283, 6, "560883", 284},
  {2.5214081744593607821226225e-158, 21, "252140817445936078212", -157},
  {4.1628921813011499311053576e-157, 15, "416289218130115", -156},
  {4.0995436253778258425234792e-11, 19, "4099543625377825843", -10},
  {2.2077188377527852280356570e-230, 18, "220771883775278523", -229},
  {2.1676002353208758373996458e-33, 1, "2", -32},
  {3.5670533566150312401724200e-70, 4, "3567", -69},
  {4.1552779178328369482198349e+147, 3, "416", 148},
  {1.7250894112223765604042989e+35, 5, "17251", 36},
  {2.7138329348876061786167872e-124, 19, "2713832934887606179", -123},
  {1.3587390117463921088553170e-34, 10, "1358739012", -33},
  {1.0941609514274267561960239e+46, 3, "109", 47},
  {2.7314777877101085749310088e-197, 18, "273147778771010857", -196},
  {5.7711100718368944042017919e-236, 18, "57711100718368944", -235},
  {6.5676749624214005609639045e-292, 8, "6567675", -291},
  {4.2879996423738714634900881e+177, 6, "4288", 178},
  {3.4721144055833155463345050e-31, 20, "34721144055833155463", -30},
  {1.1933718506868406425237413e-97, 5, "11934", -96},
  {1.8905590910042396899370942e+03, 10, "1890559091", 4},
  {5.8274703195898394965986016e-37, 1, "6", -36},
  {1.3080943781897279530536719e+283, 14, "13080943781897", 284},
  {3.1033817111490648291044894e-117, 13, "3103381711149", -116},
  {1.7484162223001181030446071e-181, 15, "174841622230012", -180},
  {3.3616105894458705057883551e-256, 2, "34", -255},
  {4.0287603437349637842233293e+266, 15, "402876034373496", 267},
  {4.5397383861153754420919701e+122, 16, "4539738386115375", 123},
  {8.9884438263681443927493516e-162, 8, "89884438", -161},
  {1.5025443210454997220397973e+264, 13, "1502544321045", 265},
  {5.2689696717194897335428577e+278, 7, "526897", 279},
  {3.6238235883530090494375552e-227, 13, "3623823588353", -226},
  {1.1069996577937237101848576e+70, 17, "11069996577937237", 71},
  {1.9682937478319814722152966e-10, 5, "19683", -9},
  {2.3788951380723186362411406e-107, 5, "23789", -106},
  {9.7062512356626779863990655e-36, 4, "9706", -35},
  {3.4887118811775496490815390e+100, 5, "34887", 101},
  {1.5812337722189319835709048e+202, 12, "158123377222", 203},
  {1.0315576526616854304637280e-57, 4, "1032", -56},
  {2.0404124741452827890255364e-87, 15, "204041247414528", -86},
  {1.3558654934928472483455006e-174, 9, "135586549", -173},
  {1.6216740277983108535408974e+05, 12, "16216740278", 6},
  {1.9219585009435375814143340e-76, 21, "192195850094353758141", -75},
  {3.0249750811162672581825335e+306, 15, "302497508111627", 307},
  {8.4036764261395686805797904e+212, 21, "840367642613956868058", 213},
  {7.3312473499675743054832154e-245, 15, "733124734996757", -244},
  {1.1309027403603053323582565e-57, 18, "113090274036030533", -56},
  {1.0103622977757584392259037e+252, 16, "1010362297775758", 253},
  {3.5545037903374133346024414e-45, 8, "35545038", -44},
  {1.8388265112149518208202770e-113, 17, "18388265112149518", -112},
  {1.4776064701329022296456920e-143, 12, "147760647013", -142},
  {3.1679897846122264812464873e-81, 8, "31679898", -80},
  {2.1632480822489088160992909e-83, 17, "21632480822489088", -82},
  {4.7851845697720653937973409e-237, 7, "4785185", -236},
  {2.8383739346518879024191326e+61, 18, "28383739346518879", 62},
  {2.2957609970025736455216759e-215, 5, "22958", -214},
  {5.1452247747756690120516284e-152, 17, "5145224774775669", -151},
  {1.0664731246137888257883563e+294, 15, "106647312461379", 295},
  {1.6344274638601971878312165e-63, 7, "1634427", -62},
  {7.3451270530742386073524763e-195, 6, "734513", -194},
  {7.5025098447247939461222861e+222, 4, "7503", 223},
  {1.9675079284771907464237247e+297, 21, "196750792847719074642", 298},
  {1.4781944325461337155672753e-84, 19, "1478194432546133716", -83},
  {5.2333046435815742949221178e+260, 4, "5233", 261},
  {1.1909212718451158171256137e-53, 3, "119", -52},
  {1.8903406343435904249947612e-12, 5, "18903", -11},
  {1.4612788577993205763050355e+03, 19, "1461278857799320576", 4},
  {1.9346881240283329912730548e+124, 14, "19346881240283", 125},
  {3.0155654951920656686947325e+209, 18, "301556549519206567", 210},
  {2.0254450239536054940364707e+260, 19, "2025445023953605494", 261},
  {7.4334489174151678673383084e+257, 17, "74334489174151679", 258},
  {1.9338713986825889470694226e+104, 11, "19338713987", 105},
  {1.0261468214757080587504484e-72, 7, "1026147", -71},
  {9.6820845001734171583089855e-303, 14, "96820845001734", -302},
  {4.3492514758528681934027850e-26, 3, "435", -25},
  {4.1533089974652198143303394e+06, 4, "4153", 7},
  {4.5928481158486545376189296e+213, 11, "45928481158", 214},
  {1.4631216018048871964937204e-31, 3, "146", -30},
  {2.1563045240296473926067979e+297, 3, "216", 298},
  {3.4248212926883498367850527e+124, 14, "34248212926883", 125},
  {1.6404832420755964690432000e+22, 21, "164048324207559646904", 23},
  {7.3383194385994903912763804e-182, 19, "7338319438599490391", -181},
  {4.8279519166677670704639310e-222, 8, "48279519", -221},
  {5.9803690797722788495515802e+125, 12, "598036907977", 126},
  {2.0695309796542277780166149e+260, 15, "206953097965423", 261},
  {4.4803614408130927575168149e-92, 12, "448036144081", -91},
  {1.4038964415776983452246363e+166, 21, "140389644157769834522", 167},
  {1.1182965700411537041426438e+175, 4, "1118", 176},
  {6.8094552691507822919991809e-134, 7, "6809455", -133},
  {9.8123408252436485313685997e+201, 5, "98123", 202},
  {1.9311106139552882743410041e-204, 16, "1931110613955288", -203},
  {2.9871082941625039416504703e-174, 11, "29871082942", -173},
  {5.1423967383548169206641924e-23, 9, "514239674", -22},
  {9.3193228740273870483186371e+254, 20, "93193228740273870483", 255},
  {1.1470641658821930197663924e-46, 8, "11470642", -45},
  {2.0566415295703841413782983e-107, 2, "21", -106},
  {5.5111565420973739585500217e-210, 10, "5511156542", -209},
  {1.8211308811447809613814675e+290, 17, "1821130881144781", 291},
  {4.4764005553796139963429468e-04, 2, "45", -3},
  {4.3462031041415537109375000e+12, 13, "4346203104142", 13},
  {1.1546504676444854565665104e+46, 9, "115465047", 47},
  {7.7523890044815502438866678e+143, 14, "77523890044816", 144},
  {3.7202689863304497029699245e+178, 2, "37", 179},
  {5.9402650279886886400000000e+17, 4, "594", 18},
  {7.2900669625385440815653619e+143, 5, "72901", 144},
  {6.1436877419812071051910100e+259, 8, "61436877", 260},
  {8.1003390059948030291606696e-114, 8, "8100339", -113},
  {1.2545039861882717656111501e-84, 1, "1", -83},
  {3.0655653964740254632260100e-10, 12, "306556539647", -9},
  {7.1076486272902310511654065e+226, 14, "71076486272902", 227},
  {5.8593241945936014585332959e-65, 20, "58593241945936014585", -64},
  {2.1464596291522300844921961e+284, 19, "2146459629152230084", 285},
  {5.2196768035165975741904921e+234, 2, "52", 235},
  {1.5335576259548082322633884e-193, 18, "153355762595480823", -192},
  {6.3195380227863138711574547e-150, 14, "63195380227863", -149},
  {4.8962038470132656661647105e+117, 4, "4896", 118},
  {5.1849558012166331561131801e+159, 18, "518495580121663316", 160},
  {6.7655946101135123696033655e-06, 4, "6766", -5},
  {6.3106722783860081050088778e+115, 9, "631067228", 116},
  {3.8839454110512284503990936e+297, 7, "3883945", 298},
  {2.1842790973502864200411753e+213, 4, "2184", 214},
  {6.0363289931052671143494289e-31, 17, "60363289931052671", -30},
  {5.5375676468235065248290047e-174, 8, "55375676", -173},
  {1.4977233133876302550137030e-288, 13, "1497723313388", -287},
  {3.0181231739438621753553702e+77, 21, "301812317394386217536", 78},
  {1.3017681794186024629251374e-239, 20, "13017681794186024629", -238},
  {8.9210608545724243698023288e+144, 16, "8921060854572424", 145},
  {3.1519715568763175698367661e-60, 6, "315197", -59},
  {6.9303870563142410097693616e+236, 1, "7", 237},
  {2.9886084542541278586767074e+66, 10, "2988608454", 67},
  {3.1499752036813786424955930e+72, 15, "314997520368138", 73},
  {3.1221549795378836362468226e+285, 14, "31221549795379", 286},
  {3.9163409245476533971199058e+90, 2, "39", 91},
  {1.0359376625324470493494269e-160, 2, "1", -159},
  {4.4261934011583953037631246e-79, 16, "4426193401158395", -78},
  {2.1998913378498813067672910e+38, 15, "219989133784988", 39},
  {6.8864827094733971372867658e+61, 2, "69", 62},
  {2.8776550690069018912975496e+289, 11, "2877655069", 290},
  {1.4603431159597683238549492e-132, 10, "1460343116", -131},
  {1.7600677457524653994438924e+131, 14, "17600677457525", 132},
  {1.5534620003530088034471936e+186, 4, "1553", 187},
  {2.3911585845246403571419406e+278, 9, "239115858", 279},
  {3.7307264987926719076936730e+260, 20, "37307264987926719077", 261},
  {1.2104514582712007714748140e+188, 18, "121045145827120077", 189},
  {9.0295277814861512576744637e-277, 10, "9029527781", -276},
  {1.5994680652422330728792463e-142, 21, "159946806524223307288", -141},
  {1.6207698709502151308051529e-24, 13, "162076987095", -23},
  {5.9105494769818268413468753e+165, 16, "5910549476981827", 166},
  {7.8613363801080574699855377e-188, 4, "7861", -187},
  {5.7602136959975960975354284e-128, 18, "57602136959975961", -127},
  {4.2516860505046286620366411e+252, 7, "4251686", 253},
  {3.3937798069402040347626625e-164, 16, "3393779806940204", -163},
  {7.0776554295215283337307086e+39, 16, "7077655429521528", 40},
  {1.8424492443491235697383474e-242, 11, "18424492443", -241},
  {3.9348229864671604860077451e+150, 18, "393482298646716049", 151},
  {1.4858580099145149440000000e+18, 19, "1485858009914514944", 19},
  {8.0618304728249627941948122e+222, 2, "81", 223},
  {1.8565160779184108339200000e+20, 6, "185652", 21},
  {4.1621923418648370861361254e+94, 9, "416219234", 95},
  {1.6895321971461375373036007e-196, 6, "168953", -195},
  {5.9047603491339697296225943e-166, 1, "6", -165},
  {8.5661213066833961280403779e+83, 20, "8566121306683396128", 84},
  {6.5627130788221414647409983e-224, 15, "656271307882214", -223},
  {6.0677515478255735547303439e+226, 9, "606775155", 227},
  {5.6036159538244295536960491e-157, 10, "5603615954", -156},
  {2.2205722844704278001672882e-69, 1, "2", -68},
  {2.0644447436551800287779081e-75, 4, "2064", -74},
  {5.5723335021925236630661375e-195, 4, "5572", -194},
  {2.3731657898643735464814704e-290, 12, "237316578986", -289},
  {1.1633625671471414791183574e-29, 15, "116336256714714", -28},
  {9.6608130907595915940848994e+226, 6, "966081", 227},
  {6.5723210575298884222597644e-284, 20, "65723210575298884223", -283},
  {2.1129019846693533477488200e-05, 8, "2112902", -4},
  {7.6017753487077905312943683e-71, 3, "76", -70},
  {4.1330475532433288234794198e-64, 15, "413304755324333", -63},
  {3.2705005296552108280330266e-31, 12, "327050052966", -30},
  {1.0307186370821458999019346e+60, 6, "103072", 61},
  {1.1756640289611154865502315e-145, 5, "11757", -144},
  {1.3737242278228660164017810e+64, 13, "1373724227823", 65},
  {8.4408492049141010841058516e+162, 17, "84408492049141011", 163},
  {3.3976481909334015035384249e+300, 7, "3397648", 301},
  {1.4454600876534830836423635e+253, 7, "144546", 254},
  {2.2219283510520543319937211e+306, 6, "222193", 307},
  {2.7367529227420334353322142e-243, 9, "273675292", -242},
  {2.6568025868364615084756940e-34, 19, "2656802586836461508", -33},
  {1.0588600655811206975831202e-16, 8, "10588601", -15},
  {1.8599335245292381510498425e+179, 3, "186", 180},
  {6.5798399883797555613219195e-29, 8, "657984", -28},
  {8.6481736966183951434229211e+118, 10, "8648173697", 119},
  {9.7772224281045947121090492e+46, 3, "978", 47},
  {1.8182471086782100037977454e-20, 6, "181825", -19},
  {6.9595902020394639684343952e+279, 20, "69595902020394639684", 280},
  {7.8251355797179730897523185e-170, 9, "782513558", -169},
  {7.2981171903646460610511204e+166, 8, "72981172", 167},
  {2.7182308643606460383402310e+153, 3, "272", 154},
  {1.4462253803268663620683129e+204, 19, "1446225380326866362", 205},
  {1.0732341800686979646120145e+222, 20, "10732341800686979646", 223},
  {2.2045924193672497436473392e-250, 8, "22045924", -249},
  {1.1714485488407113382899457e-94, 1, "1", -93},
  {3.8538446973446632385253906e+10, 12, "385384469734", 11},
  {1.7020710790448831038823554e-38, 8, "17020711", -37},
  {9.4763271633395428451001591e-128, 16, "9476327163339543", -127},
  {8.1156753120319387992072231e+97, 6, "811568", 98},
  {1.3128075368606742687246158e+39, 13, "1312807536861", 40},
  {3.9453036784327721546647093e-187, 7, "3945304", -186},
  {4.0814907785232519186024070e-171, 17, "40814907785232519", -170},
  {5.8190063261184404690951068e+231, 20, "58190063261184404691", 232},
  {1.6003343412115958279247415e+245, 8, "16003343", 246},
  {9.2795638801579380150665156e-263, 11, "92795638802", -262},
  {3.7815669435257449855137935e-117, 3, "378", -116},
  {5.0448329728286149740969681e+307, 2, "5", 308},
  {1.2153768594298106499185193e+204, 18, "121537685942981065", 205},
  {2.6637667011919903541166080e+24, 12, "266376670119", 25},
  {3.4127045736172442223486655e+46, 13, "3412704573617", 47},
  {4.4579953428751130426476381e+299, 10, "4457995343", 300},
  {5.9431124641450112745694058e+35, 18, "594311246414501127", 36},
  {5.1401046250826426331561208e+264, 12, "514010462508", 265},
  {4.3839612085175384948676445e-72, 11, "43839612085", -71},
  {1.9499673661419346809408856e-185, 12, "194996736614", -184},
  {5.8162665845990362645879361e+52, 13, "5816266584599", 53},
  {1.4230014296553288026244040e+262, 6, "1423", 263},
  {1.5655307123300170113555163e-124, 17, "1565530712330017", -123},
  {7.2181182257432235080948706e-152, 5, "72181", -151},
  {1.5569209770563740144641542e-210, 4, "1557", -209},
  {1.0028604841374165301788268e-253, 5, "10029", -252},
  {1.2689463788390561523437500e+12, 8, "12689464", 13},
  {1.3115594809159674333779448e-223, 12, "131155948092", -222},
  {2.0499059716693109136338097e-102, 14, "20499059716693", -101},
  {4.1927823976899589151532042e-16, 14, "419278239769", -15},
  {3.7286351712963207566295672e+63, 2, "37", 64},
  {3.3247793075230519292872761e-192, 4, "3325", -191},
  {5.5289965814471544642952239e-40, 16, "5528996581447154", -39},
  {8.7680236093380835825523122e+195, 18, "876802360933808358", 196},
  {1.7062495492107677801566196e-255, 17, "17062495492107678", -254},
  {8.3559933107438809335026236e-231, 1, "8", -230},
  {6.6983982904150364344079581e-308, 2, "67", -307},
  {1.5663214012627870596451696e-277, 19, "156632140126278706", -276},
  {1.8160228756246963911594261e+77, 14, "18160228756247", 78},
  {2.6432363932867244337897347e-148, 5, "26432", -147},
  {2.0070381409851599752041277e-106, 11, "2007038141", -105},
  {2.0003540250684800238781093e-10, 9, "200035403", -9},
  {2.5978743165690715816404198e+258, 9, "259787432", 259},
  {6.5903647395614263047967009e+72, 5, "65904", 73},
  {4.7622579131959947559110684e+238, 3, "476", 239},
  {8.1646541323393872081578515e+96, 17, "81646541323393872", 97},
  {7.7109535329137954347662368e+157, 1, "8", 158},
  {2.0918504635655312500000000e+15, 21, "209185046356553125", 16},
  {5.8205358040034202912494224e-276, 21, "582053580400342029125", -275},
  {5.0129021628057362522014791e-102, 6, "50129", -101},
  {6.3814291913897326665735777e-276, 6, "638143", -275},
  {6.4957358823499541831768487e-63, 11, "64957358823", -62},
  {1.3604014645414107008555370e+53, 16, "1360401464541411", 54},
  {2.9682679430060101885438769e+32, 2, "3", 33},
  {1.2737809413749922700012735e-147, 16, "1273780941374992", -146},
  {3.0513606986977638805998014e-158, 1, "3", -157},
  {4.7137925773356094794053206e+01, 13, "4713792577336", 2},
  {1.2489761504759528194578841e+288, 17, "12489761504759528", 289},
  {3.3343188065734146288285210e-68, 2, "33", -67},
  {1.4335269432402190438981245e-156, 10, "1433526943", -155},
  {1.5428889043761967739781795e+108, 4, "1543", 109},
  {1.3138790157757274858933329e-275, 15, "131387901577573", -274},
  {2.0785353739257081856000000e+19, 1, "2", 20},
  {4.7702951939202934067729138e+198, 10, "4770295194", 199},
  {4.7871966115232413966781498e-51, 4, "4787", -50},
  {1.8722194801568980068882745e-302, 3, "187", -301},
  {2.0881593976328712360932349e-42, 3, "209", -41},
  {5.7722847266443151149946124e+125, 3, "577", 126},
  {3.5569789171366578476135244e-48, 18, "355697891713665785", -47},
  {4.1884248890136257249137838e-194, 9, "418842489", -193},
  {7.2848266561496304123770186e-279, 14, "72848266561496", -278},
  {6.4074558985264511484643627e-228, 15, "640745589852645", -227},
  {2.1261321575721007635434453e-35, 5, "21261", -34},
  {7.1084667890661120659489094e-255, 4, "7108", -254},
  {8.3074175181663024541089572e-227, 20, "83074175181663024541", -226},
  {2.6077894831155791219153573e+82, 11, "26077894831", 83},
  {4.1558646904436314774976433e-44, 10, "415586469", -43},
  {6.8408478649226982688440025e+69, 10, "6840847865", 70},
  {3.1880910423742312609730834e+244, 19, "3188091042374231261", 245},
  {1.2990246322700394156090478e+162, 5, "1299", 163},
  {3.5442392001204966648969554e+202, 17, "35442392001204967", 203},
  {1.4050335894596260364795026e+124, 6, "140503", 125},
  {1.1720914399762583592285046e-284, 17, "11720914399762584", -283},
  {1.0339418822930322816276678e-152, 8, "10339419", -151},
  {4.2311156527933917160790445e+235, 7, "4231116", 236},
  {3.1870869296972872574846689e-291, 1, "3", -290},
  {3.9111382718368859934944831e+102, 15, "391113827183689", 103},
  {9.0641991458810787207767135e+02, 11, "90641991459", 3},
  {2.7174099711906601598384849e+57, 9, "271740997", 58},
  {2.1735140135521651790505755e+131, 16, "2173514013552165", 132},
  {2.3269446989798526763916016e+10, 4, "2327", 11},
  {1.0186661557979478791747971e+148, 4, "1019", 149},
  {1.9778234019496224879041782e+40, 12, "197782340195", 41},
  {7.7720072796599372110512619e-94, 7, "7772007", -93},
  {8.1401934048294422030522810e-01, 18, "81401934048294422", 0},
  {6.8727213412068088643943720e+50, 12, "687272134121", 51},
  {9.0139607355066440727994557e+95, 3, "901", 96},
  {1.6939948870496838674793422e-205, 14, "16939948870497", -204},
  {2.1174107815846766422769996e-72, 3, "212", -71},
  {3.4409098749139354817203649e+233, 14, "34409098749139", 234},
  {2.8014754258087398571832909e+197, 8, "28014754", 198},
  {2.8929265029771086118438524e-92, 6, "289293", -91},
  {8.0504546168635592533829107e+198, 5, "80505", 199},
  {2.8691763318467689158259570e+148, 13, "2869176331847", 149},
  {1.0516816419460136749863962e+114, 21, "105168164194601367499", 115},
  {3.8443576082884256546879359e+64, 7, "3844358", 65},
  {1.0339110791090623592598264e-141, 16, "1033911079109062", -140},
  {1.3075106951847890309306203e-253, 8, "13075107", -252},
  {5.2940831149829500951462664e-293, 8, "52940831", -292},
  {9.5943930511619935027892281e+116, 20, "95943930511619935028", 117},
  {1.7428980057727159455261264e+47, 19, "1742898005772715946", 48},
  {1.2856340425029341437447021e+159, 6, "128563", 160},
  {1.5764676099578989953612236e-204, 7, "1576468", -203},
  {5.9740637791717972562541881e+235, 21, "597406377917179725625", 236},
  {1.2918917709193557456362982e+266, 2, "13", 267},
  {2.5710849676439036000000000e+16, 5, "25711", 17},
  {7.3040979107270813086406034e+264, 1, "7", 265},
  {2.4590538318140974248829684e+293, 11, "24590538318", 294},
  {1.3206106618975810999287966e+73, 19, "13206106618975811", 74},
  {2.0764620547975228493115637e-229, 4, "2076", -228},
  {3.8494654110969143470434210e+130, 2, "38", 131},
  {2.4666178263241430525067968e+162, 5, "24666", 163},
  {6.0622025406281711581144412e+189, 9, "606220254", 190},
  {3.4593680523385476000000000e+16, 7, "3459368", 17},
  {1.0666049191655759251584015e-218, 12, "106660491917", -217},
  {7.9825661125289567828471199e+274, 17, "79825661125289568", 275},
  {7.7761109385640736375524589e+176, 1, "8", 177},
  {2.1800712938553546436826675e-279, 21, "218007129385535464368", -278},
  {1.0857987377785331652033924e-62, 17, "10857987377785332", -61},
  {3.7280614366150220306316641e-137, 21, "372806143661502203063", -136},
  {1.3989609203468211453687090e+69, 15, "139896092034682", 70},
  {7.1420333458117071723509114e-46, 5, "7142", -45},
  {1.1839306205109245203625148e+275, 3, "118", 276},
  {4.0643432103976679384742232e+199, 7, "4064343", 200},
  {6.2689715023128881221580281e-54, 19, "6268971502312888122", -53},
  {2.4552549223252655477182024e-234, 12, "245525492233", -233},
  {1.5245110276841272050296895e+66, 3, "152", 67},
  {1.7236393791661813116175280e-272, 5, "17236", -271},
  {5.7385594051475113368336851e-187, 2, "57", -186},
  {3.2812813448809845771579037e-144, 15, "328128134488098", -143},
  {4.1097750672958531643001102e+144, 21, "41097750672958531643", 145},
  {2.1908765009586172619237978e-234, 20, "21908765009586172619", -233},
  {2.0206333208165700295130493e-207, 16, "202063332081657", -206},
  {2.4027093126270433588671604e-254, 10, "2402709313", -253},
  {9.6937258768165033664638325e+209, 19, "9693725876816503366", 210},
  {1.3456649003344670045185294e-65, 5, "13457", -64},
  {1.5958642600239271097088770e+74, 12, "159586426002", 75},
  {2.4139542835455115636186708e-53, 3, "241", -52},
  {4.3271357312790388817258212e+44, 11, "43271357313", 45},
  {4.0970381748889813079570696e-92, 20, "4097038174888981308", -91},
  {7.8196564744185646586547526e+236, 19, "7819656474418564659", 237},
  {4.4450836462012439958479017e+254, 10, "4445083646", 255},
  {2.2119166898795436980471966e+115, 19, "2211916689879543698", 116},
  {9.1461224520378409892229934e+82, 3, "915", 83},
  {2.0335328196060627670162856e+166, 1, "2", 167},
  {8.0618920001505728936757485e+175, 14, "80618920001506", 176},
  {2.7017164906552792488837171e-86, 14, "27017164906553", -85},
  {5.2969269221743345609679812e-75, 3, "53", -74},
  {1.7710919752984381063489244e-85, 20, "17710919752984381063", -84},
  {1.1286181612633261466619869e+33, 3, "113", 34},
  {2.4246141757227117212083900e+288, 10, "2424614176", 289},
  {3.3486280987524221468911276e+183, 21, "334862809875242214689", 184},
  {2.5229426627739911316201073e+233, 16, "2522942662773991", 234},
  {1.9937414871892485141442545e-288, 9, "199374149", -287},
  {3.8782159070528625948753778e-77, 17, "38782159070528626", -76},
  {1.2773269531009436744321669e-51, 4, "1277", -50},
  {1.0424983243784993986304635e+198, 15, "10424983243785", 199},
  {1.2317759192585718669750439e-116, 16, "1231775919258572", -115},
  {7.2153758587651195635729082e+111, 19, "7215375858765119564", 112},
  {1.3033687217531793001749695e-170, 18, "13033687217531793", -169},
  {2.4570753406259386532271857e-17, 20, "24570753406259386532", -16},
  {6.9657857555980908264653578e-71, 8, "69657858", -70},
  {1.8756741772026754127556029e-116, 11, "18756741772", -115},
  {7.3730199298332356835478924e-13, 19, "7373019929833235684", -12},
  {5.9361883652728844503529096e-233, 3, "594", -232},
  {6.7482181112767639762365805e-292, 5, "67482", -291},
  {1.5199184631053266601562500e+12, 13, "1519918463105", 13},
  {3.3379926515602612692912822e-296, 20, "33379926515602612693", -295},
  {6.9551761008427168221947118e-152, 19, "6955176100842716822", -151},
  {2.9047083763832267482536353e-225, 18, "290470837638322675", -224},
  {1.5543462087681155917473515e-220, 11, "15543462088", -219},
  {1.5990337673732412859140300e-161, 4, "1599", -160},
  {6.2760713786731665741259039e+92, 20, "62760713786731665741", 93},
  {6.3631416218717108557657629e+227, 14, "63631416218717", 228},
  {7.7032798236536761838575938e-236, 10, "7703279824", -235},
  {2.2757083117439562283447237e+277, 3, "228", 278},
  {2.1340921658897166516143815e-81, 9, "213409217", -80},
  {1.0412712782884090540084304e+127, 10, "1041271278", 128},
  {3.6094903810211829721217393e-232, 2, "36", -231},
  {9.6758673642664109592087760e+196, 9, "967586736", 197},
  {2.4434185818152962556555137e-272, 21, "244341858181529625566", -271},
  {4.7307287787509385373792772e+170, 1, "5", 171},
  {6.9959569597685322832270827e+174, 12, "699595695977", 175},
  {1.9716888238668118949652705e+49, 11, "19716888239", 50},
  {6.8351094435434274813499393e+293, 15, "683510944354343", 294},
  {4.6873649400693233583107223e-129, 8, "46873649", -128},
  {4.1945716800547398931533816e-158, 9, "419457168", -157},
  {4.3777089713017898611724377e+05, 14, "43777089713018", 6},
  {9.4394161789968278428593577e+48, 19, "9439416178996827843", 49},
  {9.8592760046876280091245803e+240, 8, "9859276", 241},
  {6.7621789389011589175567129e+101, 6, "676218", 102},
  {5.8263168785029017571108634e+302, 1, "6", 303},
  {5.9191827651809965789284443e+226, 12, "591918276518", 227},
  {9.7094550455714345033577795e+62, 11, "97094550456", 63},
  {8.3872250687179285858798387e-293, 14, "83872250687179", -292},
  {3.4263062692826963465653336e+294, 6, "342631", 295},
  {1.7548086520010902040144564e+256, 8, "17548087", 257},
  {3.0617727210711498901056227e+100, 19, "306177272107114989", 101},
  {2.8626725866300660216091092e+277, 2, "29", 278},
  {6.0160235440182586181684374e-229, 13, "6016023544018", -228},
  {1.4653337482944787578946049e+173, 7, "1465334", 174},
  {2.9717777888745459077138499e-40, 18, "297177778887454591", -39},
  {2.0023074292482233258667742e-246, 9, "200230743", -245},
  {7.8445808756056337783065267e+294, 7, "7844581", 295},
  {8.7378627931453255156906621e+247, 14, "87378627931453", 248},
  {6.2518004788182371183473966e+84, 17, "62518004788182371", 85},
  {8.7780455547098012918519208e+80, 15, "87780455547098", 81},
  {2.1589164008030202159729909e+167, 14, "2158916400803", 168},
  {1.9029348132975114276632667e+05, 21, "190293481329751142766", 6},
  {4.1861728996117191053373207e-220, 3, "419", -219},
  {4.3648394430867813591971856e-193, 12, "436483944309", -192},
  {3.6016945413304089737156568e+173, 8, "36016945", 174},
  {3.8320386798466101478041293e-59, 19, "3832038679846610148", -58},
  {1.4345660728790316930973315e-164, 11, "14345660729", -163},
  {4.1536399352251729875403666e+176, 5, "41536", 177},
  {2.8107165734834293080145044e-91, 17, "28107165734834293", -90},
  {1.7168898946122252799286584e+86, 10, "1716889895", 87},
  {1.4152700864927708200178132e-244, 18, "141527008649277082", -243},
  {3.0781750447273504398782844e+75, 11, "30781750447", 76},
  {3.9842381627893137024140707e-76, 3, "398", -75},
  {1.7093342594023710548250942e+55, 11, "17093342594", 56},
  {9.1271789397999890136718750e+11, 9, "912717894", 12},
  {4.8835839582311453822916344e+125, 9, "488358396", 126},
  {1.2073276724569624018620551e-295, 11, "12073276725", -294},
  {2.7656844752902057926888469e+41, 19, "2765684475290205793", 42},
  {3.7569290744867265552064028e+94, 20, "37569290744867265552", 95},
  {9.3537452770491636846281537e-22, 16, "9353745277049164", -21},
  {7.8796949311920216216390691e-224, 11, "78796949312", -223},
  {1.2541840305327258326470774e+143, 11, "12541840305", 144},
  {3.1712899106708432811069724e+246, 18, "317128991067084328", 247},
  {8.9852309089413736326967634e-08, 18, "898523090894137363", -7},
  {2.3871543500943421090537220e+266, 6, "238715", 267},
  {4.2383331448155109995114684e-97, 19, "4238333144815511", -96},
  {9.9816677451162153206092889e+134, 6, "998167", 135},
  {1.0215926182074433065505589e+162, 5, "10216", 163},
  {2.3491511431319480116619536e+147, 12, "234915114313", 148},
  {2.6316702452208893935927338e-122, 14, "26316702452209", -121},
  {1.9212338051590314975273285e+307, 8, "19212338", 308},
  {2.1919042919606668372252281e-259, 1, "2", -258},
  {4.5906789561369322590088534e-305, 11, "45906789561", -304},
  {2.0888498646524375814777879e-231, 10, "2088849865", -230},
  {1.0834098915965764485175758e+184, 9, "108340989", 185},
  {9.1572332124881472765958043e+73, 9, "915723321", 74},
  {5.4025364890306104837758408e+213, 9, "540253649", 214},
  {6.5932468396891025741281643e+192, 5, "65932", 193},
  {9.5797121275397758238502340e-51, 7, "9579712", -50},
  {3.7106408614682802094852787e-299, 10, "3710640861", -298},
  {4.7711943362867333059855457e-61, 18, "477119433628673331", -60},
  {4.9828381652318769508020742e-53, 15, "498283816523188", -52},
  {5.5455961652511424830128784e+48, 18, "554559616525114248", 49},
  {1.0963001478486446311480122e-249, 16, "1096300147848645", -248},
  {6.2945545586409456652915195e-156, 13, "6294554558641", -155},
  {1.3648010031800745617504887e-34, 13, "136480100318", -33},
  {1.9323107894022697778909519e+186, 21, "193231078940226977789", 187},
  {2.1476638479948484485403147e+74, 17, "21476638479948484", 75},
  {5.9909490025430388224522707e-58, 9, "5990949", -57},
  {3.0796597573462050998097213e-219, 4, "308", -218},
  {1.7120627009632294221400107e+251, 7, "1712063", 252},
  {3.7234883694744176497221173e-237, 2, "37", -236},
  {4.7032574160290745246909629e-147, 4, "4703", -146},
  {4.3077698274952319715760449e-64, 21, "430776982749523197158", -63},
  {9.6063126402261950031236269e-245, 21, "960631264022619500312", -244},
  {1.1411639818633397262109274e+157, 12, "114116398186", 158},
  {1.2525428509922749445286690e-117, 3, "125", -116},
  {7.4112360274377325582715514e-56, 9, "741123603", -55},
  {9.5293663910087448263450395e-66, 18, "952936639100874483", -65},
  {2.4606222691585739450293552e+88, 7, "2460622", 89},
  {5.9081895747966614295379021e+188, 5, "59082", 189},
  {1.4103638431599012350955842e-197, 5, "14104", -196},
  {1.1339654708163962894437699e+193, 8, "11339655", 194},
  {1.5885681319116374671388993e+81, 16, "1588568131911637", 82},
  {4.5794200670132049702842735e-296, 13, "4579420067013", -295},
  {9.7792645106764292547967914e-74, 18, "977926451067642925", -73},
  {1.1862495408699617184391875e+134, 2, "12", 135},
  {8.0684351660180320754189625e-96, 17, "80684351660180321", -95},
  {3.5294885582858491006909067e+164, 9, "352948856", 165},
  {8.4931205729846425198094083e+191, 20, "84931205729846425198", 192},
  {8.1864667343532904784398424e+213, 14, "81864667343533", 214},
  {3.5454326883638730972799174e+153, 17, "35454326883638731", 154},
  {4.9839473863735223743297544e-19, 16, "4983947386373522", -18},
  {1.8570316970636152463647313e-163, 18, "185703169706361525", -162},
  {3.9636947131533105789323972e-167, 6, "396369", -166},
  {1.4325164791536890675200000e+20, 21, "143251647915368906752", 21},
  {3.9218799221783011043832109e-166, 18, "39218799221783011", -165},
  {8.2805807747887345477814063e-265, 10, "8280580775", -264},
  {5.3614753604472206170974035e+302, 14, "53614753604472", 303},
  {1.2215405033845812192698705e+251, 21, "122154050338458121927", 252},
  {3.4068642062828894698334276e-203, 7, "3406864", -202},
  {8.4490264084837399618877303e-55, 9, "844902641", -54},
  {1.1239254054766708948150345e-64, 2, "11", -63},
  {7.3091252688346168017652724e+183, 7, "7309125", 184},
  {5.8940848031515692720617264e-204, 5, "58941", -203},
  {2.9210532800803772023552928e+277, 8, "29210533", 278},
  {3.8970510850823238592777258e+239, 14, "38970510850823", 240},
  {1.4701936861674377121479040e+65, 4, "147", 66},
  {2.8747404497533128714356218e+295, 3, "287", 296},
  {1.6838137783372963277642565e+118, 10, "1683813778", 119},
  {1.2634694732134769505729471e+225, 14, "12634694732135", 226},
  {9.5579529339568883314024556e-223, 17, "95579529339568883", -222},
  {2.3550809437137321751821660e-144, 14, "23550809437137", -143},
  {3.3817069248436670123194430e-290, 18, "338170692484366701", -289},
  {1.7057522259456941577918425e-246, 13, "1705752225946", -245},
  {7.2070331072381902718369503e+123, 16, "720703310723819", 124},
  {5.8017067342649559746965165e+30, 8, "58017067", 31},
  {1.3806948887452563346492631e+227, 11, "13806948887", 228},
  {5.5431831648140110266492339e-56, 12, "554318316481", -55},
  {8.6038161815966585074439314e+229, 9, "860381618", 230},
  {1.8838495369760309472439985e+01, 4, "1884", 2},
  {2.2351447000641042028137449e-78, 10, "22351447", -77},
  {1.4923821129354947069654049e-290, 16, "1492382112935495", -289},
  {1.8403201826232552775763907e+03, 9, "184032018", 4},
  {1.5297407840414383508403135e-248, 9, "152974078", -247},
  {3.2154508649675893156609448e-62, 3, "322", -61},
  {1.2532004808740205374137157e+219, 1, "1", 220},
  {5.6076671466398799823299437e+142, 7, "5607667", 143},
  {9.0199679787973918113861212e-278, 18, "901996797879739181", -277},
  {3.3127006586056481609826446e+189, 10, "3312700659", 190},
  {3.4372009007583734776115890e-35, 8, "34372009", -34},
  {2.4198135537767130205838612e+132, 2, "24", 133},
  {2.7843953661102666444369046e-20, 19, "2784395366110266644", -19},
  {2.3655131935740719505550532e-107, 17, "2365513193574072", -106},
  {1.1548550513249102696270834e+85, 7, "1154855", 86},
  {1.4365581261916297590827306e+74, 10, "1436558126", 75},
  {3.4010846204145786941808183e+03, 18, "340108462041457869", 4},
  {2.6128076355202642427707873e-307, 17, "26128076355202642", -306},
  {8.6301120643170048647994073e-99, 17, "86301120643170049", -98},
  {9.8475582703510403462563984e+103, 3, "985", 104},
  {1.5481663686338345087278867e+02, 9, "154816637", 3},
  {1.3061410736642051243347086e-67, 13, "1306141073664", -66},
  {4.9586655472047657059777775e+63, 15, "495866554720477", 64},
  {6.8028748617771805128949757e-67, 18, "680287486177718051", -66},
  {2.8277275634868562338211837e-122, 13, "2827727563487", -121},
  {1.2836104346288455762646081e+47, 11, "12836104346", 48},
  {2.1286101187030375713154670e-127, 3, "213", -126},
  {2.8025392618602320273742218e-171, 8, "28025393", -170},
  {3.7134001905235212187605944e-113, 9, "371340019", -112},
  {7.8185818540066835000962178e-16, 16, "7818581854006684", -15},
  {2.1596453507596800920285860e+245, 15, "215964535075968", 246},
  {4.6675580268514724942803548e-243, 18, "466755802685147249", -242},
  {9.8630623941624240101723767e-20, 10, "9863062394", -19},
  {1.0659612311984553776231570e+48, 17, "10659612311984554", 49},
  {1.1787617208375563385844922e-62, 13, "1178761720838", -61},
  {2.4035711053957060510782134e+128, 12, "24035711054", 129},
  {4.9781413937284895530277698e-60, 16, "497814139372849", -59},
  {2.9176965816151439805309046e-191, 13, "2917696581615", -190},
  {3.1630417548482639152793460e-58, 13, "3163041754848", -57},
  {2.4109534750709129295161779e+146, 14, "24109534750709", 147},
  {4.3475364956492742017501990e-92, 1, "4", -91},
  {1.4101644577033559503930837e+34, 12, "14101644577", 35},
  {1.0671604499895672774090342e-17, 8, "10671604", -16},
  {2.6110234583191864127608950e-131, 13, "2611023458319", -130},
  {6.5819550133042619441981235e-68, 3, "658", -67},
  {7.1370766893095727923200000e+20, 11, "71370766893", 21},
  {2.4949694928910104880146309e+157, 12, "249496949289", 158},
  {4.2738210612490779935886140e+134, 7, "4273821", 135},
  {2.6262186502801557252713801e-51, 1, "3", -50},
  {1.1411642832817137812418580e+229, 7, "1141164", 230},
  {2.5334949875094403036294324e+229, 4, "2533", 230},
  {1.3243413768604732779231922e+232, 5, "13243", 233},
  {1.7091160218000765733935346e-121, 13, "17091160218", -120},
  {7.5922964933348107193710589e-81, 13, "7592296493335", -80},
  {3.4015704447069850609381828e+256, 18, "340157044470698506", 257},
  {6.6775219304159939476720853e-82, 6, "667752", -81},
  {4.2953871384446222240300403e+142, 2, "43", 143},
  {3.2040126088066852489988032e-129, 2, "32", -128},
  {8.7942718672590148795065470e+79, 13, "8794271867259", 80},
  {6.1603611509206884244250170e+56, 20, "61603611509206884244", 57},
  {2.5962100257505134582077368e+146, 20, "25962100257505134582", 147},
  {1.7182408959382050956419141e+65, 9, "17182409", 66},
  {1.2592608773813156901517484e+238, 11, "12592608774", 239},
  {3.4548915087224724379955553e+30, 8, "34548915", 31},
  {2.2573848667819356302819303e-296, 13, "2257384866782", -295},
  {8.6757837399302871109320053e-307, 21, "867578373993028711093", -306},
  {3.8102090767769830715654252e+245, 7, "3810209", 246},
  {1.0519225406920288014967949e-145, 16, "1051922540692029", -144},
  {1.3952103223877491332365261e+29, 8, "13952103", 30},
  {6.3556804423267961938909103e+212, 16, "6355680442326796", 213},
  {9.5549960073569679613751528e-286, 2, "96", -285},
  {7.8400249196378861037678369e+194, 3, "784", 195},
  {5.6801103263377816654561495e-223, 4, "568", -222},
  {3.1457292448304181942741297e+48, 4, "3146", 49},
  {7.0105595950070700336351454e+75, 10, "7010559595", 76},
  {2.4665178173815280821243037e-169, 10, "2466517817", -168},
  {1.1083526244018990476440861e-16, 5, "11084", -15},
  {9.9897917500356825983978665e+179, 16, "9989791750035683", 180},
  {1.6551788406675045502181366e-123, 7, "1655179", -122},
  {1.9975025804220039716819283e-229, 20, "19975025804220039717", -228},
  {5.5857229260512120561088523e+01, 7, "5585723", 2},
  {6.1067634854317564197667064e-274, 2, "61", -273},
  {3.1563145611628658284421320e-248, 14, "31563145611629", -247},
  {1.0463675740478143608984752e+122, 21, "10463675740478143609", 123},
  {6.0857310996415297066266467e+208, 4, "6086", 209},
  {2.0214517078997146467468934e+294, 4, "2021", 295},
  {2.0706005048720147532932722e-222, 9, "20706005", -221},
  {1.3093111181822945363819599e+06, 12, "130931111818", 7},
  {3.0840303507410832977409136e-189, 16, "3084030350741083", -188},
  {6.3168974451478942149441731e-252, 15, "631689744514789", -251},
  {7.0312157022893499918605240e-68, 7, "7031216", -67},
  {1.1262896653312718749374347e-106, 21, "112628966533127187494", -105},
  {4.8936064810273588802607560e-29, 19, "489360648102735888", -28},
  {3.9441929517859922778846674e-243, 14, "3944192951786", -242},
  {2.8959855248889133495287550e-26, 18, "289598552488891335", -25},
  {3.1911088593545605601904255e-28, 11, "31911088594", -27},
  {3.7107373948080199510442565e-129, 14, "3710737394808", -128},
  {3.3605306555236138296708207e-126, 20, "33605306555236138297", -125},
  {9.6907781709289206420230734e-177, 13, "9690778170929", -176},
  {7.2781603958464649788444653e-146, 17, "7278160395846465", -145},
  {4.5598131865734075010019902e+103, 19, "4559813186573407501", 104},
  {4.7181274851940727750570025e+104, 8, "47181275", 105},
  {1.6180129658482527551310650e+234, 12, "161801296585", 235},
  {7.3074048705246367083101107e-90, 2, "73", -89},
  {4.8958149971967687023556235e+236, 18, "48958149971967687", 237},
  {2.4891176463646033724269306e+108, 12, "248911764636", 109},
  {3.5700407351701901829058018e-263, 1, "4", -262},
  {1.0177635570977903436240187e-218, 2, "1", -217},
  {1.5798915875188195575422703e-243, 12, "157989158752", -242},
  {2.9019476278383496496880514e-46, 12, "290194762784", -45},
  {4.7461770107081683142283386e+86, 1, "5", 87},
  {6.9523217515865966520747949e-258, 18, "695232175158659665", -257},
  {9.9154019559091147395110759e+115, 8, "9915402", 116},
  {2.0079379089902121682237814e-84, 8, "20079379", -83},
  {4.2190467511391849485872670e+306, 14, "42190467511392", 307},
  {3.7984147154237847175880926e+49, 4, "3798", 50},
  {2.2738277372937680277071364e-154, 12, "227382773729", -153},
  {1.7038806815961802071872096e-201, 2, "17", -200},
  {3.4577009547253299712815287e+87, 19, "3457700954725329971", 88},
  {1.4474164590475531280145194e+281, 17, "14474164590475531", 282},
  {3.1605635982656903451250145e-250, 16, "316056359826569", -249},
  {7.4372896138998181896114715e+128, 3, "744", 129},
  {1.8109139527566084492679163e-159, 20, "18109139527566084493", -158},
  {3.1526648295891793312718307e-259, 5, "31527", -258},
  {7.0052894102446740472117885e-139, 15, "700528941024467", -138},
  {4.3905450860967550997682743e-92, 12, "43905450861", -91},
  {2.1598628412790699790246581e-222, 12, "215986284128", -221},
  {7.0816434585571282416927163e-78, 21, "708164345855712824169", -77},
  {1.9793142052803594843858053e+302, 18, "197931420528035948", 303},
  {3.4619719113357232259300999e-123, 11, "34619719113", -122},
  {8.7138321047193870312170076e-68, 3, "871", -67},
  {4.0231225341343162034965256e+285, 21, "40231225341343162035", 286},
  {3.7821440689463245532797454e+281, 19, "3782144068946324553", 282},
  {3.1755277859879998278453218e-299, 9, "317552779", -298},
  {3.0846012363136251706736331e-97, 2, "31", -96},
  {1.2408025675536064814008432e-07, 19, "1240802567553606481", -6},
  {1.2129692100460660455094463e-261, 10, "121296921", -260},
  {7.2351124334566757581815443e+300, 6, "723511", 301},
  {8.7347400037037025684756447e+139, 13, "8734740003704", 140},
  {1.9703961551529536860144323e-184, 9, "197039616", -183},
  {1.1793412274474818801684496e+99, 17, "11793412274474819", 100},
  {2.7889442683818962482804241e-135, 15, "27889442683819", -134},
  {1.0218258308311956906970663e-56, 7, "1021826", -55},
  {5.9901227346417578068841787e+141, 4, "599", 142},
  {1.5884846279393306690995721e-198, 15, "158848462793933", -197},
  {2.2232721158583364558199230e-27, 7, "2223272", -26},
  {1.9916317850196425377749254e-270, 4, "1992", -269},
  {5.5620955253551023729575478e-232, 19, "5562095525355102373", -231},
  {1.9665929462199902070680890e+57, 20, "19665929462199902071", 58},
  {5.6751758583578750493686263e+175, 12, "567517585836", 176},
  {9.1564685075139653528848466e-103, 1, "9", -102},
  {3.3683407259634399020134038e-57, 21, "336834072596343990201", -56},
  {2.1856203539531945958620552e-38, 5, "21856", -37},
  {2.9874078036443224782145496e-214, 18, "298740780364432248", -213},
  {1.7020256876428259560385867e-19, 5, "1702", -18},
  {8.5605424062915835569554103e-79, 13, "8560542406292", -78},
  {1.5437591318559456232056445e-158, 2, "15", -157},
  {2.9103378965136193218748638e+292, 14, "29103378965136", 293},
  {1.2987956936201191307593628e-11, 10, "1298795694", -10},
  {9.9130346075004927074706587e+221, 19, "9913034607500492707", 222},
  {2.8187042960130503927259019e+45, 20, "28187042960130503927", 46},
  {2.4843259576304139471021470e+282, 20, "24843259576304139471", 283},
  {9.0951236987512572718767667e+208, 10, "9095123699", 209},
  {5.5833167405265984536859074e-74, 14, "55833167405266", -73},
  {7.6824941779516042001173284e+182, 7, "7682494", 183},
  {1.3945795721784183544598481e+215, 9, "139457957", 216},
  {1.8602127562827057881705365e+295, 19, "1860212756282705788", 296},
  {6.4008572890551418599518943e-12, 1, "6", -11},
  {7.6076048415983948540347998e-214, 2, "76", -213},
  {3.6703346932002769516424795e-68, 8, "36703347", -67},
  {1.8941400257605272134225729e-157, 5, "18941", -156},
  {3.2888364664033723120143931e-81, 19, "3288836466403372312", -80},
  {8.9692645224123250706602444e+307, 20, "89692645224123250707", 308},
  {8.1437655677701493271956756e-215, 4, "8144", -214},
  {7.4144604184399641774078642e-156, 3, "741", -155},
  {7.3151546898553891365308842e-128, 6, "731515", -127},
  {1.8518165013200581364555534e-64, 5, "18518", -63},
  {1.1398902221638588940818774e-282, 5, "11399", -281},
  {8.1660263686195300037443884e-22, 12, "816602636862", -21},
  {7.9107841581948906155091689e+28, 3, "791", 29},
  {7.4889956381857047121578820e-255, 6, "7489", -254},
  {1.1125056998337905585381832e-10, 17, "11125056998337906", -9},
  {1.6670002181571836447177932e+62, 16, "1667000218157184", 63},
  {8.4820499951308123743678465e+80, 7, "848205", 81},
  {5.5143635703223050142849866e+126, 13, "5514363570322", 127},
  {7.3556865288534179752779938e-203, 4, "7356", -202},
  {4.4182227304626405357739608e-43, 21, "441822273046264053577", -42},
  {1.4248454656795400275427988e-161, 13, "142484546568", -160},
  {2.0055969183182525517087754e-247, 13, "2005596918318", -246},
  {3.0839407190057549265748204e+29, 19, "3083940719005754927", 30},
  {1.9181789894772185290851145e+240, 6, "191818", 241},
  {9.3745339839185466225642041e-66, 1, "9", -65},
  {6.2231296721087770250012315e+205, 2, "62", 206},
  {4.4369692465113726414858879e+297, 7, "4436969", 298},
  {1.1319127297897934943775265e-223, 3, "113", -222},
  {6.1111263347905755566438400e+57, 16, "6111126334790576", 58},
  {1.1063355297115830171041938e-223, 21, "11063355297115830171", -222},
  {4.2088361572928373446477695e+79, 12, "420883615729", 80},
  {1.7957880670031586382664056e-258, 12, "1795788067", -257},
  {7.2733548435159358555777814e+143, 16, "7273354843515936", 144},
  {6.0437319882289969508083222e+45, 12, "604373198823", 46},
  {1.2045292111818011655157040e-16, 13, "1204529211182", -15},
  {1.7532064042239633111492423e-204, 5, "17532", -203},
  {7.2821871681649971822592000e+22, 9, "728218717", 23},
  {5.6215302355167055674123340e-63, 19, "5621530235516705567", -62},
  {1.6483876069068487680000000e+18, 10, "1648387607", 19},
  {2.3546822796212170388631828e-31, 20, "23546822796212170389", -30},
  {5.0847586488420913593221473e-181, 16, "5084758648842091", -180},
  {3.0802865387085116316057600e+23, 9, "308028654", 24},
  {5.5908479897699795612458979e+246, 5, "55908", 247},
  {1.5778872863334705844852547e+107, 1, "2", 108},
  {1.1520424473294435298446734e+133, 18, "115204244732944353", 134},
  {7.4191479015756110154595203e+83, 18, "741914790157561102", 84},
  {7.7386907939965732829100903e+155, 12, "7738690794", 156},
  {2.2294050310162864830002112e+37, 16, "2229405031016286", 38},
  {1.0096449479677219950398758e+250, 18, "1009644947967722", 251},
  {3.4675935998632671368104552e-164, 7, "3467594", -163},
  {6.9453040953039867474222906e-300, 19, "6945304095303986747", -299},
  {4.4925164016038899477941941e+251, 12, "44925164016", 252},
  {1.2704384791784046997395303e-189, 9, "127043848", -188},
  {1.7363055279566209860538388e+303, 6, "173631", 304},
  {1.4484644039754976654367130e+26, 5, "14485", 27},
  {7.1131188977259246985128038e-77, 10, "7113118898", -76},
  {1.4297524923989865853283282e+105, 6, "142975", 106},
  {5.7887838564265850306081017e-89, 5, "57888", -88},
  {2.6777159721199110591468412e+243, 11, "26777159721", 244},
  {6.8539551056686153911374998e+158, 14, "68539551056686", 159},
  {6.9305303087127627289697251e-96, 1, "7", -95},
  {7.3839795007556174812419233e-39, 1, "7", -38},
  {7.9524724803256521640132709e-59, 10, "795247248", -58},
  {3.1773685543413181565533236e+84, 12, "317736855434", 85},
  {4.4326146804147759155378726e-162, 5, "44326", -161},
  {5.5862201752701458652898971e+173, 16, "5586220175270146", 174},
  {2.4688525212592773379690159e+214, 15, "246885252125928", 215},
  {2.4265189460942819662932489e-270, 20, "24265189460942819663", -269},
  {1.2420871708485496081836694e-228, 17, "12420871708485496", -227},
  {1.0186103020334624146478605e+259, 10, "1018610302", 260},
  {1.0795124878962289299474762e+50, 5, "10795", 51},
  {1.5425780382444886439509885e-59, 18, "154257803824448864", -58},
  {8.8838148792746348068396067e-221, 6, "888381", -220},
  {1.7364952828530165022720000e+21, 19, "1736495282853016502", 22},
  {2.4261674466062890119382337e-233, 1, "2", -232},
  {9.9093101527907448710735937e-10, 20, "99093101527907448711", -9},
  {3.3857268853536118264289510e+280, 21, "338572688535361182643", 281},
  {3.7394220511776197213293926e+01, 16, "373942205117762", 2},
  {5.3280466748515855215373449e+03, 17, "53280466748515855", 4},
  {4.4681694167711851625918818e+112, 8, "44681694", 113},
  {2.6972679648866833427662972e+123, 17, "26972679648866833", 124},
  {9.3977557247317094175862558e-68, 19, "9397755724731709418", -67},
  {9.0774840974395232189198642e-218, 13, "907748409744", -217},
  {1.9248945842027489323160765e+225, 10, "1924894584", 226},
  {9.2045725777141893951300367e-270, 8, "92045726", -269},
  {2.3490660396027649681583248e-102, 3, "235", -101},
  {2.1485317910543727945610532e+232, 2, "21", 233},
  {1.3937148058908643842352413e-11, 6, "139371", -10},
  {4.8427648889415927597555943e+100, 4, "4843", 101},
  {1.6571478465928968346049587e-276, 13, "1657147846593", -275},
  {4.8413692861968121704183732e-41, 18, "484136928619681217", -40},
  {2.1443057271720500104132265e-291, 20, "21443057271720500104", -290},
  {1.5160288346089560926238226e-156, 19, "1516028834608956093", -155},
  {2.2428976161644803177496389e+210, 15, "224289761616448", 211},
  {2.1345633057242675088582644e+283, 21, "213456330572426750886", 284},
  {1.2083900727839836272747649e+154, 8, "12083901", 155},
  {4.3572620960968228785528465e+204, 7, "4357262", 205},
  {3.3536873204205645923687444e-107, 8, "33536873", -106},
  {1.9948077588718578627752973e-134, 13, "1994807758872", -133},
  {2.4219620130503629209600000e+22, 15, "242196201305036", 23},
  {1.1101991477162731501156479e+286, 18, "111019914771627315", 287},
  {7.0998288232044739548617205e+115, 6, "709983", 116},
  {1.5960930795137808992463838e+289, 11, "15960930795", 290},
  {1.8730110450785509884097592e+174, 9, "187301105", 175},
  {1.3957631012634885755207292e+83, 9, "13957631", 84},
  {4.9959945638916096335635268e+234, 5, "4996", 235},
  {2.2071090780714351905531031e+282, 8, "22071091", 283},
  {4.5035564893663117477179570e-109, 17, "45035564893663117", -108},
  {2.6231641788689512931024036e-278, 15, "262316417886895", -277},
  {1.2862448929936636750909272e+48, 8, "12862449", 49},
  {5.3517450854301726111360942e-233, 15, "535174508543017", -232},
  {1.2831430346924770447160102e-37, 10, "1283143035", -36},
  {4.9704902211552760577967976e-234, 21, "49704902211552760578", -233},
  {5.9450967504444144044953704e-304, 17, "59450967504444144", -303},
  {2.3661951121094185465835537e-131, 21, "236619511210941854658", -130},
  {2.4951490098238032042280404e-219, 13, "2495149009824", -218},
  {3.1033218142434911472930137e-212, 6, "310332", -211},
  {4.8943403551797244015888650e+188, 8, "48943404", 189},
  {5.3449586050417115792099205e+225, 10, "5344958605", 226},
  {1.7706318041358062250432257e-121, 18, "177063180413580623", -120},
  {8.9904542179135334648326215e+161, 9, "899045422", 162},
  {4.9993307695626712933392959e+122, 20, "49993307695626712933", 123},
  {4.5089902205125043865556547e-154, 3, "451", -153},
  {1.9087225111127034749550854e-56, 16, "1908722511112703", -55},
  {1.0759165117706984915663186e-236, 9, "107591651", -235},
  {5.2878596112715549930748909e-194, 11, "52878596113", -193},
  {3.3891368925072991676998149e-82, 15, "33891368925073", -81},
  {3.5095082998981270427166080e-139, 6, "350951", -138},
  {1.4146867270052825450684877e-254, 2, "14", -253},
  {8.3301480150206785727945272e-119, 6, "833015", -118},
  {1.0754323326137397747804064e+166, 12, "107543233261", 167},
  {1.9010230125239210958647008e+235, 1, "2", 236},
  {5.6002593039429267635204199e+54, 4, "56", 55},
  {9.0101406342422835954417110e+162, 9, "901014063", 163},
  {4.3762590327223635668154986e+161, 16, "4376259032722364", 162},
  {1.6006955005501550694842697e-42, 12, "160069550055", -41},
  {1.1720981620884706371493829e-228, 21, "117209816208847063715", -227},
  {2.9172564829641430610999247e+28, 2, "29", 29},
  {1.0061161749276261454275045e+29, 8, "10061162", 30},
  {1.4862404142929181505893332e+300, 3, "149", 301},
  {1.2590624282826596189027972e-24, 17, "12590624282826596", -23},
  {6.7949508937277013476330711e-59, 15, "67949508937277", -58},
  {1.9402402844937713460961564e-200, 15, "194024028449377", -199},
  {3.2078172332433090863158184e+99, 9, "320781723", 100},
  {2.4470674052192503382501946e-24, 20, "24470674052192503383", -23},
  {4.2354402724486772717444057e-68, 8, "42354403", -67},
  {4.6395981668014529388823585e+174, 7, "4639598", 175},
  {1.5425161142411158248384207e-148, 12, "154251611424", -147},
  {3.0277558775022630178059297e+306, 11, "30277558775", 307},
  {2.0440223083666053053629772e-112, 5, "2044", -111},
  {7.9690681836177868543959876e+267, 8, "79690682", 268},
  {8.3545699937560508076586108e+33, 13, "8354569993756", 34},
  {2.3981114475377009815676837e-272, 5, "23981", -271},
  {6.2385299336433716595924360e+140, 5, "62385", 141},
  {9.2159254646909064879043184e-208, 11, "92159254647", -207},
  {6.8823408699629968032240868e+05, 13, "6882340869963", 6},
  {4.9618441122479499755421747e+270, 13, "4961844112248", 271},
  {1.0741030482413358150886178e-07, 14, "10741030482413", -6},
  {6.3011595039514763146465260e-274, 17, "63011595039514763", -273},
  {5.1900625480523939720815710e+248, 4, "519", 249},
  {6.8071115562097426584997658e+201, 12, "680711155621", 202},
  {5.1614801361301625592421544e-184, 15, "516148013613016", -183},
  {1.3884300280431999932457055e+153, 19, "1388430028043199993", 154},
  {8.3858443688762136503100919e+01, 15, "838584436887621", 2},
  {3.1567641148140686812549552e+171, 20, "31567641148140686813", 172},
  {2.5528323372527083535146254e+268, 6, "255283", 269},
  {3.0120711133814564323328000e+22, 6, "301207", 23},
  {3.2896548828040947157987364e-128, 13, "3289654882804", -127},
  {8.6599505125728077692962274e-91, 11, "86599505126", -90},
  {8.1483024325998249255326160e+72, 10, "8148302433", 73},
  {8.6934182605567755319704253e+72, 20, "8693418260556775532", 73},
  {3.4092677567122888486344789e-268, 4, "3409", -267},
  {4.7385998935804871911129905e-164, 2, "47", -163},
  {4.0984524921324168343858190e-288, 18, "409845249213241683", -287},
  {1.5267537859393160246224347e-16, 4, "1527", -15},
  {2.4296072476826049792958424e+291, 8, "24296072", 292},
  {1.0571878656862132896930511e-103, 7, "1057188", -102},
  {6.1315908442484604523824080e+207, 2, "61", 208},
  {3.5235977876738961065213601e-206, 11, "35235977877", -205},
  {3.8677965387043352022473485e+197, 17, "38677965387043352", 198},
  {2.6672089457237496841287640e+50, 19, "2667208945723749684", 51},
  {1.9431423218223406942664903e+37, 7, "1943142", 38},
  {1.0185255477992605143296402e+186, 21, "101852554779926051433", 187},
  {1.2225900774166297982342689e+256, 12, "122259007742", 257},
  {1.5623390095508560374197229e+286, 4, "1562", 287},
  {1.2849022182218131497448771e+213, 16, "1284902218221813", 214},
  {2.3989024864285463793391891e-225, 14, "23989024864285", -224},
  {5.9324701702597930876988288e-178, 15, "593247017025979", -177},
  {2.9469938324233044819237773e-199, 15, "29469938324233", -198},
  {8.0994945032932032238866060e+192, 14, "80994945032932", 193},
  {2.0935720329077493450526164e+158, 20, "20935720329077493451", 159},
  {2.3386744010514188036508479e-181, 10, "2338674401", -180},
  {3.7868656774656247549894472e-173, 12, "378686567747", -172},
  {4.6375563407268833769231994e-266, 4, "4638", -265},
  {3.2629406575102517646487890e-159, 12, "326294065751", -158},
  {4.1193571645052540028889287e-71, 2, "41", -70},
  {2.2983969072038663246520181e-252, 12, "22983969072", -251},
  {3.5925323131817504157235276e+268, 21, "359253231318175041572", 269},
  {8.9073602482046987481322045e+195, 3, "891", 196},
  {1.3982729524923785132639458e+88, 16, "1398272952492379", 89},
  {1.5582374232993940118152875e-32, 4, "1558", -31},
  {3.7703583349239996650802417e+274, 18, "377035833492399967", 275},
  {2.8048943215838998464905797e+133, 14, "28048943215839", 134},
  {1.8462019640206912132864587e-276, 6, "18462", -275},
  {7.5684648050275903482550209e-70, 8, "75684648", -69},
  {1.7211070373184879177657006e+174, 1, "2", 175},
  {2.3508780408542330605399855e+300, 11, "23508780409", 301},
  {8.2293250681694172279566196e+94, 10, "8229325068", 95},
  {3.7193100564031432968541043e-255, 1, "4", -254},
  {9.2300523784208836577142194e-262, 15, "923005237842088", -261},
  {2.5297470967401198995155750e+92, 4, "253", 93},
  {1.2335511299169057890949993e-260, 9, "123355113", -259},
  {9.2707137749156232241043794e+114, 12, "927071377492", 115},
  {1.2231150500847326156872441e+02, 11, "12231150501", 3},
  {1.8752982374401458466413551e-99, 3, "188", -98},
  {8.6070737767193374704704963e+111, 11, "86070737767", 112},
  {1.4720336911694230015197254e-83, 14, "14720336911694", -82},
  {5.9358251536598633057923310e-261, 20, "59358251536598633058", -260},
  {1.3549631531025834669865244e+271, 12, "13549631531", 272},
  {9.7705755502622614472668181e+219, 11, "97705755503", 220},
  {2.7041355568399583805440000e+21, 3, "27", 22},
  {2.6665753466045881103785428e-187, 19, "266657534660458811", -186},
  {3.7762111631468548434141722e+113, 8, "37762112", 114},
  {8.3600934959565376000000000e+16, 4, "836", 17},
  {4.4806035843498026256791650e-44, 12, "448060358435", -43},
  {1.8236174917033370487138223e+137, 13, "1823617491703", 138},
  {3.7942786405459727522168999e-230, 15, "379427864054597", -229},
  {2.7776527433993648594692521e-199, 4, "2778", -198},
  {2.0760097492319192171802097e-183, 16, "2076009749231919", -182},
  {1.4646246481120718133510686e-87, 4, "1465", -86},
  {6.2835148605042248926248726e+116, 11, "62835148605", 117},
  {6.5102705844430164683557688e+205, 20, "65102705844430164684", 206},
  {1.6714868520668688959526965e+135, 5, "16715", 136},
  {5.4657800077579954201927798e-154, 10, "5465780008", -153},
  {5.4244430939889424973396558e+46, 11, "5424443094", 47},
  {3.4472755730503063596810557e-34, 15, "344727557305031", -33},
  {1.1643829932130517197925401e-09, 19, "116438299321305172", -8},
  {7.9553200670244509865235101e+87, 5, "79553", 88},
  {3.6261273548424755859375000e+12, 20, "36261273548424755859", 13},
  {4.2975728110010074765843667e+273, 11, "4297572811", 274},
  {6.2483795345009948316183015e+213, 7, "624838", 214},
  {9.3299054185845509712006583e-158, 4, "933", -157},
  {6.1679776876535985900940534e-236, 21, "616797768765359859009", -235},
  {6.8075403361774898878858821e+193, 1, "7", 194},
  {1.0856343585649439539200000e+20, 19, "1085634358564943954", 21},
  {7.7387054766186276593101328e-303, 13, "7738705476619", -302},
  {6.0655174321687965743876703e+00, 8, "60655174", 1},
  {1.0570547802868096896016429e-190, 4, "1057", -189},
  {1.6194194623706843728171548e+71, 11, "16194194624", 72},
  {4.0263142078543519232870917e+74, 11, "40263142079", 75},
  {2.2253086596291035103995911e+196, 18, "222530865962910351", 197},
  {2.8596606657390750080945111e+92, 16, "2859660665739075", 93},
  {3.9441456406626353359901319e+186, 4, "3944", 187},
  {2.0382163752640208565215777e+191, 16, "2038216375264021", 192},
  {1.9435359239096819710484453e-209, 5, "19435", -208},
  {5.3112028517263035655699504e-61, 7, "5311203", -60},
  {1.8605118945277301334478305e-159, 2, "19", -158},
  {3.2723951813257645031259333e-97, 2, "33", -96},
  {3.0200080098517178772807031e+35, 8, "3020008", 36},
  {7.2367309707187844231900910e-71, 14, "72367309707188", -70},
  {1.2361424615546754883564702e-150, 5, "12361", -149},
  {2.3569831458547369806109353e+92, 18, "235698314585473698", 93},
  {7.2281342493469725438522982e+50, 9, "722813425", 51},
  {2.1525584079068987213172583e-293, 1, "2", -292},
  {2.5681489504831956812844174e-180, 19, "2568148950483195681", -179},
  {5.5203307307563809101830282e+91, 6, "552033", 92},
  {1.0079411986956634539325250e+00, 15, "100794119869566", 1},
  {3.3223674790667442386359194e+100, 12, "332236747907", 101},
  {1.5075676370009288145666832e+131, 8, "15075676", 132},
  {6.3197928926099482878712515e+132, 7, "6319793", 133},
  {3.3371755402760411834918031e-242, 4, "3337", -241},
  {1.3529758321466650315903058e-247, 12, "135297583215", -246},
  {1.1300633575646168900413828e+188, 8, "11300634", 189},
  {2.4636747711360954310284819e+172, 8, "24636748", 173},
  {4.7839814532915118906145740e+127, 1, "5", 128},
  {7.0787874213792431354522705e+08, 7, "7078787", 9},
  {7.9679693467813628364377119e-154, 15, "796796934678136", -153},
  {8.9468421094916473114411787e-125, 3, "895", -124},
  {4.0788072510211162346920454e-191, 11, "4078807251", -190},
  {6.6491240822468617510105672e-133, 17, "66491240822468618", -132},
  {5.1952072163103096583184604e+307, 13, "519520721631", 308},
  {1.6728395515150979135973737e+146, 6, "167284", 147},
  {3.4743623255515389702814925e+156, 12, "347436232555", 157},
  {2.3101569544731201811594724e-154, 4, "231", -153},
  {1.3819600714501613511601828e-96, 13, "138196007145", -95},
  {1.1611859778281102041223287e+156, 17, "11611859778281102", 157},
  {4.5227207844142956393133580e-159, 12, "452272078441", -158},
  {2.8036212842948651297046923e+73, 14, "28036212842949", 74},
  {2.4346670606823226910844884e+185, 6, "243467", 186},
  {1.9830817842379862664728702e+219, 10, "1983081784", 220},
  {7.0557384643337826750793772e-50, 9, "705573846", -49},
  {2.0984349455889562795120588e-234, 20, "20984349455889562795", -233},
  {1.0401919932835208647313840e+132, 21, "104019199328352086473", 133},
  {1.5989723519913523805842938e-254, 7, "1598972", -253},
  {1.3593654996338445352005519e-08, 19, "1359365499633844535", -7},
  {3.5017634062224271110364431e+303, 14, "35017634062224", 304},
  {3.5902403253703344000000000e+16, 8, "35902403", 17},
  {7.8740903779782034235027438e-300, 1, "8", -299},
  {4.9509055489448457547209193e-214, 9, "495090555", -213},
  {1.3482098075425133064132458e-87, 6, "134821", -86},
  {7.7444602994973842831102710e-31, 6, "774446", -30},
  {5.6351440764178713279189296e+45, 13, "5635144076418", 46},
  {8.4927760643728509922911284e-119, 8, "84927761", -118},
  {5.0579470417684167360193769e-273, 17, "50579470417684167", -272},
  {6.5618370515651095334591470e+225, 8, "65618371", 226},
  {6.1136759038365580690558415e-222, 6, "611368", -221},
  {3.1931087143269854152529914e-108, 12, "319310871433", -107},
  {5.5508030626317345895775950e-195, 5, "55508", -194},
  {1.8037368889840900854617477e-09, 14, "18037368889841", -8},
  {2.5412100784278885673252958e-70, 1, "3", -69},
  {2.9838639415841063504952665e+35, 4, "2984", 36},
  {3.7276269470555386692611481e+271, 20, "37276269470555386693", 272},
  {1.1695916096073797496302763e+56, 11, "11695916096", 57},
  {1.0736384950484873847564008e-91, 20, "10736384950484873848", -90},
  {3.3658686840079864585454454e-237, 7, "3365869", -236},
  {1.6165737729064737230929103e+72, 12, "161657377291", 73},
  {3.5738238977626957244725448e+186, 4, "3574", 187},
  {1.1395774351716238512505879e+186, 14, "11395774351716", 187},
  {1.6981104824963905262724499e-26, 16, "1698110482496391", -25},
  {1.0896936943363493225873123e-113, 2, "11", -112},
  {6.4431323799953979669702160e+171, 6, "644313", 172},
  {1.3183641776793998512223633e+186, 10, "1318364178", 187},
  {1.6612650183789959577600000e+20, 10, "1661265018", 21},
  {4.2174842044563597557760000e+22, 3, "422", 23},
  {1.8285941309018743434870927e-280, 5, "18286", -279},
  {7.4534732930685286498846513e-06, 15, "745347329306853", -5},
  {1.5005135718757962122694064e-174, 14, "15005135718758", -173},
  {7.8295722415345033004467939e+62, 13, "7829572241535", 63},
  {2.0575420535934025735233753e+244, 17, "20575420535934026", 245},
  {1.5321330647466281343124942e-269, 1, "2", -268},
  {2.1364074644402797470122685e+123, 21, "213640746444027974701", 124},
  {6.3090891182181355357713399e+305, 16, "6309089118218136", 306},
  {1.2016992404704508078258767e-140, 5, "12017", -139},
  {3.4837573614158757007818163e+270, 4, "3484", 271},
  {4.3899787293138521940854637e+69, 9, "438997873", 70},
  {2.1904928159045536052058214e+92, 12, "21904928159", 93},
  {1.5103110377882666575318538e+178, 2, "15", 179},
  {9.7376654073309745017902814e+122, 21, "973766540733097450179", 123},
  {5.4814785393078975547340731e-30, 11, "54814785393", -29},
  {4.0265344261571864242459574e-288, 19, "4026534426157186424", -287},
  {7.2617943900547454143135673e+229, 16, "7261794390054745", 230},
  {1.9566113412963337340750386e+99, 18, "195661134129633373", 100},
  {1.8512516150179702909294221e+144, 10, "1851251615", 145},
  {1.8781998639348424212907761e-115, 14, "18781998639348", -114},
  {1.8224758598057089230975817e+254, 7, "1822476", 255},
  {4.2636225549400754322036230e-09, 2, "43", -8},
  {1.4330020255011604217724909e-170, 6, "1433", -169},
  {1.5736013369623737008614749e+130, 20, "15736013369623737009", 131},
  {2.2089020706400772775563767e+146, 5, "22089", 147},
  {8.5815356285090328529384322e-247, 2, "86", -246},
  {3.0159315737924109531208029e-142, 18, "301593157379241095", -141},
  {1.6388027385795803407583692e-183, 7, "1638803", -182},
  {6.8016579806642050320447576e-139, 17, "6801657980664205", -138},
  {1.8428957849935845947265625e+11, 9, "184289578", 12},
  {1.0963246006455493408608965e-233, 18, "109632460064554934", -232},
  {2.6400056701194066105541888e+166, 1, "3", 167},
  {6.7415263594564659135769730e+143, 9, "674152636", 144},
  {2.2039925106924593572167520e+89, 1, "2", 90},
  {1.9478180248808953111874082e-221, 20, "19478180248808953112", -220},
  {1.3809119189383669134704684e+166, 17, "13809119189383669", 167},
  {3.1658915865910808217778907e-140, 19, "3165891586591080822", -139},
  {1.9330317012151803391419304e+196, 8, "19330317", 197},
  {1.5639349263471084184376295e-132, 19, "1563934926347108418", -131},
  {3.5952928376220983510177927e-117, 19, "3595292837622098351", -116},
  {7.2454348878756069983550717e-56, 14, "72454348878756", -55},
  {4.1181361261309160680911523e-240, 2, "41", -239},
  {3.1754694600493570180836275e-127, 7, "3175469", -126},
  {1.6867364034943001589240134e+132, 9, "16867364", 133},
  {3.1474278705156809005857645e+40, 9, "314742787", 41},
  {1.3651787057368754604417335e-132, 11, "13651787057", -131},
  {6.2164119572222165736901559e+195, 5, "62164", 196},
  {1.3644548648605723775365399e-210, 21, "136445486486057237754", -209},
  {1.3623949619787713413511042e+243, 15, "136239496197877", 244},
  {4.2348918670298945818444026e+136, 8, "42348919", 137},
  {3.9552076172037927411975973e+93, 5, "39552", 94},
  {9.6730941997186839542334107e+115, 15, "967309419971868", 116},
  {5.8134014032052560182188110e+213, 6, "58134", 214},
  {6.5567545382830293933291852e-226, 6, "655675", -225},
  {2.9250523984603300094604492e+09, 15, "292505239846033", 10},
  {5.3792017044650644004260153e+35, 15, "537920170446506", 36},
  {7.2346350085124716688827299e-47, 20, "72346350085124716689", -46},
  {4.5470281861493260754246991e+292, 21, "454702818614932607542", 293},
  {5.5074920244566690202103617e+261, 20, "55074920244566690202", 262},
  {2.5562332916803318591122721e+111, 5, "25562", 112},
  {4.3440098432371182887985942e+35, 19, "4344009843237118289", 36},
  {8.2408007592424908693828911e+01, 1, "8", 2},
  {6.0591910031020152902431816e-19, 9, "6059191", -18},
  {1.5042511697434691975096613e-181, 13, "1504251169743", -180},
  {2.1025432481510635448542840e+184, 8, "21025432", 185},
  {2.4208828261823342033980453e+229, 12, "242088282618", 230},
  {1.5888615354332211934723451e-143, 2, "16", -142},
  {1.5124849509254685958945921e-173, 11, "15124849509", -172},
  {1.2885507757173703791939364e-142, 5, "12886", -141},
  {7.1322925450514892752182608e-227, 4, "7132", -226},
  {1.6417060460466536057602884e-160, 6, "164171", -159},
  {3.1268411253772681951123308e-279, 8, "31268411", -278},
  {4.4835242520903903927408394e+237, 13, "448352425209", 238},
  {2.6985204460707649359216719e+50, 20, "26985204460707649359", 51},
  {2.1427377120327162307262504e+274, 6, "214274", 275},
  {1.6341736471815649095263304e-95, 20, "16341736471815649095", -94},
  {1.5901022251879583752869462e+280, 1, "2", 281},
  {6.3063860562574361294275853e-283, 5, "63064", -282},
  {6.6961418210400914584194789e+231, 2, "67", 232},
  {7.6625896195550084766148382e+29, 14, "7662589619555", 30},
  {1.2422289549447824338999562e+60, 17, "12422289549447824", 61},
  {1.7848696564136206317553305e-276, 8, "17848697", -275},
  {4.7643986458074731937172989e-276, 4, "4764", -275},
  {3.1386741172667938053450946e-288, 3, "314", -287},
  {1.4522223067192120652715356e-89, 21, "145222230671921206527", -88},
  {6.5665829230676941655853378e+196, 21, "656658292306769416559", 197},
  {5.0970122313455828821226517e-48, 3, "51", -47},
  {2.5415067659838922125190100e-108, 15, "254150676598389", -107},
  {1.9829109559032643460843637e+229, 15, "198291095590326", 230},
  {1.6123300339090598318195171e+76, 10, "1612330034", 77},
  {5.6865245916845112094901655e-221, 19, "5686524591684511209", -220},
  {4.8679394552564967452042117e+176, 3, "487", 177},
  {5.3649456103061220589540535e+160, 8, "53649456", 161},
  {1.6158232118368738598804563e+197, 14, "16158232118369", 198},
  {1.7657676664389059059543777e-98, 14, "17657676664389", -97},
  {3.1731578263102149466661553e-146, 17, "31731578263102149", -145},
  {2.0917120328958008748290922e-88, 5, "20917", -87},
  {8.6512680810504985689503497e-53, 12, "865126808105", -52},
  {1.0871923138850588354143157e+76, 14, "10871923138851", 77},
  {2.0841403311287362930450998e+80, 3, "208", 81},
  {1.2615203392180732800144938e-17, 7, "126152", -16},
  {7.9545562276474713531509351e+284, 4, "7955", 285},
  {1.4931594522805057466448260e-280, 21, "149315945228050574664", -279},
  {1.0125954017594139851613125e+135, 7, "1012595", 136},
  {5.0297629442938546360218899e-132, 13, "5029762944294", -131},
  {2.6120734695192520553916890e-103, 7, "2612073", -102},
  {4.9259076738480187376605683e-188, 2, "49", -187},
  {7.0774216270607248738072042e-84, 19, "7077421627060724874", -83},
  {1.3013258946927707533235456e-19, 3, "13", -18},
  {5.9006974677374925101518706e-260, 11, "59006974677", -259},
  {6.4966656645872236474480250e-230, 5, "64967", -229},
  {3.7743449045455242865406663e+92, 21, "377434490454552428654", 93},
  {5.9872124848851860200397259e-72, 18, "598721248488518602", -71},
  {1.4020591183737558428312314e+56, 5, "14021", 57},
  {8.1228261737823274312276320e+151, 6, "812283", 152},
  {1.5781711452421636239862686e+187, 19, "1578171145242163624", 188},
  {2.4002734375735335822549013e-80, 4, "24", -79},
  {5.5553739662216459714560000e+21, 9, "555537397", 22},
  {2.8829096459124057022280201e+63, 14, "28829096459124", 64},
  {3.2894205692793992432625465e+109, 8, "32894206", 110},
  {3.1167813489926684487131110e+70, 21, "311678134899266844871", 71},
  {1.3344323238249593702849108e+213, 17, "13344323238249594", 214},
  {3.5824835700687630832394663e+153, 9, "358248357", 154},
  {3.9017778670041326662120620e-153, 11, "3901777867", -152},
  {2.1905880002092168698911611e+58, 15, "219058800020922", 59},
  {7.0586775637673959793666011e-104, 5, "70587", -103},
  {3.1995378218039527906293988e+153, 16, "3199537821803953", 154},
  {7.2583034107139880714365350e+175, 19, "7258303410713988071", 176},
  {5.0663307296183420751778284e+280, 14, "50663307296183", 281},
  {1.8248607066068237817446360e+130, 2, "18", 131},
  {1.0047452176177389941970713e+234, 5, "10047", 235},
  {1.5875157073047894035681326e-189, 1, "2", -188},
  {1.5117203781512616997899124e-156, 10, "1511720378", -155},
  {1.2596767845416100690969441e+85, 4, "126", 86},
  {1.5070563728456082277469079e+32, 17, "15070563728456082", 33},
  {9.7284923962258740565978873e+288, 9, "97284924", 289},
  {1.6747890861558237490182221e+121, 4, "1675", 122},
  {3.5721883670152481189678804e+86, 14, "35721883670152", 87},
  {3.7770584787984859275400204e+117, 4, "3777", 118},
  {2.8919686191076807020983153e+271, 4, "2892", 272},
  {1.1809550662605151001219362e+195, 19, "11809550662605151", 196},
  {3.0573728491593848774698365e-225, 14, "30573728491594", -224},
  {7.7061835982639101038918114e-12, 13, "7706183598264", -11},
  {7.3495537135654590448905782e-266, 9, "734955371", -265},
  {5.0024059795955498177061058e-110, 12, "50024059796", -109},
  {3.8037473816697732425400480e+260, 4, "3804", 261},
  {3.9299578316722325734153307e+207, 1, "4", 208},
  {1.0427638456311701881416471e-115, 3, "104", -114},
  {1.5075424347408777331603730e+37, 12, "150754243474", 38},
  {2.7281632703973635198747464e+236, 18, "272816327039736352", 237},
  {1.3942133255834851297549903e+05, 11, "13942133256", 6},
  {4.5724944151161471494006576e-278, 13, "4572494415116", -277},
  {3.9478733716710499546852874e+195, 9, "394787337", 196},
  {9.4202132034485984840171193e+85, 8, "94202132", 86},
  {1.0840096200936502416398827e+257, 15, "108400962009365", 258},
  {7.0566244899239471201444445e+43, 14, "70566244899239", 44},
  {2.7145351646379843071298834e-204, 13, "2714535164638", -203},
  {1.8417609764228827678331044e-218, 2, "18", -217},
  {8.9441512639667758520686610e-207, 8, "89441513", -206},
  {2.7526070772740496921827632e-181, 7, "2752607", -180},
  {5.9858189688124698728527278e-61, 12, "598581896881", -60},
  {9.7860835934939375673747258e-223, 10, "9786083593", -222},
  {1.1497945994321056761282818e-98, 10, "1149794599", -97},
  {3.1145127731100780431951263e+105, 5, "31145", 106},
  {1.9739931748448399698403038e-255, 10, "1973993175", -254},
  {6.9850784318397875891642600e-109, 10, "6985078432", -108},
  {1.3575535554780560925752947e-146, 5, "13576", -145},
  {9.8042221992584428967620336e-139, 11, "98042221993", -138},
  {1.7961308433237154345186869e+202, 5, "17961", 203},
  {2.4178427709984335182009098e+183, 17, "24178427709984335", 184},
  {8.3086817148651807643617761e-100, 14, "83086817148652", -99},
  {4.1241465130058665960523953e+285, 18, "41241465130058666", 286},
  {6.4928328483290419506522820e-145, 5, "64928", -144},
  {2.8600019205189690600095121e-123, 9, "286000192", -122},
  {3.1123159271841084517211441e+202, 15, "311231592718411", 203},
  {4.2064157375004677127641631e+278, 12, "42064157375", 279},
  {2.1672940881598330108965682e-119, 13, "216729408816", -118},
  {9.6667161570517916315422070e+151, 6, "966672", 152},
  {1.9314450486132604212081519e-261, 12, "193144504861", -260},
  {1.9078905415806220926638694e+31, 3, "191", 32},
  {1.3301348528277964117480081e+144, 11, "13301348528", 145},
  {3.2888807230875037333104393e-267, 2, "33", -266},
  {2.5595120623575894609461858e-212, 2, "26", -211},
  {2.3810774809854201124121236e-96, 10, "2381077481", -95},
  {8.8722266846360114148807129e-256, 16, "8872226684636011", -255},
  {1.0220955823580604857741221e+60, 15, "102209558235806", 61},
  {1.3600692282967615722189100e+219, 3, "136", 220},
  {1.4319054335208996850793277e-34, 10, "1431905434", -33},
  {3.8730889999222236813431336e-258, 18, "387308899992222368", -257},
  {2.0069010124509409144800085e-132, 17, "20069010124509409", -131},
  {1.4359500324163128386806906e+307, 6, "143595", 308},
  {4.9685089923246518768378790e+182, 8, "4968509", 183},
  {8.1593820747226881833401538e-171, 8, "81593821", -170},
  {2.7889619993408610000000000e+15, 2, "28", 16},
  {2.5493343462729443076409232e+169, 10, "2549334346", 170},
  {1.6195220394914738484356853e-257, 21, "161952203949147384844", -256},
  {2.9280187116108940021122425e+183, 19, "2928018711610894002", 184},
  {1.1438574540475240568704042e+154, 19, "1143857454047524057", 155},
  {1.3282165203715134650942045e-33, 13, "1328216520372", -32},
  {2.2793719586079555586937360e+167, 5, "22794", 168},
  {1.1588970702586399005327943e-142, 18, "11588970702586399", -141},
  {8.3361530789316812562617146e-109, 18, "833615307893168126", -108},
  {5.7114790669975740436618810e+141, 7, "5711479", 142},
  {4.0817326788856825270902650e-101, 5, "40817", -100},
  {3.2523688119294055624076308e-251, 4, "3252", -250},
  {5.4946253404375348406631877e-141, 2, "55", -140},
  {1.2024729534146676797804578e+112, 10, "1202472953", 113},
  {1.2562660853450120687289555e-08, 16, "1256266085345012", -7},
  {7.6272263265311351546629536e-302, 8, "76272263", -301},
  {2.6473586488246376861051521e+173, 4, "2647", 174},
  {1.9337779290113392071549759e+105, 11, "1933777929", 106},
  {9.7708264471753674368941118e-277, 13, "9770826447175", -276},
  {1.3348057848802526510802647e-135, 2, "13", -134},
  {3.8221887074457752195417200e-18, 13, "3822188707446", -17},
  {1.8897094732246598565852218e-63, 21, "188970947322465985659", -62},
  {5.5958387332771191682255939e+135, 5, "55958", 136},
  {3.3793749796000751206678041e-92, 7, "3379375", -91},
  {7.7675055701629055980019460e+279, 2, "78", 280},
  {9.7230259518444713996274271e+70, 4, "9723", 71},
  {9.8610549731415577697631778e+266, 3, "986", 267},
  {1.6435427126436599497025764e-214, 16, "164354271264366", -213},
  {4.9746268059645690849236946e+114, 2, "5", 115},
  {2.1107993453020759520674052e-271, 14, "21107993453021", -270},
  {3.5684772357876817650094054e-78, 16, "3568477235787682", -77},
  {2.4074418227776480431593282e-192, 14, "24074418227776", -191},
  {8.5299785312426329954264691e-57, 6, "852998", -56},
  {1.1481006147464467840090654e-262, 13, "1148100614746", -261},
  {2.2230392200205383801322455e+216, 21, "222303922002053838013", 217},
  {4.7719762594537323874025968e-164, 4, "4772", -163},
  {1.5990386411508528482247301e-99, 3, "16", -98},
  {1.6330466810440718041192531e-222, 5, "1633", -221},
  {5.9325496457338451660548207e-308, 19, "5932549645733845166", -307},
  {2.4799346921473875567415495e-78, 4, "248", -77},
  {1.7076270025985384417838571e+37, 7, "1707627", 38},
  {1.0682838329401442995157545e-103, 21, "106828383294014429952", -102},
  {3.1946374847738902389215735e-280, 5, "31946", -279},
  {1.3780138014070405529600000e+20, 3, "138", 21},
  {4.0513094139668696376665713e+40, 4, "4051", 41},
  {5.7431728349090539149797344e-229, 19, "5743172834909053915", -228},
  {4.9026490018112233544686159e+87, 2, "49", 88},
  {7.5385967272035401265384280e+00, 12, "75385967272", 1},
  {2.6915717768750799907230448e-179, 21, "269157177687507999072", -178},
  {4.8612551361473131251703268e-177, 15, "486125513614731", -176},
  {5.8880457294070113834561013e-303, 21, "588804572940701138346", -302},
  {1.3167325101754873856338907e+182, 10, "131673251", 183},
  {2.9406794447080145374794860e+97, 6, "294068", 98},
  {7.9944608972069767751407418e+170, 4, "7994", 171},
  {8.3614262259302317833974551e-263, 17, "83614262259302318", -262},
  {2.8757210978602836486633419e-276, 2, "29", -275},
  {1.2190610187193308011566214e+212, 9, "121906102", 213},
  {7.5862248614292468503690673e-233, 6, "758622", -232},
  {4.8204948500389923895109845e-256, 1, "5", -255},
  {1.4104846735893737115136070e+116, 2, "14", 117},
  {6.8023026274246282104466261e-252, 1, "7", -251},
  {8.8810772692184716902924710e+145, 6, "888108", 146},
  {3.8484073877296818251635174e-209, 18, "384840738772968183", -208},
  {1.0544835711442476414245156e-249, 1, "1", -248},
  {1.3523406721241970969148670e-161, 15, "13523406721242", -160},
  {2.3836280742873547417364316e+177, 20, "23836280742873547417", 178},
  {1.0597625406159929479744239e+138, 11, "10597625406", 139},
  {9.8381042996835942493240172e+137, 2, "98", 138},
  {3.4159103770962816163351479e-189, 10, "3415910377", -188},
  {2.2142953837574862063775072e+02, 3, "221", 3},
  {2.8691642654958594612144001e-249, 12, "28691642655", -248},
  {1.0237649245822903179190387e-70, 3, "102", -69},
  {9.3627076195699235000894731e+193, 7, "9362708", 194},
  {1.4208209150532317793757027e+165, 17, "14208209150532318", 166},
  {1.0942963468456516878545793e+249, 12, "109429634685", 250},
  {2.6973490166707498130434009e+64, 9, "269734902", 65},
  {2.6443228897501911362830802e+153, 19, "2644322889750191136", 154},
  {1.3433723361888002000000000e+16, 11, "13433723362", 17},
  {5.6595884356736116673707828e+276, 17, "56595884356736117", 277},
  {6.2790560300397085230685163e+202, 19, "6279056030039708523", 203},
  {4.3262457565193217695677639e-93, 18, "432624575651932177", -92},
  {1.8598791268483676757812500e+12, 9, "185987913", 13},
  {3.7367157568704118784000000e+20, 4, "3737", 21},
  {8.0957880888988476069069464e+49, 1, "8", 50},
  {2.4559350788384610000000000e+15, 8, "24559351", 16},
  {4.6638210713380847288828471e+108, 10, "4663821071", 109},
  {3.4288435971293421788204993e-273, 6, "342884", -272},
  {5.9680961290106597585482930e+168, 1, "6", 169},
  {5.9223602609861677546630498e-08, 17, "59223602609861678", -7},
  {9.9997748935944674362540872e+151, 21, "999977489359446743625", 152},
  {9.1342461240806316747081899e-178, 5, "91342", -177},
  {3.3097147771301727964233728e+25, 15, "330971477713017", 26},
  {6.2670463136382773585939698e-92, 10, "6267046314", -91},
  {5.9375932931782364600880470e-68, 19, "593759329317823646", -67},
  {6.9881891925508566384006396e+257, 2, "7", 258},
  {2.9862145270933739437310367e+273, 8, "29862145", 274},
  {2.0489030104447883054950725e-27, 12, "204890301044", -26},
  {3.7133767756905829228578720e+285, 13, "3713376775691", 286},
  {7.1771385899933168412091314e-183, 15, "717713858999332", -182},
  {1.1197116692973155819650929e-14, 3, "112", -13},
  {9.1307496595808652273262851e+02, 20, "91307496595808652273", 3},
  {1.2475055132742036815352909e-301, 17, "12475055132742037", -300},
  {3.2520319918174817118785141e+165, 21, "325203199181748171188", 166},
  {2.3365252805680507522096934e+54, 11, "23365252806", 55},
  {4.9171621030465403617280000e+22, 13, "4917162103047", 23},
  {1.7642671888435417467256166e-195, 18, "176426718884354175", -194},
  {3.6265547043422822733655081e-65, 15, "362655470434228", -64},
  {6.5211898750140198028342630e-230, 1, "7", -229},
  {2.4683030257442568847544589e-133, 19, "2468303025744256885", -132},
  {6.2935287315702970190045562e+00, 18, "629352873157029702", 1},
  {7.4126550119034827657748843e+176, 11, "74126550119", 177},
  {4.1471058512737249066581403e+176, 9, "414710585", 177},
  {7.0840947288905016080323302e+104, 20, "7084094728890501608", 105},
  {2.1008091830931265267279727e-257, 5, "21008", -256},
  {4.3637391429190067888148502e+58, 13, "4363739142919", 59},
  {2.4756133273788737383248763e+274, 21, "247561332737887373832", 275},
  {3.5493344829360937118496275e-74, 14, "35493344829361", -73},
  {2.2280945924076220731339847e+168, 19, "2228094592407622073", 169},
  {1.9479488881076723409439565e-112, 2, "19", -111},
  {1.1064973327946168729600000e+20, 3, "111", 21},
  {1.1080549405696315884192797e-259, 7, "1108055", -258},
  {3.0921275995895285941088561e-117, 12, "309212759959", -116},
  {7.3448154737985120933366091e-290, 15, "734481547379851", -289},
  {2.5017481189756024542430346e+64, 10, "2501748119", 65},
  {4.1668449670350728106274325e-170, 20, "41668449670350728106", -169},
  {4.3453643130137395731127001e-245, 13, "4345364313014", -244},
  {2.9475812827948974077420640e-193, 5, "29476", -192},
  {1.1016199161135908466981739e+130, 3, "11", 131},
  {1.6238773358421175293409491e+292, 2, "16", 293},
  {9.1722120791054370757754444e-131, 14, "91722120791054", -130},
  {1.1769599261293475275210090e-259, 20, "11769599261293475275", -258},
  {1.6603253260856645803495161e-257, 6, "166033", -256},
  {5.9453710459250974720324639e+29, 7, "5945371", 30},
  {6.5871572488290574126749155e-43, 21, "658715724882905741267", -42},
  {7.9857327187126453354935617e-249, 17, "79857327187126453", -248},
  {1.7996061239692290560872007e+188, 18, "179960612396922906", 189},
  {6.5521788118623302684617721e-251, 2, "66", -250},
  {6.1033583763065100040552880e+260, 9, "610335838", 261},
  {1.1351762562470179072525384e+111, 11, "11351762562", 112},
  {1.2832713615049887213433757e-144, 15, "128327136150499", -143},
  {7.7132968956042752351969792e+214, 17, "77132968956042752", 215},
  {1.8720012144000358823241068e+261, 10, "1872001214", 262},
  {1.0573290056823206364037524e-149, 14, "10573290056823", -148},
  {1.2909109120511722607990092e-79, 21, "12909109120511722608", -78},
  {1.7311061182730790400000000e+17, 18, "173110611827307904", 18},
  {2.5209056952792800612904696e+270, 14, "25209056952793", 271},
  {9.3325553916670028129963510e+274, 5, "93326", 275},
  {1.0126722703864169277151372e-35, 19, "1012672270386416928", -34},
  {3.8687787595305932991050918e-301, 14, "38687787595306", -300},
  {6.0361413773679435931916394e-191, 5, "60361", -190},
  {1.4461286693628673244879773e-294, 10, "1446128669", -293},
  {1.1794296208338265024454564e+261, 15, "117942962083383", 262},
  {1.5728699757907839240023824e-185, 17, "15728699757907839", -184},
  {2.4008748358714302684924649e+192, 3, "24", 193},
  {3.2639942066529896245357147e-159, 8, "32639942", -158},
  {1.9086540266324811428784219e-78, 3, "191", -77},
  {1.9934570721755211417769538e-166, 20, "19934570721755211418", -165},
  {1.7965225223611885340436281e-81, 8, "17965225", -80},
  {1.0355894920077872683454644e-161, 7, "1035589", -160},
  {2.2598877529716923046768158e+290, 7, "2259888", 291},
  {2.4384197053318394239529259e+187, 7, "243842", 188},
  {9.4867419841091763006050376e-24, 18, "94867419841091763", -23},
  {5.5841814944920942854382179e-216, 18, "558418149449209429", -215},
  {2.2449276912551076889989140e+71, 19, "2244927691255107689", 72},
  {2.5270006413267874441590145e+254, 10, "2527000641", 255},
  {7.4348049596174416986556953e-36, 1, "7", -35},
  {2.6336871253801487983904531e-93, 10, "2633687125", -92},
  {1.9521058346049901275947986e+163, 11, "19521058346", 164},
  {2.4550530481743108828534063e-174, 2, "25", -173},
  {6.4326539030086112998996477e-272, 6, "643265", -271},
  {1.3719732487631863231931859e+268, 15, "137197324876319", 269},
  {1.2099282679417556203623817e+283, 2, "12", 284},
  {4.5528562007333937046852973e+200, 11, "45528562007", 201},
  {3.2541189363533631936262702e-67, 19, "3254118936353363194", -66},
  {5.3994862653282746045121082e+103, 15, "539948626532827", 104},
  {2.5734990583430934218701782e-199, 2, "26", -198},
  {4.4091905737325967966587223e-167, 10, "4409190574", -166},
  {8.5573175023642527288249117e-276, 7, "8557318", -275},
  {2.1743583421249752098266036e-214, 10, "2174358342", -213},
  {8.1845841048563506727031424e-86, 14, "81845841048564", -85},
  {1.8341004708984747240588778e+80, 2, "18", 81},
  {4.4093930958835254537116203e-17, 14, "44093930958835", -16},
  {7.5652342301538012689614780e+51, 16, "7565234230153801", 52},
  {3.0303081337601851470355160e+240, 15, "303030813376019", 241},
  {2.4180848613341736973848267e-196, 2, "24", -195},
  {1.2964826349002549031774387e-31, 15, "129648263490025", -30},
  {2.0417021275938618535963359e-203, 13, "2041702127594", -202},
  {1.0361798841084620785191337e-45, 8, "10361799", -44},
  {9.8714785545306704504537385e-55, 17, "98714785545306705", -54},
  {3.4016644738578347486496708e-56, 20, "34016644738578347486", -55},
  {4.5704714574053761564053974e+185, 20, "45704714574053761564", 186},
  {4.6893238234841772264494331e-76, 16, "4689323823484177", -75},
  {3.8851874177719070303677022e-114, 10, "3885187418", -113},
  {5.5163316976073206620654690e+206, 21, "551633169760732066207", 207},
  {2.4406978821828134997716771e-171, 14, "24406978821828", -170},
  {4.1282192173334473342472736e+52, 10, "4128219217", 53},
  {1.2257421725412617379959541e+44, 7, "1225742", 45},
  {4.0014777937446600110542924e+40, 1, "4", 41},
  {1.5698803787807742568584693e+261, 5, "15699", 262},
  {6.7348111923896934118978141e-93, 13, "673481119239", -92},
  {2.6445158849367325689208607e-235, 11, "26445158849", -234},
  {2.5640740054339257556254546e+254, 8, "2564074", 255},
  {1.0298221282861693584399978e+263, 3, "103", 264},
  {6.4643442625252193439459895e-149, 5, "64643", -148},
  {3.5257310386791316279742105e+286, 9, "352573104", 287},
  {4.9892615852130859373088781e+137, 1, "5", 138},
  {1.5906482511359336974966517e-208, 10, "1590648251", -207},
  {5.9433174197231935529525605e-08, 12, "594331741972", -7},
  {5.3157507099781707544708102e+259, 15, "531575070997817", 260},
  {1.3860290887231454379679903e-297, 18, "138602908872314544", -296},
  {2.0159579615552726472548640e-108, 9, "201595796", -107},
  {3.8124313316311346241554058e+230, 7, "3812431", 231},
  {1.2079015480328258217828516e+303, 15, "120790154803283", 304},
  {6.8430604856928662575252665e+252, 19, "6843060485692866258", 253},
  {7.6670077197852533492397935e+283, 1, "8", 284},
  {6.9657256376458353207980379e+285, 13, "6965725637646", 286},
  {3.3561979693792766250495918e-125, 1, "3", -124},
  {6.1770483030799459641883071e+95, 9, "61770483", 96},
  {2.1497896867734217536173732e+165, 10, "2149789687", 166},
  {9.9493469460354030637079589e-112, 6, "994935", -111},
  {2.7458382250349644405865275e-104, 11, "2745838225", -103},
  {3.1182441589113142025518851e+50, 16, "3118244158911314", 51},
  {5.7215119753286967613515426e-190, 13, "5721511975329", -189},
  {1.6455101687247554049557185e-86, 14, "16455101687248", -85},
  {2.2851383419044128675334804e-02, 10, "2285138342", -1},
  {7.4724347432549071423643671e+250, 20, "74724347432549071424", 251},
  {3.0815073921541098409518998e+57, 10, "3081507392", 58},
  {2.4119215151586785952027569e+31, 6, "241192", 32},
  {4.4390301544231143936887041e-248, 18, "443903015442311439", -247},
  {4.6987719220987890615036684e-250, 18, "469877192209878906", -249},
  {7.4349300308411630776077956e+96, 10, "7434930031", 97},
  {6.5952575904525546376975881e+64, 21, "65952575904525546377", 65},
  {1.1111625667393679542857230e-252, 12, "111116256674", -251},
  {6.1179919466949054219562284e-23, 19, "6117991946694905422", -22},
  {8.1629920806965221761113733e-56, 4, "8163", -55},
  {1.0038483043278505610304773e+122, 20, "1003848304327850561", 123},
  {1.2235730806174739223328546e-08, 4, "1224", -7},
  {1.1162829176537579303438247e-72, 21, "111628291765375793034", -71},
  {1.5916084849038658142228687e+256, 13, "1591608484904", 257},
  {2.2438359054281739500752966e+59, 8, "22438359", 60},
  {1.9325530674317575558445598e+187, 7, "1932553", 188},
  {1.7506528987224075990525307e+03, 17, "17506528987224076", 4},
  {2.3783468541687657290316041e+51, 3, "238", 52},
  {4.7963138853114853307118379e+126, 1, "5", 127},
  {4.2007377049325739687764899e-234, 13, "4200737704933", -233},
  {3.2834963943354065313504932e+127, 20, "32834963943354065314", 128},
  {1.0623902516611775237287837e+206, 15, "106239025166118", 207},
  {1.3583100850053382707772773e-193, 13, "1358310085005", -192},
  {2.0850062864330046199217313e+45, 19, "208500628643300462", 46},
  {5.9821430132241914031260128e+32, 14, "59821430132242", 33},
  {4.2205128522764635196045895e-168, 3, "422", -167},
  {1.9192848945120356438044603e+65, 19, "1919284894512035644", 66},
  {2.0731109099264676184795506e+298, 9, "207311091", 299},
  {3.4985543826171653139960792e-102, 8, "34985544", -101},
  {3.2962965002438908514027943e-274, 13, "3296296500244", -273},
  {7.0945208733475108211575729e+156, 4, "7095", 157},
  {2.0680430636072206165364923e-63, 20, "20680430636072206165", -62},
  {1.3825748135127968178559387e-114, 3, "138", -113},
  {4.5806655998983086252937501e-191, 18, "458066559989830863", -190},
  {3.7359412679475211458637897e-149, 16, "3735941267947521", -148},
  {1.0418454394198172244504054e-302, 16, "1041845439419817", -301},
  {1.3328255026229078391186360e-57, 4, "1333", -56},
  {2.8581043684894360006523839e+39, 17, "2858104368489436", 40},
  {2.8453309486735036654977497e+252, 19, "2845330948673503665", 253},
  {2.0696407679076261567666230e+283, 20, "20696407679076261568", 284},
  {7.0504192713531401312430127e-243, 1, "7", -242},
  {9.3630746975148910674118965e-57, 20, "93630746975148910674", -56},
  {4.0309871548353485181626121e+122, 16, "4030987154835349", 123},
  {7.8450333719715976387394415e-220, 1, "8", -219},
  {5.0699429194345244761642394e+302, 3, "507", 303},
  {6.2860094563084925978474134e-250, 14, "62860094563085", -249},
  {1.4731818271380275992053362e+200, 5, "14732", 201},
  {1.4682802439188420339650131e-09, 13, "1468280243919", -8},
  {5.3340729760113959639086886e-83, 19, "5334072976011395964", -82},
  {2.9553022979778424829995686e+44, 11, "2955302298", 45},
  {2.3625092538782584943858154e-214, 3, "236", -213},
  {3.2803741054755578695561365e-267, 19, "328037410547555787", -266},
  {2.0394603674534063620457003e-291, 17, "20394603674534064", -290},
  {2.0017300640630215015421653e-112, 14, "2001730064063", -111},
  {3.9058313864864880981119838e-262, 9, "390583139", -261},
  {1.6809770116786423470229471e-192, 9, "168097701", -191},
  {4.6354066121165032845649567e+62, 8, "46354066", 63},
  {5.8097053589014280291505438e-196, 18, "580970535890142803", -195},
  {2.5077358383208563373574870e-175, 11, "25077358383", -174},
  {3.2287386695313825069813898e-270, 21, "322873866953138250698", -269},
  {2.1617790987181025852698168e+245, 7, "2161779", 246},
  {1.3978599274506346742852785e-170, 18, "139785992745063467", -169},
  {1.0379326486448449104893105e+54, 13, "1037932648645", 55},
  {4.4332887885000295876161950e+96, 14, "44332887885", 97},
  {6.4826459827921326759074998e+174, 18, "648264598279213268", 175},
  {2.7584592047248591221694354e-210, 12, "275845920472", -209},
  {1.5836946084775781262833176e+162, 5, "15837", 163},
  {9.7187256290392621904030857e+170, 1, "1", 172},
  {7.4944421988414160096618624e+195, 16, "7494442198841416", 196},
  {3.0312204607508565377543868e-10, 6, "303122", -9},
  {6.9030090894190715189545959e+190, 4, "6903", 191},
  {3.6347318683596905930465552e+230, 9, "363473187", 231},
  {2.5794902966082553187212881e+122, 19, "2579490296608255319", 123},
  {6.9135317000910914108543549e+223, 20, "69135317000910914109", 224},
  {1.1967005387485742449248356e-41, 8, "11967005", -40},
  {7.2575897353587342328579588e+304, 18, "725758973535873423", 305},
  {6.1280386151978435431614248e-127, 9, "612803862", -126},
  {2.9762410970157283549347274e+42, 6, "297624", 43},
  {3.2907718226683000263068554e+122, 21, "329077182266830002631", 123},
  {3.3579794555404630443020928e+64, 12, "335797945554", 65},
  {1.7929998823049825393402982e-76, 8, "17929999", -75},
  {1.2406028811070191574426761e-250, 5, "12406", -249},
  {1.7000738098391893787373593e+178, 13, "1700073809839", 179},
  {1.2932686061803286830249633e-182, 21, "129326860618032868302", -181},
  {2.5503176264269132593652912e-102, 1, "3", -101},
  {1.8141269413414686521808989e+150, 8, "18141269", 151},
  {1.2809589773340767867851453e+222, 15, "128095897733408", 223},
  {8.5135941853918702545062459e-96, 20, "85135941853918702545", -95},
  {2.8363550474050044932064945e-202, 14, "2836355047405", -201},
  {1.0209283399799956292485076e+50, 7, "1020928", 51},
  {2.7918743879728094624181601e-218, 16, "2791874387972809", -217},
  {5.9985039220779743191649303e-121, 5, "59985", -120},
  {8.6052271023285851406545201e-128, 17, "86052271023285851", -127},
  {3.4995820296182660699074825e-308, 19, "349958202961826607", -307},
  {6.3168951156117119971610725e+32, 6, "63169", 33},
  {1.6187957155454524939814188e-71, 18, "161879571554545249", -70},
  {2.8174936301667996412693234e+298, 15, "28174936301668", 299},
  {1.3904193653035945840203843e+284, 16, "1390419365303595", 285},
  {1.4720714183969961485915940e-185, 2, "15", -184},
  {3.3095069426995120922894734e-279, 9, "330950694", -278},
  {1.2927891150931685965120328e-67, 2, "13", -66},
  {5.1535582348378307323301424e-201, 1, "5", -200},
  {4.2742976325344356971451903e+200, 21, "427429763253443569715", 201},
  {2.5148981939772626850416098e-293, 8, "25148982", -292},
  {4.5820377654109954310523175e-271, 16, "4582037765410995", -270},
  {1.0937480656082053204990721e-189, 6, "109375", -188},
  {8.2544038848773209078445838e+251, 2, "83", 252},
  {2.0768946744388421225771832e-78, 2, "21", -77},
  {2.3405784617527630385077139e-151, 12, "234057846175", -150},
  {4.6264141755308955367514560e+281, 8, "46264142", 282},
  {1.4031762187227432947173641e-301, 18, "140317621872274329", -300},
  {1.7541907983797631687065600e+23, 9, "17541908", 24},
  {9.2652744467844868103053581e+282, 8, "92652744", 283},
  {2.0563670504272345230263784e-285, 13, "2056367050427", -284},
  {2.3973282651100092892546009e+197, 21, "239732826511000928925", 198},
  {1.8447980565528933384437268e+196, 13, "1844798056553", 197},
  {3.4402682869874240357191280e-182, 1, "3", -181},
  {3.4734201566141508123525684e+165, 11, "34734201566", 166},
  {7.3031380106910057208331369e-121, 10, "7303138011", -120},
  {3.9652992026896640883392509e+70, 19, "3965299202689664088", 71},
  {1.0599099363614178523796132e-174, 12, "105990993636", -173},
  {9.4539748033970241546630859e+09, 17, "94539748033970242", 10},
  {1.9213686690659166281177547e-269, 17, "19213686690659166", -268},
  {1.5089846074748991971350796e+30, 11, "15089846075", 31},
  {1.2016664739068312012102309e-120, 3, "12", -119},
  {4.4634822652268692067200963e-104, 17, "44634822652268692", -103},
  {6.9717805693158102708826732e+142, 19, "6971780569315810271", 143},
  {1.4862502917391284144122369e+112, 18, "148625029173912841", 113},
  {1.1924301793522482517768578e-258, 9, "119243018", -257},
  {7.8281069333893413480309091e+116, 11, "78281069334", 117},
  {2.3804345583385454657456359e+260, 9, "238043456", 261},
  {1.7604516410667684141806413e+72, 4, "176", 73},
  {1.8739748360495067114170684e+292, 15, "187397483604951", 293},
  {2.3364097784395065590449810e-162, 10, "2336409778", -161},
  {1.2469301215432541129739959e-213, 10, "1246930122", -212},
  {8.1619896229959201032023230e+43, 4, "8162", 44},
  {3.2260589055163079529843277e+178, 21, "322605890551630795298", 179},
  {1.4640822944991037277813716e+101, 8, "14640823", 102},
  {7.2190042960243613054784692e-137, 10, "7219004296", -136},
  {1.6942748925353173560429759e-194, 8, "16942749", -193},
  {1.1326248166502557252037601e-280, 16, "1132624816650256", -279},
  {5.9159333912489240821760000e+21, 9, "591593339", 22},
  {3.8267948659068274886536361e-269, 14, "38267948659068", -268},
  {8.5875258055831859507690682e-234, 2, "86", -233},
  {6.9127911929073066918194651e+45, 19, "6912791192907306692", 46},
  {2.2284860156214102473792037e+234, 14, "22284860156214", 235},
  {7.4458394189588501684892204e-18, 13, "7445839418959", -17},
  {1.6416892786716449956735767e-102, 7, "1641689", -101},
  {2.3542020179998883404141978e-159, 5, "23542", -158},
  {6.4772507236125753051195421e-189, 11, "64772507236", -188},
  {1.7056753073341855444719145e+185, 10, "1705675307", 186},
  {8.1578828155453789209476961e+256, 19, "8157882815545378921", 257},
  {4.9875642313879703047583054e-37, 12, "498756423139", -36},
  {5.1209047774125615233277926e-221, 9, "512090478", -220},
  {1.7056719296070144000825452e-68, 19, "17056719296070144", -67},
  {1.2113450904234830917883028e-159, 8, "12113451", -158},
  {1.8880791041367162058926969e-212, 20, "18880791041367162059", -211},
  {7.4316109406101832819709372e-118, 19, "7431610940610183282", -117},
  {2.3307961337212746681544297e-08, 16, "2330796133721275", -7},
  {1.4421239946127227381296938e+52, 14, "14421239946127", 53},
  {5.2651957630734817894361567e-06, 18, "526519576307348179", -5},
  {3.8280092931511072844404666e+51, 2, "38", 52},
  {6.5828767295045336719283254e+248, 13, "6582876729505", 249},
  {8.7210892349103434246700542e-185, 4, "8721", -184},
  {1.2052019908315506539550794e-104, 17, "12052019908315507", -103},
  {1.4906320255328866714666506e+239, 1, "1", 240},
  {9.8687999058639587981203168e-244, 12, "986879990586", -243},
  {7.1131863733584533363602847e+252, 4, "7113", 253},
  {1.4915360302095859810321371e+214, 9, "149153603", 215},
  {8.8707822277746362957263060e+273, 8, "88707822", 274},
  {1.0286195859884487535830881e+265, 2, "1", 266},
  {4.3757952765577474675149723e-265, 21, "437579527655774746751", -264},
  {8.0908207082093246585693154e+279, 1, "8", 280},
  {6.8108662318721618571665637e-284, 10, "6810866232", -283},
  {1.1113477687988429255445811e-15, 17, "11113477687988429", -14},
  {4.6511836380405660406409529e-274, 19, "4651183638040566041", -273},
  {7.1998167576328414384962409e+125, 5, "71998", 126},
  {2.9479742773541592784726660e-287, 5, "2948", -286},
  {3.2501013716465573845363783e-35, 6, "32501", -34},
  {1.4274592637470936369230887e-297, 3, "143", -296},
  {6.6455228185634224770336300e+120, 11, "66455228186", 121},
  {1.7119494552983767848288804e+122, 10, "1711949455", 123},
  {1.8002399802266086277430007e+167, 16, "1800239980226609", 168},
  {1.1415794198338127584240071e-120, 12, "114157941983", -119},
  {3.5071369813032547298412360e+53, 11, "35071369813", 54},
  {3.6052950632338141834836933e+202, 9, "360529506", 203},
  {2.2105606121184343455350645e-63, 4, "2211", -62},
  {1.2076218961460361480712891e+10, 13, "1207621896146", 11},
  {2.4950257592579376665619326e+50, 12, "249502575926", 51},
  {2.5713675645572771301827958e+264, 13, "2571367564557", 265},
  {4.1806953219621851295432212e+249, 15, "418069532196219", 250},
  {5.9879301995955349538255347e+301, 14, "59879301995955", 302},
  {3.2229868821693123269807152e-192, 2, "32", -191},
  {2.3892580744750764184380275e-240, 5, "23893", -239},
  {6.6599677551222629695839688e+149, 2, "67", 150},
  {4.0307513547277535806553286e-305, 13, "4030751354728", -304},
  {9.1097488670926751640812035e-64, 20, "91097488670926751641", -63},
  {5.4130240221145205800938421e+231, 2, "54", 232},
  {4.1919716689865800299357384e-12, 17, "419197166898658", -11},
  {1.6341667339400675787295452e-274, 19, "1634166733940067579", -273},
  {6.5291236991342475091362888e+60, 19, "6529123699134247509", 61},
  {1.3491894505851352996910768e+213, 16, "1349189450585135", 214},
  {9.5426313855587013620803429e+299, 16, "9542631385558701", 300},
  {3.6643348604069537059593958e-188, 5, "36643", -187},
  {7.5516110998942715634669462e-290, 9, "75516111", -289},
  {2.1760360454689947802981630e+123, 3, "218", 124},
  {7.6765125650083352063108884e-60, 4, "7677", -59},
  {4.8610883359723596960910719e-03, 10, "4861088336", -2},
  {2.3412297358025291617627609e-299, 13, "2341229735803", -298},
  {2.8751246232535863647860176e-250, 18, "287512462325358636", -249},
  {7.7573824684154657183748152e-85, 16, "7757382468415466", -84},
  {2.2436019301316319888740214e+196, 21, "224360193013163198887", 197},
  {1.0069518437194095830425285e+72, 12, "100695184372", 73},
  {2.9839876324630218574855644e+95, 20, "29839876324630218575", 96},
  {3.0834799824320231968205000e+155, 3, "308", 156},
  {7.5462092733154993674446476e-05, 1, "8", -4},
  {3.4668469113530222012006400e+23, 21, "34668469113530222012", 24},
  {7.1198587258924869912529387e-84, 17, "7119858725892487", -83},
  {8.1899467927692730346100479e+226, 2, "82", 227},
  {1.8257086132235278064334103e+50, 13, "1825708613224", 51},
  {2.3440691935471032510094640e+120, 14, "23440691935471", 121},
  {7.1289016335306112229656355e+207, 4, "7129", 208},
  {4.7189208265822821513185918e+67, 14, "47189208265823", 68},
  {3.7348898666936654759630809e-73, 1, "4", -72},
  {1.5363378396598377997054677e-117, 6, "153634", -116},
  {1.0466925391721815905890122e+150, 10, "1046692539", 151},
  {3.9695481668150869189595167e+62, 13, "3969548166815", 63},
  {1.4071169864614327335843370e+272, 8, "1407117", 273},
  {1.1816942322484510619767676e-81, 16, "1181694232248451", -80},
  {1.7850638239841710226997724e-73, 20, "17850638239841710227", -72},
  {3.1443363715463421266635279e-232, 2, "31", -231},
  {1.3654966019769404325321617e-250, 21, "136549660197694043253", -249},
  {9.1885169178829506297168077e+215, 1, "9", 216},
  {7.8774637443122119430795577e-166, 2, "79", -165},
  {4.6631211154714103063633698e+31, 13, "4663121115471", 32},
  {8.8747341046100060275776922e-13, 6, "887473", -12},
  {1.5549094241071472705917126e-158, 21, "155490942410714727059", -157},
  {7.4887945899900666608095549e-38, 4, "7489", -37},
  {4.5311484410012885134759283e-302, 12, "4531148441", -301},
  {2.2756269363125925201407041e+213, 4, "2276", 214},
  {1.8580126892155769013286577e-80, 10, "1858012689", -79},
  {4.1501361538095271003358526e+124, 4, "415", 125},
  {5.8225015836688786925388770e+269, 12, "582250158367", 270},
  {2.1498916033047492887345345e-217, 13, "2149891603305", -216},
  {5.5030731854888460130425040e-278, 5, "55031", -277},
  {7.9015422422154633342872571e-282, 15, "790154224221546", -281},
  {2.6959703099885186626810955e+172, 18, "269597030998851866", 173},
  {1.2196896761111088940929045e+222, 11, "12196896761", 223},
  {3.3786027480456541741348141e-151, 18, "337860274804565417", -150},
  {3.9278382245038012004480502e-161, 2, "39", -160},
  {3.7979762711527502448104472e-269, 12, "379797627115", -268},
  {1.6167081146701000632063730e+150, 11, "16167081147", 151},
  {6.5199328028123024175584696e+202, 14, "65199328028123", 203},
  {2.6285440115840056911011500e+39, 4, "2629", 40},
  {9.3419485072091741927167858e-113, 5, "93419", -112},
  {6.3276010946749193191542363e-19, 13, "6327601094675", -18},
  {2.2989993703149646077260016e-163, 12, "229899937031", -162},
  {3.9945520497053983800891377e+161, 13, "3994552049705", 162},
  {1.1030349136322650544384666e-05, 10, "1103034914", -4},
  {1.3702452875160459912011855e-184, 5, "13702", -183},
  {4.2588064344474735321298845e-41, 4, "4259", -40},
  {9.7133552289553778533019631e+259, 8, "97133552", 260},
  {1.7081037727378976032924224e-307, 19, "1708103772737897603", -306},
  {8.1785435102553001545252155e+36, 21, "817854351025530015453", 37},
  {3.2136110545494515707164516e+133, 8, "32136111", 134},
  {3.0723396790943160367321682e-186, 11, "30723396791", -185},
  {2.5379893951898697567468779e-206, 6, "253799", -205},
  {7.4082475859252920823663126e-62, 3, "741", -61},
  {1.4826761430191544510461573e+290, 6, "148268", 291},
  {4.6015114409393594807412366e+189, 11, "46015114409", 190},
  {8.1730794740619317153975692e+189, 1, "8", 190},
  {8.9031866593486367652067215e-57, 18, "890318665934863677", -56},
  {4.1024318498711109824100816e-61, 5, "41024", -60},
  {7.4000680444688009629317094e+02, 13, "7400068044469", 3},
  {1.2431975918600097953160198e+297, 5, "12432", 298},
  {2.6604218148439700351732471e-14, 1, "3", -13},
  {4.2875857624894891979998711e-134, 14, "42875857624895", -133},
  {3.1703481335038626680476634e-234, 15, "317034813350386", -233},
  {4.1439413721267438486615209e-16, 11, "41439413721", -15},
  {7.2793262288807120977580611e-283, 11, "72793262289", -282},
  {2.3549674472928027277066644e-289, 20, "23549674472928027277", -288},
  {1.8593239330296286846936979e-206, 1, "2", -205},
  {1.7022832741582379347095918e-280, 13, "1702283274158", -279},
  {1.3428886623968575468142194e-92, 2, "13", -91},
  {6.4539218874002134798439822e-117, 10, "6453921887", -116},
  {5.7835437911127304167342651e+188, 19, "5783543791112730417", 189},
  {7.2260265409808704253669027e+54, 19, "7226026540980870425", 55},
  {1.7421266775630217417757711e+175, 1, "2", 176},
  {1.9760989381599177241999321e-04, 20, "19760989381599177242", -3},
  {3.5497294811871887360000000e+18, 16, "3549729481187189", 19},
  {1.8889301172629967964510377e-102, 16, "1888930117262997", -101},
  {4.3466942458808826463330619e+50, 4, "4347", 51},
  {1.9461170093230217031548650e-264, 12, "194611700932", -263},
  {1.6569301198606978084253717e+53, 9, "165693012", 54},
  {4.8612500872301157226537788e+184, 20, "48612500872301157227", 185},
  {3.9598227725639719243556811e+239, 21, "395982277256397192436", 240},
  {3.6535408631109828715131835e+54, 2, "37", 55},
  {1.6853425606429499127456250e-70, 17, "16853425606429499", -69},
  {2.5886953588180506408757276e-192, 16, "2588695358818051", -191},
  {1.1158889637574143076711271e-178, 18, "111588896375741431", -177},
  {6.7000990797472287500000000e+14, 15, "670009907974723", 15},
  {2.1616105771510326299815249e+257, 10, "2161610577", 258},
  {2.9927028317748959585914828e+99, 17, "2992702831774896", 100},
  {3.0405272590215187558699237e+289, 9, "304052726", 290},
  {2.3380441067392708000000000e+16, 15, "233804410673927", 17},
  {5.1579642910831966950617799e+97, 19, "5157964291083196695", 98},
  {1.2194745462244959711004702e-141, 21, "12194745462244959711", -140},
  {1.6258188274111804456771382e-40, 14, "16258188274112", -39},
  {1.1936019123889812721800675e+48, 14, "1193601912389", 49},
  {3.1291392862865479944961176e-08, 19, "3129139286286547994", -7},
  {9.6028664320652405978098148e-104, 19, "9602866432065240598", -103},
  {1.1325755977903137713355327e-44, 1, "1", -43},
  {1.5464333470271715833711117e-130, 5, "15464", -129},
  {3.4337899467547759124927932e+83, 15, "343378994675478", 84},
  {5.2443383451848186370865873e-86, 2, "52", -85},
  {1.3728704792271748625681907e-234, 10, "1372870479", -233},
  {7.1971615478025267242924000e-131, 2, "72", -130},
  {1.3426464871329574218750000e+13, 1, "1", 14},
  {3.4241740277271737147618130e-120, 2, "34", -119},
  {2.1987046296905729885232470e-263, 19, "2198704629690572989", -262},
  {2.3106626324412836803959027e-250, 21, "23106626324412836804", -249},
  {8.2101565351504791272378069e+155, 9, "821015654", 156},
  {8.5212921021446930971359843e-43, 16, "8521292102144693", -42},
  {1.4083911269095748238870845e-288, 3, "141", -287},
  {1.3894716190751863123550948e+194, 5, "13895", 195},
  {5.9355175390901604068924570e-33, 1, "6", -32},
  {8.1343539020118866957515731e-238, 19, "8134353902011886696", -237},
  {8.8562577290431597527655998e-305, 5, "88563", -304},
  {2.1445876948545483460724027e-149, 20, "21445876948545483461", -148},
  {2.0332498884210061794558710e-91, 17, "20332498884210062", -90},
  {9.4552112808299627160761675e+272, 2, "95", 273},
  {9.5632969575082358266442265e+283, 13, "9563296957508", 284},
  {2.3658296131665792364940204e+29, 17, "23658296131665792", 30},
  {2.9666386742424850511021448e-11, 17, "29666386742424851", -10},
  {5.8720723507436955713396233e+199, 9, "587207235", 200},
  {2.8670832541552031730542259e-148, 15, "28670832541552", -147},
  {1.5110044585000717036225391e+244, 2, "15", 245},
  {7.4470697586442476764662627e+87, 20, "74470697586442476765", 88},
  {3.7509007546881710811554820e+108, 15, "375090075468817", 109},
  {5.2809372819582510837347832e+294, 1, "5", 295},
  {7.9137682600004480806026956e-46, 18, "791376826000044808", -45},
  {8.1300176671057648071879088e-77, 12, "813001766711", -76},
  {9.4380949154713836942017713e+100, 10, "9438094915", 101},
  {2.3303311819380643755755461e+261, 11, "23303311819", 262},
  {4.3302292489141472490498777e+75, 14, "43302292489141", 76},
  {7.4326887021336928256482345e+27, 4, "7433", 28},
  {2.0931656815520616589421796e+251, 20, "20931656815520616589", 252},
  {8.0510333885001121975589570e-77, 12, "80510333885", -76},
  {4.4924763340491295292235416e-277, 15, "449247633404913", -276},
  {9.2087994859292739902181779e-62, 16, "9208799485929274", -61},
  {8.2285190748436511349303700e-106, 17, "82285190748436511", -105},
  {2.7088170949629785608738617e+227, 13, "2708817094963", 228},
  {2.1981044398078034450260100e+266, 4, "2198", 267},
  {2.2835249554705521861669419e-216, 11, "22835249555", -215},
  {3.8407078818694318842825177e-22, 3, "384", -21},
  {3.0507133300040649913215621e+69, 1, "3", 70},
  {1.9052721678501774440138498e+137, 14, "19052721678502", 138},
  {4.2371588516918864483156468e-190, 21, "423715885169188644832", -189},
  {5.0060074765552043723667501e+191, 20, "50060074765552043724", 192},
  {1.7193924800179270519420751e-229, 11, "171939248", -228},
  {2.8767905391554797569026384e+244, 7, "2876791", 245},
  {3.0049840704781942783524301e-40, 15, "300498407047819", -39},
  {4.5927488992399346827803435e+151, 18, "459274889923993468", 152},
  {1.2905907381975951878790198e+243, 21, "129059073819759518788", 244},
  {1.1248147285296044674314537e+189, 6, "112481", 190},
  {1.4992510381327608367985763e+78, 12, "149925103813", 79},
  {6.6452296784843951870285461e+91, 2, "66", 92},
  {1.4090024218359992453081851e-65, 17, "14090024218359992", -64},
  {8.0036738530917512814668615e+192, 8, "80036739", 193},
  {1.4394344019611936359715962e-140, 3, "144", -139},
  {9.8434680988347989464504315e+265, 9, "98434681", 266},
  {7.1736980028538344588056422e-50, 4, "7174", -49},
  {1.0896414155303355702647547e+108, 18, "108964141553033557", 109},
  {2.2789904053826557350468677e+285, 19, "2278990405382655735", 286},
  {1.9246834354110456334821716e-82, 16, "1924683435411046", -81},
  {1.7137659619893750855103399e-179, 21, "171376596198937508551", -178},
  {8.1649595405592028601526829e-293, 16, "8164959540559203", -292},
  {3.3591809788533144485650600e+38, 16, "3359180978853314", 39},
  {1.4213440912775083835517433e+192, 9, "142134409", 193},
  {1.8908616921312973982666602e-250, 8, "18908617", -249},
  {8.9868669520039229296184446e-295, 12, "8986866952", -294},
  {4.3874075970064038183331052e-244, 4, "4387", -243},
  {8.8202223418298517158908284e+278, 9, "882022234", 279},
  {3.6775675257969979509443581e+300, 2, "37", 301},
  {1.7915345163610116229999879e+165, 10, "1791534516", 166},
  {3.1930674888805270530636249e-242, 7, "3193067", -241},
  {1.7007832334826536895369462e-182, 21, "170078323348265368954", -181},
  {3.8688298134032370813714675e+267, 18, "386882981340323708", 268},
  {9.1528005233122318153580141e-184, 3, "915", -183},
  {5.0280666808617272000000000e+16, 12, "502806668086", 17},
  {1.2413775668376509832187073e-37, 19, "1241377566837650983", -36},
  {3.4696030063213540145696166e-71, 5, "34696", -70},
  {2.7967315004706186284131122e-05, 17, "27967315004706186", -4},
  {2.3373306432583179442642223e+28, 10, "2337330643", 29},
  {2.2558946808947443091349348e-46, 8, "22558947", -45},
  {2.9075341870943063828694036e+208, 13, "2907534187094", 209},
  {9.7324658600641998370612657e-265, 9, "973246586", -264},
  {2.7364986613374518907898138e+60, 9, "273649866", 61},
  {6.6072873503422032415045981e-50, 3, "661", -49},
  {6.1601097908375482412739516e+45, 12, "616010979084", 46},
  {6.1437877852759104069235718e-01, 14, "61437877852759", 0},
  {5.3090581021767727250344124e+234, 2, "53", 235},
  {5.9597799974971784676625482e+231, 19, "5959779997497178468", 232},
  {4.8802878765521124598406823e+272, 9, "488028788", 273},
  {9.3020568098910018633198330e-251, 7, "9302057", -250},
  {3.8764383579198302159757093e-264, 19, "3876438357919830216", -263},
  {3.2554602082014887386896975e+270, 16, "3255460208201489", 271},
  {1.2705674134780302590284488e-30, 14, "1270567413478", -29},
  {1.5724302178617581844664965e+247, 19, "1572430217861758184", 248},
  {7.0845386401077593970103130e+121, 4, "7085", 122},
  {9.8222768667571874745122710e+109, 6, "982228", 110},
  {2.9313202931014881533139537e+169, 13, "2931320293101", 170},
  {1.0107790073133098015831720e+142, 1, "1", 143},
  {1.7004208136584242083699792e+02, 17, "17004208136584242", 3},
  {1.8768000220426535225313922e+179, 7, "18768", 180},
  {3.1948282043352574780602960e-71, 14, "31948282043353", -70},
  {7.0578113074111562949740043e-202, 2, "71", -201},
  {3.3068727565127250368388313e+77, 6, "330687", 78},
  {4.4516072552018073600000000e+17, 1, "4", 18},
  {3.5239432973828919285684013e+286, 2, "35", 287},
  {9.7827878962633088845968739e-182, 19, "9782787896263308885", -181},
  {2.0073909645467282045948706e-17, 15, "200739096454673", -16},
  {6.6173575612394652193680513e+299, 1, "7", 300},
  {2.7980769929337865693548532e-214, 4, "2798", -213},
  {2.0957482844244816000000000e+16, 10, "2095748284", 17},
  {9.4938790290083416862690296e-240, 2, "95", -239},
  {3.0104275424941735488685634e-11, 9, "301042754", -10},
  {1.8689237805155251914375619e+156, 19, "1868923780515525191", 157},
  {4.0113070199151396475966426e-67, 5, "40113", -66},
  {4.4939707156952436527136651e+303, 10, "4493970716", 304},
  {3.1527854054050159216133280e-80, 13, "3152785405405", -79},
  {1.2566513852755854111510050e-70, 1, "1", -69},
  {1.8897812196994536914001089e-225, 7, "1889781", -224},
  {5.7674560009901951537299289e+290, 21, "576745600099019515373", 291},
  {6.3152801458882043060529764e+269, 18, "631528014588820431", 270},
  {5.3963470791559804886633866e-252, 10, "5396347079", -251},
  {4.7336452222096940969277580e+169, 11, "47336452222", 170},
  {1.1955324502170234354725887e-216, 4, "1196", -215},
  {1.9784551242160216091870854e-221, 4, "1978", -220},
  {5.7607467404495569765743246e-218, 11, "57607467404", -217},
  {1.3842242413095855459089031e+141, 19, "1384224241309585546", 142},
  {1.8007384661751339512948769e+230, 21, "180073846617513395129", 231},
  {5.4483240729343466444084262e+154, 10, "5448324073", 155},
  {2.5877626735024158323096809e+183, 12, "25877626735", 184},
  {1.0635052044867796325683594e+11, 14, "10635052044868", 12},
  {2.6663321425305462216777673e+282, 10, "2666332143", 283},
  {1.8753750241505532746951530e+31, 7, "1875375", 32},
  {2.2685220730615200366781607e+60, 9, "226852207", 61},
  {1.3952698911004450928683320e-181, 19, "1395269891100445093", -180},
  {4.2636600564010711848842256e-63, 2, "43", -62},
  {3.1275549166298688248190518e+233, 1, "3", 234},
  {3.2715771416429981760419276e+80, 18, "327157714164299818", 81},
  {2.8239557644056225015213905e+185, 20, "28239557644056225015", 186},
  {1.1178127822433084896970284e+300, 1, "1", 301},
  {2.7952647224309006629529187e-149, 6, "279526", -148},
  {1.1323329181733078705079835e-284, 4, "1132", -283},
  {1.7300024002540027812054475e-244, 8, "17300024", -243},
  {3.7780641882511124886383880e-19, 13, "3778064188251", -18},
  {5.9376466414937689537910552e+249, 16, "5937646641493769", 250},
  {8.4256317570855087121863409e-253, 3, "843", -252},
  {1.2251206900346510745957490e-206, 15, "122512069003465", -205},
  {1.3706090805103824224216953e-46, 11, "13706090805", -45},
  {9.4868392251228372556245574e-156, 5, "94868", -155},
  {1.5662198388047872867900878e+04, 8, "15662198", 5},
  {5.5583722167492625833646294e-140, 20, "55583722167492625834", -139},
  {3.8910790784902384106832339e+86, 11, "38910790785", 87},
  {1.8609167405998913903758210e-160, 12, "18609167406", -159},
  {1.5852402731673156056203052e-288, 1, "2", -287},
  {3.4012941491886435901786609e+290, 20, "34012941491886435902", 291},
  {4.7157378313099070312500000e+13, 3, "472", 14},
  {1.6290063779012425718947429e-302, 21, "162900637790124257189", -301},
  {1.8401970693966355886610570e+238, 17, "18401970693966356", 239},
  {9.7906972042993822978632861e+191, 20, "97906972042993822979", 192},
  {2.1478249730889521950974439e+244, 9, "214782497", 245},
  {1.5704633857903713852894947e-268, 19, "1570463385790371385", -267},
  {1.5666810625788070562714353e+108, 11, "15666810626", 109},
  {5.1307770328854118706538643e+283, 17, "51307770328854119", 284},
  {6.9265146493484126276742862e-44, 19, "6926514649348412628", -43},
  {4.8083746950468797048051546e+88, 5, "48084", 89},
  {1.4153379017975765367712445e+95, 5, "14153", 96},
  {5.2985036370762595961341050e+113, 2, "53", 114},
  {8.9943446224488245597665208e-295, 3, "899", -294},
  {1.8075525900711966845803447e-242, 11, "18075525901", -241},
  {7.2527212132660373472550613e-96, 1, "7", -95},
  {1.4013428311868692271021149e+76, 8, "14013428", 77},
  {1.2381129536406629168147750e+210, 1, "1", 211},
  {1.2953778521322463209481977e-34, 16, "1295377852132246", -33},
  {7.4033674755844066942166842e+224, 13, "7403367475584", 225},
  {4.5756052717044258599432349e-239, 9, "457560527", -238},
  {1.4000814144547043158177623e-157, 8, "14000814", -156},
  {1.1857913377208820494125360e+36, 2, "12", 37},
  {3.6728494741637298659497901e+01, 3, "367", 2},
  {4.7878259730207274121631178e+239, 1, "5", 240},
  {9.6619171301664736036270268e-208, 2, "97", -207},
  {3.1818466740999501206615918e-276, 13, "31818466741", -275},
  {2.7239886210690566409707992e+82, 6, "272399", 83},
  {1.8907088771083734210815947e-144, 21, "189070887710837342108", -143},
  {6.4075799464127450953892734e-182, 12, "640757994641", -181},
  {2.6306722941462956328208543e+178, 19, "2630672294146295633", 179},
  {2.2412135363301741490440111e+49, 9, "224121354", 50},
  {2.4797132508817774288664796e-79, 19, "2479713250881777429", -78},
  {8.2551320257332018891803816e-18, 14, "82551320257332", -17},
  {3.3375202314212947039815124e+247, 5, "33375", 248},
  {3.8398724590553399162369081e+172, 1, "4", 173},
  {2.7520773649637186530836902e+233, 4, "2752", 234},
  {6.3342573356745057465145780e-270, 8, "63342573", -269},
  {7.1904654455570511680875323e-70, 16, "7190465445557051", -69},
  {4.5854727982332460917377566e-140, 12, "458547279823", -139},
  {2.8768931944819112571363941e-258, 20, "28768931944819112571", -257},
  {4.0375401596001830085163425e-16, 14, "40375401596002", -15},
  {2.0610805558654955672775198e+192, 16, "2061080555865496", 193},
  {2.5246490695202793057603535e+81, 20, "25246490695202793058", 82},
  {6.9662414730337911895069095e-201, 8, "69662415", -200},
  {2.6392689647649820424847825e+293, 6, "263927", 294},
  {7.4714351622051069517601733e+229, 5, "74714", 230},
  {3.6513850697881803447421937e+102, 2, "37", 103},
  {2.0235255131598824108831925e+245, 7, "2023526", 246},
  {2.6645000827038925520083146e+231, 21, "266450008270389255201", 232},
  {3.2316792247310457818838064e+112, 19, "3231679224731045782", 113},
  {1.9230109523514150289858824e-32, 21, "192301095235141502899", -31},
  {3.4033308566103962881195538e+205, 4, "3403", 206},
  {8.9944846585240391767288221e-24, 11, "89944846585", -23},
  {3.6088620744913911655879836e+50, 20, "36088620744913911656", 51},
  {6.1883429610824536317099767e+300, 5, "61883", 301},
  {6.6725080825802495965153316e+219, 3, "667", 220},
  {2.3589802981546487137265444e-01, 19, "2358980298154648714", 0},
  {3.9346656957207257719244647e+291, 8, "39346657", 292},
  {4.1688600990036728186224402e-239, 14, "41688600990037", -238},
  {9.7839076730540095596610761e-157, 13, "9783907673054", -156},
  {8.1143330298241915110543841e+269, 13, "8114333029824", 270},
  {1.0267817805342318585937730e-200, 18, "102678178053423186", -199},
  {1.2578924098795279312742386e+88, 12, "125789240988", 89},
  {5.2607375744078920106364323e-177, 15, "526073757440789", -176},
  {1.6835591505819155195616960e+306, 19, "168355915058191552", 307},
  {7.3014673667821960449218750e+09, 4, "7301", 10},
  {4.1989832490442064065193328e+124, 5, "4199", 125},
  {9.7137691226741194935892759e-209, 2, "97", -208},
  {1.8599479728326591246472028e-193, 9, "185994797", -192},
  {1.5730608108255096370874141e+31, 21, "157306081082550963709", 32},
  {4.4252636768305213100176180e+178, 15, "442526367683052", 179},
  {3.8168434456924367974674492e-97, 19, "3816843445692436797", -96},
  {1.3435867120500132275901880e-296, 7, "1343587", -295},
  {5.0594139267594840877229599e+176, 10, "5059413927", 177},
  {3.4285789544226952516891164e+142, 6, "342858", 143},
  {4.0207519563064899862149501e+42, 13, "4020751956306", 43},
  {1.2752836145897629913176100e-296, 7, "1275284", -295},
  {3.6828460469156574066526214e-84, 1, "4", -83},
  {8.1457784784068374070776595e-102, 2, "81", -101},
  {3.4063434775445594131599090e-16, 20, "34063434775445594132", -15},
  {6.3300708890139783076660292e-214, 9, "633007089", -213},
  {1.1509325206439505976849224e-116, 21, "115093252064395059768", -115},
  {4.0766098154525202801323758e+01, 1, "4", 2},
  {5.2057286138985610120049203e-119, 15, "520572861389856", -118},
  {1.0973602349788778553829616e+02, 13, "1097360234979", 3},
  {5.9052917072925128188985305e-192, 19, "5905291707292512819", -191},
  {5.6629668018790581320203376e+34, 1, "6", 35},
  {1.4328411412633029974471361e+170, 3, "143", 171},
  {1.3261396035278597477422305e+247, 15, "132613960352786", 248},
  {2.0673592205565139744034463e+223, 19, "2067359220556513974", 224},
  {9.6089586848384299146641406e-135, 3, "961", -134},
  {1.0286657588888853664994054e-181, 9, "102866576", -180},
  {1.9055891647198275643805823e+146, 6, "190559", 147},
  {2.3746392753763080000000000e+16, 20, "2374639275376308", 17},
  {2.5337664320885993608033893e+224, 5, "25338", 225},
  {4.9148516183237848742822649e-290, 16, "4914851618323785", -289},
  {3.8498250839931124573922716e+03, 17, "38498250839931125", 4},
  {2.6337584464891762409264844e+231, 15, "263375844648918", 232},
  {1.8176070201932446148284897e+53, 7, "1817607", 54},
  {1.3050283128483159280792342e+274, 16, "1305028312848316", 275},
  {1.0337379675007965159095041e-125, 19, "1033737967500796516", -124},
  {4.4549673199522237932531023e+106, 12, "445496731995", 107},
  {1.9732152222504685218814554e-47, 6, "197322", -46},
  {9.8822121924434351458319330e-188, 13, "9882212192443", -187},
  {1.4452627954926642000322863e+65, 4, "1445", 66},
  {1.9396950362864993086648679e-287, 1, "2", -286},
  {1.6419067426267603079134851e+251, 17, "16419067426267603", 252},
  {3.9891162470015878400925718e-13, 10, "3989116247", -12},
  {9.9984694218031105794871809e-131, 9, "999846942", -130},
  {1.0740314937195985885448131e-271, 18, "107403149371959859", -270},
  {9.8803411409015621871774274e-241, 15, "988034114090156", -240},
  {1.0563282586317780011024785e+232, 19, "1056328258631778001", 233},
  {5.0883664858740460836197597e-121, 10, "5088366486", -120},
  {2.2698821612610884843738363e-185, 20, "22698821612610884844", -184},
  {1.8424310165370466906265461e+291, 14, "1842431016537", 292},
  {6.4289572232959260640741730e-12, 20, "64289572232959260641", -11},
  {2.7832628875726243390147638e-209, 4, "2783", -208},
  {3.6012147844621225298524864e+168, 15, "360121478446212", 169},
  {1.0777487862179749118551645e+173, 10, "1077748786", 174},
  {1.9734081604867067225988424e+163, 10, "197340816", 164},
  {3.0345958474241426968241706e+50, 8, "30345958", 51},
  {6.6655334451435555105135288e+74, 15, "666553344514356", 75},
  {7.4312157182246642136223676e+283, 13, "7431215718225", 284},
  {2.7371455106493194512081825e-23, 9, "273714551", -22},
  {9.8556628158385408857381243e+145, 6, "985566", 146},
  {1.6202794489070059804630371e-86, 13, "1620279448907", -85},
  {8.2438655452636158862826837e-304, 11, "82438655453", -303},
  {2.7733083445608171022591456e-23, 10, "2773308345", -22},
  {1.8386505573980131686884815e-190, 5, "18387", -189},
  {3.8641950915904805257024008e-202, 14, "38641950915905", -201},
  {9.5104447464209238281250000e+12, 21, "951044474642092382813", 13},
  {6.3023910167809472728683820e+211, 1, "6", 212},
  {1.0248147472604422943476602e-269, 9, "102481475", -268},
  {7.4469984064765653741020776e-237, 17, "74469984064765654", -236},
  {5.9428446668930600142078349e+227, 6, "594284", 228},
  {5.6577229100847122243007270e-218, 11, "56577229101", -217},
  {1.7789154967658156391042261e-38, 14, "17789154967658", -37},
  {2.7627125521781372309601355e-14, 19, "2762712552178137231", -13},
  {6.4306749083228111365359074e-245, 9, "643067491", -244},
  {2.3041845397111303457746968e-231, 17, "23041845397111303", -230},
  {1.3381542749267920184716414e-160, 2, "13", -159},
  {4.1254046120710216502683545e+113, 4, "4125", 114},
  {1.2376627864438765024551506e+114, 16, "1237662786443877", 115},
  {1.1585898575200586624619781e+253, 12, "115858985752", 254},
  {5.2385159004878757244112455e-140, 16, "5238515900487876", -139},
  {9.7786904148409402910724934e-270, 11, "97786904148", -269},
  {4.1285565237176189691998459e-23, 16, "4128556523717619", -22},
  {8.9153235637855478815654750e+228, 13, "8915323563786", 229},
  {2.8388621153389458304942689e+163, 7, "2838862", 164},
  {1.6292500717821030046842377e+176, 5, "16293", 177},
  {3.4277244501432972028851509e+06, 7, "3427724", 7},
  {1.3233447386187449999236557e+92, 5, "13233", 93},
  {3.7871294596451193225845919e+161, 8, "37871295", 162},
  {8.9885779969177759193382160e+149, 5, "89886", 150},
  {5.6143510592068576766853873e-13, 10, "5614351059", -12},
  {2.5301196199391388380375849e+73, 14, "25301196199391", 74},
  {4.4648780271158551877109320e-51, 11, "44648780271", -50},
  {6.4671883728959795106929434e+110, 16, "646718837289598", 111},
  {2.2676358200271860890805264e+293, 10, "226763582", 294},
  {3.8335196371884424163459591e-305, 4, "3834", -304},
  {1.4844718194748826489533806e-297, 6, "148447", -296},
  {6.3186666717891746589213670e+215, 19, "6318666671789174659", 216},
  {4.2986914409220516676396012e+117, 14, "42986914409221", 118},
  {3.8297118016157346894465976e-183, 18, "382971180161573469", -182},
  {5.8709545677911696152677537e+214, 5, "5871", 215},
  {2.7796280166205503159343731e-185, 17, "27796280166205503", -184},
  {4.5970715458055128429075111e-80, 3, "46", -79},
  {6.7807132348089348199150779e+278, 13, "6780713234809", 279},
  {7.0101971257124511113487156e-264, 7, "7010197", -263},
  {2.1962190147165807808199644e-147, 18, "219621901471658078", -146},
  {5.9590761472830336420436481e-02, 20, "5959076147283033642", -1},
  {4.6229554496229079907128700e+247, 10, "462295545", 248},
  {1.0624101304622311236586556e-107, 6, "106241", -106},
  {4.4491308053774780027435250e-165, 8, "44491308", -164},
  {3.3884252838963387085475516e-236, 15, "338842528389634", -235},
  {1.5977363958491260200335538e+110, 20, "159773639584912602", 111},
  {2.7479094936086160512099620e+147, 15, "274790949360862", 148},
  {1.5708712437888235234238000e+239, 19, "1570871243788823523", 240},
  {8.1090101094409013849527956e-83, 21, "810901010944090138495", -82},
  {3.3859808489684388261015361e-26, 11, "3385980849", -25},
  {7.6168431703680249366478597e-153, 10, "761684317", -152},
  {4.9231003447761799195495643e+56, 18, "492310034477617992", 57},
  {1.4592357276322163572233674e-116, 2, "15", -115},
  {8.8365383829643743698722599e-185, 21, "883653838296437436987", -184},
  {2.2171773657586884603879652e+207, 15, "221717736575869", 208},
  {4.1605590333054008276733945e-25, 10, "4160559033", -24},
  {4.3261494785303995433267106e+131, 18, "432614947853039954", 132},
  {1.3759213709515577465666809e+72, 10, "1375921371", 73},
  {2.3489663377832625070785157e+206, 9, "234896634", 207},
  {1.8971181511137078018231077e-59, 16, "1897118151113708", -58},
  {3.7867239422180019887899236e-292, 13, "3786723942218", -291},
  {5.8367757306687717102119423e+184, 15, "583677573066877", 185},
  {1.3053186081967937374027135e+39, 3, "131", 40},
  {2.1166051550362380656214128e+110, 5, "21166", 111},
  {4.4910744304775867880993170e+86, 3, "449", 87},
  {6.1920609249321252634929134e-302, 10, "6192060925", -301},
  {1.7154693043417902396529854e+168, 21, "171546930434179023965", 169},
  {1.2773711422125144238553660e+180, 8, "12773711", 181},
  {2.5012018458920226059364897e-98, 16, "2501201845892023", -97},
  {9.0647824476504572066059090e-201, 12, "906478244765", -200},
  {5.4404426385831128341616552e-125, 1, "5", -124},
  {1.5597139325398160040995275e-09, 1, "2", -8},
  {1.3946252979706828749773440e+49, 5, "13946", 50},
  {1.2762104716852343608689262e+292, 10, "1276210472", 293},
  {4.5144898318158611971144888e+184, 21, "451448983181586119711", 185},
  {4.0837108007710766798262031e-264, 5, "40837", -263},
  {8.6956545920760742016564649e-07, 14, "86956545920761", -6},
  {5.4393140582889988978583843e-224, 9, "543931406", -223},
  {1.7958747214738309734258962e+45, 19, "1795874721473830973", 46},
  {2.9000687842605538281662501e+259, 3, "29", 260},
  {8.1634061844555008061503960e-51, 13, "8163406184456", -50},
  {5.8776595254401933830454227e-21, 19, "5877659525440193383", -20},
  {2.1714214457582360783639602e-107, 12, "217142144576", -106},
  {1.0562726896843901533999717e-166, 10, "105627269", -165},
  {2.4605524347619891467763165e-199, 2, "25", -198},
  {3.8803114376344232030815780e+211, 1, "4", 212},
  {8.7309360927244271023585884e-100, 21, "873093609272442710236", -99},
  {2.4439118162365928844999779e+167, 7, "2443912", 168},
  {5.7946144839327501761348662e+92, 21, "579461448393275017613", 93},
  {4.2874845815743136194681721e-54, 20, "42874845815743136195", -53},
  {1.4473211152301974378797111e+94, 18, "144732111523019744", 95},
  {1.2689775807905227103139226e+157, 9, "126897758", 158},
  {4.9017977830394635953692894e+304, 13, "4901797783039", 305},
  {3.8579080238016286487365978e-186, 17, "38579080238016286", -185},
  {1.7709761810745876945017323e+226, 8, "17709762", 227},
  {1.3786305102164153287467161e+307, 7, "1378631", 308},
  {5.4383774679909940810454872e+266, 6, "543838", 267},
  {4.2663561442407653808593750e+10, 12, "426635614424", 11},
  {4.4188871081310253936862923e+50, 13, "4418887108131", 51},
  {2.4769180149508451264390658e-190, 11, "2476918015", -189},
  {3.8715034880712786449700308e+285, 15, "387150348807128", 286},
  {5.5520885952593820843464165e-79, 11, "55520885953", -78},
  {1.1834913687272476195107269e-34, 19, "118349136872724762", -33},
  {5.7238721458591870736352178e-133, 2, "57", -132},
  {3.2293954640337582028103069e-15, 14, "32293954640338", -14},
  {5.5098224907529570065139807e+115, 2, "55", 116},
  {8.8890146517623796011651629e-206, 3, "889", -205},
  {1.1776302308479068064106522e-216, 4, "1178", -215},
  {2.8271554864578666431578718e-129, 10, "2827155486", -128},
  {2.2880185424323347324098431e-274, 12, "228801854243", -273},
  {2.1845939947553875931035538e+79, 20, "21845939947553875931", 80},
  {4.4070746255461120102926148e-96, 18, "440707462554611201", -95},
  {3.5367838341776375901453341e+132, 16, "3536783834177638", 133},
  {2.8532092641594583032298099e-207, 5, "28532", -206},
  {5.8645405164427199012490179e+187, 2, "59", 188},
  {2.0810012717916158514229531e+81, 17, "20810012717916159", 82},
  {2.8161756282926215196966946e+253, 19, "281617562829262152", 254},
  {1.1100115042917357241112985e-07, 8, "11100115", -6},
  {1.2644010041436255695150628e+287, 18, "126440100414362557", 288},
  {6.2043911252571724234234230e+174, 7, "6204391", 175},
  {7.4274088154247331117414389e+158, 21, "742740881542473311174", 159},
  {3.2522403663310614089012061e-282, 15, "325224036633106", -281},
  {3.1160730068710472224299977e+37, 16, "3116073006871047", 38},
  {4.8492638430532754652527046e-236, 9, "484926384", -235},
  {4.0255457867240414320944078e+213, 18, "402554578672404143", 214},
  {5.1964420024689521763348272e+108, 18, "519644200246895218", 109},
  {1.3983807246193086062973928e-226, 17, "13983807246193086", -225},
  {7.5810370806001600447420985e+66, 19, "7581037080600160045", 67},
  {3.2158437338912913681274231e+239, 13, "3215843733891", 240},
  {9.8064986056116712957457034e+237, 15, "980649860561167", 238},
  {2.1879988563863203727348677e-253, 19, "2187998856386320373", -252},
  {6.2614953444811073077732526e+122, 20, "62614953444811073078", 123},
  {2.9422008487896526914331347e+78, 2, "29", 79},
  {4.2012413364099687083606732e-284, 6, "420124", -283},
  {8.9578379532822887342923935e+191, 4, "8958", 192},
  {1.0662688131139979269754562e+189, 16, "1066268813113998", 190},
  {8.9599533912418255040583444e-284, 10, "8959953391", -283},
  {3.5366167519528011469499348e-143, 10, "3536616752", -142},
  {4.6597655263968429524612586e-230, 21, "465976552639684295246", -229},
  {1.6677818384370783926931960e+286, 15, "166778183843708", 287},
  {2.8817120205251080451433241e+172, 7, "2881712", 173},
  {8.0197746528301631769863889e+03, 7, "8019775", 4},
  {7.4500344251753516582165389e-155, 3, "745", -154},
  {6.6794565511947700714609863e-164, 10, "6679456551", -163},
  {2.0172637352120621666907929e-291, 8, "20172637", -290},
  {7.7554396108703717277228958e+216, 15, "775543961087037", 217},
  {2.5922736923246130833092852e-203, 19, "2592273692324613083", -202},
  {1.3832883742865940098191693e-227, 7, "1383288", -226},
  {2.4005999883689616271004777e+258, 3, "24", 259},
  {1.7982729280116943221492365e-214, 14, "17982729280117", -213},
  {4.1102337910742233799170372e+291, 13, "4110233791074", 292},
  {1.9682361849906421661376953e+10, 3, "197", 11},
  {3.3784674294335164919028443e-213, 3, "338", -212},
  {4.1565240784614690964307721e+279, 10, "4156524078", 280},
  {3.5166293983597582544922653e+168, 19, "3516629398359758254", 169},
  {4.8639535771001165140138761e-121, 4, "4864", -120},
  {4.3619187956087422372620806e-305, 13, "4361918795609", -304},
  {1.9677281268200576482865710e+295, 6, "196773", 296},
  {2.3581842684724286236025720e-278, 13, "2358184268472", -277},
  {8.7010498979749222163903906e+251, 5, "8701", 252},
  {2.4053023762828249220950193e-285, 6, "24053", -284},
  {4.5216982156259976077944534e-117, 2, "45", -116},
  {1.4942750473593947765432594e-261, 8, "1494275", -260},
  {3.6746762457088419660226406e+33, 20, "3674676245708841966", 34},
  {9.2695218579010701724459364e-131, 2, "93", -130},
  {2.0907760751922260672217862e+65, 13, "2090776075192", 66},
  {6.6524075027517066217953154e-150, 17, "66524075027517066", -149},
  {1.9638801795344889282560000e+21, 8, "19638802", 22},
  {3.9955293767653205830360790e-07, 18, "399552937676532058", -6},
  {6.7939659318029410103337760e-224, 16, "6793965931802941", -223},
  {6.3321590320997445045922916e+46, 5, "63322", 47},
  {1.9741873872098591181143779e-260, 21, "197418738720985911811", -259},
  {2.4737924638383966384301854e+70, 5, "24738", 71},
  {2.5890731143314780758741254e+176, 6, "258907", 177},
  {2.2803281031184770911392175e+237, 15, "228032810311848", 238},
  {1.4297130110350962799208240e+219, 20, "14297130110350962799", 220},
  {6.3388058831094189680738090e+63, 16, "6338805883109419", 64},
  {9.3493564092582312130061173e-108, 15, "934935640925823", -107},
  {3.6705420867484657712951107e+207, 8, "36705421", 208},
  {3.4128709928860447147149442e-249, 1, "3", -248},
  {4.4083962192350380579464331e-166, 1, "4", -165},
  {7.9692268420326701284453225e+278, 3, "797", 279},
  {7.3326040131117224682050574e-231, 6, "73326", -230},
  {1.6436066265896180667405615e-109, 19, "1643606626589618067", -108},
  {1.0198313120417779032696863e-252, 10, "1019831312", -251},
  {2.7987214418373471115986223e+160, 14, "27987214418373", 161},
  {3.8104314627353441932853366e-51, 17, "38104314627353442", -50},
  {4.1650326491668325583636829e+283, 18, "416503264916683256", 284},
  {5.4090764113515686209167101e-72, 16, "5409076411351569", -71},
  {1.4415392133756539878495250e-265, 21, "144153921337565398785", -264},
  {2.1252057551283766577048674e-66, 21, "21252057551283766577", -65},
  {5.4720661690041217697969372e+37, 15, "547206616900412", 38},
  {3.4396715973533073315273267e+162, 2, "34", 163},
  {6.5625292467803345925212246e-68, 7, "6562529", -67},
  {1.5424332700547222330599309e+271, 19, "1542433270054722233", 272},
  {5.9861455868459338562032566e-191, 5, "59861", -190},
  {4.2520801992950649418241303e+231, 10, "4252080199", 232},
  {2.4327481610819754587885012e-279, 10, "2432748161", -278},
  {2.6302459881359903376438031e-235, 7, "2630246", -234},
  {1.6405370156980218397063853e+63, 19, "164053701569802184", 64},
  {2.3205882391363939011403157e-219, 21, "232058823913639390114", -218},
  {3.7351982997104464516952222e-248, 4, "3735", -247},
  {7.3372780175754270924890384e+111, 13, "7337278017575", 112},
  {1.5598610041238349722733864e-75, 2, "16", -74},
  {2.5972307992215631242118930e+110, 3, "26", 111},
  {8.9653140477274629678034794e+117, 11, "89653140477", 118},
  {1.5448291861409301619793062e+279, 20, "1544829186140930162", 280},
  {5.7385139417297057837516943e-150, 4, "5739", -149},
  {1.6851311673371472328370445e-104, 4, "1685", -103},
  {5.4633633177996208890876782e-254, 13, "54633633178", -253},
  {1.9976741148864099009403541e-213, 1, "2", -212},
  {3.1383229689200716063361746e-115, 4, "3138", -114},
  {7.2652424340371433062400000e+20, 21, "726524243403714330624", 21},
  {9.3515614700428532838716514e+232, 20, "93515614700428532839", 233},
  {7.5166265025303164401637274e-260, 20, "75166265025303164402", -259},
  {8.0511244458541418070927347e-133, 1, "8", -132},
  {1.7963803392292148470206110e-29, 2, "18", -28},
  {6.3211216215654060240382609e-193, 20, "6321121621565406024", -192},
  {2.2527207823864763304345663e-292, 19, "225272078238647633", -291},
  {8.7364784838151384798569003e+75, 4, "8736", 76},
  {2.3735268954925046663461647e-288, 10, "2373526895", -287},
  {3.7606173863088705466850570e+00, 7, "3760617", 1},
  {1.0510393950965716369949119e-44, 6, "105104", -43},
  {2.7171238741169913871826725e-223, 11, "27171238741", -222},
  {1.0603824671643508715577096e-273, 1, "1", -272},
  {1.7461086097065695837089038e+65, 1, "2", 66},
  {3.6408665061394882368761898e+303, 14, "36408665061395", 304},
  {4.4266655117824362348867682e-161, 20, "44266655117824362349", -160},
  {3.3278693786439152909123879e-235, 13, "3327869378644", -234},
  {1.5384919263472078584042853e+191, 19, "1538491926347207858", 192},
  {4.8652705371821709376904230e-246, 16, "4865270537182171", -245},
  {3.4664601381598940022670278e+106, 20, "34664601381598940023", 107},
  {7.3464163501470945116968318e+133, 1, "7", 134},
  {1.7255019909130981136392375e+234, 15, "17255019909131", 235},
  {1.9465454601748170071677233e+111, 5, "19465", 112},
  {1.0303738817224677338231930e+132, 12, "103037388172", 133},
  {5.3340689266697650146484375e+11, 15, "533406892666977", 12},
  {6.5126694106937486707184759e-173, 19, "6512669410693748671", -172},
  {1.0887153510585966007059665e+251, 19, "1088715351058596601", 252},
  {2.1299591010248017791446002e-72, 21, "212995910102480177914", -71},
  {1.4027279628013766440252224e+219, 13, "1402727962801", 220},
  {5.4406351263935103662284894e+205, 10, "5440635126", 206},
  {1.1467204364783894185933146e-181, 13, "1146720436478", -180},
  {3.2620274841156203899225668e-132, 10, "3262027484", -131},
  {2.0649561879087634054872310e-53, 14, "20649561879088", -52},
  {6.3450114027143144668761440e-132, 12, "634501140271", -131},
  {4.5572757013948194816000000e+19, 11, "45572757014", 20},
  {2.9856039112742357720733621e-225, 2, "3", -224},
  {4.8509323301982640777257570e-308, 16, "4850932330198264", -307},
  {6.8937464057233836207099911e+42, 6, "689375", 43},
  {3.1149764924679183603279450e+165, 7, "3114976", 166},
  {2.3835259310429661075676636e-62, 17, "23835259310429661", -61},
  {1.6909884382133221125920582e+137, 10, "1690988438", 138},
  {2.6026585972654002968789424e+144, 19, "2602658597265400297", 145},
  {3.7110718636728244055304427e-38, 19, "3711071863672824406", -37},
  {8.8298140001485226054478994e+242, 19, "8829814000148522605", 243},
  {2.3962873524239422567891762e+234, 20, "23962873524239422568", 235},
  {2.8094031661746208064617248e-209, 11, "28094031662", -208},
  {7.2169939741575762042094672e-243, 12, "721699397416", -242},
  {6.2808626305520311140629394e-171, 8, "62808626", -170},
  {1.2763429125545887370974105e+239, 18, "127634291255458874", 240},
  {7.6603057016322224846192251e+145, 13, "7660305701632", 146},
  {1.6249523847582922580286064e-301, 15, "162495238475829", -300},
  {3.1617052227736240302934588e+165, 18, "316170522277362403", 166},
  {3.8759574409917678166494746e-264, 21, "387595744099176781665", -263},
  {4.3622108303088874686671797e+132, 8, "43622108", 133},
  {9.7749965647722985728584007e+263, 8, "97749966", 264},
  {1.5235903298782163096456368e+220, 17, "15235903298782163", 221},
  {1.1344934908232373488959778e+82, 19, "1134493490823237349", 83},
  {1.6670218847525330460443696e-65, 11, "16670218848", -64},
  {1.0712678044520490381969805e-32, 19, "1071267804452049038", -31},
  {5.4595910656698168311155298e-67, 8, "54595911", -66},
  {9.0692890031790698834842092e+241, 13, "9069289003179", 242},
  {5.4866958675377090749950148e-24, 9, "548669587", -23},
  {5.8796249691844589634449398e+262, 13, "5879624969184", 263},
  {5.9078472189634150179545234e+235, 12, "590784721896", 236},
  {1.0617090842050999830940859e-250, 19, "1061709084205099983", -249},
  {8.2808771323265061659884333e-256, 21, "828087713232650616599", -255},
  {4.0877812549563943398436757e-289, 9, "408778125", -288},
  {2.8045241227659974762421548e+171, 10, "2804524123", 172},
  {1.6234126275138351935822811e+00, 18, "162341262751383519", 1},
  {3.3661485668567997453224430e-36, 21, "336614856685679974532", -35},
  {4.1514600108745218361061178e+160, 21, "415146001087452183611", 161},
  {1.6476296749281138848653552e+224, 11, "16476296749", 225},
  {7.0922180423832450828666117e+130, 5, "70922", 131},
  {1.7027822774461902832662119e-206, 19, "1702782277446190283", -205},
  {1.2880374925357505585972875e+76, 4, "1288", 77},
  {1.6651540720731053983503501e+282, 19, "1665154072073105398", 283},
  {3.4070439164071597866414286e-93, 21, "340704391640715978664", -92},
  {1.2716834407899310933038641e+205, 12, "127168344079", 206},
  {3.6358135043230219752138724e-102, 5, "36358", -101},
  {4.3377186203873134173087150e+88, 9, "433771862", 89},
  {4.7208273823115162675538329e-26, 18, "472082738231151627", -25},
  {9.5139498544704391879312526e-15, 11, "95139498545", -14},
  {2.5176044857567302371005187e-285, 5, "25176", -284},
  {3.6551831405418964180564624e-227, 2, "37", -226},
  {6.7802805647440694067213083e+160, 2, "68", 161},
  {2.6685765827327087850670262e-110, 12, "266857658273", -109},
  {4.3210929653419726035391227e-227, 9, "432109297", -226},
  {1.8616770343091974831008054e+246, 3, "186", 247},
  {5.8244384075394851609236854e-281, 16, "5824438407539485", -280},
  {5.2850451432806800451554687e+238, 14, "52850451432807", 239},
  {8.1433516213551021756320073e-109, 4, "8143", -108},
  {4.6676303681410518815642228e-301, 2, "47", -300},
  {7.1830701000755896570323824e+258, 1, "7", 259},
  {1.2462290141344770579521868e-89, 19, "1246229014134477058", -88},
  {5.7572701409053026907377758e-160, 3, "576", -159},
  {1.5262009150894438195518072e+302, 19, "152620091508944382", 303},
  {9.5682104502663147571360591e+259, 2, "96", 260},
  {7.5089996364350923605237946e-83, 4, "7509", -82},
  {7.3026156200266728176138803e+257, 9, "730261562", 258},
  {1.3972277243429441552776780e+278, 21, "139722772434294415528", 279},
  {4.8829769990269343358702345e-290, 19, "4882976999026934336", -289},
  {5.5020660665465523025491672e+138, 2, "55", 139},
  {2.5250890840485306762980068e-102, 17, "25250890840485307", -101},
  {2.2008876435627129808381142e+01, 7, "2200888", 2},
  {1.1665772487145259191306386e-231, 11, "11665772487", -230},
  {1.8728429981303134636916916e-304, 3, "187", -303},
  {8.4792940747974693251546587e+212, 1, "8", 213},
  {6.2970734450930737304687500e+11, 10, "6297073445", 12},
  {2.0497299539547731209302628e+158, 11, "2049729954", 159},
  {1.2061619916136966544730981e-306, 5, "12062", -305},
  {2.2340672287921625966470365e-185, 2, "22", -184},
  {9.4335513714325023490749787e+87, 14, "94335513714325", 88},
  {6.4483508803023832023402815e-224, 2, "64", -223},
  {1.1926842537530851353644079e-70, 7, "1192684", -69},
  {1.7698057042611232892248087e+83, 18, "176980570426112329", 84},
  {4.8288495222527246232040365e-83, 8, "48288495", -82},
  {1.9988344346163887962493600e+184, 4, "1999", 185},
  {1.0720604672762273535547178e+67, 10, "1072060467", 68},
  {2.2840531697968207525959105e+212, 4, "2284", 213},
  {3.8995130268648273077153895e-301, 8, "3899513", -300},
  {2.4770044951933966927314659e-73, 9, "24770045", -72},
  {4.5360250942730745542703850e-238, 6, "453603", -237},
  {2.3371175446229938647814461e-284, 8, "23371175", -283},
  {3.9213603877391358004346482e-185, 5, "39214", -184},
  {1.4069836521268736328125000e+13, 21, "140698365212687363281", 14},
  {1.6903658919357296590088645e-229, 21, "169036589193572965901", -228},
  {1.1226846355892121958980012e-199, 19, "1122684635589212196", -198},
  {3.8725192003278451120370922e+219, 1, "4", 220},
  {3.5080455317865267381866719e-181, 20, "35080455317865267382", -180},
  {3.6774589162599895000000000e+15, 10, "3677458916", 16},
  {2.4282184708965443587748659e+26, 13, "2428218470897", 27},
  {2.2271850544267201867671049e+284, 10, "2227185054", 285},
  {1.1424574831344371123196091e+86, 15, "114245748313444", 87},
  {1.7417860527591654101333004e+182, 6, "174179", 183},
  {4.7723510318094866498947470e-160, 8, "4772351", -159},
  {1.7877064733329367034997710e+201, 5, "17877", 202},
  {3.4694453716064017852953114e+109, 12, "346944537161", 110},
  {1.5367984812208419297535623e-265, 10, "1536798481", -264},
  {1.3685480902186208654852465e+186, 18, "136854809021862087", 187},
  {1.7667856551765235163594888e+32, 9, "176678566", 33},
  {2.5291580001026800528801820e+124, 2, "25", 125},
  {7.0031125206720796281424372e-72, 7, "7003113", -71},
  {3.4850800293910820269739240e-92, 5, "34851", -91},
  {9.0714621400666942844296411e-221, 2, "91", -220},
  {1.9488351321905874973722347e+252, 10, "1948835132", 253},
  {2.5093885829448115243204080e-89, 9, "250938858", -88},
  {1.5283897946059474370062073e+271, 7, "152839", 272},
  {3.6747416404649751931382305e+62, 18, "367474164046497519", 63},
  {2.0962147104501374427820900e+228, 16, "2096214710450137", 229},
  {1.6435406215141007360266688e-40, 11, "16435406215", -39},
  {1.7376735758785611524407119e-243, 13, "1737673575879", -242},
  {1.2481296247733200785304353e+91, 20, "12481296247733200785", 92},
  {2.1409958419755279250626690e-281, 4, "2141", -280},
  {6.0330674956064200589459492e+181, 13, "6033067495606", 182},
  {1.8890408158807273790258952e+248, 19, "1889040815880727379", 249},
  {2.5281105429464905612829803e+103, 5, "25281", 104},
  {9.2811940657300730015536623e-170, 20, "92811940657300730016", -169},
  {1.7077254855030168661642053e+292, 16, "1707725485503017", 293},
  {4.1600981371290250042995024e+60, 18, "4160098137129025", 61},
  {4.2228776224541920648861593e-07, 18, "422287762245419206", -6},
  {7.8721473927435042574546894e+129, 13, "7872147392744", 130},
  {1.4558064261695557650802762e+194, 4, "1456", 195},
  {4.3771424090870775463041668e+173, 1, "4", 174},
  {1.2519058542058373983051147e+221, 7, "1251906", 222},
  {1.4873871577670500362330797e+149, 1, "1", 150},
  {6.3889523319290419370829647e-214, 18, "638895233192904194", -213},
  {1.3685423192974700163143520e-201, 16, "136854231929747", -200},
  {3.9525067953442742708306200e+260, 5, "39525", 261},
  {1.9436486417274458115799405e-78, 11, "19436486417", -77},
  {1.9676825070115558459949191e+38, 18, "196768250701155585", 39},
  {6.7966921885469056705358276e+301, 15, "679669218854691", 302},
  {7.0783171816826077908592011e-125, 6, "707832", -124},
  {4.0472348324370004686729485e+129, 3, "405", 130},
  {7.0606276642943069736854657e-162, 18, "706062766429430697", -161},
  {3.5448350668269281258130713e+40, 21, "354483506682692812581", 41},
  {2.1660435048970705498941964e+72, 10, "2166043505", 73},
  {3.4582043452200446742729295e-272, 20, "34582043452200446743", -271},
  {1.0446019961100881068470425e-115, 4, "1045", -114},
  {2.6107685027470175871637448e+272, 2, "26", 273},
  {8.8670335852978208978107384e-210, 17, "88670335852978209", -209},
  {1.5145472898756587143370413e-253, 11, "15145472899", -252},
  {8.3249754357673195188017450e+272, 9, "832497544", 273},
  {6.2517692835499197670054460e-303, 4, "6252", -302},
  {8.1335413629390056113055889e+126, 14, "8133541362939", 127},
  {2.7822849292198027145367685e-269, 14, "27822849292198", -268},
  {4.1882527122081243906596126e+241, 8, "41882527", 242},
  {1.0815730931734647220831030e-83, 1, "1", -82},
  {1.3117254447342472356359551e+201, 6, "131173", 202},
  {1.9894371259992797096426063e+141, 18, "198943712599927971", 142},
  {2.0937762173907707767618861e+128, 13, "2093776217391", 129},
  {3.9433882037679002132669820e-19, 15, "39433882037679", -18},
  {5.6709106644257145955963525e+52, 12, "567091066443", 53},
  {1.9295192265185873648218292e-182, 5, "19295", -181},
  {9.2218330952508173482050257e-249, 13, "9221833095251", -248},
  {1.5389434242857632682155150e-272, 7, "1538943", -271},
  {1.9078613274201069389886934e-57, 8, "19078613", -56},
  {1.2529443877277197662159421e-53, 4, "1253", -52},
  {1.0827465964333972981322936e-111, 12, "108274659643", -110},
  {2.9861896532905243891436007e+291, 4, "2986", 292},
  {6.8654224514151641749396292e+158, 21, "686542245141516417494", 159},
  {3.5766699936832173045131104e+215, 21, "357666999368321730451", 216},
  {2.5800804341188586378331428e+181, 5, "25801", 182},
  {2.2788020836604041072667589e+270, 20, "22788020836604041073", 271},
  {1.0073221141654981444356910e+286, 1, "1", 287},
  {2.1111876571249827124234638e-284, 16, "2111187657124983", -283},
  {7.8620043934967170680854229e-159, 8, "78620044", -158},
  {1.5644755475839155697068738e-281, 20, "15644755475839155697", -280},
  {3.7600633999036050891024967e+135, 14, "37600633999036", 136},
  {5.1053176755803906524186399e-124, 21, "510531767558039065242", -123},
  {3.5252960198181257216000000e+21, 15, "352529601981813", 22},
  {1.4983645766809665961858860e-224, 12, "149836457668", -223},
  {1.5967070717136550771120145e-50, 12, "159670707171", -49},
  {2.0889526561808020888648253e-100, 15, "20889526561808", -99},
  {1.0297860796979077329703173e+140, 8, "10297861", 141},
  {2.7183763869703172783218409e+252, 1, "3", 253},
  {2.0163936025560250036746745e+233, 9, "20163936", 234},
  {8.9237079484168869908418698e-300, 19, "8923707948416886991", -299},
  {2.0339845086711739360291746e-157, 6, "203398", -156},
  {5.3568259164273801520295137e-01, 14, "53568259164274", 0},
  {6.2718454493031773782622783e-288, 15, "627184544930318", -287},
  {1.4757719500851347859463663e+76, 2, "15", 77},
  {8.8287602829275962579312209e+74, 8, "88287603", 75},
  {4.0250657998498279623412457e-60, 20, "40250657998498279623", -59},
  {1.2559064631351665098119249e-31, 18, "125590646313516651", -30},
  {8.2535923799063014603128465e+133, 3, "825", 134},
  {1.2029086468547190000000000e+16, 14, "12029086468547", 17},
  {5.6644822303881205084914729e-05, 19, "5664482230388120508", -4},
  {7.2538920827506218524821837e-09, 10, "7253892083", -8},
  {1.8791066941368482921829935e+155, 14, "18791066941368", 156},
  {3.1846318054901877338108931e-281, 17, "31846318054901877", -280},
  {3.5390775716470821098606484e-295, 9, "353907757", -294},
  {4.7729570030402491740360026e-195, 18, "477295700304024917", -194},
  {3.8218137608460109328230354e+138, 5, "38218", 139},
  {6.0604326706572075539477988e-89, 8, "60604327", -88},
  {5.0908562245640804469908529e-172, 9, "509085622", -171},
  {1.0050237299835911365824084e-115, 9, "100502373", -114},
  {9.7286660354788983561776287e+123, 15, "97286660354789", 124},
  {3.2633113093966739076433565e-242, 16, "3263311309396674", -241},
  {6.6053436872682165810587731e+62, 3, "661", 63},
  {4.0171416517977781838496000e+177, 16, "4017141651797778", 178},
  {1.2546274633301333341254994e+292, 5, "12546", 293},
  {1.1101277256708986477130169e-04, 21, "111012772567089864771", -3},
  {4.0768364226169421855701711e+155, 11, "40768364226", 156},
  {5.2627028178244058301940871e-94, 5, "52627", -93},
  {1.2961793139825384707220005e+247, 10, "1296179314", 248},
  {2.2308576586814897348170782e+229, 4, "2231", 230},
  {9.8855654989523597874167808e+27, 16, "988556549895236", 28},
  {4.6076306143358683816248806e+134, 2, "46", 135},
  {2.6554681465491378481978905e-217, 18, "265546814654913785", -216},
  {4.5229877694366917587084938e+135, 4, "4523", 136},
  {4.3251704537463545975744476e-163, 2, "43", -162},
  {9.2837037063277384715519872e+298, 11, "92837037063", 299},
  {4.0863008403324444213184578e+219, 1, "4", 220},
  {2.6719900990247749948116484e+150, 21, "267199009902477499481", 151},
  {8.5204076150957888524077375e-143, 11, "85204076151", -142},
  {1.0255791545014908114855495e-34, 7, "1025579", -33},
  {2.6983067340154715321099750e-32, 12, "269830673402", -31},
  {1.4582456761042395558826118e+46, 7, "1458246", 47},
  {1.0921672368697092834855479e+248, 4, "1092", 249},
  {1.0167790040696224000000000e+17, 15, "101677900406962", 18},
  {2.7419288750044141550122803e+202, 16, "2741928875004414", 203},
  {2.2629086372257118307790026e-83, 21, "226290863722571183078", -82},
  {4.0488248177508566886496422e+118, 7, "4048825", 119},
  {7.4628545321862302777243239e+61, 19, "7462854532186230278", 62},
  {1.4219981944243846132098802e+67, 17, "14219981944243846", 68},
  {1.0616641488716182720963843e+04, 9, "106166415", 5},
  {6.3500088877274810991092807e+174, 5, "635", 175},
  {6.1898280478404982202157130e+305, 19, "618982804784049822", 306},
  {2.4329480130837438585177489e+250, 11, "24329480131", 251},
  {5.1022805245698031103040440e+129, 7, "5102281", 130},
  {1.8832696211440550638074520e-187, 19, "1883269621144055064", -186},
  {1.8911051992292012697523759e-275, 6, "189111", -274},
  {2.1617254596636047789136911e+66, 12, "216172545966", 67},
  {1.3959135949443319958402282e+278, 21, "139591359494433199584", 279},
  {1.8539362313104890756038245e-265, 9, "185393623", -264},
  {1.7677447810344598181872330e-36, 12, "176774478103", -35},
  {1.9546929814637069120942288e-94, 10, "1954692981", -93},
  {7.3949383086380829751477773e+274, 9, "739493831", 275},
  {8.3623120376258639615847570e-293, 16, "8362312037625864", -292},
  {2.7210590651980769089851626e+253, 5, "27211", 254},
  {1.0336053559627452818010172e+173, 1, "1", 174},
  {4.9878075537392839703806137e-189, 4, "4988", -188},
  {8.7725737494067186557656015e-232, 10, "8772573749", -231},
  {5.3561425845374900898127228e+243, 4, "5356", 244},
  {1.3350998885107760325834107e-229, 9, "133509989", -228},
  {1.6374389229410369325235262e-195, 4, "1637", -194},
  {2.8566417308842815235558898e-03, 16, "2856641730884282", -2},
  {2.2957805850474874008252583e+148, 16, "2295780585047487", 149},
  {1.6505329635761543889825677e+59, 3, "165", 60},
  {1.1712033199711712969965097e-251, 16, "1171203319971171", -250},
  {1.5824761181115241622727292e+122, 6, "158248", 123},
  {3.9454100999260340038481584e-220, 14, "3945410099926", -219},
  {6.2866219105461061042106966e+60, 12, "628662191055", 61},
  {4.0745989515166736805917185e+272, 12, "407459895152", 273},
  {6.9845308606086581805222264e-51, 21, "698453086060865818052", -50},
  {4.4663004624584307894110680e+06, 17, "44663004624584308", 7},
  {5.9330317816668236525551907e-242, 12, "593303178167", -241},
  {1.1516623653982837495824384e+26, 21, "115166236539828374958", 27},
  {7.4081994681334641039408383e-260, 11, "74081994681", -259},
  {8.1773382538442879511403987e-143, 16, "8177338253844288", -142},
  {1.9601182108671202726502782e+304, 13, "1960118210867", 305},
  {2.3382775578270843955579086e+154, 11, "23382775578", 155},
  {6.1653292019897725060831440e-241, 6, "616533", -240},
  {1.9177999429481730428954360e+155, 3, "192", 156},
  {7.4791015669605521509908216e+252, 10, "7479101567", 253},
  {8.7959890581182634477092751e+142, 15, "879598905811826", 143},
  {8.6647329230386161618906678e-174, 11, "8664732923", -173},
  {4.1725205160391506798120639e+52, 8, "41725205", 53},
  {2.4807428561903105425229171e-296, 11, "24807428562", -295},
  {8.0539778768512798977612115e-179, 5, "8054", -178},
  {3.1711763663089003732570388e-96, 6, "317118", -95},
  {5.1450230013117464070193964e+132, 2, "51", 133},
  {1.3788387335573274248636827e-255, 6, "137884", -254},
  {1.5651265086577800696025863e+95, 4, "1565", 96},
  {1.3666893614877506978406366e-132, 21, "136668936148775069784", -131},
  {3.0427210935613052112365442e+246, 19, "3042721093561305211", 247},
  {9.1233461795058373110653143e+65, 18, "912334617950583731", 66},
  {4.3735739736953243721553216e-122, 3, "437", -121},
  {8.3612896198249927842499196e+282, 11, "83612896198", 283},
  {3.3696159526158385207547136e-45, 1, "3", -44},
  {5.6967552046158278130748620e-247, 5, "56968", -246},
  {8.7871327474915476321945196e+90, 5, "87871", 91},
  {6.0502346886620937029932180e+176, 15, "605023468866209", 177},
  {9.6231166439479098755422863e-270, 8, "96231166", -269},
  {4.1134798095011274391349806e+86, 21, "411347980950112743913", 87},
  {1.1494128034153554101306770e+289, 16, "1149412803415355", 290},
  {2.8557656615625111631372112e+250, 21, "285576566156251116314", 251},
  {1.7399468711006964330929165e-19, 4, "174", -18},
  {1.0346276844102563246157708e-201, 6, "103463", -200},
  {5.8236662146463895313657893e-254, 17, "58236662146463895", -253},
  {7.5477387620919098257855574e+58, 2, "75", 59},
  {1.4537854310816505058265324e-84, 20, "14537854310816505058", -83},
  {6.0480732176322617154070883e-300, 21, "604807321763226171541", -299},
  {4.2677946498371713972669291e-130, 2, "43", -129},
  {7.3886538528561060416091898e-295, 3, "739", -294},
  {1.3616167347158805275248759e+115, 16, "1361616734715881", 116},
  {6.5458314124977006615737233e-199, 19, "6545831412497700662", -198},
  {5.4218743564770929319235910e+268, 10, "5421874356", 269},
  {5.3681746241380388584567452e+150, 20, "53681746241380388585", 151},
  {3.8013737128936715126037598e+09, 14, "38013737128937", 10},
  {4.2769101778812410956662342e-42, 18, "42769101778812411", -41},
  {7.6425498748102252700579113e-160, 3, "764", -159},
  {6.5278380202308661401322955e-158, 16, "6527838020230866", -157},
  {1.4241946993117471247561533e+278, 11, "14241946993", 279},
  {1.4785703151610869051230269e+227, 8, "14785703", 228},
  {7.0834837674579554608701072e+243, 1, "7", 244},
  {2.4600467399317083236961793e-291, 2, "25", -290},
  {1.0742880665034958524824707e-183, 17, "10742880665034959", -182},
  {5.6083877045057424626272973e-136, 3, "561", -135},
  {7.6890425904081216000000000e+16, 7, "7689043", 17},
  {1.1696884062029963415755745e+305, 3, "117", 306},
  {9.5325068878087651683017612e+04, 19, "9532506887808765168", 5},
  {2.7475022919897336485157165e-235, 21, "274750229198973364852", -234},
  {1.2268514647629734406275538e-142, 10, "1226851465", -141},
  {6.1529363091028099254313060e+262, 11, "61529363091", 263},
  {2.3679130801228387001726065e-294, 14, "23679130801228", -293},
  {8.7752005733332026679817315e+35, 11, "87752005733", 36},
  {1.9073367386676138264504566e+27, 9, "190733674", 28},
  {8.9419683948720635270902115e+108, 19, "8941968394872063527", 109},
  {1.9740372688678256482966208e+50, 14, "19740372688678", 51},
  {6.0047174068915309443987392e+218, 9, "600471741", 219},
  {1.0922924619288315384186811e+32, 7, "1092292", 33},
  {7.1976091938532056092700385e-244, 17, "71976091938532056", -243},
  {2.3856378741798992185562893e-95, 1, "2", -94},
  {2.8755928287763756857035530e-290, 17, "28755928287763757", -289},
  {2.3449263277906147403377916e-280, 12, "234492632779", -279},
  {1.6502998912190831260938590e+151, 11, "16502998912", 152},
  {3.5509693208327930509813760e+150, 7, "3550969", 151},
  {3.1087072302019846230769483e+48, 1, "3", 49},
  {4.3017220150038383372226046e-29, 8, "4301722", -28},
  {1.6172787418953344298471031e-231, 12, "16172787419", -230},
  {3.1526980504403598606586456e+07, 4, "3153", 8},
  {3.6655319815254290477684970e+225, 10, "3665531982", 226},
  {2.3101420232737318517591920e-166, 4, "231", -165},
  {6.6595856875381003419813503e-208, 12, "665958568754", -207},
  {1.6586522181786430509166965e-59, 8, "16586522", -58},
  {7.4894688247937991057116078e+252, 1, "7", 253},
  {1.2736044684871198259941418e-38, 16, "127360446848712", -37},
  {2.0709996918109965308872720e-191, 14, "2070999691811", -190},
  {1.9796013086189196174156412e+72, 7, "1979601", 73},
  {8.1890594637568819397911242e+243, 9, "818905946", 244},
  {4.9958348607420402443618926e-273, 10, "4995834861", -272},
  {1.0709931206029995149308130e+220, 12, "10709931206", 221},
  {4.0855715391638174525704912e-21, 13, "4085571539164", -20},
  {1.6848818906436047834817750e-186, 1, "2", -185},
  {7.0417205784220387342685942e-208, 20, "70417205784220387343", -207},
  {1.0741635563363810441108580e-64, 15, "107416355633638", -63},
  {1.5411917817408024933316201e-263, 1, "2", -262},
  {3.8990132907864999439766967e-07, 21, "389901329078649994398", -6},
  {2.5369898342932842627819594e+244, 18, "253698983429328426", 245},
  {2.8193458892768982497079227e+156, 1, "3", 157},
  {4.9876458425528800551346231e+92, 15, "498764584255288", 93},
  {6.6942506618959910414428759e+179, 19, "6694250661895991041", 180},
  {2.6754642395906289871660930e+220, 5, "26755", 221},
  {7.2328170400940365080488892e-170, 15, "723281704009404", -169},
  {3.6541845177351625365842564e-243, 18, "365418451773516254", -242},
  {3.8451110878962284308597211e+199, 21, "384511108789622843086", 200},
  {4.9792437630186349786146501e+204, 19, "4979243763018634979", 205},
  {2.0675240912179333246072124e+121, 12, "206752409122", 122},
  {2.7322635321464939971581681e-199, 17, "2732263532146494", -198},
  {1.5339769125004808520277612e+146, 9, "153397691", 147},
  {3.1349520852372375363073958e-238, 7, "3134952", -237},
  {1.5978843209083483113628763e+182, 13, "1597884320908", 183},
  {2.0192333898061134820238375e-70, 4, "2019", -69},
  {1.6697140072734790938744083e+123, 15, "166971400727348", 124},
  {3.0989315868271605079872757e-91, 14, "30989315868272", -90},
  {2.5187068022887843510183709e-287, 17, "25187068022887844", -286},
  {7.6415439647690242479359944e+268, 18, "764154396476902425", 269},
  {2.2603554005570908671719211e+42, 20, "22603554005570908672", 43},
  {2.9035875826950520277023315e+06, 4, "2904", 7},
  {9.4572308152570375652802054e+174, 15, "945723081525704", 175},
  {1.6143605362181496246904570e+190, 13, "1614360536218", 191},
  {1.7327465671079117060094339e-262, 16, "1732746567107912", -261},
  {1.8852847023125100658547459e+179, 4, "1885", 180},
  {7.3926230693513610423506247e-187, 19, "7392623069351361042", -186},
  {7.1914806318332397488448943e+29, 17, "71914806318332397", 30},
  {2.7603360372013507749005013e+68, 5, "27603", 69},
  {1.1728247884420076289059878e+291, 2, "12", 292},
  {8.8367035995302190866487893e-147, 4, "8837", -146},
  {2.4770861628651209174750373e+166, 8, "24770862", 167},
  {1.6081213405705394046285884e-229, 10, "1608121341", -228},
  {5.6277750183207464194924660e-60, 11, "56277750183", -59},
  {1.2079510814658623706898006e+178, 6, "120795", 179},
  {6.0837616624324175313710781e+128, 10, "6083761662", 129},
  {2.4956562724589601318723311e-54, 18, "249565627245896013", -53},
  {2.0493891628352762855427978e-278, 14, "20493891628353", -277},
  {8.5096348907019275735499014e+28, 3, "851", 29},
  {8.3576988403705849583652508e+278, 6, "83577", 279},
  {6.3385341285709758730891313e-24, 20, "63385341285709758731", -23},
  {1.4935789767204011189380911e-141, 20, "14935789767204011189", -140},
  {1.7871334025291645319916783e-155, 5, "17871", -154},
  {1.7817647840638613578505226e-105, 7, "1781765", -104},
  {1.5206112834101458531091784e-151, 5, "15206", -150},
  {1.3079257692920588316720838e-192, 20, "13079257692920588317", -191},
  {1.1901821125592143731278828e-30, 16, "1190182112559214", -29},
  {4.8208256280307417589923798e-202, 16, "4820825628030742", -201},
  {5.5139140618438254261058036e-179, 12, "551391406184", -178},
  {7.9285962972408928232382905e-110, 3, "793", -109},
  {5.8081484459014428114340693e-208, 20, "58081484459014428114", -207},
  {3.8505457830216507336527228e-16, 5, "38505", -15},
  {1.0924296440766142349736237e+53, 5, "10924", 54},
  {7.3404849434752930332810754e-215, 11, "73404849435", -214},
  {5.9055656675477904699516875e+159, 7, "5905566", 160},
  {4.0573745528654040020261792e-239, 2, "41", -238},
  {1.7309083786826403628240253e-294, 2, "17", -293},
  {1.1528291302725236640325051e-241, 13, "1152829130273", -240},
  {1.1663333152830269336700439e+09, 14, "1166333315283", 10},
  {3.5623436721939650522957736e+270, 15, "356234367219397", 271},
  {2.7365698008479320542312641e+48, 1, "3", 49},
  {1.7436283912495517101315527e+72, 4, "1744", 73},
  {8.6801069784464180803802471e-251, 20, "86801069784464180804", -250},
  {1.9059402667630654165790838e+282, 14, "19059402667631", 283},
  {7.9026221263070022607846892e-25, 17, "79026221263070023", -24},
  {1.7086588704198008721788204e+134, 13, "170865887042", 135},
  {1.4530873597998644693774807e-296, 18, "145308735979986447", -295},
  {8.1985227142167172294528249e-192, 5, "81985", -191},
  {3.2236213761684988498325914e+247, 15, "32236213761685", 248},
  {1.1114109806557896535894160e+115, 12, "111141098066", 116},
  {1.9704544896841755553062653e+276, 8, "19704545", 277},
  {2.4047607143613052250393380e-93, 20, "2404760714361305225", -92},
  {2.6745372540014765144319203e-24, 11, "2674537254", -23},
  {8.0060375964309383976989093e+251, 15, "800603759643094", 252},
  {4.8902072740220422989524085e-89, 3, "489", -88},
  {2.4931749904357031368997873e+88, 16, "2493174990435703", 89},
  {1.6148244323675760688175212e+218, 7, "1614824", 219},
  {7.9066569169855420647614294e-125, 10, "7906656917", -124},
  {8.0860592888680851611259564e+70, 5, "80861", 71},
  {5.0844184429622816291734400e-24, 9, "508441844", -23},
  {1.7678515556710450706696316e+286, 11, "17678515557", 287},
  {6.0461509845175056966833298e+67, 13, "6046150984518", 68},
  {7.3820534492903244342913947e-210, 6, "738205", -209},
  {4.8269295027326227927643700e-20, 13, "4826929502733", -19},
  {8.9339461194943195112840685e+120, 10, "8933946119", 121},
  {1.4272111457618705348190378e-187, 17, "14272111457618705", -186},
  {2.0032280300359523253991097e-205, 6, "200323", -204},
  {1.1932587665221106152212660e+267, 21, "119325876652211061522", 268},
  {2.5472910195421899229121195e-66, 2, "25", -65},
  {7.6878547643258350421927574e+241, 4, "7688", 242},
  {2.1919956575973225552307298e-111, 1, "2", -110},
  {7.1114613139908962836771977e-175, 7, "7111461", -174},
  {8.2491694266733540365690062e+275, 16, "8249169426673354", 276},
  {4.5428708211958636720632425e-232, 12, "45428708212", -231},
  {5.8394292119841904113088056e+51, 10, "5839429212", 52},
  {5.1990154269096718432911287e+115, 12, "519901542691", 116},
  {4.4415646912923201258395582e+173, 11, "44415646913", 174},
  {3.7044295972432839843467412e-60, 18, "370442959724328398", -59},
  {3.8385173587700536403224475e+122, 15, "383851735877005", 123},
  {3.4543911802278961911122016e-16, 10, "345439118", -15},
  {1.3490863869592968614086108e-193, 11, "1349086387", -192},
  {8.0328439423696404237923013e-212, 13, "803284394237", -211},
  {5.0368599740351443242420649e+287, 6, "503686", 288},
  {2.4667859454505322473308294e-43, 13, "2466785945451", -42},
  {2.4918037737088171809064757e-154, 13, "2491803773709", -153},
  {2.6865569534027484375000000e+14, 11, "26865569534", 15},
  {1.0681686219226233849996094e-242, 4, "1068", -241},
  {9.9879254374884224516092240e-06, 3, "999", -5},
  {5.4498247277138678811196456e+46, 3, "545", 47},
  {4.1930717893628333338141786e+80, 7, "4193072", 81},
  {6.7897306049225570340980565e+264, 1, "7", 265},
  {1.3070870822730167534578985e+168, 17, "13070870822730168", 169},
  {8.4766237022861747891784946e-187, 10, "8476623702", -186},
  {6.6651739388192893128121806e+75, 11, "66651739388", 76},
  {2.7522636904683505840868794e-306, 4, "2752", -305},
  {9.6851356615022763402553136e+93, 17, "96851356615022763", 94},
  {1.9639894672839669022895758e-51, 5, "1964", -50},
  {1.6865271217417360761543442e+263, 9, "168652712", 264},
  {1.9076718924976697460606562e-82, 9, "190767189", -81},
  {1.4372830319192943418141316e-304, 1, "1", -303},
  {6.8018605378526064329802964e-74, 15, "680186053785261", -73},
  {1.4280956169878612647086771e+126, 3, "143", 127},
  {1.6281916870477493197921081e+212, 20, "16281916870477493198", 213},
  {9.6738925428585824068329415e+228, 2, "97", 229},
  {1.1820145389259889679845242e+179, 12, "118201453893", 180},
  {1.3807368881455477183220264e-241, 13, "1380736888146", -240},
  {4.0840276938364751375902572e+244, 18, "408402769383647514", 245},
  {5.5890762601557928406042171e-198, 3, "559", -197},
  {1.3685366816753826914287016e-282, 18, "136853668167538269", -281},
  {1.6596887191049270961720193e-261, 13, "1659688719105", -260},
  {8.2625431370490518484269075e+71, 20, "82625431370490518484", 72},
  {1.3443677037845125765653493e+259, 10, "1344367704", 260},
  {4.0754631859074465033222713e-198, 21, "407546318590744650332", -197},
  {2.8501680040003457458408972e+33, 8, "2850168", 34},
  {1.8231301588999119635032928e-187, 17, "1823130158899912", -186},
  {4.7291341836692919531538086e-07, 2, "47", -6},
  {5.8111951876470835837615731e+163, 3, "581", 164},
  {6.4878928414492049569810621e+181, 11, "64878928414", 182},
  {1.9262128712436518523271486e+29, 20, "19262128712436518523", 30},
  {2.4995612547816672128237548e-234, 7, "2499561", -233},
  {7.7242892717190630270624553e+193, 10, "7724289272", 194},
  {3.4308292589014919484820098e+89, 9, "343082926", 90},
  {1.5664267853935560794497336e+175, 15, "156642678539356", 176},
  {3.8874268380734233096715332e-75, 21, "388742683807342330967", -74},
  {9.6509410903960617878409802e-95, 4, "9651", -94},
  {1.2685051808773289679382155e-70, 14, "12685051808773", -69},
  {3.6800473172259432305671246e+38, 3, "368", 39},
  {2.8966155438970542328338486e-119, 21, "289661554389705423283", -118},
  {1.8059603599442209041270282e-170, 20, "18059603599442209041", -169},
  {8.5978870164513994938974526e-270, 8, "8597887", -269},
  {6.5662301476866191049218894e+88, 8, "65662301", 89},
  {1.5414627532986940448358622e+84, 4, "1541", 85},
  {1.2481662278476160367512851e+284, 5, "12482", 285},
  {3.6411969894613920298006073e+244, 7, "3641197", 245},
  {3.2524568784521161159360123e-276, 13, "3252456878452", -275},
  {3.7740526050562794950417482e+88, 8, "37740526", 89},
  {6.6560133142189454370002866e-211, 15, "665601331421895", -210},
  {2.5529866699283675835410000e+186, 10, "255298667", 187},
  {3.0172364587892483535239394e-64, 18, "301723645878924835", -63},
  {1.5404701355944813397692111e+70, 18, "154047013559448134", 71},
  {6.6630720529076708061221158e+135, 14, "66630720529077", 136},
  {7.7950259516221694109615985e+171, 5, "7795", 172},
  {9.3553432540304620134198630e+87, 20, "93553432540304620134", 88},
  {1.7343902293886084159470231e-25, 7, "173439", -24},
  {1.2477929945534094743617405e+220, 20, "12477929945534094744", 221},
  {1.1207889918146138025165610e-230, 16, "1120788991814614", -229},
  {1.2067954834705038589385710e-138, 11, "12067954835", -137},
  {1.0941352228749445906366194e+114, 13, "1094135222875", 115},
  {5.3610913875183587179006641e+90, 13, "5361091387518", 91},
  {2.2496479067179151956419169e+232, 16, "2249647906717915", 233},
  {6.8045155790311975269773542e+80, 3, "68", 81},
  {1.5834224836774828146573055e+308, 19, "1583422483677482815", 309},
  {1.5802106093243087290968756e+152, 1, "2", 153},
  {2.1109699457352222142637379e+170, 16, "2110969945735222", 171},
  {1.9782831117237489433590173e-48, 16, "1978283111723749", -47},
  {1.2448790263145728110529110e+247, 3, "124", 248},
  {5.4336863320383202916913806e-71, 2, "54", -70},
  {1.2172050665634798318089025e+251, 19, "1217205066563479832", 252},
  {2.6987967724171039477525051e+140, 9, "269879677", 141},
  {2.0162708746800509544587258e-110, 16, "2016270874680051", -109},
  {4.8456206569313976835291582e+245, 15, "48456206569314", 246},
  {2.2181260026939252176680873e+156, 18, "221812600269392522", 157},
  {6.2489720103261428714793981e+296, 2, "62", 297},
  {1.3517674162387402084788838e+87, 20, "13517674162387402085", 88},
  {4.3284101217797925248700423e-79, 8, "43284101", -78},
  {4.2343170409087671045132955e-53, 8, "4234317", -52},
  {1.4741247581840129197153646e+81, 5, "14741", 82},
  {3.8126817820550421251796914e+87, 16, "3812681782055042", 88},
  {1.7246206257225578681412875e-166, 15, "172462062572256", -165},
  {1.4645627119843983183448695e+216, 4, "1465", 217},
  {3.4352634082347895311213287e-103, 7, "3435263", -102},
  {2.4812395728928475528331276e-299, 19, "2481239572892847553", -298},
  {4.7177524288520360584093689e-178, 10, "4717752429", -177},
  {2.5905252763497237613516304e+95, 11, "25905252763", 96},
  {1.1157048505285408794989304e-228, 9, "111570485", -227},
  {4.8363257131735755003185158e+133, 9, "483632571", 134},
  {4.4061176902591405286695242e-61, 21, "440611769025914052867", -60},
  {8.1045329477274314055944909e+292, 4, "8105", 293},
  {3.8984752451301036169227097e-14, 9, "389847525", -13},
  {1.5093634611269764477293980e+282, 20, "15093634611269764477", 283},
  {8.3493615523613095515745868e-26, 4, "8349", -25},
  {2.3091522862208038544972782e-144, 2, "23", -143},
  {1.3329805836720029829486543e-77, 1, "1", -76},
  {6.2672111406177037209973912e-191, 9, "626721114", -190},
  {8.0388343262179247196379448e+233, 2, "8", 234},
  {3.0260593567703900700318467e-112, 20, "302605935677039007", -111},
  {6.2904157334435702221262326e-251, 8, "62904157", -250},
  {9.7457691537058456336379760e+235, 14, "97457691537058", 236},
  {2.8052526945219901904823645e-44, 10, "2805252695", -43},
  {4.2217121843298466206175924e+178, 4, "4222", 179},
  {2.7331446990287760945438711e-85, 7, "2733145", -84},
  {5.3432933716102057256933700e+209, 2, "53", 210},
  {4.1546992928517071570048494e-286, 21, "4154699292851707157", -285},
  {2.2356776353365135300767150e+222, 3, "224", 223},
  {4.5273018783910208395751299e-14, 1, "5", -13},
  {7.3201531890025662139562788e+221, 19, "7320153189002566214", 222},
  {6.5493595216283179165366623e-119, 2, "65", -118},
  {1.2413681824753016179571295e-36, 18, "124136818247530162", -35},
  {1.8328067890274270849791167e-184, 11, "1832806789", -183},
  {9.1308414418571968694487727e+113, 10, "9130841442", 114},
  {1.7368020701788354858061413e-88, 15, "173680207017884", -87},
  {2.1241029986661654583829747e-129, 18, "212410299866616546", -128},
  {2.1568610582991921303686333e-154, 13, "2156861058299", -153},
  {2.4722286532788612192148975e+210, 3, "247", 211},
  {4.2288547161535293005091053e-224, 4, "4229", -223},
  {1.2902277690730662400000000e+18, 20, "129022776907306624", 19},
  {1.0170856313118684141161126e-100, 14, "10170856313119", -99},
  {4.0990883183723504925397103e-292, 18, "409908831837235049", -291},
  {1.5154223311650835918833893e-232, 20, "15154223311650835919", -231},
  {1.6097044488206989858325693e-20, 3, "161", -19},
  {3.7849672870593017941789972e-184, 4, "3785", -183},
  {1.8039234462815538380800000e+20, 2, "18", 21},
  {1.8819615634201986135501525e+79, 11, "18819615634", 80},
  {2.2367628107507413293951462e-163, 15, "223676281075074", -162},
  {7.6978149842850592533771237e+48, 19, "7697814984285059253", 49},
  {7.1996938211192532973977746e+162, 11, "71996938211", 163},
  {7.9585164397274928000000000e+16, 15, "795851643972749", 17},
  {2.0217526074324535369873047e+10, 9, "202175261", 11},
  {3.5734546514299586276169500e-302, 14, "357345465143", -301},
  {8.7388293638316191300990541e+70, 17, "87388293638316191", 71},
  {1.8922866559659660786667800e+89, 2, "19", 90},
  {2.0129800561138565625030657e-124, 18, "201298005611385656", -123},
  {9.8939594067875834280245347e-99, 10, "9893959407", -98},
  {1.3482013895051448932941217e-218, 9, "134820139", -217},
  {2.2537496889413214100225643e-281, 13, "2253749688941", -280},
  {7.9414428371316031497565194e-142, 4, "7941", -141},
  {4.5627348466206026671390501e-101, 19, "4562734846620602667", -100},
  {2.7017126369683979229667293e+225, 12, "270171263697", 226},
  {2.5272453841014608555564765e+30, 17, "25272453841014609", 31},
  {6.8111744418495240212628031e+50, 13, "681117444185", 51},
  {2.4674591062067521052979117e+219, 5, "24675", 220},
  {8.1078132837003114019580607e-01, 18, "81078132837003114", 0},
  {4.8730388902705632546667832e+120, 19, "4873038890270563255", 121},
  {1.1067874310245576315522887e-269, 4, "1107", -268},
  {7.6797120535835162436974154e-212, 8, "76797121", -211},
  {9.1907719811770757863932649e-99, 1, "9", -98},
  {5.5739252124712865124833337e-167, 14, "55739252124713", -166},
  {3.7814054535814015473222734e-52, 6, "378141", -51},
  {9.3446920206232048660567933e-182, 11, "93446920206", -181},
  {4.3346359458522065324359573e+03, 7, "4334636", 4},
  {1.0896494685950383918064334e+73, 15, "108964946859504", 74},
  {1.5610351247900352473034029e-281, 19, "1561035124790035247", -280},
  {9.6621225536182461078402349e+40, 6, "966212", 41},
  {3.0741785770285030605507681e+160, 21, "307417857702850306055", 161},
  {4.1958720492411239353258135e+29, 1, "4", 30},
  {5.9269385060947678540033610e-123, 7, "5926939", -122},
  {1.5026338022700061478190706e+94, 8, "15026338", 95},
  {2.3475894454463491253737787e-121, 18, "234758944544634913", -120},
  {2.5189921794816508433834317e-256, 15, "251899217948165", -255},
  {7.3099173386784333046314927e-22, 10, "7309917339", -21},
  {1.0873050056524291276499651e-190, 1, "1", -189},
  {1.1967070487584813196809846e-176, 8, "1196707", -175},
  {1.4502147390634871627880333e+29, 5, "14502", 30},
  {3.4827160680458881860903362e-128, 19, "3482716068045888186", -127},
  {1.9390169587109601307397142e-299, 4, "1939", -298},
  {4.1714768780964938360457349e+210, 9, "417147688", 211},
  {1.5161043083065595172652048e-99, 19, "1516104308306559517", -98},
  {7.6699451645308596810937261e-122, 17, "76699451645308597", -121},
  {2.3960728728337838861173356e+44, 12, "239607287283", 45},
  {5.2656459491641250413303227e+127, 8, "52656459", 128},
  {1.6220766739283221478301001e+265, 17, "16220766739283221", 266},
  {2.5813153931863174056136043e-135, 2, "26", -134},
  {8.3619002219219170784419531e-242, 20, "83619002219219170784", -241},
  {1.0630387202310855356721315e+237, 20, "10630387202310855357", 238},
  {1.4980341976775357967770425e+123, 13, "1498034197678", 124},
  {9.2531282052606763019967684e-61, 10, "9253128205", -60},
  {1.0587804876692265633485169e-237, 3, "106", -236},
  {6.0672454160399149714066880e+02, 11, "6067245416", 3},
  {1.9789722955267108482055163e-246, 16, "1978972295526711", -245},
  {4.8691706309222349300599647e+201, 20, "48691706309222349301", 202},
  {9.3317365707301222555446917e-178, 12, "933173657073", -177},
  {2.0934668737339424012954559e+138, 3, "209", 139},
  {7.9254485300681352971446281e+35, 14, "79254485300681", 36},
  {4.2030350979877418925360744e+31, 21, "420303509798774189254", 32},
  {1.7646930641107683193364366e+308, 8, "17646931", 309},
  {1.6198966746250302952332366e-258, 8, "16198967", -257},
  {5.7986028771325098426476646e-254, 11, "57986028771", -253},
  {4.9576376796959354885349325e-148, 9, "495763768", -147},
  {1.1343207384973014199109616e+44, 13, "1134320738497", 45},
  {2.7193389032972223503747955e+04, 1, "3", 5},
  {1.8421705888357429504394531e+10, 14, "18421705888357", 11},
  {2.1675536381763604044217902e-35, 18, "21675536381763604", -34},
  {6.8680616989920134897081750e+185, 18, "686806169899201349", 186},
  {3.5247251181564943703045912e+68, 3, "352", 69},
  {6.4977820642119511624161062e-285, 20, "64977820642119511624", -284},
  {6.5477997450320754207561626e-224, 6, "65478", -223},
  {6.0207009537970423697780584e+109, 19, "602070095379704237", 110},
  {9.7981516637820305265605735e-124, 8, "97981517", -123},
  {1.4669201939650242177470950e-147, 17, "14669201939650242", -146},
  {4.7404187163325905454318152e+52, 1, "5", 53},
  {3.9810895497226815933911048e-03, 9, "398108955", -2},
  {2.2625431485794538216310311e+133, 20, "22625431485794538216", 134},
  {1.1034022326282828185600000e+20, 13, "1103402232628", 21},
  {2.0111994272561409024900132e-86, 20, "20111994272561409025", -85},
  {1.6858595157562625245223510e-173, 13, "1685859515756", -172},
  {6.2074700340825918384391047e+197, 12, "620747003408", 198},
  {6.4117352881216503336290360e+270, 1, "6", 271},
  {2.3839632448857167974490404e+216, 18, "23839632448857168", 217},
  {9.8237310161899728753001183e+227, 11, "98237310162", 228},
  {3.4788401683573268897797710e+46, 21, "347884016835732688978", 47},
  {1.3528996819592197450876135e-255, 21, "135289968195921974509", -254},
  {2.4619046619757418708166077e-24, 17, "24619046619757419", -23},
  {1.2891923047283441686804064e+116, 18, "128919230472834417", 117},
  {1.2127439218108774805077177e-03, 12, "121274392181", -2},
  {4.8709797018635613842839776e-192, 20, "48709797018635613843", -191},
  {6.6064253030941465254519216e-167, 5, "66064", -166},
  {1.5352622857528298719831200e+74, 10, "1535262286", 75},
  {4.9269561800301104090529753e+176, 19, "4926956180030110409", 177},
  {6.6309364682607745549330170e-68, 15, "663093646826077", -67},
  {1.8256945657681665990374457e+29, 3, "183", 30},
  {2.8091125017707153540023313e-205, 16, "2809112501770715", -204},
  {2.8959464972757576903273050e+260, 1, "3", 261},
  {2.1663017355455240656952851e+167, 9, "216630174", 168},
  {1.4779975909411529547946941e+187, 17, "1477997590941153", 188},
  {3.7021358222047274789362207e+255, 4, "3702", 256},
  {5.8006414500319305569291372e+296, 17, "58006414500319306", 297},
  {3.4699005044576444307761138e-64, 3, "347", -63},
  {8.7845813617749735248438600e-31, 19, "8784581361774973525", -30},
  {1.2345869453620424506975956e+119, 21, "12345869453620424507", 120},
  {6.4628334611744817560237910e-242, 13, "6462833461174", -241},
  {1.0333086228526820119718414e+186, 6, "103331", 187},
  {2.5234789342645399811358821e+283, 3, "252", 284},
  {4.6282900044447851181030273e+08, 8, "462829", 9},
  {1.1547488932897303358808737e-153, 11, "11547488933", -152},
  {1.3437741839145704390868594e-180, 17, "13437741839145704", -179},
  {5.6134490880725071018350279e+231, 16, "5613449088072507", 232},
  {2.4096497609737836771653867e+300, 6, "240965", 301},
  {5.7562277447514948426169729e+284, 1, "6", 285},
  {6.3276790531364359795747270e-111, 6, "632768", -110},
  {3.2296662300449553206910452e+219, 15, "322966623004496", 220},
  {1.3297384753054996986858791e-171, 2, "13", -170},
  {8.0399230939471142875056991e-93, 3, "804", -92},
  {1.0853559757968914617141568e-45, 8, "1085356", -44},
  {1.1931660342305506777042559e+169, 14, "11931660342306", 170},
  {4.1202901387307509327739512e-215, 16, "4120290138730751", -214},
  {4.9207672613840939370123510e+241, 10, "4920767261", 242},
  {1.1745927540293734154549133e+114, 6, "117459", 115},
  {1.4867804035366336488117473e-92, 2, "15", -91},
  {2.0989521551208670243597211e+291, 10, "2098952155", 292},
  {1.0590464827869463017365995e+71, 5, "1059", 72},
  {2.4490319407248115357185061e-279, 15, "244903194072481", -278},
  {7.5527832431349033849603384e-83, 20, "7552783243134903385", -82},
  {3.7451244728598002658309950e-93, 14, "37451244728598", -92},
  {1.6758365878664849214344619e-265, 2, "17", -264},
  {4.5226651085501448491034911e-92, 21, "45226651085501448491", -91},
  {9.7569747005062405266497570e+86, 5, "9757", 87},
  {2.6233942215837767761640142e-169, 6, "262339", -168},
  {1.3247247369042515570803980e+161, 14, "13247247369043", 162},
  {5.3994493179697544912746427e+177, 16, "5399449317969754", 178},
  {1.0341881839945652245660312e+04, 13, "1034188183995", 5},
  {5.4770728605679353600000000e+17, 12, "547707286057", 18},
  {8.1648194470691848233253513e-257, 20, "81648194470691848233", -256},
  {1.5556213634939715476773151e-154, 18, "155562136349397155", -153},
  {4.0675212537942539004385242e+230, 16, "4067521253794254", 231},
  {1.3334706120428881522772832e-35, 2, "13", -34},
  {2.3797959967831268022036225e-154, 20, "23797959967831268022", -153},
  {9.7545129416266710503275891e+137, 14, "97545129416267", 138},
  {6.4809618133146707822303781e+115, 13, "6480961813315", 116},
  {4.2132220312073118915551672e+233, 20, "42132220312073118916", 234},
  {9.7431591160655263265766151e-149, 16, "9743159116065526", -148},
  {4.8384610251329019325563193e-115, 18, "483846102513290193", -114},
  {5.4012578669353034925147693e+109, 20, "54012578669353034925", 110},
  {2.8317100363743958407144542e-261, 6, "283171", -260},
  {2.7549649767275556974835140e-141, 17, "27549649767275557", -140},
  {3.8053396482046335937500000e+13, 20, "38053396482046335938", 14},
  {1.9801283307437363442390254e+225, 21, "198012833074373634424", 226},
  {4.6122543406265580254390424e-41, 11, "46122543406", -40},
  {2.9240568926085915252344182e-231, 13, "2924056892609", -230},
  {1.5419483458212298275165651e+204, 7, "1541948", 205},
  {8.3413079003966188406343668e-54, 21, "834130790039661884063", -53},
  {5.5730934936495778071506180e+62, 13, "557309349365", 63},
  {7.0504361450415907162469548e-181, 15, "705043614504159", -180},
  {3.2405594611025284138123510e-111, 5, "32406", -110},
  {6.9652919254503414730255879e+272, 4, "6965", 273},
  {7.5213806557909103544135947e-41, 4, "7521", -40},
  {8.7201237025571347250949376e+219, 12, "872012370256", 220},
  {1.3962267461754159109500485e-104, 10, "1396226746", -103},
  {5.4311891231416651111456978e-272, 3, "543", -271},
  {4.2194821486090489445993292e-242, 4, "4219", -241},
  {1.4363036936198426113937416e-148, 18, "143630369361984261", -147},
  {3.7852356590799271673935788e-146, 10, "3785235659", -145},
  {3.9070961361067103614991931e+256, 9, "390709614", 257},
  {8.4504368208569025089360593e-01, 13, "8450436820857", 0},
  {2.8383020390335232944823334e-14, 2, "28", -13},
  {2.3752664255491628324078261e+264, 7, "2375266", 265},
  {7.6222712270416265425221914e-176, 6, "762227", -175},
  {1.3169366477422329996400068e+72, 2, "13", 73},
  {3.0325477396310278615346376e-137, 18, "303254773963102786", -136},
  {2.4188827169900417510858291e-281, 5, "24189", -280},
  {1.6992298497629491742202947e+134, 7, "169923", 135},
  {2.0803913911530059873504047e+241, 9, "208039139", 242},
  {1.5745676246749795996349108e-136, 20, "15745676246749795996", -135},
  {3.7264034629660100486357869e-199, 16, "372640346296601", -198},
  {2.2064710101345527113095042e+102, 19, "2206471010134552711", 103},
  {3.5552644167965448593089906e+65, 19, "3555264416796544859", 66},
  {7.5311572510842554466494269e-107, 9, "753115725", -106},
  {1.4525084543995015000000000e+15, 13, "14525084544", 16},
  {1.9738857084969782704888130e+36, 7, "1973886", 37},
  {4.6343822220749108886718750e+11, 3, "463", 12},
  {2.1672621855757591170615531e-44, 16, "2167262185575759", -43},
  {3.3813946197760569734442979e-171, 19, "3381394619776056973", -170},
  {7.2268647681269611160574538e-141, 5, "72269", -140},
  {8.6063119092466945303844681e+263, 17, "86063119092466945", 264},
  {3.3384204876335152000000000e+16, 21, "33384204876335152", 17},
  {1.0997084716961898248586965e+214, 15, "109970847169619", 215},
  {2.3097987516152066870976558e-52, 13, "2309798751615", -51},
  {1.6863890549012220003511006e-136, 10, "1686389055", -135},
  {1.0934832401793337816866113e+63, 12, "109348324018", 64},
  {7.0178452234865635886798201e+72, 11, "70178452235", 73},
  {3.6570328624227293691231078e-254, 17, "36570328624227294", -253},
  {1.2896838683088163516301660e+246, 9, "128968387", 247},
  {3.3727054238747825126249328e-218, 11, "33727054239", -217},
  {9.7523975172607676608168283e+290, 2, "98", 291},
  {6.9310145657371848549800864e-49, 9, "693101457", -48},
  {5.2718376295305240862428461e+132, 10, "527183763", 133},
  {7.6546731561957669644238282e-175, 15, "765467315619577", -174},
  {9.2690905062434695670135759e-185, 5, "92691", -184},
  {4.2368149195838215514374136e+107, 10, "423681492", 108},
  {8.4548975981703301703412462e-187, 17, "84548975981703302", -186},
  {3.5839344754577804790592894e+298, 16, "358393447545778", 299},
  {3.9985622965804529585462754e+72, 2, "4", 73},
  {3.1607650482374907906991578e-285, 15, "316076504823749", -284},
  {1.4885841059210543221512475e+63, 15, "148858410592105", 64},
  {2.3675968717575381645693761e+73, 19, "2367596871757538165", 74},
  {4.9110356680645875945065346e+114, 16, "4911035668064588", 115},
  {2.8781835325708096151421420e+77, 17, "28781835325708096", 78},
  {6.5397607334459308078185191e+208, 20, "65397607334459308078", 209},
  {6.5575950323307829875071478e+199, 19, "6557595032330782988", 200},
  {1.4331797992539904718078958e-02, 17, "14331797992539905", -1},
  {2.9993276470437815117641327e+65, 1, "3", 66},
  {1.1588820186775392169628358e+132, 12, "115888201868", 133},
  {1.1137633675012017597334487e-268, 16, "1113763367501202", -267},
  {2.4265519438376622445496746e-92, 13, "2426551943838", -91},
  {1.3706107320573054525464586e-59, 2, "14", -58},
  {1.3587381533086704980301408e-270, 11, "13587381533", -269},
  {5.6881254902447966100135731e-38, 8, "56881255", -37},
  {1.5919809141332786767716355e-68, 15, "159198091413328", -67},
  {6.1879002384602438091918595e+146, 4, "6188", 147},
  {1.0253073536992248979138331e-02, 5, "10253", -1},
  {1.7959050414689877700114157e-69, 20, "179590504146898777", -68},
  {7.6712815335769981465268057e+90, 10, "7671281534", 91},
  {5.4510288150976583962046432e-279, 16, "5451028815097658", -278},
  {9.0897267650388890124139554e+100, 21, "908972676503888901241", 101},
  {6.3362804228915401329080789e+105, 19, "6336280422891540133", 106},
  {1.0095840962561859232247523e-64, 17, "10095840962561859", -63},
  {3.8476014998699972740452332e-121, 5, "38476", -120},
  {2.4816363561435231419755401e+122, 9, "248163636", 123},
  {1.2943659023257137190949743e-128, 8, "12943659", -127},
  {2.9241908920119186784535746e+198, 10, "2924190892", 199},
  {6.4446302679337878840137860e-35, 14, "64446302679338", -34},
  {1.4981967891165442592555232e+234, 17, "14981967891165443", 235},
  {9.3715347154148258043371091e-160, 10, "9371534715", -159},
  {5.8271244699353891325682262e+224, 5, "58271", 225},
  {4.9496579494673522833055095e+136, 11, "49496579495", 137},
  {2.0081281862034624288661011e+298, 8, "20081282", 299},
  {5.2780248376433386220245971e+225, 6, "527802", 226},
  {1.2063805120061602277135318e+205, 3, "121", 206},
  {2.6092403073127832394469775e-26, 2, "26", -25},
  {1.8104376166822128740065973e+102, 9, "181043762", 103},
  {4.6800240672380615331525704e+198, 18, "468002406723806153", 199},
  {2.5910223876402251087526717e-138, 8, "25910224", -137},
  {4.2478534732638378671729529e-165, 4, "4248", -164},
  {5.6232191940836594604372212e-127, 10, "5623219194", -126},
  {3.8015197291289217698688086e-130, 11, "38015197291", -129},
  {1.3169332981377700930664651e-107, 3, "132", -106},
  {1.1078535596144561805978908e-260, 19, "1107853559614456181", -259},
  {1.4368406573427014823907544e-301, 8, "14368407", -300},
  {3.3299037580262064173197700e-02, 8, "33299038", -1},
  {3.8114448689463146791956236e-19, 3, "381", -18},
  {3.2321464906533130313260816e+232, 9, "323214649", 233},
  {1.7986155236582988669612676e+221, 13, "1798615523658", 222},
  {1.8329725820799082008954467e-105, 11, "18329725821", -104},
  {3.2536129882162259899438810e-287, 21, "325361298821622598994", -286},
  {1.4806848802097065413248249e+59, 4, "1481", 60},
  {1.6712076798312623333555710e-280, 14, "16712076798313", -279},
  {6.1668335163222106325271041e-281, 1, "6", -280},
  {4.1073030256475316790853364e+226, 2, "41", 227},
  {7.5410116678807505428352218e-51, 11, "75410116679", -50},
  {3.3317707565614154120722667e-304, 3, "333", -303},
  {1.8665019990905700412998218e-123, 7, "1866502", -122},
  {1.1390037439704650996161207e-191, 10, "1139003744", -190},
  {6.0898542704820638302126074e-88, 13, "6089854270482", -87},
  {2.9148652144812333976752537e+113, 8, "29148652", 114},
  {6.3678316697934452054154159e-226, 16, "6367831669793445", -225},
  {6.9763204809354169509652909e-233, 11, "69763204809", -232},
  {6.9260827105604099223223749e+71, 7, "6926083", 72},
  {1.8894090056914916604635970e-163, 12, "188940900569", -162},
  {7.0911391532082927131622165e+148, 6, "709114", 149},
  {8.6535180167068930202229621e-186, 13, "8653518016707", -185},
  {1.0976796546600310566595108e-131, 13, "109767965466", -130},
  {2.7410978370028120665559691e-236, 13, "2741097837003", -235},
  {4.4044235065166908592781073e+143, 8, "44044235", 144},
  {6.1435154370451240068859721e-78, 21, "614351543704512400689", -77},
  {3.2415321138469197831025926e-277, 6, "324153", -276},
  {1.5108708059567220138783798e-297, 19, "1510870805956722014", -296},
  {2.3780618889584805477699375e-85, 6, "237806", -84},
  {8.9329598002514593195956878e+102, 8, "89329598", 103},
  {1.1979430418272845942869297e-54, 11, "11979430418", -53},
  {1.2938073489251974309380764e-176, 11, "12938073489", -175},
  {8.5829045497279163535121438e+151, 12, "858290454973", 152},
  {9.9732725620207328610032959e-43, 8, "99732726", -42},
  {5.2712800623962692634374514e+49, 13, "5271280062396", 50},
  {1.6996931049609660322431496e+227, 10, "1699693105", 228},
  {7.2490787127644827349404318e+70, 2, "72", 71},
  {1.1321780100754196349359528e+165, 20, "11321780100754196349", 166},
  {1.6315905526307313492873615e-195, 13, "1631590552631", -194},
  {6.5584406925223313785759794e-293, 21, "655844069252233137858", -292},
  {4.6938355508819587306729505e-31, 19, "4693835550881958731", -30},
  {3.0160185926195149035153033e+230, 11, "30160185926", 231},
  {2.5099668447194376017332883e+69, 1, "3", 70},
  {5.6880829586760640342453566e+206, 14, "56880829586761", 207},
  {1.1352999006229090107577247e-130, 9, "11352999", -129},
  {5.3610509614134049122910770e-194, 6, "536105", -193},
  {3.0944664588981027453655721e-66, 20, "30944664588981027454", -65},
  {4.5227423468332814213119185e-140, 14, "45227423468333", -139},
  {4.0586204888449574139734485e-40, 9, "405862049", -39},
  {7.2276784522740195149052485e+271, 18, "722767845227401951", 272},
  {2.5178940505572408858490033e-260, 18, "251789405055724089", -259},
  {2.8396835916753742218017578e+10, 11, "28396835917", 11},
  {8.3465865956652291584185096e+306, 6, "834659", 307},
  {4.2171217253157452431531854e-150, 6, "421712", -149},
  {3.1113189447876579516377477e+122, 21, "311131894478765795164", 123},
  {8.7481134641389074457061324e+216, 12, "874811346414", 217},
  {2.5636393014739308081275670e+177, 15, "256363930147393", 178},
  {2.6042235835559169439463707e+136, 20, "26042235835559169439", 137},
  {1.1566890259407028574690506e-281, 19, "1156689025940702857", -280},
  {1.5530256899954252265565812e+271, 12, "155302569", 272},
  {1.7448822018744631525783710e-277, 8, "17448822", -276},
  {5.5444604214683403816603507e+119, 6, "554446", 120},
  {1.8566030580487825220365956e+293, 4, "1857", 294},
  {3.6314832565625452042408693e+148, 12, "363148325656", 149},
  {3.3320252835697822234911300e-111, 15, "333202528356978", -110},
  {9.2938956975043896074663136e+92, 6, "92939", 93},
  {6.6445547230313710269802710e+162, 3, "664", 163},
  {1.2647482733835463680000000e+18, 10, "1264748273", 19},
  {9.5116774991930006153787559e-141, 9, "95116775", -140},
  {8.3065723983054552086739803e-166, 5, "83066", -165},
  {1.2233736791012482407201090e-195, 9, "122337368", -194},
  {5.2520207063533617809830612e+71, 10, "5252020706", 72},
  {5.0911600375371325495815442e+226, 4, "5091", 227},
  {3.9985166067103750718795345e-173, 12, "399851660671", -172},
  {2.9746847100405275906616415e+138, 17, "29746847100405276", 139},
  {2.1075960840216481623982320e-92, 9, "210759608", -91},
  {2.6161546050841373801153792e+51, 9, "261615461", 52},
  {1.4402517239189039189441205e-65, 7, "1440252", -64},
  {1.3424233373104139396707753e+226, 15, "134242333731041", 227},
  {2.9819971787431139873677010e-117, 13, "2981997178743", -116},
  {1.2643221629127415524636784e+107, 9, "126432216", 108},
  {1.2055599298820981329333988e+172, 4, "1206", 173},
  {1.7572759601516552746101585e+296, 16, "1757275960151655", 297},
  {2.3435856481235149251393485e-173, 19, "2343585648123514925", -172},
  {1.3516353142672501065269996e-173, 14, "13516353142673", -172},
  {4.5678468758375582924800000e+20, 15, "456784687583756", 21},
  {6.8558704953870760162739685e+62, 4, "6856", 63},
  {6.9618495015379023044885254e+75, 21, "696184950153790230449", 76},
  {1.3755181131397364556401430e-88, 14, "13755181131397", -87},
  {1.3578008484504162018056783e-142, 7, "1357801", -141},
  {5.5297710425770514872234090e+132, 19, "5529771042577051487", 133},
  {6.7407759310534915351536060e-130, 14, "67407759310535", -129},
  {5.2617759934984146265669973e-131, 12, "52617759935", -130},
  {8.3159464497733409342162663e-258, 9, "831594645", -257},
  {1.1382619941468585416617291e-179, 1, "1", -178},
  {1.0471896138327352199268403e-13, 12, "104718961383", -12},
  {1.3522229587113485769277845e-161, 7, "1352223", -160},
  {8.1067579007381366700733750e+276, 2, "81", 277},
  {2.7486288793069145833843725e-198, 5, "27486", -197},
  {3.2145918618746905294715711e+233, 15, "321459186187469", 234},
  {4.1974023583230428753812542e-260, 12, "419740235832", -259},
  {1.3559766221905589665629646e-105, 17, "1355976622190559", -104},
  {2.2613609338549052148005457e+279, 17, "22613609338549052", 280},
  {1.7616691501922153089205345e-85, 5, "17617", -84},
  {5.4891194758222530639131665e+165, 5, "54891", 166},
  {5.1990855883437144280955729e-106, 4, "5199", -105},
  {2.2722913686192948233930327e+66, 2, "23", 67},
  {1.1289957899421094933355327e-287, 11, "11289957899", -286},
  {5.0861610808943482588443282e+135, 5, "50862", 136},
  {1.8502681499835226319834801e-80, 18, "185026814998352263", -79},
  {6.1399636914515403008930008e-242, 6, "613996", -241},
  {1.1474758426394707275378227e-85, 4, "1147", -84},
  {4.3517381607029557367538457e-203, 9, "435173816", -202},
  {1.6881482878483129034766952e-297, 17, "16881482878483129", -296},
  {6.5672934308443552048743974e+202, 17, "65672934308443552", 203},
  {1.5861835253677100156775270e+170, 21, "158618352536771001568", 171},
  {2.1252731165033697524613387e-01, 2, "21", 0},
  {1.0150248637523932737707174e+38, 21, "101502486375239327377", 39},
  {6.1165792056044520468979465e-209, 4, "6117", -208},
  {8.4830881427317181780076117e+45, 17, "84830881427317182", 46},
  {3.7278540060398581368036641e-260, 19, "3727854006039858137", -259},
  {1.8191524786597298472340366e-118, 15, "181915247865973", -117},
  {1.6774102825590192235155698e+300, 16, "1677410282559019", 301},
  {1.6452641199206951548627888e-222, 16, "1645264119920695", -221},
  {2.3163880500905157195433621e+245, 1, "2", 246},
  {3.4710813743749230372312842e+27, 5, "34711", 28},
  {9.0671206777173661901719251e+266, 14, "90671206777174", 267},
  {3.3036977826592863260863763e+80, 17, "33036977826592863", 81},
  {8.2971105514100004017340536e-101, 20, "82971105514100004017", -100},
  {1.8903210313470563784662019e+81, 8, "1890321", 82},
  {7.6513732277576840530322414e-72, 11, "76513732278", -71},
  {2.7690979121826347955419742e-205, 20, "27690979121826347955", -204},
  {3.9268274239292231284343932e+168, 20, "39268274239292231284", 169},
  {2.5874692768645299987428098e-265, 20, "25874692768645299987", -264},
  {1.5487366143240938413857466e+218, 14, "15487366143241", 219},
  {1.7858609435606480887692048e+68, 6, "178586", 69},
  {6.4236942055128904877268630e-55, 9, "642369421", -54},
  {4.7631473323904450894046992e+275, 11, "47631473324", 276},
  {6.4351444483831777202893673e+227, 4, "6435", 228},
  {3.3555086688165929117058855e-256, 17, "33555086688165929", -255},
  {2.4337408499570201095067459e-21, 13, "2433740849957", -20},
  {1.0834070609760551820059117e-80, 3, "108", -79},
  {3.8638473801176994096867356e-75, 1, "4", -74},
  {1.0036957082289086415821381e+229, 6, "10037", 230},
  {2.1002123499436015647072909e-149, 15, "21002123499436", -148},
  {1.5408025930367676869025810e-46, 2, "15", -45},
  {1.2058576796965900871507331e+119, 21, "120585767969659008715", 120},
  {6.3270214279945611713438701e+178, 16, "6327021427994561", 179},
  {4.8589099248447008935229451e+108, 2, "49", 109},
  {1.2297888615122855893758270e+182, 10, "1229788862", 183},
  {1.1326968946409806176150056e+119, 2, "11", 120},
  {1.1880657742256936010732711e+258, 10, "1188065774", 259},
  {1.9770811742259972200012895e-271, 14, "1977081174226", -270},
  {2.9291272184084267466772157e-262, 6, "292913", -261},
  {1.2564823328610207544747342e+174, 7, "1256482", 175},
  {1.8588306032619643070271611e-103, 7, "1858831", -102},
  {1.0679922846122049301873959e+164, 2, "11", 165},
  {6.5097538323114539135913445e+290, 17, "65097538323114539", 291},
  {2.5076012321256256356959750e+37, 15, "250760123212563", 38},
  {8.7834850061812082622369050e+288, 2, "88", 289},
  {4.8768309926904210348097855e+258, 15, "487683099269042", 259},
  {3.4915340766748995334999187e-33, 11, "34915340767", -32},
  {4.8118676571516361214910034e+154, 19, "4811867657151636121", 155},
  {1.1579794541750409360744909e-129, 6, "115798", -128},
  {2.9807684628752655925517203e+206, 7, "2980768", 207},
  {6.3338863493939677081326515e-68, 17, "63338863493939677", -67},
  {3.3667211115157965812668151e-38, 9, "336672111", -37},
  {1.0000090498392192173852683e-110, 13, "1000009049839", -109},
  {9.1355177492800495460968634e-29, 17, "91355177492800495", -28},
  {2.5894040539164247844125488e+59, 19, "2589404053916424784", 60},
  {2.1300817511401546798477585e-82, 1, "2", -81},
  {3.7314038368081369600000000e+17, 13, "3731403836808", 18},
  {6.6721406530187349242367075e-283, 6, "667214", -282},
  {5.7998187480151971212887076e-44, 17, "57998187480151971", -43},
  {1.1921803634031839259892837e-188, 4, "1192", -187},
  {1.0934878159482538259911711e-188, 19, "1093487815948253826", -187},
  {3.0092909053849692507067062e-204, 1, "3", -203},
  {3.3688175421589005632383682e-307, 10, "3368817542", -306},
  {4.1566842304025115711480639e-305, 16, "4156684230402512", -304},
  {2.5646729268310639418247882e-296, 5, "25647", -295},
  {7.1239727584827831850473288e-65, 5, "7124", -64},
  {2.2009605854334424431833541e+247, 11, "22009605854", 248},
  {1.9124626773700233162532092e-178, 9, "191246268", -177},
  {5.0887495433275726573738477e+127, 6, "508875", 128},
  {3.4574431934674997146536608e-285, 4, "3457", -284},
  {4.4340569096012887320477850e+104, 16, "4434056909601289", 105},
  {2.3215504370646192211502523e-01, 19, "2321550437064619221", 0},
  {7.0217887378285464478151402e+255, 7, "7021789", 256},
  {1.5916120903109316925493016e-100, 12, "159161209031", -99},
  {1.1264101862701774179195510e-43, 6, "112641", -42},
  {3.1389562871674127965113895e+200, 17, "31389562871674128", 201},
  {1.1412617245250334336566655e+248, 3, "114", 249},
  {1.0368611652192978033814141e+52, 16, "1036861165219298", 53},
  {1.0092436831652883285733887e+288, 11, "10092436832", 289},
  {8.0669578460885400806855261e+180, 16, "806695784608854", 181},
  {4.5671807421900827948853756e+28, 20, "45671807421900827949", 29},
  {7.7484794075584650912287904e+56, 6, "774848", 57},
  {7.4888976348314868861830735e+157, 1, "7", 158},
  {1.1531365952898070414615208e-155, 14, "11531365952898", -154},
  {1.9766703548975175437046483e+178, 7, "197667", 179},
  {3.4592606841706403577555176e+235, 6, "345926", 236},
  {7.4196514886284320493206550e-269, 2, "74", -268},
  {5.4593775690648870849609375e+11, 5, "54594", 12},
  {2.3593614657504211340778324e+168, 14, "23593614657504", 169},
  {3.1234112612189543438543290e-181, 15, "312341126121895", -180},
  {3.7211356187987874230250351e-143, 3, "372", -142},
  {5.2254963660370102567755684e-266, 11, "5225496366", -265},
  {1.2181367153681066638582671e+117, 11, "12181367154", 118},
  {1.1318046239779167835042382e-150, 1, "1", -149},
  {7.6418865433286346915711333e+256, 4, "7642", 257},
  {6.1151844803786079740925128e+237, 11, "61151844804", 238},
  {4.1368659542090475095898909e+198, 2, "41", 199},
  {7.2037919172510994054535088e+189, 15, "72037919172511", 190},
  {2.8076683987723249952958822e-195, 5, "28077", -194},
  {9.7695024449075898351363520e+159, 10, "9769502445", 160},
  {1.7218826327631117071358643e-112, 21, "172188263276311170714", -111},
  {5.5876954230020819578143188e-229, 6, "55877", -228},
  {7.1954468556774294899711967e+32, 13, "7195446855677", 33},
  {2.3874408638360959755879345e-179, 15, "23874408638361", -178},
  {1.2297623579717006252987989e-113, 1, "1", -112},
  {2.2063370140051680902191207e-225, 4, "2206", -224},
  {4.7133773619744959184028526e+73, 15, "47133773619745", 74},
  {1.5742180158989650942596625e-294, 15, "157421801589897", -293},
  {2.0207919281682433195986283e-08, 4, "2021", -7},
  {2.1793289555620368681798127e-24, 12, "217932895556", -23},
  {2.7602255916196635142527355e+246, 20, "27602255916196635143", 247},
  {2.5406376889138432021285079e-139, 13, "2540637688914", -138},
  {2.4079602758690578506686719e+255, 5, "2408", 256},
  {4.3191971596176922281566749e+158, 10, "431919716", 159},
  {9.1870543234204065491341029e+278, 21, "918705432342040654913", 279},
  {1.6872087387508828383360874e-295, 2, "17", -294},
  {6.7711336166808629082687673e-281, 21, "677113361668086290827", -280},
  {4.2562622327438842894033535e+204, 20, "42562622327438842894", 205},
  {8.9627328828556932901217823e-236, 11, "89627328829", -235},
  {2.3152776758955395397639474e-125, 7, "2315278", -124},
  {1.0407615845773974628965330e-210, 17, "10407615845773975", -209},
  {2.2958342542435268957965081e-208, 13, "2295834254244", -207},
  {3.3596252016293436991733760e+24, 13, "3359625201629", 25},
  {1.3411344748103078298445182e+162, 18, "134113447481030783", 163},
  {9.7723982503223336396452942e+111, 17, "97723982503223336", 112},
  {2.9373570287226685938001220e+210, 4, "2937", 211},
  {5.6984692082846569127735842e-195, 4, "5698", -194},
  {9.3703127791793333418678747e+301, 11, "93703127792", 302},
  {4.5038586145049858093261719e+09, 10, "4503858615", 10},
  {8.5312134178876739909996872e+275, 13, "8531213417888", 276},
  {4.6854509342896627387796304e+159, 16, "4685450934289663", 160},
  {2.1145291801659935846804866e+220, 12, "211452918017", 221},
  {6.3328139229056833163057743e-233, 1, "6", -232},
  {1.2828626298499368131160736e+07, 10, "128286263", 8},
  {1.0378025905709931560960000e+21, 9, "103780259", 22},
  {2.9075653539646831460963430e-259, 3, "291", -258},
  {1.0848004893081227109538616e+112, 18, "108480048930812271", 113},
  {1.6570395079994963701387405e-242, 12, "1657039508", -241},
  {1.8348496337450427921232339e-162, 5, "18348", -161},
  {5.3113963484795526155503159e+111, 9, "531139635", 112},
  {7.1048475404088069787161574e-145, 6, "710485", -144},
  {1.4493105322909826532251643e-02, 20, "14493105322909826532", -1},
  {5.1175398845435183464489267e-134, 21, "511753988454351834645", -133},
  {5.8277274475393403736479346e-114, 5, "58277", -113},
  {2.1334010285418271720225955e-67, 21, "213340102854182717202", -66},
  {7.6611229883806655710305278e+177, 6, "766112", 178},
  {3.1752832102636120523739508e-133, 17, "31752832102636121", -132},
  {1.7002915956713338108130529e-01, 5, "17003", 0},
  {2.3085726008492556961999708e-212, 5, "23086", -211},
  {2.8890410737288315837224639e-238, 5, "2889", -237},
  {3.5145564155659157752299799e+39, 12, "351455641557", 40},
  {7.2468391363910137228968580e-25, 18, "724683913639101372", -24},
  {2.1150590181487628159170874e+269, 4, "2115", 270},
  {7.5360638147210061392108393e-241, 5, "75361", -240},
  {9.6507778428857845240167385e-11, 7, "9650778", -10},
  {3.3956046098062716475611266e-70, 6, "33956", -69},
  {1.3130540591840813731698645e+272, 6, "131305", 273},
  {1.5133321018160444411314656e+65, 5, "15133", 66},
  {1.5270442678684386940597654e+200, 13, "1527044267868", 201},
  {1.2135789884700372757692025e-55, 17, "12135789884700373", -54},
  {3.8334713010835458792753725e+207, 7, "3833471", 208},
  {1.0686550051259956359863281e+11, 8, "1068655", 12},
  {4.5035461843713998378951214e-272, 10, "4503546184", -271},
  {3.9612797068163900089627385e+278, 21, "396127970681639000896", 279},
  {2.9417597458638555617880219e+212, 12, "294175974586", 213},
  {2.6870514604131766363432453e-31, 7, "2687051", -30},
  {8.0254046031332641770616100e-269, 17, "80254046031332642", -268},
  {2.4384722304294023193383293e-142, 15, "24384722304294", -141},
  {6.2818250345361850296972719e+285, 16, "6281825034536185", 286},
  {5.7592307158166528973120755e+293, 18, "57592307158166529", 294},
  {4.9055263980585794319615183e+111, 3, "491", 112},
  {1.9322919381889061139486538e-157, 10, "1932291938", -156},
  {4.5106231329686544982042161e-199, 7, "4510623", -198},
  {7.6678817874951430395953965e+167, 6, "766788", 168},
  {5.0821987969444252486700507e+216, 17, "50821987969444252", 217},
  {7.1236127063377870272133181e+234, 19, "7123612706337787027", 235},
  {8.1594841505434027098410921e+146, 11, "81594841505", 147},
  {6.4208510929822693153645492e-137, 4, "6421", -136},
  {4.8928858458553681064017289e+179, 6, "489289", 180},
  {5.1665379437387230154854478e+01, 13, "5166537943739", 2},
  {4.2725027629583916480825483e-144, 10, "4272502763", -143},
  {6.9725010491606763077624554e-165, 2, "7", -164},
  {9.0507414796811818498119065e-244, 9, "905074148", -243},
  {3.1540442320074121948264741e+74, 2, "32", 75},
  {6.0127988027953750190839030e+186, 10, "6012798803", 187},
  {1.6828970247749237713063386e+224, 1, "2", 225},
  {5.8481107537107346805227520e+25, 18, "584811075371073468", 26},
  {2.1906227145610510541546133e-43, 8, "21906227", -42},
  {4.4076591903063498802459729e-223, 11, "44076591903", -222},
  {1.0019042747972042607568859e+234, 18, "100190427479720426", 235},
  {1.7835767410630112740138200e-306, 21, "178357674106301127401", -305},
  {2.0404402347172622611865916e+194, 9, "204044023", 195},
  {1.8950692990695407714843750e+12, 15, "189506929906954", 13},
  {1.7393083651004423873856815e+51, 15, "173930836510044", 52},
  {2.4835243803238370399901447e+293, 11, "24835243803", 294},
  {4.9304943607167105637430900e-231, 20, "49304943607167105637", -230},
  {1.8610837849282316030006319e-234, 12, "186108378493", -233},
  {2.0437863926899918542129418e-210, 7, "2043786", -209},
  {2.6185024994218190671200500e+127, 11, "26185024994", 128},
  {1.1204039899393166680396277e-215, 21, "112040398993931666804", -214},
  {1.1973825727126884599212539e-304, 13, "1197382572713", -303},
  {2.0275616507414070934050934e-104, 12, "202756165074", -103},
  {2.6306298409262942175556166e-226, 14, "26306298409263", -225},
  {1.6503738709743940473317530e-178, 15, "165037387097439", -177},
  {1.4492117835426476266374444e-264, 11, "14492117835", -263},
  {5.1850386630511611090931724e-38, 11, "51850386631", -37},
  {8.3095013131568893176974210e+269, 6, "83095", 270},
  {5.8014558692579082912561268e-64, 7, "5801456", -63},
  {2.1610047092988696009452080e+283, 12, "21610047093", 284},
  {6.1083376623639758205406077e+161, 20, "61083376623639758205", 162},
  {7.3933871818161831678163621e-145, 16, "7393387181816183", -144},
  {1.2899886140485100499712878e-196, 17, "128998861404851", -195},
  {3.5961002746989708959293261e-297, 16, "3596100274698971", -296},
  {5.2591345380537588407695727e+291, 7, "5259135", 292},
  {5.1287117105645718587841386e+300, 20, "51287117105645718588", 301},
  {1.2021445524003724637395505e+228, 19, "1202144552400372464", 229},
  {2.7203008069397715319965453e-180, 21, "2720300806939771532", -179},
  {5.0658821498884699676817795e-113, 1, "5", -112},
  {2.0119404355382400000000000e+15, 8, "20119404", 16},
  {1.2728999166594231977236114e-273, 10, "1272899917", -272},
  {3.1448768150712564065710241e-60, 2, "31", -59},
  {9.1899244740241751151533081e-117, 3, "919", -116},
  {2.3465582201858570245686001e-136, 7, "2346558", -135},
  {2.9903706895166417691204792e-270, 8, "29903707", -269},
  {6.1337855028822576945728968e+181, 1, "6", 182},
  {9.7132274401492638684403498e+68, 8, "97132274", 69},
  {3.6163287494517075128512655e-236, 5, "36163", -235},
  {3.2763837172588325109478104e-99, 19, "3276383717258832511", -98},
  {2.7582870122132158831332993e-23, 14, "27582870122132", -22},
  {5.7370914474712422783587594e-255, 9, "573709145", -254},
  {2.0866224559902474711000113e+270, 9, "208662246", 271},
  {2.6405022344641477543801444e-237, 21, "264050223446414775438", -236},
  {1.3073919340829047458195588e+104, 7, "1307392", 105},
  {1.6524840438336603463290165e+40, 4, "1652", 41},
  {8.0303833618222996351274818e-145, 16, "80303833618223", -144},
  {1.0414770813921468359908969e-18, 15, "104147708139215", -17},
  {2.3292436698072599421394102e-03, 4, "2329", -2},
  {9.4696111172328614103102297e+176, 9, "946961112", 177},
  {3.0660579737312119849486638e+167, 14, "30660579737312", 168},
  {3.0802084097197032357670274e+34, 1, "3", 35},
  {6.5936751516723872139084294e-214, 9, "659367515", -213},
  {2.1696638225225335706706167e-284, 13, "2169663822523", -283},
  {2.1724744097535872010727836e+83, 2, "22", 84},
  {1.7488735514831082177374456e-68, 12, "174887355148", -67},
  {5.5447794207601063617836370e+280, 21, "554477942076010636178", 281},
  {4.4178053957084381507272051e-65, 13, "4417805395708", -64},
  {4.2182513945929669971748005e+295, 8, "42182514", 296},
  {8.7337468213575071106476315e-230, 1, "9", -229},
  {1.8391539651362106470487044e+161, 7, "1839154", 162},
  {1.5630332337023438460360427e-31, 12, "15630332337", -30},
  {7.6335108471309203808549292e+285, 12, "763351084713", 286},
  {1.4359259348608025937101894e+206, 4, "1436", 207},
  {6.8016836646534084257091316e-45, 15, "680168366465341", -44},
  {1.1205590524180398984565117e+148, 2, "11", 149},
  {5.3776430624286740567185916e+03, 18, "537764306242867406", 4},
  {6.1990669921170376501990322e+69, 13, "6199066992117", 70},
  {6.4820013562205029051275337e+87, 20, "64820013562205029051", 88},
  {2.5143351498726455079783049e-95, 1, "3", -94},
  {1.0959236399592089479266358e-183, 20, "10959236399592089479", -182},
  {3.2137224444475391435106724e-60, 20, "32137224444475391435", -59},
  {2.2763613814482452410761295e+306, 5, "22764", 307},
  {2.3538891566096513105574380e+67, 17, "23538891566096513", 68},
  {8.8845034483209486702988315e-113, 14, "88845034483209", -112},
  {8.6696869278165707119973427e+90, 12, "866968692782", 91},
  {1.6174136128182473741706451e+89, 13, "1617413612818", 90},
  {7.1679133346653688292964204e+189, 13, "7167913334665", 190},
  {2.0469802428678464832380106e+86, 1, "2", 87},
  {9.6611973831235401918236081e-25, 4, "9661", -24},
  {4.7508000754516159763937076e-225, 4, "4751", -224},
  {2.9506608098738348016159839e+285, 16, "2950660809873835", 286},
  {3.6434989891168054199218750e+11, 4, "3643", 12},
  {4.9957264948345433820895909e-237, 6, "499573", -236},
  {1.6951954537536176364583708e-227, 18, "169519545375361764", -226},
  {2.2966748627900719590171648e-199, 14, "22966748627901", -198},
  {5.1283742102107733736681141e+82, 19, "5128374210210773374", 83},
  {1.2403915665858500437147014e-153, 11, "12403915666", -152},
  {1.2819498116842154338773405e-165, 10, "1281949812", -164},
  {2.0516467064329781404123052e-275, 19, "205164670643297814", -274},
  {3.2732262555480970404526941e+238, 7, "3273226", 239},
  {4.3645211250448671792103869e+189, 1, "4", 190},
  {9.4406649378151208558730826e-63, 1, "9", -62},
  {2.2704844843423394724713493e+80, 11, "22704844843", 81},
  {8.6756722846648387923056040e-45, 5, "86757", -44},
  {7.4603404723466267031346104e-133, 14, "74603404723466", -132},
  {2.1035436565831482090229361e-299, 21, "210354365658314820902", -298},
  {1.8626995594359317661413698e+207, 21, "186269955943593176614", 208},
  {1.5094461015762925422261062e+205, 2, "15", 206},
  {6.6549353375532302936056073e+128, 11, "66549353376", 129},
  {3.2840232818728617995232943e+191, 4, "3284", 192},
  {1.3930556945456748841895021e+246, 11, "13930556945", 247},
  {1.0083985128607785471180800e+23, 8, "10083985", 24},
  {7.7261670861818308734111727e+183, 13, "7726167086182", 184},
  {1.4642743459101540690528715e-189, 19, "1464274345910154069", -188},
  {1.2228634079334703125230477e-60, 17, "12228634079334703", -59},
  {1.0547911885525594828573478e+56, 6, "105479", 57},
  {7.3654887544151256316493325e+175, 21, "736548875441512563165", 176},
  {3.4298313786732803143873252e-285, 5, "34298", -284},
  {4.2029255579103046747494321e-81, 14, "42029255579103", -80},
  {1.6358784164083166104930628e+220, 12, "163587841641", 221},
  {7.7488901279222259750192540e-38, 3, "775", -37},
  {5.0284205790469560966478028e+158, 7, "5028421", 159},
  {2.8720662593718214923074098e+70, 9, "287206626", 71},
  {1.4237605202795641063876811e-293, 20, "14237605202795641064", -292},
  {9.1478203273511888770231033e+41, 1, "9", 42},
  {1.1313032307197633724321973e+274, 21, "113130323071976337243", 275},
  {3.7741433037139765611807899e-300, 14, "3774143303714", -299},
  {2.0485802296386124830875480e+248, 11, "20485802296", 249},
  {3.5700296592270253871448051e+295, 12, "357002965923", 296},
  {2.5323572445399889567920790e+94, 4, "2532", 95},
  {4.3578748629666313433892247e+139, 3, "436", 140},
  {1.0124474847369504817443193e+73, 13, "1012447484737", 74},
  {4.9052446055839533951540808e+300, 15, "490524460558395", 301},
  {3.8720107346184987544924600e-22, 18, "387201073461849875", -21},
  {1.0755505008437734526961030e-191, 19, "1075550500843773453", -190},
  {3.9105562562645990400000000e+17, 19, "391055625626459904", 18},
  {9.9020846394180842099314163e+135, 12, "990208463942", 136},
  {8.3172611661276146913939958e-110, 14, "83172611661276", -109},
  {8.8189500755285948337738372e+149, 6, "881895", 150},
  {1.7035826409657462739361719e+121, 1, "2", 122},
  {3.0591934659465869928956709e-192, 4, "3059", -191},
  {1.1183770715899243182742893e+269, 16, "1118377071589924", 270},
  {1.7285494020156950763183630e+200, 3, "173", 201},
  {6.1442883784748851200000000e+18, 17, "61442883784748851", 19},
  {1.2618673573365848771909882e+110, 19, "1261867357336584877", 111},
  {4.9260790546113909312679034e-91, 8, "49260791", -90},
  {5.5510529880739160385273420e+188, 10, "5551052988", 189},
  {2.8224935402590661261984316e+107, 18, "282249354025906613", 108},
  {1.8574018110137022172568382e-89, 9, "185740181", -88},
  {1.6841887423785264382725985e-156, 17, "16841887423785264", -155},
  {9.2785686059043235211937793e-100, 16, "9278568605904324", -99},
  {5.9038498987409940051064678e-119, 19, "5903849898740994005", -118},
  {3.3702901174104725994948425e+299, 16, "3370290117410473", 300},
  {7.2240713324243087947058959e-233, 13, "7224071332424", -232},
  {7.9338087557185753484365514e+184, 5, "79338", 185},
  {3.7488379049669983089325846e-213, 16, "3748837904966998", -212},
  {3.9772157097448148005188758e-160, 3, "398", -159},
  {3.5997708303951686920387081e-176, 9, "359977083", -175},
  {4.6055534753045749236630183e-143, 2, "46", -142},
  {4.0852789566749769916315552e+32, 4, "4085", 33},
  {1.8523636758313197619710686e+73, 5, "18524", 74},
  {5.9719308734356172479303710e-192, 5, "59719", -191},
  {3.3024909091727338515071802e+176, 7, "3302491", 177},
  {9.8937829472782735482815664e-136, 12, "989378294728", -135},
  {3.0352488104452993498021504e+253, 17, "30352488104452993", 254},
  {8.5611838642209951745594522e-47, 9, "856118386", -46},
  {2.2373288330397375403169705e-22, 8, "22373288", -21},
  {1.7814592185907699661398314e+51, 11, "17814592186", 52},
  {4.1572806101485513736434862e-251, 8, "41572806", -250},
  {3.0394360357156213893212788e+104, 9, "303943604", 105},
  {4.8446597670678200665861368e+05, 20, "48446597670678200666", 6},
  {1.0195299815204259922460284e+226, 8, "101953", 227},
  {1.2991465602622404789174590e-103, 2, "13", -102},
  {2.7514102444490472218176727e-56, 18, "275141024444904722", -55},
  {8.0200149710491834096794173e+174, 5, "802", 175},
  {5.4166139923360198493392601e-178, 7, "5416614", -177},
  {9.4763375363085280295516321e-143, 2, "95", -142},
  {9.9212650313713666304055723e-270, 18, "992126503137136663", -269},
  {1.4631463014595525495519864e+208, 21, "146314630145955254955", 209},
  {8.8542397262190652322361943e-213, 21, "885423972621906523224", -212},
  {4.3543783978717807959729518e+294, 9, "43543784", 295},
  {6.1107625605239804531184455e-48, 9, "611076256", -47},
  {3.7688116890112088394380434e+81, 14, "37688116890112", 82},
  {8.7731576242428219773255868e-113, 9, "877315762", -112},
  {1.0729384296256599726760964e-35, 17, "107293842962566", -34},
  {7.7129122785525671721907322e+194, 15, "771291227855257", 195},
  {9.2726847580169206913375862e-123, 19, "9272684758016920691", -122},
  {1.4703695051159032818421244e+295, 11, "14703695051", 296},
  {3.7170464374950479296028061e+199, 9, "371704644", 200},
  {7.6485413683068030742765893e-13, 9, "764854137", -12},
  {1.7416433650671352421785181e+175, 8, "17416434", 176},
  {3.8317787416149118020795506e+242, 15, "383177874161491", 243},
  {1.1536157544772587839823106e-209, 6, "115362", -208},
  {9.1408151516951710643200309e-84, 2, "91", -83},
  {3.1647432514294277193967823e+135, 11, "31647432514", 136},
  {1.1879356663571633343821092e+249, 7, "1187936", 250},
  {4.8024118203377302953068505e+222, 19, "4802411820337730295", 223},
  {2.1204200094544169500797342e-220, 19, "212042000945441695", -219},
  {8.4217568581046018580733873e-219, 15, "84217568581046", -218},
  {1.1408453652068926427366817e-293, 5, "11408", -292},
  {1.9482247492917776232819512e+223, 5, "19482", 224},
  {2.4016704972293404314782459e-98, 17, "24016704972293404", -97},
  {3.4520553573249231040616423e-157, 20, "34520553573249231041", -156},
  {2.2204108706981906862220381e-11, 18, "222041087069819069", -10},
  {3.2716261732536530402718655e-167, 20, "32716261732536530403", -166},
  {6.3888313269983348436653614e+05, 17, "63888313269983348", 6},
  {2.6457105004236669367280886e+72, 21, "264571050042366693673", 73},
  {3.7228007954965675472552101e-263, 15, "372280079549657", -262},
  {3.7486716643706269862165572e-299, 17, "3748671664370627", -298},
  {3.2192275533215196855050518e-40, 3, "322", -39},
  {5.8641261073219425270508509e+01, 20, "58641261073219425271", 2},
  {9.5970400796116543418127619e+259, 8, "95970401", 260},
  {1.0919660296784882101680530e+265, 8, "1091966", 266},
  {5.2736700083449244868417679e-278, 11, "52736700083", -277},
  {6.5411058278612558198819408e+96, 7, "6541106", 97},
  {3.3781617186453896945190229e-225, 4, "3378", -224},
  {4.9621115195293532388082657e+78, 18, "496211151952935324", 79},
  {3.8159697603603247550420145e+176, 16, "3815969760360325", 177},
  {5.6150489848485140059337122e+121, 17, "5615048984848514", 122},
  {1.7797134596180148640083644e-140, 20, "1779713459618014864", -139},
  {8.6955028160057616941802527e+294, 5, "86955", 295},
  {5.1624623198939193986011536e-121, 16, "5162462319893919", -120},
  {5.8405823368649070933735205e-190, 14, "58405823368649", -189},
  {4.5296932759567911090501039e+285, 19, "4529693275956791109", 286},
  {1.9462311575134851733866736e-33, 14, "19462311575135", -32},
  {2.1897505990492508329143545e+104, 5, "21898", 105},
  {2.6973966120303175870204299e-64, 14, "26973966120303", -63},
  {2.3204416929532409667968750e+11, 21, "23204416929532409668", 12},
  {4.0071263329527743214141667e+95, 14, "40071263329528", 96},
  {1.8728310244229612833774104e+95, 4, "1873", 96},
  {4.6085214129088711996216207e-09, 16, "4608521412908871", -8},
  {1.7854931516611553323929658e+51, 3, "179", 52},
  {2.8812567249007596357819982e+132, 16, "288125672490076", 133},
  {1.2305635097907607249368360e+39, 9, "123056351", 40},
  {3.8501556395105110211471168e-224, 5, "38502", -223},
  {3.5545040156390844540861890e-148, 20, "35545040156390844541", -147},
  {1.5235026366912551158019164e+60, 5, "15235", 61},
  {2.3944164669261360890828400e-44, 6, "239442", -43},
  {1.1984177709623344071460499e+161, 3, "12", 162},
  {6.2217005184812683775237812e-109, 1, "6", -108},
  {3.7861259494136250368000000e+19, 2, "38", 20},
  {3.0428707995308778664245104e-107, 10, "30428708", -106},
  {2.5311539608060572629124660e-238, 8, "2531154", -237},
  {1.5346716541217412656913022e+54, 14, "15346716541217", 55},
  {1.1534138234307401063980621e-265, 15, "115341382343074", -264},
  {7.6471593695022002243256018e+170, 11, "76471593695", 171},
  {9.8460262217386138794969386e+120, 1, "1", 122},
  {7.3819647161575140490833219e+300, 11, "73819647162", 301},
  {2.5430501783562031057309632e-244, 7, "254305", -243},
  {3.3859024743755564060437797e-203, 12, "338590247438", -202},
  {1.1205465473009223552227735e+266, 20, "11205465473009223552", 267},
  {9.2019437372759476894112323e-153, 5, "92019", -152},
  {2.7718445983187513968048349e-109, 18, "27718445983187514", -108},
  {1.0920170554564858756973708e+116, 6, "109202", 117},
  {8.6735646197926598274799985e+292, 19, "8673564619792659827", 293},
  {5.3882383296353957893514851e-111, 11, "53882383296", -110},
  {1.2387660765981752117803068e-115, 12, "12387660766", -114},
  {5.3294570872346013278311276e-144, 3, "533", -143},
  {6.3993528453330291916800000e+20, 5, "63994", 21},
  {5.7496386711706607656367656e-109, 1, "6", -108},
  {5.1866063616801036729070760e-294, 5, "51866", -293},
  {8.1527009319604532631250518e-211, 13, "815270093196", -210},
  {1.6971164742918470087728345e-210, 9, "169711647", -209},
  {4.3888104231103668616286070e+233, 3, "439", 234},
  {3.1169092808979588048006522e-33, 9, "311690928", -32},
  {4.0444860736087514545809834e-124, 7, "4044486", -123},
  {1.3867295668218629008390062e-138, 21, "138672956682186290084", -137},
  {3.0058740482157794050727414e+235, 5, "30059", 236},
  {2.8651543249747613161992288e-297, 6, "286515", -296},
  {6.7392303044615779326854046e-64, 7, "673923", -63},
  {1.1346551839455777868676623e-66, 1, "1", -65},
  {1.4331386520496301690374125e-178, 6, "143314", -177},
  {1.5321106343071202992292605e-08, 3, "153", -7},
  {6.3816535726053023006221068e-15, 2, "64", -14},
  {4.7676430103911722856680315e-247, 20, "47676430103911722857", -246},
  {3.0821800629021466334607995e-266, 4, "3082", -265},
  {9.3639497658578071970485970e-48, 21, "936394976585780719705", -47},
  {9.0713441350722231279719748e-111, 10, "9071344135", -110},
  {1.1173600057462247572583252e-95, 9, "111736001", -94},
  {8.1057714932649083449435067e+34, 8, "81057715", 35},
  {1.2066193835336231640262130e-149, 20, "1206619383533623164", -148},
  {9.9180849520785192594683092e-203, 13, "9918084952079", -202},
  {3.4937533131174614945617883e-151, 3, "349", -150},
  {2.4984531449146669698925690e+268, 10, "2498453145", 269},
  {1.4141613455914949139718132e+113, 12, "141416134559", 114},
  {1.3561721245720938697020098e-55, 4, "1356", -54},
  {8.5793002288303958250232942e-253, 19, "8579300228830395825", -252},
  {1.6412769964608080375571278e+139, 20, "16412769964608080376", 140},
  {3.1280399997146989455626754e-232, 15, "31280399997147", -231},
  {1.3786034346739225618122996e-270, 18, "137860343467392256", -269},
  {1.2200833717748098766440825e+34, 19, "1220083371774809877", 35},
  {1.6022181409706832654943929e+199, 2, "16", 200},
  {4.4023533380310411314427823e-192, 6, "440235", -191},
  {1.7022261151736169363858872e-195, 11, "17022261152", -194},
  {6.1138843822704369867931465e+301, 1, "6", 302},
  {5.6478870864871411132812500e+11, 17, "56478870864871411", 12},
  {5.9852857802976716205922052e-217, 14, "59852857802977", -216},
  {4.9596951977491006073488389e-135, 6, "49597", -134},
  {3.3504118866473797566018355e+26, 13, "3350411886647", 27},
  {1.0304788164342467015589230e+86, 17, "10304788164342467", 87},
  {7.3679752585326448305895128e-291, 17, "73679752585326448", -290},
  {5.9590470953350127394728230e+254, 19, "5959047095335012739", 255},
  {5.8339793799207387725380207e+185, 10, "583397938", 186},
  {1.7709318490442601001274643e-127, 17, "17709318490442601", -126},
  {2.6684088919671312284228692e-126, 18, "266840889196713123", -125},
  {3.7426747066169469091437363e-73, 14, "37426747066169", -72},
  {8.1066105303221952000000000e+16, 14, "81066105303222", 17},
  {3.7915700396585099534082770e-120, 12, "379157003966", -119},
  {5.1250639093495269756860300e-295, 3, "513", -294},
  {7.8982180722634515844906202e-97, 13, "7898218072263", -96},
  {4.3482832313207953743313843e+29, 1, "4", 30},
  {2.2123100637721080216720934e-251, 8, "22123101", -250},
  {1.5458573596860167367780450e-201, 6, "154586", -200},
  {6.3009238940992036047839927e-115, 2, "63", -114},
  {1.7209939653771138933948185e-21, 15, "172099396537711", -20},
  {3.5381166294224111021085517e+285, 17, "35381166294224111", 286},
  {8.3760452707214138161060919e-103, 15, "837604527072141", -102},
  {7.5499174109113483108131723e+198, 12, "754991741091", 199},
  {4.9584936393738386955619890e+257, 18, "49584936393738387", 258},
  {2.0592135765903394385166268e+108, 11, "20592135766", 109},
  {3.2978512542334164772119576e-259, 8, "32978513", -258},
  {1.3236592778149017026687443e+181, 4, "1324", 182},
  {3.0781644147985067294158381e-83, 2, "31", -82},
  {1.1682313283102205308292695e-225, 2, "12", -224},
  {8.9645996160194909012121216e-246, 19, "8964599616019490901", -245},
  {5.7799321399503022922694390e+283, 20, "57799321399503022923", 284},
  {2.5327515870759577400579763e-224, 20, "25327515870759577401", -223},
  {8.4867920585246972816782601e-201, 20, "84867920585246972817", -200},
  {5.2787543272581323484186622e+209, 5, "52788", 210},
  {3.6317146838147990402576345e+118, 5, "36317", 119},
  {2.8246727813692739403996297e+172, 3, "282", 173},
  {1.2327071409315697500000000e+15, 3, "123", 16},
  {9.9284757434147556454117626e+40, 6, "992848", 41},
  {3.9033096040841790573781029e+264, 2, "39", 265},
  {4.1170089218040566378757357e-47, 17, "41170089218040566", -46},
  {4.3440337251233082931978496e+40, 4, "4344", 41},
  {1.0281797019607485157112218e-11, 3, "103", -10},
  {3.9677959773415483247114071e+130, 11, "39677959773", 131},
  {7.4348466479834701029087416e-129, 7, "7434847", -128},
  {7.6926351476225543170535961e-240, 8, "76926351", -239},
  {8.3153190791206936004489989e+61, 9, "831531908", 62},
  {1.7530939385508800038655101e-214, 17, "175309393855088", -213},
  {1.0354577469545923636612060e-100, 11, "1035457747", -99},
  {5.8584809248855853080749512e+08, 15, "585848092488559", 9},
  {8.1471349966712716824170930e+251, 4, "8147", 252},
  {4.0740750781883109875491657e+183, 3, "407", 184},
  {3.6442192909201605106594956e+84, 16, "3644219290920161", 85},
  {6.0334496265471492203193770e+86, 16, "6033449626547149", 87},
  {1.6523130953954678942728119e-116, 4, "1652", -115},
  {6.2334839931474692062276047e+170, 18, "623348399314746921", 171},
  {6.6571913334324273048281384e-01, 9, "665719133", 0},
  {2.2848006388407013828721794e-149, 16, "2284800638840701", -148},
  {2.0031488026532253345352438e+68, 13, "2003148802653", 69},
  {2.7567334568712613365015234e-63, 5, "27567", -62},
  {1.1155567363428386413121756e-131, 12, "111555673634", -130},
  {1.6680800475674924243270721e-210, 13, "1668080047567", -209},
  {2.6907272751483011058190202e+44, 2, "27", 45},
  {2.9984429561372373366247992e+52, 5, "29984", 53},
  {1.7417165398430147363383887e+259, 2, "17", 260},
  {3.0561322988346238644275247e-140, 6, "305613", -139},
  {6.3562862344473116886673314e-301, 21, "635628623444731168867", -300},
  {2.6645279665878860900214787e-192, 18, "266452796658788609", -191},
  {2.2186472112123565422712369e+159, 15, "221864721121236", 160},
  {9.5365157012243438008713645e+71, 18, "95365157012243438", 72},
  {2.1812594418179182474136774e+219, 21, "218125944181791824741", 220},
  {1.9999032194303076545105247e+131, 14, "19999032194303", 132},
  {1.7578497801918138023063232e-142, 17, "17578497801918138", -141},
  {2.7471089695804755757122159e-59, 5, "27471", -58},
  {9.2301441275011621898428230e-232, 19, "923014412750116219", -231},
  {3.1107697542929088676180276e-142, 15, "311076975429291", -141},
  {2.4595877205762398911412024e-296, 11, "24595877206", -295},
  {2.8522823874927045759904470e-263, 17, "28522823874927046", -262},
  {1.6915852691915806712874437e-74, 13, "1691585269192", -73},
  {4.9270603867165881051102983e-212, 10, "4927060387", -211},
  {1.4653124060119640242315772e-77, 6, "146531", -76},
  {8.7997106843367599132618713e-79, 12, "879971068434", -78},
  {6.4577901099976335099399616e+267, 13, "6457790109998", 268},
  {3.5650358225015465002314298e-245, 16, "3565035822501547", -244},
  {5.2659459418279949304933368e-89, 20, "52659459418279949305", -88},
  {2.2662653181075161480038643e-290, 10, "2266265318", -289},
  {9.2141718792051655833214870e-191, 21, "921417187920516558332", -190},
  {9.7278361498448229669553436e-241, 1, "1", -239},
  {5.0510311771177920310667867e-218, 11, "50510311771", -217},
  {8.8346066331646038636582225e-175, 3, "883", -174},
  {4.6628166379860820312500000e+12, 15, "466281663798608", 13},
  {1.3234162309274891490532909e-210, 8, "13234162", -209},
  {5.4424941847112475732000739e+155, 4, "5442", 156},
  {2.3888064519090669731273260e-81, 20, "23888064519090669731", -80},
  {9.1172078895934035186152300e-87, 18, "911720788959340352", -86},
  {3.4677853182492282229791094e-266, 7, "3467785", -265},
  {9.0917042893966298285713475e+193, 15, "909170428939663", 194},
  {7.9696031485061615026291232e-60, 21, "796960314850616150263", -59},
  {3.7701093612119035285327721e-134, 12, "377010936121", -133},
  {1.2318766779801886023298315e-163, 9, "123187668", -162},
  {4.8626998627688771473927665e-61, 21, "486269986276887714739", -60},
  {1.8907688532923485026373534e-213, 10, "1890768853", -212},
  {3.0915899089920382487420921e-263, 9, "309158991", -262},
  {5.5322977852640848799692347e+196, 5, "55323", 197},
  {1.2605200703445966519651231e-264, 8, "12605201", -263},
  {1.2169999077475875442956208e-289, 13, "1216999907748", -288},
  {1.3380166536628063050946307e+40, 12, "133801665366", 41},
  {7.3592826361063663609620204e+105, 21, "735928263610636636096", 106},
  {3.2312894056020398552284827e+245, 2, "32", 246},
  {3.2883817288890999893311768e+88, 11, "32883817289", 89},
  {9.6750071170810362786663688e+165, 13, "9675007117081", 166},
  {1.0418747101442153323271094e+37, 15, "104187471014422", 38},
  {4.2006415137693691774715987e-215, 4, "4201", -214},
  {3.9806237777401931167693364e+291, 5, "39806", 292},
  {1.5738676254511202356209948e+138, 15, "157386762545112", 139},
  {5.5741681717483378061634046e+104, 4, "5574", 105},
  {1.8513027648376056475939990e-09, 12, "185130276484", -8},
  {2.3363270238161353581256186e-224, 16, "2336327023816135", -223},
  {1.4406167278937667596023962e-93, 15, "144061672789377", -92},
  {1.2315490700503569753716634e+212, 3, "123", 213},
  {4.9342738894740559800807572e+38, 20, "49342738894740559801", 39},
  {2.9260284108501300771438145e-150, 2, "29", -149},
  {1.8657169034404320861254147e-35, 16, "1865716903440432", -34},
  {1.4096280386169208682300613e-121, 2, "14", -120},
  {1.8076573405430748046425439e-59, 18, "18076573405430748", -58},
  {5.4012714544688400514203546e-23, 9, "540127145", -22},
  {8.9130072544642520922968549e-194, 16, "8913007254464252", -193},
  {9.5575884982190310829820351e-163, 8, "95575885", -162},
  {6.6286001311212796008423897e+181, 7, "66286", 182},
  {5.2844820415475867187500000e+13, 2, "53", 14},
  {1.3001979213924897503905085e+110, 1, "1", 111},
  {1.8557811241708375685714629e-184, 11, "18557811242", -183},
  {6.9996042095379695225272051e+220, 21, "699960420953796952253", 221},
  {4.5801677192774225142716549e-145, 15, "458016771927742", -144},
  {1.0004162207611517882642121e-101, 4, "1", -100},
  {1.6151660799143353372134310e+36, 19, "1615166079914335337", 37},
  {2.0847404277461053455195849e+269, 5, "20847", 270},
  {2.6573806778144890371710074e+244, 14, "26573806778145", 245},
  {7.7368659948504947405058806e-153, 15, "773686599485049", -152},
  {1.7705353294247296356101594e-98, 9, "177053533", -97},
  {9.1524787142118171718215039e+191, 9, "915247871", 192},
  {1.0755963151592371612335686e-124, 16, "1075596315159237", -123},
  {1.2770962105541323355366807e-155, 1, "1", -154},
  {4.5214129688969449288032646e+248, 8, "4521413", 249},
  {2.1300030860412826823823453e-87, 11, "2130003086", -86},
  {1.8675947684432693358644362e-139, 7, "1867595", -138},
  {7.2171901799079559181879608e+35, 16, "7217190179907956", 36},
  {2.8465937899962075945886354e-242, 15, "284659378999621", -241},
  {9.4972512156932031610554619e+93, 8, "94972512", 94},
  {4.2630383463743003339479548e-137, 14, "42630383463743", -136},
  {4.4828852199673632733320900e+245, 20, "44828852199673632733", 246},
  {1.6876968139245749703578336e+161, 6, "16877", 162},
  {1.7558351976584456224372843e+03, 6, "175584", 4},
  {8.5644490031129171567632300e-83, 6, "856445", -82},
  {4.4268499395325303796145388e-30, 4, "4427", -29},
  {1.2075948326306190547427657e+115, 15, "120759483263062", 116},
  {3.7525040277132996782894703e+149, 14, "37525040277133", 150},
  {2.1312204370669675186941979e+134, 2, "21", 135},
  {3.5975443753827806776376373e+165, 13, "3597544375383", 166},
  {1.5942410803711007850141958e+74, 11, "15942410804", 75},
  {3.2653341404306141846555335e+133, 20, "32653341404306141847", 134},
  {1.2169130265713657951602224e+61, 14, "12169130265714", 62},
  {1.3380079334518801827347188e+210, 9, "133800793", 211},
  {2.5797526826182721287039956e-112, 16, "2579752682618272", -111},
  {2.9067433705600071157582444e-64, 19, "2906743370560007116", -63},
  {7.4131280947426806375748709e+250, 1, "7", 251},
  {1.6742181194412722137674732e-180, 17, "16742181194412722", -179},
  {5.0784344733341287249914651e+43, 4, "5078", 44},
  {1.1597919975305478154133209e-122, 15, "115979199753055", -121},
  {1.1421179911400645700492266e+134, 10, "1142117991", 135},
  {1.7571509257156742072983993e+104, 11, "17571509257", 105},
  {1.7329491124064337848903090e-91, 11, "17329491124", -90},
  {3.8934607440304218792602470e-269, 17, "38934607440304219", -268},
  {5.5767288409800855603884901e+283, 5, "55767", 284},
  {5.9677947112316086340026752e-66, 3, "597", -65},
  {5.3301994671573420799323193e+94, 4, "533", 95},
  {5.4569955223439706938743890e-294, 9, "545699552", -293},
  {2.3599638165243652257229404e+58, 14, "23599638165244", 59},
  {5.6686299820610285232489585e-249, 3, "567", -248},
  {5.4560592938234142256424118e+55, 10, "5456059294", 56},
  {9.5685681511318677035056087e-37, 15, "956856815113187", -36},
  {9.7800307140008591081264108e-105, 6, "978003", -104},
  {1.9219755202754934201196238e+173, 19, "192197552027549342", 174},
  {9.6728617235376328012394644e-240, 12, "967286172354", -239},
  {5.0217051599807555667486856e-95, 8, "50217052", -94},
  {2.9600662456320084059835621e-211, 4, "296", -210},
  {4.4576599387724847264845970e+126, 2, "45", 127},
  {1.6752957399712036437453137e+236, 15, "16752957399712", 237},
  {6.3409785766049316960705451e-21, 11, "63409785766", -20},
  {2.8808131439269703758772219e-304, 20, "28808131439269703759", -303},
  {1.2315541348247373650851511e-287, 5, "12316", -286},
  {2.9587361057523703493643552e+03, 17, "29587361057523703", 4},
  {1.6029243494067607463124637e-215, 6, "160292", -214},
  {1.4644538604847728354258457e-124, 9, "146445386", -123},
  {1.7366712839505730067898553e+224, 1, "2", 225},
  {2.4787775222455966514345150e-262, 9, "247877752", -261},
  {7.6478978778418088546734418e+87, 18, "764789787784180885", 88},
  {7.4103037715833059682644511e-274, 3, "741", -273},
  {4.0854311332411109314266328e-73, 1, "4", -72},
  {5.8968416958943103784131924e-268, 20, "58968416958943103784", -267},
  {5.2820883457096523278233337e-110, 17, "52820883457096523", -109},
  {3.1986206612629696167633257e-88, 4, "3199", -87},
  {6.0098209986093304041765652e+169, 14, "60098209986093", 170},
  {1.2108864749162648128943151e+221, 1, "1", 222},
  {1.6029174334295549023287388e-128, 4, "1603", -127},
  {4.1991253291736536998296132e+189, 20, "41991253291736536998", 190},
  {7.7874135209190714359283447e+08, 12, "778741352092", 9},
  {5.3504947478943511187419466e+249, 2, "54", 250},
  {2.8003226010899363875298580e-155, 17, "28003226010899364", -154},
  {2.6193731019618878024691464e-225, 5, "26194", -224},
  {1.0377721123952970677639020e+160, 13, "1037772112395", 161},
  {6.1862469804997885675583449e-137, 7, "6186247", -136},
  {2.5873853686056748944042794e+164, 17, "25873853686056749", 165},
  {1.3623127344600384833629137e-21, 19, "1362312734460038483", -20},
  {1.6386743619399599265307188e+06, 21, "163867436193995992653", 7},
  {5.0383316026224214267603221e+257, 9, "50383316", 258},
  {6.6504040440269529533641736e+87, 16, "6650404044026953", 88},
  {4.2112106842840112152879852e+43, 11, "42112106843", 44},
  {1.2460455992145317636552527e+231, 19, "1246045599214531764", 232},
  {7.5020296516925425783366429e+298, 2, "75", 299},
  {2.6885926241295462982512939e-244, 15, "268859262412955", -243},
  {2.8078485867865508002316866e-293, 20, "28078485867865508002", -292},
  {3.9737276697629999172198183e-173, 9, "397372767", -172},
  {1.1572628175255442565589025e-215, 8, "11572628", -214},
  {3.8290299420959741104197923e-242, 21, "382902994209597411042", -241},
  {1.9722709931728955141402124e+227, 17, "19722709931728955", 228},
  {5.0175900376291793614433388e+243, 8, "501759", 244},
  {5.4348469832613010156599467e-207, 7, "5434847", -206},
  {1.2066166602135275533120489e+166, 15, "120661666021353", 167},
  {9.1740759008247174171553173e+285, 18, "917407590082471742", 286},
  {9.7700898586208687278922890e-25, 18, "977008985862086873", -24},
  {1.0553657746576722300355961e-229, 1, "1", -228},
  {1.7945472913069123185414896e-154, 21, "179454729130691231854", -153},
  {1.5197717148333339276215710e+187, 11, "15197717148", 188},
  {1.2972806632368350026077831e+28, 9, "129728066", 29},
  {2.6146038313523914755844498e+71, 13, "2614603831352", 72},
  {2.5814640324870568353959205e+128, 8, "2581464", 129},
  {5.9343914437415759372061619e+294, 14, "59343914437416", 295},
  {5.1025150949454148399034768e-45, 18, "510251509494541484", -44},
  {5.7753956547290743236478963e-25, 5, "57754", -24},
  {1.1176244319830894801856706e-149, 9, "111762443", -148},
  {4.3143604650956598876946325e-52, 1, "4", -51},
  {6.5832400873234354005128673e+195, 8, "65832401", 196},
  {2.3526694087116779041293441e+260, 10, "2352669409", 261},
  {8.3338852890156922443967050e-192, 12, "833388528902", -191},
  {5.0438743715331988486809505e+288, 15, "50438743715332", 289},
  {3.6067593829195136194394388e+202, 13, "360675938292", 203},
  {9.7818505391850518471001376e+86, 13, "9781850539185", 87},
  {2.4537420461284745822539051e-55, 19, "2453742046128474582", -54},
  {1.7161240250340067326782754e-106, 14, "1716124025034", -105},
  {7.7944645597264856983736782e-291, 10, "779446456", -290},
  {6.9756646337388178279041976e+47, 6, "697566", 48},
  {2.0133705410357835003367338e+294, 4, "2013", 295},
  {2.7663879402435897850267187e-215, 20, "2766387940243589785", -214},
  {4.1190026698655617630701227e-200, 10, "411900267", -199},
  {7.7812044604425756519876650e+71, 19, "7781204460442575652", 72},
  {1.3440074073700229328999685e+224, 1, "1", 225},
  {4.2052681603722577995074482e+134, 21, "420526816037225779951", 135},
  {7.0142808123836607624008728e+256, 2, "7", 257},
  {2.1332659832730715246874375e-273, 8, "2133266", -272},
  {1.1905497556710190462483594e+79, 17, "1190549755671019", 80},
  {2.6456607145102289662840108e+196, 12, "264566071451", 197},
  {1.5262142373408032949813821e-298, 21, "152621423734080329498", -297},
  {3.9058867465585525959901481e+54, 13, "3905886746559", 55},
  {1.1343647746251067929491687e-244, 11, "11343647746", -243},
  {1.7981161472143336992703179e-99, 1, "2", -98},
  {2.6767897462732125383810795e-223, 15, "267678974627321", -222},
  {5.5443899197407735017194267e+85, 16, "5544389919740774", 86},
  {2.7038771060263474109615267e-257, 18, "270387710602634741", -256},
  {7.2404658902407884627282553e-19, 12, "724046589024", -18},
  {1.7801124755208629500414148e-24, 8, "17801125", -23},
  {3.1243381856107181645699613e-55, 16, "3124338185610718", -54},
  {1.2942848829097654166999968e-173, 21, "12942848829097654167", -172},
  {2.8381747819972378390250072e-162, 1, "3", -161},
  {3.4033186313029335951884184e-25, 19, "3403318631302933595", -24},
  {3.0582347224244527183078067e+202, 2, "31", 203},
  {4.2326746110283720053609333e+220, 13, "4232674611028", 221},
  {1.7201471206128285608958304e+54, 15, "172014712061283", 55},
  {4.0915067495690886660526993e+96, 8, "40915067", 97},
  {1.1472380259409241019806425e+191, 14, "11472380259409", 192},
  {7.7866885251611593632759855e-276, 12, "778668852516", -275},
  {7.3176058521352152624779467e+43, 3, "732", 44},
  {9.3257255223925576967290464e+205, 14, "93257255223926", 206},
  {6.0778514031552548615226426e+110, 10, "6077851403", 111},
  {6.7543443488643906190153338e+163, 18, "675434434886439062", 164},
  {1.4984931382214970237988222e-11, 9, "149849314", -10},
  {4.3733339447866902812432745e-106, 14, "43733339447867", -105},
  {8.6955475938685426367007549e-251, 20, "86955475938685426367", -250},
  {8.0608260698043818850984471e-24, 15, "806082606980438", -23},
  {9.6007078863629497821920837e-250, 4, "9601", -249},
  {5.8284461782409197094940978e+124, 2, "58", 125},
  {1.8037236411088474556703871e-200, 7, "1803724", -199},
  {3.1236542294545145778453318e+137, 9, "312365423", 138},
  {7.5186136802290305266078995e-67, 8, "75186137", -66},
  {1.0904249591945172142004594e+03, 18, "109042495919451721", 4},
  {2.8595076572619827657801103e-289, 2, "29", -288},
  {9.4323049334990483575936553e-219, 7, "9432305", -218},
  {2.3142959732589454654478318e+237, 2, "23", 238},
  {3.0933908589739043935779274e+279, 1, "3", 280},
  {3.8778355550770476373838936e-24, 18, "387783555507704764", -23},
  {2.9505814025860998702929094e-301, 9, "29505814", -300},
  {1.7124678007782615903882097e+250, 3, "171", 251},
  {5.2146477827668911206866938e-222, 18, "521464778276689112", -221},
  {1.6173489190294346387174608e+255, 5, "16173", 256},
  {2.4751677218893671833525936e-282, 16, "2475167721889367", -281},
  {4.3814095351277678908205183e-53, 13, "4381409535128", -52},
  {6.3214869328569734023140026e-109, 2, "63", -108},
  {2.5450146047203019591465943e-33, 4, "2545", -32},
  {8.3300772066855801380763633e-57, 11, "83300772067", -56},
  {1.3627122414695192472288273e-283, 16, "1362712241469519", -282},
  {1.8141154804778550125818991e+253, 16, "1814115480477855", 254},
  {5.9323477850849411771336023e+153, 16, "5932347785084941", 154},
  {1.7528526732378181834310795e-278, 11, "17528526732", -277},
  {3.4473024088716715100863970e+123, 1, "3", 124},
  {4.4139669017875160506036991e+00, 15, "441396690178752", 1},
  {8.2387281913006034887785534e+93, 14, "82387281913006", 94},
  {3.3534759636519899735814881e+197, 15, "335347596365199", 198},
  {4.3115599997697174937013701e-195, 6, "431156", -194},
  {1.3923872397282997005638264e+142, 21, "139238723972829970056", 143},
  {4.7574773629701246778153050e+178, 5, "47575", 179},
  {1.6686571446179080658122574e+306, 4, "1669", 307},
  {2.0627809020752968048228152e+191, 19, "2062780902075296805", 192},
  {5.6106915167755494454680693e-275, 20, "56106915167755494455", -274},
  {4.0047206155910534622721410e-191, 9, "400472062", -190},
  {2.8786902635647264611366054e+198, 10, "2878690264", 199},
  {2.6507420868020155456785377e-210, 17, "26507420868020155", -209},
  {1.2466743348638400969924849e-138, 13, "1246674334864", -137},
  {3.8764157024449991186948288e+142, 16, "3876415702444999", 143},
  {2.0579454012368347094715766e+283, 19, "2057945401236834709", 284},
  {2.8461357182347386904432191e-107, 20, "28461357182347386904", -106},
  {4.6240266517493344151294880e-43, 16, "4624026651749334", -42},
  {2.5973968638649828174707802e-56, 7, "2597397", -55},
  {1.5835816711850537714532495e-108, 5, "15836", -107},
  {2.0797207096374550494383007e+259, 11, "20797207096", 260},
  {4.5160807720671552672924196e-124, 9, "451608077", -123},
  {2.3806309956858266255360000e+21, 10, "2380630996", 22},
  {1.4083829987264187141343005e-242, 14, "14083829987264", -241},
  {7.6357851105844672266150019e+291, 17, "76357851105844672", 292},
  {2.1191294864429561449561329e+152, 13, "2119129486443", 153},
  {3.2822239718651489231815640e-248, 18, "328222397186514892", -247},
  {1.8595524168228265698377382e+50, 9, "185955242", 51},
  {1.9724358328686991045562484e+159, 16, "1972435832868699", 160},
  {3.6008406949440208075923425e+267, 8, "36008407", 268},
  {9.8144768935525053825204521e-273, 11, "98144768936", -272},
  {2.1119016000196043580825298e+250, 2, "21", 251},
  {9.0695546369886001916196013e+259, 11, "9069554637", 260},
  {2.9253083099688421843502459e-61, 20, "29253083099688421844", -60},
  {1.5433834600458441112095365e-167, 7, "1543383", -166},
  {1.6205396672118554823229440e+25, 11, "16205396672", 26},
  {1.7664274600832347028339425e+208, 15, "176642746008323", 209},
  {1.5487574417090609360595362e-122, 15, "154875744170906", -121},
  {1.6799541877643169517542031e-207, 20, "16799541877643169518", -206},
  {9.7947662537885848561948304e+201, 10, "9794766254", 202},
  {8.1451388848436500084192394e+158, 21, "814513888484365000842", 159},
  {3.0273541729024954485190678e+188, 7, "3027354", 189},
  {1.2983464669761634635430141e-160, 21, "129834646697616346354", -159},
  {1.1108432630689231804807836e+78, 5, "11108", 79},
  {8.7419415543482397980635829e+61, 2, "87", 62},
  {1.1471527581367251959075892e-121, 3, "115", -120},
  {9.3939186498540610033887643e-180, 8, "93939186", -179},
  {1.4012842079616532480000000e+19, 9, "140128421", 20},
  {3.2966238004318378339279987e+206, 7, "3296624", 207},
  {7.1972588056433204244698490e+302, 6, "719726", 303},
  {2.2487249103774368258485686e+253, 5, "22487", 254},
  {8.9955632314580256224305118e-307, 13, "8995563231458", -306},
  {5.6761807856134271799427173e+281, 7, "5676181", 282},
  {2.3128781298528865573297072e-303, 9, "231287813", -302},
  {2.4118429941968239303338158e-166, 9, "241184299", -165},
  {3.5611670462837738785012252e+306, 19, "3561167046283773879", 307},
  {1.9184460240960545886637480e+102, 21, "191844602409605458866", 103},
  {1.1109531752225286085230928e-166, 6, "111095", -165},
  {6.7293171386917350976857794e-194, 17, "67293171386917351", -193},
  {4.6548147142428743601602833e-29, 13, "4654814714243", -28},
  {7.5280475785065317166031380e+40, 6, "752805", 41},
  {1.0477421902523901222794787e+61, 18, "104774219025239012", 62},
  {1.6292428090584563677606374e+284, 17, "16292428090584564", 285},
  {2.4841595432412676640090489e+223, 9, "248415954", 224},
  {7.9079685816622957774269025e-227, 12, "790796858166", -226},
  {1.1607573253183655831928832e+25, 4, "1161", 26},
  {1.0015098077782504615072634e-170, 15, "100150980777825", -169},
  {2.0111277240747167124661568e+129, 9, "201112772", 130},
  {6.4992580208839510363087222e-263, 14, "6499258020884", -262},
  {2.2076697820678797520469076e-119, 18, "220766978206787975", -118},
  {7.3740377300230214134283721e+292, 11, "737403773", 293},
  {1.9747220692811950324196810e-113, 6, "197472", -112},
  {2.5278241853575557420537016e-280, 13, "2527824185358", -279},
  {6.1128260690319441628183746e+42, 7, "6112826", 43},
  {3.7668974309248727243292698e+166, 20, "37668974309248727243", 167},
  {7.0530195582392701893006453e-76, 8, "70530196", -75},
  {1.3520314302989066006708226e+37, 10, "135203143", 38},
  {2.2234936257443003849141855e-123, 13, "2223493625744", -122},
  {2.0685690196411479325589541e+235, 18, "206856901964114793", 236},
  {1.3446714489938222388412538e-63, 16, "1344671448993822", -62},
  {5.6566886622618916755783374e-266, 4, "5657", -265},
  {1.0458588045339578437414054e-255, 12, "104585880453", -254},
  {1.1091843380963228371830255e-162, 16, "1109184338096323", -161},
  {1.5098082120199823092128446e+137, 11, "1509808212", 138},
  {4.7475657721236257622706641e+245, 1, "5", 246},
  {4.1804554850944439833445108e-246, 14, "41804554850944", -245},
  {1.6805005962115926199110839e+284, 4, "1681", 285},
  {6.3710927409660389812913200e-09, 17, "6371092740966039", -8},
  {1.0125912251412183416789802e+123, 14, "10125912251412", 124},
  {7.3847651228319278117268057e+223, 11, "73847651228", 224},
  {1.0303677755869739273112481e-261, 17, "10303677755869739", -260},
  {1.2313470310364094135288796e-144, 4, "1231", -143},
  {1.3296670209602211523669287e+224, 3, "133", 225},
  {3.0143181900045372311614491e-239, 17, "30143181900045372", -238},
  {1.2405717615555266015333755e-290, 17, "12405717615555266", -289},
  {1.1993103202671304562396565e-160, 7, "119931", -159},
  {1.0594080630560016288654879e+04, 16, "1059408063056002", 5},
  {3.3447549440957417131002617e-264, 18, "334475494409574171", -263},
  {9.2603222965442644110630466e+138, 10, "9260322297", 139},
  {1.6286771213390983154086065e-74, 18, "162867712133909832", -73},
  {2.0044269236512219600519972e+75, 8, "20044269", 76},
  {3.3019785560114996292702641e-273, 7, "3301979", -272},
  {7.5599073599866094670585581e-168, 10, "755990736", -167},
  {1.4970616807051141402158034e-199, 18, "149706168070511414", -198},
  {1.9519680880626401506424371e+85, 16, "195196808806264", 86},
  {1.4412797585868373693006961e+252, 8, "14412798", 253},
  {6.2573394739250930803294585e+176, 14, "62573394739251", 177},
  {4.8052709332901313834773648e+73, 19, "4805270933290131383", 74},
  {1.2192425752149655352154833e+249, 3, "122", 250},
  {5.8540672010263784169255521e-82, 6, "585407", -81},
  {2.1080690982846924972108947e-81, 14, "21080690982847", -80},
  {5.3057411470188129496193526e-196, 20, "53057411470188129496", -195},
  {1.1570428770581185744882697e+288, 21, "115704287705811857449", 289},
  {2.7907514049762515302539467e-134, 21, "279075140497625153025", -133},
  {3.2458832200825813035040340e+297, 6, "324588", 298},
  {3.3539966181278652821184223e-230, 14, "33539966181279", -229},
  {2.7226888957548474073634580e+296, 10, "2722688896", 297},
  {3.0681425554569547612316172e-115, 4, "3068", -114},
  {3.4003064051624043709552565e-46, 16, "3400306405162404", -45},
  {6.7151206638772374703736452e-180, 20, "67151206638772374704", -179},
  {1.7995425844910257230204934e+57, 2, "18", 58},
  {1.8634420562593512910575639e-214, 20, "18634420562593512911", -213},
  {2.2779715393203504578295618e-121, 5, "2278", -120},
  {1.0701720630358543066111911e+276, 2, "11", 277},
  {5.3486880469327820064340157e+49, 10, "5348688047", 50},
  {3.1905708839817305207162410e-232, 16, "3190570883981731", -231},
  {6.0121105993936341285578198e-232, 3, "601", -231},
  {2.6146536624141653492515275e+275, 4, "2615", 276},
  {1.6239090795485574113830111e+115, 1, "2", 116},
  {1.1558644381690255769600000e+20, 8, "11558644", 21},
  {5.5817336446720457106958299e+85, 19, "5581733644672045711", 86},
  {1.6019604454133993336653068e-133, 15, "16019604454134", -132},
  {3.1500141377477005496755240e-220, 1, "3", -219},
  {3.7000649147972307652835362e+186, 12, "37000649148", 187},
  {1.1091907287044962489304294e+155, 6, "110919", 156},
  {2.0062450442442773012977965e-60, 21, "20062450442442773013", -59},
  {4.2278660114809945805637274e-184, 3, "423", -183},
  {4.6204604426716655357369936e+277, 17, "46204604426716655", 278},
  {2.4890942330943138809180094e-208, 13, "2489094233094", -207},
  {2.9714748472496046434272969e-144, 21, "297147484724960464343", -143},
  {3.4040981160539687947506146e-219, 6, "34041", -218},
  {1.6935732629244259082711338e+62, 6, "169357", 63},
  {7.1799371734559399101403952e+301, 8, "71799372", 302},
  {1.4055914163826112619759055e-244, 4, "1406", -243},
  {3.5217567701000380111509003e+03, 21, "352175677010003801115", 4},
  {2.8570367213515647766569408e-265, 6, "285704", -264},
  {1.0009553107995640505695483e+276, 19, "1000955310799564051", 277},
  {1.1244634896960044404430780e-142, 4, "1124", -141},
  {1.3932924887242143482403364e+121, 3, "139", 122},
  {2.4349035706478300568333670e-186, 16, "243490357064783", -185},
  {1.1240101660822248618520349e+303, 14, "11240101660822", 304},
  {1.8268744756135246228749638e-152, 2, "18", -151},
  {1.0915901548289086178336047e+152, 9, "109159015", 153},
  {9.1065731455050851157058679e-209, 20, "91065731455050851157", -208},
  {2.1610376036521646805594582e-61, 8, "21610376", -60},
  {8.3080716508444859589038362e+199, 9, "830807165", 200},
  {5.4240454818247232926522465e+269, 11, "54240454818", 270},
  {1.3908011052799472736004282e-150, 11, "13908011053", -149},
  {1.0457738047720061671434714e+38, 3, "105", 39},
  {2.9393976763016950194240177e+240, 17, "2939397676301695", 241},
  {1.6467208850562225554381461e+299, 19, "1646720885056222555", 300},
  {3.0172143649842306389719450e-134, 2, "3", -133},
  {2.9061691484990188908260515e+230, 15, "290616914849902", 231},
  {4.2144044999753455971718607e-27, 3, "421", -26},
  {4.1516557700663825931519404e-109, 13, "4151655770066", -108},
  {9.9747471882876729057169784e-104, 1, "1", -102},
  {5.3483448966622735857234481e+228, 19, "5348344896662273586", 229},
  {4.4922304141483788206196973e+163, 9, "449223041", 164},
  {1.1593649906532492017516480e-183, 20, "11593649906532492018", -182},
  {3.1649192494147487067613886e+257, 1, "3", 258},
  {1.9249403670548330690141185e+245, 12, "192494036705", 246},
  {1.3108982636432938309757622e+219, 13, "1310898263643", 220},
  {7.3617543555843200577356817e+130, 7, "7361754", 131},
  {1.8400199929004222711226477e-92, 19, "1840019992900422271", -91},
  {2.4855091932333622704332693e-169, 14, "24855091932334", -168},
  {4.0836651406284838075755850e-131, 5, "40837", -130},
  {7.9223417873260740050692599e+204, 17, "7922341787326074", 205},
  {6.3003851284581259065059154e+221, 15, "630038512845813", 222},
  {5.0427832051559068963082330e-95, 12, "504278320516", -94},
  {3.8335554673776327942194090e-37, 7, "3833555", -36},
  {3.0304258190273138973300150e+57, 11, "3030425819", 58},
  {4.3632653704261245741443287e+285, 6, "436327", 286},
  {4.8535718648092828569511349e+145, 6, "485357", 146},
  {9.8984949847688079640760347e+259, 7, "9898495", 260},
  {1.8643957214514976605483253e-110, 9, "186439572", -109},
  {2.2039244052218739069583979e-97, 2, "22", -96},
  {6.5456595825247976722269413e+208, 16, "6545659582524798", 209},
  {4.8677354020532767395088924e-244, 15, "486773540205328", -243},
  {1.3543258941736369901197502e-259, 11, "13543258942", -258},
  {7.0255172497830825955598723e-255, 12, "702551724978", -254},
  {1.0501382403882732008114705e-136, 14, "10501382403883", -135},
  {1.5882548834440985098470058e-233, 6, "158825", -232},
  {4.6388960399516010385981027e-169, 5, "46389", -168},
  {1.3416233448215791850806573e+193, 2, "13", 194},
  {4.7161999501434613571897085e+73, 10, "471619995", 74},
  {2.5723035209785536983757368e-278, 11, "2572303521", -277},
  {4.5368974780052363875234835e-306, 7, "4536897", -305},
  {2.9142604035324680807110033e-291, 13, "2914260403532", -290},
  {3.7131907534905706055467886e+276, 19, "3713190753490570606", 277},
  {2.7267799850941152328687167e+00, 7, "272678", 1},
  {4.4654091216406601458227555e+236, 11, "44654091216", 237},
  {1.9311184148870283860386507e-307, 5, "19311", -306},
  {3.6440786819768222931390171e-293, 2, "36", -292},
  {3.9317515579035305794373920e-54, 14, "39317515579035", -53},
  {2.2070184740275794313787899e-26, 10, "2207018474", -25},
  {3.8783264595207649640646047e+164, 11, "38783264595", 165},
  {7.3583905627459416498113452e-263, 8, "73583906", -262},
  {1.4145675159908753126182857e-143, 8, "14145675", -142},
  {7.0151460355696796107517080e+38, 3, "702", 39},
  {2.9431578899894218422612211e-84, 14, "29431578899894", -83},
  {1.2778124030768158521712109e-41, 18, "127781240307681585", -40},
  {8.1007145146644149242340159e-125, 14, "81007145146644", -124},
  {3.0769474477831709809428576e-272, 6, "307695", -271},
  {2.3337392648104012962638604e+298, 2, "23", 299},
  {7.1963973459054821720279487e+281, 18, "719639734590548217", 282},
  {1.6583008106846211417837017e+183, 2, "17", 184},
  {2.7482668159233672296193974e-220, 18, "274826681592336723", -219},
  {3.6665917888316955923467663e-242, 18, "366659178883169559", -241},
  {6.8856429223799021826042209e-35, 15, "68856429223799", -34},
  {8.0752092310443438012044633e-86, 16, "8075209231044344", -85},
  {4.8297783460411229458487807e-294, 12, "482977834604", -293},
  {4.7685757678915358560066566e+138, 8, "47685758", 139},
  {1.0166838639278861257825775e+223, 9, "101668386", 224},
  {8.0460722624941579993576222e+34, 12, "804607226249", 35},
  {2.2608807585907089046894724e-62, 20, "22608807585907089047", -61},
  {7.8694896494973508231546973e-228, 2, "79", -227},
  {7.8033691448247475046891900e+42, 6, "780337", 43},
  {5.3390154657537659520843384e-278, 9, "533901547", -277},
  {3.3364725814403216793684198e-250, 8, "33364726", -249},
  {3.1672801129673939280057074e+28, 13, "3167280112967", 29},
  {4.4430497159408782958984375e+10, 1, "4", 11},
  {1.5696972994191092657747562e-19, 7, "1569697", -18},
  {3.8988544969885307121321902e-118, 12, "389885449699", -117},
  {1.3610574607130642107222229e+04, 18, "136105746071306421", 5},
  {1.2536778254638624921323766e-270, 15, "125367782546386", -269},
  {1.5382662502944839312320600e-161, 4, "1538", -160},
  {3.1256785901940834944916848e+177, 21, "312567859019408349449", 178},
  {1.0957604666900938988137885e-138, 6, "109576", -137},
  {1.4276441001244279890889489e+240, 3, "143", 241},
  {4.6442600737780760593334729e-113, 15, "464426007377808", -112},
  {4.2537821156073156515075211e+155, 16, "4253782115607316", 156},
  {2.5333478288562853909481261e+292, 1, "3", 293},
  {3.5109257089087777564785798e+261, 17, "35109257089087778", 262},
  {1.9318641483632526516764272e-231, 9, "193186415", -230},
  {2.2059677910614122920331688e-54, 15, "220596779106141", -53},
  {8.2468661781180085512405802e+247, 18, "824686617811800855", 248},
  {3.5354409585212461194985668e-103, 19, "3535440958521246119", -102},
  {2.2882945768293003455634357e-239, 12, "228829457683", -238},
  {3.2499035531229773632537004e+202, 4, "325", 203},
  {9.2978857511885646856900026e-201, 10, "9297885751", -200},
  {1.1841321183203937168144765e-295, 2, "12", -294},
  {8.7143644151609502326708223e-48, 3, "871", -47},
  {6.2430694579646759708908267e+108, 2, "62", 109},
  {4.2437658011338608037277996e+130, 21, "424376580113386080373", 131},
  {3.1511253632559892726658517e-151, 8, "31511254", -150},
  {1.0978966724650881894807053e+160, 11, "10978966725", 161},
  {1.3085361088354267769211933e-79, 21, "130853610883542677692", -78},
  {9.7921074346914894187191486e+102, 8, "97921074", 103},
  {9.7628356561202871318012032e-235, 15, "976283565612029", -234},
  {1.2650489568911710937781277e+58, 8, "1265049", 59},
  {5.7373941654771749981514545e-272, 19, "5737394165477174998", -271},
  {1.2333740766269209314164456e+105, 19, "1233374076626920931", 106},
  {1.4730834592507677065002110e-22, 9, "147308346", -21},
  {2.4837765316210740242988747e-284, 20, "24837765316210740243", -283},
  {5.1574444231670256013773503e-297, 7, "5157444", -296},
  {7.6528300005494422444000581e-225, 19, "7652830000549442244", -224},
  {8.0332520660548280478970285e+140, 10, "8033252066", 141},
  {3.2832721666905993702385895e-270, 14, "32832721666906", -269},
  {1.3154060429368917669833748e+151, 11, "13154060429", 152},
  {1.8880377512537377688695133e-126, 12, "188803775125", -125},
  {3.8016151794406493875872923e-78, 18, "380161517944064939", -77},
  {1.4563765030474783397878449e-182, 5, "14564", -181},
  {6.1344850788589532344751962e-241, 4, "6134", -240},
  {7.7572605128555834886773699e-18, 14, "77572605128556", -17},
  {7.1128198835256101730418340e+193, 14, "71128198835256", 194},
  {2.3672020867236513719245039e-03, 5, "23672", -2},
  {1.1387133896309175252436465e+230, 21, "113871338963091752524", 231},
  {1.9666294805332133706264734e+259, 10, "1966629481", 260},
  {4.8781298007615543758179490e-139, 9, "48781298", -138},
  {2.1949318971248528286479081e+181, 7, "2194932", 182},
  {3.3869254415797774996835799e+289, 3, "339", 290},
  {3.7899899906724528720795246e+81, 11, "37899899907", 82},
  {2.1747074221016439788411959e-183, 4, "2175", -182},
  {1.1228034276019972024758688e-85, 20, "11228034276019972025", -84},
  {1.6204808363983390287676768e+114, 18, "162048083639833903", 115},
  {5.1443518356333381968927504e-38, 16, "5144351835633338", -37},
  {3.6035045767700660148361544e+189, 10, "3603504577", 190},
  {9.7348929634322195762941800e+140, 18, "973489296343221958", 141},
  {1.6066734473044796937536398e+78, 7, "1606673", 79},
  {4.4961945839199871082344900e+29, 5, "44962", 30},
  {5.7448780459989945423870950e-01, 15, "574487804599899", 0},
  {2.5589405788957613360056510e-34, 19, "2558940578895761336", -33},
  {2.3606243784028367965900711e+259, 18, "23606243784028368", 260},
  {6.3702992889874657331809026e+160, 15, "637029928898747", 161},
  {8.3347815322751268502762011e+64, 15, "833478153227513", 65},
  {3.4836051567467041007300158e-162, 13, "3483605156747", -161},
  {3.1976674815857410159691911e-128, 20, "3197667481585741016", -127},
  {1.2141161689586790354466442e+202, 15, "121411616895868", 203},
  {1.3596591694852906036015584e+33, 4, "136", 34},
  {3.1081767792631076000000000e+16, 11, "31081767793", 17},
  {1.5510413428897105820107557e+95, 13, "155104134289", 96},
  {1.5327392974722944664983851e+235, 7, "1532739", 236},
  {8.2102136517729428236966128e-21, 7, "8210214", -20},
  {5.7672964839507990676270473e+243, 11, "5767296484", 244},
  {1.6537306036286526766692167e+207, 2, "17", 208},
  {1.5523477539540005383413367e+247, 20, "15523477539540005383", 248},
  {3.6318837336779118128847416e-185, 2, "36", -184},
  {5.0620344337683594809806011e-196, 20, "5062034433768359481", -195},
  {1.6098872565617098548530235e+165, 15, "160988725656171", 166},
  {2.8312149173901669584892145e-224, 6, "283121", -223},
  {8.3359537874256931276338374e-105, 17, "83359537874256931", -104},
  {1.2598393361317974731633300e-157, 18, "125983933613179747", -156},
  {1.5057324033918092823738687e-250, 10, "1505732403", -249},
  {3.0692450390320015540061544e+63, 10, "3069245039", 64},
  {1.6325626036870374688762356e-186, 14, "1632562603687", -185},
  {4.5456090073571687915404197e+280, 13, "4545609007357", 281},
  {6.6858550268631104381520743e-209, 16, "668585502686311", -208},
  {4.6320395690827957625518281e+265, 10, "4632039569", 266},
  {2.2335268856469932477078861e-33, 1, "2", -32},
  {1.6943335206747497822314640e+135, 14, "16943335206747", 136},
  {1.1927459123923709349619017e-104, 8, "11927459", -103},
  {6.3011814056846458236935304e+148, 11, "63011814057", 149},
  {1.9759673382125479917743383e+46, 15, "197596733821255", 47},
  {1.7728994473756643943173800e+234, 5, "17729", 235},
  {1.2958461234180269552020355e-179, 6, "129585", -178},
  {2.1079440232159298861857261e+71, 9, "210794402", 72},
  {7.0351930143199260427015271e-87, 18, "703519301431992604", -86},
  {9.9501479945688743860484483e-302, 21, "995014799456887438605", -301},
  {6.1900013537493417594076508e-168, 10, "6190001354", -167},
  {4.1560068227200992602385072e+307, 18, "415600682272009926", 308},
  {1.7832179097333541371213777e-266, 19, "1783217909733354137", -265},
  {2.2286491693887388801310306e-28, 18, "222864916938873888", -27},
  {1.4407939183985940861316239e-62, 1, "1", -61},
  {3.5559237685208797858603138e-236, 10, "3555923769", -235},
  {3.5598191295210963273181605e+201, 8, "35598191", 202},
  {1.1931208293005423109456734e+91, 19, "1193120829300542311", 92},
  {7.9584456949144782577105059e+220, 15, "795844569491448", 221},
  {6.5631757217887783115250116e-236, 5, "65632", -235},
  {1.7708794177940330919403723e-42, 12, "177087941779", -41},
  {1.7606922882143158984558716e+201, 10, "1760692288", 202},
  {8.1515095919605251532137466e+223, 12, "815150959196", 224},
  {1.2565494226487016119214749e+240, 19, "1256549422648701612", 241},
  {5.1498864173320057441484800e+23, 9, "514988642", 24},
  {4.5100143054661980294774972e-63, 16, "4510014305466198", -62},
  {6.9030247475194506682683872e+106, 10, "6903024748", 107},
  {1.4357163330197780638988608e-129, 9, "143571633", -128},
  {5.2061293538513097995356502e+126, 5, "52061", 127},
  {1.7590285338757675089920000e+21, 1, "2", 22},
  {1.3513788731131049300935619e+109, 2, "14", 110},
  {1.2044322915731447480320000e+23, 8, "12044323", 24},
  {2.1986045499393487290262783e+01, 21, "219860454993934872903", 2},
  {1.5772137756101069008330728e-37, 11, "15772137756", -36},
  {5.3873447940868009907981130e+252, 7, "5387345", 253},
  {9.4733086856239556049576088e+141, 18, "94733086856239556", 142},
  {8.2737265974951601413993840e+148, 15, "827372659749516", 149},
  {3.1403870030080613400926156e-142, 4, "314", -141},
  {9.9929078576558459022830348e-250, 17, "99929078576558459", -249},
  {3.9634645975661031251212092e+44, 19, "3963464597566103125", 45},
  {9.0034789636314840636905490e+159, 1, "9", 160},
  {6.2021939016890236776915500e+117, 16, "6202193901689024", 118},
  {2.3937760382819726834280003e-65, 7, "2393776", -64},
  {7.7172757696061082843999151e+30, 9, "771727577", 31},
  {7.5987999359324585859412055e-303, 20, "75987999359324585859", -302},
  {4.4555455091321027831539356e-117, 19, "4455545509132102783", -116},
  {1.9887251695609960603709983e-77, 21, "198872516956099606037", -76},
  {3.6512151162972164181365579e+244, 11, "36512151163", 245},
  {1.4708804348437976579235128e+58, 4, "1471", 59},
  {1.0666911890569114041380555e+213, 6, "106669", 214},
  {5.6329469950829180097861236e+187, 16, "5632946995082918", 188},
  {1.9519730739527088737372474e+150, 7, "1951973", 151},
  {7.3153202080264277843503963e+30, 15, "731532020802643", 31},
  {5.7720699854419317435368755e+277, 17, "57720699854419317", 278},
  {8.4490827496051037613520573e-178, 11, "84490827496", -177},
  {2.0978092908493410162282826e-196, 21, "209780929084934101623", -195},
  {2.6787710739238912355832833e-99, 15, "267877107392389", -98},
  {1.9394817913570182823936000e+22, 10, "1939481791", 23},
  {6.0784630208710496684385181e+301, 21, "607846302087104966844", 302},
  {3.3551247016586131448351177e-287, 4, "3355", -286},
  {1.1601262138536526584687745e+242, 18, "116012621385365266", 243},
  {2.1249704612923038387456825e-301, 9, "212497046", -300},
  {8.9751693453158731894855396e+97, 20, "89751693453158731895", 98},
  {8.7824702117349861827045243e-07, 2, "88", -6},
  {5.6737649334397376120808694e+226, 12, "567376493344", 227},
  {1.4418953891548374482017343e-207, 19, "1441895389154837448", -206},
  {8.9636841161565316572906032e-270, 8, "89636841", -269},
  {2.0570136902060415229342993e-03, 4, "2057", -2},
  {4.2723709954058611366201762e-67, 8, "4272371", -66},
  {6.6953411340283633009687739e+165, 12, "669534113403", 166},
  {4.6344181092682883531696186e-154, 17, "46344181092682884", -153},
  {3.4357313325054828581696759e-211, 16, "3435731332505483", -210},
  {3.3752348498123793259961078e-283, 1, "3", -282},
  {1.2819675872284477291823017e-225, 13, "1281967587228", -224},
  {3.1657502610822403918928835e-181, 20, "31657502610822403919", -180},
  {8.7017090929930912743316239e-150, 12, "870170909299", -149},
  {5.4918980292130413410910776e+290, 16, "5491898029213041", 291},
  {2.8331494471053145346177067e-88, 1, "3", -87},
  {1.0251085815565961638640147e+03, 16, "1025108581556596", 4},
  {2.0487114046332932014264100e-86, 3, "205", -85},
  {1.7175460015309035930743799e-40, 3, "172", -39},
  {6.2255245821873035808130312e-271, 9, "622552458", -270},
  {1.0441149116732157415243300e-224, 7, "1044115", -223},
  {8.9773322026301440847472724e-157, 18, "897733220263014408", -156},
  {2.5516701194226733626163200e+23, 3, "255", 24},
  {2.3336962994006253767495435e+279, 18, "233369629940062538", 280},
  {3.2165206094239029432912957e+00, 4, "3217", 1},
  {5.5657711977991976910682679e+199, 17, "55657711977991977", 200},
  {1.1935918101727717184716321e+262, 21, "119359181017277171847", 263},
  {6.7423675748105844258111833e-16, 10, "6742367575", -15},
  {2.9265326949716966133279941e-24, 20, "29265326949716966133", -23},
  {9.3339514419603691633055802e-219, 21, "933395144196036916331", -218},
  {4.0917942694547620921040418e+199, 8, "40917943", 200},
  {5.7517630721586370835356356e-23, 4, "5752", -22},
  {6.6460498874833165585163467e-40, 6, "664605", -39},
  {3.0737655340973110951350466e-130, 11, "30737655341", -129},
  {4.2214802812818392649852688e-116, 9, "422148028", -115},
  {1.4635470273106347036376387e+166, 14, "14635470273106", 167},
  {1.4918783410636168451677444e+107, 12, "149187834106", 108},
  {1.0058819792775655290679555e+305, 6, "100588", 306},
  {6.8893468706158471082840992e+69, 19, "6889346870615847108", 70},
  {7.5656651419167568955031536e-170, 2, "76", -169},
  {2.5324607601507103991176650e-161, 13, "2532460760151", -160},
  {2.9259693073459984132746667e-276, 14, "2925969307346", -275},
  {3.4692392665529091992974026e+146, 3, "347", 147},
  {2.5623807985017848908066121e-143, 19, "2562380798501784891", -142},
  {2.0087063244274337193928659e+05, 20, "20087063244274337194", 6},
  {1.4680696684095799292211700e-298, 11, "14680696684", -297},
  {1.0233722293835200077193332e-209, 11, "10233722294", -208},
  {5.5548297367891552534582783e+213, 19, "5554829736789155253", 214},
  {6.5178825101511956738665897e+134, 20, "65178825101511956739", 135},
  {3.5098466740503136204413804e-137, 2, "35", -136},
  {2.4267185372457401184364674e-73, 16, "242671853724574", -72},
  {3.1303834379011642528910127e+190, 11, "31303834379", 191},
  {1.3196611907946285060355475e+290, 13, "1319661190795", 291},
  {4.0502006263231763147569280e-271, 4, "405", -270},
  {1.4583410614028022911962473e-242, 11, "14583410614", -241},
  {3.4690527995051602468408004e-307, 14, "34690527995052", -306},
  {8.8717477006311992329942941e-30, 20, "8871747700631199233", -29},
  {1.6988822955581871048146173e-38, 12, "169888229556", -37},
  {1.8423117578362940713398867e-301, 3, "184", -300},
  {7.2559368363098288370882649e-03, 13, "725593683631", -2},
  {9.5871895359073173049571682e-86, 19, "9587189535907317305", -85},
  {3.4798361825928594635953151e+199, 13, "3479836182593", 200},
  {2.9652624665275360079900469e+125, 2, "3", 126},
  {1.3773611133007418203779726e+152, 3, "138", 153},
  {8.1112465470090233548948414e-79, 20, "81112465470090233549", -78},
  {1.0360216682158292881201678e+241, 6, "103602", 242},
  {5.7163361119361255677430573e-195, 9, "571633611", -194},
  {5.8116021528964167413727187e-84, 21, "581160215289641674137", -83},
  {7.8950239041240482668383510e+240, 16, "7895023904124048", 241},
  {6.4568451607212382627042910e+221, 18, "645684516072123826", 222},
  {9.9743374306523915872702679e+227, 9, "997433743", 228},
  {1.5134936882008317570889693e-12, 19, "1513493688200831757", -11},
  {4.1981705350263102929569216e-281, 2, "42", -280},
  {4.2260852272573728331968762e-290, 17, "42260852272573728", -289},
  {1.1861514620604324532846908e+215, 5, "11862", 216},
  {1.7166107228639361113767032e-115, 15, "171661072286394", -114},
  {2.8914917450863306841668004e+155, 16, "2891491745086331", 156},
  {1.3408175913767106918301186e+73, 16, "1340817591376711", 74},
  {3.4396117550821661028737659e+188, 17, "34396117550821661", 189},
  {1.0415648872062898170203243e-128, 10, "1041564887", -127},
  {1.0547210733854926953278509e-249, 6, "105472", -248},
  {8.8883478133657345460804268e-247, 21, "888834781336573454608", -246},
  {2.9564980687683923643014812e+250, 10, "2956498069", 251},
  {2.3252960311373213647212952e+206, 12, "232529603114", 207},
  {2.6350767762982591986656189e+08, 2, "26", 9},
  {5.4076263028743722682229128e+188, 1, "5", 189},
  {1.2422506157533239415012638e+262, 17, "12422506157533239", 263},
  {1.6248818841517041690861967e-99, 2, "16", -98},
  {4.4913028565131862636822550e+78, 4, "4491", 79},
  {4.7633508086916589567664989e+189, 3, "476", 190},
  {5.1924853108089268552173040e+29, 3, "519", 30},
  {3.0929844717648522724967838e-87, 1, "3", -86},
  {6.6130598573757267775880478e+221, 21, "661305985737572677759", 222},
  {1.8779292816759003575091040e-216, 7, "1877929", -215},
  {2.6147452496672350346144371e-120, 19, "2614745249667235035", -119},
  {1.0206207199946063492365458e+247, 18, "102062071999460635", 248},
  {2.7935905863635858588997842e+124, 10, "2793590586", 125},
  {3.2299215113772988843265921e+03, 4, "323", 4},
  {8.6261346067569500269254811e+83, 18, "862613460675695003", 84},
  {7.5750680202572201984000000e+19, 16, "757506802025722", 20},
  {2.7143578891909918908866418e+188, 13, "2714357889191", 189},
  {1.8866228862888070269423004e-118, 18, "188662288628880703", -117},
  {4.9091614007406276070008818e+95, 18, "490916140074062761", 96},
  {6.9543123288179024260811640e-26, 5, "69543", -25},
  {3.1887675543681841444439065e+89, 7, "3188768", 90},
  {2.1206520221713098326787118e-09, 10, "2120652022", -8},
  {6.3669128702827734375000000e+12, 10, "636691287", 13},
  {6.1707739108002906589477143e-05, 12, "61707739108", -4},
  {2.3592670763509854744739573e-66, 2, "24", -65},
  {3.1275541681605338726400000e+20, 6, "312755", 21},
  {2.4138307086180591501550602e+165, 4, "2414", 166},
  {5.7167097254016851682006992e-23, 4, "5717", -22},
  {1.1982758618359684867729396e+98, 20, "11982758618359684868", 99},
  {1.2138115194413185038858899e-29, 13, "1213811519441", -28},
  {1.5592034762939979346930762e-230, 8, "15592035", -229},
  {3.4814337647861383437734133e+103, 9, "348143376", 104},
  {3.5662165969373868392722216e+03, 21, "356621659693738683927", 4},
  {4.5376279446120608765651711e-05, 4, "4538", -4},
  {2.7323215046720606315989076e-278, 10, "2732321505", -277},
  {1.4996073694667177570664488e-269, 19, "1499607369466717757", -268},
  {2.8522359775399934533793815e-147, 15, "285223597753999", -146},
  {1.2471095351667324115748189e-262, 14, "12471095351667", -261},
  {7.7579063609524145842744506e+220, 2, "78", 221},
  {1.2446069901171497070108628e-93, 16, "124460699011715", -92},
  {1.7984531738910462092961775e+217, 9, "179845317", 218},
  {3.4452124007404892305896020e+212, 16, "3445212400740489", 213},
  {2.4449136993988594567996082e+120, 18, "244491369939885946", 121},
  {8.1101593627576662019922345e+128, 1, "8", 129},
  {4.2278020342914370668076246e-178, 10, "4227802034", -177},
  {5.3917597458697285998873754e+154, 5, "53918", 155},
  {4.9229607478841243341612147e-182, 16, "4922960747884124", -181},
  {4.5778127003217593029730751e+55, 21, "457781270032175930297", 56},
  {1.1177772155177893933620032e-276, 3, "112", -275},
  {7.2254393617949647615842285e-205, 1, "7", -204},
  {1.1303229481070286590109141e-72, 12, "113032294811", -71},
  {5.9169233525835290215531141e-304, 3, "592", -303},
  {1.4604055735428688002682880e-67, 6, "146041", -66},
  {2.9808041721015507353600000e+20, 10, "2980804172", 21},
  {2.0951327419291150001968171e-190, 10, "2095132742", -189},
  {1.3082949134518801873887145e-51, 10, "1308294913", -50},
  {8.9233011462742761171592476e+144, 12, "892330114627", 145},
  {1.3381152673081938817169321e+155, 20, "13381152673081938817", 156},
  {5.0840978571557260867857400e-263, 9, "508409786", -262},
  {4.4095795596115996285362267e-201, 8, "44095796", -200},
  {9.9580847739165862687098733e-256, 17, "99580847739165863", -255},
  {3.6766884878285545950761174e+240, 11, "36766884878", 241},
  {3.0903510819066485469426355e-176, 5, "30904", -175},
  {9.8478450693017605557738233e+176, 12, "98478450693", 177},
  {2.2587647897951042068598326e+03, 15, "22587647897951", 4},
  {2.5927889994059390044048693e+49, 14, "25927889994059", 50},
  {1.2369754223780901017772887e-266, 2, "12", -265},
  {2.6473288790588162383367015e-221, 17, "26473288790588162", -220},
  {9.1270629955772191775411656e-58, 1, "9", -57},
  {1.4195345236924001352526488e-145, 18, "141953452369240014", -144},
  {2.6452065600222226194823711e-76, 2, "26", -75},
  {5.2224119169287490637844728e-270, 8, "52224119", -269},
  {2.7227587521932498471360086e+177, 16, "272275875219325", 178},
  {7.6460672268889340228321443e-11, 20, "76460672268889340228", -10},
  {1.8663327553020726163408215e+108, 6, "186633", 109},
  {1.8782528057544041024203939e-38, 3, "188", -37},
  {7.0323432684066866594514189e-167, 6, "703234", -166},
  {4.0603689118043419375742092e-127, 7, "4060369", -126},
  {1.3410555439239686826675186e-180, 14, "1341055543924", -179},
  {3.6313732613195154825512161e-83, 11, "36313732613", -82},
  {1.3410661479721221674228744e+213, 10, "1341066148", 214},
  {1.5849919564597628607700830e+254, 19, "1584991956459762861", 255},
  {4.5652394423380150552048864e-280, 11, "45652394423", -279},
  {2.1802487229440169248248814e-219, 5, "21802", -218},
  {1.1110693188781908247619867e+04, 8, "11110693", 5},
  {1.4122918765102726998095653e-102, 17, "14122918765102727", -101},
  {3.0854354900402099469965742e-139, 12, "308543549004", -138},
  {3.8665526963724329741187860e+184, 17, "3866552696372433", 185},
  {1.7381670956955405921201103e-126, 10, "1738167096", -125},
  {1.5367073654014651118986307e+202, 5, "15367", 203},
  {5.4781660000722948806740366e-195, 1, "5", -194},
  {1.6358081268936136355763619e-131, 19, "1635808126893613636", -130},
  {6.5520990595801276945954932e+33, 5, "65521", 34},
  {1.5177192066811474100223699e-232, 14, "15177192066811", -231},
  {3.9207057844763505782890543e-277, 16, "3920705784476351", -276},
  {9.9212454884332781242183532e-125, 14, "99212454884333", -124},
  {6.1917425663330451179514630e+269, 12, "619174256633", 270},
  {1.6794760868087756184063500e-266, 5, "16795", -265},
  {4.8141905163516415865192182e-105, 3, "481", -104},
  {2.2796889598190667663541426e-58, 12, "227968895982", -57},
  {1.9727363554927568071600928e-155, 5, "19727", -154},
  {3.4733005646377796550178545e+37, 4, "3473", 38},
  {5.3678350757665439747601017e-75, 18, "536783507576654397", -74},
  {3.5493121694250849155243631e-113, 15, "354931216942508", -112},
  {1.1297346291335308822597801e-165, 6, "112973", -164},
  {1.4394290432140816029691597e-177, 8, "1439429", -176},
  {9.8100264391279196342675185e-12, 8, "98100264", -11},
  {1.9932530581976004267472026e-218, 1, "2", -217},
  {2.4917075336725168220093576e-156, 5, "24917", -155},
  {1.8156982760318734592136772e-231, 15, "181569827603187", -230},
  {3.6646019451086267942185344e+114, 12, "366460194511", 115},
  {3.9664763262276267230635664e-84, 1, "4", -83},
  {2.0573668261352608802982124e+192, 20, "20573668261352608803", 193},
  {1.3072852523019859612956285e+153, 16, "1307285252301986", 154},
  {9.2581729681002731743236147e-29, 17, "92581729681002732", -28},
  {1.8373416344655326009601673e+180, 18, "18373416344655326", 181},
  {1.3164257231099805306812843e+92, 3, "132", 93},
  {4.6998528606034191824247846e-181, 2, "47", -180},
  {6.4354275028298177576670236e+143, 17, "64354275028298178", 144},
  {3.2183312922916996905197665e-187, 1, "3", -186},
  {3.9588773319330309435892801e-03, 12, "395887733193", -2},
  {9.3222159036868755402238581e-56, 8, "93222159", -55},
  {2.5240148058208619388132887e+252, 1, "3", 253},
  {6.8389184817821215497097974e+108, 12, "683891848178", 109},
  {1.2882309549388353742323302e-92, 19, "1288230954938835374", -91},
  {6.8265302707188359431594690e+272, 4, "6827", 273},
  {2.9740467957301461154113623e-297, 6, "297405", -296},
  {2.3518756877990975697259349e+79, 19, "235187568779909757", 80},
  {1.3309379058697474143326165e+109, 21, "133093790586974741433", 110},
  {4.0521926932533159555071908e+65, 19, "4052192693253315956", 66},
  {4.9439254202528538905264372e-268, 21, "494392542025285389053", -267},
  {2.7566802627406588605936341e-201, 16, "2756680262740659", -200},
  {2.0698861492021331477535718e+65, 11, "20698861492", 66},
  {3.5958586827407634657718131e-275, 15, "359585868274076", -274},
  {5.3808130933371321041252571e+237, 18, "53808130933371321", 238},
  {2.1337765314456696464695661e+146, 18, "213377653144566965", 147},
  {4.0893583883140650987732151e+277, 2, "41", 278},
  {3.2392797656761110872922014e+73, 17, "32392797656761111", 74},
  {1.9942912006967984938898885e-187, 7, "1994291", -186},
  {1.6734401039444199970468666e-137, 5, "16734", -136},
  {2.8621264371789512236594650e+166, 16, "2862126437178951", 167},
  {1.8420619351998408366838153e-26, 19, "1842061935199840837", -25},
  {2.3254409071866905196541912e-211, 6, "232544", -210},
  {7.7431827663430884844235411e-88, 7, "7743183", -87},
  {1.9903489189145028370618803e-209, 16, "1990348918914503", -208},
  {1.5886488633479936599731445e+10, 11, "15886488633", 11},
  {1.0672873600088188889329539e+232, 3, "107", 233},
  {1.4597240875100663610159553e+103, 18, "145972408751006636", 104},
  {2.1872201367241216916256491e-40, 12, "218722013672", -39},
  {2.2171402848022557270512520e-255, 10, "2217140285", -254},
  {7.7668982575411115381631522e-286, 15, "776689825754111", -285},
  {8.2860387009287816990683975e+90, 14, "82860387009288", 91},
  {9.5042678784265297302993342e+276, 11, "95042678784", 277},
  {1.3659788625996805230372946e-186, 19, "1365978862599680523", -185},
  {2.8281437598103264452064579e-161, 2, "28", -160},
  {4.6156260262787039076133958e-48, 12, "461562602628", -47},
  {2.3089266782845136897436023e-286, 9, "230892668", -285},
  {1.1454691438500123303914767e-274, 18, "114546914385001233", -273},
  {1.9839678569665915377644256e+91, 12, "198396785697", 92},
  {2.1806365744255640377880784e-284, 2, "22", -283},
  {9.6762170258887867095493321e+232, 19, "967621702588878671", 233},
  {8.1398683955868928851941786e+26, 7, "8139868", 27},
  {4.0206157119515445106053465e-224, 7, "4020616", -223},
  {2.2897026396143563880284107e-24, 13, "2289702639614", -23},
  {9.4928473959031400286104239e+195, 12, "94928473959", 196},
  {5.2175291375816616191792775e+28, 4, "5218", 29},
  {1.9128102058111784684606838e+139, 11, "19128102058", 140},
  {6.5685886426553223649970939e+78, 11, "65685886427", 79},
  {2.2076673991538927506017236e-138, 12, "220766739915", -137},
  {7.6027506260919007220987493e+245, 10, "7602750626", 246},
  {3.4136814808712049453327027e-227, 8, "34136815", -226},
  {1.2272491880010324358254540e-177, 19, "1227249188001032436", -176},
  {4.5056047013834669755585090e+269, 21, "450560470138346697556", 270},
  {4.9812244620639055299918281e-136, 2, "5", -135},
  {1.8913121174243094925219139e+247, 3, "189", 248},
  {2.3501586982011404135992539e+268, 16, "235015869820114", 269},
  {4.1545713759241593317404549e+186, 6, "415457", 187},
  {1.4394039665972134400000000e+17, 10, "1439403967", 18},
  {1.1641266056461338367701258e-255, 16, "1164126605646134", -254},
  {5.6547859518756370055740886e-73, 4, "5655", -72},
  {2.8716224778361432019299583e-65, 7, "2871622", -64},
  {3.8977312880712078962192847e-65, 19, "3897731288071207896", -64},
  {3.5042727188203693882996341e+194, 13, "350427271882", 195},
  {1.1535780619409666481240146e+27, 19, "1153578061940966648", 28},
  {2.6183037263772735139963750e-158, 9, "261830373", -157},
  {1.2147501764425476024500172e-178, 6, "121475", -177},
  {1.8612963628093369538751904e+102, 16, "1861296362809337", 103},
  {2.3495565495354541107667775e+275, 3, "235", 276},
  {1.9912216478742430428698228e-69, 7, "1991222", -68},
  {1.4797493987990430561830707e-65, 5, "14797", -64},
  {3.2292320506966505150218240e+25, 5, "32292", 26},
  {1.2763250308017357066504967e-94, 18, "127632503080173571", -93},
  {3.7367557905767876349174242e+199, 9, "373675579", 200},
  {1.4285193417423030675963909e+100, 5, "14285", 101},
  {1.6509739612199571191223215e+183, 13, "165097396122", 184},
  {5.2661376896010860443907165e-87, 20, "52661376896010860444", -86},
  {1.3256882390729271666888613e-171, 18, "132568823907292717", -170},
  {5.7810196393925522801653682e-192, 1, "6", -191},
  {6.4538368743625960267910947e+84, 7, "6453837", 85},
  {2.1073181891283715607275260e-266, 15, "210731818912837", -265},
  {3.0565235897583778638431423e-141, 20, "30565235897583778638", -140},
  {1.5089482167725801564737037e-219, 14, "15089482167726", -218},
  {1.0659178977643722318076557e-32, 10, "1065917898", -31},
  {6.7784519123335781434891491e-84, 8, "67784519", -83},
  {1.3439859854557299832274249e-116, 6, "134399", -115},
  {4.2635619858617378234863281e+10, 5, "42636", 11},
  {1.0667477475179320049894527e-86, 6, "106675", -85},
  {2.4762366605337861209415733e+237, 4, "2476", 238},
  {3.5302508208358648538056640e+44, 3, "353", 45},
  {1.7433886620244103241375842e-242, 12, "174338866202", -241},
  {5.6370362361889120266904698e-146, 20, "56370362361889120267", -145},
  {8.8043539378826538690921141e+146, 17, "88043539378826539", 147},
  {1.5850012679655537234632184e+290, 20, "15850012679655537235", 291},
  {1.2180954961337775270874468e-07, 10, "1218095496", -6},
  {1.7847502366691977803578838e-168, 19, "178475023666919778", -167},
  {4.3102404936877864914418486e-103, 2, "43", -102},
  {7.7855571031648546905310720e-79, 3, "779", -78},
  {1.6134263885424847024327790e-211, 8, "16134264", -210},
  {4.8006332796377587657232766e-01, 6, "480063", 0},
  {5.5734840579941384092540954e+99, 12, "557348405799", 100},
  {1.1239100233124003952943871e+72, 20, "11239100233124003953", 73},
  {7.7355028655228891481032046e+227, 8, "77355029", 228},
  {2.4961961771744519820066622e+51, 1, "2", 52},
  {1.6055148208301655707687401e+122, 16, "1605514820830166", 123},
  {2.3450082012100198950856405e+52, 14, "234500820121", 53},
  {9.7026513884167874431515261e-163, 21, "970265138841678744315", -162},
  {2.0026083154340062367280930e+131, 19, "2002608315434006237", 132},
  {1.6012280144170173022878654e-218, 10, "1601228014", -217},
  {7.3492611802511268033786336e+238, 8, "73492612", 239},
  {7.1676856134080847409733041e+303, 18, "716768561340808474", 304},
  {4.2660082302836360069431720e+173, 19, "4266008230283636007", 174},
  {6.5058590444677351221626979e+187, 15, "650585904446774", 188},
  {1.5128180250699564763290993e-304, 19, "1512818025069956476", -303},
  {4.7729822350924442135601841e+259, 16, "4772982235092444", 260},
  {2.9121569551041007700019958e-308, 16, "2912156955104101", -307},
  {7.8265416657288081983970944e-137, 8, "78265417", -136},
  {6.5291875967727443456400323e+103, 16, "6529187596772744", 104},
  {2.5527413124239463661459907e+213, 6, "255274", 214},
  {1.2662675534690759828333749e-196, 5, "12663", -195},
  {4.1808174066288545407237289e+223, 20, "41808174066288545407", 224},
  {3.8120451064318719738343425e+188, 18, "381204510643187197", 189},
  {5.4825498821256205215788860e+149, 20, "54825498821256205216", 150},
  {1.5854987385719532496026827e+55, 20, "15854987385719532496", 56},
  {5.1349474425198263711233762e+185, 11, "51349474425", 186},
  {1.8491853162469553539320039e+65, 20, "18491853162469553539", 66},
  {3.3541080719708572507151319e+100, 20, "33541080719708572507", 101},
  {4.0423539473968823398049549e-103, 4, "4042", -102},
  {8.8990884298920874796987808e+204, 6, "889909", 205},
  {1.0535116362173989663766957e+220, 2, "11", 221},
  {1.0658054185770232411835396e+176, 10, "1065805419", 177},
  {2.3655692739692275042814971e-45, 3, "237", -44},
  {8.6758623265697817251887291e+89, 18, "867586232656978173", 90},
  {2.1526682422338468331852264e-260, 17, "21526682422338468", -259},
  {5.7591688672900219156076966e+98, 16, "5759168867290022", 99},
  {3.3330543883460172330264561e-298, 13, "3333054388346", -297},
  {5.1256380869666702334340765e+216, 19, "5125638086966670233", 217},
  {1.3801704330889428549553690e-207, 18, "138017043308894285", -206},
  {6.2032474192356206476688385e+06, 21, "620324741923562064767", 7},
  {1.8531938518921347656250000e+13, 8, "18531939", 14},
  {6.2866953643937716135670175e+49, 1, "6", 50},
  {1.4961154863645280137170451e-171, 21, "149611548636452801372", -170},
  {4.4679068087654087831349224e-254, 21, "446790680876540878313", -253},
  {3.8732618616369651009292906e+298, 20, "38732618616369651009", 299},
  {9.3871386790625261663771416e-32, 5, "93871", -31},
  {1.4215774557611895844586763e-157, 5, "14216", -156},
  {1.7529220029590016973715385e-236, 1, "2", -235},
  {5.0482572142178990932993111e+74, 1, "5", 75},
  {3.6308821251612916725539574e+223, 6, "363088", 224},
  {3.4627857908840071510585654e+141, 9, "346278579", 142},
  {3.0904875302141266564226122e-291, 17, "30904875302141267", -290},
  {1.6033591398210398012423868e+183, 5, "16034", 184},
  {8.3494404860527849192210133e+232, 15, "834944048605278", 233},
  {1.6628031944471827803394472e-100, 3, "166", -99},
  {3.4478146050271818678235554e+226, 20, "34478146050271818678", 227},
  {2.4263662393614335464490075e-269, 4, "2426", -268},
  {1.6838974193057621440514275e-188, 3, "168", -187},
  {4.4427397261635411013977068e+118, 1, "4", 119},
  {2.2263898495207426402072218e-51, 17, "22263898495207426", -50},
  {3.3041061202467288019218454e+223, 20, "33041061202467288019", 224},
  {9.7985433794116149730354748e-10, 1, "1", -8},
  {6.2840998625656830887942853e-128, 12, "628409986257", -127},
  {9.9322201098609891411692664e-229, 20, "99322201098609891412", -228},
  {8.4962252300951719875227881e-146, 1, "8", -145},
  {4.6867543637241733830410240e+24, 17, "46867543637241734", 25},
  {1.2704481916977656549306182e-132, 3, "127", -131},
  {6.1508007674248121141069548e+69, 9, "615080077", 70},
  {1.9675341751646834975447640e-82, 14, "19675341751647", -81},
  {1.2921313340291141627386980e-92, 21, "129213133402911416274", -91},
  {2.8756942877101935674991313e-09, 14, "28756942877102", -8},
  {2.0069034577274684301482408e-225, 14, "20069034577275", -224},
  {5.7720069862799095933308633e+44, 11, "57720069863", 45},
  {4.8987432109064308210143885e+164, 2, "49", 165},
  {8.6943426414104767519567751e+78, 8, "86943426", 79},
  {1.6927476502241516475329419e+302, 14, "16927476502242", 303},
  {1.1384893272050392388264436e-203, 12, "113848932721", -202},
  {7.9050983543319321274132780e+307, 19, "7905098354331932127", 308},
  {2.4787966265046455414346700e+250, 14, "24787966265046", 251},
  {9.3587798900375957257694913e+157, 13, "9358779890038", 158},
  {4.6836828465829841928957967e+103, 15, "468368284658298", 104},
  {4.7322838387695403434133901e+303, 15, "473228383876954", 304},
  {4.2508332995520581617141760e+221, 3, "425", 222},
  {4.2669189129205733326644268e-171, 19, "4266918912920573333", -170},
  {1.9994662800084072474571585e-261, 14, "19994662800084", -260},
  {1.1588199719203586412849209e-177, 6, "115882", -176},
  {3.6477628023981895771839278e+185, 9, "36477628", 186},
  {1.3991884777473480527898076e-76, 7, "1399188", -75},
  {9.2849161481215816962062190e-281, 12, "928491614812", -280},
  {1.6567546779791943083734335e+211, 20, "16567546779791943084", 212},
  {1.8064799152874600328826379e+249, 8, "18064799", 250},
  {5.1592279992597722604522112e-217, 1, "5", -216},
  {7.3577057825770826827829967e-284, 21, "735770578257708268278", -283},
  {5.4013347424370063509037882e-109, 2, "54", -108},
  {6.4914870202985920545149740e+136, 8, "6491487", 137},
  {1.0689817419730833101028429e-23, 6, "106898", -22},
  {6.0906633983422949624795776e-39, 19, "6090663398342294962", -38},
  {2.1340868810214152282772762e+128, 19, "2134086881021415228", 129},
  {2.0385541336798732879367586e+176, 16, "2038554133679873", 177},
  {2.2115540214600808015004103e-159, 19, "2211554021460080802", -158},
  {6.9363354165248201603456762e+46, 5, "69363", 47},
  {3.1715014436024708197860164e+266, 11, "31715014436", 267},
  {3.7271128551602982722504317e-195, 17, "37271128551602983", -194},
  {2.2174239179043302799616907e+145, 3, "222", 146},
  {8.0606936868871458852271317e+55, 6, "806069", 56},
  {3.8706129811494522932520448e+282, 15, "387061298114945", 283},
  {9.4630322163981196800000000e+17, 6, "946303", 18},
  {1.5520165575797293821870121e+145, 20, "15520165575797293822", 146},
  {2.2584457568720897693429306e+71, 21, "225844575687208976934", 72},
  {1.2991152406116681037893496e+181, 1, "1", 182},
  {1.8056924121387507452903554e+236, 9, "180569241", 237},
  {1.2935001724866349434553576e-291, 2, "13", -290},
  {6.1045639702987120640000000e+19, 21, "6104563970298712064", 20},
  {1.8712124282157525447868976e-90, 11, "18712124282", -89},
  {1.6957664703825163150366023e+34, 21, "169576647038251631504", 35},
  {4.3355704299314299568354300e+307, 5, "43356", 308},
  {5.0145844757545228609966675e+38, 9, "501458448", 39},
  {1.2022749326883550617151041e-234, 21, "120227493268835506172", -233},
  {1.4671078672886466670647638e-88, 21, "146710786728864666706", -87},
  {2.6472640202250355771819963e+254, 13, "2647264020225", 255},
  {1.5652524056479439360000000e+18, 19, "1565252405647943936", 19},
  {1.2414991638104803310298524e-194, 21, "124149916381048033103", -193},
  {1.1788967610526076174227295e+215, 19, "1178896761052607617", 216},
  {1.2152830274244637764320199e-254, 5, "12153", -253},
  {3.6799973998384944945318937e-290, 8, "36799974", -289},
  {4.1547349880961955082816224e+246, 9, "415473499", 247},
  {2.2878223482604120024456306e+152, 1, "2", 153},
  {2.8526169457212683799871471e+172, 16, "2852616945721268", 173},
  {3.2970541432147989269196842e+01, 9, "329705414", 2},
  {2.6122740907096172680753052e+112, 20, "26122740907096172681", 113},
  {3.6332175908500748856728639e-142, 19, "3633217590850074886", -141},
  {7.1240304611355505027771696e-86, 2, "71", -85},
  {1.2753025854585630968639708e-207, 14, "12753025854586", -206},
  {1.6003192571370250905865749e+35, 5, "16003", 36},
  {9.2216330885038639371363148e+139, 18, "922163308850386394", 140},
  {1.4826816907763774263854625e-09, 18, "148268169077637743", -8},
  {2.9046235906478415826304472e-210, 8, "29046236", -209},
  {6.1549610490391240717628295e+196, 10, "6154961049", 197},
  {3.9078974527860734495218058e+255, 9, "390789745", 256},
  {1.3242591683174234467742914e-172, 11, "13242591683", -171},
  {3.0407005802051718125577433e-24, 20, "30407005802051718126", -23},
  {5.6344691756706914863217740e-191, 7, "5634469", -190},
  {3.7148048033555106813956791e-276, 15, "371480480335551", -275},
  {1.8625069023703548439971915e-134, 16, "1862506902370355", -133},
  {1.1011760109336723750000000e+15, 7, "1101176", 16},
  {4.5236681838655576023446037e-05, 14, "45236681838656", -4},
  {1.3639877353966677769896334e-15, 18, "136398773539666778", -14},
  {2.2363113049120070337101791e+290, 18, "223631130491200703", 291},
  {3.4685492834834199995103146e-182, 19, "346854928348342", -181},
  {1.1764494784409440374496593e+203, 14, "11764494784409", 204},
  {3.9305684663213459113357091e-234, 5, "39306", -233},
  {6.2770119744705060710082670e-119, 19, "6277011974470506071", -118},
  {7.6680263668149937864233399e-72, 19, "7668026366814993786", -71},
  {1.9071948551327237939207522e-228, 14, "19071948551327", -227},
  {3.5390182738109250386472569e-183, 10, "3539018274", -182},
  {1.5879029586911620290502451e-237, 12, "158790295869", -236},
  {1.3545965945803287878603387e+144, 17, "13545965945803288", 145},
  {7.0338758358488496921736543e-168, 17, "70338758358488497", -167},
  {7.8147213643422856105865731e-48, 18, "781472136434228561", -47},
  {5.4091881042163155463180684e-56, 17, "54091881042163155", -55},
  {6.0658194812339985419591147e+109, 5, "60658", 110},
  {5.9034316514630998400924023e-163, 13, "5903431651463", -162},
  {6.1424051586587437501222475e+156, 20, "61424051586587437501", 157},
  {2.6488097514521847895212109e-11, 14, "26488097514522", -10},
  {1.6374054870848951986171044e-173, 18, "16374054870848952", -172},
  {7.3283418166104553315738316e-136, 3, "733", -135},
  {4.6563639598718459295010747e-54, 7, "4656364", -53},
  {5.4606036557040258153719159e-196, 16, "5460603655704026", -195},
  {1.5916695834088293859255106e+212, 13, "1591669583409", 213},
  {7.2310368515070531346851142e+186, 8, "72310369", 187},
  {5.5736063552043640604974968e+237, 4, "5574", 238},
  {2.8814115840056345433854171e-91, 16, "2881411584005635", -90},
  {1.0883906761056417560725928e-37, 12, "108839067611", -36},
  {1.5713332774919098454750613e-111, 19, "1571333277491909845", -110},
  {4.6886122020976607989535445e+158, 6, "468861", 159},
  {1.6251199673680003164220419e-41, 5, "16251", -40},
  {7.3918112935453504335075554e+168, 16, "739181129354535", 169},
  {1.1377330000400771512062648e+94, 3, "114", 95},
  {4.1502063618258998789877006e-280, 11, "41502063618", -279},
  {1.8035228678455499386437009e+108, 19, "1803522867845549939", 109},
  {2.7576326377322786318934975e-298, 6, "275763", -297},
  {3.0467938585683660327699345e-106, 9, "304679386", -105},
  {3.6115265769686102118660177e-117, 15, "361152657696861", -116},
  {2.1083946442340570972448064e-218, 17, "21083946442340571", -217},
  {2.4391194782176443614557196e+204, 15, "243911947821764", 205},
  {9.6971861758723455404882474e+233, 12, "969718617587", 234},
  {4.3399830615928231779221766e-48, 19, "4339983061592823178", -47},
  {1.8079635345133107626688298e+86, 6, "180796", 87},
  {9.0410502261197072268051921e+282, 6, "904105", 283},
  {3.1117856440101940874547363e+258, 7, "3111786", 259},
  {5.9613757387436378613804740e+83, 19, "5961375738743637861", 84},
  {3.6425071839667297705162177e-204, 20, "36425071839667297705", -203},
  {7.6140274810714032629426432e-275, 5, "7614", -274},
  {8.6283677350806955764696268e-15, 14, "86283677350807", -14},
  {1.5701131904631674467287699e-265, 9, "157011319", -264},
  {6.1648017120538968780933008e+299, 11, "61648017121", 300},
  {1.2533675888340860609406485e+122, 9, "125336759", 123},
  {4.8625346238214152792165366e-287, 16, "4862534623821415", -286},
  {6.5502425390576266662649665e-182, 3, "655", -181},
  {5.9924864153059318616439782e-111, 18, "599248641530593186", -110},
  {1.5235321239647970448701605e-101, 15, "15235321239648", -100},
  {1.0722521557856803139771649e+256, 5, "10723", 257},
  {1.7954095495533479256013868e-274, 18, "179540954955334793", -273},
  {5.7022128232548108131228970e-16, 12, "570221282325", -15},
  {3.4994536164219800755293232e+270, 20, "34994536164219800755", 271},
  {1.2700868590591383685127806e-233, 19, "1270086859059138369", -232},
  {2.6962409170750758440637349e+82, 19, "2696240917075075844", 83},
  {2.8800919950488463151841341e-48, 13, "2880091995049", -47},
  {4.1210287186375532664391685e+144, 13, "4121028718638", 145},
  {9.8968086116612590762509263e-155, 4, "9897", -154},
  {3.5295000223263312283657393e+41, 4, "353", 42},
  {1.1791379103757625615928716e-80, 11, "11791379104", -79},
  {2.3797748050340018870015745e-293, 7, "2379775", -292},
  {1.3676259081238883422236492e+104, 13, "1367625908124", 105},
  {3.9547162810700879071685323e+149, 3, "395", 150},
  {1.0472016799893781624673612e+136, 19, "1047201679989378162", 137},
  {7.1540755406071953167467821e+243, 16, "7154075540607195", 244},
  {1.6639687326534432638390669e-63, 21, "166396873265344326384", -62},
  {4.2109425010089637500000000e+14, 4, "4211", 15},
  {9.3963710238307316803200645e-265, 12, "939637102383", -264},
  {9.4338927977289451749653267e+198, 1, "9", 199},
  {2.4116058305118007520540996e+142, 7, "2411606", 143},
  {1.6669463178299337059330399e+282, 17, "16669463178299337", 283},
  {1.6070200493708717810215726e+224, 13, "1607020049371", 225},
  {7.9571389673986587741176356e-78, 17, "79571389673986588", -77},
  {2.1322042678524911793872464e-132, 16, "2132204267852491", -131},
  {2.0858754784953636510934908e-169, 6, "208588", -168},
  {7.4391311368450132028514350e-216, 2, "74", -215},
  {8.0519149065542225981464821e-295, 3, "805", -294},
  {2.0019035074369733152491536e-62, 1, "2", -61},
  {8.9625362514263759282801786e+132, 9, "896253625", 133},
  {9.0675013968083807281534164e+152, 20, "90675013968083807282", 153},
  {3.0707461333290578440819177e-174, 2, "31", -173},
  {1.1423815282228760901616963e-203, 8, "11423815", -202},
  {9.1263552427096731270642532e-215, 7, "9126355", -214},
  {6.3809863228983465386395928e-246, 17, "63809863228983465", -245},
  {7.3305602385740754378119496e+296, 19, "7330560238574075438", 297},
  {9.9147845058926125183426875e+298, 21, "991478450589261251834", 299},
  {9.4943709706446843860052389e+204, 1, "9", 205},
  {3.0705918183353605931936848e+57, 8, "30705918", 58},
  {2.2422296587030530465573077e+40, 8, "22422297", 41},
  {1.1283282561211078766989064e-234, 1, "1", -233},
  {1.0488666602626079047569508e+261, 2, "1", 262},
  {1.1235948767492338704893424e-216, 10, "1123594877", -215},
  {7.3280222171735538781274761e-243, 14, "73280222171736", -242},
  {3.2021634549280410302029436e-288, 10, "3202163455", -287},
  {5.5576368765756519819161906e-23, 1, "6", -22},
  {1.7575467457089664206369188e+193, 14, "1757546745709", 194},
  {1.0026388943418043177030712e-38, 7, "1002639", -37},
  {3.8461440409163673404536529e+193, 7, "3846144", 194},
  {3.9821809508152095275690759e+133, 18, "398218095081520953", 134},
  {1.7062172076011192497074903e+218, 4, "1706", 219},
  {6.5149498605016020161927695e+264, 19, "6514949860501602016", 265},
  {1.7845301805677454132356349e-05, 16, "1784530180567745", -4},
  {3.1152590755059342703898337e+269, 4, "3115", 270},
  {9.3846683858794418024565124e-194, 3, "938", -193},
  {1.4247382321350410892649197e+280, 20, "14247382321350410893", 281},
  {8.1369117991298501422204465e+209, 3, "814", 210},
  {2.8244118287769500889001612e+136, 18, "282441182877695009", 137},
  {6.6889050753809294419033363e-121, 15, "668890507538093", -120},
  {1.3310654992157869818801436e+257, 8, "13310655", 258},
  {2.0484171380726747054946211e+62, 10, "2048417138", 63},
  {1.3586641673566107715029324e-309, 4, "1359", -308},
  {4.5846456163087152426378033e+271, 20, "45846456163087152426", 272},
  {7.4530493178828851634800431e-286, 18, "745304931788288516", -285},
  {1.8055626462464603293575319e-19, 9, "180556265", -18},
  {9.7377208220385781250839500e-112, 12, "973772082204", -111},
  {5.0151984963581217695906089e+39, 12, "501519849636", 40},
  {4.4566686536466459428238631e-123, 21, "445666865364664594282", -122},
  {2.0415012000785263938850776e+208, 19, "2041501200078526394", 209},
  {1.0233605427794480621770181e-283, 3, "102", -282},
  {7.8453813133921758913832076e-225, 20, "78453813133921758914", -224},
  {7.7855427528556688093927371e+293, 6, "778554", 294},
  {2.9940287869441283256240962e-183, 14, "29940287869441", -182},
  {7.2709144913421206869314964e-81, 3, "727", -80},
  {1.4139679563467108988170578e+287, 20, "14139679563467108988", 288},
  {1.4353094917752931476739156e-62, 7, "1435309", -61},
  {1.6967836224185945458259738e+55, 9, "169678362", 56},
  {1.5734605862331987085047434e+252, 11, "15734605862", 253},
  {7.0332458888106115779957848e+155, 10, "7033245889", 156},
  {3.1112746591259900032870478e-85, 5, "31113", -84},
  {2.3576314478751361493728681e+265, 13, "2357631447875", 266},
  {1.0647850685202763415873051e+06, 15, "106478506852028", 7},
  {2.7055453555591144945539150e+142, 21, "270554535555911449455", 143},
  {7.8051526342755669450544610e+260, 3, "781", 261},
  {1.2437200563435364284980852e+145, 21, "12437200563435364285", 146},
  {1.6846618846094482903149415e-158, 5, "16847", -157},
  {1.2942724415299838003931278e-264, 2, "13", -263},
  {3.7990646904493357004368201e-130, 1, "4", -129},
  {8.8129087606721537198537961e+278, 18, "881290876067215372", 279},
  {1.9914792690325565515482651e+82, 18, "199147926903255655", 83},
  {1.4844340785999615497177353e+232, 14, "14844340786", 233},
  {6.0090186887544524298263887e-21, 10, "6009018689", -20},
  {6.8772869445376524931741734e+120, 2, "69", 121},
  {5.3603220859989203531262725e-244, 16, "536032208599892", -243},
  {9.2125933952828284253569851e-195, 6, "921259", -194},
  {7.6889715094186346665483222e+70, 11, "76889715094", 71},
  {2.5164605458218765641644807e-155, 11, "25164605458", -154},
  {4.3635316112038118412984730e-77, 18, "436353161120381184", -76},
  {9.4042034383501816714329766e-102, 9, "940420344", -101},
  {4.0621786324484881721115322e-53, 11, "40621786324", -52},
  {3.4937439574566334529861100e+250, 15, "349374395745663", 251},
  {1.6357932000435388461000169e+178, 7, "1635793", 179},
  {1.1486084839950677432664207e+184, 3, "115", 185},
  {3.3466453025223311318482021e-67, 2, "33", -66},
  {1.9923570547459249887126325e-111, 5, "19924", -110},
  {3.4436457816502641164705025e-91, 8, "34436458", -90},
  {2.9237680173206148024324614e+139, 16, "2923768017320615", 140},
  {7.5022019773757883678720000e+22, 3, "75", 23},
  {2.7037823582936875300696437e-90, 6, "270378", -89},
  {4.0067736132747905527751992e+220, 16, "4006773613274791", 221},
  {2.1246519982655899646355451e+39, 11, "21246519983", 40},
  {2.9168855237068335038317529e-143, 17, "29168855237068335", -142},
  {4.9335201212146652918373843e+191, 17, "49335201212146653", 192},
  {5.9570196792128487424000000e+19, 11, "59570196792", 20},
  {3.2312984551433200977044180e+04, 12, "323129845514", 5},
  {6.7412831600591661534042475e-167, 11, "67412831601", -166},
  {2.9663607787409033995505485e+96, 2, "3", 97},
  {3.8005893071552029605287039e-186, 9, "380058931", -185},
  {1.0966315763784388775634902e+106, 11, "10966315764", 107},
  {5.7703914020882001845311946e-221, 2, "58", -220},
  {1.8225271863722070062312671e-19, 21, "182252718637220700623", -18},
  {1.7154842907168461914062500e+12, 8, "17154843", 13},
  {9.4275606929747272191808715e+137, 11, "9427560693", 138},
  {1.5450769215142640680825778e+226, 16, "1545076921514264", 227},
  {3.6361555397403463224928265e-47, 2, "36", -46},
  {1.2072444536408260764029588e-173, 15, "120724445364083", -172},
  {3.0916188948909752551297506e+95, 11, "30916188949", 96},
  {1.2402882749910689101103584e-185, 21, "124028827499106891011", -184},
  {6.8930980883493682861328125e+10, 21, "689309808834936828613", 11},
  {9.1681342222915882764604253e+263, 21, "916813422229158827646", 264},
  {5.1878511727349120230986841e-289, 11, "51878511727", -288},
  {9.0797439068562913456622163e+79, 3, "908", 80},
  {1.7924533996305940625000000e+14, 18, "179245339963059406", 15},
  {7.7054264144149819043523975e-51, 13, "7705426414415", -50},
  {4.7544744917641792297363281e+10, 13, "4754474491764", 11},
  {4.4067034365026524175029325e+278, 5, "44067", 279},
  {3.1264762601355324757365574e+258, 8, "31264763", 259},
  {1.8431833122922038107612765e+116, 5, "18432", 117},
  {7.9994211007548176499870973e+271, 2, "8", 272},
  {4.3682641964869541759245051e-262, 15, "436826419648695", -261},
  {1.0816060507078680695926095e-36, 5, "10816", -35},
  {6.9708008038487934924729807e+179, 18, "697080080384879349", 180},
  {1.4952112867122327668688528e+130, 16, "1495211286712233", 131},
  {1.5655983624497144972380925e-37, 18, "15655983624497145", -36},
  {2.0941777112053469670303553e-44, 12, "209417771121", -43},
  {1.1440356057121518394922563e-305, 13, "1144035605712", -304},
  {4.1883106844632954612654688e-233, 2, "42", -232},
  {2.1297364687851740870866717e-93, 11, "21297364688", -92},
  {1.1182361914238933171455893e-146, 4, "1118", -145},
  {5.4053436467984489320604074e-156, 13, "5405343646798", -155},
  {1.0110311733808072103861345e-37, 3, "101", -36},
  {1.9127528420797642683682985e-224, 12, "191275284208", -223},
  {2.5411786589039391130225602e+95, 9, "254117866", 96},
  {1.1877285051909839289071102e-191, 6, "118773", -190},
  {2.3552789768191187761695442e+104, 2, "24", 105},
  {5.5870306747698823145495492e+180, 1, "6", 181},
  {8.1090803443270283626751445e-208, 7, "810908", -207},
  {8.5450556082671323264558334e+222, 2, "85", 223},
  {7.3443424132944642190363066e+29, 19, "7344342413294464219", 30},
  {1.7622857869257547808349886e+308, 2, "18", 309},
  {3.7145749954175328000000000e+17, 10, "3714574995", 18},
  {2.1716032890897743607340099e-182, 21, "217160328908977436073", -181},
  {7.3198416763525031048637266e-242, 8, "73198417", -241},
  {3.1555329590843914543300484e-290, 6, "315553", -289},
  {4.0425126465145348669779849e+68, 17, "40425126465145349", 69},
  {1.8282530924213591278641645e+257, 2, "18", 258},
  {8.4564861649157659325673444e-196, 20, "84564861649157659326", -195},
  {1.9131187273319793962534394e-42, 10, "1913118727", -41},
  {1.3885272528428817215505611e-84, 19, "1388527252842881722", -83},
  {6.8663315839980878891982993e+248, 14, "68663315839981", 249},
  {1.6339289165060853791145783e-205, 9, "163392892", -204},
  {3.7658808144398851766991251e+229, 13, "376588081444", 230},
  {6.5120254947867642137702683e-30, 21, "651202549478676421377", -29},
  {8.2682781826579941503814535e-210, 10, "8268278183", -209},
  {4.7193572505028144431886364e-19, 4, "4719", -18},
  {8.1644066422077470960855214e-306, 12, "816440664221", -305},
  {1.9740391758336116902712549e+243, 11, "19740391758", 244},
  {1.4667439906657703139716281e-131, 8, "1466744", -130},
  {2.0949816674714060222821978e+125, 15, "209498166747141", 126},
  {1.1313081568295880200579649e+143, 12, "113130815683", 144},
  {8.7843057473871519029065255e-293, 14, "87843057473872", -292},
  {6.6171360185773229927535922e+198, 18, "661713601857732299", 199},
  {1.5555030487187807366520065e-148, 12, "155550304872", -147},
  {5.5707015535825688760024744e+159, 9, "557070155", 160},
  {4.2506701901975984686606616e+32, 15, "42506701901976", 33},
  {8.4516677866248781404865831e+73, 14, "84516677866249", 74},
  {8.9273350006518571249742451e-159, 21, "892733500065185712497", -158},
  {8.2378342054304768490056824e-100, 4, "8238", -99},
  {1.3399029491871857998407761e+171, 3, "134", 172},
  {1.7889577822292466944507243e-66, 11, "17889577822", -65},
  {6.1202467260681813502433376e+77, 13, "6120246726068", 78},
  {7.8449150580554850000000000e+15, 11, "78449150581", 16},
  {4.6940057163051779021634896e-223, 10, "4694005716", -222},
  {1.1018703490343201562712122e+57, 3, "11", 58},
  {1.8318019537174382949044514e-88, 12, "183180195372", -87},
  {7.1179423849767117434704022e-292, 16, "7117942384976712", -291},
  {7.8991176793393244601734256e+96, 16, "7899117679339324", 97},
  {6.4881127581729024648666382e+07, 12, "648811275817", 8},
  {1.6689537345860853819835157e+230, 8, "16689537", 231},
  {2.7159439185447466741115254e-57, 21, "271594391854474667411", -56},
  {2.1925708133239101806531831e+60, 15, "219257081332391", 61},
  {2.7207641300058003376773671e+109, 13, "2720764130006", 110},
  {9.2116295609481007949451046e+299, 15, "92116295609481", 300},
  {5.3437735742182178452753798e-62, 1, "5", -61},
  {3.1143120806108975705227961e+144, 14, "31143120806109", 145},
  {7.0083561871862950500345389e-233, 5, "70084", -232},
  {4.1098124039038238644696487e+211, 3, "411", 212},
  {8.1106434077580391373913744e-226, 8, "81106434", -225},
  {9.4892043476615593222741250e-43, 7, "9489204", -42},
  {1.5703880551969852679838064e+54, 10, "1570388055", 55},
  {9.2286677805702012243669965e+295, 6, "922867", 296},
  {3.0536252942751424168020099e+76, 5, "30536", 77},
  {7.5447441470508966992770534e+41, 2, "75", 42},
  {4.5142180292225884984197617e-228, 6, "451422", -227},
  {4.4142679809932864135110329e-30, 21, "441426798099328641351", -29},
  {3.6636821365368327838628290e-300, 5, "36637", -299},
  {1.5127593806880035423935842e-83, 20, "15127593806880035424", -82},
  {8.3430435273878834350042165e+229, 16, "8343043527387883", 230},
  {9.3865025001259254505092574e-23, 1, "9", -22},
  {9.4383674647102634446322430e+112, 14, "94383674647103", 113},
  {9.8832545490971475859468596e-275, 6, "988325", -274},
  {1.6325043017642876365564607e-28, 18, "163250430176428764", -27},
  {1.2150928368535623495827547e-29, 2, "12", -28},
  {1.9932399742764574422810374e+172, 9, "199323997", 173},
  {9.0083469357369125812831236e+269, 3, "901", 270},
  {4.6360010281349434821396414e+296, 1, "5", 297},
  {6.8870660568218701181824388e-214, 16, "688706605682187", -213},
  {1.9292352183796416672817695e-137, 9, "192923522", -136},
  {9.1933192585794258310431370e-284, 17, "91933192585794258", -283},
  {4.9981881868520697280211188e-113, 4, "4998", -112},
  {1.1234319361712521486710789e-178, 1, "1", -177},
  {3.4725732339123066715658045e-152, 15, "347257323391231", -151},
  {4.7794744304042009837424072e-08, 18, "477947443040420098", -7},
  {2.6760675284179787117312049e-208, 20, "26760675284179787117", -207},
  {5.8463163313575239574262536e+195, 12, "584631633136", 196},
  {4.0797823690104868165952547e+270, 16, "4079782369010487", 271},
  {3.5173473006909228222946084e+93, 14, "35173473006909", 94},
  {1.5481879027365917071769600e+23, 10, "1548187903", 24},
  {2.5525309490973445943150088e+190, 1, "3", 191},
  {8.5798238601118432034678222e-165, 10, "857982386", -164},
  {5.6640175886832392640397312e+25, 16, "5664017588683239", 26},
  {2.0658894101319759802873190e+158, 18, "206588941013197598", 159},
  {1.7184853056628330025905286e-306, 10, "1718485306", -305},
  {2.1165079248484465169331609e+289, 5, "21165", 290},
  {1.0926783002916241074475500e+295, 6, "109268", 296},
  {8.0333198721086745612701369e+272, 5, "80333", 273},
  {2.2032453568482039675228057e+236, 7, "2203245", 237},
  {2.5988224823043011198236175e+114, 1, "3", 115},
  {1.8786119476454274490717418e-246, 13, "1878611947645", -245},
  {2.3727478578329349845329362e-132, 18, "237274785783293498", -131},
  {6.3511028825839923152404040e-229, 3, "635", -228},
  {1.2148055748540243806687795e-156, 21, "121480557485402438067", -155},
  {1.0864961647750864713538542e+194, 15, "108649616477509", 195},
  {1.7404658531490803200000000e+17, 21, "174046585314908032", 18},
  {1.2713184699065286318677793e-285, 15, "127131846990653", -284},
  {7.6064364780893128319601945e+263, 3, "761", 264},
  {6.2133233059410801274919869e-105, 14, "62133233059411", -104},
  {3.8932462893008778674387712e+95, 10, "3893246289", 96},
  {6.7226629032826570329879886e-242, 21, "672266290328265703299", -241},
  {3.8455060230019298845398029e+243, 16, "384550602300193", 244},
  {1.7626701334638607651548882e-71, 10, "1762670133", -70},
  {2.5523444774820263435258392e-34, 18, "255234447748202634", -33},
  {8.8003859403777224789625893e+103, 17, "88003859403777225", 104},
  {6.6040876531569846963438528e-52, 21, "660408765315698469634", -51},
  {1.0216042844280209889264110e-123, 15, "102160428442802", -122},
  {2.3665918095205401315732329e-136, 19, "2366591809520540132", -135},
  {9.3868632831179802017739823e+95, 6, "938686", 96},
  {1.4452822078148945643979990e-116, 10, "1445282208", -115},
  {3.0534315430328242770591363e+31, 21, "305343154303282427706", 32},
  {1.6558526770733529781778970e+187, 19, "1655852677073352978", 188},
  {1.8599554789362824499152281e+246, 9, "185995548", 247},
  {5.9148252641094049217253172e-22, 10, "5914825264", -21},
  {9.6803779471812136153493260e+209, 7, "9680378", 210},
  {2.7899062898174552510642724e-143, 19, "2789906289817455251", -142},
  {3.0783991762634273009157848e+230, 7, "3078399", 231},
  {4.0107680345639678428414091e-265, 20, "40107680345639678428", -264},
  {7.6309552386881896270611864e+152, 4, "7631", 153},
  {3.5676783330180747556364875e+288, 18, "356767833301807476", 289},
  {7.7477150348255239916659660e+100, 14, "77477150348255", 101},
  {5.7011546765233977760057009e+52, 21, "570115467652339777601", 53},
  {4.4428771874098722625759302e-40, 12, "444287718741", -39},
  {9.8371797123455659954286120e-161, 10, "9837179712", -160},
  {1.9029696782058356889144491e+77, 19, "1902969678205835689", 78},
  {3.1004482450973946739538313e+51, 3, "31", 52},
  {2.9101261121048024395309158e+143, 20, "29101261121048024395", 144},
  {9.6666741205757904099434073e+263, 17, "96666741205757904", 264},
  {6.6591009829611442127879708e+135, 1, "7", 136},
  {1.5109228998449519792727588e-46, 17, "1510922899844952", -45},
  {1.1031172738461716961383771e-21, 7, "1103117", -20},
  {2.9373238770116517570834037e-43, 3, "294", -42},
  {9.7168132700813332286772557e+224, 7, "9716813", 225},
  {2.0658775359768724899049131e-131, 17, "20658775359768725", -130},
  {4.0456156363750054395988692e-44, 4, "4046", -43},
  {1.0106474952213614253409232e+151, 12, "101064749522", 152},
  {1.1421176077982986389209826e-249, 17, "11421176077982986", -248},
  {4.5461131205082292526001944e+283, 17, "45461131205082293", 284},
  {2.4121184496208334375000000e+14, 16, "2412118449620833", 15},
  {3.1090426971934595778930258e-12, 10, "3109042697", -11},
  {3.7117541899941550924925122e+245, 4, "3712", 246},
  {5.6786722798341678318223527e-89, 19, "5678672279834167832", -88},
  {1.6365431555663398042583830e+219, 1, "2", 220},
  {2.9800755800881558029104081e+38, 12, "298007558009", 39},
  {3.5033838627440818372385183e+256, 12, "350338386274", 257},
  {1.6957444126517046356639185e+02, 21, "169574441265170463566", 3},
  {4.0015700302661683765482111e-290, 11, "40015700303", -289},
  {2.7630315352143000972966629e-102, 19, "2763031535214300097", -101},
  {1.6002160918297685125133317e+242, 17, "16002160918297685", 243},
  {3.9572421478661038129235668e+225, 3, "396", 226},
  {1.8587951794057400903844991e-182, 11, "18587951794", -181},
  {2.3908646697920082075689050e-231, 7, "2390865", -230},
  {6.4859083240797724117577430e+35, 12, "648590832408", 36},
  {6.8268894357239253901615590e-187, 7, "6826889", -186},
  {3.4994209795272389100626353e+40, 6, "349942", 41},
  {2.0168594494474729778750358e+37, 10, "2016859449", 38},
  {4.8549270114596027786566887e+165, 3, "485", 166},
  {8.0945975772150067815403117e+178, 7, "8094598", 179},
  {1.7495446591204295184959593e-63, 16, "174954465912043", -62},
  {1.0071775415131332153408183e-290, 20, "10071775415131332153", -289},
  {9.9797340628146283674840112e+258, 1, "1", 260},
  {2.3295051530148679350205655e+295, 2, "23", 296},
  {1.4780904334253597380648826e+254, 5, "14781", 255},
  {1.8054320418093835719900975e-44, 7, "1805432", -43},
  {4.0252212264719675383658230e-38, 2, "4", -37},
  {4.9454363325116571889953716e+58, 18, "494543633251165719", 59},
  {1.3748300158865097881525308e-106, 19, "1374830015886509788", -105},
  {1.0066962650589231144217853e+172, 11, "10066962651", 173},
  {5.1571506289539517867560707e-06, 6, "515715", -5},
  {4.5591993544075597084194205e-222, 12, "455919935441", -221},
  {4.1313593224492149701466544e+104, 7, "4131359", 105},
  {1.0182365144889485734581457e+51, 20, "10182365144889485735", 52},
  {2.9886997551769883071641978e-226, 19, "2988699755176988307", -225},
  {9.6593728168979147970227345e-138, 8, "96593728", -137},
  {8.7334877272030447716881009e+257, 11, "87334877272", 258},
  {1.9078973686579313252512770e+290, 16, "1907897368657931", 291},
  {1.9608847746152984970374455e+285, 6, "196088", 286},
  {2.5483125273238966474309564e+05, 6, "254831", 6},
  {2.8336899538309680975771175e-106, 6, "283369", -105},
  {8.4432751385718092198481416e+55, 17, "84432751385718092", 56},
  {7.6208189899587098396772699e+163, 10, "762081899", 164},
  {3.6035947188189890625000000e+13, 11, "36035947188", 14},
  {3.5011892975864107246434098e+224, 8, "35011893", 225},
  {1.4083585684047340511712198e+258, 18, "140835856840473405", 259},
  {3.0778743095950370315975109e+169, 2, "31", 170},
  {1.0944372347394197687982321e+224, 2, "11", 225},
  {3.1625122901217834791724668e+194, 13, "3162512290122", 195},
  {6.4821539671941478788294235e-196, 16, "6482153967194148", -195},
  {6.4549870975824807995123644e-215, 8, "64549871", -214},
  {5.6146939512539294553595817e+254, 18, "561469395125392946", 255},
  {1.0073627868334568807878011e+266, 13, "1007362786833", 267},
  {2.7195215122439779987523023e+72, 11, "27195215122", 73},
  {7.8485455392751768576214131e+296, 9, "784854554", 297},
  {1.0761877164214258424234094e-94, 11, "10761877164", -93},
  {4.8948553185051979944564487e+65, 17, "4894855318505198", 66},
  {8.6491834787958880386800302e-55, 6, "864918", -54},
  {1.7615773060291902270522425e+195, 17, "17615773060291902", 196},
  {1.1189804765680698870358188e+41, 15, "111898047656807", 42},
  {2.1336114957959270976905211e-215, 20, "21336114957959270977", -214},
  {2.4677269001982442434036695e-91, 7, "2467727", -90},
  {7.1139392395330156016147250e-94, 5, "71139", -93},
  {1.3468062213755033600936934e+45, 20, "13468062213755033601", 46},
  {4.8987038803040297553858446e+103, 15, "489870388030403", 104},
  {3.2056604010731361638680019e+54, 9, "32056604", 55},
  {2.7527963121489712746023596e+220, 18, "275279631214897127", 221},
  {9.1514830818021106357014082e-138, 2, "92", -137},
  {1.1804924652917932075000092e-136, 10, "1180492465", -135},
  {4.6571532998257547504654197e-33, 15, "465715329982575", -32},
  {4.4724664967421106557961153e-48, 2, "45", -47},
  {8.9019548847712353866016666e+106, 12, "890195488477", 107},
  {4.1776174120076706948047124e+129, 7, "4177617", 130},
  {2.6994196865120294815908070e-239, 17, "26994196865120295", -238},
  {3.6792388611027212094733556e-67, 7, "3679239", -66},
  {4.8971016415115300805695476e-117, 1, "5", -116},
  {1.4633952281816379705087206e-61, 20, "14633952281816379705", -60},
  {5.3105252254711865461964800e+23, 8, "53105252", 24},
  {5.1673034234297202909668019e+203, 6, "51673", 204},
  {1.3639470661318169193251136e+193, 17, "13639470661318169", 194},
  {8.1938007031317635671265663e-164, 19, "8193800703131763567", -163},
  {7.3957249953866318941849672e-189, 4, "7396", -188},
  {2.7574707845006634494925680e+105, 21, "275747078450066344949", 106},
  {3.2151343656470740825170651e+04, 7, "3215134", 5},
  {1.7130985872693701077002689e+234, 11, "17130985873", 235},
  {2.2611664322201093778573708e+191, 14, "22611664322201", 192},
  {1.4266010457996622330854103e+285, 20, "14266010457996622331", 286},
  {1.4320743838006966397768243e+113, 17, "14320743838006966", 114},
  {7.8260440984396382665494232e-305, 18, "782604409843963827", -304},
  {1.0566154868743898557972745e+284, 12, "105661548687", 285},
  {2.7244479422270213320868226e-117, 6, "272445", -116},
  {4.8127407070132093127305551e+82, 10, "4812740707", 83},
  {4.9124732887009249406582911e+225, 19, "4912473288700924941", 226},
  {8.1144008399771658964014398e-98, 15, "811440083997717", -97},
  {5.3509621167210972371340331e+82, 7, "5350962", 83},
  {6.6612213714746683940217096e-152, 3, "666", -151},
  {2.9281823316589178714049280e+276, 4, "2928", 277},
  {6.6771658412983660020286652e+189, 19, "6677165841298366002", 190},
  {4.1469673048837089401494829e+191, 6, "414697", 192},
  {5.4420452414444721231959879e+194, 20, "54420452414444721232", 195},
  {2.9975309486672990322171007e+222, 21, "299753094866729903222", 223},
  {1.7165964785064950880575505e+111, 4, "1717", 112},
  {9.3886448828722897944441921e+223, 1, "9", 224},
  {9.4706343221988120007529781e-79, 18, "9470634322198812", -78},
  {7.3485200760450305144460344e+116, 14, "7348520076045", 117},
  {5.4278145556940025563941639e+96, 5, "54278", 97},
  {7.0410611879876735139814097e-238, 13, "7041061187988", -237},
  {9.9975848060337050781250000e+12, 15, "999758480603371", 13},
  {7.1931985193693333347097516e+75, 11, "71931985194", 76},
  {7.0833849983261832122372246e-303, 3, "708", -302},
  {1.8323336149676173055551185e-273, 15, "183233361496762", -272},
  {2.4843045897861592958498420e+102, 17, "24843045897861593", 103},
  {1.5877639038702428022636163e+155, 10, "1587763904", 156},
  {4.5230182076178985601044042e-57, 16, "4523018207617899", -56},
  {1.0465492117778968514769350e+46, 18, "104654921177789685", 47},
  {8.1460128330341882519802168e+65, 5, "8146", 66},
  {2.7244868684938294113356454e+78, 6, "272449", 79},
  {1.3342689638556600959365993e-250, 15, "133426896385566", -249},
  {6.2699019086864389577386615e-100, 5, "62699", -99},
  {1.1823366805266280670710470e-32, 7, "1182337", -31},
  {6.9216347564995779389013623e+28, 1, "7", 29},
  {2.0411424162679281419705234e+214, 9, "204114242", 215},
  {1.4390950348773358221494927e+60, 19, "1439095034877335822", 61},
  {2.3844028716697765472607702e+251, 9, "238440287", 252},
  {2.4313908108882373307270582e-07, 21, "243139081088823733073", -6},
  {1.0143272792943048951745692e-238, 10, "1014327279", -237},
  {7.1105386076458402848512710e+251, 3, "711", 252},
  {4.4932829454898674157448113e+03, 2, "45", 4},
  {2.8862388128181289035770811e+120, 3, "289", 121},
  {4.4684047613637841136003054e+165, 20, "44684047613637841136", 166},
  {6.5976750547759326411264413e+156, 17, "65976750547759326", 157},
  {3.4055203000749037948906939e+181, 18, "340552030007490379", 182},
  {6.5909312549285956338318493e+50, 12, "659093125493", 51},
  {1.5980740954608477154534633e-263, 6, "159807", -262},
  {7.7081982622560061876610635e-269, 3, "771", -268},
  {6.8163082408702739994269726e-87, 16, "6816308240870274", -86},
  {1.2554931379450933255296430e-25, 20, "12554931379450933255", -24},
  {2.9319880242544856684920192e-40, 17, "29319880242544857", -39},
  {5.2913680502722519415707039e+185, 15, "529136805027225", 186},
  {1.0527920498812623999662184e-212, 4, "1053", -211},
  {6.5412616053877216733298688e+25, 4, "6541", 26},
  {3.1040924142517916886738762e-87, 1, "3", -86},
  {3.0865907220275704163001921e+244, 8, "30865907", 245},
  {2.4909192069516741847710945e+206, 8, "24909192", 207},
  {2.1682587423735327503134143e-112, 20, "21682587423735327503", -111},
  {1.1526207360065617075906088e-210, 18, "115262073600656171", -209},
  {6.1598989238649041142102043e-270, 7, "6159899", -269},
  {7.0275575245201437374858211e-149, 4, "7028", -148},
  {6.6203375341650348131837076e-184, 12, "662033753417", -183},
  {1.7016358797100373407519789e+89, 18, "170163587971003734", 90},
  {3.9995692107411590900338951e+174, 6, "399957", 175},
  {1.8228922867612179034670505e-284, 2, "18", -283},
  {8.9710089127273442285797173e+77, 21, "897100891272734422858", 78},
  {2.7124140232003344000000000e+17, 19, "27124140232003344", 18},
  {9.7583646285920274870982296e-120, 9, "975836463", -119},
  {1.0949933650343454592068918e-194, 4, "1095", -193},
  {3.4454559771393882132650325e-194, 14, "34454559771394", -193},
  {3.0233473199627877122936820e+243, 15, "302334731996279", 244},
  {5.8317258388846200980247292e+286, 19, "5831725838884620098", 287},
  {3.9089353677867425381617062e-184, 6, "390894", -183},
  {1.5372914964744991711293714e-257, 10, "1537291496", -256},
  {1.0888304236700190503040003e-229, 5, "10888", -228},
  {