/* This file is auto-generated from "transaction.xml" by the typemaker
   tool of Gwenhywfar. 
   Do not edit this file -- all changes will be lost! */
#ifndef TRANSACTION_H
#define TRANSACTION_H

/** @page P_AB_TRANSACTION_PUBLIC AB_Transaction (public)
This page describes the properties of AB_TRANSACTION
This type contains all important information about transactions. All text fields are in UTF-8.<h3>Local Account Info</h3>
<p>
This group contains information about the local account.</p>
@anchor AB_TRANSACTION_LocalCountry
<h4>LocalCountry</h4>
<p>
This is the two-character country code according to ISO 3166-1 (Alpha-2). This is also used in DNS toplevel domain names. For Germany use "DE" (not case-sensitive).</p>
<p>
Set this property with @ref AB_Transaction_SetLocalCountry, 
get it with @ref AB_Transaction_GetLocalCountry
</p>

@anchor AB_TRANSACTION_LocalBankCode
<h4>LocalBankCode</h4>
<p>
This is the code of the local bank (i.e.
<b>your</b>
bank).</p>
<p>
Set this property with @ref AB_Transaction_SetLocalBankCode, 
get it with @ref AB_Transaction_GetLocalBankCode
</p>

@anchor AB_TRANSACTION_LocalBranchId
<h4>LocalBranchId</h4>
<p>
This is the branch id of the local bank (OFX only)</p>
<p>
Set this property with @ref AB_Transaction_SetLocalBranchId, 
get it with @ref AB_Transaction_GetLocalBranchId
</p>

@anchor AB_TRANSACTION_LocalAccountNumber
<h4>LocalAccountNumber</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetLocalAccountNumber, 
get it with @ref AB_Transaction_GetLocalAccountNumber
</p>

@anchor AB_TRANSACTION_LocalSuffix
<h4>LocalSuffix</h4>
<p>
If your account has subaccounts which are distinguished by different suffixes, then this is that suffix. Otherwise it's empty. (HBCI only)</p>
<p>
Set this property with @ref AB_Transaction_SetLocalSuffix, 
get it with @ref AB_Transaction_GetLocalSuffix
</p>

@anchor AB_TRANSACTION_LocalIban
<h4>LocalIban</h4>
<p>
International Bank Account Number according to ECBS EBS 204.
<table><tr><th>Pos</th><th>Meaning</th></tr><tr><td>0-1</td><td>Country code according to ISO 3166</td></tr><tr><td>2-3</td><td>Checksum</td></tr><tr><td>4-33</td><td>Country specific account info</td></tr></table>
Examples:
<ul><li>BE62510007547061</li><li>FR1420041010050500013M02606</li></ul></p>
<p>
Set this property with @ref AB_Transaction_SetLocalIban, 
get it with @ref AB_Transaction_GetLocalIban
</p>

@anchor AB_TRANSACTION_LocalName
<h4>LocalName</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetLocalName, 
get it with @ref AB_Transaction_GetLocalName
</p>

@anchor AB_TRANSACTION_LocalBic
<h4>LocalBic</h4>
<p>
This is the SWIFT id of the local bank.</p>
<p>
Set this property with @ref AB_Transaction_SetLocalBic, 
get it with @ref AB_Transaction_GetLocalBic
</p>

<h3>Remote Account Info</h3>
<p>
This group contains information about the remote account.</p>
@anchor AB_TRANSACTION_RemoteCountry
<h4>RemoteCountry</h4>
<p>
This is the two-character ISO country code (as used in toplevel domains). For Germany use "DE".</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteCountry, 
get it with @ref AB_Transaction_GetRemoteCountry
</p>

@anchor AB_TRANSACTION_RemoteBankName
<h4>RemoteBankName</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteBankName, 
get it with @ref AB_Transaction_GetRemoteBankName
</p>

@anchor AB_TRANSACTION_RemoteBankLocation
<h4>RemoteBankLocation</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteBankLocation, 
get it with @ref AB_Transaction_GetRemoteBankLocation
</p>

@anchor AB_TRANSACTION_RemoteBankCode
<h4>RemoteBankCode</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteBankCode, 
get it with @ref AB_Transaction_GetRemoteBankCode
</p>

@anchor AB_TRANSACTION_RemoteBranchId
<h4>RemoteBranchId</h4>
<p>
This is the branch id of the remote bank (OFX only)</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteBranchId, 
get it with @ref AB_Transaction_GetRemoteBranchId
</p>

@anchor AB_TRANSACTION_RemoteAccountNumber
<h4>RemoteAccountNumber</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteAccountNumber, 
get it with @ref AB_Transaction_GetRemoteAccountNumber
</p>

@anchor AB_TRANSACTION_RemoteSuffix
<h4>RemoteSuffix</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteSuffix, 
get it with @ref AB_Transaction_GetRemoteSuffix
</p>

@anchor AB_TRANSACTION_RemoteIban
<h4>RemoteIban</h4>
<p>
International Bank Account Number according to ECBS EBS 204.
<table><tr><th>Pos</th><th>Meaning</th></tr><tr><td>0-1</td><td>Country code according to ISO 3166</td></tr><tr><td>2-3</td><td>Checksum</td></tr><tr><td>4-33</td><td>Country specific account info</td></tr></table>
Examples:
<ul><li>BE62510007547061</li><li>FR1420041010050500013M02606</li></ul></p>
<p>
Set this property with @ref AB_Transaction_SetRemoteIban, 
get it with @ref AB_Transaction_GetRemoteIban
</p>

@anchor AB_TRANSACTION_RemoteName
<h4>RemoteName</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteName, 
get it with @ref AB_Transaction_GetRemoteName
</p>

@anchor AB_TRANSACTION_RemoteBic
<h4>RemoteBic</h4>
<p>
This is the SWIFT id of the local bank.</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteBic, 
get it with @ref AB_Transaction_GetRemoteBic
</p>

@anchor AB_TRANSACTION_UniqueId
<h3>UniqueId</h3>
<p>
This is a unique id assigned by the application. However, when adding a transaction to a job (like JobTransfer) this id is assigned by AqBanking to make sure that this id is unique across all applications.</p>
<p>
Set this property with @ref AB_Transaction_SetUniqueId, 
get it with @ref AB_Transaction_GetUniqueId
</p>

@anchor AB_TRANSACTION_IdForApplication
<h3>IdForApplication</h3>
<p>
This is a unique id assigned by the application only. This id is never changed by AqBanking.</p>
<p>
Set this property with @ref AB_Transaction_SetIdForApplication, 
get it with @ref AB_Transaction_GetIdForApplication
</p>

@anchor AB_TRANSACTION_GroupId
<h3>GroupId</h3>
<p>
This id is assigned by a backend when sending mutliple transfer jobs in one backend request (e.g. AqHBCI uses DTAUS files when sending multi-transfer requests; in this case every every transfer which goes into the same DTAUS file receives the same id).</p>
<p>
Set this property with @ref AB_Transaction_SetGroupId, 
get it with @ref AB_Transaction_GetGroupId
</p>

<h3>Dates</h3>
<p>
</p>
@anchor AB_TRANSACTION_ValutaDate
<h4>ValutaDate</h4>
<p>
The date when the transaction was really executed (Datum Valuta/Wertstellung)</p>
<p>
Set this property with @ref AB_Transaction_SetValutaDate, 
get it with @ref AB_Transaction_GetValutaDate
</p>

@anchor AB_TRANSACTION_Date
<h4>Date</h4>
<p>
The date when the transaction was booked (but sometimes it is unused). (Buchungsdatum)</p>
<p>
Set this property with @ref AB_Transaction_SetDate, 
get it with @ref AB_Transaction_GetDate
</p>

<h3>Value</h3>
<p>
</p>
@anchor AB_TRANSACTION_Value
<h4>Value</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetValue, 
get it with @ref AB_Transaction_GetValue
</p>

@anchor AB_TRANSACTION_Fees
<h3>Fees</h3>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetFees, 
get it with @ref AB_Transaction_GetFees
</p>

<h3>Info Which Is Not Supported by All Backends</h3>
<p>
<p>This group contains information which differ between backends.</p>
<p>Some of this information might not even be<b>supported</b>by every backends.</p></p>
@anchor AB_TRANSACTION_TextKey
<h4>TextKey</h4>
<p>
<p>A numerical transaction code, defined for all kinds of different actions. (Textschluessel)</p>
<p>For a normal transfer you should set it to 51. For debit notes the values 04 or 05 may be used. For other values please refer to your credit institute. (HBCI only)</p></p>
<p>
Set this property with @ref AB_Transaction_SetTextKey, 
get it with @ref AB_Transaction_GetTextKey
</p>

@anchor AB_TRANSACTION_TextKeyExt
<h4>TextKeyExt</h4>
<p>
<p>An extension to the text key (Textschluesselergaenzung, SWIFT Feld 34)</p>
<p>For a normal transfer you should set it to 51. For debit notes the values 04 or 05 may be used. For other values please refer to your credit institute. (HBCI only)</p></p>
<p>
Set this property with @ref AB_Transaction_SetTextKeyExt, 
get it with @ref AB_Transaction_GetTextKeyExt
</p>

@anchor AB_TRANSACTION_TransactionKey
<h4>TransactionKey</h4>
<p>
this is the transaction id that tells you more about the type of transaction (3 character code) (Buchungsschluessel) (HBCI only)</p>
<p>
Set this property with @ref AB_Transaction_SetTransactionKey, 
get it with @ref AB_Transaction_GetTransactionKey
</p>

@anchor AB_TRANSACTION_CustomerReference
<h4>CustomerReference</h4>
<p>
Reference string, if the customer (you) has specified one. (E.g. the cheque number.) Otherwise "NONREF" or empty (Kundenreferenz)</p>
<p>
Set this property with @ref AB_Transaction_SetCustomerReference, 
get it with @ref AB_Transaction_GetCustomerReference
</p>

@anchor AB_TRANSACTION_BankReference
<h4>BankReference</h4>
<p>
Reference string for this transaction given by the bank, if it has given one. Otherwise empty. (Bankreferenz)</p>
<p>
Set this property with @ref AB_Transaction_SetBankReference, 
get it with @ref AB_Transaction_GetBankReference
</p>

@anchor AB_TRANSACTION_EndToEndReference
<h4>EndToEndReference</h4>
<p>
This is a reference provided by the issuer of a SEPA transfer.</p>
<p>
Set this property with @ref AB_Transaction_SetEndToEndReference, 
get it with @ref AB_Transaction_GetEndToEndReference
</p>

@anchor AB_TRANSACTION_MandateReference
<h4>MandateReference</h4>
<p>
This is a reference provided by the issuer of a SEPA transfer.</p>
<p>
Set this property with @ref AB_Transaction_SetMandateReference, 
get it with @ref AB_Transaction_GetMandateReference
</p>

@anchor AB_TRANSACTION_CreditorIdentifier
<h4>CreditorIdentifier</h4>
<p>
Used for SEPA transfers.</p>
<p>
Set this property with @ref AB_Transaction_SetCreditorIdentifier, 
get it with @ref AB_Transaction_GetCreditorIdentifier
</p>

@anchor AB_TRANSACTION_OriginatorIdentifier
<h4>OriginatorIdentifier</h4>
<p>
Used for SEPA transfers.</p>
<p>
Set this property with @ref AB_Transaction_SetOriginatorIdentifier, 
get it with @ref AB_Transaction_GetOriginatorIdentifier
</p>

@anchor AB_TRANSACTION_TransactionCode
<h4>TransactionCode</h4>
<p>
A 3 digit numerical transaction code, defined for all kinds of different actions. (Geschaeftsvorfallcode)</p>
<p>
Set this property with @ref AB_Transaction_SetTransactionCode, 
get it with @ref AB_Transaction_GetTransactionCode
</p>

@anchor AB_TRANSACTION_TransactionText
<h4>TransactionText</h4>
<p>
Transaction text (e.g. STANDING ORDER) (Buchungstext)</p>
<p>
Set this property with @ref AB_Transaction_SetTransactionText, 
get it with @ref AB_Transaction_GetTransactionText
</p>

@anchor AB_TRANSACTION_Primanota
<h4>Primanota</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetPrimanota, 
get it with @ref AB_Transaction_GetPrimanota
</p>

@anchor AB_TRANSACTION_FiId
<h4>FiId</h4>
<p>
<p>This is an id optionally assigned by the Financial Institute. It is mostly used by OFX.</p></p>
<p>
Set this property with @ref AB_Transaction_SetFiId, 
get it with @ref AB_Transaction_GetFiId
</p>

@anchor AB_TRANSACTION_Purpose
<h4>Purpose</h4>
<p>
<p>This string list contains the purpose of the transaction. Every entry of this list represents a single purpose line.</p></p>
<p>
Set this property with @ref AB_Transaction_SetPurpose, 
get it with @ref AB_Transaction_GetPurpose
</p>

@anchor AB_TRANSACTION_Category
<h4>Category</h4>
<p>
<p>This string list contains the categories this transaction belongs to. This element is not used by AqBanking itself but some im/exporter plugins may choose to use these.</p></p>
<p>
Set this property with @ref AB_Transaction_SetCategory, 
get it with @ref AB_Transaction_GetCategory
</p>

<h3>Additional Information for Standing Orders</h3>
<p>
<p>This group contains information which is used with standing orders. It is not needed for other usage of this type.</p></p>
@anchor AB_TRANSACTION_Period
<h4>Period</h4>
<p>
This variable contains the execution period (e.g. whether a standing order is to be executed weekly or monthly etc).</p>
<p>
Set this property with @ref AB_Transaction_SetPeriod, 
get it with @ref AB_Transaction_GetPeriod
</p>

@anchor AB_TRANSACTION_Cycle
<h4>Cycle</h4>
<p>
The standing order is executed every
<i>cycle</i>
x
<i>period</i>
. So if
<i>period</i>
is
<i>weekly</i>
and
<i>cycle</i>
is
<i>2</i>
then the standing order is executed every 2 weeks.</p>
<p>
Set this property with @ref AB_Transaction_SetCycle, 
get it with @ref AB_Transaction_GetCycle
</p>

@anchor AB_TRANSACTION_ExecutionDay
<h4>ExecutionDay</h4>
<p>
The execution day. The meaning of this variable depends on the content of
<i>period</i>
:
<ul><li>monthly: day of the month (starting with<i>1</i>)</li><li>weekly: day of the week (starting with<i>1</i>=Monday)</li></ul></p>
<p>
Set this property with @ref AB_Transaction_SetExecutionDay, 
get it with @ref AB_Transaction_GetExecutionDay
</p>

@anchor AB_TRANSACTION_FirstExecutionDate
<h4>FirstExecutionDate</h4>
<p>
The date when the standing order is to be executed for the first time.</p>
<p>
Set this property with @ref AB_Transaction_SetFirstExecutionDate, 
get it with @ref AB_Transaction_GetFirstExecutionDate
</p>

@anchor AB_TRANSACTION_LastExecutionDate
<h4>LastExecutionDate</h4>
<p>
The date when the standing order is to be executed for the last time.</p>
<p>
Set this property with @ref AB_Transaction_SetLastExecutionDate, 
get it with @ref AB_Transaction_GetLastExecutionDate
</p>

@anchor AB_TRANSACTION_NextExecutionDate
<h4>NextExecutionDate</h4>
<p>
The date when the standing order is to be executed next (this field is only interesting when retrieving the list of currently active standing orders)</p>
<p>
Set this property with @ref AB_Transaction_SetNextExecutionDate, 
get it with @ref AB_Transaction_GetNextExecutionDate
</p>

<h3>Additional Information for Transfers</h3>
<p>
<p>This group contains information which is used with all kinds of transfers. It is setup by the function @ref AB_Banking_GatherResponses for transfers but not used by AqBanking otherwise.</p></p>
@anchor AB_TRANSACTION_Type
<h4>Type</h4>
<p>
This variable contains the type of transfer (transfer, debit note etc).</p>
<p>
Set this property with @ref AB_Transaction_SetType, 
get it with @ref AB_Transaction_GetType
</p>

@anchor AB_TRANSACTION_SubType
<h4>SubType</h4>
<p>
This variable contains the sub-type of transfer.</p>
<p>
Set this property with @ref AB_Transaction_SetSubType, 
get it with @ref AB_Transaction_GetSubType
</p>

@anchor AB_TRANSACTION_Status
<h4>Status</h4>
<p>
This variable contains the status of the transfer (accepted, rejected, pending). etc).</p>
<p>
Set this property with @ref AB_Transaction_SetStatus, 
get it with @ref AB_Transaction_GetStatus
</p>

@anchor AB_TRANSACTION_Charge
<h4>Charge</h4>
<p>
Specify who is to be charged for the transaction.</p>
<p>
Set this property with @ref AB_Transaction_SetCharge, 
get it with @ref AB_Transaction_GetCharge
</p>

<h3>Additional Information for Foreign Transfers</h3>
<p>
<p>This group contains information which is used with transfers to other countries in the world. It is used by backends and applications but not by AqBanking itself.</p></p>
@anchor AB_TRANSACTION_RemoteAddrStreet
<h4>RemoteAddrStreet</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteAddrStreet, 
get it with @ref AB_Transaction_GetRemoteAddrStreet
</p>

@anchor AB_TRANSACTION_RemoteAddrZipcode
<h4>RemoteAddrZipcode</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteAddrZipcode, 
get it with @ref AB_Transaction_GetRemoteAddrZipcode
</p>

@anchor AB_TRANSACTION_RemoteAddrCity
<h4>RemoteAddrCity</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemoteAddrCity, 
get it with @ref AB_Transaction_GetRemoteAddrCity
</p>

@anchor AB_TRANSACTION_RemotePhone
<h4>RemotePhone</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetRemotePhone, 
get it with @ref AB_Transaction_GetRemotePhone
</p>

<h3>Additional Information for Investment Transfers</h3>
<p>
<p>This group contains information which is used with investment/stock transfers. It is used by backends and applications but not by AqBanking itself.</p></p>
@anchor AB_TRANSACTION_UnitId
<h4>UnitId</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetUnitId, 
get it with @ref AB_Transaction_GetUnitId
</p>

@anchor AB_TRANSACTION_UnitIdNameSpace
<h4>UnitIdNameSpace</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetUnitIdNameSpace, 
get it with @ref AB_Transaction_GetUnitIdNameSpace
</p>

@anchor AB_TRANSACTION_Units
<h4>Units</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetUnits, 
get it with @ref AB_Transaction_GetUnits
</p>

@anchor AB_TRANSACTION_UnitPrice
<h4>UnitPrice</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetUnitPrice, 
get it with @ref AB_Transaction_GetUnitPrice
</p>

@anchor AB_TRANSACTION_Commission
<h4>Commission</h4>
<p>
</p>
<p>
Set this property with @ref AB_Transaction_SetCommission, 
get it with @ref AB_Transaction_GetCommission
</p>

<h3>Additional Information for SEPA Direct Debits</h3>
<p>
<p>This group contains information which is used with SEPA transfers within the European Community. It is used by backends and applications but not by AqBanking itself.</p></p>
@anchor AB_TRANSACTION_CreditorSchemeId
<h4>CreditorSchemeId</h4>
<p>
"Creditor Scheme Identification" ("Glaeubiger-ID", assigned by Deutsche Bundesbank)</p>
<p>
Set this property with @ref AB_Transaction_SetCreditorSchemeId, 
get it with @ref AB_Transaction_GetCreditorSchemeId
</p>

@anchor AB_TRANSACTION_MandateId
<h4>MandateId</h4>
<p>
"SEPA Direct debit mandate id</p>
<p>
Set this property with @ref AB_Transaction_SetMandateId, 
get it with @ref AB_Transaction_GetMandateId
</p>

@anchor AB_TRANSACTION_MandateDate
<h4>MandateDate</h4>
<p>
"Issue date of the direct debit mandate</p>
<p>
Set this property with @ref AB_Transaction_SetMandateDate, 
get it with @ref AB_Transaction_GetMandateDate
</p>

@anchor AB_TRANSACTION_MandateDebitorName
<h4>MandateDebitorName</h4>
<p>
"Debitor name for direct debit mandate if given by the debtor</p>
<p>
Set this property with @ref AB_Transaction_SetMandateDebitorName, 
get it with @ref AB_Transaction_GetMandateDebitorName
</p>

@anchor AB_TRANSACTION_OriginalCreditorSchemeId
<h4>OriginalCreditorSchemeId</h4>
<p>
Original value for "Creditor Scheme Identification", in case that value changed over time</p>
<p>
Set this property with @ref AB_Transaction_SetOriginalCreditorSchemeId, 
get it with @ref AB_Transaction_GetOriginalCreditorSchemeId
</p>

@anchor AB_TRANSACTION_OriginalMandateId
<h4>OriginalMandateId</h4>
<p>
"Original SEPA Direct debit mandate id, in case that changed over time</p>
<p>
Set this property with @ref AB_Transaction_SetOriginalMandateId, 
get it with @ref AB_Transaction_GetOriginalMandateId
</p>

@anchor AB_TRANSACTION_OriginalCreditorName
<h4>OriginalCreditorName</h4>
<p>
"Original SEPA Direct debit creditor name, in case that changed over time</p>
<p>
Set this property with @ref AB_Transaction_SetOriginalCreditorName, 
get it with @ref AB_Transaction_GetOriginalCreditorName
</p>

@anchor AB_TRANSACTION_SequenceType
<h4>SequenceType</h4>
<p>
Sequence type of the debit (on-time, first, recurring).</p>
<p>
Set this property with @ref AB_Transaction_SetSequenceType, 
get it with @ref AB_Transaction_GetSequenceType
</p>

*/
#ifdef __cplusplus
extern "C" {
#endif

typedef struct AB_TRANSACTION AB_TRANSACTION;

#ifdef __cplusplus
} /* __cplusplus */
#endif

#include <gwenhywfar/db.h>
#include <gwenhywfar/inherit.h>
#include <gwenhywfar/list2.h>
/* headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/gwentime.h>
#include <gwenhywfar/gwendate.h>
#include <gwenhywfar/stringlist.h>
#include <aqbanking/value.h>
#include <aqbanking/transactionlimits.h>
#include <aqbanking/transactionfns.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  AB_Transaction_PeriodUnknown=-1,
  /** No period.  */
  AB_Transaction_PeriodNone=0,
  /** The standing order is to be executed every month.  */
  AB_Transaction_PeriodMonthly,
  /** The standing order is to be executed every week.  */
  AB_Transaction_PeriodWeekly
} AB_TRANSACTION_PERIOD;

AQBANKING_API AB_TRANSACTION_PERIOD AB_Transaction_Period_fromString(const char *s);
AQBANKING_API const char *AB_Transaction_Period_toString(AB_TRANSACTION_PERIOD v);

typedef enum {
  AB_Transaction_TypeUnknown=-1,
  /** Simple transaction (as in transaction statements)  */
  AB_Transaction_TypeTransaction=0,
  /** Transfer type of transaction (as used with transfer jobs)  */
  AB_Transaction_TypeTransfer,
  /** Debit note type of transaction (as used with debit note jobs)  */
  AB_Transaction_TypeDebitNote,
  /** EU-Transfer type of transaction (as used for with transfer jobs)  */
  AB_Transaction_TypeEuTransfer,
  /** SEPA-Transfer type of transaction (as used with SEPA transfer jobs)  */
  AB_Transaction_TypeSepaTransfer,
  /** SEPA debit note type of transaction (as used with SEPA debit note jobs)  */
  AB_Transaction_TypeSepaDebitNote,
  /** Internal transfer (transfer between accounts at the same bank)  */
  AB_Transaction_TypeInternalTransfer
} AB_TRANSACTION_TYPE;

AQBANKING_API AB_TRANSACTION_TYPE AB_Transaction_Type_fromString(const char *s);
AQBANKING_API const char *AB_Transaction_Type_toString(AB_TRANSACTION_TYPE v);

typedef enum {
  AB_Transaction_SubTypeUnknown=-1,
  /** No transfer sub-type  */
  AB_Transaction_SubTypeNone=0,
  /** Standard transfer.  */
  AB_Transaction_SubTypeStandard,
  /** Check.  */
  AB_Transaction_SubTypeCheck,
  /** Debit note (Abbuchungsverfahren)  */
  AB_Transaction_SubTypeBookedDebitNote,
  /** Debit note (Einzugsermaechtigung)  */
  AB_Transaction_SubTypeDrawnDebitNote,
  /** Standing order (Dauerauftrag)  */
  AB_Transaction_SubTypeStandingOrder,
  /** Loan transfer.  */
  AB_Transaction_SubTypeLoan,
  /** EU standard transfer.  */
  AB_Transaction_SubTypeEuStandard,
  /** Eu transfer which is to be executed the same day.  */
  AB_Transaction_SubTypeEuASAP,
  /** Buy stocks and alike  */
  AB_Transaction_SubTypeBuy,
  /** Sell stocks and alike  */
  AB_Transaction_SubTypeSell,
  /** Reinvestment.  */
  AB_Transaction_SubTypeReinvest,
  /** Dividend.  */
  AB_Transaction_SubTypeDividend
} AB_TRANSACTION_SUBTYPE;

AQBANKING_API AB_TRANSACTION_SUBTYPE AB_Transaction_SubType_fromString(const char *s);
AQBANKING_API const char *AB_Transaction_SubType_toString(AB_TRANSACTION_SUBTYPE v);

typedef enum {
  AB_Transaction_StatusUnknown=-1,
  /** No status.  */
  AB_Transaction_StatusNone=0,
  /** The transfer has been accepted by the bank.  */
  AB_Transaction_StatusAccepted,
  /** The transfer has been rejected by the bank (or was erroneous).  */
  AB_Transaction_StatusRejected,
  /** The transfer is still pending.  */
  AB_Transaction_StatusPending,
  /** The transfer is being sent.  */
  AB_Transaction_StatusSending,
  /** The transfer has automatically been reconciled.  */
  AB_Transaction_StatusAutoReconciled,
  /** The transfer has automatically been reconciled.  */
  AB_Transaction_StatusManuallyReconciled,
  /** The transfer has been revoked.  */
  AB_Transaction_StatusRevoked,
  /** The transfer has been aborted.  */
  AB_Transaction_StatusAborted
} AB_TRANSACTION_STATUS;

AQBANKING_API AB_TRANSACTION_STATUS AB_Transaction_Status_fromString(const char *s);
AQBANKING_API const char *AB_Transaction_Status_toString(AB_TRANSACTION_STATUS v);

typedef enum {
  AB_Transaction_ChargeUnknown=-1,
  /** Nobody is to be charged.  */
  AB_Transaction_ChargeNobody=0,
  /** Issuer is to be charged.  */
  AB_Transaction_ChargeLocal,
  /** Peer is to be charged.  */
  AB_Transaction_ChargeRemote,
  /** Issuer and peer share the charges.  */
  AB_Transaction_ChargeShare
} AB_TRANSACTION_CHARGE;

AQBANKING_API AB_TRANSACTION_CHARGE AB_Transaction_Charge_fromString(const char *s);
AQBANKING_API const char *AB_Transaction_Charge_toString(AB_TRANSACTION_CHARGE v);

typedef enum {
  AB_Transaction_SequenceTypeUnknown=-1,
  /** One-time operation.  */
  AB_Transaction_SequenceTypeOnce=0,
  /** First operation with more following.  */
  AB_Transaction_SequenceTypeFirst,
  /** Following operation (not the first).  */
  AB_Transaction_SequenceTypeFollowing,
  /** Final operation (last).  */
  AB_Transaction_SequenceTypeFinal
} AB_TRANSACTION_SEQUENCETYPE;

AQBANKING_API AB_TRANSACTION_SEQUENCETYPE AB_Transaction_SequenceType_fromString(const char *s);
AQBANKING_API const char *AB_Transaction_SequenceType_toString(AB_TRANSACTION_SEQUENCETYPE v);


GWEN_INHERIT_FUNCTION_LIB_DEFS(AB_TRANSACTION, AQBANKING_API)
GWEN_LIST2_FUNCTION_LIB_DEFS(AB_TRANSACTION, AB_Transaction, AQBANKING_API)

/** Destroys all objects stored in the given LIST2 and the list itself
*/
AQBANKING_API void AB_Transaction_List2_freeAll(AB_TRANSACTION_LIST2 *stl);

/** Creates a new object.
*/
AQBANKING_API AB_TRANSACTION *AB_Transaction_new(void);
/** Creates an object from the data in the given GWEN_DB_NODE
*/
AQBANKING_API AB_TRANSACTION *AB_Transaction_fromDb(GWEN_DB_NODE *db);
/** Creates and returns a deep copy of thegiven object.
*/
AQBANKING_API AB_TRANSACTION *AB_Transaction_dup(const AB_TRANSACTION*st);
/** Destroys the given object.
*/
AQBANKING_API void AB_Transaction_free(AB_TRANSACTION *st);
/** Increments the usage counter of the given object, so an additional free() is needed to destroy the object.
*/
AQBANKING_API void AB_Transaction_Attach(AB_TRANSACTION *st);
/** Reads data from a GWEN_DB.
*/
AQBANKING_API int AB_Transaction_ReadDb(AB_TRANSACTION *st, GWEN_DB_NODE *db);
/** Stores an object in the given GWEN_DB_NODE
*/
AQBANKING_API int AB_Transaction_toDb(const AB_TRANSACTION*st, GWEN_DB_NODE *db);
/** Returns 0 if this object has not been modified, !=0 otherwise
*/
AQBANKING_API int AB_Transaction_IsModified(const AB_TRANSACTION *st);
/** Sets the modified state of the given object
*/
AQBANKING_API void AB_Transaction_SetModified(AB_TRANSACTION *st, int i);



/** @name Local Account Info
 *
This group contains information about the local account.*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_LocalCountry
*/
AQBANKING_API const char *AB_Transaction_GetLocalCountry(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalCountry
*/
AQBANKING_API void AB_Transaction_SetLocalCountry(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalBankCode
*/
AQBANKING_API const char *AB_Transaction_GetLocalBankCode(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalBankCode
*/
AQBANKING_API void AB_Transaction_SetLocalBankCode(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalBranchId
*/
AQBANKING_API const char *AB_Transaction_GetLocalBranchId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalBranchId
*/
AQBANKING_API void AB_Transaction_SetLocalBranchId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalAccountNumber
*/
AQBANKING_API const char *AB_Transaction_GetLocalAccountNumber(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalAccountNumber
*/
AQBANKING_API void AB_Transaction_SetLocalAccountNumber(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalSuffix
*/
AQBANKING_API const char *AB_Transaction_GetLocalSuffix(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalSuffix
*/
AQBANKING_API void AB_Transaction_SetLocalSuffix(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalIban
*/
AQBANKING_API const char *AB_Transaction_GetLocalIban(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalIban
*/
AQBANKING_API void AB_Transaction_SetLocalIban(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalName
*/
AQBANKING_API const char *AB_Transaction_GetLocalName(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalName
*/
AQBANKING_API void AB_Transaction_SetLocalName(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_LocalBic
*/
AQBANKING_API const char *AB_Transaction_GetLocalBic(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LocalBic
*/
AQBANKING_API void AB_Transaction_SetLocalBic(AB_TRANSACTION *el, const char *d);

/*@}*/

/** @name Remote Account Info
 *
This group contains information about the remote account.*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_RemoteCountry
*/
AQBANKING_API const char *AB_Transaction_GetRemoteCountry(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteCountry
*/
AQBANKING_API void AB_Transaction_SetRemoteCountry(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteBankName
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBankName(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteBankName
*/
AQBANKING_API void AB_Transaction_SetRemoteBankName(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteBankLocation
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBankLocation(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteBankLocation
*/
AQBANKING_API void AB_Transaction_SetRemoteBankLocation(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteBankCode
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBankCode(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteBankCode
*/
AQBANKING_API void AB_Transaction_SetRemoteBankCode(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteBranchId
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBranchId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteBranchId
*/
AQBANKING_API void AB_Transaction_SetRemoteBranchId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteAccountNumber
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAccountNumber(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteAccountNumber
*/
AQBANKING_API void AB_Transaction_SetRemoteAccountNumber(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteSuffix
*/
AQBANKING_API const char *AB_Transaction_GetRemoteSuffix(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteSuffix
*/
AQBANKING_API void AB_Transaction_SetRemoteSuffix(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteIban
*/
AQBANKING_API const char *AB_Transaction_GetRemoteIban(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteIban
*/
AQBANKING_API void AB_Transaction_SetRemoteIban(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteName
*/
AQBANKING_API const GWEN_STRINGLIST *AB_Transaction_GetRemoteName(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteName
*/
AQBANKING_API void AB_Transaction_SetRemoteName(AB_TRANSACTION *el, const GWEN_STRINGLIST *d);
AQBANKING_API void AB_Transaction_AddRemoteName(AB_TRANSACTION *st, const char *d, int chk);
AQBANKING_API void AB_Transaction_RemoveRemoteName(AB_TRANSACTION *st, const char *d);
AQBANKING_API void AB_Transaction_ClearRemoteName(AB_TRANSACTION *st);
AQBANKING_API int AB_Transaction_HasRemoteName(const AB_TRANSACTION *st, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteBic
*/
AQBANKING_API const char *AB_Transaction_GetRemoteBic(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteBic
*/
AQBANKING_API void AB_Transaction_SetRemoteBic(AB_TRANSACTION *el, const char *d);

/*@}*/

/**
* Returns the property @ref AB_TRANSACTION_UniqueId
*/
AQBANKING_API uint32_t AB_Transaction_GetUniqueId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_UniqueId
*/
AQBANKING_API void AB_Transaction_SetUniqueId(AB_TRANSACTION *el, uint32_t d);

/**
* Returns the property @ref AB_TRANSACTION_IdForApplication
*/
AQBANKING_API uint32_t AB_Transaction_GetIdForApplication(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_IdForApplication
*/
AQBANKING_API void AB_Transaction_SetIdForApplication(AB_TRANSACTION *el, uint32_t d);

/**
* Returns the property @ref AB_TRANSACTION_GroupId
*/
AQBANKING_API uint32_t AB_Transaction_GetGroupId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_GroupId
*/
AQBANKING_API void AB_Transaction_SetGroupId(AB_TRANSACTION *el, uint32_t d);

/** @name Dates
*/
/*@{*/
/**
* Returns the property @ref AB_TRANSACTION_ValutaDate
*/
AQBANKING_API const GWEN_TIME *AB_Transaction_GetValutaDate(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_ValutaDate
*/
AQBANKING_API void AB_Transaction_SetValutaDate(AB_TRANSACTION *el, const GWEN_TIME *d);

/**
* Returns the property @ref AB_TRANSACTION_Date
*/
AQBANKING_API const GWEN_TIME *AB_Transaction_GetDate(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Date
*/
AQBANKING_API void AB_Transaction_SetDate(AB_TRANSACTION *el, const GWEN_TIME *d);

/*@}*/

/** @name Value
 *
*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_Value
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetValue(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Value
*/
AQBANKING_API void AB_Transaction_SetValue(AB_TRANSACTION *el, const AB_VALUE *d);

/*@}*/

/**
* Returns the property @ref AB_TRANSACTION_Fees
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetFees(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Fees
*/
AQBANKING_API void AB_Transaction_SetFees(AB_TRANSACTION *el, const AB_VALUE *d);

/** @name Info Which Is Not Supported by All Backends
 *
<p>This group contains information which differ between backends.</p>
<p>Some of this information might not even be<b>supported</b>by every backends.</p>*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_TextKey
*/
AQBANKING_API int AB_Transaction_GetTextKey(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_TextKey
*/
AQBANKING_API void AB_Transaction_SetTextKey(AB_TRANSACTION *el, int d);

/**
* Returns the property @ref AB_TRANSACTION_TextKeyExt
*/
AQBANKING_API int AB_Transaction_GetTextKeyExt(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_TextKeyExt
*/
AQBANKING_API void AB_Transaction_SetTextKeyExt(AB_TRANSACTION *el, int d);

/**
* Returns the property @ref AB_TRANSACTION_TransactionKey
*/
AQBANKING_API const char *AB_Transaction_GetTransactionKey(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_TransactionKey
*/
AQBANKING_API void AB_Transaction_SetTransactionKey(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_CustomerReference
*/
AQBANKING_API const char *AB_Transaction_GetCustomerReference(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_CustomerReference
*/
AQBANKING_API void AB_Transaction_SetCustomerReference(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_BankReference
*/
AQBANKING_API const char *AB_Transaction_GetBankReference(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_BankReference
*/
AQBANKING_API void AB_Transaction_SetBankReference(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_EndToEndReference
*/
AQBANKING_API const char *AB_Transaction_GetEndToEndReference(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_EndToEndReference
*/
AQBANKING_API void AB_Transaction_SetEndToEndReference(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_MandateReference
*/
AQBANKING_API const char *AB_Transaction_GetMandateReference(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_MandateReference
*/
AQBANKING_API void AB_Transaction_SetMandateReference(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_CreditorIdentifier
*/
AQBANKING_API const char *AB_Transaction_GetCreditorIdentifier(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_CreditorIdentifier
*/
AQBANKING_API void AB_Transaction_SetCreditorIdentifier(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_OriginatorIdentifier
*/
AQBANKING_API const char *AB_Transaction_GetOriginatorIdentifier(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_OriginatorIdentifier
*/
AQBANKING_API void AB_Transaction_SetOriginatorIdentifier(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_TransactionCode
*/
AQBANKING_API int AB_Transaction_GetTransactionCode(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_TransactionCode
*/
AQBANKING_API void AB_Transaction_SetTransactionCode(AB_TRANSACTION *el, int d);

/**
* Returns the property @ref AB_TRANSACTION_TransactionText
*/
AQBANKING_API const char *AB_Transaction_GetTransactionText(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_TransactionText
*/
AQBANKING_API void AB_Transaction_SetTransactionText(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_Primanota
*/
AQBANKING_API const char *AB_Transaction_GetPrimanota(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Primanota
*/
AQBANKING_API void AB_Transaction_SetPrimanota(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_FiId
*/
AQBANKING_API const char *AB_Transaction_GetFiId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_FiId
*/
AQBANKING_API void AB_Transaction_SetFiId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_Purpose
*/
AQBANKING_API const GWEN_STRINGLIST *AB_Transaction_GetPurpose(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Purpose
*/
AQBANKING_API void AB_Transaction_SetPurpose(AB_TRANSACTION *el, const GWEN_STRINGLIST *d);
AQBANKING_API void AB_Transaction_AddPurpose(AB_TRANSACTION *st, const char *d, int chk);
AQBANKING_API void AB_Transaction_RemovePurpose(AB_TRANSACTION *st, const char *d);
AQBANKING_API void AB_Transaction_ClearPurpose(AB_TRANSACTION *st);
AQBANKING_API int AB_Transaction_HasPurpose(const AB_TRANSACTION *st, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_Category
*/
AQBANKING_API const GWEN_STRINGLIST *AB_Transaction_GetCategory(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Category
*/
AQBANKING_API void AB_Transaction_SetCategory(AB_TRANSACTION *el, const GWEN_STRINGLIST *d);
AQBANKING_API void AB_Transaction_AddCategory(AB_TRANSACTION *st, const char *d, int chk);
AQBANKING_API void AB_Transaction_RemoveCategory(AB_TRANSACTION *st, const char *d);
AQBANKING_API void AB_Transaction_ClearCategory(AB_TRANSACTION *st);
AQBANKING_API int AB_Transaction_HasCategory(const AB_TRANSACTION *st, const char *d);

/*@}*/

/** @name Additional Information for Standing Orders
 *
<p>This group contains information which is used with standing orders. It is not needed for other usage of this type.</p>*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_Period
*/
AQBANKING_API AB_TRANSACTION_PERIOD AB_Transaction_GetPeriod(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Period
*/
AQBANKING_API void AB_Transaction_SetPeriod(AB_TRANSACTION *el, AB_TRANSACTION_PERIOD d);

/**
* Returns the property @ref AB_TRANSACTION_Cycle
*/
AQBANKING_API int AB_Transaction_GetCycle(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Cycle
*/
AQBANKING_API void AB_Transaction_SetCycle(AB_TRANSACTION *el, int d);

/**
* Returns the property @ref AB_TRANSACTION_ExecutionDay
*/
AQBANKING_API int AB_Transaction_GetExecutionDay(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_ExecutionDay
*/
AQBANKING_API void AB_Transaction_SetExecutionDay(AB_TRANSACTION *el, int d);

/**
* Returns the property @ref AB_TRANSACTION_FirstExecutionDate
*/
AQBANKING_API const GWEN_TIME *AB_Transaction_GetFirstExecutionDate(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_FirstExecutionDate
*/
AQBANKING_API void AB_Transaction_SetFirstExecutionDate(AB_TRANSACTION *el, const GWEN_TIME *d);

/**
* Returns the property @ref AB_TRANSACTION_LastExecutionDate
*/
AQBANKING_API const GWEN_TIME *AB_Transaction_GetLastExecutionDate(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_LastExecutionDate
*/
AQBANKING_API void AB_Transaction_SetLastExecutionDate(AB_TRANSACTION *el, const GWEN_TIME *d);

/**
* Returns the property @ref AB_TRANSACTION_NextExecutionDate
*/
AQBANKING_API const GWEN_TIME *AB_Transaction_GetNextExecutionDate(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_NextExecutionDate
*/
AQBANKING_API void AB_Transaction_SetNextExecutionDate(AB_TRANSACTION *el, const GWEN_TIME *d);

/*@}*/

/** @name Additional Information for Transfers
 *
<p>This group contains information which is used with all kinds of transfers. It is setup by the function @ref AB_Banking_GatherResponses for transfers but not used by AqBanking otherwise.</p>*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_Type
*/
AQBANKING_API AB_TRANSACTION_TYPE AB_Transaction_GetType(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Type
*/
AQBANKING_API void AB_Transaction_SetType(AB_TRANSACTION *el, AB_TRANSACTION_TYPE d);

/**
* Returns the property @ref AB_TRANSACTION_SubType
*/
AQBANKING_API AB_TRANSACTION_SUBTYPE AB_Transaction_GetSubType(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_SubType
*/
AQBANKING_API void AB_Transaction_SetSubType(AB_TRANSACTION *el, AB_TRANSACTION_SUBTYPE d);

/**
* Returns the property @ref AB_TRANSACTION_Status
*/
AQBANKING_API AB_TRANSACTION_STATUS AB_Transaction_GetStatus(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Status
*/
AQBANKING_API void AB_Transaction_SetStatus(AB_TRANSACTION *el, AB_TRANSACTION_STATUS d);

/**
* Returns the property @ref AB_TRANSACTION_Charge
*/
AQBANKING_API AB_TRANSACTION_CHARGE AB_Transaction_GetCharge(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Charge
*/
AQBANKING_API void AB_Transaction_SetCharge(AB_TRANSACTION *el, AB_TRANSACTION_CHARGE d);

/*@}*/

/** @name Additional Information for Foreign Transfers
 *
<p>This group contains information which is used with transfers to other countries in the world. It is used by backends and applications but not by AqBanking itself.</p>*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_RemoteAddrStreet
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrStreet(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteAddrStreet
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrStreet(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteAddrZipcode
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrZipcode(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteAddrZipcode
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrZipcode(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemoteAddrCity
*/
AQBANKING_API const char *AB_Transaction_GetRemoteAddrCity(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemoteAddrCity
*/
AQBANKING_API void AB_Transaction_SetRemoteAddrCity(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_RemotePhone
*/
AQBANKING_API const char *AB_Transaction_GetRemotePhone(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_RemotePhone
*/
AQBANKING_API void AB_Transaction_SetRemotePhone(AB_TRANSACTION *el, const char *d);

/*@}*/

/** @name Additional Information for Investment Transfers
 *
<p>This group contains information which is used with investment/stock transfers. It is used by backends and applications but not by AqBanking itself.</p>*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_UnitId
*/
AQBANKING_API const char *AB_Transaction_GetUnitId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_UnitId
*/
AQBANKING_API void AB_Transaction_SetUnitId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_UnitIdNameSpace
*/
AQBANKING_API const char *AB_Transaction_GetUnitIdNameSpace(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_UnitIdNameSpace
*/
AQBANKING_API void AB_Transaction_SetUnitIdNameSpace(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_Units
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetUnits(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Units
*/
AQBANKING_API void AB_Transaction_SetUnits(AB_TRANSACTION *el, const AB_VALUE *d);

/**
* Returns the property @ref AB_TRANSACTION_UnitPrice
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetUnitPrice(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_UnitPrice
*/
AQBANKING_API void AB_Transaction_SetUnitPrice(AB_TRANSACTION *el, const AB_VALUE *d);

/**
* Returns the property @ref AB_TRANSACTION_Commission
*/
AQBANKING_API const AB_VALUE *AB_Transaction_GetCommission(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_Commission
*/
AQBANKING_API void AB_Transaction_SetCommission(AB_TRANSACTION *el, const AB_VALUE *d);

/*@}*/

/** @name Additional Information for SEPA Direct Debits
 *
<p>This group contains information which is used with SEPA transfers within the European Community. It is used by backends and applications but not by AqBanking itself.</p>*/
/*@{*/

/**
* Returns the property @ref AB_TRANSACTION_CreditorSchemeId
*/
AQBANKING_API const char *AB_Transaction_GetCreditorSchemeId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_CreditorSchemeId
*/
AQBANKING_API void AB_Transaction_SetCreditorSchemeId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_MandateId
*/
AQBANKING_API const char *AB_Transaction_GetMandateId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_MandateId
*/
AQBANKING_API void AB_Transaction_SetMandateId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_MandateDate
*/
AQBANKING_API const GWEN_DATE *AB_Transaction_GetMandateDate(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_MandateDate
*/
AQBANKING_API void AB_Transaction_SetMandateDate(AB_TRANSACTION *el, const GWEN_DATE *d);

/**
* Returns the property @ref AB_TRANSACTION_MandateDebitorName
*/
AQBANKING_API const char *AB_Transaction_GetMandateDebitorName(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_MandateDebitorName
*/
AQBANKING_API void AB_Transaction_SetMandateDebitorName(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_OriginalCreditorSchemeId
*/
AQBANKING_API const char *AB_Transaction_GetOriginalCreditorSchemeId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_OriginalCreditorSchemeId
*/
AQBANKING_API void AB_Transaction_SetOriginalCreditorSchemeId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_OriginalMandateId
*/
AQBANKING_API const char *AB_Transaction_GetOriginalMandateId(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_OriginalMandateId
*/
AQBANKING_API void AB_Transaction_SetOriginalMandateId(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_OriginalCreditorName
*/
AQBANKING_API const char *AB_Transaction_GetOriginalCreditorName(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_OriginalCreditorName
*/
AQBANKING_API void AB_Transaction_SetOriginalCreditorName(AB_TRANSACTION *el, const char *d);

/**
* Returns the property @ref AB_TRANSACTION_SequenceType
*/
AQBANKING_API AB_TRANSACTION_SEQUENCETYPE AB_Transaction_GetSequenceType(const AB_TRANSACTION *el);
/**
* Set the property @ref AB_TRANSACTION_SequenceType
*/
AQBANKING_API void AB_Transaction_SetSequenceType(AB_TRANSACTION *el, AB_TRANSACTION_SEQUENCETYPE d);

/*@}*/


#ifdef __cplusplus
} /* __cplusplus */
#endif


#endif /* TRANSACTION_H */
