/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;

public class PgSequence {
    private String cache;
    private String increment;
    private String maxValue;
    private String minValue;
    private String name;
    private String startWith;
    private boolean cycle;
    private String ownedBy;
    private String comment;

    public PgSequence(String name) {
        this.name = name;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getCache() {
        return this.cache;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(100);
        sbSQL.append("CREATE SEQUENCE ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.name));
        if (this.startWith != null) {
            sbSQL.append("\n\tSTART WITH ");
            sbSQL.append(this.startWith);
        }
        if (this.increment != null) {
            sbSQL.append("\n\tINCREMENT BY ");
            sbSQL.append(this.increment);
        }
        sbSQL.append("\n\t");
        if (this.maxValue == null) {
            sbSQL.append("NO MAXVALUE");
        } else {
            sbSQL.append("MAXVALUE ");
            sbSQL.append(this.maxValue);
        }
        sbSQL.append("\n\t");
        if (this.minValue == null) {
            sbSQL.append("NO MINVALUE");
        } else {
            sbSQL.append("MINVALUE ");
            sbSQL.append(this.minValue);
        }
        if (this.cache != null) {
            sbSQL.append("\n\tCACHE ");
            sbSQL.append(this.cache);
        }
        if (this.cycle) {
            sbSQL.append("\n\tCYCLE");
        }
        sbSQL.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON SEQUENCE ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public String getOwnedBySQL() {
        StringBuilder sbSQL = new StringBuilder(100);
        sbSQL.append("ALTER SEQUENCE ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.name));
        if (this.ownedBy != null && !this.ownedBy.isEmpty()) {
            sbSQL.append("\n\tOWNED BY ");
            sbSQL.append(this.ownedBy);
        }
        sbSQL.append(';');
        return sbSQL.toString();
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public String getDropSQL() {
        return "DROP SEQUENCE " + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public void setIncrement(String increment) {
        this.increment = increment;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
    }

    public String getStartWith() {
        return this.startWith;
    }

    public String getOwnedBy() {
        return this.ownedBy;
    }

    public void setOwnedBy(String ownedBy) {
        this.ownedBy = ownedBy;
    }
}

