/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.text.MessageFormat;

public class CreateTableParser {
    public static void parse(PgDatabase database, String statement) {
        Parser parser = new Parser(statement);
        parser.expect("CREATE", "TABLE");
        parser.expectOptional("IF", "NOT", "EXISTS");
        String tableName = parser.parseIdentifier();
        PgTable table = new PgTable(ParserUtils.getObjectName(tableName));
        String schemaName = ParserUtils.getSchemaName(tableName, database);
        PgSchema schema = database.getSchema(schemaName);
        if (schema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), schemaName, statement));
        }
        schema.addTable(table);
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            if (parser.expectOptional("CONSTRAINT")) {
                CreateTableParser.parseConstraint(parser, table);
            } else {
                CreateTableParser.parseColumn(parser, table);
            }
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("INHERITS")) {
                CreateTableParser.parseInherits(parser, table);
                continue;
            }
            if (parser.expectOptional("WITHOUT")) {
                table.setWith("OIDS=false");
                continue;
            }
            if (parser.expectOptional("WITH")) {
                if (parser.expectOptional("OIDS") || parser.expectOptional("OIDS=true")) {
                    table.setWith("OIDS=true");
                    continue;
                }
                if (parser.expectOptional("OIDS=false")) {
                    table.setWith("OIDS=false");
                    continue;
                }
                table.setWith(parser.getExpression());
                continue;
            }
            if (parser.expectOptional("TABLESPACE")) {
                table.setTablespace(parser.parseString());
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseInherits(Parser parser, PgTable table) {
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            table.addInherits(ParserUtils.getObjectName(parser.parseIdentifier()));
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
    }

    private static void parseConstraint(Parser parser, PgTable table) {
        PgConstraint constraint = new PgConstraint(ParserUtils.getObjectName(parser.parseIdentifier()));
        table.addConstraint(constraint);
        constraint.setDefinition(parser.getExpression());
        constraint.setTableName(table.getName());
    }

    private static void parseColumn(Parser parser, PgTable table) {
        PgColumn column = new PgColumn(ParserUtils.getObjectName(parser.parseIdentifier()));
        table.addColumn(column);
        column.parseDefinition(parser.getExpression());
    }

    private CreateTableParser() {
    }
}

