/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.io.PrintWriter;

public class PgDiffFunctions {
    public static void createFunctions(PrintWriter writer, PgDiffArguments arguments, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgFunction newFunction : newSchema.getFunctions()) {
            PgFunction oldFunction = oldSchema == null ? null : oldSchema.getFunction(newFunction.getSignature());
            if (oldFunction != null && newFunction.equals(oldFunction, arguments.isIgnoreFunctionWhitespace())) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println(newFunction.getCreationSQL());
        }
    }

    public static void dropFunctions(PrintWriter writer, PgDiffArguments arguments, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgFunction oldFunction : oldSchema.getFunctions()) {
            if (newSchema.containsFunction(oldFunction.getSignature())) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println(oldFunction.getDropSQL());
        }
    }

    public static void alterComments(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgFunction oldfunction : oldSchema.getFunctions()) {
            boolean addComma;
            PgFunction newFunction = newSchema.getFunction(oldfunction.getSignature());
            if (newFunction == null) continue;
            if (oldfunction.getComment() == null && newFunction.getComment() != null || oldfunction.getComment() != null && newFunction.getComment() != null && !oldfunction.getComment().equals(newFunction.getComment())) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON FUNCTION ");
                writer.print(PgDiffUtils.getQuotedName(newFunction.getName()));
                writer.print('(');
                addComma = false;
                for (PgFunction.Argument argument : newFunction.getArguments()) {
                    if (addComma) {
                        writer.print(", ");
                    } else {
                        addComma = true;
                    }
                    writer.print(argument.getDeclaration(false));
                }
                writer.print(") IS ");
                writer.print(newFunction.getComment());
                writer.println(';');
                continue;
            }
            if (oldfunction.getComment() == null || newFunction.getComment() != null) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("COMMENT ON FUNCTION ");
            writer.print(PgDiffUtils.getQuotedName(newFunction.getName()));
            writer.print('(');
            addComma = false;
            for (PgFunction.Argument argument : newFunction.getArguments()) {
                if (addComma) {
                    writer.print(", ");
                } else {
                    addComma = true;
                }
                writer.print(argument.getDeclaration(false));
            }
            writer.println(") IS NULL;");
        }
    }

    private PgDiffFunctions() {
    }
}

