/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measurement {
    private Viewer viewer;
    public ModelSet modelSet;
    public int traceX = Integer.MIN_VALUE;
    public int traceY;
    protected int count;
    protected int[] countPlusIndices = new int[5];
    protected Point3fi[] pts;
    private String strMeasurement;
    private String strFormat;
    protected float value;
    private boolean isVisible = true;
    private boolean isHidden = false;
    private boolean isDynamic = false;
    private boolean isTrajectory = false;
    private short colix;
    private int index;
    private AxisAngle4f aa;
    private Point3f pointArc;
    public TickInfo tickInfo;

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = this.countPlusIndices[0] = n;
    }

    public int[] getCountPlusIndices() {
        return this.countPlusIndices;
    }

    public Point3fi[] getPoints() {
        return this.pts;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int n) {
        int n2 = this.countPlusIndices[n];
        return n2 < -1 ? this.pts[-2 - n2] : this.modelSet.atoms[n2];
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String getString(Viewer viewer, String string, String string2) {
        this.viewer = viewer;
        this.value = this.getMeasurement();
        this.formatMeasurement(string, string2, true);
        if (string == null) {
            return this.getInfoAsString(string2);
        }
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return (this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ", false) + " : " + this.value;
    }

    public String getStrFormat() {
        return this.strFormat;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isTrajectory() {
        return this.isTrajectory;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void setDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    public short getColix() {
        return this.colix;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public AxisAngle4f getAxisAngle() {
        return this.aa;
    }

    public Point3f getPointArc() {
        return this.pointArc;
    }

    public TickInfo getTickInfo() {
        return this.tickInfo;
    }

    public Measurement(ModelSet modelSet, Measurement measurement, float f, short s, String string, int n) {
        this.index = n;
        this.modelSet = modelSet;
        this.viewer = modelSet.viewer;
        this.colix = s;
        this.strFormat = string;
        if (measurement != null) {
            this.tickInfo = measurement.tickInfo;
            this.pts = measurement.pts;
        }
        if (this.pts == null) {
            this.pts = new Point3fi[4];
        }
        int[] nArray = measurement == null ? null : measurement.countPlusIndices;
        int n2 = this.count = nArray == null ? 0 : nArray[0];
        if (this.count > 0) {
            System.arraycopy(nArray, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectory(this.countPlusIndices);
        }
        this.value = Float.isNaN(f) || this.isTrajectory ? this.getMeasurement() : f;
        this.formatMeasurement(null);
    }

    public Measurement(ModelSet modelSet, int[] nArray, Point3fi[] point3fiArray, TickInfo tickInfo) {
        this.countPlusIndices = nArray;
        this.count = nArray[0];
        this.pts = point3fiArray == null ? new Point3fi[4] : point3fiArray;
        this.modelSet = modelSet;
        this.tickInfo = tickInfo;
    }

    public void refresh() {
        this.value = this.getMeasurement();
        this.isTrajectory = this.modelSet.isTrajectory(this.countPlusIndices);
        this.formatMeasurement(null);
    }

    public String getMeasurementScript(String string, boolean bl) {
        String string2 = "";
        boolean bl2 = string.equals(" ");
        for (int i = 1; i <= this.count; ++i) {
            string2 = string2 + (i > 1 ? string : " ") + this.getLabel(i, bl2, bl);
        }
        return string2;
    }

    public void formatMeasurement(String string, String string2, boolean bl) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!bl && string != null && string.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.strFormat = string;
        this.formatMeasurement(string2);
    }

    protected void formatMeasurement(String string) {
        this.strMeasurement = null;
        if (Float.isNaN(this.value) || this.count == 0) {
            return;
        }
        switch (this.count) {
            case 2: {
                this.strMeasurement = this.formatDistance(string);
                return;
            }
            case 3: {
                if (this.value == 180.0f) {
                    this.aa = null;
                    this.pointArc = null;
                } else {
                    Vector3f vector3f = new Vector3f();
                    Vector3f vector3f2 = new Vector3f();
                    float f = Measure.computeAngle(this.getAtom(1), this.getAtom(2), this.getAtom(3), vector3f, vector3f2, false);
                    Vector3f vector3f3 = new Vector3f();
                    vector3f3.cross(vector3f, vector3f2);
                    this.aa = new AxisAngle4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                    vector3f.normalize();
                    vector3f.scale(0.5f);
                    this.pointArc = new Point3f(vector3f);
                }
            }
            case 4: {
                this.strMeasurement = this.formatAngle(this.value);
                return;
            }
        }
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.viewer.isSelected(this.countPlusIndices[1]) && this.viewer.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement(null);
        }
    }

    private String formatDistance(String string) {
        if (string == null) {
            string = this.viewer.getMeasureDistanceUnits();
        }
        string = Measurement.fixUnits(string);
        float f = Measurement.fixValue(this.value, string);
        return this.formatString(f, string);
    }

    private static String fixUnits(String string) {
        if (string == "nanometers") {
            return "nm";
        }
        if (string == "picometers") {
            return "pm";
        }
        if (string == "angstroms") {
            return "\u00c5";
        }
        return string;
    }

    private static float fixValue(float f, String string) {
        if (string != null) {
            if (string.equals("nm")) {
                return (float)((int)(f * 100.0f + 0.5f)) / 1000.0f;
            }
            if (string.equals("pm")) {
                return (float)((int)((double)(f * 1000.0f) + 0.5)) / 10.0f;
            }
            if (string.equals("au")) {
                return (float)((int)(f / 0.5291772f * 1000.0f + 0.5f)) / 1000.0f;
            }
        }
        return (float)((int)(f * 100.0f + 0.5f)) / 100.0f;
    }

    private String formatAngle(float f) {
        f = (int)(f * 10.0f + (f >= 0.0f ? 0.5f : -0.5f));
        return this.formatString(f /= 10.0f, "\u00b0");
    }

    private String formatString(float f, String string) {
        String string2;
        String string3 = this.countPlusIndices[0] + ":" + "";
        String string4 = string2 = this.strFormat != null && this.strFormat.indexOf(string3) == 0 ? this.strFormat : this.viewer.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        if (string2.indexOf(string3) == 0) {
            string2 = string2.substring(2);
        }
        return LabelToken.formatLabel(this.viewer, this, string2, f, string);
    }

    public boolean sameAs(int[] nArray, Point3fi[] point3fiArray) {
        int n;
        if (this.count != nArray[0]) {
            return false;
        }
        boolean bl = true;
        for (n = 1; n <= this.count && bl; ++n) {
            bl = this.countPlusIndices[n] == nArray[n];
        }
        if (bl) {
            for (n = 0; n < this.count && bl; ++n) {
                if (point3fiArray[n] == null) continue;
                bl = (double)this.pts[n].distance(point3fiArray[n]) < 0.01;
            }
        }
        if (bl) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAs(nArray, point3fiArray, 1, 2) && this.sameAs(nArray, point3fiArray, 2, 1);
            }
            case 3: {
                return this.sameAs(nArray, point3fiArray, 1, 3) && this.sameAs(nArray, point3fiArray, 2, 2) && this.sameAs(nArray, point3fiArray, 3, 1);
            }
            case 4: 
        }
        return this.sameAs(nArray, point3fiArray, 1, 4) && this.sameAs(nArray, point3fiArray, 2, 3) && this.sameAs(nArray, point3fiArray, 3, 2) && this.sameAs(nArray, point3fiArray, 4, 1);
    }

    private boolean sameAs(int[] nArray, Point3fi[] point3fiArray, int n, int n2) {
        int n3 = this.countPlusIndices[n];
        int n4 = nArray[n2];
        return n3 >= 0 || n4 >= 0 ? n3 == n4 : (double)this.pts[-2 - n3].distance(point3fiArray[-2 - n4]) < 0.01;
    }

    public boolean sameAs(int n, int n2) {
        return this.sameAs(this.countPlusIndices, this.pts, n, n2);
    }

    public List<String> toVector() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= this.count; ++i) {
            arrayList.add(this.getLabel(i, false, false));
        }
        arrayList.add(this.strMeasurement);
        return arrayList;
    }

    public float getMeasurement() {
        if (this.countPlusIndices == null) {
            return Float.NaN;
        }
        if (this.count < 2) {
            return Float.NaN;
        }
        int n = this.count;
        while (--n >= 0) {
            if (this.countPlusIndices[n + 1] != -1) continue;
            return Float.NaN;
        }
        Point3fi point3fi = this.getAtom(1);
        Point3fi point3fi2 = this.getAtom(2);
        switch (this.count) {
            case 2: {
                return point3fi.distance(point3fi2);
            }
            case 3: {
                Point3fi point3fi3 = this.getAtom(3);
                return Measure.computeAngle(point3fi, point3fi2, point3fi3, true);
            }
            case 4: {
                Point3fi point3fi4 = this.getAtom(3);
                Point3fi point3fi5 = this.getAtom(4);
                return Measure.computeTorsion(point3fi, point3fi2, point3fi4, point3fi5, true);
            }
        }
        return Float.NaN;
    }

    public String getLabel(int n, boolean bl, boolean bl2) {
        int n2 = this.countPlusIndices[n];
        return n2 < 0 ? (bl2 ? "modelIndex " + this.getAtom((int)n).modelIndex + " " : "") + Escape.escape(this.getAtom(n)) : (bl ? "(({" + n2 + "}))" : this.viewer.getAtomInfo(n2));
    }

    public void setModelIndex(short s) {
        if (this.pts == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.pts[i] == null) continue;
            this.pts[i].modelIndex = s;
        }
    }

    public boolean isValid() {
        return !(this.sameAs(1, 2) || this.count > 2 && this.sameAs(1, 3) || this.count == 4 && this.sameAs(2, 4));
    }

    public static int find(List<Measurement> list, Measurement measurement) {
        int[] nArray = measurement.getCountPlusIndices();
        Point3fi[] point3fiArray = measurement.getPoints();
        int n = list.size();
        while (--n >= 0) {
            if (!list.get(n).sameAs(nArray, point3fiArray)) continue;
            return n;
        }
        return -1;
    }

    public boolean isConnected(Atom[] atomArray, int n) {
        int n2 = -1;
        for (int i = 1; i <= n; ++i) {
            int n3 = this.getAtomIndex(i);
            if (n3 < 0) continue;
            if (n2 >= 0 && !atomArray[n3].isBonded(atomArray[n2])) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    public String getInfoAsString(String string) {
        float f = this.count == 2 ? Measurement.fixValue(this.value, string) : this.value;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.count == 2 ? "distance" : (this.count == 3 ? "angle" : "dihedral"));
        stringBuffer.append(" \t").append(f);
        stringBuffer.append(" \t").append(this.getString());
        for (int i = 1; i <= this.count; ++i) {
            stringBuffer.append(" \t").append(this.getLabel(i, false, false));
        }
        return stringBuffer.toString();
    }
}

