<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Utilisation du serveur HTTP Apache sous Microsoft Windows - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Notes spcifiques  un
  systme</a></div><div id="page-content"><div id="preamble"><h1>Utilisation du serveur HTTP Apache sous Microsoft Windows</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/platform/windows.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/platform/windows.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/platform/windows.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>


    <p>Ce document dcrit l'installation, la configuration et
    l'excution d'Apache 2.4 sous Microsoft Windows. Si vous avez des
    questions aprs avoir lu la documentation, ou si vous avez rencontr
    des vnements particuliers ou des rapports d'erreur, vous pouvez
    consultez la <a href="http://httpd.apache.org/userslist.html">liste
    de diffusion de la communaut des utilisateurs</a>.</p>

    <p>Dans ce document, nous supposons que vous installez une
    distribution binaire d'Apache. Si vous voulez compiler Apache
    vous-mme (par exemple pour aider au dveloppement ou pour
    rechercher des bogues), rfrez-vous au document <a href="win_compiling.html">Compilation d'Apache pour Microsoft
    Windows</a>.</p>

  </div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#req">Prrequis du systme d'exploitation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#down">Tlchargement d'Apache pour Windows</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cust">Personnaliser Apache pour Windows</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#winsvc">Excuter Apache en tant que service</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#wincons">Excuter Apache depuis la console</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#test">Vrification de l'installation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#windrivemap">Configuration de l'accs aux ressources rseau</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#tuning">Personnalisation sous Windows</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="req" id="req">Prrequis du systme d'exploitation</a></h2>
    

    <p>La plate-forme Windows de base pour l'excution d'Apache 2.4 est
    Windows 2000 ou suprieur. Veillez  toujours vous procurer et installer le
    dernier service pack afin d'viter les bogues du systme
    d'exploitation.</p>

    <div class="note">Les versions du serveur HTTP Apache suprieures  2.2 ne
    fonctionneront sous aucun systme d'exploitation d'une version
    antrieure  Windows 2000.</div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="down" id="down">Tlchargement d'Apache pour Windows</a></h2>
    

    <p>Le projet du serveur HTTP Apache proprement dit ne fournit pas de
    distribution binaire mais seulement le code source. Certains membres
    du projet <em>peuvent</em> mettre  disposition des paquets binaires
     titre individuel, mais ceux-ci n'ont pas vocation  tre
    distribus publiquement.</p>
    
    <p>Si vous n'tes
    pas en mesure de compiler le serveur HTTP Apache vous-mme, vous
    pouvez vous procurer un paquet binaire auprs des nombreuses
    distributions disponibles sur Internet.</p>

    <p>Quelques solutions populaires pour dployer Apache httpd, et
    ventuellement PHP et MySQL sous Microsoft Windows :</p>
    <ul>
    <li><a href="http://www.apachehaus.com/cgi-bin/download.plx">ApacheHaus</a></li>
    <li><a href="http://www.apachelounge.com/download/">Apache Lounge</a></li>
    <li><a href="http://bitnami.com/stack/wamp">BitNami WAMP Stack</a></li>
    <li><a href="http://www.wampserver.com/">WampServer</a></li>
    <li><a href="http://www.apachefriends.org/en/xampp.html">XAMPP</a></li>
    </ul>
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="cust" id="cust">Personnaliser Apache pour Windows</a></h2>
    

    <p>La configuration d'Apache est enregistre dans les fichiers du
    sous-rpertoire <code>conf</code>. Ce sont les mme fichiers que
    ceux utiliss pour configurer la version Unix, mais il y a quelques
    directives spcifiques  Apache pour Windows. Voir l'<a href="../mod/directives.html">index des directives</a> pour la liste
    des directives disponibles.</p>

    <p>Les principales spcificits d'Apache pour Windows sont :</p>
    <ul>
      <li><p>Comme Apache pour Windows est un programme multithread, il
      ne lance pas de processus spar pour chaque requte, comme Apache
      peut le faire sous Unix. En fait, il n'y a en gnral que deux
      processus Apache en excution : un processus parent, et un
      processus enfant qui traite les requtes. Chaque requte est
      traite par un thread spar au sein du processus enfant.</p>

      <p>Les directives de gestion de processus diffrent galement :</p>

      <p><code class="directive"><a href="../mod/mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></code>
      : comme dans la version Unix, cette directive contrle le nombre
      de connexions qu'un
      processus enfant particulier va traiter avant de s'arrter.
      Cependant,  la diffrence d'Unix, un processus de remplacement
      n'est pas instantanment disponible. Utilisez la dfinition par
      dfaut <code>MaxConnectionsPerChild 0</code>, sauf si vous
      risquez de manquer de mmoire dans des modules tiers ou dans des
      applications in-process.</p>

      <div class="warning"><strong>Attention : le fichier de
      configuration du serveur est recharg lorsqu'un nouveau processus
      enfant est dmarr. En consquence, si vous avez modifi
      <code>httpd.conf</code>, le nouveau processus enfant peut ne pas
      dmarrer, ou vous pouvez obtenir des rsultats
      inattendus.</strong></div>

      <p><code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code> : il
      s'agit d'une nouvelle directive. Elle indique au serveur le nombre
      de threads qu'il doit utiliser. Elle dfinit le nombre maximum de
      connexions simultanes que le serveur peut grer ; vous devez
      donc vous assurer que ce nombre soit suffisamment grand pour les
      besoins de votre site. La valeur par dfaut <code>ThreadsPerChild
      150</code> est recommande, mais doit tre ajuste  la valeur
      maximale estime de connexions simultanes  accepter.</p></li>

      <li><p>Les directives qui acceptent des noms de fichiers comme
      arguments doivent utiliser des noms de fichiers Windows et non
      Unix. Cependant, comme Apache peut interprter les anti-slashes
      comme des squences d'chappement de caractres, vous devez
      absolument utiliser des slashes dans les noms de chemins  la
      place des anti-slashes.</p></li>

      <li><p>Alors que les noms de fichiers sont en gnral insensibles
       la casse sous Windows, les URLs sont encore sensibles  la casse
      en interne avant d'tre mises en correspondance avec le systme de
      fichiers. Par exemple, les directives <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>, <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, et <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> utilisent toutes des
      arguments sensibles  la casse. Pour cette raison, il est
      particulirement recommand d'utiliser la directive <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> lorsqu'on
      dsire limiter l'accs  certains contenus du systme de fichiers,
      car cette directive s'applique  tout contenu d'un rpertoire,
      sans tenir compte de la manire dont on y accde. Pour vous
      assurer que seules des minuscules sont utilises dans les URLs,
      vous pouvez utiliser ceci :</p>

      <pre class="prettyprint lang-config">RewriteEngine On
RewriteMap lowercase int:tolower
RewriteCond "%{REQUEST_URI}" "[A-Z]"
RewriteRule "(.*)" "${lowercase:$1}" [R,L]</pre>
</li>

      <li><p>Lors de son excution, Apache n'a besoin d'un accs en
      criture qu'au rpertoire des journaux et  toute arborescence de
      rpertoires de cache configure. Suite au problme d'insensibilit
       la casse et au format de noms courts 8.3, Apache doit valider
      tous les noms de chemins fournis. Cela signifie que chaque
      rpertoire qu'Apache value doit avoir les droits en lecture,
      listage et parcours, et ceci depuis la racine jusqu'aux feuilles.
      Si Apache2.4 est install dans C:\Program Files, le rpertoire
      racine, Program Files et Apache2.4 doivent tous tre visibles pour
      Apache</p></li>

      <li><p>Apache peut charger divers modules sans qu'il soit ncessaire
      de recompiler le serveur. Si Apache est compil
      normalement, il va installer de nombreux modules optionnels dans
      le rpertoire <code>\Apache2.4\modules</code>. Pour activer ces
      modules ou d'autres modules, on doit utiliser la
      directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>. Par
      exemple, pour activer le module status, ajoutez la ligne suivante
      (en plus des directives d'activation de status dans
      <code>access.conf</code>) :</p>

      <pre class="prettyprint lang-config">LoadModule status_module modules/mod_status.so</pre>


      <p>Des informations sont aussi  votre disposition pour <a href="../mod/mod_so.html#creating">crer des modules
      chargeables</a></p></li>

      <li><p>Apache peut aussi charger des extensions ISAPI (Internet
      Server Application Programming Interface), comme celles qu'utilise
      Microsoft IIS et d'autres serveurs Windows. <a href="../mod/mod_isapi.html">Voir ici pour plus
      d'informations</a>. Notez qu'Apache ne peut <strong>pas</strong>
      charger de filtres ISAPI, et que les gestionnaires ISAPI contenant
      des extensions de fonctionnalits Microsoft ne fonctionneront
      pas.</p></li>

      <li><p>Pour les scripts CGI, la mthode qu'utilise Apache pour
      dterminer l'interprteur du script est configurable grce  la
      directive <code class="directive"><a href="../mod/core.html#scriptinterpretersource">ScriptInterpreterSource</a></code></p></li>

      <li><p>Comme il est souvent difficile de grer des fichiers avec
      des noms du style <code>.htaccess</code> sous Windows, vous avez
      tout intrt  changer le nom de ce fichier de configuration par
      rpertoire  l'aide de la directive <code class="directive"><a href="../mod/core.html#accessfilename">AccessFilename</a></code>.</p></li>

      <li><p>Toute erreur survenant au cours du processus de dmarrage
      d'Apache est enregistre dans le journal des vnements de
      Windows si l'on est sous Windows NT. Ce mcanisme fonctionne comme
      une sauvegarde pour les situations o Apache n'est pas encore prt
       utiliser le fichier <code>error.log</code>. Vous pouvez
      consulter le journal des vnements applicatifs Windows en
      utilisant l'observateur d'vnements : Dmarrage - Paramtres -
      Panneau de configuration - Outils d'administration - Observateur
      d'vnements.</p></li>
    </ul>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="winsvc" id="winsvc">Excuter Apache en tant que service</a></h2>
    

    <p>Apache fournit un utilitaire nomm Apache Service Monitor
    (Moniteur du service Apache). Grce  lui, vous pouvez voir et grer
    l'tat de tous les services Apache installs sur toutes les machines
    du rseau. Pour pouvoir grer un service Apache avec le moniteur,
    vous devez d'abord installer le service (soit automatiquement au
    cours de l'installation, soit manuellement).</p>

    <p>Vous pouvez installer Apache en tant que service Windows NT 
    partir de la ligne de commandes et depuis le sous-rpertoire Apache
    <code>bin</code> comme suit :</p>

    <div class="example"><p><code>
      httpd.exe -k install
    </code></p></div>

    <p>Si vous avez install plusieurs services Apache sur votre
    ordinateur, vous devrez spcifier le nom du service que vous voulez
    installer en utilisant la commande suivante (notez que si vous
    spcifiez un nom durant l'installation, vous devrez aussi le
    spcifier pour toute opration comportant l'option -k) :</p>

    <div class="example"><p><code>
      httpd.exe -k install -n "Nom-service"
    </code></p></div>

    <p>Si un service doit utiliser un fichier de configuration
    spcifique, utilisez ceci :</p>

    <div class="example"><p><code>
      httpd.exe -k install -n "Nom-service" -f "c:\fichiers\Nom-service.conf"
    </code></p></div>

    <p>Si vous utilisez la premire commande sans paramtre particulier,
    except <code>-k install</code>, le service aura pour nom
    <code>Apache2.4</code> et le fichier de configuration sera cens
    tre <code>conf\httpd.conf</code>.</p>

    <p>Supprimer un service Apache est trs simple. Utilisez
    simplement :</p>

    <div class="example"><p><code>
      httpd.exe -k uninstall
    </code></p></div>

    <p>On peut spcifier un service Apache particulier en utilisant
    :</p>

    <div class="example"><p><code>
      httpd.exe -k uninstall -n "Nom service"
    </code></p></div>

    <p>Normalement, le dmarrage, le redmarrage et l'arrt d'un
    service Apache s'effectuent via le Moniteur de Service Apache, ou en
    utilisant des commandes telles que <code>NET START Apache2.4</code> et
    <code>NET STOP Apache2.4</code>, ou encore via le gestionnaire de
    services standard de Windows. Avant de dmarrer Apache en tant que
    service dans quelque but que ce soit, vous devez tester le fichier
    de configuration du service en utilisant :</p>

    <div class="example"><p><code>
      httpd.exe -n "Nom-service" -t
    </code></p></div>

    <p>Vous pouvez aussi contrler un service Apache  l'aide de ses
    options de ligne de commande. Avec cette mthode, pour dmarrer un
    service Apache install, vous utiliserez :</p>

    <div class="example"><p><code>
      httpd.exe -k start -n "Nom-Service"
    </code></p></div>

    <p>Pour arrter un service Apache via les options de lignes de
    commande, utilisez ceci :</p>

    <div class="example"><p><code>
      httpd.exe -k stop -n "Nom-Service"
    </code></p></div>

    <p>ou</p>

    <div class="example"><p><code>
      httpd.exe -k shutdown -n "Nom-Service"
    </code></p></div>

    <p>Vous pouvez aussi redmarrer un service en excution et le forcer
     relire son fichier de configuration en utilisant :</p>

    <div class="example"><p><code>
      httpd.exe -k restart -n "Nom-Service"
    </code></p></div>

    <p>Par dfaut, tous les services Apache sont configurs pour
    s'excuter sous l'utilisateur system (le compte
    <code>LocalSystem</code>). Le compte <code>LocalSystem</code> n'a
    pas de privilges sur votre rseau, que ce soit via un mcanisme
    scuris de Windows, y compris le systme de fichiers, des tubes
    nomms, DCOM ou des RPC scuriss. Il a cependant des privilges
    levs en local.</p>

    <div class="warning"><strong>N'accordez jamais de privilges rseau
    au compte <code>LocalSystem</code> ! Si Apache doit pouvoir accder
     des ressources rseau, crez un compte spar pour Apache comme
    indiqu ci-dessous.</strong></div>

    <p>Il est fortement fortement conseill aux utilisateurs de crer un
    compte spar pour excuter le(s) service(s) Apache, et mme
    obligatoire si vous devez accder  des ressources rseau via
    Apache.</p>

    <ol>
      <li>Crez un compte d'utilisateur du domaine normal, et
      assurez-vous de retenir son mot de passe.</li>

      <li>Accordez  l'utilisateur nouvellement cr les privilges
      <code>Log on as a service</code> et <code>Act as part of the
      operating system</code>. Sous Windows NT 4.0, ces privilges sont
      accords via le Gestionnaire des utilisateurs du Domaine, mais
      sous Windows 2000 et XP, vous aurez plutt intrt  utiliser une
      GPO pour propager ces configurations. Vous pouvez aussi effectuer
      ces rglages via la Politique de Scurit Locale intgre  la
      MMC.</li>

      <li>Vrifiez que le compte nouvellement cr est membre du groupe
      Utilisateurs</li>

      <li>Accordez  ce compte les droits Lecture et Excution (RX) sur
      tous les documents et rpertoires de scripts (<code>htdocs</code>
      et <code>cgi-bin</code> par exemple), et aussi sur l'excutable
      binaire <code>httpd.exe</code>.</li>

      <li>Accordez aussi  ce compte les droits de modification sur le
      rpertoire <code>logs</code>.</li>

    </ol>

    <div class="note">Il est en gnral de bonne pratique d'accorder  l'utilisateur
    sous lequel le service Apache s'excute les droits en lecture et
    excution (RX) sur l'ensemble du rpertoire Apache2.4, sauf pour le
    sous-rpertoire <code>logs</code>, sur lequel l'utilisateur doit
    avoir au moins les droits de modification (RWXD).</div>

    <p>Si vous permettez  ce compte de se connecter en tant
    qu'utilisateur et service, vous pouvez ouvrir une session sous ce
    compte et vrifier s'il a bien le droit d'excuter les scripts, de
    lire les pages web, et si vous pouvez dmarrer Apache  partir d'une
    console Windows. Si tout fonctionne, et si vous avez suivi les
    tapes ci-dessus, Apache devrait s'excuter en tant que service sans
    problme.</p>

    <div class="note"><strong>Le code d'erreur 2186</strong> indique probablement
    qu'Apache ne peut pas accder  une ressource rseau ncessaire, et
    que vous devez revoir la configuration "Log On As" (Se connecter en
    tant que ...) du service.</div>

    <p>Lorsqu'Apache dmarre en tant que service, il se peut que vous
    obteniez un message d'erreur du Gestionnaire de Services Windows.
    Par exemple, si vous essayez de dmarrer Apache en utilisant
    l'applet Services du Panneau de configuration de Windows, vous
    pouvez obtenir le message suivant :</p>

    <div class="example"><p><code>
      Could not start the Apache2.4 service on \\COMPUTER <br />
      Error 1067; The process terminated unexpectedly.
    </code></p></div>

    <p>Vous obtiendrez cette erreur  caractre gnral pour tout
    problme survenant au cours du dmarrage du service Apache. Afin de
    dterminer exactement la cause du problme, vous devez suivre les
    instructions permettant d'excuter Apache pour Windows depuis la
    ligne de commande.</p>

    <p>Si vous rencontrez des problmes avec le service, il est
    conseill de suivre les instructions ci-dessous afin d'essayer de
    dmarrer httpd.exe depuis une console, et d'analyser les erreurs
    plutt que vous dmener  essayer de dmarrer le service.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="wincons" id="wincons">Excuter Apache depuis la console</a></h2>
    

    <p>Il est en gnral recommand d'excuter Apache en tant que
    service, mais il est parfois plus simple d'utiliser la ligne de
    commande, en particulier au cours de la configuration initiale et
    les tests.</p>

    <p>Pour excuter Apache depuis la ligne de commande et en tant
    qu'application de console, utilisez la commande suivante :</p>

    <div class="example"><p><code>
      httpd.exe
    </code></p></div>

    <p>Apache va dmarrer, et continuera son excution jusqu' ce qu'on
    l'arrte en tapant Ctrl-C.</p>

    <p>Vous pouvez galement dmarrer Apache via le raccourci "Dmarrer
    Apache dans une console" plac dans <code>Dmarrer --&gt;
    Programmes --&gt; Apache HTTP Server 2.4.xx --&gt; Control Apache
    Server</code> au cours de l'installation. Ceci va
    ouvrir une console Windows, et y dmarrer Apache.
    Si vous n'avez pas install Apache en tant que service, la
    fentre Windows restera ouverte jusqu' ce que vous arrtiez Apache
    en tapant Ctrl-C dans cette fentre. Le serveur va alors s'arrter
    au bout de quelques secondes. Cependant, si vous avez install
    Apache en tant que service, c'est ce dernier que le raccourci
    ci-dessus va lancer. Si le service Apache est dj en cours
    d'excution, le raccourci va rester sans effet.</p>

    <p>Si Apache s'excute en tant que service, vous pouvez l'arrter en
    ouvrant une autre console et en entrant :</p>

    <div class="example"><p><code>
      httpd.exe -k shutdown
    </code></p></div>

    <p>Plutt que de lancer Apache  partir d'une console, il est
    prfrable de l'excuter en tant que service car dans ce cas, il
    termine proprement les oprations en cours avant de s'teindre.</p>

    <p>Si le serveur a t lanc depuis une console, vous ne pouvez
    l'arrter qu'en pressant la combinaison de touches Ctrl-C dans la
    mme fentre.</p>

    <p>Vous pouvez aussi redmarrer Apache. Ceci le force  recharger
    son fichier de configuration. Toute opration en cours peut tre
    acheve sans interruption. Pour redmarrer Apache, vous pouvez soit
    taper Control-Break dans la fentre de console que vous avez
    utilise pour le dmarrer, soit entrer :</p>

    <div class="example"><p><code>
      httpd.exe -k restart
    </code></p></div>

    <p>si le serveur s'excute en tant que service.</p>

    <div class="note">Note pour les utilisateurs familiers de la version Unix
    d'Apache : les commandes ci-dessus reprsentent pour Windows
    l'quivalent des commandes <code>kill -TERM <em>pid</em></code> et
    <code>kill -USR1 <em>pid</em></code>. L'option de ligne de commande
    <code>-k</code> a t choisie  titre de rapprochement avec la
    commande <code>kill</code> utilise sous Unix.</div>

    <p>Si la fentre de la console Apache se ferme immdiatement ou
    inopinment aprs le dmarrage d'Apache, ouvrez une console Windows
    depuis le menu Dmarrer --&gt; Programmes. Placez-vous dans le
    rpertoire d'installation d'Apache, tapez la commande
    <code>httpd.exe</code>, et observez le message d'erreur. Allez
    ensuite dans le rpertoire des journaux, et visualisez le fichier
    <code>error.log</code> pour dtecter d'ventuelles erreurs de
    configuration. Si Apache a t install dans <code>C:\Program
    Files\Apache Software Foundation\Apache2.4\</code>, vous
    pouvez entrer ce qui suit :</p>

    <div class="example"><p><code>
      c: <br />
      cd "\Program Files\Apache Software Foundation\Apache2.4\bin" <br />
      httpd.exe
    </code></p></div>

    <p>Attendez ensuite qu'Apache s'arrte ou tapez Ctrl-C. Entrez alors
    la commande suivante :</p>

    <div class="example"><p><code>
      cd ..\logs <br />
      more &lt; error.log
    </code></p></div>

    <p>Lorsqu'on travaille avec Apache, il est important de comprendre
    comment ce dernier trouve son fichier de configuration. Vous pouvez
    spcifier un fichier de configuration  partir de la ligne de
    commande de deux faons :</p>

    <ul>
      <li><p>L'option <code>-f</code> permet de spcifier un chemin
      absolu ou relatif vers un fichier de configuration particulier
      :</p>(sous Windows 9x, il est recommand d'utiliser la ligne de
    commande  cause du manque de fiabilit du support des services
    fourni par ce systme).

      <div class="example"><p><code>
        httpd.exe -f "c:\fichiers-de-mon-serveur\autre-config.conf"
      </code></p></div>

      <p>ou</p>

      <div class="example"><p><code>
        httpd.exe -f fichiers-de-mon-serveur\autre-config.conf
      </code></p></div></li>

      <li><p>L'option <code>-n</code> permet de spcifier le service
      Apache install dont le fichier de configuration doit tre utilis
      :</p>

      <div class="example"><p><code>
        httpd.exe -n "Nom-service"
      </code></p></div>
      </li>
    </ul>

    <p>Dans les deux cas, la directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code> doit tre correctement dfinie
    dans le fichier de configuration.</p>

    <p>Si vous ne spcifiez aucun fichier de configuration  l'aide des
    options <code>-f</code> ou <code>-n</code>, Apache utilisera le nom
    du fichier de configuration compil dans le serveur, en gnral
    <code>conf\httpd.conf</code>. Ce chemin cod en dur est relatif au
    rpertoire d'installation. Vous pouvez vrifier ce chemin  partir
    de la valeur de l'tiquette <code>SERVER_CONFIG_FILE</code> en
    invoquant Apache avec l'option <code>-V</code>, comme ceci :</p>

    <div class="example"><p><code>
      httpd.exe -V
    </code></p></div>

    <p>Apache va ensuite essayer de dterminer la valeur de son
    <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code> en effectuant les
    recherches suivantes, dans cet ordre :</p>

    <ol>
      <li>Une directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>
      via l'option de ligne de commande <code>-C</code>.</li>

      <li>L'option de ligne de commande <code>-d</code>.</li>

      <li>Le rpertoire de travail courant.</li>

      <li>Une entre de la base de registre cre dans le cas d'une
      installation binaire.</li>

      <li>La racine des documents (<code>DocumentRoot</code>) code en dur
      dans le serveur. Elle
      correspond par dfaut  <code>/apache</code>, et vous pouvez le
      vrifier en tapant <code>httpd.exe -V</code> et en recherchant
      l'tiquette <code>HTTPD_ROOT</code>.</li>
    </ol>

    <p>Si vous n'avez pas effectu d'installation binaire, dans certains
    scnarios, Apache va signaler l'absence de cette cl de registre.
    On peut passer outre cet avertissement si le serveur a t en mesure
    de trouver son fichier de configuration d'une autre manire.</p>

    <p>La valeur de cette cl correspond au rpertoire <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code> qui contient lui-mme le
    sous-rpertoire <code>conf</code>. Lors de son dmarrage, Apache lit
    le fichier <code>httpd.conf</code>  partir de ce rpertoire. Si ce
    fichier contient une directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code> qui spcifie un rpertoire
    diffrent de celui que contient la cl de registre ci-dessus, Apache
    oubliera la cl de registre, et utilisera le rpertoire spcifi par
    le fichier de configuration. Si vous dplacez le rpertoire Apache
    ou ses fichiers de configuration, il est vital de mettre  jour la
    directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code> dans
    <code>httpd.conf</code> afin de reflter la nouvelle
    localisation.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="test" id="test">Vrification de l'installation</a></h2>
    

    <p>Une fois Apache dmarr (soit  partir d'une console Windows,
    soit en tant que service), ce dernier va se mettre  l'coute sur
    le port 80 ( moins que vous ayiez modifi la directive <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> dans les fichiers de
    configuration ou que vous ayiez install Apache pour l'utilisateur
    courant seulement). Pour vous connecter au serveur et accder  la
    page par dfaut, lancez un navigateur et entrez cette URL :</p>

    <div class="example"><p><code>
      http://localhost/
    </code></p></div>

    <p>Apache devrait renvoyer une page de bienvenue et vous devriez
    voir s'afficher "It Works!". Si rien ne se passe ou si vous obtenez
    une erreur, consultez le fichier <code>error.log</code> dans le
    sous-rpertoire <code>logs</code>. Si votre serveur n'est pas
    connect au rseau, ou si vous avez de srieux problmes avec la
    configuration de votre DNS (Domain Name Service), vous devez
    utiliser cette URL :</p>

    <div class="example"><p><code>
      http://127.0.0.1/
    </code></p></div>

    <p>Si Apache coute un port non standard, vous devez le prciser
    explicitement dans l'URL :</p>

    <div class="example"><p><code>
      http://127.0.0.1:8080/
    </code></p></div>

    <p>Aprs que votre installation de base fonctionne, vous devez la
    configurer correctement en ditant les fichiers du sous-rpertoire
    <code>conf</code>. Encore une fois, si vous modifiez la
    configuration du service Apache sous Windows NT, essayez d'abord de
    redmarrer le service depuis la ligne de commande afin de vous
    assurer de l'absence d'erreur.</p>

    <p>Comme Apache <strong>ne peut pas</strong> partager le mme port
    avec d'autres applications TCP/IP, il se peut que vous soyez amen 
    arrter, dsinstaller ou reconfigurer certains services avant de
    dmarrer Apache. Ces services entrant en conflit avec Apache
    comprennent les autres serveurs WWW, certaines implmentations de
    pare-feu, et mme certaines applications client (comme Skype) qui
    utilisent le port 80 afin de contourner les pare-feu.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="windrivemap" id="windrivemap">Configuration de l'accs aux ressources rseau</a></h2>
    

  <p>L'accs  des fichiers par le rseau peut tre spcifi via deux
  mcanismes fournis par Windows :</p>

  <dl>
    <dt>Association de lettres de lecteur</dt>
    <dd>Par exemple, <code>Alias "/images/" "Z:/"</code></dd>

    <dt>chemins UNC</dt>
    <dd>Par exemple, <code>Alias "/images/" "//imagehost/www/images/"</code></dd>
  </dl>

  <p>L'association de lettres de lecteur permet  l'administrateur de
  maintenir une correspondance avec une certaine machine et un certain
  chemin en dehors de la configuration d'Apache httpd. Cependant, ces
  associations ne sont possibles que dans le cadre des sessions
  interactives, et ne sont pas directement disponibles pour Apache httpd
  lorsqu'il est dmarr en tant que service. <strong>N'utilisez par
  consquent que des
  chemins UNC pour les ressources rseau dans httpd.conf,</strong> de
  faon  ce que les ressources soient accessibles quelle que soit la
  manire dont Apache httpd a t dmarr (des procdures exotiques et
  probablement sujettes aux erreurs peuvent permettre de contourner la
  restriction due aux associations de lettres de lecteur, mais leur
  utilisation est dconseille).</p>

  <div class="example"><h3>Exemple de DocumentRoot avec chemin UNC</h3><pre class="prettyprint lang-config">DocumentRoot "//dochost/www/html/"</pre>
</div>

  <div class="example"><h3>Exemple de DocumentRoot avec adresse IP dans le chemin UNC</h3><pre class="prettyprint lang-config">DocumentRoot "//192.168.1.50/docs/"</pre>
</div>

  <div class="example"><h3>Exemple d'Alias et rpertoire correspondant avec
  chemin UNC</h3><pre class="prettyprint lang-config">Alias "/images/" "//imagehost/www/images/"

&lt;Directory "//imagehost/www/images/"&gt;
#...
&lt;Directory&gt;</pre>
</div>

  <p>Lorsqu'Apache s'excute en tant que service, vous devez crer un
  compte spcifique afin de pouvoir accder aux ressources rseau, comme
  dcrit ci-dessus.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="tuning" id="tuning">Personnalisation sous Windows</a></h2>
    
    <ul>
      <li><p>Si on utilise un grand nombre de redirections de journaux
      via des pipes, il est souvent ncessaire d'augmenter la
      taille de la mmoire du bureau ("desktop heap"). Pour une information plus
      dtaille, veuillez vous reporter  la documentation sur les <a href="../logs.html#piped">redirections de journaux</a>.</p></li>
    </ul>
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/platform/windows.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/platform/windows.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/platform/windows.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/platform/windows.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>