<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_ssl - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_ssl</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_ssl.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_ssl.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Chiffrement de haut niveau bas sur les protocoles Secure
Sockets Layer (SSL) et Transport Layer Security (TLS)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>ssl_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_ssl.c</td></tr></table>
<h3>Sommaire</h3>

<p>Ce module fournit le support SSL v3 et TLS v1 au serveur HTTP
Apache. SSL v2 n'est plus support.</p>

<p>Ce module s'appuie sur <a href="http://www.openssl.org/">OpenSSL</a>
pour fournir le moteur de chiffrement.</p>

<p>D'autres dtails, discussions et exemples sont fournis dans la <a href="../ssl/">documentation SSL</a>.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#envvars">Variables d'environnement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#logformats">Formats de journaux
personnaliss</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#notes">Information  propos de la requte</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#expressionparser">Extension pour l'interprtation
des expressions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authzproviders">Fournisseurs d'autorisation
disponibles avec Require</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#sslcacertificatefile">SSLCACertificateFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcacertificatepath">SSLCACertificatePath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcadnrequestfile">SSLCADNRequestFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcadnrequestpath">SSLCADNRequestPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcarevocationcheck">SSLCARevocationCheck</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcarevocationfile">SSLCARevocationFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcarevocationpath">SSLCARevocationPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcertificatechainfile">SSLCertificateChainFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcertificatefile">SSLCertificateFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcertificatekeyfile">SSLCertificateKeyFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslciphersuite">SSLCipherSuite</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcompression">SSLCompression</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslcryptodevice">SSLCryptoDevice</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslengine">SSLEngine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslfips">SSLFIPS</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslhonorcipherorder">SSLHonorCipherOrder</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslinsecurerenegotiation">SSLInsecureRenegotiation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspdefaultresponder">SSLOCSPDefaultResponder</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspenable">SSLOCSPEnable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspnoverify">SSLOCSPNoverify</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspoverrideresponder">SSLOCSPOverrideResponder</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspproxyurl">SSLOCSPProxyURL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocsprespondercertificatefile">SSLOCSPResponderCertificateFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocsprespondertimeout">SSLOCSPResponderTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspresponsemaxage">SSLOCSPResponseMaxAge</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspresponsetimeskew">SSLOCSPResponseTimeSkew</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslocspuserequestnonce">SSLOCSPUseRequestNonce</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslopensslconfcmd">SSLOpenSSLConfCmd</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssloptions">SSLOptions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslpassphrasedialog">SSLPassPhraseDialog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslprotocol">SSLProtocol</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycacertificatefile">SSLProxyCACertificateFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycacertificatepath">SSLProxyCACertificatePath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycarevocationcheck">SSLProxyCARevocationCheck</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycarevocationfile">SSLProxyCARevocationFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycarevocationpath">SSLProxyCARevocationPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycheckpeercn">SSLProxyCheckPeerCN</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycheckpeerexpire">SSLProxyCheckPeerExpire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxycheckpeername">SSLProxyCheckPeerName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxyciphersuite">SSLProxyCipherSuite</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxyengine">SSLProxyEngine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxymachinecertificatechainfile">SSLProxyMachineCertificateChainFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxymachinecertificatefile">SSLProxyMachineCertificateFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxymachinecertificatepath">SSLProxyMachineCertificatePath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxyprotocol">SSLProxyProtocol</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxyverify">SSLProxyVerify</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslproxyverifydepth">SSLProxyVerifyDepth</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslrandomseed">SSLRandomSeed</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslrenegbuffersize">SSLRenegBufferSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslrequire">SSLRequire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslrequiressl">SSLRequireSSL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslsessioncache">SSLSessionCache</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslsessioncachetimeout">SSLSessionCacheTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslsessionticketkeyfile">SSLSessionTicketKeyFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslsessiontickets">SSLSessionTickets</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslsrpunknownuserseed">SSLSRPUnknownUserSeed</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslsrpverifierfile">SSLSRPVerifierFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingcache">SSLStaplingCache</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingerrorcachetimeout">SSLStaplingErrorCacheTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingfaketrylater">SSLStaplingFakeTryLater</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingforceurl">SSLStaplingForceURL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingrespondertimeout">SSLStaplingResponderTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingresponsemaxage">SSLStaplingResponseMaxAge</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingresponsetimeskew">SSLStaplingResponseTimeSkew</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingreturnrespondererrors">SSLStaplingReturnResponderErrors</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstaplingstandardcachetimeout">SSLStaplingStandardCacheTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslstrictsnivhostcheck">SSLStrictSNIVHostCheck</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslusername">SSLUserName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslusestapling">SSLUseStapling</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslverifyclient">SSLVerifyClient</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sslverifydepth">SSLVerifyDepth</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_ssl">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_ssl">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="envvars" id="envvars">Variables d'environnement</a></h2>

<p>Ce module peut tre configur pour fournir aux espaces de nommage SSI
et CGI de nombreux lments d'informations concernant SSL par le biais
de variables d'environnement supplmentaires. Par dfaut, et pour
des raisons de performances, ces informations ne sont pas fournies (Voir
la directive <code class="directive">SSLOptions</code> StdEnvVars ci-dessous).
Les variables gnres se trouvent dans la table ci-dessous.
Ces informations peuvent galement tre disponible sous des noms diffrents
 des fins de compatibilit ascendante. Reportez-vous au chapitre <a href="../ssl/ssl_compat.html">Compatibilit</a> pour plus de dtails 
propos des variables de compatibilit.</p>

<table class="bordered">

<tr>
 <th><a name="table3">Nom de la variable :</a></th>
 <th>Type de valeur :</th>
 <th>Description :</th>
</tr>
<tr><td><code>HTTPS</code></td>                         <td>drapeau</td>
<td>HTTPS est utilis.</td></tr>
<tr><td><code>SSL_PROTOCOL</code></td>                  <td>chane</td>
<td>La version du protocole SSL (SSLv3, TLSv1, TLSv1.1, TLSv1.2)</td></tr>
<tr><td><code>SSL_SESSION_ID</code></td>                <td>chane</td>
<td>L'identifiant de session SSL cod en hexadcimal</td></tr>
<tr><td><code>SSL_SESSION_RESUMED</code></td>           <td>chane</td>
<td>Session SSL initiale ou reprise. Note : plusieurs requtes peuvent
tre servies dans le cadre de la mme session SSL (initiale ou reprise)
si les connexions persistantes (HTTP KeepAlive) sont utilises</td></tr>
<tr><td><code>SSL_SECURE_RENEG</code></td>              <td>chane</td>
<td><code>true</code> si la rengociation scurise est supporte,
<code>false</code> dans le cas contraire</td></tr>
<tr><td><code>SSL_CIPHER</code></td>                    <td>chane</td>
<td>Le nom de l'algorithme de chiffrement</td></tr>
<tr><td><code>SSL_CIPHER_EXPORT</code></td>             <td>chane</td>
<td><code>true</code> si l'algorithme de chiffrement est un algorithme
export</td></tr>
<tr><td><code>SSL_CIPHER_USEKEYSIZE</code></td>         <td>nombre</td>
<td>Nombre de bits de chiffrement (rellement utiliss)</td></tr>
<tr><td><code>SSL_CIPHER_ALGKEYSIZE</code></td>         <td>nombre</td>
<td>Nombre de bits de chiffrement (possible)</td></tr>
<tr><td><code>SSL_COMPRESS_METHOD</code></td>           <td>chane</td>
<td>Mthode de compression SSL ngocie</td></tr>

<tr><td><code>SSL_VERSION_INTERFACE</code></td>         <td>chane</td>
<td>La version du programme mod_ssl</td></tr>
<tr><td><code>SSL_VERSION_LIBRARY</code></td>           <td>chane</td>
<td>La version du programme OpenSSL</td></tr>
<tr><td><code>SSL_CLIENT_M_VERSION</code></td>          <td>chane</td>
<td>La version du certificat client</td></tr>
<tr><td><code>SSL_CLIENT_M_SERIAL</code></td>           <td>chane</td>
<td>Le numro de srie du certificat client</td></tr>
<tr><td><code>SSL_CLIENT_S_DN</code></td>               <td>chane</td>
<td>Le DN sujet du certificat client</td></tr>
<tr><td><code>SSL_CLIENT_S_DN_</code><em>x509</em></td> <td>chane</td>
<td>Elment du DN sujet du client</td></tr>
<tr><td><code>SSL_CLIENT_SAN_Email_</code><em>n</em></td> <td>chane</td>
<td>Les entres d'extension subjectAltName du certificat client de type rfc822Name</td></tr>
<tr><td><code>SSL_CLIENT_SAN_DNS_</code><em>n</em></td> <td>chane</td>
<td>Les entres d'extension subjectAltName du certificat client de type dNSName</td></tr>
<tr><td><code>SSL_CLIENT_SAN_OTHER_msUPN_</code><em>n</em></td>
<td>chane</td>    <td>Extensions subjectAltName de type otherName du
certificat client, forme Microsoft du nom principal de l'utilisateur (OID 1.3.6.1.4.1.311.20.2.3)</td></tr>
<tr><td><code>SSL_CLIENT_I_DN</code></td>               <td>chane</td>
<td>DN de l'metteur du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_I_DN_</code><em>x509</em></td> <td>chane</td>
<td>Elment du DN de l'metteur du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_V_START</code></td>            <td>chane</td>
<td>Validit du certificat du client (date de dbut)</td></tr>
<tr><td><code>SSL_CLIENT_V_END</code></td>              <td>chane</td>
<td>Validit du certificat du client (date de fin)</td></tr>
<tr><td><code>SSL_CLIENT_V_REMAIN</code></td>           <td>chane</td>
<td>Nombre de jours avant expiration du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_A_SIG</code></td>              <td>chane</td>
<td>Algorithme utilis pour la signature du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_A_KEY</code></td>              <td>chane</td>
<td>Algorithme utilis pour la cl publique du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_CERT</code></td>               <td>chane</td>
<td>Certificat du client au format PEM</td></tr>
<tr><td><code>SSL_CLIENT_CERT_CHAIN_</code><em>n</em></td>
<td>chane</td>    <td>Certificats de la chane de certification du
client au format PEM</td></tr>
<tr><td><code>SSL_CLIENT_CERT_RFC4523_CEA</code></td>   <td>chane</td>
<td>Numro de srie et fournisseur du certificat. le format correspond 
celui de la CertificateExactAssertion dans la RFC4523</td></tr>
<tr><td><code>SSL_CLIENT_VERIFY</code></td>             <td>chane</td>
<td><code>NONE</code>, <code>SUCCESS</code>, <code>GENEROUS</code> ou
<code>FAILED:</code><em>raison</em></td></tr>
<tr><td><code>SSL_SERVER_M_VERSION</code></td>          <td>chane</td>
<td>La version du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_M_SERIAL</code></td>           <td>chane</td>    <td>

The serial of the server certificate</td></tr>
<tr><td><code>SSL_SERVER_S_DN</code></td>               <td>chane</td>
<td>DN sujet du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_S_DN_</code><em>x509</em></td> <td>chane</td>
<td>Elment du DN sujet du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_SAN_Email_</code><em>n</em></td>
<td>chane</td>  <td>Les entres d'extension subjectAltName du
certificat de serveur de type rfc822Name</td></tr>
<tr><td><code>SSL_SERVER_SAN_DNS_</code><em>n</em></td> <td>chane</td>
<td>Les entres d'extension subjectAltName du
certificat de serveur de type dNSName</td></tr>
<tr><td><code>SSL_SERVER_SAN_OTHER_dnsSRV_</code><em>n</em></td>
<td>chane</td>    <td>Extensions subjectAltName de type otherName du
certificat serveur, sous la forme SRVName (OID 1.3.6.1.5.5.7.8.7, RFC 4985)</td></tr>
<tr><td><code>SSL_SERVER_I_DN</code></td>               <td>chane</td>
<td>DN de l'metteur du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_I_DN_</code><em>x509</em></td> <td>chane</td>
<td>Elment du DN de l'metteur du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_V_START</code></td>            <td>chane</td>
<td>Validit du certificat du serveur (date de ddut)</td></tr>
<tr><td><code>SSL_SERVER_V_END</code></td>              <td>chane</td>
<td>Validit du certificat du serveur (date de fin)</td></tr>
<tr><td><code>SSL_SERVER_A_SIG</code></td>              <td>chane</td>
<td>Algorithme utilis pour la signature du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_A_KEY</code></td>              <td>chane</td>
<td>Algorithme utilis pour la cl publique du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_CERT</code></td>               <td>chane</td>
<td>Certificat du serveur au format PEM</td></tr>
<tr><td><code>SSL_SRP_USER</code></td>                  <td>chane</td>
<td>nom d'utilisateur SRP</td></tr>
<tr><td><code>SSL_SRP_USERINFO</code></td>              <td>chane</td>
<td>informations sur l'utilisateur SRP</td></tr>
<tr><td><code>SSL_TLS_SNI</code></td>                   <td>string</td>
<td>Contenu de l'extension SNI TLS (si support par ClientHello)</td></tr>
</table>

<p><em>x509</em> spcifie un lment de DN X.509 parmi
<code>C,ST,L,O,OU,CN,T,I,G,S,D,UID,Email</code>. A partir de la version
2.2.0 d'Apache, <em>x509</em> peut aussi comporter un suffixe numrique
<code>_n</code>. Si le DN en question comporte plusieurs attributs de
noms identiques, ce suffixe constitue un index dbutant  zro et
permettant de slectionner un
attribut particulier. Par exemple, si le DN sujet du certificat du
serveur comporte deux champs OU, on peut utiliser
<code>SSL_SERVER_S_DN_OU_0</code> et <code>SSL_SERVER_S_DN_OU_1</code>
pour rfrencer chacun d'entre eux. Un nom de variable sans suffixe
<code>_n</code> est quivalent au mme nom avec le suffixe
<code>_0</code>, ce qui correspond au premier attribut (ou au seul)
caractrisant le DN.
Lorsque la table d'environnement est remplie en utilisant l'option
<code>StdEnvVars</code> de la directive <code class="directive"><a href="#ssloptions">SSLOptions</a></code>, le premier attribut (ou le
seul) caractrisant le DN est enregistr avec un nom sans suffixe ;
autrement dit, aucune entre possdant comme suffixe <code>_0</code>
n'est enregistre.</p>

<p>A partir de la version 2.4.32 de httpd, on peut ajouter le suffixe
<em>_RAW</em>  <em>x509</em> dans un composant DN afin d'empcher la conversion
de la valeur de l'attribut en UTF-8. Il doit tre plac aprs le suffixe index
(s'il existe). On utilisera par exemple <code>SSL_SERVER_S_DN_OU_RAW</code> ou
<code>SSL_SERVER_S_DN_OU_0_RAW</code>.</p>

<p>Le format des variables <em>*_DN</em> a chang depuis la version
2.3.11 d'Apache HTTPD. Voir l'option <code>LegacyDNStringFormat</code>
de la directive <code class="directive"><a href="#ssloptions">SSLOptions</a></code> pour
plus de dtails.</p>

<p><code>SSL_CLIENT_V_REMAIN</code> n'est disponible qu' partir de la
version 2.1.</p>

<p>Plusieurs variables d'environnement additionnelles peuvent tre
utilises dans les expressions <code class="directive">SSLRequire</code>, ou
dans les formats de journalisation personnaliss :</p>

<div class="note"><pre>HTTP_USER_AGENT        PATH_INFO             AUTH_TYPE
HTTP_REFERER           QUERY_STRING          SERVER_SOFTWARE
HTTP_COOKIE            REMOTE_HOST           API_VERSION
HTTP_FORWARDED         REMOTE_IDENT          TIME_YEAR
HTTP_HOST              IS_SUBREQ             TIME_MON
HTTP_PROXY_CONNECTION  DOCUMENT_ROOT         TIME_DAY
HTTP_ACCEPT            SERVER_ADMIN          TIME_HOUR
THE_REQUEST            SERVER_NAME           TIME_MIN
REQUEST_FILENAME       SERVER_PORT           TIME_SEC
REQUEST_METHOD         SERVER_PROTOCOL       TIME_WDAY
REQUEST_SCHEME         REMOTE_ADDR           TIME
REQUEST_URI            REMOTE_USER</pre></div>

<p>Dans ces contextes, deux formats spciaux peuvent aussi tre utiliss
:</p>

<dl>
  <dt><code>ENV:<em>nom_variable</em></code></dt>
  <dd>Correspond  la variable d'environnement standard
  <em>nom_variable</em>.</dd>

  <dt><code>HTTP:<em>nom_en-tte</em></code></dt>
  <dd>Correspond  la valeur de l'en-tte de requte dont le nom est
  <em>nom_en-tte</em>.</dd>
</dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="logformats" id="logformats">Formats de journaux
personnaliss</a></h2>

<p>Lorsque <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> est compil dans le serveur Apache
ou mme charg (en mode DSO), des fonctions supplmentaires sont
disponibles pour le <a href="mod_log_config.html#formats">Format de journal personnalis</a> du
module <code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code>. A ce titre, la fonction de
format d'eXtension ``<code>%{</code><em>nom-var</em><code>}x</code>''
peut tre utilise pour prsenter en extension toute variable fournie
par tout module, et en particulier celles fournies par mod_ssl et que
vous trouverez dans la table ci-dessus.</p>
<p>
A des fins de compatibilit ascendante, il existe une fonction de format
cryptographique supplmentaire
``<code>%{</code><em>nom</em><code>}c</code>''. Vous trouverez toutes
les informations  propos de cette fonction dans le chapitre <a href="../ssl/ssl_compat.html">Compatibilit</a>.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">CustomLog "logs/ssl_request_log" "%t %h %{SSL_PROTOCOL}x %{SSL_CIPHER}x \"%r\" %b"</pre>
</div>
<p>Ces formats sont disponibles mme si l'option <code>StdEnvVars</code> de la
directive <code class="directive"><a href="#ssloptions">SSLOptions</a></code> n'a pas t
dfinie.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="notes" id="notes">Information  propos de la requte</a></h2>

<p><code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> enregistre des informations  propos de la
requte que l'on peut restituer dans les journaux avec la chane de
format <code>%{<em>nom</em>}n</code> via le module
<code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code>.</p>

<p>Les informations enregistres sont les suivantes :</p>

<dl>
  <dt><code>ssl-access-forbidden</code></dt>
  <dd>Cette information contient la valeur <code>1</code> si l'accs a
  t refus suite  une directive <code class="directive">SSLRequire</code> ou
  <code class="directive">SSLRequireSSL</code>.</dd>

  <dt><code>ssl-secure-reneg</code></dt>
  <dd>Si <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> a t compil avec une version
  d'OpenSSL qui supporte la rengociation scurise, si SSL est utilis
  pour la connexion courante et si le client supporte lui aussi la
  rengociation scurise, cette information contiendra la valeur
  <code>1</code>. Si le client ne supporte pas la rengociation
  scurise, l'information contiendra la valeur <code>0</code>. Si
  <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> n'a pas t compil avec une version
  d'OpenSSL qui supporte la rengociation scurise, ou si SSL n'est pas
  utilis pour la connexion courante, le contenu de l'information ne
  sera pas dfini.</dd>
</dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="expressionparser" id="expressionparser">Extension pour l'interprtation
des expressions</a></h2>

<p>Lorsque <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> est compil statiquement avec
Apache, ou mme charg dynamiquement (en tant que module DSO), toute <a name="envvars">variable</a> en provenance de <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> peut
tre utilise pour l'<a href="../expr.html">interprtation des
expression ap_expr</a>. Les variables peuvent tre rfrences en
utilisant la syntaxe ``<code>%{</code><em>varname</em><code>}</code>''.
A partir de la version 2.4.18, on peut aussi utiliser la syntaxe de
style <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>
``<code>%{SSL:</code><em>varname</em><code>}</code>'', ou la syntaxe de
style fonction ``<code>ssl(</code><em>varname</em><code>)</code>''.</p>
<div class="example"><h3>Exemple (en utilisant <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code>)</h3><pre class="prettyprint lang-config">Header set X-SSL-PROTOCOL "expr=%{SSL_PROTOCOL}"
Header set X-SSL-CIPHER "expr=%{SSL:SSL_CIPHER}"</pre>
</div>
<p>Cette fonctionnalit est disponible mme si l'option
<code>StdEnvVars</code> de la directive <code class="directive"><a href="#ssloptions">SSLOptions</a></code> n'a pas t dfinie.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="authzproviders" id="authzproviders">Fournisseurs d'autorisation
disponibles avec Require</a></h2>

  <p><code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> propose quelques fournisseurs
  d'autorisation  utiliser avec la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> du module
  <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code>.</p>

  <h3><a name="reqssl" id="reqssl">Require ssl</a></h3>

    <p>Le fournisseur <code>ssl</code> refuse l'accs si une connexion
    n'est pas chiffre avec SSL. L'effet est similaire  celui de la
    directive <code class="directive">SSLRequireSSL</code>.</p>


    <pre class="prettyprint lang-config">Require ssl</pre>



  

  <h3><a name="reqverifyclient" id="reqverifyclient">Require ssl-verify-client</a></h3>

    <p>Le fournisseur <code>ssl</code> autorise l'accs si
    l'utilisateur est authentifi via un certificat client valide. Ceci
    n'a un effet que si <code>SSLVerifyClient optional</code> est actif.</p>

    <p>Dans l'exemple suivant, l'accs est autoris si le client est
    authentifi via un certificat client ou par nom d'utilisateur/mot de
    passe :</p>

    <pre class="prettyprint lang-config">Require ssl-verify-client
Require valid-user</pre>


  

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcacertificatefile" id="sslcacertificatefile">Directive</a> <a name="SSLCACertificateFile" id="SSLCACertificateFile">SSLCACertificateFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant une concatnation des certificats de CA
cods en PEM pour l'authentification des clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCACertificateFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le fichier <em>tout-en-un</em> o vous
pouvez rassembler les certificats des Autorits de Certification (CAs)
pour les clients auxquels vous avez  faire. On les utilise pour
l'authentification des clients. Un tel fichier contient la simple
concatnation des diffrents fichiers de certificats cods en PEM, par
ordre de prfrence. Cette directive peut tre utilise  la place et/ou
en complment de la directive <code class="directive"><a href="#sslcacertificatepath">SSLCACertificatePath</a></code>.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCACertificateFile "/usr/local/apache2/conf/ssl.crt/ca-bundle-client.crt"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcacertificatepath" id="sslcacertificatepath">Directive</a> <a name="SSLCACertificatePath" id="SSLCACertificatePath">SSLCACertificatePath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire des certificats de CA cods en PEM pour
l'authentification des clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCACertificatePath <em>chemin-rpertoire</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le rpertoire o sont stocks les
certificats des Autorits de Certification (CAs) pour les clients
auxquels vous avez  faire. On les utilise pour vrifier le certificat
du client au cours de l'authentification de ce dernier.</p>
<p>
Les fichiers de ce rpertoire doivent tre cods en PEM et ils sont
accds via des noms de fichier sous forme de condenss ou hash. Il ne
suffit donc pas de placer les fichiers de certificats dans ce rpertoire
: vous devez aussi crer des liens symboliques nomms
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce rpertoire contient les liens symboliques appropris.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCACertificatePath "/usr/local/apache2/conf/ssl.crt/"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcadnrequestfile" id="sslcadnrequestfile">Directive</a> <a name="SSLCADNRequestFile" id="SSLCADNRequestFile">SSLCADNRequestFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant la concatnation des certificats de CA
cods en PEM pour la dfinition de noms de CA acceptables</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCADNRequestFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Lorsque mod_ssl demande un certificat client, une liste de <em>noms
d'Autorits de Certification acceptables</em> est envoye au client au
cours de la phase d'initialisation de la connexion SSL. Le client peut
alors utiliser cette liste de noms de CA pour slectionner un certificat
client appropri parmi ceux dont il dispose.</p>

<p>Si aucune des directives <code class="directive"><a href="#sslcadnrequestpath">SSLCADNRequestPath</a></code> ou <code class="directive"><a href="#sslcadnrequestfile">SSLCADNRequestFile</a></code> n'est dfinie, la liste
de noms de CsA acceptables envoye au client est la liste des noms de
tous les certificats de CA spcifis par les directives <code class="directive"><a href="#sslcacertificatefile">SSLCACertificateFile</a></code> et <code class="directive"><a href="#sslcacertificatepath">SSLCACertificatePath</a></code> ; en d'autres termes,
c'est la liste des noms de CAs qui sera effectivement utilise pour
vrifier le certificat du client.</p>

<p>Dans certaines situations, il est utile de pouvoir envoyer
une liste de noms de CA acceptables qui diffre de la liste des CAs
effectivement utiliss pour vrifier le certificat du client ;
considrons par exemple le cas o le certificat du client est sign par
des CAs intermdiaires. On peut ici utiliser les directives <code class="directive"><a href="#sslcadnrequestpath">SSLCADNRequestPath</a></code> et/ou <code class="directive"><a href="#sslcadnrequestfile">SSLCADNRequestFile</a></code>, et les noms de CA
acceptables seront alors extraits de l'ensemble des certificats contenus
dans le rpertoire et/ou le fichier dfinis par cette paire de
directives.</p>

<p><code class="directive"><a href="#sslcadnrequestfile">SSLCADNRequestFile</a></code> doit
spcifier un fichier <em>tout-en-un</em> contenant une concatnation des
certificats de CA cods en PEM.</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCADNRequestFile "/usr/local/apache2/conf/ca-names.crt"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcadnrequestpath" id="sslcadnrequestpath">Directive</a> <a name="SSLCADNRequestPath" id="SSLCADNRequestPath">SSLCADNRequestPath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire contenant des fichiers de certificats de CA
cods en PEM pour la dfinition de noms de CA acceptables</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCADNRequestPath <em>chemin-rpertoire</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>

<p>Cette directive optionnelle permet de dfinir la liste de <em>noms de
CAs acceptables</em> qui sera envoye au client lorsqu'un certificat de
client est demand. Voir la directive <code class="directive"><a href="#sslcadnrequestfile">SSLCADNRequestFile</a></code> pour plus de
dtails.</p>

<p>Les fichiers de ce rpertoire doivent tre cods en PEM et ils sont
accds via des noms de fichier sous forme de condenss ou hash. Il ne
suffit donc pas de placer les fichiers de certificats dans ce rpertoire
: vous devez aussi crer des liens symboliques nomms
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce rpertoire contient les liens symboliques appropris.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCADNRequestPath "/usr/local/apache2/conf/ca-names.crt/"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcarevocationcheck" id="sslcarevocationcheck">Directive</a> <a name="SSLCARevocationCheck" id="SSLCARevocationCheck">SSLCARevocationCheck</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la vrification des rvocations base sur les CRL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCARevocationCheck chain|leaf|none <em>flag</em>s</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLCARevocationCheck none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Le drapeau optionnel <em>flag</em>s est disponible  partir de la
version 2.4.21 du serveur HTTP Apache</td></tr>
</table>
<p>
Active la vrification des rvocations base sur les Listes de
Rvocations de Certificats (CRL). Au moins une des directives <code class="directive"><a href="#sslcarevocationfile">SSLCARevocationFile</a></code> ou <code class="directive"><a href="#sslcarevocationpath">SSLCARevocationPath</a></code> doit tre dfinie.
Lorsque cette directive est dfinie  <code>chain</code> (valeur
recommande), les vrifications CRL sont effectues sur tous les
certificats de la chane, alors que la valeur <code>leaf</code> limite
la vrification au certificat hors chane (la feuille).
</p>
<p><em>flag</em>s peut prendre comme valeurs </p>
<ul>
<li><code>no_crl_for_cert_ok</code>
<p>
Avant la version 2.3.15, les vrifications CRL dans mod_ssl
russissaient mme si aucune CRL n'tait trouve dans les chemins
dfinis par les directives <code class="directive"><a href="#sslcarevocationfile">SSLCARevocationFile</a></code> ou <code class="directive"><a href="#sslcarevocationpath">SSLCARevocationPath</a></code>.</p>
<p>Le comportement a
chang avec l'introduction de la  directive
<code class="directive">SSLCARevocationFile</code> : par dfaut avec
<code>chain</code> ou <code>leaf</code>, les CRLs <em>doivent</em> tre prsentes pour que la
validation russisse ; dans le cas contraire, elle chouera avec une
erreur <code>"unable to get certificate CRL"</code>.</p>
<p>La valeur <code>no_crl_for_cert_ok</code> du drapeau <em>flag</em> permet de
retrouver le comportement prcdent.</p>
</li>
</ul>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCARevocationCheck chain</pre>
</div>
<div class="example"><h3>Compatibilit avec la branche 2.2</h3><pre class="prettyprint lang-config">SSLCARevocationCheck chain no_crl_for_cert_ok</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcarevocationfile" id="sslcarevocationfile">Directive</a> <a name="SSLCARevocationFile" id="SSLCARevocationFile">SSLCARevocationFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant la concatnation des CRLs des CA cods en
PEM pour l'authentification des clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCARevocationFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le fichier <em>tout-en-un</em> o sont
rassembles les Listes de Rvocation de Certificats (CRLs) des Autorits
de certification (CAs) pour les clients auxquels vous avez  faire. On
les utilise pour l'authentification des clients. Un tel fichier contient
la simple concatnation des diffrents fichiers de CRLs cods en PEM,
dans l'ordre de prfrence. Cette directive peut tre utilise  la
place et/ou en complment de la directive <code class="directive"><a href="#sslcarevocationpath">SSLCARevocationPath</a></code>.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCARevocationFile
"/usr/local/apache2/conf/ssl.crl/ca-bundle-client.crl"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcarevocationpath" id="sslcarevocationpath">Directive</a> <a name="SSLCARevocationPath" id="SSLCARevocationPath">SSLCARevocationPath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire des CRLs de CA cods en PEM pour
l'authentification des clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCARevocationPath <em>chemin-rpertoire</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le rpertoire o sont stockes les
Listes de Rvocation de Certificats (CRL) des Autorits de Certification
(CAs) pour les clients auxquels vous avez  faire. On les utilise pour
rvoquer les certificats des clients au cours de l'authentification de
ces derniers.</p>
<p>
Les fichiers de ce rpertoire doivent tre cods en PEM et ils sont
accds via des noms de fichier sous forme de condenss ou hash. Il ne
suffit donc pas de placer les fichiers de CRL dans ce rpertoire
: vous devez aussi crer des liens symboliques nomms
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce rpertoire contient les liens symboliques appropris.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCARevocationPath "/usr/local/apache2/conf/ssl.crl/"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcertificatechainfile" id="sslcertificatechainfile">Directive</a> <a name="SSLCertificateChainFile" id="SSLCertificateChainFile">SSLCertificateChainFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant les certificats de CA du serveur cods en
PEM</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCertificateChainFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<div class="note"><h3>SSLCertificateChainFile est obsolte</h3>
<p><code>SSLCertificateChainFile</code> est devenue obsolte avec la
version 2.4.8, lorsque la directive
<code class="directive"><a href="#sslcertificatefile">SSLCertificateFile</a></code> a t tendue
pour supporter aussi les certificats de CA intermdiaires dans le
fichier de certificats du serveur.</p>
</div>
<p>
Cette directive permet de dfinir le fichier optionnel
<em>tout-en-un</em> o vous pouvez rassembler les certificats des
Autorits de Certification (CA) qui forment la chane de certification
du certificat du serveur. Cette chane dbute par le certificat de la CA
qui a dlivr le certificat du serveur et peut remonter jusqu'au
certificat de la CA racine. Un tel fichier contient la simple
concatnation des diffrents certificats de CA cods en PEM, en gnral
dans l'ordre de la chane de certification.</p>
<p>Elle doit tre utilise  la place et/ou en complment de la
directive <code class="directive"><a href="#sslcacertificatepath">SSLCACertificatePath</a></code>
pour construire explicitement la chane de certification du serveur qui
est envoye au navigateur en plus du certificat du serveur. Elle s'avre
particulirement utile pour viter les conflits avec les certificats de
CA lorsqu'on utilise l'authentification du client. Comme le fait de
placer un certificat de CA de la chane de certification du serveur dans
la directive <code class="directive"><a href="#sslcacertificatepath">SSLCACertificatePath</a></code> produit le mme effet
pour la construction de la chane de certification, cette directive a
pour effet colatral de faire accepter les certificats clients fournis
par cette mme CA, au cours de l'authentification du client.</p>
<p>
Soyez cependant prudent : fournir la chane de certification ne
fonctionne que si vous utilisez un <em>simple</em> certificat de
serveur RSA <em>ou</em> DSA. Si vous utilisez une paire de certificats
coupls RSA+DSA , cela ne fonctionnera que si les deux certificats
utilisent vraiment <em>la mme</em> chane de certification. Dans le cas
contraire, la confusion risque de s'installer au niveau des
navigateurs.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCertificateChainFile "/usr/local/apache2/conf/ssl.crt/ca.crt"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcertificatefile" id="sslcertificatefile">Directive</a> <a name="SSLCertificateFile" id="SSLCertificateFile">SSLCertificateFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier de donnes contenant le certificat X.509 du serveur cod en
PEM</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCertificateFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette directive permet de dfinir le fichier de donnes contenant
les informations de certificat
X.509 du serveur codes au format PEM. Ce fichier doit contenir
au minimum un certificat d'entit finale (feuille). 
La directive peut tre utilise plusieurs fois (elle rfrence des
fichiers diffrents) pour accepter plusieurs algorithmes
d'authentification au niveau du serveur - souvent RSA, DSA et ECC. Le
nombre d'algorithmes supports dpend de la version d'OpenSSL utilise
avec mod_ssl :  partir de la version 1.0.0, la commande <code>openssl
list-public-key-algorithms</code> affiche la liste des algorithmes
supports. Voir aussi la note ci-dessous  propos des limitations des versions
d'OpenSSL antrieures  1.0.2 et la manire de les contourner.
</p>

<p>Les fichiers peuvent aussi contenir des certificats de CA
intermdiaires tris depuis la feuille vers la racine. Cette
fonctionnalit est disponible depuis la version 2.4.8 du serveur HTTP
Apache, et rend obsolte la directive <code class="directive"><a href="#sslcertificatechainfile">SSLCertificateChainFile</a></code>. A partir de la
version 1.0.2 d'OpenSSL, il est alors possible de configurer la chane
de certification en fonction du certificat.</p>

<p>Depuis la version 2.4.7 du serveur HTTP Apache, on peut aussi ajouter
des paramtres DH personnaliss et un nom EC
curve pour les cls phmres  la fin du premier fichier dfini par la
directive <code class="directive"><a href="#sslcertificatefile">SSLCertificateFile</a></code>.
Ces paramtres peuvent tre gnrs avec les commandes <code>openssl
dhparam</code> et <code>openssl ecparam</code>, et ils peuvent tre
ajouts tel quel  la fin du premier fichier de certificat. En effet,
seul le premier fichier de certificat dfini peut tre utilis pour
enregistrer des paramtres personnaliss, car ces derniers s'appliquent
indpendamment de l'algorithme d'authentification utilis.
</p>

<p>Enfin, il est aussi possible d'ajouter la cl prive du certificat de
l'entit finale au fichier de certificat, ce qui permet de se passer
d'une directive <code class="directive"><a href="#sslcertificatekeyfile">SSLCertificateKeyFile</a></code> spare. Cette
pratique est cependant fortement dconseille. En effet, les fichiers de
certificats qui contiennent de tels cls embarques doivent tre dfinis
avant les certificats en utilisant un fichier de cl spar. En outre,
si la cl est chiffre, une bote de dialogue pour entrer le mot de
passe de la cl s'ouvre au dmarrage du serveur.
</p>

<div class="note">
<h3>Interoprabilit des paramtres DH avec les nombres premiers de
plus de 1024 bits</h3>
<p>
Depuis la version 2.4.7, mod_ssl utilise des
paramtres DH standardiss avec des nombres premiers de 2048, 3072 et
4096 bits, et avec des nombres premiers de 6144 et 8192 bits depuis la
version 2.4.10 (voir <a href="http://www.ietf.org/rfc/rfc3526.txt">RFC
3526</a>), et les fournit aux clients en fonction de la longueur de la
cl du certificat RSA/DSA. En particulier avec les clients bass sur
Java (versions 7 et antrieures), ceci peut provoquer des erreurs au
cours de la ngociation - voir cette <a href="../ssl/ssl_faq.html#javadh">rponse de la FAQ SSL</a> pour
contourner les problmes de ce genre.
</p>
</div>

<div class="note">
<h3>Paramtres DH par dfaut lorsqu'on utilise plusieurs certificats et une
version d'OpenSSL antrieure  1.0.2.</h3>
<p>
Lorsqu'on utilise plusieurs certificats pour supporter diffrents algorithmes
d'authentification (comme RSA, DSA, mais principalement ECC) et une
version d'OpenSSL antrieure  1.0.2, il est recommand soit d'utiliser des
paramtres DH spcifiques (solution  privilgier) en les ajoutant au premier
fichier certificat (comme dcrit ci-dessus), soit d'ordonner les directives
<code class="directive">SSLCertificateFile</code> de faon  ce que les certificats
RSA/DSA soit placs <strong>aprs</strong> les certificats ECC.
</p>
<p>
Cette limitation est prsente dans les anciennes versions d'OpenSSL qui
prsentent toujours le dernier certificat configur, au lieu
de laisser le serveur HTTP Apache dterminer le certificat slectionn lors de
la phase de ngociation de la connexion (lorsque les paramtres DH doivent tre
envoys  l'hte distant).
De ce fait, le serveur peut slectionner des paramtres DH par dfaut bass sur
la longueur de la cl du mauvais certificat (les cls ECC sont beaucoup plus
petites que les cls RSA/DSA et leur longueur n'est pas pertinente pour la
slection des nombres premiers DH).
</p>
<p>
Ce problme peut tre rsolu en crant et configurant des paramtres DH
spcifiques (comme dcrit ci-dessus), car ils l'emportent toujours sur les
paramtres DH par dfaut, et vous pourrez ainsi utiliser une longueur spcifique
et approprie.
</p>
</div>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCertificateFile "/usr/local/apache2/conf/ssl.crt/server.crt"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcertificatekeyfile" id="sslcertificatekeyfile">Directive</a> <a name="SSLCertificateKeyFile" id="SSLCertificateKeyFile">SSLCertificateKeyFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant la cl prive du serveur code en
PEM</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCertificateKeyFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette directive permet de dfinir le fichier contenant la cl prive du
serveur code en PEM. Si la cl prive est
chiffre, une bote de dialogue demandant le mot de passe s'ouvre au
dmarrage.</p>

<p>
Cette directive peut tre utilise plusieurs fois pour rfrencer
diffrents noms de fichiers, afin de supporter plusieurs algorithmes
pour l'authentification du serveur. A chaque directive <code class="directive"><a href="#sslcertificatekeyfile">SSLCertificateKeyFile</a></code> doit tre associe
une directive <code class="directive">SSLCertificateFile</code> correspondante.
</p>

<p>
La cl priv peut aussi tre ajoute au fichier dfini par la directive
<code class="directive"><a href="#sslcertificatefile">SSLCertificateFile</a></code>, mais cette
pratique est fortement dconseille. En effet, les fichiers de
certificats qui comportent une telle cl doivent tre dfinis aprs les
certificats en utilisant un fichier de cl spar.</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCertificateKeyFile "/usr/local/apache2/conf/ssl.key/server.key"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslciphersuite" id="sslciphersuite">Directive</a> <a name="SSLCipherSuite" id="SSLCipherSuite">SSLCipherSuite</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Algorithmes de chiffrement disponibles pour la ngociation
au cours de l'initialisation de la connexion SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCipherSuite <em>algorithmes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLCipherSuite DEFAULT (dpend de la version d'OpenSSL
installe)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive complexe utilise la chane <em>algorithmes</em>
contenant la liste des algorithmes de chiffrement OpenSSL que le client
peut utiliser au cours de la phase d'initialisation de la connexion SSL.
Notez que cette directive peut tre utilise aussi bien dans un contexte
de serveur que dans un contexte de rpertoire. Dans un contexte de
serveur, elle s'applique  l'initialisation SSL standard lorsqu'une
connexion est tablie. Dans un contexte de rpertoire, elle force une
rengociation SSL avec la liste d'algorithmes de chiffrement spcifie
aprs la lecture d'une requte HTTP, mais avant l'envoi de la rponse
HTTP.</p>
<p>
La liste d'algorithmes de chiffrement SSL spcifie par l'argument
<em>algorithmes</em> comporte quatre attributs principaux auxquels
s'ajoutent quelques attributs secondaires :</p>
<ul>
<li><em>Algorithme d'change de cls</em>:<br />
    RSA, Diffie-Hellman, Elliptic Curve Diffie-Hellman, Secure Remote Password
</li>
<li><em>Algorithme d'authentification</em>:<br />
    RSA, Diffie-Hellman, DSS, ECDSA ou none.
</li>
<li><em>Algorithme de chiffrement</em>:<br />
    AES, DES, Triple-DES, RC4, RC2, IDEA, etc...
</li>
<li><em>Algorithme de condens MAC</em>:<br />
    MD5, SHA or SHA1, SHA256, SHA384.
</li>
</ul>
<p>L'algorithme de chiffrement peut aussi provenir de l'extrieur. Les
algorithmes SSLv2 ne sont plus supports.
Pour dfinir les algorithmes  utiliser, on
peut soit spcifier tous les algorithmes  la fois, soit utiliser des
alias pour spcifier une liste d'algorithmes dans leur ordre de
prfrence (voir <a href="#table1">Table 1</a>). Les algorithmes et
alias effectivement disponibles dpendent de la version d'openssl
utilise. Les versions ultrieures d'openssl inclueront probablement des
algorithmes supplmentaires.</p>

<table class="bordered">

<tr><th><a name="table1">Symbole</a></th> <th>Description</th></tr>
<tr><td colspan="2"><em>Algorithme d'change de cls :</em></td></tr>
<tr><td><code>kRSA</code></td>   <td>Echange de cls RSA</td></tr>
<tr><td><code>kDHr</code></td>   <td>Echange de cls Diffie-Hellman avec
cl RSA</td></tr>
<tr><td><code>kDHd</code></td>   <td>Echange de cls Diffie-Hellman avec
cl DSA</td></tr>
<tr><td><code>kEDH</code></td>   <td>Echange de cls Diffie-Hellman
temporaires (pas de certificat)</td>   </tr>
<tr><td><code>kSRP</code></td>   <td>change de cls avec mot de passe
distant scuris (SRP)</td></tr>
<tr><td colspan="2"><em>Algorithmes d'authentification :</em></td></tr>
<tr><td><code>aNULL</code></td>  <td>Pas d'authentification</td></tr>
<tr><td><code>aRSA</code></td>   <td>Authentification RSA</td></tr>
<tr><td><code>aDSS</code></td>   <td>Authentification DSS</td> </tr>
<tr><td><code>aDH</code></td>    <td>Authentification Diffie-Hellman</td></tr>
<tr><td colspan="2"><em>Algorithmes de chiffrement :</em></td></tr>
<tr><td><code>eNULL</code></td>  <td>Pas de chiffrement</td>         </tr>
<tr><td><code>NULL</code></td>   <td>alias pour eNULL</td>         </tr>
<tr><td><code>AES</code></td>    <td>Chiffrement AES</td>        </tr>
<tr><td><code>DES</code></td>    <td>Chiffrement DES</td>        </tr>
<tr><td><code>3DES</code></td>   <td>Chiffrement Triple-DES</td> </tr>
<tr><td><code>RC4</code></td>    <td>Chiffrement RC4</td>       </tr>
<tr><td><code>RC2</code></td>    <td>Chiffrement RC2</td>       </tr>
<tr><td><code>IDEA</code></td>   <td>Chiffrement IDEA</td>       </tr>
<tr><td colspan="2"><em>Algorithmes de condenss MAC </em>:</td></tr>
<tr><td><code>MD5</code></td>    <td>Fonction de hashage MD5</td></tr>
<tr><td><code>SHA1</code></td>   <td>Fonction de hashage SHA1</td></tr>
<tr><td><code>SHA</code></td>    <td>alias pour SHA1</td> </tr>
<tr><td><code>SHA256</code></td> <td>&gt;Fonction de hashage SHA256</td> </tr>
<tr><td><code>SHA384</code></td> <td>&gt;Fonction de hashage SHA384</td> </tr>
<tr><td colspan="2"><em>Alias :</em></td></tr>
<tr><td><code>SSLv3</code></td>  <td>tous les algorithmes de chiffrement
SSL version 3.0</td> </tr>
<tr><td><code>TLSv1</code></td>  <td>tous les algorithmes de chiffrement
TLS version 1.0</td> </tr>
<tr><td><code>EXP</code></td>    <td>tous les algorithmes de chiffrement
externes</td>  </tr>
<tr><td><code>EXPORT40</code></td> <td>tous les algorithmes de chiffrement
externes limits  40 bits</td>  </tr>
<tr><td><code>EXPORT56</code></td> <td>tous les algorithmes de chiffrement
externes limits  56 bits</td>  </tr>
<tr><td><code>LOW</code></td>    <td>tous les algorithmes de chiffrement
faibles (non externes, DES simple)</td></tr>
<tr><td><code>MEDIUM</code></td> <td>tous les algorithmes avec
chiffrement 128 bits</td> </tr>
<tr><td><code>HIGH</code></td>   <td>tous les algorithmes
utilisant Triple-DES</td>     </tr>
<tr><td><code>RSA</code></td>    <td>tous les algorithmes
utilisant l'change de cls RSA</td> </tr>
<tr><td><code>DH</code></td>     <td>tous les algorithmes
utilisant l'change de cls Diffie-Hellman</td> </tr>
<tr><td><code>EDH</code></td>    <td>tous les algorithmes
utilisant l'change de cls Diffie-Hellman temporaires</td> </tr>
<tr><td><code>ECDH</code></td>   <td>change de cls Elliptic Curve Diffie-Hellman</td>   </tr>
<tr><td><code>ADH</code></td>    <td>tous les algorithmes
utilisant l'change de cls Diffie-Hellman anonymes</td> </tr>
<tr><td><code>AECDH</code></td>    <td>tous les algorithmes
utilisant l'change de cls Elliptic Curve Diffie-Hellman</td> </tr>
<tr><td><code>SRP</code></td>    <td>tous les algorithmes utilisant
l'change de cls avec mot de passe distant scuris (SRP)</td> </tr>
<tr><td><code>DSS</code></td>    <td>tous les algorithmes
utilisant l'authentification DSS</td> </tr>
<tr><td><code>ECDSA</code></td>    <td>tous les algorithmes
utilisant l'authentification ECDSA</td> </tr>
<tr><td><code>aNULL</code></td>   <td>tous les algorithmes
n'utilisant aucune authentification</td> </tr>
</table>
<p>
Cela devient intressant lorsque tous ces symboles sont combins
ensemble pour spcifier les algorithmes disponibles et l'ordre dans
lequel vous voulez les utiliser. Pour simplifier tout cela, vous
disposez aussi d'alias (<code>SSLv3, TLSv1, EXP, LOW, MEDIUM,
HIGH</code>) pour certains groupes d'algorithmes. Ces symboles peuvent
tre relis par des prfixes pour former la chane <em>algorithmes</em>.
Les prfixes disponibles sont :</p>
<ul>
<li>none: ajoute l'algorithme  la liste</li>
<li><code>+</code>: dplace les algorithmes qui conviennent  la
place courante dans la liste</li>
<li><code>-</code>: supprime l'algorithme de la liste (peut tre rajout
plus tard)</li>
<li><code>!</code>: supprime dfinitivement l'algorithme de la liste (ne
peut <strong>plus</strong> y tre rajout plus tard)</li>
</ul>

<div class="note">
<h3>Les algorithmes <code>aNULL</code>, <code>eNULL</code> et
<code>EXP</code> sont toujours dsactivs</h3>
<p>Depuis la version 2.4.7, les
algorithmes de type null ou destins  l'exportation sont toujours
dsactivs car mod_ssl ajoute obligatoirement
<code>!aNULL:!eNULL:!EXP</code>  toute chane d'algorithme de
chiffrement  l'initialisation.</p>
</div>

<p>Pour vous simplifier la vie, vous pouvez utiliser la commande
``<code>openssl ciphers -v</code>'' qui vous fournit un moyen simple de
crer la chane <em>algorithmes</em> avec succs. La chane
<em>algorithmes</em> par dfaut dpend de la version des bibliothques
SSL installes. Supposons qu'elle contienne
``<code>RC4-SHA:AES128-SHA:HIGH:MEDIUM:!aNULL:!MD5</code>'', ce qui
stipule de mettre <code>RC4-SHA</code> et <code>AES128-SHA</code> en
premiers, car ces algorithmes prsentent un bon compromis entre vitesse
et scurit. Viennent ensuite les algorithmes de scurit leve et
moyenne. En fin de compte, les algorithmes qui n'offrent aucune
authentification sont exclus, comme les algorithmes anonymes
Diffie-Hellman pour SSL, ainsi que tous les algorithmes qui utilisent
<code>MD5</code> pour le hashage, car celui-ci est reconnu comme
insuffisant.</p>
<div class="example"><pre>$ openssl ciphers -v 'RC4-SHA:AES128-SHA:HIGH:MEDIUM:!aNULL:!MD5'
RC4-SHA                 SSLv3 Kx=RSA      Au=RSA  Enc=RC4(128)  Mac=SHA1
AES128-SHA              SSLv3 Kx=RSA      Au=RSA  Enc=AES(128)  Mac=SHA1
DHE-RSA-AES256-SHA      SSLv3 Kx=DH       Au=RSA  Enc=AES(256)  Mac=SHA1
...                     ...               ...     ...           ...
SEED-SHA                SSLv3 Kx=RSA      Au=RSA  Enc=SEED(128) Mac=SHA1
PSK-RC4-SHA             SSLv3 Kx=PSK      Au=PSK  Enc=RC4(128)  Mac=SHA1
KRB5-RC4-SHA            SSLv3 Kx=KRB5     Au=KRB5 Enc=RC4(128)  Mac=SHA1</pre></div>
<p>Vous trouverez la liste complte des algorithmes RSA &amp; DH
spcifiques  SSL dans la <a href="#table2">Table 2</a>.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLCipherSuite RSA:!EXP:!NULL:+HIGH:+MEDIUM:-LOW</pre>
</div>
<table class="bordered">

<tr><th><a name="table2">Symbole algorithme</a></th> <th>Protocole</th>
<th>Echange de cls</th> <th>Authentification</th> <th>Chiffrement</th>
<th>Condens MAC</th> <th>Type</th> </tr>
<tr><td colspan="7"><em>Algorithmes RSA :</em></td></tr>
<tr><td><code>DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>3DES(168)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>IDEA-CBC-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>IDEA(128)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>RC4-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>RC4(128)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>RC4-MD5</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>RC4(128)</td> <td>MD5</td> <td /> </tr>
<tr><td><code>DES-CBC-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>DES(56)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>EXP-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>RSA(512)</td> <td>RSA</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-RC2-CBC-MD5</code></td> <td>SSLv3</td> <td>RSA(512)</td> <td>RSA</td> <td>RC2(40)</td> <td>MD5</td> <td>  export</td> </tr>
<tr><td><code>EXP-RC4-MD5</code></td> <td>SSLv3</td> <td>RSA(512)</td> <td>RSA</td> <td>RC4(40)</td> <td>MD5</td> <td>  export</td> </tr>
<tr><td><code>NULL-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>None</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>NULL-MD5</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>None</td> <td>MD5</td> <td /> </tr>
<tr><td colspan="7"><em>Algorithmes Diffie-Hellman :</em></td></tr>
<tr><td><code>ADH-DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>None</td> <td>3DES(168)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>ADH-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>None</td> <td>DES(56)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>ADH-RC4-MD5</code></td> <td>SSLv3</td> <td>DH</td> <td>None</td> <td>RC4(128)</td> <td>MD5</td> <td /> </tr>
<tr><td><code>EDH-RSA-DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>RSA</td> <td>3DES(168)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>EDH-DSS-DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>DSS</td> <td>3DES(168)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>EDH-RSA-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>RSA</td> <td>DES(56)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>EDH-DSS-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>DSS</td> <td>DES(56)</td> <td>SHA1</td> <td /> </tr>
<tr><td><code>EXP-EDH-RSA-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>RSA</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-EDH-DSS-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>DSS</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-ADH-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>None</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-ADH-RC4-MD5</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>None</td> <td>RC4(40)</td> <td>MD5</td> <td>  export</td> </tr>
</table>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcompression" id="sslcompression">Directive</a> <a name="SSLCompression" id="SSLCompression">SSLCompression</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet d'activer la compression au niveau SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCompression on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLCompression off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.3 du serveur HTTP
Apache, si on utilise une version d'OpenSSL 0.9.8 ou suprieure ;
l'utilisation dans un contexte de serveur virtuel n'est disponible que
si on utilise une version d'OpenSSL 1.0.0 ou suprieure. La valeur par
dfaut tait <code>on</code> dans la version 2.4.3.</td></tr>
</table>
<p>Cette directive permet d'activer la compression au niveau SSL.</p>
<div class="warning">
<p>L'activation de la compression est  l'origine de problmes de
scurit dans la plupart des configurations (l'attaque nomme CRIME).</p>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslcryptodevice" id="sslcryptodevice">Directive</a> <a name="SSLCryptoDevice" id="SSLCryptoDevice">SSLCryptoDevice</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active l'utilisation d'un acclrateur matriel de
chiffrement</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLCryptoDevice <em>moteur</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLCryptoDevice builtin</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet d'activer l'utilisation d'une carte acclratrice
de chiffrement qui prendra en compte certaines parties du traitement
relatif  SSL. Cette directive n'est utilisable que si la bote 
outils SSL  t compile avec le support "engine" ; les versions 0.9.7
et suprieures d'OpenSSL possdent par dfaut le support "engine", alors
qu'avec la version 0.9.6, il faut utiliser les distributions spares
"-engine".</p>

<p>Pour dterminer les moteurs supports, excutez la commande
"<code>openssl engine</code>".</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config"># Pour un acclrateur Broadcom :
SSLCryptoDevice ubsec</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslengine" id="sslengine">Directive</a> <a name="SSLEngine" id="SSLEngine">SSLEngine</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interrupteur marche/arrt du moteur SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLEngine on|off|optional</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLEngine off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet d'activer/dsactiver le moteur du protocole
SSL/TLS. Elle doit tre utilise dans une section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> pour activer
SSL/TLS pour ce serveur virtuel particulier. Par dfaut, le moteur du
protocole SSL/TLS est dsactiv pour le serveur principal et tous les
serveurs virtuels configurs.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">&lt;VirtualHost _default_:443&gt;
SSLEngine on
#...
&lt;/VirtualHost&gt;</pre>
</div>
<p>Depuis la version 2.1 d'Apache, la directive
<code class="directive">SSLEngine</code> peut tre dfinie 
<code>optional</code>, ce qui active le support de <a href="http://www.ietf.org/rfc/rfc2817.txt">RFC 2817</a>, Upgrading to
TLS Within HTTP/1.1. Pour le moment, aucun navigateur web ne supporte
RFC 2817.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslfips" id="sslfips">Directive</a> <a name="SSLFIPS" id="SSLFIPS">SSLFIPS</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Coimmutateur du mode SSL FIPS</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLFIPS on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLFIPS off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet d'activer/dsactiver l'utilisation du drapeau
FIPS_mode de la bibliothque SSL. Elle doit tre dfinie dans le
contexte du serveur principal, et n'accepte pas les configurations
sources de conflits (SSLFIPS on suivi de SSLFIPS off par exemple). Le
mode s'applique  toutes les oprations de la bibliothque SSL.
</p>
<p>
Si httpd a t compil avec une bibliothque SSL qui ne supporte pas le
drapeau FIPS_mode, la directive <code>SSLFIPS on</code> chouera.
Reportez-vous au document sur la politique de scurit FIPS 140-2 de la
bibliothque du fournisseur SSL, pour les prrequis spcifiques
ncessaires  l'utilisation de mod_ssl selon un mode d'opration
approuv par FIPS 140-2 ; notez que mod_ssl en lui-mme n'est pas
valid, mais peut tre dcrit comme utilisant un module de chiffrement
valid par FIPS 140-2, lorsque tous les composants sont assembls et mis
en oeuvre selon les recommandations de la politique de scurit
applicable.
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslhonorcipherorder" id="sslhonorcipherorder">Directive</a> <a name="SSLHonorCipherOrder" id="SSLHonorCipherOrder">SSLHonorCipherOrder</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Option permettant de classer les algorithmes de chiffrement
du serveur par ordre de prfrence</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLHonorCipherOrder on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLHonorCipherOrder off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Normalement, ce sont les prfrences du client qui sont prises en
compte lors du choix d'un algorithme de chiffrement au cours d'une
ngociation SSLv3 ou TLSv1. Si cette directive est active, ce sont les
prfrences du serveur qui seront prises en compte  la place.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLHonorCipherOrder on</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslinsecurerenegotiation" id="sslinsecurerenegotiation">Directive</a> <a name="SSLInsecureRenegotiation" id="SSLInsecureRenegotiation">SSLInsecureRenegotiation</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Option permettant d'activer le support de la rengociation
non scurise</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLInsecureRenegotiation on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLInsecureRenegotiation off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis httpd 2.2.15, si une version 0.9.8m
ou suprieure d'OpenSSL est utilise</td></tr>
</table>
<p>Comme il a t spcifi, toutes les versions des protocoles SSL et
TLS (jusqu' la version 1.2 de TLS incluse) taient vulnrables  une
attaque de type Man-in-the-Middle (<a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2009-3555">CVE-2009-3555</a>)
au cours d'une rengociation. Cette vulnrabilit permettait  un
attaquant de prfixer la requte HTTP (telle qu'elle tait vue du
serveur) avec un texte choisi. Une extension du protocole a t
dveloppe pour corriger cette vulnrabilit, sous rserve qu'elle soit
supporte par le client et le serveur.</p>

<p>Si <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> est li  une version 0.9.8m ou
suprieure d'OpenSSL, par dfaut, la rengociation n'est accorde qu'aux
clients qui supportent la nouvelle extension du protocole. Si
cette directive est active, la rengociation sera accorde aux anciens
clients (non patchs), quoique de manire non scurise</p>

<div class="warning"><h3>Avertissement  propos de la scurit</h3>
<p>Si cette directive est active, les connexions SSL seront vulnrables
aux attaques de type prfixe Man-in-the-Middle comme dcrit dans <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2009-3555">CVE-2009-3555</a>.</p>
</div>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLInsecureRenegotiation on</pre>
</div>

<p>La variable d'environnement <code>SSL_SECURE_RENEG</code> peut tre
utilise dans un script SSI ou CGI pour dterminer si la rengociation
scurise est supporte pour une connexion SSL donne.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspdefaultresponder" id="sslocspdefaultresponder">Directive</a> <a name="SSLOCSPDefaultResponder" id="SSLOCSPDefaultResponder">SSLOCSPDefaultResponder</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'URI du rpondeur par dfaut pour la validation
OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSDefaultResponder <em>uri</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette directive permet de dfinir le rpondeur OCSP par dfaut. Si la
directive <code class="directive"><a href="#sslocspoverrideresponder">SSLOCSPOverrideResponder</a></code> n'est pas active,
l'URI spcifi ne sera utilis que si aucun URI de rpondeur n'est
spcifi dans le certificat en cours de vrification.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspenable" id="sslocspenable">Directive</a> <a name="SSLOCSPEnable" id="SSLOCSPEnable">SSLOCSPEnable</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la validation OCSP de la chane de certificats du
client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPEnable on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPEnable off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette directive permet d'activer la validation OCSP de la chane de
certificats du client. Si elle est active, les certificats de la chane
de certificats du client seront valids auprs d'un rpondeur OCSP, une
fois la vrification normale effectue (vrification des CRLs
incluse).</p>

<p>Le rpondeur OCSP utilis est soit extrait du certificat lui-mme,
soit spcifi dans la configuration ; voir les directives <code class="directive"><a href="#sslocspdefaultresponder">SSLOCSPDefaultResponder</a></code> et <code class="directive"><a href="#sslocspoverrideresponder">SSLOCSPOverrideResponder</a></code>.</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLVerifyClient on
SSLOCSPEnable on
SSLOCSPDefaultResponder "http://responder.example.com:8888/responder"
SSLOCSPOverrideResponder on</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspnoverify" id="sslocspnoverify">Directive</a> <a name="SSLOCSPNoverify" id="SSLOCSPNoverify">SSLOCSPNoverify</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Evite la vrification des certificats des rpondeurs OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPNoverify <em>On/Off</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPNoverify Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.26 du serveur HTTP Apache,
sous rserve d'utiliser une version 0.9.7 ou suprieure d'OpenSSL</td></tr>
</table>
<p>Cette directive permet d'viter la vrification des certificats
des rpondeurs OCSP, ce qui peut s'avrer utile lorsqu'on teste un serveur OCSP.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspoverrideresponder" id="sslocspoverrideresponder">Directive</a> <a name="SSLOCSPOverrideResponder" id="SSLOCSPOverrideResponder">SSLOCSPOverrideResponder</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Force l'utilisation de l'URI du rpondeur par dfaut pour
la validation OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPOverrideResponder on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPOverrideResponder off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Force l'utilisation, au cours d'une validation OCSP de certificat, du
rpondeur OCSP par dfaut spcifi dans la configuration, que le
certificat en cours de vrification fasse mention d'un rpondeur OCSP ou
non.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspproxyurl" id="sslocspproxyurl">Directive</a> <a name="SSLOCSPProxyURL" id="SSLOCSPProxyURL">SSLOCSPProxyURL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Adresse de mandataire  utiliser pour les requtes OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPProxyURL <em>url</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.19 du serveur HTTP Apache</td></tr>
</table>
<p>Cette directive permet de dfinir l'URL d'un mandataire HTTP qui devra tre
utilis pour toutes les requtes vers un rpondeur OCSP.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocsprespondercertificatefile" id="sslocsprespondercertificatefile">Directive</a> <a name="SSLOCSPResponderCertificateFile" id="SSLOCSPResponderCertificateFile">SSLOCSPResponderCertificateFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fournit un jeu de certificats de confiance du rpondeur OCSP avec
encodage PEM</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPResponderCertificateFile <em>file</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.26 du serveur HTTP Apache,
sous rserve d'utiliser une version 0.9.7 ou suprieure d'OpenSSL</td></tr>
</table>
<p>Cette directive permet de dfinir un fichier contenant une liste de
certificats de confiance du rpondeur OCSP  utiliser au cours de la validation
du certificat du rpondeur OCSP. Les certificats fournis peuvent
tre considrs comme de confiance sans avoir  effectuer de vrifications
supplmentaires. Ce processus de validation du certificat du rpondeur OCSP
intervient en gnral lorsque ce dernier est autosign ou tout simplement absent
de la rponse OCSP.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocsprespondertimeout" id="sslocsprespondertimeout">Directive</a> <a name="SSLOCSPResponderTimeout" id="SSLOCSPResponderTimeout">SSLOCSPResponderTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dlai d'attente pour les requtes OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPResponderTimeout <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPResponderTimeout 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette option permet de dfinir le dlai d'attente pour les requtes 
destination des rpondeurs OCSP, lorsque la directive <code class="directive"><a href="#sslocspenable">SSLOCSPEnable</a></code> est  on.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspresponsemaxage" id="sslocspresponsemaxage">Directive</a> <a name="SSLOCSPResponseMaxAge" id="SSLOCSPResponseMaxAge">SSLOCSPResponseMaxAge</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Age maximum autoris pour les rponses OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPResponseMaxAge <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPResponseMaxAge -1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette option permet de dfinir l'ge maximum autoris (la
"fraicheur") des rponses OCSP. La valeur par dfault (<code>-1</code>)
signifie qu'aucun ge maximum n'est dfini ; autrement dit, les
rponses OCSP sont considres comme valides tant que la valeur de leur
champ <code>nextUpdate</code> se situe dans le futur.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspresponsetimeskew" id="sslocspresponsetimeskew">Directive</a> <a name="SSLOCSPResponseTimeSkew" id="SSLOCSPResponseTimeSkew">SSLOCSPResponseTimeSkew</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Drive temporelle maximale autorise pour la validation des
rponses OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPResponseTimeSkew <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPResponseTimeSkew 300</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette option permet de dfinir la drive temporelle maximale
autorise pour les rponses OCSP (lors de la vrification des champs
<code>thisUpdate</code> et <code>nextUpdate</code>).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslocspuserequestnonce" id="sslocspuserequestnonce">Directive</a> <a name="SSLOCSPUseRequestNonce" id="SSLOCSPUseRequestNonce">SSLOCSPUseRequestNonce</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Use a nonce within OCSP queries</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOCSPUseRequestNonce on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLOCSPUseRequestNonce on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Available in httpd 2.4.10 and later</td></tr>
</table><p>La documentation de cette directive
	n'a pas encore t traduite. Veuillez vous reporter  la version
	en langue anglaise.</p></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslopensslconfcmd" id="sslopensslconfcmd">Directive</a> <a name="SSLOpenSSLConfCmd" id="SSLOpenSSLConfCmd">SSLOpenSSLConfCmd</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configuration des paramtres d'OpenSSL via son API <em>SSL_CONF</em></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOpenSSLConfCmd <em>commande</em> <em>valeur</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.4.8 du serveur HTTP
Apache avec OpenSSL 1.0.2 ou suprieur</td></tr>
</table>
<p>Cette directive permet  mod_ssl d'accder  l'API <em>SSL_CONF</em>
d'OpenSSL. Il n'est ainsi plus ncessaire d'implmenter des
directives supplmentaires pour <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> lorsque de nouvelles
fonctionnalits sont ajoutes  OpenSSL, ce qui rend la configuration de
ce dernier beaucoup plus souple.</p>

<p>Le jeu de commandes disponibles pour la directive
<code class="directive">SSLOpenSSLConfCmd</code> dpend de la version d'OpenSSL
utilise pour <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> (la version minimale 1.0.2 est un
prrequis). Pour obtenir la liste des commandes supportes, voir la
section <em>Supported configuration file commands</em> de la page de
manuel d'OpenSSL <a href="http://www.openssl.org/docs/man1.0.2/ssl/SSL_CONF_cmd.html#SUPPORTED-CONFIGURATION-FILE-COMMANDS">SSL_CONF_cmd(3)</a>.</p>

<p>Certaines commandes peuvent remplacer des directives existantes
(comme <code class="directive"><a href="#sslciphersuite">SSLCipherSuite</a></code> ou
<code class="directive"><a href="#sslprotocol">SSLProtocol</a></code>) ; notez cependant
que la syntaxe et/ou les valeurs possibles peuvent diffrer.</p>

<div class="example"><h3>Examples</h3><pre class="prettyprint lang-config">SSLOpenSSLConfCmd Options -SessionTicket,ServerPreference
SSLOpenSSLConfCmd ECDHParameters brainpoolP256r1
SSLOpenSSLConfCmd ServerInfoFile
"/usr/local/apache2/conf/server-info.pem"
SSLOpenSSLConfCmd Protocol "-ALL, TLSv1.2"
SSLOpenSSLConfCmd SignatureAlgorithms RSA+SHA384:ECDSA+SHA256</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ssloptions" id="ssloptions">Directive</a> <a name="SSLOptions" id="SSLOptions">SSLOptions</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure diffrentes options d'excution du moteur SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLOptions [+|-]<em>option</em> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Options</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de contrler diffrentes options d'excution du
moteur SSL dans un contexte de rpertoire. Normalement, si plusieurs
<code>SSLOptions</code> peuvent s'appliquer  un rpertoire, c'est la
plus spcifique qui est vritablement prise en compte ; les options ne
se combinent pas entre elles. Elles se combinent cependant entre elles
si elles sont <em>toutes</em> prcdes par un symbole plus
(<code>+</code>) ou moins (<code>-</code>). Toute option prcde d'un
<code>+</code> est ajoute aux options actuellement en vigueur, et toute
option prcde d'un <code>-</code> est supprime de ces mmes
options.
</p>
<p>
Les <em>option</em>s disponibles sont :</p>
<ul>
<li><code>StdEnvVars</code>
    <p>
    Lorsque cette option est active, le jeu standard de variables
    d'environnement SSL relatives  CGI/SSI est cr. Cette option est
    dsactive par dfaut pour des raisons de performances, car
    l'extraction des informations constitue une opration assez coteuse
    en ressources. On n'active donc en gnral cette option que pour les
    requtes CGI et SSI.</p>
</li>
<li><code>ExportCertData</code>
    <p>
    Lorsque cette option est active, des variables d'environnement
    CGI/SSI supplmentaires sont cres : <code>SSL_SERVER_CERT</code>,
    <code>SSL_CLIENT_CERT</code> et
    <code>SSL_CLIENT_CERT_CHAIN_</code><em>n</em> (avec <em>n</em> =
    0,1,2,..). Elles contiennent les certificats X.509 cods en PEM du
    serveur et du client pour la connexion HTTPS courante, et peuvent
    tre utilises par les scripts CGI pour une vrification de
    certificat plus labore. De plus, tous les autres certificats de la
    chane de certificats du client sont aussi fournis. Tout ceci gonfle
    un peu l'environnement, et c'est la raison pour laquelle vous ne
    devez activer cette option qu' la demande.</p>
</li>
<li><code>FakeBasicAuth</code>
    <p>
    Lorsque cette option est active, le Nom Distinctif (DN) sujet du
    certificat client X509 est traduit en un nom d'utilisateur pour
    l'autorisation HTTP de base. Cela signifie que les mthodes
    d'authentification standard d'Apache peuvent tre utilises pour le
    contrle d'accs. Le nom d'utilisateur est tout simplement le Sujet
    du certificat X509 du client (il peut tre dtermin en utilisant la
    commande OpenSSL <code>openssl x509</code> : <code>openssl x509
    -noout -subject -in </code><em>certificat</em><code>.crt</code>).
    Notez qu'aucun mot de passe n'est envoy par l'utilisateur. Chaque
    entre du fichier des utilisateurs doit comporter ce mot de passe :
    ``<code>xxj31ZMTZzkVA</code>'', qui est la version chiffre en DES
    du mot ``<code>password</code>''. Ceux qui travaillent avec un
    chiffrement bas sur MD5 (par exemple sous FreeBSD ou BSD/OS,
    etc...) doivent utiliser le condens MD5 suivant pour le mme mot :
    ``<code>$1$OXLyS...$Owx8s2/m9/gfkcRVXzgoE/</code>''.</p>

    <p>Notez que la directive <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicfake">AuthBasicFake</a></code> implmente par le
    module <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> peut tre utilise d'une
    manire plus gnrale comme simulation d'authentification basique,
    ce qui permet de contrler la structure nom utilisateur/mot de
    passe.</p>
</li>
<li><code>StrictRequire</code>
    <p>
    Cette option <em>force</em> l'interdiction d'accs lorsque
    <code>SSLRequireSSL</code> ou <code>SSLRequire</code> a dcid que
    l'accs devait tre interdit. Par dfaut, dans le cas o
    une directive ``<code>Satisfy any</code>'' est utilise, et si
    d'autres restrictions d'accs ont t franchies, on passe en gnral
    outre l'interdiction d'accs due  <code>SSLRequireSSL</code> ou
    <code>SSLRequire</code> (parce que c'est ainsi que le mcanisme
    <code>Satisfy</code> d'Apache doit fonctionner). Pour des
    restrictions d'accs plus strictes, vous pouvez cependant utiliser
    <code>SSLRequireSSL</code> et/ou <code>SSLRequire</code> en
    combinaison avec une option ``<code>SSLOptions
    +StrictRequire</code>''. Une directive ``<code>Satisfy Any</code>''
    n'a alors aucune chance d'autoriser l'accs si mod_ssl a dcid de
    l'interdire.</p>
</li>
<li><code>OptRenegotiate</code>
    <p>
    Cette option active la gestion optimise de la rengociation des
    connexions SSL intervenant lorsque les directives SSL sont utilises
    dans un contexte de rpertoire. Par dfaut un schma strict est
    appliqu, et <em>chaque</em> reconfiguration des paramtres SSL au
    niveau du rpertoire implique une phase de rengociation SSL
    <em>complte</em>. Avec cette option, mod_ssl essaie d'viter les
    changes non ncessaires en effectuant des vrifications de
    paramtres plus granulaires (mais tout de mme efficaces).
    Nanmoins, ces vrifications granulaires peuvent ne pas correspondre
     ce qu'attend l'utilisateur, et il est donc recommand de n'activer
    cette option que dans un contexte de rpertoire.</p>
</li>
<li><code>LegacyDNStringFormat</code>
    <p>
    Cette option permet d'agir sur la manire dont les valeurs des
    variables <code>SSL_{CLIENT,SERVER}_{I,S}_DN</code> sont formates.
    Depuis la version 2.3.11, Apache HTTPD utilise par dfaut un format
    compatible avec la RFC 2253. Ce format utilise des virgules comme
    dlimiteurs entre les attributs, permet l'utilisation de caractres
    non-ASCII (qui sont alors convertis en UTF8), chappe certains
    caractres spciaux avec des slashes inverss, et trie les attributs
    en plaant l'attribut "C" en dernire position.</p>

    <p>Si l'option <code>LegacyDNStringFormat</code> est prsente, c'est
    l'ancien format qui sera utilis : les attributs sont tris avec
    l'attribut "C" en premire position, les sparateurs sont des
    slashes non inverss, les caractres non-ASCII ne sont pas supports
    et le support des caractres spciaux n'est pas fiable.
    </p>
</li>
</ul>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLOptions +FakeBasicAuth -StrictRequire
&lt;Files ~ "\.(cgi|shtml)$"&gt;
    SSLOptions +StdEnvVars -ExportCertData
&lt;/Files&gt;</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslpassphrasedialog" id="sslpassphrasedialog">Directive</a> <a name="SSLPassPhraseDialog" id="SSLPassPhraseDialog">SSLPassPhraseDialog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Mthode utilise pour entrer le mot de passe pour les cls
prives chiffres</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLPassPhraseDialog <em>type</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLPassPhraseDialog builtin</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Lors de son dmarrage, Apache doit lire les diffrents fichiers de
certificats (voir la directive <code class="directive"><a href="#sslcertificatefile">SSLCertificateFile</a></code>) et de cls prives
(voir la directive <code class="directive"><a href="#sslcertificatekeyfile">SSLCertificateKeyFile</a></code>) des serveurs
virtuels o SSL est activ. Comme, pour des raisons de scurit, les
fichiers de cls prives sont en gnral chiffrs,  mod_ssl doit
demander  l'administrateur un mot de passe pour dchiffrer ces
fichiers. L'argument <em>type</em> permet de choisir la manire dont
cette demande peut tre formule parmi les trois suivantes :</p>
<ul>
<li><code>builtin</code>
    <p>
    C'est la mthode par dfaut, et un dialogue interactive de terminal
    s'ouvre au cours du dmarrage juste avant qu'Apache ne se dtache du
    terminal. A ce moment, l'administrateur doit entrer manuellement un
    mot de passe pour chaque fichier de cl prive chiffr. Etant donn
    qu'il peut y avoir un grand nombre de serveurs virtuels configurs
    avec SSL activ, le protocole de rutilisation suivant est utilis
    pour minimiser le dialogue : lorsqu'un fichier de cl prive est
    chiffr, tous les mots de passe connus (au dbut, il n'y en a aucun,
    bien entendu) sont essays. Si l'un de ces mots de passe connus
    convient, aucun dialogue ne s'ouvrira pour ce fichier de
    cl prive particulier. Si aucun ne convient, un autre mot de passe
    sera demand  partir du terminal et sera mis en mmoire pour le
    fichier de cl prive suivant (pour lequel il pourra ventuellement
    tre rutilis).</p>
    <p>
    Cette mthode confre  mod_ssl une grande souplesse (car pour N
    fichiers de cl prive chiffrs, vous <em>pouvez</em> utiliser N
    mots de passe diffrents - mais vous devrez alors tous les fournir,
    bien entendu), tout en minimisant le dialogue de terminal (vous
    pouvez en effet utiliser un seul mot de passe pour les N fichiers de
    cl prive et vous n'aurez alors  l'entrer qu'une seule
    fois).</p></li>

<li><code>|/chemin/vers/programme [arguments...]</code>

   <p>Ce mode permet d'utiliser un programme externe qui va se prsenter
   comme une redirection vers un priphrique d'entre particulier ; le
   texte de prompt standard utilis pour le mode <code>builtin</code>
   est envoy au programme sur <code>stdin</code>, et celui-ci doit
   renvoyer des mots de passe sur <code>stdout</code>. Si
   plusieurs mots de passe sont requis (ou si un mot de passe incorrect
   a t entr), un texte de prompt supplmentaire sera crit aprs le
   retour du premier mot de passe, et d'autres mots de passe devront
   alors tre rcrits.</p></li>

<li><code>exec:/chemin/vers/programme</code>
    <p>
    Ici, un programme externe est appel au dmarrage du serveur pour
    chaque fichier de cl prive chiffr.Il est appel avec deux
    arguments (le premier est de la forme
    ``<code>nom-serveur:port</code>'', le second
    est ``<code>RSA</code>'', ``<code>DSA</code>'', ``<code>ECC</code>''
    ou un index entier commenant  3 si plus de 3 cls ont t
    configures), qui
    indiquent pour quels serveur et algorithme il doit crire le mot de
    passe correspondant sur <code>stdout</code>. Avec les versions 2.4.8
    (non ralise) et
    2.4.9, il est appel avec un seul argument, une chane de la forme
    "<code>servername:portnumber:index</code>" (o <code>index</code>
    est un nombre entier commenant  zro), qui spcifie le serveur,
    le port TCP et un numro de certificat. Le but recherch est
    l'excution de vrifications de scurit pralables permettant de
    s'assurer que le systme n'est pas victime d'une attaque, et de ne
    fournir le mot de passe que si toutes les vrifications ont t
    effectues avec succs.</p>
    <p>
    Ces vrifications de scurit, ainsi que la manire dont le mot de
    passe est dtermin peuvent tre aussi sophistiqus que vous le
    dsirez. Mod_ssl ne dfinit que l'interface : un programme
    excutable qui crit le mot de passe sur <code>stdout</code>. Ni
    plus, ni moins ! Ainsi, si vous tes vraiment paranoaque en matire
    de scurit, voici votre interface. Tout le reste doit tre confi 
    l'administrateur  titre d'exercice, car les besoins en scurit
    locale sont trs diffrents.</p>
    <p>
    L'algorithme de rutilisation est utilis ici aussi. En d'autres
    termes, le programme externe n'est appel qu'une fois par mot de
    passe unique.</p></li>
</ul>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLPassPhraseDialog "exec:/usr/local/apache/sbin/pp-filter"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslprotocol" id="sslprotocol">Directive</a> <a name="SSLProtocol" id="SSLProtocol">SSLProtocol</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Indique les versions du protocole SSL/TLS
disponibles</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProtocol [+|-]<em>protocole</em> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProtocol all -SSLv3 (jusqu' la version 2.4.16 : all)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir quelles versions du protocole SSL/TLS
seront acceptes lors de l'initialisation d'une nouvelle connexion.</p>
<p>
Les <em>protocole</em>s disponibles sont les suivants (sensibles  la
casse) :</p>
<ul>
<li><code>SSLv3</code>
    <p>
    Il s'agit du protocole Secure Sockets Layer (SSL) version 3.0 de
    Netscape Corporation. C'est le successeur de SSLv2 et le
    prdcesseur de TLSv1, mais est considr comme
    obsolte dans la <a href="http://www.ietf.org/rfc/rfc7568.txt">RFC
    7568</a></p></li>

<li><code>TLSv1</code>
    <p>
    Il s'agit du protocole  Transport Layer Security (TLS) version 1.0.
    C'est le successeur de SSLv3, et il est dfini dans la <a href="http://www.ietf.org/rfc/rfc2246.txt">RFC2246</a>. Il est
    support par la plupart des clients.</p></li>

<li><code>TLSv1.1</code> ( partir de la version 1.0.1 d'OpenSSL)
    <p>
    Une rvision du protocole TLS 1.0 dfinie dans la <a href="http://www.ietf.org/rfc/rfc4346.txt">RFC 4346</a>.</p></li>

<li><code>TLSv1.2</code> ( partir de la version 1.0.1 d'OpenSSL)
    <p>
    Une rvision du protocole TLS 1.1 dfinie dans la <a href="http://www.ietf.org/rfc/rfc5246.txt">RFC 5246</a>.</p></li>

<li><code>all</code>
    <p>
    C'est un raccourci pour ``<code>+SSLv3 +TLSv1</code>'' ou -  partir
    de la version 1.0.1 d'OpenSSL - ``<code>+SSLv3 +TLSv1 +TLSv1.1
    +TLSv1.2</code>'' (sauf si OpenSSL a t compil avec l'option
    ``no-ssl3'', auquel cas <code>all</code> n'inclura pas
    <code>+SSLv3</code>).</p></li>
</ul>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProtocol TLSv1</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycacertificatefile" id="sslproxycacertificatefile">Directive</a> <a name="SSLProxyCACertificateFile" id="SSLProxyCACertificateFile">SSLProxyCACertificateFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant la concatnation des certificats de CA
cods en PEM pour l'authentification des serveurs distants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCACertificateFile <em>file-path</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le fichier <em>tout-en-un</em> o sont
stocks les certificats des Autorits de Certification (CA) pour les
<em>serveurs distants</em> auxquels vous avez  faire. On les utilise
lors de l'authentification du serveur distant. Un tel fichier contient
la simple concatnation des diffrents fichiers de certificats cods en
PEM, classs par ordre de prfrence. On peut utiliser cette directive 
la place et/ou en complment de la directive <code class="directive"><a href="#sslproxycacertificatepath">SSLProxyCACertificatePath</a></code>.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCACertificateFile
"/usr/local/apache2/conf/ssl.crt/ca-bundle-serveur.distant.crt"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycacertificatepath" id="sslproxycacertificatepath">Directive</a> <a name="SSLProxyCACertificatePath" id="SSLProxyCACertificatePath">SSLProxyCACertificatePath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire des certificats de CA cods en PEM pour
l'authentification des serveurs distants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCACertificatePath <em>chemin-rpertoire</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de spcifier le rpertoire o sont stocks les
certificats des Autorits de Certification (CAs) pour les serveurs
distants auxquels vous avez  faire. On les utilise pour vrifier le
certificat du serveur distant lors de l'authentification de ce
dernier.</p>
<p>
Les fichiers de ce rpertoire doivent tre cods en PEM et ils sont
accds via des noms de fichier sous forme de condenss ou hash. Il ne
suffit donc pas de placer les fichiers de certificats dans ce rpertoire
: vous devez aussi crer des liens symboliques nomms
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce rpertoire contient les liens symboliques appropris.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCACertificatePath "/usr/local/apache2/conf/ssl.crt/"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycarevocationcheck" id="sslproxycarevocationcheck">Directive</a> <a name="SSLProxyCARevocationCheck" id="SSLProxyCARevocationCheck">SSLProxyCARevocationCheck</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la vrification des rvocations base sur les CRLs
pour l'authentification du serveur distant</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCARevocationCheck chain|leaf|none</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyCARevocationCheck none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Active la vrification des rvocations base sur les Listes de
rvocations de Certificats (CRL) pour les <em>serveurs distants</em>
auxquels vous vous connectez. A moins une des directives <code class="directive"><a href="#sslproxycarevocationfile">SSLProxyCARevocationFile</a></code> ou <code class="directive"><a href="#sslproxycarevocationpath">SSLProxyCARevocationPath</a></code> doit tre dfinie.
Lorsque cette directive est dfinie  <code>chain</code> (valeur
recommande), les vrifications CRL sont effectues sur tous les
certificats de la chane, alors que la valeur <code>leaf</code> limite
la vrification au certificat hors chane (la feuille).
</p>
<div class="note">
<h3>Lorsque la directive est dfinie  <code>chain</code> ou
<code>leaf</code>, les CRLs doivent tre disponibles pour que la
validation russisse</h3>
<p>
Avant la version 2.3.15, les vrifications CRL dans mod_ssl
russissaient mme si aucune CRL n'tait trouve dans les chemins
dfinis par les directives <code class="directive"><a href="#sslproxycarevocationfile">SSLProxyCARevocationFile</a></code> ou <code class="directive"><a href="#sslproxycarevocationpath">SSLProxyCARevocationPath</a></code>. Le comportement a
chang avec l'introduction de cette directive : lorsque la vrification
est active, les CRLs <em>doivent</em> tre prsentes pour que la
validation russisse ; dans le cas contraire, elle chouera avec une
erreur <code>"CRL introuvable"</code>.
</p>
</div>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCARevocationCheck chain</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycarevocationfile" id="sslproxycarevocationfile">Directive</a> <a name="SSLProxyCARevocationFile" id="SSLProxyCARevocationFile">SSLProxyCARevocationFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant la concatnation des CRLs de CA cods en
PEM pour l'authentification des serveurs distants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCARevocationFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le fichier <em>tout-en-un</em> o sont
rassembles les Listes de Rvocation de Certificats (CRLs) des Autorits
de certification (CAs) pour les <em>serveurs distants</em> auxquels vous
avez  faire. On les utilise pour l'authentification des serveurs
distants. Un tel fichier contient la simple concatnation des diffrents
fichiers de CRLs cods en PEM, classs par ordre de prfrence. Cette
directive peut tre utilise  la place et/ou en complment de la
directive <code class="directive"><a href="#sslproxycarevocationpath">SSLProxyCARevocationPath</a></code>.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCARevocationFile
"/usr/local/apache2/conf/ssl.crl/ca-bundle-serveur.distant.crl"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycarevocationpath" id="sslproxycarevocationpath">Directive</a> <a name="SSLProxyCARevocationPath" id="SSLProxyCARevocationPath">SSLProxyCARevocationPath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire des CRLs de CA cods en PEM pour
l'authentification des serveurs distants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCARevocationPath <em>chemin-rpertoire</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le rpertoire o sont stockes les
Listes de Rvocation de Certificats (CRL) des Autorits de Certification
(CAs) pour les serveurs distants auxquels vous avez  faire. On les
utilise pour rvoquer les certificats des serveurs distants au cours de
l'authentification de ces derniers.</p>
<p>
Les fichiers de ce rpertoire doivent tre cods en PEM et ils sont
accds via des noms de fichier sous forme de condenss ou hash. Il ne
suffit donc pas de placer les fichiers de CRL dans ce rpertoire
: vous devez aussi crer des liens symboliques nomms
<em>valeur-de-hashage</em><code>.rN</code>, et vous devez toujours vous
assurer que ce rpertoire contient les liens symboliques appropris.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCARevocationPath "/usr/local/apache2/conf/ssl.crl/"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycheckpeercn" id="sslproxycheckpeercn">Directive</a> <a name="SSLProxyCheckPeerCN" id="SSLProxyCheckPeerCN">SSLProxyCheckPeerCN</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configuration de la vrification du champ CN du certificat
du serveur distant
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCheckPeerCN on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyCheckPeerCN on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir si le champ CN du certificat du serveur
distant doit tre compar au nom de serveur de l'URL de la requte. S'ils ne
correspondent pas, un code d'tat 502 (Bad Gateway) est envoy. A partir de la
version 2.4.5, SSLProxyCheckPeerCN a t remplac par <code class="directive"><a href="#sslproxycheckpeername">SSLProxyCheckPeerName</a></code>.
</p>
<p>
De la version 2.4.5  la version 2.4.20, spcifier <code>SSLProxyCheckPeerName
off</code> tait suffisant pour obtenir ce comportement (car la valeur par
dfaut de <code>SSLProxyCheckPeerCN</code> tait <code>on</code>). Avec ces
versions, les deux directives doivent tre dfinies  <code>off</code> pour
viter toute validation du nom de certificat du serveur distant, et de
nombreux utilisateurs ont signal ce comportement comme trs perturbant.
</p>
<p>
A partir de la version 2.4.21, toutes les configurations qui activent au moins
une des deux directives <code>SSLProxyCheckPeerName</code> ou
<code>SSLProxyCheckPeerCN</code> adopteront le nouveau comportement de la
directive <code class="directive"><a href="#sslproxycheckpeername">SSLProxyCheckPeerName</a></code>, et
toutes les configurations qui dsactivent une des deux directives
<code>SSLProxyCheckPeerName</code> ou <code>SSLProxyCheckPeerCN</code>
viteront toute validation du nom de certificat du serveur distant. Seule la
configuration suivante permettra de retrouver la comparaison de CN
traditionnelle pour les versions 2.4.21 et suprieures :
</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCheckPeerCN on
SSLProxyCheckPeerName off</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycheckpeerexpire" id="sslproxycheckpeerexpire">Directive</a> <a name="SSLProxyCheckPeerExpire" id="SSLProxyCheckPeerExpire">SSLProxyCheckPeerExpire</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configuration de la vrification de l'expiration du
certificat du serveur distant
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCheckPeerExpire on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyCheckPeerExpire on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir si l'expiration du certificat du
serveur distant doit tre vrifie ou non. Si la vrification choue, un
code d'tat 502 (Bad Gateway) est envoy.
</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyCheckPeerExpire on</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxycheckpeername" id="sslproxycheckpeername">Directive</a> <a name="SSLProxyCheckPeerName" id="SSLProxyCheckPeerName">SSLProxyCheckPeerName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure la vrification du nom d'hte dans les
certificats serveur distants
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCheckPeerName on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyCheckPeerName on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.5 du serveur HTTP
Apache</td></tr>
</table>
<p>
Cette directive permet de configurer la vrification du nom d'hte pour
les certificats serveur lorsque mod_ssl agit en tant que client SSL. La
vrification russit si le nom d'hte de l'URI de la requte correspond  un
des attributs CN du sujet du certificat, ou  l'extension subjectAltName. Si la
vrification choue, la requte SSL
avorte, et un code d'erreur 502 (Bad Gateway) est renvoy.
</p>
<p>
Les caractres gnriques sont supports dans certains cas bien spcifiques :
une entre subjectAltName de type dNSName ou les attributs CN
commenant par <code>*.</code> correspondront  tout nom d'hte comportant
le mme nombre de champs et le mme suffixe ; par exemple,
<code>*.example.org</code> correspondra  <code>foo.example.org</code>,
mais pas  <code>foo.bar.example.org</code> car le nombre d'lments dans les
nom est diffrent.
</p>
<p>
Cette fonctionnalit a t introduite avec la version 2.4.5 et l'emporte sur la
directive <code class="directive"><a href="#sslproxycheckpeercn">SSLProxyCheckPeerCN</a></code> qui ne
comparait que la valeur exacte du premier attribut CN avec le nom d'hte.
Cependant, de nombreux utilisateurs taient dconcerts par le comportement
induit par l'utilisation de ces deux directives individuellement, si bien que ce
comportement a t amlior avec la version 2.4.21. Voir la description de la
directive <code class="directive"><a href="#sslproxycheckpeercn">SSLProxyCheckPeerCN</a></code> pour le
comportement original et des dtails  propos de ces amliorations.
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxyciphersuite" id="sslproxyciphersuite">Directive</a> <a name="SSLProxyCipherSuite" id="SSLProxyCipherSuite">SSLProxyCipherSuite</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Algorithmes de chiffrement disponibles pour la ngociation
lors de l'initialisation d'une connexion SSL de mandataire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyCipherSuite <em>algorithmes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyCipherSuite ALL:!ADH:RC4+RSA:+HIGH:+MEDIUM:+LOW:+EXP</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>Cette directive est quivalente  la directive <code class="directive"><a href="#sslciphersuite">SSLCipherSuite</a></code>, mais s'applique  une connexion de
mandataire. Veuillez vous reporter  la directive <code class="directive"><a href="#sslciphersuite">SSLCipherSuite</a></code> pour plus d'informations.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxyengine" id="sslproxyengine">Directive</a> <a name="SSLProxyEngine" id="SSLProxyEngine">SSLProxyEngine</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interrupteur marche/arrt du moteur de mandataire
SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyEngine on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyEngine off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet d'activer/dsactiver l'utilisation du moteur de
protocole SSL/TLS pour le mandataire. On l'utilise en gnral 
l'intrieur d'une section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> pour activer le protocole SSL/TLS
dans le cadre d'un mandataire pour un serveur virtuel particulier. Par
dfaut, le moteur de protocole SSL/TLS est dsactiv pour la fonction de
mandataire du serveur principal et de tous les serveurs virtuels
configurs.</p>

<p>Notez que la directive <code class="directive">SSLProxyEngine</code> ne doit
gnralement pas tre utilise dans le cadre d'un serveur virtuel qui agit en
tant que mandataire direct (via les directives <code class="directive"><a href="../mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code> ou <code class="directive"><a href="../mod/mod_proxy.html#proxyrequests">ProxyRequests</a></code>).
<code class="directive">SSLProxyEngine</code> n'est pas ncessaire pour activer un
serveur mandataire direct pour les requtes SSL/TLS.</p>


<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">&lt;VirtualHost _default_:443&gt;
    SSLProxyEngine on
    #...
&lt;/VirtualHost&gt;</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxymachinecertificatechainfile" id="sslproxymachinecertificatechainfile">Directive</a> <a name="SSLProxyMachineCertificateChainFile" id="SSLProxyMachineCertificateChainFile">SSLProxyMachineCertificateChainFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier de certificats de CA encods PEM concatns permettant au
mandataire de choisir un certificat</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyMachineCertificateChainFile <em>nom-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le fichier global o est enregistre
la chane de certification pour tous les certificats clients utiliss.
Elle est ncessaire si le serveur distant prsente une liste de
certificats de CA qui ne sont pas les signataires directs d'un des
certificats clients configurs.
</p>
<p>
Ce fichier contient tout simplement la concatnation des diffrents
fichiers de certificats encods PEM. Au dmarrage, chaque certificat
client configur est examin et une chane de certification est
construite.
</p>
<div class="warning"><h3>Avertissement en matire de scurit</h3>
<p>Si cette directive est dfinie, tous les certificats contenus dans le
fichier spcifi seront considrs comme tant de confiance, comme s'ils
taient aussi dsigns dans la directive <code class="directive"><a href="#sslproxycacertificatefile">SSLProxyCACertificateFile</a></code>.</p>
</div>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyMachineCertificateChainFile
"/usr/local/apache2/conf/ssl.crt/proxyCA.pem"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxymachinecertificatefile" id="sslproxymachinecertificatefile">Directive</a> <a name="SSLProxyMachineCertificateFile" id="SSLProxyMachineCertificateFile">SSLProxyMachineCertificateFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichier contenant la concatnation des cls et certificats
clients cods en PEM que le mandataire doit utiliser</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyMachineCertificateFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le fichier tout-en-un o sont stocks
les cls et certificats permettant au serveur mandataire de
s'authentifier auprs des serveurs distants.
</p>
<p>
Le fichier spcifi est la simple concatnation des diffrents fichiers
de certificats cods en PEM, classs par ordre de prfrence. Cette
directive s'utilise  la place ou en complment de la directive
<code>SSLProxyMachineCertificatePath</code>.
</p>
<div class="warning">
<p>Actuellement, les cls prives chiffres ne sont pas supportes.</p>
</div>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyMachineCertificateFile
"/usr/local/apache2/conf/ssl.crt/proxy.pem"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxymachinecertificatepath" id="sslproxymachinecertificatepath">Directive</a> <a name="SSLProxyMachineCertificatePath" id="SSLProxyMachineCertificatePath">SSLProxyMachineCertificatePath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire des cls et certificats clients cods en PEM que
le mandataire doit utiliser</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyMachineCertificatePath <em>chemin-rpertoire</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le rpertoire o sont stocks les cls
et certificats permettant au serveur mandataire de s'authentifier auprs
des serveurs distants.
</p>
<p>Les fichiers de ce rpertoire doivent tre cods en PEM et ils sont
accds via des noms de fichier sous forme de condenss ou hash. Vous
devez donc aussi crer des liens symboliques nomms
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce rpertoire contient les liens symboliques appropris.</p>
<div class="warning">
<p>Actuellement, les cls prives chiffres ne sont pas supportes.</p>
</div>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyMachineCertificatePath "/usr/local/apache2/conf/proxy.crt/"</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxyprotocol" id="sslproxyprotocol">Directive</a> <a name="SSLProxyProtocol" id="SSLProxyProtocol">SSLProxyProtocol</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les protocoles SSL disponibles pour la fonction de
mandataire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyProtocol [+|-]<em>protocole</em> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyProtocol all -SSLv3 (jusqu' la version 2.4.16: all)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>

<p>
Cette directive permet de dfinir les protocoles SSL que mod_ssl peut
utiliser lors de l'laboration de son environnement de serveur pour la
fonction de mandataire. Il ne se connectera qu'aux serveurs utilisant un
des protocoles spcifis.</p>
<p>Veuillez vous reporter  la directive <code class="directive"><a href="#sslprotocol">SSLProtocol</a></code> pour plus d'informations.
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxyverify" id="sslproxyverify">Directive</a> <a name="SSLProxyVerify" id="SSLProxyVerify">SSLProxyVerify</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Niveau de vrification du certificat du serveur
distant</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyVerify <em>niveau</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyVerify none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>

<p>Lorsqu'un mandataire est configur pour faire suivre les requtes
vers un serveur SSL distant, cette directive permet de configurer la
vrification du certificat de ce serveur distant.</p>

<p>
Les valeurs de <em>niveau</em>x disponibles sont les suivantes :</p>
<ul>
<li><strong>none</strong>:
     aucun certificat n'est requis pour le serveur distant</li>
<li><strong>optional</strong>:
     le serveur distant <em>peut</em> prsenter un certificat valide</li>
<li><strong>require</strong>:
     le serveur distant <em>doit</em> prsenter un certificat valide</li>
<li><strong>optional_no_ca</strong>:
     le serveur distant peut prsenter un certificat valide<br />
     mais il n'est pas ncessaire qu'il soit vrifiable (avec succs).</li>
</ul>
<p>En pratique, seuls les niveaux <strong>none</strong> et
<strong>require</strong> sont vraiment intressants, car le niveau
<strong>optional</strong> ne fonctionne pas avec tous les serveurs, et
le niveau <strong>optional_no_ca</strong> va tout  fait  l'encontre de
l'ide que l'on peut se faire de l'authentification (mais peut tout de
mme tre utilis pour tablir des pages de test SSL, etc...).</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyVerify require</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslproxyverifydepth" id="sslproxyverifydepth">Directive</a> <a name="SSLProxyVerifyDepth" id="SSLProxyVerifyDepth">SSLProxyVerifyDepth</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Niveau de profondeur maximum dans les certificats de CA
lors de la vrification du certificat du serveur distant</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLProxyVerifyDepth <em>niveau</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLProxyVerifyDepth 1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, </td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le niveau de profondeur maximum
jusqu'auquel mod_ssl doit aller au cours de sa vrification avant de
dcider que le serveur distant ne possde pas de certificat valide.</p>
<p>
La profondeur correspond en fait au nombre maximum de fournisseurs de
certificats intermdiaires, c'est  dire le nombre maximum de
certificats
de CA que l'on peut consulter lors de la vrification du certificat du
serveur distant. Une profondeur de 0 signifie que seuls les certificats
de serveurs distants auto-signs sont accepts, et la profondeur par
dfaut de 1 que le certificat du serveur distant peut tre soit
auto-sign, soit sign par une CA connue directement du serveur (en
d'autres termes, le certificat de CA est rfrenc par la directive
<code class="directive"><a href="#sslproxycacertificatepath">SSLProxyCACertificatePath</a></code>),
etc...</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLProxyVerifyDepth 10</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslrandomseed" id="sslrandomseed">Directive</a> <a name="SSLRandomSeed" id="SSLRandomSeed">SSLRandomSeed</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Source de dclenchement du Gnrateur de Nombres
Pseudo-Alatoires (PRNG)</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLRandomSeed <em>contexte</em> <em>source</em>
[<em>nombre</em>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir une ou plusieurs sources de
dclenchement du Gnrateur de Nombres Pseudo-Alatoires (PRNG) dans
OpenSSL au dmarrage du serveur (si <em>contexte</em> a pour valeur
<code>startup</code>) et/ou juste avant l'tablissement d'une nouvelle
connexion SSL (si <em>contexte</em> a pour valeur <code>connect</code>).
Cette directive ne peut tre utilise qu'au niveau du serveur global car
le PRNG est un service global.</p>
<p>
Les diffrentes valeurs de <em>source</em> disponibles sont :</p>
<ul>
<li><code>builtin</code>
    <p>Cette source de dclenchement intgre est toujours disponible.
    Son utilisation consomme un minimum de cycles CPU en cours
    d'excution, et son utilisation ne prsente de ce fait aucun
    problme. La source utilise pour dclencher le PRNG contient la
    date courante, l'identifiant du processus courant et (si disponible)
    un extrait de 1Ko alatoirement choisi de la structure d'Apache pour
    les changes inter-processus. Ceci prsente un inconvnient car le
    caractre alatoire de cette source n'est pas vraiment fort, et au
    dmarrage (lorsque la structure d'changes n'est pas encore
    disponible), cette source ne produit que quelques octets d'entropie.
    Vous devez donc toujours utiliser une source de dclenchement
    additionnelle, au moins pour le dmarrage.</p></li>
<li><code>file:/chemin/vers/source</code>
    <p>
    Cette variante utilise un fichier externe
    <code>file:/chemin/vers/source</code> comme source de dclenchement
    du PRNG. Lorsque <em>nombre</em> est spcifi, seuls les
    <em>nombre</em> premiers octets du fichier forment l'entropie (et
    <em>nombre</em> est fourni comme premier argument 
    <code>/chemin/vers/source</code>). Lorsque <em>nombre</em> n'est pas
    spcifi, l'ensemble du fichier forme l'entropie (et <code>0</code>
    est fourni comme premier argument 
    <code>/chemin/vers/source</code>). Utilisez cette source en
    particulier au dmarrage, par exemple avec un fichier de
    priphrique <code>/dev/random</code> et/ou
    <code>/dev/urandom</code> (qui sont en gnral prsent sur les
    plate-formes drives d'Unix modernes comme FreeBSD et Linux).</p>
    <p><em>Soyez cependant prudent</em> : en gnral,
    <code>/dev/random</code> ne fournit que l'entropie dont il dispose
    rellement ; en d'autres termes, lorsque vous demandez 512 octets
    d'entropie, si le priphrique ne dispose que de 100 octets, deux
    choses peuvent se produire : sur certaines plates-formes, vous ne
    recevez que les 100 octets, alors que sur d'autres, la lecture se
    bloque jusqu' ce qu'un nombre suffisant d'octets soit disponible
    (ce qui peut prendre beaucoup de temps). Il est prfrable ici
    d'utiliser le priphrique <code>/dev/urandom</code>, car il ne se
    bloque jamais et fournit vraiment la quantit de donnes demandes.
    Comme inconvnient, les donnes reues ne sont pas forcment de la
    meilleure qualit.</p></li>

<li><code>exec:/chemin/vers/programme</code>
    <p>
    Cette variante utilise un excutable externe
    <code>/chemin/vers/programme</code> comme source de dclenchement du
    PRNG. Lorsque <em>nombre</em> est spcifi, seules les
    <em>nombre</em> premiers octets de son flux <code>stdout</code>
    forment l'entropie. Lorsque <em>nombre</em> n'est pas spcifi,
    l'intgralit des donnes produites sur <code>stdout</code> forment
    l'entropie. N'utilisez cette variante qu'au dmarrage o une source
    de dclenchement fortement alatoire est ncessaire, en utilisant
    un programme externe (comme dans l'exemple
    ci-dessous avec l'utilitaire <code>truerand</code> bas sur la
    bibliothque <em>truerand</em> de AT&amp;T que vous trouverez
    dans la distribution de mod_ssl). Bien entendu, l'utilisation de
    cette variante dans un contexte "connection" ralentit le serveur de
    manire trop importante, et en gnral, vous devez donc viter
    d'utiliser des programmes externes dans ce contexte.</p></li>
<li><code>egd:/chemin/vers/socket-egd</code> (Unix seulement)
    <p>Cette variante utilise le socket de domaine Unix du Dmon
    Gnrateur d'Entropie externe ou Entropy Gathering Daemon ou EGD
    (voir <a href="http://www.lothar.com/tech/crypto/">http://www.lothar.com/tech
    /crypto/</a>) pour dclencher le PRNG. N'utilisez cette variante que
    si votre plate-forme ne possde pas de priphrique random ou
    urandom.</p></li>
</ul>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLRandomSeed startup builtin
SSLRandomSeed startup "file:/dev/random"
SSLRandomSeed startup "file:/dev/urandom" 1024
SSLRandomSeed startup "exec:/usr/local/bin/truerand" 16
SSLRandomSeed connect builtin
SSLRandomSeed connect "file:/dev/random"
SSLRandomSeed connect "file:/dev/urandom" 1024</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslrenegbuffersize" id="sslrenegbuffersize">Directive</a> <a name="SSLRenegBufferSize" id="SSLRenegBufferSize">SSLRenegBufferSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la taille du tampon de rengociation
SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLRenegBufferSize <var>taille</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLRenegBufferSize 131072</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>

<p>Si une rengociation SSL est requise dans un contexte de rpertoire,
par exemple avec l'utilisation de <code class="directive"><a href="#sslverifyclient">SSLVerifyClient</a></code> dans un bloc Directory ou
Location, mod_ssl doit mettre en tampon en mmoire tout corps de requte
HTTP en attendant qu'une nouvelle initialisation de connexion SSL puisse
tre effectue. Cette directive permet de dfinir la quantit de mmoire
 allouer pour ce tampon.</p>

<div class="warning"><p>
Notez que dans de nombreuses configurations, le client qui envoie un
corps de requte n'est pas forcment digne de confiance, et l'on doit
par consquent prendre en considration la possibilit d'une attaque de
type dni de service lorsqu'on modifie la valeur de cette directive.
</p></div>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLRenegBufferSize 262144</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslrequire" id="sslrequire">Directive</a> <a name="SSLRequire" id="SSLRequire">SSLRequire</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>N'autorise l'accs que lorsqu'une expression boolenne
complexe et arbitraire est vraie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLRequire <em>expression</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<div class="note"><h3>SSLRequire est obsolte</h3>
<p><code>SSLRequire</code> est obsolte et doit en gnral tre
remplace par l'expression <a href="mod_authz_core.html#reqexpr">Require</a>. La syntaxe <a href="../expr.html">ap_expr</a> de l'expression <code>Require</code> est
une extension de la syntaxe de <code>SSLRequire</code>, avec les
diffrences suivantes :</p>

<p>Avec <code>SSLRequire</code>, les oprateurs de comparaison
<code>&lt;</code>, <code>&lt;=</code>, ... sont strictement quivalents
aux oprateurs <code>lt</code>, <code>le</code>, ... , et fonctionnent
selon une mthode qui compare tout d'abord la longueur des deux chanes,
puis l'ordre alphabtique. Les expressions <a href="../expr.html">ap_expr</a>, quant  elles, possdent deux jeux
d'oprateurs de comparaison : les oprateurs <code>&lt;</code>,
<code>&lt;=</code>, ... effectuent une comparaison alphabtique de
chanes, alors que les oprateurs <code>-lt</code>, <code>-le</code>,
... effectuent une comparaison d'entiers. Ces derniers possdent aussi
des alias sans tiret initial : <code>lt</code>, <code>le</code>, ...
</p>

</div>

<p>Cette directive permet de spcifier une condition gnrale d'accs
qui doit tre entirement satisfaite pour que l'accs soit autoris.
C'est une directive trs puissante, car la condition d'accs spcifie
est une expression boolenne complexe et arbitraire contenant un nombre
quelconque de vrifications quant aux autorisations d'accs.</p>
<p>
L'<em>expression</em> doit respecter la syntaxe suivante (fournie ici
sous la forme d'une notation dans le style de la grammaire BNF) :</p>
<blockquote>
<pre>expr     ::= "<strong>true</strong>" | "<strong>false</strong>"
           | "<strong>!</strong>" expr
           | expr "<strong>&amp;&amp;</strong>" expr
           | expr "<strong>||</strong>" expr
           | "<strong>(</strong>" expr "<strong>)</strong>"
           | comp

comp     ::= word "<strong>==</strong>" word | word "<strong>eq</strong>" word
           | word "<strong>!=</strong>" word | word "<strong>ne</strong>" word
           | word "<strong>&lt;</strong>"  word | word "<strong>lt</strong>" word
           | word "<strong>&lt;=</strong>" word | word "<strong>le</strong>" word
           | word "<strong>&gt;</strong>"  word | word "<strong>gt</strong>" word
           | word "<strong>&gt;=</strong>" word | word "<strong>ge</strong>" word
           | word "<strong>in</strong>" "<strong>{</strong>" wordlist "<strong>}</strong>"
           | word "<strong>in</strong>" "<strong>PeerExtList(</strong>" word "<strong>)</strong>"
           | word "<strong>=~</strong>" regex
           | word "<strong>!~</strong>" regex

wordlist ::= word
           | wordlist "<strong>,</strong>" word

word     ::= digit
           | cstring
           | variable
           | function

digit    ::= [0-9]+
cstring  ::= "..."
variable ::= "<strong>%{</strong>" varname "<strong>}</strong>"
function ::= funcname "<strong>(</strong>" funcargs "<strong>)</strong>"</pre>
</blockquote>
<p>Pour <code>varname</code>, toute variable dcrite dans <a href="#envvars">Variables d'environnement</a> pourra tre utilise.
Pour <code>funcname</code>, vous trouverez la liste des fonctions
disponibles dans la <a href="../expr.html#functions">documentation
ap_expr</a>.</p>

<p><em>expression</em> est interprte et traduite
sous une forme machine interne lors du chargement de la configuration,
puis value lors du traitement de la requte. Dans le contexte des
fichiers .htaccess, <em>expression</em> est interprte et excute
chaque fois que le fichier .htaccess intervient lors du traitement de la
requte.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLRequire (    %{SSL_CIPHER} !~ m/^(EXP|NULL)-/                   \
            and %{SSL_CLIENT_S_DN_O} eq "Snake Oil, Ltd."          \
            and %{SSL_CLIENT_S_DN_OU} in {"Staff", "CA", "Dev"}    \
            and %{TIME_WDAY} -ge 1 and %{TIME_WDAY} -le 5          \
            and %{TIME_HOUR} -ge 8 and %{TIME_HOUR} -le 20       ) \
           or %{REMOTE_ADDR} =~ m/^192\.76\.162\.[0-9]+$/</pre>
</div>


<p>La fonction <code>PeerExtList(<em>identifiant objet</em>)</code>
recherche une instance d'extension de certificat X.509 identifie par
<em>identifiant objet</em> (OID) dans le certificat client. L'expression est
value  true si la partie gauche de la chane correspond exactement 
la valeur d'une extension identifie par cet OID (Si plusieurs
extensions possdent le mme OID, l'une d'entre elles au moins doit
correspondre).
</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLRequire "foobar" in PeerExtList("1.2.3.4.5.6")</pre>
</div>

<div class="note"><h3>Notes  propos de la fonction PeerExtList</h3>

<ul>

<li><p>L'identifiant objet peut tre spcifi soit comme un nom
descriptif reconnu par la bibliothque SSL, tel que
<code>"nsComment"</code>, soit comme un OID numrique tel que
<code>"1.2.3.4.5.6"</code>.</p></li>

<li><p>Les expressions contenant des types connus de la bibliothque
SSL sont transformes en chanes avant comparaison. Pour les extensions
contenant un type non connu de la bibliothque SSL, mod_ssl va essayer
d'interprter la valeur s'il s'agit d'un des types ASN.1 primaires UTF8String,
IA5String, VisibleString, ou BMPString. Si l'extension correspond  un
de ces types, la chane sera convertie en UTF-8 si ncessaire, puis
compare avec la partie gauche de l'expression.</p></li>

</ul>
</div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../env.html">Les variables d'environnement dans le
serveur HTTP Apache</a>, pour d'autres exemples.
</li>
<li><a href="mod_authz_core.html#reqexpr">Require expr</a></li>
<li><a href="../expr.html">Syntaxe gnrale des expressions dans le
serveur HTTP Apache</a>
</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslrequiressl" id="sslrequiressl">Directive</a> <a name="SSLRequireSSL" id="SSLRequireSSL">SSLRequireSSL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interdit l'accs lorsque la requte HTTP n'utilise pas
SSL</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLRequireSSL</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive interdit l'accs si HTTP sur SSL (c'est  dire HTTPS)
n'est pas activ pour la connexion courante. Ceci est trs pratique dans
un serveur virtuel o SSL est activ ou dans un rpertoire pour se
protger des erreurs de configuration qui pourraient donner accs  des
ressources protges. Lorsque cette directive est prsente, toutes les
requtes qui n'utilisent pas SSL sont rejetes.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLRequireSSL</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslsessioncache" id="sslsessioncache">Directive</a> <a name="SSLSessionCache" id="SSLSessionCache">SSLSessionCache</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Type du cache de session SSL global et
inter-processus</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLSessionCache <em>type</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLSessionCache none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de configurer le type de stockage du cache de
session SSL global et inter-processus. Ce cache est une fonctionnalit
optionnelle qui acclre le traitement parallle des requtes. Pour ce
qui est des requtes vers un mme processus du serveur (via HTTP
keep-alive), OpenSSL met en cache les informations de session SSL en
interne. Mais comme les clients modernes demandent des images en ligne
et d'autres donnes via des requtes parallles (un nombre de quatre
requtes parallles est courant), ces requtes vont tre servies par
<em>plusieurs</em> processus du serveur pr-dclenchs. Ici, un cache
inter-processus permet d'viter des ngociations de session
inutiles.</p>
<p>
Les quatre <em>type</em>s de stockage suivants sont actuellement
supports :</p>
<ul>
<li><code>none</code>

    <p>Cette valeur dsactive le cache de session global et
    inter-processus, ce qui va ralentir le serveur de manire sensible
    et peut poser problme avec certains navigateurs, en particulier si
    les certificats clients sont activs. Cette configuration n'est pas
    recommande.</p></li>

<li><code>nonenotnull</code>

    <p>Cette valeur dsactive tout cache de session global et
    inter-processus. Cependant, elle force OpenSSL  envoyer un
    identifiant de session non nul afin de s'adapter aux clients bogus
    qui en ncessitent un.</p></li>

<li><code>dbm:/chemin/vers/fichier-donnes</code>

    <p>Cette valeur utilise un fichier de hashage DBM sur disque local
    pour synchroniser les caches OpenSSL locaux en mmoire des processus
    du serveur. Ce cache de session peut tre sujet  des problmes de
    fiabilit sous forte charge. Pour l'utiliser, le module
    <code class="module"><a href="../mod/mod_socache_dbm.html">mod_socache_dbm</a></code> doit tre charg.</p></li>

<li><code>shmcb:/chemin/vers/fichier-donnes</code>[<code>(</code><em>nombre</em><code>)</code>]

    <p>Cette valeur utilise un tampon cyclique  hautes performances
    (d'une taille d'environ <em>nombre</em> octets) dans un segment de
    mmoire partage en RAM (tabli via
    <code>/chemin/vers/fichier-donnes</code>, pour synchroniser les
    caches OpenSSL locaux en mmoire des processus du serveur. C'est le
    type de cache de session recommand. Pour l'utiliser, le module
    <code class="module"><a href="../mod/mod_socache_shmcb.html">mod_socache_shmcb</a></code> doit tre charg.</p></li>

<li><code>dc:UNIX:/chemin/vers/socket</code>

    <p>Cette valeur utilise les bibliothques de mise en cache de
    sessions distribue sur <a href="http://distcache.sourceforge.net/">distcache</a>.
    L'argument doit spcifier le serveur ou mandataire  utiliser en
    utilisant la syntaxe d'adressage distcache ; par exemple,
    <code>UNIX:/chemin/vers/socket</code> spcifie une socket de domaine
    Unix (en gnral un mandataire de dc_client local) ;
    <code>IP:serveur.example.com:9001</code> spcifie une adresse IP.
    Pour l'utiliser, le module <code class="module"><a href="../mod/mod_socache_dc.html">mod_socache_dc</a></code> doit tre
    charg.</p></li>

</ul>

<div class="example"><h3>Exemples</h3><pre class="prettyprint lang-config">SSLSessionCache "dbm:/usr/local/apache/logs/ssl_gcache_data"
SSLSessionCache "shmcb:/usr/local/apache/logs/ssl_gcache_data(512000)"</pre>
</div>

<p>Le mutex <code>ssl-cache</code> permet de srialiser l'accs au cache
de session afin d'viter toute corruption. Ce mutex peut tre configur
via la directive <code class="directive"><a href="../mod/core.html#mutex">Mutex</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslsessioncachetimeout" id="sslsessioncachetimeout">Directive</a> <a name="SSLSessionCacheTimeout" id="SSLSessionCacheTimeout">SSLSessionCacheTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de secondes avant l'expiration d'une session SSL
dans le cache de sessions</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLSessionCacheTimeout <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLSessionCacheTimeout 300</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>S'applique aussi  la reprise de session TLS (RFC 5077) 
partir de la version 2.4.10 du serveur HTTP Apache</td></tr>
</table>
<p>
Cette directive permet de dfinir la dure de vie en secondes des
informations stockes dans le cache de sessions SSL global et
inter-processus, dans le cache OpenSSL interne en mmoire et pour
les sessions rinitialises par la reprise de session TLS (RFC 5077). elle peut
tre dfinie  une valeur d'environ 15  des fins de test, mais  une
valeur trs suprieure comme 300 en production.</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLSessionCacheTimeout 600</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslsessionticketkeyfile" id="sslsessionticketkeyfile">Directive</a> <a name="SSLSessionTicketKeyFile" id="SSLSessionTicketKeyFile">SSLSessionTicketKeyFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Cl de chiffrement/dchiffrement permanente pour les
tickets de session TLS</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLSessionTicketKeyFile <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.4.0 du serveur HTTP
Apache, sous rserve que l'on utilise une version 0.9.8h ou suprieure
d'OpenSSL</td></tr>
</table>
<p>Cette directive permet de dfinir une cl secrte pour le chiffrement
et le dchiffrement des tickets de session TLS selon les prconisations
de la <a href="http://www.ietf.org/rfc/rfc5077.txt">RFC 5077</a>. Elle a
t conue  l'origine pour les environnements de clusters o les
donnes des sessions TLS doivent tre partages entre plusieurs noeuds.
Pour les configurations ne comportant qu'une seule instance de httpd, il
est prfrable d'utiliser les cls (alatoires) gnres par mod_ssl au
dmarrage du serveur.</p>
<p>Le fichier doit contenir 48 octets de donnes alatoires cres de
prfrence par une source  haute entropie. Sur un systme de type UNIX,
il est possible de crer le fichier contenant la cl de la manire
suivante :</p>

<div class="example"><p><code>
dd if=/dev/random of=/chemin/vers/fichier.tkey bs=1 count=48
</code></p></div>

<p>Ces cls doivent tre renouveles frquemment, car il s'agit du seul
moyen d'invalider un ticket de session existant - OpenSSL ne permet pas
actuellement de spcifier une limite  la dure de
vie des tickets. Une nouvelle cl ne peut tre utilise qu'aprs avoir
redmarr le serveur. Tous les tickets de session existants deviennent
invalides aprs le redmarrage du serveur.</p>

<div class="warning">
<p>Ce fichier contient des donnes sensibles et doit donc tre protg
par des permissions similaires  celles du fichier spcifi par la
directive <code class="directive"><a href="#sslcertificatekeyfile">SSLCertificateKeyFile</a></code>.</p>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslsessiontickets" id="sslsessiontickets">Directive</a> <a name="SSLSessionTickets" id="SSLSessionTickets">SSLSessionTickets</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active ou dsactive les tickets de session TLS</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLSessionTickets on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLSessionTickets on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.11 du serveur HTTP
Apache, sous rserve d'utiliser OpenSSL version 0.9.8f ou suprieure.
</td></tr>
</table>
<p>Cette directive permet d'activer ou de dsactiver l'utilisation des
tickets de session TLS (RFC 5077).</p>
<div class="warning">
<p>Les tickets de session TLS sont activs par dfaut. Les utiliser sans
redmarrer le serveur selon une priodicit approprie (par exemple
quotidiennement) compromet cependant le niveau de confidentialit.</p>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslsrpunknownuserseed" id="sslsrpunknownuserseed">Directive</a> <a name="SSLSRPUnknownUserSeed" id="SSLSRPUnknownUserSeed">SSLSRPUnknownUserSeed</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Source d'ala pour utilisateur SRP inconnu</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLSRPUnknownUserSeed <em>secret-string</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.4.4 du serveur HTTP
Apache, si la version 1.0.1 ou suprieure d'OpenSSL est utilise.</td></tr>
</table>
<p>
Cette directive permet de dfinir la source d'ala  utiliser
pour les utilisateurs SRP inconnus, ceci afin de combler les manques en
cas d'existence d'un tel utilisateur. Elle dfinit une chane secrte. Si
cette directive n'est pas dfinie, Apache renverra une alerte
UNKNOWN_PSK_IDENTITY aux clients qui fournissent un nom d'utilisateur
inconnu.
</p>
<div class="example"><h3>Exemple</h3><p><code>
SSLSRPUnknownUserSeed "secret"
</code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslsrpverifierfile" id="sslsrpverifierfile">Directive</a> <a name="SSLSRPVerifierFile" id="SSLSRPVerifierFile">SSLSRPVerifierFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Chemin du fichier de vrification SRP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLSRPVerifierFile <em>file-path</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.4.4 du serveur HTTP
Apache, si la version 1.0.1 ou suprieure d'OpenSSL est utilise.</td></tr>
</table>
<p>
Cette directive permet d'activer TLS-SRP et de dfinir le chemin du
fichier de vrification OpenSSL SRP (Mot de passe distant scuris)
contenant les noms d'utilisateurs TLS-SRP, les vrificateurs, les
"grains de sel" (salts), ainsi que les paramtres de groupe.</p>
<div class="example"><h3>Exemple</h3><p><code>
SSLSRPVerifierFile "/path/to/file.srpv"
</code></p></div>
<p>
Le fichier de vrification peut tre cr via l'utilitaire en ligne de
commande <code>openssl</code> :</p>
<div class="example"><h3>Cration du fichier de vrification SRP</h3><p><code>
openssl srp -srpvfile passwd.srpv -userinfo "some info" -add username
</code></p></div>
<p>La valeur affecte au paramtre optionnel <code>-userinfo</code> est
enregistre dans la variable d'environnement
<code>SSL_SRP_USERINFO</code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingcache" id="sslstaplingcache">Directive</a> <a name="SSLStaplingCache" id="SSLStaplingCache">SSLStaplingCache</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configuration du cache pour l'agrafage OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingCache <em>type</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Si <code class="directive"><a href="#sslusestapling">SSLUseStapling</a></code> est  "on",
cette directive permet de configurer le cache destin  stocker les
rponses OCSP incluses dans la ngociation TLS. La configuration d'un
cache est obligatoire pour pouvoir utiliser l'agrafage OCSP. A
l'exception de <code>none</code> et <code>nonenotnull</code>, cette
directive supporte les mmes types de stockage que la directive
<code class="directive"><a href="#sslsessioncache">SSLSessionCache</a></code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingerrorcachetimeout" id="sslstaplingerrorcachetimeout">Directive</a> <a name="SSLStaplingErrorCacheTimeout" id="SSLStaplingErrorCacheTimeout">SSLStaplingErrorCacheTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure de vie des rponses invalides dans le cache pour
agrafage OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingErrorCacheTimeout <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingErrorCacheTimeout 600</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet de dfinir la dure de vie des rponses
<em>invalides</em> dans le cache pour agrafage OCSP configur via la
directive <code class="directive"><a href="#sslstaplingcache">SSLStaplingCache</a></code>. Pour
dfinir la dure de vie des rponses valides, voir la directive
<code class="directive"><a href="#sslstaplingstandardcachetimeout">SSLStaplingStandardCacheTimeout</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingfaketrylater" id="sslstaplingfaketrylater">Directive</a> <a name="SSLStaplingFakeTryLater" id="SSLStaplingFakeTryLater">SSLStaplingFakeTryLater</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Gnre une rponse "tryLater" pour les requtes OCSP choues</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingFakeTryLater on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingFakeTryLater on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Lorsque cette directive est active, et si une requte vers un
serveur OCSP  des fins d'inclusion dans une ngociation TLS choue,
mod_ssl va gnrer une rponse "tryLater" pour le client (<code class="directive"><a href="#sslstaplingreturnrespondererrors">SSLStaplingReturnResponderErrors</a></code> doit tre
active).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingforceurl" id="sslstaplingforceurl">Directive</a> <a name="SSLStaplingForceURL" id="SSLStaplingForceURL">SSLStaplingForceURL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Remplace l'URI du serveur OCSP spcifi dans l'extension
AIA du certificat</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingForceURL <em>uri</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet de remplacer l'URI du serveur OCSP extraite de
l'extension authorityInfoAccess (AIA) du certificat. Elle peut s'avrer
utile lorsqu'on passe par un mandataire</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingrespondertimeout" id="sslstaplingrespondertimeout">Directive</a> <a name="SSLStaplingResponderTimeout" id="SSLStaplingResponderTimeout">SSLStaplingResponderTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Temps d'attente maximum pour les requtes vers les serveurs
OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingResponderTimeout <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingResponderTimeout 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet de dfinir le temps d'attente maximum lorsque
mod_ssl envoie une requte vers un serveur OCSP afin d'obtenir une
rponse destine  tre incluse dans les ngociations TLS avec les
clients (<code class="directive"><a href="#sslusestapling">SSLUseStapling</a></code> doit
avoir t active au pralable).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingresponsemaxage" id="sslstaplingresponsemaxage">Directive</a> <a name="SSLStaplingResponseMaxAge" id="SSLStaplingResponseMaxAge">SSLStaplingResponseMaxAge</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Age maximum autoris des rponses OCSP incluses dans la
ngociation TLS</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingResponseMaxAge <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingResponseMaxAge -1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet de dfinir l'ge maximum autoris
("fracheur") des rponses OCSP incluses dans la ngociation TLS
(<code class="directive"><a href="#sslusestapling">SSLUseStapling</a></code> doit
avoir t active au pralable). La valeur par dfaut (<code>-1</code>)
ne dfinit aucun ge maximum, ce qui signifie que les rponses OCSP sont
considres comme valides  partir du moment o le contenu de leur champ
<code>nextUpdate</code> se trouve dans le futur.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingresponsetimeskew" id="sslstaplingresponsetimeskew">Directive</a> <a name="SSLStaplingResponseTimeSkew" id="SSLStaplingResponseTimeSkew">SSLStaplingResponseTimeSkew</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure de vie maximale autorise des rponses OCSP incluses dans la
ngociation TLS</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingResponseTimeSkew <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingResponseTimeSkew 300</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet de spcifier l'intervalle de temps maximum que
mod_ssl va calculer en faisant la diffrence entre les contenus des
champs <code>nextUpdate</code> et <code>thisUpdate</code> des rponses
OCSP incluses dans la ngociation TLS. Pour pouvoir utiliser cette
directive, <code class="directive"><a href="#sslusestapling">SSLUseStapling</a></code> doit
tre  "on".</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingreturnrespondererrors" id="sslstaplingreturnrespondererrors">Directive</a> <a name="SSLStaplingReturnResponderErrors" id="SSLStaplingReturnResponderErrors">SSLStaplingReturnResponderErrors</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Transmet au client les erreurs survenues lors des requtes
OCSP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingReturnResponderErrors on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingReturnResponderErrors on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Lorsque cette directive est active, mod_ssl va transmettre au client les
rponses concernant les requtes OCSP
choues (comme les rponses avec un statut gnral autre que
"successful", les rponses avec un statut de certificat autre que
"good", les rponses arrives  expiration, etc...). 
Lorsqu'elle est  <code>off</code>, seules les rponses avec un
statut de certificat gal  "good" seront incluses dans la ngociation
TLS.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstaplingstandardcachetimeout" id="sslstaplingstandardcachetimeout">Directive</a> <a name="SSLStaplingStandardCacheTimeout" id="SSLStaplingStandardCacheTimeout">SSLStaplingStandardCacheTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure de vie des rponses OCSP dans le cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStaplingStandardCacheTimeout <em>secondes</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStaplingStandardCacheTimeout 3600</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet de dfinir la dure de vie des rponses OCSP
dans le cache configur via la directive <code class="directive"><a href="#sslstaplingcache">SSLStaplingCache</a></code>. Elle ne s'applique qu'aux
rponse <em>valides</em>, alors que la directive <code class="directive"><a href="#sslstaplingerrorcachetimeout">SSLStaplingErrorCacheTimeout</a></code> s'applique aux
rponses invalides ou non disponibles.
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslstrictsnivhostcheck" id="sslstrictsnivhostcheck">Directive</a> <a name="SSLStrictSNIVHostCheck" id="SSLStrictSNIVHostCheck">SSLStrictSNIVHostCheck</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle de l'accs des clients non-SNI  un serveur virtuel 
base de nom.
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLStrictSNIVHostCheck on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLStrictSNIVHostCheck off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.12 d'Apache</td></tr>
</table>
<p>
Cette directive permet de contrler l'accs des clients non-SNI  un serveur
virtuel  base de nom. Si elle est dfinie  <code>on</code> dans le
serveur virtuel  base de nom par dfaut, les
clients non-SNI ne seront autoriss  accder  aucun serveur virtuel
appartenant  cette combinaison IP/port. Par
contre, si elle est dfinie  <code>on</code> dans un serveur virtuel
quelconque, les clients non-SNI ne se verront interdire l'accs qu' ce
serveur.
</p>

<div class="warning"><p>
Cette option n'est disponible que si httpd a t compil avec une
version d'OpenSSL supportant SNI.
</p></div>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLStrictSNIVHostCheck on</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslusername" id="sslusername">Directive</a> <a name="SSLUserName" id="SSLUserName">SSLUserName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom de la variable servant  dterminer le nom de
l'utilisateur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLUserName <em>nom-var</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette variable permet de dfinir le champ "user" de l'objet de la
requte Apache. Ce champ est utilis par des modules de plus bas niveau
pour identifier l'utilisateur avec une chane de caractres. En
particulier, l'utilisation de cette directive peut provoquer la
dfinition de la variable d'environnement <code>REMOTE_USER</code>.
La valeur de l'argument <em>nom-var</em> peut correspondre  toute <a href="#envvars">variable d'environnement SSL</a>.</p>

<p>Notez que cette directive est sans effet si l'option
<code>FakeBasicAuth</code> est utilise (voir <a href="#ssloptions">SSLOptions</a>).</p>

<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLUserName SSL_CLIENT_S_DN_CN</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslusestapling" id="sslusestapling">Directive</a> <a name="SSLUseStapling" id="SSLUseStapling">SSLUseStapling</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active l'ajout des rponses OCSP  la ngociation TLS</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLUseStapling on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLUseStapling off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible si on utilise OpenSSL version 0.9.8h ou suprieure</td></tr>
</table>
<p>Cette directive permet d'activer l'"Agrafage OCSP" (OCSP stapling)
selon la dfinition de l'extension TLS "Certificate Status Request"
fournie dans la RFC 6066. Si elle est active et si le client le
demande, mod_ssl va inclure une rponse OCSP  propos de son propre
certificat dans la ngociation TLS. Pour pouvoir activer l'Agrafage
OCSP, il est ncessaire de configurer un <code class="directive"><a href="#sslstaplingcache">SSLStaplingCache</a></code>.</p>

<p>L'agrafage OCSP dispense le client de requrir le serveur OCSP
directement ; il faut cependant noter que selon les spcifications de la
RFC 6066, la rponse <code>CertificateStatus</code> du serveur ne peut
inclure une rponse OCSP que pour un seul certificat. Pour les
certificats de serveur comportant des certificats de CA intermdiaires
dans leur chane (c'est un cas typique de nos jours), l'implmentation
actuelle de l'agrafage OCSP n'atteint que partiellement l'objectif d'
"conomie en questions/rponse et en ressources". Pour plus de dtails,
voir la <a href="http://www.ietf.org/rfc/rfc6961.txt">RFC 6961</a> (TLS
Multiple Certificate Status Extension).
</p>

<p>Lorsque l'agrafage OCSP est activ, le mutex
<code>ssl-stapling</code> contrle l'accs au cache de l'agrafage OCSP
afin de prvenir toute corruption, et le mutex
<code>sss-stapling-refresh</code> contrle le raffrachissement des
rponses OCSP. Ces mutex peuvent tre configurs via la directive
<code class="directive"><a href="../mod/core.html#mutex">Mutex</a></code>.
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslverifyclient" id="sslverifyclient">Directive</a> <a name="SSLVerifyClient" id="SSLVerifyClient">SSLVerifyClient</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Niveau de vrification du certificat client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLVerifyClient <em>niveau</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLVerifyClient none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de dfinir le niveau de vrification du
certificat pour l'authentification du client. Notez que cette directive
peut tre utilise  la fois dans les contextes du serveur principal et
du rpertoire. Dans le contexte du serveur principal, elle s'applique au
processus d'authentification du client utilis au cours de la
ngociation SSL standard lors de l'tablissement d'une connexion. Dans
un contexte de rpertoire, elle force une rengociation SSL avec le
niveau de vrification du client spcifi, aprs la lecture d'une
requte HTTP, mais avant l'envoi de la rponse HTTP.</p>
<p>
Les valeurs de <em>niveau</em> disponibles sont les suivantes :</p>
<ul>
<li><strong>none</strong>:
     aucun certificat client n'est requis</li>
<li><strong>optional</strong>:
     le client <em>peut</em> prsenter un certificat valide</li>
<li><strong>require</strong>:
     le client <em>doit</em> prsenter un certificat valide</li>
<li><strong>optional_no_ca</strong>:
     le client peut prsenter un certificat valide, mais il n'est pas
     ncessaire que ce dernier soit vrifiable (avec succs). Cette option ne
     peut pas tre utilise lors de l'authentification du client.</li>
</ul>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLVerifyClient require</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sslverifydepth" id="sslverifydepth">Directive</a> <a name="SSLVerifyDepth" id="SSLVerifyDepth">SSLVerifyDepth</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Profondeur maximale des certificats de CA pour la
vrification des certificats clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SSLVerifyDepth <em>nombre</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SSLVerifyDepth 1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ssl</td></tr>
</table>
<p>
Cette directive permet de spcifier la profondeur maximale  laquelle
mod_ssl va effectuer sa vrification avant de dcider que le client ne
possde pas de certificat valide. Notez que cette directive peut tre
utilise  la fois dans les contextes du serveur principal et de
rpertoire. Dans le contexte du serveur principal, elle s'applique au
processus d'authentification du client utilis au cours de la
ngociation SSL standard lors de l'tablissement d'une connexion. Dans
un contexte de rpertoire, elle force une rengociation SSL avec le
client selon la nouvelle profondeur spcifie, aprs la lecture d'une
requte HTTP, mais avant l'envoi de la rponse HTTP.</p>
<p>
La profondeur correspond au nombre maximum de fournisseurs de
certificats intermdiaires, c'est  dire le nombre maximum de
certificats de CA que l'on est autoris  suivre lors de la vrification
du certificat du client. Une profondeur de 0 signifie que seuls les
certificats clients auto-signs sont accepts ; la profondeur par dfaut
de 1 signifie que le certificat client peut tre soit auto-sign, soit
sign par une CA connue directement du serveur (c'est  dire que le
certificat de la CA doit tre rfrenc par la directive <code class="directive"><a href="#sslcacertificatepath">SSLCACertificatePath</a></code>), etc...</p>
<div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">SSLVerifyDepth 10</pre>
</div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_ssl.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_ssl.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_ssl.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>