/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.packagemanager;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.packagemanager.PackageRepository;
import org.apache.solr.packagemanager.PackageUtils;
import org.apache.solr.packagemanager.SolrPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageRepository
extends PackageRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @JsonIgnore
    private Map<String, SolrPackage> packages;

    public DefaultPackageRepository() {
    }

    public DefaultPackageRepository(String repositoryName, String repositoryURL) {
        this.name = repositoryName;
        this.repositoryURL = repositoryURL;
    }

    @Override
    public void refresh() {
        this.packages = null;
    }

    @Override
    public Map<String, SolrPackage> getPackages() {
        if (this.packages == null) {
            this.initPackages();
        }
        return this.packages;
    }

    @Override
    public SolrPackage getPackage(String packageName) {
        return this.getPackages().get(packageName);
    }

    @Override
    public boolean hasPackage(String packageName) {
        return this.getPackages().containsKey(packageName);
    }

    @Override
    public Path download(String artifactName) throws SolrException, IOException {
        Path tmpDirectory = Files.createTempDirectory("solr-packages", new FileAttribute[0]);
        tmpDirectory.toFile().deleteOnExit();
        URL url = new URL(new URL(this.repositoryURL.endsWith("/") ? this.repositoryURL : this.repositoryURL + "/"), artifactName);
        String fileName = FilenameUtils.getName((String)url.getPath());
        Path destination = tmpDirectory.resolve(fileName);
        switch (url.getProtocol()) {
            case "http": 
            case "https": 
            case "ftp": {
                FileUtils.copyURLToFile((URL)url, (File)destination.toFile());
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URL protocol " + url.getProtocol() + " not supported");
            }
        }
        return destination;
    }

    private void initPackages() {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            SolrPackage[] items = PackageUtils.getJson((HttpClient)client, this.repositoryURL + "/repository.json", SolrPackage[].class);
            this.packages = new HashMap<String, SolrPackage>(items.length);
            for (SolrPackage pkg : items) {
                pkg.setRepository(this.name);
                this.packages.put(pkg.name, pkg);
            }
        }
        catch (IOException ex) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug("Found {} packages in repository '{}'", (Object)this.packages.size(), (Object)this.name);
        }
    }
}

