/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import org.apache.solr.request.SolrQueryRequest;

public abstract class UpdateCommand
implements Cloneable {
    protected SolrQueryRequest req;
    protected long version;
    protected String route;
    protected int flags;
    public static int BUFFERING = 1;
    public static int REPLAY = 2;
    public static int PEER_SYNC = 4;
    public static int IGNORE_AUTOCOMMIT = 8;
    public static int CLEAR_CACHES = 16;
    public static int IGNORE_INDEXWRITER = 32;

    public UpdateCommand(SolrQueryRequest req) {
        this.req = req;
    }

    public abstract String name();

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.name());
        sb.append('{');
        boolean needComma = false;
        if (this.flags != 0) {
            sb.append("flags=").append(Integer.toHexString(this.flags));
            needComma = true;
        }
        if (this.version != 0L) {
            if (needComma) {
                sb.append(',');
            }
            sb.append("_version_=").append(this.version);
        }
        return sb.toString();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public void setReq(SolrQueryRequest req) {
        this.req = req;
    }

    public UpdateCommand clone() {
        try {
            return (UpdateCommand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

