/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.util.ExternalPaths;
import org.junit.After;
import org.junit.AfterClass;

public abstract class EmbeddedSolrServerTestBase
extends SolrTestCaseJ4 {
    protected static final String DEFAULT_CORE_NAME = "collection1";
    public static EmbeddedSolrServer client = null;

    @After
    public synchronized void afterClass() throws Exception {
        if (client != null) {
            client.close();
        }
        client = null;
    }

    @AfterClass
    public static void afterEmbeddedSolrServerTestBase() throws Exception {
    }

    public synchronized EmbeddedSolrServer getSolrClient() {
        if (client == null) {
            client = this.createNewSolrClient();
        }
        return client;
    }

    public EmbeddedSolrServer createNewSolrClient() {
        return new EmbeddedSolrServer(h.getCoreContainer(), DEFAULT_CORE_NAME){

            public void close() {
            }
        };
    }

    public void upload(String collection, ContentStream ... contents) {
        Path base = Paths.get(this.getSolrClient().getCoreContainer().getSolrHome(), collection);
        this.writeTo(base, contents);
    }

    private void writeTo(Path base, ContentStream ... contents) {
        try {
            if (!Files.exists(base, new LinkOption[0])) {
                Files.createDirectories(base, new FileAttribute[0]);
            }
            for (ContentStream content : contents) {
                File file = new File(base.toFile(), content.getName());
                file.getParentFile().mkdirs();
                try (FileOutputStream os = new FileOutputStream(file);){
                    ByteStreams.copy((InputStream)content.getStream(), (OutputStream)os);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ContentStream> download(String collection, String ... names) {
        Path base = Paths.get(this.getSolrClient().getCoreContainer().getSolrHome(), collection);
        ArrayList<ContentStream> result = new ArrayList<ContentStream>();
        if (Files.exists(base, new LinkOption[0])) {
            for (String name : names) {
                File file = new File(base.toFile(), name);
                if (!file.exists() || !file.canRead()) continue;
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ByteStreams.copy((InputStream)new FileInputStream(file), (OutputStream)os);
                    ContentStreamBase.ByteArrayStream stream = new ContentStreamBase.ByteArrayStream(os.toByteArray(), name);
                    result.add((ContentStream)stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public static void initCore() throws Exception {
        String home = EmbeddedSolrServerTestBase.legacyExampleCollection1SolrHome();
        String config = home + "/" + DEFAULT_CORE_NAME + "/conf/solrconfig.xml";
        String schema = home + "/" + DEFAULT_CORE_NAME + "/conf/schema.xml";
        EmbeddedSolrServerTestBase.initCore(config, schema, home);
    }

    public static String legacyExampleCollection1SolrHome() throws IOException {
        String sourceHome = ExternalPaths.SOURCE_HOME;
        if (sourceHome == null) {
            throw new IllegalStateException("No source home! Cannot create the legacy example solr home directory.");
        }
        File tempSolrHome = LuceneTestCase.createTempDir().toFile();
        FileUtils.copyFileToDirectory((File)new File(sourceHome, "server/solr/solr.xml"), (File)tempSolrHome);
        File collectionDir = new File(tempSolrHome, DEFAULT_CORE_NAME);
        FileUtils.forceMkdir((File)collectionDir);
        File configSetDir = new File(sourceHome, "server/solr/configsets/sample_techproducts_configs/conf");
        FileUtils.copyDirectoryToDirectory((File)configSetDir, (File)collectionDir);
        Properties props = new Properties();
        props.setProperty("name", DEFAULT_CORE_NAME);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)new File(collectionDir, "core.properties")), "UTF-8");){
            props.store(writer, null);
        }
        return tempSolrHome.getAbsolutePath();
    }
}

