/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SortedNumericDVAcc;

abstract class DoubleSortedNumericDVAcc
extends SortedNumericDVAcc {
    double[] result;
    double initialValue;

    public DoubleSortedNumericDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, double initialValue) throws IOException {
        super(fcontext, sf, numSlots);
        this.result = new double[numSlots];
        this.initialValue = initialValue;
        if (initialValue != 0.0) {
            Arrays.fill(this.result, initialValue);
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slotNum) throws IOException {
        return this.result[slotNum];
    }

    @Override
    public void reset() throws IOException {
        Arrays.fill(this.result, this.initialValue);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        resizer.resize(this.result, this.initialValue);
    }

    protected double getDouble(long val) {
        switch (this.sf.getType().getNumberType()) {
            case INTEGER: 
            case LONG: 
            case DATE: {
                return val;
            }
            case FLOAT: {
                return NumericUtils.sortableIntToFloat((int)((int)val));
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)val);
            }
        }
        return 0.0;
    }
}

