/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.DoubleRange;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persist;

@Root(name="double-range")
class DoubleRangeConstraint
extends Constraint {
    Double min;
    Double max;
    @Attribute(name="min", required=false)
    Double minOrNull;
    @Attribute(name="max", required=false)
    Double maxOrNull;

    DoubleRangeConstraint() {
    }

    @Override
    protected boolean isMet(Object value) {
        if (value == null) {
            return false;
        }
        this.checkAssignableFrom(value, Number.class);
        double v = ((Number)value).doubleValue();
        return v >= this.min && v <= this.max;
    }

    public String toString() {
        return "range(min = " + this.min.toString() + ", max = " + this.max.toString() + ")";
    }

    @Override
    public void populateCustom(Annotation annotation) {
        DoubleRange range = (DoubleRange)annotation;
        this.min = range.min();
        this.max = range.max();
    }

    @Persist
    void beforeSerialization() {
        if (this.min > Double.NEGATIVE_INFINITY) {
            this.minOrNull = this.min;
        }
        if (this.max < Double.POSITIVE_INFINITY) {
            this.maxOrNull = this.max;
        }
    }
}

