/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.lang.invoke.MethodHandles;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestParams;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.PackageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagePluginHolder<T>
extends PluginBag.PluginHolder<T> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String LATEST = "$LATEST";
    private final SolrCore core;
    private final SolrConfig.SolrPluginInfo pluginMeta;
    private PackageLoader.Package.Version pkgVersion;
    private PluginInfo info;

    public PackagePluginHolder(final PluginInfo info, SolrCore core, SolrConfig.SolrPluginInfo pluginMeta) {
        super(info);
        this.core = core;
        this.pluginMeta = pluginMeta;
        this.info = info;
        this.reload(core.getCoreContainer().getPackageLoader().getPackage(info.pkgName));
        core.getPackageListeners().addListener(new PackageListeners.Listener(){

            @Override
            public String packageName() {
                return info.pkgName;
            }

            @Override
            public PluginInfo pluginInfo() {
                return info;
            }

            @Override
            public void changed(PackageLoader.Package pkg) {
                PackagePluginHolder.this.reload(pkg);
            }

            @Override
            public PackageLoader.Package.Version getPackageVersion() {
                return PackagePluginHolder.this.pkgVersion;
            }
        });
    }

    private String maxVersion() {
        RequestParams.ParamSet p = this.core.getSolrConfig().getRequestParams().getParams("PKG_VERSIONS");
        if (p == null) {
            return null;
        }
        Object o = p.get().get(this.info.pkgName);
        if (o == null || LATEST.equals(o)) {
            return null;
        }
        return o.toString();
    }

    private synchronized void reload(PackageLoader.Package pkg) {
        PackageLoader.Package.Version pkgLatest;
        String lessThan = this.maxVersion();
        PackageLoader.Package.Version newest = pkg.getLatest(lessThan);
        if (newest == null) {
            log.error("No latest version available for package : {}", (Object)pkg.name());
            return;
        }
        if (lessThan != null && (pkgLatest = pkg.getLatest()) != newest) {
            log.info("Using version :{}. latest is {},  params.json has config {} : {}", new Object[]{newest.getVersion(), pkgLatest.getVersion(), pkg.name(), lessThan});
        }
        if (this.pkgVersion != null && newest == this.pkgVersion) {
            return;
        }
        log.info("loading plugin: {} -> {} using  package {}:{}", new Object[]{this.pluginInfo.type, this.pluginInfo.name, pkg.name(), newest.getVersion()});
        this.initNewInstance(newest);
        this.pkgVersion = newest;
    }

    protected void initNewInstance(PackageLoader.Package.Version newest) {
        Object instance = SolrCore.createInstance(this.pluginInfo.className, this.pluginMeta.clazz, this.pluginMeta.getCleanTag(), this.core, newest.getLoader());
        PluginBag.initInstance(instance, this.pluginInfo);
        Object old = this.inst;
        this.inst = instance;
        if (old instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)old;
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.error("error closing plugin", (Throwable)e);
            }
        }
    }
}

