/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSHDFSUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final AtomicLong RECOVER_LEASE_SUCCESS_COUNT = new AtomicLong();

    public static void recoverFileLease(FileSystem fs, Path p, Configuration conf, CallerInfo callerInfo) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        FSHDFSUtils.recoverDFSFileLease((DistributedFileSystem)fs, p, conf, callerInfo);
    }

    static boolean recoverDFSFileLease(DistributedFileSystem dfs, Path p, Configuration conf, CallerInfo callerInfo) throws IOException {
        log.info("Recovering lease on dfs file " + p);
        long startWaiting = System.nanoTime();
        long recoveryTimeout = TimeUnit.NANOSECONDS.convert(conf.getInt("solr.hdfs.lease.recovery.timeout", 900000), TimeUnit.MILLISECONDS) + startWaiting;
        long firstPause = conf.getInt("solr.hdfs.lease.recovery.first.pause", 4000);
        long subsequentPause = TimeUnit.NANOSECONDS.convert(conf.getInt("solr.hdfs.lease.recovery.dfs.timeout", 61000), TimeUnit.MILLISECONDS);
        if (dfs.isFileClosed(p)) {
            return true;
        }
        boolean recovered = false;
        int nbAttempt = 0;
        while (!(recovered || (recovered = FSHDFSUtils.recoverLease(dfs, nbAttempt, p, startWaiting)) || FSHDFSUtils.checkIfTimedout(conf, recoveryTimeout, nbAttempt, p, startWaiting) || callerInfo.isCallerClosed())) {
            block7: {
                try {
                    if (nbAttempt == 0) {
                        Thread.sleep(firstPause);
                        break block7;
                    }
                    long localStartWaiting = System.nanoTime();
                    while (System.nanoTime() - localStartWaiting < subsequentPause && !callerInfo.isCallerClosed()) {
                        Thread.sleep(conf.getInt("solr.hdfs.lease.recovery.pause", 1000));
                        if (!dfs.isFileClosed(p)) continue;
                        recovered = true;
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            ++nbAttempt;
        }
        if (recovered) {
            RECOVER_LEASE_SUCCESS_COUNT.incrementAndGet();
        }
        return recovered;
    }

    static boolean checkIfTimedout(Configuration conf, long recoveryTimeout, int nbAttempt, Path p, long startWaiting) {
        if (recoveryTimeout < System.nanoTime()) {
            log.warn("Cannot recoverLease after trying for " + conf.getInt("solr.hdfs.lease.recovery.timeout", 900000) + "ms (solr.hdfs.lease.recovery.timeout); continuing, but may be DATALOSS!!!; " + FSHDFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting));
            return true;
        }
        return false;
    }

    static boolean recoverLease(DistributedFileSystem dfs, int nbAttempt, Path p, long startWaiting) throws FileNotFoundException {
        boolean recovered = false;
        try {
            recovered = dfs.recoverLease(p);
            log.info("recoverLease=" + recovered + ", " + FSHDFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting));
        }
        catch (IOException e) {
            if (e.getMessage().contains("File does not exist")) {
                throw new FileNotFoundException("The given transactionlog file wasn't found at " + p);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            log.warn(FSHDFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting), (Throwable)e);
        }
        return recovered;
    }

    private static String getLogMessageDetail(int nbAttempt, Path p, long startWaiting) {
        return "attempt=" + nbAttempt + " on file=" + p + " after " + TimeUnit.MILLISECONDS.convert(System.nanoTime() - startWaiting, TimeUnit.NANOSECONDS) + "ms";
    }

    public static interface CallerInfo {
        public boolean isCallerClosed();
    }
}

